<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use App\Mixins\Certificate\MakeCertificate;
use App\Models\Certificate;
use App\Models\CertificateTemplate;
use App\Models\Quiz;
use App\Models\QuizzesResult;
use App\Models\Reward;
use App\Models\RewardAccounting;
use App\Models\Sale;
use App\Models\Webinar;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image;

//bdoor add this
use Illuminate\Support\Facades\Storage;

class CertificateController extends Controller
{

    //bdoor add this
// public function saveImage(Request $request)
// {
//     $imageData = $request->input('image'); // base64 data
//     $certificateId = $request->input('certificate_id');

//     if (!$imageData || !$certificateId) {
//         return response()->json(['status' => false, 'message' => 'Missing data']);
//     }

//     try {
//         $imageData = explode(',', $imageData)[1]; // remove "data:image/png;base64,"
//         $imageBinary = base64_decode($imageData);

//         $fileName = "certificate_{$certificateId}.png";
//         $filePath = "store/certificates/{$fileName}";

//         Storage::disk('public')->put($filePath, $imageBinary);

//         Certificate::where('id', operator: $certificateId)->update([
//             'image_path' => 'storage/' . $filePath
//         ]);

//         return response()->json([
//             'status' => 'success',
//             'url' => asset('storage/' . $filePath)
//         ]);
//     } catch (\Exception $e) {
//         return response()->json(['status' => false, 'message' => $e->getMessage()]);
//     }
// }

public function saveImage(Request $request): JsonResponse
{
    $imageData = $request->input('image');
    $certificateId = $request->input('certificate_id');

    if (!$imageData || !$certificateId) {
        return response()->json(['status' => false, 'message' => 'Missing data']);
    }

    try {
        $imageData = explode(',', $imageData)[1];
        $imageBinary = base64_decode($imageData);

        // Ensure the directory exists
        if (!file_exists(public_path('store/certificates'))) {
            mkdir(public_path('store/certificates'), 0755, true);
        }

        $filePath = public_path("store/certificates/certificate_{$certificateId}.png");

        file_put_contents($filePath, $imageBinary);

        Certificate::where('id', $certificateId)->update([
            'image_path' => "store/certificates/certificate_{$certificateId}.png"
        ]);

        return response()->json([
            'status' => true,
            'url' => asset("store/certificates/certificate_{$certificateId}.png")
        ]);
    } catch (\Exception $e) {
        return response()->json(['status' => false, 'message' => $e->getMessage()]);
    }
}
//bdoor end this

public function lists(Request $request)
    {
        $this->authorize("panel_certificates_lists");

        $user = auth()->user();

        if (!$user->isUser()) {
            $query = Quiz::where('creator_id', $user->id)
                ->where('status', Quiz::ACTIVE);

            $activeQuizzes = $query->count();

            $quizzesIds = $query->pluck('id')->toArray();

            $achievementsCount = Certificate::whereIn('quiz_id', $quizzesIds)->count();

            $quizResultQuery = QuizzesResult::whereIn('quiz_id', $quizzesIds);
            $failedResults = deepClone($quizResultQuery)->where('status', QuizzesResult::$failed)->count();
            $avgGrade = deepClone($quizResultQuery)->where('status', QuizzesResult::$passed)->avg('user_grade');

            $userAllQuizzes = deepClone($query)->get();

            $query = $this->quizFilters(deepClone($query), $request);

            $quizzes = $query->with([
                'webinar',
                'certificates',
                'quizResults' => function ($query) {
                    $query->orderBy('id', 'desc');
                },
            ])->paginate(10);

            foreach ($quizzes as $quiz) {
                $quizResults = $quiz->quizResults;

                $quiz->avg_grade = $quizResults->where('status', QuizzesResult::$passed)->avg('user_grade');
            }

            $userWebinars = Webinar::select('id')
                ->where(function ($query) use ($user) {
                    $query->where('creator_id', $user->id)
                        ->orWhere('teacher_id', $user->id);
                })
                ->where('status', 'active')
                ->get();

            $data = [
                'pageTitle' => trans('quiz.certificates_lists'),
                'quizzes' => $quizzes,
                'activeQuizzes' => $activeQuizzes,
                'achievementsCount' => $achievementsCount,
                'avgGrade' => round($avgGrade, 2),
                'failedResults' => $failedResults,
                'userWebinars' => $userWebinars,
                'userAllQuizzes' => $userAllQuizzes,
            ];

            return view('web.default.panel.certificates.list', $data);
        }

        abort(404);
    }

    public function achievements(Request $request)
    {
        $this->authorize("panel_certificates_achievements");

        $user = auth()->user();

        $results = QuizzesResult::where('user_id', $user->id);

        $failedQuizzes = deepClone($results)->where('status', QuizzesResult::$failed)->count();
        $avgGrades = deepClone($results)->where('status', QuizzesResult::$passed)->avg('user_grade');

        if (!empty($request->get('grade'))) {
            $results->where('user_grade', $request->get('grade'));
        }

        $quizzesIds = $results->where('status', QuizzesResult::$passed)
            ->pluck('quiz_id')
            ->toArray();
        $quizzesIds = array_unique($quizzesIds);

        $query = Quiz::query()->whereIn('id', $quizzesIds)
            ->where('status', Quiz::ACTIVE);

        $certificatesCount = deepClone($query)->count();

        $userAllQuizzes = deepClone($query)->get();

        $query = $this->quizFilters(deepClone($query), $request);

        $quizzes = $query
            ->whereHas('quizResults', function ($query) {
                $query->where('status', QuizzesResult::$passed);
            })
            ->with([
                'webinar',
                'quizResults' => function ($query) use ($user) {
                    $query->where('status', QuizzesResult::$passed);
                    $query->where('user_id', $user->id);
                    $query->orderBy('created_at', 'desc');
                },
            ])->paginate(10);


        foreach ($quizzes as $quiz) {
            $canDownloadCertificate = false;

            $userQuizDone = $quiz->quizResults;

            if (count($userQuizDone)) {
                $quiz->result = $userQuizDone->first();

                if ($quiz->result->status == 'passed') {
                    $canDownloadCertificate = true;
                }
            }

            $quiz->can_download_certificate = $canDownloadCertificate;
        }

        $webinarsIds = $user->getPurchasedCoursesIds();
        $userWebinars = Webinar::select('id')
            ->whereIn('id', $webinarsIds)
            ->where('status', 'active')
            ->get();

        $data = [
            'pageTitle' => trans('quiz.my_achievements_lists'),
            'quizzes' => $quizzes,
            'failedQuizzes' => $failedQuizzes,
            'avgGrades' => round($avgGrades, 2),
            'certificatesCount' => $certificatesCount,
            'userWebinars' => $userWebinars,
            'userAllQuizzes' => $userAllQuizzes,
        ];

        return view(getTemplate() . '.panel.certificates.achievements', $data);
    }

    private function quizFilters($query, $request)
    {
        $from = $request->get('from');
        $to = $request->get('to');
        $webinar_id = $request->get('webinar_id');
        $quiz_id = $request->get('quiz_id');
        $grade = $request->get('grade');


        fromAndToDateFilter($from, $to, $query, 'created_at');

        if (!empty($webinar_id)) {
            $query->where('webinar_id', $webinar_id);
        }

        if (!empty($quiz_id)) {
            $query->where('id', $quiz_id);
        }

        return $query;
    }

    public function makeCertificate($quizResultId)
    {
        $user = auth()->user();

        $makeCertificate = new MakeCertificate();

        $quizResult = QuizzesResult::where('id', $quizResultId)
            ->where('user_id', $user->id)
            ->where('status', QuizzesResult::$passed)
            ->with(['quiz' => function ($query) {
                $query->with(['webinar']);
            }])
            ->first();

        if (!empty($quizResult)) {
            return $makeCertificate->makeQuizCertificate($quizResult);
        }

        abort(404);
    }

    /**
     * Test method to demonstrate HTML2Canvas certificate generation
     */
    public function testCertificateGeneration()
    {
        $user = auth()->user();
        
        // Create a sample certificate template
        $template = CertificateTemplate::where('status', 'publish')
            ->where('type', 'quiz')
            ->first();

        if (empty($template)) {
            // Create a simple test template if none exists
            $body = "
                <div style='text-align: center; padding: 50px;'>
                    <h1 style='color: #007bff; font-size: 32px; margin-bottom: 30px;'>Certificate of Completion</h1>
                    <p style='font-size: 18px; margin-bottom: 20px;'>This is to certify that</p>
                    <h2 style='color: #333; font-size: 24px; margin-bottom: 30px;'>[student_name]</h2>
                    <p style='font-size: 16px; margin-bottom: 20px;'>has successfully completed the course</p>
                    <h3 style='color: #007bff; font-size: 20px; margin-bottom: 30px;'>[course_name]</h3>
                    <p style='font-size: 14px; color: #666;'>Certificate ID: [certificate_id]</p>
                    <p style='font-size: 14px; color: #666;'>Issued on: [date]</p>
                </div>
            ";
        } else {
            $body = $template->body;
        }

        // Replace placeholders with sample data
        $body = str_replace('[student_name]', $user->full_name, $body);
        $body = str_replace('[course_name]', 'Test Course - HTML2Canvas Demo', $body);
        $body = str_replace('[certificate_id]', 'TEST-' . time(), $body);
        $body = str_replace('[date]', date('F j, Y'), $body);

        $data = [
            'body' => $body,
            'certificate' => (object)['id' => 'test-' . time()]
        ];

        return view('admin.certificates.create_template.show_certificate_html2canvas', $data);
    }
}
