(function ($) {
    "use strict";

    // Initialize navbar immediately
    function initializeNavbar() {
        var navbar = document.getElementById("navbar");
        var navbarVacuum = document.getElementById("navbarVacuum");
        
        if (navbar && navbarVacuum) {
            // Set the vacuum height immediately to prevent content jump
            navbarVacuum.style.height = navbar.offsetHeight + 'px';
        }
    }

    // Run immediately if DOM is already loaded
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initializeNavbar);
    } else {
        initializeNavbar();
    }

    // Also run on window load as a fallback
    window.addEventListener('load', initializeNavbar);

    $('body').on('click', '.xs-categories-toggle', function (e) {
        if (e.target !== this) return;

        if ($(this).hasClass('show-items')) {
            $(this).removeClass('show-items');
        } else {
            $(this).addClass('show-items');
        }
    });

    $('body').on('click', this, function (event) {
        if (!$(event.target).closest('.menu-category').length) {
            $(".xs-categories-toggle").removeClass('show-items');
        }
    });

    $('body').on('click', '.cat-dropdown-menu > li', function (e) {
        const $this = $(this);

        const hasOpen = $this.hasClass('show-sub-menu');

        $('.cat-dropdown-menu > li').each((key, item) => {
            $(item).removeClass('show-sub-menu')
        });

        if (hasOpen) {
            $this.removeClass('show-sub-menu');
        } else {
            $this.addClass('show-sub-menu');
        }
    });

    $('body').on('click', '#navbarClose', function (e) {
        $('#navbarContent').removeClass('show');
    });

    $('body').on('click', '#navbarToggle', function (e) {
        $('#navbarContent').addClass('show');
    });

    // Initialize navbar functionality after DOM is ready
    $(document).ready(function() {
        var navbar = document.getElementById("navbar");
        var navbarVacuum = document.getElementById("navbarVacuum");
        
        // Set the vacuum height immediately to prevent content jump
        if (navbar && navbarVacuum) {
            // Since navbar is already fixed-top, we just need to set the vacuum height
            navbarVacuum.style.height = navbar.offsetHeight + 'px';
        }

        function myFunction() {
            if (!navbar || !navbarVacuum) return;
            
            // Keep the vacuum height consistent with navbar height
            navbarVacuum.style.height = navbar.offsetHeight + 'px';
            
            // Handle scroll behavior
            if (window.pageYOffset > 50) {
                navbar.classList.add("scrolled");
            } else {
                navbar.classList.remove("scrolled");
            }
        }

        window.onscroll = function () {
            myFunction()
        };
        
        // Also call on load to set initial state
        myFunction();
    });

})(jQuery);