@php
    if (empty($authUser) and auth()->check()) {
        $authUser = auth()->user();
    }

    $navBtnUrl = null;
    $navBtnText = null;

    if(request()->is('forums*')) {
        $navBtnUrl = '/forums/create-topic';
        $navBtnText = trans('update.create_new_topic');
    } else {
        $navbarButton = getNavbarButton(!empty($authUser) ? $authUser->role_id : null, empty($authUser));

        if (!empty($navbarButton)) {
            $navBtnUrl = $navbarButton->url;
            $navBtnText = $navbarButton->title;
        }
    }
@endphp

@php
    $userLanguages = !empty($generalSettings['site_language']) ? [$generalSettings['site_language'] => getLanguages($generalSettings['site_language'])] : [];

    if (!empty($generalSettings['user_languages']) and is_array($generalSettings['user_languages'])) {
        $userLanguages = getLanguages($generalSettings['user_languages']);
    }

    $localLanguage = [];

    foreach($userLanguages as $key => $userLanguage) {
        $localLanguage[localeToCountryCode($key)] = $userLanguage;
    }

@endphp

<style>
#navbarVacuum {
    height: 80px;
    min-height: 80px;
    display: block;
}
.navbar {
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
}
.navbar.scrolled {
    background-color: #ffffff !important;
    box-shadow: 0 3px 10px 0 rgba(0, 0, 0, 0.1);
}
.navbar.scrolled .nav-link {
    color: rgb(13, 54, 71) !important;
}
.navbar.scrolled .navbar-brand img {
    display: none;
}
.navbar.scrolled .navbar-brand .logo-scrolled {
    display: block !important;
}
.navbar .navbar-brand .logo-scrolled {
    display: none;
}
</style>
<div id="navbarVacuum" style="height: 80px;"></div>
<script>
// Set vacuum height immediately to prevent content jump
(function() {
    var navbar = document.getElementById("navbar");
    var navbarVacuum = document.getElementById("navbarVacuum");
    if (navbar && navbarVacuum) {
        navbarVacuum.style.height = navbar.offsetHeight + 'px';
    }
})();

// Add scroll behavior debugging
window.addEventListener('scroll', function() {
    var navbar = document.getElementById("navbar");
    if (navbar) {
        if (window.pageYOffset > 50) {
            navbar.classList.add("scrolled");
            console.log("Navbar scrolled - class added");
        } else {
            navbar.classList.remove("scrolled");
            console.log("Navbar not scrolled - class removed");
        }
    }
});
</script>
<nav id="navbar" class="navbar navbar-expand-lg navbar-light fixed-top">
    <div class="{{ (!empty($isPanel) and $isPanel) ? 'container-fluid' : 'container'}}">
        <div class="d-flex align-items-center justify-content-between w-100">

            <a class="navbar-brand navbar-order d-flex align-items-center justify-content-center mr-0 {{ (empty($navBtnUrl) and empty($navBtnText)) ? 'ml-auto' : '' }}" href="/">
                @if(!empty($generalSettings['logo']))
                    <img src="{{ $generalSettings['logo'] }}" class="img-cover" alt="site logo">
                @endif
                <img src="/store/1/NEFT-LOGO2 copy.png" class="img-cover logo-scrolled" alt="site logo scrolled">
            </a>

            <button class="navbar-toggler navbar-order" type="button" id="navbarToggle">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="mx-lg-30 d-none d-lg-flex flex-grow-1 navbar-toggle-content " id="navbarContent">
                <div class="navbar-toggle-header text-right d-lg-none">
                    <button class="btn-transparent" id="navbarClose">
                        <i data-feather="x" width="32" height="32"></i>
                    </button>
                </div>

                <ul class="navbar-nav mr-auto d-flex align-items-center">

                    @if(!empty($authUser) and $authUser->isOrganization() and !empty($authUser->organization) and !empty($authUser->organization->logo))
                        <li class="mr-lg-25">
                            <a href="{{ $authUser->getProfileUrl() }}" class="d-flex align-items-center">
                                <img src="{{ $authUser->organization->logo }}" class="rounded-circle mr-10" alt="{{ $authUser->organization->full_name }} logo" width="32" height="32">
                                {{ $authUser->organization->full_name }}
                            </a>
                        </li>
                    @endif
<!-- @if(!empty($categories) and count($categories))
...
<li class="mr-lg-25">
    <div class="menu-category">
        <ul>
            <li class="cursor-pointer user-select-none d-flex xs-categories-toggle js-toggle-category-menu">
                <i data-feather="grid" width="20" height="20" class="mr-10 d-none d-lg-block"></i>
                {{ trans('categories.categories') }}

                <ul class="cat-dropdown-menu d-none">
                    @foreach($categories as $category)
                        <li>
                            <a href="{{ $category->getUrl() }}" class="{{ (!empty($category->subCategories) and count($category->subCategories)) ? 'js-has-subcategory' : '' }}">
                                <div class="d-flex align-items-center">
                                    @if(!empty($category->icon))
                                        <img src="{{ $category->icon }}" class="cat-dropdown-menu-icon mr-10" alt="{{ $category->title }} icon">
                                    @endif

                                    {{ $category->title }}
                                </div>

                                @if(!empty($category->subCategories) and count($category->subCategories))
                                    <i data-feather="chevron-right" width="20" height="20" class="d-none d-lg-inline-block ml-10"></i>
                                    <i data-feather="chevron-down" width="20" height="20" class="d-inline-block d-lg-none"></i>
                                @endif
                            </a>

                            @if(!empty($category->subCategories) and count($category->subCategories))
                                <ul class="sub-menu" data-simplebar @if((!empty($isRtl) and $isRtl)) data-simplebar-direction="rtl" @endif>
                                    @foreach($category->subCategories as $subCategory)
                                        <li>
                                            <a href="{{ $subCategory->getUrl() }}">
                                                @if(!empty($subCategory->icon))
                                                    <img src="{{ $subCategory->icon }}" class="cat-dropdown-menu-icon mr-10" alt="{{ $subCategory->title }} icon">
                                                @endif

                                                {{ $subCategory->title }}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </li>
                    @endforeach
                </ul>
            </li>
        </ul>
    </div>
</li>
@endif -->
                    @if(!empty($navbarPages) and count($navbarPages))
                        @foreach($navbarPages as $navbarPage)
                            <li class="nav-item">
                                <a class="nav-link" href="{{ $navbarPage['link'] }}">{{ $navbarPage['title'] }}</a>
                            </li>
                        @endforeach
                    @endif
                </ul>
            </div>

            <div class="nav-icons-or-start-live navbar-order d-flex align-items-center justify-content-end">

                @if(!empty($navBtnUrl))
                    <a href="{{ $navBtnUrl }}" class="d-none d-lg-flex btn btn-sm btn-primary nav-start-a-live-btn">
                        {{ $navBtnText }}
                    </a>

                    <a href="{{ $navBtnUrl }}" class="d-flex d-lg-none text-primary nav-start-a-live-btn font-14">
                        {{ $navBtnText }}
                    </a>
                @endif

                @if(!empty($isPanel))
                    @if($authUser->checkAccessToAIContentFeature())
                        <div class="js-show-ai-content-drawer show-ai-content-drawer-btn d-flex-center mr-40">
                            <div class="d-flex-center size-32 rounded-circle bg-white">
                                <img src="/assets/default/img/ai/ai-chip.svg" alt="ai" class="" width="16px" height="16px">
                            </div>
                            <span class="ml-5 font-weight-500 text-secondary font-14 d-none d-lg-block">{{ trans('update.ai_content') }}</span>
                        </div>
                    @endif
                @endif

                <div class="d-none nav-notify-cart-dropdown top-navbar">
                    @include('web.default.includes.shopping-cart-dropdwon')

                    <div class="border-left mx-15"></div>

                    @include('web.default.includes.notification-dropdown')
                </div>

            </div>
        </div>
    </div>

                @if(!empty($localLanguage) and count($localLanguage) > 1)
                    <form action="/locale" method="post" class="mr-15 mx-md-20">
                        {{ csrf_field() }}

                        <input type="hidden" name="locale">

                        @if(!empty($previousUrl))
                            <input type="hidden" name="previous_url" value="{{ $previousUrl }}">
                        @endif

                        <div class="language-select">
                            <div id="localItems"
                                 data-selected-country="{{ localeToCountryCode(mb_strtoupper(app()->getLocale())) }}"
                                 data-countries='{{ json_encode($localLanguage) }}'
                            ></div>
                        </div>
                    </form>
                @else
                    <div class="mr-15 mx-md-20"></div>
                @endif

</nav>

@push('scripts_bottom')
    <script src="/assets/default/js/parts/navbar.min.js"></script>

@endpush
