<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Panel\CertificateController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::group(['prefix' => '/development'], function () {

    // Certificate image saving route
    Route::post('/certificates/save-image', [CertificateController::class, 'saveImage'])->name('save.certificate.image');        

    // Mobile app certificate routes
    Route::group(['prefix' => 'certificates', 'namespace' => 'Web', 'middleware' => 'api.auth'], function () {
        Route::get('/generate-image', 'CertificatesController@generateCertificateImage');
        Route::get('/get-html', 'CertificatesController@getCertificateHtml');
        Route::get('/list', 'CertificatesController@getCertificates');
    });

    Route::get('/', function () {
        return 'api test';
    });

    Route::middleware('api') ->group(base_path('routes/api/auth.php'));

    Route::namespace('Web')->group(base_path('routes/api/guest.php'));

    Route::prefix('panel')->namespace('Panel')->group(base_path('routes/api/user.php'));

    Route::group(['namespace' => 'Config', 'middleware' => []], function () {
        Route::get('/config', ['uses' => 'ConfigController@list']);
        Route::get('/config/register/{type}', ['uses' => 'ConfigController@getRegisterConfig']);
    });

    Route::prefix('instructor')->middleware(['api.auth', 'api.level-access:teacher'])->namespace('Instructor')->group(base_path('routes/api/instructor.php'));

});
