<?php
    if (empty($authUser) and auth()->check()) {
        $authUser = auth()->user();
    }

    $navBtnUrl = null;
    $navBtnText = null;

    if(request()->is('forums*')) {
        $navBtnUrl = '/forums/create-topic';
        $navBtnText = trans('update.create_new_topic');
    } else {
        $navbarButton = getNavbarButton(!empty($authUser) ? $authUser->role_id : null, empty($authUser));

        if (!empty($navbarButton)) {
            $navBtnUrl = $navbarButton->url;
            $navBtnText = $navbarButton->title;
        }
    }
?>

<?php
    $userLanguages = !empty($generalSettings['site_language']) ? [$generalSettings['site_language'] => getLanguages($generalSettings['site_language'])] : [];

    if (!empty($generalSettings['user_languages']) and is_array($generalSettings['user_languages'])) {
        $userLanguages = getLanguages($generalSettings['user_languages']);
    }

    $localLanguage = [];

    foreach($userLanguages as $key => $userLanguage) {
        $localLanguage[localeToCountryCode($key)] = $userLanguage;
    }

?>

<style>
#navbarVacuum {
    height: 80px;
    min-height: 80px;
    display: block;
}
.navbar {
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
}
.navbar.scrolled {
    background-color: #ffffff !important;
    box-shadow: 0 3px 10px 0 rgba(0, 0, 0, 0.1);
}
.navbar.scrolled .nav-link {
    color: rgb(13, 54, 71) !important;
}
.navbar.scrolled .navbar-brand img {
    display: none;
}
.navbar.scrolled .navbar-brand .logo-scrolled {
    display: block !important;
}
.navbar .navbar-brand .logo-scrolled {
    display: none;
}
</style>
<div id="navbarVacuum" style="height: 80px;"></div>
<script>
// Set vacuum height immediately to prevent content jump
(function() {
    var navbar = document.getElementById("navbar");
    var navbarVacuum = document.getElementById("navbarVacuum");
    if (navbar && navbarVacuum) {
        navbarVacuum.style.height = navbar.offsetHeight + 'px';
    }
})();

// Add scroll behavior debugging
window.addEventListener('scroll', function() {
    var navbar = document.getElementById("navbar");
    if (navbar) {
        if (window.pageYOffset > 50) {
            navbar.classList.add("scrolled");
            console.log("Navbar scrolled - class added");
        } else {
            navbar.classList.remove("scrolled");
            console.log("Navbar not scrolled - class removed");
        }
    }
});
</script>
<nav id="navbar" class="navbar navbar-expand-lg navbar-light fixed-top">
    <div class="<?php echo e((!empty($isPanel) and $isPanel) ? 'container-fluid' : 'container'); ?>">
        <div class="d-flex align-items-center justify-content-between w-100">

            <a class="navbar-brand navbar-order d-flex align-items-center justify-content-center mr-0 <?php echo e((empty($navBtnUrl) and empty($navBtnText)) ? 'ml-auto' : ''); ?>" href="/">
                <?php if(!empty($generalSettings['logo'])): ?>
                    <img src="<?php echo e($generalSettings['logo']); ?>" class="img-cover" alt="site logo">
                <?php endif; ?>
                <img src="/store/1/NEFT-LOGO2 copy.png" class="img-cover logo-scrolled" alt="site logo scrolled">
            </a>

            <button class="navbar-toggler navbar-order" type="button" id="navbarToggle">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="mx-lg-30 d-none d-lg-flex flex-grow-1 navbar-toggle-content " id="navbarContent">
                <div class="navbar-toggle-header text-right d-lg-none">
                    <button class="btn-transparent" id="navbarClose">
                        <i data-feather="x" width="32" height="32"></i>
                    </button>
                </div>

                <ul class="navbar-nav mr-auto d-flex align-items-center">

                    <?php if(!empty($authUser) and $authUser->isOrganization() and !empty($authUser->organization) and !empty($authUser->organization->logo)): ?>
                        <li class="mr-lg-25">
                            <a href="<?php echo e($authUser->getProfileUrl()); ?>" class="d-flex align-items-center">
                                <img src="<?php echo e($authUser->organization->logo); ?>" class="rounded-circle mr-10" alt="<?php echo e($authUser->organization->full_name); ?> logo" width="32" height="32">
                                <?php echo e($authUser->organization->full_name); ?>

                            </a>
                        </li>
                    <?php endif; ?>
<!-- <?php if(!empty($categories) and count($categories)): ?>
...
<li class="mr-lg-25">
    <div class="menu-category">
        <ul>
            <li class="cursor-pointer user-select-none d-flex xs-categories-toggle js-toggle-category-menu">
                <i data-feather="grid" width="20" height="20" class="mr-10 d-none d-lg-block"></i>
                <?php echo e(trans('categories.categories')); ?>


                <ul class="cat-dropdown-menu d-none">
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <a href="<?php echo e($category->getUrl()); ?>" class="<?php echo e((!empty($category->subCategories) and count($category->subCategories)) ? 'js-has-subcategory' : ''); ?>">
                                <div class="d-flex align-items-center">
                                    <?php if(!empty($category->icon)): ?>
                                        <img src="<?php echo e($category->icon); ?>" class="cat-dropdown-menu-icon mr-10" alt="<?php echo e($category->title); ?> icon">
                                    <?php endif; ?>

                                    <?php echo e($category->title); ?>

                                </div>

                                <?php if(!empty($category->subCategories) and count($category->subCategories)): ?>
                                    <i data-feather="chevron-right" width="20" height="20" class="d-none d-lg-inline-block ml-10"></i>
                                    <i data-feather="chevron-down" width="20" height="20" class="d-inline-block d-lg-none"></i>
                                <?php endif; ?>
                            </a>

                            <?php if(!empty($category->subCategories) and count($category->subCategories)): ?>
                                <ul class="sub-menu" data-simplebar <?php if((!empty($isRtl) and $isRtl)): ?> data-simplebar-direction="rtl" <?php endif; ?>>
                                    <?php $__currentLoopData = $category->subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e($subCategory->getUrl()); ?>">
                                                <?php if(!empty($subCategory->icon)): ?>
                                                    <img src="<?php echo e($subCategory->icon); ?>" class="cat-dropdown-menu-icon mr-10" alt="<?php echo e($subCategory->title); ?> icon">
                                                <?php endif; ?>

                                                <?php echo e($subCategory->title); ?>

                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </li>
        </ul>
    </div>
</li>
<?php endif; ?> -->
                    <?php if(!empty($navbarPages) and count($navbarPages)): ?>
                        <?php $__currentLoopData = $navbarPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $navbarPage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e($navbarPage['link']); ?>"><?php echo e($navbarPage['title']); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </ul>
            </div>

            <div class="nav-icons-or-start-live navbar-order d-flex align-items-center justify-content-end">

                <?php if(!empty($navBtnUrl)): ?>
                    <a href="<?php echo e($navBtnUrl); ?>" class="d-none d-lg-flex btn btn-sm btn-primary nav-start-a-live-btn">
                        <?php echo e($navBtnText); ?>

                    </a>

                    <a href="<?php echo e($navBtnUrl); ?>" class="d-flex d-lg-none text-primary nav-start-a-live-btn font-14">
                        <?php echo e($navBtnText); ?>

                    </a>
                <?php endif; ?>

                <?php if(!empty($isPanel)): ?>
                    <?php if($authUser->checkAccessToAIContentFeature()): ?>
                        <div class="js-show-ai-content-drawer show-ai-content-drawer-btn d-flex-center mr-40">
                            <div class="d-flex-center size-32 rounded-circle bg-white">
                                <img src="/assets/default/img/ai/ai-chip.svg" alt="ai" class="" width="16px" height="16px">
                            </div>
                            <span class="ml-5 font-weight-500 text-secondary font-14 d-none d-lg-block"><?php echo e(trans('update.ai_content')); ?></span>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <div class="d-none nav-notify-cart-dropdown top-navbar">
                    <?php echo $__env->make('web.default.includes.shopping-cart-dropdwon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <div class="border-left mx-15"></div>

                    <?php echo $__env->make('web.default.includes.notification-dropdown', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>

            </div>
        </div>
    </div>

                <?php if(!empty($localLanguage) and count($localLanguage) > 1): ?>
                    <form action="/locale" method="post" class="mr-15 mx-md-20">
                        <?php echo e(csrf_field()); ?>


                        <input type="hidden" name="locale">

                        <?php if(!empty($previousUrl)): ?>
                            <input type="hidden" name="previous_url" value="<?php echo e($previousUrl); ?>">
                        <?php endif; ?>

                        <div class="language-select">
                            <div id="localItems"
                                 data-selected-country="<?php echo e(localeToCountryCode(mb_strtoupper(app()->getLocale()))); ?>"
                                 data-countries='<?php echo e(json_encode($localLanguage)); ?>'
                            ></div>
                        </div>
                    </form>
                <?php else: ?>
                    <div class="mr-15 mx-md-20"></div>
                <?php endif; ?>

</nav>

<?php $__env->startPush('scripts_bottom'); ?>
    <script src="/assets/default/js/parts/navbar.min.js"></script>

<?php $__env->stopPush(); ?>
<?php /**PATH /home/neftenergies/public_html/docroot.neft.sa/resources/views/web/default/includes/navbar.blade.php ENDPATH**/ ?>