<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class CleanupTempCertificates extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'certificates:cleanup {--days=1 : Delete files older than X days}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean up temporary certificate files';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $tempPath = storage_path('app/temp');
        $days = $this->option('days');
        $cutoffTime = time() - ($days * 24 * 60 * 60);
        
        $deletedCount = 0;
        $deletedSize = 0;

        if (!File::exists($tempPath)) {
            $this->info('Temp directory does not exist.');
            return 0;
        }

        $files = File::glob($tempPath . '/*.png');
        
        foreach ($files as $file) {
            if (File::lastModified($file) < $cutoffTime) {
                $size = File::size($file);
                File::delete($file);
                $deletedCount++;
                $deletedSize += $size;
                $this->line("Deleted: " . basename($file));
            }
        }

        $this->info("Cleanup completed: {$deletedCount} files deleted, " . 
                   number_format($deletedSize / 1024 / 1024, 2) . " MB freed.");

        return 0;
    }
} 