<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use function Matrix\trace;

class SendVerificationEmailCode extends Notification
{
    private $notifiable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($notifiable)
    {
        $this->notifiable = $notifiable;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        // Debug: Log email notification attempt
        \Log::info('Email notification being sent:', [
            'email' => $notifiable->email,
            'code' => $notifiable->code,
            'notifiable_type' => get_class($notifiable)
        ]);

        $generalSettings = getGeneralSettings();
        $subject = trans('auth.email_confirmation');

        $confirm = [
            'title' => $subject . ' ' . trans('auth.in') . ' ' . $generalSettings['site_name'],
            'message' => trans('auth.email_confirmation_template_body', ['email' => $notifiable->email, 'site' => $generalSettings['site_name']]),
            'code' => $notifiable->code
        ];

        try {
            $mailMessage = (new MailMessage)
                ->subject($subject)
                ->from(!empty($generalSettings['site_email']) ? $generalSettings['site_email'] : env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'))
                ->view('web.default.emails.confirmCode', [
                    'confirm' => $confirm,
                    'generalSettings' => $generalSettings
                ]);

            \Log::info('Email notification created successfully');
            return $mailMessage;
        } catch (\Exception $e) {
            \Log::error('Email notification creation failed:', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            throw $e;
        }
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
