<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCertificationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('certifications', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            
            $table->increments('Id');
            $table->string('neft_certificate_number')->nullable();
            $table->string('name')->nullable();
            $table->string('id_no')->nullable();
            $table->string('govt_id')->nullable();
            $table->string('company')->nullable();
            $table->string('course_name')->nullable();
            $table->date('actual_date')->nullable();
            $table->date('issue_date')->nullable();
            $table->date('expiration_date')->nullable();
            $table->integer('created_at')->nullable();
            $table->integer('updated_at')->nullable();
            
            $table->foreign('student_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('certifications');
    }
} 