<?php
require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

// Check navbar links in database
$navbarLinks = \App\Models\Setting::where('name', 'navbar_links')->first();

echo "=== NAVBAR LINKS DEBUG ===\n";
echo "Setting ID: " . $navbarLinks->id . "\n";
echo "Setting Name: " . $navbarLinks->name . "\n";
echo "Value Type: " . gettype($navbarLinks->value) . "\n";
echo "Value Content: " . print_r($navbarLinks->value, true) . "\n";

// Check translations
echo "\n=== TRANSLATIONS ===\n";
if (!empty($navbarLinks->translations)) {
    foreach ($navbarLinks->translations as $translation) {
        echo "Locale: " . $translation->locale . "\n";
        echo "Value: " . $translation->value . "\n";
        echo "---\n";
    }
} else {
    echo "No translations found\n";
}

// Check current locale
echo "\n=== CURRENT LOCALE ===\n";
echo "Current Locale: " . app()->getLocale() . "\n";
echo "Default Locale: " . getDefaultLocale() . "\n";

// Test getNavbarLinks function
echo "\n=== GETNAVBARLINKS FUNCTION ===\n";
$navbarPages = getNavbarLinks();
echo "Count: " . count($navbarPages) . "\n";
echo "Pages: " . print_r($navbarPages, true) . "\n";