(function ($) {
  "use strict";

  if (jQuery().summernote) {
    makeSummernote($('.summernote'), 400);
  }

  $('body').on('click', '#submitForm', function (e) {
    e.preventDefault();
    var $this = $(this);
    $this.addClass('loadingbar primary').prop('disabled', true);
    var $form = $this.closest('form');
    var action = $form.attr('action');
    var data = $form.serializeObject();
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-16 text-center text-dark-blue">' + noticeboard_success_send + '</h3>',
          showConfirmButton: false
        });
        setTimeout(function () {
          window.location.href = result.redirectTo ? result.redirectTo : '/panel/noticeboard';
        }, 2000);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;

      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
  $('body').on('click', '.js-view-message', function (e) {
    var $this = $(this);
    var card = $this.closest('.noticeboard-item');
    var title = card.find('.js-noticeboard-title').text();
    var time = card.find('.js-noticeboard-time').text();
    var message = card.find('.js-noticeboard-message').val();
    var modal = $('#noticeboardMessageModal');
    modal.find('.modal-title').text(title);
    modal.find('.modal-time').text(time);
    modal.find('.modal-message').html(message);
    Swal.fire({
      html: modal.html(),
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '30rem'
    });
  });
  $('body').on('change', '#typeSelect', function (e) {
    e.preventDefault();
    var value = this.value;
    var instructorCourses = $('#instructorCourses');
    instructorCourses.addClass('d-none');

    if (value === 'course') {
      instructorCourses.removeClass('d-none');
    }
  });
})(jQuery);
