/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*************************************************!*\
  !*** ./resources/js/panel/store/my-purchase.js ***!
  \*************************************************/
(function () {
  "use strict";

  $('body').on('click', '.js-view-tracking-code', function () {
    var $this = $(this);
    var saleId = $this.attr('data-sale-id');
    var orderId = $this.attr('data-product-order-id');
    var path = "/panel/store/purchases/".concat(saleId, "/getProductOrder/").concat(orderId);
    $.get(path, function (result) {
      if (result && result.order) {
        var html = "\n                    <div>\n                        <h3 class=\"section-title after-line font-20 text-dark-blue mb-25\">".concat(viewTrackingCodeModalTitleLang, "</h3>\n\n                        <div class=\"mt-15 w-100\">\n                            <div class=\"\">\n                                <span class=\"font-weight-500 mr-5\">").concat(trackingCodeLang, " :</span>\n                                <span class=\"font-14 text-gray\">").concat(result.order.tracking_code, "</span>\n                            </div>\n\n                            <div class=\"mt-15\">\n                                <span class=\"font-weight-500 mr-5\">").concat(addressLang, " :</span>\n                                <span class=\"font-14 text-gray\">").concat(result.order.address, "</span>\n                            </div>\n                        </div>\n\n                        <div class=\"mt-30 d-flex align-items-center justify-content-end\">\n                            ").concat(result.shipping_tracking_url && result.shipping_tracking_url !== '' && result.shipping_tracking_url !== 'null' ? "\n                                            <div class=\"mr-20\">\n                                                <a href=\"".concat(result.shipping_tracking_url, "\" class=\"btn btn-primary btn-sm\">").concat(shippingTrackingUrlLang, "</a>\n                                            </div>\n                                           ") : '', "\n\n                            <button type=\"button\" class=\"btn btn-danger btn-sm close-swl\">").concat(closeLang, "</button>\n                        </div>\n                    </div>\n                ");
        Swal.fire({
          html: html,
          showCancelButton: false,
          showConfirmButton: false,
          customClass: {
            content: 'p-0 text-left'
          },
          width: '40rem'
        });
      }
    });
  });
  $('body').on('click', '.js-got-the-parcel', function () {
    var $this = $(this);
    var saleId = $this.attr('data-sale-id');
    var orderId = $this.attr('data-product-order-id');
    var path = "/panel/store/purchases/".concat(saleId, "/productOrder/").concat(orderId, "/setGotTheParcel");
    var html = "\n                    <div>\n                        <h3 class=\"section-title after-line font-20 text-dark-blue mb-25\">".concat(gotTheParcelLang, "</h3>\n\n                        <div class=\"mt-15 w-100\">\n                            <p class=\"\">").concat(gotTheParcelConfirmTextLang, "</p>\n                        </div>\n\n                        <div class=\"mt-30 d-flex align-items-center justify-content-end\">\n                            <button type=\"button\" id=\"saveGotTheParcel\" data-action=\"").concat(path, "\" class=\"btn btn-sm btn-primary\">").concat(confirmLang, "</button>\n                            <button type=\"button\" class=\"btn btn-danger btn-sm close-swl ml-10\">").concat(closeLang, "</button>\n                        </div>\n                    </div>\n                ");
    Swal.fire({
      html: html,
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '32rem'
    });
  });
  $('body').on('click', '#saveGotTheParcel', function (e) {
    e.preventDefault();
    var $this = $(this);
    var path = $this.attr('data-action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    $.get(path, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue py-25">' + gotTheParcelSaveSuccessLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      } else {
        Swal.fire({
          icon: 'error',
          html: '<h3 class="font-20 text-center text-dark-blue py-25">' + gotTheParcelSaveErrorLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
      }
    });
  });
  $('body').on('click', '.js-show-product-files', function (e) {
    e.preventDefault();
    var path = $(this).attr('href');
    loadingSwl();
    $.get(path, function (result) {
      if (result && result.code === 200) {
        var html = "\n                    <div>\n                        <h3 class=\"section-title after-line font-20 text-dark-blue mb-25\">".concat(filesLang, "</h3>\n\n                        <div class=\"mt-15 w-100\">").concat(result.html, "</div>\n\n                        <div class=\"mt-30 d-flex align-items-center justify-content-end\">\n                            <button type=\"button\" class=\"btn btn-danger btn-sm close-swl ml-10\">").concat(closeLang, "</button>\n                        </div>\n                    </div>\n                ");
        Swal.fire({
          html: html,
          showCancelButton: false,
          showConfirmButton: false,
          customClass: {
            content: 'p-0 text-left'
          },
          width: '32rem',
          onOpen: function onOpen() {
            feather.replace();
          }
        });
      }
    });
  });
})(jQuery);
/******/ })()
;