(function ($) {
  "use strict";

  $('body').on('click', '#formSubmit', function (e) {
    e.preventDefault();
    var $this = $(this);
    $this.addClass('loadingbar primary').prop('disabled', true);
    var $form = $this.closest('form');
    var action = $form.attr('action');
    var data = $form.serializeObject();
    $.post(action, data, function (result) {
      if (result && result.code === 404) {
        Swal.fire({
          icon: 'error',
          html: '<h3 class="font-20 text-center text-dark-blue">' + certificateNotFound + '</h3>',
          showConfirmButton: true,
          showCancelButton: false,
          confirmButtonText: close,
          confirmButtonColor: '#f63c3c',
          dangerMode: true
        });
      } else if (result && result.code === 200) {
        var certificate = result.certificate;
        $('#certificateModal .modal-student').text(certificate.student);
        $('#certificateModal .modal-webinar').text(certificate.webinar_title);
        $('#certificateModal .modal-date').text(certificate.date);
        var modal = '<div id="validCertificateModal">';
        modal += $('#certificateModal').html();
        modal += '</div>';
        Swal.fire({
          html: modal,
          showCancelButton: false,
          showConfirmButton: false,
          customClass: {
            content: 'p-0 text-left'
          },
          width: '36rem'
        });
      }
    }).fail(function (err) {
      var errors = err.responseJSON;

      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    }).always(function () {
      refreshCaptcha();
      $this.removeClass('loadingbar primary').prop('disabled', false);
    });
  });
})(jQuery);
