(function ($) {
  "use strict";

  $('body').on('click', '.reply-comment', function (e) {
    e.preventDefault();
    var $this = $(this);
    var comment_card = $this.closest('.comments-card');
    var comment_id = comment_card.attr('data-id');
    var csrf = comment_card.attr('data-csrf');
    var address = comment_card.attr('data-address');
    var item_id = $('#commentItemId').val();
    var item_name = $('#commentItemName').val();
    var replyCommentHtml = '<form action="' + address + '" method="post" class="mt-30">\n' + '<input type="hidden" name="_token" value="' + csrf + '"/>\n' + '<input type="hidden" name="item_id" value="' + item_id + '"/>' + '<input type="hidden" name="item_name" value="' + item_name + '"/>' + '<input type="hidden" name="comment_id" value="' + comment_id + '"/>\n' + '<div class="form-group">\n' + '<textarea name="reply" id="" class="form-control" rows="10"></textarea>\n' + '</div>\n' + '<button type="submit" class="btn btn-primary btn-sm">' + replyLang + '</button>\n' + '<button type="button" class="btn btn-gray btn-sm ml-20 reply-close">' + closeLang + '</button>\n' + '</form>';
    comment_card.append(replyCommentHtml);
  });
  $('body').on('click', '.reply-close', function (e) {
    e.preventDefault();
    $(this).closest('form').remove();
  });
  $('body').on('click', '.report-comment', function (e) {
    e.preventDefault();
    var comment_id = $(this).attr('data-comment-id');
    var item_id = $('#commentItemId').val();
    var item_name = $('#commentItemName').val();
    var html = '<div id="reportModal">\n' + '    <h3 class="section-title after-line font-20 text-dark-blue mb-25">' + reportLang + '</h3>\n' + '\n' + '    <form action="/comments/' + comment_id + '/report" method="post">\n' + '         <input type="hidden" name="item_id" value="' + item_id + '"/>' + '         <input type="hidden" name="item_name" value="' + item_name + '"/>' + '        <div class="form-group">\n' + '            <label class="input-label">' + messageToReviewerLang + '</label>\n' + '            <textarea name="message" class="form-control" rows="6"></textarea>\n' + '            <div class="invalid-feedback"></div>\n' + '        </div>\n' + '\n' + '        <div class="mt-30 d-flex align-items-center justify-content-end">\n' + '            <button type="button" id="saveReport" class="btn btn-sm btn-primary">' + saveLang + '</button>\n' + '            <button type="button" class="btn btn-sm btn-danger ml-10 close-swl">' + closeLang + '</button>\n' + '        </div>\n' + '    </form>\n' + '</div>';
    Swal.fire({
      html: html,
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '30rem'
    });
  });
  $('body').on('click', '#saveReport', function (e) {
    var $this = $(this);
    var form = $('#reportModal form');
    var data = form.serializeObject();
    var action = form.attr('action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    form.find('input').removeClass('is-invalid');
    form.find('textarea').removeClass('is-invalid');
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue">' + reportSuccessLang + '</h3>',
          showConfirmButton: false
        });
        setTimeout(function () {
          window.location.reload();
        }, 2000);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;

      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
})(jQuery);
