/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!**********************************************!*\
  !*** ./resources/js/parts/content_delete.js ***!
  \**********************************************/
(function ($) {
  "use strict";

  function makeModalHtml(itemId, itemType) {
    return "<div class=\"custom-modal-body\">\n                <h2 class=\"section-title after-line\">".concat(deleteRequestLang, "</h2>\n\n                <div class=\"js-delete-content-form mt-20\" data-action=\"/panel/content-delete-request\">\n                    <input type=\"hidden\" name=\"item_id\" value=\"").concat(itemId, "\">\n                    <input type=\"hidden\" name=\"item_type\" value=\"").concat(itemType, "\">\n\n                    <div class=\"bg-gray200 rounded-sm text-gray p-10 font-14\">").concat(deleteRequestDescriptionLang, "</div>\n\n                    <div class=\"form-group mt-20\">\n                        <label class=\"input-label\">").concat(requestDetailsLang, "</label>\n                        <textarea name=\"description\" class=\"js-ajax-description form-control\" rows=\"5\"></textarea>\n                        <div class=\"invalid-feedback font-14\"></div>\n                    </div>\n\n                    <div class=\"d-flex align-items-center justify-content-end mt-3\">\n                        <button type=\"button\" class=\"js-send-delete-request btn btn-sm btn-primary\">").concat(sendRequestLang, "</button>\n                        <button type=\"button\" class=\"close-swl btn btn-sm btn-danger ml-2\">").concat(closeLang, "</button>\n                    </div>\n                </div>\n            </div>");
  }
  $('body').on('click', '.js-content-delete-action', function (e) {
    e.preventDefault();
    e.stopPropagation();
    var $this = $(this);
    var href = $this.attr('href');
    var itemId = $this.attr('data-item');
    var itemType = $this.attr('data-item-type');
    Swal.fire({
      html: makeModalHtml(itemId, itemType),
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '36rem'
    });
  });
  $('body').on('click', '.js-send-delete-request', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.js-delete-content-form');
    var data = serializeObjectByTag(form);
    var action = form.attr('data-action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    form.find('textarea').removeClass('is-invalid');
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        //window.location.reload();
        Swal.fire({
          icon: 'success',
          title: result.title,
          html: '<p class="font-16 text-center text-gray">' + result.msg + '</p>',
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 1500);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = form.find('.js-ajax-' + key);
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
})(jQuery);
/******/ })()
;