(function ($) {
  $('body').on('change', 'input[name="meeting_type"]', function () {
    var regionCard = $('#regionCard');

    if ($(this).val() === 'in_person') {
      regionCard.removeClass('d-none');
    } else {
      regionCard.addClass('d-none');
    }
  });
  $('body').on('change', 'input[name="flexible_date"]', function () {
    if (this.checked) {
      $('#dateTimeCard').addClass('d-none');
    } else {
      $('#dateTimeCard').removeClass('d-none');
    }
  });
  $(document).ready(function () {
    var $timeRange = $('#timeRange');

    if ($timeRange && $timeRange.length && jQuery().wRunner) {
      var minLimit = $timeRange.attr('data-minLimit');
      var maxLimit = $timeRange.attr('data-maxLimit');
      var minTimeEl = $timeRange.find('input[name="min_time"]');
      var maxTimeEl = $timeRange.find('input[name="max_time"]');
      var minValue = minTimeEl.val();
      var maxValue = maxTimeEl.val();
      var wtime = $timeRange.wRunner({
        type: 'range',
        limits: {
          minLimit: minLimit,
          maxLimit: maxLimit
        },
        rangeValue: {
          minValue: minValue,
          maxValue: maxValue
        },
        step: 1
      });
      wtime.onValueUpdate(function (values) {
        minTimeEl.val(values.minValue);
        maxTimeEl.val(values.maxValue);
      });
    }
  });
})(jQuery);
