(function ($) {
  "use strict";

  new Swiper('#bestRateInstructorsSwiper', {
    slidesPerView: 1,
    spaceBetween: 16,
    loop: false,
    autoplay: {
      delay: 5000,
      disableOnInteraction: false
    },
    pagination: {
      el: '.best-rate-swiper-pagination',
      clickable: true
    },
    breakpoints: {
      991: {
        slidesPerView: 3
      },
      660: {
        slidesPerView: 2
      }
    }
  });
  new Swiper('#topSaleInstructorsSwiper', {
    slidesPerView: 1,
    spaceBetween: 16,
    loop: false,
    autoplay: {
      delay: 5000,
      disableOnInteraction: false
    },
    pagination: {
      el: '.best-sale-swiper-pagination',
      clickable: true
    },
    breakpoints: {
      991: {
        slidesPerView: 3
      },
      660: {
        slidesPerView: 2
      }
    }
  });
  var loadMoreInstructors = {
    page: 1,
    has_more: true
  };
  $('body').on('click', '#loadMoreInstructors', function (e) {
    e.preventDefault();
    var $this = $(this);
    var role = $this.attr('data-page');
    var url = $this.attr('data-url');
    $this.addClass('loadingbar gray').prop('disabled', true);

    if (loadMoreInstructors.has_more) {
      getInstructors(loadMoreInstructors.page + 1, role, url);
    }
  });

  function getInstructors() {
    var page = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
    var role = arguments.length > 1 ? arguments[1] : undefined;
    var url = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    var $form = $('#filtersForm');
    var data = $form.serializeObject();
    data['page'] = page;
    $('#loadMoreInstructors').removeClass('d-none'); //

    var link = url !== null && url !== void 0 ? url : '/load_more/' + role;
    $.get(link, data, function (result) {
      if (result && result.html) {
        $('#instructorsList').append(result.html);

        if (page < result.last_page) {
          loadMoreInstructors = {
            page: page,
            has_more: true
          };
        } else {
          loadMoreInstructors = {
            page: page,
            has_more: false
          };
          $('#loadMoreInstructors').addClass('d-none');
        }
      }
    }).always(function () {
      $('#loadMoreInstructors').removeClass('loadingbar gray').prop('disabled', false);
      feather.replace();
    });
  }

  var timeOut = undefined;
  $('body').on('change', '#filtersForm input,#filtersForm select', function (e) {
    e.preventDefault();
    var $form = $('#filtersForm');
    loadMoreInstructors = {
      page: 1,
      has_more: true
    };

    if (timeOut !== undefined) {
      clearTimeout(timeOut);
    }

    timeOut = setTimeout(function () {
      $form.trigger('submit');
    }, 1000);
  });
})(jQuery);
