<html lang="fa">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>{{ $pageTitle ?? '' }}</title>

    <style>

        @font-face {
            font-family: 'fontFamily';
            src: url({{ public_path('/store/pdf_fonts/DejaVuSans.ttf') }}) format("truetype");
            font-weight: 400;
            font-style: normal;
        }

        html, body {
            background-image: url("{{ $image }}");
            background-repeat: no-repeat;
            background-size: cover;
            margin: 0;
            border: initial;
            border-radius: initial;
            page-break-after: always;
            font-size: 14px;
            font-weight: 400;
            font-family: 'fontFamily'
        }

        @page {
            size: A4;
            margin: 0;
        }

        * {
            box-sizing: border-box;
            font-family: 'fontFamily' !important;
        }
    </style>
</head>

<body id="app">
{!! $body !!}
</body>

<!-- 
bdoor start this

<body id="capture">
    {!! $body !!}

    <a class="download" download="certificate.png" style="display:none; margin:20px auto; text-align:center; padding:12px 15px; background:#028A0F; color:#fff; border-radius:5px; text-decoration:none;">Download Certificate</a>

    <script src="{{ asset('js/app.js') }}"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            html2canvas(document.getElementById('capture'), {
                allowTaint: true,
                useCORS: true,
                width: 750
            }).then(function (canvas) {
                document.getElementById('capture').appendChild(canvas);
                canvas.style.display = 'none';

                var dataUrl = canvas.toDataURL("image/png");
                var downloadBtn = document.querySelector('.download');
                downloadBtn.href = dataUrl;
                downloadBtn.style.display = 'inline-block';
                downloadBtn.textContent = 'Download Certificate';

                fetch('{{ route("save.certificate.image") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({
                        image: dataUrl,
                        certificate_id: '{{ $certificate->id ?? '' }}'
                    })
                })
                .then(response => response.json())
                .then(data => {
                    console.log("📥 Certificate saved:", data);
                })
                .catch(error => {
                    console.error("❌ Error saving certificate:", error);
                });
            });
        });
    </script>
</body>

</html> 

bdoor end this
-->
