<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "=====================================\n";
echo "DATABASE TABLE STRUCTURE\n";
echo "=====================================\n\n";

// Show settings table
echo "📊 TABLE: `settings`\n";
echo "─────────────────────────────────────\n";
$setting = DB::table('settings')->where('name', 'home_hero')->first();
echo "id: " . $setting->id . "\n";
echo "name: " . $setting->name . "\n";
echo "page: " . $setting->page . "\n";
echo "updated_at: " . $setting->updated_at . "\n";
echo "\nNote: The 'value' column was moved to 'setting_translations' table\n\n";

// Show setting_translations table
echo "📊 TABLE: `setting_translations`\n";
echo "─────────────────────────────────────\n";
$translations = DB::table('setting_translations')
    ->where('setting_id', $setting->id)
    ->orderBy('locale')
    ->get();

foreach ($translations as $translation) {
    echo "\nRecord ID: " . $translation->id . "\n";
    echo "setting_id: " . $translation->setting_id . " (references settings.id)\n";
    echo "locale: " . $translation->locale . "\n";
    echo "value: " . substr($translation->value, 0, 100) . "...\n";
    
    $value = json_decode($translation->value, true);
    echo "\nDecoded JSON:\n";
    echo "  - title: " . ($value['title'] ?? 'N/A') . "\n";
    echo "  - hero_background: " . ($value['hero_background'] ?? 'N/A') . "\n";
    echo "  - is_video_background: " . ($value['is_video_background'] ?? 'NOT SET') . "\n";
    echo "─────────────────────────────────────\n";
}

echo "\n\n=====================================\n";
echo "WHERE THE FIX WAS APPLIED\n";
echo "=====================================\n";
echo "Table: setting_translations\n";
echo "Record: WHERE setting_id = {$setting->id} AND locale = 'ar'\n";
echo "Field Modified: 'value' JSON field\n";
echo "Change: Added 'is_video_background' => 1\n";
