<?php
    $socials = getSocials();
    if (!empty($socials) and count($socials)) {
        $socials = collect($socials)->sortBy('order')->toArray();
    }

    $footerColumns = getFooterColumns();
?>

<!-- Location Map Section - Above Footer -->
<div class="location-map-section" style="background: #ffffff; padding: 0; margin: 0; width: 100%;">
    <div class="map-wrapper" style="position: relative; width: 100%; height: 300px; overflow: hidden; margin: 0;">
        <iframe 
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3570.1234567890123!2d50.1705719!3d26.3755478!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3e49e8ba48c2d889%3A0xf8bf9683d3a01c89!2sNEFT+ENERGIES!5e0!3m2!1sen!2ssa!4v1234567890123"
            width="100%" 
            height="300" 
            style="border:0; margin: 0;" 
            allowfullscreen="" 
            loading="lazy" 
            referrerpolicy="no-referrer-when-downgrade">
        </iframe>
        <div class="map-info-overlay" style="position: absolute; top: 15px; left: 15px; background: rgba(255,255,255,0.95); padding: 12px 16px; border-radius: 6px; box-shadow: 0 3px 10px rgba(0,0,0,0.1); backdrop-filter: blur(10px); z-index: 1000;">
            <div class="d-flex align-items-center mb-1">
                <i data-feather="map-pin" width="16" height="16" class="mr-2" style="color: #007bff;"></i>
                <h6 class="mb-0 font-weight-bold" style="color: #333; font-size: 14px;">NEFT ENERGIES</h6>
            </div>
            <p class="mb-1" style="color: #666; font-size: 12px;">Neft Energies Building, King Fahad Road, Al Qashlah, Dhahran,34232.</p>
            <a href="https://www.google.com/maps/place/%D8%B4%D8%B1%D9%83%D8%A9+%D8%A7%D9%84%D8%B7%D8%A7%D9%82%D8%A9+NEFT%E2%80%AD/@26.3755478,50.1705719,17z/data=!3m1!4b1!4m6!3m5!1s0x3e49e8ba48c2d889:0xf8bf9683d3a01c89!8m2!3d26.3755478!4d50.1705719!16s%2Fg%2F11bxg1lwdw?entry=ttu" target="_blank" class="btn btn-primary btn-sm" style="font-size: 11px; padding: 6px 12px; border-radius: 4px;">
            <i data-feather="navigation" width="12" height="12" class="mr-1"></i>Get Directions
            </a>
        </div>
    </div>
</div>

<footer class="footer bg-secondary position-relative user-select-none">
     <div class="container">
        <div class="row" style="padding-bottom: 30px;">
            <div class="col-12">
                 <!-- removed by bdoor
             <div class=" footer-subscribe d-block d-md-flex align-items-center justify-content-between">  -->

                    <!-- removed by 
                 <div class="flex-grow-1">
                        <strong><?php echo e(trans('footer.join_us_today')); ?></strong>
                        <span class="d-block mt-5 text-white"><?php echo e(trans('footer.subscribe_content')); ?></span>
                    </div>
                    <div class="subscribe-input bg-white p-10 flex-grow-1 mt-30 mt-md-0">
                        <form action="/newsletters" method="post">
                            <?php echo e(csrf_field()); ?>


                            <div class="form-group d-flex align-items-center m-0">
                                <div class="w-100">
                                    <input type="text" name="newsletter_email" class="form-control border-0 <?php $__errorArgs = ['newsletter_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="<?php echo e(trans('footer.enter_email_here')); ?>"/>
                                    <?php $__errorArgs = ['newsletter_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <button type="submit" class="btn btn-primary rounded-pill"><?php echo e(trans('footer.join')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>--> 
            <!-- </div> -->
        </div>
    </div> 

    <div class="container">
        <div class="row">

            <!-- First Column -->
            <div class="col-6 col-md-3">
                <?php if(trans('footer.first_column_title') !== ''): ?>
                    <span class="header d-block text-white font-weight-bold" style="border-bottom: 2px solid white; padding-bottom: 8px; display: inline-block; width: fit-content;"><?php echo e(trans('footer.first_column_title')); ?></span>
                <?php endif; ?>
                <div class="mt-20">
                    <?php echo trans('footer.first_column_content'); ?>

                </div>
            </div>

            <!-- Second Column -->
            <div class="col-6 col-md-3">
                <?php if(trans('footer.second_column_title') !== ''): ?>
                    <span class="header d-block text-white font-weight-bold" style="border-bottom: 2px solid white; padding-bottom: 8px; display: inline-block; width: fit-content;"><?php echo e(trans('footer.second_column_title')); ?></span>
                <?php endif; ?>
                <div class="mt-20">
                    <?php echo trans('footer.second_column_content'); ?>

                </div>
            </div>

            <!-- Third Column -->
            <div class="col-6 col-md-3">
                <?php if(trans('footer.third_column_title') !== ''): ?>
                    <span class="header d-block text-white font-weight-bold" style="border-bottom: 2px solid white; padding-bottom: 8px; display: inline-block; width: fit-content;"><?php echo e(trans('footer.third_column_title')); ?></span>
                <?php endif; ?>
                <div class="mt-20">
                    <?php echo trans('footer.third_column_content'); ?>

                </div>
            </div>

            <!-- Fourth Column -->
            <div class="col-6 col-md-3">
                <?php if(trans('footer.forth_column_title') !== ''): ?>
                    <span class="header d-block text-white font-weight-bold" style="border-bottom: 2px solid white; padding-bottom: 8px; display: inline-block; width: fit-content;"><?php echo e(trans('footer.forth_column_title')); ?></span>
                <?php endif; ?>
                <div class="mt-20">
                    <?php echo trans('footer.forth_column_content'); ?>

                </div>
            </div>

        </div>

        <div class="mt-40 py-25 d-flex align-items-center justify-content-between" style="border-top: 1px solid white; width: 100%; margin: 0; padding: 0;">
            <div class="container d-flex align-items-center justify-content-between">
                <div class="footer-logo">
                    <a href="/">
                        <?php if(!empty($generalSettings['footer_logo'])): ?>
                            <img src="<?php echo e($generalSettings['footer_logo']); ?>" class="img-cover" alt="footer logo">
                        <?php endif; ?>
                    </a>
                </div>

                <div class="footer-social">
                    <?php if(!empty($socials) and count($socials)): ?>
                        <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e($social['link']); ?>" target="_blank">
                                <img src="<?php echo e($social['image']); ?>" alt="<?php echo e($social['title']); ?>" class="mr-15">
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <?php if(getOthersPersonalizationSettings('platform_phone_and_email_position') == 'footer'): ?>
        <div class="footer-copyright-card" style="width: 100vw; margin-left: calc(-50vw + 50%); margin-right: calc(-50vw + 50%); padding: 0;">
            <div class="container d-flex align-items-center justify-content-between py-15">
                <div class="font-14 text-white"><?php echo e(trans('update.platform_copyright_hint')); ?></div>

                <div class="d-flex align-items-center justify-content-center">
                    <?php if(!empty($generalSettings['site_phone'])): ?>
                        <div class="d-flex align-items-center text-white font-14">
                            <i data-feather="phone" width="20" height="20" class="mr-10"></i>
                            <?php echo e($generalSettings['site_phone']); ?>

                        </div>
                    <?php endif; ?>

                    <?php if(!empty($generalSettings['site_email'])): ?>
                        <div class="border-left mx-5 mx-lg-15 h-100"></div>

                        <div class="d-flex align-items-center text-white font-14">
                            <i data-feather="mail" width="20" height="20" class="mr-10"></i>
                            <?php echo e($generalSettings['site_email']); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

</footer>

<style>
    .location-map-section {
        background: #ffffff;
        margin: 0;
        padding: 0;
        width: 100%;
    }
    
    .map-wrapper {
        width: 100%;
        height: 300px;
        margin: 0;
        padding: 0;
        overflow: hidden;
    }
    
    .map-info-overlay {
        transition: all 0.3s ease;
    }
    
    .map-info-overlay:hover {
        transform: scale(1.02);
        box-shadow: 0 6px 20px rgba(0,0,0,0.15) !important;
    }
    
    .map-info-overlay .btn-primary {
        transition: all 0.3s ease;
    }
    
    .map-info-overlay .btn-primary:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(0,123,255,0.3);
    }
    
    @media (max-width: 768px) {
        .map-wrapper {
            height: 250px !important;
        }
    }
    
    @media (max-width: 576px) {
        .map-wrapper {
            height: 200px !important;
        }
    }

    .location-map-section { margin-bottom: 0 !important; padding-bottom: 0 !important; }
  .location-map-section .map-wrapper { margin: 0 !important; padding: 0 !important; height: 300px; }
  .location-map-section .map-wrapper iframe {
    display: block;     
    margin: 0 !important;
    vertical-align: bottom;
    height: 100% !important;  
    border: 0;
  }

  footer.footer { margin-top: 0 !important; padding-top: 0; }

  .location-map-section + footer.footer { margin-top: 0 !important; }

  </style>

<?php /**PATH /home/neftenergies/public_html/docroot.neft.sa/resources/views/web/default/includes/footer.blade.php ENDPATH**/ ?>