<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\FlexApi\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Serialize;


class InsightsConversationalAiContext extends InstanceContext
    {
    /**
     * Initialize the InsightsConversationalAiContext
     *
     * @param Version $version Version that contains the resource
     * @param string $instanceSid Sid of Flex Service Instance
     */
    public function __construct(
        Version $version,
        $instanceSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'instanceSid' =>
            $instanceSid,
        ];

        $this->uri = '/Insights/Instances/' . \rawurlencode($instanceSid)
        .'/AI/Reports';
    }

    /**
     * Fetch the InsightsConversationalAiInstance
     *
     * @param array|Options $options Optional Arguments
     * @return InsightsConversationalAiInstance Fetched InsightsConversationalAiInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): InsightsConversationalAiInstance
    {

        $options = new Values($options);

        $params = Values::of([
            'MaxRows' =>
                $options['maxRows'],
            'ReportId' =>
                $options['reportId'],
            'Granularity' =>
                $options['granularity'],
            'IncludeDate' =>
                Serialize::iso8601DateTime($options['includeDate']),
        ]);

        $payload = $this->version->fetch('GET', $this->uri, $params);

        return new InsightsConversationalAiInstance(
            $this->version,
            $payload,
            $this->solution['instanceSid']
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.FlexApi.V1.InsightsConversationalAiContext ' . \implode(' ', $context) . ']';
    }
}
