<div class="progress-bar" data-percent="<?php echo course_progress($course_id); ?>" data-duration="1000" data-color="#ccc, #198754"><span><?php echo course_progress($course_id); ?>%</span></div>

<?php
    // Check if payment_status exists in the enrol table for the course and user
    $enrolment_data = $this->db->get_where('enrol', array('course_id' => $course_id, 'user_id' => $this->session->userdata('user_id')))->row();
    $payment_status = ($enrolment_data) ? $enrolment_data->payment_status : 0;
    $issued_date = $this->db->get_where('course', array('id' => $course_id))->row('issued_date');
?>

<?php if ($payment_status == 0): ?>
    <div class="alert alert-danger mt-5" id="payment-alert" role="alert">
        <h4 class="alert-heading"><?php echo get_phrase('Payment Required'); ?></h4>
        <hr>
        <p><?php echo get_phrase('Sorry for the inconvenience, but your certificate is currently on hold due to an outstanding payment. Once the balance is settled, we will promptly release your certificate. Thank you for your cooperation and understanding.'); ?></p>
    </div>
<?php elseif (course_progress($course_id) == 100 && !empty($issued_date)): ?>
    <div class="alert alert-success mt-5" id="certificate-alert-success" role="alert">
        <h4 class="alert-heading"><?php echo get_phrase('well_done'); ?>!</h4>
        <hr>
        <p><?php echo get_phrase('congratulations').'!!!'; ?></p>
        <p><?php echo get_phrase('you are now eligible to download the course completion certificate'); ?>.</p>
    </div>
<?php else: ?>
    <div class="alert alert-info mt-5" id="certificate-alert-warning" role="alert">
        <h4 class="alert-heading"><?php echo get_phrase('Notice'); ?></h4>
        <hr>
        <p> <?php echo get_phrase('you have completed'); ?> <span id="progression"><?php echo course_progress($course_id); ?></span>% <?php echo get_phrase('of the course'); ?> </p>
        <p><?php echo get_phrase('you can download the course completion certificate after completing the course'); ?></p>
    </div>
    
    <?php if (course_progress($course_id) == 100 && empty($issued_date)): ?>
        <div class="row">
            <div class="col-12 text-center">
                <?php
                    $shareable_url = $this->certificate_model->get_certificate_url($this->session->userdata('user_id'), $course_id);
                    $issued_date = date('Y-m-d'); // Get the current date
                    $this->db->where('id', $course_id);
                    $this->db->update('course', array('issued_date' => $issued_date));
                ?>
                <?php if ($payment_status == 1): ?>
                    <a class="btn bg-success text-white px-4" id="generateCertificateBtn" target="_blank" href="<?php echo $shareable_url; ?>">
                        <?= get_phrase('Generate Certificate') ?>
                    </a>
                <?php else: ?>
                    <button class="btn bg-success text-white px-4 disabled" id="generateCertificateBtn">
                        <?= get_phrase('Generate Certificate') ?>
                    </button>
                    <p class="mt-2"><?php echo get_phrase('Your payment is not done. Cannot generate the certificate.'); ?></p>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>

<?php endif; ?>

<script>
    $(".progress-bar").loading();
</script>
