<?php
// Database connection details
$hostname = "localhost";
$username = "neftenergies_app";
$password = "8wmW2AO@!ex5";
$database = "neftenergies_app";

// Create a database connection
$mysqli = new mysqli($hostname, $username, $password, $database);

// Check the connection
if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error);
}

$quiz_results = $quiz_results->row_array();
$user_all_answers = json_decode(strtolower($quiz_results['user_answers']), true);
$my_correct_answer_question_ids = json_decode(strtolower($quiz_results['correct_answers']), true);

// Get the course id for the current user
$user_course_id = $lesson_details['course_id'];

// Add the following code to fetch payment_status from the "enrol" table using prepared statements
$query = "SELECT payment_status FROM enrol WHERE user_id = ? AND course_id = ?";
$stmt = $mysqli->prepare($query);

if ($stmt) {
    $stmt->bind_param("ii", $user_id, $user_course_id); // Assuming $user_id is the current user's id
    $stmt->execute();
    $stmt->bind_result($payment_status);

    // Fetch the result
    $stmt->fetch();

    // Close the statement
    $stmt->close();
} else {
    die("Query preparation failed: " . $mysqli->error);
}

// Calculate the percentage of course completion
$totalMarks = json_decode($lesson_details['attachment'], true)['total_marks'];
$obtainedMarks = $quiz_results['total_obtained_marks'];
$completionPercentage = ($obtainedMarks / $totalMarks) * 100;
?>

<div class="col-12">
    <h4 class="w-100 text-center"><?php echo get_phrase('quiz_results'); ?></h4>
    <p class="w-100 text-center mb-1"><?php echo get_phrase('total_marks'); ?> : <?php echo $totalMarks; ?></p>
    <p class="w-100 text-center my-0"><?php echo get_phrase('obtained_marks'); ?> : <?= $completionPercentage ?>%</p>
</div>

<div class="col-12">
    <?php 
    if ($payment_status == 1) {
        if ($completionPercentage == 100) {
            // Show a notice for congratulations
    ?>
            <div class="alert alert-success mt-5" id="congratulations-alert" role="alert">
                <h4 class="alert-heading"><?= get_phrase('Congratulations') ?>!</h4>
                <hr>
                <p><?= get_phrase('You are now eligible to download the course completion certificate') ?>.</p>
            </div>
    <?php
        } else {
            // Show a notice for course completion percentage
    ?>
            <div class="alert alert-info mt-5" id="completion-alert" role="alert">
                <h4 class="alert-heading"><?= get_phrase('Course Completion') ?></h4>
                <hr>
                <p><?= get_phrase('you have obtained') ?> <?= $completionPercentage ?>% <?= get_phrase('marks in the final exam.') ?>.</p>
            </div>
    <?php
        }
    } else {
        // Show a notice for non-payment
    ?>
        <div class="alert alert-danger mt-5" id="payment-alert" role="alert">
            <h4 class="alert-heading"><?= get_phrase('Payment Required') ?></h4>
            <hr>
            <p><?= get_phrase('Sorry for the inconvenience, but your certificate is currently on hold due to an outstanding payment. Once the balance is settled, we will promptly release your certificate. Thank you for your cooperation and understanding.') ?></p>
        </div>
    <?php
    }
    ?>
</div>


<?php
// Add the following code to fetch status from the "certificates" table using prepared statements
$query_certificates = "SELECT status FROM certificates WHERE student_id = ? AND course_id = ?";
$stmt_certificates = $mysqli->prepare($query_certificates);

if ($stmt_certificates) {
    $stmt_certificates->bind_param("ii", $user_id, $user_course_id);
    $stmt_certificates->execute();
    $stmt_certificates->bind_result($certificate_status);

    // Fetch the result
    $stmt_certificates->fetch();

    // Close the statement
    $stmt_certificates->close();
} else {
    die("Query preparation failed: " . $mysqli->error);
}

?>

<?php if ($lesson_details['quiz_attempt'] > ($total_attempted - 1) && $certificate_status == 0): ?>
    <div class="row justify-content-center" style="margin-top:-30px;">
        <div class="col-md-1"></div>
        <div class="col-md-9">
            <a class="btn btn-dark text-white mt-5" onclick="take_the_quiz_again()" href="javascript:;"><?php echo get_phrase('take_the_quiz_again'); ?> <i class="fas fa-chevron-right"></i></a>
        </div>
    </div>
    <script>
        function take_the_quiz_again(){
            $.ajax({
                url: '<?php echo site_url('user/start_quiz/'.$lesson_details['id'].'/retake'); ?>',
                success: function(){
                    location.reload();
                }
            });
        }
    </script>
<?php endif; ?>