<div class="row justify-content-center">
    <div class="col-xl-7">
        <div class="card">
            <div class="card-body">
                <div class="col-lg-12">
                    <h4 class="mb-3 header-title">Bulk Enrollment by uploading excel sheet</h4>
                    
                    <div id="messages"></div>
                    
                    <form id="enrolForm" enctype="multipart/form-data">
                        
                        <div class="form-group">
                            <label for="multiple_course_id"><?php echo get_phrase('course_to_enrol'); ?><span class="required">*</span> </label>
                            <select class="select2 form-control select2-multiple" data-toggle="select2" multiple="multiple" data-placeholder="Choose ..." name="course_id[]" id="multiple_course_id" required>
                                <option value=""><?php echo get_phrase('select_a_course'); ?></option>
                                <?php $course_list = $this->db->where('status', 'active')->or_where('status', 'private')->get('course')->result_array();
                                    foreach ($course_list as $course): ?>
                                    <option value="<?php echo $course['id'] ?>"><?php echo $course['title']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="form-group mb-3">
                            <label for="date_added">Enroll Date<span class="required">*</span></label>
                            <input type="text" class="form-control datepicker" name="date_added" id="date_added" required>
                        </div>

                        <div class="form-group mb-3">
                            <label for="expiry_date">Expiry Date<span class="required">*</span></label>
                            <input type="text" class="form-control datepicker" name="expiry_date" id="expiry_date" required>
                        </div>

                        <div class="form-group mb-3">
                            <label>Upload .Xlsx File<span class="required">*</span></label>
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" id="excel_file" name="excel_file" required accept=".xlsx">
                                    <label class="custom-file-label" for="excel_file">Upload excel sheet</label>
                                </div>
                            </div>
                        </div>
                        <button type="button" class="btn btn-primary float-right" id="enrolButton">Enroll Now</button>
                        <a href="<?= base_url('admin'); ?>" class="btn btn-secondary float-left mdi mdi-arrow-left">Back</a>
                    </form>
                </div>
            </div> <!-- end card body-->
        </div>
    </div>
</div>
<style>
#messages{
    color:green;
}
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    $('#excel_file').on('change', function() {
        var fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').html(fileName);
    });

    $('#enrolButton').click(function() {
        var isValid = $('#enrolForm')[0].checkValidity(); // Check form validity
        
        if (isValid) {
            var formData = new FormData($('#enrolForm')[0]);

            // Get selected course IDs from the select element
            var selectedCourses = $('#multiple_course_id').val();
            selectedCourses.forEach(function(courseId) {
                formData.append('course_id[]', courseId);
            });

            $.ajax({
                type: 'POST',
                url: '<?= base_url('upload/upload_process'); ?>',
                data: formData,
                dataType: 'text',
                processData: false,
                contentType: false,
                success: function(response) {
                    $('#messages').html(response);
                },
                error: function(response) {
                    $('#messages').html('Error: ' + response.responseText);
                }
            });
        } else {
            // Display a message to fill in all required fields
            $('#messages').html('<span style="color: red;">Please fill in all required fields.</span>');
        }
    });
});

</script>

<script>

$(document).ready(function() {
    // Initialize date picker for the expiry date and date added fields
    $('.datepicker').datepicker({
        format: 'yyyy-mm-dd', // Set your desired date format
        autoclose: true,
        todayHighlight: true
    });
});
</script>
