DROP TABLE IF EXISTS `addons`;
CREATE TABLE `addons` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `unique_identifier` varchar(255) NOT NULL,
  `version` varchar(255) DEFAULT NULL,
  `status` int NOT NULL,
  `created_at` int DEFAULT NULL,
  `updated_at` int DEFAULT NULL,
  `about` longtext,
  `purchase_code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
INSERT INTO `addons` (`id`, `name`, `unique_identifier`, `version`, `status`, `created_at`, `updated_at`, `about`, `purchase_code`) VALUES ('1', 'Tutor Booking', 'tutor_booking', '1.2', '1', '1566511200', NULL, 'This tutor booking addon helps student to book a tuition form a instructor for a specific time', '82748f56-8fb6-4143-a6fa-126e41e50f66'), ('2', 'Certificate', 'certificate', '1.3', '1', '1566511200', NULL, 'This addon helps student to get certified. Academy provides a course completion certificate for each student after completing any course', '82748f56-8fb6-4143-a6fa-126e41e50f66');
DROP TABLE IF EXISTS `applications`;
CREATE TABLE `applications` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `address` longtext,
  `phone` varchar(255) DEFAULT NULL,
  `message` longtext,
  `document` varchar(255) DEFAULT NULL,
  `status` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
DROP TABLE IF EXISTS `blog_category`;
CREATE TABLE `blog_category` (
  `blog_category_id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `subtitle` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `added_date` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`blog_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `blog_comments`;
CREATE TABLE `blog_comments` (
  `blog_comment_id` int NOT NULL AUTO_INCREMENT,
  `blog_id` int NOT NULL,
  `user_id` int NOT NULL,
  `parent_id` int NOT NULL,
  `comment` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `likes` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `added_date` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `updated_date` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`blog_comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `blogs`;
CREATE TABLE `blogs` (
  `blog_id` int NOT NULL AUTO_INCREMENT,
  `blog_category_id` int NOT NULL,
  `user_id` int NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `keywords` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `description` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `thumbnail` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `banner` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `is_popular` int NOT NULL,
  `likes` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `added_date` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `updated_date` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`blog_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `category`;
CREATE TABLE `category` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `parent` int DEFAULT '0',
  `slug` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `date_added` int DEFAULT NULL,
  `last_modified` int DEFAULT NULL,
  `font_awesome_class` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `thumbnail` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `category` (`id`, `code`, `name`, `parent`, `slug`, `date_added`, `last_modified`, `font_awesome_class`, `thumbnail`) VALUES ('1', 'f6e643f55d', 'UpStream', '0', 'upstream', '1692482400', NULL, 'fas fa-chess', 'category-thumbnail.png'), ('2', 'd9b2097f49', 'Safety', '1', 'safety', '1692482400', NULL, 'fas fa-chess', NULL);
DROP TABLE IF EXISTS `certificates`;
CREATE TABLE `certificates` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `student_id` int DEFAULT NULL,
  `course_id` int DEFAULT NULL,
  `shareable_url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3;
INSERT INTO `certificates` (`id`, `student_id`, `course_id`, `shareable_url`) VALUES ('9', '453', '1', 'ce30db054f'), ('10', '451', '1', 'ea28c86282'), ('11', '451', '2', '51fec7711a'), ('12', '458', '1', '63d861901f');
DROP TABLE IF EXISTS `ci_sessions`;
CREATE TABLE `ci_sessions` (
  `id` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `timestamp` int unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('17lrkjc5edn270lhco1fikh1emmdregs', '212.70.118.68', '1695715464', '__ci_last_regenerate|i:1695463481;custom_session_limit|i:1696579464;user_id|s:3:\"453\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:12:\"Noman Khalid\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";cart_items|a:0:{}language|s:7:\"english\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('341ee4evr63f33do5la4qfu97e387dp4', '116.58.203.191', '1695666005', '__ci_last_regenerate|i:1695476754;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1696529107;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('d7cudrighm6n18imev6cpk8cti8d38hg', '212.70.118.87', '1695715650', '__ci_last_regenerate|i:1695481815;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1696579649;user_id|s:1:\"1\";role_id|s:1:\"1\";role|s:5:\"Admin\";name|s:13:\"Noman  Khalid\";is_instructor|s:1:\"1\";admin_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('2u3rglvssv85akcjev9mfqjd62s039vq', '43.245.123.105', '1695629085', '__ci_last_regenerate|i:1695629085;'), ('5k6s4vfcnvi0g6te5g3i4a7rjn47aeqi', '43.245.123.105', '1695629088', '__ci_last_regenerate|i:1695629088;'), ('a0lb54g1kg9r3n19tjmron75k0bau94m', '43.245.123.105', '1695629088', '__ci_last_regenerate|i:1695629088;'), ('kivbkivducm3hmu9pqhej95cde4q9bj1', '43.245.123.105', '1695629088', '__ci_last_regenerate|i:1695629088;'), ('327hdsaloc96nh4ue6fdvfnfdlhvm6qt', '43.245.123.105', '1695629088', '__ci_last_regenerate|i:1695629088;'), ('61hrilgvnod1iv1vr1iklbgp71rbq87j', '43.245.123.105', '1695629088', '__ci_last_regenerate|i:1695629088;'), ('74hdjr8l25kv63a1t8er1llqemv9rrug', '43.245.123.105', '1695629088', '__ci_last_regenerate|i:1695629088;'), ('p6rtm7bvoggb5ictaj7v4kjfkaic9par', '43.245.123.105', '1695629089', '__ci_last_regenerate|i:1695629089;'), ('9a4arpvd6lu43h2t1fjh68o45n3m9u4r', '43.245.123.105', '1695629091', '__ci_last_regenerate|i:1695629091;'), ('gr1fldre1e6glgi1auohejp53rbgs6v9', '43.245.123.105', '1695629091', '__ci_last_regenerate|i:1695629091;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('001ke9a8b5e44thf76tdh4qkrl8pr830', '43.245.123.105', '1695629091', '__ci_last_regenerate|i:1695629091;'), ('8isnpm81m6ln8qee1ojihei0cc7ejpg3', '43.245.123.105', '1695629092', '__ci_last_regenerate|i:1695629092;'), ('me0kjp9dthfpg643epf5vej0qipbofht', '43.245.123.105', '1695629093', '__ci_last_regenerate|i:1695629093;'), ('fv5ahc02nru40dfnm7c8nl8u3u84jf2a', '43.245.123.105', '1695629094', '__ci_last_regenerate|i:1695629094;'), ('pkj3j1ta8sukc0miurucob57fr0746av', '43.245.123.105', '1695629094', '__ci_last_regenerate|i:1695629094;'), ('s3rs2csatvkhengmtegqjtu1cg3juj9r', '43.245.123.105', '1695629094', '__ci_last_regenerate|i:1695629094;'), ('omjpo2dh63add81u9hbnihkp6mqie0nt', '43.245.123.105', '1695629095', '__ci_last_regenerate|i:1695629095;'), ('eb7h4gs2cnt2g1q5iu215pprarea9oim', '43.245.123.105', '1695629095', '__ci_last_regenerate|i:1695629095;'), ('330120ccinibqh7mm1p46943vbdghfs2', '43.245.123.105', '1695629095', '__ci_last_regenerate|i:1695629095;'), ('9gjt7m1ni1t4m41u564gloo344e948rk', '43.245.123.105', '1695629095', '__ci_last_regenerate|i:1695629095;'), ('9alne2v287a4t5vt1midd288snot17mr', '43.245.123.105', '1695629096', '__ci_last_regenerate|i:1695629096;'), ('5jmgbh2b5a3hlvpenr2qqbv9daktg38b', '43.245.123.105', '1695629096', '__ci_last_regenerate|i:1695629096;'), ('o7so8ordmvnn4apq60iff7i3c0ngp1s9', '43.245.123.105', '1695629096', '__ci_last_regenerate|i:1695629096;'), ('44389o7f95988ahkkcivjgf9nsolidck', '43.245.123.105', '1695629098', '__ci_last_regenerate|i:1695629098;'), ('9e4020fnbqj51b0qqn3gnrtmj4ujbnsr', '43.245.123.105', '1695629098', '__ci_last_regenerate|i:1695629098;'), ('fbr2vdo0b0kao6rkjme95m79ragr2apl', '43.245.123.105', '1695629098', '__ci_last_regenerate|i:1695629098;'), ('sv5hno7hvgdkh6h6p2slpm996c5lh37l', '43.245.123.105', '1695629098', '__ci_last_regenerate|i:1695629098;'), ('auf3smp1oghe6g7etrgq2gt6mbg7pooh', '43.245.123.105', '1695629099', '__ci_last_regenerate|i:1695629099;'), ('c3t56t6oq5ugnber3v7ubj8mks3guu52', '43.245.123.105', '1695629101', '__ci_last_regenerate|i:1695629101;'), ('085p8066r36dtb1p06jnq60ajejdmjbd', '43.245.123.105', '1695629102', '__ci_last_regenerate|i:1695629102;'), ('sjarkes6cq0l77kccikh4705dj4m4hae', '43.245.123.105', '1695629102', '__ci_last_regenerate|i:1695629102;'), ('vitu7e1ojpl40oh9ku7o2q726hs6274t', '43.245.123.105', '1695629102', '__ci_last_regenerate|i:1695629102;'), ('4kd8cakq7u6hgnq07gma7vtmebae5cug', '43.245.123.105', '1695629102', '__ci_last_regenerate|i:1695629102;'), ('6v1833ji6e4je61r5mn4pkotb7qrgga6', '43.245.123.105', '1695629102', '__ci_last_regenerate|i:1695629102;'), ('tchkijdn3rfmrs2b624rgk40ktbkl9h6', '43.245.123.105', '1695629102', '__ci_last_regenerate|i:1695629102;'), ('h480d8tdpmvjhc2324udip6bf419ok44', '43.245.123.105', '1695629103', '__ci_last_regenerate|i:1695629103;'), ('sedphh1t4i2pre96hcjmntqjsct5078s', '103.67.156.175', '1695648773', '__ci_last_regenerate|i:1695648773;'), ('890oo01v39qhvmq88kl6q1pgpb4i671b', '103.67.156.175', '1695648778', '__ci_last_regenerate|i:1695648778;'), ('n01dl27ksmkr8kbeahmhdmuaq6vv5hc7', '103.67.156.175', '1695648778', '__ci_last_regenerate|i:1695648778;'), ('emhftco09ipgastvudeildp3vpuimcvo', '103.67.156.175', '1695648778', '__ci_last_regenerate|i:1695648778;'), ('4b54punu3cgdelitd4ptr3ujacqirj4j', '103.67.156.175', '1695648778', '__ci_last_regenerate|i:1695648778;'), ('s1f5c9a86a77vgis24pbf3u91ufqe65r', '103.67.156.175', '1695648778', '__ci_last_regenerate|i:1695648778;'), ('5gol4fdb5fn2v6ns062qh2rdn0msj0i5', '103.67.156.175', '1695648778', '__ci_last_regenerate|i:1695648778;'), ('snfds78fh16k1n7639bflcffrfqgrhfi', '103.67.156.175', '1695648778', '__ci_last_regenerate|i:1695648778;'), ('nltqfjb9m712b9kf6ceflv9muekp3lfe', '103.67.156.175', '1695648787', '__ci_last_regenerate|i:1695648787;'), ('107mg2qa3qt8g68htem3983rv6jiq68o', '103.67.156.175', '1695648787', '__ci_last_regenerate|i:1695648787;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('df79qata58srrc0qol4l3lcco764gfer', '103.67.156.175', '1695648787', '__ci_last_regenerate|i:1695648787;'), ('21k0lon97q999hoo9dd59chjdme6prt8', '103.67.156.175', '1695648789', '__ci_last_regenerate|i:1695648789;'), ('glirf2d8mcl5pvj26ovmhj24m9tlf86o', '103.67.156.175', '1695648811', '__ci_last_regenerate|i:1695648811;'), ('6j6c9914tokkopi1l5vh0rqrjtmlj2m3', '103.253.45.152', '1695659320', '__ci_last_regenerate|i:1695659320;'), ('j14pvpsfuer4rcfq44r791a9lg2g1dbi', '103.253.45.152', '1695659323', '__ci_last_regenerate|i:1695659323;'), ('oeuuojp8d6bdudivls36cgghs7an3qi3', '103.253.45.152', '1695659323', '__ci_last_regenerate|i:1695659323;'), ('b7pvjk99uipo2g84l8inedhi5e776kvh', '103.253.45.152', '1695659323', '__ci_last_regenerate|i:1695659323;'), ('d3rr4f4l4189auv6h13c0e40jeas9hl9', '103.253.45.152', '1695659323', '__ci_last_regenerate|i:1695659323;'), ('q4lovlgnt712e6s2287q142mmdup0ais', '103.253.45.152', '1695659323', '__ci_last_regenerate|i:1695659323;'), ('dbf6mok4r5d1edfc62v1cmbe7uv9vsf4', '103.253.45.152', '1695659323', '__ci_last_regenerate|i:1695659323;'), ('clgiief2osmat7nh8nisc3m3tuth79a2', '103.253.45.152', '1695659324', '__ci_last_regenerate|i:1695659324;'), ('oh3k4qh1fmp0qfpf1ci9kg1kb99r72t1', '103.253.45.152', '1695659327', '__ci_last_regenerate|i:1695659327;'), ('ifilffmp3duolvcebmp17a8m4nsgq383', '103.253.45.152', '1695659327', '__ci_last_regenerate|i:1695659327;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('197b2ouv8lb4aehec95h6cs52otnquej', '103.253.45.152', '1695659327', '__ci_last_regenerate|i:1695659327;'), ('pc7t84kn6l7jqsenaqsc1evluu65sh1c', '103.253.45.152', '1695659330', '__ci_last_regenerate|i:1695659330;'), ('nos1b480bi509tub4gs4op9fb1c6ggsv', '103.253.45.152', '1695659330', '__ci_last_regenerate|i:1695659330;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ebn8edvn3bk08bqeredrc32p6r56u27r', '103.253.45.152', '1695659331', '__ci_last_regenerate|i:1695659331;'), ('6g4261eqbquckpo2cng2s6pel4fud8og', '103.253.45.152', '1695659331', '__ci_last_regenerate|i:1695659331;'), ('i8v0juriiufdn7kh2srieivut5fqmdeb', '103.253.45.152', '1695659333', '__ci_last_regenerate|i:1695659333;'), ('pq37kgt0h24j01pjg67sp2hv8ikaph9j', '103.253.45.152', '1695659333', '__ci_last_regenerate|i:1695659333;'), ('kpjpnrecken01kb6us2cpos6aac39jm7', '103.253.45.152', '1695659333', '__ci_last_regenerate|i:1695659333;'), ('8e8vgeru9j2b7s9nq3tvk54j296sugt6', '103.253.45.152', '1695659333', '__ci_last_regenerate|i:1695659333;'), ('deu3427jfi0d9lfh3rvanq04cam5vqq7', '103.253.45.152', '1695659333', '__ci_last_regenerate|i:1695659333;'), ('61treoase1chdvkn9b3uakqlesr2a152', '103.253.45.152', '1695659334', '__ci_last_regenerate|i:1695659334;'), ('htvtdo8tnqkb1dag1e9u34131vrggcqm', '103.253.45.152', '1695659336', '__ci_last_regenerate|i:1695659336;'), ('70bof65ik3370k1gggpq3ha20r99ttgd', '103.253.45.152', '1695659336', '__ci_last_regenerate|i:1695659336;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('9ui9f9hcke9mbslt4v6kbovn44po9bdn', '103.253.45.152', '1695659336', '__ci_last_regenerate|i:1695659336;'), ('104i94h952650571fdv954vvkuur2foi', '103.253.45.152', '1695659338', '__ci_last_regenerate|i:1695659338;'), ('1omajnh0ncro5g06ld763v9o8t86po34', '103.253.45.152', '1695659338', '__ci_last_regenerate|i:1695659338;'), ('loi7gc1k73h5s9pdfopegn2thfessiui', '103.253.45.152', '1695659339', '__ci_last_regenerate|i:1695659339;'), ('c5f1q0vk4gr63i9bbi4edugu07aeoq7p', '103.253.45.152', '1695659339', '__ci_last_regenerate|i:1695659339;'), ('56jescm611gbcus260tfmudsr2r5ep7o', '103.253.45.152', '1695659339', '__ci_last_regenerate|i:1695659339;'), ('airmke47a1qipfgvcpq4b6pqid9f2pv1', '103.253.45.152', '1695659339', '__ci_last_regenerate|i:1695659339;'), ('u1pt15q7c9b55sl2j61dpehbi2pj7uvc', '103.253.45.152', '1695659339', '__ci_last_regenerate|i:1695659339;'), ('jevh2d2rurdu9vevoofrp0c9fd8tjejh', '103.253.45.152', '1695659339', '__ci_last_regenerate|i:1695659339;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('sc6r42dnm3f3008piuhreh1c3nod0idr', '103.253.45.152', '1695659341', '__ci_last_regenerate|i:1695659341;'), ('72r79bl3ae19ttpla4dmtsi7ismg4cri', '103.253.45.152', '1695659364', '__ci_last_regenerate|i:1695659364;'), ('d63khhsqbma75d7ot5p81ca6pum53urk', '103.253.45.152', '1695659426', '__ci_last_regenerate|i:1695659426;'), ('i8db3mul50titj5253mere00hl2efpk0', '103.253.45.152', '1695659461', '__ci_last_regenerate|i:1695659461;'), ('mpbk4km1a2qji3vc609qkdni4v4bgljk', '103.253.45.152', '1695659461', '__ci_last_regenerate|i:1695659461;'), ('4pia5jomcblr0kjrqbu03b9k9jl9v2dt', '103.253.45.152', '1695659461', '__ci_last_regenerate|i:1695659461;'), ('8cmd72cu1fascng6ndsg541ienscn4me', '103.253.45.152', '1695659461', '__ci_last_regenerate|i:1695659461;'), ('9mvvb6h4r1badbq4l47s1ekmh1fc2g6h', '103.253.45.152', '1695659461', '__ci_last_regenerate|i:1695659461;'), ('al5ta10mtgjq7fmg6su0n8c83jmtl36q', '103.253.45.152', '1695659463', '__ci_last_regenerate|i:1695659463;'), ('8alj4atglkt251boka65ul3k6rpk3cug', '103.253.45.152', '1695659468', '__ci_last_regenerate|i:1695659468;'), ('r36p2oi8ef9sra0ii748b7oodtpuktjn', '103.253.45.152', '1695659469', '__ci_last_regenerate|i:1695659469;'), ('om27p49d9cdsa06s8ajmu9lmau99ruib', '103.253.45.152', '1695659470', '__ci_last_regenerate|i:1695659470;'), ('47gv3llrr4ud1ckn47i4hrdrp9btnipr', '103.253.45.152', '1695659470', '__ci_last_regenerate|i:1695659470;'), ('g217e72uuttepoesitdbvpkq59oo6r7k', '103.253.45.152', '1695659471', '__ci_last_regenerate|i:1695659471;'), ('nvo9fidbb830gippvmbrfg3na7j2m960', '103.253.45.152', '1695659471', '__ci_last_regenerate|i:1695659471;'), ('hc0eks3aufprfp7qhp6qqqt3hjn8hl13', '103.253.45.152', '1695659471', '__ci_last_regenerate|i:1695659471;'), ('apm5g0to5ls6u7pkiufahvlfs8cv9hsi', '103.253.45.152', '1695659471', '__ci_last_regenerate|i:1695659471;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ib6ua7apqf9d116notckrkgibc8dnbpt', '103.253.45.152', '1695659473', '__ci_last_regenerate|i:1695659473;'), ('rd1l1c9mao593q2l0ma4q9os26deru6p', '103.253.45.152', '1695659709', '__ci_last_regenerate|i:1695659709;'), ('5p45g2t3tc4t6keiaf88or7c5q7evhs9', '103.253.45.152', '1695659709', '__ci_last_regenerate|i:1695659709;'), ('u7fvsvalicdi86029mkf6f1e6n936fsq', '103.253.45.152', '1695659709', '__ci_last_regenerate|i:1695659709;'), ('pg3u5vjrmjh59khrll0a4qj7o3nmadhs', '103.253.45.152', '1695659709', '__ci_last_regenerate|i:1695659709;'), ('9g0ppd4buimdvp2462891c854pni2gul', '103.253.45.152', '1695659709', '__ci_last_regenerate|i:1695659709;'), ('def6tjs4tc88fducp8cpgedna4c7ntcc', '103.253.45.152', '1695659710', '__ci_last_regenerate|i:1695659710;'), ('jesdrtatvjfqmj2upig1prj8d1jhr3no', '103.253.45.152', '1695659711', '__ci_last_regenerate|i:1695659711;'), ('e7qlnulrod26391b8lg7p1ptvkg9k11j', '103.253.45.152', '1695659711', '__ci_last_regenerate|i:1695659711;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('5o5d42ug9lhj1bj45btalo3i2ibd4ltv', '103.253.45.152', '1695659712', '__ci_last_regenerate|i:1695659712;'), ('u8vht54ftbob7f1a86np07mad3iv12us', '103.253.45.152', '1695659712', '__ci_last_regenerate|i:1695659712;'), ('ts6kum5lqkpensskp6ktfqmaqf1hi1ak', '103.253.45.152', '1695659713', '__ci_last_regenerate|i:1695659713;'), ('874ppo342mgl60bhls304vc9mlnqj1n3', '103.253.45.152', '1695659719', '__ci_last_regenerate|i:1695659719;'), ('3qloi10nbgct32hek3gf4rai2n63ifbs', '103.253.45.152', '1695659719', '__ci_last_regenerate|i:1695659719;'), ('pcsca6cu75pntdpb346lklkg6qk949ik', '103.253.45.152', '1695659720', '__ci_last_regenerate|i:1695659720;'), ('o7ed48abq7sd47cpbfcgc4k0t9e4of82', '103.253.45.152', '1695659720', '__ci_last_regenerate|i:1695659720;'), ('8u2h8kvmtuu2epre6e0rrfqv6v9enkfe', '103.253.45.152', '1695659723', '__ci_last_regenerate|i:1695659723;'), ('9o19f19u6jio23japhr3o5uh7u59o6ue', '103.253.45.152', '1695659723', '__ci_last_regenerate|i:1695659723;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ik4p7g3t7cvkrnlkaspk3hup3bs1b7oo', '103.253.45.152', '1695659723', '__ci_last_regenerate|i:1695659723;'), ('h1nppgivhcf75i350iu3fq92qt32dhst', '103.253.45.152', '1695659723', '__ci_last_regenerate|i:1695659723;'), ('p86eratg3p8k8adrtqaqp7dtrmsulv5l', '103.253.45.152', '1695659734', '__ci_last_regenerate|i:1695659734;'), ('a9h4se8jb09edagoo98nq1jdbic38ses', '103.253.45.152', '1695659737', '__ci_last_regenerate|i:1695659737;'), ('msricsgg165ppu0au87bqigo808rto6n', '103.253.45.152', '1695659737', '__ci_last_regenerate|i:1695659737;'), ('di842poh7foavifm25ib0jqmqqmu5a30', '103.253.45.152', '1695659737', '__ci_last_regenerate|i:1695659737;'), ('rpsnkbdf6fsm0ao6k0f3k2pjrmpue6sj', '103.253.45.152', '1695659737', '__ci_last_regenerate|i:1695659737;'), ('ql2rhvonvoqhjju5fo76suk30vo5vjad', '103.253.45.152', '1695659737', '__ci_last_regenerate|i:1695659737;'), ('9vr4s0lf3g3rvb2knhcfrcckn02ctb8c', '103.253.45.152', '1695659737', '__ci_last_regenerate|i:1695659737;'), ('dglsd0dqb4hkir6m6b48l4o0kk4qn62d', '103.253.45.152', '1695659738', '__ci_last_regenerate|i:1695659738;'), ('slgo112hn8m8o0ja9r3v7ckhre57og62', '103.253.45.152', '1695659742', '__ci_last_regenerate|i:1695659742;'), ('bl2eu73h8b01u6gvmadcdkaaogk04k0v', '103.253.45.152', '1695659742', '__ci_last_regenerate|i:1695659742;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('q5hvqbsguq7dvp48ll9nifrmallvnsnq', '103.253.45.152', '1695659743', '__ci_last_regenerate|i:1695659743;'), ('4q3r3reh7j14eg2rhcn1rgdtrpql7fk2', '103.253.47.183', '1695664626', '__ci_last_regenerate|i:1695664626;'), ('k2qs4ii5vhoivc4lo5bc2ngppqqgt409', '103.253.47.183', '1695664628', '__ci_last_regenerate|i:1695664628;'), ('946vc8ogh25852n7hgncjcihulidg5a5', '103.253.47.183', '1695664629', '__ci_last_regenerate|i:1695664629;'), ('6uc0b9s0g04863icrdcsgtna4i36da3n', '103.253.47.183', '1695664629', '__ci_last_regenerate|i:1695664629;'), ('delg9n9br5cq3ciukhcsn7tn18j8j4s5', '103.253.47.183', '1695664629', '__ci_last_regenerate|i:1695664629;'), ('rqlmhgo864g0gedbf9b6fmvrbkgo8n1f', '103.253.47.183', '1695664629', '__ci_last_regenerate|i:1695664629;'), ('j6in4q88fuvk8ri51ko1to0q5g0kjv9a', '103.253.47.183', '1695664629', '__ci_last_regenerate|i:1695664629;'), ('l2ocel3oc2b8vjd0g098mhu02g78s6hu', '103.253.47.183', '1695664629', '__ci_last_regenerate|i:1695664629;'), ('qhejtkhlfep0vklpguuoobd78s87ou1q', '103.253.47.183', '1695664633', '__ci_last_regenerate|i:1695664633;'), ('tetatpr11mf68hedn73i5gov7dpi1gtm', '103.253.47.183', '1695664633', '__ci_last_regenerate|i:1695664633;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('v2g3igk7dinod01j8i0dmjm2ejueagmq', '103.253.47.183', '1695664634', '__ci_last_regenerate|i:1695664634;'), ('naq64em3091a09od48877vfdeffh5eti', '103.253.47.183', '1695664635', '__ci_last_regenerate|i:1695664635;'), ('e2vt85oil78jmn8erakbm111glje8nli', '103.253.47.183', '1695664635', '__ci_last_regenerate|i:1695664635;'), ('ufib2gv9gltmtr6nuup45u6gti31tmkq', '103.253.47.183', '1695664639', '__ci_last_regenerate|i:1695664639;'), ('js33boc4umgmf5f7jnplh90q2c10onnl', '103.253.47.183', '1695664639', '__ci_last_regenerate|i:1695664639;'), ('djn22ph4c62dfhbvf17f6idhdm3kksdu', '103.253.47.183', '1695664640', '__ci_last_regenerate|i:1695664640;'), ('nkd8hml7gip6v64ad2le9k21k5kuer3u', '103.253.47.183', '1695664640', '__ci_last_regenerate|i:1695664640;'), ('brv6j2h18tv07uu7dsrdj1q9civlqav5', '103.253.47.183', '1695664643', '__ci_last_regenerate|i:1695664643;'), ('9blvcspf81dns46c3gdtssha8dl3lij6', '103.253.47.183', '1695664643', '__ci_last_regenerate|i:1695664643;'), ('jqoap44ru6t8pm5kfb8r18gjsp1p1o1j', '103.253.47.183', '1695664643', '__ci_last_regenerate|i:1695664643;'), ('7rcdauv3fkouic71h25t0grs4ml2ck3l', '103.253.47.183', '1695664643', '__ci_last_regenerate|i:1695664643;'), ('qr83gjeic5jp3noga6r788hdk7utg7m6', '103.253.47.183', '1695664643', '__ci_last_regenerate|i:1695664643;'), ('m7b00qnef4o9r998gg93qqmt82hl7fa7', '103.253.47.183', '1695664643', '__ci_last_regenerate|i:1695664643;'), ('4qlvq7tdit27l04hd8vgubp9va3cue1m', '103.253.47.183', '1695664645', '__ci_last_regenerate|i:1695664645;'), ('7pitc08sd2etv6mqij8ljjsjlk8r93gd', '103.253.47.183', '1695664645', '__ci_last_regenerate|i:1695664645;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('mtnrhskdn51fl35n423lpvqvna547023', '103.253.47.183', '1695664646', '__ci_last_regenerate|i:1695664646;'), ('1918fdt09bedsdsqbos09jn3esu8qq6a', '103.253.47.183', '1695664647', '__ci_last_regenerate|i:1695664647;'), ('amql8smo2ca674tt4url5c81od20b07j', '103.253.47.183', '1695664647', '__ci_last_regenerate|i:1695664647;'), ('tb38sg1m4bd6tdou6ei8emi4jt0fo11e', '103.253.47.183', '1695664651', '__ci_last_regenerate|i:1695664651;'), ('ei0pfifspncvpodr4p4ohubuj29l8j8a', '103.253.47.183', '1695664651', '__ci_last_regenerate|i:1695664651;'), ('h1ls944t1lkkqqcjrfgaoaho41gh23ha', '103.253.47.183', '1695664652', '__ci_last_regenerate|i:1695664652;'), ('sn52lodk4j4mcu4gbe8d80lr9pgdilrk', '103.253.47.183', '1695664652', '__ci_last_regenerate|i:1695664652;'), ('o7c7tikv2q8j4kvjie5htln26q5kmn67', '103.253.47.183', '1695664653', '__ci_last_regenerate|i:1695664653;'), ('39vohe5qo5nvdq21apdtblk90pbvnms8', '103.253.47.183', '1695664653', '__ci_last_regenerate|i:1695664653;'), ('k9ng3jca3tn9d27lj2rsnncok5tb52u1', '103.253.47.183', '1695664653', '__ci_last_regenerate|i:1695664653;'), ('meut0f024ahe67b7gd0m694buhd735sb', '103.253.47.183', '1695664653', '__ci_last_regenerate|i:1695664653;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('6s7uihvfljknh50d3rnds52b8u3sfuf2', '103.253.47.183', '1695664662', '__ci_last_regenerate|i:1695664662;'), ('2v0so86khnmk7455lsvdo31c4shv7bin', '103.253.47.183', '1695664662', '__ci_last_regenerate|i:1695664662;'), ('67b8fe0ja4nok7jk3jfvumal47kud6ui', '103.253.47.183', '1695664662', '__ci_last_regenerate|i:1695664662;'), ('ipbs17qu6l9f9ut1nnj32n3d2or2e44k', '103.253.47.183', '1695664662', '__ci_last_regenerate|i:1695664662;'), ('neeeku29oh8sk8220m28mub1n63h7g9c', '103.253.47.183', '1695664662', '__ci_last_regenerate|i:1695664662;'), ('qhho7dlqipvobj6ic1hpk919l61cl89g', '103.253.47.183', '1695664662', '__ci_last_regenerate|i:1695664662;'), ('39brolqfs0tnmave2k3hg0nuljolqqbg', '103.253.47.183', '1695664666', '__ci_last_regenerate|i:1695664666;'), ('0h1mu7497s4lu52b4kj87ut8g6bepdmh', '103.253.47.183', '1695664666', '__ci_last_regenerate|i:1695664666;'), ('e34ldm5g4mhaok5nnd9it4a5vterlmeq', '103.253.47.183', '1695664667', '__ci_last_regenerate|i:1695664667;'), ('j5dvu16j9cn16p3mufafa3m8f7pch9te', '103.253.47.183', '1695664668', '__ci_last_regenerate|i:1695664668;'), ('kavd5qbt6dhagfo031k2tv5lansba82v', '103.253.47.183', '1695664668', '__ci_last_regenerate|i:1695664668;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('chmlpnkg537i1dt1qvq1r4knk629devl', '103.253.47.183', '1695664669', '__ci_last_regenerate|i:1695664669;'), ('pdf3qi1rf6umtahqtb1d1d911lqn9n1p', '103.253.47.183', '1695664670', '__ci_last_regenerate|i:1695664670;'), ('3jv5ooir10270il054tgt9etepmvm5du', '103.253.47.183', '1695664670', '__ci_last_regenerate|i:1695664670;'), ('fviucsl9qbha2lag6n6nlim54qqgaqn8', '103.253.47.183', '1695664672', '__ci_last_regenerate|i:1695664672;'), ('h4g1s4lk8mqascnau3d2ga9ka9m6a5kb', '103.253.47.183', '1695664673', '__ci_last_regenerate|i:1695664673;'), ('r075hdpoip1ed5k92fst8vopq9u4i99v', '103.253.47.183', '1695664673', '__ci_last_regenerate|i:1695664673;'), ('uplgj64cpc2r4hts6iqg68ilp77parpt', '103.253.47.183', '1695664673', '__ci_last_regenerate|i:1695664673;'), ('j1iccsa77k5pdspn8r7n9qtkvshtmfm2', '103.253.47.183', '1695664673', '__ci_last_regenerate|i:1695664673;'), ('6uao996et8n1k5sarm2cvsd1u9rnfefo', '103.253.47.183', '1695664674', '__ci_last_regenerate|i:1695664674;'), ('l1kc317u81a25ahe6rbkme4blvidb4l1', '103.253.47.183', '1695664675', '__ci_last_regenerate|i:1695664675;'), ('rssih6qhu4id57snc4hjrveoh4bknr5i', '103.253.47.183', '1695664675', '__ci_last_regenerate|i:1695664675;'), ('uuka3empt339kobcmcehjfm8dgduf1dm', '103.253.47.183', '1695664675', '__ci_last_regenerate|i:1695664675;'), ('6h3e7hkem4h1o3gv95g9774p156dc04m', '103.253.47.183', '1695664676', '__ci_last_regenerate|i:1695664676;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('cbo7t4pkri569fuek19tm9e264ptcq9b', '103.253.47.183', '1695664681', '__ci_last_regenerate|i:1695664681;'), ('q58om6irqn54kvtkl3aga29udjorh9ed', '103.253.47.183', '1695664681', '__ci_last_regenerate|i:1695664681;'), ('fjrpiirm2e3e5r97b8vdtg3ng1cm7hgb', '103.253.47.183', '1695664681', '__ci_last_regenerate|i:1695664681;'), ('2h95phdc34r7j05c4ie315bj44uao2v3', '103.253.47.183', '1695664681', '__ci_last_regenerate|i:1695664681;'), ('28t8p4aq0t92pnjd7ba6qmcbuofvl0ni', '103.253.47.183', '1695664681', '__ci_last_regenerate|i:1695664681;'), ('0s0f3e21ebbogovl6qcg34fqm3tu4ad6', '103.253.47.183', '1695664682', '__ci_last_regenerate|i:1695664682;'), ('0339af0rec0u1eoii4r2b0qk29oq2cca', '103.253.47.183', '1695664684', '__ci_last_regenerate|i:1695664684;'), ('lijundr8gtifmjclmihp1vs1ul23g58l', '103.253.47.183', '1695664684', '__ci_last_regenerate|i:1695664684;'), ('bevtd722uq95jsehuih09p6jpk1ba8ss', '103.253.47.183', '1695664687', '__ci_last_regenerate|i:1695664687;'), ('cjjqf4v8s2as4j1gpb4g3th1jukvk7pe', '103.253.47.183', '1695664687', '__ci_last_regenerate|i:1695664687;'), ('erq4n5113nc8f2ah3pncik1sb0oj6nvc', '103.253.47.183', '1695664687', '__ci_last_regenerate|i:1695664687;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('4ktg84ej40u7e3c4cgjjfcmdgigdrk5g', '103.253.47.183', '1695664687', '__ci_last_regenerate|i:1695664687;'), ('jno99ng3m11v9l76cddne8s3ekj9g07o', '103.253.47.183', '1695664698', '__ci_last_regenerate|i:1695664698;'), ('coei59ohtalgglvpr1h8jd9t0s16capg', '103.253.47.183', '1695664698', '__ci_last_regenerate|i:1695664698;'), ('3tvqtvq08knaa2lbkpvc7val88f22nk2', '103.253.47.183', '1695664699', '__ci_last_regenerate|i:1695664699;'), ('9j3gipncko0q3ipmgc1u0dub9umn2a1c', '103.253.47.183', '1695664699', '__ci_last_regenerate|i:1695664699;'), ('55jejm8evhc9bv8f0bn0nm04sfg08r77', '103.253.47.183', '1695664699', '__ci_last_regenerate|i:1695664699;'), ('lc7h0be8genj5hg01ch5jhqembmontd2', '103.253.47.183', '1695664699', '__ci_last_regenerate|i:1695664699;'), ('uh30i0grl15g8bltdus7tmvq9fia2r0e', '103.253.47.183', '1695664700', '__ci_last_regenerate|i:1695664700;'), ('4rriootg62rgereskrcm005r5rcev2q3', '103.253.47.183', '1695664700', '__ci_last_regenerate|i:1695664700;'), ('vgf7glmqapt63mhmh8bli02bt58kc6ih', '103.253.47.183', '1695664700', '__ci_last_regenerate|i:1695664700;'), ('j69drab1d6pm6mm9peaku1sh7mutob34', '103.253.47.183', '1695664700', '__ci_last_regenerate|i:1695664700;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('msqhivmo7eb7fg99r6iqscl0kb079m67', '103.253.47.183', '1695664702', '__ci_last_regenerate|i:1695664702;'), ('7o4a72q3ju2qr7mkcr1aamne2l7g5tnu', '103.253.47.183', '1695664726', '__ci_last_regenerate|i:1695664726;'), ('suiqj8k8vhuv5nj4ll1sl4uf05urlbi2', '103.253.47.183', '1695664726', '__ci_last_regenerate|i:1695664726;'), ('ion0vlhiad5t2prqq3kevr7p8gnotj13', '103.253.47.183', '1695664726', '__ci_last_regenerate|i:1695664726;'), ('2l3ht7ss7gln6kg24e0tpl1puk4p233e', '103.253.47.183', '1695664726', '__ci_last_regenerate|i:1695664726;'), ('jjvo7ulnrsdhu2sqnldjo7of9s615ohq', '103.253.47.183', '1695664727', '__ci_last_regenerate|i:1695664727;'), ('u8abv5jk6oj9il1q8ngvsrk3dadh3k9e', '103.253.47.183', '1695664727', '__ci_last_regenerate|i:1695664727;'), ('a18bb61ph403aqt17bk0tig2bsca617p', '103.253.47.183', '1695664729', '__ci_last_regenerate|i:1695664729;'), ('cm6guoqhg31pt6e1rbmnhcsej2110r87', '103.253.47.183', '1695664730', '__ci_last_regenerate|i:1695664730;'), ('1mdo0t7pvei31sshlil8i824evdm5mak', '103.253.47.183', '1695664730', '__ci_last_regenerate|i:1695664730;'), ('7m304ptgr1pejg1qdkhmn20hlho38rif', '103.253.47.183', '1695664730', '__ci_last_regenerate|i:1695664730;'), ('5cf2mj0t3ivqvhq5jiglsdnvv30vnfes', '103.253.47.183', '1695664730', '__ci_last_regenerate|i:1695664730;'), ('m7r9hi0g8mm5ftjru73uvtgf95qg983c', '103.253.47.183', '1695664730', '__ci_last_regenerate|i:1695664730;'), ('mco3oig4b2gah8d8sq5me3mib32dhnoi', '103.253.47.183', '1695664731', '__ci_last_regenerate|i:1695664731;'), ('dnrfc35t814seqs0dknfclfiupackmod', '103.253.47.183', '1695664731', '__ci_last_regenerate|i:1695664731;'), ('tua42bc9ifvv5pdci583rk5vjtkkvkem', '103.253.47.183', '1695664731', '__ci_last_regenerate|i:1695664731;'), ('c2lm2os64u43kbvh2ujip6d6d6e7asrf', '103.253.47.183', '1695664731', '__ci_last_regenerate|i:1695664731;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('d81iq80erkr4ifqj9u3ob5pbpo0gtfvp', '103.253.47.183', '1695664733', '__ci_last_regenerate|i:1695664733;'), ('0n82vi7n6br2uj55ou71l912d5dsc6kp', '103.253.47.183', '1695664743', '__ci_last_regenerate|i:1695664743;'), ('lnmc3n6dje28et9e62shaimln40huseq', '103.253.47.183', '1695664756', '__ci_last_regenerate|i:1695664756;'), ('6002l7383d4qvgui2jc4i3scimtct77j', '103.253.47.183', '1695664758', '__ci_last_regenerate|i:1695664758;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('s9i2a2ch6cmeahcub0fvq9vjlv2fgj98', '103.253.47.183', '1695664758', '__ci_last_regenerate|i:1695664758;'), ('tjs1oujf7spv3i3qrk11780dr3j2jre5', '103.253.47.183', '1695664772', '__ci_last_regenerate|i:1695664772;'), ('d8htuqb433459mhavbvh3t3u1nh0f0da', '103.253.47.183', '1695664775', '__ci_last_regenerate|i:1695664775;'), ('mrr738mmmh05j9ina03f1jne5cjcf32g', '103.253.47.183', '1695664775', '__ci_last_regenerate|i:1695664775;'), ('ivioc252r1mtkmjh1t84qgivsddr78oh', '103.253.47.183', '1695664775', '__ci_last_regenerate|i:1695664775;'), ('b71vahrv0hen82v2b5t4aqk16ldim2rs', '103.253.47.183', '1695664775', '__ci_last_regenerate|i:1695664775;'), ('hsh6kihgcsgjbkg47qgsrik2l7omllug', '103.253.47.183', '1695664775', '__ci_last_regenerate|i:1695664775;'), ('c9bfevjr873s4j3oidhdjlem0u5u2sip', '103.253.47.183', '1695664775', '__ci_last_regenerate|i:1695664775;'), ('mklqi2t7esk9dc3aouqr8dkab07o0527', '103.253.47.183', '1695664776', '__ci_last_regenerate|i:1695664776;'), ('n4u5stp686r7ft6fj2iuihqksqnisdhi', '103.253.47.183', '1695664777', '__ci_last_regenerate|i:1695664777;'), ('13abb8airjjhf9fvbqqsgb1spne812o8', '103.253.47.183', '1695664777', '__ci_last_regenerate|i:1695664777;'), ('jda6c971a71sptcmjt3ej9mtbuusn3ab', '103.253.47.183', '1695664778', '__ci_last_regenerate|i:1695664778;'), ('t8idif0lots2tmbn378mfelp4c7qmbp9', '103.253.47.183', '1695664778', '__ci_last_regenerate|i:1695664778;'), ('hjb48d9b24f9vsrvcsj6e4ejfhc2165v', '103.253.47.183', '1695664778', '__ci_last_regenerate|i:1695664778;'), ('p5e6b0m3c136fkdl0527onrskpha5ucq', '103.253.47.183', '1695664778', '__ci_last_regenerate|i:1695664778;'), ('6aam84lhviu1j4qaibqhvddr53mjrivq', '103.253.47.183', '1695664778', '__ci_last_regenerate|i:1695664778;'), ('h6mn89i4ir5botg70k3f6qeosfog1kna', '103.253.47.183', '1695664778', '__ci_last_regenerate|i:1695664778;'), ('q2cs7ldgh3d784vb82assl70cr4veiit', '103.253.47.183', '1695664778', '__ci_last_regenerate|i:1695664778;'), ('sncctpdslmpdgjlcgu3c3v7hamjerege', '103.253.47.183', '1695664778', '__ci_last_regenerate|i:1695664778;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('cdl7v599u2413slgvgkrdg0bb02qb6co', '103.253.47.183', '1695664781', '__ci_last_regenerate|i:1695664781;'), ('bdsihf5tse10akd0qga2clstqsji6lhq', '103.253.47.183', '1695664782', '__ci_last_regenerate|i:1695664782;'), ('hhueel0qplrtlc2ftfdlup2a72rijve2', '103.253.47.183', '1695664801', '__ci_last_regenerate|i:1695664801;'), ('g56qvttf24c4bgl0h5ahh3kmgmp9hp3e', '103.253.47.183', '1695664803', '__ci_last_regenerate|i:1695664803;'), ('vabqo08a0g2agn9utg7iqbqlrbq92s5g', '103.253.47.183', '1695664805', '__ci_last_regenerate|i:1695664805;'), ('5hnhghkneakjg3vnqshjvg9pj0g5fjja', '103.253.47.183', '1695664806', '__ci_last_regenerate|i:1695664806;'), ('5e04pigtkpsvqcoosbmfchohh85jeshh', '103.253.47.183', '1695665028', '__ci_last_regenerate|i:1695665028;'), ('mugqtqj4ri8bmprnhukn5rtcs32gm4l4', '103.253.47.183', '1695665031', '__ci_last_regenerate|i:1695665031;'), ('4lkemg62llqbn49ftnrgch54fg849mjn', '103.253.47.183', '1695665031', '__ci_last_regenerate|i:1695665031;'), ('71aqrrh110p7kbt17sgs3ip82bal5cn3', '103.253.47.183', '1695665031', '__ci_last_regenerate|i:1695665031;'), ('ulkakt3eulckvut09ad4r603eijvo495', '103.253.47.183', '1695665031', '__ci_last_regenerate|i:1695665031;'), ('i4pkv8flqofqb17fgpe158c1cv2ki03t', '103.253.47.183', '1695665031', '__ci_last_regenerate|i:1695665031;'), ('12inbplkgjjm2hcjue2482nallkp70fu', '103.253.47.183', '1695665031', '__ci_last_regenerate|i:1695665031;'), ('oof7fn2ns9akojr2731cmvmk8f76eh09', '103.253.47.183', '1695665034', '__ci_last_regenerate|i:1695665034;'), ('i9mn69ik02lln76av7ddgp72dpn8npej', '103.253.47.183', '1695665034', '__ci_last_regenerate|i:1695665034;'), ('fpj0e1bme0m9c9le6l25fo22u0pq8p01', '103.253.47.183', '1695665035', '__ci_last_regenerate|i:1695665035;'), ('ic5p66q0pijbuocuisro8cirop56ge0f', '103.253.47.183', '1695665035', '__ci_last_regenerate|i:1695665035;'), ('qsh0go2fgikphgofmv8mv4vf3pa9l4r2', '103.253.47.183', '1695665035', '__ci_last_regenerate|i:1695665035;'), ('9vu4bga2g5e0e7qbhr4hcit9usarn747', '103.253.47.183', '1695665035', '__ci_last_regenerate|i:1695665035;'), ('osvnn09s0bis6ju9v3v978ubn83jrk1s', '103.253.47.183', '1695665035', '__ci_last_regenerate|i:1695665035;'), ('2nat9jmkr17dlg5h0o9j4d9fss340vmk', '103.253.47.183', '1695665036', '__ci_last_regenerate|i:1695665036;'), ('87am7s9q5g06k4h8ste5nblctkvbd3ej', '103.253.47.183', '1695665036', '__ci_last_regenerate|i:1695665036;'), ('4i7p6jn3lc656qkue2t80cjrqdb4ljd3', '103.253.47.183', '1695665036', '__ci_last_regenerate|i:1695665036;'), ('a9p3cul8smarmr1tqgdnlvi42s0ki55l', '103.253.47.183', '1695665036', '__ci_last_regenerate|i:1695665036;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('5jlar4u183su3e5egomlrnurstae8sl6', '103.253.47.183', '1695665038', '__ci_last_regenerate|i:1695665038;'), ('8cdt6j78fd6gggbe4v1jpb9r3cqvn9la', '103.253.47.183', '1695665058', '__ci_last_regenerate|i:1695665058;'), ('aab4an7vcvcf877fa0trg1htepfqvoco', '103.253.47.183', '1695665073', '__ci_last_regenerate|i:1695665073;'), ('mq53g85fekb5vknr771m8rrof5pjlsmg', '103.253.47.183', '1695665073', '__ci_last_regenerate|i:1695665073;'), ('ollufnopkq2uhsctu45ve6bt83qmp42s', '103.253.47.183', '1695665073', '__ci_last_regenerate|i:1695665073;'), ('952ae6smpmo6cdk14g1a37cl6of4bcjp', '103.253.47.183', '1695665073', '__ci_last_regenerate|i:1695665073;'), ('m9ehper8gngi3ltiska7n1jeo4ccuhld', '103.253.47.183', '1695665073', '__ci_last_regenerate|i:1695665073;'), ('7it8q3aq7bdj1usfqrklc81ro19s0ou6', '103.253.47.183', '1695665074', '__ci_last_regenerate|i:1695665074;'), ('puh3epnct4rom7490vt3bc90i3el40tk', '103.253.47.183', '1695665082', '__ci_last_regenerate|i:1695665082;'), ('bpmh1af1615t4np16sg7vr7e0id20a79', '103.253.47.183', '1695665083', '__ci_last_regenerate|i:1695665083;'), ('mi0fsm0tksf7aua86k09jlgan3oq1r6h', '103.253.47.183', '1695665084', '__ci_last_regenerate|i:1695665084;'), ('8p9u9u9vrol0li0fuc687kmo4lnd3ndk', '103.253.47.183', '1695665084', '__ci_last_regenerate|i:1695665084;'), ('sdij8jtu0jbd23iu6iqiru36hmi5r67p', '103.253.47.183', '1695665084', '__ci_last_regenerate|i:1695665084;'), ('vl0jav308j5jus56kv0j4lvscgac02e7', '103.253.47.183', '1695665084', '__ci_last_regenerate|i:1695665084;'), ('b113p59sc318f9gc9n7lc4kroqf0hpa5', '103.253.47.183', '1695665085', '__ci_last_regenerate|i:1695665085;'), ('53dik3457a6jrle27mscthp1ds08m829', '103.253.47.183', '1695665085', '__ci_last_regenerate|i:1695665085;'), ('1230l0aldkf0u3qll8j8p9qg026ge18u', '103.253.47.183', '1695665085', '__ci_last_regenerate|i:1695665085;'), ('lu90l37gjamarrlil646ca0qsr8eqg9f', '103.253.47.183', '1695665085', '__ci_last_regenerate|i:1695665085;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('lparg4691bmsg5lm5ei7kbj701tatb0f', '103.253.47.183', '1695665088', '__ci_last_regenerate|i:1695665088;'), ('6ufoimi431bpmmu7m694iuhpnppvi5t3', '103.253.47.183', '1695665101', '__ci_last_regenerate|i:1695665101;'), ('86khr6de5stm1d9ksmd3kldu559arcn9', '103.253.47.183', '1695665842', '__ci_last_regenerate|i:1695665842;'), ('peem04810bj0nrmq97du4vdvo8a388is', '103.253.47.183', '1695665845', '__ci_last_regenerate|i:1695665845;'), ('tb1fmcso6oumghd3dpm2m70m7jpf9uc1', '103.253.47.183', '1695665845', '__ci_last_regenerate|i:1695665845;'), ('jugihqf0pbfvrempjnvtj2oldn873qji', '103.253.47.183', '1695665845', '__ci_last_regenerate|i:1695665845;'), ('i4jeceu5dsd8vs50p34pkhqd4h100uqb', '103.253.47.183', '1695665845', '__ci_last_regenerate|i:1695665845;'), ('j0v010f0ilat5uerj2f2bat19305nf0d', '103.253.47.183', '1695665845', '__ci_last_regenerate|i:1695665845;'), ('t3pr71lo6i2frr8tagjtqaul11fdfhpc', '103.253.47.183', '1695665845', '__ci_last_regenerate|i:1695665845;'), ('juehuccevl0t77ibl6l3bcb32bjsmf66', '103.253.47.183', '1695665845', '__ci_last_regenerate|i:1695665845;'), ('r3dofh4gipcjabkfu10gicrc0gns0i64', '103.253.47.183', '1695665848', '__ci_last_regenerate|i:1695665848;'), ('c1rvaj5pokiup0dft0e8rt7akbv7jfu8', '103.253.47.183', '1695665861', '__ci_last_regenerate|i:1695665861;'), ('8kmuc8mob6kgnjuifkompsrsiqfstsl7', '103.253.47.183', '1695665862', '__ci_last_regenerate|i:1695665862;'), ('5cf5bv01s41stggsl14qtfgd82n6htp0', '103.253.47.183', '1695665862', '__ci_last_regenerate|i:1695665862;'), ('j6dsvrv3or5vpfeof113bek8uchjfi9d', '103.253.47.183', '1695665862', '__ci_last_regenerate|i:1695665862;'), ('jh7acoj2n7pc78ak2mfp5a16i5kvufqp', '103.253.47.183', '1695665862', '__ci_last_regenerate|i:1695665862;'), ('d370oola8a4linvkqnp4ejbh7lcsg58b', '103.253.47.183', '1695665862', '__ci_last_regenerate|i:1695665862;'), ('d1atamfq8t633dfjs057c4veu81misce', '37.111.217.8', '1695665911', '__ci_last_regenerate|i:1695665911;'), ('khp47k5ab1emohsjvl754a6jgcg3q7t5', '37.111.217.8', '1695665912', '__ci_last_regenerate|i:1695665912;'), ('n6lg18q3rkst7udilrf1t4c814u80317', '37.111.217.8', '1695665916', '__ci_last_regenerate|i:1695665916;'), ('ievcf0t1f7kq62oha6uonqcsoge2a1jv', '37.111.217.8', '1695665916', '__ci_last_regenerate|i:1695665916;'), ('gl0cg66cf9eo0ommjeth3buaqbbulpki', '37.111.217.8', '1695665917', '__ci_last_regenerate|i:1695665917;'), ('ojn3q10blr4st2uvpviu9c9cr1h9hc2j', '37.111.217.8', '1695665917', '__ci_last_regenerate|i:1695665917;'), ('l42rqvm3toq77a7jg3aa45lmll7e87ma', '37.111.217.8', '1695665993', '__ci_last_regenerate|i:1695665993;'), ('mdviphel7ev940513g53tjdul56hiamf', '37.111.217.8', '1695665993', '__ci_last_regenerate|i:1695665993;'), ('qv7f4jnjirgv41pvsgbnfe2vnctvdvhd', '37.111.217.8', '1695665993', '__ci_last_regenerate|i:1695665993;'), ('7tk5q0nafumk7n40fk3ek2jfp6f05ph9', '37.111.217.8', '1695665993', '__ci_last_regenerate|i:1695665993;'), ('su18rr2imjql9ir94motv95nnv1i90k6', '37.111.217.8', '1695665993', '__ci_last_regenerate|i:1695665993;'), ('s9bhkglnm85l0fj86ahqkhmv9n16n9gd', '37.111.217.8', '1695665993', '__ci_last_regenerate|i:1695665993;'), ('qmtc47ad6f0a7ptnkuuovo9vv9a6l9c8', '37.111.217.8', '1695665994', '__ci_last_regenerate|i:1695665994;'), ('hpr3ds612j588qi56ik62h33tqo8q2fs', '37.111.217.8', '1695665994', '__ci_last_regenerate|i:1695665994;'), ('5aiorpe1jhol2990an96val41hnr724a', '37.111.217.8', '1695665995', '__ci_last_regenerate|i:1695665995;'), ('uspc9moqmpi9h8cddsa12mlgasfk9st0', '37.111.217.8', '1695665997', '__ci_last_regenerate|i:1695665997;'), ('sjlu1b2qk6sa771m4d7rfdb9slh2hr3l', '37.111.217.8', '1695665997', '__ci_last_regenerate|i:1695665997;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('4uitq96tkspibmd0u397apj41u5tgu1i', '37.111.217.8', '1695665997', '__ci_last_regenerate|i:1695665997;'), ('2jjlb3f8fvc31lvcsncaecuq9gqduudo', '37.111.217.8', '1695665998', '__ci_last_regenerate|i:1695665998;'), ('1fppmmkbkv7eqg5p24250k366n47iu1i', '37.111.217.8', '1695665999', '__ci_last_regenerate|i:1695665999;'), ('mmts1c14i3fn08fjo31r5n5k6p0i68d5', '37.111.217.8', '1695666002', '__ci_last_regenerate|i:1695666002;'), ('51bq96jgmvf188qmuujrh3ruob4ikm4m', '37.111.217.8', '1695666004', '__ci_last_regenerate|i:1695666004;'), ('e9m7ppf420blj47kc0m411peficg415g', '37.111.217.8', '1695666004', '__ci_last_regenerate|i:1695666004;'), ('70qugkqv5mvu37v1elt517sgedmrauug', '37.111.217.8', '1695666005', '__ci_last_regenerate|i:1695666005;'), ('timobhjl3v523apd13pvn0a66aq96mh3', '37.111.217.8', '1695666005', '__ci_last_regenerate|i:1695666005;'), ('dcndb16g3a7i7d2fkt3npuk61ri6h436', '37.111.217.8', '1695666005', '__ci_last_regenerate|i:1695666005;'), ('hdt3qfn3n5268p53b7bdsioab3dgnb48', '37.111.217.8', '1695666005', '__ci_last_regenerate|i:1695666005;'), ('3kp6h1dltrheogehpcelk910kilcjav2', '37.111.217.8', '1695666005', '__ci_last_regenerate|i:1695666005;'), ('5ajrs943756k92ccntrf7tih9bgnmd8p', '37.111.217.8', '1695666005', '__ci_last_regenerate|i:1695666005;'), ('gt3knbiu6ue7gqbnoaug2ojlrtqkihtd', '37.111.217.8', '1695666018', '__ci_last_regenerate|i:1695666018;'), ('g78crcuo2psd8nnu8v7ggdb5oqjn3b9i', '37.111.217.8', '1695666022', '__ci_last_regenerate|i:1695666022;'), ('mdsj2pnpblgi5n0madofepolr5amhb69', '37.111.217.8', '1695666022', '__ci_last_regenerate|i:1695666022;'), ('2k5upadiigpfa3uauuco65g0j9ufsrt3', '37.111.217.8', '1695666022', '__ci_last_regenerate|i:1695666022;'), ('c0usatjj9svqrnfnhk81ca4c2oj26663', '37.111.217.8', '1695666022', '__ci_last_regenerate|i:1695666022;'), ('gd6a23tl4988a176vt647m024gvdq17i', '37.111.217.8', '1695666022', '__ci_last_regenerate|i:1695666022;'), ('dg5nmg10ate1su6sd343e7c40crn52b1', '37.111.217.8', '1695666022', '__ci_last_regenerate|i:1695666022;'), ('naq491pi5ssojm9rf9iqtfkn574cqi14', '37.111.217.8', '1695666022', '__ci_last_regenerate|i:1695666022;'), ('ti37qe1c89tusd2g1aj3gsv3iij6n686', '37.111.217.8', '1695666024', '__ci_last_regenerate|i:1695666024;'), ('hchjin2u4i376csgji0523tr47aisl57', '37.111.217.8', '1695666024', '__ci_last_regenerate|i:1695666024;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('barmus8j7pv23ekrgo193tl96llllga7', '37.111.217.8', '1695666025', '__ci_last_regenerate|i:1695666025;'), ('3pco5bahnqgfjn0idkf3hiknv2bgs7ap', '37.111.217.8', '1695666031', '__ci_last_regenerate|i:1695666031;'), ('kc0mgnjudnlbcsf99dob7grm79191u7d', '37.111.217.8', '1695666031', '__ci_last_regenerate|i:1695666031;'), ('394bo4omda05d9or50m92c89i1akjf2i', '37.111.217.8', '1695666031', '__ci_last_regenerate|i:1695666031;'), ('kgi4dld8f54rbm8olvks0m24ijrmlr1p', '37.111.217.8', '1695666031', '__ci_last_regenerate|i:1695666031;'), ('ps4alunvul0hodit3i3qt0ke8bcvk3o9', '37.111.217.8', '1695666031', '__ci_last_regenerate|i:1695666031;'), ('7bkav85quafmtkgg7vid70nid5ir4t4r', '37.111.217.8', '1695666031', '__ci_last_regenerate|i:1695666031;'), ('a7lfnvkmnufoe10h44jq6r8if3dtaomg', '37.111.217.8', '1695666053', '__ci_last_regenerate|i:1695666053;'), ('chcbod2i8p676l7kl7334ejiag5khmm6', '37.111.217.8', '1695666054', '__ci_last_regenerate|i:1695666054;'), ('t1d3o6ju9b2ofn95088mvm4ohu93btu5', '37.111.217.8', '1695666054', '__ci_last_regenerate|i:1695666054;'), ('fsjk12mcg605gm5j2s258m36s9oc33jp', '37.111.217.8', '1695666054', '__ci_last_regenerate|i:1695666054;'), ('d6hkbstm4rg80p3cc0q926mcecva1m82', '37.111.217.8', '1695666054', '__ci_last_regenerate|i:1695666054;'), ('06m49c41e262i09i4hui1olag8dvnnrr', '37.111.217.8', '1695666054', '__ci_last_regenerate|i:1695666054;'), ('qh1gv5ch4vp145tklnm9nhaa0uug0aes', '37.111.217.8', '1695666054', '__ci_last_regenerate|i:1695666054;'), ('huhmducea28a1udla3ni7pg8eqapr0qh', '37.111.217.8', '1695666054', '__ci_last_regenerate|i:1695666054;'), ('8tic4gu4284frn4kpaatibvh7np9q5so', '37.111.217.8', '1695666056', '__ci_last_regenerate|i:1695666056;'), ('ml2i93nl2akf9j2drnfqsusnb73h2fc5', '37.111.217.8', '1695801515', '__ci_last_regenerate|i:1695666056;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1696643298;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('9akc1d243jcveflni95uv19roeiem2km', '37.111.217.8', '1695666059', '__ci_last_regenerate|i:1695666059;'), ('aap6cfpos62j3ojjqr15fc08afbq3hrs', '37.111.217.8', '1695666060', '__ci_last_regenerate|i:1695666060;'), ('g19a0q1nshg5hvooel1r0gt99pcq75j1', '37.111.217.8', '1695666060', '__ci_last_regenerate|i:1695666060;'), ('ni1hncb85c2cj95vbescm88d59sckjbf', '37.111.217.8', '1695666060', '__ci_last_regenerate|i:1695666060;'), ('kla0jqr0so1f4hli4337mc1ihl39egqj', '37.111.217.8', '1695666060', '__ci_last_regenerate|i:1695666060;'), ('9q6kg05oradogb5hsp7f0u8vbvl7juj1', '37.111.217.8', '1695666060', '__ci_last_regenerate|i:1695666060;'), ('qse8tgffq1o49djthat811qvtrsf44jp', '37.111.217.8', '1695666060', '__ci_last_regenerate|i:1695666060;'), ('tek6vq6851oorjajq3j1r54p4g1781vq', '37.111.217.8', '1695666060', '__ci_last_regenerate|i:1695666060;'), ('n2qktcmdbvafji8a3vvjvd3k6orupa5s', '37.111.217.8', '1695666061', '__ci_last_regenerate|i:1695666061;'), ('h6ccrp0g9h6i19u2emjtdfvq8umed8bm', '37.111.217.8', '1695666061', '__ci_last_regenerate|i:1695666061;'), ('4rgpn5kapkjpqd60immpbu840cifo2vd', '37.111.217.8', '1695666061', '__ci_last_regenerate|i:1695666061;'), ('cq3ia9mtcnbbg95eb0tg6ilt5mj80np0', '37.111.217.8', '1695666061', '__ci_last_regenerate|i:1695666061;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ohbqq035vj1sn7avef36pqa8vk1ltsdn', '37.111.217.8', '1695666063', '__ci_last_regenerate|i:1695666063;'), ('4h4850d6btn09jprglacfmmpakufqar2', '37.111.217.8', '1695666064', '__ci_last_regenerate|i:1695666064;'), ('8oac3i31cgndgqujh6c4uvj4qddmgmlb', '37.111.217.8', '1695666065', '__ci_last_regenerate|i:1695666065;'), ('bc4q38r27j79nchms1srutng4fpkm4vt', '37.111.217.8', '1695666065', '__ci_last_regenerate|i:1695666065;'), ('uk0l6qoddptg7hqgomqfvv2hbuq6tic7', '37.111.217.8', '1695666065', '__ci_last_regenerate|i:1695666065;'), ('231ffnurm5iu3ba79rp2vefre0v4ge4s', '37.111.217.8', '1695666065', '__ci_last_regenerate|i:1695666065;'), ('fgec673k0ffkn5dvvtlpmqlppna9ddq2', '37.111.217.8', '1695666065', '__ci_last_regenerate|i:1695666065;'), ('qh2bftcl8v8duo5a2vn95o8u3nq29q54', '37.111.217.8', '1695666065', '__ci_last_regenerate|i:1695666065;'), ('4od3hqd3a6jfi5fbqagthv4bne4daikh', '37.111.217.8', '1695666065', '__ci_last_regenerate|i:1695666065;'), ('tidmj64p09bd16s44p8beq4ssa4sco6c', '37.111.217.8', '1695666065', '__ci_last_regenerate|i:1695666065;'), ('57c9lj6tinldul8tugbpfs03r6l3953n', '37.111.217.8', '1695666065', '__ci_last_regenerate|i:1695666065;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('gfj3tu6dp1svi57o958td8u27pq7g3ov', '37.111.217.8', '1695666065', '__ci_last_regenerate|i:1695666065;'), ('1vi71km19ji071t6f5u195l8j52it7in', '37.111.217.8', '1695666065', '__ci_last_regenerate|i:1695666065;'), ('v1noil20ak53d7uso7f99kdssdvscjmf', '37.111.217.8', '1695666069', '__ci_last_regenerate|i:1695666069;'), ('oc4gccccu97q0g34sq55uul2s1es4qr0', '37.111.217.8', '1695666069', '__ci_last_regenerate|i:1695666069;'), ('ls9t5qv202v18g94616kt8kun88as27i', '37.111.217.8', '1695666069', '__ci_last_regenerate|i:1695666069;'), ('ok2ii8urjodjjavreerefkd7siss6rbm', '37.111.217.8', '1695666069', '__ci_last_regenerate|i:1695666069;'), ('54as2fo212mc3s65t398iio01cqsc3pu', '37.111.217.8', '1695666071', '__ci_last_regenerate|i:1695666071;'), ('ko2gu20grmn2n1jqu3bqs58f5c3jqcem', '37.111.217.8', '1695666071', '__ci_last_regenerate|i:1695666071;'), ('q6066gv873ena7ssdfp620g5vac5ner7', '37.111.217.8', '1695666072', '__ci_last_regenerate|i:1695666072;'), ('rvrvujfe18qesb9bcfuioof22d65atl4', '37.111.217.8', '1695666072', '__ci_last_regenerate|i:1695666072;'), ('i6jc2lar8tdj1g3srbufntf2i5iribii', '37.111.217.8', '1695666072', '__ci_last_regenerate|i:1695666072;'), ('t85f0eba42c3774bk3for75d8r2q15ag', '37.111.217.8', '1695666072', '__ci_last_regenerate|i:1695666072;'), ('uajnhe4g4qp4o1o8c6m4ehcrnaog4dk4', '37.111.217.8', '1695666072', '__ci_last_regenerate|i:1695666072;'), ('8bp884gfopfojpqiqpld0fmngdm9mees', '37.111.217.8', '1695666072', '__ci_last_regenerate|i:1695666072;'), ('36ea34omqrfjtdnr9pnl5c8sj5agfl3g', '37.111.217.8', '1695666072', '__ci_last_regenerate|i:1695666072;'), ('jo6llvv872u5oljsnu1a5gbkavgc8sug', '37.111.217.8', '1695666073', '__ci_last_regenerate|i:1695666073;'), ('rri5vqp1mecbsjp1370qhhbjphbdoibq', '37.111.217.8', '1695666073', '__ci_last_regenerate|i:1695666073;'), ('8qrhcim77lr7t9o0n1187lmn5mjf2aj2', '37.111.217.8', '1695666073', '__ci_last_regenerate|i:1695666073;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('127piji7gpkfm5q264tskjait414v0ou', '37.111.217.8', '1695666073', '__ci_last_regenerate|i:1695666073;'), ('5s8ms8ga21nos1uhmvoa1okv0upeso0m', '37.111.217.8', '1695666075', '__ci_last_regenerate|i:1695666075;'), ('fllj3g42v0o3viipv8vvstuefnujedec', '37.111.217.8', '1695666082', '__ci_last_regenerate|i:1695666082;'), ('7jmmpqoarkrmn3efv1hqe401hfg7q60h', '37.111.217.8', '1695666088', '__ci_last_regenerate|i:1695666088;'), ('tpk34gh113b9op7ldrcac1k9qjq4k91m', '37.111.217.8', '1695666088', '__ci_last_regenerate|i:1695666088;'), ('9jfn07lfcn1d2t4drp0qb0q5sb4jd8kc', '37.111.217.8', '1695666089', '__ci_last_regenerate|i:1695666089;'), ('2np12tqbpg5eja46cdqdk6miocsjn5gs', '37.111.217.8', '1695666089', '__ci_last_regenerate|i:1695666089;'), ('3jvjd154077im7fh9hflmq60u3fr67qd', '37.111.217.8', '1695666089', '__ci_last_regenerate|i:1695666089;'), ('7md842odes2ajpa2ad1t4n0l6piiakr6', '37.111.217.8', '1695666089', '__ci_last_regenerate|i:1695666089;'), ('m3rk3psl3kn1fjnrm7v61p1pso1pne33', '37.111.217.8', '1695666089', '__ci_last_regenerate|i:1695666089;'), ('67g0bmpmvdb8prfl4tuq83e4g0u4mp2k', '37.111.217.8', '1695666089', '__ci_last_regenerate|i:1695666089;'), ('iuvj9n76n0e9gm7kunallq8asf6qf79e', '37.111.217.8', '1695666100', '__ci_last_regenerate|i:1695666100;'), ('gd9atqd3ajkutajeiq3s9cjkq3m043li', '37.111.217.8', '1695666112', '__ci_last_regenerate|i:1695666112;'), ('60vll4b82gopdaqp88nbsrhg82aud7an', '37.111.217.8', '1695666112', '__ci_last_regenerate|i:1695666112;'), ('m6krbv0mk5p1rrrcf2psd26ook75nmlt', '37.111.217.8', '1695666112', '__ci_last_regenerate|i:1695666112;'), ('7kncugfhe8meu9j0io9d8tdlu9q2lsd3', '37.111.217.8', '1695666112', '__ci_last_regenerate|i:1695666112;'), ('e48u03pko3t5rn0snajegbk2j6sea8bk', '37.111.217.8', '1695666112', '__ci_last_regenerate|i:1695666112;'), ('lmir2n76qrnbotfe9dbljhs5r2cppcci', '37.111.217.8', '1695666114', '__ci_last_regenerate|i:1695666114;'), ('3avs1oilf7eu9jq6gebatkn9qeujdnq5', '37.111.217.8', '1695666114', '__ci_last_regenerate|i:1695666114;'), ('fnm2gpiqh5gksc9tm6us2fdi5i4v9f2f', '103.67.158.53', '1695666886', '__ci_last_regenerate|i:1695666886;'), ('rkdqkmuq56l38ktn1n2j2notpi6qlli6', '103.67.158.53', '1695666889', '__ci_last_regenerate|i:1695666889;'), ('12td7skk4bljmutbtmqpl4nk1maaktgi', '103.67.158.53', '1695666889', '__ci_last_regenerate|i:1695666889;'), ('si9osoqam4bf2e02cok8tbc5ukpk11p3', '103.67.158.53', '1695666889', '__ci_last_regenerate|i:1695666889;'), ('sstdo8orc0u0hv4cah18hf7ssil4vist', '103.67.158.53', '1695666889', '__ci_last_regenerate|i:1695666889;'), ('fl988q7gcjgdl6l1rakjd5lpmftp4319', '103.67.158.53', '1695666889', '__ci_last_regenerate|i:1695666889;'), ('q683f3ou1tc2nba4sq2seq19utokr3e8', '103.67.158.53', '1695666889', '__ci_last_regenerate|i:1695666889;'), ('vd5s4465mebomn55usr5jlcmmcbkbgca', '103.67.158.53', '1695666890', '__ci_last_regenerate|i:1695666890;'), ('8dck3lhgth981frv7kdej8bqj7f3ro00', '103.67.158.53', '1695666890', '__ci_last_regenerate|i:1695666890;'), ('vrc3g13t74liil7obl167c2eq8ekrkgf', '103.67.158.53', '1695666891', '__ci_last_regenerate|i:1695666891;'), ('ska5ucvsf90evktuqlfpm7et8fb69b3i', '103.67.158.53', '1695666891', '__ci_last_regenerate|i:1695666891;'), ('iuntdml4s77tr98tg2lgkpgktfv3fo4j', '103.67.158.53', '1695666891', '__ci_last_regenerate|i:1695666891;'), ('fsk38q3cr531itkolq0asvber7mchcoo', '103.67.158.53', '1695666891', '__ci_last_regenerate|i:1695666891;'), ('qk0asg34c23nuce32b67m61a4ee87ebo', '103.67.158.53', '1695666891', '__ci_last_regenerate|i:1695666891;'), ('71n4h8bfr9vh77oiennnh45uar8curjv', '103.67.158.53', '1695666891', '__ci_last_regenerate|i:1695666891;'), ('a5p572ias8mdsj4c6c7u3eech7a3fuog', '103.67.158.53', '1695666891', '__ci_last_regenerate|i:1695666891;'), ('7aimot19nn4cfl7qet1pjjumsv6p9tvg', '103.67.158.53', '1695666892', '__ci_last_regenerate|i:1695666892;'), ('f14hggnc586fhjvm6btuq4idn2iraheo', '103.67.158.53', '1695666892', '__ci_last_regenerate|i:1695666892;'), ('cv7mnarijute542rrhpbm9o2ufdfh3qf', '103.67.158.53', '1695666892', '__ci_last_regenerate|i:1695666892;'), ('h2bedfd3dava62orjf6o98k0p043mdaj', '103.67.158.53', '1695666893', '__ci_last_regenerate|i:1695666892;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('gmu959pl5turq3rerschl34u8bbd2dg9', '103.67.158.53', '1695666896', '__ci_last_regenerate|i:1695666896;'), ('5jrlgvutfve71nr7r1nesink72f396nt', '103.67.158.53', '1695666896', '__ci_last_regenerate|i:1695666896;'), ('6f3pvmjabcc07jrlg9otf1nkfqi4b3f4', '103.67.158.53', '1695666896', '__ci_last_regenerate|i:1695666896;'), ('b2ckrp3hqv05f211pu5gihcj3bvoa799', '103.67.158.53', '1695666896', '__ci_last_regenerate|i:1695666896;'), ('8e3ulq1soel38396iig4cm7hgi8rcos1', '103.67.158.53', '1695666896', '__ci_last_regenerate|i:1695666896;'), ('l4auiqk1s6on61puudqadccu53fuujuf', '103.67.158.53', '1695666896', '__ci_last_regenerate|i:1695666896;'), ('kau0c7mmhcad5cn9s0614mnr4lv1n0q5', '103.67.158.53', '1695666898', '__ci_last_regenerate|i:1695666898;'), ('49js78363dnh5m1cg42g7iqvr8392aqv', '103.67.158.53', '1695666898', '__ci_last_regenerate|i:1695666898;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ehv7sl9rv5tuq2nisg86lpmeicqgrlpr', '103.67.158.53', '1695666898', '__ci_last_regenerate|i:1695666898;'), ('q23aqj6lu1ekpd0l99dqkht0pv04bol7', '103.67.158.53', '1695666899', '__ci_last_regenerate|i:1695666899;'), ('11docm2ge47d83o06ia3lkim6tm6umas', '103.67.158.53', '1695666900', '__ci_last_regenerate|i:1695666900;'), ('97vhjk0jfltqg91j41gs8ratvpr87blb', '103.67.158.53', '1695667042', '__ci_last_regenerate|i:1695667042;'), ('blkkeu8s8fu953uuqd6u0o8uafmspb9m', '103.67.158.53', '1695667042', '__ci_last_regenerate|i:1695667042;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ipo9f4cje0l0g3gnhujfc18i8crc0c3c', '103.67.158.53', '1695667043', '__ci_last_regenerate|i:1695667043;'), ('46dgdcu1rsrg5rg9drmhiauoopnvh36d', '103.67.158.53', '1695667043', '__ci_last_regenerate|i:1695667043;'), ('3tpt1gqrfsitolp15ev3vhdgg1m0381v', '103.67.158.53', '1695667044', '__ci_last_regenerate|i:1695667044;'), ('6tg7p2rs9ligo6kt54qb6fq046n7n1eq', '103.67.158.53', '1695667114', '__ci_last_regenerate|i:1695667114;'), ('2pmio6cnb81nbg9undbrp282tatb6lev', '103.67.158.53', '1695667115', '__ci_last_regenerate|i:1695667115;'), ('hif6hq3dtnmtde7hme2ovfh9b8oocl4a', '103.67.158.53', '1695667115', '__ci_last_regenerate|i:1695667115;'), ('v5u8uue8am7kfib7fq0t20gkf1vspsb6', '103.67.158.53', '1695667115', '__ci_last_regenerate|i:1695667115;'), ('s5b1rknlobfel4uoftgdjru9guiluafd', '103.67.158.53', '1695667115', '__ci_last_regenerate|i:1695667115;'), ('ri6jhgqu2g2jk6u1fdl77a03fmt1vb42', '103.67.158.53', '1695667115', '__ci_last_regenerate|i:1695667115;'), ('vtrifuv0dht702msaeupij35h59a6tkt', '103.67.158.53', '1695667116', '__ci_last_regenerate|i:1695667116;'), ('qstkvc6h3nobuhl4in9ldiftpl5904vo', '103.67.158.53', '1695667117', '__ci_last_regenerate|i:1695667117;'), ('72cb6frrj3c89u38l8980a7qsfkdhj8s', '103.67.158.53', '1695667117', '__ci_last_regenerate|i:1695667117;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('33kl7icug66s6tddpl8lssgj6vo3655e', '103.67.158.53', '1695667117', '__ci_last_regenerate|i:1695667117;'), ('m3d6ev8gt1467f4im1ui6vhsglrjb9i6', '103.67.158.53', '1695667118', '__ci_last_regenerate|i:1695667118;'), ('l1dfq2l7nnu5jd6i2hiv2esd4311om7r', '103.67.158.53', '1695667118', '__ci_last_regenerate|i:1695667118;'), ('ovifb1bhq7oip2cv36trc0k4744sgmq3', '103.67.158.53', '1695667120', '__ci_last_regenerate|i:1695667120;'), ('tjfd2q6rtvveq1i3gfq43u85r8okgi1g', '103.67.158.53', '1695667279', '__ci_last_regenerate|i:1695667279;'), ('rdhij2hp6khba5s0cogm8gk4o6ghgs01', '103.67.158.53', '1695667279', '__ci_last_regenerate|i:1695667279;'), ('1ppnqqvp446iopspqv0rho56fmf7af1u', '103.67.158.53', '1695667280', '__ci_last_regenerate|i:1695667280;'), ('o8negf7bbole5d64vqlipgpubrgi8qab', '103.67.158.53', '1695667280', '__ci_last_regenerate|i:1695667280;'), ('chufdh6mh4rgdcuhj1ct9ilqgd3lh4em', '103.67.158.53', '1695667280', '__ci_last_regenerate|i:1695667280;'), ('ir2bjm98fibgv3234e241lkj53e2omgj', '103.67.158.53', '1695667280', '__ci_last_regenerate|i:1695667280;'), ('j7akilm7kmlb8hotvm3p8p9jgrntum7a', '103.67.158.53', '1695667280', '__ci_last_regenerate|i:1695667280;'), ('mve52hr011gd9l1fa5fkiok0c2tdgg3u', '103.67.158.53', '1695667280', '__ci_last_regenerate|i:1695667280;'), ('1f1pr9ua8o0lcfkjoll210iio39l6hof', '103.67.158.53', '1695667280', '__ci_last_regenerate|i:1695667280;'), ('used6sc9curuvg01tu4ii502tr78sudl', '103.67.158.53', '1695667280', '__ci_last_regenerate|i:1695667280;'), ('a4ogi85aj8p30dd8icmj9c0rn59m28h1', '103.67.158.53', '1695667280', '__ci_last_regenerate|i:1695667280;'), ('keo46su6jn4kvedbuaoc6fd09hm17thp', '103.67.158.53', '1695667280', '__ci_last_regenerate|i:1695667280;'), ('62qsrp59ugtu9o176g3ja4p2hm166q73', '103.67.158.53', '1695667281', '__ci_last_regenerate|i:1695667281;'), ('v3nkfgsok59bkl6f3un4lgn9hbhbp8bd', '103.67.158.53', '1695667282', '__ci_last_regenerate|i:1695667282;'), ('n30vkkrir0g02rmi7hbeno7917g6l3dv', '103.67.158.53', '1695667282', '__ci_last_regenerate|i:1695667282;'), ('kveid1l6eltapk1ierhkl44pgrrlnv3b', '103.67.158.53', '1695667288', '__ci_last_regenerate|i:1695667288;'), ('22dfkni1d14n17en3hc43ga9fuhgokh7', '103.67.158.53', '1695667288', '__ci_last_regenerate|i:1695667288;'), ('1r4dmui1ko2jepuql5tmvogn80cbl5uk', '103.67.158.53', '1695667289', '__ci_last_regenerate|i:1695667289;'), ('4i8aq8lf14sodpvmghvi4184t4p2pfvl', '103.67.158.53', '1695667430', '__ci_last_regenerate|i:1695667430;'), ('b0juk6tjv2f5ic41afj7urerp2gl3k0p', '103.67.158.53', '1695667430', '__ci_last_regenerate|i:1695667430;'), ('qpfbqf96j3p7loamcqlgj8u4hb996pc9', '103.67.158.53', '1695667435', '__ci_last_regenerate|i:1695667435;'), ('m2k3m1bvevd9b1lskfcntajehch8mmbm', '103.67.158.53', '1695667435', '__ci_last_regenerate|i:1695667435;'), ('o99vbvduffmfr07a6vlod4l0iau9kiqp', '103.67.158.53', '1695667436', '__ci_last_regenerate|i:1695667436;'), ('dkgq15iid9nlv65n6s765rn3ns2tbotu', '103.67.158.53', '1695667440', '__ci_last_regenerate|i:1695667440;'), ('5n9qch9qmakssh62lvru62hiovuipufp', '103.67.158.53', '1695667441', '__ci_last_regenerate|i:1695667441;'), ('e0q44judr6l7lhu77ht4jreuolnmgn0c', '103.67.158.53', '1695667441', '__ci_last_regenerate|i:1695667441;'), ('7hef6ecbm0r2n5d7i9nj57q1l2348vab', '103.67.158.53', '1695667441', '__ci_last_regenerate|i:1695667441;'), ('qbkqjfkpj0ea8u5vf0vuta9klon578q8', '103.67.158.53', '1695667441', '__ci_last_regenerate|i:1695667441;'), ('rurfpk5qa5jlmrfmapolq31svv9pfr1d', '103.67.158.53', '1695667441', '__ci_last_regenerate|i:1695667441;'), ('ats9ek0ob42rrk77c9dc5dph4s8s97ol', '103.67.158.53', '1695667441', '__ci_last_regenerate|i:1695667441;'), ('stndfrnb3n57c86foolcsh44k7i07hhg', '103.67.158.53', '1695667441', '__ci_last_regenerate|i:1695667441;'), ('m9ndf4po8pt9j3oscruk9h231rpg6val', '103.67.158.53', '1695667442', '__ci_last_regenerate|i:1695667442;'), ('9c8mopg0q78kmb8lum9go7rf3hpuoh73', '103.67.158.53', '1695667443', '__ci_last_regenerate|i:1695667443;'), ('6qhnbn8fnsuhb2o2q2b9vvvbie71hg2l', '103.67.158.53', '1695667443', '__ci_last_regenerate|i:1695667443;'), ('hoc6sf475hf44n94n2eo9val5ntqqom7', '103.67.158.53', '1695667443', '__ci_last_regenerate|i:1695667443;'), ('33pm0o1kut41r1aguvfi0g4h0gp44tta', '103.67.158.53', '1695667445', '__ci_last_regenerate|i:1695667445;'), ('rcboe8tokpa69g64agnf0gs0ph76r42c', '103.67.158.53', '1695667445', '__ci_last_regenerate|i:1695667445;'), ('s4vrjhk7bj0j5nh6qdioa1gc2prsfac3', '103.67.158.53', '1695667445', '__ci_last_regenerate|i:1695667445;'), ('56ttskbud9nam72rr0g5a743chuufoq0', '103.67.158.53', '1695667445', '__ci_last_regenerate|i:1695667445;'), ('uovb19t34jf4sel8pfsmhbk5qd8tnpia', '103.67.158.53', '1695667445', '__ci_last_regenerate|i:1695667445;'), ('rthfudgepadvjf0941tm6as1a734lcjj', '103.67.158.53', '1695667446', '__ci_last_regenerate|i:1695667446;'), ('80lrfr5ikhelj2760q120kh4s6lt3qpf', '103.67.158.53', '1695667447', '__ci_last_regenerate|i:1695667447;'), ('pau10ut87rgfq3f18khnfpijggf7eamo', '103.67.158.53', '1695667447', '__ci_last_regenerate|i:1695667447;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ghf5s1mnab5ahvnmbvna8vujs31qk6v3', '103.67.158.53', '1695667448', '__ci_last_regenerate|i:1695667448;'), ('o9m8ch53ov5a5ou8vlbl9qvsifpefcm6', '103.67.158.53', '1695667450', '__ci_last_regenerate|i:1695667450;'), ('3aljg2jm5em8uqgeusr2maleupolvj1f', '103.67.158.53', '1695667451', '__ci_last_regenerate|i:1695667451;'), ('8gbbs7tk21d9mu1db1s36uohk1rs45cf', '103.67.158.53', '1695667978', '__ci_last_regenerate|i:1695667978;'), ('sucpffmcmbas41m59cb9fua5lgtapbdp', '103.67.158.53', '1695667978', '__ci_last_regenerate|i:1695667978;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('gh3scfcb44j65ihtutlmd8gci6ekjgco', '103.67.158.53', '1695667979', '__ci_last_regenerate|i:1695667979;'), ('f89u1lj8umo9cntps668414bmgfeuhap', '103.67.158.53', '1695667980', '__ci_last_regenerate|i:1695667980;'), ('6alcjivu0v0skb2rq18mrqu67c9pphv0', '103.67.158.53', '1695667980', '__ci_last_regenerate|i:1695667980;'), ('gft4q70099f9m9j79tbsatcvah9s75tp', '103.67.158.53', '1695667990', '__ci_last_regenerate|i:1695667990;'), ('pieeb2cil1m3ta0591qe7vr7hlrpljo0', '103.67.158.53', '1695667990', '__ci_last_regenerate|i:1695667990;'), ('0ie2pr1mfu4noslg36hjvvhrrbrccshv', '116.58.203.107', '1695668285', '__ci_last_regenerate|i:1695668285;'), ('0tu4ss20jv3r4mn6ugp45ecnhb64v75p', '116.58.203.107', '1695668288', '__ci_last_regenerate|i:1695668288;'), ('onbrgqrj4u4iu71aeuhcen6hrl5mei6d', '116.58.203.107', '1695668288', '__ci_last_regenerate|i:1695668288;'), ('q3vh4qdkn8ee684tqsvss36q6eb2dv4c', '116.58.203.107', '1695668288', '__ci_last_regenerate|i:1695668288;'), ('njde2bhvil2k9b0n2aptcgqb02gnjbhq', '116.58.203.107', '1695668288', '__ci_last_regenerate|i:1695668288;'), ('ht0aavhfg8b1anjeq634c9kfvicijhhg', '116.58.203.107', '1695668288', '__ci_last_regenerate|i:1695668288;'), ('5enpg5onjjsneh30oma22olqfnqsg690', '116.58.203.107', '1695668288', '__ci_last_regenerate|i:1695668288;'), ('lcshmn7uijt1t201bhnbe3aojj85so1v', '116.58.203.107', '1695668288', '__ci_last_regenerate|i:1695668288;'), ('nck3f2j4c7trqvc4jief1d54v5quib39', '116.58.203.107', '1695668291', '__ci_last_regenerate|i:1695668291;'), ('81g3mk6inng59qk9o59bu5ndm92b1oni', '116.58.203.107', '1695668292', '__ci_last_regenerate|i:1695668292;'), ('58qib934i4mfihpviphf0m9t0moad7fm', '116.58.203.107', '1695668293', '__ci_last_regenerate|i:1695668293;'), ('06ssatbdf94igb6r5mh1qf4tja5tdqrj', '116.58.203.107', '1695668293', '__ci_last_regenerate|i:1695668293;'), ('ttpn5pvea6q25sm0rmsn3ghp969kbhum', '116.58.203.107', '1695668293', '__ci_last_regenerate|i:1695668293;'), ('qiaoojl91idm1habh5vomsn5k75g3a24', '116.58.203.107', '1695668293', '__ci_last_regenerate|i:1695668293;'), ('5s528p85kmnf7i58eltnaj3rf3dk2ldv', '116.58.203.107', '1695668293', '__ci_last_regenerate|i:1695668293;'), ('t3929u9jfrcq1818i02es2ksmlko3dm8', '116.58.203.107', '1695668293', '__ci_last_regenerate|i:1695668293;'), ('8skfii2dgh05a8u9ausoal90rdovsfha', '116.58.203.107', '1695668295', '__ci_last_regenerate|i:1695668295;'), ('je5hj0cgdooqtdko4apnjhsl0be255hg', '116.58.203.107', '1695668295', '__ci_last_regenerate|i:1695668295;'), ('ii8tk7gl3lf69ra21jvar98r0k0fevcb', '116.58.203.107', '1695668295', '__ci_last_regenerate|i:1695668295;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('obe4t956fpha00rtaaelpohmi8253tjm', '116.58.203.107', '1695668295', '__ci_last_regenerate|i:1695668295;'), ('c1v988buttpj0nfer9361g2720rc6g71', '116.58.203.107', '1695668297', '__ci_last_regenerate|i:1695668297;'), ('fphjlbdi0q6olbi044f0cifhega08thk', '116.58.203.107', '1695668309', '__ci_last_regenerate|i:1695668309;'), ('0806novnsrdufiran84m68rb3ne63mcn', '116.58.203.107', '1695668317', '__ci_last_regenerate|i:1695668317;'), ('icrgcakgl4s5mu63t3d4pt5l16ojal5m', '116.58.203.107', '1695668317', '__ci_last_regenerate|i:1695668317;'), ('i5olhbu8obehrn64p026grmd2ibjq2t6', '116.58.203.107', '1695668456', '__ci_last_regenerate|i:1695668456;'), ('41ijgjm796dqr8imb7rhcu8bgefpj65t', '116.58.203.107', '1695668457', '__ci_last_regenerate|i:1695668457;'), ('qbo5t1krebd0da10al3f9qsm60lms5kl', '116.58.203.107', '1695668457', '__ci_last_regenerate|i:1695668457;'), ('llulgik9t3t81ubdpfaumdcjg9jkls4e', '116.58.203.107', '1695668457', '__ci_last_regenerate|i:1695668457;'), ('799atsh542hor0jetelegnrg7940d9d4', '116.58.203.107', '1695668457', '__ci_last_regenerate|i:1695668457;'), ('t4j722l64h9c5li70sc845cueabr2lq9', '116.58.203.107', '1695668457', '__ci_last_regenerate|i:1695668457;'), ('4v8tcmsn2usp4k64ds91otaqqa19g9he', '116.58.203.107', '1695668457', '__ci_last_regenerate|i:1695668457;'), ('u3b37muqagg0l89ihd6r50cha7oouusp', '116.58.203.107', '1695668457', '__ci_last_regenerate|i:1695668457;'), ('1us6khn83ojlbbgk8ud15thtr3s3ibfg', '116.58.203.107', '1695668459', '__ci_last_regenerate|i:1695668459;'), ('kkpmj704m0iu2lil5fket5k9gdd8qlb2', '116.58.203.107', '1695668459', '__ci_last_regenerate|i:1695668459;'), ('hqlcba03g2er57fd4pkvj724mck566ki', '116.58.203.107', '1695668459', '__ci_last_regenerate|i:1695668459;'), ('b3519v30a8uaoi6se73ph3o8ecdjqdqq', '116.58.203.107', '1695668459', '__ci_last_regenerate|i:1695668459;'), ('nd2ucnmmg3enp6udiung8v8203rf2np8', '116.58.203.107', '1695668459', '__ci_last_regenerate|i:1695668459;'), ('l23oqmrju0vrs215of7n7jl5hptqeitf', '116.58.203.107', '1695668460', '__ci_last_regenerate|i:1695668460;'), ('hlnolhnajersa6n2pur9lck0r0s4jahf', '116.58.203.107', '1695668461', '__ci_last_regenerate|i:1695668461;'), ('7kdfqk8qavfgumcgk3urfjk941oqjgq8', '116.58.203.107', '1695668464', '__ci_last_regenerate|i:1695668464;'), ('k8binpkdifvditk3331gpe85tcn37akv', '116.58.203.107', '1695668465', '__ci_last_regenerate|i:1695668465;'), ('109agj2c8sj41gdsmska5htev33nnd2p', '116.58.203.107', '1695668465', '__ci_last_regenerate|i:1695668465;'), ('shsugaq6kg973m6r5k3ekinoq3e63rva', '116.58.203.107', '1695668465', '__ci_last_regenerate|i:1695668465;'), ('p9252cd2k2qkngf3esjhi1k23jnbdd19', '116.58.203.107', '1695668465', '__ci_last_regenerate|i:1695668465;'), ('fh16dbnflv2mb5tolmh7bgco0u0s7bhg', '116.58.203.107', '1695668465', '__ci_last_regenerate|i:1695668465;'), ('ret4h52qj78hrtm71c2b16guinknqh7e', '116.58.203.107', '1695668465', '__ci_last_regenerate|i:1695668465;'), ('nhv31nf83nemnr60sk740867g7l059pc', '116.58.203.107', '1695668465', '__ci_last_regenerate|i:1695668465;'), ('70tpgth6j1kp5s7hep3tbj3gv1qab20b', '116.58.203.107', '1695668467', '__ci_last_regenerate|i:1695668467;'), ('dicuidfc4qnpummrujjanfp2nn845ae3', '116.58.203.107', '1695668486', '__ci_last_regenerate|i:1695668486;'), ('7ojda83hrbrn5b9ar4is46h5s24svrip', '116.58.203.107', '1695668486', '__ci_last_regenerate|i:1695668486;'), ('hem9etaaf2aosjh0mfgpvcd63eo8iflt', '116.58.203.107', '1695668486', '__ci_last_regenerate|i:1695668486;'), ('lqmitftt9tcmiulh6vmo9m28g931uhpv', '116.58.203.107', '1695668486', '__ci_last_regenerate|i:1695668486;'), ('uhgvt9te3l0b4omb961sj5f2pq81s87h', '116.58.203.107', '1695668487', '__ci_last_regenerate|i:1695668487;'), ('6k1qbo55ff76q63ibf8moo9s23ipn28h', '116.58.203.107', '1695668489', '__ci_last_regenerate|i:1695668489;'), ('ltk1859fo21ai6h0lb2k1qqn8l1pemm2', '116.58.203.107', '1695668489', '__ci_last_regenerate|i:1695668489;'), ('jfaff73qh7vpu8ukdlrlkp5fjvrc7u48', '116.58.203.107', '1695668489', '__ci_last_regenerate|i:1695668489;'), ('jb9cbfnssfnprout2t58fimiukrkcnbc', '116.58.203.107', '1695668489', '__ci_last_regenerate|i:1695668489;'), ('9uhmr02knffnikndnl9qjppsf947g6p3', '116.58.203.107', '1695668489', '__ci_last_regenerate|i:1695668489;'), ('ko3f0hqo569ff2ab4u9q50mnmrbk6oun', '116.58.203.107', '1695668490', '__ci_last_regenerate|i:1695668490;'), ('r1120m8t2ibcavjrvtqd21fhrusc37hg', '86.62.192.48', '1695672674', '__ci_last_regenerate|i:1695672674;'), ('g6iv5e21b6hkkgfi6g813bu8k9m1cuht', '86.62.192.48', '1695672677', '__ci_last_regenerate|i:1695672677;'), ('asns37i00dggh8uio448j801a7mf1ove', '86.62.192.48', '1695672677', '__ci_last_regenerate|i:1695672677;'), ('69j7fh2vkdgp3r5ankuhinil1n5f2tnv', '86.62.192.48', '1695672677', '__ci_last_regenerate|i:1695672677;'), ('hst7r7gr9s5plp15i8fs0q77h06pef6b', '86.62.192.48', '1695672677', '__ci_last_regenerate|i:1695672677;'), ('lnm2hut95r3k7a1bt9a5alodj82l4mru', '86.62.192.48', '1695672677', '__ci_last_regenerate|i:1695672677;'), ('lf59o1ah5e234on425a75gri11ht2i6k', '86.62.192.48', '1695672677', '__ci_last_regenerate|i:1695672677;'), ('2ajq3msus3flopq9hgft2lq4p4cn2j7s', '86.62.192.48', '1695672678', '__ci_last_regenerate|i:1695672678;'), ('njql2br79c76u4qm855m8aqi72t3i7mu', '86.62.192.48', '1695672683', '__ci_last_regenerate|i:1695672683;'), ('vh4k8pp1ohfd9sqa97t8i139t00goauv', '86.62.192.48', '1695672683', '__ci_last_regenerate|i:1695672683;'), ('bpdo4eiqf9s03p7c3niv0vmk6m2b9dl0', '86.62.192.48', '1695672685', '__ci_last_regenerate|i:1695672685;'), ('cga1s6768d3tq1ha0qf5jpv6k5gqho9g', '86.62.192.48', '1695672685', '__ci_last_regenerate|i:1695672685;'), ('endconjkitsct3l443udf5oegjnh1f8b', '86.62.192.48', '1695672688', '__ci_last_regenerate|i:1695672688;'), ('q6da5tdbio4a0qno4br86nmnjj56hmli', '86.62.192.48', '1695672688', '__ci_last_regenerate|i:1695672688;'), ('f22p4f6jv44hd5r843en80pcc58u2ch8', '86.62.192.48', '1695672688', '__ci_last_regenerate|i:1695672688;'), ('881tb6ek3qe895rjl9mtaab3lt1ntcdg', '86.62.192.48', '1695672688', '__ci_last_regenerate|i:1695672688;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('g8l7dj346o83j11u5c14tthni39k3vko', '86.62.192.48', '1695672691', '__ci_last_regenerate|i:1695672691;'), ('7nd74gf1r6lrchoqot6ka21567fj7o4h', '86.62.192.48', '1695672692', '__ci_last_regenerate|i:1695672692;'), ('ordsc477ukhsp14fe7ro4mn8mrlq0t1u', '212.70.118.68', '1695715439', '__ci_last_regenerate|i:1695715439;'), ('84dch870jo8f3jc7t7vhqi938t75usiu', '212.70.118.68', '1695715442', '__ci_last_regenerate|i:1695715442;'), ('ajnut8v6r2r95k43qm9fs36c2ftm6ork', '212.70.118.68', '1695715442', '__ci_last_regenerate|i:1695715442;'), ('nmg6778qejm4087uhiliq62mi351e3aq', '212.70.118.68', '1695715442', '__ci_last_regenerate|i:1695715442;'), ('4a6vskgga6porve2ub6cjk2ub26opb3i', '212.70.118.68', '1695715442', '__ci_last_regenerate|i:1695715442;'), ('n7lufahvl7nib8emlka2i24npk7ad31h', '212.70.118.68', '1695715442', '__ci_last_regenerate|i:1695715442;'), ('5s9on14v0bfgsbj7uknn8qe745meaanp', '212.70.118.68', '1695715442', '__ci_last_regenerate|i:1695715442;'), ('k2j2gnmoa8c7nghpkfs61754tq1inoa3', '212.70.118.68', '1695715443', '__ci_last_regenerate|i:1695715443;'), ('e54pvjmegb476oeog1u5t0medpttfojn', '212.70.118.68', '1695715445', '__ci_last_regenerate|i:1695715445;'), ('nchblbflkpulqr405v0alp5f0hdpuetl', '212.70.118.68', '1695715445', '__ci_last_regenerate|i:1695715445;'), ('ph57emmqutgqle6rub014phjro03jp64', '212.70.118.68', '1695715446', '__ci_last_regenerate|i:1695715446;'), ('lg3ph7m2rslqusp13nm79htb6v6q4j8e', '212.70.118.68', '1695715446', '__ci_last_regenerate|i:1695715446;'), ('il4i3db44fq2eqop1faljk3t4jjjmtgj', '212.70.118.68', '1695715447', '__ci_last_regenerate|i:1695715447;'), ('i0m39518rioue83sdkuiatm73ebl1qqi', '212.70.118.68', '1695715447', '__ci_last_regenerate|i:1695715447;'), ('rdd25mkh4mutd1aef9rnfb5oeranggv8', '212.70.118.68', '1695715447', '__ci_last_regenerate|i:1695715447;'), ('iaeuva73vk1g7gl45lrs6koqphhtgqld', '212.70.118.68', '1695715447', '__ci_last_regenerate|i:1695715447;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('8vaku2k4dkqvtjp41ihqpueq8ro0l1e4', '212.70.118.68', '1695715450', '__ci_last_regenerate|i:1695715450;'), ('j88fo99rchs2j6pqmh7r9n6fuumg4rh1', '212.70.118.68', '1695715489', '__ci_last_regenerate|i:1695715489;'), ('ki6tv16lqnls8rcbvbc9bpg72aje5l6p', '212.70.118.68', '1695715492', '__ci_last_regenerate|i:1695715492;'), ('7t41c0mcd2pjbf9sgl4u4aucrnlbodh7', '212.70.118.68', '1695715492', '__ci_last_regenerate|i:1695715492;'), ('lqs2epocn50c0uehhb1o4r8bsg7iib6b', '212.70.118.68', '1695715492', '__ci_last_regenerate|i:1695715492;'), ('v6afuh87rin51ikn68fgoqia5g04fvgk', '212.70.118.68', '1695715492', '__ci_last_regenerate|i:1695715492;'), ('iuj7kkim74q0r1d0c0r4828utr6tvjld', '212.70.118.68', '1695715492', '__ci_last_regenerate|i:1695715492;'), ('2cgse12h5t54k6ucuvji18mbp42p5n18', '212.70.118.68', '1695715492', '__ci_last_regenerate|i:1695715492;'), ('e5dho6kftumhgjvs01bts51v7pd4ocds', '212.70.118.68', '1695715493', '__ci_last_regenerate|i:1695715493;'), ('bfee148hupk129fvud1qu5dgc1evr7dp', '212.70.118.68', '1695715608', '__ci_last_regenerate|i:1695715608;'), ('jlvmpr0v36qq7g11khe5kfe1lffichja', '212.70.118.68', '1695715612', '__ci_last_regenerate|i:1695715612;'), ('c6g5c3d0o70m882u2u390o2q05b1u5le', '212.70.118.68', '1695715625', '__ci_last_regenerate|i:1695715625;'), ('knkl667st5q0uff352hlce8mfgpp4r5b', '212.70.118.68', '1695715726', '__ci_last_regenerate|i:1695715726;'), ('1g3dn39ov26fsf8ahi2jue6p99u41bsp', '212.70.118.68', '1695715726', '__ci_last_regenerate|i:1695715726;'), ('ho8mp92i2ipo41klfoh3n7p7v04pckm0', '212.70.118.68', '1695715726', '__ci_last_regenerate|i:1695715726;'), ('8hgtmhh0qcfbd0r13or7cimdhhltu16e', '212.70.118.68', '1695715726', '__ci_last_regenerate|i:1695715726;'), ('te0bilb1shhop849g3g4vtdpgka62lrt', '212.70.118.68', '1695715726', '__ci_last_regenerate|i:1695715726;'), ('b90re8i6b1e24v0003dg5bcnpl2pnulk', '212.70.118.68', '1695715726', '__ci_last_regenerate|i:1695715726;'), ('hkbns9st1d8e8rh9vfg6id1fm74fcdut', '212.70.118.68', '1695715726', '__ci_last_regenerate|i:1695715726;'), ('m9qe1hga0rpa5399ujg16o9js39gpfv2', '212.70.118.68', '1695715726', '__ci_last_regenerate|i:1695715726;'), ('b02qcmpde5kd2c7n4pjbcdcg9en77ptd', '212.70.118.68', '1695715728', '__ci_last_regenerate|i:1695715728;'), ('1j4r905jm96m33btvf4b1b8h9sgigspa', '212.70.118.68', '1695715729', '__ci_last_regenerate|i:1695715729;'), ('a74vtb09kvvn1dt1sudmrm02ljvqttb0', '212.70.118.68', '1695715729', '__ci_last_regenerate|i:1695715729;'), ('ccf7f4fenf125cmidostnc2tscspfihf', '212.70.118.68', '1695715729', '__ci_last_regenerate|i:1695715729;'), ('db6v307rf008tf4lkv1ga9v0te654i1i', '212.70.118.68', '1695715731', '__ci_last_regenerate|i:1695715731;'), ('k8mj0u1bohh6qv6qgoqdi0mmkvbqnfau', '212.70.118.68', '1695715731', '__ci_last_regenerate|i:1695715731;'), ('pubrp625vq9cvdeb9bt8mjo641ac0jbs', '212.70.118.68', '1695715731', '__ci_last_regenerate|i:1695715731;'), ('kvrphgi1g5j0t50qqkrff70hi1i1pplv', '212.70.118.68', '1695715731', '__ci_last_regenerate|i:1695715731;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('nkq0cgno4phne5p71em4e8n30d9eq16j', '212.70.118.68', '1695715747', '__ci_last_regenerate|i:1695715747;'), ('ukhig991pbvk2fm6cc9pedauk18fab44', '212.70.118.68', '1695715824', '__ci_last_regenerate|i:1695715747;custom_session_limit|i:1696579824;user_id|s:3:\"453\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:12:\"Noman Khalid\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";cart_items|a:0:{}language|s:7:\"english\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('daf5vv97quck40qj45oesdc7i817hnkd', '212.70.118.68', '1695715818', '__ci_last_regenerate|i:1695715818;'), ('po4ra336s6i78jodpukl6ihjbtgluubi', '212.70.118.68', '1695716106', '__ci_last_regenerate|i:1695716106;'), ('nu4ha9gfg8c7ih1gcnrg4h5uobn2n4sm', '212.70.118.68', '1695716106', '__ci_last_regenerate|i:1695716106;'), ('rdjt8d9fndmg0c5muqsd3e94l8r1npcp', '212.70.118.68', '1695716106', '__ci_last_regenerate|i:1695716106;'), ('gp6ph1qogrn8folqlpdr9vbbp6i5irk2', '212.70.118.68', '1695716106', '__ci_last_regenerate|i:1695716106;'), ('bsul0v5cabr73nkdj1gmsng5ooj2iptn', '212.70.118.68', '1695716106', '__ci_last_regenerate|i:1695716106;'), ('n8govrfjfj0qpgipi1r50j3prhug29vg', '212.70.118.68', '1695716107', '__ci_last_regenerate|i:1695716107;'), ('gdp64e54cs053oie9lvu3bb4181p2v70', '212.70.118.68', '1695716110', '__ci_last_regenerate|i:1695716110;'), ('26n61gjl847r0dd48osb7te5to29koru', '212.70.118.68', '1695716110', '__ci_last_regenerate|i:1695716110;'), ('fhggc72mkc1hd63f1itrklm0f6i3o70f', '212.70.118.68', '1695716111', '__ci_last_regenerate|i:1695716111;'), ('6gage91ld8fo6ohk15fut07e1f3r0pci', '212.70.118.68', '1695716115', '__ci_last_regenerate|i:1695716115;'), ('sdho1m8ml0edqr0799hsvge3b7h0e7lc', '212.70.118.68', '1695716115', '__ci_last_regenerate|i:1695716115;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('vbjfh4atl42bekmtdm436gakbe0h1a7p', '212.70.118.68', '1695716115', '__ci_last_regenerate|i:1695716115;'), ('bp5l0k621535nejjq9kkdk5coc7kll4o', '212.70.118.68', '1695716120', '__ci_last_regenerate|i:1695716120;'), ('i24bptd56pth7443u8hmpksca37fei5r', '212.70.118.68', '1695716120', '__ci_last_regenerate|i:1695716120;'), ('q329cn1a76fkiccjubtssq05ike49bbp', '43.245.122.138', '1695716122', '__ci_last_regenerate|i:1695716122;'), ('up12gl8vv00ers31cgkdevtj3k6hjtd2', '43.245.122.138', '1695716125', '__ci_last_regenerate|i:1695716125;'), ('7106c8ldgr1ebin56cgn3uo8mn9ocofv', '43.245.122.138', '1695716125', '__ci_last_regenerate|i:1695716125;'), ('79angnruvcmbcagqq5el71p4m92btupv', '43.245.122.138', '1695716125', '__ci_last_regenerate|i:1695716125;'), ('fqid2ai5ekpedt6oqb3n7rcld1eq161k', '43.245.122.138', '1695716125', '__ci_last_regenerate|i:1695716125;'), ('llb2sj8u9rsdut62ko76qh0d2t83jla1', '43.245.122.138', '1695716125', '__ci_last_regenerate|i:1695716125;'), ('fvm3nn33n4m8j9bu21erf85rp0tvfb59', '43.245.122.138', '1695716125', '__ci_last_regenerate|i:1695716125;'), ('0lhpoarrjqdja9j21lg9ss0rfl7mgpui', '43.245.122.138', '1695716126', '__ci_last_regenerate|i:1695716126;'), ('np9d138ui7hevnkhlpbp6q97nem8h09c', '212.70.118.68', '1695716134', '__ci_last_regenerate|i:1695716134;'), ('d94f0t1qkqui9gcouv41njcun3veinln', '212.70.118.68', '1695716134', '__ci_last_regenerate|i:1695716134;'), ('8efr7qf3dpvn0bjt6q1l6s7uajt4ueg1', '212.70.118.68', '1695716134', '__ci_last_regenerate|i:1695716134;'), ('dr6du953mecumtdm6ore3ap3qbv5qe9c', '212.70.118.68', '1695716134', '__ci_last_regenerate|i:1695716134;'), ('edhuk3h3d007p5l8gjgerht9it7gaca2', '212.70.118.68', '1695716134', '__ci_last_regenerate|i:1695716134;'), ('r838bsgubhcf4apb04jb0jb2ldctpdhf', '212.70.118.68', '1695716134', '__ci_last_regenerate|i:1695716134;'), ('b1s7a0ilk9umci7m6hsefcicg2deg64i', '43.245.122.138', '1695716136', '__ci_last_regenerate|i:1695716136;'), ('v4v1sbmmll8kqsursjvmn3776rod4ghh', '43.245.122.138', '1695716139', '__ci_last_regenerate|i:1695716139;'), ('8s4clj5r17rluh2ks9vkavvn2a51ijn1', '43.245.122.138', '1695716140', '__ci_last_regenerate|i:1695716140;'), ('1te3p5e33vsn1anntjad44nba8mrodf0', '43.245.122.138', '1695716140', '__ci_last_regenerate|i:1695716140;'), ('hn40jug8fnc711s1e09pf9bf014bggi3', '43.245.122.138', '1695716140', '__ci_last_regenerate|i:1695716140;'), ('bsg2kv0tlnio2630quiinvsmatqk45ea', '43.245.122.138', '1695716140', '__ci_last_regenerate|i:1695716140;'), ('6acn272765i0d58q42d8jm9cfiigvib8', '43.245.122.138', '1695716140', '__ci_last_regenerate|i:1695716140;'), ('bfc0ao30nh4rm8m1g9vpmeg2ge2bqnsh', '43.245.122.138', '1695716140', '__ci_last_regenerate|i:1695716140;'), ('u19fsfifrado38eac0rovs3ha03tcn8b', '43.245.122.138', '1695716140', '__ci_last_regenerate|i:1695716140;'), ('gs53te28p6tijhodrijruh8t485ebkmh', '43.245.122.138', '1695716141', '__ci_last_regenerate|i:1695716141;'), ('q3jove6t7crj0p7tovcd5lrs9f4t5oe8', '43.245.122.138', '1695716141', '__ci_last_regenerate|i:1695716141;'), ('qkrcudb5gq22n425mo8207traa62sntk', '43.245.122.138', '1695716141', '__ci_last_regenerate|i:1695716141;'), ('vs222vog747htqcb1u3ar14m0t2n0dus', '43.245.122.138', '1695716141', '__ci_last_regenerate|i:1695716141;'), ('3d7co94l0fbo8dh4b0nn5q554t7todmu', '43.245.122.138', '1695716141', '__ci_last_regenerate|i:1695716141;'), ('k5cuhc08cn1sejsnts0ssdsj8gb3igu1', '43.245.122.138', '1695716141', '__ci_last_regenerate|i:1695716141;'), ('pai443r48kdandmh2okqo8fh2q8vf7cc', '43.245.122.138', '1695716143', '__ci_last_regenerate|i:1695716143;'), ('n8sjddunmtavoe5sfq2udrmnkr2viuou', '43.245.122.138', '1695716143', '__ci_last_regenerate|i:1695716143;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('3v872gessfkd4o464kptj2dgb3783ksc', '43.245.122.138', '1695716143', '__ci_last_regenerate|i:1695716143;'), ('tprspfqf0rkgf0itpq9abu9fjjebfipe', '212.70.118.68', '1695716228', '__ci_last_regenerate|i:1695716228;'), ('kudnqicl71vd5l5bc4u0n7eenuo4vjk4', '212.70.118.68', '1695716228', '__ci_last_regenerate|i:1695716228;'), ('lb005eje4nmevhshk1refihp9bf8n19k', '212.70.118.68', '1695716228', '__ci_last_regenerate|i:1695716228;'), ('ds75f6boi1pmil0h6fq2etd8sa7mprbj', '212.70.118.68', '1695716228', '__ci_last_regenerate|i:1695716228;'), ('hg2ha9ce57cbbcbt1fcmvtlmp6nn7h61', '212.70.118.68', '1695716228', '__ci_last_regenerate|i:1695716228;'), ('aq34u4p9oin1s4m2n0ardt7daovvv039', '212.70.118.68', '1695716228', '__ci_last_regenerate|i:1695716228;'), ('45pn668v24hp85bupmnjqii3m9cic6l5', '212.70.118.68', '1695716231', '__ci_last_regenerate|i:1695716231;'), ('49kf5jqvj94bepnba4sigm6vvlms5bd0', '212.70.118.68', '1695716231', '__ci_last_regenerate|i:1695716231;'), ('sb5dvhkevk02kj2qlh5dao02bmem2rt1', '212.70.118.68', '1695716231', '__ci_last_regenerate|i:1695716231;'), ('a00o9rrdkmvff1nehi6bvfh3c1ulmdf2', '212.70.118.68', '1695716231', '__ci_last_regenerate|i:1695716231;'), ('nq4edo6oe37f1o0ig0c2m807mbc9rv7c', '212.70.118.68', '1695716231', '__ci_last_regenerate|i:1695716231;'), ('ub7871memmffdvms36algpvusgkvlha7', '212.70.118.68', '1695716231', '__ci_last_regenerate|i:1695716231;'), ('52n2pa2ljmncacfaitf4vbi8jmlt8g76', '212.70.118.68', '1695716233', '__ci_last_regenerate|i:1695716233;'), ('qi4dff47nbp1bb0q1sae3plemqas77l8', '212.70.118.68', '1695716233', '__ci_last_regenerate|i:1695716233;'), ('d1i4a9splma2cvm5shj00qv4jdq9n9c1', '212.70.118.68', '1695716233', '__ci_last_regenerate|i:1695716233;'), ('je5opo8ll0l0p2h6j9cedshrrof264an', '212.70.118.68', '1695716233', '__ci_last_regenerate|i:1695716233;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('cku5q142b78i093tpjebbbmjab9qs6n5', '212.70.118.68', '1695716236', '__ci_last_regenerate|i:1695716236;'), ('db9seti5qhs4u2hpgvb9oo129m1dn435', '212.70.118.68', '1695716236', '__ci_last_regenerate|i:1695716236;'), ('30m2o66r4q18kv4sq572d8edlrh8d17u', '212.70.118.68', '1695716236', '__ci_last_regenerate|i:1695716236;'), ('a6n7rusotgcqhnsn3il2tvj2vc0g0uds', '212.70.118.68', '1695716236', '__ci_last_regenerate|i:1695716236;'), ('erclm757o4olsag9fftkbl75oreeg87e', '212.70.118.68', '1695716236', '__ci_last_regenerate|i:1695716236;'), ('bf07rho0kelrib6ht6n7irkkuvbfkuui', '212.70.118.68', '1695716237', '__ci_last_regenerate|i:1695716237;'), ('bkodvklpp8a26blvb4m17d58oei1gks1', '212.70.118.68', '1695716239', '__ci_last_regenerate|i:1695716239;'), ('4ch9pq76l0c01bdfsc99al3hrmlcsnq9', '212.70.118.68', '1695716239', '__ci_last_regenerate|i:1695716239;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('4fs1m3k15apvb24t017ibilsa0npd48d', '212.70.118.68', '1695716239', '__ci_last_regenerate|i:1695716239;'), ('v1g6tv1npd3u28toa11u3jb8jnd5dreb', '212.70.118.68', '1695716245', '__ci_last_regenerate|i:1695716245;'), ('3hcma89chp558e3hhf9j6v8s0tucrh0a', '212.70.118.68', '1695716245', '__ci_last_regenerate|i:1695716245;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('uc8nr3gfdajrcrmb9kt9ssio1h0e7ijh', '212.70.118.68', '1695716246', '__ci_last_regenerate|i:1695716246;'), ('t7u6cm05824i2h8eabhd84er1hb3pce3', '43.245.122.138', '1695716462', '__ci_last_regenerate|i:1695716462;'), ('jn8ql0fkgjr6smlc3ik99rs5l53g97vb', '43.245.122.138', '1695716474', '__ci_last_regenerate|i:1695716474;'), ('lqsnvojf82vfvrrg81dhgadasbvvsnm5', '43.245.122.138', '1695716546', '__ci_last_regenerate|i:1695716546;'), ('62hlhlbevtuki82sgut0iid600n9a9rn', '43.245.122.138', '1695716551', '__ci_last_regenerate|i:1695716551;'), ('02i4m90fmoumjlu07fn7j0eqiar759av', '43.245.122.138', '1695716551', '__ci_last_regenerate|i:1695716551;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('1akt88tgr2el48l8s35eufkq2mpld0kr', '43.245.122.138', '1695716552', '__ci_last_regenerate|i:1695716552;'), ('jgjdc4pk7vivvhqkvo9v700c31vrdfn3', '43.245.122.138', '1695716709', '__ci_last_regenerate|i:1695716709;'), ('n19c27po96b2uvlbg3vjsoqrbj3r0crn', '43.245.122.138', '1695716713', '__ci_last_regenerate|i:1695716713;'), ('lu5jl07ivttefvfglj2g0fgis0g7u68h', '43.245.122.138', '1695716713', '__ci_last_regenerate|i:1695716713;'), ('k2k1ukq577o8s4fq85isji27u0n2dnbi', '43.245.122.138', '1695716713', '__ci_last_regenerate|i:1695716713;'), ('ulnc8kitk24eckkc4pil2tlr71180d0t', '43.245.122.138', '1695716713', '__ci_last_regenerate|i:1695716713;'), ('c9crsedu2eb70khpp6ssekecps9usgtt', '43.245.122.138', '1695716713', '__ci_last_regenerate|i:1695716713;'), ('vpc7q6b5dfpf820tak3qsob3hco8le46', '43.245.122.138', '1695716713', '__ci_last_regenerate|i:1695716713;'), ('3ck5u21l4juoj2c89ao6db5qfbmmtl4j', '43.245.122.138', '1695716713', '__ci_last_regenerate|i:1695716713;'), ('ue81g799tarcd893iolddnqdpqr0ri4s', '43.245.122.138', '1695716717', '__ci_last_regenerate|i:1695716717;'), ('nq9p8vltm54spg8pljt7ncinv192v42f', '43.245.122.138', '1695716717', '__ci_last_regenerate|i:1695716717;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('mgrnaf4sdl71h3arj2cjo8foonoc27pu', '43.245.122.138', '1695716718', '__ci_last_regenerate|i:1695716718;'), ('0tpr9ipnim1i2m7j8br7m5psfieos75r', '43.245.122.138', '1695716737', '__ci_last_regenerate|i:1695716737;'), ('irkpm4ku88grabi5sbcbe2hv58r3phrv', '43.245.122.138', '1695716737', '__ci_last_regenerate|i:1695716737;'), ('a761cndha62kfgvfp0l126h8kbno28gm', '43.245.122.138', '1695716738', '__ci_last_regenerate|i:1695716738;'), ('uju8cdr9sfesm8lhjo90gsq13fdhp92l', '43.245.122.138', '1695716811', '__ci_last_regenerate|i:1695716811;'), ('i6tpl2ru74vvfnh9skhn10ihpd4db73o', '43.245.122.138', '1695716815', '__ci_last_regenerate|i:1695716815;'), ('7o8a2nf0tgb834qp872n40i6j9071kki', '43.245.122.138', '1695716816', '__ci_last_regenerate|i:1695716816;'), ('g1kir2q1e3rl09dl3v75s6jrkul0g85h', '43.245.122.138', '1695716817', '__ci_last_regenerate|i:1695716817;'), ('i9te7r5stpm0o152r41u3eia78o0trar', '43.245.122.138', '1695716817', '__ci_last_regenerate|i:1695716817;'), ('l5eqleru5jelk2mgel109nc58mg0a747', '43.245.122.138', '1695716817', '__ci_last_regenerate|i:1695716817;'), ('6nafb5ldmdegmjp74iqcrtla9aape761', '43.245.122.138', '1695716817', '__ci_last_regenerate|i:1695716817;'), ('le973gsgl315u9ql17tg9fcqni9r316o', '43.245.122.138', '1695716817', '__ci_last_regenerate|i:1695716817;'), ('2m4juoj2r4lakc7ed6pb6t3nu6vt0456', '43.245.122.138', '1695716817', '__ci_last_regenerate|i:1695716817;'), ('tmicbae1abmhoaagcnnnlcn5gdb1dfbq', '43.245.122.138', '1695716822', '__ci_last_regenerate|i:1695716822;'), ('r14je8ho0j0cgvcmpt3fhs2j38d01qg7', '43.245.122.138', '1695716822', '__ci_last_regenerate|i:1695716822;'), ('ll4s6o8lehrif7oo3o0aj9kls0rsaaps', '43.245.122.138', '1695716822', '__ci_last_regenerate|i:1695716822;'), ('td96m5ao3ciso47fr1rrlnt1fgsivpt7', '43.245.122.138', '1695716822', '__ci_last_regenerate|i:1695716822;'), ('j9edvrabfku4e0lkqtl1d398t8cid08k', '43.245.122.138', '1695716822', '__ci_last_regenerate|i:1695716822;'), ('jfvuoto6e4btrfl46uco9ckb258hs07l', '43.245.122.138', '1695716822', '__ci_last_regenerate|i:1695716822;'), ('899t8k60qqsuk1ma9g3qgfb43pv0ipac', '43.245.122.138', '1695716825', '__ci_last_regenerate|i:1695716825;'), ('e2inlok75meteja5r0q86u3t6lsmdhul', '43.245.122.138', '1695716825', '__ci_last_regenerate|i:1695716825;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('r77visn17o2jjjq07j1qnsbf4fte8d68', '43.245.122.138', '1695716826', '__ci_last_regenerate|i:1695716826;'), ('ipmds8e2nuaanajttgss230a0lbb2q1r', '43.245.122.138', '1695717006', '__ci_last_regenerate|i:1695717006;'), ('6ninlttvnn49h791c39h9vm8tje9e5n0', '43.245.122.138', '1695717018', '__ci_last_regenerate|i:1695717018;'), ('q7u2mdv4lr7mnck6m96aph854kc2s4dk', '43.245.122.138', '1695717019', '__ci_last_regenerate|i:1695717019;'), ('5d69mdc67v1098qpfonu4sjl325ceq8p', '43.245.122.138', '1695717019', '__ci_last_regenerate|i:1695717019;'), ('24t8mo9evt35c0jgg8sggjpo0budk1v4', '43.245.122.138', '1695717019', '__ci_last_regenerate|i:1695717019;'), ('52itpr3fv0m4k0jqnbnp4dpnaaepi08c', '43.245.122.138', '1695717019', '__ci_last_regenerate|i:1695717019;'), ('uoqlr5aaqpfc7loap5j0ru73kltu26db', '43.245.122.138', '1695717019', '__ci_last_regenerate|i:1695717019;'), ('eqiaab6dllu0aobqkf2rf3scjm1hu8fm', '43.245.122.138', '1695717019', '__ci_last_regenerate|i:1695717019;'), ('eckd5aehe7rhss85espe8o6c478ou5mf', '43.245.122.138', '1695717019', '__ci_last_regenerate|i:1695717019;'), ('u26mdb6s7foeb24r6bh9gf45s0jjvdpu', '43.245.122.138', '1695717021', '__ci_last_regenerate|i:1695717021;'), ('1tj1aj3qo6be1hdc2kjhevpo4tosb0g1', '43.245.122.138', '1695717021', '__ci_last_regenerate|i:1695717021;'), ('5t54p9ggjsatb6aqnbkjb4clkf82tarl', '43.245.122.138', '1695717021', '__ci_last_regenerate|i:1695717021;'), ('nncpqsbjv66pctls7ejkb0vhpa216odj', '43.245.122.138', '1695717021', '__ci_last_regenerate|i:1695717021;'), ('hlrudhj6j8m7gl59qvpvs5uj0po8veav', '43.245.122.138', '1695717029', '__ci_last_regenerate|i:1695717029;'), ('d8e4h7o9kpmptmeqfuuu31ris52de8q9', '43.245.122.138', '1695717029', '__ci_last_regenerate|i:1695717029;'), ('unmfagc3p25hrb1auogo9q4s98vu87i6', '43.245.122.138', '1695717029', '__ci_last_regenerate|i:1695717029;'), ('l2b7hp540i2lb1m3jnr2rdo60p05f263', '43.245.122.138', '1695717029', '__ci_last_regenerate|i:1695717029;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('op0na2cjdr405duqqgr9huunbn9kkbic', '43.245.122.138', '1695717035', '__ci_last_regenerate|i:1695717035;'), ('h7go7hcaa7plu1f3tgc3gbmm3i22h2cm', '43.245.122.138', '1695717035', '__ci_last_regenerate|i:1695717035;'), ('a0ig26cnmg2b4pbmv6dl3t7r01d9dl1h', '43.245.122.138', '1695717035', '__ci_last_regenerate|i:1695717035;'), ('80k9usmome2shplrd0i16p97lrrt7969', '43.245.122.138', '1695717035', '__ci_last_regenerate|i:1695717035;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('mdl258ibumm29n35oqg1g1ru060ogsca', '43.245.122.138', '1695717042', '__ci_last_regenerate|i:1695717042;'), ('j24vsqi76i1akm8vhii3fh3cc1mruv12', '43.245.122.138', '1695717042', '__ci_last_regenerate|i:1695717042;'), ('inrpjvl190juvr18ufoaj0nujis0sf1e', '43.245.122.138', '1695717042', '__ci_last_regenerate|i:1695717042;'), ('es75v45t1p5jo581oj3u4rf2f6kgdvs5', '43.245.122.138', '1695717042', '__ci_last_regenerate|i:1695717042;'), ('5ohgp5nkasrfopl1s2qr5f8ca8jhneng', '43.245.122.138', '1695717042', '__ci_last_regenerate|i:1695717042;'), ('3rffui845r339g7dm6lk930loqha1b18', '43.245.122.138', '1695717043', '__ci_last_regenerate|i:1695717043;'), ('d7sjipq988jb866vjaejbf14a0qd4faj', '43.245.122.138', '1695717045', '__ci_last_regenerate|i:1695717045;'), ('h8rubs3o3tl4rtlgkugdvltr0qm5cb6o', '43.245.122.138', '1695717045', '__ci_last_regenerate|i:1695717045;'), ('rbdkf9jvo547oe99fub5qi2h5l94uhe7', '43.245.122.138', '1695717046', '__ci_last_regenerate|i:1695717046;'), ('n0nah152s2gtngauq38du875chmc3ois', '43.245.122.138', '1695717046', '__ci_last_regenerate|i:1695717046;'), ('ia62knllsppdg6l15iqni49e00i1tj23', '43.245.122.138', '1695717046', '__ci_last_regenerate|i:1695717046;'), ('bucf1ba22e9fdtmnjpd6fdkpveerkp0p', '43.245.122.138', '1695717046', '__ci_last_regenerate|i:1695717046;'), ('oqq7geqh74ah3ekp75ol6uo38vd19j67', '43.245.122.138', '1695717046', '__ci_last_regenerate|i:1695717046;'), ('n4i46q3fbuh94de8btaoqfjoirr5hb72', '43.245.122.138', '1695717046', '__ci_last_regenerate|i:1695717046;'), ('p81hfvl2aeopc0t5qtj06g8v84cp9r4q', '43.245.122.138', '1695717093', '__ci_last_regenerate|i:1695717093;'), ('kalmc6lh6m2s5f3h215bufkt60gp45cc', '43.245.122.138', '1695717094', '__ci_last_regenerate|i:1695717094;'), ('dp41n2kga1pa0b5qfdbjcmf4ohbeom3e', '43.245.122.138', '1695717094', '__ci_last_regenerate|i:1695717094;'), ('bgknth538fufp67qugp6qrb5qgmf3gcf', '43.245.122.138', '1695717094', '__ci_last_regenerate|i:1695717094;'), ('qvn0ml9q8eepjp2u4npjqa1nevhnsll1', '43.245.122.138', '1695717094', '__ci_last_regenerate|i:1695717094;'), ('b8khjckr40a3qpfkqqbabr3fjqeje47q', '43.245.122.138', '1695717094', '__ci_last_regenerate|i:1695717094;'), ('kor3pu62rro91e6sha5obd8esaj1eefe', '43.245.122.138', '1695717094', '__ci_last_regenerate|i:1695717094;'), ('7k0rm8b0ks29vipf1af7405kfkvtcngi', '43.245.122.138', '1695717097', '__ci_last_regenerate|i:1695717097;'), ('f7li5gr8sia06hdchs6u9cuc5hh6i56i', '43.245.122.138', '1695717097', '__ci_last_regenerate|i:1695717097;'), ('bm8jm89fv0l2lmr15a3l5fcnf8qrvnvv', '43.245.122.138', '1695717097', '__ci_last_regenerate|i:1695717097;'), ('lrrfnefd6sitlr3ckfniqco146m5orls', '43.245.122.138', '1695717097', '__ci_last_regenerate|i:1695717097;'), ('mgm9g623acavek9e39iu38628i9s5btn', '43.245.122.138', '1695717097', '__ci_last_regenerate|i:1695717097;'), ('32atsrtpojc8mrko6qhfrve1kla608a3', '43.245.122.138', '1695717098', '__ci_last_regenerate|i:1695717098;'), ('c3uc8bk0uccj1s81p1elf8nkrcnehf81', '43.245.122.138', '1695717138', '__ci_last_regenerate|i:1695717138;'), ('onj4g6r49hj457pdpvmo31jt2ra8bu4r', '43.245.122.138', '1695717142', '__ci_last_regenerate|i:1695717142;'), ('b6hj8s3s8ajb9e4vidb41pcsq0rkdmqo', '43.245.122.138', '1695717143', '__ci_last_regenerate|i:1695717143;'), ('15ag6j1tj9mjk8hg6fleesnvb26sqo2q', '43.245.122.138', '1695717144', '__ci_last_regenerate|i:1695717144;'), ('m9dg201fkc03bag1co6qo3e9loil58bh', '43.245.122.138', '1695717144', '__ci_last_regenerate|i:1695717144;'), ('ps1apf8gojoa8osqfsktm1olc44qe9ib', '43.245.122.138', '1695717144', '__ci_last_regenerate|i:1695717144;'), ('52k39ilikm1of9pf31e1klvijoli0fh8', '43.245.122.138', '1695717144', '__ci_last_regenerate|i:1695717144;'), ('as4pmhs5t91nud53ol3anqmaf03d7ssr', '43.245.122.138', '1695717144', '__ci_last_regenerate|i:1695717144;'), ('d4otgdthgju8e3e7gf3qtibom5gd4j6j', '43.245.122.138', '1695717144', '__ci_last_regenerate|i:1695717144;'), ('jgq6roea97cgbmrblq3u08rc85245n64', '43.245.122.138', '1695717144', '__ci_last_regenerate|i:1695717144;'), ('rl5gtm62kearaqef0mg7i8ju57ba5klg', '43.245.122.138', '1695717144', '__ci_last_regenerate|i:1695717144;'), ('22arcd0a53sno550nkf055khf0tlmuad', '43.245.122.138', '1695717144', '__ci_last_regenerate|i:1695717144;'), ('cu7hapiq7cao435au8cacg7vaae824st', '43.245.122.138', '1695717144', '__ci_last_regenerate|i:1695717144;'), ('kjhrufbj4633gji6soh9amedr7tmotq5', '43.245.122.138', '1695717144', '__ci_last_regenerate|i:1695717144;'), ('vq9lhlsip5oojdjq7p66cgkb0edndfru', '43.245.122.138', '1695717145', '__ci_last_regenerate|i:1695717145;'), ('nemb9idlvsd5aoie4fcd17ac56v2vhsf', '43.245.122.138', '1695717198', '__ci_last_regenerate|i:1695717198;'), ('kpgr1p784a9raq2c57t96sorg5vut9r5', '43.245.122.138', '1695717201', '__ci_last_regenerate|i:1695717201;'), ('q6ds1d437c55aeeqs20l1grlmqkuoc9f', '43.245.122.138', '1695717201', '__ci_last_regenerate|i:1695717201;'), ('ojo1hdp2dens1r33c2605p5en4f6hisf', '43.245.122.138', '1695717202', '__ci_last_regenerate|i:1695717202;'), ('drc14uf7m9djv7a50h2fk4n5bm4jouuu', '43.245.122.138', '1695717202', '__ci_last_regenerate|i:1695717202;'), ('o0iega9tfvuqpi6ovbthhfar2jpv79p5', '43.245.122.138', '1695717202', '__ci_last_regenerate|i:1695717202;'), ('mc8fbok40dkp4bj2moi0vheh801fq2v9', '43.245.122.138', '1695717202', '__ci_last_regenerate|i:1695717202;'), ('4e1haj8bpvcjfqfh276uoaag7q7l7d2i', '43.245.122.138', '1695717202', '__ci_last_regenerate|i:1695717202;'), ('0q88v1ldo2mq3e6l6lm2tldtjkrlv32k', '43.245.122.138', '1695717202', '__ci_last_regenerate|i:1695717202;'), ('vo8opkrece2i451an1enaa9csrp0ue7k', '43.245.122.138', '1695717203', '__ci_last_regenerate|i:1695717203;'), ('ih9gcl4a64fvr0bj4g2i1ur7o9lc4cv8', '43.245.122.138', '1695717206', '__ci_last_regenerate|i:1695717206;'), ('9khr8ko1kdkh723ajt1ne7ovn6m6hq5p', '43.245.122.138', '1695717206', '__ci_last_regenerate|i:1695717206;'), ('98fjd6sntkr1lfcchtl1oehmb10vtmsl', '43.245.122.138', '1695717206', '__ci_last_regenerate|i:1695717206;'), ('h0t3i65jedpmcp5fmhk3dq5eisjkko32', '43.245.122.138', '1695717206', '__ci_last_regenerate|i:1695717206;'), ('f4ls8qb0dfmttncrvh5ermu6g89upldd', '43.245.122.138', '1695717206', '__ci_last_regenerate|i:1695717206;'), ('u4ev1d05p6se5aklorsrl3rsfo2s20nl', '43.245.122.138', '1695717207', '__ci_last_regenerate|i:1695717207;'), ('t6fipkintg4hdtm7lip419kgp6mfacr2', '43.245.122.138', '1695717209', '__ci_last_regenerate|i:1695717209;'), ('k0c87najtr9stopqsq2u9lta58tgfm8e', '43.245.122.138', '1695717209', '__ci_last_regenerate|i:1695717209;'), ('jvonmg2jr0k297m1pkvrkie33m4v605n', '43.245.122.138', '1695717210', '__ci_last_regenerate|i:1695717210;'), ('0cn44q2eo02obecpj0pc7cs634gsiru1', '43.245.122.138', '1695717210', '__ci_last_regenerate|i:1695717210;'), ('22alkjm4rb6f3i651rh7lci8s27jfge9', '43.245.122.138', '1695717210', '__ci_last_regenerate|i:1695717210;'), ('n5q74k4fvcg2i4d8l3kpojm0akru7n4g', '43.245.122.138', '1695717210', '__ci_last_regenerate|i:1695717210;'), ('id7mua8aek0d6guk5e9nf5cfrsid73o0', '43.245.122.138', '1695717210', '__ci_last_regenerate|i:1695717210;'), ('6eclit3pss88elega0jrol4u5vafgi4j', '43.245.122.138', '1695717210', '__ci_last_regenerate|i:1695717210;'), ('0ap5mnfak7rgtpr79enq3a2ra15gs70e', '43.245.122.138', '1695717210', '__ci_last_regenerate|i:1695717210;'), ('bh7gc9vimupm5r98ku5hi1hqom0mo19h', '43.245.122.138', '1695717210', '__ci_last_regenerate|i:1695717210;'), ('tpgmhmdomoslkcr9frkheh8mke181rhg', '43.245.122.138', '1695717210', '__ci_last_regenerate|i:1695717210;'), ('8m6daptng2st8qus8eje89f7i2lkme1j', '43.245.122.138', '1695717210', '__ci_last_regenerate|i:1695717210;'), ('fk066qaqlnhnlvdn58lhe9vgh945ui8f', '43.245.122.138', '1695717210', '__ci_last_regenerate|i:1695717210;'), ('c84dptmqmcva5d5pqm09c2h5ojnmftl6', '43.245.122.138', '1695717211', '__ci_last_regenerate|i:1695717211;'), ('22254a9lk7ds5cvllph0n2dei483fj9i', '43.245.122.138', '1695717212', '__ci_last_regenerate|i:1695717212;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('uor074nt3i224p8lec05qu671da48r4k', '43.245.122.138', '1695717212', '__ci_last_regenerate|i:1695717212;'), ('uok28o7p1043vmi7frk0gikq3v2cpf83', '43.245.122.138', '1695717212', '__ci_last_regenerate|i:1695717212;'), ('v7aqrue4bb7h1ea9o0pqtuad3utm1mkj', '43.245.122.138', '1695717216', '__ci_last_regenerate|i:1695717216;'), ('cnqludvd85i52hasmmjq8f95shnrdo01', '43.245.122.138', '1695717216', '__ci_last_regenerate|i:1695717216;'), ('djtla5kf2e2urce9sk8f62ka2s02leiv', '43.245.122.138', '1695717216', '__ci_last_regenerate|i:1695717216;'), ('et5u3qahlmrctpp3fnv669h396s1e18g', '212.70.118.68', '1695718558', '__ci_last_regenerate|i:1695718558;'), ('8od3gnghadtvfg65ssc7for106i0l65d', '212.70.118.68', '1695718558', '__ci_last_regenerate|i:1695718558;'), ('rusu052m7bmp5lu8uc020retvhp4ccjs', '212.70.118.68', '1695718558', '__ci_last_regenerate|i:1695718558;'), ('d3oscpm8hgb02ol048ffq9a1n7mh0q22', '212.70.118.68', '1695718558', '__ci_last_regenerate|i:1695718558;'), ('8o0mroj4frghl70ifd6dhd0kufkbd9uf', '212.70.118.68', '1695718558', '__ci_last_regenerate|i:1695718558;'), ('71v69rrp1ir0ic6669mlk0pkv0sjemtr', '103.253.45.40', '1695746689', '__ci_last_regenerate|i:1695746689;'), ('10dsq7mffqnipsi945rpd8osqmd42hm3', '103.253.45.40', '1695746692', '__ci_last_regenerate|i:1695746692;'), ('u3p54spphgc66orvjq7gpe6pp2r1eh73', '103.253.45.40', '1695746692', '__ci_last_regenerate|i:1695746692;'), ('mh3161kmoumb86fiesqimkjat0b5tkga', '103.253.45.40', '1695746692', '__ci_last_regenerate|i:1695746692;'), ('pj0dlhe8b7u14u89dk3i77jaoamgcgid', '103.253.45.40', '1695746692', '__ci_last_regenerate|i:1695746692;'), ('pdm3t486k0oprq20ksk0l9skai59qvng', '103.253.45.40', '1695746692', '__ci_last_regenerate|i:1695746692;'), ('5m1vdqgp6n95d2vvj3pj6vaikd890dnp', '103.253.45.40', '1695746692', '__ci_last_regenerate|i:1695746692;'), ('tik981pdlf7o3ftog0ns17psn0ja83oi', '103.253.45.40', '1695746694', '__ci_last_regenerate|i:1695746694;'), ('nds0pmq0df2ba932k43g4o619elb0rgg', '103.253.45.40', '1695746708', '__ci_last_regenerate|i:1695746708;'), ('bklqks42c2e6upaq31187sms3p7sqt47', '103.253.45.40', '1695746708', '__ci_last_regenerate|i:1695746708;'), ('1tpumnuqssodouen9497uckp4frjc3kn', '103.253.45.40', '1695746708', '__ci_last_regenerate|i:1695746708;'), ('jobq246btc7m8tqv8cu2ols7ue4one8t', '103.253.45.40', '1695746708', '__ci_last_regenerate|i:1695746708;'), ('8dkiplf3chtcg2fbujf450r6epl2532u', '103.253.45.40', '1695746709', '__ci_last_regenerate|i:1695746709;'), ('okj2ds1af77fd2u9k4ofpmlva4bne5br', '103.253.45.40', '1695746713', '__ci_last_regenerate|i:1695746713;'), ('g54b2hemqvaeojba447v1sg63j1s5gnp', '103.253.45.40', '1695746724', '__ci_last_regenerate|i:1695746724;'), ('3o64g74s7fr87ohv2cv0agisuhknlug1', '103.253.45.40', '1695746824', '__ci_last_regenerate|i:1695746824;'), ('20q35maa1npie6u7fq2l4d598hotjc76', '103.253.45.40', '1695746834', '__ci_last_regenerate|i:1695746834;'), ('r02buu2oiojbl9k19vs6v8sogtp06obp', '103.253.45.40', '1695746834', '__ci_last_regenerate|i:1695746834;'), ('r1dsm05ba1o1imf30h517kdtdmn9o25a', '103.253.45.40', '1695747224', '__ci_last_regenerate|i:1695747224;'), ('eg8sl8ip8cfgn4ducgmc4b9dgi33335s', '103.253.45.40', '1695747230', '__ci_last_regenerate|i:1695747230;'), ('qit3kdgtfnsveg659mthbhuhnlj5t7gv', '103.253.45.40', '1695747232', '__ci_last_regenerate|i:1695747232;'), ('ct9ovelv3rq71d2jbgjur4c2a9jmj32s', '103.253.45.40', '1695747232', '__ci_last_regenerate|i:1695747232;'), ('64tiisft6g26pu68lr0dstg1qb3e4aip', '103.253.45.40', '1695747232', '__ci_last_regenerate|i:1695747232;'), ('pioqqfqr2g2ha4ltdpd85nqm6oqc8de8', '103.253.45.40', '1695747232', '__ci_last_regenerate|i:1695747232;'), ('9ulflfhcd018u5l1rb1gcmp4vjsalpu7', '103.253.45.40', '1695747241', '__ci_last_regenerate|i:1695747241;'), ('u09ccnoi3iv78uc8382n7enafqpuf7vk', '103.253.45.40', '1695747399', '__ci_last_regenerate|i:1695747399;'), ('2b5ehjkd3gt5o3mhn8ueslme98affbiu', '103.253.45.40', '1695747403', '__ci_last_regenerate|i:1695747403;'), ('f2n36p1ve4pk78f0edltu99j8lp8qllm', '103.253.45.40', '1695747403', '__ci_last_regenerate|i:1695747403;'), ('94ahl19ap9tnua0mlmem97ialp2ct28h', '103.253.45.40', '1695747403', '__ci_last_regenerate|i:1695747403;'), ('khob5lrdlibmojh9n4ider2q68sls27c', '103.253.45.40', '1695747403', '__ci_last_regenerate|i:1695747403;'), ('oa08kmgsjmo2ifgkhnlqfrna5pven9u4', '103.253.45.40', '1695747403', '__ci_last_regenerate|i:1695747403;'), ('iljrggmeh8ahvudbkr8k6fk6k7g4d6ci', '103.253.45.40', '1695747403', '__ci_last_regenerate|i:1695747403;'), ('ciuh7glejot18godq9p56d2iqekbcidl', '103.253.45.40', '1695747403', '__ci_last_regenerate|i:1695747403;'), ('mq29k6qslfin7aou8458e3e89kl5cikv', '103.253.45.40', '1695747404', '__ci_last_regenerate|i:1695747404;'), ('g41gh725v9icbhtn8log3ggj0128falc', '103.253.45.40', '1695747404', '__ci_last_regenerate|i:1695747404;'), ('fui9i2ettj2s82vaac2n0h46vbssdqpg', '103.253.45.40', '1695747404', '__ci_last_regenerate|i:1695747404;'), ('pvckal4n6amsui3p5h9aja35oi4jr7b7', '103.253.45.40', '1695747405', '__ci_last_regenerate|i:1695747405;'), ('cb8i4f09btr901l3n6ngdqam7ijoo2fh', '103.253.45.40', '1695747407', '__ci_last_regenerate|i:1695747407;'), ('r64vhdnl50tdqr2il4mfafmfgs9go45a', '103.253.45.40', '1695747495', '__ci_last_regenerate|i:1695747495;'), ('2d34krf7j9phj7q68b7s6b0jcf8vb81e', '103.253.45.40', '1695747497', '__ci_last_regenerate|i:1695747497;'), ('smrlpqr0mdsupfoeecae43onkemsh5bt', '103.253.45.40', '1695747500', '__ci_last_regenerate|i:1695747500;'), ('hluu8umh2ued5bqg27f10qvpjjd2gv77', '103.253.45.40', '1695747503', '__ci_last_regenerate|i:1695747503;'), ('ira8sa4r8krkrd81j0aj2s40s87er6nr', '103.253.45.40', '1695747503', '__ci_last_regenerate|i:1695747503;'), ('0m8q3kog10b03bkkhsbj3r0p24ikn4j0', '103.253.45.40', '1695747503', '__ci_last_regenerate|i:1695747503;'), ('duedd8s3cr814at7vbbgpf3ovrv4ii10', '103.253.45.40', '1695747504', '__ci_last_regenerate|i:1695747504;'), ('14h1p88q0m7edia3am3o02me93hsc4uf', '103.253.45.40', '1695747506', '__ci_last_regenerate|i:1695747506;'), ('7moajgo6edo7grbh4eqem54neubbo389', '103.253.45.40', '1695747546', '__ci_last_regenerate|i:1695747546;'), ('v8ocidvc2ns5kd8rab1eipgpj9gv07qa', '103.253.45.40', '1695747550', '__ci_last_regenerate|i:1695747550;'), ('sqav6qqqvkvrh1f58s0onn6l4eouvsds', '103.253.45.40', '1695747550', '__ci_last_regenerate|i:1695747550;'), ('5ahn59on1tofs1rgmjmrrsiru39v5lud', '103.253.45.40', '1695747550', '__ci_last_regenerate|i:1695747550;'), ('htd9ituj2nrtdht59sm1vqehfe9360hq', '103.253.45.40', '1695747550', '__ci_last_regenerate|i:1695747550;'), ('brn3sj0uhgipp6mpskuek4smt5uagrgp', '103.253.45.40', '1695747550', '__ci_last_regenerate|i:1695747550;'), ('neoecteoisi7nntn0s112tu08on874k7', '103.253.45.40', '1695747550', '__ci_last_regenerate|i:1695747550;'), ('dm4osgktl7ok5o4v5umher90gok0aa01', '103.253.45.40', '1695747551', '__ci_last_regenerate|i:1695747551;'), ('j8moq849jjqj99okj8r4019vj1u0vegg', '103.253.45.40', '1695747556', '__ci_last_regenerate|i:1695747556;'), ('b0knm8vfurepp07k5khgjj0icsf0223d', '103.253.45.40', '1695747556', '__ci_last_regenerate|i:1695747556;'), ('2irh48tfsv9eandlr1cgq7k727nodroj', '103.253.45.40', '1695747556', '__ci_last_regenerate|i:1695747556;'), ('bate9gaetfa9sbioseds1j57vgbgdff0', '103.253.45.40', '1695747556', '__ci_last_regenerate|i:1695747556;'), ('jl1sjkcuc4lc0ili9tis412npc9bit0k', '103.253.45.40', '1695747557', '__ci_last_regenerate|i:1695747557;'), ('q2g0jc28v31e5rro9m4soref8ls7m812', '103.253.45.40', '1695747560', '__ci_last_regenerate|i:1695747560;'), ('finrl86chrs2ms443tvso9q09ga14u9p', '103.253.45.40', '1695747724', '__ci_last_regenerate|i:1695747724;'), ('2cn9onpmp39hesoa9mbh6g0pt2rr96qh', '103.253.45.40', '1695747731', '__ci_last_regenerate|i:1695747731;'), ('anj65hctfdn2vsoqnvg66ine98hcgbc4', '103.253.45.40', '1695747738', '__ci_last_regenerate|i:1695747738;'), ('0qbke627taq0o6bcc3jtvn9sii0it444', '103.253.45.40', '1695747745', '__ci_last_regenerate|i:1695747745;'), ('8hdam0k1oif1icnn0e5k92ssrlj22p90', '103.253.45.40', '1695747746', '__ci_last_regenerate|i:1695747746;'), ('n9780dvajgk3smnauevjmjrpqdosn2m0', '103.253.45.40', '1695747746', '__ci_last_regenerate|i:1695747746;'), ('g8797i6sop4tr46vmhtpsdd8adc68eoi', '103.253.45.40', '1695747746', '__ci_last_regenerate|i:1695747746;'), ('euvbf3qtdsnge8f3e9n7lh35r4hk4ej3', '103.253.45.40', '1695747747', '__ci_last_regenerate|i:1695747747;'), ('ka378v3slh5npb4htng0goq4f99bng2g', '103.253.45.40', '1695747749', '__ci_last_regenerate|i:1695747749;'), ('1kqvbaa7ah41935801ek77016gilqjhs', '103.253.45.40', '1695747792', '__ci_last_regenerate|i:1695747792;'), ('3i2odfq1fossntncbng274n57s92deda', '103.253.45.40', '1695747795', '__ci_last_regenerate|i:1695747795;'), ('lgfiilh1s276qidgic7438cr3sefeu1t', '103.253.45.40', '1695747795', '__ci_last_regenerate|i:1695747795;'), ('eqe14ale8modriaafaunn0e2mu2tpump', '103.253.45.40', '1695747795', '__ci_last_regenerate|i:1695747795;'), ('hfg04skm59bbd93sg07n943pljg01n82', '103.253.45.40', '1695747795', '__ci_last_regenerate|i:1695747795;'), ('g4m2nj115fg5l969h3dgbitnn2t2s6b4', '103.253.45.40', '1695747795', '__ci_last_regenerate|i:1695747795;'), ('nj9p3gud6ec3k7qpulcknm3if9d0p3og', '103.253.45.40', '1695747795', '__ci_last_regenerate|i:1695747795;'), ('9hvqjtkfqtkbojd0nb6laqdmu10l1m15', '103.253.45.40', '1695747796', '__ci_last_regenerate|i:1695747796;'), ('cm4fd1m5q38bup2mifdikcneor5mvm9i', '103.253.45.40', '1695747878', '__ci_last_regenerate|i:1695747878;'), ('2j4hn37458dscapk3gpd99rs598khc8k', '103.253.45.40', '1695747884', '__ci_last_regenerate|i:1695747884;'), ('qs9632c8gno3jhi013mk5fr3n5kmm52i', '103.253.45.40', '1695747884', '__ci_last_regenerate|i:1695747884;'), ('s24rmmjupmkjciqraqp54182c4joc5gi', '103.253.45.40', '1695747884', '__ci_last_regenerate|i:1695747884;'), ('a4vkft3nhe4r67ldhpm1ljibokqpilkk', '103.253.45.40', '1695747885', '__ci_last_regenerate|i:1695747885;'), ('n2qr85234a8rqh7rtdtv7m5ct93g97td', '103.253.45.40', '1695747887', '__ci_last_regenerate|i:1695747887;'), ('6f6cgvcrdqgev9k5uritfr1f1i6ufl9h', '103.253.45.40', '1695747975', '__ci_last_regenerate|i:1695747975;'), ('l8jaoqh5gr71sm6fflamolvekjbam6v6', '103.253.45.40', '1695748114', '__ci_last_regenerate|i:1695748114;'), ('380a9t710ba7ta5hh2nh1gfv1i75pt0m', '103.253.45.40', '1695748118', '__ci_last_regenerate|i:1695748118;'), ('0jsmmun2l11pdoi23kbac7602gbeu5i9', '103.253.45.40', '1695748118', '__ci_last_regenerate|i:1695748118;'), ('9313she0tdmkcinb07bat373dp16bqut', '103.253.45.40', '1695748118', '__ci_last_regenerate|i:1695748118;'), ('ifkeui5cp3ivdd42q5hi22oll9mpl93g', '103.253.45.40', '1695748118', '__ci_last_regenerate|i:1695748118;'), ('ng3s3riis77kg3aj717t9g3ss5k5v27h', '103.253.45.40', '1695748118', '__ci_last_regenerate|i:1695748118;'), ('tjgo7uqpj8f7sqh708lf5v6jur4nt900', '103.253.45.40', '1695748118', '__ci_last_regenerate|i:1695748118;'), ('tivirm2s1rt8h5j7p2b4t4dnn7ig5evr', '103.253.45.40', '1695748118', '__ci_last_regenerate|i:1695748118;'), ('av103isgp0qet76n2u13cugdbt9ibies', '103.253.45.40', '1695748462', '__ci_last_regenerate|i:1695748462;'), ('inv3iq0qc5n5t201nsuu9tdnvjo6vapo', '103.253.45.40', '1695748462', '__ci_last_regenerate|i:1695748462;'), ('4lcpc58oifpin981oeqblvuu8qosdrn1', '103.253.45.40', '1695748462', '__ci_last_regenerate|i:1695748462;'), ('t4o8bv99kipkeu1tcppms1qfbjmilbet', '103.253.45.40', '1695748463', '__ci_last_regenerate|i:1695748463;'), ('vfhgprq83rnjb37mu0iiad69al3h0mfd', '103.253.45.40', '1695748465', '__ci_last_regenerate|i:1695748465;'), ('p4lv6hbsvrni66hffbk67jc5vdb172vo', '103.253.45.40', '1695748612', '__ci_last_regenerate|i:1695748612;'), ('a4nfgb3uhe309sp5u12aiduje7t1a499', '103.253.45.40', '1695748615', '__ci_last_regenerate|i:1695748615;'), ('682onmgdi709l9apk4jl8utvre35m4fp', '103.253.45.40', '1695748630', '__ci_last_regenerate|i:1695748630;'), ('qke3f2rr8spjnbg2d7mfjqu8jrqll6gf', '103.253.45.40', '1695748633', '__ci_last_regenerate|i:1695748633;'), ('i2qd57ko072r250p7s6f7f94gpemof3o', '103.253.45.40', '1695748633', '__ci_last_regenerate|i:1695748633;'), ('m22vtjpfaqg51tf34uumfecbep4q43hk', '103.253.45.40', '1695748633', '__ci_last_regenerate|i:1695748633;'), ('ja1fkbf32hajpp6msr06p2ejr6sdr4am', '103.253.45.40', '1695748633', '__ci_last_regenerate|i:1695748633;'), ('85v4jk9frfsei4q034rq63eqe1pe95of', '103.253.45.40', '1695748633', '__ci_last_regenerate|i:1695748633;'), ('n65pm6c36nictjk637439qn58n26qmnb', '103.253.45.40', '1695748633', '__ci_last_regenerate|i:1695748633;'), ('iddk2srhu3lfkfc3ls8qgf8q6lt4t2m4', '103.253.45.40', '1695748634', '__ci_last_regenerate|i:1695748634;'), ('psrbcb8cirm2vdde9vn1rirg6v997jh8', '103.253.45.40', '1695748636', '__ci_last_regenerate|i:1695748636;'), ('o5a45f4pdqtirht0j592m6e7ie5hasom', '103.253.45.40', '1695748636', '__ci_last_regenerate|i:1695748636;'), ('888vn187du6s7vter7s5hso0phqnoabm', '103.253.45.40', '1695748636', '__ci_last_regenerate|i:1695748636;'), ('b0ehpu674tnqnn3udaj756h7v2mptmm3', '103.253.45.40', '1695748637', '__ci_last_regenerate|i:1695748637;'), ('r09g89npq1fb4fj7s78gurkvmh78b1ji', '103.253.45.40', '1695748640', '__ci_last_regenerate|i:1695748640;'), ('iu0kv788qfu24m5d8ts4i307kntkq1ms', '103.253.45.40', '1695749098', '__ci_last_regenerate|i:1695749098;'), ('g4mdoupelga572ut12hf0g7m3l6ot0ub', '103.253.45.40', '1695749099', '__ci_last_regenerate|i:1695749099;'), ('cg2b1ldum8lj8amlt0018i71a6l94gra', '103.253.45.40', '1695749099', '__ci_last_regenerate|i:1695749099;'), ('ev7un0gktq4l01pdnglbir5b5ugi3jfj', '103.253.45.40', '1695749099', '__ci_last_regenerate|i:1695749099;'), ('88fqrcmkb7asudp0j2laekkughv12gbi', '103.253.45.40', '1695749099', '__ci_last_regenerate|i:1695749099;'), ('a5cns05vud5d1kg0gd2kfqvkn34dd0fo', '103.253.45.40', '1695749101', '__ci_last_regenerate|i:1695749101;'), ('qq2bsa1t97p58f25fjj5pus4mvhj2rfq', '103.253.45.40', '1695749345', '__ci_last_regenerate|i:1695749345;'), ('enol2jadm9s2knfc53jr8h38cm3plpbk', '103.253.45.40', '1695749352', '__ci_last_regenerate|i:1695749352;'), ('0lq1tjqgbk6lulcf3nm981gect765vlb', '103.253.45.40', '1695749352', '__ci_last_regenerate|i:1695749352;'), ('2bh0cqv7fq2sfb9pb7b8tfqpvp1gbjg9', '103.253.45.40', '1695749353', '__ci_last_regenerate|i:1695749353;'), ('7r9c95vvcmhr8ad40idrsldsvq9g7ms7', '103.253.45.40', '1695749353', '__ci_last_regenerate|i:1695749353;'), ('7tgcek9pp32a5a8mcgeduoa8pmq4lfgp', '103.253.45.40', '1695749353', '__ci_last_regenerate|i:1695749353;'), ('pfvu5t0qefgu2pllhh6ob15fb776aa72', '103.253.45.40', '1695749353', '__ci_last_regenerate|i:1695749353;'), ('o3km3jfpjlsbsbnvqpjhuf6d7hsrqgmo', '103.253.45.40', '1695749353', '__ci_last_regenerate|i:1695749353;'), ('075qtotc9kja2jqlo2b6ami4mhrrsjnj', '103.253.45.40', '1695749353', '__ci_last_regenerate|i:1695749353;'), ('qip30mf1i4mfeitgfk7jatbcnnual6on', '103.253.45.40', '1695749358', '__ci_last_regenerate|i:1695749358;'), ('onoijj2fgs9lrvhgggpvuphqp3o2jsg4', '103.253.45.40', '1695749362', '__ci_last_regenerate|i:1695749362;'), ('iikii09i7m5jbpicvub5f6vd3r1lv8hg', '103.253.45.40', '1695749362', '__ci_last_regenerate|i:1695749362;'), ('1h4f6mgk59k5lvbe2k76r0uj216a9cah', '103.253.45.40', '1695749362', '__ci_last_regenerate|i:1695749362;'), ('lah6195b84kkkvon5pa8kh03lscpobbt', '103.253.45.40', '1695749362', '__ci_last_regenerate|i:1695749362;'), ('lehfknia6fq3qqv4lmv76evflh8i4821', '103.253.45.40', '1695749362', '__ci_last_regenerate|i:1695749362;'), ('01fg76eo1jiovbkbft3tpo66mt109tll', '103.253.45.40', '1695749362', '__ci_last_regenerate|i:1695749362;'), ('nv8t1so1p54pp5d3ao9hdsea4hm1lf6j', '103.253.45.40', '1695749362', '__ci_last_regenerate|i:1695749362;'), ('48abfqbe3i45tsvoh7724dn60eliic94', '103.253.45.40', '1695749362', '__ci_last_regenerate|i:1695749362;'), ('ptkj4jb5jore267qkqs3n6l57rkhths1', '103.253.45.40', '1695749362', '__ci_last_regenerate|i:1695749362;'), ('4q3kgb8v74p2j02203m627td7oucm83t', '103.253.45.40', '1695749362', '__ci_last_regenerate|i:1695749362;'), ('dheh5c8vbke7jc06tminremdmapvpcdt', '103.253.45.40', '1695749363', '__ci_last_regenerate|i:1695749363;'), ('gdmkpnebmn0vnlq8i1k542vr8ivcvbcb', '103.253.45.40', '1695749367', '__ci_last_regenerate|i:1695749367;'), ('ucfaio4jjuv2q12m4c2v7vd1lkcbk6qh', '103.253.45.40', '1695749628', '__ci_last_regenerate|i:1695749628;'), ('da8elnph2ljcmtca75qoqbhuequp0g9c', '103.253.45.40', '1695749631', '__ci_last_regenerate|i:1695749631;'), ('6bihb091lopfmmore4qu9768r67ipge0', '103.253.45.40', '1695749631', '__ci_last_regenerate|i:1695749631;'), ('03pac8etu4crjallt0k5vsr13tc4h4v6', '103.253.45.40', '1695749631', '__ci_last_regenerate|i:1695749631;'), ('quujdd8cm5ofdb6a99ijsljf4gl3sp9n', '103.253.45.40', '1695749631', '__ci_last_regenerate|i:1695749631;'), ('snlev9h81vusod99r51okc6opqn2tml4', '103.253.45.40', '1695749631', '__ci_last_regenerate|i:1695749631;'), ('2vfgtb1hf9clfgogfvgvgod3fhnlde7m', '103.253.45.40', '1695749631', '__ci_last_regenerate|i:1695749631;'), ('4iv8ks5qelbi1bivb8qbsu8d7tfq1pgi', '103.253.45.40', '1695749632', '__ci_last_regenerate|i:1695749632;'), ('q47qlrb6urc6qkh5gg3rh80dnql118hl', '103.253.45.40', '1695749641', '__ci_last_regenerate|i:1695749641;'), ('28nt3e4qfnroknk7ap9jq524m5gnp9n2', '103.253.45.40', '1695749641', '__ci_last_regenerate|i:1695749641;'), ('bnkjg2sid4lcjf25c5f9ng642am8f2em', '103.253.45.40', '1695749641', '__ci_last_regenerate|i:1695749641;'), ('n4ip6niruk724u2n8q7vq4qq6795rdt3', '103.253.45.40', '1695749641', '__ci_last_regenerate|i:1695749641;'), ('384krjok2lrv7091jvrsj6vdm1iigje1', '103.253.45.40', '1695749642', '__ci_last_regenerate|i:1695749642;'), ('6bcrdjejtjrc22thj9l7pcrl77htv30s', '103.253.45.40', '1695749647', '__ci_last_regenerate|i:1695749647;'), ('lf7ckfo4n8mrqn3easat6mmrcoff1iis', '103.253.45.40', '1695750217', '__ci_last_regenerate|i:1695750217;'), ('rhla8strb59icjh1tsbd219p23q0qape', '103.253.45.40', '1695750228', '__ci_last_regenerate|i:1695750228;'), ('g089tn8vc64q04l1n8lhrrbkqec769mb', '103.253.45.40', '1695750231', '__ci_last_regenerate|i:1695750231;'), ('5026s5ci6k9qg8bpej5n5rr29tbehv9v', '103.253.45.40', '1695750231', '__ci_last_regenerate|i:1695750231;'), ('d5s1c8nodlicg14b4he1tt74lms2dhtp', '103.253.45.40', '1695750231', '__ci_last_regenerate|i:1695750231;'), ('bks4cioudpesk283kng61dhcskembhb3', '103.253.45.40', '1695750231', '__ci_last_regenerate|i:1695750231;'), ('8dp9aes3dolc8kkr2ilu1n77ni4j60ap', '103.253.45.40', '1695750231', '__ci_last_regenerate|i:1695750231;'), ('csacivi67co8fa0tiq8v18q3ljje5gam', '103.253.45.40', '1695750231', '__ci_last_regenerate|i:1695750231;'), ('dgbm04oildclqojgfrgbaus173l6fdq6', '103.253.45.40', '1695750231', '__ci_last_regenerate|i:1695750231;'), ('h8a8c0fjummqneggdv0ta7b4gfvl1ci0', '103.253.45.40', '1695750234', '__ci_last_regenerate|i:1695750234;'), ('1oufasm97md39vfcailbrojaib4crqru', '103.253.45.40', '1695750234', '__ci_last_regenerate|i:1695750234;'), ('so0romh3nfqhmipr9legsva07uc5ri6a', '103.253.45.40', '1695750234', '__ci_last_regenerate|i:1695750234;'), ('fcle996elgcidbjscl3odmukj81o6k8i', '103.253.45.40', '1695750234', '__ci_last_regenerate|i:1695750234;'), ('n357hsgnqdkfe5ibjdapgqqmouucoq2o', '103.253.45.40', '1695750235', '__ci_last_regenerate|i:1695750235;'), ('mgg9i14ghh3si5lqsg5o8a61t81onoi9', '103.253.45.40', '1695750236', '__ci_last_regenerate|i:1695750236;'), ('6ee6k1uks5rq8u4htehpbr07t89j7fn5', '103.253.45.40', '1695750328', '__ci_last_regenerate|i:1695750328;'), ('2ktg560eijo1d52s2gak4b2bt5a4788o', '103.253.45.40', '1695750330', '__ci_last_regenerate|i:1695750330;'), ('kf22mnh5ejfs4n38rh248qaheu1ge3j7', '103.253.45.40', '1695750827', '__ci_last_regenerate|i:1695750827;'), ('v0la4fit57kjhejvltokvupc9eitg5nb', '103.253.45.40', '1695750831', '__ci_last_regenerate|i:1695750831;'), ('shcgv9h6ftd3r1rsnpaskh5n2m143ogb', '103.253.45.40', '1695750831', '__ci_last_regenerate|i:1695750831;'), ('m7ki0m1icg8f944cvcl63l0rcih9ajj2', '103.253.45.40', '1695750831', '__ci_last_regenerate|i:1695750831;'), ('u93uh69r4nb35e0b48cuqq48agftu35e', '103.253.45.40', '1695750831', '__ci_last_regenerate|i:1695750831;'), ('jisv0iaqbcfk460s9crurd8iieqq2g1u', '103.253.45.40', '1695750831', '__ci_last_regenerate|i:1695750831;'), ('cfgp0i6rb0mbkcmpd8tlhogbbdfv2cc1', '103.253.45.40', '1695750831', '__ci_last_regenerate|i:1695750831;'), ('cp5h4nthboi37f51nmrm2dt6k6i06ibn', '103.253.45.40', '1695750831', '__ci_last_regenerate|i:1695750831;'), ('5p4vuuekqoea0lh7f1t3eac28h1u8kvn', '103.253.45.40', '1695750832', '__ci_last_regenerate|i:1695750832;'), ('04k1k01uamockmtsl838n3rcu01r0m4e', '103.253.45.40', '1695750832', '__ci_last_regenerate|i:1695750832;'), ('83j9dm9ae2qs975f67c6u1c6r2ho9r0u', '103.253.45.40', '1695750833', '__ci_last_regenerate|i:1695750833;'), ('tu8dq9ftq0pq0ibrmf8bakaq3ibev59h', '103.253.45.40', '1695750833', '__ci_last_regenerate|i:1695750833;'), ('uf47b2m9gac6p4hu5rfh6rlla3e3tffi', '103.253.45.40', '1695750836', '__ci_last_regenerate|i:1695750836;'), ('osrn99lqqcfe1hg1iht0uqrqel871j2q', '103.253.45.40', '1695750993', '__ci_last_regenerate|i:1695750993;'), ('1kjggkvp5vln6hb27cl513vm4f9a53oq', '103.253.45.40', '1695750996', '__ci_last_regenerate|i:1695750996;'), ('3hpj3pnum8v140gfgb3aq18glm204lqm', '103.253.45.40', '1695750996', '__ci_last_regenerate|i:1695750996;'), ('esoaa1e8i4d7d5u6itsu0vci3ebso3le', '103.253.45.40', '1695750996', '__ci_last_regenerate|i:1695750996;'), ('vtbe2hiofhjafvmjgj53rqiequj279pb', '103.253.45.40', '1695750996', '__ci_last_regenerate|i:1695750996;'), ('v0b65g2kl1fsmnrosdfrik8rmn922m2v', '103.253.45.40', '1695750996', '__ci_last_regenerate|i:1695750996;'), ('vl49vk3ftrn43sr7qmvkbqn662n86r29', '103.253.45.40', '1695750996', '__ci_last_regenerate|i:1695750996;'), ('4aepnrgq4nu4ldqog108pu1l9r19q5bc', '103.253.45.40', '1695750996', '__ci_last_regenerate|i:1695750996;'), ('3iukcdvir01ia9jsa4vq21g72aga4kqa', '103.253.45.40', '1695751001', '__ci_last_regenerate|i:1695751001;'), ('h8mtpqvk2ej8v3udil5qj6duaqkbas6u', '103.253.45.40', '1695751001', '__ci_last_regenerate|i:1695751001;'), ('a048ob91iigdccts0ihj2rfk36it1kvr', '103.253.45.40', '1695751001', '__ci_last_regenerate|i:1695751001;'), ('nj1jh1jkae4q0elfu2j7pvet18ndqb3g', '103.253.45.40', '1695751001', '__ci_last_regenerate|i:1695751001;'), ('lduj6fpprl6k7i6uuen556qb29591umg', '103.253.45.40', '1695751002', '__ci_last_regenerate|i:1695751002;'), ('r51rocst141jpbp24q8sau6jugv7io9i', '103.253.45.40', '1695751005', '__ci_last_regenerate|i:1695751005;'), ('q8120cbcuh72h6ik67esr4trj53h7eb5', '103.253.45.40', '1695751450', '__ci_last_regenerate|i:1695751450;'), ('g1j87rhjf92q108bg1c9f4mjap3ikmhq', '103.253.45.40', '1695751453', '__ci_last_regenerate|i:1695751453;'), ('258njerc561sot061adbg5b6833vb7po', '103.253.45.40', '1695751453', '__ci_last_regenerate|i:1695751453;'), ('k80jt7g0l2itjca83mn4e8qbj76bg8n4', '103.253.45.40', '1695751453', '__ci_last_regenerate|i:1695751453;'), ('53tihrjtq35hrn4afujs6q7fo8mdr9bo', '103.253.45.40', '1695751453', '__ci_last_regenerate|i:1695751453;'), ('13ar29umtr65v03tua35490lv9vcv499', '103.253.45.40', '1695751453', '__ci_last_regenerate|i:1695751453;'), ('r5fbno5t5esbm96fvm34nta4j4g8fqou', '103.253.45.40', '1695751453', '__ci_last_regenerate|i:1695751453;'), ('df58iojvj8fbkbv7otls1gilu72tg1ei', '103.253.45.40', '1695751453', '__ci_last_regenerate|i:1695751453;'), ('4uu7eghqtu9buousiqnhcgti1ujap1to', '103.253.45.40', '1695751455', '__ci_last_regenerate|i:1695751455;'), ('m2m40fe0h9fbv5o844or1p12tjkr2krg', '103.253.45.40', '1695751455', '__ci_last_regenerate|i:1695751455;'), ('0tqsqurff1me39pl9g50i4pre95blnie', '103.253.45.40', '1695751455', '__ci_last_regenerate|i:1695751455;'), ('icjrc4dqhtb0eh5luit909fvj2nqhjc2', '103.253.45.40', '1695751456', '__ci_last_regenerate|i:1695751456;'), ('a8pa64d1t51ahtio6erdtcr3ku2c226a', '103.253.45.40', '1695751458', '__ci_last_regenerate|i:1695751458;'), ('q3bhqq7e300tjlh8r6ilgeih228k998r', '103.253.45.40', '1695751713', '__ci_last_regenerate|i:1695751713;'), ('3i2qrjlgvellioims9o7mlit6kg8olcf', '103.253.45.40', '1695751717', '__ci_last_regenerate|i:1695751717;'), ('skt64opvljf14g4kda2n6v2er7vb0n33', '103.253.45.40', '1695751717', '__ci_last_regenerate|i:1695751717;'), ('25arvc6vveikru0rmaecgnhpbn0hmra5', '103.253.45.40', '1695751717', '__ci_last_regenerate|i:1695751717;'), ('8j86b5rh7q36t6k580atadslki8hfuj6', '103.253.45.40', '1695751717', '__ci_last_regenerate|i:1695751717;'), ('l55au8hcivl9n5aqu5ocr3jcunvv47po', '103.253.45.40', '1695751717', '__ci_last_regenerate|i:1695751717;'), ('17jspe7uktkc6btr1ki9705i7h93rr3e', '103.253.45.40', '1695751717', '__ci_last_regenerate|i:1695751717;'), ('kg3467pc7msnmplkfrrks09v3t0v6p5k', '103.253.45.40', '1695751718', '__ci_last_regenerate|i:1695751718;'), ('omv7s38up0lnq9tqrh53so32pnddc3rv', '103.253.45.40', '1695751720', '__ci_last_regenerate|i:1695751720;'), ('hof0g53rrpirolvg5r0qobeb840iueot', '103.253.45.40', '1695751720', '__ci_last_regenerate|i:1695751720;'), ('dqbqhg495tc7a4ok5c2gp5g5t7oqs2ig', '103.253.45.40', '1695751720', '__ci_last_regenerate|i:1695751720;'), ('ks4b8k3end15thmjtr3ks8masqpkma2d', '103.253.45.40', '1695751721', '__ci_last_regenerate|i:1695751721;'), ('a3r6g7ofijl513mjit68dejeris932t2', '103.253.45.40', '1695751728', '__ci_last_regenerate|i:1695751728;'), ('qrabb5tujb4k29p913a3jvkkruhboi0i', '103.253.45.40', '1695751874', '__ci_last_regenerate|i:1695751874;'), ('p93e415o7vpa855t4qcqvesl1e942coh', '103.253.45.40', '1695751875', '__ci_last_regenerate|i:1695751875;'), ('78t3s5fs4j3qlvlpii5iu36b1us5nsbh', '103.253.45.40', '1695751903', '__ci_last_regenerate|i:1695751903;'), ('9r340p96tkamlbneus59rosnkevmtkte', '103.253.45.40', '1695751905', '__ci_last_regenerate|i:1695751905;'), ('mi8urictie831jporaf0l7f94vvsojsf', '103.253.45.40', '1695752014', '__ci_last_regenerate|i:1695752014;'), ('gsf38v03kb73mn5mfricdg2gg8ok9rd9', '103.253.45.40', '1695752017', '__ci_last_regenerate|i:1695752017;'), ('ome062inuk5vccim5emoj5r4mkou05ec', '103.253.45.40', '1695752017', '__ci_last_regenerate|i:1695752017;'), ('tqfvgr4p6c4a4e7dbfur74spbgotpv47', '103.253.45.40', '1695752017', '__ci_last_regenerate|i:1695752017;'), ('c52qbbvr5phva2r0ogsa1eiloi258hpg', '103.253.45.40', '1695752017', '__ci_last_regenerate|i:1695752017;'), ('p270m5j996cfimhhg3kgad1sokq7g8t2', '103.253.45.40', '1695752017', '__ci_last_regenerate|i:1695752017;'), ('59fg01c2gjkc3257g810rc10vpt7ek87', '103.253.45.40', '1695752017', '__ci_last_regenerate|i:1695752017;'), ('kae1494ujjuie85anqi9k9u8t5ohc7n6', '103.253.45.40', '1695752017', '__ci_last_regenerate|i:1695752017;'), ('sp7ml2pmqm8kr67pkvovpi7ekub19j0j', '103.253.45.40', '1695752019', '__ci_last_regenerate|i:1695752019;'), ('6ul9jd04fa0n0dp7blkljnre2kt2nf4v', '103.253.45.40', '1695752019', '__ci_last_regenerate|i:1695752019;'), ('tgk4j3te4r5e7po44d85s2pndom96p7f', '103.253.45.40', '1695752019', '__ci_last_regenerate|i:1695752019;'), ('8nc35kmrs6cl7r2np00c2sno7c6p8092', '103.253.45.40', '1695752019', '__ci_last_regenerate|i:1695752019;'), ('qogkoieka3h2uns55lh0dnu68nvvpv4g', '103.253.45.40', '1695752049', '__ci_last_regenerate|i:1695752049;'), ('iip7p5rhfk7f4qgssvk9b8q4rquatqo4', '103.253.45.40', '1695752050', '__ci_last_regenerate|i:1695752050;'), ('ghb39vvunlo6hgra2vcip72jh7h1cc0u', '103.253.45.40', '1695752050', '__ci_last_regenerate|i:1695752050;'), ('2j0m8urrlbivrj6u5lrg02k1pgbh9c4n', '103.253.45.40', '1695752050', '__ci_last_regenerate|i:1695752050;'), ('j1tj1kdd8lv7liso5qetcglinkda9qv1', '103.253.45.40', '1695752050', '__ci_last_regenerate|i:1695752050;'), ('4a212ac1t2fsrjrcc40nd08tis4mfbe1', '103.253.45.40', '1695752050', '__ci_last_regenerate|i:1695752050;'), ('1g8c70uakiaq4k5cmqfhau9qb39ij8s8', '103.253.45.40', '1695752303', '__ci_last_regenerate|i:1695752303;'), ('e1mfmvn1m9uromh6ri5bml8e95tacvhu', '103.253.45.40', '1695752306', '__ci_last_regenerate|i:1695752306;'), ('q4ctc3fvsltrv35bmgb9j3pakrojmvls', '103.253.45.40', '1695752306', '__ci_last_regenerate|i:1695752306;'), ('vhcm3dulm1febg4a3il4kgud60ue8tm8', '103.253.45.40', '1695752306', '__ci_last_regenerate|i:1695752306;'), ('5hl2les6fem71upt9s9fu6vq3ugs75nk', '103.253.45.40', '1695752306', '__ci_last_regenerate|i:1695752306;'), ('j6votv481eoerns2du55r78qt5k00lj2', '103.253.45.40', '1695752306', '__ci_last_regenerate|i:1695752306;'), ('tcrmfsqqhij8209kb58c5moi55u07g6m', '103.253.45.40', '1695752306', '__ci_last_regenerate|i:1695752306;'), ('e6i3emstk2j5njel7hhqohffu0ck8hgs', '103.253.45.40', '1695752306', '__ci_last_regenerate|i:1695752306;'), ('fo109mcf3ldgim9tocpjtggf4nfetpui', '103.253.45.40', '1695752308', '__ci_last_regenerate|i:1695752308;'), ('3rkchmonqmio7gl8l0j2olrus5euektg', '103.253.45.40', '1695752308', '__ci_last_regenerate|i:1695752308;'), ('5veghsg2cgg2662r4chtqk2qu9ev6s63', '103.253.45.40', '1695752308', '__ci_last_regenerate|i:1695752308;'), ('1i689qaeu094augt99dhj1vdakrf78sg', '103.253.45.40', '1695752308', '__ci_last_regenerate|i:1695752308;'), ('0sica1k15lhecegv1va9trtjkei81ip0', '103.253.45.40', '1695752309', '__ci_last_regenerate|i:1695752309;'), ('f4e240l6mjoojcvb47k2oq65mi87t8c7', '103.253.45.40', '1695752311', '__ci_last_regenerate|i:1695752311;'), ('rgiljk33fg3n4kh4a7ora2fbo5uttjc4', '103.253.45.40', '1695752647', '__ci_last_regenerate|i:1695752647;'), ('no3csqcnss7lsib9nourmfqrs8tl25ev', '103.253.45.40', '1695752651', '__ci_last_regenerate|i:1695752651;'), ('3efl8o4behu2lh8fd4k93ba8rvai334k', '103.253.45.40', '1695752651', '__ci_last_regenerate|i:1695752651;'), ('6e6kjsktmeng5ts3kiusar6epos57ab5', '103.253.45.40', '1695752651', '__ci_last_regenerate|i:1695752651;'), ('5rs2ulp1qdsslnst5ot6dlg2ctmunf8r', '103.253.45.40', '1695752651', '__ci_last_regenerate|i:1695752651;'), ('p3k52s4n8pdbso57fgkmi1q6i0oibu4j', '103.253.45.40', '1695752651', '__ci_last_regenerate|i:1695752651;'), ('jubf8hcpdsj0p78039g8g10fgchg01q5', '103.253.45.40', '1695752651', '__ci_last_regenerate|i:1695752651;'), ('nab1h7kmkhgjiflpgml9kh0ksmb93eql', '103.253.45.40', '1695752651', '__ci_last_regenerate|i:1695752651;'), ('2lm6tcdeqkcda471f3ovhm60o5if7anv', '103.253.45.40', '1695752652', '__ci_last_regenerate|i:1695752652;'), ('74fi2aknl4flabg8bs40cq820jr5hqkg', '103.253.45.40', '1695752652', '__ci_last_regenerate|i:1695752652;'), ('us87eg91ihinotr67k454eoc1bk9s76f', '103.253.45.40', '1695752652', '__ci_last_regenerate|i:1695752652;'), ('qj4btduq8mgnb83ou1mdhd2tjjrp04gb', '103.253.45.40', '1695752653', '__ci_last_regenerate|i:1695752653;'), ('60sm5rjle69pn9ti7pjhavb7i5rq9fgp', '103.253.45.40', '1695752656', '__ci_last_regenerate|i:1695752656;'), ('iopl4agle3dhmtv3qi5isae7kjsu9qeg', '103.253.45.40', '1695752660', '__ci_last_regenerate|i:1695752660;'), ('o5ahi1v9psn362vh0f0tshp3hp3mfg7g', '103.253.45.40', '1695752736', '__ci_last_regenerate|i:1695752736;'), ('086r0vocj319ghvpj4h4aur6naosfbus', '103.253.45.40', '1695752747', '__ci_last_regenerate|i:1695752747;'), ('g2477midgs77t7qf4ijqokmme8h1t02e', '103.253.45.40', '1695752749', '__ci_last_regenerate|i:1695752749;'), ('e1jnck90g9gbo4r20bs8pfmti39eaudc', '103.253.45.40', '1695752750', '__ci_last_regenerate|i:1695752750;'), ('0uva0o5bqkk3c4j74qdpv7q02bnrlnfn', '103.253.45.40', '1695752750', '__ci_last_regenerate|i:1695752750;'), ('lg5smkjggreks60ikg50jqfctamlq9ps', '103.253.45.40', '1695752750', '__ci_last_regenerate|i:1695752750;'), ('ncfuhupbeoqsgos65tvad0623roa6k8l', '103.253.45.40', '1695752750', '__ci_last_regenerate|i:1695752750;'), ('ods4rrmmdj1p7tmg82gfskue77slisq1', '103.253.45.40', '1695752752', '__ci_last_regenerate|i:1695752752;'), ('53rdfg1su8rfhv931vu7elboo6bnfmvm', '103.253.45.40', '1695753704', '__ci_last_regenerate|i:1695753704;'), ('srr1embnb4qvq0hi9sj3etmaudpudprm', '103.253.45.40', '1695753707', '__ci_last_regenerate|i:1695753707;'), ('6pktlesj2avh72t46sgke2fhms6sn25p', '103.253.45.40', '1695753710', '__ci_last_regenerate|i:1695753710;'), ('odpm1mgtismeen4cfmqr60k8ch9q8iqg', '103.253.45.40', '1695753710', '__ci_last_regenerate|i:1695753710;'), ('kfabb6mmblj52rvpa6gvcdtb8sm82cgt', '103.253.45.40', '1695753710', '__ci_last_regenerate|i:1695753710;'), ('8h5onph9ld7tgq7dit3gnanakjlk8chp', '103.253.45.40', '1695753710', '__ci_last_regenerate|i:1695753710;'), ('g7hu57mmdnmp8udh872evn2r9ivdhtmj', '103.253.45.40', '1695753713', '__ci_last_regenerate|i:1695753713;'), ('45tdcttv0iguovkokp6ssi4sck84psmv', '103.253.45.40', '1695753796', '__ci_last_regenerate|i:1695753796;'), ('ln0feu7atvodhc29p4uc8a3i92kqn2ko', '103.253.45.40', '1695753805', '__ci_last_regenerate|i:1695753805;'), ('bmqfnk45fgergo5sil9t5lshqhschtok', '103.253.45.40', '1695753807', '__ci_last_regenerate|i:1695753807;'), ('teekjlf9ccoa98dctfcug5ten5lr7j5v', '103.253.45.40', '1695753809', '__ci_last_regenerate|i:1695753809;'), ('noso2c1vn6mubhs5vk726ol0acjtd13o', '103.253.45.40', '1695753809', '__ci_last_regenerate|i:1695753809;'), ('j7kvmiipr406b4qm969qai51ub5k8qbc', '103.253.45.40', '1695753809', '__ci_last_regenerate|i:1695753809;'), ('h9mvsqju0bgjjfvg7356lifga9cn36vk', '103.253.45.40', '1695753810', '__ci_last_regenerate|i:1695753810;'), ('392m7h25gu682imatlvdafcd6bfjtjcb', '103.253.45.40', '1695753812', '__ci_last_regenerate|i:1695753812;'), ('q161kjpb2s1kcov9kh0mlo76rjdao0cd', '103.253.45.40', '1695754285', '__ci_last_regenerate|i:1695754285;'), ('jhopcm8l1j51art0ngmfnkqah7jk5v0g', '103.253.45.40', '1695754288', '__ci_last_regenerate|i:1695754288;'), ('o5ruo29gmva7i5qchnte5qciap288mdo', '103.253.45.40', '1695754288', '__ci_last_regenerate|i:1695754288;'), ('8aaph38g16s14ph767o9k2fjcii36lrp', '103.253.45.40', '1695754288', '__ci_last_regenerate|i:1695754288;'), ('jgju9lrshh4s0j2tdtvvihhuuj4jo93j', '103.253.45.40', '1695754288', '__ci_last_regenerate|i:1695754288;'), ('ovofao23uhbhpos0bh5e18gu5qme2k1q', '103.253.45.40', '1695754288', '__ci_last_regenerate|i:1695754288;'), ('c4cauqje2o0l2jnb2uq1ttvp6p9n7hul', '103.253.45.40', '1695754288', '__ci_last_regenerate|i:1695754288;'), ('fnlogg3dd76placfule4biv39ohng5k1', '103.253.45.40', '1695754289', '__ci_last_regenerate|i:1695754289;'), ('vt5alarvcam3lhpb07v8j6ernsou0vui', '103.253.45.40', '1695754317', '__ci_last_regenerate|i:1695754317;'), ('3midrusbauhdesq89ssisg00ev0sduk5', '103.253.45.40', '1695754318', '__ci_last_regenerate|i:1695754318;'), ('0p4fo027mvqt13kb0dgrajpvvvsidf53', '103.253.45.40', '1695754318', '__ci_last_regenerate|i:1695754318;'), ('im7lbc1ni900hb33cl76bndb4f5klat6', '103.253.45.40', '1695754318', '__ci_last_regenerate|i:1695754318;'), ('jftlv4u6v4trsgob0nkoq4p836601m7j', '103.253.45.40', '1695754319', '__ci_last_regenerate|i:1695754319;'), ('afqnr0ogg5iih129v77k796tespacn33', '103.253.45.40', '1695754321', '__ci_last_regenerate|i:1695754321;'), ('q5ndmvj8e979c7pimbl9u7uilq5ll0hd', '103.253.45.40', '1695778182', '__ci_last_regenerate|i:1695778182;'), ('b9qv2k9ok5ntap8o3l7i5h5a96tf61tf', '103.253.45.40', '1695778185', '__ci_last_regenerate|i:1695778185;'), ('rodrq9u9pptn4krf03cb7ma7tk6bevtp', '103.253.45.40', '1695778185', '__ci_last_regenerate|i:1695778185;'), ('pouc6rrvrbhiefais255norflro3a1ag', '103.253.45.40', '1695778185', '__ci_last_regenerate|i:1695778185;'), ('s3j8qgs97jbteteejrbqkmfmppg19tub', '103.253.45.40', '1695778185', '__ci_last_regenerate|i:1695778185;'), ('i4600d9kd5u4lr6hqe0ojb72jrieogui', '103.253.45.40', '1695778185', '__ci_last_regenerate|i:1695778185;'), ('hlv5oer7vq19kme70f0j4if41guuhbno', '103.253.45.40', '1695778185', '__ci_last_regenerate|i:1695778185;'), ('u58ddsudft1io5q11opvl6fla131r3ep', '103.253.45.40', '1695778186', '__ci_last_regenerate|i:1695778186;'), ('lttedkcmv7o41cgve9d5afks69m0c087', '103.253.45.40', '1695778188', '__ci_last_regenerate|i:1695778188;'), ('ugpp4h3r19c0r9nbkmg3om5da4mrfoeu', '103.253.45.40', '1695778188', '__ci_last_regenerate|i:1695778188;'), ('p7f2ucailnh66uq4dlrnvrgrbf8sv4bi', '103.253.45.40', '1695778188', '__ci_last_regenerate|i:1695778188;'), ('ic6ejegpquj6dk48rigmh4so7ru786l7', '103.253.45.40', '1695778189', '__ci_last_regenerate|i:1695778189;'), ('b8rfjvhnv3g8lhg6rbl3f5ckhsq34r4g', '103.253.45.40', '1695778192', '__ci_last_regenerate|i:1695778192;'), ('3qo6gni98ktccgo7o9isifje6semaolc', '103.253.45.40', '1695778205', '__ci_last_regenerate|i:1695778205;'), ('s25vc6us4cjallo2urdntkntfm968mmf', '103.253.45.40', '1695778981', '__ci_last_regenerate|i:1695778981;'), ('6r83f2m8qhhdpq4dg5au5hr08glcgaf2', '103.253.45.40', '1695778984', '__ci_last_regenerate|i:1695778984;'), ('5r50e28b3rc1ecb15teaeq712ski24rk', '103.253.45.40', '1695778984', '__ci_last_regenerate|i:1695778984;'), ('fhjn2f1t7psn7c2a404t3edja3nvr05d', '103.253.45.40', '1695778984', '__ci_last_regenerate|i:1695778984;'), ('r3gksi3b3f1j5mv56ir3jofqrkj9gu8a', '103.253.45.40', '1695778984', '__ci_last_regenerate|i:1695778984;'), ('t8rla2mpm33olqncbnto3gi2a99f6r3a', '103.253.45.40', '1695778984', '__ci_last_regenerate|i:1695778984;'), ('gg6udqa23hmo6idl4nbfofqfkvnhei39', '103.253.45.40', '1695778984', '__ci_last_regenerate|i:1695778984;'), ('gtbqgporo2nhr1c37iph1c4l0aaieigs', '103.253.45.40', '1695778984', '__ci_last_regenerate|i:1695778984;'), ('e6o88kn8kbr3rug4jr2j2dfvgq3d4j1d', '103.253.45.40', '1695778985', '__ci_last_regenerate|i:1695778985;'), ('b0ohet3t5plhvasc2fuem8o916bpu4gp', '103.253.45.40', '1695778985', '__ci_last_regenerate|i:1695778985;'), ('krej2fjmceagl39d0gi7ga5h2kgft2kt', '103.253.45.40', '1695778985', '__ci_last_regenerate|i:1695778985;'), ('bmr8fn9vb6r8g2676ofdkvpfo3domab3', '103.253.45.40', '1695778985', '__ci_last_regenerate|i:1695778985;'), ('noq5phusovoi6ni29gol8p6k2t9n5tr8', '103.253.45.40', '1695778986', '__ci_last_regenerate|i:1695778986;'), ('garmfft7dcmb92odshv7og8cl37nscgv', '103.253.45.40', '1695778990', '__ci_last_regenerate|i:1695778990;'), ('59b88vqnkmvrt1k4cvb6d008ge04aegc', '103.253.45.40', '1695779201', '__ci_last_regenerate|i:1695779201;'), ('2co8faq9uirnerskqo6g9eg8btarqvf1', '103.253.45.40', '1695779206', '__ci_last_regenerate|i:1695779206;'), ('lenql3lpho0mcprfgs5dmt5kkb4gk36d', '103.253.45.40', '1695779215', '__ci_last_regenerate|i:1695779215;'), ('5j9077iensiq4bqu3kvb5ho7lf3ofh8e', '103.253.45.40', '1695779215', '__ci_last_regenerate|i:1695779215;'), ('vdjqtkdm48k08n1u1mcmlvfd8qp2u6de', '103.253.45.40', '1695779221', '__ci_last_regenerate|i:1695779221;'), ('f6ipvnmc35aak2u32ed2b51qs6ek60vj', '103.253.45.40', '1695779221', '__ci_last_regenerate|i:1695779221;'), ('qr0mftmud4eaak65aghljel58jlk7o61', '103.253.45.40', '1695779223', '__ci_last_regenerate|i:1695779223;'), ('d0icmuvri17tgadjfkvnbp6sicll908o', '103.253.45.40', '1695779240', '__ci_last_regenerate|i:1695779240;'), ('v2kapqoarcfsdh14qi95kk9cgl7tmkku', '103.253.45.40', '1695779256', '__ci_last_regenerate|i:1695779256;'), ('rgmmebniumbmoeq9se44kqu91cvndd66', '103.253.45.40', '1695779282', '__ci_last_regenerate|i:1695779282;'), ('iim28at55b7q56koo7qast5qu54lc45i', '103.253.45.40', '1695779283', '__ci_last_regenerate|i:1695779283;'), ('9gt74he3fi2jpr03atqkim2veme7b4ts', '103.253.45.40', '1695779284', '__ci_last_regenerate|i:1695779284;'), ('0jma0447vbs40kq3d2e5lp760lhiqv9q', '103.253.45.40', '1695779284', '__ci_last_regenerate|i:1695779284;'), ('pfg5stb5v0okft4vh0db7ksloirrrtq8', '103.253.45.40', '1695779284', '__ci_last_regenerate|i:1695779284;'), ('7fm11pdie5qbsna5kkd31b3bcopr9sta', '103.253.45.40', '1695779284', '__ci_last_regenerate|i:1695779284;'), ('6h51sshes4avq63ineieadkdqpj6tooh', '103.253.45.40', '1695779284', '__ci_last_regenerate|i:1695779284;'), ('er06stkd2u8h2r2gu74vmq9lvk485ek7', '103.253.45.40', '1695779285', '__ci_last_regenerate|i:1695779285;'), ('dgo2nbpjfh1qgtin76hui6l0k8datfue', '103.253.45.40', '1695779287', '__ci_last_regenerate|i:1695779287;'), ('43naf10iu823t6ikhhq2d0hn0rpt31bl', '103.253.45.40', '1695779287', '__ci_last_regenerate|i:1695779287;'), ('m8com0ubpe6qrs4r9piou99t1arrr594', '103.253.45.40', '1695779287', '__ci_last_regenerate|i:1695779287;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('3nj97k5bbepcvpe4haie04njjclffh26', '103.253.45.40', '1695779287', '__ci_last_regenerate|i:1695779287;'), ('8hd9fnq9of0jup30rsjusk9ao90mo3pc', '103.253.45.40', '1695779291', '__ci_last_regenerate|i:1695779291;'), ('fna7lgqp8bkatgbuqillg1atd9hmomi1', '103.253.45.40', '1695779347', '__ci_last_regenerate|i:1695779347;'), ('48l6pd6lopgkr2sotjfda68flv4iqu4r', '103.253.45.40', '1695779351', '__ci_last_regenerate|i:1695779351;'), ('pqips3i696p0nmgpitibs8a45if0ucbp', '103.253.45.40', '1695779351', '__ci_last_regenerate|i:1695779351;'), ('ho7ko13rp1nacaeqomnvapgmgek2fb1j', '103.253.45.40', '1695779351', '__ci_last_regenerate|i:1695779351;'), ('knvgtn68fldfavdc9emdr13cjk8qk41n', '103.253.45.40', '1695779351', '__ci_last_regenerate|i:1695779351;'), ('7isn4c0gmcsnvmq4jgoknvttla15d6k9', '103.253.45.40', '1695779351', '__ci_last_regenerate|i:1695779351;'), ('8rppml2g3ka282gkbnooktbj0tah7k54', '103.253.45.40', '1695779351', '__ci_last_regenerate|i:1695779351;'), ('0su3ej4q8vqv8pp09pealf57tfqlhmkr', '103.253.45.40', '1695779363', '__ci_last_regenerate|i:1695779363;'), ('jq1rh92ldp69hnpjm98cv6c85q0ltodv', '103.253.45.40', '1695779363', '__ci_last_regenerate|i:1695779363;'), ('c1b550eihs5ocem50jlr22lop2vfgseo', '103.253.45.40', '1695780346', '__ci_last_regenerate|i:1695780346;'), ('966nbp9o1ub8rglmp6dtm1n0gnvph238', '103.253.45.40', '1695780349', '__ci_last_regenerate|i:1695780349;'), ('u82panvsfncun3p2pf4sh4hvfi5p39sf', '103.253.45.40', '1695780349', '__ci_last_regenerate|i:1695780349;'), ('sndul497p340ho7as2fjl05h3e0b8gn7', '103.253.45.40', '1695780349', '__ci_last_regenerate|i:1695780349;'), ('5f40bmbtpa96n1r1ogri1m607uhu4r4i', '103.253.45.40', '1695780349', '__ci_last_regenerate|i:1695780349;'), ('v1cm1gpfnrfthlde1711ndeq4j8k1t57', '103.253.45.40', '1695780349', '__ci_last_regenerate|i:1695780349;'), ('22r01jvvu27gc2r9bg4osq6jf6svnan6', '103.253.45.40', '1695780349', '__ci_last_regenerate|i:1695780349;'), ('mqenbe2bopupqk46qqcjf0ug0q717ihm', '103.253.45.40', '1695780350', '__ci_last_regenerate|i:1695780350;'), ('23taqcbh1vnf5h30tlvu88f5qbles40j', '103.253.45.40', '1695780928', '__ci_last_regenerate|i:1695780928;'), ('bhulb5ljrqj5uqaul6a460ntisnslo3c', '103.253.45.40', '1695780931', '__ci_last_regenerate|i:1695780931;'), ('rc7but2ouun60ptne9hkj1hrqf9lar23', '103.253.45.40', '1695780931', '__ci_last_regenerate|i:1695780931;'), ('69pr80t1446li1jr9mm4i9ol890kaosr', '103.253.45.40', '1695780931', '__ci_last_regenerate|i:1695780931;'), ('82fv301oadiajlp6r6732omnjq7c5tnu', '103.253.45.40', '1695780931', '__ci_last_regenerate|i:1695780931;'), ('e9tgcp68qeq0ie670jcg3i7v0pgjpu3r', '103.253.45.40', '1695780931', '__ci_last_regenerate|i:1695780931;'), ('jhk3lq5tnpn3ucs6n6svrvu1srrbu5j0', '103.253.45.40', '1695780931', '__ci_last_regenerate|i:1695780931;'), ('b0t3cu7a2gcd03pjuemskdh89uk8rrh7', '103.253.45.40', '1695780932', '__ci_last_regenerate|i:1695780932;'), ('1d5faph4as84urqd5ehfijtl5ml7q475', '103.253.45.40', '1695780935', '__ci_last_regenerate|i:1695780935;'), ('l6l29fmub0r38ddeetvtiohnkgm9fdf4', '103.253.45.40', '1695780935', '__ci_last_regenerate|i:1695780935;'), ('jn6oh1dntanha08jkh9fpphd7qpqtf2v', '103.253.45.40', '1695780935', '__ci_last_regenerate|i:1695780935;'), ('5mqrjf2o2s37jg5m0id7hqg4jj5t0oqf', '103.253.45.40', '1695780936', '__ci_last_regenerate|i:1695780936;'), ('n6lpcleat704efjfrm3q42iinupuilvq', '103.253.45.40', '1695781585', '__ci_last_regenerate|i:1695781585;'), ('vgq28tj147dom0et6pg0lgcgmh90jqrt', '103.253.45.40', '1695781588', '__ci_last_regenerate|i:1695781588;'), ('4cj1sr0h2vk68dq166uh80u8d3v9sehr', '103.253.45.40', '1695781588', '__ci_last_regenerate|i:1695781588;'), ('cqb682v5b3iin866vqdjtctdeu1ppqn5', '103.253.45.40', '1695781588', '__ci_last_regenerate|i:1695781588;'), ('v67s3b6djteva8467g50icfvnqbf9gqg', '103.253.45.40', '1695781588', '__ci_last_regenerate|i:1695781588;'), ('8etc00o7jdkqda1nilop75rnmb6ctopp', '103.253.45.40', '1695781588', '__ci_last_regenerate|i:1695781588;'), ('0qttkkomoo9rvbkchnev0npauq169sk0', '103.253.45.40', '1695781588', '__ci_last_regenerate|i:1695781588;'), ('pp6orl1lj76ihtk3qa48sns23lh8fgpk', '103.253.45.40', '1695781589', '__ci_last_regenerate|i:1695781589;'), ('77g8n5nc24s09lioockvradg161pc6lp', '103.253.45.40', '1695781590', '__ci_last_regenerate|i:1695781590;'), ('mas6irjifsbl3uf8o97i0h43j4g4pp2i', '103.253.45.40', '1695781590', '__ci_last_regenerate|i:1695781590;'), ('5f2blasctpmcto9m3762fbsl8vne49mo', '103.253.45.40', '1695781590', '__ci_last_regenerate|i:1695781590;'), ('3vc5v8eu7414am8prm1k413r1qb8v1vn', '103.253.45.40', '1695781591', '__ci_last_regenerate|i:1695781591;'), ('o2h1p0t7l331el5sp2a8h7ks2v32lbhs', '103.253.45.40', '1695782393', '__ci_last_regenerate|i:1695782393;'), ('rj3lc16g0l7lb5aq74bn9ep0upml402q', '103.253.45.40', '1695782396', '__ci_last_regenerate|i:1695782396;'), ('rg27su6p23hvu69k04isqudq2b09iic9', '103.253.45.40', '1695782396', '__ci_last_regenerate|i:1695782396;'), ('m32enfptsh5lbf2potjk5q4afl8q4ejs', '103.253.45.40', '1695782396', '__ci_last_regenerate|i:1695782396;'), ('6oedc39agfkngs4bhvpp0im40i4f5maa', '103.253.45.40', '1695782396', '__ci_last_regenerate|i:1695782396;'), ('nue2sa7b316kcofpm9fgciauhob1bspd', '103.253.45.40', '1695782396', '__ci_last_regenerate|i:1695782396;'), ('n9ijhbabk48giq3qnjthohnnnullp1c5', '103.253.45.40', '1695782396', '__ci_last_regenerate|i:1695782396;'), ('kud8ckouh4s9c2275tjmabqejqt7g6dh', '103.253.45.40', '1695782397', '__ci_last_regenerate|i:1695782397;'), ('go80q4htls3dnru1jt4g3p83hvmdin22', '103.253.45.40', '1695782406', '__ci_last_regenerate|i:1695782406;'), ('d2ojrs87v7megi0pgct5jf0rsi04ngbk', '103.253.45.40', '1695782406', '__ci_last_regenerate|i:1695782406;'), ('njoqj1b100eq1hq9rdeacvnh0pjm8r1b', '103.253.45.40', '1695782406', '__ci_last_regenerate|i:1695782406;'), ('vqtue51didct2ug5v3t337knk16jm77o', '103.253.45.40', '1695782406', '__ci_last_regenerate|i:1695782406;'), ('dcgh17gqmspfsq0a5gp6vup4vhuph004', '103.253.45.40', '1695782407', '__ci_last_regenerate|i:1695782407;'), ('9b2e828g84cc4vfeln8rdbhjc3h70fad', '103.253.45.40', '1695782506', '__ci_last_regenerate|i:1695782506;'), ('ge7tnkkceaa5p45a8vmb59ku48ehfnbc', '103.253.45.40', '1695782510', '__ci_last_regenerate|i:1695782510;'), ('94ndvfqgnkmqb97i2enll376guf4hn17', '103.253.45.40', '1695782510', '__ci_last_regenerate|i:1695782510;'), ('fasdvlm256h0hsiuu03k7qdvf1p39c4s', '103.253.45.40', '1695782510', '__ci_last_regenerate|i:1695782510;'), ('fatd1r5ojeg0mnb0j2ouki7kb8iqo9u9', '103.253.45.40', '1695782510', '__ci_last_regenerate|i:1695782510;'), ('rh7t7tbh9ig99mkso27if187av1d6es3', '103.253.45.40', '1695782510', '__ci_last_regenerate|i:1695782510;'), ('i1096fj0cki49hatjaolm791t1lp887s', '103.253.45.40', '1695782510', '__ci_last_regenerate|i:1695782510;'), ('rtkjdg6ccj7muqsr2j0q74qioeq9kfpc', '103.253.45.40', '1695782510', '__ci_last_regenerate|i:1695782510;'), ('5ah6atua129b1hq494dfj7v6s1uk54nc', '103.253.45.40', '1695782514', '__ci_last_regenerate|i:1695782514;'), ('e54bjviecl40o4quhi49h1baqk33oq4e', '103.253.45.40', '1695782514', '__ci_last_regenerate|i:1695782514;'), ('nhg7ilbdmcht5jtg30k7qv5mjpsmr26o', '103.253.45.40', '1695782514', '__ci_last_regenerate|i:1695782514;'), ('0pjvhj3lcp0e646ufohufm6vii2tegcp', '103.253.45.40', '1695782515', '__ci_last_regenerate|i:1695782515;'), ('tbcdc2gpqmvd69e8b5snc73fe4782o0h', '103.253.45.40', '1695782580', '__ci_last_regenerate|i:1695782580;'), ('dnfutg79nr2ur3blhegjfp1sv27dos9r', '103.253.45.40', '1695782583', '__ci_last_regenerate|i:1695782583;'), ('m5b10a73aeg90em4msb8hmtj20lagkug', '103.253.45.40', '1695782583', '__ci_last_regenerate|i:1695782583;'), ('f4tcu5iq8kk8711bnhl0alvsihur8s0v', '103.253.45.40', '1695782583', '__ci_last_regenerate|i:1695782583;'), ('p7snksvaj6dbndm7fk82uqegoao84fth', '103.253.45.40', '1695782583', '__ci_last_regenerate|i:1695782583;'), ('mipdbc614deg0pvpl3focmgouvlohuj6', '103.253.45.40', '1695782583', '__ci_last_regenerate|i:1695782583;'), ('5mac33ur21hlh5gk6udjr2otn645gbbc', '103.253.45.40', '1695782583', '__ci_last_regenerate|i:1695782583;'), ('ceg5dj9i14a17c083lk21u7kha72k30n', '103.253.45.40', '1695782584', '__ci_last_regenerate|i:1695782584;'), ('fcme8umn3jpdl13d8kadc7nkdcb4go8i', '103.253.45.40', '1695782585', '__ci_last_regenerate|i:1695782585;'), ('7qqnl74pr59h0v22mvtft4m60sc4d02v', '103.253.45.40', '1695782585', '__ci_last_regenerate|i:1695782585;'), ('2pc8mcbpqfk8l0mmvthflh4bj40nt8tb', '103.253.45.40', '1695782585', '__ci_last_regenerate|i:1695782585;'), ('uivn9huus1isq8j4umhdbj43ao1jtjit', '103.253.45.40', '1695782585', '__ci_last_regenerate|i:1695782585;'), ('asbilbpmo8niilv612re1omq4jv515ek', '103.253.45.40', '1695782586', '__ci_last_regenerate|i:1695782586;'), ('jkkpbnkare1tpvg704am8j5815bsjk40', '103.253.45.40', '1695782656', '__ci_last_regenerate|i:1695782656;'), ('506senecbvsb336seo7eqovbufodt24b', '103.253.45.40', '1695782660', '__ci_last_regenerate|i:1695782660;'), ('8ne2k73tdgut2u58prmp76t7ha3n0959', '103.253.45.40', '1695782660', '__ci_last_regenerate|i:1695782660;'), ('vl5bm40opina6m4qkqeeh56llr4s1f27', '103.253.45.40', '1695782660', '__ci_last_regenerate|i:1695782660;'), ('5fjeb1r5b9nki192pi8f355fi4an4nj4', '103.253.45.40', '1695782660', '__ci_last_regenerate|i:1695782660;'), ('h93ji2n4lj0qlav74vi3rud565i45lfl', '103.253.45.40', '1695782660', '__ci_last_regenerate|i:1695782660;'), ('044vg7s3s8ki51os3i26mkjdrnqo3bea', '103.253.45.40', '1695782660', '__ci_last_regenerate|i:1695782660;'), ('feu2qetq2o5dhvtcn58qj5fs58u6loe3', '103.253.45.40', '1695782660', '__ci_last_regenerate|i:1695782660;'), ('7c8mlj0as26spgi6dv72pkh7ltvkesbh', '103.253.45.40', '1695782667', '__ci_last_regenerate|i:1695782667;'), ('d25ph5ksctm5qhb3ot9uritjvkq2pkop', '103.253.45.40', '1695782667', '__ci_last_regenerate|i:1695782667;'), ('dbsqv7mue5loklvknfl8n3uh2ghdjve7', '103.253.45.40', '1695782667', '__ci_last_regenerate|i:1695782667;'), ('3l9192l283vr922vg7rimo1jkmql4pd6', '103.253.45.40', '1695782667', '__ci_last_regenerate|i:1695782667;'), ('3u0mnamfsnkc1jfhdnh50pmpeg28q656', '103.253.45.40', '1695782668', '__ci_last_regenerate|i:1695782668;'), ('11vufvolrcgv8ohl4rg8t2p2hnelur5h', '103.253.45.40', '1695782722', '__ci_last_regenerate|i:1695782722;'), ('0dhpldcoll5oaq7f7hno2q0u0ospt72e', '103.253.45.40', '1695782725', '__ci_last_regenerate|i:1695782725;'), ('aqpjgqhkr0h5a6brtnlbtalmsh4si0n1', '103.253.45.40', '1695782725', '__ci_last_regenerate|i:1695782725;'), ('ple2ii9vtu99grotnrdo471ehobdtrar', '103.253.45.40', '1695782725', '__ci_last_regenerate|i:1695782725;'), ('3j1libmtoiususc9rgfc8odg8o4al0la', '103.253.45.40', '1695782725', '__ci_last_regenerate|i:1695782725;'), ('mljqv7n9cht229nb22rmtp4gbpm7s783', '103.253.45.40', '1695782725', '__ci_last_regenerate|i:1695782725;'), ('khkgseh3tij2c8hrmhuoa5qbn4dehjvm', '103.253.45.40', '1695782725', '__ci_last_regenerate|i:1695782725;'), ('6235ms5f9sl98ohcfdrbmbbrf44quq8o', '103.253.45.40', '1695782726', '__ci_last_regenerate|i:1695782726;'), ('69mmhfmkdiomvce1qcgtm5q1oti8rr8k', '103.253.45.40', '1695782728', '__ci_last_regenerate|i:1695782728;'), ('17tvksnb9uuk309vmoqb1bci81jdilub', '103.253.45.40', '1695782728', '__ci_last_regenerate|i:1695782728;'), ('v0608s143kk76ndjcrkodsce5vid1m4v', '103.253.45.40', '1695782728', '__ci_last_regenerate|i:1695782728;'), ('p27vse2e0rn4t7ajqcjq6vl4eu2d13dl', '103.253.45.40', '1695782729', '__ci_last_regenerate|i:1695782729;'), ('k3d8fq26phenedr7te7acff0sicfiri1', '103.253.45.40', '1695782828', '__ci_last_regenerate|i:1695782828;'), ('0sretcu1tou0rmqqelp3gf4njrjkqq0c', '103.253.45.40', '1695782887', '__ci_last_regenerate|i:1695782887;'), ('k2mdbkrnv6jcos8guk7d4gicgmc8o0t2', '103.253.45.40', '1695782891', '__ci_last_regenerate|i:1695782891;'), ('6qic6qkn47p20a55f8b80j7l99fev9t3', '103.253.45.40', '1695782891', '__ci_last_regenerate|i:1695782891;'), ('0esafum03morqlmnnct5sgc0fg4rgnv9', '103.253.45.40', '1695782891', '__ci_last_regenerate|i:1695782891;'), ('54u4g8nodf94jbpcgrcm2sou3fg90eo0', '103.253.45.40', '1695782891', '__ci_last_regenerate|i:1695782891;'), ('fv9nmt7627mrq8f60nt2ljlthfsup8km', '103.253.45.40', '1695782891', '__ci_last_regenerate|i:1695782891;'), ('efimoetaa94k9mttmstm07gvm84dgh7s', '103.253.45.40', '1695782891', '__ci_last_regenerate|i:1695782891;'), ('t1lk98v8rcvsq1gqfcodopgu7mf2hf42', '103.253.45.40', '1695782891', '__ci_last_regenerate|i:1695782891;'), ('ppjpegrddhv7tf701cvne2qceurve21r', '103.253.45.40', '1695782893', '__ci_last_regenerate|i:1695782893;'), ('bhcsmhjj9pblj4j81c9pf0ie0dmehbt4', '103.253.45.40', '1695782893', '__ci_last_regenerate|i:1695782893;'), ('1eldhs586eej2k6j13fvftvgshnftspt', '103.253.45.40', '1695782893', '__ci_last_regenerate|i:1695782893;'), ('cd7ubfo2iue5aim1h2u5d0uffo8e8kbi', '103.253.45.40', '1695782894', '__ci_last_regenerate|i:1695782894;'), ('1sjvn78p3mib139cj6tpc5h63e156jns', '103.253.45.40', '1695782915', '__ci_last_regenerate|i:1695782915;'), ('bu7jfjh0g1sa9u2071v2ed82t95jp4qr', '103.253.45.40', '1695782918', '__ci_last_regenerate|i:1695782918;'), ('rar38l81j6tuab7d6s3etem5gb1k4fc1', '103.253.45.40', '1695782919', '__ci_last_regenerate|i:1695782919;'), ('7sme4ptvsfo6eb85ndsojopui7qs41u2', '103.253.45.40', '1695782919', '__ci_last_regenerate|i:1695782919;'), ('jnt2951osfo5pdfln13algp1gvmiei84', '103.253.45.40', '1695782919', '__ci_last_regenerate|i:1695782919;'), ('9kod1m8sqs0e8dbg9a9m6rasg99hebog', '103.253.45.40', '1695782920', '__ci_last_regenerate|i:1695782920;'), ('vgvu84uc4qu2luctme41ufb1cklcbqmp', '103.253.45.40', '1695782995', '__ci_last_regenerate|i:1695782995;'), ('fv51hedsnvqvbkq5tq1evefjubec7n7n', '103.253.45.40', '1695782998', '__ci_last_regenerate|i:1695782998;'), ('594ailuh68fgjmf0hgk3i6evo0q5bg2u', '103.253.45.40', '1695782998', '__ci_last_regenerate|i:1695782998;'), ('c84q953q3ukrb9nrk0o7bli46nif7prd', '103.253.45.40', '1695782998', '__ci_last_regenerate|i:1695782998;'), ('27hs5fqg0n38d87ofrq87k24v3djpnkl', '103.253.45.40', '1695782998', '__ci_last_regenerate|i:1695782998;'), ('vq67e2i35mmt7g752qs75nf0bammpf3s', '103.253.45.40', '1695782998', '__ci_last_regenerate|i:1695782998;'), ('vq4cfl0bfg81su11u27ri6sntv8eqiuq', '103.253.45.40', '1695782998', '__ci_last_regenerate|i:1695782998;'), ('9kqtk6fod4ttjfjqil5u1h221694k8cc', '103.253.45.40', '1695782999', '__ci_last_regenerate|i:1695782999;'), ('4amlvoa8gcbt7d0ma7k9r6s8q5v1kft0', '103.253.45.40', '1695783001', '__ci_last_regenerate|i:1695783001;'), ('6kltgevh1le7t85cu32s9be2ugo667qm', '103.253.45.40', '1695783001', '__ci_last_regenerate|i:1695783001;'), ('8g17k126nrjettfpvkair6m5fj5dk225', '103.253.45.40', '1695783001', '__ci_last_regenerate|i:1695783001;'), ('fm5pfrokta6oandmeakk5nmbagpiqvij', '103.253.45.40', '1695783001', '__ci_last_regenerate|i:1695783001;'), ('7f515672rhbctj5udpu0eujaadktc002', '103.253.45.40', '1695783002', '__ci_last_regenerate|i:1695783002;'), ('t9rt095upfe5jm5g351s5qa4cju0qrl4', '103.253.45.40', '1695783036', '__ci_last_regenerate|i:1695783036;'), ('rbn9e50c1uac7icnbmlvie7hg3t4iup4', '103.253.45.40', '1695783040', '__ci_last_regenerate|i:1695783040;'), ('0iv95c9n6tv0ivn77qesaqb0e3np7c9q', '103.253.45.40', '1695783040', '__ci_last_regenerate|i:1695783040;'), ('pahfi4i9h3gngpgjk6cifjstu6ik24lj', '103.253.45.40', '1695783040', '__ci_last_regenerate|i:1695783040;'), ('0si883f7tjv8vevlfaq1hel7usp0nr11', '103.253.45.40', '1695783040', '__ci_last_regenerate|i:1695783040;'), ('14mq73gurpmid9pg2l2qg5qeg2to11q2', '103.253.45.40', '1695783040', '__ci_last_regenerate|i:1695783040;'), ('d5tcqpj7ockk2bbuafqlmpm4dks9odei', '103.253.45.40', '1695783041', '__ci_last_regenerate|i:1695783041;'), ('43ae2acif9jqqr30njbunijkndq7ept5', '103.253.45.40', '1695783105', '__ci_last_regenerate|i:1695783105;'), ('0gu1j0g6du3e6c0a9o5nj6m9qih9puku', '103.253.45.40', '1695783108', '__ci_last_regenerate|i:1695783108;'), ('ft5nd001q4nsl89vs9v1464c0tf5e76j', '103.253.45.40', '1695783109', '__ci_last_regenerate|i:1695783109;'), ('tfet1b9863l6kisc7p5seg6olmuaobt7', '103.253.45.40', '1695783109', '__ci_last_regenerate|i:1695783109;'), ('0mcuutr2gicq2vjmv060f6qvkk69ah91', '103.253.45.40', '1695783109', '__ci_last_regenerate|i:1695783109;'), ('d343svh32di8f9hbrgtpsedgsekjci95', '103.253.45.40', '1695783109', '__ci_last_regenerate|i:1695783109;'), ('0grpobj51n0onjpunisbikhjckcrtgeh', '103.253.45.40', '1695783109', '__ci_last_regenerate|i:1695783109;'), ('fqkuh0p926gtcft0vt1sic8vqn8c3vt1', '103.253.45.40', '1695783109', '__ci_last_regenerate|i:1695783109;'), ('1v4mne6sfg9crgs94bmcuqr5clr7h0jv', '103.253.45.40', '1695783113', '__ci_last_regenerate|i:1695783113;'), ('kjv68ppk7hll0isbnlj10ng1l5o8s3vh', '103.253.45.40', '1695783113', '__ci_last_regenerate|i:1695783113;'), ('n9n4v7teak0qps07ve6ttnrig5fso4ra', '103.253.45.40', '1695783113', '__ci_last_regenerate|i:1695783113;'), ('o39upm1mr0t4eg2gl3v4lv2rf6klf58t', '103.253.45.40', '1695783113', '__ci_last_regenerate|i:1695783113;'), ('mif8bdsiv3hvcfaql1fesmfjrkdn114u', '103.253.45.40', '1695783114', '__ci_last_regenerate|i:1695783114;'), ('pqi9flj34q7auj492dbqnkavq6okmrte', '103.253.45.40', '1695783242', '__ci_last_regenerate|i:1695783242;'), ('plbndebqnn0h3tvkqlhb6v54ugjsropm', '103.253.45.40', '1695783245', '__ci_last_regenerate|i:1695783245;'), ('e0nufsahttelum9gsngi76ncnmmlhbo6', '103.253.45.40', '1695783245', '__ci_last_regenerate|i:1695783245;'), ('2c4034ad12ert77usf3vda5lunkmc9ji', '103.253.45.40', '1695783245', '__ci_last_regenerate|i:1695783245;'), ('j2s001835ut9nnad2krc948foqbq1lvb', '103.253.45.40', '1695783245', '__ci_last_regenerate|i:1695783245;'), ('2mq2uupq39e7kl5u68tmshqac71ki17n', '103.253.45.40', '1695783245', '__ci_last_regenerate|i:1695783245;'), ('4u0b3b146odteo4tdvo1shtiho32ioc6', '103.253.45.40', '1695783245', '__ci_last_regenerate|i:1695783245;'), ('98204l42u0j58gppdeb6pjgn6v5o2hh9', '103.253.45.40', '1695783246', '__ci_last_regenerate|i:1695783246;'), ('l556idmau4mugdg31gia947pdh3i1pm8', '103.253.45.40', '1695783247', '__ci_last_regenerate|i:1695783247;'), ('h9gnt8fo65c9502d3uno953fmj1c6jen', '103.253.45.40', '1695783247', '__ci_last_regenerate|i:1695783247;'), ('pjmiaddfpc8d3je25ej7huq98dfg7o1g', '103.253.45.40', '1695783247', '__ci_last_regenerate|i:1695783247;'), ('ka52b6pi734684j70efrpj6tqbhevejh', '103.253.45.40', '1695783248', '__ci_last_regenerate|i:1695783248;'), ('7nnrobpktoijc4a3abqps3tvt4o7rsv4', '103.253.45.40', '1695783760', '__ci_last_regenerate|i:1695783760;'), ('htv2vloprat9vadtjtsfktothgh8272r', '103.253.45.40', '1695783763', '__ci_last_regenerate|i:1695783763;'), ('a6g2sur72ioutk1efa8ldoq8lt2l0f2c', '103.253.45.40', '1695783763', '__ci_last_regenerate|i:1695783763;'), ('t7ec9ium3p13oapclilhgle46h9bs6t9', '103.253.45.40', '1695783763', '__ci_last_regenerate|i:1695783763;'), ('1e2co6juta04s9t4ne01cgmvqdtu9rjc', '103.253.45.40', '1695783763', '__ci_last_regenerate|i:1695783763;'), ('0bt9m4942bsv799s4nppv078sh08rov2', '103.253.45.40', '1695783979', '__ci_last_regenerate|i:1695783979;'), ('hbtierhadqjc29k5cr0i4s4s3a2q8mnb', '103.253.45.40', '1695783983', '__ci_last_regenerate|i:1695783983;'), ('muj1san6ocpnms3mhdcjfbv7a4n6cjqt', '103.253.45.40', '1695783983', '__ci_last_regenerate|i:1695783983;'), ('ro9nvslniucn83v42kh6p8mikb5t8lk5', '103.253.45.40', '1695783983', '__ci_last_regenerate|i:1695783983;'), ('gm2j92utl9munu2935640ai3ocguh27a', '103.253.45.40', '1695783983', '__ci_last_regenerate|i:1695783983;'), ('4c0lf75f1c06sl7qao2sge6igcv3j4qb', '103.253.45.40', '1695783983', '__ci_last_regenerate|i:1695783983;'), ('3rflp49ov9cq17pcgv2nfo65ti00jgoj', '103.253.45.40', '1695783983', '__ci_last_regenerate|i:1695783983;'), ('fhqhhokhulvk6te76b1v2s6ggqru30lj', '103.253.45.40', '1695783983', '__ci_last_regenerate|i:1695783983;'), ('5fcdjlkl7l6n7gpb6mi3j9gkhjhker3a', '103.253.45.40', '1695783984', '__ci_last_regenerate|i:1695783984;'), ('ggo24571j7sqk5i6pu7tnaoibf5lnr3m', '103.253.45.40', '1695783984', '__ci_last_regenerate|i:1695783984;'), ('jvhrebpvd5ouf4s26u114vnfghm08c6d', '103.253.45.40', '1695783984', '__ci_last_regenerate|i:1695783984;'), ('lnetu13sovj42iiv98kpab8pc300ar49', '103.253.45.40', '1695783984', '__ci_last_regenerate|i:1695783984;'), ('ch4a5rop3m71l738mj4hp3rvi02m2d36', '103.253.45.40', '1695783985', '__ci_last_regenerate|i:1695783985;'), ('lu0ga9o479k1h15p3ondh7bd655h7mt8', '103.253.45.40', '1695784019', '__ci_last_regenerate|i:1695784019;'), ('lipmd5es037krvglhleoka26t11qtmol', '103.253.45.40', '1695784022', '__ci_last_regenerate|i:1695784022;'), ('d9h3d8p8its91vgirftm6vsgrdc3grrj', '103.253.45.40', '1695784022', '__ci_last_regenerate|i:1695784022;'), ('oc90k9j8iemvkmj5mejmqka0nj71f5p0', '103.253.45.40', '1695784022', '__ci_last_regenerate|i:1695784022;'), ('bn87h5s8i7hm61fk23oshjmdrmjn8mkf', '103.253.45.40', '1695784022', '__ci_last_regenerate|i:1695784022;'), ('0h4latahjsk6c8lahdb5o5sadnlleop7', '103.253.45.40', '1695784022', '__ci_last_regenerate|i:1695784022;'), ('236q43mue17gh54tbpvasr12sdan4vo9', '103.253.45.40', '1695784022', '__ci_last_regenerate|i:1695784022;'), ('diq5ab9hn043nd3dfd2v2tu6bmjgplgf', '103.253.45.40', '1695784023', '__ci_last_regenerate|i:1695784023;'), ('qganul7slf5sbk8ghdgioj4f1cr1mita', '103.253.45.40', '1695784024', '__ci_last_regenerate|i:1695784024;'), ('98iejnom3oprp306qs1o16co69o03nso', '103.253.45.40', '1695784024', '__ci_last_regenerate|i:1695784024;'), ('egi13s0mnicevh8mvknfm1ap9k2h1ok2', '103.253.45.40', '1695784024', '__ci_last_regenerate|i:1695784024;'), ('ng41tt0k4ud64k98spk7qtqj9c1l88h6', '103.253.45.40', '1695784025', '__ci_last_regenerate|i:1695784025;'), ('l873o0e4pg18t3qd70targ2f15h1c43h', '103.253.45.40', '1695784356', '__ci_last_regenerate|i:1695784356;'), ('hmvbv2fbim8lv394n78mde4sbf8o2hkb', '103.253.45.40', '1695784359', '__ci_last_regenerate|i:1695784359;'), ('51hjkf9i66gf5f7g2gr2iptgc1ietilf', '103.253.45.40', '1695784359', '__ci_last_regenerate|i:1695784359;'), ('ndiqdb27k65r8191061n9m1av6nld13b', '103.253.45.40', '1695784359', '__ci_last_regenerate|i:1695784359;'), ('in675ps6p48d1etc9uirrk0g3rkg3sod', '103.253.45.40', '1695784359', '__ci_last_regenerate|i:1695784359;'), ('mpuk5qjhchi45g8dbma3pksce0f5beo7', '103.253.45.40', '1695784359', '__ci_last_regenerate|i:1695784359;'), ('fj7n7ph5klbn8hs0rhivmh6aascflm8e', '103.253.45.40', '1695784359', '__ci_last_regenerate|i:1695784359;'), ('bqvpfan1j0jlnlnc59qt6kf5jk0d7vue', '103.253.45.40', '1695784360', '__ci_last_regenerate|i:1695784360;'), ('lfr0jj2ttd7ve048ke6m22u7c7fl1vgs', '103.253.45.40', '1695784364', '__ci_last_regenerate|i:1695784364;'), ('4trk4g3udd134fsfbq7tke9rgio3fbva', '103.253.45.40', '1695784364', '__ci_last_regenerate|i:1695784364;'), ('nfc0e6coq3r8nvtvdfgj7bcb90749ivk', '103.253.45.40', '1695784364', '__ci_last_regenerate|i:1695784364;'), ('e97qu31v1103q479esm45vh6qqumolep', '103.253.45.40', '1695784364', '__ci_last_regenerate|i:1695784364;'), ('emek74n3u1g2h1v699bsathiu734nnf0', '103.253.45.40', '1695784365', '__ci_last_regenerate|i:1695784365;'), ('m7k4e9i5o6tc61rlctiab03igiafosoi', '103.253.45.40', '1695784422', '__ci_last_regenerate|i:1695784422;'), ('s3pv3jh3i8esed5aeef2338qdj4956t3', '103.253.45.40', '1695784426', '__ci_last_regenerate|i:1695784426;'), ('8lhaggntf1e7ik33lms3kra1jv02vfhd', '103.253.45.40', '1695784426', '__ci_last_regenerate|i:1695784426;'), ('endup4u6vm5k2vlo91d45o66up4rkhbr', '103.253.45.40', '1695784426', '__ci_last_regenerate|i:1695784426;'), ('h2qlgcvgk2lttp8e173kh0490cpvh01t', '103.253.45.40', '1695784426', '__ci_last_regenerate|i:1695784426;'), ('65dldh9t0iu3jd4esf939rrbo9s19dv1', '103.253.45.40', '1695784426', '__ci_last_regenerate|i:1695784426;'), ('22a12c38csr8qn9hvl2nckittp1ghfvg', '103.253.45.40', '1695784426', '__ci_last_regenerate|i:1695784426;'), ('rjt8hoipn66il7eibhlc0o7r9um3jdch', '103.253.45.40', '1695784427', '__ci_last_regenerate|i:1695784427;'), ('ama0nuv1unfk45m5a6rcd51e31i03aas', '103.253.45.40', '1695784427', '__ci_last_regenerate|i:1695784427;'), ('3i84s46b0eopqvjitcujnfh9lud2rbpm', '103.253.45.40', '1695784427', '__ci_last_regenerate|i:1695784427;'), ('7crepbc6tv9pdhinucosj33cd4gpoct8', '103.253.45.40', '1695784427', '__ci_last_regenerate|i:1695784427;'), ('bq7fglc3hbjdohf7fdha1s1ko6tb8qfb', '103.253.45.40', '1695784428', '__ci_last_regenerate|i:1695784428;'), ('9hoejobc4ltfmmd94efsronb2h26u1ho', '103.253.45.40', '1695784517', '__ci_last_regenerate|i:1695784517;'), ('sp221ib2vi4h3pd28erouu3vfholc9g1', '103.253.45.40', '1695784520', '__ci_last_regenerate|i:1695784520;'), ('kd7hhsp07a0etf5fb4sh9nrtfnc28gkf', '103.253.45.40', '1695784520', '__ci_last_regenerate|i:1695784520;'), ('6n9aii57pfi96kpvlqjf0hff0sbr0j0k', '103.253.45.40', '1695784520', '__ci_last_regenerate|i:1695784520;'), ('dj3e79q4ualqmp253o4njv5qkmnuuvig', '103.253.45.40', '1695784520', '__ci_last_regenerate|i:1695784520;'), ('jo72rl2ipbn1d0v00jmc830limsp79i1', '103.253.45.40', '1695784520', '__ci_last_regenerate|i:1695784520;'), ('qe5s1qnnv4h52e1h64mcd2da9270tr4l', '103.253.45.40', '1695784520', '__ci_last_regenerate|i:1695784520;'), ('fn4q031r7nfm7oglopfvlqkqtgbrvn1u', '103.253.45.40', '1695784522', '__ci_last_regenerate|i:1695784522;'), ('lb3udkma6uq2d2315esle2l4l9d4fet8', '103.253.45.40', '1695784522', '__ci_last_regenerate|i:1695784522;'), ('gbptul66un0381882dbfhqto6gjsjmn5', '103.253.45.40', '1695784522', '__ci_last_regenerate|i:1695784522;'), ('ai1vpa2mlq9bqb9f7hnh0m01a0ljdkru', '103.253.45.40', '1695784522', '__ci_last_regenerate|i:1695784522;'), ('8clbg1qt769rkko731vplui07oopn373', '103.253.45.40', '1695784524', '__ci_last_regenerate|i:1695784524;'), ('a3c47ch1cedjalm8acg0roo2v3kap3qg', '103.253.45.40', '1695784901', '__ci_last_regenerate|i:1695784901;'), ('5odt20q8k539aq9sabbmprudt65tfhs9', '103.253.45.40', '1695784904', '__ci_last_regenerate|i:1695784904;'), ('9rfs0aq4ugs57dnpq9jetei74pr8csfk', '103.253.45.40', '1695784904', '__ci_last_regenerate|i:1695784904;'), ('1f4elp4fn7mmtp9nspba56pqcub4a8pc', '103.253.45.40', '1695784904', '__ci_last_regenerate|i:1695784904;'), ('pkl1gaaggdfdphrsn82n2ved9b7t6lu1', '103.253.45.40', '1695784904', '__ci_last_regenerate|i:1695784904;'), ('l27uirumktfgftcnctvspd1aiad0fjbg', '103.253.45.40', '1695784904', '__ci_last_regenerate|i:1695784904;'), ('9g34f3f4ko551514a4lc6tdhj2une0aq', '103.253.45.40', '1695784904', '__ci_last_regenerate|i:1695784904;'), ('g5msdksco3ptfu65r3rl9l5rt5n6anvj', '103.253.45.40', '1695784905', '__ci_last_regenerate|i:1695784905;'), ('aqia6fti0i295mj5h2lkf58euagout6u', '103.253.45.40', '1695784906', '__ci_last_regenerate|i:1695784906;'), ('3pqnv7a4qbg7qvom686mkpgca3mql3f0', '103.253.45.40', '1695784906', '__ci_last_regenerate|i:1695784906;'), ('ei4tlcs22hka6reiiuhi50al27qht6el', '103.253.45.40', '1695784906', '__ci_last_regenerate|i:1695784906;'), ('52k5dmqj0t0d5ke2q0vgagl5l09m9b0g', '103.253.45.40', '1695784906', '__ci_last_regenerate|i:1695784906;'), ('5tibjbh3nushnit3g8gqbt0h377f245d', '103.253.45.40', '1695784907', '__ci_last_regenerate|i:1695784907;'), ('pudng5oa23pjeaqka03u901hva0jj88v', '103.253.45.40', '1695784963', '__ci_last_regenerate|i:1695784963;'), ('6pfr3k8bvq6cg6ou3vg84l99u167ej9f', '103.253.45.40', '1695784967', '__ci_last_regenerate|i:1695784967;'), ('0msfd1qsh4tannrqjq5j4dmj452ogadm', '103.253.45.40', '1695784967', '__ci_last_regenerate|i:1695784967;'), ('11au5nnfpgv76itpoc7jprl3hbtl07pk', '103.253.45.40', '1695784967', '__ci_last_regenerate|i:1695784967;'), ('8as42mmhb02m6scpaarjf0vrbam20us9', '103.253.45.40', '1695784967', '__ci_last_regenerate|i:1695784967;'), ('g9q9s2h6n4idtd8d3g0thpplgecitgdf', '103.253.45.40', '1695784967', '__ci_last_regenerate|i:1695784967;'), ('sck4r7cavtfh73f7lg20ejj828h8q3lr', '103.253.45.40', '1695784967', '__ci_last_regenerate|i:1695784967;'), ('4sjidk5ahmpgkkkr40kcev5ui53gutmn', '103.253.45.40', '1695784967', '__ci_last_regenerate|i:1695784967;'), ('kfoohufmd6toi4o72sjm9l0hluvou8lv', '103.253.45.40', '1695784967', '__ci_last_regenerate|i:1695784967;'), ('vtpf5ofve8bdqlbl9geb5dcgl3vqjuc5', '103.253.45.40', '1695784967', '__ci_last_regenerate|i:1695784967;'), ('f93aqibot23stc3dtgqo8hstneujudhd', '103.253.45.40', '1695784967', '__ci_last_regenerate|i:1695784967;'), ('3cdc1303sus1d4ovhjpuhf9sg738vrg3', '103.253.45.40', '1695784967', '__ci_last_regenerate|i:1695784967;'), ('ak33t7fa2opt1dc1vp3cagltf50npjko', '103.253.45.40', '1695784968', '__ci_last_regenerate|i:1695784968;'), ('nee108dec5eq0slkhrncklac5r05in2a', '103.253.45.40', '1695785021', '__ci_last_regenerate|i:1695785021;'), ('7qcedvbgepks10lk88seml95657dhuop', '103.253.45.40', '1695785073', '__ci_last_regenerate|i:1695785073;'), ('6cfdqv6icf1udl0e2sc0uiu53b1qb487', '103.253.45.40', '1695785077', '__ci_last_regenerate|i:1695785077;'), ('5tom1q37afb1l31pk39infakljplsbhf', '103.253.45.40', '1695785077', '__ci_last_regenerate|i:1695785077;'), ('hlsbg7djc8ff5h4djh2bs0utlla81hb4', '103.253.45.40', '1695785077', '__ci_last_regenerate|i:1695785077;'), ('4534lid05k121urk982jbkd4pj55f787', '103.253.45.40', '1695785077', '__ci_last_regenerate|i:1695785077;'), ('kl5qlna318tcfibqd49e75puj2gicafn', '103.253.45.40', '1695785077', '__ci_last_regenerate|i:1695785077;'), ('p0qh93fidcr7tsra5afd1ihdr78ajd77', '103.253.45.40', '1695785077', '__ci_last_regenerate|i:1695785077;'), ('1jsim76208kp59u0klendc99sn67ak8a', '103.253.45.40', '1695785077', '__ci_last_regenerate|i:1695785077;'), ('autluskeeb2kd3f69hq8nb64nbfkt9k9', '103.253.45.40', '1695785079', '__ci_last_regenerate|i:1695785079;'), ('qdub8oss1tfrjgces3pdob0bjk3648am', '103.253.45.40', '1695785079', '__ci_last_regenerate|i:1695785079;'), ('7rq4ukahlmv9su98ps1pq774s1nhe5bi', '103.253.45.40', '1695785079', '__ci_last_regenerate|i:1695785079;'), ('l651jd8kr5s1nap5l7tr5dtbqmh5m3i6', '103.253.45.40', '1695785079', '__ci_last_regenerate|i:1695785079;'), ('dllnef06jv60qde50g7etqacefu0218a', '103.253.45.40', '1695785079', '__ci_last_regenerate|i:1695785079;'), ('tker4qmhulo1bhgrl387ofo8meecs174', '103.253.45.40', '1695785164', '__ci_last_regenerate|i:1695785164;'), ('vjlho1cdjciqe3vctajdj4gn5n6dfjdn', '103.253.45.40', '1695785167', '__ci_last_regenerate|i:1695785167;'), ('eobloo5cd27rhakdl1as5au94746racm', '103.253.45.40', '1695785167', '__ci_last_regenerate|i:1695785167;'), ('95qu2kd2v194imk301545b7o6bc2tlcl', '103.253.45.40', '1695785167', '__ci_last_regenerate|i:1695785167;'), ('ufant86psgkjfpplb5bvfkvr070ebte0', '103.253.45.40', '1695785167', '__ci_last_regenerate|i:1695785167;'), ('94dom75v1cnit1inj7pqoifu2g2cqmgu', '103.253.45.40', '1695785167', '__ci_last_regenerate|i:1695785167;'), ('higgjkotr96bhagqp0vd6e4g7kjj2n39', '103.253.45.40', '1695785167', '__ci_last_regenerate|i:1695785167;'), ('r2j8ebjcicant6ipf8evtsmba176rmi7', '103.253.45.40', '1695785168', '__ci_last_regenerate|i:1695785168;'), ('dcur10kssj8h6tou7gc63jcpe0f32dkn', '103.253.45.40', '1695785168', '__ci_last_regenerate|i:1695785168;'), ('0na0gce0dj5gae8it4qchprk706a2b2i', '103.253.45.40', '1695785168', '__ci_last_regenerate|i:1695785168;'), ('el0n0k8ud80tj133iilaf738230f1ank', '103.253.45.40', '1695785168', '__ci_last_regenerate|i:1695785168;'), ('qi6u89qjudb1h70aq3kh5lkqfgv2eq53', '103.253.45.40', '1695785168', '__ci_last_regenerate|i:1695785168;'), ('7v4nv9vgt9nbefqksu8bm8gjgess5lk6', '103.253.45.40', '1695785169', '__ci_last_regenerate|i:1695785169;'), ('1ts9t20pinhfouhbkq8gl8390ur7ujsd', '103.253.45.40', '1695785190', '__ci_last_regenerate|i:1695785190;'), ('cpkcrna4hte437v6b8gaji4d9vluk3lf', '103.253.45.40', '1695785194', '__ci_last_regenerate|i:1695785194;'), ('00j40vk9670rm0f6n4stjmdp9e95rt12', '103.253.45.40', '1695785194', '__ci_last_regenerate|i:1695785194;'), ('s07eb94den0jfvikf6hi6ljebqrj2h4o', '103.253.45.40', '1695785194', '__ci_last_regenerate|i:1695785194;'), ('mbe8d7qp0474gjfaae2uqd3iea6m93hq', '103.253.45.40', '1695785194', '__ci_last_regenerate|i:1695785194;'), ('ttifegidhenjtmo8gue5jcg87e1n0s50', '103.253.45.40', '1695785194', '__ci_last_regenerate|i:1695785194;'), ('vdct869b714rbiihc4rjqtcutsri36mj', '103.253.45.40', '1695785194', '__ci_last_regenerate|i:1695785194;'), ('jor63l8bf1o56hrui4sv4uf0vs1p0a7d', '103.253.45.40', '1695785194', '__ci_last_regenerate|i:1695785194;'), ('vagpeefm74mosfa8tm4htjpptj6mgnm9', '103.253.45.40', '1695785195', '__ci_last_regenerate|i:1695785195;'), ('tn213et1e0bf8no5317do80prvdg9dnu', '103.253.45.40', '1695785195', '__ci_last_regenerate|i:1695785195;'), ('t26rhvla1ap48q363hgcdqpgfv572og8', '103.253.45.40', '1695785195', '__ci_last_regenerate|i:1695785195;'), ('0gj4shn1q9ngungnekjdppagtjif11qj', '103.253.45.40', '1695785195', '__ci_last_regenerate|i:1695785195;'), ('mi1p9lass4ljam2m4laan28rtln3r31t', '103.253.45.40', '1695785196', '__ci_last_regenerate|i:1695785196;'), ('ovm1543d6lllth017ursi95ivf7vc819', '103.253.45.40', '1695785262', '__ci_last_regenerate|i:1695785262;'), ('ofroktgl5ek4ghtidipp12q4do7t3ibf', '103.253.45.40', '1695785266', '__ci_last_regenerate|i:1695785266;'), ('2dd6d1mhuntqbtj3jicl833r678g7jm8', '103.253.45.40', '1695785266', '__ci_last_regenerate|i:1695785266;'), ('m92ejnak6q5aiqs9njtdmiu8g3gavdi9', '103.253.45.40', '1695785266', '__ci_last_regenerate|i:1695785266;'), ('jcjggj0fos95vfkariu6a56qmqqdqul2', '103.253.45.40', '1695785266', '__ci_last_regenerate|i:1695785266;'), ('8nsuf2clh9ke7uk4qqc93ad7ftkbbmgp', '103.253.45.40', '1695785266', '__ci_last_regenerate|i:1695785266;'), ('p96kcipiojqjgaldpif9oi408rcn847l', '103.253.45.40', '1695785266', '__ci_last_regenerate|i:1695785266;'), ('1s4p7hp3p0p5jsr00a3ofk8bimoesd30', '103.253.45.40', '1695785266', '__ci_last_regenerate|i:1695785266;'), ('s79ip9e1ckn339hp7lrjra4sg281fk57', '103.253.45.40', '1695785267', '__ci_last_regenerate|i:1695785267;'), ('5csr86u2246jt292tmbrqa6rj8p1sjvq', '103.253.45.40', '1695785267', '__ci_last_regenerate|i:1695785267;'), ('ide2fsk99tk259cj5mdgm9ascthnug38', '103.253.45.40', '1695785267', '__ci_last_regenerate|i:1695785267;'), ('ggl3sikb0lg2s3oht63vab3rqhuok49o', '103.253.45.40', '1695785268', '__ci_last_regenerate|i:1695785268;'), ('tf1nehs5av3bhjanl4kkvameav85kmgm', '103.253.45.40', '1695785285', '__ci_last_regenerate|i:1695785285;'), ('0rl1gmpll2kuho7076a718sapt8qtqi1', '103.253.45.40', '1695785288', '__ci_last_regenerate|i:1695785288;'), ('jhh7h2re6m2lmgbkb3337mnm2vgt45lr', '103.253.45.40', '1695785288', '__ci_last_regenerate|i:1695785288;'), ('r7egr32rao1segag9h4mbpsv9euba96m', '103.253.45.40', '1695785288', '__ci_last_regenerate|i:1695785288;'), ('uragic0dt2do0kick8ot2ukcn5psh13p', '103.253.45.40', '1695785288', '__ci_last_regenerate|i:1695785288;'), ('t9q3r7hm472bkgcbb9g1ndb2ou0dl81a', '103.253.45.40', '1695785288', '__ci_last_regenerate|i:1695785288;'), ('kpijn84l5il1276mp4aetg0tv94jau16', '103.253.45.40', '1695785288', '__ci_last_regenerate|i:1695785288;'), ('1ju9n02u9qpsqeek5ai7vh70bvhqc7an', '103.253.45.40', '1695785288', '__ci_last_regenerate|i:1695785288;'), ('7e31dpara324pulk18vubpggl26tv29t', '103.253.45.40', '1695785289', '__ci_last_regenerate|i:1695785289;'), ('qldjqqchnnhh4pp480bsjtpb4u6aq7c0', '103.253.45.40', '1695785289', '__ci_last_regenerate|i:1695785289;'), ('vcv76kienmam5pmr7aoattua1gkc18t4', '103.253.45.40', '1695785289', '__ci_last_regenerate|i:1695785289;'), ('6g2fd1tar86gi3fjcsm3tc518qqdm08g', '103.253.45.40', '1695785289', '__ci_last_regenerate|i:1695785289;'), ('cktul2g7fo45f22a5thn6lgq1qn0h19r', '103.253.45.40', '1695785290', '__ci_last_regenerate|i:1695785290;'), ('gd919k7g08n4qk2j28clc0b0s85ig9oj', '103.253.45.40', '1695785292', '__ci_last_regenerate|i:1695785292;'), ('rsjd4qraameur83s898k2nst968q56a7', '103.253.45.40', '1695785292', '__ci_last_regenerate|i:1695785292;'), ('sbgu733dmin8bq7tt6m6e9hvmle09d7g', '103.253.45.40', '1695785292', '__ci_last_regenerate|i:1695785292;'), ('lefe6ls7f9vg9ma2e7kn0086iiqi50ph', '103.253.45.40', '1695785292', '__ci_last_regenerate|i:1695785292;'), ('5uvp9aj8ljfoevifds5775ffe2mnlk45', '103.253.45.40', '1695785292', '__ci_last_regenerate|i:1695785292;'), ('b2a8uhtjo1bfia938jsv63imb6c0mvk8', '103.253.45.40', '1695785292', '__ci_last_regenerate|i:1695785292;'), ('rdfrcnov50raut88fb1jtdopqgnfdnss', '103.253.45.40', '1695785293', '__ci_last_regenerate|i:1695785293;'), ('9h8ri618gvbgehrf9j79055adqrhpdgr', '103.253.45.40', '1695785460', '__ci_last_regenerate|i:1695785460;'), ('m7unus4htf4c713epsr34ilp4fodc25h', '103.253.45.40', '1695785460', '__ci_last_regenerate|i:1695785460;'), ('ohm3mms82jmhatmn56j2olnugnpijtl0', '103.253.45.40', '1695785460', '__ci_last_regenerate|i:1695785460;'), ('fsth7n58876e9r4d9jeop69tslmldeo9', '103.253.45.40', '1695785460', '__ci_last_regenerate|i:1695785460;'), ('kjsgquv7pg2lo2nta5ub55vjd7brlddg', '103.253.45.40', '1695785460', '__ci_last_regenerate|i:1695785460;'), ('2u8ccpdtakip64qqdg5f8rct6qdgbm4h', '103.253.45.40', '1695785460', '__ci_last_regenerate|i:1695785460;'), ('b9jfcdop7d3v74jn0k4m7ie8flirbeum', '103.253.45.40', '1695785460', '__ci_last_regenerate|i:1695785460;'), ('qsod2mgfs77giae54etf8897rc68b7ud', '103.253.45.40', '1695785461', '__ci_last_regenerate|i:1695785461;'), ('m8u2igeegn99oa5n8ga1jdp73t7079rv', '103.253.45.40', '1695785541', '__ci_last_regenerate|i:1695785541;'), ('1m7bpu5svjmphpktjjnndb7kmrk1k99f', '103.253.45.40', '1695785544', '__ci_last_regenerate|i:1695785544;'), ('cqdlrmt08evbck6eoesua3s9g8bthlca', '103.253.45.40', '1695785544', '__ci_last_regenerate|i:1695785544;'), ('4v7100uk8ofqpq7tsmf5e79lqv3pupat', '103.253.45.40', '1695785544', '__ci_last_regenerate|i:1695785544;'), ('q0ao0vqrmafcreur35fv8evp66sl52k1', '103.253.45.40', '1695785544', '__ci_last_regenerate|i:1695785544;'), ('am71t911jed1ils33rmvmu89kna0anl9', '103.253.45.40', '1695785544', '__ci_last_regenerate|i:1695785544;'), ('eljo6nmqg60ne9nnsntsl4fb71fhjg81', '103.253.45.40', '1695785544', '__ci_last_regenerate|i:1695785544;'), ('gqd6h9l8n0p6e1f2amsbr97oiqph0mog', '103.253.45.40', '1695785544', '__ci_last_regenerate|i:1695785544;'), ('pdf3lrjd59ivv7p3mjrf36pn7aevl95o', '103.253.45.40', '1695785545', '__ci_last_regenerate|i:1695785545;'), ('1mpbpd301an4ik8fm7o22vc5k8iomu0b', '103.253.45.40', '1695785545', '__ci_last_regenerate|i:1695785545;'), ('41tt1hkhess7nq5anmfrcmd6u9f05qna', '103.253.45.40', '1695785545', '__ci_last_regenerate|i:1695785545;'), ('3dqu1moq4c749kan50bf6tlvm0gagb0l', '103.253.45.40', '1695785545', '__ci_last_regenerate|i:1695785545;'), ('3it8g5gsv983u1fb3eoop5l1h7h7ordi', '103.253.45.40', '1695785546', '__ci_last_regenerate|i:1695785546;'), ('5m0quh0toq8ha838buh3bfo89h4hsvho', '103.253.45.40', '1695785558', '__ci_last_regenerate|i:1695785558;'), ('hr50rhni4n8al86n678eqtbgct5l0ies', '103.253.45.40', '1695785562', '__ci_last_regenerate|i:1695785562;'), ('amha5ro03ibcof7kmsfrg3eet9m46ma3', '103.253.45.40', '1695785562', '__ci_last_regenerate|i:1695785562;'), ('b81q1de2gqdd6oimisiu5bh9qt20gaug', '103.253.45.40', '1695785562', '__ci_last_regenerate|i:1695785562;'), ('r09l418rt4tpcf8sd3h0ncr0jpakahvt', '103.253.45.40', '1695785562', '__ci_last_regenerate|i:1695785562;'), ('hab2erfai4n3hcejk5jt4oo8f8t6emah', '103.253.45.40', '1695785562', '__ci_last_regenerate|i:1695785562;'), ('n3vrgnl23ntg3om8fmmhgedubedj2tr5', '103.253.45.40', '1695785562', '__ci_last_regenerate|i:1695785562;'), ('bsaojda61r05cmbk9hua04lfbpobaof2', '103.253.45.40', '1695785562', '__ci_last_regenerate|i:1695785562;'), ('6kgen87pliao5l450n6caegb648ujnti', '103.253.45.40', '1695785567', '__ci_last_regenerate|i:1695785567;'), ('gl2e663ipifvqdh6iipktjt5jfbm19j6', '103.253.45.40', '1695785567', '__ci_last_regenerate|i:1695785567;'), ('4m7vuhi4k3guachpvsisld6flufj44kf', '103.253.45.40', '1695785567', '__ci_last_regenerate|i:1695785567;'), ('f412gr84uv195j8rrhpro697vfk5bv8m', '103.253.45.40', '1695785568', '__ci_last_regenerate|i:1695785568;'), ('8hmn4j8u8kgf8ldh26rdo9di6mmal51d', '103.253.45.40', '1695785742', '__ci_last_regenerate|i:1695785742;'), ('03ehsgtg6nler98s78mdfkf63r39q2o2', '103.253.45.40', '1695785745', '__ci_last_regenerate|i:1695785745;'), ('3ibgf94m0547m0gtbesih2j8ak5rv7ch', '103.253.45.40', '1695785745', '__ci_last_regenerate|i:1695785745;'), ('c9ke18qimo4tu6jp71v48gentos6h67c', '103.253.45.40', '1695785745', '__ci_last_regenerate|i:1695785745;'), ('fij0uv8p5mvjh69alemcclat7qtgqn67', '103.253.45.40', '1695785745', '__ci_last_regenerate|i:1695785745;'), ('olbjtnarnearscvmgue8iefearvihus3', '103.253.45.40', '1695785745', '__ci_last_regenerate|i:1695785745;'), ('tl95fuv04v7jg2khe3o1ih33jr7k1u5e', '103.253.45.40', '1695785745', '__ci_last_regenerate|i:1695785745;'), ('0j31oq4lir1o7uef5u466voq0akj717n', '103.253.45.40', '1695785745', '__ci_last_regenerate|i:1695785745;'), ('ks8jb8mfeubal7bqkhc1vmgolptvc0vq', '103.253.45.40', '1695785746', '__ci_last_regenerate|i:1695785746;'), ('k1isqb5b2qunc5fs0f0s8mp1qidba4lm', '103.253.45.40', '1695785746', '__ci_last_regenerate|i:1695785746;'), ('b18ad2peop1sr5fo05deqbfi34t0c0oh', '103.253.45.40', '1695785746', '__ci_last_regenerate|i:1695785746;'), ('anm36tca16ffuoavr40istshqt978o3k', '103.253.45.40', '1695785746', '__ci_last_regenerate|i:1695785746;'), ('v7c6cs4dssa6tm0mg4agqn7tgpgj70m9', '103.253.45.40', '1695785747', '__ci_last_regenerate|i:1695785747;'), ('qbf6h5r26msjkugrl4mhvuornbbnf2kc', '103.253.45.40', '1695785809', '__ci_last_regenerate|i:1695785809;'), ('etdc7oasmkljvqj0l2imnl59dip7d2jt', '103.253.45.40', '1695785812', '__ci_last_regenerate|i:1695785812;'), ('le71mutv22vb07n7r1r08phj30kq0thu', '103.253.45.40', '1695785812', '__ci_last_regenerate|i:1695785812;'), ('b88i5qm8v5jbeffrmv8lvlvt4kkb8acp', '103.253.45.40', '1695785812', '__ci_last_regenerate|i:1695785812;'), ('v10br5rnmur855mn9fq6nkufb87vuirc', '103.253.45.40', '1695785812', '__ci_last_regenerate|i:1695785812;'), ('uv6g49649d4uhvpeu9071cn8atcggbrc', '103.253.45.40', '1695785812', '__ci_last_regenerate|i:1695785812;'), ('8c48t4jf9eq7bjsebrvp37rog9a9em7k', '103.253.45.40', '1695785812', '__ci_last_regenerate|i:1695785812;'), ('jpoa986skj30ckjkis9riq8nqteoqf8q', '103.253.45.40', '1695785813', '__ci_last_regenerate|i:1695785813;'), ('efjlg0g68gk2fr51tgdsvhgn1t463rek', '103.253.45.40', '1695785813', '__ci_last_regenerate|i:1695785813;'), ('s75fl5l45sh3n9e8083m1splbdqht3g9', '103.253.45.40', '1695785813', '__ci_last_regenerate|i:1695785813;'), ('eskf6kfq8gnqqq5ee4umscu9alqve63d', '103.253.45.40', '1695785813', '__ci_last_regenerate|i:1695785813;'), ('jca8946ak7a5l8q2j59h34cc81hu8aqh', '103.253.45.40', '1695785814', '__ci_last_regenerate|i:1695785814;'), ('ss2o8v13tim7sll8qpgil1u0cu0q0vi5', '103.253.45.40', '1695785921', '__ci_last_regenerate|i:1695785921;'), ('uo5e9278aufe465r31ucrufmlmtntljk', '103.253.45.40', '1695785924', '__ci_last_regenerate|i:1695785924;'), ('b5m68n1m72q1vvurs0srtpf0663vjj0m', '103.253.45.40', '1695785924', '__ci_last_regenerate|i:1695785924;'), ('mf8mbbu25ma2a3k8b6g9obck9drogoeg', '103.253.45.40', '1695785924', '__ci_last_regenerate|i:1695785924;'), ('pabtnpipl3i0dnp98hjme68m7jgrh9f6', '103.253.45.40', '1695785924', '__ci_last_regenerate|i:1695785924;'), ('dnk62r12kfr50tmro8sqk4m992knl0ru', '103.253.45.40', '1695785924', '__ci_last_regenerate|i:1695785924;'), ('doambe0qvpdr8rae8btbh4kojvr0ndcf', '103.253.45.40', '1695785924', '__ci_last_regenerate|i:1695785924;'), ('ak7ie2n8c3qt8t9vupq3oqi6un8ejg5a', '103.253.45.40', '1695785925', '__ci_last_regenerate|i:1695785925;'), ('cumpbkj6ee9r9053dbjutq622hp2iqk9', '103.253.45.40', '1695785925', '__ci_last_regenerate|i:1695785925;'), ('j95iam099etq0t3a6v73vrl70i7avvvo', '103.253.45.40', '1695785925', '__ci_last_regenerate|i:1695785925;'), ('e2um07soh8o9558hhrdjq8h75pfttvme', '103.253.45.40', '1695785925', '__ci_last_regenerate|i:1695785925;'), ('lgobv9a379h6nkd5dvhkmrf4s0bir9sp', '103.253.45.40', '1695785925', '__ci_last_regenerate|i:1695785925;'), ('jn7bf5i4hcqfbnb7qubs0n946gpgrm8q', '103.253.45.40', '1695785926', '__ci_last_regenerate|i:1695785926;'), ('r8u4b38fgihcomq1l49htd6g5hp7td50', '103.253.45.40', '1695786068', '__ci_last_regenerate|i:1695786068;'), ('vv3psmq86l75g4rttde3gk16afese0dn', '103.253.45.40', '1695786071', '__ci_last_regenerate|i:1695786071;'), ('p7bajcqcdhnja5htnpfgqm9eud4c6u0e', '103.253.45.40', '1695786071', '__ci_last_regenerate|i:1695786071;'), ('j43sgv1eaqtioprmq5940mtbotm5qf4h', '103.253.45.40', '1695786072', '__ci_last_regenerate|i:1695786072;'), ('fk2gndp5ko4tku25ijei7mh9vfreldpd', '103.253.45.40', '1695786072', '__ci_last_regenerate|i:1695786071;'), ('sc8ai8fands2joadp3ijvbj7cgoc10l7', '103.253.45.40', '1695786072', '__ci_last_regenerate|i:1695786072;'), ('b8pkhcd768h2t69qbh9oh00cihhuh8d8', '103.253.45.40', '1695786072', '__ci_last_regenerate|i:1695786072;'), ('jllnamehrjfasemdstqc315vik2g45sk', '103.253.45.40', '1695786072', '__ci_last_regenerate|i:1695786072;'), ('r1q8j1a589sjufbr9h0envb0a16te1sj', '103.253.45.40', '1695786073', '__ci_last_regenerate|i:1695786073;'), ('ap50t4bardu31bn40dianecgv2tb5tlv', '103.253.45.40', '1695786073', '__ci_last_regenerate|i:1695786073;'), ('su5rejblsku4rbcf8s6rocsb0ubl7u7h', '103.253.45.40', '1695786073', '__ci_last_regenerate|i:1695786073;'), ('aff9ktr8iqdmrd4qlk3kf5g8ctn4nemc', '103.253.45.40', '1695786074', '__ci_last_regenerate|i:1695786074;'), ('9d1h7ib2g2e95cpdem7tpc5eb29fjqge', '103.253.45.40', '1695786130', '__ci_last_regenerate|i:1695786130;'), ('d4a0k1pe7r5i3tujrsuquttu1crfpjcu', '103.253.45.40', '1695786133', '__ci_last_regenerate|i:1695786133;'), ('q1f0n7fe0acdsjhjbpdrkertp9a9avlo', '103.253.45.40', '1695786133', '__ci_last_regenerate|i:1695786133;'), ('5421hubn30oq33e1hr5ab0lqor38ll1m', '103.253.45.40', '1695786133', '__ci_last_regenerate|i:1695786133;'), ('erbfq9cibtem7hkdfvec1rea9orm4188', '103.253.45.40', '1695786133', '__ci_last_regenerate|i:1695786133;'), ('mqmr0gfs6dj6rc1f62104qc48k2sqsm3', '103.253.45.40', '1695786133', '__ci_last_regenerate|i:1695786133;'), ('1pfus6qsk3ajukfglr8916nv26l4jtmh', '103.253.45.40', '1695786133', '__ci_last_regenerate|i:1695786133;'), ('khhijp8ejp4qvp14doc65962is97l30c', '103.253.45.40', '1695786133', '__ci_last_regenerate|i:1695786133;'), ('jnsd4in12cprg8mpqm52dq6jeva3bfrm', '103.253.45.40', '1695786134', '__ci_last_regenerate|i:1695786134;'), ('q0kdvqsgmdohgsqv62pptof5lipc7tn7', '103.253.45.40', '1695786134', '__ci_last_regenerate|i:1695786134;'), ('aimq2fdts9g66nkstq8imufq89bidnpt', '103.253.45.40', '1695786134', '__ci_last_regenerate|i:1695786134;'), ('qdi1medt10qn8k4jnk1fpb1rabqu7cks', '103.253.45.40', '1695786135', '__ci_last_regenerate|i:1695786135;'), ('ffid9162so6u3b3gbkc0ac2sordduokp', '103.253.45.40', '1695786173', '__ci_last_regenerate|i:1695786173;'), ('tv773sot6m5rgaslecpq9svn8f7gadpf', '103.253.45.40', '1695786177', '__ci_last_regenerate|i:1695786177;'), ('r63tfvvl5l6aque61l6277ed1eraacde', '103.253.45.40', '1695786177', '__ci_last_regenerate|i:1695786177;'), ('040a4bjcr039v8r26cgfqj7kbgh09c5j', '103.253.45.40', '1695786177', '__ci_last_regenerate|i:1695786177;'), ('9lttv2e1vsto4i7r3it94pe1fhrqqbau', '103.253.45.40', '1695786177', '__ci_last_regenerate|i:1695786177;'), ('k2lpdb5tcqp16tkifskjqkg4gv6ggj1a', '103.253.45.40', '1695786177', '__ci_last_regenerate|i:1695786177;'), ('elbhbl04pj9ua2opmbtadkqrfrvl0u0t', '103.253.45.40', '1695786177', '__ci_last_regenerate|i:1695786177;'), ('3cj8lt8e5b7oo2vb0lv63ikh3pu3fqij', '103.253.45.40', '1695786178', '__ci_last_regenerate|i:1695786178;'), ('cknn69bsvcfb7u84801kbn5236j14f16', '103.253.45.40', '1695786183', '__ci_last_regenerate|i:1695786183;'), ('iu8p44bb0ffrv8unpkfeeafgqu5dvs82', '103.253.45.40', '1695786183', '__ci_last_regenerate|i:1695786183;'), ('6ppf2koj8cpb8lg84s2h0809lcrfg2bt', '103.253.45.40', '1695786183', '__ci_last_regenerate|i:1695786183;'), ('oumtidsnp74vj69vprdnre8sl26j7lva', '103.253.45.40', '1695786184', '__ci_last_regenerate|i:1695786184;'), ('52pk28g9ldqf803o2nimckga2mhksoj7', '103.253.45.40', '1695786219', '__ci_last_regenerate|i:1695786219;'), ('v0ib99v65lgmn0bkibuml6gev5kvlpnh', '103.253.45.40', '1695786222', '__ci_last_regenerate|i:1695786222;'), ('t9mmpthbh2oi0cb8kpooq9j24e3frqbm', '103.253.45.40', '1695786222', '__ci_last_regenerate|i:1695786222;'), ('4v1a09vfiofd0kse90cb4ak27vjs0s2j', '103.253.45.40', '1695786222', '__ci_last_regenerate|i:1695786222;'), ('ps4hcdpqp91pf03tmt62qgsvp9m1u7fj', '103.253.45.40', '1695786222', '__ci_last_regenerate|i:1695786222;'), ('b8b2891416kuvnd58sohijncsldq424o', '103.253.45.40', '1695786223', '__ci_last_regenerate|i:1695786222;'), ('m0fhtj2a3q766icpll1ahltp5cnb0cg8', '103.253.45.40', '1695786223', '__ci_last_regenerate|i:1695786223;'), ('8nh95ggsfhpc3l0dbs4mrhnduf8a2qev', '103.253.45.40', '1695786223', '__ci_last_regenerate|i:1695786223;'), ('ahuv5bednq9mekjgrnp6bnpfrnu3u41u', '103.253.45.40', '1695786226', '__ci_last_regenerate|i:1695786226;'), ('pob549oe50v8hd8ome0jc1alokjp9eiv', '103.253.45.40', '1695786226', '__ci_last_regenerate|i:1695786226;'), ('mvmpim8fo2uvcfcacj7q32qg605se72e', '103.253.45.40', '1695786226', '__ci_last_regenerate|i:1695786226;'), ('rprip8k6ks042ghv2v4uqf2op1j6ch5c', '103.253.45.40', '1695786227', '__ci_last_regenerate|i:1695786227;'), ('u621bs3de6mr3t90vgo966u7tonosf7f', '103.253.45.40', '1695786257', '__ci_last_regenerate|i:1695786257;'), ('i5mfnnvoe8aiup5o69ev546p0k246bek', '103.253.45.40', '1695786261', '__ci_last_regenerate|i:1695786261;'), ('1rpmm74beqh8puook9k8tgq1j2d6phb2', '103.253.45.40', '1695786261', '__ci_last_regenerate|i:1695786261;'), ('317m17uhh3jpcp0nkaaj5uffn9hqi2vf', '103.253.45.40', '1695786261', '__ci_last_regenerate|i:1695786261;'), ('kjij7atp8l1jlm3ke1rr0av70jog259n', '103.253.45.40', '1695786261', '__ci_last_regenerate|i:1695786261;'), ('jkmu87h5q1n1duomoibi90706sc6bf1q', '103.253.45.40', '1695786261', '__ci_last_regenerate|i:1695786261;'), ('p3t5ljn00mqsvlfe6fs74l3v4pt2b3ku', '103.253.45.40', '1695786261', '__ci_last_regenerate|i:1695786261;'), ('d6b9qbekegs8f8ag87j6r429463el36b', '103.253.45.40', '1695786262', '__ci_last_regenerate|i:1695786262;'), ('f5i9p6egjmp56pphlk10027aal27hvsi', '103.253.45.40', '1695786263', '__ci_last_regenerate|i:1695786263;'), ('eudh8l05cs1u4eiot777gdsiib8vipgc', '103.253.45.40', '1695786263', '__ci_last_regenerate|i:1695786263;'), ('h66jt0vt6ki3lpfeak6oka53qq37pbrc', '103.253.45.40', '1695786263', '__ci_last_regenerate|i:1695786263;'), ('5soma639oqr5pl9rr5ne7neo474tlr8a', '103.253.45.40', '1695786264', '__ci_last_regenerate|i:1695786264;'), ('r7k45i1pn564vair04o3sddtikhdil00', '103.253.45.40', '1695786266', '__ci_last_regenerate|i:1695786266;'), ('c3ci1gfmh84e33j2vppsj8t36m95jeg3', '103.253.45.40', '1695786266', '__ci_last_regenerate|i:1695786266;'), ('4o1v3gvd4j1fgjq7ibcc0i12h9du0kpk', '103.253.45.40', '1695786266', '__ci_last_regenerate|i:1695786266;'), ('mqejipp8i6qshvv6cj2salbguvc060sp', '103.253.45.40', '1695786266', '__ci_last_regenerate|i:1695786266;'), ('il0r5i8fh1iidugs2n9avf5f7k6a320q', '103.253.45.40', '1695786266', '__ci_last_regenerate|i:1695786266;'), ('lgadeis7or8e1oab09huo31oksl468jg', '103.253.45.40', '1695786266', '__ci_last_regenerate|i:1695786266;'), ('ude02e9elt1bi0ntpedhmq6o2qa9e8md', '103.253.45.40', '1695786267', '__ci_last_regenerate|i:1695786267;'), ('iu3gajjo6a87cer3p1f1cutfv36k1d9n', '103.253.45.40', '1695786286', '__ci_last_regenerate|i:1695786286;'), ('h5vj046r5tq34lj6ts5ssm5tgsa48ttt', '37.111.223.76', '1695787840', '__ci_last_regenerate|i:1695787840;'), ('748j26r628id61dpocqdc6s3h574kibb', '37.111.223.76', '1695787841', '__ci_last_regenerate|i:1695787841;'), ('kmbn2nat9qsi8n9969ubdvhlet34sv7c', '37.111.223.76', '1695787841', '__ci_last_regenerate|i:1695787841;'), ('irhkg60e5ul6l296b5m2cfoi3h6qf9fk', '37.111.223.76', '1695787841', '__ci_last_regenerate|i:1695787841;'), ('9roaiiqk01boskrhsbgq95draqn1fepm', '37.111.223.76', '1695787841', '__ci_last_regenerate|i:1695787841;'), ('2dq07aj09n8dror1mgvqd578vjin99lh', '37.111.223.76', '1695787841', '__ci_last_regenerate|i:1695787841;'), ('6e65ffqdk6olsbkjv5aq7tmhu86in7om', '37.111.223.76', '1695787841', '__ci_last_regenerate|i:1695787841;'), ('kctopbvoarb67k19hef7dli9k3vnr4sb', '37.111.223.76', '1695787841', '__ci_last_regenerate|i:1695787841;'), ('62ioqrqbaur56gsd9g3bs2b6mkelpeet', '37.111.223.76', '1695787847', '__ci_last_regenerate|i:1695787847;'), ('300hr6orosjkf0cdoajtkg5s57gs07uc', '37.111.223.76', '1695787847', '__ci_last_regenerate|i:1695787847;'), ('ivso24t5jp7ehf9f4aoemeftbrhmnsb6', '37.111.223.76', '1695787847', '__ci_last_regenerate|i:1695787847;'), ('bsd67eaqnsv3o8q3rmpadict9be5v9qg', '37.111.223.76', '1695787848', '__ci_last_regenerate|i:1695787848;'), ('ob61o91f9iln4gkfg9l784q6390kald8', '37.111.223.76', '1695787851', '__ci_last_regenerate|i:1695787851;'), ('qaj3q5874rl9c3ln49vokfn64kelv94b', '37.111.223.76', '1695787851', '__ci_last_regenerate|i:1695787851;'), ('1jdf4b2pid16dgagalu83uq9l8jsts81', '37.111.223.76', '1695787851', '__ci_last_regenerate|i:1695787851;'), ('ocrgtmj169s06qvsdtgrnegbemk06o90', '37.111.223.76', '1695787851', '__ci_last_regenerate|i:1695787851;'), ('0r53kngnjrrvo7qoc01eg2j7cb7fq8lg', '37.111.223.76', '1695787851', '__ci_last_regenerate|i:1695787851;'), ('svu6pha3hfmqt3o0lmq1fpi0bgkj6lor', '37.111.223.76', '1695787851', '__ci_last_regenerate|i:1695787851;'), ('5er1sbplbv0cs7qf86s6b20gjn69nb6a', '37.111.223.76', '1695787851', '__ci_last_regenerate|i:1695787851;'), ('qsbq6276o576ehn0dpafrlt6nkqnk5c0', '37.111.223.76', '1695787861', '__ci_last_regenerate|i:1695787861;'), ('gdlobhh2a6hmrenohtia3ed29b6a5ul1', '37.111.223.76', '1695787867', '__ci_last_regenerate|i:1695787867;'), ('sfctkpqgekirjk0atbmeb4244l1tgmlg', '37.111.223.76', '1695787876', '__ci_last_regenerate|i:1695787876;'), ('7eqlpep49moqlocqm4op7r8qriskpnu0', '37.111.223.76', '1695787881', '__ci_last_regenerate|i:1695787881;'), ('htpad3bpvjfd83l716jg347or8ileb72', '37.111.223.76', '1695787881', '__ci_last_regenerate|i:1695787881;'), ('u8s18la9e8d1lfma653a5qo69fi5hm87', '37.111.223.76', '1695787881', '__ci_last_regenerate|i:1695787881;'), ('b9bsdane3hfi8lcm5afquqc0pa1huutj', '37.111.223.76', '1695787881', '__ci_last_regenerate|i:1695787881;'), ('7ar0vrrmr1ifm32uuiei84fvojtltkun', '37.111.223.76', '1695787881', '__ci_last_regenerate|i:1695787881;'), ('49mpmrtc59uqh7os24tn5c90sffmognm', '37.111.223.76', '1695787882', '__ci_last_regenerate|i:1695787882;'), ('hm7qhajv3cnbpalbp5gn0ute67jk43hi', '37.111.223.76', '1695787899', '__ci_last_regenerate|i:1695787899;'), ('hfqj5r87ta7iu1aqap32rcregjjaho67', '103.67.157.224', '1695799120', '__ci_last_regenerate|i:1695799120;'), ('os5bdva6fedrnr7p2glk3tp73e4aeisv', '103.67.157.239', '1695799123', '__ci_last_regenerate|i:1695799123;'), ('9r69qe4o0ilsrgl3nia1vusrle0q54a6', '103.67.157.239', '1695799123', '__ci_last_regenerate|i:1695799123;'), ('k7f6tao77l4l011k26jgl0266tpboog7', '103.67.157.239', '1695799123', '__ci_last_regenerate|i:1695799123;'), ('quo5blfrqaav4reu0cfp0na095s4sbcp', '103.67.157.239', '1695799123', '__ci_last_regenerate|i:1695799123;'), ('42ukjdbrig78arvp49p3cginlff7krcp', '103.67.157.239', '1695799123', '__ci_last_regenerate|i:1695799123;'), ('pp7815vasmaq7eqarramp2rsn2db04fr', '103.67.157.239', '1695799123', '__ci_last_regenerate|i:1695799123;'), ('4i4uc1ua2jmjkf11u46h1hg2l009gd1a', '103.67.157.239', '1695799124', '__ci_last_regenerate|i:1695799124;'), ('9kpigu6n8egeccqlf3qd9qu5bavsjnoa', '103.67.157.239', '1695799156', '__ci_last_regenerate|i:1695799156;'), ('6esak7ul0jhkp3cbgpahkareh6jivue8', '103.67.157.239', '1695799161', '__ci_last_regenerate|i:1695799161;'), ('p8uqqvs71vbp2aehahhlvdi6t6rbm187', '103.67.157.239', '1695799164', '__ci_last_regenerate|i:1695799164;'), ('gtkmrhjheqvcirbh606qmn7kebqfrmlk', '103.67.157.239', '1695799744', '__ci_last_regenerate|i:1695799744;'), ('uliepij7fkk320uphii16o0lq4e3kmkd', '103.67.157.239', '1695799748', '__ci_last_regenerate|i:1695799748;'), ('tqcce9smhi6pfqaiislcj6cpa4hhlfu2', '103.67.157.239', '1695799748', '__ci_last_regenerate|i:1695799748;'), ('2d3kchfjepeg5a59m1l8r795dm8epfb8', '103.67.157.239', '1695799748', '__ci_last_regenerate|i:1695799748;'), ('b32ado7ralqp535f8mf4g0a099s299g7', '103.67.157.239', '1695799748', '__ci_last_regenerate|i:1695799748;'), ('bhd07u0like5qrkj5ebfggpg97bm09ca', '103.67.157.239', '1695799748', '__ci_last_regenerate|i:1695799748;'), ('lduruht9159t4h37pbad9a4g648924pf', '103.67.157.239', '1695799748', '__ci_last_regenerate|i:1695799748;'), ('28d2d5tsg4kfhpic1sco7vho7oe2t5jq', '103.67.157.239', '1695799748', '__ci_last_regenerate|i:1695799748;'), ('1oqjj4nmf5nufb51b577760abet84grh', '103.67.157.239', '1695799828', '__ci_last_regenerate|i:1695799828;'), ('ckpnkvkedi0svmjeqd51vs50pffqheri', '103.67.157.239', '1695799829', '__ci_last_regenerate|i:1695799829;'), ('s1kkialfviv54es4cpiv42u2l1j6qltn', '103.67.157.239', '1695799829', '__ci_last_regenerate|i:1695799829;'), ('e4j1gshmagpv88kqn3ghmggpdrr07bgd', '103.67.157.239', '1695799829', '__ci_last_regenerate|i:1695799829;'), ('fh2ag4t1v3363tpa2aeighstqneq92j8', '103.67.157.239', '1695799829', '__ci_last_regenerate|i:1695799829;'), ('ijl9bm92bf9vad37372j9na8inopgo4u', '103.67.157.239', '1695799829', '__ci_last_regenerate|i:1695799829;'), ('gokactde49u2fcjmuucfqd25omaok629', '103.67.157.239', '1695799829', '__ci_last_regenerate|i:1695799829;'), ('p6160cgh4s5i9teujapgd5b56elra2to', '103.67.157.239', '1695799829', '__ci_last_regenerate|i:1695799829;'), ('fudmgf5177q1u63a46ltdpi32g88p9dg', '103.67.157.231', '1695799830', '__ci_last_regenerate|i:1695799830;'), ('p26mpgquuactrq2jmojfvme4jf4p74ld', '103.67.157.231', '1695799830', '__ci_last_regenerate|i:1695799830;'), ('8cq1bpdvl5bj4uu4p25j9tf9r117ov9o', '103.67.157.231', '1695799830', '__ci_last_regenerate|i:1695799830;'), ('n55pt5c40v5th2eje96viglc5if3k5fa', '103.67.157.231', '1695799831', '__ci_last_regenerate|i:1695799831;'), ('gi0i2htf0p9q62gev2777jnfapj3j0dg', '103.67.157.232', '1695799843', '__ci_last_regenerate|i:1695799843;'), ('3pcu9cpc3e025ae7ui2uqrupt16c4jvk', '103.67.157.232', '1695799853', '__ci_last_regenerate|i:1695799853;'), ('jgn7tb6ct9loh5v3j1ih8s375lg5sgcn', '103.67.157.232', '1695799853', '__ci_last_regenerate|i:1695799853;'), ('gnkoqab340c019vcg7966u1tk7cl5dpv', '103.67.157.232', '1695799853', '__ci_last_regenerate|i:1695799853;'), ('qhtlcita1djkefv8fscl50i9ib5stefi', '103.67.157.232', '1695799854', '__ci_last_regenerate|i:1695799854;'), ('ol7n0mk1jlv5j2l2pfs8cb499m794tm3', '103.67.157.232', '1695799854', '__ci_last_regenerate|i:1695799854;'), ('l972k2o1v2d3j537odfr6e6pn9r51hid', '103.67.157.231', '1695799870', '__ci_last_regenerate|i:1695799870;'), ('fjtre0h5iigvllbq8taffl1gd68fve96', '103.67.157.231', '1695799874', '__ci_last_regenerate|i:1695799874;'), ('v42ec07ir33uhb1dq47accl8i30uko2q', '103.67.157.231', '1695799874', '__ci_last_regenerate|i:1695799874;'), ('ed8gqnn9vre399mnr5ha8fl20iq7ps6j', '103.67.157.231', '1695799874', '__ci_last_regenerate|i:1695799874;'), ('tm142ha62d4gbpq4n16ch3b28htkifn9', '103.67.157.231', '1695799874', '__ci_last_regenerate|i:1695799874;'), ('876hla7kdlptpo8v02ed0b66mc0ttrl5', '103.67.157.231', '1695799874', '__ci_last_regenerate|i:1695799874;'), ('kdjt9hl59b7vqsr2ire1kif84ot3ga3n', '103.67.157.231', '1695799874', '__ci_last_regenerate|i:1695799874;'), ('difvo327m3aqj3t48ig3q4omhce884rh', '103.67.157.231', '1695799874', '__ci_last_regenerate|i:1695799874;'), ('a7ee1t0bqri5reu98ekor4lqgni5g77a', '103.67.157.231', '1695799876', '__ci_last_regenerate|i:1695799876;'), ('35grj20paclajce0s4bfuss3rnallhvt', '103.67.157.231', '1695799876', '__ci_last_regenerate|i:1695799876;'), ('8nsmabj3u8hs00vlqtmshlp0cu4jhgi6', '103.67.157.231', '1695799876', '__ci_last_regenerate|i:1695799876;'), ('cl8gmgr3kcmbof1b11896sf3cn5m8cia', '103.67.157.231', '1695799877', '__ci_last_regenerate|i:1695799877;'), ('3bb6jtmdlsv2b97p1scs8e1gmjbov1ai', '103.67.157.231', '1695799889', '__ci_last_regenerate|i:1695799889;'), ('gmnm3q9q7ie4rjefbl5g3dagsjvvijkj', '103.67.157.231', '1695799892', '__ci_last_regenerate|i:1695799892;'), ('uuoeecjdvij0l30sac9t0tnv7ee1t6ds', '103.67.157.231', '1695799893', '__ci_last_regenerate|i:1695799893;'), ('an5lhqia3c7g4q3s0fv6tpaaq8f2t2r4', '103.67.157.231', '1695799893', '__ci_last_regenerate|i:1695799893;'), ('6u2ml6sc1hd9dip5ce09sp95hc9utl4f', '103.67.157.231', '1695799893', '__ci_last_regenerate|i:1695799893;'), ('123io2133vh7e30s114ceve4pb0hj0ed', '103.67.157.231', '1695799894', '__ci_last_regenerate|i:1695799894;'), ('snl575mqctenj1mpqlvih7pa6o7c8g06', '103.67.157.231', '1695799952', '__ci_last_regenerate|i:1695799952;'), ('m8s4jh9bqm31mv2235gf93j4ouif6vb6', '103.67.157.231', '1695799955', '__ci_last_regenerate|i:1695799955;'), ('qa8ranr7dspi1mt73rps4qr5610hbvl8', '103.67.157.231', '1695799955', '__ci_last_regenerate|i:1695799955;'), ('l47vmgr86or2vdatu4kbktsjr081ph4r', '103.67.157.231', '1695799955', '__ci_last_regenerate|i:1695799955;'), ('771pdkr0g08cq43jmgc9qmag01rmejdk', '103.67.157.231', '1695799955', '__ci_last_regenerate|i:1695799955;'), ('aotklo2m24j1cg9d0bnbntsrfp0uik93', '103.67.157.231', '1695799955', '__ci_last_regenerate|i:1695799955;'), ('s4aqd3djh1gk04me46hg1lgn5s328l37', '103.67.157.231', '1695799955', '__ci_last_regenerate|i:1695799955;'), ('1fgo84uot0jmhvfv5h896lb64rdfvv0j', '103.67.157.231', '1695799956', '__ci_last_regenerate|i:1695799956;'), ('obdk7fb9hct784bog25vtjn04mb0pg4v', '103.67.157.231', '1695799958', '__ci_last_regenerate|i:1695799958;'), ('op3omk2fn8jnuu0daaco7eskmbo6jnb4', '103.67.157.231', '1695799958', '__ci_last_regenerate|i:1695799958;'), ('ccoghdjt72qbp035o4c6ltptd1dag91f', '103.67.157.231', '1695799958', '__ci_last_regenerate|i:1695799958;'), ('lci2k50kmctkb069pnjjh1mvd7cf256l', '103.67.157.239', '1695799959', '__ci_last_regenerate|i:1695799959;'), ('6atb67eik1l7tocphvramsjn0ov0lhd0', '103.67.157.239', '1695799965', '__ci_last_regenerate|i:1695799965;'), ('rfbo11p713l9uuasembep1vb6nt8fn0g', '103.67.157.239', '1695799967', '__ci_last_regenerate|i:1695799967;'), ('oiuhprsi4mpql4tbft4gebd9jkm639uv', '103.67.157.239', '1695799967', '__ci_last_regenerate|i:1695799967;'), ('kv2ctshlsq1l9s8jgq0h16bradp9aqai', '103.67.157.239', '1695799967', '__ci_last_regenerate|i:1695799967;'), ('3qeeeqs2pod4mgsknve4uf96vm3ij556', '103.67.157.239', '1695799967', '__ci_last_regenerate|i:1695799967;'), ('o9oc63uabcq0qulopdbdbkd6jjka8dff', '103.67.157.239', '1695799967', '__ci_last_regenerate|i:1695799967;'), ('b3rkacr33hif0ohelhbkrvnfm94scpug', '103.67.157.239', '1695799967', '__ci_last_regenerate|i:1695799967;'), ('7rrdtmuainuc5n4r1825uk7d7q41s5h0', '103.67.157.239', '1695799968', '__ci_last_regenerate|i:1695799968;'), ('g5cqsnl32pruv4o2g9b4lv9hmau16vkc', '103.67.157.233', '1695800359', '__ci_last_regenerate|i:1695800359;'), ('kp1n5s96hrjeg8r1p1spj96q1e8jegfj', '103.67.157.239', '1695800672', '__ci_last_regenerate|i:1695800672;'), ('dv6tvte5cest7tscue09k71oq6anb93u', '103.67.157.239', '1695800675', '__ci_last_regenerate|i:1695800675;'), ('oo2s3b46ekhvm2phnr3q7ejifgs924ak', '103.67.157.239', '1695800675', '__ci_last_regenerate|i:1695800675;'), ('sg3d03it1av4ej0ev86ddfjo1cki5mrc', '103.67.157.239', '1695800675', '__ci_last_regenerate|i:1695800675;'), ('rnvvrjcoff32jahbcsa7pnbqgjpfp4at', '103.67.157.239', '1695800675', '__ci_last_regenerate|i:1695800675;'), ('b0cjm3jgrf5tdntcrg7vmk53sm9g81ba', '103.67.157.239', '1695800675', '__ci_last_regenerate|i:1695800675;'), ('fte56j0dc4lja4jbhn7ogq0uq6bonb6v', '103.67.157.239', '1695800675', '__ci_last_regenerate|i:1695800675;'), ('6j80j38o6m5qbtcbdrio2qh0sgikb2dn', '103.67.157.239', '1695800676', '__ci_last_regenerate|i:1695800676;'), ('a07era0lo6fa8vee9e87gl2ihqench1q', '103.67.157.231', '1695800683', '__ci_last_regenerate|i:1695800683;'), ('7fglnjbqgkr8lkkdlqsbr2h0eb85gsid', '103.67.157.231', '1695800684', '__ci_last_regenerate|i:1695800684;'), ('6tphq8gmidhip073fnq7l1a8lguf67go', '103.67.157.231', '1695800684', '__ci_last_regenerate|i:1695800684;'), ('5nsbbncg4hesv1sel66mifqtrkot2736', '103.67.157.231', '1695800684', '__ci_last_regenerate|i:1695800684;'), ('r2m7dhgjqr0rsug568jev99abuqvn8pb', '103.67.157.231', '1695800684', '__ci_last_regenerate|i:1695800684;'), ('o7ogs1mkd148edu887q8896hcncjm6jc', '103.67.157.231', '1695800684', '__ci_last_regenerate|i:1695800684;'), ('4l0706q2atn9blgehcjb6pbrkc74clev', '103.67.157.231', '1695800684', '__ci_last_regenerate|i:1695800684;'), ('3052nupiik1g1rq3an38vtmft5l1k717', '103.67.157.231', '1695800685', '__ci_last_regenerate|i:1695800685;'), ('83k41mup6sa04ijfeprbhatod9dlcvgv', '103.67.157.231', '1695800685', '__ci_last_regenerate|i:1695800685;'), ('fc28oq2e429q14152ll0mqthbg0b4ke5', '103.67.157.231', '1695800685', '__ci_last_regenerate|i:1695800685;'), ('7b58mbafoso8pl1lcvabkkj6hp27mqcr', '103.67.157.231', '1695800685', '__ci_last_regenerate|i:1695800685;'), ('18m4d9btg705vohgolj26mvr8flk8120', '103.67.157.231', '1695800685', '__ci_last_regenerate|i:1695800685;'), ('1ijobt2jolmunpt18hs5g8lghj4j6vfd', '103.67.157.231', '1695800686', '__ci_last_regenerate|i:1695800686;'), ('ebsfdacsp89qaan28kc3lapv4a2lo46q', '103.67.157.231', '1695800688', '__ci_last_regenerate|i:1695800688;'), ('g797qpiv3tbf4j5vamdgof2e0mimu2gb', '103.67.157.231', '1695800688', '__ci_last_regenerate|i:1695800688;'), ('rm528j4i9l792tulrq4cumtrv528gncs', '103.67.157.231', '1695800688', '__ci_last_regenerate|i:1695800688;'), ('v4njki193n0uihao49kin55soarcsvda', '103.67.157.231', '1695800689', '__ci_last_regenerate|i:1695800689;'), ('7bbubsak6il2o5cb4i123599hvv3qqa2', '103.67.157.231', '1695800689', '__ci_last_regenerate|i:1695800689;'), ('c6tkrb5h4ckd84hhf9dksn135qkpm55r', '103.67.157.231', '1695800689', '__ci_last_regenerate|i:1695800689;'), ('gqo51be7hdv6v468n8s891f6v23lj7mp', '103.67.157.231', '1695800689', '__ci_last_regenerate|i:1695800689;'), ('4g52i9172cit469u4q2m8h6cks8k9bnr', '103.67.157.231', '1695800699', '__ci_last_regenerate|i:1695800699;'), ('icnpioh8c2fdihlml2njam2f7rqt86mp', '103.67.157.231', '1695800728', '__ci_last_regenerate|i:1695800728;'), ('vl8m7rfuse12rv22a7ojaumh81glndbg', '103.67.157.231', '1695800732', '__ci_last_regenerate|i:1695800732;'), ('usccpt7gcv8q75ab7jf3dh7afqq1j38l', '103.67.157.231', '1695800732', '__ci_last_regenerate|i:1695800732;'), ('ur939gepc5q18iih26gb2tqeur41okbl', '103.67.157.231', '1695800732', '__ci_last_regenerate|i:1695800732;'), ('e6k3u3c8ooon7mjf36rernegrflk4vus', '103.67.157.231', '1695800732', '__ci_last_regenerate|i:1695800732;'), ('kq37p5edsujh6gnpap3o1tr6u5kd0q2r', '103.67.157.231', '1695800732', '__ci_last_regenerate|i:1695800732;'), ('h355vqleq34njo8ftmp2i4vmps81o2am', '103.67.157.231', '1695800732', '__ci_last_regenerate|i:1695800732;'), ('j8n31c4jgei7ffd0lb32ba58t1qtlmdo', '103.67.157.231', '1695800732', '__ci_last_regenerate|i:1695800732;'), ('kje1crm4jppang2ecgo6g83cuc6lgnue', '103.67.157.231', '1695800745', '__ci_last_regenerate|i:1695800745;'), ('mdtht20sla8fqbf51pkkvqud9ugp2fqv', '103.67.157.231', '1695800746', '__ci_last_regenerate|i:1695800746;'), ('4ccsfs59b41u3dmb44coun2nl7e95lfr', '103.67.157.231', '1695800746', '__ci_last_regenerate|i:1695800746;'), ('tci2j2kc97jqbr72r1s6k7fe6ip2elim', '103.67.157.231', '1695800746', '__ci_last_regenerate|i:1695800746;'), ('ajbtsn46r7d7n2tua4el3c17bct2dg6j', '103.67.157.231', '1695800746', '__ci_last_regenerate|i:1695800746;'), ('gesgk8gkucj2sse2giosqo73bg2o3r8e', '103.67.157.231', '1695800746', '__ci_last_regenerate|i:1695800746;'), ('p71mt38e51e3e3lvorasft6465e90fk6', '103.67.157.231', '1695800746', '__ci_last_regenerate|i:1695800746;'), ('7k12i34orpgvloq5epntu7h7j3cqq811', '103.67.157.231', '1695800746', '__ci_last_regenerate|i:1695800746;'), ('emoccrr6de18reironfi1dmvjq6n6rn9', '103.67.157.231', '1695800747', '__ci_last_regenerate|i:1695800747;'), ('c6j1fpoqqeenoagunkr7el7qvufi5kc9', '103.67.157.231', '1695800747', '__ci_last_regenerate|i:1695800747;'), ('hjei03b6puh4b80f1g65g05e2p8pq6v1', '103.67.157.231', '1695800747', '__ci_last_regenerate|i:1695800747;'), ('prcpgbjv58ji9s16q99duu51vampnavv', '103.67.157.231', '1695800747', '__ci_last_regenerate|i:1695800747;'), ('oqmr84aeitruok9jvjfp8bou6se3brom', '103.67.157.231', '1695800750', '__ci_last_regenerate|i:1695800750;'), ('s2v01nsja27kbjpe22uolpamfbdhr4dp', '103.67.157.231', '1695800750', '__ci_last_regenerate|i:1695800750;'), ('co4p7hpa77lg8e7m46hfeodg5rtgnvk9', '103.67.157.231', '1695800750', '__ci_last_regenerate|i:1695800750;'), ('dkcvkpbk9g1jdl7t4d7fe7a4suh64mpa', '103.67.157.231', '1695800750', '__ci_last_regenerate|i:1695800750;'), ('t2qbpcdfj693rb8euho9qqmegd5dvgn7', '103.67.157.231', '1695800750', '__ci_last_regenerate|i:1695800750;'), ('34jtufjesih80nvespvsm2esn7j9jusl', '103.67.157.231', '1695800750', '__ci_last_regenerate|i:1695800750;'), ('if4c46j208a1q3i32mq0fb03ijf27glj', '103.67.157.231', '1695800750', '__ci_last_regenerate|i:1695800750;'), ('rdkpmsjojq1uoccogdlbnag3vbf1ajq7', '103.67.157.231', '1695800758', '__ci_last_regenerate|i:1695800758;'), ('ttslvunh7ijtlssat0tvkder6a3v64l6', '103.67.157.231', '1695800774', '__ci_last_regenerate|i:1695800774;'), ('hc66ihfbn191ktb1sb2dehnemo67a738', '103.67.157.231', '1695800778', '__ci_last_regenerate|i:1695800778;'), ('v4s3k855ps4nh4cl08jeg1lrsl8nuv56', '103.67.157.231', '1695800778', '__ci_last_regenerate|i:1695800778;'), ('p2mkf3o5a52sqc1m149v6hgc8i69bkd5', '103.67.157.231', '1695800778', '__ci_last_regenerate|i:1695800778;'), ('n6jalv7k6k2gshur92ntcqjnap3jgg6m', '103.67.157.231', '1695800778', '__ci_last_regenerate|i:1695800778;'), ('l9votu4a028vpk6i14tt7vb4q4t4rv4l', '103.67.157.231', '1695800778', '__ci_last_regenerate|i:1695800778;'), ('v274coc4bj90h2f70dmfq19sk8t07psh', '103.67.157.231', '1695800778', '__ci_last_regenerate|i:1695800778;'), ('v67shhqhfn5p4ue6h9iqhclr6gvupvk9', '103.67.157.231', '1695800778', '__ci_last_regenerate|i:1695800778;'), ('g536lgp4pdonbb9g88tgr1ncosat6jq4', '103.67.157.234', '1695800787', '__ci_last_regenerate|i:1695800787;'), ('l586sr2qpih4eio5de6qgeab63k4ln9k', '103.67.157.234', '1695800788', '__ci_last_regenerate|i:1695800788;'), ('t7gt3ipt3qjhh5rnfe84hmfi9h1melmp', '103.67.157.234', '1695800788', '__ci_last_regenerate|i:1695800788;'), ('t4maci2689gnvmed2mkejqpublvvkv1c', '103.67.157.234', '1695800788', '__ci_last_regenerate|i:1695800788;'), ('1t8d986jjho0kni37s8vnf4pfn9bjt6a', '103.67.157.234', '1695800788', '__ci_last_regenerate|i:1695800788;'), ('1tsku8ekvq0nddg5libarnn3t15m973l', '103.67.157.234', '1695800788', '__ci_last_regenerate|i:1695800788;'), ('u18dqffr6mk1kmknqvjk3v8d6huo2355', '103.67.157.234', '1695800789', '__ci_last_regenerate|i:1695800789;'), ('n0k3bccjf69d1v8d0oeovagulhq936a7', '103.67.157.234', '1695800789', '__ci_last_regenerate|i:1695800789;'), ('5mq6454mc21abi4ffhjbl9n4pkdtj3hv', '103.67.157.234', '1695800790', '__ci_last_regenerate|i:1695800790;'), ('v2c4mi9gfnuek3ls4fv3roq746f8ande', '103.67.157.234', '1695800790', '__ci_last_regenerate|i:1695800790;'), ('0hkimsiscb0310qrdpcpk9fqtj1ltfsu', '103.67.157.234', '1695800790', '__ci_last_regenerate|i:1695800790;'), ('3eiqtfb57oqer4f14d3hp46pb1cib91o', '103.67.157.234', '1695800790', '__ci_last_regenerate|i:1695800790;'), ('pn87g9rh5lspbnd55o7iu11ofvd4g7o7', '103.67.157.234', '1695800790', '__ci_last_regenerate|i:1695800790;'), ('tg3ri65tfqckcjo1erpfcq98qtp2kurk', '103.67.157.239', '1695800792', '__ci_last_regenerate|i:1695800792;'), ('2tpdtu4jedg5moaonmdrestm7qmqmt4p', '103.67.157.239', '1695800796', '__ci_last_regenerate|i:1695800796;'), ('qlrsald0i7op6r8d7au4mc668ndjoomc', '103.67.157.239', '1695800796', '__ci_last_regenerate|i:1695800796;'), ('oqcmt4t903bcuc5uf45f4vff7q4mb3bg', '103.67.157.231', '1695800801', '__ci_last_regenerate|i:1695800801;'), ('212qqmuma80phsgrmkp2lb899oeuthea', '103.67.157.231', '1695800801', '__ci_last_regenerate|i:1695800801;'), ('8dvdqn8c7i4r9fkdb5ed0opc4r7nudqf', '103.67.157.231', '1695800801', '__ci_last_regenerate|i:1695800801;'), ('birebvp85g6163kfb67r16fm2t93pk8d', '103.67.157.231', '1695800806', '__ci_last_regenerate|i:1695800806;'), ('o4uhnhdf775r18pe710f6u5bjni8f7pv', '103.67.157.231', '1695800806', '__ci_last_regenerate|i:1695800806;'), ('7m6lisjlat6u8gt428ekjd2te24tis5j', '103.67.157.231', '1695801270', '__ci_last_regenerate|i:1695801270;'), ('c16s3i89cl01ifhcgn2bi6s41lsk62ku', '103.67.157.231', '1695801273', '__ci_last_regenerate|i:1695801273;'), ('196jt221h0a1q6acht9cfh6u1hp2foc5', '103.67.157.231', '1695801273', '__ci_last_regenerate|i:1695801273;'), ('96faelvt3gffgno6rnmvi7mru7lj8v41', '103.67.157.231', '1695801273', '__ci_last_regenerate|i:1695801273;'), ('fg98g8gq0j8del7pt932ua3dt149taam', '103.67.157.231', '1695801274', '__ci_last_regenerate|i:1695801274;'), ('5aleg18ejcvahs9o24u3shpg4fc4j81k', '103.67.157.231', '1695801302', '__ci_last_regenerate|i:1695801302;'), ('j1qato3uiguqs5nsv2a625gmvb6a3vp4', '103.67.157.231', '1695801306', '__ci_last_regenerate|i:1695801306;'), ('minfglk8nejv5pb2deduf72ke228rd7r', '103.67.157.231', '1695801306', '__ci_last_regenerate|i:1695801306;'), ('dr5rp7flhpfj1gmqqbg2b7c44krvlcn1', '103.67.157.231', '1695801306', '__ci_last_regenerate|i:1695801306;'), ('qjo3i98hv2d1eh4l8m16i9uimvqcghvr', '103.67.157.231', '1695801306', '__ci_last_regenerate|i:1695801306;'), ('chnid6kujvp0763n3r66fo8am1tb7h9i', '103.67.157.231', '1695801306', '__ci_last_regenerate|i:1695801306;'), ('h8c6q83ak9m2jgeqsvr4b1glnbv5ac07', '103.67.157.231', '1695801306', '__ci_last_regenerate|i:1695801306;'), ('3tfn3fn52575fj97e0uqmadrmlf69ngf', '103.67.157.231', '1695801306', '__ci_last_regenerate|i:1695801306;'), ('aitfd82ksnl3b7dklermp1uuti58dthu', '103.67.157.231', '1695801308', '__ci_last_regenerate|i:1695801308;'), ('qvp5rr6quif7215btrvpg36llc8u0mjo', '103.67.157.231', '1695801308', '__ci_last_regenerate|i:1695801308;'), ('7qvu6a8kvbev20e7qj88sfonsn7vqrgm', '103.67.157.231', '1695801308', '__ci_last_regenerate|i:1695801308;'), ('u836f7ed8k1vd1ti5ucc5pbddi28ksuq', '103.67.157.231', '1695801308', '__ci_last_regenerate|i:1695801308;'), ('1neag0387ubgthm35b2i1ghqm9ra48h5', '103.67.157.231', '1695801320', '__ci_last_regenerate|i:1695801320;'), ('mllinpti9nhep69ed6s2ocbufmbr23vo', '103.67.157.231', '1695801349', '__ci_last_regenerate|i:1695801349;'), ('jk3ls6g9242iv6ef4g100iroa879u46f', '103.67.157.231', '1695801424', '__ci_last_regenerate|i:1695801424;'), ('hrrk4tdpfqhqh4c4os08q4rb82jgv19f', '103.67.157.231', '1695801428', '__ci_last_regenerate|i:1695801428;'), ('7p8npoov4j3rpifsk7j5d0lls57fki7j', '103.67.157.231', '1695801428', '__ci_last_regenerate|i:1695801428;'), ('gknp1hg8d5li5not3u0f6fljjsmiq5jm', '103.67.157.231', '1695801428', '__ci_last_regenerate|i:1695801428;'), ('p5lfcfcc7umn2si9qlkttkjk5lmb6jrj', '103.67.157.231', '1695801428', '__ci_last_regenerate|i:1695801428;'), ('nteku4l9eh64rap56c32ns1upj0m0fpc', '103.67.157.231', '1695801428', '__ci_last_regenerate|i:1695801428;'), ('ru7kbog7bhcv9qp6f5r8mj13d0g30m5m', '103.67.157.231', '1695801428', '__ci_last_regenerate|i:1695801428;'), ('jqijltp7bf360v7ibel2eho386h4c8ui', '103.67.157.231', '1695801429', '__ci_last_regenerate|i:1695801429;'), ('gp7dbtuf8r11aba5uoh8td9ai3ust0m3', '103.67.157.231', '1695801430', '__ci_last_regenerate|i:1695801430;'), ('l823n4lk979f004dfkp4m0utfijjha9j', '103.67.157.231', '1695801430', '__ci_last_regenerate|i:1695801430;'), ('k0je0dttbmgcrunske2kf7i5j9om1m2c', '103.67.157.231', '1695801431', '__ci_last_regenerate|i:1695801431;'), ('ancj7lrjas3g0mk09ravmsi7v2psdg1g', '103.67.157.231', '1695801431', '__ci_last_regenerate|i:1695801431;'), ('2809n5rc7rj5gt0ubjbim10lpdatemil', '103.67.157.231', '1695801486', '__ci_last_regenerate|i:1695801486;'), ('5s6k3aer0tibqd9htfmmkbrm7g2vha3k', '103.67.157.231', '1695801504', '__ci_last_regenerate|i:1695801504;'), ('dmst14sbr983j5404bj9kimms2hu7kmv', '103.67.157.231', '1695801513', '__ci_last_regenerate|i:1695801513;'), ('65n9c9mnuvt6a6s4gbbur7goj5umoip1', '103.67.157.231', '1695801513', '__ci_last_regenerate|i:1695801513;'), ('6ba0miugt5401hdh9q5a8kgr6f5n389f', '103.67.157.231', '1695801513', '__ci_last_regenerate|i:1695801513;'), ('9tk3hgdoemn4qb2k4g6k2d9j24ede65d', '103.67.157.231', '1695801514', '__ci_last_regenerate|i:1695801514;'), ('9udt6jivo0tn4oluohfhm529sdsem5ks', '103.67.157.231', '1695801514', '__ci_last_regenerate|i:1695801514;'), ('66fpvo54qb20n8mvt6qm04bab0ikqpfg', '103.67.157.231', '1695801522', '__ci_last_regenerate|i:1695801522;'), ('qpf86l7i3j5kpetv1720adad38rja0uq', '103.67.157.231', '1695801526', '__ci_last_regenerate|i:1695801526;'), ('btg6cbfkhb89th76kq4skha3pe85gici', '103.67.157.231', '1695801526', '__ci_last_regenerate|i:1695801526;'), ('3aal56p1qsahbju02acohb8fr5uitg2f', '103.67.157.231', '1695801526', '__ci_last_regenerate|i:1695801526;'), ('edjiineckdeq3444d9hap8ala2hms092', '103.67.157.231', '1695801526', '__ci_last_regenerate|i:1695801526;'), ('rnna222ev86p506cc7b1bh7b0g2glhfv', '103.67.157.231', '1695801526', '__ci_last_regenerate|i:1695801526;'), ('uqbloce7810tbsqj0h2ti08jsvce7rjt', '103.67.157.231', '1695801526', '__ci_last_regenerate|i:1695801526;'), ('87sap1g7h2h2np93i4qh96n48e29qpgg', '103.67.157.231', '1695801526', '__ci_last_regenerate|i:1695801526;'), ('805ogvikb5hfmpv19qqe48b6alts8vna', '103.67.157.231', '1695801530', '__ci_last_regenerate|i:1695801530;'), ('7tim3kblgj087ap3ivdhucljh5crcgt6', '103.67.157.231', '1695801530', '__ci_last_regenerate|i:1695801530;'), ('6mg045a23uj1ugsni4hrdu6nas40lma0', '103.67.157.231', '1695801530', '__ci_last_regenerate|i:1695801530;'), ('bk6es0pimd72curar69rmhukd7gcp6d4', '103.67.157.231', '1695801531', '__ci_last_regenerate|i:1695801531;'), ('4hgf0jv3s9h4194uqo151ppf1arj9c4l', '103.67.157.231', '1695801577', '__ci_last_regenerate|i:1695801577;'), ('j9351ncc8ut0qb28la21ol39q4gqhgqh', '103.67.157.231', '1695801615', '__ci_last_regenerate|i:1695801615;'), ('lojj4k6emc6snlib6po60pi1euqko996', '103.67.157.231', '1695801620', '__ci_last_regenerate|i:1695801620;'), ('p7kql7h0s74jt59p5g6bds9epesa50hp', '103.67.157.231', '1695801620', '__ci_last_regenerate|i:1695801620;'), ('o3kk09if54gmsv7rhhu4cl077mtadpoe', '103.67.157.231', '1695801620', '__ci_last_regenerate|i:1695801620;'), ('ji24949fpggqr2fdnca04p2trlumrhd5', '103.67.157.231', '1695801620', '__ci_last_regenerate|i:1695801620;'), ('iaaj772ijsssg6p42tt8l2gt0a3nse9d', '103.67.157.231', '1695801620', '__ci_last_regenerate|i:1695801620;'), ('vdsv0hbr0p3rg812doj3hvps9elqt0bp', '103.67.157.231', '1695801620', '__ci_last_regenerate|i:1695801620;'), ('0ekgfhfcrs2lde2f5e1hbbe4p2ide3pr', '103.67.157.231', '1695801621', '__ci_last_regenerate|i:1695801621;'), ('ia55f7stjuvvq8ftsthls8mlrfj7b8rk', '103.67.157.231', '1695801622', '__ci_last_regenerate|i:1695801622;'), ('lchmokd38e5oingocr6uud7epmv08bvv', '103.67.157.231', '1695801622', '__ci_last_regenerate|i:1695801622;'), ('3fbvq0vv4b3m9f4br9nrmdekef3naj69', '103.67.157.231', '1695801622', '__ci_last_regenerate|i:1695801622;'), ('0v0qh5h8iefrdcsnnsj059qhbkejhi68', '103.67.157.231', '1695801623', '__ci_last_regenerate|i:1695801623;'), ('ijm0ug560u47vscuarbq2m22f9fkf79a', '103.67.157.231', '1695801642', '__ci_last_regenerate|i:1695801642;'), ('706cp96t4tsnqmitu8dbnvps01tg287a', '103.67.157.231', '1695801645', '__ci_last_regenerate|i:1695801645;'), ('goro4m9p1dmqo0g76g3qgd9cb8tm6vlu', '103.67.157.231', '1695801645', '__ci_last_regenerate|i:1695801645;'), ('ji3s0s799d3qral3l5u3o0g2o057dj8o', '103.67.157.231', '1695801645', '__ci_last_regenerate|i:1695801645;'), ('vdq0u1612ieue5topb99urkud0lsvdk7', '103.67.157.231', '1695801645', '__ci_last_regenerate|i:1695801645;'), ('6fkt28c392jmv2gnmgctc8kion74vqar', '103.67.157.231', '1695801645', '__ci_last_regenerate|i:1695801645;'), ('3jpohcjbcuujmqau00pci7osue174vta', '103.67.157.231', '1695801645', '__ci_last_regenerate|i:1695801645;'), ('1nfdiddh335uj6pi0jivt9u46gq3j9j7', '103.67.157.231', '1695801646', '__ci_last_regenerate|i:1695801646;'), ('9i718il3ta2ck4juks8i35bhlhrhm0ni', '103.67.157.231', '1695801647', '__ci_last_regenerate|i:1695801647;'), ('rvjjs7hl4m0kelupl4l0clodjoa75spv', '103.67.157.231', '1695801647', '__ci_last_regenerate|i:1695801647;'), ('ud4ctabrl501bs3cjg3aemq8u0obper8', '103.67.157.231', '1695801647', '__ci_last_regenerate|i:1695801647;'), ('9uvj5qm9be06qjvi5ravf4p4hj6p6r7n', '103.67.157.231', '1695801647', '__ci_last_regenerate|i:1695801647;'), ('7auogtekh328ochtq4qvi98ib32b8cok', '103.67.157.231', '1695801648', '__ci_last_regenerate|i:1695801648;'), ('7q3d9k1urlnos6se91lnj61ldpva6hnk', '103.67.157.231', '1695801775', '__ci_last_regenerate|i:1695801775;'), ('m3ja8afi2b3ohp8ucl95qgomdri1tqi6', '103.67.157.231', '1695801913', '__ci_last_regenerate|i:1695801913;'), ('ncdvlr4fomdks8pudvv6u6fpe893cplu', '103.67.157.231', '1695801917', '__ci_last_regenerate|i:1695801917;'), ('trlnb977h127ff10kdjfi4shualtman7', '103.67.157.231', '1695801917', '__ci_last_regenerate|i:1695801917;'), ('qvc1iitpq98gi0napbvslkap7bvvj0ci', '103.67.157.231', '1695801917', '__ci_last_regenerate|i:1695801917;'), ('qnae8fi9imilf79s7ula5skfsohdjtf9', '103.67.157.231', '1695801917', '__ci_last_regenerate|i:1695801917;'), ('38fnrtdiiaqt4lip0t4tbqtqu70i5475', '103.67.157.231', '1695801917', '__ci_last_regenerate|i:1695801917;'), ('ecq5blhc8ipc18mi00c1as2lq9ekj2el', '103.67.157.231', '1695801917', '__ci_last_regenerate|i:1695801917;'), ('daraauo5dja2k8jqleru1t0com6cjmlj', '103.67.157.231', '1695801924', '__ci_last_regenerate|i:1695801924;'), ('2gcqckvrfunbptdon859ona8ovit4jvd', '103.67.157.231', '1695801925', '__ci_last_regenerate|i:1695801925;'), ('6vjsgk7s4a8ce4bh0lc1aisp22uo91ig', '103.67.157.231', '1695801925', '__ci_last_regenerate|i:1695801925;'), ('kj50ne8kcpf601h62jgh7skr79risgvo', '103.67.157.231', '1695801925', '__ci_last_regenerate|i:1695801925;'), ('gnbn629etq1ooui8p9e56hvmecejh6kg', '103.67.157.231', '1695801925', '__ci_last_regenerate|i:1695801925;'), ('3osrupbtuc0svf4foi73hjnmtkiat6dt', '103.67.157.231', '1695801925', '__ci_last_regenerate|i:1695801925;'), ('gjgfuuhhn947op72l7aol2v9tqdh4tad', '103.67.157.231', '1695801925', '__ci_last_regenerate|i:1695801925;'), ('g6vak715urbc1j3d9nj9upbj8t8265ni', '103.67.157.231', '1695801926', '__ci_last_regenerate|i:1695801926;'), ('m3h1jeq0t3imknrsl5mia9jgefgpndae', '103.67.157.231', '1695801926', '__ci_last_regenerate|i:1695801926;'), ('4frkmbfmcan0ukehb626e04ftl82828j', '103.67.157.231', '1695801926', '__ci_last_regenerate|i:1695801926;'), ('ea73v3aod1s5929dsk5b3qgghsftrf8m', '103.67.157.231', '1695801926', '__ci_last_regenerate|i:1695801926;'), ('4gifg9h6e4hquh3tvseva48mgq4ji2ai', '103.67.157.231', '1695801927', '__ci_last_regenerate|i:1695801927;'), ('m5dfngr1nrrmdrbm789lobh2drk2fr25', '103.67.157.231', '1695801927', '__ci_last_regenerate|i:1695801927;'), ('1oefejbs5e6het32rjbt9k5k651scmlc', '103.67.157.231', '1695801929', '__ci_last_regenerate|i:1695801929;'), ('b44ughui2khev7lv80j09bknrungbd89', '103.67.157.231', '1695801930', '__ci_last_regenerate|i:1695801930;'), ('d8pilip18ig8cvrcdk0sjjgmf67poke5', '103.67.157.231', '1695801930', '__ci_last_regenerate|i:1695801930;'), ('ns24s5t5n0hqh49j2ubjurc8a4728rbs', '103.67.157.231', '1695801930', '__ci_last_regenerate|i:1695801930;'), ('ovpc1coraqir0ak7no5utusiev3lbmmc', '103.67.157.231', '1695801930', '__ci_last_regenerate|i:1695801930;'), ('5e4g83afmdvp6t806rgvl107ce2mj8sm', '103.67.157.231', '1695801930', '__ci_last_regenerate|i:1695801930;'), ('f1hmn4jmhsiv6j94q84heq8t0vp49kns', '103.67.157.231', '1695801930', '__ci_last_regenerate|i:1695801930;'), ('rtuj1ojdt1ofo8h6ddhba8l3nok1cps2', '103.67.157.231', '1695801939', '__ci_last_regenerate|i:1695801939;'), ('4tum96md3msilkqis2lqoev67pkma6gt', '103.67.157.239', '1695801973', '__ci_last_regenerate|i:1695801973;'), ('s45bst0hp9r5m68gb2h1va335rpcs8bh', '103.67.157.239', '1695801974', '__ci_last_regenerate|i:1695801974;'), ('3shvtq4apbk6od2eepf3rg3baq8hf43s', '103.67.157.239', '1695801974', '__ci_last_regenerate|i:1695801974;'), ('pq4b94ct1vahalu9f2qe2qebsp3rdqjc', '103.67.157.239', '1695801974', '__ci_last_regenerate|i:1695801974;'), ('25t18t2moorl4675nd3qtffuk4a08gc3', '103.67.157.239', '1695801974', '__ci_last_regenerate|i:1695801974;'), ('07ej7v00a7b4g2ch837oureh7qac3ldt', '103.67.157.239', '1695801974', '__ci_last_regenerate|i:1695801974;'), ('aq6l215rhbcg8kdrqefsmmj872o8d14p', '103.67.157.239', '1695801974', '__ci_last_regenerate|i:1695801974;'), ('ipgccbh5q8au9uovpnhn50r45smkgll3', '103.67.157.224', '1695801974', '__ci_last_regenerate|i:1695801974;'), ('uh32vs6bcrdjtd0potoha3ii3l3t46lh', '103.67.157.224', '1695801975', '__ci_last_regenerate|i:1695801975;'), ('92gbu4mhsgib76fkv6m09a0db68jhl82', '103.67.157.224', '1695801975', '__ci_last_regenerate|i:1695801975;'), ('4neieptqd4t5trirjfoetcl5f7sot1al', '103.67.157.224', '1695801975', '__ci_last_regenerate|i:1695801975;'), ('52lk278ubaod4iv1uc1eq6ohq8r4f76o', '103.67.157.224', '1695801976', '__ci_last_regenerate|i:1695801976;'), ('3oe1hb0nh6o3ru3dvn5t40g1q9doi4me', '103.67.157.224', '1695801980', '__ci_last_regenerate|i:1695801980;'), ('75gs54neddlsf3p7e6rv5g1thf27382u', '103.67.157.224', '1695801980', '__ci_last_regenerate|i:1695801980;'), ('2qam54mokvrb5bfqavt14taechd7d428', '103.67.157.224', '1695801980', '__ci_last_regenerate|i:1695801980;'), ('aed8im4aes88csfmjobu0f21874he77k', '103.67.157.224', '1695801981', '__ci_last_regenerate|i:1695801981;'), ('cgtqmd7fdhjbgj5r7s64onbn5lbm8jcd', '103.67.157.224', '1695801981', '__ci_last_regenerate|i:1695801981;'), ('kq51cmu7rfpnohmn0u6t4v1jcijcp1f9', '103.67.157.224', '1695801981', '__ci_last_regenerate|i:1695801981;'), ('j8i9lpr7eresfvbmlau6sahdia3ld17u', '103.67.157.224', '1695801981', '__ci_last_regenerate|i:1695801981;'), ('spnj71ieb01nesinnqcjh5duotlakvmc', '103.67.157.225', '1695802048', '__ci_last_regenerate|i:1695802048;'), ('abmcmt4ouvohst6s8c8uhmfkuf21ieo2', '103.67.157.225', '1695802049', '__ci_last_regenerate|i:1695802049;'), ('1hd9966sbhjsu31lonogsan1hlmft3rn', '103.67.157.225', '1695802049', '__ci_last_regenerate|i:1695802049;'), ('k27ei0mgg8a0dn6ibdiqopnul3ts4fks', '103.67.157.225', '1695802049', '__ci_last_regenerate|i:1695802049;'), ('1pfqudc53s4r4ldj6bnael3omama1s1a', '103.67.157.225', '1695802049', '__ci_last_regenerate|i:1695802049;'), ('qrr41jknrjo91m0bchs16fkdtpni6m80', '103.67.157.225', '1695802049', '__ci_last_regenerate|i:1695802049;'), ('ha9jknr9314vgfjqbmbqoenplhp2o76n', '103.67.157.225', '1695802049', '__ci_last_regenerate|i:1695802049;'), ('nhn87bgniekmlfpechiruo4m9q1115p0', '103.67.157.225', '1695802050', '__ci_last_regenerate|i:1695802050;'), ('nju9nkv4a7o6fhlilm30nlrn5omn6fue', '103.67.157.225', '1695802052', '__ci_last_regenerate|i:1695802052;'), ('hj7odr7senn82rajeo139t5ij0bbclls', '103.67.157.225', '1695802052', '__ci_last_regenerate|i:1695802052;'), ('35hnr7mt4545j1khsve9din728u55e0e', '103.67.157.225', '1695802052', '__ci_last_regenerate|i:1695802052;'), ('oj5aa6paiuo0el64eba83vu9p5l743ue', '103.67.157.225', '1695802053', '__ci_last_regenerate|i:1695802053;'), ('5d4i247n2prsgnt2ku2pe8f47a0i3nu1', '103.67.157.225', '1695802057', '__ci_last_regenerate|i:1695802057;'), ('06ul2inham61ndmqoijmlldfbvsk1vu0', '103.67.157.239', '1695802057', '__ci_last_regenerate|i:1695802057;'), ('4iq5860bk4t359shmcfnhtd2bbjmth8i', '103.67.157.239', '1695802057', '__ci_last_regenerate|i:1695802057;'), ('utt631d3onbgj8jqc99a4aki2l71tcb0', '103.67.157.225', '1695802057', '__ci_last_regenerate|i:1695802057;'), ('52ht27vhmg5vpe57fmrkcu03t8ieq73b', '103.67.157.239', '1695802057', '__ci_last_regenerate|i:1695802057;'), ('7atpn9bm6fotrsulnbfdsld27vkqpv7d', '103.67.157.239', '1695802057', '__ci_last_regenerate|i:1695802057;'), ('tnqtsdvcgadv3n3ij0scckjgd5m0h55r', '103.67.157.239', '1695802057', '__ci_last_regenerate|i:1695802057;'), ('kj7luid46vmvd7tpcq25cu7n9j5p33s0', '103.67.157.239', '1695802081', '__ci_last_regenerate|i:1695802081;'), ('e8bvsn9qtm45o6v5uqu49a9i6dgqat5s', '103.67.157.239', '1695802082', '__ci_last_regenerate|i:1695802082;'), ('5l0u27edf37dkphmkqkddqbr114mpmuk', '103.67.157.239', '1695802082', '__ci_last_regenerate|i:1695802082;'), ('ub5crlra02e27looh52k86uces4n8cn8', '103.67.157.239', '1695802082', '__ci_last_regenerate|i:1695802082;'), ('pf2irvf0pr7trvvvi9uufrs6k4avhv7i', '103.67.157.239', '1695802082', '__ci_last_regenerate|i:1695802082;'), ('sut293v4i1gepukln9tptmnip3sproal', '103.67.157.239', '1695802082', '__ci_last_regenerate|i:1695802082;'), ('nt9d4l78673elhg1sh95e1k9pta9eslc', '103.67.157.239', '1695802082', '__ci_last_regenerate|i:1695802082;'), ('341d1baftbs206pt54qliih0hqrjlgvt', '103.67.157.239', '1695802082', '__ci_last_regenerate|i:1695802082;'), ('3nlqtnklshgas7n3qsjp5f8s313ab5cc', '103.67.157.239', '1695802144', '__ci_last_regenerate|i:1695802144;'), ('g4sr34iv81rera1jng033061n50poevc', '103.67.157.239', '1695802144', '__ci_last_regenerate|i:1695802144;'), ('bvt560jqtrk5ibfcm2sgcuh7c32v127a', '103.67.157.239', '1695802144', '__ci_last_regenerate|i:1695802144;'), ('4207m36714c8m45rib41nqkdcq00e278', '103.67.157.239', '1695802144', '__ci_last_regenerate|i:1695802144;'), ('t042c0e8qiq4474ggh5d3lnms6j78v5a', '103.67.157.239', '1695802144', '__ci_last_regenerate|i:1695802144;'), ('6vl7ckrh0lgbpenar3hdb4km3vaju2tc', '103.67.157.239', '1695802146', '__ci_last_regenerate|i:1695802146;'), ('bds1c0n4rr4e9qrvefgcv17bnpi0e02f', '103.67.157.239', '1695802171', '__ci_last_regenerate|i:1695802146;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1695845364;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('2u87shh1aeijjbti4tftedcdag90k6h8', '103.67.157.239', '1695802147', '__ci_last_regenerate|i:1695802147;'), ('6artijtkb9eco7hg3n5m555n2uld9klo', '103.67.157.239', '1695802147', '__ci_last_regenerate|i:1695802147;'), ('jpr5ds2civjmf4gcr7rfhj6qrsk2muvb', '103.67.157.239', '1695802147', '__ci_last_regenerate|i:1695802147;'), ('gj0kkbi9m6m19paca0ff7pn48jq9sqmr', '103.67.157.239', '1695802147', '__ci_last_regenerate|i:1695802147;'), ('k4uafj0apqq7o3p3oole1uqlr6rt4q6v', '103.67.157.239', '1695802149', '__ci_last_regenerate|i:1695802149;'), ('6oq5dt1r7sn9glotunhv5md1uu95c7ki', '103.67.157.239', '1695802149', '__ci_last_regenerate|i:1695802149;'), ('dlptjkvcksp7ib6mjr5b9klp73eaat76', '103.67.157.239', '1695802150', '__ci_last_regenerate|i:1695802150;'), ('44b884td19vdnde4in4gvts8s5vd2vo1', '103.67.157.239', '1695802150', '__ci_last_regenerate|i:1695802150;'), ('ss70nsr8dv6qjo8m3c8011h7d0utkt4k', '103.67.157.239', '1695802150', '__ci_last_regenerate|i:1695802150;'), ('ft62vmm2u2uomova75j6d47c6sae6o4g', '103.67.157.239', '1695802150', '__ci_last_regenerate|i:1695802150;'), ('jnuk2ghkj7r0r9i89akbdsdrcthpigt2', '103.67.157.239', '1695802150', '__ci_last_regenerate|i:1695802150;'), ('8lb0ss683a8mtvje554qssnip9fn7ph8', '103.67.157.239', '1695802150', '__ci_last_regenerate|i:1695802150;'), ('4civi4rjpuf72so8qphnoidmcs47h0ad', '103.67.157.239', '1695802151', '__ci_last_regenerate|i:1695802151;'), ('q1hp62eaok2rv4pt955a71r9i9ve9blc', '103.67.157.239', '1695802151', '__ci_last_regenerate|i:1695802151;'), ('utiablpbieg81kd4mv92vvuqgbruvpnn', '103.67.157.239', '1695802151', '__ci_last_regenerate|i:1695802151;'), ('vl4c32cj9uvt6b3f9i7sfpolsuj28ced', '103.67.157.239', '1695802151', '__ci_last_regenerate|i:1695802151;'), ('mjqhj7k0m8461sboei9jhsm26498arae', '103.67.157.239', '1695802152', '__ci_last_regenerate|i:1695802152;'), ('kjnid79up2q28p1vdbonb609gfu5db83', '103.67.157.239', '1695802154', '__ci_last_regenerate|i:1695802154;'), ('f1kgeakj80v94pm2pi67hj69qilf1mn5', '103.67.157.239', '1695802155', '__ci_last_regenerate|i:1695802155;'), ('dp3j8h0jusvo2h952cd62crnkfn8tgpd', '103.67.157.239', '1695802156', '__ci_last_regenerate|i:1695802156;'), ('0eug75tdvrpmu6g82hn88f6ke7bj3cbm', '103.67.157.239', '1695802156', '__ci_last_regenerate|i:1695802156;'), ('j872rvt74dcadq75gnqnud1mp3uonmdg', '103.67.157.239', '1695802156', '__ci_last_regenerate|i:1695802156;'), ('k6tl5ddnddcc5t33hubl7rocdfbsh1gr', '103.67.157.239', '1695802156', '__ci_last_regenerate|i:1695802156;'), ('54hfj82pg9r0oqgu1k275054o4i2g424', '103.67.157.239', '1695802156', '__ci_last_regenerate|i:1695802156;'), ('81upc8inrdo0t3vbf0m43akffdnm23c1', '103.67.157.239', '1695802156', '__ci_last_regenerate|i:1695802156;'), ('kigvdhu3ub1rdq4cftv0p79u8cstfd6t', '103.67.157.239', '1695802156', '__ci_last_regenerate|i:1695802156;'), ('ngclnhphji29makme93skon3c5sh5he9', '103.67.157.239', '1695802156', '__ci_last_regenerate|i:1695802156;'), ('1fm0l327jjvc592e4ff471jkisf788qn', '103.67.157.239', '1695802156', '__ci_last_regenerate|i:1695802156;'), ('visvu8iegd3f2u5or7knl2mbdrcv276h', '103.67.157.239', '1695802156', '__ci_last_regenerate|i:1695802156;'), ('fr0fgsr6afo2uj3i1s003tfils6u5os1', '103.67.157.239', '1695802161', '__ci_last_regenerate|i:1695802161;'), ('i0osdgk2e3gm96j3tmchr8q4j0f83bgh', '103.67.157.239', '1695802161', '__ci_last_regenerate|i:1695802161;'), ('rcj1r951k0dmqeit7bvu9utifju81mnr', '103.67.157.239', '1695802161', '__ci_last_regenerate|i:1695802161;'), ('q2qrmsshp9pp370vtnp3umgpu9rujf70', '103.67.157.239', '1695802161', '__ci_last_regenerate|i:1695802161;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('77dhgko2t3v9ur3a6bq3rjc39gh6qk0d', '103.67.157.239', '1695802164', '__ci_last_regenerate|i:1695802164;'), ('ka4t76igi0mfcmm67b3c37dn81ir5ucj', '103.67.157.239', '1695802169', '__ci_last_regenerate|i:1695802169;'), ('k4ft5ma5r5fms64ov8cuocsf5giessfh', '103.67.157.239', '1695802547', '__ci_last_regenerate|i:1695802547;'), ('geoc5ec0lok3tvn3smu47svf2p1b94v4', '103.67.157.239', '1695802548', '__ci_last_regenerate|i:1695802548;'), ('51d04b5v2sqcslfj2mcot9jdgs428l95', '103.67.157.239', '1695802548', '__ci_last_regenerate|i:1695802548;'), ('7aifrqi8q86amltpkm2l834omb8nmuaj', '103.67.157.239', '1695802548', '__ci_last_regenerate|i:1695802548;'), ('jad49p5tdoesr4iu5avo55kr4sd8g878', '103.67.157.239', '1695802548', '__ci_last_regenerate|i:1695802548;'), ('brv607et2votju3chv1g0lokukorpnsi', '103.67.157.239', '1695802549', '__ci_last_regenerate|i:1695802549;'), ('vhl55ls29obbv4p0sk08u2gt7kal5rd3', '103.67.157.239', '1695802549', '__ci_last_regenerate|i:1695802549;'), ('qm72i52hdlqqdk87h1m5vumfekg2c458', '103.67.157.239', '1695802549', '__ci_last_regenerate|i:1695802549;'), ('5f3oklveqib6bps6hna6kcjsrbt4q422', '103.67.157.239', '1695802559', '__ci_last_regenerate|i:1695802559;'), ('3nf0g10kqp2maf33k0gpvrntv1dg3649', '103.67.157.239', '1695802560', '__ci_last_regenerate|i:1695802560;'), ('1ltmlpf98ut8n88p6o9io9hb8439f82c', '103.67.157.239', '1695802560', '__ci_last_regenerate|i:1695802560;'), ('4pnf5cl822uclge46g7p1ratg1oi0101', '103.67.157.239', '1695802560', '__ci_last_regenerate|i:1695802560;'), ('ma7nshjiodch6iochgshitrhui6lsa7m', '103.67.157.239', '1695802560', '__ci_last_regenerate|i:1695802560;'), ('lu84g5v8t6jonb8fn049a2gv9i8jf9t6', '103.67.157.239', '1695802560', '__ci_last_regenerate|i:1695802560;'), ('h5hqgmoi7m8hgubfjub2dkdvpqjr4cdl', '103.67.157.239', '1695802560', '__ci_last_regenerate|i:1695802560;'), ('26psedrbe4ku3sspu5cjihqh7f85fpef', '103.67.157.239', '1695802560', '__ci_last_regenerate|i:1695802560;'), ('bpb1kkh918e2sd5b429ft81gef7hpavo', '103.67.157.239', '1695802562', '__ci_last_regenerate|i:1695802562;'), ('koocg57mhumijkbin96etkjv627745bp', '103.67.157.239', '1695802563', '__ci_last_regenerate|i:1695802563;'), ('aflsn8424g68htv6ilha8maqc807b12k', '103.67.157.239', '1695802574', '__ci_last_regenerate|i:1695802563;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1695845768;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('eitn65tsu19vq468l80hsr9qsnibt0lu', '103.67.157.239', '1695802564', '__ci_last_regenerate|i:1695802564;'), ('l7ifg5sovii74knt6jhusurp6fhbh65k', '103.67.157.239', '1695802565', '__ci_last_regenerate|i:1695802565;'), ('p0fl6cojbg9934cp0pth5l87lb1kc7on', '103.67.157.239', '1695802566', '__ci_last_regenerate|i:1695802566;'), ('5jtq18de5dgl7q3p6mjbnr91vh23po7t', '103.67.157.239', '1695802566', '__ci_last_regenerate|i:1695802566;'), ('424qnok3rl719hf782ksl9ej8e5bi25l', '103.67.157.239', '1695802566', '__ci_last_regenerate|i:1695802566;'), ('9db4jrfouooh53kavphgjec4hqp7sauu', '103.67.157.239', '1695802566', '__ci_last_regenerate|i:1695802566;'), ('64qsphs9p5n4i7et51q65f2tpitprvn9', '103.67.157.239', '1695802566', '__ci_last_regenerate|i:1695802566;'), ('476n46hpon06is0fcmmqtqb469mc35uk', '103.67.157.239', '1695802566', '__ci_last_regenerate|i:1695802566;'), ('h4nrgjrqcpkeh45o2kiinu8jkkpko1v8', '103.67.157.239', '1695802566', '__ci_last_regenerate|i:1695802566;'), ('khs79eb6s3l9i0jbrkeqqauav3tb9kp5', '103.67.157.239', '1695802566', '__ci_last_regenerate|i:1695802566;'), ('81gl3rjs56vm1bsd0m93jf3du2os4rj1', '103.67.157.239', '1695802566', '__ci_last_regenerate|i:1695802566;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('eidf7mdevu42qhcli32gkkmtef6827e7', '103.67.157.239', '1695802566', '__ci_last_regenerate|i:1695802566;'), ('df8akdh60mlgui8ljijatt8haoch0v6m', '103.67.157.239', '1695802568', '__ci_last_regenerate|i:1695802568;'), ('lc5ogckdqkh0lsd3k8jb8mjcd8luhgvd', '103.67.157.239', '1695802573', '__ci_last_regenerate|i:1695802573;'), ('qo8hmbnjikv82cfg7gp5e89it777k7no', '103.67.157.239', '1695802574', '__ci_last_regenerate|i:1695802574;'), ('p2oqp1n8gdvn1hikkg3uiagtev0vq1kc', '103.67.157.239', '1695802574', '__ci_last_regenerate|i:1695802574;'), ('lgmt30eep1esrbsies1bet2rqv2e9pom', '103.67.157.239', '1695802574', '__ci_last_regenerate|i:1695802574;'), ('qb6g0p3sd33cdo1fb9jik1nijasvebe0', '103.67.157.239', '1695802574', '__ci_last_regenerate|i:1695802574;'), ('6ak8frrio5nk2r56aml1c9oe0fla76jk', '103.67.157.239', '1695802575', '__ci_last_regenerate|i:1695802575;'), ('62ulrrg8n86k75nnohe8te1jqvi8j29b', '103.67.157.239', '1695802578', '__ci_last_regenerate|i:1695802578;'), ('7a7ggq2m819pthli3j7b5erprp81nj1s', '103.67.157.239', '1695802578', '__ci_last_regenerate|i:1695802578;'), ('irtolnlbl2l46at437v7ducs0o6p58f9', '103.67.157.239', '1695802578', '__ci_last_regenerate|i:1695802578;'), ('odc94iff2hejvs4ffv1f6t7r9biselp9', '103.67.157.239', '1695802578', '__ci_last_regenerate|i:1695802578;'), ('kkl3sb1198g4cjcnn6cjp5c51f79i0n3', '103.67.157.239', '1695802578', '__ci_last_regenerate|i:1695802578;'), ('md7or4645mb5g4t2s63lc0boct84rq3f', '103.67.157.239', '1695802578', '__ci_last_regenerate|i:1695802578;'), ('cr4ni82n7l4b5rpronrr3d59toordrqq', '103.67.157.239', '1695802578', '__ci_last_regenerate|i:1695802578;'), ('adlubc4tvptd6o009jrklfeepa7nbvlg', '103.67.157.239', '1695802587', '__ci_last_regenerate|i:1695802587;'), ('urni7rv86bcu41c3tks5bnmqu55i5410', '103.67.157.239', '1695802865', '__ci_last_regenerate|i:1695802865;'), ('9ct7as7ne30vh64u21bj2vqt4oa0mdrh', '103.67.157.239', '1695802868', '__ci_last_regenerate|i:1695802868;'), ('iuv4agvngnhe733ukq34dl0eogj2rv33', '103.67.157.239', '1695802868', '__ci_last_regenerate|i:1695802868;'), ('6q9ab58js8fk5uom6uou3h7k1dublllp', '103.67.157.239', '1695802868', '__ci_last_regenerate|i:1695802868;'), ('cjadcsv0us7hlg3fuue50muq57ncgpit', '103.67.157.239', '1695802868', '__ci_last_regenerate|i:1695802868;'), ('ai3vh9g8iv0r2g9cds7557rgg8rrh06e', '103.67.157.239', '1695802868', '__ci_last_regenerate|i:1695802868;'), ('nbm5bou5fgo0vmb0siok5rp7128bqpgg', '103.67.157.239', '1695802868', '__ci_last_regenerate|i:1695802868;'), ('9drlrogsc8uqflnsrtbq7p9b7g3mk95p', '103.67.157.239', '1695802869', '__ci_last_regenerate|i:1695802869;'), ('ugs2mq8ff10e885rc4n2dui8us0bkmfk', '103.67.157.239', '1695802871', '__ci_last_regenerate|i:1695802871;'), ('1mrc3sptmpv5nsnsruhr85mrri2nkije', '103.67.157.239', '1695802871', '__ci_last_regenerate|i:1695802871;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('brfq0cgu9i6pln95toe4ajdn7btirntm', '103.67.157.239', '1695802871', '__ci_last_regenerate|i:1695802871;'), ('518ob1mnt6u49sqkd4sgri3fk3huoqus', '103.67.157.239', '1695802888', '__ci_last_regenerate|i:1695802888;'), ('581ougo19rpkge5mguoq81rt631nu9f6', '103.67.157.239', '1695802889', '__ci_last_regenerate|i:1695802889;'), ('508f518gbg9ed3d1g9sdaahv83gkdbnr', '103.67.157.239', '1695802889', '__ci_last_regenerate|i:1695802889;'), ('o9qkgtt1t643roa98jhrperksihu4hkr', '103.67.157.239', '1695802889', '__ci_last_regenerate|i:1695802889;'), ('s9d7t7tlj8st4pfg8ev1dhjqd77al1sj', '103.67.157.239', '1695802889', '__ci_last_regenerate|i:1695802889;'), ('4c92v739ed7dtvrtlt0931lu8d48567n', '103.67.157.239', '1695802889', '__ci_last_regenerate|i:1695802889;'), ('1333iuc962st9b4ur1qal9v9r65l7an0', '103.67.157.239', '1695802889', '__ci_last_regenerate|i:1695802889;'), ('umgbfeg4jstet4mo953s9tqo83cgrk2h', '103.67.157.239', '1695802889', '__ci_last_regenerate|i:1695802889;'), ('sp2aspbqjsnj560qfb06pvmkniqeickm', '103.67.157.239', '1695802891', '__ci_last_regenerate|i:1695802891;'), ('doj6i9pt57uvunl64r57s75fe7usipt4', '103.67.157.239', '1695802891', '__ci_last_regenerate|i:1695802891;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ss91n97tdsv92kg64dies3n6c8s6tpka', '103.67.157.239', '1695802891', '__ci_last_regenerate|i:1695802891;'), ('bbo7v4m4pnjml9ru6gitfrgic56jlemq', '103.67.157.239', '1695802893', '__ci_last_regenerate|i:1695802893;'), ('c8mtbmojqhu2dbefrqsk1v4voe61sr6f', '103.67.157.239', '1695802893', '__ci_last_regenerate|i:1695802893;'), ('652b23pa0bnbg30mhpjvkf4lkn0ir6r8', '103.67.157.239', '1695802895', '__ci_last_regenerate|i:1695802895;'), ('kfel60qaivjntb0gpt1hotetm7p5head', '103.67.157.239', '1695802896', '__ci_last_regenerate|i:1695802896;'), ('t00g5jfiu850h5nhkm30iqldp34kokmj', '103.67.157.239', '1695802896', '__ci_last_regenerate|i:1695802896;'), ('8tasurtuqrlj8quir7s9kgfk08ki08bd', '103.67.157.239', '1695802896', '__ci_last_regenerate|i:1695802896;'), ('r4h4rnpsaklq6uf770jbop5q8chbf4is', '103.67.157.239', '1695802896', '__ci_last_regenerate|i:1695802896;'), ('bg68aotukr46pd6jfipv8cdlrhrlof1n', '103.67.157.239', '1695802896', '__ci_last_regenerate|i:1695802896;'), ('2cm59f4ib1hs9etrucgbjjj2kntb5s00', '103.67.157.239', '1695802896', '__ci_last_regenerate|i:1695802896;'), ('1bruaivrkosdko73ljs8n04dki1nsrjc', '103.67.157.239', '1695802897', '__ci_last_regenerate|i:1695802897;'), ('7s5jmpmi7r9cn749cto45tafnqmjipg6', '103.67.157.239', '1695802897', '__ci_last_regenerate|i:1695802897;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('kkcflppjpkfe8k5g8di7kko3hfrcv4ns', '103.67.157.239', '1695802898', '__ci_last_regenerate|i:1695802898;'), ('5kj1a80ptil1gulrq6enj5d5lu5b3d6v', '103.67.157.239', '1695802933', '__ci_last_regenerate|i:1695802933;'), ('e92uqc403u95vjuln6olmqkssuv4coj0', '103.67.157.239', '1695802934', '__ci_last_regenerate|i:1695802934;'), ('8urrqua4nmdvhk698koq6mi3jfemviet', '103.67.157.239', '1695802934', '__ci_last_regenerate|i:1695802934;'), ('b15vjlh3di1gesh1uckv9a14j9nsuod9', '103.67.157.239', '1695802934', '__ci_last_regenerate|i:1695802934;'), ('ak3h0dnu02idm5oofohh1487rca4jf03', '103.67.157.239', '1695802935', '__ci_last_regenerate|i:1695802935;'), ('pvo8gt7r1nm44tptbktc508bvt1dgcog', '103.67.157.239', '1695802946', '__ci_last_regenerate|i:1695802946;'), ('9riffr785md8enbb18tokjdjgmc98c9k', '103.67.157.239', '1695802950', '__ci_last_regenerate|i:1695802950;'), ('o9ihsdpprs3k7992d6o8d4m3mfqd9r7i', '103.67.157.239', '1695802950', '__ci_last_regenerate|i:1695802950;'), ('c42vo3nm07k35e8q3a83mamshud878nf', '103.67.157.239', '1695802950', '__ci_last_regenerate|i:1695802950;'), ('tfsu07nikugj79p1ibrd6k3e75b1ir7b', '103.67.157.239', '1695802950', '__ci_last_regenerate|i:1695802950;'), ('4ap2nqp2au3rl3tguv9ao2iu6b7vk9b6', '103.67.157.239', '1695802950', '__ci_last_regenerate|i:1695802950;'), ('o8885qdkg1o34jcvel2l9v5amd2kdbhf', '103.67.157.239', '1695802950', '__ci_last_regenerate|i:1695802950;'), ('lre1bj1tsjfnaiu22ng9viu06ld8hrp0', '103.67.157.239', '1695802950', '__ci_last_regenerate|i:1695802950;'), ('368l1kk0b8e89l26i5aockfup6eloeo9', '103.67.157.239', '1695802953', '__ci_last_regenerate|i:1695802953;'), ('gfpi5n5f85l9esgtkvkv9rg1gi49spkg', '103.67.157.239', '1695802953', '__ci_last_regenerate|i:1695802953;'), ('j5tetekts0947sdukagagud9n8bajdgq', '103.67.157.239', '1695802953', '__ci_last_regenerate|i:1695802953;'), ('377ptjr08qdleht9j3vq1u0q7q6ihh3q', '103.67.157.239', '1695802953', '__ci_last_regenerate|i:1695802953;'), ('cg23di0bsgn58th42ur4qqvmt2og5b0c', '103.67.157.239', '1695802954', '__ci_last_regenerate|i:1695802954;'), ('o56fk34652a0fku79ck0tpj2krefgqa3', '212.70.118.68', '1695802968', '__ci_last_regenerate|i:1695802968;'), ('8bhb6plu5u92c5k5tqnfm9kbnifln593', '212.70.118.68', '1695802971', '__ci_last_regenerate|i:1695802971;'), ('6f2l681m9hck04mccfq8i1prt7ogcorl', '212.70.118.68', '1695802971', '__ci_last_regenerate|i:1695802971;'), ('p8s33ijh5i8ajbslmph5n5f20pm8ujlb', '212.70.118.68', '1695802971', '__ci_last_regenerate|i:1695802971;'), ('gec3fppv6jf84d0lgm9s1c9rkhku0q9o', '212.70.118.68', '1695802971', '__ci_last_regenerate|i:1695802971;'), ('nfsffi3mi55pi2fqvm46to1npv9qd1i3', '212.70.118.68', '1695802971', '__ci_last_regenerate|i:1695802971;'), ('2tges9bqotnt8kbt5h18jccvdv2leprm', '212.70.118.68', '1695802971', '__ci_last_regenerate|i:1695802971;'), ('7veghupsimnlnk4o38g5chishqk8ht64', '212.70.118.68', '1695802971', '__ci_last_regenerate|i:1695802971;'), ('rpdijglanofu5anua0nqplm4hi90chji', '212.70.118.68', '1695803005', '__ci_last_regenerate|i:1695803005;'), ('pml44gcca6oq4knpfcu0ajc6trltknra', '212.70.118.68', '1695803011', '__ci_last_regenerate|i:1695803011;'), ('i3di30olggdch5kitns35lhp6piaktiu', '212.70.118.68', '1695803018', '__ci_last_regenerate|i:1695803018;'), ('oprttli6b1uo1kpjva1tia6j3c76jebi', '212.70.118.68', '1695803020', '__ci_last_regenerate|i:1695803020;'), ('mppk0j94at1gkmvrmprf4djqnnlo77b9', '212.70.118.68', '1695803020', '__ci_last_regenerate|i:1695803020;'), ('jvs531t6nlgi5d2mak1e8841t490483p', '212.70.118.68', '1695803020', '__ci_last_regenerate|i:1695803020;'), ('h3hbvkhb3jg589k4e0ke2kf14decs4d9', '212.70.118.68', '1695803020', '__ci_last_regenerate|i:1695803020;'), ('t8o9kfcd3ro3308a5sn27gfdh2o0jsra', '212.70.118.68', '1695803020', '__ci_last_regenerate|i:1695803020;'), ('v2feo12t0jl3gci1qd2ma515ae8rnsei', '212.70.118.68', '1695803020', '__ci_last_regenerate|i:1695803020;'), ('378ekpukhrrm57h6rfit6vgjmnirdlj8', '212.70.118.68', '1695803020', '__ci_last_regenerate|i:1695803020;'), ('1re4m98poujc4jll5dpogvivinm5jkh9', '212.70.118.68', '1695803023', '__ci_last_regenerate|i:1695803023;'), ('agj9niinf77frl1au48q30oqorli7erq', '212.70.118.68', '1695803023', '__ci_last_regenerate|i:1695803023;'), ('v1jq7uut5p9rveuv0ctgul45hh4r7ioc', '212.70.118.68', '1695803023', '__ci_last_regenerate|i:1695803023;'), ('go358bbd4j5te65fba2m5suj47t3omiu', '212.70.118.68', '1695803023', '__ci_last_regenerate|i:1695803023;'), ('prj4vua8pdv0ve3anb1dpnfgse5r1s1e', '212.70.118.68', '1695803023', '__ci_last_regenerate|i:1695803023;'), ('giniqp5vmmsm14id6c3mvc5fpvquqou8', '103.67.157.231', '1695803055', '__ci_last_regenerate|i:1695803055;'), ('daolsmr5vhplc86icc3ja8fhlophlplv', '103.67.157.231', '1695803058', '__ci_last_regenerate|i:1695803058;'), ('ja5t7t6b0ka6iuqricqufgvgcl77189t', '103.67.157.231', '1695803058', '__ci_last_regenerate|i:1695803058;'), ('3nok2mcg4bg97lt2hv8dmnppvvp8hr5d', '103.67.157.231', '1695803058', '__ci_last_regenerate|i:1695803058;'), ('g1q71ph8qdijrvgset22vgca5dgn2vi9', '103.67.157.231', '1695803058', '__ci_last_regenerate|i:1695803058;'), ('3jp8nujgume7lribi360o9vlt1gkod5v', '103.67.157.231', '1695803058', '__ci_last_regenerate|i:1695803058;'), ('41svn1pc4qornaa46jpfs1i1rlv8225t', '103.67.157.231', '1695803058', '__ci_last_regenerate|i:1695803058;'), ('u97cmt7llrrh6l2ructkt723k0nkq0gg', '103.67.157.231', '1695803059', '__ci_last_regenerate|i:1695803059;'), ('djs2v58vb0flks95o4d2dpnp10qscq11', '103.67.157.231', '1695803070', '__ci_last_regenerate|i:1695803070;'), ('too9efrrupgup5dhhhtd0bdjpt28kfrm', '103.67.157.231', '1695803071', '__ci_last_regenerate|i:1695803071;'), ('ja41d04th6g64cirohv05tug5i5lrrqv', '103.67.157.231', '1695803071', '__ci_last_regenerate|i:1695803071;'), ('8ci1dmpa3vhcothsorpgo879ipr6bmpa', '103.67.157.231', '1695803071', '__ci_last_regenerate|i:1695803071;'), ('qt3jt5fqpdqjm96kv3sep2tg58ja4as7', '103.67.157.231', '1695803071', '__ci_last_regenerate|i:1695803071;'), ('t7iotf7dfrvhbors63f9avl6k72grau8', '103.67.157.231', '1695803071', '__ci_last_regenerate|i:1695803071;'), ('csfr56omir5h5cvfguao44pkfovggtub', '103.67.157.231', '1695803071', '__ci_last_regenerate|i:1695803071;'), ('33gfh4l7cdf7sh6u8qvff5dojfm0ke4q', '103.67.157.231', '1695803072', '__ci_last_regenerate|i:1695803072;'), ('e0o4jq0d94npduaa5k46ism80i76qhlf', '103.67.157.231', '1695803074', '__ci_last_regenerate|i:1695803074;'), ('sfq8h7qq8iskuhndr583tkiubpnthsn1', '103.67.157.231', '1695803074', '__ci_last_regenerate|i:1695803074;'), ('nm1epk34qm1hticj8ag21otukrrt8t0c', '103.67.157.231', '1695803074', '__ci_last_regenerate|i:1695803074;'), ('7ki079ki3b7tbmrdtk5aa0oh5cggfr2r', '103.67.157.231', '1695803074', '__ci_last_regenerate|i:1695803074;'), ('7ec76ks7hddf2n4fk7ksm3uentf6cq40', '103.67.157.231', '1695803074', '__ci_last_regenerate|i:1695803074;'), ('io33h4c7pqfg2t2giihetlgn8dp1q75d', '103.67.157.231', '1695803077', '__ci_last_regenerate|i:1695803077;'), ('hi2jrc68mpnnm6nsa7hsdjta9nfqf3v3', '103.67.157.231', '1695803077', '__ci_last_regenerate|i:1695803077;'), ('ro8o96jqd249db4r7251jm91hdh3mfh1', '103.67.157.231', '1695803077', '__ci_last_regenerate|i:1695803077;'), ('jn67g7adklr1s99h8q4j7u5bu49c78hj', '103.67.157.231', '1695803077', '__ci_last_regenerate|i:1695803077;'), ('ddskidef6rgaoutotojeae4sicq68rgm', '103.67.157.231', '1695803077', '__ci_last_regenerate|i:1695803077;'), ('l9jvchn7r2gtivkk6hihh39m70erl4tm', '103.67.157.231', '1695803077', '__ci_last_regenerate|i:1695803077;'), ('g4bv02pv6hmakf6kfklfduk8881g0rt6', '103.67.157.231', '1695803078', '__ci_last_regenerate|i:1695803078;'), ('52ilipon1g5gjsvei0n8sm7gt9pnmh0m', '103.67.157.231', '1695803089', '__ci_last_regenerate|i:1695803089;'), ('vnm9m6svdts86cjd8qkc2b2dm8l3na1d', '212.70.118.68', '1695803096', '__ci_last_regenerate|i:1695803096;'), ('n34aibkfs4hdicvr1gabkfljbvru4gh8', '212.70.118.68', '1695803096', '__ci_last_regenerate|i:1695803096;'), ('e6jaij6ajn6sgumc22cm9pnntb35mciv', '212.70.118.68', '1695803096', '__ci_last_regenerate|i:1695803096;'), ('caoogga2c7lgg72javpn1h787pi6h94l', '212.70.118.68', '1695803096', '__ci_last_regenerate|i:1695803096;'), ('ac8oqcsaavh7mu66lr78ths2s6bgdkrj', '212.70.118.68', '1695803096', '__ci_last_regenerate|i:1695803096;'), ('7ddm7pcjk8fjg5l5v9pr44r0e9kjs0el', '212.70.118.68', '1695803096', '__ci_last_regenerate|i:1695803096;'), ('kv4aift2904tvjsum6e46nfltnadlfi8', '212.70.118.68', '1695803096', '__ci_last_regenerate|i:1695803096;'), ('ub02umc15u3h2faj4oppdbn6kddslde9', '212.70.118.68', '1695803100', '__ci_last_regenerate|i:1695803100;'), ('schebivo8aorpbht98drto6cbbl587nr', '212.70.118.68', '1695803100', '__ci_last_regenerate|i:1695803100;'), ('qlhsh035863thf6asfqrieskpodu2oba', '212.70.118.68', '1695803100', '__ci_last_regenerate|i:1695803100;'), ('i77jjf7uo5b2lc01q7f2ug6j8ndi3v2r', '212.70.118.68', '1695803100', '__ci_last_regenerate|i:1695803100;'), ('ttlht29ti1n09ukmj06kv0ih2rg0s23k', '212.70.118.68', '1695803100', '__ci_last_regenerate|i:1695803100;'), ('rmhj7c5i22qmcjgdmns73jb7i8llalgn', '212.70.118.68', '1695803100', '__ci_last_regenerate|i:1695803100;'), ('saf7cgf3chg6veiuqeajdq4rad2rgqd4', '212.70.118.68', '1695803154', '__ci_last_regenerate|i:1695803154;'), ('28futoivlrt3lm8famk325gegcb1qti5', '212.70.118.68', '1695803185', '__ci_last_regenerate|i:1695803185;'), ('8faef2bv8u9t56fs774c6hkpqf35sdgh', '103.67.157.231', '1695804164', '__ci_last_regenerate|i:1695804164;'), ('trn58t7tt4s8r6a4bsf3udatbhh4r0hb', '103.67.157.231', '1695804168', '__ci_last_regenerate|i:1695804168;'), ('fc170661algrng9o5179tm2vs0v2hct9', '103.67.157.231', '1695804168', '__ci_last_regenerate|i:1695804168;'), ('0h3gojr85av5qk1g0fhv5j8276jidur3', '103.67.157.231', '1695804168', '__ci_last_regenerate|i:1695804168;'), ('t9a32t1fq0b03ilnbio76ehvgr61gfn4', '103.67.157.231', '1695804168', '__ci_last_regenerate|i:1695804168;'), ('o9rh9a2qehcgmhss29v5etlam9rolrfk', '103.67.157.231', '1695804168', '__ci_last_regenerate|i:1695804168;'), ('q8vfdq570nv0l4523r7uudn5352musik', '103.67.157.231', '1695804168', '__ci_last_regenerate|i:1695804168;'), ('0dtmcvcurd48moic92fq3uik95fj9nb0', '103.67.157.231', '1695804168', '__ci_last_regenerate|i:1695804168;'), ('du3nn94rguhsqi3qthl0stt92o445bu0', '103.67.157.231', '1695804176', '__ci_last_regenerate|i:1695804176;'), ('t2eri1g9gfnmaffrtjegtm76n46trhov', '103.67.157.231', '1695804177', '__ci_last_regenerate|i:1695804177;'), ('tnhcs0if8n1mp2k76c313tcv6bt992i1', '103.67.157.231', '1695804177', '__ci_last_regenerate|i:1695804177;'), ('cvdj556h9bmmuqb3e7lek0jtbgimh72f', '103.67.157.231', '1695804177', '__ci_last_regenerate|i:1695804177;'), ('aj3c2vn88b9nj3idkm281cem4g27ohhb', '103.67.157.231', '1695804177', '__ci_last_regenerate|i:1695804177;'), ('hc8ede99ihnb57215fkcn651ank198s8', '103.67.157.231', '1695804177', '__ci_last_regenerate|i:1695804177;'), ('90ehoeolcb7626r2t938r7tupuukbci0', '103.67.157.231', '1695804177', '__ci_last_regenerate|i:1695804177;'), ('hbk7dmqtk6fkj17fdpp0knfs929b863a', '103.67.157.231', '1695804177', '__ci_last_regenerate|i:1695804177;'), ('ipjcp7v7e9inmikktrs50hb0rul8tpn6', '103.67.157.231', '1695804219', '__ci_last_regenerate|i:1695804219;'), ('c6lhvsipoem5d1o6tqecjkscqjf5eok0', '103.67.157.231', '1695804219', '__ci_last_regenerate|i:1695804219;'), ('2o48juf5o4nhrfd0a5vqqero83shim9q', '103.67.157.231', '1695882190', '__ci_last_regenerate|i:1695804219;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1696746124;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('lpoo6kijgvcb709kccfc31g51jitca0k', '103.67.157.231', '1695804226', '__ci_last_regenerate|i:1695804226;'), ('cd8aha2h3f89e84n899tdekvlfmk6hk0', '103.67.157.231', '1695804227', '__ci_last_regenerate|i:1695804227;'), ('1odbfteg0t8ogthvnhe29q3ida6lj3ft', '103.67.157.231', '1695804228', '__ci_last_regenerate|i:1695804228;'), ('ep9sd5vjkigo6lrg3alsdbou7itmmrev', '103.67.157.231', '1695804228', '__ci_last_regenerate|i:1695804228;'), ('m9aer8c0h42olgu288j3tsd4geigfuu2', '103.67.157.231', '1695804228', '__ci_last_regenerate|i:1695804228;'), ('sj9ght5fp9mkj9grqpoh1o8krvg296a3', '103.67.157.231', '1695804228', '__ci_last_regenerate|i:1695804228;'), ('ompb10a7u890sc2h6808dpooalel4t9o', '103.67.157.231', '1695804228', '__ci_last_regenerate|i:1695804228;'), ('fg3k8fn9807amj91aeaj7n7rrslq47lt', '103.67.157.231', '1695804228', '__ci_last_regenerate|i:1695804228;'), ('hjiorrngj03vc9vk5qi894tj5o35r66h', '103.67.157.231', '1695804228', '__ci_last_regenerate|i:1695804228;'), ('vuib7gja3rj08m6hasiqrpo0on30mdtl', '103.67.157.231', '1695804232', '__ci_last_regenerate|i:1695804232;'), ('j868d6959ehk1kq9jc5tbfqs3rb93sp9', '103.67.157.231', '1695804232', '__ci_last_regenerate|i:1695804232;'), ('8ocgfq8m4a8klnaf1bq94ijh98fefu98', '103.67.157.231', '1695804233', '__ci_last_regenerate|i:1695804233;'), ('viucp33hm5pdgd5nselm47rurguh5j0v', '103.67.157.231', '1695804233', '__ci_last_regenerate|i:1695804233;'), ('ur8hffv5lgrk30u0s4t902tgm6m9elrh', '103.67.157.231', '1695804233', '__ci_last_regenerate|i:1695804233;'), ('oku15vfo1vu97gkakr324bacro2avgbk', '103.67.157.231', '1695804233', '__ci_last_regenerate|i:1695804233;'), ('voh71fh5qvlt1h2q30gomn2eej9pdovv', '103.67.157.231', '1695804233', '__ci_last_regenerate|i:1695804233;'), ('h6jvjkr47guq5qmsuv46cvkqverdcmc4', '103.67.157.231', '1695804233', '__ci_last_regenerate|i:1695804233;'), ('95n4kqivn000ht134vkfs57n3iitup5q', '103.67.157.231', '1695804234', '__ci_last_regenerate|i:1695804234;'), ('21f42pgg3tv1jq2bijqelg7g2bs6m8pi', '103.67.157.231', '1695804234', '__ci_last_regenerate|i:1695804234;'), ('51btupc04eo617avqq8ck1esn2v377d0', '103.67.157.231', '1695804234', '__ci_last_regenerate|i:1695804234;'), ('isdvd7dvabnkdl59smsp26orqmnrfc8o', '103.67.157.231', '1695804234', '__ci_last_regenerate|i:1695804234;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('b03te9dc0ehdk8p7getebnu4ii26o8nq', '103.67.157.231', '1695804236', '__ci_last_regenerate|i:1695804236;'), ('sh3rn0hn368dqurlphmmi0tdtrso1nl6', '103.67.157.231', '1695804241', '__ci_last_regenerate|i:1695804241;'), ('l9iu36jjbbv32gr45ft94hloku80cckg', '37.111.218.238', '1695809064', '__ci_last_regenerate|i:1695809064;'), ('nsjdvdkb6e5rcnpfukbrtpmkcb7o1ajk', '37.111.218.238', '1695809067', '__ci_last_regenerate|i:1695809067;'), ('h1vpu5qj71uavolb4c1ulf0ah39gmege', '37.111.218.238', '1695809067', '__ci_last_regenerate|i:1695809067;'), ('bn3erk6etmmitgu2uiv8evd2n3lliu99', '37.111.218.238', '1695809067', '__ci_last_regenerate|i:1695809067;'), ('tgr85khksknq3itrhv17jbihsnb971qm', '37.111.218.238', '1695809067', '__ci_last_regenerate|i:1695809067;'), ('4gg4f9aaukr05rl44tgt7i0kuedjqonq', '37.111.218.238', '1695809067', '__ci_last_regenerate|i:1695809067;'), ('tcogdntjkpvke8sip0ql5n0oo4s4oto8', '37.111.218.238', '1695809068', '__ci_last_regenerate|i:1695809068;'), ('1p3nc4rt8g3juevfhj4qg076rngjl90g', '37.111.218.238', '1695809068', '__ci_last_regenerate|i:1695809068;'), ('9f0hor8ncklf0ujltm4rrmne6dtja6tj', '37.111.218.238', '1695809087', '__ci_last_regenerate|i:1695809087;'), ('u7nvj2lp4vh5va1rnbcqp9osk5m3uck3', '37.111.218.238', '1695809087', '__ci_last_regenerate|i:1695809087;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('u6cf5038ss4q8vqrg74qkv6nsnrkas5p', '37.111.218.238', '1695809088', '__ci_last_regenerate|i:1695809088;'), ('1vg63obrae8165966ltfc695bt5pii3p', '37.111.218.238', '1695809108', '__ci_last_regenerate|i:1695809108;'), ('66uge70ankn9ibfhglqb81fbh67frkai', '37.111.218.238', '1695809109', '__ci_last_regenerate|i:1695809109;'), ('onki85k2qt85t1ltaak2hlqnegq157pm', '37.111.218.238', '1695809112', '__ci_last_regenerate|i:1695809112;'), ('0screb5q3claffhgc1c5dl6jmkfu5liu', '37.111.218.238', '1695809112', '__ci_last_regenerate|i:1695809112;'), ('tdp5hkjtcdgnc9mchonsmins69r3lgl6', '37.111.218.238', '1695809112', '__ci_last_regenerate|i:1695809112;'), ('qat7751o2hnne1v6v949loelrmhkt9m0', '37.111.218.238', '1695809112', '__ci_last_regenerate|i:1695809112;'), ('ckdbd86f095iu1fvmc30aarui77auile', '37.111.218.238', '1695809113', '__ci_last_regenerate|i:1695809113;'), ('8hntc061ia4eh9jums97km3fdf13ssru', '37.111.218.238', '1695809116', '__ci_last_regenerate|i:1695809116;'), ('kvkp5doh96028t6v8ho70gtgv40j2cmb', '37.111.218.238', '1695809121', '__ci_last_regenerate|i:1695809121;'), ('8dkj83gkrteij02srlptpvkdt0sv6jph', '37.111.218.238', '1695809122', '__ci_last_regenerate|i:1695809122;'), ('4428jj2lks6prar24c1k3pv0vd5mg9m2', '37.111.218.238', '1695809122', '__ci_last_regenerate|i:1695809122;'), ('7sj20kvlhvdugi5o3hmpvipr78jsp0cv', '37.111.218.238', '1695809122', '__ci_last_regenerate|i:1695809122;'), ('ntv5hq939l23k7h56rjc3hr4vg967mmn', '37.111.218.238', '1695809122', '__ci_last_regenerate|i:1695809122;'), ('3l5g5q2dataegmfkntberegsqgsui5hd', '37.111.218.238', '1695809122', '__ci_last_regenerate|i:1695809122;'), ('qtd4hp14e2gojib9b4ig2ov3ni7t6hs5', '37.111.218.238', '1695809123', '__ci_last_regenerate|i:1695809123;'), ('6npgbj2leeke8bt7fofr7ukjqa5738q6', '37.111.218.238', '1695809123', '__ci_last_regenerate|i:1695809123;'), ('5vhp1fgmh55actj02b3524thh9mn4scb', '37.111.218.238', '1695809133', '__ci_last_regenerate|i:1695809133;'), ('bspiin28rvrqn5uo6mi59mpb6sm3p9l5', '37.111.218.238', '1695809133', '__ci_last_regenerate|i:1695809133;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('l216usc0dkbha8csi0av8h5ssscusi9m', '37.111.218.238', '1695809134', '__ci_last_regenerate|i:1695809134;'), ('r7vbehv6abmgur1ekrlf3o2jha6n7q50', '37.111.218.238', '1695809137', '__ci_last_regenerate|i:1695809137;'), ('tp3rbc3d18fggkapjfdt4bflmchkme1a', '37.111.218.238', '1695809137', '__ci_last_regenerate|i:1695809137;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('8kan40q1b2qm6r8dqopbbcamecjos46v', '37.111.218.238', '1695809137', '__ci_last_regenerate|i:1695809137;'), ('22l698nu3gsipmpgaq2q5fmqhhqt55f2', '103.253.46.181', '1695828488', '__ci_last_regenerate|i:1695828488;'), ('v1u2aj3rkp45jjcape4e8f14da0ulern', '103.253.46.181', '1695828491', '__ci_last_regenerate|i:1695828491;'), ('o0onom8skei7mpv657n5s4la88uvfnlc', '103.253.46.181', '1695828491', '__ci_last_regenerate|i:1695828491;'), ('fnj4fd425p6sn2mq9fkc60g1aroprddl', '103.253.46.181', '1695828491', '__ci_last_regenerate|i:1695828491;'), ('5p7ato57tvcaoiooab28h35gs2ulaevm', '103.253.46.181', '1695828491', '__ci_last_regenerate|i:1695828491;'), ('haqt1osd80cn7nb779jdudndvhabukrr', '103.253.46.181', '1695828491', '__ci_last_regenerate|i:1695828491;'), ('ffgfs8m8ao6b807lasm8fjrqqhnm50ic', '103.253.46.181', '1695828491', '__ci_last_regenerate|i:1695828491;'), ('vf7okkgoe0lo4tbl3ltlugtnfkh81np0', '103.253.46.181', '1695828492', '__ci_last_regenerate|i:1695828492;'), ('nphosvgss1nvulbpt9211t5041mcf9rb', '103.253.46.181', '1695828496', '__ci_last_regenerate|i:1695828496;'), ('vpace58i1acsinc7rdtcamudq3q0nl24', '103.253.46.181', '1695828505', '__ci_last_regenerate|i:1695828505;'), ('ovee76dn1n78t8jp4ig0jbv2cseg9ltn', '103.253.46.181', '1695828505', '__ci_last_regenerate|i:1695828505;'), ('2se7pm1ohvhmn22s064vt0o410dlel49', '103.253.46.181', '1695828506', '__ci_last_regenerate|i:1695828506;'), ('gfaofcop4uekqehsnboqoo6f4c8krnt2', '103.253.46.181', '1695828506', '__ci_last_regenerate|i:1695828506;'), ('pv1j7tudt57t56dvogaq2hkoehbp0nbq', '103.253.46.181', '1695828506', '__ci_last_regenerate|i:1695828506;'), ('q8g1qnvqck0oea52r225cub8njlb247g', '103.253.46.181', '1695828506', '__ci_last_regenerate|i:1695828506;'), ('0usmq9pngnahsg5ullka4tkvmkthc0sp', '103.253.46.181', '1695828506', '__ci_last_regenerate|i:1695828506;'), ('30rdv66tab2u0qmgkhe31ho6qb678opn', '103.253.46.181', '1695828506', '__ci_last_regenerate|i:1695828506;'), ('i4omdmcopr4pciji3epjgpineoj7mu2h', '103.253.46.181', '1695829041', '__ci_last_regenerate|i:1695829041;'), ('lea2qe3eskdoljp2pfnvbhej694u7h6c', '103.253.46.181', '1695829041', '__ci_last_regenerate|i:1695829041;'), ('tbci00d631j2tcp1q705l30030ciavhc', '103.253.46.181', '1695829053', '__ci_last_regenerate|i:1695829053;'), ('vil5ca215kqdopridn73r545eriq0buq', '103.253.46.181', '1695829053', '__ci_last_regenerate|i:1695829053;'), ('poolkb9tftfvu5bnm7pfkekrd8ms0ptb', '103.253.46.181', '1695829053', '__ci_last_regenerate|i:1695829053;'), ('vu70pr1o8uq04m3tiens942omtq5nc4l', '103.253.46.181', '1695829053', '__ci_last_regenerate|i:1695829053;'), ('dh2d9r8tn7rumsrrh9o8il5ird0fokhk', '103.253.46.181', '1695829053', '__ci_last_regenerate|i:1695829053;'), ('km8jgpl9j4c47cv3dhm0mk1kqpko2jt6', '103.253.46.181', '1695829054', '__ci_last_regenerate|i:1695829054;'), ('kksmqtbd7unume066hk9h0r5781fkm9h', '103.253.46.181', '1695829057', '__ci_last_regenerate|i:1695829057;'), ('hjlgdfbbde0srlsm52bb3i8tj8dk7bmi', '103.253.46.181', '1695829111', '__ci_last_regenerate|i:1695829111;'), ('7tmsijp71lbcoeu6rj0f5hgbujagg6cn', '103.253.46.181', '1695829113', '__ci_last_regenerate|i:1695829113;'), ('bd6c9o4nge49137srtmtp3uc55h4o9ii', '103.253.46.181', '1695829113', '__ci_last_regenerate|i:1695829113;'), ('ug0v7fpcr6qbh491u91c65r847na0bh0', '103.253.46.181', '1695829113', '__ci_last_regenerate|i:1695829113;'), ('11e0odjv9cjv2f06qboos1427f5t99ob', '103.253.46.181', '1695829113', '__ci_last_regenerate|i:1695829113;'), ('16h3it6uhf9iq2jemktu1robtq9k8tff', '103.253.46.181', '1695829113', '__ci_last_regenerate|i:1695829113;'), ('7m8vvh0j2hocol0645ftipfn5681ncm1', '103.253.46.181', '1695829114', '__ci_last_regenerate|i:1695829114;'), ('1fkbgrmuclofhjmg356pvns5eoe42ld9', '103.253.46.181', '1695829114', '__ci_last_regenerate|i:1695829114;'), ('9a0m24bkih6an15uu2aoolaa5ap0mg8o', '103.253.46.181', '1695829240', '__ci_last_regenerate|i:1695829240;'), ('vuc11dpq715tl01n8t60bn9u5s9uf5m8', '103.253.46.181', '1695829260', '__ci_last_regenerate|i:1695829260;'), ('qg0ur04rs42tkva1c98ekv0c5vphak8c', '103.253.46.181', '1695829260', '__ci_last_regenerate|i:1695829260;'), ('jn5km3s4j00s4ee1s4uimd5sui4me1n8', '103.253.46.181', '1695829261', '__ci_last_regenerate|i:1695829261;'), ('lti1ad64j3bf70rebi62fjhm46m1cp75', '103.253.46.181', '1695829261', '__ci_last_regenerate|i:1695829261;'), ('8p66emcr3ek3c86pignc90fggfal9pud', '103.253.46.181', '1695829261', '__ci_last_regenerate|i:1695829261;'), ('1g4kr69iggfcbg2070gr41o36e4sm66t', '103.253.46.181', '1695829261', '__ci_last_regenerate|i:1695829261;'), ('o7mkr27c2mqooi2aplog45hi0rjgqpf4', '103.253.46.181', '1695829261', '__ci_last_regenerate|i:1695829261;'), ('bras36a8iu0n0k9t89uj6nis08n66q2v', '103.253.46.181', '1695829261', '__ci_last_regenerate|i:1695829261;'), ('mo3hi7f98l4jguetkqinec55eenhrku3', '103.253.46.181', '1695829263', '__ci_last_regenerate|i:1695829263;'), ('7dqh0gm8ts423i70cb3lbs2rh44ne28t', '103.253.46.181', '1695829284', '__ci_last_regenerate|i:1695829284;'), ('g757cau1jgo9ror88voq39ru7o95ujnl', '103.253.46.181', '1695829284', '__ci_last_regenerate|i:1695829284;'), ('7gt0ipirelkdq3pnadn21jtpkhvgf6eo', '103.253.46.181', '1695829285', '__ci_last_regenerate|i:1695829285;'), ('7nriv683g1b5j023pccs0usd4udsak38', '103.253.46.181', '1695829285', '__ci_last_regenerate|i:1695829285;'), ('3ptgmrbau9juimeh97abtncuf5acpetl', '103.253.46.181', '1695829285', '__ci_last_regenerate|i:1695829285;'), ('dipene5a3n47c92ar82aup2l5jorvf92', '103.253.46.181', '1695829285', '__ci_last_regenerate|i:1695829285;'), ('hd5pdnh4fvn98gm71dk2t1cegrhfl0v7', '103.253.46.181', '1695829285', '__ci_last_regenerate|i:1695829285;'), ('751pn2otq77e25aammnkvqr5hb22uhqf', '103.253.46.181', '1695829285', '__ci_last_regenerate|i:1695829285;'), ('e32vq15feegadrad55p96m465ojsv31i', '103.253.46.181', '1695829286', '__ci_last_regenerate|i:1695829286;'), ('nj8odjusr9lm7p622tlht156dnd3l5a4', '103.253.45.78', '1695829524', '__ci_last_regenerate|i:1695829524;'), ('c9i7nf5icuuaqaldfj9m5rphr759g7eq', '103.253.45.78', '1695829527', '__ci_last_regenerate|i:1695829527;'), ('i5pemcof3osb3uqatv7ol6jom6ot5unb', '103.253.45.78', '1695829527', '__ci_last_regenerate|i:1695829527;'), ('m1l17du25l4djo37j8run985gm7d5ars', '103.253.45.78', '1695829527', '__ci_last_regenerate|i:1695829527;'), ('dkqjcrt8rcgrjra96c7m5dd3c0imm17m', '103.253.45.78', '1695829527', '__ci_last_regenerate|i:1695829527;'), ('lo6akiki1oifsikdh8miierihfh0ubco', '103.253.45.78', '1695829527', '__ci_last_regenerate|i:1695829527;'), ('mo5nbe34ofqnghrnlvujj09e7q3kd1uf', '103.253.45.78', '1695829527', '__ci_last_regenerate|i:1695829527;'), ('32h9cirfvbtk35ogl926oe1q1at1ipps', '103.253.45.78', '1695829528', '__ci_last_regenerate|i:1695829528;'), ('md4og2dd68rojrtdk4e8pusvcvmnb89e', '103.253.45.78', '1695829530', '__ci_last_regenerate|i:1695829530;'), ('fs4s0j5rehnn12dabhuvakbla3n2talf', '103.253.45.78', '1695829538', '__ci_last_regenerate|i:1695829538;'), ('5isj7m0eqfkm0kjjhr2h4q18rtkqb7vq', '103.253.45.78', '1695829538', '__ci_last_regenerate|i:1695829538;'), ('7826o3t5in5258tid0p99v1k0bqt3uvk', '103.253.45.78', '1695829539', '__ci_last_regenerate|i:1695829539;'), ('tlhe277jsgo4o4jmca3qmuksrr7t2o1o', '103.253.45.78', '1695829539', '__ci_last_regenerate|i:1695829539;'), ('7o676f31a4ml8j10m4bv8poin5s6aocl', '103.253.45.78', '1695829539', '__ci_last_regenerate|i:1695829539;'), ('5e1pnjjnls9h8nvjgo5oafk96ika48q8', '103.253.45.78', '1695829539', '__ci_last_regenerate|i:1695829539;'), ('6993thdpt0nn7uoaah009qlq9onqbls4', '103.253.45.78', '1695829539', '__ci_last_regenerate|i:1695829539;'), ('ujujdh7gv7ieaj2mjphpbi30087leqcf', '103.253.45.78', '1695829539', '__ci_last_regenerate|i:1695829539;'), ('su4mqm34sk7qqsfe526s4vubh0bo7prr', '103.253.45.78', '1695829851', '__ci_last_regenerate|i:1695829851;'), ('5ea0vnm95hjkvl5hrt5hgofvl993v5e0', '103.253.45.78', '1695829851', '__ci_last_regenerate|i:1695829851;'), ('02pn3ans0pf1bc5uiikg036sg587fdnh', '103.253.45.78', '1695829857', '__ci_last_regenerate|i:1695829857;'), ('pvikegaohj4fp7p0n8m543g1qg1g8ft2', '103.253.45.78', '1695829858', '__ci_last_regenerate|i:1695829858;'), ('fkgms8300uiv2j6bm094c80ad4i33tdr', '103.253.45.78', '1695829858', '__ci_last_regenerate|i:1695829858;'), ('9f30f7q4bd9of95qg2g5umjli258uidl', '103.253.45.78', '1695829858', '__ci_last_regenerate|i:1695829858;'), ('rokl97vud6dk7b6urge6actdsi91th4f', '103.253.45.78', '1695829858', '__ci_last_regenerate|i:1695829858;'), ('qsrn5crp2s60qjb9p2rhlaq3om0m60o6', '103.253.45.78', '1695829858', '__ci_last_regenerate|i:1695829858;'), ('2nps83r978dsha3ao2j54ogbaj2ta51n', '103.253.45.78', '1695829858', '__ci_last_regenerate|i:1695829858;'), ('5h6v0qhdmbp2t2026nfdg5kksgjkbedg', '103.253.45.78', '1695829859', '__ci_last_regenerate|i:1695829859;'), ('lmt76kafi0c258dstb5rk4i3fm4h6d7v', '103.253.45.78', '1695829860', '__ci_last_regenerate|i:1695829860;'), ('p9gai4g7945mltpkhnvdolbukfp0fhic', '103.253.45.78', '1695829861', '__ci_last_regenerate|i:1695829861;'), ('n0okblid69qesf288ghhik79rne2s4fg', '103.253.45.78', '1695829861', '__ci_last_regenerate|i:1695829861;'), ('ip00obj1d3c1a3p61j1f5po8u6h29dv5', '103.253.45.78', '1695829861', '__ci_last_regenerate|i:1695829861;'), ('8o2odu8274koojq8ikkgqddg5mg110v4', '103.253.45.78', '1695829861', '__ci_last_regenerate|i:1695829861;'), ('t5c8tc7ghgvfq4kjdv14l7841arfudrb', '103.253.45.78', '1695829861', '__ci_last_regenerate|i:1695829861;'), ('ursijc1u2c1foes618mlp1r8m3u1vn5o', '103.253.45.78', '1695829861', '__ci_last_regenerate|i:1695829861;'), ('g22l2e835r9md8gij3136u4jvkmgv187', '103.253.45.78', '1695829862', '__ci_last_regenerate|i:1695829862;'), ('0uro12qqlqavaimufi6vsv63mqd3jhqp', '103.253.45.78', '1695829862', '__ci_last_regenerate|i:1695829862;'), ('2v5ln216b4l9qo85pp1njdlk3ljchecn', '103.253.45.78', '1695829888', '__ci_last_regenerate|i:1695829888;'), ('088grjugc7rab00pbv8sts4l0lo15hkr', '103.253.45.78', '1695829891', '__ci_last_regenerate|i:1695829891;'), ('bj1pee35ich270cd23e5ci914tj17hk1', '103.253.45.78', '1695829891', '__ci_last_regenerate|i:1695829891;'), ('92oo6mn1ehsf7v4c12jtpk0m1v4grc5m', '103.253.45.78', '1695829891', '__ci_last_regenerate|i:1695829891;'), ('065nk0la8s9pt7qnvahgihmbj6a91tp2', '103.253.45.78', '1695829891', '__ci_last_regenerate|i:1695829891;'), ('oc14p76utlqt7p237alctnkqt8esiqt9', '103.253.45.78', '1695829892', '__ci_last_regenerate|i:1695829892;'), ('t4a54r12opp1d6nturekc1t71e2439fh', '103.253.45.78', '1695829892', '__ci_last_regenerate|i:1695829892;'), ('ta9gjsu207gqdk5sq8upg0d55e350qte', '103.253.45.78', '1695829892', '__ci_last_regenerate|i:1695829892;'), ('t8660jforpmi9fc71stl1nlitqi0q4pu', '103.253.45.78', '1695829893', '__ci_last_regenerate|i:1695829893;'), ('2ql4aur182a9bqp1c8f7m4mmuff31fr6', '103.253.45.78', '1695830267', '__ci_last_regenerate|i:1695830267;'), ('7q0sdtdn2bu8mnluf4a8oi4uhij2qh17', '103.253.45.78', '1695830270', '__ci_last_regenerate|i:1695830270;'), ('t4bvporl0kogiv1quj2q41c1t1990m03', '103.253.45.78', '1695830270', '__ci_last_regenerate|i:1695830270;'), ('du7lctu90up61m5hqlm5087ojnvoc5dj', '103.253.45.78', '1695830270', '__ci_last_regenerate|i:1695830270;'), ('81u6o5nmef1o074sbkim8rag1ut7mucc', '103.253.45.78', '1695830270', '__ci_last_regenerate|i:1695830270;'), ('078k76ecp2uful9bohf4pp23qss8b2a8', '103.253.45.78', '1695830270', '__ci_last_regenerate|i:1695830270;'), ('pche9d9j5l83i27e9srofqbgjls3lh8u', '103.253.45.78', '1695830270', '__ci_last_regenerate|i:1695830270;'), ('0p4kgtguk1eod8nb5u7mjc1mmn4v404g', '103.253.45.78', '1695830270', '__ci_last_regenerate|i:1695830270;'), ('tn528fn5a5kegjehp651g9s3do0qhv3o', '103.253.45.78', '1695830280', '__ci_last_regenerate|i:1695830280;'), ('n0fhcbocmpanjasu42d4klv94dki0hl7', '103.253.45.78', '1695830301', '__ci_last_regenerate|i:1695830301;'), ('94a0lmts3d3qbpr8f9isc5gc2q49i9ja', '103.253.45.78', '1695830301', '__ci_last_regenerate|i:1695830301;'), ('vq7v1tg17qltordvuik5bveu355hf0n3', '103.253.45.78', '1695830302', '__ci_last_regenerate|i:1695830302;'), ('9hfrj85p78i4kfrmreou9lr955aur90f', '103.253.45.78', '1695830302', '__ci_last_regenerate|i:1695830302;'), ('jfdii7vfpjr3hn3tl9nmt1kqfs16cm1d', '103.253.45.78', '1695830302', '__ci_last_regenerate|i:1695830302;'), ('viq3dn9jl8ggcrurpid9t7tirg6dgmod', '103.253.45.78', '1695830302', '__ci_last_regenerate|i:1695830302;'), ('b41s9g6rmgcrmlp0rmvr1729v0bv21pf', '103.253.45.78', '1695830302', '__ci_last_regenerate|i:1695830302;'), ('rvpvlvotrrsagagbcgm4dktcnb32clsi', '103.253.45.78', '1695830303', '__ci_last_regenerate|i:1695830303;'), ('1k6osit1c8jqt80mfbe9sgsdgdgnga4t', '103.253.45.78', '1695830303', '__ci_last_regenerate|i:1695830303;'), ('jsp0pte4bbqdecjbl0qpoj22mbjf7gsu', '103.253.45.78', '1695830312', '__ci_last_regenerate|i:1695830312;'), ('m59ikqnq7u41anjdoioj3f8e2he7b6i0', '103.253.45.78', '1695830312', '__ci_last_regenerate|i:1695830312;'), ('g2irkdbfg7rjrlvoldm76sanjdrv8svv', '103.253.45.78', '1695830312', '__ci_last_regenerate|i:1695830312;'), ('5u3ck6m9guia4cnmp4i947o9pv0fjkm8', '103.253.45.78', '1695830312', '__ci_last_regenerate|i:1695830312;'), ('saqhm2pc4jt0tfkkit33t6ho77lk43na', '103.253.45.78', '1695830312', '__ci_last_regenerate|i:1695830312;'), ('acfa2ga0t58gvll9dggt5lkiqvsaill0', '103.253.45.78', '1695830312', '__ci_last_regenerate|i:1695830312;'), ('h025ost57fm1hhinabrl9nhjd13plv5s', '103.253.45.78', '1695830313', '__ci_last_regenerate|i:1695830313;'), ('i43jsijktkvcvgvug860lor61tkqhmjh', '103.253.45.78', '1695830329', '__ci_last_regenerate|i:1695830329;'), ('8a8snmcqdi49tdk2a7sfp2vhvul2b1pv', '103.253.45.78', '1695830329', '__ci_last_regenerate|i:1695830329;'), ('qebegmo0ohqns940j6ttc7e6oohn5h86', '103.253.45.78', '1695830329', '__ci_last_regenerate|i:1695830329;'), ('rrpffnqv3rihrl1l6bv6doanjt58kkdc', '103.253.45.78', '1695830330', '__ci_last_regenerate|i:1695830330;'), ('t2ocpovunr3917aefcccof20su1h35nl', '103.253.45.78', '1695830331', '__ci_last_regenerate|i:1695830331;'), ('0b6eisus4qumh5ber4cascpan4uaeg33', '103.253.45.78', '1695830339', '__ci_last_regenerate|i:1695830339;'), ('pbqfjn3vevcavr5c0k4r9m6sket780em', '103.253.45.78', '1695830340', '__ci_last_regenerate|i:1695830340;'), ('edj7qvkma1p0kh3q437ic572tpvls1vn', '103.253.45.78', '1695830340', '__ci_last_regenerate|i:1695830340;'), ('fmfeccq7b5i4gldv3gkb955v5uehee63', '103.253.45.78', '1695830340', '__ci_last_regenerate|i:1695830340;'), ('ja4im07tqk056q4o962da2rsk6balqf0', '103.253.45.78', '1695830340', '__ci_last_regenerate|i:1695830340;'), ('mgq6q63jkur70o175s8j74asrnsuuudf', '103.253.45.78', '1695830340', '__ci_last_regenerate|i:1695830340;'), ('lhr7hph0ngduefki6vh2pc3olumfd4b7', '103.253.45.78', '1695830341', '__ci_last_regenerate|i:1695830341;'), ('n938j8mebtu2egrjv2spl6lqn8mpjple', '103.253.45.78', '1695830341', '__ci_last_regenerate|i:1695830341;'), ('14vd13veur42l56kr234q473jbvs5d25', '103.253.45.78', '1695830342', '__ci_last_regenerate|i:1695830342;'), ('1j8du7a5bvhh10ssopckaiucf0b90kre', '103.253.45.78', '1695830404', '__ci_last_regenerate|i:1695830404;'), ('90c6ka0tltmkcu8ts3emcvn8p9f2lhej', '103.253.45.78', '1695830407', '__ci_last_regenerate|i:1695830407;'), ('g0o60hk5dtcmmqfa16jc3ldh404e431l', '103.253.45.78', '1695830407', '__ci_last_regenerate|i:1695830407;'), ('e799qkp659rce32a60nph5ph4mcjihbr', '103.253.45.78', '1695830407', '__ci_last_regenerate|i:1695830407;'), ('p98pgj80s1p4ktnlsop7tdid55mtnrs8', '103.253.45.78', '1695830407', '__ci_last_regenerate|i:1695830407;'), ('6bl2mlqg6mpfhdpjg0d43gcdebd77spp', '103.253.45.78', '1695830407', '__ci_last_regenerate|i:1695830407;'), ('qb3jv66q1e42mjsogjpeplsj88gd3h3l', '103.253.45.78', '1695830407', '__ci_last_regenerate|i:1695830407;'), ('pp5ggje2k3iflkg6ri17vfplpefa5eia', '103.253.45.78', '1695830407', '__ci_last_regenerate|i:1695830407;'), ('enbe5571r065knum4l7hqdf7k4cm9jhp', '103.253.45.78', '1695830411', '__ci_last_regenerate|i:1695830411;'), ('lu9td9m5fj0n0544f8310tnovlmuepm5', '103.253.45.78', '1695830414', '__ci_last_regenerate|i:1695830414;'), ('r81u1ehj0cruv02tr4hbnblmupa3ngaq', '103.253.45.78', '1695830414', '__ci_last_regenerate|i:1695830414;'), ('01v3445rca4bm77hjj4e8gs32a2kkkh2', '103.253.45.78', '1695830415', '__ci_last_regenerate|i:1695830415;'), ('n6r88d1rkcs33qocmvhl9il4a365lrvc', '103.253.45.78', '1695830415', '__ci_last_regenerate|i:1695830415;'), ('cqlcansoot7mivkrehvg1a5mr3hikvh3', '103.253.45.78', '1695830415', '__ci_last_regenerate|i:1695830415;'), ('jpqi1rql6lfpdcmijkcvav661i5tv4qa', '103.253.45.78', '1695830415', '__ci_last_regenerate|i:1695830415;'), ('550n2sn8nas81f2mjt7q6k8qll43vjcf', '103.253.45.78', '1695830415', '__ci_last_regenerate|i:1695830415;'), ('v20ibptpq5ltdrfv46m9iercf1j41aq6', '103.253.45.78', '1695830415', '__ci_last_regenerate|i:1695830415;'), ('b5ah2u44634tqnmrthhm4iqepf7ghabu', '103.253.45.78', '1695830415', '__ci_last_regenerate|i:1695830415;'), ('c2f4q5i1tn706n0ss8lo1nuqlsvpkcbf', '103.253.45.78', '1695830417', '__ci_last_regenerate|i:1695830417;'), ('91k9beit9s08i8m2dk2vai4fm6iqc2h6', '103.253.45.78', '1695830417', '__ci_last_regenerate|i:1695830417;'), ('v7tvdnes2qk3fligffel27lmq17c7lnk', '103.253.45.78', '1695830418', '__ci_last_regenerate|i:1695830418;'), ('i6ke1o3ui5ainvp97l9fv2pv5rlstb8q', '103.253.45.78', '1695830418', '__ci_last_regenerate|i:1695830418;'), ('7oraupqiicgtvhmh3t882hv3gqggn6pt', '103.253.45.78', '1695830418', '__ci_last_regenerate|i:1695830418;'), ('o5at99icq54fainteeq6momoh0cbnmh2', '103.253.45.78', '1695830418', '__ci_last_regenerate|i:1695830418;'), ('o5r1trompsp1ar33vejgdoi71kvb9pad', '103.253.45.78', '1695830418', '__ci_last_regenerate|i:1695830418;'), ('eujs91otp57qvf5m00kegvmu5rg4l5ut', '103.253.45.78', '1695830418', '__ci_last_regenerate|i:1695830418;'), ('mfrqgrhf3q8k50kp3jb6nqjjet2m6ehm', '103.253.45.78', '1695830419', '__ci_last_regenerate|i:1695830419;'), ('v6k6luqhfn79vhm26ak7ced8h9crs8ji', '103.253.45.78', '1695830422', '__ci_last_regenerate|i:1695830422;'), ('uf1q98kbtot827mjjqtjppvug9fbn7vu', '103.253.45.78', '1695830422', '__ci_last_regenerate|i:1695830422;'), ('p6apar3j1imqv0n0101o29ttqhauo0br', '103.253.45.78', '1695830422', '__ci_last_regenerate|i:1695830422;'), ('m02vd0f7ge8j0c3dsln2e8950ncukcit', '103.253.45.78', '1695830423', '__ci_last_regenerate|i:1695830423;'), ('o79hva0cd7bf7pghltrdmld0ebqd2v4c', '103.253.45.78', '1695830424', '__ci_last_regenerate|i:1695830424;'), ('l08hv710650aie4ijovmqbfd25osjcmi', '103.253.45.78', '1695831210', '__ci_last_regenerate|i:1695831210;'), ('5pcrlftg2jh8l5pupv0tum1cbjjpuhea', '103.253.45.78', '1695831213', '__ci_last_regenerate|i:1695831213;'), ('1q792e51prasfo8388khfqd95v0od0i7', '103.253.45.78', '1695831213', '__ci_last_regenerate|i:1695831213;'), ('jcaqpu4ndqbprs1pfq9psb7fmtf6gm87', '103.253.45.78', '1695831213', '__ci_last_regenerate|i:1695831213;'), ('c59t99ga74f9f87l1egpr5d78fa56ke1', '103.253.45.78', '1695831213', '__ci_last_regenerate|i:1695831213;'), ('5fpu73vlans2d3775sfa7lv5d2k5tf8a', '103.253.45.78', '1695831213', '__ci_last_regenerate|i:1695831213;'), ('fn3gc3jv99d9o8dp4hkjbfd9qj79m8jh', '103.253.45.78', '1695831214', '__ci_last_regenerate|i:1695831214;'), ('2haucb81rks305sunit4kuqstjktl1nv', '103.253.45.78', '1695831215', '__ci_last_regenerate|i:1695831215;'), ('9076uhdj5ou4c633j1suugnbgnua55sp', '103.253.45.78', '1695831225', '__ci_last_regenerate|i:1695831225;'), ('v5mi5720ogc4mdof0m4llv8hos8fhmfc', '103.253.45.78', '1695831226', '__ci_last_regenerate|i:1695831226;'), ('4u1g6o2tbe33uqs009i1jpi94v1lk108', '103.253.45.78', '1695831226', '__ci_last_regenerate|i:1695831226;'), ('uv80rctq7tblcnf5n660hni5fika2vk2', '103.253.45.78', '1695831226', '__ci_last_regenerate|i:1695831226;'), ('euejdah85cptlic50q19ckj61t7n8uvv', '103.253.45.78', '1695831227', '__ci_last_regenerate|i:1695831227;'), ('39u31gvubqjvf3hd8m6b2jg55h375nsi', '103.253.45.78', '1695831227', '__ci_last_regenerate|i:1695831227;'), ('fu71cfdbnh8fabc2asncb8ucc2aov3rm', '103.253.45.78', '1695831227', '__ci_last_regenerate|i:1695831227;'), ('ip2pfa3g16t295358f1in8kbbf6o2tof', '103.253.45.78', '1695831227', '__ci_last_regenerate|i:1695831227;'), ('a7vnlacil5ud09rcleqntfme9oqgje7m', '103.253.45.78', '1695831228', '__ci_last_regenerate|i:1695831228;'), ('760htkao3r5dr3li0a742716ap34f0r5', '103.253.45.78', '1695831228', '__ci_last_regenerate|i:1695831228;'), ('4noi1rbe5vkvq1vc8c5q73nctd1lf57n', '103.253.45.78', '1695831228', '__ci_last_regenerate|i:1695831228;'), ('qd9qrcthvmnp86bt6anpbo1k465f7sa6', '103.253.45.78', '1695831228', '__ci_last_regenerate|i:1695831228;'), ('26sp8lvib61ouhg1gd6fge0e8on8j6qu', '103.253.45.78', '1695831266', '__ci_last_regenerate|i:1695831266;'), ('t4qelo37kmbvttjocivnum2me7161cb3', '103.253.45.78', '1695831269', '__ci_last_regenerate|i:1695831269;'), ('t4nsl1p7i182diq2bqajv3kii1l88b22', '103.253.45.78', '1695831269', '__ci_last_regenerate|i:1695831269;'), ('sog3hdtqequmvba8ho3flm1ooohq9eq5', '103.253.45.78', '1695831269', '__ci_last_regenerate|i:1695831269;'), ('j51bh0c831d64sge4fngg651itcvstuj', '103.253.45.78', '1695831269', '__ci_last_regenerate|i:1695831269;'), ('7b2db712ihnb98kqhgg0qhtuqu80d50r', '103.253.45.78', '1695831269', '__ci_last_regenerate|i:1695831269;'), ('44m4a31fic20ojmls002c764ltpm3s00', '103.253.45.78', '1695831269', '__ci_last_regenerate|i:1695831269;'), ('h0vbugs2tejtbi8u3p4sq28et7tmkffr', '103.253.45.78', '1695831270', '__ci_last_regenerate|i:1695831270;'), ('hridqu4k7lqkjgbp4s3b79kgqdu6np5l', '103.253.45.78', '1695831279', '__ci_last_regenerate|i:1695831279;'), ('pgbgo76ep7npk3hi7oqrba093o4f3c7m', '103.253.45.78', '1695831284', '__ci_last_regenerate|i:1695831284;'), ('ntjfiujvo0p2kko4781d90oah3li31l2', '103.253.45.78', '1695831284', '__ci_last_regenerate|i:1695831284;'), ('pcerl2mu66k0kv8eponpas1skfj6qti4', '103.253.45.78', '1695831284', '__ci_last_regenerate|i:1695831284;'), ('s6qsp8tnso2c89is59tn3aah9f31ls67', '103.253.45.78', '1695831284', '__ci_last_regenerate|i:1695831284;'), ('ducdk4ttj3ha1eebcfmg1cic6hgqsdhe', '103.253.45.78', '1695831284', '__ci_last_regenerate|i:1695831284;'), ('5u1rjfq81h9877r3nu02v2vsdg4v35pk', '103.253.45.78', '1695831285', '__ci_last_regenerate|i:1695831285;'), ('3bg2ai6o3efjvjego8j0ni4k17oebet4', '103.253.45.78', '1695831286', '__ci_last_regenerate|i:1695831286;'), ('bj1dt2mrs989fmueq4mt18htkgbbip0p', '103.253.45.78', '1695834801', '__ci_last_regenerate|i:1695834801;'), ('lot2qlndnd9bbgbi49q72lfocok42c3c', '103.253.45.78', '1695834801', '__ci_last_regenerate|i:1695834801;'), ('1honh1269o9ma7lfko6ns6ok67o4ta02', '103.253.45.78', '1695834802', '__ci_last_regenerate|i:1695834802;'), ('36ap1g1jl3hcjio4s8rfb4at2ehb2q9j', '103.253.45.78', '1695834802', '__ci_last_regenerate|i:1695834802;'), ('pq2bpa9l94ugnedkoq3pepa2ghrlhrdk', '103.253.45.78', '1695834802', '__ci_last_regenerate|i:1695834802;'), ('h81i0o36umed9f08ksivsf2jmqr3kr7b', '103.253.45.78', '1695834802', '__ci_last_regenerate|i:1695834802;'), ('8sa303u8oedef1jrptvqhdqe32m3bji5', '103.253.45.78', '1695834802', '__ci_last_regenerate|i:1695834802;'), ('morh4nkt5dh807eco6n8k9htgun4u025', '103.253.45.78', '1695834802', '__ci_last_regenerate|i:1695834802;'), ('ou843qchljc8anbdjtoh8idpj8hp73kq', '103.253.45.78', '1695834803', '__ci_last_regenerate|i:1695834803;'), ('8hh1u7pg5hr2gdsv2cjvihu70dcl4u9v', '103.253.45.78', '1695835010', '__ci_last_regenerate|i:1695835010;'), ('v5djs1k8g6nns58i6dhvnmk2nl69smfq', '103.253.45.78', '1695835010', '__ci_last_regenerate|i:1695835010;'), ('00meikvjcem9qpu10kj495l9ti0ne4ad', '103.253.45.78', '1695835010', '__ci_last_regenerate|i:1695835010;'), ('u3k9ot32quobufvsqoa1vtmlrn9teihg', '103.253.45.78', '1695835010', '__ci_last_regenerate|i:1695835010;'), ('dmp0flq70092lpjepdam3unb1rg54foe', '103.253.45.78', '1695835011', '__ci_last_regenerate|i:1695835011;'), ('jj0eqco2h2okhqbq22ir38ree1sr4mua', '103.253.45.78', '1695835063', '__ci_last_regenerate|i:1695835063;'), ('94g6illvlfrbkphb1ij69mj4ct3vpta0', '103.253.45.78', '1695835066', '__ci_last_regenerate|i:1695835066;'), ('efb34mtratfsisd450ij85ft6vtf8817', '103.253.45.78', '1695835066', '__ci_last_regenerate|i:1695835066;'), ('tkrm1ph6eaosn2bh8hs15j8jde94ku93', '103.253.45.78', '1695835066', '__ci_last_regenerate|i:1695835066;'), ('ntiaruvr52jn0nsniqn9662nfg37iu4q', '103.253.45.78', '1695835066', '__ci_last_regenerate|i:1695835066;'), ('m41qmcofom7fkoj70tdtnm08v3k3u655', '103.253.45.78', '1695835066', '__ci_last_regenerate|i:1695835066;'), ('jh37o1iun23afkjs44b3c6uqs346qb22', '103.253.45.78', '1695835066', '__ci_last_regenerate|i:1695835066;'), ('kj9in3mpcftgetiof5odsneb2v2rdb3p', '103.253.45.78', '1695835067', '__ci_last_regenerate|i:1695835067;'), ('929t3u396dt1p8m48d08egnukjpi1557', '103.253.45.78', '1695835074', '__ci_last_regenerate|i:1695835074;'), ('7ks6p6fsubkdccdtspki0e07gtvrc3sp', '103.253.45.78', '1695835098', '__ci_last_regenerate|i:1695835098;'), ('bik1jdp74btl3lgo5aklj25kkebh9cgc', '103.253.45.78', '1695835098', '__ci_last_regenerate|i:1695835098;'), ('jjf0upfcc5i9pseni1dk1nchfldjafep', '103.253.45.78', '1695835098', '__ci_last_regenerate|i:1695835098;'), ('db5ars5pcui5daf212pbv8g8ftv55jbp', '103.253.45.78', '1695835099', '__ci_last_regenerate|i:1695835099;'), ('brtvvbubon98rkeueu6sp6skb5vivblu', '103.253.45.78', '1695835108', '__ci_last_regenerate|i:1695835108;'), ('6osoea1aiacsofrn1um615mv646j1u2k', '103.253.45.78', '1695835109', '__ci_last_regenerate|i:1695835109;'), ('qjhgql14ldji7gjaqne3mjdl78a74cvl', '103.253.45.78', '1695835110', '__ci_last_regenerate|i:1695835110;'), ('7vnbri2i1rma6sa5cvvcj68sja8rtbc9', '103.253.45.78', '1695835110', '__ci_last_regenerate|i:1695835110;'), ('jeneneafcpfumdcusf4pvu58e80mg5gh', '103.253.45.78', '1695835110', '__ci_last_regenerate|i:1695835110;'), ('cned6u82uevou0mkoc8ms4ro1qm3p7d4', '103.253.45.78', '1695835110', '__ci_last_regenerate|i:1695835110;'), ('mcu03bq9ubl72mhhohk45112dfq01vbn', '103.253.45.78', '1695835110', '__ci_last_regenerate|i:1695835110;'), ('u62jq5abinq88i09l9k30kg3j3btmht7', '103.253.45.78', '1695835110', '__ci_last_regenerate|i:1695835110;'), ('av4r37d41biif6dncar9kbsc9fjalp0s', '103.253.45.78', '1695835110', '__ci_last_regenerate|i:1695835110;'), ('n5r7b8c78r1tcqjq79snv4rrfe6f8r56', '103.253.45.78', '1695835594', '__ci_last_regenerate|i:1695835594;'), ('7l1n2f3c0qusf3k36hq30qqovvib0sa2', '103.253.45.78', '1695835597', '__ci_last_regenerate|i:1695835597;'), ('mcg8pc523uq3mqsfug65jmu2nt5rc85t', '103.253.45.78', '1695835597', '__ci_last_regenerate|i:1695835597;'), ('7fchbtp6dje0elrmigau68s8kjjmu20r', '103.253.45.78', '1695835597', '__ci_last_regenerate|i:1695835597;'), ('9kiuku0ke5bh27f9lli4ei22lt92e41b', '103.253.45.78', '1695835597', '__ci_last_regenerate|i:1695835597;'), ('8anu51q8sfn85ckah75gos99btdlukn9', '103.253.45.78', '1695835597', '__ci_last_regenerate|i:1695835597;'), ('n30hsi0941bkonjeqfj4jp65a7pk1enr', '103.253.45.78', '1695835598', '__ci_last_regenerate|i:1695835598;'), ('uhdt0ui7oslabu39uap6h73turao9e8h', '103.253.45.78', '1695835598', '__ci_last_regenerate|i:1695835598;'), ('drm26js6v0g335eoe0m9mh2vm1sadltk', '103.253.45.78', '1695835604', '__ci_last_regenerate|i:1695835604;'), ('57i9259pokfamda9ci08vamu9ikt3rg2', '103.253.45.78', '1695835609', '__ci_last_regenerate|i:1695835609;'), ('4anl2o2re50m5mf7cc1fm9d94m3f5slk', '103.253.45.78', '1695835610', '__ci_last_regenerate|i:1695835610;'), ('bd1tks3o3iu16rqnuto8a3r70pnf0ma8', '103.253.45.78', '1695835610', '__ci_last_regenerate|i:1695835610;'), ('bs6eu7364cnv22chdsq6ndi282hcvegk', '103.253.45.78', '1695835610', '__ci_last_regenerate|i:1695835610;'), ('6t8kacc0fnqv6308bmv2g04apdn75bjh', '103.253.45.78', '1695835610', '__ci_last_regenerate|i:1695835610;'), ('km1l2dh9pcncagrv4iogag5bjghplvds', '103.253.45.78', '1695835610', '__ci_last_regenerate|i:1695835610;'), ('5pgfoo1u2ujga2hkjsvtj1e1eg7c1uac', '103.253.45.78', '1695835610', '__ci_last_regenerate|i:1695835610;'), ('1v9cohe2n2dra2uebr40q57eqgn809va', '103.253.45.78', '1695835610', '__ci_last_regenerate|i:1695835610;'), ('8e06gdsajqlv64kdkst5u82ub7p914hh', '103.253.45.78', '1695835611', '__ci_last_regenerate|i:1695835611;'), ('f7v5pdl2agdhr1ra9d6822fiq9gcdjk6', '103.253.45.78', '1695835613', '__ci_last_regenerate|i:1695835613;'), ('05uicddb11m6fu5sqtb5osepbuk5o7j7', '103.253.45.78', '1695835613', '__ci_last_regenerate|i:1695835613;'), ('cfdnaqjb9jmtkp6tcis4gg1svavos224', '103.253.45.78', '1695835613', '__ci_last_regenerate|i:1695835613;'), ('92ghb7opoa67cp1h6em7uf2jeba2t4ai', '103.253.45.78', '1695835614', '__ci_last_regenerate|i:1695835614;'), ('u0r8vv4lovke7eo6lmagaplfovng8hjs', '103.253.45.78', '1695835615', '__ci_last_regenerate|i:1695835615;'), ('g97fh6gm4vdlvooa1qdvcp0lsio65mbu', '103.253.45.78', '1695835618', '__ci_last_regenerate|i:1695835618;'), ('2djd5dj8ckhal1ggk0chsid5o5of2atk', '103.253.45.78', '1695835618', '__ci_last_regenerate|i:1695835618;'), ('26tfrjsvt7nafjgq2rvkk0ejp6jtt9t2', '103.253.45.78', '1695835619', '__ci_last_regenerate|i:1695835619;'), ('phggege4h19llr0mhnjr997luguv92pc', '103.253.45.78', '1695835619', '__ci_last_regenerate|i:1695835619;'), ('gsmvfb9f574hei11kevu3a913gqeu4jq', '103.253.45.78', '1695835619', '__ci_last_regenerate|i:1695835619;'), ('23d9jh8korhhjr7q0ccmhbltekierqe7', '103.253.45.78', '1695835619', '__ci_last_regenerate|i:1695835619;'), ('56il6i0gm77d8big45afmluvp4vhm1fm', '103.253.45.78', '1695835619', '__ci_last_regenerate|i:1695835619;'), ('tnkf8d1bii7p6reld68k5vra6oqmfv73', '103.253.45.78', '1695835619', '__ci_last_regenerate|i:1695835619;'), ('7mlomo0rqn137o82mecil6ujstaecjtc', '103.253.45.78', '1695835903', '__ci_last_regenerate|i:1695835903;'), ('jl6stgca7s38ugcoc8dn440gapaam8tk', '103.253.45.78', '1695835904', '__ci_last_regenerate|i:1695835904;'), ('lva2ajeb2d8eahlht4m6ichdfvkddsqd', '103.253.45.78', '1695835904', '__ci_last_regenerate|i:1695835904;'), ('ka61v1jijjc3b4i4o8qi3p1tg3vvukpc', '103.253.45.78', '1695835904', '__ci_last_regenerate|i:1695835904;'), ('2ce4u1rcac6h8g8979d51a22ricbauq2', '103.253.45.78', '1695835904', '__ci_last_regenerate|i:1695835904;'), ('tloutf09q8anp5jjjef758nmo32bblhb', '103.253.45.78', '1695835904', '__ci_last_regenerate|i:1695835904;'), ('g9v0sq3m2fbh8m2nq9unbgt18nqnfisa', '103.253.45.78', '1695835904', '__ci_last_regenerate|i:1695835904;'), ('hp2ff5mbpgsn4o7bftp86oka5kn811p6', '103.253.45.78', '1695835904', '__ci_last_regenerate|i:1695835904;'), ('2lomg90vss3frs1v7ofpgi7ul6vi9s6m', '103.253.45.78', '1695835904', '__ci_last_regenerate|i:1695835904;'), ('4sr255o166ob6eciho64bhk457bv95hn', '103.253.45.78', '1695835919', '__ci_last_regenerate|i:1695835919;'), ('6eotkmr6gb0ns4bjltvnirhvnkmlm6rg', '103.253.45.78', '1695835920', '__ci_last_regenerate|i:1695835920;'), ('emainiked1dqh1pkqotfn7h3gh46jlk4', '103.253.45.78', '1695835920', '__ci_last_regenerate|i:1695835920;'), ('62bo1sgvmqa7ubh0gg3kk91vfm18l08a', '103.253.45.78', '1695835920', '__ci_last_regenerate|i:1695835920;'), ('vbmvov8vhfsgfi2ph8kedstdil64nb3d', '103.253.45.78', '1695835920', '__ci_last_regenerate|i:1695835920;'), ('jfitr1o6a06o1fcklqhg8h56ee3l286k', '103.253.45.78', '1695835920', '__ci_last_regenerate|i:1695835920;'), ('r5369cqb3s4rd960fd5uttrhqrf9k55k', '103.253.45.78', '1695835920', '__ci_last_regenerate|i:1695835920;'), ('6ihgdkhubepk7tdfnmbj1g9kipccd1dj', '103.253.45.78', '1695835920', '__ci_last_regenerate|i:1695835920;'), ('262mphjrclv4np4rs4o1qnm4ivvgacgs', '103.253.45.78', '1695836395', '__ci_last_regenerate|i:1695836395;'), ('ughi9u0s1sft5nrc1bu9c6k3bq5t574e', '103.253.45.78', '1695836399', '__ci_last_regenerate|i:1695836399;'), ('lt3gietj97jka4a4p986il6u7a9224sb', '103.253.45.78', '1695836399', '__ci_last_regenerate|i:1695836399;'), ('84cigi3uni6ua4r3k2ni368tokcmq5fe', '103.253.45.78', '1695836399', '__ci_last_regenerate|i:1695836399;'), ('1s8kemt6m1pvgpmtskkli4mmndon9d97', '103.253.45.78', '1695836399', '__ci_last_regenerate|i:1695836399;'), ('unh5h8ts9ekvravg7gl59qm7d8uohbb5', '103.253.45.78', '1695836399', '__ci_last_regenerate|i:1695836399;'), ('g36bclmpp64bfqiup4ahf93lsdkcdto2', '103.253.45.78', '1695836399', '__ci_last_regenerate|i:1695836399;'), ('78bcfe203s1v55nmose105mdd4anrdqf', '103.253.45.78', '1695836399', '__ci_last_regenerate|i:1695836399;'), ('dihbdbpp4ucnpf6i4n5vmp3fcnnv6igd', '103.253.45.78', '1695836404', '__ci_last_regenerate|i:1695836404;'), ('69b4v1hct6udblcq28l4inej5080qc7s', '103.253.45.78', '1695836448', '__ci_last_regenerate|i:1695836448;'), ('7gn9rdomh0lgt05scmjeu53ou3264eke', '103.253.45.78', '1695836452', '__ci_last_regenerate|i:1695836452;'), ('cnupsl0fa6kq77bbm8pmh3bf97m1guu8', '103.253.45.78', '1695836452', '__ci_last_regenerate|i:1695836452;'), ('145obskue1qvlrngsdafh03iq4ep65he', '103.253.45.78', '1695836452', '__ci_last_regenerate|i:1695836452;'), ('6alna02bk4utdvusego9lfttofn1lll2', '103.253.45.78', '1695836452', '__ci_last_regenerate|i:1695836452;'), ('iokn29gpdoarjn7pheiq4c67lt58hbt1', '103.253.45.78', '1695836452', '__ci_last_regenerate|i:1695836452;'), ('naleecmihe899kg5d4d9n076f284ugkr', '103.253.45.78', '1695836452', '__ci_last_regenerate|i:1695836452;'), ('d4s16phmaq8fmeikoboh39jrnfb79sdr', '103.253.45.78', '1695836452', '__ci_last_regenerate|i:1695836452;'), ('hqrlrqrlqrbftsisi6fpriefirl4s32a', '103.253.45.78', '1695836462', '__ci_last_regenerate|i:1695836462;'), ('q0i9aj5ojcet31v4ddke6mdq0n7g66hb', '103.253.45.78', '1695836590', '__ci_last_regenerate|i:1695836590;'), ('ccqdcbu4rd06lh00et7191co6cnn0kf9', '103.253.45.78', '1695836594', '__ci_last_regenerate|i:1695836594;'), ('jhdg3sa9j69g3h62141rs7toffaun5rr', '103.253.45.78', '1695836594', '__ci_last_regenerate|i:1695836594;'), ('nt5fd3m40fb3083lmn6pt10l5uakqols', '103.253.45.78', '1695836594', '__ci_last_regenerate|i:1695836594;'), ('ffits7ubqtlthi8g07np1t1nfjueib19', '103.253.45.78', '1695836594', '__ci_last_regenerate|i:1695836594;'), ('78glgu2ev23hcdoft6lb0l608vpjuh3n', '103.253.45.78', '1695836594', '__ci_last_regenerate|i:1695836594;'), ('14j1fjp2lthlfc5su2ohl88kb65mc5tk', '103.253.45.78', '1695836594', '__ci_last_regenerate|i:1695836594;'), ('j5m881329plh3bkgi0s8k9nn8ib4b6sk', '103.253.45.78', '1695836594', '__ci_last_regenerate|i:1695836594;'), ('oc7ojgbb7rluc3muc9ood7ka5qb1lq0t', '103.253.45.78', '1695836597', '__ci_last_regenerate|i:1695836597;'), ('pol3dla1b24d6hsp85l2g49gl2111dvt', '103.253.45.78', '1695836603', '__ci_last_regenerate|i:1695836603;'), ('4q24af84e5oop0fa7igjlrldhv1em0h8', '103.253.45.78', '1695836604', '__ci_last_regenerate|i:1695836604;'), ('hopmbce600dkd27d0icucqgb59l7ckq5', '103.253.45.78', '1695836605', '__ci_last_regenerate|i:1695836605;'), ('opmgmo27sd2bld3s5353eetgh30l82ao', '103.253.45.78', '1695836605', '__ci_last_regenerate|i:1695836605;'), ('ap566jijmdedbu3i0478f9phdtm4dkh2', '103.253.45.78', '1695836605', '__ci_last_regenerate|i:1695836605;'), ('e9pn1cllgnd5r857q1vtju5a534bs0g0', '103.253.45.78', '1695836605', '__ci_last_regenerate|i:1695836605;'), ('g4hp2q09djg8ebn3emd6d5gsa7ir3s7t', '103.253.45.78', '1695836605', '__ci_last_regenerate|i:1695836605;'), ('eb485tm87k6p7dh18jdgovncpgfihseo', '103.253.45.78', '1695836605', '__ci_last_regenerate|i:1695836605;'), ('hvnousg5pm5g67uqimd3n3i4hn40cmdf', '103.253.45.78', '1695836606', '__ci_last_regenerate|i:1695836606;'), ('jcv4r0n2g7j9lqehmtfj1fnr1ia36q90', '103.253.45.78', '1695836676', '__ci_last_regenerate|i:1695836676;'), ('0vrs28ghrg81047t7cc172bc0i2bcm1p', '103.253.45.78', '1695836680', '__ci_last_regenerate|i:1695836680;'), ('1ec3p8c1vcmh9akhcfohirirq29gls5k', '103.253.45.78', '1695836680', '__ci_last_regenerate|i:1695836680;'), ('b410eun18pjo1ua8ehs3kspgsd41iqg1', '103.253.45.78', '1695836680', '__ci_last_regenerate|i:1695836680;'), ('r43h8mauvu0og1um7oieerohlfti3s9u', '103.253.45.78', '1695836680', '__ci_last_regenerate|i:1695836680;'), ('0gfn27208mesu5j5vk3opvlhdkl53km0', '103.253.45.78', '1695836680', '__ci_last_regenerate|i:1695836680;'), ('lc9cscf0ppl6vj9h5dmk0qf51lbsompf', '103.253.45.78', '1695836680', '__ci_last_regenerate|i:1695836680;'), ('914fb762ehtefb6kd9klr90v6vfveasm', '103.253.45.78', '1695836680', '__ci_last_regenerate|i:1695836680;'), ('i80ghtua7cma2ifcvjs5sesumj5mtrqp', '103.253.45.78', '1695836685', '__ci_last_regenerate|i:1695836685;'), ('k0dshjabu7o8mnqjks47e8s2g92qlraq', '103.253.45.78', '1695836688', '__ci_last_regenerate|i:1695836688;'), ('irsf756nk1369segg2u5fbvnkagthuud', '103.253.45.78', '1695836689', '__ci_last_regenerate|i:1695836689;'), ('i31bft93jpsgc6eruurmbeli3u6g3ofe', '103.253.45.78', '1695836690', '__ci_last_regenerate|i:1695836690;'), ('ajcvmo60uu6gs8f77npb585jibphu1g5', '103.253.45.78', '1695836690', '__ci_last_regenerate|i:1695836690;'), ('38kp8h46av39qi2ma1les43hbp46u1gf', '103.253.45.78', '1695836690', '__ci_last_regenerate|i:1695836690;'), ('j4ksm7l9rktp6lvqi3b7hc80pffv765f', '103.253.45.78', '1695836690', '__ci_last_regenerate|i:1695836690;'), ('tltto0ev5msj01ld3gidqsfbrguqkfit', '103.253.45.78', '1695836690', '__ci_last_regenerate|i:1695836690;'), ('tg2ricqdtpt5gs098b6ignsbj8ps4ldk', '103.253.45.78', '1695836690', '__ci_last_regenerate|i:1695836690;'), ('ti3brp0ub8ojgn5tscm4vjloftq5incj', '103.253.45.78', '1695836690', '__ci_last_regenerate|i:1695836690;'), ('0tabd609o53mv1sjfs4s7qukvekt1jue', '103.253.45.78', '1695836702', '__ci_last_regenerate|i:1695836702;'), ('4fv81nr07t6etujcppbgn0c10ormog1k', '103.253.45.78', '1695836993', '__ci_last_regenerate|i:1695836993;'), ('ljl5hhsc687gtgu865obrmiqsc6pagfb', '103.253.45.78', '1695836997', '__ci_last_regenerate|i:1695836997;'), ('9l43ip27fncimiet1h7hef4fccadem9h', '103.253.45.78', '1695836997', '__ci_last_regenerate|i:1695836997;'), ('l19ghqljao652go7f7c6vr9r6nmf75jo', '103.253.45.78', '1695836997', '__ci_last_regenerate|i:1695836997;'), ('mnedfstq1fl1njhonba8p22r43vr0kse', '103.253.45.78', '1695836997', '__ci_last_regenerate|i:1695836997;'), ('duccpmokhboelrr1vt6k34u3h0pkf8pu', '103.253.45.78', '1695836997', '__ci_last_regenerate|i:1695836997;'), ('rs8h6l6mmmriumojfn5j029bbq3msmb8', '103.253.45.78', '1695836997', '__ci_last_regenerate|i:1695836997;'), ('kug8lbgi8up8hstfqovljnq5r0513fu8', '103.253.45.78', '1695836997', '__ci_last_regenerate|i:1695836997;'), ('gfvrhonn3p57bbtnrr15d3k3cbkcklp1', '103.253.45.78', '1695837000', '__ci_last_regenerate|i:1695837000;'), ('9s3laecmluogsj8gm85dni49db98pe08', '103.253.45.78', '1695837005', '__ci_last_regenerate|i:1695837005;'), ('5sd8lks0mbq88kr77qll2fup3llepvii', '103.253.45.78', '1695837005', '__ci_last_regenerate|i:1695837005;'), ('spjqicanjoohn389cp6pakjgfnlb152s', '103.253.45.78', '1695837006', '__ci_last_regenerate|i:1695837006;'), ('2grti77de99ruvu8ni5mr2vrk36d8ku2', '103.253.45.78', '1695837006', '__ci_last_regenerate|i:1695837006;'), ('v0kvvb5tn2dfvv0a5u74iima7toh7qcb', '103.253.45.78', '1695837006', '__ci_last_regenerate|i:1695837006;'), ('v1nm0dqurq5f70ia7vf6ol5qreo3nk2a', '103.253.45.78', '1695837006', '__ci_last_regenerate|i:1695837006;'), ('tl01e4ur8uh4usqamqi1aq9teg66dafk', '103.253.45.78', '1695837006', '__ci_last_regenerate|i:1695837006;'), ('d139bqe7rafmrqgh61c6i2gp1h4vbh5f', '103.253.45.78', '1695837006', '__ci_last_regenerate|i:1695837006;'), ('rr90hssl09hvojcgoee6cqik5ut5ghsi', '103.253.45.78', '1695837006', '__ci_last_regenerate|i:1695837006;'), ('jsufiu4v9svl7prlbe9kourf79iu4o3m', '103.253.45.78', '1695837010', '__ci_last_regenerate|i:1695837010;'), ('4nd988hp6cvbft02gnde31ig5esjl9jv', '103.253.45.78', '1695837010', '__ci_last_regenerate|i:1695837010;'), ('ncf6q0rgf9f34orvp61qegd6ho0hct79', '103.253.45.78', '1695837011', '__ci_last_regenerate|i:1695837011;'), ('7is0t52simu74ub50o4ne8uhpaf08hjp', '103.253.45.78', '1695837011', '__ci_last_regenerate|i:1695837011;'), ('h9e8nijhcki62k5r32hkogo3an8r612j', '103.253.45.78', '1695837011', '__ci_last_regenerate|i:1695837011;'), ('gfphsjgfsprs9mrd94l2711nsgkgm5i4', '103.253.45.78', '1695837011', '__ci_last_regenerate|i:1695837011;'), ('dos2o969u9lg9kp80v11k4aqlm87f3no', '103.253.45.78', '1695837011', '__ci_last_regenerate|i:1695837011;'), ('0jdgipkjo4clba9no6ak4vi8tiblp455', '103.253.45.78', '1695837011', '__ci_last_regenerate|i:1695837011;'), ('kosmcpsnoltpqlpdq6ue39v8i5jqb6ug', '103.253.45.78', '1695837187', '__ci_last_regenerate|i:1695837187;'), ('jrpc98og7p3p9rf38uk1mfo0v0h504ts', '103.253.45.78', '1695837190', '__ci_last_regenerate|i:1695837190;'), ('vfjnqp9td8dnetgt282d69tadth1a175', '103.253.45.78', '1695837190', '__ci_last_regenerate|i:1695837190;'), ('alg1hf5b8d31c2vqv8e2d2akfojonnhm', '103.253.45.78', '1695837190', '__ci_last_regenerate|i:1695837190;'), ('qbsit86kam92tjt2o3rud86c31rmlrm0', '103.253.45.78', '1695837190', '__ci_last_regenerate|i:1695837190;'), ('oop2fkh2tutl6po3173r2neugtdv9ufk', '103.253.45.78', '1695837190', '__ci_last_regenerate|i:1695837190;'), ('bs8vli1rr577knp3v2qe4emquahhfinu', '103.253.45.78', '1695837190', '__ci_last_regenerate|i:1695837190;'), ('pa5bhgion81m77ntm3bk8jbutcuejq9o', '103.253.45.78', '1695837191', '__ci_last_regenerate|i:1695837191;'), ('7krftef043eslttmvtflk29nlm1vcmaj', '103.253.45.78', '1695837201', '__ci_last_regenerate|i:1695837201;'), ('rd6to8q0b8tg9ssueljki8pcdgf4e0d0', '103.253.45.78', '1695837202', '__ci_last_regenerate|i:1695837202;'), ('cps6qb4gbplnt2tg2i1qjlco1setp542', '103.253.45.78', '1695837202', '__ci_last_regenerate|i:1695837202;'), ('hl4kbbb739il420rc79salh8h2qbnmjp', '103.253.45.78', '1695837202', '__ci_last_regenerate|i:1695837202;'), ('tj0n2bmrs1hst3e8k66biqr32j7o4el7', '103.253.45.78', '1695837202', '__ci_last_regenerate|i:1695837202;'), ('9nhgnk5k366ijic7ufds4qe0u7vvj7l2', '103.253.45.78', '1695837202', '__ci_last_regenerate|i:1695837202;'), ('82isbitg6q37iig2m3q1d1d4jgqb9cjf', '103.253.45.78', '1695837202', '__ci_last_regenerate|i:1695837202;'), ('4r8qsknq2pijk04has5gco2qhg4b7kcl', '103.253.45.78', '1695837202', '__ci_last_regenerate|i:1695837202;'), ('ksbc19bh75jffikr52ssqbv8oabj8bvi', '103.253.45.78', '1695837203', '__ci_last_regenerate|i:1695837203;'), ('pic994gf1rj7925dmp92pv87bk20nfje', '103.253.45.78', '1695837568', '__ci_last_regenerate|i:1695837568;'), ('8jsgobqdhmqo2ttnciffsd6m20038748', '103.253.45.78', '1695837569', '__ci_last_regenerate|i:1695837569;'), ('urh4gsf59b664vtmed4dh5qv0dq4vp3u', '103.253.45.78', '1695837569', '__ci_last_regenerate|i:1695837569;'), ('neba68case3nvv3o8v7na17f8lesef28', '103.253.45.78', '1695837569', '__ci_last_regenerate|i:1695837569;'), ('in5nc3egd22qc2bk7ekufm804vfvblbd', '103.253.45.78', '1695837569', '__ci_last_regenerate|i:1695837569;'), ('fncoodca8er76l9sj8rfiesriqejlg86', '103.253.45.78', '1695837569', '__ci_last_regenerate|i:1695837569;'), ('3abs1k5ungleckuh2u34kshknr1b8rui', '103.253.45.78', '1695837569', '__ci_last_regenerate|i:1695837569;'), ('osa44cg1f2gqs3ofroo6vr0ojfimfdn8', '103.253.45.78', '1695837569', '__ci_last_regenerate|i:1695837569;'), ('4l15aook64sqiu2skdln7lef8q8dbh7q', '27.147.201.240', '1695887900', '__ci_last_regenerate|i:1695875977;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1696751900;user_id|s:1:\"1\";role_id|s:1:\"1\";role|s:5:\"Admin\";name|s:13:\"Noman  Khalid\";is_instructor|s:1:\"1\";admin_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('58s04t3rebgcln1k2psnv8fk29nlf5oo', '27.147.201.240', '1695886431', '__ci_last_regenerate|i:1695876133;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1696750431;user_id|s:3:\"457\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:8:\"John Doe\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('njgtk19g1rp9jtcbnb8bg0o0nivr2veg', '103.196.232.132', '1695876546', '__ci_last_regenerate|i:1695876543;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}cart_items|a:0:{}language|s:7:\"english\";'), ('phmjlpp6st0mnsjrpv9sa7oqchs8jb4n', '43.245.232.69', '1695876553', '__ci_last_regenerate|i:1695876550;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}cart_items|a:0:{}language|s:7:\"english\";'), ('egfqreo4q5gvup28ir3en4578tg48f4f', '103.67.158.85', '1695881455', '__ci_last_regenerate|i:1695881455;'), ('cqqd3ocnbukdakkeq26mcman6m6us2sn', '103.67.158.83', '1695881460', '__ci_last_regenerate|i:1695881460;'), ('p9v8s3pfkpvkok728ep1v9rggreu98pf', '103.67.158.84', '1695881464', '__ci_last_regenerate|i:1695881464;'), ('0ckmu2naibvpuldbpif7vrh5t21sdmd2', '103.67.158.84', '1695881464', '__ci_last_regenerate|i:1695881464;'), ('3put4sr5gsl0m60rm9l3gouveoknl4eu', '103.67.158.84', '1695881464', '__ci_last_regenerate|i:1695881464;'), ('mbj90iojqulpvvf3mha1r3mffhqb5o2b', '103.67.158.84', '1695881464', '__ci_last_regenerate|i:1695881464;'), ('khr77f65ubk2f1ouojbbk6vcdedvi39u', '103.67.158.83', '1695881465', '__ci_last_regenerate|i:1695881465;'), ('pgdn52rsvnsn06n81k73fs2quus9gro6', '103.67.158.86', '1695881484', '__ci_last_regenerate|i:1695881484;'), ('mbj89t7ekb192aqducv68hj61d0d3rlh', '103.67.158.86', '1695881485', '__ci_last_regenerate|i:1695881485;'), ('f2d9esgfpel6m2v774sv8h1e7uvgojj7', '103.67.158.86', '1695881486', '__ci_last_regenerate|i:1695881486;'), ('qbqbunttiak9okmrh4errgs6uqf230g4', '103.67.158.86', '1695881486', '__ci_last_regenerate|i:1695881486;'), ('ee34utnf5j8bnjk20l385atfc4o8s7vh', '103.67.158.86', '1695881486', '__ci_last_regenerate|i:1695881486;'), ('koq6aiuf957vffeb65iq60o8bevkc20m', '103.67.158.86', '1695881486', '__ci_last_regenerate|i:1695881486;'), ('3oeraelh2me6s2340vjq9kjp4el29bqs', '103.67.158.86', '1695881486', '__ci_last_regenerate|i:1695881486;'), ('6ctdv4l1bqucbsp4d40c58uovnlkoqtt', '103.67.158.86', '1695881486', '__ci_last_regenerate|i:1695881486;'), ('ps4qmd13mc97cqsktvvgivhasn3g6v48', '103.67.158.86', '1695881488', '__ci_last_regenerate|i:1695881488;'), ('jipa6e3u9d8au2c6p897kq6q4m83hk3h', '103.67.158.87', '1695881495', '__ci_last_regenerate|i:1695881495;'), ('pm88eakm7977ofdjcupabf0b98i9vmqh', '103.67.158.85', '1695881495', '__ci_last_regenerate|i:1695881495;'), ('nm7nhr55u0p75an62e8187fvcol9flp3', '103.67.158.85', '1695881495', '__ci_last_regenerate|i:1695881495;'), ('0mdb8ij5it8pf8pn9icea0gcd33mtnvp', '103.67.158.87', '1695881495', '__ci_last_regenerate|i:1695881495;'), ('clrkqtvbq47qg94vnoie55h1if36u704', '103.67.158.87', '1695881500', '__ci_last_regenerate|i:1695881500;'), ('vgrmrs97nrfjtg4k1je8dt5jan52rciv', '103.67.158.87', '1695881500', '__ci_last_regenerate|i:1695881500;'), ('5avgo4uhmdme4jge32l7guvmvmgijsd5', '103.67.158.87', '1695881500', '__ci_last_regenerate|i:1695881500;'), ('1rrkghjvh69v9plg5a8jlcq4ku6ui1ge', '103.67.158.87', '1695881500', '__ci_last_regenerate|i:1695881500;'), ('sloa6ivec5gvd82eirtds4qgio8uua35', '103.67.158.87', '1695881500', '__ci_last_regenerate|i:1695881500;'), ('so900n0p27k5kca5d9hcbg404daciu4v', '103.67.158.87', '1695881502', '__ci_last_regenerate|i:1695881502;'), ('3o6d6e5ge3nl3gu8ia6q25n2pbc9v471', '103.67.158.87', '1695881502', '__ci_last_regenerate|i:1695881502;'), ('fkc59ppsipfm3sh6n4en6j00qlab4tqk', '103.67.158.87', '1695881503', '__ci_last_regenerate|i:1695881503;'), ('82j352vhdkd0najifujjfcck71kiimf5', '103.67.158.87', '1695881506', '__ci_last_regenerate|i:1695881506;'), ('d1c7spdv2n16sdi0aau3cbtqgsr1l3kb', '103.67.158.87', '1695881506', '__ci_last_regenerate|i:1695881506;'), ('2ms5t3u9u5c5r99bdnsk5fplfdbsn9jl', '103.67.158.87', '1695881506', '__ci_last_regenerate|i:1695881506;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('jn1bge4he863i7asp2lj1849tuv8mtlr', '103.67.158.87', '1695881506', '__ci_last_regenerate|i:1695881506;'), ('30ur2aegdku26h24dojq40g5thctb69d', '103.67.158.87', '1695881509', '__ci_last_regenerate|i:1695881509;'), ('uq9aklbp3j97su6q2k8o8b5bm2oii5o8', '103.67.158.87', '1695881511', '__ci_last_regenerate|i:1695881511;'), ('b6qab6qmgnd997h53tjcm2ml948o1hg5', '103.67.158.87', '1695881511', '__ci_last_regenerate|i:1695881511;'), ('30a34vav5q3ljtmvrkreamq5f8ni90b0', '103.67.158.87', '1695881511', '__ci_last_regenerate|i:1695881511;'), ('phvmlvi0tpno6m2bu9v3kglrj4qjea1v', '103.67.158.87', '1695881511', '__ci_last_regenerate|i:1695881511;'), ('b38b8d7hh41hrjdlq7006tm6m1rb4psp', '103.67.158.87', '1695881511', '__ci_last_regenerate|i:1695881511;'), ('q83ffvdkgk64fo012a24m0v8objpmb6d', '103.67.158.87', '1695881511', '__ci_last_regenerate|i:1695881511;'), ('ll00fqrmh3hudpmtgb413rsr65spv9um', '103.67.158.87', '1695881519', '__ci_last_regenerate|i:1695881519;'), ('cti9904h0q3ml21kvctaejt219gjn863', '103.67.158.87', '1695881519', '__ci_last_regenerate|i:1695881519;'), ('q2akbrpih6usn9o7t4i0s7qou4ha7678', '103.67.158.87', '1695881519', '__ci_last_regenerate|i:1695881519;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('kh6o3c38ahgrkkq9vubu6l120cmjg1ca', '103.67.158.87', '1695881519', '__ci_last_regenerate|i:1695881519;'), ('0ilvls9fis8k6nk7aam2ruf425aeu7d6', '103.67.158.87', '1695881523', '__ci_last_regenerate|i:1695881523;'), ('pundnbvaumc2se6nk57dbc1ih01iq07j', '103.67.158.83', '1695881531', '__ci_last_regenerate|i:1695881531;'), ('1ohppfmjr3c89ea316l4vot2r4ck4m33', '103.67.158.83', '1695881531', '__ci_last_regenerate|i:1695881531;'), ('la8g3aim7vvva5ujr9pld6urkfuedp1o', '103.67.158.83', '1695881531', '__ci_last_regenerate|i:1695881531;'), ('gbpqjf8foilfev1p63vmp7nds5etk6va', '103.67.158.83', '1695881531', '__ci_last_regenerate|i:1695881531;'), ('9c2egcdgn7e750vsdvpm15i36e1l3gqk', '103.67.158.84', '1695881534', '__ci_last_regenerate|i:1695881534;'), ('ev3fcij8on81t4fvtqf3jsup141bde44', '103.67.158.87', '1695881664', '__ci_last_regenerate|i:1695881664;'), ('20duht0shog1gcflgd8r17nq9u60hnhe', '103.67.158.87', '1695881664', '__ci_last_regenerate|i:1695881664;'), ('g9aag1p1ls98tpm2fo0p71hf8bth3ua5', '103.67.158.87', '1695881664', '__ci_last_regenerate|i:1695881664;'), ('e339ksg63sd1ovn15v9fna8ru1smel45', '103.67.158.87', '1695881664', '__ci_last_regenerate|i:1695881664;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('5irtl2e2celqg23jlk0aobvvva1ak06j', '103.67.158.87', '1695881666', '__ci_last_regenerate|i:1695881666;'), ('8uetanb0n5nr7mj2fbu2rlo70ljlkqie', '103.67.158.87', '1695881683', '__ci_last_regenerate|i:1695881683;'), ('h8cjn0uvf98qu5loqji1uecmhv0u58jc', '103.67.158.87', '1695881683', '__ci_last_regenerate|i:1695881683;'), ('gi0q9v6uef46s7vce11o2mbdm360ob22', '103.67.158.87', '1695881683', '__ci_last_regenerate|i:1695881683;'), ('h2qf03954onscauhug7m9q88e6datj60', '103.67.158.87', '1695881683', '__ci_last_regenerate|i:1695881683;'), ('2n5343a1thjhj7caqsbl2thddvo7lvo2', '103.67.158.87', '1695881685', '__ci_last_regenerate|i:1695881685;'), ('0tugfsk8e9m77tgkei2vveed8riaepts', '103.67.158.83', '1695881688', '__ci_last_regenerate|i:1695881688;'), ('jl1op1gu42ql4g42j2c0md6d3ae7l526', '103.67.158.83', '1695881688', '__ci_last_regenerate|i:1695881688;'), ('6hbmuuka9vt673er8j71tvo20lu6191p', '103.67.158.83', '1695881689', '__ci_last_regenerate|i:1695881689;'), ('mm90naeccccu5o5cadvudikqo9o5i83l', '103.67.158.83', '1695881689', '__ci_last_regenerate|i:1695881689;'), ('hfrba3jkl6e44rjpkmb7lr7oqhco22o9', '103.67.158.83', '1695881689', '__ci_last_regenerate|i:1695881689;'), ('5gc9231rlbv1ictlntv1okfs9kkq9khs', '103.67.158.83', '1695881689', '__ci_last_regenerate|i:1695881689;'), ('f86s34jphn5upfh6smnqqp8qcke5t9sd', '103.67.158.83', '1695881689', '__ci_last_regenerate|i:1695881689;'), ('9pql9ljnb3t76rk4t1ca4djlp6c0p8fk', '103.67.158.83', '1695881690', '__ci_last_regenerate|i:1695881690;'), ('mfp55i0rpa5lbpgrq6jm8mj6ojvpin6m', '103.67.158.83', '1695881692', '__ci_last_regenerate|i:1695881692;'), ('glk6bugfkn57vrd4v9q1o4ed4fblqd2u', '103.67.158.83', '1695881692', '__ci_last_regenerate|i:1695881692;'), ('f72h8ut7a6rtijebm4n915skum4dgng8', '103.67.158.83', '1695881692', '__ci_last_regenerate|i:1695881692;'), ('kvsdqlnja5dnn3s2s7rq0dnj14l5rt5l', '103.67.158.83', '1695881692', '__ci_last_regenerate|i:1695881692;'), ('ihtooh898hqpqpe8lec8260kne52lns9', '103.67.158.83', '1695881692', '__ci_last_regenerate|i:1695881692;'), ('cea4qj9o47dc2l5kl70k802ra77c71rj', '103.67.158.83', '1695881692', '__ci_last_regenerate|i:1695881692;'), ('00ibbsjd574no1kotoec3jgs2lvh8fg6', '103.67.158.86', '1695882032', '__ci_last_regenerate|i:1695882032;'), ('p4o0hl2ium7cusedvbb1up34i0i7hl9c', '103.67.158.86', '1695882038', '__ci_last_regenerate|i:1695882038;'), ('rijfpf39ep7gkcsqa3hro363fa7lsm96', '103.67.158.86', '1695882038', '__ci_last_regenerate|i:1695882038;'), ('i2e2gut43nvcb7gbqregdm3bpdqgqk20', '103.67.158.86', '1695882038', '__ci_last_regenerate|i:1695882038;'), ('k4hoompv0vr8jmpl4dioamisjjkg0e2c', '103.67.158.86', '1695882038', '__ci_last_regenerate|i:1695882038;'), ('n2sf2hbutnc4vpsn1sb1qoh37nc6cq3t', '103.67.158.86', '1695882038', '__ci_last_regenerate|i:1695882038;'), ('7j5mjs4er3sg2egle1op0q6o9cqhjosi', '103.67.158.80', '1695882038', '__ci_last_regenerate|i:1695882038;'), ('ih1jubuf9loq9r712f41kljc0e0ts1ae', '103.67.158.83', '1695882038', '__ci_last_regenerate|i:1695882038;'), ('sgf5mqjkpba1bqeed2pl9gdmqud3c4ri', '103.67.158.83', '1695882040', '__ci_last_regenerate|i:1695882040;'), ('j2j006jhhatns90usrl9jbnjhj9n7668', '103.67.158.83', '1695882050', '__ci_last_regenerate|i:1695882050;'), ('3thpeh2rgtqntqv2810pk1otg6lm7snu', '103.67.158.83', '1695882050', '__ci_last_regenerate|i:1695882050;'), ('vqsl7loc6h28saptu1tq0p8pa0t96552', '103.67.158.83', '1695882051', '__ci_last_regenerate|i:1695882051;'), ('9l5m6uf2n3enpgfna9ic3v89qfvgc9bg', '103.67.158.83', '1695882051', '__ci_last_regenerate|i:1695882051;'), ('7gu1dbun400cik4phucade7d81n2b5op', '103.67.158.83', '1695882051', '__ci_last_regenerate|i:1695882051;'), ('s23s26laeq9e38albkshgoc7jiiinfd3', '103.67.158.84', '1695882052', '__ci_last_regenerate|i:1695882052;'), ('46330n387o7a51sohjb7dk21ge3ijupb', '103.67.158.84', '1695882052', '__ci_last_regenerate|i:1695882052;'), ('i2rephegesv9l65tb4g74aado0au6oj0', '103.67.158.85', '1695882052', '__ci_last_regenerate|i:1695882052;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('03c4co10libab2ntdejlk4o1b7m2ts79', '103.67.158.84', '1695882052', '__ci_last_regenerate|i:1695882052;'), ('15rr0d3mo07n0csqta629q12tu0oa3bf', '103.67.158.85', '1695882052', '__ci_last_regenerate|i:1695882052;'), ('kca4q65ef9vna6mooaarvtlfo97ojc8b', '103.67.158.85', '1695882052', '__ci_last_regenerate|i:1695882052;'), ('mqehlod0acfufkomtv5spqjnhvjuhm85', '103.67.158.85', '1695882052', '__ci_last_regenerate|i:1695882052;'), ('g7qf69625br5nscbjnpp8b65h6ftqf1i', '103.67.158.85', '1695882052', '__ci_last_regenerate|i:1695882052;'), ('a353nvmmpvimkliqt8tnftvkqm3atkp7', '103.67.158.85', '1695882052', '__ci_last_regenerate|i:1695882052;'), ('2tv90ug2j9ip8rpont52vjgd8st4cuph', '103.67.158.85', '1695882052', '__ci_last_regenerate|i:1695882052;'), ('sabesci8ct5emq7maf8d0g66jhg9c29t', '103.67.158.85', '1695882052', '__ci_last_regenerate|i:1695882052;'), ('v3ol9m94jmb5o43t6g81itqievmpk46g', '103.67.158.84', '1695882054', '__ci_last_regenerate|i:1695882054;'), ('gmejk7e3kba5j1u8q1cmi8qqr25q3pjj', '103.67.158.84', '1695882109', '__ci_last_regenerate|i:1695882109;'), ('lmdb13ts4hthglc4h8ca3mq08071furf', '103.67.158.83', '1695882127', '__ci_last_regenerate|i:1695882127;'), ('js2f86k43cc2n7bel1trrm1pds5tn0ve', '103.67.158.83', '1695882129', '__ci_last_regenerate|i:1695882129;'), ('egceibfn6pb3qf5u0aslmo2nguggtqm9', '103.67.158.83', '1695882129', '__ci_last_regenerate|i:1695882129;'), ('e2ascrc20qvm8p8uemqqdokoplsoso6c', '103.67.158.83', '1695882129', '__ci_last_regenerate|i:1695882129;'), ('07ebsl0k4mpbnelphjr1gbtf71f17aq5', '103.67.158.83', '1695882137', '__ci_last_regenerate|i:1695882137;'), ('33ml0otthc1qvma4e4br87cp996od590', '103.67.158.84', '1695882138', '__ci_last_regenerate|i:1695882138;'), ('usnj23q1b7b6q16r29fmmobnm0kuoivr', '103.67.158.84', '1695882151', '__ci_last_regenerate|i:1695882151;'), ('a3rnbv79svkcv56i92dggca2lbt0ne47', '103.67.158.84', '1695882155', '__ci_last_regenerate|i:1695882155;'), ('jqejnnhqpl7q1q29bkq4aburdk7492d5', '103.67.158.84', '1695882155', '__ci_last_regenerate|i:1695882155;'), ('535a7qg9cqhj8hvcc1qgflgh5f1qh5p9', '103.67.158.84', '1695882155', '__ci_last_regenerate|i:1695882155;'), ('hg45vdkl9f0dh8nqsegc6r34rfnv0t53', '103.67.158.84', '1695882155', '__ci_last_regenerate|i:1695882155;'), ('37lt98qlofj004ub2n9q47hcgkircr7h', '103.67.158.84', '1695882155', '__ci_last_regenerate|i:1695882155;'), ('o0p8ds23o5om6r2id7c1m17t547ric0b', '103.67.158.84', '1695882155', '__ci_last_regenerate|i:1695882155;'), ('egsneoe7pcprisvk01tsmqjp8pghpj2n', '103.67.158.84', '1695882155', '__ci_last_regenerate|i:1695882155;'), ('jo2igno19q11j939tl4jfllf084gs8bq', '103.67.158.84', '1695882156', '__ci_last_regenerate|i:1695882156;'), ('122dmt9tefemg8tn2gg90mim66dm4ah2', '103.67.158.84', '1695882161', '__ci_last_regenerate|i:1695882161;'), ('4vsl1e2ll15rn6pks4eb4jfijartd65h', '103.67.158.84', '1695882161', '__ci_last_regenerate|i:1695882161;'), ('0bjv655p656qqp9mrc9csmq53qegq13r', '103.67.158.84', '1695882161', '__ci_last_regenerate|i:1695882161;'), ('ektgikkrd3c1nssob0vgur9pje7h24n3', '103.67.158.84', '1695882161', '__ci_last_regenerate|i:1695882161;'), ('ovutch9f5rekv15c7vfakj891j3o6nr8', '103.67.158.83', '1695882163', '__ci_last_regenerate|i:1695882163;'), ('1d8ui2470j346lu478pih33eojinkgeo', '103.67.158.83', '1695882164', '__ci_last_regenerate|i:1695882164;'), ('njnrgi00i9iqmelgf9asf4dmicn15fb2', '103.67.158.83', '1695882170', '__ci_last_regenerate|i:1695882170;'), ('b0ov5p5i9r6hte6itaga09n6dnc517fv', '103.67.158.83', '1695882170', '__ci_last_regenerate|i:1695882170;'), ('rpr97ueqs03lbmvcle278rtr0tcegvfb', '103.67.158.83', '1695882170', '__ci_last_regenerate|i:1695882170;'), ('gv7rk5hgl9ghh325f65h2kcd0vtsjl1e', '103.67.158.83', '1695882170', '__ci_last_regenerate|i:1695882170;'), ('9h50mh2datrqg555irtt83qpbqr5577b', '103.67.158.83', '1695882170', '__ci_last_regenerate|i:1695882170;'), ('c3f0gs94nclckdisegfmva1l9r56orhj', '103.67.158.83', '1695882170', '__ci_last_regenerate|i:1695882170;'), ('740e42mjcgk4il6d4a3tc2jgo772t1jr', '103.67.158.83', '1695882171', '__ci_last_regenerate|i:1695882171;'), ('kjqbg1shpfbotbaq4b112hef5nskqrl9', '103.67.158.83', '1695882171', '__ci_last_regenerate|i:1695882171;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('cm1et9kp32rqgnphuncn52mrvuh0msni', '103.67.158.83', '1695882173', '__ci_last_regenerate|i:1695882173;'), ('9arrd3f5tnvdp1tvggqtrs0rjtedr317', '103.67.158.83', '1695882189', '__ci_last_regenerate|i:1695882189;'), ('qv1ip54152723veohd92fdks3v2qrv6i', '103.67.158.85', '1695882486', '__ci_last_regenerate|i:1695882486;'), ('btctajl44316q5e7fr4qct5kct4has11', '103.67.158.84', '1695882491', '__ci_last_regenerate|i:1695882491;'), ('d0oevdjg5mkf61nsbcrnllgg9gfaee8j', '103.67.158.84', '1695882491', '__ci_last_regenerate|i:1695882491;'), ('1i5948h6rut8e8a9v4qua9elbnj38e20', '103.67.158.84', '1695882491', '__ci_last_regenerate|i:1695882491;'), ('bdo9bjoa7ergo43ms7g8jobv7keaoo44', '103.67.158.84', '1695882491', '__ci_last_regenerate|i:1695882491;'), ('pch4f251l98k2j8scteq1uddo4n8uhvj', '103.67.158.84', '1695882491', '__ci_last_regenerate|i:1695882491;'), ('putcq6funmu6obr26q018q9mng2c8kn2', '103.67.158.84', '1695882491', '__ci_last_regenerate|i:1695882491;'), ('b5th1acapubf9a4ilqk2fff9cmblbn3v', '103.67.158.84', '1695882492', '__ci_last_regenerate|i:1695882492;'), ('stnsunrekefp2f11m0bndkm85654m613', '103.67.158.86', '1695882517', '__ci_last_regenerate|i:1695882517;'), ('tq53ce03qos0jk1vv86pb0mu7j15n3mc', '103.67.158.86', '1695882519', '__ci_last_regenerate|i:1695882519;'), ('m39riq2ouhljq9nfe55uhvgufaf7smsj', '103.67.158.86', '1695882519', '__ci_last_regenerate|i:1695882519;'), ('mr4mu1inmdq13d9j388mjcnplck7v49f', '103.67.158.86', '1695882519', '__ci_last_regenerate|i:1695882519;'), ('2s5n4egf8j7p3cpv9usli0srgg2j170p', '103.67.158.86', '1695882519', '__ci_last_regenerate|i:1695882519;'), ('672hcfocr89gjvdvou9eqt3uifd5etdh', '103.67.158.86', '1695882519', '__ci_last_regenerate|i:1695882519;'), ('5vip0if2sqdvv0bq33ktf0jj4o1clfcn', '103.67.158.86', '1695882519', '__ci_last_regenerate|i:1695882519;'), ('4uelsaag9qg86vkq7mvfnod2pagm4n75', '103.67.158.83', '1695882519', '__ci_last_regenerate|i:1695882519;'), ('nhshl7v5glfpmfv5rbt0rhq24vs1at8i', '103.67.158.83', '1695882521', '__ci_last_regenerate|i:1695882521;'), ('jdi9of22lapceh689tvhhl1at620nokv', '103.67.158.83', '1695886913', '__ci_last_regenerate|i:1695882522;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1696750594;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('p0j76hdope9t2f0rq3ruuleicp4iijum', '103.67.158.86', '1695882532', '__ci_last_regenerate|i:1695882532;'), ('341n5fvtb5dl5vutujhns7jtuf61ldhk', '103.67.158.86', '1695882532', '__ci_last_regenerate|i:1695882532;'), ('q9926rpifsc52hho0d4nk8salq2tp7r0', '103.67.158.86', '1695882532', '__ci_last_regenerate|i:1695882532;'), ('cqrr9l6ag3nhi10prlfkiee0b1m7h30s', '103.67.158.86', '1695882532', '__ci_last_regenerate|i:1695882532;'), ('brs5ffknkitthmt7sl62p2a92ip3h72l', '103.67.158.86', '1695882533', '__ci_last_regenerate|i:1695882533;'), ('06o7j4b9nbe6gp3so0dc86rpiur6eptl', '103.67.158.85', '1695882537', '__ci_last_regenerate|i:1695882537;'), ('6pcnigmf845nt42c5snh7otb8h948o6k', '103.67.158.85', '1695882537', '__ci_last_regenerate|i:1695882537;'), ('o4b3al2ud77ba76v1m8fr2b7n308nhbv', '103.67.158.85', '1695882537', '__ci_last_regenerate|i:1695882537;'), ('7lpicam4oecfpgsbanb314fgah3j1f0u', '103.67.158.85', '1695882537', '__ci_last_regenerate|i:1695882537;'), ('clnin5lu914fnppt271292q42qajqiis', '103.67.158.85', '1695882537', '__ci_last_regenerate|i:1695882537;'), ('5cm7d69ftekec1vhugkn35p0gqktv4qm', '103.67.158.85', '1695882537', '__ci_last_regenerate|i:1695882537;'), ('l9e5hrm4ng1roltfcf476pjc9ueom76s', '103.67.158.85', '1695882538', '__ci_last_regenerate|i:1695882538;'), ('koqv9trdq4q92a2i0n8k7vuunqmob2bc', '103.67.158.83', '1695882545', '__ci_last_regenerate|i:1695882545;'), ('khvjiq67qk8p2s0b29s1hqaf3p8o9ec3', '103.67.158.87', '1695882583', '__ci_last_regenerate|i:1695882583;'), ('r59uf3hf3rbj1d68vo2ctpufcue37v2b', '103.67.158.87', '1695882584', '__ci_last_regenerate|i:1695882584;'), ('i1i9f9fdg4i61odq3hu0mvarvitmh1cv', '103.67.158.87', '1695882584', '__ci_last_regenerate|i:1695882584;'), ('doj3vfo5qugc05vkqr7nlr9efm4gb7g4', '103.67.158.87', '1695882584', '__ci_last_regenerate|i:1695882584;'), ('ie2vtddi8di3nmndfo4g2h8m2mbv8re4', '103.67.158.87', '1695882584', '__ci_last_regenerate|i:1695882584;'), ('hfhqs5ndr2msqpsb9ug8q8l3b0upq3jm', '103.67.158.87', '1695882584', '__ci_last_regenerate|i:1695882584;'), ('735p155cv5qgjge8ddsb773hg88bt85v', '103.67.158.87', '1695882584', '__ci_last_regenerate|i:1695882584;'), ('egjfft0001qn9ah2rdh4e8tj3ekhvoa3', '103.67.158.87', '1695882584', '__ci_last_regenerate|i:1695882584;'), ('577fvq011gfp1b903021l0co6qcpahc9', '103.67.158.83', '1695882587', '__ci_last_regenerate|i:1695882587;'), ('hmvtau59a90u2fp10if0mohstt2litp8', '103.67.158.83', '1695882587', '__ci_last_regenerate|i:1695882587;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ohvn3ni9p799t4kfafgt5jpq4vkmm51q', '103.67.158.83', '1695882587', '__ci_last_regenerate|i:1695882587;'), ('jqfrhv8rmqh4vq4dtb5oq9iorn9rckoi', '103.67.158.83', '1695882594', '__ci_last_regenerate|i:1695882594;'), ('j8ukc94sibkcgi5h1l4pe5aee7s3mugp', '103.67.158.86', '1695882597', '__ci_last_regenerate|i:1695882597;'), ('u0oolu4mm4bfs74buv7d2f4i0n47tgua', '103.67.158.86', '1695882597', '__ci_last_regenerate|i:1695882597;'), ('fje6aiapoui5794j5208tudscmp8nh4s', '103.67.158.86', '1695882598', '__ci_last_regenerate|i:1695882598;'), ('7ufo0u3skfjhfe52pjupcqgrln28sasj', '103.67.158.86', '1695882598', '__ci_last_regenerate|i:1695882598;'), ('csdcffhfvq82rc6j8abm4amnbigj2t3a', '103.67.158.86', '1695882598', '__ci_last_regenerate|i:1695882598;'), ('m73q75kufia8lqfgv5la4q98n3cuvt46', '103.67.158.86', '1695882598', '__ci_last_regenerate|i:1695882598;'), ('nlmm19hgqpbubalgnn8u1jhafrsdtn75', '103.67.158.86', '1695882598', '__ci_last_regenerate|i:1695882598;'), ('r4hjqfv1275521pklu4gf77fel8h3qds', '103.67.158.86', '1695882598', '__ci_last_regenerate|i:1695882598;'), ('deg9oma3kakbdlui7lq1hmncd0q2viik', '103.67.158.85', '1695882600', '__ci_last_regenerate|i:1695882600;'), ('levr47r599pp8f7fupbc4vu4cer2h60t', '103.67.158.85', '1695882600', '__ci_last_regenerate|i:1695882600;'), ('9mk1q7c7t0gvr1uavsdjpmvfao3ml3pq', '103.67.158.85', '1695882600', '__ci_last_regenerate|i:1695882600;'), ('gmrfl4jla72h599gf64ih37g916bgoht', '103.67.158.85', '1695882600', '__ci_last_regenerate|i:1695882600;'), ('7d00a6t9ekot0ek6mshnmd5siqbrgkp9', '103.67.158.85', '1695882601', '__ci_last_regenerate|i:1695882601;'), ('t7ugr2h3631c0kqku00rqg8njjv86jdv', '103.67.158.85', '1695882602', '__ci_last_regenerate|i:1695882602;'), ('8c7hj8i3p3i5ovrcedp8jdrm73hgk9he', '103.67.158.85', '1695882605', '__ci_last_regenerate|i:1695882605;'), ('8uonfihr34375vq5e90733ecamdvfb6r', '103.67.158.85', '1695882608', '__ci_last_regenerate|i:1695882608;'), ('8fh7fitfp3pf393ku4u6hrlnkkfodda9', '103.67.158.80', '1695882609', '__ci_last_regenerate|i:1695882609;'), ('9hi76lr3dla3thocffvnt1hi9neftoq8', '103.67.158.80', '1695882609', '__ci_last_regenerate|i:1695882609;'), ('nlf8ov8nkql0lq66k64qiu3jtst8m5bd', '103.67.158.80', '1695882609', '__ci_last_regenerate|i:1695882609;'), ('4qhvulgoctbkhlisakd7d3830mrmh16j', '103.67.158.80', '1695882609', '__ci_last_regenerate|i:1695882609;'), ('in44vutsj2pi6pomd2rk707n021n73ec', '103.67.158.80', '1695882609', '__ci_last_regenerate|i:1695882609;'), ('l7a1shlaoqv9csbfav5078d9tksac4np', '103.67.158.80', '1695882609', '__ci_last_regenerate|i:1695882609;'), ('l79fjlqnrt6drteacfdmqakb9cfmpkhe', '103.67.158.80', '1695882609', '__ci_last_regenerate|i:1695882609;'), ('59omdcn2ra7eedl68ntcccp39llvbgja', '103.67.158.80', '1695882610', '__ci_last_regenerate|i:1695882610;'), ('jcnllk2k9jfohtario811cjvhqs5moo2', '103.67.158.80', '1695882610', '__ci_last_regenerate|i:1695882610;'), ('375fdsnh7sb75sob9sg86a417c0q13o9', '103.67.158.80', '1695882610', '__ci_last_regenerate|i:1695882610;'), ('j399ivuiecrb4ui8h7beot8cmfg6t3p9', '103.67.158.80', '1695882610', '__ci_last_regenerate|i:1695882610;'), ('gqhtbbv6uifhlvsig4lshe6njs2al92v', '103.67.158.80', '1695882610', '__ci_last_regenerate|i:1695882610;'), ('egf7gi3pdf35uucvlv8o94oc711q0m6q', '103.67.158.80', '1695882611', '__ci_last_regenerate|i:1695882611;'), ('v5rmunm7g2sndmkgqjo47af4it95u4ah', '103.67.158.84', '1695882771', '__ci_last_regenerate|i:1695882771;'), ('a4qpl253nkm3k03itlhamric641inemt', '103.67.158.84', '1695882771', '__ci_last_regenerate|i:1695882771;'), ('s7f95rbe8dng1bosk09r2o2kvcednoca', '103.67.158.84', '1695882772', '__ci_last_regenerate|i:1695882772;'), ('62df0rasrtk7vatq14eo8mtrl8i0om32', '103.67.158.84', '1695882773', '__ci_last_regenerate|i:1695882773;'), ('gcsiqh485uq9j53abncokaoadrdrjb0u', '103.67.158.84', '1695882773', '__ci_last_regenerate|i:1695882773;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('l46nr2a445pq42v7kulnlf79qhecimdu', '103.67.158.80', '1695882774', '__ci_last_regenerate|i:1695882774;'), ('08d94rimnfnpht6vv7arid79pa9csn0c', '103.67.158.80', '1695882782', '__ci_last_regenerate|i:1695882782;'), ('65b2c1hmictinde2usaanc0mr90j1ssi', '103.67.158.80', '1695882782', '__ci_last_regenerate|i:1695882782;'), ('30rkd6dl4bvjbd62h9hl2rbfjka6gbfn', '103.67.158.80', '1695882782', '__ci_last_regenerate|i:1695882782;'), ('t6c55o4hritn1rpq3akjc23e5lch1kcc', '103.67.158.80', '1695882782', '__ci_last_regenerate|i:1695882782;'), ('2h08o4969ksok5hb9l80pvsgul6ufkrt', '103.67.158.83', '1695882784', '__ci_last_regenerate|i:1695882784;'), ('cu9if0f1745dkeujq1p87chqaai56nb5', '103.67.158.83', '1695882787', '__ci_last_regenerate|i:1695882787;'), ('dqh0g3d0hq1dmahcunofdfo3ctqb1hc1', '103.67.158.83', '1695882789', '__ci_last_regenerate|i:1695882789;'), ('i3cip5qgsumhtvivvg2kjv747ud49gu7', '103.67.158.83', '1695882789', '__ci_last_regenerate|i:1695882789;'), ('egrqvrpk1oa9kij0gaus7s2pfg1ui6mr', '103.67.158.83', '1695882789', '__ci_last_regenerate|i:1695882789;'), ('7mc1f8o1sb9jbvn4ua51rfhgrmgddnlj', '103.67.158.83', '1695882789', '__ci_last_regenerate|i:1695882789;'), ('mqq1dhoc4lg21180obljkckljanjcpqo', '103.67.158.83', '1695882789', '__ci_last_regenerate|i:1695882789;'), ('943oi7vk45r71ot3ts56mjrdjgh50b3n', '103.67.158.83', '1695882789', '__ci_last_regenerate|i:1695882789;'), ('d3gudl23lgl8q08m26dg58cb596ji1bj', '103.67.158.84', '1695882790', '__ci_last_regenerate|i:1695882790;'), ('ut1eql528ngu4pn1ufdlrt50c6scqejn', '103.67.158.80', '1695883194', '__ci_last_regenerate|i:1695883194;'), ('j21ep6tmfeajpo0binrekses7qrunle6', '103.67.158.80', '1695883194', '__ci_last_regenerate|i:1695883194;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('58a7cd4jg4d9uis29c04m97mfd9uvcb5', '103.67.158.83', '1695883195', '__ci_last_regenerate|i:1695883195;'), ('3pbk5b63fd0cm0u1rbf02uleigmjvih4', '103.67.158.83', '1695883197', '__ci_last_regenerate|i:1695883197;'), ('q7q3bignfvmsbul9o0tutg6i8ordhv1r', '103.67.158.83', '1695883199', '__ci_last_regenerate|i:1695883199;'), ('k93a7fcnif1akqtv5mjgf3i9qhf20fe9', '103.67.158.83', '1695883199', '__ci_last_regenerate|i:1695883199;'), ('jv6i142ojv4vu6a7pirbn6et00j30bd6', '103.67.158.83', '1695883199', '__ci_last_regenerate|i:1695883199;'), ('126v321sq9becoljc7jhgt9pvdp474eh', '103.67.158.83', '1695883200', '__ci_last_regenerate|i:1695883200;'), ('implelb6npua198d4cof3e88cf0d9mac', '103.67.158.84', '1695883203', '__ci_last_regenerate|i:1695883203;'), ('rbehac5nnspmie3mi2ttr4d0l7as098r', '103.67.158.83', '1695883204', '__ci_last_regenerate|i:1695883204;'), ('unc1034rceelspjv0ckab924pikokjql', '103.67.158.84', '1695883207', '__ci_last_regenerate|i:1695883207;'), ('3mqrt5cjh8e6fjf1f0ao9rdffbrvs6fr', '103.67.158.84', '1695883210', '__ci_last_regenerate|i:1695883210;'), ('q3neoihjr7p1f12dluob71kc32hkscdj', '103.67.158.84', '1695883210', '__ci_last_regenerate|i:1695883210;'), ('qleslmn49t91mu6gggprg7lki149gc1c', '103.67.158.84', '1695883210', '__ci_last_regenerate|i:1695883210;'), ('88vmrv6bmct0gk5b6t595qr36mtgm79f', '103.67.158.84', '1695883214', '__ci_last_regenerate|i:1695883214;'), ('c6v1v42c8scns4vmkab6nleq8eveokfp', '103.67.158.84', '1695885134', '__ci_last_regenerate|i:1695885134;'), ('4ir37jn8u267q63unogvlm3a3dq171p0', '103.67.158.84', '1695885137', '__ci_last_regenerate|i:1695885137;'), ('37p9t9pk96jus0m69fe8j0eanno7502t', '103.67.158.84', '1695885138', '__ci_last_regenerate|i:1695885138;'), ('m6gf6mc8m6r4luoql80ue30lk0j7ednp', '103.67.158.85', '1695885142', '__ci_last_regenerate|i:1695885142;'), ('bfi27kti7fjn1323maqefhnq5ht4h3jr', '103.67.158.85', '1695885142', '__ci_last_regenerate|i:1695885142;'), ('ee6ckf66kssjm69jc11uktvu4ad53l4n', '103.67.158.85', '1695885142', '__ci_last_regenerate|i:1695885142;'), ('vsh4napf2mjqj1uou0i2nishn343f6to', '103.67.158.85', '1695885142', '__ci_last_regenerate|i:1695885142;'), ('4qrjjriop20df4oifh22h1frogiciof9', '103.67.158.85', '1695885142', '__ci_last_regenerate|i:1695885142;'), ('guvbmh67lojhip28ks9ina42lod1tvi8', '103.67.158.85', '1695885142', '__ci_last_regenerate|i:1695885142;'), ('m3hn9fl1t7n3ha7j98rhbteeib87327g', '103.67.158.85', '1695885151', '__ci_last_regenerate|i:1695885151;'), ('1ol209ai8nc874plftgkm3qctu010k8u', '103.67.158.85', '1695885154', '__ci_last_regenerate|i:1695885154;'), ('kadpthjqtmsskrv2sfulgus4g2irtm8p', '103.67.158.85', '1695885154', '__ci_last_regenerate|i:1695885154;'), ('7319f7c1ptr9ug4l2ros5rthok8npsg8', '103.67.158.85', '1695885154', '__ci_last_regenerate|i:1695885154;'), ('v4egj7h7st3e2d8tu4veqb0p1dva5m60', '103.67.158.85', '1695885154', '__ci_last_regenerate|i:1695885154;'), ('duvvoabc8q43j32vs1s6pkrsauhfetnc', '103.67.158.85', '1695885154', '__ci_last_regenerate|i:1695885154;'), ('366d9nsvqrb6vmm5qqi37oe60qi4f03j', '103.67.158.85', '1695885154', '__ci_last_regenerate|i:1695885154;'), ('kjhtiufmon9606usnksplvn7d7p1mfrr', '103.67.158.85', '1695885154', '__ci_last_regenerate|i:1695885154;'), ('t3fu3vkq30ul1c6o82458n0ceqjaatfl', '103.67.158.85', '1695885154', '__ci_last_regenerate|i:1695885154;'), ('67j6es9k432vlbu2aghc7vbffkdr3ma4', '103.67.158.85', '1695885154', '__ci_last_regenerate|i:1695885154;'), ('jigap4l4dbdk5gn9fm5k6bveklglebve', '103.67.158.85', '1695885154', '__ci_last_regenerate|i:1695885154;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('di2j4bsh0s2rg8chpom8jgjur46i9fbt', '103.67.158.85', '1695885161', '__ci_last_regenerate|i:1695885161;'), ('l8ijhh3pt70qrrifk9hirln3jm48hqui', '103.67.158.85', '1695885186', '__ci_last_regenerate|i:1695885186;'), ('9aq93qp3gar8dfamb13pht4nt4g12m74', '103.67.158.85', '1695885186', '__ci_last_regenerate|i:1695885186;'), ('euvni0hm78bi72pm9ararujap5ab59tq', '103.67.158.85', '1695885186', '__ci_last_regenerate|i:1695885186;'), ('p95qok657j5sg1lpu52432ihsk4p0bgr', '103.67.158.85', '1695885186', '__ci_last_regenerate|i:1695885186;'), ('63g3iolaous5ipqnreuc26ktkfhju79i', '103.67.158.85', '1695885187', '__ci_last_regenerate|i:1695885187;'), ('sf6h3cbd2u2niup2p8u673nh36tp2cpi', '103.67.158.85', '1695885191', '__ci_last_regenerate|i:1695885191;'), ('j7of20o3j5gcng4agop16q11gbbm12op', '103.67.158.85', '1695885191', '__ci_last_regenerate|i:1695885191;'), ('n8g1mnrv125969glbnodb7ldpq2vto13', '103.67.158.85', '1695885191', '__ci_last_regenerate|i:1695885191;'), ('ktgm6ubfajjuj962q5sjoctfp9qah3dk', '103.67.158.85', '1695885191', '__ci_last_regenerate|i:1695885191;'), ('ovhmsg3v88nsvaop0efm0ukokbtdqg2u', '103.67.158.85', '1695885191', '__ci_last_regenerate|i:1695885191;'), ('6mi6fqicf21b15f7n45opc1ns94qnjqh', '103.67.158.85', '1695885199', '__ci_last_regenerate|i:1695885199;'), ('4h88gd8lslg4hah9ejiktrcgjqf9gmef', '103.67.158.83', '1695885308', '__ci_last_regenerate|i:1695885308;'), ('70ac2j4650eot2isaituo38p548du3fh', '103.67.158.83', '1695885308', '__ci_last_regenerate|i:1695885308;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('7qkop3rln7fl1ev11tm19s0h814uee0f', '103.67.158.86', '1695885308', '__ci_last_regenerate|i:1695885308;'), ('djo5af1g8eppepo4k9iafjbclab8mj3u', '103.67.158.86', '1695885309', '__ci_last_regenerate|i:1695885309;'), ('q9k4bfgadqhiqpc2mpp29qft1rrl4e8p', '103.67.158.83', '1695885310', '__ci_last_regenerate|i:1695885310;'), ('p0cb8mvhbkteb8hacu8le32fl6t5gr68', '103.67.158.83', '1695885310', '__ci_last_regenerate|i:1695885310;'), ('kphns1nbb8hk0c7ulnplau4bl0du3gto', '103.67.158.83', '1695885310', '__ci_last_regenerate|i:1695885310;'), ('349u5kauaa663jhv18l8llg7jsojqfp3', '103.67.158.83', '1695885310', '__ci_last_regenerate|i:1695885310;'), ('13tufoebl7pdoimb88grvb511bbc9gau', '103.67.158.83', '1695885310', '__ci_last_regenerate|i:1695885310;'), ('cfn5tfcuruhofgvcboo6vuj8eb86qg3u', '103.67.158.83', '1695885310', '__ci_last_regenerate|i:1695885310;'), ('5jh6oc8jcjo2gqmupodbm9lh8pl9og98', '103.67.158.83', '1695885310', '__ci_last_regenerate|i:1695885310;'), ('7n5k9mnp3jvc98uq7d467usn2vjkhsin', '103.67.158.83', '1695885312', '__ci_last_regenerate|i:1695885312;'), ('6taioi6h4d4phqru209nakh5bt49jpge', '103.67.158.83', '1695885312', '__ci_last_regenerate|i:1695885312;'), ('o05il1n9p1k3jjesosn34raoqo214sqp', '103.67.158.83', '1695885312', '__ci_last_regenerate|i:1695885312;'), ('7tp066ug6cs0g12adis7jc52gaeshoai', '103.67.158.83', '1695885312', '__ci_last_regenerate|i:1695885312;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('8j3291falukq9dnhkel5gb659b31makf', '103.67.158.83', '1695885314', '__ci_last_regenerate|i:1695885314;'), ('kb6fs9ghseciu16elbrcvbbhkqfrjasd', '103.67.158.83', '1695885331', '__ci_last_regenerate|i:1695885331;'), ('ijam126reqpabgas2ik0os6u88bhk7el', '103.67.158.85', '1695885452', '__ci_last_regenerate|i:1695885452;'), ('clji27173c207n8knutfba24s3398dac', '103.67.158.85', '1695885452', '__ci_last_regenerate|i:1695885452;'), ('2t9pcg7csd2uisc3l41ul7sm5b0sat7e', '103.67.158.85', '1695885452', '__ci_last_regenerate|i:1695885452;'), ('3fmov42daju4furqt16o6du2sb3c5ma8', '103.67.158.85', '1695885455', '__ci_last_regenerate|i:1695885455;'), ('uu5t18ebi0djkv58449dho4pc38os3kl', '103.67.158.85', '1695885460', '__ci_last_regenerate|i:1695885460;'), ('2dccl1ncmuhbkfc5teq0gc1ib7kdhth4', '103.67.158.83', '1695885461', '__ci_last_regenerate|i:1695885461;'), ('hrr72m30kcbcvftnh58r2mpahdp08ve6', '103.67.158.83', '1695885461', '__ci_last_regenerate|i:1695885461;'), ('rgmdmqrnoli3of1ud8uus91j7lg1dcbg', '103.67.158.83', '1695885461', '__ci_last_regenerate|i:1695885461;'), ('v1u0ajggjksm3t7hmemg0pvjqueidob4', '103.67.158.83', '1695885461', '__ci_last_regenerate|i:1695885461;'), ('86qko0p29rb529mbmutpu1j4qmutr0ug', '103.67.158.83', '1695885461', '__ci_last_regenerate|i:1695885461;'), ('qskg6j1j0apr9efqeu7pdsel75hbvuga', '103.67.158.83', '1695885465', '__ci_last_regenerate|i:1695885465;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('9u5ob2h4q06a0qcolkltul8gq6vfnstd', '103.67.158.84', '1695885531', '__ci_last_regenerate|i:1695885531;'), ('j5bt4kennkckcqaak3jdn3o1licdmibu', '103.67.158.84', '1695885532', '__ci_last_regenerate|i:1695885532;'), ('qehfra2b1q41tnnv9s1s1rkgj3pv9gg2', '103.67.158.84', '1695885532', '__ci_last_regenerate|i:1695885532;'), ('1ocuuujf25s26uhd5r8937r01dqod1vr', '103.67.158.84', '1695885532', '__ci_last_regenerate|i:1695885532;'), ('dbsc9b458dejvhph99jeapbb36sjh51o', '103.67.158.84', '1695885532', '__ci_last_regenerate|i:1695885532;'), ('au3gb4rvufaer6n4oaj4djn2m9od9meh', '103.67.158.84', '1695885532', '__ci_last_regenerate|i:1695885532;'), ('qei2edps7i8lso6a5rvrm1h6jjv25s7p', '103.67.158.84', '1695885532', '__ci_last_regenerate|i:1695885532;'), ('08inrn0qfiucc853m3k92ne83m5jbhfr', '103.67.158.83', '1695885572', '__ci_last_regenerate|i:1695885572;'), ('m4nnkuvsm3vce20g1mael6c19ao4d6re', '103.67.158.83', '1695885572', '__ci_last_regenerate|i:1695885572;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('4gtucja991daa189elqa2s56ecbrb133', '103.67.158.83', '1695885574', '__ci_last_regenerate|i:1695885574;'), ('cg4115devb5p4ohn0vl3d165d32m8jft', '103.67.158.83', '1695885575', '__ci_last_regenerate|i:1695885575;'), ('0akdg5ddbnb45ppk84mf362ofgo7ab7l', '103.67.158.83', '1695885575', '__ci_last_regenerate|i:1695885575;'), ('u873alrjs326q0id1t1cfct00557nb75', '103.67.158.84', '1695885578', '__ci_last_regenerate|i:1695885578;'), ('nbfbe39ruure1mn34a2jiv5mc7g6q3m3', '103.67.158.84', '1695885578', '__ci_last_regenerate|i:1695885578;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('hv3bukl53nfe6ridl4sdm1no8da6jaov', '103.67.158.83', '1695885579', '__ci_last_regenerate|i:1695885579;'), ('lnvdeqgvkj343ueb1v3negbnqdjuccbi', '103.67.158.85', '1695885587', '__ci_last_regenerate|i:1695885587;'), ('jhqde0rljioruk0tgbnf2qniuli4s05g', '103.67.158.85', '1695885588', '__ci_last_regenerate|i:1695885588;'), ('af4vh2apam7igr53820hc36caguordqg', '103.67.158.85', '1695885588', '__ci_last_regenerate|i:1695885588;'), ('82an2ub86fkv4it9rgbb7bo724qur028', '103.67.158.85', '1695885588', '__ci_last_regenerate|i:1695885588;'), ('rssaj1c8fo28mklsq70fejm4gqr49m9l', '103.67.158.85', '1695885588', '__ci_last_regenerate|i:1695885588;'), ('5hoie6sfg479vnao6497iga57sqk5obo', '103.67.158.85', '1695885588', '__ci_last_regenerate|i:1695885588;'), ('i0eqhub6o973f0qugmmbjt55maprkril', '103.67.158.85', '1695885588', '__ci_last_regenerate|i:1695885588;'), ('t79948u6jvh19s71qjvah7316a6mtihl', '103.67.158.85', '1695885588', '__ci_last_regenerate|i:1695885588;'), ('dtq3l0rju677vtdv8llvnuc8hqqe3bc4', '103.67.158.85', '1695885590', '__ci_last_regenerate|i:1695885590;'), ('dq2g9od3hgndo0ir6fm4osjm97geugfi', '103.67.158.83', '1695885591', '__ci_last_regenerate|i:1695885591;'), ('v9nf9iptdrb8dtimfnn92ss1s3c57hij', '103.67.158.83', '1695885591', '__ci_last_regenerate|i:1695885591;'), ('865skg38ur1u38eh65rr2imnhgt2lebo', '103.67.158.83', '1695885591', '__ci_last_regenerate|i:1695885591;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('81sfsfich0unb9j6r7di6fjk52tfulrr', '103.67.158.83', '1695885591', '__ci_last_regenerate|i:1695885591;'), ('uhsofmkm997g23n2d8smp9o16e2m1tt6', '103.67.158.83', '1695885608', '__ci_last_regenerate|i:1695885608;'), ('9uvqs1vgmvn8s971rc7lfelale6t45dj', '103.67.158.83', '1695885672', '__ci_last_regenerate|i:1695885672;'), ('ifa30kik4umjaamvht2si9cud6g0hvqd', '103.67.158.84', '1695885835', '__ci_last_regenerate|i:1695885835;'), ('4pmlcr9st3nt6if0p4pgf48hndej89uh', '103.67.158.84', '1695885855', '__ci_last_regenerate|i:1695885855;'), ('daibjsq8co1udak4kcv2akqakkbuvhab', '103.67.158.83', '1695886363', '__ci_last_regenerate|i:1695886363;'), ('fprfh9d3titnjelvdhlpg8ggha3mbmfb', '103.67.158.83', '1695886363', '__ci_last_regenerate|i:1695886363;'), ('cb7mahn9tvv6npf5k9436t6ac2iggiud', '103.67.158.83', '1695886363', '__ci_last_regenerate|i:1695886363;'), ('q0khl432aenbrou2rdium94vl5nvsjt5', '103.67.158.83', '1695886363', '__ci_last_regenerate|i:1695886363;'), ('gq36kraa8eod7s1tpu1ebmd5bqg481bc', '103.67.158.83', '1695886363', '__ci_last_regenerate|i:1695886363;'), ('4me0hqh9n0bh2j8o6jhord7d14pfvu96', '103.67.158.83', '1695886363', '__ci_last_regenerate|i:1695886363;'), ('v5fo6oiefbt6q6958sadg0oqvc7nieau', '103.67.158.84', '1695886365', '__ci_last_regenerate|i:1695886365;'), ('d4t4366j0b7urnkhhvtd4b2u67pcfvc6', '103.67.158.84', '1695886365', '__ci_last_regenerate|i:1695886365;'), ('69pq1htsa473ctqpo05cqqpag2lklgbn', '103.67.158.84', '1695886365', '__ci_last_regenerate|i:1695886365;'), ('lg2s8qgl97kdgki3pdi6gkhddbt98tbc', '103.67.158.84', '1695886365', '__ci_last_regenerate|i:1695886365;'), ('u2vh6ror5c9kk17kgcushh2puia9j90i', '103.67.158.84', '1695886365', '__ci_last_regenerate|i:1695886365;'), ('iu6ic33tov8nds9vja9vo6lbee2sfm39', '103.67.158.84', '1695886365', '__ci_last_regenerate|i:1695886365;'), ('krnpjlpvjuv6hck202eidt7pu251cvr8', '103.67.158.84', '1695886365', '__ci_last_regenerate|i:1695886365;'), ('vdaup40bj0brqhd8ov9ft3fh4clrv7uk', '103.67.158.80', '1695886369', '__ci_last_regenerate|i:1695886369;'), ('pu308ukl3tnvogvdfv6mkdep1seahi1n', '103.67.158.84', '1695886369', '__ci_last_regenerate|i:1695886369;'), ('m5fnionjcbb55vgt1lr80ane404lflve', '103.67.158.86', '1695886369', '__ci_last_regenerate|i:1695886369;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('fk3vpi4pn86lnas59amk3lutch5dvp5e', '103.67.158.80', '1695886373', '__ci_last_regenerate|i:1695886373;'), ('kcepbf3gg13bq0v16ma51de4ma5vg5r2', '103.67.158.80', '1695886373', '__ci_last_regenerate|i:1695886373;'), ('bbfsrl32ch42oj91gcgcsffsuf6aknd5', '103.67.158.84', '1695886402', '__ci_last_regenerate|i:1695886402;'), ('vecdercvgqrvsntpn2hdkin6grvfv7v8', '103.67.158.84', '1695886405', '__ci_last_regenerate|i:1695886405;'), ('ivie41708kso6s1n6vfl2lpljgth0h3g', '103.67.158.84', '1695886405', '__ci_last_regenerate|i:1695886405;'), ('e52g4ifglv66prod16ing65dj9n2cp1c', '103.67.158.84', '1695886405', '__ci_last_regenerate|i:1695886405;'), ('praln192ru0d4ij0uuu9qnfa5vhn7d4c', '103.67.158.84', '1695886405', '__ci_last_regenerate|i:1695886405;'), ('2jmd16rfdc4p7184bblt2h01e8i4iqtm', '103.67.158.84', '1695886405', '__ci_last_regenerate|i:1695886405;'), ('vo0npvhqnhfvgue760om2hmbl5h1q6r1', '103.67.158.84', '1695886406', '__ci_last_regenerate|i:1695886406;'), ('erktqj0jqsffl8j8vjf1msn0ob2fq3s7', '103.67.158.84', '1695886406', '__ci_last_regenerate|i:1695886406;'), ('jnkfmm3iv5i6la11bkluth51m4h40vgv', '103.67.158.84', '1695886408', '__ci_last_regenerate|i:1695886408;'), ('hvp43hg3u3fgnrdvuk463pkgtua7h4h1', '103.67.158.84', '1695886416', '__ci_last_regenerate|i:1695886416;'), ('l3gtp24lmdhgpjv88n4tkdrj4ehlsgmn', '103.67.158.84', '1695886419', '__ci_last_regenerate|i:1695886419;'), ('v5th144n9idoo2aj843f873bnrqbe76t', '103.67.158.84', '1695886419', '__ci_last_regenerate|i:1695886419;'), ('sm5lskse3439suf9plp7qh29p2clobnu', '103.67.158.84', '1695886419', '__ci_last_regenerate|i:1695886419;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ca87jgpfkj9arndg0bukulmkqtm7g40j', '103.67.158.84', '1695886419', '__ci_last_regenerate|i:1695886419;'), ('b6sp5icdng428fn26uj18jqeupa6umkl', '103.67.158.85', '1695886421', '__ci_last_regenerate|i:1695886421;'), ('oh0jdl49kuk42ahr9tb5lsesg39qh2om', '103.67.158.85', '1695886432', '__ci_last_regenerate|i:1695886432;'), ('f0ov56avfrj7tgvguf6qhtcbiott59dr', '103.67.158.85', '1695886432', '__ci_last_regenerate|i:1695886432;'), ('3jse4b4s9c8hetndr5ta6do1o9ef7jrc', '103.67.158.85', '1695886432', '__ci_last_regenerate|i:1695886432;'), ('ovncdgklqjt78g3k52vve9fi4b60aava', '103.67.158.85', '1695886432', '__ci_last_regenerate|i:1695886432;'), ('drmnetbcljc40pnms7feu35r2c94mrgb', '103.67.158.85', '1695886432', '__ci_last_regenerate|i:1695886432;'), ('v7nr6sikbcpsj8ghkpsrh3bvu21fp72s', '103.67.158.85', '1695886432', '__ci_last_regenerate|i:1695886432;'), ('uk9dpd5vu11b4kgosr8adiqa2eunh5pu', '103.67.158.85', '1695886436', '__ci_last_regenerate|i:1695886436;'), ('plile49a594sdrdcbkla9mr14md3fug8', '103.67.158.83', '1695886444', '__ci_last_regenerate|i:1695886444;'), ('5bke14843pmoh8qbpe65p4vdiakr8jpo', '103.67.158.83', '1695886444', '__ci_last_regenerate|i:1695886444;'), ('4gt164oo3nbaf95apd78s6ipfqj4e919', '103.67.158.83', '1695886444', '__ci_last_regenerate|i:1695886444;'), ('9h5rnucm862e0vsr2pgim5vgh4vd0vkr', '103.67.158.83', '1695886444', '__ci_last_regenerate|i:1695886444;'), ('035hs7rnef9fthnv4k92mjgrsb5obor3', '103.67.158.83', '1695886444', '__ci_last_regenerate|i:1695886444;'), ('tdumm7gr0e12ksn0dusek9hh8oakdlk2', '103.67.158.85', '1695886493', '__ci_last_regenerate|i:1695886493;'), ('ve5qo9i0ti9gur8rl76vj90i54qtlpcc', '103.67.158.85', '1695886493', '__ci_last_regenerate|i:1695886493;'), ('mqolcjbhljvtf30iomiioj10p025nbpp', '103.67.158.85', '1695886493', '__ci_last_regenerate|i:1695886493;'), ('8gcsfm8nsfltmh61kcrsg34jssh8c3bg', '103.67.158.85', '1695886493', '__ci_last_regenerate|i:1695886493;'), ('9hubpr38ach6qp13sdd50kbqm7k0uv6r', '103.67.158.85', '1695886493', '__ci_last_regenerate|i:1695886493;'), ('ntdk9do89jchao0h6chsdp7lrj98eapo', '103.67.158.85', '1695886493', '__ci_last_regenerate|i:1695886493;'), ('fagipi6h7j918elmnmjajot3pq8nqass', '103.67.158.85', '1695886501', '__ci_last_regenerate|i:1695886501;'), ('h4l7rcoefro2e6jpngcq5tfkkrd4e33d', '103.67.158.85', '1695886502', '__ci_last_regenerate|i:1695886502;'), ('6novt29avm5vhqps8i4l1knh85a0piv3', '103.67.158.85', '1695886502', '__ci_last_regenerate|i:1695886502;'), ('pmhnf9lv1m5pk2769h014775728jjotv', '103.67.158.85', '1695886502', '__ci_last_regenerate|i:1695886502;'), ('ue1uojsq5chm9qto45trl5v651o52aic', '103.67.158.85', '1695886502', '__ci_last_regenerate|i:1695886502;'), ('dvmfsi6hvjslvjvhf2f61up8f17glhu8', '103.67.158.85', '1695886502', '__ci_last_regenerate|i:1695886502;'), ('imei1ddt1ohdj7536jmcjisg3k3il736', '103.67.158.85', '1695886502', '__ci_last_regenerate|i:1695886502;'), ('vq93bp68d550p4m6eidn5u4pjjjb58pk', '103.67.158.85', '1695886504', '__ci_last_regenerate|i:1695886504;'), ('mcveeh0lcji39pranbe3i7v977g6vhiq', '103.67.158.85', '1695886504', '__ci_last_regenerate|i:1695886504;'), ('l39bkl96q773tkbiko06fskj1ejnt1mt', '103.67.158.85', '1695886505', '__ci_last_regenerate|i:1695886505;'), ('gnamo00koj06nmichlna2j6anuc5leos', '103.67.158.85', '1695886506', '__ci_last_regenerate|i:1695886506;'), ('dm6co8glp6ibhv2hag2upjpm5nvlup3q', '103.67.158.85', '1695886506', '__ci_last_regenerate|i:1695886506;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('t8ni3qik1sp9httsfgqhma0p6189op1a', '103.67.158.85', '1695886506', '__ci_last_regenerate|i:1695886506;'), ('lpjb0asg9nf2ltq4h5o5f3jjadq257c6', '103.67.158.85', '1695886506', '__ci_last_regenerate|i:1695886506;'), ('6piu7fjdch9n9a4pdcmuommvjde5ut55', '103.67.158.85', '1695886506', '__ci_last_regenerate|i:1695886506;'), ('j6j14sav3kbjr2mm82177ndamo2cfob8', '103.67.158.85', '1695886506', '__ci_last_regenerate|i:1695886506;'), ('jg6klh912meabgo0jkoh4q4sqmp3ddg2', '103.67.158.85', '1695886506', '__ci_last_regenerate|i:1695886506;'), ('l8qs6ed47o73cn01qdb87dha6m5rc8qc', '103.67.158.85', '1695886506', '__ci_last_regenerate|i:1695886506;'), ('dacs519ml42rajfodjl9rlt6r39l49it', '103.67.158.85', '1695886506', '__ci_last_regenerate|i:1695886506;'), ('mskuthsmfe9i36joj30cpf1hk48vvu2t', '103.67.158.85', '1695886506', '__ci_last_regenerate|i:1695886506;'), ('7pv5o32n3jvsnhppkh4hr52kn6sog16b', '103.67.158.82', '1695886509', '__ci_last_regenerate|i:1695886509;'), ('leheu44a2bsq703p31b2c13nm0cgo8s9', '103.67.158.82', '1695886523', '__ci_last_regenerate|i:1695886523;'), ('06k0v9lqg733pn7aqbap5s0slvq77fdb', '103.67.158.82', '1695886524', '__ci_last_regenerate|i:1695886524;'), ('ms1osger5v480mh2l71s51avp9sdk0e7', '103.67.158.82', '1695886524', '__ci_last_regenerate|i:1695886524;'), ('rgr2jac9mojhug4fo67peod0fr3sa6mg', '103.67.158.82', '1695886524', '__ci_last_regenerate|i:1695886524;'), ('3k34mpji9unbs8fhbctbcpfaj102hkl4', '103.67.158.82', '1695886524', '__ci_last_regenerate|i:1695886524;'), ('kstq5dmue15i6sm7q97hlq155slrehk0', '103.67.158.82', '1695886525', '__ci_last_regenerate|i:1695886525;'), ('6m5dfuhsqajejcso37mkobcch0sa0tbj', '103.67.158.87', '1695886529', '__ci_last_regenerate|i:1695886529;'), ('3jipmjthep8e0740jv155ee0u944sa94', '103.67.158.87', '1695886529', '__ci_last_regenerate|i:1695886529;'), ('eikbk6mtg0lrm923beq08hpobjqss0eh', '103.67.158.87', '1695886529', '__ci_last_regenerate|i:1695886529;'), ('vjpq0d4kpr26i0todjm1rarhfopojioc', '103.67.158.87', '1695886529', '__ci_last_regenerate|i:1695886529;'), ('inhnj601t2su8a9jlb7e211ohor99m42', '103.67.158.87', '1695886529', '__ci_last_regenerate|i:1695886529;'), ('dsle8dlkl2glg6fuide7k33ok29ko29t', '103.67.158.87', '1695886529', '__ci_last_regenerate|i:1695886529;'), ('bpkou4n1a1tjsuj7h9b7q27ncue8pmj7', '103.67.158.87', '1695886529', '__ci_last_regenerate|i:1695886529;'), ('be89anombolj7n110ne2njemuc97j3j9', '103.67.158.87', '1695886533', '__ci_last_regenerate|i:1695886533;'), ('bhmatjhamsam9s1hpafg3dosu75qjur9', '103.67.158.80', '1695886552', '__ci_last_regenerate|i:1695886552;'), ('11s09pgn81eihd4md5hsonlr4vpsp2cg', '103.67.158.80', '1695886552', '__ci_last_regenerate|i:1695886552;'), ('5fl515hs3o2cvndofq1fq7pfnj996s3p', '103.67.158.80', '1695886552', '__ci_last_regenerate|i:1695886552;'), ('0jpgs5jk8tec9fehur66fkqtfh2egosm', '103.67.158.80', '1695886552', '__ci_last_regenerate|i:1695886552;'), ('oamrgmijums7jrppbnhmfj3sa9lupbdp', '103.67.158.80', '1695886552', '__ci_last_regenerate|i:1695886552;'), ('v5trfssgmou15ckigl33ajsr9cosu0tc', '103.67.158.80', '1695886552', '__ci_last_regenerate|i:1695886552;'), ('lf2df4ni0ebccsa4bb25063gilva3c1h', '103.67.158.80', '1695886552', '__ci_last_regenerate|i:1695886552;'), ('25l2r1rbokd2f28mmhgsp80kcm8jqbvu', '103.67.158.80', '1695886553', '__ci_last_regenerate|i:1695886553;'), ('mohj1m76e6tjcet2vrb0ptr36pruen2c', '103.67.158.80', '1695886555', '__ci_last_regenerate|i:1695886555;'), ('e6ob2vv4uad1m6eh29psiuifng8u8mvs', '103.67.158.80', '1695886555', '__ci_last_regenerate|i:1695886555;'), ('dgisrmj26ssb6vid70es0ed933r5hfso', '103.67.158.80', '1695886555', '__ci_last_regenerate|i:1695886555;'), ('9pr5k4kdh9qjth9tl90afvha635479ca', '103.67.158.80', '1695886556', '__ci_last_regenerate|i:1695886556;'), ('n61vd0sp1gq1o6nqbe1a4l00l4lt1igr', '103.67.158.80', '1695886558', '__ci_last_regenerate|i:1695886558;'), ('2tn3j89sibv8bv1b3duccb9ll55jf3ae', '103.67.158.80', '1695886558', '__ci_last_regenerate|i:1695886558;'), ('r5qibo6c9nnmt460rkdh504s1ljqm54u', '103.67.158.80', '1695886561', '__ci_last_regenerate|i:1695886561;'), ('qmp1d35ng0bqbim9ul6r1a4a39egatbi', '103.67.158.80', '1695886561', '__ci_last_regenerate|i:1695886561;'), ('pc1tsrpmrsmrsq0nojor6guubvlh93s1', '103.67.158.80', '1695886561', '__ci_last_regenerate|i:1695886561;'), ('e7h46kio6q7odrnehnau9u48oectrou4', '103.67.158.80', '1695886561', '__ci_last_regenerate|i:1695886561;'), ('ji3npan6rs3gg2g11qnk9duhcc53dfes', '103.67.158.80', '1695886561', '__ci_last_regenerate|i:1695886561;'), ('6o0a13e5tmv4qo3buie84ud4k5pgeqov', '103.67.158.80', '1695886563', '__ci_last_regenerate|i:1695886563;'), ('hsvjq4opst2j2atqrksama57p1cp6d28', '103.67.158.80', '1695886563', '__ci_last_regenerate|i:1695886563;'), ('mp6bieor8s6ajpl8givl5q2mdttoqcc6', '103.67.158.85', '1695886564', '__ci_last_regenerate|i:1695886564;'), ('se7p2vo246s70lcif9obdp548tsjmcc6', '103.67.158.85', '1695886564', '__ci_last_regenerate|i:1695886564;'), ('t75s794qif1gqh6pptval5io1aookv2h', '103.67.158.85', '1695886564', '__ci_last_regenerate|i:1695886564;'), ('qusemun43cri95eagktgccinskri8muh', '103.67.158.85', '1695886564', '__ci_last_regenerate|i:1695886564;'), ('gp9p81bmtnjjhkdgqhjputbb3au7a4sm', '103.67.158.85', '1695886564', '__ci_last_regenerate|i:1695886564;'), ('0veuocvgn21o228afs27jj2dug7snn1h', '103.67.158.85', '1695886564', '__ci_last_regenerate|i:1695886564;'), ('mqgpn3hjjb0se5qsni9fsmvg0bj0re8b', '103.67.158.85', '1695886564', '__ci_last_regenerate|i:1695886564;'), ('jf36nvq2ldsvhlbnl4fqpc4oquqou161', '103.67.158.85', '1695886564', '__ci_last_regenerate|i:1695886564;'), ('j1okeeuvfng6be0s3vgnkp1n9a83pjt5', '103.67.158.85', '1695886564', '__ci_last_regenerate|i:1695886564;'), ('ttp2b6pqdln8s5an1d1bau8kpqidh939', '103.67.158.85', '1695886564', '__ci_last_regenerate|i:1695886564;'), ('s0k05a869vo8sjdlurfe2c277dfl2ccq', '103.67.158.85', '1695886564', '__ci_last_regenerate|i:1695886564;'), ('j2b7ihhvpl7iihqpk92v4eqec39e3nl5', '103.67.158.83', '1695886564', '__ci_last_regenerate|i:1695886564;'), ('ak2qkq1c5h190h9nrht3v54j364eoq32', '103.67.158.83', '1695886568', '__ci_last_regenerate|i:1695886568;'), ('mavcc0m2adpe8vj0nlbma7d2375v1rb6', '103.67.158.83', '1695886569', '__ci_last_regenerate|i:1695886569;'), ('tqqamk4vigdd8r9a0p7gipuf0nhjp3es', '103.67.158.83', '1695886569', '__ci_last_regenerate|i:1695886569;'), ('q512kjokv7f9fpheu020f1lbucnletsv', '103.67.158.83', '1695886569', '__ci_last_regenerate|i:1695886569;'), ('2286qhkj726cbf1o7utb5b5qvsqqcikc', '103.67.158.83', '1695886569', '__ci_last_regenerate|i:1695886569;'), ('isskaspfu8bvsbk437tvlgrp0lvkqrfo', '103.67.158.83', '1695886569', '__ci_last_regenerate|i:1695886569;'), ('jl51k44much4dgputfuh12sd0tcumtja', '103.67.158.83', '1695886569', '__ci_last_regenerate|i:1695886569;'), ('epj7m1pc1p6naijtbbppkj4iselnb572', '103.67.158.83', '1695886569', '__ci_last_regenerate|i:1695886569;'), ('b06q8cc2c5hvsk33pvpgg9cn1rh93lq4', '103.67.158.85', '1695886571', '__ci_last_regenerate|i:1695886571;'), ('4spja7jj9apr9h31p60nhpim8ve6ha65', '103.67.158.85', '1695886571', '__ci_last_regenerate|i:1695886571;'), ('0sv6e978ckt7846gdli5f7qlg5l18on1', '103.67.158.85', '1695886571', '__ci_last_regenerate|i:1695886571;'), ('lsl3vfauegvqqtddjptepntetnq8r3g5', '103.67.158.85', '1695886571', '__ci_last_regenerate|i:1695886571;'), ('s9huu9djtjekhpfn3e9r7drqlkmjeegs', '103.67.158.85', '1695886574', '__ci_last_regenerate|i:1695886574;'), ('i3aq5cprngm0n9smk4gk0ocb619upvce', '103.67.158.84', '1695886580', '__ci_last_regenerate|i:1695886580;'), ('kpuoa5eqmg0th6g5m49981hctrkaeq1j', '103.67.158.84', '1695886599', '__ci_last_regenerate|i:1695886599;'), ('hfgrsps6k6peh61mc6agf5945d65aqaq', '103.67.158.83', '1695886906', '__ci_last_regenerate|i:1695886906;'), ('9t6bddimjvlmuon0n5lfq1kil3ssglkj', '103.67.158.83', '1695886913', '__ci_last_regenerate|i:1695886913;'), ('2g1crg3ta8dt9m8r40d4pvm2e975a834', '176.203.87.245', '1695897029', '__ci_last_regenerate|i:1695897029;'), ('ji2in2e09632s14d1u92adsf86pvpas2', '176.203.87.245', '1695897032', '__ci_last_regenerate|i:1695897032;'), ('l3v07na2e56cqf7geu82gmm0ddceamcm', '176.203.87.245', '1695897032', '__ci_last_regenerate|i:1695897032;'), ('0c1fcus2orjs93brd40pnp92ub0tt8p5', '176.203.87.245', '1695897032', '__ci_last_regenerate|i:1695897032;'), ('37a9cm83r2rlq6mnm53jcth39fau5qcb', '176.203.87.245', '1695897032', '__ci_last_regenerate|i:1695897032;'), ('hlffbtvlpmvhf908tqms6ti7d2dke6bq', '176.203.87.245', '1695897032', '__ci_last_regenerate|i:1695897032;'), ('33l8tdt6t4ihhtns53flgahfrpandlo5', '176.203.87.245', '1695897032', '__ci_last_regenerate|i:1695897032;'), ('84e6r34lanupk1n26r0v9ann3bvutvst', '176.203.87.245', '1695897033', '__ci_last_regenerate|i:1695897033;'), ('h7fis0tkcqka0hi5a9sckuk79dt66unq', '176.203.87.245', '1695897137', '__ci_last_regenerate|i:1695897137;'), ('sbc8dtufmqbjle416t7uj1vmt7k1kg7g', '176.203.87.245', '1695897138', '__ci_last_regenerate|i:1695897138;'), ('dffl8lvoa8pj8jkgt985ojpfd8epnjlc', '176.203.87.245', '1695897138', '__ci_last_regenerate|i:1695897138;'), ('fjm09s0qnt19ase9armlgrspqvpj98ub', '176.203.87.245', '1695897138', '__ci_last_regenerate|i:1695897138;'), ('einjmopalgjl8ctrgkm9i7v1qpk38f5p', '176.203.87.245', '1695897138', '__ci_last_regenerate|i:1695897138;'), ('vjqpappro1n3unn28oa84h48i8h1bpp6', '176.203.87.245', '1695897138', '__ci_last_regenerate|i:1695897138;'), ('hq2il4m9vrqli4e11gd83jradubtuo3i', '176.203.87.245', '1695897138', '__ci_last_regenerate|i:1695897138;'), ('42tl5eji4vurndjuunqeh5728e4fovej', '176.203.87.245', '1695897139', '__ci_last_regenerate|i:1695897139;'), ('bbu777pjmoon66m1l2mm1lkjdncu1n8d', '176.203.87.245', '1695897141', '__ci_last_regenerate|i:1695897141;'), ('4db7j5v7acmmilk3v9dj6358gakl9kam', '176.203.87.245', '1695897142', '__ci_last_regenerate|i:1695897142;'), ('4t42rpi08luagm136psjk5u82pmccv70', '176.203.87.245', '1695897143', '__ci_last_regenerate|i:1695897143;'), ('h541eiukbr1qv4ltt68i6i0dgt82ht5i', '176.203.87.245', '1695897143', '__ci_last_regenerate|i:1695897143;'), ('5v79avqtmmv8ul7h1u6ji6vubfcmtmac', '176.203.87.245', '1695897143', '__ci_last_regenerate|i:1695897143;'), ('gkrnee77m4lmp9k0cahuek774hjs4tdu', '176.203.87.245', '1695897143', '__ci_last_regenerate|i:1695897143;'), ('qk49dbq9fmdu62rst6n24uhi9583m590', '176.203.87.245', '1695897145', '__ci_last_regenerate|i:1695897145;'), ('sq49b5i90ug10aaksg13dli6tvboi17j', '176.203.87.245', '1695897145', '__ci_last_regenerate|i:1695897145;'), ('dmssmq264mul8spddnqk7m4v301rgqnq', '176.203.87.245', '1695897145', '__ci_last_regenerate|i:1695897145;'), ('912rbrcg6f11q1c0jk1mmn7e0uvtihh4', '176.203.87.245', '1695897145', '__ci_last_regenerate|i:1695897145;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('3l0lb9j4p1g49fuq2l6i9tur9cgp0ii3', '176.203.87.245', '1695897148', '__ci_last_regenerate|i:1695897148;'), ('sofm21h3qjpdfs9ropcjkvfd5sp5ceka', '176.203.87.245', '1695897235', '__ci_last_regenerate|i:1695897148;custom_session_limit|i:1696761164;user_id|s:3:\"453\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:12:\"Noman Khalid\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";cart_items|a:0:{}language|s:7:\"english\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('qqoece79g2j7r0eb4335q8mdrq6bga3h', '176.203.87.245', '1695897176', '__ci_last_regenerate|i:1695897176;'), ('bhofcuvjr1faj7r3eup63lggrgof88fa', '176.203.87.245', '1695897183', '__ci_last_regenerate|i:1695897183;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('1du75fjd83qf8vkhilrbb9rr72s7d3si', '176.203.87.245', '1695897183', '__ci_last_regenerate|i:1695897183;'), ('85go0ishhfv7me7mf2e1hj5b8ps36s4k', '176.203.87.245', '1695897183', '__ci_last_regenerate|i:1695897183;'), ('70t0pqu13mf36avvdpdon7umustv3f8f', '176.203.87.245', '1695897183', '__ci_last_regenerate|i:1695897183;'), ('ese1b673pbt149kq2i78a979kaql8cho', '176.203.87.245', '1695897186', '__ci_last_regenerate|i:1695897186;'), ('9it5cralndau2nvs0176s32q3vm4o9u1', '176.203.87.245', '1695897191', '__ci_last_regenerate|i:1695897191;'), ('0ql9hd5lcbbat7f81uiu063prqi5n9k2', '176.203.87.245', '1695897193', '__ci_last_regenerate|i:1695897193;'), ('nuapqbauja4qvqr8g4rof8e8cmsnun2u', '176.203.87.245', '1695897193', '__ci_last_regenerate|i:1695897193;'), ('7cl166cq58gdask5u74gmnq89e701h9u', '176.203.87.245', '1695897194', '__ci_last_regenerate|i:1695897194;'), ('rr5524peoj4j3f6btugf41f6oe0udle5', '176.203.87.245', '1695897194', '__ci_last_regenerate|i:1695897194;'), ('q52pjn6oh2l1q4vqccl9mhoe7nig39mo', '176.203.87.245', '1695897194', '__ci_last_regenerate|i:1695897194;'), ('1qccf8sjos0euneklkb8nht1edrc22qo', '176.203.87.245', '1695897194', '__ci_last_regenerate|i:1695897194;'), ('r8er7v0s27o089s3f7v4jjtot5ga8ujt', '176.203.87.245', '1695897195', '__ci_last_regenerate|i:1695897195;'), ('5v5d5r21t0nunljvpvfh5oarmrfb7use', '176.203.87.245', '1695897201', '__ci_last_regenerate|i:1695897201;'), ('uvo0ch815mqs8gr17ustvgk549i5e931', '176.203.87.245', '1695897201', '__ci_last_regenerate|i:1695897201;'), ('cl1m1l11ndapidlrbmbgfrvroff1t43d', '176.203.87.245', '1695897202', '__ci_last_regenerate|i:1695897202;'), ('scqh4pt98hktfbd2hc5nqdr582r8h62c', '176.203.87.245', '1695897202', '__ci_last_regenerate|i:1695897202;'), ('bibefimp0dtfsdjrnp064249mv7agqt2', '176.203.87.245', '1695897202', '__ci_last_regenerate|i:1695897202;'), ('8o8slm6svmn5he9apqervf7lc90j3q3l', '176.203.87.245', '1695897202', '__ci_last_regenerate|i:1695897202;'), ('d7scjonds4dn89407vgh8c7bijd84h2d', '176.203.87.245', '1695897203', '__ci_last_regenerate|i:1695897203;'), ('g7cr0pro7hkks3fjm103tc1k3js7sq9j', '176.203.87.245', '1695897203', '__ci_last_regenerate|i:1695897203;'), ('isc1ah8n8r1urmmidbdnpk59bspf1utk', '176.203.87.245', '1695897203', '__ci_last_regenerate|i:1695897203;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('8lglqm2stgfnvlm9fc25mm406fs7os97', '176.203.87.245', '1695897203', '__ci_last_regenerate|i:1695897203;'), ('jjdpth57oqo7qgfu5a3p0ks7812n6q6b', '176.203.87.245', '1695897210', '__ci_last_regenerate|i:1695897210;'), ('62imqiv69l9di97qklq12b2ifqpda7pb', '176.203.87.245', '1695897219', '__ci_last_regenerate|i:1695897219;'), ('7s775kiihasr8kmenstsrtlvevu17d0b', '176.203.87.245', '1695897232', '__ci_last_regenerate|i:1695897232;'), ('thb7tebvdsqpe3vq3r21hgv7gb9hk62f', '176.203.87.245', '1695897232', '__ci_last_regenerate|i:1695897232;'), ('7dgnkt9neusadf0ok65fpocbbq10sbnk', '176.203.87.245', '1695897232', '__ci_last_regenerate|i:1695897232;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('mk0kbuaboo4pubn3k9r6u29i5f13rd3j', '176.203.87.245', '1695897232', '__ci_last_regenerate|i:1695897232;'), ('p2gjajag6qf83pcnmtrvdpq6ppa63leh', '176.203.87.245', '1695897235', '__ci_last_regenerate|i:1695897235;'), ('l5987pnvspc383ims2j314m2nkle2tlq', '103.67.158.83', '1695897893', '__ci_last_regenerate|i:1695897893;'), ('iolbta9ctqtp0ttdogjlmpmafo4n8rll', '37.111.223.139', '1695898101', '__ci_last_regenerate|i:1695898101;'), ('u9m11v5u7s6f1a5imiiv347u5a04aj55', '37.111.223.139', '1695898103', '__ci_last_regenerate|i:1695898103;'), ('lp8pcvr8826qmkcl8pc881tvnnqo71bj', '37.111.223.139', '1695898103', '__ci_last_regenerate|i:1695898103;'), ('6niv4n750osv7sj1c1fgsigp6niai2b2', '37.111.223.139', '1695898103', '__ci_last_regenerate|i:1695898103;'), ('utua97qomap3e29o78giovtfehbqv3vq', '37.111.223.139', '1695898103', '__ci_last_regenerate|i:1695898103;'), ('g14i2hfceobonojfst98e27gksab9ubk', '37.111.223.139', '1695898103', '__ci_last_regenerate|i:1695898103;'), ('8sbsmi2014ksbrm8tmjognu3smkl295c', '37.111.223.139', '1695898103', '__ci_last_regenerate|i:1695898103;'), ('gglqkvikdvadhurfeeqngtbi1oaid94u', '37.111.223.139', '1695898104', '__ci_last_regenerate|i:1695898104;'), ('h7994des1eipitl0u26jvpojiatvh6lc', '37.111.223.139', '1695898115', '__ci_last_regenerate|i:1695898115;'), ('5vmm4sj4patu1g4clrttgr81nfbs8igv', '37.111.223.139', '1695898116', '__ci_last_regenerate|i:1695898116;'), ('oihnffnf6qfleqf7jg38q5pmm2bobnsg', '37.111.223.139', '1695898116', '__ci_last_regenerate|i:1695898116;'), ('fumm9qnseq06rqpilbaeu3f0grqhnf68', '37.111.223.139', '1695898116', '__ci_last_regenerate|i:1695898116;'), ('q23pjf8nekqmpsngpls2vcokoiq0o0rc', '37.111.223.139', '1695898116', '__ci_last_regenerate|i:1695898116;'), ('d9ponbghph4706e4epf5sdq2ulq2ol89', '37.111.223.139', '1695898116', '__ci_last_regenerate|i:1695898116;'), ('litiu5bobidoo6lro5im8o4qomh9aako', '37.111.223.139', '1695898116', '__ci_last_regenerate|i:1695898116;'), ('ttlocaflk3a6q5tqtpdgmmu7b98ouonj', '37.111.223.139', '1695898116', '__ci_last_regenerate|i:1695898116;'), ('b0sml4mosabm8cc5q7gfl5iesnh84rt8', '37.111.223.139', '1695898118', '__ci_last_regenerate|i:1695898118;'), ('4867mcmagcv2sc9st7atb74p3vp6gvq6', '37.111.223.139', '1695898118', '__ci_last_regenerate|i:1695898118;'), ('fg5r8c1smptl1dcbcu1sbplocednhkqu', '37.111.223.139', '1695898119', '__ci_last_regenerate|i:1695898119;'), ('0f0ul68vnjgkqplgnu71soutqbtl8dh8', '37.111.223.139', '1695898119', '__ci_last_regenerate|i:1695898119;'), ('6v19bc422go4ikbuf7o08beih1vobqc4', '37.111.223.139', '1695898119', '__ci_last_regenerate|i:1695898119;'), ('9ubjbaq5fgmj96chosifjo3gqg20d9va', '37.111.223.139', '1695898119', '__ci_last_regenerate|i:1695898119;'), ('tja8dg4akhr2puq5kf3gn12uf2msihkr', '37.111.223.139', '1695898119', '__ci_last_regenerate|i:1695898119;'), ('2atqtj7v1s3a5ccvj32mm7c5pdhfgue9', '37.111.223.139', '1695898119', '__ci_last_regenerate|i:1695898119;'), ('6ku7msjbi9c0aip9cgshm276a9pa7aha', '37.111.223.139', '1695898119', '__ci_last_regenerate|i:1695898119;'), ('boj95b6m9eep58u69dlfpc0fals1u2hh', '37.111.223.139', '1695898119', '__ci_last_regenerate|i:1695898119;'), ('enk2sb6r34jd2opqvjpkf23q7o2oog5n', '37.111.223.139', '1695898119', '__ci_last_regenerate|i:1695898119;'), ('92rakfj17h439uj1176lbda3rt1ji9ul', '37.111.223.139', '1695898119', '__ci_last_regenerate|i:1695898119;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('q31vb81mktmmrl8aaidj5v9hvpd7vil0', '37.111.223.139', '1695898122', '__ci_last_regenerate|i:1695898122;'), ('b4rp72qun2kiui5dhr5k635imrtfhbc3', '37.111.223.139', '1695958175', '__ci_last_regenerate|i:1695898122;custom_session_limit|i:1696765218;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";cart_items|a:0:{}language|s:7:\"english\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('1e4s7b2ps089gsdvklsv2eaqcmdqutqv', '103.67.156.128', '1695898134', '__ci_last_regenerate|i:1695898134;'), ('f16ds7203em7h0t4vp7jpi0teo81ncj0', '103.67.156.128', '1695898135', '__ci_last_regenerate|i:1695898135;'), ('7hd33tpvp3qno0cibf4lc7iitveo47oa', '103.67.156.128', '1695898135', '__ci_last_regenerate|i:1695898135;'), ('pcc8i2phb55434u0desodiqv3kapmst3', '103.67.156.128', '1695898135', '__ci_last_regenerate|i:1695898135;'), ('1odtusa4pf984a6mnokjet8t3i94as61', '103.67.156.128', '1695898135', '__ci_last_regenerate|i:1695898135;'), ('5baen703jkm1v4jl3rlgaiuqja4817no', '103.67.156.128', '1695898135', '__ci_last_regenerate|i:1695898135;'), ('7gha4621197fbenvrpl5tgl187v3l6a1', '103.67.156.128', '1695898135', '__ci_last_regenerate|i:1695898135;'), ('ddtgnbpkgjmgpg6ng78i7lgp4b2ma7g4', '103.67.156.128', '1695898208', '__ci_last_regenerate|i:1695898208;'), ('2q5m9n1idkr53rquj4a9euo19d0ufaep', '103.67.156.128', '1695898208', '__ci_last_regenerate|i:1695898208;'), ('kgsk2an3rjg05pldpqbfnmdkk04levak', '103.67.156.128', '1695898208', '__ci_last_regenerate|i:1695898208;'), ('fjv4qf5mqfpi9hrglbh7ohjed738f3md', '103.67.156.128', '1695898208', '__ci_last_regenerate|i:1695898208;'), ('ua05dhs8pedtdsqbtml66jioq4s56j9p', '103.67.156.128', '1695898209', '__ci_last_regenerate|i:1695898209;'), ('lkvcq3h7setjlpi891attc22apegu2tg', '103.67.156.128', '1695898212', '__ci_last_regenerate|i:1695898212;'), ('5mt6ucs91kjdd4m8l96rcfmd6ctrodcq', '103.67.156.128', '1695898212', '__ci_last_regenerate|i:1695898212;'), ('9c29enlcqepein3o4c97c1hq1bekbmgd', '103.67.156.128', '1695898216', '__ci_last_regenerate|i:1695898216;'), ('q9vg5ec1ivgbm5rjcgvgkkh4m5lskltu', '103.67.156.128', '1695898216', '__ci_last_regenerate|i:1695898216;'), ('5kpvc5ah3ajuj1m77f8khi9n2dofsme1', '103.67.156.128', '1695898216', '__ci_last_regenerate|i:1695898216;'), ('jtttuusq5dmnbj36oage6msonedoh6j3', '103.67.156.128', '1695898216', '__ci_last_regenerate|i:1695898216;'), ('nb7qd1gnff1i55ce4v86qppc4sm3qqt3', '103.67.156.128', '1695898216', '__ci_last_regenerate|i:1695898216;'), ('gg25l70elb1er8cq1h52kf2bd2626fr0', '103.67.156.128', '1695898218', '__ci_last_regenerate|i:1695898218;'), ('f4e47rgm72s1glvba68o1h18p9155ml5', '103.67.156.128', '1695898218', '__ci_last_regenerate|i:1695898218;'), ('vc6l4shsno1oiclkhvotko7743rh0jk3', '103.67.156.128', '1695898218', '__ci_last_regenerate|i:1695898218;'), ('69n2a3jhjvp917fgqnbk9jcs3gt0s1sg', '103.67.156.128', '1695898218', '__ci_last_regenerate|i:1695898218;'), ('gf47lkep89537n7hmuq88b8asbv7gg9i', '103.67.156.128', '1695898218', '__ci_last_regenerate|i:1695898218;'), ('9ohj7fsllt6icmp6sclq7tcvl6g1qjp4', '103.67.156.128', '1695898219', '__ci_last_regenerate|i:1695898219;'), ('bmt10g57bas60445btsmtfcul4g69tbk', '103.67.156.128', '1695898219', '__ci_last_regenerate|i:1695898219;'), ('4gj4qb8ei9jf8ntt338g16o7sk0hkj6k', '103.67.156.128', '1695898220', '__ci_last_regenerate|i:1695898220;'), ('geuie38foge4afjqusi3sn04cddonqaa', '103.67.156.128', '1695898220', '__ci_last_regenerate|i:1695898220;'), ('adph7h18u7mp2ms9c5mn673ud1s1kq67', '103.67.156.128', '1695898221', '__ci_last_regenerate|i:1695898221;'), ('m1p735rbf9t3do74j0m9p9i79ksvalv7', '103.67.156.128', '1695898221', '__ci_last_regenerate|i:1695898221;'), ('labvv7arfdukue8kujvkpr097vr18eg5', '103.67.156.128', '1695898223', '__ci_last_regenerate|i:1695898223;'), ('99pqlt2qvuj57861a6n8v0o11jl28pmk', '103.67.156.128', '1695898223', '__ci_last_regenerate|i:1695898223;'), ('bk656k26hvkbgm4i9mqnm4udos9jdokh', '103.67.156.128', '1695898223', '__ci_last_regenerate|i:1695898223;'), ('46efp05l2ji1el377766vnnb5krr9rbt', '103.67.156.128', '1695898223', '__ci_last_regenerate|i:1695898223;'), ('4evkrrioh2l6hit6u27h1j364g11a9cp', '103.67.156.128', '1695898223', '__ci_last_regenerate|i:1695898223;'), ('1sse54hup46okpnulpsjralkifon0uf5', '103.67.156.128', '1695898223', '__ci_last_regenerate|i:1695898223;'), ('rpl0tl4te4qlgf11d9bpcce89pt469l8', '103.67.156.128', '1695898224', '__ci_last_regenerate|i:1695898224;'), ('hb2kocqb306td8ob5f10dhb6jh6lh0jj', '103.67.156.128', '1695898224', '__ci_last_regenerate|i:1695898224;'), ('e1lvufehinec0c8556q2eu9r5a7l3g95', '103.67.156.128', '1695898224', '__ci_last_regenerate|i:1695898224;'), ('0shpq1adh4vka0sb1orkucf6nf2vomn9', '103.67.156.128', '1695898225', '__ci_last_regenerate|i:1695898225;'), ('io2sln3hid6oo4ob9npqlloc28q2me9o', '103.67.156.128', '1695898226', '__ci_last_regenerate|i:1695898226;'), ('9qmvl1k8442u8qptr4p3grqo4jk4rtt6', '103.67.156.128', '1695898226', '__ci_last_regenerate|i:1695898226;'), ('ngre6m6hqdlq8jeegd2c2jccoj9gnfdj', '103.67.156.128', '1695898226', '__ci_last_regenerate|i:1695898226;'), ('9161gfag7478psg6st3fsidtp4bii235', '103.67.156.128', '1695898226', '__ci_last_regenerate|i:1695898226;'), ('j0b2mr7big2a4b0c3795jceels889h2j', '103.67.156.128', '1695898226', '__ci_last_regenerate|i:1695898226;'), ('g7e0rm4kgl3mm8vdh39gs775t84hc6nb', '103.67.156.128', '1695898227', '__ci_last_regenerate|i:1695898227;'), ('sifm3n15p0ckdma5nh7gpjbc6chjg9of', '103.67.156.128', '1695898227', '__ci_last_regenerate|i:1695898227;'), ('amikj6463q45noau81jmi5op3iaad0je', '103.67.156.128', '1695898228', '__ci_last_regenerate|i:1695898228;'), ('tvnipv3ulrmv2hb1om2ula5567v7dmn9', '103.67.156.128', '1695898228', '__ci_last_regenerate|i:1695898228;'), ('mfg1j8d43pbb7lq1m9rn0uvabkm985am', '103.67.156.128', '1695898228', '__ci_last_regenerate|i:1695898228;'), ('pcnoo28krr7ruggo2vrjdr5n140ueto2', '103.67.156.128', '1695898229', '__ci_last_regenerate|i:1695898229;'), ('jmcqpacl8771d31f03m750tko6asp6oh', '103.67.156.128', '1695898229', '__ci_last_regenerate|i:1695898229;'), ('80uhm25bbkhdehceg7so45qvd3t8t5vt', '103.67.156.128', '1695898229', '__ci_last_regenerate|i:1695898229;'), ('8lhhjj2d1b09b2g08h91iq0gi8h3ubcr', '103.67.156.128', '1695898229', '__ci_last_regenerate|i:1695898229;'), ('4tdohkvas2p9mi550iceqkovhsgdrvkc', '103.67.156.128', '1695898230', '__ci_last_regenerate|i:1695898230;'), ('t92hki8f44bk820l7sr5k199n5qfn3p6', '103.67.156.128', '1695898230', '__ci_last_regenerate|i:1695898230;'), ('s414acpji74j26gvc9iebap6unt4bahu', '103.67.156.128', '1695898230', '__ci_last_regenerate|i:1695898230;'), ('9v1pfsja56ee27bbd3j72agmbal4v37d', '103.67.156.128', '1695898230', '__ci_last_regenerate|i:1695898230;'), ('kd0vug5i84jcqoggkkeg30f2sdg7abeb', '103.67.156.128', '1695898230', '__ci_last_regenerate|i:1695898230;'), ('savvpg75fj8c5r23sfcvrmhlve0fr7ar', '103.67.156.128', '1695898232', '__ci_last_regenerate|i:1695898232;'), ('40j5lnke1goqok3i5favuaae8qu74a03', '103.67.156.128', '1695898232', '__ci_last_regenerate|i:1695898232;'), ('vocv1tsf5q7egujald87e9liug0cgla5', '103.67.156.128', '1695898232', '__ci_last_regenerate|i:1695898232;'), ('m0lm8e76prukppodhf2gjq3knukv3lqa', '103.67.156.128', '1695898232', '__ci_last_regenerate|i:1695898232;'), ('l3nsa28cig7llon2mear3v42s316evmr', '103.67.156.128', '1695898232', '__ci_last_regenerate|i:1695898232;'), ('c0arf6jrkj4tacuin8ko54l43a9gnb4t', '103.67.156.128', '1695898232', '__ci_last_regenerate|i:1695898232;'), ('tj78s04f97vq3lo4mcr2micqsf3vvogf', '103.67.156.128', '1695898232', '__ci_last_regenerate|i:1695898232;'), ('ihofvl2mvqkidk1k8ud3mffclfkt4d9j', '103.67.156.128', '1695898233', '__ci_last_regenerate|i:1695898233;'), ('f6ngksot3uni0icrkis7kio64ce66ohr', '103.67.156.128', '1695898233', '__ci_last_regenerate|i:1695898233;'), ('556vdg0jhl8ue52abphs89rlf4om7f3p', '103.67.156.128', '1695898234', '__ci_last_regenerate|i:1695898234;'), ('r85qa9l31cj09rrmfo1ttu06fgnei7tt', '103.67.156.128', '1695898234', '__ci_last_regenerate|i:1695898234;'), ('s97ficuvhsemn7jneaoa56u3hr347oeh', '103.67.156.128', '1695898234', '__ci_last_regenerate|i:1695898234;'), ('374jt4arq4qou93vpd9o15hh945f1ksm', '103.67.156.128', '1695898234', '__ci_last_regenerate|i:1695898234;'), ('ejsanahqrtlai92rqrbl7uspjhgkq9v2', '103.67.156.128', '1695898235', '__ci_last_regenerate|i:1695898235;'), ('0es2i9faos67s2iv8lr0kgamb8b7fvs7', '103.67.156.128', '1695898235', '__ci_last_regenerate|i:1695898235;'), ('hbbqjdbduh2a9gkvscft1uqbtrpsdoiu', '103.67.156.128', '1695898235', '__ci_last_regenerate|i:1695898235;'), ('jcg14417lasa56dob1raairdk7rofpss', '103.67.156.128', '1695898235', '__ci_last_regenerate|i:1695898235;'), ('09qsn2qk60qnvf2d580ak9jjkgt5ta0j', '103.67.156.128', '1695898235', '__ci_last_regenerate|i:1695898235;'), ('dhqiukh7v1ltstidsg4nm5i52cmpig6j', '103.67.156.128', '1695898235', '__ci_last_regenerate|i:1695898235;'), ('2s62s50eqvpaivo8fjlljqk2g1aj4dvr', '103.67.156.128', '1695898237', '__ci_last_regenerate|i:1695898237;'), ('drd5npgaq3s54di134jetnuca6e3ttm1', '103.67.156.128', '1695898238', '__ci_last_regenerate|i:1695898237;'), ('02801i73bnnso78r56hbqe38i8n4v61k', '103.67.156.128', '1695898238', '__ci_last_regenerate|i:1695898238;'), ('3opnaa3kmqrifj1iekdp70jbnocrusi2', '103.67.156.128', '1695898238', '__ci_last_regenerate|i:1695898238;'), ('s3sb5rr19sgpa6mm8nb9me8rvmqb9436', '103.67.156.128', '1695898238', '__ci_last_regenerate|i:1695898238;'), ('ljmt2lbeih86712l1avbua91ehatjmlt', '103.67.156.128', '1695898238', '__ci_last_regenerate|i:1695898238;'), ('bbpl3c0nkit1i85q1bqad6ianqds37rh', '103.67.156.128', '1695898238', '__ci_last_regenerate|i:1695898238;'), ('ofqjha4ft5l1avh6rlel48ti5g8qldga', '103.67.156.128', '1695898239', '__ci_last_regenerate|i:1695898239;'), ('rm5n9jfatuf4gbn1b71ldmp7ur4li429', '103.67.156.128', '1695898239', '__ci_last_regenerate|i:1695898239;'), ('3dfsnk2cjeu71vdd7tg24upupoitace3', '103.67.156.128', '1695898239', '__ci_last_regenerate|i:1695898239;'), ('0av4sc68rib1palb20t6e9m57qgpf8k3', '103.67.156.128', '1695898239', '__ci_last_regenerate|i:1695898239;'), ('siethvjob5i8enlfgcggt0jnl3bqetkc', '103.67.156.128', '1695898239', '__ci_last_regenerate|i:1695898239;'), ('9ks5bvouqvbbl6n5loao3fe2d8h10rqc', '103.67.156.128', '1695898239', '__ci_last_regenerate|i:1695898239;'), ('v07quscvfr34c58hu0726on7ot56o2ab', '103.67.156.128', '1695898239', '__ci_last_regenerate|i:1695898239;'), ('d0cqjht0nc50i6k565vjgnp55f6a6sd8', '103.67.156.128', '1695898355', '__ci_last_regenerate|i:1695898355;'), ('kb7naqog7djf0chjpoe7m4o1qf4qbo8m', '103.67.156.128', '1695898355', '__ci_last_regenerate|i:1695898355;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ncc9qsa9nk1ruve8vq7ojr41ip47d0gr', '103.67.156.128', '1695898356', '__ci_last_regenerate|i:1695898356;'), ('q9oflpqsflubbgbjm85tbtj71itilji0', '103.67.156.128', '1695898357', '__ci_last_regenerate|i:1695898357;'), ('djvht18jlp4ai4t05ropkup0nbbdgl4a', '103.67.156.128', '1695898358', '__ci_last_regenerate|i:1695898358;'), ('tqs2r8e9hu5a0k3ndg7qcmm0knvo507q', '103.67.156.128', '1695898748', '__ci_last_regenerate|i:1695898748;'), ('chvj8l2c4uaaq6f2p8q44g2a38b28hls', '103.67.156.128', '1695898748', '__ci_last_regenerate|i:1695898748;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('sf6tcn2ib1k60d2oj626cn1fm8saqks1', '103.67.156.128', '1695898748', '__ci_last_regenerate|i:1695898748;'), ('fho6ffkpm71nqpk291mm0gvoo0lks3t4', '103.67.156.128', '1695898753', '__ci_last_regenerate|i:1695898753;'), ('3mufafs5s5162smrua06phqnn60bub26', '103.67.156.128', '1695898753', '__ci_last_regenerate|i:1695898753;'), ('k4j9s4l7ajlrv7kfs4anuamfn1eqacva', '103.67.156.128', '1695899712', '__ci_last_regenerate|i:1695899712;'), ('2r1qb8mf16um6mf3in4oatddvbs9l8is', '103.67.156.128', '1695899712', '__ci_last_regenerate|i:1695899712;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('jrg3gdl4bc670rm192l6v9j920jl0hi6', '103.67.156.128', '1695899713', '__ci_last_regenerate|i:1695899713;'), ('19dgbs56hr12oqd84oqnn9mo8lh096sq', '37.111.223.139', '1695901172', '__ci_last_regenerate|i:1695901172;'), ('djju242q709k6qp2oo0vbb6p2akm4he9', '37.111.223.139', '1695901175', '__ci_last_regenerate|i:1695901175;'), ('555sp0u7c1f76uk5nne34sbpt3ipgeku', '37.111.223.139', '1695901175', '__ci_last_regenerate|i:1695901175;'), ('e56o8df4u038q46l2hiogldii58bjjtb', '37.111.223.139', '1695901175', '__ci_last_regenerate|i:1695901175;'), ('hkjvosijviqqpg27qhcc9l24els34oti', '37.111.223.139', '1695901175', '__ci_last_regenerate|i:1695901175;'), ('9sinvhpk5kati2b99mf4cf23dbllhjcg', '37.111.223.139', '1695901175', '__ci_last_regenerate|i:1695901175;'), ('g2tc6q61ourto6q7n1auqeqm4u94s5cn', '37.111.223.139', '1695901175', '__ci_last_regenerate|i:1695901175;'), ('rusauj997qocbu51kgi4ctipv598lktu', '37.111.223.139', '1695901176', '__ci_last_regenerate|i:1695901176;'), ('d64nejfv0hva8ulun9i8liekvuap64h0', '37.111.223.139', '1695901179', '__ci_last_regenerate|i:1695901179;'), ('jqckem7d16020b2souqicdjkttdnnjbf', '37.111.223.139', '1695901200', '__ci_last_regenerate|i:1695901200;'), ('ed7q3i97g82hvpnqcc1f9eudfk5sc4ov', '37.111.223.139', '1695901200', '__ci_last_regenerate|i:1695901200;'), ('kebu0e5drdkin3d5jv9tklc3rpqbpspk', '37.111.223.139', '1695901200', '__ci_last_regenerate|i:1695901200;'), ('u2nl3fqde4h3550lb01lkatnlbs8id5f', '37.111.223.139', '1695901200', '__ci_last_regenerate|i:1695901200;'), ('3ahbm71q2njdghdptdmcn96qf8egiohd', '37.111.223.139', '1695901201', '__ci_last_regenerate|i:1695901201;'), ('r2ittsj3vriulhtmvsjs8ct5m0t9hibc', '37.111.223.139', '1695901202', '__ci_last_regenerate|i:1695901202;'), ('lm0ulb5361vlbp36212g83ovacpb6474', '37.111.223.139', '1695901202', '__ci_last_regenerate|i:1695901202;'), ('oj6u6md8a5mt7bkfas41en8m06retrpn', '37.111.223.139', '1695901202', '__ci_last_regenerate|i:1695901202;'), ('ujgg7ne9ilrd01hb6edpee9f69keogav', '37.111.223.139', '1695901203', '__ci_last_regenerate|i:1695901203;'), ('1s2men6iamlstaqg2fq3n7gu4ls62g14', '37.111.223.139', '1695901203', '__ci_last_regenerate|i:1695901203;'), ('86aq10vkkkpq0a3214imvnoa17pc9rjt', '37.111.223.139', '1695901203', '__ci_last_regenerate|i:1695901203;'), ('s3uo6ne8kh4760r9l160ui2p13f6tmt3', '37.111.223.139', '1695901203', '__ci_last_regenerate|i:1695901203;'), ('40gve31ttstll3slrobmqq17pnk90gk5', '37.111.223.139', '1695901203', '__ci_last_regenerate|i:1695901203;'), ('ldqnporubq0guh60rpfht5gf35ioa9g0', '37.111.223.139', '1695901203', '__ci_last_regenerate|i:1695901203;'), ('s686v12b27on37ce1prhdgdkp9682lpf', '37.111.223.139', '1695901203', '__ci_last_regenerate|i:1695901203;'), ('13939uoab7f6t1g5t0c0efm6bkahhoht', '37.111.223.139', '1695901204', '__ci_last_regenerate|i:1695901204;'), ('l42a98v9o8p4hvgi19qmjp7ma07m0n6b', '37.111.223.139', '1695901205', '__ci_last_regenerate|i:1695901205;'), ('q12q9u35hj2jeu4cu6vutt015a85us7v', '37.111.223.139', '1695901205', '__ci_last_regenerate|i:1695901205;'), ('o7uaglac4gaaddmpmna2prlkqstmh5kc', '37.111.223.139', '1695901205', '__ci_last_regenerate|i:1695901205;'), ('vdvjhvulqjfu16cs37q8i203q248fmae', '37.111.223.139', '1695901205', '__ci_last_regenerate|i:1695901205;'), ('9ulc4daj10dk09fm094ed2cbk94dklcj', '37.111.223.139', '1695901205', '__ci_last_regenerate|i:1695901205;'), ('s5aedi2cd5qg6naidu8655c30htsd2rk', '37.111.223.139', '1695901205', '__ci_last_regenerate|i:1695901205;'), ('oomt4o2vuhj7j3srm0rg3uip2lr338o7', '37.111.223.139', '1695901206', '__ci_last_regenerate|i:1695901206;'), ('bcvbi2i96p7c3e0hvctnfpqlrikqqrc4', '37.111.223.139', '1695901207', '__ci_last_regenerate|i:1695901207;'), ('8gp8fphe4vgdf48me0ghg664srerhj3l', '37.111.223.139', '1695901207', '__ci_last_regenerate|i:1695901207;'), ('pq0l2scvrdbvvilsoi7a31iibejrq43g', '37.111.223.139', '1695901208', '__ci_last_regenerate|i:1695901208;'), ('r16dts7jqlh43qd6gn2ce8ts3aruqgf2', '37.111.223.139', '1695901208', '__ci_last_regenerate|i:1695901207;'), ('onm6q5gra0lj9lh3fnkuv3snl5t5r4df', '37.111.223.139', '1695901208', '__ci_last_regenerate|i:1695901208;'), ('1sr62gm97aqi2m4hg9ni0v16in7ummur', '37.111.223.139', '1695901208', '__ci_last_regenerate|i:1695901208;'), ('7con0ltips25h86msagnu71d5na14mun', '37.111.223.139', '1695901208', '__ci_last_regenerate|i:1695901208;'), ('1vekmibo8lamqtgco3eciebl87a437cf', '37.111.223.139', '1695901208', '__ci_last_regenerate|i:1695901208;'), ('6r95ibn5q3i9a9s4n4ps8npg4vmt250h', '37.111.223.139', '1695901208', '__ci_last_regenerate|i:1695901208;'), ('4e2pad9u1k5m6rbjaeam85vvk1jp5mcp', '37.111.223.139', '1695901208', '__ci_last_regenerate|i:1695901208;'), ('m8dsoqurtn7m8mneo0f4gnrictlcqn7a', '37.111.223.139', '1695901208', '__ci_last_regenerate|i:1695901208;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('uptcol8g92o68n3vqqbhes7btosaae1c', '37.111.223.139', '1695901210', '__ci_last_regenerate|i:1695901210;'), ('k3lop1n1vblj2crqp42f31dvjno89avj', '103.253.47.248', '1695915464', '__ci_last_regenerate|i:1695915464;'), ('kud1948nosl6t1lrd3v7mpvd4cd1ejsq', '103.253.47.248', '1695915469', '__ci_last_regenerate|i:1695915469;'), ('e5c7vts59grl19615t3qdirsltfge0er', '103.253.47.248', '1695915471', '__ci_last_regenerate|i:1695915471;'), ('akio175gtct23uha5l7bj265pq0kc5r1', '103.253.47.248', '1695915471', '__ci_last_regenerate|i:1695915471;'), ('bioqag0moe99j5srt787rgo0d9o3nphb', '103.253.47.248', '1695915471', '__ci_last_regenerate|i:1695915471;'), ('94kpbaquctofnltiinnv9candfk4qqsa', '103.253.47.248', '1695915471', '__ci_last_regenerate|i:1695915471;'), ('ahu8hivf2md7j8jiq29ta4umfd66me41', '103.253.47.248', '1695915472', '__ci_last_regenerate|i:1695915472;'), ('um6udmigjig4nkrmpkmgbbonthu4musd', '103.253.47.248', '1695915473', '__ci_last_regenerate|i:1695915473;'), ('42uks1hchlt0hjnqjah8t9va7i68uls5', '103.253.47.248', '1695915474', '__ci_last_regenerate|i:1695915474;'), ('ub92719cle321bfull88qom1h9tmtljg', '103.253.47.248', '1695915477', '__ci_last_regenerate|i:1695915477;'), ('30uoj0koiqmc81k5k3a6m7ehtuon5f7d', '103.253.47.248', '1695915478', '__ci_last_regenerate|i:1695915478;'), ('b79dlrem45a4kncnt7p5nso3ic14a76t', '103.253.47.248', '1695915479', '__ci_last_regenerate|i:1695915479;'), ('4j6ur4l2v32p3tqriglfunpmm9kpssqe', '103.253.47.248', '1695915479', '__ci_last_regenerate|i:1695915479;'), ('q595gtot4q6mgi25b2lmtbt9lsobqfnb', '103.253.47.248', '1695915479', '__ci_last_regenerate|i:1695915479;'), ('fekaj0ntkiojik6rc9uhcjaec13k78ra', '103.253.47.248', '1695915479', '__ci_last_regenerate|i:1695915479;'), ('m1nlgkpf0ed6og76tb0lkeoie7oufd3s', '103.253.47.248', '1695915479', '__ci_last_regenerate|i:1695915479;'), ('i69hddb7jmpnlsmo9ugrer230j1b0a2e', '103.253.47.248', '1695915479', '__ci_last_regenerate|i:1695915479;'), ('on9ucur6a0sfl0gij77ko855nmtdq2o0', '103.253.47.248', '1695915479', '__ci_last_regenerate|i:1695915479;'), ('vj3empm4td2hlll7ak3r4os82rut8tu7', '103.253.47.248', '1695915480', '__ci_last_regenerate|i:1695915480;'), ('lbib4ncqm41del7ibrq35g7dofhrl6pq', '103.253.47.248', '1695915481', '__ci_last_regenerate|i:1695915481;'), ('0ken4uusulmunb6ge6in7c7p12doop7d', '103.253.47.248', '1695915481', '__ci_last_regenerate|i:1695915481;'), ('9h6d852b6vbvnas7k8ghmnskun1bogj2', '103.253.47.248', '1695915485', '__ci_last_regenerate|i:1695915485;'), ('i4crp2ff1rvlvibh233f4ms5b5uibvtr', '103.253.47.248', '1695915486', '__ci_last_regenerate|i:1695915486;'), ('7fs89uu3iv3sdedmsua8g02mlj2iv7th', '103.253.47.248', '1695915486', '__ci_last_regenerate|i:1695915486;'), ('g2agmfa1q8qtvu16sqc6cdehm09maq5m', '103.253.47.248', '1695915486', '__ci_last_regenerate|i:1695915486;'), ('5obd9fe75g6mmt2dd00i5osouoshbgvf', '103.253.47.248', '1695915487', '__ci_last_regenerate|i:1695915487;'), ('e81raotgaacjj24aq8f0oebqpr2fj3kl', '103.253.47.248', '1695915487', '__ci_last_regenerate|i:1695915487;'), ('nb3elq5je01o0n4cah0mmr2dj543o7p2', '103.253.47.248', '1695915487', '__ci_last_regenerate|i:1695915487;'), ('j94a8a548m04a52k3dakmvv65roolqpe', '103.253.47.248', '1695915487', '__ci_last_regenerate|i:1695915487;'), ('bapngiv4m4ojtqke8bdo4pm8etf0sisa', '103.253.47.248', '1695915487', '__ci_last_regenerate|i:1695915487;'), ('usho42ndummjadobj7msm8qv7dqo6f94', '103.253.47.248', '1695915487', '__ci_last_regenerate|i:1695915487;'), ('ucsi8m7cim577o0ifoc88du4ldpso87n', '103.253.47.248', '1695915487', '__ci_last_regenerate|i:1695915487;'), ('48u898tqsas0kl488ige6svtp606rkqb', '103.253.47.248', '1695915487', '__ci_last_regenerate|i:1695915487;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('silivfaprlk1lans4ov7edc067u4bmg6', '103.253.47.248', '1695915489', '__ci_last_regenerate|i:1695915489;'), ('k4s2dq8jnb61emiktabbc040t80n4pct', '103.253.47.248', '1695915492', '__ci_last_regenerate|i:1695915492;'), ('eed7oo1pcbh1gf1h527dof1e1bt4rr5d', '103.253.47.248', '1695915586', '__ci_last_regenerate|i:1695915586;'), ('5hlaftqji8ao0n1pd28ri06o4so900gh', '103.253.47.248', '1695915587', '__ci_last_regenerate|i:1695915587;'), ('65sv0mmrmuredclhceoopiv7jisrom45', '103.253.47.248', '1695915587', '__ci_last_regenerate|i:1695915587;'), ('oe8h0a76s25e0avq0u1c78e37qgcavvq', '103.253.47.248', '1695915589', '__ci_last_regenerate|i:1695915589;'), ('nslprstbfq7n306l9lv6hbanifnf40g0', '103.253.47.248', '1695915589', '__ci_last_regenerate|i:1695915589;'), ('ft5gbcj13if635dick2f9sfnj6i4gvkd', '103.253.47.248', '1695915589', '__ci_last_regenerate|i:1695915589;'), ('a0ad4vt40u1kq1t85pnbda36kti0o5o5', '103.253.47.248', '1695915589', '__ci_last_regenerate|i:1695915589;'), ('7jbep0jp6b5orescijh8a3d55m52bk17', '103.253.47.248', '1695915589', '__ci_last_regenerate|i:1695915589;'), ('7g8eh6dub0kt7sa07t6b11ipeoviskdn', '103.253.47.248', '1695915590', '__ci_last_regenerate|i:1695915590;'), ('6ro5d7psv7c68c2pi914e086l0110tl8', '103.253.47.248', '1695915591', '__ci_last_regenerate|i:1695915591;'), ('led3et3052130bqh15p3p28mo3r51e0p', '103.253.47.248', '1695915650', '__ci_last_regenerate|i:1695915650;'), ('n4ih359nq7fhrmo4td7b7f8racea6b61', '103.253.47.248', '1695915651', '__ci_last_regenerate|i:1695915651;'), ('4bgg9jtdmh3p2rp2p6ttrpqr3a92ddbb', '103.253.47.248', '1695915652', '__ci_last_regenerate|i:1695915652;'), ('i5309t7b5nggsot4fkppbmqeutg3dbdg', '103.253.47.248', '1695915652', '__ci_last_regenerate|i:1695915652;'), ('jbp05tun26lf390nn1ssgkk3tapug4mq', '103.253.47.248', '1695915652', '__ci_last_regenerate|i:1695915652;'), ('22qbeivehkb82kc5hdnoh032e9cjvjin', '103.253.47.248', '1695915652', '__ci_last_regenerate|i:1695915652;'), ('90oqme8qhcobdktfft7cfnheiphjgfqa', '103.253.47.248', '1695915652', '__ci_last_regenerate|i:1695915652;'), ('kgvqhnddk096jv2hmp92bjd0mm4a4rnn', '103.253.47.248', '1695915652', '__ci_last_regenerate|i:1695915652;'), ('03obbqmnl9e7mri8hq19vo1a9hmdclqk', '103.253.47.248', '1695915652', '__ci_last_regenerate|i:1695915652;'), ('357hr32e4rqe90nshj3aa5jlveb7vuir', '103.253.47.248', '1695915690', '__ci_last_regenerate|i:1695915690;'), ('qk8838l96ptt22m2ntk5pcpqosnl3vfu', '103.253.47.248', '1695915690', '__ci_last_regenerate|i:1695915690;'), ('l0k9fnk50v7hdis3ukd8h7jf8vebl86u', '103.253.47.248', '1695918419', '__ci_last_regenerate|i:1695918419;'), ('8hf54tmds0jnmeoo2jt654lm4l4b83jn', '103.253.47.248', '1695918422', '__ci_last_regenerate|i:1695918422;'), ('dubvrtfk57rvvo2oeoh32igfcds42tj2', '103.253.47.248', '1695918422', '__ci_last_regenerate|i:1695918422;'), ('e7fjb1k4r0j51r3vataqk69v9h8u260k', '103.253.47.248', '1695918422', '__ci_last_regenerate|i:1695918422;'), ('u9bekvgda5sash50ujcc77lmkk5ch42b', '103.253.47.248', '1695918422', '__ci_last_regenerate|i:1695918422;'), ('takkjs8ccqdo6llegbigo3b1bt1iq8tm', '103.253.47.248', '1695918422', '__ci_last_regenerate|i:1695918422;'), ('cphl55nqb9r2qepib3g25c8nb5aj5j4j', '103.253.47.248', '1695918422', '__ci_last_regenerate|i:1695918422;'), ('o3f3v23fnnfsvk6a05g0kvjdnmk9uf8b', '103.253.47.248', '1695918423', '__ci_last_regenerate|i:1695918423;'), ('tblk1qe5ai35avcf1a75svvif9b8shlu', '103.253.47.248', '1695918434', '__ci_last_regenerate|i:1695918434;'), ('beedem4l4emjo6a6pn5da3gibhsg1703', '103.253.47.248', '1695918469', '__ci_last_regenerate|i:1695918469;'), ('9nqhlspm1225i06gkqnc569700alvt6s', '103.253.47.248', '1695918470', '__ci_last_regenerate|i:1695918470;'), ('eeltet9hunf7l627lr8jnf1dkosvuh1s', '103.253.47.248', '1695920543', '__ci_last_regenerate|i:1695920543;'), ('4nsk8urclv5lcok01ta68hej76ipkos4', '103.253.47.248', '1695920545', '__ci_last_regenerate|i:1695920545;'), ('ounpq9janobrerkakbvfv1ntv72ni7uq', '103.253.47.248', '1695920545', '__ci_last_regenerate|i:1695920545;'), ('cf4gfnt4g6mf18bfnb84nenf8n2u652j', '103.253.47.248', '1695920545', '__ci_last_regenerate|i:1695920545;'), ('let9k8uk1uvpgh5369defbkdtduupbkr', '103.253.47.248', '1695920545', '__ci_last_regenerate|i:1695920545;'), ('08htf686jrjgi0ihfqjje9npq10sundd', '103.253.47.248', '1695920545', '__ci_last_regenerate|i:1695920545;'), ('e7b0t401mf8co7g2p63qvqr1nhfboejt', '103.253.47.248', '1695920545', '__ci_last_regenerate|i:1695920545;'), ('7rsd5mnbgsevb4o6n03nn82q90tufopa', '103.253.47.248', '1695920545', '__ci_last_regenerate|i:1695920545;'), ('lig2od66ej7qo0bk4t6kc22h7ksebhtc', '103.253.47.248', '1695920689', '__ci_last_regenerate|i:1695920689;'), ('9copq0fnq1mhv5lnm71fjt37jau6rgq5', '103.253.47.248', '1695920689', '__ci_last_regenerate|i:1695920689;'), ('5d446a06och3aqgnqdtgoe6d66ftli0g', '103.253.47.248', '1695920729', '__ci_last_regenerate|i:1695920729;'), ('61jpsfk2kpba2b5be8f5a6b2tho5hl0g', '103.253.47.248', '1695920729', '__ci_last_regenerate|i:1695920729;'), ('9ddra752tqokj7vude241t2uhaf2gij8', '103.253.47.248', '1695920745', '__ci_last_regenerate|i:1695920745;'), ('an65d905ce55oilb62so3bvrvishst36', '103.253.47.248', '1695920745', '__ci_last_regenerate|i:1695920745;'), ('0s7k7c6br9rsj43tlqj94dvne92odjt6', '103.253.47.248', '1695920768', '__ci_last_regenerate|i:1695920768;'), ('5gkcfl60roq2vuo6f65g66sfmbeiht71', '103.253.47.248', '1695920769', '__ci_last_regenerate|i:1695920769;'), ('buhk6pnpeqjreaq3g80vkei28t3u1k20', '103.253.47.248', '1695920814', '__ci_last_regenerate|i:1695920814;'), ('f2hpmf13t5m3m5joekm9rl6s686o098o', '103.253.47.248', '1695920815', '__ci_last_regenerate|i:1695920815;'), ('oqnt1qslsudarosn7bojam9eqttvvg2s', '103.253.47.248', '1695921801', '__ci_last_regenerate|i:1695921801;'), ('lhd460rn2lr9i2cmq369g7cqg31dmadr', '103.253.47.248', '1695921804', '__ci_last_regenerate|i:1695921804;'), ('a5fj9l9rt9jtojsk22l4i27qen11topp', '103.253.47.248', '1695921804', '__ci_last_regenerate|i:1695921804;'), ('t835io4vhqblsn7mgr6d6gubuanm1upj', '103.253.47.248', '1695921804', '__ci_last_regenerate|i:1695921804;'), ('svrsqk6262au67o9q1p94lmlnr82b7m5', '103.253.47.248', '1695921804', '__ci_last_regenerate|i:1695921804;'), ('hb99nrvadpv6mi3qjf5m0jkp736gabvo', '103.253.47.248', '1695921804', '__ci_last_regenerate|i:1695921804;'), ('svn473eea9l6lf7tki44nqg9buote3v3', '103.253.47.248', '1695921805', '__ci_last_regenerate|i:1695921805;'), ('c6sh7qu7c09no9mjhmbfh0vm8r34jfop', '103.253.47.248', '1695921805', '__ci_last_regenerate|i:1695921805;'), ('nhuej2sn2l2deanu1ac52d4jdtm0fu50', '103.253.47.248', '1695921869', '__ci_last_regenerate|i:1695921869;'), ('ou7hvsprvjq8jtiuie7cqliauht5kb6h', '103.253.47.248', '1695923171', '__ci_last_regenerate|i:1695923171;'), ('h9fr1he0gcrh53pki7dinkkut71m1upe', '103.253.47.248', '1695923171', '__ci_last_regenerate|i:1695923171;'), ('lahsvvp69b2cb168ne7vp8kmb9kg3bbq', '103.253.47.248', '1695923171', '__ci_last_regenerate|i:1695923171;'), ('2ar9mfobgg4543mqd66fp4bh9gdlga88', '103.253.47.248', '1695923171', '__ci_last_regenerate|i:1695923171;'), ('pudrie26be7mqm20ndvh3td3e1ugl26b', '103.253.47.248', '1695923171', '__ci_last_regenerate|i:1695923171;'), ('c3r1mhsv8tnpnp7q31o6o495fp3voepj', '103.253.47.248', '1695923171', '__ci_last_regenerate|i:1695923171;'), ('gbcmcudajf6950rk7l7ec504breovg3r', '103.253.47.248', '1695923175', '__ci_last_regenerate|i:1695923175;'), ('rr4dcsge7flfhq6uks26jqvu1ecnekdv', '103.253.47.248', '1695923175', '__ci_last_regenerate|i:1695923175;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('sbudkkqcgnoudvtt5pkl07ied7mfudvn', '103.253.47.248', '1695923176', '__ci_last_regenerate|i:1695923176;'), ('77ghl09l8c3ko05hjcq6sqgq7a6f4arb', '103.253.47.248', '1695923178', '__ci_last_regenerate|i:1695923178;'), ('gfj5nu1vuenu21bol8cashq1d4id873p', '103.253.47.248', '1695923179', '__ci_last_regenerate|i:1695923179;'), ('5tt41lfu7qe4i71rtd66r410v0t2jrum', '103.253.47.248', '1695923371', '__ci_last_regenerate|i:1695923371;'), ('bepq5jc12vo4m6o4qlt0m6i9kqu26008', '103.253.47.248', '1695923375', '__ci_last_regenerate|i:1695923375;'), ('htr4plq30067e1jfdr0i8bikenb7dcjh', '103.253.47.248', '1695923375', '__ci_last_regenerate|i:1695923375;'), ('3e6g0ij69eq3dmgkju1tscmnqmt1jqft', '103.253.47.248', '1695923375', '__ci_last_regenerate|i:1695923375;'), ('6k2j9qugki7ipar2dlhp65p4tkveulj8', '103.253.47.248', '1695923375', '__ci_last_regenerate|i:1695923375;'), ('o72b0nu92kfcmvn4r9e6ta91c9jbi31c', '103.253.47.248', '1695923375', '__ci_last_regenerate|i:1695923375;'), ('99nrrmvo66hf4p4nqscd4bn987vusmi1', '103.253.47.248', '1695923375', '__ci_last_regenerate|i:1695923375;'), ('e7cs5o48r3iquq5h1ca1n4hs276ofr63', '103.253.47.248', '1695923376', '__ci_last_regenerate|i:1695923376;'), ('el470ofh35bsqgj31g563lpptomdqpj2', '103.253.47.248', '1695923415', '__ci_last_regenerate|i:1695923415;'), ('tjodvq73o8ia6ra38u42ietco57l3ikg', '103.253.47.248', '1695923415', '__ci_last_regenerate|i:1695923415;'), ('b6d3rpqt7gu5mqssqnkh254end66cdbn', '103.253.47.248', '1695923416', '__ci_last_regenerate|i:1695923416;'), ('c1e2vm7c77iv3ee8e5gimiukj4e21u3a', '103.253.47.248', '1695923417', '__ci_last_regenerate|i:1695923417;'), ('8q3g41rlnnek2b97su62gacsv4nccv2n', '103.253.47.248', '1695923417', '__ci_last_regenerate|i:1695923417;'), ('1d0jn2tfrrvshlqsuqfeo22mgajlvv7c', '103.253.47.248', '1695923421', '__ci_last_regenerate|i:1695923421;'), ('s8v1icq72ee9o1h9qc614aghpc35g3d8', '103.253.47.248', '1695923423', '__ci_last_regenerate|i:1695923423;'), ('a87j1057o1lckq6qfls694gg70l6a0j7', '103.253.47.248', '1695923424', '__ci_last_regenerate|i:1695923423;'), ('6s6bat5n8jjaccvd7dcmt6a7k8hpqv6o', '103.253.47.248', '1695923424', '__ci_last_regenerate|i:1695923424;'), ('89851kcnenjpl119cpptfskh7vabh789', '103.253.47.248', '1695923424', '__ci_last_regenerate|i:1695923424;'), ('vs8djp276kdvst3hho94r1jg7jh96t4v', '103.253.47.248', '1695923424', '__ci_last_regenerate|i:1695923424;'), ('rsc6c2tf44e6d1uv0bn736rc3uvfq2sk', '103.253.47.248', '1695923424', '__ci_last_regenerate|i:1695923424;'), ('1luismha5pg5g0rnch6n81704ju1lqun', '103.253.47.248', '1695923424', '__ci_last_regenerate|i:1695923424;'), ('5urg7ccc7583higlhbm5qqv0mch4bsv7', '103.253.47.248', '1695923424', '__ci_last_regenerate|i:1695923424;'), ('tmmmdoritffgtr9vnoclgip0am24q7uc', '103.253.47.248', '1695923425', '__ci_last_regenerate|i:1695923425;'), ('o8jojq79jd6g3pub231aa541fg5ss4a0', '103.253.47.248', '1695923432', '__ci_last_regenerate|i:1695923432;'), ('f5uar48jcubhnkieb0s50idpp0dgsd5o', '103.253.47.248', '1695923435', '__ci_last_regenerate|i:1695923435;'), ('da4t78ka4r28s80sdh7c6471u745008h', '103.253.47.248', '1695923435', '__ci_last_regenerate|i:1695923435;'), ('a6kud1o84bi318svrrs16rue58f83hls', '103.253.47.248', '1695923435', '__ci_last_regenerate|i:1695923435;'), ('1a30joe5anjmic4cuk904hdpji15mfas', '103.253.47.248', '1695923435', '__ci_last_regenerate|i:1695923435;'), ('ip66ro9stlgks11dm08iofgg12b9ls8g', '103.253.47.248', '1695923435', '__ci_last_regenerate|i:1695923435;'), ('06srs2sr1fkfi34l9r5aod5kv18e8su9', '103.253.47.248', '1695923435', '__ci_last_regenerate|i:1695923435;'), ('e68je8i1s564cv98evoaee77dvptokd5', '103.253.47.248', '1695923435', '__ci_last_regenerate|i:1695923435;'), ('16muj7ttbgacusgmti500t2ocgu8j1gd', '103.253.47.248', '1695923438', '__ci_last_regenerate|i:1695923438;'), ('nm5f9cpdqlkabar2m10oq9g2ckeigsj1', '45.79.122.142', '1695923650', '__ci_last_regenerate|i:1695923650;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('f8oiqc148k5n3lof0p2bkgihao5jr5dv', '45.79.122.142', '1695923652', '__ci_last_regenerate|i:1695923652;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('833q9kp67pguj6qp6bsn47f0p6tibcdg', '45.79.122.142', '1695923655', '__ci_last_regenerate|i:1695923654;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('hsioo2799idbd20pgcds5pchd45flr1u', '103.253.47.248', '1695923656', '__ci_last_regenerate|i:1695923656;'), ('h2q5h5rro3m5ehm66avilvrkh19ldtt6', '45.79.122.142', '1695923657', '__ci_last_regenerate|i:1695923657;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('m06g70k1kvv8a6luvfimofok6uk2mkit', '103.253.47.248', '1695923657', '__ci_last_regenerate|i:1695923657;'), ('ug7kui8j7602cn3k682duvupkuhivpuc', '103.253.47.248', '1695923770', '__ci_last_regenerate|i:1695923770;'), ('imo542a37ost9ohh5lv21o86dn8vfb6u', '103.253.47.248', '1695923770', '__ci_last_regenerate|i:1695923770;'), ('v118eriogpc4rs9h8453204m81qkl91f', '103.253.47.248', '1695951157', '__ci_last_regenerate|i:1695951157;'), ('jtl71c49i0beulpsvulpilv29qk302il', '103.253.47.248', '1695951160', '__ci_last_regenerate|i:1695951160;'), ('ic51crlnvsu0vnkp9ubg849fdbia9dph', '103.253.47.248', '1695951160', '__ci_last_regenerate|i:1695951160;'), ('i7dvdl182qrkt1tsq6j6o0i8v7kj5hae', '103.253.47.248', '1695951160', '__ci_last_regenerate|i:1695951160;'), ('h1r3ejk09akk7j9uj5sf31jeaichff2s', '103.253.47.248', '1695951160', '__ci_last_regenerate|i:1695951160;'), ('3n098rb7n33g9lhe7donskk6ek4h190q', '103.253.47.248', '1695951160', '__ci_last_regenerate|i:1695951160;'), ('3vse65afkbutbtgoe32lmtr37hdgdh7p', '103.253.47.248', '1695951160', '__ci_last_regenerate|i:1695951160;'), ('lk8f49v6d3ab4qktq9i792p495f0fqt0', '103.253.47.248', '1695951161', '__ci_last_regenerate|i:1695951161;'), ('7b5iphio88jr1n3ghmbrtfhpmqflc82b', '103.253.47.248', '1695951174', '__ci_last_regenerate|i:1695951174;'), ('61boifpcj2ioq8tr63h1rgmlsk59n94c', '103.253.47.248', '1695951174', '__ci_last_regenerate|i:1695951174;'), ('0gun7uo2usdh5kn98qucp3g7adbl1pmf', '103.253.47.248', '1695951175', '__ci_last_regenerate|i:1695951175;'), ('m8mlkniv1715nhsfu601e7dov3ccuch8', '103.253.47.248', '1695951175', '__ci_last_regenerate|i:1695951175;'), ('07sqcmogi9ip2muknfqhbbbhjs8eokfq', '103.253.47.248', '1695951175', '__ci_last_regenerate|i:1695951175;'), ('dvfjns5hk1v77596g590u3iv6cndeqfb', '103.253.47.248', '1695951175', '__ci_last_regenerate|i:1695951175;'), ('976o3lrnrsklblos28u85fegukg167jb', '103.253.47.248', '1695951175', '__ci_last_regenerate|i:1695951175;'), ('1qkvl6qnjbg3ub6dptvkp5q2ua0b6usb', '103.253.47.248', '1695951175', '__ci_last_regenerate|i:1695951175;'), ('79gsiv5qvp84q5e4o2ko30jm999r3c79', '103.253.47.248', '1695951177', '__ci_last_regenerate|i:1695951177;'), ('4fo9lgancan5ckd0mqbcd6hh6kbthbfb', '103.253.47.248', '1695951177', '__ci_last_regenerate|i:1695951177;'), ('lgc3bkudrrlubh7t9cmhjqiftc1o3ler', '103.253.47.248', '1695951177', '__ci_last_regenerate|i:1695951177;'), ('jfvss4es7plnnjfnjcsknaersa75cuco', '103.253.47.248', '1695951177', '__ci_last_regenerate|i:1695951177;'), ('j2fve8v8s4i8vq9mmcgkog3484280jpd', '103.253.47.248', '1695951177', '__ci_last_regenerate|i:1695951177;'), ('sq9g4oaenhsvg2llhlmdlmgkuv9sb254', '103.253.47.248', '1695951177', '__ci_last_regenerate|i:1695951177;'), ('9bbfq66j36bjq4ru8gb6bh5j0p6r0d5u', '103.253.47.248', '1695951382', '__ci_last_regenerate|i:1695951382;'), ('03jdmuarns41jk2tnsu932pvn1eq8dc7', '103.253.47.248', '1695951382', '__ci_last_regenerate|i:1695951382;'), ('3hhbd7m8dhq5fglg57t1ermkccaru6dj', '103.253.47.248', '1695951382', '__ci_last_regenerate|i:1695951382;'), ('prsm6vr7c1gtl2fd4ug95dpkkdv5rj5m', '103.253.47.248', '1695951382', '__ci_last_regenerate|i:1695951382;'), ('kr7bd09ma963sr6p7vn9apk51mlbdrtb', '103.253.47.248', '1695951382', '__ci_last_regenerate|i:1695951382;'), ('n04v861e108h1b6ufl3lkls1hnkbslmg', '103.253.47.248', '1695951667', '__ci_last_regenerate|i:1695951667;'), ('iqk9idv5p8uak0hpjs7lng6vteherbq7', '103.253.47.248', '1695951676', '__ci_last_regenerate|i:1695951676;'), ('a4r9ldtv3najikaa39u6up1dh94nn0dh', '103.253.47.248', '1695951677', '__ci_last_regenerate|i:1695951677;'), ('gt4b6t46kf3jcfibphm5lhbj3if713e0', '103.253.47.248', '1695951685', '__ci_last_regenerate|i:1695951685;'), ('mqcbr4t7hp28hjd0q2kgh77i6d166ohd', '103.253.47.248', '1695951772', '__ci_last_regenerate|i:1695951772;'), ('utl4stcsvsuif9rvg239hgrh5qnc9c1q', '103.253.47.248', '1695952074', '__ci_last_regenerate|i:1695952074;'), ('37i6q5e9bad3rd1kp452pdss6mpsb7eg', '103.253.47.248', '1695952078', '__ci_last_regenerate|i:1695952078;'), ('p7b7a6c7o3u565givsmg5mlf2bijgt9q', '103.253.47.248', '1695952078', '__ci_last_regenerate|i:1695952078;'), ('7mkpd1u48vfo319akffg9iboki8nanef', '103.253.47.248', '1695952078', '__ci_last_regenerate|i:1695952078;'), ('aloo9q1h8m4jkrlp1c078te5n64v5lv8', '103.253.47.248', '1695952078', '__ci_last_regenerate|i:1695952078;'), ('am4i7f8pe1cpcj755fs6soak6ed0q4r9', '103.253.47.248', '1695952078', '__ci_last_regenerate|i:1695952078;'), ('6bkuh17tr8bp7n2q0djtprf8qd5d69p8', '103.253.47.248', '1695952078', '__ci_last_regenerate|i:1695952078;'), ('6gol5h4iv1id1suv6fud0j9ftjaipkss', '103.253.47.248', '1695952078', '__ci_last_regenerate|i:1695952078;'), ('hlctcsom943strh1861p9c0v61pb2nnj', '103.253.47.248', '1695952083', '__ci_last_regenerate|i:1695952083;'), ('j59rlucgvhqbqt62ptpv3pjtbp31ct67', '103.253.47.248', '1695952083', '__ci_last_regenerate|i:1695952083;'), ('o3c8b0pkggcb7avjfgmts12j7123gb53', '103.253.47.248', '1695952083', '__ci_last_regenerate|i:1695952083;'), ('rcu53hfjcohrc8mtjaa2ihq4esu6mavt', '103.253.47.248', '1695952084', '__ci_last_regenerate|i:1695952084;'), ('6n0tm79af9u0g3tikjjlg6o5ce1418ng', '103.253.47.248', '1695952084', '__ci_last_regenerate|i:1695952084;'), ('onhcrd4lu6ibnmkhu408rf29red3p76t', '103.253.47.248', '1695952084', '__ci_last_regenerate|i:1695952084;'), ('er87enhalmke0llsqevlaa1imskg8866', '103.253.47.248', '1695952087', '__ci_last_regenerate|i:1695952087;'), ('4sih2c0mf9ierh4lsjv0ied55v3ljjb7', '103.253.47.248', '1695952087', '__ci_last_regenerate|i:1695952087;'), ('6f93i0hds0gt7t008o7i0fc8kpna7m6m', '103.253.47.248', '1695952088', '__ci_last_regenerate|i:1695952088;'), ('bse673mpj05hkvm959i6279ftclukl72', '103.253.47.248', '1695952088', '__ci_last_regenerate|i:1695952088;'), ('il2qs2179uftcc9urm0pfgn548t84l9i', '103.253.47.248', '1695952088', '__ci_last_regenerate|i:1695952088;'), ('5garmkfrpalfukuv3os9s6lk1slpe05r', '103.253.47.248', '1695952088', '__ci_last_regenerate|i:1695952088;'), ('9i2iro4qnhnpur9j6qhf1eumm9lmknac', '103.253.47.248', '1695952088', '__ci_last_regenerate|i:1695952088;'), ('6dkvq84lejcl45rv19jige59ne31c23j', '103.253.47.248', '1695952088', '__ci_last_regenerate|i:1695952088;'), ('0ds29800e9nmu80s6mbd65u0p97kqko5', '103.253.47.248', '1695952252', '__ci_last_regenerate|i:1695952252;'), ('59anhrtt985oicku64nnioul5mdai74i', '103.253.47.248', '1695952256', '__ci_last_regenerate|i:1695952256;'), ('0o0uaq9rr73hm9hgc8mk8dnapc9a7b54', '103.253.47.248', '1695952256', '__ci_last_regenerate|i:1695952256;'), ('5ujnogerae5u0quaesua664ca50ft4ha', '103.253.47.248', '1695952256', '__ci_last_regenerate|i:1695952256;'), ('upotpvbvvviodkjo9ihtr5he9a9dvo8h', '103.253.47.248', '1695952256', '__ci_last_regenerate|i:1695952256;'), ('ffl4lr2ukg6uk8g75qnf5gf3saqus387', '103.253.47.248', '1695952256', '__ci_last_regenerate|i:1695952256;'), ('n3npmaniupnuldjja4up8l7ovrg77hin', '103.253.47.248', '1695952256', '__ci_last_regenerate|i:1695952256;'), ('vmr24t6ifdp3oeejf63iffj1imbtaqfh', '103.253.47.248', '1695952256', '__ci_last_regenerate|i:1695952256;'), ('d4lraktmp5pv3s6bs7k5t0oks2qsse0s', '103.253.47.248', '1695952378', '__ci_last_regenerate|i:1695952378;'), ('53100guqrdln3g72gnud9ploi25in1t6', '103.253.47.248', '1695952382', '__ci_last_regenerate|i:1695952382;'), ('pfusvhpqqp8b7sb2k0og45tdisp7hj4b', '103.253.47.248', '1695952382', '__ci_last_regenerate|i:1695952382;'), ('rfqeto0dn8v9g7f84pqdu9v82a1hgt4v', '103.253.47.248', '1695952382', '__ci_last_regenerate|i:1695952382;'), ('rlqvit2v7elq7de2ba0b3ue3hbb2ugc9', '103.253.47.248', '1695952382', '__ci_last_regenerate|i:1695952382;'), ('dg8bl2966qmqlkr0248smpdmaj3surf0', '103.253.47.248', '1695952382', '__ci_last_regenerate|i:1695952382;'), ('qkd6ppf9ck481vee21kl6eef8nfdfd74', '103.253.47.248', '1695952382', '__ci_last_regenerate|i:1695952382;'), ('nmmla53cl6fctp1i3jfssoijljr5sapd', '103.253.47.248', '1695952382', '__ci_last_regenerate|i:1695952382;'), ('a7hk5h14fl4gu4inh5ouje2b591d4u8e', '103.253.47.248', '1695952431', '__ci_last_regenerate|i:1695952431;'), ('nekdult1itq1gnl7edjidk0h53lmnkc7', '103.253.47.248', '1695952436', '__ci_last_regenerate|i:1695952436;'), ('adb0amdll8b8hrhbiikjtajgaprbc5l2', '103.253.47.248', '1695952467', '__ci_last_regenerate|i:1695952467;'), ('gpvj4mc3gndgq67lo581baltnk26988n', '103.253.47.248', '1695952471', '__ci_last_regenerate|i:1695952471;'), ('b9koensok4a446jlrprsm32ju3iprb2l', '103.253.47.248', '1695952471', '__ci_last_regenerate|i:1695952471;'), ('4s06kf6ei0h8poneeftther287nftgkm', '103.253.47.248', '1695952471', '__ci_last_regenerate|i:1695952471;'), ('khij1o2gnngcj4a56cm39c2if6shk27i', '103.253.47.248', '1695952471', '__ci_last_regenerate|i:1695952471;'), ('kfphqbggrc1rjmjin1fdd7sk9ji06krp', '103.253.47.248', '1695952471', '__ci_last_regenerate|i:1695952471;'), ('1i3mujfbnvno5pnsaomps2e85bbs6i44', '103.253.47.248', '1695952471', '__ci_last_regenerate|i:1695952471;'), ('klcdavskorcokitas63dp4pmt5qc7kcj', '103.253.47.248', '1695952471', '__ci_last_regenerate|i:1695952471;'), ('06k2lhfnv1at7l30f4505depmocqhanh', '103.253.47.248', '1695952708', '__ci_last_regenerate|i:1695952708;'), ('67nvbpsuqgvkr9kt5g5e6f8ighos792a', '103.253.47.248', '1695952711', '__ci_last_regenerate|i:1695952711;'), ('981hoaq8kqpnmpqno9vo0sv9pqjqo62p', '103.253.47.248', '1695952711', '__ci_last_regenerate|i:1695952711;'), ('f6gpeeu8s78a9ckvltjgnqpnqtjd8a2p', '103.253.47.248', '1695952711', '__ci_last_regenerate|i:1695952711;'), ('14hnanarnb885m6qme07cqjdg4qilth1', '103.253.47.248', '1695952711', '__ci_last_regenerate|i:1695952711;'), ('eigj827abcb1h819sfoeivo90ca9anru', '103.253.47.248', '1695952711', '__ci_last_regenerate|i:1695952711;'), ('v2md8udkn2005rc44ie7nkveit31kbv4', '103.253.47.248', '1695952711', '__ci_last_regenerate|i:1695952711;'), ('5in80lften9qete3lebhmdoccm92nuq8', '103.253.47.248', '1695952712', '__ci_last_regenerate|i:1695952712;'), ('idujfe40s2mmlb9n19adr7b5r06ji20l', '103.253.47.248', '1695952774', '__ci_last_regenerate|i:1695952774;'), ('4pejt5jhmuk27qt8il2u0rt435ggnocb', '103.253.47.248', '1695952777', '__ci_last_regenerate|i:1695952777;'), ('f93aq43m3bfp3nousijg2nqgimtbjep4', '103.253.47.248', '1695952777', '__ci_last_regenerate|i:1695952777;'), ('4klaf0mleogr4pi18q9ank1ogslpegvj', '103.253.47.248', '1695952777', '__ci_last_regenerate|i:1695952777;'), ('q2ifa9j8g7jcqdqsrqen0vbqhaub3pk8', '103.253.47.248', '1695952777', '__ci_last_regenerate|i:1695952777;'), ('ublpnnka4u67a5blfa19b8bm1g00ugr3', '103.253.47.248', '1695952777', '__ci_last_regenerate|i:1695952777;'), ('gijgsc3q6otkh7du1s56esgtmgd01u5e', '103.253.47.248', '1695952777', '__ci_last_regenerate|i:1695952777;'), ('vldture0214c3cpafcauook08vp4nkfm', '103.253.47.248', '1695952778', '__ci_last_regenerate|i:1695952778;'), ('6lgr8n0khpto89eseiqcb58sjqdhp991', '103.253.47.248', '1695952781', '__ci_last_regenerate|i:1695952781;'), ('mdthkfnig0uicjk0ptu33nn33ubkgtq3', '103.253.47.248', '1695952782', '__ci_last_regenerate|i:1695952782;'), ('nmmsa8hc3j8lcdqkrf5u0rorfcok8bii', '103.253.47.248', '1695952782', '__ci_last_regenerate|i:1695952782;'), ('gr0vt1kf9ijn1d3915rr5alfn3gahi0l', '103.253.47.248', '1695952782', '__ci_last_regenerate|i:1695952782;'), ('9kbkhs3ntm9fj8m5h5ejdb374eq7s7fi', '103.253.47.248', '1695952782', '__ci_last_regenerate|i:1695952782;'), ('p1pldaigafvfgut64igajqam6p298dul', '103.253.47.248', '1695952782', '__ci_last_regenerate|i:1695952782;'), ('nreaf1nlplttmb9t9iqeh6rdtm297jht', '103.253.47.248', '1695952782', '__ci_last_regenerate|i:1695952782;'), ('jt6vsf7v2p6veu1ur9mo9vl0v4h58ia3', '103.253.47.248', '1695952782', '__ci_last_regenerate|i:1695952782;'), ('u90cs3390o9bdrdenkui0e6aq84to98k', '103.253.47.248', '1695952784', '__ci_last_regenerate|i:1695952784;'), ('orsno7es3j063p39f80caqg6tbsj2sm2', '103.253.47.248', '1695952785', '__ci_last_regenerate|i:1695952785;'), ('a8rakjglndsp29b57hf4immiba4aqgt1', '103.253.47.248', '1695952785', '__ci_last_regenerate|i:1695952785;'), ('92u572k1gn3p8qq2c5p8v9vl6dts98tg', '103.253.47.248', '1695952785', '__ci_last_regenerate|i:1695952785;'), ('25vfnim5dojv4g7vvq9kp4ceglpes6ae', '103.253.47.248', '1695952785', '__ci_last_regenerate|i:1695952785;'), ('6v2utq3e0ktkr7il2edags9094f2tmh7', '103.253.47.248', '1695952785', '__ci_last_regenerate|i:1695952785;'), ('upkgv3n0rrgt3l7fagg0bapgdf151io4', '103.253.47.248', '1695952785', '__ci_last_regenerate|i:1695952785;'), ('nsf7id009l3rtvn38a85fg11ioo6tm0v', '103.253.47.248', '1695952785', '__ci_last_regenerate|i:1695952785;'), ('eqglvmopq7n0abshit5a2gi3kn9arj4r', '103.253.47.248', '1695952932', '__ci_last_regenerate|i:1695952932;'), ('b84lqifil51s91kligo7loc9iac2b03u', '103.253.47.248', '1695952935', '__ci_last_regenerate|i:1695952935;'), ('hf9ufv1j08u8qu001revtljp2leqdjum', '103.253.47.248', '1695952935', '__ci_last_regenerate|i:1695952935;'), ('ake3ac1o8o3h1f8i01k2r2as92ousfbk', '103.253.47.248', '1695952935', '__ci_last_regenerate|i:1695952935;'), ('k8s58gmkbd15lqtcbrlbcjr98h9e2ur8', '103.253.47.248', '1695952935', '__ci_last_regenerate|i:1695952935;'), ('sobu8tr1c3rkc0jl66cq4apn8b0s1b73', '103.253.47.248', '1695952935', '__ci_last_regenerate|i:1695952935;'), ('9ke474pnm0dsi951uajj3qnf1b3p915i', '103.253.47.248', '1695952935', '__ci_last_regenerate|i:1695952935;'), ('cahsvtabs1g1m7gahpc13th31q90793c', '103.253.47.248', '1695952935', '__ci_last_regenerate|i:1695952935;'), ('qu5prgq2938g42u67ksfe44ga4vupem0', '103.253.47.248', '1695952940', '__ci_last_regenerate|i:1695952940;'), ('gq8cmqb8niaa8av4tpohl48gn2p7tgd0', '103.253.47.248', '1695952940', '__ci_last_regenerate|i:1695952940;'), ('jc4bb683q5if60b54s0oj7g3t8ca5vdk', '103.253.47.248', '1695952941', '__ci_last_regenerate|i:1695952941;'), ('7qutkhnji8ntfarv1eetevi8aph5oqpj', '103.253.47.248', '1695952941', '__ci_last_regenerate|i:1695952941;'), ('jmkevuj3dguidopfett4q3trcsos5810', '103.253.47.248', '1695952941', '__ci_last_regenerate|i:1695952941;'), ('kidfjsju8qkb97o1nmvptofg82n549qq', '103.253.47.248', '1695952941', '__ci_last_regenerate|i:1695952941;'), ('0l5h916aj0g18dmbq884rfs1dle3r5q5', '103.253.47.248', '1695952941', '__ci_last_regenerate|i:1695952941;'), ('4sfjgm83tbim6fr1pp6tp4t6smo2ddfo', '103.253.47.248', '1695952941', '__ci_last_regenerate|i:1695952941;'), ('jkr1bq71fj2un4752mjk2rqjeqi82v0h', '103.253.47.248', '1695953045', '__ci_last_regenerate|i:1695953045;'), ('joo83uu5sbbs9l79049vjf9l8btlp5bp', '103.253.47.248', '1695953046', '__ci_last_regenerate|i:1695953046;'), ('qd6keotqejet15kvtd63j65i9531h7me', '103.253.47.248', '1695953049', '__ci_last_regenerate|i:1695953049;'), ('l76he1vh0oulhq49stjhlrv0h69ijma2', '103.253.47.248', '1695953050', '__ci_last_regenerate|i:1695953050;'), ('hfsdd0tcnk7lfal8ibuo3g52n457u44r', '103.253.47.248', '1695953051', '__ci_last_regenerate|i:1695953051;'), ('vei9nuijabafg3bpl3ek2to7e7oubv57', '103.253.47.248', '1695953051', '__ci_last_regenerate|i:1695953051;'), ('5salb70k1vjn13mieudmnqpblp702m94', '103.253.47.248', '1695953051', '__ci_last_regenerate|i:1695953051;'), ('um578plhehhd55707fqokeu1bcnjg1rj', '103.253.47.248', '1695953051', '__ci_last_regenerate|i:1695953051;'), ('svdukrvatcd8dtnue60nbn8fde2iebrl', '103.253.47.248', '1695953051', '__ci_last_regenerate|i:1695953051;'), ('fd9k9i31pco83kaeklqhdlqus2dd03mc', '103.253.47.248', '1695953051', '__ci_last_regenerate|i:1695953051;'), ('2q1fan9794v1f69v3rulftu0rnmiusr2', '103.253.47.248', '1695953084', '__ci_last_regenerate|i:1695953084;'), ('avllps1rc6jno0a5lmqskcat1t06npne', '103.253.47.248', '1695953087', '__ci_last_regenerate|i:1695953087;'), ('k9gugc7b1e9i73rt7gdneo2plak5va2j', '103.253.47.248', '1695953087', '__ci_last_regenerate|i:1695953087;'), ('quor1680o6dsmtr0d5nth807o6ljhest', '103.253.47.248', '1695953087', '__ci_last_regenerate|i:1695953087;'), ('3vo3471mcubsfrh74knlsp1e66m1eeon', '103.253.47.248', '1695953087', '__ci_last_regenerate|i:1695953087;'), ('dng733onci0nj1os72cce5r5d37qfm0g', '103.253.47.248', '1695953087', '__ci_last_regenerate|i:1695953087;'), ('0a3puvm3qpt53jfqsikv6p5np7e45fht', '103.253.47.248', '1695953087', '__ci_last_regenerate|i:1695953087;'), ('nqtdi6jljvibu80rmf14rvgu0eita49l', '103.253.47.248', '1695953088', '__ci_last_regenerate|i:1695953088;'), ('0jiru1lpdju9emvm37anv9ib5usmpu8m', '103.253.47.248', '1695953146', '__ci_last_regenerate|i:1695953146;'), ('b47e715a06snni4sp7namf05lg7ae6p9', '103.253.47.248', '1695953149', '__ci_last_regenerate|i:1695953149;'), ('l29vs51d8l02tk40id3h1m7d7de4mqh5', '103.253.47.248', '1695953149', '__ci_last_regenerate|i:1695953149;'), ('81mggtopogu058em66sndv79mv7nbhvo', '103.253.47.248', '1695953149', '__ci_last_regenerate|i:1695953149;'), ('to5scf7s2jd4c87pek3k74a7k0s4fdce', '103.253.47.248', '1695953149', '__ci_last_regenerate|i:1695953149;'), ('b64v4v424n57ebfq09dhnnnnd8kgcme7', '103.253.47.248', '1695953149', '__ci_last_regenerate|i:1695953149;'), ('qt6te2eivcig0qf88okturnftqpkaddu', '103.253.47.248', '1695953149', '__ci_last_regenerate|i:1695953149;'), ('lco0kqh5ree5uhmhrc08l84o6hm84ra9', '103.253.47.248', '1695953150', '__ci_last_regenerate|i:1695953150;'), ('1hv58r9e12c1i4rfrgbs613eh3n8oh91', '103.253.47.248', '1695953222', '__ci_last_regenerate|i:1695953222;'), ('0j76dmi5mj1ld8cjecrk33jofnif3p0l', '103.253.47.248', '1695953225', '__ci_last_regenerate|i:1695953225;'), ('02gma37hgu65ibk8cptqueacuj468tsd', '103.253.47.248', '1695953225', '__ci_last_regenerate|i:1695953225;'), ('qp6paq11t7fc70d6boalvqbidpf4hv23', '103.253.47.248', '1695953225', '__ci_last_regenerate|i:1695953225;'), ('0o4i6osafc3gbnklose2t73kcap0c4ko', '103.253.47.248', '1695953225', '__ci_last_regenerate|i:1695953225;'), ('6rko0mekib0o1q6t66lkd06b1rl90m4b', '103.253.47.248', '1695953225', '__ci_last_regenerate|i:1695953225;'), ('jbcpolcup48anh225r6hmc8i71ka41j7', '103.253.47.248', '1695953225', '__ci_last_regenerate|i:1695953225;'), ('ur69lth2jkmh7ora1uo8p0t4esegd7sf', '103.253.47.248', '1695953225', '__ci_last_regenerate|i:1695953225;'), ('tfjuiu51fc0m7vmg9ppkk8tto00ggif3', '103.253.47.248', '1695953229', '__ci_last_regenerate|i:1695953229;'), ('7l209d1sirkj1gpfctko2dr6r7gkedcd', '103.253.47.248', '1695953229', '__ci_last_regenerate|i:1695953229;'), ('5g7135hul295avom34s58ftsojtqoc0j', '103.253.47.248', '1695953230', '__ci_last_regenerate|i:1695953230;'), ('prdqu68r9hkljouo0jnjdkkeaiocvmqi', '103.253.47.248', '1695953230', '__ci_last_regenerate|i:1695953230;'), ('i3mjncf1fs9tic0cgqoh1jd92sq6t14m', '103.253.47.248', '1695953230', '__ci_last_regenerate|i:1695953230;'), ('5sefr6bk1m2u4ofhe8idn1b47pe5t6nr', '103.253.47.248', '1695953230', '__ci_last_regenerate|i:1695953230;'), ('1cqjdahvln1lj21mn0qahjd1pas4qdcl', '103.253.47.248', '1695953230', '__ci_last_regenerate|i:1695953230;'), ('aasld4mbero5qam9leolo008rntth0lp', '103.253.47.248', '1695953230', '__ci_last_regenerate|i:1695953230;'), ('sjshc2of2jqavtr82p2l8md083mcli7k', '103.253.47.248', '1695953547', '__ci_last_regenerate|i:1695953547;'), ('lvm3f8tun7fovp7bdejvsbqehe1iekup', '103.253.47.248', '1695953550', '__ci_last_regenerate|i:1695953550;'), ('udbch9kv51goj3kpodltgavd06n6ub77', '103.253.47.248', '1695953550', '__ci_last_regenerate|i:1695953550;'), ('comhd18f2ebgh6t9upoh40513c2kvvgb', '103.253.47.248', '1695953550', '__ci_last_regenerate|i:1695953550;'), ('nkd67l8sg669ak92ajboqss1iv1uj856', '103.253.47.248', '1695953550', '__ci_last_regenerate|i:1695953550;'), ('queukt9s940m6ooe29jsbncc50sd5rvo', '103.253.47.248', '1695953550', '__ci_last_regenerate|i:1695953550;'), ('38qkg6l8iue4g4hphc24vb69pvb65ucp', '103.253.47.248', '1695953551', '__ci_last_regenerate|i:1695953551;'), ('j5lu34euujnrao2jlr17tctafue6ecdr', '103.253.47.248', '1695953551', '__ci_last_regenerate|i:1695953551;'), ('kaoqfuh9qga9pdoo81svb7asrb9q02ht', '103.253.47.248', '1695953556', '__ci_last_regenerate|i:1695953556;'), ('qmctbtm8ngvhgs3op7go4staof31bevp', '103.253.47.248', '1695953556', '__ci_last_regenerate|i:1695953556;'), ('94sk58kp793mfe09n5690no2g18b13h8', '103.253.47.248', '1695953557', '__ci_last_regenerate|i:1695953557;'), ('fou827imt05qf7qavvp5itrlhig3r13d', '103.253.47.248', '1695953557', '__ci_last_regenerate|i:1695953557;'), ('58lcvhjj2smrgo7t8953r3i5to9jidb6', '103.253.47.248', '1695953557', '__ci_last_regenerate|i:1695953557;'), ('t1srhh12skrvdeqf5agm85n334tc7jjm', '103.253.47.248', '1695953557', '__ci_last_regenerate|i:1695953557;'), ('mibdidkp6b1glcqpvt9slo4j799sbeuk', '103.253.47.248', '1695953557', '__ci_last_regenerate|i:1695953557;'), ('du4itlr7n89agu9s1tvveapo1dd1smo8', '103.253.47.248', '1695953557', '__ci_last_regenerate|i:1695953557;'), ('ph36iqj0f009phui340g12j03287ggub', '103.253.47.248', '1695953888', '__ci_last_regenerate|i:1695953888;'), ('u6p81a63jnmi28nma8tkui110od9fkjb', '103.253.47.248', '1695953892', '__ci_last_regenerate|i:1695953892;'), ('pun8jd3ss40s3rkdd28gdgac95nvobki', '103.253.47.248', '1695953892', '__ci_last_regenerate|i:1695953892;'), ('12l8d97ja3v0krnl9d5b7s3d0mnqohj0', '103.253.47.248', '1695953892', '__ci_last_regenerate|i:1695953892;'), ('3l5e4j8qqn046grvffnrkk6v8e20on4f', '103.253.47.248', '1695953892', '__ci_last_regenerate|i:1695953892;'), ('gc2tfek7paus1l998v263s2omp3kooc0', '103.253.47.248', '1695953892', '__ci_last_regenerate|i:1695953892;'), ('lbp51fh0a348v5menm05e3sg5seoplsi', '103.253.47.248', '1695953892', '__ci_last_regenerate|i:1695953892;'), ('j8gh7rg28m51nsok832e8kqp2iq7dfha', '103.253.47.248', '1695953893', '__ci_last_regenerate|i:1695953893;'), ('ktn5ovoeefa9mpd5ofs9fkp9621p16pk', '103.253.47.248', '1695954022', '__ci_last_regenerate|i:1695954022;'), ('ocdcacn7f0ptd5rqcn160l9b4jfmuj82', '103.253.47.248', '1695954025', '__ci_last_regenerate|i:1695954025;'), ('kf6ehh6ajtu7ugedi49lqn59oj28g4oe', '103.253.47.248', '1695954025', '__ci_last_regenerate|i:1695954025;'), ('ddem772shdfo75rq6tjvm9001a2447dj', '103.253.47.248', '1695954025', '__ci_last_regenerate|i:1695954025;'), ('49qq3ab2i68k7o5424mp5ov5fvpvgtka', '103.253.47.248', '1695954025', '__ci_last_regenerate|i:1695954025;'), ('2sab4uq605mrv10k5p358pppjuatd569', '103.253.47.248', '1695954025', '__ci_last_regenerate|i:1695954025;'), ('0bnqaoj2nnjjm2jbuid2u4455s7c3s60', '103.253.47.248', '1695954025', '__ci_last_regenerate|i:1695954025;'), ('o6io8e5m1oecmqp0su696rri5oipgjn2', '103.253.47.248', '1695954025', '__ci_last_regenerate|i:1695954025;'), ('n40qgmf0pkqumdsqqccik348778q8a50', '103.253.47.248', '1695954170', '__ci_last_regenerate|i:1695954170;'), ('n6sm6q0psulan9fos51ubula7mv47gsj', '103.253.47.248', '1695954174', '__ci_last_regenerate|i:1695954174;'), ('2fn509b23od0onkqq2ncphj113kg62e5', '103.253.47.248', '1695954174', '__ci_last_regenerate|i:1695954174;'), ('p31abkigseeb2s7uimuqfaggr3f9jsjt', '103.253.47.248', '1695954174', '__ci_last_regenerate|i:1695954174;'), ('l0aj98nc8pfe8lj4kic42flbikd73n74', '103.253.47.248', '1695954174', '__ci_last_regenerate|i:1695954174;'), ('gh178sku8o9kl7a28o14jdll9dmqjvk2', '103.253.47.248', '1695954174', '__ci_last_regenerate|i:1695954174;'), ('g844keph1ffr3n97hhcg08me0mktp33b', '103.253.47.248', '1695954174', '__ci_last_regenerate|i:1695954174;'), ('6suas6d3acr4lusker162lvddcg7tt33', '103.253.47.248', '1695954174', '__ci_last_regenerate|i:1695954174;'), ('4srgbsi3b7c7nk4smipkcf5gd9haiih9', '103.253.47.248', '1695954184', '__ci_last_regenerate|i:1695954184;'), ('2uasafbsr6klqj5ua5hh7uu02jeqiov6', '103.253.47.248', '1695954185', '__ci_last_regenerate|i:1695954185;'), ('paa3if72pefn6hkl4idsivh0f6ur4j7n', '103.253.47.248', '1695954186', '__ci_last_regenerate|i:1695954186;'), ('87ud39cvs7gdq7dho0vl98eqqe9qn95g', '103.253.47.248', '1695954186', '__ci_last_regenerate|i:1695954186;'), ('n1de764b79kdf6g2j5m41spo25lr44fc', '103.253.47.248', '1695954186', '__ci_last_regenerate|i:1695954186;'), ('qauinbb4hpe77sd4o9rq9teeele16p77', '103.253.47.248', '1695954186', '__ci_last_regenerate|i:1695954186;'), ('dvs9l326ulsqse4257kese043m5qjk0f', '103.253.47.248', '1695954186', '__ci_last_regenerate|i:1695954186;'), ('8sepe1n35s8m3p4scbfsuvjffsiicspc', '103.253.47.248', '1695954186', '__ci_last_regenerate|i:1695954186;'), ('7537l942p3lkmh61t65e9o4i9ahqq49t', '103.253.47.248', '1695954376', '__ci_last_regenerate|i:1695954376;'), ('ffqor439jo2hl9psoj5gg9801olm2q1h', '103.253.47.248', '1695954379', '__ci_last_regenerate|i:1695954379;'), ('cqrm5jsi1usn6bi5sr4lnjlbv9ij14mb', '103.253.47.248', '1695954379', '__ci_last_regenerate|i:1695954379;'), ('5tut5i878q3ubj3elarl6o3rd95d13v1', '103.253.47.248', '1695954379', '__ci_last_regenerate|i:1695954379;'), ('sl0gmsv1lk1pmk5v0pugabpr76h8gq5c', '103.253.47.248', '1695954380', '__ci_last_regenerate|i:1695954380;'), ('nim2pg1v1knr5tgnbcdnteqeru28v8rr', '103.253.47.248', '1695954380', '__ci_last_regenerate|i:1695954380;'), ('j8ok16ssi83iv4st20790uo0gvfq80en', '103.253.47.248', '1695954380', '__ci_last_regenerate|i:1695954380;'), ('4knv1iblor4d34sptmiial0p9plict75', '103.253.47.248', '1695954380', '__ci_last_regenerate|i:1695954380;'), ('r6gbhrcplo3la72s0ddn37um4np8aala', '103.253.47.248', '1695954469', '__ci_last_regenerate|i:1695954469;'), ('60if7arqqrf73ln631tnfdr4d14vmv0q', '103.253.47.248', '1695955138', '__ci_last_regenerate|i:1695955138;'), ('ppcn2n05fpnucl79hn4pqpc6d7d8un93', '103.253.47.248', '1695955141', '__ci_last_regenerate|i:1695955141;'), ('el12m50hsn503v7c1efkn3d00fmtmsba', '103.253.47.248', '1695955141', '__ci_last_regenerate|i:1695955141;'), ('nplq9tvgvmhbgecg51a3pgunjpuecbdo', '103.253.47.248', '1695955142', '__ci_last_regenerate|i:1695955142;'), ('lgit80ledptvvcqb6g17v2mv66umd0j8', '103.253.47.248', '1695955142', '__ci_last_regenerate|i:1695955142;'), ('6562lhna03b4bep99svnojlqa665noq1', '103.253.47.248', '1695955142', '__ci_last_regenerate|i:1695955142;'), ('c1k0rb2mgb15migq4ds9igij2t6f0jvd', '103.253.47.248', '1695955142', '__ci_last_regenerate|i:1695955142;'), ('cdsu85b2rhrd3b77isjvkas8qs06p1te', '103.253.47.248', '1695955142', '__ci_last_regenerate|i:1695955142;'), ('snvi1042nmctk35m3daeba7cmdqb1vem', '43.245.121.95', '1695955485', '__ci_last_regenerate|i:1695955485;'), ('cirvou62an3b0hdcq5jnffrpp13q28kq', '43.245.121.95', '1695955486', '__ci_last_regenerate|i:1695955486;'), ('q1cn0cmrv5hcn2af2lt5ag43gla36uk9', '43.245.121.95', '1695955486', '__ci_last_regenerate|i:1695955486;'), ('h08030n6m19ne1r70682in00uga4tpa0', '43.245.121.95', '1695955487', '__ci_last_regenerate|i:1695955487;'), ('d43q41orngpmdls8mnt4vsi84revgfb4', '43.245.121.95', '1695955487', '__ci_last_regenerate|i:1695955487;'), ('0d8m5n7cvos4j6lfdrccujdgfebng078', '43.245.121.95', '1695955487', '__ci_last_regenerate|i:1695955487;'), ('44ukfn4hjv60l5ko16ek98t92ipog8to', '43.245.121.95', '1695955487', '__ci_last_regenerate|i:1695955487;'), ('qkmlpa3dnqi6vqcoutukk2ssq62ff6ip', '43.245.121.95', '1695955487', '__ci_last_regenerate|i:1695955487;'), ('dql5hdim2fag6oh711m1qr7vj1ur81h6', '43.245.121.95', '1695955487', '__ci_last_regenerate|i:1695955487;'), ('fgph3um4f14e4u4m0jff16pfvt32um4f', '43.245.121.95', '1695957304', '__ci_last_regenerate|i:1695957303;'), ('be9kn0lsrj91p0im65gc23pa1ct23rai', '43.245.121.95', '1695957306', '__ci_last_regenerate|i:1695957306;'), ('9p6iqkul2lupbmoirbogounpcc2h72h8', '43.245.121.95', '1695957306', '__ci_last_regenerate|i:1695957306;'), ('p37k7t92bdmhvtg2f9jpno1odutaspd9', '43.245.121.95', '1695957306', '__ci_last_regenerate|i:1695957306;'), ('18ta7gp0nk05f4dkdon79t91612g0ejm', '43.245.121.95', '1695957306', '__ci_last_regenerate|i:1695957306;'), ('lsg5t4g6ojpja73jbrlb8ufp80h7kslt', '43.245.121.95', '1695957306', '__ci_last_regenerate|i:1695957306;'), ('u01l0dm0a6jsbtrknebqsqafvhcr6ekk', '43.245.121.95', '1695957306', '__ci_last_regenerate|i:1695957306;'), ('fk0u5q38hsa64i009ngfkhpm5gqop7i1', '43.245.121.95', '1695957307', '__ci_last_regenerate|i:1695957307;'), ('at6phfhvvpkj7s55ivvjum38vfr3l1qv', '43.245.121.95', '1695957383', '__ci_last_regenerate|i:1695957383;'), ('ttuf4d9ks39flaajl9lcrsqj7ipga52b', '43.245.121.95', '1695957432', '__ci_last_regenerate|i:1695957432;'), ('cuk4qm3ohk26qf355h7hugu1jejhm1o4', '43.245.121.95', '1695957435', '__ci_last_regenerate|i:1695957435;'), ('adtrrrf3fpgud5iotkji3e4ra1ktr926', '43.245.121.95', '1695957435', '__ci_last_regenerate|i:1695957435;'), ('c4d9e58rd5ng87rnniumk52uj2o0hh3i', '43.245.121.95', '1695957435', '__ci_last_regenerate|i:1695957435;'), ('4e274kj323kc6hce21auf8glgkeld89n', '43.245.121.95', '1695957435', '__ci_last_regenerate|i:1695957435;'), ('2bvb8nedsrscja76uff525du89qf12fq', '43.245.121.95', '1695957435', '__ci_last_regenerate|i:1695957435;'), ('0jfl516020bvt7l8cmaojhl41jrouca7', '43.245.121.95', '1695957435', '__ci_last_regenerate|i:1695957435;'), ('ke7oic9php2rbat5cg2av0n6q9raaudg', '43.245.121.95', '1695957436', '__ci_last_regenerate|i:1695957436;'), ('lr5ndtdf214k8co8up203bbdkcm3ijkb', '43.245.121.95', '1695957614', '__ci_last_regenerate|i:1695957614;'), ('r305gj74gcm6hlt9jstmidu6dr0p0e1k', '43.245.121.95', '1695957618', '__ci_last_regenerate|i:1695957618;'), ('96mod4fprcqmi43pqij0ebmjrengcoc1', '43.245.121.95', '1695957618', '__ci_last_regenerate|i:1695957618;'), ('0ach94lstpjsvmhfka0p2g7r7pv911om', '43.245.121.95', '1695957618', '__ci_last_regenerate|i:1695957618;'), ('ib72vtvno24nvo5l6bhli5nfjocmcqa9', '43.245.121.95', '1695957618', '__ci_last_regenerate|i:1695957618;'), ('8h8mg21g8hqlor09d3jhinhqhgnev1tu', '43.245.121.95', '1695957618', '__ci_last_regenerate|i:1695957618;'), ('i73roffos0lg5qgmhnq1k1bvee0mqund', '43.245.121.95', '1695957618', '__ci_last_regenerate|i:1695957618;'), ('qnghne4e06ql9t8ek37t1i9gackk28kp', '43.245.121.95', '1695957618', '__ci_last_regenerate|i:1695957618;'), ('bsfhngcsl8nbe2nebb86ssc615fl94de', '43.245.121.95', '1695957840', '__ci_last_regenerate|i:1695957840;'), ('jdtrj41ae7ace6s9fgr6k3vnkbtko0fl', '43.245.121.95', '1695957844', '__ci_last_regenerate|i:1695957844;'), ('66karlav642mrt179sdv1orag91o44jk', '43.245.121.95', '1695957844', '__ci_last_regenerate|i:1695957844;'), ('vv7b92f0ns2m45loe9ul43o0u7t6e73m', '43.245.121.95', '1695957844', '__ci_last_regenerate|i:1695957844;'), ('1b3hm6pl1id6luunl7ibltbthepgu894', '43.245.121.95', '1695957844', '__ci_last_regenerate|i:1695957844;'), ('1ip5gfo6bhlsijlaam6289q5t5a1r1vr', '43.245.121.95', '1695957844', '__ci_last_regenerate|i:1695957844;'), ('3n7v3k1ri98qjbafcetnpu5rcgufdnjr', '43.245.121.95', '1695957844', '__ci_last_regenerate|i:1695957844;'), ('8kukrj4stamkfp0ii6s10i8cv3uo8iq0', '43.245.121.95', '1695957845', '__ci_last_regenerate|i:1695957845;'), ('uc801dj4ednuo7903vnib09lpkb96itr', '43.245.121.95', '1695957854', '__ci_last_regenerate|i:1695957854;'), ('cq2p30om6dom30677cmgqig2g5i65q38', '43.245.121.95', '1695957879', '__ci_last_regenerate|i:1695957879;'), ('eluhqku8gjrbh2r779uf9d3qfg5nf0qt', '43.245.121.95', '1695957882', '__ci_last_regenerate|i:1695957882;'), ('00fed50iqi3n2c4lkt6co7dkju4t8jfe', '43.245.121.95', '1695957882', '__ci_last_regenerate|i:1695957882;'), ('ru2735ppooje98o3mn70mdjpu4u9dnf8', '43.245.121.95', '1695957882', '__ci_last_regenerate|i:1695957882;'), ('762a5mpv1u9fj6bqat71pf9fma9clldn', '43.245.121.95', '1695957882', '__ci_last_regenerate|i:1695957882;'), ('6cml0af1mgggk2ld4bldji21ikdt9liv', '43.245.121.95', '1695957882', '__ci_last_regenerate|i:1695957882;'), ('rp6d2u5q7nnk1vp4ngcnv5hbek03h48s', '43.245.121.95', '1695957882', '__ci_last_regenerate|i:1695957882;'), ('cscflmu4a23d70cup99otoil4cg8a3pm', '43.245.121.95', '1695957883', '__ci_last_regenerate|i:1695957883;'), ('9qotbfo4h6frpe0c317jmllli4kfflar', '43.245.121.95', '1695957903', '__ci_last_regenerate|i:1695957903;'), ('ft4l81f0s7s994ubjp2chgdh1ek6jpvi', '43.245.121.95', '1695957906', '__ci_last_regenerate|i:1695957906;'), ('d7a89lv1vv8ngeh3s2uhimqn4bn0a32b', '43.245.121.95', '1695957906', '__ci_last_regenerate|i:1695957906;'), ('k8m4v4qit5fmuqhkg39lns728ajn88c1', '43.245.121.95', '1695957906', '__ci_last_regenerate|i:1695957906;'), ('v4r5c7rjknc2cu0amu7o27i3mr5odn23', '43.245.121.95', '1695957906', '__ci_last_regenerate|i:1695957906;'), ('5kt8oko10q6h89qjmtoate6n52a4o4fg', '43.245.121.95', '1695957906', '__ci_last_regenerate|i:1695957906;'), ('a3cu2pkcjk9ns4683kf7flja4hbs0n8d', '43.245.121.95', '1695957906', '__ci_last_regenerate|i:1695957906;'), ('5n7ef5mrukfmkkitcq9gl30u231div4t', '43.245.121.95', '1695957907', '__ci_last_regenerate|i:1695957907;'), ('0ft011k06iib35l1hia5sq3v60mr7l06', '43.245.121.95', '1695958064', '__ci_last_regenerate|i:1695958064;'), ('ik50p0h5ponv6ejs547p4625lr2jnjd4', '43.245.121.95', '1695958064', '__ci_last_regenerate|i:1695958064;'), ('jsr6jmqleb6un7m1m4hjnlk3i8ur5hg7', '43.245.121.95', '1695958065', '__ci_last_regenerate|i:1695958065;'), ('jqn3u4bhn44p35ln471g8jmp3uu79lev', '43.245.121.95', '1695958065', '__ci_last_regenerate|i:1695958065;'), ('g7n71vmbdbecese8g82bf869nkis4vuj', '43.245.121.95', '1695958065', '__ci_last_regenerate|i:1695958065;'), ('1ss9nmt2tbt1m3bd3fpc4kgsrofc7o8s', '43.245.121.95', '1695958065', '__ci_last_regenerate|i:1695958065;'), ('9cmbnvt6kci5e0gm0dsgocimfvmn13lc', '43.245.121.95', '1695958065', '__ci_last_regenerate|i:1695958065;'), ('6ua4903e5hs0vt7dkrjftl5q0c8k3dv4', '43.245.121.95', '1695958065', '__ci_last_regenerate|i:1695958065;'), ('ko05n1tedj8ornhhhqo0mp6ldcr5ahfh', '43.245.121.95', '1695958077', '__ci_last_regenerate|i:1695958077;'), ('id3lm02j1bj2bav6n5npq8mkl311o9pj', '43.245.121.95', '1695958088', '__ci_last_regenerate|i:1695958088;'), ('s9ckoueic67sbl6cbasqi2ksu0cm4m6m', '43.245.121.95', '1695958106', '__ci_last_regenerate|i:1695958106;'), ('1oa4c25n78dtpoj3m55h7tk047svdi2j', '43.245.121.95', '1695958159', '__ci_last_regenerate|i:1695958159;'), ('pa6r4as0vtmc6hi7qg2c0lbf65f3h67u', '43.245.121.95', '1695958159', '__ci_last_regenerate|i:1695958159;'), ('vvvsqrg4vkf6p0pk4obr8e9ft994neoo', '43.245.121.95', '1695958175', '__ci_last_regenerate|i:1695958175;'), ('o0sac5fhji08t57gtrmn1eavhhpmtrrg', '43.245.121.95', '1695958235', '__ci_last_regenerate|i:1695958235;'), ('agfrqkk697c1t1qp94khccagh2tr79q1', '43.245.121.95', '1695958260', '__ci_last_regenerate|i:1695958260;'), ('0tthag6s5tf1r1cc9ei22hsvc6hu4a54', '43.245.121.95', '1695958261', '__ci_last_regenerate|i:1695958261;'), ('jhc0ack115higtj127ss6hre06llter5', '43.245.121.95', '1695958261', '__ci_last_regenerate|i:1695958261;'), ('8ea4ubdi0g1fc9dts0v2glrhkqvhl56n', '43.245.121.95', '1695958261', '__ci_last_regenerate|i:1695958261;'), ('hcccoim50kflatfkn4nsbbu00sqr05om', '43.245.121.95', '1695958261', '__ci_last_regenerate|i:1695958261;'), ('vqsap78f9lv5vlm88funlq040kpb6kit', '43.245.121.95', '1695958261', '__ci_last_regenerate|i:1695958261;'), ('nbd012k8lfdns7f2bse3ssmvk0mpv13a', '43.245.121.95', '1695958261', '__ci_last_regenerate|i:1695958261;'), ('6talhpcr2o104oq6c0lfm3opu1ac2tk8', '43.245.121.95', '1695958261', '__ci_last_regenerate|i:1695958261;'), ('7isb852p6j2471ipj23paat7742enb6u', '43.245.121.95', '1695968079', '__ci_last_regenerate|i:1695958262;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1696001468;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('c9dv36g112iqco10c81hna3d1culggs5', '43.245.121.95', '1695958264', '__ci_last_regenerate|i:1695958264;'), ('ek3cuogqamnj4e6c4e3po28f18rea3ke', '43.245.121.95', '1695958265', '__ci_last_regenerate|i:1695958265;'), ('83b038flaiqgkmlppk4a1io0cm2umcmv', '43.245.121.95', '1695958266', '__ci_last_regenerate|i:1695958266;'), ('m3gns9ule2h9l5mqucja5m8c6t7lnb48', '43.245.121.95', '1695958266', '__ci_last_regenerate|i:1695958266;'), ('g1nmp33odsku9vkguiojova7j65o431q', '43.245.121.95', '1695958266', '__ci_last_regenerate|i:1695958266;'), ('cnfhk0o4hrn9uk4lgud7f0ioafgbjtoe', '43.245.121.95', '1695958266', '__ci_last_regenerate|i:1695958266;'), ('vn02luj14t8kb9r0kgsrs303lvsggbms', '43.245.121.95', '1695958266', '__ci_last_regenerate|i:1695958266;'), ('4n9171ac45qupl1p657j18i4u5k4v780', '43.245.121.95', '1695958266', '__ci_last_regenerate|i:1695958266;'), ('14rehh14d7rsnphdauq9hfh89hkujr51', '43.245.121.95', '1695958266', '__ci_last_regenerate|i:1695958266;'), ('5mvsgsk776jksd6e7qeqrbnfcgq60r8k', '43.245.121.95', '1695958266', '__ci_last_regenerate|i:1695958266;'), ('phbm6itn0neiotu8i3u9jsofilk1abc1', '43.245.121.95', '1695958266', '__ci_last_regenerate|i:1695958266;'), ('h5140n5jaf7mn36qjv8m80l9d3b7i44b', '43.245.121.95', '1695958266', '__ci_last_regenerate|i:1695958266;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('7e8bbm1bqc0c561ffrrpkij7uvgvau08', '43.245.121.95', '1695958268', '__ci_last_regenerate|i:1695958268;'), ('jrl1p4co1f9oq7ibe3895v12tciil7nf', '43.245.121.95', '1695958400', '__ci_last_regenerate|i:1695958400;'), ('6g1vlb1mt45npvidsom3hce22ga6t6md', '43.245.121.95', '1695958403', '__ci_last_regenerate|i:1695958403;'), ('5ckg0isqt6s7uim6lm7nba4sq98jfhib', '43.245.121.95', '1695958403', '__ci_last_regenerate|i:1695958403;'), ('7vbekcm8tot1r6eb7tn6t6sfoa2cov1i', '43.245.121.95', '1695958403', '__ci_last_regenerate|i:1695958403;'), ('3qnu43pl04hnup7lt8sbsn09i6uorin8', '43.245.121.95', '1695958403', '__ci_last_regenerate|i:1695958403;'), ('u3l72pb34htltj1m3iiggqej6mtfsekh', '43.245.121.95', '1695958403', '__ci_last_regenerate|i:1695958403;'), ('btvuaf95o2h8dt9ksrbbat1jstel16eh', '43.245.121.95', '1695958403', '__ci_last_regenerate|i:1695958403;'), ('0d5tmlbf22isapbholv0ih7m0gvhafas', '43.245.121.95', '1695958404', '__ci_last_regenerate|i:1695958404;'), ('mo6tl6o09g8iuqm83pde9b37neklci0i', '43.245.121.95', '1695958526', '__ci_last_regenerate|i:1695958526;'), ('5h8upnm64oprinn2hv4a1ffs8dqad04t', '43.245.121.95', '1695958526', '__ci_last_regenerate|i:1695958526;'), ('3e953usjdtau15ipbmnbi7ufma0v0im8', '43.245.121.95', '1695958656', '__ci_last_regenerate|i:1695958656;'), ('s5423ck4ptu9680eugodfd5udhpvgg4a', '43.245.121.95', '1695958657', '__ci_last_regenerate|i:1695958657;'), ('pio8oueqmgq3kanc6j855rcki4qig2cq', '43.245.121.95', '1695958657', '__ci_last_regenerate|i:1695958657;'), ('0737mu3bjvvduc21sjdnu3rahqrqu1k9', '43.245.121.95', '1695958658', '__ci_last_regenerate|i:1695958658;'), ('9ov5ao8g2dbp53jv4u81i24vv1pf9iv0', '43.245.121.95', '1695958658', '__ci_last_regenerate|i:1695958658;'), ('v9dt9pbbo05uk3uoh8qoadhs8vvmqsg3', '43.245.121.95', '1695958658', '__ci_last_regenerate|i:1695958658;'), ('mveiem463075mukulo6t5sq7ggu9dvbr', '43.245.121.95', '1695958658', '__ci_last_regenerate|i:1695958658;'), ('pnu5ie1ft4qsdnp9s3jn4n4cncmqn6tb', '43.245.121.95', '1695958658', '__ci_last_regenerate|i:1695958658;'), ('83hrf3tkg0uofhuhqi3rkejt2633gt68', '43.245.121.95', '1695958658', '__ci_last_regenerate|i:1695958658;'), ('f8j4st8u5d3qt8l93m6umgfth9qbm0vm', '43.245.121.95', '1695958674', '__ci_last_regenerate|i:1695958674;'), ('vecmqs282maej5mp5cs29nsjeuj0p93s', '43.245.121.95', '1695958674', '__ci_last_regenerate|i:1695958674;'), ('q2mjipsof1ombmv4afst4m4ts65l9sse', '43.245.121.95', '1695958679', '__ci_last_regenerate|i:1695958679;'), ('7v265a5oafool7anbi8gmaji2jpgorg1', '43.245.121.95', '1695958679', '__ci_last_regenerate|i:1695958679;'), ('k508l67urgs0lokqngagm45sa1p6grd2', '43.245.121.95', '1695958680', '__ci_last_regenerate|i:1695958680;'), ('0aho6idt8pi6bsa41h5qm91nusuaj0d2', '43.245.121.95', '1695958680', '__ci_last_regenerate|i:1695958680;'), ('m789dtskqe68d8vg1qiivp79isasbpm4', '43.245.121.95', '1695958680', '__ci_last_regenerate|i:1695958680;'), ('mbt4dcd8hqkneh4capt4g2ec3bst2tqq', '43.245.121.95', '1695958680', '__ci_last_regenerate|i:1695958680;'), ('0vu1juvrbk7n5msqpua2ls1ctiqad8pg', '43.245.121.95', '1695958680', '__ci_last_regenerate|i:1695958680;'), ('8oir0beojgls7691ntrqir76p81b5qp4', '43.245.121.95', '1695958680', '__ci_last_regenerate|i:1695958680;'), ('d44egnr78bagcrn06p0ld5ui3sd7tgr6', '43.245.121.95', '1695958681', '__ci_last_regenerate|i:1695958681;'), ('cfjk9klbn5i11tp8n6lt8blsgiau1qqi', '43.245.121.95', '1695958682', '__ci_last_regenerate|i:1695958682;'), ('20l57etpnm486054uteta1vejvc36hbb', '43.245.121.95', '1695958682', '__ci_last_regenerate|i:1695958682;'), ('tv2guo707nmasobtej09doq1po54km65', '43.245.121.95', '1695958682', '__ci_last_regenerate|i:1695958682;'), ('2cb5151ue60tnj6hqv7nmu9u5i758spd', '43.245.121.95', '1695958682', '__ci_last_regenerate|i:1695958682;'), ('c1i75ugdmtlm71vg4ti66uhpj1ffbt0s', '43.245.121.95', '1695958682', '__ci_last_regenerate|i:1695958682;'), ('ecsm324nchsoeng4qmb30dt7v7j7p6jd', '43.245.121.95', '1695958685', '__ci_last_regenerate|i:1695958685;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('d05olslnfhbi2jsjq3rcgt32n93vnbi7', '43.245.121.95', '1695958685', '__ci_last_regenerate|i:1695958685;'), ('vss8c6jrmaq4v8ki00qcddltbr9ctclo', '43.245.121.95', '1695958686', '__ci_last_regenerate|i:1695958686;'), ('oabbi89683ba1snh78g849kekqtcoi39', '43.245.121.95', '1695958706', '__ci_last_regenerate|i:1695958706;'), ('3inkp1u1j725737k6amdeo3mf42luu76', '43.245.121.95', '1695958707', '__ci_last_regenerate|i:1695958707;'), ('jjjfbnus5dcoode5j03tg01j35p0j9fg', '43.245.121.95', '1695958709', '__ci_last_regenerate|i:1695958709;'), ('deah0bqs09hnubsgftu8upnggqh0nnc8', '43.245.121.95', '1695958709', '__ci_last_regenerate|i:1695958709;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('qi8q5pf6darr7u4s5i9sq9egmhf78trj', '43.245.121.95', '1695958711', '__ci_last_regenerate|i:1695958711;'), ('rh3pc7h88cskpkve5u9aih8u62jo4pie', '43.245.121.95', '1695958714', '__ci_last_regenerate|i:1695958714;'), ('35v755ppuh6vkr9m3le4stjvpcbmvdq2', '43.245.121.95', '1695958714', '__ci_last_regenerate|i:1695958714;'), ('n14dcgcfckstl65lc49f7reb5t1m5qii', '43.245.121.95', '1695958715', '__ci_last_regenerate|i:1695958715;'), ('c30r7k4jstr7vo5n228b47r5jso74d2v', '43.245.121.95', '1695958715', '__ci_last_regenerate|i:1695958715;'), ('9equ0024m1h0cttu98duv52redk467b7', '43.245.121.95', '1695958716', '__ci_last_regenerate|i:1695958716;'), ('hs7gikvceciotrvvppf1ung866ag307h', '43.245.121.95', '1695958718', '__ci_last_regenerate|i:1695958718;'), ('8072u4pgc412f9302696mjhtuvl7gqid', '43.245.121.95', '1695958718', '__ci_last_regenerate|i:1695958718;'), ('lrrp4cncv7dq3dckup2dvsp2tcdieemt', '43.245.121.95', '1695958721', '__ci_last_regenerate|i:1695958721;'), ('g2h67j3sepfj2oalns8oh0bp4k8gds2c', '43.245.121.95', '1695958721', '__ci_last_regenerate|i:1695958720;'), ('fm384hp4jvs97kid44ut16t4ia72be5o', '43.245.121.95', '1695958721', '__ci_last_regenerate|i:1695958721;'), ('e88cim5mh6k1a9peop51stbmf4s4blbe', '43.245.121.95', '1695958729', '__ci_last_regenerate|i:1695958729;'), ('o1hu86u9gnd300e4a38prt126p0iejij', '43.245.121.95', '1695958729', '__ci_last_regenerate|i:1695958729;'), ('4p1r09p7f13f5ie98ac56jn791l5ql4p', '43.245.121.95', '1695958729', '__ci_last_regenerate|i:1695958729;'), ('vn00c4ejii63umuh0t88shovs78lsngh', '43.245.121.95', '1695958729', '__ci_last_regenerate|i:1695958729;'), ('efbou8rem6ngchsmk29iu6nd67b37uin', '43.245.121.95', '1695958729', '__ci_last_regenerate|i:1695958729;'), ('cnb94kdikpr84urq72mesbtoe9i836c7', '43.245.121.95', '1695958732', '__ci_last_regenerate|i:1695958732;'), ('vbmoig3ci32chtb70hlc19mbc8tqcijl', '43.245.121.95', '1695958732', '__ci_last_regenerate|i:1695958732;'), ('rlcd2rhcbaud223j87t8rbmr0g2jag90', '43.245.121.95', '1695958736', '__ci_last_regenerate|i:1695958736;'), ('6koj60s7maco995mdj8i1j622k5rqmgq', '43.245.121.95', '1695958736', '__ci_last_regenerate|i:1695958736;'), ('oon7j3b90g6qnch62nmeh1kb26ens81d', '43.245.121.95', '1695958737', '__ci_last_regenerate|i:1695958737;'), ('jtf7muh3jad3gu6p0qvua1bqj2bc75tv', '43.245.121.95', '1695958748', '__ci_last_regenerate|i:1695958748;'), ('l7drm9htpk5k8ha44mc2skj4eadaih79', '43.245.121.95', '1695958748', '__ci_last_regenerate|i:1695958748;'), ('sn3tm4e49vmeevrvhvr2nh6ok506najr', '43.245.121.95', '1695958748', '__ci_last_regenerate|i:1695958748;'), ('j9643v22mseruan54c4830ld5pijgs5m', '43.245.121.95', '1695958748', '__ci_last_regenerate|i:1695958748;'), ('20rbqrptdjsnrj3lftbogffpqborueak', '43.245.121.95', '1695958748', '__ci_last_regenerate|i:1695958748;'), ('e1lovgjlga1jhluarn1hpjtig18k89el', '43.245.121.95', '1695958748', '__ci_last_regenerate|i:1695958748;'), ('08ml9os36ej84mqaq23iikupcfc8msmu', '43.245.121.95', '1695958748', '__ci_last_regenerate|i:1695958748;'), ('fmggf7nc1js8ru6lvtoulmbcjmrkrde2', '43.245.121.95', '1695958757', '__ci_last_regenerate|i:1695958757;'), ('ko3hspg4ra6i6ccpubqrglhnkrt3t8bi', '43.245.121.95', '1695958758', '__ci_last_regenerate|i:1695958758;'), ('9o1is7lv6b5qkgtqitmbtq1vfkf1p1rl', '43.245.121.95', '1695958758', '__ci_last_regenerate|i:1695958758;'), ('30avs46eada2rqom6l70kkup7p8g2s2b', '43.245.121.95', '1695958758', '__ci_last_regenerate|i:1695958758;'), ('fcm2gc5bm2opd0dk6elvvdac66t7v63c', '43.245.121.95', '1695958758', '__ci_last_regenerate|i:1695958758;'), ('7v8hmb8pl0kb3jdebg7cjem6sei8pds3', '43.245.121.95', '1695958758', '__ci_last_regenerate|i:1695958758;'), ('tvibbu0c1bsnckca0i92vqoue07sv637', '43.245.121.95', '1695958758', '__ci_last_regenerate|i:1695958758;'), ('clmjq6ljt2qsa6s4beitqj2mh6o5u3sf', '43.245.121.95', '1695958758', '__ci_last_regenerate|i:1695958758;'), ('d9rg56u9jclhunutqm6r339etkcl4aac', '43.245.121.95', '1695958759', '__ci_last_regenerate|i:1695958759;'), ('5klpcvl7584lrnovf358gadh7r8tg5lc', '43.245.121.95', '1695958759', '__ci_last_regenerate|i:1695958759;'), ('3srbpdkopaqaudo9h3o6cb53g09avs0p', '43.245.121.95', '1695958759', '__ci_last_regenerate|i:1695958759;'), ('rakeriqo2jjcrmc4f6eavhg65rqe04s0', '43.245.121.95', '1695958759', '__ci_last_regenerate|i:1695958759;'), ('hkrc5691guf19o4ncva4nc4io53pt21a', '43.245.121.95', '1695958761', '__ci_last_regenerate|i:1695958761;'), ('3dcdfmom3a7252l1s2cdc60hl4250obp', '43.245.121.95', '1695958761', '__ci_last_regenerate|i:1695958761;'), ('s8ij2vlmfb3k3pr9fk04b4j70mhorvgp', '43.245.121.95', '1695959489', '__ci_last_regenerate|i:1695959489;'), ('0o9ci85gvcav7u9ikju0hi73fb877316', '43.245.121.95', '1695959492', '__ci_last_regenerate|i:1695959492;'), ('3ipklfhpn6jp3blj66iarse1dvvcp7ht', '43.245.121.95', '1695959492', '__ci_last_regenerate|i:1695959492;'), ('4hlmjn5ffgc0rvguc61ms40ebureuhq9', '43.245.121.95', '1695959492', '__ci_last_regenerate|i:1695959492;'), ('3hi5va8fc9da6glphvvq55llfadgvaee', '43.245.121.95', '1695959492', '__ci_last_regenerate|i:1695959492;'), ('7g790daqed07fkqnj8p80pup99fg7e12', '43.245.121.95', '1695959492', '__ci_last_regenerate|i:1695959492;'), ('l01s631m9gd2538gih2f6iffepuopk8j', '43.245.121.95', '1695959492', '__ci_last_regenerate|i:1695959492;'), ('f5arja32jb4l3gs3eulpibgg3d91kp0s', '43.245.121.95', '1695959539', '__ci_last_regenerate|i:1695959539;'), ('g1sni7uk5g73esil6onvfjm55v9nbm1b', '43.245.121.95', '1695959553', '__ci_last_regenerate|i:1695959553;'), ('bq1mekhqlkmf2tpptkrfhn0t4hiu8ggl', '43.245.121.95', '1695959557', '__ci_last_regenerate|i:1695959557;'), ('bqh3u1g419jdbunr0t339qjiagjkb1je', '43.245.121.95', '1695959557', '__ci_last_regenerate|i:1695959557;'), ('ue297rjr84dlgl5btmva2ubqrup6krli', '43.245.121.95', '1695959557', '__ci_last_regenerate|i:1695959557;'), ('5daq3f3mqcvmvrcffj5ocujcmnrjq8ts', '43.245.121.95', '1695959557', '__ci_last_regenerate|i:1695959557;'), ('hv9qlpg7e3pk6ov6cij7os04kgbi4rce', '43.245.121.95', '1695959557', '__ci_last_regenerate|i:1695959557;'), ('4iju4p8k8p5j4jkhjjsrhk4l0qagfvrf', '43.245.121.95', '1695959557', '__ci_last_regenerate|i:1695959557;'), ('dnufrf8dta307gmofh5aeh51np8rtdsm', '43.245.121.95', '1695959557', '__ci_last_regenerate|i:1695959557;'), ('qegaeu2muhvsoupjgd5mdq91sg8s22jh', '43.245.121.95', '1695959579', '__ci_last_regenerate|i:1695959579;'), ('9ht9lcc1udno20bedjno2md51t2hjumg', '43.245.121.95', '1695959579', '__ci_last_regenerate|i:1695959579;'), ('6ka0oe3f1i2p78rhfatqi9aa3re47ufo', '43.245.121.95', '1695959580', '__ci_last_regenerate|i:1695959580;'), ('39qcjbqk04p4b564i87oaoigq3jg0ohj', '43.245.121.95', '1695959580', '__ci_last_regenerate|i:1695959580;'), ('rsmtli7d5qq5l8arbdqtpemmeuu8nkk5', '43.245.121.95', '1695959580', '__ci_last_regenerate|i:1695959580;'), ('p20pfis6sftroec23mbq3qheigbqb4tm', '43.245.121.95', '1695959580', '__ci_last_regenerate|i:1695959580;'), ('kn5l14jhk6ub2073le95cehrd663q6ae', '43.245.121.95', '1695959580', '__ci_last_regenerate|i:1695959580;'), ('fgt0o5fljekev3kv1j4a9ca84r7ka62i', '43.245.121.95', '1695959580', '__ci_last_regenerate|i:1695959580;'), ('4mptbeh00edudk534nh6c67v1u9oeog9', '43.245.121.95', '1695959683', '__ci_last_regenerate|i:1695959683;'), ('2sanjudc1436a9chfnvbec2tpq4ga7vr', '43.245.121.95', '1695959683', '__ci_last_regenerate|i:1695959683;'), ('bao15g273cank5gj1pcqehns9i2r4t4l', '43.245.121.95', '1695959683', '__ci_last_regenerate|i:1695959683;'), ('bsgemtqpu48td4kfpojpjl5hesgtig0s', '43.245.121.95', '1695959683', '__ci_last_regenerate|i:1695959683;'), ('g97dl2fqd0reb8fff15l9igu4fmvlnrr', '43.245.121.95', '1695959683', '__ci_last_regenerate|i:1695959683;'), ('uuuc950lo9h9ab1fgneg04jahj1c46md', '43.245.121.95', '1695959698', '__ci_last_regenerate|i:1695959698;'), ('ovfqsj3p3kstks6bgalt1hskf7m793sq', '43.245.121.95', '1695959701', '__ci_last_regenerate|i:1695959701;'), ('hnnip953341k8rjv59tavpcdrhchqtt8', '43.245.121.95', '1695959701', '__ci_last_regenerate|i:1695959701;'), ('f7gcr45aiv7m2qo33f43jrrgkdi9ms3e', '43.245.121.95', '1695959701', '__ci_last_regenerate|i:1695959701;'), ('38u32mc8i6q78k54ak47dcm5tj127miu', '43.245.121.95', '1695959701', '__ci_last_regenerate|i:1695959701;'), ('sf1otof2f2b4c22noptd78rn86t7463o', '43.245.121.95', '1695959701', '__ci_last_regenerate|i:1695959701;'), ('lcekoa91e7q2bak4osalqggbunmsbgrn', '43.245.121.95', '1695959701', '__ci_last_regenerate|i:1695959701;'), ('aso83t6q5quo7buu34gtnmia4tktll6b', '43.245.121.95', '1695959702', '__ci_last_regenerate|i:1695959702;'), ('eefk2ugrutfcgnd8i1p2c5tnvmg6e4h3', '43.245.121.95', '1695959801', '__ci_last_regenerate|i:1695959801;'), ('2arifja242fmhn22ua5hu05bjsk81u54', '43.245.121.95', '1695959804', '__ci_last_regenerate|i:1695959804;'), ('lui47hme14q9ep8lcndl519m0suphi4u', '43.245.121.95', '1695959804', '__ci_last_regenerate|i:1695959804;'), ('dqrtncasr3m3eg6hpngmatqu8qt4o9j7', '43.245.121.95', '1695959804', '__ci_last_regenerate|i:1695959804;'), ('3johd2ah552eju25uo56o0abl5bmcdom', '43.245.121.95', '1695959804', '__ci_last_regenerate|i:1695959804;'), ('a7udcq81vpdl45jd37sm66jmjtjus19r', '43.245.121.95', '1695959804', '__ci_last_regenerate|i:1695959804;'), ('q087b2njhls657h5lmdgrf7hm4ut7e5n', '43.245.121.95', '1695959804', '__ci_last_regenerate|i:1695959804;'), ('odoiben4v78e4rf72vlubssgpbpg44h2', '43.245.121.95', '1695959805', '__ci_last_regenerate|i:1695959805;'), ('us2mlou9mbc0h7930bbci2okvs1dfafu', '43.245.121.95', '1695959869', '__ci_last_regenerate|i:1695959869;'), ('va081635qorg957raiuojrnpqjj6al4d', '43.245.121.95', '1695959872', '__ci_last_regenerate|i:1695959872;'), ('gor3f33bgrd075fc0tuireikjijl8cml', '43.245.121.95', '1695959872', '__ci_last_regenerate|i:1695959872;'), ('c9gadggrrldl4je7n0rb5mo8p2epbrrn', '43.245.121.95', '1695959872', '__ci_last_regenerate|i:1695959872;'), ('lgko79gpa5j72oogf6nbv49ik7clohns', '43.245.121.95', '1695959872', '__ci_last_regenerate|i:1695959872;'), ('fjmuk2hiiralqpjn56tst1n8m0182bdu', '43.245.121.95', '1695959872', '__ci_last_regenerate|i:1695959872;'), ('6has0u48ptf4jca5oobl10cgrgrg161q', '43.245.121.95', '1695959872', '__ci_last_regenerate|i:1695959872;'), ('48brnt7fbh8sv8s8lhqf2pgm25hnj2kd', '43.245.121.95', '1695959873', '__ci_last_regenerate|i:1695959873;'), ('t14llbq4pb8ukgt16bs9jc7cvvloiilp', '43.245.121.95', '1695959879', '__ci_last_regenerate|i:1695959879;'), ('t4j2k54ajqcug1rlm9cm49ifb52vrnv1', '43.245.121.95', '1695959879', '__ci_last_regenerate|i:1695959879;'), ('al7l0g0au01rnb9vrs8ijtn8u2u5a24q', '43.245.121.95', '1695959880', '__ci_last_regenerate|i:1695959880;'), ('i2j2nm2sba6966k7eshq0t6sp4cs2o8v', '43.245.121.95', '1695959880', '__ci_last_regenerate|i:1695959880;'), ('b5gsuklc0n1tasjrhs12rfd5hi2arkam', '43.245.121.95', '1695959880', '__ci_last_regenerate|i:1695959880;'), ('nak710r7jkso6lrrk2nfg6f264i7khp8', '43.245.121.95', '1695959880', '__ci_last_regenerate|i:1695959880;'), ('sg6lbj86ea6muntsueov2qjqjerfdb3g', '43.245.121.95', '1695959880', '__ci_last_regenerate|i:1695959880;'), ('qosrk17v3kecg16ovulfesnco284f9va', '43.245.121.95', '1695959880', '__ci_last_regenerate|i:1695959880;'), ('0frjunb168ibrapveseriguhdtr7qnot', '43.245.121.95', '1695959937', '__ci_last_regenerate|i:1695959937;'), ('7gmfor2pn8odggfus506sthmcegpphbn', '43.245.121.95', '1695959940', '__ci_last_regenerate|i:1695959940;'), ('lkdcqlg669prfjldnrj3v9ll5eou5mm9', '43.245.121.95', '1695959940', '__ci_last_regenerate|i:1695959940;'), ('firorenvagpmdj5bm47ihjq7q0epijf5', '43.245.121.95', '1695959941', '__ci_last_regenerate|i:1695959941;'), ('m5d2m4jfpojg0pqnh8v2ic4rdcmulgc2', '43.245.121.95', '1695959941', '__ci_last_regenerate|i:1695959941;'), ('713901c06bn4iar7i0cjedhr2deu6tas', '43.245.121.95', '1695959941', '__ci_last_regenerate|i:1695959941;'), ('1uiqaoqi71476bn0cvh08krbcgvpqdu4', '43.245.121.95', '1695959941', '__ci_last_regenerate|i:1695959941;'), ('6j7htmevgmvq6h3oahc63b28ej8i0b1b', '43.245.121.95', '1695959941', '__ci_last_regenerate|i:1695959941;'), ('kq50ofj8fr4v9e6r9hfn71eeldjoccn3', '43.245.121.95', '1695959941', '__ci_last_regenerate|i:1695959941;'), ('of786qjij91m59h4eea609v27acf5f45', '43.245.121.95', '1695960004', '__ci_last_regenerate|i:1695960004;'), ('ud8e7846a99i7v5r44vop61rjfl87pdo', '43.245.121.95', '1695960008', '__ci_last_regenerate|i:1695960008;'), ('2psg6r2v3fqop1v0tkmhjpgdo1tm9iqq', '43.245.121.95', '1695960008', '__ci_last_regenerate|i:1695960008;'), ('h4b4s698554n87e2heq9fci8kh8s4n4e', '43.245.121.95', '1695960008', '__ci_last_regenerate|i:1695960008;'), ('3rsp1in8bnndobauvae9iq3729s4pprk', '43.245.121.95', '1695960008', '__ci_last_regenerate|i:1695960008;'), ('kvfts1i59c0oi1gkgnsa6jfim2c149pb', '43.245.121.95', '1695960008', '__ci_last_regenerate|i:1695960008;'), ('r2tc6voupip5kvhq2scuub7f4a4vd47n', '43.245.121.95', '1695960008', '__ci_last_regenerate|i:1695960008;'), ('u3pg7au8t9idhgmcdrgdq090edlvkm5j', '43.245.121.95', '1695960008', '__ci_last_regenerate|i:1695960008;'), ('4rcljc63egf47e6r6rcc1lrgtcrt5mug', '43.245.121.95', '1695960125', '__ci_last_regenerate|i:1695960125;'), ('76t59vhrd154bgbo1ksjrtg38q4ddocr', '43.245.121.95', '1695960414', '__ci_last_regenerate|i:1695960414;'), ('1i1utusttjib4qft865ca04bc9ufvnp7', '43.245.121.95', '1695960418', '__ci_last_regenerate|i:1695960418;'), ('drv37901d4hbec8b0l7bm09ku217k4s2', '43.245.121.95', '1695960418', '__ci_last_regenerate|i:1695960418;'), ('9odvupft5v6ro7nj4uviibr5hi32uoqd', '43.245.121.95', '1695960418', '__ci_last_regenerate|i:1695960418;'), ('08fqdmv996aaaanvchmhkimbpjm46rue', '43.245.121.95', '1695960418', '__ci_last_regenerate|i:1695960418;'), ('jjdd6a20p5ggm8666v5h2fs6r4noj7ba', '43.245.121.95', '1695960418', '__ci_last_regenerate|i:1695960418;'), ('7dofuudstj0gvf4u3toa7mbacdvg1pb1', '43.245.121.95', '1695960418', '__ci_last_regenerate|i:1695960418;'), ('1d2b7hd5p5tb72ekku2suqjtnkdbqsni', '43.245.121.95', '1695960469', '__ci_last_regenerate|i:1695960469;'), ('pp0vsqul8nc48qlqkf2s08kni0buhgpg', '43.245.121.95', '1695960507', '__ci_last_regenerate|i:1695960507;'), ('6jk8nqf283lcvhpvje980c626n0mul4b', '43.245.121.95', '1695960507', '__ci_last_regenerate|i:1695960507;'), ('3rm4nb4crnj4c6ejq7bgjpc17kk5m0ol', '43.245.121.95', '1695960552', '__ci_last_regenerate|i:1695960552;'), ('r9do1nmugidjsc9s5igvj2mocfvrbd8u', '43.245.121.95', '1695960553', '__ci_last_regenerate|i:1695960553;'), ('43mlpaak0m3j7d01si19q5h4vd74q0rv', '43.245.121.95', '1695960574', '__ci_last_regenerate|i:1695960574;'), ('3s78vdl04cgi8utub9c2ace33g1o9bjb', '43.245.121.95', '1695960598', '__ci_last_regenerate|i:1695960598;'), ('o65uk74d9nrglkncbi3sc799te583c15', '43.245.121.95', '1695960599', '__ci_last_regenerate|i:1695960598;'), ('jq637elholc46i1um53rn0ch148trsqr', '43.245.121.95', '1695960924', '__ci_last_regenerate|i:1695960924;'), ('ud27pmncclmcqh3mr6uh4iman8o8181u', '43.245.121.95', '1695960928', '__ci_last_regenerate|i:1695960928;'), ('54lt1ftuphssbrl2r4f0en3oegiikje1', '43.245.121.95', '1695960928', '__ci_last_regenerate|i:1695960928;'), ('dac3ofhrto918ij6j1sf4ps8d38gga84', '43.245.121.95', '1695960928', '__ci_last_regenerate|i:1695960928;'), ('13hk4kgdq7fo4p13pme5fu08nv169n4r', '43.245.121.95', '1695960928', '__ci_last_regenerate|i:1695960928;'), ('77ptcj0q9hs8l60fqt3tqmaimaeq6qvk', '43.245.121.95', '1695960928', '__ci_last_regenerate|i:1695960928;'), ('pfqgr0qgvq848k19lvqo22gea225qopr', '43.245.121.95', '1695960928', '__ci_last_regenerate|i:1695960928;'), ('jbv3m3igkb743s9m28ochde03qh3v5dr', '43.245.121.95', '1695960928', '__ci_last_regenerate|i:1695960928;'), ('cgkerej53aqt5u87ofo70gphqh54dnd1', '43.245.121.95', '1695961038', '__ci_last_regenerate|i:1695961038;'), ('u8kljs4ojo8el7qsocfmi05o70kp30gt', '43.245.121.95', '1695961038', '__ci_last_regenerate|i:1695961038;'), ('00sddc4tbvoq0e04o9g4h8sau3grs307', '43.245.121.95', '1695961039', '__ci_last_regenerate|i:1695961039;'), ('184r8gr15hpgvtr9ge23mmbcds0cn9nf', '43.245.121.95', '1695961039', '__ci_last_regenerate|i:1695961039;'), ('7s1stmm6d98otetsr3qlbmbbc6ld6320', '43.245.121.95', '1695961039', '__ci_last_regenerate|i:1695961039;'), ('afcs1gaem7kkpbn6e42plctmub433jb6', '43.245.121.95', '1695961039', '__ci_last_regenerate|i:1695961039;'), ('om6fqaaasic4g2fa3sfla4e469ibvcrq', '43.245.121.95', '1695961039', '__ci_last_regenerate|i:1695961039;'), ('52s2h39nh0jdi93vd2tr7hi4lfoentd9', '43.245.121.95', '1695961039', '__ci_last_regenerate|i:1695961039;'), ('rdmu0a5q94unhis712b3f4055s7vjlvq', '43.245.120.232', '1695961460', '__ci_last_regenerate|i:1695961460;'), ('3f0ag0q3cunfsc85mjcc965jmkq8cotn', '43.245.120.232', '1695961461', '__ci_last_regenerate|i:1695961461;'), ('6bf2e43ocg239gc2sn7vlm6lffj9ke7c', '43.245.120.232', '1695961465', '__ci_last_regenerate|i:1695961465;'), ('2qo14ugmo6j58u0agnj58mje0g01kt78', '43.245.120.232', '1695961465', '__ci_last_regenerate|i:1695961465;'), ('8j9ktkro0pdcfcplkch9r8jc9rcbjo81', '43.245.120.232', '1695961465', '__ci_last_regenerate|i:1695961465;'), ('4hmlq88apsscm214go0q6if9hrl6vr7g', '43.245.120.232', '1695961465', '__ci_last_regenerate|i:1695961465;'), ('ffnaicrt08stjv63q1qjtq2bqhuildpt', '43.245.120.232', '1695961465', '__ci_last_regenerate|i:1695961465;'), ('csrltfgvpqsk0glqvhnqe3j25a6g0cdk', '43.245.120.232', '1695961466', '__ci_last_regenerate|i:1695961466;'), ('1rjpaeeckb1bo22q5n3jr5b5itliu6jr', '43.245.120.232', '1695961467', '__ci_last_regenerate|i:1695961467;'), ('e9q6pps7oagh4dkvosjhuq5rbihqi8ne', '43.245.120.232', '1695961467', '__ci_last_regenerate|i:1695961467;'), ('4p8koiqb777kvk46t6unn2ehb736e56p', '43.245.120.232', '1695961506', '__ci_last_regenerate|i:1695961506;'), ('tddcgufpndka5ru7juhht9jjo99acu71', '43.245.120.232', '1695961506', '__ci_last_regenerate|i:1695961506;'), ('9kplvnso75g7hq2rmvdnlhhif7phdi51', '43.245.120.232', '1695965526', '__ci_last_regenerate|i:1695965526;'), ('qvf4nrebchqisqlrmb3kluuhi0sa8sbs', '43.245.120.232', '1695965529', '__ci_last_regenerate|i:1695965529;'), ('90p62iieccaqivk15s1ff4ot95n4ce5p', '43.245.120.232', '1695965529', '__ci_last_regenerate|i:1695965529;'), ('gepset0ts5mcqc53j8nulk215rhk1m9e', '43.245.120.232', '1695965529', '__ci_last_regenerate|i:1695965529;'), ('kfv5aetkoachq2aflsvoig87l83mo1jr', '43.245.120.232', '1695965529', '__ci_last_regenerate|i:1695965529;'), ('lg3k460mt3j7t28kli3gbqaokmndg5ko', '43.245.120.232', '1695965529', '__ci_last_regenerate|i:1695965529;'), ('5sjrqsn7gl0dvfg7o3111id7h24bp8ou', '43.245.120.232', '1695965529', '__ci_last_regenerate|i:1695965529;'), ('mqe2kej2h7l3pufgqdc59lnfq7nbact1', '43.245.120.232', '1695965529', '__ci_last_regenerate|i:1695965529;'), ('sto127tr17f67toprm8pbgsc93c1816i', '43.245.120.232', '1695965534', '__ci_last_regenerate|i:1695965534;'), ('n7h3lfiqa2a6v7guth66innimt82p10p', '43.245.120.232', '1695965535', '__ci_last_regenerate|i:1695965535;'), ('kce6cgoiue18oink8auk0c13l0149r8c', '43.245.120.232', '1695965535', '__ci_last_regenerate|i:1695965535;'), ('kk4d5hdm0p2g7kp93crnjnp1cdtdlh78', '43.245.120.232', '1695965535', '__ci_last_regenerate|i:1695965535;'), ('3b38p6eqo71e2askpl0spdnfchcgnhab', '43.245.120.232', '1695965535', '__ci_last_regenerate|i:1695965535;'), ('4cjt538m2l0cdna6e1cafk4ijlr0juun', '43.245.120.232', '1695965535', '__ci_last_regenerate|i:1695965535;'), ('e6305as7rahc8ja98ajqcsgh0ti1d5do', '43.245.120.232', '1695965535', '__ci_last_regenerate|i:1695965535;'), ('9a108lc2642fna8adnugnpshck1eifsv', '43.245.120.232', '1695965535', '__ci_last_regenerate|i:1695965535;'), ('pidtl8fnhetupash7bi9rk6glroha7m2', '43.245.120.232', '1695965564', '__ci_last_regenerate|i:1695965564;'), ('2p2bmqkjovi29qo451he3778oiausk5v', '43.245.120.232', '1695965565', '__ci_last_regenerate|i:1695965565;'), ('piuejd53dk3r8ssqhsiifbom7r5plnma', '43.245.120.232', '1695965566', '__ci_last_regenerate|i:1695965566;'), ('d12es3njlrcfn416031n9dl5hpfogq2j', '43.245.120.232', '1695965568', '__ci_last_regenerate|i:1695965568;'), ('5mhmfo2kob4s67vk8marm0od3j6aa90h', '43.245.120.232', '1695965740', '__ci_last_regenerate|i:1695965740;'), ('hp2n3dts27629perc8kapi4tleb3r720', '43.245.120.232', '1695966194', '__ci_last_regenerate|i:1695966194;'), ('gk3tj338n4mjphtbpbkclogvpkvc9g84', '43.245.120.232', '1695966197', '__ci_last_regenerate|i:1695966197;'), ('ja1jsc4k5cik1io37sm4bkd5md348kve', '43.245.120.232', '1695966197', '__ci_last_regenerate|i:1695966197;'), ('9g58ujlpsjngm9s48059c0vhbanqs0vh', '43.245.120.232', '1695966197', '__ci_last_regenerate|i:1695966197;'), ('iid31c3gdpnejgdggrshmhjnp5s8sd8c', '43.245.120.232', '1695966197', '__ci_last_regenerate|i:1695966197;'), ('s09fl1613psoq8lel86gmhbpqoikl7d7', '43.245.120.232', '1695966197', '__ci_last_regenerate|i:1695966197;'), ('mqf2pf6hpshnsdfjo4afcadbvt076cub', '43.245.120.232', '1695966197', '__ci_last_regenerate|i:1695966197;'), ('5jacbgkpe4cdov5r45lrbf5vet0p4jv5', '43.245.120.232', '1695966198', '__ci_last_regenerate|i:1695966198;'), ('cq4v9tm3096j8lu6h6d1pphck8cj6580', '43.245.120.232', '1695966210', '__ci_last_regenerate|i:1695966210;'), ('8rrmhs9u4kaoncdk1d5fbhf41de0mgee', '43.245.120.232', '1695966211', '__ci_last_regenerate|i:1695966211;'), ('mudih3cdmbr9n7pfao0rfpkh8ov28emq', '43.245.120.232', '1695966211', '__ci_last_regenerate|i:1695966211;'), ('ktpfn8n0ph0ffeu74qldp28a352t1nqm', '43.245.120.232', '1695966211', '__ci_last_regenerate|i:1695966211;'), ('tq2d0661d4qefan76qv0osb3d2nmdoq2', '43.245.120.232', '1695966211', '__ci_last_regenerate|i:1695966211;'), ('82jce10d7jdidg22bsdrhmt5sq9h8u7v', '43.245.120.232', '1695966211', '__ci_last_regenerate|i:1695966211;'), ('v08hl2msadcmq2r35kt2675m0k45v2ip', '43.245.120.232', '1695966211', '__ci_last_regenerate|i:1695966211;'), ('d854pp5ffho0achkt0u0j1eorgo165b1', '43.245.120.232', '1695966211', '__ci_last_regenerate|i:1695966211;'), ('d9ls46vate5ff6h5a8c2eeskuabl6rd1', '43.245.120.232', '1695966466', '__ci_last_regenerate|i:1695966466;'), ('95pedeoombrerrnh001vi729su5kvdkh', '43.245.120.232', '1695966469', '__ci_last_regenerate|i:1695966469;'), ('85vd7m2ae062b5dn4mblt7sn2u0npbtq', '43.245.120.232', '1695966469', '__ci_last_regenerate|i:1695966469;'), ('ic3mauol4hqp3g947athbeboakq5rbt2', '43.245.120.232', '1695966469', '__ci_last_regenerate|i:1695966469;'), ('9moc9lpte7avcij30vhr1c8t9c5mhha1', '43.245.120.232', '1695966469', '__ci_last_regenerate|i:1695966469;'), ('ktc11ikgi6lkd1ie6m79oouubo3252sg', '43.245.120.232', '1695966469', '__ci_last_regenerate|i:1695966469;'), ('n32g7r6sf1igg8qqd2ssf970k9gmro0t', '43.245.120.232', '1695966469', '__ci_last_regenerate|i:1695966469;'), ('rprdlrtg7h49thhp8frbtupi96cfsn9h', '43.245.120.232', '1695966470', '__ci_last_regenerate|i:1695966470;'), ('bbm3jkd345dn276gvra4bevnp8pthfjl', '43.245.120.232', '1695966485', '__ci_last_regenerate|i:1695966485;'), ('8dfa6ness371dhf4i91v7v3bcvpoi9j4', '43.245.120.232', '1695966485', '__ci_last_regenerate|i:1695966485;'), ('391a0fsnm21grot874ufkukjnod183ef', '116.58.201.253', '1695966518', '__ci_last_regenerate|i:1695966518;'), ('o34cnhhuoqt1kogsmll3a775e9922ffo', '43.245.120.232', '1695966521', '__ci_last_regenerate|i:1695966521;'), ('bq3qknrp3kmqkju9pubhrbmcvlfds916', '43.245.120.232', '1695966523', '__ci_last_regenerate|i:1695966523;'), ('g3bp3n0l6va2oq68g5pck4t8vsu2t5vs', '43.245.120.232', '1695966524', '__ci_last_regenerate|i:1695966524;'), ('dnbn24o685oeds1hrum7grcif6ocfmek', '43.245.120.232', '1695966524', '__ci_last_regenerate|i:1695966524;'), ('8rcen78nq8hj67k05ibnfh8p25ajhup7', '43.245.120.232', '1695966525', '__ci_last_regenerate|i:1695966525;'), ('ig0qt3fptq90p25lf0979jd47grau5cq', '43.245.120.232', '1695966525', '__ci_last_regenerate|i:1695966525;'), ('9qcigrtfrq1q7prd59pnqcbmu0cruh0b', '43.245.120.232', '1695966525', '__ci_last_regenerate|i:1695966525;'), ('mgt22lgh2o9g7mvdh00r8ktn0cv423uq', '43.245.120.232', '1695966525', '__ci_last_regenerate|i:1695966525;'), ('ta7cobovdcnsdv5ij5qvafa6m9nqo4hd', '43.245.120.232', '1695966525', '__ci_last_regenerate|i:1695966525;'), ('ghejds9n9ccsoilptd2900c297ckia8n', '43.245.120.232', '1695966525', '__ci_last_regenerate|i:1695966525;'), ('4rol81os6seki0vso67rhma078fk7dff', '43.245.120.232', '1695967005', '__ci_last_regenerate|i:1695967005;'), ('itm696ekgjn79hqqkevle28vilvfa6as', '43.245.120.232', '1695967008', '__ci_last_regenerate|i:1695967008;'), ('21v754agjkl1km7u91kidt5ig99h4u89', '43.245.120.232', '1695967008', '__ci_last_regenerate|i:1695967008;'), ('uspk8vhmqn9u7eq41k0musnk11mskvo0', '43.245.120.232', '1695967008', '__ci_last_regenerate|i:1695967008;'), ('eeu2igo6r704bb0jphspns95rmeul68e', '43.245.120.232', '1695967008', '__ci_last_regenerate|i:1695967008;'), ('ii0r5es2e99kumq3or4363bdfcl6aqet', '43.245.120.232', '1695967008', '__ci_last_regenerate|i:1695967008;'), ('t8ihrt2pfv6m14hidkg3n2p5jfhl0g3o', '43.245.120.232', '1695967008', '__ci_last_regenerate|i:1695967008;'), ('4qlhu8rqh6vkhdbbrtcn925msmgm49v0', '43.245.120.232', '1695967008', '__ci_last_regenerate|i:1695967008;'), ('m92p10dj1d8cuc4il8c3vmbpl68kac8v', '43.245.120.232', '1695967017', '__ci_last_regenerate|i:1695967017;'), ('vufbhtqm71b77c98rvjsihl1hcscbdic', '43.245.120.232', '1695967018', '__ci_last_regenerate|i:1695967018;'), ('6p0tsf85akgldjso9bvmopgre4rt5dom', '43.245.120.232', '1695967019', '__ci_last_regenerate|i:1695967019;'), ('rpi41ncl9d8robgtst7oa1qeo92rcmom', '43.245.120.232', '1695967019', '__ci_last_regenerate|i:1695967019;'), ('nomnbo62hb5sjpg8h6oihvgcsmnmv7jo', '43.245.120.232', '1695967019', '__ci_last_regenerate|i:1695967019;'), ('23j61il97jltl5qvajbnuk2p1l4e0ucc', '43.245.120.232', '1695967019', '__ci_last_regenerate|i:1695967019;'), ('io3cccfri7cug7lv2k60hvqhk2h6glci', '43.245.120.232', '1695967019', '__ci_last_regenerate|i:1695967019;'), ('eaakuep93vfks6b9dde5gq2ingnmc1t2', '43.245.120.232', '1695967019', '__ci_last_regenerate|i:1695967019;'), ('5ssplbt3ub2u01vkmck64obbkqtn9gqk', '43.245.120.232', '1695967196', '__ci_last_regenerate|i:1695967196;'), ('367i9feu0qgvh1sbhob0tdom73v0mm4n', '43.245.120.232', '1695967196', '__ci_last_regenerate|i:1695967196;'), ('7jsb23tee4tbtvp5t54o2ei2vqmmao2e', '43.245.120.232', '1695967197', '__ci_last_regenerate|i:1695967197;'), ('virch3fiuaor56nkge6eg0skes3g09ct', '43.245.120.232', '1695967197', '__ci_last_regenerate|i:1695967197;'), ('uj70313u2ono5sbkbe2epglh314gi8ht', '43.245.120.232', '1695967197', '__ci_last_regenerate|i:1695967197;'), ('j66q972ajqcag52e65rg2f68bibolkj9', '43.245.120.232', '1695967197', '__ci_last_regenerate|i:1695967197;'), ('a8sor2ujabu2ojp3hq9r09dj6mq7vuev', '43.245.120.232', '1695967197', '__ci_last_regenerate|i:1695967197;'), ('pvm4nhjrrlt80gtvj4gr4qp70pio8uqb', '43.245.120.232', '1695967197', '__ci_last_regenerate|i:1695967197;'), ('0su04l4qnctc5d5f8lfs7d824gkk5efr', '43.245.120.232', '1695967207', '__ci_last_regenerate|i:1695967207;'), ('0no9ccdgikmj1o0ghbu31mkv2s739cd3', '43.245.120.232', '1695967207', '__ci_last_regenerate|i:1695967207;'), ('l44rspft6rnl960dvi00okfsd88hros0', '43.245.120.232', '1695967208', '__ci_last_regenerate|i:1695967208;'), ('69s0g0ic2t6vijf1m7jfac8klt170stq', '43.245.120.232', '1695967208', '__ci_last_regenerate|i:1695967208;'), ('ildu33clefnf6jibrs4o78caqi2nh32v', '43.245.120.232', '1695967208', '__ci_last_regenerate|i:1695967208;'), ('orseus2p9go2s2eiv8ae9at3egb03orf', '43.245.120.232', '1695967208', '__ci_last_regenerate|i:1695967208;'), ('ne6ihtd51nm3t7bgq24jhfb80j9oej4q', '43.245.120.232', '1695967208', '__ci_last_regenerate|i:1695967208;'), ('293pthsepnlifi3fkj00u4m45e1esjgo', '43.245.120.232', '1695967208', '__ci_last_regenerate|i:1695967208;'), ('m2fettqdrhdl675ulk3c55dj3901s7ju', '43.245.120.232', '1695967374', '__ci_last_regenerate|i:1695967374;'), ('h7jufkla3rqctotjcfs2a8cdrtijmrma', '43.245.120.232', '1695967376', '__ci_last_regenerate|i:1695967376;'), ('nd2546h1q2r34ndvbmacfvmeq381hn97', '43.245.120.232', '1695967486', '__ci_last_regenerate|i:1695967486;'), ('spr5s71ld9kdf17sqsog48q7u2mp9699', '43.245.120.232', '1695967489', '__ci_last_regenerate|i:1695967489;'), ('65t6pebd0tpqn7r5avefev042mvgihpa', '43.245.120.232', '1695967489', '__ci_last_regenerate|i:1695967489;'), ('sl1kq3afo9e9f16ciu2vv9meecdill33', '43.245.120.232', '1695967489', '__ci_last_regenerate|i:1695967489;'), ('q02a13u7pts4gnerg3g7q4533ql5jomr', '43.245.120.232', '1695967489', '__ci_last_regenerate|i:1695967489;'), ('75039sbupi7vfqjhnfo4otp2k0vg4n6f', '43.245.120.232', '1695967489', '__ci_last_regenerate|i:1695967489;'), ('2f6qsg8c3f51h6e83k8u7rc5r3m6vib7', '43.245.120.232', '1695967489', '__ci_last_regenerate|i:1695967489;'), ('fk8npkv032htd18fl90kakcfq39s0n3n', '43.245.120.232', '1695967490', '__ci_last_regenerate|i:1695967490;'), ('ocdisbijqheugsoco0c7rfvspi922p0f', '43.245.120.232', '1695967492', '__ci_last_regenerate|i:1695967492;'), ('p3cqmov4fmibr4ddtqa5062q4vn2fdpi', '43.245.120.232', '1695967492', '__ci_last_regenerate|i:1695967492;'), ('b7rbl3rujgjbvci40kp32mdrm71be0fs', '43.245.120.232', '1695967493', '__ci_last_regenerate|i:1695967493;'), ('cfdc459l5cdefdjea1ju88bhqrnb6p54', '43.245.120.232', '1695967493', '__ci_last_regenerate|i:1695967493;'), ('o1ds2p4vbh0dpugecddrcisrdt6h0s7m', '43.245.120.232', '1695967493', '__ci_last_regenerate|i:1695967493;'), ('ig2nsupn6ip5ul2lqte2ievlf1bok8dh', '43.245.120.232', '1695967493', '__ci_last_regenerate|i:1695967493;'), ('i5h743j5u5aknn1l8pbca46nrls4p11j', '43.245.120.232', '1695967493', '__ci_last_regenerate|i:1695967493;'), ('v17brjj1magb4f30bloh80gk0a2vnme6', '43.245.120.232', '1695967493', '__ci_last_regenerate|i:1695967493;'), ('1i4e1nag236dg1agnt9oh1dbhal3sn62', '43.245.120.232', '1695967885', '__ci_last_regenerate|i:1695967885;'), ('82977rp0tltddpb00d8ahl6r87310q00', '43.245.120.232', '1695967888', '__ci_last_regenerate|i:1695967888;'), ('c0lk2ao97gflug5j96gasq21slrb0jr2', '43.245.120.232', '1695967888', '__ci_last_regenerate|i:1695967888;'), ('81mfu9f4mljliuik7irimg4vrihgbl8v', '43.245.120.232', '1695967888', '__ci_last_regenerate|i:1695967888;'), ('00vqnku94djdu8hmafjgb5knk6c5ls52', '43.245.120.232', '1695967888', '__ci_last_regenerate|i:1695967888;'), ('4tb9tn9udljv57kaoidtc44anksgqale', '43.245.120.232', '1695967889', '__ci_last_regenerate|i:1695967889;'), ('f9ko1gc86mri8rupiniuk1qccurlb1mj', '43.245.120.232', '1695967889', '__ci_last_regenerate|i:1695967889;'), ('i7gk1mo4q1coulv86dblq8gsl5mhf9on', '43.245.120.232', '1695967889', '__ci_last_regenerate|i:1695967889;'), ('elhn7hg8vq3bavp2rftdn6rlu9bhuloh', '43.245.120.232', '1695968051', '__ci_last_regenerate|i:1695968051;'), ('ro01d639dti6tem9q6e99lnl2if1o6ng', '43.245.120.232', '1695968051', '__ci_last_regenerate|i:1695968051;'), ('eeqc83ndd33v6mf9asc1fl341itqr9e2', '43.245.120.232', '1695968051', '__ci_last_regenerate|i:1695968051;'), ('8fkj13a4v7p9racns7r01hfc6k57do7e', '43.245.120.232', '1695968051', '__ci_last_regenerate|i:1695968051;'), ('ogmjdr2n8ud2vrhlg86i900g9rpgv4rf', '43.245.120.232', '1695968051', '__ci_last_regenerate|i:1695968051;'), ('m27e1a0p873uiak9h36eam8juqhnl4j7', '43.245.120.232', '1695968052', '__ci_last_regenerate|i:1695968052;'), ('m5ro5prvctc1jc1nig7lqfto6s4dnk0c', '43.245.120.232', '1695968058', '__ci_last_regenerate|i:1695968058;'), ('a3qhcovocgu46ouv7g3t74senf5otq9u', '43.245.120.232', '1695968075', '__ci_last_regenerate|i:1695968075;'), ('78bq0fol0vtkub1s2kgmet79v55s7hqd', '43.245.120.232', '1695968076', '__ci_last_regenerate|i:1695968076;'), ('r94dfean2rig4h6fj4ff2dqb8jn3vl1j', '43.245.120.232', '1695968077', '__ci_last_regenerate|i:1695968077;'), ('q2i33hi2kc8n41rus9duddo7mso8dnsd', '43.245.120.232', '1695968079', '__ci_last_regenerate|i:1695968079;'), ('839v463jq41b87rcokn8jb2pmcgjcuts', '43.245.120.232', '1695968080', '__ci_last_regenerate|i:1695968080;'), ('sg96s97ifu4k5fipl9a1cfjj98uvnjrt', '43.245.120.232', '1695968080', '__ci_last_regenerate|i:1695968080;'), ('d4snk0p54h22don5qpf6tok4cnfmht89', '43.245.120.232', '1695968081', '__ci_last_regenerate|i:1695968081;'), ('irer9d9m45stmtfkf23q9qjg5ei7jci3', '43.245.120.232', '1695968081', '__ci_last_regenerate|i:1695968081;'), ('ce68u61gpkojml9ij2o9nkek2ho14iaa', '43.245.120.232', '1695968081', '__ci_last_regenerate|i:1695968081;'), ('pvd3eult7iknf42vgeqkueaet1eqhrkm', '43.245.120.232', '1695968081', '__ci_last_regenerate|i:1695968081;'), ('hqo7enearmr2r7bq22vt7mfnda2a2stf', '43.245.120.232', '1695968081', '__ci_last_regenerate|i:1695968081;'), ('33trp5fo19undjj7er0gnan7ijtmkifc', '43.245.120.232', '1695968081', '__ci_last_regenerate|i:1695968081;'), ('settb5dn6n1fjud7j034uc8diicjdq1e', '43.245.120.232', '1695968177', '__ci_last_regenerate|i:1695968177;'), ('2ps96ddbnj9vd3ljd0gg4vh0tu1n5ggc', '43.245.120.232', '1695968178', '__ci_last_regenerate|i:1695968178;'), ('3h77uik43i9f06pdp770i4r4onsue0rb', '43.245.120.232', '1695968178', '__ci_last_regenerate|i:1695968178;'), ('49va0qhm85lgajkb6jiggshqliaokfe0', '43.245.120.232', '1695968178', '__ci_last_regenerate|i:1695968178;'), ('3saeh1frqd68enn93ke3420kogiip07b', '43.245.120.232', '1695968178', '__ci_last_regenerate|i:1695968178;'), ('qt4pjmt2qso62hooe7e9d7b3m9h5b0ft', '43.245.120.232', '1695968178', '__ci_last_regenerate|i:1695968178;'), ('j7p3jnd3b00ej7eknshlnq2n02nakp31', '43.245.120.232', '1695968178', '__ci_last_regenerate|i:1695968178;'), ('299inkcdbvgnkbfk08jvq971hgh74b9a', '43.245.120.232', '1695968178', '__ci_last_regenerate|i:1695968178;'), ('jm15brefnjstgq5f6udnkt4nds73a33s', '43.245.120.232', '1695968181', '__ci_last_regenerate|i:1695968181;'), ('i9fk618iru8rqirh04c326s0ojme9m4s', '43.245.120.232', '1695968185', '__ci_last_regenerate|i:1695968185;'), ('keaaqlggtruiiirk5lt38cugcs6l06il', '43.245.120.232', '1695968186', '__ci_last_regenerate|i:1695968186;'), ('2d54ob2caf68627uh442pcbt2b5culcq', '43.245.120.232', '1695968186', '__ci_last_regenerate|i:1695968186;'), ('bbc3p4hjes9e7pnm8cujfm9o6mc2mfr4', '43.245.120.232', '1695968186', '__ci_last_regenerate|i:1695968186;'), ('qumho0bq50be2khqlae7s5n5dkgcv7np', '43.245.120.232', '1695968186', '__ci_last_regenerate|i:1695968186;'), ('b9euec6fi2tr190mmfrkpa4pp7kfoots', '43.245.120.232', '1695968186', '__ci_last_regenerate|i:1695968186;'), ('rn9f89lvsgevdu2671sf9v1nu362nhem', '43.245.120.232', '1695968186', '__ci_last_regenerate|i:1695968186;'), ('lgth97pnftqiibjfknghfk17nvkg1ujo', '43.245.120.232', '1695968187', '__ci_last_regenerate|i:1695968187;'), ('68vk4i76m39h13iobq1dv1ng44fd6h4i', '43.245.120.232', '1695968187', '__ci_last_regenerate|i:1695968187;'), ('gjkhthdq2j4g0vrvmjk56q5ak6o99jc3', '43.245.120.232', '1695968187', '__ci_last_regenerate|i:1695968187;'), ('nttfuo96idfqt4gfvl31rc0gvv5m7eno', '43.245.120.232', '1695968187', '__ci_last_regenerate|i:1695968187;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('njvu80cgqa0cnhnmttbhslgts14pf32u', '43.245.120.232', '1695968190', '__ci_last_regenerate|i:1695968190;'), ('7e1mnsdq03uftdd4ulpsp1f5hiqpnfo1', '43.245.120.232', '1695974542', '__ci_last_regenerate|i:1695968190;custom_session_limit|i:1696011390;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";cart_items|a:0:{}language|s:7:\"english\";cachedContent|s:47:\"\n    <!-- Your page content goes here -->\n\n    \";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('m1vj2qqtirjf9gb7tm98lo2mmmrndif9', '43.245.120.232', '1695968329', '__ci_last_regenerate|i:1695968329;'), ('ef7vlb8j9bneng4g9pgt1jp0iriiqv1l', '43.245.120.232', '1695968336', '__ci_last_regenerate|i:1695968336;'), ('3o6t9rha1i34baghnhg9tlukclrj70cu', '43.245.120.232', '1695968336', '__ci_last_regenerate|i:1695968336;'), ('buhkhvub3bhu0odcgtdavdad60f4r6v4', '43.245.120.232', '1695968337', '__ci_last_regenerate|i:1695968337;'), ('2kfn0ft5ntl5o99qs152dp4qvn890rvr', '43.245.120.232', '1695968337', '__ci_last_regenerate|i:1695968337;'), ('h0kvq19vg8apmn18c1k7a8ckp1rhe1j1', '43.245.120.232', '1695968337', '__ci_last_regenerate|i:1695968337;'), ('acq1dqa7ksdqrfbrqai69ju60rfc2rq8', '43.245.120.232', '1695968337', '__ci_last_regenerate|i:1695968337;'), ('550kvkm42prnramj3euct6307pv00tqn', '43.245.120.232', '1695968337', '__ci_last_regenerate|i:1695968337;'), ('6tmpda21i12oeqobqgjpdfs8jaahqm5q', '43.245.120.232', '1695968337', '__ci_last_regenerate|i:1695968337;'), ('7q9p3ddn3podj1deqgc0c0suq6cp1mlc', '43.245.120.232', '1695968339', '__ci_last_regenerate|i:1695968339;'), ('7o4spnlk3kss55q5lonv4j1ntleqk16v', '43.245.120.232', '1695968340', '__ci_last_regenerate|i:1695968340;'), ('n4svu7bsaghoo3ib8nm62b4g484ukq3f', '43.245.120.232', '1695968612', '__ci_last_regenerate|i:1695968612;'), ('p72okb67sks0ubl4si5mjgtbc0c85hq3', '43.245.120.232', '1695968614', '__ci_last_regenerate|i:1695968614;'), ('pjbdsjtu9ofur9v6fh1vv41lvfbp7td5', '43.245.120.232', '1695968615', '__ci_last_regenerate|i:1695968615;'), ('i1k8ehhsdeoclaj1v0fl5nbrubqtul3q', '43.245.120.232', '1695968615', '__ci_last_regenerate|i:1695968615;'), ('o85k971r7tlk5la5smkhb8rqdraippnd', '43.245.120.232', '1695968615', '__ci_last_regenerate|i:1695968615;'), ('637afl53ih21165n8tg512vui5rc5dio', '43.245.120.232', '1695968615', '__ci_last_regenerate|i:1695968615;'), ('bpr3l503p4i69ri3doumferr0688delf', '43.245.120.232', '1695968615', '__ci_last_regenerate|i:1695968615;'), ('lim0tfl4v0l8th4phe0m6pjerliujcl8', '43.245.120.232', '1695968615', '__ci_last_regenerate|i:1695968615;'), ('n9j7i1ko764dt5sjal3i2jm5f0qspgrt', '43.245.120.232', '1695968615', '__ci_last_regenerate|i:1695968615;'), ('lr0nmasre9udam3tbqpfo49at9oad63j', '43.245.120.232', '1695968638', '__ci_last_regenerate|i:1695968638;'), ('olnjelriln98ap3dr3or4621qnv8c4ph', '43.245.120.232', '1695968707', '__ci_last_regenerate|i:1695968707;'), ('i8pabe2kq1r6vs0ofnqfmh3v580tluln', '43.245.120.232', '1695968707', '__ci_last_regenerate|i:1695968707;'), ('i0d9ohd7aa71k0i6ahhhjv4lmm6h4j4e', '43.245.120.232', '1695968707', '__ci_last_regenerate|i:1695968707;'), ('kg2e1r098qli6fej2i27qeobeergic2r', '43.245.120.232', '1695968707', '__ci_last_regenerate|i:1695968707;'), ('2b49sdrdigkau6pskb8f0dv0209f47k0', '43.245.120.232', '1695968707', '__ci_last_regenerate|i:1695968707;'), ('b436mklj1qbi9i2lsfu9rk7d79bpo63r', '43.245.120.232', '1695968707', '__ci_last_regenerate|i:1695968707;'), ('71lnmq8r39ub5k22pqshigde9i9kcekb', '43.245.120.232', '1695968707', '__ci_last_regenerate|i:1695968707;'), ('ddliimhule66p9qqc0n3cp5qevckhb5s', '43.245.120.232', '1695968708', '__ci_last_regenerate|i:1695968708;'), ('eoqdmus1dhhcq6gg7m6s5u1kagetha85', '43.245.120.232', '1695968709', '__ci_last_regenerate|i:1695968709;'), ('dfpfaub0dajmejtsi26fsqfa5v4sq5jh', '43.245.120.232', '1695968851', '__ci_last_regenerate|i:1695968851;'), ('g35jahd6217b21kt5k7irbp8cpjhakhe', '43.245.120.232', '1695968852', '__ci_last_regenerate|i:1695968852;'), ('bmqqkpa2citgd8accj9g136qk8q9uge1', '43.245.120.232', '1695968852', '__ci_last_regenerate|i:1695968852;'), ('maf75ts9fquicnpa9dp45oj32t32lscg', '43.245.120.232', '1695968852', '__ci_last_regenerate|i:1695968852;'), ('8imhnvp6et2ud0lbgkjko3gd5lurkvr7', '43.245.120.232', '1695968852', '__ci_last_regenerate|i:1695968852;'), ('vv6ujjgacvfce3v2vhhhk33u5cal8k4d', '43.245.120.232', '1695968852', '__ci_last_regenerate|i:1695968852;'), ('hqutaagr41r2f6qg35f7915c3fegokcf', '43.245.120.232', '1695968852', '__ci_last_regenerate|i:1695968852;'), ('msf23k6eaunfvcv758rt13d33nolbrov', '43.245.120.232', '1695968852', '__ci_last_regenerate|i:1695968852;'), ('gbjj68uefsa6chf38fqbs1tpcb5s9j50', '43.245.120.232', '1695968975', '__ci_last_regenerate|i:1695968975;'), ('hf5sv9esqi23rcp5paoqnj43k8dep9qb', '43.245.120.232', '1695968979', '__ci_last_regenerate|i:1695968979;'), ('h8t3dhmdtviib83p0ahdrceaqpn65m7j', '43.245.120.232', '1695968979', '__ci_last_regenerate|i:1695968979;'), ('sanlq9jokmsv38mva1t2lg00gocb1k7u', '43.245.120.232', '1695968980', '__ci_last_regenerate|i:1695968980;'), ('djtvdtcr26e6o7s43bv14o4fsg72bekf', '43.245.120.232', '1695968980', '__ci_last_regenerate|i:1695968980;'), ('s7f69r50apu8aji9u9mcea34uoadh7an', '43.245.120.232', '1695968980', '__ci_last_regenerate|i:1695968980;'), ('k3orb8d8393sb08j13pbr77e0heenen1', '43.245.120.232', '1695968980', '__ci_last_regenerate|i:1695968980;'), ('aqeneddquqso7d39uj195np3a26rl01n', '43.245.120.232', '1695968980', '__ci_last_regenerate|i:1695968980;'), ('qbj6l6qkutogec9u8kr9shb730so4m6r', '43.245.120.232', '1695968980', '__ci_last_regenerate|i:1695968980;'), ('evhmhk2is0cn21ap2mt0cm5tsbtov8kr', '43.245.120.232', '1695969012', '__ci_last_regenerate|i:1695969012;'), ('u9r3k8qb8s9sohcmomh71qe87sc8m802', '43.245.120.232', '1695969075', '__ci_last_regenerate|i:1695969075;'), ('8mlguefiv7idabt950u9rs14n4q84aj6', '43.245.120.232', '1695969109', '__ci_last_regenerate|i:1695969109;'), ('d5h5v9n6pn2pem5m6pbdor42v3f7bp2n', '43.245.120.232', '1695969109', '__ci_last_regenerate|i:1695969109;'), ('dajutlegsi7sucijpgvb0ubgck54udqu', '43.245.120.232', '1695969109', '__ci_last_regenerate|i:1695969109;'), ('s11p8268k4b1solojuuso8bfq9l144dg', '43.245.120.232', '1695969109', '__ci_last_regenerate|i:1695969109;'), ('od8oophu72ig37pspps4gb1plf6cpo32', '43.245.120.232', '1695969109', '__ci_last_regenerate|i:1695969109;'), ('65eam2kagj2r6go3hsn1etlmg934k7nj', '43.245.120.232', '1695969109', '__ci_last_regenerate|i:1695969109;'), ('n3lmef3eqbflpj4qb6d1o707d4mfci2l', '43.245.120.232', '1695969109', '__ci_last_regenerate|i:1695969109;'), ('186mg4dknh6kqhes7k9crbv1sspjtus8', '43.245.120.232', '1695969109', '__ci_last_regenerate|i:1695969109;'), ('502o2mpkvgn8nk0usjlsv3jlbute6pca', '43.245.120.232', '1695969119', '__ci_last_regenerate|i:1695969119;'), ('33qssnm53qgpasjojka7in5t3r4a4v8n', '43.245.120.232', '1695969174', '__ci_last_regenerate|i:1695969174;'), ('ln57jo797mcmg5i9155jk50lrk8ftaj9', '43.245.120.232', '1695969207', '__ci_last_regenerate|i:1695969207;'), ('g9mk7663nmsemie33rrsdbesgouf3jh6', '43.245.120.232', '1695969300', '__ci_last_regenerate|i:1695969300;'), ('jbkoj2olcnsdj6mnh4hndag8j0ec5fr0', '43.245.120.232', '1695969302', '__ci_last_regenerate|i:1695969302;'), ('urpumme7eiq9rjfiqf15qio517bn5kjt', '43.245.120.232', '1695969302', '__ci_last_regenerate|i:1695969302;'), ('ta6eff0l6duct1eoou06dp7dvetil5qo', '43.245.120.232', '1695969303', '__ci_last_regenerate|i:1695969303;'), ('26ak335dv5qa19nheickggirb6045cko', '43.245.120.232', '1695969303', '__ci_last_regenerate|i:1695969303;'), ('iqr9tn1r6to949rji8jo16vre5ec1acn', '43.245.120.232', '1695969303', '__ci_last_regenerate|i:1695969303;'), ('isd1jlq1tfsbt9t8j5s79j5mjfl3ou0n', '43.245.120.232', '1695969303', '__ci_last_regenerate|i:1695969303;'), ('caomnbtpoeqea4uqvu1sdsgsrjlaeomt', '43.245.120.232', '1695969303', '__ci_last_regenerate|i:1695969303;'), ('novhsnknb2bfdsk0uclf1mmegotig1ld', '43.245.120.232', '1695969303', '__ci_last_regenerate|i:1695969303;'), ('q6sbdb3a9clu7li34127907dleqj7ucl', '43.245.120.232', '1695969423', '__ci_last_regenerate|i:1695969423;'), ('najvaojdik6vvr8lfr1jnnrduf5lekn5', '43.245.120.232', '1695969427', '__ci_last_regenerate|i:1695969427;'), ('mcvvn0aidi0kieukrh420lm31fulb4en', '43.245.120.232', '1695969427', '__ci_last_regenerate|i:1695969427;'), ('ela9fvviopfo4bm7k6j3h8q0619e4gag', '43.245.120.232', '1695969427', '__ci_last_regenerate|i:1695969427;'), ('fepscgnjs505inuepq3eorj2700e2tv2', '43.245.120.232', '1695969427', '__ci_last_regenerate|i:1695969427;'), ('jpoltd91e4j2af009o84e80uop0gn5oj', '43.245.120.232', '1695969427', '__ci_last_regenerate|i:1695969427;'), ('d1m03f39t1cdkg071g6h9nfskh84ibbl', '43.245.120.232', '1695969427', '__ci_last_regenerate|i:1695969427;'), ('fll0pnl2dd7hrskl3gtmhabs1avp34ed', '43.245.120.232', '1695969427', '__ci_last_regenerate|i:1695969427;'), ('7fmpee71265coge3brsrkn3gn7kolh19', '43.245.120.232', '1695969431', '__ci_last_regenerate|i:1695969431;'), ('28efkid9aafsfhuh6q8ed3h3cd7jbsf9', '43.245.120.232', '1695969431', '__ci_last_regenerate|i:1695969431;'), ('adq0vh1fdt8l359tkk303irgpo5vh2qd', '43.245.120.232', '1695969432', '__ci_last_regenerate|i:1695969432;'), ('g77e9ep0kjhml7h3m0uvco2prv19tcjq', '43.245.120.232', '1695969432', '__ci_last_regenerate|i:1695969432;'), ('ccq28qqmbmktcaraqhiqonhhjpl7pkjs', '43.245.120.232', '1695969432', '__ci_last_regenerate|i:1695969432;'), ('prkuikhprvj7tb934hla4koui4t7lol6', '43.245.120.232', '1695969432', '__ci_last_regenerate|i:1695969432;'), ('cpik37jvb5btit6elq723jisq87d15pi', '43.245.120.232', '1695969432', '__ci_last_regenerate|i:1695969432;'), ('s47i01jpthslolclnkeumb4q1afo0ccc', '43.245.120.232', '1695969432', '__ci_last_regenerate|i:1695969432;'), ('5lq1gd0qftsbr6a221biabl6k29fmvc5', '43.245.120.232', '1695969436', '__ci_last_regenerate|i:1695969436;'), ('otl265m5qa7np9b7ftbveg39ki7f73cg', '43.245.120.232', '1695969436', '__ci_last_regenerate|i:1695969436;'), ('ctuv6ltbvu64plm4muqkqb1so6d04g9i', '43.245.120.232', '1695969436', '__ci_last_regenerate|i:1695969436;'), ('p5hgqni86j0eadgjs9hk6781d18vfahs', '43.245.120.232', '1695969436', '__ci_last_regenerate|i:1695969436;'), ('l4ir6ffk1vpsllp0v28s2a0iglriqn68', '43.245.120.232', '1695969437', '__ci_last_regenerate|i:1695969437;'), ('4jahb2jg1oqkhug5mj16dfi4i5imrntu', '43.245.120.232', '1695969438', '__ci_last_regenerate|i:1695969438;'), ('ce18mpdgehshmddemfvt87sm2plp8jhv', '43.245.120.232', '1695969439', '__ci_last_regenerate|i:1695969439;'), ('thhqqsjfrpipcphg3mgcj1cu7a0sco7t', '43.245.120.232', '1695969439', '__ci_last_regenerate|i:1695969439;'), ('7014atgi9tesuanm9t6ecr36g26r2lgo', '43.245.120.232', '1695969439', '__ci_last_regenerate|i:1695969439;'), ('gt3tpmhbd9it28fbu9gigtc8to5s0qru', '43.245.120.232', '1695969439', '__ci_last_regenerate|i:1695969439;'), ('au097jgrn51jqcgt2vdlahlgm2mg3pb2', '43.245.120.232', '1695969439', '__ci_last_regenerate|i:1695969439;'), ('qpu8e9tmksjfclfsokasj7drntrcimb3', '43.245.120.232', '1695969439', '__ci_last_regenerate|i:1695969439;'), ('o3c5gp8ablbso5t9g3aiq4efr1jm639r', '43.245.120.232', '1695969439', '__ci_last_regenerate|i:1695969439;'), ('89ocfn35pmkn0pmj75tglt27j00aj4dg', '43.245.120.232', '1695969441', '__ci_last_regenerate|i:1695969441;'), ('uot7uflfcu6b9r4bpv5mji2n3g8sl7mk', '43.245.120.232', '1695969580', '__ci_last_regenerate|i:1695969580;'), ('u358epfsqliieuvi113i57s998hj9vu0', '43.245.120.232', '1695969583', '__ci_last_regenerate|i:1695969583;'), ('kmdsn89q0ppeemkpatk0c1m7g0q28gih', '43.245.120.232', '1695969583', '__ci_last_regenerate|i:1695969583;'), ('h576ip9lqtrcq2quhtrs01m21teigqjb', '43.245.120.232', '1695969583', '__ci_last_regenerate|i:1695969583;'), ('b0j6lggllkdbs8b3k04kkc8e8v98jqv1', '43.245.120.232', '1695969583', '__ci_last_regenerate|i:1695969583;'), ('597emou3nl343g7n9gtj4m9kc6vot289', '43.245.120.232', '1695969583', '__ci_last_regenerate|i:1695969583;'), ('j7555jf9jov9ta73506tphicr6iqr9t9', '43.245.120.232', '1695969583', '__ci_last_regenerate|i:1695969583;'), ('4aje907gtpnlamel42505ngc8fe8gql3', '43.245.120.232', '1695969584', '__ci_last_regenerate|i:1695969584;'), ('t2qpc4n9isf0ofkj42vm5voj694dua7p', '43.245.120.232', '1695969589', '__ci_last_regenerate|i:1695969589;'), ('lbj5d2d0u6h14p04guemuhrdtil9djri', '43.245.120.232', '1695969589', '__ci_last_regenerate|i:1695969589;'), ('k966sjc7ju61o0ofsgteljrm4ic3ds50', '43.245.120.232', '1695969590', '__ci_last_regenerate|i:1695969590;'), ('8q7v9qnikpa3jga66eoqf0oc1vj96837', '43.245.120.232', '1695969590', '__ci_last_regenerate|i:1695969590;'), ('nel9ruep1pa6lh3j3gi6hp6l0kv17si2', '43.245.120.232', '1695969590', '__ci_last_regenerate|i:1695969590;'), ('289bkkmkridhqvh1dmkrmfuja1ncl6te', '43.245.120.232', '1695969590', '__ci_last_regenerate|i:1695969590;'), ('3t3asjafenuouca5ur0823plpc39qplq', '43.245.120.232', '1695969590', '__ci_last_regenerate|i:1695969590;'), ('d64jl5eua9ldqra7erb3rrtfubsejbue', '43.245.120.232', '1695969590', '__ci_last_regenerate|i:1695969590;'), ('hkregpjarv47aen4a9nkhbaf4v6e80b5', '43.245.120.232', '1695969595', '__ci_last_regenerate|i:1695969595;'), ('sngqhq201d0g7qe0ava7lrim4unouf01', '43.245.120.232', '1695969663', '__ci_last_regenerate|i:1695969663;'), ('7vhvhc3n79pnha1osh4qs3q9c10imjd8', '43.245.120.232', '1695969666', '__ci_last_regenerate|i:1695969666;'), ('5p54pne4knqlq916n5vve7iv2ivm03s0', '43.245.120.232', '1695969666', '__ci_last_regenerate|i:1695969666;'), ('u0jmov6dtmprat9p6o92ntbo3son75ba', '43.245.120.232', '1695969666', '__ci_last_regenerate|i:1695969666;'), ('re4q64kdg9ij7r7df7earki0hatam6k1', '43.245.120.232', '1695969666', '__ci_last_regenerate|i:1695969666;'), ('mvkg8fqieuoocdfu643ai5d70uvtckq6', '43.245.120.232', '1695969666', '__ci_last_regenerate|i:1695969666;'), ('49gae4ksevj5k2e1qk97f5j016fcvjii', '43.245.120.232', '1695969667', '__ci_last_regenerate|i:1695969667;'), ('l392ts0dvmj8aombamvl6qao4btd22cc', '43.245.120.232', '1695969667', '__ci_last_regenerate|i:1695969667;'), ('2b90jk11a83njtir6lf4c5b7vbd23i0e', '43.245.120.232', '1695969670', '__ci_last_regenerate|i:1695969670;'), ('nirovegqh2m3uinpmg779v8icshnhunc', '43.245.120.232', '1695970049', '__ci_last_regenerate|i:1695970049;'), ('ff1gd2g515t824dn67i10pd4oeh79cf7', '43.245.120.232', '1695970051', '__ci_last_regenerate|i:1695970051;'), ('bh123addukmnf3k1meq65ori090nfm9n', '43.245.120.232', '1695970052', '__ci_last_regenerate|i:1695970052;'), ('krob7mhf4kqbh10670bhermdlodikeec', '43.245.120.232', '1695970053', '__ci_last_regenerate|i:1695970053;'), ('o8l2e7c35ata48hemv2o8uj115tftbat', '43.245.120.232', '1695970053', '__ci_last_regenerate|i:1695970053;'), ('gl2enbhkm59g0fg2a0u6ic69v196jkol', '43.245.120.232', '1695970053', '__ci_last_regenerate|i:1695970053;'), ('7crdinai21apnfvs74p4l9ju3lqi499u', '43.245.120.232', '1695970053', '__ci_last_regenerate|i:1695970053;'), ('s5ikbp663e333kmbnns43ajsc4bjjl60', '43.245.120.232', '1695970053', '__ci_last_regenerate|i:1695970053;'), ('v8oev43jb3mkflt0k7cnard5f7ju91be', '43.245.120.232', '1695970053', '__ci_last_regenerate|i:1695970053;'), ('ovjvtum1lfa7ciqb0i70ldnn3at533ra', '43.245.120.232', '1695970071', '__ci_last_regenerate|i:1695970071;'), ('ev5feu9h8lcqcdl766dv966duie9k7ud', '43.245.120.232', '1695970078', '__ci_last_regenerate|i:1695970078;'), ('d89u2hvg6oto03sji0f8m63p2bl402t0', '43.245.120.232', '1695970078', '__ci_last_regenerate|i:1695970078;'), ('0jsajjmkosg4nditlm9them97cbupd0m', '43.245.120.232', '1695970079', '__ci_last_regenerate|i:1695970079;'), ('g320c3apdhurdgl6ieib3q2pk5bn4ejq', '43.245.120.232', '1695970079', '__ci_last_regenerate|i:1695970079;'), ('60c1titvjedgvqr842bm99auuvh85m3m', '43.245.120.232', '1695970079', '__ci_last_regenerate|i:1695970079;'), ('4cdtk0sp8gevtt2q3kgbuv3m281g2mj5', '43.245.120.232', '1695970079', '__ci_last_regenerate|i:1695970079;'), ('p5veb2s5a3rtfns7j68a3ii0h6l025ic', '43.245.120.232', '1695970079', '__ci_last_regenerate|i:1695970079;'), ('ch4fjb2nfsag8mkdanpamq774b9vfrfq', '43.245.120.232', '1695970144', '__ci_last_regenerate|i:1695970144;'), ('sea29ukmd0apovruv0nic18c18dmde30', '43.245.120.232', '1695970219', '__ci_last_regenerate|i:1695970219;'), ('tuteb859rqcv7tcp31ruf8lb4tpa8g9f', '43.245.120.232', '1695970221', '__ci_last_regenerate|i:1695970221;'), ('cusu9ocodvqthnst1v9bd4flg5ot9eb7', '43.245.120.232', '1695970361', '__ci_last_regenerate|i:1695970361;'), ('hkvkt3010drcmk607145kcvdpp09mr0k', '43.245.120.232', '1695970363', '__ci_last_regenerate|i:1695970363;'), ('sc3jcslpjuqrh076cc5cq3d6bkomeia2', '43.245.120.232', '1695970366', '__ci_last_regenerate|i:1695970366;'), ('bu24a3t2b7jr97ku5mdchlv5ueomagiu', '43.245.120.232', '1695970366', '__ci_last_regenerate|i:1695970366;'), ('86l2c35tlq6gjrqh9ivh7qi0auvr8imi', '43.245.120.232', '1695970367', '__ci_last_regenerate|i:1695970367;'), ('eomgkajhgib7kscv6m9g3mbh6he2ua59', '43.245.120.232', '1695970367', '__ci_last_regenerate|i:1695970367;'), ('8cm7scv39oglavum36nogh8k09t9i5hb', '43.245.120.232', '1695970367', '__ci_last_regenerate|i:1695970367;'), ('0ouftjfc5m1uldhbft85bavguq3drk0e', '43.245.120.232', '1695970367', '__ci_last_regenerate|i:1695970367;'), ('sp2ruundilrqqqej6j383m2rhbsltg4a', '43.245.120.232', '1695970367', '__ci_last_regenerate|i:1695970367;'), ('36fngic7lvhvjbd8j56pf6ier1o891fe', '43.245.120.232', '1695970367', '__ci_last_regenerate|i:1695970367;'), ('o4sfsaakini6a7qioermad1ap29tmhh8', '43.245.120.232', '1695970489', '__ci_last_regenerate|i:1695970489;'), ('rmmcu1l6234f3if0mm4gi3failunc4j6', '43.245.120.232', '1695970512', '__ci_last_regenerate|i:1695970512;'), ('ilti1le78cv95qihoq8ibftltcinlebf', '43.245.120.232', '1695970600', '__ci_last_regenerate|i:1695970600;'), ('d33hk2fokj6297f8amp1t1i3pr8db9bf', '43.245.120.232', '1695970712', '__ci_last_regenerate|i:1695970712;'), ('jpp9q70v8bs8cmmgcg212233ubdpptne', '43.245.120.232', '1695970713', '__ci_last_regenerate|i:1695970713;'), ('53sj6usaet6tmdt2atpdub9uo869t38g', '43.245.120.232', '1695970713', '__ci_last_regenerate|i:1695970713;'), ('2juf0qcfnhn9fm1kmklape1n8a9gtk0c', '43.245.120.232', '1695970713', '__ci_last_regenerate|i:1695970713;'), ('7mrlv0vsugpe73bc24rkh4blk6e8n63e', '43.245.120.232', '1695970713', '__ci_last_regenerate|i:1695970713;'), ('g9fs030suta0nfuou32gvt9iio7vaio7', '43.245.120.232', '1695970713', '__ci_last_regenerate|i:1695970713;'), ('acgdvi8ujirg6hudlcjgal7oakibnsde', '43.245.120.232', '1695970713', '__ci_last_regenerate|i:1695970713;'), ('9mvd7h36lnhsfco0msed25indolkgpdo', '43.245.120.232', '1695970713', '__ci_last_regenerate|i:1695970713;'), ('q3kdl5a5s98e36ums7mjvad39ubdn8j4', '43.245.120.232', '1695970715', '__ci_last_regenerate|i:1695970715;'), ('le7e3b57nv2a3smlfus8d3m1mfnk20ha', '43.245.120.232', '1695970716', '__ci_last_regenerate|i:1695970716;'), ('bq2beoc8ds2s96bougm9078j34alb75i', '43.245.120.232', '1695970716', '__ci_last_regenerate|i:1695970716;'), ('rdam5680u8o56rfredufqc5gp9iftkal', '43.245.120.232', '1695970716', '__ci_last_regenerate|i:1695970716;'), ('hs4qi6vm0tn0n1pcafs7r2pekjv131pr', '43.245.120.232', '1695970716', '__ci_last_regenerate|i:1695970716;'), ('l5qjiekrfno5f8c07qu7n94r9u9m1drr', '43.245.120.232', '1695970716', '__ci_last_regenerate|i:1695970716;'), ('on8f6iovd8oqt6i0v2ps2lpcbubdb8oa', '43.245.120.232', '1695970716', '__ci_last_regenerate|i:1695970716;'), ('grk2e9hasqcq10m9u2u8vgf9brn6cel6', '43.245.120.232', '1695970716', '__ci_last_regenerate|i:1695970716;'), ('vrslpnh2mhnbfsgboftcmqbsabb57qbs', '43.245.120.232', '1695970797', '__ci_last_regenerate|i:1695970797;'), ('k7ssopdojuelih4st8ismf86ebp5roti', '43.245.120.232', '1695970799', '__ci_last_regenerate|i:1695970799;'), ('3mtqi37km2ked1m2j3n50lnra6a31ftu', '43.245.120.232', '1695970862', '__ci_last_regenerate|i:1695970862;'), ('575jqauquf03bht6f2g6n8ftmo657q1j', '43.245.120.232', '1695970864', '__ci_last_regenerate|i:1695970864;'), ('revujerpvt85svbne66rrj2ksft1sod2', '43.245.120.232', '1695970991', '__ci_last_regenerate|i:1695970991;'), ('64iq7qpqiaatngp2t5ma9ssdriqvmr2s', '43.245.120.232', '1695970993', '__ci_last_regenerate|i:1695970993;'), ('vauc69brf85po912qjkhr0i6lpok9ekd', '43.245.120.232', '1695971007', '__ci_last_regenerate|i:1695971007;'), ('19dta91m9qgdabsub5rpm8cu21k2cobk', '43.245.120.232', '1695971007', '__ci_last_regenerate|i:1695971007;'), ('4ka67pnku5lasb84vrg3t7hu6gt9bm4e', '43.245.120.232', '1695971007', '__ci_last_regenerate|i:1695971007;'), ('077o9kgnavcso685m5vqf803and55ou1', '43.245.120.232', '1695971095', '__ci_last_regenerate|i:1695971095;'), ('eqomoifph453eafhl5s3ftvbsgmlt0ph', '43.245.120.232', '1695971097', '__ci_last_regenerate|i:1695971097;'), ('p6sgmlidee22fmsdm6884dbck8o5odc9', '43.245.120.232', '1695971113', '__ci_last_regenerate|i:1695971113;'), ('n65jbiacmnrk2u4tgm82o723d99nopt7', '43.245.120.232', '1695971178', '__ci_last_regenerate|i:1695971178;'), ('2ntad94uun7gjueaengrt62jdgs66fo1', '43.245.120.232', '1695973700', '__ci_last_regenerate|i:1695973700;'), ('7tqi5crkm80dr9hh0ef078rci9u98lh0', '43.245.120.232', '1695973703', '__ci_last_regenerate|i:1695973703;'), ('2f1mlggeun43nonrdfirk9eo128s890c', '43.245.120.232', '1695973703', '__ci_last_regenerate|i:1695973703;'), ('4sou94tevj6ffegi3mo7171oulf8e4nc', '43.245.120.232', '1695973703', '__ci_last_regenerate|i:1695973703;'), ('lci3pcpc0ebscum5p2nhrqeku1akdahl', '43.245.120.232', '1695973703', '__ci_last_regenerate|i:1695973703;'), ('sadeppg1slt4hu8i47ms7a0uro07nkch', '43.245.120.232', '1695973703', '__ci_last_regenerate|i:1695973703;'), ('obbsgdltnta48ja7rlfcme5l5pg1u0mj', '43.245.120.232', '1695973703', '__ci_last_regenerate|i:1695973703;'), ('nqisjt5nm6l3618nmj9tpiodta8m96hr', '43.245.120.232', '1695973704', '__ci_last_regenerate|i:1695973704;'), ('ka8qvrp3ajl72e4pnd1qrvgcr6fptun6', '43.245.120.232', '1695973706', '__ci_last_regenerate|i:1695973706;'), ('rvf268oji7habrgc4ftg183qgg3215br', '43.245.120.232', '1695973706', '__ci_last_regenerate|i:1695973706;'), ('jukpm7k80f2gffdoshlv8cdmbgj8j71i', '43.245.120.232', '1695973706', '__ci_last_regenerate|i:1695973706;'), ('1b50sdg0ctqj5t50k26feq06rsp8t9hm', '43.245.120.232', '1695973706', '__ci_last_regenerate|i:1695973706;'), ('6jvhp5ept67o4egbi9sck8v3ajm9blof', '43.245.120.232', '1695973707', '__ci_last_regenerate|i:1695973707;'), ('8b77f3mi6trv9a7k3cok4885ev4o4d65', '43.245.120.232', '1695973715', '__ci_last_regenerate|i:1695973715;'), ('25kg90mv86p1ehumog5l0qqq84j8ul2j', '43.245.120.232', '1695973715', '__ci_last_regenerate|i:1695973715;'), ('7pm5ntd0nf6vbo7td8bho1o6jk79qbdr', '43.245.120.232', '1695973715', '__ci_last_regenerate|i:1695973715;'), ('crd4qlulmvipf8l2gag6aqmc00c5vsq2', '43.245.120.232', '1695973715', '__ci_last_regenerate|i:1695973715;'), ('r1nnsn2ipm60f3ckhf8tjieiuvsoq3hj', '43.245.120.232', '1695973715', '__ci_last_regenerate|i:1695973715;'), ('ssggpr3i56lqsn829nliknpqp30l50rj', '43.245.120.232', '1695973715', '__ci_last_regenerate|i:1695973715;'), ('35i7eg95qi6j9jb0vflg0kr6gig1rjpu', '43.245.120.232', '1695973716', '__ci_last_regenerate|i:1695973716;'), ('08i2chltgjh7avbk5af4u99lbjkufbti', '43.245.120.232', '1695973742', '__ci_last_regenerate|i:1695973742;'), ('insbfrr7kqnl76f7aef4plbvt8edrmbc', '43.245.120.232', '1695973743', '__ci_last_regenerate|i:1695973743;'), ('pfe0m4vvk99l25e58hl5u8qgrg7s5ihl', '43.245.120.232', '1695973743', '__ci_last_regenerate|i:1695973743;'), ('jnnt0h6gfdmlk9bfmib316jpergd7sgc', '43.245.120.232', '1695973743', '__ci_last_regenerate|i:1695973743;'), ('0qknkd4315kj2rl09k34gdqbl5strner', '43.245.120.232', '1695973743', '__ci_last_regenerate|i:1695973743;'), ('76u0djh21rpkt8kb6j177fkps5ue2j1e', '43.245.120.232', '1695973743', '__ci_last_regenerate|i:1695973743;'), ('6n8vpui1inj7g98qvtd91spmr93eng7m', '43.245.120.232', '1695973743', '__ci_last_regenerate|i:1695973743;'), ('ia5lkg6hreaj880il6ftdc5oi6imfk25', '43.245.120.232', '1695973743', '__ci_last_regenerate|i:1695973743;'), ('vqdm73pu70qv6dk44aipjl3bi8i4t68j', '43.245.120.232', '1695974016', '__ci_last_regenerate|i:1695974016;'), ('eo299rsait3l4fsmsrvb6feaf26pi46h', '43.245.120.232', '1695974020', '__ci_last_regenerate|i:1695974020;'), ('g3rdq2r2uf0afs9m2lrqu8p168eihm5e', '43.245.120.232', '1695974020', '__ci_last_regenerate|i:1695974020;'), ('jnbpki6n7j0mo3uqv3525uih7eo05l2j', '43.245.120.232', '1695974021', '__ci_last_regenerate|i:1695974021;'), ('8ccvh42b7n4ipiprrdqlrp8ac4u1b35u', '43.245.120.232', '1695974021', '__ci_last_regenerate|i:1695974021;'), ('5mj8vtbfhh4sflmjclvfbpaardevbi80', '43.245.120.232', '1695974021', '__ci_last_regenerate|i:1695974021;'), ('sibapdank4m56aggrn39m1fcih2ib6eo', '43.245.120.232', '1695974021', '__ci_last_regenerate|i:1695974021;'), ('26of5cvk8aipgiaa9lceeh6no7ba1v0i', '43.245.120.232', '1695974021', '__ci_last_regenerate|i:1695974021;'), ('cga80oojepn20qo8gob61ueocuos168m', '43.245.120.232', '1695974021', '__ci_last_regenerate|i:1695974021;'), ('oese4s8nua82fb7nka6lg66s34euh50l', '43.245.120.232', '1695974021', '__ci_last_regenerate|i:1695974021;'), ('osrff4lq2l9iibusm3jsq50g3supk1k4', '43.245.120.232', '1695974021', '__ci_last_regenerate|i:1695974021;'), ('akjp1ms160k0eqtd5v3c2o3lfsoes9ju', '43.245.120.232', '1695974022', '__ci_last_regenerate|i:1695974022;'), ('d2k4geg9vg9s1jlvbkfbsh6kf1o4oahn', '43.245.120.232', '1695974198', '__ci_last_regenerate|i:1695974198;'), ('u0t2rftbbo6st0rk9n8a6vck12ck73co', '43.245.120.232', '1695974217', '__ci_last_regenerate|i:1695974217;'), ('fgffrpi7p2287iiafqt7mmiaqf5r11ot', '43.245.120.232', '1695974434', '__ci_last_regenerate|i:1695974434;'), ('d50b1rq1p034sf5gv0sk9fq4ft6hlct8', '43.245.120.232', '1695974480', '__ci_last_regenerate|i:1695974480;'), ('6311o1mj60oo8ldlnpbss90ek0osddok', '43.245.120.232', '1695974483', '__ci_last_regenerate|i:1695974483;'), ('t8t5k986do5ljopvlpalq4kt2ejefqpf', '43.245.120.232', '1695974483', '__ci_last_regenerate|i:1695974483;'), ('qskc4je8eor8ouvd0a8la6jqbq33k7d6', '43.245.120.232', '1695974483', '__ci_last_regenerate|i:1695974483;'), ('ieu1v6uovf8p90lmtbmh4trpiqcp3mfq', '43.245.120.232', '1695974483', '__ci_last_regenerate|i:1695974483;'), ('re9r91v4cc2g7re95n9qo23tsaouoj37', '43.245.120.232', '1695974483', '__ci_last_regenerate|i:1695974483;'), ('hj883o4k8jtukctht6oot22iqrev4re9', '43.245.120.232', '1695974483', '__ci_last_regenerate|i:1695974483;'), ('lfj1kuc10pv6924uccuucacc8oa4s9bo', '43.245.120.232', '1695974484', '__ci_last_regenerate|i:1695974484;'), ('a77lrl4fvp4sa8nmqsafb69j0kc127du', '43.245.120.232', '1695974498', '__ci_last_regenerate|i:1695974498;'), ('g71eb3vu7rj2t21fmbd6kbi5netq1ctj', '43.245.120.232', '1695974498', '__ci_last_regenerate|i:1695974498;'), ('hb51sv6tthtoaava1c2kmvl646jrcfpf', '43.245.120.232', '1695974498', '__ci_last_regenerate|i:1695974498;'), ('ptmgikp593418e48n16k9odj4be3fvto', '43.245.120.232', '1695974498', '__ci_last_regenerate|i:1695974498;'), ('saiv6mgn1llf0velobgj2ttjh4u8l3au', '43.245.120.232', '1695974500', '__ci_last_regenerate|i:1695974500;'), ('h8o7bbiiig0ohidkd888090ap74hs1d5', '43.245.120.232', '1695974528', '__ci_last_regenerate|i:1695974528;'), ('6tb0pqimk5ohoh3n420d43hm73fosftl', '43.245.120.232', '1695974531', '__ci_last_regenerate|i:1695974531;'), ('hshm15qt3shsb5v4mgipoqg5farl3933', '43.245.120.232', '1695974532', '__ci_last_regenerate|i:1695974532;'), ('d1c47vlsttvnquqd2bnbmiqqi0kcd2r6', '43.245.120.232', '1695974532', '__ci_last_regenerate|i:1695974532;'), ('oe9vc8mepp90blju7utum4m1iogg392l', '43.245.120.232', '1695974532', '__ci_last_regenerate|i:1695974532;'), ('5uh3o9bf97782n8mtbfsnctbb9d7ks7c', '43.245.120.232', '1695974532', '__ci_last_regenerate|i:1695974532;'), ('8rk2et2g20mhssuoaa1i69botmrf3vml', '43.245.120.232', '1695974532', '__ci_last_regenerate|i:1695974532;'), ('1ks7knou4gojeu0a0f6ovhm3ucaldggj', '43.245.120.232', '1695974532', '__ci_last_regenerate|i:1695974532;'), ('3te7ke193t84aonv8cpushuqat5a9mmm', '43.245.120.232', '1695974533', '__ci_last_regenerate|i:1695974533;'), ('hegc1ivvn6fbkeqh11er4ihm7mj3ddp7', '43.245.120.232', '1695974533', '__ci_last_regenerate|i:1695974533;'), ('kgdbbboefr103l3tf26dlg3d9mpi4s9c', '43.245.120.232', '1695974533', '__ci_last_regenerate|i:1695974533;'), ('vo8fao9rdsi2jelpfi6vdgjc3rie61fo', '43.245.120.232', '1695974535', '__ci_last_regenerate|i:1695974535;'), ('v9c5vj236r526janvbgbcn5h9o859iak', '43.245.120.232', '1695974543', '__ci_last_regenerate|i:1695974543;'), ('rk6ftv1habfn66lh05qjpjg4nbp907ep', '43.245.120.232', '1695974543', '__ci_last_regenerate|i:1695974543;'), ('vd2mdp8lu7k4lefvfi25hhdholp3ltbf', '43.245.120.232', '1695974543', '__ci_last_regenerate|i:1695974543;'), ('jfoobo7hsgledpjes7robrb4cdhrusds', '43.245.120.232', '1695974544', '__ci_last_regenerate|i:1695974544;'), ('bp9tt5qi4psumpl2ne5r27pp1kijfsts', '43.245.120.232', '1695974571', '__ci_last_regenerate|i:1695974571;'), ('7j3c68goprkgbg2ucu06baagcu6nu8js', '43.245.120.232', '1695974575', '__ci_last_regenerate|i:1695974575;'), ('qumuefsbpamjv17ch8n85vkcbm4v4r4b', '43.245.120.232', '1695974575', '__ci_last_regenerate|i:1695974575;'), ('mvmio2nttt3hlmkihe1ooukls12bc1v2', '43.245.120.232', '1695974575', '__ci_last_regenerate|i:1695974575;'), ('qo9ifu7cdcg8fo6oj275mqom1c9fqel6', '43.245.120.232', '1695974575', '__ci_last_regenerate|i:1695974575;'), ('qmcvev6b5euuput31fe8649rdq5c4k5r', '43.245.120.232', '1695974575', '__ci_last_regenerate|i:1695974575;'), ('k481kb1ph0q6ehrvrftkgln25e6cpbl0', '43.245.120.232', '1695974575', '__ci_last_regenerate|i:1695974575;'), ('ie3d40ctqclbpu054ahvrr2eintet9hu', '43.245.120.232', '1695974575', '__ci_last_regenerate|i:1695974575;'), ('s62m5hec8fdlig1cidh1ppkfhf1nck5o', '43.245.120.232', '1695974577', '__ci_last_regenerate|i:1695974577;'), ('8r0dh8jgm3ra4mbrt7vmbdh5inagfvc5', '43.245.120.232', '1695974577', '__ci_last_regenerate|i:1695974577;'), ('ajrgoatsomcn7dam797kl7ov4oem55p6', '43.245.120.232', '1695974577', '__ci_last_regenerate|i:1695974577;'), ('0jgjts0bohgfd9bmcirhp33iqnlr1i95', '43.245.120.232', '1695974578', '__ci_last_regenerate|i:1695974578;'), ('h9p3oioupe612e1fqtqrbipjkfh35lta', '43.245.120.232', '1695974588', '__ci_last_regenerate|i:1695974588;'), ('2edfo70shqkclmknegh5gahdhvd8l3gd', '43.245.120.232', '1695974656', '__ci_last_regenerate|i:1695974656;'), ('s5r75g3h969d015smd7g34ofpcg1epq2', '43.245.120.232', '1695974659', '__ci_last_regenerate|i:1695974659;'), ('s3ehjfjrn8jpbrkhpdl3jam8rh396ttr', '43.245.120.232', '1695974659', '__ci_last_regenerate|i:1695974659;'), ('f9aoshm5merg3sr8d4b3u2hn6j8gl42s', '43.245.120.232', '1695974659', '__ci_last_regenerate|i:1695974659;'), ('462r02j9utgj7bfsk3hiu12tctjlu1uf', '43.245.120.232', '1695974659', '__ci_last_regenerate|i:1695974659;'), ('l671v5bo040ua9bgoelosplljl5kasja', '43.245.120.232', '1695974659', '__ci_last_regenerate|i:1695974659;'), ('tn09e9uund1iuodgu0b892bb952maiue', '43.245.120.232', '1695974659', '__ci_last_regenerate|i:1695974659;'), ('d37pc4sp1qtpj1nplt09f4p81m4mfbjj', '43.245.120.232', '1695974660', '__ci_last_regenerate|i:1695974660;'), ('mffp82gbb3vu0mgrud7v6c1pkid32g4r', '43.245.120.232', '1695974674', '__ci_last_regenerate|i:1695974674;'), ('65kjrvjjbtat9mmsj8vmaflvlttn4qq4', '43.245.120.232', '1695974675', '__ci_last_regenerate|i:1695974675;'), ('v5rci652r11i26eq5clb8lrj9q9gep2q', '43.245.120.232', '1695974675', '__ci_last_regenerate|i:1695974675;'), ('0e5mjoiuk69ab2c121ubjcpim91s7qsb', '43.245.120.232', '1695974675', '__ci_last_regenerate|i:1695974675;'), ('arkg0trk9i7o174e7ub0tn6p94pmn768', '43.245.120.232', '1695974675', '__ci_last_regenerate|i:1695974675;'), ('rotrgcr684fpka0bt8pc9net6oqi5sb7', '43.245.120.232', '1695974675', '__ci_last_regenerate|i:1695974675;'), ('vqtqg98ha6khpqbldbnmkcl8ffv4kedh', '43.245.120.232', '1695974675', '__ci_last_regenerate|i:1695974675;'), ('pksqdsis91echvbtgq67d5sfibvfqn1r', '43.245.120.232', '1695974676', '__ci_last_regenerate|i:1695974676;'), ('mvg66a2enmjfkfe4rbmrs0jev0u498a4', '43.245.120.232', '1695974676', '__ci_last_regenerate|i:1695974676;'), ('3ng2niihnr59mugkgot8utou7hvldvvp', '43.245.120.232', '1695974676', '__ci_last_regenerate|i:1695974676;'), ('orjtb8id79mrq0gl4to25jblss2dgaor', '43.245.120.232', '1695974676', '__ci_last_regenerate|i:1695974676;'), ('5puq2grfn3utfcmdvog35q2uandgu820', '43.245.120.232', '1695974676', '__ci_last_regenerate|i:1695974676;'), ('b07qfdef2tmdqpeigppeta7p2umh9hk0', '43.245.120.232', '1695974677', '__ci_last_regenerate|i:1695974677;'), ('m7qn7952smlnbv53hdeftug44vd23em4', '43.245.120.232', '1695974685', '__ci_last_regenerate|i:1695974685;'), ('k8hbsghchaq1qelgiec8qsgknuvo547q', '43.245.120.232', '1695974685', '__ci_last_regenerate|i:1695974685;'), ('m9tb3rssbttev002jik2dialun3h3orc', '43.245.120.232', '1695974685', '__ci_last_regenerate|i:1695974685;'), ('u6vr2rksc6b5vi6akpis9hpft7u4pqj4', '43.245.120.232', '1695974685', '__ci_last_regenerate|i:1695974685;'), ('467f3253ph0uv7hdrornhius9dmlmfjf', '43.245.120.232', '1695974685', '__ci_last_regenerate|i:1695974685;'), ('6puqq6jqauooh8tu51elhu07b61ek91t', '43.245.120.232', '1695974686', '__ci_last_regenerate|i:1695974686;'), ('cv89sekra2bmpg0t6hhhcmcauj4um7je', '43.245.120.232', '1695974689', '__ci_last_regenerate|i:1695974689;'), ('ds912elimsnvo69squfkes6b12n1em3l', '43.245.120.232', '1695974759', '__ci_last_regenerate|i:1695974759;'), ('lu632649oeb5h4fa4jqe4do8thfmne2h', '43.245.120.232', '1695974885', '__ci_last_regenerate|i:1695974885;'), ('c8md08t5rpes9qohsb8o704kp1mjh5ol', '43.245.120.232', '1695974888', '__ci_last_regenerate|i:1695974888;'), ('bt23305ojaj5t2f90a90pldhetoaqlvm', '43.245.120.232', '1695974888', '__ci_last_regenerate|i:1695974888;'), ('sjhe4oe6usjhgto4jduq6gde725cqt4e', '43.245.120.232', '1695974888', '__ci_last_regenerate|i:1695974888;'), ('k87keorrinef803oqrula05sr506vd5q', '43.245.120.232', '1695974888', '__ci_last_regenerate|i:1695974888;'), ('61uodai30u97kmkf93k27udgosr3iomn', '43.245.120.232', '1695974888', '__ci_last_regenerate|i:1695974888;'), ('uiim7lu0brfhcg7gp12k4bdcmnnvjgsc', '43.245.120.232', '1695974889', '__ci_last_regenerate|i:1695974889;'), ('5c9dctthaa95it9rrs8ti2f3hv67pomi', '43.245.120.232', '1695974890', '__ci_last_regenerate|i:1695974890;'), ('1c5r49a2f2lu2a1vr2hbg9mams3et9iv', '43.245.120.232', '1695975174', '__ci_last_regenerate|i:1695975174;'), ('fki0njnkv2r9sauhqlp3879rcg547au9', '43.245.120.232', '1695975285', '__ci_last_regenerate|i:1695975285;'), ('akgee004s55npm43ru3meopbbaa4cafk', '43.245.120.232', '1695975351', '__ci_last_regenerate|i:1695975351;'), ('32rbm5of2cv7q9evhl092n38padb0er1', '43.245.120.232', '1695975354', '__ci_last_regenerate|i:1695975354;'), ('2dd05bs2pkqpu22cn86gq5ispkfm0cfl', '43.245.120.232', '1695975354', '__ci_last_regenerate|i:1695975354;'), ('860rhn5lfvi6i1hk2ucogttnol6qfm9p', '43.245.120.232', '1695975354', '__ci_last_regenerate|i:1695975354;'), ('plmpc8scoof7mbemkc4oefgmgajsnh8d', '43.245.120.232', '1695975354', '__ci_last_regenerate|i:1695975354;'), ('92ju7kiec9ivcdq6d5q1vck80vrnhg8o', '43.245.120.232', '1695975354', '__ci_last_regenerate|i:1695975354;'), ('dhjjci2qhk8v428ctic2kci2gop5iael', '43.245.120.232', '1695975354', '__ci_last_regenerate|i:1695975354;'), ('hud245ik28go588aifcultl6vqjrj23u', '43.245.120.232', '1695975355', '__ci_last_regenerate|i:1695975355;'), ('qmcvgtgillu8brtefvnvc6ml31nbh957', '43.245.120.232', '1695975374', '__ci_last_regenerate|i:1695975374;'), ('tfnj3kpgksukpugkp2ck080faq0obc9u', '43.245.120.232', '1695975396', '__ci_last_regenerate|i:1695975396;'), ('b14nagcfd0hp59sjb56ch14v3sllb804', '43.245.120.232', '1695975430', '__ci_last_regenerate|i:1695975430;'), ('g61s6pp540t4ue4nl13n92b5usoh5t7i', '43.245.120.232', '1695975431', '__ci_last_regenerate|i:1695975431;'), ('miqargljjdmo5beq4b0p9nlh2qgi08p7', '43.245.120.232', '1695975431', '__ci_last_regenerate|i:1695975431;'), ('pa93irs0chgm0vdpafp2rgr91n07pjjk', '43.245.120.232', '1695975431', '__ci_last_regenerate|i:1695975431;'), ('gj1juj65jp4mgeimosgf95t6mjr3cgf0', '43.245.120.232', '1695975431', '__ci_last_regenerate|i:1695975431;'), ('3ki7a2kl4rggso9lmkml8okkitcut0sv', '43.245.120.232', '1695975431', '__ci_last_regenerate|i:1695975431;'), ('slqp0b5gia6avvlqsgl9jvsho59giv7u', '43.245.120.232', '1695975431', '__ci_last_regenerate|i:1695975431;'), ('0re45l125den2a27o17dj812jccdclmm', '43.245.120.232', '1695975431', '__ci_last_regenerate|i:1695975431;'), ('mu1flr5267dpp00dpvkkj8bnoiq9m3ac', '43.245.120.232', '1695975431', '__ci_last_regenerate|i:1695975431;'), ('mdn257heivk3se7fhm6pviop3o7ghocm', '43.245.120.232', '1695975431', '__ci_last_regenerate|i:1695975431;'), ('il2tf8aq7l2v7c9sus560o7t83ikfndr', '43.245.120.232', '1695975431', '__ci_last_regenerate|i:1695975431;'), ('796bpvo6lnq5h1c076ubtg6ltjdj3boh', '43.245.120.232', '1695975431', '__ci_last_regenerate|i:1695975431;'), ('j3ob9ri83o03h6og3qrkko2ebf4ll1l2', '43.245.120.232', '1695975432', '__ci_last_regenerate|i:1695975432;'), ('m9meo0g7edvvn87di4feqdoc8o72j717', '43.245.120.232', '1695975436', '__ci_last_regenerate|i:1695975436;'), ('7tlcc7eb5c9h418poo0kmn0bdenp8bc4', '43.245.120.232', '1695975436', '__ci_last_regenerate|i:1695975436;'), ('umdcgstp8pog1tbr6j2qh7gom8e0ki9q', '43.245.120.232', '1695975436', '__ci_last_regenerate|i:1695975436;'), ('hjjrrpnnsmae63vmamejta475k13uv0g', '43.245.120.232', '1695975436', '__ci_last_regenerate|i:1695975436;'), ('lusmepchlv659q9jkd5our4sr51etaan', '43.245.120.232', '1695975436', '__ci_last_regenerate|i:1695975436;'), ('7o7si0g80on7mplmgfbrvuhc1mceone6', '43.245.120.232', '1695975436', '__ci_last_regenerate|i:1695975436;'), ('v18fe6fgatlvu1cim90bko9n04o8o0t7', '43.245.120.232', '1695975436', '__ci_last_regenerate|i:1695975436;'), ('09uqv85sp93vg5jhu8tv0v96jrg4vt69', '43.245.120.232', '1695975447', '__ci_last_regenerate|i:1695975447;'), ('pn4npc5algfirpmu6mg2nbl68rb61umm', '43.245.120.232', '1695975458', '__ci_last_regenerate|i:1695975458;'), ('n34a18sjkb61s60iemqsvho5ila4r26g', '43.245.120.232', '1695975459', '__ci_last_regenerate|i:1695975459;'), ('pcg19rak2drf6to8c652sd1m2cn7t1g5', '43.245.120.232', '1695975459', '__ci_last_regenerate|i:1695975459;'), ('8c815hb5qjjd1q0mh9921l8qjn5sl27s', '43.245.120.232', '1695975459', '__ci_last_regenerate|i:1695975459;'), ('21knudcbeonif4g09sououfbmp8h8ekg', '43.245.120.232', '1695975459', '__ci_last_regenerate|i:1695975459;'), ('v3evkca4p60l2q1jdmspho3c86gedhdv', '43.245.120.232', '1695975459', '__ci_last_regenerate|i:1695975459;'), ('7hjijgngfstv9rn8ifkjrrrvejk38vmt', '43.245.120.232', '1695975459', '__ci_last_regenerate|i:1695975459;'), ('ihs4f3q7acch8if7t8dm7nev447iknjq', '43.245.120.232', '1695975459', '__ci_last_regenerate|i:1695975459;'), ('mn3uclt7voj3o912jiq109f04c9uugfq', '43.245.120.232', '1695975460', '__ci_last_regenerate|i:1695975460;'), ('c02ue8os20jkfsaanjl5a34bq8htpan0', '43.245.120.232', '1695975460', '__ci_last_regenerate|i:1695975460;'), ('eddghdpjuvgaiq3hjn9ghlcaiodf8aj3', '43.245.120.232', '1695975460', '__ci_last_regenerate|i:1695975460;'), ('r8t12hgf56o1jad52eh8ngu1jb9om1hm', '43.245.120.232', '1695975460', '__ci_last_regenerate|i:1695975460;'), ('fsvch89de8bvd82bad2ne7o5o80pfsgq', '43.245.120.232', '1695975463', '__ci_last_regenerate|i:1695975463;'), ('a0pkve6o0unsnrjp9mirfk479u6i5bg8', '43.245.120.232', '1695975463', '__ci_last_regenerate|i:1695975463;'), ('b9td518lq5vlkq2up50imig4ugs0gdcv', '43.245.120.232', '1695975463', '__ci_last_regenerate|i:1695975463;'), ('ckclbi42k8872o99ol62n65s32a0vh14', '43.245.120.232', '1695975463', '__ci_last_regenerate|i:1695975463;'), ('bnaskavvd0rce49hlnpu51fcqjg1rrvc', '43.245.120.232', '1695975463', '__ci_last_regenerate|i:1695975463;'), ('nrr8dkk123eg4s8n160lnhimnnhrn6ui', '43.245.120.232', '1695975463', '__ci_last_regenerate|i:1695975463;'), ('rmcvu6njcjab6upk07q2q2nij0jiijcr', '43.245.120.232', '1695975463', '__ci_last_regenerate|i:1695975463;'), ('iklubdibc1rejv20em0g4p34lod7ogh9', '43.245.120.232', '1695975477', '__ci_last_regenerate|i:1695975477;'), ('gd7dmlbnedsr3ljbjfnuqqgveteh9d61', '43.245.120.232', '1695975477', '__ci_last_regenerate|i:1695975477;'), ('n56hab19up8386b3av4gbgite7ubfkqs', '43.245.120.232', '1695975477', '__ci_last_regenerate|i:1695975477;'), ('bqftn18tjbs9slh3qktequebnan9ofv4', '43.245.120.232', '1695975477', '__ci_last_regenerate|i:1695975477;'), ('bgbhh4ad2jds3r15ief19lr2748na1st', '43.245.120.232', '1695975477', '__ci_last_regenerate|i:1695975477;'), ('bl5s0rsnd3ph6bfjctoi8930ru64m2v8', '43.245.120.232', '1695975477', '__ci_last_regenerate|i:1695975477;'), ('94vik208ala9d2ea4igs6el3oqmgf4hm', '43.245.120.232', '1695975477', '__ci_last_regenerate|i:1695975477;'), ('tjo01kgk7l6q6n3jjf75tas9cbdp8tqe', '43.245.120.232', '1695975478', '__ci_last_regenerate|i:1695975478;'), ('5und6jud5moageldfji15dpfm8hur1iv', '43.245.120.232', '1695975579', '__ci_last_regenerate|i:1695975579;'), ('4esb8f12m6sm6776ks38bptmsf0iforc', '43.245.120.232', '1695975579', '__ci_last_regenerate|i:1695975579;'), ('o0e0b6c0briat9ovhqt2k0h89ku7ki9b', '43.245.120.232', '1695975579', '__ci_last_regenerate|i:1695975579;'), ('u5q7lfvfunhiel63mt8r5fssmp4a52vf', '43.245.120.232', '1695975579', '__ci_last_regenerate|i:1695975579;'), ('tffkcrr12v2lm4prc572d2gl5vnpf7gf', '43.245.120.232', '1695975579', '__ci_last_regenerate|i:1695975579;'), ('on0kbvughr4psp5kg1o0i3t966aqskl3', '43.245.120.232', '1695975579', '__ci_last_regenerate|i:1695975579;'), ('lu9tn4t3pg0c0i2leg3nucn7p276nd8h', '43.245.120.232', '1695975579', '__ci_last_regenerate|i:1695975579;'), ('svas556gc53jceqgrg04ctfckd19pco0', '43.245.120.232', '1695975580', '__ci_last_regenerate|i:1695975580;'), ('gd01tgdvkhk7g8dn58al5hs69ioc5vm3', '43.245.120.232', '1695975581', '__ci_last_regenerate|i:1695975581;'), ('6i20lk9inc096c0pt95vb9bp7rpfh1cf', '43.245.120.232', '1695975581', '__ci_last_regenerate|i:1695975581;'), ('cv8p3nt6ifg7ptk2s7lhd3q5d3dp2jbi', '43.245.120.232', '1695975581', '__ci_last_regenerate|i:1695975581;'), ('6f826fa4fhshl2824plbck2vrpjeaqpn', '43.245.120.232', '1695975599', '__ci_last_regenerate|i:1695975599;'), ('cj88b0i50sgn4sc0sk6a95p94hn2uvsv', '43.245.120.232', '1695975602', '__ci_last_regenerate|i:1695975602;'), ('8npg99m06aesrn01v0po6889h713rura', '43.245.120.232', '1695975602', '__ci_last_regenerate|i:1695975602;'), ('al6tr8ldarqe2ur5levdt460nb2ettih', '43.245.120.232', '1695975602', '__ci_last_regenerate|i:1695975602;'), ('rd4n33o7bo25lif5gul4s30nn3l4ufu2', '43.245.120.232', '1695975602', '__ci_last_regenerate|i:1695975602;'), ('87alr0hqoojmne6ta9ogpuuna90e3uie', '43.245.120.232', '1695975603', '__ci_last_regenerate|i:1695975603;'), ('mhg0r3qq8l2fhlhhd2qnomiu3tceeb3c', '43.245.120.232', '1696008777', '__ci_last_regenerate|i:1695975604;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1696019084;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('jhsvl3tp0qde6bbp12sirugavcqrjskn', '43.245.120.232', '1695975605', '__ci_last_regenerate|i:1695975605;'), ('fk8a5nponnsc9un4ed9d27hcfrd4ings', '43.245.120.232', '1695975605', '__ci_last_regenerate|i:1695975605;'), ('901g6qe73t8mjkcli89f34rqevmrp7sv', '43.245.120.232', '1695975605', '__ci_last_regenerate|i:1695975605;'), ('cctlm9ck22nc1o5sa0udjjgt7akk7ols', '43.245.120.232', '1695975605', '__ci_last_regenerate|i:1695975605;'), ('lms0afs4l6q7dv839blbqmmorosakcgm', '43.245.120.232', '1695975613', '__ci_last_regenerate|i:1695975613;'), ('d19csguoo61j1qhp0g58uv4hsgab7v8q', '43.245.120.232', '1695975616', '__ci_last_regenerate|i:1695975616;'), ('c546c2ia3qg0pjgj4p2mvlds5f6ulph8', '43.245.120.232', '1695975616', '__ci_last_regenerate|i:1695975616;'), ('med1334i53fnb9qoriitqvatfrppt7rp', '43.245.120.232', '1695975616', '__ci_last_regenerate|i:1695975616;'), ('cvlkddirmpc2s6ka0ie4hcgalokbdgrt', '43.245.120.232', '1695975616', '__ci_last_regenerate|i:1695975616;'), ('tu7tdqfigf1lkn95nn3k64gt1km62fs5', '43.245.120.232', '1695975616', '__ci_last_regenerate|i:1695975616;'), ('ot8c5n309a581mponlv1562rmkjcib2f', '43.245.120.232', '1695975616', '__ci_last_regenerate|i:1695975616;'), ('9cm9tuibd2o0u3l4kbst6tbb6avr4ipg', '43.245.120.232', '1695975617', '__ci_last_regenerate|i:1695975617;'), ('tnv9jchrvcpb9sft266hpdfmui4l26bs', '43.245.120.232', '1695975618', '__ci_last_regenerate|i:1695975618;'), ('gvurp5onkmq2qt8rnq36qqb5kij8qv32', '43.245.120.232', '1695975618', '__ci_last_regenerate|i:1695975618;'), ('d7oef8bhq8fgfg34md83fejnhjnq8hf2', '43.245.120.232', '1695975618', '__ci_last_regenerate|i:1695975618;'), ('oh8sbmu16nbk14t786lo80tkbiemg6tf', '43.245.120.232', '1695975620', '__ci_last_regenerate|i:1695975620;'), ('t3eh1st59nu7208qrqavjvcvldsnujn5', '43.245.120.232', '1695975843', '__ci_last_regenerate|i:1695975843;'), ('pqhj03ag9jbq8ab0cbu9ehssq3vl28lv', '43.245.120.232', '1695975846', '__ci_last_regenerate|i:1695975846;'), ('286chc042ft3d9cge8ivfb35vnund97u', '43.245.120.232', '1695975846', '__ci_last_regenerate|i:1695975846;'), ('bbur6o3ll3gqfiojkfniu94rhln8ci7j', '43.245.120.232', '1695975846', '__ci_last_regenerate|i:1695975846;'), ('q8on5rp3br7lfmssf4poa2043rv329v3', '43.245.120.232', '1695975846', '__ci_last_regenerate|i:1695975846;'), ('r2fs0e1asfnrvoji8s41jmvliiggcebi', '43.245.120.232', '1695975846', '__ci_last_regenerate|i:1695975846;'), ('iq5n1f4rp2vtdr9961rr27r8b7jgfqtv', '43.245.120.232', '1695975846', '__ci_last_regenerate|i:1695975846;'), ('rfmt70ne9o236nmjg29cdrrkrqanvo24', '43.245.120.232', '1695975847', '__ci_last_regenerate|i:1695975847;'), ('9ns1r25u2df56ho8ndghunr7l91i2i9s', '43.245.120.232', '1695975857', '__ci_last_regenerate|i:1695975857;'), ('65tcqfujqcvlumbh9n1p2bjq3f2ip2st', '43.245.120.232', '1695975857', '__ci_last_regenerate|i:1695975857;'), ('ggide11197g72s2nmcqnrnfkib9cn563', '43.245.120.232', '1695975857', '__ci_last_regenerate|i:1695975857;'), ('mvobf6tbej2i0cu59g5j00p1uobasku4', '43.245.120.232', '1695975857', '__ci_last_regenerate|i:1695975857;'), ('38qqjrv19nkmgtrgmg341ba4te1vdif9', '43.245.120.232', '1695975863', '__ci_last_regenerate|i:1695975863;'), ('98ncn99u8v3rflupjftmm90jnvelhoa4', '43.245.120.232', '1695975863', '__ci_last_regenerate|i:1695975863;'), ('hm6khconhhq2vt4debvi105hsg00frrt', '43.245.120.232', '1695975863', '__ci_last_regenerate|i:1695975863;'), ('2re2ec1gboj9htbma0hhr5bbooqbk4j7', '43.245.120.232', '1695975863', '__ci_last_regenerate|i:1695975863;'), ('0fsclt0ho6fefbuq99n5ahrif32aphv6', '43.245.120.232', '1695975863', '__ci_last_regenerate|i:1695975863;'), ('igpde192c22btg18891g7m56qr5k1ko1', '43.245.120.232', '1695975863', '__ci_last_regenerate|i:1695975863;'), ('qi961fi67f33uu7l84043gei3hk9tu6m', '43.245.120.232', '1695975878', '__ci_last_regenerate|i:1695975878;'), ('5ghl7p8kc0co2cjg4amqaoufmpf5lqij', '43.245.120.232', '1695975879', '__ci_last_regenerate|i:1695975879;'), ('oj4261a4ldb9a7uusk43ufp2g9q5pmld', '43.245.120.232', '1695975879', '__ci_last_regenerate|i:1695975879;'), ('k01karn1kdq87160uf3lpo7obbntcmlb', '43.245.120.232', '1695975879', '__ci_last_regenerate|i:1695975879;'), ('874tsnqc7no3kk1dbe7j482o4blkg3gs', '43.245.120.232', '1695975879', '__ci_last_regenerate|i:1695975879;'), ('iq3r9relfei50sksi8est13gr2t8tjdh', '43.245.120.232', '1695975879', '__ci_last_regenerate|i:1695975879;'), ('oabp3qief01lh8o76pt59fqons3ng9p3', '43.245.120.232', '1695975879', '__ci_last_regenerate|i:1695975879;'), ('ultbtj2e2dsf65fp8ui6uoigv86hrro3', '43.245.120.232', '1695975879', '__ci_last_regenerate|i:1695975879;'), ('a0pha2ka0fbf56u3qioulbd2efkd78qb', '43.245.120.232', '1695975881', '__ci_last_regenerate|i:1695975881;'), ('3n2glfcn3lr7ah8er46c75lugje5cu2q', '43.245.120.232', '1695975881', '__ci_last_regenerate|i:1695975881;'), ('07t5m92kf0t27vjv6b42ht9aka9m1d72', '43.245.120.232', '1695975881', '__ci_last_regenerate|i:1695975881;'), ('201rcki6ji2fs7rifc584ilt9ppoi535', '43.245.120.232', '1695975881', '__ci_last_regenerate|i:1695975881;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('cln99q69u8jo1utp1bt7a9r7cam4nn20', '43.245.120.232', '1695975884', '__ci_last_regenerate|i:1695975884;'), ('ng72s6khh1af578d60s6aj1dmara836o', '43.245.120.232', '1695976499', '__ci_last_regenerate|i:1695976499;'), ('kopqi99tf4oq5874inlptr4qcrarto88', '43.245.120.232', '1695976503', '__ci_last_regenerate|i:1695976503;'), ('inb96sinsihqh55c5n9j985ih3egah7m', '43.245.120.232', '1695976503', '__ci_last_regenerate|i:1695976503;'), ('1naim4je31a2rc6mh6ai36mggtcsrvd6', '43.245.120.232', '1695976503', '__ci_last_regenerate|i:1695976503;'), ('8bdiijr6j6e44rvmhi48gonqj0j931e6', '43.245.120.232', '1695976503', '__ci_last_regenerate|i:1695976503;'), ('5hmli5eo76svv5ucujdhdi4srdh39pug', '43.245.120.232', '1695976503', '__ci_last_regenerate|i:1695976503;'), ('k283m7j4hfmvrl2uj1ajtu89vnrg7rlp', '43.245.120.232', '1695976503', '__ci_last_regenerate|i:1695976503;'), ('hf1lq0hm279u9pg22lons02fnccfrtgl', '43.245.120.232', '1695976504', '__ci_last_regenerate|i:1695976504;'), ('0n7inkde5jhpv0qtl4ru8dpg00uj8gtg', '43.245.120.232', '1695976508', '__ci_last_regenerate|i:1695976508;'), ('6mng957u1a2qrsu8317l25u1bgv3i135', '43.245.120.232', '1695976509', '__ci_last_regenerate|i:1695976509;'), ('cuncbm7orkqlrsfthq27e36264fcim8j', '43.245.120.232', '1695976510', '__ci_last_regenerate|i:1695976510;'), ('cjbqic174l21khkjoiu04m0kns2uoqhc', '43.245.120.232', '1695976510', '__ci_last_regenerate|i:1695976510;'), ('sem034r8ag61ogmqkqp9n8sic978hso7', '43.245.120.232', '1695976510', '__ci_last_regenerate|i:1695976510;'), ('1s7jhc29132v20qh77strrb0ckqbjcvu', '43.245.120.232', '1695976510', '__ci_last_regenerate|i:1695976510;'), ('n0ufss3332u8luhpfjccvhcejnarj070', '43.245.120.232', '1695976510', '__ci_last_regenerate|i:1695976510;'), ('nkjm0qecpt21audgegirgjdvu6nf9qou', '43.245.120.232', '1695976510', '__ci_last_regenerate|i:1695976510;'), ('tf8f2d8h8pn2r8ksdm3uvsu6a42pfueh', '43.245.120.232', '1695976511', '__ci_last_regenerate|i:1695976511;'), ('5e3f21j78l1ith6nt7ias8hcj113ei47', '43.245.120.232', '1695976512', '__ci_last_regenerate|i:1695976512;'), ('cnbebqh5f708jq5nla9r4f65ajnjqf3j', '43.245.120.232', '1695976512', '__ci_last_regenerate|i:1695976512;'), ('9vacddamu8c4k33ifio0tkgev19qbna6', '43.245.120.232', '1695976512', '__ci_last_regenerate|i:1695976512;'), ('krg93mj11077ippqmnm76imihkv5lcri', '43.245.120.232', '1695976512', '__ci_last_regenerate|i:1695976512;'), ('7mrteuqr3dhs9p5cp84fbucs70ccso7u', '43.245.120.232', '1695976512', '__ci_last_regenerate|i:1695976512;'), ('ahqhmn47498andtfkbham90bpqbrcaui', '43.245.120.232', '1695976512', '__ci_last_regenerate|i:1695976512;'), ('tscfo3n7esia44oc7uais1m0s2c89mhr', '43.245.120.232', '1695976512', '__ci_last_regenerate|i:1695976512;'), ('qu4qlbavqv6iuc0dg9qsejop2a0194at', '37.111.222.33', '1695976753', '__ci_last_regenerate|i:1695976753;'), ('fe581d8oi5r3u8ged5j1decqohjhcank', '37.111.222.33', '1695976753', '__ci_last_regenerate|i:1695976753;'), ('g49tckbkg64jvlm7n7cnfbmt1uvc8640', '37.111.222.33', '1695976810', '__ci_last_regenerate|i:1695976810;'), ('8c9klor7gmqa7u8akiokkq5453mnpm05', '37.111.222.33', '1695976860', '__ci_last_regenerate|i:1695976860;'), ('a2h1v7secvoihio6aa6gtg2kmqt3ep8t', '37.111.222.33', '1695976878', '__ci_last_regenerate|i:1695976878;'), ('fgm4l845ntg4ts0ddt2c87dj1qrch05f', '37.111.222.33', '1695976909', '__ci_last_regenerate|i:1695976909;'), ('af2fqd610jssdthslh148sil8iqknd65', '37.111.222.33', '1695976912', '__ci_last_regenerate|i:1695976912;'), ('846480ca0d7d4blv2qn5b2s9l36174gu', '37.111.222.33', '1695976912', '__ci_last_regenerate|i:1695976912;'), ('khdcha5iehr5qlk82rqbn1du10e9jg6j', '37.111.222.33', '1695976912', '__ci_last_regenerate|i:1695976912;'), ('eclfh5hpuv7pcrf5d9dcce7lc3jr4r1r', '37.111.222.33', '1695976912', '__ci_last_regenerate|i:1695976912;'), ('umhevkpr4h8k0j6atk0cbqkkme2iqubu', '37.111.222.33', '1695976912', '__ci_last_regenerate|i:1695976912;'), ('g29psvjaq85qdopmr2j3im69to1dtpom', '37.111.222.33', '1695976912', '__ci_last_regenerate|i:1695976912;'), ('u9h7r8k6j3k7hb09p7njjdoadb6nun4b', '37.111.222.33', '1695976913', '__ci_last_regenerate|i:1695976913;'), ('b6g747u1q4q7k9d0ppp3i227mgcnp36r', '37.111.222.33', '1695976917', '__ci_last_regenerate|i:1695976917;'), ('qpifnkdi7mea5dg6d7lq9adqovu9trvb', '37.111.222.33', '1695976917', '__ci_last_regenerate|i:1695976917;'), ('6et1gbvanvem8dl05264t34k18eov5ql', '37.111.222.33', '1695976918', '__ci_last_regenerate|i:1695976918;'), ('bofcj2eiuhk2upjohmp1hjjr18qj4pm5', '37.111.222.33', '1695976918', '__ci_last_regenerate|i:1695976918;'), ('ki616bbm4mgkni9dqcafnv4pvanblfc3', '37.111.222.33', '1695976918', '__ci_last_regenerate|i:1695976918;'), ('90vqbm1g2pc6li2r8obrmejkvtcc48dl', '37.111.222.33', '1695976918', '__ci_last_regenerate|i:1695976918;'), ('7o6arqn0841lv13khilqrtbtp657bkps', '37.111.222.33', '1695976918', '__ci_last_regenerate|i:1695976918;'), ('tv6on656nn8c4kdq0gner6aea7tjho9k', '37.111.222.33', '1695976918', '__ci_last_regenerate|i:1695976918;'), ('8phaso7kfb7vdmc1d68rkss66h4q5p2b', '37.111.222.33', '1695976953', '__ci_last_regenerate|i:1695976953;'), ('be1i31evurb0qr1qo25be5g0rdd65ura', '37.111.222.33', '1695976959', '__ci_last_regenerate|i:1695976959;'), ('9k4buc4dadnbqt3or9ke1pj97mi9j6om', '37.111.222.33', '1695976959', '__ci_last_regenerate|i:1695976959;'), ('sc5c30860sdo6vsdjc2pbvdi6brrbk26', '37.111.222.33', '1695976959', '__ci_last_regenerate|i:1695976959;'), ('nousfejeqeb5j2dfus268q219luv5qjh', '37.111.222.33', '1695976959', '__ci_last_regenerate|i:1695976959;'), ('cbke6jr76qilsncfc2or2k9n46pig32f', '37.111.222.33', '1695976959', '__ci_last_regenerate|i:1695976959;'), ('0dns03cpr1mvruugurdbon58gd0mjt8o', '37.111.222.33', '1695976960', '__ci_last_regenerate|i:1695976960;'), ('bdoh57onvouj6799i5prpppmbjpoqm0f', '37.111.222.33', '1695976961', '__ci_last_regenerate|i:1695976961;'), ('049ttn41s0irfrmcs41b91fb01cdqv3c', '37.111.222.33', '1695976962', '__ci_last_regenerate|i:1695976962;'), ('9cieoueod7khkb7j4a6n4ok29cmu7rms', '37.111.222.33', '1695976963', '__ci_last_regenerate|i:1695976963;'), ('5h98ngso5nqv7gv9tg2l8eg1ia38b1lh', '37.111.222.33', '1695976963', '__ci_last_regenerate|i:1695976963;'), ('lifbn159fj55aqbleugpsi25vd359424', '37.111.222.33', '1695976963', '__ci_last_regenerate|i:1695976963;'), ('hsosfmgf515l7clsequ2799j5dfk3b4u', '37.111.222.33', '1695976963', '__ci_last_regenerate|i:1695976963;'), ('asuqj4bgrhg1jj3e0b4re1ibiqvbi1m3', '37.111.222.33', '1695976963', '__ci_last_regenerate|i:1695976963;'), ('f3u5l1om3lv2n3df313s84k89gnk2j3p', '37.111.222.33', '1695976963', '__ci_last_regenerate|i:1695976963;'), ('1noi1cbpvg7rlvu9kpmdsphn0u6rb2vn', '37.111.222.33', '1695976964', '__ci_last_regenerate|i:1695976964;'), ('5jqcjmv8qi4jvdi77bc345ab1es2qj34', '37.111.222.33', '1695976964', '__ci_last_regenerate|i:1695976964;'), ('v3j19qde8gag7f6md3e6na61hgums5ql', '37.111.222.33', '1695976964', '__ci_last_regenerate|i:1695976964;'), ('nhrdhpb5rmr0ctf1877hs1mso6e8bob1', '37.111.222.33', '1695976964', '__ci_last_regenerate|i:1695976964;'), ('8d2jtpo3fnu3a1smpkk5m5tu7vtk2q16', '37.111.222.33', '1695976964', '__ci_last_regenerate|i:1695976964;'), ('8ll4l6ir3rj1tjnfg4hqh543598lddtf', '37.111.222.33', '1695976964', '__ci_last_regenerate|i:1695976964;'), ('ivff6vlf5cqn2gcht8h58sfpe7kik11o', '37.111.222.33', '1695976967', '__ci_last_regenerate|i:1695976967;'), ('km9jgfgr9f2r1j6u67uo8m3l5fqjku87', '37.111.222.33', '1695976967', '__ci_last_regenerate|i:1695976967;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('88eannb7rf0dgko849sdvp1amtuad1tf', '37.111.222.33', '1695976967', '__ci_last_regenerate|i:1695976967;'), ('u1rmpseo56p4e240s2m2ckv12ip4up9i', '37.111.222.33', '1695976985', '__ci_last_regenerate|i:1695976985;'), ('s3fe9hkp6j9rd71l2qbesopn9e33v5sh', '37.111.222.33', '1695976985', '__ci_last_regenerate|i:1695976985;'), ('j3c016t3fsb6b29fish2g2m1hgrdaihi', '103.67.158.55', '1695990709', '__ci_last_regenerate|i:1695990709;'), ('qd6vec1etl8op2pk1nl059dkf93bccaa', '103.67.158.55', '1695990712', '__ci_last_regenerate|i:1695990712;'), ('mu3k2fu3sk94r3p8453ag1at70satr4v', '103.67.158.55', '1695990712', '__ci_last_regenerate|i:1695990712;'), ('17v3me9qm1t0nlqh1clc2jliv0kb4hu5', '103.67.158.55', '1695990712', '__ci_last_regenerate|i:1695990712;'), ('nvd3gu2g51s06jeka3gf1s8qj4g33o77', '103.67.158.55', '1695990712', '__ci_last_regenerate|i:1695990712;'), ('q8a8rgaku09ne28uk34f2qilomo41guj', '103.67.158.55', '1695990712', '__ci_last_regenerate|i:1695990712;'), ('u4ava6v2tsvun81vkb5etf0fudmapshn', '103.67.158.55', '1695990712', '__ci_last_regenerate|i:1695990712;'), ('fer4569bt18hsc3k2l7d7ukm4rdceo4c', '103.67.158.55', '1695990712', '__ci_last_regenerate|i:1695990712;'), ('i5s78p1bbn5afhl364hhdgd4dtnt1282', '103.67.158.55', '1695990715', '__ci_last_regenerate|i:1695990715;'), ('oeeulrlv96v2v0rrr61173fc20ccgova', '103.67.158.55', '1695990715', '__ci_last_regenerate|i:1695990715;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('hm6anmf2mp88kr7fbo3l1dr38vpge1s3', '103.67.158.55', '1695990716', '__ci_last_regenerate|i:1695990716;'), ('k5sem8d16268d13oa5koqqpgb7umql6c', '103.67.158.55', '1695990784', '__ci_last_regenerate|i:1695990784;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('rji2cp1mgrnajqq8lnbe13hgoei25pls', '103.67.158.55', '1695990785', '__ci_last_regenerate|i:1695990785;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('fpfm2sppall10f7m49uq7asvfqoo7kbn', '66.220.149.16', '1695990847', '__ci_last_regenerate|i:1695990846;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('c7dro3ssdp88853n21u90nsr4i3ijvb0', '103.67.158.55', '1695990890', '__ci_last_regenerate|i:1695990890;'), ('nj3s9eilaglhiv5231192t22ttqqa6pe', '103.67.158.55', '1695990890', '__ci_last_regenerate|i:1695990890;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('4sc4623841685aanva6k29huoflp9ich', '103.67.158.55', '1695990891', '__ci_last_regenerate|i:1695990891;'), ('n0k17s4lqms1sfrsg42f182ci80epvlv', '116.58.200.32', '1696003683', '__ci_last_regenerate|i:1696003683;'), ('7nph8v3lhfhtsnh562fn11mblisnhmc1', '116.58.200.32', '1696003686', '__ci_last_regenerate|i:1696003686;'), ('4ab21g6r7ri8eirmltfmgrnpag8qid3j', '116.58.200.32', '1696003686', '__ci_last_regenerate|i:1696003686;'), ('h6d04ltk47lll39jbncjb6i66p5d96u3', '116.58.200.32', '1696003686', '__ci_last_regenerate|i:1696003686;'), ('8gn9dhm0qnmor0der8fvar0alh3qtq63', '116.58.200.32', '1696003686', '__ci_last_regenerate|i:1696003686;'), ('3hh6r4kn6vfjd7qmgk3kvpi8v7dlo6m2', '116.58.200.32', '1696003686', '__ci_last_regenerate|i:1696003686;'), ('u57mm8a9nojkvrojh0ld9s8he1uvhfrh', '116.58.200.32', '1696003686', '__ci_last_regenerate|i:1696003686;'), ('bdef3s6q7uj6b0b7fo6gfesakjgh6ta1', '116.58.200.32', '1696003686', '__ci_last_regenerate|i:1696003686;'), ('bpe6gqcuq1b8t6d46bmt1cbb8vabao53', '116.58.200.32', '1696003785', '__ci_last_regenerate|i:1696003785;'), ('onqe0tfecd8pi37m2ltul555vqcka4eh', '116.58.200.32', '1696003788', '__ci_last_regenerate|i:1696003788;'), ('ge5imgsifoljoumhob4tu86g4fog92nv', '116.58.200.32', '1696003788', '__ci_last_regenerate|i:1696003788;'), ('k8rvhs2a2chm6s5rm4lpkr0gfbg78vos', '116.58.200.32', '1696003788', '__ci_last_regenerate|i:1696003788;'), ('enuf21vg2gtdac8qjj9rom0kcvivsj11', '116.58.200.32', '1696003788', '__ci_last_regenerate|i:1696003788;'), ('37g8hrg9vvhmmkijqqjkfttv38p5v0aq', '116.58.200.32', '1696003788', '__ci_last_regenerate|i:1696003788;'), ('a11qg0p4jnt9belfip0490f6gsa8d76o', '116.58.200.32', '1696003788', '__ci_last_regenerate|i:1696003788;'), ('tlg289ma5kf9jbpc928vvfrpooh9g1p3', '116.58.200.32', '1696003789', '__ci_last_regenerate|i:1696003789;'), ('4r8vc0620vah0brq0d5ffita5riv0qs4', '116.58.200.32', '1696003792', '__ci_last_regenerate|i:1696003792;'), ('d6kutfet9kahrntnboi97mlnl02ieb9g', '116.58.200.32', '1696004569', '__ci_last_regenerate|i:1696004569;'), ('qm0bs7h9oug05bi3cahtiftqok968m9p', '116.58.200.32', '1696004576', '__ci_last_regenerate|i:1696004576;'), ('mtgsamreurcrsq0ai5ce0djdt54fda9i', '116.58.200.32', '1696004922', '__ci_last_regenerate|i:1696004922;'), ('al9hp14npcr8hpk8t58q3gjskaks2gd6', '116.58.200.32', '1696004925', '__ci_last_regenerate|i:1696004925;'), ('e3jbjp7a5d8v3ch111ncjgg5mdeg093q', '116.58.200.32', '1696004925', '__ci_last_regenerate|i:1696004925;'), ('bsmhnqckprd61c575j088gfdcr545up3', '116.58.200.32', '1696004925', '__ci_last_regenerate|i:1696004925;'), ('q8ii7ujm8qql673dfb9fj6v3gdpmnfs9', '116.58.200.32', '1696004925', '__ci_last_regenerate|i:1696004925;'), ('he9e0ap4omk4p63ooknrn3hte4nf3crs', '116.58.200.32', '1696004925', '__ci_last_regenerate|i:1696004925;'), ('s508hepguavkvqeungq39tvev371gplq', '116.58.200.32', '1696004925', '__ci_last_regenerate|i:1696004925;'), ('umbfiurttm5fkm56bseeksroer201e6p', '116.58.200.32', '1696004926', '__ci_last_regenerate|i:1696004926;'), ('ngtf2it2qsm686si557jio17r7kardag', '116.58.200.32', '1696004996', '__ci_last_regenerate|i:1696004996;'), ('9brir2sg26eld46qg45l5rl4pg8lf481', '116.58.200.32', '1696004996', '__ci_last_regenerate|i:1696004996;'), ('aemikohrg0loj08bj1u5f0apgotk5ail', '116.58.200.32', '1696004997', '__ci_last_regenerate|i:1696004997;'), ('04j8u658sj7hvjhg5uh76sboebkuj12f', '116.58.200.32', '1696004997', '__ci_last_regenerate|i:1696004997;'), ('41fdtauroljrdenhke3q0lsn7t9msrco', '116.58.200.32', '1696004997', '__ci_last_regenerate|i:1696004997;'), ('25nug73h580vbn71b1uca3hda254nfvv', '116.58.200.32', '1696004997', '__ci_last_regenerate|i:1696004997;'), ('m37nsgbqqo3416bn8ld7mdat2ko9t8ds', '116.58.200.32', '1696004997', '__ci_last_regenerate|i:1696004997;'), ('fh7vfkij5j4i0s8pahsregavb85t42b1', '116.58.200.32', '1696004997', '__ci_last_regenerate|i:1696004997;'), ('shsgui09fi1qlg5m02j1lt29ld8stp67', '116.58.200.32', '1696004998', '__ci_last_regenerate|i:1696004998;'), ('fok7vm1qoihkd25j9iggea3orvkrtlc4', '116.58.200.32', '1696004999', '__ci_last_regenerate|i:1696004999;'), ('93v37iuu3ms05prn22tqcitmf8kthpjm', '116.58.200.32', '1696004999', '__ci_last_regenerate|i:1696004999;'), ('n002ri7e79dcqk48iovdpgmdntf52u9q', '116.58.200.32', '1696004999', '__ci_last_regenerate|i:1696004999;'), ('9m5v5p8pb40hmekgl5pjagki9mvqeaf2', '116.58.200.32', '1696004999', '__ci_last_regenerate|i:1696004999;'), ('gehm8tfadh7q6u8qu27517a2ur44kq9d', '116.58.200.32', '1696004999', '__ci_last_regenerate|i:1696004999;'), ('d6bcnv1gom2ot06839r8l1q846kah7mq', '116.58.200.32', '1696004999', '__ci_last_regenerate|i:1696004999;'), ('u0ipgibjncbslfgu5ittkdlt0clkh6ns', '116.58.200.32', '1696004999', '__ci_last_regenerate|i:1696004999;'), ('lfs1cbuecv73ppheo8a5u1qk5cbs4f9k', '116.58.200.32', '1696005000', '__ci_last_regenerate|i:1696005000;'), ('3n1t2iq7l4t44ovsalek77a32gr19gra', '116.58.200.32', '1696005001', '__ci_last_regenerate|i:1696005001;'), ('f4akbh8tekociea1es2ikl0c6vmdrni5', '116.58.200.32', '1696005001', '__ci_last_regenerate|i:1696005001;'), ('51kvmov0a84e4lmcf10u6q9bjdagm54r', '116.58.200.32', '1696005001', '__ci_last_regenerate|i:1696005001;'), ('iuk9828ln0bagjv2mnuhv49g4tgt1l3m', '116.58.200.32', '1696005001', '__ci_last_regenerate|i:1696005001;'), ('lda2me2mt0hp84856qb7ujo8le6gmavt', '116.58.200.32', '1696005001', '__ci_last_regenerate|i:1696005001;'), ('kr5ont4s9gl3pm9p6hhpv2852nnvc8pj', '116.58.200.32', '1696005001', '__ci_last_regenerate|i:1696005001;'), ('buj1bhaa2krbnv381gq484dpgj8r2jqo', '116.58.200.32', '1696005001', '__ci_last_regenerate|i:1696005001;'), ('nro7q100in27uo3bfcc5imuvc244ftqn', '116.58.200.32', '1696005081', '__ci_last_regenerate|i:1696005081;'), ('rbk3f2da46dcb5iciotmp8596kmrpifb', '116.58.200.32', '1696005085', '__ci_last_regenerate|i:1696005085;'), ('vqilptlj7mnmp01sl8q8pi6culgo45gm', '116.58.200.32', '1696005086', '__ci_last_regenerate|i:1696005086;'), ('ccbhiucbq6mpvbd9r3ejjk2qi613agh2', '116.58.200.32', '1696005086', '__ci_last_regenerate|i:1696005086;'), ('v08qlqlprvchp3ic8pgstbgvbu5h7chm', '116.58.200.32', '1696005086', '__ci_last_regenerate|i:1696005086;'), ('gtlmvti3f56ausbrski509kdtc7e4kht', '116.58.200.32', '1696005086', '__ci_last_regenerate|i:1696005086;'), ('b633q3imabu0n6mofjr7ic36bm15k3dh', '116.58.200.32', '1696005086', '__ci_last_regenerate|i:1696005086;'), ('1q0r3imqh3f4ng9q2kcr9cg2fb122h2b', '116.58.200.32', '1696005086', '__ci_last_regenerate|i:1696005086;'), ('6ibnu6fbe2s4pqcehc7ciub5dnagcfco', '116.58.200.32', '1696005086', '__ci_last_regenerate|i:1696005086;'), ('5rlj7srj56v2lghfmb8redfgv7bdpmic', '116.58.200.32', '1696005092', '__ci_last_regenerate|i:1696005092;'), ('o2q6r223lkknm76dh7vnvlf6kh13l1u0', '116.58.200.32', '1696005093', '__ci_last_regenerate|i:1696005093;'), ('qcj96cs52gep9q2ch29qjf2hojd0v82h', '116.58.200.32', '1696005093', '__ci_last_regenerate|i:1696005093;'), ('vp0f0mfac38v1mkkomcf0uokq0h52l49', '116.58.200.32', '1696005093', '__ci_last_regenerate|i:1696005093;'), ('o4agcqkrsn4mlsc117osj0vd710gjpns', '116.58.200.32', '1696005093', '__ci_last_regenerate|i:1696005093;'), ('928483sr7d6hliokvi9inapng8d0q8e5', '116.58.200.32', '1696005093', '__ci_last_regenerate|i:1696005093;'), ('hb6b88mqn8vhmptbv9umdd6dot0hhjnu', '116.58.200.32', '1696005093', '__ci_last_regenerate|i:1696005093;'), ('nb1ikh1ppfl9hl29fg88c3o8pmvgiiqc', '116.58.200.32', '1696005093', '__ci_last_regenerate|i:1696005093;'), ('kdr0mrhh8a09npgf9sdgqvpdp97dq070', '116.58.200.32', '1696005195', '__ci_last_regenerate|i:1696005195;'), ('d61pv95vd7139d6vn2sa28nqmrh9o0lm', '116.58.200.32', '1696005196', '__ci_last_regenerate|i:1696005196;'), ('v7o7pkrui18p3mkjvnuvj9vqdar459ln', '116.58.200.32', '1696005510', '__ci_last_regenerate|i:1696005510;'), ('pum883tle067j9dgccod8c5m6e505sjr', '116.58.200.32', '1696005510', '__ci_last_regenerate|i:1696005510;'), ('9dtn14m7um8f9g0atecp94v71gobdqeu', '116.58.200.32', '1696005627', '__ci_last_regenerate|i:1696005627;'), ('3akeeraabd0gafddm4cugi4365qrivaa', '116.58.200.32', '1696006132', '__ci_last_regenerate|i:1696006132;'), ('4s5oadd11akrq4k0tist3johgc5r58ia', '116.58.200.32', '1696006500', '__ci_last_regenerate|i:1696006500;'), ('97lg8clls1ni39b14guekadsalhqh5op', '116.58.200.32', '1696006500', '__ci_last_regenerate|i:1696006500;'), ('cp3mhnkp04tltujbo4re3rc4m6gja4ac', '116.58.200.32', '1696006501', '__ci_last_regenerate|i:1696006501;'), ('db14j5qm305vo6dsafg76uom4cgebvvl', '116.58.200.32', '1696006501', '__ci_last_regenerate|i:1696006501;'), ('s750k4e4dip9inuas6klcr339ankham1', '116.58.200.32', '1696006501', '__ci_last_regenerate|i:1696006501;'), ('3nq41b28338eclu7qikucbsq3pm871a5', '116.58.200.32', '1696006501', '__ci_last_regenerate|i:1696006501;'), ('gt8aj91crfji13glne32duva1jt3qp0j', '116.58.200.32', '1696006501', '__ci_last_regenerate|i:1696006501;'), ('66m4rsp8vcre8l6p2a0d17ephmcdgjne', '116.58.200.32', '1696006501', '__ci_last_regenerate|i:1696006501;'), ('cgpvmrm1nv1paneih8i6jicoili42f6l', '116.58.200.32', '1696008398', '__ci_last_regenerate|i:1696008398;'), ('23ip472hb7n5pquru1b0ijl8dtiaqsp5', '116.58.200.32', '1696008399', '__ci_last_regenerate|i:1696008399;'), ('7ptof7epk19fkjc3vprfidl2bd7cjakd', '116.58.200.32', '1696008399', '__ci_last_regenerate|i:1696008399;'), ('s72jc6finktula1i7aepj5nha0ho42im', '116.58.200.32', '1696008400', '__ci_last_regenerate|i:1696008400;'), ('uq8n92e3evokoihgohsohoj9l4h3lnb6', '116.58.200.32', '1696008400', '__ci_last_regenerate|i:1696008400;'), ('hk9ggbkohc6nlcqg669djsa04gisab25', '116.58.200.32', '1696008400', '__ci_last_regenerate|i:1696008400;'), ('k5mrurrk137a86oa8f6ovslp1p0fee03', '116.58.200.32', '1696008400', '__ci_last_regenerate|i:1696008400;'), ('5ktlttdim5somh5abtbgd7fi77qd0eou', '116.58.200.32', '1696008400', '__ci_last_regenerate|i:1696008400;'), ('39t0af6mh7clgv4s1n60js30euqn8ehs', '116.58.200.32', '1696008400', '__ci_last_regenerate|i:1696008400;'), ('bsq10o85jdl3i3kljavh249s7o2m0q49', '116.58.200.32', '1696008453', '__ci_last_regenerate|i:1696008453;'), ('mjsei1f2ji4ihu4rfb8uu6skorrahf84', '116.58.200.32', '1696008454', '__ci_last_regenerate|i:1696008454;'), ('gou35pibl238bkdugc1h6n02rb887jmq', '116.58.200.32', '1696008454', '__ci_last_regenerate|i:1696008454;'), ('oubn6a9m9l4cur7g0f144b9ms2kbgs0d', '116.58.200.32', '1696008454', '__ci_last_regenerate|i:1696008454;'), ('d15voqnbmt5i8kiq0j9joqaoiuo8k7mc', '116.58.200.32', '1696008454', '__ci_last_regenerate|i:1696008454;'), ('ku089pdkr2e66gb9slk3pqk12t65e9cq', '116.58.200.32', '1696008455', '__ci_last_regenerate|i:1696008455;'), ('fobjkd34a8l5je4djgkots0869np5d6u', '116.58.200.32', '1696008455', '__ci_last_regenerate|i:1696008455;'), ('6b5v60mrs0eq3hoa413jicd5fb2c87p6', '116.58.200.32', '1696008455', '__ci_last_regenerate|i:1696008455;'), ('r0mq3h3m071me3ir4mioid85atruv40h', '116.58.200.32', '1696008455', '__ci_last_regenerate|i:1696008455;'), ('lqdrk24lhjojn37ub710naf0jfivh3bj', '116.58.200.32', '1696008627', '__ci_last_regenerate|i:1696008627;'), ('jlkjnv1afb1q2rjb19e1o116narsv28r', '116.58.200.32', '1696008627', '__ci_last_regenerate|i:1696008627;'), ('2j977rv0s0sbjhtta7rc4050vnpi3v66', '116.58.200.32', '1696008628', '__ci_last_regenerate|i:1696008628;'), ('0434cikul6qeffdn386thq45goosc4ej', '116.58.200.32', '1696008628', '__ci_last_regenerate|i:1696008628;'), ('q4sekrki2aop042ensspf9v5327e37ln', '116.58.200.32', '1696008628', '__ci_last_regenerate|i:1696008628;'), ('7alofkgrnr58j7on4oq9vt0ngfu42e6a', '116.58.200.32', '1696008628', '__ci_last_regenerate|i:1696008628;'), ('5hfbphjkiectvp9qrlt8v2m5l9b3f7nj', '116.58.200.32', '1696008628', '__ci_last_regenerate|i:1696008628;'), ('f5sm25nklrop1bnq8seclgigi6jmqn0d', '116.58.200.32', '1696008628', '__ci_last_regenerate|i:1696008628;'), ('gm3l2ej6e22gp2mailoo3brf7tqq6b5r', '37.111.223.178', '1696008775', '__ci_last_regenerate|i:1696008775;'), ('n2kpb40um9f1sagahulvp8kql44afg2s', '37.111.223.178', '1696008775', '__ci_last_regenerate|i:1696008775;'), ('bkqgvq6c3orflj8tltla3591ecushjr7', '37.111.223.178', '1696008776', '__ci_last_regenerate|i:1696008776;'), ('r8dh1niu4lptvohpivgua5nu29d1s79g', '37.111.223.178', '1696008776', '__ci_last_regenerate|i:1696008776;'), ('uqnsedhsspgbmh9nfkggb736su1d2p78', '37.111.223.178', '1696008776', '__ci_last_regenerate|i:1696008776;'), ('p9khlm8evv6acac8ul22gr0ovmsr2on4', '37.111.223.178', '1696008776', '__ci_last_regenerate|i:1696008776;'), ('277behkqcfbsb353abl1ca7e7kht7qtj', '37.111.223.178', '1696008776', '__ci_last_regenerate|i:1696008776;'), ('hqg46h98hmdp8d1gnqgii4c5598c5457', '37.111.223.178', '1696008776', '__ci_last_regenerate|i:1696008776;'), ('sc1oqd08d706eb57v8bm2n2q14lncv86', '37.111.223.175', '1696008796', '__ci_last_regenerate|i:1696008796;'), ('2935h85pl0nspnc69jvt1icvhgaba6ke', '37.111.223.175', '1696008799', '__ci_last_regenerate|i:1696008799;'), ('j0h8ahrm6oh508t0hcjrhlci7dq9ll3o', '37.111.223.175', '1696008799', '__ci_last_regenerate|i:1696008799;'), ('ac1ik1j0sqpcr78a4i9l4abfrk6abe1e', '37.111.223.175', '1696008799', '__ci_last_regenerate|i:1696008799;'), ('v1shivifv8666sn003q8h9i1d4dstsg2', '37.111.223.175', '1696008799', '__ci_last_regenerate|i:1696008799;'), ('2pmbilfk4h6rtg72e1g4t7l1gouvporf', '37.111.223.175', '1696008799', '__ci_last_regenerate|i:1696008799;'), ('8nbe9eqtl7hd6pb8kd4h8fpq2dvff49h', '37.111.223.175', '1696008799', '__ci_last_regenerate|i:1696008799;'), ('oie33rub4v1f1cenq58qe04lj99ikm3t', '37.111.223.175', '1696008800', '__ci_last_regenerate|i:1696008800;'), ('hkal44qno3549ucj7cduc5ps7echhr7n', '37.111.223.175', '1696008826', '__ci_last_regenerate|i:1696008826;'), ('me7su45ha64g25mibt7s9np51p0ghhcg', '37.111.223.175', '1696008827', '__ci_last_regenerate|i:1696008827;'), ('ufa3gutqa9ko6d48bekit1of34rf3p8n', '37.111.223.175', '1696008827', '__ci_last_regenerate|i:1696008827;'), ('ridj8sdjiih0gto7i5e73v4a8q124no3', '37.111.223.175', '1696008827', '__ci_last_regenerate|i:1696008827;'), ('hlu3fkkss7ann2nkn104ue1mtat7mlpm', '37.111.223.175', '1696008827', '__ci_last_regenerate|i:1696008827;'), ('ce0289in6ug0cmcs1tog76co5omjsc33', '37.111.223.175', '1696008827', '__ci_last_regenerate|i:1696008827;'), ('dh01ku9s3t8ufvlp92u5m43r7v4pomuf', '37.111.223.175', '1696008827', '__ci_last_regenerate|i:1696008827;'), ('78kuclt2e0bkih3vs316d36umvbah7jo', '37.111.223.175', '1696008828', '__ci_last_regenerate|i:1696008828;'), ('id2ciq8u2lj7m7bebglbc4k2ul1v4p53', '37.111.223.175', '1696127682', '__ci_last_regenerate|i:1696008829;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1696052039;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('qf24rhflc1tl2412ckr1ctelg2h2f6b9', '37.111.223.175', '1696008836', '__ci_last_regenerate|i:1696008836;'), ('0bs5vlfhovkt2omiiqojthklr54ldiq9', '37.111.223.175', '1696008836', '__ci_last_regenerate|i:1696008836;'), ('mrobaee9gvsl508m2816l0er764r645d', '37.111.223.175', '1696008837', '__ci_last_regenerate|i:1696008837;'), ('64j63c7hsf2lhll1p6vr89t3jprn86hp', '37.111.223.175', '1696008837', '__ci_last_regenerate|i:1696008837;'), ('94f21lo2pmqsrtk64ff6aipjvotnv2f9', '37.111.223.175', '1696008837', '__ci_last_regenerate|i:1696008837;'), ('f0m1a6ehqocfl1oqclk2074f9jc6bm50', '37.111.223.175', '1696008837', '__ci_last_regenerate|i:1696008837;'), ('v2gr0qijohjkc2tdslodothu6r02qv51', '37.111.223.175', '1696008837', '__ci_last_regenerate|i:1696008837;'), ('7p10d0hbtq64ck6e0kqc76l2ds5inr9i', '37.111.223.175', '1696008837', '__ci_last_regenerate|i:1696008837;'), ('hripu4itq4vn3c2kqs0s2dhagvqlg4o5', '37.111.223.175', '1696008837', '__ci_last_regenerate|i:1696008837;'), ('jdq1i2rni7256chndjhbudk6lqfr2h7s', '37.111.223.175', '1696008837', '__ci_last_regenerate|i:1696008837;'), ('6s31818c4058scs9ot0626n6ii8ecket', '37.111.223.175', '1696008837', '__ci_last_regenerate|i:1696008837;'), ('5ceb4lkf22u9okpq87fkav2fjg5060rq', '37.111.223.175', '1696008837', '__ci_last_regenerate|i:1696008837;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('26qb1m4s5pt60gjql9vk35t2nu4kddf5', '37.111.223.175', '1696008839', '__ci_last_regenerate|i:1696008839;'), ('k1ko3dvdl6m4dosdh5ahd9s8ecfn0edo', '103.16.25.111', '1696013734', '__ci_last_regenerate|i:1696013734;'), ('tohg4agrraop1r6uv2e3pdune70oig2t', '103.16.25.111', '1696013777', '__ci_last_regenerate|i:1696013777;'), ('mrra14l3ms03einn62uhpk3oacceo5vh', '103.16.25.111', '1696013778', '__ci_last_regenerate|i:1696013778;'), ('7noq4jj81jlemhbmrkueaoqcg8egfeq6', '103.16.25.111', '1696013778', '__ci_last_regenerate|i:1696013778;'), ('afarsvd9mudlcjsumrb79dujbdciam2q', '103.16.25.111', '1696013778', '__ci_last_regenerate|i:1696013778;'), ('t8i8fl9ojkdndvqmie4k0fgva41egds8', '103.16.25.111', '1696013778', '__ci_last_regenerate|i:1696013778;'), ('3a8m1rrg134gtnj5a5jt8khnchhf4o4j', '103.16.25.111', '1696013778', '__ci_last_regenerate|i:1696013777;'), ('8f44f5tseaiu84nsn4hgvlq0qlbgitri', '103.16.25.111', '1696013778', '__ci_last_regenerate|i:1696013778;'), ('scfmp0f0uqa1ldlskbk7sgsht8b4t4ou', '103.16.25.111', '1696013796', '__ci_last_regenerate|i:1696013796;'), ('ocjktoc9o5tf9afrquhdmmla06lds530', '103.16.25.111', '1696013796', '__ci_last_regenerate|i:1696013796;'), ('7mmi8fg123p762vmv4kh8jcni1ghsbou', '103.16.25.111', '1696013796', '__ci_last_regenerate|i:1696013796;'), ('9d8f6meqapkqhrg33vmdqcq6qhm0kp1k', '103.16.25.111', '1696013796', '__ci_last_regenerate|i:1696013796;'), ('tssqcmvqj4r082mr3fo3c50tuqov278i', '103.16.25.111', '1696013796', '__ci_last_regenerate|i:1696013796;'), ('ve7f5upmru7m44u7k60kknfb04226i4d', '103.16.25.111', '1696013796', '__ci_last_regenerate|i:1696013796;'), ('8uhopbosvd4ld27qnmugr74k7ohf9pp2', '103.16.25.111', '1696013799', '__ci_last_regenerate|i:1696013799;'), ('dj3rerqsif6ng1f111mli4d3pqfl0nvl', '103.16.25.111', '1696013799', '__ci_last_regenerate|i:1696013799;'), ('tc720113un7ok9tj82o0kis5q96io1jj', '103.16.25.111', '1696013799', '__ci_last_regenerate|i:1696013799;'), ('0cac6q8kfou4gm0v3mk4oe7bfu41gg60', '103.16.25.111', '1696013800', '__ci_last_regenerate|i:1696013800;'), ('vl85l7igsejn0qj287dtakdr47k5u1ip', '103.16.25.111', '1696013800', '__ci_last_regenerate|i:1696013800;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('0uks8c53e5ok34mrfgk4de7nb0ivj6bs', '103.16.25.111', '1696013801', '__ci_last_regenerate|i:1696013801;'), ('mqg90d188ipnpndrup1gdrb1uc97eou5', '103.16.25.111', '1696014575', '__ci_last_regenerate|i:1696014575;'), ('mqdvm2uvahc3bqbmbhdptvud3r1nl9rb', '103.16.25.111', '1696014587', '__ci_last_regenerate|i:1696014587;'), ('s0mpffj9bf67nmdaujjoo4mgj50fa4em', '103.16.25.111', '1696014587', '__ci_last_regenerate|i:1696014587;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('h7k8jsdk2p30v7hbevgb0880ua42lnlq', '103.16.25.111', '1696014587', '__ci_last_regenerate|i:1696014587;'), ('7p84grl78ufmrpdn696icqcpkcjrf59u', '103.16.25.111', '1696014589', '__ci_last_regenerate|i:1696014589;'), ('ber0qri3ghl38h82bmp9ei9kcns4v3s4', '103.16.25.111', '1696014589', '__ci_last_regenerate|i:1696014589;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('svhskgr4qff7di8ov7fkg60ljd2fis7s', '103.16.25.111', '1696014589', '__ci_last_regenerate|i:1696014589;'), ('dp40vrenukc1f4n9injjervodsaqd220', '103.16.25.111', '1696014590', '__ci_last_regenerate|i:1696014590;'), ('5esm7cf6mc7qqq79jqbpvropqmofkol4', '103.16.25.111', '1696014590', '__ci_last_regenerate|i:1696014590;'), ('d2raljrq3cr1h98bstobkc38lpaccme2', '103.16.25.111', '1696014591', '__ci_last_regenerate|i:1696014591;'), ('3njm65jphbrl4as5h0j7civ341pl33lk', '103.16.25.111', '1696014592', '__ci_last_regenerate|i:1696014592;'), ('kvpeo4e90vn0pmhhf73v0016tp0561lb', '103.16.25.111', '1696014592', '__ci_last_regenerate|i:1696014592;'), ('lcc53lt4fq4006u1kfa3tho2njt0b4ne', '103.16.25.111', '1696014592', '__ci_last_regenerate|i:1696014592;'), ('djf2favefv9ebon72lntsh83vb22c1fb', '103.16.25.111', '1696014595', '__ci_last_regenerate|i:1696014595;'), ('c0m0pmstlluvb9kgrrorj8r2pidjrfaq', '103.16.25.111', '1696014595', '__ci_last_regenerate|i:1696014595;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('hsqv2fru0s5u6ns58torkbbdq2ebga2h', '103.16.25.111', '1696014596', '__ci_last_regenerate|i:1696014596;'), ('qdpcpkqb75nrc895ftdi5dmc8955l309', '103.16.25.111', '1696015571', '__ci_last_regenerate|i:1696015571;'), ('tqttq26kupfcurs0ti80vfo4ukjl1btq', '103.16.25.111', '1696015574', '__ci_last_regenerate|i:1696015574;'), ('d77ivj1svh24q680j64slpluikt06u6h', '103.16.25.111', '1696015574', '__ci_last_regenerate|i:1696015574;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('6dbhjs3r80gttjkngld32tgsn2li3lgq', '103.16.25.111', '1696015575', '__ci_last_regenerate|i:1696015575;'), ('tadjodqm6u1dg18675i4fmpfq70f6r2i', '103.16.25.111', '1696015585', '__ci_last_regenerate|i:1696015585;'), ('59t7dfejabdmrabm0pljtm4f0u1ga0dr', '103.16.25.111', '1696015585', '__ci_last_regenerate|i:1696015585;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('7jg9g0oa1ira09m24na6sgiu02d2923u', '103.16.25.111', '1696015586', '__ci_last_regenerate|i:1696015586;'), ('ev1pfbcq22q6o2toprt0fjno7u860gia', '103.16.25.111', '1696016041', '__ci_last_regenerate|i:1696016041;'), ('hv5lngou2md5dds3ce4fevodk71h4o2g', '103.16.25.111', '1696016045', '__ci_last_regenerate|i:1696016045;'), ('1nol41a7t1apmukbkpdh4fjhdt02v8ol', '103.16.25.111', '1696016045', '__ci_last_regenerate|i:1696016045;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('l3h5pf39pkupufonk2dut3hisam1tb1c', '103.16.25.111', '1696016045', '__ci_last_regenerate|i:1696016045;'), ('qb6jmt74g9oggu23p1fkm1qida9e1e1q', '103.16.25.111', '1696018497', '__ci_last_regenerate|i:1696018497;'), ('127afprq6m7tjfc3hd314d9ntq36v0ns', '103.16.25.111', '1696018500', '__ci_last_regenerate|i:1696018500;'), ('7ur8t884bangtu2bmi86cq17t5ooot95', '103.16.25.111', '1696018501', '__ci_last_regenerate|i:1696018501;'), ('fmfjo9n797np1m7jrt19tb9pf3rcgh9f', '103.16.25.111', '1696018501', '__ci_last_regenerate|i:1696018501;'), ('mbpkiblrpsksfpq693ldntneq2aj3vsa', '103.16.25.111', '1696018501', '__ci_last_regenerate|i:1696018501;'), ('mgbq7hvno2516s0bvmrrtef73pqlhnh4', '103.16.25.111', '1696018501', '__ci_last_regenerate|i:1696018501;'), ('bkdtsph7uf6k1jt5soe1iiapoann9lnb', '103.16.25.111', '1696018501', '__ci_last_regenerate|i:1696018501;'), ('m4f0b8m21h9mkrjlo8456unnn9jrl4mf', '103.16.25.111', '1696018501', '__ci_last_regenerate|i:1696018501;'), ('437kpcr0b50qjoc9epkfr0nmk7hbgbtk', '103.16.25.111', '1696018507', '__ci_last_regenerate|i:1696018507;'), ('mbpi8l8ptr0t845o2j3b851pbllttu28', '103.16.25.111', '1696018507', '__ci_last_regenerate|i:1696018507;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('q8gud7fkntkhk1e80r0te31mo1u6o9t6', '103.16.25.111', '1696018507', '__ci_last_regenerate|i:1696018507;'), ('36vcrt4lvqll37vmbdrjrq4uigkce68o', '103.16.25.111', '1696018510', '__ci_last_regenerate|i:1696018510;'), ('gg0rnc5a28s61jpu8n5cj7osivug273n', '103.16.25.111', '1696018510', '__ci_last_regenerate|i:1696018510;'), ('2cmsl98iqu24llnkffqk2sbjpaqe6j60', '103.16.25.111', '1696018510', '__ci_last_regenerate|i:1696018510;'), ('3jp8psc9meba3hgsjn8galp7bgva2r3d', '103.16.25.111', '1696018511', '__ci_last_regenerate|i:1696018511;'), ('tob25lrjlv9ckvm1873d0mg60qfntuea', '103.16.25.111', '1696018511', '__ci_last_regenerate|i:1696018511;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('9iss7a85ki5m1avs91hkomuqa6te5e8f', '103.16.25.111', '1696018511', '__ci_last_regenerate|i:1696018511;'), ('bint4t93d0atkcdr061r4sh46uengg1b', '103.16.25.111', '1696018512', '__ci_last_regenerate|i:1696018512;'), ('v24iabvsute1quopjplq1km5ru6lk5oi', '103.16.25.111', '1696018512', '__ci_last_regenerate|i:1696018512;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('7qbrmo1bseplkkqdt8dhbn83nc466k9b', '103.16.25.111', '1696018513', '__ci_last_regenerate|i:1696018513;'), ('tms1fu0dbiqnd3k0thp4smjvk1l9k9k0', '103.16.25.111', '1696018515', '__ci_last_regenerate|i:1696018515;'), ('n4jvsmvnq02ct17ckgq2ue1vscm57lmc', '103.16.25.111', '1696018515', '__ci_last_regenerate|i:1696018515;'), ('qievusslcm1i8ilsq487m5ildrbd0ci8', '103.16.25.111', '1696018516', '__ci_last_regenerate|i:1696018516;'), ('5512n3vqtej2mv24656uimhmqh0j8jsv', '103.16.25.111', '1696018516', '__ci_last_regenerate|i:1696018516;'), ('0p7jgts1jijej8iiqn9qbncmg6ro6c0p', '103.16.25.111', '1696018517', '__ci_last_regenerate|i:1696018517;'), ('4p5almj2np3i7uet95qkrmdmto13lb8n', '103.16.25.111', '1696018517', '__ci_last_regenerate|i:1696018517;'), ('gpv3ucjmhb62fkpo7kapig9e0rfdeg6v', '103.16.25.111', '1696018517', '__ci_last_regenerate|i:1696018517;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('l9l7250dje1h34b87r5lfgcf7lk4ec2n', '103.16.25.111', '1696018518', '__ci_last_regenerate|i:1696018518;'), ('6amlc6m1ukackctduqdb5nbnjpgin6b9', '103.16.25.111', '1696018523', '__ci_last_regenerate|i:1696018523;'), ('jg9v2iaskdaap6v0u2tdhbhqv1jcgio7', '103.16.25.111', '1696018523', '__ci_last_regenerate|i:1696018523;'), ('k2dmi81kj0urhgqk29af35oqf1nmv7m4', '103.16.25.111', '1696018526', '__ci_last_regenerate|i:1696018526;'), ('goclfgssfpeelv3m9mrk47odumk88jl9', '103.16.25.111', '1696018526', '__ci_last_regenerate|i:1696018526;'), ('5tdmmg47dtvjemcep6v8potrjqo4ql1k', '103.16.25.111', '1696018526', '__ci_last_regenerate|i:1696018526;'), ('ucjaa9n56i2cb74f7aift5rkoaol7ju2', '103.16.25.111', '1696018526', '__ci_last_regenerate|i:1696018526;'), ('o7i3t3mgmoil30b5pqe8vvqd0bgjcq76', '103.16.25.111', '1696018526', '__ci_last_regenerate|i:1696018526;'), ('t76jjr6q85gd5u66v0o245fhu3dfhmrb', '103.16.25.111', '1696018526', '__ci_last_regenerate|i:1696018526;'), ('bvatdqbb27n5l3p1bq2gt062763rclrj', '103.16.25.111', '1696020422', '__ci_last_regenerate|i:1696020422;'), ('3lndq7t76ho2cquv8bvm9m52o6q45fvg', '103.16.25.111', '1696020441', '__ci_last_regenerate|i:1696020441;'), ('o66e7omion3etmj69cr83rt6hbrsf0sj', '103.16.25.111', '1696020441', '__ci_last_regenerate|i:1696020441;'), ('nq5io42df3usm0kag5u762o1ka2bn3lq', '103.16.25.111', '1696020441', '__ci_last_regenerate|i:1696020441;'), ('cln2r2t70t6c5tl8q7b74m7faplnvd01', '103.16.25.111', '1696020441', '__ci_last_regenerate|i:1696020441;'), ('9g72lln2p2g51t2qserf2abofpib80dp', '103.16.25.111', '1696020441', '__ci_last_regenerate|i:1696020441;'), ('vlmrdcp06grgq1rert3mec8eh0lklgjp', '103.16.25.111', '1696020441', '__ci_last_regenerate|i:1696020441;'), ('3jbhpjicqdsbvjjtha01c8s6ln9lv9ui', '103.16.25.111', '1696020442', '__ci_last_regenerate|i:1696020442;'), ('s7jjjjomacoqp7qcpqkmhbvlq9rd5jk7', '103.16.25.111', '1696020463', '__ci_last_regenerate|i:1696020463;'), ('c8eq3lg1acpt25gs2mdtencpbqopvj50', '103.16.25.111', '1696020463', '__ci_last_regenerate|i:1696020463;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('sr7iekg7vb12l3pancu7ibdoqqab0793', '103.16.25.111', '1696020464', '__ci_last_regenerate|i:1696020464;'), ('dntgl6ng0oc9il8tffic6ip2apcs7ov1', '103.16.25.111', '1696020763', '__ci_last_regenerate|i:1696020763;'), ('uu3nhrk6b29pfpjp8giccbic5cv91p7k', '103.16.25.111', '1696020767', '__ci_last_regenerate|i:1696020767;'), ('eu94277eclen9ceebron62vldi09rjj1', '103.16.25.111', '1696020767', '__ci_last_regenerate|i:1696020767;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('lqtqfi2du125v3aldeqpsn7mg0ildmbn', '103.16.25.111', '1696020768', '__ci_last_regenerate|i:1696020768;'), ('fgqcflcdoe6hhoruekf5hotk9ro6ucti', '103.67.156.44', '1696127638', '__ci_last_regenerate|i:1696127638;'), ('396i81nojg93c6mqv0flp4p1m2ihgf8n', '103.67.156.44', '1696127641', '__ci_last_regenerate|i:1696127641;'), ('2of3le8ich4t80ks4t2g0pcvv3i7so6t', '103.67.156.44', '1696127641', '__ci_last_regenerate|i:1696127641;'), ('g6gop918s5tqddvvut4b4lf08465fktf', '103.67.156.44', '1696127641', '__ci_last_regenerate|i:1696127641;'), ('6ogq9d6gmvq2n536hla1d122h3jf30dk', '103.67.156.44', '1696127641', '__ci_last_regenerate|i:1696127641;'), ('skhng00gi8455898qfa8v5e795gbgigc', '103.67.156.44', '1696127641', '__ci_last_regenerate|i:1696127641;'), ('j2t1c8v31u09b2fj2fg97o3e4d3l6pb2', '103.67.156.44', '1696127641', '__ci_last_regenerate|i:1696127641;'), ('qsn8qqrq48dth7t18i9g8jt2fs24ieqg', '103.67.156.44', '1696127642', '__ci_last_regenerate|i:1696127642;'), ('r1aqbu1k3qq482rfgrjgl7ipiudck90h', '103.67.156.44', '1696127663', '__ci_last_regenerate|i:1696127663;'), ('lgcf2pvcfnj6p2v98ec4ceu17teq45as', '103.67.156.44', '1696127664', '__ci_last_regenerate|i:1696127664;'), ('ikjvh0cgb9egffih61nb3jsgsb32jo3s', '103.67.156.44', '1696127665', '__ci_last_regenerate|i:1696127665;'), ('ca5ug0jaoejeka59fpnggi1609s9eo77', '103.67.156.44', '1696127665', '__ci_last_regenerate|i:1696127665;'), ('lgqcmpsvassabkvt6h7qoje5vqkufpdf', '103.67.156.44', '1696127665', '__ci_last_regenerate|i:1696127665;'), ('a13pm2e4vk23pbf5m4co9bdqkq4lqvvi', '103.67.156.44', '1696127665', '__ci_last_regenerate|i:1696127665;'), ('ba8pfalllrodk44g6ner06dsnin7giue', '103.67.156.44', '1696127665', '__ci_last_regenerate|i:1696127665;'), ('7862hbrig97t205foi7h6b4a1skebcl6', '103.67.156.44', '1696127665', '__ci_last_regenerate|i:1696127665;'), ('ms5c87298t2v85ejo683bkm4hl8jacsn', '103.67.156.44', '1696127669', '__ci_last_regenerate|i:1696127669;'), ('4e4q3f01pqds42lrlb6lebd27jlkmuc0', '103.67.156.44', '1696127669', '__ci_last_regenerate|i:1696127669;'), ('o8rbrnlr44s1omth53u3nc470fu50bqd', '103.67.156.44', '1696127669', '__ci_last_regenerate|i:1696127669;'), ('otfdpka4cr5m8063r8qb3ibv918gtlck', '103.67.156.44', '1696127669', '__ci_last_regenerate|i:1696127669;'), ('qs521aftrnl52i3jv07gle8pn7mi2aun', '103.67.156.44', '1696127669', '__ci_last_regenerate|i:1696127669;'), ('8q9v1lpslapu3ka7k5oo4r7tf918453n', '103.67.156.44', '1696127669', '__ci_last_regenerate|i:1696127669;'), ('usrm47crhlef8jmu1k1t708ornl2ajkm', '103.67.156.44', '1696127671', '__ci_last_regenerate|i:1696127671;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('8fsaekntoon02fjrakjpmhn4il3dcsge', '103.67.156.44', '1696127671', '__ci_last_regenerate|i:1696127671;'), ('0t0940mon08vaq9e12n3otr8n14b214v', '103.67.156.44', '1696127671', '__ci_last_regenerate|i:1696127671;'), ('ll31i95je142fq433uk1m8ac70iek64s', '103.67.156.44', '1696127684', '__ci_last_regenerate|i:1696127684;'), ('bst9r13p1l0ca2ni466v7kvis3udgq2e', '103.67.156.44', '1696127684', '__ci_last_regenerate|i:1696127684;'), ('fr6jpapvkkecc2khavdk9q2jo7bdb1f8', '103.67.156.44', '1696127684', '__ci_last_regenerate|i:1696127684;'), ('j4n70t5o9rap368a7kcf27c4l5javg8v', '103.67.156.44', '1696127684', '__ci_last_regenerate|i:1696127684;'), ('l7m7m566jjebl9tjl9evuitafg7p5aqk', '103.67.156.44', '1696127684', '__ci_last_regenerate|i:1696127684;'), ('qps94qqrli3bkbk68or6t0dk1495m5au', '103.67.156.44', '1696127684', '__ci_last_regenerate|i:1696127684;'), ('3v6cfgv65ee0f3u0cqbm2cqrmj7slkmo', '103.67.156.35', '1696168138', '__ci_last_regenerate|i:1696168138;'), ('rvju948pngi9uks2l9fcsif0i3hs2lhh', '103.67.156.35', '1696168141', '__ci_last_regenerate|i:1696168141;'), ('kk0g2gdn1rkoquqc1cmodq7u298fu5ff', '103.67.156.35', '1696168141', '__ci_last_regenerate|i:1696168141;'), ('5v5q9u148sb6v7lnudmg16js7gpgh299', '103.67.156.35', '1696168141', '__ci_last_regenerate|i:1696168141;'), ('ng5v288534gmjcjfqkfm437fn20avhvn', '103.67.156.35', '1696168141', '__ci_last_regenerate|i:1696168141;'), ('pvec8qdlqln89lc5eli8cdfid50mjo51', '103.67.156.35', '1696168141', '__ci_last_regenerate|i:1696168141;'), ('dnbomhbqu5lgg8gm80cdb49sfgvqj922', '103.67.156.35', '1696168141', '__ci_last_regenerate|i:1696168141;'), ('k71qr2chbj9c4k6tm2bvn81sp19ab9tg', '103.67.156.35', '1696168142', '__ci_last_regenerate|i:1696168142;'), ('3rnnsk9lptfe5sgghkkqub5er3a2tjjp', '103.67.156.35', '1696168149', '__ci_last_regenerate|i:1696168149;'), ('v992jp2223llgkhsqjf3ngmgmkd3vbov', '103.67.156.35', '1696168149', '__ci_last_regenerate|i:1696168149;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('kjttr36kqt2kcd8okgiodi3cp9ia1dbb', '103.67.156.35', '1696168149', '__ci_last_regenerate|i:1696168149;'), ('a48s7eanem7c4uv4mmk3fbji9kf8isji', '103.67.156.35', '1696168155', '__ci_last_regenerate|i:1696168155;'), ('dmih5p9243an9c1rikjj636sh7ttpd94', '103.67.156.35', '1696168155', '__ci_last_regenerate|i:1696168155;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('rfugmij9c6gspdoanr71aa4eeakahunn', '103.67.156.35', '1696168156', '__ci_last_regenerate|i:1696168156;'), ('3ogb6tj1uk9t0k1t57mrld68e3p0hhio', '103.67.156.35', '1696168174', '__ci_last_regenerate|i:1696168174;'), ('ea86trpvti8k7or5i68urs25qpsrs2v9', '103.67.156.35', '1696168177', '__ci_last_regenerate|i:1696168177;'), ('3sionaci6uvi3jl2a65sr2n6ejgmn7gj', '103.67.156.35', '1696168177', '__ci_last_regenerate|i:1696168177;'), ('ks28ivq9qauqqcqujt190dq7h0q880vj', '103.67.156.35', '1696168177', '__ci_last_regenerate|i:1696168177;'), ('cao61p1j1s08ho5dms9pt109b9c8coih', '103.67.156.35', '1696168177', '__ci_last_regenerate|i:1696168177;'), ('8t971pi0ilmgt54a7qm04sipuod7mdbf', '103.67.156.35', '1696168177', '__ci_last_regenerate|i:1696168177;'), ('h1kqr7n4smamq11m6s8rcc330tgl07tn', '103.67.156.35', '1696168177', '__ci_last_regenerate|i:1696168177;'), ('u3ld7aq0p09cj5j26pk2hfquj82dcli3', '103.67.156.35', '1696168178', '__ci_last_regenerate|i:1696168178;'), ('k0m6u13fo71lv84r15e9987jk96t12hd', '103.67.156.35', '1696168180', '__ci_last_regenerate|i:1696168180;'), ('5vl6o6sv8eh5d3r8924gvhp7qbao01mt', '103.67.156.35', '1696168180', '__ci_last_regenerate|i:1696168180;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('3b4ht5mgm2dvsi6tch0vo0trq8der75c', '103.67.156.35', '1696168180', '__ci_last_regenerate|i:1696168180;'), ('3hgqrdemb7qru75ibaovgdfdq128432v', '103.67.156.35', '1696168202', '__ci_last_regenerate|i:1696168202;'), ('o7u69rodi436hr577q3svv5t3f46bl34', '103.67.156.35', '1696168203', '__ci_last_regenerate|i:1696168203;'), ('hfhk3oikbnsj5utevcl6n8iuanmdd35t', '103.67.156.35', '1696168203', '__ci_last_regenerate|i:1696168203;'), ('7hhu57407comelb3rmps5h52ua5uf27o', '103.67.156.35', '1696168203', '__ci_last_regenerate|i:1696168203;'), ('ckevoq2rn5m1rkrpsklh2ct35l5e459v', '103.67.156.35', '1696168203', '__ci_last_regenerate|i:1696168203;'), ('c0hb6p35294uiifnvrs41d20cgb7nslk', '103.67.156.35', '1696168203', '__ci_last_regenerate|i:1696168203;'), ('opfi9sntfusrjrq58r38ps5tn9nunr9h', '103.67.156.35', '1696168203', '__ci_last_regenerate|i:1696168203;'), ('v51knef1u8cf2v820pd2vt9blmvv2dod', '103.67.156.35', '1696168204', '__ci_last_regenerate|i:1696168204;'), ('a37hp8qsk51gbmmghaesibb9htc6bnp4', '103.67.156.35', '1696168208', '__ci_last_regenerate|i:1696168208;'), ('k50vtbi38rhoe3d5klol3vajeju05p8a', '103.67.156.35', '1696168208', '__ci_last_regenerate|i:1696168208;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('bqdn1k4q4ubr89qf0j05s5niopq9vhh4', '103.67.156.35', '1696168208', '__ci_last_regenerate|i:1696168208;'), ('64aanoidrsc8va8qma2bc9f2oed726vt', '103.67.156.35', '1696168304', '__ci_last_regenerate|i:1696168304;'), ('iesteppeel9g4fio4cpu03a3qprkkru4', '103.67.156.35', '1696168304', '__ci_last_regenerate|i:1696168304;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('kofv14mp7u69ia18pf3hd693ph44r6m8', '103.67.156.35', '1696168305', '__ci_last_regenerate|i:1696168305;'), ('om5iqeb6qfnnms3m1g9h5rpfbioacuvp', '103.67.156.35', '1696168309', '__ci_last_regenerate|i:1696168309;'), ('i0pamh33lmeima2sp1falnpfqp979jub', '103.67.156.35', '1696168309', '__ci_last_regenerate|i:1696168309;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('fbnpkgoi10k4mtr29ts6qus50p3ugqjd', '103.67.156.35', '1696168309', '__ci_last_regenerate|i:1696168309;'), ('h95fk6erkemadfd5j1oj7dhqeh9hv1pm', '103.67.156.35', '1696168314', '__ci_last_regenerate|i:1696168314;'), ('9ktis7921p0o2pv7c4hnrnhhkmrcum3s', '103.67.156.35', '1696168315', '__ci_last_regenerate|i:1696168315;'), ('0ru25e6rlcpihlc2usp5m0gr8smnan88', '103.67.156.35', '1696168315', '__ci_last_regenerate|i:1696168315;'), ('6tov9buffgbsc8rouera68kph5tf1vmo', '103.67.156.35', '1696168315', '__ci_last_regenerate|i:1696168315;'), ('1gj4g2o9jdjqq5bp2cpbdbisv73s2j74', '103.67.156.35', '1696168315', '__ci_last_regenerate|i:1696168315;'), ('6rpl9dabghrha2q0qti4h3q3s7vhchph', '103.67.156.35', '1696168315', '__ci_last_regenerate|i:1696168315;'), ('f4kju2l4d6g0mfv45hec0tegpuk3j3id', '103.67.156.35', '1696168315', '__ci_last_regenerate|i:1696168315;'), ('rcbei7hg0hfp1v9d5kc7muft4t8m5d0u', '103.67.156.35', '1696168315', '__ci_last_regenerate|i:1696168315;'), ('i2oiusa5pop1etvs8lhsudu6sul6gnbp', '103.67.156.35', '1696168316', '__ci_last_regenerate|i:1696168316;'), ('v93210id5j8aohqd4ccaejf813inampf', '103.67.156.35', '1696168316', '__ci_last_regenerate|i:1696168316;'), ('ejs9tl2pmdfssabo1q9i92qev8a8ern9', '103.67.156.35', '1696168316', '__ci_last_regenerate|i:1696168316;'), ('5v75pfue021l88tah6sf2gkoo7s2f8mf', '103.67.156.35', '1696168316', '__ci_last_regenerate|i:1696168316;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('fg8d9hh10j35uvpjbo174g5mftehdrhb', '103.67.156.35', '1696168318', '__ci_last_regenerate|i:1696168318;'), ('2f0cqiu0d66cqe7u6irub3tvq4kn51ap', '103.67.156.35', '1696183199', '__ci_last_regenerate|i:1696168318;custom_session_limit|i:1696211518;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";cart_items|a:0:{}language|s:7:\"english\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('la1o388fs5vkr1tb3mn5cmr2ddpl5sqi', '103.67.156.35', '1696168324', '__ci_last_regenerate|i:1696168324;'), ('jkb8rmifhdiua76fuku6emeggdkoiuvk', '103.67.156.35', '1696168324', '__ci_last_regenerate|i:1696168324;'), ('jlef4jjss3bqfq5rie0711ldtqs2v94c', '103.67.156.35', '1696168324', '__ci_last_regenerate|i:1696168324;'), ('93u9d7dei57l8fgodfg1msur26mcp711', '103.67.156.35', '1696168324', '__ci_last_regenerate|i:1696168324;'), ('q1k4avtha31ce58ns6mcnrloq68k0d6s', '103.67.156.35', '1696168324', '__ci_last_regenerate|i:1696168324;'), ('vt9h6l15eue8f2dia1gha3eun3dnf3da', '103.67.156.35', '1696168325', '__ci_last_regenerate|i:1696168325;'), ('gh6hbs7588aclurnu94tsklkc83rs845', '103.67.156.35', '1696168326', '__ci_last_regenerate|i:1696168326;'), ('l1ehmf7ljep8q5vko9o1igf6uudcavlj', '103.67.156.35', '1696168326', '__ci_last_regenerate|i:1696168326;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('p7f4vvdr7fq9s5hpnqdtm6cj6f8rcho9', '103.67.156.35', '1696168326', '__ci_last_regenerate|i:1696168326;'), ('orglggq31podr37ikd658hp9g6d0i0nn', '103.67.156.35', '1696171868', '__ci_last_regenerate|i:1696171868;'), ('hqqnigblhteue50qhht8mom8es2eh729', '103.67.156.35', '1696171871', '__ci_last_regenerate|i:1696171871;'), ('p8tmu5nmn2jef57183injvllu94t8k6u', '103.67.156.35', '1696171871', '__ci_last_regenerate|i:1696171871;'), ('88ecnu5rvtm4mcl9fv8aerpmt722sn1u', '103.67.156.35', '1696171871', '__ci_last_regenerate|i:1696171871;'), ('0fbk34e7sbvfk23bljc5rlamqj3gnbmj', '103.67.156.35', '1696171871', '__ci_last_regenerate|i:1696171871;'), ('obqbh5stn8j3qhckp9rv828m3eunhbb7', '103.67.156.35', '1696171871', '__ci_last_regenerate|i:1696171871;'), ('bekhsct5qd8vlu52holsculvssjh43dn', '103.67.156.35', '1696171872', '__ci_last_regenerate|i:1696171872;'), ('75rd3fovmnr0avsj21md4nb8gm6f7nq2', '103.67.156.35', '1696171873', '__ci_last_regenerate|i:1696171873;'), ('n5foaa9vv4pmto92bca6nicqojdhlldv', '103.67.156.35', '1696171909', '__ci_last_regenerate|i:1696171909;'), ('ulubusgl9m1j7prniao3bma7ei7vq5s1', '103.67.156.35', '1696171909', '__ci_last_regenerate|i:1696171909;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('5s9v2i27e1sbqqshjad3e498ha9tvtgm', '103.67.156.35', '1696171910', '__ci_last_regenerate|i:1696171910;'), ('3cnonrldk54uquiciro91cl1sm0e2aot', '103.67.156.35', '1696171935', '__ci_last_regenerate|i:1696171935;'), ('t8n11gs8u62jj89b0esf0g1r304gngsk', '103.67.156.35', '1696171938', '__ci_last_regenerate|i:1696171938;'), ('alk6n3tsmgte9rahtg7c8n5rlmuktvoh', '103.67.156.35', '1696171938', '__ci_last_regenerate|i:1696171938;'), ('vin340mfntifu3t94280179muslpoeou', '103.67.156.35', '1696171938', '__ci_last_regenerate|i:1696171938;'), ('g8d9mcibn8psfdvoe6dej4t8kecn81f1', '103.67.156.35', '1696171938', '__ci_last_regenerate|i:1696171938;'), ('esnedkkkj08b9177mbho8a4v5m6n1f5f', '103.67.156.35', '1696171938', '__ci_last_regenerate|i:1696171938;'), ('8pcrfvd58dhkako23jb44mshon1qgm9u', '103.67.156.35', '1696171939', '__ci_last_regenerate|i:1696171939;'), ('oca43i1tb5k1p6ojer3ro9nfu26o65ok', '103.67.156.35', '1696171939', '__ci_last_regenerate|i:1696171939;'), ('3e4n7e5k0oo1toto37keleihc39v7avh', '103.67.156.35', '1696171999', '__ci_last_regenerate|i:1696171999;'), ('p9ul07n4fgudb6j5b7lbuigoc3d5kl6t', '103.67.156.35', '1696172000', '__ci_last_regenerate|i:1696172000;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('9d7lu9ilct49fhf71sm878v9arjh57h1', '103.67.156.35', '1696172000', '__ci_last_regenerate|i:1696172000;'), ('49v9kgjldqh4e46tv6utbvav126pvveh', '103.67.156.35', '1696172284', '__ci_last_regenerate|i:1696172284;'), ('t2jogsj1n9eloetg0enr3leu8b8krjre', '103.67.156.35', '1696172286', '__ci_last_regenerate|i:1696172286;'), ('dqnt7avaat2hkugak8gfbl5oretcgbpb', '103.67.156.35', '1696172287', '__ci_last_regenerate|i:1696172287;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('d6f2l4lkklauda3agh29iktb0b9ld3mb', '103.67.156.35', '1696172288', '__ci_last_regenerate|i:1696172288;'), ('d5j55qpea60qhg69jm4kb7d8cvoc9967', '103.67.156.35', '1696172291', '__ci_last_regenerate|i:1696172291;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('07vmnkt9kn0uh23tg7j2jjrc49md7dk1', '103.67.156.35', '1696172291', '__ci_last_regenerate|i:1696172291;'), ('ccge7rgsvn3lo2auqni9pr8oj8oopnsl', '103.67.156.35', '1696172292', '__ci_last_regenerate|i:1696172292;'), ('avberqgicjo5fuj1a6296oco24ooslki', '103.67.156.35', '1696172301', '__ci_last_regenerate|i:1696172301;'), ('n6fsb13dbbfp13ctf6geiop9pqqe6cqp', '103.67.156.35', '1696172304', '__ci_last_regenerate|i:1696172304;'), ('lkt1rjh075h9jcrmirngulssdbm41h39', '103.67.156.35', '1696172304', '__ci_last_regenerate|i:1696172304;'), ('ck1mi2jh6huvau2al2cb645681oq8js9', '103.67.156.35', '1696172304', '__ci_last_regenerate|i:1696172304;'), ('qqbv8uql5cvt5q0qmrj1kv77pm78ik3h', '103.67.156.35', '1696172304', '__ci_last_regenerate|i:1696172304;'), ('a2o30915mtfl5gje4s5bp1c957mmn06a', '103.67.156.35', '1696172304', '__ci_last_regenerate|i:1696172304;'), ('lh0ornvf1c9l5jdd86jn9sc1lt63eafo', '103.67.156.35', '1696172304', '__ci_last_regenerate|i:1696172304;'), ('q4vl1qqklvkbmian75tr23vqkhl0ee3i', '103.67.156.35', '1696172305', '__ci_last_regenerate|i:1696172305;'), ('869u97cphhkqb57fc0vlg5j5rqrh7ttk', '103.67.156.35', '1696172309', '__ci_last_regenerate|i:1696172309;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('kgtcrcf9rqkr5idrhj07q69cdi2ilv7a', '103.67.156.35', '1696172310', '__ci_last_regenerate|i:1696172310;'), ('c0vi3s4jokotnm2ptgjb5kch41q3jobn', '103.67.156.35', '1696172310', '__ci_last_regenerate|i:1696172310;'), ('rg9fdb56bfahhisku76lrg2ng0a5pmpt', '103.67.156.35', '1696172388', '__ci_last_regenerate|i:1696172388;'), ('cnnhn9gdpub0i6a76pqjaoatepjqtvm4', '103.67.156.35', '1696172392', '__ci_last_regenerate|i:1696172392;'), ('e3h308d6dfp6t2p8a2gpnnvnagpalbbp', '103.67.156.35', '1696172392', '__ci_last_regenerate|i:1696172392;'), ('m00ru81kv128o1rulmn52qcv5nuft8l9', '103.67.156.35', '1696172392', '__ci_last_regenerate|i:1696172392;'), ('ekdvcp6ciec0vi7l120k45emos4j8j9i', '103.67.156.35', '1696172392', '__ci_last_regenerate|i:1696172392;'), ('81gmu1qqhvkalef7l4trro8q281764lf', '103.67.156.35', '1696172392', '__ci_last_regenerate|i:1696172392;'), ('trobrscp72bf8gm600k0s8bnbgs0p23v', '103.67.156.35', '1696172392', '__ci_last_regenerate|i:1696172392;'), ('nij8pqnl4a042e3tea6nls2nur1oi8vi', '103.67.156.35', '1696172392', '__ci_last_regenerate|i:1696172392;'), ('ut2tfmlgptl4podfourncsbp7duq6amr', '103.67.156.35', '1696172424', '__ci_last_regenerate|i:1696172424;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('i1mevj25tae34iv3dd479so3f7ra2rsm', '103.67.156.35', '1696172424', '__ci_last_regenerate|i:1696172424;'), ('vljt2fgbhusd3di11bsem0on46k7bmvl', '103.67.156.35', '1696172425', '__ci_last_regenerate|i:1696172425;'), ('akemrnimms5po2vtvnifhcbjf4n1auil', '103.67.156.35', '1696172521', '__ci_last_regenerate|i:1696172521;'), ('gbt5gjcrlch1q7kp731ol4bghkndevrm', '103.67.156.35', '1696172525', '__ci_last_regenerate|i:1696172525;'), ('0sf7tgnf064netej871jkaghi720cmj5', '103.67.156.35', '1696172525', '__ci_last_regenerate|i:1696172525;'), ('gebn2qg5ft69dhnintf1gf18lqd9pimj', '103.67.156.35', '1696172525', '__ci_last_regenerate|i:1696172525;'), ('2a3oda1pg8ob1bbf780f9dc5bic2nfa5', '103.67.156.35', '1696172525', '__ci_last_regenerate|i:1696172525;'), ('apdr59tma519nes8he46hmtbqhblojq7', '103.67.156.35', '1696172525', '__ci_last_regenerate|i:1696172525;'), ('2eud72j2t4qpr2dtdesvmhac6he7rv82', '103.67.156.35', '1696172526', '__ci_last_regenerate|i:1696172526;'), ('60gv2ise4b0vb1a2uvqu63m8vpeu8534', '103.67.156.35', '1696172526', '__ci_last_regenerate|i:1696172526;'), ('ff9tamr3mqmaha5953gtfmolrlbcshee', '103.67.156.35', '1696172530', '__ci_last_regenerate|i:1696172530;'), ('ldb5rn73epj4a4r8cv1k78dn5gclcgm9', '103.67.156.35', '1696172531', '__ci_last_regenerate|i:1696172531;'), ('5becmq1u2rqdc3v7c2ess0q6p3h84l3l', '103.67.156.35', '1696172531', '__ci_last_regenerate|i:1696172531;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('kuilnu3lk15kgssrs3cof1hvr5of1gtn', '103.67.156.35', '1696172532', '__ci_last_regenerate|i:1696172532;'), ('f0oaut8njhfkfjthsdias0ssq5jqehlt', '103.67.156.35', '1696172707', '__ci_last_regenerate|i:1696172707;'), ('cdql5dq93b8np6bat1augq2p9fcrm65s', '103.67.156.35', '1696172712', '__ci_last_regenerate|i:1696172712;'), ('pvtatph1r2gpj4075cgpnpi7of1p8s1h', '103.67.156.35', '1696172715', '__ci_last_regenerate|i:1696172715;'), ('pdudft08nnh4bfult2hlos6hvvkn5nuv', '103.67.156.35', '1696172716', '__ci_last_regenerate|i:1696172716;'), ('4t0o2camvugi64tqp40vv16c5p44he7r', '103.67.156.35', '1696172716', '__ci_last_regenerate|i:1696172716;'), ('i0t1bbf3pfclv5q6o5fdurub3hd2hgtf', '103.67.156.35', '1696172716', '__ci_last_regenerate|i:1696172716;'), ('g2o03ss650gv40nat30kk10eqr2no3i5', '103.67.156.35', '1696172716', '__ci_last_regenerate|i:1696172716;'), ('8384relv6mk9j96v6l80bomavpb3t4u5', '103.67.156.35', '1696172716', '__ci_last_regenerate|i:1696172716;'), ('j3kmd995dnsnnvd2g1e1o3nqot7loj1v', '103.67.156.35', '1696172716', '__ci_last_regenerate|i:1696172716;'), ('earujbbpdf0pi2b4r7s7tu1cqdm34qrg', '103.67.156.35', '1696172721', '__ci_last_regenerate|i:1696172721;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('nuetb0mj2upe6o1htg06njgsnbe2t1r5', '103.67.156.35', '1696172721', '__ci_last_regenerate|i:1696172721;'), ('f6isk7ldl0ohr3cb6nc8bf2j7veuij0d', '103.67.156.35', '1696172722', '__ci_last_regenerate|i:1696172722;'), ('d3tvpqpqaidqb1dpu0cp3euq3tl6fnlh', '103.67.156.35', '1696172740', '__ci_last_regenerate|i:1696172740;'), ('040v87cd52groog06g3ob32akdnulvt7', '103.67.156.35', '1696172743', '__ci_last_regenerate|i:1696172743;'), ('f7q0dsesuf72o4h9k6lbs6hbeghml7em', '103.67.156.35', '1696172743', '__ci_last_regenerate|i:1696172743;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ho5el8jhi60gl7ou23trt48um8f666qh', '103.67.156.35', '1696172744', '__ci_last_regenerate|i:1696172744;'), ('6mj8oc60pbegbgt9rjv71ktqjhm04es9', '103.67.156.35', '1696172763', '__ci_last_regenerate|i:1696172763;'), ('fcsski2b3lbaaa0nkb4drhhudu76s1dl', '103.67.156.35', '1696172766', '__ci_last_regenerate|i:1696172766;'), ('lf6hqk01qhbffl2fof5hqm8vs3vd5lc1', '103.67.156.35', '1696172766', '__ci_last_regenerate|i:1696172766;'), ('bfj13l1fm2huv0nokma6i5v58qbuf6mi', '103.67.156.35', '1696172766', '__ci_last_regenerate|i:1696172766;'), ('ruaq1767886rvcsp0cec4ndvrvhdgml4', '103.67.156.35', '1696172766', '__ci_last_regenerate|i:1696172766;'), ('nbpvfamngn3j8nubsi04jithhr3tck3d', '103.67.156.35', '1696172766', '__ci_last_regenerate|i:1696172766;'), ('edcsjf4084bhkps8k45mcj1aaf45j7aa', '103.67.156.35', '1696172766', '__ci_last_regenerate|i:1696172766;'), ('4tlcr37r0o4hoqv6dj7egcajnqkm0bu7', '103.67.156.35', '1696172766', '__ci_last_regenerate|i:1696172766;'), ('pcpbf60lgiv9i8tlsmh6tespah8agfe7', '103.67.156.35', '1696172767', '__ci_last_regenerate|i:1696172767;'), ('gjb4tqc0s34mt89glf77lkgsf39i5lct', '103.67.156.35', '1696172767', '__ci_last_regenerate|i:1696172767;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('uep4vedou5l03f1gqcljg96vnb6ls03b', '103.67.156.35', '1696172768', '__ci_last_regenerate|i:1696172768;'), ('nt7tqut02uken4msatj7k6ukvu1a0gjj', '103.67.156.35', '1696172792', '__ci_last_regenerate|i:1696172792;'), ('f4atlnv4tgb3e6e7b6quegvro6a10252', '103.67.156.35', '1696172795', '__ci_last_regenerate|i:1696172795;'), ('hm2lcia657mo0e6k5oml78cct4fc9gj9', '103.67.156.35', '1696172796', '__ci_last_regenerate|i:1696172795;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('tqiao0rkq9nmvofrhsb7koem90t529r7', '103.67.156.35', '1696172796', '__ci_last_regenerate|i:1696172796;'), ('js46rc77599rbckrau6e507b5g55qk6t', '103.67.156.35', '1696172822', '__ci_last_regenerate|i:1696172822;'), ('h324jq8as4gbun0ncgg6unjacvvrtih1', '103.67.156.35', '1696172825', '__ci_last_regenerate|i:1696172825;'), ('7etk659lo7ghfmcubkttrtdg2508653g', '103.67.156.35', '1696172825', '__ci_last_regenerate|i:1696172825;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('91vqv5e68k8ph61re5a1bda5trb4d8cg', '103.67.156.35', '1696172826', '__ci_last_regenerate|i:1696172826;'), ('ah5udpi6tbs8smbmn5l9ga5qfrvhkqhl', '103.67.156.35', '1696172855', '__ci_last_regenerate|i:1696172855;'), ('91ebjkt2n2v1tv23fgv2u3e5a6ebasra', '103.67.156.35', '1696172910', '__ci_last_regenerate|i:1696172910;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('idmj232up6gkqq8bothrdita1oovk6tc', '103.67.156.35', '1696172910', '__ci_last_regenerate|i:1696172910;'), ('pvaocf46hr6k287c0naqi02u5kgge84h', '103.67.156.35', '1696172911', '__ci_last_regenerate|i:1696172911;'), ('tlq2cd0sm1kahq08citpp5i3ojroq145', '103.67.156.35', '1696175287', '__ci_last_regenerate|i:1696175287;'), ('gf5d2hu8vv5c0ffqsgc94p8f1af5vokb', '103.67.156.35', '1696175290', '__ci_last_regenerate|i:1696175290;'), ('e9nmu6inqsd3e2vlt6auurblnd5osths', '103.67.156.35', '1696175290', '__ci_last_regenerate|i:1696175290;'), ('b3jr4ed95lj12lnbs60nu5ss9i8ip0ij', '103.67.156.35', '1696175290', '__ci_last_regenerate|i:1696175290;'), ('e9vo5q84d6tjfohmpahohshe7ojv4tg3', '103.67.156.35', '1696175290', '__ci_last_regenerate|i:1696175290;'), ('d69ue186iqo99c1ir46ctqge679c42rk', '103.67.156.35', '1696175290', '__ci_last_regenerate|i:1696175290;'), ('njine84mjva0th0k65euo1ndr0l8aj7c', '103.67.156.35', '1696175290', '__ci_last_regenerate|i:1696175290;'), ('jmcd9nsfc289fe7llk8ptj3jivcalncb', '103.67.156.35', '1696175290', '__ci_last_regenerate|i:1696175290;'), ('db0pql7n77lmls9h2eutdk78ut9e086e', '103.67.156.35', '1696176036', '__ci_last_regenerate|i:1696176036;'), ('ju96rj8d2et7na1bj16q7ko0j3em1ru5', '103.67.156.35', '1696176104', '__ci_last_regenerate|i:1696176104;'), ('r5qcf518j6j7mi5qfli17pgkqdu62pek', '103.67.156.35', '1696176197', '__ci_last_regenerate|i:1696176197;'), ('l6i07pmlod07tgmm5m2oftim6ph3i52t', '103.67.156.35', '1696176337', '__ci_last_regenerate|i:1696176337;'), ('vfte9if21vn6gm4r23k424ughja2spsh', '103.67.156.35', '1696176338', '__ci_last_regenerate|i:1696176338;'), ('jco3hsrhf2jsp18vkk4aaj0i1kot5jrn', '103.67.156.35', '1696176339', '__ci_last_regenerate|i:1696176339;'), ('maoodcggdfehb0ula3bmmjuiph8fsvvh', '103.67.156.35', '1696176339', '__ci_last_regenerate|i:1696176339;'), ('vv6qmji6a1cg0db7basgbvj81psgtj1b', '103.67.156.35', '1696176339', '__ci_last_regenerate|i:1696176339;'), ('j5e23poa8u4oo9ai91djuvl8o1jdpgmg', '103.67.156.35', '1696176339', '__ci_last_regenerate|i:1696176339;'), ('3f9nrh9l29mjdr3mmc615kf4c07rajso', '103.67.156.35', '1696176340', '__ci_last_regenerate|i:1696176340;'), ('vcpja7qqi1ii3fkcntcchibrpkek0uut', '103.67.156.35', '1696176355', '__ci_last_regenerate|i:1696176355;'), ('dshjvrmtj0o4tvoq4vm9n1j42936g73v', '103.67.156.35', '1696176364', '__ci_last_regenerate|i:1696176364;'), ('7dcht0tl8tjtk53hhqv6s5i17v637sad', '103.67.156.35', '1696176365', '__ci_last_regenerate|i:1696176365;'), ('aa82bus0n72ftgl1mjeu5m58r1rdck8j', '103.67.156.35', '1696176365', '__ci_last_regenerate|i:1696176365;'), ('afijrefsdj5ui8f1vlf3l17c9tdg5dhv', '103.67.156.35', '1696176365', '__ci_last_regenerate|i:1696176365;'), ('0n0q83c7fhlaobb33ao8c9c4aj8fmsvg', '103.67.156.35', '1696176365', '__ci_last_regenerate|i:1696176365;'), ('rmo1ctidnnunn0o9uar4t3f4e877r8cj', '103.67.156.35', '1696176365', '__ci_last_regenerate|i:1696176365;'), ('q832uuqicqdbc22vvmdooh73k9iq62cb', '103.67.156.35', '1696176365', '__ci_last_regenerate|i:1696176365;'), ('tm41e1v30ikj64qkakgi794h1rhkeau1', '103.67.156.35', '1696176367', '__ci_last_regenerate|i:1696176367;'), ('jgu649df1bfl1jjd0nq3b45t74qds7me', '103.67.156.35', '1696176369', '__ci_last_regenerate|i:1696176367;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ernhlhhhgvagha207qkv1on0ik4ke5gg', '103.67.156.35', '1696176370', '__ci_last_regenerate|i:1696176370;'), ('eblkhe31b3qb55ngg2q3t0a079h547bs', '103.67.156.35', '1696176474', '__ci_last_regenerate|i:1696176474;'), ('gm4ai47idfmbjap0e0f11o66biorstg7', '103.67.156.35', '1696176474', '__ci_last_regenerate|i:1696176474;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('hkkvr0948mc7p1ncv007g7g7kv93117o', '103.67.156.35', '1696176474', '__ci_last_regenerate|i:1696176474;'), ('3p23dhghm6tnsp99r2r6krhjpcujbuca', '103.67.156.35', '1696176839', '__ci_last_regenerate|i:1696176839;'), ('m1skk92k1mvo46dmjiok3vbsthdd2rsn', '103.67.156.35', '1696176843', '__ci_last_regenerate|i:1696176843;'), ('ikcceigitd25a20ccn1ce8nq0a82vo7r', '103.67.156.35', '1696176843', '__ci_last_regenerate|i:1696176843;'), ('ksuhr2s43ffnsvg5i2jcomkui6gojp2c', '103.67.156.35', '1696176843', '__ci_last_regenerate|i:1696176843;'), ('rpcppnm3hq6svnjk0d97p597nrnjubs5', '103.67.156.35', '1696176843', '__ci_last_regenerate|i:1696176843;'), ('ifolcogu94bkik83fbhualssinasofbu', '103.67.156.35', '1696176843', '__ci_last_regenerate|i:1696176843;'), ('ecj4oimsa01mn33po9f6nubhvfkvn4bh', '103.67.156.35', '1696176843', '__ci_last_regenerate|i:1696176843;'), ('b0gu2ucs4tqskm2t0i47ja8rl165bl9k', '103.67.156.35', '1696176844', '__ci_last_regenerate|i:1696176844;'), ('16sd5d9q3q8hruhv5f8lhf97rnkv66it', '103.67.156.35', '1696176926', '__ci_last_regenerate|i:1696176926;'), ('12jfo8q23h84kp865hgm9md4ff3ilpgn', '103.67.156.35', '1696176926', '__ci_last_regenerate|i:1696176926;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('op0o80q07k3mip37gj9g9bq6me34t3de', '103.67.156.35', '1696176927', '__ci_last_regenerate|i:1696176927;'), ('pe2okft2mqn1poibaoa8c6p15u1ulvdh', '103.67.156.35', '1696177001', '__ci_last_regenerate|i:1696177001;'), ('o6vf71vc97ms91sbsenmna2daaco0ucj', '103.67.156.35', '1696177004', '__ci_last_regenerate|i:1696177004;'), ('329hgv8v08qgouqmlrrrfr3l7rhodvou', '103.67.156.35', '1696177004', '__ci_last_regenerate|i:1696177004;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('65jdcq6ajguok5rlp2olg17snhnu0thn', '103.67.156.35', '1696177005', '__ci_last_regenerate|i:1696177005;'), ('khb61kki5gfik7olhmk94g9qojndc6j6', '103.67.156.35', '1696177047', '__ci_last_regenerate|i:1696177047;'), ('q8j87ab5dujs8csh8enadvpvi6doikda', '103.67.156.35', '1696177053', '__ci_last_regenerate|i:1696177053;'), ('kv4ijn72hbmb8rlrgh5fernrq4uucjhv', '103.67.156.35', '1696177053', '__ci_last_regenerate|i:1696177053;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('v43mi46svgpcam7u2u5ie9k03s9e3l88', '103.67.156.35', '1696177053', '__ci_last_regenerate|i:1696177053;'), ('fcb70lvk9n957utthlau00pkg8hf3ocj', '103.67.156.35', '1696177170', '__ci_last_regenerate|i:1696177170;'), ('76fro49i8jgb0hg18gh979b8r253hi7g', '103.67.156.35', '1696177172', '__ci_last_regenerate|i:1696177172;'), ('b42v1qnnl417qdc8effe7gb6d3hcpkqp', '103.67.156.35', '1696177172', '__ci_last_regenerate|i:1696177172;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('drvleljn5ij2cvcv0cn9pr9m7lkf8g7n', '103.67.156.35', '1696177173', '__ci_last_regenerate|i:1696177173;'), ('j39ijj5672jtjm4m3a4okfqof57v4fse', '103.67.156.35', '1696177230', '__ci_last_regenerate|i:1696177230;'), ('ttu2fe6nu8pfe1rlnv2jmaodjgi616bh', '103.67.156.35', '1696177232', '__ci_last_regenerate|i:1696177232;'), ('1vjjqkd93m1pr4elja6fhieqmbfqcm48', '103.67.156.35', '1696177232', '__ci_last_regenerate|i:1696177232;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('j911otb5ecrojcji3pcsct7bk9hr4q4j', '103.67.156.35', '1696177233', '__ci_last_regenerate|i:1696177233;'), ('c1iuarvae2ofahhbvs9f42ha9p9i4shq', '103.67.156.35', '1696177301', '__ci_last_regenerate|i:1696177301;'), ('uskt1irqrfa96jfeop40lng4d3806phn', '103.67.156.35', '1696177304', '__ci_last_regenerate|i:1696177304;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('rgf14auvbvo13iu37gr71sbmgh4lge4i', '103.67.156.35', '1696177304', '__ci_last_regenerate|i:1696177304;'), ('12est2kqtufutupjig0i61jeer4sfk8k', '103.67.156.35', '1696177305', '__ci_last_regenerate|i:1696177305;'), ('21e1lt80fs8ps5afkklr1bmnglkb44g9', '103.67.156.35', '1696177362', '__ci_last_regenerate|i:1696177362;'), ('eis0qu4mfhdedpvvuk3hkf1q2k147687', '103.67.156.35', '1696177364', '__ci_last_regenerate|i:1696177364;'), ('8d75hkpbps04nuril567nac7cnhu06n6', '103.67.156.35', '1696177364', '__ci_last_regenerate|i:1696177364;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('abd5ebfi2mrjg7dcv2utju62els7krtj', '103.67.156.35', '1696177365', '__ci_last_regenerate|i:1696177365;'), ('1lf3vn16epm8q40itdnfnjo1n1cqhst3', '103.67.156.35', '1696177393', '__ci_last_regenerate|i:1696177393;'), ('mr3kgpc9gijl7boo3e1m9nt2r1m1ejvt', '103.67.156.35', '1696177396', '__ci_last_regenerate|i:1696177396;'), ('nmk63rg93t7psu8ovca2857ga728vupm', '103.67.156.35', '1696177396', '__ci_last_regenerate|i:1696177396;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('s5kosg3ld34a5p7778qi4ic5akeckfc7', '103.67.156.35', '1696177397', '__ci_last_regenerate|i:1696177397;'), ('b2tlmtikmq6uub9bdg7hkdojsveipsu6', '103.67.156.35', '1696177421', '__ci_last_regenerate|i:1696177421;'), ('k2jt0ocfocbnk8vhcuvi5n343br9qkcj', '103.67.156.35', '1696177423', '__ci_last_regenerate|i:1696177423;'), ('n1jhlralldlv3b84vg787bnjhnfeo4dm', '103.67.156.35', '1696177423', '__ci_last_regenerate|i:1696177423;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('k0n4ho1tislekv8ddobombl8odqgdp9k', '103.67.156.35', '1696177424', '__ci_last_regenerate|i:1696177424;'), ('90368m44qd2bn1507gumo8t2hl797ub5', '103.67.156.35', '1696177501', '__ci_last_regenerate|i:1696177501;'), ('1fh156m40mdsfm64j6o2n37djc8sm84o', '103.67.156.35', '1696177503', '__ci_last_regenerate|i:1696177503;'), ('jdmbv460cgik5e2kg0n191fa86k6lc3a', '103.67.156.35', '1696177503', '__ci_last_regenerate|i:1696177503;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('6rpepfetmt3ojj1l83pdqlct5283bgip', '103.67.156.35', '1696177504', '__ci_last_regenerate|i:1696177504;'), ('vmk190c1akt7n1d31un7hf48lb3khs0d', '103.67.156.35', '1696177776', '__ci_last_regenerate|i:1696177776;'), ('edaa02fp0dukiiudlrgd3kjkqr2jdf6l', '103.67.156.35', '1696177778', '__ci_last_regenerate|i:1696177778;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('n9u49h8cfsg70q06mmd0crkdb7ki153m', '103.67.156.35', '1696177778', '__ci_last_regenerate|i:1696177778;'), ('5f92ja5qtpnc4vfr44hsq9v5jcklv4ui', '103.67.156.35', '1696177779', '__ci_last_regenerate|i:1696177779;'), ('bc74bs2j4hs544ag6asdujqt1q4tfmn5', '103.67.156.35', '1696177928', '__ci_last_regenerate|i:1696177928;'), ('e4mt64rpb1ras6jplqbiega9u205ur5p', '103.67.156.35', '1696177931', '__ci_last_regenerate|i:1696177931;'), ('7g5ufbu2peam8j27hs7rbpq7vom06n3u', '103.67.156.35', '1696177931', '__ci_last_regenerate|i:1696177931;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('8p3g8c2cvjr6pft9h5c7ijr8bvv44ms2', '103.67.156.35', '1696177931', '__ci_last_regenerate|i:1696177931;'), ('nuhrusbfc4ctd3ko8v970eahl8lj66o2', '103.67.156.35', '1696177940', '__ci_last_regenerate|i:1696177940;'), ('ur5so648qobkeiju22t0qo3u2ttu9mav', '103.67.156.35', '1696177943', '__ci_last_regenerate|i:1696177943;'), ('fs1pbu55huc83ourmqgad1q70ohp4597', '103.67.156.35', '1696177943', '__ci_last_regenerate|i:1696177943;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('4o8033d4evdh98t6r0bmjl909vsdnvtn', '103.67.156.35', '1696177943', '__ci_last_regenerate|i:1696177943;'), ('efk4bnof327bbhkilqcvmfmlrv5gq9qi', '103.67.156.35', '1696178641', '__ci_last_regenerate|i:1696178641;'), ('mkns631fgof3lab8kkja1vnooj89de3m', '103.67.156.35', '1696178643', '__ci_last_regenerate|i:1696178643;'), ('kk97kf6jmn2np0mgtu1119benra9humd', '103.67.156.35', '1696178643', '__ci_last_regenerate|i:1696178643;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('cikfllme9k90fb9sacebm4l6o4ldq5mm', '103.67.156.35', '1696178644', '__ci_last_regenerate|i:1696178644;'), ('a35n90j68en0eiu98te4f4ironht8nhi', '103.67.156.35', '1696178712', '__ci_last_regenerate|i:1696178712;'), ('2322j110ucrg98f85o3uurgck67hijsc', '103.67.156.35', '1696178712', '__ci_last_regenerate|i:1696178712;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('loh42vnm08rckkpdkadufss54odk3hal', '103.67.156.35', '1696178713', '__ci_last_regenerate|i:1696178713;'), ('tbrug6l8kd4463m0mkil0h62tesl5pa0', '103.67.156.35', '1696178750', '__ci_last_regenerate|i:1696178750;'), ('h0q98hhs7o38mb3a2t1qjmh2dfq913t5', '103.67.156.35', '1696178750', '__ci_last_regenerate|i:1696178750;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('jt1intf97j2m36jq2l5h1nd96i9s62v9', '103.67.156.35', '1696178751', '__ci_last_regenerate|i:1696178751;'), ('s0hukef3sd8m6po9ibncnj0etaas2n1s', '103.67.156.35', '1696178878', '__ci_last_regenerate|i:1696178878;'), ('2ab6e8m9qq5apm10tvjec18ko4mi1hf3', '103.67.156.35', '1696178878', '__ci_last_regenerate|i:1696178878;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('93lrfs61s4ipaliqppgfj2i8451ont8k', '103.67.156.35', '1696178879', '__ci_last_regenerate|i:1696178879;'), ('0sme80co7gt3ubtstm4htpqak9blle8a', '103.67.156.35', '1696179197', '__ci_last_regenerate|i:1696179197;'), ('3i5c463agmfgakbdhel8id524fltjr0m', '103.67.156.35', '1696179200', '__ci_last_regenerate|i:1696179200;'), ('pn8oe92jnftql7fe7lul4q048v13a23e', '103.67.156.35', '1696179200', '__ci_last_regenerate|i:1696179200;'), ('p9aaj39b99mgkr5o51925e3iu5e8fcp5', '103.67.156.35', '1696179200', '__ci_last_regenerate|i:1696179200;'), ('228a4mc3g4amcnuedq87fbs98ei8m6hi', '103.67.156.35', '1696179200', '__ci_last_regenerate|i:1696179200;'), ('trjqc95qbimaa3gc2ci98k3v1ble3ja0', '103.67.156.35', '1696179200', '__ci_last_regenerate|i:1696179200;'), ('s2i296p8eqpd9ig285k587ev6h1n5obt', '103.67.156.35', '1696179200', '__ci_last_regenerate|i:1696179200;'), ('5fbt6qiapmrq3ijiegkuvl8ptgnt4cs7', '103.67.156.35', '1696179201', '__ci_last_regenerate|i:1696179201;'), ('7v76cgvopu8itdc55bl6gljp3meot13m', '103.67.156.35', '1696179203', '__ci_last_regenerate|i:1696179203;'), ('3k9oskqn8mcob1o8d5c154lf9bniphc5', '103.67.156.35', '1696179203', '__ci_last_regenerate|i:1696179203;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('861tip3p19ahs3vog73uubcubsnm91go', '103.67.156.35', '1696179203', '__ci_last_regenerate|i:1696179203;'), ('som5ijkh6ktlr1lb8g3sobihdfv0l82k', '103.67.156.35', '1696179241', '__ci_last_regenerate|i:1696179241;'), ('fgcld9vqc5lcul518jjgtf8q8gq9rpm9', '103.67.156.35', '1696179243', '__ci_last_regenerate|i:1696179243;'), ('is6dvd7t4qi47oqha59t3fp4aduuph0o', '103.67.156.35', '1696179243', '__ci_last_regenerate|i:1696179243;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('are715ko6035eeqlkbl3os1j1nvb1b2c', '103.67.156.35', '1696179243', '__ci_last_regenerate|i:1696179243;'), ('gf9k644sc0v8quitmj23456im8uakkhe', '103.67.156.35', '1696179258', '__ci_last_regenerate|i:1696179258;'), ('mk23suitct9qi3qb2ac7g5chke4gdkm6', '103.67.156.35', '1696179260', '__ci_last_regenerate|i:1696179260;'), ('3buer6j2kk0jhs4mo0c3edf6vari1st6', '103.67.156.35', '1696179260', '__ci_last_regenerate|i:1696179260;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('2v0qpj9g02mjhpb5tb1u361svcdlen4q', '103.67.156.35', '1696179261', '__ci_last_regenerate|i:1696179261;'), ('o7lcdd5nl8bs8tekgf4tv76qb59fm8ob', '103.67.156.35', '1696179271', '__ci_last_regenerate|i:1696179271;'), ('fo1pofqfdqeid23nbffcopja5cbnna81', '103.67.156.35', '1696179273', '__ci_last_regenerate|i:1696179273;'), ('3e18ltedug376hlf9k01qfvdhk4rrv44', '103.67.156.35', '1696179273', '__ci_last_regenerate|i:1696179273;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('5unm2ibgljf0at9053po7ghsh00cpkas', '103.67.156.35', '1696179274', '__ci_last_regenerate|i:1696179274;'), ('lmg8es1gpnp9jdn15a5ghnagrrt6pg0l', '103.67.156.35', '1696179297', '__ci_last_regenerate|i:1696179297;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('43no1sqtut2hg82lak5gfb8tjhfd50sr', '103.67.156.35', '1696179297', '__ci_last_regenerate|i:1696179297;'), ('gt58qp71u0ouu45n5de5994c5agtf23t', '103.67.156.35', '1696179297', '__ci_last_regenerate|i:1696179297;'), ('9qsni659k8p20n6ml12qm8di6ia5vhii', '103.67.156.35', '1696179341', '__ci_last_regenerate|i:1696179341;'), ('eqo53ld3hnjh35k3vbf5mlrnqngfulsb', '103.67.156.35', '1696179344', '__ci_last_regenerate|i:1696179344;'), ('2r5ikgqa6isfa6ker7p5j9togf4rs7o9', '103.67.156.35', '1696179344', '__ci_last_regenerate|i:1696179344;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('q4s6o61nml0pca2kf0adpmlp1pvu0eif', '103.67.156.35', '1696179344', '__ci_last_regenerate|i:1696179344;'), ('j98svrnaiqkn21ofadoe7446he01706l', '103.67.156.35', '1696179638', '__ci_last_regenerate|i:1696179638;'), ('5fmnonr3e87nqqv7u5j8dvef9ii0l55o', '103.67.156.35', '1696179641', '__ci_last_regenerate|i:1696179641;'), ('2p9sp6vep57m7bd74cnmmdutfj95mr9a', '103.67.156.35', '1696179641', '__ci_last_regenerate|i:1696179641;'), ('nnap4kagdbeuk6js961s834qd5118duo', '103.67.156.35', '1696179641', '__ci_last_regenerate|i:1696179641;'), ('2laau5r7t3ggppd8f7ghb3fc5n5ljk0c', '103.67.156.35', '1696179641', '__ci_last_regenerate|i:1696179641;'), ('8dr0k9f6qv8fi0a1emfqb97lihnsf7eq', '103.67.156.35', '1696179641', '__ci_last_regenerate|i:1696179641;'), ('3214e57blg3jq61348ophmf6ilnpj1tc', '103.67.156.35', '1696179641', '__ci_last_regenerate|i:1696179641;'), ('5mllrqh4hbo5kfbtkidcb86l82qjlo05', '103.67.156.35', '1696179642', '__ci_last_regenerate|i:1696179642;'), ('4fi4pn66e48dfnru289tv87cnkb4oj8p', '103.67.156.35', '1696179708', '__ci_last_regenerate|i:1696179708;'), ('tdj2uj4iaqtidd3a9v8ds0eo9svhocrg', '103.67.156.35', '1696179708', '__ci_last_regenerate|i:1696179708;'), ('lv02f79aartlbbfcm4r9o3ct8706j3ne', '103.67.156.35', '1696179708', '__ci_last_regenerate|i:1696179708;'), ('mjcn8gb18lk8su819u9smkfn3ouo5af1', '103.67.156.35', '1696179708', '__ci_last_regenerate|i:1696179708;'), ('g5hkmogffmkcish6gmboeqv57jtapsvs', '103.67.156.35', '1696179708', '__ci_last_regenerate|i:1696179708;'), ('gmfd0niunal5oben3cl7umsnp8hdvm3a', '103.67.156.35', '1696179709', '__ci_last_regenerate|i:1696179709;'), ('n2iutiebh59b61jnj8c8ejcfmt34l2co', '103.67.156.35', '1696179710', '__ci_last_regenerate|i:1696179710;'), ('ej5qtv2069hkehtqpgb9shmivag8932s', '103.67.156.35', '1696179710', '__ci_last_regenerate|i:1696179710;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('0d80585vgq3ti5nn6iou2g502b13itet', '103.67.156.35', '1696179711', '__ci_last_regenerate|i:1696179711;'), ('i4oor96vvu3h6ja3vft7bh1qe8c8qaaa', '103.67.156.35', '1696179762', '__ci_last_regenerate|i:1696179762;'), ('4oqri996p9nr3thk3f6jm2jiq184bnga', '103.67.156.35', '1696179765', '__ci_last_regenerate|i:1696179765;'), ('bpv8mg908sts3j46rjaompi6i41qk1qf', '103.67.156.35', '1696179765', '__ci_last_regenerate|i:1696179765;'), ('o41phsag4khlcsnjguu42t0dfqmj6fj9', '103.67.156.35', '1696179765', '__ci_last_regenerate|i:1696179765;'), ('e8cct97am15kdfki83nud7j41oh4umtd', '103.67.156.35', '1696179765', '__ci_last_regenerate|i:1696179765;'), ('c976hrkukmlrt8939rrvpkfnf4fleoen', '103.67.156.35', '1696179765', '__ci_last_regenerate|i:1696179765;'), ('607mjqdd0uiei7ah6lmku8nuilqu0ku8', '103.67.156.35', '1696179765', '__ci_last_regenerate|i:1696179765;'), ('d7uch3furonhihma3uci22i6oe12rh1b', '103.67.156.35', '1696179765', '__ci_last_regenerate|i:1696179765;'), ('6cc978m982rtladskbp0f1ifurtm22gp', '103.67.156.35', '1696179767', '__ci_last_regenerate|i:1696179767;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('0g3n5nsqus5ghibfurke7v5a4o1r6eti', '103.67.156.35', '1696179767', '__ci_last_regenerate|i:1696179767;'), ('66pv7ujtcb1sghpdh1ci6980slg0vqr5', '103.67.156.35', '1696179767', '__ci_last_regenerate|i:1696179767;'), ('gipje152vmpthgl58v65vohp4bn9r0jb', '103.67.156.35', '1696179875', '__ci_last_regenerate|i:1696179875;'), ('kspbi3ue6af2t9q6pdrt24s4otgmpqf8', '103.67.156.35', '1696179884', '__ci_last_regenerate|i:1696179884;'), ('7e5i11mhglg30ial5ecp9gb8emsav9vo', '103.67.156.35', '1696180168', '__ci_last_regenerate|i:1696180168;'), ('32jc1dd4pll1b0u0988trkc2m24uk1kr', '103.67.156.35', '1696180367', '__ci_last_regenerate|i:1696180367;'), ('e5pmg391hbpst3o38ugimsgdce6n04rn', '103.67.156.35', '1696180367', '__ci_last_regenerate|i:1696180367;'), ('74gicv1kvsk0khhlunsjo1esn0t34uv3', '103.67.156.35', '1696180367', '__ci_last_regenerate|i:1696180367;'), ('fhrenvnvi7onjfpt8qe4d8211fb20dep', '103.67.156.35', '1696180367', '__ci_last_regenerate|i:1696180367;'), ('0qnopfpguft339qto4cq02g6r8spj55g', '103.67.156.35', '1696180367', '__ci_last_regenerate|i:1696180367;'), ('47h56unnlp2lke5pmvqu62864j3amf4d', '103.67.156.35', '1696180368', '__ci_last_regenerate|i:1696180368;'), ('m5t2eb19ptkalonolrmmikfs375jgm3e', '103.67.156.35', '1696180369', '__ci_last_regenerate|i:1696180369;'), ('afu34mmlccf0ue1ju6acofhbkd2bv6k9', '103.67.156.35', '1696180369', '__ci_last_regenerate|i:1696180369;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('956gt66e86n54gsnecvc08j5ras2dprg', '103.67.156.35', '1696180369', '__ci_last_regenerate|i:1696180369;'), ('mjttuo6190aepp1qhf0j1d2nles867jb', '103.67.156.35', '1696180384', '__ci_last_regenerate|i:1696180384;'), ('135i8a8eh0pirr9pjtpm906rjrqj63pe', '103.67.156.35', '1696180385', '__ci_last_regenerate|i:1696180385;'), ('6ng64a4e4ep6hj7b8d4tk8sq89q79fho', '103.67.156.35', '1696180385', '__ci_last_regenerate|i:1696180385;'), ('pt10ekjig68ra9el206obd6v8k0sh2ck', '103.67.156.35', '1696180385', '__ci_last_regenerate|i:1696180385;'), ('idjmbg22miejnj8t52t4ritpda2l063g', '103.67.156.35', '1696180385', '__ci_last_regenerate|i:1696180385;'), ('16eg2p1k2avc3o2jr8gbe3fojdt1aqvj', '103.67.156.35', '1696180385', '__ci_last_regenerate|i:1696180385;'), ('sf7ubh4uvul4961mdk9j8po1cvo4mhvj', '103.67.156.35', '1696180385', '__ci_last_regenerate|i:1696180385;'), ('mp4j9mlpikihc4joeugctvmkhm4655jn', '103.67.156.35', '1696180385', '__ci_last_regenerate|i:1696180385;'), ('pllt626pron7egfcb8hla0gs77t12lpu', '103.67.156.35', '1696180721', '__ci_last_regenerate|i:1696180721;'), ('0a2928rl9qe8k18utubctuhjgko5indt', '103.67.156.35', '1696180724', '__ci_last_regenerate|i:1696180724;'), ('dm8ehl1kglh1prksn3lishke1dtfurnj', '103.67.156.35', '1696180724', '__ci_last_regenerate|i:1696180724;'), ('gee314j4pn9ghivfujve2pcbikff65j2', '103.67.156.35', '1696180724', '__ci_last_regenerate|i:1696180724;'), ('ur44dkg33di6mm1hkf5kv5lj65tt38n8', '103.67.156.35', '1696180724', '__ci_last_regenerate|i:1696180724;'), ('cit7ecfhrl0djvso1mh245put150o20p', '103.67.156.35', '1696180724', '__ci_last_regenerate|i:1696180724;'), ('rhqhnd2iqkp8t2cbm8keldlqnc1gbabf', '103.67.156.35', '1696180724', '__ci_last_regenerate|i:1696180724;'), ('85i0iqqagg4pgedsj6jib6h6pu24qh5t', '103.67.156.35', '1696180725', '__ci_last_regenerate|i:1696180725;'), ('u25mks26i0i8bu4n42c810d7h9qrumrn', '103.67.156.35', '1696180866', '__ci_last_regenerate|i:1696180866;'), ('77v9pjia1tu9ct9h53vjvhh1fmv74kae', '103.67.156.35', '1696180866', '__ci_last_regenerate|i:1696180866;'), ('da1pkalibv5nbmq4tt4smeiuo88bbioc', '103.67.156.35', '1696180866', '__ci_last_regenerate|i:1696180866;'), ('fukk6hafeptg8dqunj8257s0tj9phq2d', '103.67.156.35', '1696180866', '__ci_last_regenerate|i:1696180866;'), ('of0a0uujes95qqj1lhhnsj75d7cq2l0t', '103.67.156.35', '1696180866', '__ci_last_regenerate|i:1696180866;'), ('teoorl9f6tfrdfrr57pds1vrfmlp8cqf', '103.67.156.35', '1696180867', '__ci_last_regenerate|i:1696180867;'), ('lakj0o9110lem4s79iqt6pvintbiiab1', '103.67.156.35', '1696180869', '__ci_last_regenerate|i:1696180869;'), ('mqkrssrnmhptpldudso59qtf72q6p9c8', '103.67.156.35', '1696180869', '__ci_last_regenerate|i:1696180869;'), ('gdtvohe3f310q3b7apebtiutkv1iqv4h', '103.67.156.35', '1696180869', '__ci_last_regenerate|i:1696180869;'), ('onfqgbpi679mdvuc99vf9hakj5rotum7', '103.67.156.35', '1696180869', '__ci_last_regenerate|i:1696180869;'), ('7ahtj5nirbabfqpjanqss3p0mmln7prl', '103.67.156.35', '1696180869', '__ci_last_regenerate|i:1696180869;'), ('p0o85trm0kj4eqsl26j1kdcle8mlr5b2', '103.67.156.35', '1696180870', '__ci_last_regenerate|i:1696180870;'), ('ffr80fqk248fhmn8lfoi63fh1umjh9nm', '116.58.201.240', '1696181230', '__ci_last_regenerate|i:1696181230;'), ('a6lkei96e3cid2af7l8tuf6u1c35cdui', '103.67.156.35', '1696181572', '__ci_last_regenerate|i:1696181572;'), ('utsfmu09go7og28rs0suu2auhnupe8r4', '103.67.156.35', '1696181572', '__ci_last_regenerate|i:1696181572;'), ('lnesjvaf1nmabk64f11ehcm3iov35hr8', '103.67.156.35', '1696182840', '__ci_last_regenerate|i:1696182840;'), ('k0l73eaqkvq5db0269p6famiis88sf1s', '103.67.156.35', '1696182844', '__ci_last_regenerate|i:1696182844;'), ('d2q98nhnd82ka5ts1bbbp6o5mpor4pbe', '103.67.156.35', '1696182844', '__ci_last_regenerate|i:1696182844;'), ('gbgt8v7mhr7esdbgcltebg4a0tt7u6t0', '103.67.156.35', '1696182844', '__ci_last_regenerate|i:1696182844;'), ('m1uecqr0sl4t66l558sqr4tbmrprrf89', '103.67.156.35', '1696182844', '__ci_last_regenerate|i:1696182844;'), ('udt7eeghriise6r2vp01adapgc2515e8', '103.67.156.35', '1696182844', '__ci_last_regenerate|i:1696182844;'), ('vhhpb25bahtvb86fde4s4nqaj8vp159q', '103.67.156.35', '1696182844', '__ci_last_regenerate|i:1696182844;'), ('886efchg64fur85260sjs4tjjilhn0vp', '103.67.156.35', '1696182844', '__ci_last_regenerate|i:1696182844;'), ('uj56rqa6immp9acsoe2593hv7srirfnq', '103.67.156.35', '1696182891', '__ci_last_regenerate|i:1696182891;'), ('b4s7ovpk73k20dpq8npbqibcnfc5a7fq', '103.67.156.35', '1696182895', '__ci_last_regenerate|i:1696182895;'), ('4kagve3a0989qt5ea3imqichnedofuf1', '103.67.156.35', '1696182895', '__ci_last_regenerate|i:1696182895;'), ('d4p6n7mec6lpmkmjp918e9k0la6sg65o', '103.67.156.35', '1696182895', '__ci_last_regenerate|i:1696182895;'), ('mma7v48kahd38sargm2hrmuvlsd37tsb', '103.67.156.35', '1696182895', '__ci_last_regenerate|i:1696182895;'), ('4lsnfa4nhq8bb8ds1oto66lfb709n185', '103.67.156.35', '1696182895', '__ci_last_regenerate|i:1696182895;'), ('37d84sa813ftg5fijg3gfgi9ge3tih6b', '103.67.156.35', '1696182895', '__ci_last_regenerate|i:1696182895;'), ('v77pt8jme56hukjhn6l81tekia2nkasp', '103.67.156.35', '1696182895', '__ci_last_regenerate|i:1696182895;'), ('1pvhbn54ap35ouoschv20ub240pgi950', '103.67.156.35', '1696183007', '__ci_last_regenerate|i:1696183007;'), ('q4gikauf3na2lcr202d8ql1a8tdn64ne', '103.67.156.35', '1696183198', '__ci_last_regenerate|i:1696183198;'), ('5k55j6if9eprl2jmrn9nrmjloehnqgfg', '103.67.156.35', '1696183198', '__ci_last_regenerate|i:1696183198;'), ('m6prn9feirer4p5u0r3orfmq09g5l1bg', '103.67.156.35', '1696183199', '__ci_last_regenerate|i:1696183199;'), ('3jhduqjp389irm4otke9o7m1mc7uhh6v', '103.67.156.35', '1696183199', '__ci_last_regenerate|i:1696183199;'), ('2qp16ern99nabcfqfh6fu672cgaqhoii', '103.67.156.35', '1696183199', '__ci_last_regenerate|i:1696183199;'), ('lb3utatfa72na00pcovbm52cg96leduk', '103.67.156.35', '1696183199', '__ci_last_regenerate|i:1696183199;'), ('hjgr1l1k74toavfbentjvlljc1o8o6sp', '103.67.156.35', '1696183199', '__ci_last_regenerate|i:1696183199;'), ('en5alsr5j2v088fl6piup0sgrlkqma0l', '103.67.156.35', '1696183199', '__ci_last_regenerate|i:1696183199;'), ('eemd6b6ss5jf3t26mbhfkkuos0ept7uv', '103.67.156.35', '1696183463', '__ci_last_regenerate|i:1696183463;'), ('mdm320f545b6241g94pr2g377or2o7ms', '103.67.156.35', '1696183466', '__ci_last_regenerate|i:1696183466;'), ('c9tfi13bjop94fq56mb1h9lkthrfhel0', '103.67.156.35', '1696183466', '__ci_last_regenerate|i:1696183466;'), ('m1fkath4jh2upvr91j1hi9vv2dvtiemt', '103.67.156.35', '1696183466', '__ci_last_regenerate|i:1696183466;'), ('j637v5urv9tdivnh2siumki05dkb5nqr', '103.67.156.35', '1696183466', '__ci_last_regenerate|i:1696183466;'), ('pvugticgidlcr87e669stn9ahv1fk7aq', '103.67.156.35', '1696183466', '__ci_last_regenerate|i:1696183466;'), ('1ci0h5j260j0qup2ro4rrddmos2nmlq7', '103.67.156.35', '1696183466', '__ci_last_regenerate|i:1696183466;'), ('4ojl6ffp8425frj2jh74fri1mo07qmeu', '103.67.156.35', '1696183467', '__ci_last_regenerate|i:1696183467;'), ('qjun676jmb7pmustar6brdau3702phbo', '103.67.156.35', '1696183490', '__ci_last_regenerate|i:1696183490;'), ('o6s1f73gi8ust17edreu99jd151s3d9m', '103.67.156.35', '1696183491', '__ci_last_regenerate|i:1696183491;'), ('kvgtq1llj1rnr4cq2igf10g6vafrbogd', '103.67.156.35', '1696183491', '__ci_last_regenerate|i:1696183491;'), ('dbqsm7hs1odqsp4clpths3lachql6pvh', '103.67.156.35', '1696183491', '__ci_last_regenerate|i:1696183491;'), ('7u58jcgjbaltbatuhlvd46j8rko7cf27', '103.67.156.35', '1696183491', '__ci_last_regenerate|i:1696183491;'), ('sgj4ttn47mrc269b5mkbsbdihft8ndmv', '103.67.156.35', '1696183491', '__ci_last_regenerate|i:1696183491;'), ('kbdr0ek7fo2io073rrr5h384s9r40iq0', '103.67.156.35', '1696183491', '__ci_last_regenerate|i:1696183491;'), ('bfvborqb1gqkv88sr9teijrk1rtipe5a', '103.67.156.35', '1696183491', '__ci_last_regenerate|i:1696183491;'), ('ats11vp6he8s1c6pj08eg9c93b8u8ebl', '103.67.156.35', '1696361587', '__ci_last_regenerate|i:1696183493;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1696403473;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('pn095ll64oq2j7tenehcrhn3kgbup56n', '103.67.156.35', '1696183495', '__ci_last_regenerate|i:1696183495;'), ('fec8f54p9nh1m4kij9ral3k4dik4dpgo', '103.67.156.35', '1696183496', '__ci_last_regenerate|i:1696183496;'), ('rk8mfbnavsn08h8jdhhllk8dlqi8tdof', '103.67.156.35', '1696183496', '__ci_last_regenerate|i:1696183496;'), ('spms4nr4in21giek8geg1og6uee6ncto', '103.67.156.35', '1696183496', '__ci_last_regenerate|i:1696183496;'), ('m8jku2bmb9i56j5o3541bn4p4l6br28j', '103.67.156.35', '1696183496', '__ci_last_regenerate|i:1696183496;'), ('ivencehpphig70pn6b823ird263etfud', '103.67.156.35', '1696183496', '__ci_last_regenerate|i:1696183496;'), ('8sda870qnfnqmdchl85qr1ugb4fvkssl', '103.67.156.35', '1696183496', '__ci_last_regenerate|i:1696183496;'), ('paade4ssi9q30ok1dvvi7bmqb3k9uc1g', '103.67.156.35', '1696183496', '__ci_last_regenerate|i:1696183496;'), ('dtj6laggil4s7m4k21nt4rne6s2t4jln', '103.67.156.35', '1696183497', '__ci_last_regenerate|i:1696183497;'), ('s7r4sesf8ghf0sdc96v4ei3t8ebbvjon', '103.67.156.35', '1696183497', '__ci_last_regenerate|i:1696183497;'), ('7a39cbchjl1b3emqqje8os5uub8m3i52', '103.67.156.35', '1696183497', '__ci_last_regenerate|i:1696183497;'), ('o4ro99mc7atsvq3kskcvgenpcsb1o3lf', '103.67.156.35', '1696183497', '__ci_last_regenerate|i:1696183497;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('rcukgc0cjbv9pr32cv32pb7o5ejs9kab', '103.67.156.35', '1696183498', '__ci_last_regenerate|i:1696183498;'), ('mm8cdkmf1qo9hjs6n1b3o591mr96s3mc', '103.67.156.35', '1696183533', '__ci_last_regenerate|i:1696183533;'), ('i2efbu4s9ar8dm59gac3tmo7bhkjejte', '103.67.156.35', '1696183537', '__ci_last_regenerate|i:1696183537;'), ('mafds8ecf4cltushd7j4li65oaoovro5', '103.67.156.35', '1696183537', '__ci_last_regenerate|i:1696183537;'), ('d9h9k0lu2rm2ilq8mebnfg48751k5ro7', '103.67.156.35', '1696183537', '__ci_last_regenerate|i:1696183537;'), ('fimrk91vepmq5aipmf3mcj5ipn31vm9u', '103.67.156.35', '1696183537', '__ci_last_regenerate|i:1696183537;'), ('boovu6ljp4sjk7r4h4ntjhmnv3ke6l8o', '103.67.156.35', '1696183537', '__ci_last_regenerate|i:1696183537;'), ('f5e3voumje09rh5dh7ki9tlalacjob3q', '103.67.156.35', '1696183537', '__ci_last_regenerate|i:1696183537;'), ('o3cm10q1et683q1p0ab7j35lq3hpqdej', '103.67.156.35', '1696183537', '__ci_last_regenerate|i:1696183537;'), ('1ji3op08imta36u406pmm8tvvume949a', '37.111.239.8', '1696183831', '__ci_last_regenerate|i:1696183831;'), ('ptla2ciqilthc3jdd3obga1rvip9pbvr', '37.111.239.8', '1696183835', '__ci_last_regenerate|i:1696183835;'), ('e4u399mog4gjkepaosms8h60k9afobgn', '37.111.239.8', '1696183835', '__ci_last_regenerate|i:1696183835;'), ('vop00krf8ds22nmccclcas2eq9nvc958', '37.111.239.8', '1696183835', '__ci_last_regenerate|i:1696183835;'), ('l5dr9il4hccjdoq022v5badill2pj2tt', '37.111.239.8', '1696183835', '__ci_last_regenerate|i:1696183835;'), ('q7qo8pqhfusiqbl6q6nuaun7vnfpa7v1', '37.111.239.8', '1696183835', '__ci_last_regenerate|i:1696183835;'), ('u52hmsgiet3sia621mkej6b20klbai2s', '37.111.239.8', '1696183835', '__ci_last_regenerate|i:1696183835;'), ('j68uf0kv63donc7j11upgo9o9tud6u26', '37.111.239.8', '1696183836', '__ci_last_regenerate|i:1696183836;'), ('adccnrd89a8qcbg6tiqse5kfi8f17il1', '37.111.239.8', '1696183842', '__ci_last_regenerate|i:1696183842;'), ('vmvcfop40dp8qkhdn89iucip4c7htbvk', '37.111.239.8', '1696183842', '__ci_last_regenerate|i:1696183842;'), ('e1m90qftnkca10gtflqsb88mvh7l6jst', '37.111.239.8', '1696183843', '__ci_last_regenerate|i:1696183843;'), ('kj2j3j9mmqqmm0ic4lav9t7l1an3p2fb', '37.111.239.8', '1696183847', '__ci_last_regenerate|i:1696183847;'), ('mdut2g8olh1natda1i6o490t67hdglf7', '37.111.239.8', '1696183847', '__ci_last_regenerate|i:1696183847;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('8lo5mve4gqsutl4vpmsj78oftdep6pk0', '37.111.239.8', '1696183847', '__ci_last_regenerate|i:1696183847;'), ('0edg7b0smv4p7tfd4hlmc43fb0n633q9', '37.111.239.8', '1696183876', '__ci_last_regenerate|i:1696183876;'), ('97adfi95ql04oq66mijsj0ktmr3snkmi', '37.111.239.8', '1696183876', '__ci_last_regenerate|i:1696183876;'), ('d37thqpnshp7cmbc86jlfno7u6k17cee', '37.111.239.8', '1696183877', '__ci_last_regenerate|i:1696183877;'), ('pjqf8pf86sls3gd04mb37v4okvftrai6', '37.111.239.8', '1696183878', '__ci_last_regenerate|i:1696183878;'), ('v34h32lf92jf0l471lgd37pn00kgsncl', '37.111.239.8', '1696183878', '__ci_last_regenerate|i:1696183878;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('9knm9dd28j3raaoqfuvmq30p4v0l5coh', '37.111.239.8', '1696183879', '__ci_last_regenerate|i:1696183879;'), ('7gqmdegc81puf3psppc3ik476jj6ekea', '37.111.239.8', '1696183881', '__ci_last_regenerate|i:1696183881;'), ('b4o62j03m7nc83omip7285np715p9d0r', '37.111.239.8', '1696183881', '__ci_last_regenerate|i:1696183881;'), ('djfmdoddvvnfvcj0qupd107mv8av2kl0', '37.111.239.8', '1696183881', '__ci_last_regenerate|i:1696183881;'), ('2po4dgq5gshqptnl55ma501eb4p6ssgm', '37.111.239.8', '1696183883', '__ci_last_regenerate|i:1696183883;'), ('pd5aubl6h1r2858eq5qcqsd214i6d9mb', '37.111.239.8', '1696183883', '__ci_last_regenerate|i:1696183883;'), ('5g2nqod6v9ne5l4dubetbe6d1eomqp49', '37.111.239.8', '1696183884', '__ci_last_regenerate|i:1696183884;'), ('8cas47mbbrg5kjt7ac9l8nlvkoar8mu4', '37.111.239.8', '1696183886', '__ci_last_regenerate|i:1696183886;'), ('d4dfi0n98raecg820b6l00tbqikddcjj', '37.111.239.8', '1696183886', '__ci_last_regenerate|i:1696183886;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('lfo97dfeour596j27jlj1coinlnpn9l2', '37.111.239.8', '1696183886', '__ci_last_regenerate|i:1696183886;'), ('e60n0ag794l9jo1utcsfbscve2oug3kv', '37.111.239.8', '1696183890', '__ci_last_regenerate|i:1696183890;'), ('kj8eciansjp1rmlnkodimnj712k8j2ur', '37.111.239.8', '1696183890', '__ci_last_regenerate|i:1696183890;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('vhpqnj5ckdfuilfrije0qm02vcaj0d1o', '37.111.239.8', '1696183890', '__ci_last_regenerate|i:1696183890;'), ('qm4sdgqipoj52qn690cr0m8n729oaub3', '37.111.239.8', '1696183896', '__ci_last_regenerate|i:1696183896;'), ('j50ikfk7pf63emoh0fmmc8ok51gmn5tn', '37.111.239.8', '1696183896', '__ci_last_regenerate|i:1696183896;'), ('mj2oqclvg57dfq7rp54vdto44hpjsb1p', '37.111.239.8', '1696183897', '__ci_last_regenerate|i:1696183897;'), ('kr5qbhrq5plmc1av6lblaoqa0fahf9g9', '37.111.239.8', '1696183898', '__ci_last_regenerate|i:1696183898;'), ('0sn0p56tesr03c0e5cp6d9gv3ogpukvj', '37.111.239.8', '1696183898', '__ci_last_regenerate|i:1696183898;'), ('1mlq8tepuluhn6mlq4kcfmroub7hca64', '37.111.239.8', '1696183900', '__ci_last_regenerate|i:1696183900;'), ('ca9d6hibsplerh7667s78ag8m223h8ho', '37.111.239.8', '1696183900', '__ci_last_regenerate|i:1696183900;'), ('pmeujc1qj6r2pml0lidv65vogfns17pm', '37.111.239.8', '1696183900', '__ci_last_regenerate|i:1696183900;'), ('ifap873pgjfujufecf0tiipogs15o8kb', '37.111.239.8', '1696183918', '__ci_last_regenerate|i:1696183918;'), ('vcgeqjpk33hejlb886921avgmhbuhicn', '37.111.239.8', '1696183920', '__ci_last_regenerate|i:1696183920;'), ('ernbk32c9cnopfb094d7d4h5d9gi31rg', '37.111.239.8', '1696183920', '__ci_last_regenerate|i:1696183920;'), ('bl9k8pek60achcptv4f1mb67rn9fcgim', '37.111.239.8', '1696183920', '__ci_last_regenerate|i:1696183920;'), ('c9ebajp0pmtfcn7h9dbb6dksrdrbsonn', '37.111.239.8', '1696183920', '__ci_last_regenerate|i:1696183920;'), ('j7783nt039ujc1ilaof5djbafau3kamb', '37.111.239.8', '1696183920', '__ci_last_regenerate|i:1696183920;'), ('h4uknlfmf2bjad42vfmftncrqt6g6pes', '37.111.239.8', '1696183920', '__ci_last_regenerate|i:1696183920;'), ('in87212r5hhlf6mi445bsg8sf1f68lrn', '37.111.239.8', '1696183920', '__ci_last_regenerate|i:1696183920;'), ('rbatplh081g531us8mdvgtsiko7pdhbc', '37.111.239.8', '1696183924', '__ci_last_regenerate|i:1696183924;'), ('7e2h24srnf6m0eiiuaq2h9kpmohcqlta', '37.111.239.8', '1696183925', '__ci_last_regenerate|i:1696183925;'), ('9psv6nl0ba99hngqf2abh8lgbdit8alk', '37.111.239.8', '1696183925', '__ci_last_regenerate|i:1696183925;'), ('508nhh0im743f5arfovkun7qq3ue2aen', '37.111.239.8', '1696183925', '__ci_last_regenerate|i:1696183925;'), ('9i1lqnms3lrq4ujg2ji7lfqfcfk3haoj', '37.111.239.8', '1696183925', '__ci_last_regenerate|i:1696183925;'), ('apm65docug3s76gtc1scmstpp8qrvfo3', '37.111.239.8', '1696183925', '__ci_last_regenerate|i:1696183925;'), ('0r7kgm0c5s7mbv5df0784tddh32mta4p', '37.111.239.8', '1696183925', '__ci_last_regenerate|i:1696183925;'), ('c7rou3dfrn1e8ok45nomrb1oepeenvn6', '37.111.239.8', '1696183925', '__ci_last_regenerate|i:1696183925;'), ('hnlojbn81hlk8ap9ciphgj377j4hp6fa', '37.111.239.8', '1696183931', '__ci_last_regenerate|i:1696183931;'), ('o7oj4qc2mbvbna6cdrpm1sel8dpheher', '37.111.239.8', '1696183931', '__ci_last_regenerate|i:1696183931;'), ('mb9094nsetrkdseue4tmha2e9te3quu8', '37.111.239.8', '1696183931', '__ci_last_regenerate|i:1696183931;'), ('l230o04ssem6vaeo83qlep4bms2d7ad6', '37.111.239.8', '1696183931', '__ci_last_regenerate|i:1696183931;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('siceah1cl9q8s184ak5nubqpm1l7l5of', '37.111.239.8', '1696183934', '__ci_last_regenerate|i:1696183934;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('3ckbqdh0u7noqm8624j6bubl3jehi1hm', '37.111.239.8', '1696183934', '__ci_last_regenerate|i:1696183934;'), ('qvngj74iottj5dtots8t3ami8b9ufl3u', '37.111.239.8', '1696183934', '__ci_last_regenerate|i:1696183934;'), ('n2uk0lhmbp3m5rrv1hujbjef1674rogq', '37.111.239.8', '1696183934', '__ci_last_regenerate|i:1696183934;'), ('uqdnnvh2okbclmjkj8r5kvh4cakrimp1', '37.111.239.8', '1696186129', '__ci_last_regenerate|i:1696183937;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1696227213;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('n6s9jno3vu8hf0u2p0ikauftol8q68tg', '37.111.239.8', '1696183967', '__ci_last_regenerate|i:1696183967;'), ('44099s6qh3fmu39geqfc0s2v1bqo7gk4', '37.111.239.8', '1696183967', '__ci_last_regenerate|i:1696183967;'), ('htv49o1b7nnj9uj029d6j2qft76tiscd', '37.111.239.8', '1696183968', '__ci_last_regenerate|i:1696183968;'), ('nv1mu5jom2mnp63g9l1ps9sgts1so0k4', '37.111.239.8', '1696183968', '__ci_last_regenerate|i:1696183968;'), ('mteeq6jbpef0dhfq9jqpssqrbn0bf6rf', '37.111.239.8', '1696183968', '__ci_last_regenerate|i:1696183968;'), ('2lhvqs9n7mlt988gs476lfmqf0cibems', '37.111.239.8', '1696183968', '__ci_last_regenerate|i:1696183968;'), ('10bcbvbc86gebj79amoh71ekhqfrm2e2', '37.111.239.8', '1696183968', '__ci_last_regenerate|i:1696183968;'), ('dj28e0uft2p4frq83urt4ml6cbr5bnfl', '37.111.239.8', '1696183969', '__ci_last_regenerate|i:1696183969;'), ('8d4cbug1vd7k3i8u01je2pupokrvkq28', '37.111.239.8', '1696183972', '__ci_last_regenerate|i:1696183972;'), ('jmlpo23k8usca7gbv94i9fje468v5jup', '37.111.239.8', '1696183973', '__ci_last_regenerate|i:1696183973;'), ('eo8bsgff4q49qe68hen4kmtqj90ij2jv', '37.111.239.8', '1696183982', '__ci_last_regenerate|i:1696183982;'), ('refb2repl32tcskr26u00jo2okr6bt6p', '37.111.239.8', '1696183982', '__ci_last_regenerate|i:1696183982;'), ('88m1cb7b54rpdqe3jf203d07pk0b95ol', '37.111.239.8', '1696183982', '__ci_last_regenerate|i:1696183982;'), ('k6o214vu0h7s6f9ffs93fa0au9anu2f9', '37.111.239.8', '1696183982', '__ci_last_regenerate|i:1696183982;'), ('2g8iqpei2vmhf1sr49s8avvmnbui5hvc', '37.111.239.8', '1696183982', '__ci_last_regenerate|i:1696183982;'), ('1lecdilf62a33bum0m9kvpn4hm5h1p0s', '37.111.239.8', '1696183982', '__ci_last_regenerate|i:1696183982;'), ('aol7r213nve9eiari2vqugqpqkapbdk1', '37.111.239.8', '1696183983', '__ci_last_regenerate|i:1696183983;'), ('8rmhab9hup89j3mgkgh73bbco60hilpv', '37.111.239.8', '1696183983', '__ci_last_regenerate|i:1696183983;'), ('8m2ss7flrmk6t3oecub0rht03eou2a6h', '37.111.239.8', '1696183983', '__ci_last_regenerate|i:1696183983;'), ('int43k68pdiiqahscgcf012cbtcpb345', '37.111.239.8', '1696183983', '__ci_last_regenerate|i:1696183983;'), ('n7v98cln22g86di0iicq8ueee114rj5b', '37.111.239.8', '1696183986', '__ci_last_regenerate|i:1696183986;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('nuh3ppc93so53vg1i3pvu0edaebnu4od', '37.111.239.8', '1696183986', '__ci_last_regenerate|i:1696183986;'), ('hhfmqe82vktqa7669p4esc07pfl9d404', '37.111.239.8', '1696183986', '__ci_last_regenerate|i:1696183986;'), ('5q6a77m28vgs6m9hj7p7mo9n6tmbpuoi', '37.111.239.8', '1696183986', '__ci_last_regenerate|i:1696183986;'), ('q7ptqmvh6i6pe30uaaqu8v8bmtb26b6t', '37.111.239.8', '1696183996', '__ci_last_regenerate|i:1696183996;'), ('4gk8f5m1m5h5fm1a70avp1ii0jv77nah', '37.111.239.8', '1696184003', '__ci_last_regenerate|i:1696184003;'), ('me7306l5kn9p7cpm39dh9lu5fm208bvh', '37.111.239.8', '1696184004', '__ci_last_regenerate|i:1696184004;'), ('0epn5j3j8uq7cthfsdp4movv685skelg', '37.111.239.8', '1696184004', '__ci_last_regenerate|i:1696184004;'), ('k4kfb4vi45287kkvn667htu5q5ekkqn5', '37.111.239.8', '1696184004', '__ci_last_regenerate|i:1696184004;'), ('dd4n0iubkrho6o5u28uqqf6rm6dh75tu', '37.111.239.8', '1696184004', '__ci_last_regenerate|i:1696184004;'), ('k15te8n4h4uetfa3g4c16v5pef7g6t2v', '37.111.239.8', '1696184004', '__ci_last_regenerate|i:1696184004;'), ('vj3ohcrao96bj86vf6on63dmme32ohbd', '37.111.239.8', '1696184004', '__ci_last_regenerate|i:1696184004;'), ('v2a7riubboe9srfnhsb0llo958j5oi2n', '37.111.239.8', '1696184004', '__ci_last_regenerate|i:1696184004;'), ('tqplbra5vu3elecqbvt4uflptu5cvorl', '37.111.239.8', '1696184006', '__ci_last_regenerate|i:1696184006;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('l9hk3slekusdtk62e1qbombt4v08iahk', '37.111.239.8', '1696184006', '__ci_last_regenerate|i:1696184006;'), ('v71ebdje0bumms85nvl2ch0u5evlv1qg', '37.111.239.8', '1696184006', '__ci_last_regenerate|i:1696184006;'), ('ob8qpqo0c8n7akg4vloui5ihgaeaciob', '37.111.239.8', '1696184006', '__ci_last_regenerate|i:1696184006;'), ('c2gqe085ievhid6tir98k6ld3a3nobip', '37.111.239.8', '1696184011', '__ci_last_regenerate|i:1696184011;'), ('3rmoof67mfh21fcnrck8aesfiion69v6', '37.111.239.8', '1696184011', '__ci_last_regenerate|i:1696184011;'), ('l6efjou3o06daqdqu8j8pfqju0nhjctt', '37.111.239.8', '1696184011', '__ci_last_regenerate|i:1696184011;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('kls85qs8jvg44uj9c93eeuj0h8600fc7', '37.111.239.8', '1696184011', '__ci_last_regenerate|i:1696184011;'), ('vaplb0p1e9auoujb051n44j69jl34lso', '37.111.239.8', '1696184014', '__ci_last_regenerate|i:1696184014;'), ('d0ncs3bv67ub219d3v27rf9lcmdfes4v', '37.111.239.8', '1696184015', '__ci_last_regenerate|i:1696184015;'), ('6rcvhiem3tp31hocp0nqfk3b4cl36c5g', '37.111.239.8', '1696184015', '__ci_last_regenerate|i:1696184015;'), ('ssba2cvf1l38o263g27i2rpquc808n87', '37.111.239.8', '1696184015', '__ci_last_regenerate|i:1696184015;'), ('s8hubpoodiop91knaloul5rttrhi6v10', '37.111.239.8', '1696184015', '__ci_last_regenerate|i:1696184015;'), ('64tgisui5v9sdgnf82lls39mv8g8sogj', '37.111.239.8', '1696184020', '__ci_last_regenerate|i:1696184020;'), ('eahd7jhr4j15ce1a1tn7qteql3ikalvo', '37.111.239.8', '1696184028', '__ci_last_regenerate|i:1696184028;'), ('c1fctk24pfvs0bi42ebfqgovdvqqjb24', '37.111.239.8', '1696184028', '__ci_last_regenerate|i:1696184028;'), ('oiaf67t040935eq5o1vrgpdt5rtbca35', '37.111.239.8', '1696184029', '__ci_last_regenerate|i:1696184029;'), ('jmtdpoo77q0mhseq5c9kcknn7e3e0kcn', '37.111.239.8', '1696184029', '__ci_last_regenerate|i:1696184029;'), ('cso5bhkjmrvaoshsb0bvrlvv2dj8712r', '37.111.239.8', '1696184029', '__ci_last_regenerate|i:1696184029;'), ('k9681niibqanj18efarskeqi8ficnkad', '37.111.239.8', '1696184029', '__ci_last_regenerate|i:1696184029;'), ('0nus6tkvb9kb8s8kvq1s6mc07radqc1a', '37.111.239.8', '1696184029', '__ci_last_regenerate|i:1696184029;'), ('2uvoj639v3n5p42mb06cvpsakfpmucl2', '37.111.239.8', '1696184030', '__ci_last_regenerate|i:1696184030;'), ('mbjcevkn48eh8iptfmhpkblevkfvd3od', '37.111.239.8', '1696184056', '__ci_last_regenerate|i:1696184056;'), ('t126ehhf7trcs3ui8dnrfp8tk2jqbrba', '37.111.239.8', '1696184060', '__ci_last_regenerate|i:1696184060;'), ('qft4ms9p3t8f5iqokidp7etr70bd2q62', '37.111.239.8', '1696184060', '__ci_last_regenerate|i:1696184060;'), ('jmra5imuad62i6q9c8236o7u0aibuhnv', '37.111.239.8', '1696184060', '__ci_last_regenerate|i:1696184060;'), ('qjnnrrb4pt4g5di3m303mmequa4d52hf', '37.111.239.8', '1696184060', '__ci_last_regenerate|i:1696184060;'), ('t5tgbrl0rqj5faj4hvhum36s1omupn7l', '37.111.239.8', '1696184060', '__ci_last_regenerate|i:1696184060;'), ('irkhh2i6ta6gdi6aac6qu91b37128ckf', '37.111.239.8', '1696184060', '__ci_last_regenerate|i:1696184060;'), ('jchvt4gs40r5aqm4f6qs0tssdd5t6bgf', '37.111.239.8', '1696184061', '__ci_last_regenerate|i:1696184061;'), ('bn1tthb0v92gpbkghepgoidt5m9hb9d0', '37.111.239.8', '1696184072', '__ci_last_regenerate|i:1696184072;'), ('ni9mgavvat501co4u6s35g5t1k97uk3k', '37.111.239.8', '1696184076', '__ci_last_regenerate|i:1696184076;'), ('d6tqdnq1es81pvv2a864vjr85bbm13cl', '37.111.239.8', '1696184076', '__ci_last_regenerate|i:1696184076;'), ('6plfq7ld9u53fj6uvr1r9qqnusmn7ptp', '37.111.239.8', '1696184076', '__ci_last_regenerate|i:1696184076;'), ('ee56rg7i5vfi70cg9bs69k8iem6r8n9t', '37.111.239.8', '1696184076', '__ci_last_regenerate|i:1696184076;'), ('3ijs91fohdjh8qa89f845naf6871979r', '37.111.239.8', '1696184076', '__ci_last_regenerate|i:1696184076;'), ('918rl1pvrpbri4i56johhm5be2thmch5', '37.111.239.8', '1696184076', '__ci_last_regenerate|i:1696184076;'), ('lv9v9lf0ucqivdp2ca5q1los3atmp330', '37.111.239.8', '1696184077', '__ci_last_regenerate|i:1696184077;'), ('vi3pttbmno6r067j6kjli78ecc727bse', '37.111.239.8', '1696184107', '__ci_last_regenerate|i:1696184107;'), ('f0qahc0pv48t93sedepe9unnktss0fgh', '37.111.239.8', '1696184111', '__ci_last_regenerate|i:1696184111;'), ('tgilpqhf04emc8oga1sha07nrj68i49v', '37.111.239.8', '1696184111', '__ci_last_regenerate|i:1696184111;'), ('j4440v9drem7ke0d5tvi0luphbgju3e7', '37.111.239.8', '1696184111', '__ci_last_regenerate|i:1696184111;'), ('k9ua264as1u7dtnptimvei9qkqosrn93', '37.111.239.8', '1696184111', '__ci_last_regenerate|i:1696184111;'), ('9uiiov5m8fpu6jfhome55j8hffre8soo', '37.111.239.8', '1696184111', '__ci_last_regenerate|i:1696184111;'), ('r40tns2kfeqqbikpj43ngp3kjcffm8i8', '37.111.239.8', '1696184111', '__ci_last_regenerate|i:1696184111;'), ('6sjiuh2g9ehhpj01orqcmntod6jbafjq', '37.111.239.8', '1696184111', '__ci_last_regenerate|i:1696184111;'), ('bu9uuosh090n2ncro1b9bd4h403iodsm', '37.111.239.8', '1696184215', '__ci_last_regenerate|i:1696184215;'), ('50rjnhoekjq01i1nicqqhasjf40pfl2j', '103.67.156.35', '1696184477', '__ci_last_regenerate|i:1696184477;'), ('e00jr15dtcdp0hjb56jkvp2nrv3oo09c', '103.67.156.35', '1696184477', '__ci_last_regenerate|i:1696184477;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('5r7kj5ekekjk9j7dvi7e3iqhrchjk58l', '103.67.156.35', '1696184478', '__ci_last_regenerate|i:1696184478;'), ('654v90lrmg6h4i43ceqqe0pr9dapp3j4', '37.111.239.8', '1696185895', '__ci_last_regenerate|i:1696185895;'), ('e214mqrq3re9eriiipdcctq86d5olo53', '37.111.239.8', '1696185895', '__ci_last_regenerate|i:1696185895;'), ('ounano0qam44b66q3elmubabpl4vv9ci', '37.111.239.8', '1696185895', '__ci_last_regenerate|i:1696185895;'), ('chnpo6co4bie8j4iqgdeci0cnuct6s7t', '37.111.239.8', '1696185895', '__ci_last_regenerate|i:1696185895;'), ('lubl0mt268tc08s6e4bctdh7l1kukle6', '37.111.239.8', '1696185895', '__ci_last_regenerate|i:1696185895;'), ('5tvaudl4ucd28rtuaggc6ba54s1obaiu', '37.111.239.8', '1696185895', '__ci_last_regenerate|i:1696185895;'), ('59pphk7hn9ijqi831ft6deelcv5q6h9k', '37.111.239.8', '1696186006', '__ci_last_regenerate|i:1696186006;'), ('6g7oj4ftoc11t4bag748v8uj1vvgps7a', '37.111.239.8', '1696186006', '__ci_last_regenerate|i:1696186006;'), ('k44r97cr6qqi89a0jpmg98bt9lh2ptuu', '37.111.239.8', '1696186006', '__ci_last_regenerate|i:1696186006;'), ('dmku6a7m7v81q2820j2i648h914a087f', '37.111.239.8', '1696186006', '__ci_last_regenerate|i:1696186006;'), ('r7k4ee19n462qcr3m5ksvd770nm9vfnj', '37.111.239.8', '1696186006', '__ci_last_regenerate|i:1696186006;'), ('hmidnjm7r9r8hel1cv7kpdopcuvu7epu', '37.111.239.8', '1696186010', '__ci_last_regenerate|i:1696186010;'), ('j1qdngejfnmd6flcstkrrn3popac4vs6', '37.111.239.8', '1696186010', '__ci_last_regenerate|i:1696186010;'), ('g17k10c93um5nkos4t3qhl2la6spsjnu', '37.111.239.8', '1696186011', '__ci_last_regenerate|i:1696186011;'), ('cu05vn9qf98amvc9e48365ed1jk23vkn', '37.111.239.8', '1696186011', '__ci_last_regenerate|i:1696186011;'), ('11ub9ttqbihmijfu516im11ibeqinffv', '37.111.239.8', '1696186011', '__ci_last_regenerate|i:1696186011;'), ('aoj26nul4vfgpg85fkjbiv2fl0t5597s', '37.111.239.8', '1696186011', '__ci_last_regenerate|i:1696186011;'), ('ololovanht0d91ohhn8ued6iqkdkdf40', '37.111.239.8', '1696186011', '__ci_last_regenerate|i:1696186011;'), ('8u7l3li45cb0dhan0j0dllitp5nr9na5', '37.111.239.8', '1696186011', '__ci_last_regenerate|i:1696186011;'), ('9hqn90s6o71e06f2vo5kta1nr4k0r5ng', '37.111.239.8', '1696186119', '__ci_last_regenerate|i:1696186119;'), ('140ohd5c0f06mh5qj8rgjdskiloil689', '37.111.239.8', '1696186123', '__ci_last_regenerate|i:1696186123;'), ('5iof2av2g3gnn7klua1ibum0ohpgtpf2', '37.111.239.8', '1696186123', '__ci_last_regenerate|i:1696186123;'), ('fs6p97vqplrq6nfuqn2q1i6h5clbdr2a', '37.111.239.8', '1696186123', '__ci_last_regenerate|i:1696186123;'), ('dbof0stscis0kt7fc2sjsgr66o81f8e0', '37.111.239.8', '1696186123', '__ci_last_regenerate|i:1696186123;'), ('llujqps5opnkulfgg3d1f0vslqic3frs', '37.111.239.8', '1696186123', '__ci_last_regenerate|i:1696186123;'), ('21vu3dtdilnh4537jbbeu3fequ77f0ka', '37.111.239.8', '1696186123', '__ci_last_regenerate|i:1696186123;'), ('5lohevole6071o6m6m2vl209uvb7rav6', '37.111.239.8', '1696186124', '__ci_last_regenerate|i:1696186124;'), ('ioscqohgbvrtceiuel0hqvee2mfg6nih', '37.111.239.8', '1696186128', '__ci_last_regenerate|i:1696186128;'), ('4f4ba8ca4725qf1anq91cluh44q6kga5', '103.67.156.35', '1696186340', '__ci_last_regenerate|i:1696186340;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('9t772f84chpfkb7vunanls4guq8vt14j', '103.67.156.35', '1696186341', '__ci_last_regenerate|i:1696186341;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('nfvopc6f8lmhai8c2ec44akt9sf5vh6g', '37.111.239.8', '1696186382', '__ci_last_regenerate|i:1696186381;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('rqlptaav10a459qprgok14in9tgitc1j', '37.111.239.8', '1696186382', '__ci_last_regenerate|i:1696186382;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('bdtodpmn56g1gc4j5lqpmu55ebpt82n6', '37.111.239.8', '1696188794', '__ci_last_regenerate|i:1696186391;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1697050429;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('6789bku5kdcsb43ttn9dsnt7p9bctr5t', '103.67.156.35', '1696186837', '__ci_last_regenerate|i:1696186837;'), ('aa1iqfgflb7m08iv1bfb1878pm1qjdgg', '103.67.156.35', '1696186838', '__ci_last_regenerate|i:1696186838;'), ('q67414tu6va18vmcehltcse9gl9cf52i', '103.67.156.35', '1696186838', '__ci_last_regenerate|i:1696186838;'), ('erfqtc0p9d3shkg11rdusv2t25c5j04l', '103.67.156.35', '1696186838', '__ci_last_regenerate|i:1696186838;'), ('g9i7ogua9fmkqfcg91tr5crb1aaq1bmr', '103.67.156.35', '1696186838', '__ci_last_regenerate|i:1696186838;'), ('4pkt7shh1t16s0o4sbgosf1nok71s7r9', '103.67.156.35', '1696186838', '__ci_last_regenerate|i:1696186838;'), ('eavf5ofb539eskg8qul1e8c28jvfse37', '103.67.156.35', '1696186838', '__ci_last_regenerate|i:1696186838;'), ('bjc5f4v7all81s11948i5pasfhekin9g', '103.67.156.35', '1696186838', '__ci_last_regenerate|i:1696186838;'), ('2sabedcvsrdbtp90j2sb2r67s5d90p69', '212.70.118.68', '1696193082', '__ci_last_regenerate|i:1696193082;'), ('u6i2hcoljripda4dd05u8f8rvquues5p', '212.70.118.68', '1696193085', '__ci_last_regenerate|i:1696193085;'), ('80frt6delu0849rvn7f6nhasi5mn1rre', '212.70.118.68', '1696193085', '__ci_last_regenerate|i:1696193085;'), ('57hc0685es0ke8u5qergqb2qura5dd0p', '212.70.118.68', '1696193085', '__ci_last_regenerate|i:1696193085;'), ('kmed5ma4aupfqmil68e8ci4fvk5uin7b', '212.70.118.68', '1696193085', '__ci_last_regenerate|i:1696193085;'), ('no4onl6d8ndbgdt1qg1bajc481f6mac2', '212.70.118.68', '1696193085', '__ci_last_regenerate|i:1696193085;'), ('65mo3mgt8jmd3kgim2ns8j56gnkeeed4', '212.70.118.68', '1696193085', '__ci_last_regenerate|i:1696193085;'), ('72dsgia4o7muk1s42s6ftk0djl2bmrmc', '212.70.118.68', '1696193085', '__ci_last_regenerate|i:1696193085;'), ('so42nfflfe5gck86c6ii1i48m1nulefj', '212.70.118.68', '1696193104', '__ci_last_regenerate|i:1696193104;'), ('fqbj4nc01rkrk7ga707s2jf12a5gllkn', '212.70.118.68', '1696193105', '__ci_last_regenerate|i:1696193105;'), ('30bq6mos3t9lo45s2kq95b2is0ghe973', '212.70.118.68', '1696193105', '__ci_last_regenerate|i:1696193105;'), ('qd1nq89197e2adf96vq7r2fiqeqbu87v', '212.70.118.68', '1696193105', '__ci_last_regenerate|i:1696193105;'), ('7ssdacifb984q8tbotaviu07bfi8llqs', '212.70.118.68', '1696193106', '__ci_last_regenerate|i:1696193106;'), ('43qrclrpfnfsv49ucd31p0ifjcv0lguo', '212.70.118.68', '1696193106', '__ci_last_regenerate|i:1696193106;'), ('vrvp34n64r2ujmia4pt7vpbad6kpr30m', '212.70.118.68', '1696193106', '__ci_last_regenerate|i:1696193106;'), ('nvf9s1bdclhfln1umc2f5rmhs8u13mdr', '212.70.118.68', '1696193106', '__ci_last_regenerate|i:1696193106;'), ('blcg34iftqjj04k967bcov5d62a078s0', '212.70.118.68', '1696193108', '__ci_last_regenerate|i:1696193108;'), ('1ilgfa1maki24tdl8q11qoi96ne0u0kt', '212.70.118.68', '1696193108', '__ci_last_regenerate|i:1696193108;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('jnko1rjjfe1j8d3f3fmb69u93umbset4', '212.70.118.68', '1696193108', '__ci_last_regenerate|i:1696193108;'), ('lbjj1f6ev9oiu2ppo6sbnegbjbqnv3r9', '212.70.118.68', '1696193140', '__ci_last_regenerate|i:1696193127;cart_items|a:0:{}language|s:7:\"english\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('j11uvi3r9eoav2188joi2o5pj0m9vfsv', '212.70.118.68', '1696193129', '__ci_last_regenerate|i:1696193129;'), ('83nn4jla8mbbpcr90n9rs4ol0ud4qugg', '212.70.118.68', '1696193129', '__ci_last_regenerate|i:1696193129;'), ('530t554msrnc07oc4mtehqjk9ri55vsb', '212.70.118.68', '1696193129', '__ci_last_regenerate|i:1696193129;'), ('gumv749bkpviqh8egolh3d7ko6ta881d', '212.70.118.68', '1696193129', '__ci_last_regenerate|i:1696193129;'), ('g6bkacusqne5d6hqt0vt57j97if0lkhg', '212.70.118.68', '1696193129', '__ci_last_regenerate|i:1696193129;'), ('5drhp3djnv2ua1a9uflqv4dd4g9lo14v', '212.70.118.68', '1696193129', '__ci_last_regenerate|i:1696193129;'), ('dtocb8o25622rgh51q3ib5kaqm7fe12q', '212.70.118.68', '1696193134', '__ci_last_regenerate|i:1696193134;'), ('gr0siv3pdnub5al4k3bep0iskdqs1edf', '212.70.118.68', '1696193134', '__ci_last_regenerate|i:1696193134;'), ('j6c63nq9ko9vn02gg5d9pcgcjuftfj27', '212.70.118.68', '1696193134', '__ci_last_regenerate|i:1696193134;'), ('gsgjqode7sjsr7qu0a3hsibgtbnkqjs9', '212.70.118.68', '1696193134', '__ci_last_regenerate|i:1696193134;'), ('q765bcngdskjm1f5i8ojmv8mnbpm9a8e', '212.70.118.68', '1696193134', '__ci_last_regenerate|i:1696193134;'), ('ubsp7qlukdreald77466js2h1vo0u9tg', '212.70.118.68', '1696193134', '__ci_last_regenerate|i:1696193134;'), ('fnmrgvqondgitqtau6npdhbttka1ijqv', '212.70.118.68', '1696193135', '__ci_last_regenerate|i:1696193135;'), ('cdbp90l7b4gbbchijqpn3nm53kth72js', '212.70.118.68', '1696193135', '__ci_last_regenerate|i:1696193135;'), ('in5o5iqatb6vn8mor1i4oo4phj86kdnl', '212.70.118.68', '1696193135', '__ci_last_regenerate|i:1696193135;'), ('kt66le1ial9uc5lhesmgere0d5amu06f', '212.70.118.68', '1696193135', '__ci_last_regenerate|i:1696193135;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('n0rlo3gqm01fomurtkcvkc75vkqs3n66', '212.70.118.68', '1696193146', '__ci_last_regenerate|i:1696193146;'), ('tuv5pnra0plojebodif1jtrdlqil2k7c', '212.70.118.68', '1696193146', '__ci_last_regenerate|i:1696193146;'), ('1jkfq7o75g8ht7bo7c043ff96b9o3hha', '212.70.118.68', '1696193147', '__ci_last_regenerate|i:1696193147;'), ('lm4ju6fmkq2opffabrtolnst8ts4kl4s', '212.70.118.68', '1696193147', '__ci_last_regenerate|i:1696193147;'), ('2en0hfdckmstn7787gp43le26k7lhp36', '212.70.118.68', '1696193147', '__ci_last_regenerate|i:1696193147;'), ('ludt48obfoel26tsma081mh72js2f5tq', '212.70.118.68', '1696193147', '__ci_last_regenerate|i:1696193147;'), ('0eqom9uu7svch4pm5p1c9872n3gerf5v', '212.70.118.68', '1696193147', '__ci_last_regenerate|i:1696193147;'), ('dbonspltse3fgfpnln5rd486avdtdt1e', '212.70.118.68', '1696193147', '__ci_last_regenerate|i:1696193147;'), ('ch8ql78mfsqg0m0rgk483m67evfbath6', '212.70.118.68', '1696193147', '__ci_last_regenerate|i:1696193147;'), ('jqs446rl9jg3hvutcv5o6u9v723l90qo', '212.70.118.68', '1696193147', '__ci_last_regenerate|i:1696193147;'), ('2th6751c6llc4fgcmqalliteoqguhibr', '212.70.118.68', '1696193147', '__ci_last_regenerate|i:1696193147;'), ('nj0g62bae02d8kgf6tis7u74de4li3vr', '103.67.156.35', '1696211931', '__ci_last_regenerate|i:1696211931;'), ('vnnodmofk0bruung9olu8o77mh4ejt9g', '103.67.156.35', '1696211935', '__ci_last_regenerate|i:1696211935;'), ('rhvsh8c9ujjt4qgvfgj9ea8m29sijskr', '103.67.156.35', '1696211935', '__ci_last_regenerate|i:1696211935;'), ('3l7q8cmn0pqkl25k13qeqhahih0p93u9', '103.67.156.35', '1696211935', '__ci_last_regenerate|i:1696211935;'), ('jj8cn3iq32bhv0p45meucnp402jvafh0', '103.67.156.35', '1696211935', '__ci_last_regenerate|i:1696211935;'), ('l2380fbhsq3osbbs5iehj419rh94kim8', '103.67.156.35', '1696211935', '__ci_last_regenerate|i:1696211935;'), ('h1pmtfign0hb4cbgskanefpflm06nr30', '103.67.156.35', '1696211935', '__ci_last_regenerate|i:1696211935;'), ('t418g572j29no5gl1novpeiishmne0lu', '103.67.156.35', '1696211935', '__ci_last_regenerate|i:1696211935;'), ('e582kjkggas8c9js4u9a45nfifq04ruk', '103.67.156.35', '1696211937', '__ci_last_regenerate|i:1696211937;'), ('hk3pb83en2blriiqcvv4jp6m9o4sfgs8', '103.67.156.35', '1696211937', '__ci_last_regenerate|i:1696211937;'), ('gnhn2le938j41rmldtujeesdbajtsi8q', '103.67.156.35', '1696211938', '__ci_last_regenerate|i:1696211938;'), ('bc4r9ps6f8fiesk3sc2lnfr96gf3mb3s', '103.67.156.35', '1696211938', '__ci_last_regenerate|i:1696211938;'), ('ht7j8n88ooc3r6e9t4t4npk260v6hp30', '103.67.156.35', '1696211938', '__ci_last_regenerate|i:1696211938;'), ('7c5mcsqlau1b2gn9khtq9ap4qn91bre3', '103.67.156.35', '1696211938', '__ci_last_regenerate|i:1696211938;'), ('jgavuj8jk5mp4duh209n0ud00on5tjvv', '103.67.156.35', '1696211938', '__ci_last_regenerate|i:1696211938;'), ('k067g0kdct601ifnqa6d7es49cev7388', '103.67.156.35', '1696211938', '__ci_last_regenerate|i:1696211938;'), ('k8m7oa214dl4lm9tadh0j6g58p40r00b', '103.67.156.35', '1696211939', '__ci_last_regenerate|i:1696211939;'), ('7of8t6fkioqtn1b52u945jbgjgpoep62', '103.67.156.35', '1696211939', '__ci_last_regenerate|i:1696211939;'), ('il7qhgoikl0pjgcbc003addq68fpht8s', '103.67.156.35', '1696211939', '__ci_last_regenerate|i:1696211939;'), ('vdmgjk3tegtqp58o5onpv12eai9q9o3k', '103.67.156.35', '1696211940', '__ci_last_regenerate|i:1696211940;'), ('jbnodhane98ocjosk9kfjplqga3pacbc', '103.67.156.35', '1696211940', '__ci_last_regenerate|i:1696211940;'), ('a47h2rg3nl9cgbus9a08l53umq8b22pd', '103.67.156.35', '1696211943', '__ci_last_regenerate|i:1696211943;'), ('pp8a3pps7nd1kh1g1oh15a5sminp2r06', '103.67.156.35', '1696211943', '__ci_last_regenerate|i:1696211943;'), ('31iuv5fbcc4061avipqsgd53lgfpvmab', '103.67.156.35', '1696211943', '__ci_last_regenerate|i:1696211943;'), ('n0fvfbghd2bf1a0gurqcbkbhpdfa1tce', '103.67.156.35', '1696211943', '__ci_last_regenerate|i:1696211943;'), ('sdhapqvi7v8uvgfq1lv40o7h8couctmq', '103.67.156.35', '1696211943', '__ci_last_regenerate|i:1696211943;'), ('o0hnjhm5p4aluu085hoi8vbgr1t0mu8d', '103.67.156.35', '1696211944', '__ci_last_regenerate|i:1696211944;'), ('jf9u3efsrmmuu4cjesne97an4o301nvq', '103.67.156.35', '1696211945', '__ci_last_regenerate|i:1696211945;'), ('58nbmegboj19lhl3pctpg1h0eg77mk24', '103.67.156.35', '1696211945', '__ci_last_regenerate|i:1696211945;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('itrponar5rj2mmqke5rum084n7mukeov', '103.67.156.35', '1696211946', '__ci_last_regenerate|i:1696211946;'), ('ragj5cktvjg5hvaq0rrgffv076rmf2o9', '103.67.156.35', '1696227863', '__ci_last_regenerate|i:1696227863;'), ('use6bji55ohf7nrhk7t6gr90kgljfk88', '103.67.156.35', '1696227866', '__ci_last_regenerate|i:1696227866;'), ('dfl6g64r41n8n7kcf08fpi8q6ic8se55', '103.67.156.35', '1696227866', '__ci_last_regenerate|i:1696227866;'), ('ebmm5vd1cu1mojgatl2t346hg3niiovc', '103.67.156.35', '1696227866', '__ci_last_regenerate|i:1696227866;'), ('8mqbh6bcj2g5uhu0a8loc7brppgipcdj', '103.67.156.35', '1696227866', '__ci_last_regenerate|i:1696227866;'), ('jpba5llddn8b4790j2a44l25kb0oj4m8', '103.67.156.35', '1696227866', '__ci_last_regenerate|i:1696227866;'), ('dgcesqheqavdks17739hv3hmhj9ut7ks', '103.67.156.35', '1696227866', '__ci_last_regenerate|i:1696227866;'), ('q3jb0f9ilclvtkh7q5gd3q7ck9tr3628', '103.67.156.35', '1696227867', '__ci_last_regenerate|i:1696227867;'), ('pikdnqhuj2l9llla2eippeo9b71qiu9q', '103.67.156.35', '1696227870', '__ci_last_regenerate|i:1696227870;'), ('bkva56nv50tg6bramf83901fqg9qotjd', '103.67.156.35', '1696227871', '__ci_last_regenerate|i:1696227871;'), ('ne4unjc7o4bg1rf5bjpksft07ntdtod2', '103.67.156.35', '1696227871', '__ci_last_regenerate|i:1696227871;'), ('3j8m3r6fs0udtvehutlqk5md18pdb7ar', '103.67.156.35', '1696227871', '__ci_last_regenerate|i:1696227871;'), ('pbarquqfjmb29c6eheti2oisjagescca', '103.67.156.35', '1696227871', '__ci_last_regenerate|i:1696227871;'), ('6v3idkhnv18vhovv5nc964ra0t7kjac9', '103.67.156.35', '1696227871', '__ci_last_regenerate|i:1696227871;'), ('00eb7c8vm1r36jt7c2ro6qp916v8arrf', '103.67.156.35', '1696227871', '__ci_last_regenerate|i:1696227871;'), ('kl24gh5e37bm4denlfo7f4v3b1cej4v7', '103.67.156.35', '1696227871', '__ci_last_regenerate|i:1696227871;'), ('7fpv1b9hsgodk72ksmf9u6h7vqg734p2', '103.67.156.35', '1696227941', '__ci_last_regenerate|i:1696227941;'), ('grigl5hu1u7o5dg1euql1u4jupd0g0db', '103.67.156.35', '1696228018', '__ci_last_regenerate|i:1696228018;'), ('f8ujkn5p1j53b6tacjg6oval0h4s3s3f', '103.67.156.35', '1696228018', '__ci_last_regenerate|i:1696228018;'), ('0cd8n74qrs08avnkqasp82dj66927o4h', '103.67.156.35', '1696228018', '__ci_last_regenerate|i:1696228018;'), ('0pdrmqclhh9hlg7i7fjok9oim227s5i4', '103.67.156.35', '1696228018', '__ci_last_regenerate|i:1696228018;'), ('ijsk4qt0l7b5uijt44qg0c2h4chvk961', '103.67.156.35', '1696228018', '__ci_last_regenerate|i:1696228018;'), ('hdsf901da39lfasur9qug64pi0s956o5', '103.67.156.35', '1696228018', '__ci_last_regenerate|i:1696228018;'), ('lckgibbfqbbp33tt4tavtirpfcri2u0f', '103.67.156.35', '1696228021', '__ci_last_regenerate|i:1696228021;'), ('1sca5rndli9035cv11aqthbj443pnjop', '103.67.156.35', '1696228021', '__ci_last_regenerate|i:1696228021;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('512ofnvnkapsbiplgfldpv4um8olbkfp', '103.67.156.35', '1696228022', '__ci_last_regenerate|i:1696228022;'), ('7s62mb9did6j06qdsml94bi6os8q1f0j', '103.67.156.35', '1696228043', '__ci_last_regenerate|i:1696228043;'), ('nosi5u9b2ehbc7eg30jb4rspgdm5e8le', '103.67.156.35', '1696228043', '__ci_last_regenerate|i:1696228043;'), ('7lpjmdfqo8ouh3et2mjllfnsaajav18c', '103.67.156.35', '1696228050', '__ci_last_regenerate|i:1696228050;'), ('ncfvlrr4nu635519i2qch32ifm91iqc9', '103.67.156.35', '1696228051', '__ci_last_regenerate|i:1696228051;'), ('ek4o0fgnnrd3b1hvlk45avkhc82t7ttf', '103.67.156.35', '1696228052', '__ci_last_regenerate|i:1696228052;'), ('p6i4elrmqrg74foios40eddcquov4ptk', '103.67.156.35', '1696228052', '__ci_last_regenerate|i:1696228052;'), ('8fark0dtoq3v0gvqccg6ucoluo7kae9f', '103.67.156.35', '1696228052', '__ci_last_regenerate|i:1696228052;'), ('9roebeq1fdlbl2j1v1a2ol17c1t5nv5p', '103.67.156.35', '1696228052', '__ci_last_regenerate|i:1696228052;'), ('efol3tisvql2mjm3nilo2htmkcmre0ae', '103.67.156.35', '1696228052', '__ci_last_regenerate|i:1696228052;'), ('o5kn62ukukqvbm5m9tle56tlcq5th637', '103.67.156.35', '1696228052', '__ci_last_regenerate|i:1696228052;'), ('scmufa67qalbt071okko61i8svgqbuoo', '103.67.156.35', '1696228054', '__ci_last_regenerate|i:1696228054;'), ('4h2r6ia4lkbf5bvmrqm0s94rfnoi0m61', '103.67.156.35', '1696228054', '__ci_last_regenerate|i:1696228054;'), ('mb176c17hl3hdgeukajofqtrl65tvhs9', '103.67.156.35', '1696228054', '__ci_last_regenerate|i:1696228054;'), ('vm6oqdf2h0t3prrcufv7ut2riqaet8m1', '103.67.156.35', '1696228054', '__ci_last_regenerate|i:1696228054;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('i4e4sjfut4f4rk87dtj7a6no1rk7ee0a', '103.67.156.35', '1696228057', '__ci_last_regenerate|i:1696228057;'), ('a8458as994h5i386on925m9maamc2i78', '103.67.156.35', '1696228066', '__ci_last_regenerate|i:1696228066;'), ('ibu33h9ctj8imjb62p1dp1ol833g01pi', '103.67.156.35', '1696228066', '__ci_last_regenerate|i:1696228066;'), ('oe8ealkr03jbnt0qj97rrb4uab48oqho', '103.67.156.35', '1696228066', '__ci_last_regenerate|i:1696228066;'), ('t7o1ekvgrvmm1h21l4fc5u3glhhtk3vf', '103.67.156.35', '1696228066', '__ci_last_regenerate|i:1696228066;'), ('89jt7f6dm9glj6en942v9qoahite347c', '103.67.156.35', '1696228067', '__ci_last_regenerate|i:1696228067;'), ('19qpq4nco60tc4bhhkpmg13un7tu6o02', '103.67.156.35', '1696228069', '__ci_last_regenerate|i:1696228069;'), ('pn8eeh9ugqslh76i7vhl8bke3romn938', '103.67.156.35', '1696228069', '__ci_last_regenerate|i:1696228069;'), ('lqupa7dbu9grudrsoh7cbge6pqhgeo2g', '103.67.156.35', '1696228403', '__ci_last_regenerate|i:1696228403;'), ('c7r4bp31hfptm3g61ui48diimro5onq0', '103.67.156.35', '1696228404', '__ci_last_regenerate|i:1696228404;'), ('3e6lnd8nsgmsaivngn92trdf9d5lom9m', '103.67.156.35', '1696228404', '__ci_last_regenerate|i:1696228404;'), ('bd0tghccuj3cgdgk7nuepqp7b1n5pnrj', '103.67.156.35', '1696228404', '__ci_last_regenerate|i:1696228404;'), ('04usnfn4avqvc06veaa86n7ei52td1uc', '103.67.156.35', '1696228404', '__ci_last_regenerate|i:1696228404;'), ('6krqgsu89fa91s3ekr0ps79fgr4ei6ee', '103.67.156.35', '1696228404', '__ci_last_regenerate|i:1696228404;'), ('jh83l09s759nl5rcfpiv61toobobtbep', '103.67.156.35', '1696228404', '__ci_last_regenerate|i:1696228404;'), ('8nca1idsh0dl8gfok6gmptgaev6ekfr4', '103.67.156.35', '1696228404', '__ci_last_regenerate|i:1696228404;'), ('boa7bm9e5v9s391g2f8k9rnq1rsnvtu7', '103.67.156.35', '1696228412', '__ci_last_regenerate|i:1696228412;'), ('nn7udifdtlmgce32dl2rug6kc4t71p30', '103.67.156.35', '1696228412', '__ci_last_regenerate|i:1696228412;'), ('cq9cpsmblin5bo6a9mrkn0ivple5q74e', '103.67.156.35', '1696228412', '__ci_last_regenerate|i:1696228412;'), ('0c4noggm3jgs2ml7jch14agmeea9m36q', '103.67.156.35', '1696228412', '__ci_last_regenerate|i:1696228412;'), ('h7ccr6h41bp2e5nv93rod01j7m7m42r8', '103.67.156.35', '1696228414', '__ci_last_regenerate|i:1696228414;'), ('8cvfqpabdis3fgbaq5jv5nnis4p0l737', '103.67.156.35', '1696228414', '__ci_last_regenerate|i:1696228414;'), ('jkpuj4ubgk96dopviaku382cu65ii178', '103.67.156.35', '1696228414', '__ci_last_regenerate|i:1696228414;'), ('n8cihjtvt3e9j478b95cto3eukt6pi9m', '103.67.156.35', '1696228414', '__ci_last_regenerate|i:1696228414;'), ('14fr0fsb767e7a83plerraqv3foklrc3', '103.67.156.35', '1696228414', '__ci_last_regenerate|i:1696228414;'), ('s3lnacncl50v74j6jci3ocq30frjmdtu', '103.67.156.35', '1696228414', '__ci_last_regenerate|i:1696228414;'), ('hrgqb9gis8la08bjt4doun6ln353qjbb', '103.67.156.35', '1696228567', '__ci_last_regenerate|i:1696228567;'), ('eiek8pufgo4qp220ju1ns3htad54v842', '103.67.156.35', '1696228567', '__ci_last_regenerate|i:1696228567;'), ('tchgtd58kfs7g93q5cs5fj0u058nrf6q', '103.67.156.35', '1696228567', '__ci_last_regenerate|i:1696228567;'), ('4te1o3i0ihl4noua1qrshnir4v9m3dk9', '103.67.156.35', '1696228567', '__ci_last_regenerate|i:1696228567;'), ('9u8ob7bn1racd0nnsau4jc90ofljidjv', '103.67.156.35', '1696228571', '__ci_last_regenerate|i:1696228571;'), ('ocdf6rkbich8itt0sldaek6k21kb7f4j', '103.67.156.35', '1696228571', '__ci_last_regenerate|i:1696228571;'), ('l9p7leqi3dm1a2k1f1ej44pa0aoo8mtd', '103.67.156.35', '1696228583', '__ci_last_regenerate|i:1696228583;'), ('bsnse1kl1rqvrb450b5gjrtqmftj562t', '103.67.156.35', '1696228583', '__ci_last_regenerate|i:1696228583;'), ('7i0ri5u382kbqt06ag3vp0bobf2kahkd', '103.67.156.35', '1696228583', '__ci_last_regenerate|i:1696228583;'), ('bl01h1lqbqktsjqc76u53tbccrn7v8os', '103.67.156.35', '1696228583', '__ci_last_regenerate|i:1696228583;'), ('0p762kp6gkpunioh5oo5btq8lp3kfn7e', '103.67.156.35', '1696228583', '__ci_last_regenerate|i:1696228583;'), ('bflsnefoh5n11gsqllhmvd5ers03m0ad', '103.67.156.35', '1696228584', '__ci_last_regenerate|i:1696228584;'), ('f9nolf9pg4prms0j15a36b60lacemgi0', '103.67.156.35', '1696228585', '__ci_last_regenerate|i:1696228585;'), ('06qac63avd6osvr65skqmdq89qt01vl7', '103.67.156.35', '1696228586', '__ci_last_regenerate|i:1696228586;'), ('7erlht36t41eqar363ugjd68mujdomch', '103.67.156.35', '1696228586', '__ci_last_regenerate|i:1696228586;'), ('eign33s1vkomg63dm8ee6cnjqtirv6jg', '103.67.156.35', '1696228586', '__ci_last_regenerate|i:1696228586;'), ('e74rt550rkiddlsc6n48cqvlud0kj3us', '103.67.156.35', '1696228586', '__ci_last_regenerate|i:1696228586;'), ('ih5npvk5sceie1mqnqinsino4c5n4e71', '103.67.156.35', '1696228586', '__ci_last_regenerate|i:1696228586;'), ('cli0jri0fufr736s1ok35ujceg7hmah3', '103.67.156.35', '1696228586', '__ci_last_regenerate|i:1696228586;'), ('dfvn17p43k9gl2tij3au3vmickm45365', '103.67.156.35', '1696228586', '__ci_last_regenerate|i:1696228586;'), ('s709v8gruoo6uarjf3dn8802ii16vf8m', '116.58.203.178', '1696306598', '__ci_last_regenerate|i:1696306598;'), ('6n8qlljk8f5mf3uq7a71ff7ttt3o677j', '116.58.203.178', '1696306601', '__ci_last_regenerate|i:1696306601;'), ('tj2opinpkjqmod9jpdbuhpmhss2icjq2', '116.58.203.178', '1696306601', '__ci_last_regenerate|i:1696306601;'), ('n2q7ijbvjikar5nqkg58hrnpgdbb2q87', '116.58.203.178', '1696306601', '__ci_last_regenerate|i:1696306601;'), ('ri47n3h4fopberd3qggragcjem5171cu', '116.58.203.178', '1696306601', '__ci_last_regenerate|i:1696306601;'), ('tnisjbeqf9lraege6h9ni3ooial05abh', '116.58.203.178', '1696306601', '__ci_last_regenerate|i:1696306601;'), ('s3l7f8k0u7v72tcb2gbk4skhki9lkksr', '116.58.203.178', '1696306601', '__ci_last_regenerate|i:1696306601;'), ('lghtir52gl51ir371q6shba74m0uf2gg', '116.58.203.178', '1696306602', '__ci_last_regenerate|i:1696306602;'), ('vlth6hdejrtuadilcuimr5s6kdft9n35', '116.58.203.178', '1696306611', '__ci_last_regenerate|i:1696306611;'), ('m8qn3oqb69420c4a36b8rs8ja8vnpsf0', '116.58.203.178', '1696306611', '__ci_last_regenerate|i:1696306611;'), ('ol0lutb280i7oa6321cirau3tffg27b8', '116.58.203.178', '1696306612', '__ci_last_regenerate|i:1696306612;'), ('cshntnbug4bejta13ufjj8oape8kpejg', '116.58.203.178', '1696306612', '__ci_last_regenerate|i:1696306612;'), ('s7r8amh5dre714f7u630jsasg1nhd86s', '116.58.203.178', '1696306612', '__ci_last_regenerate|i:1696306612;'), ('6jh7jvm6hem038vk0fdd1rjo5dgc84pg', '116.58.203.178', '1696306612', '__ci_last_regenerate|i:1696306612;'), ('m3etek43sfafdqp6515baeps4pc5jc7p', '116.58.203.178', '1696306612', '__ci_last_regenerate|i:1696306612;'), ('1olm3snuhb18h5etaom71lurm0q1ifvn', '116.58.203.178', '1696306612', '__ci_last_regenerate|i:1696306612;'), ('up721kltru55thhuf12ngn7lm0hlk7mv', '116.58.203.178', '1696306614', '__ci_last_regenerate|i:1696306614;'), ('5kn7qdpk44m7jdr32raketbmgq7bpaq5', '116.58.203.178', '1696306614', '__ci_last_regenerate|i:1696306614;'), ('r2nr1497qj76958igahi1en4hnmrjvf8', '116.58.203.178', '1696306614', '__ci_last_regenerate|i:1696306614;'), ('82u05d329jo9i4foptr7n9rmdo90fpvl', '116.58.203.178', '1696306614', '__ci_last_regenerate|i:1696306614;'), ('uf95lkrqnollrqiic29f93qvf54ghjf8', '116.58.203.178', '1696306614', '__ci_last_regenerate|i:1696306614;'), ('cs2915li8p9l612l0q4nrsnfsaoq8hhl', '116.58.203.178', '1696306614', '__ci_last_regenerate|i:1696306614;'), ('a24n72giev97oqiq31hnr1p7rpoeht2v', '116.58.203.178', '1696306616', '__ci_last_regenerate|i:1696306616;'), ('7hhjrbvl2cf3o987n4ask4v9hqpe0pgp', '116.58.203.178', '1696306616', '__ci_last_regenerate|i:1696306616;'), ('v6gpv05jjpn8ijm7sve2p7pgh30q14oh', '116.58.203.178', '1696306617', '__ci_last_regenerate|i:1696306617;'), ('cv4i534hh92k7c5um4l468sedapqg3gc', '116.58.203.178', '1696306617', '__ci_last_regenerate|i:1696306617;'), ('b3ua1erkue84ric75a54epqhdulrg5iq', '116.58.203.178', '1696306617', '__ci_last_regenerate|i:1696306617;'), ('gqkq932tqtvfs5ba6fap6vu4ms1h8jpt', '116.58.203.178', '1696306617', '__ci_last_regenerate|i:1696306617;'), ('j1jbi8a7bvts9cl9oahdvvv5gooq84c6', '116.58.203.178', '1696306617', '__ci_last_regenerate|i:1696306617;'), ('htue22irh4e4ue4fic1mo9bte0cbhv9g', '116.58.203.178', '1696306617', '__ci_last_regenerate|i:1696306617;'), ('ts4i07pathn8mdc3jhsm4ebkjr49ji84', '116.58.203.178', '1696306617', '__ci_last_regenerate|i:1696306617;'), ('gq3jcnn0dn5fn6cuordc3e9vvroqsvsl', '116.58.203.178', '1696306617', '__ci_last_regenerate|i:1696306617;'), ('q8htab9c95rao64tes9ol5uchla35d02', '116.58.203.178', '1696306618', '__ci_last_regenerate|i:1696306617;'), ('edmkeroa46fnrr5k88utq79bh3tfc255', '116.58.203.178', '1696306618', '__ci_last_regenerate|i:1696306618;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('hvivnmjbn6tnqorar46tf8nq2vih7pcd', '116.58.203.178', '1696306619', '__ci_last_regenerate|i:1696306619;'), ('6btbt73f113vichqtspn23p1b6k2t0l0', '116.58.203.178', '1696306803', '__ci_last_regenerate|i:1696306803;'), ('kh9otb0nrsdtdmqr3ncpvt133vqkic2t', '116.58.203.178', '1696306807', '__ci_last_regenerate|i:1696306807;'), ('ivdak6g5l7nv4ppj7eg2att17o9ivvjm', '116.58.203.178', '1696306807', '__ci_last_regenerate|i:1696306807;'), ('n7kos0gnv5mfjnv66qe04olv70pc1gl1', '116.58.203.178', '1696306807', '__ci_last_regenerate|i:1696306807;'), ('9bkrkteboskdr0eclj561diqqcnfh7pq', '116.58.203.178', '1696306807', '__ci_last_regenerate|i:1696306807;'), ('k23vjr208l5cmsmc2bsgcebqdfei6j9b', '116.58.203.178', '1696306807', '__ci_last_regenerate|i:1696306807;'), ('u64nensjq8cqhrf4rp8j714v6nj1qm2h', '116.58.203.178', '1696306807', '__ci_last_regenerate|i:1696306807;'), ('20jecc9l1i418ha5gj2lipijs9gkb7pm', '116.58.203.178', '1696306807', '__ci_last_regenerate|i:1696306807;'), ('e3psp0tq719sgainoidmfq8g984krgck', '116.58.203.178', '1696307540', '__ci_last_regenerate|i:1696307540;'), ('si5m677i5tv8acl490sik650cru30jbd', '116.58.203.178', '1696307544', '__ci_last_regenerate|i:1696307544;'), ('81tj22tujmcenedaan7k0mfs0u8u76m4', '116.58.203.178', '1696307545', '__ci_last_regenerate|i:1696307545;'), ('tb6khfkfds4c3ihriihb64oceghu7mtk', '116.58.203.178', '1696307546', '__ci_last_regenerate|i:1696307546;'), ('opf1ru7pgg7mbuugvamh43c3ts2di0f1', '116.58.203.178', '1696307546', '__ci_last_regenerate|i:1696307546;'), ('h8seb8luil49aj93f5bop7bjshelk4vb', '116.58.203.178', '1696307546', '__ci_last_regenerate|i:1696307546;'), ('c2skk73cj32qjft6fcri71kaadv50r39', '116.58.203.178', '1696307546', '__ci_last_regenerate|i:1696307546;'), ('2fe7lgb7dbnsqml7gkll7qjkcra4d5oq', '116.58.203.178', '1696307546', '__ci_last_regenerate|i:1696307546;'), ('u1lke0h41kek66tqkmiaekfqquthurqb', '116.58.203.178', '1696307546', '__ci_last_regenerate|i:1696307546;'), ('0tc5620oubp5l6uukk24etp4ummslch8', '116.58.203.178', '1696307694', '__ci_last_regenerate|i:1696307694;'), ('rbatlp1om845epgna4rcujj4k6jk0gdr', '116.58.203.178', '1696307907', '__ci_last_regenerate|i:1696307907;'), ('q5gehm81n6shobn4og93vkt459num6k0', '116.58.203.178', '1696307907', '__ci_last_regenerate|i:1696307907;'), ('emsmb2efdpfdlc1edlh5vd7mvqnbh8gq', '116.58.203.178', '1696307908', '__ci_last_regenerate|i:1696307908;'), ('0qo6bmqse1ca4vdnkrmg7p52hrca725j', '116.58.203.178', '1696307908', '__ci_last_regenerate|i:1696307908;'), ('hm779cqb36o4plup4022lgv7pu5fmo35', '116.58.203.178', '1696307908', '__ci_last_regenerate|i:1696307908;'), ('v3jk3t6it36q8abkrenprpf6fgf0o79m', '116.58.203.178', '1696307908', '__ci_last_regenerate|i:1696307908;'), ('ikn0kvui373hc7tf52r4echm4cbm9eu3', '116.58.203.178', '1696307908', '__ci_last_regenerate|i:1696307908;'), ('s1me40rm4bq9eg0b1fbmdatmb274haui', '116.58.203.178', '1696307908', '__ci_last_regenerate|i:1696307908;'), ('pqrlbu753u25eb0toua16qvdmsf9ubft', '116.58.203.178', '1696307910', '__ci_last_regenerate|i:1696307910;'), ('voah1cqtbehr26im3nrmt16sqs9nm9am', '116.58.203.178', '1696307911', '__ci_last_regenerate|i:1696307911;'), ('rurgfdr80pns6etqt8q0ngn3cr523p5q', '116.58.203.178', '1696307911', '__ci_last_regenerate|i:1696307911;'), ('nm9gevpe9emibbacp05hj40u9t0kebak', '116.58.203.178', '1696307911', '__ci_last_regenerate|i:1696307911;'), ('flr5ckvhs4fgsddb1ncc43os7dh2v5vf', '116.58.203.178', '1696307911', '__ci_last_regenerate|i:1696307911;'), ('eme50lgbdtdei0alntbo7gdv8k7jpiru', '116.58.203.178', '1696307911', '__ci_last_regenerate|i:1696307911;'), ('276fnatc6gl5q5erhll94pbafn26ilft', '116.58.203.178', '1696307911', '__ci_last_regenerate|i:1696307911;'), ('gdqfu62ugvoem22pqa26icm8273mnstn', '116.58.203.178', '1696307911', '__ci_last_regenerate|i:1696307911;'), ('8ngb1jalfbrvb2g41t7gflja80kbgfom', '116.58.203.178', '1696308422', '__ci_last_regenerate|i:1696308422;'), ('tjv8r0uq7gf377amukgkstgqms58q9fr', '116.58.203.178', '1696308426', '__ci_last_regenerate|i:1696308426;'), ('eeg5vq7venp6fvck7ghemrr410686qe3', '116.58.203.178', '1696308426', '__ci_last_regenerate|i:1696308426;'), ('928s0hieic8qrrd5b5v2s89akvmve52b', '116.58.203.178', '1696308426', '__ci_last_regenerate|i:1696308426;'), ('ods3nt2fe6lcm32al6dpfmmgh6qja2a4', '116.58.203.178', '1696308426', '__ci_last_regenerate|i:1696308426;'), ('g9ahqceq3kct5p8fcooniimoa60jn8v0', '116.58.203.178', '1696308426', '__ci_last_regenerate|i:1696308426;'), ('cgfh9a8mif6hpp6stb8op6eljc4ii1il', '116.58.203.178', '1696308426', '__ci_last_regenerate|i:1696308426;'), ('e3a0pn6u4cr70iqq9hbctamj5unvt517', '116.58.203.178', '1696308427', '__ci_last_regenerate|i:1696308427;'), ('8u5e8kf37a5djh8df8kugghq2eogmbbr', '116.58.203.178', '1696308613', '__ci_last_regenerate|i:1696308613;'), ('fj7klc4kj943eocib4kedgcebfkb15la', '116.58.203.178', '1696308613', '__ci_last_regenerate|i:1696308613;'), ('l5pl93cb0b9qetg0c390184tps51cqk8', '116.58.203.178', '1696308613', '__ci_last_regenerate|i:1696308613;'), ('70jg0bsdailebmkl83u5up39h7cne0m1', '116.58.203.178', '1696308614', '__ci_last_regenerate|i:1696308614;'), ('s82djepimb9ml6okc9t8t0p24a9mjmbb', '116.58.203.178', '1696308615', '__ci_last_regenerate|i:1696308615;'), ('br9j6oueu0f6t72tab0mgvlml8kfvm59', '116.58.203.178', '1696308615', '__ci_last_regenerate|i:1696308615;'), ('9jra2hdqmqfoft60vn5u22evmud5s01n', '103.67.156.140', '1696353967', '__ci_last_regenerate|i:1696353967;'), ('gsqm7a9v8a2frukv28ur1has1lcrtgdi', '103.67.156.140', '1696353969', '__ci_last_regenerate|i:1696353969;'), ('8hetv3goanjqvdk8t2t45fqgleom9g7a', '103.67.156.140', '1696353969', '__ci_last_regenerate|i:1696353969;'), ('pr3p67cvh56m6m710cokl6i5c00csbnq', '103.67.156.140', '1696353969', '__ci_last_regenerate|i:1696353969;'), ('gkd3av5j0c0sqlag35c6s8hr4gamtde7', '103.67.156.140', '1696353969', '__ci_last_regenerate|i:1696353969;'), ('2nt9oic4ost88jvku39i7hluc9m873gc', '103.67.156.140', '1696353969', '__ci_last_regenerate|i:1696353969;'), ('5jnmmt66v7d6eeu3mbidnsdtqt4a2b85', '103.67.156.140', '1696353969', '__ci_last_regenerate|i:1696353969;'), ('gfq752lhm15c3ft8odp77bde99e03l35', '103.67.156.140', '1696353970', '__ci_last_regenerate|i:1696353970;'), ('u7obnu0vbklj4fb8pivbbl48u6susb9t', '103.67.156.140', '1696354068', '__ci_last_regenerate|i:1696354068;'), ('22o2fvobhg36p3m4dhvcp14svnnh9d64', '103.67.156.140', '1696354072', '__ci_last_regenerate|i:1696354072;'), ('tfceqs0n253npbcjive0112b6aa87k9o', '103.67.156.140', '1696354072', '__ci_last_regenerate|i:1696354072;'), ('kdtecbj6d3asl1jqd01lqi3k71pi66nd', '103.67.156.140', '1696354072', '__ci_last_regenerate|i:1696354072;'), ('npuvu5ijfr42rsb77eej8kn2712i58fj', '103.67.156.140', '1696354072', '__ci_last_regenerate|i:1696354072;'), ('kep2i9jrcqjs792p9823reu5tm8vm2u8', '103.67.156.140', '1696354072', '__ci_last_regenerate|i:1696354072;'), ('bs2ra7sv09anaol22mp92mjkjet5os0k', '103.67.156.140', '1696354072', '__ci_last_regenerate|i:1696354072;'), ('sk330kufo62rdrt9h31i66bc6q77snhs', '103.67.156.140', '1696354072', '__ci_last_regenerate|i:1696354072;'), ('t92jrk8ilaseciddffnrpi9klqagfds6', '103.67.156.140', '1696354082', '__ci_last_regenerate|i:1696354082;'), ('mimmmqhi47qr3u7lkso43buv7rfis9hh', '103.67.156.140', '1696354084', '__ci_last_regenerate|i:1696354084;'), ('r9joqc0d1051qnsi85ggl9a9o4kffijq', '103.67.156.140', '1696354086', '__ci_last_regenerate|i:1696354086;'), ('go7cpspkh2n6vosuj1vef7puetuqprbh', '103.67.156.140', '1696354086', '__ci_last_regenerate|i:1696354086;'), ('buu28trn2fkaed3s5lsbqr1uf6dd8uv6', '103.67.156.140', '1696354086', '__ci_last_regenerate|i:1696354086;'), ('sl3mdom8f9le8r3kl05a0ligmfcob1ue', '103.67.156.140', '1696354086', '__ci_last_regenerate|i:1696354086;'), ('em1lpjsccbv5hlco235lqmseuduoojh1', '103.67.156.140', '1696354086', '__ci_last_regenerate|i:1696354086;'), ('emo43r67a6ddhhjum457bds3n9lti9a2', '103.67.156.140', '1696354086', '__ci_last_regenerate|i:1696354086;'), ('ij1g5lrt8t7p98ceq69adl62ochep3fe', '103.67.156.140', '1696354089', '__ci_last_regenerate|i:1696354089;'), ('fqvh1a7ul8glrv840g90b39jj00jkrk1', '103.67.156.140', '1696354089', '__ci_last_regenerate|i:1696354089;'), ('u5uf37k9g83skcnratv5evn20dkhlp24', '103.67.156.140', '1696354089', '__ci_last_regenerate|i:1696354089;'), ('nsttpbud9jdv3ejgteh58a7g65fdahct', '103.67.156.140', '1696354089', '__ci_last_regenerate|i:1696354089;'), ('33lqfiaeup6hsbupb6uje7oe1d6c62tg', '103.67.156.140', '1696354089', '__ci_last_regenerate|i:1696354089;'), ('ar2u1kfeu4gpvn73n1idek0a0g7tbr0g', '103.67.156.140', '1696354089', '__ci_last_regenerate|i:1696354089;'), ('d3cknisqs37q943n279tsi3sn6c90ep2', '103.67.156.140', '1696354091', '__ci_last_regenerate|i:1696354091;'), ('jhabl3ct1omb32c9ml02pt6aoe0n0tgd', '103.67.156.140', '1696354091', '__ci_last_regenerate|i:1696354091;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('sau72ukonk1eee5d01va1gcn7g0diiqf', '103.67.156.140', '1696354091', '__ci_last_regenerate|i:1696354091;'), ('8di0mk1uvquob8skurma7re2lugkf94l', '103.67.156.140', '1696354099', '__ci_last_regenerate|i:1696354099;'), ('qb294koqicep1efkhc65mo38g79m7d9q', '103.67.156.140', '1696354101', '__ci_last_regenerate|i:1696354101;'), ('23furnq0egmg2cid0lgiavs8ctagc824', '103.67.156.140', '1696354103', '__ci_last_regenerate|i:1696354103;'), ('3gincg8g51thkgnkphguaus7ktsjb5l3', '103.67.156.140', '1696354103', '__ci_last_regenerate|i:1696354103;'), ('dv99q8drj3l4sqns79bk28q5amamiqn2', '103.67.156.140', '1696354103', '__ci_last_regenerate|i:1696354103;'), ('m50l8u7rh6avjtch43m2u84odts9og5f', '103.67.156.140', '1696354103', '__ci_last_regenerate|i:1696354103;'), ('imoaads4n1kdra6mo4p1u9jmm5gjmi4l', '103.67.156.140', '1696354103', '__ci_last_regenerate|i:1696354103;'), ('30hc2cf66jp00mh4am1tajf86tfadm92', '103.67.156.140', '1696354103', '__ci_last_regenerate|i:1696354103;'), ('9q4npcq5vrmv9l42skjmk2mdbpdue1h5', '103.67.156.140', '1696354104', '__ci_last_regenerate|i:1696354104;'), ('ilt3trefgskbsrrg53jp0jeoak3osm22', '103.67.156.140', '1696354104', '__ci_last_regenerate|i:1696354104;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('d00puolrn5nat5qgnfq1n98laub7h8tn', '103.67.156.140', '1696354104', '__ci_last_regenerate|i:1696354104;'), ('f6f0cuirhabmo0aosifgu97ikq8ck4gf', '103.67.156.140', '1696354104', '__ci_last_regenerate|i:1696354104;'), ('imacgbiqm84k988bjim3gaa6ijrj549i', '103.67.156.140', '1696354107', '__ci_last_regenerate|i:1696354107;'), ('sabp5q93kg1me3i0qo5g9asafkpat6mr', '103.67.156.140', '1696354160', '__ci_last_regenerate|i:1696354160;'), ('6phk199kkosr8s4e8ad17vjg86fite07', '103.67.156.140', '1696354161', '__ci_last_regenerate|i:1696354161;'), ('h5irhb1gflb4js48q02a262ce33kjou6', '103.67.156.140', '1696354216', '__ci_last_regenerate|i:1696354216;'), ('b2a1r4k4m3c7ql5e7hnq64lclcci7a24', '103.67.156.140', '1696354220', '__ci_last_regenerate|i:1696354220;'), ('1e7e1qdthljj75utbpk2p3rg032u7nvk', '103.67.156.140', '1696354220', '__ci_last_regenerate|i:1696354220;'), ('0i1q8nt3voe3irhurcjc6hcqg2b0vnf9', '103.67.156.140', '1696354220', '__ci_last_regenerate|i:1696354220;'), ('seohof866hcphlvf284cavek8oil9g3e', '103.67.156.140', '1696354220', '__ci_last_regenerate|i:1696354220;'), ('tvskvb7rdosf9lrm4hvgdlnt9mpvpdpp', '103.67.156.140', '1696354221', '__ci_last_regenerate|i:1696354221;'), ('men478mdhd7cngqqjpr3mpu3dsff2r05', '103.67.156.140', '1696354221', '__ci_last_regenerate|i:1696354221;'), ('qqjh2mr821jboiq1ktl4rujdj617gm8e', '103.67.156.140', '1696354221', '__ci_last_regenerate|i:1696354221;'), ('9s813cv1q1f10nidjle0qlpae5ooo1mc', '103.67.156.140', '1696354221', '__ci_last_regenerate|i:1696354221;'), ('4uhdovvr5tv6m7tm71al4i8227aivtbi', '103.67.156.140', '1696354243', '__ci_last_regenerate|i:1696354243;'), ('jejarqgp4tfl5ms12m3kk73dj6lm3ttf', '103.67.156.140', '1696354314', '__ci_last_regenerate|i:1696354314;'), ('sqbsl1eljsuh3r9ctp8ave1tf65sbtfn', '103.67.156.140', '1696354317', '__ci_last_regenerate|i:1696354317;'), ('fgu6c1e2h3hi7upvc84f24scsid01560', '103.67.156.140', '1696354317', '__ci_last_regenerate|i:1696354317;'), ('g75f447akf6ol16auhpjcoslbe2hq6aj', '103.67.156.140', '1696354317', '__ci_last_regenerate|i:1696354317;'), ('247v31lf5ic3glo42f8nqmmviqdpcn18', '103.67.156.140', '1696354317', '__ci_last_regenerate|i:1696354317;'), ('9s490vrjgc7ch1l3jrkrl55d14gcqpt7', '103.67.156.140', '1696354317', '__ci_last_regenerate|i:1696354317;'), ('tbl3gro8ntb8fgd4u6dgu4bof05a2a1e', '103.67.156.140', '1696354317', '__ci_last_regenerate|i:1696354317;'), ('7348epkg8eedqh8rn39tpdoms7ajagdt', '103.67.156.140', '1696354318', '__ci_last_regenerate|i:1696354318;'), ('9skjojosrvnb8sosmhgor86ufe1ho0no', '103.67.156.140', '1696354324', '__ci_last_regenerate|i:1696354324;'), ('v8p0jnmen4dn8nrodtd33h59htkfmn7u', '103.67.156.140', '1696354325', '__ci_last_regenerate|i:1696354324;'), ('umj6s1b5diliocdck64nt4vs0ddrjjo7', '103.67.156.140', '1696354329', '__ci_last_regenerate|i:1696354329;'), ('citbfdm4eq492v31o9sdbhmfk1ge5il5', '103.67.156.140', '1696354330', '__ci_last_regenerate|i:1696354330;'), ('2ejckbhpul1dj83k250htbsvrhkh1hob', '103.67.156.140', '1696354332', '__ci_last_regenerate|i:1696354332;'), ('pb33ptb3gqt0bcdpcuor3s0nmkrtnhdv', '103.67.156.140', '1696354333', '__ci_last_regenerate|i:1696354333;'), ('uf4cu6clu4sukcjhcdthhifagn7s1e1i', '103.67.156.140', '1696354333', '__ci_last_regenerate|i:1696354333;'), ('q040bskufvpniek1a85lktqbouunp1u4', '103.67.156.140', '1696354333', '__ci_last_regenerate|i:1696354333;'), ('j8sp5nfofokqebborl8sei6otbhbqrlq', '103.67.156.140', '1696354333', '__ci_last_regenerate|i:1696354333;'), ('i4rr3qlcciigo7v69mlbtmm2d611bthb', '103.67.156.140', '1696354333', '__ci_last_regenerate|i:1696354333;'), ('2os9gitbtv0m85j0m6pn4gq8se8mnkbt', '103.67.156.140', '1696354333', '__ci_last_regenerate|i:1696354333;'), ('m9mm2s32frd3hud8adj01i0274jli2lo', '103.67.156.140', '1696354335', '__ci_last_regenerate|i:1696354335;'), ('gsvl2rh6mp78icaevebk6reffhqvhq9u', '103.67.156.140', '1696354335', '__ci_last_regenerate|i:1696354335;'), ('f5reajos1aluc7da7pc08i9dv2hkphrd', '103.67.156.140', '1696354335', '__ci_last_regenerate|i:1696354335;'), ('1seu9si938etanohgt8dbqelbkutf6lk', '103.67.156.140', '1696354335', '__ci_last_regenerate|i:1696354335;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('7lu159ing8gpbgeelvmdr26gbopvpdpl', '103.67.156.140', '1696354337', '__ci_last_regenerate|i:1696354337;'), ('dg6pn3miqj452edl3mr01tk6comjls6d', '103.67.156.140', '1696354397', '__ci_last_regenerate|i:1696354397;'), ('sgkbfoaojl9blvu918mh3f63je2ot146', '103.67.156.140', '1696354401', '__ci_last_regenerate|i:1696354401;'), ('jpddfgukc5drr18i0g6ebdof085a6vje', '103.67.156.140', '1696354401', '__ci_last_regenerate|i:1696354401;'), ('m1q78rf87q1l3q0e99lrpqi26dc4bmgu', '103.67.156.140', '1696354401', '__ci_last_regenerate|i:1696354401;'), ('b70kjd30t6q83m774g9u92sqm58eenoe', '103.67.156.140', '1696354401', '__ci_last_regenerate|i:1696354401;'), ('5bd6ek0rbm76vu9kur8b1nfop5o9rrmj', '103.67.156.140', '1696354401', '__ci_last_regenerate|i:1696354401;'), ('5n0su8ithin0fckbva4o216221i9cf80', '103.67.156.140', '1696354401', '__ci_last_regenerate|i:1696354401;'), ('1vf0vlnkp8f63ppj8trebabc3567rfje', '103.67.156.140', '1696354402', '__ci_last_regenerate|i:1696354402;'), ('5brlkv5r4b77tshg16k7eltlf01d86lj', '103.67.156.140', '1696354404', '__ci_last_regenerate|i:1696354404;'), ('is1fhsu7q1ifbu1f3chtme6kfe0ths6q', '103.67.156.140', '1696354404', '__ci_last_regenerate|i:1696354404;'), ('76mpk85ij49hvk1cpbm69bkegh736mb2', '103.67.156.140', '1696354405', '__ci_last_regenerate|i:1696354405;'), ('u00t6k78kmcq65d1jtbrmpgo2a1m0mme', '103.67.156.140', '1696354405', '__ci_last_regenerate|i:1696354405;'), ('inhgq1901v1chd8sosojjltpr7a5vr83', '103.67.156.140', '1696354405', '__ci_last_regenerate|i:1696354405;'), ('efdr4prjvcbgsdaaq4bvocm6j2cq3let', '103.67.156.140', '1696354405', '__ci_last_regenerate|i:1696354405;'), ('hlamu45ksqhlb0r7nem7h76j6m006dti', '103.67.156.140', '1696354405', '__ci_last_regenerate|i:1696354405;'), ('99tvaldgke6552hrd726v7o88gif1vsk', '103.67.156.140', '1696354405', '__ci_last_regenerate|i:1696354405;'), ('oqeu8b841svknm5e8otr6q5hmj14qo67', '103.67.156.140', '1696354410', '__ci_last_regenerate|i:1696354410;'), ('qb78nunh8n0tvnrjei4vt872e6sge2a8', '103.67.156.140', '1696354414', '__ci_last_regenerate|i:1696354414;'), ('hgds5mdauars3jibtfln0h6305055jrs', '103.67.156.140', '1696354414', '__ci_last_regenerate|i:1696354414;'), ('bgtq3pu88gh40278p2gvjv2g00i5fent', '103.67.156.140', '1696354414', '__ci_last_regenerate|i:1696354414;'), ('m5o5na8lu9a7bv1kfd3u0un2hfvsn4pp', '103.67.156.140', '1696354414', '__ci_last_regenerate|i:1696354414;'), ('v1q8elkr4lna1tafk9k48jp6876udoso', '103.67.156.140', '1696354414', '__ci_last_regenerate|i:1696354414;'), ('6ap02229k7sgpl2mlubm935i440p8ino', '103.67.156.140', '1696354414', '__ci_last_regenerate|i:1696354414;'), ('prhucjb0s2gt7md8br5bfjv6p6sds9rp', '103.67.156.140', '1696354414', '__ci_last_regenerate|i:1696354414;'), ('h0msaco1c56gk9pe3vsv1t9f418dt92u', '103.67.156.140', '1696354447', '__ci_last_regenerate|i:1696354447;'), ('9d0b2h00uu0qdskkg4l7q0cd7gtvi4f5', '103.67.156.140', '1696354448', '__ci_last_regenerate|i:1696354448;'), ('r2vnuu9pn7h62n4u2bomobee9bq456bk', '103.67.156.140', '1696354448', '__ci_last_regenerate|i:1696354448;'), ('uu7a38ei9biovkgtf09ns5qgc47f299t', '103.67.156.140', '1696354448', '__ci_last_regenerate|i:1696354448;'), ('p8cflh0u0uvoatd8cm3ohteop6ljc7i0', '103.67.156.140', '1696354448', '__ci_last_regenerate|i:1696354448;'), ('j97ltbrscms5jvd4lc4ctviklae6ec33', '103.67.156.140', '1696354448', '__ci_last_regenerate|i:1696354448;'), ('4ivi7bmsitrndl05452tpkf544io7dn3', '103.67.156.140', '1696354448', '__ci_last_regenerate|i:1696354448;'), ('mlj0hnldb7sr9vmsf8eh5rljl10p0ame', '103.67.156.140', '1696354448', '__ci_last_regenerate|i:1696354448;'), ('bqudnlalas3ikvidgv7r4s0bfj5o6a22', '103.67.156.140', '1696355061', '__ci_last_regenerate|i:1696355061;'), ('d3p6csie84tuarahtku0r30o7o7cbf0s', '103.67.156.140', '1696355065', '__ci_last_regenerate|i:1696355065;'), ('rv3k8b13epu5f84m4ot6d8d7k7uvinba', '103.67.156.140', '1696355065', '__ci_last_regenerate|i:1696355065;'), ('nct7g2vldkh17bicrdrhlcut53bf9q0d', '103.67.156.140', '1696355065', '__ci_last_regenerate|i:1696355065;'), ('hjlolvgnmjggg0c5lleqkq8he8nnotss', '103.67.156.140', '1696355065', '__ci_last_regenerate|i:1696355065;'), ('o9f35bnf5fndt9uqgmt00pbea1912qsm', '103.67.156.140', '1696355065', '__ci_last_regenerate|i:1696355065;'), ('jv59oe440dsfsgpvg6k29dm2e9g5g8ju', '103.67.156.140', '1696355065', '__ci_last_regenerate|i:1696355065;'), ('u5kds4lcuk96rkhmsrl3k661ko4j5d6j', '103.67.156.140', '1696355065', '__ci_last_regenerate|i:1696355065;'), ('drccb8q048omi3hkim30a0t16ocu9s9u', '103.67.156.140', '1696355130', '__ci_last_regenerate|i:1696355130;'), ('n7ekrfv7hkate847b6kjlh7614m8287q', '103.67.156.140', '1696355133', '__ci_last_regenerate|i:1696355133;'), ('fq006hu5gmlhe8m4ed1ocvpbf3mud7ir', '103.67.156.140', '1696355134', '__ci_last_regenerate|i:1696355134;'), ('60nhp17r0go0u91ob96p9djbq04e7f7p', '103.67.156.140', '1696355134', '__ci_last_regenerate|i:1696355134;'), ('luu1252tnbbb3tt4vpv7r5gb0mhl4500', '103.67.156.140', '1696355134', '__ci_last_regenerate|i:1696355134;'), ('e32s7h1atsjbdlfkp8k8rg3p0oj3p33d', '103.67.156.140', '1696355134', '__ci_last_regenerate|i:1696355134;'), ('5l755qji7dbckrgcdkmulpv8d7bam6uo', '103.67.156.140', '1696355134', '__ci_last_regenerate|i:1696355134;'), ('boubmjmieqnnvimn2020j1d2d1il3n4h', '103.67.156.140', '1696355136', '__ci_last_regenerate|i:1696355136;'), ('f69sl62pdo4rmps9j5o3f2ghsugmqqhp', '103.67.156.140', '1696355422', '__ci_last_regenerate|i:1696355422;'), ('3hv1c596a6rr51v73d9mvku70esneeis', '103.67.156.140', '1696355426', '__ci_last_regenerate|i:1696355426;'), ('gmb3m959fl5imktjaal9odqta48slc5o', '103.67.156.140', '1696355426', '__ci_last_regenerate|i:1696355426;'), ('unuprur71pb4l6n4ehjc26mn8eot2l45', '103.67.156.140', '1696355426', '__ci_last_regenerate|i:1696355426;'), ('l2ukecsmc64381oqvnrorla5m11td40o', '103.67.156.140', '1696355426', '__ci_last_regenerate|i:1696355426;'), ('9cndh5ah3jrs2m2bhkalta58up1nlt9r', '103.67.156.140', '1696355426', '__ci_last_regenerate|i:1696355426;'), ('h6i47jsrttql9b9olakevqv7o7ke3bat', '103.67.156.140', '1696355426', '__ci_last_regenerate|i:1696355426;'), ('uqkn4fehm9unepprkn4ohud4j3e64ho0', '103.67.156.140', '1696355426', '__ci_last_regenerate|i:1696355426;'), ('vtb0ko7hc6kk86s6fpb0plioe9vjo5di', '103.67.156.140', '1696355489', '__ci_last_regenerate|i:1696355489;'), ('39nt120s113g557ok716ghqhubrs4jng', '103.67.156.140', '1696355491', '__ci_last_regenerate|i:1696355491;'), ('3b904r3cpio59tp9ih1trgkpiv1ls7iv', '103.67.156.140', '1696355492', '__ci_last_regenerate|i:1696355492;'), ('0qmvtnl3nbd95aqia6ceastbqh8ap8ch', '103.67.156.140', '1696355492', '__ci_last_regenerate|i:1696355492;'), ('86gll0e06hfubfrq1i6v1bknlet89in7', '103.67.156.140', '1696355492', '__ci_last_regenerate|i:1696355492;'), ('rnbm83h0dto3v8jgc6g3u5aed9e7vh8p', '103.67.156.140', '1696355492', '__ci_last_regenerate|i:1696355492;'), ('j9acit7gj5i2o4ep131evu94uuqgrjd2', '103.67.156.140', '1696355492', '__ci_last_regenerate|i:1696355492;'), ('d61n7uf9gssmdcrp232rhlv1qh7enram', '103.67.156.140', '1696355492', '__ci_last_regenerate|i:1696355492;'), ('fvqdudqat6j8bom4gd9o7crhpth9f1vq', '103.67.156.140', '1696355492', '__ci_last_regenerate|i:1696355492;'), ('uiq6230f92vjvabhgkp1g4rj0fhhvd8j', '103.67.156.140', '1696355931', '__ci_last_regenerate|i:1696355931;'), ('acgpsni16ob4bau7m1212q7at9rjkrms', '103.67.156.140', '1696355934', '__ci_last_regenerate|i:1696355934;'), ('22ufen5r6dalcl6bpcbnchkvhvian44u', '103.67.156.140', '1696355934', '__ci_last_regenerate|i:1696355934;'), ('sitf6dl67oc6fcpidtsskots8sjg2fce', '103.67.156.140', '1696355934', '__ci_last_regenerate|i:1696355934;'), ('of5dkm1q9oj34o5runm35h1h7v40qrf2', '103.67.156.140', '1696355934', '__ci_last_regenerate|i:1696355934;'), ('d8khbo1qafjqu1fgsjiluv9gr8nnkg8s', '103.67.156.140', '1696355934', '__ci_last_regenerate|i:1696355934;'), ('tvta5q8t0nlcujq6p5kch3ujsh24njk4', '103.67.156.140', '1696355934', '__ci_last_regenerate|i:1696355934;'), ('8udec3ihj9v7jq2kj544qbk8av11sllo', '103.67.156.140', '1696355935', '__ci_last_regenerate|i:1696355935;'), ('okmilnqq8hvossctk074lt2bubbvffhq', '103.67.156.140', '1696356130', '__ci_last_regenerate|i:1696356130;'), ('grdimkcudd5cmbgq6efhe7v1e15ca315', '103.67.156.140', '1696356130', '__ci_last_regenerate|i:1696356130;'), ('dre21i21m6js26b0giqs29os3ed0o72u', '103.67.156.140', '1696356131', '__ci_last_regenerate|i:1696356131;'), ('md1qn99tto3r1chaps2udl0m3ci7foqo', '103.67.156.140', '1696356131', '__ci_last_regenerate|i:1696356131;'), ('bric6ep0q8im3rmvv3k0g257hdiqg34k', '103.67.156.140', '1696356131', '__ci_last_regenerate|i:1696356131;'), ('iblugbt1evog3talbv3ag0mm1u208957', '103.67.156.140', '1696356131', '__ci_last_regenerate|i:1696356131;'), ('7otfuemviro93el5upcft643bt30scb4', '103.67.156.140', '1696356131', '__ci_last_regenerate|i:1696356131;'), ('vos3jsq4a7qnde3vlj18rcsqsft3fg4m', '103.67.156.140', '1696356131', '__ci_last_regenerate|i:1696356131;'), ('cu2e9r4dgb6o4h1entha1e1e6oifu6f0', '103.67.156.140', '1696356225', '__ci_last_regenerate|i:1696356225;'), ('2n94s0oh6hleumbb44hifkqfl7mtrjqg', '103.67.156.140', '1696356225', '__ci_last_regenerate|i:1696356225;'), ('o36a00bk202m9pr2g8ucl7rdaufvsm0j', '103.67.156.140', '1696356226', '__ci_last_regenerate|i:1696356226;'), ('k5nlpndimja1lrirfmsjanmecjr3off9', '103.67.156.140', '1696356226', '__ci_last_regenerate|i:1696356226;'), ('nidm0d3j0h971ji42o5spc064n333d8f', '103.67.156.140', '1696356226', '__ci_last_regenerate|i:1696356226;'), ('te3ddqpnch1ncihd20t7b48scosk0466', '103.67.156.140', '1696356226', '__ci_last_regenerate|i:1696356226;'), ('5ra7vkvssi3s2qr5uk91bc1s93mjr7fh', '103.67.156.140', '1696356226', '__ci_last_regenerate|i:1696356226;'), ('cbb9e996r0kia6kocn1kd4ph71ekbcin', '103.67.156.140', '1696356226', '__ci_last_regenerate|i:1696356226;'), ('ntvsd668k9brhujidnf19vkj8dsi960a', '103.67.156.140', '1696356534', '__ci_last_regenerate|i:1696356534;'), ('9peuvq0hj27e5b4aaakvp5vphk5t64ae', '103.67.156.140', '1696356692', '__ci_last_regenerate|i:1696356692;'), ('8vubfmc2hrgoji5ll1mmskpimep6st4p', '103.67.156.140', '1696356813', '__ci_last_regenerate|i:1696356813;'), ('5bk711qetteh0c73vhpamfvpm1debtv1', '103.67.156.140', '1696356895', '__ci_last_regenerate|i:1696356895;'), ('28rl64u8jn4ivuuskd2trh1m0kp7hkmj', '103.67.156.140', '1696356898', '__ci_last_regenerate|i:1696356898;'), ('c45j5u7mspp44gbqsuplasin53f3rj26', '103.67.156.140', '1696356898', '__ci_last_regenerate|i:1696356898;'), ('ad1e1rmlkhjhne9s9kr1tt37umgjoo8e', '103.67.156.140', '1696356898', '__ci_last_regenerate|i:1696356898;'), ('emls2kmq19asn6da23ls47to90sb6hbj', '103.67.156.140', '1696356898', '__ci_last_regenerate|i:1696356898;'), ('jv2lgi0f5illha8r6f9hmii2v48a1fqf', '103.67.156.140', '1696356898', '__ci_last_regenerate|i:1696356898;'), ('0ffqco9ont3vffo2lk1e6lnfjslliebn', '103.67.156.140', '1696356898', '__ci_last_regenerate|i:1696356898;'), ('1lv88tim1lhvg5sdgljvig5c2stg0bfr', '103.67.156.140', '1696356899', '__ci_last_regenerate|i:1696356899;'), ('1armkcqk0bq6p2knqa7i3bakc0koecbh', '103.67.156.140', '1696357070', '__ci_last_regenerate|i:1696357070;'), ('s90noe0rf92mou2gjq87hrdj2h2cd5an', '103.67.156.140', '1696357071', '__ci_last_regenerate|i:1696357071;'), ('cnck3l9nssj8v5u5h2upm95e5jhfv8af', '103.67.156.140', '1696357071', '__ci_last_regenerate|i:1696357071;'), ('37ti59rqdkukftnu9ii9kdqisg93u7kq', '103.67.156.140', '1696357071', '__ci_last_regenerate|i:1696357071;'), ('qejkpfm8ivadtka2f7099db45eavpt4r', '103.67.156.140', '1696357071', '__ci_last_regenerate|i:1696357071;'), ('rp44a2du7vmgto7dfhtk9esnd7991i9a', '103.67.156.140', '1696357071', '__ci_last_regenerate|i:1696357071;'), ('u9numeluumjikum7n5ko6v0ur87kppgp', '103.67.156.140', '1696357071', '__ci_last_regenerate|i:1696357071;'), ('dfmdke4bjo55v61o94udd9ebd2338i9l', '103.67.156.140', '1696357071', '__ci_last_regenerate|i:1696357071;'), ('51jbegp26j0rcel3h7mrmi04ftl4so6p', '103.67.156.140', '1696357433', '__ci_last_regenerate|i:1696357433;'), ('agj165cg5lsrlfimpc6a0kugh8ol7r0u', '103.67.156.140', '1696357436', '__ci_last_regenerate|i:1696357436;'), ('trf0j0tf5j2sfftdftc4m60ougmo1ake', '103.67.156.140', '1696357436', '__ci_last_regenerate|i:1696357436;'), ('9g5nufv98ab08qpmrm073prfib0sjqqj', '103.67.156.140', '1696357436', '__ci_last_regenerate|i:1696357436;'), ('bt0q493io605rulkqunn2paigdn7pl5q', '103.67.156.140', '1696357436', '__ci_last_regenerate|i:1696357436;'), ('65eok1o3vkh973o0tceeb8uf6r905495', '103.67.156.140', '1696357436', '__ci_last_regenerate|i:1696357436;'), ('mk94r3jplomvlgruh073qaa0grd3v3nf', '103.67.156.140', '1696357436', '__ci_last_regenerate|i:1696357436;'), ('9mndifvrbqd52jqa5te9rd730rcdk94j', '103.67.156.140', '1696357437', '__ci_last_regenerate|i:1696357437;'), ('nuf4c1dta9mkq1034j6bb4eototps7fe', '103.67.156.140', '1696357588', '__ci_last_regenerate|i:1696357588;'), ('h0prkgl8jkduc0sj92nmm9eiimll4uqr', '103.67.156.140', '1696357591', '__ci_last_regenerate|i:1696357591;'), ('m5gv7u14930rn2mel8q2lbifggadj6b5', '103.67.156.140', '1696357591', '__ci_last_regenerate|i:1696357591;'), ('utf7mmt4hhba028l3fmbepa5vunvk0nu', '103.67.156.140', '1696357591', '__ci_last_regenerate|i:1696357591;'), ('og8i9316gqm5c7oblnksl4f57mi5foe8', '103.67.156.140', '1696357591', '__ci_last_regenerate|i:1696357591;'), ('qig5d5vpn6hlp23l5hc9ukkqhkau7cfl', '103.67.156.140', '1696357591', '__ci_last_regenerate|i:1696357591;'), ('bkk2togk2l2l8kjjsbb2umctlrggjasq', '103.67.156.140', '1696357591', '__ci_last_regenerate|i:1696357591;'), ('sasnq92bujicm0hptjc265l7rnblvomc', '103.67.156.140', '1696357592', '__ci_last_regenerate|i:1696357592;'), ('jn7gg3ug63509m0ej46ff145qaen79bl', '103.67.156.140', '1696357778', '__ci_last_regenerate|i:1696357778;'), ('v235daon0854k4ob0ueqsarre2p8bjl2', '103.67.156.140', '1696357781', '__ci_last_regenerate|i:1696357781;'), ('6ojo4di9pejuao1vtpueela5u33m44nf', '103.67.156.140', '1696357781', '__ci_last_regenerate|i:1696357781;'), ('7fo0iojgg11mgfnnte8fjalj07dngoot', '103.67.156.140', '1696357781', '__ci_last_regenerate|i:1696357781;'), ('eungp95hdef97gcomoe6cmhvqm32ldaa', '103.67.156.140', '1696357781', '__ci_last_regenerate|i:1696357781;'), ('2dql3ebohhtg25338mdg9u1h0gc9ebbg', '103.67.156.140', '1696357781', '__ci_last_regenerate|i:1696357781;'), ('encaegkvjedp72fhdqtclg15jip80e6e', '103.67.156.140', '1696357781', '__ci_last_regenerate|i:1696357781;'), ('ev2s4692od8qcgecg3pucrcenafrlue5', '103.67.156.140', '1696357782', '__ci_last_regenerate|i:1696357782;'), ('4sk0n97i6218h406le05lphu0uouo6oo', '103.67.156.140', '1696357821', '__ci_last_regenerate|i:1696357821;'), ('dp39u1jacm12p1pcrsvb8v29rs2jbtt9', '103.67.156.140', '1696357824', '__ci_last_regenerate|i:1696357824;'), ('udnk8ue5dgvl2u00dm6662luq5n9djqk', '103.67.156.140', '1696357824', '__ci_last_regenerate|i:1696357824;'), ('qp7n7tndn7bdosum2ujlmlismeqnlm3e', '103.67.156.140', '1696357824', '__ci_last_regenerate|i:1696357824;'), ('0r8lt48taf9812r0hcflgh4rh2pl3eet', '103.67.156.140', '1696357824', '__ci_last_regenerate|i:1696357824;'), ('gtvdhagu5923l04mfgecg7p9n3m4fhuf', '103.67.156.140', '1696357824', '__ci_last_regenerate|i:1696357824;'), ('sdag7ujv6lhmfua26ttc49o2394f5orq', '103.67.156.140', '1696357824', '__ci_last_regenerate|i:1696357824;'), ('eeq882etmrssoqfcbvqvj4dgip8e2r1d', '103.67.156.140', '1696357825', '__ci_last_regenerate|i:1696357825;'), ('p78npatb163fcev98ch639ibs7fjsg6s', '103.67.156.140', '1696357954', '__ci_last_regenerate|i:1696357954;'), ('s8hfg7cda0t5r6alr667fapk21s3i6s1', '103.67.156.140', '1696357957', '__ci_last_regenerate|i:1696357957;'), ('563cmenttnr6oliv39ktd7lf5mif86d3', '103.67.156.140', '1696357957', '__ci_last_regenerate|i:1696357957;'), ('83d8eo0p89a0i7cvlaftuuhoi4mfc21c', '103.67.156.140', '1696357957', '__ci_last_regenerate|i:1696357957;'), ('i4522do4vtkis4np8qlhket5v2c6c01c', '103.67.156.140', '1696357957', '__ci_last_regenerate|i:1696357957;'), ('67fjep9j6vjou4mj8q54somd1s7o5fqk', '103.67.156.140', '1696357957', '__ci_last_regenerate|i:1696357957;'), ('bd7ujkh11d576s9pvtagn0tqq2qkinhl', '103.67.156.140', '1696357957', '__ci_last_regenerate|i:1696357957;'), ('ojlg4046q5gclmcga0rqkevmm73gld99', '103.67.156.140', '1696357957', '__ci_last_regenerate|i:1696357957;'), ('ph8av06499cj8jq2avre4ablcp7hjp2t', '103.67.156.140', '1696358124', '__ci_last_regenerate|i:1696358124;'), ('94l52q2htmcacgo5o7bjhako4v4h9fej', '103.67.156.140', '1696358128', '__ci_last_regenerate|i:1696358128;'), ('7aujsd2t37n3ugc69iacdtkane0b0bg4', '103.67.156.140', '1696358128', '__ci_last_regenerate|i:1696358128;'), ('a98gsupqf8klrp6a08l2et3dtub0kn78', '103.67.156.140', '1696358128', '__ci_last_regenerate|i:1696358128;'), ('f2iktt1etgr6c62pnt0jj86j7keggqmd', '103.67.156.140', '1696358128', '__ci_last_regenerate|i:1696358128;'), ('2tlthkhior0er36c2qpe17pukqf3bl4i', '103.67.156.140', '1696358128', '__ci_last_regenerate|i:1696358128;'), ('6sem42c6kq0p5of8j8pb2h3lvurif1lj', '103.67.156.140', '1696358128', '__ci_last_regenerate|i:1696358128;'), ('9149nqg1lvu07uk50m1ghbi72gnmd96g', '103.67.156.140', '1696358128', '__ci_last_regenerate|i:1696358128;'), ('g17o5d5g5udnj13evsdmvqrk6d5fki4t', '103.67.156.140', '1696358163', '__ci_last_regenerate|i:1696358163;'), ('ajidjq6ckv5vle0fspsovfr16ksa7fvd', '103.67.156.140', '1696358167', '__ci_last_regenerate|i:1696358167;'), ('24scpqo8dlv9igq19l8uc3gkp380hl9a', '103.67.156.140', '1696358167', '__ci_last_regenerate|i:1696358167;'), ('bn077r2jomcdd07p75v3dfc59o0369cp', '103.67.156.140', '1696358168', '__ci_last_regenerate|i:1696358168;'), ('u4gm5rdbnan8gmo9j14baj433ti1fd61', '103.67.156.140', '1696358168', '__ci_last_regenerate|i:1696358168;'), ('8lnnf7qg7m7ajbjidga2o4gk8krm6f6f', '103.67.156.140', '1696358168', '__ci_last_regenerate|i:1696358168;'), ('kkjbq1ls4bdlp2ed7p2vg3vrbf02lsms', '103.67.156.140', '1696358168', '__ci_last_regenerate|i:1696358168;'), ('bbjsdk329fffm49hee3j1fb0efco5lqo', '103.67.156.140', '1696358168', '__ci_last_regenerate|i:1696358168;'), ('fhckl0r2qgpv60lbah943j8jrc9m0t9t', '103.67.156.140', '1696358168', '__ci_last_regenerate|i:1696358168;'), ('tdq7md2a9soek581ut64549pfhff8foi', '103.67.156.140', '1696358387', '__ci_last_regenerate|i:1696358387;'), ('b24vshlibsc5986j7mii52rc8q731m5s', '103.67.156.140', '1696358390', '__ci_last_regenerate|i:1696358390;'), ('l0rom7ioda2be3osjh9enbp27ffctkp9', '103.67.156.140', '1696358390', '__ci_last_regenerate|i:1696358390;'), ('jhpjui5qnm6kqhsbjnjmp4vsqdf66ctq', '103.67.156.140', '1696358390', '__ci_last_regenerate|i:1696358390;'), ('kn4s4b2sjhbhb8ffb7c59fn02qkplfog', '103.67.156.140', '1696358390', '__ci_last_regenerate|i:1696358390;'), ('9aedq9pf4elcnqso0gfciem9ds02nl3r', '103.67.156.140', '1696358390', '__ci_last_regenerate|i:1696358390;'), ('leeif6s978jtig3rl4fgqjktmvbrhfva', '103.67.156.140', '1696358390', '__ci_last_regenerate|i:1696358390;'), ('fe9k61jifgtt3v9m929i6v2abm6enoqj', '103.67.156.140', '1696358390', '__ci_last_regenerate|i:1696358390;'), ('4qdh40fmeg6k7rlk9u90s1sp745f9pcv', '103.67.156.140', '1696358509', '__ci_last_regenerate|i:1696358509;'), ('qoqlpeirkg9q8rv34ure06htodnm4qli', '103.67.156.140', '1696358513', '__ci_last_regenerate|i:1696358513;'), ('fk98g720r3q0lp9copag5sioaacdqfgb', '103.67.156.140', '1696358513', '__ci_last_regenerate|i:1696358513;'), ('uhj5ahs0lldmvtcro2qq9un2l6kuuke5', '103.67.156.140', '1696358513', '__ci_last_regenerate|i:1696358513;'), ('g7n4tgb99iqh1nuhv9vl9b574upgf6pf', '103.67.156.140', '1696358513', '__ci_last_regenerate|i:1696358513;'), ('3ecdgjh1bncsq6ot6q1k9r91k3cdl6t1', '103.67.156.140', '1696358513', '__ci_last_regenerate|i:1696358513;'), ('rn7014i3io4tn0je4o7ecu43gc2ugga5', '103.67.156.140', '1696358513', '__ci_last_regenerate|i:1696358513;'), ('1e2bat20fvrg0i5o3v23aiqfti40ufqt', '103.67.156.140', '1696358513', '__ci_last_regenerate|i:1696358513;'), ('93oti2l79k2shoaeofuos7nc09uej3gm', '103.67.156.140', '1696358658', '__ci_last_regenerate|i:1696358658;'), ('gt32u29cfvro0j31589mg90c3m7tddce', '103.67.156.140', '1696358658', '__ci_last_regenerate|i:1696358658;'), ('pf9aebv9l9oej3dqt2bjccileticrnga', '103.67.156.140', '1696358659', '__ci_last_regenerate|i:1696358659;'), ('d7ch1g2u8g9cq6t7vqihirhjkqb9s49c', '103.67.156.140', '1696358659', '__ci_last_regenerate|i:1696358659;'), ('eu71qb4ff1tr242udal5htmmr3js25nb', '103.67.156.140', '1696358659', '__ci_last_regenerate|i:1696358659;'), ('o2cesp3k6fq501bq7465vf74p2dqq88b', '103.67.156.140', '1696358659', '__ci_last_regenerate|i:1696358659;'), ('q0ltre8b7pg3ea6o4r94argg68au90fn', '103.67.156.140', '1696358659', '__ci_last_regenerate|i:1696358659;'), ('f2metr0gjveo2sdntba174rq6qm76c69', '103.67.156.140', '1696358659', '__ci_last_regenerate|i:1696358659;'), ('ecuqvius51kfncotu7nn4131t3kdod2n', '103.67.156.140', '1696358910', '__ci_last_regenerate|i:1696358910;'), ('2cigoljvd7iabu97t9uhph4tk0qf3kru', '103.67.156.140', '1696358913', '__ci_last_regenerate|i:1696358913;'), ('pgs2eccsbsb2uu1gl6in7k5cfeqje6mq', '103.67.156.140', '1696358913', '__ci_last_regenerate|i:1696358913;'), ('0ir0o80cgeardrsitohns1d3hhfuhk28', '103.67.156.140', '1696358913', '__ci_last_regenerate|i:1696358913;'), ('66tmavmu7dmjim9124jrachaicr1cj59', '103.67.156.140', '1696358913', '__ci_last_regenerate|i:1696358913;'), ('mcru8get57g63hr6hpjat512f0fbaouq', '103.67.156.140', '1696358913', '__ci_last_regenerate|i:1696358913;'), ('6s7u9d0sq2edpkgqmm76ruv7igutcga4', '103.67.156.140', '1696358913', '__ci_last_regenerate|i:1696358913;'), ('ifc2ebmt7igmbv18hvh4ajsrmb3lo0an', '103.67.156.140', '1696358914', '__ci_last_regenerate|i:1696358914;'), ('jg58u2l3gvnkaflhcn0jvr64op3jm92t', '103.67.156.140', '1696358943', '__ci_last_regenerate|i:1696358943;'), ('3jknh0638fabuia601gov578ain4had8', '103.67.156.140', '1696359200', '__ci_last_regenerate|i:1696359200;'), ('3pojc68ea30otduo8p8dp9omfetadbip', '103.67.156.140', '1696359229', '__ci_last_regenerate|i:1696359229;'), ('an2vb1kfkcpd4jah9inhplfquduj2vrn', '103.67.156.140', '1696359259', '__ci_last_regenerate|i:1696359259;'), ('tfk6s698l0tb2cmsqlertgh6kfcv8t4m', '103.67.156.140', '1696359430', '__ci_last_regenerate|i:1696359430;'), ('6kkbd8gska06qp577kdc5vvvpg1rn816', '103.67.156.140', '1696359430', '__ci_last_regenerate|i:1696359430;'), ('b1v0sdi2ltrn7052te99c08n71skdidc', '103.67.156.140', '1696359797', '__ci_last_regenerate|i:1696359797;'), ('ag5khk077ptq3v5rh3ppjuk91v4gddv7', '103.67.156.140', '1696359822', '__ci_last_regenerate|i:1696359822;'), ('j7e4or7g5i7dtl1ppqfugrhstufcott0', '103.16.25.109', '1696359923', '__ci_last_regenerate|i:1696359923;'), ('9qq4atcdgk30kbe3ock1li9974fn0bk2', '103.16.25.109', '1696359927', '__ci_last_regenerate|i:1696359927;'), ('9aol8k48kfrvkldm47d5mfd0gq8t5fps', '103.16.25.109', '1696359927', '__ci_last_regenerate|i:1696359927;'), ('rthqntofbokqfhac9l6ave6o14ld86ai', '103.16.25.109', '1696359927', '__ci_last_regenerate|i:1696359927;'), ('qh3fc359mr1h0jo4idhk1u1jvduh0pdl', '103.16.25.109', '1696359927', '__ci_last_regenerate|i:1696359927;'), ('v9m01ft9huahi1lgi2c73pd1lg6mcfco', '103.16.25.109', '1696359927', '__ci_last_regenerate|i:1696359927;'), ('jauti42h9a3m67hd6sdkuo0c79v86s3k', '103.16.25.109', '1696359927', '__ci_last_regenerate|i:1696359927;'), ('0lbhnebddrbqc6bcppigopqgbv4i1nsk', '103.16.25.109', '1696359927', '__ci_last_regenerate|i:1696359927;'), ('t7eop3irmt6ikj3rq2u74r78166acs8j', '103.16.25.109', '1696359940', '__ci_last_regenerate|i:1696359940;'), ('qdbu0jf8fodpq0bhk8hn4ivk29234i4f', '103.16.25.109', '1696359940', '__ci_last_regenerate|i:1696359940;'), ('2lsqpajbqhubgoetefuhlm9v43u9katr', '103.16.25.109', '1696359940', '__ci_last_regenerate|i:1696359940;'), ('viqh8nhllgp1gu2ki2s4t37ihfmns1eb', '103.16.25.109', '1696359940', '__ci_last_regenerate|i:1696359940;'), ('krr6v2i9jg1cgqcua24opfd0lj8aef8e', '103.16.25.109', '1696359940', '__ci_last_regenerate|i:1696359940;'), ('2grbtibp6a52p37t9igchgrcmdcouma4', '103.16.25.109', '1696359941', '__ci_last_regenerate|i:1696359941;'), ('9vprforuibugmfj3c6eglhiv8utrop5b', '103.16.25.109', '1696359942', '__ci_last_regenerate|i:1696359942;'), ('l7rjt7ei41gspvl2p4f11bl5tud9d9n4', '103.16.25.109', '1696359942', '__ci_last_regenerate|i:1696359942;'), ('73nrpvdnoau3s4cskvel2828nha536b1', '103.16.25.109', '1696359942', '__ci_last_regenerate|i:1696359942;'), ('n30imfcb7boaretppnprmhs7qnan8n2e', '103.16.25.109', '1696359942', '__ci_last_regenerate|i:1696359942;'), ('dccbo5sf0l52mr4pb02tc68cpsgc4qin', '103.16.25.109', '1696359942', '__ci_last_regenerate|i:1696359942;'), ('bqmbh1n2u73hrh51ahe9ounqpaoucemj', '103.16.25.109', '1696359942', '__ci_last_regenerate|i:1696359942;'), ('q46mtccvn79592878mptr7gd04po8tds', '103.67.156.140', '1696359965', '__ci_last_regenerate|i:1696359965;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('i5dv8dmk5vune46gvuoilf78llslfn93', '103.67.156.140', '1696359966', '__ci_last_regenerate|i:1696359966;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('ko3e62v6889ohp9iilg2bn0neg9mjrkt', '103.16.25.109', '1696360021', '__ci_last_regenerate|i:1696360021;'), ('nupfo9gt8e5o5nbeu3g0c0olekdg29o3', '103.16.25.109', '1696360022', '__ci_last_regenerate|i:1696360022;'), ('9orl6qdjv70en5uhjkmf23vc5pa36rrm', '103.16.25.109', '1696360022', '__ci_last_regenerate|i:1696360022;'), ('frfje72qu5i1kfna8d11e75ltj7b108p', '103.16.25.109', '1696360022', '__ci_last_regenerate|i:1696360022;'), ('75murrsdrabpudi441b18urasbl89spe', '103.16.25.109', '1696360022', '__ci_last_regenerate|i:1696360022;'), ('1cng1q16v9ls64rckushs2sr96m07nb3', '103.16.25.109', '1696360022', '__ci_last_regenerate|i:1696360022;'), ('ho5tn16hfht46kr0qen80058uo7vqe2r', '103.16.25.109', '1696360022', '__ci_last_regenerate|i:1696360022;'), ('crrao63dvep6flklb9isedokj5ivlbip', '103.16.25.109', '1696360023', '__ci_last_regenerate|i:1696360023;'), ('rak3ke9o3sscijh1gmjtrdeubghbdq3i', '103.16.25.109', '1696368746', '__ci_last_regenerate|i:1696360026;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1697224316;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('aos11mk61v0lrpc8cl2l28sadngjn67o', '103.16.25.109', '1696360027', '__ci_last_regenerate|i:1696360027;'), ('9p7ca47o8910vr3ncc1rvdih6d0583d2', '103.16.25.109', '1696360027', '__ci_last_regenerate|i:1696360027;'), ('dn5hgdhptdm51k2368ji00f67m25pjm1', '103.16.25.109', '1696360028', '__ci_last_regenerate|i:1696360028;'), ('3o2h9fgg77dqdk5munl1fn1utkrrgl9l', '103.16.25.109', '1696360028', '__ci_last_regenerate|i:1696360028;'), ('r0op4r24avrvm0ufnv9jge8j0nf4e22c', '103.16.25.109', '1696360028', '__ci_last_regenerate|i:1696360028;'), ('b2i1m285bio9ogo9h5qgpltieajtuahb', '103.16.25.109', '1696360028', '__ci_last_regenerate|i:1696360028;'), ('g8dkiak29i3sf4hjtt4v26ooipalk4td', '103.16.25.109', '1696360028', '__ci_last_regenerate|i:1696360028;'), ('v3f07itpshh8ji8alkon18shnth3ev70', '103.16.25.109', '1696360028', '__ci_last_regenerate|i:1696360028;'), ('51qmfgumnotvjq46hulksgmp25ons51p', '103.67.156.140', '1696360028', '__ci_last_regenerate|i:1696360028;'), ('jkhi5vtuavdmsamr9s5qspl9akif9mul', '103.67.156.140', '1696360028', '__ci_last_regenerate|i:1696360028;'), ('j2ihe6uvs27ajqafe4t5uerrj59igcps', '103.67.156.140', '1696360029', '__ci_last_regenerate|i:1696360029;'), ('588j1gcs1gl9vfedai5ejc2fm58ucncu', '103.67.156.140', '1696360029', '__ci_last_regenerate|i:1696360029;'), ('isqc500v1uhohugpnkkkf7kn92bbfqg1', '103.67.156.140', '1696360029', '__ci_last_regenerate|i:1696360029;'), ('rhr8c3rd9rsfcqitd5qsa17a7poq9hl6', '103.67.156.140', '1696360029', '__ci_last_regenerate|i:1696360029;'), ('l23s0lg6ettqq2ncm450iqmq43t2i24r', '103.67.156.140', '1696360029', '__ci_last_regenerate|i:1696360029;'), ('v6ksbc5pp1tor3p3imra59bj905tiq2k', '103.67.156.140', '1696360029', '__ci_last_regenerate|i:1696360029;'), ('r2it6boohbbqhb2gosq8ojdftas4u7uc', '103.67.156.140', '1696360031', '__ci_last_regenerate|i:1696360031;'), ('kiccvvp7o6ln2ftvsb7f0lhq9t712p8d', '103.67.156.140', '1696360031', '__ci_last_regenerate|i:1696360031;'), ('eqlton52p2ns6ihlehev6sqvhemop5al', '103.67.156.140', '1696360031', '__ci_last_regenerate|i:1696360031;'), ('b93ghocev5t3lgasrskt3danhr9h14pp', '103.67.156.140', '1696360031', '__ci_last_regenerate|i:1696360031;'), ('pgn3fi3mtu4kqfv3t441qdu9ndp4iejc', '103.16.25.109', '1696360035', '__ci_last_regenerate|i:1696360035;'), ('oemkv53kt0sqdfj0mtom9674i5jvs3br', '103.16.25.109', '1696360035', '__ci_last_regenerate|i:1696360035;'), ('4eadhf177gnvcnaorji1lf07q5ni2tl1', '103.16.25.109', '1696360035', '__ci_last_regenerate|i:1696360035;'), ('dq5ina0tqru6r4g0aivn199ci657mtbr', '103.16.25.109', '1696360035', '__ci_last_regenerate|i:1696360035;'), ('0flncibb8rnnq24mnfd8mnmgdk2mmbsk', '103.16.25.109', '1696360040', '__ci_last_regenerate|i:1696360040;'), ('rsmb9ui2hago1sckgghkd5tmtm2f0ns7', '103.16.25.109', '1696360040', '__ci_last_regenerate|i:1696360040;'), ('n3gdoqrv8scsmuaeckqeftc0u8r7f9mc', '103.16.25.109', '1696360041', '__ci_last_regenerate|i:1696360041;'), ('09mh5dvq545oadechu9g4cre5gnm2969', '103.16.25.109', '1696360041', '__ci_last_regenerate|i:1696360041;'), ('tnug2n46p6a3gg07d7d0armu993mo9ru', '103.16.25.109', '1696360041', '__ci_last_regenerate|i:1696360041;'), ('l95d9ltb09rmgb0j203k411ru8730oso', '103.16.25.109', '1696360041', '__ci_last_regenerate|i:1696360041;'), ('e7tmiscf3tkj3n5b1k115tlgn2d0ooio', '103.16.25.109', '1696360041', '__ci_last_regenerate|i:1696360041;'), ('rmldk5635ogqoeuoq2sj5q72eu2blt7v', '103.16.25.109', '1696360041', '__ci_last_regenerate|i:1696360041;'), ('lr9kfv4m6r9f8pehi8j3dqh5e7sqtobt', '103.16.25.109', '1696360041', '__ci_last_regenerate|i:1696360041;'), ('6k613680jahvrqsanco75f134binn5t3', '103.16.25.109', '1696360041', '__ci_last_regenerate|i:1696360041;'), ('np3t52ocpafjhmgbpp97ha86ldrgcfjh', '103.16.25.109', '1696360041', '__ci_last_regenerate|i:1696360041;'), ('o9k975d6c021etkh9h6q8vp9hro2d3b2', '103.16.25.109', '1696360041', '__ci_last_regenerate|i:1696360041;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('gneosr2d6shi30e2smkfa8qp859ltreo', '103.16.25.109', '1696360050', '__ci_last_regenerate|i:1696360050;'), ('98vkqsqdl9rnv0laok9givir1h2daikp', '103.16.25.109', '1696360050', '__ci_last_regenerate|i:1696360050;'), ('pna2ae9p11urut1d2sq55ahv093drrvh', '103.16.25.109', '1696360050', '__ci_last_regenerate|i:1696360050;'), ('sv9gjr30vs6gu19t111lf4bgdfn0bkc9', '103.16.25.109', '1696360050', '__ci_last_regenerate|i:1696360050;'), ('bas4pe8i30lfhqukosgnsmqmo4im6jmp', '103.16.25.109', '1696360050', '__ci_last_regenerate|i:1696360050;'), ('04l7nlc7kb1scpk2alaf7vottrdl6h67', '103.16.25.109', '1696360050', '__ci_last_regenerate|i:1696360050;'), ('41fdf9o1qvhe4rhp74bg9e8387cp595b', '103.16.25.109', '1696360050', '__ci_last_regenerate|i:1696360050;'), ('eo407usfk3sbfpui3ac3sdm23sprdppd', '103.16.25.109', '1696360050', '__ci_last_regenerate|i:1696360050;'), ('svgkn6sea9hcvdre754pnir5tp1p5nto', '103.16.25.109', '1696360052', '__ci_last_regenerate|i:1696360052;'), ('rhvfojfb58k4mepv73t56n2lfslmf52m', '103.16.25.109', '1696360052', '__ci_last_regenerate|i:1696360052;'), ('p18ml0ud2iffh2nn6ft8onjuo7328ndk', '103.16.25.109', '1696360052', '__ci_last_regenerate|i:1696360052;'), ('tipufbrdiuq69sfjehqscddlqqpgo5br', '103.16.25.109', '1696360052', '__ci_last_regenerate|i:1696360052;'), ('06nbete1173cgfhn99r6bmiehbpv2vv5', '103.16.25.109', '1696360052', '__ci_last_regenerate|i:1696360052;'), ('skfhslajuj7ru2c27mkdp9cheee76vpv', '103.16.25.109', '1696360052', '__ci_last_regenerate|i:1696360052;'), ('i1v6el1pqh7t51ifcp9l0sq3kep6ae98', '103.16.25.109', '1696360052', '__ci_last_regenerate|i:1696360052;'), ('1f5od0lthjm539irjl80avs8oeju6oq9', '103.16.25.109', '1696360052', '__ci_last_regenerate|i:1696360052;'), ('ti76n70klm577b5pnhia8944difbcm3e', '103.16.25.109', '1696360054', '__ci_last_regenerate|i:1696360054;'), ('rd4ml53gkd425v0td68u1jvlok14uc5o', '103.16.25.109', '1696360055', '__ci_last_regenerate|i:1696360055;'), ('f1bve2et9o9pdfap42namddb52blfem3', '103.16.25.109', '1696360055', '__ci_last_regenerate|i:1696360055;'), ('kjj26hdo1crf29l7t1l844t4463cirho', '103.16.25.109', '1696360055', '__ci_last_regenerate|i:1696360055;'), ('7ok731kdc5i8ld1f098mba1c5tovn6bj', '103.16.25.109', '1696360056', '__ci_last_regenerate|i:1696360056;'), ('31l1dt78ga322b7catjecla8kbq87jdh', '103.16.25.109', '1696360056', '__ci_last_regenerate|i:1696360056;'), ('use054ikac6qd4c80d1pm7meti02379b', '103.16.25.109', '1696360056', '__ci_last_regenerate|i:1696360056;'), ('0eiqudhh2ttiaa862ha2rhl4b01iuhll', '103.16.25.109', '1696360056', '__ci_last_regenerate|i:1696360056;'), ('qko1ut22tc8rl4b7k0kjbjthr6vp5jru', '103.16.25.109', '1696360056', '__ci_last_regenerate|i:1696360056;'), ('3hetbgrg4toi5k30i7jppajuaae3mh2f', '103.16.25.109', '1696360056', '__ci_last_regenerate|i:1696360056;'), ('2p3l3l8chrropgmrh0ip70pmmt5rm1l7', '103.16.25.109', '1696360056', '__ci_last_regenerate|i:1696360056;'), ('m8t1shcbt6djjsqv0e089bm223i44nd1', '103.16.25.109', '1696360056', '__ci_last_regenerate|i:1696360056;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('pphga8s4e40qqpenbts53mfhcf6kknur', '103.67.156.140', '1696484937', '__ci_last_regenerate|i:1696360059;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1697348937;user_id|s:1:\"1\";role_id|s:1:\"1\";role|s:5:\"Admin\";name|s:13:\"Noman  Khalid\";is_instructor|s:1:\"1\";admin_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('abg378v7nkv4u31uv5s5ou68dno7v7h2', '103.16.25.109', '1696360064', '__ci_last_regenerate|i:1696360064;'), ('9355ptsgmb8a670u2m9501hr5r5hulmn', '103.16.25.109', '1696360064', '__ci_last_regenerate|i:1696360064;'), ('0oldg46gsg87mfkgmnvuia9beh0li4mm', '103.16.25.109', '1696360065', '__ci_last_regenerate|i:1696360065;'), ('p0b79eobkkehaq40gkajb8sg1qtr8em1', '103.16.25.109', '1696360065', '__ci_last_regenerate|i:1696360065;'), ('7ufhtvfek0ejb0ikmccbk4ivgcfac9e1', '103.16.25.109', '1696360065', '__ci_last_regenerate|i:1696360065;'), ('0bm8kg2egpnvh2vektphd6kt52u34qd4', '103.16.25.109', '1696360065', '__ci_last_regenerate|i:1696360065;'), ('jdiqgcqffst9gedukv1su2l57numpcsv', '103.16.25.109', '1696360065', '__ci_last_regenerate|i:1696360065;'), ('ppb4q3ks3r0aae0ldt032j864qa7tohb', '103.16.25.109', '1696360065', '__ci_last_regenerate|i:1696360065;'), ('0hre4ccfe48ejimvhcc474i9kbv92ig8', '103.16.25.109', '1696360067', '__ci_last_regenerate|i:1696360067;'), ('cjp287j1o7h2cfm67vggun7lbk4vuqab', '103.16.25.109', '1696360067', '__ci_last_regenerate|i:1696360067;'), ('h4d5iqiv7nl1n7cvrs9acva8kqkd1el5', '103.16.25.109', '1696360068', '__ci_last_regenerate|i:1696360068;'), ('qno0dmiskudm682612bvlq3opfgi3r3d', '103.16.25.109', '1696360068', '__ci_last_regenerate|i:1696360068;'), ('ibgc8nnt7hdtpe46gam66gcdh71bhs0h', '103.16.25.109', '1696360068', '__ci_last_regenerate|i:1696360068;'), ('enc2o4247ocrmdkaba6mfulbbrtr39je', '103.16.25.109', '1696360068', '__ci_last_regenerate|i:1696360068;'), ('9617i5r84sjibulvpc7o5akhijqqb10o', '103.16.25.109', '1696360068', '__ci_last_regenerate|i:1696360068;'), ('qh0is8uj5qsirahibvge1bnah4m43123', '103.16.25.109', '1696360068', '__ci_last_regenerate|i:1696360068;'), ('12hh4odpmk0e6gqnepl225gfl19t4vht', '103.16.25.109', '1696360070', '__ci_last_regenerate|i:1696360070;'), ('vff5paddijnjd2fn9pg3mdhcr5rf21o3', '103.16.25.109', '1696360071', '__ci_last_regenerate|i:1696360071;'), ('k3uleqdanlq6oggrhh970j216fok4bi2', '103.16.25.109', '1696360071', '__ci_last_regenerate|i:1696360071;'), ('qsok7odhdcqircfn7ra2eufgki0eec4n', '103.16.25.109', '1696360071', '__ci_last_regenerate|i:1696360071;'), ('vimcs4lgq6gt8bg6i7g251upmtbp5rdf', '103.16.25.109', '1696360071', '__ci_last_regenerate|i:1696360071;'), ('2heqpr4iqla2csnvcck7uehs1snv8gq8', '103.16.25.109', '1696360073', '__ci_last_regenerate|i:1696360073;'), ('82mmhd3646mi1nn7nribuj1k496iicoi', '103.16.25.109', '1696360073', '__ci_last_regenerate|i:1696360073;'), ('stgad3ga72b4chicdupond1nlj32o4pm', '103.16.25.109', '1696360074', '__ci_last_regenerate|i:1696360074;'), ('5prmsg5eevs360tsa829bh083m9mnf6j', '103.16.25.109', '1696360074', '__ci_last_regenerate|i:1696360074;'), ('nr2tbrodsus06arjqpfq3soje3k43pnf', '103.16.25.109', '1696360074', '__ci_last_regenerate|i:1696360074;'), ('71n6g0kut98o7ojki5bdm76tv5t2k0oc', '103.16.25.109', '1696360074', '__ci_last_regenerate|i:1696360074;'), ('580qe1umqpm7oqq62pmlt2c9cvg28204', '103.16.25.109', '1696360074', '__ci_last_regenerate|i:1696360074;'), ('r0qbkvf9clgm2tlkm7d1h0klnvdhbl84', '103.16.25.109', '1696360074', '__ci_last_regenerate|i:1696360074;'), ('ljl705p74169giupb47pqfvm8havtkqn', '103.16.25.109', '1696360075', '__ci_last_regenerate|i:1696360075;'), ('qlvvtiam5ostp4oqjbhs2p9541hg5hat', '103.16.25.109', '1696360075', '__ci_last_regenerate|i:1696360075;'), ('eur248jnh19bt84t2fqp8jnpqrpcgb5p', '103.16.25.109', '1696360075', '__ci_last_regenerate|i:1696360075;'), ('mp0ob350kmd96qdfsjh094onf4d4h56d', '103.16.25.109', '1696360075', '__ci_last_regenerate|i:1696360075;'), ('42hmjlaus7n5u4cduv7n0kqck8ejn3j2', '103.16.25.109', '1696360078', '__ci_last_regenerate|i:1696360078;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('855l6md942jov214i4d5cravtkgvrqct', '103.16.25.109', '1696360083', '__ci_last_regenerate|i:1696360083;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('s56nlucmne8o4k75h0f9cfpsc2g4m0q5', '103.16.25.109', '1696360087', '__ci_last_regenerate|i:1696360087;'), ('0m95j7r3bffhdafj4b4d0d5kprc4ausc', '103.16.25.109', '1696360087', '__ci_last_regenerate|i:1696360087;'), ('0sovltmml6tq3sh1csvs7c1ckerr1j0c', '103.16.25.109', '1696360087', '__ci_last_regenerate|i:1696360087;'), ('u93pupr8va6s5lsddrhmpepl4u3k8h21', '103.16.25.109', '1696360087', '__ci_last_regenerate|i:1696360087;'), ('l7im9i4a0qtkepk5k4drcalnb0t1n7md', '103.16.25.109', '1696360087', '__ci_last_regenerate|i:1696360087;'), ('5gaqdu69ou2bmqovp84ufld9m62irk8d', '103.16.25.109', '1696360087', '__ci_last_regenerate|i:1696360087;'), ('rlc86tspmp3h3fp040q1rrrl4kaqqth8', '103.16.25.109', '1696360088', '__ci_last_regenerate|i:1696360088;'), ('c7apnf2mc6ceo0pjggrbdacuok75fmid', '103.16.25.109', '1696360088', '__ci_last_regenerate|i:1696360088;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('7o9bqr5ckj4fg3ih5h2vqk6a8d80iqkt', '103.16.25.109', '1696360089', '__ci_last_regenerate|i:1696360089;'), ('q26hdv0m2dhqus8lubpe4eka4uk0pme6', '103.16.25.109', '1696360093', '__ci_last_regenerate|i:1696360093;'), ('1ah0v5ulleh9adlc3ernhl93d9r4niia', '103.16.25.109', '1696360093', '__ci_last_regenerate|i:1696360093;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('mqn7gsg62ghscedui998psjnajmscmpi', '103.16.25.109', '1696360093', '__ci_last_regenerate|i:1696360093;'), ('pegqkmfk3s5eenk9oq19onl7dd1vo10h', '103.16.25.109', '1696360095', '__ci_last_regenerate|i:1696360095;'), ('1ctqsk5h090qn56qqppo5437qs31cj1f', '103.16.25.109', '1696360095', '__ci_last_regenerate|i:1696360095;'), ('16qhtt8iph74v9kl8408mm95ttk4jr03', '103.16.25.109', '1696360096', '__ci_last_regenerate|i:1696360096;'), ('bm08gv61c6961i2t1co8h4to8nl6a6qh', '103.16.25.109', '1696360096', '__ci_last_regenerate|i:1696360096;'), ('cu7vf22ih35hhqurmuj4odg4aot5vh4h', '103.16.25.109', '1696360096', '__ci_last_regenerate|i:1696360096;'), ('l3uroml1pb7hh27useurj2loklr3ohq2', '103.16.25.109', '1696360097', '__ci_last_regenerate|i:1696360097;'), ('dfo481n1qbuvn4t55elk7km93b5thphu', '103.16.25.109', '1696360097', '__ci_last_regenerate|i:1696360097;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ss3t58hm6jbhhh3k6nrgagnl7v3ihn5g', '103.16.25.109', '1696360098', '__ci_last_regenerate|i:1696360098;'), ('77n95tok3v89r7eupemcnikujmts5qd4', '103.16.25.109', '1696360111', '__ci_last_regenerate|i:1696360111;'), ('laj9sq1e5pqqpo15s77rc5tbv40tml0l', '103.16.25.109', '1696360111', '__ci_last_regenerate|i:1696360111;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('2rppqn1u7ofr9e7so1latvf6eob7t1a6', '103.16.25.109', '1696360111', '__ci_last_regenerate|i:1696360111;'), ('1ec2vo0lme3ui6jb6v9ro8lglsu7nngo', '103.16.25.109', '1696360113', '__ci_last_regenerate|i:1696360113;'), ('7fc17q1rfh52u47l0d3kgn9hmb8if4a1', '103.16.25.109', '1696360113', '__ci_last_regenerate|i:1696360113;'), ('025ctq56m214eq5m7kf436hki4dm25ks', '103.16.25.109', '1696360117', '__ci_last_regenerate|i:1696360117;'), ('2vao5e7ma3t4lotls4kcdnhtlv882f18', '103.16.25.109', '1696360117', '__ci_last_regenerate|i:1696360117;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('unsg531to5so2vt0jn9u5oic772mqrqc', '103.16.25.109', '1696360118', '__ci_last_regenerate|i:1696360118;'), ('u3jcocri6pivjp7qgca2j2coprdfi4u0', '103.16.25.109', '1696360118', '__ci_last_regenerate|i:1696360118;'), ('jm92rbsg1ip7sdb9ec3er0hagbnqmuek', '103.16.25.109', '1696360118', '__ci_last_regenerate|i:1696360118;'), ('ckmq33u44gdisoci4lq438r384osku4c', '103.16.25.109', '1696360122', '__ci_last_regenerate|i:1696360122;'), ('s8k3m080q074gpsahig7vhounohjn6gi', '103.16.25.109', '1696360122', '__ci_last_regenerate|i:1696360122;'), ('jvcsjck8m7ajbfckc2j6bl8c51n00v9r', '103.16.25.109', '1696360123', '__ci_last_regenerate|i:1696360123;'), ('q09a28nhbnapnjp05csp5ia8q26svsgm', '103.16.25.109', '1696360123', '__ci_last_regenerate|i:1696360123;'), ('f9cubsvqurtcsq8u9irse4pbkoml77cc', '103.16.25.109', '1696360123', '__ci_last_regenerate|i:1696360123;'), ('ej4h4d6i0rpdmjc5b6hoec9spomrq8mg', '103.16.25.109', '1696360123', '__ci_last_regenerate|i:1696360123;'), ('oc9e525mn67vhledk9c7r9fkkr8abjmn', '103.16.25.109', '1696360123', '__ci_last_regenerate|i:1696360123;'), ('6dtm4q1njvm8glpnpinj0ffh7v8l363g', '103.16.25.109', '1696360123', '__ci_last_regenerate|i:1696360123;'), ('h5s3514342430c3nod1bjvm5geq1rk7e', '103.16.25.109', '1696360124', '__ci_last_regenerate|i:1696360124;'), ('8g9lldevpo8edc8ug2unqp9iahosse18', '103.16.25.109', '1696360124', '__ci_last_regenerate|i:1696360124;'), ('nhi13o0s9fbge6rgksv0kchf5e5dkhf9', '103.16.25.109', '1696360124', '__ci_last_regenerate|i:1696360124;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('tt1pm6tjamode0btb1aflf0ekhh2legd', '103.16.25.109', '1696360124', '__ci_last_regenerate|i:1696360124;'), ('3hrm8msrd2fb1fq36pf7n53k6ouojtr3', '103.16.25.109', '1696360138', '__ci_last_regenerate|i:1696360138;'), ('07bbud3bksfej769n61n7iio3e3fm6ob', '103.16.25.109', '1696360138', '__ci_last_regenerate|i:1696360138;'), ('5spr1iao6q09hr359bmk7guqblpveh1i', '103.16.25.109', '1696360139', '__ci_last_regenerate|i:1696360139;'), ('sv4jde64ec7fulej4rar98ofde0lf1kc', '103.16.25.109', '1696360139', '__ci_last_regenerate|i:1696360139;'), ('6vtkhcvp4mfpttdmt7ub2v36jq3g11ga', '103.16.25.109', '1696360139', '__ci_last_regenerate|i:1696360139;'), ('uo202j3jv19p3tuah2hbhcojnvs3gp7j', '103.16.25.109', '1696360139', '__ci_last_regenerate|i:1696360139;'), ('u9mukhadvgltfp4d1qngr4c1tnkhkd79', '103.16.25.109', '1696360139', '__ci_last_regenerate|i:1696360139;'), ('alkplcf5grno804rbfsn3t9te1ldaa8i', '103.16.25.109', '1696360139', '__ci_last_regenerate|i:1696360139;'), ('iff10k82fldpbc3rtckbsjpl9davaroo', '103.16.25.109', '1696360141', '__ci_last_regenerate|i:1696360141;'), ('q757ba7hbaua4kp38krr2jvafb0k5ahe', '103.16.25.109', '1696360141', '__ci_last_regenerate|i:1696360141;'), ('lcd6806eu2asevrubu6vp4uha5va7dq7', '103.16.25.109', '1696360141', '__ci_last_regenerate|i:1696360141;'), ('52s4cjt5r1q63l6fhfsts2hc74c9bblp', '103.16.25.109', '1696360141', '__ci_last_regenerate|i:1696360141;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('hg17p0v27pceajmthgkf1kth69b47gvf', '103.16.25.109', '1696360146', '__ci_last_regenerate|i:1696360146;'), ('1c85t81in81daam00k5579trjfka2g2t', '103.16.25.109', '1696360146', '__ci_last_regenerate|i:1696360146;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('56ajdiqg26jo7hr9ohf0599fek7ff3ag', '103.16.25.109', '1696360155', '__ci_last_regenerate|i:1696360154;'), ('a1gqi84b1s5j7ihncucqcdeftn68g87f', '103.67.156.140', '1696360188', '__ci_last_regenerate|i:1696360188;'), ('6np6hind7ujebro2p1ieu23spt2hn70g', '103.67.156.140', '1696360188', '__ci_last_regenerate|i:1696360188;'), ('qug12ua6b019lrbhg1cn5614rr5tr321', '103.67.156.140', '1696360188', '__ci_last_regenerate|i:1696360188;'), ('n0pqce362ud7okrrbs78gs9s60cjs7j8', '103.67.156.140', '1696360188', '__ci_last_regenerate|i:1696360188;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('l4nfup0m3uo9t09t0arjk53kdqok2fv5', '103.16.25.109', '1696360189', '__ci_last_regenerate|i:1696360189;'), ('90i3hao30eiuarkhh101pcb1km1i54is', '103.16.25.109', '1696360189', '__ci_last_regenerate|i:1696360189;'), ('l7or6stdk67vfjhfi8ru20tdi5uh6apl', '103.16.25.109', '1696360189', '__ci_last_regenerate|i:1696360189;'), ('8u04l5u6v1sedmq6dpeuhpo3vb2rqaqt', '103.16.25.109', '1696360189', '__ci_last_regenerate|i:1696360189;'), ('37fkc1bbj7350mbaegjf0rgj4d7dhffe', '103.16.25.109', '1696360189', '__ci_last_regenerate|i:1696360189;'), ('7argu79nkf4kun880sske6qrthr2mmg6', '103.16.25.109', '1696360189', '__ci_last_regenerate|i:1696360189;'), ('f5sn82f5n1bafpp2d02vorcq7r0l4no4', '103.67.156.140', '1696360190', '__ci_last_regenerate|i:1696360190;'), ('rnrr5o3inre5rt1ljb8n7rj8ka65m785', '103.16.25.109', '1696360191', '__ci_last_regenerate|i:1696360191;'), ('dn1ont83smks1f76jtdo9r8amdjeu48k', '103.16.25.109', '1696360191', '__ci_last_regenerate|i:1696360191;'), ('jno24osli5fjnruv03jiviqtvepl49c9', '103.16.25.109', '1696360191', '__ci_last_regenerate|i:1696360191;'), ('ed45rg68ivvmlemsopeapt19fc4fmjas', '103.16.25.109', '1696360191', '__ci_last_regenerate|i:1696360191;'), ('rhbo62t67hmaflr77al1k9jgj46iei74', '103.16.25.109', '1696360191', '__ci_last_regenerate|i:1696360191;'), ('q71renosv744960ejdsrh89v8ap58m3h', '103.16.25.109', '1696360191', '__ci_last_regenerate|i:1696360191;'), ('gala73lkl3qi0e33ltipmb1h8cpguvde', '103.16.25.109', '1696360191', '__ci_last_regenerate|i:1696360191;'), ('4j8nfnmb5gc4v35h3t7479g7nt2o4q74', '103.16.25.109', '1696360191', '__ci_last_regenerate|i:1696360191;'), ('ukj38o0gd0654oomckf75rpstfde9458', '103.16.25.109', '1696360194', '__ci_last_regenerate|i:1696360194;'), ('8oupq4q1q4apt2uk538j7r543pub9cr5', '103.16.25.109', '1696360194', '__ci_last_regenerate|i:1696360194;'), ('uvmvmcosk92kpbubta0p8kb5feefsrh3', '103.16.25.109', '1696360194', '__ci_last_regenerate|i:1696360194;'), ('2kjbudu8t6p6nrcpa6c4ch1eong1vdm0', '103.16.25.109', '1696360194', '__ci_last_regenerate|i:1696360194;'), ('4sqva9tvn9hjsalj0pkee3sdtrieluup', '103.16.25.109', '1696360194', '__ci_last_regenerate|i:1696360194;'), ('cti3cf7omsmudcgdd1ifqmgin25jugtg', '103.16.25.109', '1696360194', '__ci_last_regenerate|i:1696360194;'), ('9ki6gd7evq8lgd3tacrpfqjepla40gce', '103.16.25.109', '1696360194', '__ci_last_regenerate|i:1696360194;'), ('rn9kgn87cb17vhs409hjnlr23umqumvt', '103.16.25.109', '1696360194', '__ci_last_regenerate|i:1696360194;'), ('14hi1r62tcoo9nued3diup8ls7u4gnge', '103.16.25.109', '1696360196', '__ci_last_regenerate|i:1696360196;'), ('ca3t7e513jgogr3p71nms1gar1bpc33s', '103.16.25.109', '1696360196', '__ci_last_regenerate|i:1696360196;'), ('gpleg56qgqr7cv4ept94a3r136od3n8b', '103.16.25.109', '1696360196', '__ci_last_regenerate|i:1696360196;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('bc0h6csds0gem7ij1ip7a71p5d0tg9ge', '103.16.25.109', '1696360196', '__ci_last_regenerate|i:1696360196;'), ('aedrmeraa6i5gpua848nl40hgovf402l', '103.16.25.109', '1696360198', '__ci_last_regenerate|i:1696360198;'), ('vfo7rdrhc4426phnl1thh9v5kar87p94', '103.67.156.140', '1696360199', '__ci_last_regenerate|i:1696360199;'), ('k6uvjf9hgfjfmdp8fiqcjg2ptp98u2u2', '103.16.25.109', '1696360215', '__ci_last_regenerate|i:1696360215;'), ('jfu09maqb2i5peo687mgk83eipiiegr2', '103.16.25.109', '1696360215', '__ci_last_regenerate|i:1696360215;'), ('m1tnsp988movdt6tlq182f36l6kh4o6c', '103.16.25.109', '1696360218', '__ci_last_regenerate|i:1696360218;'), ('1cb4aac2vg8hsfj0o1sape8seb8n3qnr', '103.16.25.109', '1696360218', '__ci_last_regenerate|i:1696360218;'), ('agqver5op10u2oiip94q4cmc4vlh9lem', '103.16.25.109', '1696360219', '__ci_last_regenerate|i:1696360219;'), ('9b5oi1qbe9vfguenhv9fe3t9lfm222hs', '103.16.25.109', '1696360219', '__ci_last_regenerate|i:1696360219;'), ('toe3r0c5uacnve4m08bg3tqakv66oslg', '103.16.25.109', '1696360219', '__ci_last_regenerate|i:1696360219;'), ('ludkfvovi4es9o4j7rlcbjmkl4hkr958', '103.16.25.109', '1696360219', '__ci_last_regenerate|i:1696360219;'), ('6v1j7mi2q5ke6i41te0d5v1334fdl54o', '103.16.25.109', '1696360219', '__ci_last_regenerate|i:1696360219;'), ('s2090dmn17oo1eomf671j3usk4amb3al', '103.16.25.109', '1696360219', '__ci_last_regenerate|i:1696360219;'), ('1m3cuooos5vv7kr76moqoldvgiv13n19', '103.16.25.109', '1696360220', '__ci_last_regenerate|i:1696360220;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('otnrlfe6r30b6mruvo2hk1i5ta7ccpjf', '103.16.25.109', '1696360220', '__ci_last_regenerate|i:1696360220;'), ('eplvqm6j7u6lr3d3uvkp9qmog3ssg88q', '103.16.25.109', '1696360220', '__ci_last_regenerate|i:1696360220;'), ('5q5jd5mmm36h7k4vpd3qbrikaciaj0pt', '103.16.25.109', '1696360220', '__ci_last_regenerate|i:1696360220;'), ('sseapootkh41hccso1esipoe5g598jm7', '103.16.25.109', '1696360226', '__ci_last_regenerate|i:1696360226;'), ('hnp60ggkdv6n622v9qr80bbeh60usmrj', '103.16.25.109', '1696360226', '__ci_last_regenerate|i:1696360226;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('2qt4pikccqqtr4jm1qn1p8295kqjr417', '103.67.156.140', '1696360239', '__ci_last_regenerate|i:1696360239;'), ('35r8c6aq8k36q7p50av6162bquliqqbj', '103.67.156.140', '1696360243', '__ci_last_regenerate|i:1696360243;'), ('tqqq5etulqdvkufvos69h4tr3qpbp4ti', '103.67.156.140', '1696360243', '__ci_last_regenerate|i:1696360243;'), ('r99e2uevt9468urs1jicntmjupme37vk', '103.67.156.140', '1696360243', '__ci_last_regenerate|i:1696360243;'), ('lirc10fsjmo6e7ha9ls1n8pvd1cocksg', '103.67.156.140', '1696360243', '__ci_last_regenerate|i:1696360243;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('bt6shonlfmk308iq8apje625bi12g6a6', '103.67.156.140', '1696360245', '__ci_last_regenerate|i:1696360245;'), ('cm4u1h7l0hboujb14vmul48fal7kj8p5', '103.67.156.140', '1696360264', '__ci_last_regenerate|i:1696360264;'), ('tsvp7sqrd53v7f6c9hfcu8dbqas2498k', '103.67.156.140', '1696360266', '__ci_last_regenerate|i:1696360266;'), ('3mi1di1ml59fqg1ulc41qi4l1sj01r0v', '103.67.156.140', '1696360266', '__ci_last_regenerate|i:1696360266;'), ('fvovs86ad3rkpajs85aag6n3lv77nbkm', '103.67.156.140', '1696360267', '__ci_last_regenerate|i:1696360267;'), ('44q7v2cbml9b0tv5f9uk64m196hnr67h', '103.67.156.140', '1696360267', '__ci_last_regenerate|i:1696360267;'), ('p0hdg6n9fuhln6q6hv34sqqnvij286ih', '103.67.156.140', '1696360267', '__ci_last_regenerate|i:1696360267;'), ('t0utq7eos4jo3vonsc0uib8bc09669bp', '103.67.156.140', '1696360267', '__ci_last_regenerate|i:1696360267;'), ('913lpmuhdoulvbibdo0a5m46jq8lq5f5', '103.67.156.140', '1696360267', '__ci_last_regenerate|i:1696360267;'), ('2kdnbgl1js2212teeq0al2amomb15cpb', '103.67.156.140', '1696360267', '__ci_last_regenerate|i:1696360267;'), ('7qeia64qph9sikjhgunqrlqrt65ga419', '103.67.156.140', '1696360269', '__ci_last_regenerate|i:1696360269;'), ('l5g3hj2tf6eqft8qcdg63nrivv0chroo', '103.67.156.140', '1696360269', '__ci_last_regenerate|i:1696360269;'), ('k57tklft1o1e4ivi7p9qshcqka248v1c', '103.67.156.140', '1696360269', '__ci_last_regenerate|i:1696360269;'), ('orncghmvd525gpukfg14kie18rtdk09a', '103.67.156.140', '1696360269', '__ci_last_regenerate|i:1696360269;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('1b6iemjpenb77oru3l39fvj3747lpm16', '103.67.156.140', '1696360272', '__ci_last_regenerate|i:1696360272;'), ('lipkjka9hk2l70gtd4i5h6djh6kb9g71', '103.67.156.140', '1696360272', '__ci_last_regenerate|i:1696360272;'), ('u1c7uj5h64ep6f4cof7rr9viq7ofd464', '103.67.156.140', '1696360272', '__ci_last_regenerate|i:1696360272;'), ('86ihsiv42ufb9adbha1q7eosa16i35em', '103.67.156.140', '1696360272', '__ci_last_regenerate|i:1696360272;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('p4v5n7sh5t12rdh9vbfiddarv5k74c6i', '103.67.156.140', '1696360274', '__ci_last_regenerate|i:1696360274;'), ('4k1sh0qu3997g6qfoc1agce9h748ohh9', '103.67.156.140', '1696360280', '__ci_last_regenerate|i:1696360280;'), ('f95uec6qjqorsrt4gp79ckcue1k7l9cm', '103.67.156.140', '1696360283', '__ci_last_regenerate|i:1696360283;'), ('gs7tqbmj5v1r4hpt3dtas0h9i2pqpuhe', '103.67.156.140', '1696360283', '__ci_last_regenerate|i:1696360283;'), ('bjktqq9jlnn0hkad5hrr1iep01pdfmrs', '103.67.156.140', '1696360283', '__ci_last_regenerate|i:1696360283;'), ('knsnqu0lsnc0i7bftm76da3ndnp3jtk3', '103.67.156.140', '1696360283', '__ci_last_regenerate|i:1696360283;'), ('pglbsa0p6q3mdobtoil2bk9p2mmhdope', '103.67.156.140', '1696360283', '__ci_last_regenerate|i:1696360283;'), ('usbvffah9d3k2m2iqg4jdae9e7ui31b4', '103.67.156.140', '1696360283', '__ci_last_regenerate|i:1696360283;'), ('nvcb80aoe65o11epud8a9ud6r0hobjsp', '103.16.25.109', '1696360283', '__ci_last_regenerate|i:1696360283;'), ('leipq87sc27c0kp0ngtn3j86o1a4l62e', '103.16.25.109', '1696360283', '__ci_last_regenerate|i:1696360283;'), ('91iens9nhnod21b6qid9tiu0bm068tue', '103.16.25.109', '1696360284', '__ci_last_regenerate|i:1696360284;'), ('4mi8krbjo8oq6fuasf4p756cse3akad7', '103.16.25.109', '1696360284', '__ci_last_regenerate|i:1696360284;'), ('lnni796o2l6bv32m3eb72tf32440v397', '103.16.25.109', '1696360284', '__ci_last_regenerate|i:1696360284;'), ('ip5cmm1vbeq67tfmjht9r4gttknp7k1s', '103.16.25.109', '1696360284', '__ci_last_regenerate|i:1696360284;'), ('8cmen4lvamhgj19gg0a8rc2gprgiscn8', '103.16.25.109', '1696360284', '__ci_last_regenerate|i:1696360284;'), ('20j6bkl878ip0nma317u85d6mqrppj8r', '103.16.25.109', '1696360284', '__ci_last_regenerate|i:1696360284;'), ('7vk3ogc87tks5lg3btcmva0oko0q7n43', '103.16.25.109', '1696360285', '__ci_last_regenerate|i:1696360285;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('1f75ep4618igspvibbt4vjmqau2fokvn', '103.16.25.109', '1696360285', '__ci_last_regenerate|i:1696360285;'), ('5pu66c4rqj2vpm08eahik5b2prvgrdrj', '103.16.25.109', '1696360285', '__ci_last_regenerate|i:1696360285;'), ('njebfataqgeqhvtirleuv2ucskat5hvi', '103.16.25.109', '1696360285', '__ci_last_regenerate|i:1696360285;'), ('7521etprcm062si37nn1o1oe0u1t0v1g', '103.67.156.140', '1696360289', '__ci_last_regenerate|i:1696360289;'), ('4239c4h0l9c9meepcar7bjfleoqd3pc3', '103.16.25.109', '1696360291', '__ci_last_regenerate|i:1696360291;'), ('42prm14otnqhs2q8t75cuh7deneaa4vj', '103.16.25.109', '1696360291', '__ci_last_regenerate|i:1696360291;'), ('fsubo1jmdt6jj6c7omj2b31145lp4l0p', '103.16.25.109', '1696360291', '__ci_last_regenerate|i:1696360291;'), ('s74js0msq7v49pjda301fb119chf76c1', '103.16.25.109', '1696360291', '__ci_last_regenerate|i:1696360291;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('s6672gki4ujltektsr4079eo6q67c68i', '103.16.25.109', '1696360305', '__ci_last_regenerate|i:1696360305;'), ('mkehk98eco2a6nj4ue1dqm9chpteenqq', '103.16.25.109', '1696360305', '__ci_last_regenerate|i:1696360305;'), ('15rontkc9mh320uebglc1jsjvh60uklj', '103.16.25.109', '1696360306', '__ci_last_regenerate|i:1696360306;'), ('p4s4s8a10lsu6prv5q7hkimqmqanhup5', '103.16.25.109', '1696360306', '__ci_last_regenerate|i:1696360306;'), ('lv4haap5v8o1qtmam4qgblfdd45sojt6', '103.16.25.109', '1696360306', '__ci_last_regenerate|i:1696360306;'), ('9c4b133afs4pi79kf54hnfcvi1m8l0n2', '103.16.25.109', '1696360306', '__ci_last_regenerate|i:1696360306;'), ('3690cnvljr6lgetgvpjnj4pgk44e4q1i', '103.16.25.109', '1696360306', '__ci_last_regenerate|i:1696360306;'), ('ogu3bshmoajufp43q41kb50abvmko6mv', '103.16.25.109', '1696360306', '__ci_last_regenerate|i:1696360306;'), ('p9p7pbmam1g6vuj69mdeqkn14h92jrmt', '103.16.25.109', '1696360309', '__ci_last_regenerate|i:1696360309;'), ('4lcu86bjfq9ch80bjt6m274clas4fp5j', '103.16.25.109', '1696360309', '__ci_last_regenerate|i:1696360309;'), ('si2vckckki8laruh837mfbva0223jo9n', '103.16.25.109', '1696360309', '__ci_last_regenerate|i:1696360309;'), ('a2s0v7ncbeal61k0hifc71o1e3u9vufd', '103.16.25.109', '1696360309', '__ci_last_regenerate|i:1696360309;'), ('6ai0tmpv61tbjp6geto3if3jvdvu5sor', '103.16.25.109', '1696360309', '__ci_last_regenerate|i:1696360309;'), ('kneia9rt8ih9sofnf522nteoua54ckvi', '103.16.25.109', '1696360309', '__ci_last_regenerate|i:1696360309;'), ('d0chs6hl3b88q2qmkmhhkil0qstbm9qb', '103.16.25.109', '1696360309', '__ci_last_regenerate|i:1696360309;'), ('mud5ln8cijujqf5q41jq5lkhfucuf6u6', '103.16.25.109', '1696360309', '__ci_last_regenerate|i:1696360309;'), ('3re7r1m6rpnt0ajb94js83lt653g8nif', '103.16.25.109', '1696360310', '__ci_last_regenerate|i:1696360310;'), ('tj6hols59jurr6ucvcp24l9vpl39qbis', '103.16.25.109', '1696360310', '__ci_last_regenerate|i:1696360310;'), ('3ldejk7q5q1ft0a2o2efkggksjm89tte', '103.16.25.109', '1696360310', '__ci_last_regenerate|i:1696360310;'), ('fgciu0hhs0pd9eae73idnci8l433fjr7', '103.16.25.109', '1696360310', '__ci_last_regenerate|i:1696360310;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('qo4qf56lmulgj566gf974rvdlt2su982', '103.16.25.109', '1696360312', '__ci_last_regenerate|i:1696360312;'), ('ujudlm342s9vbhthkvdsl0o46aeivk2k', '103.16.25.109', '1696360322', '__ci_last_regenerate|i:1696360322;'), ('mevpf27ppg553q0fg07hg6iidihlpccp', '103.16.25.109', '1696360322', '__ci_last_regenerate|i:1696360322;'), ('ainu6i6si9npio3jsdpvr6rquobn8f7r', '103.16.25.109', '1696360323', '__ci_last_regenerate|i:1696360323;'), ('3ik054jtdnunrmosbn2u7pak4uiukanf', '103.16.25.109', '1696360323', '__ci_last_regenerate|i:1696360323;'), ('njg0qlsvub3cmg09lffcjb57ieok48d9', '103.16.25.109', '1696360323', '__ci_last_regenerate|i:1696360323;'), ('nj9ocpr6hpof9md6uan0ikdu6m33ht8v', '103.16.25.109', '1696360323', '__ci_last_regenerate|i:1696360323;'), ('3p79ufrsbq4nql1o4atnnabsjougotot', '103.16.25.109', '1696360323', '__ci_last_regenerate|i:1696360323;'), ('388e9brgsi42qta782omht8r7qfvop3p', '103.16.25.109', '1696360323', '__ci_last_regenerate|i:1696360323;'), ('f1e779u5tanqr97s5bfk2f011o2qbfpr', '103.67.156.140', '1696360353', '__ci_last_regenerate|i:1696360353;'), ('0dmqk4tikou432mc5pseq5nrq9r6harl', '103.16.25.109', '1696360361', '__ci_last_regenerate|i:1696360361;'), ('j757d7j8851ehiho1u8slh5cbpnvou0l', '103.16.25.109', '1696360365', '__ci_last_regenerate|i:1696360365;'), ('fuke3r2av2qen4ojblocuhoa3bs5959r', '103.16.25.109', '1696360365', '__ci_last_regenerate|i:1696360365;'), ('nmojhf0p1kh3jl590bahfk8fn2jmhhdb', '103.16.25.109', '1696360365', '__ci_last_regenerate|i:1696360365;'), ('8oq1dk8c2jq0mgdslh3mlecga7caf40k', '103.16.25.109', '1696360365', '__ci_last_regenerate|i:1696360365;'), ('f9eegmavam41eptuuo46fpf5j0f46a2r', '103.16.25.109', '1696360365', '__ci_last_regenerate|i:1696360365;'), ('ig8ssse7vh602cc38ad3tlaa9sonbuhu', '103.16.25.109', '1696360365', '__ci_last_regenerate|i:1696360365;'), ('f9fmhh8ig9qhr5bcsr6neog6jvm2r7bj', '103.16.25.109', '1696360365', '__ci_last_regenerate|i:1696360365;'), ('hdju4kis89sntnoa2gfdejp8f704fkk2', '103.67.156.140', '1696360373', '__ci_last_regenerate|i:1696360373;'), ('hmfrqfcfcgeessj9clmmf7hqg35s2gha', '103.16.25.109', '1696360377', '__ci_last_regenerate|i:1696360377;'), ('l5flpf1jho34rl67vdqk9pdthajvo39t', '103.16.25.109', '1696360381', '__ci_last_regenerate|i:1696360381;'), ('9333hm3bitp4mmtqhm6o607oe2krvgqh', '103.16.25.109', '1696360381', '__ci_last_regenerate|i:1696360381;'), ('jd0pk8ah8iln49rjeh3algmkt7a45ra3', '103.16.25.109', '1696360381', '__ci_last_regenerate|i:1696360381;'), ('ae5k65l65be14niiimjvlsek4v2f9djj', '103.16.25.109', '1696360381', '__ci_last_regenerate|i:1696360381;'), ('b2hf3sgvcs6v3elamo6vvd3r7r3chkb8', '103.16.25.109', '1696360381', '__ci_last_regenerate|i:1696360381;'), ('e6aqrfropi9dpr9emr8c7rkll86rbfp3', '103.16.25.109', '1696360381', '__ci_last_regenerate|i:1696360381;'), ('al7gat6phmg5sjuti942tjnjctac3nkv', '103.16.25.109', '1696360381', '__ci_last_regenerate|i:1696360381;'), ('052tc6g45a85gltu717e0tgd69rqe8mf', '103.67.156.140', '1696360393', '__ci_last_regenerate|i:1696360393;'), ('bphqkb07ppah1867hcvp9cei6qqntvje', '103.67.156.140', '1696360410', '__ci_last_regenerate|i:1696360410;'), ('5ed9ubcekc709mcpokpiih75inl19pff', '103.67.156.140', '1696360412', '__ci_last_regenerate|i:1696360412;'), ('l51vov3q5ro93aith73hlnem1far6e56', '103.67.156.140', '1696360492', '__ci_last_regenerate|i:1696360492;'), ('o5vsda13skna03nvinvpkkjoa83tsj55', '103.67.156.140', '1696360492', '__ci_last_regenerate|i:1696360492;'), ('s8v1ksqmv3jm0ra1jahn5ve1dabtspdl', '103.67.156.140', '1696360493', '__ci_last_regenerate|i:1696360493;'), ('dle2g1dpmf32a9buaj1p3p4e9cr9e4q1', '103.67.156.140', '1696360493', '__ci_last_regenerate|i:1696360493;'), ('119ne0ogcrmdkq6g4c5uq4d44n186hk9', '103.67.156.140', '1696360493', '__ci_last_regenerate|i:1696360493;'), ('9oo36sju1vesgj588pnh2rt1upslh9ot', '103.67.156.140', '1696360493', '__ci_last_regenerate|i:1696360493;'), ('5sgon37r978dnea9htqg3ep1tjfu0oj4', '103.67.156.140', '1696360493', '__ci_last_regenerate|i:1696360493;'), ('vq6bakb2558574mokjjpas4390qqnsoa', '103.67.156.140', '1696360493', '__ci_last_regenerate|i:1696360493;'), ('ep0okfq7cequveftfs46643lvm3tpqmh', '103.67.156.140', '1696360510', '__ci_last_regenerate|i:1696360510;'), ('5sdhgniku7qc54anv48186sdim20m58j', '103.16.25.109', '1696360562', '__ci_last_regenerate|i:1696360562;'), ('roa9bf0virgf7vd6kf3hp11j51np32ni', '103.16.25.109', '1696360580', '__ci_last_regenerate|i:1696360580;'), ('7fl5lq8jah76jbkl3vmdoq462k1u13t0', '103.16.25.109', '1696360584', '__ci_last_regenerate|i:1696360584;'), ('7ksgmf2t5m5v396psfq64thpomvlrrk0', '103.16.25.109', '1696360584', '__ci_last_regenerate|i:1696360584;'), ('pt55d6gvtporiuevkpqhgs26gd2tq5go', '103.16.25.109', '1696360584', '__ci_last_regenerate|i:1696360584;'), ('8s2gljtpf8t3petnkqlv2pl5ev3li9vp', '103.16.25.109', '1696360584', '__ci_last_regenerate|i:1696360584;'), ('9spj3lub930thf22crjvbfgrjersk7nj', '103.16.25.109', '1696360584', '__ci_last_regenerate|i:1696360584;'), ('fc29ijqb8h05j1ipvi6skvhb3teqrsdk', '103.16.25.109', '1696360584', '__ci_last_regenerate|i:1696360584;'), ('d9s7em3latc9dr7vn4bk052hrjhb9e1l', '103.16.25.109', '1696360584', '__ci_last_regenerate|i:1696360584;'), ('4dr8t83f24lsumc4joc3849o5cgpv470', '103.67.156.140', '1696360593', '__ci_last_regenerate|i:1696360593;'), ('ufdq1q06oun01ilip51pq3hfiunr6l55', '103.16.25.109', '1696360669', '__ci_last_regenerate|i:1696360669;'), ('t0egc1huvrefiogo328he1gg1vfubr86', '103.16.25.109', '1696360673', '__ci_last_regenerate|i:1696360673;'), ('63tv4cnb570uute27mak9pqe42013hpi', '103.16.25.109', '1696360673', '__ci_last_regenerate|i:1696360673;'), ('t69u0v5imse1g4256ajlcion05pvau1m', '103.16.25.109', '1696360673', '__ci_last_regenerate|i:1696360673;'), ('sev6do0mkmhivpljsdi3j7m7u5jejkhl', '103.16.25.109', '1696360673', '__ci_last_regenerate|i:1696360673;'), ('24ljfnkc1h79fg2v92olmpp87mbmvhve', '103.16.25.109', '1696360673', '__ci_last_regenerate|i:1696360673;'), ('ch83qa12mkmukb5v8fhkc1uc7s41r6oj', '103.16.25.109', '1696360673', '__ci_last_regenerate|i:1696360673;'), ('7c97k9901l458r49ki7b7tk3bicv17h1', '103.16.25.109', '1696360674', '__ci_last_regenerate|i:1696360674;'), ('lhhf1gaqsfnirc34dljcrrggnbchvo6p', '103.16.25.109', '1696360689', '__ci_last_regenerate|i:1696360689;'), ('rcj0772jm17jgi6ulnbaok4tn7899ujk', '103.16.25.109', '1696360693', '__ci_last_regenerate|i:1696360693;'), ('1q6qkns6aho85i4gf196mqonc2v3nn0i', '103.16.25.109', '1696360693', '__ci_last_regenerate|i:1696360693;'), ('tdrodgkcrbmohcv1e5ee34kkt42nn7v4', '103.16.25.109', '1696360693', '__ci_last_regenerate|i:1696360693;'), ('sb8a8fag9l7nqemmcfoiua6ln6stbguq', '103.16.25.109', '1696360693', '__ci_last_regenerate|i:1696360693;'), ('e4t28jspsrcvffanptj6r8ne12en9cou', '103.16.25.109', '1696360693', '__ci_last_regenerate|i:1696360693;'), ('45f68sc5ahksqqqv7pok9pd6mkk12qcb', '103.16.25.109', '1696360693', '__ci_last_regenerate|i:1696360693;'), ('nngce979kuhhee7djuldonunhllfbfab', '103.16.25.109', '1696360693', '__ci_last_regenerate|i:1696360693;'), ('6fo1ca2hr1heam05r5q0bojoqm7ob0t2', '103.16.25.109', '1696360704', '__ci_last_regenerate|i:1696360704;'), ('tp728p25f4nlp2ju8a28o0683dsqmq1j', '103.16.25.109', '1696360707', '__ci_last_regenerate|i:1696360707;'), ('ssqicp8liqv1rarv6uae2mpjreknetof', '103.16.25.109', '1696360707', '__ci_last_regenerate|i:1696360707;'), ('jnmaf830hanu0bq4vv4i68bim3ithlvr', '103.16.25.109', '1696360707', '__ci_last_regenerate|i:1696360707;'), ('l0qa8igjq68kd38dou13g21v9aeuiv27', '103.16.25.109', '1696360707', '__ci_last_regenerate|i:1696360707;'), ('dqrp3igesjddc77e25m09ibl2hor1g2p', '103.16.25.109', '1696360707', '__ci_last_regenerate|i:1696360707;'), ('91a0p4bp53b6n910jjicf56uro5sb532', '103.16.25.109', '1696360708', '__ci_last_regenerate|i:1696360708;'), ('dmjkle0r044tb8v8e7mo026ik7bhf9mv', '103.16.25.109', '1696360708', '__ci_last_regenerate|i:1696360708;'), ('j6qh7ldia3m61ba51ke03noh2s44be0c', '103.67.156.140', '1696360721', '__ci_last_regenerate|i:1696360721;'), ('3aaff9ah308mh11lcbctlad90qj21t9g', '103.67.156.140', '1696360726', '__ci_last_regenerate|i:1696360726;'), ('0p813eksar07d16fvbp5tj1ipjludnf8', '103.67.156.140', '1696360726', '__ci_last_regenerate|i:1696360726;'), ('3du9d732810q6d40ldjr7a2k9v5e1kmi', '103.67.156.140', '1696360727', '__ci_last_regenerate|i:1696360727;'), ('qqpbk62643s1esa2189b7j671aqkg45m', '103.67.156.140', '1696360727', '__ci_last_regenerate|i:1696360727;'), ('lcfvv8scutfpqnoeuih7flu0dav4h3bf', '103.67.156.140', '1696360727', '__ci_last_regenerate|i:1696360727;'), ('ur1ra2a0is5uaa9n1lagf9tkb197gl50', '103.67.156.140', '1696360727', '__ci_last_regenerate|i:1696360727;'), ('dggebn1ob6e0dgbg0mvj3pq4v04p2i03', '103.67.156.140', '1696360727', '__ci_last_regenerate|i:1696360727;'), ('o5uq65c30oe2gc7l1o76k5t5rbgre1ng', '103.67.156.140', '1696360727', '__ci_last_regenerate|i:1696360727;'), ('09ovca45v8jk4ib81c8jg39b6rqdudv2', '103.67.156.140', '1696360914', '__ci_last_regenerate|i:1696360914;'), ('teck47nd5j2oc6ttgqnifdakkito6h66', '103.16.25.109', '1696360930', '__ci_last_regenerate|i:1696360930;'), ('tq1hcu2o7ghvmeib34gnr60j9c843sof', '103.16.25.109', '1696360930', '__ci_last_regenerate|i:1696360930;'), ('ch0dq6cf5b5mrp0g4seue4vsscpmmr71', '103.16.25.109', '1696360930', '__ci_last_regenerate|i:1696360930;'), ('f3sm8o5fpavp7n4ncth31bje3divqiks', '103.16.25.109', '1696360930', '__ci_last_regenerate|i:1696360930;'), ('99n34ttvou6g6j2e2ufo9783loe7cr49', '103.16.25.109', '1696360930', '__ci_last_regenerate|i:1696360930;'), ('fe2s7ivs63d9aj1af8f8caampcngti19', '103.16.25.109', '1696360931', '__ci_last_regenerate|i:1696360931;'), ('j3ntgj2b924t7f4bhjms9jaf2t85mber', '103.16.25.109', '1696360939', '__ci_last_regenerate|i:1696360939;'), ('2kbhtspk7bp1hunf41ub5efff8hgrmjj', '103.16.25.109', '1696360939', '__ci_last_regenerate|i:1696360939;'), ('k13s8ge7v1ao3o47ppcqi7ps25t2ks6r', '103.16.25.109', '1696360939', '__ci_last_regenerate|i:1696360939;'), ('qk2rfjc8n3rbkdts1d6af8f8a59h6f09', '103.16.25.109', '1696360939', '__ci_last_regenerate|i:1696360939;'), ('f902t8em5emeqq3ppj9sj92pqbcbqhv7', '103.16.25.109', '1696360939', '__ci_last_regenerate|i:1696360939;'), ('24vitutg29tm9ps9g3hvbilklpdvnujb', '103.16.25.109', '1696360939', '__ci_last_regenerate|i:1696360939;'), ('1kovnlmj4d1phe0ij7agcklmue5111e0', '103.16.25.109', '1696369938', '__ci_last_regenerate|i:1696360952;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1697224973;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('jd6ll1pdfsmdnb9qkbmd2e71tl70oqbb', '103.67.156.140', '1696361002', '__ci_last_regenerate|i:1696361002;'), ('j9g2343k58kid262ocb7u9tednoboj7r', '103.67.156.140', '1696361141', '__ci_last_regenerate|i:1696361141;'), ('dqu7deuguh8cmud069lhisoa3ktt646d', '103.67.156.140', '1696361393', '__ci_last_regenerate|i:1696361393;'), ('laihi0snk7invi2tjkel9gbcu6qfdsog', '103.67.156.140', '1696361415', '__ci_last_regenerate|i:1696361415;'), ('0ejjjkq9iuo2p66b2616b33do979a1g2', '103.67.156.140', '1696361421', '__ci_last_regenerate|i:1696361421;'), ('cd48rvgobbrqbgbnm6q951ai83quhpae', '103.67.156.140', '1696361448', '__ci_last_regenerate|i:1696361448;'), ('13arlg4gbv86fdsqvf5hjbt7e202q9v2', '103.67.156.140', '1696361500', '__ci_last_regenerate|i:1696361500;'), ('iet0tpf57qp6eleajonl8409n58q2i74', '103.67.156.140', '1696361503', '__ci_last_regenerate|i:1696361503;'), ('n4s8ljisp63m5e3id8vijstnbpkldbmo', '103.67.156.140', '1696361503', '__ci_last_regenerate|i:1696361503;'), ('aofbs7qn6buu9r2tr8glfjqcvt315be6', '103.67.156.140', '1696361503', '__ci_last_regenerate|i:1696361503;'), ('a989ppn67hcdqrouatrmdu5l7sf5fmbl', '103.67.156.140', '1696361503', '__ci_last_regenerate|i:1696361503;'), ('jr3kgbnurmmh74ndacqd704stv1q3j10', '103.67.156.140', '1696361503', '__ci_last_regenerate|i:1696361503;'), ('8389ruricoudgthne5osnln9ra3f3coc', '103.67.156.140', '1696361503', '__ci_last_regenerate|i:1696361503;'), ('88d2u2ub3e3u6qedduu2a7fq7mstmtqb', '103.67.156.140', '1696361504', '__ci_last_regenerate|i:1696361504;'), ('vd1ctb6264i1vlcn7pr722epkougkl4r', '103.67.156.140', '1696361589', '__ci_last_regenerate|i:1696361589;'), ('c70tc49kb76vf0u1ijef84b7l98u191r', '103.67.156.140', '1696361590', '__ci_last_regenerate|i:1696361590;'), ('1dv3mm2hp3jffrlv3hgad73l3vc8fncp', '103.16.25.109', '1696361657', '__ci_last_regenerate|i:1696361649;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}cart_items|a:0:{}language|s:7:\"english\";'), ('6vjk08u2rmdgoq1s86nttiq992na8ju1', '103.67.156.140', '1696361702', '__ci_last_regenerate|i:1696361702;'), ('p2v8qtktkamrer54rnj8ngrf984i27nu', '103.67.156.140', '1696361705', '__ci_last_regenerate|i:1696361705;'), ('qat5sfv4a8sdriub3lfacghfughp7ggc', '103.67.156.140', '1696361705', '__ci_last_regenerate|i:1696361705;'), ('bkdmu4tnh76565j7va93srmt7lqb01pd', '103.67.156.140', '1696361705', '__ci_last_regenerate|i:1696361705;'), ('pfp9jh6pu0n959ro6uld9v3osk22vm48', '103.67.156.140', '1696361705', '__ci_last_regenerate|i:1696361705;'), ('do008i1u3u8m1ff7amkmkvcd1lj3c3vv', '103.67.156.140', '1696361705', '__ci_last_regenerate|i:1696361705;'), ('qrclskrqgav576cui5humd66ej8rh53e', '103.67.156.140', '1696361705', '__ci_last_regenerate|i:1696361705;'), ('bo70j7lh3mal7cf86j0f17oo6h75srhq', '103.67.156.140', '1696361705', '__ci_last_regenerate|i:1696361705;'), ('04pdc6gi9tetgfc80b8cacpfhtunupbr', '103.67.156.140', '1696361732', '__ci_last_regenerate|i:1696361732;'), ('og4fiud6prgmmj1i3nik5iooe13v3o71', '103.67.156.140', '1696361733', '__ci_last_regenerate|i:1696361733;'), ('opelqk6c6v1k0g7vmu7dv6i8p2q32359', '103.67.156.140', '1696361733', '__ci_last_regenerate|i:1696361733;'), ('v3859p45c7plv9ijfatrkc03878nmsk4', '103.67.156.140', '1696361733', '__ci_last_regenerate|i:1696361733;'), ('6h8o130486futpheajeok4mhfol2lnni', '103.67.156.140', '1696361733', '__ci_last_regenerate|i:1696361733;'), ('sscepjmn5tlrlegb4fec06mbchmsiq05', '103.67.156.140', '1696361733', '__ci_last_regenerate|i:1696361733;'), ('1g4tojqaellme8ctevlgpb1tupci0m2f', '103.67.156.140', '1696361733', '__ci_last_regenerate|i:1696361733;'), ('p7pvj98qjppo3npk2d469kn9uvem5lu4', '103.67.156.140', '1696361734', '__ci_last_regenerate|i:1696361734;'), ('doo0vhjbna8rat651v6l9ri53uissf08', '103.67.156.140', '1696427606', '__ci_last_regenerate|i:1696361734;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1696404939;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('vklbpedjuee0hllpcl10u1hlitd52qvp', '103.67.156.140', '1696361735', '__ci_last_regenerate|i:1696361735;'), ('jo79o13s7vtlifo4sl5sf3448eaql7mv', '103.67.156.140', '1696361735', '__ci_last_regenerate|i:1696361735;'), ('dd7di3ilnsgns0dem8ve5nl04meg3fa3', '103.67.156.140', '1696361736', '__ci_last_regenerate|i:1696361736;'), ('jk80v6f704ioilq5n9q7vgaklm0au068', '103.67.156.140', '1696361736', '__ci_last_regenerate|i:1696361736;'), ('ei068ptk63g8sc0ma1e05hu48plo3mo4', '103.67.156.140', '1696361736', '__ci_last_regenerate|i:1696361736;'), ('shk84kfdt03arbfg0pmeb2efa8acq6rk', '103.67.156.140', '1696361736', '__ci_last_regenerate|i:1696361736;'), ('sf4rs9utpdefidq5duaq602dveb5mcvb', '103.67.156.140', '1696361736', '__ci_last_regenerate|i:1696361736;'), ('hol250jsk1h18e9be63nogiq2v42clmf', '103.67.156.140', '1696361736', '__ci_last_regenerate|i:1696361736;'), ('ui8qg0537ktj6esrbu4332rf4eabttnk', '103.67.156.140', '1696361738', '__ci_last_regenerate|i:1696361738;'), ('6cr5p68uhqol6r7isk4usnthsak5e0bl', '103.67.156.140', '1696361738', '__ci_last_regenerate|i:1696361738;'), ('3amp4tfioos7vgnooualcg9la701nfdc', '103.67.156.140', '1696361738', '__ci_last_regenerate|i:1696361738;'), ('4n8m1luo9vqpmah00uqcijv0mom44bia', '103.67.156.140', '1696361738', '__ci_last_regenerate|i:1696361738;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('to3fho8gf77hn836rkq94ar8b05cdpki', '103.67.156.140', '1696361740', '__ci_last_regenerate|i:1696361740;'), ('1ndi5tp2eq81t57dfenvnr1t55hev366', '103.67.156.140', '1696361745', '__ci_last_regenerate|i:1696361745;'), ('131q8qj1su1nte9ft0bp1s9lc4vktbaf', '103.67.156.140', '1696361748', '__ci_last_regenerate|i:1696361748;'), ('ielao8cv70npqem15dis5p9jto1j3103', '103.16.25.109', '1696361799', '__ci_last_regenerate|i:1696361799;'), ('ad10idr2lr82dc35t6glsnltoe4vo6q7', '103.16.25.109', '1696361807', '__ci_last_regenerate|i:1696361807;'), ('qqje8tjm4f1bu6lifvlpv0sdfta0ff2q', '103.16.25.109', '1696361807', '__ci_last_regenerate|i:1696361807;'), ('fkts8pmqbe8p09a6ef5ussm10l25f3fn', '103.16.25.109', '1696361807', '__ci_last_regenerate|i:1696361807;'), ('quoc3q8pgf65b6p40tm76uma7hshk39i', '103.16.25.109', '1696361807', '__ci_last_regenerate|i:1696361807;'), ('de3bhhsb929gv34umdaroth7n9esb5ae', '103.16.25.109', '1696361807', '__ci_last_regenerate|i:1696361807;'), ('gshm5e9ak4h935c5e0d89mpnrd7f8857', '103.16.25.109', '1696361807', '__ci_last_regenerate|i:1696361807;'), ('k1g6851dtt0dh88i50469cgf6lm3tnic', '103.67.156.140', '1696361829', '__ci_last_regenerate|i:1696361829;'), ('oe2cgjcs5oqs1f14qjtskufsdonnp7lp', '103.16.25.109', '1696361884', '__ci_last_regenerate|i:1696361884;'), ('6odj8cjmqakseoloqi1pihb3m73fr95i', '103.16.25.109', '1696361884', '__ci_last_regenerate|i:1696361884;'), ('s4tev9gbnebtssu9murk54m94qhc3vo5', '103.16.25.109', '1696361884', '__ci_last_regenerate|i:1696361884;'), ('qal6c3t42mbg22p38n1mgob7pa1ag2np', '103.16.25.109', '1696361884', '__ci_last_regenerate|i:1696361884;'), ('qi2ntklafpsqqup8ma92bv1vod42uuq8', '103.16.25.109', '1696361884', '__ci_last_regenerate|i:1696361884;'), ('evrjvvm0nprnfh5ghsi5s3q56u6o08vu', '103.16.25.109', '1696361885', '__ci_last_regenerate|i:1696361885;'), ('9fbqhnbgf0f6brtdcrbffoe5miviiqfb', '103.16.25.109', '1696361984', '__ci_last_regenerate|i:1696361984;'), ('23n0aelidm4mbivvtk9hgvco546dru2q', '103.16.25.109', '1696361984', '__ci_last_regenerate|i:1696361984;'), ('je6dcomiqhbgh9r4gs37scftair532oe', '103.16.25.109', '1696361984', '__ci_last_regenerate|i:1696361984;'), ('lem0jrt5nnde3i852kgg228i0jav2oov', '103.16.25.109', '1696361984', '__ci_last_regenerate|i:1696361984;'), ('2j9asr3npulokmq365s064f7v6an2369', '103.16.25.109', '1696361984', '__ci_last_regenerate|i:1696361984;'), ('ibp7eji23c8ghfea6b3jl0n6ars4moj7', '103.16.25.109', '1696361984', '__ci_last_regenerate|i:1696361984;'), ('hr2ti4qcp7umq3lo76vjv1tlgm5mvatu', '103.16.25.109', '1696361989', '__ci_last_regenerate|i:1696361989;'), ('9q43ah3bd8721u60qhso678c5sp24gem', '103.16.25.109', '1696361989', '__ci_last_regenerate|i:1696361989;'), ('1u2gslc7uunoqap23mu1mn8136abc5kl', '103.16.25.109', '1696361990', '__ci_last_regenerate|i:1696361990;'), ('n0a5p4gr4826m1c4v39tvj5ipfr5rtb6', '103.16.25.109', '1696361990', '__ci_last_regenerate|i:1696361990;'), ('rkuolco1hii8ibqpn4hn5l742u47m5cq', '103.16.25.109', '1696361990', '__ci_last_regenerate|i:1696361990;'), ('l2cvqjid05vk3f7skqktmhrkhkd430bu', '103.16.25.109', '1696361990', '__ci_last_regenerate|i:1696361990;'), ('5fjgcrr2u2ddvup6i5d282o5hq4aon2v', '103.16.25.109', '1696361990', '__ci_last_regenerate|i:1696361990;'), ('bpufp6nds0rdq9hde9l24imkvjh5fgnf', '103.16.25.109', '1696361990', '__ci_last_regenerate|i:1696361990;'), ('nrjmvkifru98km0uj6i79qsg9ildbprs', '103.16.25.109', '1696361993', '__ci_last_regenerate|i:1696361993;'), ('9kgtenlk0jg32knq4tovb7i1i4a38i97', '103.16.25.109', '1696361993', '__ci_last_regenerate|i:1696361993;'), ('e21n7a2e6fmn6mm2dq5107mmg5k888ot', '103.16.25.109', '1696361993', '__ci_last_regenerate|i:1696361993;'), ('6numdrf5eq7ljlhv7lo6v3e55ddhgc9s', '103.16.25.109', '1696361993', '__ci_last_regenerate|i:1696361993;'), ('ca16jrporlhfam1o8qvak76hgua1rac0', '103.16.25.109', '1696361993', '__ci_last_regenerate|i:1696361993;'), ('fh9p3o74ibapvbcp46nvs4ivam54v61e', '103.16.25.109', '1696361993', '__ci_last_regenerate|i:1696361993;'), ('on9crgtmqmv1h9uu895jqvr89f4ovf4q', '103.16.25.109', '1696361993', '__ci_last_regenerate|i:1696361993;'), ('kcshndv9kl7g928uhbd2j1ahl2smna9t', '103.16.25.109', '1696361993', '__ci_last_regenerate|i:1696361993;'), ('6evaslju2c9tv4f5g46nkemhugf3acd2', '103.67.156.140', '1696362203', '__ci_last_regenerate|i:1696362203;'), ('anu3leg369nbv3idgagr582ehq0nafdv', '103.67.156.140', '1696362203', '__ci_last_regenerate|i:1696362203;'), ('aa2obd38mic0vun7fe19n0o88rgda2g7', '103.67.156.140', '1696362204', '__ci_last_regenerate|i:1696362204;'), ('h1oh5qkp825cbaui7cjj4o8ibn957fjv', '103.67.156.140', '1696362204', '__ci_last_regenerate|i:1696362204;'), ('j08g5ebpu9trq1gocu4aci1rdab58ggn', '103.67.156.140', '1696362204', '__ci_last_regenerate|i:1696362204;'), ('b53fj0kemgvcuuf0o1dhhe6rt1m3k2h3', '103.67.156.140', '1696362204', '__ci_last_regenerate|i:1696362204;'), ('sroct2ddq95cg13ajtik3cl4iom7n25r', '103.67.156.140', '1696362204', '__ci_last_regenerate|i:1696362204;'), ('tqrt6tmr9sk8ijl3ttc7fee9hqlqmoee', '103.67.156.140', '1696362204', '__ci_last_regenerate|i:1696362204;'), ('0imujmo0v6qa4utcdhm22ud13dcihu6r', '37.111.218.191', '1696362232', '__ci_last_regenerate|i:1696362232;'), ('79fsf2tdunoapk8e4ifmbuch9e0ne0nj', '37.111.218.191', '1696362232', '__ci_last_regenerate|i:1696362232;'), ('m6b6hs751uimo2kov2dk8ma2j3lj0rn8', '37.111.218.191', '1696362232', '__ci_last_regenerate|i:1696362232;'), ('jorg3jjv6a3ofp1bdhceudftds74mpk1', '37.111.218.191', '1696362232', '__ci_last_regenerate|i:1696362232;'), ('ah0nqruqbghmh15h1vnlchnkr05ptlca', '37.111.218.191', '1696362232', '__ci_last_regenerate|i:1696362232;'), ('qusmn1of9073jhevgb6rvoihrqicc8a4', '37.111.218.191', '1696362232', '__ci_last_regenerate|i:1696362232;'), ('gkguailiim3dbnnrdf18q2aarnfutjjf', '103.16.25.109', '1696362332', '__ci_last_regenerate|i:1696362332;'), ('dt452f4d8n8p9ln6rku4qg1g6r34q13j', '103.16.25.109', '1696362349', '__ci_last_regenerate|i:1696362349;'), ('qqq1e0makpdvi5g9l8g07rde1met7l2m', '103.16.25.109', '1696362349', '__ci_last_regenerate|i:1696362349;'), ('2daqtku6l79v2fs0ivspmgfqmbcts1lu', '103.16.25.109', '1696362349', '__ci_last_regenerate|i:1696362349;'), ('ge87dtfccmso641hov29ru8fn1l6r4or', '103.16.25.109', '1696362349', '__ci_last_regenerate|i:1696362349;'), ('1fbjldg0dnle4i5mbis4rv45ve2v495k', '103.16.25.109', '1696362349', '__ci_last_regenerate|i:1696362349;'), ('aue5a2pra8hk9ihtpp5j3dti87b8n405', '103.16.25.109', '1696362349', '__ci_last_regenerate|i:1696362349;'), ('7tptgsu7mfom4huhf3d0r7oddm69g7fn', '103.16.25.109', '1696362353', '__ci_last_regenerate|i:1696362353;'), ('h5eatl43i822takh6r1tteech1rrssak', '103.16.25.109', '1696362353', '__ci_last_regenerate|i:1696362353;'), ('jpurlv3tki75s43vakq17kc4vnu97521', '103.16.25.109', '1696362353', '__ci_last_regenerate|i:1696362353;'), ('bpgrddbjhkkbtanjgrgvm4uq1si4gdvn', '103.16.25.109', '1696362353', '__ci_last_regenerate|i:1696362353;'), ('2qar1ue1ki9cm0qis5a7fbh9lhp5nhh6', '103.16.25.109', '1696362353', '__ci_last_regenerate|i:1696362353;'), ('reggfg92caa59v6qlv2ihcds2o266b74', '103.16.25.109', '1696362353', '__ci_last_regenerate|i:1696362353;'), ('3onv95fbmglfvdl17n449abn9l1fb49s', '103.16.25.109', '1696362429', '__ci_last_regenerate|i:1696362429;'), ('h965ql6ctft3ahdsgbk3q41lqib6iu6a', '103.16.25.109', '1696362429', '__ci_last_regenerate|i:1696362429;'), ('lglgvm8orkvo3m59vmrdc63a7j0ra0q2', '103.16.25.109', '1696362429', '__ci_last_regenerate|i:1696362429;'), ('ld57hdunhp0omi40rlsiaq4c4kujbcki', '103.16.25.109', '1696362429', '__ci_last_regenerate|i:1696362429;'), ('s93074ds93dbo41mhqi32mjh364qlusr', '103.16.25.109', '1696362429', '__ci_last_regenerate|i:1696362429;'), ('ntdee9ok8ui9nrtnrd41d54h4jp17tr8', '103.16.25.109', '1696362430', '__ci_last_regenerate|i:1696362430;'), ('ekevqvh7lahpjn67qsgt87edag5c9bfa', '103.16.25.109', '1696362916', '__ci_last_regenerate|i:1696362916;'), ('eetmg1j3ij87utno4s5sp96mlakve5rr', '103.16.25.109', '1696362920', '__ci_last_regenerate|i:1696362920;'), ('7h0950eaaeg7v3ukmiuickan1egvr5pr', '103.16.25.109', '1696362920', '__ci_last_regenerate|i:1696362920;'), ('6mvbnt8r6v4vps4nhgpe2dukoi56ksrt', '103.16.25.109', '1696362920', '__ci_last_regenerate|i:1696362920;'), ('bir5o83sofk6uldvckc16669msnaltqg', '103.16.25.109', '1696362920', '__ci_last_regenerate|i:1696362920;'), ('rh20b2lbgm5ob4ei9rfia640gmq6cb1b', '103.16.25.109', '1696362920', '__ci_last_regenerate|i:1696362920;'), ('9h9dgc9o2f769ro0vbpcb4t2li2rau3s', '103.16.25.109', '1696362920', '__ci_last_regenerate|i:1696362920;'), ('s96htgrvkvaq7ne1vrllbcdh0ai0sd6h', '103.16.25.109', '1696362921', '__ci_last_regenerate|i:1696362921;'), ('3mlesin6p7dvotdsji5jk94o7d27on4e', '103.16.25.109', '1696362998', '__ci_last_regenerate|i:1696362998;'), ('57kl6pmvrr7vkbcq4e26r67ttq2g43va', '103.16.25.109', '1696362998', '__ci_last_regenerate|i:1696362998;'), ('jkh6ibq3jpcpnrvk9e4oof2ldra6ldcn', '103.16.25.109', '1696362998', '__ci_last_regenerate|i:1696362998;'), ('8r5lgl7lp7hq0fhkr1a9jd2o87mpjcu8', '103.16.25.109', '1696362998', '__ci_last_regenerate|i:1696362998;'), ('ekcq75k55vc9nsg2i4v8k318vvqaearq', '103.16.25.109', '1696362998', '__ci_last_regenerate|i:1696362998;'), ('vgo0gfjuoqmd9tfku28fhqq91m7vlt6d', '103.16.25.109', '1696362999', '__ci_last_regenerate|i:1696362999;'), ('7q8ali0eratf3a98go479fgt4tqfumc6', '103.16.25.109', '1696363072', '__ci_last_regenerate|i:1696363072;'), ('5d1sooua17gddbrsi996ug8i4k3s952l', '103.16.25.109', '1696363072', '__ci_last_regenerate|i:1696363072;'), ('bn534a3fcssg85jvjiqcpe5tuipflhmf', '103.16.25.109', '1696363072', '__ci_last_regenerate|i:1696363072;'), ('5huh13io77cvtdd6ptms131nk16dtv4m', '103.16.25.109', '1696363072', '__ci_last_regenerate|i:1696363072;'), ('a44v2rdf5c6n2bcnclbctkjq7a4cfi8r', '103.16.25.109', '1696363072', '__ci_last_regenerate|i:1696363072;'), ('e0pr3kplq9f53j01rformuof227mtr89', '103.16.25.109', '1696363072', '__ci_last_regenerate|i:1696363072;'), ('u0uhgsgqiueqc90l157hqu5vgoj7sito', '103.16.25.109', '1696363300', '__ci_last_regenerate|i:1696363300;'), ('50stdnvmhsr4ttfi6ff795uoq6r4phs0', '103.16.25.109', '1696363300', '__ci_last_regenerate|i:1696363300;'), ('amvps4aaldo72otnh3qv1a6rm6ppqs8v', '103.16.25.109', '1696363300', '__ci_last_regenerate|i:1696363300;'), ('7qhphardt300uas5v1lqgsg0j3og73u2', '103.16.25.109', '1696363300', '__ci_last_regenerate|i:1696363300;'), ('i3crf3bd3ae000itkt3hp3pkthmde458', '103.16.25.109', '1696363300', '__ci_last_regenerate|i:1696363300;'), ('j081mhgjouptssksrlsvlthfb0he2oj9', '103.16.25.109', '1696363300', '__ci_last_regenerate|i:1696363300;'), ('l72k0am0b98sff357hpo4ma2h3k5qcd1', '103.16.25.109', '1696363307', '__ci_last_regenerate|i:1696363307;'), ('97ptj4mg159i9ejnbi6gksbhre9ie4hn', '103.16.25.109', '1696363307', '__ci_last_regenerate|i:1696363307;'), ('q3mhb48126qf48uc6h2s1hfllm444qno', '103.16.25.109', '1696363307', '__ci_last_regenerate|i:1696363307;'), ('hn0cf8a4edlelo7lia5pt74kbkjpkjal', '103.16.25.109', '1696363307', '__ci_last_regenerate|i:1696363307;'), ('bc3vkjvtfkdn4ilflkh8hlt29nmejpka', '103.16.25.109', '1696363307', '__ci_last_regenerate|i:1696363307;'), ('0uiqtov0rpm7fbiflt7mu1kr0b34r8eh', '103.16.25.109', '1696363307', '__ci_last_regenerate|i:1696363307;'), ('4tn099l3su1gia6dcvd6tam4uensa961', '103.16.25.109', '1696363310', '__ci_last_regenerate|i:1696363310;'), ('rusrtcfii5hvition78jvpqi8aj8q49o', '103.16.25.109', '1696363310', '__ci_last_regenerate|i:1696363310;'), ('q4lht7di9oi8obkojtc04c5h5d08iqqb', '103.16.25.109', '1696363310', '__ci_last_regenerate|i:1696363310;'), ('fnej8armlq224psf6qc4nrsmff21fjc5', '103.16.25.109', '1696363310', '__ci_last_regenerate|i:1696363310;'), ('84daoqd8f1q4fa31ib9ab4vq1dmeji77', '103.16.25.109', '1696363310', '__ci_last_regenerate|i:1696363310;'), ('l6ghhq1tks8j6ecqssfcoqrrbrcn9ng1', '103.16.25.109', '1696363310', '__ci_last_regenerate|i:1696363310;'), ('etpfhnke5fs8n0kvbgqi4bqkoro8ab7d', '103.16.25.109', '1696363691', '__ci_last_regenerate|i:1696363691;'), ('kamfft4bf4397cp8vu75afm9fcglip8c', '103.16.25.109', '1696363691', '__ci_last_regenerate|i:1696363691;'), ('8fed0c5vcmjb05dkko6ht2dfqs82l89p', '103.16.25.109', '1696363691', '__ci_last_regenerate|i:1696363691;'), ('vs23tncpdbet31b0kcntmm1r7cil0ose', '103.16.25.109', '1696363691', '__ci_last_regenerate|i:1696363691;'), ('jh9anb9q9numskmobqm8jdhn3ju72dsj', '103.16.25.109', '1696363691', '__ci_last_regenerate|i:1696363691;'), ('0rnmhrah51qe8gepmt92dnf62611ct39', '103.16.25.109', '1696363691', '__ci_last_regenerate|i:1696363691;'), ('bvg2itp2tm44ko7u7i2q4pp2qj30ablk', '103.16.25.109', '1696363696', '__ci_last_regenerate|i:1696363696;'), ('k9ku48di0fmg4pli50epfv384lqjt5oq', '103.16.25.109', '1696363697', '__ci_last_regenerate|i:1696363696;'), ('ci06rt77fbt0kphiknn63ls2mnhnk993', '103.16.25.109', '1696363697', '__ci_last_regenerate|i:1696363697;'), ('340osicaoqhgm4rno3uea5hld31g48a7', '103.16.25.109', '1696363697', '__ci_last_regenerate|i:1696363697;'), ('709s1qggs06lfojjdkasu3hi01s1vt9t', '103.16.25.109', '1696363697', '__ci_last_regenerate|i:1696363697;'), ('69655qdj5fsma31lphg9uadbvhumj5nj', '103.16.25.109', '1696363697', '__ci_last_regenerate|i:1696363697;'), ('astged5oph1tmm3m8ud7t0s0cm5uqusg', '103.16.25.109', '1696363713', '__ci_last_regenerate|i:1696363713;'), ('d2pud0me42cg87n5kih2nrub6jv5181l', '103.16.25.109', '1696364394', '__ci_last_regenerate|i:1696364394;'), ('8q4u72lt6e8anggse8lsh71gppqg9k2s', '103.16.25.109', '1696364404', '__ci_last_regenerate|i:1696364404;'), ('bgit1pmechshdkb2un3sufpijqtj7mlo', '103.16.25.109', '1696364404', '__ci_last_regenerate|i:1696364404;'), ('ri4ep7a3p6vdts2l7bnqq0m9aa4safuh', '103.16.25.109', '1696364405', '__ci_last_regenerate|i:1696364405;'), ('jc85464qb751j2rrl0ei1u732orug5et', '103.16.25.109', '1696364405', '__ci_last_regenerate|i:1696364405;'), ('mv5ritsrc25jemdp9a71ieddp0u7ed7o', '103.16.25.109', '1696364405', '__ci_last_regenerate|i:1696364405;'), ('lpe6lb2i6dq1cbrrtf362otkkggjg8sc', '103.16.25.109', '1696364405', '__ci_last_regenerate|i:1696364405;'), ('m5u3k117530rmu5o9i67qf939r4sj65b', '103.16.25.109', '1696364405', '__ci_last_regenerate|i:1696364405;'), ('pn53hk45utti0nctjlf3ggtmfj14vrn7', '103.16.25.109', '1696364405', '__ci_last_regenerate|i:1696364405;'), ('33i4d1noh27ifm3iv5dr1hmd0d5dtrm9', '103.16.25.109', '1696364406', '__ci_last_regenerate|i:1696364406;'), ('puds7bjbbljcv68f00d0tca71s8ackvf', '103.16.25.109', '1696364406', '__ci_last_regenerate|i:1696364406;'), ('sfcq822mclqg99d823scgcadn8ethevg', '103.16.25.109', '1696364406', '__ci_last_regenerate|i:1696364406;'), ('5bforutngfj3id9vm8ahdovpdrkdc3ll', '103.16.25.109', '1696364406', '__ci_last_regenerate|i:1696364406;'), ('ot0vunn4hg4trur5ed5vv8ovd8utmik6', '103.16.25.109', '1696364406', '__ci_last_regenerate|i:1696364406;'), ('1dq1veja6f1cvhu4p2p29qkmp9o0qgdd', '103.16.25.109', '1696364406', '__ci_last_regenerate|i:1696364406;'), ('tudihlb2jo504evligbr1u6tqup9mr05', '103.16.25.109', '1696364415', '__ci_last_regenerate|i:1696364415;'), ('s924v7hfhm4n6ullaf2jmlbhkrfdqn49', '103.16.25.109', '1696364415', '__ci_last_regenerate|i:1696364415;'), ('qknsofvgcin0q9n981oiea22bcb6ecaf', '103.16.25.109', '1696364415', '__ci_last_regenerate|i:1696364415;'), ('020igclfcqaufus3r58l0pgvfqj6lc7m', '103.16.25.109', '1696364415', '__ci_last_regenerate|i:1696364415;'), ('0urjqsmn2qu9p31t7h9oi51hanppfgbi', '103.16.25.109', '1696364415', '__ci_last_regenerate|i:1696364415;'), ('4irajb6dnqh8ahflel02mq1t52e5fjab', '103.16.25.109', '1696364416', '__ci_last_regenerate|i:1696364416;'), ('efefvctk20ad6g5g3afs1kak6dp9c41t', '103.16.25.109', '1696364423', '__ci_last_regenerate|i:1696364423;'), ('dsi2k4m732j1l3qm2n8i9s6km907hqr5', '103.16.25.109', '1696364423', '__ci_last_regenerate|i:1696364423;'), ('da92g70nb5pj3p1geclsa74u8r2kigfp', '103.16.25.109', '1696364423', '__ci_last_regenerate|i:1696364423;'), ('9bbgjedd13ce5cc3alp25qu1s3c82t9u', '103.16.25.109', '1696364423', '__ci_last_regenerate|i:1696364423;'), ('855pnejoglrb8on2gt9fvs8o71jgotmu', '103.16.25.109', '1696364423', '__ci_last_regenerate|i:1696364423;'), ('2kamkm2iq42ar8m4f9vueg16nr0uhe5p', '103.16.25.109', '1696364423', '__ci_last_regenerate|i:1696364423;'), ('m8urh4e7i3jlq0lt9g3bgd921im2msjs', '103.16.25.109', '1696364905', '__ci_last_regenerate|i:1696364905;'), ('oupqomasdkgt2a2vnd1prta210d9421q', '103.16.25.109', '1696364913', '__ci_last_regenerate|i:1696364913;'), ('hqou8f9hgodsnht8km42kg0795kim7bg', '103.16.25.111', '1696364913', '__ci_last_regenerate|i:1696364913;'), ('2vs45r8dofn2m8u01lddtpop1fqmt96e', '103.16.25.109', '1696364914', '__ci_last_regenerate|i:1696364914;'), ('9v04s4qutp350kr8dnnomvrvmdh9ck7h', '103.16.25.109', '1696364914', '__ci_last_regenerate|i:1696364914;'), ('pj59nh7qt4r8v6et1ugv4uheet1bjj0m', '103.16.25.109', '1696364914', '__ci_last_regenerate|i:1696364914;'), ('cn454t9vuktgl1l2nbm6qbk3c7dsqepk', '103.16.25.109', '1696364914', '__ci_last_regenerate|i:1696364914;'), ('tesu0ih35svtg5bvm0qnevsaco6t6jlk', '103.16.25.109', '1696364914', '__ci_last_regenerate|i:1696364914;'), ('nmd2p5i8qogg9m03dbonp1hplv5b4ja4', '103.16.25.109', '1696364914', '__ci_last_regenerate|i:1696364914;'), ('drussk3cpqm090vfk7vf1u2nmi3tarek', '103.16.25.109', '1696364914', '__ci_last_regenerate|i:1696364914;'), ('8g893ng6bp33tpqmig6tmlvg8avf0k1q', '103.16.25.109', '1696364914', '__ci_last_regenerate|i:1696364914;'), ('ldivo8mjsjnvuo49n8stn3607c8heb9j', '103.16.25.109', '1696364914', '__ci_last_regenerate|i:1696364914;'), ('halrcaacg42kkgpn8cg64accm57km19c', '103.16.25.109', '1696364914', '__ci_last_regenerate|i:1696364914;'), ('3l39pk7bqa40ca8mqeqgaruac75303m7', '103.16.25.109', '1696364914', '__ci_last_regenerate|i:1696364914;'), ('rhegpeahdni576h7r0avquhlnqbs1ph7', '103.16.25.109', '1696364915', '__ci_last_regenerate|i:1696364915;'), ('fqqvcc8ssidrtnc1baqh0aelj8u0k9tf', '103.16.25.109', '1696364921', '__ci_last_regenerate|i:1696364921;'), ('p4ihtf7uqc6ilmso33rmtih6aaqsaqlm', '103.16.25.109', '1696364921', '__ci_last_regenerate|i:1696364921;'), ('jre44tqqimn0gk9cr9b5f3tmlg8aol0h', '103.16.25.109', '1696364921', '__ci_last_regenerate|i:1696364921;'), ('h9ukg4kvvd0832p86s49ennfookbt5gm', '103.16.25.109', '1696364921', '__ci_last_regenerate|i:1696364921;'), ('qdkrrge1sjrkaut17qt58ipuajbl2uhq', '103.16.25.109', '1696364921', '__ci_last_regenerate|i:1696364921;'), ('l2par1is5n1lmdjlknpki4i2ld7tuqnk', '103.16.25.109', '1696364921', '__ci_last_regenerate|i:1696364921;'), ('1qrugoegnb9ra1v7mraphnsljjeblnq5', '103.16.25.109', '1696365021', '__ci_last_regenerate|i:1696365021;'), ('aqfnt6k2u8blhglkml4rorqcpo8hlsnu', '103.16.25.109', '1696365021', '__ci_last_regenerate|i:1696365021;'), ('iomet7fitgodi5jqsuok67ks9bhcb9rm', '103.16.25.109', '1696365021', '__ci_last_regenerate|i:1696365021;'), ('nq23v969giftlb2pmqfk74illm7uc9r0', '103.16.25.109', '1696365021', '__ci_last_regenerate|i:1696365021;'), ('dfo0b51gtjrrn8u4fjajjt8f05jffaic', '103.16.25.109', '1696365021', '__ci_last_regenerate|i:1696365021;'), ('r9ervoajpfbsld44vie676p9ape5805h', '103.16.25.109', '1696365021', '__ci_last_regenerate|i:1696365021;'), ('5mfd57mln7qtn3ncmgdla2g3tkapnvmg', '103.16.25.109', '1696365030', '__ci_last_regenerate|i:1696365030;'), ('l8kph4ird8k3mer7rl09dc8toianq703', '103.16.25.109', '1696365030', '__ci_last_regenerate|i:1696365030;'), ('d8ovaioc2598cdhk8q4q89n0hqrmn9gv', '103.16.25.109', '1696365030', '__ci_last_regenerate|i:1696365030;'), ('va9d1ckrhnbqhopjh70b9g178o1b5l1u', '103.16.25.109', '1696365030', '__ci_last_regenerate|i:1696365030;'), ('ljcqncv30e3qn0ulm10uhq4b494rcq0f', '103.16.25.109', '1696365030', '__ci_last_regenerate|i:1696365030;'), ('0qr64msg7b3ucogq225sn68uqoo8c3tt', '103.16.25.109', '1696365030', '__ci_last_regenerate|i:1696365030;'), ('0kc4fk3c5rcgod5jc15pjpkq84595ihu', '103.16.25.109', '1696365034', '__ci_last_regenerate|i:1696365034;'), ('g3d9kiogirugij3hirhb0uklmadp7klb', '103.16.25.109', '1696365034', '__ci_last_regenerate|i:1696365034;'), ('4oe4ea6v9487n67nl8f154fevv423s7a', '103.16.25.109', '1696365034', '__ci_last_regenerate|i:1696365034;'), ('h012ifubdqco9igtdk06cn3tp85k5vav', '103.16.25.109', '1696365034', '__ci_last_regenerate|i:1696365034;'), ('995t1pej36d3t21tdsfomses9197pub0', '103.16.25.109', '1696365034', '__ci_last_regenerate|i:1696365034;'), ('ajcbo3mb2rraet9n9j8pq4lffnqvbidp', '103.16.25.109', '1696365034', '__ci_last_regenerate|i:1696365034;'), ('mc5uogdm9ogi1316k5k0mpdp7u5tc1o7', '103.16.25.109', '1696365084', '__ci_last_regenerate|i:1696365084;'), ('njq1fqlgi64q2n0n3659a1poktq93ckh', '103.16.25.109', '1696365094', '__ci_last_regenerate|i:1696365094;'), ('bj7urj9rj4j1lmiuqqaqo6t9idlm7plo', '103.16.25.109', '1696365096', '__ci_last_regenerate|i:1696365096;'), ('5c4g6o1ajvhor533julra76bqg2lgmhb', '103.16.25.109', '1696365096', '__ci_last_regenerate|i:1696365096;'), ('kqtdm9lpfiimqbmho6etijstl7r0bcuc', '103.16.25.109', '1696365096', '__ci_last_regenerate|i:1696365096;'), ('8q24im85378hglff95ndpmsma5nutv5o', '103.16.25.109', '1696365096', '__ci_last_regenerate|i:1696365096;'), ('rne3prfcleuj0ab9i4cbe46qmsc74pvc', '103.16.25.109', '1696365096', '__ci_last_regenerate|i:1696365096;'), ('dm3h90e8uek5umimg0d2vqs3vd9ukfq5', '103.16.25.109', '1696365096', '__ci_last_regenerate|i:1696365096;'), ('f9ihdkhqcqk5q4g129r3pkia07ub2sne', '103.16.25.109', '1696365096', '__ci_last_regenerate|i:1696365096;'), ('j0p39q0lh720idvlqmoegbohk72ug326', '103.16.25.109', '1696365096', '__ci_last_regenerate|i:1696365096;'), ('5h6tb84cdigq1lh8hf6pb9ltfus709gn', '103.16.25.109', '1696365097', '__ci_last_regenerate|i:1696365097;'), ('aehb34gp5ogjpl96breudha7q28tp1m3', '103.16.25.109', '1696365097', '__ci_last_regenerate|i:1696365097;'), ('17kdhn0aa2bhefkpqh8bmph8j7jtnntu', '103.16.25.109', '1696365097', '__ci_last_regenerate|i:1696365097;'), ('ant30jvehobc029luuo1l7rvb46vdup1', '103.16.25.109', '1696365097', '__ci_last_regenerate|i:1696365097;'), ('0ud13e7maqftj31p8loteealgfmbougi', '103.16.25.109', '1696365097', '__ci_last_regenerate|i:1696365097;'), ('baiav1etpfabeobklnip1733shjlvft7', '103.16.25.109', '1696365097', '__ci_last_regenerate|i:1696365097;'), ('gmm2v8j0jt5p71qmtfj2ahoau6q9cmpc', '103.16.25.109', '1696365153', '__ci_last_regenerate|i:1696365153;'), ('knclco964g6c2b8ljonjre5g3pogasju', '103.16.25.109', '1696366205', '__ci_last_regenerate|i:1696366205;'), ('t8gcvri37udp8rpf9asv7h5h0d66iabs', '103.16.25.109', '1696366209', '__ci_last_regenerate|i:1696366209;'), ('q0tqrjn236eovmoqdolp60oh1jvibi3s', '103.16.25.109', '1696366209', '__ci_last_regenerate|i:1696366209;'), ('5fokgd58lo1mjvo1b0v1so5nnqmk5830', '103.16.25.109', '1696366209', '__ci_last_regenerate|i:1696366209;'), ('ir3des76ft51jqp64rhb1pvfqne1m47b', '103.16.25.109', '1696366209', '__ci_last_regenerate|i:1696366209;'), ('fta3bi5hako5smh6eg08i0786ka5vs4q', '103.16.25.109', '1696366209', '__ci_last_regenerate|i:1696366209;'), ('ebu8jbsgpo13ie7l0e8rl8hf0vk7qa5s', '103.16.25.109', '1696366209', '__ci_last_regenerate|i:1696366209;'), ('f7606lba1vtsoorkp0900qa7i5vj24er', '103.16.25.109', '1696366209', '__ci_last_regenerate|i:1696366209;'), ('pa4qi48du0e8etu10p2kas5qeomumm67', '103.16.25.109', '1696366222', '__ci_last_regenerate|i:1696366222;'), ('t5qbvi9i1om30rb0hg4f3ik0m2aji6cl', '103.16.25.109', '1696366222', '__ci_last_regenerate|i:1696366222;'), ('qjnqmbpbeni83fec3a9rr23ffol7etec', '103.16.25.109', '1696366222', '__ci_last_regenerate|i:1696366222;'), ('b2ms466f0lb59r9eke795k0posuimu79', '103.16.25.109', '1696366222', '__ci_last_regenerate|i:1696366222;'), ('2faaprkrmmb7app0u9nh99pol72njdh6', '103.16.25.109', '1696366222', '__ci_last_regenerate|i:1696366222;'), ('6fubcpfqi6fj71uthm5plkjdbsov26mt', '103.16.25.109', '1696366222', '__ci_last_regenerate|i:1696366222;'), ('5g5qfe4bdcgq2bogm177e4b4e22hli1b', '103.16.25.109', '1696366278', '__ci_last_regenerate|i:1696366278;'), ('v7mjdavhpirj4mfn0kaf9mj8fv61jcke', '103.16.25.109', '1696367871', '__ci_last_regenerate|i:1696367871;'), ('akf4nooo0k0j85o3oij59oq100cc37tv', '103.16.25.109', '1696367874', '__ci_last_regenerate|i:1696367874;'), ('n5fuvimfaumdbdmo720bghemmbhamhf4', '103.16.25.109', '1696367874', '__ci_last_regenerate|i:1696367874;'), ('nfmamer4aln4arqa5n5comcrk0eu5dbg', '103.16.25.109', '1696367874', '__ci_last_regenerate|i:1696367874;'), ('c1jct0vrkijlr01lbqceai2r7snnj081', '103.16.25.109', '1696367874', '__ci_last_regenerate|i:1696367874;'), ('kmue5iecuq7en28n0cpecnf6ivq9hkor', '103.16.25.109', '1696367874', '__ci_last_regenerate|i:1696367874;'), ('8cermncht2a1fv2m64edfvfuj2tegt0q', '103.16.25.109', '1696367874', '__ci_last_regenerate|i:1696367874;'), ('2eirkkurpu8m5uduv2i3ae510okcnkn6', '103.16.25.109', '1696367875', '__ci_last_regenerate|i:1696367875;'), ('p5nqu3ul7dcgp4ku8mju4vte37s5rgb1', '103.16.25.109', '1696368283', '__ci_last_regenerate|i:1696368283;'), ('3g2ud60odgkvv6g657tk58ihkrji34fv', '103.16.25.109', '1696368283', '__ci_last_regenerate|i:1696368283;'), ('p69o4g5sbmdu1ok94s6rp63c4qungm2r', '103.16.25.109', '1696368283', '__ci_last_regenerate|i:1696368283;'), ('skatlt1cdvtv3sk55jeqar0gma09p8pm', '103.16.25.109', '1696368283', '__ci_last_regenerate|i:1696368283;'), ('gt0sqafll08qsu3nbmclsl47oah0tloh', '103.16.25.109', '1696368283', '__ci_last_regenerate|i:1696368283;'), ('6b7g2v2okc9ftfv12r011fiupvh39327', '103.16.25.109', '1696368283', '__ci_last_regenerate|i:1696368283;'), ('iq68q3u05ucid5p4gefn22qsvr24p401', '103.16.25.109', '1696368739', '__ci_last_regenerate|i:1696368739;'), ('pdnouv93f3m17neij5t56hav329saulq', '103.16.25.109', '1696368739', '__ci_last_regenerate|i:1696368739;'), ('i9v176esmf99317e5vof24frn9g0q1jk', '103.16.25.109', '1696368739', '__ci_last_regenerate|i:1696368739;'), ('1avntsr5srm9ke3il3bb71rke97k8nfd', '103.16.25.109', '1696368739', '__ci_last_regenerate|i:1696368739;'), ('qpi3er18ftvblhrrfocurnij5gsmalk7', '103.16.25.109', '1696368739', '__ci_last_regenerate|i:1696368739;'), ('uc9213ofqigv2up67ft6hjnuq11u4one', '103.16.25.109', '1696368740', '__ci_last_regenerate|i:1696368740;'), ('ol3c7hcpvocve0ss4bihpl9fci4ms8qa', '103.16.25.109', '1696368748', '__ci_last_regenerate|i:1696368748;'), ('1kcugs6hks2fc3ailornstp7829q7j0g', '103.16.25.109', '1696368748', '__ci_last_regenerate|i:1696368748;'), ('j1ogpvure42hp5hjrfpo9m1m4ck1gjk8', '103.16.25.109', '1696368748', '__ci_last_regenerate|i:1696368748;'), ('jb3dav34do1dhsdh1mgifasj2g7utpfd', '103.16.25.109', '1696368748', '__ci_last_regenerate|i:1696368748;'), ('q2keba1atk2dv89cmc4vddmrh0gjb0kd', '103.16.25.109', '1696368748', '__ci_last_regenerate|i:1696368748;'), ('sar4sk0sj6m7sh984n6fn4pmj80p0ecq', '103.16.25.109', '1696368748', '__ci_last_regenerate|i:1696368748;'), ('ap0j6r09l0mi85cqmmigg9bmci7glgn3', '103.67.156.132', '1696385266', '__ci_last_regenerate|i:1696385266;'), ('4lflgc5c0vmiiisgapkgt8kf8jbfdgg9', '37.111.222.215', '1696399840', '__ci_last_regenerate|i:1696399840;'), ('i1fcg165q7ulr25tkcunhl5em0ofo949', '37.111.222.215', '1696399844', '__ci_last_regenerate|i:1696399844;'), ('kn85rhe7pcrvd8g0d74dpa80r8onou8f', '37.111.222.215', '1696399844', '__ci_last_regenerate|i:1696399844;'), ('k70dkccs3u3bqhijflj4kg24tnv1dqmr', '37.111.222.215', '1696399844', '__ci_last_regenerate|i:1696399844;'), ('377q152cv4u1ie6naf8r0rdt5ppk8jtt', '37.111.222.215', '1696399844', '__ci_last_regenerate|i:1696399844;'), ('jppfkj6falopfcm2da4o316f7s8caf51', '37.111.222.215', '1696399844', '__ci_last_regenerate|i:1696399844;'), ('i58tsj53s41m22m0dbem901rbgce0chr', '37.111.222.215', '1696399844', '__ci_last_regenerate|i:1696399844;'), ('arm1g3hpfl5qp2cgv5hujgd18420t3me', '37.111.222.215', '1696399844', '__ci_last_regenerate|i:1696399844;'), ('9mmjvo0nn33rcb0gmbc2mo3a1vberum0', '37.111.222.215', '1696399848', '__ci_last_regenerate|i:1696399848;'), ('coqa0f6794v6vu6nbodo1ab8chs9kc42', '37.111.222.215', '1696399853', '__ci_last_regenerate|i:1696399853;'), ('9s545bhndpkma0llv3a68kj8ctsv7lbd', '37.111.222.215', '1696399856', '__ci_last_regenerate|i:1696399856;'), ('2qe1b5vtphm43rveq1ebebghsuta56b7', '37.111.222.215', '1696399856', '__ci_last_regenerate|i:1696399856;'), ('c6lm4idkr7l700qjs5psj159kf1utrr5', '37.111.222.215', '1696399856', '__ci_last_regenerate|i:1696399856;'), ('diqgl16n8fgmr4t5r22rmlfco1cd0dql', '37.111.222.215', '1696399856', '__ci_last_regenerate|i:1696399856;'), ('172q59ufqseau64sel1cf3sdbf3efupl', '37.111.222.215', '1696399857', '__ci_last_regenerate|i:1696399857;'), ('8idprjm2arthm1a6b39oanj3mdhep7ub', '37.111.222.215', '1696399857', '__ci_last_regenerate|i:1696399857;'), ('lgqe8f771j73a33oua46mmbs3qvtefht', '37.111.223.30', '1696411215', '__ci_last_regenerate|i:1696411215;'), ('830cvsu1qbrh6ltegp5d9vjqpalub077', '37.111.223.30', '1696411218', '__ci_last_regenerate|i:1696411218;'), ('1s6bvnfmaln2pkvoqj1ao26mf3815ohr', '37.111.223.30', '1696411218', '__ci_last_regenerate|i:1696411218;'), ('2ij2crokr56vf49acpu850kmfd75colf', '37.111.223.30', '1696411218', '__ci_last_regenerate|i:1696411218;'), ('r9itk5f5e6cf270el2s9v5uikmbmesi7', '37.111.223.30', '1696411218', '__ci_last_regenerate|i:1696411218;'), ('ua6o64nh2c7shg7o6r8m8qk899p5gvna', '37.111.223.30', '1696411218', '__ci_last_regenerate|i:1696411218;'), ('1v0c1pbljt7agnbjgoscv47dmmgqrod9', '37.111.223.30', '1696411218', '__ci_last_regenerate|i:1696411218;'), ('gkffkj0og8au9t5en3c3nnsqqbnc1pb7', '116.58.202.134', '1696416793', '__ci_last_regenerate|i:1696416793;'), ('vqh6vq80t2abpdhn7p9lsq6tssolp3te', '116.58.202.134', '1696416796', '__ci_last_regenerate|i:1696416796;'), ('10a6g89r32om2dombgbretbck9i0iud8', '116.58.202.134', '1696416796', '__ci_last_regenerate|i:1696416796;'), ('o4iqsnk966nvh13c0atp8tpicsvcd4nq', '116.58.202.134', '1696416796', '__ci_last_regenerate|i:1696416796;'), ('qgar40tc9sfc6b5r96ged9r10c1lneu2', '116.58.202.134', '1696416796', '__ci_last_regenerate|i:1696416796;'), ('fauiuds8dlcm3djd8tba6r16p3iakvrg', '116.58.202.134', '1696416796', '__ci_last_regenerate|i:1696416796;'), ('5ada7msmekuul8et2acaq68ql6a619o3', '116.58.202.134', '1696416796', '__ci_last_regenerate|i:1696416796;'), ('s5mi6aq470n1knd9irmhailumdsk872m', '116.58.202.134', '1696416797', '__ci_last_regenerate|i:1696416797;'), ('b0evje9rqa6mggupe01jsd54irrv4bb9', '116.58.202.134', '1696417015', '__ci_last_regenerate|i:1696417015;'), ('aqtv5grfjaj9d26a1lim0gb5ua4ubre3', '116.58.202.134', '1696417015', '__ci_last_regenerate|i:1696417015;'), ('pg6fnv8bjj95t0pbri3fkbe4egk1bf5k', '37.111.223.30', '1696417537', '__ci_last_regenerate|i:1696417537;'), ('85t41ptqanugn89slbl60im2e4e48dhi', '103.253.46.218', '1696422234', '__ci_last_regenerate|i:1696422234;'), ('oabqnl7qj99kld80f78thb6k32gs684l', '103.253.46.218', '1696422238', '__ci_last_regenerate|i:1696422238;'), ('sprtfvfo3t91o66o2u32267r6jd7rn2s', '103.253.46.218', '1696422291', '__ci_last_regenerate|i:1696422291;'), ('p3iivd37f1l5u1fi6eh5gb4gvau3bb5b', '103.67.156.95', '1696425406', '__ci_last_regenerate|i:1696425406;'), ('remuop71bnh00dbvaufrueahj7g45gre', '103.67.156.101', '1696425597', '__ci_last_regenerate|i:1696425597;'), ('h5ru5m55pducrdkovcjugplog34ukaja', '103.67.158.155', '1696426919', '__ci_last_regenerate|i:1696426919;'), ('43budoca71n0dqokl0bo2mp48o3nsvpf', '103.67.158.155', '1696427090', '__ci_last_regenerate|i:1696427090;'), ('o64k5uq1p3rbiancfgfiupljniho4h4e', '103.67.158.155', '1696427269', '__ci_last_regenerate|i:1696427269;'), ('73vmol41cv349prn0o1hh5619dcgjfcj', '103.67.158.155', '1696427371', '__ci_last_regenerate|i:1696427371;'), ('pgensjcje51e3mdasu2gksbbe134gmu8', '103.67.158.155', '1696427371', '__ci_last_regenerate|i:1696427371;'), ('tculid7mc2a2lcjoorj5h1t86l1kk6v6', '103.67.158.155', '1696427371', '__ci_last_regenerate|i:1696427371;'), ('q8tv1m3kfe2ov2kpqi49d6a7m0tcr7vb', '103.67.158.155', '1696427371', '__ci_last_regenerate|i:1696427371;'), ('tc9u8muv55svii55oq0ejqh789p1okcf', '103.67.158.155', '1696427372', '__ci_last_regenerate|i:1696427371;'), ('n1l182v0fs9flk5lovcvn7dgnp7bqn5q', '103.67.158.155', '1696427372', '__ci_last_regenerate|i:1696427371;'), ('clgp7u035o6bnq2l266qannjehdfmt4i', '103.67.158.155', '1696427372', '__ci_last_regenerate|i:1696427371;'), ('aecrcbfdtrqn4v19hi7ccbs97dbogvg5', '103.67.158.155', '1696427392', '__ci_last_regenerate|i:1696427392;'), ('560qkoe4psf5bvc70tp603u8rrogk884', '103.67.158.155', '1696427606', '__ci_last_regenerate|i:1696427606;'), ('7k9uthhppbo7tkm3atcorfk5ofo047e1', '103.67.158.155', '1696428003', '__ci_last_regenerate|i:1696428003;'), ('mvu7tubumkg7kvn5phu9ngnehiqlopd9', '103.67.158.155', '1696428006', '__ci_last_regenerate|i:1696428006;'), ('n3jk944j4plfhg7ogulkjet3the7300q', '103.67.158.155', '1696428006', '__ci_last_regenerate|i:1696428006;'), ('db19jf8i8asv5ucf1n5c6sogch0n26ed', '103.67.158.155', '1696428006', '__ci_last_regenerate|i:1696428006;'), ('fg96od9aqd89dg6m72d5lqguoemnedjk', '103.67.158.155', '1696428006', '__ci_last_regenerate|i:1696428006;'), ('cqj39q02997e8tbg5vvcc3rhk9pe01sk', '103.67.158.155', '1696428006', '__ci_last_regenerate|i:1696428006;'), ('7ie5hqaivaqqn0vecogq5tk7rrhcg6f7', '103.67.158.155', '1696428006', '__ci_last_regenerate|i:1696428006;'), ('568337146puv99683o98m2nspktm11e2', '103.67.158.155', '1696428007', '__ci_last_regenerate|i:1696428007;'), ('5gcq8674k1ikhdovd7cffmkdeo3371fv', '103.67.158.155', '1696428031', '__ci_last_regenerate|i:1696428031;'), ('3na7h5tse1cfqhcsq1mfvfndl2conig0', '103.67.158.155', '1696428032', '__ci_last_regenerate|i:1696428032;'), ('4ufuqh27icq19cqvm6lsrtck9vveeg3v', '103.67.158.155', '1696428032', '__ci_last_regenerate|i:1696428032;'), ('oqoh1hrlef4o17sns427pq8i6f9ib8qj', '103.67.158.155', '1696428032', '__ci_last_regenerate|i:1696428032;'), ('g5kld9d31pfsm7ovt44hhlf8rvj2m89g', '103.67.158.155', '1696428032', '__ci_last_regenerate|i:1696428032;'), ('m4qp3ooontcccpecaphmgbdtt4kaigci', '103.67.158.155', '1696428032', '__ci_last_regenerate|i:1696428032;'), ('32v29lhh4t37bo2ec9u7t20ihuc0gisr', '103.67.158.155', '1696428032', '__ci_last_regenerate|i:1696428032;'), ('5g795q9r5q4vmepvgko4avioguksrgra', '103.67.158.155', '1696428034', '__ci_last_regenerate|i:1696428034;'), ('5eh1thbl7je3p5ts8h6fdq7q6d1j93d9', '103.67.158.155', '1696428034', '__ci_last_regenerate|i:1696428034;'), ('vvileoit3hudi61gnu82r5fiblq81hl1', '103.67.158.155', '1696428035', '__ci_last_regenerate|i:1696428035;'), ('bggj74otqva3r0781dhm1ttfc425r20u', '103.67.158.155', '1696428036', '__ci_last_regenerate|i:1696428036;'), ('g41cdtho0gonhruluei735jaj6rpgk6h', '103.67.158.155', '1696428036', '__ci_last_regenerate|i:1696428036;'), ('t0hb9hl0980a4325311qhhf2vitbt5fb', '103.67.158.155', '1696428036', '__ci_last_regenerate|i:1696428036;'), ('ahhr401j37aq78m34et196ct6noklkc0', '103.67.158.155', '1696428036', '__ci_last_regenerate|i:1696428036;'), ('44shkpilq4951rcj2htnfp57gldup4r0', '103.67.158.155', '1696428036', '__ci_last_regenerate|i:1696428036;'), ('lfljl23317ugibo6pds1n1da79k140r5', '103.67.158.155', '1696428036', '__ci_last_regenerate|i:1696428036;'), ('lb91bevja9oa1p36t335fc3o1ia4c953', '103.67.158.155', '1696428036', '__ci_last_regenerate|i:1696428036;'), ('q462sll97so5d3v4pjvaalqkmi8kjbfu', '103.67.158.155', '1696428036', '__ci_last_regenerate|i:1696428036;'), ('d6ssh5blekdg9nuucrbh0pokjp6vvp6q', '103.67.158.155', '1696428036', '__ci_last_regenerate|i:1696428036;'), ('sm5h61bmt2mesjeolifm4blu5hvmlslf', '103.67.158.155', '1696428036', '__ci_last_regenerate|i:1696428036;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('qtu5idjg9s1t679keiq1h0aamgnuhvcj', '103.67.158.155', '1696431029', '__ci_last_regenerate|i:1696428039;custom_session_limit|i:1696471239;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";cart_items|a:0:{}language|s:7:\"english\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('gm383npchi68r4pes785nfb564bu23ne', '103.67.158.155', '1696428040', '__ci_last_regenerate|i:1696428040;'), ('8ea41l3fh9iu1j3mu2j0pvrvq82kti87', '103.67.158.155', '1696428405', '__ci_last_regenerate|i:1696428405;'), ('cge6rj51ub8qnts6gc7lbctje5m19ok9', '103.67.158.155', '1696428548', '__ci_last_regenerate|i:1696428548;'), ('errn5kubl1lrm9fup5pn673ivtjv10lk', '103.67.158.155', '1696428725', '__ci_last_regenerate|i:1696428725;'), ('mv98ctaqa9vvt1p69k135r9at51mvv5l', '103.67.158.155', '1696428982', '__ci_last_regenerate|i:1696428982;'), ('gffhmcf2tp40oe8q5lt46ntrati16qoj', '103.67.158.155', '1696428984', '__ci_last_regenerate|i:1696428984;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('47p3es4hjncqjjb3hfninme65qlmib44', '103.67.158.155', '1696428988', '__ci_last_regenerate|i:1696428988;'), ('p1sdgqsj47udhurstq26n19vmrtv497e', '103.67.158.155', '1696428988', '__ci_last_regenerate|i:1696428988;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('6sq6h4bjgdo52mo0vh8j8m40r9msfel9', '103.67.158.155', '1696428989', '__ci_last_regenerate|i:1696428989;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}language|s:7:\"english\";'), ('71paaau5p621s7qffp9b2pa1hg9377bs', '103.67.158.155', '1696428993', '__ci_last_regenerate|i:1696428993;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('8m9dn10v1etl3cfdeissu1g3r627lc82', '103.67.158.155', '1696428998', '__ci_last_regenerate|i:1696428998;'), ('ucfb6gmpa7kttgofhtp7mkpq1d1ukstk', '103.67.158.155', '1696428999', '__ci_last_regenerate|i:1696428999;'), ('6hn2liln77q8inabn943jjgrt7q1joq3', '103.67.158.155', '1696429000', '__ci_last_regenerate|i:1696429000;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('8rh489712b4vm5qkau4o6oa2aenmkrqf', '103.67.158.155', '1696429066', '__ci_last_regenerate|i:1696429066;'), ('omblaoo5n12h03m4td5cq86ok3qtn52c', '103.67.158.155', '1696429066', '__ci_last_regenerate|i:1696429066;'), ('832kuf2sflvrleamcprgtpahip4uv1rl', '103.67.158.155', '1696429067', '__ci_last_regenerate|i:1696429067;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('tb4046l1p0u4oq1shcd37ri0kbo1q3ju', '103.67.158.155', '1696429076', '__ci_last_regenerate|i:1696429076;'), ('glroeda2vp35uahc00onvdi1lb4qhr4e', '103.67.158.155', '1696429077', '__ci_last_regenerate|i:1696429077;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}cart_items|a:0:{}language|s:7:\"english\";'), ('sfnp9885psk9sapclp6406t8gt0o0cnb', '103.67.158.155', '1696429172', '__ci_last_regenerate|i:1696429172;'), ('ghu6tv8kvigqkjqmclb9cvqjeqv3hv3m', '103.67.158.155', '1696429174', '__ci_last_regenerate|i:1696429174;'), ('qqt2cj8vvv5g5aaa3js8fkls51aujopo', '103.67.158.155', '1696429218', '__ci_last_regenerate|i:1696429218;'), ('q615ots0sqqket4uuk7h4mc8q12vrrke', '103.67.158.155', '1696429403', '__ci_last_regenerate|i:1696429403;'), ('58kc1jo0pvr5a60kf5qjmqp0vit72tsk', '103.67.158.155', '1696429409', '__ci_last_regenerate|i:1696429409;'), ('2pttfgu4jdtqmi1o7sjcp9e8n9uu99cd', '103.67.158.155', '1696429409', '__ci_last_regenerate|i:1696429409;'), ('jn6gr60atl1s6gbbv1fjb0s0j660hhou', '103.67.158.155', '1696429409', '__ci_last_regenerate|i:1696429409;'), ('dkrh53d6g6ge80umajfred674ba0oir3', '103.67.158.155', '1696430965', '__ci_last_regenerate|i:1696430965;'), ('fhv082b7aq39j9oa8v6e9ctim90302is', '103.67.158.155', '1696430969', '__ci_last_regenerate|i:1696430969;'), ('s3t0ffpecjcnjkrce3lo0q111qqlpjv4', '103.67.158.155', '1696430969', '__ci_last_regenerate|i:1696430969;'), ('bqpsqdk8pkrnsvs09ube1se5mps990ui', '103.67.158.155', '1696430969', '__ci_last_regenerate|i:1696430969;'), ('varoumhmi4scnsrkeck4mf36sbv5v3oe', '103.67.158.155', '1696430969', '__ci_last_regenerate|i:1696430969;'), ('ra3m4ff0tnv6fvchgbsua8seojt2pb5g', '103.67.158.155', '1696430969', '__ci_last_regenerate|i:1696430969;'), ('hhauj5k1haj8iba38ils339on673htg9', '103.67.158.155', '1696430969', '__ci_last_regenerate|i:1696430969;'), ('b7d0li0644q3lsjquf9einaepkcrmnj2', '103.67.158.155', '1696430970', '__ci_last_regenerate|i:1696430970;'), ('buokjlbhn1qa1mmg2gd38f3tpndvstg9', '103.67.158.155', '1696431026', '__ci_last_regenerate|i:1696431026;'), ('g3ihdktu0e1693nd7bgqk78jrgpfj6qm', '103.67.158.155', '1696431114', '__ci_last_regenerate|i:1696431114;'), ('2erddr8ol0tqdrsrlggfn72hd9cuq3uu', '103.67.158.155', '1696431115', '__ci_last_regenerate|i:1696431115;'), ('rt4hrc2ve5e05ceg9i58dapsh73doakb', '103.67.158.155', '1696431115', '__ci_last_regenerate|i:1696431115;'), ('9tr1635h8us0j5c9tnkocild9erpfi71', '103.67.158.155', '1696431115', '__ci_last_regenerate|i:1696431115;'), ('mrs0aih15el33t06jpub7n5gmjn9i9vu', '103.67.158.155', '1696431115', '__ci_last_regenerate|i:1696431115;'), ('1gafv9ghkhkqg97t7jll76ti9v2jj7g1', '103.67.158.155', '1696431115', '__ci_last_regenerate|i:1696431115;'), ('r43mhi7ghcbfvhvu057nccaj65rqrmid', '103.67.158.155', '1696431115', '__ci_last_regenerate|i:1696431115;'), ('iejsvr0kanipm3tbfk36v8efep0a3f5t', '103.67.158.155', '1696431116', '__ci_last_regenerate|i:1696431116;'), ('92vjft56e600njtesbnthgu3j1huhokv', '103.67.158.155', '1696431120', '__ci_last_regenerate|i:1696431120;'), ('afc6o3iaf7ddsp4jq2qrbg1nucerpnr6', '103.67.158.155', '1696431121', '__ci_last_regenerate|i:1696431121;'), ('5vta42tqbn4hmjsughkrq9nvug8np60o', '103.67.158.155', '1696431122', '__ci_last_regenerate|i:1696431122;'), ('fdn0ttdue6f13a4hm5d9vo4ds6bfn2qi', '103.67.158.155', '1696431122', '__ci_last_regenerate|i:1696431122;'), ('5fiknl0u14sifb56medd6mlhrba1nmkt', '103.67.158.155', '1696431122', '__ci_last_regenerate|i:1696431122;'), ('r6b3j0be84h7475i2210hu3bp9b428cc', '103.67.158.155', '1696431122', '__ci_last_regenerate|i:1696431122;'), ('q2keisc8q0akvgo4c2ep9sl1p26av1j9', '103.67.158.155', '1696431122', '__ci_last_regenerate|i:1696431122;'), ('0houopgam4kc67nod4g36vl1rdj0p2qh', '103.67.158.155', '1696431122', '__ci_last_regenerate|i:1696431122;'), ('mahvogd4j164nr31v2p4s90322okrfth', '103.67.158.155', '1696431126', '__ci_last_regenerate|i:1696431126;'), ('nn7rq8474sln6d26aeeuk6ilckrsd0pi', '103.67.158.155', '1696431126', '__ci_last_regenerate|i:1696431126;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('so8d228ac1p2kk2bun18q372qgaf0uhs', '103.67.158.155', '1696431126', '__ci_last_regenerate|i:1696431126;'), ('gpl4iffvbd670uh4cpj66s8j67q9jf7d', '103.67.158.155', '1696431127', '__ci_last_regenerate|i:1696431127;'), ('cd23nngal7tlb40o3cf9052n0ucflr22', '103.67.158.155', '1696431129', '__ci_last_regenerate|i:1696431129;'), ('m2oj61idk4jn6hg5r8qualhbgabsjdhe', '103.67.158.155', '1696483930', '__ci_last_regenerate|i:1696431129;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1696527118;user_id|s:3:\"451\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:10:\"Masud Alam\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('pibadanqcfv5ovpumls7hlf0rb7sh6gh', '103.67.158.155', '1696431231', '__ci_last_regenerate|i:1696431231;'), ('7c19huuaspm452jvpm0fi2rdssahufcs', '103.67.158.155', '1696431300', '__ci_last_regenerate|i:1696431300;'), ('9ge0lhfnp17mbj9h7nsgg2igq6nrl295', '103.67.158.155', '1696431341', '__ci_last_regenerate|i:1696431341;'), ('phh91brr3t0cbmlk2b1v6r3o2bvudehs', '103.67.158.155', '1696431434', '__ci_last_regenerate|i:1696431434;'), ('4eddbnpim9e0sjc5dib2q2hb8vlrctvr', '103.67.158.155', '1696431437', '__ci_last_regenerate|i:1696431437;'), ('uklhranlor7s6d3amlm007h2e3eajaem', '103.67.158.155', '1696431437', '__ci_last_regenerate|i:1696431437;'), ('bnhhcjg2q5tj9ntmu3bic7l4v49i5du8', '103.67.158.155', '1696431437', '__ci_last_regenerate|i:1696431437;'), ('svibfqr0arnaf2pfatugkhgrh6gi9amp', '103.67.158.155', '1696431437', '__ci_last_regenerate|i:1696431437;'), ('68hlvthsv0dnl9q4qiarkbcil7c05g9v', '103.67.158.155', '1696431437', '__ci_last_regenerate|i:1696431437;'), ('78j191lib8bt1cs45p1rmq9jbpoqfihr', '103.67.158.155', '1696431437', '__ci_last_regenerate|i:1696431437;'), ('4rpnsdn0184as68v19103uillsf49lch', '103.67.158.155', '1696431438', '__ci_last_regenerate|i:1696431438;'), ('q4l0t03hq48dqi4ddrq87o7oe9hjvfhj', '103.67.158.155', '1696431526', '__ci_last_regenerate|i:1696431526;'), ('5ldk8frc2h4qsqlmrrgkpvng9sa39pje', '103.67.158.155', '1696431528', '__ci_last_regenerate|i:1696431528;'), ('e5c907c7753dua81qjm8bgdjl4fhfj2j', '103.67.158.155', '1696431584', '__ci_last_regenerate|i:1696431584;'), ('84dfol03io11oncjbltghj3tp9ts60v5', '103.67.158.155', '1696431674', '__ci_last_regenerate|i:1696431674;'), ('qp3ehfp727unb8smdfcjoo5cjqljmqga', '103.67.158.155', '1696431708', '__ci_last_regenerate|i:1696431708;'), ('gf6utt6tglgof8mj24m7ipkaemticr8v', '103.67.158.155', '1696431713', '__ci_last_regenerate|i:1696431713;'), ('36ftqrhkk2anfblfasegn2q7fiu39k4u', '37.211.35.118', '1696437222', '__ci_last_regenerate|i:1696437222;'), ('natqvjubmh216sueac58dmpdn8upmfc5', '37.211.35.118', '1696437222', '__ci_last_regenerate|i:1696437222;'), ('s17d8k6mosim7djijvvb4hdq0tga38t3', '37.211.35.118', '1696437238', '__ci_last_regenerate|i:1696437238;'), ('f754e126ma0j9svcsufhkjkarm10hme0', '37.211.35.118', '1696437239', '__ci_last_regenerate|i:1696437239;'), ('mfa5mhr5vjf1fgc0ru7gfvflkhfsjqbk', '37.211.35.118', '1696437239', '__ci_last_regenerate|i:1696437239;'), ('q3eaojf5umghej7fahu175j1t4mpk8s0', '37.211.35.118', '1696437239', '__ci_last_regenerate|i:1696437239;'), ('1gsoim06sd0ge8cad53p9l83sd2qvql3', '37.211.35.118', '1696437239', '__ci_last_regenerate|i:1696437239;'), ('o00f0k6pv6oevito3jgs86q3rdpmoj7i', '37.211.35.118', '1696437239', '__ci_last_regenerate|i:1696437239;'), ('r1qpedeg3i1m7m8icm5qqd4qrbijviip', '37.211.35.118', '1696437239', '__ci_last_regenerate|i:1696437239;'), ('pi0a8260sj50k55obn2uq10ic17jplt7', '37.211.35.118', '1696437240', '__ci_last_regenerate|i:1696437240;'), ('gl11ja0rkjba6k6qfh347kq0tmdijbll', '37.211.35.118', '1696437242', '__ci_last_regenerate|i:1696437242;'), ('o3tniiusid0r1hdn77vpocjd4t6hman3', '37.211.35.118', '1696437243', '__ci_last_regenerate|i:1696437243;'), ('5lmievogp9codb8rjboem5ujh4ukfq8d', '37.211.35.118', '1696437244', '__ci_last_regenerate|i:1696437244;'), ('cj6428iavbdc9putemrbo0spme0ndnhj', '37.211.35.118', '1696437244', '__ci_last_regenerate|i:1696437244;'), ('8gvbgd230f98bppvv459elu47chqgt7h', '37.211.35.118', '1696437244', '__ci_last_regenerate|i:1696437244;'), ('vqgmohtntdlbluaf84ald6ogp46n4ab1', '37.211.35.118', '1696437244', '__ci_last_regenerate|i:1696437244;'), ('ns27jhdgo973739sus7nj49gcpqsic2e', '37.211.35.118', '1696437833', '__ci_last_regenerate|i:1696437245;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1697301696;user_id|s:3:\"453\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:12:\"Noman Khalid\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('obq6oiqi843abl2haksa8ifqi9t4f46k', '37.211.35.118', '1696437250', '__ci_last_regenerate|i:1696437250;'), ('2mn0f4tbgh3dqjju5k506sasvn4gfm9i', '37.211.35.118', '1696437251', '__ci_last_regenerate|i:1696437250;'), ('lb16oaobrje88dcs3jl7keqqbucg9ra7', '37.211.35.118', '1696437251', '__ci_last_regenerate|i:1696437251;'), ('tnsj4v4rhmhnvtdkba9pooej8ckpn4j9', '37.211.35.118', '1696437251', '__ci_last_regenerate|i:1696437251;'), ('0o0sp2ntl4scnqd8fnbad29eq76hkqr6', '37.211.35.118', '1696437251', '__ci_last_regenerate|i:1696437251;'), ('d40p58bu2u180gdpv8pdq3ear150nkv9', '37.211.35.118', '1696437251', '__ci_last_regenerate|i:1696437251;'), ('lp7vfch7v53aeifm3tcqaqun5kbravi2', '37.211.35.118', '1696437252', '__ci_last_regenerate|i:1696437252;'), ('m8t6iq9aijmgk2a0iop5efr6o6qhisa5', '37.211.35.118', '1696437252', '__ci_last_regenerate|i:1696437252;'), ('uu06hu7pv3l72pq71elbgsu1e120pdsr', '37.211.35.118', '1696437252', '__ci_last_regenerate|i:1696437252;'), ('gcc36u0f1fsn9ce6tqdua9polpjgjul4', '37.211.35.118', '1696437252', '__ci_last_regenerate|i:1696437252;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('lesvvorl0j7v0bvctcd8p42uso7in4n2', '37.211.35.118', '1696437262', '__ci_last_regenerate|i:1696437262;'), ('3a6it3ru49632ugatbdl4dvh03o750i8', '37.211.35.118', '1696437262', '__ci_last_regenerate|i:1696437262;'), ('am5ptplbhtpumh89al00q3v0qduhpk5e', '37.211.35.118', '1696437262', '__ci_last_regenerate|i:1696437262;'), ('4u7q35dlk64pb4d1q5dgb4opghq2rk40', '37.211.35.118', '1696437262', '__ci_last_regenerate|i:1696437262;'), ('ctei665ik55le83bor7lm8bln15lme8l', '37.211.35.118', '1696437263', '__ci_last_regenerate|i:1696437263;'), ('02spsp15mp21ue1vg9bmvie9bcb6d185', '37.211.35.118', '1696437265', '__ci_last_regenerate|i:1696437265;'), ('76mc9o9q8nplmhfq7kjfbbj56m2c4d2m', '37.211.35.118', '1696437266', '__ci_last_regenerate|i:1696437266;'), ('oki4qgmapg9it71vcagu3i6adao9bhfj', '37.211.35.118', '1696437267', '__ci_last_regenerate|i:1696437267;'), ('u3h92pdcii1h1102fl8lpq7pr22iv148', '37.211.35.118', '1696437267', '__ci_last_regenerate|i:1696437267;'), ('a5d0283jb4v2t410q9oeg3i11n4ikgb5', '37.211.35.118', '1696437267', '__ci_last_regenerate|i:1696437267;'), ('e5r3f718f2nu0pf7k55qkegps7ooaqnk', '37.211.35.118', '1696437267', '__ci_last_regenerate|i:1696437267;'), ('q3ts1hvee4votn1e4bght3td18rs6lm4', '37.211.35.118', '1696437267', '__ci_last_regenerate|i:1696437267;'), ('6koc9bkc44a1h73rkeov45b3mnscgacc', '37.211.35.118', '1696437267', '__ci_last_regenerate|i:1696437267;'), ('gmao35427i5610r2v7etufoa1ogc7vkm', '37.211.35.118', '1696437267', '__ci_last_regenerate|i:1696437267;'), ('gn19n2kgm408luger095rnjhvmcgkuj8', '37.211.35.118', '1696437267', '__ci_last_regenerate|i:1696437267;'), ('tj9plpf7o6ocumfrd1v1tcmebtvkmbor', '37.211.35.118', '1696437267', '__ci_last_regenerate|i:1696437267;'), ('1gs61ko933u935v5l0bf7bja65ehrjkj', '37.211.35.118', '1696437268', '__ci_last_regenerate|i:1696437268;'), ('gs1nrf8mo69e8l617eqd0s1bmktuemsd', '37.211.35.118', '1696437274', '__ci_last_regenerate|i:1696437274;'), ('dldc47jg6sf1rt5a6b7491vd0kau65q9', '37.211.35.118', '1696437275', '__ci_last_regenerate|i:1696437275;'), ('snghe06eokpnjk9nik221l0acd1c6f3p', '37.211.35.118', '1696437276', '__ci_last_regenerate|i:1696437276;'), ('b8ulm3l23uss75ri7q3q6rf2leupf132', '37.211.35.118', '1696437276', '__ci_last_regenerate|i:1696437276;'), ('cq18vge93rccq3ofq7oho0976b7vepdv', '37.211.35.118', '1696437276', '__ci_last_regenerate|i:1696437276;'), ('ca4hiqu2dmvh1i7vqql974gi869c8abb', '37.211.35.118', '1696437276', '__ci_last_regenerate|i:1696437276;'), ('kk2gvdh0l3l5d7s7b66ao7821hfniinf', '37.211.35.118', '1696437277', '__ci_last_regenerate|i:1696437277;'), ('8rpjvrrstcgg4cfv5tqcvvq7b5rj8phd', '37.211.35.118', '1696437277', '__ci_last_regenerate|i:1696437277;'), ('at5b04bfh8rsldg401lgjkppoe0et68i', '37.211.35.118', '1696437277', '__ci_last_regenerate|i:1696437277;'), ('q8b0lefvid5rnfst0mbf5kkl5tc0ojal', '37.211.35.118', '1696437277', '__ci_last_regenerate|i:1696437277;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('j1711tr18hoiv8a7432akvtmnhibg8ca', '37.211.35.118', '1696437586', '__ci_last_regenerate|i:1696437586;'), ('jsrl2g9mgikq9mqipd4ko255c2j2eoev', '37.211.35.118', '1696437587', '__ci_last_regenerate|i:1696437587;'), ('0nnnseom3h5tto89rjtd5dk2b7n73anh', '37.211.35.118', '1696437588', '__ci_last_regenerate|i:1696437588;'), ('d8kq3ogcvsrgfhlvuqic9758li02jesg', '37.211.35.118', '1696437588', '__ci_last_regenerate|i:1696437588;'), ('gk8373c8olvajtqure36ebg3v4ir338d', '37.211.35.118', '1696437588', '__ci_last_regenerate|i:1696437588;'), ('umdq01pp70belavfv888udbr44vmis8a', '37.211.35.118', '1696437588', '__ci_last_regenerate|i:1696437588;'), ('hnqhvm47276hrc67a6j0g229h8oqdecr', '37.211.35.118', '1696437589', '__ci_last_regenerate|i:1696437589;'), ('f7u5dbp5vbfjs20n2cdrqbi8e261amla', '37.211.35.118', '1696437589', '__ci_last_regenerate|i:1696437589;'), ('7craesnh8qvqa0tpvcn6mcb5ur44o37l', '37.211.35.118', '1696437589', '__ci_last_regenerate|i:1696437589;'), ('lv6gcofjvfv9gd7iigmuchpun01fjt5k', '37.211.35.118', '1696437589', '__ci_last_regenerate|i:1696437589;'), ('52np7bg96dbjdq1nomqmov41r7im67i0', '37.211.35.118', '1696437589', '__ci_last_regenerate|i:1696437589;'), ('m3813eauuo7efkflo0pbi6h2c2iguokc', '37.211.35.118', '1696437590', '__ci_last_regenerate|i:1696437590;'), ('kpd6lkn1kl845ccdcllcodsslcu0uigm', '37.211.35.118', '1696437601', '__ci_last_regenerate|i:1696437601;'), ('dkqfj5rfp8sco071pe7svg464u5imgu8', '37.211.35.118', '1696437601', '__ci_last_regenerate|i:1696437601;'), ('49vdd62vorqnge6e66jak9ifq3prolu2', '37.211.35.118', '1696437602', '__ci_last_regenerate|i:1696437602;'), ('5hck1nm5a1m2r4o2gfi4uosn1gv0mks5', '37.211.35.118', '1696437605', '__ci_last_regenerate|i:1696437605;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('8oao0ijsd6nh6anikuktvnfeofmo77l8', '37.211.35.118', '1696437605', '__ci_last_regenerate|i:1696437605;'), ('j1dim2vl1hlhesakk310qa2dgenp8ujp', '37.211.35.118', '1696437606', '__ci_last_regenerate|i:1696437606;'), ('aj91lf01mdn60qp41pfsio16kaqm1pq0', '37.211.35.118', '1696437609', '__ci_last_regenerate|i:1696437609;'), ('7kmgoot4ev1u5namcidvo1h9mlh32osf', '37.211.35.118', '1696437610', '__ci_last_regenerate|i:1696437610;'), ('a8bkgsukup8dos0efebuh273n4pf4i56', '37.211.35.118', '1696437614', '__ci_last_regenerate|i:1696437614;'), ('4jmi108tsj28j7o89euiedp1rbmtvoa3', '37.211.35.118', '1696437615', '__ci_last_regenerate|i:1696437615;'), ('0emb09gtia2ll2v6f63r9fu6k0n7euao', '37.211.35.118', '1696437616', '__ci_last_regenerate|i:1696437616;'), ('mshf7a1s4ph1si9tnvf4ar83vbn24a3e', '37.211.35.118', '1696437616', '__ci_last_regenerate|i:1696437616;'), ('sh4hqeauvhaij40a4vnqp3rtqoujneb0', '37.211.35.118', '1696437616', '__ci_last_regenerate|i:1696437616;'), ('srcr3crhaf52q602gqu1risdtg22oqse', '37.211.35.118', '1696437616', '__ci_last_regenerate|i:1696437616;'), ('9eepk0gmrv8k1o459m8gvc9h073h86lj', '37.211.35.118', '1696437616', '__ci_last_regenerate|i:1696437616;'), ('fb6n4bukalhil6qolfdfd2avtu4pvpk8', '37.211.35.118', '1696437616', '__ci_last_regenerate|i:1696437616;'), ('dj9i247i49dkh98vtdqt1vm6j3s884en', '37.211.35.118', '1696437653', '__ci_last_regenerate|i:1696437653;'), ('v6cc66qok59gv1pbjtadeg2jqsjbfm79', '37.211.35.118', '1696437653', '__ci_last_regenerate|i:1696437653;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('92jqm36gg7rel9eajmoo3er2ddm31gib', '37.211.35.118', '1696437653', '__ci_last_regenerate|i:1696437653;'), ('68qkbkkb0pnep4o9773gocdte94f20b5', '37.211.35.118', '1696437653', '__ci_last_regenerate|i:1696437653;'), ('ndor7prd2sb0985u1b9c11tjjgongv5h', '37.211.35.118', '1696437661', '__ci_last_regenerate|i:1696437661;'), ('vg5i1n9stkb40ieleeaoi4695oa6c2qq', '37.211.35.118', '1696437679', '__ci_last_regenerate|i:1696437679;'), ('gu5un1kevsig836buq6shidikenhuq1i', '37.211.35.118', '1696437679', '__ci_last_regenerate|i:1696437679;'), ('fgmi20l3m2k6asisvu9s27u7umhk69t7', '37.211.35.118', '1696437679', '__ci_last_regenerate|i:1696437679;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('rfaii9p4jg236ru1r62eutvcf4qi5cgs', '37.211.35.118', '1696437679', '__ci_last_regenerate|i:1696437679;'), ('aotpr3a09fdkpb7aso937la2cdlir37a', '37.211.35.118', '1696437683', '__ci_last_regenerate|i:1696437683;'), ('gnu6avlfcq9b3hst9no9thmu31ppdr3u', '37.211.35.118', '1696437699', '__ci_last_regenerate|i:1696437699;'), ('cqrhcqqddahqffk8bas6ghrj2jk47nih', '37.211.35.118', '1696437699', '__ci_last_regenerate|i:1696437699;'), ('f914a72n8v5lmv6lseojvr0cup6t8o1i', '37.211.35.118', '1696437700', '__ci_last_regenerate|i:1696437699;'), ('n3r7v373d78sp04ik16mng0hr0jc456q', '37.211.35.118', '1696437700', '__ci_last_regenerate|i:1696437700;'), ('27fiugbvtk5p8d4m7cd4tmh7795pfvqi', '37.211.35.118', '1696437705', '__ci_last_regenerate|i:1696437705;'), ('mss7ak8kn1cnra4a499ekiuagivcdh8i', '37.211.35.118', '1696437705', '__ci_last_regenerate|i:1696437705;'), ('d6j4i2aj88m5qb9dfe6ammieg07ogih8', '37.211.35.118', '1696437705', '__ci_last_regenerate|i:1696437705;'), ('csda4mplj0lfh6o7jsd30srnejeu6ua4', '37.211.35.118', '1696437705', '__ci_last_regenerate|i:1696437705;'), ('h16jf8gjqncjj0efeu0d5amnag563hf7', '37.211.35.118', '1696437705', '__ci_last_regenerate|i:1696437705;'), ('lbmpuboc1dh8ulerrpotr3fe73gos3fd', '37.211.35.118', '1696437705', '__ci_last_regenerate|i:1696437705;'), ('1u8dk3t7oijubflqqkr050hdpc347hdt', '37.211.35.118', '1696437706', '__ci_last_regenerate|i:1696437706;'), ('m10615adglje5gqj9r107mv8shnsvb3h', '37.211.35.118', '1696437803', '__ci_last_regenerate|i:1696437803;'), ('tc534dfreq6i1ji4sg3abjdcb60tpomt', '37.211.35.118', '1696437820', '__ci_last_regenerate|i:1696437820;'), ('aqjhvdemq217cjimd47078npab12kr3t', '37.211.35.118', '1696437821', '__ci_last_regenerate|i:1696437821;'), ('bso46gb2njm2fjrgo3c4t2dflgplqlu6', '37.211.35.118', '1696437821', '__ci_last_regenerate|i:1696437821;'), ('aiasg2g3k4gc5e1q1fr6hs6skvagi6j1', '37.211.35.118', '1696437821', '__ci_last_regenerate|i:1696437821;'), ('r11e8sg6r3m2oat7am9f4f5olpq2qj8i', '37.211.35.118', '1696437821', '__ci_last_regenerate|i:1696437821;'), ('f2ur2pve1vo5i8jpuuto9nfa57c7hu0j', '37.211.35.118', '1696437821', '__ci_last_regenerate|i:1696437821;'), ('poo2tvrmn4cfqfs0l5bh18r3unjqqr2k', '37.211.35.118', '1696437821', '__ci_last_regenerate|i:1696437821;'), ('0mn9qr2mmvvvp9jk4oubtgcg3pr4u7gc', '37.211.35.118', '1696437822', '__ci_last_regenerate|i:1696437822;'), ('o8094vo2sbo4n8kcqe4mr0m10pv4ic6l', '37.211.35.118', '1696437824', '__ci_last_regenerate|i:1696437824;'), ('0lq09crat5nbpc9n46ha48igjqll9dmc', '37.211.35.118', '1696437825', '__ci_last_regenerate|i:1696437825;'), ('mq40i0gmp7amuo3mkocu6amocfl7puou', '37.211.35.118', '1696437825', '__ci_last_regenerate|i:1696437825;'), ('m9foq7bi1qnkjqd89mkfk8o7pnv14fjk', '37.211.35.118', '1696437825', '__ci_last_regenerate|i:1696437825;'), ('8he5nas2nc02vsn94301283416ckoav4', '37.211.35.118', '1696437825', '__ci_last_regenerate|i:1696437825;'), ('89bigmoduiv6c27m7mq9vfui59k44hij', '37.211.35.118', '1696437825', '__ci_last_regenerate|i:1696437825;'), ('i8ovakr8ke5qa9n77g8u8t72c6jgk4oq', '37.211.35.118', '1696437825', '__ci_last_regenerate|i:1696437825;'), ('rfp6bk0hf6en1go5kdmjq63ogqbq6b3v', '37.211.35.118', '1696437826', '__ci_last_regenerate|i:1696437826;'), ('busou8bqnua51b49q74an6nqoedf1ebk', '37.211.35.118', '1696437829', '__ci_last_regenerate|i:1696437829;'), ('0n8hbso2i6gd7p0ran07v5s8r3q2si30', '37.211.35.118', '1696437830', '__ci_last_regenerate|i:1696437830;'), ('l5t77ctbj6p3u8lec6611l0mqln6574k', '37.211.35.118', '1696437830', '__ci_last_regenerate|i:1696437830;'), ('atqceken9s96quelo833t55vnnal4umd', '37.211.35.118', '1696437830', '__ci_last_regenerate|i:1696437830;'), ('qlfnmm5dpiurkddobujc3a6kmfm62obg', '37.211.35.118', '1696437831', '__ci_last_regenerate|i:1696437831;'), ('g7qlpjt243thf2n4jgtq043qoh22726d', '37.211.35.118', '1696437836', '__ci_last_regenerate|i:1696437836;'), ('q4ujjmmoc2lr8b3q1m0jl6r2afs2ps18', '37.211.35.118', '1696437837', '__ci_last_regenerate|i:1696437837;'), ('uutsaauoifu1rc2rkdskk53mqf2bc09l', '37.211.35.118', '1696437837', '__ci_last_regenerate|i:1696437837;'), ('cut9ggjcorukbkgdqitcoq47g359gs1f', '37.211.35.118', '1696437837', '__ci_last_regenerate|i:1696437837;'), ('9aa82ht4iks1186ud2jnvai680l1319h', '37.211.35.118', '1696437837', '__ci_last_regenerate|i:1696437837;'), ('3sp8np06n04ptrfkclk9fvf2lmsl56pl', '37.211.35.118', '1696437838', '__ci_last_regenerate|i:1696437838;'), ('5hcvkueu6v886vd95lqgjejgmsbb9eli', '37.211.35.118', '1696437840', '__ci_last_regenerate|i:1696437840;'), ('ghd7miovn358996lg5dc8v1f8rf0p8cj', '37.211.35.118', '1696437840', '__ci_last_regenerate|i:1696437840;'), ('vm73im33pmq7err49fus5t1hn3pvcd5a', '37.211.35.118', '1696437840', '__ci_last_regenerate|i:1696437840;'), ('412ud3d23uv7ie476bd64huraiovf5u8', '37.211.35.118', '1696437840', '__ci_last_regenerate|i:1696437840;'), ('u1d5b5ppra5hb6o2jv2vnv8ni8ea42o9', '37.211.35.118', '1696437840', '__ci_last_regenerate|i:1696437840;'), ('vfp3ut63m6n9ilekl0u6p42i32nv6f8t', '37.211.35.118', '1696437841', '__ci_last_regenerate|i:1696437841;'), ('qgbpu6scbpk8dgvt5b87na64vripf1ts', '176.203.220.106', '1696438203', '__ci_last_regenerate|i:1696438203;'), ('f05d13d57527701b0mg1ip9c7liclkdm', '176.203.220.106', '1696438315', '__ci_last_regenerate|i:1696438315;'), ('cuskmpr3s3976rdidcsebv2g41k8s41c', '176.203.220.106', '1696438315', '__ci_last_regenerate|i:1696438315;'), ('lg3pntk3d20jv0bj9drfng7rguuhiofp', '176.203.220.106', '1696438315', '__ci_last_regenerate|i:1696438315;'), ('jeb7qrj1f71au83fihqherauci2n4qgi', '176.203.220.106', '1696438315', '__ci_last_regenerate|i:1696438315;'), ('euk12khsc4ssj65e17qlu1qiumpq8uvm', '176.203.220.106', '1696438317', '__ci_last_regenerate|i:1696438317;'), ('mq30kncjaf2n6ete62mdt1e5vqestg6l', '176.203.220.106', '1696438317', '__ci_last_regenerate|i:1696438317;'), ('i6lim7u00apallq070hk8kmn5lq1mdov', '176.203.220.106', '1696438317', '__ci_last_regenerate|i:1696438317;'), ('jb1luvk7r094nn62m9v97598hcaq7dtn', '176.203.220.106', '1696438317', '__ci_last_regenerate|i:1696438317;'), ('lr9i8h7jga8efgje56d7hmt5hdo5f6kh', '176.203.220.106', '1696438317', '__ci_last_regenerate|i:1696438317;'), ('jtphhh72if1gkm0kdg34nvmf4du14q9k', '176.203.220.106', '1696438317', '__ci_last_regenerate|i:1696438317;'), ('drvradedrlhk9jlmuhjh76s1i9s57kt3', '176.203.220.106', '1696438318', '__ci_last_regenerate|i:1696438318;'), ('pd2sudg5l81jlik3j68m4kpfi2lig9u0', '176.203.220.106', '1696438333', '__ci_last_regenerate|i:1696438333;'), ('cnvi02n412akk4hdinppk6krnmup9rhs', '176.203.220.106', '1696438336', '__ci_last_regenerate|i:1696438336;'), ('eghokit3bgr7dv1p2m6er729dr7g1unr', '176.203.220.106', '1696438336', '__ci_last_regenerate|i:1696438336;'), ('cjudvr2hjqs5qtk2rjtcfe0ofv7gip1o', '176.203.220.106', '1696438336', '__ci_last_regenerate|i:1696438336;'), ('mmis35dsain2dr6n88m2i3ockhj4cv6v', '176.203.220.106', '1696438336', '__ci_last_regenerate|i:1696438336;'), ('urm9pein5913bmd9cgi92t09k9adja6h', '176.203.220.106', '1696438337', '__ci_last_regenerate|i:1696438337;'), ('2cdds3pko1cev9n3jj806flirvdde33d', '176.203.220.106', '1696438337', '__ci_last_regenerate|i:1696438337;'), ('dvq544k2carut122jl5vc1h58tar519b', '176.203.220.106', '1696438337', '__ci_last_regenerate|i:1696438337;'), ('7hl6h72t1dhtoi1s21rg1s506j7823vn', '176.203.220.106', '1696438354', '__ci_last_regenerate|i:1696438354;'), ('02srovlotg93up3e90bpausnpg4b1cjb', '176.203.220.106', '1696438355', '__ci_last_regenerate|i:1696438355;'), ('9is9jrcrrp7s5l8nbun7hs21c886vbm2', '176.203.220.106', '1696438355', '__ci_last_regenerate|i:1696438355;'), ('2filiifebe4qs2t9soqr3e02plvlvskf', '176.203.220.106', '1696438355', '__ci_last_regenerate|i:1696438355;'), ('8s402c7qemu7v1kk4lbi38s5dfef38f5', '176.203.220.106', '1696438355', '__ci_last_regenerate|i:1696438355;'), ('kgucv9pomnv8rk38d4lopss8usmvkgea', '176.203.220.106', '1696438355', '__ci_last_regenerate|i:1696438355;'), ('b2lr8val1padvjf1deci73ap3m9ges6e', '176.203.220.106', '1696438355', '__ci_last_regenerate|i:1696438355;'), ('4qeh1im8c6bdgd24daoah8t6r5etckrb', '176.203.220.106', '1696438355', '__ci_last_regenerate|i:1696438355;'), ('kbbk9007i8heaf9k2fkpni0kftoirfd5', '176.203.220.106', '1696438356', '__ci_last_regenerate|i:1696438356;'), ('2a3c6fdkd34c4ufb68m5cvup3p6svn6j', '176.203.220.106', '1696438357', '__ci_last_regenerate|i:1696438357;'), ('o44cadn0gr84ov9596v9vdovqi108sbs', '176.203.220.106', '1696438755', '__ci_last_regenerate|i:1696438359;cart_items|a:0:{}language|s:7:\"english\";custom_session_limit|i:1697302576;user_id|s:3:\"458\";role_id|s:1:\"2\";role|s:4:\"User\";name|s:12:\"Noman Khalid\";is_instructor|s:1:\"0\";user_login|s:1:\"1\";countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"old\";}'), ('9qa5jrj034f12lqirju9inqn1cm0khnn', '176.203.220.106', '1696438360', '__ci_last_regenerate|i:1696438360;'), ('pngou46ldici47o61kmitagudnd06a83', '176.203.220.106', '1696438361', '__ci_last_regenerate|i:1696438361;'), ('bj7fuuvspkqmn36vj6gi4rlq510nc81o', '176.203.220.106', '1696438362', '__ci_last_regenerate|i:1696438362;'), ('agdfvujocp5tesdt868p5ri08l8noh18', '176.203.220.106', '1696438362', '__ci_last_regenerate|i:1696438362;'), ('dq8adklbl1cccp73rg5h44di25krada2', '176.203.220.106', '1696438362', '__ci_last_regenerate|i:1696438362;'), ('k1nl33mgj0nvbcpdeanpip5f5645mknc', '176.203.220.106', '1696438362', '__ci_last_regenerate|i:1696438362;'), ('5gnlt4a2pjshu3karmf09u5a1m6ruicf', '176.203.220.106', '1696438362', '__ci_last_regenerate|i:1696438362;'), ('22505ml06i1j64i4f6d1omeg0ie03uej', '176.203.220.106', '1696438363', '__ci_last_regenerate|i:1696438363;'), ('f71pqfj5ns9t37b7di886vcjlec5bptq', '176.203.220.106', '1696438483', '__ci_last_regenerate|i:1696438483;'), ('1sf7jqrpbars2ho39i1oau7dsn8kn1tr', '176.203.220.106', '1696438484', '__ci_last_regenerate|i:1696438484;'), ('0beae2rkt9lv5g7o6mlmg2r8p2j7ve8p', '176.203.220.106', '1696438484', '__ci_last_regenerate|i:1696438484;'), ('3s0e0g0c2nh5vggiljr9h54fa90er59h', '176.203.220.106', '1696438484', '__ci_last_regenerate|i:1696438484;'), ('2ar0h0kn3vb50k77qtf903k62edjv0ut', '176.203.220.106', '1696438484', '__ci_last_regenerate|i:1696438484;'), ('ha8drdpmp9vfvb307dhcsorlk6q2m7ib', '176.203.220.106', '1696438484', '__ci_last_regenerate|i:1696438484;'), ('rlh11nd9t8cja9ssei2ae6erthf8uroh', '176.203.220.106', '1696438484', '__ci_last_regenerate|i:1696438484;'), ('j1p6u4bd0c6uqnadkaqkck35gj9foo30', '176.203.220.106', '1696438529', '__ci_last_regenerate|i:1696438529;'), ('vvcqg50fk7r5vu2sn13m8k3cj092t2oc', '176.203.220.106', '1696438529', '__ci_last_regenerate|i:1696438529;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('dsattts64qd3uj2kcvtu9adg02ank07p', '176.203.220.106', '1696438530', '__ci_last_regenerate|i:1696438530;'), ('rd9r952oaree2e7q7n4021o1msobcm8d', '176.203.220.106', '1696438540', '__ci_last_regenerate|i:1696438540;'), ('j8ajjp8luapeipqf06mo6vspnmscbft1', '176.203.220.106', '1696438541', '__ci_last_regenerate|i:1696438541;'), ('9b0oalv05qmj2nbl915utnlph8mqm5kq', '176.203.220.106', '1696438549', '__ci_last_regenerate|i:1696438549;'), ('jf7sngje7pgojek3o0t001efjk2d5lnc', '176.203.220.106', '1696438550', '__ci_last_regenerate|i:1696438550;'), ('s1noatjidr9p3rcpl8fe9a7o14d3ottd', '176.203.220.106', '1696438551', '__ci_last_regenerate|i:1696438551;'), ('1neraph6rb0m506l47m7a1qhp33rnegh', '176.203.220.106', '1696438551', '__ci_last_regenerate|i:1696438551;'), ('45407glrpghqa0gp2t2bboi86skqc09h', '176.203.220.106', '1696438552', '__ci_last_regenerate|i:1696438552;'), ('raqf26k9a182ridtb5lhnqdkgtiklfk7', '176.203.220.106', '1696438552', '__ci_last_regenerate|i:1696438552;'), ('8jbrv9s34r2fmls3i98uq9l49bjn8ssn', '176.203.220.106', '1696438552', '__ci_last_regenerate|i:1696438552;'), ('cb7pd89j8k3kg0b4rrvn5sn7to92iek0', '176.203.220.106', '1696438552', '__ci_last_regenerate|i:1696438552;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('69fvv2j1420le63th3clq76caa5675eo', '176.203.220.106', '1696438559', '__ci_last_regenerate|i:1696438559;'), ('b1ui9pent9tccm24sbd5r0pjvr2lkkea', '176.203.220.106', '1696438561', '__ci_last_regenerate|i:1696438561;'), ('enggcst1k3rph8naglclss6frcuplijp', '176.203.220.106', '1696438582', '__ci_last_regenerate|i:1696438582;'), ('lqhbvrod7caudv207ei5ctsn3b191f54', '176.203.220.106', '1696438677', '__ci_last_regenerate|i:1696438677;'), ('gr0m80j1b6q5pd3hrij9df5n9qesuokn', '176.203.220.106', '1696438680', '__ci_last_regenerate|i:1696438680;'), ('ahv5rbaphk0k9tcfrk5qp8duvhidl0cm', '176.203.220.106', '1696438680', '__ci_last_regenerate|i:1696438680;'), ('t0vqhuv5nkmts1mncdf4ne50e48olqhb', '176.203.220.106', '1696438681', '__ci_last_regenerate|i:1696438681;'), ('0sca1hk5km5j84p12dhn15kloqo9sm09', '176.203.220.106', '1696438681', '__ci_last_regenerate|i:1696438681;'), ('ee3bbjqor208hl0ne55jksm42k8ai7oe', '176.203.220.106', '1696438683', '__ci_last_regenerate|i:1696438683;'), ('a8p67numpg8k8kte0ht9s6r81i9ek9m4', '176.203.220.106', '1696438683', '__ci_last_regenerate|i:1696438683;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('9fia3jp5drq8g54kn1bgf8m479trt1je', '176.203.220.106', '1696438683', '__ci_last_regenerate|i:1696438683;'), ('74tqu65vgpk39dredbgeieao2v22hsla', '176.203.220.106', '1696438683', '__ci_last_regenerate|i:1696438683;'), ('pqs4bbl5et0cl5a2h6ar55pev4dn847a', '176.203.220.106', '1696438690', '__ci_last_regenerate|i:1696438690;'), ('es9mr6jopq13id6r4eto9akm4cqqi8ij', '176.203.220.106', '1696438691', '__ci_last_regenerate|i:1696438691;'), ('kvh1a0sug3lgvhg0g271hvl7g8cchm7b', '176.203.220.106', '1696438691', '__ci_last_regenerate|i:1696438691;'), ('30efofimmr4opqtr2bmgdpdgq5m4pijg', '176.203.220.106', '1696438691', '__ci_last_regenerate|i:1696438691;'), ('psmbioqpob714fp9keqts22rv922i5hr', '176.203.220.106', '1696438693', '__ci_last_regenerate|i:1696438693;'), ('6ln06dfjcl1asgcembhjtq0uc5sjl6oe', '176.203.220.106', '1696438693', '__ci_last_regenerate|i:1696438693;'), ('rktc4jghuuboj9b795nre7lvccetf2pf', '176.203.220.106', '1696438693', '__ci_last_regenerate|i:1696438693;'), ('ec33culnt7oagjfnlksivgkdbhdhiuag', '176.203.220.106', '1696438693', '__ci_last_regenerate|i:1696438693;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('0b2dkitgom3tm03rf8ukuktt9aum2mc4', '176.203.220.106', '1696438695', '__ci_last_regenerate|i:1696438695;'), ('kq3lqm8gqdfjcjqib4pcv2meimmsrgro', '176.203.220.106', '1696438699', '__ci_last_regenerate|i:1696438699;'), ('0e7r1araf4rhhgbc3vct0rjbp2o4s3hn', '176.203.220.106', '1696438700', '__ci_last_regenerate|i:1696438700;'), ('aj1tlnqi56am57cfuri0l3jfjsda5veo', '176.203.220.106', '1696438701', '__ci_last_regenerate|i:1696438701;'), ('obkq4lduttp6pfs2bahf1melsm3jgp2a', '176.203.220.106', '1696438701', '__ci_last_regenerate|i:1696438701;'), ('a7bpivtbtunse0kslv05ifkfk05duqdi', '176.203.220.106', '1696438711', '__ci_last_regenerate|i:1696438711;'), ('vakjes92oti6v2oh9e34p166jhghoqir', '176.203.220.106', '1696438714', '__ci_last_regenerate|i:1696438714;'), ('n53t6lqpv3aopsr531dra21d1lb24iov', '176.203.220.106', '1696438714', '__ci_last_regenerate|i:1696438714;'), ('7pnhah6nkg45r39t9877m6f2n2geafen', '176.203.220.106', '1696438715', '__ci_last_regenerate|i:1696438714;'), ('ku2e55ll37rm70ijhq7g976n4b725gme', '176.203.220.106', '1696438715', '__ci_last_regenerate|i:1696438715;'), ('5b7nbp5v56busvfr0vloqardumtn1mta', '176.203.220.106', '1696438715', '__ci_last_regenerate|i:1696438715;'), ('hnc6po1adrb0ee6la93mahe5enjn05aq', '176.203.220.106', '1696438715', '__ci_last_regenerate|i:1696438715;'), ('uehs0bihu02prf6kpt88qb79p5c8ik3c', '176.203.220.106', '1696438716', '__ci_last_regenerate|i:1696438716;'), ('khb3oo1j1qr2ekm2tathhnclqns1r217', '176.203.220.106', '1696438716', '__ci_last_regenerate|i:1696438716;'), ('qkmi3a3vqte6nfd4c75umf3ftoj7chs9', '176.203.220.106', '1696438717', '__ci_last_regenerate|i:1696438717;'), ('o7e12eie45b4605054fcd6qe92d4qtg1', '176.203.220.106', '1696438718', '__ci_last_regenerate|i:1696438718;'), ('dhpbsuqdero6bkrg941pt14ja9s08307', '176.203.220.106', '1696438718', '__ci_last_regenerate|i:1696438718;'), ('7i8q6ppil3d8s4s8sg44rt12mosmduab', '176.203.220.106', '1696438721', '__ci_last_regenerate|i:1696438721;'), ('iiccvtma1frcrtg7f0ba55es4h3gmv0p', '176.203.220.106', '1696438721', '__ci_last_regenerate|i:1696438721;'), ('l960m10nqe0hq7o1u9np5u2n01og7qbn', '176.203.220.106', '1696438721', '__ci_last_regenerate|i:1696438721;'), ('c51r31lfvggg8k9ao3jn1p7r503t50vc', '176.203.220.106', '1696438721', '__ci_last_regenerate|i:1696438721;'), ('5oode17ggpin8t9bp6t7jeef5rmeq3ge', '176.203.220.106', '1696438722', '__ci_last_regenerate|i:1696438722;'), ('nbn360bqgm6gqdpfvtos2h3bf3k1tfch', '176.203.220.106', '1696438723', '__ci_last_regenerate|i:1696438723;'), ('ll4hk8nfepoeke920a552rbaaanktgvu', '176.203.220.106', '1696438725', '__ci_last_regenerate|i:1696438725;'), ('12uum3brp5lkdogrjmqo2v8hq2g76snd', '176.203.220.106', '1696438726', '__ci_last_regenerate|i:1696438726;'), ('mqngvkrq2pp0fhq37pcaiu69dogt56sq', '176.203.220.106', '1696438727', '__ci_last_regenerate|i:1696438727;'), ('7fgponfk6ef1nonfnaafd5cfopq46cfb', '176.203.220.106', '1696438728', '__ci_last_regenerate|i:1696438728;'), ('kj8adq715nm530cg42k69s4k2088a1va', '176.203.220.106', '1696438728', '__ci_last_regenerate|i:1696438728;'), ('9b632mc63b2qlfcntnulshb13u50sk9c', '176.203.220.106', '1696438728', '__ci_last_regenerate|i:1696438728;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('ub0tr1r69fo3eq55fc952jmhl8h828oo', '176.203.220.106', '1696438728', '__ci_last_regenerate|i:1696438728;'), ('hj5clohkd0oirbraimo9gkaque8qgmn8', '176.203.220.106', '1696438728', '__ci_last_regenerate|i:1696438728;'), ('qt90jvvcq82e598q0reshkto673324bm', '176.203.220.106', '1696438733', '__ci_last_regenerate|i:1696438733;'), ('al8bqmpb2rtk7np5n2kl3tifh1kvjfq0', '176.203.220.106', '1696438733', '__ci_last_regenerate|i:1696438733;'), ('n7eafmsj5gdlqvg5vicsr4lnk4b841nb', '176.203.220.106', '1696438733', '__ci_last_regenerate|i:1696438733;'), ('v18egased6jcscqhsthbee4d9i61tgvu', '176.203.220.106', '1696438733', '__ci_last_regenerate|i:1696438733;'), ('d70nfmm4hi5286irdbo0oqta5u739nba', '176.203.220.106', '1696438736', '__ci_last_regenerate|i:1696438736;'), ('j9tc2ivuebb9k0bvs5h6orm2te8abf12', '176.203.220.106', '1696438736', '__ci_last_regenerate|i:1696438736;'), ('h4romks7qo8ad6e8cj85ug1lr9qs3u99', '176.203.220.106', '1696438736', '__ci_last_regenerate|i:1696438736;'), ('6b6dfflrma0l2ovsnl5d8pc69be6geab', '176.203.220.106', '1696438736', '__ci_last_regenerate|i:1696438736;'), ('jfnho70ulpk016l5sju9vtnj1pmc07rn', '176.203.220.106', '1696438736', '__ci_last_regenerate|i:1696438736;'), ('paer0bdd8tmf4iljgqkeqkala64k0skk', '176.203.220.106', '1696438737', '__ci_last_regenerate|i:1696438737;'), ('nb88vvaedpmsbmmn9il6uffa2ucses1k', '176.203.220.106', '1696438739', '__ci_last_regenerate|i:1696438739;'), ('6co6ftg92ker0octsnkavj1hbgoo4382', '176.203.220.106', '1696438739', '__ci_last_regenerate|i:1696438739;'), ('709qf6lm61gejjtgsqvhmumludeq66ol', '176.203.220.106', '1696438739', '__ci_last_regenerate|i:1696438739;'), ('qdn20ra58mqhmpc0hq8hq70fjdcl776n', '176.203.220.106', '1696438740', '__ci_last_regenerate|i:1696438740;'), ('euqd4ojft4cji63m85s55b2bbdi5r1o3', '176.203.220.106', '1696438751', '__ci_last_regenerate|i:1696438751;'), ('051kqq5q0nq39m2g5915r73nm3475hml', '176.203.220.106', '1696438751', '__ci_last_regenerate|i:1696438751;'), ('t9cf5fjt6tbak1rt1obcitbhdtub8q6t', '176.203.220.106', '1696438751', '__ci_last_regenerate|i:1696438751;'), ('654dnt9vru4rmhn8r59uvvurgrkb398r', '176.203.220.106', '1696438752', '__ci_last_regenerate|i:1696438752;'), ('jcr9o85icddieh35p888f2ks4oa0c2fk', '176.203.220.106', '1696438753', '__ci_last_regenerate|i:1696438753;'), ('16dapii2v989fu7fuq7n4eo54ae35ha4', '176.203.220.106', '1696438753', '__ci_last_regenerate|i:1696438753;'), ('51hfqtiqoti06g0nj7np3p1a2m1cl1ao', '176.203.220.106', '1696438753', '__ci_last_regenerate|i:1696438753;'), ('sd9ijp6676phrh8irkm4ap8jdtfgobjt', '176.203.220.106', '1696438753', '__ci_last_regenerate|i:1696438753;'), ('dfg1jhmjnv9qcnf3nre9a94bg328kcko', '176.203.220.106', '1696438753', '__ci_last_regenerate|i:1696438753;'), ('kig8k1kooskpvqk8lic7ro5b2s23agtt', '176.203.220.106', '1696438754', '__ci_last_regenerate|i:1696438753;'), ('o0is7n7avb75t9tvkleuopr3s4jdu3h3', '176.203.220.106', '1696438757', '__ci_last_regenerate|i:1696438757;'), ('flb9vmets5tghls91uo22igc7q54heer', '176.203.220.106', '1696438757', '__ci_last_regenerate|i:1696438757;'), ('bu1dtlhgrm2cgv3tf7a1fdnjbi9urhic', '176.203.220.106', '1696438757', '__ci_last_regenerate|i:1696438757;'), ('eab839m8rttd2hfm5na4mioqhbbakbde', '176.203.220.106', '1696438757', '__ci_last_regenerate|i:1696438757;'), ('btk0vnu4mu5h19f1lsodpvn681bh3ovt', '176.203.220.106', '1696438802', '__ci_last_regenerate|i:1696438802;'), ('2lslgfd0lt0htsctd1n4bf7o4is8a5l0', '176.203.220.106', '1696438802', '__ci_last_regenerate|i:1696438802;'), ('arvi4gt2940phb0qlbe4kgpupl7vi336', '176.203.220.106', '1696438802', '__ci_last_regenerate|i:1696438802;'), ('o5deutab16048gsuq0auf401mgt2egqc', '176.203.220.106', '1696438802', '__ci_last_regenerate|i:1696438802;'), ('cn00po53fesg08tk2tel6j74rumsb32h', '176.203.220.106', '1696438802', '__ci_last_regenerate|i:1696438802;'), ('qeuqg59hl0ssogvkkeni6lnmm7pngvnc', '176.203.220.106', '1696438802', '__ci_last_regenerate|i:1696438802;'), ('vk3jntseeermn0jc3nhtfb7mqds8pdiu', '176.203.220.106', '1696438803', '__ci_last_regenerate|i:1696438803;'), ('mvridap47i2e0ghptpsng1rp3gdphs5s', '176.203.220.106', '1696438818', '__ci_last_regenerate|i:1696438818;'), ('rmhlfapqjdt8clfflf5rifatpc9k95fn', '176.203.220.106', '1696438819', '__ci_last_regenerate|i:1696438819;'), ('srcc0dk8lbcbrbspjs69i3ojd3eonup9', '176.203.220.106', '1696438819', '__ci_last_regenerate|i:1696438819;'), ('qpopdae0c12648drdf88if40an235lfs', '176.203.220.106', '1696438819', '__ci_last_regenerate|i:1696438819;'), ('a3v1to3odigisahg2e49d736hs9uljoi', '176.203.220.106', '1696438819', '__ci_last_regenerate|i:1696438819;'), ('iepq60br3p6h66vtvo7f5iav4atrmv1a', '176.203.220.106', '1696438819', '__ci_last_regenerate|i:1696438819;'), ('2518pgqq8bggqntdid4osnl7573i6cab', '176.203.220.106', '1696438819', '__ci_last_regenerate|i:1696438819;'), ('3qalshmihs4182dqei38hl6m958qr3rp', '176.203.220.106', '1696438820', '__ci_last_regenerate|i:1696438820;'), ('o2br2h32u1rcttf90vccskp41ood7mri', '176.203.220.106', '1696438820', '__ci_last_regenerate|i:1696438820;'), ('2hhm5bg5u7ma07lbrk0hbvr26gsgi204', '176.203.220.106', '1696438820', '__ci_last_regenerate|i:1696438820;'), ('prte47b3900upqp53kbh1gqijgqnu10t', '176.203.220.106', '1696438820', '__ci_last_regenerate|i:1696438820;'), ('9lg3lffjarppmdj0p2tusprvaikibqb4', '176.203.220.106', '1696438821', '__ci_last_regenerate|i:1696438821;'), ('ldkbjv2c94vqcsnqhdoh4idfc4vr0bfp', '176.203.220.106', '1696438825', '__ci_last_regenerate|i:1696438825;'), ('uaique6ffaraeloell71e3qg123b2qhq', '176.203.220.106', '1696438825', '__ci_last_regenerate|i:1696438825;'), ('oloqph9rhiirfhp8qihga60kv0raokv6', '176.203.220.106', '1696438825', '__ci_last_regenerate|i:1696438825;'), ('p763ncd5pl8iifu80oegmrnv5hrjmbv7', '176.203.220.106', '1696438825', '__ci_last_regenerate|i:1696438825;'), ('6me0291g8opuilh8cip7ij3pu8iooi89', '176.203.220.106', '1696438825', '__ci_last_regenerate|i:1696438825;'), ('qm2j79g8cmcqik9qfh2agsel0pa4lcvc', '176.203.220.106', '1696438825', '__ci_last_regenerate|i:1696438825;'), ('pk8inpebtj011v77gfhualp4a63falai', '176.203.220.106', '1696438825', '__ci_last_regenerate|i:1696438825;'), ('29pn6s02ce83mkcven6rhrd7stimhtt7', '176.203.220.106', '1696438866', '__ci_last_regenerate|i:1696438866;'), ('eg1o4l210cuj9avmbr6tf3leqbc00ghm', '37.211.35.118', '1696438905', '__ci_last_regenerate|i:1696438905;'), ('o98fmqq4hnvu9361d7ckv3jr2fccr8e5', '37.211.35.118', '1696438971', '__ci_last_regenerate|i:1696438951;'), ('slifa35opk6f61m1a89ul4dnq2d9gn3s', '37.211.35.118', '1696439026', '__ci_last_regenerate|i:1696439006;'), ('8mgvli18l6o9iv6ad2ov7lfo5aiasrmp', '37.211.35.118', '1696440161', '__ci_last_regenerate|i:1696440161;'), ('er0o4am8ppoarstl5e6in769u5u2ul0c', '37.211.35.118', '1696440175', '__ci_last_regenerate|i:1696440175;'), ('f64vsa473nerafpc96nagfqotgcmklph', '37.211.35.118', '1696440206', '__ci_last_regenerate|i:1696440192;'), ('vsl6sv7tk06v1567c7h5f3iiuipbhsm1', '37.111.217.194', '1696483853', '__ci_last_regenerate|i:1696483853;'), ('8pebfo9m9ft5kosf1vaes1r30oc64of2', '37.111.217.194', '1696483856', '__ci_last_regenerate|i:1696483856;'), ('c3jaifiqcmd2b4ero329addn90tci3oq', '37.111.217.194', '1696483856', '__ci_last_regenerate|i:1696483856;'), ('d9qq67ja0kchb55ibk250p329h40hi0p', '37.111.217.194', '1696483856', '__ci_last_regenerate|i:1696483856;'), ('a1qp9or57pmilo547o684facgmn90s8u', '37.111.217.194', '1696483856', '__ci_last_regenerate|i:1696483856;'), ('l8ob5g4q0jaiejh12c96bisjrpm8cmvl', '37.111.217.194', '1696483856', '__ci_last_regenerate|i:1696483856;'), ('v8tvkiac8me1hkjupu677prgqojaqhbd', '37.111.217.194', '1696483856', '__ci_last_regenerate|i:1696483856;'), ('r7gubcu1jtu8kmrojdgvfrr8ukto9plt', '37.111.217.194', '1696483856', '__ci_last_regenerate|i:1696483856;'), ('kej1lqnei4o60s0tn2o3p1m81jigc8tu', '37.111.217.194', '1696483864', '__ci_last_regenerate|i:1696483864;'), ('givufcjmab3cei2qliealkhdal4n8b0u', '37.111.217.194', '1696483864', '__ci_last_regenerate|i:1696483864;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('tk4i3kkfslckl2vbi5s4a3je3sgcc3sa', '37.111.217.194', '1696483864', '__ci_last_regenerate|i:1696483864;'), ('gnl6tpgdgptt6cotn240nornmfj4nn95', '37.111.217.194', '1696483870', '__ci_last_regenerate|i:1696483870;'), ('e4kma94fr69tqb3uat2dd8ogms2udfrl', '37.111.217.194', '1696483871', '__ci_last_regenerate|i:1696483871;'), ('0ujsj5163130pi19toqapdmtol474o1t', '37.111.217.194', '1696483878', '__ci_last_regenerate|i:1696483878;'), ('4ovn9nm7auoga76t306jbcp3rekdf16m', '37.111.217.194', '1696483878', '__ci_last_regenerate|i:1696483878;'), ('77rp1iv9573ohq1dd9eaq1co985l52cp', '37.111.217.194', '1696483879', '__ci_last_regenerate|i:1696483879;'), ('sp3eb537uuj7pb45jfn1r2edbu6k6fis', '37.111.217.194', '1696483879', '__ci_last_regenerate|i:1696483879;'), ('ro49v9g73nhv6mt0htlidmumhh2igso9', '37.111.217.194', '1696483879', '__ci_last_regenerate|i:1696483879;'), ('16lej8u1q8h4eiuk2qkij4c0kda2bjbi', '37.111.217.194', '1696483879', '__ci_last_regenerate|i:1696483879;'), ('gdcpglnc3jhdqgnih3otv1tbmkevcnd2', '37.111.217.194', '1696483879', '__ci_last_regenerate|i:1696483879;'), ('i46vv6k3u0umdtukfdm9mg4pnjhkbunu', '37.111.217.194', '1696483879', '__ci_last_regenerate|i:1696483879;'), ('k61u328bquht9m3esd9df2gl108h57vk', '37.111.217.194', '1696483881', '__ci_last_regenerate|i:1696483881;'), ('j9bq3p9jf0c0bgsdk7ste6kf08i69gie', '37.111.217.194', '1696483881', '__ci_last_regenerate|i:1696483881;'), ('klc8ec59vst5hscoshfop6bff6bucglv', '37.111.217.194', '1696483881', '__ci_last_regenerate|i:1696483881;'), ('q1m7ubib0o75lf8pl12u01m8ifqim11o', '37.111.217.194', '1696483881', '__ci_last_regenerate|i:1696483881;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('qrlljvtcplp34vkiusc1u896f167u3pq', '37.111.217.194', '1696483884', '__ci_last_regenerate|i:1696483884;'), ('mu58qk1et4ruh8i60j0btcvffm8u253j', '37.111.217.194', '1696483907', '__ci_last_regenerate|i:1696483907;'), ('4994or722h26e756spfh1ftk450jba9r', '37.111.217.194', '1696483910', '__ci_last_regenerate|i:1696483910;'), ('jk1f6da8kp1kgcd1u1t3na54n4qj7nd4', '37.111.217.194', '1696483911', '__ci_last_regenerate|i:1696483911;'), ('ppok8vo271hu5fvrbg78uuvtgj3qu7nj', '37.111.217.194', '1696483912', '__ci_last_regenerate|i:1696483912;'), ('7gitasqjq6mr49mb90qq8ekgm2943ccc', '37.111.217.194', '1696483912', '__ci_last_regenerate|i:1696483912;'), ('4v546sjegbboqkf0img3jh5c5h0kqb6t', '37.111.217.194', '1696483912', '__ci_last_regenerate|i:1696483912;'), ('htai1k1sds73m3m1rhsdfs9gmprh7clh', '37.111.217.194', '1696483912', '__ci_last_regenerate|i:1696483912;'), ('18qvgulsi9u0uoeh7f67epb42mrk36fa', '37.111.217.194', '1696483912', '__ci_last_regenerate|i:1696483912;'), ('hbhcm1cdhkd0dm4am4okpg4a1m60npi8', '37.111.217.194', '1696483912', '__ci_last_regenerate|i:1696483912;'), ('netlcb7385c470042sfq0cqf47gj6i0j', '37.111.217.194', '1696483912', '__ci_last_regenerate|i:1696483912;'), ('t304tpf7659q1nijc619crno78kor6mg', '37.111.217.194', '1696483914', '__ci_last_regenerate|i:1696483914;'), ('m6qlhqgs8de1j3u64fivdcr4ipttvucs', '37.111.217.194', '1696483914', '__ci_last_regenerate|i:1696483914;'), ('90mvd8li6uop6julibvkbpstmhi4da74', '37.111.217.194', '1696483915', '__ci_last_regenerate|i:1696483915;'), ('198nn8g1iap7c83vi0hi8cthhkohard7', '37.111.217.194', '1696483915', '__ci_last_regenerate|i:1696483915;'), ('53kftetpeo7baktop81v75hjk5m9t0g7', '37.111.217.194', '1696483915', '__ci_last_regenerate|i:1696483915;'), ('e9738ig4dmciaq6otnge9ohnpnnodpfi', '37.111.217.194', '1696483915', '__ci_last_regenerate|i:1696483915;'), ('4n62rq85f3htlkt0ulinkkj59m0da94k', '37.111.217.194', '1696483915', '__ci_last_regenerate|i:1696483915;'), ('nejpnu6apquniej9tj3mlscdrfchdd6c', '37.111.217.194', '1696483915', '__ci_last_regenerate|i:1696483915;'), ('ujm1jofvkh8me7mb0bf9hb8c9nn5uo6f', '37.111.217.194', '1696483916', '__ci_last_regenerate|i:1696483916;'), ('atdhro8ftn0rt69es2o32ocu0a7of3ib', '37.111.217.194', '1696483916', '__ci_last_regenerate|i:1696483916;'), ('1dfr1ndgievnjq85u8nqj7vqfpdgdlps', '37.111.217.194', '1696483916', '__ci_last_regenerate|i:1696483916;'), ('qgpjcr8ncugl3p4ci85osraui5r2gffr', '37.111.217.194', '1696483916', '__ci_last_regenerate|i:1696483916;countCall|i:1;__ci_vars|a:1:{s:9:\"countCall\";s:3:\"new\";}'), ('6pa6k3eb41e7uod9htaudqdjuqhfh05h', '37.111.217.194', '1696483918', '__ci_last_regenerate|i:1696483918;'), ('a7tm54u4p51d8s9igmdo6gi9vkv3cpjh', '37.111.217.194', '1696483931', '__ci_last_regenerate|i:1696483931;'), ('noksb5r2v4rfuvqks2j30lovmpc4jc61', '37.111.217.194', '1696483931', '__ci_last_regenerate|i:1696483931;'), ('h7ah7c7e48pii9vvj2oh3b34heotnvd1', '37.111.217.194', '1696483931', '__ci_last_regenerate|i:1696483931;'), ('qttmcc9p9s1e3a0r91odbv3a0thf2uk0', '37.111.217.194', '1696483931', '__ci_last_regenerate|i:1696483931;'), ('jit92sf892jmcebnreiukskvqo772aa6', '37.111.217.194', '1696483932', '__ci_last_regenerate|i:1696483932;'), ('ldk3jnnnkjjruvp6kb1rar4eqop4augl', '37.111.217.194', '1696483934', '__ci_last_regenerate|i:1696483934;'), ('f8sam1clnc70phn1506e1divsh56ccin', '37.111.217.194', '1696483934', '__ci_last_regenerate|i:1696483934;'), ('3chrl7030941lq6vlfokc7euf9ru0i6t', '37.111.217.194', '1696483974', '__ci_last_regenerate|i:1696483974;'), ('kg97cd78hsd5aopcgfkcvri0maaufvrm', '37.111.217.194', '1696484041', '__ci_last_regenerate|i:1696484041;'), ('rc7mr0gm2223kcf7661eo957f0d2iekk', '37.111.217.194', '1696484041', '__ci_last_regenerate|i:1696484041;'), ('hat6m533bve63blb9hq2ea53t3jvtjd6', '37.111.217.194', '1696484041', '__ci_last_regenerate|i:1696484041;'), ('h1r1sth9bds097lag508p19ej6c2ampn', '37.111.217.194', '1696484041', '__ci_last_regenerate|i:1696484041;'), ('o3plbot2hl622jtjjt5eho9bk3ijoftt', '37.111.217.194', '1696484041', '__ci_last_regenerate|i:1696484041;'), ('avrakmue4s1vdv94sftgagjrimspvgo8', '37.111.217.194', '1696484041', '__ci_last_regenerate|i:1696484041;'), ('s6ih9l2a0omalgnltbijchtpd1t0kr1f', '37.111.217.194', '1696484042', '__ci_last_regenerate|i:1696484042;'), ('18dgmqn4f6evg16c6n699injdesgdgap', '37.111.217.194', '1696484043', '__ci_last_regenerate|i:1696484043;'), ('87e0cjo0encjhd9da17mf9k0okuoj40r', '37.111.217.194', '1696484043', '__ci_last_regenerate|i:1696484043;'), ('3i94mhirbh0ntsplrpkefdi6elj59458', '37.111.217.194', '1696484043', '__ci_last_regenerate|i:1696484043;'), ('h450lo4kl2jfj8nuegmh51esnf73iats', '37.111.217.194', '1696484044', '__ci_last_regenerate|i:1696484044;'), ('2v788lkf7q366jgihv7rh6rhqq7jinsc', '37.111.217.194', '1696484208', '__ci_last_regenerate|i:1696484208;'), ('4fkbi5slfn6f2c45t1iif272m34flvj3', '37.111.217.194', '1696484211', '__ci_last_regenerate|i:1696484211;'), ('6jjmdcnv0255oqlujf6au1u6lm9givv8', '37.111.217.194', '1696484211', '__ci_last_regenerate|i:1696484211;'), ('2dhqim2k2pndoa0e9n8akp0rja68p9it', '37.111.217.194', '1696484211', '__ci_last_regenerate|i:1696484211;'), ('cppk9f6e3amd6gu80qhb032tnp77dna3', '37.111.217.194', '1696484211', '__ci_last_regenerate|i:1696484211;'), ('b58jr031qcqkiugu389e113fj3h33s6l', '37.111.217.194', '1696484211', '__ci_last_regenerate|i:1696484211;'), ('p97f0schugfimv55hul40av3ciq09k38', '37.111.217.194', '1696484211', '__ci_last_regenerate|i:1696484211;'), ('vpb8amri48vqkodgmgbjo3gbfqlaecic', '37.111.217.194', '1696484212', '__ci_last_regenerate|i:1696484212;'), ('5qd8v1hb90pglk1oflun0er2bgg23kqe', '37.111.217.194', '1696484246', '__ci_last_regenerate|i:1696484226;'), ('k3c92lah94a3ko7ojm8fkji95fvc3f0e', '37.111.217.194', '1696484295', '__ci_last_regenerate|i:1696484275;'), ('hfkuo95ge0vrq8r24495huf1kc628k3u', '37.111.217.194', '1696484350', '__ci_last_regenerate|i:1696484350;'), ('gouqbapss92it0bpg2cfm07gidkmvusd', '37.111.217.194', '1696484351', '__ci_last_regenerate|i:1696484351;'), ('bs50m540bqtc6kociu8rv68flo068gsl', '37.111.217.194', '1696484351', '__ci_last_regenerate|i:1696484351;'), ('adbdv0jom0q7e7jtjqmp4nhq1n5rgv33', '37.111.217.194', '1696484351', '__ci_last_regenerate|i:1696484351;'), ('meej8obhkidlagnkalam35ao7dbd2bfj', '37.111.217.194', '1696484351', '__ci_last_regenerate|i:1696484351;'), ('pri3nl8o4urn1dc99nue8uqdv1teht6k', '37.111.217.194', '1696484351', '__ci_last_regenerate|i:1696484351;'), ('jddiu3i8a48l5k63d5gd72iipqfiski6', '37.111.217.194', '1696484351', '__ci_last_regenerate|i:1696484351;'), ('n808det9faqcm0ltf37kad9uedq087t1', '37.111.217.194', '1696484352', '__ci_last_regenerate|i:1696484352;'), ('viup5ft3k8sig49qcl903j0gc6lm7cs0', '37.111.217.194', '1696484353', '__ci_last_regenerate|i:1696484353;'), ('mnip3qb525fppo98g79ol91cnh1u3a6g', '37.111.217.194', '1696484353', '__ci_last_regenerate|i:1696484353;'), ('hb02njv84bbbi4qa3li56u9b8eqgct56', '37.111.217.194', '1696484353', '__ci_last_regenerate|i:1696484353;'), ('4gli39l2gjdsrp896qsvpj13ur2hnfrc', '37.111.217.194', '1696484353', '__ci_last_regenerate|i:1696484353;'), ('riru2uaalld1u8n3mnnrh6sd06ojamr1', '37.111.217.194', '1696484354', '__ci_last_regenerate|i:1696484354;'), ('dk02p0bshs8ohlii29aehedq56pqk2k6', '37.111.217.194', '1696484357', '__ci_last_regenerate|i:1696484357;'), ('urvpssrca71u5mqke0gc1ofdct27b1d1', '37.111.217.194', '1696484357', '__ci_last_regenerate|i:1696484357;'), ('cgpdaj5v8sm0h5hpsn3l6rj1jdlqlt9p', '37.111.217.194', '1696484357', '__ci_last_regenerate|i:1696484357;'), ('70tfkm5f65rkohk0j1mkob538bnvpjkr', '37.111.217.194', '1696484357', '__ci_last_regenerate|i:1696484357;'), ('opcr53r0ac8sb7mnivfke0t1cbsas9qr', '37.111.217.194', '1696484357', '__ci_last_regenerate|i:1696484357;'), ('feg2j02qh9vjv8tpd85cbeufilra04h1', '37.111.217.194', '1696484357', '__ci_last_regenerate|i:1696484357;'), ('g9lf55uohp2e1q828h7ninvp2rsphhsg', '37.111.217.194', '1696484357', '__ci_last_regenerate|i:1696484357;'), ('dv3kb397fo9cfu4o403no1k9t3s373hh', '103.67.156.157', '1696484683', '__ci_last_regenerate|i:1696484683;'), ('61e23mbmvn7vslqja2d43emk8q6sju16', '103.67.156.157', '1696484687', '__ci_last_regenerate|i:1696484687;'), ('ruc8pk4p71lafsaupgrckql9v3ncc9cc', '103.67.156.157', '1696484687', '__ci_last_regenerate|i:1696484687;'), ('en4c98o87m8otdl2e6rqe784pkes2m4m', '103.67.156.157', '1696484687', '__ci_last_regenerate|i:1696484687;'), ('vb507pql6mhn6j2i3skjamrpdfh3r64g', '103.67.156.157', '1696484687', '__ci_last_regenerate|i:1696484687;'), ('6ltkvt8mrr86f1v3mqko7r72jvc0513g', '103.67.156.157', '1696484687', '__ci_last_regenerate|i:1696484687;'), ('ir1qkncraqm2a1td7fm2d1qaaqd3uhdl', '103.67.156.157', '1696484687', '__ci_last_regenerate|i:1696484687;'), ('hi9cr809do6rsvuun3lai1v2scjnptqu', '103.67.156.157', '1696484687', '__ci_last_regenerate|i:1696484687;'), ('f4qouu2k0qqbda80rfcicq4nk44u8u34', '103.67.156.157', '1696484822', '__ci_last_regenerate|i:1696484802;');
DROP TABLE IF EXISTS `comment`;
CREATE TABLE `comment` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `body` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `user_id` int DEFAULT NULL,
  `commentable_id` int DEFAULT NULL,
  `commentable_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `date_added` int DEFAULT NULL,
  `last_modified` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `coupons`;
CREATE TABLE `coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `discount_percentage` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_at` int DEFAULT NULL,
  `expiry_date` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `course`;
CREATE TABLE `course` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `short_description` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `description` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `outcomes` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `faqs` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `language` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `sub_category_id` int DEFAULT NULL,
  `section` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `requirements` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `price` double DEFAULT NULL,
  `discount_flag` int DEFAULT '0',
  `discounted_price` double DEFAULT NULL,
  `level` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `user_id` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `thumbnail` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `video_url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `date_added` int DEFAULT NULL,
  `last_modified` int DEFAULT NULL,
  `course_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `is_top_course` int DEFAULT '0',
  `is_admin` int DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `course_overview_provider` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `meta_keywords` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `meta_description` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `is_free_course` int DEFAULT NULL,
  `multi_instructor` int NOT NULL DEFAULT '0',
  `enable_drip_content` int NOT NULL,
  `creator` int DEFAULT NULL,
  `expiry_period` int DEFAULT NULL,
  `certificate_year` int DEFAULT NULL,
  `certificate_id` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `issued_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `course` (`id`, `title`, `short_description`, `description`, `outcomes`, `faqs`, `language`, `category_id`, `sub_category_id`, `section`, `requirements`, `price`, `discount_flag`, `discounted_price`, `level`, `user_id`, `thumbnail`, `video_url`, `date_added`, `last_modified`, `course_type`, `is_top_course`, `is_admin`, `status`, `course_overview_provider`, `meta_keywords`, `meta_description`, `is_free_course`, `multi_instructor`, `enable_drip_content`, `creator`, `expiry_period`, `certificate_year`, `certificate_id`, `issued_date`) VALUES ('1', 'Hydrogen Sulfide (H2S) + SCBA', 'H2S (Hydrogen Sulphide) is a gas that can be created by natural biological processes or by human activity and poses a serious threat to people or assets because of its extremely toxic and corrosive properties. It is important, therefore, for all personnel working in construction industry, sewage and water treatment plants, and oil &amp; gas facilities to be competent in emergency response training. In addition become aware of the necessary practices to stay and work in an environment with potential exposure to H2S gas. This training will cover the characteristics of Hydrogen Sulphide gas and the potential physiological effects of exposure as well as the use of H2S detection equipment and escape breathing apparatus.', '<ul xss=\"removed\"><li>Introduction TO H2S Gas </li><li>Other names used to describe H2S </li><li>Hydrogen Sulfide H2S properties & characteristics </li><li>Where H2S can be located Parts per million (ppm) as a measurement parameter </li><li>Factors affecting individual susceptibility to H2S </li><li>Hazard associated with H2S </li><li>Occupational exposure limits to H2S </li><li>Safety Signs (flags color) </li><li>H2S alarms and gas detector</li><li>Protection from H2S </li><li>Detection of H2S </li><li>Escape </li><li>Rescue </li><li>Recovery </li><li>Practical Assessment: </li><li>Donning & operating (including checks) an escape breathing apparatus (SCBA) with a mask within 30 seconds<ul><li>Stage 1: Trial</li><li>Stage 2: Actual</li><li>Stage 3: Final exercise and timing</li></ul></li></ul><p></p><ul></ul>', '[\"Outcome 1\",\"Outcome 2\",\"Outcome 3\"]', '{\"Who is it for?\":\"Any personnel working in a water \\u2013 chemical treatment facility, Oil and Gas industry, industrial areas and construction areas.\"}', 'english', '1', '2', '[1,4]', '[\"Requirements4\",\"Requirement 1\",\"Requirement 2\",\"Requirement 3 \"]', '150', NULL, '0', 'advanced', '1', NULL, '', '1692482400', '1696179293', 'general', '1', '1', 'active', '', '', '', '1', '0', '1', '1', '12', '10', 'NEFT2023401063475', '2023-08-31'), ('2', 'First AID-CPR-AED', 'This course is essential to provide any personnel with basic and simple instructions and procedures in case of any medical emergency occurs at work place , home ,school or even on the street. This training will educate participants on the proper way of performing Cardiopulmonary Resuscitation (CPR), using the Automated External Defibrillator (AED) in a safe, timely, and effective manner and responding to any kind of medical emergency professionally until medical treatment can be accessed. Various medical scenarios will be covered along with their ways of prevention and treatment. The main objective of this course is to communicate how to preserve life, prevent worsening and promote recovery to an injured person.\r\n', '<h1 xss=removed>Outline</h1><ul xss=removed><li>Introduction</li><li>Purpose of First Aid</li><li>Contents of the First Aid Kit</li><li>Define and conduct Cardiopulmonary Resuscitation (CPR)</li><li>Using an Automated External Defibrillator (AED)</li><li>Respond to choking in adults, children, and infants</li><li>Treatment of unconscious casualties</li><li>Recovery Position for adults, children, and infants</li><li>Communication and delegation in an emergency</li><li>Emergency services numbers</li><li>Good Samaritan Law</li><li>Universal Precautions</li><li>Emergency action plan</li><li>Skills of a First Aider</li><li>Respond to heart attack victims</li><li>Nose bleed and injury</li><li>Control internal and external bleeding</li><li>Respond to impaled object</li><li>Treat burns</li><li>Treat broken bones and dislocation</li><li>Respond to spinal injuries</li><li>Respond to Shock</li><li>Identify and respond to stroke</li><li>Treatment of wounds</li><li>Extreme temperatures emergencies</li><li>Respond and treat animal and insect bites</li></ul>', '[]', '[]', 'english', '1', '2', '[3]', '[]', '0', NULL, '0', 'beginner', '3', NULL, '', '1692482400', '1692625569', 'general', '0', '0', 'active', '', '', '', '1', '0', '1', '3', '12', '2', 'NEFT2023504161797', '2023-09-19'), ('13', 'test', 'sdf', '<p>sdf<br></p>', '[]', '[]', 'english', '1', '2', '[]', '[]', '0', NULL, '0', 'beginner', '1', NULL, '', '1693519200', '1695401703', 'general', '1', '1', 'active', '', '', '', NULL, '1', '0', '1', NULL, '5', 'NEFT2023295592356', '2023-09-19'), ('14', 'New Course For Test', 'This is a test course', '<p>test course description<br></p>', '[\"test\"]', '{\"test\":\"test\"}', 'english', '1', '2', '[5]', '[\"test\"]', '10', NULL, '0', 'beginner', '1', NULL, '', '1695420000', '1695485729', 'general', '0', '1', 'active', '', '', '', '1', '0', '1', '1', NULL, '2', 'NEFT2023834506656', NULL);
DROP TABLE IF EXISTS `currency`;
CREATE TABLE `currency` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `symbol` varchar(255) DEFAULT NULL,
  `paypal_supported` int DEFAULT NULL,
  `stripe_supported` int DEFAULT NULL,
  `ccavenue_supported` int DEFAULT '0',
  `iyzico_supported` int DEFAULT '0',
  `paystack_supported` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=utf8mb3;
INSERT INTO `currency` (`id`, `name`, `code`, `symbol`, `paypal_supported`, `stripe_supported`, `ccavenue_supported`, `iyzico_supported`, `paystack_supported`) VALUES ('1', 'US Dollar', 'USD', '$', '1', '1', '0', '0', '0'), ('2', 'Albanian Lek', 'ALL', 'Lek', '0', '1', '0', '0', '0'), ('3', 'Algerian Dinar', 'DZD', 'دج', '1', '1', '0', '0', '0'), ('4', 'Angolan Kwanza', 'AOA', 'Kz', '1', '1', '0', '0', '0'), ('5', 'Argentine Peso', 'ARS', '$', '1', '1', '0', '0', '0'), ('6', 'Armenian Dram', 'AMD', '֏', '1', '1', '0', '0', '0'), ('7', 'Aruban Florin', 'AWG', 'ƒ', '1', '1', '0', '0', '0'), ('8', 'Australian Dollar', 'AUD', '$', '1', '1', '0', '0', '0'), ('9', 'Azerbaijani Manat', 'AZN', 'm', '1', '1', '0', '0', '0'), ('10', 'Bahamian Dollar', 'BSD', 'B$', '1', '1', '0', '0', '0'), ('11', 'Bahraini Dinar', 'BHD', '.د.ب', '1', '1', '0', '0', '0'), ('12', 'Bangladeshi Taka', 'BDT', '৳', '1', '1', '0', '0', '0'), ('13', 'Barbadian Dollar', 'BBD', 'Bds$', '1', '1', '0', '0', '0'), ('14', 'Belarusian Ruble', 'BYR', 'Br', '0', '0', '0', '0', '0'), ('15', 'Belgian Franc', 'BEF', 'fr', '1', '1', '0', '0', '0'), ('16', 'Belize Dollar', 'BZD', '$', '1', '1', '0', '0', '0'), ('17', 'Bermudan Dollar', 'BMD', '$', '1', '1', '0', '0', '0'), ('18', 'Bhutanese Ngultrum', 'BTN', 'Nu.', '1', '1', '0', '0', '0'), ('19', 'Bitcoin', 'BTC', '฿', '1', '1', '0', '0', '0'), ('20', 'Bolivian Boliviano', 'BOB', 'Bs.', '1', '1', '0', '0', '0'), ('21', 'Bosnia', 'BAM', 'KM', '1', '1', '0', '0', '0'), ('22', 'Botswanan Pula', 'BWP', 'P', '1', '1', '0', '0', '0'), ('23', 'Brazilian Real', 'BRL', 'R$', '1', '1', '0', '0', '0'), ('24', 'British Pound Sterling', 'GBP', '£', '1', '1', '0', '0', '0'), ('25', 'Brunei Dollar', 'BND', 'B$', '1', '1', '0', '0', '0'), ('26', 'Bulgarian Lev', 'BGN', 'Лв.', '1', '1', '0', '0', '0'), ('27', 'Burundian Franc', 'BIF', 'FBu', '1', '1', '0', '0', '0'), ('28', 'Cambodian Riel', 'KHR', 'KHR', '1', '1', '0', '0', '0'), ('29', 'Canadian Dollar', 'CAD', '$', '1', '1', '0', '0', '0'), ('30', 'Cape Verdean Escudo', 'CVE', '$', '1', '1', '0', '0', '0'), ('31', 'Cayman Islands Dollar', 'KYD', '$', '1', '1', '0', '0', '0'), ('32', 'CFA Franc BCEAO', 'XOF', 'CFA', '1', '1', '0', '0', '0'), ('33', 'CFA Franc BEAC', 'XAF', 'FCFA', '1', '1', '0', '0', '0'), ('34', 'CFP Franc', 'XPF', '₣', '1', '1', '0', '0', '0'), ('35', 'Chilean Peso', 'CLP', '$', '1', '1', '0', '0', '0'), ('36', 'Chinese Yuan', 'CNY', '¥', '1', '1', '0', '0', '0'), ('37', 'Colombian Peso', 'COP', '$', '1', '1', '0', '0', '0'), ('38', 'Comorian Franc', 'KMF', 'CF', '1', '1', '0', '0', '0'), ('39', 'Congolese Franc', 'CDF', 'FC', '1', '1', '0', '0', '0'), ('40', 'Costa Rican ColÃ³n', 'CRC', '₡', '1', '1', '0', '0', '0'), ('41', 'Croatian Kuna', 'HRK', 'kn', '1', '1', '0', '0', '0'), ('42', 'Cuban Convertible Peso', 'CUC', '$, CUC', '1', '1', '0', '0', '0'), ('43', 'Czech Republic Koruna', 'CZK', 'Kč', '1', '1', '0', '0', '0'), ('44', 'Danish Krone', 'DKK', 'Kr.', '1', '1', '0', '0', '0'), ('45', 'Djiboutian Franc', 'DJF', 'Fdj', '1', '1', '0', '0', '0'), ('46', 'Dominican Peso', 'DOP', '$', '1', '1', '0', '0', '0'), ('47', 'East Caribbean Dollar', 'XCD', '$', '1', '1', '0', '0', '0'), ('48', 'Egyptian Pound', 'EGP', 'ج.م', '1', '1', '0', '0', '0'), ('49', 'Eritrean Nakfa', 'ERN', 'Nfk', '1', '1', '0', '0', '0'), ('50', 'Estonian Kroon', 'EEK', 'kr', '1', '1', '0', '0', '0'), ('51', 'Ethiopian Birr', 'ETB', 'Nkf', '1', '1', '0', '0', '0'), ('52', 'Euro', 'EUR', '€', '1', '1', '0', '0', '0'), ('53', 'Falkland Islands Pound', 'FKP', '£', '1', '1', '0', '0', '0'), ('54', 'Fijian Dollar', 'FJD', 'FJ$', '1', '1', '0', '0', '0'), ('55', 'Gambian Dalasi', 'GMD', 'D', '1', '1', '0', '0', '0'), ('56', 'Georgian Lari', 'GEL', 'ლ', '1', '1', '0', '0', '0'), ('57', 'German Mark', 'DEM', 'DM', '1', '1', '0', '0', '0'), ('58', 'Ghanaian Cedi', 'GHS', 'GH₵', '1', '1', '0', '0', '0'), ('59', 'Gibraltar Pound', 'GIP', '£', '1', '1', '0', '0', '0'), ('60', 'Greek Drachma', 'GRD', '₯, Δρχ, Δρ', '1', '1', '0', '0', '0'), ('61', 'Guatemalan Quetzal', 'GTQ', 'Q', '1', '1', '0', '0', '0'), ('62', 'Guinean Franc', 'GNF', 'FG', '1', '1', '0', '0', '0'), ('63', 'Guyanaese Dollar', 'GYD', '$', '1', '1', '0', '0', '0'), ('64', 'Haitian Gourde', 'HTG', 'G', '1', '1', '0', '0', '0'), ('65', 'Honduran Lempira', 'HNL', 'L', '1', '1', '0', '0', '0'), ('66', 'Hong Kong Dollar', 'HKD', '$', '1', '1', '0', '0', '0'), ('67', 'Hungarian Forint', 'HUF', 'Ft', '1', '1', '0', '0', '0'), ('68', 'Icelandic KrÃ³na', 'ISK', 'kr', '1', '1', '0', '0', '0'), ('69', 'Indian Rupee', 'INR', '₹', '1', '1', '1', '0', '0'), ('70', 'Indonesian Rupiah', 'IDR', 'Rp', '1', '1', '0', '0', '0'), ('71', 'Iranian Rial', 'IRR', '﷼', '1', '1', '0', '0', '0'), ('72', 'Iraqi Dinar', 'IQD', 'د.ع', '1', '1', '0', '0', '0'), ('73', 'Israeli New Sheqel', 'ILS', '₪', '1', '1', '0', '0', '0'), ('74', 'Italian Lira', 'ITL', 'L,£', '1', '1', '0', '0', '0'), ('75', 'Jamaican Dollar', 'JMD', 'J$', '1', '1', '0', '0', '0'), ('76', 'Japanese Yen', 'JPY', '¥', '1', '1', '0', '0', '0'), ('77', 'Jordanian Dinar', 'JOD', 'ا.د', '1', '1', '0', '0', '0'), ('78', 'Kazakhstani Tenge', 'KZT', 'лв', '1', '1', '0', '0', '0'), ('79', 'Kenyan Shilling', 'KES', 'KSh', '1', '1', '0', '0', '0'), ('80', 'Kuwaiti Dinar', 'KWD', 'ك.د', '1', '1', '0', '0', '0'), ('81', 'Kyrgystani Som', 'KGS', 'лв', '1', '1', '0', '0', '0'), ('82', 'Laotian Kip', 'LAK', '₭', '1', '1', '0', '0', '0'), ('83', 'Latvian Lats', 'LVL', 'Ls', '0', '0', '0', '0', '0'), ('84', 'Lebanese Pound', 'LBP', '£', '1', '1', '0', '0', '0'), ('85', 'Lesotho Loti', 'LSL', 'L', '1', '1', '0', '0', '0'), ('86', 'Liberian Dollar', 'LRD', '$', '1', '1', '0', '0', '0'), ('87', 'Libyan Dinar', 'LYD', 'د.ل', '1', '1', '0', '0', '0'), ('88', 'Lithuanian Litas', 'LTL', 'Lt', '0', '0', '0', '0', '0'), ('89', 'Macanese Pataca', 'MOP', '$', '1', '1', '0', '0', '0'), ('90', 'Macedonian Denar', 'MKD', 'ден', '1', '1', '0', '0', '0'), ('91', 'Malagasy Ariary', 'MGA', 'Ar', '1', '1', '0', '0', '0'), ('92', 'Malawian Kwacha', 'MWK', 'MK', '1', '1', '0', '0', '0'), ('93', 'Malaysian Ringgit', 'MYR', 'RM', '1', '1', '0', '0', '0'), ('94', 'Maldivian Rufiyaa', 'MVR', 'Rf', '1', '1', '0', '0', '0'), ('95', 'Mauritanian Ouguiya', 'MRO', 'MRU', '1', '1', '0', '0', '0'), ('96', 'Mauritian Rupee', 'MUR', '₨', '1', '1', '0', '0', '0'), ('97', 'Mexican Peso', 'MXN', '$', '1', '1', '0', '0', '0'), ('98', 'Moldovan Leu', 'MDL', 'L', '1', '1', '0', '0', '0'), ('99', 'Mongolian Tugrik', 'MNT', '₮', '1', '1', '0', '0', '0'), ('100', 'Moroccan Dirham', 'MAD', 'MAD', '1', '1', '0', '0', '0'), ('101', 'Mozambican Metical', 'MZM', 'MT', '1', '1', '0', '0', '0'), ('102', 'Myanmar Kyat', 'MMK', 'K', '1', '1', '0', '0', '0'), ('103', 'Namibian Dollar', 'NAD', '$', '1', '1', '0', '0', '0'), ('104', 'Nepalese Rupee', 'NPR', '₨', '1', '1', '0', '0', '0'), ('105', 'Netherlands Antillean Guilder', 'ANG', 'ƒ', '1', '1', '0', '0', '0'), ('106', 'New Taiwan Dollar', 'TWD', '$', '1', '1', '0', '0', '0'), ('107', 'New Zealand Dollar', 'NZD', '$', '1', '1', '0', '0', '0'), ('108', 'Nicaraguan CÃ³rdoba', 'NIO', 'C$', '1', '1', '0', '0', '0'), ('109', 'Nigerian Naira', 'NGN', '₦', '1', '1', '0', '0', '1'), ('110', 'North Korean Won', 'KPW', '₩', '0', '0', '0', '0', '0'), ('111', 'Norwegian Krone', 'NOK', 'kr', '1', '1', '0', '0', '0'), ('112', 'Omani Rial', 'OMR', '.ع.ر', '0', '0', '0', '0', '0'), ('113', 'Pakistani Rupee', 'PKR', '₨', '1', '1', '0', '0', '0'), ('114', 'Panamanian Balboa', 'PAB', 'B/.', '1', '1', '0', '0', '0'), ('115', 'Papua New Guinean Kina', 'PGK', 'K', '1', '1', '0', '0', '0'), ('116', 'Paraguayan Guarani', 'PYG', '₲', '1', '1', '0', '0', '0'), ('117', 'Peruvian Nuevo Sol', 'PEN', 'S/.', '1', '1', '0', '0', '0'), ('118', 'Philippine Peso', 'PHP', '₱', '1', '1', '0', '0', '0'), ('119', 'Polish Zloty', 'PLN', 'zł', '1', '1', '0', '0', '0'), ('120', 'Qatari Rial', 'QAR', 'ق.ر', '1', '1', '0', '0', '0'), ('121', 'Romanian Leu', 'RON', 'lei', '1', '1', '0', '0', '0'), ('122', 'Russian Ruble', 'RUB', '₽', '1', '1', '0', '0', '0'), ('123', 'Rwandan Franc', 'RWF', 'FRw', '1', '1', '0', '0', '0'), ('124', 'Salvadoran ColÃ³n', 'SVC', '₡', '0', '0', '0', '0', '0'), ('125', 'Samoan Tala', 'WST', 'SAT', '1', '1', '0', '0', '0'), ('126', 'Saudi Riyal', 'SAR', '﷼', '1', '1', '0', '0', '0'), ('127', 'Serbian Dinar', 'RSD', 'din', '1', '1', '0', '0', '0'), ('128', 'Seychellois Rupee', 'SCR', 'SRe', '1', '1', '0', '0', '0'), ('129', 'Sierra Leonean Leone', 'SLL', 'Le', '1', '1', '0', '0', '0'), ('130', 'Singapore Dollar', 'SGD', '$', '1', '1', '0', '0', '0'), ('131', 'Slovak Koruna', 'SKK', 'Sk', '1', '1', '0', '0', '0'), ('132', 'Solomon Islands Dollar', 'SBD', 'Si$', '1', '1', '0', '0', '0'), ('133', 'Somali Shilling', 'SOS', 'Sh.so.', '1', '1', '0', '0', '0'), ('134', 'South African Rand', 'ZAR', 'R', '1', '1', '0', '0', '0'), ('135', 'South Korean Won', 'KRW', '₩', '1', '1', '0', '0', '0'), ('136', 'Special Drawing Rights', 'XDR', 'SDR', '1', '1', '0', '0', '0'), ('137', 'Sri Lankan Rupee', 'LKR', 'Rs', '1', '1', '0', '0', '0'), ('138', 'St. Helena Pound', 'SHP', '£', '1', '1', '0', '0', '0'), ('139', 'Sudanese Pound', 'SDG', '.س.ج', '1', '1', '0', '0', '0'), ('140', 'Surinamese Dollar', 'SRD', '$', '1', '1', '0', '0', '0'), ('141', 'Swazi Lilangeni', 'SZL', 'E', '1', '1', '0', '0', '0'), ('142', 'Swedish Krona', 'SEK', 'kr', '1', '1', '0', '0', '0'), ('143', 'Swiss Franc', 'CHF', 'CHf', '1', '1', '0', '0', '0'), ('144', 'Syrian Pound', 'SYP', 'LS', '0', '0', '0', '0', '0'), ('145', 'São Tomé and Príncipe Dobra', 'STD', 'Db', '1', '1', '0', '0', '0'), ('146', 'Tajikistani Somoni', 'TJS', 'SM', '1', '1', '0', '0', '0'), ('147', 'Tanzanian Shilling', 'TZS', 'TSh', '1', '1', '0', '0', '0'), ('148', 'Thai Baht', 'THB', '฿', '1', '1', '0', '0', '0'), ('149', 'Tongan pa\'anga', 'TOP', '$', '1', '1', '0', '0', '0'), ('150', 'Trinidad & Tobago Dollar', 'TTD', '$', '1', '1', '0', '0', '0'), ('151', 'Tunisian Dinar', 'TND', 'ت.د', '1', '1', '0', '0', '0'), ('152', 'Turkish Lira', 'TRY', '₺', '1', '1', '0', '1', '0'), ('153', 'Turkmenistani Manat', 'TMT', 'T', '1', '1', '0', '0', '0'), ('154', 'Ugandan Shilling', 'UGX', 'USh', '1', '1', '0', '0', '0'), ('155', 'Ukrainian Hryvnia', 'UAH', '₴', '1', '1', '0', '0', '0'), ('156', 'United Arab Emirates Dirham', 'AED', 'إ.د', '1', '1', '0', '0', '0'), ('157', 'Uruguayan Peso', 'UYU', '$', '1', '1', '0', '0', '0'), ('158', 'Afghan Afghani', 'AFA', '؋', '1', '1', '0', '0', '0'), ('159', 'Uzbekistan Som', 'UZS', 'лв', '1', '1', '0', '0', '0'), ('160', 'Vanuatu Vatu', 'VUV', 'VT', '1', '1', '0', '0', '0'), ('161', 'Venezuelan BolÃvar', 'VEF', 'Bs', '0', '0', '0', '0', '0'), ('162', 'Vietnamese Dong', 'VND', '₫', '1', '1', '0', '0', '0'), ('163', 'Yemeni Rial', 'YER', '﷼', '1', '1', '0', '0', '0'), ('164', 'Zambian Kwacha', 'ZMK', 'ZK', '1', '1', '0', '0', '0');
DROP TABLE IF EXISTS `custom_page`;
CREATE TABLE `custom_page` (
  `custom_page_id` int NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `page_content` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `page_url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `button_title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `button_position` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`custom_page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `enrol`;
CREATE TABLE `enrol` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `course_id` int DEFAULT NULL,
  `gifted_by` int NOT NULL DEFAULT '0',
  `expiry_date` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `date_added` int DEFAULT NULL,
  `last_modified` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=436 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `enrol` (`id`, `user_id`, `course_id`, `gifted_by`, `expiry_date`, `date_added`, `last_modified`) VALUES ('425', '451', '1', '0', '1727587870', '1695160800', '1696456800'), ('429', '453', '1', '0', '1726567130', '1695420000', NULL), ('430', '451', '2', '0', '1727464113', '1695592800', '1696284000'), ('431', '451', '14', '0', NULL, '1695592800', '1696284000'), ('432', '453', '2', '0', '1726820120', '1695679200', NULL), ('433', '457', '1', '0', '1726980094', '0', NULL), ('434', '453', '14', '0', NULL, '1696370400', NULL), ('435', '458', '1', '0', '1727542540', '1696370400', NULL);
DROP TABLE IF EXISTS `frontend_settings`;
CREATE TABLE `frontend_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `value` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `frontend_settings` (`id`, `key`, `value`) VALUES ('1', 'banner_title', 'Start learning from best Platform'), ('2', 'banner_sub_title', 'Study any topic, anytime. Explore thousands of courses for the lowest price ever!'), ('4', 'about_us', '<p></p><h2><span xss=\"removed\">About us</span></h2>'), ('10', 'terms_and_condition', '<h2>Terms and Condition</h2>'), ('11', 'privacy_policy', '<p></p><p></p><h2><span xss=\"removed\">Privacy Policy</span></h2>'), ('13', 'theme', 'default-new'), ('14', 'cookie_note', 'This website uses cookies to personalize content and analyse traffic in order to offer you a better experience.'), ('15', 'cookie_status', 'active'), ('16', 'cookie_policy', '<h1>Cookie policy</h1><ol><li>Cookies are small text files that can be used by websites to make a user\'s experience more efficient.</li><li>The law states that we can store cookies on your device if they are strictly necessary for the operation of this site. For all other types of cookies we need your permission.</li><li>This site uses different types of cookies. Some cookies are placed by third party services that appear on our pages.</li></ol>'), ('17', 'banner_image', '{\"home_1\":\"home-1.png\",\"home_2\":\"home-2.png\",\"home_3\":\"home-3.png\",\"home_4\":\"home-4.png\",\"home_5\":\"home-5.png\",\"home_6\":\"home-6.png\"}'), ('18', 'light_logo', 'logo-light.png'), ('19', 'dark_logo', 'logo-dark.png'), ('20', 'small_logo', 'logo-light-sm.png'), ('21', 'favicon', 'favicon.png'), ('22', 'recaptcha_status', '0'), ('23', 'recaptcha_secretkey', 'Valid-secret-key'), ('24', 'recaptcha_sitekey', 'Valid-site-key'), ('25', 'refund_policy', '<h2><span xss=\"removed\">Refund Policy</span></h2>'), ('26', 'facebook', 'https://facebook.com'), ('27', 'twitter', 'https://twitter.com'), ('28', 'linkedin', ''), ('31', 'blog_page_title', 'Where possibilities begin'), ('32', 'blog_page_subtitle', 'We’re a leading marketplace platform for learning and teaching online. Explore some of our most popular content and learn something new.'), ('33', 'blog_page_banner', 'blog-page.png'), ('34', 'instructors_blog_permission', '0'), ('35', 'blog_visibility_on_the_home_page', '1'), ('37', 'website_faqs', '[]'), ('38', 'motivational_speech', '[]'), ('39', 'home_page', 'home_1');
DROP TABLE IF EXISTS `language`;
CREATE TABLE `language` (
  `phrase_id` int NOT NULL AUTO_INCREMENT,
  `phrase` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `english` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`phrase_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1165 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `language` (`phrase_id`, `phrase`, `english`) VALUES ('1', 'English', 'English'), ('2', '404_not_found', '404 not found'), ('3', '404_not_found', '404 not found'), ('4', 'courses', 'Courses'), ('5', 'courses', 'Courses'), ('6', 'all_courses', 'All courses'), ('7', 'all_courses', 'All courses'), ('8', 'search', 'Search'), ('9', 'you_have_no_items_in_your_cart!', 'You have no items in your cart!'), ('10', 'you_have_no_items_in_your_cart!', 'You have no items in your cart!'), ('11', 'checkout', 'Checkout'), ('12', 'checkout', 'Checkout'), ('13', 'login', 'Login'), ('14', 'login', 'Login'), ('15', 'join_now', 'Join now'), ('16', 'join_now', 'Join now'), ('17', 'sign_up', 'Sign up'), ('18', 'sign_up', 'Sign up'), ('19', 'categories', 'Categories'), ('20', 'categories', 'Categories'), ('21', 'cookie_policy', 'Cookie policy'), ('22', 'cookie_policy', 'Cookie policy'), ('23', 'accept', 'Accept'), ('24', 'accept', 'Accept'), ('25', 'home', 'Home'), ('26', 'home', 'Home'), ('27', 'the_page_you_requested_could_not_be_found', 'The page you requested could not be found'), ('28', 'check_the_spelling_of_the_url', 'Check the spelling of the url'), ('29', 'if_you_are_still_puzzled,_click_on_the_home_link_below', 'If you are still puzzled, click on the home link below'), ('30', 'back_to_home', 'Back to home'), ('31', 'top_categories', 'Top categories'), ('32', 'top_categories', 'Top categories'), ('33', 'useful_links', 'Useful links'), ('34', 'useful_links', 'Useful links'), ('35', 'blog', 'Blog'), ('36', 'blog', 'Blog'), ('37', 'help', 'Help'), ('38', 'help', 'Help'), ('39', 'contact_us', 'Contact us'), ('40', 'contact_us', 'Contact us'), ('41', 'about_us', 'About us'), ('42', 'about_us', 'About us'), ('43', 'privacy_policy', 'Privacy policy'), ('44', 'privacy_policy', 'Privacy policy'), ('45', 'terms_and_condition', 'Terms and condition'), ('46', 'terms_and_condition', 'Terms and condition'), ('47', 'faq', 'Faq'), ('48', 'faq', 'Faq'), ('49', 'refund_policy', 'Refund policy'), ('50', 'refund_policy', 'Refund policy'), ('51', 'subscribe_to_our_newsletter', 'Subscribe to our newsletter'), ('52', 'subscribe_to_our_newsletter', 'Subscribe to our newsletter'), ('53', 'enter_your_email_address', 'Enter your email address'), ('54', 'enter_your_email_address', 'Enter your email address'), ('55', 'creativeitem', 'Creativeitem'), ('56', 'creativeitem', 'Creativeitem'), ('57', 'are_you_sure', 'Are you sure'), ('58', 'are_you_sure', 'Are you sure'), ('59', 'yes', 'Yes'), ('60', 'yes', 'Yes'), ('61', 'no', 'No'), ('62', 'no', 'No'), ('63', 'log_in', 'Log in'), ('64', 'explore,_learn,_and_grow_with_us._enjoy_a_seamless_and_enriching_educational_journey._lets_begin!', 'Explore, learn, and grow with us. enjoy a seamless and enriching educational journey. lets begin!'), ('65', 'your_email', 'Your email'), ('66', 'enter_your_email', 'Enter your email'), ('67', 'password', 'Password'), ('68', 'enter_your_valid_password', 'Enter your valid password'), ('69', 'forgot_password?', 'Forgot password?'), ('70', 'don`t_have_an_account?', 'Don`t have an account?'), ('71', 'or', 'Or'), ('72', 'welcome', 'Welcome'), ('73', 'dashboard', 'Dashboard'), ('74', 'quick_actions', 'Quick actions'), ('75', 'create_course', 'Create course'), ('76', 'add_course', 'Add course'), ('77', 'add_new_lesson', 'Add new lesson'), ('78', 'add_lesson', 'Add lesson'), ('79', 'add_student', 'Add student'), ('80', 'enrol_a_student', 'Enrol a student'), ('81', 'enrol_student', 'Enrol student'), ('82', 'help_center', 'Help center'), ('83', 'read_documentation', 'Read documentation'), ('84', 'watch_video_tutorial', 'Watch video tutorial'), ('85', 'get_customer_support', 'Get customer support'), ('86', 'order_customization', 'Order customization'), ('87', 'request_a_new_feature', 'Request a new feature'), ('88', 'browse_addons', 'Browse addons'), ('89', 'remove_all', 'Remove all'), ('90', 'notification', 'Notification'), ('91', 'no_notification', 'No notification'), ('92', 'stay_tuned!', 'Stay tuned!'), ('93', 'notifications_about_your_activity_will_show_up_here.', 'Notifications about your activity will show up here.'), ('94', 'notification_settings', 'Notification settings'), ('95', 'mark_all_as_read', 'Mark all as read'), ('96', 'admin', 'Admin'), ('97', 'my_account', 'My account'), ('98', 'settings', 'Settings'), ('99', 'logout', 'Logout'), ('100', 'visit_website', 'Visit website'), ('101', 'navigation', 'Navigation'), ('102', 'manage_courses', 'Manage courses'), ('103', 'add_new_course', 'Add new course'), ('104', 'course_category', 'Course category'), ('105', 'coupons', 'Coupons'), ('106', 'enrollments', 'Enrollments'), ('107', 'course_enrollment', 'Course enrollment'), ('108', 'enrol_history', 'Enrol history'), ('109', 'report', 'Report'), ('110', 'admin_revenue', 'Admin revenue'), ('111', 'instructor_revenue', 'Instructor revenue'), ('112', 'purchase_history', 'Purchase history'), ('113', 'users', 'Users'), ('114', 'admins', 'Admins'), ('115', 'manage_admins', 'Manage admins'), ('116', 'add_new_admin', 'Add new admin'), ('117', 'instructors', 'Instructors'), ('118', 'manage_instructors', 'Manage instructors'), ('119', 'add_new_instructor', 'Add new instructor'), ('120', 'instructor_payout', 'Instructor payout'), ('121', 'instructor_settings', 'Instructor settings'), ('122', 'applications', 'Applications'), ('123', 'students', 'Students'), ('124', 'manage_students', 'Manage students'), ('125', 'add_new_student', 'Add new student'), ('126', 'message', 'Message'), ('127', 'all_blogs', 'All blogs'), ('128', 'pending_blog', 'Pending blog'), ('129', 'blog_category', 'Blog category'), ('130', 'blog_settings', 'Blog settings'), ('131', 'newsletter', 'Newsletter'), ('132', 'all_newsletter', 'All newsletter'), ('133', 'subscribed_user', 'Subscribed user'), ('134', 'addons', 'Addons'), ('135', 'themes', 'Themes'), ('136', 'system_settings', 'System settings'), ('137', 'website_settings', 'Website settings'), ('138', 'academy_cloud', 'Academy cloud'), ('139', 'drip_content_settings', 'Drip content settings'), ('140', 'payment_settings', 'Payment settings'), ('141', 'language_settings', 'Language settings'), ('142', 'social_login', 'Social login'), ('143', 'custom_page_builder', 'Custom page builder'), ('144', 'data_center', 'Data center'), ('145', 'about', 'About'), ('146', 'manage_profile', 'Manage profile'), ('147', 'admin_revenue_this_year', 'Admin revenue this year'), ('148', 'number_courses', 'Number courses'), ('149', 'number_of_lessons', 'Number of lessons'), ('150', 'number_of_enrolment', 'Number of enrolment'), ('151', 'number_of_student', 'Number of student'), ('152', 'course_overview', 'Course overview'), ('153', 'active_courses', 'Active courses'), ('154', 'pending_courses', 'Pending courses'), ('155', 'requested_withdrawal', 'Requested withdrawal'), ('156', 'january', 'January'), ('157', 'february', 'February'), ('158', 'march', 'March'), ('159', 'april', 'April'), ('160', 'may', 'May'), ('161', 'june', 'June'), ('162', 'july', 'July'), ('163', 'august', 'August'), ('164', 'september', 'September'), ('165', 'october', 'October'), ('166', 'november', 'November'), ('167', 'december', 'December'), ('168', 'this_year', 'This year'), ('169', 'active_course', 'Active course'), ('170', 'pending_course', 'Pending course'), ('171', 'heads_up', 'Heads up'), ('172', 'congratulations', 'Congratulations'), ('173', 'oh_snap', 'Oh snap'), ('174', 'please_fill_all_the_required_fields', 'Please fill all the required fields'), ('175', 'close', 'Close'), ('176', 'cancel', 'Cancel'), ('177', 'continue', 'Continue'), ('178', 'ok', 'Ok'), ('179', 'success', 'Success'), ('180', 'your_server_does_not_allow_uploading_files_that_large.', 'Your server does not allow uploading files that large.'), ('181', 'your_servers_file_upload_limit_is_512mb', 'Your servers file upload limit is 512mb'), ('182', 'successfully', 'Successfully'), ('183', 'div_added_to_bottom_', 'Div added to bottom '), ('184', 'div_has_been_deleted_', 'Div has been deleted '), ('185', 'addon_manager', 'Addon manager'), ('186', 'buy_new_addon', 'Buy new addon'), ('187', 'install_addon', 'Install addon'), ('188', 'installed_addons', 'Installed addons'), ('189', 'available_addons', 'Available addons'), ('190', 'name', 'Name'), ('191', 'version', 'Version'), ('192', 'status', 'Status'), ('193', 'actions', 'Actions'), ('194', 'add_addon', 'Add addon'), ('195', 'install_an_addon', 'Install an addon'), ('196', 'back_to_addon_list', 'Back to addon list'), ('197', 'upload_addon_file', 'Upload addon file'), ('198', 'zip_file', 'Zip file'), ('199', 'purchase_code', 'Purchase code'), ('200', 'enter_your_valid_purchase_code', 'Enter your valid purchase code'), ('201', 'back', 'Back'), ('202', 'addon_installed_successfully', 'Addon installed successfully'), ('203', 'tutor_booking', 'Tutor booking'), ('204', 'subject_category', 'Subject category'), ('205', 'add_booking', 'Add booking'), ('206', 'all_bookings', 'All bookings'), ('207', 'booked_schedules', 'Booked schedules'), ('208', 'live_class_settings', 'Live class settings'), ('209', 'active', 'Active'), ('210', 'addon_update', 'Addon update'), ('211', 'deactive', 'Deactive'), ('212', 'delete', 'Delete'), ('213', 'about_this_addon', 'About this addon'), ('214', 'certificate_settings', 'Certificate settings'), ('215', 'theme_settings', 'Theme settings'), ('216', 'buy_new_theme', 'Buy new theme'), ('217', 'upload_your_theme_file', 'Upload your theme file'), ('218', 'installed_themes', 'Installed themes'), ('219', 'add_new_themes', 'Add new themes'), ('220', 'active_theme', 'Active theme'), ('221', 'theme_successfully_activated', 'Theme successfully activated'), ('222', 'you_do_not_have_right_to_access_this_theme', 'You do not have right to access this theme'), ('223', 'add_schedule', 'Add schedule'), ('224', 'tution_topic', 'Tution topic'), ('225', 'category', 'Category'), ('226', 'select_category', 'Select category'), ('227', 'sub_category', 'Sub category'), ('228', 'class_type', 'Class type'), ('229', 'online', 'Online'), ('230', 'in_person', 'In person'), ('231', 'price_type', 'Price type'), ('232', 'fixed', 'Fixed'), ('233', 'hourly', 'Hourly'), ('234', 'price', 'Price'), ('235', 'tution_type', 'Tution type'), ('236', 'single_time', 'Single time'), ('237', 'repeated_days_', 'Repeated days '), ('238', 'select_days', 'Select days'), ('239', 'check_all_', 'Check all '), ('240', 'sunday', 'Sunday'), ('241', 'monday', 'Monday'), ('242', 'tuesday', 'Tuesday'), ('243', 'wednesday', 'Wednesday'), ('244', 'thursday', 'Thursday'), ('245', 'friday', 'Friday'), ('246', 'saturday', 'Saturday'), ('247', 'schedule_start_time', 'Schedule start time'), ('248', 'schedule_end_time', 'Schedule end time'), ('249', 'class_duration', 'Class duration'), ('250', 'duration', 'Duration'), ('251', 'select_duration', 'Select duration'), ('252', 'class_invitation_link', 'Class invitation link'), ('253', 'group', 'Group'), ('254', 'single', 'Single'), ('255', 'start_time', 'Start time'), ('256', 'end_time', 'End time'), ('257', 'one_time', 'One time'), ('258', 'everyday', 'Everyday'), ('259', 'selected_days', 'Selected days'), ('260', 'save_schedule', 'Save schedule'), ('261', 'required_field', 'Required field'), ('262', 'you_can_not_keep_any_field_empty', 'You can not keep any field empty'), ('263', 'schedule_added_successfully', 'Schedule added successfully'), ('264', 'list_of_bookings', 'List of bookings'), ('265', 'booking_lists', 'Booking lists'), ('266', 'title', 'Title'), ('267', 'added_by', 'Added by'), ('268', 'action', 'Action'), ('269', 'h2s', 'H2s'), ('270', 'no_category', 'No category'), ('271', 'no_sub_category', 'No sub category'), ('272', 'noman_khalid', 'Noman khalid'), ('273', '_schedules', ' schedules'), ('274', 'edit_schedules', 'Edit schedules'), ('275', 'edit_booking', 'Edit booking'), ('276', '_inactive_booking', ' inactive booking'), ('277', 'list_of_schedules', 'List of schedules'), ('278', 'booking_title_:_h2s', 'Booking title : h2s'), ('279', '_active_schedule_list', ' active schedule list'), ('280', 'upcoming_', 'Upcoming '), ('281', 'archive_', 'Archive '), ('282', 'date', 'Date'), ('283', 'active_till', 'Active till'), ('284', 'time_', 'Time '), ('285', 'sunday,', 'Sunday,'), ('286', 'available', 'Available'), ('287', 'start_class_', 'Start class '), ('288', 'edit_schedule', 'Edit schedule'), ('289', 'edit', 'Edit'), ('290', '_inactive', ' inactive'), ('291', 'no_data_found', 'No data found'), ('292', 'eidt_schedule', 'Eidt schedule'), ('293', 'no_category_found', 'No category found'), ('294', 'update_schedule', 'Update schedule'), ('295', 'tutor_categories', 'Tutor categories'), ('296', 'add_new_category', 'Add new category'), ('297', 'add_category', 'Add category'), ('298', 'tutor_category_add_form', 'Tutor category add form'), ('299', 'category_title', 'Category title'), ('300', 'parent', 'Parent'), ('301', 'none', 'None'), ('302', 'select_none_to_create_a_parent_category', 'Select none to create a parent category'), ('303', 'submit', 'Submit'), ('304', 'data_added_successfully', 'Data added successfully'), ('305', 'sub_categories', 'Sub categories'), ('306', 'edit_category', 'Edit category'), ('307', 'update_tutor_category', 'Update tutor category'), ('308', 'update_tutor_category_form', 'Update tutor category form'), ('309', 'upcoming_courses', 'Upcoming courses'), ('310', 'free_courses', 'Free courses'), ('311', 'paid_courses', 'Paid courses'), ('312', 'course_list', 'Course list'), ('313', 'all', 'All'), ('314', 'pending', 'Pending'), ('315', 'private', 'Private'), ('316', 'upcoming', 'Upcoming'), ('317', 'instructor', 'Instructor'), ('318', 'free', 'Free'), ('319', 'paid', 'Paid'), ('320', 'filter', 'Filter'), ('321', 'lesson_and_section', 'Lesson and section'), ('322', 'enrolled_student', 'Enrolled student'), ('323', 'data_deleted', 'Data deleted'), ('324', 'tuition_topic', 'Tuition topic'), ('325', 'course_enrolment', 'Course enrolment'), ('326', 'enrolment_form', 'Enrolment form'), ('327', 'course_to_enrol', 'Course to enrol'), ('328', 'select_a_course', 'Select a course'), ('329', 'certificate_template_text', 'Certificate template text'), ('330', 'and', 'And'), ('331', 'represents_student_name_and_course_title_on_the_certificate', 'Represents student name and course title on the certificate'), ('332', 'save', 'Save'), ('333', 'certificate_template', 'Certificate template'), ('334', 'make_sure_that_template_size_is_less_than', 'Make sure that template size is less than'), ('335', 'certificate_text_position', 'Certificate text position'), ('336', 'you_must_update_the_text_position_after_updating_the_certificate_template_text', 'You must update the text position after updating the certificate template text'), ('337', 'edit_text_position', 'Edit text position'), ('338', 'start_learning_from_best_platform', 'Start learning from best platform'), ('339', 'study_any_topic,_anytime._explore_thousands_of_courses_for_the_lowest_price_ever!', 'Study any topic, anytime. explore thousands of courses for the lowest price ever!'), ('340', 'what_do_you_want_to_learn', 'What do you want to learn'), ('341', 'happy', 'Happy'), ('342', 'experienced', 'Experienced'), ('343', 'online_courses', 'Online courses'), ('344', 'explore_a_variety_of_fresh_topics', 'Explore a variety of fresh topics'), ('345', 'expert_instruction', 'Expert instruction'), ('346', 'find_the_right_course_for_you', 'Find the right course for you'), ('347', 'smart_solution', 'Smart solution'), ('348', 'learn_on_your_schedule', 'Learn on your schedule'), ('349', 'top_courses', 'Top courses'), ('350', 'these_are_the_most_popular_courses_among_listen_courses_learners_worldwide', 'These are the most popular courses among listen courses learners worldwide'), ('351', 'top', 'Top'), ('352', 'latest_courses', 'Latest courses'), ('353', 'these_are_the_most_latest_courses_among_listen_courses_learners_worldwide', 'These are the most latest courses among listen courses learners worldwide'), ('354', 'join_now_to_start_learning', 'Join now to start learning'), ('355', 'learn_from_our_quality_instructors!', 'Learn from our quality instructors!'), ('356', 'get_started', 'Get started'), ('357', 'become_a_new_instructor', 'Become a new instructor'), ('358', 'teach_thousands_of_students_and_earn_money!', 'Teach thousands of students and earn money!'), ('359', 'no_search_value_found', 'No search value found'), ('360', 'first_name', 'First name'), ('361', 'enter_your_first_name', 'Enter your first name'), ('362', 'last_name', 'Last name'), ('363', 'enter_your_last_name', 'Enter your last name'), ('364', 'apply_to_become_a_instructor', 'Apply to become a instructor'), ('365', 'phone', 'Phone'), ('366', 'enter_your_phone_number', 'Enter your phone number'), ('367', 'document', 'Document'), ('368', 'provide_some_documents_about_your_qualifications', 'Provide some documents about your qualifications'), ('369', 'already_you_have_an_account?', 'Already you have an account?'), ('370', 'private_messaging', 'Private messaging'), ('371', 'private_message', 'Private message'), ('372', 'new_message', 'New message'), ('373', 'choose_an_option_from_the_left_side', 'Choose an option from the left side'), ('374', 'certificates_text_position', 'Certificates text position'), ('375', 'update', 'Update'), ('376', 'attention', 'Attention'), ('377', 'you_can_change_the_text_positions_by_drag_and_drop', 'You can change the text positions by drag and drop'), ('378', 'drag_out_of_the_certificate_layout_to_keep_an_object_hidden', 'Drag out of the certificate layout to keep an object hidden'), ('379', 'after_changing_your_text_positions,_click_the_save_button_to_save_the_parts', 'After changing your text positions, click the save button to save the parts'), ('380', 'please_wait', 'Please wait'), ('381', 'custom_pages', 'Custom pages'), ('382', 'add_a_new_page', 'Add a new page'), ('383', 'page_title', 'Page title'), ('384', 'button_title', 'Button title'), ('385', 'button_position', 'Button position'), ('386', 'add_custom_page', 'Add custom page'), ('387', 'add_your_new_page', 'Add your new page'), ('388', 'page_information', 'Page information'), ('389', 'enter_page_title', 'Enter page title'), ('390', 'page_content', 'Page content'), ('391', 'footer', 'Footer'), ('392', 'header', 'Header'), ('393', 'page_url', 'Page url'), ('394', 'add_page', 'Add page'), ('395', 'invalid_login_credentials', 'Invalid login credentials'), ('396', 'administration', 'Administration'), ('397', 'log_out', 'Log out'), ('398', 'all_category', 'All category'), ('399', 'show_more', 'Show more'), ('400', 'show_less', 'Show less'), ('401', 'level', 'Level'), ('402', 'beginner', 'Beginner'), ('403', 'intermediate', 'Intermediate'), ('404', 'advanced', 'Advanced'), ('405', 'language', 'Language'), ('406', 'ratings', 'Ratings'), ('407', 'list_view', 'List view'), ('408', 'grid_view', 'Grid view'), ('409', 'reset', 'Reset'), ('410', 'showing', 'Showing'), ('411', 'of', 'Of'), ('412', 'results', 'Results'), ('413', 'newly_published', 'Newly published'), ('414', 'highest_rating', 'Highest rating'), ('415', 'lowest_price', 'Lowest price'), ('416', 'highest_price', 'Highest price'), ('417', 'discounted', 'Discounted'), ('418', 'basic_info', 'Basic info'), ('419', 'email', 'Email'), ('420', 'facebook_link', 'Facebook link'), ('421', 'twitter_link', 'Twitter link'), ('422', 'linkedin_link', 'Linkedin link'), ('423', 'a_short_title_about_yourself', 'A short title about yourself'), ('424', 'skills', 'Skills'), ('425', 'write_your_skill_and_click_the_enter_button', 'Write your skill and click the enter button'), ('426', 'biography', 'Biography'), ('427', 'photo', 'Photo'), ('428', 'the_image_size_should_be_any_square_image', 'The image size should be any square image'), ('429', 'choose_file', 'Choose file'), ('430', 'update_profile', 'Update profile'), ('431', 'current_password', 'Current password'), ('432', 'new_password', 'New password'), ('433', 'confirm_new_password', 'Confirm new password'), ('434', 'update_password', 'Update password'), ('435', 'website_name', 'Website name'), ('436', 'website_title', 'Website title'), ('437', 'website_keywords', 'Website keywords'), ('438', 'website_description', 'Website description'), ('439', 'author', 'Author'), ('440', 'slogan', 'Slogan'), ('441', 'system_email', 'System email'), ('442', 'address', 'Address'), ('443', 'youtube_api_key', 'Youtube api key'), ('444', 'get_youtube_api_key', 'Get youtube api key'), ('445', 'if_you_want_to_use_google_drive_video,_you_need_to_enable_the_google_drive_service_in_this_api', 'If you want to use google drive video, you need to enable the google drive service in this api'), ('446', 'vimeo_api_key', 'Vimeo api key'), ('447', 'get_vimeo_api_key', 'Get vimeo api key'), ('448', 'system_language', 'System language'), ('449', 'student_email_verification', 'Student email verification'), ('450', 'enable', 'Enable'), ('451', 'disable', 'Disable'), ('452', 'course_accessibility', 'Course accessibility'), ('453', 'publicly', 'Publicly'), ('454', 'only_logged_in_users', 'Only logged in users'), ('455', 'number_of_authorized_devices', 'Number of authorized devices'), ('456', 'how_many_devices_do_you_want_to_allow_for_logging_in_using_a_single_account', 'How many devices do you want to allow for logging in using a single account'), ('457', 'course_selling_tax', 'Course selling tax'), ('458', 'enter_0_if_you_want_to_disable_the_tax_option', 'Enter 0 if you want to disable the tax option'), ('459', 'google_analytics_id', 'Google analytics id'), ('460', 'keep_it_blank_if_you_want_to_disable_it', 'Keep it blank if you want to disable it'), ('461', 'meta_pixel_id', 'Meta pixel id'), ('462', 'footer_text', 'Footer text'), ('463', 'footer_link', 'Footer link'), ('464', 'update_product', 'Update product'), ('465', 'file', 'File'), ('466', 'frontend_settings', 'Frontend settings'), ('467', 'home_page_layout', 'Home page layout'), ('468', 'motivational_speech', 'Motivational speech'), ('469', 'website_faqs', 'Website faqs'), ('470', 'recaptcha', 'Recaptcha'), ('471', 'logo_&_images', 'Logo & images'), ('472', 'frontend_website_settings', 'Frontend website settings'), ('473', 'banner_title', 'Banner title'), ('474', 'banner_sub_title', 'Banner sub title'), ('475', 'cookie_status', 'Cookie status'), ('476', 'inactive', 'Inactive'), ('477', 'cookie_note', 'Cookie note'), ('478', 'facebook', 'Facebook'), ('479', 'twitter', 'Twitter'), ('480', 'linkedin', 'Linkedin'), ('481', 'update_settings', 'Update settings'), ('482', 'activated', 'Activated'), ('483', 'description', 'Description'), ('484', 'image', 'Image'), ('485', 'upload_image', 'Upload image'), ('486', 'faq_question', 'Faq question'), ('487', 'save_changes', 'Save changes'), ('488', 'question', 'Question'), ('489', 'answer', 'Answer'), ('490', 'recaptcha_settings', 'Recaptcha settings'), ('491', 'recaptcha_status', 'Recaptcha status'), ('492', 'recaptcha_sitekey', 'Recaptcha sitekey'), ('493', 'recaptcha_secretkey', 'Recaptcha secretkey'), ('494', 'update_recaptcha_settings', 'Update recaptcha settings'), ('495', 'update_banner_image', 'Update banner image'), ('496', 'upload_banner_image', 'Upload banner image'), ('497', 'update_light_logo', 'Update light logo'), ('498', 'upload_light_logo', 'Upload light logo'), ('499', 'update_dark_logo', 'Update dark logo'), ('500', 'upload_dark_logo', 'Upload dark logo'), ('501', 'update_small_logo', 'Update small logo'), ('502', 'upload_small_logo', 'Upload small logo'), ('503', 'update_favicon', 'Update favicon'), ('504', 'upload_favicon', 'Upload favicon'), ('505', 'import_your_data', 'Import your data'), ('506', 'choose_your_demo_file', 'Choose your demo file'), ('507', 'import', 'Import'), ('508', 'backup_your_website', 'Backup your website'), ('509', 'backup_your_current_data', 'Backup your current data'), ('510', 'keep_a_backup', 'Keep a backup'), ('511', 'no_backup', 'No backup'), ('512', 'student', 'Student'), ('513', 'enrolled_courses', 'Enrolled courses'), ('514', 'student_add', 'Student add'), ('515', 'student_add_form', 'Student add form'), ('516', 'login_credentials', 'Login credentials'), ('517', 'social_information', 'Social information'), ('518', 'payment_info', 'Payment info'), ('519', 'finish', 'Finish'), ('520', 'user_image', 'User image'), ('521', 'choose_user_image', 'Choose user image'), ('522', 'paypal', 'Paypal'), ('523', 'sandbox_client_id', 'Sandbox client id'), ('524', 'required_for_instructor', 'Required for instructor'), ('525', 'sandbox_secret_key', 'Sandbox secret key'), ('526', 'production_client_id', 'Production client id'), ('527', 'production_secret_key', 'Production secret key'), ('528', 'stripe', 'Stripe'), ('529', 'public_key', 'Public key'), ('530', 'secret_key', 'Secret key'), ('531', 'public_live_key', 'Public live key'), ('532', 'secret_live_key', 'Secret live key'), ('533', 'razorpay', 'Razorpay'), ('534', 'key_id', 'Key id'), ('535', 'theme_color', 'Theme color'), ('536', 'thank_you', 'Thank you'), ('537', 'you_are_just_one_click_away', 'You are just one click away'), ('538', 'course_adding_form', 'Course adding form'), ('539', 'back_to_course_list', 'Back to course list'), ('540', 'basic', 'Basic'), ('541', 'info', 'Info'), ('542', 'pricing', 'Pricing'), ('543', 'media', 'Media'), ('544', 'seo', 'Seo'), ('545', 'course_title', 'Course title'), ('546', 'enter_course_title', 'Enter course title'), ('547', 'short_description', 'Short description'), ('548', 'select_a_category', 'Select a category'), ('549', 'select_sub_category', 'Select sub category'), ('550', 'language_made_in', 'Language made in'), ('551', 'enable_drip_content', 'Enable drip content'), ('552', 'create_as_a', 'Create as a'), ('553', 'private_course', 'Private course'), ('554', 'upcoming_course', 'Upcoming course'), ('555', 'check_if_this_course_is_top_course', 'Check if this course is top course'), ('556', 'course_faq', 'Course faq'), ('557', 'requirements', 'Requirements'), ('558', 'provide_requirements', 'Provide requirements'), ('559', 'outcomes', 'Outcomes'), ('560', 'provide_outcomes', 'Provide outcomes'), ('561', 'check_if_this_is_a_free_course', 'Check if this is a free course'), ('562', 'course_price', 'Course price'), ('563', 'enter_course_course_price', 'Enter course course price'), ('564', 'check_if_this_course_has_discount', 'Check if this course has discount'), ('565', 'discounted_price', 'Discounted price'), ('566', 'this_course_has', 'This course has'), ('567', 'discount', 'Discount'), ('568', 'expiry_period', 'Expiry period'), ('569', 'lifetime', 'Lifetime'), ('570', 'limited_time', 'Limited time'), ('571', 'number_of_month', 'Number of month'), ('572', 'after_purchase,_students_can_access_the_course_until_your_selected_time.', 'After purchase, students can access the course until your selected time.'), ('573', 'course_overview_provider', 'Course overview provider'), ('574', 'youtube', 'Youtube'), ('575', 'vimeo', 'Vimeo'), ('576', 'html5', 'Html5'), ('577', 'course_overview_url', 'Course overview url'), ('578', 'course_thumbnail', 'Course thumbnail'), ('579', 'meta_keywords', 'Meta keywords'), ('580', 'write_a_keyword_and_then_press_enter_button', 'Write a keyword and then press enter button'), ('581', 'meta_description', 'Meta description'), ('582', 'category_add_form', 'Category add form'), ('583', 'category_code', 'Category code'), ('584', 'icon_picker', 'Icon picker'), ('585', 'category_thumbnail', 'Category thumbnail'), ('586', 'the_image_size_should_be', 'The image size should be'), ('587', 'choose_thumbnail', 'Choose thumbnail'), ('588', 'course_has_been_added_successfully', 'Course has been added successfully'), ('589', 'edit_course', 'Edit course'), ('590', 'course_manager', 'Course manager'), ('591', 'view_on_frontend', 'View on frontend'), ('592', 'curriculum', 'Curriculum'), ('593', 'academic_progress', 'Academic progress'), ('594', 'add_new_section', 'Add new section'), ('595', 'add_section', 'Add section'), ('596', 'course_type', 'Course type'), ('597', 'general', 'General'), ('598', 'the_course_type_can_not_be_editable', 'The course type can not be editable'), ('599', 'instructor_of_this_course', 'Instructor of this course'), ('600', 'updated_as_a', 'Updated as a'), ('601', 'months', 'Months'), ('602', 'mark_as_pending', 'Mark as pending'), ('603', 'section_and_lesson', 'Section and lesson'), ('604', 'edit_this_course', 'Edit this course'), ('605', 'view_course_on_frontend', 'View course on frontend'), ('606', 'go_to_course_playing_page', 'Go to course playing page'), ('607', 'section', 'Section'), ('608', 'lesson', 'Lesson'), ('609', 'provide_a_section_name', 'Provide a section name'), ('610', 'section_has_been_added_successfully', 'Section has been added successfully'), ('611', 'add_new_quiz', 'Add new quiz'), ('612', 'add_quiz', 'Add quiz'), ('613', 'sort_sections', 'Sort sections'), ('614', 'sort_lessons', 'Sort lessons'), ('615', 'sort_lesson', 'Sort lesson'), ('616', 'update_section', 'Update section'), ('617', 'edit_section', 'Edit section'), ('618', 'delete_section', 'Delete section'), ('619', 'select_lesson_type', 'Select lesson type'), ('620', 'video', 'Video'), ('621', 'secured', 'Secured'), ('622', 'video_file', 'Video file'), ('623', 'video_url', 'Video url'), ('624', 'google_drive_video', 'Google drive video'), ('625', 'document_file', 'Document file'), ('626', 'text', 'Text'), ('627', 'image_file', 'Image file'), ('628', 'iframe_embed', 'Iframe embed'), ('629', 'next', 'Next'), ('630', 'please_select_a_course', 'Please select a course'), ('631', 'lesson_type', 'Lesson type'), ('632', 'change', 'Change'), ('633', 'enter_your_text', 'Enter your text'), ('634', 'summary', 'Summary'), ('635', 'do_you_want_to_keep_it_free_as_a_preview_lesson', 'Do you want to keep it free as a preview lesson'), ('636', 'mark_as_free_lesson', 'Mark as free lesson'), ('637', 'uploading', 'Uploading'), ('638', 'lesson_has_been_added_successfully', 'Lesson has been added successfully'), ('639', 'update_lesson', 'Update lesson'), ('640', 'quiz_title', 'Quiz title'), ('641', 'quiz_duration', 'Quiz duration'), ('642', 'if_you_want_to_disable_the_timer,_set_the_duration_to', 'If you want to disable the timer, set the duration to'), ('643', 'total_marks', 'Total marks'), ('644', 'number_of_quiz_retakes', 'Number of quiz retakes'), ('645', 'enter_0_if_you_want_to_disable_multiple_attempts', 'Enter 0 if you want to disable multiple attempts'), ('646', 'instruction', 'Instruction'), ('647', 'quiz_has_been_added_successfully', 'Quiz has been added successfully'), ('648', 'quiz_results', 'Quiz results'), ('649', 'manage_quiz_questions', 'Manage quiz questions'), ('650', 'quiz_questions', 'Quiz questions'), ('651', 'update_quiz_information', 'Update quiz information'), ('652', 'quiz', 'Quiz'), ('653', 'questions_of', 'Questions of'), ('654', 'update_sorting', 'Update sorting'), ('655', 'add_new_question', 'Add new question'), ('656', 'questions_have_been_sorted', 'Questions have been sorted'), ('657', 'write_your_question', 'Write your question'), ('658', 'question_type', 'Question type'), ('659', 'select_question_type', 'Select question type'), ('660', 'multiple_choice', 'Multiple choice'), ('661', 'single_choice', 'Single choice'), ('662', 'plain_text', 'Plain text'), ('663', 'fill_in_the_blank', 'Fill in the blank'), ('664', 'submit_quiz_question', 'Submit quiz question'), ('665', 'question_has_been_added', 'Question has been added'), ('666', 'enter_which_word_of_your_question_you_want_to_show_blank', 'Enter which word of your question you want to show blank'), ('667', 'press_the_enter_key_after_writing_your_every_word', 'Press the enter key after writing your every word'), ('668', 'number_of_options', 'Number of options'), ('669', 'option', 'Option'), ('670', 'option_', 'Option '), ('671', 'correct_answer_can_not_be_empty', 'Correct answer can not be empty'), ('672', 'update_quiz_question', 'Update quiz question'), ('673', 'progress', 'Progress'), ('674', 'hours', 'Hours'), ('675', 'compare', 'Compare'), ('676', 'reviews', 'Reviews'), ('677', 'lessons', 'Lessons'), ('678', 'course', 'Course'), ('679', 'created_by', 'Created by'), ('680', 'enrolled', 'Enrolled'), ('681', 'last_updated', 'Last updated'), ('682', 'overview', 'Overview'), ('683', 'course_description', 'Course description'), ('684', 'what_will_i_learn?', 'What will i learn?'), ('685', 'frequently_asked_question', 'Frequently asked question'), ('686', 'instructor_profile', 'Instructor profile'), ('687', 'hydrogen_sulfide_(h2s)_+_scba', 'Hydrogen sulfide (h2s) + scba'), ('688', 'compare_this_course', 'Compare this course'), ('689', 'lectures', 'Lectures'), ('690', 'quizzes', 'Quizzes'), ('691', 'skill_level', 'Skill level'), ('692', 'certificate', 'Certificate'), ('693', 'remove_from_cart', 'Remove from cart'), ('694', 'add_to_cart', 'Add to cart'), ('695', 'buy_now', 'Buy now'), ('696', 'related_courses', 'Related courses'), ('697', 'course_updated_successfully', 'Course updated successfully'), ('698', 'enroll_now', 'Enroll now'), ('699', 'your_registration_has_been_successfully_done', 'Your registration has been successfully done'), ('700', 'my_course', 'My course'), ('701', 'you_have_no_items_in_your_wishlist!', 'You have no items in your wishlist!'), ('702', 'go_to_wishlist', 'Go to wishlist'), ('703', 'year', 'Year'), ('704', 'month', 'Month'), ('705', 'day', 'Day'), ('706', 'hour', 'Hour'), ('707', 'minute', 'Minute'), ('708', 'second', 'Second'), ('709', 'ago', 'Ago'), ('710', 'become_a_instructor', 'Become a instructor'), ('711', 'my_courses', 'My courses'), ('712', 'my_wishlist', 'My wishlist'), ('713', 'my_messages', 'My messages'), ('714', 'user_profile', 'User profile'), ('715', 'successfully_enrolled', 'Successfully enrolled'), ('716', 'write_a_review', 'Write a review'), ('717', '1_start_rating', '1 start rating'), ('718', '2_start_rating', '2 start rating'), ('719', '3_start_rating', '3 start rating'), ('720', '4_start_rating', '4 start rating'), ('721', '5_start_rating', '5 start rating'), ('722', 'write_your_comment', 'Write your comment'), ('723', 'start_now', 'Start now'), ('724', 'course_content', 'Course content'), ('725', 'mark_as_complete', 'Mark as complete'), ('726', 'notice', 'Notice'), ('727', 'you_have_completed', 'You have completed'), ('728', 'of_the_course', 'Of the course'), ('729', 'you_can_download_the_course_completion_certificate_after_completing_the_course', 'You can download the course completion certificate after completing the course'), ('730', 'total_questions', 'Total questions'), ('731', 'quiz_time', 'Quiz time'), ('732', 'start_quiz', 'Start quiz'), ('733', 'quiz_submission_successfully', 'Quiz submission successfully'), ('734', 'completed', 'Completed'), ('735', 'uncheck', 'Uncheck'), ('736', 'obtained_marks', 'Obtained marks'), ('737', 'wrong', 'Wrong'), ('738', 'correct_answer', 'Correct answer'), ('739', 'take_the_quiz_again', 'Take the quiz again'), ('740', 'correct', 'Correct'), ('741', 'lesson_has_been_updated_successfully', 'Lesson has been updated successfully'), ('742', 'not_completed_yet', 'Not completed yet'), ('743', 'enrolled_from', 'Enrolled from'), ('744', 'last_seen_on', 'Last seen on'), ('745', 'completed_on', 'Completed on'), ('746', 'completed_lesson', 'Completed lesson'), ('747', 'out_of', 'Out of'), ('748', 'watched_duration', 'Watched duration'), ('749', 'total_attempts', 'Total attempts'), ('750', 'obtained_marks_of_all_attempts', 'Obtained marks of all attempts'), ('751', 'go_to_answer_sheet', 'Go to answer sheet'), ('752', 'the_course_is_not_over_yet', 'The course is not over yet'), ('753', 'total_participant_students', 'Total participant students'), ('754', 'participant_students', 'Participant students'), ('755', 'select_student', 'Select student'), ('756', 'select_a_student_to_view_the_answer_sheet', 'Select a student to view the answer sheet'), ('757', 'lesson_has_been_deleted_successfully', 'Lesson has been deleted successfully'), ('758', 'this_video_will_be_shown_on_web_application', 'This video will be shown on web application'), ('759', 'analyzing_the_url', 'Analyzing the url'), ('760', 'invalid_url', 'Invalid url'), ('761', 'your_video_source_has_to_be_either_youtube_or_vimeo', 'Your video source has to be either youtube or vimeo'), ('762', 'lesson_provider', 'Lesson provider'), ('763', 'for_mobile_application', 'For mobile application'), ('764', 'only', 'Only'), ('765', 'type_video_is_acceptable_for_mobile_application', 'Type video is acceptable for mobile application'), ('766', 'top_instructors', 'Top instructors'), ('767', 'they_efficiently_serve_large_number_of_students_on_our_platform', 'They efficiently serve large number of students on our platform'), ('768', 'tution_schedules', 'Tution schedules'), ('769', 'wishlist', 'Wishlist'), ('770', 'messages', 'Messages'), ('771', 'profile', 'Profile'), ('772', 'account_credentials', 'Account credentials'), ('773', 'go_to_course_page', 'Go to course page'), ('774', 'author_profile', 'Author profile'), ('775', 'expiration_on', 'Expiration on'), ('776', 'sort_lessons_of', 'Sort lessons of'), ('777', 'lessons_have_been_sorted', 'Lessons have been sorted'), ('778', 'for_web_application', 'For web application'), ('779', 'well_done', 'Well done'), ('780', 'you_are_now_eligible_to_download_the_course_completion_certificate', 'You are now eligible to download the course completion certificate'), ('781', 'get_certificate', 'Get certificate'), ('782', 'total_duration', 'Total duration'), ('783', 'total_lesson', 'Total lesson'), ('784', 'download', 'Download'), ('785', 'archive', 'Archive'), ('786', 'payment', 'Payment'), ('787', 'profile_photo', 'Profile photo'), ('788', 'update_your_profile_photo_and_personal_details', 'Update your profile photo and personal details'), ('789', 'upload_photo', 'Upload photo'), ('790', 'profile_info', 'Profile info'), ('791', 'add_your_twitter_link', 'Add your twitter link'), ('792', 'add_your_facebook_link', 'Add your facebook link'), ('793', 'add_your_linkedin_link', 'Add your linkedin link'), ('794', 'course_content_not_found', 'Course content not found'), ('795', 'please_ensure_that_your_course_has_at_least_one_section_and_one_lesson.', 'Please ensure that your course has at least one section and one lesson.'), ('796', 'booked_schedule', 'Booked schedule'), ('797', 'tutor', 'Tutor'), ('798', 'booked_by', 'Booked by'), ('799', 'please_choice_your_document_file', 'Please choice your document file'), ('800', 'become_an_instructor', 'Become an instructor'), ('801', 'your_application', 'Your application'), ('802', 'details', 'Details'), ('803', 'applicant_details', 'Applicant details'), ('804', 'application_details', 'Application details'), ('805', 'instructor_application', 'Instructor application'), ('806', 'instructor_applications', 'Instructor applications'), ('807', 'list_of_applications', 'List of applications'), ('808', 'pending_applications', 'Pending applications'), ('809', 'approved_applications', 'Approved applications'), ('810', 'approve', 'Approve'), ('811', 'application_approved_successfully', 'Application approved successfully'), ('812', 'approved', 'Approved'), ('813', 'instructor_dashboard', 'Instructor dashboard'), ('814', 'student_bookings', 'Student bookings'), ('815', 'sales_report', 'Sales report'), ('816', 'payout_report', 'Payout report'), ('817', 'payout_settings', 'Payout settings'), ('818', 'number_of_courses', 'Number of courses'), ('819', 'pending_balance', 'Pending balance'), ('820', 'requested_withdrawal_amount', 'Requested withdrawal amount'), ('821', 'first_aid-cpr-aed', 'First aid-cpr-aed'), ('822', 'safety_courses', 'Safety courses'), ('823', 'height_safety', 'Height safety'), ('824', 'john_wick', 'John wick'), ('825', 'draft_courses', 'Draft courses'), ('826', 'draft', 'Draft'), ('827', 'booking_title_:_first_aid-cpr-aed', 'Booking title : first aid-cpr-aed'), ('828', 'wednesday,', 'Wednesday,'), ('829', 'thursday,', 'Thursday,'), ('830', 'short_title_about_yourself', 'Short title about yourself'), ('831', 'your_skills', 'Your skills'), ('832', 'add_instructor', 'Add instructor'), ('833', 'view_courses', 'View courses'), ('834', 'public_instructor_settings', 'Public instructor settings'), ('835', 'allow_public_instructor', 'Allow public instructor'), ('836', 'instructor_application_note', 'Instructor application note'), ('837', 'instructor_commission_settings', 'Instructor commission settings'), ('838', 'instructor_revenue_percentage', 'Instructor revenue percentage'), ('839', 'admin_revenue_percentage', 'Admin revenue percentage'), ('840', 'course_added_successfully', 'Course added successfully'), ('841', 'please_wait_untill_admin_approves_it', 'Please wait untill admin approves it'), ('842', 'mark_as_drafted', 'Mark as drafted'), ('843', 'total_section', 'Total section'), ('844', 'total_enrolment', 'Total enrolment'), ('845', 'mark_as_active', 'Mark as active'), ('846', 'mail_subject', 'Mail subject'), ('847', 'mail_body', 'Mail body'), ('848', 'send_mail', 'Send mail'), ('849', 'course_status_updated', 'Course status updated'), ('850', 'list_of_tuitions', 'List of tuitions'), ('851', 'filters', 'Filters'), ('852', 'tuition_type', 'Tuition type'), ('853', 'in_perosn', 'In perosn'), ('854', 'main_category', 'Main category'), ('855', 'price_range', 'Price range'), ('856', 'tutors', 'Tutors'), ('857', 'khalid', 'Khalid'), ('858', 'wick', 'Wick'), ('859', 'tution_availability', 'Tution availability'), ('860', 'selected_days_', 'Selected days '), ('861', '0', '0'), ('862', 'available_schedules', 'Available schedules'), ('863', '6', '6'), ('864', '', ''), ('865', '16', '16'), ('866', 'tutore_details', 'Tutore details'), ('867', 'john', 'John'), ('868', 'schedule', 'Schedule'), ('869', 'review', 'Review'), ('870', 'availability', 'Availability'), ('871', 'view_all_availability', 'View all availability'), ('872', 'hours_taught', 'Hours taught'), ('873', 'total_students', 'Total students'), ('874', 'all_review', 'All review'), ('875', 'subject', 'Subject'), ('876', 'date_&_time', 'Date & time'), ('877', 'request_lesson', 'Request lesson'), ('878', 'edit_review', 'Edit review'), ('879', 'schedule_booking', 'Schedule booking'), ('880', 'pay_for_schedule_booking', 'Pay for schedule booking'), ('881', 'make_payment', 'Make payment'), ('882', 'select_payment_gateway', 'Select payment gateway'), ('883', 'by', 'By'), ('884', 'total', 'Total'), ('885', 'pay_with_stripe', 'Pay with stripe'), ('886', 'pay_by_razorpay', 'Pay by razorpay'), ('887', 'payment_successfully_done', 'Payment successfully done'), ('888', 'join_class', 'Join class'), ('889', 'tuition_date', 'Tuition date'), ('890', 'fee', 'Fee'), ('891', 'paid_by', 'Paid by'), ('892', 'payment_date', 'Payment date'), ('893', '20_aug,_23', '20 aug, 23'), ('894', 'afternoon_session', 'Afternoon session'), ('895', 'booking_title_:_afternoon_session', 'Booking title : afternoon session'), ('896', 'monday,', 'Monday,'), ('897', 'tuesday,', 'Tuesday,'), ('898', 'booked', 'Booked'), ('899', 'instructor_edit', 'Instructor edit'), ('900', 'instructor_edit_form', 'Instructor edit form'), ('901', 'short_title', 'Short title'), ('902', 'student_edit', 'Student edit'), ('903', 'student_edit_form', 'Student edit form'), ('904', 'applicant', 'Applicant'), ('905', 'phone_number', 'Phone number'), ('906', 'manage_your_drip_content_settings', 'Manage your drip content settings'), ('907', 'lesson_completion_role', 'Lesson completion role'), ('908', 'video_percentage_wise', 'Video percentage wise'), ('909', 'video_duration_wise', 'Video duration wise'), ('910', 'minimum_duration_to_watch', 'Minimum duration to watch'), ('911', 'minimum_percentage_to_watch', 'Minimum percentage to watch'), ('912', 'message_for_locked_lesson', 'Message for locked lesson'), ('913', 'the_auto_checkmark_is_only_applicable_for_video_lessons', 'The auto checkmark is only applicable for video lessons'), ('914', 'learn_more', 'Learn more'), ('915', 'video_url_is_not_supported', 'Video url is not supported'), ('916', 'this_lecture_is_available_exclusively_as_of_premium_part._to_gain_access,_please_purchase_the_course', 'This lecture is available exclusively as of premium part. to gain access, please purchase the course'), ('917', 'not_started_yet', 'Not started yet'), ('918', 'course_name', 'Course name'), ('919', 'request_a_new_withdrawal', 'Request a new withdrawal'), ('920', 'pending_amount', 'Pending amount'), ('921', 'total_payout_amount', 'Total payout amount'), ('922', 'payout_amount', 'Payout amount'), ('923', 'payment_type', 'Payment type'), ('924', 'date_processed', 'Date processed'), ('925', 'setup_payment_informations', 'Setup payment informations'), ('926', 'setup_your_payment_settings', 'Setup your payment settings'), ('927', 'be_careful', 'Be careful'), ('928', 'select_a_user', 'Select a user'), ('929', 'write_your_message', 'Write your message'), ('930', 'send', 'Send'), ('931', 'enrol_histories', 'Enrol histories'), ('932', 'user_name', 'User name'), ('933', 'enrolled_course', 'Enrolled course'), ('934', 'enrollment_date', 'Enrollment date'), ('935', 'expiry_date', 'Expiry date'), ('936', 'user_update_successfully', 'User update successfully'), ('937', 'purchased_courses', 'Purchased courses'), ('938', 'payment_method', 'Payment method'), ('939', 'purchased_date', 'Purchased date'), ('940', 'invoice', 'Invoice'), ('941', 'credentials', 'Credentials'), ('942', 'account_information', 'Account information'), ('943', 'enter_current_password', 'Enter current password'), ('944', 'enter_new_password', 'Enter new password'), ('945', 'confirm_password', 'Confirm password'), ('946', 're-type_your_password', 'Re-type your password'), ('947', 'disable_successfully', 'Disable successfully'), ('948', 'inactived_booking_lists', 'Inactived booking lists'), ('949', 'h2s_arabic', 'H2s arabic'), ('950', 'booking_title_:_h2s_arabic', 'Booking title : h2s arabic'), ('951', 'n', 'N'), ('952', 'a', 'A'), ('953', 'lifetime_access', 'Lifetime access'), ('954', 'certificate_template_has_been_updated', 'Certificate template has been updated'), ('955', 'not_found', 'Not found'), ('956', 'about_this_application', 'About this application'), ('957', 'software_version', 'Software version'), ('958', 'check_update', 'Check update'), ('959', 'php_version', 'Php version'), ('960', 'curl_enable', 'Curl enable'), ('961', 'enabled', 'Enabled'), ('962', 'product_license', 'Product license'), ('963', 'valid', 'Valid'), ('964', 'customer_support_status', 'Customer support status'), ('965', 'support_expiry_date', 'Support expiry date'), ('966', 'customer_name', 'Customer name'), ('967', 'customer_support', 'Customer support'), ('968', 'you_have_to_buy_the_course_first', 'You have to buy the course first'), ('969', '5', '5'), ('970', '46', '46'), ('971', '1', '1'), ('972', 'noman_', 'Noman '), ('973', 'updated_successfully', 'Updated successfully'), ('974', '21_aug,_23', '21 aug, 23'), ('975', 'john_doe', 'John doe'), ('976', 'user_added_successfully', 'User added successfully'), ('977', 'student_has_been_enrolled', 'Student has been enrolled'), ('978', 'time_over', 'Time over'), ('979', 'list_of_sections', 'List of sections'), ('980', 'sections_have_been_sorted', 'Sections have been sorted'), ('981', 'invalid_lesson_url_and_duration', 'Invalid lesson url and duration'), ('982', 'play_now', 'Play now'), ('983', 'complete_previous_lesson_to_unlock_it', 'Complete previous lesson to unlock it'), ('984', 'document_type', 'Document type'), ('985', 'select_type_of_document', 'Select type of document'), ('986', 'text_file', 'Text file'), ('987', 'pdf_file', 'Pdf file'), ('988', 'attachment', 'Attachment'), ('989', 'pdf', 'Pdf'), ('990', 'previous', 'Previous'), ('991', 'course_compare', 'Course compare'), ('992', 'compare_with_1_courses', 'Compare with 1 courses'), ('993', 'has_discount', 'Has discount'), ('994', 'made_in', 'Made in'), ('995', 'last_updated_at', 'Last updated at'), ('996', 'total_lectures', 'Total lectures'), ('997', 'total_quizzes', 'Total quizzes'), ('998', 'number_of_reviews', 'Number of reviews'), ('999', 'avg_rating', 'Avg rating'), ('1000', 'creator', 'Creator'), ('1001', 'compare_with_3_courses', 'Compare with 3 courses'), ('1002', 'add_admin', 'Add admin'), ('1003', 'root_admin', 'Root admin'), ('1004', 'instructor_payouts', 'Instructor payouts'), ('1005', 'list_of_payouts', 'List of payouts'), ('1006', 'completed_payouts', 'Completed payouts'), ('1007', 'pending_payouts', 'Pending payouts'), ('1008', 'payout_date', 'Payout date'), ('1009', 'generate_certificate', 'Generate certificate'), ('1010', 'join', 'Join'), ('1011', 'my_certificates', 'My certificates'), ('1012', 'certificates', 'Certificates'), ('1013', 'educator_profile', 'Educator profile'), ('1014', 'statistics', 'Statistics'), ('1015', 'view_certificate', 'View certificate'), ('1016', 'open_certificate', 'Open certificate'), ('1017', 'expired', 'Expired'), ('1018', 'you_are_not_able_to_update_profile_photo', 'You are not able to update profile photo'), ('1019', 'your_phone', 'Your phone'), ('1020', 'your_servers_file_upload_limit_is_40mb', 'Your servers file upload limit is 40mb'), ('1021', 'website_notification', 'Website notification'), ('1022', 'smtp_settings', 'Smtp settings'), ('1023', 'email_template', 'Email template'), ('1024', 'protocol', 'Protocol'), ('1025', 'smtp_crypto', 'Smtp crypto'), ('1026', 'smtp_host', 'Smtp host'), ('1027', 'smtp_port', 'Smtp port'), ('1028', 'smtp_from_email', 'Smtp from email'), ('1029', 'smtp_username', 'Smtp username'), ('1030', 'smtp_password', 'Smtp password'), ('1031', 'email_type', 'Email type'), ('1032', 'email_subject', 'Email subject'), ('1033', 'to_admin', 'To admin'), ('1034', 'to_user', 'To user'), ('1035', 'edit_email_template', 'Edit email template'), ('1036', 'to_instructor', 'To instructor'), ('1037', 'to_student', 'To student'), ('1038', 'to_affiliator', 'To affiliator'), ('1039', 'to_payer', 'To payer'), ('1040', 'to_receiver', 'To receiver'), ('1041', 'configure_your_notification_settings', 'Configure your notification settings'), ('1042', 'new_user_registration', 'New user registration'), ('1043', 'get_notified_when_a_new_user_signs_up', 'Get notified when a new user signs up'), ('1044', 'configure_for_admin', 'Configure for admin'), ('1045', 'system_notification', 'System notification'), ('1046', 'email_notification', 'Email notification'), ('1047', 'configure_for_user', 'Configure for user'), ('1048', 'email_verification', 'Email verification'), ('1049', 'not_editable', 'Not editable'), ('1050', 'it_is_permanently_enabled_for_student_email_verification.', 'It is permanently enabled for student email verification.'), ('1051', 'forgot_password_mail', 'Forgot password mail'), ('1052', 'account_security_alert', 'Account security alert'), ('1053', 'send_verification_code_for_login_from_a_new_device', 'Send verification code for login from a new device'), ('1054', 'course_purchase_notification', 'Course purchase notification'), ('1055', 'stay_up-to-date_on_student_course_purchases.', 'Stay up-to-date on student course purchases.'), ('1056', 'configure_for_student', 'Configure for student'), ('1057', 'configure_for_instructor', 'Configure for instructor'), ('1058', 'course_completion_mail', 'Course completion mail'), ('1059', 'stay_up_to_date_on_student_course_completion.', 'Stay up to date on student course completion.'), ('1060', 'course_eligibility_notification', 'Course eligibility notification'), ('1061', 'stay_up_to_date_on_course_certificate_eligibility.', 'Stay up to date on course certificate eligibility.'), ('1062', 'offline_payment_suspended_mail', 'Offline payment suspended mail'), ('1063', 'if_students_provides_fake_information,_notify_them_of_the_suspension', 'If students provides fake information, notify them of the suspension'), ('1064', 'course_bundle_purchase_notification', 'Course bundle purchase notification'), ('1065', 'stay_up-to-date_on_student_course_bundle_purchases.', 'Stay up-to-date on student course bundle purchases.'), ('1066', 'new_user_added_as_affiliator', 'New user added as affiliator'), ('1067', 'send_account_information_to_the_new_user', 'Send account information to the new user'), ('1068', 'configure_for_affiliator', 'Configure for affiliator'), ('1069', 'affiliate_approval_notification', 'Affiliate approval notification'), ('1070', 'send_affiliate_approval_mail_to_the_user_account', 'Send affiliate approval mail to the user account'), ('1071', 'affiliator_request_cancellation', 'Affiliator request cancellation'), ('1072', 'send_mail,_when_you_cancel_the_affiliation_request', 'Send mail, when you cancel the affiliation request'), ('1073', 'affiliation_money_withdrawal_request', 'Affiliation money withdrawal request'), ('1074', 'send_mail,_when_the_users_request_the_withdrawal_of_money', 'Send mail, when the users request the withdrawal of money'), ('1075', 'approval_of_withdrawal_request_of_affiliation', 'Approval of withdrawal request of affiliation'), ('1076', 'send_mail,_when_you_approved_the_affiliation_withdrawal_request', 'Send mail, when you approved the affiliation withdrawal request'), ('1077', 'course_gift_notification', 'Course gift notification'), ('1078', 'notify_users_after_course_gift', 'Notify users after course gift'), ('1079', 'configure_for_payer', 'Configure for payer'), ('1080', 'configure_for_receiver', 'Configure for receiver'), ('1081', 'total_amount', 'Total amount'), ('1082', 'enrolment_date', 'Enrolment date'), ('1083', 'blogs', 'Blogs'), ('1084', 'add_new_blog', 'Add new blog'), ('1085', 'student_id', 'Student id'), ('1086', 'user_deleted_successfully', 'User deleted successfully'), ('1087', 'national_id/iqama_id/empoyee_id', 'National id/iqama id/empoyee id'), ('1088', 'type_your_national_id/iqama_id/empoyee_id', 'Type your national id/iqama id/empoyee id'), ('1089', 'enter_national_id/iqama_id/empoyee_id', 'Enter national id/iqama id/empoyee id'), ('1090', 'you_have_already_registered', 'You have already registered'), ('1091', 'enter_your_id', 'Enter your id'), ('1092', 'system_currency_settings', 'System currency settings'), ('1093', 'system_currency', 'System currency'), ('1094', 'select_system_currency', 'Select system currency'), ('1095', 'currency_position', 'Currency position'), ('1096', 'left', 'Left'), ('1097', 'right', 'Right'), ('1098', 'left_with_a_space', 'Left with a space'), ('1099', 'right_with_a_space', 'Right with a space'), ('1100', 'update_system_currency', 'Update system currency'), ('1101', 'want_to_keep_test_mode_enabled', 'Want to keep test mode enabled'), ('1102', 'select_currency', 'Select currency'), ('1103', 'ensure_that_the_system_currency_and_all_active_payment_gateway_currencies_are_same', 'Ensure that the system currency and all active payment gateway currencies are same'), ('1104', 'national_id_/_iqama_id_/_empoyee_id', 'National id / iqama id / empoyee id'), ('1105', 'enter_student_id', 'Enter student id'), ('1106', 'issued_on', 'Issued on'), ('1107', 'years', 'Years'), ('1108', 'enter_expiry_year', 'Enter expiry year'), ('1109', 'expiry_years', 'Expiry years'), ('1110', 'certificate_year', 'Certificate year'), ('1111', 'enter_certificate_expiry', 'Enter certificate expiry'), ('1112', 'expiry_year', 'Expiry year'), ('1113', 'enter_national_id_/_iqama_id_/_empoyee_id', 'Enter national id / iqama id / empoyee id'), ('1114', 'upload', 'Upload'), ('1115', 'test', 'Test'), ('1116', 'shopping_cart', 'Shopping cart'), ('1117', 'your_cart_items', 'Your cart items'), ('1118', 'items', 'Items'), ('1119', 'subtotal', 'Subtotal'), ('1120', 'apply_coupon', 'Apply coupon'), ('1121', 'apply', 'Apply'), ('1122', 'send_as_a_gift', 'Send as a gift'), ('1123', 'email_address', 'Email address'), ('1124', 'continue_to_payment', 'Continue to payment'), ('1125', 'searching', 'Searching'), ('1126', 'payment_required', 'Payment required'), ('1127', 'your_payment_for_this_course_is_not_done._please_make_the_payment_to_access_the_course.', 'Your payment for this course is not done. please make the payment to access the course.'), ('1128', 'sorry_for_the_inconvenience,_but_your_certificate_is_currently_on_hold_due_to_an_outstanding_payment._once_the_balance_is_settled,_we_will_promptly_release_your_certificate._thank_you_for_your_cooperation_and_understanding.', 'Sorry for the inconvenience, but your certificate is currently on hold due to an outstanding payment. once the balance is settled, we will promptly release your certificate. thank you for your cooperation and understanding.'), ('1129', 'certificate_eligibility', 'Certificate eligibility'), ('1130', 'configure_for_', 'Configure for '), ('1131', 'payment_status', 'Payment status'), ('1132', 'date_added', 'Date added'), ('1133', 'data_deleted_successfully', 'Data deleted successfully'), ('1134', 'unpaid', 'Unpaid'), ('1135', 'mon', 'Mon'), ('1136', 'aug', 'Aug'), ('1137', 'sun', 'Sun'), ('1138', 'quiz_has_been_updated_successfully', 'Quiz has been updated successfully'), ('1139', 'back_to_certificates', 'Back to certificates'), ('1140', 'pay_for_purchasing_course', 'Pay for purchasing course'), ('1141', 'back_to_mobile_app', 'Back to mobile app'), ('1142', 'unverified', 'Unverified'), ('1143', 'successfully_disabled', 'Successfully disabled'), ('1144', 'successfully_enabled', 'Successfully enabled'), ('1145', 'smtp_settings_updated_successfully', 'Smtp settings updated successfully'), ('1146', 'user', 'User'), ('1147', 'student_has_been_enrolled_to_that_course', 'Student has been enrolled to that course'), ('1148', 'product_updated_successfully', 'Product updated successfully'), ('1149', 'contact', 'Contact'), ('1150', 'find_a_tutor', 'Find a tutor'), ('1151', 'cart', 'Cart'), ('1152', 'buy_the_course', 'Buy the course'), ('1153', '_', ' '), ('1154', '22', '22'), ('1155', 'booked_tuition', 'Booked tuition'), ('1156', 'social_login_configuration', 'Social login configuration'), ('1157', 'facebook_login', 'Facebook login'), ('1158', 'facebook_app_creation_instruction', 'Facebook app creation instruction'), ('1159', 'facebook_app_id', 'Facebook app id'), ('1160', 'facebook_app_secret', 'Facebook app secret'), ('1161', 'iframe', 'Iframe'), ('1162', 'iframe_source', 'Iframe source'), ('1163', 'provide_the_source_only', 'Provide the source only'), ('1164', 'system_settings_updated', 'System settings updated');
DROP TABLE IF EXISTS `lesson`;
CREATE TABLE `lesson` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `duration` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `course_id` int DEFAULT NULL,
  `section_id` int DEFAULT NULL,
  `video_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `cloud_video_id` int DEFAULT NULL,
  `video_url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `date_added` int DEFAULT NULL,
  `last_modified` int DEFAULT NULL,
  `lesson_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `attachment` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `attachment_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `caption` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `summary` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `is_free` int NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '0',
  `quiz_attempt` int NOT NULL DEFAULT '0',
  `video_type_for_mobile_application` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `video_url_for_mobile_application` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `duration_for_mobile_application` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `lesson` (`id`, `title`, `duration`, `course_id`, `section_id`, `video_type`, `cloud_video_id`, `video_url`, `date_added`, `last_modified`, `lesson_type`, `attachment`, `attachment_type`, `caption`, `summary`, `is_free`, `order`, `quiz_attempt`, `video_type_for_mobile_application`, `video_url_for_mobile_application`, `duration_for_mobile_application`) VALUES ('2', 'Final Quiz', '1:20:00', '1', '1', NULL, NULL, NULL, '1692482400', '1695852000', 'quiz', '{\"total_marks\":\"100\"}', 'json', NULL, '', '0', '2', '23', NULL, NULL, NULL), ('4', 'Final Quiz', '1:00:00', '2', '3', NULL, NULL, NULL, '1692568800', '1695333600', 'quiz', '{\"total_marks\":\"10\"}', 'json', NULL, 'test', '0', '0', '5', NULL, NULL, NULL), ('6', '34534', NULL, '1', '4', NULL, NULL, NULL, '1692568800', NULL, 'other', 'e4dde0bb315881b95b8824a27030d5c7.pdf', 'pdf', NULL, '&lt;p&gt;xfbxhbsh&lt;/p&gt;', '0', '0', '1', NULL, NULL, NULL), ('8', 'test', '0:00:00', '14', '5', NULL, NULL, NULL, '1696284000', NULL, 'quiz', '{\"total_marks\":\"10\"}', 'json', NULL, 'sdf', '0', '0', '20', NULL, NULL, NULL);
DROP TABLE IF EXISTS `log`;
CREATE TABLE `log` (
  `id` int NOT NULL,
  `from` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `message`;
CREATE TABLE `message` (
  `message_id` int NOT NULL AUTO_INCREMENT,
  `message_thread_code` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `message` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `sender` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `timestamp` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `read_status` int DEFAULT NULL,
  PRIMARY KEY (`message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `message_thread`;
CREATE TABLE `message_thread` (
  `message_thread_id` int NOT NULL AUTO_INCREMENT,
  `message_thread_code` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `sender` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT '',
  `receiver` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT '',
  `last_message_timestamp` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`message_thread_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `newsletter_subscriber`;
CREATE TABLE `newsletter_subscriber` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `updated_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `newsletters`;
CREATE TABLE `newsletters` (
  `id` int NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `created_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `updated_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `notification_settings`;
CREATE TABLE `notification_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `is_editable` int DEFAULT NULL,
  `addon_identifier` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `user_types` varchar(400) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `system_notification` varchar(400) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `email_notification` varchar(400) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `subject` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `template` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `setting_title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `setting_sub_title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `date_updated` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `notification_settings` (`id`, `type`, `is_editable`, `addon_identifier`, `user_types`, `system_notification`, `email_notification`, `subject`, `template`, `setting_title`, `setting_sub_title`, `date_updated`) VALUES ('1', 'signup', '1', NULL, '[\"admin\",\"user\"]', '{\"admin\":\"1\",\"user\":\"1\"}', '{\"admin\":\"0\",\"user\":\"0\"}', '{\"admin\":\"New user registered\",\"user\":\"Registered successfully\"}', '{\"admin\":\"New user registered [user_name] \\r\\n<br>User email: <b>[user_email]<\\/b>\",\"user\":\"You have successfully registered with us at [system_name].\"}', 'New user registration', 'Get notified when a new user signs up', '1695482339'), ('2', 'email_verification', '0', NULL, '[\"user\"]', '{\"user\":\"0\"}', '{\"user\":\"1\"}', '{\"user\":\"Email verification code\"}', '{\"user\":\"You have received a email verification code. Your verification code is [email_verification_code]\"}', 'Email verification', 'It is permanently enabled for student email verification.', '1684135777'), ('3', 'forget_password_mail', '0', NULL, '[\"user\"]', '{\"user\":\"0\"}', '{\"user\":\"1\"}', '{\"user\":\"Forgot password verification code\"}', '{\"user\":\"You have received a email verification code. Your verification code is [system_name][verification_link][minutes]\"}', 'Forgot password mail', 'It is permanently enabled for student email verification.', '1684145383'), ('4', 'new_device_login_confirmation', '0', NULL, '[\"user\"]', '{\"user\":\"0\"}', '{\"user\":\"1\"}', '{\"user\":\"Please confirm your login\"}', '{\"user\":\"Have you tried logging in with a different device? Confirm using the verification code. Your verification code is [verification_code]. Remember that you will lose access to your previous device after logging in to the new device <b>[user_agent]<\\/b>.<br> Use the verification code within [minutes] minutes\"}', 'Account security alert', 'Send verification code for login from a new device', '1684145383'), ('6', 'course_purchase', '1', NULL, '[\"admin\",\"student\",\"instructor\"]', '{\"admin\":\"1\",\"student\":\"1\",\"instructor\":\"1\"}', '{\"admin\":\"0\",\"student\":\"0\",\"instructor\":\"0\"}', '{\"admin\":\"A new course has been sold\",\"instructor\":\"A new course has been sold\",\"student\":\"You have purchased a new course\"}', '{\"admin\":\"<p>Course title: [course_title]<\\/p><p>Student: [student_name]\\r\\n<\\/p><p>Paid amount: [paid_amount]<\\/p><p>Instructor: [instructor_name]<\\/p>\",\"instructor\":\"Course title: [course_title]\\r\\nStudent: [student_name]\\r\\nPaid amount: [paid_amount]\",\"student\":\"Course title: [course_title]\\r\\nPaid amount: [paid_amount]\\r\\nInstructor: [instructor_name]\"}', 'Course purchase notification', 'Stay up-to-date on student course purchases.', '1684303456'), ('7', 'course_completion_mail', '1', NULL, '[\"student\",\"instructor\"]', '{\"student\":\"1\",\"instructor\":\"1\"}', '{\"student\":\"0\",\"instructor\":\"0\"}', '{\"instructor\":\"Course completion\",\"student\":\"You have completed a new course\"}', '{\"instructor\":\"Course completed [course_title]\\r\\nStudent: [student_name]\",\"student\":\"Course: [course_title]\\r\\nInstructor: [instructor_name]\"}', 'Course completion mail', 'Stay up to date on student course completion.', '1684303457'), ('8', 'certificate_eligibility', '1', 'certificate', '[\"student\",\"instructor\"]', '{\"student\":\"1\",\"instructor\":\"1\"}', '{\"student\":\"0\",\"instructor\":\"0\"}', '{\"instructor\":\"Certificate eligibility\",\"student\":\"certificate eligibility\"}', '{\"instructor\":\"Course: [course_title]\\r\\nStudent: [student_name]\\r\\nCertificate link: [certificate_link]\",\"student\":\"Course: [course_title]\\r\\nInstructor: [instructor_name]\\r\\nCertificate link: [certificate_link]\"}', 'Course eligibility notification', 'Stay up to date on course certificate eligibility.', '1684303460'), ('9', 'offline_payment_suspended_mail', '1', 'offline_payment', '[\"student\"]', '{\"student\":\"1\"}', '{\"student\":\"0\"}', '{\"student\":\"Your payment has been suspended\"}', '{\"student\":\"<p>Your offline payment has been <b style=\'color: red;\'>suspended</b> !</p><p>Please provide a valid document of your payment.</p>\"}', 'Offline payment suspended mail', 'If students provides fake information, notify them of the suspension', '1684303463'), ('10', 'bundle_purchase', '1', 'course_bundle', '[\"admin\",\"student\",\"instructor\"]', '{\"admin\":\"1\",\"student\":\"1\",\"instructor\":\"1\"}', '{\"admin\":\"0\",\"student\":\"0\",\"instructor\":\"0\"}', '{\"admin\":\"A new course bundle has been sold \",\"instructor\":\"A new course bundle has been sold \",\"student\":\"You have purchased a new course bundle test\"}', '{\"admin\":\"Course bundle: [bundle_title]\\r\\nStudent: [student_name]\\r\\nInstructor: [instructor_name] \",\"instructor\":\"Course bundle: [bundle_title]\\r\\nStudent: [student_name] \",\"student\":\"Course bundle: [bundle_title]\\r\\nInstructor: [instructor_name] \"}', 'Course bundle purchase notification', 'Stay up-to-date on student course bundle purchases.', '1684303467'), ('13', 'add_new_user_as_affiliator', '0', 'affiliate_course', '[\"affiliator\"]', '{\"affiliator\":\"0\"}', '{\"affiliator\":\"1\"}', '{\"affiliator\":\"Congratulation ! You are assigned as an affiliator\"}', '{\"affiliator\":\"You are assigned as a website Affiliator.\\r\\nWebsite: [website_link]\\r\\n<br>\\r\\nPassword: [password]\"}', 'New user added as affiliator', 'Send account information to the new user', '1684135777'), ('14', 'affiliator_approval_notification', '1', 'affiliate_course', '[\"affiliator\"]', '{\"affiliator\":\"1\"}', '{\"affiliator\":\"0\"}', '{\"affiliator\":\"Congratulations! Your affiliate request has been approved\"}', '{\"affiliator\":\"Congratulations! Your affiliate request has been approved\"}', 'Affiliate approval notification', 'Send affiliate approval mail to the user account', '1684303472'), ('15', 'affiliator_request_cancellation', '1', 'affiliate_course', '[\"affiliator\"]', '{\"affiliator\":\"1\"}', '{\"affiliator\":\"0\"}', '{\"affiliator\":\"Sorry ! Your request has been currently refused\"}', '{\"affiliator\":\"Sorry ! Your request has been currently refused.\"}', 'Affiliator request cancellation', 'Send mail, when you cancel the affiliation request', '1684303473'), ('16', 'affiliation_amount_withdrawal_request', '1', 'affiliate_course', '[\"admin\",\"affiliator\"]', '{\"admin\":\"1\",\"affiliator\":\"1\"}', '{\"admin\":\"0\",\"affiliator\":\"0\"}', '{\"admin\":\"New money withdrawal request\",\"affiliator\":\"New money withdrawal request\"}', '{\"admin\":\"New money withdrawal request by [\'user_name] [amount]\",\"affiliator\":\"Your Withdrawal request of [amount] has been sent to authority\"}', 'Affiliation money withdrawal request', 'Send mail, when the users request the withdrawal of money', '1684303476'), ('17', 'approval_affiliation_amount_withdrawal_request', '1', 'affiliate_course', '[\"affiliator\"]', '{\"affiliator\":\"1\"}', '{\"affiliator\":\"0\"}', '{\"affiliator\":\"Congartulation ! Your withdrawal request has been approved\"}', '{\"affiliator\":\"Congartulation ! Your payment request has been approved.\"}', 'Approval of withdrawal request of affiliation', 'Send mail, when you approved the affiliation withdrawal request', '1684303480'), ('18', 'course_gift', '1', NULL, '[\"payer\",\"receiver\"]', '{\"payer\":\"1\",\"receiver\":\"1\"}', '{\"payer\":\"0\",\"receiver\":\"0\"}', '{\"payer\":\"You have gift a course\",\"receiver\":\"You have received a course gift\"}', '{\"payer\":\"You have gift a course to [user_name] [course_title][instructor]\",\"receiver\":\"You have received a course gift by [course_title][instructor]\"}', 'Course gift notification', 'Notify users after course gift', '1684303482');
DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `from_user` int DEFAULT NULL,
  `to_user` int DEFAULT NULL,
  `type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `status` int DEFAULT NULL,
  `created_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `updated_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `notifications` (`id`, `from_user`, `to_user`, `type`, `title`, `description`, `status`, `created_at`, `updated_at`) VALUES ('8', NULL, '3', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692519925', NULL), ('9', '1', '3', 'course_status', 'Activated', 'Your course is activate', '0', '1692520535', NULL), ('10', '1', '3', 'course_status', 'asdad', 'asdasd', '0', '1692617367', NULL), ('12', '2', '3', 'certificate_eligibility', 'Certificate eligibility', '\n    <div>Course: <a href=\"https://showkeenz.com/academy/home/course/first-aid-cpr-aed/2\" target=\"_blank\">First AID-CPR-AED</a>\r\nStudent: John Doe\r\nCertificate link: <a href=\"https://showkeenz.com/academy/certificate/19c022e344\" target=\"_blank\"> Certificate link</a></div>\n    ', '0', '1692623951', NULL), ('13', '4', '4', 'certificate_eligibility', 'certificate eligibility', '\n    <div>Course: <a href=\"https://showkeenz.com/academy/home/course/hydrogen-sulfide-h2s-scba/1\" target=\"_blank\">Hydrogen Sulfide (H2S) + SCBA</a>\r\nInstructor: Waqas Ahmed\r\nCertificate link: <a href=\"https://showkeenz.com/academy/certificate/342b4f9a97\" target=\"_blank\"> Certificate link</a></div>\n    ', '0', '1692624563', NULL), ('16', NULL, '5', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692721342', NULL), ('18', NULL, '18', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692865578', NULL), ('20', NULL, '19', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692865876', NULL), ('22', NULL, '20', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692866284', NULL), ('24', NULL, '21', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692866411', NULL), ('26', NULL, '22', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692866805', NULL), ('28', NULL, '23', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692866845', NULL), ('30', NULL, '24', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692866971', NULL), ('32', NULL, '25', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692867219', NULL), ('34', NULL, '26', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692872652', NULL), ('36', NULL, '27', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692872793', NULL), ('38', NULL, '28', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692872901', NULL), ('40', NULL, '29', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692873159', NULL), ('42', NULL, '30', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692873242', NULL), ('44', NULL, '31', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1692873791', NULL), ('46', NULL, '32', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1693020462', NULL), ('48', NULL, '33', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1693021081', NULL), ('50', NULL, '34', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1693021128', NULL), ('52', NULL, '35', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1693021286', NULL), ('54', NULL, '36', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1693021365', NULL), ('56', NULL, '37', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1693021754', NULL), ('58', NULL, '38', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1693021991', NULL), ('60', NULL, '39', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1693022362', NULL), ('62', NULL, '40', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1693022528', NULL), ('64', NULL, '41', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1693023209', NULL), ('66', NULL, '42', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1693023469', NULL), ('68', NULL, '43', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1693134223', NULL), ('69', NULL, '3', 'certificate_eligibility', 'certificate eligibility', '\n    <div>Course: <a href=\"https://showkeenz.com/academy/home/course/first-aid-cpr-aed/2\" target=\"_blank\">First AID-CPR-AED</a>\r\nInstructor: John Wick\r\nCertificate link: <a href=\"https://showkeenz.com/academy/certificate/66ba7c15d6\" target=\"_blank\"> Certificate link</a></div>\n    ', '0', '1695118115', NULL), ('70', NULL, '3', 'certificate_eligibility', 'Certificate eligibility', '\n    <div>Course: <a href=\"https://showkeenz.com/academy/home/course/first-aid-cpr-aed/2\" target=\"_blank\">First AID-CPR-AED</a>\r\nStudent: John Wick\r\nCertificate link: <a href=\"https://showkeenz.com/academy/certificate/66ba7c15d6\" target=\"_blank\"> Certificate link</a></div>\n    ', '0', '1695118115', NULL), ('75', '437', '437', 'certificate_eligibility', 'certificate eligibility', '\n    <div>Course: <a href=\"https://showkeenz.com/academy/home/course/hydrogen-sulfide-h2s-scba/1\" target=\"_blank\">Hydrogen Sulfide (H2S) + SCBA</a>\r\nInstructor: noman khalid\r\nCertificate link: <a href=\"https://showkeenz.com/academy/certificate/1463267187\" target=\"_blank\"> Certificate link</a></div>\n    ', '0', '1695369524', NULL), ('77', NULL, '437', 'certificate_eligibility', 'certificate eligibility', '\n    <div>Course: <a href=\"https://showkeenz.com/academy/home/course/first-aid-cpr-aed/2\" target=\"_blank\">First AID-CPR-AED</a>\r\nInstructor: noman khalid\r\nCertificate link: <a href=\"https://showkeenz.com/academy/certificate/2aef6e6085\" target=\"_blank\"> Certificate link</a></div>\n    ', '0', '1695369715', NULL), ('78', NULL, '3', 'certificate_eligibility', 'Certificate eligibility', '\n    <div>Course: <a href=\"https://showkeenz.com/academy/home/course/first-aid-cpr-aed/2\" target=\"_blank\">First AID-CPR-AED</a>\r\nStudent: noman khalid\r\nCertificate link: <a href=\"https://showkeenz.com/academy/certificate/2aef6e6085\" target=\"_blank\"> Certificate link</a></div>\n    ', '0', '1695369715', NULL), ('79', NULL, '453', 'certificate_eligibility', 'certificate eligibility', '\n    <div>Course: <a href=\"https://showkeenz.com/academy/home/course/hydrogen-sulfide-h2s-scba/1\" target=\"_blank\">Hydrogen Sulfide (H2S) + SCBA</a>\r\nInstructor: Noman Khalid\r\nCertificate link: <a href=\"https://showkeenz.com/academy/certificate/ce30db054f\" target=\"_blank\"> Certificate link</a></div>\n    ', '0', '1695463171', NULL), ('84', NULL, '454', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1695482627', NULL), ('86', NULL, '455', 'signup', 'Registered successfully', '\n    <div>You have successfully registered with us at NeftEnergies.</div>\n    ', '0', '1695482788', NULL), ('88', NULL, NULL, 'certificate_eligibility', 'Certificate eligibility', '\n    <div>Course: <a href=\"https://showkeenz.com/academy/home/course/first-aid-cpr-aed/2\" target=\"_blank\">First AID-CPR-AED</a>\r\nStudent: Masud Alam\r\nCertificate link: <a href=\"https://showkeenz.com/academy/certificate/51fec7711a\" target=\"_blank\"> Certificate link</a></div>\n    ', '0', '1695664758', NULL), ('89', '458', '458', 'certificate_eligibility', 'certificate eligibility', '\n    <div>Course: <a href=\"https://showkeenz.com/academy/home/course/hydrogen-sulfide-h2s-scba/1\" target=\"_blank\">Hydrogen Sulfide (H2S) + SCBA</a>\r\nInstructor: Noman Khalid\r\nCertificate link: <a href=\"https://showkeenz.com/academy/certificate/63d861901f\" target=\"_blank\"> Certificate link</a></div>\n    ', '0', '1696438576', NULL), ('90', '458', '1', 'certificate_eligibility', 'Certificate eligibility', '\n    <div>Course: <a href=\"https://showkeenz.com/academy/home/course/hydrogen-sulfide-h2s-scba/1\" target=\"_blank\">Hydrogen Sulfide (H2S) + SCBA</a>\r\nStudent: Noman Khalid\r\nCertificate link: <a href=\"https://showkeenz.com/academy/certificate/63d861901f\" target=\"_blank\"> Certificate link</a></div>\n    ', '0', '1696438576', NULL);
DROP TABLE IF EXISTS `payment`;
CREATE TABLE `payment` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `course_id` int DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `date_added` int DEFAULT NULL,
  `last_modified` int DEFAULT NULL,
  `admin_revenue` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `instructor_revenue` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `instructor_payment_status` int DEFAULT '0',
  `transaction_id` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `session_id` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `coupon` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `payment_gateways`;
CREATE TABLE `payment_gateways` (
  `id` int NOT NULL AUTO_INCREMENT,
  `identifier` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `currency` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `keys` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `model_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `enabled_test_mode` int NOT NULL,
  `status` int NOT NULL,
  `is_addon` int NOT NULL,
  `created_at` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `updated_at` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `payment_gateways` (`id`, `identifier`, `currency`, `title`, `description`, `keys`, `model_name`, `enabled_test_mode`, `status`, `is_addon`, `created_at`, `updated_at`) VALUES ('1', 'paypal', 'USD', 'Paypal', '', '{\"sandbox_client_id\":\"AfGaziKslex-scLAyYdDYXNFaz2aL5qGau-SbDgE_D2E80D3AFauLagP8e0kCq9au7W4IasmFbirUUYc\",\"sandbox_secret_key\":\"EMa5pCTuOpmHkhHaCGibGhVUcKg0yt5-C3CzJw-OWJCzaXXzTlyD17SICob_BkfM_0Nlk7TWnN42cbGz\",\"production_client_id\":\"1234\",\"production_secret_key\":\"12345\"}', 'Payment_model', '1', '1', '0', '', '1673263724'), ('2', 'stripe', 'USD', 'Stripe', '', '{\"public_key\":\"pk_test_CAC3cB1mhgkJqXtypYBTGb4f\",\"secret_key\":\"sk_test_iatnshcHhQVRXdygXw3L2Pp2\",\"public_live_key\":\"pk_live_xxxxxxxxxxxxxxxxxxxxxxxx\",\"secret_live_key\":\"sk_live_xxxxxxxxxxxxxxxxxxxxxxxx\"}', 'Payment_model', '1', '1', '0', '', '1673263724'), ('3', 'razorpay', 'USD', 'Razorpay', '', '{\"key_id\":\"rzp_test_J60bqBOi1z1aF5\",\"secret_key\":\"uk935K7p4j96UCJgHK8kAU4q\",\"theme_color\":\"#23d792\"}', 'Payment_model', '1', '1', '0', '', '1673264610');
DROP TABLE IF EXISTS `payout`;
CREATE TABLE `payout` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `date_added` int DEFAULT NULL,
  `last_modified` int DEFAULT NULL,
  `status` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `admin_id` int DEFAULT NULL,
  `permissions` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `question`;
CREATE TABLE `question` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `quiz_id` int DEFAULT NULL,
  `title` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `number_of_options` int DEFAULT NULL,
  `options` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `correct_answers` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `question` (`id`, `quiz_id`, `title`, `type`, `number_of_options`, `options`, `correct_answers`, `order`) VALUES ('5', '2', '&lt;p&gt;Select True&lt;/p&gt;', 'single_choice', '2', '[\"False\",\"True\"]', '[\"2\"]', '0'), ('6', '2', '&lt;p&gt;Course delivered in-person?&lt;/p&gt;', 'single_choice', '2', '[\"True\",\"False\"]', '[\"1\"]', '0'), ('7', '2', '&lt;p&gt;What is greater than 10?&lt;/p&gt;', 'multiple_choice', '3', '[\"7\",\"3\",\"15\"]', '[\"3\"]', '0');
DROP TABLE IF EXISTS `quiz_results`;
CREATE TABLE `quiz_results` (
  `quiz_result_id` int NOT NULL AUTO_INCREMENT,
  `quiz_id` int NOT NULL,
  `user_id` int NOT NULL,
  `user_answers` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `correct_answers` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL COMMENT 'question_id',
  `total_obtained_marks` double NOT NULL,
  `date_added` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `date_updated` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `is_submitted` int NOT NULL,
  PRIMARY KEY (`quiz_result_id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `quiz_results` (`quiz_result_id`, `quiz_id`, `user_id`, `user_answers`, `correct_answers`, `total_obtained_marks`, `date_added`, `date_updated`, `is_submitted`) VALUES ('7', '2', '453', '{\"5\":[\"2\"],\"6\":[\"1\"],\"7\":[\"3\"]}', '[\"5\",\"6\",\"7\"]', '100', '1695464059', '1695464163', '1'), ('8', '2', '451', '{\"5\":[\"1\"],\"7\":[\"3\"],\"6\":[\"1\"]}', '[\"7\",\"6\"]', '66.7', '1695474908', '1695477781', '1'), ('9', '2', '451', '{\"5\":[\"2\"]}', '[\"5\"]', '33.3', '1695659349', '1695659494', '1'), ('10', '4', '451', '[]', '[]', '0', '1695664738', '', '1'), ('11', '4', '451', '[]', '[]', '0', '1695664747', '', '1'), ('12', '4', '451', '[]', '[]', '0', '1695664761', '', '1'), ('13', '2', '451', '{\"5\":[\"1\"],\"6\":[\"1\"]}', '[\"6\"]', '33.3', '1695665041', '1695668301', '1'), ('14', '2', '453', '{\"5\":[\"2\"]}', '[\"5\"]', '33.3', '1695715455', '1695715824', '1'), ('15', '2', '451', '{\"5\":[\"1\"]}', '[]', '0', '1695779294', '1695779298', '1'), ('16', '2', '457', '{\"5\":[\"2\"],\"6\":[\"2\"],\"7\":[\"3\"]}', '[\"5\",\"7\"]', '66.7', '1695879757', '1695879817', '1'), ('17', '4', '451', '[]', '[]', '0', '1695881535', '1695881535', '1'), ('18', '2', '451', '{\"5\":[\"1\"],\"6\":[\"1\"],\"7\":[\"2\"]}', '[\"6\"]', '33.3', '1695881668', '1695881675', '1'), ('19', '2', '451', '{\"5\":[\"1\"],\"6\":[\"1\"],\"7\":[\"1\"]}', '[\"6\"]', '33.3', '1695882056', '1695882062', '1'), ('20', '2', '451', '{\"5\":[\"1\"],\"6\":[\"1\"],\"7\":[\"1\"]}', '[\"6\"]', '33.3', '1695882111', '1695882116', '1'), ('21', '2', '451', '{\"5\":[\"2\"],\"6\":[\"2\"],\"7\":[\"2\"]}', '[\"5\"]', '33.3', '1695882119', '1695882123', '1'), ('22', '2', '451', '{\"5\":[\"1\"],\"7\":[\"3\"],\"6\":[\"2\"]}', '[\"7\"]', '33.3', '1695885176', '1695886429', '1'), ('23', '2', '457', '{\"5\":[\"2\"],\"7\":[\"3\"],\"6\":[\"2\"]}', '[\"5\",\"7\"]', '66.7', '1695886322', '1695886424', '1'), ('24', '2', '457', '[]', '[]', '0', '1695886429', '', '0'), ('25', '2', '451', '{\"5\":[\"1\"],\"6\":[\"1\"],\"7\":[\"3\"]}', '[\"6\",\"7\"]', '66.7', '1695886511', '1695886517', '1'), ('26', '2', '451', '{\"5\":[\"2\"],\"6\":[\"1\"],\"7\":[\"2\"]}', '[\"5\",\"6\"]', '66.7', '1695886575', '1695886580', '1'), ('27', '2', '451', '{\"5\":[\"2\"],\"6\":[\"1\"],\"7\":[\"3\"]}', '[\"5\",\"6\",\"7\"]', '100', '1695886588', '1695886593', '1'), ('28', '2', '453', '{\"5\":[\"2\"],\"6\":[\"1\"],\"7\":[\"3\"]}', '[\"5\",\"6\",\"7\"]', '100', '1695897153', '1695897164', '1'), ('29', '2', '451', '{\"5\":[\"2\"],\"6\":[\"1\"],\"7\":[\"3\"]}', '[\"5\",\"6\",\"7\"]', '100', '1695898126', '1695898133', '1'), ('30', '2', '451', '{\"6\":[\"1\"],\"7\":[\"1\"],\"5\":[\"1\"]}', '[\"6\"]', '33.3', '1695901212', '1695901218', '1'), ('31', '8', '451', '[]', '[]', '0', '1696360315', '', '1'), ('32', '8', '453', '[]', '[]', '0', '1696437664', '', '1'), ('33', '4', '453', '[]', '[]', '0', '1696437686', '', '0'), ('34', '2', '458', '{\"5\":[\"2\"],\"6\":[\"1\"],\"7\":[\"3\"]}', '[\"5\",\"6\",\"7\"]', '100', '1696438566', '1696438574', '1');
DROP TABLE IF EXISTS `rating`;
CREATE TABLE `rating` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `rating` double DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `ratable_id` int DEFAULT NULL,
  `ratable_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `date_added` int DEFAULT NULL,
  `last_modified` int DEFAULT NULL,
  `review` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `role`;
CREATE TABLE `role` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `date_added` int DEFAULT NULL,
  `last_modified` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `role` (`id`, `name`, `date_added`, `last_modified`) VALUES ('1', 'Admin', '1234567890', '1234567890'), ('2', 'User', '1234567890', '1234567890');
DROP TABLE IF EXISTS `section`;
CREATE TABLE `section` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `course_id` int DEFAULT NULL,
  `order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `section` (`id`, `title`, `course_id`, `order`) VALUES ('1', 'Day 1', '1', '2'), ('3', 'Section1', '2', '0'), ('4', 'video', '1', '1'), ('5', 'exam', '14', '0');
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `value` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `settings` (`id`, `key`, `value`) VALUES ('1', 'language', 'english'), ('2', 'system_name', 'NeftEnergies'), ('3', 'system_title', 'Academy Learning Club'), ('4', 'system_email', 'academy@example.com'), ('5', 'address', 'Sydney, Australia'), ('6', 'phone', '+143-52-9933631'), ('7', 'purchase_code', '82748f56-8fb6-4143-a6fa-126e41e50f66'), ('8', 'paypal', '[{\"active\":\"1\",\"mode\":\"sandbox\",\"sandbox_client_id\":\"AfGaziKslex-scLAyYdDYXNFaz2aL5qGau-SbDgE_D2E80D3AFauLagP8e0kCq9au7W4IasmFbirUUYc\",\"sandbox_secret_key\":\"EMa5pCTuOpmHkhHaCGibGhVUcKg0yt5-C3CzJw-OWJCzaXXzTlyD17SICob_BkfM_0Nlk7TWnN42cbGz\",\"production_client_id\":\"1234\",\"production_secret_key\":\"12345\"}]'), ('9', 'stripe_keys', '[{\"active\":\"1\",\"testmode\":\"on\",\"public_key\":\"pk_test_CAC3cB1mhgkJqXtypYBTGb4f\",\"secret_key\":\"sk_test_iatnshcHhQVRXdygXw3L2Pp2\",\"public_live_key\":\"pk_live_xxxxxxxxxxxxxxxxxxxxxxxx\",\"secret_live_key\":\"sk_live_xxxxxxxxxxxxxxxxxxxxxxxx\"}]'), ('10', 'youtube_api_key', 'youtube-api-key'), ('11', 'vimeo_api_key', 'vimeo-api-key'), ('12', 'slogan', 'A course based video CMS'), ('13', 'text_align', NULL), ('14', 'allow_instructor', '1'), ('15', 'instructor_revenue', '70'), ('16', 'system_currency', 'USD'), ('17', 'paypal_currency', 'USD'), ('18', 'stripe_currency', 'USD'), ('19', 'author', 'Creativeitem'), ('20', 'currency_position', 'left'), ('21', 'website_description', 'Study any topic, anytime. explore thousands of courses for the lowest price ever!'), ('22', 'website_keywords', 'LMS,Learning Management System,Creativeitem,Academy LMS'), ('23', 'footer_text', 'Creativeitem'), ('24', 'footer_link', 'https://creativeitem.com/'), ('25', 'protocol', 'smtp'), ('26', 'smtp_host', 'mail.showkeenz.com'), ('27', 'smtp_port', '993'), ('28', 'smtp_user', 'notification@showkeenz.com'), ('29', 'smtp_pass', 'pW+;pxN6,L4#'), ('30', 'version', '6.1'), ('31', 'student_email_verification', 'enable'), ('32', 'instructor_application_note', 'Fill all the fields carefully and share if you want to share any document with us it will help us to evaluate you as an instructor.'), ('33', 'razorpay_keys', '[{\"active\":\"1\",\"key\":\"rzp_test_J60bqBOi1z1aF5\",\"secret_key\":\"uk935K7p4j96UCJgHK8kAU4q\",\"theme_color\":\"#c7a600\"}]'), ('34', 'razorpay_currency', 'USD'), ('35', 'fb_app_id', 'fb-app-id'), ('36', 'fb_app_secret', 'fb-app-secret'), ('37', 'fb_social_login', '0'), ('38', 'drip_content_settings', '{\"lesson_completion_role\":\"percentage\",\"minimum_duration\":15,\"minimum_percentage\":\"50\",\"locked_lesson_message\":\"&lt;h3 xss=&quot;removed&quot; style=&quot;text-align: center; &quot;&gt;&lt;span xss=&quot;removed&quot;&gt;&lt;strong&gt;Permission denied!&lt;\\/strong&gt;&lt;\\/span&gt;&lt;\\/h3&gt;&lt;p xss=&quot;removed&quot; style=&quot;text-align: center; &quot;&gt;&lt;span xss=&quot;removed&quot;&gt;This course supports drip content, so you must complete the previous lessons.&lt;\\/span&gt;&lt;\\/p&gt;\"}'), ('41', 'course_accessibility', 'publicly'), ('42', 'smtp_crypto', 'ssl'), ('43', 'allowed_device_number_of_loging', '5'), ('47', 'academy_cloud_access_token', 'jdfghasdfasdfasdfasdfasdf'), ('48', 'course_selling_tax', '0'), ('49', 'ccavenue_keys', '[{\"active\":\"1\",\"ccavenue_merchant_id\":\"cmi_xxxxxx\",\"ccavenue_working_key\":\"cwk_xxxxxxxxxxxx\",\"ccavenue_access_code\":\"ccc_xxxxxxxxxxxxx\"}]'), ('50', 'ccavenue_currency', 'INR'), ('51', 'iyzico_keys', '[{\"active\":\"1\",\"testmode\":\"on\",\"iyzico_currency\":\"TRY\",\"api_test_key\":\"atk_xxxxxxxx\",\"secret_test_key\":\"stk_xxxxxxxx\",\"api_live_key\":\"alk_xxxxxxxx\",\"secret_live_key\":\"slk_xxxxxxxx\"}]'), ('52', 'iyzico_currency', 'TRY'), ('53', 'paystack_keys', '[{\"active\":\"1\",\"testmode\":\"on\",\"secret_test_key\":\"sk_test_c746060e693dd50c6f397dffc6c3b2f655217c94\",\"public_test_key\":\"pk_test_0816abbed3c339b8473ff22f970c7da1c78cbe1b\",\"secret_live_key\":\"sk_live_xxxxxxxxxxxxxxxxxxxxx\",\"public_live_key\":\"pk_live_xxxxxxxxxxxxxxxxxxxxx\"}]'), ('54', 'paystack_currency', 'NGN'), ('55', 'paytm_keys', '[{\"PAYTM_MERCHANT_KEY\":\"PAYTM_MERCHANT_KEY\",\"PAYTM_MERCHANT_MID\":\"PAYTM_MERCHANT_MID\",\"PAYTM_MERCHANT_WEBSITE\":\"DEFAULT\",\"INDUSTRY_TYPE_ID\":\"Retail\",\"CHANNEL_ID\":\"WEB\"}]'), ('57', 'google_analytics_id', ''), ('58', 'meta_pixel_id', ''), ('59', 'smtp_from_email', 'notification@showkeenz.com'), ('60', 'randCallRange', '56'), ('61', 'certificate_template', 'Mr. / Ms. {student} successfully completed the course for {course}.'), ('62', 'certificate-text-positons', '\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			\n			&lt;div class=&quot;this-template&quot; style=&quot;width: 750px; position: relative;&quot;&gt;\n				&lt;img width=&quot;100%&quot; src=&quot;..\\..\\uploads/certificates/template.jpg&quot;&gt;\n				&lt;div class=&quot;draggable image&quot; style=&quot;position: absolute; font-family: &amp;quot;Miss Fajardose&amp;quot;; font-size: 40px; top: 109.9px; left: 51.8833px;&quot;&gt;{image}&lt;/div&gt;&lt;div class=&quot;draggable student_id&quot; style=&quot;position: absolute; font-size: 16px; top: 308.867px; left: 73.8667px;&quot;&gt;{student_id}&lt;/div&gt;\n&lt;div class=&quot;draggable certificate_id&quot; style=&quot;position: absolute; font-size: 16px; top: 406.833px; left: 60.85px;&quot;&gt;{certificate_id}&lt;/div&gt;\n&lt;div class=&quot;draggable certificate_year&quot; style=&quot;position: absolute; font-size: 20px; top: 260.917px; left: 611.883px;&quot;&gt;{certificate_year}&lt;/div&gt;\n				&lt;div class=&quot;draggable course_completion_date&quot; style=&quot;position: absolute; font-size: 20px; top: 192.917px; left: 606.883px;&quot;&gt;{date}&lt;/div&gt;\n				&lt;div class=&quot;draggable certificate_text&quot; style=&quot;position: absolute; width: 400px; text-align: center; font-size: 28px; top: 218.95px; font-family: &amp;quot;Pinyon Script&amp;quot;; left: 186.9px;&quot;&gt;Mr. / Ms. {student} successfully completed the course for {course}.&lt;/div&gt;\n				&lt;div class=&quot;draggable qrCode&quot; style=&quot;position: absolute; width: 85px; height: 85px; text-align: center; font-size: 20px; top: 342.9px; left: 611.917px;&quot;&gt;&lt;p style=&quot;text-align: center; padding: 4px 0px;&quot;&gt;Qr code&lt;/p&gt;&lt;/div&gt;\n			&lt;/div&gt;\n																																																																																																																																																');
DROP TABLE IF EXISTS `tag`;
CREATE TABLE `tag` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tagable_id` int DEFAULT NULL,
  `tagable_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `date_added` int DEFAULT NULL,
  `last_modified` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
DROP TABLE IF EXISTS `tutor_booking`;
CREATE TABLE `tutor_booking` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `sub_category_id` int DEFAULT '0',
  `price_type` varchar(255) DEFAULT NULL,
  `tution_class_type` varchar(255) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT '0.00',
  `tutor_id` int DEFAULT NULL,
  `meeting_link` varchar(255) DEFAULT NULL,
  `date_added` varchar(255) DEFAULT NULL,
  `active_status` int DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;
INSERT INTO `tutor_booking` (`id`, `title`, `category_id`, `sub_category_id`, `price_type`, `tution_class_type`, `price`, `tutor_id`, `meeting_link`, `date_added`, `active_status`) VALUES ('1', 'H2s', '0', '0', 'fixed', '2', '150.00', '1', 'https://neftenergies.com', '1692439500', '1'), ('2', 'First AID-CPR-AED', '3', '4', 'fixed', '2', '15.00', '3', 'https://neftenergies.com', '1692520080', '1'), ('3', 'Afternoon Session', '3', '4', 'fixed', '2', '150.00', '1', 'https://neftenergies.com', '1692608100', '1'), ('4', 'H2S Arabic', '3', '4', 'fixed', '2', '2.00', '3', 'https://youtube.com', '1692616740', '1');
DROP TABLE IF EXISTS `tutor_category`;
CREATE TABLE `tutor_category` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `parent` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;
INSERT INTO `tutor_category` (`id`, `name`, `slug`, `parent`) VALUES ('3', 'Safety Courses', 'safety-courses', '0'), ('4', 'Height Safety', 'height-safety', '3');
DROP TABLE IF EXISTS `tutor_live_class_settings`;
CREATE TABLE `tutor_live_class_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `zoom_meeting_id` varchar(255) DEFAULT NULL,
  `zoom_meeting_password` varchar(255) DEFAULT NULL,
  `zoom_api_key` varchar(255) DEFAULT NULL,
  `zoom_secret_key` varchar(255) DEFAULT NULL,
  `tutor_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
DROP TABLE IF EXISTS `tutor_payment`;
CREATE TABLE `tutor_payment` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `student_id` int DEFAULT NULL,
  `tutor_id` int DEFAULT NULL,
  `booking_id` int DEFAULT NULL,
  `schedule_id` int DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `date_added` varchar(255) DEFAULT NULL,
  `admin_revenue` decimal(10,2) DEFAULT NULL,
  `instructor_revenue` decimal(10,2) DEFAULT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `last_modified` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
INSERT INTO `tutor_payment` (`id`, `student_id`, `tutor_id`, `booking_id`, `schedule_id`, `amount`, `payment_type`, `date_added`, `admin_revenue`, `instructor_revenue`, `transaction_id`, `last_modified`) VALUES ('1', '3', '3', '2', '9', '15.00', 'stripe', '1692482400', '4.00', '11.00', '', ''), ('2', '2', '3', '4', '66', '2.00', 'stripe', '1692568800', '0.00', '2.00', '', '');
DROP TABLE IF EXISTS `tutor_reviews`;
CREATE TABLE `tutor_reviews` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `tutor_id` int DEFAULT NULL,
  `review` longtext,
  `rating` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT '1',
  `date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
DROP TABLE IF EXISTS `tutor_schedule`;
CREATE TABLE `tutor_schedule` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int DEFAULT '0',
  `tutor_id` int DEFAULT '0',
  `start_time` varchar(255) DEFAULT NULL,
  `end_time` varchar(255) DEFAULT NULL,
  `tuition_type` int DEFAULT '3',
  `valid_till` varchar(255) DEFAULT NULL,
  `tution_class_type` varchar(255) DEFAULT NULL,
  `selected_days` varchar(255) DEFAULT NULL,
  `class_type` varchar(255) DEFAULT NULL,
  `status` int DEFAULT '0',
  `student_id` varchar(255) DEFAULT NULL,
  `active_status` int DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb3;
INSERT INTO `tutor_schedule` (`id`, `booking_id`, `tutor_id`, `start_time`, `end_time`, `tuition_type`, `valid_till`, `tution_class_type`, `selected_days`, `class_type`, `status`, `student_id`, `active_status`) VALUES ('1', '1', '1', '1692525900', '1692536700', '0', '1695301500', '2', '[\"sunday\"]', NULL, '0', NULL, '1'), ('2', '1', '1', '1693130700', '1693141500', '0', '1695301500', '2', '[\"sunday\"]', NULL, '0', NULL, '1'), ('3', '1', '1', '1693735500', '1693746300', '0', '1695301500', '2', '[\"sunday\"]', NULL, '0', NULL, '1'), ('4', '1', '1', '1694340300', '1694351100', '0', '1695301500', '2', '[\"sunday\"]', NULL, '0', NULL, '1'), ('5', '1', '1', '1694945100', '1694955900', '0', '1695301500', '2', '[\"sunday\"]', NULL, '0', NULL, '1'), ('6', '2', '3', '1693117800', '1693128600', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '0'), ('7', '2', '3', '1693377000', '1693387800', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '0'), ('8', '2', '3', '1693463400', '1693474200', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '0'), ('9', '2', '3', '1693722600', '1693733400', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '1', '3', '0'), ('10', '2', '3', '1693981800', '1693992600', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '0'), ('11', '2', '3', '1694068200', '1694079000', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '0'), ('12', '2', '3', '1694327400', '1694338200', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '0'), ('13', '2', '3', '1694586600', '1694597400', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '0'), ('14', '2', '3', '1694673000', '1694683800', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '0'), ('15', '2', '3', '1694932200', '1694943000', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '0'), ('16', '2', '3', '1695191400', '1695202200', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '0'), ('17', '2', '3', '1695277800', '1695288600', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '0'), ('18', '2', '3', '1695537000', '1695547800', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '0'), ('19', '2', '3', '1695796200', '1695807000', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '0'), ('20', '2', '3', '1695882600', '1695893400', '0', '1695893400', '2', '[\"sunday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '0'), ('21', '3', '1', '1693126380', '1693137180', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('22', '3', '1', '1693212780', '1693223580', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('23', '3', '1', '1693299180', '1693309980', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('24', '3', '1', '1693385580', '1693396380', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('25', '3', '1', '1693471980', '1693482780', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('26', '3', '1', '1693731180', '1693741980', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('27', '3', '1', '1693817580', '1693828380', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('28', '3', '1', '1693903980', '1693914780', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('29', '3', '1', '1693990380', '1694001180', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('30', '3', '1', '1694076780', '1694087580', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('31', '3', '1', '1694335980', '1694346780', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('32', '3', '1', '1694422380', '1694433180', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('33', '3', '1', '1694508780', '1694519580', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('34', '3', '1', '1694595180', '1694605980', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('35', '3', '1', '1694681580', '1694692380', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('36', '3', '1', '1694940780', '1694951580', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('37', '3', '1', '1695027180', '1695037980', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('38', '3', '1', '1695113580', '1695124380', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('39', '3', '1', '1695199980', '1695210780', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('40', '3', '1', '1695286380', '1695297180', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('41', '3', '1', '1695545580', '1695556380', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('42', '3', '1', '1695631980', '1695642780', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('43', '3', '1', '1695718380', '1695729180', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('44', '3', '1', '1695804780', '1695815580', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('45', '3', '1', '1695891180', '1695901980', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('46', '3', '1', '1696150380', '1696161180', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('47', '3', '1', '1696236780', '1696247580', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('48', '3', '1', '1696323180', '1696333980', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('49', '3', '1', '1696409580', '1696420380', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('50', '3', '1', '1696495980', '1696506780', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('51', '3', '1', '1696755180', '1696765980', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('52', '3', '1', '1696841580', '1696852380', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('53', '3', '1', '1696927980', '1696938780', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('54', '3', '1', '1697014380', '1697025180', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('55', '3', '1', '1697100780', '1697111580', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('56', '3', '1', '1697359980', '1697370780', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('57', '3', '1', '1697446380', '1697457180', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('58', '3', '1', '1697532780', '1697543580', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('59', '3', '1', '1697619180', '1697629980', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('60', '3', '1', '1697705580', '1697716380', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('61', '3', '1', '1697964780', '1697975580', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('62', '3', '1', '1698051180', '1698061980', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('63', '3', '1', '1698137580', '1698148380', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('64', '3', '1', '1698223980', '1698234780', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('65', '3', '1', '1698310380', '1698321180', '0', '1698321180', '2', '[\"sunday\",\"monday\",\"tuesday\",\"wednesday\",\"thursday\"]', NULL, '0', NULL, '1'), ('66', '4', '3', '1692616680', '1692627480', '1', '1692627480', '2', NULL, NULL, '1', '2', '1');
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `email` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `phone` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `address` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `skills` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `social_links` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `biography` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `role_id` int DEFAULT NULL,
  `date_added` int DEFAULT NULL,
  `last_modified` int DEFAULT NULL,
  `wishlist` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `title` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `payment_keys` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `verification_code` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `status` int DEFAULT NULL,
  `is_instructor` int DEFAULT '0',
  `image` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `sessions` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `student_id` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `payment_status` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=459 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `users` (`id`, `first_name`, `last_name`, `email`, `phone`, `address`, `password`, `skills`, `social_links`, `biography`, `role_id`, `date_added`, `last_modified`, `wishlist`, `title`, `payment_keys`, `verification_code`, `status`, `is_instructor`, `image`, `sessions`, `student_id`, `payment_status`) VALUES ('1', 'Noman ', 'Khalid', 'hello@smartdivs.com', NULL, NULL, '7c222fb2927d828af22f592134e8932480637c0d', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', '', '1', NULL, '1696440192', NULL, '', '', 'aGVsbG9Ac21hcnRkaXZzLmNvbV9VaDYjQCM2aFVfODI2MjE5MA', '1', '1', '499c46cf9bc91336ea50c8213b2522b9', '', NULL, '0'), ('451', 'Masud', 'Alam', 'howto.liton@gmail.com', NULL, NULL, '7c4a8d09ca3762af61e59520943dc26494f8941b', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', '<p>test<br></p>', '2', '1695242708', '1696484802', '[\"1\"]', NULL, '{\"paypal\":{\"sandbox_client_id\":\"\",\"sandbox_secret_key\":\"\",\"production_client_id\":\"\",\"production_secret_key\":\"\"},\"stripe\":{\"public_key\":\"\",\"secret_key\":\"\",\"public_live_key\":\"\",\"secret_live_key\":\"\"},\"razorpay\":{\"key_id\":\"\",\"secret_key\":\"\",\"theme_color\":\"\"}}', 'aG93dG8ubGl0b25AZ21haWwuY29tX1VoNiNAIzZoVV8zNTYyNzQy', '1', '0', NULL, '[\"a7lfnvkmnufoe10h44jq6r8if3dtaomg\",\"bdtodpmn56g1gc4j5lqpmu55ebpt82n6\",\"1kovnlmj4d1phe0ij7agcklmue5111e0\"]', '57766', '1'), ('453', 'Noman', 'Khalid', NULL, NULL, NULL, '7c4a8d09ca3762af61e59520943dc26494f8941b', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', '', '2', '1695462639', NULL, '[]', NULL, '[]', '156250', '1', '0', NULL, '[]', '123456789', '0'), ('457', 'John', 'Doe', 'student2@example.com', NULL, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', NULL, '2', '1695876049', NULL, '[]', NULL, '[]', NULL, '1', '0', '090910ea3900914533215fcfe1aae376', '[\"58s04t3rebgcln1k2psnv8fk29nlf5oo\"]', NULL, NULL), ('458', 'Noman', 'Khalid', NULL, NULL, NULL, '7c4a8d09ca3762af61e59520943dc26494f8941b', '', '{\"facebook\":\"\",\"twitter\":\"\",\"linkedin\":\"\"}', NULL, '2', '1696437803', NULL, '[]', NULL, '[]', '281983', '1', '0', NULL, '', '123456789', NULL);
DROP TABLE IF EXISTS `watch_histories`;
CREATE TABLE `watch_histories` (
  `watch_history_id` int NOT NULL AUTO_INCREMENT,
  `course_id` int NOT NULL,
  `student_id` int NOT NULL,
  `completed_lesson` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `course_progress` int NOT NULL,
  `watching_lesson_id` int NOT NULL,
  `quiz_result` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `completed_date` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `date_added` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `date_updated` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`watch_history_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
INSERT INTO `watch_histories` (`watch_history_id`, `course_id`, `student_id`, `completed_lesson`, `course_progress`, `watching_lesson_id`, `quiz_result`, `completed_date`, `date_added`, `date_updated`) VALUES ('10', '1', '453', '[\"6\",\"2\"]', '100', '2', '', '1695463171', '50', '1695897186'), ('11', '1', '1', '', '0', '2', '', NULL, '1695463238', '1695665000'), ('12', '1', '451', '[\"6\",\"2\"]', '100', '6', '', '1695477789', '50', '1696360154'), ('13', '2', '451', '[\"4\"]', '100', '4', '', '1695664758', '100', '1696360198'), ('14', '1', '457', '[\"2\"]', '50', '2', '', NULL, '1695876304', '1695886425'), ('15', '14', '451', '[\"8\"]', '100', '8', '', NULL, '100', NULL), ('16', '14', '453', '[\"8\"]', '100', '8', '', NULL, '100', NULL), ('17', '1', '458', '[\"6\",\"2\"]', '100', '6', '', '1696438576', '50', '1696438695');
DROP TABLE IF EXISTS `watched_duration`;
CREATE TABLE `watched_duration` (
  `watched_id` int unsigned NOT NULL AUTO_INCREMENT,
  `watched_student_id` int DEFAULT NULL,
  `watched_course_id` int DEFAULT NULL,
  `watched_lesson_id` int DEFAULT NULL,
  `current_duration` int DEFAULT NULL,
  `watched_counter` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`watched_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
