<?php
/**
 * The template for Job Detail 
 */
// set view in db if user comes first time cookie
global $post, $current_user, $cs_form_fields2, $cs_plugin_options;

$cs_job_posted_date_formate = 'd-m-Y H:i:s';
$cs_job_expired_date_formate = 'd-m-Y H:i:s';
$current_post_ids = get_the_ID();
?>
<div class="main-section jobs-detail-3">
    <?php
    /*
     *  login user detail
     */
    $login_user_name = '';
    $login_user_email = '';
    $login_user_phone = '';
    $cs_emp_funs = new cs_employer_functions();
    if ( is_user_logged_in() ) {
        $user_info = get_userdata($current_user->ID);
        if ( isset($user_info->display_name) )
            $login_user_name = $user_info->display_name;
        if ( isset($user_info->user_email) )
            $login_user_email = $user_info->user_email;

        $login_user_phone = get_user_meta($user_info->ID, 'cs_phone_number', true);
    }

    $cs_job_status = get_post_meta($post->ID, 'cs_job_status', true);
    $cs_job_emplyr = get_post_meta($post->ID, 'cs_job_username', true);
    $user = get_user_by('login', $cs_job_emplyr);
    do_action('jobhunt_google_sturctured_jobs_posting', $post->ID);
    $cs_post_view = true;
    if ( $cs_job_status != 'active' ) {
        $cs_post_view = false;
        if ( is_user_logged_in() && $cs_job_emplyr == $current_user->user_login ) {
            $cs_post_view = true;
            $cs_owner_view = true;
        }
        if ( is_user_logged_in() && current_user_can('administrator') ) {
            $cs_post_view = true;
            $cs_owner_view = true;
        }
    }
    if ( $cs_post_view == true ) {
        if ( have_posts() ):
            while ( have_posts() ) : the_post();
                $job_post = $post;
                // get all job types
                $all_specialisms = get_the_terms($job_post->ID, 'specialisms');
                $specialisms_values = '';
                $specialism_flag = 1;
                if ( $all_specialisms != '' ) {
                    foreach ( $all_specialisms as $specialismsitem ) {
                        $specialisms_values .= $specialismsitem->slug;
                        if ( $specialism_flag != count($all_specialisms) ) {
                            $specialisms_values .= ", ";
                        }
                        $specialism_flag ++;
                    }
                }
                // get posted user
                $cs_job_username = get_post_meta(get_the_ID(), 'cs_job_username', true);
                // getting employer information
                $employer_post = get_user_by('login', $cs_job_username);

                $job_address = get_user_address_string_for_detail($job_post->ID);

                // getting from plugin options
                $cs_title_f_size = isset($cs_plugin_options['cs_job_default_header_title_f_size']) ? $cs_plugin_options['cs_job_default_header_title_f_size'] : '';
                $cs_title_color = isset($cs_plugin_options['cs_job_default_header_title_color']) ? $cs_plugin_options['cs_job_default_header_title_color'] : '';
                $cs_title_style_str = '';
                if ( ($cs_title_f_size != '' && $cs_title_f_size > 0) || $cs_title_color != '' ) {
                    $cs_title_style_str .= ' style="';
                    if ( $cs_title_f_size != '' && $cs_title_f_size > 0 ) {
                        $cs_title_style_str .= ' font-size: ' . $cs_title_f_size . 'px !important;';
                    }
                    if ( $cs_title_color != '' ) {
                        $cs_title_style_str .= ' color: ' . $cs_title_color . ' !important;';
                    }
                    $cs_title_style_str .= '"';
                }
                $celine_active = false;
                $celine_active = apply_filters('jobhunt_celine_depedency', $celine_active);
                ?>
                <div class="page-section">
                    <div class="<?php if ( isset($cs_plugin_options['cs_plugin_single_container']) && $cs_plugin_options['cs_plugin_single_container'] == 'on' ) echo 'container' ?>">
                        <div class="row">
                            <div class="section-fullwidtht col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <div class="row">
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                        <?php
                                        $flag = 1;
                                        if ( isset($employer_post) && $employer_post != '' ) {
                                            $cs_employee_web_http = $employer_post->user_url;
                                            $cs_email = $employer_post->user_email;
                                            $cs_employee_web = preg_replace('#^https?://#', '', $cs_employee_web_http);
                                            $cs_employee_facebook = get_user_meta($employer_post->ID, 'cs_facebook', true);
                                            $cs_employee_twitter = get_user_meta($employer_post->ID, 'cs_twitter', true);
                                            $cs_employee_linkedin = get_user_meta($employer_post->ID, 'cs_linkedin', true);
                                            $cs_employee_google_plus = get_user_meta($employer_post->ID, 'cs_google_plus', true);
                                            $cs_phone_number = get_user_meta($employer_post->ID, 'cs_phone_number', true);
                                            $cs_employee_employer_img = get_user_meta($employer_post->ID, 'user_img', true);
                                            $cs_employee_employer_img = cs_get_img_url($cs_employee_employer_img, 'cs_media_5');
                                            $cs_employee_employer_img = apply_filters('digitalmarketing_job_image', $cs_employee_employer_img, $job_post->ID);
                                            if ( ! cs_image_exist($cs_employee_employer_img) || $cs_employee_employer_img == "" ) {
                                                $cs_employee_employer_img = esc_url(wp_jobhunt::plugin_url() . 'assets/images/img-not-found4x3.jpg');
                                            }
                                            $username = $employer_post->display_name;
                                            // getting job posted date 
                                            $cs_job_posted_date = get_post_meta($job_post->ID, 'cs_job_posted', true);
                                            // getting job application count
                                            $applications = 0;
                                            $cs_applicants = count_usermeta('cs-user-jobs-applied-list', serialize(strval($job_post->ID)), 'LIKE', true);
                                            $applications += count($cs_applicants);
                                            // getting job count views
                                            $cs_count_views = get_post_meta($job_post->ID, "cs_count_views", true);
                                            //  job info section
                                            $jobs_info_output = '';
                                            $jobs_info_output .= '<div class="jobs-info">';
                                            $jobs_info_output .= do_action('jobhunt_job_detail_top', get_the_ID());
                                            $jobs_info_output .= cs_check_expire_job(get_the_ID(), 'html');
                                            //  image section
                                            if ( $cs_employee_employer_img <> '' && ! $celine_active ) {
                                                $jobs_info_output .= '<div class="cs-media">';
                                                $jobs_info_output .= '<figure>';
                                                $jobs_info_output .= '<a href="' . esc_url(get_author_posts_url($employer_post->ID)) . '">';
                                                $jobs_info_output .= '<img src="' . esc_url($cs_employee_employer_img) . '" alt="' . esc_html($employer_post->post_title) . '" />';
                                                $jobs_info_output .= '</a>';
                                                $jobs_info_output .= '</figure>';
                                                $jobs_info_output .= '</div>';
                                            }
                                            //  content section
                                            $jobs_info_output .= '<div class="cs-text">';
                                            if ( ! $celine_active ) {
                                                $jobs_info_output .= '<strong>' . esc_attr($username) . '</strong>';
                                            }
                                            $jobs_info_output = apply_filters('jobhunt_celine_entity_job_detail', $jobs_info_output, $job_post->ID);
                                            $jobs_info_output .= '<ul class="post-options">';
                                            $job_address = apply_filters('jobhunt_job_address_frontend', $job_address, $job_post->ID);
                                            $jobs_locations_enabled = apply_filters('jobhunt_jobs_locations_enabled', 'yes');
                                            if( $jobs_locations_enabled == 'yes'){
                                                if ( $job_address != '' ) {
                                                    $jobs_info_output .= '<li><i class="icon-location6"></i><a href="#">' . esc_attr($job_address) . '</a></li>';
                                                }                                         
                                            }
                                            /*Add on listing of custom searching listing*/
                                            //$jobs_info_output .= apply_filters('show_custom_search_in_listing_jobs_details', $jobs_info_output);
                                            if ($cs_job_posted_date != '') {
                                                $jobs_info_output .= '<li>';
                                                $jobs_info_output .= '<i class="icon-calendar5"></i>';
                                                $jobs_info_output .= esc_html__('Post Date:', 'jobhunt') . '  <span>' . date_i18n(get_option('date_format'), $cs_job_posted_date) . '</span>';
                                                $jobs_info_output .= '</li>';
                                            }
                                            // Application closing date frontend filter in application deadline add on
                                            $jobs_info_output .= apply_filters('job_hunt_application_deadline_date_frontend', $current_post_ids);
                                            $display_num_app_views_button = 'yes';
                                            $display_num_app_views_button = apply_filters('jobhunt_vaavio_application_views_job_ui', $display_num_app_views_button);
                                            $harry_active = false;
                                            $harry_active = apply_filters('wp_jobhunt_harry_plugin_active', $harry_active);
                                            if ( $display_num_app_views_button == 'yes' && ! $harry_active ) {
                                                $jobs_info_output .= '<li>';
                                                $jobs_info_output .= '<i class="icon-text"></i>';
                                                $jobs_info_output .= esc_html__('Applications', 'jobhunt') . ' <span>' . esc_html($applications) . '</span>';
                                                $jobs_info_output .= '</li>';

                                                $jobs_info_output .= '<li>';
                                                $jobs_info_output .= '<i class="icon-eye7"></i>';
                                                $jobs_info_output .= esc_html__('Views', 'jobhunt') . '<span> ' . esc_attr($cs_count_views) . '</span>';
                                                $jobs_info_output .= '</li>';
                                            }
                                            $jobs_info_output .= '</ul>';
                                            $jobs_info_output .= '</div>';
                                            //  social media section
                                            if ( cs_social_share(0) ) {
                                                $jobs_info_output .= '<div class="social-media">';
                                                $jobs_info_output .= '<span>' . esc_html__('Share', 'jobhunt') . '</span>';
                                                $jobs_info_output .= cs_social_share(false);
                                                $jobs_info_output .= '</div>';
                                            }
                                            $jobhunt_featured = apply_filters('jobhunt_featured_job', '', $job_post->ID);
                                            $jobs_info_output .= force_balance_tags($jobhunt_featured);
                                            $jobs_info_output .= '</div>';
                                            echo apply_filters('_3_columns_job_info', $jobs_info_output, $current_post_ids);
                                            ?>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="page-section">
                    <div class="<?php if ( isset($cs_plugin_options['cs_plugin_single_container']) && $cs_plugin_options['cs_plugin_single_container'] == 'on' ) echo 'container' ?>">
                        <div class="row">
                            <div class="section-content col-lg-8 col-md-8 col-sm-12 col-xs-12">
                                <div class="row">
                                    <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12 col-xs-12">
                                        <div class="rich-editor-text">
                                            <h6><?php esc_html_e('Job Overview', 'jobhunt'); ?></h6>
                                            <?php
                                            wp_reset_query();
                                            $post_job = get_post(get_the_ID());
                                           echo apply_filters('the_content', $post_job->post_content);
                                            //the_content();
                                            wp_link_pages(array(
                                                'before' => '<div class="page-content-links"><strong class="page-links-title">' . esc_html__('Pages:', 'jobhunt') . '</strong>',
                                                'after' => '</div>',
                                                'link_before' => '<span>',
                                                'link_after' => '</span>',
                                                'pagelink' => '%',
                                                'separator' => '',
                                            ));
                                            $empty_string = '';
                                            echo apply_filters('view_more', $empty_string, $current_post_ids);
                                            ?>
                                        </div>
                                        <?php do_action('jobhunt_job_attachment_frontend_ui', $current_post_ids); ?>
                                    </div>
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="jobs-detail-listing">
                                            <h6><?php esc_html_e('Job Detail', 'jobhunt'); ?></h6>
                                            <ul class="row">
                                                <?php
                                                $cs_job_cus_fields = get_option("cs_job_cus_fields");
                                                if ( is_array($cs_job_cus_fields) && sizeof($cs_job_cus_fields) > 0 ) {
                                                    $custom_field_box = 1;
                                                    foreach ( $cs_job_cus_fields as $cus_field ) {
                                                        if ( $cus_field['meta_key'] != '' ) {
                                                            $data = get_post_meta($job_post->ID, $cus_field['meta_key'], true);
                                                            // empty check of value
                                                            if ( $cus_field['label'] != '' )
                                                                if ( $data != "" ) {
                                                                    ?> <li class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                                        <div class="listing-inner">
                                                                            <i class="<?php echo sanitize_html_class($cus_field['fontawsome_icon']) ?>"></i>
                                                                            <div class="cs-text">
                                                                                <span>    <?php echo esc_html($cus_field['label']); ?></span><strong><?php
                                                                                    // check the data is array or not
                                                                                    if ( is_array($data) ) {
                                                                                        $data_flage = 1;
                                                                                        $comma = '';
                                                                                        foreach ( $data as $datavalue ) {
                                                                                            if ( $cus_field['type'] == 'dropdown' ) {
                                                                                                $options = $cus_field['options']['value'];
                                                                                                if ( isset($options) ) {
                                                                                                    $finded_array = array_search($datavalue, $options);
                                                                                                    $datavalue = isset($finded_array) ? $cus_field['options']['label'][$finded_array] : '';
                                                                                                }
                                                                                                echo $comma . esc_html($datavalue);
                                                                                                $comma = ', ';
                                                                                            } else {
                                                                                                echo esc_html($datavalue);
                                                                                            }
                                                                                            if ( $data_flage != count($data) ) {
                                                                                                echo "";
                                                                                            }
                                                                                            $data_flage ++;
                                                                                        }
                                                                                    } else {
                                                                                        if ( $cus_field['type'] == 'dropdown' ) {
                                                                                            $options = $cus_field['options']['value'];
                                                                                            if ( isset($options) ) {
                                                                                                $finded_array = array_search($data, $options);
                                                                                                $data = isset($finded_array) ? $cus_field['options']['label'][$finded_array] : '';
                                                                                            }
                                                                                            echo esc_html($data);
                                                                                        } else if ( $cus_field['type'] == 'url' ) {
                                                                                            echo '<a class="no-transform" href="'. esc_url($data) .'" target="_blank">'. esc_url($data) .'</a>';
                                                                                        }else{
                                                                                            echo esc_html($data);
                                                                                        }
                                                                                    }
                                                                                    ?></strong>
                                                                            </div>
                                                                        </div></li><?php
                                                                    if ( ($custom_field_box % 3 == 0 && $custom_field_box > 0) && count($cs_job_cus_fields) != $custom_field_box )
                                                                        $custom_field_box ++;
                                                                }
                                                        }
                                                    }
                                                    if ( $custom_field_box % 3 != 0 && $custom_field_box > 0 )
                                                        echo "";
                                                }
                                                ?>
                                                <li class="col-lg-12 col-md-12 col-sm-12">
                                                    <div class="listing-inner"></div>
                                                </li>
                                            </ul>
                                        </div>
                        <?php
                        if (current_user_can('administrator')) { 
                        ?>
                            <div class="apply-buttons">
                                <h3><?php esc_html_e('Select a Candidate', 'jobhunt'); ?></h3>
                                
                                <button id="showCandidatesBtn" class="btn-show-candidates">
                                    <?php esc_html_e('Show Candidates', 'jobhunt'); ?>
                                </button>
                        
                                <div id="candidateForm" class="candidate-form">
                                    <button id="closeCandidatesBtn" class="btn-close">
                                        <i class="fas fa-times"></i> 
                                    </button>
                        
                                    <form method="post" action="">
                                        <div class="candidate-list">
                                            <?php
                                            $args = array(
                                                'role'    => 'cs_candidate',
                                                'orderby' => 'user_nicename',
                                                'order'   => 'ASC'
                                            );
                                            $users = get_users($args);
                        
                                            foreach ($users as $candidate) {
                                                $specialism = get_user_meta($candidate->ID, 'cs_specialisms', true);
                                                if (is_array($specialism)) {
                                                    $specialism = implode(', ', $specialism);
                                                } else {
                                                    $specialism = $specialism ? $specialism : 'N/A';
                                                }
                                                $email = $candidate->user_email;
                                                ?>
                                                <div class="candidate-card">
                                                    <h4><?php echo esc_html($candidate->display_name); ?></h4>
                                                    <p><strong>Specialism:</strong> <?php echo esc_html($specialism); ?></p>
                                                    <p><strong>Email:</strong> <a href="mailto:<?php echo esc_attr($email); ?>"><?php echo esc_html($email); ?></a></p>
                                                    <input type="radio" name="selected_candidate" value="<?php echo esc_attr($candidate->ID); ?>">
                                                </div>
                                                <?php
                                            }
                                            ?>
                                        </div>
                        
                                        <div class="submit-container">
                                            <button type="submit" name="apply_for_candidate" class="btn-submit">
                                                <i class="icon-briefcase4"></i> <?php esc_html_e('Submit Application', 'jobhunt'); ?>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        
<?php
if (is_admin()) {
    if (isset($_POST['apply_for_candidate']) && !empty($_POST['selected_candidate'])) {
        $selected_candidate = intval($_POST['selected_candidate']);
        $applied_jobs = get_user_meta($selected_candidate, 'cs-user-jobs-applied-list', true);

        if (!is_array($applied_jobs)) {
            $applied_jobs = array();
        }

        $already_applied = false;
        foreach ($applied_jobs as $applied_job) {
            if (isset($applied_job['post_id']) && $applied_job['post_id'] == $current_post_id) {
                $already_applied = true;
                break;
            }
        }

        if (!$already_applied) {
            $applied_jobs[] = array(
                'post_id' => $current_post_id,
                'date' => current_time('mysql'),
            );

            update_user_meta($selected_candidate, 'cs-user-jobs-applied-list', $applied_jobs);
            if (!update_user_meta($selected_candidate, 'cs-user-jobs-applied-list', $applied_jobs)) {
    echo '<p style="color:red;">Failed to save application data.</p>';
}
            echo '<p>' . esc_html__('Candidate has been successfully applied for this job.', 'jobhunt') . '</p>';
        } else {
            echo '<p>' . esc_html__('Candidate already applied for this job.', 'jobhunt') . '</p>';
        }
    }
} else {
    echo '<p>' . esc_html__('Only admins can submit applications.', 'jobhunt') . '</p>';
}}
?>
                        
                        <style>
                        .candidate-form {
                            display: none;
                            background: #fff;
                            padding: 20px;
                            border-radius: 8px;
                            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
                            position: relative;
                            margin-top: 15px;
                            text-align: center; 
                        }
                        
                        .btn-show-candidates {
                            background-color: #7CB4C4;
                            color: white;
                            padding: 10px 20px;
                            cursor: pointer;
                            border-radius: 5px;
                            text-align: center;
                            display: inline-block;
                            border: none;
                        }
                        
                        .btn-close {
                            background: transparent;
                            color: #ff0000;
                            border: none;
                            font-size: 20px;
                            cursor: pointer;
                            position: absolute;
                            top: 10px;
                            right: 10px;
                        }
                        
                        .btn-close i {
                            font-size: 24px;
                        }
                        
                        .submit-container {
                            text-align: center;
                            margin-top: 20px;
                        }
                        
                        .btn-submit {
                            background-color: #7CB4C4; /
                            color: white;
                            padding: 10px 25px;
                            border: none;
                            border-radius: 5px;
                            cursor: pointer;
                            font-size: 16px;
                        }
                        
                        .btn-submit:hover {
                            background-color: #fff;
                        }
                        
                        .candidate-list {
                            display: flex;
                            flex-wrap: wrap;
                            gap: 15px;
                            justify-content: center; 
                        }
                        
                        .candidate-card {
                            border: 1px solid #ddd;
                            padding: 15px;
                            border-radius: 8px;
                            background: #f9f9f9;
                            width: 250px;
                            text-align: center;
                        }
                        
                        .candidate-card h4 {
                            margin: 0 0 10px;
                        }
                        
                        .candidate-card p {
                            margin: 5px 0;
                        }
                        
                        .candidate-card input {
                            margin-top: 10px;
                        }
                        </style>
                        
                        <script>
                        document.addEventListener("DOMContentLoaded", function() {
                            var showBtn = document.getElementById("showCandidatesBtn");
                            var closeBtn = document.getElementById("closeCandidatesBtn");
                            var form = document.getElementById("candidateForm");
                        
                            showBtn.addEventListener("click", function() {
                                form.style.display = "block"; 
                            });
                        
                            closeBtn.addEventListener("click", function() {
                                form.style.display = "none"; 
                            });
                        });
                        </script>
                        
                        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

                                    </div>
                                </div>
                                <div class="cs-content-holder">
                                    <section class="cs-featured-jobs list">
                                        <div class="featured-holder">
                                            <?php
                                            ob_start();
                                            $filter_arr2[] = '';
                                            // specilisim filter for all jobs
                                            $specialisms = '';
                                            if ( $specialisms_values != '' )
                                                $specialisms = explode(",", $specialisms_values);
                                            if ( $specialisms != '' && $specialisms != 'All specialisms' ) {
                                                $filter_multi_spec_arr = ['relation' => 'OR', ];
                                                foreach ( $specialisms as $specialisms_key ) {
                                                    if ( $specialisms_key != '' ) {
                                                        $filter_multi_spec_arr[] = array(
                                                            'taxonomy' => 'specialisms',
                                                            'field' => 'slug',
                                                            'terms' => array( $specialisms_key )
                                                        );
                                                    }
                                                }
                                                $filter_arr2[] = array(
                                                    $filter_multi_spec_arr
                                                );
                                            }
                                            $featured_job_mypost = array( 'posts_per_page' => "10", 'post_type' => 'jobs', 'order' => "DESC", 'orderby' => 'post_date',
                                                'post_status' => 'publish', 'ignore_sticky_posts' => 1,
                                                'post__not_in' => array( $job_post->ID ),
                                                'tax_query' => array(
                                                    'relation' => 'AND',
                                                    $filter_arr2
                                                ),
                                                'meta_query' => array(
                                                    array(
                                                        'key' => 'cs_job_posted',
                                                        'value' => current_time('timestamp'),
                                                        'compare' => '<=',
                                                    ),
                                                    array(
                                                        'key' => 'cs_job_expired',
                                                        'value' => current_time('timestamp'),
                                                        'compare' => '>=',
                                                    ),
                                                    array(
                                                        'key' => 'cs_job_status',
                                                        'value' => 'active',
                                                        'compare' => '=',
                                                    ),
                                                )
                                            );
                                            // Exclude expired jobs from listing
                                            $featured_job_mypost = apply_filters('job_hunt_jobs_listing_parameters', $featured_job_mypost);
                                            $featured_job_loop_count = new WP_Query($featured_job_mypost);
                                            $featuredjob_count_post = $featured_job_loop_count->found_posts;
                                            if ( $featuredjob_count_post > 0 ) {
                                                ?>
                                                <h4><?php esc_html_e('Related Jobs', 'jobhunt') ?> (<?php echo ( $featuredjob_count_post ); ?>) </h4>
                                                <ul class="cs-company-jobs">
                                                    <?php
                                                    // getting if record not found
                                                    $cs_search_result_page = isset($cs_plugin_options['cs_search_result_page']) ? $cs_plugin_options['cs_search_result_page'] : '';
                                                    $flag = 1;
                                                    while ( $featured_job_loop_count->have_posts() ) : $featured_job_loop_count->the_post();
                                                        global $post;
                                                        $cs_job_posted = get_post_meta($post->ID, 'cs_job_posted', true);
                                                        $cs_job_employer = get_post_meta($post->ID, "cs_job_username", true); //
                                                        $cs_job_employer = cs_get_user_id_by_login($cs_job_employer);
                                                        $cs_jobs_thumb_url = get_the_author_meta('user_img', $cs_job_employer);
                                                        $cs_jobs_address = get_user_address_string_for_list($post->ID);
                                                        if ( ! cs_image_exist($cs_jobs_thumb_url) || $cs_jobs_thumb_url == "" ) {
                                                            $cs_jobs_thumb_url = esc_url(wp_jobhunt::plugin_url() . 'assets/images/img-not-found4x3.jpg');
                                                        }
                                                        $all_job_type = get_the_terms($post->ID, 'job_type');
//                                                        
                                                        $job_type_values = '';
                                                        $job_type_class = '';
                                                        $job_type_flag = 1;
                                                        if ( $all_job_type != '' ) {
                                                            foreach ( $all_job_type as $job_type ) {
                                                                $t_id_main = $job_type->term_id;
                                                                //$job_type_color_arr = get_option("job_type_color_$t_id_main");
								$job_type_color_arr = get_term_meta($job_type->term_id, 'jobtype_meta_data', true);
                                                                $job_type_color = '';
                                                                if ( isset($job_type_color_arr['text']) ) {
                                                                    $job_type_color = $job_type_color_arr['text'];
                                                                }
                                                                $cs_link = ' href="javascript:void(0);"';
                                                                if ( $cs_search_result_page != '' ) {
                                                                    $cs_link = ' href="' . esc_url_raw(get_page_link($cs_search_result_page) . '?job_type=' . $job_type->slug) . '"';
                                                                }
                                                                $job_type_values .= '<a ' . force_balance_tags($cs_link) . ' class="categories" style="color:' . $job_type_color . '">' . $job_type->name . '</a>';

                                                                if ( $job_type_flag != count($all_job_type) ) {
                                                                    $job_type_values .= " ";
                                                                    $job_type_class .= " ";
                                                                }
                                                                $job_type_flag ++;
                                                            }
                                                        }
                                                        ?>
                                                        <li>
                                                            <div class="cs-text">
                                                                <span><a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php echo the_title(); ?></a></span>
                                                                <?php
                                                                esc_html_e(' on', 'jobhunt');
                                                                if ( isset($cs_job_posted) && $cs_job_posted != '' ) {
                                                                    ?>
                                                                    <span class="post-date"><?php echo date_i18n(get_option('date_format'), $cs_job_posted) ?></span>
                                                                <?php }echo force_balance_tags($job_type_values);
                                                                ?>
                                                            </div>
                                                        </li>

                                                        <?php
                                                        $flag ++;
                                                    endwhile;
                                                    wp_reset_postdata();
                                                    ?>
                                                </ul>
                                            <?php } ?>
                                            <?php
                                            $related_jobs_output = ob_get_clean();
                                            echo apply_filters('related_jobs', $related_jobs_output, $current_post_ids);
                                            ?>
                                        </div>
                                    </section>
                                </div>

                            </div>
                            <div class="section-sidebar col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <?php 
                                /*
                                ob_start(); ?>
                                <?php
                                $employer_contact_form = 'on';
                                $employer_contact_form = apply_filters('jobhunt_employer_contact_form', $employer_contact_form);
                                $display_employer_contact_form = 'yes';
                                $display_employer_contact_form = apply_filters('jobhunt_employer_contact_form_display', $display_employer_contact_form);
                                $display_employer_contact_from_job_detail = 'yes';
                                $display_employer_contact_from_job_detail = apply_filters('jobhunt_employer_contact_from_job_detail', $display_employer_contact_from_job_detail, $current_post_ids);
                                $cs_job_detail_contact_form = isset($cs_plugin_options['cs_job_detail_contact_form']) ? $cs_plugin_options['cs_job_detail_contact_form'] : '';
                                ?>
                                <?php
                                if ( isset($cs_job_detail_contact_form) && $cs_job_detail_contact_form == 'on' ) {
                                    if ( $employer_contact_form == 'on' && ( $display_employer_contact_form == 'yes' && $display_employer_contact_from_job_detail == 'yes' ) ) {
                                        ?>
                                        <div class="employer-contact-form">
                                            <?php
                                            $cs_sitekey = isset($cs_plugin_options['cs_sitekey']) ? $cs_plugin_options['cs_sitekey'] : '';
                                            $cs_secretkey = isset($cs_plugin_options['cs_secretkey']) ? $cs_plugin_options['cs_secretkey'] : '';
                                            cs_google_recaptcha_scripts();
                                            ?>
                                            <script>
                                                var recaptcha8;
                                                var cs_multicap = function () {
                                                    //Render the recaptcha1 on the element with ID "recaptcha1"
                                                    recaptcha8 = grecaptcha.render('recaptcha8', {
                                                        'sitekey': '<?php echo ($cs_sitekey); ?>', //Replace this with your Site key
                                                        'theme': 'light'
                                                    });
                                                };
                                            </script>
                                            <h5><?php
                                                esc_html_e('Contact', 'jobhunt');
                                                $cs_terms_condition = isset($cs_plugin_options['cs_terms_condition']) ? $cs_plugin_options['cs_terms_condition'] : '';
                                                $required = '';
                                                $required = apply_filters('jobhunt_harry_required_class', $required);
                                                ?></h5>
                                            <div class="cs-profile-contact-detail" data-adminurl="<?php echo esc_url(admin_url('admin-ajax.php')); ?>" data-cap="recaptcha7">
                                                <form id="ajaxcontactemployer" action="#" method="post" enctype="multipart/form-data">
                                                    <div id="ajaxcontact-response" class=""></div>
                                                    <div class="input-filed"> <i class="icon-user9"></i>
                                                        <?php
                                                        $cs_opt_array = array(
                                                            'id' => '',
                                                            'std' => isset($login_user_name) ? esc_html($login_user_name) : '',
                                                            'cust_id' => "ajaxcontactname",
                                                            'cust_name' => "ajaxcontactname",
                                                            'classes' => 'form-control' . $required . '',
                                                            'extra_atr' => 'placeholder="' . esc_html__('Enter your Name', 'jobhunt') . '*"',
                                                            'required' => 'yes',
                                                        );
                                                        $cs_form_fields2->cs_form_text_render($cs_opt_array);
                                                        ?>
                                                    </div>
                                                    <div class="input-filed"> <i class="icon-envelope4"></i>
                                                        <?php
                                                        $cs_opt_array = array(
                                                            'id' => '',
                                                            'std' => isset($login_user_email) ? esc_html($login_user_email) : '',
                                                            'cust_id' => "ajaxcontactemail",
                                                            'cust_name' => "ajaxcontactemail",
                                                            'classes' => 'form-control',
                                                            'extra_atr' => 'placeholder="' . esc_html__('Email Address', 'jobhunt') . '*"',
                                                            'required' => 'yes',
                                                        );
                                                        $cs_form_fields2->cs_form_text_render($cs_opt_array);
                                                        ?>
                                                    </div>
                                                    <div class="input-filed"> <i class="icon-mobile4"></i>
                                                        <?php
                                                        $cs_opt_array = array(
                                                            'id' => '',
                                                            'std' => isset($login_user_phone) ? esc_html($login_user_phone) : '',
                                                            'cust_id' => "ajaxcontactphone",
                                                            'cust_name' => "ajaxcontactphone",
                                                            'classes' => 'form-control',
                                                            'extra_atr' => 'placeholder="' . esc_html__('Phone Number', 'jobhunt') . '"',
                                                        );
                                                        $cs_form_fields2->cs_form_text_render($cs_opt_array);
                                                        ?>
                                                    </div>
                                                    <div class="input-filed">
                                                        <?php
                                                        $cs_opt_array = array(
                                                            'id' => '',
                                                            'std' => '',
                                                            'cust_id' => "ajaxcontactcontents",
                                                            'cust_name' => "ajaxcontactcontents",
                                                            'classes' => 'form-control',
                                                            'extra_atr' => 'placeholder="' . esc_html__('Message should have more than 50 characters', 'jobhunt') . '"',
                                                        );
                                                        $cs_form_fields2->cs_form_textarea_render($cs_opt_array);
                                                        ?>
                                                    </div>
                                                    <?php
                                                    $cs_terms_policy_switch = isset($cs_plugin_options['cs_terms_policy_switch']) ? $cs_plugin_options['cs_terms_policy_switch'] : '';
                                                    $cs_terms_condition     = isset($cs_plugin_options['jobhunt_emp_term_page'])  ? $cs_plugin_options['jobhunt_emp_term_page']  : '';
                                                    if ( $cs_terms_policy_switch == 'on' && $cs_terms_condition != '' ) {
                                                        ?>
                                                        <div class="term-conditions input-filed">
                                                            <div class="terms">
                                                                <label><input type="checkbox" name="cs_contact_terms" id="cs_contact_terms" value="on">
                                                                    <?php esc_html_e('You accepts our', 'jobhunt') ?>
                                                                    <a target="_blank" href="<?php echo esc_url(get_permalink($cs_terms_condition)) ?>"> <?php esc_html_e('Terms and Conditions', 'jobhunt') ?></a>
                                                                </label>
                                                            </div>
                                                        </div>
                                                        <?php
                                                    }
                                                    ?>
                                                    <?php
                                                    if (isset($employer_post) && $employer_post != '') {
                                                        do_action('jobhunt_harry_form_fields', $employer_post->ID);
                                                    }
                                                    global $cs_plugin_options;
                                                    $cs_captcha_switch = isset($cs_plugin_options['cs_captcha_switch']) ? $cs_plugin_options['cs_captcha_switch'] : '';
                                                    if ( $cs_captcha_switch == 'on' ) {
                                                        echo '<div class="input-holder recaptcha-reload" id="recaptcha8_div">';
                                                        echo cs_captcha('recaptcha8');
                                                        echo '</div>';
                                                    }
                                                    ?>
                                                    <div class="submit-btn profile-contact-btn" data-employerid="<?php echo isset($employer_post->ID) ? esc_html($employer_post->ID) : ''; ?>">
                                                        <?php
                                                        $cs_opt_array = array(
                                                            'id' => '',
                                                            'std' => esc_html__('Send Email', 'jobhunt'),
                                                            'cust_id' => "employerid_contactus",
                                                            'cust_name' => "employerid_contactus",
                                                            'cust_type' => 'button',
                                                        );
                                                        $cs_opt_array = apply_filters('jobhunt_employer_contact_form_btn', $cs_opt_array);
                                                        $cs_form_fields2->cs_form_text_render($cs_opt_array);
                                                        $cs_opt_array = array(
                                                            'std' => 'cs_registration_validation',
                                                            'cust_id' => 'action',
                                                            'cust_name' => 'action',
                                                            'cust_type' => 'hidden',
                                                            'return' => true,
                                                        );
                                                        $cs_form_fields2->cs_form_text_render($cs_opt_array);
                                                        ?>
                                                        <div id="main-cs-loader" class="loader_class"></div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <?php
                                    }
                                }
                                $contact_form_output = ob_get_clean();
                                echo apply_filters('contact_form', $contact_form_output, $current_post_ids);
                                */
                                ?>
                                <?php
                                $cs_plugin_options = get_option('cs_plugin_options');
                                $cs_safetysafe_switch = $cs_plugin_options['cs_safetysafe_switch'];
                                if ( $cs_safetysafe_switch != '' && $cs_safetysafe_switch == 'on' ) {
                                    ?>
                                    <div class="safety-save">
                                        <div class="warning-title ">
                                            <h4 class="cs-color"><i class="icon-warning4"></i><?php esc_html_e('Safety Information', 'jobhunt') ?></h4>
                                        </div>
                                        <div class="cs-text">
                                            <ul class="save-info">
                                                <?php
                                                $cs_safety_title_array = isset($cs_plugin_options['cs_safety_title_array']) ? $cs_plugin_options['cs_safety_title_array'] : '';
                                                $cs_safety_desc_array = isset($cs_plugin_options['cs_safety_desc_array']) ? $cs_plugin_options['cs_safety_desc_array'] : '';
                                                if ( is_array($cs_safety_desc_array) && sizeof($cs_safety_desc_array) > 0 ) {
                                                    $cs_safety_count = 0;
                                                    foreach ( $cs_safety_desc_array as $cs_safety_desc ) {
                                                        ?>
                                                        <li>
                                                            <h3><?php echo esc_html($cs_safety_title_array[$cs_safety_count]); ?></h3>
                                                            <p><?php echo esc_html($cs_safety_desc); ?></p>
                                                        </li>
                                                        <?php
                                                        $cs_safety_count ++;
                                                    }
                                                } else {
                                                    ?>
                                                    <li>
                                                        <p><?php esc_html_e('There is no record found', 'jobhunt') ?></p>
                                                    </li>
                                                    <?php
                                                }
                                                ?>
                                            </ul>
                                        </div>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div> 
                <?php
            endwhile;
        endif;
    } else {
        ?>
        <div class="main-section">
            <div class="<?php if ( isset($cs_plugin_options['cs_plugin_single_container']) && $cs_plugin_options['cs_plugin_single_container'] == 'on' ) echo 'container' ?>">
                <div class="row">
                    <div class="col-lg-12 col-sm-12 col-md-12 col-xs-12">
                        <div class="unauthorized">
                            <h1>
                                <?php _e('You are not <span>authorized</span>', 'jobhunt') ?>
                            </h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
    ?>
</div>