<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('class_jobhunt_jobs_export')) {

    class class_jobhunt_jobs_export {

        /**
         * class_jobhunt_jobs_export constructor.
         */
        function __construct() {
            add_action('wp_ajax_jobs_export_download', array($this, 'jobs_export_download_callback'));
            add_filter('jobhunt_jobs_fields', array($this, 'jobhunt_jobs_fields_callback'));
        }

        public function jobhunt_jobs_fields_callback($fields_array) {
            $fields_array = array(
                'job_username' => esc_html__('User Name', 'jobhunt-jobs-importer'),
                'job_posted' => esc_html__('Job Posted Date', 'jobhunt-jobs-importer'),
                'job_expired' => esc_html__('Job Expiry', 'jobhunt-jobs-importer'),
                'application_closing_date' => esc_html__('Application Close Date', 'jobhunt-jobs-importer'),
                'job_featured' => esc_html__('Job Featured', 'jobhunt-jobs-importer'),
                'job_status' => esc_html__('Job Status', 'jobhunt-jobs-importer'),
                'job_style' => esc_html__('Job Style', 'jobhunt-jobs-importer'),
                'job_package' => esc_html__('Job Package', 'jobhunt-jobs-importer'),
                'external_url_id' => esc_html__('External URL', 'jobhunt-jobs-importer'),
                'post_loc_country' => esc_html__('Country', 'jobhunt-jobs-importer'),
                'post_loc_city' => esc_html__('City', 'jobhunt-jobs-importer'),
                'post_comp_address' => esc_html__('Address', 'jobhunt-jobs-importer'),
                'user_img' => esc_html__('User Image', 'jobhunt-jobs-importer'),
                'cover_user_img' => esc_html__('User Cover Image', 'jobhunt-jobs-importer'),
                'phone_number' => esc_html__('Phone Number', 'jobhunt-jobs-importer'),
                'user_status' => esc_html__('User Status', 'jobhunt-jobs-importer'),
            );

            $jobs_custom_fields = get_option('cs_job_cus_fields');
            if (!empty($jobs_custom_fields)) {
                foreach ($jobs_custom_fields as $job_field_id => $job_field_data) {
                    $label = isset($job_field_data['label']) ? $job_field_data['label'] : '';
                    $meta_key = isset($job_field_data['meta_key']) ? $job_field_data['meta_key'] : '';
                    $fields_array[$meta_key] = $label;
                }
            }
            return $fields_array;
        }

        public function jobs_export_download_callback() {

            $jobs_fields = array(
                'job_id',
                'job_username',
                'job_posted',
                'job_expired',
                'application_closing_date',
                'job_featured',
                'job_status',
                'job_style',
                'job_package',
                'trans_id',
                'external_url_id',
                'post_loc_country',
                'post_loc_city',
                'post_comp_address',
            );

            $user_fields = array(
                'user_img',
                'cover_user_img',
                'phone_number',
                'user_status',
                'allow_search',
            );

            $jobs_postqry = array('posts_per_page' => "-1", 'post_type' => 'jobs',
                'post_status' => 'publish',
                'fields' => 'ids',
            );


            $jobsData = new WP_Query($jobs_postqry);
            $jobsData = isset($jobsData->posts) ? $jobsData->posts : array();

            if (!empty($jobsData)) {
                $xmlObj = new SimpleXMLElement('<xml/>');
                foreach ($jobsData as $job_id) {

                    $job_data = get_post($job_id);
                    $user_name = get_post_meta($job_id, 'cs_job_username', true);
                    $jobs_custom_fields = get_option('cs_job_cus_fields');
                    if (is_numeric($user_name)) {
                        $userData = $user = get_user_by('ID', $user_name);
                    } else {
                        $userData = $user = get_user_by('login', $user_name);
                    }
                    $userData = isset($userData->data) ? $userData->data : (object) array();
                    $user_nicename = isset($userData->user_nicename) ? $userData->user_nicename : '';
                    $userID = isset($userData->ID) ? $userData->ID : 0;
                    $user_description = get_user_meta($userID, 'description', true);
                    $user_img = get_user_meta($userID, 'user_img', true);
                    $cover_user_img = get_user_meta($userID, 'cover_user_img', true);

                    $first_name = get_user_meta($userID, 'first_name', true);
                    $last_name = get_user_meta($userID, 'last_name', true);

                    $user_img = cs_get_img_url($user_img, 'cs_media_5');
                    $cover_user_img = cs_get_img_url($cover_user_img, 'cs_media_5');

                    $jobXMLObj = $xmlObj->addChild('jobData');
                    $jobXMLObj->addChild('jobTitle', get_the_title($job_id));
                    $jobXMLObj->addChild('jobSlug', $job_data->post_name);
                    //$jobXMLObj->addChild('jobContent', html_entity_decode($job_data->post_content));
                    $jobXMLObj->addChild('jobContent', htmlspecialchars($job_data->post_content));
                    $jobXMLObj->addChild('jobDate', $job_data->post_date);

                    if (!empty($jobs_fields)) {
                        foreach ($jobs_fields as $jobs_field_key) {
                            $jobs_field_value = get_post_meta($job_id, 'cs_' . $jobs_field_key, true);
                            if ($jobs_field_value != '') {
                                $jobXMLObj->addChild($jobs_field_key, $jobs_field_value);
                            }
                        }
                    }

                    if (!empty($jobs_custom_fields)) {
                        $jobCustomFieldsXMLObj = $jobXMLObj->addChild('jobCustomFields');
                        foreach ($jobs_custom_fields as $job_field_id => $job_field_data) {
                            $meta_key = isset($job_field_data['meta_key']) ? $job_field_data['meta_key'] : '';
                            $meta_value = get_post_meta($job_id, $meta_key, true);
                            $meta_value = is_array($meta_value) ? json_encode($meta_value) : $meta_value;
                            if ($meta_value != '') {
                                $jobCustomFieldsXMLObj->addChild($meta_key, $meta_value);
                            }
                        }
                    }

                    $jobUserXMLObj = $jobXMLObj->addChild('employerData');

                    if ($first_name != '') {
                        $jobUserXMLObj->addChild('first_name', $first_name);
                    }
                    if ($last_name != '') {
                        $jobUserXMLObj->addChild('last_name', $last_name);
                    }

                    if ($user_nicename != '') {
                        $jobUserXMLObj->addChild('user_nicename', $user_nicename);
                    }
                    if ($userData->user_login != '') {
                        $jobUserXMLObj->addChild('userName', $userData->user_login);
                    }
                    if ($userData->user_email != '') {
                        $jobUserXMLObj->addChild('user_email', $userData->user_email);
                    }
                    if ($user_description != '') {
                        $jobUserXMLObj->addChild('description', $user_description);
                    }

                    if ($user_img != '') {
                        $jobUserXMLObj->addChild('user_img', $user_img);
                    }
                    if ($cover_user_img != '') {
                        $jobUserXMLObj->addChild('cover_user_img', $cover_user_img);
                    }

                    if (!empty($user_fields)) {
                        foreach ($user_fields as $user_field_key) {
                            $user_field_value = get_user_meta($userID, 'cs_' . $user_field_key, true);
                            if ($user_field_value != '') {
                                $jobUserXMLObj->addChild($user_field_key, $user_field_value);
                            }
                        }
                    }

                    $specialisms = get_the_terms($job_id, 'specialisms');
                    $jobTypeTerms = get_the_terms($job_id, 'job_type');
                    if (!empty($specialisms)) {
                        $specialismTermXMLObj = $jobXMLObj->addChild('specialisms-term');
                        foreach ($specialisms as $specialisData) {
                            $specialismTermXMLObj->addChild('Term', $specialisData->name);
                        }
                    }

                    if (!empty($jobTypeTerms)) {
                        $jobTypeTermXMLObj = $jobXMLObj->addChild('job_type-term');
                        foreach ($jobTypeTerms as $jobTypeTermData) {
                            $jobTypeTermXMLObj->addChild('Term', $jobTypeTermData->name);
                        }
                    }
                }
            }

            $random_id = rand(11111, 99999);
            $xml_file_name = 'xml-jobs-exports-' . $random_id . '.xml';
            $xmlObj->asXml(JOBHUNT_JOBS_IMPORTER_CORE_DIR . '/assets/xml-exports/' . $xml_file_name);
            ?>
            <div class="jobhunt-import-export-response">
                <a href="<?php echo JOBHUNT_JOBS_IMPORTER_PLUGIN_URL . '/assets/xml-exports/' . $xml_file_name; ?>" target="_blank"><i class="icon-in"></i><?php echo __('Download XML File', 'jobhunt-jobs-importer'); ?></a>
            </div>
            <?php
            wp_die();
        }

    }

    new class_jobhunt_jobs_export();
}
?>