<?php
/**
 * @Jobs Counter widget Class
 *
 *
 */
if (!class_exists('jobs_stack')) {

    class jobs_stack extends WP_Widget {

        /**
         * Start Function how to create Jobs Counter Module
         *        
         */
        public function __construct() {
            parent::__construct(
                    'jobs_stack', // Base ID
                    esc_html__('CS : Jobs Stack', 'jobhunt'), // Name
                    array('classname' => 'cs-job-counter', 'description' => esc_html__('Enter job stack info ', 'jobhunt'),)
            );
        }

        /**
         * Start Function how to create Jobs Counter html form
         *        
         */
        function form($instance) {
            global $cs_theme_form_fields, $cs_html_fields, $cs_theme_html_fields;
            $instance = wp_parse_args((array) $instance, array('title' => ''));
            $title = $instance['title'];
            $sub_title = isset($instance['sub_title']) ? $instance['sub_title'] : '';
            $image_url = isset($instance['image_url']) ? esc_url($instance['image_url']) : '';
            $bg_img_url = isset($instance['bg_img_url']) ? esc_url($instance['bg_img_url']) : '';
            $store_img_url = isset($instance['store_img_url']) ? esc_attr($instance['store_img_url']) : '';
            $bg_switch = isset($instance['bg_switch']) ? esc_attr($instance['bg_switch']) : '';
            $randomID = rand(135434, 957655);
            $random = rand(1345434, 957345345655);


            $cs_opt_array = array(
                'name' => esc_html__('Enter Title', 'jobhunt'),
                'desc' => '',
                'hint_text' => '',
                'echo' => false,
                'field_params' => array(
                    'std' => esc_attr($title),
                    'id' => '',
                    'classes' => '',
                    'cust_id' => CS_FUNCTIONS()->cs_special_chars($this->get_field_id('title')),
                    'cust_name' => CS_FUNCTIONS()->cs_special_chars($this->get_field_name('title')),
                    'return' => true,
                    'required' => false
                ),
            );
            echo $cs_html_fields->cs_text_field($cs_opt_array);


            $cs_opt_array = array(
                'name' => esc_html__('Enter Content', 'jobhunt'),
                'desc' => '',
                'hint_text' => '',
                'echo' => false,
                'field_params' => array(
                    'std' => esc_attr($sub_title),
                    'id' => '',
                    'classes' => '',
                    'cust_id' => CS_FUNCTIONS()->cs_special_chars($this->get_field_id('sub_title')),
                    'cust_name' => CS_FUNCTIONS()->cs_special_chars($this->get_field_name('sub_title')),
                    'return' => true,
                    'required' => false
                ),
            );
            echo $cs_html_fields->cs_text_field($cs_opt_array);


            $cs_opt_array = array(
                'std' => $image_url,
                'id' => 'form-widget_cs_widget_logo' . absint($randomID),
                'name' => esc_html__('Logo', 'jobhunt'),
                'desc' => '',
                'hint_text' => '',
                'echo' => true,
                'prefix' => '',
                'field_params' => array(
                    'std' => $image_url,
                    'id' => 'form-widget_cs_widget_logo' . absint($randomID),
                    'cust_name' => $this->get_field_name('image_url'),
                    'return' => true,
                    'prefix' => '',
                ),
            );

            $cs_html_fields->cs_upload_file_field($cs_opt_array);


            $cs_opt_array = array(
                'std' => $bg_img_url,
                'id' => 'form-widget_cs_widget_bg_img' . absint($randomID),
                'name' => esc_html__('App Image', 'jobhunt'),
                'desc' => '',
                'hint_text' => '',
                'echo' => true,
                'prefix' => '',
                'field_params' => array(
                    'std' => $bg_img_url,
                    'id' => 'form-widget_cs_widget_bg_img' . absint($randomID),
                    'cust_name' => $this->get_field_name('bg_img_url'),
                    'return' => true,
                    'prefix' => '',
                ),
            );

            $cs_html_fields->cs_upload_file_field($cs_opt_array);

            $cs_opt_array = array(
                'std' => $store_img_url,
                'id' => 'form-widget_cs_widget_store_img_url' . absint($random),
                'name' => esc_html__('App Store', 'jobhunt'),
                'desc' => '',
                'hint_text' => '',
                'echo' => true,
                'prefix' => '',
                'field_params' => array(
                    'std' => $store_img_url,
                    'id' => 'form-widget_cs_widget_store_img_url' . absint($random),
                    'cust_name' => $this->get_field_name('store_img_url'),
                    'return' => true,
                    'prefix' => '',
                ),
            );

            $cs_html_fields->cs_upload_file_field($cs_opt_array);

            $cs_opt_array = array(
                'name' => esc_html__('Backgroud Image', 'jobhunt'),
                'desc' => '',
                'hint_text' => '',
                'echo' => true,
                'field_params' => array(
                    'std' => esc_attr($bg_switch),
                    'id' => '',
                    'classes' => '',
                    'cust_id' => CS_FUNCTIONS()->cs_special_chars($this->get_field_id('bg_switch')),
                    'cust_name' => CS_FUNCTIONS()->cs_special_chars($this->get_field_name('bg_switch')),
                    'return' => true,
                    'options' => array('yes' => esc_html__('Yes', 'jobhunt'), 'no' => esc_html__('No', 'jobhunt')),
                    'required' => false
                ),
            );
            $cs_html_fields->cs_select_field($cs_opt_array);
        }

        function update($new_instance, $old_instance) {
            $instance = $old_instance;
            $instance['title'] = $new_instance['title'];
            $instance['sub_title'] = $new_instance['sub_title'];
            $instance['image_url'] = $new_instance['image_url'];
            $instance['bg_img_url'] = $new_instance['bg_img_url'];
            $instance['bg_switch'] = $new_instance['bg_switch'];

            $instance['store_img_url'] = $new_instance['store_img_url'];
            return $instance;
        }

        /**
         * Start Function how to Display Jobs Counter widget
         *        
         */
        function widget($args, $instance) {
            global $cs_plugin_options;
            extract($args, EXTR_SKIP);
            $title = empty($instance['title']) ? '' : apply_filters('widget_title', $instance['title']);
            $title = htmlspecialchars_decode(stripslashes($title));
            $sub_title = empty($instance['sub_title']) ? ' ' : apply_filters('widget_title', $instance['sub_title']);
            $image_url = empty($instance['image_url']) ? '' : esc_url($instance['image_url']);
            $bg_img_url = empty($instance['bg_img_url']) ? '' : apply_filters('widget_title', $instance['bg_img_url']);
            $store_img_url = empty($instance['store_img_url']) ? '' : apply_filters('widget_title', $instance['store_img_url']);
            $bg_switch = empty($instance['bg_switch']) ? '' : apply_filters('widget_title', $instance['bg_switch']);
            ?>
            <div class="widget widget-text">
                <div class="widgettext jobstack<?php echo ($bg_switch == 'yes' ? ' has-bg' : '') ?>">
                    <?php if ($image_url != '') { ?>
                        <div class="logo">
                            <img src="<?php echo esc_url($image_url); ?>" alt="">
                        </div>
                    <?php } ?>
                    <div class="widget-title"><h5><?php echo esc_html($title); ?></h5></div>
                    <div class="job-inner-text">
                        <p><?php echo esc_html($sub_title); ?></p>
                        <ul>
                            <li><img src="<?php echo esc_url($bg_img_url); ?>" alt=""></li>
                            <li><img src="<?php echo esc_url($store_img_url); ?>" alt=""></li>
                        </ul>
                    </div>
                </div>
            </div>
            <?php
        }

    }

//add_action('widgets_init', create_function('', 'return register_widget("jobs_stack");'));
    add_action('widgets_init', function() {
        return register_widget("jobs_stack");
    });
}
