<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('class_jobhunt_jobs_import')) {

    class class_jobhunt_jobs_import {

        /**
         * class_jobhunt_jobs_import constructor.
         */
        function __construct() {
            add_filter('upload_mimes', array($this, 'jobhunt_upload_mimes_callback'), 1);
            add_action('wp_ajax_jobs_import_xml_file_render', array($this, 'jobs_import_xml_file_render_callback'));
            add_action('wp_ajax_jobs_import_form_submit', array($this, 'jobs_import_form_submit_callback'));
        }

        public function jobs_import_form_submit_callback() {
            $xml_file = isset($_POST['jobhunt_xml_import_file']) ? $_POST['jobhunt_xml_import_file'] : '';
            $jobhunt_jobs_fields = apply_filters('jobhunt_jobs_fields', array());
            $jobhunt_jobs_fields['term_specialisms'] = '';
            $jobhunt_jobs_fields['term_job_type'] = '';
            $terms_array = array();
            $jobs_data = array();
            if ($xml_file != '') {
                $xmlData = simplexml_load_file($xml_file);
                if (!empty($xmlData)) {
                    $job_counter = 1;
                    foreach ($xmlData as $xmlRepeatedKey => $xmlChildData) {
                        if (!empty($jobhunt_jobs_fields)) {

                            foreach ($jobhunt_jobs_fields as $field_key => $field_label) {
                                $xml_required_key = isset($_POST[$field_key]) ? $_POST[$field_key] : '';
                                if (strpos($xml_required_key, '-term') !== false) {
                                    $xml_required_key_label = str_replace('-term', '', $xml_required_key);
                                    $terms_array[$job_counter][$xml_required_key_label] = (array) $xmlChildData->$xml_required_key;
                                } else {
                                    $job_field_value = $this->jobhunt_search_xml_value($xmlChildData, $xml_required_key);
                                    $jobs_data[$job_counter][$field_key] = $job_field_value;
                                }
                            }
                        }

                        $job_counter++;
                    }
                }

                if (!empty($jobs_data)) {
                    foreach ($jobs_data as $job_counter => $jobData) {
                        $termsDataArray = isset($terms_array[$job_counter]) ? $terms_array[$job_counter] : array();
                        $this->jobhunt_import_single_job($jobData, $termsDataArray);
                    }
                }
            }
            ?>
            <div class="jobhunt-import-response-success">
                <span>
                    <i class="icon-check-square-o"></i>
                    <?php echo __('Jobs Successfully Imported', 'jobhunt-jobs-importer'); ?>
                </span>
            </div>
            <?php
            wp_die();
        }

        public function jobhunt_import_single_job($jobData, $termsDataArray) {
            global $wpdb;
            $jobData_filtered = $jobData;
            unset($jobData_filtered['jobTitle']);
            unset($jobData_filtered['jobContent']);
            unset($jobData_filtered['jobSlug']);
            unset($jobData_filtered['cs_job_title']);
            unset($jobData_filtered['display_name']);
            unset($jobData_filtered['user_email']);
            unset($jobData_filtered['cs_phone_number']);
            unset($jobData_filtered['user_img']);
            unset($jobData_filtered['cover_user_img']);

            $user_image = isset($jobData['user_img']) ? $jobData['user_img'] : '';
            $cover_user_img = isset($jobData['cover_user_img']) ? $jobData['cover_user_img'] : '';

            /*
             * Insert User
             */
            $userdata = array(
                'user_login' => isset($jobData['cs_job_username']) ? $jobData['cs_job_username'] : '',
                'user_email' => isset($jobData['user_email']) ? $jobData['user_email'] : '',
                'first_name' => isset($jobData['first_name']) ? $jobData['first_name'] : '',
                'last_name' => isset($jobData['last_name']) ? $jobData['last_name'] : '',
                'display_name' => isset($jobData['display_name']) ? $jobData['display_name'] : '',
                'user_url' => isset($jobData['user_img']) ? $jobData['user_img'] : '',
                'user_pass' => wp_generate_password(),
                'role' => 'cs_employer'
            );

            $user_id = wp_insert_user($userdata);

            if (!isset($user_id->errors)) {

                if ($user_image != '') {
                    $user_image_id = media_sideload_image($user_image, 0, null, 'id');
                    update_user_meta($user_id, 'user_img', $user_image_id);
                }
                if ($cover_user_img != '') {
                    $cover_image_id = media_sideload_image($cover_user_img, 0, null, 'id');
                    update_user_meta($user_id, 'cover_user_img', $cover_image_id);
                }

                $wpdb->update(
                        $wpdb->prefix . 'users', array('user_status' => 1), array('ID' => esc_sql($user_id))
                );
                update_user_meta($user_id, 'cs_user_status', 'active');
                update_user_meta($user_id, 'cs_phone_number', isset($jobData['cs_phone_number']) ? $jobData['cs_phone_number'] : '');
                update_user_meta($user_id, 'cs_post_loc_country', isset($jobData['cs_post_loc_country']) ? $jobData['cs_post_loc_country'] : '');
                update_user_meta($user_id, 'cs_post_loc_city', isset($jobData['cs_post_loc_city']) ? $jobData['cs_post_loc_city'] : '');
                update_user_meta($user_id, 'cs_post_comp_address', isset($jobData['cs_post_comp_address']) ? $jobData['cs_post_comp_address'] : '');
            }


            /*
             * Insert Job
             */
            $cs_job_posted = isset($jobData['cs_job_posted']) ? date('Y-m-d H:i:s', $jobData['cs_job_posted']) : current_time('Y-m-d H:i:s', 1);
            $job_post = array(
                'post_title' => isset($jobData['jobTitle']) ? $jobData['jobTitle'] : '',
                'post_content' => isset($jobData['jobContent']) ? $jobData['jobContent'] : '',
                'post_name' => isset($jobData['jobSlug']) ? $jobData['jobSlug'] : '',
                'post_status' => 'publish',
                'post_type' => 'jobs',
                'post_date' => $cs_job_posted
            );
            $job_id = wp_insert_post($job_post);
            if (!empty($jobData_filtered)) {
                foreach ($jobData_filtered as $job_custom_field_key => $job_custom_field_value) {
                    update_post_meta($job_id, $job_custom_field_key, $job_custom_field_value);
                }
            }

            update_post_meta($job_id, 'cs_array_data', $jobData);

            if (!empty($termsDataArray)) {
                foreach ($termsDataArray as $term_name => $termData) {
                    $termData = isset($termData['Term']) ? $termData['Term'] : array();
                    $termData = is_array($termData) ? $termData : array($termData);
                    $termsIdsArray = array();
                    if (!empty($termData)) {
                        foreach ($termData as $term_slug) {
                            $term = get_term_by('name', $term_slug, $term_name);
                            if (isset($term->term_id)) {
                                $termsIdsArray[] = $term->term_id;
                            }
                        }
                        wp_set_post_terms($job_id, $termsIdsArray, $term_name);
                    }
                }
            }
        }

        public function jobhunt_search_xml_value($xmlChildData, $xml_required_key) {
            $xmlChildData = (array) $xmlChildData;
            foreach ($xmlChildData as $xmlChildData_key => $xmlChildData_value) {
                $return_value = '';
                if (is_object($xmlChildData_value)) {
                    $return_value = $this->jobhunt_search_xml_value($xmlChildData_value, $xml_required_key);
                }
                if ($xmlChildData_key == $xml_required_key) {
                    $return_value = $xmlChildData_value;
                }
                if ($return_value != '') {
                    return $return_value;
                }
            }
        }

        public function jobhunt_upload_mimes_callback($mimes) {
            $mimes['xml'] = 'text/xml';
            return $mimes;
        }

        public function jobs_import_xml_file_render_callback() {
            $uploadedfile = isset($_FILES['jobs_import_file']) ? $_FILES['jobs_import_file'] : array();
            if (!empty($uploadedfile)) {
                $upload_overrides = array('test_form' => false);
                $movefile = wp_handle_upload($uploadedfile, $upload_overrides);
                if ($movefile) {
                    $xmlData = simplexml_load_file($movefile['file']);
                    echo $this->jobhunt_load_xml_data($xmlData, $movefile['file']);
                }
            }
            wp_die();
        }

        public function jobhunt_load_xml_data($xmlData, $xml_file_path) {
            global $cs_html_fields;
            $xmlFieldsArray = array('' => esc_html__('Select XML Item', 'jobhunt-jobs-importer'));
            $response_data = '';
            $terms_array = array('' => esc_html__('Select Term', 'jobhunt-jobs-importer'));
            $jobhunt_jobs_fields = apply_filters('jobhunt_jobs_fields', array());
            if (!empty($xmlData)) {
                foreach ($xmlData as $xmlRepeatedKey => $xmlChildData) {
                    if (!empty($xmlChildData)) {
                        $xmlFieldsArray = $this->jobhunt_get_xml_file_keys($xmlChildData, $xmlFieldsArray);
                    }
                }

                $terms_array = isset($xmlFieldsArray['terms_array']) ? $xmlFieldsArray['terms_array'] : $terms_array;
                if (isset($xmlFieldsArray['terms_array'])) {
                    unset($xmlFieldsArray['terms_array']);
                }

                array_unshift($terms_array, esc_html__('Select Term', 'jobhunt-jobs-importer'));

                ob_start();

                echo '<form id="jobhunt-import-jobs-submit-form" class="jobhunt-import-jobs-submit-form" method="post" action="" enctype="multipart/form-data">';

                if (!empty($jobhunt_jobs_fields)) {
                    foreach ($jobhunt_jobs_fields as $job_field_key => $job_field_label) {
                        $cs_opt_array = array(
                            'name' => $job_field_label,
                            'desc' => '',
                            'hint_text' => '',
                            'echo' => true,
                            'field_params' => array(
                                'std' => '',
                                'cust_id' => $job_field_key,
                                'cust_name' => $job_field_key,
                                'classes' => 'chosen-select-no-single',
                                'options' => $xmlFieldsArray,
                                'return' => true,
                            ),
                        );
                        $cs_html_fields->cs_select_field($cs_opt_array);
                    }
                }

                $cs_opt_array = array(
                    'name' => esc_html__('Specialisms', 'jobhunt-jobs-importer'),
                    'desc' => '',
                    'hint_text' => '',
                    'echo' => true,
                    'field_params' => array(
                        'std' => '',
                        'cust_id' => 'term_specialisms',
                        'cust_name' => 'term_specialisms',
                        'classes' => 'chosen-select-no-single',
                        'options' => $terms_array,
                        'return' => true,
                    ),
                );
                $cs_html_fields->cs_select_field($cs_opt_array);

                $cs_opt_array = array(
                    'name' => esc_html__('Job Type', 'jobhunt-jobs-importer'),
                    'desc' => '',
                    'hint_text' => '',
                    'echo' => true,
                    'field_params' => array(
                        'std' => '',
                        'cust_id' => 'term_job_type',
                        'cust_name' => 'term_job_type',
                        'classes' => 'chosen-select-no-single',
                        'options' => $terms_array,
                        'return' => true,
                    ),
                );
                $cs_html_fields->cs_select_field($cs_opt_array);

                echo '<input type="hidden" name="jobhunt_xml_import_file" id="jobhunt_xml_import_file" value="' . $xml_file_path . '">';
                echo '<div class="form-elements"><div class="col-lg-4 col-md-4 col-sm-12 col-xs-12"><label>&nbsp;</label>
                    </div>
                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                    <input type="submit" value="Submit" class="jobhunt-importer-submit-btn">
				</div>
			</div>
                </form>';
                $response_data = ob_get_clean();
            }

            return $response_data;
        }

        public function jobhunt_get_xml_file_keys($xmlChildData, $xmlFieldsArray) {
            $xmlChildData = (array) $xmlChildData;
            foreach ($xmlChildData as $xmlChildData_key => $xmlChildData_value) {

                if (strpos($xmlChildData_key, '-term') === false) {
                    if (is_object($xmlChildData_value)) {
                        $xmlFieldsArray = $this->jobhunt_get_xml_file_keys($xmlChildData_value, $xmlFieldsArray);
                    } else {
                        $xmlFieldsArray[$xmlChildData_key] = $xmlChildData_key;
                    }
                } else {
                    $xmlFieldsArray['terms_array'][$xmlChildData_key] = str_replace('-term', '', $xmlChildData_key);
                }
            }

            return $xmlFieldsArray;
        }

    }

    new class_jobhunt_jobs_import();
}
?>