<?php

// Direct access not allowed.
if ( ! defined('ABSPATH') ) {
    exit;
}

/**
 * File Type: JobHunt Email
 */
if ( ! class_exists('JobHunt_Email') ) {

    class JobHunt_Email {

        public $email_post_type_name;

        /**
         * Start construct Functions
         */
        public function __construct() {

            $this->email_post_type_name = 'emails';
            add_action('init', array( $this, 'register_post_type_callback' ));
            add_action('add_meta_boxes', array( $this, 'add_metabox_callback' ));
            add_action('wp_ajax_process_emails', array( $this, 'process_emails_callback' ), 99);
            add_action('wp_ajax_nopriv_process_emails', array( $this, 'process_emails_callback' ), 99);
            add_action('jobhunt_process_emails', array( $this, 'jobhunt_process_emails_callback' ), 99,2);
            add_filter('jobhunt_plugin_option_smtp_tab', array( $this, 'create_plugin_option_smtp' ), 10, 1);
            add_filter('jobhunt_smtp_plugin_options', array( $this, 'create_smtp_plugin_options' ), 10, 1);
            add_action('phpmailer_init', array( $this, 'phpmailer_init_callback' ), 10, 1);
            add_action('wp_ajax_send_smtp_mail', array( $this, 'send_smtp_mail_callback' ));
            add_action('jobhunt_send_mail', array( $this, 'send_mail_callback' ), 20, 1);
            add_filter('wp_mail_from_name', array( $this, 'wp_mail_from_name_callback' ), 10, 1);
            
        }
        

        public function register_post_type_callback() {
            $labels = array(
                'name' => _x('Emails', 'post type general name', 'jobhunt'),
                'singular_name' => _x('Email', 'post type singular name', 'jobhunt'),
                'menu_name' => _x('Emails', 'admin menu', 'jobhunt'),
                'name_admin_bar' => _x('Email', 'add new on admin bar', 'jobhunt'),
                'add_new' => _x('Add New', 'email', 'jobhunt'),
                'add_new_item' => esc_html__('Add New Email', 'jobhunt'),
                'new_item' => esc_html__('New Email', 'jobhunt'),
                'edit_item' => esc_html__('Edit Email', 'jobhunt'),
                'view_item' => esc_html__('View Email', 'jobhunt'),
                'all_items' => esc_html__('Sent Emails', 'jobhunt'),
                'search_items' => esc_html__('Search Emails', 'jobhunt'),
                'parent_item_colon' => esc_html__('Parent Emails:', 'jobhunt'),
                'not_found' => esc_html__('No emails found.', 'jobhunt'),
                'not_found_in_trash' => esc_html__('No emails found in Trash.', 'jobhunt')
            );

            $args = array(
                'labels' => $labels,
                'description' => esc_html__('Description.', 'jobhunt'),
                'public' => false,
                'publicly_queryable' => false,
                'show_ui' => true,
                'show_in_menu' => 'edit.php?post_type=jobs',
                'query_var' => false,
                'rewrite' => array( 'slug' => 'emails' ),
                'capability_type' => 'post',
                'has_archive' => false,
                'hierarchical' => false,
                'menu_position' => null,
                'supports' => array( 'title', 'editor' )
            );

            register_post_type($this->email_post_type_name, $args);
        }

        public function add_metabox_callback() {
            add_meta_box(
                    'email-details', esc_html__('Email Details', 'jobhunt'), array( $this, 'render_email_details_metabox' ), $this->email_post_type_name, 'advanced', 'default'
            );
        }

        public function render_email_details_metabox($post) {
            if ( isset($post) ) {
                $post_id = $post->ID;
                $meta = array(
                    'email_send_to' => array( 'title' => esc_html__('Sent To', 'jobhunt'), '' ),
                    'email_status' => array( 'title' => esc_html__('Email Status', 'jobhunt'), '' ),
                    'email_headers' => array( 'title' => esc_html__('Email Headers', 'jobhunt'), '' ),
                    'mailer_response' => array( 'title' => esc_html__('Mailer Response', 'jobhunt'), '' ),
                );
                echo '<table>';
                foreach ( $meta as $key => $val ) {
                    echo '<tr>';
                    echo '<td>' . $val['title'] . '</td>';
                    echo '<td>';
                    $val = get_post_meta($post_id, $key, true);
                    if ( is_array($val) ) {
                        echo implode(', ', $val);
                    } else {
                        echo $val;
                    }
                    echo '</td>';
                    echo '</tr>';
                }
                echo '</table>';
            }
        }

        public function save_email($args) {
            // Create post object
            $email_post = array(
                'post_title' => $args['subject'],
                'post_content' => $args['message'],
                'post_status' => 'publish',
                'post_type' => $this->email_post_type_name,
            );

            // Insert the post into the database.
            $id = wp_insert_post($email_post);

            if ( ! is_wp_error($id) ) {
                update_post_meta($id, 'email_status', 'new');
                update_post_meta($id, 'email_headers', $args['headers']);
                update_post_meta($id, 'email_send_to', $args['sent_to']);
                update_post_meta($id, 'email_type', $args['email_type']);
                return $id;
            } else {
                return 0;
            }
        }

        public function process_emails_callback() {
            $cs_plugin_options = get_option('cs_plugin_options');
            $cs_email_logs = isset($cs_plugin_options['cs_email_logs']) ? $cs_plugin_options['cs_email_logs'] : '';

            $args = array(
                'post_type' => $this->email_post_type_name
            );
            $post_id = isset($_REQUEST['post_id']) ? $_REQUEST['post_id'] : 0;
            if ( $post_id != 0 ) {
                $args['post__in'] = array( intval($post_id) );
            }
            $args['meta_query'] = array(
                array(
                    'key' => 'email_status',
                    'value' => 'new',
                    'compare' => 'LIKE',
                )
            );

            $query = new WP_Query($args);

            if ( $query->have_posts() ) {
                while ( $query->have_posts() ) {
                    $query->the_post();
                    $jobhunt_post_id = get_the_ID();
                    $jobhunt_subject = get_the_title();
                    $jobhunt_message = get_the_content();
                    $jobhunt_send_to = get_post_meta($jobhunt_post_id, 'email_send_to', true);
                    $jobhunt_headers = get_post_meta($jobhunt_post_id, 'email_headers', true);
                    $jobhunt_email_type = get_post_meta($jobhunt_post_id, 'email_type', true);
                    if ( ! empty($jobhunt_email_type) ) {
                        if ( $jobhunt_email_type == 'html' ) {
                            add_filter('wp_mail_content_type', function () {
                                return 'text/html';
                            });
                        } else {
                            add_filter('wp_mail_content_type', function () {
                                return 'text/plain';
                            });
                        }
                    }

                    $attachments = array();
                    $attachments = apply_filters('jobhunt_harry_cv_attachment',$attachments,$jobhunt_post_id);
                    $jobhunt_confirm = wp_mail($jobhunt_send_to, $jobhunt_subject, $jobhunt_message, $jobhunt_headers,$attachments);
                    update_post_meta($jobhunt_post_id, 'email_status', 'processed');
                    update_post_meta($jobhunt_post_id, 'mailer_response', $jobhunt_confirm + "");
                    if ( $cs_email_logs != 'on' && $jobhunt_post_id != '' && is_numeric($jobhunt_post_id) && get_post_type($jobhunt_post_id) == $this->email_post_type_name ) {
                        wp_delete_post($jobhunt_post_id, true);
                    }
                }
                wp_reset_postdata();
            } else {
                echo esc_html__('No Posts found', 'jobhunt');
            }
            wp_die();
        }

        public function jobhunt_process_emails_callback($post_id = '', $mail_arguments = array()) {
            $cs_plugin_options = get_option('cs_plugin_options');
            $cs_email_logs = isset($cs_plugin_options['cs_email_logs']) ? $cs_plugin_options['cs_email_logs'] : '';
            

            $args = array(
                'post_type' => $this->email_post_type_name
            );
            //$post_id = isset($_REQUEST['post_id']) ? $_REQUEST['post_id'] : 0;
            if ( $post_id != 0 ) {
                $args['post__in'] = array( intval($post_id) );
            }
            $args['meta_query'] = array(
                array(
                    'key' => 'email_status',
                    'value' => 'new',
                    'compare' => 'LIKE',
                )
            );

            $query = new WP_Query($args);

            if ( $query->have_posts() ) {
                while ( $query->have_posts() ) {
                    $query->the_post();
                    $jobhunt_post_id = get_the_ID();
                    $jobhunt_subject = get_the_title();
                    $jobhunt_message = get_the_content();
                    $jobhunt_send_to = get_post_meta($jobhunt_post_id, 'email_send_to', true);
                    $jobhunt_headers = get_post_meta($jobhunt_post_id, 'email_headers', true);
                    $jobhunt_email_type = get_post_meta($jobhunt_post_id, 'email_type', true);
                    if ( ! empty($jobhunt_email_type) ) {
                        if ( $jobhunt_email_type == 'html' ) {
                            add_filter('wp_mail_content_type', function () {
                                return 'text/html';
                            });
                        } else {
                            add_filter('wp_mail_content_type', function () {
                                return 'text/plain';
                            });
                        }
                    }

                    $attachments = isset( $mail_arguments['attachment'] )? $mail_arguments['attachment'] : array();
                    $attachments = apply_filters('jobhunt_harry_cv_attachment',$attachments,$jobhunt_post_id);

                    // send email to employer on there specified email address
                    $attachments = apply_filters('jobhunt_employer_notification_update_attachment_field', $attachments, $post_id);
                    
                    $jobhunt_confirm = wp_mail($jobhunt_send_to, $jobhunt_subject, $jobhunt_message, $jobhunt_headers,$attachments);
                    update_post_meta($jobhunt_post_id, 'email_status', 'processed');

                    update_post_meta($jobhunt_post_id, 'mailer_response', $jobhunt_confirm);
                    if ( $cs_email_logs != 'on' && $jobhunt_post_id != '' && is_numeric($jobhunt_post_id) && get_post_type($jobhunt_post_id) == $this->email_post_type_name ) {
                        wp_delete_post($jobhunt_post_id, true);
                    }
                }
                wp_reset_postdata();
            }
        }

        /**
          @return array Smtp plugin option fields.
         */
        public function create_plugin_option_smtp($jobhunt_setting_options) {
            $jobhunt_setting_options[] = array(
                "name" => esc_html__('SMTP Configuration', 'jobhunt'),
                "fontawesome" => 'icon-envelope4',
                "id" => "tab-smtp-configuration",
                "std" => "",
                "type" => "main-heading",
                "options" => ''
            );

            $on_off_option = array( 'yes' => esc_html__('Yes', 'jobhunt'), 'no' => esc_html__('No', 'jobhunt') );

            $jobhunt_setting_options[] = array(
                "name" => esc_html__("SMTP Configuration", "jobhunt"),
                "id" => "tab-smtp-configuration",
                "extra" => 'class="jobhunt_tab_block" data-title="' . esc_html__("SMTP Configuration", "jobhunt") . '"',
                "type" => "sub-heading",
            );

            $jobhunt_setting_options[] = array( "name" => esc_html__('SMTP Configuration', 'jobhunt'),
                "id" => "tab-settings-smtp-configuration",
                "std" => esc_html__('SMTP Configuration', 'jobhunt'),
                "type" => "section",
                "options" => ""
            );

            $jobhunt_setting_options[] = array( "col_heading" => esc_html__("SMTP Configuration", "jobhunt"),
                "type" => "tab-smtp",
                "help_text" => ""
            );
            $jobhunt_setting_options[] = array( "name" => esc_html__("Enable SMTP to Send Emails?", 'jobhunt'),
                "desc" => "",
                "hint_text" => esc_html__("Turn it on If you want to send Email Through SMTP..", "jobhunt"),
                "id" => "use_smtp_mail",
                "std" => "",
                "type" => "checkbox",
                "onchange" => "use_smtp_mail_opt(this)",
                "options" => $on_off_option,
            );

            $jobhunt_setting_options[] = array(
                "type" => "division",
                "enable_id" => "jobhunt_use_smtp_mail",
                "enable_val" => "on",
                "extra_atts" => 'id="cs-no-smtp-div"',
            );

            $jobhunt_setting_options[] = array( "name" => esc_html__("Use SMTP Authentication?", 'jobhunt'),
                "desc" => "",
                "hint_text" => esc_html__("Turn it on If you want to use SMTP Authentication.., If checked, you must provide the SMTP username and password below", "jobhunt"),
                "id" => "use_smtp_auth",
                "std" => "",
                "type" => "checkbox",
            );

            $jobhunt_setting_options[] = array( "name" => esc_html__("SMTP Host Name", 'jobhunt'),
                "desc" => "",
                "hint_text" => esc_html__("Enter your Smtp host here, It is name of your service provider", "jobhunt"),
                "id" => "smtp_host",
                "std" => "",
                "classes" => "jobhunt-dev-req-field-admin",
                'extra_attr' => 'data-visible="cs-no-smtp-div"',
                "type" => "text",
            );

            $jobhunt_setting_options[] = array( "name" => esc_html__("SMTP Port", 'jobhunt'),
                "desc" => "",
                "hint_text" => esc_html__("Enter your Smtp port here, e.g 25 or 465, This is generally 25.", "jobhunt"),
                "id" => "smtp_port",
                "std" => "",
                "type" => "text",
            );

            $jobhunt_setting_options[] = array( "name" => esc_html__("Connection prefix", 'jobhunt'),
                "desc" => "",
                "hint_text" => esc_html__("Sets connection prefix for secure connections (prefix method must be supported by your PHP install and your SMTP host)", 'jobhunt'),
                "id" => "secure_connection_type",
                "cust_name" => "mail_set_return_path",
                "std" => "true",
                "type" => "select",
                "options" => array( '' => 'none', 'ssl' => 'ssl', 'tls' => 'tls' ),
            );

            $jobhunt_setting_options[] = array( "name" => esc_html__("SMTP username", 'jobhunt'),
                "desc" => "",
                "hint_text" => esc_html__('Enter SMTP Username here', 'jobhunt'),
                "id" => "smtp_username",
                "std" => "",
                "type" => "text",
            );
            $jobhunt_setting_options[] = array( "name" => esc_html__("SMTP Password", 'jobhunt'),
                "desc" => "",
                "hint_text" => esc_html__('Please Enter SMTP Password here', 'jobhunt'),
                "id" => "smtp_password",
                "std" => "",
                "type" => "password",
            );

            $jobhunt_setting_options[] = array( "name" => esc_html__("Wordwrap length", 'jobhunt'),
                "desc" => "",
                "hint_text" => esc_html__('Enter Wordwrap length here, Sets word wrapping on the body of the message to a given number of characters.', 'jobhunt'),
                "id" => "wordwrap_length",
                "std" => "",
                "type" => "text",
            );

            $jobhunt_setting_options[] = array( "name" => esc_html__("Enable debugging?", 'jobhunt'),
                "desc" => "",
                "hint_text" => esc_html__("Only check this if you are experiencing problems and would like more error reporting to occur. Uncheck this once you have finished debugging.", "jobhunt"),
                "id" => "smtp_debugging",
                "std" => "",
                "type" => "checkbox",
            );

            $jobhunt_setting_options[] = array( "name" => esc_html__("Sender e-mail", 'jobhunt'),
                "desc" => "",
                "hint_text" => esc_html__('Sets the From e-mail address for all outgoing messages. Leave blank to use the WordPress default. This value will be used even if you do not enable SMTP. NOTE: This may not take effect depending on your mail server and settings, especially if using SMTPAuth (such as for GMail).', "jobhunt"),
                "id" => "smtp_sender_email",
                "std" => "",
                "type" => "text",
            );

            $jobhunt_setting_options[] = array( "name" => esc_html__("Sender name", 'jobhunt'),
                "desc" => "",
                "hint_text" => esc_html__('Sets the From name for all outgoing messages. Leave blank to use the WordPress default. This value will be used even if you do not enable SMTP.', "jobhunt"),
                "id" => "sender_name",
                "std" => "",
                "type" => "text",
            );

            $jobhunt_setting_options[] = array( "name" => esc_html__("Test Email", 'jobhunt'),
                "desc" => "",
                "hint_text" => esc_html__('Sets the test email address for checking smtp is working or not from bottom send text button. Leave blank to use the adminstrator email address.', "jobhunt"),
                "id" => "test_email",
                "std" => "",
                "type" => "text",
            );

            $jobhunt_setting_options[] = array( "name" => '',
                "desc" => "",
                "hint_text" => '',
                "id" => "submit_test_email",
                "std" => "Send Test",
                "type" => "text",
                "cust_type" => "button",
            );

            $jobhunt_setting_options[] = array(
                "type" => "division_close",
            );

            $jobhunt_setting_options[] = array( "col_heading" => esc_html__("SMTP Configurations", "jobhunt"),
                "type" => "col-right-text",
                "help_text" => ""
            );

            return $jobhunt_setting_options;
        }

        /**
         * @param    PHPMailer    $phpmailer    A reference to the current instance of PHP Mailer
         */
        public function phpmailer_init_callback($phpmailer) {
            $options = get_option('cs_plugin_options');
            // Don't configure for SMTP if no host is provided.
            if ( empty($options['cs_use_smtp_mail']) || $options['cs_use_smtp_mail'] != 'on' ) {
                return;
            }
            $phpmailer->IsSMTP();
            $phpmailer->Host = isset($options['cs_smtp_host']) ? $options['cs_smtp_host'] : 'imap.gmail.com';
            $phpmailer->Port = isset($options['cs_smtp_port']) ? $options['cs_smtp_port'] : 25;
            $phpmailer->SMTPAuth = isset($options['cs_use_smtp_auth']) ? $options['cs_use_smtp_auth'] : false;
            if ( $phpmailer->SMTPAuth ) {
                $phpmailer->Username = isset($options['cs_smtp_username']) ? $options['cs_smtp_username'] : 'admin';
                $phpmailer->Password = isset($options['cs_smtp_password']) ? $options['cs_smtp_password'] : 'admin';
            }
            if ( $options['cs_secure_connection_type'] != '' )
                $phpmailer->SMTPSecure = isset($options['cs_secure_connection_type']) ? $options['cs_secure_connection_type'] : 'ssl';
            if ( $options['cs_smtp_sender_email'] != '' )
                $phpmailer->SetFrom($options['cs_smtp_sender_email'], $options['cs_smtp_sender_email']);
            if ( $options['cs_wordwrap_length'] > 0 )
                $phpmailer->WordWrap = isset($options['cs_wordwrap_length']) ? $options['cs_wordwrap_length'] : '20';
            if ( $options['cs_smtp_debugging'] == "on" && isset($_POST['action']) && $_POST['action'] == 'send_smtp_mail' )
                $phpmailer->SMTPDebug = true;
        }

        public function send_smtp_mail_callback() {
            $user = wp_get_current_user();
            $options = get_option('cs_plugin_options');
            if ( ! empty($user) ) {
                $email = $user->user_email;
            }
            $email = (isset($options['cs_test_email']) && $options['cs_test_email'] != '') ? $options['cs_test_email'] : $email;
            $subject = esc_html__('This is a test mail', 'jobhunt');
            $timestamp = current_time('mysql');
            $message = sprintf(esc_html__('Hi, this is the %s plugin e-mailing you a test message from your WordPress blog.', 'jobhunt'), 'jobhunt');
            $message .= "\n\n";
            $jobhunt_from_name = isset($options['cs_sender_name']) ? $options['cs_sender_name'] : '';
            $jobhunt_from_email = isset($options['cs_smtp_sender_email']) ? $options['cs_smtp_sender_email'] : '';
            $headers = array();
            $headers[] = 'From:' . $jobhunt_from_name . ' <' . $jobhunt_from_email . '>';
            //$headers[] = 'From:' . $jobhunt_from_email . ' <' . $jobhunt_from_name . '>';

            $array = array( 'to' => $email, 'subject' => $subject, 'message' => $message, 'headers' => $headers );

            do_action('jobhunt_send_mail', $array);

            // Check success
            global $phpmailer;
            if ( $phpmailer->ErrorInfo != "" ) {
                $error_msg = '<div class="error"><p>' . esc_html__('An error was encountered while trying to send the test e-mail.', 'jobhunt') . '</p>';
                $error_msg .= '<blockquote style="font-weight:bold;">';
                $error_msg .= '<p>' . $phpmailer->ErrorInfo . '</p>';
                $error_msg .= '</p></blockquote>';
                $error_msg .= '</div>';
            } else {
                $error_msg = '<div class="updated"><p>' . esc_html__('Test e-mail sent.', 'jobhunt') . '</p>';
                $error_msg .= '<p>' . sprintf(esc_html__('The body of the e-mail includes this time-stamp: %s.', 'jobhunt'), $timestamp) . '</p></div>';
            }
            echo $error_msg;
            exit;
        }

        /**
          @return string The name from which the email is being sent.
         */
        public function wp_mail_from_name_callback($original_email_from) {
            $options = get_option('cs_plugin_options');
            // Don't configure for SMTP if no host is provided.
            if ( empty($options['cs_use_smtp_mail']) || $options['cs_use_smtp_mail'] != 'on' || $options['cs_sender_name'] == '' ) {
                return get_bloginfo('name');
            } else {
                return $options['cs_sender_name'];
            }
        }

        /*
         * Send Mail through SMTP if configured.
         * Allowed array parameters: 
         * array('to' => $email, 'subject' => $subject, 'message' => $message, 'headers' => $headers')
         */

        public function send_mail_callback($args) {
            $cs_plugin_options = get_option('cs_plugin_options');
            $cs_email_logs = isset($cs_plugin_options['cs_email_logs']) ? $cs_plugin_options['cs_email_logs'] : '';

            $jobhunt_send_to = (isset($args['to'])) ? $args['to'] : '';
            $jobhunt_subject = (isset($args['subject'])) ? $args['subject'] : '';
            $jobhunt_message = (isset($args['message'])) ? $args['message'] : '';
            $jobhunt_headers = array();
            if ( isset($args['from']) && $args['from'] != '' ) {
                $jobhunt_headers[] = 'From: ' . $args['from'];
            }
            $email_type = 'plain_text';
            if ( isset($args['email_type']) ) {
                $email_type = $args['email_type'];
            }

            $jobhunt_headers = ( isset($args['headers']) ) ? $args['headers'] : $jobhunt_headers;
            $class_obj = ( isset($args['class_obj']) ) ? $args['class_obj'] : '';
            $post_id = $this->save_email(array(
                'sent_to' => $jobhunt_send_to,
                'subject' => $jobhunt_subject,
                'message' => $jobhunt_message,
                'headers' => $jobhunt_headers,
                'email_type' => $email_type,
            ));
            if ( $post_id != 0 ) {
                do_action('jobhunt_harry_update_attachment_field',$post_id,$args);
                //wp_remote_get(admin_url('admin-ajax.php?action=process_emails&post_id=' . $post_id), array( 'timeout' => 0, 'httpversion' => '1.1' ));
                do_action('jobhunt_process_emails',$post_id, $args);
            }

            if ( $class_obj != '' ) {
                $class_obj->is_email_sent = true;
            }

            if ( $cs_email_logs != 'on' && $post_id != '' && is_numeric($post_id) && get_post_type($post_id) == $this->email_post_type_name ) {
                $email_status = get_post_meta($post_id, 'email_status', true);
                if ( $email_status == 'processed' ) {
                    wp_delete_post($post_id, true);
                }
            }
        }

    }

    $jobhunt_email = new JobHunt_Email();
}