<?php

/**
 * Importing Email Templates Data
 *
 * @since 1.0
 * @package	Directory
 */
// Direct access not allowed.
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Email Templates Data Class.
 */
class Jobhunt_Email_Templates_Data {

    /**
     * Put hooks in place and activate.
     */
    public function __construct() {
        add_action('init', array($this, 'init'), 8);
    }

    public function init() {
        
        //do_action('jobhunt_email_verification_email', $reg_user);
        
        
        if( isset( $_GET['email_verify'] ) && $_GET['email_verify'] != '' ){
            $email_verify = $_GET['email_verify'];
            $email_verify = base64_decode(base64_decode($email_verify));
            $email_verify = json_decode($email_verify);
            //pre($email_verify);
            $user_id = isset( $email_verify->user_id )? $email_verify->user_id : 0;
            $verfication_code = isset( $email_verify->verfication_code )? $email_verify->verfication_code : 0;
            $user_verification_code = get_user_meta($user_id, 'verification_code', true);
            if( $verfication_code == $user_verification_code){
                //update_user_meta($user_id, 'verification_code', '');
                update_user_meta($user_id, 'email_verified', 1);
                
//bdoor add this
// Get user
    $user = get_userdata($user_id);
    if (!$user || !in_array('cs_employer', (array) $user->roles)) {
        return; // Only for employer role
    }

    // Skip if already sent
    if (get_user_meta($user_id, 'contract_pdf_sent', true)) {
        return;
    }

    // Gather data
    $user_name = $user->display_name;
    $phone = get_user_meta($user_id, 'cs_phone_number', true);
    $user_email = $user->user_email;
    $company_name = get_user_meta($user_id, 'cs_organization_name', true);
    $company_number = get_user_meta($user_id, 'cr_number', true);
    $company_address = get_user_meta($user_id, 'cs_city', true);
    $today = date('Y-m-d');

    // Load HTML
    $template_path = get_theme_file_path('/pdf-library/mpdf/templates/contract-template.html');
    $html = file_get_contents($template_path);
    if (!$html) {
        error_log("Failed to load contract template.");
        return;
    }

    // Replace placeholders
    $replacements = [
        '[user_name]' => $user_name,
        '[user_email]' => $user_email,
        '[phone]' => $phone,
        '[company_name]' => $company_name,
        '[company_number]' => $company_number,
        '[company_address]' => $company_address,
        '[today]' => $today,
    ];
    $html = str_replace(array_keys($replacements), array_values($replacements), $html);

    // Load mPDF
    if (!class_exists('\\Mpdf\\Mpdf')) {
        require_once get_theme_file_path('/pdf-library/mpdf/vendor/autoload.php');
    }

    // Generate PDF
    $mpdf = new \Mpdf\Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'amiri',
        'margin_top' => 40,
        'margin_bottom' => 40,
    ]);
    $mpdf->WriteHTML($html);

    // Save to file
    $upload_dir = wp_upload_dir();
    $pdf_path = $upload_dir['basedir'] . "/Employer_Contract{$user_id}.pdf";
    $mpdf->Output($pdf_path, \Mpdf\Output\Destination::FILE);

    // Send email
    $subject = "Employer Contract";
    $message = 
    
"Dear {$user_name},

Attached is your employer agreement.

Please follow these steps:
1. Read the contract carefully.
2. Sign it at the bottom.
3. Reply to this email with the signed contract attached to complete your account activation.

Regards,  
Qeyada Careers

عزيزي/عزيزتي {$user_name}،

مرفق مع هذه الرسالة عقد صاحب العمل الخاص بك.

يرجى اتباع الخطوات التالية:
1. قراءة العقد بعناية.
2. التوقيع عليه في الأسفل.
3. إعادة إرسال العقد الموقع بالرد على هذا البريد الإلكتروني لاستكمال تفعيل الحساب.

مع التحية،  
قيادة للتوظيف
";
    $headers = ['Content-Type: text/plain; charset=UTF-8'];
    $attachments = [$pdf_path];

    wp_mail($user_email, $subject, $message, $headers, $attachments);

    // Mark as sent
    update_user_meta($user_id, 'contract_pdf_sent', true);

//the end of bdoor addings
                
                
            }
            wp_redirect(site_url().'?email_verified=confirm');
            exit;
        }
        
        delete_option('templates_already_created');
        if (true != get_option('templates_already_created')) {
            add_action('jobhunt_load_email_templates', array($this, 'jobhunt_load_email_templates_data'));
        }
    }

    public function jobhunt_load_email_templates_data($email_templates) {
        if (!empty($email_templates)) {

            foreach ($email_templates as $group => $group_array) {
                $group_id = $this->jobhunt_register_email_group($group);
                $this->jobhunt_add_email_template_post($group_array, $group_id);
            }
            update_option('templates_already_created', true);
        }
    }

    public function jobhunt_register_email_group($group_slug) {
        $group_name = str_replace("_", " ", $group_slug);
        $group_id = 0;

        $return_data = wp_insert_term(
                $group_name, // the term 
                'email_template_group', // the taxonomy
                array(
                    'slug' => $group_name,
                )
        );
        if ((!isset($return_data->error_data)) && isset($return_data['term_id']) && $return_data['term_id'] != '') {
            $group_id = $return_data['term_id'];
        } else {
            if (isset($return_data->error_data)) {

                $group_id = $return_data->error_data['term_exists'];
            }
        }
        return $group_id;
    }

    public function jobhunt_add_email_template_post($group_array, $group_id) {
        global $wpdb;

        foreach ($group_array as $slug => $post_data) {
            $check = jobhunt_check_if_template_exists($slug, 'jh-templates');
            if (false == $check) {
                $new_template = array(
                    'post_title' => wp_strip_all_tags($post_data['title']),
                    'post_name' => $slug,
                    'post_content' => $post_data['template'],
                    'post_type' => 'jh-templates',
                    'post_status' => 'publish',
                    'post_author' => get_current_user_id(),
                );
                $post_id = wp_insert_post($new_template);
                update_post_meta($post_id, 'jh_email_template_type', $post_data['email_template_type']);
                update_post_meta($post_id, 'jh_email_notification', 1);
                $output = wp_set_object_terms($post_id, $group_id, 'email_template_group');

                update_post_meta($post_id, 'jh_email_type', $post_data['jh_email_type']);
                update_post_meta($post_id, 'is_recipients_enabled', $post_data['is_recipients_enabled']);
                update_post_meta($post_id, 'description', $post_data['description']);
            }
        }
    }

}

$jobhunt_email_templates_data_instance = new Jobhunt_Email_Templates_Data();