<?php

function generate_employer_contract_pdf($user_id) {
    // Fetch user data
    $user = get_userdata($user_id);
    if (!$user || !in_array('cs_employer', (array) $user->roles)) {
        return; // Only for employer role
    }

    // Skip if already sent
    if (get_user_meta($user_id, 'contract_pdf_sent', true)) {
        return;
    }

    // Gather data
    $first_name = get_user_meta($user_id, 'first_name', true);
    $last_name = get_user_meta($user_id, 'last_name', true);
    $company_name = get_user_meta($user_id, 'display_name', true);
    $phone = get_user_meta($user_id, 'cs_phone_number', true);
    $user_email = $user->user_email;
    $user_name = trim($first_name . ' ' . $last_name);
    $presenter_name = $user_name;
    $company_number = get_user_meta($user_id, 'company_cr_number', true);
    $company_address = get_user_meta($user_id, 'company_address', true);
    $today = date('Y-m-d');

    // Load HTML
    $template_path = get_theme_file_path('/templates/contract-template.html');
    $html = file_get_contents($template_path);
    if (!$html) {
        error_log("Failed to load contract template.");
        return;
    }

    // Replace placeholders
    $replacements = [
        '[first_name]' => $first_name,
        '[last_name]' => $last_name,
        '[user_name]' => $user_name,
        '[user_email]' => $user_email,
        '[phone]' => $phone,
        '[company_name]' => $company_name,
        '[company_number]' => $company_number,
        '[company_address]' => $company_address,
        '[presenter_name]' => $presenter_name,
        '[today]' => $today,
    ];
    $html = str_replace(array_keys($replacements), array_values($replacements), $html);

    // Load mPDF
    if (!class_exists('\\Mpdf\\Mpdf')) {
        require_once get_theme_file_path('/vendor/autoload.php');
    }

    // Generate PDF
    $mpdf = new \Mpdf\Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'Arial', // or 'Amiri' for Arabic
    ]);
    $mpdf->WriteHTML($html);

    // Save to file
    $upload_dir = wp_upload_dir();
    $pdf_path = $upload_dir['basedir'] . "/contract_{$user_id}.pdf";
    $mpdf->Output($pdf_path, \Mpdf\Output\Destination::FILE);

    // Send email
    $subject = "Your Employer Contract";
    $message = "Dear {$user_name},\n\nAttached is your employer agreement. Please sign and reply to this email to proceed with account activation.\n\nRegards,\nQeyada Careers";
    $headers = ['Content-Type: text/plain; charset=UTF-8'];
    $attachments = [$pdf_path];

    wp_mail($user_email, $subject, $message, $headers, $attachments);

    // Mark as sent
    update_user_meta($user_id, 'contract_pdf_sent', true);
}
