<?php

// Simulate a user ID (replace with actual logic later)
$user_id = 123;

// Simulate user meta data
$first_name = "Ali";
$last_name = "Hassan";
$company_name = "Neft Energies";
$phone = "+966-555-123456";
$user_email = "ali.hassan@company.com";
$user_name = $first_name . ' ' . $last_name;
$presenter_name = $user_name;
$company_number = "CR-567890";
$company_address = "King Fahad Road, Dhahran, KSA";
$today = date('Y-m-d');

// Load HTML template
$template_path = __DIR__ . '/templates/contract-template.html';
$html = file_get_contents($template_path);
if (!$html) {
    die("Failed to load HTML template.");
}

// Replace placeholders
$replacements = [
    '[first_name]' => $first_name,
    '[last_name]' => $last_name,
    '[user_name]' => $user_name,
    '[user_email]' => $user_email,
    '[phone]' => $phone,
    '[company_name]' => $company_name,
    '[company_number]' => $company_number,
    '[company_address]' => $company_address,
    '[presenter_name]' => $presenter_name,
    '[today]' => $today,
];

$html = str_replace(array_keys($replacements), array_values($replacements), $html);

// Load mPDF (manual setup)
require_once __DIR__ . '/vendor/autoload.php';

// Create PDF
$mpdf = new \Mpdf\Mpdf([
    'mode' => 'utf-8',
    'format' => 'A4',
    'default_font' => 'Arial',
]);

$mpdf->WriteHTML($html);

// Output inline OR save to file
// $mpdf->Output('contract.pdf', 'I'); // Show in browser
$mpdf->Output(__DIR__ . "/contract_{$user_id}.pdf", \Mpdf\Output\Destination::FILE);

echo "PDF generated: contract_{$user_id}.pdf";
