<?php
/**
 * @Mailchimp List
 */

if (!defined('ABSPATH')) {
    wp_die;
}
if ( ! function_exists('cs_mailchimp_list') ) {

    function cs_mailchimp_list($apikey) {
        global $cs_theme_options;
        if (class_exists('MailChimp')) {
            $MailChimp = new MailChimp($apikey);
            $mailchimp_list = $MailChimp->get('lists');//$MailChimp->call('lists/list');
            $mailchimp_list['data'] = $mailchimp_list['lists'];
            return $mailchimp_list;
        }
    }

}

/**
 * @custom mail chimp form
 */
if ( ! function_exists('cs_custom_mailchimp') ) {

    function cs_custom_mailchimp($view = '') {
        global $cs_theme_options, $counter, $jobcareer_options;
        $counter ++;
        ?>              
        <script>
            function cs_mailchimp_submit(theme_url, counter, admin_url) {
                'use strict';
                $ = jQuery;
                $('#process_' + counter).html('<div id="process_newsletter_' + counter + '"><i class="icon-refresh icon-spin" style="float:right;margin:12px 0px 0px 0px;"></i></div>');
                $.ajax({
                    type: 'POST',
                    url: admin_url,
                    data: $('#mcform_' + counter).serialize() + '&action=jobcareer_mailchimp',
                    success: function (response) {
                        //$(".cs-error-msg").css("display", "block");
                        $('#mcform_' + counter).get(0).reset();
                        $('#newsletter_mess_' + counter).fadeIn(600);
                        $('#newsletter_mess_' + counter).html(response);
                        $('#cs-aviation-success').html(response);
                        $(".cs-aviation-success").addClass("important");
                        //$('#btn_newsletter_'+counter).fadeIn(600);
                        $('#process_' + counter).html('');
                    }
                });
            }
             function cs_mailchimp_submit_aviation(theme_url, counter, admin_url) {
                'use strict';
                $ = jQuery;
                $('#process_' + counter).html('<div id="process_newsletter_' + counter + '"><i class="icon-refresh icon-spin" style="float:right;margin:12px 0px 0px 0px;"></i></div>');
                $.ajax({
                    type: 'POST',
                    url: admin_url,
                    data: $('#mcform_' + counter).serialize() + '&action=jobcareer_mailchimp',
                    success: function (response) {
                        //$(".cs-error-msg").css("display", "block");
                        $('#mcform_' + counter).get(0).reset();
                        $('#newsletter_mess_' + counter).fadeIn(600);
                        $('#newsletter_mess_' + counter).html(response);
                        $('#cs-aviation-success').html(response);
                        $(".cs-aviation-success").addClass("important");
                        //$('#btn_newsletter_'+counter).fadeIn(600);
                        $('#process_' + counter).html('');
                    }
                });
            }
        </script>
	<?php if($view == 'aviation'){ ?>
        <div class="aviation-newletter" id="process_newsletter_<?php echo intval($counter); ?>">
                                <div class="aviation-newletter-inner">
                                    <div class="fieldset">
                                        <form class="cs-aviation" action="javascript:cs_mailchimp_submit_aviation('<?php echo get_template_directory_uri() ?>','<?php echo esc_js($counter); ?>','<?php echo admin_url('admin-ajax.php'); ?>')" id="mcform_<?php echo intval($counter); ?>" method="post">
                                            <button class="shown cs-bgcolor cs-aviation-trigger" type="button" id="cs_aviation_trigger"> <?php esc_html_e('Click to subscribe for Newsletter', 'cs_frame'); ?></button>
                                            <input id="cs_list_id" type="hidden" name="cs_list_id" value="<?php if ( isset($jobcareer_options['jobcareer_mailchimp_list']) ) {
            echo esc_attr($jobcareer_options['jobcareer_mailchimp_list']);
        } ?>" />
                                            <div class="cs-input-holder" id="cs-aviation-holder">
                                                <input type="email" value="" name="" placeholder="Enter Your Email Address">
                                                <button class="cs-bgcolor" type="submit" id="btn_newsletter_<?php echo intval($counter); ?>" value="Submit"> <?php esc_html_e('Submit', 'cs_frame'); ?></button>
                                            </div>
                                            <div class="cs-aviation-success" id="cs-aviation-success"><i class="icon-refresh icon-spin" style="float:right;margin:12px 0px 0px 0px;"></i></div>
                                        </form>
                                    </div>
                                </div>
                            </div>
        <?php } else{ ?>
        <div id ="process_newsletter_<?php echo intval($counter); ?>">
            <div id="process_<?php echo intval($counter); ?>" class="cs-show-msg"> </div>
            <div id="newsletter_mess_<?php echo intval($counter); ?>" style="display:none" class="cs-error-msg"></div> 
            <form  action="javascript:cs_mailchimp_submit('<?php echo get_template_directory_uri() ?>','<?php echo esc_js($counter); ?>','<?php echo admin_url('admin-ajax.php'); ?>')" id="mcform_<?php echo intval($counter); ?>" method="post">
                <input id="cs_list_id" type="hidden" name="cs_list_id" value="<?php if ( isset($jobcareer_options['jobcareer_mailchimp_list']) ) {
            echo esc_attr($jobcareer_options['jobcareer_mailchimp_list']);
        } ?>" />
                <input type="text" id="mc_email" class="txt-bar"  name="mc_email" placeholder=" <?php esc_html_e('Enter Valid Email Address', 'cs_frame'); ?>">				
                <input type="submit" class ="submit-btn cs-bgcolor vsmall" id="btn_newsletter_<?php echo intval($counter); ?>"   value="<?php esc_html_e('Submit', 'cs_frame'); ?>">
            </form>
        </div> 
        <?php
        }
    }

}


if ( ! function_exists('cs_short_code') ) {

    function cs_short_code($name = '', $function = '') {

        if ( $name != '' && $function != '' ) {
            add_shortcode($name, $function);
        }
    }

}

/*
 * Start function Quote Form Submit 
 */
if ( ! function_exists('jobcareer_slider_form_submit') ) {

    function jobcareer_slider_form_submit() {
        define('WP_USE_THEMES', false);

        $cs_slider_error_msg = '';
        foreach ( $_REQUEST as $keys => $values ) {
            $$keys = $values;
        }

        $bloginfo = get_bloginfo();
        $subjecteEmail = "(" . $bloginfo . ") " . esc_html__('Quote Form Received', 'jobcareer');
        $message = '
            <table width="100%" border="1">
              <tr>
                <td width="100"><strong>' . esc_html__('Name:', 'jobcareer') . '</strong></td>
                <td>' . $slider_name . '</td>
              </tr>
              <tr>
                <td><strong>' . esc_html__('Email:', 'jobcareer') . '</strong></td>
                <td>' . $slider_mail . '</td>
              </tr>
              <tr>
                <td><strong>' . esc_html__('Mobile Number:', 'jobcareer') . '</strong></td>
                <td>' . $slider_number . '</td>
              </tr>
              <tr>
                <td><strong>' . esc_html__('Message:', 'jobcareer') . '</strong></td>
                <td>' . $slider_message . '</td>
              </tr>
              <tr>
                <td><strong>' . esc_html__('IP Address:', 'jobcareer') . '</strong></td>
                <td>' . $_SERVER["REMOTE_ADDR"] . '</td>
              </tr>
            </table>';
        $headers = '';
        if ( (isset($slider_name) && $slider_name !== '') && (isset($slider_mail) && $slider_mail !== '') ) {
            $headers = 'From: ' . $slider_name . ' <' . $slider_mail . '>' . "\r\n";
            $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
            $headers .= "MIME-Version: 1.0" . "\r\n";
        }
        $attachments = '';
        if ( wp_mail(sanitize_email($cs_slider_email), ($subjecteEmail), $message, $headers, $attachments) ) {
            $json = array();
            $json['type'] = "success";
            $json['message'] = '<p>' . jobcareer_textarea_filter($cs_slider_succ_msg) . '</p>';
        } else {
            $json['type'] = "error";
            $json['message'] = '<p>' . jobcareer_textarea_filter($cs_slider_error_msg) . '</p>';
        };

        echo json_encode($json);
        die();
    }

}


// End function Quote Form Submit 

