/*! For license information please see trp-lang-switcher-configurator.js.LICENSE.txt */
(()=>{var e,t={54:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-color__wrapper[data-v-6f8cc29c]{align-items:center;display:flex;gap:8px;position:relative}.trp-color--picking[data-v-6f8cc29c]{-webkit-user-select:none;-moz-user-select:none;user-select:none}.trp-color-input[data-v-6f8cc29c]{border:1px solid #e2e2e4;border-radius:5px;cursor:pointer;height:29px;width:53px}.trp-color-input[data-v-6f8cc29c]:focus-visible{outline:2px solid var(--trp-settings-accent-color)}.trp-color__popover[data-v-6f8cc29c]{left:0;position:absolute;top:calc(100% + 4px);z-index:1000}.trp-color-code[data-v-6f8cc29c]{text-transform:uppercase}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/ColorField.vue"],names:[],mappings:"AAqFA,qCAGI,kBAAmB,CADnB,YAAa,CAEb,OAAQ,CAHR,iBAIJ,CAEA,qCACI,wBAAiB,CAAjB,qBAAiB,CAAjB,gBACJ,CAEA,kCAGI,wBAAyB,CACzB,iBAAkB,CAClB,cAAe,CAHf,WAAY,CADZ,UAKJ,CAEA,gDACI,kDACJ,CAEA,qCAGI,MAAO,CAFP,iBAAkB,CAClB,oBAAqB,CAErB,YACJ,CAEA,iCACI,wBACJ",sourcesContent:['<script setup>\r\nimport { ref, computed, onMounted, onBeforeUnmount } from \'vue\'\r\nimport \'vue-color/style.css\'\r\nimport { ChromePicker, tinycolor } from \'vue-color\'\r\n\r\nconst props = defineProps({\r\n    label      : { type: String, default: \'\' },\r\n    modelValue : { type: String, required: true }\r\n})\r\nconst emit = defineEmits([\'update:modelValue\'])\r\n\r\n// picker visibility + refs for click-outside\r\nconst showPicker = ref(false)\r\nconst swatchRef  = ref(null)\r\nconst pickerRef  = ref(null)\r\n\r\nfunction togglePicker() {\r\n    showPicker.value = !showPicker.value\r\n}\r\nfunction onClickOutside(e) {\r\n    if (\r\n        swatchRef.value && !swatchRef.value.contains(e.target) &&\r\n        pickerRef.value && !pickerRef.value.contains(e.target)\r\n    ) {\r\n        showPicker.value = false\r\n    }\r\n}\r\n\r\nonMounted(() => document.addEventListener(\'mousedown\', onClickOutside))\r\nonBeforeUnmount(() => document.removeEventListener(\'mousedown\', onClickOutside))\r\n\r\nconst tinyColorModel = computed({\r\n    get() {\r\n        return tinycolor(props.modelValue)\r\n    },\r\n    set(tc) {\r\n        // ensure we handle both hex-only and hex+alpha\r\n        const c = tinycolor(tc)\r\n        const hex  = c.toHexString().toUpperCase()\r\n        const alpha = Math.round(c.getAlpha() * 255)\r\n                          .toString(16)\r\n                          .padStart(2,\'0\')\r\n                          .toUpperCase()\r\n\r\n        const out = alpha === \'FF\' ? hex : `${hex}${alpha}`\r\n\r\n        emit(\'update:modelValue\', out)\r\n    }\r\n})\r\n<\/script>\r\n\r\n<template>\r\n    <div :class="{ \'trp-color--picking\': showPicker }">\r\n        <span v-if="label" class="trp-field__label trp-primary-text-bold">\r\n          {{ label }}\r\n        </span>\r\n        <div class="trp-color__wrapper">\r\n            <div\r\n                class="trp-color-input"\r\n                :style="{ background: modelValue }"\r\n                ref="swatchRef"\r\n                @click="togglePicker"\r\n                @keydown.enter.space="togglePicker"\r\n                role="button"\r\n                aria-label="Open colour picker"\r\n                tabindex="0"\r\n            />\r\n\r\n            <span class="trp-color-code trp-primary-text">\r\n                {{ modelValue.toUpperCase() }}\r\n            </span>\r\n\r\n            <div\r\n                v-if="showPicker"\r\n                class="trp-color__popover"\r\n                ref="pickerRef"\r\n                @mousedown.stop\r\n            >\r\n                <ChromePicker v-model:tinyColor="tinyColorModel" />\r\n            </div>\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-color__wrapper {\r\n    position: relative;\r\n    display: flex;\r\n    align-items: center;\r\n    gap: 8px;\r\n}\r\n\r\n.trp-color--picking {\r\n    user-select: none;\r\n}\r\n\r\n.trp-color-input {\r\n    width: 53px;\r\n    height: 29px;\r\n    border: 1px solid #E2E2E4;\r\n    border-radius: 5px;\r\n    cursor: pointer;\r\n}\r\n\r\n.trp-color-input:focus-visible {\r\n    outline: 2px solid var(--trp-settings-accent-color);\r\n}\r\n\r\n.trp-color__popover {\r\n    position: absolute;\r\n    top: calc(100% + 4px);\r\n    left: 0;\r\n    z-index: 1000;\r\n}\r\n\r\n.trp-color-code {\r\n    text-transform: uppercase;\r\n}\r\n</style>\r\n'],sourceRoot:""}]);const a=s},72:(e,t,n)=>{"use strict";var r,i=function(){return void 0===r&&(r=Boolean(window&&document&&document.all&&!window.atob)),r},o=function(){var e={};return function(t){if(void 0===e[t]){var n=document.querySelector(t);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(e){n=null}e[t]=n}return e[t]}}(),s=[];function a(e){for(var t=-1,n=0;n<s.length;n++)if(s[n].identifier===e){t=n;break}return t}function l(e,t){for(var n={},r=[],i=0;i<e.length;i++){var o=e[i],l=t.base?o[0]+t.base:o[0],c=n[l]||0,h="".concat(l," ").concat(c);n[l]=c+1;var d=a(h),u={css:o[1],media:o[2],sourceMap:o[3]};-1!==d?(s[d].references++,s[d].updater(u)):s.push({identifier:h,updater:m(u,t),references:1}),r.push(h)}return r}function c(e){var t=document.createElement("style"),r=e.attributes||{};if(void 0===r.nonce){var i=n.nc;i&&(r.nonce=i)}if(Object.keys(r).forEach(function(e){t.setAttribute(e,r[e])}),"function"==typeof e.insert)e.insert(t);else{var s=o(e.insert||"head");if(!s)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");s.appendChild(t)}return t}var h,d=(h=[],function(e,t){return h[e]=t,h.filter(Boolean).join("\n")});function u(e,t,n,r){var i=n?"":r.media?"@media ".concat(r.media," {").concat(r.css,"}"):r.css;if(e.styleSheet)e.styleSheet.cssText=d(t,i);else{var o=document.createTextNode(i),s=e.childNodes;s[t]&&e.removeChild(s[t]),s.length?e.insertBefore(o,s[t]):e.appendChild(o)}}function p(e,t,n){var r=n.css,i=n.media,o=n.sourceMap;if(i?e.setAttribute("media",i):e.removeAttribute("media"),o&&"undefined"!=typeof btoa&&(r+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(o))))," */")),e.styleSheet)e.styleSheet.cssText=r;else{for(;e.firstChild;)e.removeChild(e.firstChild);e.appendChild(document.createTextNode(r))}}var f=null,g=0;function m(e,t){var n,r,i;if(t.singleton){var o=g++;n=f||(f=c(t)),r=u.bind(null,n,o,!1),i=u.bind(null,n,o,!0)}else n=c(t),r=p.bind(null,n,t),i=function(){!function(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e)}(n)};return r(e),function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap)return;r(e=t)}else i()}}e.exports=function(e,t){(t=t||{}).singleton||"boolean"==typeof t.singleton||(t.singleton=i());var n=l(e=e||[],t);return function(e){if(e=e||[],"[object Array]"===Object.prototype.toString.call(e)){for(var r=0;r<n.length;r++){var i=a(n[r]);s[i].references--}for(var o=l(e,t),c=0;c<n.length;c++){var h=a(n[c]);0===s[h].references&&(s[h].updater(),s.splice(h,1))}n=o}}}},85:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-settings-separator[data-v-446a0a1f]{margin-bottom:8px}.trp-layout-customizer-field[data-v-446a0a1f]{display:flex;flex-direction:column;gap:16px}.trp-lc-mode-toggle[data-v-446a0a1f]{display:flex;gap:8px}.trp-lc-mode-button[data-v-446a0a1f]{background:none;border:none;cursor:pointer;display:flex;gap:4px;padding:0 8px 8px}.trp-lc-mode-button.active[data-v-446a0a1f]{border-bottom:2px solid var(--trp-settings-accent-color);color:var(--trp-settings-accent-color)}.trp-lc-mode-button.active svg path[data-v-446a0a1f]{fill:var(--trp-settings-accent-color)}.trp-lc-settings-panel[data-v-446a0a1f]{display:flex;flex-direction:column;gap:16px}.trp-lc-section[data-v-446a0a1f]{display:flex;flex-direction:column;gap:24px}.trp-lc-subfield[data-v-446a0a1f] .trp-radio-group__wrapper{display:flex;flex-direction:column;gap:8px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/LayoutCustomizerField.vue"],names:[],mappings:"AA4OA,yCACI,iBACJ,CAEA,8CACI,YAAa,CACb,qBAAsB,CACtB,QACJ,CAEA,qCACI,YAAa,CACb,OACJ,CAEA,qCAKI,eAAgB,CAChB,WAAY,CAFZ,cAAe,CAHf,YAAa,CACb,OAAQ,CACR,iBAIJ,CAEA,4CAEI,wDAAyD,CADzD,sCAEJ,CAEA,qDACI,qCACJ,CAGA,wCACI,YAAa,CACb,qBAAsB,CACtB,QACJ,CAEA,iCACI,YAAa,CACb,qBAAsB,CACtB,QACJ,CAEA,4DAAoD,YAAa,CAAE,qBAAsB,CAAE,OAAU",sourcesContent:['<script setup>\r\nimport { reactive, watch, computed } from \'vue\'\r\nimport { usePreviewViewport }        from "../../composables/usePreviewViewport"\r\n\r\nimport RadioGroupField from \'./RadioGroupField.vue\'\r\n\r\nconst positionOptions = [\r\n    { value: \'bottom-right\', label: \'Bottom Right\' },\r\n    { value: \'bottom-left\',  label: \'Bottom Left\'  },\r\n    { value: \'top-right\',    label: \'Top Right\'    },\r\n    { value: \'top-left\',     label: \'Top Left\'     }\r\n]\r\n\r\nconst flagIconOptions = [\r\n    { value: \'before\', label: \'Before Language\' },\r\n    { value: \'after\',  label: \'After Language\'  },\r\n    { value: \'hide\',   label: \'Hide Icons\'      }\r\n]\r\n\r\n// For menu scope\r\nconst flagShapeOptions = [\r\n    { value: \'rect\',     label: \'Rectangle 4:3\' },\r\n    { value: \'square\',   label: \'Square 1:1\'    },\r\n    { value: \'rounded\',  label: \'Rounded\'   }\r\n]\r\n\r\nconst languageNameOptions = [\r\n    { value: \'full\',  label: \'Full Names\'  },\r\n    { value: \'short\', label: \'Short Names\' },\r\n    { value: \'none\',  label: \'No Names\'    }\r\n]\r\n\r\nconst props = defineProps({\r\n    label:      { type: String, default: \'\' },\r\n    modelValue: {\r\n        type: Object,\r\n        default: () => ({\r\n            desktop: {},\r\n            mobile : {}\r\n        })\r\n    },\r\n    scope: {\r\n        type: String,\r\n        required: true\r\n    }\r\n})\r\nconst emit = defineEmits([\'update:modelValue\', \'update:customValue\'])\r\n\r\nconst local = reactive({\r\n    desktop: { ...props.modelValue.desktop },\r\n    mobile:  { ...props.modelValue.mobile  }\r\n})\r\n\r\nwatch(\r\n    () => local,\r\n    (val) => { emit(\'update:modelValue\', { desktop: { ...val.desktop }, mobile: { ...val.mobile } }) },\r\n    { deep: true }\r\n)\r\n\r\nwatch(\r\n    () => props.modelValue,\r\n    (val) => {\r\n        if (val.desktop) Object.assign(local.desktop, val.desktop)\r\n        if (val.mobile)  Object.assign(local.mobile,  val.mobile)\r\n    }\r\n)\r\n\r\nconst { selectedViewport: currentMode, setViewport } = usePreviewViewport(props.scope)\r\n\r\nconst isShortcode = props.scope === \'shortcode\'\r\nconst isMenu      = props.scope === \'menu\'\r\nconst isFloater   = props.scope === \'floater\'\r\n\r\n/** TODO: I think we should generate the fields dynamically in case further changes will be made to this component. */\r\n<\/script>\r\n\r\n<template>\r\n    <div class="trp-layout-customizer-field trp-field trp-field--column">\r\n    <span\r\n        v-if="label"\r\n        class="trp-field__label trp-primary-text-bold"\r\n    >{{ label }}</span>\r\n\r\n        <div v-if="scope === \'menu\'" class="trp-settings-separator"></div>\r\n\r\n        \x3c!-- viewport toggle --\x3e\r\n        <div class="trp-lc-mode-toggle">\r\n            <button\r\n                :class="[\'trp-lc-mode-button\', { active: currentMode === \'desktop\' }]"\r\n                @click="setViewport(\'desktop\')"\r\n                type="button"\r\n            >\r\n                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">\r\n                    <path fill-rule="evenodd" clip-rule="evenodd"\r\n                          d="M3 2H17C17.55 2 18 2.45 18 3V13C18 13.55 17.55 14 17 14H12V16H14\r\n                   C14.55 16 15 16.45 15 17V18H5V17C5 16.45 5.45 16 6 16H8V14H3\r\n                   C2.45 14 2 13.55 2 13V3C2 2.45 2.45 2 3 2ZM16 11V4H4V11H16Z" fill="#1D2327"/>\r\n                </svg>\r\n                <span>Desktop</span>\r\n            </button>\r\n\r\n            <button\r\n                :class="[\'trp-lc-mode-button\', { active: currentMode === \'mobile\' }]"\r\n                @click="setViewport(\'mobile\')"\r\n                type="button"\r\n            >\r\n                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">\r\n                    <path fill-rule="evenodd" clip-rule="evenodd"\r\n                          d="M6 2H14C14.55 2 15 2.45 15 3V17C15 17.55 14.55 18 14 18H6\r\n                   C5.45 18 5 17.55 5 17V3C5 2.45 5.45 2 6 2ZM13 14V4H7V14H13Z" fill="#1D2327"/>\r\n                </svg>\r\n                <span>Mobile</span>\r\n            </button>\r\n        </div>\r\n\r\n        <div class="trp-lc-settings-panel">\r\n            \x3c!-- DESKTOP --\x3e\r\n            <template v-if="currentMode === \'desktop\'">\r\n                <div class="trp-lc-section">\r\n                    \x3c!-- position / width / padding only when NOT shortcode --\x3e\r\n                    <template v-if="isFloater">\r\n                        <div class="trp-lc-subfield">\r\n                            <RadioGroupField\r\n                                label="Switcher Position"\r\n                                v-model="local.desktop.position"\r\n                                :options="positionOptions"\r\n                            />\r\n                        </div>\r\n\r\n                        <div class="trp-lc-subfield">\r\n                            <RadioGroupField\r\n                                label="Switcher Width"\r\n                                v-model="local.desktop.width"\r\n                                v-model:customValue="local.desktop.customWidth"\r\n                                :options="[ { value: \'default\', label: \'Default\' } ]"\r\n                            />\r\n                        </div>\r\n\r\n                        <div class="trp-lc-subfield">\r\n                            <RadioGroupField\r\n                                label="Switcher Padding"\r\n                                v-model="local.desktop.padding"\r\n                                v-model:customValue="local.desktop.customPadding"\r\n                                :options="[ { value: \'default\', label: \'Default\' } ]"\r\n                            />\r\n                        </div>\r\n                    </template>\r\n\r\n                    <div class="trp-lc-subfield">\r\n                        <RadioGroupField\r\n                            label="Flag Icons Position"\r\n                            v-model="local.desktop.flagIconPosition"\r\n                            :options="flagIconOptions"\r\n                        />\r\n                    </div>\r\n\r\n\r\n                    <div v-if="isMenu" class="trp-lc-subfield">\r\n                        <RadioGroupField\r\n                            label="Flag icons"\r\n                            v-model="local.desktop.flagShape"\r\n                            :options="flagShapeOptions"\r\n                        />\r\n                    </div>\r\n\r\n                    <div class="trp-lc-subfield">\r\n                        <RadioGroupField\r\n                            label="Language Names"\r\n                            v-model="local.desktop.languageNames"\r\n                            :options="languageNameOptions"\r\n                        />\r\n                    </div>\r\n                </div>\r\n            </template>\r\n\r\n            \x3c!-- MOBILE --\x3e\r\n            <template v-else>\r\n                <div class="trp-lc-section">\r\n                    <template v-if="isFloater">\r\n                        <div class="trp-lc-subfield">\r\n                            <RadioGroupField\r\n                                label="Switcher Position"\r\n                                v-model="local.mobile.position"\r\n                                :options="positionOptions"\r\n                            />\r\n                        </div>\r\n\r\n                        <div class="trp-lc-subfield">\r\n                            <RadioGroupField\r\n                                label="Switcher Width"\r\n                                v-model="local.mobile.width"\r\n                                v-model:customValue="local.mobile.customWidth"\r\n                                :options="[ { value: \'default\', label: \'Default\' } ]"\r\n                            />\r\n                        </div>\r\n\r\n                        <div class="trp-lc-subfield">\r\n                            <RadioGroupField\r\n                                label="Switcher Padding"\r\n                                v-model="local.mobile.padding"\r\n                                v-model:customValue="local.mobile.customPadding"\r\n                                :options="[ { value: \'default\', label: \'Default\' } ]"\r\n                            />\r\n                        </div>\r\n                    </template>\r\n\r\n                    <div class="trp-lc-subfield">\r\n                        <RadioGroupField\r\n                            label="Flag Icons Position"\r\n                            v-model="local.mobile.flagIconPosition"\r\n                            :options="flagIconOptions"\r\n                        />\r\n                    </div>\r\n\r\n                    <div v-if="isMenu" class="trp-lc-subfield">\r\n                        <RadioGroupField\r\n                            label="Flag icons"\r\n                            v-model="local.desktop.flagShape"\r\n                            :options="flagShapeOptions"\r\n                        />\r\n                    </div>\r\n\r\n                    <div class="trp-lc-subfield">\r\n                        <RadioGroupField\r\n                            label="Language Names"\r\n                            v-model="local.mobile.languageNames"\r\n                            :options="languageNameOptions"\r\n                        />\r\n                    </div>\r\n                </div>\r\n            </template>\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-settings-separator {\r\n    margin-bottom: 8px;\r\n}\r\n\r\n.trp-layout-customizer-field {\r\n    display: flex;\r\n    flex-direction: column;\r\n    gap: 16px;\r\n}\r\n\r\n.trp-lc-mode-toggle {\r\n    display: flex;\r\n    gap: 8px;\r\n}\r\n\r\n.trp-lc-mode-button {\r\n    display: flex;\r\n    gap: 4px;\r\n    padding: 0 8px 8px 8px;\r\n    cursor: pointer;\r\n    background: none;\r\n    border: none;\r\n}\r\n\r\n.trp-lc-mode-button.active {\r\n    color: var(--trp-settings-accent-color);\r\n    border-bottom: 2px solid var(--trp-settings-accent-color);\r\n}\r\n\r\n.trp-lc-mode-button.active svg path {\r\n    fill: var(--trp-settings-accent-color);\r\n}\r\n\r\n/* panel & sections */\r\n.trp-lc-settings-panel {\r\n    display: flex;\r\n    flex-direction: column;\r\n    gap: 16px;\r\n}\r\n\r\n.trp-lc-section   {\r\n    display: flex;\r\n    flex-direction: column;\r\n    gap: 24px;\r\n}\r\n\r\n.trp-lc-subfield :deep(.trp-radio-group__wrapper) { display: flex; flex-direction: column; gap: 8px; }\r\n\r\n</style>\r\n'],sourceRoot:""}]);const a=s},101:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-language-switcher-preview__container[data-v-b9e7100a]{display:flex;flex-direction:column;gap:24px}.trp-language-switcher-preview-box[data-v-b9e7100a]{background-image:var(--v0a032f7b);background-repeat:no-repeat;background-size:cover;border:1px solid #e2e2e4;border-radius:var(--trp-settings-radius-small);height:220px;overflow:hidden;position:relative}.trp-language-switcher-preview-box .trp-floating-switcher:hover .trp-switcher-dropdown-list[data-v-b9e7100a]{max-height:150px}.trp-floating-switcher[data-v-b9e7100a]:hover{overflow-y:auto}.trp-language-switcher[data-v-b9e7100a]{background:var(--bg);border-color:var(--border-color);border-radius:var(--border-radius);border-style:solid;border-width:var(--border-width);bottom:var(--bottom,unset);box-shadow:0 10px 20px 0 #0000000d;display:flex;flex-direction:column-reverse;left:var(--left,unset);overflow:hidden;padding:var(--switcher-padding);position:absolute;right:var(--right,unset);top:var(--top,unset);transition:.2s ease;width:var(--switcher-width)}.trp-switcher-position-top.trp-language-switcher[data-v-b9e7100a]{flex-direction:column}.trp-language-switcher-inner[data-v-b9e7100a]{display:flex;flex-direction:column-reverse}.trp-preview-ls-inline .trp-language-switcher-inner[data-v-b9e7100a]{flex-direction:row;justify-content:space-between}.trp-switcher-position-top.trp-ls-dropdown .trp-language-switcher-inner[data-v-b9e7100a],.trp-switcher-position-top.trp-ls-dropdown .trp-switcher-dropdown-list[data-v-b9e7100a]{flex-direction:column}.trp-ls-dropdown:not(:hover) .trp-language-item[data-v-b9e7100a]{pointer-events:none}.trp-switcher-dropdown-list[data-v-b9e7100a]{max-height:0;overflow:hidden;scrollbar-color:var(--text) transparent;scrollbar-width:thin;transition:.2s ease-in-out;transition-duration:var(--transition-duration)}.trp-language-switcher.trp-shortcode-switcher[data-v-b9e7100a]{border:var(--border-width) solid var(--border-color);flex-direction:column;left:50%;overflow-y:hidden;padding:10px 0;top:35%;transform:translateX(-50%);transition:none;width:auto}.trp-language-switcher.trp-shortcode-switcher .trp-language-switcher-inner[data-v-b9e7100a]{flex-direction:column}.trp-current-language-item__wrapper[data-v-b9e7100a]{align-items:center;display:flex;flex-direction:row;justify-content:space-between;padding-right:8px}.trp-shortcode-switcher.trp-dropdown-open .trp-shortcode-arrow[data-v-b9e7100a]{transform:rotate(180deg)}.trp-language-switcher.trp-shortcode-switcher.trp-open-on-hover:hover .trp-switcher-dropdown-list[data-v-b9e7100a],.trp-open-on-click.trp-dropdown-open .trp-switcher-dropdown-list[data-v-b9e7100a]{max-height:75px;overflow-y:auto}.trp-open-on-click .trp-current-language-item__wrapper[data-v-b9e7100a]{cursor:pointer}.trp-shortcode-arrow[data-v-b9e7100a]{pointer-events:none}.trp-shortcode-switcher.trp-opposite-button[data-v-b9e7100a]{border-radius:var(--border-radius);overflow:hidden;padding:var(--switcher-padding,10px 12px);transition:none;width:auto}.trp-shortcode-switcher.trp-opposite-button .trp-current-language-item__wrapper[data-v-b9e7100a]{cursor:default}.trp-shortcode-switcher .trp-current-language-item__wrapper.trp-hide-arrow .trp-shortcode-arrow[data-v-b9e7100a]{display:none}.trp-shortcode-switcher.trp-opposite-button .trp-switcher-dropdown-list[data-v-b9e7100a]{display:none!important;max-height:0!important;overflow:hidden!important}.trp-shortcode-switcher.trp-opposite-button.trp-open-on-hover:hover .trp-switcher-dropdown-list[data-v-b9e7100a]{display:none!important}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/LanguageSwitcherPreview.vue"],names:[],mappings:"AAkMI,2DACI,YAAa,CACb,qBAAsB,CACtB,QACJ,CAEA,oDACI,iCAA+B,CAC/B,2BAA4B,CAC5B,qBAAsB,CAItB,wBAAyB,CADzB,8CAA+C,CAF/C,YAAa,CAIb,eAAgB,CAHhB,iBAIJ,CAEA,6GACI,gBACJ,CAEA,8CACI,eACJ,CAEA,wCAcI,oBAAqB,CAFrB,gCAAiC,CADjC,kCAAmC,CAEnC,kBAAmB,CAHnB,gCAAiC,CANjC,0BAA4B,CAY5B,kCAAmC,CAfnC,YAAa,CACb,6BAA8B,CAI9B,sBAAwB,CAExB,eAAgB,CAChB,+BAAgC,CANhC,iBAAkB,CAIlB,wBAA0B,CAF1B,oBAAsB,CAYtB,mBAAqB,CAFrB,2BAGJ,CAEA,kEACI,qBACJ,CAEA,8CACI,YAAa,CACb,6BACJ,CAEA,qEACI,kBAAmB,CACnB,6BACJ,CAEA,iLACI,qBACJ,CAEA,iEACI,mBACJ,CAEA,6CACI,YAAa,CACb,eAAgB,CAGhB,uCAAwC,CADxC,oBAAqB,CADrB,0BAA4B,CAG5B,8CACJ,CAGA,+DAII,oDAAqD,CAKrD,qBAAsB,CAPtB,QAAS,CAGT,iBAAkB,CAElB,cAAe,CANf,OAAQ,CAER,0BAA2B,CAG3B,eAAgB,CAEhB,UAEJ,CAEA,4FACI,qBACJ,CAEA,qDAGI,kBAAmB,CAFnB,YAAa,CACb,kBAAmB,CAEnB,6BAA8B,CAC9B,iBACJ,CAEA,gFACI,wBACJ,CAOA,qMACI,eAAgB,CAChB,eACJ,CAEA,wEACI,cACJ,CAEA,sCACI,mBACJ,CAEA,6DAEI,kCAAmC,CAEnC,eAAgB,CAHhB,yCAA2C,CAI3C,eAAgB,CAFhB,UAGJ,CAGA,iGACI,cACJ,CAGA,iHACI,YACJ,CAGA,yFACI,sBAAwB,CACxB,sBAAwB,CACxB,yBACJ,CAGA,iHACI,sBACJ",sourcesContent:['<script setup>\r\nimport { useSwitcherPreview } from "../composables/useSwitcherPreview"\r\nimport { computed, ref }        from "vue"\r\n\r\nimport LanguageItem from "./LanguageItem.vue"\r\nimport PoweredBy    from "./PoweredBy.vue"\r\n\r\nimport { __ } from \'../composables/utils/i18n\'\r\n\r\nconst bgUrl = `url(${window.tpLangSwitcherData.misc.pluginUrl}assets/images/switcher-preview-bg.png)`\r\n\r\nconst props = defineProps({\r\n    scope: {\r\n      type: String,\r\n      default: \'\',\r\n      validator: v => [\'floater\',\'shortcode\',\'menu\'].includes(v)\r\n    }\r\n})\r\n\r\nconst isOpen = ref(false)\r\n\r\nconst toggleDropdown = () => openOnClick.value && ( isOpen.value = !isOpen.value )\r\n\r\nconst isShortcode = computed(() => props.scope === \'shortcode\')\r\n\r\nconst previewBoxText = __( \'Hover over the language switcher to see it in action!\')\r\n\r\nconst switcherEdgeClass = computed(() => {\r\n    if (props.scope !== \'floater\') return null\r\n\r\n    if (switcherPosition.value?.startsWith(\'top\')) return \'trp-switcher-position-top\'\r\n    if (switcherPosition.value?.startsWith(\'bottom\')) return \'trp-switcher-position-bottom\'\r\n\r\n    return null\r\n})\r\n\r\nconst {\r\n    displayedList,\r\n    isDropdown,\r\n    switcherStyles,\r\n    isOppositeMode,\r\n    showPoweredBy,\r\n    switcherPosition,\r\n    openOnClick\r\n} = useSwitcherPreview(props.scope)\r\n\r\nconst allowShortcodeToggle = computed(() => isShortcode.value && !isOppositeMode.value && openOnClick.value)\r\n\r\nconst shortcodeClasses = computed(() => {\r\n    if (!isShortcode.value) return []\r\n    return [\r\n        isOppositeMode.value ? \'trp-opposite-button\' : null,\r\n        allowShortcodeToggle.value ? \'trp-open-on-click\' : \'trp-open-on-hover\',\r\n        { \'trp-dropdown-open\': isOpen.value && !isOppositeMode.value }\r\n    ]\r\n})\r\n\r\nconst onShortcodeClick = () => {\r\n    if (!isShortcode.value || isOppositeMode.value) return\r\n    if (openOnClick.value) isOpen.value = !isOpen.value\r\n}\r\n<\/script>\r\n\r\n<template>\r\n    <div class="trp-language-switcher-preview__container">\r\n        <div class="trp-language-switcher-preview-box">\r\n            \x3c!-- Floater view, opposite mode --\x3e\r\n            <template v-if="isOppositeMode && !isShortcode">\r\n                <div\r\n                    class="trp-language-switcher trp-floating-switcher trp-opposite-button"\r\n                    :style="switcherStyles"\r\n                >\r\n                    <LanguageItem\r\n                        v-if="displayedList.length"\r\n                        :key="displayedList[0].code"\r\n                        :language="displayedList[0]"\r\n                    />\r\n\r\n                    <PoweredBy v-if="showPoweredBy" />\r\n                </div>\r\n            </template>\r\n\r\n            \x3c!-- Floater view, normal display --\x3e\r\n            <template v-else-if="!isShortcode">\r\n                <div\r\n                    v-if="isDropdown"\r\n                    class="trp-language-switcher trp-floating-switcher trp-ls-dropdown"\r\n                    :class="switcherEdgeClass"\r\n                    :style="switcherStyles"\r\n                >\r\n                    <PoweredBy v-if="showPoweredBy" />\r\n\r\n                    <div class="trp-language-switcher-inner">\r\n                        <LanguageItem\r\n                            v-if="displayedList.length"\r\n                            :key="displayedList[0].code"\r\n                            :language="displayedList[0]"\r\n                            :dropdown="false"\r\n                            class="trp-language-item__default"\r\n                        />\r\n\r\n                        <div class="trp-switcher-dropdown-list">\r\n                            <LanguageItem\r\n                                v-for="lang in displayedList.slice(1)"\r\n                                :key="lang.code"\r\n                                :language="lang"\r\n                                :dropdown="true"\r\n                            />\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div\r\n                    v-else\r\n                    class="trp-language-switcher trp-preview-ls-inline"\r\n                    :class="switcherEdgeClass"\r\n                    :style="switcherStyles"\r\n                >\r\n                    <PoweredBy v-if="showPoweredBy" />\r\n\r\n                    <div class="trp-language-switcher-inner">\r\n                        <LanguageItem\r\n                            v-for="lang in displayedList"\r\n                            :key="lang.code"\r\n                            :language="lang"\r\n                        />\r\n                    </div>\r\n                </div>\r\n            </template>\r\n\r\n            \x3c!-- Shortcode view --\x3e\r\n            <template v-else>\r\n                <div\r\n                    class="trp-language-switcher trp-ls-dropdown trp-shortcode-switcher"\r\n                    :class="shortcodeClasses"\r\n                    :style="switcherStyles"\r\n                    @click="onShortcodeClick"\r\n                >\r\n                    <div class="trp-language-switcher-inner">\r\n                        <div class="trp-current-language-item__wrapper" :class="{ \'trp-hide-arrow\': isOppositeMode }">\r\n                            <LanguageItem\r\n                                v-if="displayedList.length"\r\n                                :key="displayedList[0].code"\r\n                                :language="displayedList[0]"\r\n                                :dropdown="false"\r\n                                class="trp-language-item__default"\r\n                            />\r\n\r\n                            \x3c!-- Arrow is visually hidden in opposite mode via CSS --\x3e\r\n                            <svg\r\n                                class="trp-shortcode-arrow"\r\n                                width="20"\r\n                                height="20"\r\n                                viewBox="0 0 20 21"\r\n                                fill="none"\r\n                                xmlns="http://www.w3.org/2000/svg"\r\n                            >\r\n                                <path\r\n                                    d="M5 8L10 13L15 8"\r\n                                    stroke="var(--text)"\r\n                                    stroke-width="2"\r\n                                    stroke-linecap="round"\r\n                                    stroke-linejoin="round"\r\n                                />\r\n                            </svg>\r\n                        </div>\r\n\r\n                        \x3c!-- Dropdown list is removed in opposite mode --\x3e\r\n                        <div\r\n                            v-if="!isOppositeMode"\r\n                            class="trp-switcher-dropdown-list"\r\n                        >\r\n                            <LanguageItem\r\n                                v-for="lang in displayedList.slice(1)"\r\n                                :key="lang.code"\r\n                                :language="lang"\r\n                                :dropdown="true"\r\n                            />\r\n                        </div>\r\n                    </div>\r\n\r\n                    <PoweredBy v-if="showPoweredBy && isOppositeMode" />\r\n                </div>\r\n            </template>\r\n\r\n        </div>\r\n\r\n        <span class="trp-language-switcher-preview-text trp-description-text">\r\n            {{ previewBoxText }}\r\n        </span>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n    .trp-language-switcher-preview__container{\r\n        display: flex;\r\n        flex-direction: column;\r\n        gap: 24px;\r\n    }\r\n\r\n    .trp-language-switcher-preview-box {\r\n        background-image: v-bind(bgUrl);\r\n        background-repeat: no-repeat;\r\n        background-size: cover;\r\n        height: 220px;\r\n        position: relative;\r\n        border-radius: var(--trp-settings-radius-small);\r\n        border: 1px solid #E2E2E4;\r\n        overflow: hidden;\r\n    }\r\n\r\n    .trp-language-switcher-preview-box .trp-floating-switcher:hover .trp-switcher-dropdown-list {\r\n        max-height: 150px;\r\n    }\r\n\r\n    .trp-floating-switcher:hover {\r\n        overflow-y: auto;\r\n    }\r\n\r\n    .trp-language-switcher {\r\n        display: flex;\r\n        flex-direction: column-reverse;\r\n        position: absolute;\r\n        bottom: var(--bottom, unset);\r\n        top: var(--top, unset);\r\n        left: var(--left, unset);\r\n        right: var(--right, unset);\r\n        overflow: hidden;\r\n        padding: var(--switcher-padding);\r\n        border-width: var(--border-width);\r\n        border-radius: var(--border-radius);\r\n        border-color: var(--border-color);\r\n        border-style: solid;\r\n        background: var(--bg);\r\n        width: var(--switcher-width);\r\n        box-shadow: 0 10px 20px 0 #0000000D;\r\n        transition: 0.2s ease;\r\n    }\r\n\r\n    .trp-switcher-position-top.trp-language-switcher {\r\n        flex-direction: column;\r\n    }\r\n\r\n    .trp-language-switcher-inner {\r\n        display: flex;\r\n        flex-direction: column-reverse;\r\n    }\r\n\r\n    .trp-preview-ls-inline .trp-language-switcher-inner {\r\n        flex-direction: row;\r\n        justify-content: space-between;\r\n    }\r\n\r\n    .trp-switcher-position-top.trp-ls-dropdown .trp-language-switcher-inner, .trp-switcher-position-top.trp-ls-dropdown .trp-switcher-dropdown-list{\r\n        flex-direction: column;\r\n    }\r\n\r\n    .trp-ls-dropdown:not(:hover) .trp-language-item {\r\n        pointer-events: none;\r\n    }\r\n\r\n    .trp-switcher-dropdown-list {\r\n        max-height: 0;\r\n        overflow: hidden;\r\n        transition: 0.2s ease-in-out;\r\n        scrollbar-width: thin;\r\n        scrollbar-color: var(--text) transparent;\r\n        transition-duration: var(--transition-duration);\r\n    }\r\n\r\n    /* Shortcode styling */\r\n    .trp-language-switcher.trp-shortcode-switcher {\r\n        top: 35%;\r\n        left: 50%;\r\n        transform: translateX(-50%);\r\n        border: var(--border-width) solid var(--border-color);\r\n        overflow-y: hidden;\r\n        transition: none;\r\n        padding: 10px 0;\r\n        width: auto;\r\n        flex-direction: column;\r\n    }\r\n\r\n    .trp-language-switcher.trp-shortcode-switcher .trp-language-switcher-inner {\r\n        flex-direction: column;\r\n    }\r\n\r\n    .trp-current-language-item__wrapper {\r\n        display: flex;\r\n        flex-direction: row;\r\n        align-items: center;\r\n        justify-content: space-between;\r\n        padding-right: 8px;\r\n    }\r\n\r\n    .trp-shortcode-switcher.trp-dropdown-open .trp-shortcode-arrow {\r\n        transform: rotate(180deg);\r\n    }\r\n\r\n    .trp-language-switcher.trp-shortcode-switcher.trp-open-on-hover:hover .trp-switcher-dropdown-list {\r\n        max-height: 75px;\r\n        overflow-y: auto;\r\n    }\r\n\r\n    .trp-open-on-click.trp-dropdown-open .trp-switcher-dropdown-list {\r\n        max-height: 75px;\r\n        overflow-y: auto;\r\n    }\r\n\r\n    .trp-open-on-click .trp-current-language-item__wrapper {\r\n        cursor: pointer;\r\n    }\r\n\r\n    .trp-shortcode-arrow {\r\n        pointer-events: none;\r\n    }\r\n\r\n    .trp-shortcode-switcher.trp-opposite-button {\r\n        padding: var(--switcher-padding, 10px 12px);\r\n        border-radius: var(--border-radius);\r\n        width: auto;\r\n        overflow: hidden;     /* no inner scroll in opposite */\r\n        transition: none;     /* no hover expand */\r\n    }\r\n\r\n    /* Don’t treat current item like a toggle in opposite mode */\r\n    .trp-shortcode-switcher.trp-opposite-button .trp-current-language-item__wrapper {\r\n        cursor: default;\r\n    }\r\n\r\n    /* Hide the arrow when opposite */\r\n    .trp-shortcode-switcher .trp-current-language-item__wrapper.trp-hide-arrow .trp-shortcode-arrow {\r\n        display: none;\r\n    }\r\n\r\n    /* Ensure no dropdown animation space is reserved in opposite */\r\n    .trp-shortcode-switcher.trp-opposite-button .trp-switcher-dropdown-list {\r\n        display: none !important;\r\n        max-height: 0 !important;\r\n        overflow: hidden !important;\r\n    }\r\n\r\n    /* Prevent hover-expansion rules affecting opposite mode */\r\n    .trp-shortcode-switcher.trp-opposite-button.trp-open-on-hover:hover .trp-switcher-dropdown-list {\r\n        display: none !important;\r\n    }\r\n\r\n</style>'],sourceRoot:""}]);const a=s},111:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,"#trp-floater-powered-by[data-v-2764dcda]{color:var(--text,#b3b3b3)!important;font-size:12px;padding:0 5px;text-align:center}#trp-floater-powered-by[data-v-2764dcda] a{color:var(--text,#b3b3b3)}.trp-switcher-position-bottom #trp-floater-powered-by[data-v-2764dcda]{border-top:1px solid var(--text,#747474);margin-top:5px;padding-top:5px}.trp-switcher-position-top #trp-floater-powered-by[data-v-2764dcda]{border-bottom:1px solid var(--text,#747474);margin-bottom:5px;padding-bottom:5px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/PoweredBy.vue"],names:[],mappings:"AAYA,yCACI,mCAAsC,CACtC,cAAe,CAEf,aAAc,CADd,iBAEJ,CAEA,2CACI,yBACJ,CAEA,uEACI,wCAA0C,CAE1C,cAAe,CADf,eAEJ,CAEA,oEACI,2CAA6C,CAE7C,iBAAkB,CADlB,kBAEJ",sourcesContent:["<script setup>\r\nimport { __ } from '../composables/utils/i18n'\r\n<\/script>\r\n\r\n<template>\r\n    <div id=\"trp-floater-powered-by\">\r\n    \x3c!-- [utm3] --\x3e\r\n        <span v-html=\"__('Powered by <a href=&quot;https://translatepress.com/?utm_source=frontend-ls&amp;utm_medium=client-site&amp;utm_campaign=powered-by-tp&quot; rel=&quot;nofollow&quot; target=&quot;_blank&quot; title=&quot;WordPress Translation Plugin&quot;>TranslatePress</a>')\"></span>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n#trp-floater-powered-by {\r\n    color: var(--text, #b3b3b3) !important;\r\n    font-size: 12px;\r\n    text-align: center;\r\n    padding: 0 5px;\r\n}\r\n\r\n#trp-floater-powered-by :deep(a) {\r\n    color: var(--text, #b3b3b3);\r\n}\r\n\r\n.trp-switcher-position-bottom #trp-floater-powered-by {\r\n    border-top: 1px solid var(--text, #747474);\r\n    padding-top: 5px;\r\n    margin-top: 5px;\r\n}\r\n\r\n.trp-switcher-position-top #trp-floater-powered-by {\r\n    border-bottom: 1px solid var(--text, #747474);\r\n    padding-bottom: 5px;\r\n    margin-bottom: 5px;\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},139:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-radio-group[data-v-e2617dbe]{display:flex;gap:16px}.trp-radio-label[data-v-e2617dbe]{cursor:pointer}.trp-lc-custom-number[data-v-e2617dbe]{margin-left:8px}.trp-radio-option[data-v-e2617dbe]{align-items:center;cursor:pointer;display:flex;line-height:20px;min-width:140px}.trp-radio-option.is-disabled[data-v-e2617dbe]{opacity:.5}.trp-radio-option.is-disabled input[data-v-e2617dbe]{background:var(--trp-settings-disabled-color);pointer-events:none}.trp-radio-option input[data-v-e2617dbe]{border:1px solid var(--trp-settings-medium-gray-border-color);height:20px;position:relative;width:20px}.trp-radio-option input[data-v-e2617dbe]:checked:before{background-color:var(--trp-settings-accent-color);height:10px;left:50%;margin:0;position:absolute;top:50%;transform:translate(-50%,-50%);width:10px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/RadioGroupField.vue"],names:[],mappings:"AAmGA,kCACI,YAAY,CACZ,QACJ,CAEA,kCACI,cACJ,CAEA,uCACI,eACJ,CAEA,mCAKI,kBAAmB,CAJnB,cAAe,CAGf,YAAa,CAFb,gBAAiB,CACjB,eAGJ,CAEA,+CACI,UACJ,CAEA,qDAEI,6CAA8C,CAD9C,mBAEJ,CAEA,yCACI,6DAA8D,CAE9D,WAAY,CACZ,iBAAkB,CAFlB,UAGJ,CAEA,wDAQI,iDAAkD,CALlD,WAAY,CAEZ,QAAS,CAET,QAAS,CANT,iBAAkB,CAGlB,OAAQ,CAER,8BAAgC,CAJhC,UAOJ",sourcesContent:["<script setup>\r\nimport { computed, ref, watch } from 'vue'\r\n\r\nimport NumberField from './NumberField.vue'\r\n\r\nconst props = defineProps({\r\n    label:       { type: String, required: false, default: '' },\r\n    modelValue:  { type: String, required: true },\r\n    options:     {\r\n        type: Array,\r\n        required: true,\r\n        validator: arr => arr.every(o =>\r\n            'value' in o && 'label' in o &&\r\n            (o.disabled === undefined || typeof o.disabled === 'boolean') &&\r\n            (o.title    === undefined || typeof o.title    === 'string')\r\n        )\r\n    },\r\n    customValue: { type: [Number, String] }, // (optional) a number v-model. If parent binds this prop, then “Custom” is automatically injected as an extra option.\r\n})\r\n\r\nconst emit = defineEmits(['update:modelValue', 'update:customValue'])\r\n\r\nconst localCustom = ref(props.customValue)\r\n\r\n// Sync parent -> localCustom whenever customValue prop changes\r\nwatch(\r\n    () => props.customValue,\r\n    (newVal) => {\r\n        if (newVal !== localCustom.value) {\r\n            localCustom.value = newVal\r\n        }\r\n    }\r\n)\r\n\r\n// Sync localCustom -> parent via update:customValue\r\nwatch(localCustom, (newVal) => {\r\n    emit('update:customValue', newVal)\r\n})\r\n\r\nconst shouldShowCustom = computed(() => props.customValue !== undefined)\r\n\r\n/** Build the array of options we actually render.\r\n *  If shouldShowCustom is true, append { value: 'custom', label: 'Custom' }\r\n *  unless the user already provided an option whose value is \"custom\".\r\n */\r\nconst displayedOptions = computed(() => {\r\n    if (!shouldShowCustom.value)\r\n        return props.options\r\n\r\n    // If parent’s options already include value = 'custom', don’t duplicate\r\n    const hasCustomAlready = props.options.some(o => o.value === 'custom')\r\n\r\n    if (hasCustomAlready)\r\n        return props.options\r\n\r\n    return [\r\n        ...props.options,\r\n        { value: 'custom', label: 'Custom' }\r\n    ]\r\n})\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-radio-group__wrapper\">\r\n        <span v-if=\"label\" class=\"trp-field__label trp-primary-text-bold\">{{ label }}</span>\r\n\r\n        <div class=\"trp-radio-group\">\r\n            <div\r\n                v-for=\"opt in displayedOptions\"\r\n                :key=\"opt.value\"\r\n                :class=\"['trp-radio-option', { 'is-disabled': opt.disabled }]\"\r\n                :title=\"opt.title\"\r\n            >\r\n                <label class=\"trp-radio-label\">\r\n                    <input\r\n                        type=\"radio\"\r\n                        :name=\"label || 'radio-group'\"\r\n                        :value=\"opt.value\"\r\n                        :checked=\"modelValue === opt.value\"\r\n                        :disabled=\"opt.disabled\"\r\n                        @change=\"() => emit('update:modelValue', opt.value)\"\r\n                    />\r\n                    <span>{{ opt.label }}</span>\r\n                </label>\r\n\r\n                <NumberField\r\n                    v-if=\"shouldShowCustom && opt.value === 'custom' && modelValue === 'custom'\"\r\n                    class=\"trp-lc-custom-number\"\r\n                    v-model=\"localCustom\"\r\n                    :label=\"''\"\r\n                    :min=\"0\"\r\n                />\r\n            </div>\r\n\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-radio-group {\r\n    display:flex;\r\n    gap:16px;\r\n}\r\n\r\n.trp-radio-label {\r\n    cursor: pointer;\r\n}\r\n\r\n.trp-lc-custom-number {\r\n    margin-left: 8px;\r\n}\r\n\r\n.trp-radio-option {\r\n    cursor: pointer;\r\n    line-height: 20px;\r\n    min-width: 140px;\r\n    display: flex;\r\n    align-items: center;\r\n}\r\n\r\n.trp-radio-option.is-disabled {\r\n    opacity: 0.5;\r\n}\r\n\r\n.trp-radio-option.is-disabled input {\r\n    pointer-events: none;\r\n    background: var(--trp-settings-disabled-color);\r\n}\r\n\r\n.trp-radio-option input {\r\n    border: 1px solid var(--trp-settings-medium-gray-border-color);\r\n    width: 20px;\r\n    height: 20px;\r\n    position: relative;\r\n}\r\n\r\n.trp-radio-option input:checked:before {\r\n    position: absolute;\r\n    width: 10px;\r\n    height: 10px;\r\n    top: 50%;\r\n    left: 50%;\r\n    transform: translate(-50%, -50%);\r\n    margin: 0;\r\n    background-color: var(--trp-settings-accent-color);\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},147:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-floater-settings__wrapper[data-v-5390537a]{display:flex;flex-direction:row;gap:16px;max-width:1200px;width:100%}.trp-floater-settings__right[data-v-5390537a]{display:flex;flex-direction:column;gap:16px;max-width:641px;width:60%}.trp-floater-settings__left[data-v-5390537a]{width:40%}.trp-sticky-box[data-v-5390537a]{position:sticky;top:50px}","",{version:3,sources:["webpack://./assets/src/language-switcher/views/FloaterConfig.vue"],names:[],mappings:"AA2OA,gDACI,YAAa,CACb,kBAAmB,CACnB,QAAS,CACT,gBAAiB,CACjB,UACJ,CAEA,8CACI,YAAa,CACb,qBAAsB,CACtB,QAAS,CAET,eAAgB,CADhB,SAEJ,CAEA,6CACI,SACJ,CAEA,iCACI,eAAgB,CAChB,QACJ",sourcesContent:["<script setup>\r\nimport SettingsBox                         from '../components/SettingsBox.vue'\r\nimport PresetApplier                       from \"../components/PresetApplier.vue\"\r\nimport LanguageSwitcherPreview             from \"../components/LanguageSwitcherPreview.vue\"\r\nimport SettingsActions                     from \"../components/SettingsActions.vue\"\r\n\r\nimport { useLanguages, useSwitcherConfig } from \"../composables/useSwitcherConfig\"\r\nimport { useLayoutCustomizer }             from \"../composables/layoutCustomizer/useLayoutCustomizer\"\r\nimport { useSwitcherPersistence }          from '../composables/useSwitcherPersistance'\r\n\r\nimport { computed, provide }               from \"vue\"\r\nimport { onBeforeRouteLeave }              from 'vue-router'\r\n\r\nimport { __ } from \"../composables/utils/i18n\"\r\n\r\nconst scope = \"floater\"\r\n\r\nconst cfg = useSwitcherConfig( scope )\r\n\r\nconst persistence = useSwitcherPersistence( scope )\r\n\r\nprovide( 'switcherPersistence', persistence )\r\n\r\nconst { isDirty, revert } = persistence\r\n\r\nconst { positioning } = useLayoutCustomizer( scope )\r\n\r\nconst flagRatio = computed(() => cfg.flagShape )\r\n\r\nconst languageItemSettings = computed(() => ({\r\n    flagPos: positioning.value.flagPos,\r\n    nameMode: positioning.value.languageNames,\r\n    flagRatio: flagRatio\r\n}))\r\n\r\nconst T = {\r\n    switcherPreview: __('Switcher Preview'),\r\n    enableFloating: __('Enable Floating Switcher'),\r\n    switcherEnabled: __('Switcher is enabled'),\r\n    switcherDisabled: __('Switcher is disabled'),\r\n    switcherType: __('Switcher Type'),\r\n    showAsDropdown: __('Show languages as dropdown'),\r\n    showSideBySide: __('Show languages side by side'),\r\n    applyPreset: __('Apply a preset'),\r\n    customizeDesign: __('Customize Design'),\r\n    backgroundColor: __('Background color'),\r\n    backgroundHoverColor: __('Background hover color'),\r\n    textColor: __('Text color'),\r\n    textHoverColor: __('Text hover color'),\r\n    borderColor: __('Switcher border color'),\r\n    borderWidth: __('Switcher border width'),\r\n    borderRadius: __('Switcher border radius'),\r\n    flagTextSize: __('Flag and text size'),\r\n    normal: __('Normal'),\r\n    large: __('Large'),\r\n    flagIconsShape: __('Flag icons shape'),\r\n    rectangle: __('Rectangle (4:3)'),\r\n    square: __('Square (1:1)'),\r\n    flagRadius: __('Flag icons border radius'),\r\n    enableCustomCss: __('Enable custom CSS'),\r\n    customizeLayout: __('Customize Layout'),\r\n    showOppositeLanguage: __('Show opposite language'),\r\n    showPoweredBy: __('Show \"Powered by TranslatePress\"'),\r\n    poweredByDesc: __('Show the small Powered by TranslatePress label in the language switcher.'),\r\n    leaveConfirm: __('You have unsaved changes. Leave anyway?'),\r\n    enableTransitions: __( 'Switcher animations' )\r\n}\r\n\r\nconst oppositeLanguageFieldDescription = __(\r\n    'Transforms the language switcher into a button showing the other available language, not the current one. <br> Only works when there are exactly two languages, the default one and a translation one.'\r\n)\r\n\r\nconst { published } = useLanguages()\r\n\r\nconst publishedLangCount = Object.keys(published).length\r\n\r\nconst aboveTwoLanguages = publishedLangCount > 2\r\n\r\nconst aboveTwoLanguagesTitle = aboveTwoLanguages\r\n    ? __('This option only works when exactly two languages are published.')\r\n    : ''\r\n\r\nonBeforeRouteLeave((to, from, next) => {\r\n    if (!isDirty.value) return next()\r\n\r\n    const ok = window.confirm(__('You have unsaved changes. Leave anyway?'))\r\n\r\n    if (ok) {\r\n        revert()\r\n        next()\r\n    }\r\n\r\n    else\r\n        next(false)\r\n})\r\n\r\nprovide('languageItemSettings', languageItemSettings)\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-floater-settings__wrapper\">\r\n        <div class=\"trp-floater-settings__left\">\r\n            <div class=\"trp-sticky-box\">\r\n                <SettingsBox\r\n                    :title=\"T.switcherPreview\"\r\n                    :scope=scope\r\n                >\r\n                    <LanguageSwitcherPreview :scope=\"scope\"/>\r\n                </SettingsBox>\r\n\r\n                <SettingsActions :scope=\"scope\" />\r\n            </div>\r\n        </div>\r\n        <div class=\"trp-floater-settings__right\">\r\n            <SettingsBox\r\n                :title=\"T.enableFloating\"\r\n                :scope=\"scope\"\r\n                :style=\"{ flexDirection: 'row', gap: '75px' }\"\r\n                :fields=\"[{\r\n                    key: 'enabled',\r\n                    type: 'toggleStatus',\r\n                    onText: T.switcherEnabled,\r\n                    offText: T.switcherDisabled\r\n                }]\"\r\n            />\r\n\r\n            <SettingsBox\r\n                :title=\"T.switcherType\"\r\n                :scope=\"scope\"\r\n                :fields=\"[{\r\n                    key: 'type',\r\n                    type: 'radio',\r\n                    default: 'dropdown',\r\n                    options: [\r\n                        { value: 'dropdown', label: T.showAsDropdown },\r\n                        { value: 'side-by-side', label: T.showSideBySide, disabled: aboveTwoLanguages, title: aboveTwoLanguagesTitle },\r\n                    ]\r\n                }]\"\r\n            />\r\n\r\n            <SettingsBox\r\n                :title=\"T.applyPreset\"\r\n                :scope=\"scope\"\r\n            >\r\n                <PresetApplier :scope=\"scope\" />\r\n            </SettingsBox>\r\n\r\n            <SettingsBox\r\n                :title=\"T.customizeDesign\"\r\n                :scope=\"scope\"\r\n                collapsible\r\n                :style=\"{ '--trp-field-label-width': '190px' }\"\r\n                :fields=\"[\r\n                    { key:  'bgColor',        type: 'color',      label: T.backgroundColor,        default: '#ffffff' },\r\n                    { key:  'bgHoverColor',   type: 'color',      label: T.backgroundHoverColor,   default: '#f5f5f5' },\r\n                    { key:  'textColor',      type: 'color',      label: T.textColor,              default: '#000000' },\r\n                    { key:  'textHoverColor', type: 'color',      label: T.textHoverColor,         default: '#000000' },\r\n                    { key:  'borderColor',    type: 'color',      label: T.borderColor,            default: '#e2e2e4' },\r\n                    { key:  'borderWidth',    type: 'number',     label: T.borderWidth,            default: 1 },\r\n                    { key:  'borderRadius',   type: 'quadNumber', label: T.borderRadius,           default: [8, 8, 0 ,0], layout: 'column' },\r\n                    { type: 'separator' },\r\n                    {\r\n                        key: 'enableTransitions',\r\n                        type: 'toggle',\r\n                        label: T.enableTransitions,\r\n                        default: true\r\n                    },\r\n                    { type: 'separator' },\r\n                    {\r\n                        key: 'size',\r\n                        type: 'radio',\r\n                        label: T.flagTextSize,\r\n                        default: 'normal',\r\n                        options: [\r\n                            { value: 'normal', label: T.normal },\r\n                            { value: 'large',  label: T.large  }\r\n                        ],\r\n                        layout: 'column'\r\n                    },\r\n                    { type: 'separator' },\r\n                    {\r\n                        key: 'flagShape',\r\n                        type: 'radio',\r\n                        label: T.flagIconsShape,\r\n                        default: 'rect',\r\n                        options: [\r\n                            { value: 'rect',   label: T.rectangle },\r\n                            { value: 'square', label: T.square    }\r\n                        ],\r\n                        layout: 'column'\r\n                    },\r\n                    { key: 'flagRadius',      type: 'number', label: T.flagRadius, default: 2 },\r\n                    { type: 'separator' },\r\n                    { key: 'enableCustomCss', type: 'toggle', label: T.enableCustomCss, default: false },\r\n                    { key: 'customCss',       type: 'customCss', label: '', visible: cfg => cfg?.enableCustomCss === true }\r\n                ]\"\r\n            />\r\n\r\n            <SettingsBox\r\n                :title=\"T.customizeLayout\"\r\n                :scope=\"scope\"\r\n                collapsible\r\n                :fields=\"[{\r\n                    key: 'layoutCustomizer',\r\n                    type: 'lCustomizer',\r\n                    label: ''\r\n                }]\"\r\n            />\r\n\r\n            <SettingsBox\r\n                title=\"Additional Settings\"\r\n                :scope=\"scope\"\r\n                collapsible\r\n                :fields=\"[{\r\n                    key: 'oppositeLanguage',\r\n                    type: 'checkbox',\r\n                    default: false,\r\n                    label: T.showOppositeLanguage,\r\n                    description: oppositeLanguageFieldDescription,\r\n                    disabled: aboveTwoLanguages,\r\n                    title: aboveTwoLanguagesTitle\r\n                },\r\n                {\r\n                    key: 'showPoweredBy',\r\n                    type: 'checkbox',\r\n                    default: false,\r\n                    label: T.showPoweredBy,\r\n                    description: T.poweredByDesc\r\n                }]\"\r\n            />\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-floater-settings__wrapper {\r\n    display: flex;\r\n    flex-direction: row;\r\n    gap: 16px;\r\n    max-width: 1200px;\r\n    width: 100%;\r\n}\r\n\r\n.trp-floater-settings__right {\r\n    display: flex;\r\n    flex-direction: column;\r\n    gap: 16px;\r\n    width: 60%;\r\n    max-width: 641px;\r\n}\r\n\r\n.trp-floater-settings__left {\r\n    width: 40%;\r\n}\r\n\r\n.trp-sticky-box {\r\n    position: sticky;\r\n    top: 50px\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},262:(e,t)=>{"use strict";t.A=(e,t)=>{const n=e.__vccOpts||e;for(const[e,r]of t)n[e]=r;return n}},268:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-toggle-status-field[data-v-63ef0d74]{align-items:center;display:flex;gap:10px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/ToggleStatusField.vue"],names:[],mappings:"AA8BA,0CAAyC,kBAAkB,CAAhC,YAAY,CAAsB,QAAU",sourcesContent:["<template>\r\n    <div class=\"trp-toggle-status-field\">\r\n        <ToggleField\r\n            v-model=\"inputValue\"\r\n            :label=\"''\"\r\n        />\r\n        <span class=\"trp-primary-text\">\r\n        {{ modelValue ? onText : offText }}\r\n        </span>\r\n    </div>\r\n</template>\r\n\r\n<script setup>\r\nimport ToggleField from './ToggleField.vue'\r\nimport { computed }  from \"vue\"\r\n\r\nconst props = defineProps({\r\n    modelValue: Boolean,\r\n    onText:  { type: String, default: 'Enabled' },\r\n    offText: { type: String, default: 'Disabled' }\r\n})\r\nconst emit = defineEmits(['update:modelValue'])\r\n\r\nconst inputValue = computed({\r\n    get: ()  => props.modelValue,\r\n    set: val => emit('update:modelValue', val)\r\n});\r\n<\/script>\r\n\r\n<style scoped>\r\n.trp-toggle-status-field { display:flex; align-items:center; gap:10px; }\r\n</style>\r\n"],sourceRoot:""}]);const a=s},419:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-quad-grid[data-v-44785c6b]{display:grid;gap:12px 24px;grid-template-columns:repeat(2,max-content)}.trp-quad-radius-corner[data-v-44785c6b]{align-items:center;display:flex;flex-direction:row;gap:8px}.trp-corner-label[data-v-44785c6b]{min-width:90px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/QuadRadiusField.vue"],names:[],mappings:"AAmDA,gCACI,YAAa,CAEb,aAAc,CADd,2CAEJ,CAEA,yCAGI,kBAAmB,CAFnB,YAAa,CACb,kBAAmB,CAEnB,OACJ,CAEA,mCACI,cACJ",sourcesContent:["<script setup>\r\nimport { computed }  from 'vue'\r\nimport NumberField from './NumberField.vue'\r\n\r\n/*\r\n  v-model expects an array: [ topLeft, topRight, bottomLeft, bottomRight ]\r\n*/\r\nconst props = defineProps( {\r\n    label      : { type : String, default : '' },\r\n    modelValue : { type : Array, required : true }\r\n})\r\nconst emit  = defineEmits( [ 'update:modelValue' ] )\r\n\r\n/* build four computed bindings that proxy into the array */\r\n// each binding is a ComputedRef<number>\r\nconst bindings = Array.from( { length : 4 }, ( _, i ) =>\r\n    computed( {\r\n        get : () => props.modelValue[ i ] ?? 0,\r\n        set : val => {\r\n            const next = [ ...props.modelValue ]\r\n\r\n            next[ i ]  = val\r\n            emit( 'update:modelValue', next )\r\n        }\r\n    })\r\n)\r\n\r\nconst cornerLabels = [ 'Top Left', 'Top Right', 'Bottom Left', 'Bottom Right' ]\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-field trp-field--column\">\r\n        <span class=\"trp-field__label trp-primary-text-bold\">{{ label }}</span>\r\n        <div class=\"trp-quad-grid\">\r\n            <div\r\n                v-for=\"(cornerLabel, idx) in cornerLabels\"\r\n                :key=\"idx\"\r\n                class=\"trp-quad-radius-corner\"\r\n            >\r\n                <span class=\"trp-primary-text trp-corner-label\">{{ cornerLabel }}</span>\r\n                <NumberField\r\n                    :modelValue=\"bindings[idx].value\"\r\n                    @update:modelValue=\"val => bindings[idx].value = val\"\r\n                    :label=\"''\"\r\n                />\r\n            </div>\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-quad-grid {\r\n    display: grid;\r\n    grid-template-columns: repeat(2, max-content);\r\n    gap: 12px 24px;\r\n}\r\n\r\n.trp-quad-radius-corner {\r\n    display: flex;\r\n    flex-direction: row;\r\n    align-items: center;\r\n    gap: 8px;\r\n}\r\n\r\n.trp-corner-label{\r\n    min-width: 90px;\r\n}\r\n\r\n</style>\r\n"],sourceRoot:""}]);const a=s},434:(e,t,n)=>{"use strict";var r={};function i(e){const t=Object.create(null);for(const n of e.split(","))t[n]=1;return e=>e in t}n.r(r),n.d(r,{BaseTransition:()=>xr,BaseTransitionPropsValidators:()=>Ar,Comment:()=>_s,DeprecationTypes:()=>Ha,EffectScope:()=>ye,ErrorCodes:()=>Sn,ErrorTypeStrings:()=>Na,Fragment:()=>Os,KeepAlive:()=>si,ReactiveEffect:()=>Se,Static:()=>Ts,Suspense:()=>ys,Teleport:()=>ur,Text:()=>Bs,TrackOpTypes:()=>dn,Transition:()=>nl,TransitionGroup:()=>ec,TriggerOpTypes:()=>un,VueElement:()=>jl,assertNumber:()=>kn,callWithAsyncErrorHandling:()=>_n,callWithErrorHandling:()=>Bn,camelize:()=>P,capitalize:()=>L,cloneVNode:()=>Gs,compatUtils:()=>$a,computed:()=>Ea,createApp:()=>Mc,createBlock:()=>Qs,createCommentVNode:()=>Ks,createElementBlock:()=>Fs,createElementVNode:()=>qs,createHydrationRenderer:()=>Ho,createPropsRestProxy:()=>ro,createRenderer:()=>$o,createSSRApp:()=>Dc,createSlots:()=>Ii,createStaticVNode:()=>Js,createTextVNode:()=>Xs,createVNode:()=>Ws,customRef:()=>rn,defineAsyncComponent:()=>ni,defineComponent:()=>Er,defineCustomElement:()=>zl,defineEmits:()=>qi,defineExpose:()=>Wi,defineModel:()=>Gi,defineOptions:()=>Ui,defineProps:()=>ji,defineSSRCustomElement:()=>$l,defineSlots:()=>Yi,devtools:()=>Fa,effect:()=>Fe,effectScope:()=>we,getCurrentInstance:()=>la,getCurrentScope:()=>Ce,getCurrentWatcher:()=>mn,getTransitionRawChildren:()=>Tr,guardReactiveProps:()=>Ys,h:()=>Ma,handleError:()=>Tn,hasInjectionContext:()=>ko,hydrate:()=>Ec,hydrateOnIdle:()=>Jr,hydrateOnInteraction:()=>ei,hydrateOnMediaQuery:()=>Zr,hydrateOnVisible:()=>Kr,initCustomFormatter:()=>Da,initDirectivesForSSR:()=>Lc,inject:()=>xo,isMemoSame:()=>Ra,isProxy:()=>zt,isReactive:()=>Ft,isReadonly:()=>Qt,isRef:()=>Wt,isRuntimeOnly:()=>ya,isShallow:()=>Vt,isVNode:()=>Vs,markRaw:()=>Ht,mergeDefaults:()=>to,mergeModels:()=>no,mergeProps:()=>na,nextTick:()=>Nn,normalizeClass:()=>J,normalizeProps:()=>K,normalizeStyle:()=>W,onActivated:()=>li,onBeforeMount:()=>mi,onBeforeUnmount:()=>yi,onBeforeUpdate:()=>bi,onDeactivated:()=>ci,onErrorCaptured:()=>Si,onMounted:()=>vi,onRenderTracked:()=>ki,onRenderTriggered:()=>xi,onScopeDispose:()=>xe,onServerPrefetch:()=>Ci,onUnmounted:()=>wi,onUpdated:()=>Ai,onWatcherCleanup:()=>vn,openBlock:()=>Ds,popScopeId:()=>Kn,provide:()=>Co,proxyRefs:()=>tn,pushScopeId:()=>Jn,queuePostFlushCb:()=>Vn,reactive:()=>Pt,readonly:()=>It,ref:()=>Ut,registerRuntimeCompiler:()=>Aa,render:()=>Tc,renderList:()=>Ri,renderSlot:()=>Li,resolveComponent:()=>_i,resolveDirective:()=>Mi,resolveDynamicComponent:()=>Ei,resolveFilter:()=>za,resolveTransitionHooks:()=>Sr,setBlockTracking:()=>Ls,setDevtoolsHook:()=>Qa,setTransitionHooks:()=>_r,shallowReactive:()=>Rt,shallowReadonly:()=>Lt,shallowRef:()=>Yt,ssrContextKey:()=>Jo,ssrUtils:()=>Va,stop:()=>Qe,toDisplayString:()=>fe,toHandlerKey:()=>N,toHandlers:()=>Fi,toRaw:()=>$t,toRef:()=>ln,toRefs:()=>on,toValue:()=>Zt,transformVNodeArgs:()=>$s,triggerRef:()=>Jt,unref:()=>Kt,useAttrs:()=>Ki,useCssModule:()=>Ul,useCssVars:()=>wl,useHost:()=>ql,useId:()=>Mr,useModel:()=>ss,useSSRContext:()=>Ko,useShadowRoot:()=>Wl,useSlots:()=>Ji,useTemplateRef:()=>Pr,useTransitionState:()=>vr,vModelCheckbox:()=>cc,vModelDynamic:()=>mc,vModelRadio:()=>dc,vModelSelect:()=>uc,vModelText:()=>lc,vShow:()=>bl,version:()=>Ia,warn:()=>La,watch:()=>ns,watchEffect:()=>Zo,watchPostEffect:()=>es,watchSyncEffect:()=>ts,withAsyncContext:()=>io,withCtx:()=>er,withDefaults:()=>Xi,withDirectives:()=>tr,withKeys:()=>xc,withMemo:()=>Pa,withModifiers:()=>wc,withScopeId:()=>Zn});const o={},s=[],a=()=>{},l=()=>!1,c=e=>111===e.charCodeAt(0)&&110===e.charCodeAt(1)&&(e.charCodeAt(2)>122||e.charCodeAt(2)<97),h=e=>e.startsWith("onUpdate:"),d=Object.assign,u=(e,t)=>{const n=e.indexOf(t);n>-1&&e.splice(n,1)},p=Object.prototype.hasOwnProperty,f=(e,t)=>p.call(e,t),g=Array.isArray,m=e=>"[object Map]"===S(e),v=e=>"[object Set]"===S(e),b=e=>"[object Date]"===S(e),A=e=>"function"==typeof e,y=e=>"string"==typeof e,w=e=>"symbol"==typeof e,C=e=>null!==e&&"object"==typeof e,x=e=>(C(e)||A(e))&&A(e.then)&&A(e.catch),k=Object.prototype.toString,S=e=>k.call(e),O=e=>S(e).slice(8,-1),B=e=>"[object Object]"===S(e),_=e=>y(e)&&"NaN"!==e&&"-"!==e[0]&&""+parseInt(e,10)===e,T=i(",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted"),E=i("bind,cloak,else-if,else,for,html,if,model,on,once,pre,show,slot,text,memo"),M=e=>{const t=Object.create(null);return n=>t[n]||(t[n]=e(n))},D=/-\w/g,P=M(e=>e.replace(D,e=>e.slice(1).toUpperCase())),R=/\B([A-Z])/g,I=M(e=>e.replace(R,"-$1").toLowerCase()),L=M(e=>e.charAt(0).toUpperCase()+e.slice(1)),N=M(e=>e?`on${L(e)}`:""),F=(e,t)=>!Object.is(e,t),Q=(e,...t)=>{for(let n=0;n<e.length;n++)e[n](...t)},V=(e,t,n,r=!1)=>{Object.defineProperty(e,t,{configurable:!0,enumerable:!1,writable:r,value:n})},z=e=>{const t=parseFloat(e);return isNaN(t)?e:t},$=e=>{const t=y(e)?Number(e):NaN;return isNaN(t)?e:t};let H;const j=()=>H||(H="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self?self:"undefined"!=typeof window?window:void 0!==n.g?n.g:{});const q=i("Infinity,undefined,NaN,isFinite,isNaN,parseFloat,parseInt,decodeURI,decodeURIComponent,encodeURI,encodeURIComponent,Math,Number,Date,Array,Object,Boolean,String,RegExp,Map,Set,JSON,Intl,BigInt,console,Error,Symbol");function W(e){if(g(e)){const t={};for(let n=0;n<e.length;n++){const r=e[n],i=y(r)?X(r):W(r);if(i)for(const e in i)t[e]=i[e]}return t}if(y(e)||C(e))return e}const U=/;(?![^(]*\))/g,Y=/:([^]+)/,G=/\/\*[^]*?\*\//g;function X(e){const t={};return e.replace(G,"").split(U).forEach(e=>{if(e){const n=e.split(Y);n.length>1&&(t[n[0].trim()]=n[1].trim())}}),t}function J(e){let t="";if(y(e))t=e;else if(g(e))for(let n=0;n<e.length;n++){const r=J(e[n]);r&&(t+=r+" ")}else if(C(e))for(const n in e)e[n]&&(t+=n+" ");return t.trim()}function K(e){if(!e)return null;let{class:t,style:n}=e;return t&&!y(t)&&(e.class=J(t)),n&&(e.style=W(n)),e}const Z=i("html,body,base,head,link,meta,style,title,address,article,aside,footer,header,hgroup,h1,h2,h3,h4,h5,h6,nav,section,div,dd,dl,dt,figcaption,figure,picture,hr,img,li,main,ol,p,pre,ul,a,b,abbr,bdi,bdo,br,cite,code,data,dfn,em,i,kbd,mark,q,rp,rt,ruby,s,samp,small,span,strong,sub,sup,time,u,var,wbr,area,audio,map,track,video,embed,object,param,source,canvas,script,noscript,del,ins,caption,col,colgroup,table,thead,tbody,td,th,tr,button,datalist,fieldset,form,input,label,legend,meter,optgroup,option,output,progress,select,textarea,details,dialog,menu,summary,template,blockquote,iframe,tfoot"),ee=i("svg,animate,animateMotion,animateTransform,circle,clipPath,color-profile,defs,desc,discard,ellipse,feBlend,feColorMatrix,feComponentTransfer,feComposite,feConvolveMatrix,feDiffuseLighting,feDisplacementMap,feDistantLight,feDropShadow,feFlood,feFuncA,feFuncB,feFuncG,feFuncR,feGaussianBlur,feImage,feMerge,feMergeNode,feMorphology,feOffset,fePointLight,feSpecularLighting,feSpotLight,feTile,feTurbulence,filter,foreignObject,g,hatch,hatchpath,image,line,linearGradient,marker,mask,mesh,meshgradient,meshpatch,meshrow,metadata,mpath,path,pattern,polygon,polyline,radialGradient,rect,set,solidcolor,stop,switch,symbol,text,textPath,title,tspan,unknown,use,view"),te=i("annotation,annotation-xml,maction,maligngroup,malignmark,math,menclose,merror,mfenced,mfrac,mfraction,mglyph,mi,mlabeledtr,mlongdiv,mmultiscripts,mn,mo,mover,mpadded,mphantom,mprescripts,mroot,mrow,ms,mscarries,mscarry,msgroup,msline,mspace,msqrt,msrow,mstack,mstyle,msub,msubsup,msup,mtable,mtd,mtext,mtr,munder,munderover,none,semantics"),ne=i("area,base,br,col,embed,hr,img,input,link,meta,param,source,track,wbr"),re="itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly",ie=i(re),oe=i(re+",async,autofocus,autoplay,controls,default,defer,disabled,hidden,inert,loop,open,required,reversed,scoped,seamless,checked,muted,multiple,selected");function se(e){return!!e||""===e}const ae=i("accept,accept-charset,accesskey,action,align,allow,alt,async,autocapitalize,autocomplete,autofocus,autoplay,background,bgcolor,border,buffered,capture,challenge,charset,checked,cite,class,code,codebase,color,cols,colspan,content,contenteditable,contextmenu,controls,coords,crossorigin,csp,data,datetime,decoding,default,defer,dir,dirname,disabled,download,draggable,dropzone,enctype,enterkeyhint,for,form,formaction,formenctype,formmethod,formnovalidate,formtarget,headers,height,hidden,high,href,hreflang,http-equiv,icon,id,importance,inert,integrity,ismap,itemprop,keytype,kind,label,lang,language,loading,list,loop,low,manifest,max,maxlength,minlength,media,min,multiple,muted,name,novalidate,open,optimum,pattern,ping,placeholder,poster,preload,radiogroup,readonly,referrerpolicy,rel,required,reversed,rows,rowspan,sandbox,scope,scoped,selected,shape,size,sizes,slot,span,spellcheck,src,srcdoc,srclang,srcset,start,step,style,summary,tabindex,target,title,translate,type,usemap,value,width,wrap"),le=i("xmlns,accent-height,accumulate,additive,alignment-baseline,alphabetic,amplitude,arabic-form,ascent,attributeName,attributeType,azimuth,baseFrequency,baseline-shift,baseProfile,bbox,begin,bias,by,calcMode,cap-height,class,clip,clipPathUnits,clip-path,clip-rule,color,color-interpolation,color-interpolation-filters,color-profile,color-rendering,contentScriptType,contentStyleType,crossorigin,cursor,cx,cy,d,decelerate,descent,diffuseConstant,direction,display,divisor,dominant-baseline,dur,dx,dy,edgeMode,elevation,enable-background,end,exponent,fill,fill-opacity,fill-rule,filter,filterRes,filterUnits,flood-color,flood-opacity,font-family,font-size,font-size-adjust,font-stretch,font-style,font-variant,font-weight,format,from,fr,fx,fy,g1,g2,glyph-name,glyph-orientation-horizontal,glyph-orientation-vertical,glyphRef,gradientTransform,gradientUnits,hanging,height,href,hreflang,horiz-adv-x,horiz-origin-x,id,ideographic,image-rendering,in,in2,intercept,k,k1,k2,k3,k4,kernelMatrix,kernelUnitLength,kerning,keyPoints,keySplines,keyTimes,lang,lengthAdjust,letter-spacing,lighting-color,limitingConeAngle,local,marker-end,marker-mid,marker-start,markerHeight,markerUnits,markerWidth,mask,maskContentUnits,maskUnits,mathematical,max,media,method,min,mode,name,numOctaves,offset,opacity,operator,order,orient,orientation,origin,overflow,overline-position,overline-thickness,panose-1,paint-order,path,pathLength,patternContentUnits,patternTransform,patternUnits,ping,pointer-events,points,pointsAtX,pointsAtY,pointsAtZ,preserveAlpha,preserveAspectRatio,primitiveUnits,r,radius,referrerPolicy,refX,refY,rel,rendering-intent,repeatCount,repeatDur,requiredExtensions,requiredFeatures,restart,result,rotate,rx,ry,scale,seed,shape-rendering,slope,spacing,specularConstant,specularExponent,speed,spreadMethod,startOffset,stdDeviation,stemh,stemv,stitchTiles,stop-color,stop-opacity,strikethrough-position,strikethrough-thickness,string,stroke,stroke-dasharray,stroke-dashoffset,stroke-linecap,stroke-linejoin,stroke-miterlimit,stroke-opacity,stroke-width,style,surfaceScale,systemLanguage,tabindex,tableValues,target,targetX,targetY,text-anchor,text-decoration,text-rendering,textLength,to,transform,transform-origin,type,u1,u2,underline-position,underline-thickness,unicode,unicode-bidi,unicode-range,units-per-em,v-alphabetic,v-hanging,v-ideographic,v-mathematical,values,vector-effect,version,vert-adv-y,vert-origin-x,vert-origin-y,viewBox,viewTarget,visibility,width,widths,word-spacing,writing-mode,x,x-height,x1,x2,xChannelSelector,xlink:actuate,xlink:arcrole,xlink:href,xlink:role,xlink:show,xlink:title,xlink:type,xmlns:xlink,xml:base,xml:lang,xml:space,y,y1,y2,yChannelSelector,z,zoomAndPan");const ce=/[ !"#$%&'()*+,./:;<=>?@[\\\]^`{|}~]/g;function he(e,t){return e.replace(ce,e=>t?'"'===e?'\\\\\\"':`\\\\${e}`:`\\${e}`)}function de(e,t){if(e===t)return!0;let n=b(e),r=b(t);if(n||r)return!(!n||!r)&&e.getTime()===t.getTime();if(n=w(e),r=w(t),n||r)return e===t;if(n=g(e),r=g(t),n||r)return!(!n||!r)&&function(e,t){if(e.length!==t.length)return!1;let n=!0;for(let r=0;n&&r<e.length;r++)n=de(e[r],t[r]);return n}(e,t);if(n=C(e),r=C(t),n||r){if(!n||!r)return!1;if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const n in e){const r=e.hasOwnProperty(n),i=t.hasOwnProperty(n);if(r&&!i||!r&&i||!de(e[n],t[n]))return!1}}return String(e)===String(t)}function ue(e,t){return e.findIndex(e=>de(e,t))}const pe=e=>!(!e||!0!==e.__v_isRef),fe=e=>y(e)?e:null==e?"":g(e)||C(e)&&(e.toString===k||!A(e.toString))?pe(e)?fe(e.value):JSON.stringify(e,ge,2):String(e),ge=(e,t)=>pe(t)?ge(e,t.value):m(t)?{[`Map(${t.size})`]:[...t.entries()].reduce((e,[t,n],r)=>(e[me(t,r)+" =>"]=n,e),{})}:v(t)?{[`Set(${t.size})`]:[...t.values()].map(e=>me(e))}:w(t)?me(t):!C(t)||g(t)||B(t)?t:String(t),me=(e,t="")=>{var n;return w(e)?`Symbol(${null!=(n=e.description)?n:t})`:e};function ve(e){return null==e?"initial":"string"==typeof e?""===e?" ":e:("number"==typeof e&&Number.isFinite(e),String(e))}let be,Ae;class ye{constructor(e=!1){this.detached=e,this._active=!0,this._on=0,this.effects=[],this.cleanups=[],this._isPaused=!1,this.parent=be,!e&&be&&(this.index=(be.scopes||(be.scopes=[])).push(this)-1)}get active(){return this._active}pause(){if(this._active){let e,t;if(this._isPaused=!0,this.scopes)for(e=0,t=this.scopes.length;e<t;e++)this.scopes[e].pause();for(e=0,t=this.effects.length;e<t;e++)this.effects[e].pause()}}resume(){if(this._active&&this._isPaused){let e,t;if(this._isPaused=!1,this.scopes)for(e=0,t=this.scopes.length;e<t;e++)this.scopes[e].resume();for(e=0,t=this.effects.length;e<t;e++)this.effects[e].resume()}}run(e){if(this._active){const t=be;try{return be=this,e()}finally{be=t}}else 0}on(){1===++this._on&&(this.prevScope=be,be=this)}off(){this._on>0&&0===--this._on&&(be=this.prevScope,this.prevScope=void 0)}stop(e){if(this._active){let t,n;for(this._active=!1,t=0,n=this.effects.length;t<n;t++)this.effects[t].stop();for(this.effects.length=0,t=0,n=this.cleanups.length;t<n;t++)this.cleanups[t]();if(this.cleanups.length=0,this.scopes){for(t=0,n=this.scopes.length;t<n;t++)this.scopes[t].stop(!0);this.scopes.length=0}if(!this.detached&&this.parent&&!e){const e=this.parent.scopes.pop();e&&e!==this&&(this.parent.scopes[this.index]=e,e.index=this.index)}this.parent=void 0}}}function we(e){return new ye(e)}function Ce(){return be}function xe(e,t=!1){be&&be.cleanups.push(e)}const ke=new WeakSet;class Se{constructor(e){this.fn=e,this.deps=void 0,this.depsTail=void 0,this.flags=5,this.next=void 0,this.cleanup=void 0,this.scheduler=void 0,be&&be.active&&be.effects.push(this)}pause(){this.flags|=64}resume(){64&this.flags&&(this.flags&=-65,ke.has(this)&&(ke.delete(this),this.trigger()))}notify(){2&this.flags&&!(32&this.flags)||8&this.flags||Te(this)}run(){if(!(1&this.flags))return this.fn();this.flags|=2,je(this),De(this);const e=Ae,t=Ve;Ae=this,Ve=!0;try{return this.fn()}finally{0,Pe(this),Ae=e,Ve=t,this.flags&=-3}}stop(){if(1&this.flags){for(let e=this.deps;e;e=e.nextDep)Le(e);this.deps=this.depsTail=void 0,je(this),this.onStop&&this.onStop(),this.flags&=-2}}trigger(){64&this.flags?ke.add(this):this.scheduler?this.scheduler():this.runIfDirty()}runIfDirty(){Re(this)&&this.run()}get dirty(){return Re(this)}}let Oe,Be,_e=0;function Te(e,t=!1){if(e.flags|=8,t)return e.next=Be,void(Be=e);e.next=Oe,Oe=e}function Ee(){_e++}function Me(){if(--_e>0)return;if(Be){let e=Be;for(Be=void 0;e;){const t=e.next;e.next=void 0,e.flags&=-9,e=t}}let e;for(;Oe;){let t=Oe;for(Oe=void 0;t;){const n=t.next;if(t.next=void 0,t.flags&=-9,1&t.flags)try{t.trigger()}catch(t){e||(e=t)}t=n}}if(e)throw e}function De(e){for(let t=e.deps;t;t=t.nextDep)t.version=-1,t.prevActiveLink=t.dep.activeLink,t.dep.activeLink=t}function Pe(e){let t,n=e.depsTail,r=n;for(;r;){const e=r.prevDep;-1===r.version?(r===n&&(n=e),Le(r),Ne(r)):t=r,r.dep.activeLink=r.prevActiveLink,r.prevActiveLink=void 0,r=e}e.deps=t,e.depsTail=n}function Re(e){for(let t=e.deps;t;t=t.nextDep)if(t.dep.version!==t.version||t.dep.computed&&(Ie(t.dep.computed)||t.dep.version!==t.version))return!0;return!!e._dirty}function Ie(e){if(4&e.flags&&!(16&e.flags))return;if(e.flags&=-17,e.globalVersion===qe)return;if(e.globalVersion=qe,!e.isSSR&&128&e.flags&&(!e.deps&&!e._dirty||!Re(e)))return;e.flags|=2;const t=e.dep,n=Ae,r=Ve;Ae=e,Ve=!0;try{De(e);const n=e.fn(e._value);(0===t.version||F(n,e._value))&&(e.flags|=128,e._value=n,t.version++)}catch(e){throw t.version++,e}finally{Ae=n,Ve=r,Pe(e),e.flags&=-3}}function Le(e,t=!1){const{dep:n,prevSub:r,nextSub:i}=e;if(r&&(r.nextSub=i,e.prevSub=void 0),i&&(i.prevSub=r,e.nextSub=void 0),n.subs===e&&(n.subs=r,!r&&n.computed)){n.computed.flags&=-5;for(let e=n.computed.deps;e;e=e.nextDep)Le(e,!0)}t||--n.sc||!n.map||n.map.delete(n.key)}function Ne(e){const{prevDep:t,nextDep:n}=e;t&&(t.nextDep=n,e.prevDep=void 0),n&&(n.prevDep=t,e.nextDep=void 0)}function Fe(e,t){e.effect instanceof Se&&(e=e.effect.fn);const n=new Se(e);t&&d(n,t);try{n.run()}catch(e){throw n.stop(),e}const r=n.run.bind(n);return r.effect=n,r}function Qe(e){e.effect.stop()}let Ve=!0;const ze=[];function $e(){ze.push(Ve),Ve=!1}function He(){const e=ze.pop();Ve=void 0===e||e}function je(e){const{cleanup:t}=e;if(e.cleanup=void 0,t){const e=Ae;Ae=void 0;try{t()}finally{Ae=e}}}let qe=0;class We{constructor(e,t){this.sub=e,this.dep=t,this.version=t.version,this.nextDep=this.prevDep=this.nextSub=this.prevSub=this.prevActiveLink=void 0}}class Ue{constructor(e){this.computed=e,this.version=0,this.activeLink=void 0,this.subs=void 0,this.map=void 0,this.key=void 0,this.sc=0,this.__v_skip=!0}track(e){if(!Ae||!Ve||Ae===this.computed)return;let t=this.activeLink;if(void 0===t||t.sub!==Ae)t=this.activeLink=new We(Ae,this),Ae.deps?(t.prevDep=Ae.depsTail,Ae.depsTail.nextDep=t,Ae.depsTail=t):Ae.deps=Ae.depsTail=t,Ye(t);else if(-1===t.version&&(t.version=this.version,t.nextDep)){const e=t.nextDep;e.prevDep=t.prevDep,t.prevDep&&(t.prevDep.nextDep=e),t.prevDep=Ae.depsTail,t.nextDep=void 0,Ae.depsTail.nextDep=t,Ae.depsTail=t,Ae.deps===t&&(Ae.deps=e)}return t}trigger(e){this.version++,qe++,this.notify(e)}notify(e){Ee();try{0;for(let e=this.subs;e;e=e.prevSub)e.sub.notify()&&e.sub.dep.notify()}finally{Me()}}}function Ye(e){if(e.dep.sc++,4&e.sub.flags){const t=e.dep.computed;if(t&&!e.dep.subs){t.flags|=20;for(let e=t.deps;e;e=e.nextDep)Ye(e)}const n=e.dep.subs;n!==e&&(e.prevSub=n,n&&(n.nextSub=e)),e.dep.subs=e}}const Ge=new WeakMap,Xe=Symbol(""),Je=Symbol(""),Ke=Symbol("");function Ze(e,t,n){if(Ve&&Ae){let t=Ge.get(e);t||Ge.set(e,t=new Map);let r=t.get(n);r||(t.set(n,r=new Ue),r.map=t,r.key=n),r.track()}}function et(e,t,n,r,i,o){const s=Ge.get(e);if(!s)return void qe++;const a=e=>{e&&e.trigger()};if(Ee(),"clear"===t)s.forEach(a);else{const i=g(e),o=i&&_(n);if(i&&"length"===n){const e=Number(r);s.forEach((t,n)=>{("length"===n||n===Ke||!w(n)&&n>=e)&&a(t)})}else switch((void 0!==n||s.has(void 0))&&a(s.get(n)),o&&a(s.get(Ke)),t){case"add":i?o&&a(s.get("length")):(a(s.get(Xe)),m(e)&&a(s.get(Je)));break;case"delete":i||(a(s.get(Xe)),m(e)&&a(s.get(Je)));break;case"set":m(e)&&a(s.get(Xe))}}Me()}function tt(e){const t=$t(e);return t===e?t:(Ze(t,0,Ke),Vt(e)?t:t.map(jt))}function nt(e){return Ze(e=$t(e),0,Ke),e}const rt={__proto__:null,[Symbol.iterator](){return it(this,Symbol.iterator,jt)},concat(...e){return tt(this).concat(...e.map(e=>g(e)?tt(e):e))},entries(){return it(this,"entries",e=>(e[1]=jt(e[1]),e))},every(e,t){return st(this,"every",e,t,void 0,arguments)},filter(e,t){return st(this,"filter",e,t,e=>e.map(jt),arguments)},find(e,t){return st(this,"find",e,t,jt,arguments)},findIndex(e,t){return st(this,"findIndex",e,t,void 0,arguments)},findLast(e,t){return st(this,"findLast",e,t,jt,arguments)},findLastIndex(e,t){return st(this,"findLastIndex",e,t,void 0,arguments)},forEach(e,t){return st(this,"forEach",e,t,void 0,arguments)},includes(...e){return lt(this,"includes",e)},indexOf(...e){return lt(this,"indexOf",e)},join(e){return tt(this).join(e)},lastIndexOf(...e){return lt(this,"lastIndexOf",e)},map(e,t){return st(this,"map",e,t,void 0,arguments)},pop(){return ct(this,"pop")},push(...e){return ct(this,"push",e)},reduce(e,...t){return at(this,"reduce",e,t)},reduceRight(e,...t){return at(this,"reduceRight",e,t)},shift(){return ct(this,"shift")},some(e,t){return st(this,"some",e,t,void 0,arguments)},splice(...e){return ct(this,"splice",e)},toReversed(){return tt(this).toReversed()},toSorted(e){return tt(this).toSorted(e)},toSpliced(...e){return tt(this).toSpliced(...e)},unshift(...e){return ct(this,"unshift",e)},values(){return it(this,"values",jt)}};function it(e,t,n){const r=nt(e),i=r[t]();return r===e||Vt(e)||(i._next=i.next,i.next=()=>{const e=i._next();return e.done||(e.value=n(e.value)),e}),i}const ot=Array.prototype;function st(e,t,n,r,i,o){const s=nt(e),a=s!==e&&!Vt(e),l=s[t];if(l!==ot[t]){const t=l.apply(e,o);return a?jt(t):t}let c=n;s!==e&&(a?c=function(t,r){return n.call(this,jt(t),r,e)}:n.length>2&&(c=function(t,r){return n.call(this,t,r,e)}));const h=l.call(s,c,r);return a&&i?i(h):h}function at(e,t,n,r){const i=nt(e);let o=n;return i!==e&&(Vt(e)?n.length>3&&(o=function(t,r,i){return n.call(this,t,r,i,e)}):o=function(t,r,i){return n.call(this,t,jt(r),i,e)}),i[t](o,...r)}function lt(e,t,n){const r=$t(e);Ze(r,0,Ke);const i=r[t](...n);return-1!==i&&!1!==i||!zt(n[0])?i:(n[0]=$t(n[0]),r[t](...n))}function ct(e,t,n=[]){$e(),Ee();const r=$t(e)[t].apply(e,n);return Me(),He(),r}const ht=i("__proto__,__v_isRef,__isVue"),dt=new Set(Object.getOwnPropertyNames(Symbol).filter(e=>"arguments"!==e&&"caller"!==e).map(e=>Symbol[e]).filter(w));function ut(e){w(e)||(e=String(e));const t=$t(this);return Ze(t,0,e),t.hasOwnProperty(e)}class pt{constructor(e=!1,t=!1){this._isReadonly=e,this._isShallow=t}get(e,t,n){if("__v_skip"===t)return e.__v_skip;const r=this._isReadonly,i=this._isShallow;if("__v_isReactive"===t)return!r;if("__v_isReadonly"===t)return r;if("__v_isShallow"===t)return i;if("__v_raw"===t)return n===(r?i?Dt:Mt:i?Et:Tt).get(e)||Object.getPrototypeOf(e)===Object.getPrototypeOf(n)?e:void 0;const o=g(e);if(!r){let e;if(o&&(e=rt[t]))return e;if("hasOwnProperty"===t)return ut}const s=Reflect.get(e,t,Wt(e)?e:n);if(w(t)?dt.has(t):ht(t))return s;if(r||Ze(e,0,t),i)return s;if(Wt(s)){const e=o&&_(t)?s:s.value;return r&&C(e)?It(e):e}return C(s)?r?It(s):Pt(s):s}}class ft extends pt{constructor(e=!1){super(!1,e)}set(e,t,n,r){let i=e[t];if(!this._isShallow){const t=Qt(i);if(Vt(n)||Qt(n)||(i=$t(i),n=$t(n)),!g(e)&&Wt(i)&&!Wt(n))return t||(i.value=n),!0}const o=g(e)&&_(t)?Number(t)<e.length:f(e,t),s=Reflect.set(e,t,n,Wt(e)?e:r);return e===$t(r)&&(o?F(n,i)&&et(e,"set",t,n):et(e,"add",t,n)),s}deleteProperty(e,t){const n=f(e,t),r=(e[t],Reflect.deleteProperty(e,t));return r&&n&&et(e,"delete",t,void 0),r}has(e,t){const n=Reflect.has(e,t);return w(t)&&dt.has(t)||Ze(e,0,t),n}ownKeys(e){return Ze(e,0,g(e)?"length":Xe),Reflect.ownKeys(e)}}class gt extends pt{constructor(e=!1){super(!0,e)}set(e,t){return!0}deleteProperty(e,t){return!0}}const mt=new ft,vt=new gt,bt=new ft(!0),At=new gt(!0),yt=e=>e,wt=e=>Reflect.getPrototypeOf(e);function Ct(e){return function(...t){return"delete"!==e&&("clear"===e?void 0:this)}}function xt(e,t){const n={get(n){const r=this.__v_raw,i=$t(r),o=$t(n);e||(F(n,o)&&Ze(i,0,n),Ze(i,0,o));const{has:s}=wt(i),a=t?yt:e?qt:jt;return s.call(i,n)?a(r.get(n)):s.call(i,o)?a(r.get(o)):void(r!==i&&r.get(n))},get size(){const t=this.__v_raw;return!e&&Ze($t(t),0,Xe),t.size},has(t){const n=this.__v_raw,r=$t(n),i=$t(t);return e||(F(t,i)&&Ze(r,0,t),Ze(r,0,i)),t===i?n.has(t):n.has(t)||n.has(i)},forEach(n,r){const i=this,o=i.__v_raw,s=$t(o),a=t?yt:e?qt:jt;return!e&&Ze(s,0,Xe),o.forEach((e,t)=>n.call(r,a(e),a(t),i))}};d(n,e?{add:Ct("add"),set:Ct("set"),delete:Ct("delete"),clear:Ct("clear")}:{add(e){t||Vt(e)||Qt(e)||(e=$t(e));const n=$t(this);return wt(n).has.call(n,e)||(n.add(e),et(n,"add",e,e)),this},set(e,n){t||Vt(n)||Qt(n)||(n=$t(n));const r=$t(this),{has:i,get:o}=wt(r);let s=i.call(r,e);s||(e=$t(e),s=i.call(r,e));const a=o.call(r,e);return r.set(e,n),s?F(n,a)&&et(r,"set",e,n):et(r,"add",e,n),this},delete(e){const t=$t(this),{has:n,get:r}=wt(t);let i=n.call(t,e);i||(e=$t(e),i=n.call(t,e));r&&r.call(t,e);const o=t.delete(e);return i&&et(t,"delete",e,void 0),o},clear(){const e=$t(this),t=0!==e.size,n=e.clear();return t&&et(e,"clear",void 0,void 0),n}});return["keys","values","entries",Symbol.iterator].forEach(r=>{n[r]=function(e,t,n){return function(...r){const i=this.__v_raw,o=$t(i),s=m(o),a="entries"===e||e===Symbol.iterator&&s,l="keys"===e&&s,c=i[e](...r),h=n?yt:t?qt:jt;return!t&&Ze(o,0,l?Je:Xe),{next(){const{value:e,done:t}=c.next();return t?{value:e,done:t}:{value:a?[h(e[0]),h(e[1])]:h(e),done:t}},[Symbol.iterator](){return this}}}}(r,e,t)}),n}function kt(e,t){const n=xt(e,t);return(t,r,i)=>"__v_isReactive"===r?!e:"__v_isReadonly"===r?e:"__v_raw"===r?t:Reflect.get(f(n,r)&&r in t?n:t,r,i)}const St={get:kt(!1,!1)},Ot={get:kt(!1,!0)},Bt={get:kt(!0,!1)},_t={get:kt(!0,!0)};const Tt=new WeakMap,Et=new WeakMap,Mt=new WeakMap,Dt=new WeakMap;function Pt(e){return Qt(e)?e:Nt(e,!1,mt,St,Tt)}function Rt(e){return Nt(e,!1,bt,Ot,Et)}function It(e){return Nt(e,!0,vt,Bt,Mt)}function Lt(e){return Nt(e,!0,At,_t,Dt)}function Nt(e,t,n,r,i){if(!C(e))return e;if(e.__v_raw&&(!t||!e.__v_isReactive))return e;const o=(s=e).__v_skip||!Object.isExtensible(s)?0:function(e){switch(e){case"Object":case"Array":return 1;case"Map":case"Set":case"WeakMap":case"WeakSet":return 2;default:return 0}}(O(s));var s;if(0===o)return e;const a=i.get(e);if(a)return a;const l=new Proxy(e,2===o?r:n);return i.set(e,l),l}function Ft(e){return Qt(e)?Ft(e.__v_raw):!(!e||!e.__v_isReactive)}function Qt(e){return!(!e||!e.__v_isReadonly)}function Vt(e){return!(!e||!e.__v_isShallow)}function zt(e){return!!e&&!!e.__v_raw}function $t(e){const t=e&&e.__v_raw;return t?$t(t):e}function Ht(e){return!f(e,"__v_skip")&&Object.isExtensible(e)&&V(e,"__v_skip",!0),e}const jt=e=>C(e)?Pt(e):e,qt=e=>C(e)?It(e):e;function Wt(e){return!!e&&!0===e.__v_isRef}function Ut(e){return Gt(e,!1)}function Yt(e){return Gt(e,!0)}function Gt(e,t){return Wt(e)?e:new Xt(e,t)}class Xt{constructor(e,t){this.dep=new Ue,this.__v_isRef=!0,this.__v_isShallow=!1,this._rawValue=t?e:$t(e),this._value=t?e:jt(e),this.__v_isShallow=t}get value(){return this.dep.track(),this._value}set value(e){const t=this._rawValue,n=this.__v_isShallow||Vt(e)||Qt(e);e=n?e:$t(e),F(e,t)&&(this._rawValue=e,this._value=n?e:jt(e),this.dep.trigger())}}function Jt(e){e.dep&&e.dep.trigger()}function Kt(e){return Wt(e)?e.value:e}function Zt(e){return A(e)?e():Kt(e)}const en={get:(e,t,n)=>"__v_raw"===t?e:Kt(Reflect.get(e,t,n)),set:(e,t,n,r)=>{const i=e[t];return Wt(i)&&!Wt(n)?(i.value=n,!0):Reflect.set(e,t,n,r)}};function tn(e){return Ft(e)?e:new Proxy(e,en)}class nn{constructor(e){this.__v_isRef=!0,this._value=void 0;const t=this.dep=new Ue,{get:n,set:r}=e(t.track.bind(t),t.trigger.bind(t));this._get=n,this._set=r}get value(){return this._value=this._get()}set value(e){this._set(e)}}function rn(e){return new nn(e)}function on(e){const t=g(e)?new Array(e.length):{};for(const n in e)t[n]=cn(e,n);return t}class sn{constructor(e,t,n){this._object=e,this._key=t,this._defaultValue=n,this.__v_isRef=!0,this._value=void 0}get value(){const e=this._object[this._key];return this._value=void 0===e?this._defaultValue:e}set value(e){this._object[this._key]=e}get dep(){return function(e,t){const n=Ge.get(e);return n&&n.get(t)}($t(this._object),this._key)}}class an{constructor(e){this._getter=e,this.__v_isRef=!0,this.__v_isReadonly=!0,this._value=void 0}get value(){return this._value=this._getter()}}function ln(e,t,n){return Wt(e)?e:A(e)?new an(e):C(e)&&arguments.length>1?cn(e,t,n):Ut(e)}function cn(e,t,n){const r=e[t];return Wt(r)?r:new sn(e,t,n)}class hn{constructor(e,t,n){this.fn=e,this.setter=t,this._value=void 0,this.dep=new Ue(this),this.__v_isRef=!0,this.deps=void 0,this.depsTail=void 0,this.flags=16,this.globalVersion=qe-1,this.next=void 0,this.effect=this,this.__v_isReadonly=!t,this.isSSR=n}notify(){if(this.flags|=16,!(8&this.flags||Ae===this))return Te(this,!0),!0}get value(){const e=this.dep.track();return Ie(this),e&&(e.version=this.dep.version),this._value}set value(e){this.setter&&this.setter(e)}}const dn={GET:"get",HAS:"has",ITERATE:"iterate"},un={SET:"set",ADD:"add",DELETE:"delete",CLEAR:"clear"},pn={},fn=new WeakMap;let gn;function mn(){return gn}function vn(e,t=!1,n=gn){if(n){let t=fn.get(n);t||fn.set(n,t=[]),t.push(e)}else 0}function bn(e,t=1/0,n){if(t<=0||!C(e)||e.__v_skip)return e;if(((n=n||new Map).get(e)||0)>=t)return e;if(n.set(e,t),t--,Wt(e))bn(e.value,t,n);else if(g(e))for(let r=0;r<e.length;r++)bn(e[r],t,n);else if(v(e)||m(e))e.forEach(e=>{bn(e,t,n)});else if(B(e)){for(const r in e)bn(e[r],t,n);for(const r of Object.getOwnPropertySymbols(e))Object.prototype.propertyIsEnumerable.call(e,r)&&bn(e[r],t,n)}return e}const An=[];let yn=!1;function wn(e,...t){if(yn)return;yn=!0,$e();const n=An.length?An[An.length-1].component:null,r=n&&n.appContext.config.warnHandler,i=function(){let e=An[An.length-1];if(!e)return[];const t=[];for(;e;){const n=t[0];n&&n.vnode===e?n.recurseCount++:t.push({vnode:e,recurseCount:0});const r=e.component&&e.component.parent;e=r&&r.vnode}return t}();if(r)Bn(r,n,11,[e+t.map(e=>{var t,n;return null!=(n=null==(t=e.toString)?void 0:t.call(e))?n:JSON.stringify(e)}).join(""),n&&n.proxy,i.map(({vnode:e})=>`at <${_a(n,e.type)}>`).join("\n"),i]);else{const n=[`[Vue warn]: ${e}`,...t];i.length&&n.push("\n",...function(e){const t=[];return e.forEach((e,n)=>{t.push(...0===n?[]:["\n"],...function({vnode:e,recurseCount:t}){const n=t>0?`... (${t} recursive calls)`:"",r=!!e.component&&null==e.component.parent,i=` at <${_a(e.component,e.type,r)}`,o=">"+n;return e.props?[i,...Cn(e.props),o]:[i+o]}(e))}),t}(i)),console.warn(...n)}He(),yn=!1}function Cn(e){const t=[],n=Object.keys(e);return n.slice(0,3).forEach(n=>{t.push(...xn(n,e[n]))}),n.length>3&&t.push(" ..."),t}function xn(e,t,n){return y(t)?(t=JSON.stringify(t),n?t:[`${e}=${t}`]):"number"==typeof t||"boolean"==typeof t||null==t?n?t:[`${e}=${t}`]:Wt(t)?(t=xn(e,$t(t.value),!0),n?t:[`${e}=Ref<`,t,">"]):A(t)?[`${e}=fn${t.name?`<${t.name}>`:""}`]:(t=$t(t),n?t:[`${e}=`,t])}function kn(e,t){}const Sn={SETUP_FUNCTION:0,0:"SETUP_FUNCTION",RENDER_FUNCTION:1,1:"RENDER_FUNCTION",NATIVE_EVENT_HANDLER:5,5:"NATIVE_EVENT_HANDLER",COMPONENT_EVENT_HANDLER:6,6:"COMPONENT_EVENT_HANDLER",VNODE_HOOK:7,7:"VNODE_HOOK",DIRECTIVE_HOOK:8,8:"DIRECTIVE_HOOK",TRANSITION_HOOK:9,9:"TRANSITION_HOOK",APP_ERROR_HANDLER:10,10:"APP_ERROR_HANDLER",APP_WARN_HANDLER:11,11:"APP_WARN_HANDLER",FUNCTION_REF:12,12:"FUNCTION_REF",ASYNC_COMPONENT_LOADER:13,13:"ASYNC_COMPONENT_LOADER",SCHEDULER:14,14:"SCHEDULER",COMPONENT_UPDATE:15,15:"COMPONENT_UPDATE",APP_UNMOUNT_CLEANUP:16,16:"APP_UNMOUNT_CLEANUP"},On={sp:"serverPrefetch hook",bc:"beforeCreate hook",c:"created hook",bm:"beforeMount hook",m:"mounted hook",bu:"beforeUpdate hook",u:"updated",bum:"beforeUnmount hook",um:"unmounted hook",a:"activated hook",da:"deactivated hook",ec:"errorCaptured hook",rtc:"renderTracked hook",rtg:"renderTriggered hook",0:"setup function",1:"render function",2:"watcher getter",3:"watcher callback",4:"watcher cleanup function",5:"native event handler",6:"component event handler",7:"vnode hook",8:"directive hook",9:"transition hook",10:"app errorHandler",11:"app warnHandler",12:"ref function",13:"async component loader",14:"scheduler flush",15:"component update",16:"app unmount cleanup function"};function Bn(e,t,n,r){try{return r?e(...r):e()}catch(e){Tn(e,t,n)}}function _n(e,t,n,r){if(A(e)){const i=Bn(e,t,n,r);return i&&x(i)&&i.catch(e=>{Tn(e,t,n)}),i}if(g(e)){const i=[];for(let o=0;o<e.length;o++)i.push(_n(e[o],t,n,r));return i}}function Tn(e,t,n,r=!0){t&&t.vnode;const{errorHandler:i,throwUnhandledErrorInProduction:s}=t&&t.appContext.config||o;if(t){let r=t.parent;const o=t.proxy,s=`https://vuejs.org/error-reference/#runtime-${n}`;for(;r;){const t=r.ec;if(t)for(let n=0;n<t.length;n++)if(!1===t[n](e,o,s))return;r=r.parent}if(i)return $e(),Bn(i,null,10,[e,o,s]),void He()}!function(e,t,n,r=!0,i=!1){if(i)throw e;console.error(e)}(e,0,0,r,s)}const En=[];let Mn=-1;const Dn=[];let Pn=null,Rn=0;const In=Promise.resolve();let Ln=null;function Nn(e){const t=Ln||In;return e?t.then(this?e.bind(this):e):t}function Fn(e){if(!(1&e.flags)){const t=Hn(e),n=En[En.length-1];!n||!(2&e.flags)&&t>=Hn(n)?En.push(e):En.splice(function(e){let t=Mn+1,n=En.length;for(;t<n;){const r=t+n>>>1,i=En[r],o=Hn(i);o<e||o===e&&2&i.flags?t=r+1:n=r}return t}(t),0,e),e.flags|=1,Qn()}}function Qn(){Ln||(Ln=In.then(jn))}function Vn(e){g(e)?Dn.push(...e):Pn&&-1===e.id?Pn.splice(Rn+1,0,e):1&e.flags||(Dn.push(e),e.flags|=1),Qn()}function zn(e,t,n=Mn+1){for(0;n<En.length;n++){const t=En[n];if(t&&2&t.flags){if(e&&t.id!==e.uid)continue;0,En.splice(n,1),n--,4&t.flags&&(t.flags&=-2),t(),4&t.flags||(t.flags&=-2)}}}function $n(e){if(Dn.length){const e=[...new Set(Dn)].sort((e,t)=>Hn(e)-Hn(t));if(Dn.length=0,Pn)return void Pn.push(...e);for(Pn=e,Rn=0;Rn<Pn.length;Rn++){const e=Pn[Rn];0,4&e.flags&&(e.flags&=-2),8&e.flags||e(),e.flags&=-2}Pn=null,Rn=0}}const Hn=e=>null==e.id?2&e.flags?-1:1/0:e.id;function jn(e){try{for(Mn=0;Mn<En.length;Mn++){const e=En[Mn];!e||8&e.flags||(4&e.flags&&(e.flags&=-2),Bn(e,e.i,e.i?15:14),4&e.flags||(e.flags&=-2))}}finally{for(;Mn<En.length;Mn++){const e=En[Mn];e&&(e.flags&=-2)}Mn=-1,En.length=0,$n(),Ln=null,(En.length||Dn.length)&&jn(e)}}let qn,Wn=[],Un=!1;let Yn=null,Gn=null;function Xn(e){const t=Yn;return Yn=e,Gn=e&&e.type.__scopeId||null,t}function Jn(e){Gn=e}function Kn(){Gn=null}const Zn=e=>er;function er(e,t=Yn,n){if(!t)return e;if(e._n)return e;const r=(...n)=>{r._d&&Ls(-1);const i=Xn(t);let o;try{o=e(...n)}finally{Xn(i),r._d&&Ls(1)}return o};return r._n=!0,r._c=!0,r._d=!0,r}function tr(e,t){if(null===Yn)return e;const n=ka(Yn),r=e.dirs||(e.dirs=[]);for(let e=0;e<t.length;e++){let[i,s,a,l=o]=t[e];i&&(A(i)&&(i={mounted:i,updated:i}),i.deep&&bn(s),r.push({dir:i,instance:n,value:s,oldValue:void 0,arg:a,modifiers:l}))}return e}function nr(e,t,n,r){const i=e.dirs,o=t&&t.dirs;for(let s=0;s<i.length;s++){const a=i[s];o&&(a.oldValue=o[s].value);let l=a.dir[r];l&&($e(),_n(l,n,8,[e.el,a,e,t]),He())}}const rr=Symbol("_vte"),ir=e=>e.__isTeleport,or=e=>e&&(e.disabled||""===e.disabled),sr=e=>e&&(e.defer||""===e.defer),ar=e=>"undefined"!=typeof SVGElement&&e instanceof SVGElement,lr=e=>"function"==typeof MathMLElement&&e instanceof MathMLElement,cr=(e,t)=>{const n=e&&e.to;if(y(n)){if(t){return t(n)}return null}return n},hr={name:"Teleport",__isTeleport:!0,process(e,t,n,r,i,o,s,a,l,c){const{mc:h,pc:d,pbc:u,o:{insert:p,querySelector:f,createText:g,createComment:m}}=c,v=or(t.props);let{shapeFlag:b,children:A,dynamicChildren:y}=t;if(null==e){const e=t.el=g(""),c=t.anchor=g("");p(e,n,r),p(c,n,r);const d=(e,t)=>{16&b&&h(A,e,t,i,o,s,a,l)},u=()=>{const e=t.target=cr(t.props,f),n=fr(e,t,g,p);e&&("svg"!==s&&ar(e)?s="svg":"mathml"!==s&&lr(e)&&(s="mathml"),i&&i.isCE&&(i.ce._teleportTargets||(i.ce._teleportTargets=new Set)).add(e),v||(d(e,n),pr(t,!1)))};v&&(d(n,c),pr(t,!0)),sr(t.props)?(t.el.__isMounted=!1,zo(()=>{u(),delete t.el.__isMounted},o)):u()}else{if(sr(t.props)&&!1===e.el.__isMounted)return void zo(()=>{hr.process(e,t,n,r,i,o,s,a,l,c)},o);t.el=e.el,t.targetStart=e.targetStart;const h=t.anchor=e.anchor,p=t.target=e.target,g=t.targetAnchor=e.targetAnchor,m=or(e.props),b=m?n:p,A=m?h:g;if("svg"===s||ar(p)?s="svg":("mathml"===s||lr(p))&&(s="mathml"),y?(u(e.dynamicChildren,y,b,i,o,s,a),Yo(e,t,!0)):l||d(e,t,b,A,i,o,s,a,!1),v)m?t.props&&e.props&&t.props.to!==e.props.to&&(t.props.to=e.props.to):dr(t,n,h,c,1);else if((t.props&&t.props.to)!==(e.props&&e.props.to)){const e=t.target=cr(t.props,f);e&&dr(t,e,null,c,0)}else m&&dr(t,p,g,c,1);pr(t,v)}},remove(e,t,n,{um:r,o:{remove:i}},o){const{shapeFlag:s,children:a,anchor:l,targetStart:c,targetAnchor:h,target:d,props:u}=e;if(d&&(i(c),i(h)),o&&i(l),16&s){const e=o||!or(u);for(let i=0;i<a.length;i++){const o=a[i];r(o,t,n,e,!!o.dynamicChildren)}}},move:dr,hydrate:function(e,t,n,r,i,o,{o:{nextSibling:s,parentNode:a,querySelector:l,insert:c,createText:h}},d){function u(e,t,l,c){t.anchor=d(s(e),t,a(e),n,r,i,o),t.targetStart=l,t.targetAnchor=c}const p=t.target=cr(t.props,l),f=or(t.props);if(p){const a=p._lpa||p.firstChild;if(16&t.shapeFlag)if(f)u(e,t,a,a&&s(a));else{t.anchor=s(e);let l=a;for(;l;){if(l&&8===l.nodeType)if("teleport start anchor"===l.data)t.targetStart=l;else if("teleport anchor"===l.data){t.targetAnchor=l,p._lpa=t.targetAnchor&&s(t.targetAnchor);break}l=s(l)}t.targetAnchor||fr(p,t,h,c),d(a&&s(a),t,p,n,r,i,o)}pr(t,f)}else f&&16&t.shapeFlag&&u(e,t,e,s(e));return t.anchor&&s(t.anchor)}};function dr(e,t,n,{o:{insert:r},m:i},o=2){0===o&&r(e.targetAnchor,t,n);const{el:s,anchor:a,shapeFlag:l,children:c,props:h}=e,d=2===o;if(d&&r(s,t,n),(!d||or(h))&&16&l)for(let e=0;e<c.length;e++)i(c[e],t,n,2);d&&r(a,t,n)}const ur=hr;function pr(e,t){const n=e.ctx;if(n&&n.ut){let r,i;for(t?(r=e.el,i=e.anchor):(r=e.targetStart,i=e.targetAnchor);r&&r!==i;)1===r.nodeType&&r.setAttribute("data-v-owner",n.uid),r=r.nextSibling;n.ut()}}function fr(e,t,n,r){const i=t.targetStart=n(""),o=t.targetAnchor=n("");return i[rr]=o,e&&(r(i,e),r(o,e)),o}const gr=Symbol("_leaveCb"),mr=Symbol("_enterCb");function vr(){const e={isMounted:!1,isLeaving:!1,isUnmounting:!1,leavingVNodes:new Map};return vi(()=>{e.isMounted=!0}),yi(()=>{e.isUnmounting=!0}),e}const br=[Function,Array],Ar={mode:String,appear:Boolean,persisted:Boolean,onBeforeEnter:br,onEnter:br,onAfterEnter:br,onEnterCancelled:br,onBeforeLeave:br,onLeave:br,onAfterLeave:br,onLeaveCancelled:br,onBeforeAppear:br,onAppear:br,onAfterAppear:br,onAppearCancelled:br},yr=e=>{const t=e.subTree;return t.component?yr(t.component):t},wr={name:"BaseTransition",props:Ar,setup(e,{slots:t}){const n=la(),r=vr();return()=>{const i=t.default&&Tr(t.default(),!0);if(!i||!i.length)return;const o=Cr(i),s=$t(e),{mode:a}=s;if(r.isLeaving)return Or(o);const l=Br(o);if(!l)return Or(o);let c=Sr(l,s,r,n,e=>c=e);l.type!==_s&&_r(l,c);let h=n.subTree&&Br(n.subTree);if(h&&h.type!==_s&&!zs(h,l)&&yr(n).type!==_s){let e=Sr(h,s,r,n);if(_r(h,e),"out-in"===a&&l.type!==_s)return r.isLeaving=!0,e.afterLeave=()=>{r.isLeaving=!1,8&n.job.flags||n.update(),delete e.afterLeave,h=void 0},Or(o);"in-out"===a&&l.type!==_s?e.delayLeave=(e,t,n)=>{kr(r,h)[String(h.key)]=h,e[gr]=()=>{t(),e[gr]=void 0,delete c.delayedLeave,h=void 0},c.delayedLeave=()=>{n(),delete c.delayedLeave,h=void 0}}:h=void 0}else h&&(h=void 0);return o}}};function Cr(e){let t=e[0];if(e.length>1){let n=!1;for(const r of e)if(r.type!==_s){0,t=r,n=!0;break}}return t}const xr=wr;function kr(e,t){const{leavingVNodes:n}=e;let r=n.get(t.type);return r||(r=Object.create(null),n.set(t.type,r)),r}function Sr(e,t,n,r,i){const{appear:o,mode:s,persisted:a=!1,onBeforeEnter:l,onEnter:c,onAfterEnter:h,onEnterCancelled:d,onBeforeLeave:u,onLeave:p,onAfterLeave:f,onLeaveCancelled:m,onBeforeAppear:v,onAppear:b,onAfterAppear:A,onAppearCancelled:y}=t,w=String(e.key),C=kr(n,e),x=(e,t)=>{e&&_n(e,r,9,t)},k=(e,t)=>{const n=t[1];x(e,t),g(e)?e.every(e=>e.length<=1)&&n():e.length<=1&&n()},S={mode:s,persisted:a,beforeEnter(t){let r=l;if(!n.isMounted){if(!o)return;r=v||l}t[gr]&&t[gr](!0);const i=C[w];i&&zs(e,i)&&i.el[gr]&&i.el[gr](),x(r,[t])},enter(e){let t=c,r=h,i=d;if(!n.isMounted){if(!o)return;t=b||c,r=A||h,i=y||d}let s=!1;const a=e[mr]=t=>{s||(s=!0,x(t?i:r,[e]),S.delayedLeave&&S.delayedLeave(),e[mr]=void 0)};t?k(t,[e,a]):a()},leave(t,r){const i=String(e.key);if(t[mr]&&t[mr](!0),n.isUnmounting)return r();x(u,[t]);let o=!1;const s=t[gr]=n=>{o||(o=!0,r(),x(n?m:f,[t]),t[gr]=void 0,C[i]===e&&delete C[i])};C[i]=e,p?k(p,[t,s]):s()},clone(e){const o=Sr(e,t,n,r,i);return i&&i(o),o}};return S}function Or(e){if(ii(e))return(e=Gs(e)).children=null,e}function Br(e){if(!ii(e))return ir(e.type)&&e.children?Cr(e.children):e;if(e.component)return e.component.subTree;const{shapeFlag:t,children:n}=e;if(n){if(16&t)return n[0];if(32&t&&A(n.default))return n.default()}}function _r(e,t){6&e.shapeFlag&&e.component?(e.transition=t,_r(e.component.subTree,t)):128&e.shapeFlag?(e.ssContent.transition=t.clone(e.ssContent),e.ssFallback.transition=t.clone(e.ssFallback)):e.transition=t}function Tr(e,t=!1,n){let r=[],i=0;for(let o=0;o<e.length;o++){let s=e[o];const a=null==n?s.key:String(n)+String(null!=s.key?s.key:o);s.type===Os?(128&s.patchFlag&&i++,r=r.concat(Tr(s.children,t,a))):(t||s.type!==_s)&&r.push(null!=a?Gs(s,{key:a}):s)}if(i>1)for(let e=0;e<r.length;e++)r[e].patchFlag=-2;return r}function Er(e,t){return A(e)?(()=>d({name:e.name},t,{setup:e}))():e}function Mr(){const e=la();return e?(e.appContext.config.idPrefix||"v")+"-"+e.ids[0]+e.ids[1]++:""}function Dr(e){e.ids=[e.ids[0]+e.ids[2]+++"-",0,0]}function Pr(e){const t=la(),n=Yt(null);if(t){const r=t.refs===o?t.refs={}:t.refs;Object.defineProperty(r,e,{enumerable:!0,get:()=>n.value,set:e=>n.value=e})}else 0;return n}const Rr=new WeakMap;function Ir(e,t,n,r,i=!1){if(g(e))return void e.forEach((e,o)=>Ir(e,t&&(g(t)?t[o]:t),n,r,i));if(ti(r)&&!i)return void(512&r.shapeFlag&&r.type.__asyncResolved&&r.component.subTree.component&&Ir(e,t,n,r.component.subTree));const s=4&r.shapeFlag?ka(r.component):r.el,a=i?null:s,{i:c,r:h}=e;const d=t&&t.r,p=c.refs===o?c.refs={}:c.refs,m=c.setupState,v=$t(m),b=m===o?l:e=>f(v,e);if(null!=d&&d!==h)if(Lr(t),y(d))p[d]=null,b(d)&&(m[d]=null);else if(Wt(d)){d.value=null;const e=t;e.k&&(p[e.k]=null)}if(A(h))Bn(h,c,12,[a,p]);else{const t=y(h),r=Wt(h);if(t||r){const o=()=>{if(e.f){const n=t?b(h)?m[h]:p[h]:h.value;if(i)g(n)&&u(n,s);else if(g(n))n.includes(s)||n.push(s);else if(t)p[h]=[s],b(h)&&(m[h]=p[h]);else{const t=[s];h.value=t,e.k&&(p[e.k]=t)}}else t?(p[h]=a,b(h)&&(m[h]=a)):r&&(h.value=a,e.k&&(p[e.k]=a))};if(a){const t=()=>{o(),Rr.delete(e)};t.id=-1,Rr.set(e,t),zo(t,n)}else Lr(e),o()}else 0}}function Lr(e){const t=Rr.get(e);t&&(t.flags|=8,Rr.delete(e))}let Nr=!1;const Fr=()=>{Nr||(console.error("Hydration completed but contains mismatches."),Nr=!0)},Qr=e=>{if(1===e.nodeType)return(e=>e.namespaceURI.includes("svg")&&"foreignObject"!==e.tagName)(e)?"svg":(e=>e.namespaceURI.includes("MathML"))(e)?"mathml":void 0},Vr=e=>8===e.nodeType;function zr(e){const{mt:t,p:n,o:{patchProp:r,createText:i,nextSibling:o,parentNode:s,remove:a,insert:l,createComment:h}}=e,d=(n,r,a,c,h,A=!1)=>{A=A||!!r.dynamicChildren;const y=Vr(n)&&"["===n.data,w=()=>g(n,r,a,c,h,y),{type:C,ref:x,shapeFlag:k,patchFlag:S}=r;let O=n.nodeType;r.el=n,-2===S&&(A=!1,r.dynamicChildren=null);let B=null;switch(C){case Bs:3!==O?""===r.children?(l(r.el=i(""),s(n),n),B=n):B=w():(n.data!==r.children&&(__VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&wn("Hydration text mismatch in",n.parentNode,`\n  - rendered on server: ${JSON.stringify(n.data)}\n  - expected on client: ${JSON.stringify(r.children)}`),Fr(),n.data=r.children),B=o(n));break;case _s:b(n)?(B=o(n),v(r.el=n.content.firstChild,n,a)):B=8!==O||y?w():o(n);break;case Ts:if(y&&(O=(n=o(n)).nodeType),1===O||3===O){B=n;const e=!r.children.length;for(let t=0;t<r.staticCount;t++)e&&(r.children+=1===B.nodeType?B.outerHTML:B.data),t===r.staticCount-1&&(r.anchor=B),B=o(B);return y?o(B):B}w();break;case Os:B=y?f(n,r,a,c,h,A):w();break;default:if(1&k)B=1===O&&r.type.toLowerCase()===n.tagName.toLowerCase()||b(n)?u(n,r,a,c,h,A):w();else if(6&k){r.slotScopeIds=h;const e=s(n);if(B=y?m(n):Vr(n)&&"teleport start"===n.data?m(n,n.data,"teleport end"):o(n),t(r,e,null,a,c,Qr(e),A),ti(r)&&!r.type.__asyncResolved){let t;y?(t=Ws(Os),t.anchor=B?B.previousSibling:e.lastChild):t=3===n.nodeType?Xs(""):Ws("div"),t.el=n,r.component.subTree=t}}else 64&k?B=8!==O?w():r.type.hydrate(n,r,a,c,h,A,e,p):128&k?B=r.type.hydrate(n,r,a,c,Qr(s(n)),h,A,e,d):__VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&wn("Invalid HostVNode type:",C,`(${typeof C})`)}return null!=x&&Ir(x,null,c,r),B},u=(e,t,n,i,o,s)=>{s=s||!!t.dynamicChildren;const{type:l,props:h,patchFlag:d,shapeFlag:u,dirs:f,transition:g}=t,m="input"===l||"option"===l;if(m||-1!==d){f&&nr(t,null,n,"created");let l,A=!1;if(b(e)){A=Uo(null,g)&&n&&n.vnode.props&&n.vnode.props.appear;const r=e.content.firstChild;if(A){const e=r.getAttribute("class");e&&(r.$cls=e),g.beforeEnter(r)}v(r,e,n),t.el=e=r}if(16&u&&(!h||!h.innerHTML&&!h.textContent)){let r=p(e.firstChild,t,e,n,i,o,s),l=!1;for(;r;){Yr(e,1)||(__VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&!l&&(wn("Hydration children mismatch on",e,"\nServer rendered element contains more child nodes than client vdom."),l=!0),Fr());const t=r;r=r.nextSibling,a(t)}}else if(8&u){let n=t.children;"\n"!==n[0]||"PRE"!==e.tagName&&"TEXTAREA"!==e.tagName||(n=n.slice(1)),e.textContent!==n&&(Yr(e,0)||(__VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&wn("Hydration text content mismatch on",e,`\n  - rendered on server: ${e.textContent}\n  - expected on client: ${t.children}`),Fr()),e.textContent=t.children)}if(h)if(__VUE_PROD_HYDRATION_MISMATCH_DETAILS__||m||!s||48&d){const i=e.tagName.includes("-");for(const o in h)!__VUE_PROD_HYDRATION_MISMATCH_DETAILS__||f&&f.some(e=>e.dir.created)||!$r(e,o,h[o],t,n)||Fr(),(m&&(o.endsWith("value")||"indeterminate"===o)||c(o)&&!T(o)||"."===o[0]||i)&&r(e,o,null,h[o],void 0,n)}else if(h.onClick)r(e,"onClick",null,h.onClick,void 0,n);else if(4&d&&Ft(h.style))for(const e in h.style)h.style[e];(l=h&&h.onVnodeBeforeMount)&&ra(l,n,t),f&&nr(t,null,n,"beforeMount"),((l=h&&h.onVnodeMounted)||f||A)&&ks(()=>{l&&ra(l,n,t),A&&g.enter(e),f&&nr(t,null,n,"mounted")},i)}return e.nextSibling},p=(e,t,r,s,a,c,h)=>{h=h||!!t.dynamicChildren;const u=t.children,p=u.length;let f=!1;for(let t=0;t<p;t++){const g=h?u[t]:u[t]=Zs(u[t]),m=g.type===Bs;e?(m&&!h&&t+1<p&&Zs(u[t+1]).type===Bs&&(l(i(e.data.slice(g.children.length)),r,o(e)),e.data=g.children),e=d(e,g,s,a,c,h)):m&&!g.children?l(g.el=i(""),r):(Yr(r,1)||(__VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&!f&&(wn("Hydration children mismatch on",r,"\nServer rendered element contains fewer child nodes than client vdom."),f=!0),Fr()),n(null,g,r,null,s,a,Qr(r),c))}return e},f=(e,t,n,r,i,a)=>{const{slotScopeIds:c}=t;c&&(i=i?i.concat(c):c);const d=s(e),u=p(o(e),t,d,n,r,i,a);return u&&Vr(u)&&"]"===u.data?o(t.anchor=u):(Fr(),l(t.anchor=h("]"),d,u),u)},g=(e,t,r,i,l,c)=>{if(Yr(e.parentElement,1)||(__VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&wn("Hydration node mismatch:\n- rendered on server:",e,3===e.nodeType?"(text)":Vr(e)&&"["===e.data?"(start of fragment)":"","\n- expected on client:",t.type),Fr()),t.el=null,c){const t=m(e);for(;;){const n=o(e);if(!n||n===t)break;a(n)}}const h=o(e),d=s(e);return a(e),n(null,t,d,h,r,i,Qr(d),l),r&&(r.vnode.el=t.el,vs(r,t.el)),h},m=(e,t="[",n="]")=>{let r=0;for(;e;)if((e=o(e))&&Vr(e)&&(e.data===t&&r++,e.data===n)){if(0===r)return o(e);r--}return e},v=(e,t,n)=>{const r=t.parentNode;r&&r.replaceChild(e,t);let i=n;for(;i;)i.vnode.el===t&&(i.vnode.el=i.subTree.el=e),i=i.parent},b=e=>1===e.nodeType&&"TEMPLATE"===e.tagName;return[(e,t)=>{if(!t.hasChildNodes())return __VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&wn("Attempting to hydrate existing markup but container is empty. Performing full mount instead."),n(null,e,t),$n(),void(t._vnode=e);d(t.firstChild,e,null,null,null),$n(),t._vnode=e},d]}function $r(e,t,n,r,i){let o,s,a,l;if("class"===t)e.$cls?(a=e.$cls,delete e.$cls):a=e.getAttribute("class"),l=J(n),function(e,t){if(e.size!==t.size)return!1;for(const n of e)if(!t.has(n))return!1;return!0}(Hr(a||""),Hr(l))||(o=2,s="class");else if("style"===t){a=e.getAttribute("style")||"",l=y(n)?n:function(e){if(!e)return"";if(y(e))return e;let t="";for(const n in e){const r=e[n];(y(r)||"number"==typeof r)&&(t+=`${n.startsWith("--")?n:I(n)}:${r};`)}return t}(W(n));const t=jr(a),c=jr(l);if(r.dirs)for(const{dir:e,value:t}of r.dirs)"show"!==e.name||t||c.set("display","none");i&&qr(i,r,c),function(e,t){if(e.size!==t.size)return!1;for(const[n,r]of e)if(r!==t.get(n))return!1;return!0}(t,c)||(o=3,s="style")}else(e instanceof SVGElement&&le(t)||e instanceof HTMLElement&&(oe(t)||ae(t)))&&(oe(t)?(a=e.hasAttribute(t),l=se(n)):null==n?(a=e.hasAttribute(t),l=!1):(a=e.hasAttribute(t)?e.getAttribute(t):"value"===t&&"TEXTAREA"===e.tagName&&e.value,l=!!function(e){if(null==e)return!1;const t=typeof e;return"string"===t||"number"===t||"boolean"===t}(n)&&String(n)),a!==l&&(o=4,s=t));if(null!=o&&!Yr(e,o)){const t=e=>!1===e?"(not rendered)":`${s}="${e}"`;return wn(`Hydration ${Ur[o]} mismatch on`,e,`\n  - rendered on server: ${t(a)}\n  - expected on client: ${t(l)}\n  Note: this mismatch is check-only. The DOM will not be rectified in production due to performance overhead.\n  You should fix the source of the mismatch.`),!0}return!1}function Hr(e){return new Set(e.trim().split(/\s+/))}function jr(e){const t=new Map;for(const n of e.split(";")){let[e,r]=n.split(":");e=e.trim(),r=r&&r.trim(),e&&r&&t.set(e,r)}return t}function qr(e,t,n){const r=e.subTree;if(e.getCssVars&&(t===r||r&&r.type===Os&&r.children.includes(t))){const t=e.getCssVars();for(const e in t){const r=ve(t[e]);n.set(`--${he(e,!1)}`,r)}}t===r&&e.parent&&qr(e.parent,e.vnode,n)}const Wr="data-allow-mismatch",Ur={0:"text",1:"children",2:"class",3:"style",4:"attribute"};function Yr(e,t){if(0===t||1===t)for(;e&&!e.hasAttribute(Wr);)e=e.parentElement;const n=e&&e.getAttribute(Wr);if(null==n)return!1;if(""===n)return!0;{const e=n.split(",");return!(0!==t||!e.includes("children"))||e.includes(Ur[t])}}const Gr=j().requestIdleCallback||(e=>setTimeout(e,1)),Xr=j().cancelIdleCallback||(e=>clearTimeout(e)),Jr=(e=1e4)=>t=>{const n=Gr(t,{timeout:e});return()=>Xr(n)};const Kr=e=>(t,n)=>{const r=new IntersectionObserver(e=>{for(const n of e)if(n.isIntersecting){r.disconnect(),t();break}},e);return n(e=>{if(e instanceof Element)return function(e){const{top:t,left:n,bottom:r,right:i}=e.getBoundingClientRect(),{innerHeight:o,innerWidth:s}=window;return(t>0&&t<o||r>0&&r<o)&&(n>0&&n<s||i>0&&i<s)}(e)?(t(),r.disconnect(),!1):void r.observe(e)}),()=>r.disconnect()},Zr=e=>t=>{if(e){const n=matchMedia(e);if(!n.matches)return n.addEventListener("change",t,{once:!0}),()=>n.removeEventListener("change",t);t()}},ei=(e=[])=>(t,n)=>{y(e)&&(e=[e]);let r=!1;const i=e=>{r||(r=!0,o(),t(),e.target.dispatchEvent(new e.constructor(e.type,e)))},o=()=>{n(t=>{for(const n of e)t.removeEventListener(n,i)})};return n(t=>{for(const n of e)t.addEventListener(n,i,{once:!0})}),o};const ti=e=>!!e.type.__asyncLoader;function ni(e){A(e)&&(e={loader:e});const{loader:t,loadingComponent:n,errorComponent:r,delay:i=200,hydrate:o,timeout:s,suspensible:a=!0,onError:l}=e;let c,h=null,d=0;const u=()=>{let e;return h||(e=h=t().catch(e=>{if(e=e instanceof Error?e:new Error(String(e)),l)return new Promise((t,n)=>{l(e,()=>t((d++,h=null,u())),()=>n(e),d+1)});throw e}).then(t=>e!==h&&h?h:(t&&(t.__esModule||"Module"===t[Symbol.toStringTag])&&(t=t.default),c=t,t)))};return Er({name:"AsyncComponentWrapper",__asyncLoader:u,__asyncHydrate(e,t,n){let r=!1;(t.bu||(t.bu=[])).push(()=>r=!0);const i=()=>{r||n()},s=o?()=>{const n=o(i,t=>function(e,t){if(Vr(e)&&"["===e.data){let n=1,r=e.nextSibling;for(;r;){if(1===r.nodeType){if(!1===t(r))break}else if(Vr(r))if("]"===r.data){if(0===--n)break}else"["===r.data&&n++;r=r.nextSibling}}else t(e)}(e,t));n&&(t.bum||(t.bum=[])).push(n)}:i;c?s():u().then(()=>!t.isUnmounted&&s())},get __asyncResolved(){return c},setup(){const e=aa;if(Dr(e),c)return()=>ri(c,e);const t=t=>{h=null,Tn(t,e,13,!r)};if(a&&e.suspense||ma)return u().then(t=>()=>ri(t,e)).catch(e=>(t(e),()=>r?Ws(r,{error:e}):null));const o=Ut(!1),l=Ut(),d=Ut(!!i);return i&&setTimeout(()=>{d.value=!1},i),null!=s&&setTimeout(()=>{if(!o.value&&!l.value){const e=new Error(`Async component timed out after ${s}ms.`);t(e),l.value=e}},s),u().then(()=>{o.value=!0,e.parent&&ii(e.parent.vnode)&&e.parent.update()}).catch(e=>{t(e),l.value=e}),()=>o.value&&c?ri(c,e):l.value&&r?Ws(r,{error:l.value}):n&&!d.value?Ws(n):void 0}})}function ri(e,t){const{ref:n,props:r,children:i,ce:o}=t.vnode,s=Ws(e,r,i);return s.ref=n,s.ce=o,delete t.vnode.ce,s}const ii=e=>e.type.__isKeepAlive,oi={name:"KeepAlive",__isKeepAlive:!0,props:{include:[String,RegExp,Array],exclude:[String,RegExp,Array],max:[String,Number]},setup(e,{slots:t}){const n=la(),r=n.ctx;if(!r.renderer)return()=>{const e=t.default&&t.default();return e&&1===e.length?e[0]:e};const i=new Map,o=new Set;let s=null;const a=n.suspense,{renderer:{p:l,m:c,um:h,o:{createElement:d}}}=r,u=d("div");function p(e){ui(e),h(e,n,a,!0)}function f(e){i.forEach((t,n)=>{const r=Ba(t.type);r&&!e(r)&&g(n)})}function g(e){const t=i.get(e);!t||s&&zs(t,s)?s&&ui(s):p(t),i.delete(e),o.delete(e)}r.activate=(e,t,n,r,i)=>{const o=e.component;c(e,t,n,0,a),l(o.vnode,e,t,n,o,a,r,e.slotScopeIds,i),zo(()=>{o.isDeactivated=!1,o.a&&Q(o.a);const t=e.props&&e.props.onVnodeMounted;t&&ra(t,o.parent,e)},a)},r.deactivate=e=>{const t=e.component;Xo(t.m),Xo(t.a),c(e,u,null,1,a),zo(()=>{t.da&&Q(t.da);const n=e.props&&e.props.onVnodeUnmounted;n&&ra(n,t.parent,e),t.isDeactivated=!0},a)},ns(()=>[e.include,e.exclude],([e,t])=>{e&&f(t=>ai(e,t)),t&&f(e=>!ai(t,e))},{flush:"post",deep:!0});let m=null;const v=()=>{null!=m&&(bs(n.subTree.type)?zo(()=>{i.set(m,pi(n.subTree))},n.subTree.suspense):i.set(m,pi(n.subTree)))};return vi(v),Ai(v),yi(()=>{i.forEach(e=>{const{subTree:t,suspense:r}=n,i=pi(t);if(e.type===i.type&&e.key===i.key){ui(i);const e=i.component.da;return void(e&&zo(e,r))}p(e)})}),()=>{if(m=null,!t.default)return s=null;const n=t.default(),r=n[0];if(n.length>1)return s=null,n;if(!(Vs(r)&&(4&r.shapeFlag||128&r.shapeFlag)))return s=null,r;let a=pi(r);if(a.type===_s)return s=null,a;const l=a.type,c=Ba(ti(a)?a.type.__asyncResolved||{}:l),{include:h,exclude:d,max:u}=e;if(h&&(!c||!ai(h,c))||d&&c&&ai(d,c))return a.shapeFlag&=-257,s=a,r;const p=null==a.key?l:a.key,f=i.get(p);return a.el&&(a=Gs(a),128&r.shapeFlag&&(r.ssContent=a)),m=p,f?(a.el=f.el,a.component=f.component,a.transition&&_r(a,a.transition),a.shapeFlag|=512,o.delete(p),o.add(p)):(o.add(p),u&&o.size>parseInt(u,10)&&g(o.values().next().value)),a.shapeFlag|=256,s=a,bs(r.type)?r:a}}},si=oi;function ai(e,t){return g(e)?e.some(e=>ai(e,t)):y(e)?e.split(",").includes(t):"[object RegExp]"===S(e)&&(e.lastIndex=0,e.test(t))}function li(e,t){hi(e,"a",t)}function ci(e,t){hi(e,"da",t)}function hi(e,t,n=aa){const r=e.__wdc||(e.__wdc=()=>{let t=n;for(;t;){if(t.isDeactivated)return;t=t.parent}return e()});if(fi(t,r,n),n){let e=n.parent;for(;e&&e.parent;)ii(e.parent.vnode)&&di(r,t,n,e),e=e.parent}}function di(e,t,n,r){const i=fi(t,e,r,!0);wi(()=>{u(r[t],i)},n)}function ui(e){e.shapeFlag&=-257,e.shapeFlag&=-513}function pi(e){return 128&e.shapeFlag?e.ssContent:e}function fi(e,t,n=aa,r=!1){if(n){const i=n[e]||(n[e]=[]),o=t.__weh||(t.__weh=(...r)=>{$e();const i=da(n),o=_n(t,n,e,r);return i(),He(),o});return r?i.unshift(o):i.push(o),o}}const gi=e=>(t,n=aa)=>{ma&&"sp"!==e||fi(e,(...e)=>t(...e),n)},mi=gi("bm"),vi=gi("m"),bi=gi("bu"),Ai=gi("u"),yi=gi("bum"),wi=gi("um"),Ci=gi("sp"),xi=gi("rtg"),ki=gi("rtc");function Si(e,t=aa){fi("ec",e,t)}const Oi="components",Bi="directives";function _i(e,t){return Di(Oi,e,!0,t)||e}const Ti=Symbol.for("v-ndc");function Ei(e){return y(e)?Di(Oi,e,!1)||e:e||Ti}function Mi(e){return Di(Bi,e)}function Di(e,t,n=!0,r=!1){const i=Yn||aa;if(i){const n=i.type;if(e===Oi){const e=Ba(n,!1);if(e&&(e===t||e===P(t)||e===L(P(t))))return n}const o=Pi(i[e]||n[e],t)||Pi(i.appContext[e],t);return!o&&r?n:o}}function Pi(e,t){return e&&(e[t]||e[P(t)]||e[L(P(t))])}function Ri(e,t,n,r){let i;const o=n&&n[r],s=g(e);if(s||y(e)){let n=!1,r=!1;s&&Ft(e)&&(n=!Vt(e),r=Qt(e),e=nt(e)),i=new Array(e.length);for(let s=0,a=e.length;s<a;s++)i[s]=t(n?r?qt(jt(e[s])):jt(e[s]):e[s],s,void 0,o&&o[s])}else if("number"==typeof e){0,i=new Array(e);for(let n=0;n<e;n++)i[n]=t(n+1,n,void 0,o&&o[n])}else if(C(e))if(e[Symbol.iterator])i=Array.from(e,(e,n)=>t(e,n,void 0,o&&o[n]));else{const n=Object.keys(e);i=new Array(n.length);for(let r=0,s=n.length;r<s;r++){const s=n[r];i[r]=t(e[s],s,r,o&&o[r])}}else i=[];return n&&(n[r]=i),i}function Ii(e,t){for(let n=0;n<t.length;n++){const r=t[n];if(g(r))for(let t=0;t<r.length;t++)e[r[t].name]=r[t].fn;else r&&(e[r.name]=r.key?(...e)=>{const t=r.fn(...e);return t&&(t.key=r.key),t}:r.fn)}return e}function Li(e,t,n={},r,i){if(Yn.ce||Yn.parent&&ti(Yn.parent)&&Yn.parent.ce){const e=Object.keys(n).length>0;return"default"!==t&&(n.name=t),Ds(),Qs(Os,null,[Ws("slot",n,r&&r())],e?-2:64)}let o=e[t];o&&o._c&&(o._d=!1),Ds();const s=o&&Ni(o(n)),a=n.key||s&&s.key,l=Qs(Os,{key:(a&&!w(a)?a:`_${t}`)+(!s&&r?"_fb":"")},s||(r?r():[]),s&&1===e._?64:-2);return!i&&l.scopeId&&(l.slotScopeIds=[l.scopeId+"-s"]),o&&o._c&&(o._d=!0),l}function Ni(e){return e.some(e=>!Vs(e)||e.type!==_s&&!(e.type===Os&&!Ni(e.children)))?e:null}function Fi(e,t){const n={};for(const r in e)n[t&&/[A-Z]/.test(r)?`on:${r}`:N(r)]=e[r];return n}const Qi=e=>e?pa(e)?ka(e):Qi(e.parent):null,Vi=d(Object.create(null),{$:e=>e,$el:e=>e.vnode.el,$data:e=>e.data,$props:e=>e.props,$attrs:e=>e.attrs,$slots:e=>e.slots,$refs:e=>e.refs,$parent:e=>Qi(e.parent),$root:e=>Qi(e.root),$host:e=>e.ce,$emit:e=>e.emit,$options:e=>co(e),$forceUpdate:e=>e.f||(e.f=()=>{Fn(e.update)}),$nextTick:e=>e.n||(e.n=Nn.bind(e.proxy)),$watch:e=>is.bind(e)}),zi=(e,t)=>e!==o&&!e.__isScriptSetup&&f(e,t),$i={get({_:e},t){if("__v_skip"===t)return!0;const{ctx:n,setupState:r,data:i,props:s,accessCache:a,type:l,appContext:c}=e;let h;if("$"!==t[0]){const l=a[t];if(void 0!==l)switch(l){case 1:return r[t];case 2:return i[t];case 4:return n[t];case 3:return s[t]}else{if(zi(r,t))return a[t]=1,r[t];if(i!==o&&f(i,t))return a[t]=2,i[t];if((h=e.propsOptions[0])&&f(h,t))return a[t]=3,s[t];if(n!==o&&f(n,t))return a[t]=4,n[t];oo&&(a[t]=0)}}const d=Vi[t];let u,p;return d?("$attrs"===t&&Ze(e.attrs,0,""),d(e)):(u=l.__cssModules)&&(u=u[t])?u:n!==o&&f(n,t)?(a[t]=4,n[t]):(p=c.config.globalProperties,f(p,t)?p[t]:void 0)},set({_:e},t,n){const{data:r,setupState:i,ctx:s}=e;return zi(i,t)?(i[t]=n,!0):r!==o&&f(r,t)?(r[t]=n,!0):!f(e.props,t)&&(("$"!==t[0]||!(t.slice(1)in e))&&(s[t]=n,!0))},has({_:{data:e,setupState:t,accessCache:n,ctx:r,appContext:i,propsOptions:s,type:a}},l){let c,h;return!!(n[l]||e!==o&&"$"!==l[0]&&f(e,l)||zi(t,l)||(c=s[0])&&f(c,l)||f(r,l)||f(Vi,l)||f(i.config.globalProperties,l)||(h=a.__cssModules)&&h[l])},defineProperty(e,t,n){return null!=n.get?e._.accessCache[t]=0:f(n,"value")&&this.set(e,t,n.value,null),Reflect.defineProperty(e,t,n)}};const Hi=d({},$i,{get(e,t){if(t!==Symbol.unscopables)return $i.get(e,t,e)},has:(e,t)=>"_"!==t[0]&&!q(t)});function ji(){return null}function qi(){return null}function Wi(e){0}function Ui(e){0}function Yi(){return null}function Gi(){0}function Xi(e,t){return null}function Ji(){return Zi("useSlots").slots}function Ki(){return Zi("useAttrs").attrs}function Zi(e){const t=la();return t.setupContext||(t.setupContext=xa(t))}function eo(e){return g(e)?e.reduce((e,t)=>(e[t]=null,e),{}):e}function to(e,t){const n=eo(e);for(const e in t){if(e.startsWith("__skip"))continue;let r=n[e];r?g(r)||A(r)?r=n[e]={type:r,default:t[e]}:r.default=t[e]:null===r&&(r=n[e]={default:t[e]}),r&&t[`__skip_${e}`]&&(r.skipFactory=!0)}return n}function no(e,t){return e&&t?g(e)&&g(t)?e.concat(t):d({},eo(e),eo(t)):e||t}function ro(e,t){const n={};for(const r in e)t.includes(r)||Object.defineProperty(n,r,{enumerable:!0,get:()=>e[r]});return n}function io(e){const t=la();let n=e();return ua(),x(n)&&(n=n.catch(e=>{throw da(t),e})),[n,()=>da(t)]}let oo=!0;function so(e){const t=co(e),n=e.proxy,r=e.ctx;oo=!1,t.beforeCreate&&ao(t.beforeCreate,e,"bc");const{data:i,computed:o,methods:s,watch:l,provide:c,inject:h,created:d,beforeMount:u,mounted:p,beforeUpdate:f,updated:m,activated:v,deactivated:b,beforeDestroy:y,beforeUnmount:w,destroyed:x,unmounted:k,render:S,renderTracked:O,renderTriggered:B,errorCaptured:_,serverPrefetch:T,expose:E,inheritAttrs:M,components:D,directives:P,filters:R}=t;if(h&&function(e,t){g(e)&&(e=fo(e));for(const n in e){const r=e[n];let i;i=C(r)?"default"in r?xo(r.from||n,r.default,!0):xo(r.from||n):xo(r),Wt(i)?Object.defineProperty(t,n,{enumerable:!0,configurable:!0,get:()=>i.value,set:e=>i.value=e}):t[n]=i}}(h,r,null),s)for(const e in s){const t=s[e];A(t)&&(r[e]=t.bind(n))}if(i){0;const t=i.call(n,n);0,C(t)&&(e.data=Pt(t))}if(oo=!0,o)for(const e in o){const t=o[e],i=A(t)?t.bind(n,n):A(t.get)?t.get.bind(n,n):a;0;const s=!A(t)&&A(t.set)?t.set.bind(n):a,l=Ea({get:i,set:s});Object.defineProperty(r,e,{enumerable:!0,configurable:!0,get:()=>l.value,set:e=>l.value=e})}if(l)for(const e in l)lo(l[e],r,n,e);if(c){const e=A(c)?c.call(n):c;Reflect.ownKeys(e).forEach(t=>{Co(t,e[t])})}function I(e,t){g(t)?t.forEach(t=>e(t.bind(n))):t&&e(t.bind(n))}if(d&&ao(d,e,"c"),I(mi,u),I(vi,p),I(bi,f),I(Ai,m),I(li,v),I(ci,b),I(Si,_),I(ki,O),I(xi,B),I(yi,w),I(wi,k),I(Ci,T),g(E))if(E.length){const t=e.exposed||(e.exposed={});E.forEach(e=>{Object.defineProperty(t,e,{get:()=>n[e],set:t=>n[e]=t,enumerable:!0})})}else e.exposed||(e.exposed={});S&&e.render===a&&(e.render=S),null!=M&&(e.inheritAttrs=M),D&&(e.components=D),P&&(e.directives=P),T&&Dr(e)}function ao(e,t,n){_n(g(e)?e.map(e=>e.bind(t.proxy)):e.bind(t.proxy),t,n)}function lo(e,t,n,r){let i=r.includes(".")?os(n,r):()=>n[r];if(y(e)){const n=t[e];A(n)&&ns(i,n)}else if(A(e))ns(i,e.bind(n));else if(C(e))if(g(e))e.forEach(e=>lo(e,t,n,r));else{const r=A(e.handler)?e.handler.bind(n):t[e.handler];A(r)&&ns(i,r,e)}else 0}function co(e){const t=e.type,{mixins:n,extends:r}=t,{mixins:i,optionsCache:o,config:{optionMergeStrategies:s}}=e.appContext,a=o.get(t);let l;return a?l=a:i.length||n||r?(l={},i.length&&i.forEach(e=>ho(l,e,s,!0)),ho(l,t,s)):l=t,C(t)&&o.set(t,l),l}function ho(e,t,n,r=!1){const{mixins:i,extends:o}=t;o&&ho(e,o,n,!0),i&&i.forEach(t=>ho(e,t,n,!0));for(const i in t)if(r&&"expose"===i);else{const r=uo[i]||n&&n[i];e[i]=r?r(e[i],t[i]):t[i]}return e}const uo={data:po,props:vo,emits:vo,methods:mo,computed:mo,beforeCreate:go,created:go,beforeMount:go,mounted:go,beforeUpdate:go,updated:go,beforeDestroy:go,beforeUnmount:go,destroyed:go,unmounted:go,activated:go,deactivated:go,errorCaptured:go,serverPrefetch:go,components:mo,directives:mo,watch:function(e,t){if(!e)return t;if(!t)return e;const n=d(Object.create(null),e);for(const r in t)n[r]=go(e[r],t[r]);return n},provide:po,inject:function(e,t){return mo(fo(e),fo(t))}};function po(e,t){return t?e?function(){return d(A(e)?e.call(this,this):e,A(t)?t.call(this,this):t)}:t:e}function fo(e){if(g(e)){const t={};for(let n=0;n<e.length;n++)t[e[n]]=e[n];return t}return e}function go(e,t){return e?[...new Set([].concat(e,t))]:t}function mo(e,t){return e?d(Object.create(null),e,t):t}function vo(e,t){return e?g(e)&&g(t)?[...new Set([...e,...t])]:d(Object.create(null),eo(e),eo(null!=t?t:{})):t}function bo(){return{app:null,config:{isNativeTag:l,performance:!1,globalProperties:{},optionMergeStrategies:{},errorHandler:void 0,warnHandler:void 0,compilerOptions:{}},mixins:[],components:{},directives:{},provides:Object.create(null),optionsCache:new WeakMap,propsCache:new WeakMap,emitsCache:new WeakMap}}let Ao=0;function yo(e,t){return function(n,r=null){A(n)||(n=d({},n)),null==r||C(r)||(r=null);const i=bo(),o=new WeakSet,s=[];let a=!1;const l=i.app={_uid:Ao++,_component:n,_props:r,_container:null,_context:i,_instance:null,version:Ia,get config(){return i.config},set config(e){0},use:(e,...t)=>(o.has(e)||(e&&A(e.install)?(o.add(e),e.install(l,...t)):A(e)&&(o.add(e),e(l,...t))),l),mixin:e=>(i.mixins.includes(e)||i.mixins.push(e),l),component:(e,t)=>t?(i.components[e]=t,l):i.components[e],directive:(e,t)=>t?(i.directives[e]=t,l):i.directives[e],mount(o,s,c){if(!a){0;const h=l._ceVNode||Ws(n,r);return h.appContext=i,!0===c?c="svg":!1===c&&(c=void 0),s&&t?t(h,o):e(h,o,c),a=!0,l._container=o,o.__vue_app__=l,ka(h.component)}},onUnmount(e){s.push(e)},unmount(){a&&(_n(s,l._instance,16),e(null,l._container),delete l._container.__vue_app__)},provide:(e,t)=>(i.provides[e]=t,l),runWithContext(e){const t=wo;wo=l;try{return e()}finally{wo=t}}};return l}}let wo=null;function Co(e,t){if(aa){let n=aa.provides;const r=aa.parent&&aa.parent.provides;r===n&&(n=aa.provides=Object.create(r)),n[e]=t}else 0}function xo(e,t,n=!1){const r=la();if(r||wo){let i=wo?wo._context.provides:r?null==r.parent||r.ce?r.vnode.appContext&&r.vnode.appContext.provides:r.parent.provides:void 0;if(i&&e in i)return i[e];if(arguments.length>1)return n&&A(t)?t.call(r&&r.proxy):t}else 0}function ko(){return!(!la()&&!wo)}const So={},Oo=()=>Object.create(So),Bo=e=>Object.getPrototypeOf(e)===So;function _o(e,t,n,r){const[i,s]=e.propsOptions;let a,l=!1;if(t)for(let o in t){if(T(o))continue;const c=t[o];let h;i&&f(i,h=P(o))?s&&s.includes(h)?(a||(a={}))[h]=c:n[h]=c:ds(e.emitsOptions,o)||o in r&&c===r[o]||(r[o]=c,l=!0)}if(s){const t=$t(n),r=a||o;for(let o=0;o<s.length;o++){const a=s[o];n[a]=To(i,t,a,r[a],e,!f(r,a))}}return l}function To(e,t,n,r,i,o){const s=e[n];if(null!=s){const e=f(s,"default");if(e&&void 0===r){const e=s.default;if(s.type!==Function&&!s.skipFactory&&A(e)){const{propsDefaults:o}=i;if(n in o)r=o[n];else{const s=da(i);r=o[n]=e.call(null,t),s()}}else r=e;i.ce&&i.ce._setProp(n,r)}s[0]&&(o&&!e?r=!1:!s[1]||""!==r&&r!==I(n)||(r=!0))}return r}const Eo=new WeakMap;function Mo(e,t,n=!1){const r=n?Eo:t.propsCache,i=r.get(e);if(i)return i;const a=e.props,l={},c=[];let h=!1;if(!A(e)){const r=e=>{h=!0;const[n,r]=Mo(e,t,!0);d(l,n),r&&c.push(...r)};!n&&t.mixins.length&&t.mixins.forEach(r),e.extends&&r(e.extends),e.mixins&&e.mixins.forEach(r)}if(!a&&!h)return C(e)&&r.set(e,s),s;if(g(a))for(let e=0;e<a.length;e++){0;const t=P(a[e]);Do(t)&&(l[t]=o)}else if(a){0;for(const e in a){const t=P(e);if(Do(t)){const n=a[e],r=l[t]=g(n)||A(n)?{type:n}:d({},n),i=r.type;let o=!1,s=!0;if(g(i))for(let e=0;e<i.length;++e){const t=i[e],n=A(t)&&t.name;if("Boolean"===n){o=!0;break}"String"===n&&(s=!1)}else o=A(i)&&"Boolean"===i.name;r[0]=o,r[1]=s,(o||f(r,"default"))&&c.push(t)}}}const u=[l,c];return C(e)&&r.set(e,u),u}function Do(e){return"$"!==e[0]&&!T(e)}const Po=e=>"_"===e||"_ctx"===e||"$stable"===e,Ro=e=>g(e)?e.map(Zs):[Zs(e)],Io=(e,t,n)=>{if(t._n)return t;const r=er((...e)=>Ro(t(...e)),n);return r._c=!1,r},Lo=(e,t,n)=>{const r=e._ctx;for(const n in e){if(Po(n))continue;const i=e[n];if(A(i))t[n]=Io(0,i,r);else if(null!=i){0;const e=Ro(i);t[n]=()=>e}}},No=(e,t)=>{const n=Ro(t);e.slots.default=()=>n},Fo=(e,t,n)=>{for(const r in t)!n&&Po(r)||(e[r]=t[r])},Qo=(e,t,n)=>{const r=e.slots=Oo();if(32&e.vnode.shapeFlag){const e=t._;e?(Fo(r,t,n),n&&V(r,"_",e,!0)):Lo(t,r)}else t&&No(e,t)},Vo=(e,t,n)=>{const{vnode:r,slots:i}=e;let s=!0,a=o;if(32&r.shapeFlag){const e=t._;e?n&&1===e?s=!1:Fo(i,t,n):(s=!t.$stable,Lo(t,i)),a=t}else t&&(No(e,t),a={default:1});if(s)for(const e in i)Po(e)||null!=a[e]||delete i[e]};const zo=ks;function $o(e){return jo(e)}function Ho(e){return jo(e,zr)}function jo(e,t){"boolean"!=typeof __VUE_PROD_HYDRATION_MISMATCH_DETAILS__&&(j().__VUE_PROD_HYDRATION_MISMATCH_DETAILS__=!1);j().__VUE__=!0;const{insert:n,remove:r,patchProp:i,createElement:l,createText:c,createComment:h,setText:d,setElementText:u,parentNode:p,nextSibling:g,setScopeId:m=a,insertStaticContent:v}=e,b=(e,t,n,r=null,i=null,o=null,s=void 0,a=null,l=!!t.dynamicChildren)=>{if(e===t)return;e&&!zs(e,t)&&(r=X(e),q(e,i,o,!0),e=null),-2===t.patchFlag&&(l=!1,t.dynamicChildren=null);const{type:c,ref:h,shapeFlag:d}=t;switch(c){case Bs:A(e,t,n,r);break;case _s:y(e,t,n,r);break;case Ts:null==e&&w(t,n,r,s);break;case Os:M(e,t,n,r,i,o,s,a,l);break;default:1&d?x(e,t,n,r,i,o,s,a,l):6&d?D(e,t,n,r,i,o,s,a,l):(64&d||128&d)&&c.process(e,t,n,r,i,o,s,a,l,Z)}null!=h&&i?Ir(h,e&&e.ref,o,t||e,!t):null==h&&e&&null!=e.ref&&Ir(e.ref,null,o,e,!0)},A=(e,t,r,i)=>{if(null==e)n(t.el=c(t.children),r,i);else{const n=t.el=e.el;t.children!==e.children&&d(n,t.children)}},y=(e,t,r,i)=>{null==e?n(t.el=h(t.children||""),r,i):t.el=e.el},w=(e,t,n,r)=>{[e.el,e.anchor]=v(e.children,t,n,r,e.el,e.anchor)},C=({el:e,anchor:t})=>{let n;for(;e&&e!==t;)n=g(e),r(e),e=n;r(t)},x=(e,t,n,r,i,o,s,a,l)=>{"svg"===t.type?s="svg":"math"===t.type&&(s="mathml"),null==e?k(t,n,r,i,o,s,a,l):B(e,t,i,o,s,a,l)},k=(e,t,r,o,s,a,c,h)=>{let d,p;const{props:f,shapeFlag:g,transition:m,dirs:v}=e;if(d=e.el=l(e.type,a,f&&f.is,f),8&g?u(d,e.children):16&g&&O(e.children,d,null,o,s,qo(e,a),c,h),v&&nr(e,null,o,"created"),S(d,e,e.scopeId,c,o),f){for(const e in f)"value"===e||T(e)||i(d,e,null,f[e],a,o);"value"in f&&i(d,"value",null,f.value,a),(p=f.onVnodeBeforeMount)&&ra(p,o,e)}v&&nr(e,null,o,"beforeMount");const b=Uo(s,m);b&&m.beforeEnter(d),n(d,t,r),((p=f&&f.onVnodeMounted)||b||v)&&zo(()=>{p&&ra(p,o,e),b&&m.enter(d),v&&nr(e,null,o,"mounted")},s)},S=(e,t,n,r,i)=>{if(n&&m(e,n),r)for(let t=0;t<r.length;t++)m(e,r[t]);if(i){let n=i.subTree;if(t===n||bs(n.type)&&(n.ssContent===t||n.ssFallback===t)){const t=i.vnode;S(e,t,t.scopeId,t.slotScopeIds,i.parent)}}},O=(e,t,n,r,i,o,s,a,l=0)=>{for(let c=l;c<e.length;c++){const l=e[c]=a?ea(e[c]):Zs(e[c]);b(null,l,t,n,r,i,o,s,a)}},B=(e,t,n,r,s,a,l)=>{const c=t.el=e.el;let{patchFlag:h,dynamicChildren:d,dirs:p}=t;h|=16&e.patchFlag;const f=e.props||o,g=t.props||o;let m;if(n&&Wo(n,!1),(m=g.onVnodeBeforeUpdate)&&ra(m,n,t,e),p&&nr(t,e,n,"beforeUpdate"),n&&Wo(n,!0),(f.innerHTML&&null==g.innerHTML||f.textContent&&null==g.textContent)&&u(c,""),d?_(e.dynamicChildren,d,c,n,r,qo(t,s),a):l||V(e,t,c,null,n,r,qo(t,s),a,!1),h>0){if(16&h)E(c,f,g,n,s);else if(2&h&&f.class!==g.class&&i(c,"class",null,g.class,s),4&h&&i(c,"style",f.style,g.style,s),8&h){const e=t.dynamicProps;for(let t=0;t<e.length;t++){const r=e[t],o=f[r],a=g[r];a===o&&"value"!==r||i(c,r,o,a,s,n)}}1&h&&e.children!==t.children&&u(c,t.children)}else l||null!=d||E(c,f,g,n,s);((m=g.onVnodeUpdated)||p)&&zo(()=>{m&&ra(m,n,t,e),p&&nr(t,e,n,"updated")},r)},_=(e,t,n,r,i,o,s)=>{for(let a=0;a<t.length;a++){const l=e[a],c=t[a],h=l.el&&(l.type===Os||!zs(l,c)||198&l.shapeFlag)?p(l.el):n;b(l,c,h,null,r,i,o,s,!0)}},E=(e,t,n,r,s)=>{if(t!==n){if(t!==o)for(const o in t)T(o)||o in n||i(e,o,t[o],null,s,r);for(const o in n){if(T(o))continue;const a=n[o],l=t[o];a!==l&&"value"!==o&&i(e,o,l,a,s,r)}"value"in n&&i(e,"value",t.value,n.value,s)}},M=(e,t,r,i,o,s,a,l,h)=>{const d=t.el=e?e.el:c(""),u=t.anchor=e?e.anchor:c("");let{patchFlag:p,dynamicChildren:f,slotScopeIds:g}=t;g&&(l=l?l.concat(g):g),null==e?(n(d,r,i),n(u,r,i),O(t.children||[],r,u,o,s,a,l,h)):p>0&&64&p&&f&&e.dynamicChildren?(_(e.dynamicChildren,f,r,o,s,a,l),(null!=t.key||o&&t===o.subTree)&&Yo(e,t,!0)):V(e,t,r,u,o,s,a,l,h)},D=(e,t,n,r,i,o,s,a,l)=>{t.slotScopeIds=a,null==e?512&t.shapeFlag?i.ctx.activate(t,n,r,s,l):R(t,n,r,i,o,s,l):L(e,t,l)},R=(e,t,n,r,i,o,s)=>{const a=e.component=sa(e,r,i);if(ii(e)&&(a.ctx.renderer=Z),va(a,!1,s),a.asyncDep){if(i&&i.registerDep(a,N,s),!e.el){const r=a.subTree=Ws(_s);y(null,r,t,n),e.placeholder=r.el}}else N(a,e,t,n,i,o,s)},L=(e,t,n)=>{const r=t.component=e.component;if(function(e,t,n){const{props:r,children:i,component:o}=e,{props:s,children:a,patchFlag:l}=t,c=o.emitsOptions;0;if(t.dirs||t.transition)return!0;if(!(n&&l>=0))return!(!i&&!a||a&&a.$stable)||r!==s&&(r?!s||ms(r,s,c):!!s);if(1024&l)return!0;if(16&l)return r?ms(r,s,c):!!s;if(8&l){const e=t.dynamicProps;for(let t=0;t<e.length;t++){const n=e[t];if(s[n]!==r[n]&&!ds(c,n))return!0}}return!1}(e,t,n)){if(r.asyncDep&&!r.asyncResolved)return void F(r,t,n);r.next=t,r.update()}else t.el=e.el,r.vnode=t},N=(e,t,n,r,i,o,s)=>{const a=()=>{if(e.isMounted){let{next:t,bu:n,u:r,parent:l,vnode:c}=e;{const n=Go(e);if(n)return t&&(t.el=c.el,F(e,t,s)),void n.asyncDep.then(()=>{e.isUnmounted||a()})}let h,d=t;0,Wo(e,!1),t?(t.el=c.el,F(e,t,s)):t=c,n&&Q(n),(h=t.props&&t.props.onVnodeBeforeUpdate)&&ra(h,l,t,c),Wo(e,!0);const u=us(e);0;const f=e.subTree;e.subTree=u,b(f,u,p(f.el),X(f),e,i,o),t.el=u.el,null===d&&vs(e,u.el),r&&zo(r,i),(h=t.props&&t.props.onVnodeUpdated)&&zo(()=>ra(h,l,t,c),i)}else{let s;const{el:a,props:l}=t,{bm:c,m:h,parent:d,root:u,type:p}=e,f=ti(t);if(Wo(e,!1),c&&Q(c),!f&&(s=l&&l.onVnodeBeforeMount)&&ra(s,d,t),Wo(e,!0),a&&te){const t=()=>{e.subTree=us(e),te(a,e.subTree,e,i,null)};f&&p.__asyncHydrate?p.__asyncHydrate(a,e,t):t()}else{u.ce&&!1!==u.ce._def.shadowRoot&&u.ce._injectChildStyle(p);const s=e.subTree=us(e);0,b(null,s,n,r,e,i,o),t.el=s.el}if(h&&zo(h,i),!f&&(s=l&&l.onVnodeMounted)){const e=t;zo(()=>ra(s,d,e),i)}(256&t.shapeFlag||d&&ti(d.vnode)&&256&d.vnode.shapeFlag)&&e.a&&zo(e.a,i),e.isMounted=!0,t=n=r=null}};e.scope.on();const l=e.effect=new Se(a);e.scope.off();const c=e.update=l.run.bind(l),h=e.job=l.runIfDirty.bind(l);h.i=e,h.id=e.uid,l.scheduler=()=>Fn(h),Wo(e,!0),c()},F=(e,t,n)=>{t.component=e;const r=e.vnode.props;e.vnode=t,e.next=null,function(e,t,n,r){const{props:i,attrs:o,vnode:{patchFlag:s}}=e,a=$t(i),[l]=e.propsOptions;let c=!1;if(!(r||s>0)||16&s){let r;_o(e,t,i,o)&&(c=!0);for(const o in a)t&&(f(t,o)||(r=I(o))!==o&&f(t,r))||(l?!n||void 0===n[o]&&void 0===n[r]||(i[o]=To(l,a,o,void 0,e,!0)):delete i[o]);if(o!==a)for(const e in o)t&&f(t,e)||(delete o[e],c=!0)}else if(8&s){const n=e.vnode.dynamicProps;for(let r=0;r<n.length;r++){let s=n[r];if(ds(e.emitsOptions,s))continue;const h=t[s];if(l)if(f(o,s))h!==o[s]&&(o[s]=h,c=!0);else{const t=P(s);i[t]=To(l,a,t,h,e,!1)}else h!==o[s]&&(o[s]=h,c=!0)}}c&&et(e.attrs,"set","")}(e,t.props,r,n),Vo(e,t.children,n),$e(),zn(e),He()},V=(e,t,n,r,i,o,s,a,l=!1)=>{const c=e&&e.children,h=e?e.shapeFlag:0,d=t.children,{patchFlag:p,shapeFlag:f}=t;if(p>0){if(128&p)return void $(c,d,n,r,i,o,s,a,l);if(256&p)return void z(c,d,n,r,i,o,s,a,l)}8&f?(16&h&&G(c,i,o),d!==c&&u(n,d)):16&h?16&f?$(c,d,n,r,i,o,s,a,l):G(c,i,o,!0):(8&h&&u(n,""),16&f&&O(d,n,r,i,o,s,a,l))},z=(e,t,n,r,i,o,a,l,c)=>{t=t||s;const h=(e=e||s).length,d=t.length,u=Math.min(h,d);let p;for(p=0;p<u;p++){const r=t[p]=c?ea(t[p]):Zs(t[p]);b(e[p],r,n,null,i,o,a,l,c)}h>d?G(e,i,o,!0,!1,u):O(t,n,r,i,o,a,l,c,u)},$=(e,t,n,r,i,o,a,l,c)=>{let h=0;const d=t.length;let u=e.length-1,p=d-1;for(;h<=u&&h<=p;){const r=e[h],s=t[h]=c?ea(t[h]):Zs(t[h]);if(!zs(r,s))break;b(r,s,n,null,i,o,a,l,c),h++}for(;h<=u&&h<=p;){const r=e[u],s=t[p]=c?ea(t[p]):Zs(t[p]);if(!zs(r,s))break;b(r,s,n,null,i,o,a,l,c),u--,p--}if(h>u){if(h<=p){const e=p+1,s=e<d?t[e].el:r;for(;h<=p;)b(null,t[h]=c?ea(t[h]):Zs(t[h]),n,s,i,o,a,l,c),h++}}else if(h>p)for(;h<=u;)q(e[h],i,o,!0),h++;else{const f=h,g=h,m=new Map;for(h=g;h<=p;h++){const e=t[h]=c?ea(t[h]):Zs(t[h]);null!=e.key&&m.set(e.key,h)}let v,A=0;const y=p-g+1;let w=!1,C=0;const x=new Array(y);for(h=0;h<y;h++)x[h]=0;for(h=f;h<=u;h++){const r=e[h];if(A>=y){q(r,i,o,!0);continue}let s;if(null!=r.key)s=m.get(r.key);else for(v=g;v<=p;v++)if(0===x[v-g]&&zs(r,t[v])){s=v;break}void 0===s?q(r,i,o,!0):(x[s-g]=h+1,s>=C?C=s:w=!0,b(r,t[s],n,null,i,o,a,l,c),A++)}const k=w?function(e){const t=e.slice(),n=[0];let r,i,o,s,a;const l=e.length;for(r=0;r<l;r++){const l=e[r];if(0!==l){if(i=n[n.length-1],e[i]<l){t[r]=i,n.push(r);continue}for(o=0,s=n.length-1;o<s;)a=o+s>>1,e[n[a]]<l?o=a+1:s=a;l<e[n[o]]&&(o>0&&(t[r]=n[o-1]),n[o]=r)}}o=n.length,s=n[o-1];for(;o-- >0;)n[o]=s,s=t[s];return n}(x):s;for(v=k.length-1,h=y-1;h>=0;h--){const e=g+h,s=t[e],u=t[e+1],p=e+1<d?u.el||u.placeholder:r;0===x[h]?b(null,s,n,p,i,o,a,l,c):w&&(v<0||h!==k[v]?H(s,n,p,2):v--)}}},H=(e,t,i,o,s=null)=>{const{el:a,type:l,transition:c,children:h,shapeFlag:d}=e;if(6&d)return void H(e.component.subTree,t,i,o);if(128&d)return void e.suspense.move(t,i,o);if(64&d)return void l.move(e,t,i,Z);if(l===Os){n(a,t,i);for(let e=0;e<h.length;e++)H(h[e],t,i,o);return void n(e.anchor,t,i)}if(l===Ts)return void(({el:e,anchor:t},r,i)=>{let o;for(;e&&e!==t;)o=g(e),n(e,r,i),e=o;n(t,r,i)})(e,t,i);if(2!==o&&1&d&&c)if(0===o)c.beforeEnter(a),n(a,t,i),zo(()=>c.enter(a),s);else{const{leave:o,delayLeave:s,afterLeave:l}=c,h=()=>{e.ctx.isUnmounted?r(a):n(a,t,i)},d=()=>{a._isLeaving&&a[gr](!0),o(a,()=>{h(),l&&l()})};s?s(a,h,d):d()}else n(a,t,i)},q=(e,t,n,r=!1,i=!1)=>{const{type:o,props:s,ref:a,children:l,dynamicChildren:c,shapeFlag:h,patchFlag:d,dirs:u,cacheIndex:p}=e;if(-2===d&&(i=!1),null!=a&&($e(),Ir(a,null,n,e,!0),He()),null!=p&&(t.renderCache[p]=void 0),256&h)return void t.ctx.deactivate(e);const f=1&h&&u,g=!ti(e);let m;if(g&&(m=s&&s.onVnodeBeforeUnmount)&&ra(m,t,e),6&h)Y(e.component,n,r);else{if(128&h)return void e.suspense.unmount(n,r);f&&nr(e,null,t,"beforeUnmount"),64&h?e.type.remove(e,t,n,Z,r):c&&!c.hasOnce&&(o!==Os||d>0&&64&d)?G(c,t,n,!1,!0):(o===Os&&384&d||!i&&16&h)&&G(l,t,n),r&&W(e)}(g&&(m=s&&s.onVnodeUnmounted)||f)&&zo(()=>{m&&ra(m,t,e),f&&nr(e,null,t,"unmounted")},n)},W=e=>{const{type:t,el:n,anchor:i,transition:o}=e;if(t===Os)return void U(n,i);if(t===Ts)return void C(e);const s=()=>{r(n),o&&!o.persisted&&o.afterLeave&&o.afterLeave()};if(1&e.shapeFlag&&o&&!o.persisted){const{leave:t,delayLeave:r}=o,i=()=>t(n,s);r?r(e.el,s,i):i()}else s()},U=(e,t)=>{let n;for(;e!==t;)n=g(e),r(e),e=n;r(t)},Y=(e,t,n)=>{const{bum:r,scope:i,job:o,subTree:s,um:a,m:l,a:c}=e;Xo(l),Xo(c),r&&Q(r),i.stop(),o&&(o.flags|=8,q(s,e,t,n)),a&&zo(a,t),zo(()=>{e.isUnmounted=!0},t)},G=(e,t,n,r=!1,i=!1,o=0)=>{for(let s=o;s<e.length;s++)q(e[s],t,n,r,i)},X=e=>{if(6&e.shapeFlag)return X(e.component.subTree);if(128&e.shapeFlag)return e.suspense.next();const t=g(e.anchor||e.el),n=t&&t[rr];return n?g(n):t};let J=!1;const K=(e,t,n)=>{null==e?t._vnode&&q(t._vnode,null,null,!0):b(t._vnode||null,e,t,null,null,null,n),t._vnode=e,J||(J=!0,zn(),$n(),J=!1)},Z={p:b,um:q,m:H,r:W,mt:R,mc:O,pc:V,pbc:_,n:X,o:e};let ee,te;return t&&([ee,te]=t(Z)),{render:K,hydrate:ee,createApp:yo(K,ee)}}function qo({type:e,props:t},n){return"svg"===n&&"foreignObject"===e||"mathml"===n&&"annotation-xml"===e&&t&&t.encoding&&t.encoding.includes("html")?void 0:n}function Wo({effect:e,job:t},n){n?(e.flags|=32,t.flags|=4):(e.flags&=-33,t.flags&=-5)}function Uo(e,t){return(!e||e&&!e.pendingBranch)&&t&&!t.persisted}function Yo(e,t,n=!1){const r=e.children,i=t.children;if(g(r)&&g(i))for(let e=0;e<r.length;e++){const t=r[e];let o=i[e];1&o.shapeFlag&&!o.dynamicChildren&&((o.patchFlag<=0||32===o.patchFlag)&&(o=i[e]=ea(i[e]),o.el=t.el),n||-2===o.patchFlag||Yo(t,o)),o.type===Bs&&-1!==o.patchFlag&&(o.el=t.el),o.type!==_s||o.el||(o.el=t.el)}}function Go(e){const t=e.subTree.component;if(t)return t.asyncDep&&!t.asyncResolved?t:Go(t)}function Xo(e){if(e)for(let t=0;t<e.length;t++)e[t].flags|=8}const Jo=Symbol.for("v-scx"),Ko=()=>{{const e=xo(Jo);return e}};function Zo(e,t){return rs(e,null,t)}function es(e,t){return rs(e,null,{flush:"post"})}function ts(e,t){return rs(e,null,{flush:"sync"})}function ns(e,t,n){return rs(e,t,n)}function rs(e,t,n=o){const{immediate:r,deep:i,flush:s,once:l}=n;const c=d({},n);const h=t&&r||!t&&"post"!==s;let p;if(ma)if("sync"===s){const e=Ko();p=e.__watcherHandles||(e.__watcherHandles=[])}else if(!h){const e=()=>{};return e.stop=a,e.resume=a,e.pause=a,e}const f=aa;c.call=(e,t,n)=>_n(e,f,t,n);let m=!1;"post"===s?c.scheduler=e=>{zo(e,f&&f.suspense)}:"sync"!==s&&(m=!0,c.scheduler=(e,t)=>{t?e():Fn(e)}),c.augmentJob=e=>{t&&(e.flags|=4),m&&(e.flags|=2,f&&(e.id=f.uid,e.i=f))};const v=function(e,t,n=o){const{immediate:r,deep:i,once:s,scheduler:l,augmentJob:c,call:h}=n,d=e=>i?e:Vt(e)||!1===i||0===i?bn(e,1):bn(e);let p,f,m,v,b=!1,y=!1;if(Wt(e)?(f=()=>e.value,b=Vt(e)):Ft(e)?(f=()=>d(e),b=!0):g(e)?(y=!0,b=e.some(e=>Ft(e)||Vt(e)),f=()=>e.map(e=>Wt(e)?e.value:Ft(e)?d(e):A(e)?h?h(e,2):e():void 0)):f=A(e)?t?h?()=>h(e,2):e:()=>{if(m){$e();try{m()}finally{He()}}const t=gn;gn=p;try{return h?h(e,3,[v]):e(v)}finally{gn=t}}:a,t&&i){const e=f,t=!0===i?1/0:i;f=()=>bn(e(),t)}const w=Ce(),C=()=>{p.stop(),w&&w.active&&u(w.effects,p)};if(s&&t){const e=t;t=(...t)=>{e(...t),C()}}let x=y?new Array(e.length).fill(pn):pn;const k=e=>{if(1&p.flags&&(p.dirty||e))if(t){const e=p.run();if(i||b||(y?e.some((e,t)=>F(e,x[t])):F(e,x))){m&&m();const n=gn;gn=p;try{const n=[e,x===pn?void 0:y&&x[0]===pn?[]:x,v];x=e,h?h(t,3,n):t(...n)}finally{gn=n}}}else p.run()};return c&&c(k),p=new Se(f),p.scheduler=l?()=>l(k,!1):k,v=e=>vn(e,!1,p),m=p.onStop=()=>{const e=fn.get(p);if(e){if(h)h(e,4);else for(const t of e)t();fn.delete(p)}},t?r?k(!0):x=p.run():l?l(k.bind(null,!0),!0):p.run(),C.pause=p.pause.bind(p),C.resume=p.resume.bind(p),C.stop=C,C}(e,t,c);return ma&&(p?p.push(v):h&&v()),v}function is(e,t,n){const r=this.proxy,i=y(e)?e.includes(".")?os(r,e):()=>r[e]:e.bind(r,r);let o;A(t)?o=t:(o=t.handler,n=t);const s=da(this),a=rs(i,o.bind(r),n);return s(),a}function os(e,t){const n=t.split(".");return()=>{let t=e;for(let e=0;e<n.length&&t;e++)t=t[n[e]];return t}}function ss(e,t,n=o){const r=la();const i=P(t);const s=I(t),a=as(e,i),l=rn((a,l)=>{let c,h,d=o;return ts(()=>{const t=e[i];F(c,t)&&(c=t,l())}),{get:()=>(a(),n.get?n.get(c):c),set(e){const a=n.set?n.set(e):e;if(!(F(a,c)||d!==o&&F(e,d)))return;const u=r.vnode.props;u&&(t in u||i in u||s in u)&&(`onUpdate:${t}`in u||`onUpdate:${i}`in u||`onUpdate:${s}`in u)||(c=e,l()),r.emit(`update:${t}`,a),F(e,a)&&F(e,d)&&!F(a,h)&&l(),d=e,h=a}}});return l[Symbol.iterator]=()=>{let e=0;return{next:()=>e<2?{value:e++?a||o:l,done:!1}:{done:!0}}},l}const as=(e,t)=>"modelValue"===t||"model-value"===t?e.modelModifiers:e[`${t}Modifiers`]||e[`${P(t)}Modifiers`]||e[`${I(t)}Modifiers`];function ls(e,t,...n){if(e.isUnmounted)return;const r=e.vnode.props||o;let i=n;const s=t.startsWith("update:"),a=s&&as(r,t.slice(7));let l;a&&(a.trim&&(i=n.map(e=>y(e)?e.trim():e)),a.number&&(i=n.map(z)));let c=r[l=N(t)]||r[l=N(P(t))];!c&&s&&(c=r[l=N(I(t))]),c&&_n(c,e,6,i);const h=r[l+"Once"];if(h){if(e.emitted){if(e.emitted[l])return}else e.emitted={};e.emitted[l]=!0,_n(h,e,6,i)}}const cs=new WeakMap;function hs(e,t,n=!1){const r=n?cs:t.emitsCache,i=r.get(e);if(void 0!==i)return i;const o=e.emits;let s={},a=!1;if(!A(e)){const r=e=>{const n=hs(e,t,!0);n&&(a=!0,d(s,n))};!n&&t.mixins.length&&t.mixins.forEach(r),e.extends&&r(e.extends),e.mixins&&e.mixins.forEach(r)}return o||a?(g(o)?o.forEach(e=>s[e]=null):d(s,o),C(e)&&r.set(e,s),s):(C(e)&&r.set(e,null),null)}function ds(e,t){return!(!e||!c(t))&&(t=t.slice(2).replace(/Once$/,""),f(e,t[0].toLowerCase()+t.slice(1))||f(e,I(t))||f(e,t))}function us(e){const{type:t,vnode:n,proxy:r,withProxy:i,propsOptions:[o],slots:s,attrs:a,emit:l,render:c,renderCache:d,props:u,data:p,setupState:f,ctx:g,inheritAttrs:m}=e,v=Xn(e);let b,A;try{if(4&n.shapeFlag){const e=i||r,t=e;b=Zs(c.call(t,e,d,u,f,p,g)),A=a}else{const e=t;0,b=Zs(e.length>1?e(u,{attrs:a,slots:s,emit:l}):e(u,null)),A=t.props?a:fs(a)}}catch(t){Es.length=0,Tn(t,e,1),b=Ws(_s)}let y=b;if(A&&!1!==m){const e=Object.keys(A),{shapeFlag:t}=y;e.length&&7&t&&(o&&e.some(h)&&(A=gs(A,o)),y=Gs(y,A,!1,!0))}return n.dirs&&(y=Gs(y,null,!1,!0),y.dirs=y.dirs?y.dirs.concat(n.dirs):n.dirs),n.transition&&_r(y,n.transition),b=y,Xn(v),b}function ps(e,t=!0){let n;for(let t=0;t<e.length;t++){const r=e[t];if(!Vs(r))return;if(r.type!==_s||"v-if"===r.children){if(n)return;n=r}}return n}const fs=e=>{let t;for(const n in e)("class"===n||"style"===n||c(n))&&((t||(t={}))[n]=e[n]);return t},gs=(e,t)=>{const n={};for(const r in e)h(r)&&r.slice(9)in t||(n[r]=e[r]);return n};function ms(e,t,n){const r=Object.keys(t);if(r.length!==Object.keys(e).length)return!0;for(let i=0;i<r.length;i++){const o=r[i];if(t[o]!==e[o]&&!ds(n,o))return!0}return!1}function vs({vnode:e,parent:t},n){for(;t;){const r=t.subTree;if(r.suspense&&r.suspense.activeBranch===e&&(r.el=e.el),r!==e)break;(e=t.vnode).el=n,t=t.parent}}const bs=e=>e.__isSuspense;let As=0;const ys={name:"Suspense",__isSuspense:!0,process(e,t,n,r,i,o,s,a,l,c){if(null==e)!function(e,t,n,r,i,o,s,a,l){const{p:c,o:{createElement:h}}=l,d=h("div"),u=e.suspense=Cs(e,i,r,t,d,n,o,s,a,l);c(null,u.pendingBranch=e.ssContent,d,null,r,u,o,s),u.deps>0?(ws(e,"onPending"),ws(e,"onFallback"),c(null,e.ssFallback,t,n,r,null,o,s),Ss(u,e.ssFallback)):u.resolve(!1,!0)}(t,n,r,i,o,s,a,l,c);else{if(o&&o.deps>0&&!e.suspense.isInFallback)return t.suspense=e.suspense,t.suspense.vnode=t,void(t.el=e.el);!function(e,t,n,r,i,o,s,a,{p:l,um:c,o:{createElement:h}}){const d=t.suspense=e.suspense;d.vnode=t,t.el=e.el;const u=t.ssContent,p=t.ssFallback,{activeBranch:f,pendingBranch:g,isInFallback:m,isHydrating:v}=d;if(g)d.pendingBranch=u,zs(g,u)?(l(g,u,d.hiddenContainer,null,i,d,o,s,a),d.deps<=0?d.resolve():m&&(v||(l(f,p,n,r,i,null,o,s,a),Ss(d,p)))):(d.pendingId=As++,v?(d.isHydrating=!1,d.activeBranch=g):c(g,i,d),d.deps=0,d.effects.length=0,d.hiddenContainer=h("div"),m?(l(null,u,d.hiddenContainer,null,i,d,o,s,a),d.deps<=0?d.resolve():(l(f,p,n,r,i,null,o,s,a),Ss(d,p))):f&&zs(f,u)?(l(f,u,n,r,i,d,o,s,a),d.resolve(!0)):(l(null,u,d.hiddenContainer,null,i,d,o,s,a),d.deps<=0&&d.resolve()));else if(f&&zs(f,u))l(f,u,n,r,i,d,o,s,a),Ss(d,u);else if(ws(t,"onPending"),d.pendingBranch=u,512&u.shapeFlag?d.pendingId=u.component.suspenseId:d.pendingId=As++,l(null,u,d.hiddenContainer,null,i,d,o,s,a),d.deps<=0)d.resolve();else{const{timeout:e,pendingId:t}=d;e>0?setTimeout(()=>{d.pendingId===t&&d.fallback(p)},e):0===e&&d.fallback(p)}}(e,t,n,r,i,s,a,l,c)}},hydrate:function(e,t,n,r,i,o,s,a,l){const c=t.suspense=Cs(t,r,n,e.parentNode,document.createElement("div"),null,i,o,s,a,!0),h=l(e,c.pendingBranch=t.ssContent,n,c,o,s);0===c.deps&&c.resolve(!1,!0);return h},normalize:function(e){const{shapeFlag:t,children:n}=e,r=32&t;e.ssContent=xs(r?n.default:n),e.ssFallback=r?xs(n.fallback):Ws(_s)}};function ws(e,t){const n=e.props&&e.props[t];A(n)&&n()}function Cs(e,t,n,r,i,o,s,a,l,c,h=!1){const{p:d,m:u,um:p,n:f,o:{parentNode:g,remove:m}}=c;let v;const b=function(e){const t=e.props&&e.props.suspensible;return null!=t&&!1!==t}(e);b&&t&&t.pendingBranch&&(v=t.pendingId,t.deps++);const A=e.props?$(e.props.timeout):void 0;const y=o,w={vnode:e,parent:t,parentComponent:n,namespace:s,container:r,hiddenContainer:i,deps:0,pendingId:As++,timeout:"number"==typeof A?A:-1,activeBranch:null,pendingBranch:null,isInFallback:!h,isHydrating:h,isUnmounted:!1,effects:[],resolve(e=!1,n=!1){const{vnode:r,activeBranch:i,pendingBranch:s,pendingId:a,effects:l,parentComponent:c,container:h}=w;let d=!1;w.isHydrating?w.isHydrating=!1:e||(d=i&&s.transition&&"out-in"===s.transition.mode,d&&(i.transition.afterLeave=()=>{a===w.pendingId&&(u(s,h,o===y?f(i):o,0),Vn(l))}),i&&(g(i.el)===h&&(o=f(i)),p(i,c,w,!0)),d||u(s,h,o,0)),Ss(w,s),w.pendingBranch=null,w.isInFallback=!1;let m=w.parent,A=!1;for(;m;){if(m.pendingBranch){m.effects.push(...l),A=!0;break}m=m.parent}A||d||Vn(l),w.effects=[],b&&t&&t.pendingBranch&&v===t.pendingId&&(t.deps--,0!==t.deps||n||t.resolve()),ws(r,"onResolve")},fallback(e){if(!w.pendingBranch)return;const{vnode:t,activeBranch:n,parentComponent:r,container:i,namespace:o}=w;ws(t,"onFallback");const s=f(n),c=()=>{w.isInFallback&&(d(null,e,i,s,r,null,o,a,l),Ss(w,e))},h=e.transition&&"out-in"===e.transition.mode;h&&(n.transition.afterLeave=c),w.isInFallback=!0,p(n,r,null,!0),h||c()},move(e,t,n){w.activeBranch&&u(w.activeBranch,e,t,n),w.container=e},next:()=>w.activeBranch&&f(w.activeBranch),registerDep(e,t,n){const r=!!w.pendingBranch;r&&w.deps++;const i=e.vnode.el;e.asyncDep.catch(t=>{Tn(t,e,0)}).then(o=>{if(e.isUnmounted||w.isUnmounted||w.pendingId!==e.suspenseId)return;e.asyncResolved=!0;const{vnode:a}=e;ba(e,o,!1),i&&(a.el=i);const l=!i&&e.subTree.el;t(e,a,g(i||e.subTree.el),i?null:f(e.subTree),w,s,n),l&&m(l),vs(e,a.el),r&&0===--w.deps&&w.resolve()})},unmount(e,t){w.isUnmounted=!0,w.activeBranch&&p(w.activeBranch,n,e,t),w.pendingBranch&&p(w.pendingBranch,n,e,t)}};return w}function xs(e){let t;if(A(e)){const n=Is&&e._c;n&&(e._d=!1,Ds()),e=e(),n&&(e._d=!0,t=Ms,Ps())}if(g(e)){const t=ps(e);0,e=t}return e=Zs(e),t&&!e.dynamicChildren&&(e.dynamicChildren=t.filter(t=>t!==e)),e}function ks(e,t){t&&t.pendingBranch?g(e)?t.effects.push(...e):t.effects.push(e):Vn(e)}function Ss(e,t){e.activeBranch=t;const{vnode:n,parentComponent:r}=e;let i=t.el;for(;!i&&t.component;)i=(t=t.component.subTree).el;n.el=i,r&&r.subTree===n&&(r.vnode.el=i,vs(r,i))}const Os=Symbol.for("v-fgt"),Bs=Symbol.for("v-txt"),_s=Symbol.for("v-cmt"),Ts=Symbol.for("v-stc"),Es=[];let Ms=null;function Ds(e=!1){Es.push(Ms=e?null:[])}function Ps(){Es.pop(),Ms=Es[Es.length-1]||null}let Rs,Is=1;function Ls(e,t=!1){Is+=e,e<0&&Ms&&t&&(Ms.hasOnce=!0)}function Ns(e){return e.dynamicChildren=Is>0?Ms||s:null,Ps(),Is>0&&Ms&&Ms.push(e),e}function Fs(e,t,n,r,i,o){return Ns(qs(e,t,n,r,i,o,!0))}function Qs(e,t,n,r,i){return Ns(Ws(e,t,n,r,i,!0))}function Vs(e){return!!e&&!0===e.__v_isVNode}function zs(e,t){return e.type===t.type&&e.key===t.key}function $s(e){Rs=e}const Hs=({key:e})=>null!=e?e:null,js=({ref:e,ref_key:t,ref_for:n})=>("number"==typeof e&&(e=""+e),null!=e?y(e)||Wt(e)||A(e)?{i:Yn,r:e,k:t,f:!!n}:e:null);function qs(e,t=null,n=null,r=0,i=null,o=(e===Os?0:1),s=!1,a=!1){const l={__v_isVNode:!0,__v_skip:!0,type:e,props:t,key:t&&Hs(t),ref:t&&js(t),scopeId:Gn,slotScopeIds:null,children:n,component:null,suspense:null,ssContent:null,ssFallback:null,dirs:null,transition:null,el:null,anchor:null,target:null,targetStart:null,targetAnchor:null,staticCount:0,shapeFlag:o,patchFlag:r,dynamicProps:i,dynamicChildren:null,appContext:null,ctx:Yn};return a?(ta(l,n),128&o&&e.normalize(l)):n&&(l.shapeFlag|=y(n)?8:16),Is>0&&!s&&Ms&&(l.patchFlag>0||6&o)&&32!==l.patchFlag&&Ms.push(l),l}const Ws=Us;function Us(e,t=null,n=null,r=0,i=null,o=!1){if(e&&e!==Ti||(e=_s),Vs(e)){const r=Gs(e,t,!0);return n&&ta(r,n),Is>0&&!o&&Ms&&(6&r.shapeFlag?Ms[Ms.indexOf(e)]=r:Ms.push(r)),r.patchFlag=-2,r}if(Ta(e)&&(e=e.__vccOpts),t){t=Ys(t);let{class:e,style:n}=t;e&&!y(e)&&(t.class=J(e)),C(n)&&(zt(n)&&!g(n)&&(n=d({},n)),t.style=W(n))}return qs(e,t,n,r,i,y(e)?1:bs(e)?128:ir(e)?64:C(e)?4:A(e)?2:0,o,!0)}function Ys(e){return e?zt(e)||Bo(e)?d({},e):e:null}function Gs(e,t,n=!1,r=!1){const{props:i,ref:o,patchFlag:s,children:a,transition:l}=e,c=t?na(i||{},t):i,h={__v_isVNode:!0,__v_skip:!0,type:e.type,props:c,key:c&&Hs(c),ref:t&&t.ref?n&&o?g(o)?o.concat(js(t)):[o,js(t)]:js(t):o,scopeId:e.scopeId,slotScopeIds:e.slotScopeIds,children:a,target:e.target,targetStart:e.targetStart,targetAnchor:e.targetAnchor,staticCount:e.staticCount,shapeFlag:e.shapeFlag,patchFlag:t&&e.type!==Os?-1===s?16:16|s:s,dynamicProps:e.dynamicProps,dynamicChildren:e.dynamicChildren,appContext:e.appContext,dirs:e.dirs,transition:l,component:e.component,suspense:e.suspense,ssContent:e.ssContent&&Gs(e.ssContent),ssFallback:e.ssFallback&&Gs(e.ssFallback),placeholder:e.placeholder,el:e.el,anchor:e.anchor,ctx:e.ctx,ce:e.ce};return l&&r&&_r(h,l.clone(h)),h}function Xs(e=" ",t=0){return Ws(Bs,null,e,t)}function Js(e,t){const n=Ws(Ts,null,e);return n.staticCount=t,n}function Ks(e="",t=!1){return t?(Ds(),Qs(_s,null,e)):Ws(_s,null,e)}function Zs(e){return null==e||"boolean"==typeof e?Ws(_s):g(e)?Ws(Os,null,e.slice()):Vs(e)?ea(e):Ws(Bs,null,String(e))}function ea(e){return null===e.el&&-1!==e.patchFlag||e.memo?e:Gs(e)}function ta(e,t){let n=0;const{shapeFlag:r}=e;if(null==t)t=null;else if(g(t))n=16;else if("object"==typeof t){if(65&r){const n=t.default;return void(n&&(n._c&&(n._d=!1),ta(e,n()),n._c&&(n._d=!0)))}{n=32;const r=t._;r||Bo(t)?3===r&&Yn&&(1===Yn.slots._?t._=1:(t._=2,e.patchFlag|=1024)):t._ctx=Yn}}else A(t)?(t={default:t,_ctx:Yn},n=32):(t=String(t),64&r?(n=16,t=[Xs(t)]):n=8);e.children=t,e.shapeFlag|=n}function na(...e){const t={};for(let n=0;n<e.length;n++){const r=e[n];for(const e in r)if("class"===e)t.class!==r.class&&(t.class=J([t.class,r.class]));else if("style"===e)t.style=W([t.style,r.style]);else if(c(e)){const n=t[e],i=r[e];!i||n===i||g(n)&&n.includes(i)||(t[e]=n?[].concat(n,i):i)}else""!==e&&(t[e]=r[e])}return t}function ra(e,t,n,r=null){_n(e,t,7,[n,r])}const ia=bo();let oa=0;function sa(e,t,n){const r=e.type,i=(t?t.appContext:e.appContext)||ia,s={uid:oa++,vnode:e,type:r,parent:t,appContext:i,root:null,next:null,subTree:null,effect:null,update:null,job:null,scope:new ye(!0),render:null,proxy:null,exposed:null,exposeProxy:null,withProxy:null,provides:t?t.provides:Object.create(i.provides),ids:t?t.ids:["",0,0],accessCache:null,renderCache:[],components:null,directives:null,propsOptions:Mo(r,i),emitsOptions:hs(r,i),emit:null,emitted:null,propsDefaults:o,inheritAttrs:r.inheritAttrs,ctx:o,data:o,props:o,attrs:o,slots:o,refs:o,setupState:o,setupContext:null,suspense:n,suspenseId:n?n.pendingId:0,asyncDep:null,asyncResolved:!1,isMounted:!1,isUnmounted:!1,isDeactivated:!1,bc:null,c:null,bm:null,m:null,bu:null,u:null,um:null,bum:null,da:null,a:null,rtg:null,rtc:null,ec:null,sp:null};return s.ctx={_:s},s.root=t?t.root:s,s.emit=ls.bind(null,s),e.ce&&e.ce(s),s}let aa=null;const la=()=>aa||Yn;let ca,ha;{const e=j(),t=(t,n)=>{let r;return(r=e[t])||(r=e[t]=[]),r.push(n),e=>{r.length>1?r.forEach(t=>t(e)):r[0](e)}};ca=t("__VUE_INSTANCE_SETTERS__",e=>aa=e),ha=t("__VUE_SSR_SETTERS__",e=>ma=e)}const da=e=>{const t=aa;return ca(e),e.scope.on(),()=>{e.scope.off(),ca(t)}},ua=()=>{aa&&aa.scope.off(),ca(null)};function pa(e){return 4&e.vnode.shapeFlag}let fa,ga,ma=!1;function va(e,t=!1,n=!1){t&&ha(t);const{props:r,children:i}=e.vnode,o=pa(e);!function(e,t,n,r=!1){const i={},o=Oo();e.propsDefaults=Object.create(null),_o(e,t,i,o);for(const t in e.propsOptions[0])t in i||(i[t]=void 0);n?e.props=r?i:Rt(i):e.type.props?e.props=i:e.props=o,e.attrs=o}(e,r,o,t),Qo(e,i,n||t);const s=o?function(e,t){const n=e.type;0;e.accessCache=Object.create(null),e.proxy=new Proxy(e.ctx,$i),!1;const{setup:r}=n;if(r){$e();const n=e.setupContext=r.length>1?xa(e):null,i=da(e),o=Bn(r,e,0,[e.props,n]),s=x(o);if(He(),i(),!s&&!e.sp||ti(e)||Dr(e),s){if(o.then(ua,ua),t)return o.then(n=>{ba(e,n,t)}).catch(t=>{Tn(t,e,0)});e.asyncDep=o}else ba(e,o,t)}else wa(e,t)}(e,t):void 0;return t&&ha(!1),s}function ba(e,t,n){A(t)?e.type.__ssrInlineRender?e.ssrRender=t:e.render=t:C(t)&&(e.setupState=tn(t)),wa(e,n)}function Aa(e){fa=e,ga=e=>{e.render._rc&&(e.withProxy=new Proxy(e.ctx,Hi))}}const ya=()=>!fa;function wa(e,t,n){const r=e.type;if(!e.render){if(!t&&fa&&!r.render){const t=r.template||co(e).template;if(t){0;const{isCustomElement:n,compilerOptions:i}=e.appContext.config,{delimiters:o,compilerOptions:s}=r,a=d(d({isCustomElement:n,delimiters:o},i),s);r.render=fa(t,a)}}e.render=r.render||a,ga&&ga(e)}{const t=da(e);$e();try{so(e)}finally{He(),t()}}}const Ca={get:(e,t)=>(Ze(e,0,""),e[t])};function xa(e){const t=t=>{e.exposed=t||{}};return{attrs:new Proxy(e.attrs,Ca),slots:e.slots,emit:e.emit,expose:t}}function ka(e){return e.exposed?e.exposeProxy||(e.exposeProxy=new Proxy(tn(Ht(e.exposed)),{get:(t,n)=>n in t?t[n]:n in Vi?Vi[n](e):void 0,has:(e,t)=>t in e||t in Vi})):e.proxy}const Sa=/(?:^|[-_])\w/g,Oa=e=>e.replace(Sa,e=>e.toUpperCase()).replace(/[-_]/g,"");function Ba(e,t=!0){return A(e)?e.displayName||e.name:e.name||t&&e.__name}function _a(e,t,n=!1){let r=Ba(t);if(!r&&t.__file){const e=t.__file.match(/([^/\\]+)\.\w+$/);e&&(r=e[1])}if(!r&&e&&e.parent){const n=e=>{for(const n in e)if(e[n]===t)return n};r=n(e.components||e.parent.type.components)||n(e.appContext.components)}return r?Oa(r):n?"App":"Anonymous"}function Ta(e){return A(e)&&"__vccOpts"in e}const Ea=(e,t)=>{const n=function(e,t,n=!1){let r,i;return A(e)?r=e:(r=e.get,i=e.set),new hn(r,i,n)}(e,0,ma);return n};function Ma(e,t,n){try{Ls(-1);const r=arguments.length;return 2===r?C(t)&&!g(t)?Vs(t)?Ws(e,null,[t]):Ws(e,t):Ws(e,null,t):(r>3?n=Array.prototype.slice.call(arguments,2):3===r&&Vs(n)&&(n=[n]),Ws(e,t,n))}finally{Ls(1)}}function Da(){return void 0}function Pa(e,t,n,r){const i=n[r];if(i&&Ra(i,e))return i;const o=t();return o.memo=e.slice(),o.cacheIndex=r,n[r]=o}function Ra(e,t){const n=e.memo;if(n.length!=t.length)return!1;for(let e=0;e<n.length;e++)if(F(n[e],t[e]))return!1;return Is>0&&Ms&&Ms.push(e),!0}const Ia="3.5.22",La=a,Na=On,Fa=qn,Qa=function e(t,n){var r,i;if(qn=t,qn)qn.enabled=!0,Wn.forEach(({event:e,args:t})=>qn.emit(e,...t)),Wn=[];else if("undefined"!=typeof window&&window.HTMLElement&&!(null==(i=null==(r=window.navigator)?void 0:r.userAgent)?void 0:i.includes("jsdom"))){(n.__VUE_DEVTOOLS_HOOK_REPLAY__=n.__VUE_DEVTOOLS_HOOK_REPLAY__||[]).push(t=>{e(t,n)}),setTimeout(()=>{qn||(n.__VUE_DEVTOOLS_HOOK_REPLAY__=null,Un=!0,Wn=[])},3e3)}else Un=!0,Wn=[]},Va={createComponentInstance:sa,setupComponent:va,renderComponentRoot:us,setCurrentRenderingInstance:Xn,isVNode:Vs,normalizeVNode:Zs,getComponentPublicInstance:ka,ensureValidVNode:Ni,pushWarningContext:function(e){An.push(e)},popWarningContext:function(){An.pop()}},za=null,$a=null,Ha=null;let ja;const qa="undefined"!=typeof window&&window.trustedTypes;if(qa)try{ja=qa.createPolicy("vue",{createHTML:e=>e})}catch(CR){}const Wa=ja?e=>ja.createHTML(e):e=>e,Ua="undefined"!=typeof document?document:null,Ya=Ua&&Ua.createElement("template"),Ga={insert:(e,t,n)=>{t.insertBefore(e,n||null)},remove:e=>{const t=e.parentNode;t&&t.removeChild(e)},createElement:(e,t,n,r)=>{const i="svg"===t?Ua.createElementNS("http://www.w3.org/2000/svg",e):"mathml"===t?Ua.createElementNS("http://www.w3.org/1998/Math/MathML",e):n?Ua.createElement(e,{is:n}):Ua.createElement(e);return"select"===e&&r&&null!=r.multiple&&i.setAttribute("multiple",r.multiple),i},createText:e=>Ua.createTextNode(e),createComment:e=>Ua.createComment(e),setText:(e,t)=>{e.nodeValue=t},setElementText:(e,t)=>{e.textContent=t},parentNode:e=>e.parentNode,nextSibling:e=>e.nextSibling,querySelector:e=>Ua.querySelector(e),setScopeId(e,t){e.setAttribute(t,"")},insertStaticContent(e,t,n,r,i,o){const s=n?n.previousSibling:t.lastChild;if(i&&(i===o||i.nextSibling))for(;t.insertBefore(i.cloneNode(!0),n),i!==o&&(i=i.nextSibling););else{Ya.innerHTML=Wa("svg"===r?`<svg>${e}</svg>`:"mathml"===r?`<math>${e}</math>`:e);const i=Ya.content;if("svg"===r||"mathml"===r){const e=i.firstChild;for(;e.firstChild;)i.appendChild(e.firstChild);i.removeChild(e)}t.insertBefore(i,n)}return[s?s.nextSibling:t.firstChild,n?n.previousSibling:t.lastChild]}},Xa="transition",Ja="animation",Ka=Symbol("_vtc"),Za={name:String,type:String,css:{type:Boolean,default:!0},duration:[String,Number,Object],enterFromClass:String,enterActiveClass:String,enterToClass:String,appearFromClass:String,appearActiveClass:String,appearToClass:String,leaveFromClass:String,leaveActiveClass:String,leaveToClass:String},el=d({},Ar,Za),tl=e=>(e.displayName="Transition",e.props=el,e),nl=tl((e,{slots:t})=>Ma(xr,ol(e),t)),rl=(e,t=[])=>{g(e)?e.forEach(e=>e(...t)):e&&e(...t)},il=e=>!!e&&(g(e)?e.some(e=>e.length>1):e.length>1);function ol(e){const t={};for(const n in e)n in Za||(t[n]=e[n]);if(!1===e.css)return t;const{name:n="v",type:r,duration:i,enterFromClass:o=`${n}-enter-from`,enterActiveClass:s=`${n}-enter-active`,enterToClass:a=`${n}-enter-to`,appearFromClass:l=o,appearActiveClass:c=s,appearToClass:h=a,leaveFromClass:u=`${n}-leave-from`,leaveActiveClass:p=`${n}-leave-active`,leaveToClass:f=`${n}-leave-to`}=e,g=function(e){if(null==e)return null;if(C(e))return[sl(e.enter),sl(e.leave)];{const t=sl(e);return[t,t]}}(i),m=g&&g[0],v=g&&g[1],{onBeforeEnter:b,onEnter:A,onEnterCancelled:y,onLeave:w,onLeaveCancelled:x,onBeforeAppear:k=b,onAppear:S=A,onAppearCancelled:O=y}=t,B=(e,t,n,r)=>{e._enterCancelled=r,ll(e,t?h:a),ll(e,t?c:s),n&&n()},_=(e,t)=>{e._isLeaving=!1,ll(e,u),ll(e,f),ll(e,p),t&&t()},T=e=>(t,n)=>{const i=e?S:A,s=()=>B(t,e,n);rl(i,[t,s]),cl(()=>{ll(t,e?l:o),al(t,e?h:a),il(i)||dl(t,r,m,s)})};return d(t,{onBeforeEnter(e){rl(b,[e]),al(e,o),al(e,s)},onBeforeAppear(e){rl(k,[e]),al(e,l),al(e,c)},onEnter:T(!1),onAppear:T(!0),onLeave(e,t){e._isLeaving=!0;const n=()=>_(e,t);al(e,u),e._enterCancelled?(al(e,p),gl(e)):(gl(e),al(e,p)),cl(()=>{e._isLeaving&&(ll(e,u),al(e,f),il(w)||dl(e,r,v,n))}),rl(w,[e,n])},onEnterCancelled(e){B(e,!1,void 0,!0),rl(y,[e])},onAppearCancelled(e){B(e,!0,void 0,!0),rl(O,[e])},onLeaveCancelled(e){_(e),rl(x,[e])}})}function sl(e){return $(e)}function al(e,t){t.split(/\s+/).forEach(t=>t&&e.classList.add(t)),(e[Ka]||(e[Ka]=new Set)).add(t)}function ll(e,t){t.split(/\s+/).forEach(t=>t&&e.classList.remove(t));const n=e[Ka];n&&(n.delete(t),n.size||(e[Ka]=void 0))}function cl(e){requestAnimationFrame(()=>{requestAnimationFrame(e)})}let hl=0;function dl(e,t,n,r){const i=e._endId=++hl,o=()=>{i===e._endId&&r()};if(null!=n)return setTimeout(o,n);const{type:s,timeout:a,propCount:l}=ul(e,t);if(!s)return r();const c=s+"end";let h=0;const d=()=>{e.removeEventListener(c,u),o()},u=t=>{t.target===e&&++h>=l&&d()};setTimeout(()=>{h<l&&d()},a+1),e.addEventListener(c,u)}function ul(e,t){const n=window.getComputedStyle(e),r=e=>(n[e]||"").split(", "),i=r(`${Xa}Delay`),o=r(`${Xa}Duration`),s=pl(i,o),a=r(`${Ja}Delay`),l=r(`${Ja}Duration`),c=pl(a,l);let h=null,d=0,u=0;t===Xa?s>0&&(h=Xa,d=s,u=o.length):t===Ja?c>0&&(h=Ja,d=c,u=l.length):(d=Math.max(s,c),h=d>0?s>c?Xa:Ja:null,u=h?h===Xa?o.length:l.length:0);return{type:h,timeout:d,propCount:u,hasTransform:h===Xa&&/\b(?:transform|all)(?:,|$)/.test(r(`${Xa}Property`).toString())}}function pl(e,t){for(;e.length<t.length;)e=e.concat(e);return Math.max(...t.map((t,n)=>fl(t)+fl(e[n])))}function fl(e){return"auto"===e?0:1e3*Number(e.slice(0,-1).replace(",","."))}function gl(e){return(e?e.ownerDocument:document).body.offsetHeight}const ml=Symbol("_vod"),vl=Symbol("_vsh"),bl={name:"show",beforeMount(e,{value:t},{transition:n}){e[ml]="none"===e.style.display?"":e.style.display,n&&t?n.beforeEnter(e):Al(e,t)},mounted(e,{value:t},{transition:n}){n&&t&&n.enter(e)},updated(e,{value:t,oldValue:n},{transition:r}){!t!=!n&&(r?t?(r.beforeEnter(e),Al(e,!0),r.enter(e)):r.leave(e,()=>{Al(e,!1)}):Al(e,t))},beforeUnmount(e,{value:t}){Al(e,t)}};function Al(e,t){e.style.display=t?e[ml]:"none",e[vl]=!t}const yl=Symbol("");function wl(e){const t=la();if(!t)return;const n=t.ut=(n=e(t.proxy))=>{Array.from(document.querySelectorAll(`[data-v-owner="${t.uid}"]`)).forEach(e=>xl(e,n))};const r=()=>{const r=e(t.proxy);t.ce?xl(t.ce,r):Cl(t.subTree,r),n(r)};bi(()=>{Vn(r)}),vi(()=>{ns(r,a,{flush:"post"});const e=new MutationObserver(r);e.observe(t.subTree.el.parentNode,{childList:!0}),wi(()=>e.disconnect())})}function Cl(e,t){if(128&e.shapeFlag){const n=e.suspense;e=n.activeBranch,n.pendingBranch&&!n.isHydrating&&n.effects.push(()=>{Cl(n.activeBranch,t)})}for(;e.component;)e=e.component.subTree;if(1&e.shapeFlag&&e.el)xl(e.el,t);else if(e.type===Os)e.children.forEach(e=>Cl(e,t));else if(e.type===Ts){let{el:n,anchor:r}=e;for(;n&&(xl(n,t),n!==r);)n=n.nextSibling}}function xl(e,t){if(1===e.nodeType){const n=e.style;let r="";for(const e in t){const i=ve(t[e]);n.setProperty(`--${e}`,i),r+=`--${e}: ${i};`}n[yl]=r}}const kl=/(?:^|;)\s*display\s*:/;const Sl=/\s*!important$/;function Ol(e,t,n){if(g(n))n.forEach(n=>Ol(e,t,n));else if(null==n&&(n=""),t.startsWith("--"))e.setProperty(t,n);else{const r=function(e,t){const n=_l[t];if(n)return n;let r=P(t);if("filter"!==r&&r in e)return _l[t]=r;r=L(r);for(let n=0;n<Bl.length;n++){const i=Bl[n]+r;if(i in e)return _l[t]=i}return t}(e,t);Sl.test(n)?e.setProperty(I(r),n.replace(Sl,""),"important"):e[r]=n}}const Bl=["Webkit","Moz","ms"],_l={};const Tl="http://www.w3.org/1999/xlink";function El(e,t,n,r,i,o=ie(t)){r&&t.startsWith("xlink:")?null==n?e.removeAttributeNS(Tl,t.slice(6,t.length)):e.setAttributeNS(Tl,t,n):null==n||o&&!se(n)?e.removeAttribute(t):e.setAttribute(t,o?"":w(n)?String(n):n)}function Ml(e,t,n,r,i){if("innerHTML"===t||"textContent"===t)return void(null!=n&&(e[t]="innerHTML"===t?Wa(n):n));const o=e.tagName;if("value"===t&&"PROGRESS"!==o&&!o.includes("-")){const r="OPTION"===o?e.getAttribute("value")||"":e.value,i=null==n?"checkbox"===e.type?"on":"":String(n);return r===i&&"_value"in e||(e.value=i),null==n&&e.removeAttribute(t),void(e._value=n)}let s=!1;if(""===n||null==n){const r=typeof e[t];"boolean"===r?n=se(n):null==n&&"string"===r?(n="",s=!0):"number"===r&&(n=0,s=!0)}try{e[t]=n}catch(e){0}s&&e.removeAttribute(i||t)}function Dl(e,t,n,r){e.addEventListener(t,n,r)}const Pl=Symbol("_vei");function Rl(e,t,n,r,i=null){const o=e[Pl]||(e[Pl]={}),s=o[t];if(r&&s)s.value=r;else{const[n,a]=function(e){let t;if(Il.test(e)){let n;for(t={};n=e.match(Il);)e=e.slice(0,e.length-n[0].length),t[n[0].toLowerCase()]=!0}const n=":"===e[2]?e.slice(3):I(e.slice(2));return[n,t]}(t);if(r){const s=o[t]=function(e,t){const n=e=>{if(e._vts){if(e._vts<=n.attached)return}else e._vts=Date.now();_n(function(e,t){if(g(t)){const n=e.stopImmediatePropagation;return e.stopImmediatePropagation=()=>{n.call(e),e._stopped=!0},t.map(e=>t=>!t._stopped&&e&&e(t))}return t}(e,n.value),t,5,[e])};return n.value=e,n.attached=Fl(),n}(r,i);Dl(e,n,s,a)}else s&&(!function(e,t,n,r){e.removeEventListener(t,n,r)}(e,n,s,a),o[t]=void 0)}}const Il=/(?:Once|Passive|Capture)$/;let Ll=0;const Nl=Promise.resolve(),Fl=()=>Ll||(Nl.then(()=>Ll=0),Ll=Date.now());const Ql=e=>111===e.charCodeAt(0)&&110===e.charCodeAt(1)&&e.charCodeAt(2)>96&&e.charCodeAt(2)<123;const Vl={};function zl(e,t,n){let r=Er(e,t);B(r)&&(r=d({},r,t));class i extends jl{constructor(e){super(r,e,n)}}return i.def=r,i}const $l=(e,t)=>zl(e,t,Dc),Hl="undefined"!=typeof HTMLElement?HTMLElement:class{};class jl extends Hl{constructor(e,t={},n=Mc){super(),this._def=e,this._props=t,this._createApp=n,this._isVueCE=!0,this._instance=null,this._app=null,this._nonce=this._def.nonce,this._connected=!1,this._resolved=!1,this._numberProps=null,this._styleChildren=new WeakSet,this._ob=null,this.shadowRoot&&n!==Mc?this._root=this.shadowRoot:!1!==e.shadowRoot?(this.attachShadow(d({},e.shadowRootOptions,{mode:"open"})),this._root=this.shadowRoot):this._root=this}connectedCallback(){if(!this.isConnected)return;this.shadowRoot||this._resolved||this._parseSlots(),this._connected=!0;let e=this;for(;e=e&&(e.parentNode||e.host);)if(e instanceof jl){this._parent=e;break}this._instance||(this._resolved?this._mount(this._def):e&&e._pendingResolve?this._pendingResolve=e._pendingResolve.then(()=>{this._pendingResolve=void 0,this._resolveDef()}):this._resolveDef())}_setParent(e=this._parent){e&&(this._instance.parent=e._instance,this._inheritParentContext(e))}_inheritParentContext(e=this._parent){e&&this._app&&Object.setPrototypeOf(this._app._context.provides,e._instance.provides)}disconnectedCallback(){this._connected=!1,Nn(()=>{this._connected||(this._ob&&(this._ob.disconnect(),this._ob=null),this._app&&this._app.unmount(),this._instance&&(this._instance.ce=void 0),this._app=this._instance=null,this._teleportTargets&&(this._teleportTargets.clear(),this._teleportTargets=void 0))})}_processMutations(e){for(const t of e)this._setAttr(t.attributeName)}_resolveDef(){if(this._pendingResolve)return;for(let e=0;e<this.attributes.length;e++)this._setAttr(this.attributes[e].name);this._ob=new MutationObserver(this._processMutations.bind(this)),this._ob.observe(this,{attributes:!0});const e=(e,t=!1)=>{this._resolved=!0,this._pendingResolve=void 0;const{props:n,styles:r}=e;let i;if(n&&!g(n))for(const e in n){const t=n[e];(t===Number||t&&t.type===Number)&&(e in this._props&&(this._props[e]=$(this._props[e])),(i||(i=Object.create(null)))[P(e)]=!0)}this._numberProps=i,this._resolveProps(e),this.shadowRoot&&this._applyStyles(r),this._mount(e)},t=this._def.__asyncLoader;t?this._pendingResolve=t().then(t=>{t.configureApp=this._def.configureApp,e(this._def=t,!0)}):e(this._def)}_mount(e){this._app=this._createApp(e),this._inheritParentContext(),e.configureApp&&e.configureApp(this._app),this._app._ceVNode=this._createVNode(),this._app.mount(this._root);const t=this._instance&&this._instance.exposed;if(t)for(const e in t)f(this,e)||Object.defineProperty(this,e,{get:()=>Kt(t[e])})}_resolveProps(e){const{props:t}=e,n=g(t)?t:Object.keys(t||{});for(const e of Object.keys(this))"_"!==e[0]&&n.includes(e)&&this._setProp(e,this[e]);for(const e of n.map(P))Object.defineProperty(this,e,{get(){return this._getProp(e)},set(t){this._setProp(e,t,!0,!0)}})}_setAttr(e){if(e.startsWith("data-v-"))return;const t=this.hasAttribute(e);let n=t?this.getAttribute(e):Vl;const r=P(e);t&&this._numberProps&&this._numberProps[r]&&(n=$(n)),this._setProp(r,n,!1,!0)}_getProp(e){return this._props[e]}_setProp(e,t,n=!0,r=!1){if(t!==this._props[e]&&(t===Vl?delete this._props[e]:(this._props[e]=t,"key"===e&&this._app&&(this._app._ceVNode.key=t)),r&&this._instance&&this._update(),n)){const n=this._ob;n&&(this._processMutations(n.takeRecords()),n.disconnect()),!0===t?this.setAttribute(I(e),""):"string"==typeof t||"number"==typeof t?this.setAttribute(I(e),t+""):t||this.removeAttribute(I(e)),n&&n.observe(this,{attributes:!0})}}_update(){const e=this._createVNode();this._app&&(e.appContext=this._app._context),Tc(e,this._root)}_createVNode(){const e={};this.shadowRoot||(e.onVnodeMounted=e.onVnodeUpdated=this._renderSlots.bind(this));const t=Ws(this._def,d(e,this._props));return this._instance||(t.ce=e=>{this._instance=e,e.ce=this,e.isCE=!0;const t=(e,t)=>{this.dispatchEvent(new CustomEvent(e,B(t[0])?d({detail:t},t[0]):{detail:t}))};e.emit=(e,...n)=>{t(e,n),I(e)!==e&&t(I(e),n)},this._setParent()}),t}_applyStyles(e,t){if(!e)return;if(t){if(t===this._def||this._styleChildren.has(t))return;this._styleChildren.add(t)}const n=this._nonce;for(let t=e.length-1;t>=0;t--){const r=document.createElement("style");n&&r.setAttribute("nonce",n),r.textContent=e[t],this.shadowRoot.prepend(r)}}_parseSlots(){const e=this._slots={};let t;for(;t=this.firstChild;){const n=1===t.nodeType&&t.getAttribute("slot")||"default";(e[n]||(e[n]=[])).push(t),this.removeChild(t)}}_renderSlots(){const e=this._getSlots(),t=this._instance.type.__scopeId;for(let n=0;n<e.length;n++){const r=e[n],i=r.getAttribute("name")||"default",o=this._slots[i],s=r.parentNode;if(o)for(const e of o){if(t&&1===e.nodeType){const n=t+"-s",r=document.createTreeWalker(e,1);let i;for(e.setAttribute(n,"");i=r.nextNode();)i.setAttribute(n,"")}s.insertBefore(e,r)}else for(;r.firstChild;)s.insertBefore(r.firstChild,r);s.removeChild(r)}}_getSlots(){const e=[this];return this._teleportTargets&&e.push(...this._teleportTargets),e.reduce((e,t)=>(e.push(...Array.from(t.querySelectorAll("slot"))),e),[])}_injectChildStyle(e){this._applyStyles(e.styles,e)}_removeChildStyle(e){0}}function ql(e){const t=la(),n=t&&t.ce;return n||null}function Wl(){const e=ql();return e&&e.shadowRoot}function Ul(e="$style"){{const t=la();if(!t)return o;const n=t.type.__cssModules;if(!n)return o;const r=n[e];return r||o}}const Yl=new WeakMap,Gl=new WeakMap,Xl=Symbol("_moveCb"),Jl=Symbol("_enterCb"),Kl=e=>(delete e.props.mode,e),Zl=Kl({name:"TransitionGroup",props:d({},el,{tag:String,moveClass:String}),setup(e,{slots:t}){const n=la(),r=vr();let i,o;return Ai(()=>{if(!i.length)return;const t=e.moveClass||`${e.name||"v"}-move`;if(!function(e,t,n){const r=e.cloneNode(),i=e[Ka];i&&i.forEach(e=>{e.split(/\s+/).forEach(e=>e&&r.classList.remove(e))});n.split(/\s+/).forEach(e=>e&&r.classList.add(e)),r.style.display="none";const o=1===t.nodeType?t:t.parentNode;o.appendChild(r);const{hasTransform:s}=ul(r);return o.removeChild(r),s}(i[0].el,n.vnode.el,t))return void(i=[]);i.forEach(tc),i.forEach(nc);const r=i.filter(rc);gl(n.vnode.el),r.forEach(e=>{const n=e.el,r=n.style;al(n,t),r.transform=r.webkitTransform=r.transitionDuration="";const i=n[Xl]=e=>{e&&e.target!==n||e&&!e.propertyName.endsWith("transform")||(n.removeEventListener("transitionend",i),n[Xl]=null,ll(n,t))};n.addEventListener("transitionend",i)}),i=[]}),()=>{const s=$t(e),a=ol(s);let l=s.tag||Os;if(i=[],o)for(let e=0;e<o.length;e++){const t=o[e];t.el&&t.el instanceof Element&&(i.push(t),_r(t,Sr(t,a,r,n)),Yl.set(t,t.el.getBoundingClientRect()))}o=t.default?Tr(t.default()):[];for(let e=0;e<o.length;e++){const t=o[e];null!=t.key&&_r(t,Sr(t,a,r,n))}return Ws(l,null,o)}}}),ec=Zl;function tc(e){const t=e.el;t[Xl]&&t[Xl](),t[Jl]&&t[Jl]()}function nc(e){Gl.set(e,e.el.getBoundingClientRect())}function rc(e){const t=Yl.get(e),n=Gl.get(e),r=t.left-n.left,i=t.top-n.top;if(r||i){const t=e.el.style;return t.transform=t.webkitTransform=`translate(${r}px,${i}px)`,t.transitionDuration="0s",e}}const ic=e=>{const t=e.props["onUpdate:modelValue"]||!1;return g(t)?e=>Q(t,e):t};function oc(e){e.target.composing=!0}function sc(e){const t=e.target;t.composing&&(t.composing=!1,t.dispatchEvent(new Event("input")))}const ac=Symbol("_assign"),lc={created(e,{modifiers:{lazy:t,trim:n,number:r}},i){e[ac]=ic(i);const o=r||i.props&&"number"===i.props.type;Dl(e,t?"change":"input",t=>{if(t.target.composing)return;let r=e.value;n&&(r=r.trim()),o&&(r=z(r)),e[ac](r)}),n&&Dl(e,"change",()=>{e.value=e.value.trim()}),t||(Dl(e,"compositionstart",oc),Dl(e,"compositionend",sc),Dl(e,"change",sc))},mounted(e,{value:t}){e.value=null==t?"":t},beforeUpdate(e,{value:t,oldValue:n,modifiers:{lazy:r,trim:i,number:o}},s){if(e[ac]=ic(s),e.composing)return;const a=null==t?"":t;if((!o&&"number"!==e.type||/^0\d/.test(e.value)?e.value:z(e.value))!==a){if(document.activeElement===e&&"range"!==e.type){if(r&&t===n)return;if(i&&e.value.trim()===a)return}e.value=a}}},cc={deep:!0,created(e,t,n){e[ac]=ic(n),Dl(e,"change",()=>{const t=e._modelValue,n=fc(e),r=e.checked,i=e[ac];if(g(t)){const e=ue(t,n),o=-1!==e;if(r&&!o)i(t.concat(n));else if(!r&&o){const n=[...t];n.splice(e,1),i(n)}}else if(v(t)){const e=new Set(t);r?e.add(n):e.delete(n),i(e)}else i(gc(e,r))})},mounted:hc,beforeUpdate(e,t,n){e[ac]=ic(n),hc(e,t,n)}};function hc(e,{value:t,oldValue:n},r){let i;if(e._modelValue=t,g(t))i=ue(t,r.props.value)>-1;else if(v(t))i=t.has(r.props.value);else{if(t===n)return;i=de(t,gc(e,!0))}e.checked!==i&&(e.checked=i)}const dc={created(e,{value:t},n){e.checked=de(t,n.props.value),e[ac]=ic(n),Dl(e,"change",()=>{e[ac](fc(e))})},beforeUpdate(e,{value:t,oldValue:n},r){e[ac]=ic(r),t!==n&&(e.checked=de(t,r.props.value))}},uc={deep:!0,created(e,{value:t,modifiers:{number:n}},r){const i=v(t);Dl(e,"change",()=>{const t=Array.prototype.filter.call(e.options,e=>e.selected).map(e=>n?z(fc(e)):fc(e));e[ac](e.multiple?i?new Set(t):t:t[0]),e._assigning=!0,Nn(()=>{e._assigning=!1})}),e[ac]=ic(r)},mounted(e,{value:t}){pc(e,t)},beforeUpdate(e,t,n){e[ac]=ic(n)},updated(e,{value:t}){e._assigning||pc(e,t)}};function pc(e,t){const n=e.multiple,r=g(t);if(!n||r||v(t)){for(let i=0,o=e.options.length;i<o;i++){const o=e.options[i],s=fc(o);if(n)if(r){const e=typeof s;o.selected="string"===e||"number"===e?t.some(e=>String(e)===String(s)):ue(t,s)>-1}else o.selected=t.has(s);else if(de(fc(o),t))return void(e.selectedIndex!==i&&(e.selectedIndex=i))}n||-1===e.selectedIndex||(e.selectedIndex=-1)}}function fc(e){return"_value"in e?e._value:e.value}function gc(e,t){const n=t?"_trueValue":"_falseValue";return n in e?e[n]:t}const mc={created(e,t,n){bc(e,t,n,null,"created")},mounted(e,t,n){bc(e,t,n,null,"mounted")},beforeUpdate(e,t,n,r){bc(e,t,n,r,"beforeUpdate")},updated(e,t,n,r){bc(e,t,n,r,"updated")}};function vc(e,t){switch(e){case"SELECT":return uc;case"TEXTAREA":return lc;default:switch(t){case"checkbox":return cc;case"radio":return dc;default:return lc}}}function bc(e,t,n,r,i){const o=vc(e.tagName,n.props&&n.props.type)[i];o&&o(e,t,n,r)}const Ac=["ctrl","shift","alt","meta"],yc={stop:e=>e.stopPropagation(),prevent:e=>e.preventDefault(),self:e=>e.target!==e.currentTarget,ctrl:e=>!e.ctrlKey,shift:e=>!e.shiftKey,alt:e=>!e.altKey,meta:e=>!e.metaKey,left:e=>"button"in e&&0!==e.button,middle:e=>"button"in e&&1!==e.button,right:e=>"button"in e&&2!==e.button,exact:(e,t)=>Ac.some(n=>e[`${n}Key`]&&!t.includes(n))},wc=(e,t)=>{const n=e._withMods||(e._withMods={}),r=t.join(".");return n[r]||(n[r]=(n,...r)=>{for(let e=0;e<t.length;e++){const r=yc[t[e]];if(r&&r(n,t))return}return e(n,...r)})},Cc={esc:"escape",space:" ",up:"arrow-up",left:"arrow-left",right:"arrow-right",down:"arrow-down",delete:"backspace"},xc=(e,t)=>{const n=e._withKeys||(e._withKeys={}),r=t.join(".");return n[r]||(n[r]=n=>{if(!("key"in n))return;const r=I(n.key);return t.some(e=>e===r||Cc[e]===r)?e(n):void 0})},kc=d({patchProp:(e,t,n,r,i,o)=>{const s="svg"===i;"class"===t?function(e,t,n){const r=e[Ka];r&&(t=(t?[t,...r]:[...r]).join(" ")),null==t?e.removeAttribute("class"):n?e.setAttribute("class",t):e.className=t}(e,r,s):"style"===t?function(e,t,n){const r=e.style,i=y(n);let o=!1;if(n&&!i){if(t)if(y(t))for(const e of t.split(";")){const t=e.slice(0,e.indexOf(":")).trim();null==n[t]&&Ol(r,t,"")}else for(const e in t)null==n[e]&&Ol(r,e,"");for(const e in n)"display"===e&&(o=!0),Ol(r,e,n[e])}else if(i){if(t!==n){const e=r[yl];e&&(n+=";"+e),r.cssText=n,o=kl.test(n)}}else t&&e.removeAttribute("style");ml in e&&(e[ml]=o?r.display:"",e[vl]&&(r.display="none"))}(e,n,r):c(t)?h(t)||Rl(e,t,0,r,o):("."===t[0]?(t=t.slice(1),1):"^"===t[0]?(t=t.slice(1),0):function(e,t,n,r){if(r)return"innerHTML"===t||"textContent"===t||!!(t in e&&Ql(t)&&A(n));if("spellcheck"===t||"draggable"===t||"translate"===t||"autocorrect"===t)return!1;if("form"===t)return!1;if("list"===t&&"INPUT"===e.tagName)return!1;if("type"===t&&"TEXTAREA"===e.tagName)return!1;if("width"===t||"height"===t){const t=e.tagName;if("IMG"===t||"VIDEO"===t||"CANVAS"===t||"SOURCE"===t)return!1}if(Ql(t)&&y(n))return!1;return t in e}(e,t,r,s))?(Ml(e,t,r),e.tagName.includes("-")||"value"!==t&&"checked"!==t&&"selected"!==t||El(e,t,r,s,0,"value"!==t)):!e._isVueCE||!/[A-Z]/.test(t)&&y(r)?("true-value"===t?e._trueValue=r:"false-value"===t&&(e._falseValue=r),El(e,t,r,s)):Ml(e,P(t),r,0,t)}},Ga);let Sc,Oc=!1;function Bc(){return Sc||(Sc=$o(kc))}function _c(){return Sc=Oc?Sc:Ho(kc),Oc=!0,Sc}const Tc=(...e)=>{Bc().render(...e)},Ec=(...e)=>{_c().hydrate(...e)},Mc=(...e)=>{const t=Bc().createApp(...e);const{mount:n}=t;return t.mount=e=>{const r=Rc(e);if(!r)return;const i=t._component;A(i)||i.render||i.template||(i.template=r.innerHTML),1===r.nodeType&&(r.textContent="");const o=n(r,!1,Pc(r));return r instanceof Element&&(r.removeAttribute("v-cloak"),r.setAttribute("data-v-app","")),o},t},Dc=(...e)=>{const t=_c().createApp(...e);const{mount:n}=t;return t.mount=e=>{const t=Rc(e);if(t)return n(t,!0,Pc(t))},t};function Pc(e){return e instanceof SVGElement?"svg":"function"==typeof MathMLElement&&e instanceof MathMLElement?"mathml":void 0}function Rc(e){if(y(e)){return document.querySelector(e)}return e}let Ic=!1;const Lc=()=>{Ic||(Ic=!0,lc.getSSRProps=({value:e})=>({value:e}),dc.getSSRProps=({value:e},t)=>{if(t.props&&de(t.props.value,e))return{checked:!0}},cc.getSSRProps=({value:e},t)=>{if(g(e)){if(t.props&&ue(e,t.props.value)>-1)return{checked:!0}}else if(v(e)){if(t.props&&e.has(t.props.value))return{checked:!0}}else if(e)return{checked:!0}},mc.getSSRProps=(e,t)=>{if("string"!=typeof t.type)return;const n=vc(t.type.toUpperCase(),t.props&&t.props.type);return n.getSSRProps?n.getSSRProps(e,t):void 0},bl.getSSRProps=({value:e})=>{if(!e)return{style:{display:"none"}}})},Nc=Symbol(""),Fc=Symbol(""),Qc=Symbol(""),Vc=Symbol(""),zc=Symbol(""),$c=Symbol(""),Hc=Symbol(""),jc=Symbol(""),qc=Symbol(""),Wc=Symbol(""),Uc=Symbol(""),Yc=Symbol(""),Gc=Symbol(""),Xc=Symbol(""),Jc=Symbol(""),Kc=Symbol(""),Zc=Symbol(""),eh=Symbol(""),th=Symbol(""),nh=Symbol(""),rh=Symbol(""),ih=Symbol(""),oh=Symbol(""),sh=Symbol(""),ah=Symbol(""),lh=Symbol(""),ch=Symbol(""),hh=Symbol(""),dh=Symbol(""),uh=Symbol(""),ph=Symbol(""),fh=Symbol(""),gh=Symbol(""),mh=Symbol(""),vh=Symbol(""),bh=Symbol(""),Ah=Symbol(""),yh=Symbol(""),wh=Symbol(""),Ch={[Nc]:"Fragment",[Fc]:"Teleport",[Qc]:"Suspense",[Vc]:"KeepAlive",[zc]:"BaseTransition",[$c]:"openBlock",[Hc]:"createBlock",[jc]:"createElementBlock",[qc]:"createVNode",[Wc]:"createElementVNode",[Uc]:"createCommentVNode",[Yc]:"createTextVNode",[Gc]:"createStaticVNode",[Xc]:"resolveComponent",[Jc]:"resolveDynamicComponent",[Kc]:"resolveDirective",[Zc]:"resolveFilter",[eh]:"withDirectives",[th]:"renderList",[nh]:"renderSlot",[rh]:"createSlots",[ih]:"toDisplayString",[oh]:"mergeProps",[sh]:"normalizeClass",[ah]:"normalizeStyle",[lh]:"normalizeProps",[ch]:"guardReactiveProps",[hh]:"toHandlers",[dh]:"camelize",[uh]:"capitalize",[ph]:"toHandlerKey",[fh]:"setBlockTracking",[gh]:"pushScopeId",[mh]:"popScopeId",[vh]:"withCtx",[bh]:"unref",[Ah]:"isRef",[yh]:"withMemo",[wh]:"isMemoSame"};const xh={start:{line:1,column:1,offset:0},end:{line:1,column:1,offset:0},source:""};function kh(e,t,n,r,i,o,s,a=!1,l=!1,c=!1,h=xh){return e&&(a?(e.helper($c),e.helper(Rh(e.inSSR,c))):e.helper(Ph(e.inSSR,c)),s&&e.helper(eh)),{type:13,tag:t,props:n,children:r,patchFlag:i,dynamicProps:o,directives:s,isBlock:a,disableTracking:l,isComponent:c,loc:h}}function Sh(e,t=xh){return{type:17,loc:t,elements:e}}function Oh(e,t=xh){return{type:15,loc:t,properties:e}}function Bh(e,t){return{type:16,loc:xh,key:y(e)?_h(e,!0):e,value:t}}function _h(e,t=!1,n=xh,r=0){return{type:4,loc:n,content:e,isStatic:t,constType:t?3:r}}function Th(e,t=xh){return{type:8,loc:t,children:e}}function Eh(e,t=[],n=xh){return{type:14,loc:n,callee:e,arguments:t}}function Mh(e,t=void 0,n=!1,r=!1,i=xh){return{type:18,params:e,returns:t,newline:n,isSlot:r,loc:i}}function Dh(e,t,n,r=!0){return{type:19,test:e,consequent:t,alternate:n,newline:r,loc:xh}}function Ph(e,t){return e||t?qc:Wc}function Rh(e,t){return e||t?Hc:jc}function Ih(e,{helper:t,removeHelper:n,inSSR:r}){e.isBlock||(e.isBlock=!0,n(Ph(r,e.isComponent)),t($c),t(Rh(r,e.isComponent)))}const Lh=new Uint8Array([123,123]),Nh=new Uint8Array([125,125]);function Fh(e){return e>=97&&e<=122||e>=65&&e<=90}function Qh(e){return 32===e||10===e||9===e||12===e||13===e}function Vh(e){return 47===e||62===e||Qh(e)}function zh(e){const t=new Uint8Array(e.length);for(let n=0;n<e.length;n++)t[n]=e.charCodeAt(n);return t}const $h={Cdata:new Uint8Array([67,68,65,84,65,91]),CdataEnd:new Uint8Array([93,93,62]),CommentEnd:new Uint8Array([45,45,62]),ScriptEnd:new Uint8Array([60,47,115,99,114,105,112,116]),StyleEnd:new Uint8Array([60,47,115,116,121,108,101]),TitleEnd:new Uint8Array([60,47,116,105,116,108,101]),TextareaEnd:new Uint8Array([60,47,116,101,120,116,97,114,101,97])};function Hh(e,{compatConfig:t}){const n=t&&t[e];return"MODE"===e?n||3:n}function jh(e,t){const n=Hh("MODE",t),r=Hh(e,t);return 3===n?!0===r:!1!==r}function qh(e,t,n,...r){return jh(e,t)}function Wh(e){throw e}function Uh(e){}function Yh(e,t,n,r){const i=new SyntaxError(String(`https://vuejs.org/error-reference/#compiler-${e}`));return i.code=e,i.loc=t,i}const Gh=e=>4===e.type&&e.isStatic;function Xh(e){switch(e){case"Teleport":case"teleport":return Fc;case"Suspense":case"suspense":return Qc;case"KeepAlive":case"keep-alive":return Vc;case"BaseTransition":case"base-transition":return zc}}const Jh=/^$|^\d|[^\$\w\xA0-\uFFFF]/,Kh=e=>!Jh.test(e),Zh=/[A-Za-z_$\xA0-\uFFFF]/,ed=/[\.\?\w$\xA0-\uFFFF]/,td=/\s+[.[]\s*|\s*[.[]\s+/g,nd=e=>4===e.type?e.content:e.loc.source,rd=e=>{const t=nd(e).trim().replace(td,e=>e.trim());let n=0,r=[],i=0,o=0,s=null;for(let e=0;e<t.length;e++){const a=t.charAt(e);switch(n){case 0:if("["===a)r.push(n),n=1,i++;else if("("===a)r.push(n),n=2,o++;else if(!(0===e?Zh:ed).test(a))return!1;break;case 1:"'"===a||'"'===a||"`"===a?(r.push(n),n=3,s=a):"["===a?i++:"]"===a&&(--i||(n=r.pop()));break;case 2:if("'"===a||'"'===a||"`"===a)r.push(n),n=3,s=a;else if("("===a)o++;else if(")"===a){if(e===t.length-1)return!1;--o||(n=r.pop())}break;case 3:a===s&&(n=r.pop(),s=null)}}return!i&&!o},id=/^\s*(?:async\s*)?(?:\([^)]*?\)|[\w$_]+)\s*(?::[^=]+)?=>|^\s*(?:async\s+)?function(?:\s+[\w$]+)?\s*\(/,od=e=>id.test(nd(e));function sd(e,t,n=!1){for(let r=0;r<e.props.length;r++){const i=e.props[r];if(7===i.type&&(n||i.exp)&&(y(t)?i.name===t:t.test(i.name)))return i}}function ad(e,t,n=!1,r=!1){for(let i=0;i<e.props.length;i++){const o=e.props[i];if(6===o.type){if(n)continue;if(o.name===t&&(o.value||r))return o}else if("bind"===o.name&&(o.exp||r)&&ld(o.arg,t))return o}}function ld(e,t){return!(!e||!Gh(e)||e.content!==t)}function cd(e){return 5===e.type||2===e.type}function hd(e){return 7===e.type&&"pre"===e.name}function dd(e){return 7===e.type&&"slot"===e.name}function ud(e){return 1===e.type&&3===e.tagType}function pd(e){return 1===e.type&&2===e.tagType}const fd=new Set([lh,ch]);function gd(e,t=[]){if(e&&!y(e)&&14===e.type){const n=e.callee;if(!y(n)&&fd.has(n))return gd(e.arguments[0],t.concat(e))}return[e,t]}function md(e,t,n){let r,i,o=13===e.type?e.props:e.arguments[2],s=[];if(o&&!y(o)&&14===o.type){const e=gd(o);o=e[0],s=e[1],i=s[s.length-1]}if(null==o||y(o))r=Oh([t]);else if(14===o.type){const e=o.arguments[0];y(e)||15!==e.type?o.callee===hh?r=Eh(n.helper(oh),[Oh([t]),o]):o.arguments.unshift(Oh([t])):vd(t,e)||e.properties.unshift(t),!r&&(r=o)}else 15===o.type?(vd(t,o)||o.properties.unshift(t),r=o):(r=Eh(n.helper(oh),[Oh([t]),o]),i&&i.callee===ch&&(i=s[s.length-2]));13===e.type?i?i.arguments[0]=r:e.props=r:i?i.arguments[0]=r:e.arguments[2]=r}function vd(e,t){let n=!1;if(4===e.key.type){const r=e.key.content;n=t.properties.some(e=>4===e.key.type&&e.key.content===r)}return n}function bd(e,t){return`_${t}_${e.replace(/[^\w]/g,(t,n)=>"-"===t?"_":e.charCodeAt(n).toString())}`}const Ad=/([\s\S]*?)\s+(?:in|of)\s+(\S[\s\S]*)/,yd={parseMode:"base",ns:0,delimiters:["{{","}}"],getNamespace:()=>0,isVoidTag:l,isPreTag:l,isIgnoreNewlineTag:l,isCustomElement:l,onError:Wh,onWarn:Uh,comments:!1,prefixIdentifiers:!1};let wd=yd,Cd=null,xd="",kd=null,Sd=null,Od="",Bd=-1,_d=-1,Td=0,Ed=!1,Md=null;const Dd=[],Pd=new class{constructor(e,t){this.stack=e,this.cbs=t,this.state=1,this.buffer="",this.sectionStart=0,this.index=0,this.entityStart=0,this.baseState=1,this.inRCDATA=!1,this.inXML=!1,this.inVPre=!1,this.newlines=[],this.mode=0,this.delimiterOpen=Lh,this.delimiterClose=Nh,this.delimiterIndex=-1,this.currentSequence=void 0,this.sequenceIndex=0}get inSFCRoot(){return 2===this.mode&&0===this.stack.length}reset(){this.state=1,this.mode=0,this.buffer="",this.sectionStart=0,this.index=0,this.baseState=1,this.inRCDATA=!1,this.currentSequence=void 0,this.newlines.length=0,this.delimiterOpen=Lh,this.delimiterClose=Nh}getPos(e){let t=1,n=e+1;for(let r=this.newlines.length-1;r>=0;r--){const i=this.newlines[r];if(e>i){t=r+2,n=e-i;break}}return{column:n,line:t,offset:e}}peek(){return this.buffer.charCodeAt(this.index+1)}stateText(e){60===e?(this.index>this.sectionStart&&this.cbs.ontext(this.sectionStart,this.index),this.state=5,this.sectionStart=this.index):this.inVPre||e!==this.delimiterOpen[0]||(this.state=2,this.delimiterIndex=0,this.stateInterpolationOpen(e))}stateInterpolationOpen(e){if(e===this.delimiterOpen[this.delimiterIndex])if(this.delimiterIndex===this.delimiterOpen.length-1){const e=this.index+1-this.delimiterOpen.length;e>this.sectionStart&&this.cbs.ontext(this.sectionStart,e),this.state=3,this.sectionStart=e}else this.delimiterIndex++;else this.inRCDATA?(this.state=32,this.stateInRCDATA(e)):(this.state=1,this.stateText(e))}stateInterpolation(e){e===this.delimiterClose[0]&&(this.state=4,this.delimiterIndex=0,this.stateInterpolationClose(e))}stateInterpolationClose(e){e===this.delimiterClose[this.delimiterIndex]?this.delimiterIndex===this.delimiterClose.length-1?(this.cbs.oninterpolation(this.sectionStart,this.index+1),this.inRCDATA?this.state=32:this.state=1,this.sectionStart=this.index+1):this.delimiterIndex++:(this.state=3,this.stateInterpolation(e))}stateSpecialStartSequence(e){const t=this.sequenceIndex===this.currentSequence.length;if(t?Vh(e):(32|e)===this.currentSequence[this.sequenceIndex]){if(!t)return void this.sequenceIndex++}else this.inRCDATA=!1;this.sequenceIndex=0,this.state=6,this.stateInTagName(e)}stateInRCDATA(e){if(this.sequenceIndex===this.currentSequence.length){if(62===e||Qh(e)){const t=this.index-this.currentSequence.length;if(this.sectionStart<t){const e=this.index;this.index=t,this.cbs.ontext(this.sectionStart,t),this.index=e}return this.sectionStart=t+2,this.stateInClosingTagName(e),void(this.inRCDATA=!1)}this.sequenceIndex=0}(32|e)===this.currentSequence[this.sequenceIndex]?this.sequenceIndex+=1:0===this.sequenceIndex?this.currentSequence===$h.TitleEnd||this.currentSequence===$h.TextareaEnd&&!this.inSFCRoot?this.inVPre||e!==this.delimiterOpen[0]||(this.state=2,this.delimiterIndex=0,this.stateInterpolationOpen(e)):this.fastForwardTo(60)&&(this.sequenceIndex=1):this.sequenceIndex=Number(60===e)}stateCDATASequence(e){e===$h.Cdata[this.sequenceIndex]?++this.sequenceIndex===$h.Cdata.length&&(this.state=28,this.currentSequence=$h.CdataEnd,this.sequenceIndex=0,this.sectionStart=this.index+1):(this.sequenceIndex=0,this.state=23,this.stateInDeclaration(e))}fastForwardTo(e){for(;++this.index<this.buffer.length;){const t=this.buffer.charCodeAt(this.index);if(10===t&&this.newlines.push(this.index),t===e)return!0}return this.index=this.buffer.length-1,!1}stateInCommentLike(e){e===this.currentSequence[this.sequenceIndex]?++this.sequenceIndex===this.currentSequence.length&&(this.currentSequence===$h.CdataEnd?this.cbs.oncdata(this.sectionStart,this.index-2):this.cbs.oncomment(this.sectionStart,this.index-2),this.sequenceIndex=0,this.sectionStart=this.index+1,this.state=1):0===this.sequenceIndex?this.fastForwardTo(this.currentSequence[0])&&(this.sequenceIndex=1):e!==this.currentSequence[this.sequenceIndex-1]&&(this.sequenceIndex=0)}startSpecial(e,t){this.enterRCDATA(e,t),this.state=31}enterRCDATA(e,t){this.inRCDATA=!0,this.currentSequence=e,this.sequenceIndex=t}stateBeforeTagName(e){33===e?(this.state=22,this.sectionStart=this.index+1):63===e?(this.state=24,this.sectionStart=this.index+1):Fh(e)?(this.sectionStart=this.index,0===this.mode?this.state=6:this.inSFCRoot?this.state=34:this.inXML?this.state=6:this.state=116===e?30:115===e?29:6):47===e?this.state=8:(this.state=1,this.stateText(e))}stateInTagName(e){Vh(e)&&this.handleTagName(e)}stateInSFCRootTagName(e){if(Vh(e)){const t=this.buffer.slice(this.sectionStart,this.index);"template"!==t&&this.enterRCDATA(zh("</"+t),0),this.handleTagName(e)}}handleTagName(e){this.cbs.onopentagname(this.sectionStart,this.index),this.sectionStart=-1,this.state=11,this.stateBeforeAttrName(e)}stateBeforeClosingTagName(e){Qh(e)||(62===e?(this.state=1,this.sectionStart=this.index+1):(this.state=Fh(e)?9:27,this.sectionStart=this.index))}stateInClosingTagName(e){(62===e||Qh(e))&&(this.cbs.onclosetag(this.sectionStart,this.index),this.sectionStart=-1,this.state=10,this.stateAfterClosingTagName(e))}stateAfterClosingTagName(e){62===e&&(this.state=1,this.sectionStart=this.index+1)}stateBeforeAttrName(e){62===e?(this.cbs.onopentagend(this.index),this.inRCDATA?this.state=32:this.state=1,this.sectionStart=this.index+1):47===e?this.state=7:60===e&&47===this.peek()?(this.cbs.onopentagend(this.index),this.state=5,this.sectionStart=this.index):Qh(e)||this.handleAttrStart(e)}handleAttrStart(e){118===e&&45===this.peek()?(this.state=13,this.sectionStart=this.index):46===e||58===e||64===e||35===e?(this.cbs.ondirname(this.index,this.index+1),this.state=14,this.sectionStart=this.index+1):(this.state=12,this.sectionStart=this.index)}stateInSelfClosingTag(e){62===e?(this.cbs.onselfclosingtag(this.index),this.state=1,this.sectionStart=this.index+1,this.inRCDATA=!1):Qh(e)||(this.state=11,this.stateBeforeAttrName(e))}stateInAttrName(e){(61===e||Vh(e))&&(this.cbs.onattribname(this.sectionStart,this.index),this.handleAttrNameEnd(e))}stateInDirName(e){61===e||Vh(e)?(this.cbs.ondirname(this.sectionStart,this.index),this.handleAttrNameEnd(e)):58===e?(this.cbs.ondirname(this.sectionStart,this.index),this.state=14,this.sectionStart=this.index+1):46===e&&(this.cbs.ondirname(this.sectionStart,this.index),this.state=16,this.sectionStart=this.index+1)}stateInDirArg(e){61===e||Vh(e)?(this.cbs.ondirarg(this.sectionStart,this.index),this.handleAttrNameEnd(e)):91===e?this.state=15:46===e&&(this.cbs.ondirarg(this.sectionStart,this.index),this.state=16,this.sectionStart=this.index+1)}stateInDynamicDirArg(e){93===e?this.state=14:(61===e||Vh(e))&&(this.cbs.ondirarg(this.sectionStart,this.index+1),this.handleAttrNameEnd(e))}stateInDirModifier(e){61===e||Vh(e)?(this.cbs.ondirmodifier(this.sectionStart,this.index),this.handleAttrNameEnd(e)):46===e&&(this.cbs.ondirmodifier(this.sectionStart,this.index),this.sectionStart=this.index+1)}handleAttrNameEnd(e){this.sectionStart=this.index,this.state=17,this.cbs.onattribnameend(this.index),this.stateAfterAttrName(e)}stateAfterAttrName(e){61===e?this.state=18:47===e||62===e?(this.cbs.onattribend(0,this.sectionStart),this.sectionStart=-1,this.state=11,this.stateBeforeAttrName(e)):Qh(e)||(this.cbs.onattribend(0,this.sectionStart),this.handleAttrStart(e))}stateBeforeAttrValue(e){34===e?(this.state=19,this.sectionStart=this.index+1):39===e?(this.state=20,this.sectionStart=this.index+1):Qh(e)||(this.sectionStart=this.index,this.state=21,this.stateInAttrValueNoQuotes(e))}handleInAttrValue(e,t){(e===t||this.fastForwardTo(t))&&(this.cbs.onattribdata(this.sectionStart,this.index),this.sectionStart=-1,this.cbs.onattribend(34===t?3:2,this.index+1),this.state=11)}stateInAttrValueDoubleQuotes(e){this.handleInAttrValue(e,34)}stateInAttrValueSingleQuotes(e){this.handleInAttrValue(e,39)}stateInAttrValueNoQuotes(e){Qh(e)||62===e?(this.cbs.onattribdata(this.sectionStart,this.index),this.sectionStart=-1,this.cbs.onattribend(1,this.index),this.state=11,this.stateBeforeAttrName(e)):39!==e&&60!==e&&61!==e&&96!==e||this.cbs.onerr(18,this.index)}stateBeforeDeclaration(e){91===e?(this.state=26,this.sequenceIndex=0):this.state=45===e?25:23}stateInDeclaration(e){(62===e||this.fastForwardTo(62))&&(this.state=1,this.sectionStart=this.index+1)}stateInProcessingInstruction(e){(62===e||this.fastForwardTo(62))&&(this.cbs.onprocessinginstruction(this.sectionStart,this.index),this.state=1,this.sectionStart=this.index+1)}stateBeforeComment(e){45===e?(this.state=28,this.currentSequence=$h.CommentEnd,this.sequenceIndex=2,this.sectionStart=this.index+1):this.state=23}stateInSpecialComment(e){(62===e||this.fastForwardTo(62))&&(this.cbs.oncomment(this.sectionStart,this.index),this.state=1,this.sectionStart=this.index+1)}stateBeforeSpecialS(e){e===$h.ScriptEnd[3]?this.startSpecial($h.ScriptEnd,4):e===$h.StyleEnd[3]?this.startSpecial($h.StyleEnd,4):(this.state=6,this.stateInTagName(e))}stateBeforeSpecialT(e){e===$h.TitleEnd[3]?this.startSpecial($h.TitleEnd,4):e===$h.TextareaEnd[3]?this.startSpecial($h.TextareaEnd,4):(this.state=6,this.stateInTagName(e))}startEntity(){}stateInEntity(){}parse(e){for(this.buffer=e;this.index<this.buffer.length;){const e=this.buffer.charCodeAt(this.index);switch(10===e&&33!==this.state&&this.newlines.push(this.index),this.state){case 1:this.stateText(e);break;case 2:this.stateInterpolationOpen(e);break;case 3:this.stateInterpolation(e);break;case 4:this.stateInterpolationClose(e);break;case 31:this.stateSpecialStartSequence(e);break;case 32:this.stateInRCDATA(e);break;case 26:this.stateCDATASequence(e);break;case 19:this.stateInAttrValueDoubleQuotes(e);break;case 12:this.stateInAttrName(e);break;case 13:this.stateInDirName(e);break;case 14:this.stateInDirArg(e);break;case 15:this.stateInDynamicDirArg(e);break;case 16:this.stateInDirModifier(e);break;case 28:this.stateInCommentLike(e);break;case 27:this.stateInSpecialComment(e);break;case 11:this.stateBeforeAttrName(e);break;case 6:this.stateInTagName(e);break;case 34:this.stateInSFCRootTagName(e);break;case 9:this.stateInClosingTagName(e);break;case 5:this.stateBeforeTagName(e);break;case 17:this.stateAfterAttrName(e);break;case 20:this.stateInAttrValueSingleQuotes(e);break;case 18:this.stateBeforeAttrValue(e);break;case 8:this.stateBeforeClosingTagName(e);break;case 10:this.stateAfterClosingTagName(e);break;case 29:this.stateBeforeSpecialS(e);break;case 30:this.stateBeforeSpecialT(e);break;case 21:this.stateInAttrValueNoQuotes(e);break;case 7:this.stateInSelfClosingTag(e);break;case 23:this.stateInDeclaration(e);break;case 22:this.stateBeforeDeclaration(e);break;case 25:this.stateBeforeComment(e);break;case 24:this.stateInProcessingInstruction(e);break;case 33:this.stateInEntity()}this.index++}this.cleanup(),this.finish()}cleanup(){this.sectionStart!==this.index&&(1===this.state||32===this.state&&0===this.sequenceIndex?(this.cbs.ontext(this.sectionStart,this.index),this.sectionStart=this.index):19!==this.state&&20!==this.state&&21!==this.state||(this.cbs.onattribdata(this.sectionStart,this.index),this.sectionStart=this.index))}finish(){this.handleTrailingData(),this.cbs.onend()}handleTrailingData(){const e=this.buffer.length;this.sectionStart>=e||(28===this.state?this.currentSequence===$h.CdataEnd?this.cbs.oncdata(this.sectionStart,e):this.cbs.oncomment(this.sectionStart,e):6===this.state||11===this.state||18===this.state||17===this.state||12===this.state||13===this.state||14===this.state||15===this.state||16===this.state||20===this.state||19===this.state||21===this.state||9===this.state||this.cbs.ontext(this.sectionStart,e))}emitCodePoint(e,t){}}(Dd,{onerr:eu,ontext(e,t){Fd(Ld(e,t),e,t)},ontextentity(e,t,n){Fd(e,t,n)},oninterpolation(e,t){if(Ed)return Fd(Ld(e,t),e,t);let n=e+Pd.delimiterOpen.length,r=t-Pd.delimiterClose.length;for(;Qh(xd.charCodeAt(n));)n++;for(;Qh(xd.charCodeAt(r-1));)r--;let i=Ld(n,r);i.includes("&")&&(i=wd.decodeEntities(i,!1)),Yd({type:5,content:Zd(i,!1,Gd(n,r)),loc:Gd(e,t)})},onopentagname(e,t){const n=Ld(e,t);kd={type:1,tag:n,ns:wd.getNamespace(n,Dd[0],wd.ns),tagType:0,props:[],children:[],loc:Gd(e-1,t),codegenNode:void 0}},onopentagend(e){Nd(e)},onclosetag(e,t){const n=Ld(e,t);if(!wd.isVoidTag(n)){let r=!1;for(let e=0;e<Dd.length;e++){if(Dd[e].tag.toLowerCase()===n.toLowerCase()){r=!0,e>0&&eu(24,Dd[0].loc.start.offset);for(let n=0;n<=e;n++){Qd(Dd.shift(),t,n<e)}break}}r||eu(23,Vd(e,60))}},onselfclosingtag(e){const t=kd.tag;kd.isSelfClosing=!0,Nd(e),Dd[0]&&Dd[0].tag===t&&Qd(Dd.shift(),e)},onattribname(e,t){Sd={type:6,name:Ld(e,t),nameLoc:Gd(e,t),value:void 0,loc:Gd(e)}},ondirname(e,t){const n=Ld(e,t),r="."===n||":"===n?"bind":"@"===n?"on":"#"===n?"slot":n.slice(2);if(Ed||""!==r||eu(26,e),Ed||""===r)Sd={type:6,name:n,nameLoc:Gd(e,t),value:void 0,loc:Gd(e)};else if(Sd={type:7,name:r,rawName:n,exp:void 0,arg:void 0,modifiers:"."===n?[_h("prop")]:[],loc:Gd(e)},"pre"===r){Ed=Pd.inVPre=!0,Md=kd;const e=kd.props;for(let t=0;t<e.length;t++)7===e[t].type&&(e[t]=Kd(e[t]))}},ondirarg(e,t){if(e===t)return;const n=Ld(e,t);if(Ed&&!hd(Sd))Sd.name+=n,Jd(Sd.nameLoc,t);else{const r="["!==n[0];Sd.arg=Zd(r?n:n.slice(1,-1),r,Gd(e,t),r?3:0)}},ondirmodifier(e,t){const n=Ld(e,t);if(Ed&&!hd(Sd))Sd.name+="."+n,Jd(Sd.nameLoc,t);else if("slot"===Sd.name){const e=Sd.arg;e&&(e.content+="."+n,Jd(e.loc,t))}else{const r=_h(n,!0,Gd(e,t));Sd.modifiers.push(r)}},onattribdata(e,t){Od+=Ld(e,t),Bd<0&&(Bd=e),_d=t},onattribentity(e,t,n){Od+=e,Bd<0&&(Bd=t),_d=n},onattribnameend(e){const t=Sd.loc.start.offset,n=Ld(t,e);7===Sd.type&&(Sd.rawName=n),kd.props.some(e=>(7===e.type?e.rawName:e.name)===n)&&eu(2,t)},onattribend(e,t){if(kd&&Sd){if(Jd(Sd.loc,t),0!==e)if(Od.includes("&")&&(Od=wd.decodeEntities(Od,!0)),6===Sd.type)"class"===Sd.name&&(Od=Ud(Od).trim()),1!==e||Od||eu(13,t),Sd.value={type:2,content:Od,loc:1===e?Gd(Bd,_d):Gd(Bd-1,_d+1)},Pd.inSFCRoot&&"template"===kd.tag&&"lang"===Sd.name&&Od&&"html"!==Od&&Pd.enterRCDATA(zh("</template"),0);else{let e=0;Sd.exp=Zd(Od,!1,Gd(Bd,_d),0,e),"for"===Sd.name&&(Sd.forParseResult=function(e){const t=e.loc,n=e.content,r=n.match(Ad);if(!r)return;const[,i,o]=r,s=(e,n,r=!1)=>{const i=t.start.offset+n;return Zd(e,!1,Gd(i,i+e.length),0,r?1:0)},a={source:s(o.trim(),n.indexOf(o,i.length)),value:void 0,key:void 0,index:void 0,finalized:!1};let l=i.trim().replace(Id,"").trim();const c=i.indexOf(l),h=l.match(Rd);if(h){l=l.replace(Rd,"").trim();const e=h[1].trim();let t;if(e&&(t=n.indexOf(e,c+l.length),a.key=s(e,t,!0)),h[2]){const r=h[2].trim();r&&(a.index=s(r,n.indexOf(r,a.key?t+e.length:c+l.length),!0))}}l&&(a.value=s(l,c,!0));return a}(Sd.exp));let t=-1;"bind"===Sd.name&&(t=Sd.modifiers.findIndex(e=>"sync"===e.content))>-1&&qh("COMPILER_V_BIND_SYNC",wd,Sd.loc,Sd.arg.loc.source)&&(Sd.name="model",Sd.modifiers.splice(t,1))}7===Sd.type&&"pre"===Sd.name||kd.props.push(Sd)}Od="",Bd=_d=-1},oncomment(e,t){wd.comments&&Yd({type:3,content:Ld(e,t),loc:Gd(e-4,t+3)})},onend(){const e=xd.length;for(let t=0;t<Dd.length;t++)Qd(Dd[t],e-1),eu(24,Dd[t].loc.start.offset)},oncdata(e,t){0!==Dd[0].ns?Fd(Ld(e,t),e,t):eu(1,e-9)},onprocessinginstruction(e){0===(Dd[0]?Dd[0].ns:wd.ns)&&eu(21,e-1)}}),Rd=/,([^,\}\]]*)(?:,([^,\}\]]*))?$/,Id=/^\(|\)$/g;function Ld(e,t){return xd.slice(e,t)}function Nd(e){Pd.inSFCRoot&&(kd.innerLoc=Gd(e+1,e+1)),Yd(kd);const{tag:t,ns:n}=kd;0===n&&wd.isPreTag(t)&&Td++,wd.isVoidTag(t)?Qd(kd,e):(Dd.unshift(kd),1!==n&&2!==n||(Pd.inXML=!0)),kd=null}function Fd(e,t,n){{const t=Dd[0]&&Dd[0].tag;"script"!==t&&"style"!==t&&e.includes("&")&&(e=wd.decodeEntities(e,!1))}const r=Dd[0]||Cd,i=r.children[r.children.length-1];i&&2===i.type?(i.content+=e,Jd(i.loc,n)):r.children.push({type:2,content:e,loc:Gd(t,n)})}function Qd(e,t,n=!1){Jd(e.loc,n?Vd(t,60):function(e,t){let n=e;for(;xd.charCodeAt(n)!==t&&n<xd.length-1;)n++;return n}(t,62)+1),Pd.inSFCRoot&&(e.children.length?e.innerLoc.end=d({},e.children[e.children.length-1].loc.end):e.innerLoc.end=d({},e.innerLoc.start),e.innerLoc.source=Ld(e.innerLoc.start.offset,e.innerLoc.end.offset));const{tag:r,ns:i,children:o}=e;if(Ed||("slot"===r?e.tagType=2:$d(e)?e.tagType=3:function({tag:e,props:t}){if(wd.isCustomElement(e))return!1;if("component"===e||(n=e.charCodeAt(0),n>64&&n<91)||Xh(e)||wd.isBuiltInComponent&&wd.isBuiltInComponent(e)||wd.isNativeTag&&!wd.isNativeTag(e))return!0;var n;for(let e=0;e<t.length;e++){const n=t[e];if(6===n.type){if("is"===n.name&&n.value){if(n.value.content.startsWith("vue:"))return!0;if(qh("COMPILER_IS_ON_ELEMENT",wd,n.loc))return!0}}else if("bind"===n.name&&ld(n.arg,"is")&&qh("COMPILER_IS_ON_ELEMENT",wd,n.loc))return!0}return!1}(e)&&(e.tagType=1)),Pd.inRCDATA||(e.children=jd(o)),0===i&&wd.isIgnoreNewlineTag(r)){const e=o[0];e&&2===e.type&&(e.content=e.content.replace(/^\r?\n/,""))}0===i&&wd.isPreTag(r)&&Td--,Md===e&&(Ed=Pd.inVPre=!1,Md=null),Pd.inXML&&0===(Dd[0]?Dd[0].ns:wd.ns)&&(Pd.inXML=!1);{const t=e.props;if(!Pd.inSFCRoot&&jh("COMPILER_NATIVE_TEMPLATE",wd)&&"template"===e.tag&&!$d(e)){const t=Dd[0]||Cd,n=t.children.indexOf(e);t.children.splice(n,1,...e.children)}const n=t.find(e=>6===e.type&&"inline-template"===e.name);n&&qh("COMPILER_INLINE_TEMPLATE",wd,n.loc)&&e.children.length&&(n.value={type:2,content:Ld(e.children[0].loc.start.offset,e.children[e.children.length-1].loc.end.offset),loc:n.loc})}}function Vd(e,t){let n=e;for(;xd.charCodeAt(n)!==t&&n>=0;)n--;return n}const zd=new Set(["if","else","else-if","for","slot"]);function $d({tag:e,props:t}){if("template"===e)for(let e=0;e<t.length;e++)if(7===t[e].type&&zd.has(t[e].name))return!0;return!1}const Hd=/\r\n/g;function jd(e){const t="preserve"!==wd.whitespace;let n=!1;for(let r=0;r<e.length;r++){const i=e[r];if(2===i.type)if(Td)i.content=i.content.replace(Hd,"\n");else if(qd(i.content)){const o=e[r-1]&&e[r-1].type,s=e[r+1]&&e[r+1].type;!o||!s||t&&(3===o&&(3===s||1===s)||1===o&&(3===s||1===s&&Wd(i.content)))?(n=!0,e[r]=null):i.content=" "}else t&&(i.content=Ud(i.content))}return n?e.filter(Boolean):e}function qd(e){for(let t=0;t<e.length;t++)if(!Qh(e.charCodeAt(t)))return!1;return!0}function Wd(e){for(let t=0;t<e.length;t++){const n=e.charCodeAt(t);if(10===n||13===n)return!0}return!1}function Ud(e){let t="",n=!1;for(let r=0;r<e.length;r++)Qh(e.charCodeAt(r))?n||(t+=" ",n=!0):(t+=e[r],n=!1);return t}function Yd(e){(Dd[0]||Cd).children.push(e)}function Gd(e,t){return{start:Pd.getPos(e),end:null==t?t:Pd.getPos(t),source:null==t?t:Ld(e,t)}}function Xd(e){return Gd(e.start.offset,e.end.offset)}function Jd(e,t){e.end=Pd.getPos(t),e.source=Ld(e.start.offset,t)}function Kd(e){const t={type:6,name:e.rawName,nameLoc:Gd(e.loc.start.offset,e.loc.start.offset+e.rawName.length),value:void 0,loc:e.loc};if(e.exp){const n=e.exp.loc;n.end.offset<e.loc.end.offset&&(n.start.offset--,n.start.column--,n.end.offset++,n.end.column++),t.value={type:2,content:e.exp.content,loc:n}}return t}function Zd(e,t=!1,n,r=0,i=0){return _h(e,t,n,r)}function eu(e,t,n){wd.onError(Yh(e,Gd(t,t)))}function tu(e,t){if(Pd.reset(),kd=null,Sd=null,Od="",Bd=-1,_d=-1,Dd.length=0,xd=e,wd=d({},yd),t){let e;for(e in t)null!=t[e]&&(wd[e]=t[e])}Pd.mode="html"===wd.parseMode?1:"sfc"===wd.parseMode?2:0,Pd.inXML=1===wd.ns||2===wd.ns;const n=t&&t.delimiters;n&&(Pd.delimiterOpen=zh(n[0]),Pd.delimiterClose=zh(n[1]));const r=Cd=function(e,t=""){return{type:0,source:t,children:e,helpers:new Set,components:[],directives:[],hoists:[],imports:[],cached:[],temps:0,codegenNode:void 0,loc:xh}}([],e);return Pd.parse(xd),r.loc=Gd(0,e.length),r.children=jd(r.children),Cd=null,r}function nu(e,t){iu(e,void 0,t,!!ru(e))}function ru(e){const t=e.children.filter(e=>3!==e.type);return 1!==t.length||1!==t[0].type||pd(t[0])?null:t[0]}function iu(e,t,n,r=!1,i=!1){const{children:o}=e,s=[];for(let t=0;t<o.length;t++){const a=o[t];if(1===a.type&&0===a.tagType){const e=r?0:ou(a,n);if(e>0){if(e>=2){a.codegenNode.patchFlag=-1,s.push(a);continue}}else{const e=a.codegenNode;if(13===e.type){const t=e.patchFlag;if((void 0===t||512===t||1===t)&&lu(a,n)>=2){const t=cu(a);t&&(e.props=n.hoist(t))}e.dynamicProps&&(e.dynamicProps=n.hoist(e.dynamicProps))}}}else if(12===a.type){if((r?0:ou(a,n))>=2){14===a.codegenNode.type&&a.codegenNode.arguments.length>0&&a.codegenNode.arguments.push("-1"),s.push(a);continue}}if(1===a.type){const t=1===a.tagType;t&&n.scopes.vSlot++,iu(a,e,n,!1,i),t&&n.scopes.vSlot--}else if(11===a.type)iu(a,e,n,1===a.children.length,!0);else if(9===a.type)for(let t=0;t<a.branches.length;t++)iu(a.branches[t],e,n,1===a.branches[t].children.length,i)}let a=!1;if(s.length===o.length&&1===e.type)if(0===e.tagType&&e.codegenNode&&13===e.codegenNode.type&&g(e.codegenNode.children))e.codegenNode.children=l(Sh(e.codegenNode.children)),a=!0;else if(1===e.tagType&&e.codegenNode&&13===e.codegenNode.type&&e.codegenNode.children&&!g(e.codegenNode.children)&&15===e.codegenNode.children.type){const t=c(e.codegenNode,"default");t&&(t.returns=l(Sh(t.returns)),a=!0)}else if(3===e.tagType&&t&&1===t.type&&1===t.tagType&&t.codegenNode&&13===t.codegenNode.type&&t.codegenNode.children&&!g(t.codegenNode.children)&&15===t.codegenNode.children.type){const n=sd(e,"slot",!0),r=n&&n.arg&&c(t.codegenNode,n.arg);r&&(r.returns=l(Sh(r.returns)),a=!0)}if(!a)for(const e of s)e.codegenNode=n.cache(e.codegenNode);function l(e){const t=n.cache(e);return t.needArraySpread=!0,t}function c(e,t){if(e.children&&!g(e.children)&&15===e.children.type){const n=e.children.properties.find(e=>e.key===t||e.key.content===t);return n&&n.value}}s.length&&n.transformHoist&&n.transformHoist(o,n,e)}function ou(e,t){const{constantCache:n}=t;switch(e.type){case 1:if(0!==e.tagType)return 0;const r=n.get(e);if(void 0!==r)return r;const i=e.codegenNode;if(13!==i.type)return 0;if(i.isBlock&&"svg"!==e.tag&&"foreignObject"!==e.tag&&"math"!==e.tag)return 0;if(void 0===i.patchFlag){let r=3;const o=lu(e,t);if(0===o)return n.set(e,0),0;o<r&&(r=o);for(let i=0;i<e.children.length;i++){const o=ou(e.children[i],t);if(0===o)return n.set(e,0),0;o<r&&(r=o)}if(r>1)for(let i=0;i<e.props.length;i++){const o=e.props[i];if(7===o.type&&"bind"===o.name&&o.exp){const i=ou(o.exp,t);if(0===i)return n.set(e,0),0;i<r&&(r=i)}}if(i.isBlock){for(let t=0;t<e.props.length;t++){if(7===e.props[t].type)return n.set(e,0),0}t.removeHelper($c),t.removeHelper(Rh(t.inSSR,i.isComponent)),i.isBlock=!1,t.helper(Ph(t.inSSR,i.isComponent))}return n.set(e,r),r}return n.set(e,0),0;case 2:case 3:return 3;case 9:case 11:case 10:default:return 0;case 5:case 12:return ou(e.content,t);case 4:return e.constType;case 8:let o=3;for(let n=0;n<e.children.length;n++){const r=e.children[n];if(y(r)||w(r))continue;const i=ou(r,t);if(0===i)return 0;i<o&&(o=i)}return o;case 20:return 2}}const su=new Set([sh,ah,lh,ch]);function au(e,t){if(14===e.type&&!y(e.callee)&&su.has(e.callee)){const n=e.arguments[0];if(4===n.type)return ou(n,t);if(14===n.type)return au(n,t)}return 0}function lu(e,t){let n=3;const r=cu(e);if(r&&15===r.type){const{properties:e}=r;for(let r=0;r<e.length;r++){const{key:i,value:o}=e[r],s=ou(i,t);if(0===s)return s;let a;if(s<n&&(n=s),a=4===o.type?ou(o,t):14===o.type?au(o,t):0,0===a)return a;a<n&&(n=a)}}return n}function cu(e){const t=e.codegenNode;if(13===t.type)return t.props}function hu(e,{filename:t="",prefixIdentifiers:n=!1,hoistStatic:r=!1,hmr:i=!1,cacheHandlers:s=!1,nodeTransforms:l=[],directiveTransforms:c={},transformHoist:h=null,isBuiltInComponent:d=a,isCustomElement:u=a,expressionPlugins:p=[],scopeId:f=null,slotted:g=!0,ssr:m=!1,inSSR:v=!1,ssrCssVars:b="",bindingMetadata:A=o,inline:w=!1,isTS:C=!1,onError:x=Wh,onWarn:k=Uh,compatConfig:S}){const O=t.replace(/\?.*$/,"").match(/([^/\\]+)\.\w+$/),B={filename:t,selfName:O&&L(P(O[1])),prefixIdentifiers:n,hoistStatic:r,hmr:i,cacheHandlers:s,nodeTransforms:l,directiveTransforms:c,transformHoist:h,isBuiltInComponent:d,isCustomElement:u,expressionPlugins:p,scopeId:f,slotted:g,ssr:m,inSSR:v,ssrCssVars:b,bindingMetadata:A,inline:w,isTS:C,onError:x,onWarn:k,compatConfig:S,root:e,helpers:new Map,components:new Set,directives:new Set,hoists:[],imports:[],cached:[],constantCache:new WeakMap,temps:0,identifiers:Object.create(null),scopes:{vFor:0,vSlot:0,vPre:0,vOnce:0},parent:null,grandParent:null,currentNode:e,childIndex:0,inVOnce:!1,helper(e){const t=B.helpers.get(e)||0;return B.helpers.set(e,t+1),e},removeHelper(e){const t=B.helpers.get(e);if(t){const n=t-1;n?B.helpers.set(e,n):B.helpers.delete(e)}},helperString:e=>`_${Ch[B.helper(e)]}`,replaceNode(e){B.parent.children[B.childIndex]=B.currentNode=e},removeNode(e){const t=B.parent.children,n=e?t.indexOf(e):B.currentNode?B.childIndex:-1;e&&e!==B.currentNode?B.childIndex>n&&(B.childIndex--,B.onNodeRemoved()):(B.currentNode=null,B.onNodeRemoved()),B.parent.children.splice(n,1)},onNodeRemoved:a,addIdentifiers(e){},removeIdentifiers(e){},hoist(e){y(e)&&(e=_h(e)),B.hoists.push(e);const t=_h(`_hoisted_${B.hoists.length}`,!1,e.loc,2);return t.hoisted=e,t},cache(e,t=!1,n=!1){const r=function(e,t,n=!1,r=!1){return{type:20,index:e,value:t,needPauseTracking:n,inVOnce:r,needArraySpread:!1,loc:xh}}(B.cached.length,e,t,n);return B.cached.push(r),r}};return B.filters=new Set,B}function du(e,t){const n=hu(e,t);uu(e,n),t.hoistStatic&&nu(e,n),t.ssr||function(e,t){const{helper:n}=t,{children:r}=e;if(1===r.length){const n=ru(e);if(n&&n.codegenNode){const r=n.codegenNode;13===r.type&&Ih(r,t),e.codegenNode=r}else e.codegenNode=r[0]}else if(r.length>1){let r=64;0,e.codegenNode=kh(t,n(Nc),void 0,e.children,r,void 0,void 0,!0,void 0,!1)}}(e,n),e.helpers=new Set([...n.helpers.keys()]),e.components=[...n.components],e.directives=[...n.directives],e.imports=n.imports,e.hoists=n.hoists,e.temps=n.temps,e.cached=n.cached,e.transformed=!0,e.filters=[...n.filters]}function uu(e,t){t.currentNode=e;const{nodeTransforms:n}=t,r=[];for(let i=0;i<n.length;i++){const o=n[i](e,t);if(o&&(g(o)?r.push(...o):r.push(o)),!t.currentNode)return;e=t.currentNode}switch(e.type){case 3:t.ssr||t.helper(Uc);break;case 5:t.ssr||t.helper(ih);break;case 9:for(let n=0;n<e.branches.length;n++)uu(e.branches[n],t);break;case 10:case 11:case 1:case 0:!function(e,t){let n=0;const r=()=>{n--};for(;n<e.children.length;n++){const i=e.children[n];y(i)||(t.grandParent=t.parent,t.parent=e,t.childIndex=n,t.onNodeRemoved=r,uu(i,t))}}(e,t)}t.currentNode=e;let i=r.length;for(;i--;)r[i]()}function pu(e,t){const n=y(e)?t=>t===e:t=>e.test(t);return(e,r)=>{if(1===e.type){const{props:i}=e;if(3===e.tagType&&i.some(dd))return;const o=[];for(let s=0;s<i.length;s++){const a=i[s];if(7===a.type&&n(a.name)){i.splice(s,1),s--;const n=t(e,a,r);n&&o.push(n)}}return o}}}const fu="/*@__PURE__*/",gu=e=>`${Ch[e]}: _${Ch[e]}`;function mu(e,t={}){const n=function(e,{mode:t="function",prefixIdentifiers:n="module"===t,sourceMap:r=!1,filename:i="template.vue.html",scopeId:o=null,optimizeImports:s=!1,runtimeGlobalName:a="Vue",runtimeModuleName:l="vue",ssrRuntimeModuleName:c="vue/server-renderer",ssr:h=!1,isTS:d=!1,inSSR:u=!1}){const p={mode:t,prefixIdentifiers:n,sourceMap:r,filename:i,scopeId:o,optimizeImports:s,runtimeGlobalName:a,runtimeModuleName:l,ssrRuntimeModuleName:c,ssr:h,isTS:d,inSSR:u,source:e.source,code:"",column:1,line:1,offset:0,indentLevel:0,pure:!1,map:void 0,helper:e=>`_${Ch[e]}`,push(e,t=-2,n){p.code+=e},indent(){f(++p.indentLevel)},deindent(e=!1){e?--p.indentLevel:f(--p.indentLevel)},newline(){f(p.indentLevel)}};function f(e){p.push("\n"+"  ".repeat(e),0)}return p}(e,t);t.onContextCreated&&t.onContextCreated(n);const{mode:r,push:i,prefixIdentifiers:o,indent:s,deindent:a,newline:l,scopeId:c,ssr:h}=n,d=Array.from(e.helpers),u=d.length>0,p=!o&&"module"!==r;!function(e,t){const{ssr:n,prefixIdentifiers:r,push:i,newline:o,runtimeModuleName:s,runtimeGlobalName:a,ssrRuntimeModuleName:l}=t,c=a,h=Array.from(e.helpers);if(h.length>0&&(i(`const _Vue = ${c}\n`,-1),e.hoists.length)){i(`const { ${[qc,Wc,Uc,Yc,Gc].filter(e=>h.includes(e)).map(gu).join(", ")} } = _Vue\n`,-1)}(function(e,t){if(!e.length)return;t.pure=!0;const{push:n,newline:r}=t;r();for(let i=0;i<e.length;i++){const o=e[i];o&&(n(`const _hoisted_${i+1} = `),yu(o,t),r())}t.pure=!1})(e.hoists,t),o(),i("return ")}(e,n);if(i(`function ${h?"ssrRender":"render"}(${(h?["_ctx","_push","_parent","_attrs"]:["_ctx","_cache"]).join(", ")}) {`),s(),p&&(i("with (_ctx) {"),s(),u&&(i(`const { ${d.map(gu).join(", ")} } = _Vue\n`,-1),l())),e.components.length&&(vu(e.components,"component",n),(e.directives.length||e.temps>0)&&l()),e.directives.length&&(vu(e.directives,"directive",n),e.temps>0&&l()),e.filters&&e.filters.length&&(l(),vu(e.filters,"filter",n),l()),e.temps>0){i("let ");for(let t=0;t<e.temps;t++)i(`${t>0?", ":""}_temp${t}`)}return(e.components.length||e.directives.length||e.temps)&&(i("\n",0),l()),h||i("return "),e.codegenNode?yu(e.codegenNode,n):i("null"),p&&(a(),i("}")),a(),i("}"),{ast:e,code:n.code,preamble:"",map:n.map?n.map.toJSON():void 0}}function vu(e,t,{helper:n,push:r,newline:i,isTS:o}){const s=n("filter"===t?Zc:"component"===t?Xc:Kc);for(let n=0;n<e.length;n++){let a=e[n];const l=a.endsWith("__self");l&&(a=a.slice(0,-6)),r(`const ${bd(a,t)} = ${s}(${JSON.stringify(a)}${l?", true":""})${o?"!":""}`),n<e.length-1&&i()}}function bu(e,t){const n=e.length>3||!1;t.push("["),n&&t.indent(),Au(e,t,n),n&&t.deindent(),t.push("]")}function Au(e,t,n=!1,r=!0){const{push:i,newline:o}=t;for(let s=0;s<e.length;s++){const a=e[s];y(a)?i(a,-3):g(a)?bu(a,t):yu(a,t),s<e.length-1&&(n?(r&&i(","),o()):r&&i(", "))}}function yu(e,t){if(y(e))t.push(e,-3);else if(w(e))t.push(t.helper(e));else switch(e.type){case 1:case 9:case 11:case 12:yu(e.codegenNode,t);break;case 2:!function(e,t){t.push(JSON.stringify(e.content),-3,e)}(e,t);break;case 4:wu(e,t);break;case 5:!function(e,t){const{push:n,helper:r,pure:i}=t;i&&n(fu);n(`${r(ih)}(`),yu(e.content,t),n(")")}(e,t);break;case 8:Cu(e,t);break;case 3:!function(e,t){const{push:n,helper:r,pure:i}=t;i&&n(fu);n(`${r(Uc)}(${JSON.stringify(e.content)})`,-3,e)}(e,t);break;case 13:!function(e,t){const{push:n,helper:r,pure:i}=t,{tag:o,props:s,children:a,patchFlag:l,dynamicProps:c,directives:h,isBlock:d,disableTracking:u,isComponent:p}=e;let f;l&&(f=String(l));h&&n(r(eh)+"(");d&&n(`(${r($c)}(${u?"true":""}), `);i&&n(fu);const g=d?Rh(t.inSSR,p):Ph(t.inSSR,p);n(r(g)+"(",-2,e),Au(function(e){let t=e.length;for(;t--&&null==e[t];);return e.slice(0,t+1).map(e=>e||"null")}([o,s,a,f,c]),t),n(")"),d&&n(")");h&&(n(", "),yu(h,t),n(")"))}(e,t);break;case 14:!function(e,t){const{push:n,helper:r,pure:i}=t,o=y(e.callee)?e.callee:r(e.callee);i&&n(fu);n(o+"(",-2,e),Au(e.arguments,t),n(")")}(e,t);break;case 15:!function(e,t){const{push:n,indent:r,deindent:i,newline:o}=t,{properties:s}=e;if(!s.length)return void n("{}",-2,e);const a=s.length>1||!1;n(a?"{":"{ "),a&&r();for(let e=0;e<s.length;e++){const{key:r,value:i}=s[e];xu(r,t),n(": "),yu(i,t),e<s.length-1&&(n(","),o())}a&&i(),n(a?"}":" }")}(e,t);break;case 17:!function(e,t){bu(e.elements,t)}(e,t);break;case 18:!function(e,t){const{push:n,indent:r,deindent:i}=t,{params:o,returns:s,body:a,newline:l,isSlot:c}=e;c&&n(`_${Ch[vh]}(`);n("(",-2,e),g(o)?Au(o,t):o&&yu(o,t);n(") => "),(l||a)&&(n("{"),r());s?(l&&n("return "),g(s)?bu(s,t):yu(s,t)):a&&yu(a,t);(l||a)&&(i(),n("}"));c&&(e.isNonScopedSlot&&n(", undefined, true"),n(")"))}(e,t);break;case 19:!function(e,t){const{test:n,consequent:r,alternate:i,newline:o}=e,{push:s,indent:a,deindent:l,newline:c}=t;if(4===n.type){const e=!Kh(n.content);e&&s("("),wu(n,t),e&&s(")")}else s("("),yu(n,t),s(")");o&&a(),t.indentLevel++,o||s(" "),s("? "),yu(r,t),t.indentLevel--,o&&c(),o||s(" "),s(": ");const h=19===i.type;h||t.indentLevel++;yu(i,t),h||t.indentLevel--;o&&l(!0)}(e,t);break;case 20:!function(e,t){const{push:n,helper:r,indent:i,deindent:o,newline:s}=t,{needPauseTracking:a,needArraySpread:l}=e;l&&n("[...(");n(`_cache[${e.index}] || (`),a&&(i(),n(`${r(fh)}(-1`),e.inVOnce&&n(", true"),n("),"),s(),n("("));n(`_cache[${e.index}] = `),yu(e.value,t),a&&(n(`).cacheIndex = ${e.index},`),s(),n(`${r(fh)}(1),`),s(),n(`_cache[${e.index}]`),o());n(")"),l&&n(")]")}(e,t);break;case 21:Au(e.body,t,!0,!1)}}function wu(e,t){const{content:n,isStatic:r}=e;t.push(r?JSON.stringify(n):n,-3,e)}function Cu(e,t){for(let n=0;n<e.children.length;n++){const r=e.children[n];y(r)?t.push(r,-3):yu(r,t)}}function xu(e,t){const{push:n}=t;if(8===e.type)n("["),Cu(e,t),n("]");else if(e.isStatic){n(Kh(e.content)?e.content:JSON.stringify(e.content),-2,e)}else n(`[${e.content}]`,-3,e)}new RegExp("\\b"+"arguments,await,break,case,catch,class,const,continue,debugger,default,delete,do,else,export,extends,finally,for,function,if,import,let,new,return,super,switch,throw,try,var,void,while,with,yield".split(",").join("\\b|\\b")+"\\b");const ku=pu(/^(?:if|else|else-if)$/,(e,t,n)=>function(e,t,n,r){if(!("else"===t.name||t.exp&&t.exp.content.trim())){const r=t.exp?t.exp.loc:e.loc;n.onError(Yh(28,t.loc)),t.exp=_h("true",!1,r)}0;if("if"===t.name){const i=Su(e,t),o={type:9,loc:Xd(e.loc),branches:[i]};if(n.replaceNode(o),r)return r(o,i,!0)}else{const i=n.parent.children;let o=i.indexOf(e);for(;o-- >=-1;){const s=i[o];if(s&&3===s.type)n.removeNode(s);else{if(!s||2!==s.type||s.content.trim().length){if(s&&9===s.type){"else-if"!==t.name&&"else"!==t.name||void 0!==s.branches[s.branches.length-1].condition||n.onError(Yh(30,e.loc)),n.removeNode();const i=Su(e,t);0,s.branches.push(i);const o=r&&r(s,i,!1);uu(i,n),o&&o(),n.currentNode=null}else n.onError(Yh(30,e.loc));break}n.removeNode(s)}}}}(e,t,n,(e,t,r)=>{const i=n.parent.children;let o=i.indexOf(e),s=0;for(;o-- >=0;){const e=i[o];e&&9===e.type&&(s+=e.branches.length)}return()=>{if(r)e.codegenNode=Ou(t,s,n);else{const r=function(e){for(;;)if(19===e.type){if(19!==e.alternate.type)return e;e=e.alternate}else 20===e.type&&(e=e.value)}(e.codegenNode);r.alternate=Ou(t,s+e.branches.length-1,n)}}}));function Su(e,t){const n=3===e.tagType;return{type:10,loc:e.loc,condition:"else"===t.name?void 0:t.exp,children:n&&!sd(e,"for")?e.children:[e],userKey:ad(e,"key"),isTemplateIf:n}}function Ou(e,t,n){return e.condition?Dh(e.condition,Bu(e,t,n),Eh(n.helper(Uc),['""',"true"])):Bu(e,t,n)}function Bu(e,t,n){const{helper:r}=n,i=Bh("key",_h(`${t}`,!1,xh,2)),{children:o}=e,s=o[0];if(1!==o.length||1!==s.type){if(1===o.length&&11===s.type){const e=s.codegenNode;return md(e,i,n),e}{let t=64;return kh(n,r(Nc),Oh([i]),o,t,void 0,void 0,!0,!1,!1,e.loc)}}{const e=s.codegenNode,t=14===(a=e).type&&a.callee===yh?a.arguments[1].returns:a;return 13===t.type&&Ih(t,n),md(t,i,n),e}var a}const _u=pu("for",(e,t,n)=>{const{helper:r,removeHelper:i}=n;return function(e,t,n,r){if(!t.exp)return void n.onError(Yh(31,t.loc));const i=t.forParseResult;if(!i)return void n.onError(Yh(32,t.loc));Tu(i,n);const{addIdentifiers:o,removeIdentifiers:s,scopes:a}=n,{source:l,value:c,key:h,index:d}=i,u={type:11,loc:t.loc,source:l,valueAlias:c,keyAlias:h,objectIndexAlias:d,parseResult:i,children:ud(e)?e.children:[e]};n.replaceNode(u),a.vFor++;const p=r&&r(u);return()=>{a.vFor--,p&&p()}}(e,t,n,t=>{const o=Eh(r(th),[t.source]),s=ud(e),a=sd(e,"memo"),l=ad(e,"key",!1,!0);l&&l.type;let c=l&&(6===l.type?l.value?_h(l.value.content,!0):void 0:l.exp);const h=l&&c?Bh("key",c):null,d=4===t.source.type&&t.source.constType>0,u=d?64:l?128:256;return t.codegenNode=kh(n,r(Nc),void 0,o,u,void 0,void 0,!0,!d,!1,e.loc),()=>{let l;const{children:u}=t;const p=1!==u.length||1!==u[0].type,f=pd(e)?e:s&&1===e.children.length&&pd(e.children[0])?e.children[0]:null;if(f?(l=f.codegenNode,s&&h&&md(l,h,n)):p?l=kh(n,r(Nc),h?Oh([h]):void 0,e.children,64,void 0,void 0,!0,void 0,!1):(l=u[0].codegenNode,s&&h&&md(l,h,n),l.isBlock!==!d&&(l.isBlock?(i($c),i(Rh(n.inSSR,l.isComponent))):i(Ph(n.inSSR,l.isComponent))),l.isBlock=!d,l.isBlock?(r($c),r(Rh(n.inSSR,l.isComponent))):r(Ph(n.inSSR,l.isComponent))),a){const e=Mh(Eu(t.parseResult,[_h("_cached")]));e.body={type:21,body:[Th(["const _memo = (",a.exp,")"]),Th(["if (_cached",...c?[" && _cached.key === ",c]:[],` && ${n.helperString(wh)}(_cached, _memo)) return _cached`]),Th(["const _item = ",l]),_h("_item.memo = _memo"),_h("return _item")],loc:xh},o.arguments.push(e,_h("_cache"),_h(String(n.cached.length))),n.cached.push(null)}else o.arguments.push(Mh(Eu(t.parseResult),l,!0))}})});function Tu(e,t){e.finalized||(e.finalized=!0)}function Eu({value:e,key:t,index:n},r=[]){return function(e){let t=e.length;for(;t--&&!e[t];);return e.slice(0,t+1).map((e,t)=>e||_h("_".repeat(t+1),!1))}([e,t,n,...r])}const Mu=_h("undefined",!1),Du=(e,t)=>{if(1===e.type&&(1===e.tagType||3===e.tagType)){const n=sd(e,"slot");if(n)return n.exp,t.scopes.vSlot++,()=>{t.scopes.vSlot--}}},Pu=(e,t,n,r)=>Mh(e,n,!1,!0,n.length?n[0].loc:r);function Ru(e,t,n=Pu){t.helper(vh);const{children:r,loc:i}=e,o=[],s=[];let a=t.scopes.vSlot>0||t.scopes.vFor>0;const l=sd(e,"slot",!0);if(l){const{arg:e,exp:t}=l;e&&!Gh(e)&&(a=!0),o.push(Bh(e||_h("default",!0),n(t,void 0,r,i)))}let c=!1,h=!1;const d=[],u=new Set;let p=0;for(let e=0;e<r.length;e++){const i=r[e];let f;if(!ud(i)||!(f=sd(i,"slot",!0))){3!==i.type&&d.push(i);continue}if(l){t.onError(Yh(37,f.loc));break}c=!0;const{children:g,loc:m}=i,{arg:v=_h("default",!0),exp:b,loc:A}=f;let y;Gh(v)?y=v?v.content:"default":a=!0;const w=sd(i,"for"),C=n(b,w,g,m);let x,k;if(x=sd(i,"if"))a=!0,s.push(Dh(x.exp,Iu(v,C,p++),Mu));else if(k=sd(i,/^else(?:-if)?$/,!0)){let n,i=e;for(;i--&&(n=r[i],3===n.type||!Nu(n)););if(n&&ud(n)&&sd(n,/^(?:else-)?if$/)){let e=s[s.length-1];for(;19===e.alternate.type;)e=e.alternate;e.alternate=k.exp?Dh(k.exp,Iu(v,C,p++),Mu):Iu(v,C,p++)}else t.onError(Yh(30,k.loc))}else if(w){a=!0;const e=w.forParseResult;e?(Tu(e),s.push(Eh(t.helper(th),[e.source,Mh(Eu(e),Iu(v,C),!0)]))):t.onError(Yh(32,w.loc))}else{if(y){if(u.has(y)){t.onError(Yh(38,A));continue}u.add(y),"default"===y&&(h=!0)}o.push(Bh(v,C))}}if(!l){const e=(e,r)=>{const o=n(e,void 0,r,i);return t.compatConfig&&(o.isNonScopedSlot=!0),Bh("default",o)};c?d.length&&d.some(e=>Nu(e))&&(h?t.onError(Yh(39,d[0].loc)):o.push(e(void 0,d))):o.push(e(void 0,r))}const f=a?2:Lu(e.children)?3:1;let g=Oh(o.concat(Bh("_",_h(f+"",!1))),i);return s.length&&(g=Eh(t.helper(rh),[g,Sh(s)])),{slots:g,hasDynamicSlots:a}}function Iu(e,t,n){const r=[Bh("name",e),Bh("fn",t)];return null!=n&&r.push(Bh("key",_h(String(n),!0))),Oh(r)}function Lu(e){for(let t=0;t<e.length;t++){const n=e[t];switch(n.type){case 1:if(2===n.tagType||Lu(n.children))return!0;break;case 9:if(Lu(n.branches))return!0;break;case 10:case 11:if(Lu(n.children))return!0}}return!1}function Nu(e){return 2!==e.type&&12!==e.type||(2===e.type?!!e.content.trim():Nu(e.content))}const Fu=new WeakMap,Qu=(e,t)=>function(){if(1!==(e=t.currentNode).type||0!==e.tagType&&1!==e.tagType)return;const{tag:n,props:r}=e,i=1===e.tagType;let o=i?function(e,t,n=!1){let{tag:r}=e;const i=Hu(r),o=ad(e,"is",!1,!0);if(o)if(i||jh("COMPILER_IS_ON_ELEMENT",t)){let e;if(6===o.type?e=o.value&&_h(o.value.content,!0):(e=o.exp,e||(e=_h("is",!1,o.arg.loc))),e)return Eh(t.helper(Jc),[e])}else 6===o.type&&o.value.content.startsWith("vue:")&&(r=o.value.content.slice(4));const s=Xh(r)||t.isBuiltInComponent(r);if(s)return n||t.helper(s),s;return t.helper(Xc),t.components.add(r),bd(r,"component")}(e,t):`"${n}"`;const s=C(o)&&o.callee===Jc;let a,l,c,h,d,u=0,p=s||o===Fc||o===Qc||!i&&("svg"===n||"foreignObject"===n||"math"===n);if(r.length>0){const n=Vu(e,t,void 0,i,s);a=n.props,u=n.patchFlag,h=n.dynamicPropNames;const r=n.directives;d=r&&r.length?Sh(r.map(e=>function(e,t){const n=[],r=Fu.get(e);r?n.push(t.helperString(r)):(t.helper(Kc),t.directives.add(e.name),n.push(bd(e.name,"directive")));const{loc:i}=e;e.exp&&n.push(e.exp);e.arg&&(e.exp||n.push("void 0"),n.push(e.arg));if(Object.keys(e.modifiers).length){e.arg||(e.exp||n.push("void 0"),n.push("void 0"));const t=_h("true",!1,i);n.push(Oh(e.modifiers.map(e=>Bh(e,t)),i))}return Sh(n,e.loc)}(e,t))):void 0,n.shouldUseBlock&&(p=!0)}if(e.children.length>0){o===Vc&&(p=!0,u|=1024);if(i&&o!==Fc&&o!==Vc){const{slots:n,hasDynamicSlots:r}=Ru(e,t);l=n,r&&(u|=1024)}else if(1===e.children.length&&o!==Fc){const n=e.children[0],r=n.type,i=5===r||8===r;i&&0===ou(n,t)&&(u|=1),l=i||2===r?n:e.children}else l=e.children}h&&h.length&&(c=function(e){let t="[";for(let n=0,r=e.length;n<r;n++)t+=JSON.stringify(e[n]),n<r-1&&(t+=", ");return t+"]"}(h)),e.codegenNode=kh(t,o,a,l,0===u?void 0:u,c,d,!!p,!1,i,e.loc)};function Vu(e,t,n=e.props,r,i,o=!1){const{tag:s,loc:a,children:l}=e;let h=[];const d=[],u=[],p=l.length>0;let f=!1,g=0,m=!1,v=!1,b=!1,A=!1,y=!1,C=!1;const x=[],k=e=>{h.length&&(d.push(Oh(zu(h),a)),h=[]),e&&d.push(e)},S=()=>{t.scopes.vFor>0&&h.push(Bh(_h("ref_for",!0),_h("true")))},O=({key:e,value:n})=>{if(Gh(e)){const o=e.content,s=c(o);if(!s||r&&!i||"onclick"===o.toLowerCase()||"onUpdate:modelValue"===o||T(o)||(A=!0),s&&T(o)&&(C=!0),s&&14===n.type&&(n=n.arguments[0]),20===n.type||(4===n.type||8===n.type)&&ou(n,t)>0)return;"ref"===o?m=!0:"class"===o?v=!0:"style"===o?b=!0:"key"===o||x.includes(o)||x.push(o),!r||"class"!==o&&"style"!==o||x.includes(o)||x.push(o)}else y=!0};for(let i=0;i<n.length;i++){const l=n[i];if(6===l.type){const{loc:e,name:n,nameLoc:r,value:i}=l;let o=!0;if("ref"===n&&(m=!0,S()),"is"===n&&(Hu(s)||i&&i.content.startsWith("vue:")||jh("COMPILER_IS_ON_ELEMENT",t)))continue;h.push(Bh(_h(n,!0,r),_h(i?i.content:"",o,i?i.loc:e)))}else{const{name:n,arg:i,exp:c,loc:m,modifiers:v}=l,b="bind"===n,A="on"===n;if("slot"===n){r||t.onError(Yh(40,m));continue}if("once"===n||"memo"===n)continue;if("is"===n||b&&ld(i,"is")&&(Hu(s)||jh("COMPILER_IS_ON_ELEMENT",t)))continue;if(A&&o)continue;if((b&&ld(i,"key")||A&&p&&ld(i,"vue:before-update"))&&(f=!0),b&&ld(i,"ref")&&S(),!i&&(b||A)){if(y=!0,c)if(b){if(k(),jh("COMPILER_V_BIND_OBJECT_ORDER",t)){d.unshift(c);continue}S(),k(),d.push(c)}else k({type:14,loc:m,callee:t.helper(hh),arguments:r?[c]:[c,"true"]});else t.onError(Yh(b?34:35,m));continue}b&&v.some(e=>"prop"===e.content)&&(g|=32);const C=t.directiveTransforms[n];if(C){const{props:n,needRuntime:r}=C(l,e,t);!o&&n.forEach(O),A&&i&&!Gh(i)?k(Oh(n,a)):h.push(...n),r&&(u.push(l),w(r)&&Fu.set(l,r))}else E(n)||(u.push(l),p&&(f=!0))}}let B;if(d.length?(k(),B=d.length>1?Eh(t.helper(oh),d,a):d[0]):h.length&&(B=Oh(zu(h),a)),y?g|=16:(v&&!r&&(g|=2),b&&!r&&(g|=4),x.length&&(g|=8),A&&(g|=32)),f||0!==g&&32!==g||!(m||C||u.length>0)||(g|=512),!t.inSSR&&B)switch(B.type){case 15:let e=-1,n=-1,r=!1;for(let t=0;t<B.properties.length;t++){const i=B.properties[t].key;Gh(i)?"class"===i.content?e=t:"style"===i.content&&(n=t):i.isHandlerKey||(r=!0)}const i=B.properties[e],o=B.properties[n];r?B=Eh(t.helper(lh),[B]):(i&&!Gh(i.value)&&(i.value=Eh(t.helper(sh),[i.value])),o&&(b||4===o.value.type&&"["===o.value.content.trim()[0]||17===o.value.type)&&(o.value=Eh(t.helper(ah),[o.value])));break;case 14:break;default:B=Eh(t.helper(lh),[Eh(t.helper(ch),[B])])}return{props:B,directives:u,patchFlag:g,dynamicPropNames:x,shouldUseBlock:f}}function zu(e){const t=new Map,n=[];for(let r=0;r<e.length;r++){const i=e[r];if(8===i.key.type||!i.key.isStatic){n.push(i);continue}const o=i.key.content,s=t.get(o);s?("style"===o||"class"===o||c(o))&&$u(s,i):(t.set(o,i),n.push(i))}return n}function $u(e,t){17===e.value.type?e.value.elements.push(t.value):e.value=Sh([e.value,t.value],e.loc)}function Hu(e){return"component"===e||"Component"===e}const ju=(e,t)=>{if(pd(e)){const{children:n,loc:r}=e,{slotName:i,slotProps:o}=function(e,t){let n,r='"default"';const i=[];for(let t=0;t<e.props.length;t++){const n=e.props[t];if(6===n.type)n.value&&("name"===n.name?r=JSON.stringify(n.value.content):(n.name=P(n.name),i.push(n)));else if("bind"===n.name&&ld(n.arg,"name")){if(n.exp)r=n.exp;else if(n.arg&&4===n.arg.type){const e=P(n.arg.content);r=n.exp=_h(e,!1,n.arg.loc)}}else"bind"===n.name&&n.arg&&Gh(n.arg)&&(n.arg.content=P(n.arg.content)),i.push(n)}if(i.length>0){const{props:r,directives:o}=Vu(e,t,i,!1,!1);n=r,o.length&&t.onError(Yh(36,o[0].loc))}return{slotName:r,slotProps:n}}(e,t),s=[t.prefixIdentifiers?"_ctx.$slots":"$slots",i,"{}","undefined","true"];let a=2;o&&(s[2]=o,a=3),n.length&&(s[3]=Mh([],n,!1,!1,r),a=4),t.scopeId&&!t.slotted&&(a=5),s.splice(a),e.codegenNode=Eh(t.helper(nh),s,r)}};const qu=(e,t,n,r)=>{const{loc:i,modifiers:o,arg:s}=e;let a;if(e.exp||o.length||n.onError(Yh(35,i)),4===s.type)if(s.isStatic){let e=s.content;0,e.startsWith("vue:")&&(e=`vnode-${e.slice(4)}`);a=_h(0!==t.tagType||e.startsWith("vnode")||!/[A-Z]/.test(e)?N(P(e)):`on:${e}`,!0,s.loc)}else a=Th([`${n.helperString(ph)}(`,s,")"]);else a=s,a.children.unshift(`${n.helperString(ph)}(`),a.children.push(")");let l=e.exp;l&&!l.content.trim()&&(l=void 0);let c=n.cacheHandlers&&!l&&!n.inVOnce;if(l){const e=rd(l),t=!(e||od(l)),n=l.content.includes(";");0,(t||c&&e)&&(l=Th([`${t?"$event":"(...args)"} => ${n?"{":"("}`,l,n?"}":")"]))}let h={props:[Bh(a,l||_h("() => {}",!1,i))]};return r&&(h=r(h)),c&&(h.props[0].value=n.cache(h.props[0].value)),h.props.forEach(e=>e.key.isHandlerKey=!0),h},Wu=(e,t,n)=>{const{modifiers:r,loc:i}=e,o=e.arg;let{exp:s}=e;return s&&4===s.type&&!s.content.trim()&&(s=void 0),4!==o.type?(o.children.unshift("("),o.children.push(') || ""')):o.isStatic||(o.content=o.content?`${o.content} || ""`:'""'),r.some(e=>"camel"===e.content)&&(4===o.type?o.isStatic?o.content=P(o.content):o.content=`${n.helperString(dh)}(${o.content})`:(o.children.unshift(`${n.helperString(dh)}(`),o.children.push(")"))),n.inSSR||(r.some(e=>"prop"===e.content)&&Uu(o,"."),r.some(e=>"attr"===e.content)&&Uu(o,"^")),{props:[Bh(o,s)]}},Uu=(e,t)=>{4===e.type?e.isStatic?e.content=t+e.content:e.content=`\`${t}\${${e.content}}\``:(e.children.unshift(`'${t}' + (`),e.children.push(")"))},Yu=(e,t)=>{if(0===e.type||1===e.type||11===e.type||10===e.type)return()=>{const n=e.children;let r,i=!1;for(let e=0;e<n.length;e++){const t=n[e];if(cd(t)){i=!0;for(let i=e+1;i<n.length;i++){const o=n[i];if(!cd(o)){r=void 0;break}r||(r=n[e]=Th([t],t.loc)),r.children.push(" + ",o),n.splice(i,1),i--}}}if(i&&(1!==n.length||0!==e.type&&(1!==e.type||0!==e.tagType||e.props.find(e=>7===e.type&&!t.directiveTransforms[e.name])||"template"===e.tag)))for(let e=0;e<n.length;e++){const r=n[e];if(cd(r)||8===r.type){const i=[];2===r.type&&" "===r.content||i.push(r),t.ssr||0!==ou(r,t)||i.push("1"),n[e]={type:12,content:r,loc:r.loc,codegenNode:Eh(t.helper(Yc),i)}}}}},Gu=new WeakSet,Xu=(e,t)=>{if(1===e.type&&sd(e,"once",!0)){if(Gu.has(e)||t.inVOnce||t.inSSR)return;return Gu.add(e),t.inVOnce=!0,t.helper(fh),()=>{t.inVOnce=!1;const e=t.currentNode;e.codegenNode&&(e.codegenNode=t.cache(e.codegenNode,!0,!0))}}},Ju=(e,t,n)=>{const{exp:r,arg:i}=e;if(!r)return n.onError(Yh(41,e.loc)),Ku();const o=r.loc.source.trim(),s=4===r.type?r.content:o,a=n.bindingMetadata[o];if("props"===a||"props-aliased"===a)return n.onError(Yh(44,r.loc)),Ku();if(!s.trim()||!rd(r))return n.onError(Yh(42,r.loc)),Ku();const l=i||_h("modelValue",!0),c=i?Gh(i)?`onUpdate:${P(i.content)}`:Th(['"onUpdate:" + ',i]):"onUpdate:modelValue";let h;h=Th([`${n.isTS?"($event: any)":"$event"} => ((`,r,") = $event)"]);const d=[Bh(l,e.exp),Bh(c,h)];if(e.modifiers.length&&1===t.tagType){const t=e.modifiers.map(e=>e.content).map(e=>(Kh(e)?e:JSON.stringify(e))+": true").join(", "),n=i?Gh(i)?`${i.content}Modifiers`:Th([i,' + "Modifiers"']):"modelModifiers";d.push(Bh(n,_h(`{ ${t} }`,!1,e.loc,2)))}return Ku(d)};function Ku(e=[]){return{props:e}}const Zu=/[\w).+\-_$\]]/,ep=(e,t)=>{jh("COMPILER_FILTERS",t)&&(5===e.type?tp(e.content,t):1===e.type&&e.props.forEach(e=>{7===e.type&&"for"!==e.name&&e.exp&&tp(e.exp,t)}))};function tp(e,t){if(4===e.type)np(e,t);else for(let n=0;n<e.children.length;n++){const r=e.children[n];"object"==typeof r&&(4===r.type?np(r,t):8===r.type?tp(e,t):5===r.type&&tp(r.content,t))}}function np(e,t){const n=e.content;let r,i,o,s,a=!1,l=!1,c=!1,h=!1,d=0,u=0,p=0,f=0,g=[];for(o=0;o<n.length;o++)if(i=r,r=n.charCodeAt(o),a)39===r&&92!==i&&(a=!1);else if(l)34===r&&92!==i&&(l=!1);else if(c)96===r&&92!==i&&(c=!1);else if(h)47===r&&92!==i&&(h=!1);else if(124!==r||124===n.charCodeAt(o+1)||124===n.charCodeAt(o-1)||d||u||p){switch(r){case 34:l=!0;break;case 39:a=!0;break;case 96:c=!0;break;case 40:p++;break;case 41:p--;break;case 91:u++;break;case 93:u--;break;case 123:d++;break;case 125:d--}if(47===r){let e,t=o-1;for(;t>=0&&(e=n.charAt(t)," "===e);t--);e&&Zu.test(e)||(h=!0)}}else void 0===s?(f=o+1,s=n.slice(0,o).trim()):m();function m(){g.push(n.slice(f,o).trim()),f=o+1}if(void 0===s?s=n.slice(0,o).trim():0!==f&&m(),g.length){for(o=0;o<g.length;o++)s=rp(s,g[o],t);e.content=s,e.ast=void 0}}function rp(e,t,n){n.helper(Zc);const r=t.indexOf("(");if(r<0)return n.filters.add(t),`${bd(t,"filter")}(${e})`;{const i=t.slice(0,r),o=t.slice(r+1);return n.filters.add(i),`${bd(i,"filter")}(${e}${")"!==o?","+o:o}`}}const ip=new WeakSet,op=(e,t)=>{if(1===e.type){const n=sd(e,"memo");if(!n||ip.has(e)||t.inSSR)return;return ip.add(e),()=>{const r=e.codegenNode||t.currentNode.codegenNode;r&&13===r.type&&(1!==e.tagType&&Ih(r,t),e.codegenNode=Eh(t.helper(yh),[n.exp,Mh(void 0,r),"_cache",String(t.cached.length)]),t.cached.push(null))}}},sp=(e,t)=>{if(1===e.type)for(const n of e.props)if(7===n.type&&"bind"===n.name&&!n.exp){const e=n.arg;if(4===e.type&&e.isStatic){const t=P(e.content);(Zh.test(t[0])||"-"===t[0])&&(n.exp=_h(t,!1,e.loc))}else t.onError(Yh(52,e.loc)),n.exp=_h("",!0,e.loc)}};function ap(e,t={}){const n=t.onError||Wh,r="module"===t.mode;!0===t.prefixIdentifiers?n(Yh(47)):r&&n(Yh(48));t.cacheHandlers&&n(Yh(49)),t.scopeId&&!r&&n(Yh(50));const i=d({},t,{prefixIdentifiers:!1}),o=y(e)?tu(e,i):e,[s,a]=[[sp,Xu,ku,op,_u,ep,ju,Qu,Du,Yu],{on:qu,bind:Wu,model:Ju}];return du(o,d({},i,{nodeTransforms:[...s,...t.nodeTransforms||[]],directiveTransforms:d({},a,t.directiveTransforms||{})})),mu(o,i)}const lp=Symbol(""),cp=Symbol(""),hp=Symbol(""),dp=Symbol(""),up=Symbol(""),pp=Symbol(""),fp=Symbol(""),gp=Symbol(""),mp=Symbol(""),vp=Symbol("");var bp;let Ap;bp={[lp]:"vModelRadio",[cp]:"vModelCheckbox",[hp]:"vModelText",[dp]:"vModelSelect",[up]:"vModelDynamic",[pp]:"withModifiers",[fp]:"withKeys",[gp]:"vShow",[mp]:"Transition",[vp]:"TransitionGroup"},Object.getOwnPropertySymbols(bp).forEach(e=>{Ch[e]=bp[e]});const yp={parseMode:"html",isVoidTag:ne,isNativeTag:e=>Z(e)||ee(e)||te(e),isPreTag:e=>"pre"===e,isIgnoreNewlineTag:e=>"pre"===e||"textarea"===e,decodeEntities:function(e,t=!1){return Ap||(Ap=document.createElement("div")),t?(Ap.innerHTML=`<div foo="${e.replace(/"/g,"&quot;")}">`,Ap.children[0].getAttribute("foo")):(Ap.innerHTML=e,Ap.textContent)},isBuiltInComponent:e=>"Transition"===e||"transition"===e?mp:"TransitionGroup"===e||"transition-group"===e?vp:void 0,getNamespace(e,t,n){let r=t?t.ns:n;if(t&&2===r)if("annotation-xml"===t.tag){if("svg"===e)return 1;t.props.some(e=>6===e.type&&"encoding"===e.name&&null!=e.value&&("text/html"===e.value.content||"application/xhtml+xml"===e.value.content))&&(r=0)}else/^m(?:[ions]|text)$/.test(t.tag)&&"mglyph"!==e&&"malignmark"!==e&&(r=0);else t&&1===r&&("foreignObject"!==t.tag&&"desc"!==t.tag&&"title"!==t.tag||(r=0));if(0===r){if("svg"===e)return 1;if("math"===e)return 2}return r}},Cp=(e,t)=>{const n=X(e);return _h(JSON.stringify(n),!1,t,3)};function xp(e,t){return Yh(e,t)}const kp=i("passive,once,capture"),Sp=i("stop,prevent,self,ctrl,shift,alt,meta,exact,middle"),Op=i("left,right"),Bp=i("onkeyup,onkeydown,onkeypress"),_p=(e,t)=>Gh(e)&&"onclick"===e.content.toLowerCase()?_h(t,!0):4!==e.type?Th(["(",e,`) === "onClick" ? "${t}" : (`,e,")"]):e;const Tp=(e,t)=>{1!==e.type||0!==e.tagType||"script"!==e.tag&&"style"!==e.tag||t.removeNode()};const Ep=[e=>{1===e.type&&e.props.forEach((t,n)=>{6===t.type&&"style"===t.name&&t.value&&(e.props[n]={type:7,name:"bind",arg:_h("style",!0,t.loc),exp:Cp(t.value.content,t.loc),modifiers:[],loc:t.loc})})}],Mp={cloak:()=>({props:[]}),html:(e,t,n)=>{const{exp:r,loc:i}=e;return r||n.onError(xp(53,i)),t.children.length&&(n.onError(xp(54,i)),t.children.length=0),{props:[Bh(_h("innerHTML",!0,i),r||_h("",!0))]}},text:(e,t,n)=>{const{exp:r,loc:i}=e;return r||n.onError(xp(55,i)),t.children.length&&(n.onError(xp(56,i)),t.children.length=0),{props:[Bh(_h("textContent",!0),r?ou(r,n)>0?r:Eh(n.helperString(ih),[r],i):_h("",!0))]}},model:(e,t,n)=>{const r=Ju(e,t,n);if(!r.props.length||1===t.tagType)return r;e.arg&&n.onError(xp(58,e.arg.loc));const{tag:i}=t,o=n.isCustomElement(i);if("input"===i||"textarea"===i||"select"===i||o){let s=hp,a=!1;if("input"===i||o){const r=ad(t,"type");if(r){if(7===r.type)s=up;else if(r.value)switch(r.value.content){case"radio":s=lp;break;case"checkbox":s=cp;break;case"file":a=!0,n.onError(xp(59,e.loc))}}else(function(e){return e.props.some(e=>!(7!==e.type||"bind"!==e.name||e.arg&&4===e.arg.type&&e.arg.isStatic))})(t)&&(s=up)}else"select"===i&&(s=dp);a||(r.needRuntime=n.helper(s))}else n.onError(xp(57,e.loc));return r.props=r.props.filter(e=>!(4===e.key.type&&"modelValue"===e.key.content)),r},on:(e,t,n)=>qu(e,t,n,t=>{const{modifiers:r}=e;if(!r.length)return t;let{key:i,value:o}=t.props[0];const{keyModifiers:s,nonKeyModifiers:a,eventOptionModifiers:l}=((e,t,n)=>{const r=[],i=[],o=[];for(let s=0;s<t.length;s++){const a=t[s].content;"native"===a&&qh("COMPILER_V_ON_NATIVE",n)||kp(a)?o.push(a):Op(a)?Gh(e)?Bp(e.content.toLowerCase())?r.push(a):i.push(a):(r.push(a),i.push(a)):Sp(a)?i.push(a):r.push(a)}return{keyModifiers:r,nonKeyModifiers:i,eventOptionModifiers:o}})(i,r,n,e.loc);if(a.includes("right")&&(i=_p(i,"onContextmenu")),a.includes("middle")&&(i=_p(i,"onMouseup")),a.length&&(o=Eh(n.helper(pp),[o,JSON.stringify(a)])),!s.length||Gh(i)&&!Bp(i.content.toLowerCase())||(o=Eh(n.helper(fp),[o,JSON.stringify(s)])),l.length){const e=l.map(L).join("");i=Gh(i)?_h(`${i.content}${e}`,!0):Th(["(",i,`) + "${e}"`])}return{props:[Bh(i,o)]}}),show:(e,t,n)=>{const{exp:r,loc:i}=e;return r||n.onError(xp(61,i)),{props:[],needRuntime:n.helper(gp)}}};const Dp=Object.create(null);Aa(function(e,t){if(!y(e)){if(!e.nodeType)return a;e=e.innerHTML}const n=function(e,t){return e+JSON.stringify(t,(e,t)=>"function"==typeof t?t.toString():t)}(e,t),i=Dp[n];if(i)return i;if("#"===e[0]){const t=document.querySelector(e);0,e=t?t.innerHTML:""}const o=d({hoistStatic:!0,onError:void 0,onWarn:a},t);o.isCustomElement||"undefined"==typeof customElements||(o.isCustomElement=e=>!!customElements.get(e));const{code:s}=function(e,t={}){return ap(e,d({},yp,t,{nodeTransforms:[Tp,...Ep,...t.nodeTransforms||[]],directiveTransforms:d({},Mp,t.directiveTransforms||{}),transformHoist:null}))}(e,o),l=new Function("Vue",s)(r);return l._rc=!0,Dp[n]=l});const Pp="undefined"!=typeof document;function Rp(e){return"object"==typeof e||"displayName"in e||"props"in e||"__vccOpts"in e}function Ip(e){return e.__esModule||"Module"===e[Symbol.toStringTag]||e.default&&Rp(e.default)}const Lp=Object.assign;function Np(e,t){const n={};for(const r in t){const i=t[r];n[r]=Qp(i)?i.map(e):e(i)}return n}const Fp=()=>{},Qp=Array.isArray;const Vp=/#/g,zp=/&/g,$p=/\//g,Hp=/=/g,jp=/\?/g,qp=/\+/g,Wp=/%5B/g,Up=/%5D/g,Yp=/%5E/g,Gp=/%60/g,Xp=/%7B/g,Jp=/%7C/g,Kp=/%7D/g,Zp=/%20/g;function ef(e){return encodeURI(""+e).replace(Jp,"|").replace(Wp,"[").replace(Up,"]")}function tf(e){return ef(e).replace(qp,"%2B").replace(Zp,"+").replace(Vp,"%23").replace(zp,"%26").replace(Gp,"`").replace(Xp,"{").replace(Kp,"}").replace(Yp,"^")}function nf(e){return tf(e).replace(Hp,"%3D")}function rf(e){return null==e?"":function(e){return ef(e).replace(Vp,"%23").replace(jp,"%3F")}(e).replace($p,"%2F")}function of(e){try{return decodeURIComponent(""+e)}catch(e){}return""+e}const sf=/\/$/;function af(e,t,n="/"){let r,i={},o="",s="";const a=t.indexOf("#");let l=t.indexOf("?");return a<l&&a>=0&&(l=-1),l>-1&&(r=t.slice(0,l),o=t.slice(l+1,a>-1?a:t.length),i=e(o)),a>-1&&(r=r||t.slice(0,a),s=t.slice(a,t.length)),r=function(e,t){if(e.startsWith("/"))return e;0;if(!e)return t;const n=t.split("/"),r=e.split("/"),i=r[r.length-1];".."!==i&&"."!==i||r.push("");let o,s,a=n.length-1;for(o=0;o<r.length;o++)if(s=r[o],"."!==s){if(".."!==s)break;a>1&&a--}return n.slice(0,a).join("/")+"/"+r.slice(o).join("/")}(null!=r?r:t,n),{fullPath:r+(o&&"?")+o+s,path:r,query:i,hash:of(s)}}function lf(e,t){return t&&e.toLowerCase().startsWith(t.toLowerCase())?e.slice(t.length)||"/":e}function cf(e,t){return(e.aliasOf||e)===(t.aliasOf||t)}function hf(e,t){if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const n in e)if(!df(e[n],t[n]))return!1;return!0}function df(e,t){return Qp(e)?uf(e,t):Qp(t)?uf(t,e):e===t}function uf(e,t){return Qp(t)?e.length===t.length&&e.every((e,n)=>e===t[n]):1===e.length&&e[0]===t}const pf={path:"/",name:void 0,params:{},query:{},hash:"",fullPath:"/",matched:[],meta:{},redirectedFrom:void 0};var ff,gf;!function(e){e.pop="pop",e.push="push"}(ff||(ff={})),function(e){e.back="back",e.forward="forward",e.unknown=""}(gf||(gf={}));function mf(e){if(!e)if(Pp){const t=document.querySelector("base");e=(e=t&&t.getAttribute("href")||"/").replace(/^\w+:\/\/[^\/]+/,"")}else e="/";return"/"!==e[0]&&"#"!==e[0]&&(e="/"+e),e.replace(sf,"")}const vf=/^[^#]+#/;function bf(e,t){return e.replace(vf,"#")+t}const Af=()=>({left:window.scrollX,top:window.scrollY});function yf(e){let t;if("el"in e){const n=e.el,r="string"==typeof n&&n.startsWith("#");0;const i="string"==typeof n?r?document.getElementById(n.slice(1)):document.querySelector(n):n;if(!i)return;t=function(e,t){const n=document.documentElement.getBoundingClientRect(),r=e.getBoundingClientRect();return{behavior:t.behavior,left:r.left-n.left-(t.left||0),top:r.top-n.top-(t.top||0)}}(i,e)}else t=e;"scrollBehavior"in document.documentElement.style?window.scrollTo(t):window.scrollTo(null!=t.left?t.left:window.scrollX,null!=t.top?t.top:window.scrollY)}function wf(e,t){return(history.state?history.state.position-t:-1)+e}const Cf=new Map;let xf=()=>location.protocol+"//"+location.host;function kf(e,t){const{pathname:n,search:r,hash:i}=t,o=e.indexOf("#");if(o>-1){let t=i.includes(e.slice(o))?e.slice(o).length:1,n=i.slice(t);return"/"!==n[0]&&(n="/"+n),lf(n,"")}return lf(n,e)+r+i}function Sf(e,t,n,r=!1,i=!1){return{back:e,current:t,forward:n,replaced:r,position:window.history.length,scroll:i?Af():null}}function Of(e){const t=function(e){const{history:t,location:n}=window,r={value:kf(e,n)},i={value:t.state};function o(r,o,s){const a=e.indexOf("#"),l=a>-1?(n.host&&document.querySelector("base")?e:e.slice(a))+r:xf()+e+r;try{t[s?"replaceState":"pushState"](o,"",l),i.value=o}catch(e){console.error(e),n[s?"replace":"assign"](l)}}return i.value||o(r.value,{back:null,current:r.value,forward:null,position:t.length-1,replaced:!0,scroll:null},!0),{location:r,state:i,push:function(e,n){const s=Lp({},i.value,t.state,{forward:e,scroll:Af()});o(s.current,s,!0),o(e,Lp({},Sf(r.value,e,null),{position:s.position+1},n),!1),r.value=e},replace:function(e,n){o(e,Lp({},t.state,Sf(i.value.back,e,i.value.forward,!0),n,{position:i.value.position}),!0),r.value=e}}}(e=mf(e)),n=function(e,t,n,r){let i=[],o=[],s=null;const a=({state:o})=>{const a=kf(e,location),l=n.value,c=t.value;let h=0;if(o){if(n.value=a,t.value=o,s&&s===l)return void(s=null);h=c?o.position-c.position:0}else r(a);i.forEach(e=>{e(n.value,l,{delta:h,type:ff.pop,direction:h?h>0?gf.forward:gf.back:gf.unknown})})};function l(){const{history:e}=window;e.state&&e.replaceState(Lp({},e.state,{scroll:Af()}),"")}return window.addEventListener("popstate",a),window.addEventListener("beforeunload",l,{passive:!0}),{pauseListeners:function(){s=n.value},listen:function(e){i.push(e);const t=()=>{const t=i.indexOf(e);t>-1&&i.splice(t,1)};return o.push(t),t},destroy:function(){for(const e of o)e();o=[],window.removeEventListener("popstate",a),window.removeEventListener("beforeunload",l)}}}(e,t.state,t.location,t.replace);const r=Lp({location:"",base:e,go:function(e,t=!0){t||n.pauseListeners(),history.go(e)},createHref:bf.bind(null,e)},t,n);return Object.defineProperty(r,"location",{enumerable:!0,get:()=>t.location.value}),Object.defineProperty(r,"state",{enumerable:!0,get:()=>t.state.value}),r}function Bf(e){return"string"==typeof e||"symbol"==typeof e}const _f=Symbol("");var Tf;!function(e){e[e.aborted=4]="aborted",e[e.cancelled=8]="cancelled",e[e.duplicated=16]="duplicated"}(Tf||(Tf={}));function Ef(e,t){return Lp(new Error,{type:e,[_f]:!0},t)}function Mf(e,t){return e instanceof Error&&_f in e&&(null==t||!!(e.type&t))}const Df="[^/]+?",Pf={sensitive:!1,strict:!1,start:!0,end:!0},Rf=/[.+*?^${}()[\]/\\]/g;function If(e,t){let n=0;for(;n<e.length&&n<t.length;){const r=t[n]-e[n];if(r)return r;n++}return e.length<t.length?1===e.length&&80===e[0]?-1:1:e.length>t.length?1===t.length&&80===t[0]?1:-1:0}function Lf(e,t){let n=0;const r=e.score,i=t.score;for(;n<r.length&&n<i.length;){const e=If(r[n],i[n]);if(e)return e;n++}if(1===Math.abs(i.length-r.length)){if(Nf(r))return 1;if(Nf(i))return-1}return i.length-r.length}function Nf(e){const t=e[e.length-1];return e.length>0&&t[t.length-1]<0}const Ff={type:0,value:""},Qf=/[a-zA-Z0-9_]/;function Vf(e,t,n){const r=function(e,t){const n=Lp({},Pf,t),r=[];let i=n.start?"^":"";const o=[];for(const t of e){const e=t.length?[]:[90];n.strict&&!t.length&&(i+="/");for(let r=0;r<t.length;r++){const s=t[r];let a=40+(n.sensitive?.25:0);if(0===s.type)r||(i+="/"),i+=s.value.replace(Rf,"\\$&"),a+=40;else if(1===s.type){const{value:e,repeatable:n,optional:l,regexp:c}=s;o.push({name:e,repeatable:n,optional:l});const h=c||Df;if(h!==Df){a+=10;try{new RegExp(`(${h})`)}catch(t){throw new Error(`Invalid custom RegExp for param "${e}" (${h}): `+t.message)}}let d=n?`((?:${h})(?:/(?:${h}))*)`:`(${h})`;r||(d=l&&t.length<2?`(?:/${d})`:"/"+d),l&&(d+="?"),i+=d,a+=20,l&&(a+=-8),n&&(a+=-20),".*"===h&&(a+=-50)}e.push(a)}r.push(e)}if(n.strict&&n.end){const e=r.length-1;r[e][r[e].length-1]+=.7000000000000001}n.strict||(i+="/?"),n.end?i+="$":n.strict&&!i.endsWith("/")&&(i+="(?:/|$)");const s=new RegExp(i,n.sensitive?"":"i");return{re:s,score:r,keys:o,parse:function(e){const t=e.match(s),n={};if(!t)return null;for(let e=1;e<t.length;e++){const r=t[e]||"",i=o[e-1];n[i.name]=r&&i.repeatable?r.split("/"):r}return n},stringify:function(t){let n="",r=!1;for(const i of e){r&&n.endsWith("/")||(n+="/"),r=!1;for(const e of i)if(0===e.type)n+=e.value;else if(1===e.type){const{value:o,repeatable:s,optional:a}=e,l=o in t?t[o]:"";if(Qp(l)&&!s)throw new Error(`Provided param "${o}" is an array but it is not repeatable (* or + modifiers)`);const c=Qp(l)?l.join("/"):l;if(!c){if(!a)throw new Error(`Missing required param "${o}"`);i.length<2&&(n.endsWith("/")?n=n.slice(0,-1):r=!0)}n+=c}}return n||"/"}}}(function(e){if(!e)return[[]];if("/"===e)return[[Ff]];if(!e.startsWith("/"))throw new Error(`Invalid path "${e}"`);function t(e){throw new Error(`ERR (${n})/"${c}": ${e}`)}let n=0,r=n;const i=[];let o;function s(){o&&i.push(o),o=[]}let a,l=0,c="",h="";function d(){c&&(0===n?o.push({type:0,value:c}):1===n||2===n||3===n?(o.length>1&&("*"===a||"+"===a)&&t(`A repeatable param (${c}) must be alone in its segment. eg: '/:ids+.`),o.push({type:1,value:c,regexp:h,repeatable:"*"===a||"+"===a,optional:"*"===a||"?"===a})):t("Invalid state to consume buffer"),c="")}function u(){c+=a}for(;l<e.length;)if(a=e[l++],"\\"!==a||2===n)switch(n){case 0:"/"===a?(c&&d(),s()):":"===a?(d(),n=1):u();break;case 4:u(),n=r;break;case 1:"("===a?n=2:Qf.test(a)?u():(d(),n=0,"*"!==a&&"?"!==a&&"+"!==a&&l--);break;case 2:")"===a?"\\"==h[h.length-1]?h=h.slice(0,-1)+a:n=3:h+=a;break;case 3:d(),n=0,"*"!==a&&"?"!==a&&"+"!==a&&l--,h="";break;default:t("Unknown state")}else r=n,n=4;return 2===n&&t(`Unfinished custom RegExp for param "${c}"`),d(),s(),i}(e.path),n);const i=Lp(r,{record:e,parent:t,children:[],alias:[]});return t&&!i.record.aliasOf==!t.record.aliasOf&&t.children.push(i),i}function zf(e,t){const n=[],r=new Map;function i(e,n,r){const a=!r,l=Hf(e);l.aliasOf=r&&r.record;const c=Uf(t,e),h=[l];if("alias"in e){const t="string"==typeof e.alias?[e.alias]:e.alias;for(const e of t)h.push(Hf(Lp({},l,{components:r?r.record.components:l.components,path:e,aliasOf:r?r.record:l})))}let d,u;for(const t of h){const{path:h}=t;if(n&&"/"!==h[0]){const e=n.record.path,r="/"===e[e.length-1]?"":"/";t.path=n.record.path+(h&&r+h)}if(d=Vf(t,n,c),r?r.alias.push(d):(u=u||d,u!==d&&u.alias.push(d),a&&e.name&&!qf(d)&&o(e.name)),Yf(d)&&s(d),l.children){const e=l.children;for(let t=0;t<e.length;t++)i(e[t],d,r&&r.children[t])}r=r||d}return u?()=>{o(u)}:Fp}function o(e){if(Bf(e)){const t=r.get(e);t&&(r.delete(e),n.splice(n.indexOf(t),1),t.children.forEach(o),t.alias.forEach(o))}else{const t=n.indexOf(e);t>-1&&(n.splice(t,1),e.record.name&&r.delete(e.record.name),e.children.forEach(o),e.alias.forEach(o))}}function s(e){const t=function(e,t){let n=0,r=t.length;for(;n!==r;){const i=n+r>>1;Lf(e,t[i])<0?r=i:n=i+1}const i=function(e){let t=e;for(;t=t.parent;)if(Yf(t)&&0===Lf(e,t))return t;return}(e);i&&(r=t.lastIndexOf(i,r-1));return r}(e,n);n.splice(t,0,e),e.record.name&&!qf(e)&&r.set(e.record.name,e)}return t=Uf({strict:!1,end:!0,sensitive:!1},t),e.forEach(e=>i(e)),{addRoute:i,resolve:function(e,t){let i,o,s,a={};if("name"in e&&e.name){if(i=r.get(e.name),!i)throw Ef(1,{location:e});0,s=i.record.name,a=Lp($f(t.params,i.keys.filter(e=>!e.optional).concat(i.parent?i.parent.keys.filter(e=>e.optional):[]).map(e=>e.name)),e.params&&$f(e.params,i.keys.map(e=>e.name))),o=i.stringify(a)}else if(null!=e.path)o=e.path,i=n.find(e=>e.re.test(o)),i&&(a=i.parse(o),s=i.record.name);else{if(i=t.name?r.get(t.name):n.find(e=>e.re.test(t.path)),!i)throw Ef(1,{location:e,currentLocation:t});s=i.record.name,a=Lp({},t.params,e.params),o=i.stringify(a)}const l=[];let c=i;for(;c;)l.unshift(c.record),c=c.parent;return{name:s,path:o,params:a,matched:l,meta:Wf(l)}},removeRoute:o,clearRoutes:function(){n.length=0,r.clear()},getRoutes:function(){return n},getRecordMatcher:function(e){return r.get(e)}}}function $f(e,t){const n={};for(const r of t)r in e&&(n[r]=e[r]);return n}function Hf(e){const t={path:e.path,redirect:e.redirect,name:e.name,meta:e.meta||{},aliasOf:e.aliasOf,beforeEnter:e.beforeEnter,props:jf(e),children:e.children||[],instances:{},leaveGuards:new Set,updateGuards:new Set,enterCallbacks:{},components:"components"in e?e.components||null:e.component&&{default:e.component}};return Object.defineProperty(t,"mods",{value:{}}),t}function jf(e){const t={},n=e.props||!1;if("component"in e)t.default=n;else for(const r in e.components)t[r]="object"==typeof n?n[r]:n;return t}function qf(e){for(;e;){if(e.record.aliasOf)return!0;e=e.parent}return!1}function Wf(e){return e.reduce((e,t)=>Lp(e,t.meta),{})}function Uf(e,t){const n={};for(const r in e)n[r]=r in t?t[r]:e[r];return n}function Yf({record:e}){return!!(e.name||e.components&&Object.keys(e.components).length||e.redirect)}function Gf(e){const t={};if(""===e||"?"===e)return t;const n=("?"===e[0]?e.slice(1):e).split("&");for(let e=0;e<n.length;++e){const r=n[e].replace(qp," "),i=r.indexOf("="),o=of(i<0?r:r.slice(0,i)),s=i<0?null:of(r.slice(i+1));if(o in t){let e=t[o];Qp(e)||(e=t[o]=[e]),e.push(s)}else t[o]=s}return t}function Xf(e){let t="";for(let n in e){const r=e[n];if(n=nf(n),null==r){void 0!==r&&(t+=(t.length?"&":"")+n);continue}(Qp(r)?r.map(e=>e&&tf(e)):[r&&tf(r)]).forEach(e=>{void 0!==e&&(t+=(t.length?"&":"")+n,null!=e&&(t+="="+e))})}return t}function Jf(e){const t={};for(const n in e){const r=e[n];void 0!==r&&(t[n]=Qp(r)?r.map(e=>null==e?null:""+e):null==r?r:""+r)}return t}const Kf=Symbol(""),Zf=Symbol(""),eg=Symbol(""),tg=Symbol(""),ng=Symbol("");function rg(){let e=[];return{add:function(t){return e.push(t),()=>{const n=e.indexOf(t);n>-1&&e.splice(n,1)}},list:()=>e.slice(),reset:function(){e=[]}}}function ig(e,t,n){const r=()=>{e[t].delete(n)};wi(r),ci(r),li(()=>{e[t].add(n)}),e[t].add(n)}function og(e){const t=xo(Kf,{}).value;t&&ig(t,"leaveGuards",e)}function sg(e,t,n,r,i,o=e=>e()){const s=r&&(r.enterCallbacks[i]=r.enterCallbacks[i]||[]);return()=>new Promise((a,l)=>{const c=e=>{var o;!1===e?l(Ef(4,{from:n,to:t})):e instanceof Error?l(e):"string"==typeof(o=e)||o&&"object"==typeof o?l(Ef(2,{from:t,to:e})):(s&&r.enterCallbacks[i]===s&&"function"==typeof e&&s.push(e),a())},h=o(()=>e.call(r&&r.instances[i],t,n,c));let d=Promise.resolve(h);e.length<3&&(d=d.then(c)),d.catch(e=>l(e))})}function ag(e,t,n,r,i=e=>e()){const o=[];for(const s of e){0;for(const e in s.components){let a=s.components[e];if("beforeRouteEnter"===t||s.instances[e])if(Rp(a)){const l=(a.__vccOpts||a)[t];l&&o.push(sg(l,n,r,s,e,i))}else{let l=a();0,o.push(()=>l.then(o=>{if(!o)throw new Error(`Couldn't resolve component "${e}" at "${s.path}"`);const a=Ip(o)?o.default:o;s.mods[e]=o,s.components[e]=a;const l=(a.__vccOpts||a)[t];return l&&sg(l,n,r,s,e,i)()}))}}}return o}function lg(e){const t=xo(eg),n=xo(tg);const r=Ea(()=>{const n=Kt(e.to);return t.resolve(n)}),i=Ea(()=>{const{matched:e}=r.value,{length:t}=e,i=e[t-1],o=n.matched;if(!i||!o.length)return-1;const s=o.findIndex(cf.bind(null,i));if(s>-1)return s;const a=dg(e[t-2]);return t>1&&dg(i)===a&&o[o.length-1].path!==a?o.findIndex(cf.bind(null,e[t-2])):s}),o=Ea(()=>i.value>-1&&function(e,t){for(const n in t){const r=t[n],i=e[n];if("string"==typeof r){if(r!==i)return!1}else if(!Qp(i)||i.length!==r.length||r.some((e,t)=>e!==i[t]))return!1}return!0}(n.params,r.value.params)),s=Ea(()=>i.value>-1&&i.value===n.matched.length-1&&hf(n.params,r.value.params));return{route:r,href:Ea(()=>r.value.href),isActive:o,isExactActive:s,navigate:function(n={}){if(function(e){if(e.metaKey||e.altKey||e.ctrlKey||e.shiftKey)return;if(e.defaultPrevented)return;if(void 0!==e.button&&0!==e.button)return;if(e.currentTarget&&e.currentTarget.getAttribute){const t=e.currentTarget.getAttribute("target");if(/\b_blank\b/i.test(t))return}e.preventDefault&&e.preventDefault();return!0}(n)){const n=t[Kt(e.replace)?"replace":"push"](Kt(e.to)).catch(Fp);return e.viewTransition&&"undefined"!=typeof document&&"startViewTransition"in document&&document.startViewTransition(()=>n),n}return Promise.resolve()}}}const cg=Er({name:"RouterLink",compatConfig:{MODE:3},props:{to:{type:[String,Object],required:!0},replace:Boolean,activeClass:String,exactActiveClass:String,custom:Boolean,ariaCurrentValue:{type:String,default:"page"},viewTransition:Boolean},useLink:lg,setup(e,{slots:t}){const n=Pt(lg(e)),{options:r}=xo(eg),i=Ea(()=>({[ug(e.activeClass,r.linkActiveClass,"router-link-active")]:n.isActive,[ug(e.exactActiveClass,r.linkExactActiveClass,"router-link-exact-active")]:n.isExactActive}));return()=>{const r=t.default&&(1===(o=t.default(n)).length?o[0]:o);var o;return e.custom?r:Ma("a",{"aria-current":n.isExactActive?e.ariaCurrentValue:null,href:n.href,onClick:n.navigate,class:i.value},r)}}}),hg=cg;function dg(e){return e?e.aliasOf?e.aliasOf.path:e.path:""}const ug=(e,t,n)=>null!=e?e:null!=t?t:n,pg=Er({name:"RouterView",inheritAttrs:!1,props:{name:{type:String,default:"default"},route:Object},compatConfig:{MODE:3},setup(e,{attrs:t,slots:n}){const r=xo(ng),i=Ea(()=>e.route||r.value),o=xo(Zf,0),s=Ea(()=>{let e=Kt(o);const{matched:t}=i.value;let n;for(;(n=t[e])&&!n.components;)e++;return e}),a=Ea(()=>i.value.matched[s.value]);Co(Zf,Ea(()=>s.value+1)),Co(Kf,a),Co(ng,i);const l=Ut();return ns(()=>[l.value,a.value,e.name],([e,t,n],[r,i,o])=>{t&&(t.instances[n]=e,i&&i!==t&&e&&e===r&&(t.leaveGuards.size||(t.leaveGuards=i.leaveGuards),t.updateGuards.size||(t.updateGuards=i.updateGuards))),!e||!t||i&&cf(t,i)&&r||(t.enterCallbacks[n]||[]).forEach(t=>t(e))},{flush:"post"}),()=>{const r=i.value,o=e.name,s=a.value,c=s&&s.components[o];if(!c)return fg(n.default,{Component:c,route:r});const h=s.props[o],d=h?!0===h?r.params:"function"==typeof h?h(r):h:null,u=Ma(c,Lp({},d,t,{onVnodeUnmounted:e=>{e.component.isUnmounted&&(s.instances[o]=null)},ref:l}));return fg(n.default,{Component:u,route:r})||u}}});function fg(e,t){if(!e)return null;const n=e(t);return 1===n.length?n[0]:n}const gg=pg;var mg="floater",vg="shortcode",bg="menu",Ag="tpLanguages";function yg(e){var t=xo(e);if(!t)throw new Error('Config scope "'.concat(e,'" not provided.'));return t}function wg(){var e=xo(Ag);if(!e)throw new Error("Languages not provided—did you forget to call provideSwitcherConfig?");return e}var Cg=n(72),xg=n.n(Cg),kg=n(877),Sg={insert:"head",singleton:!1};xg()(kg.A,Sg);kg.A.locals;function Og(e){return Og="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},Og(e)}var Bg=/^\s+/,_g=/\s+$/;function Tg(e,t){if(t=t||{},(e=e||"")instanceof Tg)return e;if(!(this instanceof Tg))return new Tg(e,t);var n=function(e){var t={r:0,g:0,b:0},n=1,r=null,i=null,o=null,s=!1,a=!1;return"string"==typeof e&&(e=function(e){e=e.replace(Bg,"").replace(_g,"").toLowerCase();var t,n=!1;if(Wg[e])e=Wg[e],n=!0;else if("transparent"==e)return{r:0,g:0,b:0,a:0,format:"name"};return(t=om.rgb.exec(e))?{r:t[1],g:t[2],b:t[3]}:(t=om.rgba.exec(e))?{r:t[1],g:t[2],b:t[3],a:t[4]}:(t=om.hsl.exec(e))?{h:t[1],s:t[2],l:t[3]}:(t=om.hsla.exec(e))?{h:t[1],s:t[2],l:t[3],a:t[4]}:(t=om.hsv.exec(e))?{h:t[1],s:t[2],v:t[3]}:(t=om.hsva.exec(e))?{h:t[1],s:t[2],v:t[3],a:t[4]}:(t=om.hex8.exec(e))?{r:Jg(t[1]),g:Jg(t[2]),b:Jg(t[3]),a:tm(t[4]),format:n?"name":"hex8"}:(t=om.hex6.exec(e))?{r:Jg(t[1]),g:Jg(t[2]),b:Jg(t[3]),format:n?"name":"hex"}:(t=om.hex4.exec(e))?{r:Jg(t[1]+""+t[1]),g:Jg(t[2]+""+t[2]),b:Jg(t[3]+""+t[3]),a:tm(t[4]+""+t[4]),format:n?"name":"hex8"}:!!(t=om.hex3.exec(e))&&{r:Jg(t[1]+""+t[1]),g:Jg(t[2]+""+t[2]),b:Jg(t[3]+""+t[3]),format:n?"name":"hex"}}(e)),"object"==Og(e)&&(sm(e.r)&&sm(e.g)&&sm(e.b)?(t=function(e,t,n){return{r:255*Gg(e,255),g:255*Gg(t,255),b:255*Gg(n,255)}}(e.r,e.g,e.b),s=!0,a="%"===String(e.r).substr(-1)?"prgb":"rgb"):sm(e.h)&&sm(e.s)&&sm(e.v)?(r=Zg(e.s),i=Zg(e.v),t=function(e,t,n){e=6*Gg(e,360),t=Gg(t,100),n=Gg(n,100);var r=Math.floor(e),i=e-r,o=n*(1-t),s=n*(1-i*t),a=n*(1-(1-i)*t),l=r%6,c=[n,s,o,o,a,n][l],h=[a,n,n,s,o,o][l],d=[o,o,a,n,n,s][l];return{r:255*c,g:255*h,b:255*d}}(e.h,r,i),s=!0,a="hsv"):sm(e.h)&&sm(e.s)&&sm(e.l)&&(r=Zg(e.s),o=Zg(e.l),t=function(e,t,n){var r,i,o;function s(e,t,n){return n<0&&(n+=1),n>1&&(n-=1),n<1/6?e+6*(t-e)*n:n<.5?t:n<2/3?e+(t-e)*(2/3-n)*6:e}if(e=Gg(e,360),t=Gg(t,100),n=Gg(n,100),0===t)r=i=o=n;else{var a=n<.5?n*(1+t):n+t-n*t,l=2*n-a;r=s(l,a,e+1/3),i=s(l,a,e),o=s(l,a,e-1/3)}return{r:255*r,g:255*i,b:255*o}}(e.h,r,o),s=!0,a="hsl"),e.hasOwnProperty("a")&&(n=e.a)),n=Yg(n),{ok:s,format:e.format||a,r:Math.min(255,Math.max(t.r,0)),g:Math.min(255,Math.max(t.g,0)),b:Math.min(255,Math.max(t.b,0)),a:n}}(e);this._originalInput=e,this._r=n.r,this._g=n.g,this._b=n.b,this._a=n.a,this._roundA=Math.round(100*this._a)/100,this._format=t.format||n.format,this._gradientType=t.gradientType,this._r<1&&(this._r=Math.round(this._r)),this._g<1&&(this._g=Math.round(this._g)),this._b<1&&(this._b=Math.round(this._b)),this._ok=n.ok}function Eg(e,t,n){e=Gg(e,255),t=Gg(t,255),n=Gg(n,255);var r,i,o=Math.max(e,t,n),s=Math.min(e,t,n),a=(o+s)/2;if(o==s)r=i=0;else{var l=o-s;switch(i=a>.5?l/(2-o-s):l/(o+s),o){case e:r=(t-n)/l+(t<n?6:0);break;case t:r=(n-e)/l+2;break;case n:r=(e-t)/l+4}r/=6}return{h:r,s:i,l:a}}function Mg(e,t,n){e=Gg(e,255),t=Gg(t,255),n=Gg(n,255);var r,i,o=Math.max(e,t,n),s=Math.min(e,t,n),a=o,l=o-s;if(i=0===o?0:l/o,o==s)r=0;else{switch(o){case e:r=(t-n)/l+(t<n?6:0);break;case t:r=(n-e)/l+2;break;case n:r=(e-t)/l+4}r/=6}return{h:r,s:i,v:a}}function Dg(e,t,n,r){var i=[Kg(Math.round(e).toString(16)),Kg(Math.round(t).toString(16)),Kg(Math.round(n).toString(16))];return r&&i[0].charAt(0)==i[0].charAt(1)&&i[1].charAt(0)==i[1].charAt(1)&&i[2].charAt(0)==i[2].charAt(1)?i[0].charAt(0)+i[1].charAt(0)+i[2].charAt(0):i.join("")}function Pg(e,t,n,r){return[Kg(em(r)),Kg(Math.round(e).toString(16)),Kg(Math.round(t).toString(16)),Kg(Math.round(n).toString(16))].join("")}function Rg(e,t){t=0===t?0:t||10;var n=Tg(e).toHsl();return n.s-=t/100,n.s=Xg(n.s),Tg(n)}function Ig(e,t){t=0===t?0:t||10;var n=Tg(e).toHsl();return n.s+=t/100,n.s=Xg(n.s),Tg(n)}function Lg(e){return Tg(e).desaturate(100)}function Ng(e,t){t=0===t?0:t||10;var n=Tg(e).toHsl();return n.l+=t/100,n.l=Xg(n.l),Tg(n)}function Fg(e,t){t=0===t?0:t||10;var n=Tg(e).toRgb();return n.r=Math.max(0,Math.min(255,n.r-Math.round(-t/100*255))),n.g=Math.max(0,Math.min(255,n.g-Math.round(-t/100*255))),n.b=Math.max(0,Math.min(255,n.b-Math.round(-t/100*255))),Tg(n)}function Qg(e,t){t=0===t?0:t||10;var n=Tg(e).toHsl();return n.l-=t/100,n.l=Xg(n.l),Tg(n)}function Vg(e,t){var n=Tg(e).toHsl(),r=(n.h+t)%360;return n.h=r<0?360+r:r,Tg(n)}function zg(e){var t=Tg(e).toHsl();return t.h=(t.h+180)%360,Tg(t)}function $g(e,t){if(isNaN(t)||t<=0)throw new Error("Argument to polyad must be a positive number");for(var n=Tg(e).toHsl(),r=[Tg(e)],i=360/t,o=1;o<t;o++)r.push(Tg({h:(n.h+o*i)%360,s:n.s,l:n.l}));return r}function Hg(e){var t=Tg(e).toHsl(),n=t.h;return[Tg(e),Tg({h:(n+72)%360,s:t.s,l:t.l}),Tg({h:(n+216)%360,s:t.s,l:t.l})]}function jg(e,t,n){t=t||6,n=n||30;var r=Tg(e).toHsl(),i=360/n,o=[Tg(e)];for(r.h=(r.h-(i*t>>1)+720)%360;--t;)r.h=(r.h+i)%360,o.push(Tg(r));return o}function qg(e,t){t=t||6;for(var n=Tg(e).toHsv(),r=n.h,i=n.s,o=n.v,s=[],a=1/t;t--;)s.push(Tg({h:r,s:i,v:o})),o=(o+a)%1;return s}Tg.prototype={isDark:function(){return this.getBrightness()<128},isLight:function(){return!this.isDark()},isValid:function(){return this._ok},getOriginalInput:function(){return this._originalInput},getFormat:function(){return this._format},getAlpha:function(){return this._a},getBrightness:function(){var e=this.toRgb();return(299*e.r+587*e.g+114*e.b)/1e3},getLuminance:function(){var e,t,n,r=this.toRgb();return e=r.r/255,t=r.g/255,n=r.b/255,.2126*(e<=.03928?e/12.92:Math.pow((e+.055)/1.055,2.4))+.7152*(t<=.03928?t/12.92:Math.pow((t+.055)/1.055,2.4))+.0722*(n<=.03928?n/12.92:Math.pow((n+.055)/1.055,2.4))},setAlpha:function(e){return this._a=Yg(e),this._roundA=Math.round(100*this._a)/100,this},toHsv:function(){var e=Mg(this._r,this._g,this._b);return{h:360*e.h,s:e.s,v:e.v,a:this._a}},toHsvString:function(){var e=Mg(this._r,this._g,this._b),t=Math.round(360*e.h),n=Math.round(100*e.s),r=Math.round(100*e.v);return 1==this._a?"hsv("+t+", "+n+"%, "+r+"%)":"hsva("+t+", "+n+"%, "+r+"%, "+this._roundA+")"},toHsl:function(){var e=Eg(this._r,this._g,this._b);return{h:360*e.h,s:e.s,l:e.l,a:this._a}},toHslString:function(){var e=Eg(this._r,this._g,this._b),t=Math.round(360*e.h),n=Math.round(100*e.s),r=Math.round(100*e.l);return 1==this._a?"hsl("+t+", "+n+"%, "+r+"%)":"hsla("+t+", "+n+"%, "+r+"%, "+this._roundA+")"},toHex:function(e){return Dg(this._r,this._g,this._b,e)},toHexString:function(e){return"#"+this.toHex(e)},toHex8:function(e){return function(e,t,n,r,i){var o=[Kg(Math.round(e).toString(16)),Kg(Math.round(t).toString(16)),Kg(Math.round(n).toString(16)),Kg(em(r))];return i&&o[0].charAt(0)==o[0].charAt(1)&&o[1].charAt(0)==o[1].charAt(1)&&o[2].charAt(0)==o[2].charAt(1)&&o[3].charAt(0)==o[3].charAt(1)?o[0].charAt(0)+o[1].charAt(0)+o[2].charAt(0)+o[3].charAt(0):o.join("")}(this._r,this._g,this._b,this._a,e)},toHex8String:function(e){return"#"+this.toHex8(e)},toRgb:function(){return{r:Math.round(this._r),g:Math.round(this._g),b:Math.round(this._b),a:this._a}},toRgbString:function(){return 1==this._a?"rgb("+Math.round(this._r)+", "+Math.round(this._g)+", "+Math.round(this._b)+")":"rgba("+Math.round(this._r)+", "+Math.round(this._g)+", "+Math.round(this._b)+", "+this._roundA+")"},toPercentageRgb:function(){return{r:Math.round(100*Gg(this._r,255))+"%",g:Math.round(100*Gg(this._g,255))+"%",b:Math.round(100*Gg(this._b,255))+"%",a:this._a}},toPercentageRgbString:function(){return 1==this._a?"rgb("+Math.round(100*Gg(this._r,255))+"%, "+Math.round(100*Gg(this._g,255))+"%, "+Math.round(100*Gg(this._b,255))+"%)":"rgba("+Math.round(100*Gg(this._r,255))+"%, "+Math.round(100*Gg(this._g,255))+"%, "+Math.round(100*Gg(this._b,255))+"%, "+this._roundA+")"},toName:function(){return 0===this._a?"transparent":!(this._a<1)&&(Ug[Dg(this._r,this._g,this._b,!0)]||!1)},toFilter:function(e){var t="#"+Pg(this._r,this._g,this._b,this._a),n=t,r=this._gradientType?"GradientType = 1, ":"";if(e){var i=Tg(e);n="#"+Pg(i._r,i._g,i._b,i._a)}return"progid:DXImageTransform.Microsoft.gradient("+r+"startColorstr="+t+",endColorstr="+n+")"},toString:function(e){var t=!!e;e=e||this._format;var n=!1,r=this._a<1&&this._a>=0;return!t&&r&&("hex"===e||"hex6"===e||"hex3"===e||"hex4"===e||"hex8"===e||"name"===e)?"name"===e&&0===this._a?this.toName():this.toRgbString():("rgb"===e&&(n=this.toRgbString()),"prgb"===e&&(n=this.toPercentageRgbString()),("hex"===e||"hex6"===e)&&(n=this.toHexString()),"hex3"===e&&(n=this.toHexString(!0)),"hex4"===e&&(n=this.toHex8String(!0)),"hex8"===e&&(n=this.toHex8String()),"name"===e&&(n=this.toName()),"hsl"===e&&(n=this.toHslString()),"hsv"===e&&(n=this.toHsvString()),n||this.toHexString())},clone:function(){return Tg(this.toString())},_applyModification:function(e,t){var n=e.apply(null,[this].concat([].slice.call(t)));return this._r=n._r,this._g=n._g,this._b=n._b,this.setAlpha(n._a),this},lighten:function(){return this._applyModification(Ng,arguments)},brighten:function(){return this._applyModification(Fg,arguments)},darken:function(){return this._applyModification(Qg,arguments)},desaturate:function(){return this._applyModification(Rg,arguments)},saturate:function(){return this._applyModification(Ig,arguments)},greyscale:function(){return this._applyModification(Lg,arguments)},spin:function(){return this._applyModification(Vg,arguments)},_applyCombination:function(e,t){return e.apply(null,[this].concat([].slice.call(t)))},analogous:function(){return this._applyCombination(jg,arguments)},complement:function(){return this._applyCombination(zg,arguments)},monochromatic:function(){return this._applyCombination(qg,arguments)},splitcomplement:function(){return this._applyCombination(Hg,arguments)},triad:function(){return this._applyCombination($g,[3])},tetrad:function(){return this._applyCombination($g,[4])}},Tg.fromRatio=function(e,t){if("object"==Og(e)){var n={};for(var r in e)e.hasOwnProperty(r)&&(n[r]="a"===r?e[r]:Zg(e[r]));e=n}return Tg(e,t)},Tg.equals=function(e,t){return!(!e||!t)&&Tg(e).toRgbString()==Tg(t).toRgbString()},Tg.random=function(){return Tg.fromRatio({r:Math.random(),g:Math.random(),b:Math.random()})},Tg.mix=function(e,t,n){n=0===n?0:n||50;var r=Tg(e).toRgb(),i=Tg(t).toRgb(),o=n/100;return Tg({r:(i.r-r.r)*o+r.r,g:(i.g-r.g)*o+r.g,b:(i.b-r.b)*o+r.b,a:(i.a-r.a)*o+r.a})},Tg.readability=function(e,t){var n=Tg(e),r=Tg(t);return(Math.max(n.getLuminance(),r.getLuminance())+.05)/(Math.min(n.getLuminance(),r.getLuminance())+.05)},Tg.isReadable=function(e,t,n){var r,i,o=Tg.readability(e,t);switch(i=!1,r=function(e){var t,n;return e=e||{level:"AA",size:"small"},t=(e.level||"AA").toUpperCase(),n=(e.size||"small").toLowerCase(),"AA"!==t&&"AAA"!==t&&(t="AA"),"small"!==n&&"large"!==n&&(n="small"),{level:t,size:n}}(n),r.level+r.size){case"AAsmall":case"AAAlarge":i=o>=4.5;break;case"AAlarge":i=o>=3;break;case"AAAsmall":i=o>=7}return i},Tg.mostReadable=function(e,t,n){var r,i,o,s,a=null,l=0;i=(n=n||{}).includeFallbackColors,o=n.level,s=n.size;for(var c=0;c<t.length;c++)(r=Tg.readability(e,t[c]))>l&&(l=r,a=Tg(t[c]));return Tg.isReadable(e,a,{level:o,size:s})||!i?a:(n.includeFallbackColors=!1,Tg.mostReadable(e,["#fff","#000"],n))};var Wg=Tg.names={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"0ff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000",blanchedalmond:"ffebcd",blue:"00f",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",burntsienna:"ea7e5d",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"0ff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"f0f",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"789",lightslategrey:"789",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"0f0",limegreen:"32cd32",linen:"faf0e6",magenta:"f0f",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"663399",red:"f00",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"fff",whitesmoke:"f5f5f5",yellow:"ff0",yellowgreen:"9acd32"},Ug=Tg.hexNames=function(e){var t={};for(var n in e)e.hasOwnProperty(n)&&(t[e[n]]=n);return t}(Wg);function Yg(e){return e=parseFloat(e),(isNaN(e)||e<0||e>1)&&(e=1),e}function Gg(e,t){(function(e){return"string"==typeof e&&-1!=e.indexOf(".")&&1===parseFloat(e)})(e)&&(e="100%");var n=function(e){return"string"==typeof e&&-1!=e.indexOf("%")}(e);return e=Math.min(t,Math.max(0,parseFloat(e))),n&&(e=parseInt(e*t,10)/100),Math.abs(e-t)<1e-6?1:e%t/parseFloat(t)}function Xg(e){return Math.min(1,Math.max(0,e))}function Jg(e){return parseInt(e,16)}function Kg(e){return 1==e.length?"0"+e:""+e}function Zg(e){return e<=1&&(e=100*e+"%"),e}function em(e){return Math.round(255*parseFloat(e)).toString(16)}function tm(e){return Jg(e)/255}var nm,rm,im,om=(rm="[\\s|\\(]+("+(nm="(?:[-\\+]?\\d*\\.\\d+%?)|(?:[-\\+]?\\d+%?)")+")[,|\\s]+("+nm+")[,|\\s]+("+nm+")\\s*\\)?",im="[\\s|\\(]+("+nm+")[,|\\s]+("+nm+")[,|\\s]+("+nm+")[,|\\s]+("+nm+")\\s*\\)?",{CSS_UNIT:new RegExp(nm),rgb:new RegExp("rgb"+rm),rgba:new RegExp("rgba"+im),hsl:new RegExp("hsl"+rm),hsla:new RegExp("hsla"+im),hsv:new RegExp("hsv"+rm),hsva:new RegExp("hsva"+im),hex3:/^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,hex6:/^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,hex4:/^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,hex8:/^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/});function sm(e){return!!om.CSS_UNIT.exec(e)}const am=(e,t,n=!1)=>{if(!n){let n=t;"hex"===t&&e.getAlpha()<1&&(n="hex8");let r=e.toString(n);try{r=JSON.parse(r)}catch{}return r}switch(t){case"rgb":return e.toRgb();case"prgb":return e.toPercentageRgb();case"hsl":return e.toHsl();case"hsv":return e.toHsv();default:return null}},lm=(e,t)=>!!(Object.prototype.hasOwnProperty.call(e,t)&&typeof e[t]<"u"),cm=e=>typeof e>"u",hm=["update:tinyColor","update:modelValue","input"];function dm(e,t,n){let r,i;const o=Ea({get:()=>{const{modelValue:t,tinyColor:n,value:o}=e,s=n??t??o;return cm(i)&&(cm(o)||(i=Tg(o).getFormat()),cm(t)||(i=Tg(t).getFormat())),cm(r)&&("object"==typeof o&&!(o instanceof Tg)&&(r=!0),"object"==typeof t&&(r=!0)),Tg(s)},set:e=>{s(e)}}),s=n=>{const o=Tg(n);if(lm(e,"tinyColor")&&t("update:tinyColor",o),lm(e,"modelValue")){const e=am(o,i,r);t("update:modelValue",e)}if(lm(e,"value")){const e=am(o,i,r);t("input",e)}};return o}const um=e=>{const t={x:0,y:0};return e instanceof MouseEvent&&(t.x=e.pageX,t.y=e.pageY),typeof TouchEvent<"u"&&e instanceof TouchEvent&&(t.x=e.touches?.[0]?e.touches[0].pageX:e.changedTouches?.[0]?e.changedTouches[0].pageX:0,t.y=e.touches?.[0]?e.touches[0].pageY:e.changedTouches?.[0]?e.changedTouches[0].pageY:0),t},pm=e=>{const{x:t,y:n}={x:window.scrollX||window.pageXOffset||document.documentElement.scrollLeft||0,y:window.scrollY||window.pageYOffset||document.documentElement.scrollTop||0},r=e.getBoundingClientRect();return{x:r.left+t,y:r.top+n}},fm=e=>"ArrowUp"===e.code||38===e.keyCode?"up":"ArrowDown"===e.code||40===e.keyCode?"down":"ArrowLeft"===e.code||37===e.keyCode?"left":"ArrowRight"===e.code||39===e.keyCode?"right":null;function gm(e,t,n){return Math.min(Math.max(e,t),n)}const mm=(e,t=20)=>{let n,r,i;return(...o)=>{n?(clearTimeout(r),r=setTimeout(()=>{Date.now()-i>=t&&(e(...o),i=Date.now())},Math.max(t-(Date.now()-i),0))):(e(...o),i=Date.now(),n=!0)}},vm=["aria-valuetext"],bm=Er({__name:"SaturationSlider",props:{hue:{},tinyColor:{},modelValue:{},value:{}},emits:["change"].concat(hm),setup(e,{emit:t}){const n=t,r=e,i=Ut(0),o=dm(r,n),s=Ea(()=>o.value.toHsv()),a=Ea(()=>r.hue??s.value.h),l=Ea(()=>`hsl(${a.value}, 100%, 50%)`),c=Ea(()=>-100*s.value.v+1+100+"%"),h=Ea(()=>s.value.v<=.01?100*i.value+"%":100*s.value.s+"%"),d=Ut(null);function u(e){o.value=e}const p=mm(function(e){const t=d.value;if(!t)return;const n=t.clientWidth,r=t.clientHeight,{x:o,y:l}=pm(t),{x:c,y:h}=um(e),p=gm(c-o,0,n),f=gm(h-l,0,r),g=p/n,m=gm(1-f/r,0,1);i.value=g;let v=Math.round(100*g),b=Math.round(100*m);1===v&&(v=.01),1===b&&(b=.01),u({h:a.value,s:v,v:b,a:s.value.a})},20);function f(e){e.preventDefault(),e.type.startsWith("mouse")?(window.addEventListener("mousemove",p),window.addEventListener("mouseup",p),window.addEventListener("mouseup",g)):e.type.startsWith("touch")&&(window.addEventListener("touchmove",p),window.addEventListener("touchend",p),window.addEventListener("touchend",g))}function g(){m()}function m(){window.removeEventListener("mousemove",p),window.removeEventListener("mouseup",p),window.removeEventListener("mouseup",g),window.removeEventListener("touchmove",p),window.removeEventListener("touchend",p),window.removeEventListener("touchend",g)}function v(e){switch(e.preventDefault(),fm(e)){case"left":{const e=s.value.s-.01;u({...s.value,s:e>=0?e:0});break}case"right":{const e=s.value.s+.01;u({...s.value,s:e>1?1:e});break}case"up":{const e=s.value.v+.01;u({...s.value,v:e>1?1:e});break}case"down":{const e=s.value.v-.01;u({...s.value,v:e<0?0:e});break}}}return wi(()=>{m()}),(e,t)=>(Ds(),Fs("div",{class:"vc-saturation-slider bg",style:W({background:l.value}),ref_key:"containerRef",ref:d,onMousedown:f,onTouchstart:f,role:"application","aria-label":"Saturation and brightness picker"},[t[1]||(t[1]=qs("div",{class:"bg white"},null,-1)),t[2]||(t[2]=qs("div",{class:"bg black"},null,-1)),qs("div",{class:"picker-wrap",style:W({top:c.value,left:h.value}),role:"slider",tabindex:"0","aria-valuemin":"0","aria-valuemax":"1","aria-label":"press arrow to change saturation or brightness","aria-valuenow":"?","aria-valuetext":`saturation: ${s.value.s.toFixed(0)}%, brightness: ${s.value.v.toFixed(0)}%`,onKeydown:v},t[0]||(t[0]=[qs("div",{class:"picker"},null,-1)]),44,vm)],36))}}),Am=(e,t)=>{const n=e.__vccOpts||e;for(const[e,r]of t)n[e]=r;return n},ym=Am(bm,[["__scopeId","data-v-4d048d6e"]]),wm=e=>typeof e<"u",Cm={class:"vc-base-slider"},xm={key:0,class:"background"},km=["aria-label","aria-valuemax","aria-valuenow"],Sm=Er({__name:"BaseSlider",props:{direction:{default:"horizontal"},modelValue:{default:0},value:{default:0},max:{default:100},step:{},ariaLabel:{default:"slider"}},emits:["input","update:modelValue"],setup(e,{emit:t}){const n=e,r=t,i=Ea(()=>n.modelValue??n.value),o=Ea(()=>{let e=i.value/n.max;return"vertical"===n.direction&&(e=1-e),100*e+"%"}),s=Ut(null);function a(e){wm(e)&&(r("input",e),r("update:modelValue",e))}function l(e){const{direction:t,max:r}=n,i=s.value;if(!i)return;const o=i.clientWidth,l=i.clientHeight,{x:c,y:h}=pm(i),{x:d,y:u}=um(e),p=d-c,f=u-h;let g;g="vertical"===t?f<0?r:f>l?0:(1-f/l)*r:p<0?0:p>o?r:p/o*r,a(g)}const c=mm(l);function h(e){l(e),e.type.startsWith("mouse")?(window.addEventListener("mousemove",c),window.addEventListener("mouseup",d)):(window.addEventListener("touchmove",c),window.addEventListener("touchend",d))}function d(){u()}function u(){window.removeEventListener("mousemove",c),window.removeEventListener("mouseup",d),window.removeEventListener("touchmove",c),window.removeEventListener("touchend",d)}function p(e){e.preventDefault();const{direction:t,max:r}=n,o=fm(e),s=n.step??r/100,l=i.value;let c;switch(o){case"left":if("horizontal"!==t)return;c=l-s<0?0:l-s;break;case"right":if("horizontal"!==t)return;c=l+s>r?r:l+s;break;case"down":if("vertical"!==t)return;c=l-s<0?0:l-s;break;case"up":if("vertical"!==t)return;c=l+s>r?r:l+s}a(c)}return wi(()=>{u()}),(e,t)=>(Ds(),Fs("div",Cm,[e.$slots.background?(Ds(),Fs("div",xm,[Li(e.$slots,"background",{},void 0,!0)])):Ks("",!0),qs("div",{class:J({slider:!0,horizontal:"horizontal"===e.direction,vertical:"vertical"===e.direction}),ref_key:"containerRef",ref:s,onMousedown:h,onTouchstart:h,role:"slider","aria-label":e.ariaLabel,"aria-valuemax":e.max,"aria-valuemin":"0","aria-valuenow":i.value.toFixed(1),tabindex:"0",onKeydown:p},[qs("div",{class:"picker-wrap",style:W({left:"horizontal"===e.direction?o.value:0,top:"vertical"===e.direction?o.value:0}),role:"presentation"},[Li(e.$slots,"picker",{},()=>[t[0]||(t[0]=qs("div",{class:"picker"},null,-1))],!0)],4)],42,km)]))}}),Om=Am(Sm,[["__scopeId","data-v-972b0fad"]]),Bm=Er({__name:"HueSlider",props:{direction:{default:"horizontal"},modelValue:{default:0}},emits:["update:modelValue"],setup(e,{emit:t}){wl(e=>({"2f44f39d":i.value}));const n=e,r=t,i=Ea(()=>`linear-gradient(to ${"horizontal"===n.direction?"right":"top"}, #f00 0%, #ff0 17%, #0f0 33%, #0ff 50%, #00f 67%, #f0f 83%, #f00 100%)`),o=Ea(()=>{const e=Number(n.modelValue);return Number.isNaN(e)?0:e}),s=Ut();ns(o,(e,t)=>{0!==e&&e-t>0&&(s.value="right"),0!==e&&e-t<0&&(s.value="left")});const a=Ea(()=>"vertical"===n.direction?0===o.value&&"right"===s.value?0:o.value:"horizontal"===n.direction?0===o.value&&"right"===s.value?360:o.value:0);function l(e){!function(e){r("update:modelValue",e)}(Math.round(e))}return(e,t)=>(Ds(),Qs(Om,{class:"vc-hue-slider",max:360,step:1,modelValue:a.value,direction:e.direction,"onUpdate:modelValue":l,"aria-label":"Hue"},{background:er(()=>t[0]||(t[0]=[qs("div",{class:"gradient"},null,-1)])),picker:er(()=>[Li(e.$slots,"default",{},void 0,!0)]),_:3},8,["modelValue","direction"]))}}),_m=Am(Bm,[["__scopeId","data-v-5367c985"]]),Tm=Er({__name:"CheckerboardBG",props:{size:{default:8},white:{default:"#fff"},grey:{default:"#e6e6e6"}},setup(e){const t=e;function n(e,t,n){return function(e,t,n){if(typeof document>"u")return null;var r=document.createElement("canvas");r.width=r.height=2*n;var i=r.getContext("2d");return i?(i.fillStyle=e,i.fillRect(0,0,r.width,r.height),i.fillStyle=t,i.fillRect(0,0,n,n),i.translate(n,n),i.fillRect(0,0,n,n),r.toDataURL()):null}(e,t,n)}const r=Ea(()=>`url(${n(t.white,t.grey,t.size)})`);return(e,t)=>(Ds(),Fs("div",{class:"vc-checkerboard",style:W({backgroundImage:r.value})},null,4))}}),Em=Am(Tm,[["__scopeId","data-v-37d61ccd"]]),Mm=Er({__name:"AlphaSlider",props:{tinyColor:{},modelValue:{},value:{}},emits:hm,setup(e,{emit:t}){const n=dm(e,t),r=Ea(()=>{const e=n.value.toRgb(),t=[e.r,e.g,e.b].join(",");return"linear-gradient(to right, rgba("+t+", 0) 0%, rgba("+t+", 1) 100%)"}),i=Ea(()=>n.value.getAlpha());function o(e){n.value=n.value.setAlpha(e).clone()}return(e,t)=>(Ds(),Qs(Om,{class:"vc-alpha-slider",modelValue:i.value,max:1,"aria-label":"Transparency","onUpdate:modelValue":o},{background:er(()=>[Ws(Em),qs("div",{class:"gradient",style:W({background:r.value})},null,4)]),_:1},8,["modelValue"]))}}),Dm=Am(Mm,[["__scopeId","data-v-07dd346b"]]),Pm={class:"vc-editable-input"},Rm=["value","aria-label"],Im={key:0,class:"vc-input-desc","aria-hidden":"true"},Lm=Er({__name:"EditableInput",props:{value:{},label:{},desc:{},max:{},min:{},step:{default:1},a11y:{}},emits:["change"],setup(e,{emit:t}){const n=e,r=t,i=n.a11y?.label??n.label,o=`input__label__${i}__${Math.random().toString().slice(2,5)}`;function s(e){const{min:t,max:i}=n;wm(i)&&+e>i?r("change",i):wm(t)&&+e<t?r("change",t):r("change",e)}function a(e){s(e.target?.value)}function l(e){let t=Number(n.value);if(!isNaN(t)){let r=n.step;const i=function(e){const t=e.toString();return-1!==t.indexOf(".")?t.split(".")[1].length:0}(r),o=fm(e);"up"===o&&(s((t+r).toFixed(i)),e.preventDefault()),"down"===o&&(s((t-r).toFixed(i)),e.preventDefault())}}return(e,t)=>(Ds(),Fs("div",Pm,[qs("input",{class:"vc-input-input",value:n.value,onKeydown:l,onInput:a,"aria-label":Kt(i),id:o},null,40,Rm),qs("label",{for:o,class:"vc-input-label","aria-hidden":"true"},fe(n.label),1),e.desc?(Ds(),Fs("span",Im,fe(e.desc),1)):Ks("",!0)]))}}),Nm=Am(Lm,[["__scopeId","data-v-4a4df1fd"]]);const Fm=e=>{const t=Ut(0),n=`__from__vc__hue__${function(){const e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";return e.charAt(Math.floor(62*Math.random()))+e.charAt(Math.floor(62*Math.random()))}()}`;return ns(e,e=>{if(e[n])return;const r=e.toHsl().h;0===r&&0!==t.value||(t.value=r)},{immediate:!0}),{hueRef:t,updateHueRef:r=>{const i=Tg({...e.value.toHsl(),h:r});i[n]=!0,e.value=i,t.value=r}}},Qm=e=>Tg(e).isValid(),Vm=e=>0===Tg(e).getAlpha(),zm={class:"saturation"},$m={class:"body"},Hm={class:"controls"},jm={class:"color-wrap"},qm=["aria-label"],Wm={class:"sliders"},Um={class:"hue-wrap"},Ym={key:0,class:"alpha-wrap"},Gm={key:0,class:"fieldsWrap","data-testid":"fields"},Xm={key:0,class:"fields"},Jm={class:"field"},Km={class:"field"},Zm={class:"field"},ev={key:0,class:"field"},tv={key:1,class:"fields"},nv={class:"field"},rv={key:2,class:"fields"},iv={class:"field"},ov={class:"field"},sv={class:"field"},av={key:0,class:"field"},lv={class:"toggle-icon",role:"presentation"},cv={style:{width:"24px",height:"24px"},viewBox:"0 0 24 24"},hv={class:"toggle-icon_highlighted",role:"presentation"},dv=Er({__name:"ChromePicker",props:{disableAlpha:{type:Boolean},disableFields:{type:Boolean},formats:{default:()=>["rgb","hex","hsl"]},tinyColor:{},modelValue:{},value:{}},emits:hm,setup(e,{emit:t}){const n=e,r=dm(n,t),{hueRef:i,updateHueRef:o}=Fm(r),s=Ut(0);let a=Ut(!1);const l=Ea(()=>{const e=r.value.toRgb();return"rgba("+[e.r,e.g,e.b,r.value.getAlpha()].join(",")+")"}),c=Ea(()=>{const{h:e,s:t,l:n}=r.value.toHsl();return{h:e.toFixed(),s:`${(100*t).toFixed()}%`,l:`${(100*n).toFixed()}%`}}),h=Ea(()=>r.value.toRgb()),d=Ea(()=>Number(r.value.getAlpha().toFixed(2))),u=new Set(["hex","hsl","rgb"]),p=Ea(()=>{const e=new Set,t=[],r=n.formats;for(const n of r)if(u.has(n)){const r=n;e.has(r)||(e.add(r),t.push(r))}return t}),f=Ea(()=>{const{disableFields:e,formats:t}=n;return!(!0===e||!Array.isArray(t)||0===p.value.length)}),g=e=>p.value.includes(e),m=e=>p.value.indexOf(e),v=e=>{e&&Qm(e)&&(r.value=e)},b=(e,t)=>{if(!t||isNaN(Number(t)))return;const n={[e]:t};r.value={...h.value,a:d.value,...n}},A=(e,t)=>{if(!t)return;const n={[e]:+t};("s"===e||"l"===e)&&(n[e]=+t.replace("%","")/100),r.value={...r.value.toHsl(),a:d.value,...n}},y=()=>{s.value!==p.value.length-1?s.value++:s.value=0},w=()=>{a.value=!0},C=()=>{a.value=!1};return(e,t)=>(Ds(),Fs("div",{role:"application","aria-label":"Chrome Color Picker",class:J(["vc-chrome-picker",e.disableAlpha?"alpha-disabled":""])},[qs("div",zm,[Ws(ym,{tinyColor:Kt(r),"onUpdate:tinyColor":t[0]||(t[0]=e=>Wt(r)?r.value=e:null),hue:Kt(i)},null,8,["tinyColor","hue"])]),qs("div",$m,[qs("div",Hm,[qs("div",jm,[qs("div",{class:"active-color",style:W({backgroundColor:l.value}),role:"presentation","aria-live":"polite","aria-label":`Current color is ${l.value}`},null,12,qm),n.disableAlpha?Ks("",!0):(Ds(),Qs(Em,{key:0}))]),qs("div",Wm,[qs("div",Um,[Ws(_m,{modelValue:Kt(i),"onUpdate:modelValue":Kt(o)},null,8,["modelValue","onUpdate:modelValue"])]),n.disableAlpha?Ks("",!0):(Ds(),Fs("div",Ym,[Ws(Dm,{tinyColor:Kt(r),"onUpdate:tinyColor":t[1]||(t[1]=e=>Wt(r)?r.value=e:null)},null,8,["tinyColor"])]))])]),f.value?(Ds(),Fs("div",Gm,[g("rgb")?tr((Ds(),Fs("div",Xm,[qs("div",Jm,[Ws(Nm,{label:"r",value:h.value.r,onChange:t[2]||(t[2]=e=>b("r",e)),a11y:{label:"Red"}},null,8,["value"])]),qs("div",Km,[Ws(Nm,{label:"g",value:h.value.g,onChange:t[3]||(t[3]=e=>b("g",e)),a11y:{label:"Green"}},null,8,["value"])]),qs("div",Zm,[Ws(Nm,{label:"b",value:h.value.b,onChange:t[4]||(t[4]=e=>b("b",e)),a11y:{label:"Blue"}},null,8,["value"])]),e.disableAlpha?Ks("",!0):(Ds(),Fs("div",ev,[Ws(Nm,{label:"a",value:d.value,step:.01,max:1,onChange:t[5]||(t[5]=e=>b("a",e)),a11y:{label:"Transparency"}},null,8,["value"])]))],512)),[[bl,s.value===m("rgb")]]):Ks("",!0),g("hex")?tr((Ds(),Fs("div",tv,[qs("div",nv,[1===d.value?(Ds(),Qs(Nm,{key:0,label:"hex",value:Kt(r).toHexString(),onChange:v,a11y:{label:"Hex"}},null,8,["value"])):Ks("",!0),1!==d.value?(Ds(),Qs(Nm,{key:1,label:"hex",value:Kt(r).toHex8String(),onChange:v,a11y:{label:"Hex with transparency"}},null,8,["value"])):Ks("",!0)])],512)),[[bl,s.value===m("hex")]]):Ks("",!0),g("hsl")?tr((Ds(),Fs("div",rv,[qs("div",iv,[Ws(Nm,{label:"h",value:Kt(i).toFixed(),onChange:t[6]||(t[6]=e=>A("h",e)),a11y:{label:"Hue"}},null,8,["value"])]),qs("div",ov,[Ws(Nm,{label:"s",value:c.value.s,onChange:t[7]||(t[7]=e=>A("s",e)),a11y:{label:"Saturation"}},null,8,["value"])]),qs("div",sv,[Ws(Nm,{label:"l",value:c.value.l,onChange:t[8]||(t[8]=e=>A("l",e)),a11y:{label:"Lightness"}},null,8,["value"])]),e.disableAlpha?Ks("",!0):(Ds(),Fs("div",av,[Ws(Nm,{label:"a",value:d.value,step:.01,max:1,onChange:t[9]||(t[9]=e=>A("a",e)),a11y:{label:"Transparency"}},null,8,["value"])]))],512)),[[bl,s.value===m("hsl")]]):Ks("",!0),p.value.length>1?(Ds(),Fs("div",{key:3,class:"toggle-btn",onClick:y,onKeydown:[xc(y,["enter"]),xc(y,["space"])],onMouseover:w,onMouseenter:w,onMouseout:C,onFocus:w,onBlur:C,role:"button","aria-label":"Change color format",tabindex:"0"},[qs("div",lv,[(Ds(),Fs("svg",cv,t[10]||(t[10]=[qs("path",{fill:"currentColor",d:"M12,18.17L8.83,15L7.42,16.41L12,21L16.59,16.41L15.17,15M12,5.83L15.17,9L16.58,7.59L12,3L7.41,7.59L8.83,9L12,5.83Z"},null,-1)])))]),tr(qs("div",hv,null,512),[[bl,Kt(a)]])],32)):Ks("",!0)])):Ks("",!0)])],2))}}),uv=Am(dv,[["__scopeId","data-v-abf90852"]]),pv={class:"vc-compact-picker",role:"application","aria-label":"Compact color picker",tabindex:"0"},fv={class:"colors",role:"listbox","aria-label":"Pick a color"},gv=["onClick","aria-label","aria-selected","title","onKeydown"],mv={class:"dot"},vv=["#4D4D4D","#999999","#FFFFFF","#F44E3B","#FE9200","#FCDC00","#DBDF00","#A4DD00","#68CCCA","#73D8FF","#AEA1FF","#FDA1FF","#333333","#808080","#CCCCCC","#D33115","#E27300","#FCC400","#B0BC00","#68BC00","#16A5A5","#009CE0","#7B64FF","#FA28FF","#000000","#666666","#B3B3B3","#9F0500","#C45100","#FB9E00","#808900","#194D33","#0C797D","#0062B1","#653294","#AB149E"],bv=(["change"].concat(hm),{role:"application","aria-label":"Grayscale color picker",class:"vc-grayscale-picker"}),Av={class:"colors",role:"listbox","aria-label":"Select a grayscale color",tabindex:"0"},yv=["onClick","aria-label","aria-selected","title","onKeydown"],wv={class:"dot"},Cv=["#FFFFFF","#F2F2F2","#E6E6E6","#D9D9D9","#CCCCCC","#BFBFBF","#B3B3B3","#A6A6A6","#999999","#8C8C8C","#808080","#737373","#666666","#595959","#4D4D4D","#404040","#333333","#262626","#0D0D0D","#000000"],xv=(["change"].concat(hm),{class:"title","aria-hidden":"true"}),kv={class:"body"},Sv={class:"saturation"},Ov={class:"hue"},Bv={class:"preview"},_v={class:"preview-label","aria-hidden":"true"},Tv={class:"preview-swatches"},Ev=["aria-label"],Mv=["aria-label"],Dv={class:"preview-label","aria-hidden":"true"},Pv={key:0,class:"actions"},Rv=["aria-label"],Iv={class:"fields"},Lv=["aria-label"],Nv=(Boolean,Boolean,hm.concat(["ok","cancel","reset"]),{class:"saturation"}),Fv={class:"controls"},Qv={class:"sliders"},Vv={class:"hue"},zv={key:0,class:"alpha"},$v={class:"color"},Hv=["aria-label"],jv={key:0,class:"field"},qv={class:"field_double"},Wv={class:"field_single"},Uv={class:"field_single"},Yv={class:"field_single"},Gv={key:0,class:"field_single"},Xv={class:"presets",role:"listbox","aria-label":"A color preset, pick one to set as current color"},Jv=["onClick","title","aria-label","aria-selected","onKeydown"],Kv=["onClick","aria-selected","title","onKeydown"],Zv=["#D0021B","#F5A623","#F8E71C","#8B572A","#7ED321","#417505","#BD10E0","#9013FE","#4A90E2","#50E3C2","#B8E986","#000000","#4A4A4A","#9B9B9B","#FFFFFF","rgba(0,0,0,0)"],eb=(Boolean,Boolean,["change"].concat(hm),{role:"application","aria-label":"Slider color picker",class:"vc-slider-picker"}),tb={class:"hue"},nb={key:0,class:"alpha"},rb={key:1,class:"swatches",role:"listbox","aria-label":"Color segments in different shades of one color",tabindex:"0"},ib=["onClick","aria-label","title","onKeydown","aria-selected"],ob=.5,sb=[{s:ob,l:.8},{s:ob,l:.65},{s:ob,l:.5},{s:ob,l:.35},{s:ob,l:.2}];Boolean;const ab={class:"vc-hsl-sliders"},lb={class:"slider-wrap h-slider"},cb={class:"slider-wrap s-slider"},hb={class:"slider-wrap l-slider"},db={key:0,class:"slider-wrap a-slider"};Boolean,Boolean;const ub={class:"vc-hsv-sliders"},pb={class:"slider-wrap h-slider"},fb={class:"slider-wrap s-slider"},gb={class:"slider-wrap b-slider"},mb={key:0,class:"slider-wrap"};Boolean,Boolean;const vb={class:"vc-rgb-sliders"},bb={class:"slider-wrap"},Ab={class:"slider-wrap"},yb={class:"slider-wrap"},wb={key:0,class:"slider-wrap a-slider"},Cb=(e,t)=>{const n=[];for(let r=1;r<=255;r++){const{r:i,g:o,b:s}={...t,[e]:r};n.push(`rgb(${i}, ${o}, ${s})`)}return`linear-gradient(to right, ${n.join(", ")})`};Boolean,Boolean;var xb={key:0,class:"trp-field__label trp-primary-text-bold"},kb={class:"trp-color__wrapper"},Sb={class:"trp-color-code trp-primary-text"};const Ob={__name:"ColorField",props:{label:{type:String,default:""},modelValue:{type:String,required:!0}},emits:["update:modelValue"],setup:function(e,t){var n=t.emit,r=e,i=n,o=Ut(!1),s=Ut(null),a=Ut(null);function l(){o.value=!o.value}function c(e){s.value&&!s.value.contains(e.target)&&a.value&&!a.value.contains(e.target)&&(o.value=!1)}vi(function(){return document.addEventListener("mousedown",c)}),yi(function(){return document.removeEventListener("mousedown",c)});var h=Ea({get:function(){return Tg(r.modelValue)},set:function(e){var t=Tg(e),n=t.toHexString().toUpperCase(),r=Math.round(255*t.getAlpha()).toString(16).padStart(2,"0").toUpperCase(),o="FF"===r?n:"".concat(n).concat(r);i("update:modelValue",o)}});return function(t,n){return Ds(),Fs("div",{class:J({"trp-color--picking":o.value})},[e.label?(Ds(),Fs("span",xb,fe(e.label),1)):Ks("",!0),qs("div",kb,[qs("div",{class:"trp-color-input",style:W({background:e.modelValue}),ref_key:"swatchRef",ref:s,onClick:l,onKeydown:xc(l,["enter","space"]),role:"button","aria-label":"Open colour picker",tabindex:"0"},null,36),qs("span",Sb,fe(e.modelValue.toUpperCase()),1),o.value?(Ds(),Fs("div",{key:0,class:"trp-color__popover",ref_key:"pickerRef",ref:a,onMousedown:n[1]||(n[1]=wc(function(){},["stop"]))},[Ws(Kt(uv),{tinyColor:h.value,"onUpdate:tinyColor":n[0]||(n[0]=function(e){return h.value=e})},null,8,["tinyColor"])],544)):Ks("",!0)])],2)}}};var Bb=n(54),_b={insert:"head",singleton:!1};xg()(Bb.A,_b);Bb.A.locals;var Tb=n(262);const Eb=(0,Tb.A)(Ob,[["__scopeId","data-v-6f8cc29c"]]);var Mb={key:0,class:"trp-field__label trp-primary-text-bold"},Db={class:"trp-number__wrapper"},Pb=["value","min"];const Rb={__name:"NumberField",props:{label:{type:String,default:""},modelValue:{type:[Number,null],default:null},min:{type:Number,default:0,required:!1}},emits:["update:modelValue"],setup:function(e,t){var n=t.emit,r=e,i=n;function o(e){var t=e.target.value;i("update:modelValue",""===t?r.min:Number(t))}return function(t,n){var r;return Ds(),Fs("div",null,[e.label?(Ds(),Fs("span",Mb,fe(e.label),1)):Ks("",!0),qs("div",Db,[qs("input",{type:"number",class:"trp-number-input",value:null!==(r=e.modelValue)&&void 0!==r?r:"",min:e.min,onInput:o},null,40,Pb),n[0]||(n[0]=qs("span",{class:"trp-primary-text"},"px",-1))])])}}};var Ib=n(565),Lb={insert:"head",singleton:!1};xg()(Ib.A,Lb);Ib.A.locals;const Nb=(0,Tb.A)(Rb,[["__scopeId","data-v-4d5d37b0"]]);var Fb={class:"trp-toggle-wrapper"},Qb={key:0,class:"trp-field__label trp-primary-text-bold"},Vb=["checked"];const zb={__name:"ToggleField",props:{modelValue:Boolean,label:{type:String,default:""}},emits:["update:modelValue"],setup:function(e,t){var n=t.emit,r=n;return function(t,n){return Ds(),Fs("div",Fb,[e.label?(Ds(),Fs("span",Qb,fe(e.label),1)):Ks("",!0),qs("div",{class:"trp-toggle-inner",onClick:n[0]||(n[0]=function(t){return r("update:modelValue",!e.modelValue)})},[qs("input",{type:"checkbox",class:"trp-toggle-input",checked:e.modelValue,readonly:""},null,8,Vb),n[1]||(n[1]=qs("span",{class:"trp-toggle-slider"},null,-1))])])}}};var $b=n(787),Hb={insert:"head",singleton:!1};xg()($b.A,Hb);$b.A.locals;const jb=(0,Tb.A)(zb,[["__scopeId","data-v-30d3f338"]]);var qb={class:"trp-toggle-status-field"},Wb={class:"trp-primary-text"};const Ub={__name:"ToggleStatusField",props:{modelValue:Boolean,onText:{type:String,default:"Enabled"},offText:{type:String,default:"Disabled"}},emits:["update:modelValue"],setup:function(e,t){var n=t.emit,r=e,i=n,o=Ea({get:function(){return r.modelValue},set:function(e){return i("update:modelValue",e)}});return function(t,n){return Ds(),Fs("div",qb,[Ws(jb,{modelValue:o.value,"onUpdate:modelValue":n[0]||(n[0]=function(e){return o.value=e}),label:""},null,8,["modelValue"]),qs("span",Wb,fe(e.modelValue?e.onText:e.offText),1)])}}};var Yb=n(268),Gb={insert:"head",singleton:!1};xg()(Yb.A,Gb);Yb.A.locals;const Xb=(0,Tb.A)(Ub,[["__scopeId","data-v-63ef0d74"]]);function Jb(e){return function(e){if(Array.isArray(e))return Kb(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(e){if("string"==typeof e)return Kb(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?Kb(e,t):void 0}}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function Kb(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}var Zb={class:"trp-radio-group__wrapper"},eA={key:0,class:"trp-field__label trp-primary-text-bold"},tA={class:"trp-radio-group"},nA=["title"],rA={class:"trp-radio-label"},iA=["name","value","checked","disabled","onChange"];const oA={__name:"RadioGroupField",props:{label:{type:String,required:!1,default:""},modelValue:{type:String,required:!0},options:{type:Array,required:!0,validator:function(e){return e.every(function(e){return"value"in e&&"label"in e&&(void 0===e.disabled||"boolean"==typeof e.disabled)&&(void 0===e.title||"string"==typeof e.title)})}},customValue:{type:[Number,String]}},emits:["update:modelValue","update:customValue"],setup:function(e,t){var n=t.emit,r=e,i=n,o=Ut(r.customValue);ns(function(){return r.customValue},function(e){e!==o.value&&(o.value=e)}),ns(o,function(e){i("update:customValue",e)});var s=Ea(function(){return void 0!==r.customValue}),a=Ea(function(){return s.value?r.options.some(function(e){return"custom"===e.value})?r.options:[].concat(Jb(r.options),[{value:"custom",label:"Custom"}]):r.options});return function(t,n){return Ds(),Fs("div",Zb,[e.label?(Ds(),Fs("span",eA,fe(e.label),1)):Ks("",!0),qs("div",tA,[(Ds(!0),Fs(Os,null,Ri(a.value,function(t){return Ds(),Fs("div",{key:t.value,class:J(["trp-radio-option",{"is-disabled":t.disabled}]),title:t.title},[qs("label",rA,[qs("input",{type:"radio",name:e.label||"radio-group",value:t.value,checked:e.modelValue===t.value,disabled:t.disabled,onChange:function(){return i("update:modelValue",t.value)}},null,40,iA),qs("span",null,fe(t.label),1)]),s.value&&"custom"===t.value&&"custom"===e.modelValue?(Ds(),Qs(Nb,{key:0,class:"trp-lc-custom-number",modelValue:o.value,"onUpdate:modelValue":n[0]||(n[0]=function(e){return o.value=e}),label:"",min:0},null,8,["modelValue"])):Ks("",!0)],10,nA)}),128))])])}}};var sA=n(139),aA={insert:"head",singleton:!1};xg()(sA.A,aA);sA.A.locals;const lA=(0,Tb.A)(oA,[["__scopeId","data-v-e2617dbe"]]);function cA(e){return function(e){if(Array.isArray(e))return hA(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(e){if("string"==typeof e)return hA(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?hA(e,t):void 0}}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function hA(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}var dA={class:"trp-field trp-field--column"},uA={class:"trp-field__label trp-primary-text-bold"},pA={class:"trp-quad-grid"},fA={class:"trp-primary-text trp-corner-label"};const gA={__name:"QuadRadiusField",props:{label:{type:String,default:""},modelValue:{type:Array,required:!0}},emits:["update:modelValue"],setup:function(e,t){var n=t.emit,r=e,i=n,o=Array.from({length:4},function(e,t){return Ea({get:function(){var e;return null!==(e=r.modelValue[t])&&void 0!==e?e:0},set:function(e){var n=cA(r.modelValue);n[t]=e,i("update:modelValue",n)}})}),s=["Top Left","Top Right","Bottom Left","Bottom Right"];return function(t,n){return Ds(),Fs("div",dA,[qs("span",uA,fe(e.label),1),qs("div",pA,[(Ds(),Fs(Os,null,Ri(s,function(e,t){return qs("div",{key:t,class:"trp-quad-radius-corner"},[qs("span",fA,fe(e),1),Ws(Nb,{modelValue:Kt(o)[t].value,"onUpdate:modelValue":function(e){return Kt(o)[t].value=e},label:""},null,8,["modelValue","onUpdate:modelValue"])])}),64))])])}}};var mA=n(419),vA={insert:"head",singleton:!1};xg()(mA.A,vA);mA.A.locals;const bA=(0,Tb.A)(gA,[["__scopeId","data-v-44785c6b"]]);let AA=[],yA=[];function wA(e){if(e<768)return!1;for(let t=0,n=AA.length;;){let r=t+n>>1;if(e<AA[r])n=r;else{if(!(e>=yA[r]))return!0;t=r+1}if(t==n)return!1}}function CA(e){return e>=127462&&e<=127487}(()=>{let e="lc,34,7n,7,7b,19,,,,2,,2,,,20,b,1c,l,g,,2t,7,2,6,2,2,,4,z,,u,r,2j,b,1m,9,9,,o,4,,9,,3,,5,17,3,3b,f,,w,1j,,,,4,8,4,,3,7,a,2,t,,1m,,,,2,4,8,,9,,a,2,q,,2,2,1l,,4,2,4,2,2,3,3,,u,2,3,,b,2,1l,,4,5,,2,4,,k,2,m,6,,,1m,,,2,,4,8,,7,3,a,2,u,,1n,,,,c,,9,,14,,3,,1l,3,5,3,,4,7,2,b,2,t,,1m,,2,,2,,3,,5,2,7,2,b,2,s,2,1l,2,,,2,4,8,,9,,a,2,t,,20,,4,,2,3,,,8,,29,,2,7,c,8,2q,,2,9,b,6,22,2,r,,,,,,1j,e,,5,,2,5,b,,10,9,,2u,4,,6,,2,2,2,p,2,4,3,g,4,d,,2,2,6,,f,,jj,3,qa,3,t,3,t,2,u,2,1s,2,,7,8,,2,b,9,,19,3,3b,2,y,,3a,3,4,2,9,,6,3,63,2,2,,1m,,,7,,,,,2,8,6,a,2,,1c,h,1r,4,1c,7,,,5,,14,9,c,2,w,4,2,2,,3,1k,,,2,3,,,3,1m,8,2,2,48,3,,d,,7,4,,6,,3,2,5i,1m,,5,ek,,5f,x,2da,3,3x,,2o,w,fe,6,2x,2,n9w,4,,a,w,2,28,2,7k,,3,,4,,p,2,5,,47,2,q,i,d,,12,8,p,b,1a,3,1c,,2,4,2,2,13,,1v,6,2,2,2,2,c,,8,,1b,,1f,,,3,2,2,5,2,,,16,2,8,,6m,,2,,4,,fn4,,kh,g,g,g,a6,2,gt,,6a,,45,5,1ae,3,,2,5,4,14,3,4,,4l,2,fx,4,ar,2,49,b,4w,,1i,f,1k,3,1d,4,2,2,1x,3,10,5,,8,1q,,c,2,1g,9,a,4,2,,2n,3,2,,,2,6,,4g,,3,8,l,2,1l,2,,,,,m,,e,7,3,5,5f,8,2,3,,,n,,29,,2,6,,,2,,,2,,2,6j,,2,4,6,2,,2,r,2,2d,8,2,,,2,2y,,,,2,6,,,2t,3,2,4,,5,77,9,,2,6t,,a,2,,,4,,40,4,2,2,4,,w,a,14,6,2,4,8,,9,6,2,3,1a,d,,2,ba,7,,6,,,2a,m,2,7,,2,,2,3e,6,3,,,2,,7,,,20,2,3,,,,9n,2,f0b,5,1n,7,t4,,1r,4,29,,f5k,2,43q,,,3,4,5,8,8,2,7,u,4,44,3,1iz,1j,4,1e,8,,e,,m,5,,f,11s,7,,h,2,7,,2,,5,79,7,c5,4,15s,7,31,7,240,5,gx7k,2o,3k,6o".split(",").map(e=>e?parseInt(e,36):1);for(let t=0,n=0;t<e.length;t++)(t%2?yA:AA).push(n+=e[t])})();function xA(e,t,n=!0,r=!0){return(n?kA:SA)(e,t,r)}function kA(e,t,n){if(t==e.length)return t;t&&BA(e.charCodeAt(t))&&_A(e.charCodeAt(t-1))&&t--;let r=OA(e,t);for(t+=TA(r);t<e.length;){let i=OA(e,t);if(8205==r||8205==i||n&&wA(i))t+=TA(i),r=i;else{if(!CA(i))break;{let n=0,r=t-2;for(;r>=0&&CA(OA(e,r));)n++,r-=2;if(n%2==0)break;t+=2}}}return t}function SA(e,t,n){for(;t>0;){let r=kA(e,t-2,n);if(r<t)return r;t--}return 0}function OA(e,t){let n=e.charCodeAt(t);if(!_A(n)||t+1==e.length)return n;let r=e.charCodeAt(t+1);return BA(r)?r-56320+(n-55296<<10)+65536:n}function BA(e){return e>=56320&&e<57344}function _A(e){return e>=55296&&e<56320}function TA(e){return e<65536?1:2}class EA{lineAt(e){if(e<0||e>this.length)throw new RangeError(`Invalid position ${e} in document of length ${this.length}`);return this.lineInner(e,!1,1,0)}line(e){if(e<1||e>this.lines)throw new RangeError(`Invalid line number ${e} in ${this.lines}-line document`);return this.lineInner(e,!0,1,0)}replace(e,t,n){[e,t]=QA(this,e,t);let r=[];return this.decompose(0,e,r,2),n.length&&n.decompose(0,n.length,r,3),this.decompose(t,this.length,r,1),DA.from(r,this.length-(t-e)+n.length)}append(e){return this.replace(this.length,this.length,e)}slice(e,t=this.length){[e,t]=QA(this,e,t);let n=[];return this.decompose(e,t,n,0),DA.from(n,t-e)}eq(e){if(e==this)return!0;if(e.length!=this.length||e.lines!=this.lines)return!1;let t=this.scanIdentical(e,1),n=this.length-this.scanIdentical(e,-1),r=new IA(this),i=new IA(e);for(let e=t,o=t;;){if(r.next(e),i.next(e),e=0,r.lineBreak!=i.lineBreak||r.done!=i.done||r.value!=i.value)return!1;if(o+=r.value.length,r.done||o>=n)return!0}}iter(e=1){return new IA(this,e)}iterRange(e,t=this.length){return new LA(this,e,t)}iterLines(e,t){let n;if(null==e)n=this.iter();else{null==t&&(t=this.lines+1);let r=this.line(e).from;n=this.iterRange(r,Math.max(r,t==this.lines+1?this.length:t<=1?0:this.line(t-1).to))}return new NA(n)}toString(){return this.sliceString(0)}toJSON(){let e=[];return this.flatten(e),e}constructor(){}static of(e){if(0==e.length)throw new RangeError("A document must have at least one line");return 1!=e.length||e[0]?e.length<=32?new MA(e):DA.from(MA.split(e,[])):EA.empty}}class MA extends EA{constructor(e,t=function(e){let t=-1;for(let n of e)t+=n.length+1;return t}(e)){super(),this.text=e,this.length=t}get lines(){return this.text.length}get children(){return null}lineInner(e,t,n,r){for(let i=0;;i++){let o=this.text[i],s=r+o.length;if((t?n:s)>=e)return new FA(r,s,n,o);r=s+1,n++}}decompose(e,t,n,r){let i=e<=0&&t>=this.length?this:new MA(RA(this.text,e,t),Math.min(t,this.length)-Math.max(0,e));if(1&r){let e=n.pop(),t=PA(i.text,e.text.slice(),0,i.length);if(t.length<=32)n.push(new MA(t,e.length+i.length));else{let e=t.length>>1;n.push(new MA(t.slice(0,e)),new MA(t.slice(e)))}}else n.push(i)}replace(e,t,n){if(!(n instanceof MA))return super.replace(e,t,n);[e,t]=QA(this,e,t);let r=PA(this.text,PA(n.text,RA(this.text,0,e)),t),i=this.length+n.length-(t-e);return r.length<=32?new MA(r,i):DA.from(MA.split(r,[]),i)}sliceString(e,t=this.length,n="\n"){[e,t]=QA(this,e,t);let r="";for(let i=0,o=0;i<=t&&o<this.text.length;o++){let s=this.text[o],a=i+s.length;i>e&&o&&(r+=n),e<a&&t>i&&(r+=s.slice(Math.max(0,e-i),t-i)),i=a+1}return r}flatten(e){for(let t of this.text)e.push(t)}scanIdentical(){return 0}static split(e,t){let n=[],r=-1;for(let i of e)n.push(i),r+=i.length+1,32==n.length&&(t.push(new MA(n,r)),n=[],r=-1);return r>-1&&t.push(new MA(n,r)),t}}class DA extends EA{constructor(e,t){super(),this.children=e,this.length=t,this.lines=0;for(let t of e)this.lines+=t.lines}lineInner(e,t,n,r){for(let i=0;;i++){let o=this.children[i],s=r+o.length,a=n+o.lines-1;if((t?a:s)>=e)return o.lineInner(e,t,n,r);r=s+1,n=a+1}}decompose(e,t,n,r){for(let i=0,o=0;o<=t&&i<this.children.length;i++){let s=this.children[i],a=o+s.length;if(e<=a&&t>=o){let i=r&((o<=e?1:0)|(a>=t?2:0));o>=e&&a<=t&&!i?n.push(s):s.decompose(e-o,t-o,n,i)}o=a+1}}replace(e,t,n){if([e,t]=QA(this,e,t),n.lines<this.lines)for(let r=0,i=0;r<this.children.length;r++){let o=this.children[r],s=i+o.length;if(e>=i&&t<=s){let a=o.replace(e-i,t-i,n),l=this.lines-o.lines+a.lines;if(a.lines<l>>4&&a.lines>l>>6){let i=this.children.slice();return i[r]=a,new DA(i,this.length-(t-e)+n.length)}return super.replace(i,s,a)}i=s+1}return super.replace(e,t,n)}sliceString(e,t=this.length,n="\n"){[e,t]=QA(this,e,t);let r="";for(let i=0,o=0;i<this.children.length&&o<=t;i++){let s=this.children[i],a=o+s.length;o>e&&i&&(r+=n),e<a&&t>o&&(r+=s.sliceString(e-o,t-o,n)),o=a+1}return r}flatten(e){for(let t of this.children)t.flatten(e)}scanIdentical(e,t){if(!(e instanceof DA))return 0;let n=0,[r,i,o,s]=t>0?[0,0,this.children.length,e.children.length]:[this.children.length-1,e.children.length-1,-1,-1];for(;;r+=t,i+=t){if(r==o||i==s)return n;let a=this.children[r],l=e.children[i];if(a!=l)return n+a.scanIdentical(l,t);n+=a.length+1}}static from(e,t=e.reduce((e,t)=>e+t.length+1,-1)){let n=0;for(let t of e)n+=t.lines;if(n<32){let n=[];for(let t of e)t.flatten(n);return new MA(n,t)}let r=Math.max(32,n>>5),i=r<<1,o=r>>1,s=[],a=0,l=-1,c=[];function h(e){let t;if(e.lines>i&&e instanceof DA)for(let t of e.children)h(t);else e.lines>o&&(a>o||!a)?(d(),s.push(e)):e instanceof MA&&a&&(t=c[c.length-1])instanceof MA&&e.lines+t.lines<=32?(a+=e.lines,l+=e.length+1,c[c.length-1]=new MA(t.text.concat(e.text),t.length+1+e.length)):(a+e.lines>r&&d(),a+=e.lines,l+=e.length+1,c.push(e))}function d(){0!=a&&(s.push(1==c.length?c[0]:DA.from(c,l)),l=-1,a=c.length=0)}for(let t of e)h(t);return d(),1==s.length?s[0]:new DA(s,t)}}function PA(e,t,n=0,r=1e9){for(let i=0,o=0,s=!0;o<e.length&&i<=r;o++){let a=e[o],l=i+a.length;l>=n&&(l>r&&(a=a.slice(0,r-i)),i<n&&(a=a.slice(n-i)),s?(t[t.length-1]+=a,s=!1):t.push(a)),i=l+1}return t}function RA(e,t,n){return PA(e,[""],t,n)}EA.empty=new MA([""],0);class IA{constructor(e,t=1){this.dir=t,this.done=!1,this.lineBreak=!1,this.value="",this.nodes=[e],this.offsets=[t>0?1:(e instanceof MA?e.text.length:e.children.length)<<1]}nextInner(e,t){for(this.done=this.lineBreak=!1;;){let n=this.nodes.length-1,r=this.nodes[n],i=this.offsets[n],o=i>>1,s=r instanceof MA?r.text.length:r.children.length;if(o==(t>0?s:0)){if(0==n)return this.done=!0,this.value="",this;t>0&&this.offsets[n-1]++,this.nodes.pop(),this.offsets.pop()}else if((1&i)==(t>0?0:1)){if(this.offsets[n]+=t,0==e)return this.lineBreak=!0,this.value="\n",this;e--}else if(r instanceof MA){let i=r.text[o+(t<0?-1:0)];if(this.offsets[n]+=t,i.length>Math.max(0,e))return this.value=0==e?i:t>0?i.slice(e):i.slice(0,i.length-e),this;e-=i.length}else{let i=r.children[o+(t<0?-1:0)];e>i.length?(e-=i.length,this.offsets[n]+=t):(t<0&&this.offsets[n]--,this.nodes.push(i),this.offsets.push(t>0?1:(i instanceof MA?i.text.length:i.children.length)<<1))}}}next(e=0){return e<0&&(this.nextInner(-e,-this.dir),e=this.value.length),this.nextInner(e,this.dir)}}class LA{constructor(e,t,n){this.value="",this.done=!1,this.cursor=new IA(e,t>n?-1:1),this.pos=t>n?e.length:0,this.from=Math.min(t,n),this.to=Math.max(t,n)}nextInner(e,t){if(t<0?this.pos<=this.from:this.pos>=this.to)return this.value="",this.done=!0,this;e+=Math.max(0,t<0?this.pos-this.to:this.from-this.pos);let n=t<0?this.pos-this.from:this.to-this.pos;e>n&&(e=n),n-=e;let{value:r}=this.cursor.next(e);return this.pos+=(r.length+e)*t,this.value=r.length<=n?r:t<0?r.slice(r.length-n):r.slice(0,n),this.done=!this.value,this}next(e=0){return e<0?e=Math.max(e,this.from-this.pos):e>0&&(e=Math.min(e,this.to-this.pos)),this.nextInner(e,this.cursor.dir)}get lineBreak(){return this.cursor.lineBreak&&""!=this.value}}class NA{constructor(e){this.inner=e,this.afterBreak=!0,this.value="",this.done=!1}next(e=0){let{done:t,lineBreak:n,value:r}=this.inner.next(e);return t&&this.afterBreak?(this.value="",this.afterBreak=!1):t?(this.done=!0,this.value=""):n?this.afterBreak?this.value="":(this.afterBreak=!0,this.next()):(this.value=r,this.afterBreak=!1),this}get lineBreak(){return!1}}"undefined"!=typeof Symbol&&(EA.prototype[Symbol.iterator]=function(){return this.iter()},IA.prototype[Symbol.iterator]=LA.prototype[Symbol.iterator]=NA.prototype[Symbol.iterator]=function(){return this});class FA{constructor(e,t,n,r){this.from=e,this.to=t,this.number=n,this.text=r}get length(){return this.to-this.from}}function QA(e,t,n){return[t=Math.max(0,Math.min(e.length,t)),Math.max(t,Math.min(e.length,n))]}function VA(e,t,n=!0,r=!0){return xA(e,t,n,r)}function zA(e,t){let n=e.charCodeAt(t);if(!(r=n,r>=55296&&r<56320&&t+1!=e.length))return n;var r;let i=e.charCodeAt(t+1);return function(e){return e>=56320&&e<57344}(i)?i-56320+(n-55296<<10)+65536:n}function $A(e){return e<=65535?String.fromCharCode(e):(e-=65536,String.fromCharCode(55296+(e>>10),56320+(1023&e)))}function HA(e){return e<65536?1:2}const jA=/\r\n?|\n/;var qA=function(e){return e[e.Simple=0]="Simple",e[e.TrackDel=1]="TrackDel",e[e.TrackBefore=2]="TrackBefore",e[e.TrackAfter=3]="TrackAfter",e}(qA||(qA={}));class WA{constructor(e){this.sections=e}get length(){let e=0;for(let t=0;t<this.sections.length;t+=2)e+=this.sections[t];return e}get newLength(){let e=0;for(let t=0;t<this.sections.length;t+=2){let n=this.sections[t+1];e+=n<0?this.sections[t]:n}return e}get empty(){return 0==this.sections.length||2==this.sections.length&&this.sections[1]<0}iterGaps(e){for(let t=0,n=0,r=0;t<this.sections.length;){let i=this.sections[t++],o=this.sections[t++];o<0?(e(n,r,i),r+=i):r+=o,n+=i}}iterChangedRanges(e,t=!1){XA(this,e,t)}get invertedDesc(){let e=[];for(let t=0;t<this.sections.length;){let n=this.sections[t++],r=this.sections[t++];r<0?e.push(n,r):e.push(r,n)}return new WA(e)}composeDesc(e){return this.empty?e:e.empty?this:KA(this,e)}mapDesc(e,t=!1){return e.empty?this:JA(this,e,t)}mapPos(e,t=-1,n=qA.Simple){let r=0,i=0;for(let o=0;o<this.sections.length;){let s=this.sections[o++],a=this.sections[o++],l=r+s;if(a<0){if(l>e)return i+(e-r);i+=s}else{if(n!=qA.Simple&&l>=e&&(n==qA.TrackDel&&r<e&&l>e||n==qA.TrackBefore&&r<e||n==qA.TrackAfter&&l>e))return null;if(l>e||l==e&&t<0&&!s)return e==r||t<0?i:i+a;i+=a}r=l}if(e>r)throw new RangeError(`Position ${e} is out of range for changeset of length ${r}`);return i}touchesRange(e,t=e){for(let n=0,r=0;n<this.sections.length&&r<=t;){let i=r+this.sections[n++];if(this.sections[n++]>=0&&r<=t&&i>=e)return!(r<e&&i>t)||"cover";r=i}return!1}toString(){let e="";for(let t=0;t<this.sections.length;){let n=this.sections[t++],r=this.sections[t++];e+=(e?" ":"")+n+(r>=0?":"+r:"")}return e}toJSON(){return this.sections}static fromJSON(e){if(!Array.isArray(e)||e.length%2||e.some(e=>"number"!=typeof e))throw new RangeError("Invalid JSON representation of ChangeDesc");return new WA(e)}static create(e){return new WA(e)}}class UA extends WA{constructor(e,t){super(e),this.inserted=t}apply(e){if(this.length!=e.length)throw new RangeError("Applying change set to a document with the wrong length");return XA(this,(t,n,r,i,o)=>e=e.replace(r,r+(n-t),o),!1),e}mapDesc(e,t=!1){return JA(this,e,t,!0)}invert(e){let t=this.sections.slice(),n=[];for(let r=0,i=0;r<t.length;r+=2){let o=t[r],s=t[r+1];if(s>=0){t[r]=s,t[r+1]=o;let a=r>>1;for(;n.length<a;)n.push(EA.empty);n.push(o?e.slice(i,i+o):EA.empty)}i+=o}return new UA(t,n)}compose(e){return this.empty?e:e.empty?this:KA(this,e,!0)}map(e,t=!1){return e.empty?this:JA(this,e,t,!0)}iterChanges(e,t=!1){XA(this,e,t)}get desc(){return WA.create(this.sections)}filter(e){let t=[],n=[],r=[],i=new ZA(this);e:for(let o=0,s=0;;){let a=o==e.length?1e9:e[o++];for(;s<a||s==a&&0==i.len;){if(i.done)break e;let e=Math.min(i.len,a-s);YA(r,e,-1);let o=-1==i.ins?-1:0==i.off?i.ins:0;YA(t,e,o),o>0&&GA(n,t,i.text),i.forward(e),s+=e}let l=e[o++];for(;s<l;){if(i.done)break e;let e=Math.min(i.len,l-s);YA(t,e,-1),YA(r,e,-1==i.ins?-1:0==i.off?i.ins:0),i.forward(e),s+=e}}return{changes:new UA(t,n),filtered:WA.create(r)}}toJSON(){let e=[];for(let t=0;t<this.sections.length;t+=2){let n=this.sections[t],r=this.sections[t+1];r<0?e.push(n):0==r?e.push([n]):e.push([n].concat(this.inserted[t>>1].toJSON()))}return e}static of(e,t,n){let r=[],i=[],o=0,s=null;function a(e=!1){if(!e&&!r.length)return;o<t&&YA(r,t-o,-1);let n=new UA(r,i);s=s?s.compose(n.map(s)):n,r=[],i=[],o=0}return function e(l){if(Array.isArray(l))for(let t of l)e(t);else if(l instanceof UA){if(l.length!=t)throw new RangeError(`Mismatched change set length (got ${l.length}, expected ${t})`);a(),s=s?s.compose(l.map(s)):l}else{let{from:e,to:s=e,insert:c}=l;if(e>s||e<0||s>t)throw new RangeError(`Invalid change range ${e} to ${s} (in doc of length ${t})`);let h=c?"string"==typeof c?EA.of(c.split(n||jA)):c:EA.empty,d=h.length;if(e==s&&0==d)return;e<o&&a(),e>o&&YA(r,e-o,-1),YA(r,s-e,d),GA(i,r,h),o=s}}(e),a(!s),s}static empty(e){return new UA(e?[e,-1]:[],[])}static fromJSON(e){if(!Array.isArray(e))throw new RangeError("Invalid JSON representation of ChangeSet");let t=[],n=[];for(let r=0;r<e.length;r++){let i=e[r];if("number"==typeof i)t.push(i,-1);else{if(!Array.isArray(i)||"number"!=typeof i[0]||i.some((e,t)=>t&&"string"!=typeof e))throw new RangeError("Invalid JSON representation of ChangeSet");if(1==i.length)t.push(i[0],0);else{for(;n.length<r;)n.push(EA.empty);n[r]=EA.of(i.slice(1)),t.push(i[0],n[r].length)}}}return new UA(t,n)}static createSet(e,t){return new UA(e,t)}}function YA(e,t,n,r=!1){if(0==t&&n<=0)return;let i=e.length-2;i>=0&&n<=0&&n==e[i+1]?e[i]+=t:i>=0&&0==t&&0==e[i]?e[i+1]+=n:r?(e[i]+=t,e[i+1]+=n):e.push(t,n)}function GA(e,t,n){if(0==n.length)return;let r=t.length-2>>1;if(r<e.length)e[e.length-1]=e[e.length-1].append(n);else{for(;e.length<r;)e.push(EA.empty);e.push(n)}}function XA(e,t,n){let r=e.inserted;for(let i=0,o=0,s=0;s<e.sections.length;){let a=e.sections[s++],l=e.sections[s++];if(l<0)i+=a,o+=a;else{let c=i,h=o,d=EA.empty;for(;c+=a,h+=l,l&&r&&(d=d.append(r[s-2>>1])),!(n||s==e.sections.length||e.sections[s+1]<0);)a=e.sections[s++],l=e.sections[s++];t(i,c,o,h,d),i=c,o=h}}}function JA(e,t,n,r=!1){let i=[],o=r?[]:null,s=new ZA(e),a=new ZA(t);for(let e=-1;;){if(s.done&&a.len||a.done&&s.len)throw new Error("Mismatched change set lengths");if(-1==s.ins&&-1==a.ins){let e=Math.min(s.len,a.len);YA(i,e,-1),s.forward(e),a.forward(e)}else if(a.ins>=0&&(s.ins<0||e==s.i||0==s.off&&(a.len<s.len||a.len==s.len&&!n))){let t=a.len;for(YA(i,a.ins,-1);t;){let n=Math.min(s.len,t);s.ins>=0&&e<s.i&&s.len<=n&&(YA(i,0,s.ins),o&&GA(o,i,s.text),e=s.i),s.forward(n),t-=n}a.next()}else{if(!(s.ins>=0)){if(s.done&&a.done)return o?UA.createSet(i,o):WA.create(i);throw new Error("Mismatched change set lengths")}{let t=0,n=s.len;for(;n;)if(-1==a.ins){let e=Math.min(n,a.len);t+=e,n-=e,a.forward(e)}else{if(!(0==a.ins&&a.len<n))break;n-=a.len,a.next()}YA(i,t,e<s.i?s.ins:0),o&&e<s.i&&GA(o,i,s.text),e=s.i,s.forward(s.len-n)}}}}function KA(e,t,n=!1){let r=[],i=n?[]:null,o=new ZA(e),s=new ZA(t);for(let e=!1;;){if(o.done&&s.done)return i?UA.createSet(r,i):WA.create(r);if(0==o.ins)YA(r,o.len,0,e),o.next();else if(0!=s.len||s.done){if(o.done||s.done)throw new Error("Mismatched change set lengths");{let t=Math.min(o.len2,s.len),n=r.length;if(-1==o.ins){let n=-1==s.ins?-1:s.off?0:s.ins;YA(r,t,n,e),i&&n&&GA(i,r,s.text)}else-1==s.ins?(YA(r,o.off?0:o.len,t,e),i&&GA(i,r,o.textBit(t))):(YA(r,o.off?0:o.len,s.off?0:s.ins,e),i&&!s.off&&GA(i,r,s.text));e=(o.ins>t||s.ins>=0&&s.len>t)&&(e||r.length>n),o.forward2(t),s.forward(t)}}else YA(r,0,s.ins,e),i&&GA(i,r,s.text),s.next()}}class ZA{constructor(e){this.set=e,this.i=0,this.next()}next(){let{sections:e}=this.set;this.i<e.length?(this.len=e[this.i++],this.ins=e[this.i++]):(this.len=0,this.ins=-2),this.off=0}get done(){return-2==this.ins}get len2(){return this.ins<0?this.len:this.ins}get text(){let{inserted:e}=this.set,t=this.i-2>>1;return t>=e.length?EA.empty:e[t]}textBit(e){let{inserted:t}=this.set,n=this.i-2>>1;return n>=t.length&&!e?EA.empty:t[n].slice(this.off,null==e?void 0:this.off+e)}forward(e){e==this.len?this.next():(this.len-=e,this.off+=e)}forward2(e){-1==this.ins?this.forward(e):e==this.ins?this.next():(this.ins-=e,this.off+=e)}}class ey{constructor(e,t,n){this.from=e,this.to=t,this.flags=n}get anchor(){return 32&this.flags?this.to:this.from}get head(){return 32&this.flags?this.from:this.to}get empty(){return this.from==this.to}get assoc(){return 8&this.flags?-1:16&this.flags?1:0}get bidiLevel(){let e=7&this.flags;return 7==e?null:e}get goalColumn(){let e=this.flags>>6;return 16777215==e?void 0:e}map(e,t=-1){let n,r;return this.empty?n=r=e.mapPos(this.from,t):(n=e.mapPos(this.from,1),r=e.mapPos(this.to,-1)),n==this.from&&r==this.to?this:new ey(n,r,this.flags)}extend(e,t=e){if(e<=this.anchor&&t>=this.anchor)return ty.range(e,t);let n=Math.abs(e-this.anchor)>Math.abs(t-this.anchor)?e:t;return ty.range(this.anchor,n)}eq(e,t=!1){return!(this.anchor!=e.anchor||this.head!=e.head||t&&this.empty&&this.assoc!=e.assoc)}toJSON(){return{anchor:this.anchor,head:this.head}}static fromJSON(e){if(!e||"number"!=typeof e.anchor||"number"!=typeof e.head)throw new RangeError("Invalid JSON representation for SelectionRange");return ty.range(e.anchor,e.head)}static create(e,t,n){return new ey(e,t,n)}}class ty{constructor(e,t){this.ranges=e,this.mainIndex=t}map(e,t=-1){return e.empty?this:ty.create(this.ranges.map(n=>n.map(e,t)),this.mainIndex)}eq(e,t=!1){if(this.ranges.length!=e.ranges.length||this.mainIndex!=e.mainIndex)return!1;for(let n=0;n<this.ranges.length;n++)if(!this.ranges[n].eq(e.ranges[n],t))return!1;return!0}get main(){return this.ranges[this.mainIndex]}asSingle(){return 1==this.ranges.length?this:new ty([this.main],0)}addRange(e,t=!0){return ty.create([e].concat(this.ranges),t?0:this.mainIndex+1)}replaceRange(e,t=this.mainIndex){let n=this.ranges.slice();return n[t]=e,ty.create(n,this.mainIndex)}toJSON(){return{ranges:this.ranges.map(e=>e.toJSON()),main:this.mainIndex}}static fromJSON(e){if(!e||!Array.isArray(e.ranges)||"number"!=typeof e.main||e.main>=e.ranges.length)throw new RangeError("Invalid JSON representation for EditorSelection");return new ty(e.ranges.map(e=>ey.fromJSON(e)),e.main)}static single(e,t=e){return new ty([ty.range(e,t)],0)}static create(e,t=0){if(0==e.length)throw new RangeError("A selection needs at least one range");for(let n=0,r=0;r<e.length;r++){let i=e[r];if(i.empty?i.from<=n:i.from<n)return ty.normalized(e.slice(),t);n=i.to}return new ty(e,t)}static cursor(e,t=0,n,r){return ey.create(e,e,(0==t?0:t<0?8:16)|(null==n?7:Math.min(6,n))|(null!=r?r:16777215)<<6)}static range(e,t,n,r){let i=(null!=n?n:16777215)<<6|(null==r?7:Math.min(6,r));return t<e?ey.create(t,e,48|i):ey.create(e,t,(t>e?8:0)|i)}static normalized(e,t=0){let n=e[t];e.sort((e,t)=>e.from-t.from),t=e.indexOf(n);for(let n=1;n<e.length;n++){let r=e[n],i=e[n-1];if(r.empty?r.from<=i.to:r.from<i.to){let o=i.from,s=Math.max(r.to,i.to);n<=t&&t--,e.splice(--n,2,r.anchor>r.head?ty.range(s,o):ty.range(o,s))}}return new ty(e,t)}}function ny(e,t){for(let n of e.ranges)if(n.to>t)throw new RangeError("Selection points outside of document")}let ry=0;class iy{constructor(e,t,n,r,i){this.combine=e,this.compareInput=t,this.compare=n,this.isStatic=r,this.id=ry++,this.default=e([]),this.extensions="function"==typeof i?i(this):i}get reader(){return this}static define(e={}){return new iy(e.combine||(e=>e),e.compareInput||((e,t)=>e===t),e.compare||(e.combine?(e,t)=>e===t:oy),!!e.static,e.enables)}of(e){return new sy([],this,0,e)}compute(e,t){if(this.isStatic)throw new Error("Can't compute a static facet");return new sy(e,this,1,t)}computeN(e,t){if(this.isStatic)throw new Error("Can't compute a static facet");return new sy(e,this,2,t)}from(e,t){return t||(t=e=>e),this.compute([e],n=>t(n.field(e)))}}function oy(e,t){return e==t||e.length==t.length&&e.every((e,n)=>e===t[n])}class sy{constructor(e,t,n,r){this.dependencies=e,this.facet=t,this.type=n,this.value=r,this.id=ry++}dynamicSlot(e){var t;let n=this.value,r=this.facet.compareInput,i=this.id,o=e[i]>>1,s=2==this.type,a=!1,l=!1,c=[];for(let n of this.dependencies)"doc"==n?a=!0:"selection"==n?l=!0:1&(null!==(t=e[n.id])&&void 0!==t?t:1)||c.push(e[n.id]);return{create:e=>(e.values[o]=n(e),1),update(e,t){if(a&&t.docChanged||l&&(t.docChanged||t.selection)||ly(e,c)){let t=n(e);if(s?!ay(t,e.values[o],r):!r(t,e.values[o]))return e.values[o]=t,1}return 0},reconfigure:(e,t)=>{let a,l=t.config.address[i];if(null!=l){let i=xy(t,l);if(this.dependencies.every(n=>n instanceof iy?t.facet(n)===e.facet(n):!(n instanceof dy)||t.field(n,!1)==e.field(n,!1))||(s?ay(a=n(e),i,r):r(a=n(e),i)))return e.values[o]=i,0}else a=n(e);return e.values[o]=a,1}}}}function ay(e,t,n){if(e.length!=t.length)return!1;for(let r=0;r<e.length;r++)if(!n(e[r],t[r]))return!1;return!0}function ly(e,t){let n=!1;for(let r of t)1&Cy(e,r)&&(n=!0);return n}function cy(e,t,n){let r=n.map(t=>e[t.id]),i=n.map(e=>e.type),o=r.filter(e=>!(1&e)),s=e[t.id]>>1;function a(e){let n=[];for(let t=0;t<r.length;t++){let o=xy(e,r[t]);if(2==i[t])for(let e of o)n.push(e);else n.push(o)}return t.combine(n)}return{create(e){for(let t of r)Cy(e,t);return e.values[s]=a(e),1},update(e,n){if(!ly(e,o))return 0;let r=a(e);return t.compare(r,e.values[s])?0:(e.values[s]=r,1)},reconfigure(e,i){let o=ly(e,r),l=i.config.facets[t.id],c=i.facet(t);if(l&&!o&&oy(n,l))return e.values[s]=c,0;let h=a(e);return t.compare(h,c)?(e.values[s]=c,0):(e.values[s]=h,1)}}}const hy=iy.define({static:!0});class dy{constructor(e,t,n,r,i){this.id=e,this.createF=t,this.updateF=n,this.compareF=r,this.spec=i,this.provides=void 0}static define(e){let t=new dy(ry++,e.create,e.update,e.compare||((e,t)=>e===t),e);return e.provide&&(t.provides=e.provide(t)),t}create(e){let t=e.facet(hy).find(e=>e.field==this);return((null==t?void 0:t.create)||this.createF)(e)}slot(e){let t=e[this.id]>>1;return{create:e=>(e.values[t]=this.create(e),1),update:(e,n)=>{let r=e.values[t],i=this.updateF(r,n);return this.compareF(r,i)?0:(e.values[t]=i,1)},reconfigure:(e,n)=>{let r,i=e.facet(hy),o=n.facet(hy);return(r=i.find(e=>e.field==this))&&r!=o.find(e=>e.field==this)?(e.values[t]=r.create(e),1):null!=n.config.address[this.id]?(e.values[t]=n.field(this),0):(e.values[t]=this.create(e),1)}}}init(e){return[this,hy.of({field:this,create:e})]}get extension(){return this}}const uy=4,py=3,fy=2,gy=1;function my(e){return t=>new by(t,e)}const vy={highest:my(0),high:my(gy),default:my(fy),low:my(py),lowest:my(uy)};class by{constructor(e,t){this.inner=e,this.prec=t}}class Ay{of(e){return new yy(this,e)}reconfigure(e){return Ay.reconfigure.of({compartment:this,extension:e})}get(e){return e.config.compartments.get(this)}}class yy{constructor(e,t){this.compartment=e,this.inner=t}}class wy{constructor(e,t,n,r,i,o){for(this.base=e,this.compartments=t,this.dynamicSlots=n,this.address=r,this.staticValues=i,this.facets=o,this.statusTemplate=[];this.statusTemplate.length<n.length;)this.statusTemplate.push(0)}staticFacet(e){let t=this.address[e.id];return null==t?e.default:this.staticValues[t>>1]}static resolve(e,t,n){let r=[],i=Object.create(null),o=new Map;for(let n of function(e,t,n){let r=[[],[],[],[],[]],i=new Map;function o(e,s){let a=i.get(e);if(null!=a){if(a<=s)return;let t=r[a].indexOf(e);t>-1&&r[a].splice(t,1),e instanceof yy&&n.delete(e.compartment)}if(i.set(e,s),Array.isArray(e))for(let t of e)o(t,s);else if(e instanceof yy){if(n.has(e.compartment))throw new RangeError("Duplicate use of compartment in extensions");let r=t.get(e.compartment)||e.inner;n.set(e.compartment,r),o(r,s)}else if(e instanceof by)o(e.inner,e.prec);else if(e instanceof dy)r[s].push(e),e.provides&&o(e.provides,s);else if(e instanceof sy)r[s].push(e),e.facet.extensions&&o(e.facet.extensions,fy);else{let t=e.extension;if(!t)throw new Error(`Unrecognized extension value in extension set (${e}). This sometimes happens because multiple instances of @codemirror/state are loaded, breaking instanceof checks.`);o(t,s)}}return o(e,fy),r.reduce((e,t)=>e.concat(t))}(e,t,o))n instanceof dy?r.push(n):(i[n.facet.id]||(i[n.facet.id]=[])).push(n);let s=Object.create(null),a=[],l=[];for(let e of r)s[e.id]=l.length<<1,l.push(t=>e.slot(t));let c=null==n?void 0:n.config.facets;for(let e in i){let t=i[e],r=t[0].facet,o=c&&c[e]||[];if(t.every(e=>0==e.type))if(s[r.id]=a.length<<1|1,oy(o,t))a.push(n.facet(r));else{let e=r.combine(t.map(e=>e.value));a.push(n&&r.compare(e,n.facet(r))?n.facet(r):e)}else{for(let e of t)0==e.type?(s[e.id]=a.length<<1|1,a.push(e.value)):(s[e.id]=l.length<<1,l.push(t=>e.dynamicSlot(t)));s[r.id]=l.length<<1,l.push(e=>cy(e,r,t))}}let h=l.map(e=>e(s));return new wy(e,o,h,s,a,i)}}function Cy(e,t){if(1&t)return 2;let n=t>>1,r=e.status[n];if(4==r)throw new Error("Cyclic dependency between fields and/or facets");if(2&r)return r;e.status[n]=4;let i=e.computeSlot(e,e.config.dynamicSlots[n]);return e.status[n]=2|i}function xy(e,t){return 1&t?e.config.staticValues[t>>1]:e.values[t>>1]}const ky=iy.define(),Sy=iy.define({combine:e=>e.some(e=>e),static:!0}),Oy=iy.define({combine:e=>e.length?e[0]:void 0,static:!0}),By=iy.define(),_y=iy.define(),Ty=iy.define(),Ey=iy.define({combine:e=>!!e.length&&e[0]});class My{constructor(e,t){this.type=e,this.value=t}static define(){return new Dy}}class Dy{of(e){return new My(this,e)}}class Py{constructor(e){this.map=e}of(e){return new Ry(this,e)}}class Ry{constructor(e,t){this.type=e,this.value=t}map(e){let t=this.type.map(this.value,e);return void 0===t?void 0:t==this.value?this:new Ry(this.type,t)}is(e){return this.type==e}static define(e={}){return new Py(e.map||(e=>e))}static mapEffects(e,t){if(!e.length)return e;let n=[];for(let r of e){let e=r.map(t);e&&n.push(e)}return n}}Ry.reconfigure=Ry.define(),Ry.appendConfig=Ry.define();class Iy{constructor(e,t,n,r,i,o){this.startState=e,this.changes=t,this.selection=n,this.effects=r,this.annotations=i,this.scrollIntoView=o,this._doc=null,this._state=null,n&&ny(n,t.newLength),i.some(e=>e.type==Iy.time)||(this.annotations=i.concat(Iy.time.of(Date.now())))}static create(e,t,n,r,i,o){return new Iy(e,t,n,r,i,o)}get newDoc(){return this._doc||(this._doc=this.changes.apply(this.startState.doc))}get newSelection(){return this.selection||this.startState.selection.map(this.changes)}get state(){return this._state||this.startState.applyTransaction(this),this._state}annotation(e){for(let t of this.annotations)if(t.type==e)return t.value}get docChanged(){return!this.changes.empty}get reconfigured(){return this.startState.config!=this.state.config}isUserEvent(e){let t=this.annotation(Iy.userEvent);return!(!t||!(t==e||t.length>e.length&&t.slice(0,e.length)==e&&"."==t[e.length]))}}function Ly(e,t){let n=[];for(let r=0,i=0;;){let o,s;if(r<e.length&&(i==t.length||t[i]>=e[r]))o=e[r++],s=e[r++];else{if(!(i<t.length))return n;o=t[i++],s=t[i++]}!n.length||n[n.length-1]<o?n.push(o,s):n[n.length-1]<s&&(n[n.length-1]=s)}}function Ny(e,t,n){var r;let i,o,s;return n?(i=t.changes,o=UA.empty(t.changes.length),s=e.changes.compose(t.changes)):(i=t.changes.map(e.changes),o=e.changes.mapDesc(t.changes,!0),s=e.changes.compose(i)),{changes:s,selection:t.selection?t.selection.map(o):null===(r=e.selection)||void 0===r?void 0:r.map(i),effects:Ry.mapEffects(e.effects,i).concat(Ry.mapEffects(t.effects,o)),annotations:e.annotations.length?e.annotations.concat(t.annotations):t.annotations,scrollIntoView:e.scrollIntoView||t.scrollIntoView}}function Fy(e,t,n){let r=t.selection,i=zy(t.annotations);return t.userEvent&&(i=i.concat(Iy.userEvent.of(t.userEvent))),{changes:t.changes instanceof UA?t.changes:UA.of(t.changes||[],n,e.facet(Oy)),selection:r&&(r instanceof ty?r:ty.single(r.anchor,r.head)),effects:zy(t.effects),annotations:i,scrollIntoView:!!t.scrollIntoView}}function Qy(e,t,n){let r=Fy(e,t.length?t[0]:{},e.doc.length);t.length&&!1===t[0].filter&&(n=!1);for(let i=1;i<t.length;i++){!1===t[i].filter&&(n=!1);let o=!!t[i].sequential;r=Ny(r,Fy(e,t[i],o?r.changes.newLength:e.doc.length),o)}let i=Iy.create(e,r.changes,r.selection,r.effects,r.annotations,r.scrollIntoView);return function(e){let t=e.startState,n=t.facet(Ty),r=e;for(let i=n.length-1;i>=0;i--){let o=n[i](e);o&&Object.keys(o).length&&(r=Ny(r,Fy(t,o,e.changes.newLength),!0))}return r==e?e:Iy.create(t,e.changes,e.selection,r.effects,r.annotations,r.scrollIntoView)}(n?function(e){let t=e.startState,n=!0;for(let r of t.facet(By)){let t=r(e);if(!1===t){n=!1;break}Array.isArray(t)&&(n=!0===n?t:Ly(n,t))}if(!0!==n){let r,i;if(!1===n)i=e.changes.invertedDesc,r=UA.empty(t.doc.length);else{let t=e.changes.filter(n);r=t.changes,i=t.filtered.mapDesc(t.changes).invertedDesc}e=Iy.create(t,r,e.selection&&e.selection.map(i),Ry.mapEffects(e.effects,i),e.annotations,e.scrollIntoView)}let r=t.facet(_y);for(let n=r.length-1;n>=0;n--){let i=r[n](e);e=i instanceof Iy?i:Array.isArray(i)&&1==i.length&&i[0]instanceof Iy?i[0]:Qy(t,zy(i),!1)}return e}(i):i)}Iy.time=My.define(),Iy.userEvent=My.define(),Iy.addToHistory=My.define(),Iy.remote=My.define();const Vy=[];function zy(e){return null==e?Vy:Array.isArray(e)?e:[e]}var $y=function(e){return e[e.Word=0]="Word",e[e.Space=1]="Space",e[e.Other=2]="Other",e}($y||($y={}));const Hy=/[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;let jy;try{jy=new RegExp("[\\p{Alphabetic}\\p{Number}_]","u")}catch(e){}function qy(e){return t=>{if(!/\S/.test(t))return $y.Space;if(function(e){if(jy)return jy.test(e);for(let t=0;t<e.length;t++){let n=e[t];if(/\w/.test(n)||n>""&&(n.toUpperCase()!=n.toLowerCase()||Hy.test(n)))return!0}return!1}(t))return $y.Word;for(let n=0;n<e.length;n++)if(t.indexOf(e[n])>-1)return $y.Word;return $y.Other}}class Wy{constructor(e,t,n,r,i,o){this.config=e,this.doc=t,this.selection=n,this.values=r,this.status=e.statusTemplate.slice(),this.computeSlot=i,o&&(o._state=this);for(let e=0;e<this.config.dynamicSlots.length;e++)Cy(this,e<<1);this.computeSlot=null}field(e,t=!0){let n=this.config.address[e.id];if(null!=n)return Cy(this,n),xy(this,n);if(t)throw new RangeError("Field is not present in this state")}update(...e){return Qy(this,e,!0)}applyTransaction(e){let t,n=this.config,{base:r,compartments:i}=n;for(let t of e.effects)t.is(Ay.reconfigure)?(n&&(i=new Map,n.compartments.forEach((e,t)=>i.set(t,e)),n=null),i.set(t.value.compartment,t.value.extension)):t.is(Ry.reconfigure)?(n=null,r=t.value):t.is(Ry.appendConfig)&&(n=null,r=zy(r).concat(t.value));if(n)t=e.startState.values.slice();else{n=wy.resolve(r,i,this),t=new Wy(n,this.doc,this.selection,n.dynamicSlots.map(()=>null),(e,t)=>t.reconfigure(e,this),null).values}let o=e.startState.facet(Sy)?e.newSelection:e.newSelection.asSingle();new Wy(n,e.newDoc,o,t,(t,n)=>n.update(t,e),e)}replaceSelection(e){return"string"==typeof e&&(e=this.toText(e)),this.changeByRange(t=>({changes:{from:t.from,to:t.to,insert:e},range:ty.cursor(t.from+e.length)}))}changeByRange(e){let t=this.selection,n=e(t.ranges[0]),r=this.changes(n.changes),i=[n.range],o=zy(n.effects);for(let n=1;n<t.ranges.length;n++){let s=e(t.ranges[n]),a=this.changes(s.changes),l=a.map(r);for(let e=0;e<n;e++)i[e]=i[e].map(l);let c=r.mapDesc(a,!0);i.push(s.range.map(c)),r=r.compose(l),o=Ry.mapEffects(o,l).concat(Ry.mapEffects(zy(s.effects),c))}return{changes:r,selection:ty.create(i,t.mainIndex),effects:o}}changes(e=[]){return e instanceof UA?e:UA.of(e,this.doc.length,this.facet(Wy.lineSeparator))}toText(e){return EA.of(e.split(this.facet(Wy.lineSeparator)||jA))}sliceDoc(e=0,t=this.doc.length){return this.doc.sliceString(e,t,this.lineBreak)}facet(e){let t=this.config.address[e.id];return null==t?e.default:(Cy(this,t),xy(this,t))}toJSON(e){let t={doc:this.sliceDoc(),selection:this.selection.toJSON()};if(e)for(let n in e){let r=e[n];r instanceof dy&&null!=this.config.address[r.id]&&(t[n]=r.spec.toJSON(this.field(e[n]),this))}return t}static fromJSON(e,t={},n){if(!e||"string"!=typeof e.doc)throw new RangeError("Invalid JSON representation for EditorState");let r=[];if(n)for(let t in n)if(Object.prototype.hasOwnProperty.call(e,t)){let i=n[t],o=e[t];r.push(i.init(e=>i.spec.fromJSON(o,e)))}return Wy.create({doc:e.doc,selection:ty.fromJSON(e.selection),extensions:t.extensions?r.concat([t.extensions]):r})}static create(e={}){let t=wy.resolve(e.extensions||[],new Map),n=e.doc instanceof EA?e.doc:EA.of((e.doc||"").split(t.staticFacet(Wy.lineSeparator)||jA)),r=e.selection?e.selection instanceof ty?e.selection:ty.single(e.selection.anchor,e.selection.head):ty.single(0);return ny(r,n.length),t.staticFacet(Sy)||(r=r.asSingle()),new Wy(t,n,r,t.dynamicSlots.map(()=>null),(e,t)=>t.create(e),null)}get tabSize(){return this.facet(Wy.tabSize)}get lineBreak(){return this.facet(Wy.lineSeparator)||"\n"}get readOnly(){return this.facet(Ey)}phrase(e,...t){for(let t of this.facet(Wy.phrases))if(Object.prototype.hasOwnProperty.call(t,e)){e=t[e];break}return t.length&&(e=e.replace(/\$(\$|\d*)/g,(e,n)=>{if("$"==n)return"$";let r=+(n||1);return!r||r>t.length?e:t[r-1]})),e}languageDataAt(e,t,n=-1){let r=[];for(let i of this.facet(ky))for(let o of i(this,t,n))Object.prototype.hasOwnProperty.call(o,e)&&r.push(o[e]);return r}charCategorizer(e){return qy(this.languageDataAt("wordChars",e).join(""))}wordAt(e){let{text:t,from:n,length:r}=this.doc.lineAt(e),i=this.charCategorizer(e),o=e-n,s=e-n;for(;o>0;){let e=VA(t,o,!1);if(i(t.slice(e,o))!=$y.Word)break;o=e}for(;s<r;){let e=VA(t,s);if(i(t.slice(s,e))!=$y.Word)break;s=e}return o==s?null:ty.range(o+n,s+n)}}function Uy(e,t,n={}){let r={};for(let t of e)for(let e of Object.keys(t)){let i=t[e],o=r[e];if(void 0===o)r[e]=i;else if(o===i||void 0===i);else{if(!Object.hasOwnProperty.call(n,e))throw new Error("Config merge conflict for field "+e);r[e]=n[e](o,i)}}for(let e in t)void 0===r[e]&&(r[e]=t[e]);return r}Wy.allowMultipleSelections=Sy,Wy.tabSize=iy.define({combine:e=>e.length?e[0]:4}),Wy.lineSeparator=Oy,Wy.readOnly=Ey,Wy.phrases=iy.define({compare(e,t){let n=Object.keys(e),r=Object.keys(t);return n.length==r.length&&n.every(n=>e[n]==t[n])}}),Wy.languageData=ky,Wy.changeFilter=By,Wy.transactionFilter=_y,Wy.transactionExtender=Ty,Ay.reconfigure=Ry.define();class Yy{eq(e){return this==e}range(e,t=e){return Gy.create(e,t,this)}}Yy.prototype.startSide=Yy.prototype.endSide=0,Yy.prototype.point=!1,Yy.prototype.mapMode=qA.TrackDel;class Gy{constructor(e,t,n){this.from=e,this.to=t,this.value=n}static create(e,t,n){return new Gy(e,t,n)}}function Xy(e,t){return e.from-t.from||e.value.startSide-t.value.startSide}class Jy{constructor(e,t,n,r){this.from=e,this.to=t,this.value=n,this.maxPoint=r}get length(){return this.to[this.to.length-1]}findIndex(e,t,n,r=0){let i=n?this.to:this.from;for(let o=r,s=i.length;;){if(o==s)return o;let r=o+s>>1,a=i[r]-e||(n?this.value[r].endSide:this.value[r].startSide)-t;if(r==o)return a>=0?o:s;a>=0?s=r:o=r+1}}between(e,t,n,r){for(let i=this.findIndex(t,-1e9,!0),o=this.findIndex(n,1e9,!1,i);i<o;i++)if(!1===r(this.from[i]+e,this.to[i]+e,this.value[i]))return!1}map(e,t){let n=[],r=[],i=[],o=-1,s=-1;for(let a=0;a<this.value.length;a++){let l,c,h=this.value[a],d=this.from[a]+e,u=this.to[a]+e;if(d==u){let e=t.mapPos(d,h.startSide,h.mapMode);if(null==e)continue;if(l=c=e,h.startSide!=h.endSide&&(c=t.mapPos(d,h.endSide),c<l))continue}else if(l=t.mapPos(d,h.startSide),c=t.mapPos(u,h.endSide),l>c||l==c&&h.startSide>0&&h.endSide<=0)continue;(c-l||h.endSide-h.startSide)<0||(o<0&&(o=l),h.point&&(s=Math.max(s,c-l)),n.push(h),r.push(l-o),i.push(c-o))}return{mapped:n.length?new Jy(r,i,n,s):null,pos:o}}}class Ky{constructor(e,t,n,r){this.chunkPos=e,this.chunk=t,this.nextLayer=n,this.maxPoint=r}static create(e,t,n,r){return new Ky(e,t,n,r)}get length(){let e=this.chunk.length-1;return e<0?0:Math.max(this.chunkEnd(e),this.nextLayer.length)}get size(){if(this.isEmpty)return 0;let e=this.nextLayer.size;for(let t of this.chunk)e+=t.value.length;return e}chunkEnd(e){return this.chunkPos[e]+this.chunk[e].length}update(e){let{add:t=[],sort:n=!1,filterFrom:r=0,filterTo:i=this.length}=e,o=e.filter;if(0==t.length&&!o)return this;if(n&&(t=t.slice().sort(Xy)),this.isEmpty)return t.length?Ky.of(t):this;let s=new tw(this,null,-1).goto(0),a=0,l=[],c=new Zy;for(;s.value||a<t.length;)if(a<t.length&&(s.from-t[a].from||s.startSide-t[a].value.startSide)>=0){let e=t[a++];c.addInner(e.from,e.to,e.value)||l.push(e)}else 1==s.rangeIndex&&s.chunkIndex<this.chunk.length&&(a==t.length||this.chunkEnd(s.chunkIndex)<t[a].from)&&(!o||r>this.chunkEnd(s.chunkIndex)||i<this.chunkPos[s.chunkIndex])&&c.addChunk(this.chunkPos[s.chunkIndex],this.chunk[s.chunkIndex])?s.nextChunk():((!o||r>s.to||i<s.from||o(s.from,s.to,s.value))&&(c.addInner(s.from,s.to,s.value)||l.push(Gy.create(s.from,s.to,s.value))),s.next());return c.finishInner(this.nextLayer.isEmpty&&!l.length?Ky.empty:this.nextLayer.update({add:l,filter:o,filterFrom:r,filterTo:i}))}map(e){if(e.empty||this.isEmpty)return this;let t=[],n=[],r=-1;for(let i=0;i<this.chunk.length;i++){let o=this.chunkPos[i],s=this.chunk[i],a=e.touchesRange(o,o+s.length);if(!1===a)r=Math.max(r,s.maxPoint),t.push(s),n.push(e.mapPos(o));else if(!0===a){let{mapped:i,pos:a}=s.map(o,e);i&&(r=Math.max(r,i.maxPoint),t.push(i),n.push(a))}}let i=this.nextLayer.map(e);return 0==t.length?i:new Ky(n,t,i||Ky.empty,r)}between(e,t,n){if(!this.isEmpty){for(let r=0;r<this.chunk.length;r++){let i=this.chunkPos[r],o=this.chunk[r];if(t>=i&&e<=i+o.length&&!1===o.between(i,e-i,t-i,n))return}this.nextLayer.between(e,t,n)}}iter(e=0){return nw.from([this]).goto(e)}get isEmpty(){return this.nextLayer==this}static iter(e,t=0){return nw.from(e).goto(t)}static compare(e,t,n,r,i=-1){let o=e.filter(e=>e.maxPoint>0||!e.isEmpty&&e.maxPoint>=i),s=t.filter(e=>e.maxPoint>0||!e.isEmpty&&e.maxPoint>=i),a=ew(o,s,n),l=new iw(o,a,i),c=new iw(s,a,i);n.iterGaps((e,t,n)=>ow(l,e,c,t,n,r)),n.empty&&0==n.length&&ow(l,0,c,0,0,r)}static eq(e,t,n=0,r){null==r&&(r=999999999);let i=e.filter(e=>!e.isEmpty&&t.indexOf(e)<0),o=t.filter(t=>!t.isEmpty&&e.indexOf(t)<0);if(i.length!=o.length)return!1;if(!i.length)return!0;let s=ew(i,o),a=new iw(i,s,0).goto(n),l=new iw(o,s,0).goto(n);for(;;){if(a.to!=l.to||!sw(a.active,l.active)||a.point&&(!l.point||!a.point.eq(l.point)))return!1;if(a.to>r)return!0;a.next(),l.next()}}static spans(e,t,n,r,i=-1){let o=new iw(e,null,i).goto(t),s=t,a=o.openStart;for(;;){let e=Math.min(o.to,n);if(o.point){let n=o.activeForPoint(o.to),i=o.pointFrom<t?n.length+1:o.point.startSide<0?n.length:Math.min(n.length,a);r.point(s,e,o.point,n,i,o.pointRank),a=Math.min(o.openEnd(e),n.length)}else e>s&&(r.span(s,e,o.active,a),a=o.openEnd(e));if(o.to>n)return a+(o.point&&o.to>n?1:0);s=o.to,o.next()}}static of(e,t=!1){let n=new Zy;for(let r of e instanceof Gy?[e]:t?function(e){if(e.length>1)for(let t=e[0],n=1;n<e.length;n++){let r=e[n];if(Xy(t,r)>0)return e.slice().sort(Xy);t=r}return e}(e):e)n.add(r.from,r.to,r.value);return n.finish()}static join(e){if(!e.length)return Ky.empty;let t=e[e.length-1];for(let n=e.length-2;n>=0;n--)for(let r=e[n];r!=Ky.empty;r=r.nextLayer)t=new Ky(r.chunkPos,r.chunk,t,Math.max(r.maxPoint,t.maxPoint));return t}}Ky.empty=new Ky([],[],null,-1),Ky.empty.nextLayer=Ky.empty;class Zy{finishChunk(e){this.chunks.push(new Jy(this.from,this.to,this.value,this.maxPoint)),this.chunkPos.push(this.chunkStart),this.chunkStart=-1,this.setMaxPoint=Math.max(this.setMaxPoint,this.maxPoint),this.maxPoint=-1,e&&(this.from=[],this.to=[],this.value=[])}constructor(){this.chunks=[],this.chunkPos=[],this.chunkStart=-1,this.last=null,this.lastFrom=-1e9,this.lastTo=-1e9,this.from=[],this.to=[],this.value=[],this.maxPoint=-1,this.setMaxPoint=-1,this.nextLayer=null}add(e,t,n){this.addInner(e,t,n)||(this.nextLayer||(this.nextLayer=new Zy)).add(e,t,n)}addInner(e,t,n){let r=e-this.lastTo||n.startSide-this.last.endSide;if(r<=0&&(e-this.lastFrom||n.startSide-this.last.startSide)<0)throw new Error("Ranges must be added sorted by `from` position and `startSide`");return!(r<0)&&(250==this.from.length&&this.finishChunk(!0),this.chunkStart<0&&(this.chunkStart=e),this.from.push(e-this.chunkStart),this.to.push(t-this.chunkStart),this.last=n,this.lastFrom=e,this.lastTo=t,this.value.push(n),n.point&&(this.maxPoint=Math.max(this.maxPoint,t-e)),!0)}addChunk(e,t){if((e-this.lastTo||t.value[0].startSide-this.last.endSide)<0)return!1;this.from.length&&this.finishChunk(!0),this.setMaxPoint=Math.max(this.setMaxPoint,t.maxPoint),this.chunks.push(t),this.chunkPos.push(e);let n=t.value.length-1;return this.last=t.value[n],this.lastFrom=t.from[n]+e,this.lastTo=t.to[n]+e,!0}finish(){return this.finishInner(Ky.empty)}finishInner(e){if(this.from.length&&this.finishChunk(!1),0==this.chunks.length)return e;let t=Ky.create(this.chunkPos,this.chunks,this.nextLayer?this.nextLayer.finishInner(e):e,this.setMaxPoint);return this.from=null,t}}function ew(e,t,n){let r=new Map;for(let t of e)for(let e=0;e<t.chunk.length;e++)t.chunk[e].maxPoint<=0&&r.set(t.chunk[e],t.chunkPos[e]);let i=new Set;for(let e of t)for(let t=0;t<e.chunk.length;t++){let o=r.get(e.chunk[t]);null==o||(n?n.mapPos(o):o)!=e.chunkPos[t]||(null==n?void 0:n.touchesRange(o,o+e.chunk[t].length))||i.add(e.chunk[t])}return i}class tw{constructor(e,t,n,r=0){this.layer=e,this.skip=t,this.minPoint=n,this.rank=r}get startSide(){return this.value?this.value.startSide:0}get endSide(){return this.value?this.value.endSide:0}goto(e,t=-1e9){return this.chunkIndex=this.rangeIndex=0,this.gotoInner(e,t,!1),this}gotoInner(e,t,n){for(;this.chunkIndex<this.layer.chunk.length;){let t=this.layer.chunk[this.chunkIndex];if(!(this.skip&&this.skip.has(t)||this.layer.chunkEnd(this.chunkIndex)<e||t.maxPoint<this.minPoint))break;this.chunkIndex++,n=!1}if(this.chunkIndex<this.layer.chunk.length){let r=this.layer.chunk[this.chunkIndex].findIndex(e-this.layer.chunkPos[this.chunkIndex],t,!0);(!n||this.rangeIndex<r)&&this.setRangeIndex(r)}this.next()}forward(e,t){(this.to-e||this.endSide-t)<0&&this.gotoInner(e,t,!0)}next(){for(;;){if(this.chunkIndex==this.layer.chunk.length){this.from=this.to=1e9,this.value=null;break}{let e=this.layer.chunkPos[this.chunkIndex],t=this.layer.chunk[this.chunkIndex],n=e+t.from[this.rangeIndex];if(this.from=n,this.to=e+t.to[this.rangeIndex],this.value=t.value[this.rangeIndex],this.setRangeIndex(this.rangeIndex+1),this.minPoint<0||this.value.point&&this.to-this.from>=this.minPoint)break}}}setRangeIndex(e){if(e==this.layer.chunk[this.chunkIndex].value.length){if(this.chunkIndex++,this.skip)for(;this.chunkIndex<this.layer.chunk.length&&this.skip.has(this.layer.chunk[this.chunkIndex]);)this.chunkIndex++;this.rangeIndex=0}else this.rangeIndex=e}nextChunk(){this.chunkIndex++,this.rangeIndex=0,this.next()}compare(e){return this.from-e.from||this.startSide-e.startSide||this.rank-e.rank||this.to-e.to||this.endSide-e.endSide}}class nw{constructor(e){this.heap=e}static from(e,t=null,n=-1){let r=[];for(let i=0;i<e.length;i++)for(let o=e[i];!o.isEmpty;o=o.nextLayer)o.maxPoint>=n&&r.push(new tw(o,t,n,i));return 1==r.length?r[0]:new nw(r)}get startSide(){return this.value?this.value.startSide:0}goto(e,t=-1e9){for(let n of this.heap)n.goto(e,t);for(let e=this.heap.length>>1;e>=0;e--)rw(this.heap,e);return this.next(),this}forward(e,t){for(let n of this.heap)n.forward(e,t);for(let e=this.heap.length>>1;e>=0;e--)rw(this.heap,e);(this.to-e||this.value.endSide-t)<0&&this.next()}next(){if(0==this.heap.length)this.from=this.to=1e9,this.value=null,this.rank=-1;else{let e=this.heap[0];this.from=e.from,this.to=e.to,this.value=e.value,this.rank=e.rank,e.value&&e.next(),rw(this.heap,0)}}}function rw(e,t){for(let n=e[t];;){let r=1+(t<<1);if(r>=e.length)break;let i=e[r];if(r+1<e.length&&i.compare(e[r+1])>=0&&(i=e[r+1],r++),n.compare(i)<0)break;e[r]=n,e[t]=i,t=r}}class iw{constructor(e,t,n){this.minPoint=n,this.active=[],this.activeTo=[],this.activeRank=[],this.minActive=-1,this.point=null,this.pointFrom=0,this.pointRank=0,this.to=-1e9,this.endSide=0,this.openStart=-1,this.cursor=nw.from(e,t,n)}goto(e,t=-1e9){return this.cursor.goto(e,t),this.active.length=this.activeTo.length=this.activeRank.length=0,this.minActive=-1,this.to=e,this.endSide=t,this.openStart=-1,this.next(),this}forward(e,t){for(;this.minActive>-1&&(this.activeTo[this.minActive]-e||this.active[this.minActive].endSide-t)<0;)this.removeActive(this.minActive);this.cursor.forward(e,t)}removeActive(e){aw(this.active,e),aw(this.activeTo,e),aw(this.activeRank,e),this.minActive=cw(this.active,this.activeTo)}addActive(e){let t=0,{value:n,to:r,rank:i}=this.cursor;for(;t<this.activeRank.length&&(i-this.activeRank[t]||r-this.activeTo[t])>0;)t++;lw(this.active,t,n),lw(this.activeTo,t,r),lw(this.activeRank,t,i),e&&lw(e,t,this.cursor.from),this.minActive=cw(this.active,this.activeTo)}next(){let e=this.to,t=this.point;this.point=null;let n=this.openStart<0?[]:null;for(;;){let r=this.minActive;if(r>-1&&(this.activeTo[r]-this.cursor.from||this.active[r].endSide-this.cursor.startSide)<0){if(this.activeTo[r]>e){this.to=this.activeTo[r],this.endSide=this.active[r].endSide;break}this.removeActive(r),n&&aw(n,r)}else{if(!this.cursor.value){this.to=this.endSide=1e9;break}if(this.cursor.from>e){this.to=this.cursor.from,this.endSide=this.cursor.startSide;break}{let e=this.cursor.value;if(e.point){if(!(t&&this.cursor.to==this.to&&this.cursor.from<this.cursor.to)){this.point=e,this.pointFrom=this.cursor.from,this.pointRank=this.cursor.rank,this.to=this.cursor.to,this.endSide=e.endSide,this.cursor.next(),this.forward(this.to,this.endSide);break}this.cursor.next()}else this.addActive(n),this.cursor.next()}}}if(n){this.openStart=0;for(let t=n.length-1;t>=0&&n[t]<e;t--)this.openStart++}}activeForPoint(e){if(!this.active.length)return this.active;let t=[];for(let n=this.active.length-1;n>=0&&!(this.activeRank[n]<this.pointRank);n--)(this.activeTo[n]>e||this.activeTo[n]==e&&this.active[n].endSide>=this.point.endSide)&&t.push(this.active[n]);return t.reverse()}openEnd(e){let t=0;for(let n=this.activeTo.length-1;n>=0&&this.activeTo[n]>e;n--)t++;return t}}function ow(e,t,n,r,i,o){e.goto(t),n.goto(r);let s=r+i,a=r,l=r-t;for(;;){let t=e.to+l-n.to,r=t||e.endSide-n.endSide,i=r<0?e.to+l:n.to,c=Math.min(i,s);if(e.point||n.point?e.point&&n.point&&(e.point==n.point||e.point.eq(n.point))&&sw(e.activeForPoint(e.to),n.activeForPoint(n.to))||o.comparePoint(a,c,e.point,n.point):c>a&&!sw(e.active,n.active)&&o.compareRange(a,c,e.active,n.active),i>s)break;(t||e.openEnd!=n.openEnd)&&o.boundChange&&o.boundChange(i),a=i,r<=0&&e.next(),r>=0&&n.next()}}function sw(e,t){if(e.length!=t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!=t[n]&&!e[n].eq(t[n]))return!1;return!0}function aw(e,t){for(let n=t,r=e.length-1;n<r;n++)e[n]=e[n+1];e.pop()}function lw(e,t,n){for(let n=e.length-1;n>=t;n--)e[n+1]=e[n];e[t]=n}function cw(e,t){let n=-1,r=1e9;for(let i=0;i<t.length;i++)(t[i]-r||e[i].endSide-e[n].endSide)<0&&(n=i,r=t[i]);return n}function hw(e,t,n=e.length){let r=0;for(let i=0;i<n&&i<e.length;)9==e.charCodeAt(i)?(r+=t-r%t,i++):(r++,i=VA(e,i));return r}function dw(e,t,n,r){for(let r=0,i=0;;){if(i>=t)return r;if(r==e.length)break;i+=9==e.charCodeAt(r)?n-i%n:1,r=VA(e,r)}return!0===r?-1:e.length}const uw="undefined"==typeof Symbol?"__ͼ":Symbol.for("ͼ"),pw="undefined"==typeof Symbol?"__styleSet"+Math.floor(1e8*Math.random()):Symbol("styleSet"),fw="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:{};class gw{constructor(e,t){this.rules=[];let{finish:n}=t||{};function r(e){return/^@/.test(e)?[e]:e.split(/,\s*/)}function i(e,t,o,s){let a=[],l=/^@(\w+)\b/.exec(e[0]),c=l&&"keyframes"==l[1];if(l&&null==t)return o.push(e[0]+";");for(let n in t){let s=t[n];if(/&/.test(n))i(n.split(/,\s*/).map(t=>e.map(e=>t.replace(/&/,e))).reduce((e,t)=>e.concat(t)),s,o);else if(s&&"object"==typeof s){if(!l)throw new RangeError("The value of a property ("+n+") should be a primitive value.");i(r(n),s,a,c)}else null!=s&&a.push(n.replace(/_.*/,"").replace(/[A-Z]/g,e=>"-"+e.toLowerCase())+": "+s+";")}(a.length||c)&&o.push((!n||l||s?e:e.map(n)).join(", ")+" {"+a.join(" ")+"}")}for(let t in e)i(r(t),e[t],this.rules)}getRules(){return this.rules.join("\n")}static newName(){let e=fw[uw]||1;return fw[uw]=e+1,"ͼ"+e.toString(36)}static mount(e,t,n){let r=e[pw],i=n&&n.nonce;r?i&&r.setNonce(i):r=new vw(e,i),r.mount(Array.isArray(t)?t:[t],e)}}let mw=new Map;class vw{constructor(e,t){let n=e.ownerDocument||e,r=n.defaultView;if(!e.head&&e.adoptedStyleSheets&&r.CSSStyleSheet){let t=mw.get(n);if(t)return e[pw]=t;this.sheet=new r.CSSStyleSheet,mw.set(n,this)}else this.styleTag=n.createElement("style"),t&&this.styleTag.setAttribute("nonce",t);this.modules=[],e[pw]=this}mount(e,t){let n=this.sheet,r=0,i=0;for(let t=0;t<e.length;t++){let o=e[t],s=this.modules.indexOf(o);if(s<i&&s>-1&&(this.modules.splice(s,1),i--,s=-1),-1==s){if(this.modules.splice(i++,0,o),n)for(let e=0;e<o.rules.length;e++)n.insertRule(o.rules[e],r++)}else{for(;i<s;)r+=this.modules[i++].rules.length;r+=o.rules.length,i++}}if(n)t.adoptedStyleSheets.indexOf(this.sheet)<0&&(t.adoptedStyleSheets=[this.sheet,...t.adoptedStyleSheets]);else{let e="";for(let t=0;t<this.modules.length;t++)e+=this.modules[t].getRules()+"\n";this.styleTag.textContent=e;let n=t.head||t;this.styleTag.parentNode!=n&&n.insertBefore(this.styleTag,n.firstChild)}}setNonce(e){this.styleTag&&this.styleTag.getAttribute("nonce")!=e&&this.styleTag.setAttribute("nonce",e)}}for(var bw={8:"Backspace",9:"Tab",10:"Enter",12:"NumLock",13:"Enter",16:"Shift",17:"Control",18:"Alt",20:"CapsLock",27:"Escape",32:" ",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",44:"PrintScreen",45:"Insert",46:"Delete",59:";",61:"=",91:"Meta",92:"Meta",106:"*",107:"+",108:",",109:"-",110:".",111:"/",144:"NumLock",145:"ScrollLock",160:"Shift",161:"Shift",162:"Control",163:"Control",164:"Alt",165:"Alt",173:"-",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'"},Aw={48:")",49:"!",50:"@",51:"#",52:"$",53:"%",54:"^",55:"&",56:"*",57:"(",59:":",61:"+",173:"_",186:":",187:"+",188:"<",189:"_",190:">",191:"?",192:"~",219:"{",220:"|",221:"}",222:'"'},yw="undefined"!=typeof navigator&&/Mac/.test(navigator.platform),ww="undefined"!=typeof navigator&&/MSIE \d|Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(navigator.userAgent),Cw=0;Cw<10;Cw++)bw[48+Cw]=bw[96+Cw]=String(Cw);for(Cw=1;Cw<=24;Cw++)bw[Cw+111]="F"+Cw;for(Cw=65;Cw<=90;Cw++)bw[Cw]=String.fromCharCode(Cw+32),Aw[Cw]=String.fromCharCode(Cw);for(var xw in bw)Aw.hasOwnProperty(xw)||(Aw[xw]=bw[xw]);let kw="undefined"!=typeof navigator?navigator:{userAgent:"",vendor:"",platform:""},Sw="undefined"!=typeof document?document:{documentElement:{style:{}}};const Ow=/Edge\/(\d+)/.exec(kw.userAgent),Bw=/MSIE \d/.test(kw.userAgent),_w=/Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(kw.userAgent),Tw=!!(Bw||_w||Ow),Ew=!Tw&&/gecko\/(\d+)/i.test(kw.userAgent),Mw=!Tw&&/Chrome\/(\d+)/.exec(kw.userAgent),Dw="webkitFontSmoothing"in Sw.documentElement.style,Pw=!Tw&&/Apple Computer/.test(kw.vendor),Rw=Pw&&(/Mobile\/\w+/.test(kw.userAgent)||kw.maxTouchPoints>2);var Iw={mac:Rw||/Mac/.test(kw.platform),windows:/Win/.test(kw.platform),linux:/Linux|X11/.test(kw.platform),ie:Tw,ie_version:Bw?Sw.documentMode||6:_w?+_w[1]:Ow?+Ow[1]:0,gecko:Ew,gecko_version:Ew?+(/Firefox\/(\d+)/.exec(kw.userAgent)||[0,0])[1]:0,chrome:!!Mw,chrome_version:Mw?+Mw[1]:0,ios:Rw,android:/Android\b/.test(kw.userAgent),webkit:Dw,webkit_version:Dw?+(/\bAppleWebKit\/(\d+)/.exec(kw.userAgent)||[0,0])[1]:0,safari:Pw,safari_version:Pw?+(/\bVersion\/(\d+(\.\d+)?)/.exec(kw.userAgent)||[0,0])[1]:0,tabSize:null!=Sw.documentElement.style.tabSize?"tab-size":"-moz-tab-size"};function Lw(e){let t;return t=11==e.nodeType?e.getSelection?e:e.ownerDocument:e,t.getSelection()}function Nw(e,t){return!!t&&(e==t||e.contains(1!=t.nodeType?t.parentNode:t))}function Fw(e,t){if(!t.anchorNode)return!1;try{return Nw(e,t.anchorNode)}catch(e){return!1}}function Qw(e){return 3==e.nodeType?Kw(e,0,e.nodeValue.length).getClientRects():1==e.nodeType?e.getClientRects():[]}function Vw(e,t,n,r){return!!n&&(Hw(e,t,n,r,-1)||Hw(e,t,n,r,1))}function zw(e){for(var t=0;;t++)if(!(e=e.previousSibling))return t}function $w(e){return 1==e.nodeType&&/^(DIV|P|LI|UL|OL|BLOCKQUOTE|DD|DT|H\d|SECTION|PRE)$/.test(e.nodeName)}function Hw(e,t,n,r,i){for(;;){if(e==n&&t==r)return!0;if(t==(i<0?0:jw(e))){if("DIV"==e.nodeName)return!1;let n=e.parentNode;if(!n||1!=n.nodeType)return!1;t=zw(e)+(i<0?0:1),e=n}else{if(1!=e.nodeType)return!1;if(1==(e=e.childNodes[t+(i<0?-1:0)]).nodeType&&"false"==e.contentEditable)return!1;t=i<0?jw(e):0}}}function jw(e){return 3==e.nodeType?e.nodeValue.length:e.childNodes.length}function qw(e,t){let n=t?e.left:e.right;return{left:n,right:n,top:e.top,bottom:e.bottom}}function Ww(e){let t=e.visualViewport;return t?{left:0,right:t.width,top:0,bottom:t.height}:{left:0,right:e.innerWidth,top:0,bottom:e.innerHeight}}function Uw(e,t){let n=t.width/e.offsetWidth,r=t.height/e.offsetHeight;return(n>.995&&n<1.005||!isFinite(n)||Math.abs(t.width-e.offsetWidth)<1)&&(n=1),(r>.995&&r<1.005||!isFinite(r)||Math.abs(t.height-e.offsetHeight)<1)&&(r=1),{scaleX:n,scaleY:r}}class Yw{constructor(){this.anchorNode=null,this.anchorOffset=0,this.focusNode=null,this.focusOffset=0}eq(e){return this.anchorNode==e.anchorNode&&this.anchorOffset==e.anchorOffset&&this.focusNode==e.focusNode&&this.focusOffset==e.focusOffset}setRange(e){let{anchorNode:t,focusNode:n}=e;this.set(t,Math.min(e.anchorOffset,t?jw(t):0),n,Math.min(e.focusOffset,n?jw(n):0))}set(e,t,n,r){this.anchorNode=e,this.anchorOffset=t,this.focusNode=n,this.focusOffset=r}}let Gw,Xw=null;function Jw(e){if(e.setActive)return e.setActive();if(Xw)return e.focus(Xw);let t=[];for(let n=e;n&&(t.push(n,n.scrollTop,n.scrollLeft),n!=n.ownerDocument);n=n.parentNode);if(e.focus(null==Xw?{get preventScroll(){return Xw={preventScroll:!0},!0}}:void 0),!Xw){Xw=!1;for(let e=0;e<t.length;){let n=t[e++],r=t[e++],i=t[e++];n.scrollTop!=r&&(n.scrollTop=r),n.scrollLeft!=i&&(n.scrollLeft=i)}}}function Kw(e,t,n=t){let r=Gw||(Gw=document.createRange());return r.setEnd(e,n),r.setStart(e,t),r}function Zw(e,t,n,r){let i={key:t,code:t,keyCode:n,which:n,cancelable:!0};r&&({altKey:i.altKey,ctrlKey:i.ctrlKey,shiftKey:i.shiftKey,metaKey:i.metaKey}=r);let o=new KeyboardEvent("keydown",i);o.synthetic=!0,e.dispatchEvent(o);let s=new KeyboardEvent("keyup",i);return s.synthetic=!0,e.dispatchEvent(s),o.defaultPrevented||s.defaultPrevented}function eC(e){for(;e.attributes.length;)e.removeAttributeNode(e.attributes[0])}function tC(e){return e.scrollTop>Math.max(1,e.scrollHeight-e.clientHeight-4)}function nC(e,t){for(let n=e,r=t;;){if(3==n.nodeType&&r>0)return{node:n,offset:r};if(1==n.nodeType&&r>0){if("false"==n.contentEditable)return null;n=n.childNodes[r-1],r=jw(n)}else{if(!n.parentNode||$w(n))return null;r=zw(n),n=n.parentNode}}}function rC(e,t){for(let n=e,r=t;;){if(3==n.nodeType&&r<n.nodeValue.length)return{node:n,offset:r};if(1==n.nodeType&&r<n.childNodes.length){if("false"==n.contentEditable)return null;n=n.childNodes[r],r=0}else{if(!n.parentNode||$w(n))return null;r=zw(n)+1,n=n.parentNode}}}Iw.safari&&Iw.safari_version>=26&&(Xw=!1);class iC{constructor(e,t,n=!0){this.node=e,this.offset=t,this.precise=n}static before(e,t){return new iC(e.parentNode,zw(e),t)}static after(e,t){return new iC(e.parentNode,zw(e)+1,t)}}const oC=[];class sC{constructor(){this.parent=null,this.dom=null,this.flags=2}get overrideDOMText(){return null}get posAtStart(){return this.parent?this.parent.posBefore(this):0}get posAtEnd(){return this.posAtStart+this.length}posBefore(e){let t=this.posAtStart;for(let n of this.children){if(n==e)return t;t+=n.length+n.breakAfter}throw new RangeError("Invalid child in posBefore")}posAfter(e){return this.posBefore(e)+e.length}sync(e,t){if(2&this.flags){let n,r=this.dom,i=null;for(let o of this.children){if(7&o.flags){if(!o.dom&&(n=i?i.nextSibling:r.firstChild)){let e=sC.get(n);(!e||!e.parent&&e.canReuseDOM(o))&&o.reuseDOM(n)}o.sync(e,t),o.flags&=-8}if(n=i?i.nextSibling:r.firstChild,t&&!t.written&&t.node==r&&n!=o.dom&&(t.written=!0),o.dom.parentNode==r)for(;n&&n!=o.dom;)n=aC(n);else r.insertBefore(o.dom,n);i=o.dom}for(n=i?i.nextSibling:r.firstChild,n&&t&&t.node==r&&(t.written=!0);n;)n=aC(n)}else if(1&this.flags)for(let n of this.children)7&n.flags&&(n.sync(e,t),n.flags&=-8)}reuseDOM(e){}localPosFromDOM(e,t){let n;if(e==this.dom)n=this.dom.childNodes[t];else{let r=0==jw(e)?0:0==t?-1:1;for(;;){let t=e.parentNode;if(t==this.dom)break;0==r&&t.firstChild!=t.lastChild&&(r=e==t.firstChild?-1:1),e=t}n=r<0?e:e.nextSibling}if(n==this.dom.firstChild)return 0;for(;n&&!sC.get(n);)n=n.nextSibling;if(!n)return this.length;for(let e=0,t=0;;e++){let r=this.children[e];if(r.dom==n)return t;t+=r.length+r.breakAfter}}domBoundsAround(e,t,n=0){let r=-1,i=-1,o=-1,s=-1;for(let a=0,l=n,c=n;a<this.children.length;a++){let n=this.children[a],h=l+n.length;if(l<e&&h>t)return n.domBoundsAround(e,t,l);if(h>=e&&-1==r&&(r=a,i=l),l>t&&n.dom.parentNode==this.dom){o=a,s=c;break}c=h,l=h+n.breakAfter}return{from:i,to:s<0?n+this.length:s,startDOM:(r?this.children[r-1].dom.nextSibling:null)||this.dom.firstChild,endDOM:o<this.children.length&&o>=0?this.children[o].dom:null}}markDirty(e=!1){this.flags|=2,this.markParentsDirty(e)}markParentsDirty(e){for(let t=this.parent;t;t=t.parent){if(e&&(t.flags|=2),1&t.flags)return;t.flags|=1,e=!1}}setParent(e){this.parent!=e&&(this.parent=e,7&this.flags&&this.markParentsDirty(!0))}setDOM(e){this.dom!=e&&(this.dom&&(this.dom.cmView=null),this.dom=e,e.cmView=this)}get rootView(){for(let e=this;;){let t=e.parent;if(!t)return e;e=t}}replaceChildren(e,t,n=oC){this.markDirty();for(let r=e;r<t;r++){let e=this.children[r];e.parent==this&&n.indexOf(e)<0&&e.destroy()}n.length<250?this.children.splice(e,t-e,...n):this.children=[].concat(this.children.slice(0,e),n,this.children.slice(t));for(let e=0;e<n.length;e++)n[e].setParent(this)}ignoreMutation(e){return!1}ignoreEvent(e){return!1}childCursor(e=this.length){return new lC(this.children,e,this.children.length)}childPos(e,t=1){return this.childCursor().findPos(e,t)}toString(){let e=this.constructor.name.replace("View","");return e+(this.children.length?"("+this.children.join()+")":this.length?"["+("Text"==e?this.text:this.length)+"]":"")+(this.breakAfter?"#":"")}static get(e){return e.cmView}get isEditable(){return!0}get isWidget(){return!1}get isHidden(){return!1}merge(e,t,n,r,i,o){return!1}become(e){return!1}canReuseDOM(e){return e.constructor==this.constructor&&!(8&(this.flags|e.flags))}getSide(){return 0}destroy(){for(let e of this.children)e.parent==this&&e.destroy();this.parent=null}}function aC(e){let t=e.nextSibling;return e.parentNode.removeChild(e),t}sC.prototype.breakAfter=0;class lC{constructor(e,t,n){this.children=e,this.pos=t,this.i=n,this.off=0}findPos(e,t=1){for(;;){if(e>this.pos||e==this.pos&&(t>0||0==this.i||this.children[this.i-1].breakAfter))return this.off=e-this.pos,this;let n=this.children[--this.i];this.pos-=n.length+n.breakAfter}}}function cC(e,t,n,r,i,o,s,a,l){let{children:c}=e,h=c.length?c[t]:null,d=o.length?o[o.length-1]:null,u=d?d.breakAfter:s;if(!(t==r&&h&&!s&&!u&&o.length<2&&h.merge(n,i,o.length?d:null,0==n,a,l))){if(r<c.length){let e=c[r];e&&(i<e.length||e.breakAfter&&(null==d?void 0:d.breakAfter))?(t==r&&(e=e.split(i),i=0),!u&&d&&e.merge(0,i,d,!0,0,l)?o[o.length-1]=e:((i||e.children.length&&!e.children[0].length)&&e.merge(0,i,null,!1,0,l),o.push(e))):(null==e?void 0:e.breakAfter)&&(d?d.breakAfter=1:s=1),r++}for(h&&(h.breakAfter=s,n>0&&(!s&&o.length&&h.merge(n,h.length,o[0],!1,a,0)?h.breakAfter=o.shift().breakAfter:(n<h.length||h.children.length&&0==h.children[h.children.length-1].length)&&h.merge(n,h.length,null,!1,a,0),t++));t<r&&o.length;)if(c[r-1].become(o[o.length-1]))r--,o.pop(),l=o.length?0:a;else{if(!c[t].become(o[0]))break;t++,o.shift(),a=o.length?0:l}!o.length&&t&&r<c.length&&!c[t-1].breakAfter&&c[r].merge(0,0,c[t-1],!1,a,l)&&t--,(t<r||o.length)&&e.replaceChildren(t,r,o)}}function hC(e,t,n,r,i,o){let s=e.childCursor(),{i:a,off:l}=s.findPos(n,1),{i:c,off:h}=s.findPos(t,-1),d=t-n;for(let e of r)d+=e.length;e.length+=d,cC(e,c,h,a,l,r,0,i,o)}class dC extends sC{constructor(e){super(),this.text=e}get length(){return this.text.length}createDOM(e){this.setDOM(e||document.createTextNode(this.text))}sync(e,t){this.dom||this.createDOM(),this.dom.nodeValue!=this.text&&(t&&t.node==this.dom&&(t.written=!0),this.dom.nodeValue=this.text)}reuseDOM(e){3==e.nodeType&&this.createDOM(e)}merge(e,t,n){return!(8&this.flags||n&&(!(n instanceof dC)||this.length-(t-e)+n.length>256||8&n.flags))&&(this.text=this.text.slice(0,e)+(n?n.text:"")+this.text.slice(t),this.markDirty(),!0)}split(e){let t=new dC(this.text.slice(e));return this.text=this.text.slice(0,e),this.markDirty(),t.flags|=8&this.flags,t}localPosFromDOM(e,t){return e==this.dom?t:t?this.text.length:0}domAtPos(e){return new iC(this.dom,e)}domBoundsAround(e,t,n){return{from:n,to:n+this.length,startDOM:this.dom,endDOM:this.dom.nextSibling}}coordsAt(e,t){return function(e,t,n){let r=e.nodeValue.length;t>r&&(t=r);let i=t,o=t,s=0;0==t&&n<0||t==r&&n>=0?Iw.chrome||Iw.gecko||(t?(i--,s=1):o<r&&(o++,s=-1)):n<0?i--:o<r&&o++;let a=Kw(e,i,o).getClientRects();if(!a.length)return null;let l=a[(s?s<0:n>=0)?0:a.length-1];Iw.safari&&!s&&0==l.width&&(l=Array.prototype.find.call(a,e=>e.width)||l);return s?qw(l,s<0):l||null}(this.dom,e,t)}}class uC extends sC{constructor(e,t=[],n=0){super(),this.mark=e,this.children=t,this.length=n;for(let e of t)e.setParent(this)}setAttrs(e){if(eC(e),this.mark.class&&(e.className=this.mark.class),this.mark.attrs)for(let t in this.mark.attrs)e.setAttribute(t,this.mark.attrs[t]);return e}canReuseDOM(e){return super.canReuseDOM(e)&&!(8&(this.flags|e.flags))}reuseDOM(e){e.nodeName==this.mark.tagName.toUpperCase()&&(this.setDOM(e),this.flags|=6)}sync(e,t){this.dom?4&this.flags&&this.setAttrs(this.dom):this.setDOM(this.setAttrs(document.createElement(this.mark.tagName))),super.sync(e,t)}merge(e,t,n,r,i,o){return(!n||!(!(n instanceof uC&&n.mark.eq(this.mark))||e&&i<=0||t<this.length&&o<=0))&&(hC(this,e,t,n?n.children.slice():[],i-1,o-1),this.markDirty(),!0)}split(e){let t=[],n=0,r=-1,i=0;for(let o of this.children){let s=n+o.length;s>e&&t.push(n<e?o.split(e-n):o),r<0&&n>=e&&(r=i),n=s,i++}let o=this.length-e;return this.length=e,r>-1&&(this.children.length=r,this.markDirty()),new uC(this.mark,t,o)}domAtPos(e){return gC(this,e)}coordsAt(e,t){return vC(this,e,t)}}class pC extends sC{static create(e,t,n){return new pC(e,t,n)}constructor(e,t,n){super(),this.widget=e,this.length=t,this.side=n,this.prevWidget=null}split(e){let t=pC.create(this.widget,this.length-e,this.side);return this.length-=e,t}sync(e){this.dom&&this.widget.updateDOM(this.dom,e)||(this.dom&&this.prevWidget&&this.prevWidget.destroy(this.dom),this.prevWidget=null,this.setDOM(this.widget.toDOM(e)),this.widget.editable||(this.dom.contentEditable="false"))}getSide(){return this.side}merge(e,t,n,r,i,o){return!(n&&(!(n instanceof pC&&this.widget.compare(n.widget))||e>0&&i<=0||t<this.length&&o<=0))&&(this.length=e+(n?n.length:0)+(this.length-t),!0)}become(e){return e instanceof pC&&e.side==this.side&&this.widget.constructor==e.widget.constructor&&(this.widget.compare(e.widget)||this.markDirty(!0),this.dom&&!this.prevWidget&&(this.prevWidget=this.widget),this.widget=e.widget,this.length=e.length,!0)}ignoreMutation(){return!0}ignoreEvent(e){return this.widget.ignoreEvent(e)}get overrideDOMText(){if(0==this.length)return EA.empty;let e=this;for(;e.parent;)e=e.parent;let{view:t}=e,n=t&&t.state.doc,r=this.posAtStart;return n?n.slice(r,r+this.length):EA.empty}domAtPos(e){return(this.length?0==e:this.side>0)?iC.before(this.dom):iC.after(this.dom,e==this.length)}domBoundsAround(){return null}coordsAt(e,t){let n=this.widget.coordsAt(this.dom,e,t);if(n)return n;let r=this.dom.getClientRects(),i=null;if(!r.length)return null;let o=this.side?this.side<0:e>0;for(let t=o?r.length-1:0;i=r[t],!(e>0?0==t:t==r.length-1||i.top<i.bottom);t+=o?-1:1);return qw(i,!o)}get isEditable(){return!1}get isWidget(){return!0}get isHidden(){return this.widget.isHidden}destroy(){super.destroy(),this.dom&&this.widget.destroy(this.dom)}}class fC extends sC{constructor(e){super(),this.side=e}get length(){return 0}merge(){return!1}become(e){return e instanceof fC&&e.side==this.side}split(){return new fC(this.side)}sync(){if(!this.dom){let e=document.createElement("img");e.className="cm-widgetBuffer",e.setAttribute("aria-hidden","true"),this.setDOM(e)}}getSide(){return this.side}domAtPos(e){return this.side>0?iC.before(this.dom):iC.after(this.dom)}localPosFromDOM(){return 0}domBoundsAround(){return null}coordsAt(e){return this.dom.getBoundingClientRect()}get overrideDOMText(){return EA.empty}get isHidden(){return!0}}function gC(e,t){let n=e.dom,{children:r}=e,i=0;for(let e=0;i<r.length;i++){let o=r[i],s=e+o.length;if(!(s==e&&o.getSide()<=0)){if(t>e&&t<s&&o.dom.parentNode==n)return o.domAtPos(t-e);if(t<=e)break;e=s}}for(let e=i;e>0;e--){let t=r[e-1];if(t.dom.parentNode==n)return t.domAtPos(t.length)}for(let e=i;e<r.length;e++){let t=r[e];if(t.dom.parentNode==n)return t.domAtPos(0)}return new iC(n,0)}function mC(e,t,n){let r,{children:i}=e;n>0&&t instanceof uC&&i.length&&(r=i[i.length-1])instanceof uC&&r.mark.eq(t.mark)?mC(r,t.children[0],n-1):(i.push(t),t.setParent(e)),e.length+=t.length}function vC(e,t,n){let r=null,i=-1,o=null,s=-1;!function e(t,a){for(let l=0,c=0;l<t.children.length&&c<=a;l++){let h=t.children[l],d=c+h.length;d>=a&&(h.children.length?e(h,a-c):(!o||o.isHidden&&(n>0||bC(o,h)))&&(d>a||c==d&&h.getSide()>0)?(o=h,s=a-c):(c<a||c==d&&h.getSide()<0&&!h.isHidden)&&(r=h,i=a-c)),c=d}}(e,t);let a=(n<0?r:o)||r||o;return a?a.coordsAt(Math.max(0,a==r?i:s),n):function(e){let t=e.dom.lastChild;if(!t)return e.dom.getBoundingClientRect();let n=Qw(t);return n[n.length-1]||null}(e)}function bC(e,t){let n=e.coordsAt(0,1),r=t.coordsAt(0,1);return n&&r&&r.top<n.bottom}function AC(e,t){for(let n in e)"class"==n&&t.class?t.class+=" "+e.class:"style"==n&&t.style?t.style+=";"+e.style:t[n]=e[n];return t}dC.prototype.children=pC.prototype.children=fC.prototype.children=oC;const yC=Object.create(null);function wC(e,t,n){if(e==t)return!0;e||(e=yC),t||(t=yC);let r=Object.keys(e),i=Object.keys(t);if(r.length-(n&&r.indexOf(n)>-1?1:0)!=i.length-(n&&i.indexOf(n)>-1?1:0))return!1;for(let o of r)if(o!=n&&(-1==i.indexOf(o)||e[o]!==t[o]))return!1;return!0}function CC(e,t,n){let r=!1;if(t)for(let i in t)n&&i in n||(r=!0,"style"==i?e.style.cssText="":e.removeAttribute(i));if(n)for(let i in n)t&&t[i]==n[i]||(r=!0,"style"==i?e.style.cssText=n[i]:e.setAttribute(i,n[i]));return r}function xC(e){let t=Object.create(null);for(let n=0;n<e.attributes.length;n++){let r=e.attributes[n];t[r.name]=r.value}return t}class kC{eq(e){return!1}updateDOM(e,t){return!1}compare(e){return this==e||this.constructor==e.constructor&&this.eq(e)}get estimatedHeight(){return-1}get lineBreaks(){return 0}ignoreEvent(e){return!0}coordsAt(e,t,n){return null}get isHidden(){return!1}get editable(){return!1}destroy(e){}}var SC=function(e){return e[e.Text=0]="Text",e[e.WidgetBefore=1]="WidgetBefore",e[e.WidgetAfter=2]="WidgetAfter",e[e.WidgetRange=3]="WidgetRange",e}(SC||(SC={}));class OC extends Yy{constructor(e,t,n,r){super(),this.startSide=e,this.endSide=t,this.widget=n,this.spec=r}get heightRelevant(){return!1}static mark(e){return new BC(e)}static widget(e){let t=Math.max(-1e4,Math.min(1e4,e.side||0)),n=!!e.block;return t+=n&&!e.inlineOrder?t>0?3e8:-4e8:t>0?1e8:-1e8,new TC(e,t,t,n,e.widget||null,!1)}static replace(e){let t,n,r=!!e.block;if(e.isBlockGap)t=-5e8,n=4e8;else{let{start:i,end:o}=EC(e,r);t=(i?r?-3e8:-1:5e8)-1,n=1+(o?r?2e8:1:-6e8)}return new TC(e,t,n,r,e.widget||null,!0)}static line(e){return new _C(e)}static set(e,t=!1){return Ky.of(e,t)}hasHeight(){return!!this.widget&&this.widget.estimatedHeight>-1}}OC.none=Ky.empty;class BC extends OC{constructor(e){let{start:t,end:n}=EC(e);super(t?-1:5e8,n?1:-6e8,null,e),this.tagName=e.tagName||"span",this.class=e.class||"",this.attrs=e.attributes||null}eq(e){var t,n;return this==e||e instanceof BC&&this.tagName==e.tagName&&(this.class||(null===(t=this.attrs)||void 0===t?void 0:t.class))==(e.class||(null===(n=e.attrs)||void 0===n?void 0:n.class))&&wC(this.attrs,e.attrs,"class")}range(e,t=e){if(e>=t)throw new RangeError("Mark decorations may not be empty");return super.range(e,t)}}BC.prototype.point=!1;class _C extends OC{constructor(e){super(-2e8,-2e8,null,e)}eq(e){return e instanceof _C&&this.spec.class==e.spec.class&&wC(this.spec.attributes,e.spec.attributes)}range(e,t=e){if(t!=e)throw new RangeError("Line decoration ranges must be zero-length");return super.range(e,t)}}_C.prototype.mapMode=qA.TrackBefore,_C.prototype.point=!0;class TC extends OC{constructor(e,t,n,r,i,o){super(t,n,i,e),this.block=r,this.isReplace=o,this.mapMode=r?t<=0?qA.TrackBefore:qA.TrackAfter:qA.TrackDel}get type(){return this.startSide!=this.endSide?SC.WidgetRange:this.startSide<=0?SC.WidgetBefore:SC.WidgetAfter}get heightRelevant(){return this.block||!!this.widget&&(this.widget.estimatedHeight>=5||this.widget.lineBreaks>0)}eq(e){return e instanceof TC&&function(e,t){return e==t||!!(e&&t&&e.compare(t))}(this.widget,e.widget)&&this.block==e.block&&this.startSide==e.startSide&&this.endSide==e.endSide}range(e,t=e){if(this.isReplace&&(e>t||e==t&&this.startSide>0&&this.endSide<=0))throw new RangeError("Invalid range for replacement decoration");if(!this.isReplace&&t!=e)throw new RangeError("Widget decorations can only have zero-length ranges");return super.range(e,t)}}function EC(e,t=!1){let{inclusiveStart:n,inclusiveEnd:r}=e;return null==n&&(n=e.inclusive),null==r&&(r=e.inclusive),{start:null!=n?n:t,end:null!=r?r:t}}function MC(e,t,n,r=0){let i=n.length-1;i>=0&&n[i]+r>=e?n[i]=Math.max(n[i],t):n.push(e,t)}TC.prototype.point=!0;class DC extends sC{constructor(){super(...arguments),this.children=[],this.length=0,this.prevAttrs=void 0,this.attrs=null,this.breakAfter=0}merge(e,t,n,r,i,o){if(n){if(!(n instanceof DC))return!1;this.dom||n.transferDOM(this)}return r&&this.setDeco(n?n.attrs:null),hC(this,e,t,n?n.children.slice():[],i,o),!0}split(e){let t=new DC;if(t.breakAfter=this.breakAfter,0==this.length)return t;let{i:n,off:r}=this.childPos(e);r&&(t.append(this.children[n].split(r),0),this.children[n].merge(r,this.children[n].length,null,!1,0,0),n++);for(let e=n;e<this.children.length;e++)t.append(this.children[e],0);for(;n>0&&0==this.children[n-1].length;)this.children[--n].destroy();return this.children.length=n,this.markDirty(),this.length=e,t}transferDOM(e){this.dom&&(this.markDirty(),e.setDOM(this.dom),e.prevAttrs=void 0===this.prevAttrs?this.attrs:this.prevAttrs,this.prevAttrs=void 0,this.dom=null)}setDeco(e){wC(this.attrs,e)||(this.dom&&(this.prevAttrs=this.attrs,this.markDirty()),this.attrs=e)}append(e,t){mC(this,e,t)}addLineDeco(e){let t=e.spec.attributes,n=e.spec.class;t&&(this.attrs=AC(t,this.attrs||{})),n&&(this.attrs=AC({class:n},this.attrs||{}))}domAtPos(e){return gC(this,e)}reuseDOM(e){"DIV"==e.nodeName&&(this.setDOM(e),this.flags|=6)}sync(e,t){var n;this.dom?4&this.flags&&(eC(this.dom),this.dom.className="cm-line",this.prevAttrs=this.attrs?null:void 0):(this.setDOM(document.createElement("div")),this.dom.className="cm-line",this.prevAttrs=this.attrs?null:void 0),void 0!==this.prevAttrs&&(CC(this.dom,this.prevAttrs,this.attrs),this.dom.classList.add("cm-line"),this.prevAttrs=void 0),super.sync(e,t);let r=this.dom.lastChild;for(;r&&sC.get(r)instanceof uC;)r=r.lastChild;if(!(r&&this.length&&("BR"==r.nodeName||0!=(null===(n=sC.get(r))||void 0===n?void 0:n.isEditable)||Iw.ios&&this.children.some(e=>e instanceof dC)))){let e=document.createElement("BR");e.cmIgnore=!0,this.dom.appendChild(e)}}measureTextSize(){if(0==this.children.length||this.length>20)return null;let e,t=0;for(let n of this.children){if(!(n instanceof dC)||/[^ -~]/.test(n.text))return null;let r=Qw(n.dom);if(1!=r.length)return null;t+=r[0].width,e=r[0].height}return t?{lineHeight:this.dom.getBoundingClientRect().height,charWidth:t/this.length,textHeight:e}:null}coordsAt(e,t){let n=vC(this,e,t);if(!this.children.length&&n&&this.parent){let{heightOracle:e}=this.parent.view.viewState,t=n.bottom-n.top;if(Math.abs(t-e.lineHeight)<2&&e.textHeight<t){let r=(t-e.textHeight)/2;return{top:n.top+r,bottom:n.bottom-r,left:n.left,right:n.left}}}return n}become(e){return e instanceof DC&&0==this.children.length&&0==e.children.length&&wC(this.attrs,e.attrs)&&this.breakAfter==e.breakAfter}covers(){return!0}static find(e,t){for(let n=0,r=0;n<e.children.length;n++){let i=e.children[n],o=r+i.length;if(o>=t){if(i instanceof DC)return i;if(o>t)break}r=o+i.breakAfter}return null}}class PC extends sC{constructor(e,t,n){super(),this.widget=e,this.length=t,this.deco=n,this.breakAfter=0,this.prevWidget=null}merge(e,t,n,r,i,o){return!(n&&(!(n instanceof PC&&this.widget.compare(n.widget))||e>0&&i<=0||t<this.length&&o<=0))&&(this.length=e+(n?n.length:0)+(this.length-t),!0)}domAtPos(e){return 0==e?iC.before(this.dom):iC.after(this.dom,e==this.length)}split(e){let t=this.length-e;this.length=e;let n=new PC(this.widget,t,this.deco);return n.breakAfter=this.breakAfter,n}get children(){return oC}sync(e){this.dom&&this.widget.updateDOM(this.dom,e)||(this.dom&&this.prevWidget&&this.prevWidget.destroy(this.dom),this.prevWidget=null,this.setDOM(this.widget.toDOM(e)),this.widget.editable||(this.dom.contentEditable="false"))}get overrideDOMText(){return this.parent?this.parent.view.state.doc.slice(this.posAtStart,this.posAtEnd):EA.empty}domBoundsAround(){return null}become(e){return e instanceof PC&&e.widget.constructor==this.widget.constructor&&(e.widget.compare(this.widget)||this.markDirty(!0),this.dom&&!this.prevWidget&&(this.prevWidget=this.widget),this.widget=e.widget,this.length=e.length,this.deco=e.deco,this.breakAfter=e.breakAfter,!0)}ignoreMutation(){return!0}ignoreEvent(e){return this.widget.ignoreEvent(e)}get isEditable(){return!1}get isWidget(){return!0}coordsAt(e,t){let n=this.widget.coordsAt(this.dom,e,t);return n||(this.widget instanceof RC?null:qw(this.dom.getBoundingClientRect(),this.length?0==e:t<=0))}destroy(){super.destroy(),this.dom&&this.widget.destroy(this.dom)}covers(e){let{startSide:t,endSide:n}=this.deco;return t!=n&&(e<0?t<0:n>0)}}class RC extends kC{constructor(e){super(),this.height=e}toDOM(){let e=document.createElement("div");return e.className="cm-gap",this.updateDOM(e),e}eq(e){return e.height==this.height}updateDOM(e){return e.style.height=this.height+"px",!0}get editable(){return!0}get estimatedHeight(){return this.height}ignoreEvent(){return!1}}class IC{constructor(e,t,n,r){this.doc=e,this.pos=t,this.end=n,this.disallowBlockEffectsFor=r,this.content=[],this.curLine=null,this.breakAtStart=0,this.pendingBuffer=0,this.bufferMarks=[],this.atCursorPos=!0,this.openStart=-1,this.openEnd=-1,this.text="",this.textOff=0,this.cursor=e.iter(),this.skip=t}posCovered(){if(0==this.content.length)return!this.breakAtStart&&this.doc.lineAt(this.pos).from!=this.pos;let e=this.content[this.content.length-1];return!(e.breakAfter||e instanceof PC&&e.deco.endSide<0)}getLine(){return this.curLine||(this.content.push(this.curLine=new DC),this.atCursorPos=!0),this.curLine}flushBuffer(e=this.bufferMarks){this.pendingBuffer&&(this.curLine.append(LC(new fC(-1),e),e.length),this.pendingBuffer=0)}addBlockWidget(e){this.flushBuffer(),this.curLine=null,this.content.push(e)}finish(e){this.pendingBuffer&&e<=this.bufferMarks.length?this.flushBuffer():this.pendingBuffer=0,this.posCovered()||e&&this.content.length&&this.content[this.content.length-1]instanceof PC||this.getLine()}buildText(e,t,n){for(;e>0;){if(this.textOff==this.text.length){let{value:t,lineBreak:n,done:r}=this.cursor.next(this.skip);if(this.skip=0,r)throw new Error("Ran out of text content when drawing inline views");if(n){this.posCovered()||this.getLine(),this.content.length?this.content[this.content.length-1].breakAfter=1:this.breakAtStart=1,this.flushBuffer(),this.curLine=null,this.atCursorPos=!0,e--;continue}this.text=t,this.textOff=0}let r=Math.min(this.text.length-this.textOff,e),i=Math.min(r,512);this.flushBuffer(t.slice(t.length-n)),this.getLine().append(LC(new dC(this.text.slice(this.textOff,this.textOff+i)),t),n),this.atCursorPos=!0,this.textOff+=i,e-=i,n=r<=i?0:t.length}}span(e,t,n,r){this.buildText(t-e,n,r),this.pos=t,this.openStart<0&&(this.openStart=r)}point(e,t,n,r,i,o){if(this.disallowBlockEffectsFor[o]&&n instanceof TC){if(n.block)throw new RangeError("Block decorations may not be specified via plugins");if(t>this.doc.lineAt(this.pos).to)throw new RangeError("Decorations that replace line breaks may not be specified via plugins")}let s=t-e;if(n instanceof TC)if(n.block)n.startSide>0&&!this.posCovered()&&this.getLine(),this.addBlockWidget(new PC(n.widget||NC.block,s,n));else{let o=pC.create(n.widget||NC.inline,s,s?0:n.startSide),a=this.atCursorPos&&!o.isEditable&&i<=r.length&&(e<t||n.startSide>0),l=!o.isEditable&&(e<t||i>r.length||n.startSide<=0),c=this.getLine();2!=this.pendingBuffer||a||o.isEditable||(this.pendingBuffer=0),this.flushBuffer(r),a&&(c.append(LC(new fC(1),r),i),i=r.length+Math.max(0,i-r.length)),c.append(LC(o,r),i),this.atCursorPos=l,this.pendingBuffer=l?e<t||i>r.length?1:2:0,this.pendingBuffer&&(this.bufferMarks=r.slice())}else this.doc.lineAt(this.pos).from==this.pos&&this.getLine().addLineDeco(n);s&&(this.textOff+s<=this.text.length?this.textOff+=s:(this.skip+=s-(this.text.length-this.textOff),this.text="",this.textOff=0),this.pos=t),this.openStart<0&&(this.openStart=i)}static build(e,t,n,r,i){let o=new IC(e,t,n,i);return o.openEnd=Ky.spans(r,t,n,o),o.openStart<0&&(o.openStart=o.openEnd),o.finish(o.openEnd),o}}function LC(e,t){for(let n of t)e=new uC(n,[e],e.length);return e}class NC extends kC{constructor(e){super(),this.tag=e}eq(e){return e.tag==this.tag}toDOM(){return document.createElement(this.tag)}updateDOM(e){return e.nodeName.toLowerCase()==this.tag}get isHidden(){return!0}}NC.inline=new NC("span"),NC.block=new NC("div");var FC=function(e){return e[e.LTR=0]="LTR",e[e.RTL=1]="RTL",e}(FC||(FC={}));const QC=FC.LTR,VC=FC.RTL;function zC(e){let t=[];for(let n=0;n<e.length;n++)t.push(1<<+e[n]);return t}const $C=zC("88888888888888888888888888888888888666888888787833333333337888888000000000000000000000000008888880000000000000000000000000088888888888888888888888888888888888887866668888088888663380888308888800000000000000000000000800000000000000000000000000000008"),HC=zC("4444448826627288999999999992222222222222222222222222222222222222222222222229999999999999999999994444444444644222822222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222999999949999999229989999223333333333"),jC=Object.create(null),qC=[];for(let e of["()","[]","{}"]){let t=e.charCodeAt(0),n=e.charCodeAt(1);jC[t]=n,jC[n]=-t}function WC(e){return e<=247?$C[e]:1424<=e&&e<=1524?2:1536<=e&&e<=1785?HC[e-1536]:1774<=e&&e<=2220?4:8192<=e&&e<=8204?256:64336<=e&&e<=65023?4:1}const UC=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\ufb50-\ufdff]/;class YC{get dir(){return this.level%2?VC:QC}constructor(e,t,n){this.from=e,this.to=t,this.level=n}side(e,t){return this.dir==t==e?this.to:this.from}forward(e,t){return e==(this.dir==t)}static find(e,t,n,r){let i=-1;for(let o=0;o<e.length;o++){let s=e[o];if(s.from<=t&&s.to>=t){if(s.level==n)return o;(i<0||(0!=r?r<0?s.from<t:s.to>t:e[i].level>s.level))&&(i=o)}}if(i<0)throw new RangeError("Index out of range");return i}}function GC(e,t){if(e.length!=t.length)return!1;for(let n=0;n<e.length;n++){let r=e[n],i=t[n];if(r.from!=i.from||r.to!=i.to||r.direction!=i.direction||!GC(r.inner,i.inner))return!1}return!0}const XC=[];function JC(e,t,n,r,i,o,s){let a=r%2?2:1;if(r%2==i%2)for(let l=t,c=0;l<n;){let t=!0,h=!1;if(c==o.length||l<o[c].from){let e=XC[l];e!=a&&(t=!1,h=16==e)}let d=t||1!=a?null:[],u=t?r:r+1,p=l;e:for(;;)if(c<o.length&&p==o[c].from){if(h)break e;let f=o[c];if(!t)for(let e=f.to,t=c+1;;){if(e==n)break e;if(!(t<o.length&&o[t].from==e)){if(XC[e]==a)break e;break}e=o[t++].to}if(c++,d)d.push(f);else{f.from>l&&s.push(new YC(l,f.from,u)),KC(e,f.direction==QC!=!(u%2)?r+1:r,i,f.inner,f.from,f.to,s),l=f.to}p=f.to}else{if(p==n||(t?XC[p]!=a:XC[p]==a))break;p++}d?JC(e,l,p,r+1,i,d,s):l<p&&s.push(new YC(l,p,u)),l=p}else for(let l=n,c=o.length;l>t;){let n=!0,h=!1;if(!c||l>o[c-1].to){let e=XC[l-1];e!=a&&(n=!1,h=16==e)}let d=n||1!=a?null:[],u=n?r:r+1,p=l;e:for(;;)if(c&&p==o[c-1].to){if(h)break e;let f=o[--c];if(!n)for(let e=f.from,n=c;;){if(e==t)break e;if(!n||o[n-1].to!=e){if(XC[e-1]==a)break e;break}e=o[--n].from}if(d)d.push(f);else{f.to<l&&s.push(new YC(f.to,l,u)),KC(e,f.direction==QC!=!(u%2)?r+1:r,i,f.inner,f.from,f.to,s),l=f.from}p=f.from}else{if(p==t||(n?XC[p-1]!=a:XC[p-1]==a))break;p--}d?JC(e,p,l,r+1,i,d,s):p<l&&s.push(new YC(p,l,u)),l=p}}function KC(e,t,n,r,i,o,s){let a=t%2?2:1;!function(e,t,n,r,i){for(let o=0;o<=r.length;o++){let s=o?r[o-1].to:t,a=o<r.length?r[o].from:n,l=o?256:i;for(let t=s,n=l,r=l;t<a;t++){let i=WC(e.charCodeAt(t));512==i?i=n:8==i&&4==r&&(i=16),XC[t]=4==i?2:i,7&i&&(r=i),n=i}for(let e=s,t=l,r=l;e<a;e++){let i=XC[e];if(128==i)e<a-1&&t==XC[e+1]&&24&t?i=XC[e]=t:XC[e]=256;else if(64==i){let i=e+1;for(;i<a&&64==XC[i];)i++;let o=e&&8==t||i<n&&8==XC[i]?1==r?1:8:256;for(let t=e;t<i;t++)XC[t]=o;e=i-1}else 8==i&&1==r&&(XC[e]=1);t=i,7&i&&(r=i)}}}(e,i,o,r,a),function(e,t,n,r,i){let o=1==i?2:1;for(let s=0,a=0,l=0;s<=r.length;s++){let c=s?r[s-1].to:t,h=s<r.length?r[s].from:n;for(let t,n,r,s=c;s<h;s++)if(n=jC[t=e.charCodeAt(s)])if(n<0){for(let e=a-3;e>=0;e-=3)if(qC[e+1]==-n){let t=qC[e+2],n=2&t?i:4&t?1&t?o:i:0;n&&(XC[s]=XC[qC[e]]=n),a=e;break}}else{if(189==qC.length)break;qC[a++]=s,qC[a++]=t,qC[a++]=l}else if(2==(r=XC[s])||1==r){let e=r==i;l=e?0:1;for(let t=a-3;t>=0;t-=3){let n=qC[t+2];if(2&n)break;if(e)qC[t+2]|=2;else{if(4&n)break;qC[t+2]|=4}}}}}(e,i,o,r,a),function(e,t,n,r){for(let i=0,o=r;i<=n.length;i++){let s=i?n[i-1].to:e,a=i<n.length?n[i].from:t;for(let l=s;l<a;){let s=XC[l];if(256==s){let s=l+1;for(;;)if(s==a){if(i==n.length)break;s=n[i++].to,a=i<n.length?n[i].from:t}else{if(256!=XC[s])break;s++}let c=1==o,h=c==(1==(s<t?XC[s]:r))?c?1:2:r;for(let t=s,r=i,o=r?n[r-1].to:e;t>l;)t==o&&(t=n[--r].from,o=r?n[r-1].to:e),XC[--t]=h;l=s}else o=s,l++}}}(i,o,r,a),JC(e,i,o,t,n,r,s)}function ZC(e,t,n){if(!e)return[new YC(0,0,t==VC?1:0)];if(t==QC&&!n.length&&!UC.test(e))return ex(e.length);if(n.length)for(;e.length>XC.length;)XC[XC.length]=256;let r=[],i=t==QC?0:1;return KC(e,i,i,n,0,e.length,r),r}function ex(e){return[new YC(0,e,0)]}let tx="";function nx(e,t,n,r,i){var o;let s=r.head-e.from,a=YC.find(t,s,null!==(o=r.bidiLevel)&&void 0!==o?o:-1,r.assoc),l=t[a],c=l.side(i,n);if(s==c){let e=a+=i?1:-1;if(e<0||e>=t.length)return null;l=t[a=e],s=l.side(!i,n),c=l.side(i,n)}let h=VA(e.text,s,l.forward(i,n));(h<l.from||h>l.to)&&(h=c),tx=e.text.slice(Math.min(s,h),Math.max(s,h));let d=a==(i?t.length-1:0)?null:t[a+(i?1:-1)];return d&&h==c&&d.level+(i?0:1)<l.level?ty.cursor(d.side(!i,n)+e.from,d.forward(i,n)?1:-1,d.level):ty.cursor(h+e.from,l.forward(i,n)?-1:1,l.level)}function rx(e,t,n){for(let r=t;r<n;r++){let t=WC(e.charCodeAt(r));if(1==t)return QC;if(2==t||4==t)return VC}return QC}const ix=iy.define(),ox=iy.define(),sx=iy.define(),ax=iy.define(),lx=iy.define(),cx=iy.define(),hx=iy.define(),dx=iy.define(),ux=iy.define(),px=iy.define({combine:e=>e.some(e=>e)}),fx=iy.define({combine:e=>e.some(e=>e)}),gx=iy.define();class mx{constructor(e,t="nearest",n="nearest",r=5,i=5,o=!1){this.range=e,this.y=t,this.x=n,this.yMargin=r,this.xMargin=i,this.isSnapshot=o}map(e){return e.empty?this:new mx(this.range.map(e),this.y,this.x,this.yMargin,this.xMargin,this.isSnapshot)}clip(e){return this.range.to<=e.doc.length?this:new mx(ty.cursor(e.doc.length),this.y,this.x,this.yMargin,this.xMargin,this.isSnapshot)}}const vx=Ry.define({map:(e,t)=>e.map(t)}),bx=Ry.define();function Ax(e,t,n){let r=e.facet(ax);r.length?r[0](t):window.onerror&&window.onerror(String(t),n,void 0,void 0,t)||(n?console.error(n+":",t):console.error(t))}const yx=iy.define({combine:e=>!e.length||e[0]});let wx=0;const Cx=iy.define({combine:e=>e.filter((t,n)=>{for(let r=0;r<n;r++)if(e[r].plugin==t.plugin)return!1;return!0})});class xx{constructor(e,t,n,r,i){this.id=e,this.create=t,this.domEventHandlers=n,this.domEventObservers=r,this.baseExtensions=i(this),this.extension=this.baseExtensions.concat(Cx.of({plugin:this,arg:void 0}))}of(e){return this.baseExtensions.concat(Cx.of({plugin:this,arg:e}))}static define(e,t){const{eventHandlers:n,eventObservers:r,provide:i,decorations:o}=t||{};return new xx(wx++,e,n,r,e=>{let t=[];return o&&t.push(Bx.of(t=>{let n=t.plugin(e);return n?o(n):OC.none})),i&&t.push(i(e)),t})}static fromClass(e,t){return xx.define((t,n)=>new e(t,n),t)}}class kx{constructor(e){this.spec=e,this.mustUpdate=null,this.value=null}get plugin(){return this.spec&&this.spec.plugin}update(e){if(this.value){if(this.mustUpdate){let e=this.mustUpdate;if(this.mustUpdate=null,this.value.update)try{this.value.update(e)}catch(t){if(Ax(e.state,t,"CodeMirror plugin crashed"),this.value.destroy)try{this.value.destroy()}catch(e){}this.deactivate()}}}else if(this.spec)try{this.value=this.spec.plugin.create(e,this.spec.arg)}catch(t){Ax(e.state,t,"CodeMirror plugin crashed"),this.deactivate()}return this}destroy(e){var t;if(null===(t=this.value)||void 0===t?void 0:t.destroy)try{this.value.destroy()}catch(t){Ax(e.state,t,"CodeMirror plugin crashed")}}deactivate(){this.spec=this.value=null}}const Sx=iy.define(),Ox=iy.define(),Bx=iy.define(),_x=iy.define(),Tx=iy.define(),Ex=iy.define();function Mx(e,t){let n=e.state.facet(Ex);if(!n.length)return n;let r=n.map(t=>t instanceof Function?t(e):t),i=[];return Ky.spans(r,t.from,t.to,{point(){},span(e,n,r,o){let s=e-t.from,a=n-t.from,l=i;for(let e=r.length-1;e>=0;e--,o--){let n,i=r[e].spec.bidiIsolate;if(null==i&&(i=rx(t.text,s,a)),o>0&&l.length&&(n=l[l.length-1]).to==s&&n.direction==i)n.to=a,l=n.inner;else{let e={from:s,to:a,direction:i,inner:[]};l.push(e),l=e.inner}}}}),i}const Dx=iy.define();function Px(e){let t=0,n=0,r=0,i=0;for(let o of e.state.facet(Dx)){let s=o(e);s&&(null!=s.left&&(t=Math.max(t,s.left)),null!=s.right&&(n=Math.max(n,s.right)),null!=s.top&&(r=Math.max(r,s.top)),null!=s.bottom&&(i=Math.max(i,s.bottom)))}return{left:t,right:n,top:r,bottom:i}}const Rx=iy.define();class Ix{constructor(e,t,n,r){this.fromA=e,this.toA=t,this.fromB=n,this.toB=r}join(e){return new Ix(Math.min(this.fromA,e.fromA),Math.max(this.toA,e.toA),Math.min(this.fromB,e.fromB),Math.max(this.toB,e.toB))}addToSet(e){let t=e.length,n=this;for(;t>0;t--){let r=e[t-1];if(!(r.fromA>n.toA)){if(r.toA<n.fromA)break;n=n.join(r),e.splice(t-1,1)}}return e.splice(t,0,n),e}static extendWithRanges(e,t){if(0==t.length)return e;let n=[];for(let r=0,i=0,o=0,s=0;;r++){let a=r==e.length?null:e[r],l=o-s,c=a?a.fromB:1e9;for(;i<t.length&&t[i]<c;){let e=t[i],r=t[i+1],o=Math.max(s,e),a=Math.min(c,r);if(o<=a&&new Ix(o+l,a+l,o,a).addToSet(n),r>c)break;i+=2}if(!a)return n;new Ix(a.fromA,a.toA,a.fromB,a.toB).addToSet(n),o=a.toA,s=a.toB}}}class Lx{constructor(e,t,n){this.view=e,this.state=t,this.transactions=n,this.flags=0,this.startState=e.state,this.changes=UA.empty(this.startState.doc.length);for(let e of n)this.changes=this.changes.compose(e.changes);let r=[];this.changes.iterChangedRanges((e,t,n,i)=>r.push(new Ix(e,t,n,i))),this.changedRanges=r}static create(e,t,n){return new Lx(e,t,n)}get viewportChanged(){return(4&this.flags)>0}get viewportMoved(){return(8&this.flags)>0}get heightChanged(){return(2&this.flags)>0}get geometryChanged(){return this.docChanged||(18&this.flags)>0}get focusChanged(){return(1&this.flags)>0}get docChanged(){return!this.changes.empty}get selectionSet(){return this.transactions.some(e=>e.selection)}get empty(){return 0==this.flags&&0==this.transactions.length}}class Nx extends sC{get length(){return this.view.state.doc.length}constructor(e){super(),this.view=e,this.decorations=[],this.dynamicDecorationMap=[!1],this.domChanged=null,this.hasComposition=null,this.markedForComposition=new Set,this.editContextFormatting=OC.none,this.lastCompositionAfterCursor=!1,this.minWidth=0,this.minWidthFrom=0,this.minWidthTo=0,this.impreciseAnchor=null,this.impreciseHead=null,this.forceSelection=!1,this.lastUpdate=Date.now(),this.setDOM(e.contentDOM),this.children=[new DC],this.children[0].setParent(this),this.updateDeco(),this.updateInner([new Ix(0,0,0,e.state.doc.length)],0,null)}update(e){var t;let n=e.changedRanges;this.minWidth>0&&n.length&&(n.every(({fromA:e,toA:t})=>t<this.minWidthFrom||e>this.minWidthTo)?(this.minWidthFrom=e.changes.mapPos(this.minWidthFrom,1),this.minWidthTo=e.changes.mapPos(this.minWidthTo,1)):this.minWidth=this.minWidthFrom=this.minWidthTo=0),this.updateEditContextFormatting(e);let r=-1;this.view.inputState.composing>=0&&!this.view.observer.editContext&&((null===(t=this.domChanged)||void 0===t?void 0:t.newSel)?r=this.domChanged.newSel.head:function(e,t){let n=!1;t&&e.iterChangedRanges((e,r)=>{e<t.to&&r>t.from&&(n=!0)});return n}(e.changes,this.hasComposition)||e.selectionSet||(r=e.state.selection.main.head));let i=r>-1?function(e,t,n){let r=Fx(e,n);if(!r)return null;let{node:i,from:o,to:s}=r,a=i.nodeValue;if(/[\n\r]/.test(a))return null;if(e.state.doc.sliceString(r.from,r.to)!=a)return null;let l=t.invertedDesc,c=new Ix(l.mapPos(o),l.mapPos(s),o,s),h=[];for(let t=i.parentNode;;t=t.parentNode){let n=sC.get(t);if(n instanceof uC)h.push({node:t,deco:n.mark});else{if(n instanceof DC||"DIV"==t.nodeName&&t.parentNode==e.contentDOM)return{range:c,text:i,marks:h,line:t};if(t==e.contentDOM)return null;h.push({node:t,deco:new BC({inclusive:!0,attributes:xC(t),tagName:t.tagName.toLowerCase()})})}}}(this.view,e.changes,r):null;if(this.domChanged=null,this.hasComposition){this.markedForComposition.clear();let{from:t,to:r}=this.hasComposition;n=new Ix(t,r,e.changes.mapPos(t,-1),e.changes.mapPos(r,1)).addToSet(n.slice())}this.hasComposition=i?{from:i.range.fromB,to:i.range.toB}:null,(Iw.ie||Iw.chrome)&&!i&&e&&e.state.doc.lines!=e.startState.doc.lines&&(this.forceSelection=!0);let o=function(e,t,n){let r=new Qx;return Ky.compare(e,t,n,r),r.changes}(this.decorations,this.updateDeco(),e.changes);return n=Ix.extendWithRanges(n,o),!!(7&this.flags||0!=n.length)&&(this.updateInner(n,e.startState.doc.length,i),e.transactions.length&&(this.lastUpdate=Date.now()),!0)}updateInner(e,t,n){this.view.viewState.mustMeasureContent=!0,this.updateChildren(e,t,n);let{observer:r}=this.view;r.ignore(()=>{this.dom.style.height=this.view.viewState.contentHeight/this.view.scaleY+"px",this.dom.style.flexBasis=this.minWidth?this.minWidth+"px":"";let e=Iw.chrome||Iw.ios?{node:r.selectionRange.focusNode,written:!1}:void 0;this.sync(this.view,e),this.flags&=-8,e&&(e.written||r.selectionRange.focusNode!=e.node)&&(this.forceSelection=!0),this.dom.style.height=""}),this.markedForComposition.forEach(e=>e.flags&=-9);let i=[];if(this.view.viewport.from||this.view.viewport.to<this.view.state.doc.length)for(let e of this.children)e instanceof PC&&e.widget instanceof RC&&i.push(e.dom);r.updateGaps(i)}updateChildren(e,t,n){let r=n?n.range.addToSet(e.slice()):e,i=this.childCursor(t);for(let e=r.length-1;;e--){let t=e>=0?r[e]:null;if(!t)break;let o,s,a,l,{fromA:c,toA:h,fromB:d,toB:u}=t;if(n&&n.range.fromB<u&&n.range.toB>d){let e=IC.build(this.view.state.doc,d,n.range.fromB,this.decorations,this.dynamicDecorationMap),t=IC.build(this.view.state.doc,n.range.toB,u,this.decorations,this.dynamicDecorationMap);s=e.breakAtStart,a=e.openStart,l=t.openEnd;let r=this.compositionView(n);t.breakAtStart?r.breakAfter=1:t.content.length&&r.merge(r.length,r.length,t.content[0],!1,t.openStart,0)&&(r.breakAfter=t.content[0].breakAfter,t.content.shift()),e.content.length&&r.merge(0,0,e.content[e.content.length-1],!0,0,e.openEnd)&&e.content.pop(),o=e.content.concat(r).concat(t.content)}else({content:o,breakAtStart:s,openStart:a,openEnd:l}=IC.build(this.view.state.doc,d,u,this.decorations,this.dynamicDecorationMap));let{i:p,off:f}=i.findPos(h,1),{i:g,off:m}=i.findPos(c,-1);cC(this,g,m,p,f,o,s,a,l)}n&&this.fixCompositionDOM(n)}updateEditContextFormatting(e){this.editContextFormatting=this.editContextFormatting.map(e.changes);for(let t of e.transactions)for(let e of t.effects)e.is(bx)&&(this.editContextFormatting=e.value)}compositionView(e){let t=new dC(e.text.nodeValue);t.flags|=8;for(let{deco:n}of e.marks)t=new uC(n,[t],t.length);let n=new DC;return n.append(t,0),n}fixCompositionDOM(e){let t=(e,t)=>{t.flags|=8|(t.children.some(e=>7&e.flags)?1:0),this.markedForComposition.add(t);let n=sC.get(e);n&&n!=t&&(n.dom=null),t.setDOM(e)},n=this.childPos(e.range.fromB,1),r=this.children[n.i];t(e.line,r);for(let i=e.marks.length-1;i>=-1;i--)n=r.childPos(n.off,1),r=r.children[n.i],t(i>=0?e.marks[i].node:e.text,r)}updateSelection(e=!1,t=!1){!e&&this.view.observer.selectionRange.focusNode||this.view.observer.readSelectionRange();let n=this.view.root.activeElement,r=n==this.dom,i=!r&&!(this.view.state.facet(yx)||this.dom.tabIndex>-1)&&Fw(this.dom,this.view.observer.selectionRange)&&!(n&&this.dom.contains(n));if(!(r||t||i))return;let o=this.forceSelection;this.forceSelection=!1;let s=this.view.state.selection.main,a=this.moveToLine(this.domAtPos(s.anchor)),l=s.empty?a:this.moveToLine(this.domAtPos(s.head));if(Iw.gecko&&s.empty&&!this.hasComposition&&(1==(c=a).node.nodeType&&c.node.firstChild&&(0==c.offset||"false"==c.node.childNodes[c.offset-1].contentEditable)&&(c.offset==c.node.childNodes.length||"false"==c.node.childNodes[c.offset].contentEditable))){let e=document.createTextNode("");this.view.observer.ignore(()=>a.node.insertBefore(e,a.node.childNodes[a.offset]||null)),a=l=new iC(e,0),o=!0}var c;let h=this.view.observer.selectionRange;!o&&h.focusNode&&(Vw(a.node,a.offset,h.anchorNode,h.anchorOffset)&&Vw(l.node,l.offset,h.focusNode,h.focusOffset)||this.suppressWidgetCursorChange(h,s))||(this.view.observer.ignore(()=>{Iw.android&&Iw.chrome&&this.dom.contains(h.focusNode)&&function(e,t){for(let n=e;n&&n!=t;n=n.assignedSlot||n.parentNode)if(1==n.nodeType&&"false"==n.contentEditable)return!0;return!1}(h.focusNode,this.dom)&&(this.dom.blur(),this.dom.focus({preventScroll:!0}));let e=Lw(this.view.root);if(e)if(s.empty){if(Iw.gecko){let e=(t=a.node,r=a.offset,1!=t.nodeType?0:(r&&"false"==t.childNodes[r-1].contentEditable?1:0)|(r<t.childNodes.length&&"false"==t.childNodes[r].contentEditable?2:0));if(e&&3!=e){let t=(1==e?nC:rC)(a.node,a.offset);t&&(a=new iC(t.node,t.offset))}}e.collapse(a.node,a.offset),null!=s.bidiLevel&&void 0!==e.caretBidiLevel&&(e.caretBidiLevel=s.bidiLevel)}else if(e.extend){e.collapse(a.node,a.offset);try{e.extend(l.node,l.offset)}catch(e){}}else{let t=document.createRange();s.anchor>s.head&&([a,l]=[l,a]),t.setEnd(l.node,l.offset),t.setStart(a.node,a.offset),e.removeAllRanges(),e.addRange(t)}else;var t,r;i&&this.view.root.activeElement==this.dom&&(this.dom.blur(),n&&n.focus())}),this.view.observer.setSelectionRange(a,l)),this.impreciseAnchor=a.precise?null:new iC(h.anchorNode,h.anchorOffset),this.impreciseHead=l.precise?null:new iC(h.focusNode,h.focusOffset)}suppressWidgetCursorChange(e,t){return this.hasComposition&&t.empty&&Vw(e.focusNode,e.focusOffset,e.anchorNode,e.anchorOffset)&&this.posFromDOM(e.focusNode,e.focusOffset)==t.head}enforceCursorAssoc(){if(this.hasComposition)return;let{view:e}=this,t=e.state.selection.main,n=Lw(e.root),{anchorNode:r,anchorOffset:i}=e.observer.selectionRange;if(!(n&&t.empty&&t.assoc&&n.modify))return;let o=DC.find(this,t.head);if(!o)return;let s=o.posAtStart;if(t.head==s||t.head==s+o.length)return;let a=this.coordsAt(t.head,-1),l=this.coordsAt(t.head,1);if(!a||!l||a.bottom>l.top)return;let c=this.domAtPos(t.head+t.assoc);n.collapse(c.node,c.offset),n.modify("move",t.assoc<0?"forward":"backward","lineboundary"),e.observer.readSelectionRange();let h=e.observer.selectionRange;e.docView.posFromDOM(h.anchorNode,h.anchorOffset)!=t.from&&n.collapse(r,i)}moveToLine(e){let t,n=this.dom;if(e.node!=n)return e;for(let r=e.offset;!t&&r<n.childNodes.length;r++){let e=sC.get(n.childNodes[r]);e instanceof DC&&(t=e.domAtPos(0))}for(let r=e.offset-1;!t&&r>=0;r--){let e=sC.get(n.childNodes[r]);e instanceof DC&&(t=e.domAtPos(e.length))}return t?new iC(t.node,t.offset,!0):e}nearest(e){for(let t=e;t;){let e=sC.get(t);if(e&&e.rootView==this)return e;t=t.parentNode}return null}posFromDOM(e,t){let n=this.nearest(e);if(!n)throw new RangeError("Trying to find position for a DOM position outside of the document");return n.localPosFromDOM(e,t)+n.posAtStart}domAtPos(e){let{i:t,off:n}=this.childCursor().findPos(e,-1);for(;t<this.children.length-1;){let e=this.children[t];if(n<e.length||e instanceof DC)break;t++,n=0}return this.children[t].domAtPos(n)}coordsAt(e,t){let n=null,r=0;for(let i=this.length,o=this.children.length-1;o>=0;o--){let s=this.children[o],a=i-s.breakAfter,l=a-s.length;if(a<e)break;if(l<=e&&(l<e||s.covers(-1))&&(a>e||s.covers(1))&&(!n||s instanceof DC&&!(n instanceof DC&&t>=0)))n=s,r=l;else if(n&&l==e&&a==e&&s instanceof PC&&Math.abs(t)<2){if(s.deco.startSide<0)break;o&&(n=null)}i=l}return n?n.coordsAt(e-r,t):null}coordsForChar(e){let{i:t,off:n}=this.childPos(e,1),r=this.children[t];if(!(r instanceof DC))return null;for(;r.children.length;){let{i:e,off:t}=r.childPos(n,1);for(;;e++){if(e==r.children.length)return null;if((r=r.children[e]).length)break}n=t}if(!(r instanceof dC))return null;let i=VA(r.text,n);if(i==n)return null;let o=Kw(r.dom,n,i).getClientRects();for(let e=0;e<o.length;e++){let t=o[e];if(e==o.length-1||t.top<t.bottom&&t.left<t.right)return t}return null}measureVisibleLineHeights(e){let t=[],{from:n,to:r}=e,i=this.view.contentDOM.clientWidth,o=i>Math.max(this.view.scrollDOM.clientWidth,this.minWidth)+1,s=-1,a=this.view.textDirection==FC.LTR;for(let e=0,l=0;l<this.children.length;l++){let c=this.children[l],h=e+c.length;if(h>r)break;if(e>=n){let n=c.dom.getBoundingClientRect();if(t.push(n.height),o){let t=c.dom.lastChild,r=t?Qw(t):[];if(r.length){let t=r[r.length-1],o=a?t.right-n.left:n.right-t.left;o>s&&(s=o,this.minWidth=i,this.minWidthFrom=e,this.minWidthTo=h)}}}e=h+c.breakAfter}return t}textDirectionAt(e){let{i:t}=this.childPos(e,1);return"rtl"==getComputedStyle(this.children[t].dom).direction?FC.RTL:FC.LTR}measureTextSize(){for(let e of this.children)if(e instanceof DC){let t=e.measureTextSize();if(t)return t}let e,t,n,r=document.createElement("div");return r.className="cm-line",r.style.width="99999px",r.style.position="absolute",r.textContent="abc def ghi jkl mno pqr stu",this.view.observer.ignore(()=>{this.dom.appendChild(r);let i=Qw(r.firstChild)[0];e=r.getBoundingClientRect().height,t=i?i.width/27:7,n=i?i.height:e,r.remove()}),{lineHeight:e,charWidth:t,textHeight:n}}childCursor(e=this.length){let t=this.children.length;return t&&(e-=this.children[--t].length),new lC(this.children,e,t)}computeBlockGapDeco(){let e=[],t=this.view.viewState;for(let n=0,r=0;;r++){let i=r==t.viewports.length?null:t.viewports[r],o=i?i.from-1:this.length;if(o>n){let r=(t.lineBlockAt(o).bottom-t.lineBlockAt(n).top)/this.view.scaleY;e.push(OC.replace({widget:new RC(r),block:!0,inclusive:!0,isBlockGap:!0}).range(n,o))}if(!i)break;n=i.to+1}return OC.set(e)}updateDeco(){let e=1,t=this.view.state.facet(Bx).map(t=>(this.dynamicDecorationMap[e++]="function"==typeof t)?t(this.view):t),n=!1,r=this.view.state.facet(_x).map((e,t)=>{let r="function"==typeof e;return r&&(n=!0),r?e(this.view):e});for(r.length&&(this.dynamicDecorationMap[e++]=n,t.push(Ky.join(r))),this.decorations=[this.editContextFormatting,...t,this.computeBlockGapDeco(),this.view.viewState.lineGapDeco];e<this.decorations.length;)this.dynamicDecorationMap[e++]=!1;return this.decorations}scrollIntoView(e){if(e.isSnapshot){let t=this.view.viewState.lineBlockAt(e.range.head);return this.view.scrollDOM.scrollTop=t.top-e.yMargin,void(this.view.scrollDOM.scrollLeft=e.xMargin)}for(let t of this.view.state.facet(gx))try{if(t(this.view,e.range,e))return!0}catch(e){Ax(this.view.state,e,"scroll handler")}let t,{range:n}=e,r=this.coordsAt(n.head,n.empty?n.assoc:n.head>n.anchor?-1:1);if(!r)return;!n.empty&&(t=this.coordsAt(n.anchor,n.anchor>n.head?-1:1))&&(r={left:Math.min(r.left,t.left),top:Math.min(r.top,t.top),right:Math.max(r.right,t.right),bottom:Math.max(r.bottom,t.bottom)});let i=Px(this.view),o={left:r.left-i.left,top:r.top-i.top,right:r.right+i.right,bottom:r.bottom+i.bottom},{offsetWidth:s,offsetHeight:a}=this.view.scrollDOM;!function(e,t,n,r,i,o,s,a){let l=e.ownerDocument,c=l.defaultView||window;for(let h=e,d=!1;h&&!d;)if(1==h.nodeType){let e,u=h==l.body,p=1,f=1;if(u)e=Ww(c);else{if(/^(fixed|sticky)$/.test(getComputedStyle(h).position)&&(d=!0),h.scrollHeight<=h.clientHeight&&h.scrollWidth<=h.clientWidth){h=h.assignedSlot||h.parentNode;continue}let t=h.getBoundingClientRect();({scaleX:p,scaleY:f}=Uw(h,t)),e={left:t.left,right:t.left+h.clientWidth*p,top:t.top,bottom:t.top+h.clientHeight*f}}let g=0,m=0;if("nearest"==i)t.top<e.top?(m=t.top-(e.top+s),n>0&&t.bottom>e.bottom+m&&(m=t.bottom-e.bottom+s)):t.bottom>e.bottom&&(m=t.bottom-e.bottom+s,n<0&&t.top-m<e.top&&(m=t.top-(e.top+s)));else{let r=t.bottom-t.top,o=e.bottom-e.top;m=("center"==i&&r<=o?t.top+r/2-o/2:"start"==i||"center"==i&&n<0?t.top-s:t.bottom-o+s)-e.top}if("nearest"==r?t.left<e.left?(g=t.left-(e.left+o),n>0&&t.right>e.right+g&&(g=t.right-e.right+o)):t.right>e.right&&(g=t.right-e.right+o,n<0&&t.left<e.left+g&&(g=t.left-(e.left+o))):g=("center"==r?t.left+(t.right-t.left)/2-(e.right-e.left)/2:"start"==r==a?t.left-o:t.right-(e.right-e.left)+o)-e.left,g||m)if(u)c.scrollBy(g,m);else{let e=0,n=0;if(m){let e=h.scrollTop;h.scrollTop+=m/f,n=(h.scrollTop-e)*f}if(g){let t=h.scrollLeft;h.scrollLeft+=g/p,e=(h.scrollLeft-t)*p}t={left:t.left-e,top:t.top-n,right:t.right-e,bottom:t.bottom-n},e&&Math.abs(e-g)<1&&(r="nearest"),n&&Math.abs(n-m)<1&&(i="nearest")}if(u)break;(t.top<e.top||t.bottom>e.bottom||t.left<e.left||t.right>e.right)&&(t={left:Math.max(t.left,e.left),right:Math.min(t.right,e.right),top:Math.max(t.top,e.top),bottom:Math.min(t.bottom,e.bottom)}),h=h.assignedSlot||h.parentNode}else{if(11!=h.nodeType)break;h=h.host}}(this.view.scrollDOM,o,n.head<n.anchor?-1:1,e.x,e.y,Math.max(Math.min(e.xMargin,s),-s),Math.max(Math.min(e.yMargin,a),-a),this.view.textDirection==FC.LTR)}}function Fx(e,t){let n=e.observer.selectionRange;if(!n.focusNode)return null;let r=nC(n.focusNode,n.focusOffset),i=rC(n.focusNode,n.focusOffset),o=r||i;if(i&&r&&i.node!=r.node){let t=sC.get(i.node);if(!t||t instanceof dC&&t.text!=i.node.nodeValue)o=i;else if(e.docView.lastCompositionAfterCursor){let e=sC.get(r.node);!e||e instanceof dC&&e.text!=r.node.nodeValue||(o=i)}}if(e.docView.lastCompositionAfterCursor=o!=r,!o)return null;let s=t-o.offset;return{from:s,to:s+o.node.nodeValue.length,node:o.node}}let Qx=class{constructor(){this.changes=[]}compareRange(e,t){MC(e,t,this.changes)}comparePoint(e,t){MC(e,t,this.changes)}boundChange(e){MC(e,e,this.changes)}};function Vx(e,t){return t.left>e?t.left-e:Math.max(0,e-t.right)}function zx(e,t){return t.top>e?t.top-e:Math.max(0,e-t.bottom)}function $x(e,t){return e.top<t.bottom-1&&e.bottom>t.top+1}function Hx(e,t){return t<e.top?{top:t,left:e.left,right:e.right,bottom:e.bottom}:e}function jx(e,t){return t>e.bottom?{top:e.top,left:e.left,right:e.right,bottom:t}:e}function qx(e,t,n){let r,i,o,s,a,l,c,h,d=!1;for(let u=e.firstChild;u;u=u.nextSibling){let e=Qw(u);for(let p=0;p<e.length;p++){let f=e[p];i&&$x(i,f)&&(f=Hx(jx(f,i.bottom),i.top));let g=Vx(t,f),m=zx(n,f);if(0==g&&0==m)return 3==u.nodeType?Wx(u,t,n):qx(u,t,n);(!r||s>m||s==m&&o>g)&&(r=u,i=f,o=g,s=m,d=!g||(t<f.left?p>0:p<e.length-1)),0==g?n>f.bottom&&(!c||c.bottom<f.bottom)?(a=u,c=f):n<f.top&&(!h||h.top>f.top)&&(l=u,h=f):c&&$x(c,f)?c=jx(c,f.bottom):h&&$x(h,f)&&(h=Hx(h,f.top))}}if(c&&c.bottom>=n?(r=a,i=c):h&&h.top<=n&&(r=l,i=h),!r)return{node:e,offset:0};let u=Math.max(i.left,Math.min(i.right,t));return 3==r.nodeType?Wx(r,u,n):d&&"false"!=r.contentEditable?qx(r,u,n):{node:e,offset:Array.prototype.indexOf.call(e.childNodes,r)+(t>=(i.left+i.right)/2?1:0)}}function Wx(e,t,n){let r=e.nodeValue.length,i=-1,o=1e9,s=0;for(let a=0;a<r;a++){let r=Kw(e,a,a+1).getClientRects();for(let l=0;l<r.length;l++){let c=r[l];if(c.top==c.bottom)continue;s||(s=t-c.left);let h=(c.top>n?c.top-n:n-c.bottom)-1;if(c.left-1<=t&&c.right+1>=t&&h<o){let n=t>=(c.left+c.right)/2,r=n;if(Iw.chrome||Iw.gecko){Kw(e,a).getBoundingClientRect().left==c.right&&(r=!n)}if(h<=0)return{node:e,offset:a+(r?1:0)};i=a+(r?1:0),o=h}}}return{node:e,offset:i>-1?i:s>0?e.nodeValue.length:0}}function Ux(e,t,n,r=-1){var i,o;let s,a=e.contentDOM.getBoundingClientRect(),l=a.top+e.viewState.paddingTop,{docHeight:c}=e.viewState,{x:h,y:d}=t,u=d-l;if(u<0)return 0;if(u>c)return e.state.doc.length;for(let t=e.viewState.heightOracle.textHeight/2,i=!1;s=e.elementAtHeight(u),s.type!=SC.Text;)for(;u=r>0?s.bottom+t:s.top-t,!(u>=0&&u<=c);){if(i)return n?null:0;i=!0,r=-r}d=l+u;let p=s.from;if(p<e.viewport.from)return 0==e.viewport.from?0:n?null:Yx(e,a,s,h,d);if(p>e.viewport.to)return e.viewport.to==e.state.doc.length?e.state.doc.length:n?null:Yx(e,a,s,h,d);let f=e.dom.ownerDocument,g=e.root.elementFromPoint?e.root:f,m=g.elementFromPoint(h,d);m&&!e.contentDOM.contains(m)&&(m=null),m||(h=Math.max(a.left+1,Math.min(a.right-1,h)),m=g.elementFromPoint(h,d),m&&!e.contentDOM.contains(m)&&(m=null));let v,b=-1;if(m&&0!=(null===(i=e.docView.nearest(m))||void 0===i?void 0:i.isEditable)){if(f.caretPositionFromPoint){let e=f.caretPositionFromPoint(h,d);e&&({offsetNode:v,offset:b}=e)}else if(f.caretRangeFromPoint){let e=f.caretRangeFromPoint(h,d);e&&({startContainer:v,startOffset:b}=e)}v&&(!e.contentDOM.contains(v)||Iw.safari&&function(e,t,n){return Gx(e,t,n)}(v,b,h)||Iw.chrome&&function(e,t,n){if(0!=t)return Gx(e,t,n);for(let t=e;;){let e=t.parentNode;if(!e||1!=e.nodeType||e.firstChild!=t)return!1;if(e.classList.contains("cm-line"))break;t=e}let r=1==e.nodeType?e.getBoundingClientRect():Kw(e,0,Math.max(e.nodeValue.length,1)).getBoundingClientRect();return n-r.left>5}(v,b,h))&&(v=void 0),v&&(b=Math.min(jw(v),b))}if(!v||!e.docView.dom.contains(v)){let t=DC.find(e.docView,p);if(!t)return u>s.top+s.height/2?s.to:s.from;({node:v,offset:b}=qx(t.dom,h,d))}let A=e.docView.nearest(v);if(!A)return null;if(A.isWidget&&1==(null===(o=A.dom)||void 0===o?void 0:o.nodeType)){let e=A.dom.getBoundingClientRect();return t.y<e.top||t.y<=e.bottom&&t.x<=(e.left+e.right)/2?A.posAtStart:A.posAtEnd}return A.localPosFromDOM(v,b)+A.posAtStart}function Yx(e,t,n,r,i){let o=Math.round((r-t.left)*e.defaultCharacterWidth);if(e.lineWrapping&&n.height>1.5*e.defaultLineHeight){let t=e.viewState.heightOracle.textHeight;o+=Math.floor((i-n.top-.5*(e.defaultLineHeight-t))/t)*e.viewState.heightOracle.lineLength}let s=e.state.sliceDoc(n.from,n.to);return n.from+dw(s,o,e.state.tabSize)}function Gx(e,t,n){let r,i=e;if(3!=e.nodeType||t!=(r=e.nodeValue.length))return!1;for(;;){let e=i.nextSibling;if(e){if("BR"==e.nodeName)break;return!1}{let e=i.parentNode;if(!e||"DIV"==e.nodeName)break;i=e}}return Kw(e,r-1,r).getBoundingClientRect().right>n}function Xx(e,t,n){let r=e.lineBlockAt(t);if(Array.isArray(r.type)){let e;for(let i of r.type){if(i.from>t)break;if(!(i.to<t)){if(i.from<t&&i.to>t)return i;e&&(i.type!=SC.Text||e.type==i.type&&!(n<0?i.from<t:i.to>t))||(e=i)}}return e||r}return r}function Jx(e,t,n,r){let i=e.state.doc.lineAt(t.head),o=e.bidiSpans(i),s=e.textDirectionAt(i.from);for(let a=t,l=null;;){let t=nx(i,o,s,a,n),c=tx;if(!t){if(i.number==(n?e.state.doc.lines:1))return a;c="\n",i=e.state.doc.line(i.number+(n?1:-1)),o=e.bidiSpans(i),t=e.visualLineSide(i,!n)}if(l){if(!l(c))return a}else{if(!r)return t;l=r(c)}a=t}}function Kx(e,t,n){for(;;){let r=0;for(let i of e)i.between(t-1,t+1,(e,i,o)=>{if(t>e&&t<i){let o=r||n||(t-e<i-t?-1:1);t=o<0?e:i,r=o}});if(!r)return t}}function Zx(e,t){let n=null;for(let r=0;r<t.ranges.length;r++){let i=t.ranges[r],o=null;if(i.empty){let t=Kx(e,i.from,0);t!=i.from&&(o=ty.cursor(t,-1))}else{let t=Kx(e,i.from,-1),n=Kx(e,i.to,1);t==i.from&&n==i.to||(o=ty.range(i.from==i.anchor?t:n,i.from==i.head?t:n))}o&&(n||(n=t.ranges.slice()),n[r]=o)}return n?ty.create(n,t.mainIndex):t}function ek(e,t,n){let r=Kx(e.state.facet(Tx).map(t=>t(e)),n.from,t.head>n.from?-1:1);return r==n.from?n:ty.cursor(r,r<n.from?1:-1)}const tk="￿";class nk{constructor(e,t){this.points=e,this.text="",this.lineSeparator=t.facet(Wy.lineSeparator)}append(e){this.text+=e}lineBreak(){this.text+=tk}readRange(e,t){if(!e)return this;let n=e.parentNode;for(let r=e;;){this.findPointBefore(n,r);let e=this.text.length;this.readNode(r);let i=r.nextSibling;if(i==t)break;let o=sC.get(r),s=sC.get(i);(o&&s?o.breakAfter:(o?o.breakAfter:$w(r))||$w(i)&&("BR"!=r.nodeName||r.cmIgnore)&&this.text.length>e)&&!ik(i,t)&&this.lineBreak(),r=i}return this.findPointBefore(n,t),this}readTextNode(e){let t=e.nodeValue;for(let n of this.points)n.node==e&&(n.pos=this.text.length+Math.min(n.offset,t.length));for(let n=0,r=this.lineSeparator?null:/\r\n?|\n/g;;){let i,o=-1,s=1;if(this.lineSeparator?(o=t.indexOf(this.lineSeparator,n),s=this.lineSeparator.length):(i=r.exec(t))&&(o=i.index,s=i[0].length),this.append(t.slice(n,o<0?t.length:o)),o<0)break;if(this.lineBreak(),s>1)for(let t of this.points)t.node==e&&t.pos>this.text.length&&(t.pos-=s-1);n=o+s}}readNode(e){if(e.cmIgnore)return;let t=sC.get(e),n=t&&t.overrideDOMText;if(null!=n){this.findPointInside(e,n.length);for(let e=n.iter();!e.next().done;)e.lineBreak?this.lineBreak():this.append(e.value)}else 3==e.nodeType?this.readTextNode(e):"BR"==e.nodeName?e.nextSibling&&this.lineBreak():1==e.nodeType&&this.readRange(e.firstChild,null)}findPointBefore(e,t){for(let n of this.points)n.node==e&&e.childNodes[n.offset]==t&&(n.pos=this.text.length)}findPointInside(e,t){for(let n of this.points)(3==e.nodeType?n.node==e:e.contains(n.node))&&(n.pos=this.text.length+(rk(e,n.node,n.offset)?t:0))}}function rk(e,t,n){for(;;){if(!t||n<jw(t))return!1;if(t==e)return!0;n=zw(t)+1,t=t.parentNode}}function ik(e,t){let n;for(;e!=t&&e;e=e.nextSibling){let t=sC.get(e);if(!(null==t?void 0:t.isWidget)&&!e.cmIgnore)return!1;t&&(n||(n=[])).push(t)}if(n)for(let e of n){let t=e.overrideDOMText;if(null==t?void 0:t.length)return!1}return!0}class ok{constructor(e,t){this.node=e,this.offset=t,this.pos=-1}}class sk{constructor(e,t,n,r){this.typeOver=r,this.bounds=null,this.text="",this.domChanged=t>-1;let{impreciseHead:i,impreciseAnchor:o}=e.docView;if(e.state.readOnly&&t>-1)this.newSel=null;else if(t>-1&&(this.bounds=e.docView.domBoundsAround(t,n,0))){let t=i||o?[]:function(e){let t=[];if(e.root.activeElement!=e.contentDOM)return t;let{anchorNode:n,anchorOffset:r,focusNode:i,focusOffset:o}=e.observer.selectionRange;n&&(t.push(new ok(n,r)),i==n&&o==r||t.push(new ok(i,o)));return t}(e),n=new nk(t,e.state);n.readRange(this.bounds.startDOM,this.bounds.endDOM),this.text=n.text,this.newSel=function(e,t){if(0==e.length)return null;let n=e[0].pos,r=2==e.length?e[1].pos:n;return n>-1&&r>-1?ty.single(n+t,r+t):null}(t,this.bounds.from)}else{let t=e.observer.selectionRange,n=i&&i.node==t.focusNode&&i.offset==t.focusOffset||!Nw(e.contentDOM,t.focusNode)?e.state.selection.main.head:e.docView.posFromDOM(t.focusNode,t.focusOffset),r=o&&o.node==t.anchorNode&&o.offset==t.anchorOffset||!Nw(e.contentDOM,t.anchorNode)?e.state.selection.main.anchor:e.docView.posFromDOM(t.anchorNode,t.anchorOffset),s=e.viewport;if((Iw.ios||Iw.chrome)&&e.state.selection.main.empty&&n!=r&&(s.from>0||s.to<e.state.doc.length)){let t=Math.min(n,r),i=Math.max(n,r),o=s.from-t,a=s.to-i;0!=o&&1!=o&&0!=t||0!=a&&-1!=a&&i!=e.state.doc.length||(n=0,r=e.state.doc.length)}this.newSel=ty.single(r,n)}}}function ak(e,t){let n,{newSel:r}=t,i=e.state.selection.main,o=e.inputState.lastKeyTime>Date.now()-100?e.inputState.lastKeyCode:-1;if(t.bounds){let{from:r,to:s}=t.bounds,a=i.from,l=null;(8===o||Iw.android&&t.text.length<s-r)&&(a=i.to,l="end");let c=ck(e.state.doc.sliceString(r,s,tk),t.text,a-r,l);c&&(Iw.chrome&&13==o&&c.toB==c.from+2&&t.text.slice(c.from,c.toB)==tk+tk&&c.toB--,n={from:r+c.from,to:r+c.toA,insert:EA.of(t.text.slice(c.from,c.toB).split(tk))})}else r&&(!e.hasFocus&&e.state.facet(yx)||r.main.eq(i))&&(r=null);if(!n&&!r)return!1;if(!n&&t.typeOver&&!i.empty&&r&&r.main.empty?n={from:i.from,to:i.to,insert:e.state.doc.slice(i.from,i.to)}:(Iw.mac||Iw.android)&&n&&n.from==n.to&&n.from==i.head-1&&/^\. ?$/.test(n.insert.toString())&&"off"==e.contentDOM.getAttribute("autocorrect")?(r&&2==n.insert.length&&(r=ty.single(r.main.anchor-1,r.main.head-1)),n={from:n.from,to:n.to,insert:EA.of([n.insert.toString().replace("."," ")])}):n&&n.from>=i.from&&n.to<=i.to&&(n.from!=i.from||n.to!=i.to)&&i.to-i.from-(n.to-n.from)<=4?n={from:i.from,to:i.to,insert:e.state.doc.slice(i.from,n.from).append(n.insert).append(e.state.doc.slice(n.to,i.to))}:Iw.chrome&&n&&n.from==n.to&&n.from==i.head&&"\n "==n.insert.toString()&&e.lineWrapping&&(r&&(r=ty.single(r.main.anchor-1,r.main.head-1)),n={from:i.from,to:i.to,insert:EA.of([" "])}),n)return lk(e,n,r,o);if(r&&!r.main.eq(i)){let t=!1,n="select";return e.inputState.lastSelectionTime>Date.now()-50&&("select"==e.inputState.lastSelectionOrigin&&(t=!0),n=e.inputState.lastSelectionOrigin,"select.pointer"==n&&(r=Zx(e.state.facet(Tx).map(t=>t(e)),r))),e.dispatch({selection:r,scrollIntoView:t,userEvent:n}),!0}return!1}function lk(e,t,n,r=-1){if(Iw.ios&&e.inputState.flushIOSKey(t))return!0;let i=e.state.selection.main;if(Iw.android&&(t.to==i.to&&(t.from==i.from||t.from==i.from-1&&" "==e.state.sliceDoc(t.from,i.from))&&1==t.insert.length&&2==t.insert.lines&&Zw(e.contentDOM,"Enter",13)||(t.from==i.from-1&&t.to==i.to&&0==t.insert.length||8==r&&t.insert.length<t.to-t.from&&t.to>i.head)&&Zw(e.contentDOM,"Backspace",8)||t.from==i.from&&t.to==i.to+1&&0==t.insert.length&&Zw(e.contentDOM,"Delete",46)))return!0;let o,s=t.insert.toString();e.inputState.composing>=0&&e.inputState.composing++;let a=()=>o||(o=function(e,t,n){let r,i=e.state,o=i.selection.main,s=-1;if(t.from==t.to&&t.from<o.from||t.from>o.to){let n=t.from<o.from?-1:1,r=n<0?o.from:o.to,a=Kx(i.facet(Tx).map(t=>t(e)),r,n);t.from==a&&(s=a)}if(s>-1)r={changes:t,selection:ty.cursor(t.from+t.insert.length,-1)};else if(t.from>=o.from&&t.to<=o.to&&t.to-t.from>=(o.to-o.from)/3&&(!n||n.main.empty&&n.main.from==t.from+t.insert.length)&&e.inputState.composing<0){let n=o.from<t.from?i.sliceDoc(o.from,t.from):"",s=o.to>t.to?i.sliceDoc(t.to,o.to):"";r=i.replaceSelection(e.state.toText(n+t.insert.sliceString(0,void 0,e.state.lineBreak)+s))}else{let s=i.changes(t),a=n&&n.main.to<=s.newLength?n.main:void 0;if(i.selection.ranges.length>1&&e.inputState.composing>=0&&t.to<=o.to&&t.to>=o.to-10){let l,c=e.state.sliceDoc(t.from,t.to),h=n&&Fx(e,n.main.head);if(h){let e=t.insert.length-(t.to-t.from);l={from:h.from,to:h.to-e}}else l=e.state.doc.lineAt(o.head);let d=o.to-t.to,u=o.to-o.from;r=i.changeByRange(n=>{if(n.from==o.from&&n.to==o.to)return{changes:s,range:a||n.map(s)};let r=n.to-d,h=r-c.length;if(n.to-n.from!=u||e.state.sliceDoc(h,r)!=c||n.to>=l.from&&n.from<=l.to)return{range:n};let p=i.changes({from:h,to:r,insert:t.insert}),f=n.to-o.to;return{changes:p,range:a?ty.range(Math.max(0,a.anchor+f),Math.max(0,a.head+f)):n.map(p)}})}else r={changes:s,selection:a&&i.selection.replaceRange(a)}}let a="input.type";(e.composing||e.inputState.compositionPendingChange&&e.inputState.compositionEndedAt>Date.now()-50)&&(e.inputState.compositionPendingChange=!1,a+=".compose",e.inputState.compositionFirstChange&&(a+=".start",e.inputState.compositionFirstChange=!1));return i.update(r,{userEvent:a,scrollIntoView:!0})}(e,t,n));return e.state.facet(cx).some(n=>n(e,t.from,t.to,s,a))||e.dispatch(a()),!0}function ck(e,t,n,r){let i=Math.min(e.length,t.length),o=0;for(;o<i&&e.charCodeAt(o)==t.charCodeAt(o);)o++;if(o==i&&e.length==t.length)return null;let s=e.length,a=t.length;for(;s>0&&a>0&&e.charCodeAt(s-1)==t.charCodeAt(a-1);)s--,a--;if("end"==r){n-=s+Math.max(0,o-Math.min(s,a))-o}if(s<o&&e.length<t.length){o-=n<=o&&n>=s?o-n:0,a=o+(a-s),s=o}else if(a<o){o-=n<=o&&n>=a?o-n:0,s=o+(s-a),a=o}return{from:o,toA:s,toB:a}}class hk{setSelectionOrigin(e){this.lastSelectionOrigin=e,this.lastSelectionTime=Date.now()}constructor(e){this.view=e,this.lastKeyCode=0,this.lastKeyTime=0,this.lastTouchTime=0,this.lastFocusTime=0,this.lastScrollTop=0,this.lastScrollLeft=0,this.pendingIOSKey=void 0,this.tabFocusMode=-1,this.lastSelectionOrigin=null,this.lastSelectionTime=0,this.lastContextMenu=0,this.scrollHandlers=[],this.handlers=Object.create(null),this.composing=-1,this.compositionFirstChange=null,this.compositionEndedAt=0,this.compositionPendingKey=!1,this.compositionPendingChange=!1,this.mouseSelection=null,this.draggedContent=null,this.handleEvent=this.handleEvent.bind(this),this.notifiedFocused=e.hasFocus,Iw.safari&&e.contentDOM.addEventListener("input",()=>null),Iw.gecko&&function(e){Nk.has(e)||(Nk.add(e),e.addEventListener("copy",()=>{}),e.addEventListener("cut",()=>{}))}(e.contentDOM.ownerDocument)}handleEvent(e){(function(e,t){if(!t.bubbles)return!0;if(t.defaultPrevented)return!1;for(let n,r=t.target;r!=e.contentDOM;r=r.parentNode)if(!r||11==r.nodeType||(n=sC.get(r))&&n.ignoreEvent(t))return!1;return!0})(this.view,e)&&!this.ignoreDuringComposition(e)&&("keydown"==e.type&&this.keydown(e)||(0!=this.view.updateState?Promise.resolve().then(()=>this.runHandlers(e.type,e)):this.runHandlers(e.type,e)))}runHandlers(e,t){let n=this.handlers[e];if(n){for(let e of n.observers)e(this.view,t);for(let e of n.handlers){if(t.defaultPrevented)break;if(e(this.view,t)){t.preventDefault();break}}}}ensureHandlers(e){let t=uk(e),n=this.handlers,r=this.view.contentDOM;for(let e in t)if("scroll"!=e){let i=!t[e].handlers.length,o=n[e];o&&i!=!o.handlers.length&&(r.removeEventListener(e,this.handleEvent),o=null),o||r.addEventListener(e,this.handleEvent,{passive:i})}for(let e in n)"scroll"==e||t[e]||r.removeEventListener(e,this.handleEvent);this.handlers=t}keydown(e){if(this.lastKeyCode=e.keyCode,this.lastKeyTime=Date.now(),9==e.keyCode&&this.tabFocusMode>-1&&(!this.tabFocusMode||Date.now()<=this.tabFocusMode))return!0;if(this.tabFocusMode>0&&27!=e.keyCode&&gk.indexOf(e.keyCode)<0&&(this.tabFocusMode=-1),Iw.android&&Iw.chrome&&!e.synthetic&&(13==e.keyCode||8==e.keyCode))return this.view.observer.delayAndroidKey(e.key,e.keyCode),!0;let t;return!Iw.ios||e.synthetic||e.altKey||e.metaKey||!((t=pk.find(t=>t.keyCode==e.keyCode))&&!e.ctrlKey||fk.indexOf(e.key)>-1&&e.ctrlKey&&!e.shiftKey)?(229!=e.keyCode&&this.view.observer.forceFlush(),!1):(this.pendingIOSKey=t||e,setTimeout(()=>this.flushIOSKey(),250),!0)}flushIOSKey(e){let t=this.pendingIOSKey;return!!t&&(!("Enter"==t.key&&e&&e.from<e.to&&/^\S+$/.test(e.insert.toString()))&&(this.pendingIOSKey=void 0,Zw(this.view.contentDOM,t.key,t.keyCode,t instanceof KeyboardEvent?t:void 0)))}ignoreDuringComposition(e){return!(!/^key/.test(e.type)||e.synthetic)&&(this.composing>0||!!(Iw.safari&&!Iw.ios&&this.compositionPendingKey&&Date.now()-this.compositionEndedAt<100)&&(this.compositionPendingKey=!1,!0))}startMouseSelection(e){this.mouseSelection&&this.mouseSelection.destroy(),this.mouseSelection=e}update(e){this.view.observer.update(e),this.mouseSelection&&this.mouseSelection.update(e),this.draggedContent&&e.docChanged&&(this.draggedContent=this.draggedContent.map(e.changes)),e.transactions.length&&(this.lastKeyCode=this.lastSelectionTime=0)}destroy(){this.mouseSelection&&this.mouseSelection.destroy()}}function dk(e,t){return(n,r)=>{try{return t.call(e,r,n)}catch(e){Ax(n.state,e)}}}function uk(e){let t=Object.create(null);function n(e){return t[e]||(t[e]={observers:[],handlers:[]})}for(let t of e){let e=t.spec,r=e&&e.plugin.domEventHandlers,i=e&&e.plugin.domEventObservers;if(r)for(let e in r){let i=r[e];i&&n(e).handlers.push(dk(t.value,i))}if(i)for(let e in i){let r=i[e];r&&n(e).observers.push(dk(t.value,r))}}for(let e in bk)n(e).handlers.push(bk[e]);for(let e in Ak)n(e).observers.push(Ak[e]);return t}const pk=[{key:"Backspace",keyCode:8,inputType:"deleteContentBackward"},{key:"Enter",keyCode:13,inputType:"insertParagraph"},{key:"Enter",keyCode:13,inputType:"insertLineBreak"},{key:"Delete",keyCode:46,inputType:"deleteContentForward"}],fk="dthko",gk=[16,17,18,20,91,92,224,225];function mk(e){return.7*Math.max(0,e)+8}class vk{constructor(e,t,n,r){this.view=e,this.startEvent=t,this.style=n,this.mustSelect=r,this.scrollSpeed={x:0,y:0},this.scrolling=-1,this.lastEvent=t,this.scrollParents=function(e){let t,n,r=e.ownerDocument;for(let i=e.parentNode;i&&!(i==r.body||t&&n);)if(1==i.nodeType)!n&&i.scrollHeight>i.clientHeight&&(n=i),!t&&i.scrollWidth>i.clientWidth&&(t=i),i=i.assignedSlot||i.parentNode;else{if(11!=i.nodeType)break;i=i.host}return{x:t,y:n}}(e.contentDOM),this.atoms=e.state.facet(Tx).map(t=>t(e));let i=e.contentDOM.ownerDocument;i.addEventListener("mousemove",this.move=this.move.bind(this)),i.addEventListener("mouseup",this.up=this.up.bind(this)),this.extend=t.shiftKey,this.multiple=e.state.facet(Wy.allowMultipleSelections)&&function(e,t){let n=e.state.facet(ix);return n.length?n[0](t):Iw.mac?t.metaKey:t.ctrlKey}(e,t),this.dragging=!(!function(e,t){let{main:n}=e.state.selection;if(n.empty)return!1;let r=Lw(e.root);if(!r||0==r.rangeCount)return!0;let i=r.getRangeAt(0).getClientRects();for(let e=0;e<i.length;e++){let n=i[e];if(n.left<=t.clientX&&n.right>=t.clientX&&n.top<=t.clientY&&n.bottom>=t.clientY)return!0}return!1}(e,t)||1!=Mk(t))&&null}start(e){!1===this.dragging&&this.select(e)}move(e){if(0==e.buttons)return this.destroy();if(this.dragging||null==this.dragging&&function(e,t){return Math.max(Math.abs(e.clientX-t.clientX),Math.abs(e.clientY-t.clientY))}(this.startEvent,e)<10)return;this.select(this.lastEvent=e);let t=0,n=0,r=0,i=0,o=this.view.win.innerWidth,s=this.view.win.innerHeight;this.scrollParents.x&&({left:r,right:o}=this.scrollParents.x.getBoundingClientRect()),this.scrollParents.y&&({top:i,bottom:s}=this.scrollParents.y.getBoundingClientRect());let a=Px(this.view);e.clientX-a.left<=r+6?t=-mk(r-e.clientX):e.clientX+a.right>=o-6&&(t=mk(e.clientX-o)),e.clientY-a.top<=i+6?n=-mk(i-e.clientY):e.clientY+a.bottom>=s-6&&(n=mk(e.clientY-s)),this.setScrollSpeed(t,n)}up(e){null==this.dragging&&this.select(this.lastEvent),this.dragging||e.preventDefault(),this.destroy()}destroy(){this.setScrollSpeed(0,0);let e=this.view.contentDOM.ownerDocument;e.removeEventListener("mousemove",this.move),e.removeEventListener("mouseup",this.up),this.view.inputState.mouseSelection=this.view.inputState.draggedContent=null}setScrollSpeed(e,t){this.scrollSpeed={x:e,y:t},e||t?this.scrolling<0&&(this.scrolling=setInterval(()=>this.scroll(),50)):this.scrolling>-1&&(clearInterval(this.scrolling),this.scrolling=-1)}scroll(){let{x:e,y:t}=this.scrollSpeed;e&&this.scrollParents.x&&(this.scrollParents.x.scrollLeft+=e,e=0),t&&this.scrollParents.y&&(this.scrollParents.y.scrollTop+=t,t=0),(e||t)&&this.view.win.scrollBy(e,t),!1===this.dragging&&this.select(this.lastEvent)}select(e){let{view:t}=this,n=Zx(this.atoms,this.style.get(e,this.extend,this.multiple));!this.mustSelect&&n.eq(t.state.selection,!1===this.dragging)||this.view.dispatch({selection:n,userEvent:"select.pointer"}),this.mustSelect=!1}update(e){e.transactions.some(e=>e.isUserEvent("input.type"))?this.destroy():this.style.update(e)&&setTimeout(()=>this.select(this.lastEvent),20)}}const bk=Object.create(null),Ak=Object.create(null),yk=Iw.ie&&Iw.ie_version<15||Iw.ios&&Iw.webkit_version<604;function wk(e,t,n){for(let r of e.facet(t))n=r(n,e);return n}function Ck(e,t){t=wk(e.state,dx,t);let n,{state:r}=e,i=1,o=r.toText(t),s=o.lines==r.selection.ranges.length,a=null!=Pk&&r.selection.ranges.every(e=>e.empty)&&Pk==o.toString();if(a){let e=-1;n=r.changeByRange(n=>{let a=r.doc.lineAt(n.from);if(a.from==e)return{range:n};e=a.from;let l=r.toText((s?o.line(i++).text:t)+r.lineBreak);return{changes:{from:a.from,insert:l},range:ty.cursor(n.from+l.length)}})}else n=s?r.changeByRange(e=>{let t=o.line(i++);return{changes:{from:e.from,to:e.to,insert:t.text},range:ty.cursor(e.from+t.length)}}):r.replaceSelection(o);e.dispatch(n,{userEvent:"input.paste",scrollIntoView:!0})}function xk(e,t,n,r){if(1==r)return ty.cursor(t,n);if(2==r)return function(e,t,n=1){let r=e.charCategorizer(t),i=e.doc.lineAt(t),o=t-i.from;if(0==i.length)return ty.cursor(t);0==o?n=1:o==i.length&&(n=-1);let s=o,a=o;n<0?s=VA(i.text,o,!1):a=VA(i.text,o);let l=r(i.text.slice(s,a));for(;s>0;){let e=VA(i.text,s,!1);if(r(i.text.slice(e,s))!=l)break;s=e}for(;a<i.length;){let e=VA(i.text,a);if(r(i.text.slice(a,e))!=l)break;a=e}return ty.range(s+i.from,a+i.from)}(e.state,t,n);{let n=DC.find(e.docView,t),r=e.state.doc.lineAt(n?n.posAtEnd:t),i=n?n.posAtStart:r.from,o=n?n.posAtEnd:r.to;return o<e.state.doc.length&&o==r.to&&o++,ty.range(i,o)}}Ak.scroll=e=>{e.inputState.lastScrollTop=e.scrollDOM.scrollTop,e.inputState.lastScrollLeft=e.scrollDOM.scrollLeft},bk.keydown=(e,t)=>(e.inputState.setSelectionOrigin("select"),27==t.keyCode&&0!=e.inputState.tabFocusMode&&(e.inputState.tabFocusMode=Date.now()+2e3),!1),Ak.touchstart=(e,t)=>{e.inputState.lastTouchTime=Date.now(),e.inputState.setSelectionOrigin("select.pointer")},Ak.touchmove=e=>{e.inputState.setSelectionOrigin("select.pointer")},bk.mousedown=(e,t)=>{if(e.observer.flush(),e.inputState.lastTouchTime>Date.now()-2e3)return!1;let n=null;for(let r of e.state.facet(sx))if(n=r(e,t),n)break;if(n||0!=t.button||(n=function(e,t){let n=Ok(e,t),r=Mk(t),i=e.state.selection;return{update(e){e.docChanged&&(n.pos=e.changes.mapPos(n.pos),i=i.map(e.changes))},get(t,o,s){let a,l=Ok(e,t),c=xk(e,l.pos,l.bias,r);if(n.pos!=l.pos&&!o){let t=xk(e,n.pos,n.bias,r),i=Math.min(t.from,c.from),o=Math.max(t.to,c.to);c=i<c.from?ty.range(i,o):ty.range(o,i)}return o?i.replaceRange(i.main.extend(c.from,c.to)):s&&1==r&&i.ranges.length>1&&(a=function(e,t){for(let n=0;n<e.ranges.length;n++){let{from:r,to:i}=e.ranges[n];if(r<=t&&i>=t)return ty.create(e.ranges.slice(0,n).concat(e.ranges.slice(n+1)),e.mainIndex==n?0:e.mainIndex-(e.mainIndex>n?1:0))}return null}(i,l.pos))?a:s?i.addRange(c):ty.create([c])}}}(e,t)),n){let r=!e.hasFocus;e.inputState.startMouseSelection(new vk(e,t,n,r)),r&&e.observer.ignore(()=>{Jw(e.contentDOM);let t=e.root.activeElement;t&&!t.contains(e.contentDOM)&&t.blur()});let i=e.inputState.mouseSelection;if(i)return i.start(t),!1===i.dragging}else e.inputState.setSelectionOrigin("select.pointer");return!1};let kk=(e,t,n)=>t>=n.top&&t<=n.bottom&&e>=n.left&&e<=n.right;function Sk(e,t,n,r){let i=DC.find(e.docView,t);if(!i)return 1;let o=t-i.posAtStart;if(0==o)return 1;if(o==i.length)return-1;let s=i.coordsAt(o,-1);if(s&&kk(n,r,s))return-1;let a=i.coordsAt(o,1);return a&&kk(n,r,a)?1:s&&s.bottom>=r?-1:1}function Ok(e,t){let n=e.posAtCoords({x:t.clientX,y:t.clientY},!1);return{pos:n,bias:Sk(e,n,t.clientX,t.clientY)}}const Bk=Iw.ie&&Iw.ie_version<=11;let _k=null,Tk=0,Ek=0;function Mk(e){if(!Bk)return e.detail;let t=_k,n=Ek;return _k=e,Ek=Date.now(),Tk=!t||n>Date.now()-400&&Math.abs(t.clientX-e.clientX)<2&&Math.abs(t.clientY-e.clientY)<2?(Tk+1)%3:1}function Dk(e,t,n,r){if(!(n=wk(e.state,dx,n)))return;let i=e.posAtCoords({x:t.clientX,y:t.clientY},!1),{draggedContent:o}=e.inputState,s=r&&o&&function(e,t){let n=e.state.facet(ox);return n.length?n[0](t):Iw.mac?!t.altKey:!t.ctrlKey}(e,t)?{from:o.from,to:o.to}:null,a={from:i,insert:n},l=e.state.changes(s?[s,a]:a);e.focus(),e.dispatch({changes:l,selection:{anchor:l.mapPos(i,-1),head:l.mapPos(i,1)},userEvent:s?"move.drop":"input.drop"}),e.inputState.draggedContent=null}bk.dragstart=(e,t)=>{let{selection:{main:n}}=e.state;if(t.target.draggable){let r=e.docView.nearest(t.target);if(r&&r.isWidget){let e=r.posAtStart,t=e+r.length;(e>=n.to||t<=n.from)&&(n=ty.range(e,t))}}let{inputState:r}=e;return r.mouseSelection&&(r.mouseSelection.dragging=!0),r.draggedContent=n,t.dataTransfer&&(t.dataTransfer.setData("Text",wk(e.state,ux,e.state.sliceDoc(n.from,n.to))),t.dataTransfer.effectAllowed="copyMove"),!1},bk.dragend=e=>(e.inputState.draggedContent=null,!1),bk.drop=(e,t)=>{if(!t.dataTransfer)return!1;if(e.state.readOnly)return!0;let n=t.dataTransfer.files;if(n&&n.length){let r=Array(n.length),i=0,o=()=>{++i==n.length&&Dk(e,t,r.filter(e=>null!=e).join(e.state.lineBreak),!1)};for(let e=0;e<n.length;e++){let t=new FileReader;t.onerror=o,t.onload=()=>{/[\x00-\x08\x0e-\x1f]{2}/.test(t.result)||(r[e]=t.result),o()},t.readAsText(n[e])}return!0}{let n=t.dataTransfer.getData("Text");if(n)return Dk(e,t,n,!0),!0}return!1},bk.paste=(e,t)=>{if(e.state.readOnly)return!0;e.observer.flush();let n=yk?null:t.clipboardData;return n?(Ck(e,n.getData("text/plain")||n.getData("text/uri-list")),!0):(function(e){let t=e.dom.parentNode;if(!t)return;let n=t.appendChild(document.createElement("textarea"));n.style.cssText="position: fixed; left: -10000px; top: 10px",n.focus(),setTimeout(()=>{e.focus(),n.remove(),Ck(e,n.value)},50)}(e),!1)};let Pk=null;bk.copy=bk.cut=(e,t)=>{let{text:n,ranges:r,linewise:i}=function(e){let t=[],n=[],r=!1;for(let r of e.selection.ranges)r.empty||(t.push(e.sliceDoc(r.from,r.to)),n.push(r));if(!t.length){let i=-1;for(let{from:r}of e.selection.ranges){let o=e.doc.lineAt(r);o.number>i&&(t.push(o.text),n.push({from:o.from,to:Math.min(e.doc.length,o.to+1)})),i=o.number}r=!0}return{text:wk(e,ux,t.join(e.lineBreak)),ranges:n,linewise:r}}(e.state);if(!n&&!i)return!1;Pk=i?n:null,"cut"!=t.type||e.state.readOnly||e.dispatch({changes:r,scrollIntoView:!0,userEvent:"delete.cut"});let o=yk?null:t.clipboardData;return o?(o.clearData(),o.setData("text/plain",n),!0):(function(e,t){let n=e.dom.parentNode;if(!n)return;let r=n.appendChild(document.createElement("textarea"));r.style.cssText="position: fixed; left: -10000px; top: 10px",r.value=t,r.focus(),r.selectionEnd=t.length,r.selectionStart=0,setTimeout(()=>{r.remove(),e.focus()},50)}(e,n),!1)};const Rk=My.define();function Ik(e,t){let n=[];for(let r of e.facet(hx)){let i=r(e,t);i&&n.push(i)}return n.length?e.update({effects:n,annotations:Rk.of(!0)}):null}function Lk(e){setTimeout(()=>{let t=e.hasFocus;if(t!=e.inputState.notifiedFocused){let n=Ik(e.state,t);n?e.dispatch(n):e.update([])}},10)}Ak.focus=e=>{e.inputState.lastFocusTime=Date.now(),e.scrollDOM.scrollTop||!e.inputState.lastScrollTop&&!e.inputState.lastScrollLeft||(e.scrollDOM.scrollTop=e.inputState.lastScrollTop,e.scrollDOM.scrollLeft=e.inputState.lastScrollLeft),Lk(e)},Ak.blur=e=>{e.observer.clearSelectionRange(),Lk(e)},Ak.compositionstart=Ak.compositionupdate=e=>{e.observer.editContext||(null==e.inputState.compositionFirstChange&&(e.inputState.compositionFirstChange=!0),e.inputState.composing<0&&(e.inputState.composing=0))},Ak.compositionend=e=>{e.observer.editContext||(e.inputState.composing=-1,e.inputState.compositionEndedAt=Date.now(),e.inputState.compositionPendingKey=!0,e.inputState.compositionPendingChange=e.observer.pendingRecords().length>0,e.inputState.compositionFirstChange=null,Iw.chrome&&Iw.android?e.observer.flushSoon():e.inputState.compositionPendingChange?Promise.resolve().then(()=>e.observer.flush()):setTimeout(()=>{e.inputState.composing<0&&e.docView.hasComposition&&e.update([])},50))},Ak.contextmenu=e=>{e.inputState.lastContextMenu=Date.now()},bk.beforeinput=(e,t)=>{var n,r;if("insertReplacementText"==t.inputType&&e.observer.editContext){let r=null===(n=t.dataTransfer)||void 0===n?void 0:n.getData("text/plain"),i=t.getTargetRanges();if(r&&i.length){let t=i[0],n=e.posAtDOM(t.startContainer,t.startOffset),o=e.posAtDOM(t.endContainer,t.endOffset);return lk(e,{from:n,to:o,insert:e.state.toText(r)},null),!0}}let i;if(Iw.chrome&&Iw.android&&(i=pk.find(e=>e.inputType==t.inputType))&&(e.observer.delayAndroidKey(i.key,i.keyCode),"Backspace"==i.key||"Delete"==i.key)){let t=(null===(r=window.visualViewport)||void 0===r?void 0:r.height)||0;setTimeout(()=>{var n;((null===(n=window.visualViewport)||void 0===n?void 0:n.height)||0)>t+10&&e.hasFocus&&(e.contentDOM.blur(),e.focus())},100)}return Iw.ios&&"deleteContentForward"==t.inputType&&e.observer.flushSoon(),Iw.safari&&"insertText"==t.inputType&&e.inputState.composing>=0&&setTimeout(()=>Ak.compositionend(e,t),20),!1};const Nk=new Set;const Fk=["pre-wrap","normal","pre-line","break-spaces"];let Qk=!1;function Vk(){Qk=!1}class zk{constructor(e){this.lineWrapping=e,this.doc=EA.empty,this.heightSamples={},this.lineHeight=14,this.charWidth=7,this.textHeight=14,this.lineLength=30}heightForGap(e,t){let n=this.doc.lineAt(t).number-this.doc.lineAt(e).number+1;return this.lineWrapping&&(n+=Math.max(0,Math.ceil((t-e-n*this.lineLength*.5)/this.lineLength))),this.lineHeight*n}heightForLine(e){if(!this.lineWrapping)return this.lineHeight;return(1+Math.max(0,Math.ceil((e-this.lineLength)/Math.max(1,this.lineLength-5))))*this.lineHeight}setDoc(e){return this.doc=e,this}mustRefreshForWrapping(e){return Fk.indexOf(e)>-1!=this.lineWrapping}mustRefreshForHeights(e){let t=!1;for(let n=0;n<e.length;n++){let r=e[n];r<0?n++:this.heightSamples[Math.floor(10*r)]||(t=!0,this.heightSamples[Math.floor(10*r)]=!0)}return t}refresh(e,t,n,r,i,o){let s=Fk.indexOf(e)>-1,a=Math.round(t)!=Math.round(this.lineHeight)||this.lineWrapping!=s;if(this.lineWrapping=s,this.lineHeight=t,this.charWidth=n,this.textHeight=r,this.lineLength=i,a){this.heightSamples={};for(let e=0;e<o.length;e++){let t=o[e];t<0?e++:this.heightSamples[Math.floor(10*t)]=!0}}return a}}class $k{constructor(e,t){this.from=e,this.heights=t,this.index=0}get more(){return this.index<this.heights.length}}class Hk{constructor(e,t,n,r,i){this.from=e,this.length=t,this.top=n,this.height=r,this._content=i}get type(){return"number"==typeof this._content?SC.Text:Array.isArray(this._content)?this._content:this._content.type}get to(){return this.from+this.length}get bottom(){return this.top+this.height}get widget(){return this._content instanceof TC?this._content.widget:null}get widgetLineBreaks(){return"number"==typeof this._content?this._content:0}join(e){let t=(Array.isArray(this._content)?this._content:[this]).concat(Array.isArray(e._content)?e._content:[e]);return new Hk(this.from,this.length+e.length,this.top,this.height+e.height,t)}}var jk=function(e){return e[e.ByPos=0]="ByPos",e[e.ByHeight=1]="ByHeight",e[e.ByPosNoHeight=2]="ByPosNoHeight",e}(jk||(jk={}));const qk=.001;class Wk{constructor(e,t,n=2){this.length=e,this.height=t,this.flags=n}get outdated(){return(2&this.flags)>0}set outdated(e){this.flags=(e?2:0)|-3&this.flags}setHeight(e){this.height!=e&&(Math.abs(this.height-e)>qk&&(Qk=!0),this.height=e)}replace(e,t,n){return Wk.of(n)}decomposeLeft(e,t){t.push(this)}decomposeRight(e,t){t.push(this)}applyChanges(e,t,n,r){let i=this,o=n.doc;for(let s=r.length-1;s>=0;s--){let{fromA:a,toA:l,fromB:c,toB:h}=r[s],d=i.lineAt(a,jk.ByPosNoHeight,n.setDoc(t),0,0),u=d.to>=l?d:i.lineAt(l,jk.ByPosNoHeight,n,0,0);for(h+=u.to-l,l=u.to;s>0&&d.from<=r[s-1].toA;)a=r[s-1].fromA,c=r[s-1].fromB,s--,a<d.from&&(d=i.lineAt(a,jk.ByPosNoHeight,n,0,0));c+=d.from-a,a=d.from;let p=Zk.build(n.setDoc(o),e,c,h);i=Uk(i,i.replace(a,l,p))}return i.updateHeight(n,0)}static empty(){return new Gk(0,0)}static of(e){if(1==e.length)return e[0];let t=0,n=e.length,r=0,i=0;for(;;)if(t==n)if(r>2*i){let i=e[t-1];i.break?e.splice(--t,1,i.left,null,i.right):e.splice(--t,1,i.left,i.right),n+=1+i.break,r-=i.size}else{if(!(i>2*r))break;{let t=e[n];t.break?e.splice(n,1,t.left,null,t.right):e.splice(n,1,t.left,t.right),n+=2+t.break,i-=t.size}}else if(r<i){let n=e[t++];n&&(r+=n.size)}else{let t=e[--n];t&&(i+=t.size)}let o=0;return null==e[t-1]?(o=1,t--):null==e[t]&&(o=1,n++),new Jk(Wk.of(e.slice(0,t)),o,Wk.of(e.slice(n)))}}function Uk(e,t){return e==t?e:(e.constructor!=t.constructor&&(Qk=!0),t)}Wk.prototype.size=1;class Yk extends Wk{constructor(e,t,n){super(e,t),this.deco=n}blockAt(e,t,n,r){return new Hk(r,this.length,n,this.height,this.deco||0)}lineAt(e,t,n,r,i){return this.blockAt(0,n,r,i)}forEachLine(e,t,n,r,i,o){e<=i+this.length&&t>=i&&o(this.blockAt(0,n,r,i))}updateHeight(e,t=0,n=!1,r){return r&&r.from<=t&&r.more&&this.setHeight(r.heights[r.index++]),this.outdated=!1,this}toString(){return`block(${this.length})`}}class Gk extends Yk{constructor(e,t){super(e,t,null),this.collapsed=0,this.widgetHeight=0,this.breaks=0}blockAt(e,t,n,r){return new Hk(r,this.length,n,this.height,this.breaks)}replace(e,t,n){let r=n[0];return 1==n.length&&(r instanceof Gk||r instanceof Xk&&4&r.flags)&&Math.abs(this.length-r.length)<10?(r instanceof Xk?r=new Gk(r.length,this.height):r.height=this.height,this.outdated||(r.outdated=!1),r):Wk.of(n)}updateHeight(e,t=0,n=!1,r){return r&&r.from<=t&&r.more?this.setHeight(r.heights[r.index++]):(n||this.outdated)&&this.setHeight(Math.max(this.widgetHeight,e.heightForLine(this.length-this.collapsed))+this.breaks*e.lineHeight),this.outdated=!1,this}toString(){return`line(${this.length}${this.collapsed?-this.collapsed:""}${this.widgetHeight?":"+this.widgetHeight:""})`}}class Xk extends Wk{constructor(e){super(e,0)}heightMetrics(e,t){let n,r=e.doc.lineAt(t).number,i=e.doc.lineAt(t+this.length).number,o=i-r+1,s=0;if(e.lineWrapping){let t=Math.min(this.height,e.lineHeight*o);n=t/o,this.length>o+1&&(s=(this.height-t)/(this.length-o-1))}else n=this.height/o;return{firstLine:r,lastLine:i,perLine:n,perChar:s}}blockAt(e,t,n,r){let{firstLine:i,lastLine:o,perLine:s,perChar:a}=this.heightMetrics(t,r);if(t.lineWrapping){let i=r+(e<t.lineHeight?0:Math.round(Math.max(0,Math.min(1,(e-n)/this.height))*this.length)),o=t.doc.lineAt(i),l=s+o.length*a,c=Math.max(n,e-l/2);return new Hk(o.from,o.length,c,l,0)}{let r=Math.max(0,Math.min(o-i,Math.floor((e-n)/s))),{from:a,length:l}=t.doc.line(i+r);return new Hk(a,l,n+s*r,s,0)}}lineAt(e,t,n,r,i){if(t==jk.ByHeight)return this.blockAt(e,n,r,i);if(t==jk.ByPosNoHeight){let{from:t,to:r}=n.doc.lineAt(e);return new Hk(t,r-t,0,0,0)}let{firstLine:o,perLine:s,perChar:a}=this.heightMetrics(n,i),l=n.doc.lineAt(e),c=s+l.length*a,h=l.number-o,d=r+s*h+a*(l.from-i-h);return new Hk(l.from,l.length,Math.max(r,Math.min(d,r+this.height-c)),c,0)}forEachLine(e,t,n,r,i,o){e=Math.max(e,i),t=Math.min(t,i+this.length);let{firstLine:s,perLine:a,perChar:l}=this.heightMetrics(n,i);for(let c=e,h=r;c<=t;){let t=n.doc.lineAt(c);if(c==e){let n=t.number-s;h+=a*n+l*(e-i-n)}let r=a+l*t.length;o(new Hk(t.from,t.length,h,r,0)),h+=r,c=t.to+1}}replace(e,t,n){let r=this.length-t;if(r>0){let e=n[n.length-1];e instanceof Xk?n[n.length-1]=new Xk(e.length+r):n.push(null,new Xk(r-1))}if(e>0){let t=n[0];t instanceof Xk?n[0]=new Xk(e+t.length):n.unshift(new Xk(e-1),null)}return Wk.of(n)}decomposeLeft(e,t){t.push(new Xk(e-1),null)}decomposeRight(e,t){t.push(null,new Xk(this.length-e-1))}updateHeight(e,t=0,n=!1,r){let i=t+this.length;if(r&&r.from<=t+this.length&&r.more){let n=[],o=Math.max(t,r.from),s=-1;for(r.from>t&&n.push(new Xk(r.from-t-1).updateHeight(e,t));o<=i&&r.more;){let t=e.doc.lineAt(o).length;n.length&&n.push(null);let i=r.heights[r.index++];-1==s?s=i:Math.abs(i-s)>=qk&&(s=-2);let a=new Gk(t,i);a.outdated=!1,n.push(a),o+=t+1}o<=i&&n.push(null,new Xk(i-o).updateHeight(e,o));let a=Wk.of(n);return(s<0||Math.abs(a.height-this.height)>=qk||Math.abs(s-this.heightMetrics(e,t).perLine)>=qk)&&(Qk=!0),Uk(this,a)}return(n||this.outdated)&&(this.setHeight(e.heightForGap(t,t+this.length)),this.outdated=!1),this}toString(){return`gap(${this.length})`}}class Jk extends Wk{constructor(e,t,n){super(e.length+t+n.length,e.height+n.height,t|(e.outdated||n.outdated?2:0)),this.left=e,this.right=n,this.size=e.size+n.size}get break(){return 1&this.flags}blockAt(e,t,n,r){let i=n+this.left.height;return e<i?this.left.blockAt(e,t,n,r):this.right.blockAt(e,t,i,r+this.left.length+this.break)}lineAt(e,t,n,r,i){let o=r+this.left.height,s=i+this.left.length+this.break,a=t==jk.ByHeight?e<o:e<s,l=a?this.left.lineAt(e,t,n,r,i):this.right.lineAt(e,t,n,o,s);if(this.break||(a?l.to<s:l.from>s))return l;let c=t==jk.ByPosNoHeight?jk.ByPosNoHeight:jk.ByPos;return a?l.join(this.right.lineAt(s,c,n,o,s)):this.left.lineAt(s,c,n,r,i).join(l)}forEachLine(e,t,n,r,i,o){let s=r+this.left.height,a=i+this.left.length+this.break;if(this.break)e<a&&this.left.forEachLine(e,t,n,r,i,o),t>=a&&this.right.forEachLine(e,t,n,s,a,o);else{let l=this.lineAt(a,jk.ByPos,n,r,i);e<l.from&&this.left.forEachLine(e,l.from-1,n,r,i,o),l.to>=e&&l.from<=t&&o(l),t>l.to&&this.right.forEachLine(l.to+1,t,n,s,a,o)}}replace(e,t,n){let r=this.left.length+this.break;if(t<r)return this.balanced(this.left.replace(e,t,n),this.right);if(e>this.left.length)return this.balanced(this.left,this.right.replace(e-r,t-r,n));let i=[];e>0&&this.decomposeLeft(e,i);let o=i.length;for(let e of n)i.push(e);if(e>0&&Kk(i,o-1),t<this.length){let e=i.length;this.decomposeRight(t,i),Kk(i,e)}return Wk.of(i)}decomposeLeft(e,t){let n=this.left.length;if(e<=n)return this.left.decomposeLeft(e,t);t.push(this.left),this.break&&(n++,e>=n&&t.push(null)),e>n&&this.right.decomposeLeft(e-n,t)}decomposeRight(e,t){let n=this.left.length,r=n+this.break;if(e>=r)return this.right.decomposeRight(e-r,t);e<n&&this.left.decomposeRight(e,t),this.break&&e<r&&t.push(null),t.push(this.right)}balanced(e,t){return e.size>2*t.size||t.size>2*e.size?Wk.of(this.break?[e,null,t]:[e,t]):(this.left=Uk(this.left,e),this.right=Uk(this.right,t),this.setHeight(e.height+t.height),this.outdated=e.outdated||t.outdated,this.size=e.size+t.size,this.length=e.length+this.break+t.length,this)}updateHeight(e,t=0,n=!1,r){let{left:i,right:o}=this,s=t+i.length+this.break,a=null;return r&&r.from<=t+i.length&&r.more?a=i=i.updateHeight(e,t,n,r):i.updateHeight(e,t,n),r&&r.from<=s+o.length&&r.more?a=o=o.updateHeight(e,s,n,r):o.updateHeight(e,s,n),a?this.balanced(i,o):(this.height=this.left.height+this.right.height,this.outdated=!1,this)}toString(){return this.left+(this.break?" ":"-")+this.right}}function Kk(e,t){let n,r;null==e[t]&&(n=e[t-1])instanceof Xk&&(r=e[t+1])instanceof Xk&&e.splice(t-1,3,new Xk(n.length+1+r.length))}class Zk{constructor(e,t){this.pos=e,this.oracle=t,this.nodes=[],this.lineStart=-1,this.lineEnd=-1,this.covering=null,this.writtenTo=e}get isCovered(){return this.covering&&this.nodes[this.nodes.length-1]==this.covering}span(e,t){if(this.lineStart>-1){let e=Math.min(t,this.lineEnd),n=this.nodes[this.nodes.length-1];n instanceof Gk?n.length+=e-this.pos:(e>this.pos||!this.isCovered)&&this.nodes.push(new Gk(e-this.pos,-1)),this.writtenTo=e,t>e&&(this.nodes.push(null),this.writtenTo++,this.lineStart=-1)}this.pos=t}point(e,t,n){if(e<t||n.heightRelevant){let r=n.widget?n.widget.estimatedHeight:0,i=n.widget?n.widget.lineBreaks:0;r<0&&(r=this.oracle.lineHeight);let o=t-e;n.block?this.addBlock(new Yk(o,r,n)):(o||i||r>=5)&&this.addLineDeco(r,i,o)}else t>e&&this.span(e,t);this.lineEnd>-1&&this.lineEnd<this.pos&&(this.lineEnd=this.oracle.doc.lineAt(this.pos).to)}enterLine(){if(this.lineStart>-1)return;let{from:e,to:t}=this.oracle.doc.lineAt(this.pos);this.lineStart=e,this.lineEnd=t,this.writtenTo<e&&((this.writtenTo<e-1||null==this.nodes[this.nodes.length-1])&&this.nodes.push(this.blankContent(this.writtenTo,e-1)),this.nodes.push(null)),this.pos>e&&this.nodes.push(new Gk(this.pos-e,-1)),this.writtenTo=this.pos}blankContent(e,t){let n=new Xk(t-e);return this.oracle.doc.lineAt(e).to==t&&(n.flags|=4),n}ensureLine(){this.enterLine();let e=this.nodes.length?this.nodes[this.nodes.length-1]:null;if(e instanceof Gk)return e;let t=new Gk(0,-1);return this.nodes.push(t),t}addBlock(e){this.enterLine();let t=e.deco;t&&t.startSide>0&&!this.isCovered&&this.ensureLine(),this.nodes.push(e),this.writtenTo=this.pos=this.pos+e.length,t&&t.endSide>0&&(this.covering=e)}addLineDeco(e,t,n){let r=this.ensureLine();r.length+=n,r.collapsed+=n,r.widgetHeight=Math.max(r.widgetHeight,e),r.breaks+=t,this.writtenTo=this.pos=this.pos+n}finish(e){let t=0==this.nodes.length?null:this.nodes[this.nodes.length-1];!(this.lineStart>-1)||t instanceof Gk||this.isCovered?(this.writtenTo<this.pos||null==t)&&this.nodes.push(this.blankContent(this.writtenTo,this.pos)):this.nodes.push(new Gk(0,-1));let n=e;for(let e of this.nodes)e instanceof Gk&&e.updateHeight(this.oracle,n),n+=e?e.length:1;return this.nodes}static build(e,t,n,r){let i=new Zk(n,e);return Ky.spans(t,n,r,i,0),i.finish(n)}}class eS{constructor(){this.changes=[]}compareRange(){}comparePoint(e,t,n,r){(e<t||n&&n.heightRelevant||r&&r.heightRelevant)&&MC(e,t,this.changes,5)}}function tS(e,t){let n=e.getBoundingClientRect(),r=e.ownerDocument,i=r.defaultView||window,o=Math.max(0,n.left),s=Math.min(i.innerWidth,n.right),a=Math.max(0,n.top),l=Math.min(i.innerHeight,n.bottom);for(let t=e.parentNode;t&&t!=r.body;)if(1==t.nodeType){let n=t,r=window.getComputedStyle(n);if((n.scrollHeight>n.clientHeight||n.scrollWidth>n.clientWidth)&&"visible"!=r.overflow){let r=n.getBoundingClientRect();o=Math.max(o,r.left),s=Math.min(s,r.right),a=Math.max(a,r.top),l=Math.min(t==e.parentNode?i.innerHeight:l,r.bottom)}t="absolute"==r.position||"fixed"==r.position?n.offsetParent:n.parentNode}else{if(11!=t.nodeType)break;t=t.host}return{left:o-n.left,right:Math.max(o,s)-n.left,top:a-(n.top+t),bottom:Math.max(a,l)-(n.top+t)}}function nS(e,t){let n=e.getBoundingClientRect();return{left:0,right:n.right-n.left,top:t,bottom:n.bottom-(n.top+t)}}class rS{constructor(e,t,n,r){this.from=e,this.to=t,this.size=n,this.displaySize=r}static same(e,t){if(e.length!=t.length)return!1;for(let n=0;n<e.length;n++){let r=e[n],i=t[n];if(r.from!=i.from||r.to!=i.to||r.size!=i.size)return!1}return!0}draw(e,t){return OC.replace({widget:new iS(this.displaySize*(t?e.scaleY:e.scaleX),t)}).range(this.from,this.to)}}class iS extends kC{constructor(e,t){super(),this.size=e,this.vertical=t}eq(e){return e.size==this.size&&e.vertical==this.vertical}toDOM(){let e=document.createElement("div");return this.vertical?e.style.height=this.size+"px":(e.style.width=this.size+"px",e.style.height="2px",e.style.display="inline-block"),e}get estimatedHeight(){return this.vertical?this.size:-1}}class oS{constructor(e){this.state=e,this.pixelViewport={left:0,right:window.innerWidth,top:0,bottom:0},this.inView=!0,this.paddingTop=0,this.paddingBottom=0,this.contentDOMWidth=0,this.contentDOMHeight=0,this.editorHeight=0,this.editorWidth=0,this.scrollTop=0,this.scrolledToBottom=!1,this.scaleX=1,this.scaleY=1,this.scrollAnchorPos=0,this.scrollAnchorHeight=-1,this.scaler=cS,this.scrollTarget=null,this.printing=!1,this.mustMeasureContent=!0,this.defaultTextDirection=FC.LTR,this.visibleRanges=[],this.mustEnforceCursorAssoc=!1;let t=e.facet(Ox).some(e=>"function"!=typeof e&&"cm-lineWrapping"==e.class);this.heightOracle=new zk(t),this.stateDeco=e.facet(Bx).filter(e=>"function"!=typeof e),this.heightMap=Wk.empty().applyChanges(this.stateDeco,EA.empty,this.heightOracle.setDoc(e.doc),[new Ix(0,0,0,e.doc.length)]);for(let e=0;e<2&&(this.viewport=this.getViewport(0,null),this.updateForViewport());e++);this.updateViewportLines(),this.lineGaps=this.ensureLineGaps([]),this.lineGapDeco=OC.set(this.lineGaps.map(e=>e.draw(this,!1))),this.computeVisibleRanges()}updateForViewport(){let e=[this.viewport],{main:t}=this.state.selection;for(let n=0;n<=1;n++){let r=n?t.head:t.anchor;if(!e.some(({from:e,to:t})=>r>=e&&r<=t)){let{from:t,to:n}=this.lineBlockAt(r);e.push(new sS(t,n))}}return this.viewports=e.sort((e,t)=>e.from-t.from),this.updateScaler()}updateScaler(){let e=this.scaler;return this.scaler=this.heightMap.height<=7e6?cS:new hS(this.heightOracle,this.heightMap,this.viewports),e.eq(this.scaler)?0:2}updateViewportLines(){this.viewportLines=[],this.heightMap.forEachLine(this.viewport.from,this.viewport.to,this.heightOracle.setDoc(this.state.doc),0,0,e=>{this.viewportLines.push(dS(e,this.scaler))})}update(e,t=null){this.state=e.state;let n=this.stateDeco;this.stateDeco=this.state.facet(Bx).filter(e=>"function"!=typeof e);let r=e.changedRanges,i=Ix.extendWithRanges(r,function(e,t,n){let r=new eS;return Ky.compare(e,t,n,r,0),r.changes}(n,this.stateDeco,e?e.changes:UA.empty(this.state.doc.length))),o=this.heightMap.height,s=this.scrolledToBottom?null:this.scrollAnchorAt(this.scrollTop);Vk(),this.heightMap=this.heightMap.applyChanges(this.stateDeco,e.startState.doc,this.heightOracle.setDoc(this.state.doc),i),(this.heightMap.height!=o||Qk)&&(e.flags|=2),s?(this.scrollAnchorPos=e.changes.mapPos(s.from,-1),this.scrollAnchorHeight=s.top):(this.scrollAnchorPos=-1,this.scrollAnchorHeight=o);let a=i.length?this.mapViewport(this.viewport,e.changes):this.viewport;(t&&(t.range.head<a.from||t.range.head>a.to)||!this.viewportIsAppropriate(a))&&(a=this.getViewport(0,t));let l=a.from!=this.viewport.from||a.to!=this.viewport.to;this.viewport=a,e.flags|=this.updateForViewport(),(l||!e.changes.empty||2&e.flags)&&this.updateViewportLines(),(this.lineGaps.length||this.viewport.to-this.viewport.from>4e3)&&this.updateLineGaps(this.ensureLineGaps(this.mapLineGaps(this.lineGaps,e.changes))),e.flags|=this.computeVisibleRanges(e.changes),t&&(this.scrollTarget=t),!this.mustEnforceCursorAssoc&&e.selectionSet&&e.view.lineWrapping&&e.state.selection.main.empty&&e.state.selection.main.assoc&&!e.state.facet(fx)&&(this.mustEnforceCursorAssoc=!0)}measure(e){let t=e.contentDOM,n=window.getComputedStyle(t),r=this.heightOracle,i=n.whiteSpace;this.defaultTextDirection="rtl"==n.direction?FC.RTL:FC.LTR;let o=this.heightOracle.mustRefreshForWrapping(i),s=t.getBoundingClientRect(),a=o||this.mustMeasureContent||this.contentDOMHeight!=s.height;this.contentDOMHeight=s.height,this.mustMeasureContent=!1;let l=0,c=0;if(s.width&&s.height){let{scaleX:e,scaleY:n}=Uw(t,s);(e>.005&&Math.abs(this.scaleX-e)>.005||n>.005&&Math.abs(this.scaleY-n)>.005)&&(this.scaleX=e,this.scaleY=n,l|=16,o=a=!0)}let h=(parseInt(n.paddingTop)||0)*this.scaleY,d=(parseInt(n.paddingBottom)||0)*this.scaleY;this.paddingTop==h&&this.paddingBottom==d||(this.paddingTop=h,this.paddingBottom=d,l|=18),this.editorWidth!=e.scrollDOM.clientWidth&&(r.lineWrapping&&(a=!0),this.editorWidth=e.scrollDOM.clientWidth,l|=16);let u=e.scrollDOM.scrollTop*this.scaleY;this.scrollTop!=u&&(this.scrollAnchorHeight=-1,this.scrollTop=u),this.scrolledToBottom=tC(e.scrollDOM);let p=(this.printing?nS:tS)(t,this.paddingTop),f=p.top-this.pixelViewport.top,g=p.bottom-this.pixelViewport.bottom;this.pixelViewport=p;let m=this.pixelViewport.bottom>this.pixelViewport.top&&this.pixelViewport.right>this.pixelViewport.left;if(m!=this.inView&&(this.inView=m,m&&(a=!0)),!this.inView&&!this.scrollTarget&&!function(e){let t=e.getBoundingClientRect(),n=e.ownerDocument.defaultView||window;return t.left<n.innerWidth&&t.right>0&&t.top<n.innerHeight&&t.bottom>0}(e.dom))return 0;let v=s.width;if(this.contentDOMWidth==v&&this.editorHeight==e.scrollDOM.clientHeight||(this.contentDOMWidth=s.width,this.editorHeight=e.scrollDOM.clientHeight,l|=16),a){let t=e.docView.measureVisibleLineHeights(this.viewport);if(r.mustRefreshForHeights(t)&&(o=!0),o||r.lineWrapping&&Math.abs(v-this.contentDOMWidth)>r.charWidth){let{lineHeight:n,charWidth:s,textHeight:a}=e.docView.measureTextSize();o=n>0&&r.refresh(i,n,s,a,Math.max(5,v/s),t),o&&(e.docView.minWidth=0,l|=16)}f>0&&g>0?c=Math.max(f,g):f<0&&g<0&&(c=Math.min(f,g)),Vk();for(let n of this.viewports){let i=n.from==this.viewport.from?t:e.docView.measureVisibleLineHeights(n);this.heightMap=(o?Wk.empty().applyChanges(this.stateDeco,EA.empty,this.heightOracle,[new Ix(0,0,0,e.state.doc.length)]):this.heightMap).updateHeight(r,0,o,new $k(n.from,i))}Qk&&(l|=2)}let b=!this.viewportIsAppropriate(this.viewport,c)||this.scrollTarget&&(this.scrollTarget.range.head<this.viewport.from||this.scrollTarget.range.head>this.viewport.to);return b&&(2&l&&(l|=this.updateScaler()),this.viewport=this.getViewport(c,this.scrollTarget),l|=this.updateForViewport()),(2&l||b)&&this.updateViewportLines(),(this.lineGaps.length||this.viewport.to-this.viewport.from>4e3)&&this.updateLineGaps(this.ensureLineGaps(o?[]:this.lineGaps,e)),l|=this.computeVisibleRanges(),this.mustEnforceCursorAssoc&&(this.mustEnforceCursorAssoc=!1,e.docView.enforceCursorAssoc()),l}get visibleTop(){return this.scaler.fromDOM(this.pixelViewport.top)}get visibleBottom(){return this.scaler.fromDOM(this.pixelViewport.bottom)}getViewport(e,t){let n=.5-Math.max(-.5,Math.min(.5,e/1e3/2)),r=this.heightMap,i=this.heightOracle,{visibleTop:o,visibleBottom:s}=this,a=new sS(r.lineAt(o-1e3*n,jk.ByHeight,i,0,0).from,r.lineAt(s+1e3*(1-n),jk.ByHeight,i,0,0).to);if(t){let{head:e}=t.range;if(e<a.from||e>a.to){let n,o=Math.min(this.editorHeight,this.pixelViewport.bottom-this.pixelViewport.top),s=r.lineAt(e,jk.ByPos,i,0,0);n="center"==t.y?(s.top+s.bottom)/2-o/2:"start"==t.y||"nearest"==t.y&&e<a.from?s.top:s.bottom-o,a=new sS(r.lineAt(n-500,jk.ByHeight,i,0,0).from,r.lineAt(n+o+500,jk.ByHeight,i,0,0).to)}}return a}mapViewport(e,t){let n=t.mapPos(e.from,-1),r=t.mapPos(e.to,1);return new sS(this.heightMap.lineAt(n,jk.ByPos,this.heightOracle,0,0).from,this.heightMap.lineAt(r,jk.ByPos,this.heightOracle,0,0).to)}viewportIsAppropriate({from:e,to:t},n=0){if(!this.inView)return!0;let{top:r}=this.heightMap.lineAt(e,jk.ByPos,this.heightOracle,0,0),{bottom:i}=this.heightMap.lineAt(t,jk.ByPos,this.heightOracle,0,0),{visibleTop:o,visibleBottom:s}=this;return(0==e||r<=o-Math.max(10,Math.min(-n,250)))&&(t==this.state.doc.length||i>=s+Math.max(10,Math.min(n,250)))&&r>o-2e3&&i<s+2e3}mapLineGaps(e,t){if(!e.length||t.empty)return e;let n=[];for(let r of e)t.touchesRange(r.from,r.to)||n.push(new rS(t.mapPos(r.from),t.mapPos(r.to),r.size,r.displaySize));return n}ensureLineGaps(e,t){let n=this.heightOracle.lineWrapping,r=n?1e4:2e3,i=r>>1,o=r<<1;if(this.defaultTextDirection!=FC.LTR&&!n)return[];let s=[],a=(r,o,l,c)=>{if(o-r<i)return;let h=this.state.selection.main,d=[h.from];h.empty||d.push(h.to);for(let e of d)if(e>r&&e<o)return a(r,e-10,l,c),void a(e+10,o,l,c);let u=function(e,t){for(let n of e)if(t(n))return n;return}(e,e=>e.from>=l.from&&e.to<=l.to&&Math.abs(e.from-r)<i&&Math.abs(e.to-o)<i&&!d.some(t=>e.from<t&&e.to>t));if(!u){if(o<l.to&&t&&n&&t.visibleRanges.some(e=>e.from<=o&&e.to>=o)){let e=t.moveToLineBoundary(ty.cursor(o),!1,!0).head;e>r&&(o=e)}let e=this.gapSize(l,r,o,c);u=new rS(r,o,e,n||e<2e6?e:2e6)}s.push(u)},l=t=>{if(t.length<o||t.type!=SC.Text)return;let i=function(e,t,n){let r=[],i=e,o=0;Ky.spans(n,e,t,{span(){},point(e,t){e>i&&(r.push({from:i,to:e}),o+=e-i),i=t}},20),i<t&&(r.push({from:i,to:t}),o+=t-i);return{total:o,ranges:r}}(t.from,t.to,this.stateDeco);if(i.total<o)return;let s,l,c=this.scrollTarget?this.scrollTarget.range.head:null;if(n){let e,n,o=r/this.heightOracle.lineLength*this.heightOracle.lineHeight;if(null!=c){let r=lS(i,c),s=((this.visibleBottom-this.visibleTop)/2+o)/t.height;e=r-s,n=r+s}else e=(this.visibleTop-t.top-o)/t.height,n=(this.visibleBottom-t.top+o)/t.height;s=aS(i,e),l=aS(i,n)}else{let n=i.total*this.heightOracle.charWidth,o=r*this.heightOracle.charWidth,a=0;if(n>2e6)for(let n of e)n.from>=t.from&&n.from<t.to&&n.size!=n.displaySize&&n.from*this.heightOracle.charWidth+a<this.pixelViewport.left&&(a=n.size-n.displaySize);let h,d,u=this.pixelViewport.left+a,p=this.pixelViewport.right+a;if(null!=c){let e=lS(i,c),t=((p-u)/2+o)/n;h=e-t,d=e+t}else h=(u-o)/n,d=(p+o)/n;s=aS(i,h),l=aS(i,d)}s>t.from&&a(t.from,s,t,i),l<t.to&&a(l,t.to,t,i)};for(let e of this.viewportLines)Array.isArray(e.type)?e.type.forEach(l):l(e);return s}gapSize(e,t,n,r){let i=lS(r,n)-lS(r,t);return this.heightOracle.lineWrapping?e.height*i:r.total*this.heightOracle.charWidth*i}updateLineGaps(e){rS.same(e,this.lineGaps)||(this.lineGaps=e,this.lineGapDeco=OC.set(e.map(e=>e.draw(this,this.heightOracle.lineWrapping))))}computeVisibleRanges(e){let t=this.stateDeco;this.lineGaps.length&&(t=t.concat(this.lineGapDeco));let n=[];Ky.spans(t,this.viewport.from,this.viewport.to,{span(e,t){n.push({from:e,to:t})},point(){}},20);let r=0;if(n.length!=this.visibleRanges.length)r=12;else for(let t=0;t<n.length&&!(8&r);t++){let i=this.visibleRanges[t],o=n[t];i.from==o.from&&i.to==o.to||(r|=4,e&&e.mapPos(i.from,-1)==o.from&&e.mapPos(i.to,1)==o.to||(r|=8))}return this.visibleRanges=n,r}lineBlockAt(e){return e>=this.viewport.from&&e<=this.viewport.to&&this.viewportLines.find(t=>t.from<=e&&t.to>=e)||dS(this.heightMap.lineAt(e,jk.ByPos,this.heightOracle,0,0),this.scaler)}lineBlockAtHeight(e){return e>=this.viewportLines[0].top&&e<=this.viewportLines[this.viewportLines.length-1].bottom&&this.viewportLines.find(t=>t.top<=e&&t.bottom>=e)||dS(this.heightMap.lineAt(this.scaler.fromDOM(e),jk.ByHeight,this.heightOracle,0,0),this.scaler)}scrollAnchorAt(e){let t=this.lineBlockAtHeight(e+8);return t.from>=this.viewport.from||this.viewportLines[0].top-e>200?t:this.viewportLines[0]}elementAtHeight(e){return dS(this.heightMap.blockAt(this.scaler.fromDOM(e),this.heightOracle,0,0),this.scaler)}get docHeight(){return this.scaler.toDOM(this.heightMap.height)}get contentHeight(){return this.docHeight+this.paddingTop+this.paddingBottom}}class sS{constructor(e,t){this.from=e,this.to=t}}function aS({total:e,ranges:t},n){if(n<=0)return t[0].from;if(n>=1)return t[t.length-1].to;let r=Math.floor(e*n);for(let e=0;;e++){let{from:n,to:i}=t[e],o=i-n;if(r<=o)return n+r;r-=o}}function lS(e,t){let n=0;for(let{from:r,to:i}of e.ranges){if(t<=i){n+=t-r;break}n+=i-r}return n/e.total}const cS={toDOM:e=>e,fromDOM:e=>e,scale:1,eq(e){return e==this}};class hS{constructor(e,t,n){let r=0,i=0,o=0;this.viewports=n.map(({from:n,to:i})=>{let o=t.lineAt(n,jk.ByPos,e,0,0).top,s=t.lineAt(i,jk.ByPos,e,0,0).bottom;return r+=s-o,{from:n,to:i,top:o,bottom:s,domTop:0,domBottom:0}}),this.scale=(7e6-r)/(t.height-r);for(let e of this.viewports)e.domTop=o+(e.top-i)*this.scale,o=e.domBottom=e.domTop+(e.bottom-e.top),i=e.bottom}toDOM(e){for(let t=0,n=0,r=0;;t++){let i=t<this.viewports.length?this.viewports[t]:null;if(!i||e<i.top)return r+(e-n)*this.scale;if(e<=i.bottom)return i.domTop+(e-i.top);n=i.bottom,r=i.domBottom}}fromDOM(e){for(let t=0,n=0,r=0;;t++){let i=t<this.viewports.length?this.viewports[t]:null;if(!i||e<i.domTop)return n+(e-r)/this.scale;if(e<=i.domBottom)return i.top+(e-i.domTop);n=i.bottom,r=i.domBottom}}eq(e){return e instanceof hS&&(this.scale==e.scale&&this.viewports.length==e.viewports.length&&this.viewports.every((t,n)=>t.from==e.viewports[n].from&&t.to==e.viewports[n].to))}}function dS(e,t){if(1==t.scale)return e;let n=t.toDOM(e.top),r=t.toDOM(e.bottom);return new Hk(e.from,e.length,n,r-n,Array.isArray(e._content)?e._content.map(e=>dS(e,t)):e._content)}const uS=iy.define({combine:e=>e.join(" ")}),pS=iy.define({combine:e=>e.indexOf(!0)>-1}),fS=gw.newName(),gS=gw.newName(),mS=gw.newName(),vS={"&light":"."+gS,"&dark":"."+mS};function bS(e,t,n){return new gw(t,{finish:t=>/&/.test(t)?t.replace(/&\w*/,t=>{if("&"==t)return e;if(!n||!n[t])throw new RangeError(`Unsupported selector: ${t}`);return n[t]}):e+" "+t})}const AS=bS("."+fS,{"&":{position:"relative !important",boxSizing:"border-box","&.cm-focused":{outline:"1px dotted #212121"},display:"flex !important",flexDirection:"column"},".cm-scroller":{display:"flex !important",alignItems:"flex-start !important",fontFamily:"monospace",lineHeight:1.4,height:"100%",overflowX:"auto",position:"relative",zIndex:0,overflowAnchor:"none"},".cm-content":{margin:0,flexGrow:2,flexShrink:0,display:"block",whiteSpace:"pre",wordWrap:"normal",boxSizing:"border-box",minHeight:"100%",padding:"4px 0",outline:"none","&[contenteditable=true]":{WebkitUserModify:"read-write-plaintext-only"}},".cm-lineWrapping":{whiteSpace_fallback:"pre-wrap",whiteSpace:"break-spaces",wordBreak:"break-word",overflowWrap:"anywhere",flexShrink:1},"&light .cm-content":{caretColor:"black"},"&dark .cm-content":{caretColor:"white"},".cm-line":{display:"block",padding:"0 2px 0 6px"},".cm-layer":{position:"absolute",left:0,top:0,contain:"size style","& > *":{position:"absolute"}},"&light .cm-selectionBackground":{background:"#d9d9d9"},"&dark .cm-selectionBackground":{background:"#222"},"&light.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground":{background:"#d7d4f0"},"&dark.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground":{background:"#233"},".cm-cursorLayer":{pointerEvents:"none"},"&.cm-focused > .cm-scroller > .cm-cursorLayer":{animation:"steps(1) cm-blink 1.2s infinite"},"@keyframes cm-blink":{"0%":{},"50%":{opacity:0},"100%":{}},"@keyframes cm-blink2":{"0%":{},"50%":{opacity:0},"100%":{}},".cm-cursor, .cm-dropCursor":{borderLeft:"1.2px solid black",marginLeft:"-0.6px",pointerEvents:"none"},".cm-cursor":{display:"none"},"&dark .cm-cursor":{borderLeftColor:"#ddd"},".cm-dropCursor":{position:"absolute"},"&.cm-focused > .cm-scroller > .cm-cursorLayer .cm-cursor":{display:"block"},".cm-iso":{unicodeBidi:"isolate"},".cm-announced":{position:"fixed",top:"-10000px"},"@media print":{".cm-announced":{display:"none"}},"&light .cm-activeLine":{backgroundColor:"#cceeff44"},"&dark .cm-activeLine":{backgroundColor:"#99eeff33"},"&light .cm-specialChar":{color:"red"},"&dark .cm-specialChar":{color:"#f78"},".cm-gutters":{flexShrink:0,display:"flex",height:"100%",boxSizing:"border-box",zIndex:200},".cm-gutters-before":{insetInlineStart:0},".cm-gutters-after":{insetInlineEnd:0},"&light .cm-gutters":{backgroundColor:"#f5f5f5",color:"#6c6c6c",border:"0px solid #ddd","&.cm-gutters-before":{borderRightWidth:"1px"},"&.cm-gutters-after":{borderLeftWidth:"1px"}},"&dark .cm-gutters":{backgroundColor:"#333338",color:"#ccc"},".cm-gutter":{display:"flex !important",flexDirection:"column",flexShrink:0,boxSizing:"border-box",minHeight:"100%",overflow:"hidden"},".cm-gutterElement":{boxSizing:"border-box"},".cm-lineNumbers .cm-gutterElement":{padding:"0 3px 0 5px",minWidth:"20px",textAlign:"right",whiteSpace:"nowrap"},"&light .cm-activeLineGutter":{backgroundColor:"#e2f2ff"},"&dark .cm-activeLineGutter":{backgroundColor:"#222227"},".cm-panels":{boxSizing:"border-box",position:"sticky",left:0,right:0,zIndex:300},"&light .cm-panels":{backgroundColor:"#f5f5f5",color:"black"},"&light .cm-panels-top":{borderBottom:"1px solid #ddd"},"&light .cm-panels-bottom":{borderTop:"1px solid #ddd"},"&dark .cm-panels":{backgroundColor:"#333338",color:"white"},".cm-dialog":{padding:"2px 19px 4px 6px",position:"relative","& label":{fontSize:"80%"}},".cm-dialog-close":{position:"absolute",top:"3px",right:"4px",backgroundColor:"inherit",border:"none",font:"inherit",fontSize:"14px",padding:"0"},".cm-tab":{display:"inline-block",overflow:"hidden",verticalAlign:"bottom"},".cm-widgetBuffer":{verticalAlign:"text-top",height:"1em",width:0,display:"inline"},".cm-placeholder":{color:"#888",display:"inline-block",verticalAlign:"top",userSelect:"none"},".cm-highlightSpace":{backgroundImage:"radial-gradient(circle at 50% 55%, #aaa 20%, transparent 5%)",backgroundPosition:"center"},".cm-highlightTab":{backgroundImage:'url(\'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="200" height="20"><path stroke="%23888" stroke-width="1" fill="none" d="M1 10H196L190 5M190 15L196 10M197 4L197 16"/></svg>\')',backgroundSize:"auto 100%",backgroundPosition:"right 90%",backgroundRepeat:"no-repeat"},".cm-trailingSpace":{backgroundColor:"#ff332255"},".cm-button":{verticalAlign:"middle",color:"inherit",fontSize:"70%",padding:".2em 1em",borderRadius:"1px"},"&light .cm-button":{backgroundImage:"linear-gradient(#eff1f5, #d9d9df)",border:"1px solid #888","&:active":{backgroundImage:"linear-gradient(#b4b4b4, #d0d3d6)"}},"&dark .cm-button":{backgroundImage:"linear-gradient(#393939, #111)",border:"1px solid #888","&:active":{backgroundImage:"linear-gradient(#111, #333)"}},".cm-textfield":{verticalAlign:"middle",color:"inherit",fontSize:"70%",border:"1px solid silver",padding:".2em .5em"},"&light .cm-textfield":{backgroundColor:"white"},"&dark .cm-textfield":{border:"1px solid #555",backgroundColor:"inherit"}},vS),yS={childList:!0,characterData:!0,subtree:!0,attributes:!0,characterDataOldValue:!0},wS=Iw.ie&&Iw.ie_version<=11;class CS{constructor(e){this.view=e,this.active=!1,this.editContext=null,this.selectionRange=new Yw,this.selectionChanged=!1,this.delayedFlush=-1,this.resizeTimeout=-1,this.queue=[],this.delayedAndroidKey=null,this.flushingAndroidKey=-1,this.lastChange=0,this.scrollTargets=[],this.intersection=null,this.resizeScroll=null,this.intersecting=!1,this.gapIntersection=null,this.gaps=[],this.printQuery=null,this.parentCheck=-1,this.dom=e.contentDOM,this.observer=new MutationObserver(t=>{for(let e of t)this.queue.push(e);(Iw.ie&&Iw.ie_version<=11||Iw.ios&&e.composing)&&t.some(e=>"childList"==e.type&&e.removedNodes.length||"characterData"==e.type&&e.oldValue.length>e.target.nodeValue.length)?this.flushSoon():this.flush()}),!window.EditContext||!Iw.android||!1===e.constructor.EDIT_CONTEXT||Iw.chrome&&Iw.chrome_version<126||(this.editContext=new SS(e),e.state.facet(yx)&&(e.contentDOM.editContext=this.editContext.editContext)),wS&&(this.onCharData=e=>{this.queue.push({target:e.target,type:"characterData",oldValue:e.prevValue}),this.flushSoon()}),this.onSelectionChange=this.onSelectionChange.bind(this),this.onResize=this.onResize.bind(this),this.onPrint=this.onPrint.bind(this),this.onScroll=this.onScroll.bind(this),window.matchMedia&&(this.printQuery=window.matchMedia("print")),"function"==typeof ResizeObserver&&(this.resizeScroll=new ResizeObserver(()=>{var e;(null===(e=this.view.docView)||void 0===e?void 0:e.lastUpdate)<Date.now()-75&&this.onResize()}),this.resizeScroll.observe(e.scrollDOM)),this.addWindowListeners(this.win=e.win),this.start(),"function"==typeof IntersectionObserver&&(this.intersection=new IntersectionObserver(e=>{this.parentCheck<0&&(this.parentCheck=setTimeout(this.listenForScroll.bind(this),1e3)),e.length>0&&e[e.length-1].intersectionRatio>0!=this.intersecting&&(this.intersecting=!this.intersecting,this.intersecting!=this.view.inView&&this.onScrollChanged(document.createEvent("Event")))},{threshold:[0,.001]}),this.intersection.observe(this.dom),this.gapIntersection=new IntersectionObserver(e=>{e.length>0&&e[e.length-1].intersectionRatio>0&&this.onScrollChanged(document.createEvent("Event"))},{})),this.listenForScroll(),this.readSelectionRange()}onScrollChanged(e){this.view.inputState.runHandlers("scroll",e),this.intersecting&&this.view.measure()}onScroll(e){this.intersecting&&this.flush(!1),this.editContext&&this.view.requestMeasure(this.editContext.measureReq),this.onScrollChanged(e)}onResize(){this.resizeTimeout<0&&(this.resizeTimeout=setTimeout(()=>{this.resizeTimeout=-1,this.view.requestMeasure()},50))}onPrint(e){("change"!=e.type&&e.type||e.matches)&&(this.view.viewState.printing=!0,this.view.measure(),setTimeout(()=>{this.view.viewState.printing=!1,this.view.requestMeasure()},500))}updateGaps(e){if(this.gapIntersection&&(e.length!=this.gaps.length||this.gaps.some((t,n)=>t!=e[n]))){this.gapIntersection.disconnect();for(let t of e)this.gapIntersection.observe(t);this.gaps=e}}onSelectionChange(e){let t=this.selectionChanged;if(!this.readSelectionRange()||this.delayedAndroidKey)return;let{view:n}=this,r=this.selectionRange;if(n.state.facet(yx)?n.root.activeElement!=this.dom:!Fw(this.dom,r))return;let i=r.anchorNode&&n.docView.nearest(r.anchorNode);i&&i.ignoreEvent(e)?t||(this.selectionChanged=!1):(Iw.ie&&Iw.ie_version<=11||Iw.android&&Iw.chrome)&&!n.state.selection.main.empty&&r.focusNode&&Vw(r.focusNode,r.focusOffset,r.anchorNode,r.anchorOffset)?this.flushSoon():this.flush(!1)}readSelectionRange(){let{view:e}=this,t=Lw(e.root);if(!t)return!1;let n=Iw.safari&&11==e.root.nodeType&&e.root.activeElement==this.dom&&function(e,t){if(t.getComposedRanges){let n=t.getComposedRanges(e.root)[0];if(n)return kS(e,n)}let n=null;function r(e){e.preventDefault(),e.stopImmediatePropagation(),n=e.getTargetRanges()[0]}return e.contentDOM.addEventListener("beforeinput",r,!0),e.dom.ownerDocument.execCommand("indent"),e.contentDOM.removeEventListener("beforeinput",r,!0),n?kS(e,n):null}(this.view,t)||t;if(!n||this.selectionRange.eq(n))return!1;let r=Fw(this.dom,n);return r&&!this.selectionChanged&&e.inputState.lastFocusTime>Date.now()-200&&e.inputState.lastTouchTime<Date.now()-300&&function(e,t){let n=t.focusNode,r=t.focusOffset;if(!n||t.anchorNode!=n||t.anchorOffset!=r)return!1;for(r=Math.min(r,jw(n));;)if(r){if(1!=n.nodeType)return!1;let e=n.childNodes[r-1];"false"==e.contentEditable?r--:(n=e,r=jw(n))}else{if(n==e)return!0;r=zw(n),n=n.parentNode}}(this.dom,n)?(this.view.inputState.lastFocusTime=0,e.docView.updateSelection(),!1):(this.selectionRange.setRange(n),r&&(this.selectionChanged=!0),!0)}setSelectionRange(e,t){this.selectionRange.set(e.node,e.offset,t.node,t.offset),this.selectionChanged=!1}clearSelectionRange(){this.selectionRange.set(null,0,null,0)}listenForScroll(){this.parentCheck=-1;let e=0,t=null;for(let n=this.dom;n;)if(1==n.nodeType)!t&&e<this.scrollTargets.length&&this.scrollTargets[e]==n?e++:t||(t=this.scrollTargets.slice(0,e)),t&&t.push(n),n=n.assignedSlot||n.parentNode;else{if(11!=n.nodeType)break;n=n.host}if(e<this.scrollTargets.length&&!t&&(t=this.scrollTargets.slice(0,e)),t){for(let e of this.scrollTargets)e.removeEventListener("scroll",this.onScroll);for(let e of this.scrollTargets=t)e.addEventListener("scroll",this.onScroll)}}ignore(e){if(!this.active)return e();try{return this.stop(),e()}finally{this.start(),this.clear()}}start(){this.active||(this.observer.observe(this.dom,yS),wS&&this.dom.addEventListener("DOMCharacterDataModified",this.onCharData),this.active=!0)}stop(){this.active&&(this.active=!1,this.observer.disconnect(),wS&&this.dom.removeEventListener("DOMCharacterDataModified",this.onCharData))}clear(){this.processRecords(),this.queue.length=0,this.selectionChanged=!1}delayAndroidKey(e,t){var n;if(!this.delayedAndroidKey){let e=()=>{let e=this.delayedAndroidKey;if(e){this.clearDelayedAndroidKey(),this.view.inputState.lastKeyCode=e.keyCode,this.view.inputState.lastKeyTime=Date.now(),!this.flush()&&e.force&&Zw(this.dom,e.key,e.keyCode)}};this.flushingAndroidKey=this.view.win.requestAnimationFrame(e)}this.delayedAndroidKey&&"Enter"!=e||(this.delayedAndroidKey={key:e,keyCode:t,force:this.lastChange<Date.now()-50||!!(null===(n=this.delayedAndroidKey)||void 0===n?void 0:n.force)})}clearDelayedAndroidKey(){this.win.cancelAnimationFrame(this.flushingAndroidKey),this.delayedAndroidKey=null,this.flushingAndroidKey=-1}flushSoon(){this.delayedFlush<0&&(this.delayedFlush=this.view.win.requestAnimationFrame(()=>{this.delayedFlush=-1,this.flush()}))}forceFlush(){this.delayedFlush>=0&&(this.view.win.cancelAnimationFrame(this.delayedFlush),this.delayedFlush=-1),this.flush()}pendingRecords(){for(let e of this.observer.takeRecords())this.queue.push(e);return this.queue}processRecords(){let e=this.pendingRecords();e.length&&(this.queue=[]);let t=-1,n=-1,r=!1;for(let i of e){let e=this.readMutation(i);e&&(e.typeOver&&(r=!0),-1==t?({from:t,to:n}=e):(t=Math.min(e.from,t),n=Math.max(e.to,n)))}return{from:t,to:n,typeOver:r}}readChange(){let{from:e,to:t,typeOver:n}=this.processRecords(),r=this.selectionChanged&&Fw(this.dom,this.selectionRange);if(e<0&&!r)return null;e>-1&&(this.lastChange=Date.now()),this.view.inputState.lastFocusTime=0,this.selectionChanged=!1;let i=new sk(this.view,e,t,n);return this.view.docView.domChanged={newSel:i.newSel?i.newSel.main:null},i}flush(e=!0){if(this.delayedFlush>=0||this.delayedAndroidKey)return!1;e&&this.readSelectionRange();let t=this.readChange();if(!t)return this.view.requestMeasure(),!1;let n=this.view.state,r=ak(this.view,t);return this.view.state==n&&(t.domChanged||t.newSel&&!t.newSel.main.eq(this.view.state.selection.main))&&this.view.update([]),r}readMutation(e){let t=this.view.docView.nearest(e.target);if(!t||t.ignoreMutation(e))return null;if(t.markDirty("attributes"==e.type),"attributes"==e.type&&(t.flags|=4),"childList"==e.type){let n=xS(t,e.previousSibling||e.target.previousSibling,-1),r=xS(t,e.nextSibling||e.target.nextSibling,1);return{from:n?t.posAfter(n):t.posAtStart,to:r?t.posBefore(r):t.posAtEnd,typeOver:!1}}return"characterData"==e.type?{from:t.posAtStart,to:t.posAtEnd,typeOver:e.target.nodeValue==e.oldValue}:null}setWindow(e){e!=this.win&&(this.removeWindowListeners(this.win),this.win=e,this.addWindowListeners(this.win))}addWindowListeners(e){e.addEventListener("resize",this.onResize),this.printQuery?this.printQuery.addEventListener?this.printQuery.addEventListener("change",this.onPrint):this.printQuery.addListener(this.onPrint):e.addEventListener("beforeprint",this.onPrint),e.addEventListener("scroll",this.onScroll),e.document.addEventListener("selectionchange",this.onSelectionChange)}removeWindowListeners(e){e.removeEventListener("scroll",this.onScroll),e.removeEventListener("resize",this.onResize),this.printQuery?this.printQuery.removeEventListener?this.printQuery.removeEventListener("change",this.onPrint):this.printQuery.removeListener(this.onPrint):e.removeEventListener("beforeprint",this.onPrint),e.document.removeEventListener("selectionchange",this.onSelectionChange)}update(e){this.editContext&&(this.editContext.update(e),e.startState.facet(yx)!=e.state.facet(yx)&&(e.view.contentDOM.editContext=e.state.facet(yx)?this.editContext.editContext:null))}destroy(){var e,t,n;this.stop(),null===(e=this.intersection)||void 0===e||e.disconnect(),null===(t=this.gapIntersection)||void 0===t||t.disconnect(),null===(n=this.resizeScroll)||void 0===n||n.disconnect();for(let e of this.scrollTargets)e.removeEventListener("scroll",this.onScroll);this.removeWindowListeners(this.win),clearTimeout(this.parentCheck),clearTimeout(this.resizeTimeout),this.win.cancelAnimationFrame(this.delayedFlush),this.win.cancelAnimationFrame(this.flushingAndroidKey),this.editContext&&(this.view.contentDOM.editContext=null,this.editContext.destroy())}}function xS(e,t,n){for(;t;){let r=sC.get(t);if(r&&r.parent==e)return r;let i=t.parentNode;t=i!=e.dom?i:n>0?t.nextSibling:t.previousSibling}return null}function kS(e,t){let n=t.startContainer,r=t.startOffset,i=t.endContainer,o=t.endOffset,s=e.docView.domAtPos(e.state.selection.main.anchor);return Vw(s.node,s.offset,i,o)&&([n,r,i,o]=[i,o,n,r]),{anchorNode:n,anchorOffset:r,focusNode:i,focusOffset:o}}class SS{constructor(e){this.from=0,this.to=0,this.pendingContextChange=null,this.handlers=Object.create(null),this.composing=null,this.resetRange(e.state);let t=this.editContext=new window.EditContext({text:e.state.doc.sliceString(this.from,this.to),selectionStart:this.toContextPos(Math.max(this.from,Math.min(this.to,e.state.selection.main.anchor))),selectionEnd:this.toContextPos(e.state.selection.main.head)});this.handlers.textupdate=n=>{let r=e.state.selection.main,{anchor:i,head:o}=r,s=this.toEditorPos(n.updateRangeStart),a=this.toEditorPos(n.updateRangeEnd);e.inputState.composing>=0&&!this.composing&&(this.composing={contextBase:n.updateRangeStart,editorBase:s,drifted:!1});let l=a-s>n.text.length;s==this.from&&i<this.from?s=i:a==this.to&&i>this.to&&(a=i);let c=ck(e.state.sliceDoc(s,a),n.text,(l?r.from:r.to)-s,l?"end":null);if(!c){let t=ty.single(this.toEditorPos(n.selectionStart),this.toEditorPos(n.selectionEnd));return void(t.main.eq(r)||e.dispatch({selection:t,userEvent:"select"}))}let h={from:c.from+s,to:c.toA+s,insert:EA.of(n.text.slice(c.from,c.toB).split("\n"))};if((Iw.mac||Iw.android)&&h.from==o-1&&/^\. ?$/.test(n.text)&&"off"==e.contentDOM.getAttribute("autocorrect")&&(h={from:s,to:a,insert:EA.of([n.text.replace("."," ")])}),this.pendingContextChange=h,!e.state.readOnly){let t=this.to-this.from+(h.to-h.from+h.insert.length);lk(e,h,ty.single(this.toEditorPos(n.selectionStart,t),this.toEditorPos(n.selectionEnd,t)))}this.pendingContextChange&&(this.revertPending(e.state),this.setSelection(e.state)),h.from<h.to&&!h.insert.length&&e.inputState.composing>=0&&!/[\\p{Alphabetic}\\p{Number}_]/.test(t.text.slice(Math.max(0,n.updateRangeStart-1),Math.min(t.text.length,n.updateRangeStart+1)))&&this.handlers.compositionend(n)},this.handlers.characterboundsupdate=n=>{let r=[],i=null;for(let t=this.toEditorPos(n.rangeStart),o=this.toEditorPos(n.rangeEnd);t<o;t++){let n=e.coordsForChar(t);i=n&&new DOMRect(n.left,n.top,n.right-n.left,n.bottom-n.top)||i||new DOMRect,r.push(i)}t.updateCharacterBounds(n.rangeStart,r)},this.handlers.textformatupdate=t=>{let n=[];for(let e of t.getTextFormats()){let t=e.underlineStyle,r=e.underlineThickness;if(!/none/i.test(t)&&!/none/i.test(r)){let i=this.toEditorPos(e.rangeStart),o=this.toEditorPos(e.rangeEnd);if(i<o){let e=`text-decoration: underline ${/^[a-z]/.test(t)?t+" ":"Dashed"==t?"dashed ":"Squiggle"==t?"wavy ":""}${/thin/i.test(r)?1:2}px`;n.push(OC.mark({attributes:{style:e}}).range(i,o))}}}e.dispatch({effects:bx.of(OC.set(n))})},this.handlers.compositionstart=()=>{e.inputState.composing<0&&(e.inputState.composing=0,e.inputState.compositionFirstChange=!0)},this.handlers.compositionend=()=>{if(e.inputState.composing=-1,e.inputState.compositionFirstChange=null,this.composing){let{drifted:t}=this.composing;this.composing=null,t&&this.reset(e.state)}};for(let e in this.handlers)t.addEventListener(e,this.handlers[e]);this.measureReq={read:e=>{this.editContext.updateControlBounds(e.contentDOM.getBoundingClientRect());let t=Lw(e.root);t&&t.rangeCount&&this.editContext.updateSelectionBounds(t.getRangeAt(0).getBoundingClientRect())}}}applyEdits(e){let t=0,n=!1,r=this.pendingContextChange;return e.changes.iterChanges((i,o,s,a,l)=>{if(n)return;let c=l.length-(o-i);if(r&&o>=r.to){if(r.from==i&&r.to==o&&r.insert.eq(l))return r=this.pendingContextChange=null,t+=c,void(this.to+=c);r=null,this.revertPending(e.state)}if(i+=t,(o+=t)<=this.from)this.from+=c,this.to+=c;else if(i<this.to){if(i<this.from||o>this.to||this.to-this.from+l.length>3e4)return void(n=!0);this.editContext.updateText(this.toContextPos(i),this.toContextPos(o),l.toString()),this.to+=c}t+=c}),r&&!n&&this.revertPending(e.state),!n}update(e){let t=this.pendingContextChange,n=e.startState.selection.main;this.composing&&(this.composing.drifted||!e.changes.touchesRange(n.from,n.to)&&e.transactions.some(e=>!e.isUserEvent("input.type")&&e.changes.touchesRange(this.from,this.to)))?(this.composing.drifted=!0,this.composing.editorBase=e.changes.mapPos(this.composing.editorBase)):this.applyEdits(e)&&this.rangeIsValid(e.state)?(e.docChanged||e.selectionSet||t)&&this.setSelection(e.state):(this.pendingContextChange=null,this.reset(e.state)),(e.geometryChanged||e.docChanged||e.selectionSet)&&e.view.requestMeasure(this.measureReq)}resetRange(e){let{head:t}=e.selection.main;this.from=Math.max(0,t-1e4),this.to=Math.min(e.doc.length,t+1e4)}reset(e){this.resetRange(e),this.editContext.updateText(0,this.editContext.text.length,e.doc.sliceString(this.from,this.to)),this.setSelection(e)}revertPending(e){let t=this.pendingContextChange;this.pendingContextChange=null,this.editContext.updateText(this.toContextPos(t.from),this.toContextPos(t.from+t.insert.length),e.doc.sliceString(t.from,t.to))}setSelection(e){let{main:t}=e.selection,n=this.toContextPos(Math.max(this.from,Math.min(this.to,t.anchor))),r=this.toContextPos(t.head);this.editContext.selectionStart==n&&this.editContext.selectionEnd==r||this.editContext.updateSelection(n,r)}rangeIsValid(e){let{head:t}=e.selection.main;return!(this.from>0&&t-this.from<500||this.to<e.doc.length&&this.to-t<500||this.to-this.from>3e4)}toEditorPos(e,t=this.to-this.from){e=Math.min(e,t);let n=this.composing;return n&&n.drifted?n.editorBase+(e-n.contextBase):e+this.from}toContextPos(e){let t=this.composing;return t&&t.drifted?t.contextBase+(e-t.editorBase):e-this.from}destroy(){for(let e in this.handlers)this.editContext.removeEventListener(e,this.handlers[e])}}class OS{get state(){return this.viewState.state}get viewport(){return this.viewState.viewport}get visibleRanges(){return this.viewState.visibleRanges}get inView(){return this.viewState.inView}get composing(){return!!this.inputState&&this.inputState.composing>0}get compositionStarted(){return!!this.inputState&&this.inputState.composing>=0}get root(){return this._root}get win(){return this.dom.ownerDocument.defaultView||window}constructor(e={}){var t;this.plugins=[],this.pluginMap=new Map,this.editorAttrs={},this.contentAttrs={},this.bidiCache=[],this.destroyed=!1,this.updateState=2,this.measureScheduled=-1,this.measureRequests=[],this.contentDOM=document.createElement("div"),this.scrollDOM=document.createElement("div"),this.scrollDOM.tabIndex=-1,this.scrollDOM.className="cm-scroller",this.scrollDOM.appendChild(this.contentDOM),this.announceDOM=document.createElement("div"),this.announceDOM.className="cm-announced",this.announceDOM.setAttribute("aria-live","polite"),this.dom=document.createElement("div"),this.dom.appendChild(this.announceDOM),this.dom.appendChild(this.scrollDOM),e.parent&&e.parent.appendChild(this.dom);let{dispatch:n}=e;this.dispatchTransactions=e.dispatchTransactions||n&&(e=>e.forEach(e=>n(e,this)))||(e=>this.update(e)),this.dispatch=this.dispatch.bind(this),this._root=e.root||function(e){for(;e;){if(e&&(9==e.nodeType||11==e.nodeType&&e.host))return e;e=e.assignedSlot||e.parentNode}return null}(e.parent)||document,this.viewState=new oS(e.state||Wy.create(e)),e.scrollTo&&e.scrollTo.is(vx)&&(this.viewState.scrollTarget=e.scrollTo.value.clip(this.viewState.state)),this.plugins=this.state.facet(Cx).map(e=>new kx(e));for(let e of this.plugins)e.update(this);this.observer=new CS(this),this.inputState=new hk(this),this.inputState.ensureHandlers(this.plugins),this.docView=new Nx(this),this.mountStyles(),this.updateAttrs(),this.updateState=0,this.requestMeasure(),(null===(t=document.fonts)||void 0===t?void 0:t.ready)&&document.fonts.ready.then(()=>this.requestMeasure())}dispatch(...e){let t=1==e.length&&e[0]instanceof Iy?e:1==e.length&&Array.isArray(e[0])?e[0]:[this.state.update(...e)];this.dispatchTransactions(t,this)}update(e){if(0!=this.updateState)throw new Error("Calls to EditorView.update are not allowed while an update is in progress");let t,n=!1,r=!1,i=this.state;for(let t of e){if(t.startState!=i)throw new RangeError("Trying to update state with a transaction that doesn't start from the previous state.");i=t.state}if(this.destroyed)return void(this.viewState.state=i);let o=this.hasFocus,s=0,a=null;e.some(e=>e.annotation(Rk))?(this.inputState.notifiedFocused=o,s=1):o!=this.inputState.notifiedFocused&&(this.inputState.notifiedFocused=o,a=Ik(i,o),a||(s=1));let l=this.observer.delayedAndroidKey,c=null;if(l?(this.observer.clearDelayedAndroidKey(),c=this.observer.readChange(),(c&&!this.state.doc.eq(i.doc)||!this.state.selection.eq(i.selection))&&(c=null)):this.observer.clear(),i.facet(Wy.phrases)!=this.state.facet(Wy.phrases))return this.setState(i);t=Lx.create(this,i,e),t.flags|=s;let h=this.viewState.scrollTarget;try{this.updateState=2;for(let t of e){if(h&&(h=h.map(t.changes)),t.scrollIntoView){let{main:e}=t.state.selection;h=new mx(e.empty?e:ty.cursor(e.head,e.head>e.anchor?-1:1))}for(let e of t.effects)e.is(vx)&&(h=e.value.clip(this.state))}this.viewState.update(t,h),this.bidiCache=TS.update(this.bidiCache,t.changes),t.empty||(this.updatePlugins(t),this.inputState.update(t)),n=this.docView.update(t),this.state.facet(Rx)!=this.styleModules&&this.mountStyles(),r=this.updateAttrs(),this.showAnnouncements(e),this.docView.updateSelection(n,e.some(e=>e.isUserEvent("select.pointer")))}finally{this.updateState=0}if(t.startState.facet(uS)!=t.state.facet(uS)&&(this.viewState.mustMeasureContent=!0),(n||r||h||this.viewState.mustEnforceCursorAssoc||this.viewState.mustMeasureContent)&&this.requestMeasure(),n&&this.docViewUpdate(),!t.empty)for(let e of this.state.facet(lx))try{e(t)}catch(e){Ax(this.state,e,"update listener")}(a||c)&&Promise.resolve().then(()=>{a&&this.state==a.startState&&this.dispatch(a),c&&!ak(this,c)&&l.force&&Zw(this.contentDOM,l.key,l.keyCode)})}setState(e){if(0!=this.updateState)throw new Error("Calls to EditorView.setState are not allowed while an update is in progress");if(this.destroyed)return void(this.viewState.state=e);this.updateState=2;let t=this.hasFocus;try{for(let e of this.plugins)e.destroy(this);this.viewState=new oS(e),this.plugins=e.facet(Cx).map(e=>new kx(e)),this.pluginMap.clear();for(let e of this.plugins)e.update(this);this.docView.destroy(),this.docView=new Nx(this),this.inputState.ensureHandlers(this.plugins),this.mountStyles(),this.updateAttrs(),this.bidiCache=[]}finally{this.updateState=0}t&&this.focus(),this.requestMeasure()}updatePlugins(e){let t=e.startState.facet(Cx),n=e.state.facet(Cx);if(t!=n){let r=[];for(let i of n){let n=t.indexOf(i);if(n<0)r.push(new kx(i));else{let t=this.plugins[n];t.mustUpdate=e,r.push(t)}}for(let t of this.plugins)t.mustUpdate!=e&&t.destroy(this);this.plugins=r,this.pluginMap.clear()}else for(let t of this.plugins)t.mustUpdate=e;for(let e=0;e<this.plugins.length;e++)this.plugins[e].update(this);t!=n&&this.inputState.ensureHandlers(this.plugins)}docViewUpdate(){for(let e of this.plugins){let t=e.value;if(t&&t.docViewUpdate)try{t.docViewUpdate(this)}catch(e){Ax(this.state,e,"doc view update listener")}}}measure(e=!0){if(this.destroyed)return;if(this.measureScheduled>-1&&this.win.cancelAnimationFrame(this.measureScheduled),this.observer.delayedAndroidKey)return this.measureScheduled=-1,void this.requestMeasure();this.measureScheduled=0,e&&this.observer.forceFlush();let t=null,n=this.scrollDOM,r=n.scrollTop*this.scaleY,{scrollAnchorPos:i,scrollAnchorHeight:o}=this.viewState;Math.abs(r-this.viewState.scrollTop)>1&&(o=-1),this.viewState.scrollAnchorHeight=-1;try{for(let e=0;;e++){if(o<0)if(tC(n))i=-1,o=this.viewState.heightMap.height;else{let e=this.viewState.scrollAnchorAt(r);i=e.from,o=e.top}this.updateState=1;let s=this.viewState.measure(this);if(!s&&!this.measureRequests.length&&null==this.viewState.scrollTarget)break;if(e>5){console.warn(this.measureRequests.length?"Measure loop restarted more than 5 times":"Viewport failed to stabilize");break}let a=[];4&s||([this.measureRequests,a]=[a,this.measureRequests]);let l=a.map(e=>{try{return e.read(this)}catch(e){return Ax(this.state,e),_S}}),c=Lx.create(this,this.state,[]),h=!1;c.flags|=s,t?t.flags|=s:t=c,this.updateState=2,c.empty||(this.updatePlugins(c),this.inputState.update(c),this.updateAttrs(),h=this.docView.update(c),h&&this.docViewUpdate());for(let e=0;e<a.length;e++)if(l[e]!=_S)try{let t=a[e];t.write&&t.write(l[e],this)}catch(e){Ax(this.state,e)}if(h&&this.docView.updateSelection(!0),!c.viewportChanged&&0==this.measureRequests.length){if(this.viewState.editorHeight){if(this.viewState.scrollTarget){this.docView.scrollIntoView(this.viewState.scrollTarget),this.viewState.scrollTarget=null,o=-1;continue}{let e=(i<0?this.viewState.heightMap.height:this.viewState.lineBlockAt(i).top)-o;if(e>1||e<-1){r+=e,n.scrollTop=r/this.scaleY,o=-1;continue}}}break}}}finally{this.updateState=0,this.measureScheduled=-1}if(t&&!t.empty)for(let e of this.state.facet(lx))e(t)}get themeClasses(){return fS+" "+(this.state.facet(pS)?mS:gS)+" "+this.state.facet(uS)}updateAttrs(){let e=ES(this,Sx,{class:"cm-editor"+(this.hasFocus?" cm-focused ":" ")+this.themeClasses}),t={spellcheck:"false",autocorrect:"off",autocapitalize:"off",writingsuggestions:"false",translate:"no",contenteditable:this.state.facet(yx)?"true":"false",class:"cm-content",style:`${Iw.tabSize}: ${this.state.tabSize}`,role:"textbox","aria-multiline":"true"};this.state.readOnly&&(t["aria-readonly"]="true"),ES(this,Ox,t);let n=this.observer.ignore(()=>{let n=CC(this.contentDOM,this.contentAttrs,t),r=CC(this.dom,this.editorAttrs,e);return n||r});return this.editorAttrs=e,this.contentAttrs=t,n}showAnnouncements(e){let t=!0;for(let n of e)for(let e of n.effects)if(e.is(OS.announce)){t&&(this.announceDOM.textContent=""),t=!1,this.announceDOM.appendChild(document.createElement("div")).textContent=e.value}}mountStyles(){this.styleModules=this.state.facet(Rx);let e=this.state.facet(OS.cspNonce);gw.mount(this.root,this.styleModules.concat(AS).reverse(),e?{nonce:e}:void 0)}readMeasured(){if(2==this.updateState)throw new Error("Reading the editor layout isn't allowed during an update");0==this.updateState&&this.measureScheduled>-1&&this.measure(!1)}requestMeasure(e){if(this.measureScheduled<0&&(this.measureScheduled=this.win.requestAnimationFrame(()=>this.measure())),e){if(this.measureRequests.indexOf(e)>-1)return;if(null!=e.key)for(let t=0;t<this.measureRequests.length;t++)if(this.measureRequests[t].key===e.key)return void(this.measureRequests[t]=e);this.measureRequests.push(e)}}plugin(e){let t=this.pluginMap.get(e);return(void 0===t||t&&t.plugin!=e)&&this.pluginMap.set(e,t=this.plugins.find(t=>t.plugin==e)||null),t&&t.update(this).value}get documentTop(){return this.contentDOM.getBoundingClientRect().top+this.viewState.paddingTop}get documentPadding(){return{top:this.viewState.paddingTop,bottom:this.viewState.paddingBottom}}get scaleX(){return this.viewState.scaleX}get scaleY(){return this.viewState.scaleY}elementAtHeight(e){return this.readMeasured(),this.viewState.elementAtHeight(e)}lineBlockAtHeight(e){return this.readMeasured(),this.viewState.lineBlockAtHeight(e)}get viewportLineBlocks(){return this.viewState.viewportLines}lineBlockAt(e){return this.viewState.lineBlockAt(e)}get contentHeight(){return this.viewState.contentHeight}moveByChar(e,t,n){return ek(this,e,Jx(this,e,t,n))}moveByGroup(e,t){return ek(this,e,Jx(this,e,t,t=>function(e,t,n){let r=e.state.charCategorizer(t),i=r(n);return e=>{let t=r(e);return i==$y.Space&&(i=t),i==t}}(this,e.head,t)))}visualLineSide(e,t){let n=this.bidiSpans(e),r=this.textDirectionAt(e.from),i=n[t?n.length-1:0];return ty.cursor(i.side(t,r)+e.from,i.forward(!t,r)?1:-1)}moveToLineBoundary(e,t,n=!0){return function(e,t,n,r){let i=Xx(e,t.head,t.assoc||-1),o=r&&i.type==SC.Text&&(e.lineWrapping||i.widgetLineBreaks)?e.coordsAtPos(t.assoc<0&&t.head>i.from?t.head-1:t.head):null;if(o){let t=e.dom.getBoundingClientRect(),r=e.textDirectionAt(i.from),s=e.posAtCoords({x:n==(r==FC.LTR)?t.right-1:t.left+1,y:(o.top+o.bottom)/2});if(null!=s)return ty.cursor(s,n?-1:1)}return ty.cursor(n?i.to:i.from,n?-1:1)}(this,e,t,n)}moveVertically(e,t,n){return ek(this,e,function(e,t,n,r){let i=t.head,o=n?1:-1;if(i==(n?e.state.doc.length:0))return ty.cursor(i,t.assoc);let s,a=t.goalColumn,l=e.contentDOM.getBoundingClientRect(),c=e.coordsAtPos(i,t.assoc||-1),h=e.documentTop;if(c)null==a&&(a=c.left-l.left),s=o<0?c.top:c.bottom;else{let t=e.viewState.lineBlockAt(i);null==a&&(a=Math.min(l.right-l.left,e.defaultCharacterWidth*(i-t.from))),s=(o<0?t.top:t.bottom)+h}let d=l.left+a,u=null!=r?r:e.viewState.heightOracle.textHeight>>1;for(let t=0;;t+=10){let n=s+(u+t)*o,r=Ux(e,{x:d,y:n},!1,o);if(n<l.top||n>l.bottom||(o<0?r<i:r>i)){let t=e.docView.coordsForChar(r),i=!t||n<t.top?-1:1;return ty.cursor(r,i,void 0,a)}}}(this,e,t,n))}domAtPos(e){return this.docView.domAtPos(e)}posAtDOM(e,t=0){return this.docView.posFromDOM(e,t)}posAtCoords(e,t=!0){return this.readMeasured(),Ux(this,e,t)}coordsAtPos(e,t=1){this.readMeasured();let n=this.docView.coordsAt(e,t);if(!n||n.left==n.right)return n;let r=this.state.doc.lineAt(e),i=this.bidiSpans(r);return qw(n,i[YC.find(i,e-r.from,-1,t)].dir==FC.LTR==t>0)}coordsForChar(e){return this.readMeasured(),this.docView.coordsForChar(e)}get defaultCharacterWidth(){return this.viewState.heightOracle.charWidth}get defaultLineHeight(){return this.viewState.heightOracle.lineHeight}get textDirection(){return this.viewState.defaultTextDirection}textDirectionAt(e){return!this.state.facet(px)||e<this.viewport.from||e>this.viewport.to?this.textDirection:(this.readMeasured(),this.docView.textDirectionAt(e))}get lineWrapping(){return this.viewState.heightOracle.lineWrapping}bidiSpans(e){if(e.length>BS)return ex(e.length);let t,n=this.textDirectionAt(e.from);for(let r of this.bidiCache)if(r.from==e.from&&r.dir==n&&(r.fresh||GC(r.isolates,t=Mx(this,e))))return r.order;t||(t=Mx(this,e));let r=ZC(e.text,n,t);return this.bidiCache.push(new TS(e.from,e.to,n,t,!0,r)),r}get hasFocus(){var e;return(this.dom.ownerDocument.hasFocus()||Iw.safari&&(null===(e=this.inputState)||void 0===e?void 0:e.lastContextMenu)>Date.now()-3e4)&&this.root.activeElement==this.contentDOM}focus(){this.observer.ignore(()=>{Jw(this.contentDOM),this.docView.updateSelection()})}setRoot(e){this._root!=e&&(this._root=e,this.observer.setWindow((9==e.nodeType?e:e.ownerDocument).defaultView||window),this.mountStyles())}destroy(){this.root.activeElement==this.contentDOM&&this.contentDOM.blur();for(let e of this.plugins)e.destroy(this);this.plugins=[],this.inputState.destroy(),this.docView.destroy(),this.dom.remove(),this.observer.destroy(),this.measureScheduled>-1&&this.win.cancelAnimationFrame(this.measureScheduled),this.destroyed=!0}static scrollIntoView(e,t={}){return vx.of(new mx("number"==typeof e?ty.cursor(e):e,t.y,t.x,t.yMargin,t.xMargin))}scrollSnapshot(){let{scrollTop:e,scrollLeft:t}=this.scrollDOM,n=this.viewState.scrollAnchorAt(e);return vx.of(new mx(ty.cursor(n.from),"start","start",n.top-e,t,!0))}setTabFocusMode(e){null==e?this.inputState.tabFocusMode=this.inputState.tabFocusMode<0?0:-1:"boolean"==typeof e?this.inputState.tabFocusMode=e?0:-1:0!=this.inputState.tabFocusMode&&(this.inputState.tabFocusMode=Date.now()+e)}static domEventHandlers(e){return xx.define(()=>({}),{eventHandlers:e})}static domEventObservers(e){return xx.define(()=>({}),{eventObservers:e})}static theme(e,t){let n=gw.newName(),r=[uS.of(n),Rx.of(bS(`.${n}`,e))];return t&&t.dark&&r.push(pS.of(!0)),r}static baseTheme(e){return vy.lowest(Rx.of(bS("."+fS,e,vS)))}static findFromDOM(e){var t;let n=e.querySelector(".cm-content"),r=n&&sC.get(n)||sC.get(e);return(null===(t=null==r?void 0:r.rootView)||void 0===t?void 0:t.view)||null}}OS.styleModule=Rx,OS.inputHandler=cx,OS.clipboardInputFilter=dx,OS.clipboardOutputFilter=ux,OS.scrollHandler=gx,OS.focusChangeEffect=hx,OS.perLineTextDirection=px,OS.exceptionSink=ax,OS.updateListener=lx,OS.editable=yx,OS.mouseSelectionStyle=sx,OS.dragMovesSelection=ox,OS.clickAddsSelectionRange=ix,OS.decorations=Bx,OS.outerDecorations=_x,OS.atomicRanges=Tx,OS.bidiIsolatedRanges=Ex,OS.scrollMargins=Dx,OS.darkTheme=pS,OS.cspNonce=iy.define({combine:e=>e.length?e[0]:""}),OS.contentAttributes=Ox,OS.editorAttributes=Sx,OS.lineWrapping=OS.contentAttributes.of({class:"cm-lineWrapping"}),OS.announce=Ry.define();const BS=4096,_S={};class TS{constructor(e,t,n,r,i,o){this.from=e,this.to=t,this.dir=n,this.isolates=r,this.fresh=i,this.order=o}static update(e,t){if(t.empty&&!e.some(e=>e.fresh))return e;let n=[],r=e.length?e[e.length-1].dir:FC.LTR;for(let i=Math.max(0,e.length-10);i<e.length;i++){let o=e[i];o.dir!=r||t.touchesRange(o.from,o.to)||n.push(new TS(t.mapPos(o.from,1),t.mapPos(o.to,-1),o.dir,o.isolates,!1,o.order))}return n}}function ES(e,t,n){for(let r=e.state.facet(t),i=r.length-1;i>=0;i--){let t=r[i],o="function"==typeof t?t(e):t;o&&AC(o,n)}return n}const MS=Iw.mac?"mac":Iw.windows?"win":Iw.linux?"linux":"key";function DS(e,t,n){return t.altKey&&(e="Alt-"+e),t.ctrlKey&&(e="Ctrl-"+e),t.metaKey&&(e="Meta-"+e),!1!==n&&t.shiftKey&&(e="Shift-"+e),e}const PS=vy.default(OS.domEventHandlers({keydown:(e,t)=>VS(LS(t.state),e,t,"editor")})),RS=iy.define({enables:PS}),IS=new WeakMap;function LS(e){let t=e.facet(RS),n=IS.get(t);return n||IS.set(t,n=function(e,t=MS){let n=Object.create(null),r=Object.create(null),i=(e,t)=>{let n=r[e];if(null==n)r[e]=t;else if(n!=t)throw new Error("Key binding "+e+" is used both as a regular binding and as a multi-stroke prefix")},o=(e,r,o,s,a)=>{var l,c;let h=n[e]||(n[e]=Object.create(null)),d=r.split(/ (?!$)/).map(e=>function(e,t){const n=e.split(/-(?!$)/);let r,i,o,s,a=n[n.length-1];"Space"==a&&(a=" ");for(let e=0;e<n.length-1;++e){const a=n[e];if(/^(cmd|meta|m)$/i.test(a))s=!0;else if(/^a(lt)?$/i.test(a))r=!0;else if(/^(c|ctrl|control)$/i.test(a))i=!0;else if(/^s(hift)?$/i.test(a))o=!0;else{if(!/^mod$/i.test(a))throw new Error("Unrecognized modifier name: "+a);"mac"==t?s=!0:i=!0}}return r&&(a="Alt-"+a),i&&(a="Ctrl-"+a),s&&(a="Meta-"+a),o&&(a="Shift-"+a),a}(e,t));for(let t=1;t<d.length;t++){let n=d.slice(0,t).join(" ");i(n,!0),h[n]||(h[n]={preventDefault:!0,stopPropagation:!1,run:[t=>{let r=NS={view:t,prefix:n,scope:e};return setTimeout(()=>{NS==r&&(NS=null)},FS),!0}]})}let u=d.join(" ");i(u,!1);let p=h[u]||(h[u]={preventDefault:!1,stopPropagation:!1,run:(null===(c=null===(l=h._any)||void 0===l?void 0:l.run)||void 0===c?void 0:c.slice())||[]});o&&p.run.push(o),s&&(p.preventDefault=!0),a&&(p.stopPropagation=!0)};for(let r of e){let e=r.scope?r.scope.split(" "):["editor"];if(r.any)for(let t of e){let e=n[t]||(n[t]=Object.create(null));e._any||(e._any={preventDefault:!1,stopPropagation:!1,run:[]});let{any:i}=r;for(let t in e)e[t].run.push(e=>i(e,QS))}let i=r[t]||r.key;if(i)for(let t of e)o(t,i,r.run,r.preventDefault,r.stopPropagation),r.shift&&o(t,"Shift-"+i,r.shift,r.preventDefault,r.stopPropagation)}return n}(t.reduce((e,t)=>e.concat(t),[]))),n}let NS=null;const FS=4e3;let QS=null;function VS(e,t,n,r){QS=t;let i=function(e){var t=!(yw&&e.metaKey&&e.shiftKey&&!e.ctrlKey&&!e.altKey||ww&&e.shiftKey&&e.key&&1==e.key.length||"Unidentified"==e.key)&&e.key||(e.shiftKey?Aw:bw)[e.keyCode]||e.key||"Unidentified";return"Esc"==t&&(t="Escape"),"Del"==t&&(t="Delete"),"Left"==t&&(t="ArrowLeft"),"Up"==t&&(t="ArrowUp"),"Right"==t&&(t="ArrowRight"),"Down"==t&&(t="ArrowDown"),t}(t),o=HA(zA(i,0))==i.length&&" "!=i,s="",a=!1,l=!1,c=!1;NS&&NS.view==n&&NS.scope==r&&(s=NS.prefix+" ",gk.indexOf(t.keyCode)<0&&(l=!0,NS=null));let h,d,u=new Set,p=e=>{if(e){for(let t of e.run)if(!u.has(t)&&(u.add(t),t(n)))return e.stopPropagation&&(c=!0),!0;e.preventDefault&&(e.stopPropagation&&(c=!0),l=!0)}return!1},f=e[r];return f&&(p(f[s+DS(i,t,!o)])?a=!0:!o||!(t.altKey||t.metaKey||t.ctrlKey)||Iw.windows&&t.ctrlKey&&t.altKey||Iw.mac&&t.altKey&&!t.ctrlKey&&!t.metaKey||!(h=bw[t.keyCode])||h==i?o&&t.shiftKey&&p(f[s+DS(i,t,!0)])&&(a=!0):(p(f[s+DS(h,t,!0)])||t.shiftKey&&(d=Aw[t.keyCode])!=i&&d!=h&&p(f[s+DS(d,t,!1)]))&&(a=!0),!a&&p(f._any)&&(a=!0)),l&&(a=!0),a&&c&&t.stopPropagation(),QS=null,a}class zS{constructor(e,t,n,r,i){this.className=e,this.left=t,this.top=n,this.width=r,this.height=i}draw(){let e=document.createElement("div");return e.className=this.className,this.adjust(e),e}update(e,t){return t.className==this.className&&(this.adjust(e),!0)}adjust(e){e.style.left=this.left+"px",e.style.top=this.top+"px",null!=this.width&&(e.style.width=this.width+"px"),e.style.height=this.height+"px"}eq(e){return this.left==e.left&&this.top==e.top&&this.width==e.width&&this.height==e.height&&this.className==e.className}static forRange(e,t,n){if(n.empty){let r=e.coordsAtPos(n.head,n.assoc||1);if(!r)return[];let i=$S(e);return[new zS(t,r.left-i.left,r.top-i.top,null,r.bottom-r.top)]}return function(e,t,n){if(n.to<=e.viewport.from||n.from>=e.viewport.to)return[];let r=Math.max(n.from,e.viewport.from),i=Math.min(n.to,e.viewport.to),o=e.textDirection==FC.LTR,s=e.contentDOM,a=s.getBoundingClientRect(),l=$S(e),c=s.querySelector(".cm-line"),h=c&&window.getComputedStyle(c),d=a.left+(h?parseInt(h.paddingLeft)+Math.min(0,parseInt(h.textIndent)):0),u=a.right-(h?parseInt(h.paddingRight):0),p=Xx(e,r,1),f=Xx(e,i,-1),g=p.type==SC.Text?p:null,m=f.type==SC.Text?f:null;g&&(e.lineWrapping||p.widgetLineBreaks)&&(g=HS(e,r,1,g));m&&(e.lineWrapping||f.widgetLineBreaks)&&(m=HS(e,i,-1,m));if(g&&m&&g.from==m.from&&g.to==m.to)return b(A(n.from,n.to,g));{let t=g?A(n.from,null,g):y(p,!1),r=m?A(null,n.to,m):y(f,!0),i=[];return(g||p).to<(m||f).from-(g&&m?1:0)||p.widgetLineBreaks>1&&t.bottom+e.defaultLineHeight/2<r.top?i.push(v(d,t.bottom,u,r.top)):t.bottom<r.top&&e.elementAtHeight((t.bottom+r.top)/2).type==SC.Text&&(t.bottom=r.top=(t.bottom+r.top)/2),b(t).concat(i).concat(b(r))}function v(e,n,r,i){return new zS(t,e-l.left,n-l.top,r-e,i-n)}function b({top:e,bottom:t,horizontal:n}){let r=[];for(let i=0;i<n.length;i+=2)r.push(v(n[i],e,n[i+1],t));return r}function A(t,n,r){let i=1e9,s=-1e9,a=[];function l(t,n,l,c,h){let p=e.coordsAtPos(t,t==r.to?-2:2),f=e.coordsAtPos(l,l==r.from?2:-2);p&&f&&(i=Math.min(p.top,f.top,i),s=Math.max(p.bottom,f.bottom,s),h==FC.LTR?a.push(o&&n?d:p.left,o&&c?u:f.right):a.push(!o&&c?d:f.left,!o&&n?u:p.right))}let c=null!=t?t:r.from,h=null!=n?n:r.to;for(let r of e.visibleRanges)if(r.to>c&&r.from<h)for(let i=Math.max(r.from,c),o=Math.min(r.to,h);;){let r=e.state.doc.lineAt(i);for(let s of e.bidiSpans(r)){let e=s.from+r.from,a=s.to+r.from;if(e>=o)break;a>i&&l(Math.max(e,i),null==t&&e<=c,Math.min(a,o),null==n&&a>=h,s.dir)}if(i=r.to+1,i>=o)break}return 0==a.length&&l(c,null==t,h,null==n,e.textDirection),{top:i,bottom:s,horizontal:a}}function y(e,t){let n=a.top+(t?e.top:e.bottom);return{top:n,bottom:n,horizontal:[]}}}(e,t,n)}}function $S(e){let t=e.scrollDOM.getBoundingClientRect();return{left:(e.textDirection==FC.LTR?t.left:t.right-e.scrollDOM.clientWidth*e.scaleX)-e.scrollDOM.scrollLeft*e.scaleX,top:t.top-e.scrollDOM.scrollTop*e.scaleY}}function HS(e,t,n,r){let i=e.coordsAtPos(t,2*n);if(!i)return r;let o=e.dom.getBoundingClientRect(),s=(i.top+i.bottom)/2,a=e.posAtCoords({x:o.left+1,y:s}),l=e.posAtCoords({x:o.right-1,y:s});return null==a||null==l?r:{from:Math.max(r.from,Math.min(a,l)),to:Math.min(r.to,Math.max(a,l))}}class jS{constructor(e,t){this.view=e,this.layer=t,this.drawn=[],this.scaleX=1,this.scaleY=1,this.measureReq={read:this.measure.bind(this),write:this.draw.bind(this)},this.dom=e.scrollDOM.appendChild(document.createElement("div")),this.dom.classList.add("cm-layer"),t.above&&this.dom.classList.add("cm-layer-above"),t.class&&this.dom.classList.add(t.class),this.scale(),this.dom.setAttribute("aria-hidden","true"),this.setOrder(e.state),e.requestMeasure(this.measureReq),t.mount&&t.mount(this.dom,e)}update(e){e.startState.facet(qS)!=e.state.facet(qS)&&this.setOrder(e.state),(this.layer.update(e,this.dom)||e.geometryChanged)&&(this.scale(),e.view.requestMeasure(this.measureReq))}docViewUpdate(e){!1!==this.layer.updateOnDocViewUpdate&&e.requestMeasure(this.measureReq)}setOrder(e){let t=0,n=e.facet(qS);for(;t<n.length&&n[t]!=this.layer;)t++;this.dom.style.zIndex=String((this.layer.above?150:-1)-t)}measure(){return this.layer.markers(this.view)}scale(){let{scaleX:e,scaleY:t}=this.view;e==this.scaleX&&t==this.scaleY||(this.scaleX=e,this.scaleY=t,this.dom.style.transform=`scale(${1/e}, ${1/t})`)}draw(e){if(e.length!=this.drawn.length||e.some((e,t)=>!function(e,t){return e.constructor==t.constructor&&e.eq(t)}(e,this.drawn[t]))){let t=this.dom.firstChild,n=0;for(let r of e)r.update&&t&&r.constructor&&this.drawn[n].constructor&&r.update(t,this.drawn[n])?(t=t.nextSibling,n++):this.dom.insertBefore(r.draw(),t);for(;t;){let e=t.nextSibling;t.remove(),t=e}this.drawn=e,Iw.ios&&(this.dom.style.display=this.dom.firstChild?"":"none")}}destroy(){this.layer.destroy&&this.layer.destroy(this.dom,this.view),this.dom.remove()}}const qS=iy.define();function WS(e){return[xx.define(t=>new jS(t,e)),qS.of(e)]}const US=iy.define({combine:e=>Uy(e,{cursorBlinkRate:1200,drawRangeCursor:!0},{cursorBlinkRate:(e,t)=>Math.min(e,t),drawRangeCursor:(e,t)=>e||t})});function YS(e={}){return[US.of(e),XS,KS,ZS,fx.of(!0)]}function GS(e){return e.startState.facet(US)!=e.state.facet(US)}const XS=WS({above:!0,markers(e){let{state:t}=e,n=t.facet(US),r=[];for(let i of t.selection.ranges){let o=i==t.selection.main;if(i.empty||n.drawRangeCursor){let t=o?"cm-cursor cm-cursor-primary":"cm-cursor cm-cursor-secondary",n=i.empty?i:ty.cursor(i.head,i.head>i.anchor?-1:1);for(let i of zS.forRange(e,t,n))r.push(i)}}return r},update(e,t){e.transactions.some(e=>e.selection)&&(t.style.animationName="cm-blink"==t.style.animationName?"cm-blink2":"cm-blink");let n=GS(e);return n&&JS(e.state,t),e.docChanged||e.selectionSet||n},mount(e,t){JS(t.state,e)},class:"cm-cursorLayer"});function JS(e,t){t.style.animationDuration=e.facet(US).cursorBlinkRate+"ms"}const KS=WS({above:!1,markers:e=>e.state.selection.ranges.map(t=>t.empty?[]:zS.forRange(e,"cm-selectionBackground",t)).reduce((e,t)=>e.concat(t)),update:(e,t)=>e.docChanged||e.selectionSet||e.viewportChanged||GS(e),class:"cm-selectionLayer"}),ZS=vy.highest(OS.theme({".cm-line":{"& ::selection, &::selection":{backgroundColor:"transparent !important"},caretColor:"transparent !important"},".cm-content":{caretColor:"transparent !important","& :focus":{caretColor:"initial !important","&::selection, & ::selection":{backgroundColor:"Highlight !important"}}}})),eO=Ry.define({map:(e,t)=>null==e?null:t.mapPos(e)}),tO=dy.define({create:()=>null,update:(e,t)=>(null!=e&&(e=t.changes.mapPos(e)),t.effects.reduce((e,t)=>t.is(eO)?t.value:e,e))}),nO=xx.fromClass(class{constructor(e){this.view=e,this.cursor=null,this.measureReq={read:this.readPos.bind(this),write:this.drawCursor.bind(this)}}update(e){var t;let n=e.state.field(tO);null==n?null!=this.cursor&&(null===(t=this.cursor)||void 0===t||t.remove(),this.cursor=null):(this.cursor||(this.cursor=this.view.scrollDOM.appendChild(document.createElement("div")),this.cursor.className="cm-dropCursor"),(e.startState.field(tO)!=n||e.docChanged||e.geometryChanged)&&this.view.requestMeasure(this.measureReq))}readPos(){let{view:e}=this,t=e.state.field(tO),n=null!=t&&e.coordsAtPos(t);if(!n)return null;let r=e.scrollDOM.getBoundingClientRect();return{left:n.left-r.left+e.scrollDOM.scrollLeft*e.scaleX,top:n.top-r.top+e.scrollDOM.scrollTop*e.scaleY,height:n.bottom-n.top}}drawCursor(e){if(this.cursor){let{scaleX:t,scaleY:n}=this.view;e?(this.cursor.style.left=e.left/t+"px",this.cursor.style.top=e.top/n+"px",this.cursor.style.height=e.height/n+"px"):this.cursor.style.left="-100000px"}}destroy(){this.cursor&&this.cursor.remove()}setDropPos(e){this.view.state.field(tO)!=e&&this.view.dispatch({effects:eO.of(e)})}},{eventObservers:{dragover(e){this.setDropPos(this.view.posAtCoords({x:e.clientX,y:e.clientY}))},dragleave(e){e.target!=this.view.contentDOM&&this.view.contentDOM.contains(e.relatedTarget)||this.setDropPos(null)},dragend(){this.setDropPos(null)},drop(){this.setDropPos(null)}}});function rO(e,t,n,r,i){t.lastIndex=0;for(let o,s=e.iterRange(n,r),a=n;!s.next().done;a+=s.value.length)if(!s.lineBreak)for(;o=t.exec(s.value);)i(a+o.index,o)}class iO{constructor(e){const{regexp:t,decoration:n,decorate:r,boundary:i,maxLength:o=1e3}=e;if(!t.global)throw new RangeError("The regular expression given to MatchDecorator should have its 'g' flag set");if(this.regexp=t,r)this.addMatch=(e,t,n,i)=>r(i,n,n+e[0].length,e,t);else if("function"==typeof n)this.addMatch=(e,t,r,i)=>{let o=n(e,t,r);o&&i(r,r+e[0].length,o)};else{if(!n)throw new RangeError("Either 'decorate' or 'decoration' should be provided to MatchDecorator");this.addMatch=(e,t,r,i)=>i(r,r+e[0].length,n)}this.boundary=i,this.maxLength=o}createDeco(e){let t=new Zy,n=t.add.bind(t);for(let{from:t,to:r}of function(e,t){let n=e.visibleRanges;if(1==n.length&&n[0].from==e.viewport.from&&n[0].to==e.viewport.to)return n;let r=[];for(let{from:i,to:o}of n)i=Math.max(e.state.doc.lineAt(i).from,i-t),o=Math.min(e.state.doc.lineAt(o).to,o+t),r.length&&r[r.length-1].to>=i?r[r.length-1].to=o:r.push({from:i,to:o});return r}(e,this.maxLength))rO(e.state.doc,this.regexp,t,r,(t,r)=>this.addMatch(r,e,t,n));return t.finish()}updateDeco(e,t){let n=1e9,r=-1;return e.docChanged&&e.changes.iterChanges((t,i,o,s)=>{s>=e.view.viewport.from&&o<=e.view.viewport.to&&(n=Math.min(o,n),r=Math.max(s,r))}),e.viewportMoved||r-n>1e3?this.createDeco(e.view):r>-1?this.updateRange(e.view,t.map(e.changes),n,r):t}updateRange(e,t,n,r){for(let i of e.visibleRanges){let o=Math.max(i.from,n),s=Math.min(i.to,r);if(s>=o){let n=e.state.doc.lineAt(o),r=n.to<s?e.state.doc.lineAt(s):n,a=Math.max(i.from,n.from),l=Math.min(i.to,r.to);if(this.boundary){for(;o>n.from;o--)if(this.boundary.test(n.text[o-1-n.from])){a=o;break}for(;s<r.to;s++)if(this.boundary.test(r.text[s-r.from])){l=s;break}}let c,h=[],d=(e,t,n)=>h.push(n.range(e,t));if(n==r)for(this.regexp.lastIndex=a-n.from;(c=this.regexp.exec(n.text))&&c.index<l-n.from;)this.addMatch(c,e,c.index+n.from,d);else rO(e.state.doc,this.regexp,a,l,(t,n)=>this.addMatch(n,e,t,d));t=t.update({filterFrom:a,filterTo:l,filter:(e,t)=>e<a||t>l,add:h})}}return t}}const oO=null!=/x/.unicode?"gu":"g",sO=new RegExp("[\0-\b\n--­؜​‎‏\u2028\u2029‭‮⁦⁧⁩\ufeff￹-￼]",oO),aO={0:"null",7:"bell",8:"backspace",10:"newline",11:"vertical tab",13:"carriage return",27:"escape",8203:"zero width space",8204:"zero width non-joiner",8205:"zero width joiner",8206:"left-to-right mark",8207:"right-to-left mark",8232:"line separator",8237:"left-to-right override",8238:"right-to-left override",8294:"left-to-right isolate",8295:"right-to-left isolate",8297:"pop directional isolate",8233:"paragraph separator",65279:"zero width no-break space",65532:"object replacement"};let lO=null;const cO=iy.define({combine(e){let t=Uy(e,{render:null,specialChars:sO,addSpecialChars:null});return(t.replaceTabs=!function(){var e;if(null==lO&&"undefined"!=typeof document&&document.body){let t=document.body.style;lO=null!=(null!==(e=t.tabSize)&&void 0!==e?e:t.MozTabSize)}return lO||!1}())&&(t.specialChars=new RegExp("\t|"+t.specialChars.source,oO)),t.addSpecialChars&&(t.specialChars=new RegExp(t.specialChars.source+"|"+t.addSpecialChars.source,oO)),t}});function hO(e={}){return[cO.of(e),dO||(dO=xx.fromClass(class{constructor(e){this.view=e,this.decorations=OC.none,this.decorationCache=Object.create(null),this.decorator=this.makeDecorator(e.state.facet(cO)),this.decorations=this.decorator.createDeco(e)}makeDecorator(e){return new iO({regexp:e.specialChars,decoration:(t,n,r)=>{let{doc:i}=n.state,o=zA(t[0],0);if(9==o){let e=i.lineAt(r),t=n.state.tabSize,o=hw(e.text,t,r-e.from);return OC.replace({widget:new pO((t-o%t)*this.view.defaultCharacterWidth/this.view.scaleX)})}return this.decorationCache[o]||(this.decorationCache[o]=OC.replace({widget:new uO(e,o)}))},boundary:e.replaceTabs?void 0:/[^]/})}update(e){let t=e.state.facet(cO);e.startState.facet(cO)!=t?(this.decorator=this.makeDecorator(t),this.decorations=this.decorator.createDeco(e.view)):this.decorations=this.decorator.updateDeco(e,this.decorations)}},{decorations:e=>e.decorations}))]}let dO=null;class uO extends kC{constructor(e,t){super(),this.options=e,this.code=t}eq(e){return e.code==this.code}toDOM(e){let t=function(e){return e>=32?"•":10==e?"␤":String.fromCharCode(9216+e)}(this.code),n=e.state.phrase("Control character")+" "+(aO[this.code]||"0x"+this.code.toString(16)),r=this.options.render&&this.options.render(this.code,n,t);if(r)return r;let i=document.createElement("span");return i.textContent=t,i.title=n,i.setAttribute("aria-label",n),i.className="cm-specialChar",i}ignoreEvent(){return!1}}class pO extends kC{constructor(e){super(),this.width=e}eq(e){return e.width==this.width}toDOM(){let e=document.createElement("span");return e.textContent="\t",e.className="cm-tab",e.style.width=this.width+"px",e}ignoreEvent(){return!1}}const fO=OC.line({class:"cm-activeLine"}),gO=xx.fromClass(class{constructor(e){this.decorations=this.getDeco(e)}update(e){(e.docChanged||e.selectionSet)&&(this.decorations=this.getDeco(e.view))}getDeco(e){let t=-1,n=[];for(let r of e.state.selection.ranges){let i=e.lineBlockAt(r.head);i.from>t&&(n.push(fO.range(i.from)),t=i.from)}return OC.set(n)}},{decorations:e=>e.decorations});class mO extends kC{constructor(e){super(),this.content=e}toDOM(e){let t=document.createElement("span");return t.className="cm-placeholder",t.style.pointerEvents="none",t.appendChild("string"==typeof this.content?document.createTextNode(this.content):"function"==typeof this.content?this.content(e):this.content.cloneNode(!0)),t.setAttribute("aria-hidden","true"),t}coordsAt(e){let t=e.firstChild?Qw(e.firstChild):[];if(!t.length)return null;let n=window.getComputedStyle(e.parentNode),r=qw(t[0],"rtl"!=n.direction),i=parseInt(n.lineHeight);return r.bottom-r.top>1.5*i?{left:r.left,right:r.right,top:r.top,bottom:r.top+i}:r}ignoreEvent(){return!1}}const vO=2e3;function bO(e,t){let n=e.posAtCoords({x:t.clientX,y:t.clientY},!1),r=e.state.doc.lineAt(n),i=n-r.from,o=i>vO?-1:i==r.length?function(e,t){let n=e.coordsAtPos(e.viewport.from);return n?Math.round(Math.abs((n.left-t)/e.defaultCharacterWidth)):-1}(e,t.clientX):hw(r.text,e.state.tabSize,n-r.from);return{line:r.number,col:o,off:i}}function AO(e,t){let n=bO(e,t),r=e.state.selection;return n?{update(e){if(e.docChanged){let t=e.changes.mapPos(e.startState.doc.line(n.line).from),i=e.state.doc.lineAt(t);n={line:i.number,col:n.col,off:Math.min(n.off,i.length)},r=r.map(e.changes)}},get(t,i,o){let s=bO(e,t);if(!s)return r;let a=function(e,t,n){let r=Math.min(t.line,n.line),i=Math.max(t.line,n.line),o=[];if(t.off>vO||n.off>vO||t.col<0||n.col<0){let s=Math.min(t.off,n.off),a=Math.max(t.off,n.off);for(let t=r;t<=i;t++){let n=e.doc.line(t);n.length<=a&&o.push(ty.range(n.from+s,n.to+a))}}else{let s=Math.min(t.col,n.col),a=Math.max(t.col,n.col);for(let t=r;t<=i;t++){let n=e.doc.line(t),r=dw(n.text,s,e.tabSize,!0);if(r<0)o.push(ty.cursor(n.to));else{let t=dw(n.text,a,e.tabSize);o.push(ty.range(n.from+r,n.from+t))}}}return o}(e.state,n,s);return a.length?o?ty.create(a.concat(r.ranges)):ty.create(a):r}}:null}function yO(e){let t=(null==e?void 0:e.eventFilter)||(e=>e.altKey&&0==e.button);return OS.mouseSelectionStyle.of((e,n)=>t(n)?AO(e,n):null)}const wO={Alt:[18,e=>!!e.altKey],Control:[17,e=>!!e.ctrlKey],Shift:[16,e=>!!e.shiftKey],Meta:[91,e=>!!e.metaKey]},CO={style:"cursor: crosshair"};function xO(e={}){let[t,n]=wO[e.key||"Alt"],r=xx.fromClass(class{constructor(e){this.view=e,this.isDown=!1}set(e){this.isDown!=e&&(this.isDown=e,this.view.update([]))}},{eventObservers:{keydown(e){this.set(e.keyCode==t||n(e))},keyup(e){e.keyCode!=t&&n(e)||this.set(!1)},mousemove(e){this.set(n(e))}}});return[r,OS.contentAttributes.of(e=>{var t;return(null===(t=e.plugin(r))||void 0===t?void 0:t.isDown)?CO:null})]}const kO="-10000px";class SO{constructor(e,t,n,r){this.facet=t,this.createTooltipView=n,this.removeTooltipView=r,this.input=e.state.facet(t),this.tooltips=this.input.filter(e=>e);let i=null;this.tooltipViews=this.tooltips.map(e=>i=n(e,i))}update(e,t){var n;let r=e.state.facet(this.facet),i=r.filter(e=>e);if(r===this.input){for(let t of this.tooltipViews)t.update&&t.update(e);return!1}let o=[],s=t?[]:null;for(let n=0;n<i.length;n++){let r=i[n],a=-1;if(r){for(let e=0;e<this.tooltips.length;e++){let t=this.tooltips[e];t&&t.create==r.create&&(a=e)}if(a<0)o[n]=this.createTooltipView(r,n?o[n-1]:null),s&&(s[n]=!!r.above);else{let r=o[n]=this.tooltipViews[a];s&&(s[n]=t[a]),r.update&&r.update(e)}}}for(let e of this.tooltipViews)o.indexOf(e)<0&&(this.removeTooltipView(e),null===(n=e.destroy)||void 0===n||n.call(e));return t&&(s.forEach((e,n)=>t[n]=e),t.length=s.length),this.input=r,this.tooltips=i,this.tooltipViews=o,!0}}function OO(e){let t=e.dom.ownerDocument.documentElement;return{top:0,left:0,bottom:t.clientHeight,right:t.clientWidth}}const BO=iy.define({combine:e=>{var t,n,r;return{position:Iw.ios?"absolute":(null===(t=e.find(e=>e.position))||void 0===t?void 0:t.position)||"fixed",parent:(null===(n=e.find(e=>e.parent))||void 0===n?void 0:n.parent)||null,tooltipSpace:(null===(r=e.find(e=>e.tooltipSpace))||void 0===r?void 0:r.tooltipSpace)||OO}}}),_O=new WeakMap,TO=xx.fromClass(class{constructor(e){this.view=e,this.above=[],this.inView=!0,this.madeAbsolute=!1,this.lastTransaction=0,this.measureTimeout=-1;let t=e.state.facet(BO);this.position=t.position,this.parent=t.parent,this.classes=e.themeClasses,this.createContainer(),this.measureReq={read:this.readMeasure.bind(this),write:this.writeMeasure.bind(this),key:this},this.resizeObserver="function"==typeof ResizeObserver?new ResizeObserver(()=>this.measureSoon()):null,this.manager=new SO(e,PO,(e,t)=>this.createTooltip(e,t),e=>{this.resizeObserver&&this.resizeObserver.unobserve(e.dom),e.dom.remove()}),this.above=this.manager.tooltips.map(e=>!!e.above),this.intersectionObserver="function"==typeof IntersectionObserver?new IntersectionObserver(e=>{Date.now()>this.lastTransaction-50&&e.length>0&&e[e.length-1].intersectionRatio<1&&this.measureSoon()},{threshold:[1]}):null,this.observeIntersection(),e.win.addEventListener("resize",this.measureSoon=this.measureSoon.bind(this)),this.maybeMeasure()}createContainer(){this.parent?(this.container=document.createElement("div"),this.container.style.position="relative",this.container.className=this.view.themeClasses,this.parent.appendChild(this.container)):this.container=this.view.dom}observeIntersection(){if(this.intersectionObserver){this.intersectionObserver.disconnect();for(let e of this.manager.tooltipViews)this.intersectionObserver.observe(e.dom)}}measureSoon(){this.measureTimeout<0&&(this.measureTimeout=setTimeout(()=>{this.measureTimeout=-1,this.maybeMeasure()},50))}update(e){e.transactions.length&&(this.lastTransaction=Date.now());let t=this.manager.update(e,this.above);t&&this.observeIntersection();let n=t||e.geometryChanged,r=e.state.facet(BO);if(r.position!=this.position&&!this.madeAbsolute){this.position=r.position;for(let e of this.manager.tooltipViews)e.dom.style.position=this.position;n=!0}if(r.parent!=this.parent){this.parent&&this.container.remove(),this.parent=r.parent,this.createContainer();for(let e of this.manager.tooltipViews)this.container.appendChild(e.dom);n=!0}else this.parent&&this.view.themeClasses!=this.classes&&(this.classes=this.container.className=this.view.themeClasses);n&&this.maybeMeasure()}createTooltip(e,t){let n=e.create(this.view),r=t?t.dom:null;if(n.dom.classList.add("cm-tooltip"),e.arrow&&!n.dom.querySelector(".cm-tooltip > .cm-tooltip-arrow")){let e=document.createElement("div");e.className="cm-tooltip-arrow",n.dom.appendChild(e)}return n.dom.style.position=this.position,n.dom.style.top=kO,n.dom.style.left="0px",this.container.insertBefore(n.dom,r),n.mount&&n.mount(this.view),this.resizeObserver&&this.resizeObserver.observe(n.dom),n}destroy(){var e,t,n;this.view.win.removeEventListener("resize",this.measureSoon);for(let t of this.manager.tooltipViews)t.dom.remove(),null===(e=t.destroy)||void 0===e||e.call(t);this.parent&&this.container.remove(),null===(t=this.resizeObserver)||void 0===t||t.disconnect(),null===(n=this.intersectionObserver)||void 0===n||n.disconnect(),clearTimeout(this.measureTimeout)}readMeasure(){let e=1,t=1,n=!1;if("fixed"==this.position&&this.manager.tooltipViews.length){let{dom:e}=this.manager.tooltipViews[0];if(Iw.gecko)n=e.offsetParent!=this.container.ownerDocument.body;else if(e.style.top==kO&&"0px"==e.style.left){let t=e.getBoundingClientRect();n=Math.abs(t.top+1e4)>1||Math.abs(t.left)>1}}if(n||"absolute"==this.position)if(this.parent){let n=this.parent.getBoundingClientRect();n.width&&n.height&&(e=n.width/this.parent.offsetWidth,t=n.height/this.parent.offsetHeight)}else({scaleX:e,scaleY:t}=this.view.viewState);let r=this.view.scrollDOM.getBoundingClientRect(),i=Px(this.view);return{visible:{left:r.left+i.left,top:r.top+i.top,right:r.right-i.right,bottom:r.bottom-i.bottom},parent:this.parent?this.container.getBoundingClientRect():this.view.dom.getBoundingClientRect(),pos:this.manager.tooltips.map((e,t)=>{let n=this.manager.tooltipViews[t];return n.getCoords?n.getCoords(e.pos):this.view.coordsAtPos(e.pos)}),size:this.manager.tooltipViews.map(({dom:e})=>e.getBoundingClientRect()),space:this.view.state.facet(BO).tooltipSpace(this.view),scaleX:e,scaleY:t,makeAbsolute:n}}writeMeasure(e){var t;if(e.makeAbsolute){this.madeAbsolute=!0,this.position="absolute";for(let e of this.manager.tooltipViews)e.dom.style.position="absolute"}let{visible:n,space:r,scaleX:i,scaleY:o}=e,s=[];for(let a=0;a<this.manager.tooltips.length;a++){let l=this.manager.tooltips[a],c=this.manager.tooltipViews[a],{dom:h}=c,d=e.pos[a],u=e.size[a];if(!d||!1!==l.clip&&(d.bottom<=Math.max(n.top,r.top)||d.top>=Math.min(n.bottom,r.bottom)||d.right<Math.max(n.left,r.left)-.1||d.left>Math.min(n.right,r.right)+.1)){h.style.top=kO;continue}let p=l.arrow?c.dom.querySelector(".cm-tooltip-arrow"):null,f=p?7:0,g=u.right-u.left,m=null!==(t=_O.get(c))&&void 0!==t?t:u.bottom-u.top,v=c.offset||DO,b=this.view.textDirection==FC.LTR,A=u.width>r.right-r.left?b?r.left:r.right-u.width:b?Math.max(r.left,Math.min(d.left-(p?14:0)+v.x,r.right-g)):Math.min(Math.max(r.left,d.left-g+(p?14:0)-v.x),r.right-g),y=this.above[a];!l.strictSide&&(y?d.top-m-f-v.y<r.top:d.bottom+m+f+v.y>r.bottom)&&y==r.bottom-d.bottom>d.top-r.top&&(y=this.above[a]=!y);let w=(y?d.top-r.top:r.bottom-d.bottom)-f;if(w<m&&!1!==c.resize){if(w<this.view.defaultLineHeight){h.style.top=kO;continue}_O.set(c,m),h.style.height=(m=w)/o+"px"}else h.style.height&&(h.style.height="");let C=y?d.top-m-f-v.y:d.bottom+f+v.y,x=A+g;if(!0!==c.overlap)for(let e of s)e.left<x&&e.right>A&&e.top<C+m&&e.bottom>C&&(C=y?e.top-m-2-f:e.bottom+f+2);if("absolute"==this.position?(h.style.top=(C-e.parent.top)/o+"px",EO(h,(A-e.parent.left)/i)):(h.style.top=C/o+"px",EO(h,A/i)),p){let e=d.left+(b?v.x:-v.x)-(A+14-7);p.style.left=e/i+"px"}!0!==c.overlap&&s.push({left:A,top:C,right:x,bottom:C+m}),h.classList.toggle("cm-tooltip-above",y),h.classList.toggle("cm-tooltip-below",!y),c.positioned&&c.positioned(e.space)}}maybeMeasure(){if(this.manager.tooltips.length&&(this.view.inView&&this.view.requestMeasure(this.measureReq),this.inView!=this.view.inView&&(this.inView=this.view.inView,!this.inView)))for(let e of this.manager.tooltipViews)e.dom.style.top=kO}},{eventObservers:{scroll(){this.maybeMeasure()}}});function EO(e,t){let n=parseInt(e.style.left,10);(isNaN(n)||Math.abs(t-n)>1)&&(e.style.left=t+"px")}const MO=OS.baseTheme({".cm-tooltip":{zIndex:500,boxSizing:"border-box"},"&light .cm-tooltip":{border:"1px solid #bbb",backgroundColor:"#f5f5f5"},"&light .cm-tooltip-section:not(:first-child)":{borderTop:"1px solid #bbb"},"&dark .cm-tooltip":{backgroundColor:"#333338",color:"white"},".cm-tooltip-arrow":{height:"7px",width:"14px",position:"absolute",zIndex:-1,overflow:"hidden","&:before, &:after":{content:"''",position:"absolute",width:0,height:0,borderLeft:"7px solid transparent",borderRight:"7px solid transparent"},".cm-tooltip-above &":{bottom:"-7px","&:before":{borderTop:"7px solid #bbb"},"&:after":{borderTop:"7px solid #f5f5f5",bottom:"1px"}},".cm-tooltip-below &":{top:"-7px","&:before":{borderBottom:"7px solid #bbb"},"&:after":{borderBottom:"7px solid #f5f5f5",top:"1px"}}},"&dark .cm-tooltip .cm-tooltip-arrow":{"&:before":{borderTopColor:"#333338",borderBottomColor:"#333338"},"&:after":{borderTopColor:"transparent",borderBottomColor:"transparent"}}}),DO={x:0,y:0},PO=iy.define({enables:[TO,MO]}),RO=iy.define({combine:e=>e.reduce((e,t)=>e.concat(t),[])});class IO{static create(e){return new IO(e)}constructor(e){this.view=e,this.mounted=!1,this.dom=document.createElement("div"),this.dom.classList.add("cm-tooltip-hover"),this.manager=new SO(e,RO,(e,t)=>this.createHostedView(e,t),e=>e.dom.remove())}createHostedView(e,t){let n=e.create(this.view);return n.dom.classList.add("cm-tooltip-section"),this.dom.insertBefore(n.dom,t?t.dom.nextSibling:this.dom.firstChild),this.mounted&&n.mount&&n.mount(this.view),n}mount(e){for(let t of this.manager.tooltipViews)t.mount&&t.mount(e);this.mounted=!0}positioned(e){for(let t of this.manager.tooltipViews)t.positioned&&t.positioned(e)}update(e){this.manager.update(e)}destroy(){var e;for(let t of this.manager.tooltipViews)null===(e=t.destroy)||void 0===e||e.call(t)}passProp(e){let t;for(let n of this.manager.tooltipViews){let r=n[e];if(void 0!==r)if(void 0===t)t=r;else if(t!==r)return}return t}get offset(){return this.passProp("offset")}get getCoords(){return this.passProp("getCoords")}get overlap(){return this.passProp("overlap")}get resize(){return this.passProp("resize")}}const LO=PO.compute([RO],e=>{let t=e.facet(RO);return 0===t.length?null:{pos:Math.min(...t.map(e=>e.pos)),end:Math.max(...t.map(e=>{var t;return null!==(t=e.end)&&void 0!==t?t:e.pos})),create:IO.create,above:t[0].above,arrow:t.some(e=>e.arrow)}});class NO{constructor(e,t,n,r,i){this.view=e,this.source=t,this.field=n,this.setHover=r,this.hoverTime=i,this.hoverTimeout=-1,this.restartTimeout=-1,this.pending=null,this.lastMove={x:0,y:0,target:e.dom,time:0},this.checkHover=this.checkHover.bind(this),e.dom.addEventListener("mouseleave",this.mouseleave=this.mouseleave.bind(this)),e.dom.addEventListener("mousemove",this.mousemove=this.mousemove.bind(this))}update(){this.pending&&(this.pending=null,clearTimeout(this.restartTimeout),this.restartTimeout=setTimeout(()=>this.startHover(),20))}get active(){return this.view.state.field(this.field)}checkHover(){if(this.hoverTimeout=-1,this.active.length)return;let e=Date.now()-this.lastMove.time;e<this.hoverTime?this.hoverTimeout=setTimeout(this.checkHover,this.hoverTime-e):this.startHover()}startHover(){clearTimeout(this.restartTimeout);let{view:e,lastMove:t}=this,n=e.docView.nearest(t.target);if(!n)return;let r,i=1;if(n instanceof pC)r=n.posAtStart;else{if(r=e.posAtCoords(t),null==r)return;let n=e.coordsAtPos(r);if(!n||t.y<n.top||t.y>n.bottom||t.x<n.left-e.defaultCharacterWidth||t.x>n.right+e.defaultCharacterWidth)return;let o=e.bidiSpans(e.state.doc.lineAt(r)).find(e=>e.from<=r&&e.to>=r),s=o&&o.dir==FC.RTL?-1:1;i=t.x<n.left?-s:s}let o=this.source(e,r,i);if(null==o?void 0:o.then){let t=this.pending={pos:r};o.then(n=>{this.pending==t&&(this.pending=null,!n||Array.isArray(n)&&!n.length||e.dispatch({effects:this.setHover.of(Array.isArray(n)?n:[n])}))},t=>Ax(e.state,t,"hover tooltip"))}else!o||Array.isArray(o)&&!o.length||e.dispatch({effects:this.setHover.of(Array.isArray(o)?o:[o])})}get tooltip(){let e=this.view.plugin(TO),t=e?e.manager.tooltips.findIndex(e=>e.create==IO.create):-1;return t>-1?e.manager.tooltipViews[t]:null}mousemove(e){var t,n;this.lastMove={x:e.clientX,y:e.clientY,target:e.target,time:Date.now()},this.hoverTimeout<0&&(this.hoverTimeout=setTimeout(this.checkHover,this.hoverTime));let{active:r,tooltip:i}=this;if(r.length&&i&&!function(e,t){let n,{left:r,right:i,top:o,bottom:s}=e.getBoundingClientRect();if(n=e.querySelector(".cm-tooltip-arrow")){let e=n.getBoundingClientRect();o=Math.min(e.top,o),s=Math.max(e.bottom,s)}return t.clientX>=r-FO&&t.clientX<=i+FO&&t.clientY>=o-FO&&t.clientY<=s+FO}(i.dom,e)||this.pending){let{pos:i}=r[0]||this.pending,o=null!==(n=null===(t=r[0])||void 0===t?void 0:t.end)&&void 0!==n?n:i;(i==o?this.view.posAtCoords(this.lastMove)==i:function(e,t,n,r,i){let o=e.scrollDOM.getBoundingClientRect(),s=e.documentTop+e.documentPadding.top+e.contentHeight;if(o.left>r||o.right<r||o.top>i||Math.min(o.bottom,s)<i)return!1;let a=e.posAtCoords({x:r,y:i},!1);return a>=t&&a<=n}(this.view,i,o,e.clientX,e.clientY))||(this.view.dispatch({effects:this.setHover.of([])}),this.pending=null)}}mouseleave(e){clearTimeout(this.hoverTimeout),this.hoverTimeout=-1;let{active:t}=this;if(t.length){let{tooltip:t}=this;t&&t.dom.contains(e.relatedTarget)?this.watchTooltipLeave(t.dom):this.view.dispatch({effects:this.setHover.of([])})}}watchTooltipLeave(e){let t=n=>{e.removeEventListener("mouseleave",t),this.active.length&&!this.view.dom.contains(n.relatedTarget)&&this.view.dispatch({effects:this.setHover.of([])})};e.addEventListener("mouseleave",t)}destroy(){clearTimeout(this.hoverTimeout),this.view.dom.removeEventListener("mouseleave",this.mouseleave),this.view.dom.removeEventListener("mousemove",this.mousemove)}}const FO=4;function QO(e,t={}){let n=Ry.define(),r=dy.define({create:()=>[],update(e,r){if(e.length&&(t.hideOnChange&&(r.docChanged||r.selection)?e=[]:t.hideOn&&(e=e.filter(e=>!t.hideOn(r,e))),r.docChanged)){let t=[];for(let n of e){let e=r.changes.mapPos(n.pos,-1,qA.TrackDel);if(null!=e){let i=Object.assign(Object.create(null),n);i.pos=e,null!=i.end&&(i.end=r.changes.mapPos(i.end)),t.push(i)}}e=t}for(let t of r.effects)t.is(n)&&(e=t.value),t.is(zO)&&(e=[]);return e},provide:e=>RO.from(e)});return{active:r,extension:[r,xx.define(i=>new NO(i,e,r,n,t.hoverTime||300)),LO]}}function VO(e,t){let n=e.plugin(TO);if(!n)return null;let r=n.manager.tooltips.indexOf(t);return r<0?null:n.manager.tooltipViews[r]}const zO=Ry.define();const $O=iy.define({combine(e){let t,n;for(let r of e)t=t||r.topContainer,n=n||r.bottomContainer;return{topContainer:t,bottomContainer:n}}});function HO(e,t){let n=e.plugin(jO),r=n?n.specs.indexOf(t):-1;return r>-1?n.panels[r]:null}const jO=xx.fromClass(class{constructor(e){this.input=e.state.facet(UO),this.specs=this.input.filter(e=>e),this.panels=this.specs.map(t=>t(e));let t=e.state.facet($O);this.top=new qO(e,!0,t.topContainer),this.bottom=new qO(e,!1,t.bottomContainer),this.top.sync(this.panels.filter(e=>e.top)),this.bottom.sync(this.panels.filter(e=>!e.top));for(let e of this.panels)e.dom.classList.add("cm-panel"),e.mount&&e.mount()}update(e){let t=e.state.facet($O);this.top.container!=t.topContainer&&(this.top.sync([]),this.top=new qO(e.view,!0,t.topContainer)),this.bottom.container!=t.bottomContainer&&(this.bottom.sync([]),this.bottom=new qO(e.view,!1,t.bottomContainer)),this.top.syncClasses(),this.bottom.syncClasses();let n=e.state.facet(UO);if(n!=this.input){let t=n.filter(e=>e),r=[],i=[],o=[],s=[];for(let n of t){let t,a=this.specs.indexOf(n);a<0?(t=n(e.view),s.push(t)):(t=this.panels[a],t.update&&t.update(e)),r.push(t),(t.top?i:o).push(t)}this.specs=t,this.panels=r,this.top.sync(i),this.bottom.sync(o);for(let e of s)e.dom.classList.add("cm-panel"),e.mount&&e.mount()}else for(let t of this.panels)t.update&&t.update(e)}destroy(){this.top.sync([]),this.bottom.sync([])}},{provide:e=>OS.scrollMargins.of(t=>{let n=t.plugin(e);return n&&{top:n.top.scrollMargin(),bottom:n.bottom.scrollMargin()}})});class qO{constructor(e,t,n){this.view=e,this.top=t,this.container=n,this.dom=void 0,this.classes="",this.panels=[],this.syncClasses()}sync(e){for(let t of this.panels)t.destroy&&e.indexOf(t)<0&&t.destroy();this.panels=e,this.syncDOM()}syncDOM(){if(0==this.panels.length)return void(this.dom&&(this.dom.remove(),this.dom=void 0));if(!this.dom){this.dom=document.createElement("div"),this.dom.className=this.top?"cm-panels cm-panels-top":"cm-panels cm-panels-bottom",this.dom.style[this.top?"top":"bottom"]="0";let e=this.container||this.view.dom;e.insertBefore(this.dom,this.top?e.firstChild:null)}let e=this.dom.firstChild;for(let t of this.panels)if(t.dom.parentNode==this.dom){for(;e!=t.dom;)e=WO(e);e=e.nextSibling}else this.dom.insertBefore(t.dom,e);for(;e;)e=WO(e)}scrollMargin(){return!this.dom||this.container?0:Math.max(0,this.top?this.dom.getBoundingClientRect().bottom-Math.max(0,this.view.scrollDOM.getBoundingClientRect().top):Math.min(innerHeight,this.view.scrollDOM.getBoundingClientRect().bottom)-this.dom.getBoundingClientRect().top)}syncClasses(){if(this.container&&this.classes!=this.view.themeClasses){for(let e of this.classes.split(" "))e&&this.container.classList.remove(e);for(let e of(this.classes=this.view.themeClasses).split(" "))e&&this.container.classList.add(e)}}}function WO(e){let t=e.nextSibling;return e.remove(),t}const UO=iy.define({enables:jO});class YO extends Yy{compare(e){return this==e||this.constructor==e.constructor&&this.eq(e)}eq(e){return!1}destroy(e){}}YO.prototype.elementClass="",YO.prototype.toDOM=void 0,YO.prototype.mapMode=qA.TrackBefore,YO.prototype.startSide=YO.prototype.endSide=-1,YO.prototype.point=!0;const GO=iy.define(),XO=iy.define(),JO={class:"",renderEmptyElements:!1,elementStyle:"",markers:()=>Ky.empty,lineMarker:()=>null,widgetMarker:()=>null,lineMarkerChange:null,initialSpacer:null,updateSpacer:null,domEventHandlers:{},side:"before"},KO=iy.define();function ZO(e){return[tB(),KO.of({...JO,...e})]}const eB=iy.define({combine:e=>e.some(e=>e)});function tB(e){let t=[nB];return e&&!1===e.fixed&&t.push(eB.of(!0)),t}const nB=xx.fromClass(class{constructor(e){this.view=e,this.domAfter=null,this.prevViewport=e.viewport,this.dom=document.createElement("div"),this.dom.className="cm-gutters cm-gutters-before",this.dom.setAttribute("aria-hidden","true"),this.dom.style.minHeight=this.view.contentHeight/this.view.scaleY+"px",this.gutters=e.state.facet(KO).map(t=>new sB(e,t)),this.fixed=!e.state.facet(eB);for(let e of this.gutters)"after"==e.config.side?this.getDOMAfter().appendChild(e.dom):this.dom.appendChild(e.dom);this.fixed&&(this.dom.style.position="sticky"),this.syncGutters(!1),e.scrollDOM.insertBefore(this.dom,e.contentDOM)}getDOMAfter(){return this.domAfter||(this.domAfter=document.createElement("div"),this.domAfter.className="cm-gutters cm-gutters-after",this.domAfter.setAttribute("aria-hidden","true"),this.domAfter.style.minHeight=this.view.contentHeight/this.view.scaleY+"px",this.domAfter.style.position=this.fixed?"sticky":"",this.view.scrollDOM.appendChild(this.domAfter)),this.domAfter}update(e){if(this.updateGutters(e)){let t=this.prevViewport,n=e.view.viewport,r=Math.min(t.to,n.to)-Math.max(t.from,n.from);this.syncGutters(r<.8*(n.to-n.from))}if(e.geometryChanged){let e=this.view.contentHeight/this.view.scaleY+"px";this.dom.style.minHeight=e,this.domAfter&&(this.domAfter.style.minHeight=e)}this.view.state.facet(eB)!=!this.fixed&&(this.fixed=!this.fixed,this.dom.style.position=this.fixed?"sticky":"",this.domAfter&&(this.domAfter.style.position=this.fixed?"sticky":"")),this.prevViewport=e.view.viewport}syncGutters(e){let t=this.dom.nextSibling;e&&(this.dom.remove(),this.domAfter&&this.domAfter.remove());let n=Ky.iter(this.view.state.facet(GO),this.view.viewport.from),r=[],i=this.gutters.map(e=>new oB(e,this.view.viewport,-this.view.documentPadding.top));for(let e of this.view.viewportLineBlocks)if(r.length&&(r=[]),Array.isArray(e.type)){let t=!0;for(let o of e.type)if(o.type==SC.Text&&t){iB(n,r,o.from);for(let e of i)e.line(this.view,o,r);t=!1}else if(o.widget)for(let e of i)e.widget(this.view,o)}else if(e.type==SC.Text){iB(n,r,e.from);for(let t of i)t.line(this.view,e,r)}else if(e.widget)for(let t of i)t.widget(this.view,e);for(let e of i)e.finish();e&&(this.view.scrollDOM.insertBefore(this.dom,t),this.domAfter&&this.view.scrollDOM.appendChild(this.domAfter))}updateGutters(e){let t=e.startState.facet(KO),n=e.state.facet(KO),r=e.docChanged||e.heightChanged||e.viewportChanged||!Ky.eq(e.startState.facet(GO),e.state.facet(GO),e.view.viewport.from,e.view.viewport.to);if(t==n)for(let t of this.gutters)t.update(e)&&(r=!0);else{r=!0;let i=[];for(let r of n){let n=t.indexOf(r);n<0?i.push(new sB(this.view,r)):(this.gutters[n].update(e),i.push(this.gutters[n]))}for(let e of this.gutters)e.dom.remove(),i.indexOf(e)<0&&e.destroy();for(let e of i)"after"==e.config.side?this.getDOMAfter().appendChild(e.dom):this.dom.appendChild(e.dom);this.gutters=i}return r}destroy(){for(let e of this.gutters)e.destroy();this.dom.remove(),this.domAfter&&this.domAfter.remove()}},{provide:e=>OS.scrollMargins.of(t=>{let n=t.plugin(e);if(!n||0==n.gutters.length||!n.fixed)return null;let r=n.dom.offsetWidth*t.scaleX,i=n.domAfter?n.domAfter.offsetWidth*t.scaleX:0;return t.textDirection==FC.LTR?{left:r,right:i}:{right:r,left:i}})});function rB(e){return Array.isArray(e)?e:[e]}function iB(e,t,n){for(;e.value&&e.from<=n;)e.from==n&&t.push(e.value),e.next()}class oB{constructor(e,t,n){this.gutter=e,this.height=n,this.i=0,this.cursor=Ky.iter(e.markers,t.from)}addElement(e,t,n){let{gutter:r}=this,i=(t.top-this.height)/e.scaleY,o=t.height/e.scaleY;if(this.i==r.elements.length){let t=new aB(e,o,i,n);r.elements.push(t),r.dom.appendChild(t.dom)}else r.elements[this.i].update(e,o,i,n);this.height=t.bottom,this.i++}line(e,t,n){let r=[];iB(this.cursor,r,t.from),n.length&&(r=r.concat(n));let i=this.gutter.config.lineMarker(e,t,r);i&&r.unshift(i);let o=this.gutter;(0!=r.length||o.config.renderEmptyElements)&&this.addElement(e,t,r)}widget(e,t){let n=this.gutter.config.widgetMarker(e,t.widget,t),r=n?[n]:null;for(let n of e.state.facet(XO)){let i=n(e,t.widget,t);i&&(r||(r=[])).push(i)}r&&this.addElement(e,t,r)}finish(){let e=this.gutter;for(;e.elements.length>this.i;){let t=e.elements.pop();e.dom.removeChild(t.dom),t.destroy()}}}class sB{constructor(e,t){this.view=e,this.config=t,this.elements=[],this.spacer=null,this.dom=document.createElement("div"),this.dom.className="cm-gutter"+(this.config.class?" "+this.config.class:"");for(let n in t.domEventHandlers)this.dom.addEventListener(n,r=>{let i,o=r.target;if(o!=this.dom&&this.dom.contains(o)){for(;o.parentNode!=this.dom;)o=o.parentNode;let e=o.getBoundingClientRect();i=(e.top+e.bottom)/2}else i=r.clientY;let s=e.lineBlockAtHeight(i-e.documentTop);t.domEventHandlers[n](e,s,r)&&r.preventDefault()});this.markers=rB(t.markers(e)),t.initialSpacer&&(this.spacer=new aB(e,0,0,[t.initialSpacer(e)]),this.dom.appendChild(this.spacer.dom),this.spacer.dom.style.cssText+="visibility: hidden; pointer-events: none")}update(e){let t=this.markers;if(this.markers=rB(this.config.markers(e.view)),this.spacer&&this.config.updateSpacer){let t=this.config.updateSpacer(this.spacer.markers[0],e);t!=this.spacer.markers[0]&&this.spacer.update(e.view,0,0,[t])}let n=e.view.viewport;return!Ky.eq(this.markers,t,n.from,n.to)||!!this.config.lineMarkerChange&&this.config.lineMarkerChange(e)}destroy(){for(let e of this.elements)e.destroy()}}class aB{constructor(e,t,n,r){this.height=-1,this.above=0,this.markers=[],this.dom=document.createElement("div"),this.dom.className="cm-gutterElement",this.update(e,t,n,r)}update(e,t,n,r){this.height!=t&&(this.height=t,this.dom.style.height=t+"px"),this.above!=n&&(this.dom.style.marginTop=(this.above=n)?n+"px":""),function(e,t){if(e.length!=t.length)return!1;for(let n=0;n<e.length;n++)if(!e[n].compare(t[n]))return!1;return!0}(this.markers,r)||this.setMarkers(e,r)}setMarkers(e,t){let n="cm-gutterElement",r=this.dom.firstChild;for(let i=0,o=0;;){let s=o,a=i<t.length?t[i++]:null,l=!1;if(a){let e=a.elementClass;e&&(n+=" "+e);for(let e=o;e<this.markers.length;e++)if(this.markers[e].compare(a)){s=e,l=!0;break}}else s=this.markers.length;for(;o<s;){let e=this.markers[o++];if(e.toDOM){e.destroy(r);let t=r.nextSibling;r.remove(),r=t}}if(!a)break;a.toDOM&&(l?r=r.nextSibling:this.dom.insertBefore(a.toDOM(e),r)),l&&o++}this.dom.className=n,this.markers=t}destroy(){this.setMarkers(null,[])}}const lB=iy.define(),cB=iy.define(),hB=iy.define({combine:e=>Uy(e,{formatNumber:String,domEventHandlers:{}},{domEventHandlers(e,t){let n=Object.assign({},e);for(let e in t){let r=n[e],i=t[e];n[e]=r?(e,t,n)=>r(e,t,n)||i(e,t,n):i}return n}})});class dB extends YO{constructor(e){super(),this.number=e}eq(e){return this.number==e.number}toDOM(){return document.createTextNode(this.number)}}function uB(e,t){return e.state.facet(hB).formatNumber(t,e.state)}const pB=KO.compute([hB],e=>({class:"cm-lineNumbers",renderEmptyElements:!1,markers:e=>e.state.facet(lB),lineMarker:(e,t,n)=>n.some(e=>e.toDOM)?null:new dB(uB(e,e.state.doc.lineAt(t.from).number)),widgetMarker:(e,t,n)=>{for(let r of e.state.facet(cB)){let i=r(e,t,n);if(i)return i}return null},lineMarkerChange:e=>e.startState.facet(hB)!=e.state.facet(hB),initialSpacer:e=>new dB(uB(e,gB(e.state.doc.lines))),updateSpacer(e,t){let n=uB(t.view,gB(t.view.state.doc.lines));return n==e.number?e:new dB(n)},domEventHandlers:e.facet(hB).domEventHandlers,side:"before"}));function fB(e={}){return[hB.of(e),tB(),pB]}function gB(e){let t=9;for(;t<e;)t=10*t+9;return t}const mB=new class extends YO{constructor(){super(...arguments),this.elementClass="cm-activeLineGutter"}},vB=GO.compute(["selection"],e=>{let t=[],n=-1;for(let r of e.selection.ranges){let i=e.doc.lineAt(r.head).from;i>n&&(n=i,t.push(mB.range(i)))}return Ky.of(t)});const bB=1024;let AB=0;class yB{constructor(e,t){this.from=e,this.to=t}}class wB{constructor(e={}){this.id=AB++,this.perNode=!!e.perNode,this.deserialize=e.deserialize||(()=>{throw new Error("This node type doesn't define a deserialize function")})}add(e){if(this.perNode)throw new RangeError("Can't add per-node props to node types");return"function"!=typeof e&&(e=kB.match(e)),t=>{let n=e(t);return void 0===n?null:[this,n]}}}wB.closedBy=new wB({deserialize:e=>e.split(" ")}),wB.openedBy=new wB({deserialize:e=>e.split(" ")}),wB.group=new wB({deserialize:e=>e.split(" ")}),wB.isolate=new wB({deserialize:e=>{if(e&&"rtl"!=e&&"ltr"!=e&&"auto"!=e)throw new RangeError("Invalid value for isolate: "+e);return e||"auto"}}),wB.contextHash=new wB({perNode:!0}),wB.lookAhead=new wB({perNode:!0}),wB.mounted=new wB({perNode:!0});class CB{constructor(e,t,n){this.tree=e,this.overlay=t,this.parser=n}static get(e){return e&&e.props&&e.props[wB.mounted.id]}}const xB=Object.create(null);class kB{constructor(e,t,n,r=0){this.name=e,this.props=t,this.id=n,this.flags=r}static define(e){let t=e.props&&e.props.length?Object.create(null):xB,n=(e.top?1:0)|(e.skipped?2:0)|(e.error?4:0)|(null==e.name?8:0),r=new kB(e.name||"",t,e.id,n);if(e.props)for(let n of e.props)if(Array.isArray(n)||(n=n(r)),n){if(n[0].perNode)throw new RangeError("Can't store a per-node prop on a node type");t[n[0].id]=n[1]}return r}prop(e){return this.props[e.id]}get isTop(){return(1&this.flags)>0}get isSkipped(){return(2&this.flags)>0}get isError(){return(4&this.flags)>0}get isAnonymous(){return(8&this.flags)>0}is(e){if("string"==typeof e){if(this.name==e)return!0;let t=this.prop(wB.group);return!!t&&t.indexOf(e)>-1}return this.id==e}static match(e){let t=Object.create(null);for(let n in e)for(let r of n.split(" "))t[r]=e[n];return e=>{for(let n=e.prop(wB.group),r=-1;r<(n?n.length:0);r++){let i=t[r<0?e.name:n[r]];if(i)return i}}}}kB.none=new kB("",Object.create(null),0,8);class SB{constructor(e){this.types=e;for(let t=0;t<e.length;t++)if(e[t].id!=t)throw new RangeError("Node type ids should correspond to array positions when creating a node set")}extend(...e){let t=[];for(let n of this.types){let r=null;for(let t of e){let e=t(n);e&&(r||(r=Object.assign({},n.props)),r[e[0].id]=e[1])}t.push(r?new kB(n.name,r,n.id,n.flags):n)}return new SB(t)}}const OB=new WeakMap,BB=new WeakMap;var _B;!function(e){e[e.ExcludeBuffers=1]="ExcludeBuffers",e[e.IncludeAnonymous=2]="IncludeAnonymous",e[e.IgnoreMounts=4]="IgnoreMounts",e[e.IgnoreOverlays=8]="IgnoreOverlays"}(_B||(_B={}));class TB{constructor(e,t,n,r,i){if(this.type=e,this.children=t,this.positions=n,this.length=r,this.props=null,i&&i.length){this.props=Object.create(null);for(let[e,t]of i)this.props["number"==typeof e?e:e.id]=t}}toString(){let e=CB.get(this);if(e&&!e.overlay)return e.tree.toString();let t="";for(let e of this.children){let n=e.toString();n&&(t&&(t+=","),t+=n)}return this.type.name?(/\W/.test(this.type.name)&&!this.type.isError?JSON.stringify(this.type.name):this.type.name)+(t.length?"("+t+")":""):t}cursor(e=0){return new $B(this.topNode,e)}cursorAt(e,t=0,n=0){let r=OB.get(this)||this.topNode,i=new $B(r);return i.moveTo(e,t),OB.set(this,i._tree),i}get topNode(){return new IB(this,0,0,null)}resolve(e,t=0){let n=PB(OB.get(this)||this.topNode,e,t,!1);return OB.set(this,n),n}resolveInner(e,t=0){let n=PB(BB.get(this)||this.topNode,e,t,!0);return BB.set(this,n),n}resolveStack(e,t=0){return function(e,t,n){let r=e.resolveInner(t,n),i=null;for(let e=r instanceof IB?r:r.context.parent;e;e=e.parent)if(e.index<0){let o=e.parent;(i||(i=[r])).push(o.resolve(t,n)),e=o}else{let o=CB.get(e.tree);if(o&&o.overlay&&o.overlay[0].from<=t&&o.overlay[o.overlay.length-1].to>=t){let s=new IB(o.tree,o.overlay[0].from+e.from,-1,e);(i||(i=[r])).push(PB(s,t,n,!1))}}return i?VB(i):r}(this,e,t)}iterate(e){let{enter:t,leave:n,from:r=0,to:i=this.length}=e,o=e.mode||0,s=(o&_B.IncludeAnonymous)>0;for(let e=this.cursor(o|_B.IncludeAnonymous);;){let o=!1;if(e.from<=i&&e.to>=r&&(!s&&e.type.isAnonymous||!1!==t(e))){if(e.firstChild())continue;o=!0}for(;o&&n&&(s||!e.type.isAnonymous)&&n(e),!e.nextSibling();){if(!e.parent())return;o=!0}}}prop(e){return e.perNode?this.props?this.props[e.id]:void 0:this.type.prop(e)}get propValues(){let e=[];if(this.props)for(let t in this.props)e.push([+t,this.props[t]]);return e}balance(e={}){return this.children.length<=8?this:WB(kB.none,this.children,this.positions,0,this.children.length,0,this.length,(e,t,n)=>new TB(this.type,e,t,n,this.propValues),e.makeTree||((e,t,n)=>new TB(kB.none,e,t,n)))}static build(e){return function(e){var t;let{buffer:n,nodeSet:r,maxBufferLength:i=bB,reused:o=[],minRepeatType:s=r.types.length}=e,a=Array.isArray(n)?new EB(n,n.length):n,l=r.types,c=0,h=0;function d(e,t,n,b,A,y){let{id:w,start:C,end:x,size:k}=a,S=h,O=c;for(;k<0;){if(a.next(),-1==k){let t=o[w];return n.push(t),void b.push(C-e)}if(-3==k)return void(c=w);if(-4==k)return void(h=w);throw new RangeError(`Unrecognized record size: ${k}`)}let B,_,T=l[w],E=C-e;if(x-C<=i&&(_=m(a.pos-t,A))){let t=new Uint16Array(_.size-_.skip),n=a.pos-_.size,i=t.length;for(;a.pos>n;)i=v(_.start,t,i);B=new MB(t,x-_.start,r),E=_.start-e}else{let e=a.pos-k;a.next();let t=[],n=[],r=w>=s?w:-1,o=0,l=x;for(;a.pos>e;)r>=0&&a.id==r&&a.size>=0?(a.end<=l-i&&(f(t,n,C,o,a.end,l,r,S,O),o=t.length,l=a.end),a.next()):y>2500?u(C,e,t,n):d(C,e,t,n,r,y+1);if(r>=0&&o>0&&o<t.length&&f(t,n,C,o,C,l,r,S,O),t.reverse(),n.reverse(),r>-1&&o>0){let e=p(T,O);B=WB(T,t,n,0,t.length,0,x-C,e,e)}else B=g(T,t,n,x-C,S-x,O)}n.push(B),b.push(E)}function u(e,t,n,o){let s=[],l=0,c=-1;for(;a.pos>t;){let{id:e,start:t,end:n,size:r}=a;if(r>4)a.next();else{if(c>-1&&t<c)break;c<0&&(c=n-i),s.push(e,t,n),l++,a.next()}}if(l){let t=new Uint16Array(4*l),i=s[s.length-2];for(let e=s.length-3,n=0;e>=0;e-=3)t[n++]=s[e],t[n++]=s[e+1]-i,t[n++]=s[e+2]-i,t[n++]=n;n.push(new MB(t,s[2]-i,r)),o.push(i-e)}}function p(e,t){return(n,r,i)=>{let o,s,a=0,l=n.length-1;if(l>=0&&(o=n[l])instanceof TB){if(!l&&o.type==e&&o.length==i)return o;(s=o.prop(wB.lookAhead))&&(a=r[l]+o.length+s)}return g(e,n,r,i,a,t)}}function f(e,t,n,i,o,s,a,l,c){let h=[],d=[];for(;e.length>i;)h.push(e.pop()),d.push(t.pop()+n-o);e.push(g(r.types[a],h,d,s-o,l-s,c)),t.push(o-n)}function g(e,t,n,r,i,o,s){if(o){let e=[wB.contextHash,o];s=s?[e].concat(s):[e]}if(i>25){let e=[wB.lookAhead,i];s=s?[e].concat(s):[e]}return new TB(e,t,n,r,s)}function m(e,t){let n=a.fork(),r=0,o=0,l=0,c=n.end-i,h={size:0,start:0,skip:0};e:for(let i=n.pos-e;n.pos>i;){let e=n.size;if(n.id==t&&e>=0){h.size=r,h.start=o,h.skip=l,l+=4,r+=4,n.next();continue}let a=n.pos-e;if(e<0||a<i||n.start<c)break;let d=n.id>=s?4:0,u=n.start;for(n.next();n.pos>a;){if(n.size<0){if(-3!=n.size)break e;d+=4}else n.id>=s&&(d+=4);n.next()}o=u,r+=e,l+=d}return(t<0||r==e)&&(h.size=r,h.start=o,h.skip=l),h.size>4?h:void 0}function v(e,t,n){let{id:r,start:i,end:o,size:l}=a;if(a.next(),l>=0&&r<s){let s=n;if(l>4){let r=a.pos-(l-4);for(;a.pos>r;)n=v(e,t,n)}t[--n]=s,t[--n]=o-e,t[--n]=i-e,t[--n]=r}else-3==l?c=r:-4==l&&(h=r);return n}let b=[],A=[];for(;a.pos>0;)d(e.start||0,e.bufferStart||0,b,A,-1,0);let y=null!==(t=e.length)&&void 0!==t?t:b.length?A[0]+b[0].length:0;return new TB(l[e.topID],b.reverse(),A.reverse(),y)}(e)}}TB.empty=new TB(kB.none,[],[],0);class EB{constructor(e,t){this.buffer=e,this.index=t}get id(){return this.buffer[this.index-4]}get start(){return this.buffer[this.index-3]}get end(){return this.buffer[this.index-2]}get size(){return this.buffer[this.index-1]}get pos(){return this.index}next(){this.index-=4}fork(){return new EB(this.buffer,this.index)}}class MB{constructor(e,t,n){this.buffer=e,this.length=t,this.set=n}get type(){return kB.none}toString(){let e=[];for(let t=0;t<this.buffer.length;)e.push(this.childString(t)),t=this.buffer[t+3];return e.join(",")}childString(e){let t=this.buffer[e],n=this.buffer[e+3],r=this.set.types[t],i=r.name;if(/\W/.test(i)&&!r.isError&&(i=JSON.stringify(i)),n==(e+=4))return i;let o=[];for(;e<n;)o.push(this.childString(e)),e=this.buffer[e+3];return i+"("+o.join(",")+")"}findChild(e,t,n,r,i){let{buffer:o}=this,s=-1;for(let a=e;a!=t&&!(DB(i,r,o[a+1],o[a+2])&&(s=a,n>0));a=o[a+3]);return s}slice(e,t,n){let r=this.buffer,i=new Uint16Array(t-e),o=0;for(let s=e,a=0;s<t;){i[a++]=r[s++],i[a++]=r[s++]-n;let t=i[a++]=r[s++]-n;i[a++]=r[s++]-e,o=Math.max(o,t)}return new MB(i,o,this.set)}}function DB(e,t,n,r){switch(e){case-2:return n<t;case-1:return r>=t&&n<t;case 0:return n<t&&r>t;case 1:return n<=t&&r>t;case 2:return r>t;case 4:return!0}}function PB(e,t,n,r){for(var i;e.from==e.to||(n<1?e.from>=t:e.from>t)||(n>-1?e.to<=t:e.to<t);){let t=!r&&e instanceof IB&&e.index<0?null:e.parent;if(!t)return e;e=t}let o=r?0:_B.IgnoreOverlays;if(r)for(let r=e,s=r.parent;s;r=s,s=r.parent)r instanceof IB&&r.index<0&&(null===(i=s.enter(t,n,o))||void 0===i?void 0:i.from)!=r.from&&(e=s);for(;;){let r=e.enter(t,n,o);if(!r)return e;e=r}}class RB{cursor(e=0){return new $B(this,e)}getChild(e,t=null,n=null){let r=LB(this,e,t,n);return r.length?r[0]:null}getChildren(e,t=null,n=null){return LB(this,e,t,n)}resolve(e,t=0){return PB(this,e,t,!1)}resolveInner(e,t=0){return PB(this,e,t,!0)}matchContext(e){return NB(this.parent,e)}enterUnfinishedNodesBefore(e){let t=this.childBefore(e),n=this;for(;t;){let e=t.lastChild;if(!e||e.to!=t.to)break;e.type.isError&&e.from==e.to?(n=t,t=e.prevSibling):t=e}return n}get node(){return this}get next(){return this.parent}}class IB extends RB{constructor(e,t,n,r){super(),this._tree=e,this.from=t,this.index=n,this._parent=r}get type(){return this._tree.type}get name(){return this._tree.type.name}get to(){return this.from+this._tree.length}nextChild(e,t,n,r,i=0){for(let o=this;;){for(let{children:s,positions:a}=o._tree,l=t>0?s.length:-1;e!=l;e+=t){let l=s[e],c=a[e]+o.from;if(DB(r,n,c,c+l.length))if(l instanceof MB){if(i&_B.ExcludeBuffers)continue;let s=l.findChild(0,l.buffer.length,t,n-c,r);if(s>-1)return new QB(new FB(o,l,e,c),null,s)}else if(i&_B.IncludeAnonymous||!l.type.isAnonymous||HB(l)){let s;if(!(i&_B.IgnoreMounts)&&(s=CB.get(l))&&!s.overlay)return new IB(s.tree,c,e,o);let a=new IB(l,c,e,o);return i&_B.IncludeAnonymous||!a.type.isAnonymous?a:a.nextChild(t<0?l.children.length-1:0,t,n,r)}}if(i&_B.IncludeAnonymous||!o.type.isAnonymous)return null;if(e=o.index>=0?o.index+t:t<0?-1:o._parent._tree.children.length,o=o._parent,!o)return null}}get firstChild(){return this.nextChild(0,1,0,4)}get lastChild(){return this.nextChild(this._tree.children.length-1,-1,0,4)}childAfter(e){return this.nextChild(0,1,e,2)}childBefore(e){return this.nextChild(this._tree.children.length-1,-1,e,-2)}enter(e,t,n=0){let r;if(!(n&_B.IgnoreOverlays)&&(r=CB.get(this._tree))&&r.overlay){let n=e-this.from;for(let{from:e,to:i}of r.overlay)if((t>0?e<=n:e<n)&&(t<0?i>=n:i>n))return new IB(r.tree,r.overlay[0].from+this.from,-1,this)}return this.nextChild(0,1,e,t,n)}nextSignificantParent(){let e=this;for(;e.type.isAnonymous&&e._parent;)e=e._parent;return e}get parent(){return this._parent?this._parent.nextSignificantParent():null}get nextSibling(){return this._parent&&this.index>=0?this._parent.nextChild(this.index+1,1,0,4):null}get prevSibling(){return this._parent&&this.index>=0?this._parent.nextChild(this.index-1,-1,0,4):null}get tree(){return this._tree}toTree(){return this._tree}toString(){return this._tree.toString()}}function LB(e,t,n,r){let i=e.cursor(),o=[];if(!i.firstChild())return o;if(null!=n)for(let e=!1;!e;)if(e=i.type.is(n),!i.nextSibling())return o;for(;;){if(null!=r&&i.type.is(r))return o;if(i.type.is(t)&&o.push(i.node),!i.nextSibling())return null==r?o:[]}}function NB(e,t,n=t.length-1){for(let r=e;n>=0;r=r.parent){if(!r)return!1;if(!r.type.isAnonymous){if(t[n]&&t[n]!=r.name)return!1;n--}}return!0}class FB{constructor(e,t,n,r){this.parent=e,this.buffer=t,this.index=n,this.start=r}}class QB extends RB{get name(){return this.type.name}get from(){return this.context.start+this.context.buffer.buffer[this.index+1]}get to(){return this.context.start+this.context.buffer.buffer[this.index+2]}constructor(e,t,n){super(),this.context=e,this._parent=t,this.index=n,this.type=e.buffer.set.types[e.buffer.buffer[n]]}child(e,t,n){let{buffer:r}=this.context,i=r.findChild(this.index+4,r.buffer[this.index+3],e,t-this.context.start,n);return i<0?null:new QB(this.context,this,i)}get firstChild(){return this.child(1,0,4)}get lastChild(){return this.child(-1,0,4)}childAfter(e){return this.child(1,e,2)}childBefore(e){return this.child(-1,e,-2)}enter(e,t,n=0){if(n&_B.ExcludeBuffers)return null;let{buffer:r}=this.context,i=r.findChild(this.index+4,r.buffer[this.index+3],t>0?1:-1,e-this.context.start,t);return i<0?null:new QB(this.context,this,i)}get parent(){return this._parent||this.context.parent.nextSignificantParent()}externalSibling(e){return this._parent?null:this.context.parent.nextChild(this.context.index+e,e,0,4)}get nextSibling(){let{buffer:e}=this.context,t=e.buffer[this.index+3];return t<(this._parent?e.buffer[this._parent.index+3]:e.buffer.length)?new QB(this.context,this._parent,t):this.externalSibling(1)}get prevSibling(){let{buffer:e}=this.context,t=this._parent?this._parent.index+4:0;return this.index==t?this.externalSibling(-1):new QB(this.context,this._parent,e.findChild(t,this.index,-1,0,4))}get tree(){return null}toTree(){let e=[],t=[],{buffer:n}=this.context,r=this.index+4,i=n.buffer[this.index+3];if(i>r){let o=n.buffer[this.index+1];e.push(n.slice(r,i,o)),t.push(0)}return new TB(this.type,e,t,this.to-this.from)}toString(){return this.context.buffer.childString(this.index)}}function VB(e){if(!e.length)return null;let t=0,n=e[0];for(let r=1;r<e.length;r++){let i=e[r];(i.from>n.from||i.to<n.to)&&(n=i,t=r)}let r=n instanceof IB&&n.index<0?null:n.parent,i=e.slice();return r?i[t]=r:i.splice(t,1),new zB(i,n)}class zB{constructor(e,t){this.heads=e,this.node=t}get next(){return VB(this.heads)}}class $B{get name(){return this.type.name}constructor(e,t=0){if(this.mode=t,this.buffer=null,this.stack=[],this.index=0,this.bufferNode=null,e instanceof IB)this.yieldNode(e);else{this._tree=e.context.parent,this.buffer=e.context;for(let t=e._parent;t;t=t._parent)this.stack.unshift(t.index);this.bufferNode=e,this.yieldBuf(e.index)}}yieldNode(e){return!!e&&(this._tree=e,this.type=e.type,this.from=e.from,this.to=e.to,!0)}yieldBuf(e,t){this.index=e;let{start:n,buffer:r}=this.buffer;return this.type=t||r.set.types[r.buffer[e]],this.from=n+r.buffer[e+1],this.to=n+r.buffer[e+2],!0}yield(e){return!!e&&(e instanceof IB?(this.buffer=null,this.yieldNode(e)):(this.buffer=e.context,this.yieldBuf(e.index,e.type)))}toString(){return this.buffer?this.buffer.buffer.childString(this.index):this._tree.toString()}enterChild(e,t,n){if(!this.buffer)return this.yield(this._tree.nextChild(e<0?this._tree._tree.children.length-1:0,e,t,n,this.mode));let{buffer:r}=this.buffer,i=r.findChild(this.index+4,r.buffer[this.index+3],e,t-this.buffer.start,n);return!(i<0)&&(this.stack.push(this.index),this.yieldBuf(i))}firstChild(){return this.enterChild(1,0,4)}lastChild(){return this.enterChild(-1,0,4)}childAfter(e){return this.enterChild(1,e,2)}childBefore(e){return this.enterChild(-1,e,-2)}enter(e,t,n=this.mode){return this.buffer?!(n&_B.ExcludeBuffers)&&this.enterChild(1,e,t):this.yield(this._tree.enter(e,t,n))}parent(){if(!this.buffer)return this.yieldNode(this.mode&_B.IncludeAnonymous?this._tree._parent:this._tree.parent);if(this.stack.length)return this.yieldBuf(this.stack.pop());let e=this.mode&_B.IncludeAnonymous?this.buffer.parent:this.buffer.parent.nextSignificantParent();return this.buffer=null,this.yieldNode(e)}sibling(e){if(!this.buffer)return!!this._tree._parent&&this.yield(this._tree.index<0?null:this._tree._parent.nextChild(this._tree.index+e,e,0,4,this.mode));let{buffer:t}=this.buffer,n=this.stack.length-1;if(e<0){let e=n<0?0:this.stack[n]+4;if(this.index!=e)return this.yieldBuf(t.findChild(e,this.index,-1,0,4))}else{let e=t.buffer[this.index+3];if(e<(n<0?t.buffer.length:t.buffer[this.stack[n]+3]))return this.yieldBuf(e)}return n<0&&this.yield(this.buffer.parent.nextChild(this.buffer.index+e,e,0,4,this.mode))}nextSibling(){return this.sibling(1)}prevSibling(){return this.sibling(-1)}atLastNode(e){let t,n,{buffer:r}=this;if(r){if(e>0){if(this.index<r.buffer.buffer.length)return!1}else for(let e=0;e<this.index;e++)if(r.buffer.buffer[e+3]<this.index)return!1;({index:t,parent:n}=r)}else({index:t,_parent:n}=this._tree);for(;n;({index:t,_parent:n}=n))if(t>-1)for(let r=t+e,i=e<0?-1:n._tree.children.length;r!=i;r+=e){let e=n._tree.children[r];if(this.mode&_B.IncludeAnonymous||e instanceof MB||!e.type.isAnonymous||HB(e))return!1}return!0}move(e,t){if(t&&this.enterChild(e,0,4))return!0;for(;;){if(this.sibling(e))return!0;if(this.atLastNode(e)||!this.parent())return!1}}next(e=!0){return this.move(1,e)}prev(e=!0){return this.move(-1,e)}moveTo(e,t=0){for(;(this.from==this.to||(t<1?this.from>=e:this.from>e)||(t>-1?this.to<=e:this.to<e))&&this.parent(););for(;this.enterChild(1,e,t););return this}get node(){if(!this.buffer)return this._tree;let e=this.bufferNode,t=null,n=0;if(e&&e.context==this.buffer)e:for(let r=this.index,i=this.stack.length;i>=0;){for(let o=e;o;o=o._parent)if(o.index==r){if(r==this.index)return o;t=o,n=i+1;break e}r=this.stack[--i]}for(let e=n;e<this.stack.length;e++)t=new QB(this.buffer,t,this.stack[e]);return this.bufferNode=new QB(this.buffer,t,this.index)}get tree(){return this.buffer?null:this._tree._tree}iterate(e,t){for(let n=0;;){let r=!1;if(this.type.isAnonymous||!1!==e(this)){if(this.firstChild()){n++;continue}this.type.isAnonymous||(r=!0)}for(;;){if(r&&t&&t(this),r=this.type.isAnonymous,!n)return;if(this.nextSibling())break;this.parent(),n--,r=!0}}}matchContext(e){if(!this.buffer)return NB(this.node.parent,e);let{buffer:t}=this.buffer,{types:n}=t.set;for(let r=e.length-1,i=this.stack.length-1;r>=0;i--){if(i<0)return NB(this._tree,e,r);let o=n[t.buffer[this.stack[i]]];if(!o.isAnonymous){if(e[r]&&e[r]!=o.name)return!1;r--}}return!0}}function HB(e){return e.children.some(e=>e instanceof MB||!e.type.isAnonymous||HB(e))}const jB=new WeakMap;function qB(e,t){if(!e.isAnonymous||t instanceof MB||t.type!=e)return 1;let n=jB.get(t);if(null==n){n=1;for(let r of t.children){if(r.type!=e||!(r instanceof TB)){n=1;break}n+=qB(e,r)}jB.set(t,n)}return n}function WB(e,t,n,r,i,o,s,a,l){let c=0;for(let n=r;n<i;n++)c+=qB(e,t[n]);let h=Math.ceil(1.5*c/8),d=[],u=[];return function t(n,r,i,s,a){for(let c=i;c<s;){let i=c,p=r[c],f=qB(e,n[c]);for(c++;c<s;c++){let t=qB(e,n[c]);if(f+t>=h)break;f+=t}if(c==i+1){if(f>h){let e=n[i];t(e.children,e.positions,0,e.children.length,r[i]+a);continue}d.push(n[i])}else{let t=r[c-1]+n[c-1].length-p;d.push(WB(e,n,r,i,c,p,t,null,l))}u.push(p+a-o)}}(t,n,r,i,0),(a||l)(d,u,s)}class UB{constructor(){this.map=new WeakMap}setBuffer(e,t,n){let r=this.map.get(e);r||this.map.set(e,r=new Map),r.set(t,n)}getBuffer(e,t){let n=this.map.get(e);return n&&n.get(t)}set(e,t){e instanceof QB?this.setBuffer(e.context.buffer,e.index,t):e instanceof IB&&this.map.set(e.tree,t)}get(e){return e instanceof QB?this.getBuffer(e.context.buffer,e.index):e instanceof IB?this.map.get(e.tree):void 0}cursorSet(e,t){e.buffer?this.setBuffer(e.buffer.buffer,e.index,t):this.map.set(e.tree,t)}cursorGet(e){return e.buffer?this.getBuffer(e.buffer.buffer,e.index):this.map.get(e.tree)}}class YB{constructor(e,t,n,r,i=!1,o=!1){this.from=e,this.to=t,this.tree=n,this.offset=r,this.open=(i?1:0)|(o?2:0)}get openStart(){return(1&this.open)>0}get openEnd(){return(2&this.open)>0}static addTree(e,t=[],n=!1){let r=[new YB(0,e.length,e,0,!1,n)];for(let n of t)n.to>e.length&&r.push(n);return r}static applyChanges(e,t,n=128){if(!t.length)return e;let r=[],i=1,o=e.length?e[0]:null;for(let s=0,a=0,l=0;;s++){let c=s<t.length?t[s]:null,h=c?c.fromA:1e9;if(h-a>=n)for(;o&&o.from<h;){let t=o;if(a>=t.from||h<=t.to||l){let e=Math.max(t.from,a)-l,n=Math.min(t.to,h)-l;t=e>=n?null:new YB(e,n,t.tree,t.offset+l,s>0,!!c)}if(t&&r.push(t),o.to>h)break;o=i<e.length?e[i++]:null}if(!c)break;a=c.toA,l=c.toA-c.toB}return r}}class GB{startParse(e,t,n){return"string"==typeof e&&(e=new XB(e)),n=n?n.length?n.map(e=>new yB(e.from,e.to)):[new yB(0,0)]:[new yB(0,e.length)],this.createParse(e,t||[],n)}parse(e,t,n){let r=this.startParse(e,t,n);for(;;){let e=r.advance();if(e)return e}}}class XB{constructor(e){this.string=e}get length(){return this.string.length}chunk(e){return this.string.slice(e)}get lineChunks(){return!1}read(e,t){return this.string.slice(e,t)}}new wB({perNode:!0});let JB=0;class KB{constructor(e,t,n,r){this.name=e,this.set=t,this.base=n,this.modified=r,this.id=JB++}toString(){let{name:e}=this;for(let t of this.modified)t.name&&(e=`${t.name}(${e})`);return e}static define(e,t){let n="string"==typeof e?e:"?";if(e instanceof KB&&(t=e),null==t?void 0:t.base)throw new Error("Can not derive from a modified tag");let r=new KB(n,[],null,[]);if(r.set.push(r),t)for(let e of t.set)r.set.push(e);return r}static defineModifier(e){let t=new e_(e);return e=>e.modified.indexOf(t)>-1?e:e_.get(e.base||e,e.modified.concat(t).sort((e,t)=>e.id-t.id))}}let ZB=0;class e_{constructor(e){this.name=e,this.instances=[],this.id=ZB++}static get(e,t){if(!t.length)return e;let n=t[0].instances.find(n=>n.base==e&&function(e,t){return e.length==t.length&&e.every((e,n)=>e==t[n])}(t,n.modified));if(n)return n;let r=[],i=new KB(e.name,r,e,t);for(let e of t)e.instances.push(i);let o=function(e){let t=[[]];for(let n=0;n<e.length;n++)for(let r=0,i=t.length;r<i;r++)t.push(t[r].concat(e[n]));return t.sort((e,t)=>t.length-e.length)}(t);for(let t of e.set)if(!t.modified.length)for(let e of o)r.push(e_.get(t,e));return i}}function t_(e){let t=Object.create(null);for(let n in e){let r=e[n];Array.isArray(r)||(r=[r]);for(let e of n.split(" "))if(e){let n=[],i=2,o=e;for(let t=0;;){if("..."==o&&t>0&&t+3==e.length){i=1;break}let r=/^"(?:[^"\\]|\\.)*?"|[^\/!]+/.exec(o);if(!r)throw new RangeError("Invalid path: "+e);if(n.push("*"==r[0]?"":'"'==r[0][0]?JSON.parse(r[0]):r[0]),t+=r[0].length,t==e.length)break;let s=e[t++];if(t==e.length&&"!"==s){i=0;break}if("/"!=s)throw new RangeError("Invalid path: "+e);o=e.slice(t)}let s=n.length-1,a=n[s];if(!a)throw new RangeError("Invalid path: "+e);let l=new r_(r,i,s>0?n.slice(0,s):null);t[a]=l.sort(t[a])}}return n_.add(t)}const n_=new wB;class r_{constructor(e,t,n,r){this.tags=e,this.mode=t,this.context=n,this.next=r}get opaque(){return 0==this.mode}get inherit(){return 1==this.mode}sort(e){return!e||e.depth<this.depth?(this.next=e,this):(e.next=this.sort(e.next),e)}get depth(){return this.context?this.context.length:0}}function i_(e,t){let n=Object.create(null);for(let t of e)if(Array.isArray(t.tag))for(let e of t.tag)n[e.id]=t.class;else n[t.tag.id]=t.class;let{scope:r,all:i=null}=t||{};return{style:e=>{let t=i;for(let r of e)for(let e of r.set){let r=n[e.id];if(r){t=t?t+" "+r:r;break}}return t},scope:r}}function o_(e,t,n,r=0,i=e.length){let o=new s_(r,Array.isArray(t)?t:[t],n);o.highlightRange(e.cursor(),r,i,"",o.highlighters),o.flush(i)}r_.empty=new r_([],2,null);class s_{constructor(e,t,n){this.at=e,this.highlighters=t,this.span=n,this.class=""}startSpan(e,t){t!=this.class&&(this.flush(e),e>this.at&&(this.at=e),this.class=t)}flush(e){e>this.at&&this.class&&this.span(this.at,e,this.class)}highlightRange(e,t,n,r,i){let{type:o,from:s,to:a}=e;if(s>=n||a<=t)return;o.isTop&&(i=this.highlighters.filter(e=>!e.scope||e.scope(o)));let l=r,c=function(e){let t=e.type.prop(n_);for(;t&&t.context&&!e.matchContext(t.context);)t=t.next;return t||null}(e)||r_.empty,h=function(e,t){let n=null;for(let r of e){let e=r.style(t);e&&(n=n?n+" "+e:e)}return n}(i,c.tags);if(h&&(l&&(l+=" "),l+=h,1==c.mode&&(r+=(r?" ":"")+h)),this.startSpan(Math.max(t,s),l),c.opaque)return;let d=e.tree&&e.tree.prop(wB.mounted);if(d&&d.overlay){let o=e.node.enter(d.overlay[0].from+s,1),c=this.highlighters.filter(e=>!e.scope||e.scope(d.tree.type)),h=e.firstChild();for(let u=0,p=s;;u++){let f=u<d.overlay.length?d.overlay[u]:null,g=f?f.from+s:a,m=Math.max(t,p),v=Math.min(n,g);if(m<v&&h)for(;e.from<v&&(this.highlightRange(e,m,v,r,i),this.startSpan(Math.min(v,e.to),l),!(e.to>=g)&&e.nextSibling()););if(!f||g>n)break;p=f.to+s,p>t&&(this.highlightRange(o.cursor(),Math.max(t,f.from+s),Math.min(n,p),"",c),this.startSpan(Math.min(n,p),l))}h&&e.parent()}else if(e.firstChild()){d&&(r="");do{if(!(e.to<=t)){if(e.from>=n)break;this.highlightRange(e,t,n,r,i),this.startSpan(Math.min(n,e.to),l)}}while(e.nextSibling());e.parent()}}}const a_=KB.define,l_=a_(),c_=a_(),h_=a_(c_),d_=a_(c_),u_=a_(),p_=a_(u_),f_=a_(u_),g_=a_(),m_=a_(g_),v_=a_(),b_=a_(),A_=a_(),y_=a_(A_),w_=a_(),C_={comment:l_,lineComment:a_(l_),blockComment:a_(l_),docComment:a_(l_),name:c_,variableName:a_(c_),typeName:h_,tagName:a_(h_),propertyName:d_,attributeName:a_(d_),className:a_(c_),labelName:a_(c_),namespace:a_(c_),macroName:a_(c_),literal:u_,string:p_,docString:a_(p_),character:a_(p_),attributeValue:a_(p_),number:f_,integer:a_(f_),float:a_(f_),bool:a_(u_),regexp:a_(u_),escape:a_(u_),color:a_(u_),url:a_(u_),keyword:v_,self:a_(v_),null:a_(v_),atom:a_(v_),unit:a_(v_),modifier:a_(v_),operatorKeyword:a_(v_),controlKeyword:a_(v_),definitionKeyword:a_(v_),moduleKeyword:a_(v_),operator:b_,derefOperator:a_(b_),arithmeticOperator:a_(b_),logicOperator:a_(b_),bitwiseOperator:a_(b_),compareOperator:a_(b_),updateOperator:a_(b_),definitionOperator:a_(b_),typeOperator:a_(b_),controlOperator:a_(b_),punctuation:A_,separator:a_(A_),bracket:y_,angleBracket:a_(y_),squareBracket:a_(y_),paren:a_(y_),brace:a_(y_),content:g_,heading:m_,heading1:a_(m_),heading2:a_(m_),heading3:a_(m_),heading4:a_(m_),heading5:a_(m_),heading6:a_(m_),contentSeparator:a_(g_),list:a_(g_),quote:a_(g_),emphasis:a_(g_),strong:a_(g_),link:a_(g_),monospace:a_(g_),strikethrough:a_(g_),inserted:a_(),deleted:a_(),changed:a_(),invalid:a_(),meta:w_,documentMeta:a_(w_),annotation:a_(w_),processingInstruction:a_(w_),definition:KB.defineModifier("definition"),constant:KB.defineModifier("constant"),function:KB.defineModifier("function"),standard:KB.defineModifier("standard"),local:KB.defineModifier("local"),special:KB.defineModifier("special")};for(let e in C_){let t=C_[e];t instanceof KB&&(t.name=e)}i_([{tag:C_.link,class:"tok-link"},{tag:C_.heading,class:"tok-heading"},{tag:C_.emphasis,class:"tok-emphasis"},{tag:C_.strong,class:"tok-strong"},{tag:C_.keyword,class:"tok-keyword"},{tag:C_.atom,class:"tok-atom"},{tag:C_.bool,class:"tok-bool"},{tag:C_.url,class:"tok-url"},{tag:C_.labelName,class:"tok-labelName"},{tag:C_.inserted,class:"tok-inserted"},{tag:C_.deleted,class:"tok-deleted"},{tag:C_.literal,class:"tok-literal"},{tag:C_.string,class:"tok-string"},{tag:C_.number,class:"tok-number"},{tag:[C_.regexp,C_.escape,C_.special(C_.string)],class:"tok-string2"},{tag:C_.variableName,class:"tok-variableName"},{tag:C_.local(C_.variableName),class:"tok-variableName tok-local"},{tag:C_.definition(C_.variableName),class:"tok-variableName tok-definition"},{tag:C_.special(C_.variableName),class:"tok-variableName2"},{tag:C_.definition(C_.propertyName),class:"tok-propertyName tok-definition"},{tag:C_.typeName,class:"tok-typeName"},{tag:C_.namespace,class:"tok-namespace"},{tag:C_.className,class:"tok-className"},{tag:C_.macroName,class:"tok-macroName"},{tag:C_.propertyName,class:"tok-propertyName"},{tag:C_.operator,class:"tok-operator"},{tag:C_.comment,class:"tok-comment"},{tag:C_.meta,class:"tok-meta"},{tag:C_.invalid,class:"tok-invalid"},{tag:C_.punctuation,class:"tok-punctuation"}]);var x_;const k_=new wB;function S_(e){return iy.define({combine:e?t=>t.concat(e):void 0})}const O_=new wB;class B_{constructor(e,t,n=[],r=""){this.data=e,this.name=r,Wy.prototype.hasOwnProperty("tree")||Object.defineProperty(Wy.prototype,"tree",{get(){return E_(this)}}),this.parser=t,this.extension=[Q_.of(this),Wy.languageData.of((e,t,n)=>{let r=__(e,t,n),i=r.type.prop(k_);if(!i)return[];let o=e.facet(i),s=r.type.prop(O_);if(s){let i=r.resolve(t-r.from,n);for(let t of s)if(t.test(i,e)){let n=e.facet(t.facet);return"replace"==t.type?n:n.concat(o)}}return o})].concat(n)}isActiveAt(e,t,n=-1){return __(e,t,n).type.prop(k_)==this.data}findRegions(e){let t=e.facet(Q_);if((null==t?void 0:t.data)==this.data)return[{from:0,to:e.doc.length}];if(!t||!t.allowsNesting)return[];let n=[],r=(e,t)=>{if(e.prop(k_)==this.data)return void n.push({from:t,to:t+e.length});let i=e.prop(wB.mounted);if(i){if(i.tree.prop(k_)==this.data){if(i.overlay)for(let e of i.overlay)n.push({from:e.from+t,to:e.to+t});else n.push({from:t,to:t+e.length});return}if(i.overlay){let e=n.length;if(r(i.tree,i.overlay[0].from+t),n.length>e)return}}for(let n=0;n<e.children.length;n++){let i=e.children[n];i instanceof TB&&r(i,e.positions[n]+t)}};return r(E_(e),0),n}get allowsNesting(){return!0}}function __(e,t,n){let r=e.facet(Q_),i=E_(e).topNode;if(!r||r.allowsNesting)for(let e=i;e;e=e.enter(t,n,_B.ExcludeBuffers))e.type.isTop&&(i=e);return i}B_.setState=Ry.define();class T_ extends B_{constructor(e,t,n){super(e,t,[],n),this.parser=t}static define(e){let t=S_(e.languageData);return new T_(t,e.parser.configure({props:[k_.add(e=>e.isTop?t:void 0)]}),e.name)}configure(e,t){return new T_(this.data,this.parser.configure(e),t||this.name)}get allowsNesting(){return this.parser.hasWrappers()}}function E_(e){let t=e.field(B_.state,!1);return t?t.tree:TB.empty}class M_{constructor(e){this.doc=e,this.cursorPos=0,this.string="",this.cursor=e.iter()}get length(){return this.doc.length}syncTo(e){return this.string=this.cursor.next(e-this.cursorPos).value,this.cursorPos=e+this.string.length,this.cursorPos-this.string.length}chunk(e){return this.syncTo(e),this.string}get lineChunks(){return!0}read(e,t){let n=this.cursorPos-this.string.length;return e<n||t>=this.cursorPos?this.doc.sliceString(e,t):this.string.slice(e-n,t-n)}}let D_=null;class P_{constructor(e,t,n=[],r,i,o,s,a){this.parser=e,this.state=t,this.fragments=n,this.tree=r,this.treeLen=i,this.viewport=o,this.skipped=s,this.scheduleOn=a,this.parse=null,this.tempSkipped=[]}static create(e,t,n){return new P_(e,t,[],TB.empty,0,n,[],null)}startParse(){return this.parser.startParse(new M_(this.state.doc),this.fragments)}work(e,t){return null!=t&&t>=this.state.doc.length&&(t=void 0),this.tree!=TB.empty&&this.isDone(null!=t?t:this.state.doc.length)?(this.takeTree(),!0):this.withContext(()=>{var n;if("number"==typeof e){let t=Date.now()+e;e=()=>Date.now()>t}for(this.parse||(this.parse=this.startParse()),null!=t&&(null==this.parse.stoppedAt||this.parse.stoppedAt>t)&&t<this.state.doc.length&&this.parse.stopAt(t);;){let r=this.parse.advance();if(r){if(this.fragments=this.withoutTempSkipped(YB.addTree(r,this.fragments,null!=this.parse.stoppedAt)),this.treeLen=null!==(n=this.parse.stoppedAt)&&void 0!==n?n:this.state.doc.length,this.tree=r,this.parse=null,!(this.treeLen<(null!=t?t:this.state.doc.length)))return!0;this.parse=this.startParse()}if(e())return!1}})}takeTree(){let e,t;this.parse&&(e=this.parse.parsedPos)>=this.treeLen&&((null==this.parse.stoppedAt||this.parse.stoppedAt>e)&&this.parse.stopAt(e),this.withContext(()=>{for(;!(t=this.parse.advance()););}),this.treeLen=e,this.tree=t,this.fragments=this.withoutTempSkipped(YB.addTree(this.tree,this.fragments,!0)),this.parse=null)}withContext(e){let t=D_;D_=this;try{return e()}finally{D_=t}}withoutTempSkipped(e){for(let t;t=this.tempSkipped.pop();)e=R_(e,t.from,t.to);return e}changes(e,t){let{fragments:n,tree:r,treeLen:i,viewport:o,skipped:s}=this;if(this.takeTree(),!e.empty){let t=[];if(e.iterChangedRanges((e,n,r,i)=>t.push({fromA:e,toA:n,fromB:r,toB:i})),n=YB.applyChanges(n,t),r=TB.empty,i=0,o={from:e.mapPos(o.from,-1),to:e.mapPos(o.to,1)},this.skipped.length){s=[];for(let t of this.skipped){let n=e.mapPos(t.from,1),r=e.mapPos(t.to,-1);n<r&&s.push({from:n,to:r})}}}return new P_(this.parser,t,n,r,i,o,s,this.scheduleOn)}updateViewport(e){if(this.viewport.from==e.from&&this.viewport.to==e.to)return!1;this.viewport=e;let t=this.skipped.length;for(let t=0;t<this.skipped.length;t++){let{from:n,to:r}=this.skipped[t];n<e.to&&r>e.from&&(this.fragments=R_(this.fragments,n,r),this.skipped.splice(t--,1))}return!(this.skipped.length>=t)&&(this.reset(),!0)}reset(){this.parse&&(this.takeTree(),this.parse=null)}skipUntilInView(e,t){this.skipped.push({from:e,to:t})}static getSkippingParser(e){return new class extends GB{createParse(t,n,r){let i=r[0].from,o=r[r.length-1].to,s={parsedPos:i,advance(){let t=D_;if(t){for(let e of r)t.tempSkipped.push(e);e&&(t.scheduleOn=t.scheduleOn?Promise.all([t.scheduleOn,e]):e)}return this.parsedPos=o,new TB(kB.none,[],[],o-i)},stoppedAt:null,stopAt(){}};return s}}}isDone(e){e=Math.min(e,this.state.doc.length);let t=this.fragments;return this.treeLen>=e&&t.length&&0==t[0].from&&t[0].to>=e}static get(){return D_}}function R_(e,t,n){return YB.applyChanges(e,[{fromA:t,toA:n,fromB:t,toB:n}])}class I_{constructor(e){this.context=e,this.tree=e.tree}apply(e){if(!e.docChanged&&this.tree==this.context.tree)return this;let t=this.context.changes(e.changes,e.state),n=this.context.treeLen==e.startState.doc.length?void 0:Math.max(e.changes.mapPos(this.context.treeLen),t.viewport.to);return t.work(20,n)||t.takeTree(),new I_(t)}static init(e){let t=Math.min(3e3,e.doc.length),n=P_.create(e.facet(Q_).parser,e,{from:0,to:t});return n.work(20,t)||n.takeTree(),new I_(n)}}B_.state=dy.define({create:I_.init,update(e,t){for(let e of t.effects)if(e.is(B_.setState))return e.value;return t.startState.facet(Q_)!=t.state.facet(Q_)?I_.init(t.state):e.apply(t)}});let L_=e=>{let t=setTimeout(()=>e(),500);return()=>clearTimeout(t)};"undefined"!=typeof requestIdleCallback&&(L_=e=>{let t=-1,n=setTimeout(()=>{t=requestIdleCallback(e,{timeout:400})},100);return()=>t<0?clearTimeout(n):cancelIdleCallback(t)});const N_="undefined"!=typeof navigator&&(null===(x_=navigator.scheduling)||void 0===x_?void 0:x_.isInputPending)?()=>navigator.scheduling.isInputPending():null,F_=xx.fromClass(class{constructor(e){this.view=e,this.working=null,this.workScheduled=0,this.chunkEnd=-1,this.chunkBudget=-1,this.work=this.work.bind(this),this.scheduleWork()}update(e){let t=this.view.state.field(B_.state).context;(t.updateViewport(e.view.viewport)||this.view.viewport.to>t.treeLen)&&this.scheduleWork(),(e.docChanged||e.selectionSet)&&(this.view.hasFocus&&(this.chunkBudget+=50),this.scheduleWork()),this.checkAsyncSchedule(t)}scheduleWork(){if(this.working)return;let{state:e}=this.view,t=e.field(B_.state);t.tree==t.context.tree&&t.context.isDone(e.doc.length)||(this.working=L_(this.work))}work(e){this.working=null;let t=Date.now();if(this.chunkEnd<t&&(this.chunkEnd<0||this.view.hasFocus)&&(this.chunkEnd=t+3e4,this.chunkBudget=3e3),this.chunkBudget<=0)return;let{state:n,viewport:{to:r}}=this.view,i=n.field(B_.state);if(i.tree==i.context.tree&&i.context.isDone(r+1e5))return;let o=Date.now()+Math.min(this.chunkBudget,100,e&&!N_?Math.max(25,e.timeRemaining()-5):1e9),s=i.context.treeLen<r&&n.doc.length>r+1e3,a=i.context.work(()=>N_&&N_()||Date.now()>o,r+(s?0:1e5));this.chunkBudget-=Date.now()-t,(a||this.chunkBudget<=0)&&(i.context.takeTree(),this.view.dispatch({effects:B_.setState.of(new I_(i.context))})),this.chunkBudget>0&&(!a||s)&&this.scheduleWork(),this.checkAsyncSchedule(i.context)}checkAsyncSchedule(e){e.scheduleOn&&(this.workScheduled++,e.scheduleOn.then(()=>this.scheduleWork()).catch(e=>Ax(this.view.state,e)).then(()=>this.workScheduled--),e.scheduleOn=null)}destroy(){this.working&&this.working()}isWorking(){return!!(this.working||this.workScheduled>0)}},{eventHandlers:{focus(){this.scheduleWork()}}}),Q_=iy.define({combine:e=>e.length?e[0]:null,enables:e=>[B_.state,F_,OS.contentAttributes.compute([e],t=>{let n=t.facet(e);return n&&n.name?{"data-language":n.name}:{}})]});class V_{constructor(e,t=[]){this.language=e,this.support=t,this.extension=[e,t]}}const z_=iy.define(),$_=iy.define({combine:e=>{if(!e.length)return"  ";let t=e[0];if(!t||/\S/.test(t)||Array.from(t).some(e=>e!=t[0]))throw new Error("Invalid indent unit: "+JSON.stringify(e[0]));return t}});function H_(e){let t=e.facet($_);return 9==t.charCodeAt(0)?e.tabSize*t.length:t.length}function j_(e,t){let n="",r=e.tabSize,i=e.facet($_)[0];if("\t"==i){for(;t>=r;)n+="\t",t-=r;i=" "}for(let e=0;e<t;e++)n+=i;return n}function q_(e,t){e instanceof Wy&&(e=new W_(e));for(let n of e.state.facet(z_)){let r=n(e,t);if(void 0!==r)return r}let n=E_(e.state);return n.length>=t?function(e,t,n){let r=t.resolveStack(n),i=t.resolveInner(n,-1).resolve(n,0).enterUnfinishedNodesBefore(n);if(i!=r.node){let e=[];for(let t=i;t&&!(t.from<r.node.from||t.to>r.node.to||t.from==r.node.from&&t.type==r.node.type);t=t.parent)e.push(t);for(let t=e.length-1;t>=0;t--)r={node:e[t],next:r}}return Y_(r,e,n)}(e,n,t):null}class W_{constructor(e,t={}){this.state=e,this.options=t,this.unit=H_(e)}lineAt(e,t=1){let n=this.state.doc.lineAt(e),{simulateBreak:r,simulateDoubleBreak:i}=this.options;return null!=r&&r>=n.from&&r<=n.to?i&&r==e?{text:"",from:e}:(t<0?r<e:r<=e)?{text:n.text.slice(r-n.from),from:r}:{text:n.text.slice(0,r-n.from),from:n.from}:n}textAfterPos(e,t=1){if(this.options.simulateDoubleBreak&&e==this.options.simulateBreak)return"";let{text:n,from:r}=this.lineAt(e,t);return n.slice(e-r,Math.min(n.length,e+100-r))}column(e,t=1){let{text:n,from:r}=this.lineAt(e,t),i=this.countColumn(n,e-r),o=this.options.overrideIndentation?this.options.overrideIndentation(r):-1;return o>-1&&(i+=o-this.countColumn(n,n.search(/\S|$/))),i}countColumn(e,t=e.length){return hw(e,this.state.tabSize,t)}lineIndent(e,t=1){let{text:n,from:r}=this.lineAt(e,t),i=this.options.overrideIndentation;if(i){let e=i(r);if(e>-1)return e}return this.countColumn(n,n.search(/\S|$/))}get simulatedBreak(){return this.options.simulateBreak||null}}const U_=new wB;function Y_(e,t,n){for(let r=e;r;r=r.next){let e=G_(r.node);if(e)return e(J_.create(t,n,r))}return 0}function G_(e){let t=e.type.prop(U_);if(t)return t;let n,r=e.firstChild;if(r&&(n=r.type.prop(wB.closedBy))){let t=e.lastChild,r=t&&n.indexOf(t.name)>-1;return e=>Z_(e,!0,1,void 0,r&&!function(e){return e.pos==e.options.simulateBreak&&e.options.simulateDoubleBreak}(e)?t.from:void 0)}return null==e.parent?X_:null}function X_(){return 0}class J_ extends W_{constructor(e,t,n){super(e.state,e.options),this.base=e,this.pos=t,this.context=n}get node(){return this.context.node}static create(e,t,n){return new J_(e,t,n)}get textAfter(){return this.textAfterPos(this.pos)}get baseIndent(){return this.baseIndentFor(this.node)}baseIndentFor(e){let t=this.state.doc.lineAt(e.from);for(;;){let n=e.resolve(t.from);for(;n.parent&&n.parent.from==n.from;)n=n.parent;if(K_(n,e))break;t=this.state.doc.lineAt(n.from)}return this.lineIndent(t.from)}continue(){return Y_(this.context.next,this.base,this.pos)}}function K_(e,t){for(let n=t;n;n=n.parent)if(e==n)return!0;return!1}function Z_(e,t,n,r,i){let o=e.textAfter,s=o.match(/^\s*/)[0].length,a=r&&o.slice(s,s+r.length)==r||i==e.pos+s,l=t?function(e){let t=e.node,n=t.childAfter(t.from),r=t.lastChild;if(!n)return null;let i=e.options.simulateBreak,o=e.state.doc.lineAt(n.from),s=null==i||i<=o.from?o.to:Math.min(o.to,i);for(let e=n.to;;){let i=t.childAfter(e);if(!i||i==r)return null;if(!i.type.isSkipped){if(i.from>=s)return null;let e=/^ */.exec(o.text.slice(n.to-o.from))[0].length;return{from:n.from,to:n.to+e}}e=i.to}}(e):null;return l?a?e.column(l.from):e.column(l.to):e.baseIndent+(a?0:e.unit*n)}function eT({except:e,units:t=1}={}){return n=>{let r=e&&e.test(n.textAfter);return n.baseIndent+(r?0:t*n.unit)}}const tT=iy.define(),nT=new wB;function rT(e){let t=e.lastChild;return t&&t.to==e.to&&t.type.isError}function iT(e,t,n){for(let r of e.facet(tT)){let i=r(e,t,n);if(i)return i}return function(e,t,n){let r=E_(e);if(r.length<n)return null;let i=null;for(let o=r.resolveStack(n,1);o;o=o.next){let s=o.node;if(s.to<=n||s.from>n)continue;if(i&&s.from<t)break;let a=s.type.prop(nT);if(a&&(s.to<r.length-50||r.length==e.doc.length||!rT(s))){let r=a(s,e);r&&r.from<=n&&r.from>=t&&r.to>n&&(i=r)}}return i}(e,t,n)}function oT(e,t){let n=t.mapPos(e.from,1),r=t.mapPos(e.to,-1);return n>=r?void 0:{from:n,to:r}}const sT=Ry.define({map:oT}),aT=Ry.define({map:oT});function lT(e){let t=[];for(let{head:n}of e.state.selection.ranges)t.some(e=>e.from<=n&&e.to>=n)||t.push(e.lineBlockAt(n));return t}const cT=dy.define({create:()=>OC.none,update(e,t){t.isUserEvent("delete")&&t.changes.iterChangedRanges((t,n)=>e=hT(e,t,n)),e=e.map(t.changes);for(let n of t.effects)if(n.is(sT)&&!uT(e,n.value.from,n.value.to)){let{preparePlaceholder:r}=t.state.facet(vT),i=r?OC.replace({widget:new wT(r(t.state,n.value))}):yT;e=e.update({add:[i.range(n.value.from,n.value.to)]})}else n.is(aT)&&(e=e.update({filter:(e,t)=>n.value.from!=e||n.value.to!=t,filterFrom:n.value.from,filterTo:n.value.to}));return t.selection&&(e=hT(e,t.selection.main.head)),e},provide:e=>OS.decorations.from(e),toJSON(e,t){let n=[];return e.between(0,t.doc.length,(e,t)=>{n.push(e,t)}),n},fromJSON(e){if(!Array.isArray(e)||e.length%2)throw new RangeError("Invalid JSON for fold state");let t=[];for(let n=0;n<e.length;){let r=e[n++],i=e[n++];if("number"!=typeof r||"number"!=typeof i)throw new RangeError("Invalid JSON for fold state");t.push(yT.range(r,i))}return OC.set(t,!0)}});function hT(e,t,n=t){let r=!1;return e.between(t,n,(e,i)=>{e<n&&i>t&&(r=!0)}),r?e.update({filterFrom:t,filterTo:n,filter:(e,r)=>e>=n||r<=t}):e}function dT(e,t,n){var r;let i=null;return null===(r=e.field(cT,!1))||void 0===r||r.between(t,n,(e,t)=>{(!i||i.from>e)&&(i={from:e,to:t})}),i}function uT(e,t,n){let r=!1;return e.between(t,t,(e,i)=>{e==t&&i==n&&(r=!0)}),r}function pT(e,t){return e.field(cT,!1)?t:t.concat(Ry.appendConfig.of(bT()))}function fT(e,t,n=!0){let r=e.state.doc.lineAt(t.from).number,i=e.state.doc.lineAt(t.to).number;return OS.announce.of(`${e.state.phrase(n?"Folded lines":"Unfolded lines")} ${r} ${e.state.phrase("to")} ${i}.`)}const gT=[{key:"Ctrl-Shift-[",mac:"Cmd-Alt-[",run:e=>{for(let t of lT(e)){let n=iT(e.state,t.from,t.to);if(n)return e.dispatch({effects:pT(e.state,[sT.of(n),fT(e,n)])}),!0}return!1}},{key:"Ctrl-Shift-]",mac:"Cmd-Alt-]",run:e=>{if(!e.state.field(cT,!1))return!1;let t=[];for(let n of lT(e)){let r=dT(e.state,n.from,n.to);r&&t.push(aT.of(r),fT(e,r,!1))}return t.length&&e.dispatch({effects:t}),t.length>0}},{key:"Ctrl-Alt-[",run:e=>{let{state:t}=e,n=[];for(let r=0;r<t.doc.length;){let i=e.lineBlockAt(r),o=iT(t,i.from,i.to);o&&n.push(sT.of(o)),r=(o?e.lineBlockAt(o.to):i).to+1}return n.length&&e.dispatch({effects:pT(e.state,n)}),!!n.length}},{key:"Ctrl-Alt-]",run:e=>{let t=e.state.field(cT,!1);if(!t||!t.size)return!1;let n=[];return t.between(0,e.state.doc.length,(e,t)=>{n.push(aT.of({from:e,to:t}))}),e.dispatch({effects:n}),!0}}],mT={placeholderDOM:null,preparePlaceholder:null,placeholderText:"…"},vT=iy.define({combine:e=>Uy(e,mT)});function bT(e){let t=[cT,ST];return e&&t.push(vT.of(e)),t}function AT(e,t){let{state:n}=e,r=n.facet(vT),i=t=>{let n=e.lineBlockAt(e.posAtDOM(t.target)),r=dT(e.state,n.from,n.to);r&&e.dispatch({effects:aT.of(r)}),t.preventDefault()};if(r.placeholderDOM)return r.placeholderDOM(e,i,t);let o=document.createElement("span");return o.textContent=r.placeholderText,o.setAttribute("aria-label",n.phrase("folded code")),o.title=n.phrase("unfold"),o.className="cm-foldPlaceholder",o.onclick=i,o}const yT=OC.replace({widget:new class extends kC{toDOM(e){return AT(e,null)}}});class wT extends kC{constructor(e){super(),this.value=e}eq(e){return this.value==e.value}toDOM(e){return AT(e,this.value)}}const CT={openText:"⌄",closedText:"›",markerDOM:null,domEventHandlers:{},foldingChanged:()=>!1};class xT extends YO{constructor(e,t){super(),this.config=e,this.open=t}eq(e){return this.config==e.config&&this.open==e.open}toDOM(e){if(this.config.markerDOM)return this.config.markerDOM(this.open);let t=document.createElement("span");return t.textContent=this.open?this.config.openText:this.config.closedText,t.title=e.state.phrase(this.open?"Fold line":"Unfold line"),t}}function kT(e={}){let t={...CT,...e},n=new xT(t,!0),r=new xT(t,!1),i=xx.fromClass(class{constructor(e){this.from=e.viewport.from,this.markers=this.buildMarkers(e)}update(e){(e.docChanged||e.viewportChanged||e.startState.facet(Q_)!=e.state.facet(Q_)||e.startState.field(cT,!1)!=e.state.field(cT,!1)||E_(e.startState)!=E_(e.state)||t.foldingChanged(e))&&(this.markers=this.buildMarkers(e.view))}buildMarkers(e){let t=new Zy;for(let i of e.viewportLineBlocks){let o=dT(e.state,i.from,i.to)?r:iT(e.state,i.from,i.to)?n:null;o&&t.add(i.from,i.from,o)}return t.finish()}}),{domEventHandlers:o}=t;return[i,ZO({class:"cm-foldGutter",markers(e){var t;return(null===(t=e.plugin(i))||void 0===t?void 0:t.markers)||Ky.empty},initialSpacer:()=>new xT(t,!1),domEventHandlers:{...o,click:(e,t,n)=>{if(o.click&&o.click(e,t,n))return!0;let r=dT(e.state,t.from,t.to);if(r)return e.dispatch({effects:aT.of(r)}),!0;let i=iT(e.state,t.from,t.to);return!!i&&(e.dispatch({effects:sT.of(i)}),!0)}}}),bT()]}const ST=OS.baseTheme({".cm-foldPlaceholder":{backgroundColor:"#eee",border:"1px solid #ddd",color:"#888",borderRadius:".2em",margin:"0 1px",padding:"0 1px",cursor:"pointer"},".cm-foldGutter span":{padding:"0 1px",cursor:"pointer"}});class OT{constructor(e,t){let n;function r(e){let t=gw.newName();return(n||(n=Object.create(null)))["."+t]=e,t}this.specs=e;const i="string"==typeof t.all?t.all:t.all?r(t.all):void 0,o=t.scope;this.scope=o instanceof B_?e=>e.prop(k_)==o.data:o?e=>e==o:void 0,this.style=i_(e.map(e=>({tag:e.tag,class:e.class||r(Object.assign({},e,{tag:null}))})),{all:i}).style,this.module=n?new gw(n):null,this.themeType=t.themeType}static define(e,t){return new OT(e,t||{})}}const BT=iy.define(),_T=iy.define({combine:e=>e.length?[e[0]]:null});function TT(e){let t=e.facet(BT);return t.length?t:e.facet(_T)}function ET(e,t){let n,r=[DT];return e instanceof OT&&(e.module&&r.push(OS.styleModule.of(e.module)),n=e.themeType),(null==t?void 0:t.fallback)?r.push(_T.of(e)):n?r.push(BT.computeN([OS.darkTheme],t=>t.facet(OS.darkTheme)==("dark"==n)?[e]:[])):r.push(BT.of(e)),r}class MT{constructor(e){this.markCache=Object.create(null),this.tree=E_(e.state),this.decorations=this.buildDeco(e,TT(e.state)),this.decoratedTo=e.viewport.to}update(e){let t=E_(e.state),n=TT(e.state),r=n!=TT(e.startState),{viewport:i}=e.view,o=e.changes.mapPos(this.decoratedTo,1);t.length<i.to&&!r&&t.type==this.tree.type&&o>=i.to?(this.decorations=this.decorations.map(e.changes),this.decoratedTo=o):(t!=this.tree||e.viewportChanged||r)&&(this.tree=t,this.decorations=this.buildDeco(e.view,n),this.decoratedTo=i.to)}buildDeco(e,t){if(!t||!this.tree.length)return OC.none;let n=new Zy;for(let{from:r,to:i}of e.visibleRanges)o_(this.tree,t,(e,t,r)=>{n.add(e,t,this.markCache[r]||(this.markCache[r]=OC.mark({class:r})))},r,i);return n.finish()}}const DT=vy.high(xx.fromClass(MT,{decorations:e=>e.decorations})),PT=OT.define([{tag:C_.meta,color:"#404740"},{tag:C_.link,textDecoration:"underline"},{tag:C_.heading,textDecoration:"underline",fontWeight:"bold"},{tag:C_.emphasis,fontStyle:"italic"},{tag:C_.strong,fontWeight:"bold"},{tag:C_.strikethrough,textDecoration:"line-through"},{tag:C_.keyword,color:"#708"},{tag:[C_.atom,C_.bool,C_.url,C_.contentSeparator,C_.labelName],color:"#219"},{tag:[C_.literal,C_.inserted],color:"#164"},{tag:[C_.string,C_.deleted],color:"#a11"},{tag:[C_.regexp,C_.escape,C_.special(C_.string)],color:"#e40"},{tag:C_.definition(C_.variableName),color:"#00f"},{tag:C_.local(C_.variableName),color:"#30a"},{tag:[C_.typeName,C_.namespace],color:"#085"},{tag:C_.className,color:"#167"},{tag:[C_.special(C_.variableName),C_.macroName],color:"#256"},{tag:C_.definition(C_.propertyName),color:"#00c"},{tag:C_.comment,color:"#940"},{tag:C_.invalid,color:"#f00"}]),RT=OS.baseTheme({"&.cm-focused .cm-matchingBracket":{backgroundColor:"#328c8252"},"&.cm-focused .cm-nonmatchingBracket":{backgroundColor:"#bb555544"}}),IT="()[]{}",LT=iy.define({combine:e=>Uy(e,{afterCursor:!0,brackets:IT,maxScanDistance:1e4,renderMatch:QT})}),NT=OC.mark({class:"cm-matchingBracket"}),FT=OC.mark({class:"cm-nonmatchingBracket"});function QT(e){let t=[],n=e.matched?NT:FT;return t.push(n.range(e.start.from,e.start.to)),e.end&&t.push(n.range(e.end.from,e.end.to)),t}const VT=dy.define({create:()=>OC.none,update(e,t){if(!t.docChanged&&!t.selection)return e;let n=[],r=t.state.facet(LT);for(let e of t.state.selection.ranges){if(!e.empty)continue;let i=WT(t.state,e.head,-1,r)||e.head>0&&WT(t.state,e.head-1,1,r)||r.afterCursor&&(WT(t.state,e.head,1,r)||e.head<t.state.doc.length&&WT(t.state,e.head+1,-1,r));i&&(n=n.concat(r.renderMatch(i,t.state)))}return OC.set(n,!0)},provide:e=>OS.decorations.from(e)}),zT=[VT,RT];function $T(e={}){return[LT.of(e),zT]}const HT=new wB;function jT(e,t,n){let r=e.prop(t<0?wB.openedBy:wB.closedBy);if(r)return r;if(1==e.name.length){let r=n.indexOf(e.name);if(r>-1&&r%2==(t<0?1:0))return[n[r+t]]}return null}function qT(e){let t=e.type.prop(HT);return t?t(e.node):e}function WT(e,t,n,r={}){let i=r.maxScanDistance||1e4,o=r.brackets||IT,s=E_(e),a=s.resolveInner(t,n);for(let r=a;r;r=r.parent){let i=jT(r.type,n,o);if(i&&r.from<r.to){let s=qT(r);if(s&&(n>0?t>=s.from&&t<s.to:t>s.from&&t<=s.to))return UT(e,t,n,r,s,i,o)}}return function(e,t,n,r,i,o,s){let a=n<0?e.sliceDoc(t-1,t):e.sliceDoc(t,t+1),l=s.indexOf(a);if(l<0||l%2==0!=n>0)return null;let c={from:n<0?t-1:t,to:n>0?t+1:t},h=e.doc.iterRange(t,n>0?e.doc.length:0),d=0;for(let e=0;!h.next().done&&e<=o;){let o=h.value;n<0&&(e+=o.length);let a=t+e*n;for(let e=n>0?0:o.length-1,t=n>0?o.length:-1;e!=t;e+=n){let t=s.indexOf(o[e]);if(!(t<0||r.resolveInner(a+e,1).type!=i))if(t%2==0==n>0)d++;else{if(1==d)return{start:c,end:{from:a+e,to:a+e+1},matched:t>>1==l>>1};d--}}n>0&&(e+=o.length)}return h.done?{start:c,matched:!1}:null}(e,t,n,s,a.type,i,o)}function UT(e,t,n,r,i,o,s){let a=r.parent,l={from:i.from,to:i.to},c=0,h=null==a?void 0:a.cursor();if(h&&(n<0?h.childBefore(r.from):h.childAfter(r.to)))do{if(n<0?h.to<=r.from:h.from>=r.to){if(0==c&&o.indexOf(h.type.name)>-1&&h.from<h.to){let e=qT(h);return{start:l,end:e?{from:e.from,to:e.to}:void 0,matched:!0}}if(jT(h.type,n,s))c++;else if(jT(h.type,-n,s)){if(0==c){let e=qT(h);return{start:l,end:e&&e.from<e.to?{from:e.from,to:e.to}:void 0,matched:!1}}c--}}}while(n<0?h.prevSibling():h.nextSibling());return{start:l,matched:!1}}const YT=Object.create(null),GT=[kB.none],XT=[],JT=Object.create(null),KT=Object.create(null);for(let[e,t]of[["variable","variableName"],["variable-2","variableName.special"],["string-2","string.special"],["def","variableName.definition"],["tag","tagName"],["attribute","attributeName"],["type","typeName"],["builtin","variableName.standard"],["qualifier","modifier"],["error","invalid"],["header","heading"],["property","propertyName"]])KT[e]=eE(YT,t);function ZT(e,t){XT.indexOf(e)>-1||(XT.push(e),console.warn(t))}function eE(e,t){let n=[];for(let r of t.split(" ")){let t=[];for(let n of r.split(".")){let r=e[n]||C_[n];r?"function"==typeof r?t.length?t=t.map(r):ZT(n,`Modifier ${n} used at start of tag`):t.length?ZT(n,`Tag ${n} used as modifier`):t=Array.isArray(r)?r:[r]:ZT(n,`Unknown highlighting tag ${n}`)}for(let e of t)n.push(e)}if(!n.length)return 0;let r=t.replace(/ /g,"_"),i=r+" "+n.map(e=>e.id),o=JT[i];if(o)return o.id;let s=JT[i]=kB.define({id:GT.length,name:r,props:[t_({[r]:n})]});return GT.push(s),s.id}FC.RTL,FC.LTR;function tE(e,t){return({state:n,dispatch:r})=>{if(n.readOnly)return!1;let i=e(t,n);return!!i&&(r(n.update(i)),!0)}}const nE=tE(lE,0),rE=tE(aE,0),iE=tE((e,t)=>aE(e,t,function(e){let t=[];for(let n of e.selection.ranges){let r=e.doc.lineAt(n.from),i=n.to<=r.to?r:e.doc.lineAt(n.to);i.from>r.from&&i.from==n.to&&(i=n.to==r.to+1?r:e.doc.lineAt(n.to-1));let o=t.length-1;o>=0&&t[o].to>r.from?t[o].to=i.to:t.push({from:r.from+/^\s*/.exec(r.text)[0].length,to:i.to})}return t}(t)),0);function oE(e,t){let n=e.languageDataAt("commentTokens",t,1);return n.length?n[0]:{}}const sE=50;function aE(e,t,n=t.selection.ranges){let r=n.map(e=>oE(t,e.from).block);if(!r.every(e=>e))return null;let i=n.map((e,n)=>function(e,{open:t,close:n},r,i){let o,s,a=e.sliceDoc(r-sE,r),l=e.sliceDoc(i,i+sE),c=/\s*$/.exec(a)[0].length,h=/^\s*/.exec(l)[0].length,d=a.length-c;if(a.slice(d-t.length,d)==t&&l.slice(h,h+n.length)==n)return{open:{pos:r-c,margin:c&&1},close:{pos:i+h,margin:h&&1}};i-r<=2*sE?o=s=e.sliceDoc(r,i):(o=e.sliceDoc(r,r+sE),s=e.sliceDoc(i-sE,i));let u=/^\s*/.exec(o)[0].length,p=/\s*$/.exec(s)[0].length,f=s.length-p-n.length;return o.slice(u,u+t.length)==t&&s.slice(f,f+n.length)==n?{open:{pos:r+u+t.length,margin:/\s/.test(o.charAt(u+t.length))?1:0},close:{pos:i-p-n.length,margin:/\s/.test(s.charAt(f-1))?1:0}}:null}(t,r[n],e.from,e.to));if(2!=e&&!i.every(e=>e))return{changes:t.changes(n.map((e,t)=>i[t]?[]:[{from:e.from,insert:r[t].open+" "},{from:e.to,insert:" "+r[t].close}]))};if(1!=e&&i.some(e=>e)){let e=[];for(let t,n=0;n<i.length;n++)if(t=i[n]){let i=r[n],{open:o,close:s}=t;e.push({from:o.pos-i.open.length,to:o.pos+o.margin},{from:s.pos-s.margin,to:s.pos+i.close.length})}return{changes:e}}return null}function lE(e,t,n=t.selection.ranges){let r=[],i=-1;for(let{from:e,to:o}of n){let n=r.length,s=1e9,a=oE(t,e).line;if(a){for(let n=e;n<=o;){let l=t.doc.lineAt(n);if(l.from>i&&(e==o||o>l.from)){i=l.from;let e=/^\s*/.exec(l.text)[0].length,t=e==l.length,n=l.text.slice(e,e+a.length)==a?e:-1;e<l.text.length&&e<s&&(s=e),r.push({line:l,comment:n,token:a,indent:e,empty:t,single:!1})}n=l.to+1}if(s<1e9)for(let e=n;e<r.length;e++)r[e].indent<r[e].line.text.length&&(r[e].indent=s);r.length==n+1&&(r[n].single=!0)}}if(2!=e&&r.some(e=>e.comment<0&&(!e.empty||e.single))){let e=[];for(let{line:t,token:n,indent:i,empty:o,single:s}of r)!s&&o||e.push({from:t.from+i,insert:n+" "});let n=t.changes(e);return{changes:n,selection:t.selection.map(n,1)}}if(1!=e&&r.some(e=>e.comment>=0)){let e=[];for(let{line:t,comment:n,token:i}of r)if(n>=0){let r=t.from+n,o=r+i.length;" "==t.text[o-t.from]&&o++,e.push({from:r,to:o})}return{changes:e}}return null}const cE=My.define(),hE=My.define(),dE=iy.define(),uE=iy.define({combine:e=>Uy(e,{minDepth:100,newGroupDelay:500,joinToEvent:(e,t)=>t},{minDepth:Math.max,newGroupDelay:Math.min,joinToEvent:(e,t)=>(n,r)=>e(n,r)||t(n,r)})}),pE=dy.define({create:()=>EE.empty,update(e,t){let n=t.state.facet(uE),r=t.annotation(cE);if(r){let i=yE.fromTransaction(t,r.selection),o=r.side,s=0==o?e.undone:e.done;return s=i?wE(s,s.length,n.minDepth,i):SE(s,t.startState.selection),new EE(0==o?r.rest:s,0==o?s:r.rest)}let i=t.annotation(hE);if("full"!=i&&"before"!=i||(e=e.isolate()),!1===t.annotation(Iy.addToHistory))return t.changes.empty?e:e.addMapping(t.changes.desc);let o=yE.fromTransaction(t),s=t.annotation(Iy.time),a=t.annotation(Iy.userEvent);return o?e=e.addChanges(o,s,a,n,t):t.selection&&(e=e.addSelection(t.startState.selection,s,a,n.newGroupDelay)),"full"!=i&&"after"!=i||(e=e.isolate()),e},toJSON:e=>({done:e.done.map(e=>e.toJSON()),undone:e.undone.map(e=>e.toJSON())}),fromJSON:e=>new EE(e.done.map(yE.fromJSON),e.undone.map(yE.fromJSON))});function fE(e={}){return[pE,uE.of(e),OS.domEventHandlers({beforeinput(e,t){let n="historyUndo"==e.inputType?mE:"historyRedo"==e.inputType?vE:null;return!!n&&(e.preventDefault(),n(t))}})]}function gE(e,t){return function({state:n,dispatch:r}){if(!t&&n.readOnly)return!1;let i=n.field(pE,!1);if(!i)return!1;let o=i.pop(e,n,t);return!!o&&(r(o),!0)}}const mE=gE(0,!1),vE=gE(1,!1),bE=gE(0,!0),AE=gE(1,!0);class yE{constructor(e,t,n,r,i){this.changes=e,this.effects=t,this.mapped=n,this.startSelection=r,this.selectionsAfter=i}setSelAfter(e){return new yE(this.changes,this.effects,this.mapped,this.startSelection,e)}toJSON(){var e,t,n;return{changes:null===(e=this.changes)||void 0===e?void 0:e.toJSON(),mapped:null===(t=this.mapped)||void 0===t?void 0:t.toJSON(),startSelection:null===(n=this.startSelection)||void 0===n?void 0:n.toJSON(),selectionsAfter:this.selectionsAfter.map(e=>e.toJSON())}}static fromJSON(e){return new yE(e.changes&&UA.fromJSON(e.changes),[],e.mapped&&WA.fromJSON(e.mapped),e.startSelection&&ty.fromJSON(e.startSelection),e.selectionsAfter.map(ty.fromJSON))}static fromTransaction(e,t){let n=xE;for(let t of e.startState.facet(dE)){let r=t(e);r.length&&(n=n.concat(r))}return!n.length&&e.changes.empty?null:new yE(e.changes.invert(e.startState.doc),n,void 0,t||e.startState.selection,xE)}static selection(e){return new yE(void 0,xE,void 0,void 0,e)}}function wE(e,t,n,r){let i=t+1>n+20?t-n-1:0,o=e.slice(i,t);return o.push(r),o}function CE(e,t){return e.length?t.length?e.concat(t):e:t}const xE=[],kE=200;function SE(e,t){if(e.length){let n=e[e.length-1],r=n.selectionsAfter.slice(Math.max(0,n.selectionsAfter.length-kE));return r.length&&r[r.length-1].eq(t)?e:(r.push(t),wE(e,e.length-1,1e9,n.setSelAfter(r)))}return[yE.selection([t])]}function OE(e){let t=e[e.length-1],n=e.slice();return n[e.length-1]=t.setSelAfter(t.selectionsAfter.slice(0,t.selectionsAfter.length-1)),n}function BE(e,t){if(!e.length)return e;let n=e.length,r=xE;for(;n;){let i=_E(e[n-1],t,r);if(i.changes&&!i.changes.empty||i.effects.length){let t=e.slice(0,n);return t[n-1]=i,t}t=i.mapped,n--,r=i.selectionsAfter}return r.length?[yE.selection(r)]:xE}function _E(e,t,n){let r=CE(e.selectionsAfter.length?e.selectionsAfter.map(e=>e.map(t)):xE,n);if(!e.changes)return yE.selection(r);let i=e.changes.map(t),o=t.mapDesc(e.changes,!0),s=e.mapped?e.mapped.composeDesc(o):o;return new yE(i,Ry.mapEffects(e.effects,t),s,e.startSelection.map(o),r)}const TE=/^(input\.type|delete)($|\.)/;class EE{constructor(e,t,n=0,r=void 0){this.done=e,this.undone=t,this.prevTime=n,this.prevUserEvent=r}isolate(){return this.prevTime?new EE(this.done,this.undone):this}addChanges(e,t,n,r,i){let o=this.done,s=o[o.length-1];return o=s&&s.changes&&!s.changes.empty&&e.changes&&(!n||TE.test(n))&&(!s.selectionsAfter.length&&t-this.prevTime<r.newGroupDelay&&r.joinToEvent(i,function(e,t){let n=[],r=!1;return e.iterChangedRanges((e,t)=>n.push(e,t)),t.iterChangedRanges((e,t,i,o)=>{for(let e=0;e<n.length;){let t=n[e++],s=n[e++];o>=t&&i<=s&&(r=!0)}}),r}(s.changes,e.changes))||"input.type.compose"==n)?wE(o,o.length-1,r.minDepth,new yE(e.changes.compose(s.changes),CE(Ry.mapEffects(e.effects,s.changes),s.effects),s.mapped,s.startSelection,xE)):wE(o,o.length,r.minDepth,e),new EE(o,xE,t,n)}addSelection(e,t,n,r){let i=this.done.length?this.done[this.done.length-1].selectionsAfter:xE;return i.length>0&&t-this.prevTime<r&&n==this.prevUserEvent&&n&&/^select($|\.)/.test(n)&&function(e,t){return e.ranges.length==t.ranges.length&&0===e.ranges.filter((e,n)=>e.empty!=t.ranges[n].empty).length}(i[i.length-1],e)?this:new EE(SE(this.done,e),this.undone,t,n)}addMapping(e){return new EE(BE(this.done,e),BE(this.undone,e),this.prevTime,this.prevUserEvent)}pop(e,t,n){let r=0==e?this.done:this.undone;if(0==r.length)return null;let i=r[r.length-1],o=i.selectionsAfter[0]||t.selection;if(n&&i.selectionsAfter.length)return t.update({selection:i.selectionsAfter[i.selectionsAfter.length-1],annotations:cE.of({side:e,rest:OE(r),selection:o}),userEvent:0==e?"select.undo":"select.redo",scrollIntoView:!0});if(i.changes){let n=1==r.length?xE:r.slice(0,r.length-1);return i.mapped&&(n=BE(n,i.mapped)),t.update({changes:i.changes,selection:i.startSelection,effects:i.effects,annotations:cE.of({side:e,rest:n,selection:o}),filter:!1,userEvent:0==e?"undo":"redo",scrollIntoView:!0})}return null}}EE.empty=new EE(xE,xE);const ME=[{key:"Mod-z",run:mE,preventDefault:!0},{key:"Mod-y",mac:"Mod-Shift-z",run:vE,preventDefault:!0},{linux:"Ctrl-Shift-z",run:vE,preventDefault:!0},{key:"Mod-u",run:bE,preventDefault:!0},{key:"Alt-u",mac:"Mod-Shift-u",run:AE,preventDefault:!0}];function DE(e,t){return ty.create(e.ranges.map(t),e.mainIndex)}function PE(e,t){return e.update({selection:t,scrollIntoView:!0,userEvent:"select"})}function RE({state:e,dispatch:t},n){let r=DE(e.selection,n);return!r.eq(e.selection,!0)&&(t(PE(e,r)),!0)}function IE(e,t){return ty.cursor(t?e.to:e.from)}function LE(e,t){return RE(e,n=>n.empty?e.moveByChar(n,t):IE(n,t))}function NE(e){return e.textDirectionAt(e.state.selection.main.head)==FC.LTR}const FE=e=>LE(e,!NE(e)),QE=e=>LE(e,NE(e));function VE(e,t){return RE(e,n=>n.empty?e.moveByGroup(n,t):IE(n,t))}"undefined"!=typeof Intl&&Intl.Segmenter;function zE(e,t,n){if(t.type.prop(n))return!0;let r=t.to-t.from;return r&&(r>2||/[^\s,.;:]/.test(e.sliceDoc(t.from,t.to)))||t.firstChild}function $E(e,t,n){let r,i,o=E_(e).resolveInner(t.head),s=n?wB.closedBy:wB.openedBy;for(let r=t.head;;){let t=n?o.childAfter(r):o.childBefore(r);if(!t)break;zE(e,t,s)?o=t:r=n?t.to:t.from}return i=o.type.prop(s)&&(r=n?WT(e,o.from,1):WT(e,o.to,-1))&&r.matched?n?r.end.to:r.end.from:n?o.to:o.from,ty.cursor(i,n?-1:1)}function HE(e,t){return RE(e,n=>{if(!n.empty)return IE(n,t);let r=e.moveVertically(n,t);return r.head!=n.head?r:e.moveToLineBoundary(n,t)})}const jE=e=>HE(e,!1),qE=e=>HE(e,!0);function WE(e){let t,n=e.scrollDOM.clientHeight<e.scrollDOM.scrollHeight-2,r=0,i=0;if(n){for(let t of e.state.facet(OS.scrollMargins)){let n=t(e);(null==n?void 0:n.top)&&(r=Math.max(null==n?void 0:n.top,r)),(null==n?void 0:n.bottom)&&(i=Math.max(null==n?void 0:n.bottom,i))}t=e.scrollDOM.clientHeight-r-i}else t=(e.dom.ownerDocument.defaultView||window).innerHeight;return{marginTop:r,marginBottom:i,selfScroll:n,height:Math.max(e.defaultLineHeight,t-5)}}function UE(e,t){let n,r=WE(e),{state:i}=e,o=DE(i.selection,n=>n.empty?e.moveVertically(n,t,r.height):IE(n,t));if(o.eq(i.selection))return!1;if(r.selfScroll){let t=e.coordsAtPos(i.selection.main.head),s=e.scrollDOM.getBoundingClientRect(),a=s.top+r.marginTop,l=s.bottom-r.marginBottom;t&&t.top>a&&t.bottom<l&&(n=OS.scrollIntoView(o.main.head,{y:"start",yMargin:t.top-a}))}return e.dispatch(PE(i,o),{effects:n}),!0}const YE=e=>UE(e,!1),GE=e=>UE(e,!0);function XE(e,t,n){let r=e.lineBlockAt(t.head),i=e.moveToLineBoundary(t,n);if(i.head==t.head&&i.head!=(n?r.to:r.from)&&(i=e.moveToLineBoundary(t,n,!1)),!n&&i.head==r.from&&r.length){let n=/^\s*/.exec(e.state.sliceDoc(r.from,Math.min(r.from+100,r.to)))[0].length;n&&t.head!=r.from+n&&(i=ty.cursor(r.from+n))}return i}function JE(e,t,n){let r=!1,i=DE(e.selection,t=>{let i=WT(e,t.head,-1)||WT(e,t.head,1)||t.head>0&&WT(e,t.head-1,1)||t.head<e.doc.length&&WT(e,t.head+1,-1);if(!i||!i.end)return t;r=!0;let o=i.start.from==t.head?i.end.to:i.end.from;return n?ty.range(t.anchor,o):ty.cursor(o)});return!!r&&(t(PE(e,i)),!0)}function KE(e,t){let n=DE(e.state.selection,e=>{let n=t(e);return ty.range(e.anchor,n.head,n.goalColumn,n.bidiLevel||void 0)});return!n.eq(e.state.selection)&&(e.dispatch(PE(e.state,n)),!0)}function ZE(e,t){return KE(e,n=>e.moveByChar(n,t))}const eM=e=>ZE(e,!NE(e)),tM=e=>ZE(e,NE(e));function nM(e,t){return KE(e,n=>e.moveByGroup(n,t))}function rM(e,t){return KE(e,n=>e.moveVertically(n,t))}const iM=e=>rM(e,!1),oM=e=>rM(e,!0);function sM(e,t){return KE(e,n=>e.moveVertically(n,t,WE(e).height))}const aM=e=>sM(e,!1),lM=e=>sM(e,!0),cM=({state:e,dispatch:t})=>(t(PE(e,{anchor:0})),!0),hM=({state:e,dispatch:t})=>(t(PE(e,{anchor:e.doc.length})),!0),dM=({state:e,dispatch:t})=>(t(PE(e,{anchor:e.selection.main.anchor,head:0})),!0),uM=({state:e,dispatch:t})=>(t(PE(e,{anchor:e.selection.main.anchor,head:e.doc.length})),!0);function pM(e,t){let{state:n}=e,r=n.selection,i=n.selection.ranges.slice();for(let r of n.selection.ranges){let o=n.doc.lineAt(r.head);if(t?o.to<e.state.doc.length:o.from>0)for(let n=r;;){let r=e.moveVertically(n,t);if(r.head<o.from||r.head>o.to){i.some(e=>e.head==r.head)||i.push(r);break}if(r.head==n.head)break;n=r}}return i.length!=r.ranges.length&&(e.dispatch(PE(n,ty.create(i,i.length-1))),!0)}function fM(e,t){if(e.state.readOnly)return!1;let n="delete.selection",{state:r}=e,i=r.changeByRange(r=>{let{from:i,to:o}=r;if(i==o){let s=t(r);s<i?(n="delete.backward",s=gM(e,s,!1)):s>i&&(n="delete.forward",s=gM(e,s,!0)),i=Math.min(i,s),o=Math.max(o,s)}else i=gM(e,i,!1),o=gM(e,o,!0);return i==o?{range:r}:{changes:{from:i,to:o},range:ty.cursor(i,i<r.head?-1:1)}});return!i.changes.empty&&(e.dispatch(r.update(i,{scrollIntoView:!0,userEvent:n,effects:"delete.selection"==n?OS.announce.of(r.phrase("Selection deleted")):void 0})),!0)}function gM(e,t,n){if(e instanceof OS)for(let r of e.state.facet(OS.atomicRanges).map(t=>t(e)))r.between(t,t,(e,r)=>{e<t&&r>t&&(t=n?r:e)});return t}const mM=(e,t,n)=>fM(e,r=>{let i,o,s=r.from,{state:a}=e,l=a.doc.lineAt(s);if(n&&!t&&s>l.from&&s<l.from+200&&!/[^ \t]/.test(i=l.text.slice(0,s-l.from))){if("\t"==i[i.length-1])return s-1;let e=hw(i,a.tabSize)%H_(a)||H_(a);for(let t=0;t<e&&" "==i[i.length-1-t];t++)s--;o=s}else o=VA(l.text,s-l.from,t,t)+l.from,o==s&&l.number!=(t?a.doc.lines:1)?o+=t?1:-1:!t&&/[\ufe00-\ufe0f]/.test(l.text.slice(o-l.from,s-l.from))&&(o=VA(l.text,o-l.from,!1,!1)+l.from);return o}),vM=e=>mM(e,!1,!0),bM=e=>mM(e,!0,!1),AM=(e,t)=>fM(e,n=>{let r=n.head,{state:i}=e,o=i.doc.lineAt(r),s=i.charCategorizer(r);for(let e=null;;){if(r==(t?o.to:o.from)){r==n.head&&o.number!=(t?i.doc.lines:1)&&(r+=t?1:-1);break}let a=VA(o.text,r-o.from,t)+o.from,l=o.text.slice(Math.min(r,a)-o.from,Math.max(r,a)-o.from),c=s(l);if(null!=e&&c!=e)break;" "==l&&r==n.head||(e=c),r=a}return r}),yM=e=>AM(e,!1);function wM(e){let t=[],n=-1;for(let r of e.selection.ranges){let i=e.doc.lineAt(r.from),o=e.doc.lineAt(r.to);if(r.empty||r.to!=o.from||(o=e.doc.lineAt(r.to-1)),n>=i.number){let e=t[t.length-1];e.to=o.to,e.ranges.push(r)}else t.push({from:i.from,to:o.to,ranges:[r]});n=o.number+1}return t}function CM(e,t,n){if(e.readOnly)return!1;let r=[],i=[];for(let t of wM(e)){if(n?t.to==e.doc.length:0==t.from)continue;let o=e.doc.lineAt(n?t.to+1:t.from-1),s=o.length+1;if(n){r.push({from:t.to,to:o.to},{from:t.from,insert:o.text+e.lineBreak});for(let n of t.ranges)i.push(ty.range(Math.min(e.doc.length,n.anchor+s),Math.min(e.doc.length,n.head+s)))}else{r.push({from:o.from,to:t.from},{from:t.to,insert:e.lineBreak+o.text});for(let e of t.ranges)i.push(ty.range(e.anchor-s,e.head-s))}}return!!r.length&&(t(e.update({changes:r,scrollIntoView:!0,selection:ty.create(i,e.selection.mainIndex),userEvent:"move.line"})),!0)}function xM(e,t,n){if(e.readOnly)return!1;let r=[];for(let t of wM(e))n?r.push({from:t.from,insert:e.doc.slice(t.from,t.to)+e.lineBreak}):r.push({from:t.to,insert:e.lineBreak+e.doc.slice(t.from,t.to)});return t(e.update({changes:r,scrollIntoView:!0,userEvent:"input.copyline"})),!0}const kM=OM(!1),SM=OM(!0);function OM(e){return({state:t,dispatch:n})=>{if(t.readOnly)return!1;let r=t.changeByRange(n=>{let{from:r,to:i}=n,o=t.doc.lineAt(r),s=!e&&r==i&&function(e,t){if(/\(\)|\[\]|\{\}/.test(e.sliceDoc(t-1,t+1)))return{from:t,to:t};let n,r=E_(e).resolveInner(t),i=r.childBefore(t),o=r.childAfter(t);return i&&o&&i.to<=t&&o.from>=t&&(n=i.type.prop(wB.closedBy))&&n.indexOf(o.name)>-1&&e.doc.lineAt(i.to).from==e.doc.lineAt(o.from).from&&!/\S/.test(e.sliceDoc(i.to,o.from))?{from:i.to,to:o.from}:null}(t,r);e&&(r=i=(i<=o.to?o:t.doc.lineAt(i)).to);let a=new W_(t,{simulateBreak:r,simulateDoubleBreak:!!s}),l=q_(a,r);for(null==l&&(l=hw(/^\s*/.exec(t.doc.lineAt(r).text)[0],t.tabSize));i<o.to&&/\s/.test(o.text[i-o.from]);)i++;s?({from:r,to:i}=s):r>o.from&&r<o.from+100&&!/\S/.test(o.text.slice(0,r))&&(r=o.from);let c=["",j_(t,l)];return s&&c.push(j_(t,a.lineIndent(o.from,-1))),{changes:{from:r,to:i,insert:EA.of(c)},range:ty.cursor(r+1+c[1].length)}});return n(t.update(r,{scrollIntoView:!0,userEvent:"input"})),!0}}function BM(e,t){let n=-1;return e.changeByRange(r=>{let i=[];for(let o=r.from;o<=r.to;){let s=e.doc.lineAt(o);s.number>n&&(r.empty||r.to>s.from)&&(t(s,i,r),n=s.number),o=s.to+1}let o=e.changes(i);return{changes:i,range:ty.range(o.mapPos(r.anchor,1),o.mapPos(r.head,1))}})}const _M=({state:e,dispatch:t})=>!e.readOnly&&(t(e.update(BM(e,(t,n)=>{n.push({from:t.from,insert:e.facet($_)})}),{userEvent:"input.indent"})),!0),TM=({state:e,dispatch:t})=>!e.readOnly&&(t(e.update(BM(e,(t,n)=>{let r=/^\s*/.exec(t.text)[0];if(!r)return;let i=hw(r,e.tabSize),o=0,s=j_(e,Math.max(0,i-H_(e)));for(;o<r.length&&o<s.length&&r.charCodeAt(o)==s.charCodeAt(o);)o++;n.push({from:t.from+o,to:t.from+r.length,insert:s.slice(o)})}),{userEvent:"delete.dedent"})),!0),EM=[{key:"Ctrl-b",run:FE,shift:eM,preventDefault:!0},{key:"Ctrl-f",run:QE,shift:tM},{key:"Ctrl-p",run:jE,shift:iM},{key:"Ctrl-n",run:qE,shift:oM},{key:"Ctrl-a",run:e=>RE(e,t=>ty.cursor(e.lineBlockAt(t.head).from,1)),shift:e=>KE(e,t=>ty.cursor(e.lineBlockAt(t.head).from))},{key:"Ctrl-e",run:e=>RE(e,t=>ty.cursor(e.lineBlockAt(t.head).to,-1)),shift:e=>KE(e,t=>ty.cursor(e.lineBlockAt(t.head).to))},{key:"Ctrl-d",run:bM},{key:"Ctrl-h",run:vM},{key:"Ctrl-k",run:e=>fM(e,t=>{let n=e.lineBlockAt(t.head).to;return t.head<n?n:Math.min(e.state.doc.length,t.head+1)})},{key:"Ctrl-Alt-h",run:yM},{key:"Ctrl-o",run:({state:e,dispatch:t})=>{if(e.readOnly)return!1;let n=e.changeByRange(e=>({changes:{from:e.from,to:e.to,insert:EA.of(["",""])},range:ty.cursor(e.from)}));return t(e.update(n,{scrollIntoView:!0,userEvent:"input"})),!0}},{key:"Ctrl-t",run:({state:e,dispatch:t})=>{if(e.readOnly)return!1;let n=e.changeByRange(t=>{if(!t.empty||0==t.from||t.from==e.doc.length)return{range:t};let n=t.from,r=e.doc.lineAt(n),i=n==r.from?n-1:VA(r.text,n-r.from,!1)+r.from,o=n==r.to?n+1:VA(r.text,n-r.from,!0)+r.from;return{changes:{from:i,to:o,insert:e.doc.slice(n,o).append(e.doc.slice(i,n))},range:ty.cursor(o)}});return!n.changes.empty&&(t(e.update(n,{scrollIntoView:!0,userEvent:"move.character"})),!0)}},{key:"Ctrl-v",run:GE}],MM=[{key:"ArrowLeft",run:FE,shift:eM,preventDefault:!0},{key:"Mod-ArrowLeft",mac:"Alt-ArrowLeft",run:e=>VE(e,!NE(e)),shift:e=>nM(e,!NE(e)),preventDefault:!0},{mac:"Cmd-ArrowLeft",run:e=>RE(e,t=>XE(e,t,!NE(e))),shift:e=>KE(e,t=>XE(e,t,!NE(e))),preventDefault:!0},{key:"ArrowRight",run:QE,shift:tM,preventDefault:!0},{key:"Mod-ArrowRight",mac:"Alt-ArrowRight",run:e=>VE(e,NE(e)),shift:e=>nM(e,NE(e)),preventDefault:!0},{mac:"Cmd-ArrowRight",run:e=>RE(e,t=>XE(e,t,NE(e))),shift:e=>KE(e,t=>XE(e,t,NE(e))),preventDefault:!0},{key:"ArrowUp",run:jE,shift:iM,preventDefault:!0},{mac:"Cmd-ArrowUp",run:cM,shift:dM},{mac:"Ctrl-ArrowUp",run:YE,shift:aM},{key:"ArrowDown",run:qE,shift:oM,preventDefault:!0},{mac:"Cmd-ArrowDown",run:hM,shift:uM},{mac:"Ctrl-ArrowDown",run:GE,shift:lM},{key:"PageUp",run:YE,shift:aM},{key:"PageDown",run:GE,shift:lM},{key:"Home",run:e=>RE(e,t=>XE(e,t,!1)),shift:e=>KE(e,t=>XE(e,t,!1)),preventDefault:!0},{key:"Mod-Home",run:cM,shift:dM},{key:"End",run:e=>RE(e,t=>XE(e,t,!0)),shift:e=>KE(e,t=>XE(e,t,!0)),preventDefault:!0},{key:"Mod-End",run:hM,shift:uM},{key:"Enter",run:kM,shift:kM},{key:"Mod-a",run:({state:e,dispatch:t})=>(t(e.update({selection:{anchor:0,head:e.doc.length},userEvent:"select"})),!0)},{key:"Backspace",run:vM,shift:vM,preventDefault:!0},{key:"Delete",run:bM,preventDefault:!0},{key:"Mod-Backspace",mac:"Alt-Backspace",run:yM,preventDefault:!0},{key:"Mod-Delete",mac:"Alt-Delete",run:e=>AM(e,!0),preventDefault:!0},{mac:"Mod-Backspace",run:e=>fM(e,t=>{let n=e.moveToLineBoundary(t,!1).head;return t.head>n?n:Math.max(0,t.head-1)}),preventDefault:!0},{mac:"Mod-Delete",run:e=>fM(e,t=>{let n=e.moveToLineBoundary(t,!0).head;return t.head<n?n:Math.min(e.state.doc.length,t.head+1)}),preventDefault:!0}].concat(EM.map(e=>({mac:e.key,run:e.run,shift:e.shift}))),DM=[{key:"Alt-ArrowLeft",mac:"Ctrl-ArrowLeft",run:e=>RE(e,t=>$E(e.state,t,!NE(e))),shift:e=>KE(e,t=>$E(e.state,t,!NE(e)))},{key:"Alt-ArrowRight",mac:"Ctrl-ArrowRight",run:e=>RE(e,t=>$E(e.state,t,NE(e))),shift:e=>KE(e,t=>$E(e.state,t,NE(e)))},{key:"Alt-ArrowUp",run:({state:e,dispatch:t})=>CM(e,t,!1)},{key:"Shift-Alt-ArrowUp",run:({state:e,dispatch:t})=>xM(e,t,!1)},{key:"Alt-ArrowDown",run:({state:e,dispatch:t})=>CM(e,t,!0)},{key:"Shift-Alt-ArrowDown",run:({state:e,dispatch:t})=>xM(e,t,!0)},{key:"Mod-Alt-ArrowUp",run:e=>pM(e,!1)},{key:"Mod-Alt-ArrowDown",run:e=>pM(e,!0)},{key:"Escape",run:({state:e,dispatch:t})=>{let n=e.selection,r=null;return n.ranges.length>1?r=ty.create([n.main]):n.main.empty||(r=ty.create([ty.cursor(n.main.head)])),!!r&&(t(PE(e,r)),!0)}},{key:"Mod-Enter",run:SM},{key:"Alt-l",mac:"Ctrl-l",run:({state:e,dispatch:t})=>{let n=wM(e).map(({from:t,to:n})=>ty.range(t,Math.min(n+1,e.doc.length)));return t(e.update({selection:ty.create(n),userEvent:"select"})),!0}},{key:"Mod-i",run:({state:e,dispatch:t})=>{let n=DE(e.selection,t=>{let n=E_(e),r=n.resolveStack(t.from,1);if(t.empty){let e=n.resolveStack(t.from,-1);e.node.from>=r.node.from&&e.node.to<=r.node.to&&(r=e)}for(let e=r;e;e=e.next){let{node:n}=e;if((n.from<t.from&&n.to>=t.to||n.to>t.to&&n.from<=t.from)&&e.next)return ty.range(n.to,n.from)}return t});return!n.eq(e.selection)&&(t(PE(e,n)),!0)},preventDefault:!0},{key:"Mod-[",run:TM},{key:"Mod-]",run:_M},{key:"Mod-Alt-\\",run:({state:e,dispatch:t})=>{if(e.readOnly)return!1;let n=Object.create(null),r=new W_(e,{overrideIndentation:e=>{let t=n[e];return null==t?-1:t}}),i=BM(e,(t,i,o)=>{let s=q_(r,t.from);if(null==s)return;/\S/.test(t.text)||(s=0);let a=/^\s*/.exec(t.text)[0],l=j_(e,s);(a!=l||o.from<t.from+a.length)&&(n[t.from]=s,i.push({from:t.from,to:t.from+a.length,insert:l}))});return i.changes.empty||t(e.update(i,{userEvent:"indent"})),!0}},{key:"Shift-Mod-k",run:e=>{if(e.state.readOnly)return!1;let{state:t}=e,n=t.changes(wM(t).map(({from:e,to:n})=>(e>0?e--:n<t.doc.length&&n++,{from:e,to:n}))),r=DE(t.selection,t=>{let n;if(e.lineWrapping){let r=e.lineBlockAt(t.head),i=e.coordsAtPos(t.head,t.assoc||1);i&&(n=r.bottom+e.documentTop-i.bottom+e.defaultLineHeight/2)}return e.moveVertically(t,!0,n)}).map(n);return e.dispatch({changes:n,selection:r,scrollIntoView:!0,userEvent:"delete.line"}),!0}},{key:"Shift-Mod-\\",run:({state:e,dispatch:t})=>JE(e,t,!1)},{key:"Mod-/",run:e=>{let{state:t}=e,n=t.doc.lineAt(t.selection.main.from),r=oE(e.state,n.from);return r.line?nE(e):!!r.block&&iE(e)}},{key:"Alt-A",run:rE},{key:"Ctrl-m",mac:"Shift-Alt-m",run:e=>(e.setTabFocusMode(),!0)}].concat(MM),PM={key:"Tab",run:_M,shift:TM};function RM(){var e=arguments[0];"string"==typeof e&&(e=document.createElement(e));var t=1,n=arguments[1];if(n&&"object"==typeof n&&null==n.nodeType&&!Array.isArray(n)){for(var r in n)if(Object.prototype.hasOwnProperty.call(n,r)){var i=n[r];"string"==typeof i?e.setAttribute(r,i):null!=i&&(e[r]=i)}t++}for(;t<arguments.length;t++)IM(e,arguments[t]);return e}function IM(e,t){if("string"==typeof t)e.appendChild(document.createTextNode(t));else if(null==t);else if(null!=t.nodeType)e.appendChild(t);else{if(!Array.isArray(t))throw new RangeError("Unsupported child node: "+t);for(var n=0;n<t.length;n++)IM(e,t[n])}}const LM="function"==typeof String.prototype.normalize?e=>e.normalize("NFKD"):e=>e;class NM{constructor(e,t,n=0,r=e.length,i,o){this.test=o,this.value={from:0,to:0},this.done=!1,this.matches=[],this.buffer="",this.bufferPos=0,this.iter=e.iterRange(n,r),this.bufferStart=n,this.normalize=i?e=>i(LM(e)):LM,this.query=this.normalize(t)}peek(){if(this.bufferPos==this.buffer.length){if(this.bufferStart+=this.buffer.length,this.iter.next(),this.iter.done)return-1;this.bufferPos=0,this.buffer=this.iter.value}return zA(this.buffer,this.bufferPos)}next(){for(;this.matches.length;)this.matches.pop();return this.nextOverlapping()}nextOverlapping(){for(;;){let e=this.peek();if(e<0)return this.done=!0,this;let t=$A(e),n=this.bufferStart+this.bufferPos;this.bufferPos+=HA(e);let r=this.normalize(t);if(r.length)for(let e=0,i=n;;e++){let o=r.charCodeAt(e),s=this.match(o,i,this.bufferPos+this.bufferStart);if(e==r.length-1){if(s)return this.value=s,this;break}i==n&&e<t.length&&t.charCodeAt(e)==o&&i++}}}match(e,t,n){let r=null;for(let t=0;t<this.matches.length;t+=2){let i=this.matches[t],o=!1;this.query.charCodeAt(i)==e&&(i==this.query.length-1?r={from:this.matches[t+1],to:n}:(this.matches[t]++,o=!0)),o||(this.matches.splice(t,2),t-=2)}return this.query.charCodeAt(0)==e&&(1==this.query.length?r={from:t,to:n}:this.matches.push(1,t)),r&&this.test&&!this.test(r.from,r.to,this.buffer,this.bufferStart)&&(r=null),r}}"undefined"!=typeof Symbol&&(NM.prototype[Symbol.iterator]=function(){return this});const FM={from:-1,to:-1,match:/.*/.exec("")},QM="gm"+(null==/x/.unicode?"":"u");class VM{constructor(e,t,n,r=0,i=e.length){if(this.text=e,this.to=i,this.curLine="",this.done=!1,this.value=FM,/\\[sWDnr]|\n|\r|\[\^/.test(t))return new HM(e,t,n,r,i);this.re=new RegExp(t,QM+((null==n?void 0:n.ignoreCase)?"i":"")),this.test=null==n?void 0:n.test,this.iter=e.iter();let o=e.lineAt(r);this.curLineStart=o.from,this.matchPos=jM(e,r),this.getLine(this.curLineStart)}getLine(e){this.iter.next(e),this.iter.lineBreak?this.curLine="":(this.curLine=this.iter.value,this.curLineStart+this.curLine.length>this.to&&(this.curLine=this.curLine.slice(0,this.to-this.curLineStart)),this.iter.next())}nextLine(){this.curLineStart=this.curLineStart+this.curLine.length+1,this.curLineStart>this.to?this.curLine="":this.getLine(0)}next(){for(let e=this.matchPos-this.curLineStart;;){this.re.lastIndex=e;let t=this.matchPos<=this.to&&this.re.exec(this.curLine);if(t){let n=this.curLineStart+t.index,r=n+t[0].length;if(this.matchPos=jM(this.text,r+(n==r?1:0)),n==this.curLineStart+this.curLine.length&&this.nextLine(),(n<r||n>this.value.to)&&(!this.test||this.test(n,r,t)))return this.value={from:n,to:r,match:t},this;e=this.matchPos-this.curLineStart}else{if(!(this.curLineStart+this.curLine.length<this.to))return this.done=!0,this;this.nextLine(),e=0}}}}const zM=new WeakMap;class $M{constructor(e,t){this.from=e,this.text=t}get to(){return this.from+this.text.length}static get(e,t,n){let r=zM.get(e);if(!r||r.from>=n||r.to<=t){let r=new $M(t,e.sliceString(t,n));return zM.set(e,r),r}if(r.from==t&&r.to==n)return r;let{text:i,from:o}=r;return o>t&&(i=e.sliceString(t,o)+i,o=t),r.to<n&&(i+=e.sliceString(r.to,n)),zM.set(e,new $M(o,i)),new $M(t,i.slice(t-o,n-o))}}class HM{constructor(e,t,n,r,i){this.text=e,this.to=i,this.done=!1,this.value=FM,this.matchPos=jM(e,r),this.re=new RegExp(t,QM+((null==n?void 0:n.ignoreCase)?"i":"")),this.test=null==n?void 0:n.test,this.flat=$M.get(e,r,this.chunkEnd(r+5e3))}chunkEnd(e){return e>=this.to?this.to:this.text.lineAt(e).to}next(){for(;;){let e=this.re.lastIndex=this.matchPos-this.flat.from,t=this.re.exec(this.flat.text);if(t&&!t[0]&&t.index==e&&(this.re.lastIndex=e+1,t=this.re.exec(this.flat.text)),t){let e=this.flat.from+t.index,n=e+t[0].length;if((this.flat.to>=this.to||t.index+t[0].length<=this.flat.text.length-10)&&(!this.test||this.test(e,n,t)))return this.value={from:e,to:n,match:t},this.matchPos=jM(this.text,n+(e==n?1:0)),this}if(this.flat.to==this.to)return this.done=!0,this;this.flat=$M.get(this.text,this.flat.from,this.chunkEnd(this.flat.from+2*this.flat.text.length))}}}function jM(e,t){if(t>=e.length)return t;let n,r=e.lineAt(t);for(;t<r.to&&(n=r.text.charCodeAt(t-r.from))>=56320&&n<57344;)t++;return t}function qM(e){let t=RM("input",{class:"cm-textfield",name:"line",value:String(e.state.doc.lineAt(e.state.selection.main.head).number)});function n(){let n=/^([+-])?(\d+)?(:\d+)?(%)?$/.exec(t.value);if(!n)return;let{state:r}=e,i=r.doc.lineAt(r.selection.main.head),[,o,s,a,l]=n,c=a?+a.slice(1):0,h=s?+s:i.number;if(s&&l){let e=h/100;o&&(e=e*("-"==o?-1:1)+i.number/r.doc.lines),h=Math.round(r.doc.lines*e)}else s&&o&&(h=h*("-"==o?-1:1)+i.number);let d=r.doc.line(Math.max(1,Math.min(r.doc.lines,h))),u=ty.cursor(d.from+Math.max(0,Math.min(c,d.length)));e.dispatch({effects:[WM.of(!1),OS.scrollIntoView(u.from,{y:"center"})],selection:u}),e.focus()}return{dom:RM("form",{class:"cm-gotoLine",onkeydown:t=>{27==t.keyCode?(t.preventDefault(),e.dispatch({effects:WM.of(!1)}),e.focus()):13==t.keyCode&&(t.preventDefault(),n())},onsubmit:e=>{e.preventDefault(),n()}},RM("label",e.state.phrase("Go to line"),": ",t)," ",RM("button",{class:"cm-button",type:"submit"},e.state.phrase("go")),RM("button",{name:"close",onclick:()=>{e.dispatch({effects:WM.of(!1)}),e.focus()},"aria-label":e.state.phrase("close"),type:"button"},["×"]))}}"undefined"!=typeof Symbol&&(VM.prototype[Symbol.iterator]=HM.prototype[Symbol.iterator]=function(){return this});const WM=Ry.define(),UM=dy.define({create:()=>!0,update(e,t){for(let n of t.effects)n.is(WM)&&(e=n.value);return e},provide:e=>UO.from(e,e=>e?qM:null)}),YM=OS.baseTheme({".cm-panel.cm-gotoLine":{padding:"2px 6px 4px",position:"relative","& label":{fontSize:"80%"},"& [name=close]":{position:"absolute",top:"0",bottom:"0",right:"4px",backgroundColor:"inherit",border:"none",font:"inherit",padding:"0"}}}),GM={highlightWordAroundCursor:!1,minSelectionLength:1,maxMatches:100,wholeWords:!1},XM=iy.define({combine:e=>Uy(e,GM,{highlightWordAroundCursor:(e,t)=>e||t,minSelectionLength:Math.min,maxMatches:Math.min})});function JM(e){let t=[nD,tD];return e&&t.push(XM.of(e)),t}const KM=OC.mark({class:"cm-selectionMatch"}),ZM=OC.mark({class:"cm-selectionMatch cm-selectionMatch-main"});function eD(e,t,n,r){return!(0!=n&&e(t.sliceDoc(n-1,n))==$y.Word||r!=t.doc.length&&e(t.sliceDoc(r,r+1))==$y.Word)}const tD=xx.fromClass(class{constructor(e){this.decorations=this.getDeco(e)}update(e){(e.selectionSet||e.docChanged||e.viewportChanged)&&(this.decorations=this.getDeco(e.view))}getDeco(e){let t=e.state.facet(XM),{state:n}=e,r=n.selection;if(r.ranges.length>1)return OC.none;let i,o=r.main,s=null;if(o.empty){if(!t.highlightWordAroundCursor)return OC.none;let e=n.wordAt(o.head);if(!e)return OC.none;s=n.charCategorizer(o.head),i=n.sliceDoc(e.from,e.to)}else{let e=o.to-o.from;if(e<t.minSelectionLength||e>200)return OC.none;if(t.wholeWords){if(i=n.sliceDoc(o.from,o.to),s=n.charCategorizer(o.head),!eD(s,n,o.from,o.to)||!function(e,t,n,r){return e(t.sliceDoc(n,n+1))==$y.Word&&e(t.sliceDoc(r-1,r))==$y.Word}(s,n,o.from,o.to))return OC.none}else if(i=n.sliceDoc(o.from,o.to),!i)return OC.none}let a=[];for(let r of e.visibleRanges){let e=new NM(n.doc,i,r.from,r.to);for(;!e.next().done;){let{from:r,to:i}=e.value;if((!s||eD(s,n,r,i))&&(o.empty&&r<=o.from&&i>=o.to?a.push(ZM.range(r,i)):(r>=o.to||i<=o.from)&&a.push(KM.range(r,i)),a.length>t.maxMatches))return OC.none}}return OC.set(a)}},{decorations:e=>e.decorations}),nD=OS.baseTheme({".cm-selectionMatch":{backgroundColor:"#99ff7780"},".cm-searchMatch .cm-selectionMatch":{backgroundColor:"transparent"}});const rD=iy.define({combine:e=>Uy(e,{top:!1,caseSensitive:!1,literal:!1,regexp:!1,wholeWord:!1,createPanel:e=>new DD(e),scrollToMatch:e=>OS.scrollIntoView(e)})});class iD{constructor(e){this.search=e.search,this.caseSensitive=!!e.caseSensitive,this.literal=!!e.literal,this.regexp=!!e.regexp,this.replace=e.replace||"",this.valid=!!this.search&&(!this.regexp||function(e){try{return new RegExp(e,QM),!0}catch(e){return!1}}(this.search)),this.unquoted=this.unquote(this.search),this.wholeWord=!!e.wholeWord}unquote(e){return this.literal?e:e.replace(/\\([nrt\\])/g,(e,t)=>"n"==t?"\n":"r"==t?"\r":"t"==t?"\t":"\\")}eq(e){return this.search==e.search&&this.replace==e.replace&&this.caseSensitive==e.caseSensitive&&this.regexp==e.regexp&&this.wholeWord==e.wholeWord}create(){return this.regexp?new dD(this):new aD(this)}getCursor(e,t=0,n){let r=e.doc?e:Wy.create({doc:e});return null==n&&(n=r.doc.length),this.regexp?lD(this,r,t,n):sD(this,r,t,n)}}class oD{constructor(e){this.spec=e}}function sD(e,t,n,r){return new NM(t.doc,e.unquoted,n,r,e.caseSensitive?void 0:e=>e.toLowerCase(),e.wholeWord?function(e,t){return(n,r,i,o)=>((o>n||o+i.length<r)&&(o=Math.max(0,n-2),i=e.sliceString(o,Math.min(e.length,r+2))),!(t(cD(i,n-o))==$y.Word&&t(hD(i,n-o))==$y.Word||t(hD(i,r-o))==$y.Word&&t(cD(i,r-o))==$y.Word))}(t.doc,t.charCategorizer(t.selection.main.head)):void 0)}class aD extends oD{constructor(e){super(e)}nextMatch(e,t,n){let r=sD(this.spec,e,n,e.doc.length).nextOverlapping();if(r.done){let n=Math.min(e.doc.length,t+this.spec.unquoted.length);r=sD(this.spec,e,0,n).nextOverlapping()}return r.done||r.value.from==t&&r.value.to==n?null:r.value}prevMatchInRange(e,t,n){for(let r=n;;){let n=Math.max(t,r-1e4-this.spec.unquoted.length),i=sD(this.spec,e,n,r),o=null;for(;!i.nextOverlapping().done;)o=i.value;if(o)return o;if(n==t)return null;r-=1e4}}prevMatch(e,t,n){let r=this.prevMatchInRange(e,0,t);return r||(r=this.prevMatchInRange(e,Math.max(0,n-this.spec.unquoted.length),e.doc.length)),!r||r.from==t&&r.to==n?null:r}getReplacement(e){return this.spec.unquote(this.spec.replace)}matchAll(e,t){let n=sD(this.spec,e,0,e.doc.length),r=[];for(;!n.next().done;){if(r.length>=t)return null;r.push(n.value)}return r}highlight(e,t,n,r){let i=sD(this.spec,e,Math.max(0,t-this.spec.unquoted.length),Math.min(n+this.spec.unquoted.length,e.doc.length));for(;!i.next().done;)r(i.value.from,i.value.to)}}function lD(e,t,n,r){return new VM(t.doc,e.search,{ignoreCase:!e.caseSensitive,test:e.wholeWord?(i=t.charCategorizer(t.selection.main.head),(e,t,n)=>!n[0].length||(i(cD(n.input,n.index))!=$y.Word||i(hD(n.input,n.index))!=$y.Word)&&(i(hD(n.input,n.index+n[0].length))!=$y.Word||i(cD(n.input,n.index+n[0].length))!=$y.Word)):void 0},n,r);var i}function cD(e,t){return e.slice(VA(e,t,!1),t)}function hD(e,t){return e.slice(t,VA(e,t))}class dD extends oD{nextMatch(e,t,n){let r=lD(this.spec,e,n,e.doc.length).next();return r.done&&(r=lD(this.spec,e,0,t).next()),r.done?null:r.value}prevMatchInRange(e,t,n){for(let r=1;;r++){let i=Math.max(t,n-1e4*r),o=lD(this.spec,e,i,n),s=null;for(;!o.next().done;)s=o.value;if(s&&(i==t||s.from>i+10))return s;if(i==t)return null}}prevMatch(e,t,n){return this.prevMatchInRange(e,0,t)||this.prevMatchInRange(e,n,e.doc.length)}getReplacement(e){return this.spec.unquote(this.spec.replace).replace(/\$([$&]|\d+)/g,(t,n)=>{if("&"==n)return e.match[0];if("$"==n)return"$";for(let t=n.length;t>0;t--){let r=+n.slice(0,t);if(r>0&&r<e.match.length)return e.match[r]+n.slice(t)}return t})}matchAll(e,t){let n=lD(this.spec,e,0,e.doc.length),r=[];for(;!n.next().done;){if(r.length>=t)return null;r.push(n.value)}return r}highlight(e,t,n,r){let i=lD(this.spec,e,Math.max(0,t-250),Math.min(n+250,e.doc.length));for(;!i.next().done;)r(i.value.from,i.value.to)}}const uD=Ry.define(),pD=Ry.define(),fD=dy.define({create:e=>new gD(OD(e).create(),null),update(e,t){for(let n of t.effects)n.is(uD)?e=new gD(n.value.create(),e.panel):n.is(pD)&&(e=new gD(e.query,n.value?SD:null));return e},provide:e=>UO.from(e,e=>e.panel)});class gD{constructor(e,t){this.query=e,this.panel=t}}const mD=OC.mark({class:"cm-searchMatch"}),vD=OC.mark({class:"cm-searchMatch cm-searchMatch-selected"}),bD=xx.fromClass(class{constructor(e){this.view=e,this.decorations=this.highlight(e.state.field(fD))}update(e){let t=e.state.field(fD);(t!=e.startState.field(fD)||e.docChanged||e.selectionSet||e.viewportChanged)&&(this.decorations=this.highlight(t))}highlight({query:e,panel:t}){if(!t||!e.spec.valid)return OC.none;let{view:n}=this,r=new Zy;for(let t=0,i=n.visibleRanges,o=i.length;t<o;t++){let{from:s,to:a}=i[t];for(;t<o-1&&a>i[t+1].from-500;)a=i[++t].to;e.highlight(n.state,s,a,(e,t)=>{let i=n.state.selection.ranges.some(n=>n.from==e&&n.to==t);r.add(e,t,i?vD:mD)})}return r.finish()}},{decorations:e=>e.decorations});function AD(e){return t=>{let n=t.state.field(fD,!1);return n&&n.query.spec.valid?e(t,n):TD(t)}}const yD=AD((e,{query:t})=>{let{to:n}=e.state.selection.main,r=t.nextMatch(e.state,n,n);if(!r)return!1;let i=ty.single(r.from,r.to),o=e.state.facet(rD);return e.dispatch({selection:i,effects:[LD(e,r),o.scrollToMatch(i.main,e)],userEvent:"select.search"}),_D(e),!0}),wD=AD((e,{query:t})=>{let{state:n}=e,{from:r}=n.selection.main,i=t.prevMatch(n,r,r);if(!i)return!1;let o=ty.single(i.from,i.to),s=e.state.facet(rD);return e.dispatch({selection:o,effects:[LD(e,i),s.scrollToMatch(o.main,e)],userEvent:"select.search"}),_D(e),!0}),CD=AD((e,{query:t})=>{let n=t.matchAll(e.state,1e3);return!(!n||!n.length)&&(e.dispatch({selection:ty.create(n.map(e=>ty.range(e.from,e.to))),userEvent:"select.search.matches"}),!0)}),xD=AD((e,{query:t})=>{let{state:n}=e,{from:r,to:i}=n.selection.main;if(n.readOnly)return!1;let o=t.nextMatch(n,r,r);if(!o)return!1;let s,a,l=o,c=[],h=[];l.from==r&&l.to==i&&(a=n.toText(t.getReplacement(l)),c.push({from:l.from,to:l.to,insert:a}),l=t.nextMatch(n,l.from,l.to),h.push(OS.announce.of(n.phrase("replaced match on line $",n.doc.lineAt(r).number)+".")));let d=e.state.changes(c);return l&&(s=ty.single(l.from,l.to).map(d),h.push(LD(e,l)),h.push(n.facet(rD).scrollToMatch(s.main,e))),e.dispatch({changes:d,selection:s,effects:h,userEvent:"input.replace"}),!0}),kD=AD((e,{query:t})=>{if(e.state.readOnly)return!1;let n=t.matchAll(e.state,1e9).map(e=>{let{from:n,to:r}=e;return{from:n,to:r,insert:t.getReplacement(e)}});if(!n.length)return!1;let r=e.state.phrase("replaced $ matches",n.length)+".";return e.dispatch({changes:n,effects:OS.announce.of(r),userEvent:"input.replace.all"}),!0});function SD(e){return e.state.facet(rD).createPanel(e)}function OD(e,t){var n,r,i,o,s;let a=e.selection.main,l=a.empty||a.to>a.from+100?"":e.sliceDoc(a.from,a.to);if(t&&!l)return t;let c=e.facet(rD);return new iD({search:(null!==(n=null==t?void 0:t.literal)&&void 0!==n?n:c.literal)?l:l.replace(/\n/g,"\\n"),caseSensitive:null!==(r=null==t?void 0:t.caseSensitive)&&void 0!==r?r:c.caseSensitive,literal:null!==(i=null==t?void 0:t.literal)&&void 0!==i?i:c.literal,regexp:null!==(o=null==t?void 0:t.regexp)&&void 0!==o?o:c.regexp,wholeWord:null!==(s=null==t?void 0:t.wholeWord)&&void 0!==s?s:c.wholeWord})}function BD(e){let t=HO(e,SD);return t&&t.dom.querySelector("[main-field]")}function _D(e){let t=BD(e);t&&t==e.root.activeElement&&t.select()}const TD=e=>{let t=e.state.field(fD,!1);if(t&&t.panel){let n=BD(e);if(n&&n!=e.root.activeElement){let r=OD(e.state,t.query.spec);r.valid&&e.dispatch({effects:uD.of(r)}),n.focus(),n.select()}}else e.dispatch({effects:[pD.of(!0),t?uD.of(OD(e.state,t.query.spec)):Ry.appendConfig.of(FD)]});return!0},ED=e=>{let t=e.state.field(fD,!1);if(!t||!t.panel)return!1;let n=HO(e,SD);return n&&n.dom.contains(e.root.activeElement)&&e.focus(),e.dispatch({effects:pD.of(!1)}),!0},MD=[{key:"Mod-f",run:TD,scope:"editor search-panel"},{key:"F3",run:yD,shift:wD,scope:"editor search-panel",preventDefault:!0},{key:"Mod-g",run:yD,shift:wD,scope:"editor search-panel",preventDefault:!0},{key:"Escape",run:ED,scope:"editor search-panel"},{key:"Mod-Shift-l",run:({state:e,dispatch:t})=>{let n=e.selection;if(n.ranges.length>1||n.main.empty)return!1;let{from:r,to:i}=n.main,o=[],s=0;for(let t=new NM(e.doc,e.sliceDoc(r,i));!t.next().done;){if(o.length>1e3)return!1;t.value.from==r&&(s=o.length),o.push(ty.range(t.value.from,t.value.to))}return t(e.update({selection:ty.create(o,s),userEvent:"select.search.matches"})),!0}},{key:"Mod-Alt-g",run:e=>{let t=HO(e,qM);if(!t){let n=[WM.of(!0)];null==e.state.field(UM,!1)&&n.push(Ry.appendConfig.of([UM,YM])),e.dispatch({effects:n}),t=HO(e,qM)}return t&&t.dom.querySelector("input").select(),!0}},{key:"Mod-d",run:({state:e,dispatch:t})=>{let{ranges:n}=e.selection;if(n.some(e=>e.from===e.to))return(({state:e,dispatch:t})=>{let{selection:n}=e,r=ty.create(n.ranges.map(t=>e.wordAt(t.head)||ty.cursor(t.head)),n.mainIndex);return!r.eq(n)&&(t(e.update({selection:r})),!0)})({state:e,dispatch:t});let r=e.sliceDoc(n[0].from,n[0].to);if(e.selection.ranges.some(t=>e.sliceDoc(t.from,t.to)!=r))return!1;let i=function(e,t){let{main:n,ranges:r}=e.selection,i=e.wordAt(n.head),o=i&&i.from==n.from&&i.to==n.to;for(let n=!1,i=new NM(e.doc,t,r[r.length-1].to);;){if(i.next(),!i.done){if(n&&r.some(e=>e.from==i.value.from))continue;if(o){let t=e.wordAt(i.value.from);if(!t||t.from!=i.value.from||t.to!=i.value.to)continue}return i.value}if(n)return null;i=new NM(e.doc,t,0,Math.max(0,r[r.length-1].from-1)),n=!0}}(e,r);return!!i&&(t(e.update({selection:e.selection.addRange(ty.range(i.from,i.to),!1),effects:OS.scrollIntoView(i.to)})),!0)},preventDefault:!0}];class DD{constructor(e){this.view=e;let t=this.query=e.state.field(fD).query.spec;function n(e,t,n){return RM("button",{class:"cm-button",name:e,onclick:t,type:"button"},n)}this.commit=this.commit.bind(this),this.searchField=RM("input",{value:t.search,placeholder:PD(e,"Find"),"aria-label":PD(e,"Find"),class:"cm-textfield",name:"search",form:"","main-field":"true",onchange:this.commit,onkeyup:this.commit}),this.replaceField=RM("input",{value:t.replace,placeholder:PD(e,"Replace"),"aria-label":PD(e,"Replace"),class:"cm-textfield",name:"replace",form:"",onchange:this.commit,onkeyup:this.commit}),this.caseField=RM("input",{type:"checkbox",name:"case",form:"",checked:t.caseSensitive,onchange:this.commit}),this.reField=RM("input",{type:"checkbox",name:"re",form:"",checked:t.regexp,onchange:this.commit}),this.wordField=RM("input",{type:"checkbox",name:"word",form:"",checked:t.wholeWord,onchange:this.commit}),this.dom=RM("div",{onkeydown:e=>this.keydown(e),class:"cm-search"},[this.searchField,n("next",()=>yD(e),[PD(e,"next")]),n("prev",()=>wD(e),[PD(e,"previous")]),n("select",()=>CD(e),[PD(e,"all")]),RM("label",null,[this.caseField,PD(e,"match case")]),RM("label",null,[this.reField,PD(e,"regexp")]),RM("label",null,[this.wordField,PD(e,"by word")]),...e.state.readOnly?[]:[RM("br"),this.replaceField,n("replace",()=>xD(e),[PD(e,"replace")]),n("replaceAll",()=>kD(e),[PD(e,"replace all")])],RM("button",{name:"close",onclick:()=>ED(e),"aria-label":PD(e,"close"),type:"button"},["×"])])}commit(){let e=new iD({search:this.searchField.value,caseSensitive:this.caseField.checked,regexp:this.reField.checked,wholeWord:this.wordField.checked,replace:this.replaceField.value});e.eq(this.query)||(this.query=e,this.view.dispatch({effects:uD.of(e)}))}keydown(e){!function(e,t,n){return VS(LS(e.state),t,e,n)}(this.view,e,"search-panel")?13==e.keyCode&&e.target==this.searchField?(e.preventDefault(),(e.shiftKey?wD:yD)(this.view)):13==e.keyCode&&e.target==this.replaceField&&(e.preventDefault(),xD(this.view)):e.preventDefault()}update(e){for(let t of e.transactions)for(let e of t.effects)e.is(uD)&&!e.value.eq(this.query)&&this.setQuery(e.value)}setQuery(e){this.query=e,this.searchField.value=e.search,this.replaceField.value=e.replace,this.caseField.checked=e.caseSensitive,this.reField.checked=e.regexp,this.wordField.checked=e.wholeWord}mount(){this.searchField.select()}get pos(){return 80}get top(){return this.view.state.facet(rD).top}}function PD(e,t){return e.state.phrase(t)}const RD=30,ID=/[\s\.,:;?!]/;function LD(e,{from:t,to:n}){let r=e.state.doc.lineAt(t),i=e.state.doc.lineAt(n).to,o=Math.max(r.from,t-RD),s=Math.min(i,n+RD),a=e.state.sliceDoc(o,s);if(o!=r.from)for(let e=0;e<RD;e++)if(!ID.test(a[e+1])&&ID.test(a[e])){a=a.slice(e);break}if(s!=i)for(let e=a.length-1;e>a.length-RD;e--)if(!ID.test(a[e-1])&&ID.test(a[e])){a=a.slice(0,e);break}return OS.announce.of(`${e.state.phrase("current match")}. ${a} ${e.state.phrase("on line")} ${r.number}.`)}const ND=OS.baseTheme({".cm-panel.cm-search":{padding:"2px 6px 4px",position:"relative","& [name=close]":{position:"absolute",top:"0",right:"4px",backgroundColor:"inherit",border:"none",font:"inherit",padding:0,margin:0},"& input, & button, & label":{margin:".2em .6em .2em 0"},"& input[type=checkbox]":{marginRight:".2em"},"& label":{fontSize:"80%",whiteSpace:"pre"}},"&light .cm-searchMatch":{backgroundColor:"#ffff0054"},"&dark .cm-searchMatch":{backgroundColor:"#00ffff8a"},"&light .cm-searchMatch-selected":{backgroundColor:"#ff6a0054"},"&dark .cm-searchMatch-selected":{backgroundColor:"#ff00ff8a"}}),FD=[fD,vy.low(bD),ND];class QD{constructor(e,t,n,r){this.state=e,this.pos=t,this.explicit=n,this.view=r,this.abortListeners=[],this.abortOnDocChange=!1}tokenBefore(e){let t=E_(this.state).resolveInner(this.pos,-1);for(;t&&e.indexOf(t.name)<0;)t=t.parent;return t?{from:t.from,to:this.pos,text:this.state.sliceDoc(t.from,this.pos),type:t.type}:null}matchBefore(e){let t=this.state.doc.lineAt(this.pos),n=Math.max(t.from,this.pos-250),r=t.text.slice(n-t.from,this.pos-t.from),i=r.search(jD(e,!1));return i<0?null:{from:n+i,to:this.pos,text:r.slice(i)}}get aborted(){return null==this.abortListeners}addEventListener(e,t,n){"abort"==e&&this.abortListeners&&(this.abortListeners.push(t),n&&n.onDocChange&&(this.abortOnDocChange=!0))}}function VD(e){let t=Object.keys(e).join(""),n=/\w/.test(t);return n&&(t=t.replace(/\w/g,"")),`[${n?"\\w":""}${t.replace(/[^\w\s]/g,"\\$&")}]`}function zD(e){let t=e.map(e=>"string"==typeof e?{label:e}:e),[n,r]=t.every(e=>/^\w+$/.test(e.label))?[/\w*$/,/\w+$/]:function(e){let t=Object.create(null),n=Object.create(null);for(let{label:r}of e){t[r[0]]=!0;for(let e=1;e<r.length;e++)n[r[e]]=!0}let r=VD(t)+VD(n)+"*$";return[new RegExp("^"+r),new RegExp(r)]}(t);return e=>{let i=e.matchBefore(r);return i||e.explicit?{from:i?i.from:e.pos,options:t,validFor:n}:null}}class $D{constructor(e,t,n,r){this.completion=e,this.source=t,this.match=n,this.score=r}}function HD(e){return e.selection.main.from}function jD(e,t){var n;let{source:r}=e,i=t&&"^"!=r[0],o="$"!=r[r.length-1];return i||o?new RegExp(`${i?"^":""}(?:${r})${o?"$":""}`,null!==(n=e.flags)&&void 0!==n?n:e.ignoreCase?"i":""):e}const qD=My.define();function WD(e,t,n,r){let{main:i}=e.selection,o=n-i.from,s=r-i.from;return{...e.changeByRange(a=>{if(a!=i&&n!=r&&e.sliceDoc(a.from+o,a.from+s)!=e.sliceDoc(n,r))return{range:a};let l=e.toText(t);return{changes:{from:a.from+o,to:r==i.from?a.to:a.from+s,insert:l},range:ty.cursor(a.from+o+l.length)}}),scrollIntoView:!0,userEvent:"input.complete"}}const UD=new WeakMap;function YD(e){if(!Array.isArray(e))return e;let t=UD.get(e);return t||UD.set(e,t=zD(e)),t}const GD=Ry.define(),XD=Ry.define();class JD{constructor(e){this.pattern=e,this.chars=[],this.folded=[],this.any=[],this.precise=[],this.byWord=[],this.score=0,this.matched=[];for(let t=0;t<e.length;){let n=zA(e,t),r=HA(n);this.chars.push(n);let i=e.slice(t,t+r),o=i.toUpperCase();this.folded.push(zA(o==i?i.toLowerCase():o,0)),t+=r}this.astral=e.length!=this.chars.length}ret(e,t){return this.score=e,this.matched=t,this}match(e){if(0==this.pattern.length)return this.ret(-100,[]);if(e.length<this.pattern.length)return null;let{chars:t,folded:n,any:r,precise:i,byWord:o}=this;if(1==t.length){let r=zA(e,0),i=HA(r),o=i==e.length?0:-100;if(r==t[0]);else{if(r!=n[0])return null;o+=-200}return this.ret(o,[0,i])}let s=e.indexOf(this.pattern);if(0==s)return this.ret(e.length==this.pattern.length?0:-100,[0,this.pattern.length]);let a=t.length,l=0;if(s<0){for(let i=0,o=Math.min(e.length,200);i<o&&l<a;){let o=zA(e,i);o!=t[l]&&o!=n[l]||(r[l++]=i),i+=HA(o)}if(l<a)return null}let c=0,h=0,d=!1,u=0,p=-1,f=-1,g=/[a-z]/.test(e),m=!0;for(let r=0,l=Math.min(e.length,200),v=0;r<l&&h<a;){let l=zA(e,r);s<0&&(c<a&&l==t[c]&&(i[c++]=r),u<a&&(l==t[u]||l==n[u]?(0==u&&(p=r),f=r+1,u++):u=0));let b,A=l<255?l>=48&&l<=57||l>=97&&l<=122?2:l>=65&&l<=90?1:0:(b=$A(l))!=b.toLowerCase()?1:b!=b.toUpperCase()?2:0;(!r||1==A&&g||0==v&&0!=A)&&(t[h]==l||n[h]==l&&(d=!0)?o[h++]=r:o.length&&(m=!1)),v=A,r+=HA(l)}return h==a&&0==o[0]&&m?this.result((d?-200:0)-100,o,e):u==a&&0==p?this.ret(-200-e.length+(f==e.length?0:-100),[0,f]):s>-1?this.ret(-700-e.length,[s,s+this.pattern.length]):u==a?this.ret(-900-e.length,[p,f]):h==a?this.result((d?-200:0)-100-700+(m?0:-1100),o,e):2==t.length?null:this.result((r[0]?-700:0)-200-1100,r,e)}result(e,t,n){let r=[],i=0;for(let e of t){let t=e+(this.astral?HA(zA(n,e)):1);i&&r[i-1]==e?r[i-1]=t:(r[i++]=e,r[i++]=t)}return this.ret(e-n.length,r)}}class KD{constructor(e){this.pattern=e,this.matched=[],this.score=0,this.folded=e.toLowerCase()}match(e){if(e.length<this.pattern.length)return null;let t=e.slice(0,this.pattern.length),n=t==this.pattern?0:t.toLowerCase()==this.folded?-200:null;return null==n?null:(this.matched=[0,t.length],this.score=n+(e.length==this.pattern.length?0:-100),this)}}const ZD=iy.define({combine:e=>Uy(e,{activateOnTyping:!0,activateOnCompletion:()=>!1,activateOnTypingDelay:100,selectOnOpen:!0,override:null,closeOnBlur:!0,maxRenderedOptions:100,defaultKeymap:!0,tooltipClass:()=>"",optionClass:()=>"",aboveCursor:!1,icons:!0,addToOptions:[],positionInfo:tP,filterStrict:!1,compareCompletions:(e,t)=>e.label.localeCompare(t.label),interactionDelay:75,updateSyncTime:100},{defaultKeymap:(e,t)=>e&&t,closeOnBlur:(e,t)=>e&&t,icons:(e,t)=>e&&t,tooltipClass:(e,t)=>n=>eP(e(n),t(n)),optionClass:(e,t)=>n=>eP(e(n),t(n)),addToOptions:(e,t)=>e.concat(t),filterStrict:(e,t)=>e||t})});function eP(e,t){return e?t?e+" "+t:e:t}function tP(e,t,n,r,i,o){let s,a,l=e.textDirection==FC.RTL,c=l,h=!1,d="top",u=t.left-i.left,p=i.right-t.right,f=r.right-r.left,g=r.bottom-r.top;if(c&&u<Math.min(f,p)?c=!1:!c&&p<Math.min(f,u)&&(c=!0),f<=(c?u:p))s=Math.max(i.top,Math.min(n.top,i.bottom-g))-t.top,a=Math.min(400,c?u:p);else{h=!0,a=Math.min(400,(l?t.right:i.right-t.left)-30);let e=i.bottom-t.bottom;e>=g||e>t.top?s=n.bottom-t.top:(d="bottom",s=t.bottom-n.top)}return{style:`${d}: ${s/((t.bottom-t.top)/o.offsetHeight)}px; max-width: ${a/((t.right-t.left)/o.offsetWidth)}px`,class:"cm-completionInfo-"+(h?l?"left-narrow":"right-narrow":c?"left":"right")}}function nP(e,t,n){if(e<=n)return{from:0,to:e};if(t<0&&(t=0),t<=e>>1){let e=Math.floor(t/n);return{from:e*n,to:(e+1)*n}}let r=Math.floor((e-t)/n);return{from:e-(r+1)*n,to:e-r*n}}class rP{constructor(e,t,n){this.view=e,this.stateField=t,this.applyCompletion=n,this.info=null,this.infoDestroy=null,this.placeInfoReq={read:()=>this.measureInfo(),write:e=>this.placeInfo(e),key:this},this.space=null,this.currentClass="";let r=e.state.field(t),{options:i,selected:o}=r.open,s=e.state.facet(ZD);this.optionContent=function(e){let t=e.addToOptions.slice();return e.icons&&t.push({render(e){let t=document.createElement("div");return t.classList.add("cm-completionIcon"),e.type&&t.classList.add(...e.type.split(/\s+/g).map(e=>"cm-completionIcon-"+e)),t.setAttribute("aria-hidden","true"),t},position:20}),t.push({render(e,t,n,r){let i=document.createElement("span");i.className="cm-completionLabel";let o=e.displayLabel||e.label,s=0;for(let e=0;e<r.length;){let t=r[e++],n=r[e++];t>s&&i.appendChild(document.createTextNode(o.slice(s,t)));let a=i.appendChild(document.createElement("span"));a.appendChild(document.createTextNode(o.slice(t,n))),a.className="cm-completionMatchedText",s=n}return s<o.length&&i.appendChild(document.createTextNode(o.slice(s))),i},position:50},{render(e){if(!e.detail)return null;let t=document.createElement("span");return t.className="cm-completionDetail",t.textContent=e.detail,t},position:80}),t.sort((e,t)=>e.position-t.position).map(e=>e.render)}(s),this.optionClass=s.optionClass,this.tooltipClass=s.tooltipClass,this.range=nP(i.length,o,s.maxRenderedOptions),this.dom=document.createElement("div"),this.dom.className="cm-tooltip-autocomplete",this.updateTooltipClass(e.state),this.dom.addEventListener("mousedown",n=>{let{options:r}=e.state.field(t).open;for(let t,i=n.target;i&&i!=this.dom;i=i.parentNode)if("LI"==i.nodeName&&(t=/-(\d+)$/.exec(i.id))&&+t[1]<r.length)return this.applyCompletion(e,r[+t[1]]),void n.preventDefault()}),this.dom.addEventListener("focusout",t=>{let n=e.state.field(this.stateField,!1);n&&n.tooltip&&e.state.facet(ZD).closeOnBlur&&t.relatedTarget!=e.contentDOM&&e.dispatch({effects:XD.of(null)})}),this.showOptions(i,r.id)}mount(){this.updateSel()}showOptions(e,t){this.list&&this.list.remove(),this.list=this.dom.appendChild(this.createListBox(e,t,this.range)),this.list.addEventListener("scroll",()=>{this.info&&this.view.requestMeasure(this.placeInfoReq)})}update(e){var t;let n=e.state.field(this.stateField),r=e.startState.field(this.stateField);if(this.updateTooltipClass(e.state),n!=r){let{options:i,selected:o,disabled:s}=n.open;r.open&&r.open.options==i||(this.range=nP(i.length,o,e.state.facet(ZD).maxRenderedOptions),this.showOptions(i,n.id)),this.updateSel(),s!=(null===(t=r.open)||void 0===t?void 0:t.disabled)&&this.dom.classList.toggle("cm-tooltip-autocomplete-disabled",!!s)}}updateTooltipClass(e){let t=this.tooltipClass(e);if(t!=this.currentClass){for(let e of this.currentClass.split(" "))e&&this.dom.classList.remove(e);for(let e of t.split(" "))e&&this.dom.classList.add(e);this.currentClass=t}}positioned(e){this.space=e,this.info&&this.view.requestMeasure(this.placeInfoReq)}updateSel(){let e=this.view.state.field(this.stateField),t=e.open;if((t.selected>-1&&t.selected<this.range.from||t.selected>=this.range.to)&&(this.range=nP(t.options.length,t.selected,this.view.state.facet(ZD).maxRenderedOptions),this.showOptions(t.options,e.id)),this.updateSelectedOption(t.selected)){this.destroyInfo();let{completion:n}=t.options[t.selected],{info:r}=n;if(!r)return;let i="string"==typeof r?document.createTextNode(r):r(n);if(!i)return;"then"in i?i.then(t=>{t&&this.view.state.field(this.stateField,!1)==e&&this.addInfoPane(t,n)}).catch(e=>Ax(this.view.state,e,"completion info")):this.addInfoPane(i,n)}}addInfoPane(e,t){this.destroyInfo();let n=this.info=document.createElement("div");if(n.className="cm-tooltip cm-completionInfo",null!=e.nodeType)n.appendChild(e),this.infoDestroy=null;else{let{dom:t,destroy:r}=e;n.appendChild(t),this.infoDestroy=r||null}this.dom.appendChild(n),this.view.requestMeasure(this.placeInfoReq)}updateSelectedOption(e){let t=null;for(let n=this.list.firstChild,r=this.range.from;n;n=n.nextSibling,r++)"LI"==n.nodeName&&n.id?r==e?n.hasAttribute("aria-selected")||(n.setAttribute("aria-selected","true"),t=n):n.hasAttribute("aria-selected")&&n.removeAttribute("aria-selected"):r--;return t&&function(e,t){let n=e.getBoundingClientRect(),r=t.getBoundingClientRect(),i=n.height/e.offsetHeight;r.top<n.top?e.scrollTop-=(n.top-r.top)/i:r.bottom>n.bottom&&(e.scrollTop+=(r.bottom-n.bottom)/i)}(this.list,t),t}measureInfo(){let e=this.dom.querySelector("[aria-selected]");if(!e||!this.info)return null;let t=this.dom.getBoundingClientRect(),n=this.info.getBoundingClientRect(),r=e.getBoundingClientRect(),i=this.space;if(!i){let e=this.dom.ownerDocument.documentElement;i={left:0,top:0,right:e.clientWidth,bottom:e.clientHeight}}return r.top>Math.min(i.bottom,t.bottom)-10||r.bottom<Math.max(i.top,t.top)+10?null:this.view.state.facet(ZD).positionInfo(this.view,t,r,n,i,this.dom)}placeInfo(e){this.info&&(e?(e.style&&(this.info.style.cssText=e.style),this.info.className="cm-tooltip cm-completionInfo "+(e.class||"")):this.info.style.cssText="top: -1e6px")}createListBox(e,t,n){const r=document.createElement("ul");r.id=t,r.setAttribute("role","listbox"),r.setAttribute("aria-expanded","true"),r.setAttribute("aria-label",this.view.state.phrase("Completions")),r.addEventListener("mousedown",e=>{e.target==r&&e.preventDefault()});let i=null;for(let o=n.from;o<n.to;o++){let{completion:s,match:a}=e[o],{section:l}=s;if(l){let e="string"==typeof l?l:l.name;if(e!=i&&(o>n.from||0==n.from))if(i=e,"string"!=typeof l&&l.header)r.appendChild(l.header(l));else{r.appendChild(document.createElement("completion-section")).textContent=e}}const c=r.appendChild(document.createElement("li"));c.id=t+"-"+o,c.setAttribute("role","option");let h=this.optionClass(s);h&&(c.className=h);for(let e of this.optionContent){let t=e(s,this.view.state,this.view,a);t&&c.appendChild(t)}}return n.from&&r.classList.add("cm-completionListIncompleteTop"),n.to<e.length&&r.classList.add("cm-completionListIncompleteBottom"),r}destroyInfo(){this.info&&(this.infoDestroy&&this.infoDestroy(),this.info.remove(),this.info=null)}destroy(){this.destroyInfo()}}function iP(e,t){return n=>new rP(n,e,t)}function oP(e){return 100*(e.boost||0)+(e.apply?10:0)+(e.info?5:0)+(e.type?1:0)}class sP{constructor(e,t,n,r,i,o){this.options=e,this.attrs=t,this.tooltip=n,this.timestamp=r,this.selected=i,this.disabled=o}setSelected(e,t){return e==this.selected||e>=this.options.length?this:new sP(this.options,hP(t,e),this.tooltip,this.timestamp,e,this.disabled)}static build(e,t,n,r,i,o){if(r&&!o&&e.some(e=>e.isPending))return r.setDisabled();let s=function(e,t){let n=[],r=null,i=null,o=e=>{n.push(e);let{section:t}=e.completion;if(t){r||(r=[]);let e="string"==typeof t?t:t.name;r.some(t=>t.name==e)||r.push("string"==typeof t?{name:e}:t)}},s=t.facet(ZD);for(let r of e)if(r.hasResult()){let e=r.result.getMatch;if(!1===r.result.filter)for(let t of r.result.options)o(new $D(t,r.source,e?e(t):[],1e9-n.length));else{let n,a=t.sliceDoc(r.from,r.to),l=s.filterStrict?new KD(a):new JD(a);for(let t of r.result.options)if(n=l.match(t.label)){let s=t.displayLabel?e?e(t,n.matched):[]:n.matched,a=n.score+(t.boost||0);if(o(new $D(t,r.source,s,a)),"object"==typeof t.section&&"dynamic"===t.section.rank){let{name:e}=t.section;i||(i=Object.create(null)),i[e]=Math.max(a,i[e]||-1e9)}}}}if(r){let e=Object.create(null),t=0,o=(e,t)=>("dynamic"===e.rank&&"dynamic"===t.rank?i[t.name]-i[e.name]:0)||("number"==typeof e.rank?e.rank:1e9)-("number"==typeof t.rank?t.rank:1e9)||(e.name<t.name?-1:1);for(let n of r.sort(o))t-=1e5,e[n.name]=t;for(let t of n){let{section:n}=t.completion;n&&(t.score+=e["string"==typeof n?n:n.name])}}let a=[],l=null,c=s.compareCompletions;for(let e of n.sort((e,t)=>t.score-e.score||c(e.completion,t.completion))){let t=e.completion;!l||l.label!=t.label||l.detail!=t.detail||null!=l.type&&null!=t.type&&l.type!=t.type||l.apply!=t.apply||l.boost!=t.boost?a.push(e):oP(e.completion)>oP(l)&&(a[a.length-1]=e),l=e.completion}return a}(e,t);if(!s.length)return r&&e.some(e=>e.isPending)?r.setDisabled():null;let a=t.facet(ZD).selectOnOpen?0:-1;if(r&&r.selected!=a&&-1!=r.selected){let e=r.options[r.selected].completion;for(let t=0;t<s.length;t++)if(s[t].completion==e){a=t;break}}return new sP(s,hP(n,a),{pos:e.reduce((e,t)=>t.hasResult()?Math.min(e,t.from):e,1e8),create:AP,above:i.aboveCursor},r?r.timestamp:Date.now(),a,!1)}map(e){return new sP(this.options,this.attrs,{...this.tooltip,pos:e.mapPos(this.tooltip.pos)},this.timestamp,this.selected,this.disabled)}setDisabled(){return new sP(this.options,this.attrs,this.tooltip,this.timestamp,this.selected,!0)}}class aP{constructor(e,t,n){this.active=e,this.id=t,this.open=n}static start(){return new aP(dP,"cm-ac-"+Math.floor(2e6*Math.random()).toString(36),null)}update(e){let{state:t}=e,n=t.facet(ZD),r=(n.override||t.languageDataAt("autocomplete",HD(t)).map(YD)).map(t=>{let r=this.active.find(e=>e.source==t)||new pP(t,this.active.some(e=>0!=e.state)?1:0);return r.update(e,n)});r.length==this.active.length&&r.every((e,t)=>e==this.active[t])&&(r=this.active);let i=this.open,o=e.effects.some(e=>e.is(gP));i&&e.docChanged&&(i=i.map(e.changes)),e.selection||r.some(t=>t.hasResult()&&e.changes.touchesRange(t.from,t.to))||!function(e,t){if(e==t)return!0;for(let n=0,r=0;;){for(;n<e.length&&!e[n].hasResult();)n++;for(;r<t.length&&!t[r].hasResult();)r++;let i=n==e.length,o=r==t.length;if(i||o)return i==o;if(e[n++].result!=t[r++].result)return!1}}(r,this.active)||o?i=sP.build(r,t,this.id,i,n,o):i&&i.disabled&&!r.some(e=>e.isPending)&&(i=null),!i&&r.every(e=>!e.isPending)&&r.some(e=>e.hasResult())&&(r=r.map(e=>e.hasResult()?new pP(e.source,0):e));for(let t of e.effects)t.is(mP)&&(i=i&&i.setSelected(t.value,this.id));return r==this.active&&i==this.open?this:new aP(r,this.id,i)}get tooltip(){return this.open?this.open.tooltip:null}get attrs(){return this.open?this.open.attrs:this.active.length?lP:cP}}const lP={"aria-autocomplete":"list"},cP={};function hP(e,t){let n={"aria-autocomplete":"list","aria-haspopup":"listbox","aria-controls":e};return t>-1&&(n["aria-activedescendant"]=e+"-"+t),n}const dP=[];function uP(e,t){if(e.isUserEvent("input.complete")){let n=e.annotation(qD);if(n&&t.activateOnCompletion(n))return 12}let n=e.isUserEvent("input.type");return n&&t.activateOnTyping?5:n?1:e.isUserEvent("delete.backward")?2:e.selection?8:e.docChanged?16:0}class pP{constructor(e,t,n=!1){this.source=e,this.state=t,this.explicit=n}hasResult(){return!1}get isPending(){return 1==this.state}update(e,t){let n=uP(e,t),r=this;(8&n||16&n&&this.touches(e))&&(r=new pP(r.source,0)),4&n&&0==r.state&&(r=new pP(this.source,1)),r=r.updateFor(e,n);for(let t of e.effects)if(t.is(GD))r=new pP(r.source,1,t.value);else if(t.is(XD))r=new pP(r.source,0);else if(t.is(gP))for(let e of t.value)e.source==r.source&&(r=e);return r}updateFor(e,t){return this.map(e.changes)}map(e){return this}touches(e){return e.changes.touchesRange(HD(e.state))}}class fP extends pP{constructor(e,t,n,r,i,o){super(e,3,t),this.limit=n,this.result=r,this.from=i,this.to=o}hasResult(){return!0}updateFor(e,t){var n;if(!(3&t))return this.map(e.changes);let r=this.result;r.map&&!e.changes.empty&&(r=r.map(r,e.changes));let i=e.changes.mapPos(this.from),o=e.changes.mapPos(this.to,1),s=HD(e.state);if(s>o||!r||2&t&&(HD(e.startState)==this.from||s<this.limit))return new pP(this.source,4&t?1:0);let a=e.changes.mapPos(this.limit);return function(e,t,n,r){if(!e)return!1;let i=t.sliceDoc(n,r);return"function"==typeof e?e(i,n,r,t):jD(e,!0).test(i)}(r.validFor,e.state,i,o)?new fP(this.source,this.explicit,a,r,i,o):r.update&&(r=r.update(r,i,o,new QD(e.state,s,!1)))?new fP(this.source,this.explicit,a,r,r.from,null!==(n=r.to)&&void 0!==n?n:HD(e.state)):new pP(this.source,1,this.explicit)}map(e){if(e.empty)return this;return(this.result.map?this.result.map(this.result,e):this.result)?new fP(this.source,this.explicit,e.mapPos(this.limit),this.result,e.mapPos(this.from),e.mapPos(this.to,1)):new pP(this.source,0)}touches(e){return e.changes.touchesRange(this.from,this.to)}}const gP=Ry.define({map:(e,t)=>e.map(e=>e.map(t))}),mP=Ry.define(),vP=dy.define({create:()=>aP.start(),update:(e,t)=>e.update(t),provide:e=>[PO.from(e,e=>e.tooltip),OS.contentAttributes.from(e,e=>e.attrs)]});function bP(e,t){const n=t.completion.apply||t.completion.label;let r=e.state.field(vP).active.find(e=>e.source==t.source);return r instanceof fP&&("string"==typeof n?e.dispatch({...WD(e.state,n,r.from,r.to),annotations:qD.of(t.completion)}):n(e,t.completion,r.from,r.to),!0)}const AP=iP(vP,bP);function yP(e,t="option"){return n=>{let r=n.state.field(vP,!1);if(!r||!r.open||r.open.disabled||Date.now()-r.open.timestamp<n.state.facet(ZD).interactionDelay)return!1;let i,o=1;"page"==t&&(i=VO(n,r.open.tooltip))&&(o=Math.max(2,Math.floor(i.dom.offsetHeight/i.dom.querySelector("li").offsetHeight)-1));let{length:s}=r.open.options,a=r.open.selected>-1?r.open.selected+o*(e?1:-1):e?0:s-1;return a<0?a="page"==t?0:s-1:a>=s&&(a="page"==t?s-1:0),n.dispatch({effects:mP.of(a)}),!0}}const wP=e=>!!e.state.field(vP,!1)&&(e.dispatch({effects:GD.of(!0)}),!0);class CP{constructor(e,t){this.active=e,this.context=t,this.time=Date.now(),this.updates=[],this.done=void 0}}const xP=xx.fromClass(class{constructor(e){this.view=e,this.debounceUpdate=-1,this.running=[],this.debounceAccept=-1,this.pendingStart=!1,this.composing=0;for(let t of e.state.field(vP).active)t.isPending&&this.startQuery(t)}update(e){let t=e.state.field(vP),n=e.state.facet(ZD);if(!e.selectionSet&&!e.docChanged&&e.startState.field(vP)==t)return;let r=e.transactions.some(e=>{let t=uP(e,n);return 8&t||(e.selection||e.docChanged)&&!(3&t)});for(let t=0;t<this.running.length;t++){let n=this.running[t];if(r||n.context.abortOnDocChange&&e.docChanged||n.updates.length+e.transactions.length>50&&Date.now()-n.time>1e3){for(let e of n.context.abortListeners)try{e()}catch(e){Ax(this.view.state,e)}n.context.abortListeners=null,this.running.splice(t--,1)}else n.updates.push(...e.transactions)}this.debounceUpdate>-1&&clearTimeout(this.debounceUpdate),e.transactions.some(e=>e.effects.some(e=>e.is(GD)))&&(this.pendingStart=!0);let i=this.pendingStart?50:n.activateOnTypingDelay;if(this.debounceUpdate=t.active.some(e=>e.isPending&&!this.running.some(t=>t.active.source==e.source))?setTimeout(()=>this.startUpdate(),i):-1,0!=this.composing)for(let t of e.transactions)t.isUserEvent("input.type")?this.composing=2:2==this.composing&&t.selection&&(this.composing=3)}startUpdate(){this.debounceUpdate=-1,this.pendingStart=!1;let{state:e}=this.view,t=e.field(vP);for(let e of t.active)e.isPending&&!this.running.some(t=>t.active.source==e.source)&&this.startQuery(e);this.running.length&&t.open&&t.open.disabled&&(this.debounceAccept=setTimeout(()=>this.accept(),this.view.state.facet(ZD).updateSyncTime))}startQuery(e){let{state:t}=this.view,n=HD(t),r=new QD(t,n,e.explicit,this.view),i=new CP(e,r);this.running.push(i),Promise.resolve(e.source(r)).then(e=>{i.context.aborted||(i.done=e||null,this.scheduleAccept())},e=>{this.view.dispatch({effects:XD.of(null)}),Ax(this.view.state,e)})}scheduleAccept(){this.running.every(e=>void 0!==e.done)?this.accept():this.debounceAccept<0&&(this.debounceAccept=setTimeout(()=>this.accept(),this.view.state.facet(ZD).updateSyncTime))}accept(){var e;this.debounceAccept>-1&&clearTimeout(this.debounceAccept),this.debounceAccept=-1;let t=[],n=this.view.state.facet(ZD),r=this.view.state.field(vP);for(let i=0;i<this.running.length;i++){let o=this.running[i];if(void 0===o.done)continue;if(this.running.splice(i--,1),o.done){let r=HD(o.updates.length?o.updates[0].startState:this.view.state),i=Math.min(r,o.done.from+(o.active.explicit?0:1)),s=new fP(o.active.source,o.active.explicit,i,o.done,o.done.from,null!==(e=o.done.to)&&void 0!==e?e:r);for(let e of o.updates)s=s.update(e,n);if(s.hasResult()){t.push(s);continue}}let s=r.active.find(e=>e.source==o.active.source);if(s&&s.isPending)if(null==o.done){let e=new pP(o.active.source,0);for(let t of o.updates)e=e.update(t,n);e.isPending||t.push(e)}else this.startQuery(s)}(t.length||r.open&&r.open.disabled)&&this.view.dispatch({effects:gP.of(t)})}},{eventHandlers:{blur(e){let t=this.view.state.field(vP,!1);if(t&&t.tooltip&&this.view.state.facet(ZD).closeOnBlur){let n=t.open&&VO(this.view,t.open.tooltip);n&&n.dom.contains(e.relatedTarget)||setTimeout(()=>this.view.dispatch({effects:XD.of(null)}),10)}},compositionstart(){this.composing=1},compositionend(){3==this.composing&&setTimeout(()=>this.view.dispatch({effects:GD.of(!1)}),20),this.composing=0}}}),kP="object"==typeof navigator&&/Win/.test(navigator.platform),SP=vy.highest(OS.domEventHandlers({keydown(e,t){let n=t.state.field(vP,!1);if(!n||!n.open||n.open.disabled||n.open.selected<0||e.key.length>1||e.ctrlKey&&(!kP||!e.altKey)||e.metaKey)return!1;let r=n.open.options[n.open.selected],i=n.active.find(e=>e.source==r.source),o=r.completion.commitCharacters||i.result.commitCharacters;return o&&o.indexOf(e.key)>-1&&bP(t,r),!1}})),OP=OS.baseTheme({".cm-tooltip.cm-tooltip-autocomplete":{"& > ul":{fontFamily:"monospace",whiteSpace:"nowrap",overflow:"hidden auto",maxWidth_fallback:"700px",maxWidth:"min(700px, 95vw)",minWidth:"250px",maxHeight:"10em",height:"100%",listStyle:"none",margin:0,padding:0,"& > li, & > completion-section":{padding:"1px 3px",lineHeight:1.2},"& > li":{overflowX:"hidden",textOverflow:"ellipsis",cursor:"pointer"},"& > completion-section":{display:"list-item",borderBottom:"1px solid silver",paddingLeft:"0.5em",opacity:.7}}},"&light .cm-tooltip-autocomplete ul li[aria-selected]":{background:"#17c",color:"white"},"&light .cm-tooltip-autocomplete-disabled ul li[aria-selected]":{background:"#777"},"&dark .cm-tooltip-autocomplete ul li[aria-selected]":{background:"#347",color:"white"},"&dark .cm-tooltip-autocomplete-disabled ul li[aria-selected]":{background:"#444"},".cm-completionListIncompleteTop:before, .cm-completionListIncompleteBottom:after":{content:'"···"',opacity:.5,display:"block",textAlign:"center"},".cm-tooltip.cm-completionInfo":{position:"absolute",padding:"3px 9px",width:"max-content",maxWidth:"400px",boxSizing:"border-box",whiteSpace:"pre-line"},".cm-completionInfo.cm-completionInfo-left":{right:"100%"},".cm-completionInfo.cm-completionInfo-right":{left:"100%"},".cm-completionInfo.cm-completionInfo-left-narrow":{right:"30px"},".cm-completionInfo.cm-completionInfo-right-narrow":{left:"30px"},"&light .cm-snippetField":{backgroundColor:"#00000022"},"&dark .cm-snippetField":{backgroundColor:"#ffffff22"},".cm-snippetFieldPosition":{verticalAlign:"text-top",width:0,height:"1.15em",display:"inline-block",margin:"0 -0.7px -.7em",borderLeft:"1.4px dotted #888"},".cm-completionMatchedText":{textDecoration:"underline"},".cm-completionDetail":{marginLeft:"0.5em",fontStyle:"italic"},".cm-completionIcon":{fontSize:"90%",width:".8em",display:"inline-block",textAlign:"center",paddingRight:".6em",opacity:"0.6",boxSizing:"content-box"},".cm-completionIcon-function, .cm-completionIcon-method":{"&:after":{content:"'ƒ'"}},".cm-completionIcon-class":{"&:after":{content:"'○'"}},".cm-completionIcon-interface":{"&:after":{content:"'◌'"}},".cm-completionIcon-variable":{"&:after":{content:"'𝑥'"}},".cm-completionIcon-constant":{"&:after":{content:"'𝐶'"}},".cm-completionIcon-type":{"&:after":{content:"'𝑡'"}},".cm-completionIcon-enum":{"&:after":{content:"'∪'"}},".cm-completionIcon-property":{"&:after":{content:"'□'"}},".cm-completionIcon-keyword":{"&:after":{content:"'🔑︎'"}},".cm-completionIcon-namespace":{"&:after":{content:"'▢'"}},".cm-completionIcon-text":{"&:after":{content:"'abc'",fontSize:"50%",verticalAlign:"middle"}}});const BP={brackets:["(","[","{","'",'"'],before:")]}:;>",stringPrefixes:[]},_P=Ry.define({map(e,t){let n=t.mapPos(e,-1,qA.TrackAfter);return null==n?void 0:n}}),TP=new class extends Yy{};TP.startSide=1,TP.endSide=-1;const EP=dy.define({create:()=>Ky.empty,update(e,t){if(e=e.map(t.changes),t.selection){let n=t.state.doc.lineAt(t.selection.main.head);e=e.update({filter:e=>e>=n.from&&e<=n.to})}for(let n of t.effects)n.is(_P)&&(e=e.update({add:[TP.range(n.value,n.value+1)]}));return e}});const MP="()[]{}<>«»»«［］｛｝";function DP(e){for(let t=0;t<16;t+=2)if(MP.charCodeAt(t)==e)return MP.charAt(t+1);return $A(e<128?e:e+1)}function PP(e,t){return e.languageDataAt("closeBrackets",t)[0]||BP}const RP="object"==typeof navigator&&/Android\b/.test(navigator.userAgent),IP=OS.inputHandler.of((e,t,n,r)=>{if((RP?e.composing:e.compositionStarted)||e.state.readOnly)return!1;let i=e.state.selection.main;if(r.length>2||2==r.length&&1==HA(zA(r,0))||t!=i.from||n!=i.to)return!1;let o=function(e,t){let n=PP(e,e.selection.main.head),r=n.brackets||BP.brackets;for(let i of r){let o=DP(zA(i,0));if(t==i)return o==i?zP(e,i,r.indexOf(i+i+i)>-1,n):QP(e,i,o,n.before||BP.before);if(t==o&&NP(e,e.selection.main.from))return VP(e,i,o)}return null}(e.state,r);return!!o&&(e.dispatch(o),!0)}),LP=[{key:"Backspace",run:({state:e,dispatch:t})=>{if(e.readOnly)return!1;let n=PP(e,e.selection.main.head).brackets||BP.brackets,r=null,i=e.changeByRange(t=>{if(t.empty){let r=function(e,t){let n=e.sliceString(t-2,t);return HA(zA(n,0))==n.length?n:n.slice(1)}(e.doc,t.head);for(let i of n)if(i==r&&FP(e.doc,t.head)==DP(zA(i,0)))return{changes:{from:t.head-i.length,to:t.head+i.length},range:ty.cursor(t.head-i.length)}}return{range:r=t}});return r||t(e.update(i,{scrollIntoView:!0,userEvent:"delete.backward"})),!r}}];function NP(e,t){let n=!1;return e.field(EP).between(0,e.doc.length,e=>{e==t&&(n=!0)}),n}function FP(e,t){let n=e.sliceString(t,t+2);return n.slice(0,HA(zA(n,0)))}function QP(e,t,n,r){let i=null,o=e.changeByRange(o=>{if(!o.empty)return{changes:[{insert:t,from:o.from},{insert:n,from:o.to}],effects:_P.of(o.to+t.length),range:ty.range(o.anchor+t.length,o.head+t.length)};let s=FP(e.doc,o.head);return!s||/\s/.test(s)||r.indexOf(s)>-1?{changes:{insert:t+n,from:o.head},effects:_P.of(o.head+t.length),range:ty.cursor(o.head+t.length)}:{range:i=o}});return i?null:e.update(o,{scrollIntoView:!0,userEvent:"input.type"})}function VP(e,t,n){let r=null,i=e.changeByRange(t=>t.empty&&FP(e.doc,t.head)==n?{changes:{from:t.head,to:t.head+n.length,insert:n},range:ty.cursor(t.head+n.length)}:r={range:t});return r?null:e.update(i,{scrollIntoView:!0,userEvent:"input.type"})}function zP(e,t,n,r){let i=r.stringPrefixes||BP.stringPrefixes,o=null,s=e.changeByRange(r=>{if(!r.empty)return{changes:[{insert:t,from:r.from},{insert:t,from:r.to}],effects:_P.of(r.to+t.length),range:ty.range(r.anchor+t.length,r.head+t.length)};let s,a=r.head,l=FP(e.doc,a);if(l==t){if($P(e,a))return{changes:{insert:t+t,from:a},effects:_P.of(a+t.length),range:ty.cursor(a+t.length)};if(NP(e,a)){let r=n&&e.sliceDoc(a,a+3*t.length)==t+t+t?t+t+t:t;return{changes:{from:a,to:a+r.length,insert:r},range:ty.cursor(a+r.length)}}}else{if(n&&e.sliceDoc(a-2*t.length,a)==t+t&&(s=HP(e,a-2*t.length,i))>-1&&$P(e,s))return{changes:{insert:t+t+t+t,from:a},effects:_P.of(a+t.length),range:ty.cursor(a+t.length)};if(e.charCategorizer(a)(l)!=$y.Word&&HP(e,a,i)>-1&&!function(e,t,n,r){let i=E_(e).resolveInner(t,-1),o=r.reduce((e,t)=>Math.max(e,t.length),0);for(let s=0;s<5;s++){let s=e.sliceDoc(i.from,Math.min(i.to,i.from+n.length+o)),a=s.indexOf(n);if(!a||a>-1&&r.indexOf(s.slice(0,a))>-1){let t=i.firstChild;for(;t&&t.from==i.from&&t.to-t.from>n.length+a;){if(e.sliceDoc(t.to-n.length,t.to)==n)return!1;t=t.firstChild}return!0}let l=i.to==t&&i.parent;if(!l)break;i=l}return!1}(e,a,t,i))return{changes:{insert:t+t,from:a},effects:_P.of(a+t.length),range:ty.cursor(a+t.length)}}return{range:o=r}});return o?null:e.update(s,{scrollIntoView:!0,userEvent:"input.type"})}function $P(e,t){let n=E_(e).resolveInner(t+1);return n.parent&&n.from==t}function HP(e,t,n){let r=e.charCategorizer(t);if(r(e.sliceDoc(t-1,t))!=$y.Word)return t;for(let i of n){let n=t-i.length;if(e.sliceDoc(n,t)==i&&r(e.sliceDoc(n-1,n))!=$y.Word)return n}return-1}function jP(e={}){return[SP,vP,ZD.of(e),xP,WP,OP]}const qP=[{key:"Ctrl-Space",run:wP},{mac:"Alt-`",run:wP},{mac:"Alt-i",run:wP},{key:"Escape",run:e=>{let t=e.state.field(vP,!1);return!(!t||!t.active.some(e=>0!=e.state))&&(e.dispatch({effects:XD.of(null)}),!0)}},{key:"ArrowDown",run:yP(!0)},{key:"ArrowUp",run:yP(!1)},{key:"PageDown",run:yP(!0,"page")},{key:"PageUp",run:yP(!1,"page")},{key:"Enter",run:e=>{let t=e.state.field(vP,!1);return!(e.state.readOnly||!t||!t.open||t.open.selected<0||t.open.disabled||Date.now()-t.open.timestamp<e.state.facet(ZD).interactionDelay)&&bP(e,t.open.options[t.open.selected])}}],WP=vy.highest(RS.computeN([ZD],e=>e.facet(ZD).defaultKeymap?[qP]:[]));class UP{constructor(e,t,n){this.from=e,this.to=t,this.diagnostic=n}}class YP{constructor(e,t,n){this.diagnostics=e,this.panel=t,this.selected=n}static init(e,t,n){let r=n.facet(aR).markerFilter;r&&(e=r(e,n));let i=e.slice().sort((e,t)=>e.from-t.from||e.to-t.to),o=new Zy,s=[],a=0;for(let e=0;;){let t,r,l=e==i.length?null:i[e];if(!l&&!s.length)break;for(s.length?(t=a,r=s.reduce((e,t)=>Math.min(e,t.to),l&&l.from>t?l.from:1e8)):(t=l.from,r=l.to,s.push(l),e++);e<i.length;){let n=i[e];if(n.from!=t||!(n.to>n.from||n.to==t)){r=Math.min(n.from,r);break}s.push(n),e++,r=Math.min(n.to,r)}let c=bR(s);if(s.some(e=>e.from==e.to||e.from==e.to-1&&n.doc.lineAt(e.from).to==e.from))o.add(t,t,OC.widget({widget:new dR(c),diagnostics:s.slice()}));else{let e=s.reduce((e,t)=>t.markClass?e+" "+t.markClass:e,"");o.add(t,r,OC.mark({class:"cm-lintRange cm-lintRange-"+c+e,diagnostics:s.slice(),inclusiveEnd:s.some(e=>e.to>r)}))}a=r;for(let e=0;e<s.length;e++)s[e].to<=a&&s.splice(e--,1)}let l=o.finish();return new YP(l,t,GP(l))}}function GP(e,t=null,n=0){let r=null;return e.between(n,1e9,(e,n,{spec:i})=>{if(!(t&&i.diagnostics.indexOf(t)<0))if(r){if(i.diagnostics.indexOf(r.diagnostic)<0)return!1;r=new UP(r.from,n,r.diagnostic)}else r=new UP(e,n,t||i.diagnostics[0])}),r}function XP(e,t){let n=t.pos,r=t.end||n,i=e.state.facet(aR).hideOn(e,n,r);if(null!=i)return i;let o=e.startState.doc.lineAt(t.pos);return!(!e.effects.some(e=>e.is(KP))&&!e.changes.touchesRange(o.from,Math.max(o.to,r)))}function JP(e,t){return e.field(tR,!1)?t:t.concat(Ry.appendConfig.of(AR))}const KP=Ry.define(),ZP=Ry.define(),eR=Ry.define(),tR=dy.define({create:()=>new YP(OC.none,null,null),update(e,t){if(t.docChanged&&e.diagnostics.size){let n=e.diagnostics.map(t.changes),r=null,i=e.panel;if(e.selected){let i=t.changes.mapPos(e.selected.from,1);r=GP(n,e.selected.diagnostic,i)||GP(n,null,i)}!n.size&&i&&t.state.facet(aR).autoPanel&&(i=null),e=new YP(n,i,r)}for(let n of t.effects)if(n.is(KP)){let r=t.state.facet(aR).autoPanel?n.value.length?pR.open:null:e.panel;e=YP.init(n.value,r,t.state)}else n.is(ZP)?e=new YP(e.diagnostics,n.value?pR.open:null,e.selected):n.is(eR)&&(e=new YP(e.diagnostics,e.panel,n.value));return e},provide:e=>[UO.from(e,e=>e.panel),OS.decorations.from(e,e=>e.diagnostics)]});const nR=OC.mark({class:"cm-lintRange cm-lintRange-active"});function rR(e,t,n){let r,{diagnostics:i}=e.state.field(tR),o=-1,s=-1;i.between(t-(n<0?1:0),t+(n>0?1:0),(e,i,{spec:a})=>{if(t>=e&&t<=i&&(e==i||(t>e||n>0)&&(t<i||n<0)))return r=a.diagnostics,o=e,s=i,!1});let a=e.state.facet(aR).tooltipFilter;return r&&a&&(r=a(r,e.state)),r?{pos:o,end:s,above:e.state.doc.lineAt(o).to<s,create:()=>({dom:iR(e,r)})}:null}function iR(e,t){return RM("ul",{class:"cm-tooltip-lint"},t.map(t=>hR(e,t,!1)))}const oR=e=>{let t=e.state.field(tR,!1);return!(!t||!t.panel)&&(e.dispatch({effects:ZP.of(!1)}),!0)},sR=[{key:"Mod-Shift-m",run:e=>{let t=e.state.field(tR,!1);t&&t.panel||e.dispatch({effects:JP(e.state,[ZP.of(!0)])});let n=HO(e,pR.open);return n&&n.dom.querySelector(".cm-panel-lint ul").focus(),!0},preventDefault:!0},{key:"F8",run:e=>{let t=e.state.field(tR,!1);if(!t)return!1;let n=e.state.selection.main,r=t.diagnostics.iter(n.to+1);return!(!r.value&&(r=t.diagnostics.iter(0),!r.value||r.from==n.from&&r.to==n.to))&&(e.dispatch({selection:{anchor:r.from,head:r.to},scrollIntoView:!0}),!0)}}];const aR=iy.define({combine:e=>({sources:e.map(e=>e.source).filter(e=>null!=e),...Uy(e.map(e=>e.config),{delay:750,markerFilter:null,tooltipFilter:null,needsRefresh:null,hideOn:()=>null},{delay:Math.max,markerFilter:lR,tooltipFilter:lR,needsRefresh:(e,t)=>e?t?n=>e(n)||t(n):e:t,hideOn:(e,t)=>e?t?(n,r,i)=>e(n,r,i)||t(n,r,i):e:t,autoPanel:(e,t)=>e||t})})});function lR(e,t){return e?t?(n,r)=>t(e(n,r),r):e:t}function cR(e){let t=[];if(e)e:for(let{name:n}of e){for(let e=0;e<n.length;e++){let r=n[e];if(/[a-zA-Z]/.test(r)&&!t.some(e=>e.toLowerCase()==r.toLowerCase())){t.push(r);continue e}}t.push("")}return t}function hR(e,t,n){var r;let i=n?cR(t.actions):[];return RM("li",{class:"cm-diagnostic cm-diagnostic-"+t.severity},RM("span",{class:"cm-diagnosticText"},t.renderMessage?t.renderMessage(e):t.message),null===(r=t.actions)||void 0===r?void 0:r.map((n,r)=>{let o=!1,s=r=>{if(r.preventDefault(),o)return;o=!0;let i=GP(e.state.field(tR).diagnostics,t);i&&n.apply(e,i.from,i.to)},{name:a}=n,l=i[r]?a.indexOf(i[r]):-1,c=l<0?a:[a.slice(0,l),RM("u",a.slice(l,l+1)),a.slice(l+1)];return RM("button",{type:"button",class:"cm-diagnosticAction"+(n.markClass?" "+n.markClass:""),onclick:s,onmousedown:s,"aria-label":` Action: ${a}${l<0?"":` (access key "${i[r]})"`}.`},c)}),t.source&&RM("div",{class:"cm-diagnosticSource"},t.source))}class dR extends kC{constructor(e){super(),this.sev=e}eq(e){return e.sev==this.sev}toDOM(){return RM("span",{class:"cm-lintPoint cm-lintPoint-"+this.sev})}}class uR{constructor(e,t){this.diagnostic=t,this.id="item_"+Math.floor(4294967295*Math.random()).toString(16),this.dom=hR(e,t,!0),this.dom.id=this.id,this.dom.setAttribute("role","option")}}class pR{constructor(e){this.view=e,this.items=[];this.list=RM("ul",{tabIndex:0,role:"listbox","aria-label":this.view.state.phrase("Diagnostics"),onkeydown:t=>{if(27==t.keyCode)oR(this.view),this.view.focus();else if(38==t.keyCode||33==t.keyCode)this.moveSelection((this.selectedIndex-1+this.items.length)%this.items.length);else if(40==t.keyCode||34==t.keyCode)this.moveSelection((this.selectedIndex+1)%this.items.length);else if(36==t.keyCode)this.moveSelection(0);else if(35==t.keyCode)this.moveSelection(this.items.length-1);else if(13==t.keyCode)this.view.focus();else{if(!(t.keyCode>=65&&t.keyCode<=90&&this.selectedIndex>=0))return;{let{diagnostic:n}=this.items[this.selectedIndex],r=cR(n.actions);for(let i=0;i<r.length;i++)if(r[i].toUpperCase().charCodeAt(0)==t.keyCode){let t=GP(this.view.state.field(tR).diagnostics,n);t&&n.actions[i].apply(e,t.from,t.to)}}}t.preventDefault()},onclick:e=>{for(let t=0;t<this.items.length;t++)this.items[t].dom.contains(e.target)&&this.moveSelection(t)}}),this.dom=RM("div",{class:"cm-panel-lint"},this.list,RM("button",{type:"button",name:"close","aria-label":this.view.state.phrase("close"),onclick:()=>oR(this.view)},"×")),this.update()}get selectedIndex(){let e=this.view.state.field(tR).selected;if(!e)return-1;for(let t=0;t<this.items.length;t++)if(this.items[t].diagnostic==e.diagnostic)return t;return-1}update(){let{diagnostics:e,selected:t}=this.view.state.field(tR),n=0,r=!1,i=null,o=new Set;for(e.between(0,this.view.state.doc.length,(e,s,{spec:a})=>{for(let e of a.diagnostics){if(o.has(e))continue;o.add(e);let s,a=-1;for(let t=n;t<this.items.length;t++)if(this.items[t].diagnostic==e){a=t;break}a<0?(s=new uR(this.view,e),this.items.splice(n,0,s),r=!0):(s=this.items[a],a>n&&(this.items.splice(n,a-n),r=!0)),t&&s.diagnostic==t.diagnostic?s.dom.hasAttribute("aria-selected")||(s.dom.setAttribute("aria-selected","true"),i=s):s.dom.hasAttribute("aria-selected")&&s.dom.removeAttribute("aria-selected"),n++}});n<this.items.length&&!(1==this.items.length&&this.items[0].diagnostic.from<0);)r=!0,this.items.pop();0==this.items.length&&(this.items.push(new uR(this.view,{from:-1,to:-1,severity:"info",message:this.view.state.phrase("No diagnostics")})),r=!0),i?(this.list.setAttribute("aria-activedescendant",i.id),this.view.requestMeasure({key:this,read:()=>({sel:i.dom.getBoundingClientRect(),panel:this.list.getBoundingClientRect()}),write:({sel:e,panel:t})=>{let n=t.height/this.list.offsetHeight;e.top<t.top?this.list.scrollTop-=(t.top-e.top)/n:e.bottom>t.bottom&&(this.list.scrollTop+=(e.bottom-t.bottom)/n)}})):this.selectedIndex<0&&this.list.removeAttribute("aria-activedescendant"),r&&this.sync()}sync(){let e=this.list.firstChild;function t(){let t=e;e=t.nextSibling,t.remove()}for(let n of this.items)if(n.dom.parentNode==this.list){for(;e!=n.dom;)t();e=n.dom.nextSibling}else this.list.insertBefore(n.dom,e);for(;e;)t()}moveSelection(e){if(this.selectedIndex<0)return;let t=GP(this.view.state.field(tR).diagnostics,this.items[e].diagnostic);t&&this.view.dispatch({selection:{anchor:t.from,head:t.to},scrollIntoView:!0,effects:eR.of(t)})}static open(e){return new pR(e)}}function fR(e,t='viewBox="0 0 40 40"'){return`url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" ${t}>${encodeURIComponent(e)}</svg>')`}function gR(e){return fR(`<path d="m0 2.5 l2 -1.5 l1 0 l2 1.5 l1 0" stroke="${e}" fill="none" stroke-width=".7"/>`,'width="6" height="3"')}const mR=OS.baseTheme({".cm-diagnostic":{padding:"3px 6px 3px 8px",marginLeft:"-1px",display:"block",whiteSpace:"pre-wrap"},".cm-diagnostic-error":{borderLeft:"5px solid #d11"},".cm-diagnostic-warning":{borderLeft:"5px solid orange"},".cm-diagnostic-info":{borderLeft:"5px solid #999"},".cm-diagnostic-hint":{borderLeft:"5px solid #66d"},".cm-diagnosticAction":{font:"inherit",border:"none",padding:"2px 4px",backgroundColor:"#444",color:"white",borderRadius:"3px",marginLeft:"8px",cursor:"pointer"},".cm-diagnosticSource":{fontSize:"70%",opacity:.7},".cm-lintRange":{backgroundPosition:"left bottom",backgroundRepeat:"repeat-x",paddingBottom:"0.7px"},".cm-lintRange-error":{backgroundImage:gR("#d11")},".cm-lintRange-warning":{backgroundImage:gR("orange")},".cm-lintRange-info":{backgroundImage:gR("#999")},".cm-lintRange-hint":{backgroundImage:gR("#66d")},".cm-lintRange-active":{backgroundColor:"#ffdd9980"},".cm-tooltip-lint":{padding:0,margin:0},".cm-lintPoint":{position:"relative","&:after":{content:'""',position:"absolute",bottom:0,left:"-2px",borderLeft:"3px solid transparent",borderRight:"3px solid transparent",borderBottom:"4px solid #d11"}},".cm-lintPoint-warning":{"&:after":{borderBottomColor:"orange"}},".cm-lintPoint-info":{"&:after":{borderBottomColor:"#999"}},".cm-lintPoint-hint":{"&:after":{borderBottomColor:"#66d"}},".cm-panel.cm-panel-lint":{position:"relative","& ul":{maxHeight:"100px",overflowY:"auto","& [aria-selected]":{backgroundColor:"#ddd","& u":{textDecoration:"underline"}},"&:focus [aria-selected]":{background_fallback:"#bdf",backgroundColor:"Highlight",color_fallback:"white",color:"HighlightText"},"& u":{textDecoration:"none"},padding:0,margin:0},"& [name=close]":{position:"absolute",top:"0",right:"2px",background:"inherit",border:"none",font:"inherit",padding:0,margin:0}}});function vR(e){return"error"==e?4:"warning"==e?3:"info"==e?2:1}function bR(e){let t="hint",n=1;for(let r of e){let e=vR(r.severity);e>n&&(n=e,t=r.severity)}return t}const AR=[tR,OS.decorations.compute([tR],e=>{let{selected:t,panel:n}=e.field(tR);return t&&n&&t.from!=t.to?OC.set([nR.range(t.from,t.to)]):OC.none}),QO(rR,{hideOn:XP}),mR];const yR=(()=>[fB(),vB,hO(),fE(),kT(),YS(),[tO,nO],Wy.allowMultipleSelections.of(!0),Wy.transactionFilter.of(e=>{if(!e.docChanged||!e.isUserEvent("input.type")&&!e.isUserEvent("input.complete"))return e;let t=e.startState.languageDataAt("indentOnInput",e.startState.selection.main.head);if(!t.length)return e;let n=e.newDoc,{head:r}=e.newSelection.main,i=n.lineAt(r);if(r>i.from+200)return e;let o=n.sliceString(i.from,r);if(!t.some(e=>e.test(o)))return e;let{state:s}=e,a=-1,l=[];for(let{head:e}of s.selection.ranges){let t=s.doc.lineAt(e);if(t.from==a)continue;a=t.from;let n=q_(s,t.from);if(null==n)continue;let r=/^\s*/.exec(t.text)[0],i=j_(s,n);r!=i&&l.push({from:t.from,to:t.from+r.length,insert:i})}return l.length?[e,{changes:l,sequential:!0}]:e}),ET(PT,{fallback:!0}),$T(),[IP,EP],jP(),yO(),xO(),gO,JM(),RS.of([...LP,...DM,...MD,...ME,...gT,...qP,...sR])])();var wR,CR,xR=Object.freeze({autofocus:!1,disabled:!1,indentWithTab:!0,tabSize:2,placeholder:"",autoDestroy:!0,extensions:[yR]}),kR=Symbol("vue-codemirror-global-config"),SR=function(e){var t=new Ay;return{compartment:t,run:function(n){t.get(e.state)?e.dispatch({effects:t.reconfigure(n)}):e.dispatch({effects:Ry.appendConfig.of(t.of(n))})}}},OR=function(e,t){var n=SR(e),r=n.compartment,i=n.run;return function(n){var o=r.get(e.state);i((null!=n?n:o!==t)?t:[])}},BR={type:Boolean,default:void 0},_R={autofocus:BR,disabled:BR,indentWithTab:BR,tabSize:Number,placeholder:String,style:Object,autoDestroy:BR,phrases:Object,root:Object,extensions:Array,selection:Object},TR={modelValue:{type:String,default:""}},ER=Object.assign(Object.assign({},_R),TR);(CR=wR||(wR={})).Change="change",CR.Update="update",CR.Focus="focus",CR.Blur="blur",CR.Ready="ready",CR.ModelUpdate="update:modelValue";var MR={};MR[wR.Change]=function(e,t){return!0},MR[wR.Update]=function(e){return!0},MR[wR.Focus]=function(e){return!0},MR[wR.Blur]=function(e){return!0},MR[wR.Ready]=function(e){return!0};var DR={};DR[wR.ModelUpdate]=MR[wR.Change];var PR=Object.assign(Object.assign({},MR),DR),RR=Er({name:"VueCodemirror",props:Object.assign({},ER),emits:Object.assign({},PR),setup:function(e,t){var n=Yt(),r=Yt(),i=Yt(),o=Object.assign(Object.assign({},xR),xo(kR,{})),s=Ea(function(){var t={};return Object.keys($t(e)).forEach(function(n){var r;"modelValue"!==n&&(t[n]=null!==(r=e[n])&&void 0!==r?r:o[n])}),t});return vi(function(){var a;r.value=function(e){var t=e.onUpdate,n=e.onChange,r=e.onFocus,i=e.onBlur,o=function(e,t){var n={};for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&t.indexOf(r)<0&&(n[r]=e[r]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var i=0;for(r=Object.getOwnPropertySymbols(e);i<r.length;i++)t.indexOf(r[i])<0&&Object.prototype.propertyIsEnumerable.call(e,r[i])&&(n[r[i]]=e[r[i]])}return n}(e,["onUpdate","onChange","onFocus","onBlur"]);return Wy.create({doc:o.doc,selection:o.selection,extensions:(Array.isArray(o.extensions)?o.extensions:[o.extensions]).concat([OS.updateListener.of(function(e){t(e),e.docChanged&&n(e.state.doc.toString(),e),e.focusChanged&&(e.view.hasFocus?r(e):i(e))})])})}({doc:e.modelValue,selection:s.value.selection,extensions:null!==(a=o.extensions)&&void 0!==a?a:[],onFocus:function(e){return t.emit(wR.Focus,e)},onBlur:function(e){return t.emit(wR.Blur,e)},onUpdate:function(e){return t.emit(wR.Update,e)},onChange:function(n,r){n!==e.modelValue&&(t.emit(wR.Change,n,r),t.emit(wR.ModelUpdate,n,r))}}),i.value=function(e){return new OS(Object.assign({},e))}({state:r.value,parent:n.value,root:s.value.root});var l=function(e){var t=function(){return e.state.doc.toString()},n=SR(e).run,r=OR(e,[OS.editable.of(!1),Wy.readOnly.of(!0)]),i=OR(e,RS.of([PM])),o=SR(e).run,s=SR(e).run,a=SR(e).run,l=SR(e).run;return{focus:function(){return e.focus()},getDoc:t,setDoc:function(n){n!==t()&&e.dispatch({changes:{from:0,to:e.state.doc.length,insert:n}})},reExtensions:n,toggleDisabled:r,toggleIndentWithTab:i,setTabSize:function(e){o([Wy.tabSize.of(e),$_.of(" ".repeat(e))])},setPhrases:function(e){s([Wy.phrases.of(e)])},setPlaceholder:function(e){a(function(e){let t=xx.fromClass(class{constructor(t){this.view=t,this.placeholder=e?OC.set([OC.widget({widget:new mO(e),side:1}).range(0)]):OC.none}get decorations(){return this.view.state.doc.length?OC.none:this.placeholder}},{decorations:e=>e.decorations});return"string"==typeof e?[t,OS.contentAttributes.of({"aria-placeholder":e})]:t}(e))},setStyle:function(e){void 0===e&&(e={}),l(OS.theme({"&":Object.assign({},e)}))}}}(i.value);ns(function(){return e.modelValue},function(e){e!==l.getDoc()&&l.setDoc(e)}),ns(function(){return e.extensions},function(e){return l.reExtensions(e||[])},{immediate:!0}),ns(function(){return s.value.disabled},function(e){return l.toggleDisabled(e)},{immediate:!0}),ns(function(){return s.value.indentWithTab},function(e){return l.toggleIndentWithTab(e)},{immediate:!0}),ns(function(){return s.value.tabSize},function(e){return l.setTabSize(e)},{immediate:!0}),ns(function(){return s.value.phrases},function(e){return l.setPhrases(e||{})},{immediate:!0}),ns(function(){return s.value.placeholder},function(e){return l.setPlaceholder(e)},{immediate:!0}),ns(function(){return s.value.style},function(e){return l.setStyle(e)},{immediate:!0}),s.value.autofocus&&l.focus(),t.emit(wR.Ready,{state:r.value,view:i.value,container:n.value})}),yi(function(){s.value.autoDestroy&&i.value&&function(e){e.destroy()}(i.value)}),function(){return Ma("div",{class:"v-codemirror",style:{display:"contents"},ref:n})}}}),IR=RR,LR=n(606);class NR{constructor(e,t,n,r,i,o,s,a,l,c=0,h){this.p=e,this.stack=t,this.state=n,this.reducePos=r,this.pos=i,this.score=o,this.buffer=s,this.bufferBase=a,this.curContext=l,this.lookAhead=c,this.parent=h}toString(){return`[${this.stack.filter((e,t)=>t%3==0).concat(this.state)}]@${this.pos}${this.score?"!"+this.score:""}`}static start(e,t,n=0){let r=e.parser.context;return new NR(e,[],t,n,n,0,[],0,r?new FR(r,r.start):null,0,null)}get context(){return this.curContext?this.curContext.context:null}pushState(e,t){this.stack.push(this.state,t,this.bufferBase+this.buffer.length),this.state=e}reduce(e){var t;let n=e>>19,r=65535&e,{parser:i}=this.p,o=this.reducePos<this.pos-25;o&&this.setLookAhead(this.pos);let s=i.dynamicPrecedence(r);if(s&&(this.score+=s),0==n)return this.pushState(i.getGoto(this.state,r,!0),this.reducePos),r<i.minRepeatTerm&&this.storeNode(r,this.reducePos,this.reducePos,o?8:4,!0),void this.reduceContext(r,this.reducePos);let a=this.stack.length-3*(n-1)-(262144&e?6:0),l=a?this.stack[a-2]:this.p.ranges[0].from,c=this.reducePos-l;c>=2e3&&!(null===(t=this.p.parser.nodeSet.types[r])||void 0===t?void 0:t.isAnonymous)&&(l==this.p.lastBigReductionStart?(this.p.bigReductionCount++,this.p.lastBigReductionSize=c):this.p.lastBigReductionSize<c&&(this.p.bigReductionCount=1,this.p.lastBigReductionStart=l,this.p.lastBigReductionSize=c));let h=a?this.stack[a-1]:0,d=this.bufferBase+this.buffer.length-h;if(r<i.minRepeatTerm||131072&e){let e=i.stateFlag(this.state,1)?this.pos:this.reducePos;this.storeNode(r,l,e,d+4,!0)}if(262144&e)this.state=this.stack[a];else{let e=this.stack[a-3];this.state=i.getGoto(e,r,!0)}for(;this.stack.length>a;)this.stack.pop();this.reduceContext(r,l)}storeNode(e,t,n,r=4,i=!1){if(0==e&&(!this.stack.length||this.stack[this.stack.length-1]<this.buffer.length+this.bufferBase)){let e=this,r=this.buffer.length;if(0==r&&e.parent&&(r=e.bufferBase-e.parent.bufferBase,e=e.parent),r>0&&0==e.buffer[r-4]&&e.buffer[r-1]>-1){if(t==n)return;if(e.buffer[r-2]>=t)return void(e.buffer[r-2]=n)}}if(i&&this.pos!=n){let i=this.buffer.length;if(i>0&&0!=this.buffer[i-4]){let e=!1;for(let t=i;t>0&&this.buffer[t-2]>n;t-=4)if(this.buffer[t-1]>=0){e=!0;break}if(e)for(;i>0&&this.buffer[i-2]>n;)this.buffer[i]=this.buffer[i-4],this.buffer[i+1]=this.buffer[i-3],this.buffer[i+2]=this.buffer[i-2],this.buffer[i+3]=this.buffer[i-1],i-=4,r>4&&(r-=4)}this.buffer[i]=e,this.buffer[i+1]=t,this.buffer[i+2]=n,this.buffer[i+3]=r}else this.buffer.push(e,t,n,r)}shift(e,t,n,r){if(131072&e)this.pushState(65535&e,this.pos);else if(262144&e)this.pos=r,this.shiftContext(t,n),t<=this.p.parser.maxNode&&this.buffer.push(t,n,r,4);else{let i=e,{parser:o}=this.p;(r>this.pos||t<=o.maxNode)&&(this.pos=r,o.stateFlag(i,1)||(this.reducePos=r)),this.pushState(i,n),this.shiftContext(t,n),t<=o.maxNode&&this.buffer.push(t,n,r,4)}}apply(e,t,n,r){65536&e?this.reduce(e):this.shift(e,t,n,r)}useNode(e,t){let n=this.p.reused.length-1;(n<0||this.p.reused[n]!=e)&&(this.p.reused.push(e),n++);let r=this.pos;this.reducePos=this.pos=r+e.length,this.pushState(t,r),this.buffer.push(n,r,this.reducePos,-1),this.curContext&&this.updateContext(this.curContext.tracker.reuse(this.curContext.context,e,this,this.p.stream.reset(this.pos-e.length)))}split(){let e=this,t=e.buffer.length;for(;t>0&&e.buffer[t-2]>e.reducePos;)t-=4;let n=e.buffer.slice(t),r=e.bufferBase+t;for(;e&&r==e.bufferBase;)e=e.parent;return new NR(this.p,this.stack.slice(),this.state,this.reducePos,this.pos,this.score,n,r,this.curContext,this.lookAhead,e)}recoverByDelete(e,t){let n=e<=this.p.parser.maxNode;n&&this.storeNode(e,this.pos,t,4),this.storeNode(0,this.pos,t,n?8:4),this.pos=this.reducePos=t,this.score-=190}canShift(e){for(let t=new QR(this);;){let n=this.p.parser.stateSlot(t.state,4)||this.p.parser.hasAction(t.state,e);if(0==n)return!1;if(!(65536&n))return!0;t.reduce(n)}}recoverByInsert(e){if(this.stack.length>=300)return[];let t=this.p.parser.nextStates(this.state);if(t.length>8||this.stack.length>=120){let n=[];for(let r,i=0;i<t.length;i+=2)(r=t[i+1])!=this.state&&this.p.parser.hasAction(r,e)&&n.push(t[i],r);if(this.stack.length<120)for(let e=0;n.length<8&&e<t.length;e+=2){let r=t[e+1];n.some((e,t)=>1&t&&e==r)||n.push(t[e],r)}t=n}let n=[];for(let e=0;e<t.length&&n.length<4;e+=2){let r=t[e+1];if(r==this.state)continue;let i=this.split();i.pushState(r,this.pos),i.storeNode(0,i.pos,i.pos,4,!0),i.shiftContext(t[e],this.pos),i.reducePos=this.pos,i.score-=200,n.push(i)}return n}forceReduce(){let{parser:e}=this.p,t=e.stateSlot(this.state,5);if(!(65536&t))return!1;if(!e.validAction(this.state,t)){let n=t>>19,r=65535&t,i=this.stack.length-3*n;if(i<0||e.getGoto(this.stack[i],r,!1)<0){let e=this.findForcedReduction();if(null==e)return!1;t=e}this.storeNode(0,this.pos,this.pos,4,!0),this.score-=100}return this.reducePos=this.pos,this.reduce(t),!0}findForcedReduction(){let{parser:e}=this.p,t=[],n=(r,i)=>{if(!t.includes(r))return t.push(r),e.allActions(r,t=>{if(393216&t);else if(65536&t){let n=(t>>19)-i;if(n>1){let r=65535&t,i=this.stack.length-3*n;if(i>=0&&e.getGoto(this.stack[i],r,!1)>=0)return n<<19|65536|r}}else{let e=n(t,i+1);if(null!=e)return e}})};return n(this.state,0)}forceAll(){for(;!this.p.parser.stateFlag(this.state,2);)if(!this.forceReduce()){this.storeNode(0,this.pos,this.pos,4,!0);break}return this}get deadEnd(){if(3!=this.stack.length)return!1;let{parser:e}=this.p;return 65535==e.data[e.stateSlot(this.state,1)]&&!e.stateSlot(this.state,4)}restart(){this.storeNode(0,this.pos,this.pos,4,!0),this.state=this.stack[0],this.stack.length=0}sameState(e){if(this.state!=e.state||this.stack.length!=e.stack.length)return!1;for(let t=0;t<this.stack.length;t+=3)if(this.stack[t]!=e.stack[t])return!1;return!0}get parser(){return this.p.parser}dialectEnabled(e){return this.p.parser.dialect.flags[e]}shiftContext(e,t){this.curContext&&this.updateContext(this.curContext.tracker.shift(this.curContext.context,e,this,this.p.stream.reset(t)))}reduceContext(e,t){this.curContext&&this.updateContext(this.curContext.tracker.reduce(this.curContext.context,e,this,this.p.stream.reset(t)))}emitContext(){let e=this.buffer.length-1;(e<0||-3!=this.buffer[e])&&this.buffer.push(this.curContext.hash,this.pos,this.pos,-3)}emitLookAhead(){let e=this.buffer.length-1;(e<0||-4!=this.buffer[e])&&this.buffer.push(this.lookAhead,this.pos,this.pos,-4)}updateContext(e){if(e!=this.curContext.context){let t=new FR(this.curContext.tracker,e);t.hash!=this.curContext.hash&&this.emitContext(),this.curContext=t}}setLookAhead(e){e>this.lookAhead&&(this.emitLookAhead(),this.lookAhead=e)}close(){this.curContext&&this.curContext.tracker.strict&&this.emitContext(),this.lookAhead>0&&this.emitLookAhead()}}class FR{constructor(e,t){this.tracker=e,this.context=t,this.hash=e.strict?e.hash(t):0}}class QR{constructor(e){this.start=e,this.state=e.state,this.stack=e.stack,this.base=this.stack.length}reduce(e){let t=65535&e,n=e>>19;0==n?(this.stack==this.start.stack&&(this.stack=this.stack.slice()),this.stack.push(this.state,0,0),this.base+=3):this.base-=3*(n-1);let r=this.start.p.parser.getGoto(this.stack[this.base-3],t,!0);this.state=r}}class VR{constructor(e,t,n){this.stack=e,this.pos=t,this.index=n,this.buffer=e.buffer,0==this.index&&this.maybeNext()}static create(e,t=e.bufferBase+e.buffer.length){return new VR(e,t,t-e.bufferBase)}maybeNext(){let e=this.stack.parent;null!=e&&(this.index=this.stack.bufferBase-e.bufferBase,this.stack=e,this.buffer=e.buffer)}get id(){return this.buffer[this.index-4]}get start(){return this.buffer[this.index-3]}get end(){return this.buffer[this.index-2]}get size(){return this.buffer[this.index-1]}next(){this.index-=4,this.pos-=4,0==this.index&&this.maybeNext()}fork(){return new VR(this.stack,this.pos,this.index)}}function zR(e,t=Uint16Array){if("string"!=typeof e)return e;let n=null;for(let r=0,i=0;r<e.length;){let o=0;for(;;){let t=e.charCodeAt(r++),n=!1;if(126==t){o=65535;break}t>=92&&t--,t>=34&&t--;let i=t-32;if(i>=46&&(i-=46,n=!0),o+=i,n)break;o*=46}n?n[i++]=o:n=new t(o)}return n}class $R{constructor(){this.start=-1,this.value=-1,this.end=-1,this.extended=-1,this.lookAhead=0,this.mask=0,this.context=0}}const HR=new $R;class jR{constructor(e,t){this.input=e,this.ranges=t,this.chunk="",this.chunkOff=0,this.chunk2="",this.chunk2Pos=0,this.next=-1,this.token=HR,this.rangeIndex=0,this.pos=this.chunkPos=t[0].from,this.range=t[0],this.end=t[t.length-1].to,this.readNext()}resolveOffset(e,t){let n=this.range,r=this.rangeIndex,i=this.pos+e;for(;i<n.from;){if(!r)return null;let e=this.ranges[--r];i-=n.from-e.to,n=e}for(;t<0?i>n.to:i>=n.to;){if(r==this.ranges.length-1)return null;let e=this.ranges[++r];i+=e.from-n.to,n=e}return i}clipPos(e){if(e>=this.range.from&&e<this.range.to)return e;for(let t of this.ranges)if(t.to>e)return Math.max(e,t.from);return this.end}peek(e){let t,n,r=this.chunkOff+e;if(r>=0&&r<this.chunk.length)t=this.pos+e,n=this.chunk.charCodeAt(r);else{let r=this.resolveOffset(e,1);if(null==r)return-1;if(t=r,t>=this.chunk2Pos&&t<this.chunk2Pos+this.chunk2.length)n=this.chunk2.charCodeAt(t-this.chunk2Pos);else{let e=this.rangeIndex,r=this.range;for(;r.to<=t;)r=this.ranges[++e];this.chunk2=this.input.chunk(this.chunk2Pos=t),t+this.chunk2.length>r.to&&(this.chunk2=this.chunk2.slice(0,r.to-t)),n=this.chunk2.charCodeAt(0)}}return t>=this.token.lookAhead&&(this.token.lookAhead=t+1),n}acceptToken(e,t=0){let n=t?this.resolveOffset(t,-1):this.pos;if(null==n||n<this.token.start)throw new RangeError("Token end out of bounds");this.token.value=e,this.token.end=n}acceptTokenTo(e,t){this.token.value=e,this.token.end=t}getChunk(){if(this.pos>=this.chunk2Pos&&this.pos<this.chunk2Pos+this.chunk2.length){let{chunk:e,chunkPos:t}=this;this.chunk=this.chunk2,this.chunkPos=this.chunk2Pos,this.chunk2=e,this.chunk2Pos=t,this.chunkOff=this.pos-this.chunkPos}else{this.chunk2=this.chunk,this.chunk2Pos=this.chunkPos;let e=this.input.chunk(this.pos),t=this.pos+e.length;this.chunk=t>this.range.to?e.slice(0,this.range.to-this.pos):e,this.chunkPos=this.pos,this.chunkOff=0}}readNext(){return this.chunkOff>=this.chunk.length&&(this.getChunk(),this.chunkOff==this.chunk.length)?this.next=-1:this.next=this.chunk.charCodeAt(this.chunkOff)}advance(e=1){for(this.chunkOff+=e;this.pos+e>=this.range.to;){if(this.rangeIndex==this.ranges.length-1)return this.setDone();e-=this.range.to-this.pos,this.range=this.ranges[++this.rangeIndex],this.pos=this.range.from}return this.pos+=e,this.pos>=this.token.lookAhead&&(this.token.lookAhead=this.pos+1),this.readNext()}setDone(){return this.pos=this.chunkPos=this.end,this.range=this.ranges[this.rangeIndex=this.ranges.length-1],this.chunk="",this.next=-1}reset(e,t){if(t?(this.token=t,t.start=e,t.lookAhead=e+1,t.value=t.extended=-1):this.token=HR,this.pos!=e){if(this.pos=e,e==this.end)return this.setDone(),this;for(;e<this.range.from;)this.range=this.ranges[--this.rangeIndex];for(;e>=this.range.to;)this.range=this.ranges[++this.rangeIndex];e>=this.chunkPos&&e<this.chunkPos+this.chunk.length?this.chunkOff=e-this.chunkPos:(this.chunk="",this.chunkOff=0),this.readNext()}return this}read(e,t){if(e>=this.chunkPos&&t<=this.chunkPos+this.chunk.length)return this.chunk.slice(e-this.chunkPos,t-this.chunkPos);if(e>=this.chunk2Pos&&t<=this.chunk2Pos+this.chunk2.length)return this.chunk2.slice(e-this.chunk2Pos,t-this.chunk2Pos);if(e>=this.range.from&&t<=this.range.to)return this.input.read(e,t);let n="";for(let r of this.ranges){if(r.from>=t)break;r.to>e&&(n+=this.input.read(Math.max(r.from,e),Math.min(r.to,t)))}return n}}class qR{constructor(e,t){this.data=e,this.id=t}token(e,t){let{parser:n}=t.p;YR(this.data,e,t,this.id,n.data,n.tokenPrecTable)}}qR.prototype.contextual=qR.prototype.fallback=qR.prototype.extend=!1;class WR{constructor(e,t,n){this.precTable=t,this.elseToken=n,this.data="string"==typeof e?zR(e):e}token(e,t){let n=e.pos,r=0;for(;;){let n=e.next<0,i=e.resolveOffset(1,1);if(YR(this.data,e,t,0,this.data,this.precTable),e.token.value>-1)break;if(null==this.elseToken)return;if(n||r++,null==i)break;e.reset(i,e.token)}r&&(e.reset(n,e.token),e.acceptToken(this.elseToken,r))}}WR.prototype.contextual=qR.prototype.fallback=qR.prototype.extend=!1;class UR{constructor(e,t={}){this.token=e,this.contextual=!!t.contextual,this.fallback=!!t.fallback,this.extend=!!t.extend}}function YR(e,t,n,r,i,o){let s=0,a=1<<r,{dialect:l}=n.p.parser;e:for(;0!=(a&e[s]);){let n=e[s+1];for(let r=s+3;r<n;r+=2)if((e[r+1]&a)>0){let n=e[r];if(l.allows(n)&&(-1==t.token.value||t.token.value==n||XR(n,t.token.value,i,o))){t.acceptToken(n);break}}let r=t.next,c=0,h=e[s+2];if(!(t.next<0&&h>c&&65535==e[n+3*h-3])){for(;c<h;){let i=c+h>>1,o=n+i+(i<<1),a=e[o],l=e[o+1]||65536;if(r<a)h=i;else{if(!(r>=l)){s=e[o+2],t.advance();continue e}c=i+1}}break}s=e[n+3*h-1]}}function GR(e,t,n){for(let r,i=t;65535!=(r=e[i]);i++)if(r==n)return i-t;return-1}function XR(e,t,n,r){let i=GR(n,r,t);return i<0||GR(n,r,e)<i}const JR=void 0!==LR&&LR.env&&/\bparse\b/.test(LR.env.LOG);let KR=null;function ZR(e,t,n){let r=e.cursor(_B.IncludeAnonymous);for(r.moveTo(t);;)if(!(n<0?r.childBefore(t):r.childAfter(t)))for(;;){if((n<0?r.to<t:r.from>t)&&!r.type.isError)return n<0?Math.max(0,Math.min(r.to-1,t-25)):Math.min(e.length,Math.max(r.from+1,t+25));if(n<0?r.prevSibling():r.nextSibling())break;if(!r.parent())return n<0?0:e.length}}class eI{constructor(e,t){this.fragments=e,this.nodeSet=t,this.i=0,this.fragment=null,this.safeFrom=-1,this.safeTo=-1,this.trees=[],this.start=[],this.index=[],this.nextFragment()}nextFragment(){let e=this.fragment=this.i==this.fragments.length?null:this.fragments[this.i++];if(e){for(this.safeFrom=e.openStart?ZR(e.tree,e.from+e.offset,1)-e.offset:e.from,this.safeTo=e.openEnd?ZR(e.tree,e.to+e.offset,-1)-e.offset:e.to;this.trees.length;)this.trees.pop(),this.start.pop(),this.index.pop();this.trees.push(e.tree),this.start.push(-e.offset),this.index.push(0),this.nextStart=this.safeFrom}else this.nextStart=1e9}nodeAt(e){if(e<this.nextStart)return null;for(;this.fragment&&this.safeTo<=e;)this.nextFragment();if(!this.fragment)return null;for(;;){let t=this.trees.length-1;if(t<0)return this.nextFragment(),null;let n=this.trees[t],r=this.index[t];if(r==n.children.length){this.trees.pop(),this.start.pop(),this.index.pop();continue}let i=n.children[r],o=this.start[t]+n.positions[r];if(o>e)return this.nextStart=o,null;if(i instanceof TB){if(o==e){if(o<this.safeFrom)return null;let e=o+i.length;if(e<=this.safeTo){let t=i.prop(wB.lookAhead);if(!t||e+t<this.fragment.to)return i}}this.index[t]++,o+i.length>=Math.max(this.safeFrom,e)&&(this.trees.push(i),this.start.push(o),this.index.push(0))}else this.index[t]++,this.nextStart=o+i.length}}}class tI{constructor(e,t){this.stream=t,this.tokens=[],this.mainToken=null,this.actions=[],this.tokens=e.tokenizers.map(e=>new $R)}getActions(e){let t=0,n=null,{parser:r}=e.p,{tokenizers:i}=r,o=r.stateSlot(e.state,3),s=e.curContext?e.curContext.hash:0,a=0;for(let r=0;r<i.length;r++){if(!(1<<r&o))continue;let l=i[r],c=this.tokens[r];if((!n||l.fallback)&&((l.contextual||c.start!=e.pos||c.mask!=o||c.context!=s)&&(this.updateCachedToken(c,l,e),c.mask=o,c.context=s),c.lookAhead>c.end+25&&(a=Math.max(c.lookAhead,a)),0!=c.value)){let r=t;if(c.extended>-1&&(t=this.addActions(e,c.extended,c.end,t)),t=this.addActions(e,c.value,c.end,t),!l.extend&&(n=c,t>r))break}}for(;this.actions.length>t;)this.actions.pop();return a&&e.setLookAhead(a),n||e.pos!=this.stream.end||(n=new $R,n.value=e.p.parser.eofTerm,n.start=n.end=e.pos,t=this.addActions(e,n.value,n.end,t)),this.mainToken=n,this.actions}getMainToken(e){if(this.mainToken)return this.mainToken;let t=new $R,{pos:n,p:r}=e;return t.start=n,t.end=Math.min(n+1,r.stream.end),t.value=n==r.stream.end?r.parser.eofTerm:0,t}updateCachedToken(e,t,n){let r=this.stream.clipPos(n.pos);if(t.token(this.stream.reset(r,e),n),e.value>-1){let{parser:t}=n.p;for(let r=0;r<t.specialized.length;r++)if(t.specialized[r]==e.value){let i=t.specializers[r](this.stream.read(e.start,e.end),n);if(i>=0&&n.p.parser.dialect.allows(i>>1)){1&i?e.extended=i>>1:e.value=i>>1;break}}}else e.value=0,e.end=this.stream.clipPos(r+1)}putAction(e,t,n,r){for(let t=0;t<r;t+=3)if(this.actions[t]==e)return r;return this.actions[r++]=e,this.actions[r++]=t,this.actions[r++]=n,r}addActions(e,t,n,r){let{state:i}=e,{parser:o}=e.p,{data:s}=o;for(let e=0;e<2;e++)for(let a=o.stateSlot(i,e?2:1);;a+=3){if(65535==s[a]){if(1!=s[a+1]){0==r&&2==s[a+1]&&(r=this.putAction(sI(s,a+2),t,n,r));break}a=sI(s,a+2)}s[a]==t&&(r=this.putAction(sI(s,a+1),t,n,r))}return r}}class nI{constructor(e,t,n,r){this.parser=e,this.input=t,this.ranges=r,this.recovering=0,this.nextStackID=9812,this.minStackPos=0,this.reused=[],this.stoppedAt=null,this.lastBigReductionStart=-1,this.lastBigReductionSize=0,this.bigReductionCount=0,this.stream=new jR(t,r),this.tokens=new tI(e,this.stream),this.topTerm=e.top[1];let{from:i}=r[0];this.stacks=[NR.start(this,e.top[0],i)],this.fragments=n.length&&this.stream.end-i>4*e.bufferLength?new eI(n,e.nodeSet):null}get parsedPos(){return this.minStackPos}advance(){let e,t,n=this.stacks,r=this.minStackPos,i=this.stacks=[];if(this.bigReductionCount>300&&1==n.length){let[e]=n;for(;e.forceReduce()&&e.stack.length&&e.stack[e.stack.length-2]>=this.lastBigReductionStart;);this.bigReductionCount=this.lastBigReductionSize=0}for(let o=0;o<n.length;o++){let s=n[o];for(;;){if(this.tokens.mainToken=null,s.pos>r)i.push(s);else{if(this.advanceStack(s,i,n))continue;{e||(e=[],t=[]),e.push(s);let n=this.tokens.getMainToken(s);t.push(n.value,n.end)}}break}}if(!i.length){let t=e&&function(e){let t=null;for(let n of e){let e=n.p.stoppedAt;(n.pos==n.p.stream.end||null!=e&&n.pos>e)&&n.p.parser.stateFlag(n.state,2)&&(!t||t.score<n.score)&&(t=n)}return t}(e);if(t)return JR&&console.log("Finish with "+this.stackID(t)),this.stackToTree(t);if(this.parser.strict)throw JR&&e&&console.log("Stuck with token "+(this.tokens.mainToken?this.parser.getName(this.tokens.mainToken.value):"none")),new SyntaxError("No parse at "+r);this.recovering||(this.recovering=5)}if(this.recovering&&e){let n=null!=this.stoppedAt&&e[0].pos>this.stoppedAt?e[0]:this.runRecovery(e,t,i);if(n)return JR&&console.log("Force-finish "+this.stackID(n)),this.stackToTree(n.forceAll())}if(this.recovering){let e=1==this.recovering?1:3*this.recovering;if(i.length>e)for(i.sort((e,t)=>t.score-e.score);i.length>e;)i.pop();i.some(e=>e.reducePos>r)&&this.recovering--}else if(i.length>1){e:for(let e=0;e<i.length-1;e++){let t=i[e];for(let n=e+1;n<i.length;n++){let r=i[n];if(t.sameState(r)||t.buffer.length>500&&r.buffer.length>500){if(!((t.score-r.score||t.buffer.length-r.buffer.length)>0)){i.splice(e--,1);continue e}i.splice(n--,1)}}}i.length>12&&i.splice(12,i.length-12)}this.minStackPos=i[0].pos;for(let e=1;e<i.length;e++)i[e].pos<this.minStackPos&&(this.minStackPos=i[e].pos);return null}stopAt(e){if(null!=this.stoppedAt&&this.stoppedAt<e)throw new RangeError("Can't move stoppedAt forward");this.stoppedAt=e}advanceStack(e,t,n){let r=e.pos,{parser:i}=this,o=JR?this.stackID(e)+" -> ":"";if(null!=this.stoppedAt&&r>this.stoppedAt)return e.forceReduce()?e:null;if(this.fragments){let t=e.curContext&&e.curContext.tracker.strict,n=t?e.curContext.hash:0;for(let s=this.fragments.nodeAt(r);s;){let r=this.parser.nodeSet.types[s.type.id]==s.type?i.getGoto(e.state,s.type.id):-1;if(r>-1&&s.length&&(!t||(s.prop(wB.contextHash)||0)==n))return e.useNode(s,r),JR&&console.log(o+this.stackID(e)+` (via reuse of ${i.getName(s.type.id)})`),!0;if(!(s instanceof TB)||0==s.children.length||s.positions[0]>0)break;let a=s.children[0];if(!(a instanceof TB&&0==s.positions[0]))break;s=a}}let s=i.stateSlot(e.state,4);if(s>0)return e.reduce(s),JR&&console.log(o+this.stackID(e)+` (via always-reduce ${i.getName(65535&s)})`),!0;if(e.stack.length>=8400)for(;e.stack.length>6e3&&e.forceReduce(););let a=this.tokens.getActions(e);for(let s=0;s<a.length;){let l=a[s++],c=a[s++],h=a[s++],d=s==a.length||!n,u=d?e:e.split(),p=this.tokens.mainToken;if(u.apply(l,c,p?p.start:u.pos,h),JR&&console.log(o+this.stackID(u)+` (via ${65536&l?`reduce of ${i.getName(65535&l)}`:"shift"} for ${i.getName(c)} @ ${r}${u==e?"":", split"})`),d)return!0;u.pos>r?t.push(u):n.push(u)}return!1}advanceFully(e,t){let n=e.pos;for(;;){if(!this.advanceStack(e,null,null))return!1;if(e.pos>n)return rI(e,t),!0}}runRecovery(e,t,n){let r=null,i=!1;for(let o=0;o<e.length;o++){let s=e[o],a=t[o<<1],l=t[1+(o<<1)],c=JR?this.stackID(s)+" -> ":"";if(s.deadEnd){if(i)continue;if(i=!0,s.restart(),JR&&console.log(c+this.stackID(s)+" (restarted)"),this.advanceFully(s,n))continue}let h=s.split(),d=c;for(let e=0;h.forceReduce()&&e<10;e++){if(JR&&console.log(d+this.stackID(h)+" (via force-reduce)"),this.advanceFully(h,n))break;JR&&(d=this.stackID(h)+" -> ")}for(let e of s.recoverByInsert(a))JR&&console.log(c+this.stackID(e)+" (via recover-insert)"),this.advanceFully(e,n);this.stream.end>s.pos?(l==s.pos&&(l++,a=0),s.recoverByDelete(a,l),JR&&console.log(c+this.stackID(s)+` (via recover-delete ${this.parser.getName(a)})`),rI(s,n)):(!r||r.score<s.score)&&(r=s)}return r}stackToTree(e){return e.close(),TB.build({buffer:VR.create(e),nodeSet:this.parser.nodeSet,topID:this.topTerm,maxBufferLength:this.parser.bufferLength,reused:this.reused,start:this.ranges[0].from,length:e.pos-this.ranges[0].from,minRepeatType:this.parser.minRepeatTerm})}stackID(e){let t=(KR||(KR=new WeakMap)).get(e);return t||KR.set(e,t=String.fromCodePoint(this.nextStackID++)),t+e}}function rI(e,t){for(let n=0;n<t.length;n++){let r=t[n];if(r.pos==e.pos&&r.sameState(e))return void(t[n].score<e.score&&(t[n]=e))}t.push(e)}class iI{constructor(e,t,n){this.source=e,this.flags=t,this.disabled=n}allows(e){return!this.disabled||0==this.disabled[e]}}class oI extends GB{constructor(e){if(super(),this.wrappers=[],14!=e.version)throw new RangeError(`Parser version (${e.version}) doesn't match runtime version (14)`);let t=e.nodeNames.split(" ");this.minRepeatTerm=t.length;for(let n=0;n<e.repeatNodeCount;n++)t.push("");let n=Object.keys(e.topRules).map(t=>e.topRules[t][1]),r=[];for(let e=0;e<t.length;e++)r.push([]);function i(e,t,n){r[e].push([t,t.deserialize(String(n))])}if(e.nodeProps)for(let t of e.nodeProps){let e=t[0];"string"==typeof e&&(e=wB[e]);for(let n=1;n<t.length;){let r=t[n++];if(r>=0)i(r,e,t[n++]);else{let o=t[n+-r];for(let s=-r;s>0;s--)i(t[n++],e,o);n++}}}this.nodeSet=new SB(t.map((t,i)=>kB.define({name:i>=this.minRepeatTerm?void 0:t,id:i,props:r[i],top:n.indexOf(i)>-1,error:0==i,skipped:e.skippedNodes&&e.skippedNodes.indexOf(i)>-1}))),e.propSources&&(this.nodeSet=this.nodeSet.extend(...e.propSources)),this.strict=!1,this.bufferLength=bB;let o=zR(e.tokenData);this.context=e.context,this.specializerSpecs=e.specialized||[],this.specialized=new Uint16Array(this.specializerSpecs.length);for(let e=0;e<this.specializerSpecs.length;e++)this.specialized[e]=this.specializerSpecs[e].term;this.specializers=this.specializerSpecs.map(aI),this.states=zR(e.states,Uint32Array),this.data=zR(e.stateData),this.goto=zR(e.goto),this.maxTerm=e.maxTerm,this.tokenizers=e.tokenizers.map(e=>"number"==typeof e?new qR(o,e):e),this.topRules=e.topRules,this.dialects=e.dialects||{},this.dynamicPrecedences=e.dynamicPrecedences||null,this.tokenPrecTable=e.tokenPrec,this.termNames=e.termNames||null,this.maxNode=this.nodeSet.types.length-1,this.dialect=this.parseDialect(),this.top=this.topRules[Object.keys(this.topRules)[0]]}createParse(e,t,n){let r=new nI(this,e,t,n);for(let i of this.wrappers)r=i(r,e,t,n);return r}getGoto(e,t,n=!1){let r=this.goto;if(t>=r[0])return-1;for(let i=r[t+1];;){let t=r[i++],o=1&t,s=r[i++];if(o&&n)return s;for(let n=i+(t>>1);i<n;i++)if(r[i]==e)return s;if(o)return-1}}hasAction(e,t){let n=this.data;for(let r=0;r<2;r++)for(let i,o=this.stateSlot(e,r?2:1);;o+=3){if(65535==(i=n[o])){if(1!=n[o+1]){if(2==n[o+1])return sI(n,o+2);break}i=n[o=sI(n,o+2)]}if(i==t||0==i)return sI(n,o+1)}return 0}stateSlot(e,t){return this.states[6*e+t]}stateFlag(e,t){return(this.stateSlot(e,0)&t)>0}validAction(e,t){return!!this.allActions(e,e=>e==t||null)}allActions(e,t){let n=this.stateSlot(e,4),r=n?t(n):void 0;for(let n=this.stateSlot(e,1);null==r;n+=3){if(65535==this.data[n]){if(1!=this.data[n+1])break;n=sI(this.data,n+2)}r=t(sI(this.data,n+1))}return r}nextStates(e){let t=[];for(let n=this.stateSlot(e,1);;n+=3){if(65535==this.data[n]){if(1!=this.data[n+1])break;n=sI(this.data,n+2)}if(!(1&this.data[n+2])){let e=this.data[n+1];t.some((t,n)=>1&n&&t==e)||t.push(this.data[n],e)}}return t}configure(e){let t=Object.assign(Object.create(oI.prototype),this);if(e.props&&(t.nodeSet=this.nodeSet.extend(...e.props)),e.top){let n=this.topRules[e.top];if(!n)throw new RangeError(`Invalid top rule name ${e.top}`);t.top=n}return e.tokenizers&&(t.tokenizers=this.tokenizers.map(t=>{let n=e.tokenizers.find(e=>e.from==t);return n?n.to:t})),e.specializers&&(t.specializers=this.specializers.slice(),t.specializerSpecs=this.specializerSpecs.map((n,r)=>{let i=e.specializers.find(e=>e.from==n.external);if(!i)return n;let o=Object.assign(Object.assign({},n),{external:i.to});return t.specializers[r]=aI(o),o})),e.contextTracker&&(t.context=e.contextTracker),e.dialect&&(t.dialect=this.parseDialect(e.dialect)),null!=e.strict&&(t.strict=e.strict),e.wrap&&(t.wrappers=t.wrappers.concat(e.wrap)),null!=e.bufferLength&&(t.bufferLength=e.bufferLength),t}hasWrappers(){return this.wrappers.length>0}getName(e){return this.termNames?this.termNames[e]:String(e<=this.maxNode&&this.nodeSet.types[e].name||e)}get eofTerm(){return this.maxNode+1}get topNode(){return this.nodeSet.types[this.top[1]]}dynamicPrecedence(e){let t=this.dynamicPrecedences;return null==t?0:t[e]||0}parseDialect(e){let t=Object.keys(this.dialects),n=t.map(()=>!1);if(e)for(let r of e.split(" ")){let e=t.indexOf(r);e>=0&&(n[e]=!0)}let r=null;for(let e=0;e<t.length;e++)if(!n[e])for(let n,i=this.dialects[t[e]];65535!=(n=this.data[i++]);)(r||(r=new Uint8Array(this.maxTerm+1)))[n]=1;return new iI(e,n,r)}static deserialize(e){return new oI(e)}}function sI(e,t){return e[t]|e[t+1]<<16}function aI(e){if(e.external){let t=e.extend?1:0;return(n,r)=>e.external(n,r)<<1|t}return e.get}const lI=[9,10,11,12,13,32,133,160,5760,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8232,8233,8239,8287,12288];function cI(e){return e>=65&&e<=90||e>=97&&e<=122||e>=161}function hI(e){return e>=48&&e<=57}function dI(e){return hI(e)||e>=97&&e<=102||e>=65&&e<=70}const uI=(e,t,n)=>(r,i)=>{for(let o=!1,s=0,a=0;;a++){let{next:l}=r;if(cI(l)||45==l||95==l||o&&hI(l))!o&&(45!=l||a>0)&&(o=!0),s===a&&45==l&&s++,r.advance();else{if(92!=l||10==r.peek(1)){o&&r.acceptToken(2==s&&i.canShift(2)?t:40==l?n:e);break}if(r.advance(),dI(r.next)){do{r.advance()}while(dI(r.next));32==r.next&&r.advance()}else r.next>-1&&r.advance();o=!0}}},pI=new UR(uI(123,2,124)),fI=new UR(uI(125,3,4)),gI=new UR(e=>{if(lI.includes(e.peek(-1))){let{next:t}=e;(cI(t)||95==t||35==t||46==t||42==t||91==t||58==t&&cI(e.peek(1))||45==t||38==t)&&e.acceptToken(122)}}),mI=new UR(e=>{if(!lI.includes(e.peek(-1))){let{next:t}=e;if(37==t&&(e.advance(),e.acceptToken(1)),cI(t)){do{e.advance()}while(cI(e.next)||hI(e.next));e.acceptToken(1)}}}),vI=t_({"AtKeyword import charset namespace keyframes media supports":C_.definitionKeyword,"from to selector":C_.keyword,NamespaceName:C_.namespace,KeyframeName:C_.labelName,KeyframeRangeName:C_.operatorKeyword,TagName:C_.tagName,ClassName:C_.className,PseudoClassName:C_.constant(C_.className),IdName:C_.labelName,"FeatureName PropertyName":C_.propertyName,AttributeName:C_.attributeName,NumberLiteral:C_.number,KeywordQuery:C_.keyword,UnaryQueryOp:C_.operatorKeyword,"CallTag ValueName":C_.atom,VariableName:C_.variableName,Callee:C_.operatorKeyword,Unit:C_.unit,"UniversalSelector NestingSelector":C_.definitionOperator,"MatchOp CompareOp":C_.compareOperator,"ChildOp SiblingOp, LogicOp":C_.logicOperator,BinOp:C_.arithmeticOperator,Important:C_.modifier,Comment:C_.blockComment,ColorLiteral:C_.color,"ParenthesizedContent StringLiteral":C_.string,":":C_.punctuation,"PseudoOp #":C_.derefOperator,"; ,":C_.separator,"( )":C_.paren,"[ ]":C_.squareBracket,"{ }":C_.brace}),bI={__proto__:null,lang:38,"nth-child":38,"nth-last-child":38,"nth-of-type":38,"nth-last-of-type":38,dir:38,"host-context":38,if:84,url:124,"url-prefix":124,domain:124,regexp:124},AI={__proto__:null,or:98,and:98,not:106,only:106,layer:170},yI={__proto__:null,selector:112,layer:166},wI={__proto__:null,"@import":162,"@media":174,"@charset":178,"@namespace":182,"@keyframes":188,"@supports":200,"@scope":204},CI={__proto__:null,to:207},xI=oI.deserialize({version:14,states:"EbQYQdOOO#qQdOOP#xO`OOOOQP'#Cf'#CfOOQP'#Ce'#CeO#}QdO'#ChO$nQaO'#CcO$xQdO'#CkO%TQdO'#DpO%YQdO'#DrO%_QdO'#DuO%_QdO'#DxOOQP'#FV'#FVO&eQhO'#EhOOQS'#FU'#FUOOQS'#Ek'#EkQYQdOOO&lQdO'#EOO&PQhO'#EUO&lQdO'#EWO'aQdO'#EYO'lQdO'#E]O'tQhO'#EcO(VQdO'#EeO(bQaO'#CfO)VQ`O'#D{O)[Q`O'#F`O)gQdO'#F`QOQ`OOP)qO&jO'#CaPOOO)C@t)C@tOOQP'#Cj'#CjOOQP,59S,59SO#}QdO,59SO)|QdO,59VO%TQdO,5:[O%YQdO,5:^O%_QdO,5:aO%_QdO,5:cO%_QdO,5:dO%_QdO'#ErO*XQ`O,58}O*aQdO'#DzOOQS,58},58}OOQP'#Cn'#CnOOQO'#Dn'#DnOOQP,59V,59VO*hQ`O,59VO*mQ`O,59VOOQP'#Dq'#DqOOQP,5:[,5:[OOQO'#Ds'#DsO*rQpO,5:^O+]QaO,5:aO+sQaO,5:dOOQW'#DZ'#DZO,ZQhO'#DdO,xQhO'#FaO'tQhO'#DbO-WQ`O'#DhOOQW'#F['#F[O-]Q`O,5;SO-eQ`O'#DeOOQS-E8i-E8iOOQ['#Cs'#CsO-jQdO'#CtO.QQdO'#CzO.hQdO'#C}O/OQ!pO'#DPO1RQ!jO,5:jOOQO'#DU'#DUO*mQ`O'#DTO1cQ!nO'#FXO3`Q`O'#DVO3eQ`O'#DkOOQ['#FX'#FXO-`Q`O,5:pO3jQ!bO,5:rOOQS'#E['#E[O3rQ`O,5:tO3wQdO,5:tOOQO'#E_'#E_O4PQ`O,5:wO4UQhO,5:}O%_QdO'#DgOOQS,5;P,5;PO-eQ`O,5;PO4^QdO,5;PO4fQdO,5:gO4vQdO'#EtO5TQ`O,5;zO5TQ`O,5;zPOOO'#Ej'#EjP5`O&jO,58{POOO,58{,58{OOQP1G.n1G.nOOQP1G.q1G.qO*hQ`O1G.qO*mQ`O1G.qOOQP1G/v1G/vO5kQpO1G/xO5sQaO1G/{O6ZQaO1G/}O6qQaO1G0OO7XQaO,5;^OOQO-E8p-E8pOOQS1G.i1G.iO7cQ`O,5:fO7hQdO'#DoO7oQdO'#CrOOQP1G/x1G/xO&lQdO1G/xO7vQ!jO'#DZO8UQ!bO,59vO8^QhO,5:OOOQO'#F]'#F]O8XQ!bO,59zO'tQhO,59xO8fQhO'#EvO8sQ`O,5;{O9OQhO,59|O9uQhO'#DiOOQW,5:S,5:SOOQS1G0n1G0nOOQW,5:P,5:PO9|Q!fO'#FYOOQS'#FY'#FYOOQS'#Em'#EmO;^QdO,59`OOQ[,59`,59`O;tQdO,59fOOQ[,59f,59fO<[QdO,59iOOQ[,59i,59iOOQ[,59k,59kO&lQdO,59mO<rQhO'#EQOOQW'#EQ'#EQO=WQ`O1G0UO1[QhO1G0UOOQ[,59o,59oO'tQhO'#DXOOQ[,59q,59qO=]Q#tO,5:VOOQS1G0[1G0[OOQS1G0^1G0^OOQS1G0`1G0`O=hQ`O1G0`O=mQdO'#E`OOQS1G0c1G0cOOQS1G0i1G0iO=xQaO,5:RO-`Q`O1G0kOOQS1G0k1G0kO-eQ`O1G0kO>PQ!fO1G0ROOQO1G0R1G0ROOQO,5;`,5;`O>gQdO,5;`OOQO-E8r-E8rO>tQ`O1G1fPOOO-E8h-E8hPOOO1G.g1G.gOOQP7+$]7+$]OOQP7+%d7+%dO&lQdO7+%dOOQS1G0Q1G0QO?PQaO'#F_O?ZQ`O,5:ZO?`Q!fO'#ElO@^QdO'#FWO@hQ`O,59^O@mQ!bO7+%dO&lQdO1G/bO@uQhO1G/fOOQW1G/j1G/jOOQW1G/d1G/dOAWQhO,5;bOOQO-E8t-E8tOAfQhO'#DZOAtQhO'#F^OBPQ`O'#F^OBUQ`O,5:TOOQS-E8k-E8kOOQ[1G.z1G.zOOQ[1G/Q1G/QOOQ[1G/T1G/TOOQ[1G/X1G/XOBZQdO,5:lOOQS7+%p7+%pOB`Q`O7+%pOBeQhO'#DYOBmQ`O,59sO'tQhO,59sOOQ[1G/q1G/qOBuQ`O1G/qOOQS7+%z7+%zOBzQbO'#DPOOQO'#Eb'#EbOCYQ`O'#EaOOQO'#Ea'#EaOCeQ`O'#EwOCmQdO,5:zOOQS,5:z,5:zOOQ[1G/m1G/mOOQS7+&V7+&VO-`Q`O7+&VOCxQ!fO'#EsO&lQdO'#EsOEPQdO7+%mOOQO7+%m7+%mOOQO1G0z1G0zOEdQ!bO<<IOOElQdO'#EqOEvQ`O,5;yOOQP1G/u1G/uOOQS-E8j-E8jOFOQdO'#EpOFYQ`O,5;rOOQ]1G.x1G.xOOQP<<IO<<IOOFbQdO7+$|OOQO'#D]'#D]OFiQ!bO7+%QOFqQhO'#EoOF{Q`O,5;xO&lQdO,5;xOOQW1G/o1G/oOOQO'#ES'#ESOGTQ`O1G0WOOQS<<I[<<I[O&lQdO,59tOGnQhO1G/_OOQ[1G/_1G/_OGuQ`O1G/_OOQW-E8l-E8lOOQ[7+%]7+%]OOQO,5:{,5:{O=pQdO'#ExOCeQ`O,5;cOOQS,5;c,5;cOOQS-E8u-E8uOOQS1G0f1G0fOOQS<<Iq<<IqOG}Q!fO,5;_OOQS-E8q-E8qOOQO<<IX<<IXOOQPAN>jAN>jOIUQaO,5;]OOQO-E8o-E8oOI`QdO,5;[OOQO-E8n-E8nOOQW<<Hh<<HhOOQW<<Hl<<HlOIjQhO<<HlOI{QhO,5;ZOJWQ`O,5;ZOOQO-E8m-E8mOJ]QdO1G1dOBZQdO'#EuOJgQ`O7+%rOOQW7+%r7+%rOJoQ!bO1G/`OOQ[7+$y7+$yOJzQhO7+$yPKRQ`O'#EnOOQO,5;d,5;dOOQO-E8v-E8vOOQS1G0}1G0}OKWQ`OAN>WO&lQdO1G0uOK]Q`O7+'OOOQO,5;a,5;aOOQO-E8s-E8sOOQW<<I^<<I^OOQ[<<He<<HePOQW,5;Y,5;YOOQWG23rG23rOKeQdO7+&a",stateData:"Kx~O#sOS#tQQ~OW[OZ[O]TO`VOaVOi]OjWOmXO!jYO!mZO!saO!ybO!{cO!}dO#QeO#WfO#YgO#oRO~OQiOW[OZ[O]TO`VOaVOi]OjWOmXO!jYO!mZO!saO!ybO!{cO!}dO#QeO#WfO#YgO#ohO~O#m$SP~P!dO#tmO~O#ooO~O]qO`rOarOjsOmtO!juO!mwO#nvO~OpzO!^xO~P$SOc!QO#o|O#p}O~O#o!RO~O#o!TO~OW[OZ[O]TO`VOaVOjWOmXO!jYO!mZO#oRO~OS!]Oe!YO!V![O!Y!`O#q!XOp$TP~Ok$TP~P&POQ!jOe!cOm!dOp!eOr!mOt!mOz!kO!`!lO#o!bO#p!hO#}!fO~Ot!qO!`!lO#o!pO~Ot!sO#o!sO~OS!]Oe!YO!V![O!Y!`O#q!XO~Oe!vOpzO#Z!xO~O]YX`YX`!pXaYXjYXmYXpYX!^YX!jYX!mYX#nYX~O`!zO~Ok!{O#m$SXo$SX~O#m$SXo$SX~P!dO#u#OO#v#OO#w#QO~Oc#UO#o|O#p}O~OpzO!^xO~Oo$SP~P!dOe#`O~Oe#aO~Ol#bO!h#cO~O]qO`rOarOjsOmtO~Op!ia!^!ia!j!ia!m!ia#n!iad!ia~P*zOp!la!^!la!j!la!m!la#n!lad!la~P*zOR#gOS!]Oe!YOr#gOt#gO!V![O!Y!`O#q#dO#}!fO~O!R#iO!^#jOk$TXp$TX~Oe#mO~Ok#oOpzO~Oe!vO~O]#rO`#rOd#uOi#rOj#rOk#rO~P&lO]#rO`#rOi#rOj#rOk#rOl#wO~P&lO]#rO`#rOi#rOj#rOk#rOo#yO~P&lOP#zOSsXesXksXvsX!VsX!YsX!usX!wsX#qsX!TsXQsX]sX`sXdsXisXjsXmsXpsXrsXtsXzsX!`sX#osX#psX#}sXlsXosX!^sX!qsX#msX~Ov#{O!u#|O!w#}Ok$TP~P'tOe#aOS#{Xk#{Xv#{X!V#{X!Y#{X!u#{X!w#{X#q#{XQ#{X]#{X`#{Xd#{Xi#{Xj#{Xm#{Xp#{Xr#{Xt#{Xz#{X!`#{X#o#{X#p#{X#}#{Xl#{Xo#{X!^#{X!q#{X#m#{X~Oe$RO~Oe$TO~Ok$VOv#{O~Ok$WO~Ot$XO!`!lO~Op$YO~OpzO!R#iO~OpzO#Z$`O~O!q$bOk!oa#m!oao!oa~P&lOk#hX#m#hXo#hX~P!dOk!{O#m$Sao$Sa~O#u#OO#v#OO#w$hO~Ol$jO!h$kO~Op!ii!^!ii!j!ii!m!ii#n!iid!ii~P*zOp!ki!^!ki!j!ki!m!ki#n!kid!ki~P*zOp!li!^!li!j!li!m!li#n!lid!li~P*zOp#fa!^#fa~P$SOo$lO~Od$RP~P%_Od#zP~P&lO`!PXd}X!R}X!T!PX~O`$sO!T$tO~Od$uO!R#iO~Ok#jXp#jX!^#jX~P'tO!^#jOk$Tap$Ta~O!R#iOk!Uap!Ua!^!Uad!Ua`!Ua~OS!]Oe!YO!V![O!Y!`O#q$yO~Od$QP~P9dOv#{OQ#|X]#|X`#|Xd#|Xe#|Xi#|Xj#|Xk#|Xm#|Xp#|Xr#|Xt#|Xz#|X!`#|X#o#|X#p#|X#}#|Xl#|Xo#|X~O]#rO`#rOd%OOi#rOj#rOk#rO~P&lO]#rO`#rOi#rOj#rOk#rOl%PO~P&lO]#rO`#rOi#rOj#rOk#rOo%QO~P&lOe%SOS!tXk!tX!V!tX!Y!tX#q!tX~Ok%TO~Od%YOt%ZO!a%ZO~Ok%[O~Oo%cO#o%^O#}%]O~Od%dO~P$SOv#{O!^%hO!q%jOk!oi#m!oio!oi~P&lOk#ha#m#hao#ha~P!dOk!{O#m$Sio$Si~O!^%mOd$RX~P$SOd%oO~Ov#{OQ#`Xd#`Xe#`Xm#`Xp#`Xr#`Xt#`Xz#`X!^#`X!`#`X#o#`X#p#`X#}#`X~O!^%qOd#zX~P&lOd%sO~Ol%tOv#{O~OR#gOr#gOt#gO#q%vO#}!fO~O!R#iOk#jap#ja!^#ja~O`!PXd}X!R}X!^}X~O!R#iO!^%xOd$QX~O`%zO~Od%{O~O#o%|O~Ok&OO~O`&PO!R#iO~Od&ROk&QO~Od&UO~OP#zOpsX!^sXdsX~O#}%]Op#TX!^#TX~OpzO!^&WO~Oo&[O#o%^O#}%]O~Ov#{OQ#gXe#gXk#gXm#gXp#gXr#gXt#gXz#gX!^#gX!`#gX!q#gX#m#gX#o#gX#p#gX#}#gXo#gX~O!^%hO!q&`Ok!oq#m!oqo!oq~P&lOl&aOv#{O~Od#eX!^#eX~P%_O!^%mOd$Ra~Od#dX!^#dX~P&lO!^%qOd#za~Od&fO~P&lOd&gO!T&hO~Od#cX!^#cX~P9dO!^%xOd$Qa~O]&mOd&oO~OS#bae#ba!V#ba!Y#ba#q#ba~Od&qO~PG]Od&qOk&rO~Ov#{OQ#gae#gak#gam#gap#gar#gat#gaz#ga!^#ga!`#ga!q#ga#m#ga#o#ga#p#ga#}#gao#ga~Od#ea!^#ea~P$SOd#da!^#da~P&lOR#gOr#gOt#gO#q%vO#}%]O~O!R#iOd#ca!^#ca~O`&xO~O!^%xOd$Qi~P&lO]&mOd&|O~Ov#{Od|ik|i~Od&}O~PG]Ok'OO~Od'PO~O!^%xOd$Qq~Od#cq!^#cq~P&lO#s!a#t#}]#}v!m~",goto:"2h$UPPPPP$VP$YP$c$uP$cP%X$cPP%_PPP%e%o%oPPPPP%oPP%oP&]P%oP%o'W%oP't'w'}'}(^'}P'}P'}P'}'}P(m'}(yP(|PP)p)v$c)|$c*SP$cP$c$cP*Y*{+YP$YP+aP+dP$YP$YP$YP+j$YP+m+p+s+z$YP$YPP$YP,P,V,f,|-[-b-l-r-x.O.U.`.f.l.rPPPPPPPPPPP.x/R/w/z0|P1U1u2O2R2U2[RnQ_^OP`kz!{$dq[OPYZ`kuvwxz!v!{#`$d%mqSOPYZ`kuvwxz!v!{#`$d%mQpTR#RqQ!OVR#SrQ#S!QS$Q!i!jR$i#U!V!mac!c!d!e!z#a#c#t#v#x#{$a$k$p$s%h%i%q%u%z&P&d&l&x'Q!U!mac!c!d!e!z#a#c#t#v#x#{$a$k$p$s%h%i%q%u%z&P&d&l&x'QU#g!Y$t&hU%`$Y%b&WR&V%_!V!iac!c!d!e!z#a#c#t#v#x#{$a$k$p$s%h%i%q%u%z&P&d&l&x'QR$S!kQ%W$RR&S%Xk!^]bf!Y![!g#i#j#m$P$R%X%xQ#e!YQ${#mQ%w$tQ&j%xR&w&hQ!ygQ#p!`Q$^!xR%f$`R#n!]!U!mac!c!d!e!z#a#c#t#v#x#{$a$k$p$s%h%i%q%u%z&P&d&l&x'QQ!qdR$X!rQ!PVR#TrQ#S!PR$i#TQ!SWR#VsQ!UXR#WtQ{UQ!wgQ#^yQ#o!_Q$U!nQ$[!uQ$_!yQ%e$^Q&Y%aQ&]%fR&v&XSjPzQ!}kQ$c!{R%k$dZiPkz!{$dR$P!gQ%}%SR&z&mR!rdR!teR$Z!tS%a$Y%bR&t&WV%_$Y%b&WQ#PmR$g#PQ`OSkPzU!a`k$dR$d!{Q$p#aY%p$p%u&d&l'QQ%u$sQ&d%qQ&l%zR'Q&xQ#t!cQ#v!dQ#x!eV$}#t#v#xQ%X$RR&T%XQ%y$zS&k%y&yR&y&lQ%r$pR&e%rQ%n$mR&c%nQyUR#]yQ%i$aR&_%iQ!|jS$e!|$fR$f!}Q&n%}R&{&nQ#k!ZR$x#kQ%b$YR&Z%bQ&X%aR&u&X__OP`kz!{$d^UOP`kz!{$dQ!VYQ!WZQ#XuQ#YvQ#ZwQ#[xQ$]!vQ$m#`R&b%mR$q#aQ!gaQ!oc[#q!c!d!e#t#v#xQ$a!zd$o#a$p$s%q%u%z&d&l&x'QQ$r#cQ%R#{S%g$a%iQ%l$kQ&^%hR&p&P]#s!c!d!e#t#v#xW!Z]b!g$PQ!ufQ#f!YQ#l![Q$v#iQ$w#jQ$z#mS%V$R%XR&i%xQ#h!YQ%w$tR&w&hR$|#mR$n#`QlPR#_zQ!_]Q!nbQ$O!gR%U$P",nodeNames:"⚠ Unit VariableName VariableName QueryCallee Comment StyleSheet RuleSet UniversalSelector TagSelector TagName NestingSelector ClassSelector . ClassName PseudoClassSelector : :: PseudoClassName PseudoClassName ) ( ArgList ValueName ParenthesizedValue AtKeyword # ; ] [ BracketedValue } { BracedValue ColorLiteral NumberLiteral StringLiteral BinaryExpression BinOp CallExpression Callee IfExpression if ArgList IfBranch KeywordQuery FeatureQuery FeatureName BinaryQuery LogicOp ComparisonQuery CompareOp UnaryQuery UnaryQueryOp ParenthesizedQuery SelectorQuery selector ParenthesizedSelector CallQuery ArgList , CallLiteral CallTag ParenthesizedContent PseudoClassName ArgList IdSelector IdName AttributeSelector AttributeName MatchOp ChildSelector ChildOp DescendantSelector SiblingSelector SiblingOp Block Declaration PropertyName Important ImportStatement import Layer layer LayerName layer MediaStatement media CharsetStatement charset NamespaceStatement namespace NamespaceName KeyframesStatement keyframes KeyframeName KeyframeList KeyframeSelector KeyframeRangeName SupportsStatement supports ScopeStatement scope to AtRule Styles",maxTerm:143,nodeProps:[["isolate",-2,5,36,""],["openedBy",20,"(",28,"[",31,"{"],["closedBy",21,")",29,"]",32,"}"]],propSources:[vI],skippedNodes:[0,5,106],repeatNodeCount:15,tokenData:"JQ~R!YOX$qX^%i^p$qpq%iqr({rs-ust/itu6Wuv$qvw7Qwx7cxy9Qyz9cz{9h{|:R|}>t}!O?V!O!P?t!P!Q@]!Q![AU![!]BP!]!^B{!^!_C^!_!`DY!`!aDm!a!b$q!b!cEn!c!}$q!}#OG{#O#P$q#P#QH^#Q#R6W#R#o$q#o#pHo#p#q6W#q#rIQ#r#sIc#s#y$q#y#z%i#z$f$q$f$g%i$g#BY$q#BY#BZ%i#BZ$IS$q$IS$I_%i$I_$I|$q$I|$JO%i$JO$JT$q$JT$JU%i$JU$KV$q$KV$KW%i$KW&FU$q&FU&FV%i&FV;'S$q;'S;=`Iz<%lO$q`$tSOy%Qz;'S%Q;'S;=`%c<%lO%Q`%VS!a`Oy%Qz;'S%Q;'S;=`%c<%lO%Q`%fP;=`<%l%Q~%nh#s~OX%QX^'Y^p%Qpq'Yqy%Qz#y%Q#y#z'Y#z$f%Q$f$g'Y$g#BY%Q#BY#BZ'Y#BZ$IS%Q$IS$I_'Y$I_$I|%Q$I|$JO'Y$JO$JT%Q$JT$JU'Y$JU$KV%Q$KV$KW'Y$KW&FU%Q&FU&FV'Y&FV;'S%Q;'S;=`%c<%lO%Q~'ah#s~!a`OX%QX^'Y^p%Qpq'Yqy%Qz#y%Q#y#z'Y#z$f%Q$f$g'Y$g#BY%Q#BY#BZ'Y#BZ$IS%Q$IS$I_'Y$I_$I|%Q$I|$JO'Y$JO$JT%Q$JT$JU'Y$JU$KV%Q$KV$KW'Y$KW&FU%Q&FU&FV'Y&FV;'S%Q;'S;=`%c<%lO%Qj)OUOy%Qz#]%Q#]#^)b#^;'S%Q;'S;=`%c<%lO%Qj)gU!a`Oy%Qz#a%Q#a#b)y#b;'S%Q;'S;=`%c<%lO%Qj*OU!a`Oy%Qz#d%Q#d#e*b#e;'S%Q;'S;=`%c<%lO%Qj*gU!a`Oy%Qz#c%Q#c#d*y#d;'S%Q;'S;=`%c<%lO%Qj+OU!a`Oy%Qz#f%Q#f#g+b#g;'S%Q;'S;=`%c<%lO%Qj+gU!a`Oy%Qz#h%Q#h#i+y#i;'S%Q;'S;=`%c<%lO%Qj,OU!a`Oy%Qz#T%Q#T#U,b#U;'S%Q;'S;=`%c<%lO%Qj,gU!a`Oy%Qz#b%Q#b#c,y#c;'S%Q;'S;=`%c<%lO%Qj-OU!a`Oy%Qz#h%Q#h#i-b#i;'S%Q;'S;=`%c<%lO%Qj-iS!qY!a`Oy%Qz;'S%Q;'S;=`%c<%lO%Q~-xWOY-uZr-urs.bs#O-u#O#P.g#P;'S-u;'S;=`/c<%lO-u~.gOt~~.jRO;'S-u;'S;=`.s;=`O-u~.vXOY-uZr-urs.bs#O-u#O#P.g#P;'S-u;'S;=`/c;=`<%l-u<%lO-u~/fP;=`<%l-uj/nYjYOy%Qz!Q%Q!Q![0^![!c%Q!c!i0^!i#T%Q#T#Z0^#Z;'S%Q;'S;=`%c<%lO%Qj0cY!a`Oy%Qz!Q%Q!Q![1R![!c%Q!c!i1R!i#T%Q#T#Z1R#Z;'S%Q;'S;=`%c<%lO%Qj1WY!a`Oy%Qz!Q%Q!Q![1v![!c%Q!c!i1v!i#T%Q#T#Z1v#Z;'S%Q;'S;=`%c<%lO%Qj1}YrY!a`Oy%Qz!Q%Q!Q![2m![!c%Q!c!i2m!i#T%Q#T#Z2m#Z;'S%Q;'S;=`%c<%lO%Qj2tYrY!a`Oy%Qz!Q%Q!Q![3d![!c%Q!c!i3d!i#T%Q#T#Z3d#Z;'S%Q;'S;=`%c<%lO%Qj3iY!a`Oy%Qz!Q%Q!Q![4X![!c%Q!c!i4X!i#T%Q#T#Z4X#Z;'S%Q;'S;=`%c<%lO%Qj4`YrY!a`Oy%Qz!Q%Q!Q![5O![!c%Q!c!i5O!i#T%Q#T#Z5O#Z;'S%Q;'S;=`%c<%lO%Qj5TY!a`Oy%Qz!Q%Q!Q![5s![!c%Q!c!i5s!i#T%Q#T#Z5s#Z;'S%Q;'S;=`%c<%lO%Qj5zSrY!a`Oy%Qz;'S%Q;'S;=`%c<%lO%Qd6ZUOy%Qz!_%Q!_!`6m!`;'S%Q;'S;=`%c<%lO%Qd6tS!hS!a`Oy%Qz;'S%Q;'S;=`%c<%lO%Qb7VSZQOy%Qz;'S%Q;'S;=`%c<%lO%Q~7fWOY7cZw7cwx.bx#O7c#O#P8O#P;'S7c;'S;=`8z<%lO7c~8RRO;'S7c;'S;=`8[;=`O7c~8_XOY7cZw7cwx.bx#O7c#O#P8O#P;'S7c;'S;=`8z;=`<%l7c<%lO7c~8}P;=`<%l7cj9VSeYOy%Qz;'S%Q;'S;=`%c<%lO%Q~9hOd~n9oUWQvWOy%Qz!_%Q!_!`6m!`;'S%Q;'S;=`%c<%lO%Qj:YWvW!mQOy%Qz!O%Q!O!P:r!P!Q%Q!Q![=w![;'S%Q;'S;=`%c<%lO%Qj:wU!a`Oy%Qz!Q%Q!Q![;Z![;'S%Q;'S;=`%c<%lO%Qj;bY!a`#}YOy%Qz!Q%Q!Q![;Z![!g%Q!g!h<Q!h#X%Q#X#Y<Q#Y;'S%Q;'S;=`%c<%lO%Qj<VY!a`Oy%Qz{%Q{|<u|}%Q}!O<u!O!Q%Q!Q![=^![;'S%Q;'S;=`%c<%lO%Qj<zU!a`Oy%Qz!Q%Q!Q![=^![;'S%Q;'S;=`%c<%lO%Qj=eU!a`#}YOy%Qz!Q%Q!Q![=^![;'S%Q;'S;=`%c<%lO%Qj>O[!a`#}YOy%Qz!O%Q!O!P;Z!P!Q%Q!Q![=w![!g%Q!g!h<Q!h#X%Q#X#Y<Q#Y;'S%Q;'S;=`%c<%lO%Qj>yS!^YOy%Qz;'S%Q;'S;=`%c<%lO%Qj?[WvWOy%Qz!O%Q!O!P:r!P!Q%Q!Q![=w![;'S%Q;'S;=`%c<%lO%Qj?yU]YOy%Qz!Q%Q!Q![;Z![;'S%Q;'S;=`%c<%lO%Q~@bTvWOy%Qz{@q{;'S%Q;'S;=`%c<%lO%Q~@xS!a`#t~Oy%Qz;'S%Q;'S;=`%c<%lO%QjAZ[#}YOy%Qz!O%Q!O!P;Z!P!Q%Q!Q![=w![!g%Q!g!h<Q!h#X%Q#X#Y<Q#Y;'S%Q;'S;=`%c<%lO%QjBUU`YOy%Qz![%Q![!]Bh!];'S%Q;'S;=`%c<%lO%QbBoSaQ!a`Oy%Qz;'S%Q;'S;=`%c<%lO%QjCQSkYOy%Qz;'S%Q;'S;=`%c<%lO%QhCcU!TWOy%Qz!_%Q!_!`Cu!`;'S%Q;'S;=`%c<%lO%QhC|S!TW!a`Oy%Qz;'S%Q;'S;=`%c<%lO%QlDaS!TW!hSOy%Qz;'S%Q;'S;=`%c<%lO%QjDtV!jQ!TWOy%Qz!_%Q!_!`Cu!`!aEZ!a;'S%Q;'S;=`%c<%lO%QbEbS!jQ!a`Oy%Qz;'S%Q;'S;=`%c<%lO%QjEqYOy%Qz}%Q}!OFa!O!c%Q!c!}GO!}#T%Q#T#oGO#o;'S%Q;'S;=`%c<%lO%QjFfW!a`Oy%Qz!c%Q!c!}GO!}#T%Q#T#oGO#o;'S%Q;'S;=`%c<%lO%QjGV[iY!a`Oy%Qz}%Q}!OGO!O!Q%Q!Q![GO![!c%Q!c!}GO!}#T%Q#T#oGO#o;'S%Q;'S;=`%c<%lO%QjHQSmYOy%Qz;'S%Q;'S;=`%c<%lO%QnHcSl^Oy%Qz;'S%Q;'S;=`%c<%lO%QjHtSpYOy%Qz;'S%Q;'S;=`%c<%lO%QjIVSoYOy%Qz;'S%Q;'S;=`%c<%lO%QfIhU!mQOy%Qz!_%Q!_!`6m!`;'S%Q;'S;=`%c<%lO%Q`I}P;=`<%l$q",tokenizers:[gI,mI,pI,fI,1,2,3,4,new WR("m~RRYZ[z{a~~g~aO#v~~dP!P!Qg~lO#w~~",28,129)],topRules:{StyleSheet:[0,6],Styles:[1,105]},specialized:[{term:124,get:e=>bI[e]||-1},{term:125,get:e=>AI[e]||-1},{term:4,get:e=>yI[e]||-1},{term:25,get:e=>wI[e]||-1},{term:123,get:e=>CI[e]||-1}],tokenPrec:1963});let kI=null;function SI(){if(!kI&&"object"==typeof document&&document.body){let{style:e}=document.body,t=[],n=new Set;for(let r in e)"cssText"!=r&&"cssFloat"!=r&&"string"==typeof e[r]&&(/[A-Z]/.test(r)&&(r=r.replace(/[A-Z]/g,e=>"-"+e.toLowerCase())),n.has(r)||(t.push(r),n.add(r)));kI=t.sort().map(e=>({type:"property",label:e,apply:e+": "}))}return kI||[]}const OI=["active","after","any-link","autofill","backdrop","before","checked","cue","default","defined","disabled","empty","enabled","file-selector-button","first","first-child","first-letter","first-line","first-of-type","focus","focus-visible","focus-within","fullscreen","has","host","host-context","hover","in-range","indeterminate","invalid","is","lang","last-child","last-of-type","left","link","marker","modal","not","nth-child","nth-last-child","nth-last-of-type","nth-of-type","only-child","only-of-type","optional","out-of-range","part","placeholder","placeholder-shown","read-only","read-write","required","right","root","scope","selection","slotted","target","target-text","valid","visited","where"].map(e=>({type:"class",label:e})),BI=["above","absolute","activeborder","additive","activecaption","after-white-space","ahead","alias","all","all-scroll","alphabetic","alternate","always","antialiased","appworkspace","asterisks","attr","auto","auto-flow","avoid","avoid-column","avoid-page","avoid-region","axis-pan","background","backwards","baseline","below","bidi-override","blink","block","block-axis","bold","bolder","border","border-box","both","bottom","break","break-all","break-word","bullets","button","button-bevel","buttonface","buttonhighlight","buttonshadow","buttontext","calc","capitalize","caps-lock-indicator","caption","captiontext","caret","cell","center","checkbox","circle","cjk-decimal","clear","clip","close-quote","col-resize","collapse","color","color-burn","color-dodge","column","column-reverse","compact","condensed","contain","content","contents","content-box","context-menu","continuous","copy","counter","counters","cover","crop","cross","crosshair","currentcolor","cursive","cyclic","darken","dashed","decimal","decimal-leading-zero","default","default-button","dense","destination-atop","destination-in","destination-out","destination-over","difference","disc","discard","disclosure-closed","disclosure-open","document","dot-dash","dot-dot-dash","dotted","double","down","e-resize","ease","ease-in","ease-in-out","ease-out","element","ellipse","ellipsis","embed","end","ethiopic-abegede-gez","ethiopic-halehame-aa-er","ethiopic-halehame-gez","ew-resize","exclusion","expanded","extends","extra-condensed","extra-expanded","fantasy","fast","fill","fill-box","fixed","flat","flex","flex-end","flex-start","footnotes","forwards","from","geometricPrecision","graytext","grid","groove","hand","hard-light","help","hidden","hide","higher","highlight","highlighttext","horizontal","hsl","hsla","hue","icon","ignore","inactiveborder","inactivecaption","inactivecaptiontext","infinite","infobackground","infotext","inherit","initial","inline","inline-axis","inline-block","inline-flex","inline-grid","inline-table","inset","inside","intrinsic","invert","italic","justify","keep-all","landscape","large","larger","left","level","lighter","lighten","line-through","linear","linear-gradient","lines","list-item","listbox","listitem","local","logical","loud","lower","lower-hexadecimal","lower-latin","lower-norwegian","lowercase","ltr","luminosity","manipulation","match","matrix","matrix3d","medium","menu","menutext","message-box","middle","min-intrinsic","mix","monospace","move","multiple","multiple_mask_images","multiply","n-resize","narrower","ne-resize","nesw-resize","no-close-quote","no-drop","no-open-quote","no-repeat","none","normal","not-allowed","nowrap","ns-resize","numbers","numeric","nw-resize","nwse-resize","oblique","opacity","open-quote","optimizeLegibility","optimizeSpeed","outset","outside","outside-shape","overlay","overline","padding","padding-box","painted","page","paused","perspective","pinch-zoom","plus-darker","plus-lighter","pointer","polygon","portrait","pre","pre-line","pre-wrap","preserve-3d","progress","push-button","radial-gradient","radio","read-only","read-write","read-write-plaintext-only","rectangle","region","relative","repeat","repeating-linear-gradient","repeating-radial-gradient","repeat-x","repeat-y","reset","reverse","rgb","rgba","ridge","right","rotate","rotate3d","rotateX","rotateY","rotateZ","round","row","row-resize","row-reverse","rtl","run-in","running","s-resize","sans-serif","saturation","scale","scale3d","scaleX","scaleY","scaleZ","screen","scroll","scrollbar","scroll-position","se-resize","self-start","self-end","semi-condensed","semi-expanded","separate","serif","show","single","skew","skewX","skewY","skip-white-space","slide","slider-horizontal","slider-vertical","sliderthumb-horizontal","sliderthumb-vertical","slow","small","small-caps","small-caption","smaller","soft-light","solid","source-atop","source-in","source-out","source-over","space","space-around","space-between","space-evenly","spell-out","square","start","static","status-bar","stretch","stroke","stroke-box","sub","subpixel-antialiased","svg_masks","super","sw-resize","symbolic","symbols","system-ui","table","table-caption","table-cell","table-column","table-column-group","table-footer-group","table-header-group","table-row","table-row-group","text","text-bottom","text-top","textarea","textfield","thick","thin","threeddarkshadow","threedface","threedhighlight","threedlightshadow","threedshadow","to","top","transform","translate","translate3d","translateX","translateY","translateZ","transparent","ultra-condensed","ultra-expanded","underline","unidirectional-pan","unset","up","upper-latin","uppercase","url","var","vertical","vertical-text","view-box","visible","visibleFill","visiblePainted","visibleStroke","visual","w-resize","wait","wave","wider","window","windowframe","windowtext","words","wrap","wrap-reverse","x-large","x-small","xor","xx-large","xx-small"].map(e=>({type:"keyword",label:e})).concat(["aliceblue","antiquewhite","aqua","aquamarine","azure","beige","bisque","black","blanchedalmond","blue","blueviolet","brown","burlywood","cadetblue","chartreuse","chocolate","coral","cornflowerblue","cornsilk","crimson","cyan","darkblue","darkcyan","darkgoldenrod","darkgray","darkgreen","darkkhaki","darkmagenta","darkolivegreen","darkorange","darkorchid","darkred","darksalmon","darkseagreen","darkslateblue","darkslategray","darkturquoise","darkviolet","deeppink","deepskyblue","dimgray","dodgerblue","firebrick","floralwhite","forestgreen","fuchsia","gainsboro","ghostwhite","gold","goldenrod","gray","grey","green","greenyellow","honeydew","hotpink","indianred","indigo","ivory","khaki","lavender","lavenderblush","lawngreen","lemonchiffon","lightblue","lightcoral","lightcyan","lightgoldenrodyellow","lightgray","lightgreen","lightpink","lightsalmon","lightseagreen","lightskyblue","lightslategray","lightsteelblue","lightyellow","lime","limegreen","linen","magenta","maroon","mediumaquamarine","mediumblue","mediumorchid","mediumpurple","mediumseagreen","mediumslateblue","mediumspringgreen","mediumturquoise","mediumvioletred","midnightblue","mintcream","mistyrose","moccasin","navajowhite","navy","oldlace","olive","olivedrab","orange","orangered","orchid","palegoldenrod","palegreen","paleturquoise","palevioletred","papayawhip","peachpuff","peru","pink","plum","powderblue","purple","rebeccapurple","red","rosybrown","royalblue","saddlebrown","salmon","sandybrown","seagreen","seashell","sienna","silver","skyblue","slateblue","slategray","snow","springgreen","steelblue","tan","teal","thistle","tomato","turquoise","violet","wheat","white","whitesmoke","yellow","yellowgreen"].map(e=>({type:"constant",label:e}))),_I=["a","abbr","address","article","aside","b","bdi","bdo","blockquote","body","br","button","canvas","caption","cite","code","col","colgroup","dd","del","details","dfn","dialog","div","dl","dt","em","figcaption","figure","footer","form","header","hgroup","h1","h2","h3","h4","h5","h6","hr","html","i","iframe","img","input","ins","kbd","label","legend","li","main","meter","nav","ol","output","p","pre","ruby","section","select","small","source","span","strong","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","tr","u","ul"].map(e=>({type:"type",label:e})),TI=["@charset","@color-profile","@container","@counter-style","@font-face","@font-feature-values","@font-palette-values","@import","@keyframes","@layer","@media","@namespace","@page","@position-try","@property","@scope","@starting-style","@supports","@view-transition"].map(e=>({type:"keyword",label:e})),EI=/^(\w[\w-]*|-\w[\w-]*|)$/,MI=/^-(-[\w-]*)?$/;const DI=new UB,PI=["Declaration"];function RI(e){for(let t=e;;){if(t.type.isTop)return t;if(!(t=t.parent))return e}}function II(e,t,n){if(t.to-t.from>4096){let r=DI.get(t);if(r)return r;let i=[],o=new Set,s=t.cursor(_B.IncludeAnonymous);if(s.firstChild())do{for(let t of II(e,s.node,n))o.has(t.label)||(o.add(t.label),i.push(t))}while(s.nextSibling());return DI.set(t,i),i}{let r=[],i=new Set;return t.cursor().iterate(t=>{var o;if(n(t)&&t.matchContext(PI)&&":"==(null===(o=t.node.nextSibling)||void 0===o?void 0:o.name)){let n=e.sliceString(t.from,t.to);i.has(n)||(i.add(n),r.push({label:n,type:"variable"}))}}),r}}const LI=e=>t=>{let{state:n,pos:r}=t,i=E_(n).resolveInner(r,-1),o=i.type.isError&&i.from==i.to-1&&"-"==n.doc.sliceString(i.from,i.to);if("PropertyName"==i.name||(o||"TagName"==i.name)&&/^(Block|Styles)$/.test(i.resolve(i.to).name))return{from:i.from,options:SI(),validFor:EI};if("ValueName"==i.name)return{from:i.from,options:BI,validFor:EI};if("PseudoClassName"==i.name)return{from:i.from,options:OI,validFor:EI};if(e(i)||(t.explicit||o)&&function(e,t){var n;if(("("==e.name||e.type.isError)&&(e=e.parent||e),"ArgList"!=e.name)return!1;let r=null===(n=e.parent)||void 0===n?void 0:n.firstChild;return"Callee"==(null==r?void 0:r.name)&&"var"==t.sliceString(r.from,r.to)}(i,n.doc))return{from:e(i)||o?i.from:r,options:II(n.doc,RI(i),e),validFor:MI};if("TagName"==i.name){for(let{parent:e}=i;e;e=e.parent)if("Block"==e.name)return{from:i.from,options:SI(),validFor:EI};return{from:i.from,options:_I,validFor:EI}}if("AtKeyword"==i.name)return{from:i.from,options:TI,validFor:EI};if(!t.explicit)return null;let s=i.resolve(r),a=s.childBefore(r);return a&&":"==a.name&&"PseudoClassSelector"==s.name?{from:r,options:OI,validFor:EI}:a&&":"==a.name&&"Declaration"==s.name||"ArgList"==s.name?{from:r,options:BI,validFor:EI}:"Block"==s.name||"Styles"==s.name?{from:r,options:SI(),validFor:EI}:null},NI=LI(e=>"VariableName"==e.name),FI=T_.define({name:"css",parser:xI.configure({props:[U_.add({Declaration:eT()}),nT.add({"Block KeyframeList":function(e){let t=e.firstChild,n=e.lastChild;return t&&t.to<n.from?{from:t.to,to:n.type.isError?e.to:n.from}:null}})]}),languageData:{commentTokens:{block:{open:"/*",close:"*/"}},indentOnInput:/^\s*\}$/,wordChars:"-"}});function QI(e,t){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=function(e,t){if(e){if("string"==typeof e)return VI(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?VI(e,t):void 0}}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,i=function(){};return{s:i,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:i}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,s=!0,a=!1;return{s:function(){n=n.call(e)},n:function(){var e=n.next();return s=e.done,e},e:function(e){a=!0,o=e},f:function(){try{s||null==n.return||n.return()}finally{if(a)throw o}}}}function VI(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}var zI={class:"trp-custom-css-editor"},$I={key:0,class:"trp-field__label trp-primary-text-bold"};const HI={__name:"CustomCssAreaField",props:{label:{type:String,default:""},visible:{type:Boolean,default:!1},modelValue:{type:String,default:""}},emits:["update:modelValue"],setup:function(e,t){var n=t.emit,r=e,i=n,o=Ut(r.modelValue),s=Ut(""),a=[new V_(FI,FI.data.of({autocomplete:NI}))],l=Yt(null),c=function(e){var t,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:300;return function(){for(var r=arguments.length,i=new Array(r),o=0;o<r;o++)i[o]=arguments[o];clearTimeout(t),t=setTimeout(function(){e.apply(void 0,i)},n)}}(function(e){var t=f(e);s.value=t,i("update:modelValue",t)},300);ns(function(){return r.modelValue},function(e){e!==s.value&&e!==o.value&&(o.value=e)}),ns(o,function(e){return c(e)}),ns(s,function(e){d&&(d.textContent=e)});var h=function(e){var t=e.view;return l.value=t},d=null,u=function(){!d&&r.visible&&((d=document.createElement("style")).dataset.customCss="",d.textContent=f(o.value),document.head.appendChild(d))},p=function(){d&&(d.remove(),d=null)},f=function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:".trp-language-switcher",n=document.createElement("style");n.textContent=e,document.head.appendChild(n);var r=n.sheet;document.head.removeChild(n);var i,o=[],s=QI(r.cssRules);try{for(s.s();!(i=s.n()).done;){var a=i.value;if(a instanceof CSSStyleRule){var l=a.selectorText.split(",").map(function(e){return(e=e.trim()).startsWith(t)?e:"".concat(t," ").concat(e)}).join(", ");o.push("".concat(l," { ").concat(a.style.cssText," }"))}else if(a instanceof CSSMediaRule){var c,h=[],d=QI(a.cssRules);try{for(d.s();!(c=d.n()).done;){var u=c.value;if(u instanceof CSSStyleRule){var p=u.selectorText.split(",").map(function(e){return(e=e.trim()).startsWith(t)?e:"".concat(t," ").concat(e)}).join(", ");h.push("".concat(p," { ").concat(u.style.cssText," }"))}else h.push(u.cssText)}}catch(e){d.e(e)}finally{d.f()}o.push("@media ".concat(a.media.mediaText," {\n").concat(h.join("\n"),"\n}"))}else o.push(a.cssText)}}catch(e){s.e(e)}finally{s.f()}return o.join("\n")};return ns(function(){return r.visible},function(e){e?u():p()}),vi(function(){r.visible&&u()}),yi(p),function(t,n){return tr((Ds(),Fs("div",zI,[e.label?(Ds(),Fs("label",$I,fe(e.label),1)):Ks("",!0),Ws(Kt(IR),{modelValue:o.value,"onUpdate:modelValue":n[0]||(n[0]=function(e){return o.value=e}),placeholder:"Write custom CSS here...",style:{height:"250px",width:"80%",fontSize:"14px",fontFamily:"monospace"},"indent-with-tab":!0,"tab-size":2,extensions:a,onReady:h},null,8,["modelValue"])],512)),[[bl,e.visible]])}}};var jI=n(793),qI={insert:"head",singleton:!1};xg()(jI.A,qI);jI.A.locals;const WI=HI;var UI=Pt({floater:"desktop",shortcode:"desktop"});function YI(e){e&&UI.hasOwnProperty(e)||(console.warn("Attempted to use usePreviewViewport with unknown or missing scope: ".concat(e,". Defaulting to 'desktop'.")),UI[e]="desktop");return{selectedViewport:Ea(function(){return UI[e]}),setViewport:function(t){UI.hasOwnProperty(e)?UI[e]=t:console.warn("Attempted to set viewport for unknown scope: ".concat(e))}}}function GI(e){return GI="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},GI(e)}function XI(e){return function(e){if(Array.isArray(e))return JI(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(e){if("string"==typeof e)return JI(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?JI(e,t):void 0}}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function JI(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}function KI(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,r)}return n}function ZI(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?KI(Object(n),!0).forEach(function(t){eL(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):KI(Object(n)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}function eL(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=GI(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var r=n.call(e,t||"default");if("object"!=GI(r))return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==GI(t)?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}var tL={class:"trp-layout-customizer-field trp-field trp-field--column"},nL={key:0,class:"trp-field__label trp-primary-text-bold"},rL={key:1,class:"trp-settings-separator"},iL={class:"trp-lc-mode-toggle"},oL={class:"trp-lc-settings-panel"},sL={key:0,class:"trp-lc-section"},aL={class:"trp-lc-subfield"},lL={class:"trp-lc-subfield"},cL={class:"trp-lc-subfield"},hL={class:"trp-lc-subfield"},dL={key:1,class:"trp-lc-subfield"},uL={class:"trp-lc-subfield"},pL={key:1,class:"trp-lc-section"},fL={class:"trp-lc-subfield"},gL={class:"trp-lc-subfield"},mL={class:"trp-lc-subfield"},vL={class:"trp-lc-subfield"},bL={key:1,class:"trp-lc-subfield"},AL={class:"trp-lc-subfield"};const yL={__name:"LayoutCustomizerField",props:{label:{type:String,default:""},modelValue:{type:Object,default:function(){return{desktop:{},mobile:{}}}},scope:{type:String,required:!0}},emits:["update:modelValue","update:customValue"],setup:function(e,t){var n=t.emit,r=[{value:"bottom-right",label:"Bottom Right"},{value:"bottom-left",label:"Bottom Left"},{value:"top-right",label:"Top Right"},{value:"top-left",label:"Top Left"}],i=[{value:"before",label:"Before Language"},{value:"after",label:"After Language"},{value:"hide",label:"Hide Icons"}],o=[{value:"rect",label:"Rectangle 4:3"},{value:"square",label:"Square 1:1"},{value:"rounded",label:"Rounded"}],s=[{value:"full",label:"Full Names"},{value:"short",label:"Short Names"},{value:"none",label:"No Names"}],a=e,l=n,c=Pt({desktop:ZI({},a.modelValue.desktop),mobile:ZI({},a.modelValue.mobile)});ns(function(){return c},function(e){l("update:modelValue",{desktop:ZI({},e.desktop),mobile:ZI({},e.mobile)})},{deep:!0}),ns(function(){return a.modelValue},function(e){e.desktop&&Object.assign(c.desktop,e.desktop),e.mobile&&Object.assign(c.mobile,e.mobile)});var h=YI(a.scope),d=h.selectedViewport,u=h.setViewport,p=(a.scope,"menu"===a.scope),f="floater"===a.scope;return function(t,n){return Ds(),Fs("div",tL,[e.label?(Ds(),Fs("span",nL,fe(e.label),1)):Ks("",!0),"menu"===e.scope?(Ds(),Fs("div",rL)):Ks("",!0),qs("div",iL,[qs("button",{class:J(["trp-lc-mode-button",{active:"desktop"===Kt(d)}]),onClick:n[0]||(n[0]=function(e){return Kt(u)("desktop")}),type:"button"},XI(n[18]||(n[18]=[qs("svg",{width:"20",height:"20",viewBox:"0 0 20 20",fill:"none",xmlns:"http://www.w3.org/2000/svg"},[qs("path",{"fill-rule":"evenodd","clip-rule":"evenodd",d:"M3 2H17C17.55 2 18 2.45 18 3V13C18 13.55 17.55 14 17 14H12V16H14\r\n                   C14.55 16 15 16.45 15 17V18H5V17C5 16.45 5.45 16 6 16H8V14H3\r\n                   C2.45 14 2 13.55 2 13V3C2 2.45 2.45 2 3 2ZM16 11V4H4V11H16Z",fill:"#1D2327"})],-1),qs("span",null,"Desktop",-1)])),2),qs("button",{class:J(["trp-lc-mode-button",{active:"mobile"===Kt(d)}]),onClick:n[1]||(n[1]=function(e){return Kt(u)("mobile")}),type:"button"},XI(n[19]||(n[19]=[qs("svg",{width:"20",height:"20",viewBox:"0 0 20 20",fill:"none",xmlns:"http://www.w3.org/2000/svg"},[qs("path",{"fill-rule":"evenodd","clip-rule":"evenodd",d:"M6 2H14C14.55 2 15 2.45 15 3V17C15 17.55 14.55 18 14 18H6\r\n                   C5.45 18 5 17.55 5 17V3C5 2.45 5.45 2 6 2ZM13 14V4H7V14H13Z",fill:"#1D2327"})],-1),qs("span",null,"Mobile",-1)])),2)]),qs("div",oL,["desktop"===Kt(d)?(Ds(),Fs("div",sL,[f?(Ds(),Fs(Os,{key:0},[qs("div",aL,[Ws(lA,{label:"Switcher Position",modelValue:c.desktop.position,"onUpdate:modelValue":n[2]||(n[2]=function(e){return c.desktop.position=e}),options:r},null,8,["modelValue"])]),qs("div",lL,[Ws(lA,{label:"Switcher Width",modelValue:c.desktop.width,"onUpdate:modelValue":n[3]||(n[3]=function(e){return c.desktop.width=e}),customValue:c.desktop.customWidth,"onUpdate:customValue":n[4]||(n[4]=function(e){return c.desktop.customWidth=e}),options:[{value:"default",label:"Default"}]},null,8,["modelValue","customValue"])]),qs("div",cL,[Ws(lA,{label:"Switcher Padding",modelValue:c.desktop.padding,"onUpdate:modelValue":n[5]||(n[5]=function(e){return c.desktop.padding=e}),customValue:c.desktop.customPadding,"onUpdate:customValue":n[6]||(n[6]=function(e){return c.desktop.customPadding=e}),options:[{value:"default",label:"Default"}]},null,8,["modelValue","customValue"])])],64)):Ks("",!0),qs("div",hL,[Ws(lA,{label:"Flag Icons Position",modelValue:c.desktop.flagIconPosition,"onUpdate:modelValue":n[7]||(n[7]=function(e){return c.desktop.flagIconPosition=e}),options:i},null,8,["modelValue"])]),p?(Ds(),Fs("div",dL,[Ws(lA,{label:"Flag icons",modelValue:c.desktop.flagShape,"onUpdate:modelValue":n[8]||(n[8]=function(e){return c.desktop.flagShape=e}),options:o},null,8,["modelValue"])])):Ks("",!0),qs("div",uL,[Ws(lA,{label:"Language Names",modelValue:c.desktop.languageNames,"onUpdate:modelValue":n[9]||(n[9]=function(e){return c.desktop.languageNames=e}),options:s},null,8,["modelValue"])])])):(Ds(),Fs("div",pL,[f?(Ds(),Fs(Os,{key:0},[qs("div",fL,[Ws(lA,{label:"Switcher Position",modelValue:c.mobile.position,"onUpdate:modelValue":n[10]||(n[10]=function(e){return c.mobile.position=e}),options:r},null,8,["modelValue"])]),qs("div",gL,[Ws(lA,{label:"Switcher Width",modelValue:c.mobile.width,"onUpdate:modelValue":n[11]||(n[11]=function(e){return c.mobile.width=e}),customValue:c.mobile.customWidth,"onUpdate:customValue":n[12]||(n[12]=function(e){return c.mobile.customWidth=e}),options:[{value:"default",label:"Default"}]},null,8,["modelValue","customValue"])]),qs("div",mL,[Ws(lA,{label:"Switcher Padding",modelValue:c.mobile.padding,"onUpdate:modelValue":n[13]||(n[13]=function(e){return c.mobile.padding=e}),customValue:c.mobile.customPadding,"onUpdate:customValue":n[14]||(n[14]=function(e){return c.mobile.customPadding=e}),options:[{value:"default",label:"Default"}]},null,8,["modelValue","customValue"])])],64)):Ks("",!0),qs("div",vL,[Ws(lA,{label:"Flag Icons Position",modelValue:c.mobile.flagIconPosition,"onUpdate:modelValue":n[15]||(n[15]=function(e){return c.mobile.flagIconPosition=e}),options:i},null,8,["modelValue"])]),p?(Ds(),Fs("div",bL,[Ws(lA,{label:"Flag icons",modelValue:c.desktop.flagShape,"onUpdate:modelValue":n[16]||(n[16]=function(e){return c.desktop.flagShape=e}),options:o},null,8,["modelValue"])])):Ks("",!0),qs("div",AL,[Ws(lA,{label:"Language Names",modelValue:c.mobile.languageNames,"onUpdate:modelValue":n[17]||(n[17]=function(e){return c.mobile.languageNames=e}),options:s},null,8,["modelValue"])])]))])])}}};var wL=n(85),CL={insert:"head",singleton:!1};xg()(wL.A,CL);wL.A.locals;const xL=(0,Tb.A)(yL,[["__scopeId","data-v-446a0a1f"]]);var kL=["title"],SL=["disabled"],OL={class:"trp-checkbox-content"},BL={key:0,class:"trp-primary-text-bold"},_L=["innerHTML"];const TL={__name:"CheckboxField",props:{modelValue:{type:Boolean,required:!0},label:{type:String,default:""},description:{type:String,default:""},disabled:{type:Boolean,default:!1},title:{type:String,default:""}},emits:["update:modelValue"],setup:function(e,t){var n=t.emit,r=e,i=n,o="trp-checkbox-".concat(Math.random().toString(36).slice(2)),s=Ea({get:function(){return!0===r.modelValue},set:function(e){return i("update:modelValue",e)}});return function(t,n){return Ds(),Fs("div",{class:"trp-settings-checkbox trp-settings-options-item",title:r.title},[tr(qs("input",{type:"checkbox",id:o,"onUpdate:modelValue":n[0]||(n[0]=function(e){return s.value=e}),disabled:r.disabled},null,8,SL),[[cc,s.value]]),qs("label",{for:o,class:"trp-checkbox-label"},[qs("div",OL,[e.label?(Ds(),Fs("span",BL,fe(e.label),1)):Ks("",!0),e.description?(Ds(),Fs("span",{key:1,class:"trp-description-text",innerHTML:e.description},null,8,_L)):Ks("",!0)])])],8,kL)}}};var EL=n(482),ML={insert:"head",singleton:!1};xg()(EL.A,ML);EL.A.locals;const DL=(0,Tb.A)(TL,[["__scopeId","data-v-2e0e42ea"]]);function PL(e){return PL="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},PL(e)}function RL(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,r)}return n}function IL(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?RL(Object(n),!0).forEach(function(t){LL(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):RL(Object(n)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}function LL(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=PL(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var r=n.call(e,t||"default");if("object"!=PL(r))return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==PL(t)?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function NL(e){return function(e){if(Array.isArray(e))return FL(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(e){if("string"==typeof e)return FL(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?FL(e,t):void 0}}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function FL(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}var QL={class:"trp-title"},VL={class:"trp-body"},zL={key:0,class:"trp-separator"};const $L={__name:"SettingsBox",props:{title:{type:String,required:!0},fields:{type:Array,required:!1,default:[]},collapsible:{type:Boolean,default:!1},scope:{type:String,required:!0}},setup:function(e){var t={color:Eb,number:Nb,toggle:jb,toggleStatus:Xb,radio:lA,quadNumber:bA,customCss:WI,lCustomizer:xL,checkbox:DL},n=e,r=yg(n.scope),i=Ut(!n.collapsible),o=Pt({});return n.fields.forEach(function(e){"separator"===e.type||o[e.key]||(void 0===r[e.key]&&void 0!==e.default&&(r[e.key]=e.default),o[e.key]=Ea({get:function(){return r[e.key]},set:function(t){return r[e.key]=t}}))}),function(s,a){return Ds(),Fs("div",{class:J(["trp-settings-box",{"trp-collapsible":n.collapsible}])},[qs("header",{class:"trp-header",onClick:a[0]||(a[0]=function(e){return n.collapsible&&(i.value=!i.value)})},[qs("span",QL,fe(n.title),1),n.collapsible?(Ds(),Fs("svg",{key:0,class:J(["trp-chevron",{open:i.value}]),viewBox:"0 0 20 20",width:"20",height:"20"},NL(a[1]||(a[1]=[qs("path",{d:"M5 6L10 11L15 6L17 7L10 14L3 7L5 6Z",fill:"#9CA1A8"},null,-1)])),2)):Ks("",!0)]),tr(qs("section",VL,[s.$slots.default?Li(s.$slots,"default",{key:0}):Ks("",!0),(Ds(!0),Fs(Os,null,Ri(n.fields,function(n){return Ds(),Fs(Os,{key:n.key||n.type},["separator"===n.type?(Ds(),Fs("div",zL)):(Ds(),Qs(Ei(t[n.type]),na({key:1,modelValue:o[n.key],"onUpdate:modelValue":function(e){return o[n.key]=e}},{ref_for:!0},IL(IL({},n),{},{visible:!n.visible||n.visible(Kt(r))}),{scope:e.scope,class:["trp-field",n.hasOwnProperty("layout")?"trp-field--column":"trp-field--row"]}),null,16,["modelValue","onUpdate:modelValue","scope","class"]))],64)}),128)),Li(s.$slots,"end")],512),[[bl,i.value]])],2)}}};var HL=n(751),jL={insert:"head",singleton:!1};xg()(HL.A,jL);HL.A.locals;const qL=(0,Tb.A)($L,[["__scopeId","data-v-2daa727d"]]);function WL(e,t,n,r){var i=arguments.length>4&&void 0!==arguments[4]?arguments[4]:function(e){return e},o=arguments.length>5&&void 0!==arguments[5]?arguments[5]:void 0;return Ea(function(){var s=e.layoutCustomizer[t.value];if(o){var a=s[o],l=s[n];return i("custom"===a&&"number"==typeof l&&l>=0?l:r)}var c=null==s?void 0:s[n];return i(null==c||"default"===c||"number"==typeof c&&c<=0?r:c)})}function UL(e){return UL="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},UL(e)}var YL=["skip"];function GL(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,r)}return n}function XL(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=UL(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var r=n.call(e,t||"default");if("object"!=UL(r))return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==UL(t)?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function JL(e){var t=yg(e),n=YI(e).selectedViewport;if("menu"===e){var r=WL(t,n,"flagIconPosition","before"),i=WL(t,n,"flagShape","rect"),o=WL(t,n,"languageNames","full");return{positioning:Ea(function(){return{flagPos:r.value,flagShape:i.value,languageNames:o.value}})}}var s="10px 0",a="bottom-right",l="full",c="before",h=WL(t,n,"customWidth","auto",function(e){return"number"==typeof e?"".concat(e,"px"):e},"width"),d=WL(t,n,"customPadding",s,function(e){return"number"==typeof e?"".concat(e,"px"):e},"padding"),u=WL(t,n,"position",a),p=WL(t,n,"flagIconPosition",c),f=WL(t,n,"languageNames",l),g=Ea(function(){var e,n=d.value,r=null!==(e={"bottom-right":{"--bottom":"0px","--right":"14px",skip:"bottom"},"bottom-left":{"--bottom":"0px","--left":"14px",skip:"bottom"},"top-right":{"--top":"0px","--right":"14px",skip:"top"},"top-left":{"--top":"0px","--left":"14px",skip:"top"}}[u.value])&&void 0!==e?e:{},i=r.skip,o=function(e,t){if(null==e)return{};var n,r,i=function(e,t){if(null==e)return{};var n={};for(var r in e)if({}.hasOwnProperty.call(e,r)){if(-1!==t.indexOf(r))continue;n[r]=e[r]}return n}(e,t);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);for(r=0;r<o.length;r++)n=o[r],-1===t.indexOf(n)&&{}.propertyIsEnumerable.call(e,n)&&(i[n]=e[n])}return i}(r,YL),s=t.borderWidth||0,a=["top"===i?"0":"".concat(s,"px"),"".concat(s,"px"),"bottom"===i?"0":"".concat(s,"px"),"".concat(s,"px")].join(" ");return function(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?GL(Object(n),!0).forEach(function(t){XL(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):GL(Object(n)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}({"--switcher-width":h.value,"--switcher-padding":n,"--border-width":a},o)});return{styleVars:g,positioning:Ea(function(){return{flagPos:p.value,languageNames:f.value}}),switcherPosition:u}}function KL(e){return KL="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},KL(e)}function ZL(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,r)}return n}function eN(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?ZL(Object(n),!0).forEach(function(t){tN(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):ZL(Object(n)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}function tN(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=KL(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var r=n.call(e,t||"default");if("object"!=KL(r))return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==KL(t)?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function nN(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=n){var r,i,o,s,a=[],l=!0,c=!1;try{if(o=(n=n.call(e)).next,0===t){if(Object(n)!==n)return;l=!1}else for(;!(l=(r=o.call(n)).done)&&(a.push(r.value),a.length!==t);l=!0);}catch(e){c=!0,i=e}finally{try{if(!l&&null!=n.return&&(s=n.return(),Object(s)!==s))return}finally{if(c)throw i}}return a}}(e,t)||function(e,t){if(e){if("string"==typeof e)return rN(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?rN(e,t):void 0}}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function rN(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}function iN(e){var t=yg(e),n=wg().published,r=JL(e),i=r.styleVars,o=r.switcherPosition,s=Object.entries(n).map(function(e){var t=nN(e,2);return eN({code:t[0]},t[1])}),a=Ea(function(){return"dropdown"===t.type}),l=Ea(function(){return!0===t.oppositeLanguage}),c=Ea(function(){return t.showPoweredBy}),h=Ea(function(){if(!0===t.oppositeLanguage)return s.slice(1,2);var n=a.value||"floater"!==e?4:2;return s.slice(0,n)}),d=Ea(function(){return"large"===t.size}),u=Ea(function(){var n,r={"--bg":t.bgColor,"--bg-hover":t.bgHoverColor,"--text":t.textColor,"--text-hover":t.textHoverColor,"--border-color":t.borderColor,"--border-radius":oN(t.borderRadius),"--font-size":d.value?"16px":"14px","--flag-size":d.value?"20px":"18px","--flag-radius":"".concat(t.flagRadius,"px"),"--aspect-ratio":"rect"===t.flagShape?"4/3":"1","--transition-duration":t.enableTransitions?"0.2s":"0s"},o={shortcode:function(){return eN(eN({},r),{},{"--border-width":t.borderWidth+"px"})},floater:function(){return eN(eN({},r),i.value)}};return(null===(n=o[e])||void 0===n?void 0:n.call(o))||r}),p=Ea(function(){return!0===t.clickLanguage});return{isDropdown:a,isOppositeMode:l,displayedList:h,switcherStyles:u,showPoweredBy:c,switcherPosition:o,openOnClick:p}}function oN(e){if(Array.isArray(e)){var t=nN(e,4),n=t[0],r=void 0===n?0:n,i=t[1],o=void 0===i?0:i,s=t[2],a=void 0===s?0:s,l=t[3],c=void 0===l?0:l;return"".concat(r,"px ").concat(o,"px ").concat(a,"px ").concat(c,"px")}return"number"==typeof e?"".concat(e,"px"):"0px"}var sN=["src"],aN={key:1,class:"trp-language-item-name"},lN=["src"];const cN={__name:"LanguageItem",props:{language:{type:Object,required:!0},dropdown:{type:Boolean,default:!1},flagPos:String,nameMode:String,flagAspectRatio:String},setup:function(e){var t,n=e,r=xo("languageItemSettings"),i=(null===(t=window)||void 0===t||null===(t=t.tpLangSwitcherData)||void 0===t||null===(t=t.misc)||void 0===t?void 0:t.pluginUrl)||"",o=Ea(function(){var e,t;return null!==(e=null!==(t=n.flagPos)&&void 0!==t?t:null==r?void 0:r.value.flagPos)&&void 0!==e?e:"before"}),s=Ea(function(){var e,t;return null!==(e=null!==(t=n.nameMode)&&void 0!==t?t:null==r?void 0:r.value.nameMode)&&void 0!==e?e:"full"}),a=Ea(function(){return"hide"!==o.value}),l=Ea(function(){return"none"!==s.value}),c=Ea(function(){return"before"===o.value}),h=Ea(function(){return"after"===o.value}),d=Ea(function(){var e,t;return"square"===(null!==(e=n.flagAspectRatio)&&void 0!==e?e:null==r||null===(t=r.value.flagRatio)||void 0===t?void 0:t.value)?"1x1":"4x3"}),u=Ea(function(){var e,t,r;if(!a.value)return null;if(n.language.flagPath)return n.language.flagPath;var o=null!==(e=null!==(t=null!==(r=n.language.locale)&&void 0!==r?r:n.language.code)&&void 0!==t?t:n.language.slug)&&void 0!==e?e:"",s=String(o).trim();if(!s||!i)return null;var l=s.replace(/-/g,"_")+".svg";return"".concat(i,"assets/flags/").concat(d.value,"/").concat(encodeURIComponent(l))}),p=Ea(function(){return"short"===s.value?n.language.shortName:n.language.name});return function(t,n){return Ds(),Fs("a",{class:J(["trp-language-item",{"trp-dropdown-item":e.dropdown}])},[c.value&&a.value?(Ds(),Fs(Os,{key:0},[u.value?(Ds(),Fs("img",{key:0,src:u.value,class:"trp-flag-image","aria-hidden":"true",loading:"lazy",decoding:"async"},null,8,sN)):Ks("",!0)],64)):Ks("",!0),l.value?(Ds(),Fs("span",aN,fe(p.value),1)):Ks("",!0),h.value&&a.value?(Ds(),Fs(Os,{key:2},[u.value?(Ds(),Fs("img",{key:0,src:u.value,class:"trp-flag-image","aria-hidden":"true",loading:"lazy",decoding:"async"},null,8,lN)):Ks("",!0)],64)):Ks("",!0)],2)}}};var hN=n(846),dN={insert:"head",singleton:!1};xg()(hN.A,dN);hN.A.locals;const uN=(0,Tb.A)(cN,[["__scopeId","data-v-fa610bac"]]);var pN={key:0,class:"trp-switcher-preview trp-dropdown-preview"},fN={key:1,class:"trp-switcher-preview trp-preview-ls-inline"};const gN={__name:"PresetPreviewLanguageSwitcher",props:{scope:{type:String,required:!0,validator:function(e){return["floater","shortcode","menu"].includes(e)}}},setup:function(e){var t=iN(e.scope),n=t.displayedList,r=t.isDropdown;return function(e,t){return Kt(r)?(Ds(),Fs("div",pN,[(Ds(!0),Fs(Os,null,Ri(Kt(n),function(e){return Ds(),Qs(uN,{key:e.code,language:e,dropdown:!0},null,8,["language"])}),128))])):(Ds(),Fs("div",fN,[(Ds(!0),Fs(Os,null,Ri(Kt(n),function(e){return Ds(),Qs(uN,{key:e.code,language:e,dropdown:!1},null,8,["language"])}),128))]))}}};var mN=n(571),vN={insert:"head",singleton:!1};xg()(mN.A,vN);mN.A.locals;const bN=(0,Tb.A)(gN,[["__scopeId","data-v-2f8e6670"]]),AN=wp.i18n;var yN="translatepress-multilingual",wN=function(e){return(0,AN.__)(e,yN)},CN=AN.sprintf;function xN(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=n){var r,i,o,s,a=[],l=!0,c=!1;try{if(o=(n=n.call(e)).next,0===t){if(Object(n)!==n)return;l=!1}else for(;!(l=(r=o.call(n)).done)&&(a.push(r.value),a.length!==t);l=!0);}catch(e){c=!0,i=e}finally{try{if(!l&&null!=n.return&&(s=n.return(),Object(s)!==s))return}finally{if(c)throw i}}return a}}(e,t)||function(e,t){if(e){if("string"==typeof e)return kN(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?kN(e,t):void 0}}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function kN(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}var SN={class:"trp-preset-applier"},ON={key:0,class:"trp-confirmation-dialog"},BN=["innerHTML"],_N={class:"trp-primary-text trp-confirmation-overwrite-warning"},TN={class:"trp-dialog-actions"},EN=["onClick"];const MN={__name:"PresetApplier",props:{scope:{type:String,required:!0,validator:function(e){return["floater","shortcode","menu"].includes(e)}}},setup:function(e){var t=yg(e.scope),n={presetDefault:wN("Default"),presetDark:wN("Dark"),presetBorder:wN("Border"),presetTransparent:wN("Transparent"),confirmTitleHtml:wN("Are you sure you want to apply the <strong>%s</strong> preset?"),confirmOverwrite:wN("It will override your current settings."),applyPreset:wN("Apply preset"),cancel:wN("Cancel"),applyPresetWithName:wN("Apply %s preset")},r=[{id:"default",name:n.presetDefault,settings:{bgColor:"#ffffff",bgHoverColor:"#0000000D",textColor:"#143852",textHoverColor:"#1D2327",borderColor:"#1438521A"}},{id:"dark",name:n.presetDark,settings:{bgColor:"#000000",bgHoverColor:"#444444",textColor:"#ffffff",textHoverColor:"#eeeeee",borderColor:"transparent"}},{id:"border",name:n.presetBorder,settings:{bgColor:"#FFFFFF",bgHoverColor:"#000000",textColor:"#143852",textHoverColor:"#ffffff",borderColor:"#143852"}},{id:"transparent",name:n.presetTransparent,settings:{bgColor:"#FFFFFFB2",bgHoverColor:"#FFFFFFB2",textColor:"#000000",textHoverColor:"#000000",borderColor:"transparent"}}];var i=Ut(null);function o(){i.value=null}function s(){i.value&&(Object.entries(i.value.settings).forEach(function(e){var n=xN(e,2),r=n[0],i=n[1];t[r]=i}),i.value=null)}return function(t,a){return Ds(),Fs("div",SN,[(Ds(),Fs(Os,null,Ri(r,function(t){return qs("div",{key:t.id,class:"trp-preset-card",style:W((r=t.settings,{"--bg":r.bgColor,"--bg-hover":r.bgHoverColor,"--text":r.textColor,"--text-hover":r.textHoverColor,"--border-color":r.borderColor}))},[qs("div",{class:"trp-preview-rect",style:W({background:"transparent"===t.id?"linear-gradient(145.41deg, #2271B1 20.41%, #D3B4DA 96.59%)":"#DBDBDB"})},[Ws(bN,{scope:e.scope},null,8,["scope"]),i.value&&i.value.id===t.id?(Ds(),Fs("div",ON,[qs("p",{class:"trp-primary-text",innerHTML:Kt(CN)(n.confirmTitleHtml,t.name)},null,8,BN),qs("p",_N,fe(n.confirmOverwrite),1),qs("div",TN,[qs("button",{class:"trp-confirm-button",onClick:s},fe(n.applyPreset),1),qs("span",{class:"trp-description-text trp-cancel-button",onClick:o},fe(n.cancel),1)])])):Ks("",!0)],4),qs("button",{class:"trp-apply-btn",onClick:function(e){return function(e){i.value=e}(t)}},fe(Kt(CN)(n.applyPresetWithName,t.name)),9,EN)],4);var r}),64))])}}};var DN=n(640),PN={insert:"head",singleton:!1};xg()(DN.A,PN);DN.A.locals;const RN=(0,Tb.A)(MN,[["__scopeId","data-v-5bd5ef9e"]]);var IN={id:"trp-floater-powered-by"},LN=["innerHTML"];const NN={__name:"PoweredBy",setup:function(e){return function(e,t){return Ds(),Fs("div",IN,[qs("span",{innerHTML:Kt(wN)('Powered by <a href="https://translatepress.com/?utm_source=frontend-ls&utm_medium=client-site&utm_campaign=powered-by-tp" rel="nofollow" target="_blank" title="WordPress Translation Plugin">TranslatePress</a>')},null,8,LN)])}}};var FN=n(111),QN={insert:"head",singleton:!1};xg()(FN.A,QN);FN.A.locals;const VN=(0,Tb.A)(NN,[["__scopeId","data-v-2764dcda"]]);var zN={class:"trp-language-switcher-preview__container"},$N={class:"trp-language-switcher-preview-box"},HN={class:"trp-language-switcher-inner"},jN={class:"trp-switcher-dropdown-list"},qN={class:"trp-language-switcher-inner"},WN={class:"trp-language-switcher-inner"},UN={key:0,class:"trp-switcher-dropdown-list"},YN={class:"trp-language-switcher-preview-text trp-description-text"};const GN={__name:"LanguageSwitcherPreview",props:{scope:{type:String,default:"",validator:function(e){return["floater","shortcode","menu"].includes(e)}}},setup:function(e){wl(function(e){return{v0a032f7b:t}});var t="url(".concat(window.tpLangSwitcherData.misc.pluginUrl,"assets/images/switcher-preview-bg.png)"),n=e,r=Ut(!1),i=Ea(function(){return"shortcode"===n.scope}),o=wN("Hover over the language switcher to see it in action!"),s=Ea(function(){var e,t;return"floater"!==n.scope?null:null!==(e=p.value)&&void 0!==e&&e.startsWith("top")?"trp-switcher-position-top":null!==(t=p.value)&&void 0!==t&&t.startsWith("bottom")?"trp-switcher-position-bottom":null}),a=iN(n.scope),l=a.displayedList,c=a.isDropdown,h=a.switcherStyles,d=a.isOppositeMode,u=a.showPoweredBy,p=a.switcherPosition,f=a.openOnClick,g=Ea(function(){return i.value&&!d.value&&f.value}),m=Ea(function(){return i.value?[d.value?"trp-opposite-button":null,g.value?"trp-open-on-click":"trp-open-on-hover",{"trp-dropdown-open":r.value&&!d.value}]:[]}),v=function(){i.value&&!d.value&&f.value&&(r.value=!r.value)};return function(e,t){return Ds(),Fs("div",zN,[qs("div",$N,[Kt(d)&&!i.value?(Ds(),Fs("div",{key:0,class:"trp-language-switcher trp-floating-switcher trp-opposite-button",style:W(Kt(h))},[Kt(l).length?(Ds(),Qs(uN,{key:Kt(l)[0].code,language:Kt(l)[0]},null,8,["language"])):Ks("",!0),Kt(u)?(Ds(),Qs(VN,{key:1})):Ks("",!0)],4)):i.value?(Ds(),Fs("div",{key:2,class:J(["trp-language-switcher trp-ls-dropdown trp-shortcode-switcher",m.value]),style:W(Kt(h)),onClick:v},[qs("div",WN,[qs("div",{class:J(["trp-current-language-item__wrapper",{"trp-hide-arrow":Kt(d)}])},[Kt(l).length?(Ds(),Qs(uN,{key:Kt(l)[0].code,language:Kt(l)[0],dropdown:!1,class:"trp-language-item__default"},null,8,["language"])):Ks("",!0),t[0]||(t[0]=qs("svg",{class:"trp-shortcode-arrow",width:"20",height:"20",viewBox:"0 0 20 21",fill:"none",xmlns:"http://www.w3.org/2000/svg"},[qs("path",{d:"M5 8L10 13L15 8",stroke:"var(--text)","stroke-width":"2","stroke-linecap":"round","stroke-linejoin":"round"})],-1))],2),Kt(d)?Ks("",!0):(Ds(),Fs("div",UN,[(Ds(!0),Fs(Os,null,Ri(Kt(l).slice(1),function(e){return Ds(),Qs(uN,{key:e.code,language:e,dropdown:!0},null,8,["language"])}),128))]))]),Kt(u)&&Kt(d)?(Ds(),Qs(VN,{key:0})):Ks("",!0)],6)):(Ds(),Fs(Os,{key:1},[Kt(c)?(Ds(),Fs("div",{key:0,class:J(["trp-language-switcher trp-floating-switcher trp-ls-dropdown",s.value]),style:W(Kt(h))},[Kt(u)?(Ds(),Qs(VN,{key:0})):Ks("",!0),qs("div",HN,[Kt(l).length?(Ds(),Qs(uN,{key:Kt(l)[0].code,language:Kt(l)[0],dropdown:!1,class:"trp-language-item__default"},null,8,["language"])):Ks("",!0),qs("div",jN,[(Ds(!0),Fs(Os,null,Ri(Kt(l).slice(1),function(e){return Ds(),Qs(uN,{key:e.code,language:e,dropdown:!0},null,8,["language"])}),128))])])],6)):(Ds(),Fs("div",{key:1,class:J(["trp-language-switcher trp-preview-ls-inline",s.value]),style:W(Kt(h))},[Kt(u)?(Ds(),Qs(VN,{key:0})):Ks("",!0),qs("div",qN,[(Ds(!0),Fs(Os,null,Ri(Kt(l),function(e){return Ds(),Qs(uN,{key:e.code,language:e},null,8,["language"])}),128))])],6))],64))]),qs("span",YN,fe(Kt(o)),1)])}}};var XN=n(101),JN={insert:"head",singleton:!1};xg()(XN.A,JN);XN.A.locals;const KN=(0,Tb.A)(GN,[["__scopeId","data-v-b9e7100a"]]);function ZN(e){return function(e){if(Array.isArray(e))return eF(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(e){if("string"==typeof e)return eF(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?eF(e,t):void 0}}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function eF(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}var tF={key:0,class:"trp-actions-overlay"},nF={class:"trp-settings-actions"},rF=["disabled"],iF={key:1},oF={key:2},sF=["disabled","title"],aF={width:"14",height:"14",viewBox:"0 0 14 14",fill:"none",xmlns:"http://www.w3.org/2000/svg",style:{"margin-right":"6px","vertical-align":"middle"}},lF={key:0,class:"trp-save-ls-error"},cF={key:0,class:"trp-revert-confirm"},hF={class:"trp-revert-text trp-primary-text"},dF={class:"trp-revert-actions"};const uF={__name:"SettingsActions",props:{scope:{type:String,required:!0}},setup:function(e){var t=e,n=xo("switcherPersistence"),r=n.save,i=n.revert,o=n.isDirty,s=n.saving,a=n.justSaved,l=n.errorMsg,c=Ut(!1);function h(){c.value=!0}function d(){c.value=!1}function u(){i(),c.value=!1}yg(t.scope);var p={saving:wN("Saving..."),saved:wN("Saved!"),saveChanges:wN("Save changes"),revertTitle:wN("Revert to last saved values"),revertChanges:wN("Revert changes"),revertConfirmText:wN("Restoring will revert to the last saved version and discard your current edits."),revertBtn:wN("Revert"),cancelBtn:wN("Keep editing")};return function(e,t){return Ds(),Fs(Os,null,[(Ds(),Qs(ur,{to:"body"},[c.value?(Ds(),Fs("div",tF)):Ks("",!0)])),qs("div",nF,[qs("button",{class:"trp-submit-btn",disabled:!Kt(o)||Kt(s),onClick:t[0]||(t[0]=function(){return Kt(r)&&Kt(r).apply(void 0,arguments)})},[Kt(s)?(Ds(),Fs(Os,{key:0},[t[1]||(t[1]=qs("span",{class:"trp-save-spinner"},null,-1)),qs("span",null,fe(p.saving),1)],64)):Kt(a)?(Ds(),Fs("span",iF,fe(p.saved),1)):(Ds(),Fs("span",oF,fe(p.saveChanges),1))],8,rF),qs("button",{class:"trp-button-secondary",disabled:!Kt(o)||Kt(s),title:p.revertTitle,onClick:h},[(Ds(),Fs("svg",aF,ZN(t[2]||(t[2]=[qs("path",{d:"M7.1752 0.713867C10.7452 0.713867 13.3002 3.54187 13.3002 7.01387C13.3002 10.4859 10.7452 13.3139 7.1752 13.3139C4.9352 13.3139 2.9612 12.2009 1.7992 10.5209L3.6122 9.45687C4.3822 10.5069 5.6142 11.2139 7.0002 11.2139C9.3102 11.2139 11.2002 9.26087 11.2002 7.01387C11.2002 4.76687 9.3102 2.81387 7.0002 2.81387C5.6212 2.81387 4.3962 3.51387 3.6262 4.55687L4.9002 5.61387L0.700195 7.01387V2.11387L2.0232 3.21987C3.2062 1.70087 5.0752 0.713867 7.1752 0.713867Z",fill:"#2271B1"},null,-1)])))),Xs(" "+fe(p.revertChanges),1)],8,sF),Kt(l)?(Ds(),Fs("span",lF,fe(Kt(l)),1)):Ks("",!0)]),(Ds(),Qs(ur,{to:"body"},[Ws(nl,{name:"fade"},{default:er(function(){return[c.value?(Ds(),Fs("div",cF,[qs("p",hF,fe(p.revertConfirmText),1),qs("div",dF,[qs("button",{class:"trp-btn-revert trp-submit-btn",onClick:u},fe(p.revertBtn),1),qs("span",{class:"trp-btn-cancel",onClick:d},fe(p.cancelBtn),1)])])):Ks("",!0)]}),_:1})]))],64)}}};var pF=n(769),fF={insert:"head",singleton:!1};xg()(pF.A,fF);pF.A.locals;const gF=(0,Tb.A)(uF,[["__scopeId","data-v-9c66bec4"]]);function mF(){var e,t,n="function"==typeof Symbol?Symbol:{},r=n.iterator||"@@iterator",i=n.toStringTag||"@@toStringTag";function o(n,r,i,o){var l=r&&r.prototype instanceof a?r:a,c=Object.create(l.prototype);return vF(c,"_invoke",function(n,r,i){var o,a,l,c=0,h=i||[],d=!1,u={p:0,n:0,v:e,a:p,f:p.bind(e,4),d:function(t,n){return o=t,a=0,l=e,u.n=n,s}};function p(n,r){for(a=n,l=r,t=0;!d&&c&&!i&&t<h.length;t++){var i,o=h[t],p=u.p,f=o[2];n>3?(i=f===r)&&(l=o[(a=o[4])?5:(a=3,3)],o[4]=o[5]=e):o[0]<=p&&((i=n<2&&p<o[1])?(a=0,u.v=r,u.n=o[1]):p<f&&(i=n<3||o[0]>r||r>f)&&(o[4]=n,o[5]=r,u.n=f,a=0))}if(i||n>1)return s;throw d=!0,r}return function(i,h,f){if(c>1)throw TypeError("Generator is already running");for(d&&1===h&&p(h,f),a=h,l=f;(t=a<2?e:l)||!d;){o||(a?a<3?(a>1&&(u.n=-1),p(a,l)):u.n=l:u.v=l);try{if(c=2,o){if(a||(i="next"),t=o[i]){if(!(t=t.call(o,l)))throw TypeError("iterator result is not an object");if(!t.done)return t;l=t.value,a<2&&(a=0)}else 1===a&&(t=o.return)&&t.call(o),a<2&&(l=TypeError("The iterator does not provide a '"+i+"' method"),a=1);o=e}else if((t=(d=u.n<0)?l:n.call(r,u))!==s)break}catch(t){o=e,a=1,l=t}finally{c=1}}return{value:t,done:d}}}(n,i,o),!0),c}var s={};function a(){}function l(){}function c(){}t=Object.getPrototypeOf;var h=[][r]?t(t([][r]())):(vF(t={},r,function(){return this}),t),d=c.prototype=a.prototype=Object.create(h);function u(e){return Object.setPrototypeOf?Object.setPrototypeOf(e,c):(e.__proto__=c,vF(e,i,"GeneratorFunction")),e.prototype=Object.create(d),e}return l.prototype=c,vF(d,"constructor",c),vF(c,"constructor",l),l.displayName="GeneratorFunction",vF(c,i,"GeneratorFunction"),vF(d),vF(d,i,"Generator"),vF(d,r,function(){return this}),vF(d,"toString",function(){return"[object Generator]"}),(mF=function(){return{w:o,m:u}})()}function vF(e,t,n,r){var i=Object.defineProperty;try{i({},"",{})}catch(e){i=0}vF=function(e,t,n,r){function o(t,n){vF(e,t,function(e){return this._invoke(t,n,e)})}t?i?i(e,t,{value:n,enumerable:!r,configurable:!r,writable:!r}):e[t]=n:(o("next",0),o("throw",1),o("return",2))},vF(e,t,n,r)}function bF(e,t,n,r,i,o,s){try{var a=e[o](s),l=a.value}catch(e){return void n(e)}a.done?t(l):Promise.resolve(l).then(r,i)}function AF(e){return function(){var t=this,n=arguments;return new Promise(function(r,i){var o=e.apply(t,n);function s(e){bF(o,r,i,s,a,"next",e)}function a(e){bF(o,r,i,s,a,"throw",e)}s(void 0)})}}function yF(e){var t=yg(e),n=Ut({});vi(AF(mF().m(function e(){return mF().w(function(e){for(;;)switch(e.n){case 0:return e.n=1,Nn();case 1:n.value=structuredClone($t(t));case 2:return e.a(2)}},e)})));var r=Ea(function(){return JSON.stringify(t)!==JSON.stringify(n.value)}),i=Ut(!1),o=Ut(!1),s=Ut("");function a(e){r.value&&(e.preventDefault(),e.returnValue="")}function l(){return l=AF(mF().m(function r(){var a,l,c;return mF().w(function(r){for(;;)switch(r.p=r.n){case 0:return i.value=!0,s.value="",r.p=1,(a=new FormData).append("action","trp_language_switcher_save"),a.append("nonce",tpLangSwitcherData.nonce),a.append("scope",e),a.append("config",JSON.stringify(t)),r.n=2,fetch(ajaxurl,{method:"POST",credentials:"same-origin",body:a});case 2:if((l=r.v).ok){r.n=3;break}throw new Error("HTTP ".concat(l.status));case 3:n.value=structuredClone($t(t)),o.value=!0,setTimeout(function(){o.value=!1},2e3),r.n=5;break;case 4:r.p=4,c=r.v,s.value=c.message||"Save failed";case 5:return r.p=5,i.value=!1,r.f(5);case 6:return r.a(2)}},r,null,[[1,4,5,6]])})),l.apply(this,arguments)}return ns(r,function(e){e?window.addEventListener("beforeunload",a):window.removeEventListener("beforeunload",a)},{immediate:!0}),{save:function(){return l.apply(this,arguments)},revert:function(){Object.assign(t,structuredClone($t(n.value)))},saving:i,justSaved:o,errorMsg:s,isDirty:r}}var wF={class:"trp-floater-settings__wrapper"},CF={class:"trp-floater-settings__left"},xF={class:"trp-sticky-box"},kF={class:"trp-floater-settings__right"},SF="floater";const OF={__name:"FloaterConfig",setup:function(e){var t=yg(SF),n=yF(SF);Co("switcherPersistence",n);var r=n.isDirty,i=n.revert,o=JL(SF).positioning,s=Ea(function(){return t.flagShape}),a=Ea(function(){return{flagPos:o.value.flagPos,nameMode:o.value.languageNames,flagRatio:s}}),l={switcherPreview:wN("Switcher Preview"),enableFloating:wN("Enable Floating Switcher"),switcherEnabled:wN("Switcher is enabled"),switcherDisabled:wN("Switcher is disabled"),switcherType:wN("Switcher Type"),showAsDropdown:wN("Show languages as dropdown"),showSideBySide:wN("Show languages side by side"),applyPreset:wN("Apply a preset"),customizeDesign:wN("Customize Design"),backgroundColor:wN("Background color"),backgroundHoverColor:wN("Background hover color"),textColor:wN("Text color"),textHoverColor:wN("Text hover color"),borderColor:wN("Switcher border color"),borderWidth:wN("Switcher border width"),borderRadius:wN("Switcher border radius"),flagTextSize:wN("Flag and text size"),normal:wN("Normal"),large:wN("Large"),flagIconsShape:wN("Flag icons shape"),rectangle:wN("Rectangle (4:3)"),square:wN("Square (1:1)"),flagRadius:wN("Flag icons border radius"),enableCustomCss:wN("Enable custom CSS"),customizeLayout:wN("Customize Layout"),showOppositeLanguage:wN("Show opposite language"),showPoweredBy:wN('Show "Powered by TranslatePress"'),poweredByDesc:wN("Show the small Powered by TranslatePress label in the language switcher."),leaveConfirm:wN("You have unsaved changes. Leave anyway?"),enableTransitions:wN("Switcher animations")},c=wN("Transforms the language switcher into a button showing the other available language, not the current one. <br> Only works when there are exactly two languages, the default one and a translation one."),h=wg().published,d=Object.keys(h).length>2,u=d?wN("This option only works when exactly two languages are published."):"";return og(function(e,t,n){if(!r.value)return n();window.confirm(wN("You have unsaved changes. Leave anyway?"))?(i(),n()):n(!1)}),Co("languageItemSettings",a),function(e,t){return Ds(),Fs("div",wF,[qs("div",CF,[qs("div",xF,[Ws(qL,{title:l.switcherPreview,scope:SF},{default:er(function(){return[Ws(KN,{scope:SF})]}),_:1},8,["title"]),Ws(gF,{scope:SF})])]),qs("div",kF,[Ws(qL,{title:l.enableFloating,scope:SF,style:{flexDirection:"row",gap:"75px"},fields:[{key:"enabled",type:"toggleStatus",onText:l.switcherEnabled,offText:l.switcherDisabled}]},null,8,["title","fields"]),Ws(qL,{title:l.switcherType,scope:SF,fields:[{key:"type",type:"radio",default:"dropdown",options:[{value:"dropdown",label:l.showAsDropdown},{value:"side-by-side",label:l.showSideBySide,disabled:d,title:Kt(u)}]}]},null,8,["title","fields"]),Ws(qL,{title:l.applyPreset,scope:SF},{default:er(function(){return[Ws(RN,{scope:SF})]}),_:1},8,["title"]),Ws(qL,{title:l.customizeDesign,scope:SF,collapsible:"",style:{"--trp-field-label-width":"190px"},fields:[{key:"bgColor",type:"color",label:l.backgroundColor,default:"#ffffff"},{key:"bgHoverColor",type:"color",label:l.backgroundHoverColor,default:"#f5f5f5"},{key:"textColor",type:"color",label:l.textColor,default:"#000000"},{key:"textHoverColor",type:"color",label:l.textHoverColor,default:"#000000"},{key:"borderColor",type:"color",label:l.borderColor,default:"#e2e2e4"},{key:"borderWidth",type:"number",label:l.borderWidth,default:1},{key:"borderRadius",type:"quadNumber",label:l.borderRadius,default:[8,8,0,0],layout:"column"},{type:"separator"},{key:"enableTransitions",type:"toggle",label:l.enableTransitions,default:!0},{type:"separator"},{key:"size",type:"radio",label:l.flagTextSize,default:"normal",options:[{value:"normal",label:l.normal},{value:"large",label:l.large}],layout:"column"},{type:"separator"},{key:"flagShape",type:"radio",label:l.flagIconsShape,default:"rect",options:[{value:"rect",label:l.rectangle},{value:"square",label:l.square}],layout:"column"},{key:"flagRadius",type:"number",label:l.flagRadius,default:2},{type:"separator"},{key:"enableCustomCss",type:"toggle",label:l.enableCustomCss,default:!1},{key:"customCss",type:"customCss",label:"",visible:function(e){return!0===(null==e?void 0:e.enableCustomCss)}}]},null,8,["title","fields"]),Ws(qL,{title:l.customizeLayout,scope:SF,collapsible:"",fields:[{key:"layoutCustomizer",type:"lCustomizer",label:""}]},null,8,["title"]),Ws(qL,{title:"Additional Settings",scope:SF,collapsible:"",fields:[{key:"oppositeLanguage",type:"checkbox",default:!1,label:l.showOppositeLanguage,description:Kt(c),disabled:d,title:Kt(u)},{key:"showPoweredBy",type:"checkbox",default:!1,label:l.showPoweredBy,description:l.poweredByDesc}]},null,8,["fields"])])])}}};var BF=n(147),_F={insert:"head",singleton:!1};xg()(BF.A,_F);BF.A.locals;const TF=(0,Tb.A)(OF,[["__scopeId","data-v-5390537a"]]);var EF={class:"trp-shortcode-display"},MF={class:"trp-description-text"},DF="[language-switcher]";const PF={__name:"ShortcodeCopy",setup:function(e){var t=Ut(!1),n=Ea(function(){return t.value?wN("Copied!"):wN("Copy")});function r(){var e;null===(e=navigator.clipboard)||void 0===e||e.writeText(DF).then(function(){t.value=!0,setTimeout(function(){return t.value=!1},2e3)}).catch(function(){var e=document.createElement("textarea");e.value=DF,e.style.position="fixed",e.style.opacity="0",document.body.appendChild(e),e.select();try{document.execCommand("copy")}finally{document.body.removeChild(e),t.value=!0,setTimeout(function(){return t.value=!1},2e3)}})}var i=wN("Use shortcode on any page or widget. You can also add the Language Switcher Block in the WP Gutenberg Editor.");return function(e,t){return Ds(),Fs(Os,null,[qs("div",EF,[qs("input",{class:"trp-shortcode-input trp-primary-text",value:DF,readonly:""}),qs("button",{class:"trp-copy-btn trp-button-secondary",type:"button",onClick:r},[t[0]||(t[0]=qs("svg",{width:"22",height:"22",viewBox:"0 0 22 22",fill:"none",xmlns:"http://www.w3.org/2000/svg"},[qs("path",{d:"M14.666 7.33317V5.49984C14.666 5.01361 14.4729 4.54729 14.129 4.20347C13.7852 3.85966 13.3189 3.6665 12.8327 3.6665H5.49935C5.01312 3.6665 4.5468 3.85966 4.20299 4.20347C3.85917 4.54729 3.66602 5.01361 3.66602 5.49984V12.8332C3.66602 13.3194 3.85917 13.7857 4.20299 14.1295C4.5468 14.4733 5.01312 14.6665 5.49935 14.6665H7.33268M7.33268 9.1665C7.33268 8.68027 7.52584 8.21396 7.86965 7.87014C8.21347 7.52633 8.67979 7.33317 9.16602 7.33317H16.4993C16.9856 7.33317 17.4519 7.52633 17.7957 7.87014C18.1395 8.21396 18.3327 8.68027 18.3327 9.1665V16.4998C18.3327 16.9861 18.1395 17.4524 17.7957 17.7962C17.4519 18.14 16.9856 18.3332 16.4993 18.3332H9.16602C8.67979 18.3332 8.21347 18.14 7.86965 17.7962C7.52584 17.4524 7.33268 16.9861 7.33268 16.4998V9.1665Z",stroke:"#2271B1","stroke-width":"1.5","stroke-linecap":"round","stroke-linejoin":"round"})],-1)),Xs(" "+fe(n.value),1)])]),qs("p",MF,fe(Kt(i)),1)],64)}}};var RF=n(652),IF={insert:"head",singleton:!1};xg()(RF.A,IF);RF.A.locals;const LF=(0,Tb.A)(PF,[["__scopeId","data-v-b466f20a"]]);var NF={class:"trp-floater-settings__wrapper"},FF={class:"trp-floater-settings__left"},QF={class:"trp-sticky-box"},VF={class:"trp-floater-settings__right"},zF="shortcode";const $F={__name:"ShortcodeConfig",setup:function(e){var t=yg(zF),n=yF(zF);Co("switcherPersistence",n);var r=n.isDirty,i=n.revert,o=JL(zF).positioning,s=Ea(function(){return t.flagShape});Co("languageItemSettings",Ea(function(){return{flagPos:o.value.flagPos,nameMode:o.value.languageNames,flagRatio:s}}));var a=wN("Transforms the language switcher into a button showing the other available language, not the current one. <br> Only works when there are exactly two languages, the default one and a translation one."),l=wg().published,c=Object.keys(l).length>2,h=c?wN("This option only works when exactly two languages are published."):"",d={confirmLeave:wN("You have unsaved changes. Leave anyway?"),switcherPreview:wN("Switcher Preview"),shortcode:wN("Shortcode"),customizeDesign:wN("Customize Design"),backgroundColor:wN("Background color"),backgroundHoverColor:wN("Background hover color"),textColor:wN("Text color"),textHoverColor:wN("Text hover color"),switcherBorderColor:wN("Switcher border color"),switcherBorderWidth:wN("Switcher border width"),switcherBorderRadius:wN("Switcher border radius"),flagTextSize:wN("Flag and text size"),normal:wN("Normal"),large:wN("Large"),flagIconsShape:wN("Flag icons shape"),rectangle:wN("Rectangle (4:3)"),square:wN("Square (1:1)"),flagRadius:wN("Flag icons border radius"),enableCustomCss:wN("Enable custom CSS"),customizeLayout:wN("Customize Layout"),additionalSettings:wN("Additional Settings"),openOnClick:wN("Open language switcher only on click"),clickLangDesc:wN("Open the language switcher shortcode by clicking on it instead of hovering. <br> Close it by clicking on it, anywhere else on the screen or by pressing the escape key. <br> This will affect only the shortcode language switcher."),enableTransitions:wN("Switcher animations"),showOppositeLanguage:wN("Show opposite language")};return og(function(e,t,n){if(!r.value)return n();window.confirm(d.confirmLeave)?(i(),n()):n(!1)}),function(e,t){return Ds(),Fs("div",NF,[qs("div",FF,[qs("div",QF,[Ws(qL,{title:d.switcherPreview,scope:zF},{default:er(function(){return[Ws(KN,{scope:zF})]}),_:1},8,["title"]),Ws(gF,{scope:zF})])]),qs("div",VF,[Ws(qL,{title:d.shortcode,scope:zF},{default:er(function(){return[Ws(LF)]}),_:1},8,["title"]),Ws(qL,{title:d.customizeDesign,scope:zF,collapsible:"",style:{"--trp-field-label-width":"190px"},fields:[{key:"bgColor",type:"color",label:d.backgroundColor,default:"#ffffff"},{key:"bgHoverColor",type:"color",label:d.backgroundHoverColor,default:"#f5f5f5"},{key:"textColor",type:"color",label:d.textColor,default:"#1D2327"},{key:"textHoverColor",type:"color",label:d.textHoverColor,default:"#000000"},{key:"borderColor",type:"color",label:d.switcherBorderColor,default:"#1438521A"},{key:"borderWidth",type:"number",label:d.switcherBorderWidth,default:1},{key:"borderRadius",type:"number",label:d.switcherBorderRadius,default:5},{type:"separator"},{key:"enableTransitions",type:"toggle",label:d.enableTransitions,default:!0},{type:"separator"},{key:"size",type:"radio",label:d.flagTextSize,default:"normal",options:[{value:"normal",label:d.normal},{value:"large",label:d.large}],layout:"column"},{type:"separator"},{key:"flagShape",type:"radio",label:d.flagIconsShape,default:"rect",options:[{value:"rect",label:d.rectangle},{value:"square",label:d.square}],layout:"column"},{key:"flagRadius",type:"number",label:d.flagRadius,default:2},{type:"separator"},{key:"enableCustomCss",type:"toggle",label:d.enableCustomCss,default:!1},{key:"customCss",type:"customCss",label:"",visible:function(e){return!0===(null==e?void 0:e.enableCustomCss)}}]},null,8,["title","fields"]),Ws(qL,{title:d.customizeLayout,scope:zF,collapsible:"",fields:[{key:"layoutCustomizer",type:"lCustomizer",label:""}]},null,8,["title"]),Ws(qL,{title:d.additionalSettings,scope:zF,collapsible:"",fields:[{key:"clickLanguage",type:"checkbox",default:!1,label:d.openOnClick,description:d.clickLangDesc},{key:"oppositeLanguage",type:"checkbox",default:!1,label:d.showOppositeLanguage,description:Kt(a),disabled:c,title:Kt(h)}]},null,8,["title","fields"])])])}}};var HF=n(661),jF={insert:"head",singleton:!1};xg()(HF.A,jF);HF.A.locals;const qF=(0,Tb.A)($F,[["__scopeId","data-v-469f4c76"]]);function WF(e){return function(e){if(Array.isArray(e))return UF(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(e){if("string"==typeof e)return UF(e,t);var n={}.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?UF(e,t):void 0}}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function UF(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}function YF(e){for(var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=(new DOMParser).parseFromString(e,"text/html"),r=n.createTreeWalker(n.body,NodeFilter.SHOW_ELEMENT),i=function(){var e=r.currentNode,i=e.tagName.toLowerCase();if(!t[i]){var o=n.createTextNode(e.textContent);return e.replaceWith(o),1}var s=t[i];(WF(e.attributes).forEach(function(t){s.includes(t.name.toLowerCase())||e.removeAttribute(t.name)}),e.hasAttribute("href"))&&((e.getAttribute("href")||"").trim().toLowerCase().startsWith("javascript:")&&e.removeAttribute("href"));e.hasAttribute("src")&&((e.getAttribute("src")||"").trim().toLowerCase().startsWith("javascript:")&&e.removeAttribute("src"))};r.nextNode();)i();return n.body.innerHTML}var GF={class:"trp-menu-settings__wrapper"},XF=["innerHTML"],JF="menu";const KF={__name:"MenuConfig",setup:function(e){yg(JF);var t=yF(JF);Co("switcherPersistence",t);var n=t.isDirty,r=t.revert,i={menuSwitcherLayout:wN("Menu Switcher Layout"),unsavedChangesAlert:wN("You have unsaved changes. Leave anyway?"),descriptionText:YF(wN('Go to <a href="/wp-admin/nav-menus.php">Appearance → Menus</a> to add languages to the Language Switcher in any menu.<br> <a href="https://translatepress.com/docs/settings/language-switcher/?utm_source=tp-language-switcher&utm_medium=client-site&utm_campaign=ls-menu-item#menu-switcher" target="_blank">Learn more in our documentation.</a>'))};return og(function(e,t,o){if(!n.value)return o();window.confirm(i.unsavedChangesAlert)?(r(),o()):o(!1)}),function(e,t){return Ds(),Fs("div",GF,[Ws(qL,{title:i.menuSwitcherLayout,scope:JF,collapsible:!1,fields:[{key:"layoutCustomizer",type:"lCustomizer",label:""}]},{end:er(function(){return[qs("span",{class:"trp-description-text",innerHTML:i.descriptionText},null,8,XF)]}),_:1},8,["title"]),Ws(gF,{scope:JF})])}}};var ZF=n(612),eQ={insert:"head",singleton:!1};xg()(ZF.A,eQ);ZF.A.locals;const tQ=(0,Tb.A)(KF,[["__scopeId","data-v-902ede12"]]),nQ=function(e){const t=zf(e.routes,e),n=e.parseQuery||Gf,r=e.stringifyQuery||Xf,i=e.history,o=rg(),s=rg(),a=rg(),l=Yt(pf);let c=pf;Pp&&e.scrollBehavior&&"scrollRestoration"in history&&(history.scrollRestoration="manual");const h=Np.bind(null,e=>""+e),d=Np.bind(null,rf),u=Np.bind(null,of);function p(e,o){if(o=Lp({},o||l.value),"string"==typeof e){const r=af(n,e,o.path),s=t.resolve({path:r.path},o),a=i.createHref(r.fullPath);return Lp(r,s,{params:u(s.params),hash:of(r.hash),redirectedFrom:void 0,href:a})}let s;if(null!=e.path)s=Lp({},e,{path:af(n,e.path,o.path).path});else{const t=Lp({},e.params);for(const e in t)null==t[e]&&delete t[e];s=Lp({},e,{params:d(t)}),o.params=d(o.params)}const a=t.resolve(s,o),c=e.hash||"";a.params=h(u(a.params));const p=function(e,t){const n=t.query?e(t.query):"";return t.path+(n&&"?")+n+(t.hash||"")}(r,Lp({},e,{hash:(f=c,ef(f).replace(Xp,"{").replace(Kp,"}").replace(Yp,"^")),path:a.path}));var f;const g=i.createHref(p);return Lp({fullPath:p,hash:c,query:r===Xf?Jf(e.query):e.query||{}},a,{redirectedFrom:void 0,href:g})}function f(e){return"string"==typeof e?af(n,e,l.value.path):Lp({},e)}function g(e,t){if(c!==e)return Ef(8,{from:t,to:e})}function m(e){return b(e)}function v(e){const t=e.matched[e.matched.length-1];if(t&&t.redirect){const{redirect:n}=t;let r="function"==typeof n?n(e):n;return"string"==typeof r&&(r=r.includes("?")||r.includes("#")?r=f(r):{path:r},r.params={}),Lp({query:e.query,hash:e.hash,params:null!=r.path?{}:e.params},r)}}function b(e,t){const n=c=p(e),i=l.value,o=e.state,s=e.force,a=!0===e.replace,h=v(n);if(h)return b(Lp(f(h),{state:"object"==typeof h?Lp({},o,h.state):o,force:s,replace:a}),t||n);const d=n;let u;return d.redirectedFrom=t,!s&&function(e,t,n){const r=t.matched.length-1,i=n.matched.length-1;return r>-1&&r===i&&cf(t.matched[r],n.matched[i])&&hf(t.params,n.params)&&e(t.query)===e(n.query)&&t.hash===n.hash}(r,i,n)&&(u=Ef(16,{to:d,from:i}),M(i,i,!0,!1)),(u?Promise.resolve(u):w(d,i)).catch(e=>Mf(e)?Mf(e,2)?e:E(e):T(e,d,i)).then(e=>{if(e){if(Mf(e,2))return b(Lp({replace:a},f(e.to),{state:"object"==typeof e.to?Lp({},o,e.to.state):o,force:s}),t||d)}else e=x(d,i,!0,a,o);return C(d,i,e),e})}function A(e,t){const n=g(e,t);return n?Promise.reject(n):Promise.resolve()}function y(e){const t=R.values().next().value;return t&&"function"==typeof t.runWithContext?t.runWithContext(e):e()}function w(e,t){let n;const[r,i,a]=function(e,t){const n=[],r=[],i=[],o=Math.max(t.matched.length,e.matched.length);for(let s=0;s<o;s++){const o=t.matched[s];o&&(e.matched.find(e=>cf(e,o))?r.push(o):n.push(o));const a=e.matched[s];a&&(t.matched.find(e=>cf(e,a))||i.push(a))}return[n,r,i]}(e,t);n=ag(r.reverse(),"beforeRouteLeave",e,t);for(const i of r)i.leaveGuards.forEach(r=>{n.push(sg(r,e,t))});const l=A.bind(null,e,t);return n.push(l),L(n).then(()=>{n=[];for(const r of o.list())n.push(sg(r,e,t));return n.push(l),L(n)}).then(()=>{n=ag(i,"beforeRouteUpdate",e,t);for(const r of i)r.updateGuards.forEach(r=>{n.push(sg(r,e,t))});return n.push(l),L(n)}).then(()=>{n=[];for(const r of a)if(r.beforeEnter)if(Qp(r.beforeEnter))for(const i of r.beforeEnter)n.push(sg(i,e,t));else n.push(sg(r.beforeEnter,e,t));return n.push(l),L(n)}).then(()=>(e.matched.forEach(e=>e.enterCallbacks={}),n=ag(a,"beforeRouteEnter",e,t,y),n.push(l),L(n))).then(()=>{n=[];for(const r of s.list())n.push(sg(r,e,t));return n.push(l),L(n)}).catch(e=>Mf(e,8)?e:Promise.reject(e))}function C(e,t,n){a.list().forEach(r=>y(()=>r(e,t,n)))}function x(e,t,n,r,o){const s=g(e,t);if(s)return s;const a=t===pf,c=Pp?history.state:{};n&&(r||a?i.replace(e.fullPath,Lp({scroll:a&&c&&c.scroll},o)):i.push(e.fullPath,o)),l.value=e,M(e,t,n,a),E()}let k;function S(){k||(k=i.listen((e,t,n)=>{if(!I.listening)return;const r=p(e),o=v(r);if(o)return void b(Lp(o,{replace:!0,force:!0}),r).catch(Fp);c=r;const s=l.value;var a,h;Pp&&(a=wf(s.fullPath,n.delta),h=Af(),Cf.set(a,h)),w(r,s).catch(e=>Mf(e,12)?e:Mf(e,2)?(b(Lp(f(e.to),{force:!0}),r).then(e=>{Mf(e,20)&&!n.delta&&n.type===ff.pop&&i.go(-1,!1)}).catch(Fp),Promise.reject()):(n.delta&&i.go(-n.delta,!1),T(e,r,s))).then(e=>{(e=e||x(r,s,!1))&&(n.delta&&!Mf(e,8)?i.go(-n.delta,!1):n.type===ff.pop&&Mf(e,20)&&i.go(-1,!1)),C(r,s,e)}).catch(Fp)}))}let O,B=rg(),_=rg();function T(e,t,n){E(e);const r=_.list();return r.length?r.forEach(r=>r(e,t,n)):console.error(e),Promise.reject(e)}function E(e){return O||(O=!e,S(),B.list().forEach(([t,n])=>e?n(e):t()),B.reset()),e}function M(t,n,r,i){const{scrollBehavior:o}=e;if(!Pp||!o)return Promise.resolve();const s=!r&&function(e){const t=Cf.get(e);return Cf.delete(e),t}(wf(t.fullPath,0))||(i||!r)&&history.state&&history.state.scroll||null;return Nn().then(()=>o(t,n,s)).then(e=>e&&yf(e)).catch(e=>T(e,t,n))}const D=e=>i.go(e);let P;const R=new Set,I={currentRoute:l,listening:!0,addRoute:function(e,n){let r,i;return Bf(e)?(r=t.getRecordMatcher(e),i=n):i=e,t.addRoute(i,r)},removeRoute:function(e){const n=t.getRecordMatcher(e);n&&t.removeRoute(n)},clearRoutes:t.clearRoutes,hasRoute:function(e){return!!t.getRecordMatcher(e)},getRoutes:function(){return t.getRoutes().map(e=>e.record)},resolve:p,options:e,push:m,replace:function(e){return m(Lp(f(e),{replace:!0}))},go:D,back:()=>D(-1),forward:()=>D(1),beforeEach:o.add,beforeResolve:s.add,afterEach:a.add,onError:_.add,isReady:function(){return O&&l.value!==pf?Promise.resolve():new Promise((e,t)=>{B.add([e,t])})},install(e){e.component("RouterLink",hg),e.component("RouterView",gg),e.config.globalProperties.$router=this,Object.defineProperty(e.config.globalProperties,"$route",{enumerable:!0,get:()=>Kt(l)}),Pp&&!P&&l.value===pf&&(P=!0,m(i.location).catch(e=>{0}));const t={};for(const e in pf)Object.defineProperty(t,e,{get:()=>l.value[e],enumerable:!0});e.provide(eg,this),e.provide(tg,Rt(t)),e.provide(ng,l);const n=e.unmount;R.add(e),e.unmount=function(){R.delete(e),R.size<1&&(c=pf,k&&k(),k=null,l.value=pf,P=!1,O=!1),n()}}};function L(e){return e.reduce((e,t)=>e.then(()=>y(t)),Promise.resolve())}return I}({history:function(e){return(e=location.host?e||location.pathname+location.search:"").includes("#")||(e+="#"),Of(e)}(),routes:[{path:"/",redirect:"/floater"},{path:"/floater",component:TF},{path:"/shortcode",component:qF},{path:"/menu-item",component:tQ}]});var rQ={class:"trp-submenu__wrapper"},iQ={class:"trp-submenu"},oQ=["onClick","onKeydown"];const sQ={__name:"SubMenu",setup:function(e){var t=[{path:"/floater",label:"Floating"},{path:"/shortcode",label:"Shortcode"},{path:"/menu-item",label:"Menu Item"}];return function(e,n){var r=_i("RouterLink");return Ds(),Fs("div",rQ,[qs("div",iQ,[(Ds(),Fs(Os,null,Ri(t,function(e){return Ws(r,{key:e.path,to:e.path,custom:""},{default:er(function(t){t.href;var n=t.navigate;return[qs("span",{class:J(["trp-submenu-item",{"trp-nav-active":t.isActive}]),role:"link",tabindex:"0",onClick:n,onKeydown:xc(wc(n,["prevent"]),["enter","space"])},fe(e.label),43,oQ)]}),_:2},1032,["to"])}),64))])])}}},aQ=sQ;var lQ={class:"trp-ls-wrapper"},cQ={class:"trp-ls-view"};const hQ={__name:"App",setup:function(e){document.getElementById("tp-language-switcher-root");var t=window.tpLangSwitcherData;return function(e){var t=e.config,n=e.languages,r=Pt(t.floater||{}),i=Pt(t.shortcode||{}),o=Pt(t.menu||{}),s=It(n||{});Co(mg,r),Co(vg,i),Co(bg,o),Co(Ag,s)}({config:t.lsConfig,languages:t.languages}),function(e,t){var n=_i("router-view");return Ds(),Fs("div",lQ,[Ws(aQ),qs("main",cQ,[Ws(n)])])}}};var dQ=n(700),uQ={insert:"head",singleton:!1};xg()(dQ.A,uQ);dQ.A.locals;const pQ=(0,Tb.A)(hQ,[["__scopeId","data-v-bf1beb8c"]]);var fQ=document.getElementById("tp-language-switcher-root");Mc(pQ).use(nQ).mount(fQ)},482:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-description-text[data-v-2e0e42ea]{line-height:150%}.trp-settings-checkbox input[data-v-2e0e42ea]:disabled{background:var(--trp-settings-disabled-color);border:none!important;pointer-events:none}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/CheckboxField.vue"],names:[],mappings:"AA6DA,uCACI,gBACJ,CACA,uDAEI,6CAA8C,CAC9C,qBAAuB,CAFvB,mBAGJ",sourcesContent:['<script setup>\r\nimport { computed } from \'vue\'\r\n\r\n/**\r\n * A simple checkbox field for the settings UI.\r\n *\r\n * Props\r\n *  - modelValue  (Boolean)  – bound value (true = checked)\r\n *  - label       (String)   – bold label text\r\n *  - description (String)   – secondary text (HTML allowed)\r\n *\r\n * Emits\r\n *  - update:modelValue\r\n */\r\nconst props = defineProps({\r\n    modelValue  : { type: Boolean, required: true },\r\n    label       : { type: String,  default: \'\' },\r\n    description : { type: String,  default: \'\' },\r\n    disabled    : { type: Boolean, default: false },\r\n    title       : { type: String, default: \'\' }\r\n})\r\n\r\nconst emit = defineEmits([\'update:modelValue\'])\r\n\r\n/* A stable unique ID so the <label> is associated with the <input>. */\r\nconst inputId = `trp-checkbox-${Math.random().toString(36).slice(2)}`\r\n\r\n/* Computed wrapper to keep SettingsBox’s two-way binding contract intact. */\r\nconst checked = computed({\r\n    get: () => props.modelValue === true,\r\n    set: (val) => emit(\'update:modelValue\', val)\r\n})\r\n\r\n<\/script>\r\n\r\n<template>\r\n    <div\r\n        class="trp-settings-checkbox trp-settings-options-item"\r\n        :title="props.title"\r\n    >\r\n        <input\r\n            type="checkbox"\r\n            :id="inputId"\r\n            v-model="checked"\r\n            :disabled="props.disabled"\r\n        />\r\n\r\n        <label :for="inputId" class="trp-checkbox-label">\r\n            <div class="trp-checkbox-content">\r\n                <span v-if="label" class="trp-primary-text-bold">{{ label }}</span>\r\n                <span\r\n                    v-if="description"\r\n                    class="trp-description-text"\r\n                    v-html="description"\r\n                />\r\n            </div>\r\n        </label>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-description-text {\r\n    line-height: 150%;\r\n}\r\n.trp-settings-checkbox input:disabled {\r\n    pointer-events: none;\r\n    background: var(--trp-settings-disabled-color);\r\n    border: none !important;\r\n}\r\n</style>\r\n'],sourceRoot:""}]);const a=s},565:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-number-input[data-v-4d5d37b0]::-webkit-inner-spin-button,.trp-number-input[data-v-4d5d37b0]::-webkit-outer-spin-button{-webkit-appearance:none;margin:0}.trp-number-input[type=number][data-v-4d5d37b0]{-moz-appearance:textfield}.trp-number__wrapper[data-v-4d5d37b0]{align-items:center;display:flex;flex-direction:row;gap:10px}.trp-number-input[data-v-4d5d37b0]{border:1px solid #c3c4c7;border-radius:5px;height:40px;text-align:center;width:53px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/NumberField.vue"],names:[],mappings:"AAiCA,4HAEI,uBAAwB,CACxB,QACJ,CAGA,gDACI,yBACJ,CAEA,sCAII,kBAAmB,CAHnB,YAAa,CACb,kBAAmB,CACnB,QAEJ,CAEA,mCAGI,wBAAyB,CACzB,iBAAkB,CAFlB,WAAY,CAGZ,iBAAkB,CAJlB,UAKJ",sourcesContent:['<script setup>\r\nconst props = defineProps({\r\n    label       : { type: String, default: \'\' },\r\n    modelValue  : { type: [Number, null], default: null },\r\n    min         : { type: Number, default: 0, required: false },\r\n})\r\n\r\nconst emit = defineEmits([\'update:modelValue\'])\r\n\r\nfunction onInput (e) {\r\n    const val = e.target.value\r\n    emit(\'update:modelValue\', val === \'\' ? props.min : Number(val))\r\n}\r\n<\/script>\r\n\r\n<template>\r\n    <div>\r\n        <span v-if="label" class="trp-field__label trp-primary-text-bold">{{ label }}</span>\r\n        <div class="trp-number__wrapper">\r\n            <input\r\n                type="number"\r\n                class="trp-number-input"\r\n                :value="modelValue ?? \'\'"\r\n                :min="min"\r\n                @input="onInput"\r\n            />\r\n            <span class="trp-primary-text">px</span>\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n/* Remove arrows in Chrome, Safari, Edge */\r\n.trp-number-input::-webkit-outer-spin-button,\r\n.trp-number-input::-webkit-inner-spin-button {\r\n    -webkit-appearance: none;\r\n    margin: 0;\r\n}\r\n\r\n/* Remove arrows in Firefox */\r\n.trp-number-input[type=\'number\'] {\r\n    -moz-appearance: textfield;\r\n}\r\n\r\n.trp-number__wrapper {\r\n    display: flex;\r\n    flex-direction: row;\r\n    gap: 10px;\r\n    align-items: center;\r\n}\r\n\r\n.trp-number-input {\r\n    width: 53px;\r\n    height: 40px;\r\n    border: 1px solid #C3C4C7;\r\n    border-radius: 5px;\r\n    text-align: center;\r\n}\r\n</style>\r\n'],sourceRoot:""}]);const a=s},571:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-switcher-preview[data-v-2f8e6670]{background:var(--bg);border:1px solid var(--border-color);border-radius:var(--trp-settings-radius-medium);box-shadow:0 10px 20px 0 #0000000d;overflow:hidden;padding:5px 0;width:-moz-fit-content;width:fit-content}.trp-language-item[data-v-2f8e6670]{align-items:center;display:flex;flex-direction:row}.trp-dropdown-preview[data-v-2f8e6670] .trp-language-item-name{max-width:150px}.trp-preview-ls-inline[data-v-2f8e6670] .trp-language-item-name{width:75px}.trp-preview-ls-inline[data-v-2f8e6670]{display:flex;justify-content:space-between}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/PresetPreviewLanguageSwitcher.vue"],names:[],mappings:"AAsCA,uCAGI,oBAAqB,CAFrB,oCAAqC,CACrC,+CAAgD,CAGhD,kCAAmC,CACnC,eAAgB,CAChB,aAAc,CAHd,sBAAkB,CAAlB,iBAIJ,CAEA,oCAGI,kBAAmB,CAFnB,YAAa,CACb,kBAEJ,CAEA,+DACI,eACJ,CAEA,gEACI,UACJ,CAEA,wCACI,YAAa,CACb,6BACJ",sourcesContent:['<script setup>\r\nimport { useSwitcherPreview } from "../composables/useSwitcherPreview"\r\nimport LanguageItem           from "./LanguageItem.vue"\r\n\r\nconst props = defineProps({\r\n    scope: {\r\n        type: String,\r\n        required: true,\r\n        validator: v => [\'floater\',\'shortcode\',\'menu\'].includes(v)\r\n    }\r\n})\r\n\r\nconst { displayedList, isDropdown } = useSwitcherPreview(props.scope)\r\n<\/script>\r\n\r\n<template>\r\n    <div v-if="isDropdown" class="trp-switcher-preview trp-dropdown-preview">\r\n        <LanguageItem\r\n            v-for="lang in displayedList"\r\n            :key="lang.code"\r\n            :language="lang"\r\n            :dropdown="true"\r\n        />\r\n    </div>\r\n\r\n    <div v-else class="trp-switcher-preview trp-preview-ls-inline">\r\n        <LanguageItem\r\n            v-for="lang in displayedList"\r\n            :key="lang.code"\r\n            :language="lang"\r\n            :dropdown="false"\r\n        />\r\n    </div>\r\n</template>\r\n\r\n\r\n<style scoped>\r\n/* DROPDOWN PREVIEW */\r\n.trp-switcher-preview {\r\n    border: 1px solid var(--border-color);\r\n    border-radius: var(--trp-settings-radius-medium);\r\n    background: var(--bg);\r\n    width: fit-content;\r\n    box-shadow: 0 10px 20px 0 #0000000D;\r\n    overflow: hidden;\r\n    padding: 5px 0;\r\n}\r\n\r\n.trp-language-item{\r\n    display: flex;\r\n    flex-direction: row;\r\n    align-items: center;\r\n}\r\n\r\n.trp-dropdown-preview :deep(.trp-language-item-name) {\r\n    max-width: 150px;\r\n}\r\n\r\n.trp-preview-ls-inline :deep(.trp-language-item-name) {\r\n    width: 75px;\r\n}\r\n\r\n.trp-preview-ls-inline {\r\n    display: flex;\r\n    justify-content: space-between;\r\n}\r\n\r\n</style>\r\n'],sourceRoot:""}]);const a=s},606:e=>{var t,n,r=e.exports={};function i(){throw new Error("setTimeout has not been defined")}function o(){throw new Error("clearTimeout has not been defined")}function s(e){if(t===setTimeout)return setTimeout(e,0);if((t===i||!t)&&setTimeout)return t=setTimeout,setTimeout(e,0);try{return t(e,0)}catch(n){try{return t.call(null,e,0)}catch(n){return t.call(this,e,0)}}}!function(){try{t="function"==typeof setTimeout?setTimeout:i}catch(e){t=i}try{n="function"==typeof clearTimeout?clearTimeout:o}catch(e){n=o}}();var a,l=[],c=!1,h=-1;function d(){c&&a&&(c=!1,a.length?l=a.concat(l):h=-1,l.length&&u())}function u(){if(!c){var e=s(d);c=!0;for(var t=l.length;t;){for(a=l,l=[];++h<t;)a&&a[h].run();h=-1,t=l.length}a=null,c=!1,function(e){if(n===clearTimeout)return clearTimeout(e);if((n===o||!n)&&clearTimeout)return n=clearTimeout,clearTimeout(e);try{return n(e)}catch(t){try{return n.call(null,e)}catch(t){return n.call(this,e)}}}(e)}}function p(e,t){this.fun=e,this.array=t}function f(){}r.nextTick=function(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];l.push(new p(e,t)),1!==l.length||c||s(u)},p.prototype.run=function(){this.fun.apply(null,this.array)},r.title="browser",r.browser=!0,r.env={},r.argv=[],r.version="",r.versions={},r.on=f,r.addListener=f,r.once=f,r.off=f,r.removeListener=f,r.removeAllListeners=f,r.emit=f,r.prependListener=f,r.prependOnceListener=f,r.listeners=function(e){return[]},r.binding=function(e){throw new Error("process.binding is not supported")},r.cwd=function(){return"/"},r.chdir=function(e){throw new Error("process.chdir is not supported")},r.umask=function(){return 0}},612:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-menu-settings__wrapper[data-v-902ede12]{display:flex;flex-direction:column;gap:16px;max-width:640px;width:100%}","",{version:3,sources:["webpack://./assets/src/language-switcher/views/MenuConfig.vue"],names:[],mappings:"AA4DA,6CAGI,YAAa,CACb,qBAAsB,CACtB,QAAS,CAJT,eAAgB,CAChB,UAIJ",sourcesContent:["<script setup>\r\nimport { provide } from 'vue'\r\nimport { onBeforeRouteLeave } from 'vue-router'\r\n\r\nimport SettingsBox from '../components/SettingsBox.vue'\r\nimport SettingsActions from '../components/SettingsActions.vue'\r\n\r\nimport { useSwitcherConfig } from '../composables/useSwitcherConfig'\r\nimport { useSwitcherPersistence } from '../composables/useSwitcherPersistance'\r\n\r\nimport { __ } from '../composables/utils/i18n'\r\nimport { sanitizeHtml }  from \"../composables/utils/sanitizeHtml\"\r\n\r\nconst scope = 'menu'\r\nconst cfg = useSwitcherConfig(scope)\r\n\r\nconst persistence = useSwitcherPersistence(scope)\r\nprovide('switcherPersistence', persistence)\r\n\r\nconst { isDirty, revert } = persistence\r\n\r\nconst T = {\r\n    menuSwitcherLayout: __('Menu Switcher Layout'),\r\n    unsavedChangesAlert: __('You have unsaved changes. Leave anyway?'),\r\n    //[utm4]\r\n    descriptionText: sanitizeHtml( __('Go to <a href=\"/wp-admin/nav-menus.php\">Appearance → Menus</a> to add languages to the Language Switcher in any menu.<br> <a href=\"https://translatepress.com/docs/settings/language-switcher/?utm_source=tp-language-switcher&utm_medium=client-site&utm_campaign=ls-menu-item#menu-switcher\" target=\"_blank\">Learn more in our documentation.</a>') )\r\n}\r\n\r\nonBeforeRouteLeave((_to, _from, next) => {\r\n    if (!isDirty.value) return next()\r\n    const ok = window.confirm(T.unsavedChangesAlert)\r\n    ok ? (revert(), next()) : next(false)\r\n})\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-menu-settings__wrapper\">\r\n        <SettingsBox\r\n            :title=\"T.menuSwitcherLayout\"\r\n            :scope=\"scope\"\r\n            :collapsible=\"false\"\r\n            :fields=\"[\r\n        {\r\n          key: 'layoutCustomizer',\r\n          type: 'lCustomizer',\r\n          label: ''\r\n        }\r\n      ]\"\r\n        >\r\n            <template #end>\r\n                <span class=\"trp-description-text\" v-html=\"T.descriptionText\" />\r\n            </template>\r\n        </SettingsBox>\r\n\r\n        <SettingsActions :scope=\"scope\" />\r\n    </div>\r\n</template>\r\n\r\n\r\n<style scoped>\r\n.trp-menu-settings__wrapper {\r\n    max-width: 640px;\r\n    width: 100%;\r\n    display: flex;\r\n    flex-direction: column;\r\n    gap: 16px;\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},627:e=>{"use strict";function t(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var n=e&&("undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"]);if(null==n)return;var r,i,o=[],s=!0,a=!1;try{for(n=n.call(e);!(s=(r=n.next()).done)&&(o.push(r.value),!t||o.length!==t);s=!0);}catch(e){a=!0,i=e}finally{try{s||null==n.return||n.return()}finally{if(a)throw i}}return o}(e,t)||function(e,t){if(!e)return;if("string"==typeof e)return n(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);"Object"===r&&e.constructor&&(r=e.constructor.name);if("Map"===r||"Set"===r)return Array.from(e);if("Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return n(e,t)}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function n(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}e.exports=function(e){var n=t(e,4),r=n[1],i=n[3];if(!i)return r;if("function"==typeof btoa){var o=btoa(unescape(encodeURIComponent(JSON.stringify(i)))),s="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(o),a="/*# ".concat(s," */"),l=i.sources.map(function(e){return"/*# sourceURL=".concat(i.sourceRoot||"").concat(e," */")});return[r].concat(l).concat([a]).join("\n")}return[r].join("\n")}},640:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-preset-applier[data-v-5bd5ef9e],[data-v-5bd5ef9e]:root{--bg:#fff;--bg-hover:#fff;--text:#000;--text-hover:#000;--border-color:#1438521a;--radius:0px}.trp-preset-applier[data-v-5bd5ef9e]{display:grid;gap:16px}.trp-preset-card[data-v-5bd5ef9e]{display:flex;flex-direction:column;gap:4px}@media (min-width:500px){.trp-preset-applier[data-v-5bd5ef9e]{grid-template-columns:repeat(2,1fr)}}.trp-confirm-button[data-v-5bd5ef9e]{background:var(--trp-settings-accent-color);border:1px solid var(--trp-settings-accent-color);border-radius:var(--trp-settings-radius-medium);color:#fff;cursor:pointer;padding:5px 10px}.trp-confirm-button[data-v-5bd5ef9e]:hover{background:transparent;color:var(--trp-settings-accent-color)}.trp-preview-rect[data-v-5bd5ef9e]{align-items:center;background:#dbdbdb;border-radius:var(--trp-settings-radius-high);display:flex;height:145px;justify-content:center;padding:16px 0;position:relative;width:100%}.trp-apply-btn[data-v-5bd5ef9e]{all:unset;color:var(--trp-settings-accent-color);cursor:pointer;font-size:var(--trp-settings-primary-font-size);font-weight:500}.trp-apply-btn[data-v-5bd5ef9e]:hover{opacity:.8}.trp-confirmation-dialog[data-v-5bd5ef9e]{background:#fff;border:1px solid;border-radius:8px;bottom:0;left:0;padding:16px;position:absolute;right:0;text-align:center;top:0}.trp-dialog-actions[data-v-5bd5ef9e]{align-items:center;display:flex;gap:8px;justify-content:center;margin-top:12px}.trp-confirmation-overwrite-warning[data-v-5bd5ef9e]{color:#c94f2d}.trp-cancel-button[data-v-5bd5ef9e]{cursor:pointer}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/PresetApplier.vue"],names:[],mappings:"AAgJA,4DACI,SAAuB,CACvB,eAAuB,CACvB,WAAuB,CACvB,iBAAuB,CACvB,wBAAyB,CACzB,YACJ,CAEA,qCACI,YAAa,CACb,QACJ,CAEA,kCACI,YAAa,CACb,qBAAsB,CACtB,OACJ,CAGA,yBACI,qCACI,mCACJ,CACJ,CAEA,qCAII,2CAA4C,CAC5C,iDAAkD,CAHlD,+CAAgD,CAChD,UAAc,CAFd,cAAe,CAKf,gBACJ,CAGA,2CACI,sBAAuB,CACvB,sCACJ,CAEA,mCAQI,kBAAmB,CALnB,kBAAmB,CAEnB,6CAA8C,CAC9C,YAAa,CAJb,YAAa,CAKb,sBAAuB,CAHvB,cAAe,CAKf,iBAAkB,CARlB,UASJ,CAEA,gCACI,SAAU,CACV,sCAAuC,CAGvC,cAAe,CAFf,+CAAgD,CAChD,eAEJ,CAEA,sCACI,UACJ,CAEA,0CACI,eAAgB,CAGhB,gBAAiB,CADjB,iBAAkB,CAMlB,QAAS,CACT,MAAO,CARP,YAAa,CAIb,iBAAkB,CAElB,OAAQ,CAHR,iBAAkB,CAElB,KAIJ,CAEA,qCAKI,kBAAmB,CAHnB,YAAa,CACb,OAAQ,CACR,sBAAuB,CAHvB,eAKJ,CAEA,qDACI,aACJ,CAEA,oCACI,cACJ",sourcesContent:["<script setup>\r\nimport { ref }    from 'vue'\r\nimport { useSwitcherConfig } from \"../composables/useSwitcherConfig\"\r\nimport PresetPreviewLanguageSwitcher from './PresetPreviewLanguageSwitcher.vue'\r\nimport { __, sprintf }               from \"../composables/utils/i18n\"\r\n\r\nconst props = defineProps({\r\n    scope: {\r\n      type: String,\r\n      required: true,\r\n      validator: v => ['floater','shortcode','menu'].includes(v)\r\n    }\r\n})\r\n\r\nconst cfg = useSwitcherConfig(props.scope)\r\n\r\n/** Localized UI text */\r\nconst T = {\r\n    presetDefault: __('Default'),\r\n    presetDark: __('Dark'),\r\n    presetBorder: __('Border'),\r\n    presetTransparent: __('Transparent'),\r\n    confirmTitleHtml: __('Are you sure you want to apply the <strong>%s</strong> preset?'),\r\n    confirmOverwrite: __('It will override your current settings.'),\r\n    applyPreset: __('Apply preset'),\r\n    cancel: __('Cancel'),\r\n    applyPresetWithName: __('Apply %s preset'),\r\n}\r\n\r\nconst presets = [\r\n    {\r\n        id: 'default',\r\n        name: T.presetDefault,\r\n        settings: {\r\n            bgColor:        '#ffffff',\r\n            bgHoverColor:   '#0000000D',\r\n            textColor:      '#143852',\r\n            textHoverColor: '#1D2327',\r\n            borderColor:    '#1438521A'\r\n        }\r\n    },\r\n    {\r\n        id: 'dark',\r\n        name: T.presetDark,\r\n        settings: {\r\n            bgColor:        '#000000',\r\n            bgHoverColor:   '#444444',\r\n            textColor:      '#ffffff',\r\n            textHoverColor: '#eeeeee',\r\n            borderColor:    'transparent'\r\n        }\r\n    },\r\n    {\r\n        id: 'border',\r\n        name: T.presetBorder,\r\n        settings: {\r\n            bgColor:        '#FFFFFF',\r\n            bgHoverColor:   '#000000',\r\n            textColor:      '#143852',\r\n            textHoverColor: '#ffffff',\r\n            borderColor:    '#143852'\r\n        }\r\n    },\r\n    {\r\n        id: 'transparent',\r\n        name: T.presetTransparent,\r\n        settings: {\r\n            bgColor:        '#FFFFFFB2',\r\n            bgHoverColor:   '#FFFFFFB2',\r\n            textColor:      '#000000',\r\n            textHoverColor: '#000000',\r\n            borderColor:    'transparent'\r\n        }\r\n    },\r\n]\r\n\r\n// helper: map settings → CSS variables on the card\r\nfunction cssVars(s) {\r\n    return {\r\n        '--bg':           s.bgColor,\r\n        '--bg-hover':     s.bgHoverColor,\r\n        '--text':         s.textColor,\r\n        '--text-hover':   s.textHoverColor,\r\n        '--border-color': s.borderColor\r\n    }\r\n}\r\n\r\nconst confirmPreset = ref(null)\r\n\r\nfunction requestApply(preset) {\r\n    confirmPreset.value = preset\r\n}\r\n\r\nfunction cancelApply() {\r\n    confirmPreset.value = null\r\n}\r\n\r\nfunction applyPreset() {\r\n    if (!confirmPreset.value) return\r\n\r\n    Object.entries(confirmPreset.value.settings).forEach(([key, val]) => {\r\n        cfg[key] = val\r\n    })\r\n\r\n    confirmPreset.value = null\r\n}\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-preset-applier\">\r\n        <div\r\n            v-for=\"preset in presets\"\r\n            :key=\"preset.id\"\r\n            class=\"trp-preset-card\"\r\n            :style=\"cssVars(preset.settings)\"\r\n        >\r\n            <div class=\"trp-preview-rect\"\r\n                 :style=\"{ background: preset.id === 'transparent' ? 'linear-gradient(145.41deg, #2271B1 20.41%, #D3B4DA 96.59%)' : '#DBDBDB' }\"\r\n            >\r\n                <PresetPreviewLanguageSwitcher :scope=\"scope\" />\r\n                <div\r\n                    v-if=\"confirmPreset && confirmPreset.id === preset.id\"\r\n                    class=\"trp-confirmation-dialog\"\r\n                >\r\n                    \x3c!-- translators: %s is the preset name --\x3e\r\n                    <p class=\"trp-primary-text\" v-html=\"sprintf(T.confirmTitleHtml, preset.name)\"></p>\r\n                    <p class=\"trp-primary-text trp-confirmation-overwrite-warning\">{{ T.confirmOverwrite }}</p>\r\n                    <div class=\"trp-dialog-actions\">\r\n                        <button class=\"trp-confirm-button\" @click=\"applyPreset\">{{ T.applyPreset }}</button>\r\n                        <span class=\"trp-description-text trp-cancel-button\" @click=\"cancelApply\">{{ T.cancel }}</span>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <button class=\"trp-apply-btn\" @click=\"requestApply(preset)\">\r\n                \x3c!-- translators: %s is the preset name --\x3e\r\n                {{ sprintf(T.applyPresetWithName, preset.name) }}\r\n            </button>\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n/* Add Fallback to vars */\r\n:root, .trp-preset-applier {\r\n    --bg:           #ffffff;\r\n    --bg-hover:     #ffffff;\r\n    --text:         #000000;\r\n    --text-hover:   #000000;\r\n    --border-color: #1438521A;\r\n    --radius:       0px;\r\n}\r\n\r\n.trp-preset-applier {\r\n    display: grid;\r\n    gap: 16px;\r\n}\r\n\r\n.trp-preset-card {\r\n    display: flex;\r\n    flex-direction: column;\r\n    gap: 4px;\r\n}\r\n\r\n/* ≥ 500 px -> 2 columns */\r\n@media (min-width: 500px) {\r\n    .trp-preset-applier {\r\n        grid-template-columns: repeat(2, 1fr);\r\n    }\r\n}\r\n\r\n.trp-confirm-button {\r\n    cursor: pointer;\r\n    border-radius: var(--trp-settings-radius-medium);\r\n    color: #ffffff;\r\n    background: var(--trp-settings-accent-color);\r\n    border: 1px solid var(--trp-settings-accent-color);\r\n    padding: 5px 10px;\r\n}\r\n\r\n\r\n.trp-confirm-button:hover {\r\n    background: transparent;\r\n    color: var(--trp-settings-accent-color);\r\n}\r\n\r\n.trp-preview-rect {\r\n    width: 100%;\r\n    height: 145px;\r\n    background: #DBDBDB;\r\n    padding: 16px 0;\r\n    border-radius: var(--trp-settings-radius-high);\r\n    display: flex;\r\n    justify-content: center;\r\n    align-items: center;\r\n    position: relative;\r\n}\r\n\r\n.trp-apply-btn {\r\n    all: unset;\r\n    color: var(--trp-settings-accent-color);\r\n    font-size: var(--trp-settings-primary-font-size);\r\n    font-weight: 500;\r\n    cursor: pointer;\r\n}\r\n\r\n.trp-apply-btn:hover {\r\n    opacity: 0.8;\r\n}\r\n\r\n.trp-confirmation-dialog {\r\n    background: #fff;\r\n    padding: 16px;\r\n    border-radius: 8px;\r\n    border: 1px solid;\r\n    text-align: center;\r\n    position: absolute;\r\n    top: 0;\r\n    right: 0;\r\n    bottom: 0;\r\n    left: 0;\r\n}\r\n\r\n.trp-dialog-actions {\r\n    margin-top: 12px;\r\n    display: flex;\r\n    gap: 8px;\r\n    justify-content: center;\r\n    align-items: center;\r\n}\r\n\r\n.trp-confirmation-overwrite-warning {\r\n    color: #C94F2D;\r\n}\r\n\r\n.trp-cancel-button {\r\n    cursor: pointer;\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},652:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-shortcode-display[data-v-b466f20a]{align-items:center;display:flex;gap:12px}.trp-shortcode-input[data-v-b466f20a]{background:#fff;border:1px solid #c3c4c7;border-radius:5px;flex:1;font-family:monospace;height:40px;padding:12px}.trp-description-text[data-v-b466f20a]{margin:0}.trp-copy-btn[data-v-b466f20a]:focus-visible,.trp-shortcode-input[data-v-b466f20a]:focus-visible{outline-color:var(--trp-settings-accent-color)}.trp-copy-btn[data-v-b466f20a]{align-content:center;display:flex;gap:8px;justify-content:center}.trp-copy-btn:hover svg path[data-v-b466f20a]{stroke:#fff}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/ShortcodeCopy.vue"],names:[],mappings:"AA6EA,wCAGI,kBAAkB,CAFlB,YAAY,CACZ,QAEJ,CAEA,sCAMI,eAAmB,CAFnB,wBAAyB,CACzB,iBAAkB,CAJlB,MAAO,CAMP,qBAAsB,CAJtB,WAAY,CADZ,YAMJ,CAEA,uCACI,QACJ,CAEA,iGACI,8CACJ,CAEA,+BAGI,oBAAqB,CAFrB,YAAa,CAGb,OAAQ,CAFR,sBAGJ,CAEA,8CACI,WACJ",sourcesContent:['<script setup>\r\nimport { ref, computed } from \'vue\'\r\nimport { __ }            from \'../composables/utils/i18n\'\r\n\r\nconst SHORTCODE = \'[language-switcher]\'\r\nconst copiedFeedback = ref(false)\r\n\r\nconst copyButtonLabel = computed(() =>\r\n    copiedFeedback.value ? __(\'Copied!\') : __(\'Copy\')\r\n)\r\n\r\nfunction copyToClipboard() {\r\n    navigator.clipboard?.writeText(SHORTCODE)\r\n             .then(() => {\r\n                 copiedFeedback.value = true\r\n                 setTimeout(() => copiedFeedback.value = false, 2000)\r\n             })\r\n             .catch(() => {\r\n                 // Fallback for very old browsers\r\n                 const textarea = document.createElement(\'textarea\')\r\n                 textarea.value = SHORTCODE\r\n                 textarea.style.position = \'fixed\'\r\n                 textarea.style.opacity = \'0\'\r\n\r\n                 document.body.appendChild(textarea)\r\n                 textarea.select()\r\n\r\n                 try {\r\n                     document.execCommand(\'copy\')\r\n                 } finally {\r\n                     document.body.removeChild(textarea)\r\n                     copiedFeedback.value = true\r\n                     setTimeout(() => copiedFeedback.value = false, 2000)\r\n                 }\r\n             })\r\n}\r\n\r\nconst shortcodeDescription = __(\'Use shortcode on any page or widget. You can also add the Language Switcher Block in the WP Gutenberg Editor.\')\r\n<\/script>\r\n\r\n<template>\r\n    <div class="trp-shortcode-display">\r\n        <input\r\n            class="trp-shortcode-input trp-primary-text"\r\n            :value="SHORTCODE"\r\n            readonly\r\n        />\r\n        <button\r\n            class="trp-copy-btn trp-button-secondary"\r\n            type="button"\r\n            @click="copyToClipboard"\r\n        >\r\n            <svg\r\n                width="22"\r\n                height="22"\r\n                viewBox="0 0 22 22"\r\n                fill="none"\r\n                xmlns="http://www.w3.org/2000/svg"\r\n            >\r\n                <path\r\n                    d="M14.666 7.33317V5.49984C14.666 5.01361 14.4729 4.54729 14.129 4.20347C13.7852 3.85966 13.3189 3.6665 12.8327 3.6665H5.49935C5.01312 3.6665 4.5468 3.85966 4.20299 4.20347C3.85917 4.54729 3.66602 5.01361 3.66602 5.49984V12.8332C3.66602 13.3194 3.85917 13.7857 4.20299 14.1295C4.5468 14.4733 5.01312 14.6665 5.49935 14.6665H7.33268M7.33268 9.1665C7.33268 8.68027 7.52584 8.21396 7.86965 7.87014C8.21347 7.52633 8.67979 7.33317 9.16602 7.33317H16.4993C16.9856 7.33317 17.4519 7.52633 17.7957 7.87014C18.1395 8.21396 18.3327 8.68027 18.3327 9.1665V16.4998C18.3327 16.9861 18.1395 17.4524 17.7957 17.7962C17.4519 18.14 16.9856 18.3332 16.4993 18.3332H9.16602C8.67979 18.3332 8.21347 18.14 7.86965 17.7962C7.52584 17.4524 7.33268 16.9861 7.33268 16.4998V9.1665Z"\r\n                    stroke="#2271B1"\r\n                    stroke-width="1.5"\r\n                    stroke-linecap="round"\r\n                    stroke-linejoin="round"\r\n                />\r\n            </svg>\r\n            {{ copyButtonLabel }}\r\n        </button>\r\n    </div>\r\n\r\n    <p class="trp-description-text">\r\n        {{ shortcodeDescription }}\r\n    </p>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-shortcode-display{\r\n    display:flex;\r\n    gap:12px;\r\n    align-items:center;\r\n}\r\n\r\n.trp-shortcode-input{\r\n    flex: 1;\r\n    padding: 12px;\r\n    height: 40px;\r\n    border: 1px solid #C3C4C7;\r\n    border-radius: 5px;\r\n    background: #ffffff;\r\n    font-family: monospace;\r\n}\r\n\r\n.trp-description-text {\r\n    margin: 0;\r\n}\r\n\r\n.trp-shortcode-input:focus-visible, .trp-copy-btn:focus-visible {\r\n    outline-color: var(--trp-settings-accent-color);\r\n}\r\n\r\n.trp-copy-btn  {\r\n    display: flex;\r\n    justify-content: center;\r\n    align-content: center;\r\n    gap: 8px;\r\n}\r\n\r\n.trp-copy-btn:hover svg path {\r\n    stroke: #ffffff;\r\n}\r\n\r\n</style>\r\n'],sourceRoot:""}]);const a=s},661:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-floater-settings__wrapper[data-v-469f4c76]{display:flex;flex-direction:row;gap:16px;max-width:1200px;width:100%}.trp-floater-settings__right[data-v-469f4c76]{display:flex;flex-direction:column;gap:16px;max-width:641px;width:60%}.trp-floater-settings__left[data-v-469f4c76]{width:40%}.trp-sticky-box[data-v-469f4c76]{position:sticky;top:50px}","",{version:3,sources:["webpack://./assets/src/language-switcher/views/ShortcodeConfig.vue"],names:[],mappings:"AA2LA,gDACI,YAAY,CACZ,kBAAkB,CAClB,QAAQ,CACR,gBAAgB,CAChB,UACJ,CAEA,8CACI,YAAY,CACZ,qBAAqB,CACrB,QAAQ,CAER,eAAe,CADf,SAEJ,CAEA,6CACI,SACJ,CAEA,iCACI,eAAe,CAAE,QACrB",sourcesContent:["<script setup>\r\nimport { computed, provide } from 'vue'\r\nimport { onBeforeRouteLeave } from 'vue-router'\r\n\r\nimport SettingsBox from '../components/SettingsBox.vue'\r\nimport SettingsActions from '../components/SettingsActions.vue'\r\nimport LanguageSwitcherPreview from '../components/LanguageSwitcherPreview.vue'\r\nimport ShortcodeCopy from '../components/ShortcodeCopy.vue'\r\n\r\nimport { useLanguages, useSwitcherConfig } from '../composables/useSwitcherConfig'\r\nimport { useSwitcherPersistence }          from '../composables/useSwitcherPersistance'\r\n\r\nimport { useLayoutCustomizer } from \"../composables/layoutCustomizer/useLayoutCustomizer\"\r\nimport { __ }                  from '../composables/utils/i18n'\r\n\r\nconst scope = 'shortcode'\r\nconst cfg = useSwitcherConfig(scope)\r\nconst persistence = useSwitcherPersistence(scope)\r\nprovide('switcherPersistence', persistence)\r\n\r\nconst { isDirty, revert } = persistence\r\nconst { positioning } = useLayoutCustomizer(scope)\r\n\r\nconst flagRatio = computed(() => cfg.flagShape)\r\n\r\nconst languageItemSettings = computed(() => ({\r\n    flagPos: positioning.value.flagPos,\r\n    nameMode: positioning.value.languageNames,\r\n    flagRatio: flagRatio\r\n}))\r\nprovide('languageItemSettings', languageItemSettings)\r\n\r\nconst oppositeLanguageFieldDescription = __(\r\n    'Transforms the language switcher into a button showing the other available language, not the current one. <br> Only works when there are exactly two languages, the default one and a translation one.'\r\n)\r\n\r\nconst { published } = useLanguages()\r\n\r\nconst publishedLangCount = Object.keys(published).length\r\n\r\nconst aboveTwoLanguages = publishedLangCount > 2\r\n\r\nconst aboveTwoLanguagesTitle = aboveTwoLanguages\r\n    ? __('This option only works when exactly two languages are published.')\r\n    : ''\r\n\r\nconst T = {\r\n    confirmLeave: __('You have unsaved changes. Leave anyway?'),\r\n    switcherPreview: __('Switcher Preview'),\r\n    shortcode: __('Shortcode'),\r\n    customizeDesign: __('Customize Design'),\r\n    backgroundColor: __('Background color'),\r\n    backgroundHoverColor: __('Background hover color'),\r\n    textColor: __('Text color'),\r\n    textHoverColor: __('Text hover color'),\r\n    switcherBorderColor: __('Switcher border color'),\r\n    switcherBorderWidth: __('Switcher border width'),\r\n    switcherBorderRadius: __('Switcher border radius'),\r\n    flagTextSize: __('Flag and text size'),\r\n    normal: __('Normal'),\r\n    large: __('Large'),\r\n    flagIconsShape: __('Flag icons shape'),\r\n    rectangle: __('Rectangle (4:3)'),\r\n    square: __('Square (1:1)'),\r\n    flagRadius: __('Flag icons border radius'),\r\n    enableCustomCss: __('Enable custom CSS'),\r\n    customizeLayout: __('Customize Layout'),\r\n    additionalSettings: __('Additional Settings'),\r\n    openOnClick: __('Open language switcher only on click'),\r\n    clickLangDesc: __('Open the language switcher shortcode by clicking on it instead of hovering. <br> Close it by clicking on it, anywhere else on the screen or by pressing the escape key. <br> This will affect only the shortcode language switcher.'),\r\n    enableTransitions: __( 'Switcher animations' ),\r\n    showOppositeLanguage: __('Show opposite language'),\r\n}\r\n\r\nonBeforeRouteLeave((_to, _from, next) => {\r\n    if (!isDirty.value) return next()\r\n    const confirmLeave = window.confirm(T.confirmLeave)\r\n    confirmLeave ? (revert(), next()) : next(false)\r\n})\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-floater-settings__wrapper\">\r\n        <div class=\"trp-floater-settings__left\">\r\n            <div class=\"trp-sticky-box\">\r\n                <SettingsBox :title=\"T.switcherPreview\" :scope=\"scope\">\r\n                    <LanguageSwitcherPreview :scope=\"scope\" />\r\n                </SettingsBox>\r\n\r\n                <SettingsActions :scope=\"scope\" />\r\n            </div>\r\n        </div>\r\n\r\n        <div class=\"trp-floater-settings__right\">\r\n            <SettingsBox :title=\"T.shortcode\" :scope=\"scope\">\r\n                <ShortcodeCopy />\r\n            </SettingsBox>\r\n\r\n            <SettingsBox\r\n                :title=\"T.customizeDesign\"\r\n                :scope=\"scope\"\r\n                collapsible\r\n                :style=\"{ '--trp-field-label-width': '190px' }\"\r\n                :fields=\"[\r\n                    { key: 'bgColor',        type: 'color', label: T.backgroundColor,       default: '#ffffff' },\r\n                    { key: 'bgHoverColor',   type: 'color', label: T.backgroundHoverColor,  default: '#f5f5f5' },\r\n                    { key: 'textColor',      type: 'color', label: T.textColor,             default: '#1D2327' },\r\n                    { key: 'textHoverColor', type: 'color', label: T.textHoverColor,        default: '#000000' },\r\n                    { key: 'borderColor',    type: 'color', label: T.switcherBorderColor,   default: '#1438521A' },\r\n                    { key: 'borderWidth',    type: 'number',label: T.switcherBorderWidth,   default: 1 },\r\n                    { key: 'borderRadius',   type: 'number',label: T.switcherBorderRadius,  default: 5 },\r\n                    { type: 'separator' },\r\n                    {\r\n                        key: 'enableTransitions',\r\n                        type: 'toggle',\r\n                        label: T.enableTransitions,\r\n                        default: true\r\n                    },\r\n                    { type: 'separator' },\r\n                    {\r\n                        key: 'size',\r\n                        type: 'radio',\r\n                        label: T.flagTextSize,\r\n                        default: 'normal',\r\n                        options: [\r\n                            { value: 'normal', label: T.normal },\r\n                            { value: 'large',  label: T.large  }\r\n                        ],\r\n                        layout: 'column'\r\n                    },\r\n                    { type: 'separator' },\r\n                    {\r\n                        key: 'flagShape',\r\n                        type: 'radio',\r\n                        label: T.flagIconsShape,\r\n                        default: 'rect',\r\n                        options: [\r\n                            { value: 'rect',   label: T.rectangle },\r\n                            { value: 'square', label: T.square    }\r\n                        ],\r\n                        layout: 'column'\r\n                    },\r\n                    { key: 'flagRadius', type: 'number', label: T.flagRadius, default: 2 },\r\n                    { type: 'separator' },\r\n                    { key: 'enableCustomCss', type: 'toggle', label: T.enableCustomCss, default: false },\r\n                    { key: 'customCss', type: 'customCss', label: '', visible: cfg => cfg?.enableCustomCss === true }\r\n                ]\"\r\n            />\r\n\r\n            <SettingsBox\r\n                :title=\"T.customizeLayout\"\r\n                :scope=\"scope\"\r\n                collapsible\r\n                :fields=\"[\r\n                    { key: 'layoutCustomizer', type: 'lCustomizer', label: '' }\r\n                ]\"\r\n            />\r\n\r\n            <SettingsBox\r\n                :title=\"T.additionalSettings\"\r\n                :scope=\"scope\"\r\n                collapsible\r\n                :fields=\"[\r\n                    {\r\n                        key: 'clickLanguage',\r\n                        type: 'checkbox',\r\n                        default: false,\r\n                        label: T.openOnClick,\r\n                        description: T.clickLangDesc\r\n                    },\r\n                    {\r\n                        key: 'oppositeLanguage',\r\n                        type: 'checkbox',\r\n                        default: false,\r\n                        label: T.showOppositeLanguage,\r\n                        description: oppositeLanguageFieldDescription,\r\n                        disabled: aboveTwoLanguages,\r\n                        title: aboveTwoLanguagesTitle\r\n                    }\r\n                ]\"\r\n            />\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n/* Re-use the same structural styles as the Floater view for consistency */\r\n.trp-floater-settings__wrapper {\r\n    display:flex;\r\n    flex-direction:row;\r\n    gap:16px;\r\n    max-width:1200px;\r\n    width:100%;\r\n}\r\n\r\n.trp-floater-settings__right {\r\n    display:flex;\r\n    flex-direction:column;\r\n    gap:16px;\r\n    width:60%;\r\n    max-width:641px;\r\n}\r\n\r\n.trp-floater-settings__left {\r\n    width:40%;\r\n}\r\n\r\n.trp-sticky-box {\r\n    position:sticky; top:50px;\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},700:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-ls-wrapper[data-v-bf1beb8c]{display:flex;flex-direction:column}.trp-ls-view[data-v-bf1beb8c]{display:flex;justify-content:flex-start;padding:0 32px}","",{version:3,sources:["webpack://./assets/src/language-switcher/App.vue"],names:[],mappings:"AAuBA,iCACI,YAAa,CACb,qBACJ,CACA,8BAEI,YAAa,CACb,0BAA2B,CAF3B,cAGJ",sourcesContent:["<script setup>\r\n\r\nimport SubMenu from './components/SubMenu.vue'\r\nimport { provideSwitcherConfig } from './composables/useSwitcherConfig'\r\n\r\nconst el = document.getElementById('tp-language-switcher-root')\r\n/** tpLangSwitcherData comes from wp_localize_script */\r\nconst { lsConfig: config, languages } = window.tpLangSwitcherData\r\n\r\nprovideSwitcherConfig( { config, languages } )\r\n\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-ls-wrapper\">\r\n        <SubMenu />\r\n        <main class=\"trp-ls-view\">\r\n            <router-view />\r\n        </main>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-ls-wrapper {\r\n    display: flex;\r\n    flex-direction: column;\r\n}\r\n.trp-ls-view {\r\n    padding: 0 32px;\r\n    display: flex;\r\n    justify-content: flex-start;\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},751:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-settings-box[data-v-2daa727d]{background:#fff;border:1px solid #e2e2e4;border-radius:2px;box-sizing:border-box;display:flex;flex-direction:column;gap:24px;padding:24px}.trp-header[data-v-2daa727d]{display:flex;justify-content:space-between}.trp-settings-box.trp-collapsible .trp-header[data-v-2daa727d]{cursor:pointer}.trp-title[data-v-2daa727d]{color:var(--trp-settings-primary-color);font-size:16px;font-weight:590}.trp-chevron[data-v-2daa727d]{transition:transform .2s ease}.trp-chevron.open[data-v-2daa727d]{transform:rotate(180deg)}.trp-body[data-v-2daa727d]{display:flex;flex-direction:column;gap:24px}.trp-separator[data-v-2daa727d]{background:var(--trp-settings-light-gray-border-color);height:1px;width:100%}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/SettingsBox.vue"],names:[],mappings:"AA8FA,mCAMI,eAAgB,CAChB,wBAAyB,CACzB,iBAAkB,CAPlB,qBAAsB,CACtB,YAAa,CACb,qBAAsB,CAEtB,QAAS,CADT,YAKJ,CAEA,6BACI,YAAa,CACb,6BACJ,CAEA,+DACI,cACJ,CAEA,4BAEI,uCAAwC,CACxC,cAAe,CAFf,eAGJ,CAEA,8BACI,6BACJ,CAEA,mCACI,wBACJ,CAEA,2BACI,YAAa,CACb,qBAAsB,CACtB,QACJ,CAEA,gCAGI,sDAAuD,CAFvD,UAAW,CACX,UAEJ",sourcesContent:['<script setup>\r\nimport { ref, computed, reactive } from \'vue\'\r\nimport { useSwitcherConfig } from \'../composables/useSwitcherConfig\'\r\n\r\nimport ColorField            from \'../components/fields/ColorField.vue\'\r\nimport NumberField           from \'../components/fields/NumberField.vue\'\r\nimport ToggleField           from \'../components/fields/ToggleField.vue\'\r\nimport ToggleStatusField     from \'../components/fields/ToggleStatusField.vue\'\r\nimport RadioGroupField       from \'../components/fields/RadioGroupField.vue\'\r\nimport QuadRadiusField       from \'../components/fields/QuadRadiusField.vue\'\r\nimport CustomCssAreaField    from \'../components/fields/CustomCssAreaField.vue\'\r\nimport LayoutCustomizerField from \'../components/fields/LayoutCustomizerField.vue\'\r\nimport CheckboxField         from \'../components/fields/CheckboxField.vue\'\r\n\r\nconst componentMap = {\r\n    color         : ColorField,\r\n    number        : NumberField,\r\n    toggle        : ToggleField,\r\n    toggleStatus  : ToggleStatusField,\r\n    radio         : RadioGroupField,\r\n    quadNumber    : QuadRadiusField,\r\n    customCss     : CustomCssAreaField,\r\n    lCustomizer   : LayoutCustomizerField,\r\n    checkbox      : CheckboxField,\r\n}\r\n\r\nconst props = defineProps( {\r\n    title       : { type: String, required: true },\r\n    fields      : { type: Array, required: false, default: [] }, // [{ fields:[{key,type,label,...}] }]\r\n    collapsible : { type: Boolean, default: false },\r\n    scope       : { type: String, required: true }\r\n})\r\n\r\nconst cfg = useSwitcherConfig( props.scope )\r\n\r\nconst open = ref( !props.collapsible )\r\n\r\nconst bindings = reactive({})\r\n\r\nprops.fields.forEach(field => {\r\n    if (field.type === \'separator\' || bindings[field.key]) return;\r\n\r\n    if (cfg[field.key] === undefined && field.default !== undefined)\r\n        cfg[field.key] = field.default\r\n\r\n    bindings[field.key] = computed({\r\n        get: () => cfg[field.key],\r\n        set: val => cfg[field.key] = val\r\n    })\r\n})\r\n<\/script>\r\n\r\n<template>\r\n    <div\r\n        class="trp-settings-box"\r\n        :class="{ \'trp-collapsible\': props.collapsible }"\r\n    >\r\n        <header class="trp-header" @click="props.collapsible && (open = !open)">\r\n            <span class="trp-title">{{ props.title }}</span>\r\n            <svg\r\n                v-if="props.collapsible"\r\n                class="trp-chevron"\r\n                :class="{ open }"\r\n                viewBox="0 0 20 20"\r\n                width="20" height="20"\r\n            >\r\n                <path d="M5 6L10 11L15 6L17 7L10 14L3 7L5 6Z" fill="#9CA1A8"/>\r\n            </svg>\r\n        </header>\r\n\r\n        <section v-show="open" class="trp-body">\r\n            <slot v-if="$slots.default" /> \x3c!-- In case a component is injected inside SettingsBox, it will be directly rendered - bypassing the routing system.  --\x3e\r\n\r\n            <template v-for="field in props.fields" :key="field.key || field.type">\r\n                <div v-if="field.type === \'separator\'" class="trp-separator" />\r\n                <component\r\n                    v-else\r\n                    :is="componentMap[field.type]"\r\n                    v-model="bindings[field.key]"\r\n                    v-bind="{ ...field, visible: field.visible ? field.visible(cfg) : true }"\r\n                    :scope="scope"\r\n                    :class="[\r\n                        \'trp-field\',\r\n                        field.hasOwnProperty(\'layout\') ? \'trp-field--column\' : \'trp-field--row\'\r\n                    ]"\r\n                />\r\n            </template>\r\n\r\n            <slot name="end" />\r\n        </section>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-settings-box {\r\n    box-sizing: border-box;\r\n    display: flex;\r\n    flex-direction: column;\r\n    padding: 24px;\r\n    gap: 24px;\r\n    background: #fff;\r\n    border: 1px solid #e2e2e4;\r\n    border-radius: 2px;\r\n}\r\n\r\n.trp-header {\r\n    display: flex;\r\n    justify-content: space-between;\r\n}\r\n\r\n.trp-settings-box.trp-collapsible .trp-header {\r\n    cursor: pointer;\r\n}\r\n\r\n.trp-title {\r\n    font-weight: 590;\r\n    color: var(--trp-settings-primary-color);\r\n    font-size: 16px;\r\n}\r\n\r\n.trp-chevron {\r\n    transition: transform .2s ease;\r\n}\r\n\r\n.trp-chevron.open {\r\n    transform: rotate(180deg);\r\n}\r\n\r\n.trp-body {\r\n    display: flex;\r\n    flex-direction: column;\r\n    gap: 24px;\r\n}\r\n\r\n.trp-separator {\r\n    height: 1px;\r\n    width: 100%;\r\n    background: var(--trp-settings-light-gray-border-color);\r\n}\r\n\r\n</style>\r\n'],sourceRoot:""}]);const a=s},769:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-actions-overlay[data-v-9c66bec4]{backdrop-filter:blur(2px);background:rgba(0,0,0,.35);inset:0;position:fixed;z-index:1000}.trp-revert-confirm[data-v-9c66bec4]{background:#fff;border:1px solid #e2e2e4;border-radius:8px;left:50%;max-width:350px;padding:15px;position:fixed;top:50%;transform:translate(-50%,-50%);z-index:10001}.trp-revert-actions[data-v-9c66bec4]{align-items:center;display:flex;justify-content:center}.trp-revert-text[data-v-9c66bec4]{text-align:center}.trp-btn-revert[data-v-9c66bec4]{margin-right:10px}.trp-btn-cancel[data-v-9c66bec4]{cursor:pointer}.trp-btn-cancel[data-v-9c66bec4]:hover{opacity:.8}.trp-settings-actions[data-v-9c66bec4]{align-items:center;display:flex;gap:12px;margin-top:24px}.trp-button-secondary[data-v-9c66bec4]{height:40px}.trp-button-secondary:hover svg path[data-v-9c66bec4]{fill:#fff}.trp-submit-btn[data-v-9c66bec4]{align-items:center;display:flex;gap:8px}.trp-button-secondary[data-v-9c66bec4]:disabled,.trp-submit-btn[data-v-9c66bec4]:disabled{opacity:.8;pointer-events:none}.trp-save-spinner[data-v-9c66bec4]{animation:spin-9c66bec4 .6s linear infinite;border:2px solid hsla(0,0%,100%,.3);border-radius:50%;border-top-color:#fff;display:inline-block;height:14px;width:14px}@keyframes spin-9c66bec4{to{transform:rotate(1turn)}}.trp-save-ls-error[data-v-9c66bec4]{color:#c00;font-size:13px;margin-left:12px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/SettingsActions.vue"],names:[],mappings:"AA+GA,sCAII,yBAAyB,CADzB,0BAA0B,CAD1B,OAAQ,CADR,cAAe,CAIf,YACJ,CAEA,qCAGI,eAAmB,CACnB,wBAAyB,CACzB,iBAAkB,CAGlB,QAAS,CAFT,eAAgB,CAIhB,YAAa,CATb,cAAe,CAMf,OAAQ,CAER,8BAAgC,CAPhC,aASJ,CAEA,qCAGI,kBAAmB,CAFnB,YAAa,CACb,sBAEJ,CAEA,kCACI,iBACJ,CAEA,iCACI,iBACJ,CAEA,iCACI,cACJ,CAEA,uCACI,UACJ,CAEA,uCAEI,kBAAmB,CADnB,YAAa,CAEb,QAAS,CACT,eACJ,CAEA,uCACI,WACJ,CAEA,sDACI,SACJ,CAEA,iCAEI,kBAAmB,CADnB,YAAa,CAEb,OACJ,CAEA,0FACI,UAAY,CACZ,mBACJ,CAEA,mCAQI,2CAAoC,CAFpC,mCAAyB,CACzB,iBAAkB,CADlB,qBAAyB,CAHzB,oBAAqB,CADrB,WAAY,CADZ,UAQJ,CAEA,yBACI,GAAK,uBAA2B,CACpC,CAEA,oCACI,UAAW,CACX,cAAe,CACf,gBACJ",sourcesContent:['<script setup>\r\nimport { useSwitcherConfig } from "../composables/useSwitcherConfig"\r\nimport { inject, ref } from "vue"\r\nimport { __ }          from "../composables/utils/i18n"\r\n\r\nconst props = defineProps({\r\n    scope: { type: String, required: true }\r\n})\r\n\r\nconst { save, revert, isDirty, saving, justSaved, errorMsg } = inject(\'switcherPersistence\')\r\n\r\nconst confirmRevert = ref(false)\r\n\r\nfunction askRevert () {\r\n    confirmRevert.value = true\r\n}\r\nfunction cancelRevert () {\r\n    confirmRevert.value = false\r\n}\r\nfunction doRevert () {\r\n    revert()\r\n    confirmRevert.value = false\r\n}\r\n\r\nconst cfg = useSwitcherConfig(props.scope)\r\n\r\nconst T = {\r\n    saving: __(\'Saving...\'),\r\n    saved: __(\'Saved!\'),\r\n    saveChanges: __(\'Save changes\'),\r\n    revertTitle: __(\'Revert to last saved values\'),\r\n    revertChanges: __(\'Revert changes\'),\r\n    revertConfirmText: __(\'Restoring will revert to the last saved version and discard your current edits.\'),\r\n    revertBtn: __(\'Revert\'),\r\n    cancelBtn: __(\'Keep editing\'),\r\n}\r\n<\/script>\r\n\r\n<template>\r\n    <teleport to="body">\r\n        <div\r\n            v-if="confirmRevert"\r\n            class="trp-actions-overlay"\r\n        />\r\n    </teleport>\r\n\r\n    <div class="trp-settings-actions">\r\n        <button\r\n            class="trp-submit-btn"\r\n            :disabled="!isDirty || saving"\r\n            @click="save"\r\n        >\r\n            <template v-if="saving">\r\n                <span class="trp-save-spinner" />\r\n                <span>{{ T.saving }}</span>\r\n            </template>\r\n\r\n            <template v-else-if="justSaved">\r\n                <span>{{ T.saved }}</span>\r\n            </template>\r\n\r\n            <template v-else>\r\n                <span>{{ T.saveChanges }}</span>\r\n            </template>\r\n        </button>\r\n\r\n        <button\r\n            class="trp-button-secondary"\r\n            :disabled="!isDirty || saving"\r\n            :title="T.revertTitle"\r\n            @click="askRevert"\r\n        >\r\n            <svg\r\n                width="14" height="14"\r\n                viewBox="0 0 14 14"\r\n                fill="none"\r\n                xmlns="http://www.w3.org/2000/svg"\r\n                style="margin-right: 6px; vertical-align: middle;"\r\n            >\r\n                <path\r\n                    d="M7.1752 0.713867C10.7452 0.713867 13.3002 3.54187 13.3002 7.01387C13.3002 10.4859 10.7452 13.3139 7.1752 13.3139C4.9352 13.3139 2.9612 12.2009 1.7992 10.5209L3.6122 9.45687C4.3822 10.5069 5.6142 11.2139 7.0002 11.2139C9.3102 11.2139 11.2002 9.26087 11.2002 7.01387C11.2002 4.76687 9.3102 2.81387 7.0002 2.81387C5.6212 2.81387 4.3962 3.51387 3.6262 4.55687L4.9002 5.61387L0.700195 7.01387V2.11387L2.0232 3.21987C3.2062 1.70087 5.0752 0.713867 7.1752 0.713867Z"\r\n                    fill="#2271B1"\r\n                />\r\n            </svg>\r\n            {{ T.revertChanges }}\r\n        </button>\r\n\r\n        <span v-if="errorMsg" class="trp-save-ls-error">{{ errorMsg }}</span>\r\n    </div>\r\n\r\n    <teleport to="body">\r\n        <transition name="fade">\r\n            <div v-if="confirmRevert" class="trp-revert-confirm">\r\n                <p class="trp-revert-text trp-primary-text">\r\n                    {{ T.revertConfirmText }}\r\n                </p>\r\n\r\n                <div class="trp-revert-actions">\r\n                    <button class="trp-btn-revert trp-submit-btn" @click="doRevert">\r\n                        {{ T.revertBtn }}\r\n                    </button>\r\n                    <span class="trp-btn-cancel" @click="cancelRevert">\r\n                        {{ T.cancelBtn }}\r\n                    </span>\r\n                </div>\r\n            </div>\r\n        </transition>\r\n    </teleport>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-actions-overlay {\r\n    position: fixed;\r\n    inset: 0;\r\n    background:rgba(0,0,0,.35);\r\n    backdrop-filter:blur(2px);\r\n    z-index:1000\r\n}\r\n\r\n.trp-revert-confirm {\r\n    position: fixed;\r\n    z-index: 10001;\r\n    background: #FFFFFF;\r\n    border: 1px solid #e2e2e4;\r\n    border-radius: 8px;\r\n    max-width: 350px;\r\n    top: 50%;\r\n    left: 50%;\r\n    transform: translate(-50%, -50%);\r\n    padding: 15px;\r\n}\r\n\r\n.trp-revert-actions {\r\n    display: flex;\r\n    justify-content: center;\r\n    align-items: center;\r\n}\r\n\r\n.trp-revert-text {\r\n    text-align: center;\r\n}\r\n\r\n.trp-btn-revert {\r\n    margin-right: 10px;\r\n}\r\n\r\n.trp-btn-cancel {\r\n    cursor: pointer;\r\n}\r\n\r\n.trp-btn-cancel:hover {\r\n    opacity: 0.8;\r\n}\r\n\r\n.trp-settings-actions {\r\n    display: flex;\r\n    align-items: center;\r\n    gap: 12px;\r\n    margin-top: 24px;\r\n}\r\n\r\n.trp-button-secondary {\r\n    height: 40px;\r\n}\r\n\r\n.trp-button-secondary:hover svg path {\r\n    fill: white;\r\n}\r\n\r\n.trp-submit-btn {\r\n    display: flex;\r\n    align-items: center;\r\n    gap: 8px;\r\n}\r\n\r\n.trp-submit-btn:disabled, .trp-button-secondary:disabled {\r\n    opacity: 0.8;\r\n    pointer-events: none;\r\n}\r\n\r\n.trp-save-spinner {\r\n    width: 14px;\r\n    height: 14px;\r\n    display: inline-block;\r\n\r\n    border: 2px solid rgba(255, 255, 255, 0.3); /* outer ring (faded) */\r\n    border-top-color: #ffffff;                 /* spinning top highlight */\r\n    border-radius: 50%;\r\n    animation: spin 0.6s linear infinite;\r\n}\r\n\r\n@keyframes spin {\r\n    to { transform: rotate(360deg); }\r\n}\r\n\r\n.trp-save-ls-error {\r\n    color: #c00;\r\n    font-size: 13px;\r\n    margin-left: 12px;\r\n}\r\n</style>\r\n'],sourceRoot:""}]);const a=s},787:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,'.trp-toggle-wrapper[data-v-30d3f338]{align-items:center;display:flex}.trp-toggle-inner[data-v-30d3f338]{cursor:pointer;display:inline-block;height:19px;position:relative;width:36px}.trp-toggle-input[data-v-30d3f338]{height:0;opacity:0;position:absolute;width:0}.trp-toggle-slider[data-v-30d3f338]{border:1px solid #949494;border-radius:28px;cursor:pointer;display:inline-block;height:17px;position:relative;transition:background-color .3s ease;width:34px}.trp-toggle-slider[data-v-30d3f338]:before{background-color:#949494;border-radius:50%;content:"";height:13px;left:4px;position:absolute;top:2px;transition:transform .2s ease-in-out;width:13px}.trp-toggle-input:checked+.trp-toggle-slider[data-v-30d3f338]{background-color:var(--trp-settings-accent-color,#0073aa);border-color:var(--trp-settings-accent-color)}.trp-toggle-input:checked+.trp-toggle-slider[data-v-30d3f338]:before{background-color:#fff;transform:translateX(14px)}',"",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/ToggleField.vue"],names:[],mappings:"AA4BA,qCAEI,kBAAmB,CADnB,YAEJ,CAEA,mCAGI,cAAe,CADf,oBAAqB,CAGrB,WAAY,CAJZ,iBAAkB,CAGlB,UAEJ,CAEA,mCAII,QAAS,CAFT,SAAU,CADV,iBAAkB,CAElB,OAEJ,CAEA,oCAOI,wBAAyB,CAFzB,kBAAmB,CAGnB,cAAe,CAPf,oBAAqB,CAGrB,WAAY,CAFZ,iBAAkB,CAIlB,oCAAsC,CAHtC,UAMJ,CAEA,2CAOI,wBAAyB,CACzB,iBAAkB,CAPlB,UAAW,CAKX,WAAY,CAHZ,QAAS,CADT,iBAAkB,CAElB,OAAQ,CAKR,oCAAsC,CAJtC,UAKJ,CAEA,8DACI,yDAA2D,CAC3D,6CACJ,CAEA,qEAEI,qBAAuB,CADvB,0BAEJ",sourcesContent:['<script setup>\r\nconst props = defineProps({\r\n    modelValue: Boolean,\r\n    label: { type: String, default: \'\' }\r\n})\r\n\r\nconst emit = defineEmits([\'update:modelValue\'])\r\n<\/script>\r\n\r\n<template>\r\n    <div class="trp-toggle-wrapper">\r\n    <span v-if="label" class="trp-field__label trp-primary-text-bold">\r\n      {{ label }}\r\n    </span>\r\n\r\n        <div class="trp-toggle-inner" @click="emit(\'update:modelValue\', !modelValue)">\r\n            <input\r\n                type="checkbox"\r\n                class="trp-toggle-input"\r\n                :checked="modelValue"\r\n                readonly\r\n            />\r\n            <span class="trp-toggle-slider" />\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-toggle-wrapper {\r\n    display: flex;\r\n    align-items: center;\r\n}\r\n\r\n.trp-toggle-inner {\r\n    position: relative;\r\n    display: inline-block;\r\n    cursor: pointer;\r\n    width: 36px;\r\n    height: 19px;\r\n}\r\n\r\n.trp-toggle-input {\r\n    position: absolute;\r\n    opacity: 0;\r\n    width: 0;\r\n    height: 0;\r\n}\r\n\r\n.trp-toggle-slider {\r\n    display: inline-block;\r\n    position: relative;\r\n    width: 34px;\r\n    height: 17px;\r\n    border-radius: 28px;\r\n    transition: background-color 0.3s ease;\r\n    border: 1px solid #949494;\r\n    cursor: pointer;\r\n}\r\n\r\n.trp-toggle-slider::before {\r\n    content: \'\';\r\n    position: absolute;\r\n    left: 4px;\r\n    top: 2px;\r\n    width: 13px;\r\n    height: 13px;\r\n    background-color: #949494;\r\n    border-radius: 50%;\r\n    transition: transform 0.2s ease-in-out;\r\n}\r\n\r\n.trp-toggle-input:checked + .trp-toggle-slider {\r\n    background-color: var(--trp-settings-accent-color, #0073aa);\r\n    border-color: var(--trp-settings-accent-color);\r\n}\r\n\r\n.trp-toggle-input:checked + .trp-toggle-slider::before {\r\n    transform: translateX(14px);\r\n    background-color: white;\r\n}\r\n</style>\r\n'],sourceRoot:""}]);const a=s},793:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".cm-focused{outline:none!important}.cm-editor{border:1px solid var(--trp-settings-light-gray-border-color,#ccc);border-radius:8px}.cm-gutters{border-radius:8px 0 0 8px}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/fields/CustomCssAreaField.vue"],names:[],mappings:"AAqJA,YACI,sBACJ,CAEA,WACI,iEAAmE,CACnE,iBACJ,CAEA,YACI,yBACJ",sourcesContent:["<script setup>\r\nimport { ref, watch, onMounted, onBeforeUnmount, shallowRef } from 'vue'\r\nimport { Codemirror } from 'vue-codemirror'\r\nimport { css } from '@codemirror/lang-css'\r\n\r\nimport debounce from '../../composables/utils/debounce'\r\n\r\nconst props = defineProps({\r\n    label: { type: String, default: '' },\r\n    visible: { type: Boolean, default: false },\r\n    modelValue: { type: String, default: '' }\r\n})\r\nconst emit = defineEmits(['update:modelValue'])\r\n\r\nconst rawCss     = ref(props.modelValue)\r\nconst scopedCss  = ref('')\r\nconst extensions = [css()]\r\nconst view       = shallowRef(null)\r\n\r\nconst debouncedEmit = debounce( ( v) => {\r\n    const scoped = scopeCustomCss(v)\r\n    scopedCss.value = scoped\r\n    emit('update:modelValue', scoped)\r\n}, 300)\r\n\r\nwatch(() => props.modelValue, v => {\r\n    if (v !== scopedCss.value && v !== rawCss.value) {\r\n        rawCss.value = v\r\n    }\r\n})\r\n\r\nwatch(rawCss, v => debouncedEmit(v))\r\n\r\nwatch(scopedCss, v => {\r\n    if (styleEl) {\r\n        styleEl.textContent = v\r\n    }\r\n})\r\n\r\nconst handleReady = ({ view: v }) => (view.value = v)\r\n\r\n/* Live <style> injection only when visible === true */\r\nlet styleEl = null\r\n\r\nconst injectStyle = () => {\r\n    if (styleEl || !props.visible) return\r\n    styleEl = document.createElement('style')\r\n    styleEl.dataset.customCss = ''\r\n    styleEl.textContent = scopeCustomCss(rawCss.value)\r\n    document.head.appendChild(styleEl)\r\n}\r\n\r\nconst removeStyle = () => {\r\n    if (styleEl) {\r\n        styleEl.remove()\r\n        styleEl = null\r\n    }\r\n}\r\n\r\nconst scopeCustomCss = (css, scopeSelector = '.trp-language-switcher') => {\r\n    // Parse into a temporary stylesheet via the browser’s CSSOM\r\n    const styleEl = document.createElement('style');\r\n    styleEl.textContent = css;\r\n    document.head.appendChild(styleEl);\r\n    const sheet = styleEl.sheet;\r\n    document.head.removeChild(styleEl);\r\n\r\n    const output = [];\r\n\r\n    for (const rule of sheet.cssRules) {\r\n        // Root-level style rules\r\n        if (rule instanceof CSSStyleRule) {\r\n            const scoped = rule.selectorText\r\n                               .split(',')\r\n                               .map(sel => {\r\n                                   sel = sel.trim();\r\n                                   // If already scoped, leave it\r\n                                   if (sel.startsWith(scopeSelector))\r\n                                       return sel;\r\n\r\n                                   // Otherwise prefix\r\n                                   return `${scopeSelector} ${sel}`\r\n                               })\r\n                               .join(', ')\r\n            output.push(`${scoped} { ${rule.style.cssText} }`)\r\n        }\r\n\r\n        // @media blocks\r\n        else if (rule instanceof CSSMediaRule) {\r\n            const inner = [];\r\n            for (const child of rule.cssRules) {\r\n                if (child instanceof CSSStyleRule) {\r\n                    const scoped = child.selectorText\r\n                                        .split(',')\r\n                                        .map(sel => {\r\n                                            sel = sel.trim()\r\n                                            return sel.startsWith(scopeSelector)\r\n                                                ? sel\r\n                                                : `${scopeSelector} ${sel}`\r\n                                        })\r\n                                        .join(', ')\r\n                    inner.push(`${scoped} { ${child.style.cssText} }`)\r\n                } else {\r\n                    // e.g. nested @supports, @keyframes inside @media\r\n                    inner.push(child.cssText)\r\n                }\r\n            }\r\n            output.push(`@media ${rule.media.mediaText} {\\n${inner.join('\\n')}\\n}`)\r\n        }\r\n\r\n        // Everything else (import, keyframes, supports)\r\n        else\r\n            output.push(rule.cssText)\r\n    }\r\n\r\n    return output.join('\\n')\r\n}\r\n\r\n// Track visibility changes\r\nwatch(() => props.visible, (visible) => {\r\n    if (visible) injectStyle()\r\n    else removeStyle()\r\n})\r\n\r\nonMounted(() => {\r\n    if (props.visible) injectStyle()\r\n})\r\nonBeforeUnmount(removeStyle)\r\n<\/script>\r\n\r\n<template>\r\n    <div class=\"trp-custom-css-editor\" v-show=\"visible\">\r\n        <label v-if=\"label\" class=\"trp-field__label trp-primary-text-bold\">\r\n            {{ label }}\r\n        </label>\r\n\r\n        <Codemirror\r\n            v-model=\"rawCss\"\r\n            :placeholder=\"'Write custom CSS here...'\"\r\n            :style=\"{ height: '250px', width: '80%', fontSize: '14px', fontFamily: 'monospace' }\"\r\n            :indent-with-tab=\"true\"\r\n            :tab-size=\"2\"\r\n            :extensions=\"extensions\"\r\n            @ready=\"handleReady\"\r\n        />\r\n    </div>\r\n</template>\r\n\r\n<style >\r\n.cm-focused {\r\n    outline: none !important;\r\n}\r\n\r\n.cm-editor {\r\n    border: 1px solid var(--trp-settings-light-gray-border-color, #ccc);\r\n    border-radius: 8px;\r\n}\r\n\r\n.cm-gutters {\r\n    border-radius: 8px 0 0 8px;\r\n}\r\n</style>\r\n"],sourceRoot:""}]);const a=s},798:e=>{"use strict";e.exports=function(e){var t=[];return t.toString=function(){return this.map(function(t){var n=e(t);return t[2]?"@media ".concat(t[2]," {").concat(n,"}"):n}).join("")},t.i=function(e,n,r){"string"==typeof e&&(e=[[null,e,""]]);var i={};if(r)for(var o=0;o<this.length;o++){var s=this[o][0];null!=s&&(i[s]=!0)}for(var a=0;a<e.length;a++){var l=[].concat(e[a]);r&&i[l[0]]||(n&&(l[2]?l[2]="".concat(n," and ").concat(l[2]):l[2]=n),t.push(l))}},t}},846:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,".trp-language-item[data-v-fa610bac]{align-items:center;color:var(--text);cursor:pointer;display:flex;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif;font-size:var(--font-size,14px);gap:8px;line-height:1.2;min-height:19px;padding:5px 16px;width:100%}.trp-language-item__default[data-v-fa610bac]{pointer-events:none}.trp-language-item[data-v-fa610bac]:hover{background:var(--bg-hover);color:var(--text-hover)}.trp-flag-image[data-v-fa610bac]{aspect-ratio:var(--aspect-ratio,4/3);border-radius:var(--flag-radius,2px);height:auto;image-rendering:pixelated;width:var(--flag-size,18px)}.trp-language-item-name[data-v-fa610bac]{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}","",{version:3,sources:["webpack://./assets/src/language-switcher/components/LanguageItem.vue"],names:[],mappings:"AAmGA,oCAEI,kBAAmB,CAMnB,iBAAkB,CAElB,cAAe,CATf,YAAa,CAIb,mHAAwH,CACxH,+BAAiC,CAHjC,OAAQ,CAIR,eAAgB,CAEhB,eAAgB,CALhB,gBAAiB,CAOjB,UACJ,CAEA,6CACI,mBACJ,CAEA,0CACI,0BAA2B,CAC3B,uBACJ,CAEA,iCAII,oCAAsC,CAHtC,oCAAsC,CACtC,WAAY,CACZ,yBAA0B,CAE1B,2BACJ,CAEA,yCAEI,eAAgB,CAChB,sBAAuB,CAFvB,kBAGJ",sourcesContent:['<script setup>\r\nimport { inject, computed } from \'vue\'\r\n\r\nconst props = defineProps( {\r\n    language : {\r\n       type     : Object,\r\n       required : true\r\n    },\r\n    dropdown : {\r\n       type    : Boolean,\r\n       default : false\r\n    },\r\n    flagPos         : String, // Inserted via injectedSettings\r\n    nameMode        : String, // Inserted via injectedSettings\r\n    flagAspectRatio : String  // Inserted via injectedSettings\r\n})\r\n\r\n// Injected global layout settings (optional override)\r\nconst injectedSettings = inject( \'languageItemSettings\' )\r\n\r\nconst pluginUrl = window?.tpLangSwitcherData?.misc?.pluginUrl || \'\'\r\n\r\nconst finalFlagPos = computed( () =>\r\n    props.flagPos ?? injectedSettings?.value.flagPos ?? \'before\'\r\n)\r\n\r\nconst finalNameMode = computed( () =>\r\n    props.nameMode ?? injectedSettings?.value.nameMode ?? \'full\'\r\n)\r\n\r\nconst showFlag = computed( () => finalFlagPos.value !== \'hide\' )\r\nconst showName = computed( () => finalNameMode.value !== \'none\' )\r\n\r\nconst isFlagBefore = computed( () => finalFlagPos.value === \'before\' )\r\nconst isFlagAfter  = computed( () => finalFlagPos.value === \'after\' )\r\n\r\nconst ratioFolder = computed(() => {\r\n    const ratioSetting = props.flagAspectRatio ?? injectedSettings?.value.flagRatio?.value\r\n\r\n    return ratioSetting === \'square\' ? \'1x1\' : \'4x3\'\r\n})\r\n\r\nconst flagUrl = computed(() => {\r\n    if (!showFlag.value) return null\r\n\r\n    // custom flag has priority\r\n    if (props.language.flagPath) return props.language.flagPath\r\n\r\n    const rawLocale =\r\n              props.language.locale ??\r\n              props.language.code ??\r\n              props.language.slug ??\r\n              \'\'\r\n    const locale = String(rawLocale).trim()\r\n    if (!locale || !pluginUrl) return null\r\n\r\n    const file = locale.replace(/-/g, \'_\') + \'.svg\'\r\n    return `${pluginUrl}assets/flags/${ratioFolder.value}/${encodeURIComponent(file)}`\r\n})\r\n\r\nconst displayName = computed( () =>\r\n    finalNameMode.value === \'short\' ? props.language.shortName : props.language.name\r\n)\r\n<\/script>\r\n\r\n<template>\r\n    <a\r\n        class="trp-language-item"\r\n        :class="{ \'trp-dropdown-item\': dropdown }"\r\n    >\r\n        <template v-if="isFlagBefore && showFlag">\r\n            <img\r\n                v-if="flagUrl"\r\n                :src="flagUrl"\r\n                class="trp-flag-image"\r\n                aria-hidden="true"\r\n                loading="lazy"\r\n                decoding="async"\r\n            />\r\n        </template>\r\n\r\n        <span v-if="showName" class="trp-language-item-name">\r\n            {{ displayName }}\r\n        </span>\r\n\r\n        <template v-if="isFlagAfter && showFlag">\r\n            <img\r\n                v-if="flagUrl"\r\n                :src="flagUrl"\r\n                class="trp-flag-image"\r\n                aria-hidden="true"\r\n                loading="lazy"\r\n                decoding="async"\r\n            />\r\n        </template>\r\n    </a>\r\n</template>\r\n\r\n<style scoped>\r\n.trp-language-item {\r\n    display: flex;\r\n    align-items: center;\r\n    gap: 8px;\r\n    padding: 5px 16px;\r\n    font-family: -apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue",sans-serif;\r\n    font-size: var(--font-size, 14px);\r\n    line-height: 1.2;\r\n    color: var(--text);\r\n    min-height: 19px;\r\n    cursor: pointer;\r\n    width: 100%;\r\n}\r\n\r\n.trp-language-item__default {\r\n    pointer-events: none;\r\n}\r\n\r\n.trp-language-item:hover {\r\n    background: var(--bg-hover);\r\n    color: var(--text-hover);\r\n}\r\n\r\n.trp-flag-image {\r\n    border-radius: var(--flag-radius, 2px);\r\n    height: auto;\r\n    image-rendering: pixelated;\r\n    aspect-ratio: var(--aspect-ratio, 4/3);\r\n    width: var(--flag-size, 18px);\r\n}\r\n\r\n.trp-language-item-name {\r\n    white-space: nowrap;\r\n    overflow: hidden;\r\n    text-overflow: ellipsis;\r\n}\r\n</style>\r\n'],sourceRoot:""}]);const a=s},877:(e,t,n)=>{"use strict";n.d(t,{A:()=>a});var r=n(627),i=n.n(r),o=n(798),s=n.n(o)()(i());s.push([e.id,':root{--vc-picker-bg:#f8f8f8;--vc-body-bg:#fff;--vc-input-bg:#fff;--vc-input-text:#333;--vc-input-label:#969696;--vc-input-border:#dadada;--vc-chrome-toggle-btn-highlighted:#eee;--vc-ps-bg:#dcdcdc;--vc-ps-title-bg-gradient-start:#f0f0f0;--vc-ps-title-bg-gradient-end:#d4d4d4;--vc-ps-title-border:#b1b1b1;--vc-ps-title-color:#4d4d4d;--vc-ps-slider-border:#b3b3b3;--vc-ps-slider-border-bottom:#f0f0f0;--vs-ps-picker-border-dark:#555;--vs-ps-picker-border-white:#fff;--vc-ps-btn-gradient-start:#fff;--vc-ps-btn-gradient-end:#e6e6e6;--vc-ps-btn-border:#878787;--vc-ps-btn-shadow:#eaeaea;--vc-ps-btn-color:#000;--vc-ps-preview-border:#000;--vc-ps-label:#000;--vc-ps-input-border:#888;--vc-ps-input-shadow-dark:rgba(0,0,0,.1);--vc-ps-input-shadow-light:#ececec;--vc-sketch-input-label:#222;--vc-sketch-presets-border:#eee;--vc-twitter-input-bg:#fff;--vc-twitter-input-border:#f0f0f0;--vc-twitter-input-color:#666;--vc-twitter-hash-bg:#f0f0f0;--vc-twitter-hash-color:#98a1a4}:root.dark{--vc-body-bg:#424242;--vc-picker-bg:#d0d0d0;--vc-input-bg:#2c2c2c;--vc-input-text:#d0d0d0;--vc-input-label:#bbb;--vc-input-border:#555;--vc-chrome-toggle-btn-highlighted:#5c5c5c;--vc-sketch-input-label:#bbb;--vc-sketch-presets-border:#5a5a5a;--vc-twitter-input-border:#383838;--vc-twitter-input-color:#bbb;--vc-twitter-hash-bg:#383838;--vc-twitter-hash-color:#a0acaf;--vc-twitter-input-bg:#555;--vc-ps-bg:#424242;--vc-ps-title-bg-gradient-start:#4e4e4e;--vc-ps-title-bg-gradient-end:#3a3a3a;--vc-ps-title-border:#5a5a5a;--vc-ps-title-color:#bbb;--vc-ps-slider-border:#5c5c5c;--vc-ps-slider-border-bottom:#4a4a4a;--vs-ps-picker-border-dark:#b8b8b8;--vs-ps-picker-border-white:#bbb;--vc-ps-btn-gradient-start:#505050;--vc-ps-btn-gradient-end:#3a3a3a;--vc-ps-btn-border:#6a6a6a;--vc-ps-btn-shadow:#2a2a2a;--vc-ps-btn-color:#bbb;--vc-ps-preview-border:#3a3a3a;--vc-ps-label:#bbb;--vc-ps-input-border:#666;--vc-ps-input-shadow-dark:rgba(0,0,0,.45);--vc-ps-input-shadow-light:#2d2d2d}.bg[data-v-4d048d6e]{cursor:crosshair;inset:0;position:absolute;touch-action:none}.white[data-v-4d048d6e]{background:linear-gradient(90deg,#fff,#fff0)}.black[data-v-4d048d6e]{background:linear-gradient(0deg,#000,#0000)}.picker-wrap[data-v-4d048d6e]{cursor:pointer;outline:none;position:absolute}.picker[data-v-4d048d6e]{border-radius:50%;box-shadow:0 0 0 1.6px var(--vc-picker-bg),inset 0 0 1px 1px #0000004d,0 0 1px 2px #0006;cursor:move;height:4px;transform:translate(-2px,-2px);width:4px}.vc-base-slider[data-v-972b0fad]{height:100%;position:relative;touch-action:none;width:100%}.background[data-v-972b0fad],.slider[data-v-972b0fad]{inset:0;position:absolute}.background[data-v-972b0fad]{overflow:hidden}.slider[data-v-972b0fad]{cursor:pointer;z-index:2}.picker-wrap[data-v-972b0fad]{outline:none;position:absolute;z-index:2}.picker[data-v-972b0fad]{background:var(--vc-picker-bg);border-radius:1px;box-shadow:0 0 2px #0009;cursor:pointer;height:8px;margin-top:1px;transform:translate(-2px);width:4px}.vc-hue-slider[data-v-5367c985]{cursor:crosshair;touch-action:none}.gradient[data-v-5367c985]{background:var(--2f44f39d);border-radius:2px;height:100%;width:100%}.vc-checkerboard[data-v-37d61ccd]{background-size:contain;inset:0;position:absolute}.vc-alpha-slider[data-v-07dd346b] .vc-checkerboard{border-radius:2px}.gradient[data-v-07dd346b]{inset:0;position:absolute}.vc-editable-input[data-v-4a4df1fd]{position:relative}.vc-input-input[data-v-4a4df1fd]{border:0;outline:none;padding:0;width:100%}.vc-input-label[data-v-4a4df1fd]{text-transform:capitalize}.vc-chrome-picker[data-v-abf90852]{border-radius:2px;box-shadow:0 0 2px #0000004d,0 4px 8px #0000004d;box-sizing:initial;font-family:Menlo,Consolas,Courier New,monospace;width:225px}.controls[data-v-abf90852]{display:flex}.color-wrap[data-v-abf90852]{position:relative;width:36px}.active-color[data-v-abf90852]{border-radius:15px;height:30px;overflow:hidden;position:relative;width:30px;z-index:1}.color-wrap[data-v-abf90852] .vc-checkerboard{background-size:auto;border-radius:15px;height:30px;width:30px}.sliders[data-v-abf90852]{flex:1}.fieldsWrap[data-v-abf90852]{display:flex;padding-top:16px}.fields[data-v-abf90852]{display:flex;flex:1;margin-left:-6px}.field[data-v-abf90852]{padding-left:6px;width:100%}.toggle-btn[data-v-abf90852]{position:relative;text-align:right;width:32px}.toggle-icon[data-v-abf90852]{color:var(--vc-input-text);cursor:pointer;margin-right:-4px;margin-top:12px;position:relative;z-index:2}.toggle-icon_highlighted[data-v-abf90852]{background:var(--vc-chrome-toggle-btn-highlighted);border-radius:4px;height:28px;left:12px;position:absolute;top:10px;width:24px}.hue-wrap[data-v-abf90852]{margin-bottom:8px}.alpha-wrap[data-v-abf90852],.hue-wrap[data-v-abf90852]{height:10px;position:relative}.alpha-wrap[data-v-abf90852] .gradient,.hue-wrap[data-v-abf90852] .container{border-radius:2px}.alpha-wrap[data-v-abf90852] .picker,.hue-wrap[data-v-abf90852] .picker{border-radius:6px;box-shadow:0 1px 4px #0000005e;height:12px;transform:translate(-6px,-2px);width:12px}.body[data-v-abf90852]{background-color:var(--vc-body-bg);padding:16px 16px 12px}.saturation[data-v-abf90852]{border-radius:2px 2px 0 0;overflow:hidden;padding-bottom:55%;position:relative;width:100%}.saturation[data-v-abf90852] .picker{height:12px;transform:translate(-6px,-6px);width:12px}.fields[data-v-abf90852] .vc-input-input{background-color:var(--vc-input-bg);border:none;border-radius:2px;box-shadow:inset 0 0 0 1px var(--vc-input-border);color:var(--vc-input-text);font-size:11px;height:21px;text-align:center;width:100%}.fields[data-v-abf90852] .vc-input-label{color:var(--vc-input-label);display:block;font-size:11px;line-height:11px;margin-top:12px;text-align:center;text-transform:uppercase}.alpha-disabled[data-v-abf90852] .active-color{height:18px;width:18px}.alpha-disabled[data-v-abf90852] .color-wrap{width:30px}.alpha-disabled[data-v-abf90852] .hue-wrap{margin-bottom:4px;margin-top:4px}.vc-compact-picker[data-v-17eda10a]{background-color:var(--vc-body-bg);border-radius:2px;box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029;box-sizing:border-box;padding-left:5px;padding-top:5px;width:245px}.colors[data-v-17eda10a]{margin:0;overflow:hidden;padding:0}.color-item[data-v-17eda10a]{cursor:pointer;float:left;height:15px;list-style:none;margin-bottom:5px;margin-right:5px;position:relative;width:15px}.color-item_white[data-v-17eda10a]{box-shadow:inset 0 0 0 1px #ddd}.color-item_white .dot[data-v-17eda10a]{background:#000}.dot[data-v-17eda10a]{background:#fff;border-radius:50%;inset:5px;opacity:1;position:absolute}.vc-grayscale-picker[data-v-85f108e1]{background-color:var(--vc-body-bg);border-radius:2px;box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029;box-sizing:border-box;padding-left:5px;padding-top:5px;width:245px}.colors[data-v-85f108e1]{margin:0;overflow:hidden;padding:0}.color-item[data-v-85f108e1]{cursor:pointer;float:left;height:15px;list-style:none;margin-bottom:5px;margin-right:5px;position:relative;width:15px}.color-item_white[data-v-85f108e1]{box-shadow:inset 0 0 0 1px #ddd}.color-item_white .dot[data-v-85f108e1]{background:#000}.dot[data-v-85f108e1]{background:#fff;border-radius:50%;inset:5px;opacity:1;position:absolute}.vc-material-picker[data-v-4e39f856]{background-color:var(--vc-body-bg);border-radius:2px;box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Helvetica Neue,Arial,sans-serif;height:98px;padding:16px;position:relative;width:98px}.vc-material-picker[data-v-4e39f856] .vc-input-input{background-color:var(--vc-body-bg);color:var(--vc-input-text);font-size:15px;height:30px;margin-top:12px;width:100%}.vc-material-picker[data-v-4e39f856] .vc-input-label{color:var(--vc-input-label);font-size:11px;left:0;position:absolute;top:0}.hex[data-v-4e39f856]{border-bottom-style:solid;border-bottom-width:2px}.rgb[data-v-4e39f856]{display:flex;margin-right:-10px;padding-top:11px}.color[data-v-4e39f856]{flex:1;padding-right:10px}.vc-photoshop-picker[data-v-fe6db8eb]{background:var(--vc-ps-bg);border-radius:4px;box-shadow:0 0 0 1px #00000040,0 8px 16px #00000026;box-sizing:initial;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Helvetica Neue,Arial,sans-serif;width:513px}.fields_disabled[data-v-fe6db8eb]{width:390px}.title[data-v-fe6db8eb]{background-image:linear-gradient(-180deg,var(--vc-ps-title-bg-gradient-start) 0,var(--vc-ps-title-bg-gradient-end) 100%);border-bottom:1px solid var(--vc-ps-title-border);border-radius:4px 4px 0 0;box-shadow:inset 0 1px #fff3,inset 0 -1px #00000005;color:var(--vc-ps-title-color);font-size:13px;height:23px;line-height:24px;text-align:center}.body[data-v-fe6db8eb]{display:flex;padding:15px}.saturation[data-v-fe6db8eb]{border-bottom:2px solid var(--vc-ps-slider-border);border:2px solid var(--vc-ps-slider-border);border-bottom-color:var(--vc-ps-slider-border-bottom);height:256px;overflow:hidden;position:relative;width:256px}.saturation[data-v-fe6db8eb] .picker{height:12px;transform:translate(-6px,-6px);width:12px}.hue[data-v-fe6db8eb]{border-bottom:2px solid var(--vc-ps-slider-border);border:2px solid var(--vc-ps-slider-border);border-bottom-color:var(--vc-ps-slider-border-bottom);height:256px;margin-left:10px;width:19px}.hue-picker[data-v-fe6db8eb]{position:relative}.hue-picker-left[data-v-fe6db8eb],.hue-picker-right[data-v-fe6db8eb]{border-color:transparent transparent transparent var(--vs-ps-picker-border-dark);border-style:solid;border-width:5px 0 5px 8px;cursor:pointer;height:0;position:absolute;width:0}.hue-picker-left[data-v-fe6db8eb]:after,.hue-picker-right[data-v-fe6db8eb]:after{border-color:transparent transparent transparent var(--vs-ps-picker-border-white);border-style:solid;border-width:4px 0 4px 6px;content:"";height:0;left:1px;position:absolute;top:1px;transform:translate(-8px,-5px);width:0}.hue-picker-left[data-v-fe6db8eb]{transform:translate(-10px,-4px)}.hue-picker-right[data-v-fe6db8eb]{transform:translate(21px,-4px) rotate(180deg)}.controls[data-v-fe6db8eb]{display:flex;margin-left:10px;width:180px}.controls_fields_disabled[data-v-fe6db8eb]{width:auto}.actions[data-v-fe6db8eb]{flex:1;margin-left:20px}.action-btn[data-v-fe6db8eb]{background-image:linear-gradient(-180deg,var(--vc-ps-btn-gradient-start) 0,var(--vc-ps-btn-gradient-end) 100%);border:1px solid var(--vc-ps-btn-border);border-radius:2px;box-shadow:0 1px 0 0 var(--vc-ps-btn-shadow);color:var(--vc-ps-btn-color);cursor:pointer;font-size:14px;height:20px;line-height:20px;margin-bottom:10px;text-align:center}.preview[data-v-fe6db8eb]{width:60px}.preview-swatches[data-v-fe6db8eb]{border-bottom:1px solid var(--vc-ps-slider-border);border:1px solid var(--vc-ps-slider-border);border-bottom-color:var(--vc-ps-slider-border-bottom);margin-bottom:2px;margin-top:1px}.preview-color[data-v-fe6db8eb]{box-shadow:inset 1px 0 var(--vc-ps-preview-border),inset -1px 0 var(--vc-ps-preview-border),inset 0 1px var(--vc-ps-preview-border);height:34px}.preview-label[data-v-fe6db8eb]{color:var(--vc-ps-label);font-size:14px;text-align:center}.fields[data-v-fe6db8eb]{padding-bottom:9px;padding-top:5px;position:relative;width:80px}.fields[data-v-fe6db8eb] .vc-input-input{background-color:var(--vc-input-bg);border:1px solid var(--vc-ps-input-border);box-shadow:inset 0 1px 1px var(--vc-ps-input-shadow-dark),0 1px 0 0 var(--vc-ps-input-shadow-light);color:var(--vc-ps-label);font-size:13px;height:18px;margin-bottom:5px;margin-left:40%;margin-right:10px;padding-left:3px;width:40%}.fields[data-v-fe6db8eb] .vc-input-desc,.fields[data-v-fe6db8eb] .vc-input-label{color:var(--vc-ps-label);font-size:13px;height:18px;line-height:22px;position:absolute;text-transform:uppercase;top:0}.fields[data-v-fe6db8eb] .vc-input-label{left:0;width:34px}.fields[data-v-fe6db8eb] .vc-input-desc{right:0;width:0}.fields-divider[data-v-fe6db8eb]{height:5px}.hex[data-v-fe6db8eb] .vc-input-input{border:1px solid var(--vc-ps-input-border);box-shadow:inset 0 1px 1px var(--vc-ps-input-shadow-dark),0 1px 0 0 var(--vc-ps-input-shadow-light);font-size:13px;height:18px;margin-bottom:6px;margin-left:20%;padding-left:3px;width:80%}.hex[data-v-fe6db8eb] .vc-input-label{font-size:13px;height:18px;left:0;line-height:22px;position:absolute;text-transform:uppercase;top:0;width:14px}.vc-sketch-picker[data-v-4a59b29b]{background:var(--vc-body-bg);border-radius:4px;box-shadow:0 0 0 1px #00000026,0 8px 16px #00000026;box-sizing:initial;font-family:Menlo,Consolas,Courier New,monospace;padding:10px 10px 0;position:relative;width:200px}.saturation[data-v-4a59b29b]{overflow:hidden;padding-bottom:75%;position:relative;width:100%}.controls[data-v-4a59b29b]{display:flex}.sliders[data-v-4a59b29b]{flex:1;padding:4px 0}.alpha[data-v-4a59b29b] .gradient,.hue[data-v-4a59b29b] .container{border-radius:2px}.hue[data-v-4a59b29b]{height:10px;position:relative}.alpha[data-v-4a59b29b]{height:10px}.alpha[data-v-4a59b29b],.color[data-v-4a59b29b]{margin-top:4px;overflow:hidden;position:relative}.color[data-v-4a59b29b]{border-radius:2px;height:24px;margin-left:4px;width:24px}.active-color[data-v-4a59b29b]{box-shadow:inset 0 0 0 1px #00000026,inset 0 0 4px #00000040;inset:0;position:absolute;z-index:2}.color[data-v-4a59b29b] .vc-checkerboard{background-size:auto}.field[data-v-4a59b29b]{display:flex;padding-top:4px}.field[data-v-4a59b29b] .vc-input-input{background-color:var(--vc-input-bg);border:none;box-shadow:inset 0 0 0 1px var(--vc-input-border);color:var(--vc-input-text);font-size:10px;padding:4px 0 3px 10%;width:90%}.field[data-v-4a59b29b] .vc-input-label{color:var(--vc-sketch-input-label);display:block;font-size:11px;padding-bottom:4px;padding-top:3px;text-align:center}.field_single[data-v-4a59b29b]{flex:1;padding-left:6px}.field_double[data-v-4a59b29b]{flex:2}.presets[data-v-4a59b29b]{border-top:1px solid var(--vc-sketch-presets-border);margin-left:-10px;margin-right:-10px;padding-left:10px;padding-top:10px}.preset-color[data-v-4a59b29b]{cursor:pointer;display:inline-block;height:16px;margin:0 10px 10px 0;overflow:hidden;position:relative;vertical-align:top;width:16px}.preset-color[data-v-4a59b29b],.preset-color[data-v-4a59b29b] .vc-checkerboard{border-radius:3px;box-shadow:inset 0 0 0 1px #00000026}.alpha-disabled .color[data-v-4a59b29b]{height:10px}.vc-slider-picker[data-v-675d6988]{position:relative;width:410px}.hue[data-v-675d6988]{height:12px;position:relative}.alpha[data-v-675d6988] .picker,.hue[data-v-675d6988] .picker{border-radius:6px;box-shadow:0 1px 4px #0000005e;height:14px;transform:translate(-7px,-2px);width:14px}.alpha[data-v-675d6988]{height:12px;margin-top:20px;position:relative}.swatches[data-v-675d6988]{display:flex;margin-top:20px}.swatch[data-v-675d6988]{flex:1;margin-right:1px;width:20%}.swatch[data-v-675d6988]:first-child{margin-right:1px}.swatch:first-child .picker[data-v-675d6988]{border-radius:2px 0 0 2px}.swatch[data-v-675d6988]:last-child{margin-right:0}.swatch:last-child .picker[data-v-675d6988]{border-radius:0 2px 2px 0}.picker[data-v-675d6988]{cursor:pointer;height:12px}.swatch:nth-child(n) .picker_active[data-v-675d6988]{border-radius:3.6px/2px;transform:scaleY(1.8)}.picker_white[data-v-675d6988]{box-shadow:inset 0 0 0 1px #ddd}.picker_active.picker_white[data-v-675d6988]{box-shadow:inset 0 0 0 .6px #ddd}.vc-swatches-picker[data-v-3427cb2a]{background-color:var(--vc-body-bg);box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029;height:240px;overflow-y:scroll;width:320px}.box[data-v-3427cb2a]{overflow:hidden;padding:16px 0 6px 16px}.colorGroup[data-v-3427cb2a]{float:left;margin-right:10px;padding-bottom:10px;width:40px}.color[data-v-3427cb2a]{border-radius:2px 2px 0 0;box-sizing:border-box;cursor:pointer;height:24px;margin-bottom:1px;overflow:hidden;width:40px}.color_white[data-v-3427cb2a]{border:1px solid #ddd}.picker[data-v-3427cb2a]{fill:#fff;display:block;margin-left:8px}.color_white .picker[data-v-3427cb2a]{fill:#333}.vc-twitter-picker[data-v-4652e193]{background:var(--vc-body-bg);border:0 solid rgba(0,0,0,.25);border-radius:4px;box-shadow:0 1px 4px #00000040;position:relative}.triangle[data-v-4652e193]{border-color:transparent transparent var(--vc-body-bg) transparent;border-style:solid;border-width:0 9px 10px;height:0;position:absolute;width:0}.triangle_shadow[data-v-4652e193]{border-color:transparent transparent rgba(0,0,0,.1);border-style:solid;border-width:0 9px 10px;height:0;position:absolute;width:0}.body[data-v-4652e193]{padding:15px 9px 9px 15px}.vc-twitter-picker[data-v-4652e193] .vc-editable-input{position:relative}.vc-twitter-picker[data-v-4652e193] .vc-input-input{background-color:var(--vc-twitter-input-bg);border:0;border-radius:0 4px 4px 0;box-shadow:inset 0 0 0 1px var(--vc-twitter-input-border);box-sizing:content-box;color:var(--vc-twitter-input-color);float:left;font-size:14px;height:28px;outline:none;padding:1px 1px 1px 8px;width:100px}.vc-twitter-picker[data-v-4652e193] .vc-editable-input span{display:none}.hash[data-v-4652e193]{align-items:center;background:var(--vc-twitter-hash-bg);border-radius:4px 0 0 4px;color:var(--vc-twitter-hash-color);display:flex;float:left;height:30px;justify-content:center;width:30px}.swatch[data-v-4652e193]{border-radius:4px;cursor:pointer;float:left;height:30px;margin:0 6px 6px 0;outline:none;position:relative;width:30px}.clear[data-v-4652e193]{clear:both}.tri_hide .triangle[data-v-4652e193],.tri_hide .triangle_shadow[data-v-4652e193]{display:none}.tri_top_left .triangle[data-v-4652e193]{left:12px;top:-10px}.tri_top_left .triangle_shadow[data-v-4652e193]{left:12px;top:-11px}.tri_top_right .triangle[data-v-4652e193]{right:12px;top:-10px}.tri_top_right .triangle_shadow[data-v-4652e193]{right:12px;top:-11px}.vc-hue-wrap[data-v-b3ac1ab2]{height:8px}.vc-hue-wrap[data-v-b3ac1ab2] .slider{border-radius:4px}.vc-hue-wrap[data-v-b3ac1ab2] .picker{background-color:var(--46ac36b6);border:2px solid #fff;border-radius:50%;box-shadow:none;height:20px;margin:0;transform:translate(-12px) translateY(-8px);width:20px}.vc-hsl-sliders[data-v-2e071f54]{font-family:Menlo,Consolas,Courier New,monospace;position:relative;width:100%}.slider-wrap[data-v-2e071f54]{display:flex;gap:12px;height:24px;margin-bottom:10px}.slider-wrap[data-v-2e071f54]:last-of-type{margin-bottom:0}.label[data-v-2e071f54]{color:var(--vc-input-text);display:block;font-size:12px;height:24px;line-height:24px;text-align:center;text-transform:uppercase}.vc-hsl-sliders[data-v-2e071f54] .vc-base-slider{height:14px;margin-top:5px}.vc-hsl-sliders[data-v-2e071f54] .background{border:1px solid var(--vc-input-border);border-radius:4px}.gradient[data-v-2e071f54]{height:100%;width:100%}.vc-hsl-sliders[data-v-2e071f54] .picker{border:2px solid #fff;border-radius:50%;box-shadow:none;height:20px;margin:0;transform:translate(-12px) translateY(-5px);width:20px}.h-slider[data-v-2e071f54] .picker{background-color:var(--41b5b6d0)}.l-slider[data-v-2e071f54] .picker,.s-slider[data-v-2e071f54] .picker{background-color:var(--05fbe691)}.vc-hsl-sliders[data-v-2e071f54] .vc-editable-input{border-bottom:1px solid var(--vc-input-border)}.vc-hsl-sliders[data-v-2e071f54] .vc-input-input{background:none;color:var(--vc-input-text);font-size:12px;text-align:center;width:50px}.vc-hsv-sliders[data-v-d6cfe1d9]{font-family:Menlo,Consolas,Courier New,monospace;position:relative;width:100%}.slider-wrap[data-v-d6cfe1d9]{display:flex;gap:12px;height:24px;margin-bottom:10px}.slider-wrap[data-v-d6cfe1d9]:last-of-type{margin-bottom:0}.label[data-v-d6cfe1d9]{color:var(--vc-input-text);display:block;font-size:12px;height:24px;line-height:24px;text-align:center;text-transform:uppercase}.vc-hsv-sliders[data-v-d6cfe1d9] .vc-base-slider{height:14px;margin-top:5px}.vc-hsv-sliders[data-v-d6cfe1d9] .background{border:1px solid var(--vc-input-border);border-radius:4px}.gradient[data-v-d6cfe1d9]{height:100%;width:100%}.vc-hsv-sliders[data-v-d6cfe1d9] .picker{border:2px solid #fff;border-radius:50%;box-shadow:none;height:20px;margin:0;transform:translate(-12px) translateY(-5px);width:20px}.h-slider[data-v-d6cfe1d9] .picker{background-color:var(--f666f450)}.b-slider[data-v-d6cfe1d9] .picker,.s-slider[data-v-d6cfe1d9] .picker{background-color:var(--46b90cce)}.vc-hsv-sliders[data-v-d6cfe1d9] .vc-editable-input{border-bottom:1px solid var(--vc-input-border)}.vc-hsv-sliders[data-v-d6cfe1d9] .vc-input-input{background:none;color:var(--vc-input-text);font-size:12px;text-align:center;width:50px}.vc-rgb-sliders[data-v-98b3b212]{font-family:Menlo,Consolas,Courier New,monospace;position:relative;width:100%}.slider-wrap[data-v-98b3b212]{display:flex;gap:12px;height:24px;margin-bottom:10px}.slider-wrap[data-v-98b3b212]:last-of-type{margin-bottom:0}.label[data-v-98b3b212]{color:var(--vc-input-text);display:block;font-size:12px;height:24px;line-height:24px;text-align:center;text-transform:uppercase}.vc-rgb-sliders[data-v-98b3b212] .vc-base-slider{height:14px;margin-top:5px}.vc-rgb-sliders[data-v-98b3b212] .background{border:1px solid var(--vc-input-border);border-radius:4px}.gradient[data-v-98b3b212]{height:100%;width:100%}.vc-rgb-sliders[data-v-98b3b212] .picker{border:2px solid #fff;border-radius:50%;box-shadow:none;height:20px;margin:0;transform:translate(-12px) translateY(-5px);width:20px}.slider-wrap[data-v-98b3b212]:not(.a-slider) .picker{background-color:var(--5f730604)}.vc-rgb-sliders[data-v-98b3b212] .vc-editable-input{border-bottom:1px solid var(--vc-input-border)}.vc-rgb-sliders[data-v-98b3b212] .vc-input-input{background:none;color:var(--vc-input-text);font-size:12px;text-align:center;width:50px}',"",{version:3,sources:["webpack://./node_modules/vue-color/dist/vue-color.css"],names:[],mappings:"AAAA,MAAM,sBAAuB,CAAC,iBAAkB,CAAC,kBAAmB,CAAC,oBAAqB,CAAC,wBAAyB,CAAC,yBAA0B,CAAC,uCAAwC,CAAC,kBAAmB,CAAC,uCAAwC,CAAC,qCAAsC,CAAC,4BAA6B,CAAC,2BAA4B,CAAC,6BAA8B,CAAC,oCAAqC,CAAC,+BAAgC,CAAC,gCAAiC,CAAC,+BAAgC,CAAC,gCAAiC,CAAC,0BAA2B,CAAC,0BAA2B,CAAC,sBAAuB,CAAC,2BAA4B,CAAC,kBAAmB,CAAC,yBAA0B,CAAC,wCAAyC,CAAC,kCAAmC,CAAC,4BAA6B,CAAC,+BAAgC,CAAC,0BAA2B,CAAC,iCAAkC,CAAC,6BAA8B,CAAC,4BAA6B,CAAC,+BAAgC,CAAC,WAAW,oBAAqB,CAAC,sBAAuB,CAAC,qBAAsB,CAAC,uBAAwB,CAAC,qBAAyB,CAAC,sBAA0B,CAAC,0CAA2C,CAAC,4BAAgC,CAAC,kCAAmC,CAAC,iCAAkC,CAAC,6BAAiC,CAAC,4BAA6B,CAAC,+BAAgC,CAAC,0BAA2B,CAAC,kBAAmB,CAAC,uCAAwC,CAAC,qCAAsC,CAAC,4BAA6B,CAAC,wBAA4B,CAAC,6BAA8B,CAAC,oCAAqC,CAAC,kCAAmC,CAAC,gCAAoC,CAAC,kCAAmC,CAAC,gCAAiC,CAAC,0BAA2B,CAAC,0BAA2B,CAAC,sBAA0B,CAAC,8BAA+B,CAAC,kBAAsB,CAAC,yBAA6B,CAAC,yCAA6C,CAAC,kCAAmC,CAAC,qBAAqB,gBAAgB,CAAmB,OAAO,CAAzB,iBAAiB,CAAS,iBAAiB,CAAC,wBAAwB,4CAA+C,CAAC,wBAAwB,2CAA6C,CAAC,8BAA8B,cAAc,CAAmB,YAAW,CAA7B,iBAA8B,CAAC,yBAAmJ,iBAAiB,CAA1G,wFAAwF,CAAzH,WAAW,CAAW,UAAU,CAA4G,8BAA6B,CAA7J,SAA8J,CAAC,iCAA8D,WAAW,CAAxC,iBAAiB,CAAwB,iBAAgB,CAAvC,UAAwC,CAAC,sDAAwE,OAAM,CAAxB,iBAAyB,CAAC,6BAA6B,eAAe,CAAC,yBAAyB,cAAc,CAAC,SAAS,CAAC,8BAA0D,YAAW,CAAvC,iBAAiB,CAAC,SAAsB,CAAC,yBAAwG,8BAA8B,CAAzE,iBAAiB,CAAC,wBAAwB,CAAgC,cAAc,CAAlH,UAAU,CAAC,cAAc,CAA0F,yBAAwB,CAArJ,SAAsJ,CAAC,gCAAgC,gBAAgB,CAAC,iBAAiB,CAAC,2BAAoE,0BAAyB,CAA3C,iBAAiB,CAA7B,WAAW,CAAtB,UAAmE,CAAC,kCAA4D,uBAAsB,CAA9B,OAAO,CAAzB,iBAAiD,CAAC,mDAAmD,iBAAiB,CAAC,2BAA6C,OAAM,CAAxB,iBAAyB,CAAC,oCAAoC,iBAAiB,CAAC,iCAAsD,QAAQ,CAAC,YAAW,CAA9B,SAAS,CAApB,UAA0C,CAAC,iCAAiC,yBAAyB,CAAC,mCAAkE,iBAAiB,CAAC,gDAAgD,CAArF,kBAAkB,CAAoE,gDAA+C,CAAjJ,WAAkJ,CAAC,2BAA2B,YAAY,CAAC,6BAA6B,iBAAiB,CAAC,UAAU,CAAC,+BAAwE,kBAAkB,CAA9B,WAAW,CAAoB,eAAe,CAA3E,iBAAiB,CAAC,UAAU,CAAgD,SAAS,CAAC,8CAAwF,oBAAmB,CAAtC,kBAAkB,CAA9B,WAAW,CAAtB,UAA8D,CAAC,0BAA0B,MAAM,CAAC,6BAA6B,YAAY,CAAC,gBAAgB,CAAC,yBAAyB,YAAY,CAAkB,MAAK,CAAtB,gBAAuB,CAAC,wBAAwB,gBAAgB,CAAC,UAAU,CAAC,6BAAyD,iBAAgB,CAAjC,gBAAgB,CAA3B,UAA6C,CAAC,8BAA2G,0BAAyB,CAAlD,cAAc,CAAhD,iBAAiB,CAAC,eAAe,CAAnD,iBAAiB,CAAkD,SAAoC,CAAC,0CAAsG,kDAAkD,CAAC,iBAAgB,CAAlG,WAAW,CAAU,SAAS,CAA3D,iBAAiB,CAAwB,QAAQ,CAA/B,UAA8G,CAAC,2BAAyD,iBAAiB,CAAC,wDAA9B,WAAW,CAA7B,iBAA0G,CAAC,6EAA6E,iBAAiB,CAAC,wEAA+F,iBAAiB,CAAgC,8BAA6B,CAA1F,WAAW,CAAmB,8BAA8B,CAAvE,UAAsG,CAAC,uBAA8C,kCAAiC,CAAxD,sBAAyD,CAAC,6BAA6E,yBAAyB,CAAC,eAAc,CAA7E,kBAAkB,CAAC,iBAAiB,CAA/C,UAAyF,CAAC,qCAAgD,WAAW,CAAC,8BAA6B,CAApD,UAAqD,CAAC,yCAAgJ,mCAAmC,CAAjG,WAAW,CAA7B,iBAAiB,CAAa,iDAAiD,CAAqC,0BAA0B,CAAC,cAAc,CAAzK,WAAW,CAA+J,iBAAgB,CAArM,UAAsM,CAAC,yCAAsF,2BAA2B,CAAxE,aAAa,CAAiB,cAAc,CAA6B,gBAAgB,CAA3E,eAAe,CAAsF,iBAAgB,CAAzC,wBAA0C,CAAC,+CAA0D,WAAU,CAArB,UAAsB,CAAC,6CAA6C,UAAU,CAAC,2CAA0D,iBAAgB,CAA/B,cAAgC,CAAC,oCAA6K,kCAAiC,CAA7H,iBAAiB,CAAuB,mDAAmD,CAAzE,qBAAqB,CAAxD,gBAAgB,CAAhC,eAAe,CAA3B,WAA2K,CAAC,yBAAmD,QAAO,CAAjC,eAAe,CAAC,SAAkB,CAAC,6BAAoI,cAAa,CAA7E,UAAU,CAAtB,WAAW,CAAtC,eAAe,CAAoD,iBAAiB,CAAlC,gBAAgB,CAAmB,iBAAiB,CAAtF,UAAqG,CAAC,mCAAmC,+BAA+B,CAAC,wCAAwC,eAAe,CAAC,sBAA8E,eAAc,CAA1C,iBAAiB,CAA3B,SAAS,CAAmB,SAAS,CAAvD,iBAAuE,CAAC,sCAA+K,kCAAiC,CAA7H,iBAAiB,CAAuB,mDAAmD,CAAzE,qBAAqB,CAApE,gBAAgB,CAAhC,eAAe,CAAkB,WAA0I,CAAC,yBAAmD,QAAO,CAAjC,eAAe,CAAC,SAAkB,CAAC,6BAAoI,cAAa,CAA7E,UAAU,CAAtB,WAAW,CAAtC,eAAe,CAAoD,iBAAiB,CAAlC,gBAAgB,CAAmB,iBAAiB,CAAtF,UAAqG,CAAC,mCAAmC,+BAA+B,CAAC,wCAAwC,eAAe,CAAC,sBAA8E,eAAc,CAA1C,iBAAiB,CAA3B,SAAS,CAAmB,SAAS,CAAvD,iBAAuE,CAAC,qCAAiK,kCAAkC,CAAxG,iBAAiB,CAAC,mDAAmD,CAAoC,qFAAoF,CAAtN,WAAW,CAAC,YAAY,CAArD,iBAAiB,CAAC,UAAkO,CAAC,qDAA4F,kCAAkC,CAAC,0BAA0B,CAAC,cAAa,CAAvG,WAAW,CAAC,eAAe,CAAtC,UAAmH,CAAC,qDAAmG,2BAA0B,CAAzC,cAAc,CAArB,MAAM,CAA9B,iBAAiB,CAAC,KAAuD,CAAC,sBAA8C,yBAAwB,CAAhD,uBAAiD,CAAC,sBAAsB,YAAY,CAAC,kBAAkB,CAAC,gBAAgB,CAAC,wBAAwB,MAAM,CAAC,kBAAkB,CAAC,sCAAkD,0BAA0B,CAAC,iBAAiB,CAAC,mDAAmD,CAAC,kBAAkB,CAAC,qFAAoF,CAApN,WAAqN,CAAC,kCAAkC,WAAW,CAAC,wBAAoC,wHAAyH,CAAC,iDAAiD,CAAC,yBAAyB,CAAC,mDAAmD,CAAC,8BAA8B,CAAC,cAAc,CAAnT,WAAW,CAAyS,gBAAgB,CAAC,iBAAiB,CAAC,uBAAoC,YAAW,CAAxB,YAAyB,CAAC,6BAAwE,kDAA2C,CAAC,2CAAyD,CAAzD,qDAAyD,CAApI,YAAY,CAAyH,eAAc,CAAtI,iBAAiB,CAA1C,WAAgK,CAAC,qCAAgD,WAAW,CAAC,8BAA6B,CAApD,UAAqD,CAAC,sBAA+D,kDAA2C,CAAC,2CAAwD,CAAxD,qDAAwD,CAA7I,YAAY,CAAY,gBAAgB,CAA3B,UAAiI,CAAC,6BAA6B,iBAAiB,CAAC,qEAAsJ,gFAAgF,CAA9H,kBAAkB,CAAC,0BAA0B,CAAkF,cAAa,CAArJ,QAAQ,CAAlC,iBAAiB,CAAC,OAA8J,CAAC,iFAA2J,iFAAiF,CAA/H,kBAAkB,CAAC,0BAA0B,CAAzE,UAAU,CAAS,QAAQ,CAA2J,QAAQ,CAAlC,iBAAiB,CAAC,OAAO,CAAU,8BAA6B,CAAjN,OAAkN,CAAC,kCAAkC,+BAA+B,CAAC,mCAAmC,6CAA6C,CAAC,2BAAwD,YAAW,CAA5B,gBAAgB,CAA5B,WAAyC,CAAC,2CAA2C,UAAU,CAAC,0BAA2C,MAAK,CAAtB,gBAAuB,CAAC,6BAA4D,8GAA+G,CAAC,wCAAwC,CAAC,iBAAiB,CAAC,4CAA4C,CAAgB,4BAA4B,CAA3C,cAAc,CAA8B,cAAc,CAAjT,WAAW,CAAuS,gBAAgB,CAAtT,kBAAkB,CAAqS,iBAAiB,CAAC,0BAA0B,UAAU,CAAC,mCAAmC,kDAA2C,CAAC,2CAAyD,CAAzD,qDAAyD,CAAC,iBAAiB,CAAC,cAAc,CAAC,gCAA4C,mIAAkI,CAA9I,WAA+I,CAAC,gCAAgC,wBAAwB,CAAC,cAAc,CAAC,iBAAiB,CAAC,yBAAyC,kBAAkB,CAAlC,eAAe,CAA+B,iBAAgB,CAA3B,UAA4B,CAAC,yCAAmR,mCAAmC,CAAlL,0CAA0C,CAAC,mGAAmG,CAAqC,wBAAwB,CAAC,cAAa,CAA1S,WAAW,CAAmC,iBAAiB,CAAnD,eAAe,CAAC,iBAAiB,CAAmB,gBAAgB,CAA1F,SAAqT,CAAC,iFAAqH,wBAAwB,CAAC,cAAc,CAAnD,WAAW,CAAyC,gBAAgB,CAA5F,iBAAiB,CAA4E,wBAAuB,CAAlG,KAAmG,CAAC,yCAAyC,MAAM,CAAC,UAAU,CAAC,wCAAwC,OAAO,CAAC,OAAO,CAAC,iCAAiC,UAAU,CAAC,sCAA+G,0CAA0C,CAAC,mGAAmG,CAAC,cAAa,CAA3N,WAAW,CAAiB,iBAAiB,CAAjC,eAAe,CAAmB,gBAAgB,CAAxE,SAAsO,CAAC,sCAAyG,cAAc,CAAC,WAAW,CAArE,MAAM,CAAgE,gBAAe,CAA7G,iBAAiB,CAAyB,wBAAwB,CAAhD,KAAK,CAAQ,UAA+E,CAAC,mCAAwG,4BAA4B,CAAC,iBAAiB,CAAC,mDAAmD,CAArH,kBAAkB,CAAoG,gDAA+C,CAAzL,mBAAmB,CAAjD,iBAAiB,CAAC,WAAsM,CAAC,6BAA6E,eAAc,CAAnD,kBAAkB,CAAC,iBAAiB,CAA/C,UAA+D,CAAC,2BAA2B,YAAY,CAAC,0BAAwC,MAAK,CAAnB,aAAoB,CAAC,mEAAmE,iBAAiB,CAAC,sBAAwC,WAAU,CAA5B,iBAA6B,CAAC,wBAA0C,WAA0C,CAAC,gDAA/B,cAAc,CAAC,eAAc,CAA3D,iBAA8L,CAAjI,wBAAgG,iBAAiB,CAA9E,WAAW,CAAkC,eAAe,CAAvE,UAAyG,CAAC,+BAAyD,4DAA4D,CAApE,OAAO,CAAzB,iBAAiB,CAAsE,SAAS,CAAC,yCAAyC,oBAAoB,CAAC,wBAAwB,YAAY,CAAC,eAAe,CAAC,wCAAsI,mCAAmC,CAAjG,WAAW,CAAC,iDAAiD,CAAqC,0BAA0B,CAAC,cAAa,CAAhK,qBAAqB,CAA/B,SAA2K,CAAC,wCAAyF,kCAAkC,CAAnF,aAAa,CAAuE,cAAc,CAApE,kBAAkB,CAAlC,eAAe,CAAsE,iBAAiB,CAAC,+BAA+B,MAAM,CAAC,gBAAgB,CAAC,+BAA+B,MAAM,CAAC,0BAAkG,oDAAmD,CAAxG,iBAAiB,CAApC,kBAAkB,CAAmB,iBAAiB,CAAC,gBAAqE,CAAC,+BAAgJ,cAAc,CAA3E,oBAAoB,CAAmE,WAAW,CAA7E,oBAAoB,CAA3E,eAAe,CAAC,iBAAiB,CAA2C,kBAAkB,CAAgB,UAA2D,CAAC,+EAA5L,iBAAiB,CAAsI,oCAA2I,CAAC,wCAAwC,WAAW,CAAC,mCAAmC,iBAAiB,CAAC,WAAW,CAAC,sBAAsB,WAAW,CAAC,iBAAiB,CAAC,8DAAqF,iBAAiB,CAAC,8BAA8B,CAA5D,WAAW,CAAkD,8BAA6B,CAArG,UAAsG,CAAC,wBAAwB,WAAW,CAAmB,eAAc,CAAhC,iBAAiC,CAAC,2BAA2B,YAAY,CAAC,eAAe,CAAC,yBAA0C,MAAM,CAAvB,gBAAgB,CAAQ,SAAS,CAAC,qCAAqC,gBAAgB,CAAC,6CAA6C,yBAAyB,CAAC,oCAAoC,cAAc,CAAC,4CAA4C,yBAAyB,CAAC,yBAAyB,cAAc,CAAC,WAAW,CAAC,qDAA2E,uBAAsB,CAA5C,qBAA6C,CAAC,+BAA+B,+BAA+B,CAAC,6CAA6C,gCAAgC,CAAC,qCAAgF,kCAAkC,CAAC,mDAAkD,CAApH,YAAY,CAAC,iBAAiB,CAA1C,WAAiI,CAAC,sBAA8C,eAAc,CAAtC,uBAAuC,CAAC,6BAA4D,UAAU,CAAC,iBAAgB,CAA1D,mBAAmB,CAAC,UAAuC,CAAC,wBAAkP,yBAAwB,CAAlP,qBAAqB,CAA0C,cAAc,CAA5C,WAAW,CAAC,iBAAiB,CAAgB,eAAe,CAAvE,UAA6N,CAAC,8BAA8B,qBAAqB,CAAC,yBAAuC,SAAS,CAAvB,aAAa,CAAW,eAAe,CAAC,sCAAsC,SAAS,CAAC,oCAAsD,4BAA4B,CAAC,8BAA8B,CAAgC,iBAAgB,CAA/C,8BAA8B,CAA5G,iBAA8H,CAAC,2BAAiH,kEAAiE,CAAhH,kBAAkB,CAAC,uBAA2B,CAAzD,QAAU,CAAtC,iBAAiB,CAAC,OAAsI,CAAC,kCAAsG,mDAA+D,CAA/D,kBAA+D,CAA/D,uBAA+D,CAAzH,QAAU,CAAgH,iBAAgB,CAApJ,OAAqJ,CAAC,uBAAuB,yBAAyB,CAAC,uDAAuD,iBAAiB,CAAC,oDAAkP,2CAA2C,CAAhF,QAAU,CAAC,yBAAyB,CAArH,yDAAyD,CAAC,sBAAsB,CAAkF,mCAAmC,CAA7Q,UAAU,CAAoQ,cAAa,CAApQ,WAAW,CAAyB,YAAY,CAApC,uBAAuB,CAA/C,WAAiR,CAAC,4DAA4D,YAAY,CAAC,uBAA+C,kBAAkB,CAAyE,oCAAoC,CAA9D,yBAAyB,CAAsC,kCAAiC,CAA9K,YAAY,CAAvB,UAAU,CAAwD,WAAW,CAAlC,sBAAsB,CAAa,UAA4G,CAAC,yBAA2D,iBAAiB,CAAoB,cAAc,CAA9D,UAAU,CAAtB,WAAW,CAA8B,kBAAkB,CAAkC,YAAW,CAA7B,iBAAiB,CAAvG,UAAoH,CAAC,wBAAwB,UAAU,CAAC,iFAAiF,YAAY,CAAC,yCAAmD,SAAQ,CAAlB,SAAmB,CAAC,gDAA0D,SAAQ,CAAlB,SAAmB,CAAC,0CAAoD,UAAS,CAAnB,SAAoB,CAAC,iDAA2D,UAAS,CAAnB,SAAoB,CAAC,8BAA8B,UAAU,CAAC,sCAAsC,iBAAiB,CAAC,sCAA+H,gCAAgC,CAAvD,qBAAsB,CAAxD,iBAAiB,CAAC,eAAe,CAAtD,WAAW,CAAC,QAAQ,CAA2F,2CAA0C,CAApK,UAAqK,CAAC,iCAA8D,gDAA+C,CAA5E,iBAAiB,CAAC,UAA2D,CAAC,8BAA8B,YAAY,CAAC,QAAQ,CAAC,WAAW,CAAC,kBAAkB,CAAC,2CAA2C,eAAe,CAAC,wBAAkD,0BAA0B,CAApD,aAAa,CAAwC,cAAc,CAArD,WAAW,CAA2C,gBAAgB,CAA0B,iBAAgB,CAAzC,wBAA0C,CAAC,iDAAgE,WAAU,CAAzB,cAA0B,CAAC,6CAA+D,uCAAsC,CAAxD,iBAAyD,CAAC,2BAAsC,WAAU,CAArB,UAAsB,CAAC,yCAA2G,qBAAsB,CAAxD,iBAAiB,CAAC,eAAe,CAAtD,WAAW,CAAC,QAAQ,CAA0D,2CAA0C,CAAnI,UAAoI,CAAC,mCAAmC,gCAAgC,CAAC,sEAAsE,gCAAgC,CAAC,oDAAoD,8CAA8C,CAAC,iDAA4D,eAAe,CAAC,0BAA0B,CAAC,cAAc,CAAC,iBAAgB,CAArF,UAAsF,CAAC,iCAA8D,gDAA+C,CAA5E,iBAAiB,CAAC,UAA2D,CAAC,8BAA8B,YAAY,CAAC,QAAQ,CAAC,WAAW,CAAC,kBAAkB,CAAC,2CAA2C,eAAe,CAAC,wBAAkD,0BAA0B,CAApD,aAAa,CAAwC,cAAc,CAArD,WAAW,CAA2C,gBAAgB,CAA0B,iBAAgB,CAAzC,wBAA0C,CAAC,iDAAgE,WAAU,CAAzB,cAA0B,CAAC,6CAA+D,uCAAsC,CAAxD,iBAAyD,CAAC,2BAAsC,WAAU,CAArB,UAAsB,CAAC,yCAA2G,qBAAsB,CAAxD,iBAAiB,CAAC,eAAe,CAAtD,WAAW,CAAC,QAAQ,CAA0D,2CAA0C,CAAnI,UAAoI,CAAC,mCAAmC,gCAAgC,CAAC,sEAAsE,gCAAgC,CAAC,oDAAoD,8CAA8C,CAAC,iDAA4D,eAAe,CAAC,0BAA0B,CAAC,cAAc,CAAC,iBAAgB,CAArF,UAAsF,CAAC,iCAA8D,gDAA+C,CAA5E,iBAAiB,CAAC,UAA2D,CAAC,8BAA8B,YAAY,CAAC,QAAQ,CAAC,WAAW,CAAC,kBAAkB,CAAC,2CAA2C,eAAe,CAAC,wBAAkD,0BAA0B,CAApD,aAAa,CAAwC,cAAc,CAArD,WAAW,CAA2C,gBAAgB,CAA0B,iBAAgB,CAAzC,wBAA0C,CAAC,iDAAgE,WAAU,CAAzB,cAA0B,CAAC,6CAA+D,uCAAsC,CAAxD,iBAAyD,CAAC,2BAAsC,WAAU,CAArB,UAAsB,CAAC,yCAA2G,qBAAsB,CAAxD,iBAAiB,CAAC,eAAe,CAAtD,WAAW,CAAC,QAAQ,CAA0D,2CAA0C,CAAnI,UAAoI,CAAC,qDAAqD,gCAAgC,CAAC,oDAAoD,8CAA8C,CAAC,iDAA4D,eAAe,CAAC,0BAA0B,CAAC,cAAc,CAAC,iBAAgB,CAArF,UAAsF",sourcesContent:[':root{--vc-picker-bg: #f8f8f8;--vc-body-bg: #fff;--vc-input-bg: #fff;--vc-input-text: #333;--vc-input-label: #969696;--vc-input-border: #dadada;--vc-chrome-toggle-btn-highlighted: #eee;--vc-ps-bg: #dcdcdc;--vc-ps-title-bg-gradient-start: #f0f0f0;--vc-ps-title-bg-gradient-end: #d4d4d4;--vc-ps-title-border: #B1B1B1;--vc-ps-title-color: #4d4d4d;--vc-ps-slider-border: #b3b3b3;--vc-ps-slider-border-bottom: #f0f0f0;--vs-ps-picker-border-dark: #555;--vs-ps-picker-border-white: #fff;--vc-ps-btn-gradient-start: #fff;--vc-ps-btn-gradient-end: #e6e6e6;--vc-ps-btn-border: #878787;--vc-ps-btn-shadow: #EAEAEA;--vc-ps-btn-color: #000;--vc-ps-preview-border: #000;--vc-ps-label: #000;--vc-ps-input-border: #888;--vc-ps-input-shadow-dark: rgba(0,0,0,.1);--vc-ps-input-shadow-light: #ececec;--vc-sketch-input-label: #222;--vc-sketch-presets-border: #eee;--vc-twitter-input-bg: #fff;--vc-twitter-input-border: #f0f0f0;--vc-twitter-input-color: #666;--vc-twitter-hash-bg: #f0f0f0;--vc-twitter-hash-color: #98A1A4}:root.dark{--vc-body-bg: #424242;--vc-picker-bg: #d0d0d0;--vc-input-bg: #2c2c2c;--vc-input-text: #d0d0d0;--vc-input-label: #bbbbbb;--vc-input-border: #555555;--vc-chrome-toggle-btn-highlighted: #5c5c5c;--vc-sketch-input-label: #bbbbbb;--vc-sketch-presets-border: #5a5a5a;--vc-twitter-input-border: #383838;--vc-twitter-input-color: #bbbbbb;--vc-twitter-hash-bg: #383838;--vc-twitter-hash-color: #a0acaf;--vc-twitter-input-bg: #555;--vc-ps-bg: #424242;--vc-ps-title-bg-gradient-start: #4e4e4e;--vc-ps-title-bg-gradient-end: #3a3a3a;--vc-ps-title-border: #5a5a5a;--vc-ps-title-color: #bbbbbb;--vc-ps-slider-border: #5c5c5c;--vc-ps-slider-border-bottom: #4a4a4a;--vs-ps-picker-border-dark: #b8b8b8;--vs-ps-picker-border-white: #bbbbbb;--vc-ps-btn-gradient-start: #505050;--vc-ps-btn-gradient-end: #3a3a3a;--vc-ps-btn-border: #6a6a6a;--vc-ps-btn-shadow: #2a2a2a;--vc-ps-btn-color: #bbbbbb;--vc-ps-preview-border: #3a3a3a;--vc-ps-label: #bbbbbb;--vc-ps-input-border: #666666;--vc-ps-input-shadow-dark: rgba(0, 0, 0, .45);--vc-ps-input-shadow-light: #2d2d2d}.bg[data-v-4d048d6e]{cursor:crosshair;position:absolute;inset:0;touch-action:none}.white[data-v-4d048d6e]{background:linear-gradient(to right,#fff,#fff0)}.black[data-v-4d048d6e]{background:linear-gradient(to top,#000,#0000)}.picker-wrap[data-v-4d048d6e]{cursor:pointer;position:absolute;outline:none}.picker[data-v-4d048d6e]{cursor:move;width:4px;height:4px;box-shadow:0 0 0 1.6px var(--vc-picker-bg),inset 0 0 1px 1px #0000004d,0 0 1px 2px #0006;border-radius:50%;transform:translate(-2px,-2px)}.vc-base-slider[data-v-972b0fad]{position:relative;width:100%;height:100%;touch-action:none}.background[data-v-972b0fad],.slider[data-v-972b0fad]{position:absolute;inset:0}.background[data-v-972b0fad]{overflow:hidden}.slider[data-v-972b0fad]{cursor:pointer;z-index:2}.picker-wrap[data-v-972b0fad]{position:absolute;z-index:2;outline:none}.picker[data-v-972b0fad]{width:4px;height:8px;margin-top:1px;border-radius:1px;box-shadow:0 0 2px #0009;background:var(--vc-picker-bg);cursor:pointer;transform:translate(-2px)}.vc-hue-slider[data-v-5367c985]{cursor:crosshair;touch-action:none}.gradient[data-v-5367c985]{width:100%;height:100%;border-radius:2px;background:var(--2f44f39d)}.vc-checkerboard[data-v-37d61ccd]{position:absolute;inset:0;background-size:contain}.vc-alpha-slider[data-v-07dd346b] .vc-checkerboard{border-radius:2px}.gradient[data-v-07dd346b]{position:absolute;inset:0}.vc-editable-input[data-v-4a4df1fd]{position:relative}.vc-input-input[data-v-4a4df1fd]{width:100%;padding:0;border:0;outline:none}.vc-input-label[data-v-4a4df1fd]{text-transform:capitalize}.vc-chrome-picker[data-v-abf90852]{width:225px;box-sizing:initial;border-radius:2px;box-shadow:0 0 2px #0000004d,0 4px 8px #0000004d;font-family:Menlo,Consolas,Courier New,monospace}.controls[data-v-abf90852]{display:flex}.color-wrap[data-v-abf90852]{position:relative;width:36px}.active-color[data-v-abf90852]{position:relative;width:30px;height:30px;border-radius:15px;overflow:hidden;z-index:1}.color-wrap[data-v-abf90852] .vc-checkerboard{width:30px;height:30px;border-radius:15px;background-size:auto}.sliders[data-v-abf90852]{flex:1}.fieldsWrap[data-v-abf90852]{display:flex;padding-top:16px}.fields[data-v-abf90852]{display:flex;margin-left:-6px;flex:1}.field[data-v-abf90852]{padding-left:6px;width:100%}.toggle-btn[data-v-abf90852]{width:32px;text-align:right;position:relative}.toggle-icon[data-v-abf90852]{position:relative;margin-right:-4px;margin-top:12px;cursor:pointer;z-index:2;color:var(--vc-input-text)}.toggle-icon_highlighted[data-v-abf90852]{position:absolute;width:24px;height:28px;top:10px;left:12px;background:var(--vc-chrome-toggle-btn-highlighted);border-radius:4px}.hue-wrap[data-v-abf90852]{position:relative;height:10px;margin-bottom:8px}.alpha-wrap[data-v-abf90852]{position:relative;height:10px}.hue-wrap[data-v-abf90852] .container,.alpha-wrap[data-v-abf90852] .gradient{border-radius:2px}.hue-wrap[data-v-abf90852] .picker,.alpha-wrap[data-v-abf90852] .picker{width:12px;height:12px;border-radius:6px;transform:translate(-6px,-2px);box-shadow:0 1px 4px #0000005e}.body[data-v-abf90852]{padding:16px 16px 12px;background-color:var(--vc-body-bg)}.saturation[data-v-abf90852]{width:100%;padding-bottom:55%;position:relative;border-radius:2px 2px 0 0;overflow:hidden}.saturation[data-v-abf90852] .picker{width:12px;height:12px;transform:translate(-6px,-6px)}.fields[data-v-abf90852] .vc-input-input{width:100%;height:21px;border-radius:2px;border:none;box-shadow:inset 0 0 0 1px var(--vc-input-border);background-color:var(--vc-input-bg);color:var(--vc-input-text);font-size:11px;text-align:center}.fields[data-v-abf90852] .vc-input-label{display:block;margin-top:12px;font-size:11px;color:var(--vc-input-label);line-height:11px;text-transform:uppercase;text-align:center}.alpha-disabled[data-v-abf90852] .active-color{width:18px;height:18px}.alpha-disabled[data-v-abf90852] .color-wrap{width:30px}.alpha-disabled[data-v-abf90852] .hue-wrap{margin-top:4px;margin-bottom:4px}.vc-compact-picker[data-v-17eda10a]{width:245px;padding-top:5px;padding-left:5px;border-radius:2px;box-sizing:border-box;box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029;background-color:var(--vc-body-bg)}.colors[data-v-17eda10a]{overflow:hidden;padding:0;margin:0}.color-item[data-v-17eda10a]{list-style:none;width:15px;height:15px;float:left;margin-right:5px;margin-bottom:5px;position:relative;cursor:pointer}.color-item_white[data-v-17eda10a]{box-shadow:inset 0 0 0 1px #ddd}.color-item_white .dot[data-v-17eda10a]{background:#000}.dot[data-v-17eda10a]{position:absolute;inset:5px;border-radius:50%;opacity:1;background:#fff}.vc-grayscale-picker[data-v-85f108e1]{padding-top:5px;padding-left:5px;width:245px;border-radius:2px;box-sizing:border-box;box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029;background-color:var(--vc-body-bg)}.colors[data-v-85f108e1]{overflow:hidden;padding:0;margin:0}.color-item[data-v-85f108e1]{list-style:none;width:15px;height:15px;float:left;margin-right:5px;margin-bottom:5px;position:relative;cursor:pointer}.color-item_white[data-v-85f108e1]{box-shadow:inset 0 0 0 1px #ddd}.color-item_white .dot[data-v-85f108e1]{background:#000}.dot[data-v-85f108e1]{position:absolute;inset:5px;border-radius:50%;opacity:1;background:#fff}.vc-material-picker[data-v-4e39f856]{position:relative;width:98px;height:98px;padding:16px;border-radius:2px;box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029;background-color:var(--vc-body-bg);font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Helvetica Neue,Arial,sans-serif}.vc-material-picker[data-v-4e39f856] .vc-input-input{width:100%;height:30px;margin-top:12px;background-color:var(--vc-body-bg);color:var(--vc-input-text);font-size:15px}.vc-material-picker[data-v-4e39f856] .vc-input-label{position:absolute;top:0;left:0;font-size:11px;color:var(--vc-input-label)}.hex[data-v-4e39f856]{border-bottom-width:2px;border-bottom-style:solid}.rgb[data-v-4e39f856]{display:flex;margin-right:-10px;padding-top:11px}.color[data-v-4e39f856]{flex:1;padding-right:10px}.vc-photoshop-picker[data-v-fe6db8eb]{width:513px;background:var(--vc-ps-bg);border-radius:4px;box-shadow:0 0 0 1px #00000040,0 8px 16px #00000026;box-sizing:initial;font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Helvetica Neue,Arial,sans-serif}.fields_disabled[data-v-fe6db8eb]{width:390px}.title[data-v-fe6db8eb]{height:23px;background-image:linear-gradient(-180deg,var(--vc-ps-title-bg-gradient-start) 0%,var(--vc-ps-title-bg-gradient-end) 100%);border-bottom:1px solid var(--vc-ps-title-border);border-radius:4px 4px 0 0;box-shadow:inset 0 1px #fff3,inset 0 -1px #00000005;color:var(--vc-ps-title-color);font-size:13px;line-height:24px;text-align:center}.body[data-v-fe6db8eb]{padding:15px;display:flex}.saturation[data-v-fe6db8eb]{width:256px;height:256px;position:relative;border:2px solid var(--vc-ps-slider-border);border-bottom:2px solid var(--vc-ps-slider-border-bottom);overflow:hidden}.saturation[data-v-fe6db8eb] .picker{width:12px;height:12px;transform:translate(-6px,-6px)}.hue[data-v-fe6db8eb]{height:256px;width:19px;margin-left:10px;border:2px solid var(--vc-ps-slider-border);border-bottom:2px solid var(--vc-ps-slider-border-bottom)}.hue-picker[data-v-fe6db8eb]{position:relative}.hue-picker-left[data-v-fe6db8eb],.hue-picker-right[data-v-fe6db8eb]{position:absolute;width:0;height:0;border-style:solid;border-width:5px 0 5px 8px;border-color:transparent transparent transparent var(--vs-ps-picker-border-dark);cursor:pointer}.hue-picker-left[data-v-fe6db8eb]:after,.hue-picker-right[data-v-fe6db8eb]:after{content:"";width:0;height:0;border-style:solid;border-width:4px 0 4px 6px;border-color:transparent transparent transparent var(--vs-ps-picker-border-white);position:absolute;top:1px;left:1px;transform:translate(-8px,-5px)}.hue-picker-left[data-v-fe6db8eb]{transform:translate(-10px,-4px)}.hue-picker-right[data-v-fe6db8eb]{transform:translate(21px,-4px) rotate(180deg)}.controls[data-v-fe6db8eb]{width:180px;margin-left:10px;display:flex}.controls_fields_disabled[data-v-fe6db8eb]{width:auto}.actions[data-v-fe6db8eb]{margin-left:20px;flex:1}.action-btn[data-v-fe6db8eb]{height:20px;margin-bottom:10px;background-image:linear-gradient(-180deg,var(--vc-ps-btn-gradient-start) 0%,var(--vc-ps-btn-gradient-end) 100%);border:1px solid var(--vc-ps-btn-border);border-radius:2px;box-shadow:0 1px 0 0 var(--vc-ps-btn-shadow);cursor:pointer;color:var(--vc-ps-btn-color);font-size:14px;line-height:20px;text-align:center}.preview[data-v-fe6db8eb]{width:60px}.preview-swatches[data-v-fe6db8eb]{border:1px solid var(--vc-ps-slider-border);border-bottom:1px solid var(--vc-ps-slider-border-bottom);margin-bottom:2px;margin-top:1px}.preview-color[data-v-fe6db8eb]{height:34px;box-shadow:inset 1px 0 var(--vc-ps-preview-border),inset -1px 0 var(--vc-ps-preview-border),inset 0 1px var(--vc-ps-preview-border)}.preview-label[data-v-fe6db8eb]{color:var(--vc-ps-label);font-size:14px;text-align:center}.fields[data-v-fe6db8eb]{padding-top:5px;padding-bottom:9px;width:80px;position:relative}.fields[data-v-fe6db8eb] .vc-input-input{width:40%;height:18px;margin-left:40%;margin-right:10px;margin-bottom:5px;padding-left:3px;border:1px solid var(--vc-ps-input-border);box-shadow:inset 0 1px 1px var(--vc-ps-input-shadow-dark),0 1px 0 0 var(--vc-ps-input-shadow-light);background-color:var(--vc-input-bg);color:var(--vc-ps-label);font-size:13px}.fields[data-v-fe6db8eb] .vc-input-label,.fields[data-v-fe6db8eb] .vc-input-desc{position:absolute;top:0;height:18px;color:var(--vc-ps-label);font-size:13px;line-height:22px;text-transform:uppercase}.fields[data-v-fe6db8eb] .vc-input-label{left:0;width:34px}.fields[data-v-fe6db8eb] .vc-input-desc{right:0;width:0}.fields-divider[data-v-fe6db8eb]{height:5px}.hex[data-v-fe6db8eb] .vc-input-input{width:80%;height:18px;margin-left:20%;margin-bottom:6px;padding-left:3px;border:1px solid var(--vc-ps-input-border);box-shadow:inset 0 1px 1px var(--vc-ps-input-shadow-dark),0 1px 0 0 var(--vc-ps-input-shadow-light);font-size:13px}.hex[data-v-fe6db8eb] .vc-input-label{position:absolute;top:0;left:0;width:14px;text-transform:uppercase;font-size:13px;height:18px;line-height:22px}.vc-sketch-picker[data-v-4a59b29b]{position:relative;width:200px;padding:10px 10px 0;box-sizing:initial;background:var(--vc-body-bg);border-radius:4px;box-shadow:0 0 0 1px #00000026,0 8px 16px #00000026;font-family:Menlo,Consolas,Courier New,monospace}.saturation[data-v-4a59b29b]{width:100%;padding-bottom:75%;position:relative;overflow:hidden}.controls[data-v-4a59b29b]{display:flex}.sliders[data-v-4a59b29b]{padding:4px 0;flex:1}.hue[data-v-4a59b29b] .container,.alpha[data-v-4a59b29b] .gradient{border-radius:2px}.hue[data-v-4a59b29b]{position:relative;height:10px}.alpha[data-v-4a59b29b]{position:relative;height:10px;margin-top:4px;overflow:hidden}.color[data-v-4a59b29b]{width:24px;height:24px;position:relative;margin-top:4px;margin-left:4px;border-radius:2px;overflow:hidden}.active-color[data-v-4a59b29b]{position:absolute;inset:0;box-shadow:inset 0 0 0 1px #00000026,inset 0 0 4px #00000040;z-index:2}.color[data-v-4a59b29b] .vc-checkerboard{background-size:auto}.field[data-v-4a59b29b]{display:flex;padding-top:4px}.field[data-v-4a59b29b] .vc-input-input{width:90%;padding:4px 0 3px 10%;border:none;box-shadow:inset 0 0 0 1px var(--vc-input-border);background-color:var(--vc-input-bg);color:var(--vc-input-text);font-size:10px}.field[data-v-4a59b29b] .vc-input-label{display:block;padding-top:3px;padding-bottom:4px;color:var(--vc-sketch-input-label);font-size:11px;text-align:center}.field_single[data-v-4a59b29b]{flex:1;padding-left:6px}.field_double[data-v-4a59b29b]{flex:2}.presets[data-v-4a59b29b]{margin-right:-10px;margin-left:-10px;padding-left:10px;padding-top:10px;border-top:1px solid var(--vc-sketch-presets-border)}.preset-color[data-v-4a59b29b]{border-radius:3px;overflow:hidden;position:relative;display:inline-block;margin:0 10px 10px 0;vertical-align:top;cursor:pointer;width:16px;height:16px;box-shadow:inset 0 0 0 1px #00000026}.preset-color[data-v-4a59b29b] .vc-checkerboard{box-shadow:inset 0 0 0 1px #00000026;border-radius:3px}.alpha-disabled .color[data-v-4a59b29b]{height:10px}.vc-slider-picker[data-v-675d6988]{position:relative;width:410px}.hue[data-v-675d6988]{height:12px;position:relative}.hue[data-v-675d6988] .picker,.alpha[data-v-675d6988] .picker{width:14px;height:14px;border-radius:6px;box-shadow:0 1px 4px #0000005e;transform:translate(-7px,-2px)}.alpha[data-v-675d6988]{height:12px;position:relative;margin-top:20px}.swatches[data-v-675d6988]{display:flex;margin-top:20px}.swatch[data-v-675d6988]{margin-right:1px;flex:1;width:20%}.swatch[data-v-675d6988]:first-child{margin-right:1px}.swatch:first-child .picker[data-v-675d6988]{border-radius:2px 0 0 2px}.swatch[data-v-675d6988]:last-child{margin-right:0}.swatch:last-child .picker[data-v-675d6988]{border-radius:0 2px 2px 0}.picker[data-v-675d6988]{cursor:pointer;height:12px}.swatch:nth-child(n) .picker_active[data-v-675d6988]{transform:scaleY(1.8);border-radius:3.6px/2px}.picker_white[data-v-675d6988]{box-shadow:inset 0 0 0 1px #ddd}.picker_active.picker_white[data-v-675d6988]{box-shadow:inset 0 0 0 .6px #ddd}.vc-swatches-picker[data-v-3427cb2a]{width:320px;height:240px;overflow-y:scroll;background-color:var(--vc-body-bg);box-shadow:0 2px 10px #0000001f,0 2px 5px #00000029}.box[data-v-3427cb2a]{padding:16px 0 6px 16px;overflow:hidden}.colorGroup[data-v-3427cb2a]{padding-bottom:10px;width:40px;float:left;margin-right:10px}.color[data-v-3427cb2a]{box-sizing:border-box;width:40px;height:24px;margin-bottom:1px;cursor:pointer;overflow:hidden;-ms-border-radius:2px 2px 0 0;-moz-border-radius:2px 2px 0 0;-o-border-radius:2px 2px 0 0;-webkit-border-radius:2px 2px 0 0;border-radius:2px 2px 0 0}.color_white[data-v-3427cb2a]{border:1px solid #ddd}.picker[data-v-3427cb2a]{display:block;fill:#fff;margin-left:8px}.color_white .picker[data-v-3427cb2a]{fill:#333}.vc-twitter-picker[data-v-4652e193]{position:relative;background:var(--vc-body-bg);border:0 solid rgba(0,0,0,.25);box-shadow:0 1px 4px #00000040;border-radius:4px}.triangle[data-v-4652e193]{position:absolute;width:0px;height:0px;border-style:solid;border-width:0 9px 10px 9px;border-color:transparent transparent var(--vc-body-bg) transparent}.triangle_shadow[data-v-4652e193]{width:0px;height:0px;border-style:solid;border-width:0 9px 10px 9px;border-color:transparent transparent rgba(0,0,0,.1) transparent;position:absolute}.body[data-v-4652e193]{padding:15px 9px 9px 15px}.vc-twitter-picker[data-v-4652e193] .vc-editable-input{position:relative}.vc-twitter-picker[data-v-4652e193] .vc-input-input{float:left;width:100px;height:28px;padding:1px 1px 1px 8px;outline:none;box-shadow:inset 0 0 0 1px var(--vc-twitter-input-border);box-sizing:content-box;border:0px;border-radius:0 4px 4px 0;background-color:var(--vc-twitter-input-bg);color:var(--vc-twitter-input-color);font-size:14px}.vc-twitter-picker[data-v-4652e193] .vc-editable-input span{display:none}.hash[data-v-4652e193]{float:left;display:flex;align-items:center;justify-content:center;height:30px;width:30px;border-radius:4px 0 0 4px;background:var(--vc-twitter-hash-bg);color:var(--vc-twitter-hash-color)}.swatch[data-v-4652e193]{width:30px;height:30px;float:left;border-radius:4px;margin:0 6px 6px 0;cursor:pointer;position:relative;outline:none}.clear[data-v-4652e193]{clear:both}.tri_hide .triangle[data-v-4652e193],.tri_hide .triangle_shadow[data-v-4652e193]{display:none}.tri_top_left .triangle[data-v-4652e193]{top:-10px;left:12px}.tri_top_left .triangle_shadow[data-v-4652e193]{top:-11px;left:12px}.tri_top_right .triangle[data-v-4652e193]{top:-10px;right:12px}.tri_top_right .triangle_shadow[data-v-4652e193]{top:-11px;right:12px}.vc-hue-wrap[data-v-b3ac1ab2]{height:8px}.vc-hue-wrap[data-v-b3ac1ab2] .slider{border-radius:4px}.vc-hue-wrap[data-v-b3ac1ab2] .picker{width:20px;height:20px;margin:0;border-radius:50%;box-shadow:none;border:2px white solid;background-color:var(--46ac36b6);transform:translate(-12px) translateY(-8px)}.vc-hsl-sliders[data-v-2e071f54]{position:relative;width:100%;font-family:Menlo,Consolas,Courier New,monospace}.slider-wrap[data-v-2e071f54]{display:flex;gap:12px;height:24px;margin-bottom:10px}.slider-wrap[data-v-2e071f54]:last-of-type{margin-bottom:0}.label[data-v-2e071f54]{display:block;height:24px;color:var(--vc-input-text);font-size:12px;line-height:24px;text-transform:uppercase;text-align:center}.vc-hsl-sliders[data-v-2e071f54] .vc-base-slider{margin-top:5px;height:14px}.vc-hsl-sliders[data-v-2e071f54] .background{border-radius:4px;border:1px solid var(--vc-input-border)}.gradient[data-v-2e071f54]{width:100%;height:100%}.vc-hsl-sliders[data-v-2e071f54] .picker{width:20px;height:20px;margin:0;border-radius:50%;box-shadow:none;border:2px white solid;transform:translate(-12px) translateY(-5px)}.h-slider[data-v-2e071f54] .picker{background-color:var(--41b5b6d0)}.s-slider[data-v-2e071f54] .picker,.l-slider[data-v-2e071f54] .picker{background-color:var(--05fbe691)}.vc-hsl-sliders[data-v-2e071f54] .vc-editable-input{border-bottom:1px solid var(--vc-input-border)}.vc-hsl-sliders[data-v-2e071f54] .vc-input-input{width:50px;background:none;color:var(--vc-input-text);font-size:12px;text-align:center}.vc-hsv-sliders[data-v-d6cfe1d9]{position:relative;width:100%;font-family:Menlo,Consolas,Courier New,monospace}.slider-wrap[data-v-d6cfe1d9]{display:flex;gap:12px;height:24px;margin-bottom:10px}.slider-wrap[data-v-d6cfe1d9]:last-of-type{margin-bottom:0}.label[data-v-d6cfe1d9]{display:block;height:24px;color:var(--vc-input-text);font-size:12px;line-height:24px;text-transform:uppercase;text-align:center}.vc-hsv-sliders[data-v-d6cfe1d9] .vc-base-slider{margin-top:5px;height:14px}.vc-hsv-sliders[data-v-d6cfe1d9] .background{border-radius:4px;border:1px solid var(--vc-input-border)}.gradient[data-v-d6cfe1d9]{width:100%;height:100%}.vc-hsv-sliders[data-v-d6cfe1d9] .picker{width:20px;height:20px;margin:0;border-radius:50%;box-shadow:none;border:2px white solid;transform:translate(-12px) translateY(-5px)}.h-slider[data-v-d6cfe1d9] .picker{background-color:var(--f666f450)}.s-slider[data-v-d6cfe1d9] .picker,.b-slider[data-v-d6cfe1d9] .picker{background-color:var(--46b90cce)}.vc-hsv-sliders[data-v-d6cfe1d9] .vc-editable-input{border-bottom:1px solid var(--vc-input-border)}.vc-hsv-sliders[data-v-d6cfe1d9] .vc-input-input{width:50px;background:none;color:var(--vc-input-text);font-size:12px;text-align:center}.vc-rgb-sliders[data-v-98b3b212]{position:relative;width:100%;font-family:Menlo,Consolas,Courier New,monospace}.slider-wrap[data-v-98b3b212]{display:flex;gap:12px;height:24px;margin-bottom:10px}.slider-wrap[data-v-98b3b212]:last-of-type{margin-bottom:0}.label[data-v-98b3b212]{display:block;height:24px;color:var(--vc-input-text);font-size:12px;line-height:24px;text-transform:uppercase;text-align:center}.vc-rgb-sliders[data-v-98b3b212] .vc-base-slider{margin-top:5px;height:14px}.vc-rgb-sliders[data-v-98b3b212] .background{border-radius:4px;border:1px solid var(--vc-input-border)}.gradient[data-v-98b3b212]{width:100%;height:100%}.vc-rgb-sliders[data-v-98b3b212] .picker{width:20px;height:20px;margin:0;border-radius:50%;box-shadow:none;border:2px white solid;transform:translate(-12px) translateY(-5px)}.slider-wrap[data-v-98b3b212]:not(.a-slider) .picker{background-color:var(--5f730604)}.vc-rgb-sliders[data-v-98b3b212] .vc-editable-input{border-bottom:1px solid var(--vc-input-border)}.vc-rgb-sliders[data-v-98b3b212] .vc-input-input{width:50px;background:none;color:var(--vc-input-text);font-size:12px;text-align:center}\n'],sourceRoot:""}]);const a=s},941:()=>{}},n={};function r(e){var i=n[e];if(void 0!==i)return i.exports;var o=n[e]={id:e,exports:{}};return t[e](o,o.exports,r),o.exports}r.m=t,e=[],r.O=(t,n,i,o)=>{if(!n){var s=1/0;for(h=0;h<e.length;h++){for(var[n,i,o]=e[h],a=!0,l=0;l<n.length;l++)(!1&o||s>=o)&&Object.keys(r.O).every(e=>r.O[e](n[l]))?n.splice(l--,1):(a=!1,o<s&&(s=o));if(a){e.splice(h--,1);var c=i();void 0!==c&&(t=c)}}return t}o=o||0;for(var h=e.length;h>0&&e[h-1][2]>o;h--)e[h]=e[h-1];e[h]=[n,i,o]},r.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return r.d(t,{a:t}),t},r.d=(e,t)=>{for(var n in t)r.o(t,n)&&!r.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},r.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),r.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),r.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},(()=>{var e={585:0,402:0};r.O.j=t=>0===e[t];var t=(t,n)=>{var i,o,[s,a,l]=n,c=0;if(s.some(t=>0!==e[t])){for(i in a)r.o(a,i)&&(r.m[i]=a[i]);if(l)var h=l(r)}for(t&&t(n);c<s.length;c++)o=s[c],r.o(e,o)&&e[o]&&e[o][0](),e[o]=0;return r.O(h)},n=self.webpackChunktranslatepress_multilingual=self.webpackChunktranslatepress_multilingual||[];n.forEach(t.bind(null,0)),n.push=t.bind(null,n.push.bind(n))})(),r.nc=void 0,r.O(void 0,[402],()=>r(434));var i=r.O(void 0,[402],()=>r(941));i=r.O(i)})();
//# sourceMappingURL=trp-lang-switcher-configurator.js.map