jQuery(function() {
	"use strict";
	$ = jQuery;
	// Do our DOM lookups beforehand
	var nav_container = jQuery(".nav-container");
	var nav = jQuery(".fixed-nav");
	
	var top_spacing = 15;
	var waypoint_offset = 50;

	nav_container.waypoint({
		handler: function(event, direction) {
			
			if (direction == 'down') {
			
				nav_container.css({ 'height':nav.outerHeight() });		
				nav.stop().addClass("sticky").css("top",-nav.outerHeight()).animate({"top":top_spacing});
				
			} else {
			
				nav_container.css({ 'height':'auto' });
				nav.stop().removeClass("sticky").css("top",nav.outerHeight()+waypoint_offset).animate({"top":""});
				
			}
			
		},
		offset: function() {
			return -nav.outerHeight()-waypoint_offset;
		}
	});
	
	var sections = jQuery("section");
	var navigation_links = jQuery(".fixed-nav a");
	
	sections.waypoint({
		handler: function(event, direction) {
		
			var active_section;
			active_section = jQuery(this);
			if (direction === "up") active_section = active_section.prev();

			var active_link = jQuery('.fixed-nav a[href="#' + active_section.attr("id") + '"]');
			navigation_links.removeClass("selected");
			active_link.addClass("selected");

		},
		offset: '25%'
	})
	
	
	navigation_links.click( function(event) {

		jQuery.scrollTo(
			jQuery(this).attr("href"),
			{
				duration: 200,
				offset: { 'left':0, 'top':-0.15*jQuery(window).height() }
			}
		);
	});


});