<?php
/**
 * Define hooks (wp content, theme options, menus & locations, set up pages, revolution slider, widgets) for importer
 *
 * @since	1.2
 * @package	WordPress
 */

add_action( 'cs_import_wp_data', 'cs_import_wp_data_handle' );
if ( ! function_exists( 'cs_import_wp_data_handle' ) ) {
	/**
	 * Import WP content using WP importer
	 *
	 * @param CS_Data_Importer $obj An instance of CS_Data_Importer class which contains different configurations.
	 */
	function cs_import_wp_data_handle( $obj ) {
		if ( ! class_exists( 'WP_Importer' ) ) {
			$wp_importer = ABSPATH . 'wp-admin/includes/class-wp-importer.php';
			require_once $wp_importer;
		}

		if ( ! class_exists( 'WP_Import' ) ) {
			require_once $obj->cs_importer_class_path;
		}

		if ( class_exists( 'WP_Importer' ) && class_exists( 'WP_Import' ) ) {
			$importer = new WP_Import();
			$importer->fetch_attachments = true;
			ob_start();
			$importer->import( $obj->wp_data_path );
			ob_end_clean();
			$obj->action_return = true;
		} else {
			$obj->action_return = false;
		}
	}
}

add_action( 'cs_import_theme_options', 'cs_import_wp_options_handle' );
if ( ! function_exists( 'cs_import_wp_options_handle' ) ) {
	/**
	 * Import Theme Options
	 *
	 * @param CS_Data_Importer $obj An instance of CS_Data_Importer class which contains different configurations.
	 */
	function cs_import_wp_options_handle( $obj ) {
		global $wp_filesystem;
		$theme_options = $wp_filesystem->get_contents( $obj->theme_options_data_path );
		$cs_theme_skin = json_decode( $theme_options, true );
		update_option( 'cs_theme_options', $cs_theme_skin );

		// Create css file when theme option call.
		if ( function_exists( 'jobcareer_write_stylesheet_content' ) ) {
			jobcareer_write_stylesheet_content();
		}

		$obj->action_return = true;
	}
}

add_action( 'cs_import_menus_and_locations', 'cs_import_menus_and_locations_handle' );
if ( ! function_exists( 'cs_import_menus_and_locations_handle' ) ) {
	/**
	 * Set Menu's locations
	 *
	 * @param CS_Data_Importer $obj An instance of CS_Data_Importer class which contains different configurations.
	 */
	function cs_import_menus_and_locations_handle( $obj ) {
		global $wp_filesystem, $wpdb;
		$locations = get_theme_mod( 'nav_menu_locations' );
		$menus_str = $wp_filesystem->get_contents( $obj->menus_data_path );
		$menus = json_decode( $menus_str, true );
		foreach ( $menus as $item ) {
			$term_exists = term_exists( $item['menu_slug'], 'nav_menu' );
			if ( ! $term_exists ) {
				$wpdb->insert(
					$wpdb->terms, array(
						'name' => $item['menu_title'],
						'slug' => $item['menu_slug'],
						'term_group' => 0,
					), array(
						'%s',
						'%s',
						'%d',
					)
				);
				$insert_id = $wpdb->insert_id;
				$locations[ $item['location'] ] = $insert_id;
				$wpdb->insert(
					$wpdb->term_taxonomy, array(
						'term_id' => $insert_id,
						'taxonomy' => 'nav_menu',
						'description' => '',
						'parent' => 0,
						'count' => 0,
					), array(
						'%d',
						'%s',
						'%s',
						'%d',
						'%d',
					)
				);
			} else {
				$locations[ $item['location'] ] = $term_exists['term_id'];
			}
		}
		set_theme_mod( 'nav_menu_locations', $locations );
		$obj->action_return = true;
	}
}

add_action( 'cs_import_setup_pages', 'cs_import_setup_pages_handle' );
if ( ! function_exists( 'cs_import_setup_pages_handle' ) ) {
	/**
	 * Set homepage for site
	 *
	 * @param CS_Data_Importer $obj An instance of CS_Data_Importer class which contains different configurations.
	 */
	function cs_import_setup_pages_handle( $obj ) {
		$homepage = get_page_by_path( $obj->homepage_slug );
                
                $demo_data_name = $obj->demo_data_name;

		if ( ! empty( $homepage->ID ) ) {
                    
			update_option( 'page_on_front', $homepage->ID );
			update_option( 'show_on_front', 'page' );
                        
                        $element_data = get_post_meta(548, '_elementor_data', true);
                        update_option('test_elementor_data_testing', $element_data);
                        do_action('jobcareer_after_demo_content_import', $obj->demo_data_name);
                        
                        if( $demo_data_name == 'elementor'){
                            global $wpdb;
                            $frontpage_id = get_option('page_on_front');

                            $data   = '[{"id":"2d87612","elType":"section","settings":{"layout":"full_width","stretch_section":"section-stretched","gap":"no"},"elements":[{"id":"564de15","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"802a0f8","elType":"widget","settings":{"revslidertitle":"Homepage 1","shortcode":"[rev_slider alias=\"homepage-1\" slidertitle=\"Homepage 1\"][\/rev_slider]"},"elements":[],"widgetType":"slider_revolution"}],"isInner":false}],"isInner":false},{"id":"7c23523","elType":"section","settings":{"margin":{"unit":"px","top":"-80","right":0,"bottom":"0","left":0,"isLinked":false}},"elements":[{"id":"78d5f3e","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"86d0b25","elType":"widget","settings":{"job_search_layout_bg":"#F5F6F8","job_search_title_field_switch":"yes","job_search_specialisam_field_switch":"yes","job_search_location_field_switch":"yes","job_lable_switch":"yes","job_search_hint_switch":"yes","job_advance_search_switch":"yes","job_advance_search_url":"#"},"elements":[],"widgetType":"jobhunt_jobs_search"}],"isInner":false}],"isInner":false},{"id":"4e727e1","elType":"section","settings":[],"elements":[{"id":"43f2dac","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"54e42be","elType":"widget","settings":{"job_specialisms_title":"BROWSE JOBS BY SPECIALTY","job_specialisms_title_align":"center","specialisms_view":"modern","specialisms_columns":"4","job_specialisms_subtitle_switch":"yes","spec_cats":["accountancy","banking","charity-voluntary","digital-creative","estate-agency","graduate","it-contractor","legal-jobs","manufacturing-jobs","marketing-pr","media-digital-creative-jobs","motoring-automotive","public-sector","purchase-ledger-clerk","retail","sales-marketing"],"_margin":{"unit":"px","top":"40","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[],"widgetType":"jobhunt_job_specialisms"}],"isInner":false}],"isInner":false},{"id":"a2308b3","elType":"section","settings":{"background_background":"classic","background_image":{"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/jobcareer-service-bg.png","id":18917,"alt":"","source":"library","size":""}},"elements":[{"id":"30646c7","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"178f47d","elType":"widget","settings":{"image":{"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/home-service-1.png","id":18915,"alt":"","source":"library","size":""},"title_text":"BROWSE JOBS BY SPECIALTY","description_text":"Towards any serious attempt to do things differently. We\u2019re<br>\nTalented people but these people are difficult to recruit, ","position":"left","image_space":{"unit":"px","size":9,"sizes":[]},"image_size":{"unit":"%","size":7,"sizes":[]},"title_typography_typography":"custom","title_typography_font_family":"Raleway","title_typography_font_size":{"unit":"px","size":13,"sizes":[]},"title_typography_font_weight":"500","title_typography_text_transform":"capitalize","title_shadow_text_shadow_type":"yes","title_shadow_text_shadow":{"horizontal":0,"vertical":0,"blur":0,"color":"rgba(0,0,0,0.3)"},"description_typography_typography":"custom","description_typography_font_family":"Montserrat","description_typography_font_size":{"unit":"px","size":13,"sizes":[]},"description_typography_font_weight":"400","description_shadow_text_shadow_type":"yes","description_shadow_text_shadow":{"horizontal":0,"vertical":0,"blur":0,"color":"rgba(0,0,0,0.3)"},"_padding":{"unit":"px","top":"60","right":"0","bottom":"60","left":"0","isLinked":false},"title_color":"#4E5356C4"},"elements":[],"widgetType":"image-box"}],"isInner":false}],"isInner":false},{"id":"ecc352e","elType":"section","settings":{"structure":"22"},"elements":[{"id":"70aa976","elType":"column","settings":{"_column_size":66,"_inline_size":75.085},"elements":[{"id":"dbff40f","elType":"widget","settings":{"cs_job_title":"FEATURED JOBS","cs_job_sub_title":"Leading Employers already using job and talent.","cs_job_view":"simple","cs_job_searchbox":"no","cs_job_map":"no","cs_job_result_type":"all","cs_job_alert_button":"disable","cs_job_show_pagination":"single_page","cs_job_pagination":"6","_margin":{"unit":"px","top":"60","right":"0","bottom":"60","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"jobhunt_jobs"}],"isInner":false},{"id":"36167e6","elType":"column","settings":{"_column_size":33,"_inline_size":24.22},"elements":[{"id":"2c27281","elType":"widget","settings":{"cs_employer_title":"TOP RECRUITERS","cs_employer_sub_title":"Employers already using job talent.","cs_employer_searchbox":"no","cs_employer_searchbox_top":"no","cs_employer_view":"box","cs_employer_show_pagination":"single_page","cs_employer_pagination":"2","_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_padding":{"unit":"px","top":"60","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"jobhunt_employers"}],"isInner":false}],"isInner":false},{"id":"a61f3ab","elType":"section","settings":{"layout":"full_width","gap":"no","structure":"20","background_background":"classic"},"elements":[{"id":"deafa6b","elType":"column","settings":{"_column_size":50,"_inline_size":null},"elements":[{"id":"9846ac2","elType":"widget","settings":{"editor":"<h2 style=\"color: #fff !important;\">We will always match you up with<br> opportunities that are the right fit<\/h2>\n<p style=\"color: #fff !important;\">I thought I would never be able to find a good job. Anyhow I took a look at the jobs posted by. I was looking for a job after matriculation due to some personal and domestic issues. I found a job but they did not pay me well. I thought I would never be able to find a good job. Anyhow I took a look.<\/p>","text_color":"#FFFFFF","_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_padding":{"unit":"px","top":"20","right":"30","bottom":"20","left":"400","isLinked":false},"_background_background":"classic","_background_color":"#55A747"},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"e301372","elType":"column","settings":{"_column_size":50,"_inline_size":null},"elements":[{"id":"87fcbb5","elType":"widget","settings":{"image":{"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/about-image.jpg","id":18918,"alt":"","source":"library","size":""},"_element_width":"inherit"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"41bd1c8","elType":"section","settings":[],"elements":[{"id":"b79d0c6","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"f63f866","elType":"widget","settings":{"cs_blog_section_title":"NOW JOBS WILL FIND YOU","cs_blog_element_subtitle":"found by employers communicate directly with hiring managers and recruiters.","cs_blog_alignment":"center","cs_blog_view":"grid","cs_blog_boxsize":"4","cs_blog_description":"yes","cs_blog_excerpt":"20","_margin":{"unit":"px","top":"60","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[],"widgetType":"jobhunt_blog"}],"isInner":false}],"isInner":false},{"id":"7e73a42","elType":"section","settings":[],"elements":[{"id":"5a27611","elType":"column","settings":{"_column_size":100,"_inline_size":null,"text_align":"center"},"elements":[{"id":"4da0c69","elType":"widget","settings":{"cs_candidate_title":"LATEST CANDIDATES","cs_candidate_cols":"6","cs_candidate_map":"no","cs_candidate_searchbox":"no","cs_candidate_show_pagination":"single_page","cs_candidate_pagination":"6"},"elements":[],"widgetType":"jobhunt_candidates"}],"isInner":false}],"isInner":false},{"id":"ccfec09","elType":"section","settings":{"layout":"full_width","gap":"no","background_background":"classic","background_image":{"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/testimonial-bg.jpg","id":18948,"size":"","alt":"","source":"library"}},"elements":[{"id":"9f31e4d","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"9c2bccf","elType":"widget","settings":{"testimonial_author_color":"#FFFFFF","testimonial_comp_color":"#FFFFFF","testimonial_style":"classic","testimonial_item":[{"_id":"73f467e","testimonial_text":"I thought I would never be able to find a good job. Anyhow I took a look at the jobs posted by on jobcareer. I was looking for a job after matriculation<br> due to some personal and domestic issues. I found a job but they did not pay me well. I thought I would never be able<br> to find a good job. Anyhow I took a look at the jobs posted by jobcareer.","testimonial_author":"James Warson","testimonial_company":"Newyork","testimonial_img_user":{"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/Testimonial-image-1.jpg","id":18919,"alt":"","source":"library","size":""}},{"testimonial_text":"I thought I would never be able to find a good job. Anyhow I took a look at the jobs posted by on jobcareer. I was looking for a job after matriculation<br> due to some personal and domestic issues. I found a job but they did not pay me well. I thought I would never be able<br> to find a good job. Anyhow I took a look at the jobs posted by jobcareer.","testimonial_author":"Ricky Price","testimonial_company":"ChimpStudio","testimonial_img_user":{"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/Testimonial-image-2.jpg","id":18920,"alt":"","source":"library","size":""},"_id":"83855c7"}],"_padding":{"unit":"px","top":"60","right":"0","bottom":"60","left":"0","isLinked":false},"_element_vertical_align":"center","_background_background":"classic","_background_image":{"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/2015\/12\/testimonial-bg.jpg","id":1407,"alt":"","source":"library"},"_background_size":"cover"},"elements":[],"widgetType":"jobhunt_testimonials"}],"isInner":false}],"isInner":false},{"id":"a1fe411","elType":"section","settings":{"margin":{"unit":"px","top":"60","right":0,"bottom":"60","left":0,"isLinked":false}},"elements":[{"id":"1d3fe55","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"e208ef0","elType":"widget","settings":{"title":"AGENCIES AND IN HOUSE TEAMS","align":"center","typography_typography":"custom","typography_font_family":"Raleway","typography_font_weight":"600","title_color":"#424242","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_style":"normal","typography_letter_spacing":{"unit":"px","size":1,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"ac01875","elType":"widget","settings":{"carousel":[{"id":18941,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-11.png"},{"id":18940,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-10.png"},{"id":18939,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-9.jpg"},{"id":18938,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-8.jpg"},{"id":18937,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-7.jpg"},{"id":18936,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-6.jpg"}],"slides_to_show":"6","navigation":"none"},"elements":[],"widgetType":"image-carousel"},{"id":"e8688cb","elType":"widget","settings":{"carousel":[{"id":18944,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-14.png"},{"id":18943,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-13.png"},{"id":18942,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-12.png"},{"id":18935,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-5.jpg"},{"id":18934,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-4.png"},{"id":18933,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-3.png"}],"slides_to_show":"6","navigation":"none"},"elements":[],"widgetType":"image-carousel"},{"id":"b7faeab","elType":"widget","settings":{"carousel":[{"id":18932,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-2.png"},{"id":18931,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-1.jpg"},{"id":18930,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-18.png"},{"id":18929,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-17.png"},{"id":18928,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-16.png"},{"id":18927,"url":"https:\/\/jobcareer.chimpgroup.com\/elementor\/wp-content\/uploads\/client-logo-jobline-15.png"}],"slides_to_show":"6","navigation":"none"},"elements":[],"widgetType":"image-carousel"}],"isInner":false}],"isInner":false}]';
                            $data = json_decode($data);
                            $data_array = array();
                            foreach( $data as $key => $datavalue){
                                    if( $key == 5){
                                            $editor_value = $datavalue->elements[0]->elements[0]->settings->editor;
                                            $editor_value = str_replace('<h2 style="color: #fff !important;">', '<h2>', $editor_value);
                                            $editor_value = str_replace('<p style="color: #fff !important;">', '<p>', $editor_value);
                                            $editor_value = str_replace(array("\r", "\n"), '', $editor_value);
                                            $datavalue->elements[0]->elements[0]->settings->editor = $editor_value;
                                    }
                                    if( $key == 0){
                                            $datavalue = json_encode($datavalue);
                                            //pre($datavalue);
                                            $datavalue = str_replace('[rev_slider alias=\"homepage-1\" slidertitle=\"Homepage 1\"][\/rev_slider]', "[rev_slider alias='homepage-1' slidertitle='Homepage 1'][/rev_slider]", $datavalue);
                                            $datavalue = json_decode($datavalue);
                                            //pre($datavalue);
                                    }
                                    $data_array[]	= $datavalue;
                            }

                            $data = json_encode($data_array);
                            update_post_meta($frontpage_id, '_elementor_data', $data);
                        }
			$obj->action_return = true;
		} else {
			$obj->action_return = false;
		}
	}
}

add_action( 'cs_import_rev_sliders', 'cs_import_rev_slider_handle' );
if ( ! function_exists( 'cs_import_rev_slider_handle' ) ) {
	/**
	 * Import Revolution Slider content using Revolution slider's importer
	 *
	 * @param CS_Data_Importer $obj An instance of CS_Data_Importer class which contains different configurations.
	 */
	function cs_import_rev_slider_handle( $obj ) {
		if ( class_exists( 'RevSlider' ) ) {
			global $wp_filesystem;
			
			require_once ABSPATH . '/wp-admin/includes/file.php';
			
			$first_str_filename = $obj->demo_data_name . '-sliders';
			//$filename = $obj->wp_upload_dir_path . 'temp-' . $obj->demo_data_name . '-sliders.zip';

            $filename = cs_framework::plugin_dir() . 'include/demo-attachments/' . 'temp-' . $obj->demo_data_name . '-sliders.zip';
            if ( !file_exists( $filename ) ) {
                $filename = cs_framework::plugin_dir() . 'include/demo-attachments/' . 'temp-jobcareer-sliders.zip';
            }
			//if ( copy( $obj->sliders_data_path, $filename ) ) {
				WP_Filesystem();
                $unzipfile = unzip_file( $filename, $obj->wp_upload_dir_path . '/' . $first_str_filename . '/' );
				// Delete zip after completion.
				//unlink( $filename );
                                
			//}

			$path = $obj->wp_upload_dir_path . $obj->demo_data_name . '-sliders/';
            if(file_exists( $path.'slider_export.txt')){
				//$slider_data = $wp_filesystem->get_contents( $obj->sliders_data_path );
                //pre($slider_data);
				$wp_dp_cs_upload_dir = wp_upload_dir();
				//$slider_file = $wp_dp_cs_upload_dir['path'] . '/slider_data_' . time() . '.zip';
                $slider_file = $filename;
				//$wp_filesystem->put_contents( $slider_file, $slider_data );
				if ( file_exists( $slider_file ) ) {
                                    
					$slider = new RevSlider();
					$update_anim = isset( $obj->sliders_options[0] ) ? $obj->sliders_options[0] : false;
					$update_static = isset( $obj->sliders_options[1] ) ? $obj->sliders_options[1] : false;
					$update_navigation = isset( $obj->sliders_options[2] ) ? $obj->sliders_options[2] : false;
					$slider->importSliderFromPost( $update_anim, $update_static, $slider_file, false, false, $update_navigation );
				}
				// Delete slider conetnt file after import.
				//unlink( $slider_file );
			}else{
                            
				$sub_dir = $path. $obj->demo_data_name .'_sliders';
				if ( $dir = opendir( $sub_dir ) ) {
                                    
					// iterate over all demo directories
					while ( false !== ( $file = readdir( $dir ) ) ) {
                                            
						if ( $file != "." && $file != ".." ) {
                                                    
							$info = pathinfo( $file );
							if ( $file != "." && $file != ".." ) {
                                                            
								$info = pathinfo( $file );
								if ( $info["extension"] === 'zip' ) {
                                                                    
									$slider_data = $wp_filesystem->get_contents( $sub_dir . '/' . $file );
									$wp_dp_cs_upload_dir = wp_upload_dir();
									$slider_file = $wp_dp_cs_upload_dir['path'] . '/slider_data_' . time() . '.zip';
									$wp_filesystem->put_contents( $slider_file, $slider_data );
									if ( file_exists( $slider_file ) ) {
                                                                            
										$slider = new RevSlider();
										$update_anim = isset( $obj->sliders_options[0] ) ? $obj->sliders_options[0] : false;
										$update_static = isset( $obj->sliders_options[1] ) ? $obj->sliders_options[1] : false;
										$update_navigation = isset( $obj->sliders_options[2] ) ? $obj->sliders_options[2] : false;
										$slider->importSliderFromPost( $update_anim, $update_static, $slider_file, false, false, $update_navigation );
									}
									// Delete slider conetnt file after import.
									unlink( $slider_file );
								}
							}
						}
					}
				}
				closedir( $dir );
			}
			// Delete sliders folder after import.
			$wp_filesystem->rmdir( $path, true );
			$obj->action_return = true;
		} else {
			$obj->action_return = false;
		}
	}
}

add_action( 'cs_import_widgets', 'cs_import_widgets_handle' );
if ( ! function_exists( 'cs_import_widgets_handle' ) ) {
	/**
	 * Import Widgets
	 *
	 * @param CS_Data_Importer $obj An instance of CS_Data_Importer class which contains different configurations.
	 */
	function cs_import_widgets_handle( $obj ) {
		if ( class_exists( 'cs_widget_data' ) ) {
			cs_widget_data::cs_import_widget_data( $obj->widget_data_path );
			$obj->action_return = true;
		} else {
			$obj->action_return = false;
		}
	}
}
