<?php

namespace ContainerDCTsmrb;

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/*
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class Glpi_Kernel_KernelProductionContainer extends Container
{
    protected $targetDir;
    protected $parameters = [];
    protected \Closure $getService;

    public function __construct(private array $buildParameters = [], protected string $containerDir = __DIR__)
    {
        $this->targetDir = \dirname($containerDir);
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'kernel' => true,
            'logger' => true,
        ];
        $this->methodMap = [
            'event_dispatcher' => 'getEventDispatcherService',
            'http_kernel' => 'getHttpKernelService',
            'request_stack' => 'getRequestStackService',
            'router' => 'getRouterService',
        ];
        $this->fileMap = [
            'Glpi\\Controller\\Altcha\\ChallengeController' => 'getChallengeControllerService',
            'Glpi\\Controller\\ApiController' => 'getApiControllerService',
            'Glpi\\Controller\\ApiRestController' => 'getApiRestControllerService',
            'Glpi\\Controller\\CaldavController' => 'getCaldavControllerService',
            'Glpi\\Controller\\CentralController' => 'getCentralControllerService',
            'Glpi\\Controller\\Config\\Helpdesk\\AddTileController' => 'getAddTileControllerService',
            'Glpi\\Controller\\Config\\Helpdesk\\CopyParentEntityController' => 'getCopyParentEntityControllerService',
            'Glpi\\Controller\\Config\\Helpdesk\\DeleteTileController' => 'getDeleteTileControllerService',
            'Glpi\\Controller\\Config\\Helpdesk\\SetTilesOrderController' => 'getSetTilesOrderControllerService',
            'Glpi\\Controller\\Config\\Helpdesk\\ShowAddTileFormController' => 'getShowAddTileFormControllerService',
            'Glpi\\Controller\\Config\\Helpdesk\\ShowEditTileFormController' => 'getShowEditTileFormControllerService',
            'Glpi\\Controller\\Config\\Helpdesk\\UpdateTileController' => 'getUpdateTileControllerService',
            'Glpi\\Controller\\DropdownFormController' => 'getDropdownFormControllerService',
            'Glpi\\Controller\\ErrorController' => 'getErrorControllerService',
            'Glpi\\Controller\\Form\\AllowListDropdown\\CountUsersController' => 'getCountUsersControllerService',
            'Glpi\\Controller\\Form\\Condition\\EditorController' => 'getEditorControllerService',
            'Glpi\\Controller\\Form\\Condition\\EngineController' => 'getEngineControllerService',
            'Glpi\\Controller\\Form\\DelegationController' => 'getDelegationControllerService',
            'Glpi\\Controller\\Form\\Destination\\AddDestinationController' => 'getAddDestinationControllerService',
            'Glpi\\Controller\\Form\\Destination\\PurgeDestinationController' => 'getPurgeDestinationControllerService',
            'Glpi\\Controller\\Form\\Destination\\UpdateDestinationController' => 'getUpdateDestinationControllerService',
            'Glpi\\Controller\\Form\\ExportController' => 'getExportControllerService',
            'Glpi\\Controller\\Form\\Import\\Step1IndexController' => 'getStep1IndexControllerService',
            'Glpi\\Controller\\Form\\Import\\Step2PreviewController' => 'getStep2PreviewControllerService',
            'Glpi\\Controller\\Form\\Import\\Step3ResolveIssuesController' => 'getStep3ResolveIssuesControllerService',
            'Glpi\\Controller\\Form\\Import\\Step4ExecuteController' => 'getStep4ExecuteControllerService',
            'Glpi\\Controller\\Form\\QuestionActorsDropdownController' => 'getQuestionActorsDropdownControllerService',
            'Glpi\\Controller\\Form\\RendererController' => 'getRendererControllerService',
            'Glpi\\Controller\\Form\\SubmitAnswerController' => 'getSubmitAnswerControllerService',
            'Glpi\\Controller\\Form\\TagListController' => 'getTagListControllerService',
            'Glpi\\Controller\\Form\\Translation\\AddNewFormTranslationController' => 'getAddNewFormTranslationControllerService',
            'Glpi\\Controller\\Form\\Translation\\DeleteFormTranslationController' => 'getDeleteFormTranslationControllerService',
            'Glpi\\Controller\\Form\\Translation\\UpdateFormTranslationController' => 'getUpdateFormTranslationControllerService',
            'Glpi\\Controller\\Form\\ValidateAnswerController' => 'getValidateAnswerControllerService',
            'Glpi\\Controller\\GenericAjaxCrudController' => 'getGenericAjaxCrudControllerService',
            'Glpi\\Controller\\GenericFormController' => 'getGenericFormControllerService',
            'Glpi\\Controller\\GenericListController' => 'getGenericListControllerService',
            'Glpi\\Controller\\Helpdesk\\IndexController' => 'getIndexControllerService',
            'Glpi\\Controller\\Helpdesk\\SearchController' => 'getSearchControllerService',
            'Glpi\\Controller\\Helpdesk\\Translation\\AddNewHelpdeskTranslationController' => 'getAddNewHelpdeskTranslationControllerService',
            'Glpi\\Controller\\Helpdesk\\Translation\\DeleteHelpdeskTranslationController' => 'getDeleteHelpdeskTranslationControllerService',
            'Glpi\\Controller\\Helpdesk\\Translation\\UpdateHelpdeskTranslationController' => 'getUpdateHelpdeskTranslationControllerService',
            'Glpi\\Controller\\IndexController' => 'getIndexController2Service',
            'Glpi\\Controller\\InstallController' => 'getInstallControllerService',
            'Glpi\\Controller\\InventoryController' => 'getInventoryControllerService',
            'Glpi\\Controller\\ItemType\\Form\\AuthMailFormController' => 'getAuthMailFormControllerService',
            'Glpi\\Controller\\ItemType\\Form\\ContactFormController' => 'getContactFormControllerService',
            'Glpi\\Controller\\ItemType\\Form\\MailCollectorFormController' => 'getMailCollectorFormControllerService',
            'Glpi\\Controller\\ItemType\\Form\\SavedSearchFormController' => 'getSavedSearchFormControllerService',
            'Glpi\\Controller\\Knowbase\\KnowbaseItemController' => 'getKnowbaseItemControllerService',
            'Glpi\\Controller\\LegacyFileLoadController' => 'getLegacyFileLoadControllerService',
            'Glpi\\Controller\\MaintenanceController' => 'getMaintenanceControllerService',
            'Glpi\\Controller\\Plugin\\LogoController' => 'getLogoControllerService',
            'Glpi\\Controller\\ProgressController' => 'getProgressControllerService',
            'Glpi\\Controller\\Security\\MFAController' => 'getMFAControllerService',
            'Glpi\\Controller\\ServiceCatalog\\IndexController' => 'getIndexController3Service',
            'Glpi\\Controller\\ServiceCatalog\\ItemsController' => 'getItemsControllerService',
            'Glpi\\Controller\\Session\\ChangeEntityController' => 'getChangeEntityControllerService',
            'Glpi\\Controller\\Session\\ChangeProfileController' => 'getChangeProfileControllerService',
            'Glpi\\Controller\\StatusController' => 'getStatusControllerService',
            'Glpi\\Controller\\UI\\Illustration\\CustomIllustrationController' => 'getCustomIllustrationControllerService',
            'Glpi\\Controller\\UI\\Illustration\\CustomSceneController' => 'getCustomSceneControllerService',
            'Glpi\\Controller\\UI\\Illustration\\SearchController' => 'getSearchController2Service',
            'Glpi\\Controller\\UI\\Illustration\\UploadController' => 'getUploadControllerService',
            'Glpi\\Controller\\WellKnownController' => 'getWellKnownControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\RedirectController' => 'getRedirectControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController' => 'getTemplateControllerService',
            'cache.app' => 'getCache_AppService',
            'cache.app_clearer' => 'getCache_AppClearerService',
            'cache.global_clearer' => 'getCache_GlobalClearerService',
            'cache.system' => 'getCache_SystemService',
            'cache.system_clearer' => 'getCache_SystemClearerService',
            'cache_warmer' => 'getCacheWarmerService',
            'console.command_loader' => 'getConsole_CommandLoaderService',
            'container.env_var_processors_locator' => 'getContainer_EnvVarProcessorsLocatorService',
            'container.get_routing_condition_service' => 'getContainer_GetRoutingConditionServiceService',
            'debug.error_handler_configurator' => 'getDebug_ErrorHandlerConfiguratorService',
            'error_controller' => 'getErrorController2Service',
            'routing.loader' => 'getRouting_LoaderService',
            'services_resetter' => 'getServicesResetterService',
        ];
        $this->aliases = [
            'Glpi\\Kernel\\Kernel' => 'kernel',
        ];
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return require $this->containerDir.\DIRECTORY_SEPARATOR.'removed-ids.php';
    }

    protected function load($file, $lazyLoad = true): mixed
    {
        if (class_exists($class = __NAMESPACE__.'\\'.$file, false)) {
            return $class::do($this, $lazyLoad);
        }

        if ('.' === $file[-4]) {
            $class = substr($class, 0, -4);
        } else {
            $file .= '.php';
        }

        $service = require $this->containerDir.\DIRECTORY_SEPARATOR.$file;

        return class_exists($class, false) ? $class::do($this, $lazyLoad) : $service;
    }

    protected function createProxy($class, \Closure $factory)
    {
        class_exists($class, false) || require __DIR__.'/'.$class.'.php';

        return $factory();
    }

    /*
     * Gets the public 'event_dispatcher' shared service.
     *
     * @return \Symfony\Component\EventDispatcher\EventDispatcher
     */
    protected static function getEventDispatcherService($container)
    {
        $container->services['event_dispatcher'] = $instance = new \Symfony\Component\EventDispatcher\EventDispatcher();

        $instance->addListener('kernel.controller', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\ControllerListener\\CheckCsrfListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\ControllerListener\\CheckCsrfListener'] ?? self::getCheckCsrfListenerService($container)), 'onKernelController'], 0);
        $instance->addListener('kernel.controller', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\ControllerListener\\FirewallStrategyListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\ControllerListener\\FirewallStrategyListener'] ?? self::getFirewallStrategyListenerService($container)), 'onKernelController'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\ExceptionListener\\AccessErrorListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\ExceptionListener\\AccessErrorListener'] ??= new \Glpi\Kernel\Listener\ExceptionListener\AccessErrorListener()), 'onKernelException'], 1);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\ExceptionListener\\ProgressErrorListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\ExceptionListener\\ProgressErrorListener'] ?? $container->load('getProgressErrorListenerService')), 'onKernelException'], 1);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\ExceptionListener\\RedirectExceptionListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\ExceptionListener\\RedirectExceptionListener'] ??= new \Glpi\Kernel\Listener\ExceptionListener\RedirectExceptionListener()), 'onKernelException'], 1);
        $instance->addListener('Glpi\\Kernel\\PostBootEvent', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\PostBootListener\\BootPlugins')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\PostBootListener\\BootPlugins'] ??= new \Glpi\Kernel\Listener\PostBootListener\BootPlugins()), 'onPostBoot'], 140);
        $instance->addListener('Glpi\\Kernel\\PostBootEvent', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\PostBootListener\\CheckPluginsStates')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\PostBootListener\\CheckPluginsStates'] ??= new \Glpi\Kernel\Listener\PostBootListener\CheckPluginsStates()), 'onPostBoot'], 150);
        $instance->addListener('Glpi\\Kernel\\PostBootEvent', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\PostBootListener\\CustomObjectsAutoloaderRegistration')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\PostBootListener\\CustomObjectsAutoloaderRegistration'] ??= new \Glpi\Kernel\Listener\PostBootListener\CustomObjectsAutoloaderRegistration()), 'onPostBoot'], 160);
        $instance->addListener('Glpi\\Kernel\\PostBootEvent', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\PostBootListener\\CustomObjectsBoot')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\PostBootListener\\CustomObjectsBoot'] ??= new \Glpi\Kernel\Listener\PostBootListener\CustomObjectsBoot()), 'onPostBoot'], 100);
        $instance->addListener('Glpi\\Kernel\\PostBootEvent', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\PostBootListener\\FlushBootErrors')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\PostBootListener\\FlushBootErrors'] ??= new \Glpi\Kernel\Listener\PostBootListener\FlushBootErrors()), 'onPostBoot'], 125);
        $instance->addListener('Glpi\\Kernel\\PostBootEvent', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\PostBootListener\\InitializeCache')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\PostBootListener\\InitializeCache'] ??= new \Glpi\Kernel\Listener\PostBootListener\InitializeCache()), 'onPostBoot'], 180);
        $instance->addListener('Glpi\\Kernel\\PostBootEvent', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\PostBootListener\\InitializeDbConnection')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\PostBootListener\\InitializeDbConnection'] ??= new \Glpi\Kernel\Listener\PostBootListener\InitializeDbConnection()), 'onPostBoot'], 190);
        $instance->addListener('Glpi\\Kernel\\PostBootEvent', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\PostBootListener\\InitializePlugins')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\PostBootListener\\InitializePlugins'] ?? $container->load('getInitializePluginsService')), 'onPostBoot'], 110);
        $instance->addListener('Glpi\\Kernel\\PostBootEvent', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\PostBootListener\\LoadLanguage')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\PostBootListener\\LoadLanguage'] ??= new \Glpi\Kernel\Listener\PostBootListener\LoadLanguage()), 'onPostBoot'], 120);
        $instance->addListener('Glpi\\Kernel\\PostBootEvent', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\PostBootListener\\LoadLegacyConfiguration')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\PostBootListener\\LoadLegacyConfiguration'] ??= new \Glpi\Kernel\Listener\PostBootListener\LoadLegacyConfiguration()), 'onPostBoot'], 170);
        $instance->addListener('Glpi\\Kernel\\PostBootEvent', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\PostBootListener\\ProfilerStart')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\PostBootListener\\ProfilerStart'] ??= new \Glpi\Kernel\Listener\PostBootListener\ProfilerStart()), 'onPostBoot'], 200);
        $instance->addListener('Glpi\\Kernel\\PostBootEvent', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\PostBootListener\\SessionStart')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\PostBootListener\\SessionStart'] ?? $container->load('getSessionStartService')), 'onPostBoot'], 130);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\RequestListener\\CatchInventoryAgentRequestListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\RequestListener\\CatchInventoryAgentRequestListener'] ??= new \Glpi\Kernel\Listener\RequestListener\CatchInventoryAgentRequestListener()), 'onKernelRequest'], 420);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\RequestListener\\CheckDatabaseStatusListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\RequestListener\\CheckDatabaseStatusListener'] ??= new \Glpi\Kernel\Listener\RequestListener\CheckDatabaseStatusListener()), 'onKernelRequest'], 450);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\RequestListener\\CheckMaintenanceListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\RequestListener\\CheckMaintenanceListener'] ??= new \Glpi\Kernel\Listener\RequestListener\CheckMaintenanceListener()), 'onKernelRequest'], 490);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\RequestListener\\ErrorHandlerRequestListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\RequestListener\\ErrorHandlerRequestListener'] ??= new \Glpi\Kernel\Listener\RequestListener\ErrorHandlerRequestListener()), 'onRequest'], 1000);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\RequestListener\\FrontEndAssetsListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\RequestListener\\FrontEndAssetsListener'] ??= new \Glpi\Kernel\Listener\RequestListener\FrontEndAssetsListener(\dirname(__DIR__, 5))), 'onKernelRequest'], 500);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\RequestListener\\LegacyItemtypeRouteListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\RequestListener\\LegacyItemtypeRouteListener'] ?? self::getLegacyItemtypeRouteListenerService($container)), 'onKernelRequest'], 350);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\RequestListener\\LegacyRouterListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\RequestListener\\LegacyRouterListener'] ??= new \Glpi\Kernel\Listener\RequestListener\LegacyRouterListener(\dirname(__DIR__, 5))), 'onKernelRequest'], 400);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\RequestListener\\PluginsRouterListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\RequestListener\\PluginsRouterListener'] ?? self::getPluginsRouterListenerService($container)), 'onKernelRequest'], 375);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\RequestListener\\RedirectLegacyRouteListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\RequestListener\\RedirectLegacyRouteListener'] ??= new \Glpi\Kernel\Listener\RequestListener\RedirectLegacyRouteListener()), 'onKernelRequest'], 33);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\RequestListener\\SessionCheckCookieListener')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\RequestListener\\SessionCheckCookieListener'] ??= new \Glpi\Kernel\Listener\RequestListener\SessionCheckCookieListener()), 'onKernelRequest'], 475);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Glpi\\Kernel\\Listener\\RequestListener\\SessionVariables')] fn () => ($container->privates['Glpi\\Kernel\\Listener\\RequestListener\\SessionVariables'] ??= new \Glpi\Kernel\Listener\RequestListener\SessionVariables()), 'onKernelRequest'], 0);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'argument_resolver.request_payload', class: 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver')] fn () => ($container->privates['argument_resolver.request_payload'] ?? self::getArgumentResolver_RequestPayloadService($container)), 'onKernelControllerArguments'], 0);
        $instance->addListener('kernel.response', [#[\Closure(name: 'response_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ResponseListener')] fn () => ($container->privates['response_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\ResponseListener('UTF-8', false)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'setDefaultLocale'], 100);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'onKernelRequest'], 16);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'validate_request_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ValidateRequestListener')] fn () => ($container->privates['validate_request_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\ValidateRequestListener()), 'onKernelRequest'], 256);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'onControllerArguments'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'logKernelException'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'onKernelException'], -128);
        $instance->addListener('kernel.response', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'removeCspHeader'], -128);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'controller.cache_attribute_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\CacheAttributeListener')] fn () => ($container->privates['controller.cache_attribute_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\CacheAttributeListener()), 'onKernelControllerArguments'], 10);
        $instance->addListener('kernel.response', [#[\Closure(name: 'controller.cache_attribute_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\CacheAttributeListener')] fn () => ($container->privates['controller.cache_attribute_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\CacheAttributeListener()), 'onKernelResponse'], -10);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_aware_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleAwareListener')] fn () => ($container->privates['locale_aware_listener'] ?? self::getLocaleAwareListenerService($container)), 'onKernelRequest'], 15);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'locale_aware_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleAwareListener')] fn () => ($container->privates['locale_aware_listener'] ?? self::getLocaleAwareListenerService($container)), 'onKernelFinishRequest'], -15);
        $instance->addListener('console.error', [#[\Closure(name: 'console.error_listener', class: 'Symfony\\Component\\Console\\EventListener\\ErrorListener')] fn () => ($container->privates['console.error_listener'] ??= new \Symfony\Component\Console\EventListener\ErrorListener(($container->services['logger'] ?? $container->get('logger', 2)))), 'onConsoleError'], -128);
        $instance->addListener('console.terminate', [#[\Closure(name: 'console.error_listener', class: 'Symfony\\Component\\Console\\EventListener\\ErrorListener')] fn () => ($container->privates['console.error_listener'] ??= new \Symfony\Component\Console\EventListener\ErrorListener(($container->services['logger'] ?? $container->get('logger', 2)))), 'onConsoleTerminate'], -128);
        $instance->addListener('console.error', [#[\Closure(name: 'console.suggest_missing_package_subscriber', class: 'Symfony\\Bundle\\FrameworkBundle\\EventListener\\SuggestMissingPackageSubscriber')] fn () => ($container->privates['console.suggest_missing_package_subscriber'] ??= new \Symfony\Bundle\FrameworkBundle\EventListener\SuggestMissingPackageSubscriber()), 'onConsoleError'], 0);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'mailer.envelope_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\EnvelopeListener')] fn () => ($container->privates['mailer.envelope_listener'] ??= new \Symfony\Component\Mailer\EventListener\EnvelopeListener(NULL, NULL)), 'onMessage'], -255);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'mailer.message_logger_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\MessageLoggerListener')] fn () => ($container->privates['mailer.message_logger_listener'] ??= new \Symfony\Component\Mailer\EventListener\MessageLoggerListener()), 'onMessage'], -255);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'mailer.messenger_transport_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\MessengerTransportListener')] fn () => ($container->privates['mailer.messenger_transport_listener'] ??= new \Symfony\Component\Mailer\EventListener\MessengerTransportListener()), 'onMessage'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'debug.debug_handlers_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\DebugHandlersListener')] fn () => ($container->privates['debug.debug_handlers_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener(NULL, $container->getEnv('bool:default::key:web:default:kernel.runtime_mode:'))), 'configure'], 2048);
        $instance->addListener('console.command', [#[\Closure(name: 'debug.debug_handlers_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\DebugHandlersListener')] fn () => ($container->privates['debug.debug_handlers_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener(NULL, $container->getEnv('bool:default::key:web:default:kernel.runtime_mode:'))), 'configure'], 2048);
        $instance->addListener('kernel.request', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelRequest'], 32);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelException'], -64);

        return $instance;
    }

    /*
     * Gets the public 'http_kernel' shared service.
     *
     * @return \Symfony\Component\HttpKernel\HttpKernel
     */
    protected static function getHttpKernelService($container)
    {
        $a = new \Symfony\Bundle\FrameworkBundle\Controller\ControllerResolver($container, ($container->services['logger'] ?? $container->get('logger', 3)));
        $a->allowControllers(['Symfony\\Bundle\\FrameworkBundle\\Controller\\AbstractController', 'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController']);
        $a->allowControllers(['Glpi\\Kernel\\Kernel']);

        return $container->services['http_kernel'] = new \Symfony\Component\HttpKernel\HttpKernel(($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), $a, ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), new \Symfony\Component\HttpKernel\Controller\ArgumentResolver(new \Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadataFactory(), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['argument_resolver.backed_enum_resolver'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\BackedEnumValueResolver());
            yield 1 => ($container->privates['argument_resolver.datetime'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\DateTimeValueResolver(NULL));
            yield 2 => ($container->privates['argument_resolver.request_attribute'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestAttributeValueResolver());
            yield 3 => ($container->privates['argument_resolver.request'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestValueResolver());
            yield 4 => ($container->privates['argument_resolver.session'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\SessionValueResolver());
            yield 5 => ($container->privates['argument_resolver.service'] ?? $container->load('getArgumentResolver_ServiceService'));
            yield 6 => ($container->privates['argument_resolver.default'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\DefaultValueResolver());
            yield 7 => ($container->privates['argument_resolver.variadic'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\VariadicValueResolver());
        }, 8), new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\BackedEnumValueResolver' => ['privates', 'argument_resolver.backed_enum_resolver', 'getArgumentResolver_BackedEnumResolverService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DateTimeValueResolver' => ['privates', 'argument_resolver.datetime', 'getArgumentResolver_DatetimeService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DefaultValueResolver' => ['privates', 'argument_resolver.default', 'getArgumentResolver_DefaultService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\QueryParameterValueResolver' => ['privates', 'argument_resolver.query_parameter_value_resolver', 'getArgumentResolver_QueryParameterValueResolverService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestAttributeValueResolver' => ['privates', 'argument_resolver.request_attribute', 'getArgumentResolver_RequestAttributeService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver' => ['privates', 'argument_resolver.request_payload', 'getArgumentResolver_RequestPayloadService', false],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestValueResolver' => ['privates', 'argument_resolver.request', 'getArgumentResolver_RequestService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\ServiceValueResolver' => ['privates', 'argument_resolver.service', 'getArgumentResolver_ServiceService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\SessionValueResolver' => ['privates', 'argument_resolver.session', 'getArgumentResolver_SessionService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\VariadicValueResolver' => ['privates', 'argument_resolver.variadic', 'getArgumentResolver_VariadicService', true],
        ], [
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\BackedEnumValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\BackedEnumValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DateTimeValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DateTimeValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DefaultValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DefaultValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\QueryParameterValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\QueryParameterValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestAttributeValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestAttributeValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\ServiceValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\ServiceValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\SessionValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\SessionValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\VariadicValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\VariadicValueResolver',
        ])), false);
    }

    /*
     * Gets the public 'request_stack' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\RequestStack
     */
    protected static function getRequestStackService($container)
    {
        return $container->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack();
    }

    /*
     * Gets the public 'router' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Routing\Router
     */
    protected static function getRouterService($container)
    {
        $container->services['router'] = $instance = new \Symfony\Bundle\FrameworkBundle\Routing\Router((new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'routing.loader' => ['services', 'routing.loader', 'getRouting_LoaderService', true],
        ], [
            'routing.loader' => 'Symfony\\Component\\Config\\Loader\\LoaderInterface',
        ]))->withContext('router.default', $container), 'kernel::loadRoutes', ['cache_dir' => $container->targetDir.'', 'debug' => false, 'generator_class' => 'Symfony\\Component\\Routing\\Generator\\CompiledUrlGenerator', 'generator_dumper_class' => 'Symfony\\Component\\Routing\\Generator\\Dumper\\CompiledUrlGeneratorDumper', 'matcher_class' => 'Symfony\\Bundle\\FrameworkBundle\\Routing\\RedirectableCompiledUrlMatcher', 'matcher_dumper_class' => 'Symfony\\Component\\Routing\\Matcher\\Dumper\\CompiledUrlMatcherDumper', 'strict_requirements' => true, 'resource_type' => 'service'], ($container->privates['router.request_context'] ?? self::getRouter_RequestContextService($container)), ($container->privates['parameter_bag'] ??= new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($container)), ($container->services['logger'] ?? $container->get('logger', 3)), 'en');

        $instance->setConfigCacheFactory(new \Symfony\Component\Config\ResourceCheckerConfigCacheFactory());

        return $instance;
    }

    /*
     * Gets the private 'Glpi\DependencyInjection\PluginContainer' shared autowired service.
     *
     * @return \Glpi\DependencyInjection\PluginContainer
     */
    protected static function getPluginContainerService($container)
    {
        return $container->privates['Glpi\\DependencyInjection\\PluginContainer'] = new \Glpi\DependencyInjection\PluginContainer($container, ($container->privates['parameter_bag'] ??= new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($container)), ($container->services['kernel'] ?? $container->get('kernel', 1)));
    }

    /*
     * Gets the private 'Glpi\Kernel\Listener\ControllerListener\CheckCsrfListener' shared autowired service.
     *
     * @return \Glpi\Kernel\Listener\ControllerListener\CheckCsrfListener
     */
    protected static function getCheckCsrfListenerService($container)
    {
        return $container->privates['Glpi\\Kernel\\Listener\\ControllerListener\\CheckCsrfListener'] = new \Glpi\Kernel\Listener\ControllerListener\CheckCsrfListener(($container->privates['Glpi\\Http\\SessionManager'] ??= new \Glpi\Http\SessionManager()));
    }

    /*
     * Gets the private 'Glpi\Kernel\Listener\ControllerListener\FirewallStrategyListener' shared autowired service.
     *
     * @return \Glpi\Kernel\Listener\ControllerListener\FirewallStrategyListener
     */
    protected static function getFirewallStrategyListenerService($container)
    {
        return $container->privates['Glpi\\Kernel\\Listener\\ControllerListener\\FirewallStrategyListener'] = new \Glpi\Kernel\Listener\ControllerListener\FirewallStrategyListener(new \Glpi\Http\Firewall(), ($container->privates['Glpi\\Http\\SessionManager'] ??= new \Glpi\Http\SessionManager()));
    }

    /*
     * Gets the private 'Glpi\Kernel\Listener\RequestListener\LegacyItemtypeRouteListener' shared autowired service.
     *
     * @return \Glpi\Kernel\Listener\RequestListener\LegacyItemtypeRouteListener
     */
    protected static function getLegacyItemtypeRouteListenerService($container)
    {
        return $container->privates['Glpi\\Kernel\\Listener\\RequestListener\\LegacyItemtypeRouteListener'] = new \Glpi\Kernel\Listener\RequestListener\LegacyItemtypeRouteListener(($container->services['router'] ?? self::getRouterService($container)));
    }

    /*
     * Gets the private 'Glpi\Kernel\Listener\RequestListener\PluginsRouterListener' shared autowired service.
     *
     * @return \Glpi\Kernel\Listener\RequestListener\PluginsRouterListener
     */
    protected static function getPluginsRouterListenerService($container)
    {
        return $container->privates['Glpi\\Kernel\\Listener\\RequestListener\\PluginsRouterListener'] = new \Glpi\Kernel\Listener\RequestListener\PluginsRouterListener(($container->privates['Glpi\\DependencyInjection\\PluginContainer'] ?? self::getPluginContainerService($container)));
    }

    /*
     * Gets the private 'argument_resolver.request_payload' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestPayloadValueResolver
     */
    protected static function getArgumentResolver_RequestPayloadService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['argument_resolver.request_payload'] = $container->createProxy('RequestPayloadValueResolverGhost5dabe4a', static fn () => \RequestPayloadValueResolverGhost5dabe4a::createLazyGhost(static fn ($proxy) => self::getArgumentResolver_RequestPayloadService($container, $proxy)));
        }

        return ($lazyLoad->__construct(($container->privates['serializer'] ?? self::getSerializerService($container)), NULL, NULL) && false ?: $lazyLoad);
    }

    /*
     * Gets the private 'cache.property_access' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_PropertyAccessService($container)
    {
        return $container->privates['cache.property_access'] = \Symfony\Component\PropertyAccess\PropertyAccessor::createCache('tn2SJ4nWA6', 0, $container->getParameter('container.build_id'), ($container->services['logger'] ?? $container->get('logger', 3)));
    }

    /*
     * Gets the private 'cache.property_info' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_PropertyInfoService($container)
    {
        return $container->privates['cache.property_info'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('APREx3efd6', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->services['logger'] ?? $container->get('logger', 3)));
    }

    /*
     * Gets the private 'cache.serializer' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_SerializerService($container)
    {
        return $container->privates['cache.serializer'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('V92SABXHbB', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->services['logger'] ?? $container->get('logger', 3)));
    }

    /*
     * Gets the private 'exception_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\ErrorListener
     */
    protected static function getExceptionListenerService($container)
    {
        return $container->privates['exception_listener'] = new \Symfony\Component\HttpKernel\EventListener\ErrorListener('Glpi\\Controller\\ErrorController', ($container->services['logger'] ?? $container->get('logger', 2)), false, []);
    }

    /*
     * Gets the private 'locale_aware_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener
     */
    protected static function getLocaleAwareListenerService($container)
    {
        return $container->privates['locale_aware_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['slugger'] ??= new \Symfony\Component\String\Slugger\AsciiSlugger('en'));
        }, 1), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));
    }

    /*
     * Gets the private 'locale_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleListener
     */
    protected static function getLocaleListenerService($container)
    {
        return $container->privates['locale_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleListener(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), 'en', ($container->services['router'] ?? self::getRouterService($container)), false, []);
    }

    /*
     * Gets the private 'mime_types' shared service.
     *
     * @return \Symfony\Component\Mime\MimeTypes
     */
    protected static function getMimeTypesService($container)
    {
        $container->privates['mime_types'] = $instance = new \Symfony\Component\Mime\MimeTypes();

        $instance->setDefault($instance);

        return $instance;
    }

    /*
     * Gets the private 'router.request_context' shared service.
     *
     * @return \Symfony\Component\Routing\RequestContext
     */
    protected static function getRouter_RequestContextService($container)
    {
        return $container->privates['router.request_context'] = \Symfony\Component\Routing\RequestContext::fromUri('', 'localhost', 'http', 80, 443);
    }

    /*
     * Gets the private 'router_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\RouterListener
     */
    protected static function getRouterListenerService($container)
    {
        return $container->privates['router_listener'] = new \Symfony\Component\HttpKernel\EventListener\RouterListener(($container->services['router'] ?? self::getRouterService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->privates['router.request_context'] ?? self::getRouter_RequestContextService($container)), ($container->services['logger'] ?? $container->get('logger', 3)), \dirname(__DIR__, 5), false);
    }

    /*
     * Gets the private 'serializer' shared service.
     *
     * @return \Symfony\Component\Serializer\Serializer
     */
    protected static function getSerializerService($container)
    {
        $a = ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());

        $b = new \Symfony\Component\PropertyAccess\PropertyAccessor(3, 2, ($container->privates['cache.property_access'] ?? self::getCache_PropertyAccessService($container)), $a, $a);
        $c = ($container->privates['serializer.mapping.cache_class_metadata_factory'] ?? self::getSerializer_Mapping_CacheClassMetadataFactoryService($container));

        $d = new \Symfony\Component\Serializer\NameConverter\MetadataAwareNameConverter($c);
        $e = new \Symfony\Component\PropertyInfo\PropertyInfoCacheExtractor(new \Symfony\Component\PropertyInfo\PropertyInfoExtractor(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.serializer_extractor'] ?? $container->load('getPropertyInfo_SerializerExtractorService'));
            yield 1 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 2), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.phpstan_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\PhpStanExtractor());
            yield 1 => ($container->privates['property_info.php_doc_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\PhpDocExtractor());
            yield 2 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 3), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.php_doc_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\PhpDocExtractor());
        }, 1), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 1), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 1)), ($container->privates['cache.property_info'] ?? self::getCache_PropertyInfoService($container)));
        $f = new \Symfony\Component\Serializer\Mapping\ClassDiscriminatorFromClassMetadata($c);

        return $container->privates['serializer'] = new \Symfony\Component\Serializer\Serializer([new \Symfony\Component\Serializer\Normalizer\UnwrappingDenormalizer($b), new \Symfony\Component\Serializer\Normalizer\ProblemNormalizer(false, translator: NULL), new \Symfony\Component\Serializer\Normalizer\UidNormalizer(), new \Symfony\Component\Serializer\Normalizer\DateTimeNormalizer(), new \Symfony\Component\Serializer\Normalizer\ConstraintViolationListNormalizer([], $d), new \Symfony\Component\Serializer\Normalizer\MimeMessageNormalizer(new \Symfony\Component\Serializer\Normalizer\PropertyNormalizer($c, $d, $e, $f, NULL, [])), new \Symfony\Component\Serializer\Normalizer\DateTimeZoneNormalizer(), new \Symfony\Component\Serializer\Normalizer\DateIntervalNormalizer(), new \Symfony\Component\Serializer\Normalizer\FormErrorNormalizer(), new \Symfony\Component\Serializer\Normalizer\BackedEnumNormalizer(), new \Symfony\Component\Serializer\Normalizer\DataUriNormalizer(($container->privates['mime_types'] ?? self::getMimeTypesService($container))), new \Symfony\Component\Serializer\Normalizer\JsonSerializableNormalizer(NULL, NULL), new \Symfony\Component\Serializer\Normalizer\ArrayDenormalizer(), new \Symfony\Component\Serializer\Normalizer\ObjectNormalizer($c, $d, $b, $e, $f, NULL, [], $e)], [new \Symfony\Component\Serializer\Encoder\XmlEncoder(), new \Symfony\Component\Serializer\Encoder\JsonEncoder(NULL, NULL), new \Symfony\Component\Serializer\Encoder\CsvEncoder()], []);
    }

    /*
     * Gets the private 'serializer.mapping.cache_class_metadata_factory' shared service.
     *
     * @return \Symfony\Component\Serializer\Mapping\Factory\CacheClassMetadataFactory
     */
    protected static function getSerializer_Mapping_CacheClassMetadataFactoryService($container)
    {
        return $container->privates['serializer.mapping.cache_class_metadata_factory'] = new \Symfony\Component\Serializer\Mapping\Factory\CacheClassMetadataFactory(new \Symfony\Component\Serializer\Mapping\Factory\ClassMetadataFactory(new \Symfony\Component\Serializer\Mapping\Loader\LoaderChain([new \Symfony\Component\Serializer\Mapping\Loader\AttributeLoader(NULL)])), \Symfony\Component\Cache\Adapter\PhpArrayAdapter::create(($container->targetDir.''.'/serialization.php'), ($container->privates['cache.serializer'] ?? self::getCache_SerializerService($container))));
    }

    public function getParameter(string $name): array|bool|string|int|float|\UnitEnum|null
    {
        if (isset($this->buildParameters[$name])) {
            return $this->buildParameters[$name];
        }

        if (!(isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters))) {
            throw new ParameterNotFoundException($name);
        }
        if (isset($this->loadedDynamicParameters[$name])) {
            return $this->loadedDynamicParameters[$name] ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
        }

        return $this->parameters[$name];
    }

    public function hasParameter(string $name): bool
    {
        if (isset($this->buildParameters[$name])) {
            return true;
        }

        return isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters);
    }

    public function setParameter(string $name, $value): void
    {
        throw new LogicException('Impossible to call set() on a frozen ParameterBag.');
    }

    public function getParameterBag(): ParameterBagInterface
    {
        if (!isset($this->parameterBag)) {
            $parameters = $this->parameters;
            foreach ($this->loadedDynamicParameters as $name => $loaded) {
                $parameters[$name] = $loaded ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
            }
            foreach ($this->buildParameters as $name => $value) {
                $parameters[$name] = $value;
            }
            $this->parameterBag = new FrozenParameterBag($parameters);
        }

        return $this->parameterBag;
    }

    private $loadedDynamicParameters = [
        'kernel.runtime_environment' => false,
        'kernel.runtime_mode' => false,
        'kernel.runtime_mode.web' => false,
        'kernel.runtime_mode.cli' => false,
        'kernel.runtime_mode.worker' => false,
        'kernel.build_dir' => false,
        'kernel.cache_dir' => false,
        'kernel.secret' => false,
        'router.cache_dir' => false,
        'serializer.mapping.cache.file' => false,
    ];
    private $dynamicParameters = [];

    private function getDynamicParameter(string $name)
    {
        $container = $this;
        $value = match ($name) {
            'kernel.runtime_environment' => $container->getEnv('default:kernel.environment:APP_RUNTIME_ENV'),
            'kernel.runtime_mode' => $container->getEnv('query_string:default:container.runtime_mode:APP_RUNTIME_MODE'),
            'kernel.runtime_mode.web' => $container->getEnv('bool:default::key:web:default:kernel.runtime_mode:'),
            'kernel.runtime_mode.cli' => $container->getEnv('not:default:kernel.runtime_mode.web:'),
            'kernel.runtime_mode.worker' => $container->getEnv('bool:default::key:worker:default:kernel.runtime_mode:'),
            'kernel.build_dir' => $container->targetDir.'',
            'kernel.cache_dir' => $container->targetDir.'',
            'kernel.secret' => $container->getEnv('default:glpi.default_secret:file:APP_SECRET_FILE'),
            'router.cache_dir' => $container->targetDir.'',
            'serializer.mapping.cache.file' => ($container->targetDir.''.'/serialization.php'),
            default => throw new ParameterNotFoundException($name),
        };
        $this->loadedDynamicParameters[$name] = true;

        return $this->dynamicParameters[$name] = $value;
    }

    protected function getDefaultParameters(): array
    {
        return [
            'kernel.project_dir' => \dirname(__DIR__, 5),
            'kernel.environment' => 'production',
            'kernel.debug' => false,
            'kernel.logs_dir' => (\dirname(__DIR__, 4).'/_log'),
            'kernel.bundles' => [
                'FrameworkBundle' => 'Symfony\\Bundle\\FrameworkBundle\\FrameworkBundle',
            ],
            'kernel.bundles_metadata' => [
                'FrameworkBundle' => [
                    'path' => (\dirname(__DIR__, 5).'/vendor/symfony/framework-bundle'),
                    'namespace' => 'Symfony\\Bundle\\FrameworkBundle',
                ],
            ],
            'kernel.charset' => 'UTF-8',
            'kernel.container_class' => 'Glpi_Kernel_KernelProductionContainer',
            'glpi.default_secret' => 'aa6e2c3945a6f7cd85431cf06111959149965bc7515b9afacaace80a3b2f9cd6',
            'env(APP_SECRET_FILE)' => (\dirname(__DIR__, 5).'/config/glpicrypt.key'),
            'debug.error_handler.throw_at' => 4437,
            'event_dispatcher.event_aliases' => [
                'Symfony\\Component\\Console\\Event\\ConsoleCommandEvent' => 'console.command',
                'Symfony\\Component\\Console\\Event\\ConsoleErrorEvent' => 'console.error',
                'Symfony\\Component\\Console\\Event\\ConsoleSignalEvent' => 'console.signal',
                'Symfony\\Component\\Console\\Event\\ConsoleTerminateEvent' => 'console.terminate',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerArgumentsEvent' => 'kernel.controller_arguments',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerEvent' => 'kernel.controller',
                'Symfony\\Component\\HttpKernel\\Event\\ResponseEvent' => 'kernel.response',
                'Symfony\\Component\\HttpKernel\\Event\\FinishRequestEvent' => 'kernel.finish_request',
                'Symfony\\Component\\HttpKernel\\Event\\RequestEvent' => 'kernel.request',
                'Symfony\\Component\\HttpKernel\\Event\\ViewEvent' => 'kernel.view',
                'Symfony\\Component\\HttpKernel\\Event\\ExceptionEvent' => 'kernel.exception',
                'Symfony\\Component\\HttpKernel\\Event\\TerminateEvent' => 'kernel.terminate',
            ],
            'fragment.renderer.hinclude.global_template' => NULL,
            'fragment.path' => '/_fragment',
            'kernel.http_method_override' => true,
            'kernel.trust_x_sendfile_type_header' => false,
            'kernel.trusted_hosts' => [

            ],
            'kernel.default_locale' => 'en',
            'kernel.enabled_locales' => [

            ],
            'kernel.error_controller' => 'Glpi\\Controller\\ErrorController',
            'debug.file_link_format' => NULL,
            'router.request_context.host' => 'localhost',
            'router.request_context.scheme' => 'http',
            'router.request_context.base_url' => '',
            'router.resource' => 'kernel::loadRoutes',
            'request_listener.http_port' => 80,
            'request_listener.https_port' => 443,
            'data_collector.templates' => [

            ],
            'console.command.ids' => [

            ],
        ];
    }
}
