<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Certification extends Model
{
    protected $table = "certifications";
    protected $primaryKey = 'Id';
    public $timestamps = false;
    protected $guarded = ['Id'];

    protected $fillable = [
        'neft_certificate_number',
        'name',
        'id_no',
        'govt_id',
        'company',
        'course_name',
        'actual_date',
        'issue_date',
        'expiration_date',
        'template',
        'created_at',
        'updated_at'
    ];

    public function student()
    {
        return $this->belongsTo('App\User', 'student_id', 'id');
    }
} 