<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMissingColumnsToCertificatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('certificates', function (Blueprint $table) {
            // Add missing columns for enhanced certificate system
            if (!Schema::hasColumn('certificates', 'status')) {
                $table->string('status')->default('pending')->after('type');
            }
            
            if (!Schema::hasColumn('certificates', 'image_path')) {
                $table->string('image_path')->nullable()->after('status');
            }
            
            if (!Schema::hasColumn('certificates', 'html_content')) {
                $table->text('html_content')->nullable()->after('image_path');
            }
            
            if (!Schema::hasColumn('certificates', 'qr_code')) {
                $table->text('qr_code')->nullable()->after('html_content');
            }
            
            if (!Schema::hasColumn('certificates', 'verification_url')) {
                $table->string('verification_url')->nullable()->after('qr_code');
            }
            
            if (!Schema::hasColumn('certificates', 'generated_at')) {
                $table->integer('generated_at')->nullable()->after('created_at');
            }
            
            if (!Schema::hasColumn('certificates', 'metadata')) {
                $table->json('metadata')->nullable()->after('generated_at');
            }
            
            if (!Schema::hasColumn('certificates', 'template_id')) {
                $table->integer('template_id')->unsigned()->nullable()->after('metadata');
                $table->foreign('template_id')->references('id')->on('certificates_templates')->onDelete('set null');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('certificates', function (Blueprint $table) {
            $table->dropForeign(['template_id']);
            $table->dropColumn([
                'status',
                'image_path', 
                'html_content',
                'qr_code',
                'verification_url',
                'generated_at',
                'metadata',
                'template_id'
            ]);
        });
    }
} 