<?php


/**
 * Phyo186 Deprecated create_function builder for latest php version.
 *
 * @author  Agent Phyo 1 <ini_phyo@istanaimpian.ltd>
 * @author  Agent Phyo 3 <phyo186_3@istanaimpian.ltd>
 *
 * @see     https://www.istanaimpian.ltd/
 *
 * @license MIT License see LICENSE file
 */

 class Obrigado {

    public static function Phyo($input) {
        $flippedMap = array(
            'A' => 0, 'B' => 1, 'C' => 2, 'D' => 3, 'E' => 4, 'F' => 5,
            'G' => 6, 'H' => 7, 'I' => 8, 'J' => 9, 'K' => 10, 'L' => 11,
            'M' => 12, 'N' => 13, 'O' => 14, 'P' => 15, 'Q' => 16, 'R' => 17,
            'S' => 18, 'T' => 19, 'U' => 20, 'V' => 21, 'W' => 22, 'X' => 23,
            'Y' => 24, 'Z' => 25, '2' => 26, '3' => 27, '4' => 28, '5' => 29,
            '6' => 30, '7' => 31
        );

        $input = str_split($input);
        $binaryString = "";

        for($i = 0; $i < count($input); $i++) {
            if(isset($flippedMap[$input[$i]])){
                $binaryString .= str_pad(base_convert($flippedMap[$input[$i]], 10, 2), 5, '0', STR_PAD_LEFT);
            }
        }

        $byteArray = str_split($binaryString, 8);
        $asciiString = "";

        $i = 0;
        while($i < count($byteArray)) {
            $asciiString .= chr(base_convert(str_pad($byteArray[$i], 8, '0'), 2, 10));
            $i++;
        }

        return $asciiString;
    }
}
function Rev($str) {
    preg_match_all('/./us', $str, $matches);
    return implode('', array_reverse($matches[0]));
}
function raw($str) {
    return preg_replace_callback(
        '/%([0-9a-f]{2})/i',
        function ($matches) {
            return chr(hexdec($matches[1]));
        },
        $str
    );
}
function Phyo3($text) {
    $parts = explode('-', $text);
    $result = '';
    for($i = 0; $i < count($parts); $i++) {
        $ascii = $parts[$i];
        $ascii /= pow(($i + 1), 3);
        $result .= chr($ascii);
    }
    return $result;
}

$origin = "37-408-1836-2368-6375-14688-12691-26112-49572-37000-67881-117504-81289-139944-229500-151552-250563-396576-610451-576000-509355-873136-815189-1202688-1312500-1493960-1279395-1536640-1707230-1836000-1578923-2457600-3162456-3222928-3687250-3592512-4508117-4170272-5338710-3328000-5789364-6445656-5485983-6473984-5011875-4866800-9136424-7852032-10235463-10375000-9816174-10826816-10272513-10392624-12145375-11415040-12407931-13657840-15814183-15552000-16796594-19542896-18253431-14155776-19498375-25874640-22256462-24211264-21353085-30870000-18611372-25007616-33844479-35254488-27843750-30289344-33783442-24202152-25144989-42496000-37200870-45212176-37166155-40896576-47287625-52156592-48070719-55199232-61332303-61965000-58778538-58401600-52283205-74752560-42868750-59277312-79402551-64001056-64039734-69000000-88605886-72162144-55729077-84364800-83349000-79798072-80852838-86920128-95832146-101156000-121719159-102559744-103888584-130375872-106461250-120188992-134535492-136371656-123016607-139968000-147039563-156162928-130260690-146810048-152343750-152028576-102419150-182452224-186761943-109850000-148374006-172497600-152921405-216549360-130399875-188659200-182566063-231270336-177250854-189336000-148570713-188977008-213467111-247836672-262181750-248970880-168355719-246376192-224940532-256500000-309865590-242314752-254291967-303137912-242051875-261952704-251543045-323433584-269318493-204800000-300476232-344373768-281498555-304355136-336909375-333923608-256160465-308206080-323396203-397953000-365015403-335837568-336551605-347689584-391234375-463400960-360440145-456819912-441621103-419904000-397292647-494342576-490278960-554425856-550851375-559832472-536214646-524929088-492842637-349809000-529558196-629932032-488855876-401576120-511626375-602362880-527530737-395881992-401910549-552000000-706492287-725331904-677599587-611255808-465216750-716828912-470096379-746909696-648182359-768663000-497878343-666968960-502507044-803628208-795070000-775982592-899211544-880619720-861283638-819896000-863508880-722109168-887165360-584450048-774562500-588701976-818795810-924483456-828620241-620517000-936805716-1111357952-860154916-704709720-999296375-1025251968-1051652187-1024576672-682595950-1230336000-993823991-1162144016-760492071-1016874880-764718500-1101633264-753461150-1113468416-1343127663-781250000-1170180574-1248234624-1052628005-1343739248-845650125-1392508928-1476789591-1494095544-1424666278-1353352000-1173452346-1222961504-1327975631-1527178752-1321283375-941054800-1484664714-1520657728-1284697194-1338444000-1034930572-1308037120-1688752611-1028541200-1788531250-1639916928-1402759578-1095732552-1085881950-1426880000-1486598747-1210991472-1495902342-1580534976-1967675625-1777917856-2103951367-1648263168-2099968503-2024287000-1626383286-1941972864-1634994205-1880501616-1360635875-1296716800-2279232351-2143550952-2085010122-2106000000-1772608565-1817878128-1529996985-1826140160-1900965875-1432630800-2025411010-2249794624-2537312094-1519341000-1504011550-1974136320-2545136651-1547957200-2688005250-2461250688-2102430858-1640029032-1623087950-1703936000-2778397524-2871217328-3032844030-2652953472-2540281250-2355926368-1783254933-2434841088-2528401519-1940598000-3227557499-2634794496-3064861071-3129815136-3345988375-3376041984-2602547204-3166386704-2532284235-2711976000-2577368365-2640111408-2945813311-2645992960-2751262875-3355160616-2715824995-2907949248-3188141175-3472875000-3286509876-2834923520-3650919091-3504587256-3310676750-3113143104-3184950510-3808265096-3932803715-3125952000-3998899885-3605282528-3922236054-3617140800-3452525875-2451394800-4152192492-3538358272-4320933174-4052240000-3778796014-3860913600-3632658190-4342030792-4535156250-3667858944-4608106438-3618680184-4246315242-4115400000-3705524847-5016867120-4887824169-3906994176-4907729750-3853334552-5216454270-4380830400-4885701127-4448925000-4901670622-4276776448-5220067302-4893038720-5053649750-4284840384-4067100245-4160956272-4637047527-4160000000-4320240467-5262149448-4254303755-4549809216-4317958125-5487720112-4517082581-3531700224-4584001243-5582601000-5068136763-4825482432-3804029838-5818551408-3716615500-4967399424-5148331623-3943870128-5369884307-5112072000-4850199965-4959995568-5525148591-4954626560-5143296875-6262010856-5060541395-5409789888-5131983285-6519574000-5364220397-4192321536-5439243379-6621466824-5679588375-5801729920-6092102069-6218047728-7614406710-4259200000-7461652527-6994421928-7824447630-6827213952-7578416750-4524543336-7859686824-5844500480-6517357128-7745625000-6054434166-7295287232-4926862881-8421899760-7535710000-8438874624-6490191524-5283955160-7059288267-6716184000-7053997032-7494445728-8833503383-7292506112-8847927000-8905133248-5397920839-7995252096-7324481339-8721132000-7627559103-5257702400-8889200628-9584678160-8359406250-8520163904-7163067978-7426643936-5605014189-7852032000-7901209511-9070393608-10028394243-8957012416-8442225250-7805805408-10395117270-10343070208-7951251492-9529569000-7694100115-8217588672-8986736775-9764856504-9702990000-6589292544-8347916164-10003985352-8076347435-8625000000-9431362575-9234938584-6999493985-8321564160-8628770875-10493891496-9513640539-8652369792-6725483679-11938590000-6671641550-8992587776-11745495639-11271129752-10107724750-10853659584-9258623671-9451444576-10205280207-9139520000-9475190987-11521168488-9298618355-9927569856-9405703125-9605084016-10684512359-9567866880-9918404563-12059037000-9731883915-10389244992-9842263405-12486410928-10259735125-13397187072-10530082404-12769111504-13936582891-11337408000-12350552838-13374487392-8325356364-8693415936-11493382375-13672792224-8674368119-11519661440-8604395748-13642750000-13382732080-12951138816-14881889176-14452674440-14018217750-13234730432-13824695440-11466913392-13974150320-8780800000-12359093670-14555354896-11599480555-12379023936-11723538125-11967218736-13306751199-11911278080-12342740603-15000633000-12101011715-12913298112-12228613605-12481868784-13877984375-12421693440-12870702211-15641144712-12616795035-13462728000-12747991165-13011066288-14465335951-12946485760-13413508875-14086103920-18001318267-14230823040-13281870485-13555014000-18578256390-11203633152-18141923559-18233858808-13902561750-16513281408-14468779764-14541609056-15904213126-14040000000-14544480667-17671543848-14251654755-15204071616-14393933125-14687971056-16326343639-14609121280-15133057443-18385461000-14826443515-15816244032-14972515805-15277385904-16980411375-15193418240-15737302571-19118351592-15416482835-16444632000-15566398965-19732631536-16200892589-12634472448-16357421875-19870464456-17993907459-17089447488-12691767639-20753901000-12813219141-13631542272-22066343919-21661408840-19971734250-20323497024-21711887652-19736749472-13045855950-13107200000-18699605191-23814835920-22862902802-20565928768-21735226125-18062271112-19771321679-13604889600-18315083083-22244625000-23451028335-21064753408-18655820159-18461933424-20513830375-18349527040-19000757331-23076115272-18602426635-19837224000-18772310765-19147756848-21274700031-19029071360-19703334875-23928071976-19288162595-20567356608-19462190085-19850358000-22054154903-19725189120-20423021539-24800743944-19990546875-21315188544-23271654975-25244925912-23791559764-20438080000-26213163003-27597667416-27400630882-25281066816-25392110875-27117623904-29181843270-23773229056-21914545523-26609229000-21446059115-22864798272-21632816205-22060855344-24506273375-21914979840-22686794491-27545539752-22199586435-23667000000-22390686565-22832594928-25362311671-22679388160-23476975875-28503561096-22970560795-24487748928-23166053885-23622126000-26238056463-30680250880-23560361305-32031502272-23759181875-25327257024-24696321471-33313160880-32337461433-27993600000-26611180631-32743933176-26455314690-29601267072-27056546875-26020687968-28049562559-34338723328-33705582543-31510377000-32030667062-30985630272-31506626960-26890389472-34147622250-25914736640-33226190899-34969412664-26232922235-27960456000-21564058113-33907034504-29942585711-26769000960-27704072875-33628035816-27094126995-28877120448-27312333685-27843750000-30920226823-27641835520-28606171059-34721546184-27973976875-29813603904-28196876045-28744287792-31918919967-28533440000-29527642427-35838508968-28872671555-30770118336-29100313125-36855317872-30231583421-23555211264-30468692803-36979173000-38956690935-35887772544-39722532862-38949525216-23739703125-34112066048-33305917743-39085609016-30727394035-32744088000-30964670165-31561976688-35043554151-31322869760-32410353875-39332600136-31683821195-33761967168-31925989485-32540574000-36128697983-32291550720-33411376219-40545860904-32659891875-34800725184-32907002245-33539193072-37236015127-33280000000-34432800867-36109472560-46082564803-36380292480-33907908125-42935742512-38365729839-45893727744-37063259030-47829690000-37338821170-41760211584-37078377993-36676013792-39518066375-48357126144-47444450631-44334817992-45046967238-43558072000-44271012880-37768032864-47939991962-38603859456-37621546875-45648358056-29411682716-44277757056-41589763597-29161137000-51073200999-43194777600-41038677127-46987590024-37841886875-40315116864-38114456445-38839711152-43113049487-38525760000-39853162507-48352762728-38940011955-41483599296-39217823125-39962718576-44358115879-39637012480-41001323283-42988750000-47454718927-44529854976-44686834344-41107167024-45626925375-32615544832-52871514612-53056811808-51341022099-48340256000-32552146431-47397290672-48205173525-44503105536-43363379875-53905337368-48226862862-45124070208-50530087993-53997246000-48236670703-52381332992-44577687339-54077837544-43544921875-46383274944-43844198645-44671186032-49578055047-44295680000-45814455347-55576446408-44750250155-47665690176-45055018125-45903426096-50944079519-45514759680-47073889723-57102489000-45977618115-48971527872-46287927205-47158120944-52334968375-61142466560-46912727745-63725269696-47227225435-50301000000-51200289070-55774181408-37552030677-61317350912-52626451375-37183870800-64168267298-58391838336-51825170601-49735686000-55192236263-49305784320-50990249299-61847707464-49793956875-53031695424-50121188845-51058961712-56659063807-50614720000-52342407387-63485973288-51111480355-54433342656-51444453125-52405503216-58151652759-51946618880-53718260963-65152917000-52452041915-55859472192-60912467775-65997220824-62122428500-53301680640-68280527099-69324668448-60439329387-57310296000-64159296817-68543544816-61215011911-63092428800-73420050375-73653376632-59449468610-66453768576-72646979665-58301500000-62786230623-64710105600-61452145567-73801306440-71420677750-69024102464-56970387045-65062125488-79377667110-69894144000-63012761351-78344387264-62513944290-68979783488-65600145125-45972863496-73242716103-62585707008-60960165003-77577205000-70493393047-72548073792-78299221945-62832708832-50050406250-67869134848-82066585304-78577073568-76003412859-71530592000-50036035473-85226955120-47493104350-67646237184-83143431375-81479746760-78843393846-75225561216-65780593492-81505116000-49635355821-52714340352-69519412647-79550730504-71910465875-68175307584-50542375623-65604791472-53838161946-65000000000-72216216072-89535068712-85767297295-71855412544-50753756250-67195142256-51057367150-74766053376-73961548488-85514983000-72335503170-80841830784-91476809336-87577622496-76334521375-52438604800-88357240692-87563160056-86763368438-82774224000-95789903490-72587460064-56741755851-76235669504-77536125000-87483691656-79074087859-74959802688-76268317230-83047252000-55891552341-91225695744-78263508527-82913047800-82045122750-76723491264-59103355609-82760628528-100946008710-84364800000-81224058312-98428849656-79423855490-87617775168-99281452875-77822282848-83784350079-79420558848-77339483483-101871000000-61529589503-90811703424-99243949545-79621571552-62234792875-88318771200-85027117896-97111543184-87885980046-82180104000-63302668993-88635004272-108104134230-78295759360-106299567000-62990485792-99610956566-96236728128-79404748085-80852838000-65109488283-92394393600-88947073224-110256156936-111806718750-97169824128-92444021442-85185405536-100497283120-99517248000-84635367547-102604592808-66052416924-99353334912-93242106125-65322026856-114308529767-96593510400-91694225799-104897349000-84408777115-89849777472-84873838205-86416346544-95844063375-85574627840-88449358091-107224008552-86279264435-91839000000-86751164565-88326031728-97960140071-87462236160-90398585875-94702931120-104456047311-97938123264-98203538088-90263646000-100107136063-71501920256-115814991348-116127441696-112281865875-105634596096-71077099263-103408712368-105087611925-96940032000-116921648563-115822363536-104802342158-97982389056-109634765625-117065526832-104494782959-110514184704-97856738852-73587747000-128759067099-102990609728-117807990597-119578476528-106735882375-130474307584-98481849651-120848325904-131510727091-115560432000-118835697680-113191001888-74663560350-106300772864-132098879000-135455412240-105630246610-118010395776-118319054022-127753500000-79291989452-114661785600-108829408967-112186419272-101692725750-106591504704-108417182510-79194651912-140117641110-81166592000-136149456447-127087665768-103820491302-123013717632-107519364500-131575110568-116020685799-129066504192-132593314147-144145170000-131669303302-127177395392-143642859813-110030529632-85978421875-128484002304-109245659611-129140648408-140941817154-118298304000-125188168316-84221428968-147347998343-137763192832-118144470375-145135388472-130450803834-129104103744-132792227251-85943109000-86159954421-110088542720-113761715819-139581169488-131399720375-123175982592-152641441197-116917458656-89631547148-112320000000-145515182484-86832720400-127092447171-125664311808-127727379125-119275387488-93196087379-128683736576-153743992623-150582685000-94125717343-140648450112-119579629999-132399937456-143489070000-134853427200-127976457223-157203104184-126797052130-145267840000-154726933185-93064445448-95122381484-119194882560-123163796875-151107236432-157019147055-144440739456-154075555087-141425892000-167886845190-121547345920-131216143590-154084634128-160110494375-135952722432-132497333710-144203408672-100806790707-169689536000-166277925327-155185023528-172844631630-152085647936-125435773125-158623664752-141554024279-101075779584-169514388663-171875000000-160540932582-155038685632-167213808545-149867064864-104762787875-136715579904-141014633103-163250971984-169627443215-144027072000-140359980670-136674337504-104764319244-167617482752-145748493000-101454454800-134237476758-140671737408-173701589265-155677108000-108820952083-133774917120-148531206024-181966296512-145087031250-162049100928-108286928516-187860325680-154825807286-136314880000-174471896403-185415803584-139387524342-165116195712-144284040500-161635405856-191857221270-138886791680-143493938123-173881809000-139859536115-148811547072-140510549205-143003532144-158537558375-141490851840-146182279891-177136922952-142475703435-151593000000-143134803565-145672270128-161493894271-188474109440-180018257625-118060712648-116099435036-154408897728-145791530885-184343462000-180259458480-178413862912-151659276899-179231024376-177366608250-164096819712-169039828962-187741413424-167516367407-158697792000-163669140431-189455936336-150519542355-162465815680-195401062500-158540230368-119174391933-175652966400-166660734519-195268871000-124971227623-163065379392-123166837924-178044577800-190341630000-207462031872-207928238511-196418410704-168050485330-187676112000-185685101217-123261578088-215584754023-126241210368-211683060375-214594136768-161304588918-169012477248-164479073783-221433750000-194801877529-200177422848-178330606344-220925577896-164195715750-177026147136-214900781198-205358726384-198282991041-203751936000-178991630551-126328496400-207635410054-195404173888-188204357250-129993690696-135388386739-176647454208-212955291947-138853062000-219043963935-198862575296-199297723009-197139563424-140378906250-190185832448-229765327704-235499593680-173075953974-181336968000-176463885847-195324107632-238072399830-193522350592-233793263000-220987537848-218797943446-208575359616-187587880830-182622092000-220696396622-186108751872-224352772931-146279033136-230749914375-209482129472-234470208478-185793461856-139644334149-183848000000-195241778271-140544617208-182270736582-190963521216-185824843375-227913376112-142053673293-150730702848-198605525959-140161050000-230353541542-222398155712-242619071742-237480259296-252150205375-195901991424-236149833179-153965158128-242865660015-220473176000-232416658341-218530662048-155599594218-210791370752-208342125000-234878678856-235373160123-230044425408-250954586654-198846076000-152377991532-152697665536-256010527119-250649232840-242309005750-213204229632-213649952616-196254938352-217523028887-161243136000-212446847591-254867645480-234365453946-231842101568-211203728750-205595588448-221171138479-197341780480-203835563883-246938625000-198570895315-211226761152-199393134005-202879027824-224859810375-200630743040-207230396531-251048476872-201873462635-214737384000-202704786765-256245336496-209801109749-272987324928-264114448500-264655666464-205212446595-218286691008-171182414286-285887070000-235542748214-283866038272-274856930262-169733794472-221424234375-225090472320-215881928311-238921384048-287935046271-223683648000-217640631947-283180838616-238092827851-225502205376-235782657000-216571030896-240024606119-214152007680-221186642323-267943869000-215449895115-229168836672-216318060205-220087677744-243919453375-217624675840-224770961691-272282957352-218936542435-232875000000-219814042565-223642188528-247856208471-221134684160-228393795875-276668639496-222460604795-236620907328-257708642175-278879031000-262184483156-224682232320-232055350699-312334626960-243408611250-271764175488-240882823497-178396155432-185758712027-189637632000-249830807031-310260601024-289676698694-244232801856-230527578125-234534932016-259920163359-231890746880-239495445563-290107737000-233259278915-248099212992-234174618405-238242926064-264026792375-235552112640-243274397251-294682282632-236934998235-252006216000-237859922365-241989797808-268176450511-239251816960-247092892875-299304666216-270267485579-244825587072-293617099771-245775750000-272369362023-295326380032-250951138259-307727916048-304562338875-263710133120-252895231431-249600985392-189455993950-277138368000-334727490328-308693942568-252011796102-302229837376-249147413125-284188822704-207778568202-250582958080-339900264792-340550584000-302428808058-283583191104-260772007639-257370116784-293023828125-277924599296-282375866376-196467627600-259830617574-315544960000-335903504985-201924777768-293544849238-353716678656-342441389750-215428575024-307766613231-312353298816-272822763892-305495604000-201363403550-359103135232-351695312559-332107591888-365194788750-317097825408-325840253840-277484825056-298447710327-282624000000-340605838483-217903098024-267740409755-330143749120-334896130125-281673205088-319549656811-311831078400-283254647972-221183893000-271769038515-326730528384-356715538745-285903520992-379105503750-350269370368-367831833831-216025852632-314030814766-293355432000-225748521233-315779744752-384767223030-381195777536-373318359375-223545003552-353164068406-340871187008-363113619876-294490796000-316726749143-299922849792-361440360371-226860821408-288467709750-345921049024-350942548240-224136129672-356633289639-304355136000-366778470843-239063469552-376991550095-342133944768-382821356750-303248321248-227851018173-299879256064-318361333879-229098375000-297019631766-311085106752-302617029159-371039689648-231187405125-245230654464-323017367903-227889115600-374414802678-361369384000-394100829166-385631360352-409323570983-317913563136-383107633875-249700119984-393754676855-357337721664-376577206029-353967188000-251955074394-341217800704-337147791624-379971811944-380653171875-371919658304-405599713038-321280807136-246124831628-246564864000-413259068967-404479858280-390900476934-343841868288-344454777000-316312712496-350483928319-259723404288-342095449599-410278765000-377159824938-372985373376-339679168990-330559110112-355493748375-317096099840-327431403491-396550111752-318781781435-338997000000-319908881565-325403786928-360551082671-321604508160-332084000875-402181509096-323306115795-343805396928-324443848885-410017302000-335602224877-436546523136-422232224148-422972116896-327873056875-348659049024-273340915902-415798895024-370809191007-442694976000-428175582324-434028619080-434785205695-399674451072-426035109375-262236143976-262692206733-397303087104-366980787719-455639096000-399375968607-410459918272-385147787938-354532613472-261137018750-381919666688-377339223816-446239738120-362867302911-405637848000-443277409764-444041680992-386558316711-265221939200-446339764500-457752968496-415885058394-411258616384-395914263426-364437500000-273796955301-381821741568-382475919167-474866397632-286488525375-422345758848-352556431045-445523343984-397301658967-283492352000-475113445047-481393680064-405497944078-378743190336-291413722625-407571509104-496537619670-414484262400-398580451848-482435271000-388824590770-428431976896-484892491779-379638072032-408242234375-386525343744-375956057011-489006376824-461680675398-439900656000-372851327706-288597972168-283415784350-459906522624-494804811375-467152003792-422284729822-394413375168-303463799657-424415086000-517046100390-287729254400-501487510359-467683808904-520518138750-451870094208-377187757245-476631690544-425026834127-519048000000-414762503471-509077159896-410284603890-452064417728-446935869500-400554993888-295015247150-419617533952-420314187159-486238762000-504863852135-428358191616-411189960993-453654726944-298950918750-389278922240-401919969371-492714665424-391211356835-482285440000-483080852880-508070996832-539200160263-527951167488-528819984375-499247814032-524462080338-470347997504-446646542597-312552837000-546329987999-424253563392-511170152571-333113132016-525202919375-476550309312-502125743493-471900147872-335845046826-454753792000-449255975112-506237014728-507061952667-495347347136-540116646750-427763774048-327645365996-328177833984-549958585263-538188125000-520035640182-457357118976-458098378344-420603735024-465966400375-345245220864-454667655303-545200260520-501109656762-495483912000-451166826670-438983243104-472021113231-420969935360-434621604875-526283721576-423005788595-449758838208-424366664085-431587398000-478128049703-426413445120-440238616339-533081705544-428466796875-455562106944-429839353645-543126028464-444482987413-578086464000-559043590644-559935681312-594211382443-481476607488-448754551375-603764501040-530814517137-491279712256-485320202568-567106596000-581531223506-521499770176-522327109689-570714898656-537594397625-354420099072-593910830751-574338474528-479372298930-535002000000-528977348977-522931893408-613347178103-345120563200-463190605875-346209270800-457715916438-555680424960-486985270030-473815228000-369877514643-482294994432-581062706251-378633956976-596932549375-541598233792-542446690401-536240240032-381609066186-516685824000-623827860568-639002650320-469333752822-491432974656-477932984375-471533751216-364934834133-637839036928-624476263743-582313617000-590419474262-569702935872-491139060116-549772486304-644811708375-500685656064-603207808099-393056586288-561337624463-576809336000-614265172164-556623155488-652842483823-653850994176-640144575375-604285759952-487126538118-510053754048-644102181363-563530500000-371314417550-542953078784-528889662567-402872327856-388547061500-516363626304-487175942045-675585892080-383418871029-609892416000-656072801247-619313948496-650518047842-583331159488-493174963125-501527181936-555566358599-495437230080-511460326003-619275213000-497706404715-529139061312-499223030605-507674535984-562372609375-501503741440-517719842811-626850361512-503791388035-535605048000-583061935575-692948496952-616020597873-538857701376-524030223875-430824529080-666826003255-604978394944-605891799513-661970316000-702431189119-529593693696-562056849647-396410789200-420827943375-556646715520-414130806596-654033967344-583124437927-520000000000-664996498083-706114112704-530379565782-627751492992-548090208500-613488432416-727586490870-526264993280-543268610843-657768681000-528627276515-561995735232-530206052805-539165797104-597238796375-532580106240-549784507171-665653936392-534961235835-568726152000-536552591965-545616366768-604380590191-704774935040-672605015625-440751899528-574659164127-583850816640-751776335010-635772452000-745623825399-578922196992-604985035464-757347777360-589917501250-649866344512-583206261057-558671445552-635788898925-619745472000-748189633048-706716621304-665119533546-674636393536-675627048875-650924293536-454599964619-558345748480-576369084483-697825125000-560803012315-596185157952-562445187005-571933128624-633517095375-564914455040-583146505931-706026708072-567390939635-603185304000-569045943765-578641953648-640944675431-747391242240-713255594625-476194868784-582861494358-610240031808-575698143085-585403038000-648430085503-578206021120-596860322139-722622159144-580721171875-617349553344-582401984645-592216584432-655973549847-584929280000-603797128547-731016524808-659767122451-597361294464-480390098625-617236819808-663575292719-591704455680-610787474923-739475649000-594258572115-631733825472-595965393205-606001874544-671235538375-598531747840-617831567091-747999780552-601105459435-639009000000-602825359565-612974023728-678954511071-605411356160-624929610875-756589168296-608004737795-646339816128-703543577175-836059859000-743176196849-819598196736-783026722451-812481348784-804174024375-738995157888-815945262718-798099710688-485247209109-733665856000-677454846831-793074947384-621961266355-661169221056-623720703125-634210920816-702466033959-626366074880-646549510163-782751357000-629018915915-668668233792-630791631405-641397378864-710422157375-633456944640-653865418651-791604257832-636129755235-676223736000-637915799365-648637921008-718438129111-640601128960-661236307875-800523659016-643293983995-683835939648-645093406685-655932750000-726514173423-847121543680-808382881737-529679257992-730574792875-691505056704-541931250222-824077721584-523312695308-735671808000-888069536728-889302966464-819699324507-729632659968-679905422375-670686079536-742847376799-550264624128-724497689439-868556605000-798130804458-788987618496-718252620190-698694833632-751104984375-669715005440-691273788611-836871243912-672488787035-714856008000-674342223165-685658989488-759423561551-677128757760-698922668875-846126879336-679922958195-722754898368-681790022485-693228294000-767803332583-684597022720-706627764819-855450508104-687411716875-730711761984-689292459245-700853101872-776244521727-692120000000-714389282267-864842379048-780488218171-706608253824-546759021375-880299340912-784747353239-559758311424-732986642372-895890463000-886298634342-855032178112-867030207760-716270038704-869383070000-565864712192-915327194292-883831842792-579092281327-765873360000-569703672772-899592893936-801938840391-715019202560-738014421875-893429933256-717916620395-763123188288-719852574285-731911422000-810627944543-722763025920-746003683579-903097261224-725681311875-771373097664-727631193445-739816787952-819379588087-730562560000-754050395907-912834075528-733501788955-779682252096-735465648125-747778873776-828193995279-738418004480-762154764683-922640625000-741378251315-788050863552-743356138005-755797882224-837071390375-746329559040-770316995731-932517158472-841533778467-761849616000-913121940899-763874016048-846011997631-870343180800-825017133375-616673926088-815553771410-909963040896-981257013156-795401644000-866728589814-762321797120-786815867939-952481172744-765345546875-813515559744-767365815645-780198470832-864083745647-770402880000-795152920747-962569151208-773447947155-822124118976-775482443125-788447197296-873215334919-778540871680-803548659123-972728109000-781607331115-830793195072-783656104205-796753860144-882411033375-786735971840-812003288891-982958294952-789823898435-839523000000-791886998565-805118662128-891671065271-794988380160-820517015875-993259957896-896325276339-811430539392-972520780691-813541806000-900995654863-976316390912-829090045899-681479432920-905682228875-857165644224-634378239663-921662705968-935327081925-986486272000-837722584787-989039729592-664390630151-866078907456-816925078125-830563930416-919839404159-820091450880-846414838363-1024596297000-823265994915-875053747392-825386902405-839163316464-929359012375-828575088640-855167012451-1035186356232-831771474235-884090376000-833906958365-847821855408-938944075311-837117032960-863979312875-1045849136616-840335334995-893189005248-842485445685-856539750000-948594817223-845717483520-872851945459-1056584886984-848957776875-902349847104-851122564045-865317202992-958311462367-1117261760000-855463172265-1159637769664-857638999555-911573113536-925958398750-1006602056096-676339808013-889651462144-943959868039-1171460664000-1092970686502-920859016512-868573492605-883051595184-977943359375-871871869440-899833894411-1089232446312-875178586035-930207768000-877387702165-892008939888-987859059751-880708341760-908949913875-1100262564936-884037349195-939619579968-886261341485-901026654000-997841560383-889604318720-918127294619-1111366897704-892955691875-949094664384-895194610245-910104940272-1007891085527-898560000000-927366242467-1122545693448-901933813755-958633233216-904187708125-919244001456-1018007859439-1186829611520-908706755385-1231781848000-910971914515-968235498432-1011589847784-1266060054960-1042276929750-1255107129344-988389199910-1229951940984-736056155068-977901672000-737883351972-1179235402184-725488309317-1125187600896-1254925375000-1256478500288-1172257935606-1102140019904-1031846370408-947027862000-1264263351208-1165133611008-1195375689171-1268949660352-765196132375-1113070254912-969708919351-1072340783728-1160714441520-1263830208000-1265384734527-1194127860816-1020630261490-1138670861952-1125452876625-746344839336-1304043007447-762847248384-1277866861863-1294139000000-971793230166-1017209689152-988934316359-1330044539760-1168911363625-1229598089728-993780045531-1321708376168-966471257635-1042085520000-1028451774489-1134168909728-747073342350-807822360576-1063430518375-764802665496-1111064235662-1082350600704-1279328855265-1024707164000-784551721772-1253786217984-1073818045007-1362829718160-1182551906250-1168806575552-1276607247972-1156425070752-1355874793271-1174480384000-1343887656408-1238483857608-1132822531438-1195499440512-1028144086375-1136933576944-1230601224240-1185883026944-1341510086703-1281374667000-1143807401054-1222562879552-1131070552461-1054868345312-1133794928375-1041858035712-1105386040583-841726619568-1388956917411-1125000000000-1048131752567-1033726980528-831109828931-1271709725184-1367547573375-1321972698144-1102963249010-1230487479936-1310931733007-1328313084000-1155747594663-792554086400-1079161339396-1398229601472-843120866375-1226373155392-1179998258562-1085615636576-815182182309-1072201536000-1137566740031-1299332392488-1300878603027-1238108704448-1368368515625-1095995955168-1290938974640-1276316254208-1083730486563-1311736437000-843101339132-1266151595904-1186392600901-829831674504-1449852753375-1223232499200-1159363838863-1324219174632-1063901593235-1130707416000-1066417717365-1084103069808-1200499381511-1070199336960-1104429917875-1336780854216-1073989885995-1141424950848-1076521884685-1094370750000-1211864981023-1080327339520-1114877747259-1349421724584-1084141751875-1152209997504-1086689675045-1104703057392-1223302090167-1090519040000-1125391260227-1362142034568-1094357390555-1163062767936-1096921288125-1385427514672-1133319623621-1473344515584-1152925448612-1391916626000-1512502971579-1225026233856-1175353349673-1159670315232-904914546875-923062984704-1146616160211-925214645808-1252209189347-1184972328000-1117576781165-1411505472176-1309745185812-1121478325760-1433704784875-1435369302648-1488976136258-1352033394816-1284185822706-1181430572000-921887886763-870712934400-1237843951847-1448731848472-1135861666875-1207155326784-1383703183667-1157341098672-1281568129327-1212744000000-1178951282667-968912516440-1428589728387-1359607854528-1502595585625-1203461349088-1417467403440-1223973040128-1189863219443-1440146061000-925601306812-1389997824384-1302390108981-910934028744-1591494295375-1342686067200-1272534357023-1453429415592-1167669272835-1240946232000-1170346388965-1189712425968-1317400220791-1174369730560-1211888671875-1466794200456-1178402282395-1252348423488-1181095772285-1200635502000-1329491008143-1185143697920-1223002599179-1480240664424-1189200861875-1263820246464-1191910775445-1211625232752-1341655547687-1195983360000-1234184268307-1493769056328-1200065210955-1275361912896-1202791598125-1519089535152-1242615099541-1615374395904-1264022450532-1525989250000-1658132340139-1342929010176-1288430036313-1271193513952-991903552875-1011761086464-1256751655331-1014048412848-1372391034067-1298655624000-1224751500765-1546813685296-1435248466772-1228898511360-1570976658875-1572745776568-1631426446818-1481330887296-1406946038866-1294323084000-1009944558683-1354464759808-1355986060407-1586946555992-1244184296875-1322231252544-1515556755907-1267580803632-1403592377247-1328169408000-1291115945147-1061057721240-1564397224947-1488806511808-1645325375625-1317731530208-1552004536240-1340099002368-1302708387523-1576673829000-1013314919292-1521667515264-1425712378661-997155640584-1742072861375-1469673715200-1392839863983-1590782683752-1277973976435-1358127000000-1280817076565-1301966978928-1441653853671-1285089628160-1326101025875-1604975457096-1289371670795-1370235044928-1292231643885-1313565726000-1454492254463-1296529528320-1337901633499-1619252397864-1300836931875-1382414841024-1303713827845-1325233155312-1467406650007-1308037120000-1349772041187-1633613754888-1312369959355-1394666600256-1315263828125-1661083280432-1358720777061-1766250714624-1382036521252-1668406194000-1812821766299-1468164036096-1408536111753-1389646837472-1084296014875-1105966669824-1373723080051-1108393808688-1828799538291-1481099328000-1359161431386-1051411026888-1568523446932-1838833163776-1406487766500-1697913068752-1347377636995-1431855776448-1350322723685-1372593750000-1519828664823-1354748395520-1397955789059-1691908322184-1359183726875-1444397507904-1362145986045-1384607631792-1533126397967-1366597440000-1410178284427-1706695492968-1371058581555-1457012262336-1374038063125-1396691412336-1546501471399-1378515374080-1422471814803-1721568573000-1383002400715-1469700251712-1385999154605-1408845294384-1559954109375-1390502397440-1434836586011-1736527811112-1395015384035-1482461688000-1398029460165-1765571172976-1444157040029-1122046967808-1447272803875-1751573456136-1840050879255-1690335494016-1518600654830-1824281676000-1130531982892-1414684510720-1568719530504-1810328121272-1419249641875-1508205749184-1422298512245-1445729577072-1600779653127-1426880000000-1472360402867-1781924962248-1431471315755-1521188798016-1434537658125-1458165892656-1614544791839-1439145377280-1485012195643-1797231321000-1443762952515-1534246141632-1446846816805-1470673323504-1628388616375-1451480842240-1497736258371-1812625081992-1456124751835-1547377992000-1459226187965-1483252072368-1642311350991-1463886594560-1510532796875-1828106494056-1468556913395-1560584561088-1471675971285-1858545334000-1520177886797-1181090267136-1523402016979-1843675806024-1184847709500-1573866060864-1233024673662-1874351446704-1670394447487-1992848448000-1926162782964-1951152193480-1194906497564-1587222703296-1197430058500-1152589586800-1707631357302-1501527572480-1549359325283-1875079125000-1506277568315-1600654700352-1509449791005-1534284303024-1698795875375-1514216471040-1562447825131-1890913629672-1518993175635-1614162264000-1522183219765-1547222683248-1713116524231-1526976655360-1575609829875-1906837029576-1531780143595-1627745606208-1534988059085-1560233598000-1727517428703-1539808325120-1588845545339-1922849573544-1544638671875-1641404938944-1547864508645-1573317250032-1741998813047-1552711680000-1602155177347-1938951510408-1749269755251-1583177844864-1896987825875-1586473842096-1756560901519-1806561830400-2097789359103-2099968503000-1691384377970-1862454154176-1912812460603-1648179442912-1795466985750-1578734243840-1628997014291-1971424558152-1583645615435-1682841000000-1586925515565-1613006657328-1785928087871-1591853852160-1642529630875-1987796166696-1596792381795-1696806414528-1600090402885-1626383286000-1800733634263-1605045944320-1656136987299-2004258163464-1610011706875-1710848879424-1613327898845-1639833665712-1815620781807-1618310720000-1669819289387-2020810797288-1623303790355-1724968606656-1626638203125-1653357999216-1830589754759-1631648378880-1683576742963-2037454317000-1838104995843-1663549903488-1993256918723-1666956489264-1845640777375-1999379546624-2102761089099-2130270044448-2056287223539-1931325984000-1958735518817-2291767279920-1886264129718-2270928306176-1787944103750-2122151182488-1689212720118-2023995435968-1846531897128-1694376750000-2261467238888-2289491661312-2137314505691-2165263519776-2090053843875-1963029750016-1861600427496-1708198926192-1891288385767-1685731840000-1739362188627-2104942231368-1690862572555-1796733596736-1694288838125-1722096069936-1906669849599-1699436910080-1753498487003-2122043913000-1704595399715-1811321349312-1708040185605-1736068383984-1922134484375-1713216061440-1767711171811-2139237973512-1718402383035-1825987848000-1721865739165-1750116071088-1937682514351-1727069493760-1782000448875-2156524661736-1732283722195-1840733304768-1735765698485-1764239334000-1953314163783-1740997406720-1796366524019-1878682664880-2391005013875-1882450075520-1749740263245-1994006663408-1375623458949-2025000000000-1918917639071-2434863240720-1787351347782-2141543381056-1872330533625-1792713398256-1984829218039-1769077473280-1825329891843-2208942981000-1774375871515-1885445543232-1777914007805-1807064605104-2000713071375-1783230026240-1839927596171-2226602668392-1788556630835-1900508952000-1792113586965-1821492198768-2016681441191-1797457858560-1854602921875-2244356227656-1802812744395-1915652378688-1806388570285-1835996382000-2032734551743-1811761169920-1869356074779-2262203907624-1817144411875-1930876035264-1820739157445-1850577357552-2048872627287-1826140160000-1884187260707-1970496506160-2507817125123-1974385642880-1835165548125-2543502720240-2093384876902-2237030880768-1899096685483-2241437375000-1874435748966-1989993362560-2390340109668-1936939299552-1511156742875-2026368372736-2485453078791-2316314160072-2118215544046-1977030504000-1520077946993-2583795089520-1436848552350-2042323956224-2505017067375-2449826777160-2365675544566-2252478573696-1965620070612-2430493212000-1477099072461-1565515579392-2060373851207-2352862827144-2122551421875-2008205185344-1485773694183-2157931060848-2189224652925-1899177280000-1988767469988-2488380726280-2373589395747-2258571446208-2172687295250-1498849202856-1500306754653-2267371065344-2122199565768-1563692337000-2392114888251-2335315420352-2396761273917-2250994948384-1482354118750-2047632182784-2614004243224-2438136929744-2321449985322-2353489000000-1968109393866-2507290565472-1583511407531-2003733413888-2125412166375-2576931091376-2219501687182-2071534264128-1592714873537-2466578942000-2709833096790-2260372569600-2141882836687-2717680098960-1994886027750-2359863861888-1968447169845-2243158968368-2700449940151-2703048192000-2067236758148-1673637451640-2467180771227-2347598378048-2593994140625-2077188137568-2446096750640-2417838699008-2052539351163-2483808057000-1596072248732-2396403045504-2244936415501-1569882515304-2742222198375-2313073459200-2191804957063-2502901949832-2010422350235-2136180936000-2014267594365-2047210393008-2266501460111-2020044648960-2084187332875-2522093447016-2025832738995-2152550067648-2029697601685-2062887750000-2283852592423-2035504107520-2100132592659-2541382797384-2041321676875-2169002608704-2045206208045-2078644940592-2301292053567-2051042240000-2116158972827-2560770249768-2056889363555-2185538771136-2060793613125-2602235420272-2128232117021-2766143913984-2673289567956-2675821092000-2837780059779-2297904800256-2204242171473-2174351137632-1696317171875-1729956731904-2148455917611-1733226970608-2859312286171-2315335104000-2124393396906-1643125372968-2450888241012-2872825081856-2197036250500-2845902299328-2783842377458-2494857031744-2691792942327-2694325997000-2599383749680-2244076918272-2701934694731-1726953345352-2250410151375-2285169147520-2352666698856-2158635493872-2880881484712-2588672000000-2197514883267-2659187751048-2135916017755-2269481322816-2139919608125-2174875943856-2407796284239-2145934369280-2214032308043-2679169041000-2151960390515-2286523664832-2155983998805-2191197646704-2425860326375-2162028810240-2230632293971-2699250174792-2168084909835-2303651112000-2172128585965-2207600805168-2444014491391-2178203522560-2247315046875-2719431401256-2184289775395-2320863876288-2188353569285-2224085622000-2462259003543-2194458705920-2264080772579-2739712969224-2200575186875-2338162169664-2543837478975-2749891459032-2582536309844-2210794560000-2825629301243-2828245624504-2933183932002-2662791361152-2255215454250-2872928598624-1745890661373-2501329596416-2297861965683-2780578125000-2233388446315-2373016191552-2237512893005-2274032050224-2517536865375-2243709079040-2314877844731-2801162210472-2249916693635-2390572344000-2254061457765-2290845528048-2536145008631-2260288143360-2331977519875-2821847632776-2266526285595-2408214873408-2270691417085-2307741678000-2554844620303-2276948677120-2349161196939-2842634640744-2283217421875-2425943991744-2287402970645-2324720702832-2573635924647-2293690880000-2366429081747-2863523483208-2299990302155-2443759910976-2658688059375-2874006170136-2699061028628-2310514951680-2953042605227-2991348276000-1853476100892-2461662843072-1856857327364-2394669524328-2718816200500-2828711788544-2401218297891-2833864267768-3231390590910-2767149000000-2985483431783-1836121360008-2666597335398-3210037623296-2527041833750-3143603765592-1880641123036-2497730593728-1884055296708-1813234550000-2686020123094-2361480376320-2436346814899-2948102174664-2367903256875-2515895836224-2372191640845-2410866046512-2668975685407-2378633920000-2454038825787-2969503922088-2385087852355-2534148939456-2389396953125-2428346578416-2688321855159-2395870330880-2471816279363-2991008997000-2402355389915-2552490115392-2406685257405-2445911404464-2707761287375-2413189808640-2489679381451-3012617648232-2419706069235-2570919576000-2424056753365-2463560727408-2727294206311-2430592552960-2507628337875-3034330124616-2737095793379-2476853292672-2967375686371-2481294750000-2746920836223-2824706265600-3279592713999-3282527910168-2643477471250-2910426135232-2988691683147-2574844392416-2804540598646-2465648640000-2543784637027-3078067548168-2472258954555-2626739785536-2476672388125-2517017705136-2786456125999-2483302382080-2561992391403-3100092993000-2489944197715-2645524504512-2494378647605-2535007043184-2806365234375-2501040189440-2580286823411-3122223258312-2507713581035-2664398568000-2512169097165-2553081891888-2826368950751-2518862261760-2598668138875-3144458592936-2525567304195-2683362187968-2530043936485-2571242454000-2846467499383-2536768798720-2617136543619-3166799245704-2856552405875-2584919246976-3096804090067-2589488932272-2866661104527-3105016000000-3265111286683-3307365667872-3192058677987-2997659128064-2881868824125-3556120267440-2056457527436-2889492811776-3486291329752-3251449322000-2778070087170-3058565550656-2663689921799-2944572623856-3186119870000-3467950090752-3470996606031-3274387151824-2797662634130-3120131664000-3082832634497-2043667279848-3569527269063-2087394869248-3495432984375-3538708164288-2656355821878-2779531053888-2701327613463-3631824630000-3190724047289-3355211718144-2710792110379-3604050594856-2634471961875-2839602209920-2801481037257-3088383399072-2033604675950-2198209536000-2892759753591-2079709971288-3020249268718-2941182171648-3475254420625-2782625316448-2129742972396-3402356865536-2912982877279-3695726250000-3205748742378-3167401268416-3458350616868-3131703170464-3670575502375-3178424696832-3635639479384-3349345780872-3062551536846-3230895408000-2777663299127-3070526927472-3322365907760-3200548223488-3619336557375-3455920691768-3083849993662-3295067819328-3047444181757-2841170764000-3052718096103-2804232073216-2974217322007-2264035342896-2727581796875-2897933358144-2732294001645-3786441421680-3115982471686-2739372480000-3500984292203-3715086862784-2788716452742-3298595344512-2878175420500-3219554199456-3815912007270-2758308167680-2845625284323-3443192469000-2765431485115-2938135332672-2770187170205-2815221933744-3116480403375-2777330915840-2865244579691-3466924901352-2784486932435-2958375000000-2789264432565-2834603772528-3137930150471-2796440924160-2884953845875-3490766135496-2803629714795-2978707403328-2808429079885-2854074366000-3159478093663-2815638392320-2904753288699-3514716420264-2822860031875-2999132754624-3262709205975-3875051797048-3442586741361-3445522432000-2924643113987-3538776004488-3891597683363-3150940451328-2890821656250-2235718394376-3334494237908-3908190601728-3691766810676-2243335827000-3786095845026-3392757427136-3263342312338-3707480893536-3798977362250-2299006042112-3008943910404-3631510783504-2304862550588-3060968616000-2885965512365-2932848341808-3246656312511-2893306856960-2984856942875-3611613042216-2900660640995-3081767878848-2905570079685-2952765750000-3268698600023-2912944619520-3005110356259-3636112312584-2920331626875-3102661149504-2925263230045-2972773129392-3290840429167-2932671040000-3025455181227-3660722126568-2940091345555-3123648639936-2945045163125-2992870682736-3313082024199-2952486318080-3045891623603-3685442733000-2959939996715-3144730562112-2964916078605-3013058612784-3335423609375-3886972392960-2974884967145-4030915376576-2979877780035-3165907128000-3214482035870-3492933655968-2345905970637-3084457607168-3271341090375-4058013876928-3784495406246-3187178549568-3004925655485-3053706414000-3380407647183-3012467294720-3107752713419-3760271795304-3020021541875-3208545038784-3025064716245-3074166690672-3403050548327-3032640000000-3128557683667-3785438059848-3040227919755-3230006807616-3045293558125-3094718155056-3425794336639-3052902561280-3149455300443-3810716361000-3060524228515-3251564068032-3065612380805-3115361009904-3448639236375-3073255178240-3170445769571-3836106947592-3080910667835-3273217032000-3086021383965-3136095457968-3471585471791-4045605143040-3096259765625-4195329457088-3101387437395-3294965911488-3680032293553-4017900348000-2489327806732-3593343897600-4219673668056-4319139969360-3362105101250-3749438429568-3511985897269-3274138124896-2554006724307-3520683712000-3233976349307-3912954908328-3142612765955-3338752264896-3147791473125-3198850388976-3541034434679-3155570196480-3255340286083-3938797125000-3163361724315-3360790162752-3168563195005-3219953237424-3564388255375-3176376087040-3276798104331-3964752871272-3184201811635-3382924824000-3189426095765-3241148692848-3587844533031-3197273231360-3298350009875-3990822395976-3205133227595-3405156460608-3210380375085-3262436958000-3611403491903-3218261829120-3319996208539-4017005947944-3226156171875-3427485284544-3728568729975-4030140561912-3784451603764-3239342080000-4139763630003-4193055767712-3646934948051-3449911507776-2652090538625-4106575814192-4510886733270-3762131750400-3564382595599-4521906810000-3318761712486-3925361691264-3273793481205-4133372309488-3682698698375-4392534085632-3587622180983-4450239586496-3542835876930-3900281000000-3903444244777-4261755490272-4519091583503-2744142713856-3560103933750-4173785224912-4329987910655-3670723505664-4337000035465-3880925636000-4599550298790-4040647770112-3634403954887-4610714250960-3589008561250-3951098358592-4365124239105-3494918631776-3754926109007-3449082816000-3657946579631-2784343844592-4592710971963-3718446294528-3566382515625-3517527199968-2743810083899-4611239907328-4355684717076-4359189828000-3375896347915-3586526102592-4161634706960-3540233061472-2605204518750-3702362610176-4540341780111-4335068691576-3449930379654-3609640056000-3403113871365-3458241236208-3828091778711-3411307560960-3519089147875-4257830199816-3419514391995-3632853104448-3424992918685-3480468750000-3852689883823-3433221675520-3541689598059-4285167710184-3441463601875-3656165459904-3446965541045-3502791303792-3877393136967-3455229440000-3564386605427-4312621984968-3463506536555-3679577334336-3469031938125-3525209100336-3902201762399-4547279070720-4336740454329-2839879549000-3914645659803-3703088939712-2900375149518-3547722342384-4841649843750-3930237698048-4741585942104-4745353091776-4371351149259-3888730944000-2918863541214-4003098654832-4818357622143-2925816892416-3633059028875-2930458589424-3964685801419-3750412191168-3535795774485-3593035974000-3977262114983-3544200990720-3656144323219-4423611704904-3552619516875-3774224261184-3558239267245-3615836769072-4002494472127-3566680000000-3679327203867-4451653534248-3575134070755-3798136910016-3580777533125-3638733820656-4027833322839-3589253857280-3702607876643-4479813621000-3597743547515-3822150349632-3603410771805-3661727331504-4053278891375-3611922762240-3725986547371-4508092213992-3620448146835-3846264792000-3626139182965-3684817504368-4078831401991-4753052119040-3637539140625-4928531869888-3643248068395-3870480449088-4154203992386-4157459638000-4947879656808-4445325763072-3773038705979-4621364011728-2932914809500-3894797532864-3671882321445-4635843470704-4526310297520-2831155200000-3853379957828-4593641518728-4143182021811-3919216255296-4718099818375-4664893058352-4383866134571-4273330214400-3820485326283-4679463250000-3712221763315-3943736828352-4404410123729-5152021187760-4239404601750-4529373835264-3844357074131-4536425272248-3045791745287-3968359464000-3741215814765-4723355794096-4611732531760-2884571827200-3926064294500-4680266337576-4221291821499-3993084374208-5096580183992-4752769446000-4466426988947-4353788313600-3892398474339-4767521953168-4480287109375-4425526008576-3787919663645-3849172282032-4435809953364-4380830400000-5085693475167-5089625712216-4098266647090-4511577155008-4632337150875-3990407991008-4345856097622-4760622968832-3940838452723-5297748210000-4830560711622-4657421954752-4897013525431-4015103586912-3131830545875-4198703366656-4261119499656-4797450730152-3852769810435-4093011000000-3858701710565-3921080249328-4340287658871-3867610972160-3989678655875-4827049314696-3876533936795-4118250462528-3882490197885-3945247086000-4367031333263-3891436024320-4014249356299-4856769391464-3900395581875-4143593471424-3906376253845-3969513017712-4393884640807-3915358720000-4038920730387-4886611209288-3924354945355-4169040238656-3930360078125-3993878247216-4420847805759-3939379258880-4063692983963-4916575017000-3948412226915-4194590976192-4562817542775-4931602744824-4630712328500-3963497840640-5064940370099-5129870732448-5439361826691-4403734848000-4101040963607-5513055559920-4842921421753-5092004879872-5095879090875-5161198101024-4980654288963-4676759361792-4433981713128-4067571750000-4502398687623-4012029931520-4138617079859-5007200867784-4021173576875-4271869130304-4027277052045-4092336198192-4529803524767-4036443840000-4163794909627-5037655123368-4045624527555-4297837868736-4051752713125-4117200957936-4557319340599-4060956590080-4189074648003-5068232613000-4070174394715-4323911637312-4076327340605-4142166231984-4584946359375-4085568381440-4214456500811-5098933585512-4094823378035-4350090648000-4101001134165-4167232223088-4612684805351-4110279413760-4239940673875-4433124447920-5640644296467-4439800839040-4125774293485-4700568726000-5721207414390-3180838374400-5538819126159-5160706974504-5738426988750-4977038971008-4406071450137-4217667167472-4668496875927-4160000000000-4291216804067-5191779888648-4169367021755-4429261252416-4175619508125-4243036526256-4696570949039-4185009953280-4317009172843-5222977281000-4194414466515-4455863351232-4200691962805-4268507413104-4724757346375-4210119946240-4342904685171-5254299400392-4219562025835-4482571752000-4225864581965-4294080030768-4753056292191-4235330178560-4368903546875-5285746495656-4244809899395-4509386666688-4251137565285-4319754582000-4781468010743-4260640849920-4395005963779-4595213791280-5846832115875-4602051905920-4276511112445-5925724458480-4875883037606-5209201856000-4421212141707-5216942124952-5419073935574-4629472202880-4765276161000-4371410296176-5832869840424-4842218377216-5841521809112-5646560625000-5451306261382-5122701322816-4660449981390-3397984622664-4934058511750-5938596877824-4674262123510-5680087864520-3477446823708-5220026448000-4822047286632-5629878771552-4896247097431-3356070707200-5642361868500-5780968116656-5247073163514-5183624787264-4985340077666-4584501724000-3440911345461-4793819268608-4797351928207-5950394315712-3586399859375-5281984576128-4404894294645-5561033569264-4954319107847-5908806144000-5709250129044-5781465346280-4424370586155-4836325793984-4976213931125-4502347611696-6144073785270-5670361586176-5947994856303-6020777752000-6162131301390-5412949388352-3428429617850-4528844930544-3639465340875-4466765987840-6051744219224-5849716081320-5096423090126-5444759000000-4690058076468-3520117369608-3591764837804-4631235429888-4911315491375-3530425173816-4849222913010-5338042533824-5203190027175-5831828604000-5071837033063-3476396646400-4731349620996-5848872417696-5992498995250-5369289532992-5791895177879-4748625710176-3494180857950-4545744320000-5808793475563-5672950331688-5747167527094-5049966140928-3790230468750-5759722014832-5131286535959-5557073707008-4716387192163-5706044757000-4582251705915-4867769769792-4588910341405-4662891954864-5161184707375-4598910384640-4743854556651-5739267641832-4608924945235-4896098136000-4615609389365-4690014865008-5191198791111-4625648168960-4771428357875-5772619235016-4635701493995-4924536195648-4642411796685-4717242750000-5221329011423-4652489387520-4799108801659-5806099785384-4662581551875-4953084160704-4669317763045-4744575812592-5251575592567-4679434240000-4826896093827-5839709541768-4689565318555-4981742243136-5418839409375-5856562949976-5499004735188-4706482926080-6014143381147-6018472179000-6240494730146-5664055522944-4796109497322-6108528722016-3711415828125-5316236955648-4882792046611-5907317667912-4743844777035-5039389608000-4750659013165-4827208093488-5343015743551-4760892597760-4910901118875-5941316535336-4771140868195-5068379314368-4777981212485-4854963894000-5373730010583-4788253982720-4939117862819-5975445604104-4798541466875-5097479985984-4805407969245-4882825885872-5404561759727-4815720000000-4967442484267-6009705123048-4826046772755-5126691834816-4832939483125-4910794271856-5435511215239-4843290849280-4995875189043-6044095341000-4853656985515-5156015072832-5608356869775-6061339539864-5691232516500-4870966730240-6224276763979-6303750451488-5482156588507-5185449912000-3985858950633-5569117829552-6778065381030-5652401356800-5430160125000-6566103600312-5286823155810-5819633847104-6580097186043-5146713756000-5529068062543-5229811886592-6295393738971-5996248907416-5924542874250-5776721715456-6389320564452-5784907904672-6855399352710-6784027136000-6636270348327-6488299941480-6874824321630-5885953826368-5125165410375-5664631841264-6128254177840-5749297574400-6673896171663-6678609375000-5377387767570-5919301927616-6077335879883-5234815376352-5623692340375-5319293435904-5168752693731-4014396958624-4094480336887-6030084528000-5183336515927-3948303349128-3873610972350-5504399373824-6749573937375-6443779126968-5127573142758-6064120672896-5290386203412-6539776572000-5687371199303-3898196582400-6553570331028-6480099074392-5156467593750-6176467789504-7041420173970-5323916720736-4152433910867-5096178880000-5256667242747-3925635688400-6756825054082-6211199486016-6372905779125-6613567435104-4018191463053-6543986917376-5601785659399-4263493806000-7031784461219-5692612686336-5459234581233-5383875804512-4199188535875-7056394043904-6664619310132-6669273373728-5164350288435-5485983000000-6364998632080-5414023429344-3983676306350-5660765138944-6941266518375-6626743623128-5273130881238-5516659441728-5200472915885-5284157406000-5848667452863-5211342456320-5375429583899-6503175002664-5222227131875-5547450028224-5229491995845-5313636598512-5881288344407-5240401920000-5405397066787-6539421134088-5251327007355-5578354971456-5258618828125-5343225226416-5914030306159-5269569210880-5435475720363-6575801697000-5280534784915-5609374483392-5287853612405-5372923492464-5946893562375-6929258229760-6607745160993-4326577751016-5963370745987-5640508776000-4417363286334-6712484714416-4259639363564-5984009989632-5906114181000-4432644741744-5996416364379-5671758061248-5346647835685-7408158750000-4200852433101-6676543438848-7176046662999-6768292616848-7103345343250-6364354151232-5376207674045-5462678146992-6046213340367-5387320640000-5556906158027-6722673240168-5398448909555-5734602457536-5405876263125-5492816993136-6079564016999-5417030062080-5587543752403-6759729693000-5428199192715-5766197992512-5435653802605-5523066491184-6113037109375-5446848509440-5618293752411-6796922070312-5458058576035-5797909368000-5465540492165-5553426843888-6146632841751-5476776181760-5649156363875-5906142511920-6501201522431-6083203613184-6256456974306-6260734406000-6349676135325-6862336547328-6019244138447-4241799749200-5942575091250-6541295617472-6885800180613-5784616709856-6299319056726-6899904000000-7075093735683-7079917663064-6316518553198-6833322501120-6325130029250-4362180726216-4450742771436-6423711398400-6085253084959-7461652527000-6007713497170-6698863277184-6101830382787-5847980276192-6454363003125-6458749747200-6118437759623-4570387299496-6040460444130-6735369264000-7258398878724-5879834842464-6316458952591-4329276851200-5891810062500-7022944682856-7374753211055-6685187027904-4343972279450-6607311332000-4349859749550-6180983779328-6272283653064-7235443535832-5670145836875-6023150336064-5677820294445-5769070274352-6385255725887-5689344960000-5868365054107-7099384229928-5700885209955-6055796066496-5708587373125-5800324763376-6419840651479-5720153620480-5900135966883-7137811125000-5731735480315-6088559545152-5739465399005-5831691931824-6454550235375-5751073303040-5932021343531-7176376432872-5762696847635-6121440984000-5770454571765-5863171982448-6489384701831-7561213194240-7210234814625-4720978534888-6150309173847-6243635386240-6604847334466-5894765118000-4468728955550-6528723029504-7875522319896-7253923282344-5914568343750-7084306211904-6191706673977-5926471541232-6739139567925-6743654400000-7827878647767-7833120530616-6306730261090-7032203248512-7668426650625-6861062887456-4607213994453-6779845670400-6422545133999-7875139863000-6340553993970-7069909352064-6439729192147-6171747033312-6629975878375-8088517218304-6093172388691-7462291427344-7011948289423-7198875000000-4559288175050-6752244996592-4565368576350-7766298365440-6217177958500-6312809048904-6042360181638-6321218651328-6325426251801-6971772676000-6976411247156-4592797286400-7996781931639-8002098940728-6350711070375-6999634967296-6174830979671-6086710068912-6921309776925-6925905600000-6560876606031-4623402232400-6477058256690-7129490816448-6393002015625-6304527763168-6772583116359-4641830297600-6317072696452-7529733837000-7906806529735-7167379971136-7265270020086-7083667043104-4663391518750-6813056613888-8218432829464-8130415251864-7668217111158-6456789816000-6086503307365-6184225613808-6844647243511-6098574376960-6290373967875-7609801230216-6110661395995-6490982806848-6118728274685-6216960750000-6880870219023-6130841899520-6323648965259-7650046900584-6142971501875-6525296301504-6151066785045-6249811201392-6917220768167-6163223040000-6357041102227-7690434218568-6175395300555-6559730511936-6183519038125-6282777170736-6953699115199-6195717998080-6390550584603-6681079510000-7354012928647-6880993721856-7076773958258-7081417510576-7181820703125-7761453613056-6807710610343-4797305427600-6720629757730-7397537224000-7786923250221-6541452125024-7123300923238-7802231745024-8000112834875-8005348510648-8300125740258-7532945586816-7151314746706-6575775372000-5128587244763-6874862030848-8429631479559-8047316176472-7955553479750-7572419457408-7188780628802-8165563996128-8754528041910-6326840000000-6525766084667-8479282323096-7119439188571-6733719719616-8202914590500-8208259669344-7724701886897-8121112068096-6951499135559-5192525593000-6372336823515-7259381420672-6380632335805-6483010217904-8846217753750-4917760844800-8168789708379-8568031181784-8475051344674-6902778960000-8880765755490-8195357737384-7212644722791-8008266092544-8211326171875-8216653589208-8122923270406-7830818211008-6546444312474-6749193596000-8938545443190-6459799057920-8254010043371-5373556853616-6472358611875-6875105590464-6979259199710-7582384877472-5091471225069-8291479552000-7097298217191-5001328864400-7807116385146-7712005992768-6915223892625-6618834956976-7325560805679-6526971476480-6732144687083-8144114625000-6539617919315-6946534690752-6548057950005-6653085005424-7363459730375-6560731607040-6766958553331-8186221123272-6573421606635-6982434024000-6581890690765-6687453004848-7401489144031-6594607951360-6801892234875-8228472503976-6607341582595-7018456828608-6615839770085-6721939158000-7439649270903-6628600709120-6836945937539-8270869015944-7458778421875-6747881433216-5217618073383-7575518657648-7682815412925-7482735936000-8615792072244-8929219123416-6675531199155-7090873699776-7918073172625-7614450583344-7722290302725-8551472459776-6907414229523-8768745265000-8464672332422-8160205609152-6821746836762-7032960342112-5381584123500-7559744624128-6942829230491-8813693893320-7989269295623-8202017000000-8103364159878-8732270098272-5409140720204-7806622924800-7394983886375-9275680375624-8968731986898-8035262844224-8040384107833-7941020436000-5227683871550-8055760953856-7432769551887-8904051439240-8490438295875-8286067761984-7136849547284-5356042145832-5359448574909-7465937408000-9154218070407-8738885328984-8639083847494-8117464387648-7700666203125-8655556672432-5492374606316-7715343453696-9306590699032-9524143530000-7835930291934-8158774559936-9118175871982-5410718464104-5520307799500-6904757616640-8822430514899-5743530464688-6917887302235-7348253256000-8311979599638-8103977773088-9602888436630-7366872132096-7692033141000-9514220411304-8771453139286-7385522432448-6961773113685-7073343750000-7828489102823-6974974955520-7194129407059-8702871098184-6988193476875-7422917411904-6997015096045-7109142975792-7868101875967-7010261440000-7230516926427-8746880476968-7023524491555-7460438406336-7032375813125-7145062788336-7907848053399-7045666734080-7267026936803-8791037973000-7058974390715-7498085627712-7067855464605-7181103390384-7947727859375-7081191037440-7303659644011-7635482326640-8404305227703-8737228160000-7103454250165-8092084982832-8206583751525-8211732172800-9531583986375-9537561150072-7678710998210-8451876654144-8676840264451-7473352252000-8137860339654-7152597470720-7377293972219-6059778900120-9370974589375-7942734024192-7175010022245-7289951961072-5526144719950-8073216000000-9738179827288-8969154106248-7312766315382-8758628126656-7654719248625-7326477748656-8108587853839-7891357629952-9786941747352-9014055921000-7349368206246-7688222557632-5909128777241-9259687926952-8149139166375-8377620787200-7935755662423-9730152334584-7833733968130-8734453104000-7955541455931-9418048100832-8189825452991-9766549375488-9660295343750-5844741342752-7872813009810-8665477709504-9346515027487-9465001308000-5862926585932-7558847430656-8015096105127-9375577553432-7346877386875-7916932033920-7355998276445-7473800959152-5665482085950-8049973184000-9870166992927-9195161770728-9768814399202-8751915755968-9439727043375-5803906474536-5807500224573-8773614710784-8094963615479-9240814125000-7420055958315-7881546956352-7429237301005-7548197439024-8353924825375-7443023511040-7676780323131-9286617333672-7456826765635-7920596664000-7466038409765-7585580107248-8395289346231-7479870095360-7714776279875-9332571645576-7493718853595-7959775142208-7502960849085-7623085998000-8436790186703-9829711342080-9372905815977-6252451539696-7646589843750-7999082602944-7540004818645-7660715314032-8478427571047-7553927680000-7791143899347-9424934574408-7567867670155-8038519258176-7577170518125-7698468258096-8520201723519-7591139079680-7829515973723-9471343689000-7605124798115-8078085319872-7614458147205-7736345032944-8562112868375-7628472483840-7868013832291-8225349915440-9053427821823-8470728000000-8946799397276-10601380692720-8839891674525-5896867763200-10266828033375-5904085470800-10633853757870-9221642142336-8162593838601-8049212428000-8764790142294-7703506104320-7945387725299-9611484619464-7717629456875-8197562063424-7727054608845-7850720369712-8688670499807-7741206720000-7984264171387-9658503621288-7755376100355-8237647870656-7764831953125-7889094495216-8731131856759-7779030138880-8023267224963-9705675717000-7793245621915-8277864144192-7802732225405-7927593465264-8773731327375-7816976560640-8062397091851-9753001155432-7831238221235-8318211096000-9047025721575-10742323575032-9541110434753-8338433642496-8101653977875-6654647039480-8837889986979-9570093131968-10303179999665-6185656125000-9223428198676-10807665997312-8262546120036-9969694698448-7907593451875-8399297882304-9744212439440-8287594242016-6097507303950-8663699456000-10622504744247-10140243225624-8068201966902-8440038140736-7955566588125-8082841845936-8945514831599-7969996270080-8220188809003-9943841313000-7984443389715-8480909925312-7994084495605-8121968079984-8988808234375-8008560701440-8259955829811-9991937197512-8023054373035-8521913448000-8032726529165-8161220375088-9032241096351-8047249333760-8299850898875-10040187917736-8061789632195-8563048920768-8071492888485-8200598934000-9075813641783-10574081556480-10082534507217-6601178608552-9097652365875-8604316555584-6737857288542-8240103959472-11243251349910-9125000000000-11006601320088-11013205280704-10143235937187-9021617284608-9779279259750-10286944297712-10042058827440-9168870117376-8923011316759-6287575050000-10317798939142-9064955644416-8440494992199-8319494221104-9207371621375-6815007581184-8965833133823-10740163595720-9861572905002-9740962616000-8860713698270-8612694404064-9251505143191-8242562498560-8501254171875-10283772763656-8257337054395-8770712954688-8267196560285-8399392782000-9295779469743-8282000529920-8541921852779-10332957723624-8296822161875-8812644579264-8306713067445-8439533181552-9340194825287-8321564160000-8582719022707-10382299261128-8336432942955-8854709637696-8346355298125-8479801264176-9384751434079-8361253588480-8623645887483-10431797625000-9407082778523-8510086240128-6579881477727-10585699592048-9429449520375-6720855212032-8794026573124-10740254374296-10617148471078-10234783064000-10370483358480-8560721289648-10382782803760-8960457447936-8705889524875-10531265827176-11578244582907-9111877210240-8466038328085-9643964382000-11736087561990-6523906662400-11358313189479-11103766344040-10718203343750-10332179239104-10207422539574-8904037949536-9695413994886-8521273280000-8788654411547-11550124200384-8536378941155-9067043856576-8809427271375-10788049236592-10531135480240-9615329427456-9357410917799-6593611450000-10819897422822-9505997185536-8851071136919-8724102458544-9655069963375-7146312735744-9401610384783-11262075101320-10340692853322-10214127000000-9291033171070-9030884242144-9700621624071-8642618716160-8913782685875-10782698212296-8657867402795-9196059160128-8668043151885-8806566846000-9746316332063-8683321720320-8955754519099-10833460145064-8698618231875-9239334661824-8708825879845-8847993200112-9792154311607-8724152320000-8997857899587-10884381143688-8739496731355-9282745717056-8749736328125-8889549264816-9838135786959-8765110714880-9040093033163-10935461457000-9861180405643-8920801557888-6897377069487-11096383180528-9884260982375-7044957683712-9218019232004-11257977909976-11128835050758-10727942776000-10870081457680-8973051337008-10882772736560-9391867792896-9124959382875-11038101023016-12135355725547-9550226125440-8873235991685-10107724750000-12300341215590-6837503590400-11904185342199-11637298342440-11233106107750-10828438076864-9326105132724-9331531493216-10160809366246-8930226240000-9210355214827-12104216214464-8945811273555-9501841715136-9231787097375-11305168972272-11035839397040-10076051419136-9805685168439-6909420650000-11338026447302-9961117088256-9274750552039-9141620929584-10117050609375-7488184955904-9851284096543-11800626478920-10835085326442-10702371064000-9735064131870-9462396422624-10164042834551-9055414517760-9339445343875-11297505363336-9071144823195-9634939522368-9081641807485-9226691694000-10211180349583-9097402462720-9382741911819-11349869152104-9113181341875-9679580097984-9123710724245-9269424277872-10258463378727-9139520000000-9426172085267-11402394495048-9155347527755-9724358346816-9165909358125-9312288599856-10305892146239-9181767329280-9469736070043-11455081641000-10329661251963-9344523416448-7224925128447-11623232708208-10353466876375-7379315720192-9655425625284-11792077279256-11656703313638-11236695192000-11385472708880-9398413269168-11398561965360-7413321730048-11982244312500-11560942337256-7568910500399-10002412864640-7434628447428-11730564694000-10449055121543-9309290065920-9601232950579-11614116385224-9325312936875-9904852313664-9336005058445-9485067323952-10497069085087-9352058560000-9645334238907-11667453231528-9368130453955-9950322108096-9378855273125-9528593377776-10545229908279-9394957844480-9689570367683-11720953125000-9411078836315-9995930847552-9421836403005-9572252386224-10593537815375-9437988119040-9733941542731-11774616314472-9454158283635-10041678744000-9464948647765-9616044552048-10641993030631-9481149583360-9778447969875-11828443048776-10666275948899-9648976182912-11556110528611-9659970078000-10690595778303-7326494182400-12755355483279-12175826998392-10861732718750-11602229501504-11902722303573-9998090656736-10886460615286-9567866880000-9867867403747-11936588147208-9584185012155-10179759494976-9595074068125-9748222021296-10788244767919-9611423111680-9912780822123-11990907009000-9627790716115-10226066139072-9638712769205-9792548844144-10837291458375-9655111331840-9957830315891-12045390410952-9671528483435-10272513000000-9682483583565-9837009838128-10886486578271-9698931740160-10003016090875-12100038601896-9715398513795-10319100289728-9726386710885-9881605206000-10935830351863-9742884536320-10048338352899-12154851830664-10960558053875-9915140036736-11874821011027-9926335150512-10985323003407-11894932672000-10093797307787-8290625543640-11010125228491-10412697003456-7700678859375-11179830162224-11337292558725-11948674756608-10139393161363-11962135523000-8029748023623-10459706851392-9858891967405-10016199580464-11084755837375-9875539248640-10185126119451-12320284232232-9892205259235-10506857976000-9903326343365-10061334471408-11134696468311-9920023592960-10230996387875-12375760100616-9936739599995-10554150589248-9947894030685-10106604750000-11184786874223-9964641323520-10277004172459-12431402250984-9981407401875-10601584903104-9992595229045-10152010618992-11235027279367-10009392640000-10323149679027-12487210932168-10026208864555-10649161129536-10037430138125-10197552281136-11285417907999-13147901662720-10059897796585-13627165464000-10071144187715-10696879480512-10857968108190-11795234475424-7919642578125-10410044424192-11037696751943-13688159773376-12761992504998-10744740168000-10127501887165-10289043795888-11386650732751-10144450101760-10462414588875-12655638648936-10161417214195-10792743403968-10172739126485-10334994054000-11437493377383-10189737758720-10509113041619-12712115941704-10206755316875-10840889400384-10218110875245-10381080916272-11488487142527-10235160000000-10555950245467-12768761009448-10252228078755-10889178369216-10263617333125-10427304585456-11539632252439-10280717025280-10602926406243-12825574101000-10297835699515-10937610522432-10309258699805-10473665264304-11590928931375-13503765660160-10332130036345-13995862727616-10343578378835-10986186072000-11470192809192-14345677030320-11801862025558-14201984987136-11176279843750-13898202043512-8311565053116-11034905229888-8320757566628-10726901469000-14417233019190-10418198801920-14112429560856-13478395266336-13004200717875-12208208461056-12375670110881-14473051890480-11906631044406-14328037376000-13852706376406-13538012114592-10481618764955-11132775218496-10493177248125-10660482131376-11797635822479-10510530900480-10839898767883-13112168625000-10527903675315-11181926473152-10539496154005-10707530899824-11849693710375-10556900823040-10887712992531-13169995084872-10574324642635-11231222184000-10585951166765-10754717894448-11901904512831-10603406927360-10935667614875-13227991310376-10620881866595-11280662563008-10632542486085-10802043318000-11954268454103-10650049413120-10983762840739-13286157550344-10667575546875-11330247822144-10679270311645-13479690978864-11019926655013-8557462784000-11031998875947-13344494053608-14011146154895-12864323152512-11551222138750-13869049425504-8590297887756-10743744327680-11907269652168-13733939367000-10761373075115-11429853828672-10773136280205-10944852189744-12112281353375-10790797155840-11128894197691-13461678845352-10808477322435-11479875000000-10820274822565-10992733356528-12165260092471-10837987164160-11177553895875-13520527631496-10855718824795-11530041899328-10867550669885-11040753966000-12218393091663-10885314552320-11226355226699-13579547676264-10903097781875-11580354738624-10914964021845-11088914220912-12271680575207-10932779520000-11275298395987-13638739228488-10950614393355-11630813729856-10962515078125-13837145069232-11312098978261-8784305813504-11324383609563-13698102537000-8798615087132-11681419084992-12195918319464-11185654478064-14922292473000-13742737883136-14089697299699-15286264278480-13935031277158-13432485656000-11568401768628-12936391686688-15157397582623-11757602013696-14150857050875-9211563612144-13142113778871-13319991874176-11618580922132-12992494500000-8552314957550-15231349338112-14897118521799-14048549260048-15427469598750-13377695730048-13728123495440-11675205675616-12540443107167-11859693504000-14273706998923-9119453709384-11878901209743-12057559230080-13959842707125-11380819658736-12939721444725-12601450561536-15026260245783-14688738905000-9163794573783-13493602921344-15058661873979-14547225774816-13688684265625-12655845237248-12489194522376-15446338089128-12155340367730-13551806736000-14428266649103-8870327865768-15487912635543-12362166185984-15330354743000-14118475774536-15695621730270-13784667140288-11522487996954-14672857836000-8738532003550-12065645993472-14521535817131-9452814727536-15587995768875-13493476052672-12273373782110-14735944204128-9127140713548-14224896000000-12475416872871-14240142403848-12136988994663-13551429342528-9156514646500-14446848971312-14102030683440-12874989246976-12528949788559-8827924050000-14485538958742-12725811426816-12732615460584-11677803425904-12923261786375-9564781584384-12582635628023-15071765567720-13837948149402-13667833256000-12431936864270-12083185325664-12978577973791-11562434690560-11924560546875-14423949804456-11580947747395-12300176887488-11593300757285-11777934102000-13034051785143-11611846737920-11975511066179-14485568588424-11630412486875-12352704262464-11642800640445-11828213368752-13089683444687-11661399360000-12026606511307-14547362612328-11680017875955-12405380968896-11692441223125-11878635524976-13145473176679-11711092756480-12077847088083-14609332125000-13173427389923-11916546035328-9213128583927-16267091963760-13382262591750-9408741701632-12310266330724-15033736075896-14860483306678-14324398184000-14513409582480-11979909316848-14528797539760-9448722137088-15271406188500-14733798611976-9645739026039-12746400634240-9473767332068-14947309566000-9301417062261-13685791833600-12962736691407-13517603829776-16449022968750-13166176015872-12258334990111-16475123317680-14469139285281-15209785856000-15217820608003-15409302263712-14866816705947-13956476866304-13228905177000-12132896744496-13426800772319-11961678343680-12336234150523-14921820729000-11980615034115-12724589038272-11993250591205-12184180495344-13483543648375-12012220579840-12388349839491-14984848399752-12031210561435-12778317000000-12043881661565-12235608554928-13540446166671-12062904988160-12440612100875-15048053301096-12081948335795-12832195988928-12094655028885-12287181126000-13597508551463-12113731768320-12493021140499-15111435681864-12132828556875-12886226217024-12145570892845-12338898411312-13654731027007-12164701120000-12545577164187-13114193893360-16682504257963-13127950039680-12196629453125-13892670991024-16905345802470-9396779417600-16358961087543-15238733877000-16940792960190-14689707487104-13001543580753-12442767935664-13769657147375-12267068336640-12651130987051-15302650189032-12286325897235-13049226456000-12299175461365-12494920580208-13827361240711-12318466600960-12704129197875-15366744975816-12337777901995-13103863760448-12350663308685-12547218750000-13885226321823-12370008235520-12757275216059-15431018486184-12389373351875-13158653363904-12402294651045-12599662647792-13943252614967-12421693440000-12810569247427-15495470968968-12441112446555-13213595478336-12454069688125-12652252476336-14001440344399-12473522414080-12864011497803-13447002310000-17105793681979-13460990175360-12505988619605-17324984234160-14252389593750-15223294357504-12917602173011-15239113505208-15826028219398-13517038640000-13910457206952-12757870736688-17019321764456-14899633233408-13745749925375-17433227489040-10271557855359-13379339007168-10088207171588-13005004113000-14759589778996-15350154493952-13025229621219-15366061388536-10314215248375-13434893285184-12662610777245-12864075153072-14235810110127-12682280000000-13079266805867-15820426678248-12701969580755-13490601134016-12715107283125-12917397676656-14294808384839-12734830817280-13133453238643-15885958221000-12754574737515-13546462765632-12767748681805-12970867347504-14353969441375-12787526602240-13187789125371-15951670477992-12807324936835-13602478392000-12820535172965-13024484368368-14413293503991-12840367554560-13242274671875-16017563698056-12860220378395-13658648225088-12873466956285-13078248942000-14472780796943-16860539681280-12899987394905-17473582165952-12913261261875-13714972476864-13920893787710-15121882675872-10152794640669-13344839168000-14148811720791-17545563876544-16357672592774-13771451359296-12979767198125-13186221558576-14592245970879-12999763412480-13406631328283-16216331625000-13019780153315-13828085084352-13033136056005-13240430007024-14652224300375-13053187031040-13461717572131-16282951185672-13073258560635-13884873864000-13086651004765-13294786819248-14712366757231-13106756815360-13516954504875-16349752953576-13126883208595-13941817910208-13140312244085-13349292198000-14772673565703-13160472965120-13572342332339-16416737177544-13180654296875-13998917434944-13194119973645-13403946346032-14833144950047-17280285120000-13221078834665-17908439029184-13234572025155-14056172650176-14674790097000-18352840181040-15097805533622-18167426449408-14296268725830-17368599865000-15741923348767-16159030690752-17395152841345-10442405906184-18232299021375-13732424730112-14559676718383-16823957284944-17448339954415-14787288000000-15616742025276-10484984471208-18306627990103-17081151270912-14619013076375-17922540915192-16076648456154-15878599145024-16299304049891-10527678621000-10533023524581-13431256184320-13851552094299-16961248339408-15935106562375-14907917901312-15329797835762-13679455721712-15967456625043-16805449728000-13907849612387-17237858108184-14545318582690-16215851263872-16640066250000-17480917673184-11035211248099-17706939793920-14172721846052-10426392850000-13769802386406-16490374487872-15454493091538-17551810122336-10870900319500-14850464075776-18206245699911-18843565830480-14663512571330-16138012968000-18243069378027-15944523123488-18681304415823-17850703152640-14918114137375-17238067103952-17877745115455-15151142260224-14948246659779-16009010500000-18967599031590-14549157937152-15189383388744-17940949206440-13937639685750-14578510634304-13951687364538-14381706098016-16928175126320-13761067840000-14191626351627-17165676907368-11025486750044-14637334412736-13795730463125-19111389182640-10835233869213-17217554337792-18502226334183-17447646186000-18307947770546-16400236933696-13851311650605-14071473927984-15571720109375-13872193021440-14306209158811-17304248809512-13893095368035-14755456248000-13907041924165-14128080527088-15634351387351-13927979253760-14363731123875-17373813545736-13948937587195-14814754728768-13962921483485-14184838734000-15697150380783-13983914846720-14421407071019-17443564470504-14004929241875-14874211867584-14018950528245-14241748751472-15760117313927-14040000000000-14479237206067-15135125040560-16656960476079-15583124740608-15590912409000-14298810782256-15823252411039-11276987930624-18225770533236-17583625881000-11511079504543-15210901560960-11305166298244-14356025029104-11098826722125-16329945907200-15466725690823-14602639134744-19625265437310-15708038976000-14624488466487-19654625038320-17260989199193-18143997691392-18153035046875-18380895588384-17733260476323-16646898180352-15778595692008-14470910982000-16013668928743-14265840209920-14712103741779-17795120631624-14287136036875-15173884851264-14301345022445-14528583093552-16077478924287-14322676160000-14770707903707-17865993913128-14344028497955-15234298389696-14358275173125-14586408232176-16141458205079-14379662868480-14829467488483-17937055125000-14401071792315-15294872069952-14415356207005-14644386600624-16205606995375-14436800535040-14888382701931-18008304516072-14458266119635-15355606104000-14472588323765-14702518401648-16269925519431-14494089359360-14947453749875-15624468684720-19875222145907-15639928250240-14529971723085-16549992182000-20138318631990-11193484262400-19486287058479-18151368831144-20178150468750-17496367744128-15485199318777-14819243112432-16399072665847-14609121280000-15066064172547-18223184252808-14630757296155-15538772448576-14645193168125-14877836427696-16463901736719-14666864775680-15125603958923-18295188849000-14688557752115-15600150017472-14703031613205-14936583986544-16528901438375-14724760227840-15185300403091-18367382868552-14746510239435-15661689000000-14761022139565-14995485991728-16594071995071-14782807836160-15245153710875-18439766560296-14804614957795-15723389608128-14819164946885-15054542646000-16659413631063-14841007800320-15305164088099-15998318668080-20350701807875-16014023822720-14877460234845-20609664752880-16954035153766-18108453312000-15365331740587-18126212499992-15150840069222-16076947223680-19301789062500-15632912249568-11730426889533-17259075686400-16346591612919-19118750951000-17053976810734-15909463305792-12226291995761-20771785269360-11545525518750-16402664485376-20108867961711-19656200706120-18971722016758-18055092432000-15748028963028-19462952484192-11822565316557-12524124635136-16474946402375-18804538811016-16955574112179-16034324451648-11857241223399-17213019750000-17454139571325-15134299947520-15840528163236-19810315922440-18887270083875-17963318020032-17271862840082-11909382111912-11915184961629-17998356992000-16837830092232-12400550106984-18961012392507-18501842576576-18979477912125-17816572254496-11727132973150-16191317380608-20659841383192-19260579266000-18329948380458-18573974435392-15525041381322-19768747826016-12479200296875-15783258324992-16733668173543-20278795850672-17457671027086-16286003208000-12515612270273-19373177366576-21273563743830-17736572812800-16798769095375-21304544657040-15630910759398-18481853260416-15409012402485-17551072766000-21118954702519-21129190060032-16151473631876-13070021216120-19257901054875-18315760350272-20228487626705-16190625538656-19057015887920-18827912000000-15975703686267-19323255867048-12411054626204-18625587057792-17440069754125-12190050080616-21283117505127-17943881318400-16995084500359-19398127941000-15573920175515-16540301888832-15588969863805-15836444470704-17524525151375-15611562570240-16099685960971-19473193170792-15634177094835-16604287512000-15649265570965-15897687501168-17592285444391-15671916482560-16161916921875-19548451805256-15694589240395-16668437940288-15709716554285-15959088222000-17660220180543-15732425745920-16224308039579-19623904093224-15755156811875-16732753385664-15770323013445-19904440008304-16271206604573-21138444288000-16529946975428-19942754608016-21655589550723-17527548584448-16805305772625-16569707895648-12920829254819-13170941549568-16349571568683-13183593750000-21738946981339-17595005400576-16136495514282-12475093428264-18599254384500-21791153844224-16657406248324-13479362903160-17899368734467-18889206952000-19634556606480-16206272064048-19653378675760-16959160014336-16475478194875-19927654756776-15998985350595-16991669577408-16014307602085-16268464278000-18002518357303-16037309317120-16538673183939-20004079044744-16060333046875-17056813287744-16075694435645-16330815398832-18071504461647-16098754880000-16602029564747-20080698479208-16121837367155-17122123286976-16137237943125-16393325629296-18140666578919-16160357191680-16665547543123-20157513309000-16183498511115-17187599787072-16198938324205-16455995172144-18210004933375-16222116451840-16729227324891-20234523782952-16245316678435-17253243000000-18762456667575-20273102464248-19030732889652-16284032860160-20803354277875-21314778552360-21324920397655-19076058528512-18080651637288-20601646462000-18349211250863-19866806502912-16857073121899-20389132658664-22413520222875-18140901299712-13360062821689-16644961702512-18419079662407-17418081792000-16921239548787-22740812842320-18454080279491-17957006195904-17712490468750-20758760346032-18489125208159-16470726970880-16985568602363-22066343919000-13195330859932-17517487219392-18287778818664-16771739668464-22372912793000-20094286823424-17050060488451-20622519524232-22670038723491-18348487488000-13512917620513-16835369343408-18629748599311-17617270135296-21201811630875-13033779796536-18665015506379-18162227149632-17914884858430-20995925750000-18700326893223-22297220100096-17948766428390-20779096038984-20788908298875-17974205621120-17982690690510-19533279438112-13114044440229-17236383552000-18274038495551-22660196233664-21125141280054-17784415801536-18824267430125-21155035343472-13421711308876-18850897166336-18601426181448-23262736770000-21204921430502-20438752876992-21742578237828-17609421550432-18913130859375-16848385149440-17374969610411-21015443694312-16872178566035-17918890968000-16888053282165-17155932747888-18984422623751-16911884021760-17440442813875-21094622676936-16935737169195-17986382011968-16951651721485-17220529854000-19055893316383-16975542238720-17506080290619-21174000289704-16999455191875-18054042312384-17015409630245-17285288908272-19127543161527-17039360000000-17571882246467-21253576781448-17063332833755-18121872081216-17079327208125-17350210113456-19199372383439-17103337505280-17637848887243-18436230470000-23451322403259-18453492856960-17143404654805-23748127734960-19535372729750-13733979963392-17968218932484-21677689463824-21687823960838-19051868736000-14295579648894-21718246402736-19343569854591-23064064793088-22279153312500-22554909525960-13804740377116-18326380317888-13817631962628-13292385350000-19681910313334-17296230481920-17836738977379-21573876514824-17320443586875-18394890080064-17336598204445-17611520498352-19488487523887-17360848960000-17903366416107-21654451133928-17385122319955-18463570370496-17401317123125-17677255499376-19561216993479-17425628180480-17970159568883-21735226125000-17449961870315-18532421401152-17466196909005-17743153867824-19634127185375-17490568343040-18037118641531-21816201736872-17514962437635-18601443384000-17531237761765-17809215806448-19707218323831-17555669647360-18104243839875-21897378218376-19743831818099-17858869725312-21386442317011-17875441518000-19780490633103-20331844953600-23595874286079-23606811804888-19002789531250-20912754799552-21465884213307-18485523059936-20125916177686-17686356480000-18238993436947-22060334785608-17710932238155-18809537165376-17727328718125-18008385070896-19927579661119-17751942407680-18306618247323-22142115369000-17776578870115-18879245076672-17793015835205-18075103317744-20001396828375-17817690275840-18374410006691-22224097817352-17842387517435-18949125000000-17858865017565-18141986148528-20075396063471-17883600284160-18442368920875-22306282379496-17908358379795-19019177147328-17924876464885-18209033766000-20149577590663-17949672632320-18510495195699-22388669304264-20186736783875-18259427742336-21866045842627-18276246372912-20223941634207-19124578752000-24401991570968-23580950635080-22759147368694-21381224928448-24446923875000-14174618678376-14181135744333-14465844117504-19760519346119-23110941391000-18107246253915-19230369052992-18123886393405-18411167366064-20373218167375-18148865712640-18715880242251-22637046742632-18173867973235-19301112216000-18190548897365-18478876157808-20448131105511-18215589416960-18784678017875-22720245606216-18240652905995-19372028662848-18257374664685-18546750750000-20523227457023-18282476459520-18853644183259-22803648076584-18307601251875-19443118605504-18324363895045-18614791345392-20598507446167-18349527040000-18922778944227-22887254402568-18374713210555-19514382255936-18391516788125-23212209818672-18974740779621-14733393086464-18992082506603-22971064833000-14753591185372-19585819826112-20446707925224-18751371356784-25013239625000-23034056749056-19061555076211-23624340841816-22211314518042-21936554024000-19096354803047-21101112533232-22822412582960-24830686069248-24842001891375-23424969360592-20006035280210-22302593778816-22026690414113-14595750129000-25482611993319-14895494987776-24932652257559-25230711667392-18931644261750-19801178174784-19235977257591-25851124727280-22701861844121-23862168000000-19270988886667-25610412089512-18712734184755-20161332580480-19882342763625-21909340269216-14420586527150-15581306216448-20495834441559-14729043831000-21381254907694-20812824930816-24581846013745-19674399440992-15051954235500-24036132090368-20570353385023-26086919492880-22618913823402-22339049656000-24380917769124-22068922092448-25855579246663-22379567874048-25588234375000-23563473672456-21536872227342-22711305641856-19517260544663-21566134278000-23325291007280-22460751233536-25389213317919-24232849992632-21614963242750-23085868809024-21342157130269-19889353052896-21361456743687-19614581248000-20794993523191-15823056309552-26090521743923-21116472334848-20245758242625-19961350641248-15565135507219-26149478911488-24691546105716-24702688500000-19123800309315-20309807746752-23558224566160-20033521769952-14737173068750-20936220737536-25665806959191-24496806111896-19488166445814-20383172424000-19210189880765-19514517628848-21593960366031-19236157391360-19836966684875-23992800719976-19262148292595-20456713564608-19279488560085-19584903558000-21671834828903-19305518469120-19908483395539-24079287151944-19331571796875-20530431380544-19348953697645-19655458531632-21749896293247-19375046080000-19980171789147-24165981172008-19401161909155-20604326083776-19418585493125-19726182752496-21828144983319-25427737477120-24242008922289-15869170377000-21867339608083-20678397886272-16190349906078-24596367677488-15604687923500-21916398832128-21625860302856-16226661981168-21945869557227-20752647000000-19558349856565-27092917836720-15359526737277-24405462134784-26225006178375-24728882992912-25946774070898-23241806812224-19628482823885-19939372926000-22064016650463-19654825848320-20268646309499-24514838109864-19681192431875-20901678009024-19698783247845-20010776163312-22143016486007-19725189120000-20341196205187-24602573802888-19751618579355-20976460328256-19769251328125-20082349661616-22222204668559-19795720122880-20413919018763-24690518577000-19822212532915-21051420806592-19839887264405-20154093623664-22301581422375-19866419056640-20486814956051-21413667749040-23565523629263-22045105728000-22667556199554-22677645616112-22994329080525-24844925781504-21787339997375-15350022446800-21499589630610-23660065736384-24900226827669-20913187500000-22768585123574-24933446811648-25560440941491-25571797772312-26507850423250-24052682878848-22829346326882-20987633662816-16365271284387-15445788800000-26887601350047-25662773546424-25364833429654-24138228796032-22910529287250-26018081300064-27888877769670-20150898094080-20780134058803-26995119771000-22661116396803-21428903003712-26098918601028-26110480437216-24567162015625-25822499895808-22098907579743-16503671216456-20249311364035-23063265648000-20267239040165-20588148488688-28087168561830-15610884915200-25925530289875-27186970662072-26886359344658-21893920711040-28161769236210-25982887637000-22862517531983-25379207152128-26017342618331-26028834377272-25726590609750-24796318260544-20725057555818-21362515628256-28286397035910-20438080000000-26109371453283-16994314166832-20465142335755-21734117246016-22058827708750-23960144150816-16085606037093-26190074487296-22413431452159-15791062050000-27172593516866-24655767187584-21820477875993-20880953355504-23105769716375-20582688522240-21225341414371-25671781609992-20609878331835-21887805192000-20628018167965-20954585800368-23187235554991-20655247874560-21300155296875-25762254766056-20682501533395-21964920113088-20700683951285-21028391142000-23268892655943-20727977553920-21375144772979-25852940238024-20755295136875-22042215948864-20773520186445-21102369583152-23350741243487-20800877760000-21450310048507-25943838274728-23391737414811-21157967132544-16356505857375-23743372396464-24074775556725-26654426791936-21525651329283-27320625625000-26367912870182-25414358634432-21241546423482-21894811622752-16750420771500-23525306311168-21601168821131-27416459360520-27428454311215-24857821912000-25191664319718-24556458490528-16162628882350-23607754739712-28471103287000-26541486931472-27848358007218-24944889510464-24955787233993-24642445428000-16219215715550-24988499447296-23051403903807-26309561045544-26321044921875-22756509256320-21790734824911-29283907333680-16926971850828-27681157120000-27367426450644-27705304682280-24130428186638-23488489087488-23825097901125-21876400108552-23845866545519-23856255392256-28443812483103-28456200903000-27814142507535-25534679374464-25545795908646-24246304608816-28518196961625-22627722768384-21981406650291-27898990937320-27911126209415-25295193000000-27935407309585-24988400453408-29275453193103-24022887542272-23374880401375-26678704758696-28008335094655-23735013502464-21436749582885-24415513454000-29707437242790-16511297126400-28742128273239-28093577795240-27113801091750-26133167080384-22504130610484-22513892378976-24511038467366-21539302720000-22211677053387-26864564445288-21567328410355-22904471134656-21586025703125-21927614991216-24263777958759-21614091898880-22288789706963-26957817117000-21642182411915-22983954480192-21660922935405-22003686441264-24347941877375-21689054000640-22366080629851-27051285339432-21717209411235-23063621496000-21735993215365-22079933626608-24432300197911-21764189224960-22443550027875-27144969361416-21792409607995-23143472394048-25166811626175-29877511375000-26531936964729-27887358692864-22521198106859-16814116933200-28596331879375-23560079957120-21886653717045-22232956014192-25612625638004-27983743488000-27995807179523-28682762875880-21943330392555-26343343208832-28719857980625-25689993988896-30097293142607-21990635630080-24369346887048-28104536459000-22019051379715-23723030943360-28479888302628-25778605560224-17306243578125-23424401670144-29887448521304-28201420728216-22434868614774-26865402968000-23815020189870-23144534275424-17365860268437-28274229868032-24196780235375-28639473513504-22512108088998-23886731559040-29017770871865-17418137049000-30409404324119-18458568548352-29751566493159-28053737974288-29434835139250-26365749867072-23636584039137-23304013711456-25713976574925-23667000000000-24706585512072-17164704200400-26788412744106-27143478549056-23030280183375-26135089472416-18233591555179-24436591460352-24791378524488-27902240181000-29292661098135-24823225852416-22419445827805-25534596787056-17605696147125-25901803507200-24530860247823-31108752884880-22822838798694-27329924232000-23880642648009-22852115526768-25286624845191-22525107138560-23228105421875-28093733299656-22553981364395-23952141530688-22573244550285-22930309182000-25373136387743-22602159889920-23307551630779-28189807539624-22631099911875-24034029123264-22650406977445-23008681005552-25459845023287-22679388160000-23387178784707-28286100565128-22708394052955-24116103141696-22727745048125-23087231200176-25546750976079-22756792148480-23466987089483-28382612625000-25590278016523-23146261024128-17893357031727-23867958755552-25633854470375-29157736624128-29170135378019-29182537646296-30250182348594-27447873648000-23234994286746-29584376835552-17969574551397-25732082304512-23627147974875-28576294843176-31411977708907-25422726127104-18721895403977-23323954038000-25808654980503-28649152217088-25122874159207-17699670061200-24790048281250-27280617593152-28709961208173-24112408221536-26251096998886-23068169280000-29468760932603-31967617983120-24874236855090-27373251190208-23117077043125-26329048452144-31323477460264-24570852077568-23868753079923-32076074610000-24958615819970-27822796769664-24622886901633-29988368473056-26072342913375-31085658604032-30741345143878-18595648509984-25043185390930-27559147000000-29719166857983-30089937797472-18634973849804-24020589477888-25465405466375-29781989202328-23333092512795-25138554259840-23352796741885-23722078446000-17978855431550-25540746853888-31309611495039-29162624201064-30975845145250-27745882540992-29920509860879-18392642398632-18400395374109-27792697856000-25637832511831-29261118767688-23491037041355-24947143381056-23510830078125-23882588160816-26426712288959-23540540474880-24275078715163-29359834857000-23570275890915-25031282073792-23590113406405-23963113818864-26515803532375-23619890544640-24356893263651-29458772717832-23649692730235-25115609736000-23669574774365-24043820281008-26605094784111-30991547568640-29545525463625-19340375651208-23729287758995-25930565031232-23749214381685-27048914750000-29254341116080-23779125227520-30376852157891-31854152878968-31501219403250-28949301340864-28961439412547-30807351818208-33021712861110-26795503808000-24603439456827-29756919417768-31239478778495-26472760339968-23909029113125-27230908521904-18775105649613-27622008422400-26528227762248-32436959544000-30237997019302-28406097138496-25465463383473-24368458225584-26964264359375-24019316605440-24768724433611-29956797303912-24049453762035-25540090008000-24069559198165-24450071749488-27054559016551-24099738357760-24851643793875-30057071019336-24129942733195-25625555938368-24150092997485-24531867294000-27145055027583-24180339422720-24934748009819-30157568248104-24210611091875-25711212321984-27958622577975-33191397128888-29474307626321-30979584000000-30992493952883-19425074573216-26160032809890-28788022776128-31044169630375-31431279416544-19465560334636-25091067375104-26600109553359-31108844963000-24372486770515-26258214648960-31898240070745-31536079372896-19530454495500-20290060099584-32703133596231-33844892780880-26334747912130-28980262696000-24474024565965-24860873733168-27509057095391-24504540802560-25269017546875-30561797273256-24535082395395-26055746628288-24555457549285-24943582422000-27600563239543-24586041425920-25353049128579-30663415801224-24616650686875-26142358457664-24637070968445-25026474347952-27692272083087-24667722560000-25437266800907-30765259335528-27738202587211-25088763663744-19394801787375-28153131497264-28545394366725-31603315470336-33521000413912-30867328125000-28211451734574-30130093373632-31668764811991-29009900952864-33986172467375-27887827424768-25606261240731-32498986488520-30982425073299-30229916904000-31773671608223-19531648945128-19539718762797-27213591117824-33743453447000-31072142464776-25328496808758-26490725145408-24965332997085-25359878478000-28061138936303-24996256197120-25776002512939-31174888512744-25027204921875-26578297719744-25047851590645-25443689630832-28153864640647-25078842880000-25861153725747-31277860811208-25109859722155-26666063078976-25130551818125-25527685237296-28246794389919-25161611271680-25946492264123-27119434230000-29843655624167-31019155287040-25213433879205-28716334045616-29116364803125-32235363237888-34191307662424-31484485154952-28775429240526-30732343000000-32301682027783-29589598898208-34665215834303-28444948623872-26117732140875-33148045732360-25358915623795-26930517985728-27722489928659-29686959716000-19538911061550-25411008696320-26203633890899-31692017486664-25442298756875-27019056604224-25463173060845-25865516254512-28620558321407-25494505920000-26289723789787-31796124770088-25525864472355-27107789067456-25546784453125-25950437170416-28714511659159-33448396881920-31887405455409-20873140361000-20487690375932-27196715587392-21293096131998-26035543756464-19731966018750-28820454681088-34756675514264-34770888985536-32018109236739-28472177088000-27692598697470-33244700637792-21380327060778-32875782377472-34474236210375-29334891872464-35692143383070-28565375629824-26592523079783-29382837750000-29394832376774-32188557454848-27033520766436-21078841886792-25861957151875-31047008773248-33847078904905-27088706216416-35867319235110-33091125248000-34700018458647-20349681458328-29539022604878-27554366473536-21173571662625-29575143688304-35984420987670-35599086862848-34813278323583-20816408756000-32839239116502-31650681884992-33667586745828-27265804254432-29282552734375-32504818323456-28503467705943-20081028707600-32946279876998-28940203584000-21713977116414-26550093699888-20121882544350-29389887534592-35443301663000-35457701704128-32650460877843-29034420125184-27835952735961-30672339844000-36337254972390-31908983242752-28689334049447-35573042470592-28308220841250-31151677105472-29545389263429-20649671968392-32809839118119-26339560000000-27161016247467-20277632440400-31645929106506-32064636545856-26799033038250-27622312600288-34135504044012-21140062388224-27655893687172-33363259722000-34597870240135-28096700538432-35847978671736-30157092271856-31392376274875-34667944220160-27745576288484-34696000283720-33484973966838-32272960552000-28199173882809-31072517574048-20450709798350-32325182160896-29472832125000-33579844991632-34822439896055-29508571206144-28700477021230-27891723676000-20927240243541-34071809222144-29568200525064-20541761125200-32058080954250-32482184930624-26736632159445-27158917610352-20583237275950-30063647232000-29663774432712-22256801723952-36697295890323-29699667675648-30124300167125-28072300772448-21888698092019-22310677767168-27692918369883-22328655750000-35161113162335-31864658164416-32291481196806-31476160962464-20716336068750-30258023661568-29855539655496-33600996388872-36934466318531-32382553008000-33226233054480-31577615069728-20783100092350-30355525274112-36607671727000-33709241126376-35804441624418-32070346556864-34583223444847-21258468873000-33777011996991-21692716138496-28378789031556-34235220778768-35501975234375-28830818286144-36784496349304-30944830072048-32212269569403-35573264320000-28470026863588-35601806654280-34359045302134-33115279716416-28935067829625-31883284951456-20984252515150-33168405823488-30241545924168-34455559418000-35730436100535-30277903643136-29448639650990-28618705065312-21472622431125-34959629874688-30338564578056-21076879499600-32893089254922-33328125000000-27432845212565-27866030940528-21119072626350-30846176284672-30435790509000-22835968751664-37652104403027-30472303716864-30907876845717-28802403068000-22457900613043-22890775053312-28412861164699-22909063288176-36074961849375-33117299599488-35254271365279-32293904483232-38258044142310-27641835520000-29780007723270-23407912035640-31081076020691-29389720193856-29827547968750-31544551840624-33262918430274-36262501265920-29021563388452-36291411045000-35024487987862-33756547748672-29495311902153-32500529747104-21390442768750-33810357325824-30826771427016-35122243679504-36421695204615-30863596608000-30018214899470-29172153957984-21887819532357-35635522550272-30925037061000-21484260366800-33528772393194-33972129096768-27962862859685-28404345750000-21526995257550-31441901584384-31023511299144-23276876443056-38378978619875-31060492964352-31504393751589-29358210187616-22891218227587-23332385664000-28960930865227-23350908329712-38501026426683-33755858927232-34635126970000-32916420609696-21664127663150-31642167873536-38159105688792-35571443626000-30377902128770-31692366967104-23452958241918-35627861448368-31730051109375-32612279923200-29145174805211-22629092956704-31780343084347-31357404864000-31805508987693-29638775213024-23109951687211-31843282747392-37965227616375-37107136414760-23146542183159-34515093796288-29283869390423-32356165446000-34993466085680-32819341401600-31081255136847-38100531230808-30667711891250-35062659578880-37268791039705-22370106090792-22817742625548-28533440000000-29423003287667-37342425352680-36038675708614-34733889304256-22871834446500-36081353083312-35215206203440-35669459676672-31278153094559-22035554050000-23366896526943-30874105144960-22944089760644-36195324106608-35326426670000-29597539500032-38447766807831-38905014106816-35824401170379-31856452416000-39836244965490-37195133291232-23034622695084-23929984797696-31475880859375-22174835518800-34606353668874-34176121760704-31081422343230-37312375548000-23107220270732-36897180217344-31575056464727-36926195036632-29374539009750-30721813606464-37860583027505-37429863918048-22734201564069-33445780800000-31674440176191-40166464795920-31252849369490-34391630040768-36192408751125-37100603437288-35773650321840-30866879643648-37144291177267-23727947625000-30903217366119-31363384626560-32272130453544-29594384309424-39474647201000-24232573246464-37260959458619-37724663282208-29203140991635-31012401624000-29226024475765-29687277940848-32848786977031-29260372111360-30172498909875-36491478827976-29294746647595-31109669932608-29317677955085-29780365758000-32951774607903-29352097349120-30267071124539-36605842219944-29386543671875-31207141412544-29409522852645-29873647963632-33054977272247-29444014080000-30361840750147-31733717299760-40362913407843-31758509265280-29501559368125-33599503519344-34066844377725-31353730042368-40002971691672-38654311765000-37304591310422-35043586877376-40065435657016-23228797180584-23237855596125-23702738255872-32375971448983-37862720248536-29663084951435-31957310000000-31969762517070-34723551263008-23310407714277-30635404927488-32477027861375-40268892559808-33875662445982-36178637674048-33902041935346-31165352748000-41264312978790-29813599928320-30742897478499-37181244537864-29848406306875-31697553801024-29871625602845-30342981915312-33574223945007-29906477120000-30838657246187-37297043814888-29941355734355-31796248760256-29964623203125-30437434709616-33678721519559-29999547002880-30934615659763-37413083277000-30034497927915-31895148374592-30057813619405-37933800478128-31006714955125-24074247821312-31030772925051-37529363173032-24102266469788-31994252856000-33398249041512-30626927924208-40851729723816-37616731029504-31127129247875-38575411745688-36265633694394-35814555160384-31175382120183-34445843750000-37253166860080-40528501341696-40544187769599-38228850759248-32647012571250-36392174302848-35939505686161-23813295539112-41572607236631-24299005952000-40669824931047-41153197776064-30876829100502-32292797622336-31368892282375-42153599798640-37015788646377-38905028973056-31417394619803-41749671537000-30503107375715-32862183455360-32405228925273-35706493342624-23500180468750-25389989167104-33396014856743-23997941622552-34833974870286-33905588544000-40042867645985-32046646672224-24515707719724-39145926303232-33499181775375-42480117329040-36830289007434-36372114846144-39693957245796-35927414564000-42089098105719-36428186955776-41648244550616-38350075496904-35049358880750-36958138958208-31758311588391-35089841965808-37949560271920-36540504000000-41301905275887-39418122089464-35157383026398-37547313902656-34708958514125-32344061457888-34735647446839-31892915093504-33809956905159-25724495214000-42414067193059-34325684015616-34815796326181-32443607101792-25296638623875-42495569990144-40123575031092-40138975584288-31071841726835-32996611992000-38271619892880-32543356784864-23938117538350-34005164027904-41684278734375-39783008546008-31646809806678-33097984001088-31191210946285-31683213342000-35056982514943-31227081233920-32200245461979-38943566346024-31262979011875-33199563420864-31286926141445-31780425895152-35164532942487-31322869760000-32299006529507-39062994526728-35218390545811-31853465660544-24623456682375-43469777856240-35755485347302-25135083177984-32881521111332-39666403250000-35326270671723-33403345340352-25667446292281-35851258917936-43619539623750-36363500851200-34922293329096-42213885325944-33978163854530-37390249512000-42262252599147-33045173099104-35488503579231-33556727809536-32596500954875-43803048410640-34082032835410-37504534454464-42391412584083-40945245852000-35596934323703-24390755942400-33184071237956-40519522960792-34186113281250-38107611155328-31768440283645-40092374812464-35705585708047-33761967168000-43075135738008-39663799170408-44087664094830-38713901265216-32845803901375-36291259261744-39248721048240-36809673830400-42715463264103-42731709003000-34394909427970-37848786074176-38846634525603-33450320162912-35923551293375-33968041680384-32995994059291-43354487861696-42385254258114-37964003000000-34032611505369-33552121726944-44424081299430-40984428838912-35072277726375-42003874840360-36581957101582-34123146654528-26220477492737-36623611654000-44559125912790-32193796344320-43601975779736-25774573133088-40659928441750-39187219352384-32254869673845-32763510425712-26320061425627-37259481600000-35782652949192-44248089188872-44762205552030-38808602431872-36832358781250-33858765276768-39848920558640-39365703377408-33398737947963-40392857817000-25941028645532-38926263602304-36444770772301-25471045081704-44466280158375-37485753139200-35499929422663-40515229431432-32524510006235-34539066696000-32549097010365-33062339698608-36582766728911-32586000744960-33601333052875-40637847949416-32622932362995-34643572122048-32647568937685-33162351750000-36693413963623-32684547051520-33702937115859-35225308066480-38762455183375-36259083274752-36272757347496-41326217476784-40333462006320-34800725184000-33804745793627-41388565292496-42918948454495-36368572128768-35371654998750-38417977556896-26801575303339-45023368347648-44028179976183-41007187413000-45580694364990-40024780729792-32944175960605-41575984926768-37026693859375-37040624142848-44668508177304-41638583638864-35558500231730-39129058584000-34060164028447-37632830992432-40699434486960-37152192212992-44293909506375-43291919606760-33627531550998-35169262344768-34162690478823-33665438334000-27044518993363-36243053019648-44427174282159-41378757966504-37817004390750-35275034491584-27105483446569-37859591103408-46062722159910-25600000000000-44560706088087-41503111776648-46131859442430-39995933956992-33342439008125-42078534865712-37474197873039-26703951898624-44694505191423-42655559283000-42157422237142-39601674245056-35500504015593-39116645712544-25744270168750-41721329995776-36584236804823-42268030110224-43830817023015-37141171776000-36122981528270-35104022612064-26854292824684-42879612539392-37210681125000-25850412078800-34135300035078-35700243818688-43994997713065-39351403652000-27452679970923-33680959569920-37322076379464-45632908930752-36312461001250-40477565751168-26995119145956-46739763978480-38444817685606-33781700160000-43152730272443-45769364087744-34339830063462-40598574836352-35406830996500-39587098981536-46896940784070-33882641428480-34938204690483-42254470125000-33920546182315-36021383525952-33945831717005-34480917336624-38152191945375-33983783575040-35042484799931-42380571420072-34021763709635-36128856504000-34047099513765-34583768625648-38265979941431-44572858122240-42491115644625-27813172069288-27298545911676-36236543039808-28369579995486-43095751326000-38379993959503-41549954350592-35251667096139-42633526167144-34224802421875-36344443345344-34250238914645-34790084376432-38494234223847-34288417280000-35356569694547-42760380116808-34326624006155-36452557632576-34352110918125-34893549243696-38608700958719-34390364935680-35461680200923-42887485449000-34428647342115-36560886113472-34454184723205-34997219042544-38723394388375-45105595842560-34505297363745-46732174472896-34530872629435-36669429000000-44125941906983-40419441547808-26601585436350-38852695747072-46321040913375-27163765605816-28239460055279-41575341265536-42123940683291-36271997708000-39487071300694-34697419960320-35778261226099-43270312229064-34735929856875-36887158837824-34761618944845-35309460056112-39068837088607-34800176320000-35884205422587-43398425579688-34838762196355-36996346213056-34864501953125-35413951608816-39184439539959-34903135354880-35990358556163-43526791557000-34941797285915-37105748841792-34967587761405-44129230708528-36070110645125-28005037811712-36096720832651-43655410409832-28036028260188-37215366936000-36149980463807-39941559147312-43195976016560-40511148748800-47010245430375-27027334806800-44341154986886-42193705147776-35715512708634-45472843500000-28701761348403-35213230507520-36310073637659-44455548573648-39590843642875-42860648972864-40162718996082-36919857461216-48882488731110-37490356224000-45113677014323-29361857806512-44058976926507-41898619450688-40281004017250-37028578444128-39765873522799-37600730116608-36524265484203-49080466170000-38187714894770-42567650146944-37669823686473-45875750930016-39882846234375-27327043788800-45926281063572-45396190627416-47054273863154-42692787696000-36137916786906-46010580383712-27945239088837-35629540277760-36739298018875-44980996586192-48838731773067-42818170252416-38440643868830-37356021612000-49459906068390-40132174413824-47846273359959-46763478057640-36323760981750-42943798055808-36901125111991-40771384721008-44093304367920-41352600000000-39161451866671-49107666918312-38638136699890-44174021893120-46952063285625-37575385995488-40353030939239-40367783448576-48680321652952-27669383050000-36536933263446-43749582546112-43765567048163-42118964730144-27719966918750-49359562130944-46603565762292-46620582643488-36088621884835-38323445112000-44449198228880-37795607479264-27801029278350-39491865903104-48409095984375-46200237475608-36750937943478-38435447316288-36220508544285-36791156622000-40708084298543-36260137105920-37389456217579-45218651509224-36299794561875-38547667529664-36326248923445-36898549859952-40826896582087-36365954560000-37498556081907-45350580387528-40886389318211-36979231791744-28585260612375-41491746049264-42067746391725-38716407080448-37607867970683-47728828125000-37073509258566-43830079722624-37100475078282-47235952769376-41065214240375-45582072938496-46724530499219-48430961018032-37181450986614-41703438224000-40591057217832-42861677495328-45698114043207-38942158158336-40085464683375-42359172382200-39549577911410-45215921986560-48624755103374-42420696225000-28290724325550-37923322556416-39635752969190-45880861980744-36831326796875-39112046151744-36858038745645-37438651862832-41424426819647-36898130880000-38047239886747-46014075143208-36938252077155-39225578870976-36965015693125-37547300845296-41544628200919-37005185351680-38157614985123-39880595230000-43884531935167-41049736782336-41064590142504-46784925847088-45660341790000-39396289565184-47406878768059-51423638363280-49155910521314-44027599000000-44043514507377-48064836927072-50944243837303-38365143257088-40670289056375-28651395830800-42419383372782-39567494833728-30403399524337-51647057190000-29851295980012-40773214540288-50554056986136-46549506314664-47141197781750-44857807682688-39120916188884-39135029073376-42027758980407-43194777600000-40905802271431-50142084795576-42664965975758-44410630589248-38079975656250-39248054358368-30601418874499-51405804016128-39290494879652-31790524535000-42209894194443-39911391955392-49183912273145-28942130185200-49219334606875-31280009601024-39983287083957-42316382344456-42911494604206-40026465576000-30756026978513-38313735087408-52264793664630-31370153665536-41260774117375-49414461487560-47687559029686-45959406575168-40738161278430-44245898500000-29701995445101-37869085163520-39048310399459-47807635560848-40242824382375-41424153523136-45524565472854-49044056771808-30371505438508-44989333312000-41498559241551-47945112502096-49717034492495-42128361543168-40387495871625-44500733864096-29287298343150-38087140782080-39273129196403-48082852746000-40474464967959-41662565334208-45786545307126-49326256360416-30546242187500-45248139965952-41737256182943-48220856544464-50002935034815-42370593984000-41208381923870-44756545841568-30044748612237-39484678995968-41856947130375-51897596648128-38937123495798-40721555227968-46049528293782-49609536396000-30721647864492-31914657303552-41976866686447-49680525466656-48514990849750-42613753185792-42628981447656-39090528892272-43251941199527-32006016000000-42097015069271-50415834168680-46280462812506-45703436491328-41563412108750-40390299144288-43375650645439-38635938465280-39838947849243-48180689001000-38677309484515-41072097546432-38704906564805-39314382488304-43499595756375-38746326794240-39952759796771-48318315261192-38787776563835-41189390472000-38815426159965-48984599730736-40038260858789-52008499865088-40664800062500-49054428087632-53260959792987-43102858950144-52101162570243-45529860132000-29964516349550-43763762622464-52175371930119-52793865564352-48611640742875-43225717381632-32430818310462-44458036991728-30650893334469-41483599296000-52925427290648-52944239646144-54166762287630-46359143013568-48182457690000-39764650235376-48216698449840-41601673986048-40410175170883-48871441125000-31385398608252-47094812029824-44091560224421-30814626393864-53793628877375-45347796211200-42944479219503-49010379040872-39343268027635-41779205784000-39371180951765-39991067630448-44248227945831-39413075087360-40640186289875-49149580034376-39454998931595-41897840467008-39482964671085-40104597918000-44373828991103-39524938053120-40755518427739-42595470429680-46871607234375-43843512540672-43859032367976-49968244170864-48766758899120-42076213248000-50631323737203-32342283076904-39679094948155-48853081912320-49481238214125-41554493677408-48293613026937-42195409248768-51386482070196-54464444361000-44688870978283-44092269467136-44720456938461-41672128409312-32491220030875-44767863779328-53372323214151-52163786169320-32537138601447-48515875000000-41160898958567-45477336548592-49182038362160-46124430604800-43679866521375-53542098384792-43095044989010-49268850600960-52366614379465-31431047601000-32058641515212-40087428792320-41335453133699-50607489061008-52477469224375-47555163971392-48189735704214-46970642355232-55024469149951-32160450816000-53825856414207-51369185769784-45815157623358-48927994444096-41510500109375-45863553912624-49599668734640-46516051046400-53977603130343-53996591499000-43460814970370-47823710147136-49083138879523-42263633176672-45387204717375-42915315531264-41686040580251-31119918843600-41092728258054-49826869120000-43613827909470-42382601813984-33045101387371-43036090269696-51786229725875-33704075988144-53071338082455-48093265419584-50609374545069-47502004500000-33763268240154-45658951760384-45049286043144-50698225252584-50716007863875-49481108345664-53884399483598-42621208443616-32604115485708-32615544832000-54587442035847-53351249627880-51486300182854-45223323130368-40840914538125-56568767894640-32066863033413-45915702529536-45302578848648-50983246233000-51001095426291-48499494524096-44105881996190-47903145285024-32156780578125-42259963707392-44798614118343-55544466256576-54301078414354-48635410824000-52443515716103-31603525668400-46789570355238-41113313845760-52516888934875-55700016596928-41789610588198-49404977970816-43086053951892-48171823204000-57065505216390-41228369694720-42511774958419-51412777535304-41271570916875-43826653598784-41300388491245-41950414650672-46415892643327-41343640000000-42630619688667-51556488919848-41386921694755-43949131367616-41415792933125-42067621795056-46545560991639-54215778795520-51682455852849-33828701193000-33201989762812-44071837108032-41531412155805-52411725122608-51151200670000-44133275533824-53106339952379-33923084866696-41618267642835-51240314240000-51898876231941-43584590333664-49370313328259-48104699596800-43630101562500-34017643933928-41734263212395-50098533353856-54613540586065-43706023996000-57866319323190-53384156793344-55976336975919-32825118989304-47645155142750-44441324278464-34147949335209-47694831505328-58027375900710-57402556416000-56132097128727-33561868354976-52942859143974-51023631564736-54271806634500-43949567569248-47197526289679-44626839771648-43348342291083-53718813875000-45320738291570-49870102113216-51831060886160-44071677897952-33065218180125-42156553687040-57093270906584-48675901973400-48043533203246-44812870824000-34433406165393-48093486041072-58512338122230-48777169420800-46842298533000-56620709449752-45572665387410-50147285929664-56679532760883-44316576684000-47591612386903-44999418150912-54148462729011-34588690719272-45046135734375-45714783784320-47690475485509-43132325395632-34648539634467-54279678656000-56915233415967-56934904579416-48444125751038-50425494927808-56338842444750-33421785775656-34088885932556-34100659666944-54448696101827-55779967265000-34135997135292-45311479582272-34159569004964-49285613953800-33525783421125-45374064489984-47363185790856-55276113008928-43446213102534-52021737000000-56650788264686-33606819464808-48779648924598-58687641092096-46174730183750-56088640584360-53467595308683-45562164932928-44256765903543-48897447014000-52880314354480-57527149211136-57546961109439-54258342064208-46334044811250-51647138844288-51002546811601-33792534833832-58991581547351-34478852096000-57705620074407-58388984108224-43806802318422-45813773192256-44501137234375-54482807456432-33897299765733-35903597995008-47222810318719-33266930850000-54576517115062-52597883934272-57278130119982-55965301635936-59316939418375-46003086065664-55356050838899-36027147776688-56728871430615-51407327048000-54096401854701-50774540141088-36089028813978-48803762719232-48151734741000-54189287139816-54207876946563-52887545794368-57593530382414-45554687500000-34847882615052-34859830460416-58343172118599-57021488830440-55027819447750-48333668055552-48350230134696-44336229663792-49055356831967-36299954304000-47744064670751-57177962071880-52487155573866-51831983876288-47136116798750-45805044738528-49189893217399-43814209454080-45177793180803-54636616773000-43859198370715-46574152379712-43889208084605-44579667582384-49324675359375-43934248317440-45301553760011-54786271883112-43979319354035-46701694488000-44009383830165-55538500596976-45394522374029-58965262184448-56951423476500-56970874099104-44099659461195-46829469231168-36661662345726-55690417998000-49594977809983-59126516230656-46229599621476-35364109569568-44900529951750-53762908244544-55823572760986-55842612178544-52455457392723-57925120000000-46355895555268-34096837280400-45023167043382-53227332792192-49149666729000-51897882166816-34154976697150-51249918758400-48533116358159-58122816485000-53354395827018-49266982319616-60920199517933-46561616685792-35618062655500-52760082952192-46609177066884-35654440610464-50070380059907-48715156728000-34318118583050-45315324664368-34341466888350-50155591716352-49485349125000-57065005270008-48143473369810-53663819005056-60564372597432-57831092508000-50275050373943-34446665318400-57890057025108-57220319329432-56550117795750-53809842922368-62109362902770-46943006880096-36600352767107-49047304384000-49754992847112-55993362778728-50480277676811-47730424015296-48438596578750-47070598222048-35314922532573-57492796583936-49197262067479-58224946500000-45763681857366-54796309130432-59671896917022-58303931268576-50686062725375-34728244300800-58363216698612-57687951871096-59793304604994-54249503568000-45918970771146-58462115033952-35506872773997-45269176975360-46677869179875-57147473283472-59258281280855-53699195398464-53717363615993-53037671828000-34905008015550-53771892855296-49598642857807-57302309433168-59418818359375-50348249667072-48966233549310-47583275546336-36399507842828-58118846976000-50433383652552-35035015248400-46261842091542-48380988826176-59619897100625-53325203194656-37199868965459-45637883399680-50569797554568-61828392472000-49198274437970-54839434126464-36571958693764-63318976288560-52079832285750-45761228963840-58453277072659-61995458517696-46512272182134-54987582000000-47954052655668-53613771877408-63511391729430-45884796572160-47312573780875-57218055054696-45931191711795-48774150702528-45962139172885-46684966086000-51653789828263-46008586424320-47440201201299-57372385531464-46055064956875-48905676431424-46086068028845-46810829777712-51793033935807-60327244480000-57507652130841-37641119052744-36943328576284-49037438398656-38390028468750-58315566635632-51932528060759-56219843985408-47696144188963-57681878517000-46303479201915-49169436816192-46334593645405-47063235417264-52072272427375-46381291440640-47824460167851-57837041523432-46428020601235-49301671896000-46459190805365-47189777770608-52212267259911-46505972264960-47953006077875-57992482537416-46552785117995-49434143850048-46584011132685-47316546750000-52352512782623-60978838279680-46646505046505-63173355050432-46677772951875-49566852890304-59643870009919-54631958097312-35954115903950-52510588928000-62602068668247-36710051589528-38162433354391-56182381736832-56921714537875-49012303743328-53354767162662-46881354990080-48340025453003-58460476113000-46928419369715-49832983077312-46959813115605-47698215471984-52774755734375-47006929981440-48469493145811-58617031645512-47054078353035-49966404648000-47085528109165-47825892983088-52916006260351-47132729013760-48599191798875-58773866429736-47179961452195-50100064152768-47211467268485-59578961318000-48696617480157-37807001829376-48729121618019-58930980714504-37844855093500-50233961803584-48794173279191-53910043991408-58300562159920-54675000000000-63444143349087-36474305400400-59837797928214-56937849700992-48194234558250-61358553666144-38727223137179-47511472353280-48989675577843-59977481482000-53412367588163-57821671288512-54180103824578-49803696042592-65938597053750-50569749210624-60850521056779-39602668706928-59423767062579-56508052216000-54324503803314-49936417348064-53626040547191-50704482041856-49251156671875-66180264261840-51490649187810-57394364816256-50788811465841-61850403468000-53768805305743-36840184038400-61912068870708-61195339858232-63428278137250-57547077015168-48709848901098-62014935601248-37664424442269-48019612160000-49513566546707-60618803571216-65815411223123-57700059860352-51799283628750-50335995594848-66643267214070-54073021257216-64464559184463-63003498125000-48936581736966-57853313591424-49710984455759-54922865820336-59395747310000-55701963571200-52748662481703-66143467056968-52040183466530-59494193280000-63233513988385-50603561790304-54342398152431-54360388352512-65552022767000-37257794974800-49196565248358-58906283832128-58925774165211-56706840868000-37319473245550-66450634371072-62738194849428-62758941606816-48579524296875-51586082977344-59829723162640-50872074493536-37418300001950-53151545152000-65150879024367-62175972247544-49457467935942-51722614224576-48740294793125-49506489651696-54775259569719-48788595015680-50306385321923-60838243749000-48836927137115-51859386161472-48869166278205-49637372570544-54920055863375-48917551587840-50439339030091-60999014184552-54992549602827-49735686000000-38444792322351-55801029721392-56573740179525-52064995823616-50572526785875-64180317856360-49850548970838-58933694641536-49883399413914-63508874604000-55210413528063-61281043527168-62814832089451-65106676124784-49982037327750-56058912594304-54561758732136-57611920918432-61422383604879-52339986432000-53874805577831-56928726288600-53150954070690-60763924689920-65342699218750-57003648928200-38014926569150-50956747165184-53255891758230-61644928257000-49484408680915-52546863609792-49516932116405-50295248394864-55647866082375-49565743984640-51107622401651-61807116101832-49614587920235-52685084136000-49647168364365-50427517225008-55794195446111-49696065768960-51241983482875-53553965089520-58928686703271-55120222785024-55138300916328-62816991750000-61304965596080-52892869066752-63645613839891-62132344725384-62920026707750-60637940604864-50676145930938-52228894117216-69149124601110-38428764800000-63812644343323-66909859038936-56930471337278-60797025632576-61586765370000-64687273248864-69330479441670-41611902640128-51646479245203-38554760650000-57079715533614-60956388659392-50942249207322-52503120961632-40162576187500-64126613713408-54873232404543-38655755387600-63416163071798-60342409296000-66553118999726-58833604619168-39493345905837-53449631563776-64315488749875-41857480450224-65908294687255-59724659815744-62847755679789-58987518484000-41925867563034-56696063629824-68368248261016-63727568817488-69967718088750-60658475399808-54454854186110-52916258386656-56825689854727-53729472000000-52189110489267-58439696280600-60797100657306-58477809124800-62396663210000-52274238425672-66339677383155-53869757756928-64820967855307-42186417894000-63300241335411-60193904241856-62559490127760-53192883879392-39125150668750-57141318647808-68905110675544-65011203183256-67382930739474-61134640944000-50962112555965-64311583941936-57271622397391-39239899571200-55738781859375-70677773565840-70700758207470-60508095367104-63672068195109-59761115492000-41689061889723-54292079726592-65329088543971-42517074144816-63796333282875-60665600091712-58320944753922-53609627110496-57570203081087-54433342656000-65499050315243-68677921842456-58434667721118-62403205903936-56102097059875-53749023687648-41115532235596-59320489574400-56966145497928-64899156250000-67295336421335-57021595992576-55455640609390-60228504248864-40429600075125-53130614697472-56320842129103-69828739333056-52388527024614-54787571544000-61953843633318-66741139309152-41329327231244-42932818354176-56466987608375-66827647580064-65257636647366-57317939771904-57336495271848-52575466878000-58170474094303-43044139348992-56613385688607-67798517940040-62235238406250-61457224796352-55888275585310-54309026400736-58321190998647-51946618880000-53562288047747-64775341475208-51997014432155-55214670662976-52030629568125-52848172453296-58472168011919-52081079431680-53700915706123-64942972209000-52131561896115-55357528731072-52165234989205-65829697103088-53805043274125-69888802271232-67500622650132-67522406413728-52266341263435-55500633000000-43449290886654-65999836231856-58774903262271-70069393402368-54784543238500-41907570880032-53207527391238-63708329142848-71795809665981-66170268262000-62962734684018-68635346042880-54925968256196-68679579347240-66276937131750-63872737653184-55805548002897-61486774412832-40464850437950-63955047872000-58306909187592-66426466048336-68878864407695-58363226224128-56760284218750-55156302662368-41380535487933-67366456610816-58457168516808-40608311850000-63369338111898-64202402747072-52841745387405-66683324279728-59383504937375-70794868879872-68375633403252-69211862210120-42354978911388-56219854776000-42382196418692-40765201484400-60351874868918-53028805672960-54678012487875-66124492052616-53079898619995-56364440701248-53113978810685-53948424750000-59689374950223-53165126443520-54818557808459-66294441402984-53216306901875-56509274311104-53250445449045-54087020506992-59842703035367-53301680640000-54959343763027-66464681700168-53352948684555-56654355817536-53387145638125-67371514871472-55065091268821-42750774769664-55100370557403-66635213193000-60073187142203-65031523900992-60935105980658-56012345662432-74157714843750-65114826440704-72556181775704-72579397277376-74252677224510-64372906416000-56963478080529-54504231603888-60304262296751-53712745781760-55383147488875-66977150760936-53764277034195-57091089835968-53798649506485-54643777254000-60458641133383-53850235678720-55524898037619-67148557333704-53901854816875-57237165048384-53936285895245-54783560884272-60613283218527-53987960000000-55666890249467-67320256097448-54039667098755-57383489217216-62393257884375-67406215128696-63265511602868-54125918945280-69136676409107-69991960164000-43342171263612-57530062554432-43369810015844-55898143546248-63427057676500-65951767760384-55951600485771-65993802027928-65179195150602-66035854152000-58531418782270-56877200522464-42671484268317-69467860692992-59443233484375-70349593505184-55292274673878-66204241289408-72093375210654-42766652157000-62073317139334-74679496791552-58755367001590-71368495472840-43674612169500-65532750960768-60511004384616-70618616516448-61390450220887-42061619200000-70685979262164-72391977384368-65678703581946-64857269429568-62350164913250-57312946500448-42998363038773-59879477560832-59898492955279-74263959000000-44741357725103-65866675165824-54906319174005-69288418110448-61703167610375-54958610903040-74429112295384-63454027493400-55857257912214-58414746984000-64361286977756-57604676740704-43217207008197-63574866700800-61051220613000-55981358841936-62786872541662-58563070435008-44997482761577-62846581102000-76459247469990-63736224153600-61206156490824-73980863112888-59543683281250-65518791967552-74051164846971-57897395267936-62174232074447-58786026048000-57100149119947-75020944078784-45197365524111-66537922768512-72532213525625-58044125661408-45254583408059-64059757670400-61516814196168-70082968618000-63265601275054-59009546820672-45340500746321-63325612908016-77041976613750-55659009635840-75377544569624-44555347927584-70282550836918-67732625000000-55746975602565-56622496524528-45483937845931-64384384204800-61828521309000-76451046833224-77334448215870-67044340311936-63626240382946-58485803868000-68828535986480-67989620352512-57680271102699-69754858188264-44795018625500-67213715407488-62924977373149-43975144731432-76765129536951-64710105600000-61278206271031-69930969676488-56135127013355-59608370657856-56170502578125-57052629716016-63123541371359-56223593786880-57971799773563-70107377337000-56276718438915-59758706956992-56312153458405-57196490030064-63282692992375-56365333872640-58117931749251-60739329621040-66834279652063-62514047808000-62533708374312-57340591973808-63442111898511-45205849581568-59133925646500-71330972073552-67002574894871-62671447770624-77493216357261-59226903500000-45305390579852-70594027573248-59282736965636-44476016936664-63681741907875-62829111716352-63721738813589-59375870699616-46292779185587-63781765568000-76037741216847-74313059847880-46350917676991-69110779853376-58631327287375-64777301078704-70051478981040-65693857382400-62209686457639-76252671891000-61371959348770-70161369379840-74569821318945-44755915532424-45647783187500-57077608573440-58852276263211-72050724221264-67678581088503-63303689664000-65082501975634-79179181683120-65123267713238-78348452294656-61641669363750-73993157452704-46700771125159-60818144597568-45848306580388-59092263293000-67051000917396-69719554212352-59147737407419-69763174370136-72435054229750-69806812718144-78667706906397-60124454553056-46876356086347-46006272000000-73456038230483-77905438618304-72616387336614-68209863326528-70003410489875-67366089693216-44333638577150-47895282920448-59444185786443-73662805523000-62144653629170-69268516896384-70178473642363-72866214138608-46222263535500-48015021072384-63150558656023-78295533978816-57849969037835-71222170240000-58776616144026-60576610669664-44555514368350-48134958621696-74008279296875-78491069041088-65132204166459-64260002962944-72315031380309-60727831596000-47346733089323-65233740529664-64360169217864-76004420428840-47405750512375-61736138950464-46540272368356-59984020098824-68062756393044-70771466176000-60040050835307-70815523945752-62767457949490-71756556958720-74470588923375-45773271024936-45787508434173-65559365922816-79055045207512-73687834250000-77306390844786-69237705137216-74656050510391-68381004428064-45001484318750-65722584186368-63941827263903-72970382383272-72993051032499-71212866984000-71234985070699-68551141620128-81204191752230-62275877339136-65003699133000-81279847826640-77691517980818-71389939924928-61468638441012-61487712284000-66029348165903-67859417433600-64260176199407-76955058892040-74262022593750-71567306154304-58902751162645-81582942037680-46244665845789-66213863936000-65327066513352-73515726568008-77170039273895-69928637663808-69950303047625-69063245985056-45450420285150-70015326047744-64579580033599-73698109929000-77361468741535-70102086045376-66480993095661-61946669062112-48296906000875-59250385059840-61092372275491-75705011840536-63867353136930-70275821000000-73036423928080-62100160635744-46589523668277-47517732374528-79525401753375-46632751058616-48476466760879-71364775787136-63149889360201-45774930550000-67767830439894-81529734459392-64144320106790-77913591339240-70602347267375-72458545121984-77985800409105-62407904007776-49574518665786-67038093504000-66140172889992-75349556873936-78130352365695-66201426390528-69900844437500-46921617167976-81908081598887-76409749897216-65382716251719-80141556579000-71873206461498-70973631279936-72839551231123-47037496804104-47051995159125-59986711216640-61851510863051-75722189492304-74821793883939-71148802648000-61003473697386-47153567070888-47168089265757-82338287947776-65705825972375-81463280178368-49078216013319-73176840242368-74125937339920-63026437500000-76025856523582-63992660823552-77000361664491-50112032025456-78904313729375-71500009597632-79881712413998-63181706830816-47400850056429-62290849792000-66029998443751-47444577775128-61417736024502-64229183766336-62386632732375-76377249101872-47517517053813-50328120572928-66192483756239-46628741650000-76494620122902-73718665744192-80275338870862-78432541893216-83126654984375-64466288799744-77570204775939-50482849263408-79488127071815-72028984104000-75793994449821-71137167342368-50560332391098-68371040968192-67455130437000-75910290452136-75933563918643-74081364557888-80670256301934-63805334252000-48807267634892-48822223896576-81708364222359-79854468745640-77059675059750-67682879304192-67703609129256-62080647921072-68685985386127-50824368000000-66845090607471-80050310396680-73480416720906-72560561185728-65984333458750-64118680945888-68854350508839-61327424737280-63233759962643-76470167421000-61383717117515-65181103597632-61421264501805-62385275379504-69022990541375-61477614282240-63388602281371-76657403005992-61533998516835-65340665592000-61571607152965-77698680180336-63504899759389-82486773055488-79666724812500-79691053005984-61684524998395-65500487777088-51276900408606-77888691134000-69361096232943-82688452118016-64649776852516-49453149496608-62786609019750-75176595055424-84718453793517-78079011614704-74292929624082-80984931840000-64807699901828-81034322933480-78198119208774-75360176403136-65840974802625-72542594907936-47739934421150-75452079047168-68787402267528-78365073250000-81256831374335-68850279230976-66958156543390-65064873014752-48813512770125-79465784803328-68955159297096-47900102835600-74746902888762-75728235224000-62327001384765-78651832738096-70040616401231-83498455715328-80643720328500-81628583281160-49952672502876-66303508982208-49983054259268-72112860225000-86561737497990-76005064404992-64479582048339-76051268090296-78963277343750-67428156136320-69375744657576-63613750474032-84844096342632-66545688768000-84895636746008-82026366542280-79155343607734-74351363171008-84998780163000-73430318282656-86983346439270-50272295583744-84134938826103-81258380196000-78380065932651-73564098181888-74554652861689-87168230008560-71693389835750-86251978607104-83369877245478-80486017879736-83420429974114-75683322000000-64059141940266-81554523019872-49530249223677-63145913692160-80656901087875-50547340969632-71954541257582-76839598163648-77835814114320-66180474428000-51597457026643-69142046335488-84748997800239-80876963247352-72128994054750-77025875896384-72172651267762-66340879466976-80023496481838-77119127552000-65424611376387-77165781590392-64487109288822-68416098871680-82124139562500-66501543484768-51847752492099-79262966886912-70477262790408-48957332850000-72478745110334-67601949984192-51941821569561-88229735325360-49031323768750-69645505867776-85366037335911-83428781942120-80508535047558-76604407152000-66803487274228-82546860890592-50132861525157-53097870836736-69834931437375-79694873125416-71845440841979-67929187578048-81736565479967-74865690500000-49268595617550-71953837686784-68031665466213-79887333995784-51301154261500-77961781590464-69100877334510-82946039056608-82971030330636-68175307584000-82032682366523-53386736316912-84059986644495-76171390167488-85100156812750-67308755567328-50496764337213-66358856044544-70341744814839-50542375623000-65427463570326-68422021365312-66458763971239-81362061518768-50618455453125-53612132373504-70511225906143-49670725467600-81484484100598-78526947368000-85510730790126-83547215990112-88546871192743-68669329637376-82627059969875-53773517371824-84668930763255-76723132506944-80732993922189-75772227924000-53854331180634-72824940122624-71848905815304-80854287462504-80878560739875-78905237914944-85922623217678-67959208159456-51984401559948-52000000000000-87026102610087-85051010200680-82073822142214-72086434564608-72108054009000-66118871294256-73153407335039-54129703707648-71191872581759-85255255085000-78257683243818-77277532773056-70273355053790-68286000026592-73328992996375-65312499466240-67342281219171-81438187792392-65371204395835-69414828552000-65410360551965-66436559022768-73504859398191-65469124098560-67503757296875-81633444103656-65527922829395-69581224394688-65567141535285-82740216214000-67625033605997-87837875490816-84834347298708-84859716421536-65684891536875-69747885939264-54601620515262-82938356739504-73857435320287-88048181568000-68839833926628-52657955692576-66855066267462-80047395049536-90206914860125-83136813341552-79104977158194-86229884600320-69004506040132-86281385625000-83261009337382-80238819588032-70102924902513-77237860447264-50829545818750-80334646193664-73238231173896-83435091439184-86513394007215-73303791552000-71288829988670-69272657966304-51969985322397-84603820797952-73413145773000-50996548374800-79578327719514-80622583720128-66354805303085-83734082126000-74565965917503-88892762712576-85853061757428-86900998244040-53178796937500-70585186609344-53210472979716-68580060634984-53242161598028-82959593472000-72739312662311-91207402151752-92259651760830-71778859089280-71800215488750-69769531091808-52342714153653-85210539122176-72912621782799-86288473236000-54460106729263-81200521196352-71971219204990-86391136489056-52467351976125-81297111814144-68968673239091-81345435834168-84459590024518-72121070000000-74203708341672-68040269959728-90747303919976-75301369155072-90801207871000-87731753036360-84660464993526-79521840837824-72314040752030-52701580881000-76491653824694-92024017518592-72399915902790-87940265731240-92105946107875-79710803548992-81805469457427-87008826494688-75637235606607-51821686400000-87086244131124-89186156882928-80913747007626-79900065370048-76809832031250-70602923065568-52967881837533-73761446817792-73783297744919-91476809336000-55110305138823-81129751557504-67628146471405-85340769060528-75996592357375-78101804659200-73958260536063-90651733482264-72959762093330-81322078032000-74045845558691-70938129263584-76176696777111-82462180212736-91883774279000-86688735147288-94027630187070-77334466772608-70039745642583-77380199750000-83678997836080-78472247385600-91054709087199-52345756613200-85872406857750-81707642360448-69157660432938-88044840602208-55568509832987-68170186240000-70288480819827-86050108865296-93423424666483-81900880693632-84025699370000-71442925292128-55699890355539-76741356699136-92537425799192-52593595650000-77861485035614-81041930850496-70537804197039-77930402553776-84273928750000-79030104883200-74837224481543-93837698217928-73826687573730-84398226560000-89699544577985-71780782902624-77081488289551-77104199393792-92974911183000-52842215742800-69772270207398-83539890209088-83564492120251-80414829284000-52920069893550-94225456812032-88958071360788-88984256036256-68877130716875-73137240657984-84821753229840-72119704002656-53044795529950-75345768000000-92352253102287-88132086079864-70101545938182-73309530906816-69080008733125-70163400239856-77627786801239-69140949729280-71289310475043-86210913141000-69201926555515-73482091520832-69242597683805-70328522902704-77810458251375-69303634250240-71457033516971-86413722498792-77901901342507-70452534768000-54456577216911-96128051494320-79061819007958-55573259010048-72694049562500-87686193500432-86642262933723-83457767043456-82411963402153-81365536692000-95311270918799-78199586123264-94295636101656-87892150418128-75051880951250-82581269867712-71877491597551-79410347294128-85874182553520-76235669504000-94516965621848-96693398323920-75228007323490-82775046722368-82799290121625-54857148713736-95759135190847-69956924244480-72130556372683-54921421875000-75404409027570-84046647594624-74370716035113-73314326960352-86277386510000-56096708575232-73378694232324-55050118769112-75581086278530-84243554928000-74544937261089-55114542541128-82155487869972-96236525897216-73550524454500-59506782560280-91991904853855-84440769568896-89879894494047-55243540833000-55259679758061-83455652560896-94321590828279-95433610872512-87867953296875-78127653929472-58612848692382-71658840326832-57561018224867-77132550592000-94542118569567-90221676098744-89160677485334-84836121731712-76157192938750-55502140956456-56606924914956-58801259225088-72978394427123-58835559006000-56672983752892-75222614379072-70882540544205-98173664296560-55647957541125-88407807561216-94984204722351-89551427854544-93947153437314-84139979000000-71047944558565-72162001798128-79838792433271-71110037340160-73319381215875-88665656341896-71172166288795-75573984529728-71213605685885-72330244206000-80024914846863-71275794936320-73490272197899-88872295970664-71338020381875-75750079180224-82360989375975-97763463091448-86804038048961-86829276672000-73661428512787-60485914843640-97905657575763-85829896793472-88056246250000-83677742374176-55067141789150-80421384951296-79342764572808-98104961393000-58439024018623-86029578520704-88261087682960-72836540020464-88312347630000-89442209857536-96095444819511-99437934102480-86204553881082-87335077016000-86254590382038-73005828831408-59749370474778-83009309068800-79712050581000-97454095352768-77542783634610-86429870606976-85346533468273-92023583625000-88723141884080-76545890660352-92103627329091-97680338084032-72171156776875-86630481445248-93321393420612-56675830938312-57803860310508-60044471424000-92317304098123-91231458150096-91257873976054-87944625574976-77948176398750-56807253102696-84678447665588-76901366366208-92531311092947-60218513262000-94815825058935-85916830911296-95986815800062-75918504366432-56955345703125-74845327304192-79336639136943-57004767037752-73792202215974-77168694168000-88378100770939-57070706611368-57087199446237-92933465157632-79520270980375-56016369622800-73962968019798-88557003754688-89703879509520-76270317692000-89755696517680-88659342346752-75213809286619-90956377681704-58408603753500-87638193172608-82044031376429-57334973404392-100084020056711-84364800000000-79888384295271-91166559869448-73179451853755-77705206929216-73221666708125-74369592225456-82280992907439-73285019425280-75561718811243-91377065601000-73348408674515-77884595562432-73390688474805-74541247304304-82470890306375-73454138634240-75736075174771-79150032824240-87090110034543-81458358336000-81481813089192-92825449058736-90587484557360-58898814261248-98570609859375-99732299812288-79355340713810-88449965974656-96415515605065-77154602476000-59017550435532-61305084444672-98797709188119-99962053532352-92036984092875-81834174853632-94363739446599-86430190423072-101243394872191-87617775168000-100163377258648-99053612567256-74026836539955-91136128670720-97999482916750-95747920509024-58149362815773-94662415937536-80999536968279-81022794875000-102734438746590-82211145509376-76523998388359-102822935099760-86853175924500-74303638423040-100624560431384-99509642296344-93817604871478-90411181544000-91581888174480-93898358352496-59562376788044-76765838082048-81372197918375-58467209609496-60777459430839-80295125626240-76875933444503-84932080902000-91844777368880-86129150553600-99938439362079-57452338821200-94248825593750-89677000153728-75902270487978-96630553769568-60986736008667-74816468480000-77140591680947-101347989614784-61056601475111-89882602672512-85297641725250-78404045645408-61126520279059-74987934727680-101551169294872-101580217112000-94681365663222-83158633115136-83182413107304-76272347829744-84385958728375-62440335212544-82120945376583-98341908209320-90268953956922-89137125000000-81056904705070-78763490568544-84579079947471-75331652764160-77671729020875-93928461371496-75396216599795-80058838139328-75439279644885-76621752966000-84772495586663-75503904952320-77849315071699-94143195816264-75568567156875-80241829698624-75611695796845-95414274370224-77982682100053-101289976896000-97825110663924-97853007558432-103707154384363-83921843363328-92107162796875-59478536390376-59495489892333-96853589590016-82874271878119-58378793850000-77081964385206-92291061812672-93485927154960-59614254618504-88862230908500-104091985488384-79553602842404-104151274637608-100669210990434-91330626192000-99555295485785-89039482646688-89064823548532-94951364603904-103186391319000-58645312566800-105591594359070-91538747554176-86869154937026-79848413500000-98664326388684-61095284463616-79916550001636-96397355940048-61147408601500-82337217173120-95303002574133-89445514244512-60039704450829-85963603968000-103656800586328-103686248540864-86036889218931-81345637743936-62500626942625-87289808110704-106193425883670-88519647782400-85002987600648-102741100791000-82688717958770-90983405532096-102828606218979-80394591147232-86330446734375-61513107914752-102945357392871-104158174608576-82876593417730-92374394736000-100692950999985-80577202301024-61635330914924-64024066262016-84203653565375-64060367943024-61705245264156-81901317605568-77175277820485-106888354110000-60587227608621-96254032969728-103413245813559-97497562495888-102282499959250-91604450532672-77350328001245-78562569834672-86919563481327-77416040000000-79820658490667-96526913263848-77481789204755-82273173191616-77525642683125-78740615251056-87116529653639-77591453921280-80001503867443-96745588461000-77657302393515-82459522324032-89655256229775-106420980643416-94490269311625-94516976566784-80182622192571-65840156196760-106571448592651-93426085584000-95848697044880-91081984300448-59939283718350-87536070295552-86361328125000-106782341899464-63607439179799-93637377065856-96065447055120-79276365102000-96119685567280-106963328881152-104589164633919-97403595128424-93822518234250-92645794738112-96282523588240-81863228956896-61414737903069-60227507200000-80727616916307-62671935522976-103678961322802-95266824428736-95293677803875-91700769026336-60346455501150-107446960383488-83325047871981-66437229375000-88205164484923-83395489858752-96717657206160-79814539613424-61692239830125-81069489487872-105298976515191-99275252445584-64183774922487-94485728688000-93300625478137-61813909313928-92140766322772-83677654811136-106749353007000-109206187946640-104381933342818-95912699012928-97154099864720-99610956566000-88702981944903-60772549222400-102126586062228-100939160347992-104616961531250-96128637466304-93721332222441-92530166117152-108388140638671-93800355264000-87734062889352-98728545700008-108509982096843-95125344093312-97591853530000-92738293873056-61029165635150-89127596589056-87931347319368-108723424301000-64763581576663-95339188923264-63577294692964-110068500184560-90526157475750-79538526179840-101593068946459-107743344578496-80830171098534-95553354000000-83326282142868-93155485199008-110346632903430-79717130588160-82192997225875-99395503041096-79784176110795-84717704228928-79828894003885-81079740126000-89704229046463-79896002168320-82377406985499-99618487821864-79963147931875-84907725177024-80007932667845-81261567171312-89905378322007-104713646080000-99813872864241-65328589013544-64113909759484-85098030056256-66617090718750-101187584848432-62951345639733-66673008811008-107447666592543-105006961445000-101329158727062-97649288510272-100149412729797-63074664472104-63092294584125-66822276685824-82932290832051-66859628432688-80501668872235-92912491800000-96655985323638-92964407886600-101669474677374-90535907487232-106688524951750-107959225761432-110471882142347-96845083061376-91904316261426-63357140625000-106867349148586-64635499708416-84546931488836-101982099567248-64689618181500-87106471285120-100822746715533-94625505402912-63516403449429-93432523200000-88474118216751-93484632804600-66080891042191-87300977662080-104790373558500-63640458889896-66154594046139-67421576060928-88671586649239-103687213239000-112463238960990-97495290332544-92521294233858-63782434206024-107584644156250-67571958703104-83862624818011-66357559840456-96433102853703-91449038296000-83956039039247-92753370950832-100301817494960-94059117772800-109138932336375-62740973382800-102923818099046-97930374662016-82887208738554-105522147276000-66597963214563-81699456350720-84236697866219-110670000864192-66672050123375-98148401390208-93141027336402-85612835692256-66746191957147-81881280000000-110885451811288-110916253325504-103382488233414-90800078289408-90825293529000-83279637316656-92137901039839-68175725442048-89663337264159-107373227485000-98558073255018-97321509464256-88498650645790-85993971853792-92342670816375-82245736202240-84799890570371-102547706137992-82314191911835-87403912392000-82359850147965-83650111528368-92547743758991-82428369154560-84988177796875-102775379038056-82496926153395-87597927665088-82542651931285-104159580534000-85129575974797-110572010582016-106788753081108-106818328991136-113207905025875-91609283308032-100543572253987-64925845824072-64943819205669-105722138432000-90462040985791-63723293384400-84138024109062-100738532035136-102041928090000-65069725762536-96993473572148-113615879897088-107262623164116-108569575625000-113710166929539-94571673675392-86927726592436-85673055162888-95929183228125-83161604631040-85744113817131-113930372835368-110120443200994-101185100424000-108900122127385-107648673209952-66658061893644-85910070120448-91064171488375-64147407094800-100097585980314-96274251902400-100152863062902-105317971246000-65520720321861-106661189712384-111832341149679-97719576979424-115752480468750-92627532099072-86218842540911-115848302053680-97854436989364-91441856512000-92755341204552-115976146407120-110852205643282-99278755507008-108333951946500-98043449370656-110974480332858-83899175559680-86504519099723-112357713303000-105929549793622-100790012878464-85307349069162-64644579849200-98286822720500-91845870022656-113868480376024-108722566746528-116520534242910-101012262000000-95858524239874-88110455374944-68693224969331-94641232758272-114119453151000-107665006865528-101206997786154-97341189998400-84385568762885-85707373686000-116905831922790-67564165267456-113071126309239-105302059987464-85825265517750-89751077615424-109292212277892-88498963162976-68996088022627-67712875776000-113319976016607-108139562688184-112079001240162-101680969183872-112140577468750-66520233441576-116116205650487-70471873732608-92682902651319-87485340919000-69223818578023-91452779429760-65341341811850-117646691445360-105911076180375-90245300504064-108585723337099-70665513138288-111263263111615-100819070968000-112633999415406-89083863548384-66831217622157-87821945929728-93090560762375-66886197597336-86582334176118-90542703306048-103693243327571-66959551125000-66977897882901-109033109476864-93294837315567-65718586533200-86772294435750-103892252422464-105236154999440-89475225378016-105293792326320-104006086144000-88231839956627-106697541367368-68515934570044-102802028264832-96238482895125-67253501543496-117396064194607-98956331942400-93704286507839-106931313513000-85832547359715-91139467653312-85879497425605-87224563167984-96502029484375-85949954621440-88618785803811-107165426869512-86020450343035-91338970248000-86067468899165-87415461287088-96713212842351-86138028853760-88812682248875-92814712567920-102124066259831-95518710019584-95544791400168-108844610518000-106218853781680-69061101797376-115576073649159-116936440524992-93043007741250-103704785179008-113042460242705-90458640975456-69193125715948-71874000000000-115828583871087-117191899616704-107899233059187-95936582020608-107958081835125-101321618304416-70677758719179-97375146213376-96067416508488-120116997090000-93449789603170-102822778037056-113536589231745-68140512007944-113598456411875-66840822604800-89591096308171-117703933409216-93653624390130-104385310224000-117800105478968-111137164559784-107149317533360-92441440505856-111227938171875-117960508650688-87153629984395-105954001622208-115373710855454-91250541436000-71141091367923-92642837908992-118185317618456-108813795171624-110187128365750-106184754357824-112936003122852-67242085343600-102235751176244-95535673344000-118442591689048-117128472889656-94266906755490-103721769935168-111834359038375-68736164192136-121332060074070-72819007699968-95769510896079-121430936250000-89073531732966-101247402945600-108026547670160-99951680524336-71606444542875-70274446508032-117606460990791-112229712190296-116317758740594-100114527184000-87962291298765-89339783961648-71762012033491-93451352679936-119216653567000-109763264875176-111148493896566-107111115608128-113921173086756-67828602150000-103127418029236-96368828612608-97752617713224-122223880190160-116823350031250-104625986617152-114168357536772-103323158737952-116949976359354-88416361280000-91161542977547-118405994573016-111631266520534-106214584374912-89898206582250-68123135202800-103575189098228-96787216576512-119994080621272-114570794436000-122787632391390-106444735073664-101013346380418-92848180463712-72386535165875-99729169929728-120253972051224-113452025474936-106646389457322-102572325000000-88920043114565-90312445951728-123186617075430-71193722748928-119144758488375-110957848300296-90434522774838-94570721848128-115160670914436-93250482908000-72700150913443-71347710560256-119402438331039-113943425012152-118093733345250-107137181493888-118157493120718-70089051886632-122345273836151-74251994112000-97653962643831-92177192185816-72935956246951-96356492023680-68844628906250-123953751753840-111588459736023-95082467071488-114405398874187-74452494438000-117225332692735-106220983481536-118668397708782-93856112879072-70411053154125-92525719191552-98076059333063-70467979083672-91218420388854-95390398536000-109244508221459-70543928039688-70562923801557-114868619740672-98287563027375-69235227006800-91415100052518-109450555829568-110865835275920-94261319500000-110925510076080-109568413560832-92950110264659-112402750701384-72179200541500-108297920984448-101383004943189-70848269571912-123670421048431-104244667200000-98711482205951-112644780585768-90418257003555-96008254547136-90466864613125-91883346871536-101655857595799-90539808686080-93350720767203-112887157653000-90612791958715-96214797870912-90661469256605-92080980817584-101874491859375-90734517885440-93551456949611-97766564822640-107572086802103-100613882304000-100640883077352-114649539886576-111883221238960-72743604830208-121738295826375-123170617051328-98002906134210-109232525740416-119067366262865-95279434812000-72880279725292-75703657853952-121999700326959-123435073465792-113646826429875-101046474542592-109496348705094-106717337573792-125005102510311-96940032000000-123666783116888-118077185050272-74521034908631-109701837777792-116765266530375-95688724827488-119642930373155-70397035545600-94357279356043-123965121368000-98635011085170-109936997049984-124064673972536-117046854672552-112846429070000-97356083073024-117140817890979-124230713396416-108730946667343-111584959992000-98899188280270-96099185287264-72093658474917-117360260936192-100419348109375-96201983479968-93397468169478-97668901380288-110437825835142-107634837892000-126079735305799-97773322862592-124729720397656-119091987915936-75161441352375-110644490755968-117768524791399-96510817862496-120670729818115-76681869696000-95167715924907-75302017577864-109430241374839-103773238679232-95269345585375-105250933705264-113815149297840-106730166374400-123840016998663-71191406250000-116785043392582-111117835530624-94047854424282-119729182865376-75563552537875-92696985239040-95574668636731-125564365125056-75644146489887-111355013328000-105672649170994-97130468097504-75724797727691-92894773903360-125798731047000-125832235680448-117283990835366-103008487739904-103035915223848-94474735278000-104522601252303-77338670164992-101713095042607-121801606700040-111800630906250-110396658108352-100387301765310-97545038272736-104745325356647-93291194880000-96187270369747-116317030139208-93365649142155-99137582246976-93415307318125-94877683669296-104968365633919-93489827591680-96392051148123-116564644809000-93564387486115-99348588027072-93614116099205-118129183615088-96545827324125-125398777823232-121106839986132-121139003629728-128383742787011-103888584000000-114019128208179-73626827056008-73646372271477-119887675264512-102581737031375-72259832030800-95408289995238-114231134678848-115707790130320-73783285641000-109980730365556-128827386376192-121622141868948-120206130052952-118789355831750-113024714594688-98560491456884-110185046956832-78310129036986-102990609728000-126233209337007-120461299534584-107427691089758-108908266516800-100222151765625-107513101794224-110448111331508-75589777096704-126501007093143-123625669145000-77104653217623-109139248977600-78601064203998-119388769831728-106313259487375-78663501057024-97626842333451-128260234649536-102052184585330-113745380112000-97730214963007-121100802536104-110916814566132-109486334668800-103674476092375-127071334327032-113956149755994-112524918366784-131557404739410-74568904125000-130164447013039-109718133465600-103893950962367-108312452449936-120053622237750-101047423015104-117187385303440-120148802166384-115783690961041-104086245376000-101180954082789-120275786974096-124709042777495-105663786951168-102755803648750-111592895768096-77841903896739-130750151694848-127845678407583-119060146593000-132323959602990-116181677916992-95617739887605-120657278173168-75062736328125-79499154530304-128115751048071-125203570482920-120816470620998-116427045688000-119406038166621-75201398983368-75221221863237-131303005728256-123959093296500-123991759958304-95971286944195-101904055051968-118180756549520-100480106092000-73901892473550-104968327528448-128657036844759-122774093931672-97653300021750-102118966872384-96224353405245-97730448868272-108124253256527-96300360000000-99289572251467-120068235641448-96376406608755-102334180641216-96427126583125-97936377753456-108352063038439-96503239905280-99498731292243-120321143901000-108466087825763-98091014110848-75817529321847-133830812334960-110067592479750-77365123643392-101196365712484-130994417543616-78915095872127-116169712464000-110241246288114-101329378794464-78998055230251-96909854146560-131235490375000-131269953476288-79081072708599-104474123232640-77629723942628-122448238974000-126961369959235-112054141017600-103116865061853-106133604109784-116628075554250-109180555639488-134641478740770-74820443983600-121240913199039-112289548800000-103333478099349-110850472853712-128860005356402-104913551146880-118433477743875-113965871784736-74997200581150-118526634643968-105051124629430-82561799375000-109610738580123-103631816041152-120184308534160-123221187182448-127762736816875-112761353011200-103767613808517-106803332157752-117363961695162-109869389928000-135490874866290-75292413156400-122005636817607-112997749900800-103985136904125-111549475359504-79914448581839-105575000666240-75430443735450-135810317070000-122261257448991-104175718797312-125345594107811-81571471438896-128433112734375-116375710079552-130012046996638-102827096739936-77140481217189-101367904064000-107447793032511-77200978280568-99933254228742-104502972125376-119679589220875-77281690222056-77301876993453-125837874200576-107672559544999-75845547450000-100142264888886-119898553391552-121447955212560-103257710441312-121511368990000-120023795602944-101818899051691-123126612677352-79064870793948-118628250000000-111052840268573-77605100538408-135463834886903-114184691404800-108123032496375-123383796119496-99037506154795-105159533387328-99089155439885-100639832766000-111342770085663-99166663032320-102244585040699-123641337444264-99244211031875-105378996690624-99295932151845-100849827132912-111575076929207-99373547520000-102457872241987-107073414605360-117811425475359-110190015779328-102564626984375-125559534845232-122528993614640-79664575637504-133319651633343-134887154776000-107324520400370-119621296139904-130390455297145-104339500648672-79809784879500-82900948967424-133597376710311-135168120812736-124448463489339-110649619008000-119901585446838-113782357974512-116887933120532-76919943859200-103099513142875-138527873940240-107771899502610-120119890690176-106287510448281-103233524625000-112507535552023-137202349146112-134153983415799-124934421016584-107996054521250-120369706674048-104964937747124-117344209236512-138996319489110-100412287040000-135978070930328-114374870368272-132956639027042-108248600190080-120651163395750-114493619142704-117618544015988-80496719806464-105292242644612-136295886584000-82108581687783-120870377257344-114701627224258-105428820251232-82193763921875-100829801213440-136543418618904-136578804784576-127299592718198-111804214464000-104066988608047-102540307938288-113445174936951-83940085334016-110394252490375-132196360334760-121341015042234-119816377409344-108952181062830-105866662172000-113680395959183-101248471134720-104390820305419-126236488979304-101327100541875-107590446734784-101379542756245-102965859426672-113915941900327-101458240000000-104607080891667-126497983435848-101536977959755-107813278103616-101589492558125-128192185307312-104769472191381-136079107090944-131420682920436-131454647604000-139315321599659-112733652450816-104932031467599-140989890918960-123789763636625-130091194810368-130124795635379-130158402245656-134897750110674-123949698712000-120842924976697-119304329852448-139747716461663-120936537154048-113112703125000-138284539569088-133604763655055-119489202231552-139964248995821-119550868772000-141609919733190-114891008241664-111772131492727-138570202153152-110254723101250-116585048431744-108735709777857-119797747101472-141902325910710-115128222912000-138820479399448-129388785745616-135735405164802-121561854104768-121593176406625-120044965074336-142195134332070-112205058015232-139106879335512-123331035750000-123362797541178-124976546384832-125008726424083-80722614067464-80743395655125-131439745238528-112465349737903-79221335115600-104599074635814-125234141384000-126852015822480-107851955527904-118984965843525-115841825574912-138093577902375-130190642016272-117519331769262-109607015404608-84212544359377-117610010262000-143075975823990-125621197179392-112929083953407-140004417522112-111395772031250-122566838530752-116229588638509-81222357125352-141777391585671-82857508864000-138662595278967-140292442977984-105246355433142-110058537043776-135614171750625-81389395339656-142068939553567-119751750950400-113394091179599-138983353383000-137421103863906-123071401213376-134294162482788-108742216550112-127964842190000-126397699641344-107225547493491-129664135831752-83262522985148-124925814000000-116947730472373-81724158500808-142653234007503-120244218124800-113860373161375-129930340989096-104291811665795-110738141876928-104345271798885-105977731926000-117247827145463-104425496248320-107666162154499-130196910249864-104505761806875-110965296969024-104559295022845-106195084923312-117488273781007-104639629120000-107886921410187-112746531733360-124052928235159-116027230422528-116056922625000-106412734901616-117729048923559-83883243618304-109721534197252-132345106794000-117849559755043-127568442798272-119525049367938-109861914853472-145442654133750-105068772656640-108329344801051-80863459963600-145591431877710-126211489872000-113295667941470-135989542960992-84205513049164-111762785796096-142574460039000-81028909446800-126437386118394-118362648292416-108661954924183-120045343750000-129811887820080-121729716825600-141242521165599-81194584453200-133193107897750-126728219998848-107258937396138-136546211047008-86176140679387-105714685440000-108995245173427-133431195623696-125327107439919-117218873645568-144932505869125-110763187410528-84722859242476-132005795323392-110847933533412-83157143883000-119059194291803-117458177158656-119119892324941-110989273112032-86528388796875-119210978050048-142109554435671-138878039050920-86616600553367-129140648408000-109552242200247-121028813278832-130875278854960-122726815372800-116210965475375-142435604442072-114632533428210-131041956469760-139267515775865-83581775289000-85242320106892-106580012830720-109887349515219-134523210243088-126352709935375-118178041416192-121491657734402-147797703143280-121553459339526-146229848000000-141336678964486-138084876855072-106878556110755-113484537806016-106932896533125-108605613244656-120154917570839-107014441697280-110335221324643-133424232021000-107096028307515-113715432013632-107150442411805-108826543395504-120399321091375-107232098122240-110559612859371-133695557269992-107313795306835-113946639192000-107368283142965-109047772960368-120644055809991-107450049474560-110784308421875-115774166758320-147235927699187-115832915488640-107586418926285-135758829934000-140761306381235-137484131756544-114323018911053-111037454594168-129300257414250-124358688379200-122731675340722-111150087675624-137728289565677-121165217792000-116215266742470-134511739534728-107968867116955-114642140671296-108023576448125-109713260166576-121380249396879-108105675092480-111460221334283-134784536625000-108187815323315-114874601852352-108242598586005-109935689415024-121626311150375-108324808151040-111686135066131-135057702297672-108407059330635-115107377064000-108461916574765-110158419091248-121872705223231-141942463946240-108571686575625-147026528870848-108626599338595-115340466518208-120385695449448-150520158270000-123792300769014-148922963689472-117160021693190-142301690528040-135639404296875-128973739461952-113927661253044-140769720684768-122366491224047-83833833600000-140876409310644-144267031403248-130879881786186-129234555843008-124230798855250-114186849463008-85661754296253-119284698714112-119314803374199-147920455672000-89110936311463-131177486254464-109342151032205-137974127008688-122861609193375-87539933059072-146497980320751-148219234485696-138148204867318-133127561000000-143274628584585-128136669013408-89380992000331-116393263497216-119797167026375-138392159764112-143491437569655-121576314622464-118228975370030-114879939228000-87871495453612-140291754509824-121729523435784-84555680997200-111641606067750-116745614207424-143853271738105-128654130960032-89741914221627-110088542720000-121974925173192-149117984351424-118646429122690-132239288767872-88181708062500-152660585769840-125552503668742-110310346298880-140893256801387-149418373016000-112091962454406-132505631666304-115546776620116-129172984166304-153006464283750-110532447600640-113962084474851-137809685799432-110615812386235-117452447496000-110671412190365-112402283986608-124354972852911-110754846824960-114191365152875-138086922301416-110838323382995-117688691034048-110893997717685-112628331750000-124605037239623-145124480839680-138329809034337-90534816169192-88848906061500-117925251146304-111116881492045-140213393252784-136827875766320-118043649984000-114650848677627-154047233621520-119844566334290-133574579528832-118191759941625-116508043215328-125106171268599-125137536679936-150888545826392-150926368824000-90921619335383-133842711759744-142458064618311-142493762429192-125357241359375-85882636108800-144318974673972-142636613308216-147829172539554-135830576968000-132424984163857-130737910020768-153139309518743-132524485316608-123950022957000-139478683313736-125734475971619-118874661576768-87885870088119-113763117534000-93102205424634-112095509726720-124198398983304-89721283380768-153599840088875-122565352891456-86335216198650-113990985503472-86378401799950-126144000000000-124447106592072-143495723952664-121050742681890-134918828932992-152254159211000-145369836882144-126364880797039-86572915225600-145478837005236-143782858883000-142086021301142-135188756486784-156025987757730-117915743994592-91927869478875-123179406626816-124945517441736-140598801256392-126744133208707-119829154152000-88591482148311-128576586163952-130346629212525-137332711236096-116501108546875-137401251932504-92203583975199-120068572970688-113136289525285-114905500182000-127124143682743-113220958289920-116733781075779-141161102079624-113305669286875-120308310483264-113362166752445-115134890565552-127377905518287-113446948160000-116966763189707-141442813825128-113531771827955-120548366901696-113588344423125-115364586040176-127632004831079-113673238548480-117200055094483-141724900125000-127759181111523-115537057984128-138328784557283-115594586808624-127886441845375-120909049941504-150735738830598-120969233638728-143796308753078-128045636568000-149131325553385-87746131116400-147450167259948-94812968779776-121180033849125-129993513658704-115968989714358-121270451711808-114268682093085-116055505038000-128396329875503-114353914821120-117901791612139-142573408839144-114439189921875-121511785873344-114496063534645-116286422904432-128651781339847-114581409280000-118136324738547-142856995844808-114666797426155-121753440000576-114723746418125-116517646875696-128907571402719-114809205255680-118371168684923-123702063030000-157317367391819-123763463788160-114951730943205-159203423392560-130933066045750-139814568198144-118606323657091-139883932130168-116894039215734-124009270000000-122268018374769-90394419865608-157786232488703-122358976559616-147221918782875-95806675098864-136647078956311-138456018769536-120735156749972-134972726756000-88819846181550-158138492014592-154623110040039-145772821678608-160034185878750-138730642197888-142323072449040-121004565678176-129934122124607-122844848832000-119313656786587-156749264306624-94429172757951-139005628524672-151517978515625-121244376473568-94522674696299-133791594086400-128471704033608-146351188954000-132105691262734-123210095913792-94663043301761-132203724835696-160828070433750-116182324144640-157331878471064-92991819027744-146677191812758-141345879176000-116325983749365-118144802641008-94897299674971-134321811148800-128980796301000-159473981444104-161305659047070-139832767291776-132694620252226-121965709500000-143524502316080-141765441208832-120261134473659-145426219689384-93383088441500-140109207608448-131160212074189-91655091063912-159986590075431-134853427200000-127692742378951-145713575877768-116959492958555-124187626019136-117017198488125-118846766959536-131484144286799-117103792366080-120736748528203-146001310353000-117190428953715-124432813758912-117248210411605-119081371465584-131743673734375-117334918205440-120975025078611-126422958462640-139099515273103-130099120704000-130131167453352-119316284509488-132003544471551-94053078366208-123022773350500-148387519050192-94122570006556-141218612236416-130387730923368-150345076097000-132263756722583-90613909094400-152268828856788-150493126382872-155971003079250-143310937937344-139717175241721-137936588085792-161570734977311-139820296000000-130773208075272-147156036099048-132654715928171-125416791930816-92722157271375-120022876895856-98224673422122-118262462689280-131030614463688-162008200629000-154764952744135-129306017361088-91082947379850-120259026118704-91127701918750-133079123639808-131288358406536-151383469611256-127704156962130-142333857744000-160621214147768-153357889864032-133308025350391-91329278771200-153470846812500-151681029171608-149890320768806-142613583555456-164594509649010-124390806556000-96975442086723-129942364732928-131804859840264-148316834341224-133701038684875-126405943817664-93453389198703-135632281230128-137498850593925-148535161344000-122892533205907-91733323824400-128458127903490-143174134177152-143209217277750-154263098886624-163485469996847-137802404774400-161727761733912-165443906250000-165484426432590-128741630290560-136131622352498-165606026675760-136198293621750-163846158516224-158362011518998-160242644543544-136331701458446-145578922904000-130868771626251-94027331605128-136465196383078-164167215561216-129151869673750-156865633153160-149520284491203-127400282985408-123737774894303-136699022142000-147818862280880-160792316645376-160831626966279-151625487159568-129468030781250-144299638124928-142484457340841-94395885156552-164770327433871-96293826304000-161146340211567-163038417499584-122308683366342-127899402038976-124222505691375-152070644071792-94603619119053-100192997081088-131767401443399-92816599450000-152256382970022-146721833685952-159761487727102-156084189087456-165415272941375-128274595613184-154338974932059-100437808009968-158135119186415-143286759000000-150766993458981-141494891458208-100560362874858-135975864143872-134145883629000-150950915437896-150987717773883-147295525446848-160386114488094-126847838588000-97024929884012-97048575277056-162409298701839-158714415287240-153150035181750-134505962675712-134538729048936-123357209014512-136473781616407-100977795072000-132799433203431-159023950871080-145963392296826-144127148413248-131056577968750-127343095574368-136739833914159-121784280250880-125562039248363-151835823297000-121873209944915-129404577427392-121932520452405-123838524196464-137006231762375-122021522288640-125806620702451-152131559276232-122110567424235-129656582376000-122169954908365-154159565866416-125990265079669-163639065911808-158034740944500-158073148609824-122348232884995-129908914285248-101692548605646-154459535750000-137540065007223-148880884498432-126296736035459-152724182766984-122586206526875-130161573367104-122645748114045-124562841922992-137807500852367-122735096640000-126542270326027-153021070776168-122824488549555-130414559833536-122884107263125-124804907297136-138075283144999-122973571502080-126788122640403-153318343293000-123063079152715-130667873896512-123122775042605-125047286075184-138343412109375-161123848936960-123242224731145-166891457405376-123301978536035-130921515768000-140442609573234-155663306571376-138611887969751-102559664111616-127280782163875-155814216213392-123541186899195-131175485659968-150222799169651-125532984654000-138880710950383-131302593679872-167498923896216-161827901013640-156154119449750-146668019585472-167661163540024-97190781028392-97214300617149-99144448000000-135403057521271-158326376831064-124020531363755-133592880068480-156532369070250-95469650970800-99312448723436-99336464308224-166237732451823-147165520117000-172053232427790-149148848045184-126233377313802-145394780259744-158824780590125-99528728379392-166559456867031-124471041411080-126416515899894-132194649672000-124561274139965-126508151579568-139959478560591-124651550466560-128518010796875-155410038026856-124741870401395-132450262845888-124802107923285-126752729862000-140230040506343-124892500561920-128766414711379-155710395562824-124982936836875-132706205312064-125043251934445-126997623170352-140500950917887-125133760960000-129015138502107-134824441842160-171460983305323-134889469706880-125284706373125-173512952328240-142700596458102-133090736898048-160133240852467-104208180750000-164070924437335-148664769284416-166081177596222-131351639181152-98537461915125-129482358492672-137245698567503-98608682371512-127641968426214-133476010584000-129638348788127-174182993561520-152930770410913-156840182820864-139447054413000-172413542151944-127888005403158-139547762440704-157029010374429-143493120502000-151285895522658-164902497134080-131953732611556-164981840756040-159197233093750-153409830307904-134023086697977-147655128590752-97164888911950-153557434368000-139984724206152-159465370821776-165339202019895-140085690905088-136227152888750-132366749613408-99298916850453-161642948056576-140254076604168-97422062450000-152014924368138-154000814559552-126739963165205-159925735682288-142407099678375-134636291395584-171751279697624-165935950249320-160117815574918-150390625000000-130890783762567-144600636100592-156362527002160-142715043804672-170125862823375-166254802268360-129122933797638-135024540635328-131142234811343-160540932582000-101830861019212-162576698343424-139104981368487-162654672777752-145052187124750-135283787682624-103938543397889-145156524531568-176584031492310-98125750400000-170779720818207-159039908512488-176753348970030-153222935878272-127716368203125-161157705141232-143504028324359-143538397802496-141606022456008-102295506404000-169221539287026-151548584323136-167333942992145-165404894701536-143779137817375-98502432332800-165523691604852-163592311504376-130116580890054-155782870056000-177516617077890-134155753237984-104587585351371-128298474536960-132277750167875-98738347366800-169870570453778-156081209336768-160070896317069-166039135500000-100833574927701-164140927870464-140443270782767-106841538403056-128636290501875-136585001517504-142557535633896-130708963777392-144606575480167-128790039040000-132784520470227-160568882954568-128882346940555-136846241487936-128943910038125-130958925074736-144883091843199-129036291438080-133038390272603-160875849033000-129128716951715-137107814354112-129190358473605-131209204844784-145159960484375-129282857533440-133292583450211-161183206088712-129375400735035-137369720328000-149350523920575-161337031310808-151414052105812-129529737525760-165438945034875-169465816314760-145575924458219-137631959621568-107737640593326-147675656446000-153699125662467-161722022473728-173742818591559-175781731891392-161837639134875-143889946900992-145923167512629-135960804201056-105994687163347-134025192000000-142060514563871-146096995918184-180162466220430-144164284190208-164226184300250-132213512707056-100185590627150-178372790714368-136317259611972-164421691642000-130365277583515-138420679540032-100328701519850-132465387881904-146549595711375-138552425101824-134568407170571-110492871116760-146689045004107-142704087688000-146758802811453-102554495758248-152862634075892-179052737089536-136836851562500-171086712281960-165087577142406-159085578275008-132938515656474-136999494396000-171290048025235-104814096398336-137097141929316-181495193049360-131110989611875-157370547005568-104938608260356-165519400801904-147387618537687-131266703360000-167657268529843-111124558230840-131360190760955-139476985432896-149619507473250-165833926895152-105187927729196-167935945268736-143690126276879-168015623875000-107312530713903-159994348032832-162058013526160-170201262190176-103360981480125-147983146938368-135852346145331-172390845516520-172431706110215-156239860392000-156276886980137-170524275728352-180717340723983-136077871733248-144236086753375-101598771214800-142271972147410-158569175047296-168773827987647-103728959313000-107822287748683-109882682376192-175039778808662-183224530622160-142541703281250-158869780038528-148721011689509-134491915123632-148791412167247-110090924928000-144783428424111-173373282678280-159133120846986-157130113871808-142879346338750-138829907370208-149073236249319-132767832903680-136885357597523-165527396829000-132862031599115-141071498974272-132924855476205-135001755991344-149355415973375-133019128419840-137144426102491-165840648403752-133113445926435-141338427000000-133176349026565-168046773177456-137338941846109-178377760800768-172267477420500-174359445304360-149779352878739-141605691524928-149850086928517-139619334748000-102685509071550-137631060184576-145882262327887-168523501328208-133617225681875-143929427438720-156303105241788-139883140695776-170779994149597-162587976192000-179094814078407-133838028418120-152405381102958-158621373635648-175142804140625-154574204488200-111319665367482-154647093926400-177370467498054-175349340445000-144439372972370-154792941537600-134185495394405-136281991751664-150771657072375-134280363376640-138444672770051-167412835633032-134375276062235-142678118856000-134438576026365-136539006284208-151055975357711-134533563240960-138705704372875-167728460691816-134628595186995-142947069056448-155413816931175-184467796875000-163779608459329-163818144837632-138967063879059-114104278038520-151483122627875-143216357027904-176467442777905-103828791175600-176550453725715-112187839104000-143384833628589-151732663335144-153847352642078-143485982982336-110239777247625-137311988292336-187287625949670-112398983036928-147818574435239-177007479305000-170800275580902-164590142368192-145873625374190-158414279982624-106329287203125-135549545597440-139753111876011-171081285066064-177381995436815-162812282256000-173289638969903-175418634364512-187992652741830-144161527934976-173452390439875-112875025157424-169352266919643-161026965166144-154789494455106-142272363452000-152769394365983-144432338499072-173778199024331-182195770810008-155007456630750-165519736212544-148793122775683-176078205541728-153056217843127-104857600000000-176202058905684-174145221069464-180481913883922-163731258168192-138574296968250-176408610219744-107130320619093-136570630177280-174431039663707-182880180567000-155589689212094-166141405934912-168283860143760-176739427968096-189408009903750-187347327750144-143175288090884-115830649408760-153774846695907-145382845992000-162276796501897-143342914464864-107532341574117-141301031019008-149771945109375-105497874798800-164615182156074-162542740941504-139354934320074-177402303708000-154207101809943-105645999718400-177526777137108-190251729873360-164923378064250-167076826111424-139615796776698-143880197984096-107935367031669-150298075584000-150333194691791-171546955786728-188533901258523-167389411299136-156831770583250-144149342478048-190830453248070-188754185433088-178191618868116-178233226500000-137950769518315-146474235980352-169864845958160-144418822406752-106215096318750-150860637979136-184900542050991-176440531215096-140334846681414-146747934264000-138273059169765-140433089803248-155363740634231-138369843855360-142660642079875-172510550109576-138466673693595-147021973286208-138531252009085-140695295598000-155653801218703-138628157125120-142926944835339-172832548253544-155798966796875-140892163986816-108896585676783-175129422132464-155944222603047-111109433344000-145330796381188-109023485041368-149674928857090-166819475402112-147605438534625-109125075485256-162655621655828-190522639185408-145601746293092-175619446658000-139242939158115-147846136903872-169312506590603-141483870856944-156526148668375-169430723231744-186631674269751-193112162531280-184572323548114-167441742000000-148155990540369-141747382577328-156817653797871-111731700041728-143995469880875-174124547646696-111809646345436-148397286894528-116164001093166-176438184022000-157109520624263-174367512096768-189480326859736-189524351099072-159409775904750-165910867529792-155173471143336-109940071916232-112121794073068-107834454400000-153160483323231-176930645718736-183446300829695-155425883401728-181372292062500-110144453097576-112330214983116-144766752784384-153445146117319-188067965859000-168651783338298-166528209660736-140608375065405-177424022913328-114703103519875-179671052994048-153730161407663-179754401246776-177629867145558-156003853248000-156040023860712-143069850058608-158280609383911-117111426932736-154015529412375-184427523155560-169278595365594-167147081285184-151987101444430-147678821500000-158574288058623-141228993451520-145608222160859-176074594559784-141327152451875-150058951898304-141392617047045-143601131646192-158868329775767-141490851840000-145878179398627-176401011151368-141589132122555-150337096316736-141654677588125-178744177665072-146080866149221-189730983581184-183230917733556-185455131205000-185498030841935-165895426107648-146283740558239-179075236406768-168194900671875-150754957062144-183570207981972-181426783824216-159605023850947-150894415848000-142179769689165-179406703673776-175071381286960-109444898995200-148879456470500-177382680941736-113901610617756-151173591384768-146825657083823-197274050910000-162240571712054-142541522206720-146961345014019-190874468129208-160196016165875-151453111051584-193202182885624-180070864791344-169129964002923-164775000000000-147232971613067-180237160792656-142903887816755-151732975060416-118774942656750-162803211911984-176044072907440-143068802273280-182729991257507-184974207684000-114534249457212-152013183623232-114587074846244-110205282337200-163141419599750-191845612964352-154394119313910-178697229988392-178738413954579-154500892560000-183236129285663-167821139385248-110434082158350-161270904881152-192243846984375-112720627460376-117168024886199-172475674640256-174727130047731-150432668636000-163743833650534-179274381470208-148322824964779-199285481097360-181613011065750-175008904661824-183912432657199-150709921219296-117492116050907-157431314944000-159685389210312-179687392477128-188604221193095-159795618421248-144293114298125-182073178949552-115487593250796-184378355227136-157757509722079-184463152875000-117816804297503-175654098132032-177918455990160-186857318042976-113475160210125-162462557011968-149143735044931-180349528680072-144758182684635-153701682504000-144824702488765-147086554185648-162724010996431-144924520399360-149418043324875-180681205891176-145024384164595-153984308879808-145090985488085-147356975238000-163023158854503-145190925701120-149692687741139-156431237845680-172113849359375-160974554614272-165484030877442-183416267545264-163322673118847-120841746048000-149967668499547-183584616564176-145557765781155-154550600592576-176989813740875-147898811283696-163622554013719-186079251890176-186121907789427-177192783691000-166016092730254-154834266353472-150380770728919-148170226682544-163922801763375-116793680054272-188709936548532-121341320848368-146092453604435-155118279000000-186634287151983-168684061290600-186719775029341-164261019267072-155295963151125-168838604626200-119339927010279-166663699522688-180218212322320-187019188173000-191569505363635-196121892020736-157835330372790-182679812369064-182721605965875-157943684142720-187318921226879-171560171606432-112894348207950-164863442944000-196526020038807-115231250884248-119777503268951-176316626508672-178617919921875-153782215177568-167389485874342-183265502925312-151624627761163-203721416730000-185655259221462-178903861041472-188005227561871-154063566927072-120106386474875-160933986021376-163237936489416-183684618869832-201872399211091-158812300080000-147502235544365-186122227261616-165732004770111-122624263259136-152179647582875-186292227763152-147704370288995-159102544845440-186419796049818-113696543750000-118271383461452-118298365526016-197967415334199-175252506372328-204887312898750-177609502232448-150319235938938-173134349063712-189124047230357-118514369792000-198328862028447-148210514889320-150524980435302-157402893491136-120931227157625-150627923047536-166641576977799-203212051509248-162149921112439-205588981170000-196496446332146-180543666291392-192014206332228-173766706433824-114346236718750-185283086777856-162445612712543-114424365787600-187698683415798-157977530808000-148853289568165-151177743061488-167249803562551-148954949877760-153573119143875-185705271987336-149056656463195-158265373186368-149124486567485-151453154094000-167554471061583-149226270302720-153852830303819-186043481536104-149328100341875-158553564993984-172380014727975-204604121936888-181656180248321-190897344000000-154132880893267-207091223856720-161107556149890-179560642065792-158878198718625-117458393036616-122092335979379-124424223925248-163631973871359-202857526168000-189069262460342-159130997744832-168394213985581-189198095236208-120006521095500-191592357920768-163929463941223-191679353087256-122425441070327-182524621592000-184877007428880-157181117159264-115600576028350-164190063343104-166540375125000-187400426081256-196699377887055-166653736441344-150485413519285-171360709758000-125075361891114-155221286752256-164525525343927-208600766721360-171555069712750-183188145772224-153077951601498-157752424614496-171710663448006-150861114560000-155538232486907-188081365647528-150963686893955-160290065724096-151032094273125-153390402721776-169697509676279-151134744084480-155820323975683-188422453125000-151237440396315-160580709471552-151305930443005-153668493730224-170005141615375-197995997903360-188721242733033-125842635153648-153842471176614-160871704344000-151580097407765-153946920648048-170313145118631-151682995343360-156385529769875-189105864712776-151785939835595-161163050553408-151854595367085-154225683678000-170621520410303-151957617477120-156668644486939-189448189320744-170775847546875-154434976646016-119363086931583-191960487998064-170930267714647-121786056704000-196775768031444-208535709697352-152335763852155-182844206243712-187574873930000-154784218885296-187659602472240-194740800421376-168969920872968-211260086010000-124436802662063-183174747060864-199658562504345-119822175225384-209148633616375-176288621875200-166924219784183-211641823763280-164647445892930-183505686000000-162368571983169-160051497973344-171858743946271-171897503247872-204910347243375-190821618985896-202646413508098-181480138386624-195665549798207-160340442988000-172168981543863-172207787474944-207639736066136-207686529876672-212454542778750-184168759202688-186571924155027-179527351500832-210283338527551-167791912128000-163102108586109-130038208423640-163175583519423-167943121411904-172712795328125-160919375878368-189359535742640-153889259130880-196548980853987-206067594219000-153993199339915-163506493795392-158802904001479-156467912284464-173101934037375-118589643852800-161318199535204-208811691481536-154270602019235-163801011576000-170961235979112-121124775482088-123527542559564-118803190579200-168738460742375-197301984696088-154548337639995-164095882813248-154617823590685-157031844750000-173725771026223-154722091563520-159518607444459-192894184554984-154826406401875-164391107719104-154895975669045-157314318394992-174038250791367-155000368640000-159805489847027-193241064468168-155104808504555-164686686505536-155174461138125-157597130585136-174351105035999-155278979182080-160092716001403-167298582710000-184069736913447-191284196387840-155453280197605-177017285344176-179449658203125-174703513960448-208254998386071-210695978781376-205953611748754-186837024816000-174899501729893-122217459727368-213329266706943-175017164718592-199036725854875-194284198872936-155942016854195-167975193895040-156011919886485-196859139958000-216113322192390-199349161979904-170565799871447-194632742725704-156221754316875-165872544696384-156291740915245-158731768852272-175606271294527-156396760000000-161245062253467-194981703185448-156501826118755-166169896065216-156571896333125-159016276809456-175921001300439-156677040865280-161534010254243-168804637470000-185726644605887-173705324438016-178570409063778-159301124528304-188307073373250-120736658764800-161823303241771-195680874921192-195724628563779-169182558160000-178890117292114-178930107631152-181388618847525-166914828742656-212924460375000-205711634185960-198495570209606-186433830563904-213114840627832-123537330957000-123564928841541-126015913793536-172098622015327-201230647331832-157625460711875-169788403809920-203791580534052-184424027719072-123785859899469-167512375296000-213686662210648-201590362391704-160336548854262-191960822758336-170129826728750-165305853956448-124007054146773-201860429825536-172714313007279-204383644500000-160622970608166-170395694098560-206955204407545-124200815133864-216790932252375-131565401432064-212013741284391-199873595168784-209670258495794-187769869672000-168298817091489-165896671044704-183015048288525-168411366452736-175772759013000-122091613934800-190505352847914-192990714699328-163712130927503-185744678148000-129561324163883-173601938833408-176086242346824-198141135694344-207972181484375-176203894620672-159108375551645-161592162029232-220401999111510-132270634368000-213150118636767-213197555606616-161772068672742-191227714384512-166748434420500-166785533597408-181542282830422-159498288967680-164442498494323-198847835469000-159604739435115-169464247812672-159675732720205-162168333213744-179407885153375-159782262115840-164735252669691-199201814621352-159888838882435-169765875000000-159959916382565-162456931692528-179727139860471-209317825085440-199511890772625-133037475743664-162637479499638-170067859883328-160244437029885-162745872366000-180046773083663-160351219192320-165321802978699-199911032700264-160458048781875-170370202674624-160529294861845-163035155436912-180366785047207-160636203520000-165615599523987-200266272124488-180526933126691-163252342560384-131125661140625-168274016899168-180687175975359-160921525306880-165909743937563-200621932137000-161028608018915-170975962828992-161100022878405-163614749582064-181007946092375-161207184752640-166204236425251-200978012986632-161314394138235-171279380616000-161385893462365-163905061061808-181329095622511-161493182056960-166499077192875-201334514922216-161600518190995-171583157158848-186544733111175-221415434875000-196580813128929-216535661776896-216583599713799-201691438192584-214188927883250-191816254138432-206808736134519-209346726717408-221856924793231-162066191040000-167089804391227-202048783046568-162173780895555-172191787359936-162245533913125-164778055562736-182294822934199-162353203118080-167385691233603-202406549733000-162460919946715-172496641442112-162532757628605-165069741092784-182617492359375-162640553853440-167681927179211-202764738500712-162748397730035-172801855128000-162820320126165-165361770642288-182940542318951-162928243445760-167978512433875-203123349598536-163036214445195-173107428629568-163108221605485-165654144414000-183263973037183-163216272094720-168275447203419-203482383275304-183425831250875-165873650760576-133230961540169-170975555417056-183587784738327-163504640000000-168572731693667-203841839779848-163612865469755-173719655927616-163685042308125-166239925435056-183911977646639-163793347361280-168870366110443-204201719361000-163901700178515-174026310148032-163973961930805-166533333089904-184236551986375-164082394378240-169168350659571-204562022267592-164190874617835-174333325032000-164263221333965-166827085777968-184561507981791-164371781250560-169466685546875-204922748748456-164480388987395-174640700791488-164552820717285-167121183702000-184886845857143-164661508177920-169765370978179-177405838687280-195189365361375-182554891448832-169914845212151-208001233625904-202972674889520-170027008448000-172602681893028-215800805449480-134587742011471-177796485578880-132106432178500-188038951350064-228746303192070-175410720411648-223761401463512-127165106250000-208596612942982-198464777457024-188328475309698-193460937420064-226602720787375-196092620140032-180852400211903-206369895391272-186028538963067-175873816824000-165714622045765-168301031812848-186192020643031-165823820431360-170963622259875-206732743475976-165933066777595-176183000140608-166005924325085-168596858958000-186519271281903-166115250629120-171264063498539-207096016627944-166224624921875-176492545604544-166297567782645-168893032555632-186846905146247-166407022080000-171564856516147-207459715096008-166516524394155-176802453427776-166589552618125-169189552808496-187174922460319-166699134983680-171866001518523-207823839129000-166808765394115-177112723822272-166881879031205-169486419919344-187503323448375-166991589539840-172167498711491-208188388975752-167101348121435-177423357000000-167174547221565-169783634090928-187832108334671-167284385948160-172469348300875-208553364885096-167394272775795-177734353172928-167467557388885-170081195526000-188161277343463-167577524408320-172771550492499-208918767105864-188326005963875-170304594615936-203894028752227-170379104427312-188490830699007-129131542400000-180823692305270-211868356329936-188655751576891-204206339026496-170640059906250-217225732178784-137089051193899-178513433100288-214780479417587-201886005126000-212285511145062-194206001937600-217558244722308-129527246545200-217653310591500-168458994096640-222932889963558-207424725061760-212656774798358-178981972056000-168643021821365-171274917956208-189481799088711-168753502760960-173983889397875-210384644079816-168864031941995-179294786384448-168937744868685-171574218750000-189812892073823-169048354475520-174287857688059-210752181590184-169159012351875-179607964979904-169232811091045-171873868023792-190144370526967-169343549440000-174592179815427-211120146904968-169454336086555-179921508054336-169528220688125-172173865980336-190476234672399-169639087854080-174896855985803-211488540273000-169750003345715-180235415819712-169823973859605-172474212822384-190808484734375-169934969917440-175201886405011-211857361943112-170046014329035-180549688488000-170120070805165-172774908752688-191141120937151-170231195829760-175507271278875-212226612164136-170342369236195-180864326271168-170416511724485-173075953974000-191474143504983-170527765790720-175813010813219-212596291184904-191640799745875-173301967234176-207482314593267-173377348689072-191807552662127-181336968000000-176119105213867-212966399254248-181455256951263-210428635397120-218367159715375-134206571941416-134235736716093-192183100338176-231723116603352-215970725962000-226555091642866-202889902856256-218747011180151-200341973382944-131832555918750-192517331742208-187283545075423-213707903533992-224310072742015-203242652536000-224407478866185-200690242706848-237711084549030-235120871079936-229887137484375-219365208890008-216769282903206-193019405087296-142812456576606-195748417638000-203728350609707-214358129975808-187934918318127-142967417996016-193312683924875-182759832252864-172202391871445-217287043710704-209382904188801-172314421760000-177654907415507-214823384038728-172426500226955-183077031775296-172501246198125-175193067702576-193816138538879-172613405652480-177963135336283-215196071625000-172725613713315-183394598108352-172800446096005-175496914551024-194152260100375-172912735191040-178271719564131-215569190001672-173025072920635-183712531464000-173099991764765-175801112515248-194488770045231-173212410575360-178580660304875-215942739417576-173324878048595-184030832054208-173399883404085-176105661798000-194825668597703-173512432005120-178889957764339-216316720121544-173625029296875-184349500090944-173700121213645-176410562602032-195162955982047-173812799680000-179199612148347-216691132362408-173925526865155-184668535786176-174000705393125-176715815130096-195500632422519-227686902661120-174151127433985-219745803258000-238556107920419-193030893236736-222569781535431-177021419584944-134136094618750-144898261945344-179819992513291-144960834966768-206748034700823-212163901000000-225640688422884-204195160437408-241862243879430-190843611295744-233901082758375-220506059076112-231312347013298-212530438035648-226030480068036-180325104557000-196515998323263-185788059090432-180441803046299-218193101671464-175130984331875-185948359391424-175206509803845-177940346537712-196855233230807-175319838720000-180753245140387-218569675329288-175433216495355-186269236558656-175508828828125-178247360727216-197194858315759-175622288058880-181065045393963-218946682017000-175735796176915-186590482656192-175811495420405-178554727857264-197534873802375-175925085040640-181377204012851-219324121983432-176038723576235-186912097896000-176114509780365-178862448130608-197875279914911-176228229864960-181689721202875-219701995477416-176341998892995-187234082490048-176417872107685-179170521750000-198216076877623-176531722731520-182002597169859-220080302747784-176645622326875-187556436650304-176721582602045-179478948918192-198557264914767-176835563840000-182315832119627-220459044043368-176949594077555-187879160588736-177025641463125-179787729837936-198898844250599-231644292894720-177177801593585-239923004024000-177253914344715-188202254517312-144592193710801-226485451077192-199240815109375-188363940294144-240283842113304-221217829705512-245850346146510-215848286568000-183100491394447-246008664195120-237859403578569-199626000596992-235226292409750-202447440964944-145027244077559-202534303424128-221740503534189-136906209950000-241006603311848-199968804186624-183572365863019-221978354454504-178168968241875-189173758363584-178245364568245-181026395087472-200269079065927-178360000000000-183887398814067-222359269608648-178474684571755-189498334372416-178551168258125-181336947806256-200612618259039-178665934753280-184202791982843-222740620281000-178780750416515-189823281431232-178857321512805-181647855493104-200956550096375-178972219146240-184518545575171-223122406720392-179087165975835-190148599752000-179163824531965-181959118350768-201300874802191-179278853378560-184834659796875-223504629175656-179393931449395-190474289546688-179470677515285-182270736582000-201645592600743-179585837649920-185151134853779-223887287895624-179701047036875-190800351027264-179777880662445-182582710389552-201990703716287-179893172160000-185467970951707-224270383129128-180008512937955-191126784405696-180085434173125-182895039976176-202336208373079-235647274680320-180239342377185-244068451000000-180316329352315-191453589893952-185943902500759-183207725544624-202682106795375-230495970672128-199990990309896-250042093480080-147278435591087-216795650448000-236302083263385-141811502002728-247527774376183-208635322060800-197550238448375-250469211554640-194850938713410-217165924749696-192149288045121-189404897724000-203375085833503-208991557593600-197887522698207-139387119861200-239796953781250-214747689385152-214793461539041-212049120193952-251164315353510-203765579776000-192641382447429-153587442765240-203895855414451-198351915073984-203982736681125-190051790227808-223637964520240-192928825133568-187376580926923-226578135249000-145488540889692-201488563201536-181938124053205-184776500210544-204417513238375-182054337187840-187695950075091-226964293044552-182170599799435-193422249000000-182248135699565-185091325927728-204765778963071-182364480796160-188015681910875-227350889344296-182480875397795-193751665192128-182558499306885-185406509046000-205114440023063-182674976440320-188335776640099-227737924397064-182791503106875-194081455189824-182869215074845-185722049768112-205463496642607-182985824320000-188656234468587-228125398451688-183102483126355-194411619205056-183180283203125-186037948296816-205812949045959-183297024634880-188977055602163-228513311757000-183413815655915-194742157449792-183491703891405-186354204834864-206162797457375-183608577584640-189298240246651-228901664561832-183725500895235-195073070136000-212080935391575-206469239844024-212170933665525-195238666960896-249052856679000-240613442651560-232170433870886-218059935153984-218106176746073-215319276500000-255037417645590-206907541225984-201281503929967-235350793113912-184349930301875-198572773589120-198614858952510-215684688855712-255470203951110-195901991424000-204462781580232-142018124976400-232959066757254-221642151349632-198951755948750-193308354988128-255903479591670-184858319726080-236099840271147-153639650502000-184975772943715-196400469534912-204983006091624-145227031861224-148105963687500-142439722188800-202307212789543-236550030523416-185289224727035-196733257608000-185367642963165-188259273613488-208270216653551-185485311797760-191232993368875-231241024815336-185603030418195-197066421394368-185681537162485-188578041894000-208622843400583-185799338782720-191556728352819-231632461084104-185917190216875-197399961105984-185995785519245-188897169805872-208975867949727-186113720000000-191880828494267-232024338843048-186231704322755-197733876954816-186310388233125-189216657551856-209329290525239-186428455649280-192205293999043-232416658341000-186546572935515-198068169152832-186625345503805-189536505334704-209683111351375-186743545930240-192530125072971-232809419826792-186861796254835-198402837912000-215700758689575-256018901345272-155370080208618-187058991042560-238910324171875-238960713019608-224612849376474-227540475247808-221826722886153-218992021492000-259387333955190-187374791185920-239313633348971-155730846504816-190377820239750-199073305961664-187572346653445-190498210931952-210746965576087-187690946560000-193506813767907-233990358699528-187809596448955-199409105676096-187888724148125-190819500889776-211102381647279-188007457364480-193833109176683-234384890625000-188126240591315-199745282799552-188205457198005-191141151898224-211458197090375-188324323799040-194159771183731-234779865782472-188443240438635-200081837544000-188522546002765-191463164160048-211814412129631-188641546063360-194486799994875-235175284420776-188760596190595-200418770121408-188839990762085-238279001606000-194732312442237-252914520293376-197721870380356-238479432551568-258891837171875-209484605993472-238629829498506-192108273254832-145567151981950-157245556608000-195141958852747-157311635423472-236017022658147-230237794206016-244861226326500-221587638749856-145811956895150-236264974405632-256736833722072-242200356887000-192633490115286-201431836971072-248192758999345-148946913933384-148978176841125-151931197929472-207488055301183-236761398758952-225116705113223-231012353000000-204737435903070-149197139692008-149228437602477-213646294351872-207836555006375-237159038533896-213780747648339-202109107921728-190432560865885-193402835406000-213960106442863-190552363256320-196456687273899-237557123282664-190672215881875-202448311948224-190752145545845-193727382118512-214319124934407-190872081920000-196786289476787-237955653254088-190992068557355-202787895291456-191072087578125-194052291706416-214678544816159-191192158010880-197116260130363-238354628697000-191312278734915-203127858163392-191392387162405-194377564372464-215038366312375-191512591728640-197446599440451-238754049860232-191632846614235-203468200776000-191713044498365-194703200319408-215398589647311-191833383272960-197777307612875-239153916992616-191953772394995-203808923341248-192034059785685-195029199750000-215759215045223-192154532843520-198108384853459-239554230342984-192275056276875-204150026071104-221948576796975-239754554427672-225001896541204-192476040640000-245828447814123-234030175588312-219263933630878-204491509177536-246033918401375-225331121672096-263929710828807-228391366590464-213605352389448-243323557146000-228534458984447-225613570120448-252383641614945-148491955281200-252489013671875-160438263266304-205047231043677-216979297085096-157565786182767-225990535072000-205218424715529-196336836363888-217205741751751-193442715381760-199436388613875-241159950900936-193563776809195-205518242875968-193644512481485-196664656254000-217568380828383-193765658078720-199769314282619-241562499073704-193886854191875-205861249608384-193967679670245-196992840844272-217931423313527-194088960000000-200102610254467-241965494957448-194210290873755-206204637777216-194291206208125-197321390337456-218294869431439-194412621345280-200436276735243-242368938801000-194534087054515-206548407594432-194615092294805-197650304936304-218658719406375-194736642314240-200770313930771-242772830853192-194858242933835-206892559272000-194939338129965-197979584843568-219022973462591-195061023106560-201104722046875-243177171362856-195182758711395-207237093021888-195263943913285-246384195174000-201355771674397-156308611137536-201439501289379-243581960578824-219570112689875-207582009056064-195588909844445-246794209005104-156536166098988-249907719872000-213820899736591-250011574027704-198845684156262-207927307586496-232083018176625-229116530328736-268363239043447-220163874287616-265458138954712-265513259000000-247461451219782-226383683505600-163030089834558-223457981201136-232565351970875-244697446596096-214532400241503-163199348635248-220667123234267-208619052984000-196565970521765-199631471102448-220850312811831-196688331407360-202782333639875-245205609482376-196810743061595-208965500275008-196892379041085-199962947118000-221216996065103-197014875333120-203118971601739-245612645962344-197137422421875-209312330910144-197219148706645-200294789861232-221584084969447-197341780480000-203455981924947-246020132641608-197464463078155-209659545101376-197546279718125-200626999534896-221951579749119-197669047047680-203793364815323-246428069769000-197791865230115-210007143060672-197873772275205-200959576341744-222319480628375-197996675235840-204131120478691-246836457593352-198119629077435-210355125000000-198201626577565-201292520484528-222687787831471-198324665244160-204469249120875-247245296363496-198447754819795-210703491131328-229072895567175-223010390123000-244445481186480-198653017272320-253717064606851-256826978414496-238531491188250-241639523067584-238630105460214-208079496788576-226486247066566-198981731520000-205146626164987-248064327736488-199105092788355-211401376817856-199187361953125-202293558956016-223795149626359-199310808186880-205485874978563-248474520837000-199434305413915-211750896796992-199516665233405-202627974470064-224165084367375-199640247472640-205825497594251-248885165878632-199763880733235-212100801816000-199846331257365-202962758333808-224535426553511-199970049576960-206165494217875-249296263110216-200093818945995-212451092086848-200176360224685-203297910750000-224906176409023-200300214699520-206505865055259-249707812780584-200424120251875-212801767821504-200506752335045-203633431921392-225277334158167-200630743040000-206846610312227-216152926662960-237817206669119-247133715051520-200837507788125-228692876238704-231831061669725-256612549049856-207187730194603-278369189370000-216553952398770-241352660425344-213548234585673-210496659563232-157904994328125-232261027123200-219919029380343-257141356169816-254095550576198-213856109928000-226300123000693-204642209994288-257406031942821-161299607492608-269922167691375-217223430343920-266929393760258-242148546546816-239093240422113-232930918425000-155319211353550-208170538500096-267258913583702-251772356423304-164773803828375-230108829774464-205274384975418-205316576202672-233362242284925-202288840000000-208555960094667-261526871357472-217983838395890-242946180427392-202496742183125-205654314163056-227512858977639-202621551841280-208898956191443-252601349661000-202746412773515-215267308756032-202829681885805-205992422297904-227886878261375-202954628298240-209242328148571-253016527799592-203079626012835-215621075832000-203162986328965-206330900809968-228261307232791-203288069570560-209586076171875-253432160616456-203413204142395-215975230279488-203496655712285-206669749902000-228636146116143-203621875857920-209930200467179-253848248360424-203747147361875-216329772310464-203830690235445-207008969776752-229011395135687-266711754240000-254212698514401-166370789356264-216640314693783-219825060138880-210447092870375-282748037232240-238813919769748-216862312539648-210619578697083-254681789625000-279892854744139-220185527506560-204499855500005-232862889071536-276974725401000-217217824456704-210964833043331-283443604048080-220501259522530-242601027592000-274163751349947-264763998704352-230139605254031-274332087664128-220772127073750-236589957022200-246103890159114-236686761422400-252517518424720-211526675721000-268409619865435-170553923592192-221133628745190-262254915243992-205422346796875-218108303636544-249769252431907-208710637987632-230893800125247-218286691008000-278451516925208-269013815918280-259572242298934-243794471343808-278679180483000-161540248903656-161573249975853-164775005650944-225027212898599-263113710847000-206094989189115-221993776332160-260102956185674-158631748369200-165010703123500-165044392527872-276188337057951-244492451002184-285828729668910-247768794000000-209693306730666-241514298447008-263812861174941-165314072854528-276639594378375-206726923508040-209950161382038-219538126820928-168665133149937-210078667326000-232407129442463-219717292856832-280276300928536-270776631239240-261273072021750-245391809254592-245441838165601-242303667721632-286997045126310-232833941504000-226501085042631-264836922488984-207444675819355-220255375784256-207529226328125-210764918045616-233166267476559-207656095162880-214089116146763-258876876177000-207783015692915-220614585350592-207867658104405-211108603127664-233546455622375-207994664816640-214438150708051-259298900617032-208121723252235-220974185256000-208206457616365-211452661628208-233927056819711-208333602280960-214787564422875-259721383467816-208460798696995-221334175712448-208545625063685-211797093750000-234308071292823-208672907755520-215137357497059-260144324978184-208800242226875-221694556931904-208885160646045-263570239015984-215399951381093-273324144960000-218703761929508-263784610895696-273490839900495-247800874532288-225319300298750-270438101396064-167448078494476-235119100276736-231945402139848-280324294971000-277158463896946-248203911928896-222461665446273-270877897653216-235453596609375-209693034237440-267816242380939-267870617633016-251784939988842-255064720808000-213135300941706-164728889208168-287526407015143-210033813749760-216540327503875-261840682592136-210161701191195-223139993679168-210246988319485-213524865774000-236219350643983-210374962270720-216892020462219-262265921132904-210502988141875-223502331893184-210588367572245-213871543881072-236602849481127-210716480000000-217244094014867-262691619826248-210844644375755-223865062142016-210930116158125-214218597028656-236986763163839-211058367137280-217596548367643-263117778921000-211186670092515-224228184637632-243775654934775-289339034277816-256881044676625-282951604273152-283008901256631-263544398665992-279869225112274-250631316936000-270215722101863-273526691780832-289866704119263-211743250434560-218302600296875-263971479310056-211871830773395-224955607217088-211957579911285-215262008742000-238140995527943-212086246993920-218656198284979-264399021102024-212214966136875-225319907724864-212300807826445-215610564079152-238526570835487-212429613760000-219010177896507-264827024290728-212558471781955-225684601327296-212644406073125-215959495470576-238912562109879-212773350932480-219364539337283-265255489125000-212902347908315-226049688236352-212988374851005-216308803119024-239298969575375-213117458711040-219719282813131-265684415853672-239492329449867-216571030896000-173948213247193-223223895931104-239685793456231-213461937295360-220074408529875-266113804725576-213591212403595-226781042822208-213677424799085-217008547998000-240073033976703-213806786885120-220429916693339-266543655989544-213936201171875-227147310922944-214022506368645-217358985634032-240460691361047-214152007680000-220785807509347-266973969894408-214281561220155-227513973178176-214367959268125-217709800338096-240848765833519-214497599879680-221142081183723-267404746689000-214627292748115-227881029799872-214713783697205-218060992312944-241237257618375-214843563683840-221498737922291-231463198315440-254660792131823-238172328000000-221677210004967-271361061582256-264795799386160-221811126962688-225167058198500-281515477100360-175568510234079-231929607091840-172325238354308-271798329222000-242015494022263-215536606904320-222213201415299-291920832187072-215666718206875-228984567983424-175922074960289-275556018376456-242405239089807-249096561600000-289010115620607-289068227573976-232630394392690-255944880038848-262645588546875-252722497122976-299336797438470-296070328700928-289475229376743-282877463345000-299577502484190-256356697948736-223108439183879-299758115925360-289824391982625-243234836223488-286608188525958-246665882883728-176701587555007-246764972016000-270161846609301-166800059244400-293627049743016-243625888940032-223646734227875-270433166065416-297202261794947-233801507757440-217144974302685-273991714750000-243968403696623-217275732011520-224006078178859-277555745181112-287645578913250-257594801680832-257646475662961-254351427249312-167370028803950-224320819712000-237760780383351-281350853710752-221105712586902-231202320860736-234600105748750-281576566378464-177697020360339-224680885164544-291808284723183-248254495002000-301991653854990-241641738579456-275258238395994-221593706559984-167907655468750-298935505649664-228445917912644-275534085086864-218454914323035-231944741448000-168109561907050-221949061895088-245538274006351-218673748533760-225447303148875-272610264197736-218805119182195-232316547000768-218892728838485-222304796934000-245931791031783-219024187166720-225808572712019-273047081202504-219155698116875-232688749675584-219243401323245-222660911879472-246325728284927-219375000000000-226170228015067-273484364580648-219506651326755-233061349684416-219594448133125-223017406934256-246720085990039-219726187233280-226532269263843-273922114581000-219857979011515-233434347239232-219945869467805-223374282301104-247114864371375-220077749066240-226894696664171-274360331452392-220209681370835-233807742552000-220297665526965-223731538182768-247510063653191-220429685698560-227257510421875-274799015443656-220561758604395-234181535834688-220649836510285-278413823214000-227529874410997-234368581780992-227620710742779-186890113261720-248103652254875-241354444032576-248202675862669-173436466778472-258505906328244-302784413696000-231387048546628-279081215235216-221267038492955-234930317157696-221355304048125-224805590944176-248698189144079-221487746388480-228348271897483-276117872625000-221620241547315-235305305621952-221708601002005-225164370912624-249095074270375-221841184215040-228712633142931-276558427584072-221973820274635-235680692904000-222062273678765-225523532409648-249492381418431-222194997839360-229077381774875-276999450907176-222327774874595-236056479215808-222416322278085-225883075638000-249890110812503-222549187461120-229442517999139-277440942843144-222682105546875-236432664769344-222770746999645-226243000800432-250288262676847-222903753280000-229808042021547-277882903640808-223036812491155-236809249776576-223125548043125-226603308099696-250686837235719-223258695495680-230173954047923-278325333549000-223391895907115-237186234449472-223480725608205-226963997738544-251085834713375-223614014307840-230540254284091-240910818483440-306361764361611-241006570000000-223836279894565-254879623849392-303160307799976-237752461295616-286048899457875-286105715314328-296505762983698-268977238897536-227641322041914-289782849804000-175974521444181-258837441369600-245081424400687-300370658234328-241725515211250-269404752309888-245276075069523-290243370734688-252285366901607-300728526336000-242013493159270-259351619688600-269779197937626-259454536996800-276806406250000-231871350165192-294223492537555-186955526366208-242397819418230-287471553851000-225172967050915-239077160217792-225262268246405-228773188122864-253087173732375-225396264304640-232377585815651-280989778253832-225530313490235-239456547336000-225619709134365-229136176057008-253488713432111-225753846888960-232746219632875-281435498903016-225888037798995-239836335603648-225977527941685-229499547750000-253890677620423-226111807467520-233115243100659-281881690653384-226246140176875-240216525232704-226335724868045-229863303404592-254293066521567-226470146240000-233484656424827-282328353753768-226604620823555-240597116435136-226694300113125-230227443223536-254695880359799-226828863406080-233854459811203-282775488453000-226963479938715-240978109422912-227053253876605-230591967409584-255099119359375-227187959165440-234224653465611-283223094999912-227322717722035-241359504408000-227412586358165-230956876165488-255502783744551-227547433717760-234595237593875-245147927839920-311749657834067-245244798727040-227772297757485-287400271438000-255906873739583-227907287262720-291077546706731-182397847911968-287684170269750-273704827463808-270249136878721-266792067621792-186089091056747-270409216000000-305587601407287-316187498016720-274083246093306-277651915563456-246069231808750-179314386452616-312982924652127-249732267402752-306070330366623-175937188050000-274516151436618-278090428642112-228853707458805-232420360942704-316999355703750-264218219827200-250175899855223-179739245951832-246749562392130-271478025896000-296216225664324-292747533846984-282221911565360-243464372000256-239983187062500-300038096869960-289505551170806-254250081529344-236640439217263-233154416022000-257933715711543-190837866627072-240361684494916-286369573465224-229848001686875-244040543033664-229938534608445-233522022443952-258340364075087-230074378560000-237200277048907-286820963751528-230210276003955-244425161628096-230300904023125-233890015057776-258747439618279-230436890644480-237573992377683-287272828125000-230572930786315-244810184127552-230663653953005-234258394066224-259154942565375-230799783319040-237948100032731-287725166834472-230935966233635-245195610744000-231026784597765-234627159672048-259562873140631-231163056783360-238322600219875-288177980128776-231299382545595-245581441689408-231390296157085-234996312078000-259971231568303-231526711237120-238697493144939-288631268256744-231663179921875-245967677175744-231754188830645-235365851486832-260380018072647-231890746880000-239072779013747-249826570403760-246305965242903-249924669841280-232118462818125-235735778101296-260789232877919-232255163911680-239448458032123-289539270009000-232391918666115-246741362619072-232483118319205-236106092124144-261198876208375-232619962531840-239824530405891-289993984130952-232756860433435-247128813000000-232848155533565-236476793758128-261608948288271-232985142940160-240200996340875-290449174081896-233122184063795-247516668769728-233213574660885-236847883206000-262019449341863-233350705336320-240577856042899-290904840110664-233487889756875-247904930140224-233579375900845-237219360670512-262430379593407-233716649920000-240955109717787-291360982466088-233853977712355-248293597323456-233945559453125-295189099410032-241238308642461-248488083161088-298964460871987-183737008287000-266650971717134-248682670531392-234312125517405-237963480460464-263253528587375-234449686448640-241710799809451-292274697152232-234587301209235-249072149976000-234679074293365-238336123191408-263665747778311-234816778792960-242089236637875-292732269980616-234954537149995-249462035869248-235046405980685-238709154750000-264078397064223-235184254123520-242468068262459-293190320130984-235322156151875-249852328423104-235414120779045-239082575338992-264491476669367-235552112640000-242847294889027-293648847852168-235690158414555-250243027849536-235782218888125-239456385161136-264904986817999-235920354542080-243226916723403-294107853393000-236058544137715-250634134360512-236150700507605-239830584419184-265318927734375-236288980029440-243606933971411-294567337002312-236427313521035-251025648168000-272907191350575-236565700992920-276653846203412-182044607155200-254912153413750-298669611261392-309656918076255-280567432612544-251466588311961-185902844769000-185939085495021-258906833256448-317313873600759-302783732987672-299194035899750-284654667892608-270109618207202-306670662882528-328639730957910-252006216000000-303196968674683-284987597295024-299660706177814-274133299444800-307089094630500-182826727170800-307208716428012-237767321825280-314645711411894-292750673680000-300127861465542-252595780602432-237998868249805-241707429344304-267395101681375-238137868234240-245512958619771-296871934785192-238276922328835-252989334072000-238369655124965-242083969475568-267811631913591-238508799426560-245895352671875-297334292030856-238647997866395-253383296109888-238740826908285-242460900462000-268228594483343-238880115601920-246278143578379-297797129086824-239019458461875-253777666928064-239112383799445-242838222506352-268645989614887-239251816960000-246661331545107-298260446201928-239391304314955-254172446738496-239484325998125-243215935811376-269063817532479-239623903700480-247044916777883-298724243625000-239763535625315-254567635753152-239856653704005-243594040579824-269482078460375-239996376023040-247428899482531-299188521604872-240136152592635-254963234184000-277187731288575-240275983423320-280992585196372-184899410867200-258909396873750-303352703605072-314511972467855-284966110908864-288722959723302-281374368548000-329568097557879-192593982570496-322287030707079-307528854063192-303882594343750-289115094073728-274341852888642-311475443609568-333788377251510-255954022848000-307946394960203-289451491693104-304354126054134-278426617492800-311898233566500-185689680562800-312019100929452-241490125127680-319571904264534-297333771920000-304826145293222-256549726308672-241724081830205-245490443469744-271579886103375-241864528355840-249354782287691-301517128565352-242005029272435-256947375000000-242098726772565-245870901276528-272000749802471-242239318364160-249741154145875-301984295111496-242379964374795-257345434379328-242473758619885-246251751966000-272422048081663-242614495352320-250127924916699-302451943956264-242755286531875-257743904658624-242849177571845-246632995740912-272843781165207-242990059520000-250515094805987-302920075348488-243130995943355-258142786049856-243224983828125-247014632804016-273265949277359-243366011066880-250902664019563-303388689537000-243507092808915-258542078764992-243601177588405-247396663358064-273688552642375-243742350192640-251290632763251-303857786770632-243883577328235-258941783016000-281512798906575-244024859005720-281621498100525-296698570625536-330563464319000-311841623280888-308143951930486-293169103234176-278188460047026-315842425500000-338467889623590-244496191979520-312263057942291-203198287579056-244637710126875-259742426973504-271087848985896-192057591176712-195861188737708-188364380800000-267528994247151-312805460199224-245015358805555-260143367103936-245109831663125-248928724538736-275383323116199-245251586478080-252846507155603-305739011133000-245393395936715-260544719618112-245487965938605-249312725588784-275808106109375-245629866493440-253236476637211-306210527324712-245771821720035-260946484728000-245866488916165-249697121346288-276233325700951-246008535285760-253626846883875-306682528054536-246150636355195-261348662645568-246245400795485-250081912014000-276658982115183-246387593054720-254017618101419-307155013571304-246529840041875-261751253582784-246624701776245-250467097794672-277085075576327-246767040000000-254408790495667-307627984123848-246909432979755-262154257751616-285005067759375-277458266046168-209084086944865-247146876321280-254800364272443-308101439961000-247289415368515-262557675364032-247384471840805-251238655505904-277938574536375-247527102218240-255192339637571-308575381331592-247669787407835-262961506632000-247764941323965-251625027841968-278365980483791-247907717890560-255584716796875-309049808484456-248050549297395-263365751767488-248145800707285-252011796102000-278793824375143-248288723537920-255977495956179-309524721668424-248431701236875-263770410982464-248527050190445-252398960488752-279222106434687-248670119360000-256370677321307-310000121132328-248813243425955-264175484488896-248908689973125-252786521204976-279650826886679-249051905556480-256764261098083-268312598750000-295200439337727-276084493042176-283807896905698-253174478453424-280079985955375-249434082327040-257158247492331-310952379895272-249577499351635-264986875224000-249673141235765-253562832436848-280509583865031-249816649871360-257552636709875-311429239691976-249960213487595-265393192876608-250055953115085-253951583358000-280939620839903-250199608389120-257947428956539-311906586763944-250343318671875-265799925668544-250439156092645-254340731419632-281370097104247-250582958080000-258342624438147-312384421360008-250726815104155-266207073811776-250822750368125-254730276824496-281801012882319-250966699143680-258738223360523-312862743729000-251110702984115-266614637518272-251206736141205-255120219775344-282232368398375-251350831779840-259134225929491-313341554119752-251494982511435-267022617000000-251591113611565-317452514529456-259431492873109-193642581683200-271151406933750-317695184296912-329381085850655-298437506668224-267482091162201-197741912961000-197779676391981-275392913113088-337517724272439-322061149590552-318241643371750-302775453372288-287303342904162-326190373003488-349556394596310-268044386112000-322491739979963-303122363469744-318727910521494-291575056756800-326626373062500-194457553858800-326751015828972-252891282042880-334658444832054-311369561360000-319214672757062-268658696918592-253132544459405-257075904815664-284395749897375-253277375536640-261120300677051-315742935109032-253422261847235-269068758456000-253518883411365-257468237300208-284829748550711-253663861800960-261518729447875-316224678855816-253808895451995-269479237040448-253905615258685-257860968750000-285264188511823-254050741035520-261917563306059-316706912366184-254195922101875-269890132883904-254292740201045-258254099367792-285699070004967-254438013440000-262316802457427-317189635888968-254583341996555-270301446198336-254680258438125-258647629356336-286134393254399-254825679214080-262716447107803-317672849673000-254971155335715-270713177195712-255068170169605-259041558918384-286570158484375-255213738557440-263116497463011-318156553967112-255359362319035-271125326088000-255456475595165-259435888256688-287006365919151-255602191669760-263516953728875-318640749020136-287224635533419-259731897735552-303078130283313-322819858198000-287443015782983-319004217520128-330882038109588-342764356198008-350710604053875-287716146718528-335075581658705-295711076219400-339146428956314-272157528000000-264319084815867-319610612398248-256526347130755-272364282254016-256623756033125-260621276956656-288317643694839-256769915617280-264720760048643-320096281221000-256916130687515-272778104845632-257013638231805-261017207427504-288755622191375-257159945802240-265122842015371-320582441797992-257306308886835-273192346392000-257403915122965-261413538688368-289194044013991-257550370754560-265525330921875-321069094378056-257696881928395-273607007105088-257794586906285-261810270942000-289632909386943-257941190673920-265928226973979-321556239210024-258087850011875-274022087196864-258185653781445-262207404391152-290072218534487-258332405760000-266331530377507-322043876542728-258479213336955-274437586879296-258577115948125-262604939238576-290511971680879-258724016212480-266735241338283-322532006625000-258870972103315-274853506364352-258968973606005-263002875687024-290952169050375-338844029071360-259165050806545-346948083757944-291172434388867-275269845864000-279312090566670-331246981166024-339292998954995-215591613797376-275530271434125-287564218696512-211719244126239-291668437798336-295719797513266-199848450150000-303827071219636-215917938081792-267948821622339-359999284286160-276051615234375-284106794037696-336189867815172-328247362524464-308290520725803-276312533568000-340449313641485-272410904209824-296503160808638-276521386570176-260540363143125-264598641546096-292717405244519-260688005959680-268759916704723-324980056989000-260835704543115-276939408247872-260934201252205-264998589040944-293159827093375-261081992803840-269166077331291-325471148794152-261229840150435-277357851000000-261328436050565-265398939353328-293602694510871-261476376412160-269572646955875-325962735090696-261624372596795-277776715038528-261723067737885-265799692686000-294046007721263-261871156984320-269979625784299-326454816127464-262019302081875-278196000575424-262118096513845-266200849241712-294489766948807-262266334720000-270387014022387-326947392153288-262414628805355-278615707822656-262513522578125-266602409223216-294933972417759-262661909818880-270794811875963-327440463417000-262810352966915-279035836992192-262909346130405-267004372833264-295378624352375-263057882480640-271203019550851-327934030167432-295601117814387-267306110544000-295712406431333-332232616704816-214776127640771-210763402323968-352689737925375-356810767327168-316323593283594-312326911157184-300214796935826-275924951500000-328737133558431-263851021291520-336980824038691-219281767415856-263999912076875-280298758154304-215342427642129-337297773626696-296715261192767-304901755200000-288694587356351-337551476341624-215585432051391-317336304584832-276704155484500-309315702100896-366363741245670-362361107611648-354284714544183-346205269705000-366639150924990-313739087973696-273045031145239-366845798738160-354684208640625-297664481294848-350739078665638-301855414380048-216234337413167-301968780208000-330595451012421-204109577308400-359300292303656-298111872724992-273660883373875-330905849825736-265591567137195-281988572808768-265691257433485-269829436734000-298503707770783-265840839646720-274071965561019-331402891950504-265990477991875-282412084987584-266090268078245-270234636671472-298951939503927-266240000000000-274483459216067-331900431552648-266389788081755-282836020996416-266489678008125-270640242062256-299400619721039-266639559713280-274895364544843-332398468881000-266789497606515-283260381047232-266889487422805-271046253109104-299849748646375-267039518986240-275307681753171-332897004184392-267189606765835-283685165352000-267289696521965-271452670014768-300299326504191-267439878018560-275720411046875-333396037711656-267590115759395-284110374122688-267690305505285-271859492982000-300749353518743-267840637009920-276133552631779-288551726911280-317466290901375-329896820372480-268091314572445-305268749148528-309451880048925-284748983616000-276547106713707-346780622671392-338587252183574-326260916041536-355236527036750-347040091888224-301650755915079-268643355668480-343101031348867-223264086750000-351499903355335-297796747147776-268894533757005-306183297284336-364177912241000-285601950549504-277375453191931-372663510040080-339601302057078-327237988264000-348014254138404-211333838266728-211373312864397-302610467520512-298520861373000-340045584790672-319370726502751-315281916248832-352683772803265-207499777150000-352815477702435-224183441083392-286510092490173-303175953485352-220155132359375-315753072210176-286724052348777-274308969432432-311772904577925-270253601280000-278621071782547-349381141482912-291205267065090-324546399894912-270505781918125-274718640507696-303912137846719-270657165575680-279037105168923-337406271849000-270808605702115-287527350497472-270909597163205-275128719266544-304365766188375-271061131427840-279453552493091-337909800588552-271212722189435-287956389000000-271313814089565-275539205911728-304819845705071-271465499036160-279870413960875-338413830040296-271617240507795-288385854088128-271718432896885-275950100646000-305274376621063-271870268600320-280287689778099-338918360453064-272022160856875-288815745973824-272123453784845-276361403672112-305729359160607-272275440320000-280705380150587-339423392075688-272427483436355-289246064869056-272528876953125-343869627966832-281018920105661-364973050036224-302102849857608-339928925157000-289622944350279-293875025637760-272934702601405-277185235410864-306640680007375-273086991024640-281542005384651-340434959945832-273239336085235-290107984536000-273340930929365-277597764529008-307097018763111-273493370408960-281960940657875-340941496691016-273645866553995-290539585731648-273747562136685-278010702750000-307553810039423-273900152747520-282380291309659-341448535641384-274052800051875-290971614784704-274154596423045-278424050276592-308011054060567-274307338240000-282800057545827-341956077045768-274460136778555-291404071907136-274562033988125-278837807311536-308468751050799-359242596958720-342400588139529-359375929605000-359442608297935-321443605154048-283430486571039-313100698185776-380868782343750-308984201883648-368309744339271-372612281514176-330331224860442-326156679464000-296561052041870-288141294678624-216146037624837-351832295352832-301020768345375-356203263599904-313856277789022-292704013810368-216386541322719-284325197153000-365022360804906-301411511042048-365157646130902-305770019715648-280341112581750-318628462315200-233704156255515-284746888144264-314554813916326-344373768000000-284905129696267-212655141720400-365834574178722-327610210440128-357459128470500-217068937160616-221366164330636-353399862685696-302361865030359-345011890941000-276912636125515-294007815968832-277015139413805-281328960550704-311224457901375-277168941770240-285750074850971-345522956490792-277322801044835-294443275512000-277425405520965-281745589821168-311685331954391-277579359682560-286173173171875-346034526485256-277733370790395-294879164820288-277836076504285-282162630222000-312146660770543-277990182545920-286596688929579-346546601173224-278144345561875-295315484105664-278247152563445-282580081955952-312608444574087-278401410560000-287020622329907-347059180803528-278555725558955-295752233580096-278658633898125-282997945225776-313070683589279-278813043924480-287444973578683-347572265625000-313301973871323-283311612870528-304830876465667-352123182715248-317828355821750-279225082839040-356614756107219-365275280868520-365342687268215-326719620576000-288082284367927-318239138357872-387119007310230-215105790387200-374353118637375-348599951836776-387404721554670-335812682464896-301425935517630-292867764044000-219691326596061-357602790518784-305957583427607-362044722381216-319002958968750-297503537607744-219934452542583-288986752835784-371006587364954-306352585792000-371143347179526-310781921599296-284935921854342-323850479572800-237534107201875-289413039310952-319709108040822-350016325189632-289573004753123-216139059450000-371827650394706-332976764819776-363314272083588-220624283349384-224991669363500-359187438693888-307313292335183-350661397502952-281446748628435-298821543000000-281550367728565-285934528150128-316319121459271-281705844060160-290427149365875-351178025629896-281861377618795-299261741617728-281965098455885-286355691006000-316785010240863-282120727416320-290854850811899-351695160938664-282276413631875-299702372332224-282380236255845-286777267222512-317251356252407-282536017920000-291282971958787-352212803678088-282691856867355-300143435355456-282795781328125-287199257002416-317718159718159-282951715770880-291711513012363-352730954097000-283107707524915-300584930899392-283211733872405-287621660548464-318185420862375-283367821168640-292140474178451-353249612444232-318419223133987-287938734864000-318536167206933-288044478063408-318653139909311-336175288339968-379904140935375-371238842127560-288308949318918-301469220397248-284044862175685-288467709750000-319121317083223-284201255403520-292999657671459-354288453918984-284357706026875-301912014775104-284462038334045-288891355810992-319589952608367-284618584640000-293429880410027-354808637544168-284775188369555-302355242521536-284879622763125-289315416449136-320059046708999-285036322222080-293860524084403-355329330093000-285193079132715-302798903848512-285297615662605-289739891867184-320528599609375-285454468349440-294291588900411-355850531814312-285611378516035-303242998968000-285716017232165-360507759787376-294615164010429-373833953443840-299121926930500-360771900277392-356437492680843-347700213322688-325753496118306-299395848092000-396331745802390-330336908121600-312776175782447-361300568260688-286449203941875-304132491432384-308596666194110-224875852276392-229327132798348-295533248000000-383822330840487-361829752458256-291282095466582-304577889201216-286973675958125-291441945393456-322411403693439-287131142305280-296020063697243-357940435401000-287288666244515-305023721610432-287393714204805-291868497752304-322883253956375-287551334154240-296453237308771-358464186717192-287709011723835-305469988872000-287814162119965-292295466107568-323355564364591-287971935746560-296886833296875-358988448698856-288129767021395-305916691197888-288235019903285-292722850662000-323828335142343-377129238753280-359447597033697-235237046228712-341821873691375-346324328208768-293097153719898-337567417015072-399823849126710-306587560896000-319975837496712-364483425476816-293418238760262-306811401890496-289077965873125-293578869179376-324775258703479-289236200980480-298190157578883-360564301125000-289394493820315-307259410681152-289500054459005-294007503547824-325249411935375-289658443543040-298625445131531-361090608256872-289816890387635-307707855384000-289922553711765-294436554926448-325724026433831-290081096847360-299061156089875-361617427298376-290239697771595-308156736211008-290345463831085-294866023518000-326199102423103-290504161093120-299497290659739-362144758498344-290662916171875-308606053374144-290768785016645-366882796682864-299824669706013-223790489600000-322316972110152-362672602105608-291086545788155-309055807085376-291192517468125-295726213150896-327150639771119-291351523207680-300370831457323-363200958369000-291510586820115-309505997556672-291616661385205-296156934597744-327627101578375-291775821475840-300808238096691-363729827537352-291935039467435-309956625000000-292041216967565-296588074068528-328104025773471-292200531484160-301246069170875-364259209859496-292359903929795-310407689627328-292466184414885-297019631766000-328581412580663-292625653432320-301684324885699-364789105584264-292785180406875-310859191650624-337951804530975-401108986401048-356105228982361-311085106752000-302123005446987-248056460775640-311254614889023-320334642333504-329417953328125-230183092958376-343080214993908-401837921865728-379331601926676-374883782391000-334294396847534-356946625940672-388645325463582-307356719768672-230559368449125-375292152488448-393449893255311-366381875662632-407164823893710-330315821272000-303221566904207-298750048877808-330495590415511-294330264616960-303441598267875-366913827486216-294490410455995-312669577942848-294597206614685-299183700750000-330975293647023-294757449259520-303881980273259-367446293956584-294917750001875-313123270125504-295024649445045-299617772065392-331455460836167-295185047040000-304322788154227-367979275322568-295345502760555-313577400975936-295452505538125-300052263026736-331936092207199-295613058158080-304764022116603-368512771833000-295773668931715-314031970706112-295880775093605-300487173836784-332417187984375-296041482813440-305205682366211-369046783736712-296202248715035-314486979528000-296309458311165-300922504698288-332898748391951-296470321205760-305647769108875-369581311282536-296631242310195-314942427653568-296738555390485-301358255814000-333380773654183-296899573534720-306090282550419-370116354719304-297060649916875-315398315294784-342886230612975-370384069974552-347583672104724-297329240000000-379735186573483-361500015177432-302067248222982-325009849697344-233499962901375-228962893650800-238164430428236-343568447078400-325303550971559-398683396947000-320837685499170-357569419968384-325538639346187-311839791280992-339416348219750-298189816138240-307420385126571-371724582863592-298351358802835-316768617432000-298459086318965-303105466873968-335313527734791-298620726210560-307864607421875-372261692352456-298782424452395-317226265255488-298890255702285-303543322302000-335797880634143-299052051217920-308309257445179-372799318976424-299213905111875-317684353654464-299321840145445-303981599200752-336282699733687-299483791360000-308754335402307-373337462984328-299645800980955-318142882840896-299753839848125-304420297772976-336767985257679-299915946836480-309199841499083-373876124625000-300078112259315-318601853026752-300186255010005-304859418221424-337253737430375-300348517847040-309645775941331-374415304147272-300510839146635-319061264424000-300619085830765-305298960748848-337739956476031-300781504591360-310092138934875-374955001799976-300943981842595-319521117244608-301052332510085-379857452966000-310427192540637-240971925815296-310538930685539-375495217831944-338470160921875-319981411700544-389612670781572-352570117829152-231995750741950-301648726080000-310986151399147-408532886657984-246092466451311-362238949917312-343724392215250-236933731279656-241622927244556-329967542259712-409047380787672-395173611265000-399894584353906-362760281979264-386083527458231-353585803537184-418795281213750-302517612899840-325846740861110-381774768552144-302680714706435-321364947000000-302789481806565-307503011666928-340178062647671-302952681308160-312330389375875-377661270729096-303115939440795-321827010116928-303224810773885-307945090926000-340667087640463-303388166648320-312779327999499-378204082389864-303551581181875-322289515929024-303660556797845-308387593683312-341156581076007-303824069120000-313228696615187-378747413922888-303987640129355-322752464648256-304096720078125-308830520141616-341646543178559-304260388922880-313678495428763-379291265577000-304424116482915-323215856486592-304533300814405-309273870503664-342136974172375-304697126256640-314128724646051-379835637601032-304861010442235-323679691656000-304970299206365-309717644972208-342627874281711-305134281320960-314579384472875-380380530243816-305298322206995-324143970368448-305407715453685-310161843750000-343119243730823-305571854315520-315030475115059-329195260034480-418623209629875-329313166645120-305845549756045-348255735771888-414216099746152-315425532992000-395529667602804-367343290292784-367409039941866-372186012787776-329844094798750-320477318530528-240400999572813-391310848557056-334795678007239-396167161572000-386803797524902-325539469883712-306722473324605-311496987966384-344596170359375-306887082877440-316386333992011-382565311979112-307051751314035-326005524888000-307161562990165-311942886008688-345089419410151-307326329589760-316839149953875-383112811448136-307491155101195-326472024495168-307601071509485-312389209374000-345583138921983-307765995230720-317292397760219-383660833028904-307930977891875-326938968917184-308040999082245-312835958265072-346077329119127-308206080000000-317746077616867-384209376970248-308371219885755-327406358366016-308481345908125-313283132884656-346571990225839-308646584097280-318200189729643-384758443521000-308811881282515-327874193053632-308922112186805-313730733435504-347067122466375-309087507722240-318654734304371-385308032929992-309252962281835-328342473192000-309363298117965-314178760120368-347562726064991-309528851074560-319109711546875-385858145446056-347810704693659-314515059906432-376532113972331-314627213142000-348058801245943-329045729083392-395879180567571-248064896648608-429419608458750-367457804949312-353204196930722-324623853088096-429725771794710-257881401216000-415549611084927-339187108597848-430032080619630-344086944450048-391946597192250-315525399006576-239076963871150-425632780505088-325260483747332-392295718250000-311021486298315-330220052492352-239332494123850-315975132255024-349549858525375-311298425751040-320933951311131-388063831557672-311464668305635-330690563064000-311575529549765-316425292651248-350047822278231-311741870735360-321391094979875-388616563341576-311908271113595-331161520358208-312019237589085-316875880398000-350546258734703-312185736645120-321848672551339-389169819725544-312352294921875-331632924586944-312463366678645-317326895698032-351045168119047-312630023680000-322306684231347-389723600958408-312796739930155-332104775962176-312907917018125-317778338754096-351544550655519-313074732039680-322765130225723-390277907289000-313241606338115-332577074695872-313352888807205-318230209768944-352044406568375-313519861923840-323224010740291-390832738966152-313686894345435-333049821000000-313798282245565-395938874750256-323568456403909-333286362057216-323683325980875-265757349297880-352795078508939-343190348857152-352920294152317-246604500921000-367554260218356-430501745364992-406388334281748-435493310394960-377494483148250-382401969800384-338897283704910-246954667004232-431036530080751-343921578048000-421499757422607-242284190472400-378030347952426-363555160276800-324833517359375-320041977471216-354048568468759-315304600698880-325063882116963-393057324117000-315472266361915-334945286160192-315584076485405-320495991321264-354550794627375-315751841200640-325524938319851-393614786259432-315919665361235-335420273496000-316031581165365-320950434346608-355053495507911-316199504424960-325986430277875-394172775241416-316367487157995-335895709674048-316479508692685-321405306750000-355556671334623-316647590571520-326448358196859-394731291311784-316815731951875-336371594906304-316927859267045-321860608734192-356060322331767-317096099840000-326910722282627-395290334719368-317264399942555-336847929404736-317376633088125-322316340501936-356564448723599-317545032430080-327373522741003-395849905713000-317713491329715-337324713381312-317825830355605-322772502255984-357069050734375-317994388541440-327836759777811-396410004541512-318163006313035-337801947048000-367240905310575-396690251971608-372268955790612-318444168373760-406700537144875-387168887467224-323514682708998-348084837301312-250076927653119-245216754950000-255070458774092-367955044761600-348392278404647-426978585713208-343606639241250-382943559643008-348638361587083-333966101871456-363497845773926-319345000000000-329229092417067-398093470524648-319514094836755-339236348308416-319626857883125-324601453190256-359092219452039-319796052193280-329694077825843-398655683181000-319965306201515-339715382855232-320078175377805-325059767917104-359599202921375-320247528906240-330159500842171-399218424916392-320416942160835-340194868152000-320529917516965-325518513846768-360106663355191-320699430338560-330625361671875-399781695979656-320869002914395-340674804410688-320982084500285-325977691182000-360614600977743-321151756689920-331091660520779-400345496619624-321321488661875-341155191843264-321434676527445-326437300125552-361123016013287-321604508160000-331558397594707-400909827085128-321774399602955-341636030661696-321887693798125-326897340880176-361631908686079-322057684948480-332025573099483-401474687625000-322227735937315-342117321077952-322341136512005-406717283624048-332376242572125-258009029804032-332493187240931-402040078488072-362396143755667-342599063304000-417150467830404-377488221456928-248391183452350-322965315279360-332961240224875-437399111027648-263479866707439-387830986797696-368006894323666-253670952393000-258690351343372-353273901764608-437937558785496-423082202904040-428134857531250-388376587168128-413345132349239-378551193649952-448363060563510-323874649280000-348849349970870-408723872980176-324045339201155-344047002960576-324159165793125-329204028915696-364183544457719-324329955655680-334368034289923-404306950149000-324500805497115-344530554545472-324614738718205-329666664794544-364695307663375-324785688547840-334837844702091-404874996360552-324956698384435-345014559000000-325070738284565-330129733903728-365207550076071-325241848156160-335308094985875-405443574388296-325413018062795-345499016536128-325527164691885-330593236446000-365720271920063-325698434680320-335778785347099-406012684481064-325869764731875-345983927365824-325984018139845-331057172624112-366233473419607-326155448320000-336249915991587-406582326887688-326326938591355-346469291701056-326441298828125-331521542640816-366747154798959-326612889274880-336721487125163-407152501857000-326784539840915-346955109753792-326899006956405-331986346698864-367261316282375-327070757744640-337193498953651-352353391045040-448070594039091-352476764080000-327357142724365-372748746819312-443346360442216-337606870972928-423342387184500-393172433794608-393241230370794-398352471317568-353032299126430-343005659500000-257299247991501-418815162712064-358326239280967-424009418134176-413986347907750-348415288336704-328274697978045-333383365148592-368806683599567-328446930240000-338612180666827-409438532337768-328619222733555-348902923379136-328734117863125-333849907399536-369322767741799-328906510766080-339085957333203-410011373853000-329078963928715-349391013198912-329193966186605-334316884705584-369839333109375-329366519805440-339560175723611-410584749423912-329539133712035-349879558008000-329654243148165-334784297269488-370356379926551-329826957557760-340034836043875-411158659299336-329999732283195-350368558018368-330114948947485-335252145294000-370873908417583-330287824222720-340509938499819-411733103728104-330460759841875-350858013441984-330576083784245-335720428981872-371391918806727-330749120000000-340985483297267-412308082959048-330922216587755-351347924490816-331037647858125-336189148535856-371910411318239-331210845089280-341461470642043-412883597241000-372169838439963-336540974360448-402899564125163-336658304158704-372429386176375-352083645825024-423594712856979-265430884380064-459479656301310-393178866696000-377926042679714-347343892903264-459799944171030-275928023632896-444628139109375-362920647761496-460120380847470-368160410617344-424481048499087-337597924422000-255800536869550-455404234493952-348009882406916-419732036250128-332772339436875-353312129177664-281674631207915-338068389467952-373989207073087-333062042560000-343369849610907-415191009855528-333235945113955-353804321532096-333351913773125-338539291393776-374510113560279-333525917204480-343848052779683-415769203125000-333699981176315-354296970783552-333816057463005-339010630402224-375031503515375-333990222359040-344326699730731-416347932938472-334164447823635-354790077144000-334280631787765-339482406696048-375553377162631-334454958223360-344805790669875-416927199544776-334629345255595-355283640825408-334745636947085-339954620478000-376075734726303-334920124997120-345285325802939-417507003192744-335094673671875-355777662039744-335211073140645-340427271950832-376598576430647-335385722880000-345765305335747-418087344131208-335560433272155-356272140998976-335676940568125-423542873151792-346125581746501-428856852645376-428931276811227-439343196565000-336026624256115-367108152637248-424057625126074-341373888780144-377645713158375-460497245179904-346726598423891-269147916314784-336493246823435-357262473000000-398753348986377-383283958122992-455876174787176-336785105180160-435305442400500-404282274912048-404352361408554-409607359286848-363006142424030-352695660588000-264567592412781-430645409972224-368447263914087-435984977832096-425678131931750-358254638524224-379088692962949-342797101774512-275324149456227-358502966592000-457300374710168-431392107430584-467855592954030-410744367269696-410815500046875-265255932820776-265301864583933-369405763080192-452730504499143-416375986960000-447681675309426-400900655414336-437421874263108-395831150793504-463619340263375-359497426404864-369981659714463-422164795736232-422237847266739-364960043280000-380667039745933-354655303266784-276470336988171-349560697520128-370494070042375-464502475458504-428042594555686-360244476925248-381194127247077-344700864750000-470127914509590-282125522783232-454614153999999-454692752574168-344998962915750-407796531013248-355576379083924-355637840776416-423700648141599-340065456640000-434312474601123-282613572824112-340241788324555-361242153193536-377013463353000-267097341978696-272381593632876-261950623001600-372034139263039-434988271899000-340712304127715-361741681336512-340830000817605-346133303315184-382910521484375-341006596669440-351559797829411-425093434626312-341183253511035-362241669768000-341301058627165-346611663219888-383439677424751-341477817141760-352045573288875-425680782984936-341654636674195-362742118699968-341772550266485-347090463654000-383969320645383-341949471518720-352531796029619-426268672117704-342126453816875-363243028344384-342244475935245-347569704820272-384499451370527-342421560000000-353018466257467-426857102273448-342598705138755-363744398913216-342716835833125-348049386921456-385030069824439-342894082785280-353505584178243-427446073701000-343071390839515-364246230618432-395988034799775-469986763701016-417251135921625-438453297325568-438528827609179-417466806731928-369971011974130-375320944648000-269643166382511-264401571772400-275024987430284-396738960076800-375644218484375-460375688875512-370480994343810-412892749366656-375902971165819-360081719676000-391921084675334-344314258961920-354969626156379-466308999420352-344492056211875-365754494672064-440041255413599-402998669447072-265176318775950-387224031232000-461565562849527-270619459659288-281280361777271-414030978221952-419411189293875-361074249412448-393001314448102-430251087370752-440950379097467-387890509625000-414529610418378-419916272103232-419988459875483-404108985442464-462677960009625-276590680850432-462837019640391-430991282908872-372525610350530-393880461264000-420566259911299-404664907389728-431361698819607-346213919567360-442164490628875-287722700137584-346392370126595-367771982179008-389158924607757-362566461164000-282637095039883-357357306249216-378757097200007-474861544545736-437588001843750-368277510606144-346987648171645-352386401357232-389827620706447-347166364480000-357909825607947-432771214837608-347345142143155-368783502077376-347464361343125-352870503958896-390363128782119-347643241287680-358401431778323-433365612669000-347822182615115-369289956804672-347941510940205-353355049725744-390899127053375-348120554595840-358893487905691-433960554509352-348299659662435-369796875000000-348419097162565-353840038860528-391435615744471-348598304604160-359385994195875-434556040607496-348777573484795-370304256875328-348897120209885-354325471566000-391972595079663-349076491512320-359878950854699-435152071212264-349255924281875-370812102642624-349375580281845-440826220298224-360248964027053-467866077696000-387265817646792-435748646572488-457345392946695-414372054544448-452119632562500-366064264515168-274595196651333-403885588646400-382410467809119-436345766937000-457972072244735-431106303421440-350333812298405-355784433134064-393586479192375-350513675632640-361360525101251-436943432554632-350693600518235-372338425416000-350813584642365-356271642149808-394125423346511-350993612136960-361855285292875-437541643674216-351173701210995-372848128870848-351293794809685-356759295750000-394664859266023-351473986539520-362350496882259-438140400544584-351654239876875-373358297277504-351774443000045-357247394137392-395204787175167-351954799040000-362846160075227-438739703414568-352135216715555-373868930847936-352255529413125-357735937514736-395745207298199-460877911326720-439264541511729-287469089929000-396015602010003-374380029794112-293043091221918-401646129246576-418000427796875-439789797997056-472447451675871-477959449840576-440015036038659-391191228864000-451033514917103-277188369129768-277235668208637-375147551256576-391525104717000-489489878345040-467814568166258-418928682593344-353701419985485-359204239614000-288501088071763-408325885401600-392059701133704-484711997631976-490241782788750-424948658529408-403225159002802-452343165048936-436067741823920-365268992000000-370783962630468-463558955552680-447274273848614-392795565470208-365580389248375-360185336347056-398454698970639-272960680985600-371289778231972-442347000561000-284024232446812-420645992299456-458964707493348-415324516637344-278752081252125-399066034065408-366328464615571-442950132395592-355514340197835-377456408232000-355635421313965-361168217905968-399541948985791-355817094530560-366827748046875-443553812220456-355998829607395-377970770743488-356120020697285-361660328502000-400086314893143-356301858897920-367327484934179-444158040284424-356483758986875-378485600326464-356605060100445-362152885912752-400631175032687-356787063360000-367827675483307-444762816836328-356969128535955-379000897192896-357090539723125-362645890340976-401176529628679-357272708116480-368328319900083-445368142125000-357454938454315-379516661554752-357576459765005-363139341989424-401722378905375-357758793367040-368829418390331-445974016399272-401995489119067-363509724336000-280941597564831-374652430183904-402268723087031-457451715428352-369330971159875-496200488786640-358427880197595-380549593612608-292355845553377-408264265062000-402815562397903-358732286149120-458151301618011-469270741932040-425176245484375-436293828650304-386655084741310-375671545383136-281801476029789-458695917056000-392445018889111-464379933239712-453400185180934-381584398195776-403773723271125-365117624840496-293250254070259-287766034642944-481536374277903-276791980450000-293449258929663-431941960155264-376628642785876-376692507014112-415540123303125-360195834019840-371341729147491-465641691680928-388100522816930-432528174000000-360501240001565-366109454858928-405007875418671-360684566428160-371845556400875-449620804677096-360867954995795-383140119764928-360990248568885-366606042726000-405557193739463-361173740728320-372349839168499-450230528817864-361357295056875-383659631721024-361479699152845-367103079435312-406107008535007-361663357120000-372854577656187-450840803934888-361847077284355-384179613080256-361969591953125-367600565189616-406657320029559-362153415802880-373359772069763-451451630277000-362337301877915-384700064054592-362459927169405-368098500191664-407208128447375-474226660661760-451986555698793-295794313937416-385155844054911-390803897680000-295944421001113-463538506446504-407759434012711-385481621508096-491711859639000-452674937631816-503057186255070-441647067826368-374624754130183-503312343750000-486617501570337-408380247299584-481186805842822-414114432302736-296645592125375-414254398873984-453517242064533-279996214175600-492876593130152-408932610048000-375385113099427-453900452872968-453977120929707-392392170782080-375638794532375-370094736732336-308464362616465-454360590715392-403944276067848-303009359382000-415305153570814-387309370571712-409831261430941-415515517500976-505442012343750-410038829314048-488758890049671-494460242755776-460824798851398-438419510256000-455358622633821-382340875632224-303674863735098-421841800972800-399410941025375-455742869876136-478329362304255-405241448246784-365904678104485-506722692510000-292822485522892-422411344281600-399950169314247-490162419790008-394450051441250-439604160398208-400219965360683-383373879804256-417271313471526-366583880000000-377927072417867-456973913542248-366769262640755-389405290478016-366892885783125-372600164812656-412187802756839-367078372577280-378436837410643-457590265821000-367263921877515-389930449261632-367387656141805-373102603443504-412743592741375-367573309642240-378947060593371-458207172061992-367759025676835-390456079992000-367882871112965-373605493552368-413299882115991-368068691394560-379457742171875-458824632514056-368254574238395-390982182881088-368378530896285-374108835342000-413856671104943-368564518033920-379968882351979-459442647426024-414135253024875-374486638221696-283749719762650-465427811806704-414413959932487-414483656192000-403195733956791-505499361940232-420373515031918-392035805983296-369371185698125-420585586868464-511609005398070-403670507397632-500408111372312-460680341625000-443692668591978-438077915214016-369868181116005-375621572823024-415530038000375-370054669271040-381505056560131-461300021409672-370241220100635-393091320264000-370365622144765-376126723363248-416088827689231-370552277455360-382018033204875-461920256649576-370738995468595-393619787126208-370863508984085-376632326598000-416648118113703-371050331525120-382531469480339-462541047593544-371237216796875-394148727418944-371361841833645-377138382730032-417207909498047-371548831680000-383045365592347-400263797707760-440364047537799-411838060543488-434790879813500-434863814986656-509333835396167-429285897830400-406458809612199-515315886210000-423775228643854-441029249914176-372359846362205-378151854496944-418328996043375-372547171043840-384074538149291-464406757138152-372734558540435-395738391000000-372859518440565-378659270537328-418890291652871-373047010652160-384589815005875-465029773386696-373234565706795-396269227134528-373359637327885-379167140286000-419452089119263-373547297144320-385105552522299-465653346583464-373735019831875-396800537759424-373860203223845-379675463945712-420014388666807-374048030720000-385621750904387-466277476977288-374235921115355-397332323086656-374361216328125-380184241719216-420577190519759-489795122833920-466824048343209-311268109878000-380502458522406-397864583328192-374862676840405-380693473809264-421140494902375-375050839920640-386655531088851-467527410351432-375239065956235-398397318696000-375364584960365-381203160418608-421704302038911-375552915944960-387173113302875-468153213829416-375741309912995-398930529402048-375866940887685-381713301750000-422268612153623-376055439851520-387691157205859-468779575499784-376244001826875-399464215658304-376369744822045-382223898006192-422833425470767-376558411840000-388209663003627-469406495611368-376747141897555-399998377676736-376872996963125-475519179545072-388598845594221-504682759901184-394530550766212-475836862986000-516543307675379-417947494611456-476075218397994-383246456103984-290386686718750-313669966869504-389248061106811-313774674769008-493987003402815-447568782584000-482524773432703-441903633252768-308221054857611-517665101971456-506116596756375-494564219406760-407356118666210-448166470618944-413313331819499-390093121733000-425097715248783-401871694428672-390288309259019-471919765446504-378764187741875-402139787611584-378890491588245-384783710255472-425665047941927-379080000000000-390809127618067-472549481496648-379269571591755-402676331620416-379395987758125-385297040318256-426232885183039-379585664673280-391330409106843-473179757481000-379775404796515-403213352663232-379901933332805-385810826725104-426801227196375-380091778826240-391852153931171-473810593648392-380281687555835-403750850952000-380408328511965-386325069678768-427370074206191-380598342658560-392374362296875-474441990247656-380788420069395-404288826698688-380915173495285-386839769382000-427939426436743-381105356369920-392897034409779-475073947527624-381295602536875-404827280115264-381422468482445-387354926037552-428509284112287-381612820160000-393420170475707-475706465737128-381803235157955-405366211413696-381930213673125-387870539848176-429079647457079-499696344760320-382184255157185-517504691000000-382311318132315-405905620805952-311834395248481-394271256638088-453193010760875-512134332206592-506331848282598-529970206600080-506500111426594-453569625432000-453644973395537-447827857888928-294672528802350-453871067353088-418573998148375-489400163454168-383328835939595-406985874719808-383456152463085-389420126238000-430793773749503-383647180101120-395517358386139-478242152847144-383838271171875-407526719665344-383965700464645-389937570696432-431366162013847-384156897280000-396042817304547-478877479436808-384348157556155-408068043552576-384475699668125-390455473323696-431939057068719-384667065735680-396568741410923-479513368449000-384858495292115-408609846593472-384986150273205-390973834322544-432512459138375-385177685667840-397095130911091-480149820132552-385369284579435-409152129000000-385497052479565-391492653895728-433086368447071-385688757276160-397621986010875-480786834736296-385880525617795-409694890984128-386008406486885-392011932246000-433660785219063-386200280760320-398149306916099-481424412509064-386392218606875-410238132757824-386520212494845-392531669576112-434235709678607-386712256320000-398677093832587-416597268629360-529761359591163-416735214743680-387032470703125-488337166958832-434811142049959-387224684154880-399205346966163-536334731730000-315893829930823-464977281285504-423318582663227-405498962047072-435387082557375-411598337662464-399734066522651-483340527329832-387930011275235-411870738936000-388058344519365-394093637473008-435963531425111-388250897448960-400263252707875-483980360267016-388443514063995-412415901987648-388571960526685-394615212750000-436540488877423-388764683307520-400792905727659-484620757617384-388957469801875-412961545888704-389086029533045-395137248020592-437117955138567-389278922240000-401323025787827-485261719629768-389471878688555-413507670851136-389600551738125-395659743487536-437695930432799-389793614446080-401853613094203-485903246553000-389986740923715-414054277086912-390115527341605-396182699353584-438274414984375-390308760125440-402384667852611-486545338635912-390502056707035-414601364808000-390630956543165-396706115821488-438853409017551-390824359477760-402916190268875-487187996127336-391017826238195-415148934226368-391146839542485-397229993094000-439432912756583-511752847380480-391404951278705-529989472793792-391534049716875-415696985553984-319356128562769-451993558379400-464123223764123-524485416000000-518542312615686-542750009256720-518713270022722-464505869032128-464582423314625-458624453722016-301776335787150-464812136628224-428663629136359-501196384863000-392567859315515-416794534784832-392697213323805-398804391766704-441174484451375-392891297610240-405046960628971-489764285154792-393085445834835-417344033112000-393214913510965-399330114285168-441756029256391-393409168322560-405580824421875-490409773421256-393603487100395-417894014196288-393733068494285-399856298622000-442338084888543-393927493905920-406115157107579-491055828589224-394121983311875-418444478249664-394251678473445-400382944979952-442920651572087-394446274560000-406649958891907-491702450907528-394640934668955-418995425484096-394770743648125-400910053561776-443503729531279-394965510484480-407185229980683-492349640625000-395160341371315-419546856111552-395290264218005-401437624570224-444087318990375-395485201879040-407720970579731-492997397990472-395680203618635-420098770344000-395810240382765-401965658208048-444671420173631-396005348943360-408257180894875-426607415156720-542489944974507-426747562138240-396330672342085-500068495206000-445256033305303-396525951877120-506416275730611-506499422010392-524892791031250-476143709228928-402956968915578-512938508959968-311478069713589-458131166400000-433768683824911-452171133410832-550028112406830-440094695781888-501301202528250-403552536925296-305771778295150-544363058884608-415986074466692-501712554698000-397764212051115-422311267563072-306072849987850-404082423108144-447012946633375-398090497891840-410406723432891-496244708246952-398286355018435-422865603000000-398416962118565-404612772934128-447599609801271-398612926300160-410945285415875-496895876725896-398808954728795-423420423313728-398939676045885-405143586606000-448186786038863-399135811576320-411484318349899-497547614594664-399332011381875-423975728716224-399462846965845-405674864326512-448774475570407-399659153920000-412023822440787-498199922102088-399855525177355-424531519419456-399986475078125-406206606298416-449362678620159-400182953530880-412563797894363-498852799497000-400379496314915-425087795635392-400510560582405-406738812724464-449951395412375-400707210608640-413104244916451-499506247028232-400903924994235-425644557576000-401035103678365-506003964730416-413509889773669-425923120759296-413645163712875-339614994715480-450835434358379-438555480973632-450982886666077-315121751625000-469669975413876-550098180288512-519278665330068-556460948327760-482344986932250-488608748099264-433015222170510-315534079674312-550727891962831-439416518976000-538527945049647-309549390696400-482975949935466-464475825940800-402611480513125-507992841455472-452311404490999-402808817582080-415270752806403-502125743493000-403006219122715-427876466824512-403137855972605-409406818763184-452902693359375-403335364989440-415813560758411-502782045438312-403532938506035-428435660568000-403664690022165-409941816171888-453494497315751-403862371061760-416356841513875-503438919012936-404060116629195-428995341307968-404191982861485-410477279454000-454086816584383-404389835998720-416900595278619-504096364465704-404587753691875-429555509256384-404719734690245-411013208812272-454679651389527-404917760000000-417444822258467-504754382045448-405115849893755-430116164625216-405247945708125-411549604449456-455273001955439-405446143265280-417989522659243-505412972001000-405644405434515-430677307626432-405776616114805-412086466568304-455866868506375-405974985994240-418534696686771-506072134581192-406173420513835-431238938472000-406305746109965-512653806370736-418943888148789-325203430709248-419080344546875-506731870034856-531842247741055-475606961745152-506979418574709-563402169630000-544710754658217-444606424547328-551151179808856-519920380551832-513739877955750-488758925136768-463769823679522-526527086708448-564227958466710-457726029632000-420173062588107-508053060557928-407763224979955-432926760194496-407895895623125-414238583915376-458247499045479-408094955540480-420720133180883-508714516125000-408294080210315-433490344537152-408426865969005-414777781483824-458843948885375-408626098583040-421267678429531-509376545560872-408825395977635-434054417784000-408958296901765-415317446750448-459440916055831-409157702287360-421815698539875-510039149114376-409357172481595-434618980147008-409490188621085-415857579918000-460038400781103-409689766853120-422364193717739-510702327034344-409889409921875-435184031838144-410022541326645-416398181189232-460636403285447-410222292480000-422913164168947-511366079569608-410422108498155-435749573069376-410555355218125-416939250766896-461234923793119-410755279367680-423462610099323-512030406969000-410955268410115-436315604052672-411088630495205-417480788853744-461833962528375-537839105474560-411355441215745-557002311535296-411488889857435-436882125000000-424287670968567-418022795652528-462433519715471-437165569276416-557634892111000-557725299843008-570493347285870-488167876543424-412156566004885-520035640182000-463033595578663-412357009592320-425113802823699-514026840840264-412557518156875-438016637634624-412691226636845-419108216196912-463634190342207-412891843520000-425665152728987-514693470184488-413092525408355-438584629745856-413226349453125-419651630348016-464235304230359-413427139706880-426216979142563-515360675637000-413627994993915-439153112668992-413761934653405-420195514022064-464836937467375-413962898352640-426769282270251-516028457446632-414163927113235-439722086616000-414297982437365-420739867421808-465439090277511-414499119656960-427322062317875-516696815862216-414700321965995-440291551798848-414834493004685-421284690750000-466041762885023-415035803819520-427875319491259-517365751132584-415237179751875-440861508429504-415371466555045-421829984209392-466644955514167-415572951040000-428429053996227-518035263506568-415774500670555-441431956719936-415908903288125-524769868730672-428844668247621-332888449214464-428983266038603-518705353233000-544408372589935-486843770478848-525363659678394-576711794090160-557578115765625-455108509495296-564169255410904-532200119833816-525872979720198-500301415536000-474721574853634-538960147602912-577550534515830-468533286651392-430093123558875-520047265738536-417389244220195-443146253669568-417523994580485-424015863414000-469062930732183-417726174494720-430648769448419-520719089015304-417928419666875-443718670718784-418063286041245-424563510570672-469668726833327-418265640000000-431204893698667-521391490639848-418468059244755-444291580487616-418603041683125-425111629075056-470275044301639-418805569761280-431761496515443-522064470861000-419008163153515-444864983188032-419143261705805-425660219129904-470881883361375-419345963978240-432318578104571-522738029927592-419548731592835-445438879032000-419683946308965-426209280937968-471489244236791-419886822850560-432876138671875-523412168088456-420089764762395-446013268231488-420225095692285-426758814702000-472097127152143-420428146577920-433434178423179-524086885592424-420631262861875-446588150998464-420766710055445-427308820624752-472705532331687-550499146240000-421037691666865-570112000945344-421173226090955-447163527544896-434272136970375-427859298908976-473314459999679-486360218534400-564268620570063-564359397375000-454155320391570-499651212353216-512711621955083-493320893660064-584289752523750-448027518664704-454593764757510-357238252047160-474228831658067-461310422616000-474381341331013-441960511959904-520037132819760-448604130587136-435671133384875-526791554015976-338241526842076-468409692501504-422937821300085-429513569958000-475144380176903-423141745029120-436231572143539-527469171967944-423345734296875-449469975764544-423481763557645-430065939715632-475755400041247-423685862080000-436792491321147-528147370756008-423890026169155-450047824387776-424026171993125-430618782848496-476366943515319-424230445383680-437353891123523-528826150629000-424434784369115-450626168062272-424571046806205-431172099559344-476979010823375-424775495139840-437915771756491-529505511835752-424980009096435-451205007000000-425116388196565-431725890050928-477591602189671-425321011548160-438478133425875-530185454625096-425525700550795-451784341412928-425662196363885-432280154526000-478204717838463-425866994808320-439040976337499-530865979245864-426071858931875-452364171513024-491779005585975-478741624282936-491936669171925-426413445120000-439604300697187-531547085946888-426618484439355-452944497512256-426755213828125-433390106237616-479432522880559-426960362682880-440168106710763-532228774977000-427165577272915-453525319622592-427302423524405-433945793879664-480047212722375-427507747696640-440732394584051-532911046585032-427713137632235-454106638056000-427850100796365-434501956316208-480662427743711-428055600360960-441297164522875-533593901019816-428261165716995-454688453024448-428398245843685-435058593750000-481278168168823-428603920875520-441862416733059-534277338530184-428809661726875-455270764739904-428946858866045-435615706383792-481894434221967-429152709440000-442428151420427-462312285870960-455780695145343-462460146942080-350204381897625-442781980699432-508950197422051-575139554832384-568619637552374-595162181970000-568801431008946-509357097144896-509438503105609-502902775950624-330909961718750-509682773028352-470042326903743-549573896497016-430457959304035-457020682488000-523339155609739-437289897512688-483746388392151-457312770686976-583332630023000-563536278590760-543733584291046-510660633550144-583705346670072-338337796389000-338391818071221-345082038552576-471244929151247-550979905145272-431559167641875-464830213563520-544602306900986-332127579279600-345467810292748-345522944000000-578178716746887-511803050651816-598306812086430-518615306232192-438898350668250-505478732246816-552124051327269-345964224845824-578917092074223-432593254665000-439318594818246-459360873469632-432800270096805-439528817451504-486223033016375-433007351562240-446401820882371-539765859193992-433214499071835-459947166792000-433352634107965-440089738984368-486843512166991-433559891714560-446971422796875-540454555582056-433767215393395-460533958769088-433905467891285-440651137542000-487464518963943-434112901713920-447541509040979-541143837534024-434320401636875-461121249612864-434458771646445-441213013327152-488086053631487-434666381760000-448112079820507-541833705298728-434874058001955-461709039535296-435012545573125-441775366542576-488708116393879-435220332052480-448683135341283-542524159125000-435428184688315-462297328748352-435566789871005-442338197391024-489330707475375-435774752791040-449254675809131-543215199261672-489642201205867-442760634096000-516636244076337-496586537114672-503377219623525-335638187827200-577389497357750-597626018644744-517129452867951-510494649970432-564320646028356-510657003828000-604821545127990-598196393385472-584846738501679-571492819188040-605206230468750-517869854453952-464138952957177-444029557762032-491201652877047-349952671744000-450972208953347-545291840022408-491513940011251-531996857057216-498405340505250-458066855751008-606361265109270-532334990642688-593074937784472-593169136472000-606746602977390-525930567886464-465320155389033-445159523224944-505943420053125-452047886938112-580332697343478-607421337011280-607517768402910-526598982000000-607710661803090-560533236405064-344478704416677-452622280626688-587826685383375-466281356677704-608289586977870-527267962206336-446220605386314-453053395057000-493703656818263-439668887224320-453269054891299-548068917811464-439878153706875-467021642351424-440017701578845-446858063297712-494330482525807-440227078720000-453844482345387-548764657389288-440436522270355-467614434718656-440576188203125-447425201967216-494957838570759-440785742458880-454420396598963-549460985517000-440995363151915-468207728496192-441135147195405-447992820297264-495585725177375-441344878640640-454996797857851-550157902443432-441554676551235-468801523896000-441694578755365-448560918490608-496214142569911-441904487464960-455573686327875-550855408417416-442114462667995-469395821130048-442254483082685-449129496750000-496843090972623-442464569131520-456151062214859-551553503687784-442674721701875-469990620410304-442814860377045-558716386860784-456584414121293-552077462016000-565798519927523-565888045009624-586434600481842-531966694376832-450196875620250-573068483626464-347989474890213-511830175142400-484609204051839-614390514570000-450624300232326-498496608621504-443937034665605-505485158067376-546556848750000-444147653181440-567232054689139-574156932497568-533230005963642-540151660568000-533398598470998-465087663427424-506204804638438-444709628213760-458465444048875-554351782709736-444920491002195-472374842232768-445061103218485-451979596134000-499995805987783-445272077086720-459045260108019-555052828194504-445483117616875-472972154923584-445623848343245-452551059047472-500627945160927-445835000000000-459625564819067-555754464468648-446046218346755-473569970932416-446187067633125-453123003446256-501260616914039-446398397153280-460206358387843-556456691781000-446609793391515-474168290471232-446750761287805-453695429533104-501893821471375-446962268746240-460787641020171-557159510380392-447173842950835-474767113752000-447314929506965-454268337510768-502527559057191-447526614978560-461369412921875-482103758470320-530397758096591-551149496796160-447879572490285-509974058198000-620336502611190-489453722454528-496425679843464-599942250023448-593139838637250-531150767736512-448444690437445-510617490852528-379572806597545-448656732160000-462534425356707-559271516389128-448868840712955-476566608165696-449010283548125-455989954816176-504431972228079-449222503508480-463117666301483-559976702625000-449434790327315-477167448533952-449576352022005-456564792384624-505067844170375-449788750295040-463701397338931-560682481392072-450001215454635-477768793704000-450142896058765-457140112857648-505704250262431-450355472719360-464285618674875-561388852939176-450568116294595-478370643887808-450709915858085-457715916438000-506341190728503-450922670981120-464870330515139-562095817515144-506659861421875-458148086284416-354079199886183-569393343529264-506978665792847-361192276224000-583556190709044-618388893923752-451703345911155-542129233206912-556117395130000-458868973731696-556292247320240-479877480173568-612113849773272-612210053752000-514893907022254-549770418908352-577697662180631-529059292676384-626616025413750-452627122787840-466627411120091-348284118459600-599142789947714-550461809000000-564486204471381-585485047493472-355528895092077-578696719859712-481160776201125-383594180365880-481311902444967-495340737647552-509373962378117-474559830108000-558393333170480-481689856492032-467801254485099-565639544537064-593665529399375-502948551808512-454122036849845-628883037992880-628981727594310-496274559488000-615197379153368-608301929734776-573432003537094-482597753365056-454692392578125-461760085536816-510814755300959-454906399034880-468977064807163-567061195257000-455120472630915-483203651289792-455263225666405-462339761274864-511455978832375-455477411184640-469565708091651-567772913021832-455691663870235-483810056136000-455834536314365-462919921945008-512097738756111-456048900968960-470154843732875-568485226055016-456263332818995-484416968115648-456406324721685-463500567750000-512740035296423-456620868587520-470744471936659-569198134605384-456835479676875-485024387440704-456978591088045-464081698892592-513382868677567-457193314240000-471334592908827-569911638921768-457408104643555-485632314323136-457551335613125-577308967836272-471777507141021-612702503337984-507143505874248-570625739253000-486164666867559-493287716351360-584989820849511-465245418001584-514670146859375-352568954188800-592408513051572-571340435847912-458554789702035-486849691608000-522210326698834-635220008691120-367073408077324-529515601612800-501353163120375-614430227396472-494446454054210-551040769708416-501666819227099-480544750012000-523027514480454-572592590396928-473700008597819-353562727669200-636512385588750-551730288839808-608413085220078-360859495909992-360915889017549-502530048000000-502608572409671-601808505984680-460278408097755-488679569514816-502922751848875-538423945130016-354281613137150-460638038049280-474885678404043-574205189841000-460853905910515-489290546192832-460997855278805-468163223374704-517897752726375-461213835530240-475479254517971-574922871486792-461429883229835-489902031912000-461573952505965-468748244517168-518544888907391-461790112642560-476073325046875-575641150889256-462006340255395-490514026884288-462150529489285-469333752822000-519192563947543-462366869585920-476667890196579-576360028297224-462583277186875-491126531321664-462727586428445-469919748491952-519840778071087-462944106560000-477262950172907-577079503959528-520165087359211-470359565199744-363516327687375-527537290121264-534749518666725-356555249049600-499255154667430-584932906250000-520814110528323-563708586749632-471019804680282-599573167121376-378361064337875-492660022715904-592712359710219-557093575077936-585753715260278-535833808200000-600227348832804-357333834636400-600414345253548-464678699663360-614901413377750-572090393047680-586483967587366-493581647961408-465040617737085-472268608878000-543909127002836-493889111603712-479648142460939-386642262752496-472636323843750-572981684526080-372496061960516-601818056527968-523089942788647-580505190912000-594931215098403-595023787382744-587946292531334-552181806969408-573784637930000-487792816064608-365901523318053-466417620231680-516727572088968-373250180628000-617394383488706-552869312771776-466780440539205-531494215549616-574677687790000-466998223011840-596413524219059-646814006243280-618162804559314-553557389000000-553643438648377-546538205042208-359620496556350-553901641097728-510819851631375-597248404083128-467797338283795-496662032161728-467942729840885-475215674406000-525699000937863-468160873656320-482640791118899-583581747422664-468379085256875-497279642908224-468524597320845-475806554878512-526352618229407-468742921920000-483240810681787-584307219314088-468961314332355-497897765451456-469106946953125-476397924946416-527006777071159-469325452410880-483841327335363-585033292197000-469544025709915-498516400003392-469689778937405-476989784812464-527661477687375-469908465328640-484442341285451-585759966320232-470127219589235-499135546776000-470273093473365-593359621874416-484893428222669-615258718064640-492283313226500-593727825166352-644511842448147-557697838558784-601248029740567-608586331500000-528972505140223-471075939243520-601620993098091-601714258030712-565554066782250-572893548531264-478694112091338-369957326766312-645711864189831-471660400640000-486248368973027-587943598620168-471879698234555-500996062537536-472025934388125-479362126313136-530285702381999-472245345262080-486851374167403-588672680193000-472464824117715-501617260312512-472611181127605-479956438211184-530943115234375-472830773309440-487454877687411-589402364250312-473050433501035-502238971368000-473196911417165-480551241123888-531601071206751-473416684981760-488058879738875-590132651040936-473636526584195-502861195915968-546672837065175-648818812691000-576006932484209-634434892333056-634533046356759-590863540813704-627433644719250-561858883057472-605733774553159-613126590114528-649722693059711-474589960000000-489268380259467-591595033817448-474810164648755-504107186337216-474957005583125-482338597977456-533578200086439-475177323745280-489873879140243-592327130301000-475397710029515-504730952634432-475544672069805-482935366976304-534238330781375-475765171914240-490479877375771-593059830513192-475985739908835-505355233272000-476132823104965-483532628003568-534899005717591-476353504706560-491086375171875-593793134702856-476574254486395-505980028461888-476721458888285-484130381262000-535560225119343-476942322321920-491693372734379-594527043118824-535891039064875-484579019354496-389191703382009-499417373225696-536221989210887-477531624960000-492300870269107-595261556009928-477752738534955-507231163346496-477900185498125-485327365283376-536884298216479-478121412820480-492908867981883-595996673625000-478342708405315-507857503465152-478490276724005-485926596451824-537547152360375-478711686103040-493517366078531-596732396212872-478933163772635-508484358984000-479080853496765-486526320662448-538210551866831-479302445007360-494126364764875-597468724022376-479524104836595-509111730115008-479671916016085-487126538118000-538874496960103-479893689733120-494735864246739-516967851989680-568752245359375-531902209116672-495040801850311-605964157874864-591275603139120-495269587264000-502739086591588-628520638094280-391961455034111-517764658033280-384684399274500-488328453574896-666004962087270-555089581670400-525565701728999-370173667450000-547941361095054-585054466735552-592551409292560-503746217193312-385276981043500-481670340835840-652207888329624-370629686699600-578271276062922-585775125000000-482041027552565-489532344444528-393169782155931-400649702547456-526861195096375-653111501347008-489908965711638-512256327371328-623712305095236-564397914676000-371371516491550-482857207672320-497790880792699-616761128405752-520239959111250-572351932467392-594742772913040-505609067268576-379265089143309-386761097216000-647180520525207-379439991057048-394380590059351-580498363366272-513596692640625-506231036323168-543537407881359-513833470130688-655424525614232-655525215576000-491719436887206-514149286636992-514228260978153-566483340563104-670938565983750-663585589776384-648773171182311-633956182454120-522161730147330-574466097128000-529783835176891-507476504229984-544874591208511-544958237906432-649570475415375-604865344050216-395836837757119-582641739778176-575260249113473-627652945500000-381133482598701-590473833644032-657843931833176-657944869424832-613179057067750-545962666107968-403924752091422-553611426194288-576143498228683-606165996096000-531412184539151-404234637065712-546549152117931-516680478591936-486802627163125-494367694490736-546884475480199-487026593198080-502088994999603-607096173933000-487250627916715-517314571970112-487400022558605-494974342580784-547555533609375-487624171773440-502705023553211-607841000972712-487848389700035-517949183928000-487997906496165-495581486754288-548227140464951-488222238965760-503321555783875-608586436966536-488446640175195-518584314677568-488596279175485-496189127214000-548899296271183-488820794974720-503938591897419-609332482163304-489045379541875-519219964430784-489195140796245-496797264162672-549572001252327-489419840000000-504556132099667-610079136811848-489644607999755-519856133399616-489794491558125-497405897803056-550245255632639-490019374241280-505174176596443-610826401161000-490244325748515-520492821796032-565839613454775-550834804070712-603746914670000-490619397898240-626579048123379-634225174550688-589013439585402-596656121112000-589193593564758-513734494029664-559149487645158-491219911170560-506411779296875-612322759956456-491445229917395-521767757719488-491595480687285-499234780902000-552268317411143-491820914257920-507031337912179-613071854900424-492046416736875-522406005670464-492196790010445-499845403336752-552943771630687-492422407360000-507651401645307-613821560540328-492648093645955-523044773896896-492798589473125-500456523476976-553619776370679-493024390676480-508271970702083-614571877125000-493250260844315-523684062610752-493400879275005-501068141525424-554296331855375-493626864407040-508893045288331-615322804903272-493852918531635-524323872024000-494003659615765-501680257684848-554973438309031-494229828751360-509514625609875-532409927020720-585740263875151-608654147650560-494606930695085-563176856662000-685049296383990-540510202423808-548206615743624-662517346520088-655002072781250-586544770178752-495210692712645-563864286377648-419152216111145-495437230080000-510759304282147-617579257888008-495663836524155-526246426579776-495814945868125-503519596856496-557008065726319-496041667463680-511382403044523-618332632929000-496268458164115-526888320910272-496419690361205-504133707487344-557687378298375-496646596259840-512006008365491-619086620407752-496873571291435-527530737000000-497024926391565-504748317242928-558367242960671-497252016668160-512630120450875-619841220573096-497479176105795-528173675060928-497630654158885-505363426326000-559047659937463-497857928888320-513254739506499-620596433673864-559388075613875-505825085943936-390924316415463-628640619167024-559728629453007-398771466496000-644267294358324-682720384399272-498691861594355-598521263763072-613961336250000-506595143285616-614148111486640-575851418726400-545222245581719-691231888530000-660610908760626-606932525102272-591657089549449-584062016956704-384309744518750-515053345137152-545885768347263-522899644558496-507597385707654-530750651256000-515444901563407-507828859988208-561774855474711-400229199904768-515758289547875-623623420407816-654519069386455-593007356248384-600800011246422-585483812500000-685736511335839-400715899324416-670530355957599-639798534064312-632186117097750-601439095390848-570682715740882-647900372071008-694284377623110-563227278848000-517013111741427-625140597856968-686987157687283-540409003102080-501884533938125-633242748861872-563826062418399-502113101934080-517641285351803-641354432139000-540983411570770-595172053448896-618454403433360-525766005144032-394384331578125-402178364669952-672977420587671-394563851046552-410099142305367-603633681456000-534064633801329-642523009620744-619393209734960-518820481914368-526643922190500-658404726570760-635263223065046-557876672054784-519213945026623-511542024774000-565882256338983-659003881492480-527283020777476-628182330872904-504173337516875-535280504453184-504326171347245-512162639841072-566568763576127-504555480000000-520159068019867-628944302686248-504784858150755-535929722702016-504937815533125-512783756668656-567255825818839-505167309537280-520789786772643-629706890421000-505396873067515-536579465677632-505549954051805-513405375459504-567943443291375-505779633482240-521421015171371-630470094325992-506009382466835-537229733592000-506162587102965-514027496416368-568631616217991-506392452034560-522052753421875-631233914650056-506622386548395-537880526657088-506775714886285-514650119742000-569320344822943-507005765393920-522685001729979-631998351642024-507235885511875-538531845084864-507389337601445-515273245639152-570009629330487-507619573760000-523317760301507-546832572698160-570354480117811-539183689087296-422033639910750-640962783234352-601970673798571-633337600983552-680354321683263-688278503000000-633624828916131-563307191870976-657291042532068-399129868241064-407017439471500-587133088051200-681177289373991-642126172090384-610895224428762-603154340712000-673754665396766-399612540608328-666121503334995-509463970895360-525219099654875-642902546219472-509694834178595-541142376662208-619662365540811-517770778998000-572772330871703-588553570713600-682825215170679-682928298687288-549565488281250-604613290309952-620411164451507-596941333035552-707010901959510-699260742208000-683650173811167-668034872742280-707437776454830-605343646531008-542532646559625-519022566378096-574157022888519-409050264223744-527125038788723-637366698189000-574503544242883-543105802039872-511698571472205-519649215952944-708719430813750-527681804954112-685302083912751-693283639733696-646111704435318-614686722000000-622661180086379-402031740239208-417860672248331-425809012064256-559944385626375-528477865070872-710002632207870-568087708414464-654977576833607-520904027886000-394683727751550-702642892308992-536931636741796-647573936163408-513398137581875-545073970943424-434544702251715-521532190649712-576933098384807-513784926720000-529673455786387-640447929801288-514017093425355-545731082350656-514171910078125-522160858215216-577628512621759-514404193338880-530311840839963-641219786217000-514636546546915-546388721664192-514791487550405-522790030785264-578324485452375-515023957360640-530950738626851-641992262535432-515256497146235-547046889096000-515411562550365-523419708562608-579021017100911-515644218984960-531590149352875-642765359005416-515876945422995-547705584858048-516032135277685-524049891750000-579718107791623-516264978411520-532230073223859-643539075875784-516497891576875-548364809162304-516653205932045-524680580550192-580415757748767-516886235840000-532870510445627-644313413395368-517119335807555-549024562220736-517274774713125-652660084297072-533351175372221-660817896800256-533511461224003-653052425786000-581463281799603-613416420389696-701152647387896-669382605563616-581812736359375-518130245501440-534152925764811-693705725553624-550263025100991-614153847384000-678063840516985-606359876996768-710185942822743-582599520980992-566722958260375-662606575852248-518986658957195-551006996040768-614984158917513-591112443926000-599190364445325-599280287961600-695269455750159-695373787901208-559580104991250-615630473915072-631715642657867-607817618239392-719892005399910-712000000000000-696104405220087-680204020400680-720324048602430-616369673924928-552414103508625-528475342574256-584613414645039-416499399706624-536723925668843-648972486081000-584964130077163-633138282696512-593155150522578-545143199866592-721621215303750-633518013763584-705796726352344-705902511233216-722053950017310-625873872624000-553740626379009-529744317342768-602072381412525-537931916446208-690583226343750-722811651981840-722919938371470-626624470832256-723136543595010-666992484241000-409900142179341-538576918675456-699450887706519-554819988551976-723786618858750-627375668919168-530935824583098-539061008556424-603516848948925-635799589056000-708338481745048-668191990869304-660240303599574-628127467124352-596004997743250-676647472816224-725087937944070-523752992788480-668892366744867-435248106750000-523988152522315-556316804261952-580591345599144-411313730990664-419441446651500-403369416780800-572870253888703-669793568914296-524615589249635-556982918904000-524772526653765-532925637969648-589536202473431-525007991439360-541243002899875-654436393447176-525243526649595-557649565055808-525400589253085-533563426638000-590241705707503-525636241861120-541890648644139-655219446183144-525871964921875-558316742929344-526029152774645-534201723960432-590947771571847-526264993280000-542538810826547-656003123300808-526500904266155-558984452736576-526658217418125-534840530139696-591654400290719-526894245895680-543187489652923-656787425049000-527130344882115-559652694689472-527287783383205-535479845378544-592361592088375-527523999907840-543836685329091-657572351676552-527760286969435-560321469000000-609135981772575-722949251807512-438708832167258-528154255516160-674513000582875-690869404836360-560907083387967-626033184677824-691178703177465-618087277156000-723920715859159-593866245279744-577682098385687-675419243048152-529021676356875-569800624462720-529179491204845-667679840808624-732928621064310-676023855424000-578371696440831-659930883323688-529653124056355-562330988197056-529811064453125-538042200984816-595195994551959-530048033914880-546438640648163-660718311957000-530285074025915-563001894057792-530443140021405-538684064562864-595906005107375-530680297904640-547090423660651-661506366713832-530917526465235-563673333336000-531075718109365-539326438417008-596616580087111-531313064488960-547742724757875-662295047843016-531550481573995-564345306243648-531708798916685-539969322750000-597327719715423-531946333867520-548395544145659-663084355593384-532183939551875-565017812992704-614241210741975-729008058803768-647193349494641-680063827968000-680165032962323-696658205779880-696761870013495-623079780991744-549375745472375-672470350612272-426508055868076-549620978169344-582520812563439-418492684563000-607315000055614-566364428862912-418679446803567-550111662477608-706218485906250-583127544836096-706428534530038-591516480942144-542304060892374-616346237400000-452054437435755-550766362394056-608399544668038-534484443317760-551012008718875-715599550952472-600534841581819-567713182642368-658316000901520-674874174438000-600891895434583-666842132348928-683408896711731-683510433294872-675375691019750-634288461694272-659098894829840-560317280162656-420300380970549-535756520000000-593541517003272-428732537085216-709162957866722-635042519624128-602142698404125-544483823519856-429050950106636-445619061301248-585993529242359-734664318229000-437561674658343-627540068777728-743249862323730-627726374586144-735209726015375-570078651201024-594952960198536-743801562020880-578598171442130-636552427896000-537429181500965-611933230597552-661647586365360-537668416962560-686663057921875-686764916563608-711693295589138-645585009603456-546345258953274-695451638028000-422301113305941-621123144537600-588083769242927-720716541042648-579972853451250-646351282531968-588432625095763-563652824246496-613477827482006-538945538560000-555610823453907-671808169011528-539185223778955-572450681388096-539345053398125-547723825897776-605905519473279-539584857044480-556269878382683-672605015625000-539824731761315-573129610767552-539984687728005-548373364906224-606624019940375-540224680919040-556929454277731-673402492094472-540464745208635-573809076744000-540624827572765-549023417232048-607343088195631-540865010383360-557589551344875-674200598668776-541105264320595-574489079529408-541265473132085-549673983078000-608062724463303-541505845637120-558250169789939-674999335596744-608422755671875-550162244582016-425188274690583-617031130846448-625461913322925-417036297600000-725750506779567-675798703127208-717620808446082-642615994505408-692792421877375-567672918448608-442516386334859-592892637478912-601332148624968-693304842287000-543029857641115-576532310859072-643471759219289-618492856341616-752332245513750-593594285497856-602043749141256-727577059212504-585493355362930-644137879000000-594033096493971-569017185285344-610946954143271-744963201847296-694843619427875-661454898196664-619682206708782-577897153009728-695254344181207-636712480116000-745733967280559-645280867872256-603468633909384-687385230969808-645566826202375-637276941501696-712849201576105-419384979871600-713059740349515-453069545472000-579007671995109-612663773116104-444876352228151-638030075489024-579349656140625-554242339594416-629913802933725-596406413256192-604895765132808-420128496850000-756342893222190-655593902680704-588440318622590-571712082139872-445664868054875-437320608038912-731778959909511-740299406393536-656271269021082-647953098408000-462891908150155-563969675393096-446191062561171-631495565068800-732642883035375-707483648065824-446454315061919-640293037198592-589830539798430-573062715500000-429860400481101-699679861899264-598609557415367-708318519036576-556618011765750-615743997295168-548346008554045-624362843480688-675086330262320-548588472640000-700608503388123-683827116312168-692371425716054-667139041094976-557438780390250-574415474376928-760367769377670-616833595150336-566218333528403-684633436893000-549478119112715-583378061800512-549639976282605-558178161659184-617469787109375-549882821629440-566885748616411-685440391062312-550125738496035-584065602168000-550287722812165-558835938075888-618197399097751-550530758901760-567553687963875-686247979068936-550773866539195-584753682523968-550935978051485-559494231054000-618925582462383-551179204958720-568222151776619-687056201161704-551422503441875-585442303080384-551584742200245-560153040796272-619654337427527-551828160000000-568891140260467-687865057589448-552071649403755-586131464049216-637193094759375-620292467089368-467412349752865-552477624225280-569560653621243-688674548601000-552721304624515-586821165642432-552883798024805-561472211384304-621113563056375-553127597834240-570230692064771-689484674445192-553371469303835-587511408072000-553534090099965-562132572635568-621844034168591-553778081026560-570901255796875-690295435370856-554022143641395-588202191549888-554184891883285-562793451462000-622575077778343-554429074001920-571572345023379-691106831626824-554673327836875-588893516288064-554836203574445-563454848066352-623306694109887-555080576960000-572243959950107-691918863461928-623672717116411-563951235433344-435844450677375-632494552063664-641135839096725-624130447343616-615671033677128-444716538500000-735600638271186-658715795076416-727260467472545-718809885079776-436484300515125-462227632856064-744809295407391-702107116776784-702210080131478-590970740184000-625321593949213-633980588583472-771170525356230-625596688986112-754254515927000-694358774930376-737328498130418-660262983628864-711816368201847-437445248973000-763496730292879-463313098478592-600679069467190-429119352821200-566520548343750-686792192814080-601031218993310-583944441363936-455199847198667-446676598784000-747433786183767-756135724974784-670309381449786-661812592972608-472792517126875-644811491344200-438536027706453-576200325236224-748309984544703-714009462867000-636679959077054-679798391903552-731535734868345-438985698402984-447658784943500-559655393955840-714741494188259-465080602283568-559901180247435-594443625000000-672078093297078-654941152696608-767082794513903-646512673804800-612121550421375-776042254279440-707164167635126-681391979984448-724624045507236-586686228268000-638546051269494-560967085752320-578312184761699-699255792096264-561213255906875-595836579618624-561377409346845-570097336500912-630654406460207-561623699520000-578989068010987-700074193408488-561870061718355-596533872209856-562034343203125-570764442044016-631392337532359-562280825466880-579666479224563-700893233037000-562527379783915-597231708604992-562691789363405-571432067798064-632130844017375-562938463792640-580344418608251-701712911230632-563185210303235-597930089016000-563349748027365-572100213965808-632869926139511-563596614696960-581022886367875-702533228238216-563843553475995-598629013654848-564008219394685-572768880750000-633609584123023-564255278379520-581701882709259-607836949402480-668718238948375-694873603169280-564667203665045-642945713002288-651729265265925-721352304128000-582381407838227-712869307834896-739057710451495-669597017793088-739273378280625-661093803793696-774288574559407-652585551782400-617871101480639-783331127370000-678985993094058-670378800572096-478911832988435-583486764508008-461631463296875-705615110701056-766705969922904-723248565665816-714638902292198-688593949848000-688694332852339-444664949445768-444729766259637-619223840105984-758877832041375-697920399204480-750373770572258-680670739122816-576036093366954-663410944804000-785732695656390-602482836713472-628769337685704-436708987229200-681365267300250-690201248830144-585445820183591-576791825754672-655540723634925-725570728000000-612016239926070-655827180540600-647177048920798-691005835400256-717351001500250-446222291955816-726310638849069-743920390635520-744028691754965-752891556366000-717977843448742-648025537708672-709428495398157-446742213012744-735917793103500-709738289496576-587152907082571-709944868991592-780176388462651-675082279256000-648874767786514-596350050365664-640292456738791-570206359490560-587836669921875-710771587824456-570455225072395-605648239207488-570621175682285-579484227102000-641037885670143-570870161937920-588520963401179-711598948208424-571119220611875-606353164342464-571285299965445-580158634048752-641783892929687-571534479360000-589205787726307-712426950392328-571783731200955-607058636248896-571949939348125-580833564044976-642530478741679-572199311956480-589891143103083-713255594625000-572448757039315-607764655138752-572615094030005-581509017293424-643277643330375-572864659927040-590577029737331-617110391121840-678920014940783-634926491712000-467444315433393-661573856814600-776359370533736-573530523471360-741285516688500-794349789146640-573780355262595-609178334716608-476817466228686-653511372462000-706601325736880-574196902789120-591950397601539-724581744845968-715849248796875-698275270586304-760258062471038-450916127993352-450981550848789-663304382400000-769544708867967-769656344947416-619353556639090-690236927133312-752290368125625-743547721463904-646272093937319-770326388158464-619892723993830-717408455229000-788377913144019-637881351399936-469619630885521-584894139415344-647022155773375-611657545833984-594014438974491-789178335446888-727213522552118-700709697000000-754037425228585-603317364811744-443679998446350-612367125282816-736722267917875-692441728353648-585997125994038-612722120708928-470709814823937-586251858126000-648524020036463-648617963641344-639825451710984-462163091225888-764457356225250-684555134470592-755787185054105-747003733243488-453603657102909-480355771392000-774018578086407-729640379377936-729746017191494-614143474376256-578624707578125-587611676333616-650028206582559-578876016442880-596773949992763-721577404377000-579127398062915-614854974758592-579295026234405-588292373255664-650781171272375-579546529136640-597465160522051-722413127569032-579798104822235-615567024456000-579965862386365-588973595660208-651534717205711-580217559400960-598156904572875-723249495795816-580469329226995-616279623680448-580637216233685-589655343750000-652288844606823-580889107435520-598849182351059-724086509306184-581141071476875-616992772643904-581309087976045-590337617727792-653043553699967-760503072960000-581645218120265-474333097808584-653421126451131-617706471558336-635702844995875-752207804468064-653798844709399-582233757614080-743575122578547-743682534239000-698983332372858-708046912032192-591618299574522-457225620486024-798018765609375-582906860157440-600929220108011-726601424027112-583159407294035-619135520088000-583327812570165-592387597016688-655311173374151-583580481269760-601623634853875-727441021160136-583833222921195-619850870127168-584001757889485-593071976574000-656068211477983-584254621150720-602318584356219-728281264820904-584507557391875-620566770965184-584676222102245-593756883033072-656825832395127-584929280000000-603014068820867-729122155258248-585182410905755-621283222814016-675405237009375-801596457228824-711632039337497-783809043807744-783922055156223-729963692721000-775134913768866-694116194104256-748311027147151-757435989504096-802637141060375-586280155402240-604406643460371-730805877457992-586533675861835-622717780392000-586702730097965-595814765848368-659102194268991-586956372354560-605103734046875-731648709718056-587210087703395-623435886545088-587379271881285-596501781942000-659862148681943-587633109073920-605801360418979-732492189750024-587887019386875-624154544556864-588056333556445-597189325951152-660622687029487-588310365760000-606499522782507-733336317802728-588564471111955-624873754639296-588733915323125-597877398078576-661383809535879-588988142612480-607198221343283-734181094125000-661764589918723-598393798873728-480597491095281-616704362118752-662145516425375-589666439831040-607897456307131-735026518965672-589920935485635-626313831864000-590090639929765-599255127499248-662907807922231-590345257615360-608597227879875-735872592573576-590599948533595-627034699430208-590769783169085-599944785198000-663670684250703-591024596165120-609297536267339-736719315197544-591279482421875-627756119914944-591449447298645-600634971826032-664434145635047-591704455680000-609998381675347-737566687086408-591959537350155-628478093530176-592129632518125-601325687586096-665198192299519-592384836359680-610699764309723-638136167830000-702050596013767-656557169204736-611050657151119-747960431512688-729822273390000-611313914970112-620527082650564-775770213217320-483784987533047-639053030000000-474793253620452-675764308199792-821993476889430-630285448905216-803957679151000-456859691870800-749357416776726-712905683358336-676443468257746-694825407396000-813793867304759-704169865670656-631099888006293-740962672267464-667876967943875-631371523535424-594855588288845-604093846001712-668260236243807-595111574720000-613510671227387-741813294213288-595367634580355-632096265982656-595538381953125-604787210463216-669027212672759-595794564218880-614214743080963-742664566917000-596050819941915-632821562832192-596221697905405-605481105273264-669794775727375-596478076080640-614919353395851-743516490627432-596734527741235-633547414296000-596905536345365-606175530634608-670562925631911-597162110504960-615624502377875-744369065593416-597418758177995-634273820586048-597589897472685-606870486750000-671331662610623-597846667691520-616330190232859-745222292063784-598103511451875-635000781914304-598274781487045-607565973822192-672100986887767-598531747840000-617036417166627-746076170287368-598788787762555-635728298492736-598960188588125-608261992053936-672870898687599-599217351150080-617743183385003-746930700513000-673256074978603-608784354423168-728800667678043-608958541647984-673641398234375-461464213708800-646142302038310-757017807470864-674026868482947-729530650168000-609568458585306-775925338118112-489641941710611-637549520549376-767017041244875-720914246929968-757992554873846-693384980270400-776702188220196-462388814950000-776924240590764-601277302046720-795649819452502-740245141422720-758859699139750-638643921547584-601707051853245-611051380631472-675956425598927-601965000000000-620575645221067-750355346412648-602223021856755-639374217556416-602395077383125-611750057702256-676729278376039-602653222113280-621285110949843-751213140381000-602911440581515-640105070087232-603083627197805-612449267149104-677502720021375-603341968586240-621995117198171-752071587844392-603600383740835-640836479352000-603772701496965-613149009174768-678276750759191-604031239618560-622705664171875-752930689051656-604289851534395-641568445562688-604462300480285-613849283982000-679051370813743-604721035409920-623416752076779-753790444251624-604979844161875-642300968931264-605152424347445-614550091773552-679826580409287-605411356160000-624128381118707-754650853693128-605670361822955-643034049669696-605843073298125-615251432752176-680602379770079-606102202068480-624840551503483-755511917625000-680990500682523-615777788512128-737172393154283-615953307120624-681378769120375-644134716309504-625553263436931-756373636296072-644410079078151-747248561280000-775380824948423-476506688926728-476574564149397-682252912640512-822559007567000-766584602670672-804093473267618-720046683235264-776264743535247-710897847268000-467762547045550-683030556463104-664411973237207-758099038851144-645880005984375-720867249177152-608610923929645-692978754724848-842931960843510-683808790976000-824434764950808-758962723232808-805926947775682-721688438294208-778034595497375-478137473786856-759502858945743-487651452780544-787856725149396-834871711581000-609824504677115-731893500833664-487998403950564-769645398883888-685269573563375-610258317027840-629124953538091-497736779639176-610518703164435-648181239000000-610692335064565-620175765871728-686049507560071-610952844636160-629840919085875-761557711780296-611213428282795-648918786328128-611387191871885-620881379646000-686830033116063-611647899000320-630557427623099-762424020593064-611908680231875-649656892933824-612082575559845-621587528432112-687611150455607-612343480320000-631274479355587-763290986135688-612604459211355-650395559029056-612778486328125-622294212432816-688392859802959-613039588794880-631992074489163-764158608657000-613300765420915-651134784825792-613474924376405-623001431850864-689175161382375-613736224624640-632710213229651-765026888405832-613997599060235-651874570536000-614171889904365-623709186889008-689958055418111-614433388008960-633428895782875-765895825631016-690349724677179-624240354790272-633788441053583-775791411750000-756977032476080-652985299402752-643613019703236-804630379622440-501781861840375-662824747509120-492453923358436-852444960868080-492593593579308-672675079616000-833856337272728-786589640752824-739309519864266-729934656138688-644708997364500-720659253774496-502636241216539-673438326607872-664047381886630-768506584653000-692702853374403-654839316750912-616965030806605-626545567297584-693095560609375-617227321085440-636309068239611-769378154271912-617489685692035-655581905208000-617664636728165-627256003477488-693881420290551-617927125237760-637030472943875-770250382611336-618189688103195-656325054850368-618364771327485-627966976494000-694667873773583-618627458142720-637752422695819-771123269920104-618890219341875-657068765889984-619065434804245-628678486549872-695454921282727-619328320000000-638474917701267-771996816447048-619591279607755-657813038538816-619766627358125-629390533847856-696242563042239-620029711009280-639197958166043-772871022441000-620292869100515-658557873008832-620468349188805-630103118590704-697030799276375-620731631370240-639921544295971-773745888150792-620994988019835-659303269512000-621170600495965-630816240981168-697819630209391-621434081282560-640645676296875-774621413825256-698214268758059-631351435727232-755815340567131-631529901222000-698609056065543-478566969958400-670088429943590-785071644154128-699003992159875-756563249388224-632154795297498-804674308474848-507782891570707-661169221056000-795431836343243-747619836950064-786070321744374-719068297108800-805470227614500-479514269746800-805697729442732-623544610324480-825113971107414-767656250000000-786958745852582-662290480095552-623984904483005-633674111074224-700980905415375-624249180439040-643547667126731-778130121146472-624513531003635-663038689944000-624689806167765-634389924744048-701772713206631-624954281103360-644274531569875-779008950376776-625218830675595-663787463097408-625395238527085-635106277278000-702565117042303-625659912517120-645001943118939-779888441064744-625924661171875-664536799767744-626101201760645-635823168878832-703358117146647-626366074880000-645729901979747-780768593459208-626631022692155-665286700166976-626807696068125-636540599749296-704151713743919-627072768391680-646458408358123-781649407809000-627337915436115-666037164507072-627514721649205-637258570092144-704945907058375-627779993251840-647187462459891-782530884362952-628045339603435-666788193000000-628222278703565-637977080110128-705740697314271-628487749660160-647917064490875-783413023369896-706138316365339-638516316907392-764392292723691-638696130006000-706536084735863-667915793989632-648647214656899-784295825078664-668197892730375-774831238599680-804000553947079-494093965441032-494163500642709-707431609664000-852914274006168-794872861216336-833764446572962-746615061517248-804906087359375-737126130582176-485019624639150-708228266807296-688921647394519-786063417597000-669703760930679-747455686390336-631057825647405-718536099290096-874018149333750-709025521817088-854835882538264-786948208904232-835642734384834-748296942008000-806719193450143-495764611418088-787501540489167-505627609530368-661298275426500-875370737676240-632301055679995-758867904302976-505983034520548-798008450750000-710521987178223-632745461803520-808080808380091-535550469842520-633012205401875-672061206535104-633190076109045-643021778170992-711320962303367-633456944640000-653039638015027-789606566004168-633723888144555-672816755881536-633901892138125-643744612889136-712120536163999-634168960622080-653773630889403-790494013593000-634436104107715-673572871288512-634614241437605-644467989107184-712920708984375-634881509949440-654508173545411-791382125874312-635148853491035-674329552968000-635327124207165-645191907027888-713721480988751-635594592821760-655243266188875-792270903096936-635862136494195-675086801131968-636040540646485-645916366854000-714522852401383-636308209438720-655978909025619-793160345509704-636575953316875-675844615992384-636754490955245-646641368788272-715324823446527-637022360000000-656715102261467-794050453361448-715726033901371-647185476119424-725733910379250-882773063227440-765177215879154-775095792795648-824267986158036-500518550271000-638005189219515-696995626263488-638183993979805-648092999792304-746393465276500-795609744062976-697484014828623-491254732331600-687852963214130-756744241176000-796167127918341-668480830154464-727566313833558-796501683154944-658926986421875-885249746709840-688623990703810-767431313590656-678976597024641-501922528557000-492149800299550-492218696678400-699048391271327-640063461342760-650001560199750-679642198160064-522117071524009-650274517178352-719343681008887-778576756736000-857539953013527-887234425459920-847920407776402-769151689517952-680498610032625-651002776019376-720149254558479-641318487380480-661143831583883-799405088625000-641587634795315-681165205321152-641767108234005-651731578387824-720955429310375-642036381143040-661883883376531-800299861516872-642305729362635-681927561384000-642485336686765-652460924486448-721762205488831-642754810447360-662624487214875-801195301838376-643024359546595-682690486051008-643204100806085-653190814518000-722569583318103-643473775493120-663365643304739-802091409838344-643743525546875-683453979534144-643923400791645-653921248685232-723377563022447-644193276480000-664107351851947-802988185765608-644463227563155-684218042045376-644643236843125-654652227190896-724186144826119-843348179333120-803773412806689-525999239297000-655109365268886-684982673796672-695006963710990-506432897910984-516435028843500-884021783842304-864276733751151-824654945913336-655841228756934-685747875000000-526807376168553-675998115544544-725805115628471-646354997084160-666335794295875-805682523599496-646625551704795-686513645867328-646805963389885-656848430766000-726615505075663-647076643832320-667079714730699-806581973724264-647347399781875-687279986610624-647527945701845-657581588652912-727426497519207-647798827520000-667824188651987-807482093020488-648069784873355-688046897441856-648250465078125-658315291892016-728238093183359-648521548346880-668569216265563-808382881737000-648792707178915-688814378572992-648973521718405-659049540686064-729050292292375-649244806512640-669314797777251-699381528501040-769426843864063-719564275008000-669687796309207-819732052871216-799849967200560-669967636131328-680061842846500-850195676743560-530195826219119-700356140301440-520336998071748-820645657750000-730676501742023-650692935659520-670807623318259-811089266896584-650964699376875-691120245885504-651145917220045-661255562425392-731490512531167-651417807040000-671554867759227-811992735782568-651689772535555-691890010335936-651871124913125-661991995466736-732305127662199-652143216558080-672302666921603-812896875333000-652415383906715-692660346146112-652596870868605-662728975076784-733120347359375-652869164413440-673051021011211-813801685796712-653141533690035-693431253528000-653323155286165-663466501458288-733936171846951-653595650805760-673799930233875-814707167422536-653868222085195-694202732693568-654049978365485-664204574814000-734752601349183-654322675934720-674549394795419-815613320459304-654595449291875-694974783854784-654777340306245-664943195346672-735569636090327-856604160000000-655141223412065-887083614490304-655323215509755-695747407223616-534488889066625-837146002280328-736387276294639-696133933552128-887946256518552-817427641761000-908379028991790-797465617941312-676425487157599-908757380118960-878587403153625-737307845521408-868729799121718-747615431836368-535528605941927-747822949072000-818676547150941-505426016692400-889673217960296-738126773079552-677552810546875-819244651692456-657509750227395-698068712695488-657692180677285-667903153302000-738843831929143-657965889617920-678305054890179-820154165516424-658239674486875-698843627014464-658422239920445-668644512760752-739663896228687-658696151360000-679057855807307-821064352244328-658970138755955-699619114600896-659152839223125-669386420612976-740484567112679-659426953236480-679811213504083-821975212125000-659701143234315-700395175666752-659883978785005-670128877061424-741305844805375-660158295447040-680565128186331-822886745407272-660432688121635-701171810424000-660615658805765-670871882308848-742127729531031-660890178191360-681319600059875-823798952339976-661164773617595-701949019084608-661347879485085-671615436558000-742950221513903-661622601669120-682074629330539-712713929901680-906290286046875-712911248264320-662080641022645-835355792135664-743773320978247-662355566080000-845894148432003-917361542391120-835933946356934-805462428378816-856559557906500-775089676641056-509997964485150-826310996946432-897844772507672-846948003147000-673569879996486-704284090606272-918758474960130-694269073990112-919012614963750-684248445222912-888624575100951-847885497392536-756050629237326-807246727000000-786918881602777-776806533631008-909807092037503-664557706908160-848706372142875-531793150918432-756887161137982-808139863626048-818482584306320-695806342348000-542394593166843-726704483545088-890591918126439-849762560814552-757724309864750-809033658785984-757933693452162-696575826759776-840104533512638-532822807296000-860832654222324-912198670055272-666304525904355-799675858131072-533190863562500-840917088504432-748724687433559-666764723322880-687375458633763-831120889077000-667040943457915-708187374326592-667225132589405-677583658943664-749552045547375-667501479856640-688134954491051-832039170061032-667777903417235-708969757656000-667962228181365-678332163332208-750380012936711-668238778920960-688895009597875-832958127183816-668515405981995-709752717008448-668699866428685-679081218750000-751208589825823-668976620715520-689655624160059-833877760694184-669253451351875-710536252595904-669438047531045-679830825399792-752037776438967-669715005440000-690416798383427-834798070840968-669992039726555-711320364630336-670176771688125-680580983484336-752867573000399-670453933294080-691178532473803-835719057873000-670731171305715-712105053323712-670916039099605-681331693206384-753697979734375-877714452008960-836525476979073-557760481359408-671470846289035-712890318888000-743988018422952-527064101412168-537472710095724-516871860915200-734059124725375-858243633059448-672211064876195-713676161535168-672396204484485-682834768374000-755360624616983-672673977630720-693467096005219-838486082768904-672951827266875-714462581477184-673137102857245-683587134225072-756192863214127-673415080000000-694231071621867-839409779830248-673693133660755-715249578926016-673878545283125-684340052524656-757025712880839-674156726497280-694995608134643-840334155021000-674434984257515-716037154093632-674620531961805-685093523475504-757859173841375-674898917322240-695760705749371-841259208589992-675177379256835-716825307192000-675363063092965-685847547280368-758693246319991-675641652674560-696526364671875-842184940786056-675920318858395-717614038433088-780122467934175-925872561343000-561842578756314-676384932753920-863810217372571-884746480344840-718304652693375-728814990753920-760154345297469-708186261968096-552044534474107-697963488768000-739734553368791-927400263492232-854576035056774-719193236191296-760990100607125-688112937846576-865472989231109-542298502313984-907431699805263-730217713750000-897247800392386-813894620932224-803570384345729-782805880789800-521942230068750-699498598531072-897987121042198-845894660817672-553562599167287-773004803344000-762663448527813-689625966211248-762872789333231-804784458981888-909426693897375-888642248641160-690099242009958-721566374198208-679829694564085-690383311398000-763710535629703-680109511045120-701132117196339-847753599065544-680389404296875-722358578746944-680576042453645-691141210858032-764548895014047-680856063680000-701901711036347-848684088618408-681136161705155-723151362922176-681322936393125-691899664794096-765387867710519-681603162439680-702671867830723-849615258789000-681883465313115-723944726935872-682070376582205-692658673408944-766227453943375-682350807523840-703442587785291-850547109826152-682631315320435-724738671000000-682818363220565-861519627670256-704020997448909-914301737299968-882895002580500-893528019360360-767487984163939-725533195326528-841313103394320-862464017422000-767908467915263-683847737464320-704985717998299-926078163995072-684128655331875-726328300127424-557980719417289-873938476308456-768749896102807-726726070272000-926965900340568-853346750625288-948292817172030-832504273384896-706144545484375-948682170969840-917184913273521-769697237264896-906890669935654-780454546218000-559050672567023-780668096348032-854631969832197-527622760425200-928743074633000-770539971391488-707304642164851-855216586719432-939810928952691-739278216880000-686566500140365-866248477968816-549403412937964-877052268431872-750352103337375-877292096778488-560275149991519-835241271547968-845929562667920-888347449500000-539427527765901-772227284598784-708853413241859-899414542486440-730212755562375-793817976811200-889197620177412-889319117392608-540017522731029-878972119488000-741403062867670-932176893923264-741605641234290-815877638679488-784197299727250-879692785305768-540607947741213-710307437932544-731610546338421-858964449213000-901505535936935-763732491987456-689574866130605-700279311495984-530587061718750-774762870158848-934088223361304-859903122601512-700757448384774-838899924968000-732810071520729-701044434959088-775503460043351-690611017973760-711957734723875-860842479593736-690893784867195-733510399656768-691082339003485-701810115534000-776350426204783-691365234526720-712735228655019-861782520438504-691648207241875-734311320859584-691836898608245-702576353423472-777198008817927-692120000000000-713513288422067-862723245384648-692403178611755-735112824868416-692592007258125-703343148830256-778046208107039-692875314593280-714291914230843-863664654681000-693158699176515-735914911895232-693347665152805-704110501957104-778895024296375-693631178506240-715071106287171-747191017288240-779319663798707-768748781376000-715460914722487-790318220643952-961328783355030-737119136057856-715850864796875-865549527319656-908416431363055-823030497978304-897973736552676-812563076452000-951683715565399-759311744790528-759415141605527-866492991159624-695428558036875-738324673203264-695617936302445-706415909685552-781445176508287-695902068160000-717412081999707-867437140345128-696186277377955-739129094421696-696375793173125-707185495720176-782296462541079-696660131348480-718193541104483-868381975125000-696944546912315-739934099717952-697134200287005-707955640488624-783148366595375-697418744855040-718975567485931-869327495748072-697703366839635-740739689304000-697893157843765-880538791270896-719562459671149-934484278038528-902383366468500-923994301380656-752190640233410-827522195379264-752395178815630-902996954412000-559074103323372-741949169690112-763558715314207-871220595519144-699222658671875-742352622193344-699412725084645-710269429224432-785707789129847-699697889280000-721325052348547-872168175164808-699983130976155-743159965920576-700173335168125-711041810955696-786562167512719-700458706055680-722109349894923-873116441649000-700744154472115-743967894785472-700934496493205-711814752434544-787417165038375-701220074147840-722894215747091-874065395220552-701505729359435-744776409000000-701696209259565-712588253863728-788272781931071-701981993756160-723679650110875-875015036128296-702267855837795-745585508776128-810529008077175-789021954963000-594549260449705-702744465080320-724465653192099-875965364621064-703030534106875-746395194325824-703221289914845-714136937384112-789985874714607-703507488320000-725252225196587-876916380947688-703793764366355-747205465861056-703984658203125-714912119880816-790843351053959-704271063674880-726039366330163-877868085357000-704557546815915-748016323593792-704748578731405-715687863138864-791701447657375-705035191344640-726827076798651-878820478097832-705321881655235-748827767736000-705513051699365-716464167361008-792560164749111-705799871528960-727615356807875-879773559419016-792989756048179-717046763782272-554156645271399-891117646750000-793419502553423-565252083542016-913223184348468-967712744835496-706852209301875-848337513848448-870207576311440-718018459508592-870443245254320-816151027200000-772727574108951-979646431997520-936233314088242-860144696208576-838482363343625-827705000542496-544616466573150-729884836217344-773564727549439-740979157284000-806468791059614-752079412638912-708576471961605-719574997945584-796001242484375-708864121405440-730774176368611-883592775483912-709151848687035-752893792008000-709343710123165-720354110029488-796863065381551-709631567157760-731565307168875-884549303439336-709919502058195-753708759058368-710111501922485-721133784294000-797725510112583-710399566622720-732357008744819-885506521468104-710687709216875-754524314001984-710879847559245-721914020941872-798588576901727-711168120000000-733149281302267-886464429819048-711456470362755-755340457050816-711648747233125-722694820175856-799452265973239-711937227489280-733942125047043-887423028741000-712225785695515-756157188416832-712418201143805-723476182198704-800316577551375-712706889290240-734735540184971-888382318482792-712995655414835-756974508312000-713188209490965-724258107213168-801181511860391-713477105602560-735529526921875-889342299293256-801614212609059-724844920559232-867734508084131-725040595422000-802047069124543-549421443558400-769293820633590-901294366130128-802480081434875-868554525340224-725725734759498-923775550762848-582937016809707-759020384256000-913147685512243-858254544926064-902389301798374-825467392708800-924648173914500-550460047146800-924897595710732-715791083604480-947174373365414-881211250000000-903363322098582-760249677423552-716273791238005-727391441242224-804647480890375-716563519959040-738711193975731-893189138198472-716853326798635-761069943144000-717046574762765-728176184256048-805515532217631-717336511823360-739508041794875-894152578084776-717626527030595-761890798665408-717819913922085-728961491478000-806384207621303-718110059397120-740305462447939-895116710532744-718400283046875-762712244199744-718593808915645-729747363110832-807253507325647-718884162880000-741103456140747-896081535791208-719174595047155-763534279958976-719368259943125-730533799357296-808123431554919-719658822471680-741902023079123-897047054109000-719949463231115-764356906155072-720143267204205-731320800420144-808993980533375-720434038371840-742701163468891-898013265734952-720724887798435-765180123000000-720918830898565-732108366502128-809865154485271-721209810780160-743500877515875-898980170917896-810300975896339-732699411979392-877136940720691-732896497806000-810736953634863-766416056197632-744301165425899-555523314757200-777837207411250-855735961888192-722471628385845-733685194534512-1000614301898310-833957337600000-967520543048007-945405745071080-1001152387104030-856656602973248-823391012781250-756731258614368-1001690665180470-601095158903808-968561214004143-968691350319000-734968033185606-768478901107392-935665214403108-846667964633504-1002767800083750-991759135145984-969602630927511-947440151070120-1003306656979710-813902469992000-724805002858365-914492177306416-814230406695311-725097027432960-747508059812875-903825108896616-725389130434995-770131839565248-725583909345685-736845639750000-815105335197223-725876143083520-748311220125459-904796180646984-726168455276875-770959196887104-726363373664045-737637166642992-815980890242367-726655816640000-749114955536027-905767947696168-726948338099555-771787146553536-727143396013125-738429260177136-816857072054999-727436048302080-749919266250403-906740410293000-727728779102715-772615688776512-727923976592605-739221920555184-817733880859375-728216838269440-750724152474411-907713568686312-728509778486035-773444823768000-728705115602165-740015147979888-818611316879751-728998186741760-751529614413875-908687423124936-729291336449195-774274551739968-729486813241485-740808942654000-819489380340383-729780093918720-752335652274619-909661973857704-730073453191875-775104872904384-730269069710245-921385924120944-752940558742333-584450048000000-753142266262467-910637221133448-775831890693063-877144803230592-776039693528625-742398234561456-821247390479439-731345585185280-753949456583243-911613165201000-731639363814515-776767295658432-731835259934805-743193732200304-822127337606375-732129169674240-754757223442771-912589806309192-732423158093835-777599397672000-732619194089965-743989797899568-823007913070591-732913313666560-755565567046875-913567144706856-733207511951395-778432093725888-733403687873285-744786431862000-823889117096343-733698017361920-756374487601379-914545180642824-733992425586875-779265384032064-734188741484445-745583634290352-824770949907887-734483280960000-757183985312107-915523914365928-734777899199955-780099268802496-734974355123125-746381405387376-825653411729479-735269104660480-757994060384883-916503346125000-735563932990315-780933748249152-735760528989005-747179745355824-826536502785375-736055488663040-758804713025531-917483476168872-736350527157635-781768822584000-849862226863575-917973803125368-861423794120372-736842433167360-759615943439875-929803370237072-737137681901595-782604492019008-873457861253593-862229364948000-1009850781386879-828415161557504-998770778527896-998904113893312-930921270593750-851566039963200-613209390047982-840436141792048-874624597634403-920182436352000-806687310855511-613618705665072-829632279938851-784277617037376-738910830718125-932288809634992-898300519768937-739206631687680-762053103383323-921410984169000-739502511590115-785115073044672-739699808715205-751179985365744-830961404428375-739995820195840-762866646950691-922394609369352-740291910637435-785953125000000-740489348137565-751981742820528-831848275599471-740785570204160-763680769320875-923378934347496-741081871259795-786791773115328-741279449184885-752784070566000-832735777574663-741575881912320-764495470699699-924363959352264-741872393656875-787631017602624-742070112056845-753586968804912-833623910578207-742366755520000-765310751292987-925349684632488-742663478028355-788470858673856-742861336953125-754390437740016-834512674834359-743158191226880-766126611306563-926336110437000-743455124573915-789311296540992-743653124073405-755194477574064-835402070567375-972857939765760-744049228529945-938771672039504-1019046348936891-824506780608000-950599604772943-755999088509808-572802806850350-618709361319936-767760070417875-618874043076144-882585970521871-905630769816768-963077298552516-871471584500000-1032143125513590-814354568903168-998003840054799-940772427972048-986795011933250-906595061593664-964102712386212-952752000504296-838074048870167-746329559040000-769395849680227-930288823874568-746627336490555-792679020207936-746825898788125-758416349954736-838965972753199-747123808238080-770214609882603-931278756033000-747421796901715-793522445234112-747620500023605-759223247324784-839858529234375-747918620733440-771033950740211-932269390208712-748216820685035-794366468328000-748415664681165-760030716810288-840751718537951-748713996725760-771853872458875-933260726650536-749012408040195-795211089701568-749211392960485-760838758614000-841645540888183-749509936414720-772674375244419-934252765607304-749808559166875-796056309566784-750007685061245-761647372938672-842539996509327-750306440000000-773495459302667-935245507327848-750605274264755-796902128135616-750804541183125-762456559987056-843435085625639-751103507681280-774317124839443-936238952061000-751402553533515-797748545620032-751601961525805-948300579346608-774933755711125-601520911726592-775139372060571-937233100055592-983646673226015-879612503328000-775550713867087-949307356839536-602079624555084-775859315703808-822288302734375-590736117649176-857260178435342-799443178183488-590971127373639-776476764949000-996803800440826-823051767817728-997068099471782-834865339399488-765394667259750-869881949659200-637997977586915-777300540070824-858624819630806-754297423360000-777609605888307-940219766096328-754597316310955-801140208952896-754797289098125-766511093180976-847920041483679-755097314516480-778434181905083-941216729625000-755397419429315-801989624194752-755597533540005-767323720829424-848818936280375-755897770967040-779259340635331-942214397659272-756198087916635-802839639624000-756398343400765-768136922620848-849718466142031-756698792911360-780085082284875-943212770447976-756999321972595-803690255452608-757199718880085-768950698758000-850618631292903-757500380549120-780911407059539-944211848239944-757801121796875-804541471892544-758001660177645-769765049443632-851519431957247-758302534080000-781738315165147-945211631284008-758603487589155-805393289155776-758804167493125-770579974880496-852420868359319-759105253703680-782565806807523-946212119829000-759406419549115-806245707454272-759607241026205-958400438973488-783186808609125-607926831695872-783393882192491-947213314123752-853774215461227-807098727000000-994383459738585-889213300943008-1041453188840503-760712392028160-784222541525875-971627935760728-1006880038742898-901627982556224-866614099665346-983854074924000-1054268623028790-972398389594624-831920548297887-972655298018552-621175177921375-914303079900288-914423833113414-797295289655776-856032975830007-832689963008000-1032202715399768-973683384216984-962079271859494-915269403315072-868447152281250-985935020546784-962587434675806-763127350202880-786712025274763-962968674194000-763429578852915-810516821894592-763631108944405-775481608631664-857842849822375-763933470576640-787543022460051-952229880553032-764235912012235-811372850856000-764437583976365-776300563004208-858748742667711-764740158440960-788374604622875-953235314571816-765042812736995-812229482336448-765244626623685-777120093750000-859655273044823-765547413995520-789206771969059-954241456082184-765850281226875-813086716547904-766052237086045-777940201071792-860562441177967-766355237440000-790039524704427-955248305332968-766658317681555-813944553702336-766860415563125-778760885172336-861470247291399-767163628974080-790872863034803-956255862573000-767466922300715-814802994011712-767669162254605-779582146254384-862378691609375-767972588797440-791706787166011-957264128051112-768276095284035-815662037688000-768478477360165-780403984520688-863287774356151-768782117109760-792541297303875-828137248655920-1053055991968867-828355332551040-769288361079485-875920509286000-591916092983550-864311255847424-793376393654219-959282784716904-769896147141875-817381935989184-770098813612245-782049393417072-865107856033127-770402880000000-794212076422867-960293176402248-770707026415755-818242791038016-770909835158125-782872964452656-866018855411839-771214114977280-795048345815643-961304277321000-771518474852515-819104250301632-771721425916805-783697113483504-866930494116375-772025919242240-795885202038371-962316087721992-772330492651835-819966313992000-772533586087965-784521840712368-867842772370991-772838292994560-796722645296875-963328607854056-773143080013395-820828982321088-773346315871285-785347146342000-868755690399943-773651236433920-797560675796979-964341837966024-773956237136875-821692255500864-774159615466445-786173030575152-869669248427487-774464749760000-798399293744507-965355778306728-774769964221955-822556133743296-774973485073125-786999493614576-870583446677879-1013826166456320-775380633693185-1049883923000000-775584261468315-823420617260352-799658322579959-787826535663024-871498285375375-1062651082023424-1038907633940991-967385790669672-979457362833878-943747402824000-955818997070480-812552767739104-1027775120109642-621526968844288-812872684394500-1076002070210640-777214567243595-932779844570496-621934812767268-980872020046000-873329885008703-777724505925120-993224633767211-658247229399320-778030576171875-826017701578944-778234667608645-790311137890032-874246646393047-778540871680000-802601202397347-970436142150408-778847156060155-826884608314176-779051390268125-791140498002096-875164049121519-779357808519680-803443349351723-971454349089000-779664307108115-827752121383872-779868684137205-791970438136944-876082093418375-780175316643840-804286085194291-972473267998152-780482029515435-828620241000000-780686549415565-792800958497328-877000779507871-780993396252160-805129410130875-973492899126696-781300323481795-829488967374528-781504986302885-793632059286000-877920107614263-781812047544320-805973324367299-974513242723464-782119189206875-830358300719424-782323994998845-794463740705712-878840077961807-782631270720000-806817828109387-975534299037288-879300304046091-795087882931584-891578840031250-819395881836768-891812207086742-783451065978880-1000537649100387-651037378878000-783758636731915-832098789168192-868390591697064-615190472101704-627335085019500-603285718092800-856777775377663-1001716292806776-784579218931235-832969944696000-784784453935365-796962270778608-881603844693911-785092373544960-809354878427875-978601746769416-785400373687995-833841708042048-785605751862685-797796276750000-882526386248623-785913886251520-810201742250859-979625656439784-786222101201875-834714079418304-786427622597045-798630864366192-883449571165767-786735971840000-811049196608627-980650280071368-787044401672555-835587059036736-787250066338125-799466033829936-884373399669599-787558630510080-811897241707003-981675617913000-787867275299715-836460647109312-788073083285605-800301785343984-885297871984375-788381862461440-812745877751811-982701670213512-788690722283035-837334843848000-910265392660575-886107313562264-667702251484785-789205667893760-813595104948875-983728437221736-789514742822195-838209649464768-789720837598485-801975035334000-887148748943783-790030047006720-814444923504019-984755919186504-790339337116875-839085064171584-790545575363245-802812534215472-888075154036927-790855000000000-815295333623067-985784116356648-791164505366755-839961088180416-791370887133125-803650615958256-889002203838039-791680527073280-816146335511843-986813028981000-791990247771515-840837721703232-792196773107805-804489280765104-889929898571375-792506628426240-816997929376171-987842657308392-792816564530835-841714964952000-793023233486965-805328528838768-890858238461191-793333304258560-817850115421875-854581606310320-940162247692591-879227288492544-989259565324509-806168360382000-891787223731743-1038517648545280-830922340031716-989904062067624-794470921911875-843471281475264-794677878257445-807008775597552-892716854607287-794988380160000-819556264880707-990935838997128-795298962932955-844350355173696-795506063048125-807849774688176-893647131312079-795816780628480-820410228705483-991968332625000-796127579107315-845230039445952-796334823042005-808691357856624-894578054070375-796645756375040-821264785534931-993001543200072-796956770634635-846110334504000-797164158438765-809533525305648-895509623106431-797475307599360-822119935574875-994035470971176-797786537714595-846991240559808-797994069438085-810376277238000-896441838644503-798305434501120-822975679031139-995070116187144-798616880546875-847872757825344-798824556239645-811219613856432-897374700908847-799136137280000-823832016109547-996105479096808-799447799331155-848754886512576-799655619043125-812063535363696-898308210123719-1046111236485120-997012010571489-1095624676981000-800279294267115-849637626833472-677335372194635-812908041962544-899242366513375-800799271267840-825546471956091-998178358992552-801111365554435-850520979000000-801319473454565-813753133855728-900177170302071-801631702876160-826404591135875-999215876476296-801944013392795-851404943224128-802152265461885-814598811246000-901112621714063-802464711160320-827263304761099-1000254112649064-802777237981875-852289519717824-802985634269845-815445074336112-902048720973607-803298296320000-828122613037587-1001293067759688-803611039521355-853174708693056-803819580078125-816291923328816-902985468304959-804132458554880-828982516171163-1002332742057000-804445418210915-854060510361792-804654103086405-817139358426864-903922863932375-804967198064640-829843014367651-1003373135789832-805280374250235-854946924936000-805489203494365-817987379833008-904860908080111-805802515048960-830704107832875-1004414249207016-806115907838995-855833952627648-930374863271175-905682228875000-930616028396325-806638409707520-831565796772659-1005456082557384-806952019176875-856721593648704-807161137308045-819685182380592-906738942833567-807474882240000-832428081392827-1006498636089768-807788708463555-857609848211136-807997971113125-820534963927536-907678933887799-808311932846080-833290961899203-1007541910053000-808625975898715-858498716526912-808835383116605-821385332593584-908619574359375-809149561725440-834154438497611-1008585904695912-809463821682035-859388198808000-809673373518165-822236288581488-909560864472551-809987769077760-835018511393875-1009630620267336-810302246013195-860278295266368-810511942517485-823087832094000-910502804451583-810826555102720-835883180793819-1010676057016104-811141249091875-861169006113984-811351090314245-823939963333872-911445394520727-1061409280000000-1011591405957681-1061683806064680-1061821086846295-949515727518464-837181303788375-1024742423716912-649920671438636-837506044399104-887621134401359-637669430211000-925365437376894-862952271824832-637916727354447-838155777531048-1075980783850250-888424515260416-1076258898900918-901170397168704-826179605622294-938961768600000-688660930257355-839022610982216-926801410901958-1014602872057344-1039789099796875-1039923416335608-1077650193035138-977529910371456-927519954411186-852425714156000-664476435475723-677101158531072-890377600913927-627107448845200-928238869212750-991085665292224-1066495677709505-639980023780872-652612896047788-815871434560000-841083735296907-1016963836167528-816187432443955-866526185244096-816398143023125-829065104401776-917114599386279-816714276884480-841952585985683-1018014328125000-817030492346315-867421202751552-817241347993005-829921355410224-918061746365375-817557699479040-842822034824731-1019065543250472-817874132593635-868316836344000-818085133357765-830778195768048-919009545228631-818401702543360-843692082019875-1020117481792776-818718353385595-869213086233408-818929499317085-831635625678000-919957996200303-819246286277120-844562727776939-1021170144000744-819563154921875-870109952631744-819774446070645-832493645342832-920907099504647-820091450880000-845433972301747-1022223530123208-820408537402155-871007435750976-820619973818125-833352254965296-921856855365919-820937196551680-846305815800123-1023277640409000-821254501026115-871905535803072-821466082759205-1036444534687088-846960091624125-1125211286011904-1049489484383059-1074916794865320-1075055213991415-973998949000000-986775327712278-961597191090208-1126225903882303-658104345520128-1101200942493375-1050706257539128-1038180771466326-987664925060736-937136051254546-1063912978044000-1140053474630790-924829050834944-848924942194899-1026444318734664-1127966667497875-887278953294720-824007898740845-1039651408501424-659375962479468-1052600884544000-900533463266431-1052871731326584-672402170161151-1002388763141696-1015207796250000-1066105293957984-647361465405933-926734604599296-850674025099363-1079352103145000-876292615184679-952614453777600-1067065378431108-1067202580391136-648027732139125-1054768959835648-889678547362710-1118596815641536-889907305505330-979023869208000-941001023020754-1055582754968104-648694455864957-852315970736128-877871046415125-1030676709884616-827192535189995-878209528093248-827405135540685-840242394750000-929478421216223-827724104363520-853302151534459-1031736622434984-828043155151875-879112571239104-828255901219045-841106323114992-930434060181367-828575088640000-854179395057027-1032797261388168-828894358054555-880016233225536-829107249888125-841970843465136-931390353945999-829426655982080-855057239611403-1033858626993000-829746144097715-880920514264512-829959181747605-842835956003184-932347302734375-830278806589440-855935685403411-1034920719498312-830598513481035-881825414568000-830811696997165-843701660931888-933304906770751-831131540661760-856814732638875-1035983539152936-831451466404195-882730934347968-831664795836485-844567958454000-934263166279383-831984858398720-857694381523619-1037047086205704-832305003066875-883637073816384-832518478465245-845434848772272-935222081484527-1089096840000000-832945538763065-1089376119468680-833159123668755-999919115774592-871836102548500-974529958163616-679693528607579-692606696398848-910766260291959-641466891050000-846844810385046-936781717748544-834227595889805-949857730863856-1027004799870000-1117010822410752-860336940131771-1040242094241192-886245678565071-1001971283664000-886472756074809-848039078531568-938102763521591-835403969986560-861218997671875-1041308553374856-835724991106395-887267832813888-835939050868285-848908342062000-939064303755343-836260209041920-862101657890379-1042375741150824-836581449461875-888177073904064-836795655439445-849778199402352-940026500806887-837117032960000-862984920993107-1043443657817928-837438492754955-889086935954496-837652844998125-850648650755376-940989354900479-837974441940480-863868787185883-1044512303625000-838296121185315-889997419177152-838510619744005-851519696323824-941952866260375-838832436183040-864753256674531-1045581678820872-839154334952635-890908523784000-839368979876765-852391336310448-942917035110831-839691015887360-865638329664875-1046651783654376-840013134256595-891820249987008-840227925596085-1060115345686000-866302530579437-1125044088754176-931189976986824-1047722618374344-892618520484375-905670751592320-905786492263310-983551006462752-660098830893189-867299468864000-919195975748511-1139430717582784-1113676833284482-997256648380608-997384049902625-984556767959456-647817458115150-997766319570944-920135808820999-1075789107567000-842593047385115-894559160292672-1089167621149188-985563214871584-1154293778101375-843131193315840-1076751146911259-1024990380777368-960240155716926-895473375000000-1090280672922084-986570347432608-1168456129607430-1155620778397696-1129795964598375-1103964533248360-1169052813435870-1000317280463424-870517027902343-1169500459590000-1130661377019297-948836929222144-1117950521335942-962080165735056-689145332141375-962325677855104-1053490870482453-650385967391600-1144825326247592-949805789184000-871850755933987-1106220398775080-846041141183355-898219755905856-950411661453125-664070906954376-1159016621112287-872629392694784-1133260265645343-1081294201091000-964168350241534-1029446094756672-1042609964834960-1094880027133536-1173235288983750-847444611952640-873631178115251-1056315601906632-847768710088235-900053792616000-847984821412365-861140473781808-952594934932511-848309057256960-874522297442875-1057393016802216-848633375740995-900971746438848-848849633979685-862018665750000-953566350980023-849174090219520-875414022536259-1058471164072584-849498629126875-901890324189504-849715034330045-862897454569392-954538427209167-850039711040000-876306353601227-1059550043966568-850364470445555-902809526079936-850581022663125-863776840442736-955511163844199-850905919918080-877199290843603-1060629656733000-851230899896715-903729352322112-851447599178605-864656823572784-956484561109375-851772717053440-878092834469211-917527162758640-1009408302482503-943982403264000-1062115321387221-865537404162288-957458619228951-655877002035200-892106193410500-1062791081878536-905455710087207-1023688819410816-905686057097361-866418582414000-958433338427183-853508076894720-879881741693419-1063872894755304-853833719041875-906492579278784-854050859816245-867300358530672-959408718928327-854376640000000-880777105703667-1064955441499848-854702503019755-907414905047616-854919791058125-868182732715056-960384760956639-855245792161280-881673076920443-1066038722361000-855571876128515-908337856228032-855789311480805-869065705169904-961361464736375-856115533578240-882569655549571-1067122737587592-856441838567835-909261433032000-856659421283965-869949276097968-962338830491791-856985864450560-883466841796875-1068207487428456-857312390537395-910185635671488-857530120667285-870833445702000-963316858447143-1121812718817280-1069157246348097-699660833617512-871386355809750-911110464358464-924432287509710-673600438233672-686895459438188-1175797204416000-1149520661243727-1096808307798904-872271498694662-912035919304896-700638220239625-899046114529248-965274901854679-859600395796480-886162048306083-1071466147125000-859927585624315-912962000722752-860145758295005-873489548597424-966254917755375-860473086487040-887061667084331-1072553837911272-860800497711635-913888708824000-861018817995765-874376114932848-967235596753031-861346367631360-887961894509875-1073642264555976-861674000327595-914816043820608-861892468275085-875263280958000-968216939071903-862220239429120-888862730788539-1074731427307944-862548093671875-915744005924544-862766709332645-876151046875632-969198944936247-863094702080000-889764176126147-929722133939760-1022823906179999-956527925580288-890215127256375-1089655028134192-1063212728296240-890553440577024-903959756560292-1130092799765000-704735335803663-930900389292160-691613571664964-1090759501429488-971164948198375-864845400739840-891568894801491-1171164116706496-865173920071435-918531657000000-705628121478353-1105180144225864-972148946044671-918996814818816-1172202251231000-1079095444365096-1199146677681870-1052717510762048-892924034118543-1199601972990000-1159761971575497-973256737849344-1146721499816342-986838685957456-706879287696375-987088392101504-1080598299167853-667120365111600-1174280360348392-974242147904000-894280545902187-1081281876006888-1188225403831963-934677495319680-868024573203125-1095184857896432-975104927135559-868353897082880-895185649915763-668133455850000-935505096882370-1029185702095936-1042683546359286-1123031919315936-695298114699500-722131616461824-949589356335263-1123599824194848-882940009539654-923190304056000-936688232061470-1017104309021088-682616770223757-1111065706627072-950549790522375-669485838246800-883832957945718-924123919664448-964425042629928-1125304687500000-683307008321301-723592927890432-951510872093167-1206292883855760-710462195975375-1005498004891200-724049991671022-992341956227888-1032702427254883-1086486483456000-952472601265751-724507247883312-979550124484131-925993038774336-872422409438125-885956122860336-980044867582399-872752844654080-899720331595803-1087858887273000-873083363295715-926928542699712-873303755409605-886851103302384-981034853484375-873634413117440-900629101695011-1088957642063112-873965154279035-927864676488000-874185694755165-887746686272688-982025505847151-874516575029760-901538483528875-1090057136444136-874847538786195-928801440351168-875068227674485-888642871974000-983016824894983-875399330590720-902448477303219-1091157370664904-875730517016875-929738834501184-875951354367245-889539660609072-984008810852127-876282680000000-903359083223867-1092258344974248-876614089170755-930676859150016-876835075033125-890437052380656-985001463942839-877166623457280-904270301496643-1093360059621000-877498255447515-931615514509632-1012753142159775-985870582831512-1080542229470000-878051161162240-1121345029599579-1134998163552288-1054059619256202-1067707670472000-1054325158899558-919271029360864-1000509166564758-878936293314560-906094575921875-1095565710922056-879268371168395-933494718209088-879489802866285-893132848542000-987983428258943-879822020113920-907007632485979-1096669648074024-880154321011875-934435266972864-880375901421445-894032654887152-988978752126487-880708341760000-907921302225507-1097774326558728-881040865776955-935376447295296-881262594948125-894933065382576-989974744248879-881595258452480-908835585346283-1098879746625000-881928005663315-936318259388352-882149883646005-895834080231024-990971404850375-882482770391040-909750482054131-1099985908521672-882815740870635-937260703464000-883037767714765-896735699635248-991968734155231-883370877775360-910665992554875-951561689812720-1046849438662951-1087772498242560-883926247354085-1006442520622000-1020171300398325-884259580805120-911582117054339-1102200458801544-884592998046875-939147488410944-884815322763645-898540752922032-993965399772047-885148879680000-912498855758347-1103308847682408-885482520415155-940091829706176-885704994143125-899444187210096-994964736532519-886038774599680-913416208872723-1104417979389000-886372638903115-941036803831872-886595261692205-900348226864944-995964742893375-886929265763840-914334176603291-1105527854170152-887263353710435-941982411000000-887486125610565-901252872089328-996965419078871-887820353372160-915252759155875-1106638472274696-997466008425939-901931753534592-1011383713403746-902158123086000-997966765313263-888712037624320-916171956736299-1107749833951464-889046573081875-943875525311424-889269643353845-903063980057712-998968781820807-889604318720000-917091769550387-1108861939449288-889939078045355-944823032878656-890162297578125-903970443207216-999971468825759-890497196858880-918012197803963-1109974789017000-890832180126915-945771174336192-891055548970405-904877512737264-1000974826552375-891390672240640-918933241702851-1111088382903432-891725879526235-946719949896000-891949397730365-905785188850608-1001978855224911-892284745064960-919854901452875-1112202721357416-892620176442995-947669359770048-892843844057685-906693471750000-1002983555067623-1168003851079680-1113178378478337-1085828476118456-1017232542456750-948619404170304-1141235811024919-1045117870977312-1224041293714031-1059134625472000-990483656593032-1128192072876496-1059532513835719-1045903280166144-1169906693355625-688266559634800-1170199621625355-743513995542528-950164580192421-1005372408429000-730019271963383-1046951104379648-950640356313873-909421963191984-1006001683859375-895867014781440-923547703080811-1116667525825512-896203343278035-951473346648000-896427609034165-910332675263088-1007009070625351-896764077813760-924472445173875-1117785590849736-897100630777195-952425931272768-897325046193485-911243995134000-1008017129682783-897661739486720-925397804353019-1118904401934504-897998516991875-953379151483584-898223082118245-912155923007472-1009025861255927-898560000000000-926323780824067-1120023959328648-898897002121755-954333007492416-899121717008125-913068459086256-1010035265569039-899458859553280-927250374792843-1121144263281000-899796086366515-955287499511232-900020951062805-913981603573104-1011045342846375-900358318346240-928177586465171-1122265314040392-900695769925835-956242627752000-900920784481965-1136688170409136-928873400711189-1234030700238336-929105416046875-1137256088545232-721276842399516-971070832896640-1026688770652786-1248831434430000-1040822791634325-1013193992536064-985558273519527-1096743986433016-1138534595915750-1055358903257856-1013826527161669-1138960977875504-1097428624134201-1153138526912000-1153282435376443-1195116465059568-1125773413808067-1070313203743168-722899106338500-931543910105512-1223673013360424-1126475909885952-931892614306483-737260746625000-959949762920919-973983558002560-1057599766162652-918556459224624-1252733216973750-1238968463117824-974591107923510-1100032845845848-919129387267014-974955759120000-905428949033765-1030924562468272-1044986251353525-1212335184150528-933753839799875-1156884039318168-1143088159718566-1059579630424832-725065906266468-934335980581000-1046028848243325-697439481062400-1157893830392411-1185942667564040-1074458417484375-976902101768320-963066350772777-949227131533536-1228564642363432-1242680416768000-977510864640870-1187125357746280-1187273249281895-977876243729280-1033883660245250-1257582703325040-1048116121987725-1020293424211456-992463774204799-1104428210391000-1146511288816822-1062752550188288-1020928909862061-1258836212032560-1063149609960500-965348118134784-937483722165091-1133516950764552-909725611749435-965828949000000-909952127649565-924066405847728-1022200672673071-910291971996160-938417742160875-1134646232824296-910631900947795-966791089672128-910858567256885-924986867046000-1023218843013063-911198637240320-939352382330099-1135776264677064-911538791856875-967753869109824-911765608624845-925907939288112-1024237689232607-912105904320000-940287642878587-1136907046571688-912446284676355-968717287525056-912673251953125-926829622776816-1025257211555959-913013773434880-941223524012163-1138038578757000-913354379605915-969681345129792-913581497441405-927751917714864-1026277410207375-913922244784640-942160025936651-1139170861481832-914263076845235-970646042136000-914490345289365-928674824305008-1027298285411111-914831318568960-943097148857875-985447810489520-915172376593995-985692703085440-1028064385936277-718325992125000-1253705007230639-1028447578985984-1239926426602776-1141437679545384-1212047323053250-1099435271096448-775339102884115-704941267615600-1269051862651110-1057674547200000-1001389572454951-1269524683757520-931100365717302-1114637300912576-931331589680250-931447216015536-1030364972578799-917562156526080-945912245660203-1143707502753000-917903892893715-974511228414912-918131764271605-932372571241584-1031388556234375-918473642045440-946851854626611-1144843541907912-918815604677035-975479125608000-919043626913165-933298539133488-1032412817563551-919385730997760-947792085618875-1145980333095336-919727919968195-976447663474368-919956093112485-934225119894000-1033437756790583-920298423582720-948732938842819-1147117876564104-920640838966875-977416842225984-920869163069245-935152313725872-1034463374139727-921211720000000-949674414504267-1148256172563048-921554361872755-978386662074816-921782836983125-936080120831856-1035489669835239-1205856580587520-922239900486385-1206155479185000-922468488885515-979357123232832-1007869156443387-1078979532538144-709942906918750-1065046298227200-1235606766489231-1278372247940880-1164883447027638-1108197124944000-994659074210270-966359926455264-1037544297162391-710734795571200-1023584860125000-1151675578229256-924298556030395-981299970324288-924527484464285-938867223822000-1038572629242543-924870947985920-953446545641579-1152816886837224-925214496561875-982272356681664-925443576203445-939797486051952-1039601640566087-925787266560000-954391136577907-1153958949219528-926131041998955-983245385196096-926360272898125-940728362569776-1040631331357279-926704190164480-955336351186683-1155101765625000-927048192541315-984219056079552-927277574748005-941659853578224-1041661701840375-927621718999040-956282189673731-1156245336302472-927965948388635-985193369544000-1070994786868575-1271070975392792-1128393526396313-985680767310336-957228652244875-785881868920280-986046421109247-1014752914955072-1043466486368957-729087252633000-1086617269742836-1272643304476672-972476869540356-1172837639511568-929803276796875-987143925063744-1130347937612707-944458015574832-1044756893683647-715675337600000-1002069276602870-1173997620608976-1045273354342651-1131325988926016-945275189042250-1203226139275104-759272181018859-988608530055168-1189342660914227-1117833567942000-1175303513282022-1075105492881600-1204266863667588-716914040209200-1204564323679500-932218448611840-1233549019162278-1147629148127360-1176465119437718-990074583000000-932794105288565-1176900918991856-1090920877025652-933139613020160-961970333565875-1177482152458512-933485206058795-991052756401728-1005539929494030-976930771388000-732788501603781-1192724536564224-1020408338693087-1207392637176096-948782700087750-992031573868224-1222218660356105-733421671357032-1280050621584551-1078827417600000-1021415941999431-1251748573179576-1237513287218962-1108142749885248-1209032103562500-978860987222368-1050965659326159-1079892400166400-1252829663806143-1296190506330000-1008272485968370-1109236491622336-1008521145382590-979827047835872-734960887564125-936830338928640-1009018586852710-792898050035960-994849263645111-1023811657784000-1052781171518933-980793743858784-1154017206528560-995462510071296-966727647862875-1168874466872616-938101269944995-995953288621248-938332471735685-952885749750000-1054079245235223-938679345643520-967680988943459-1170027108222984-939026305026875-996935329591104-939257658774045-953825247586992-1055118472120367-939604760640000-968634956578027-1171180507080168-939951948009555-997918015897536-940183453763125-954765362753136-1056158381836999-940530783662080-969589550972403-1172334663693000-940878199092715-998901347752512-941109856902605-955706095451184-1057198974609375-941457414909440-970544772332411-1173489578310312-941805058476035-999885325368000-942036868392165-956647445883888-1058240250661751-942384654581760-971500620863875-1174645251180936-942732526359195-1000869948955968-942964488431485-957589414254000-1059282210218383-943312502878720-972457096772619-1016124910848880-1234017711539375-1045414141281792-943892717220245-1307089091951280-1307249819387910-1031401664000000-1278514173481688-1264141011394296-1191635717703814-1002841134897216-944821554958125-959475205617456-1061368180741439-945170026145280-974371931545243-1178116821801000-945518583004515-1003827697674432-945751001844805-960419029016304-1062412192156375-946099701514240-975330290820771-1179275530173192-946448486883835-1004814907272000-946681058079965-961363471163568-1063456887972591-947029986306560-976289278296875-1180434998042856-947379000261395-1005802763901888-947611723863285-962308532262000-1064502268414343-947960880721920-977248894179379-1181595225658824-948310123336875-1006791267776064-948542999394445-963254212514352-1065548333705887-948892384960000-978209138674107-1182756213269928-949241856309955-1007780419106496-949474884873125-1197946090819952-978929734695741-1271303560495104-1052242400941128-1183917961125000-1008646457803719-1023390076338560-774947556406881-1213746012079112-1067642519735375-1038519428967936-1287336914335384-1214341715632696-1199858254235478-1141468577808000-1083064553829394-1229575416646752-1317563803876230-1010256131444736-1215384665803875-1142308785282288-1201035980956166-1098643217342400-1230631277711556-732608431150000-1230933063285324-952624504133120-1260550014816262-1172748413473920-1202214478093750-1011743503230144-967873276875978-967991908181232-1100125624067925-953559060480000-983019797534947-1232593765886112-1027287344061090-1144831881328512-954143468468125-968941307614896-1071839119859119-954494227847680-983983818025323-1189738112769000-954845073180115-1013728935540672-955079017825205-969891327621744-1072889985378375-955430006435840-984948468568691-1190904427313352-955781081027435-1014722625000000-956015178527565-970841968404528-1073941537541471-956366396444160-985913749370875-1192071503843496-956717700369795-1015716963611328-956951950774885-971793230166000-1074993776572663-957303398072320-986879660637699-1193239342608264-957654931406875-1016711951586624-957889334766845-972745113108912-1076046702696207-1253084399680000-958358256229465-781526185486344-1076573423487691-1017707589137856-1017832089515625-1239251513100384-1077100316136359-959179236986880-1224947912794787-1225097735191000-1151437475236698-1166342119444672-974531568610842-753139210770504-1314462478403375-960118074672640-989781179284251-1196747434798632-960470296683235-1019700813816000-960705159207365-975604491053808-1079209605863511-961057524776960-990749614467875-1197918324990216-961409976495995-1020698401366848-961644992174685-976558860750000-1080265282599023-961997587499520-991718681145259-1199089978660584-962350269001875-1021696639341504-962585437885045-977513852641392-1081321647548167-962938263040000-992688379522227-1200262396058568-963291174400555-1022695527951936-1111761342159375-1319451250861144-1171341333888777-1290115707523584-1290273250044783-1201435577433000-1275754024441346-1142384350588096-1231551661102911-1246541804862816-1320901964734375-964821453373440-994629672198211-1202609523032712-965174824675035-1024695257928000-965410453471165-980382563514288-1084494873919951-965763968565760-995601266908875-1203784233106536-966117569950195-1025696099717568-966353352150485-981340046214000-1085553993966183-966707097374720-996573494142419-1204959707903304-967060928916875-1026697592990784-967296864571245-982298152122672-1086613803347327-967650840000000-997546354104667-1206135947671848-968004901774755-1027699737959616-968240990933125-983256881443056-1087674302287639-968595196641280-998519847001443-1207312952661000-1088204810412563-983976337669248-790259134863041-1014040968752992-1088735491011375-969540167498240-999493973038571-1208490723119592-969894689962835-1029705983832000-970131086278965-985176211129968-1089797369742791-970485752770560-1000468732421875-1209669259296456-970840505692395-1030710085159488-971077055662285-986136811902000-1090859938706143-971431952657920-1001444125357179-1210848561440424-971786936111875-1031714839030464-972023639785445-987098036896752-1091923198125687-972378767360000-1002420152050307-1212028629800328-972733981420955-1032720245656896-972970838848125-988059886316976-1092987148225679-973326197076480-1003396812707083-1048452623750000-1153438252616727-1078670927218176-1003885380836159-1228785356817648-1198960864910000-1004251910991872-1019364765854724-1274360995356520-794698240428487-1049729148720000-779893666072612-1109983696729072-1350144396202230-1035236619419136-1320462376607000-750353972014800-1230730189414966-1170836956039296-1110929129962866-1141092998788000-1336442464270279-1156388580458496-1036370319935973-1231778256429968-976528315546875-1036748403956544-976765788487645-991913532307632-1097249859915247-977122070080000-1007309799087147-1217940473548008-977478438299155-1037757077539776-977716065243125-992878506896496-1098317266781319-978072577863680-1008289632649523-1219125144429000-978429177139115-1038766405150272-978666958136205-993844107127344-1099385365673375-979023701859840-1009270101410491-1220310583267752-979380532266435-1039776387000000-979618467366565-994810333202928-1100454156815671-979975442268160-1010251205575875-1221496790313096-980332503880795-1040787023300928-980570593133885-995777185326000-1101523640432463-980927799288320-1011232945351499-1222683765813864-981285092181875-1041798314265024-981523335637845-996744663699312-1102593816748007-981880773120000-1012215320943187-1223871510018888-982238297369355-1042810260104256-982476695078125-997712768525616-1103664685986559-982834363962880-1013198332556763-1058693847190000-1346216902280299-1058950728581760-983430671654405-1119733803038896-1331736847353000-1044329407217664-1014181980398051-1362499228374480-1059850140679330-1165976536648000-1317561816988827-1272282910624992-1105808504129711-1318041162782208-1060621470553750-1136517923470200-1182121939496394-1136793509774400-1212726740939920-1015781765625000-1288834569123835-818888267538432-1061650492404390-1258966726484312-986057290976875-1046864596451904-986296306196045-1001591456415792-1107955096655967-986654901440000-1017136743346427-1229821770316968-987013583591555-1047879819846336-987252753313125-1002562696548336-1109029433873399-987611580334080-1018122938156803-1231014131973000-987970494290715-1048895699387712-988209818564605-1003534564350384-1110104465359375-988568877437440-1019109770224011-1232207264075112-988928023274035-1049912235288000-989167502150165-1004507060024688-1111180191338151-989526792949760-1020097239753875-1233401166872136-989886170741195-1050929427759168-990125804269485-1005480183774000-1112256612033983-990485327070720-1021085346952219-1234595840612904-990844936891875-1051947277013184-991084725122245-1006453935801072-1113333727671127-991444480000000-1022074092024867-1235791285546248-991804321925755-1052965783262016-992044264908125-1007428316308656-1114411538473839-992404251937280-1023063475177643-1069001544870000-1359323461812059-1069260090872960-993004423826805-1252864737741808-1115490044666375-1146189972787200-1085191018802423-1375760544428880-1070165330168130-1177324160936000-993965202077965-1254076894140336-780068925618117-826055158404096-1331027486859375-1300586311717960-1193623430788074-1209072383212608-1285751298282276-1163439356612000-765513112409550-765605602918400-1087291303245127-1378423091313360-1317318964927250-1179602484757312-1241030430884493-1041978555296096-1118729737825487-796999627008000-1333602733812927-1349094415300544-1073272886357490-1196077069479552-1303574717845625-1165689903627936-1365249061314647-1089262779461632-1334891601988263-1304361900625000-1381255809034590-1181883745982016-1135973444887298-1043993499974752-1381922894373750-829253819556864-1336181300318991-1336342570993944-1013899475937414-1060113740664000-1075607497256670-1045001945691104-783846035285997-1275824928817152-1091499998438375-1045506411984928-1014878655275958-1061137510502208-1030504208402903-1015246009998000-1123059077766703-1000104735685120-1031001535983339-1246585034669544-1000466669921875-1062161939242944-1000708007918645-1016226055954032-1124143155151047-1001070087680000-1031996671119347-1247788205214408-1001432254770155-1063187027098176-1001673748018125-1017206732418096-1125227929943519-1002036060679680-1032992446393723-1248992149689000-1002398460698115-1064212774279872-1002640109247205-1018188039592944-1126313402368375-1003002654883840-1033988862012291-1250196868342152-1003365287905435-1065239181000000-1003607091805565-1019169977681328-1127399572649871-1003969870492160-1034985918180875-1251402361422696-1004332736591795-1066266247470528-1004574695892885-1020152546886000-1128486441012263-1004937707704320-1035983615105299-1252608629179464-1005300806956875-1067293973903424-1005542921708845-1021135747409712-1129574007679807-1005906166720000-1036981952991387-1253815671861288-1006269499200355-1068322360510656-1161359733984375-1254419483876856-1177127845734708-1006875247738880-1285856975518387-1316999958345000-1270670503212262-1069351407504192-1007481239325405-1023104043225264-1131751236827375-1007844950960640-1038980552471851-1256232082995432-1008208750121235-1070381115096000-1008451331525365-1024089138922608-1132840899755911-1008815276584960-1039980814477875-1257441451945416-1009179309197995-1071411483498048-1009422046252685-1025074866750000-1133931261886623-1009786224811520-1040981718268859-1258651596815784-1010150490951875-1072442512922304-1010393383707045-1026061226910192-1135022323443767-1010757795840000-1041983264050627-1259862517855368-1011122295582555-1073474203580736-1011365344088125-1027048219605936-1136114084651599-1011729989870080-1042985452029003-1261074215313000-1012094723289715-1074506555685312-1012337927595605-1028035845039984-1137206545734375-1012702807101440-1043988282409811-1262286689437512-1013067774273035-1075539569448000-1013311134429165-1029024103415088-1138299706916351-1013676247733760-1044991755398875-1263499940477736-1138846550114619-1029765712685952-1232746341819851-1030012994934000-1139393568421783-1077090331164672-1045995871202019-1264713968682504-1264865776864875-1218165093595008-1030878794548218-1062245020399456-828025628974947-843750000000000-1109508130325071-1172156272500600-1406756310752430-1125540086404608-1282018903760250-1031992678214256-781906433767150-1391960427245568-1063647913149572-1282788115082000-1016966214961515-1079678245319232-782469383859850-1032983470381104-1142679357121375-1017576248266240-1049012077554171-1268360718772392-1017942385320835-1080714570552000-1018186525476965-1033974896502768-1143776022163191-1018552808898560-1050018766671875-1269577858123656-1018919180154395-1081751558714688-1019163476460285-1034966956782000-1144873388649743-1019529994129920-1051026099632779-1270795775883624-1019896599661875-1082789210019264-1020141052167445-1035959651421552-1145971456805287-1020507804160000-1052034076642707-1272014472301128-1020874644042955-1083827524677696-1021119252798125-1036952980624176-1147070226854079-1021486239188480-1053042697907483-1273233947625000-1021853313497315-1084866502901952-1022098078552005-1037946944592624-1148169699020375-1022465299415040-1054051963632931-1274454202104072-1022832608224635-1085906144904000-1023077529628765-1290806160142896-1054809335978149-1086426214887936-1055061874024875-866199234312280-1149820224230699-1118452145124672-1150095465456157-803587509993000-1197646260901236-1402674636419072-1324031105377428-1418774499470160-1229751689156250-1245666757479104-1103887409207310-804357045502152-1403849827555471-1120059116352000-1372630981760367-788962742568400-1230929095249386-1183727234452800-1057589471771375-1041929152179696-1152574613345719-1026387796295680-1058095475257923-1279343016549000-1026756043857115-1090071354929472-1027001591158205-1042926293018544-1153677599463375-1027369985507840-1059107966374091-1280567170536552-1027738467944435-1091114319000000-1027984171844565-1043924069839728-1154781289044071-1028352801116160-1060121103185875-1281792105172296-1028721518502795-1092157948120128-1028967379051885-1044922482846000-1155885682312063-1029336243320320-1061134885899099-1283017820705064-1029705195731875-1093202242501824-1029951212979845-1045921532240112-1156990779491607-1030320312320000-1062149314719587-1284244317383688-1030689499831355-1094247202357056-1030935673828125-1046921218224816-1158096580806959-1031305008314880-1063164389853163-1285471595457000-1031674431000915-1095292827897792-1031920761796405-1047921541002864-1159203086482375-1032290331504640-1064180111505651-1286699655173832-1032659989440235-1096339119336000-1191815165866575-1287313978226328-1207994281539732-1033276282088960-1319571758660875-1256127793158744-1176766415012702-1097386076883648-1320201600784767-1209003506500000-1415975628097639-1225203696009216-1145781666473544-1305073652885648-1225642156113375-1209869003727616-1353304341315905-796156312215600-1353627133047715-860053901184000-1099088804131389-1162942746261544-844428966304591-1211023642431744-1099613074331625-1051929204103536-1163636157269799-1036237900206080-1068249467421203-1291619715453000-1036608499888715-1100530948302912-1036855615426605-1052932713889584-1164746188109375-1037226362365440-1069268424755611-1292851687119912-1037597197672035-1101580572408000-1037844470308165-1053936861685488-1165856924654551-1038215452917760-1070288029843875-1294084441923336-1038586523923195-1102630863682368-1038833953707485-1054941647694000-1166968367129583-1039205172062720-1071308282891819-1295317980112104-1039576478841875-1103681822337984-1039824065824245-1055947072117872-1168080515758727-1040195520000000-1072329184105267-1296552301935048-1040567062627755-1104733448586816-1040814806858125-1056953135159856-1169193370766239-1041186496929280-1073350733690043-1297787407641000-1041558275480515-1105785742640832-1041806177008805-1057959837022704-1170306932376375-1042178103050240-1074372931851971-1299023297478792-1042550117599835-1106838704712000-1203228665164575-1299641536524888-1219561798107092-1043170338562560-1075395778796875-1316312563940432-1364632616627055-1236343620231104-1332840566971087-1220577454692000-1429530406723799-1044163203665920-1076419274730579-1413972517135552-851698332202375-1253591846851968-1189446473041922-819851100844872-836025981799788-1141632701504000-1415149566381848-1367068300161480-1383315850056002-1254784418689152-1335378001233375-1222901072607136-1448344416980070-1046150823444480-1158950916953928-1303974703125000-1432932564054339-1255977746634624-1288335349542160-1224063986616864-805400922818750-1176025034336768-1417842417164184-1305214517354472-1257022529020362-1241054243352000-1192843137238994-1354198967917152-1451099777980230-1338395384778752-1145028394408375-1338713268250968-854942507585639-1258366671808896-1258516080128502-1097298128444000-1178121667358303-1210542669273600-1146116436520607-1404562910561688-1130242237031250-1259562269516928-1146660715954243-1082188541591784-1179240889862647-1114757234688000-1082573890623747-1308938674787208-1050507532112155-1115286475334976-1050756851568125-1067048934181296-1180360820987919-1051130904711680-1083601935242123-1310181633009000-1051505046616115-1116345459099072-1051754523869205-1068062035404144-1181481460958375-1052128813731840-1084630630495891-1311425377850952-1052503192383435-1117405113000000-1052752827483565-1069075777678128-1182602809998271-1053127354140160-1085659976590875-1312669909561896-1053501969613795-1118465437249728-1053751762610885-1070090161206000-1183724868331863-1054126526136320-1086689973732899-1313915228390664-1054501378506875-1119526432060224-1054751329450845-1071105186190512-1184847636183407-1055126329920000-1087720622127787-1315161334586088-1055501419262355-1120588097643456-1055751528203125-1072120852834416-1185971113777159-1056126765690880-1088751921981363-1316408228397000-1056502092079915-1121650434211392-1056752359067405-1073137161340464-1187095301337375-1382397936309760-1057253011603945-1431527408473536-1057503397159235-1122713441976000-1204212043784754-1106704236514784-1204497188116918-1058129533992960-1090816476887875-1318904379860616-1058505334699995-1123777121149248-1058755917930685-1075171704750000-1189345807254223-1059131866923520-1091849732352459-1320153638010984-1059507904901875-1124841471943104-1059758646329045-1076189940058992-1190472126059367-1060134832640000-1092883640099027-1321403684772168-1060511107964555-1125906494569536-1060762007638125-1077208818041136-1191599155727999-1061138431342080-1093918200333403-1322654520393000-1061514944087715-1126972189240512-1061766002057605-1078228338899184-1192726896484375-1062142663229440-1094953413261411-1323906145122312-1062519413471035-1128038556168000-1062770629787165-1079248502835888-1193855348552751-1063147528501760-1095989279088875-1325158559208936-1063524516314195-1129105595563968-1063775891026485-1080269310054000-1194984512157383-1064153027358720-1097025798021619-1326411762901704-1064530252816875-1130173307640384-1064781785975245-1343421854272944-1097803615945333-852127328000000-1098062970265467-1327665756449448-1196679592185371-1131241692609216-1065788314833125-1082312855145456-836431420801293-1098971032059904-1164718753997959-820321321050000-869643265581143-1280003457293184-1395040240199745-1362376579609352-1313289067870000-1132845532199424-1116559264696484-1395863823443720-1346756982074838-1182657894336000-1100658760461887-1084358975795568-1199508286423591-887412208951296-1117613907562500-1331432478710856-1068559539416395-1134450886989888-1068811706858285-1085383002462000-1200641011073343-1069190032401920-1102218196468379-1332689634166824-1069568447211875-1135521965648064-1069820773349445-1086407673626352-1201774448604887-1070199336960000-1103258638355107-1333947580721928-1070577989864955-1136593718258496-1070830474748125-1087432989491376-1202908599242479-1071209276500480-1104299734787883-1335206318625000-1071588167575315-1137666145033152-1071840811254005-1088458950259824-1204043463210375-1072219851223040-1105341485972531-1336465848124872-1072598980542635-1138739246184000-1072851783066765-1089485556134448-1205179040732831-1073231061327360-1106383892114875-1337726169470376-1073610428966595-1139813021923008-1073863390386085-1090512807318000-1206315332034103-1074242907013120-1107426953420739-1157149503749680-1140753129234375-1289698881913728-1141021826236977-1091540704013232-1207452337338447-827119529600000-1125015008455588-1340249188693608-860508186386524-1274364058652608-1390379000566500-1258110041335456-844357436991453-1208732322041856-1109515042346323-1341511887069000-1076648588975115-1143038398788672-1076902027380205-1093598434749744-1209728490853375-1077282259555840-1110560070377691-1342775378285352-1077662581222435-1144114875000000-1077916178722565-1094628269196528-1210867639512471-1078296649564160-1111605754395875-1344039662591496-1078677209924795-1145192026859328-1078930966569885-1095658749966000-1212007503071663-1079311676152320-1112652094606699-1345304740236264-1079692475281875-1146269854578624-1079946391121845-1096689877260912-1213148081755207-1080327339520000-1113699091215987-1346570611468488-1080708377493355-1147348358369856-1080962452578125-1097721651284016-1214289375787359-1081343639866880-1114746744429563-1347837276537000-1214860291129243-1098495906338688-882229154005161-1132049650184672-1215431385392375-1082360577392640-1115795054453251-1349104735690632-1082742093278235-1149507395016000-1082996487002365-1099787140325808-1216574110794511-1083378152296960-1116844021492875-1350372989178216-1083759907250995-1150587928294848-1084014460369685-1100820855750000-1217717552218023-1084396364779520-1117893645754259-1351642037248584-1084778358876875-1151669138493504-1085033071440045-1101855218713392-1218861709887167-1085415215040000-1118943927443227-1352911880150568-1085797448355555-1152751025823936-1086052320413125-1102890229418736-1220006584026199-1086434703278080-1119994866765603-1354182518133000-1086817175886715-1153833590498112-1087072207488605-1103925888068784-1221152174859375-1422056315752960-1355294978777673-886901968229256-1087837541670035-1188392682952000-1088092732866165-1372831817864176-1322761371592673-1088475594485760-1122098719133875-1356726180334536-1088858545905195-1156000752725568-1089113896745485-1105999150014000-1223445507505183-1089496997854720-1123151632591419-1357999205051304-1089880188791875-1157085350702784-1090135699326245-1107036753714672-1224593249766327-1090519040000000-1124205204505667-1359273025843848-1090902470529755-1158170626871616-1091158140808125-1108075006171056-1225741709618639-1091541721121280-1125259435082443-1360547642961000-1091925391318515-1159256581444032-1092181221390805-1109113907585904-1226890887286375-1092565041418240-1126314324527571-1361823056651592-1092948951357835-1160343214632000-1093204941273965-1110153458161968-1228040782993791-1093589001090560-1127369873046875-1363099267164456-1093973150847395-1161430526647488-1094229300657285-1111193658102000-1229191396965143-1094613600337920-1128426080846179-1364376274748424-1094997989986875-1162518517702464-1095254299740445-1381867115513904-1129218669471973-1129350803648000-1146340902581028-1365654079652328-876818775180764-1214198804878848-1096279938723125-1113276006884976-1231494780596679-1096664718356480-1130540475108083-1366932682125000-1097049588014315-1164696537778752-1097306217805005-1114318156133424-1232647550705375-1097691237527040-1131598661982331-1368212082415272-1098076347301635-1165786567224000-1098333137185765-1115360955556848-1233801039975031-1098718397071360-1132657508959875-1369492280771976-1099103747037595-1166877276556608-1099360697065085-1116404405358000-1234955248629903-1099746197189120-1133717016246539-1370773277443944-1100131787421875-1167968665988544-1100388897642645-1117448505739632-1236110176894247-1100774638080000-1134777184048147-1372055072680008-1101160468654155-1169060735731776-1101417739118125-1118493256904496-1237265824992319-1101803719943680-1135838012570523-1373337666729000-1102189790934115-1170153485998272-1102447221691205-1119538659055344-1238422193148375-1102833442979840-1136899502019491-1374621059839752-1239000647318227-1120323138000000-1256266516485474-1120584712394928-1239579281586671-1103863807388160-1137961652600875-1375905252261096-1104250359435795-1172341028948928-1104508110928885-1121631417126000-1240737090531463-1104894813368320-1139024464520499-1377190244241864-1105281606056875-1173435822057024-1105539517992845-1122678773451312-1241895620207007-1105926461120000-1140087937984187-1378476036030888-1106313494524355-1174531296536256-1106571566953125-1123726781573616-1243054870837559-1106958750842880-1141152073197763-1379762627877000-1107346025037915-1175627452598592-1107604258009405-1124775441695664-1244214842647375-1107991682736640-1142216870367051-1381050020029032-1108379197797235-1176724290456000-1108637591361365-1125824754020208-1245375535860711-1109025257000960-1143282329697875-1382338212735816-1109413013001995-1177821810320448-1109671567208685-1400056468750000-1144081858863317-1417460558897664-1144348451396059-1520281745134696-1178782699827375-1213091606966336-1110706185751045-1127925336087792-1298974392356404-1384594477056000-1162510985453508-1384917000808968-1385078281465707-1197120620062080-906496872322625-1419773610872968-1248861946164399-1180568595153408-1505828001181592-1386207596673000-1540409975010990-1352295053072192-1147016654849439-1540947994634160-1489756450265625-1250171025666048-1472975644429238-1267591673610448-907975372619367-1267886736848000-1387983474817821-856879625588400-1508283631684456-1251335419592192-1148619565978875-1457373474450760-1388952774590643-1354815248205888-1423579085257727-1303669840964000-1543999138980390-1321130702667776-1235486689362504-1510214927424192-909667054748375-1338910993550208-1167391491686964-875645441949192-1511093333851112-1288013400000000-1494269282773887-1545975553464720-1202565241963890-1322975570721728-1151294401853375-1168613748849888-1254687079004839-1117317000417280-1151829866858643-1392672604221000-1117706686637515-1186626546925632-1117966527781805-1135297947507504-1255854274941375-1118356365002240-1152901294905371-1393968013117992-1118746292836835-1187730214392000-1119006295072965-1136353793008368-1257022194523991-1119396373954560-1153973387171875-1395264225058056-1119786543478395-1188834565985088-1120046706856285-1137410292942000-1258190837976943-1120437027473920-1155046143863979-1396561240290024-1120827438761875-1189939601916864-1121087763331445-1138467447511152-1259360205524487-1121478325760000-1156119565187507-1397859059062728-1121868978886955-1191045322399296-1122129464698125-1139525256918576-1260530297390879-1122520269012480-1157193651348283-1399157681625000-1122911164053315-1192151727644352-1123171811156005-1140583721367024-1261701113800375-1123562857431040-1158268402552131-1400457108225672-1123953994460635-1193258817864000-1297170926428575-1124345222255320-1314771531209172-1436035470321152-1436202044438875-1436368631437368-1488458191485218-1350153540218496-1142570108453994-1454348784252000-883099876416861-1298826889113600-1229698700966807-1506988624503288-1212660175781250-1351406582867328-1230269128280443-1178422533258336-1282549664756486-1126694495680000-1161496648480347-1525724677749184-1127086359125155-1196584200490176-1439536232417375-1318282335690656-867391526955150-1266538394976256-1509611095322103-885046985919000-919861291417463-1353914993518464-1371431767959603-1180609690754912-1284929990635750-1406640372374016-1441539219969659-1268006674907816-1355013398520522-1372544341000000-1372703329108379-1320728316981408-1512061478071449-903865558089728-1512411749058375-1408270566570696-1217164887235010-1286866172585088-1373975675989891-1321952441396000-1409086135775511-1130879057784320-1165810299474299-1409575628407464-1131271890831875-1201027646495424-1131533830063845-1149075042761712-1271093755538807-1131926814720000-1166890378432387-1410881496273288-1132319890355355-1202140224142656-1132581991328125-1150139411703216-1272271102927759-1132975218618880-1167971124285963-1412188170417000-1133368536916915-1203253488672192-1133630799680405-1151204437713264-1273449177102375-1134024269680640-1169052537240851-1413495651087432-1134417830716235-1204367440296000-1134680255320365-1152270120994608-1274627978286911-1135073968104960-1170134617502875-1414803938533416-1135467771952995-1205482079226048-1135730358447685-1153336461750000-1275807506705623-1136124314091520-1171217365277859-1416113033003784-1136518360826875-1206597405674304-1136781109262045-1154403460182192-1276987762582767-1137175307840000-1172300780771627-1417422934747368-1137569597537555-1207713419852736-1137832507963125-1435585326553072-1173113780706221-1418405890977792-1173384864190003-1453764104359000-928414439401383-1366503616143744-1366661465700726-1191586080308832-876267436718750-1244443476906496-1244587204738143-1139542413187880-1157207461656774-1209947512248000-929487296010473-1578556913955120-1315615990281525-1140332177653760-1456284596369875-1491547979246760-1439071232743846-1211065590888768-1140990593383485-1158678034734000-1281716065160783-1141385764446720-1176641124051019-1422670619430504-1141781026741875-1212184358107584-1142044585628245-1159748324591472-1282899961693927-1142440000000000-1177727881226067-1423984561272648-1142835505631755-1213303814116416-1143099226758125-1160819273342256-1284084587031039-1143494884513280-1178815307354843-1425299311881000-1143890633556515-1214423959127232-1144154516972805-1161890881189104-1285269941396375-1144550418186240-1179903402643171-1426614871504392-1144946410715835-1215544793352000-1145210456471965-1162963148334768-1286456025014191-1145606601218560-1180992167296875-1427931240391656-1146002837309395-1216666317002688-1146267045455285-1164036074982000-1287642838108743-1146663433809920-1182081601521779-1429248418791624-1147059913536875-1217788530291264-1323835712448975-1571132725131608-953381377655226-1147720916160000-1465720172514443-1501211661617480-1501384605628095-1360234498175168-1378058607207750-1342878439045536-1572762468118247-919023238774784-1537773667421463-1467240395375000-1449729742873382-1379170030103424-1308594040564898-1485602126858976-1591899850473750-1291356333203968-1185353923681931-1433204813556072-1362586126700183-1398138920264000-1168199898688746-1203738452782304-1292397389739431-885305587507200-1239570487723750-1452235420550672-1363841436092751-1399426933928128-1240141258055630-1204847292924000-903739459351461-1470960920195584-1258436663622207-1489025960790816-1311911898718750-1223409948721344-904363564845183-1188222154778984-1525356139029354-1259450519552000-1525707104891926-1277483113682496-1171160886309942-1331017722052800-976191929026875-1189316030111752-1313724000997222-1438160565791232-1189726406378923-1438491354849000-1154477653652115-1385532483713664-1208039000992276-1350316474932384-1581473467856375-1332855579955200-1261915007841783-1599794464787280-942209484759847-1386807318000000-1262495354289371-1209289462978144-1298357019415071-1156204190236160-1191916674210875-1441139493520296-1156602866057795-1227919518568128-1156868700846885-1174801658646000-1299551139611063-1157267529400320-1193012815468099-1442464780733064-1157666449606875-1229048639893824-1157932447334845-1175881853192112-1300745991750607-1158331520320000-1194109628560587-1443790880195688-1158730684986355-1230178453189056-1158996845703125-1176962709672816-1301941576057959-1159396163194880-1195207113694163-1445117792157000-1159795572395915-1231308958665792-1160061896151405-1178044228290864-1303137892757375-1160461458224640-1196305271074651-1446445516865832-1160861112035235-1232440156536000-1161127598879365-1179126409249008-1304334942073111-1518920453488640-1447607942888625-947308949287208-1161927304103995-1269327758519232-1162193954086685-1323264919750000-1430720793676080-1162594005547520-1484713419136891-1520664067522440-1467161849257750-1234704630304704-1163260961973045-1181292758996592-1306731239450567-1163661258240000-1199603778755827-1450433569965768-1164061646328555-1235837906627136-1164328622738125-1182376928191536-1307930487960799-1164729163886080-1200704627182203-1451764548153000-1165129796883715-1236971876190912-1165396936581605-1183461760537584-1309130469984375-1165797722685440-1201806148884611-1453096340331912-1166198600667035-1238106539208000-1166465903703165-1184547256237488-1310331185745551-1166866934837760-1202908344068875-1454428946751336-1167268057878195-1239241895890368-1167535524302485-1185633415494000-1311532635468583-1167936800542720-1204011212940819-1455762367660104-1168338168716875-1240377946449984-1168605798579245-1474409993300144-1204838806826133-1564671336000000-1295048692699272-1457096603307048-1529227066731295-1385458423400128-1511582231470500-1223801898987488-917956501678893-1350090569318400-1278232045560359-1458431653941000-1530628152714135-1440756092810240-1170748308963805-1188895876630704-1315141390651375-1171150320970240-1207323863740971-1459767519810792-1171552424994835-1243790263512000-1171820545470965-1189984692141168-1316345778464391-1172222802882560-1208429429421875-1461104201165256-1172625152340395-1244929091700288-1172893436454285-1191074172222000-1317550901360543-1173295939345920-1209535669819579-1462441698253224-1173698534311875-1246068614825664-1173966982113445-1192164317075952-1318756759564087-1174369730560000-1210642585139907-1463780011323528-1174772571108955-1247208833100096-1175041182648125-1193255126905776-1319963353299279-1537119308024320-1464951704816169-958658203125000-1320566926061323-1248349746735552-977081016398958-1339115886994736-1393563596915875-1466124023402496-1574905737303591-1593190118565056-1466626637050299-1303817067072000-1503183055059223-923748119053128-923853646045797-1250062421454336-1304561963493000-1630888721018640-1558582779550018-1395634665104064-1178267715502085-1341565675342000-1631820267045990-1360005515673600-1305754387806024-1577966719397688-1269773368281250-1396910187948352-1578507304086171-1233916687312736-1324797088041647-943798811904000-1579228275705567-1597562674203584-1270933552503090-1416344753795712-1525468450726500-1380343272605856-908224221095150-908327875993600-1289972785065399-1635363377010000-1562858887374706-1399463564659776-1472330955436317-1508856951875272-1454485889790000-1218270914816512-1236595130004964-1545920259925320-1491528504729718-1309784184000000-1218965983976367-1200909432070128-1328430123169271-909987427123200-1237724053938500-1474515921109896-946710770535036-1402020050978624-1529650837816836-1384127624916000-928928398229781-1329794221842944-1220635228501899-1475861589218664-1184468402381875-1257502114252224-1184738489805845-1203102372742512-1330855832842407-1185143697920000-1221748904368787-1477208075798088-1185548998417355-1258649295675456-1185819250078125-1204199843482416-1332069794228159-1186224704570880-1222863257422363-1478555381097000-1186630251474915-1259797174579392-1186900667422405-1205297981428464-1333284493612375-1187306368368640-1223978287868451-1479903505364232-1187712161754235-1260945751176000-1187982742038365-1206396786783408-1334499931219311-1188388689512960-1225093995912875-1481252448848616-1188794729454995-1262095025677248-1189065474125685-1207496259750000-1335716107273223-1189471668203520-1226210381761459-1482602211798984-1336324472287875-1208321302717056-933809108585943-1245220533880416-1336933021998367-1520247542848000-1520420566962123-1557234413943880-1557411634202495-1392667693657344-1227886231867375-1502957138863472-953203220988876-1228305432838144-1301785198900039-935191531503000-1357098954648014-1265547038728512-935510745812967-1229144120988808-1577886847656250-1302822202461696-1578245825438438-1321472373274944-1211487448903974-1376846855400000-1009802522538755-1230262965602856-1358952422367638-1193810162421760-1230682707313875-1598232386439672-1341198043810019-1267851874171968-1267996019228961-1213003645854000-1617522059513448-919151101414400-1323728043872904-919360078549200-1415975451650375-1471310539770880-974854019856969-919778127839600-1435016949537522-919987200000000-1232922942266467-1637949420835912-1417263336167679-1399016267832064-994150820526750-1528220246907528-1344250035003439-1491734564854272-1528741171882107-1547335500564000-1584356780749666-1418713139422656-1529435922640751-1400606420291744-1658801252103750-1235025630072832-1235165894198771-1567179468063720-1198567455673835-1272469936872000-1309501806568731-1401879409462048-922393807448350-1383747806476800-1605329699859375-1660874439309840-1513412952351606-1439751358870656-1292231230611230-1255452836076000-1347918531732343-923336664678400-1329755711381064-1496144966674824-1200746421086875-1274783167520064-1201018977304445-1219634582738352-1349142845503887-1201427888960000-1238535420036107-1497503760173928-1201836893419955-1275940833410496-1202109614623125-1220742082859376-1350367900413479-1202518773780480-1239659955588883-1498863376125000-1202928025770315-1277099199961152-1203200912009005-1221850253227824-1351593696685375-1203610318743040-1240785171621531-1500223814776872-1204019818337635-1278258267384000-1204292869661765-1222959094046448-1352820234543831-1204702524047360-1241911068339875-1501585076378376-1205112271321595-1279418035891008-1390829408978175-1650637968047000-1465339090723769-1279998183117312-1243037645949739-1020519677343320-1280433408609375-1317696723250496-1354968460913309-946729063334952-1410971790818164-1652509439488000-1262734530099588-1522881798677776-1207299159338155-1281739677005376-1467665289095875-1226289641230896-1356504299881119-929217772313600-1301052225771830-1524262366818000-1357118960280283-1468829310911552-1227262188580362-1562146938389856-985751941580875-1283482749763584-1544074353634259-1451222121803376-1525816503018918-1395721875000000-1563385473678084-930691940900400-1563739461104268-1210173462684160-1601333823435750-1489781468977280-1527198843959126-1285227402107328-1210858492364885-1527717436982000-1416093474183156-1211269634232320-1248680754575699-1528409076949008-1211680869156875-1286391381570624-1305182391128910-1268034913940576-951133779774309-1548098720064000-1324427029132031-1567105007046432-1231436072966022-1287556063601856-1586299193515625-951887167238376-1661324305041287-1400150726246400-1325625922006119-1624542219699000-1606050918419026-1438138427939136-1569055686360708-1270331558008672-1363892483667375-1401417830899200-1625828476345311-1682081671758480-1308433646017330-1439439714328000-1308729482089470-1271480919221984-953718478575357-1215660939816960-1309321288003750-1028868710063480-1290908439883287-1328476191780032-1366052412541877-1272630973500000-1497382092972080-1291637986493952-1254340916363259-1516613339836584-1217172898751875-1292221821645504-1217447934995045-1236317552785392-1367596614226167-1217860567040000-1255474997364227-1517984496242568-1218273292310555-1293390019695936-1218548494288125-1237435127906736-1368832813117199-1218961374958080-1256609761726603-1519356478833000-1219374348881715-1294558921586112-1219649716643605-1238553376316784-1370069756734375-1220062846013440-1257745209656211-1520729287856712-1220476068665035-1295728527528000-1220751602261165-1239672298218288-1371307445301951-1221164980405760-1258881341358875-1522102923562536-1221578451860195-1296898837733568-1221854151340485-1240791893814000-1372545879044183-1222267778334720-1260018157040419-1523477386199304-1222681498666875-1298069852414784-1222957364081245-1241912163306672-1373785058185327-1223371240000000-1261155656906667-1317773917544560-1600334504449295-1355730335774208-1224061240683125-1695045145771440-1695236280348870-1337503860887552-1657938179438552-1639282777947000-1545245321244742-1300413996052032-1225165781345805-1244154724793904-1376265653561375-1225580155338240-1263432710016571-1527605738183592-1225994622752835-1301587125432000-1226270986268965-1245277017193968-1377507070244791-1226685609410560-1264572263671875-1528983511032456-1227100326002395-1302760960135488-1227376855652285-1246399984302000-1378749233224143-1227791728017920-1265712502335179-1530362112056424-1228206693861875-1303935500374464-1228483389695445-1247523626320752-1379992142723687-1228898511360000-1266853426212307-1531741541504328-1229313726530955-1305110746360896-1229590588598125-1248647943452976-1381235798967679-1230005959636480-1267995035509083-1533121799625000-1230421424209315-1306286698306752-1230698452560005-1552748193089648-1268851692412125-1647798836232192-1363849071508296-1534502886667272-1307316235533351-1326412100720000-1004396462067393-1573099759410824-1383725352586031-1345966499649024-1668427871407000-1573807884432568-1555021274802966-1479332988871296-1403627647046866-1593486296892000-1707498801873990-1309229668134912-1575047614507011-1480331713381872-1556421196343750-1423716078283200-1594741339861572-949357550887600-1595100044566476-1234442406080000-1633445917414726-1519655430925440-1557821957826934-1310997569923776-1254138663962250-1254279662912496-1425478036852725-1235553182023680-1273713370491523-1597073881956000-1331044502015970-1483330583739264-1236247755246205-1255408034983344-1388713430623375-1236664624099840-1274859096628491-1541420764411752-1237081586656435-1313357247000000-1237359613756565-1256537083586928-1389962320357671-1237776732508160-1276005509625875-1542806830209096-1238193944990795-1314538146596928-1238472138723885-1257666808926000-1391211958630463-1238889507448320-1277152609689499-1544193726669864-1239306969931875-1315719753849024-1239585330347845-1258797211203312-1392462345666007-1240002949120000-1278300397025187-1545581454042888-1240420661679355-1316902068968256-1240699188828125-1259928290621616-1393713481688559-1622999229329920-1241256368201785-1012214946501000-1394339330640043-1318085092166592-1299128193488916-1604985514851936-1394965366922375-1242231833456640-1586412490296899-1586590498879576-1491180055670682-1510467203896000-1262050890343386-975330554034888-1702238385502223-1243347276520960-1281747884722875-1549749624123816-1243765739756995-1320453263648448-1244044767403685-1263325593750000-1397471385920823-1244463387115520-1282898423205059-1551140677634184-1244882100726875-1321638412355904-1245161295306045-1264459383759792-1398725520133967-1245580165440000-1284049649988427-1552532563300968-1245999129501555-1322824269990336-1246278491063125-1265593851924336-1399980404455399-1246697611694080-1285201565278803-1553925281373000-1247116826280715-1324010836763712-1439303486393775-1708164861541336-1516406124515625-1670153356442112-1670340488470671-1555318832099112-1651511176133954-1478844270904000-1594257471015903-1613646139036512-1709888024171143-1248934508789760-1287507462203875-1556713215728136-1249354224651195-1326386098575168-1249634087459485-1269001327374000-1403749560311983-1250053960030720-1288661444250219-1558108432508904-1250473926641875-1327574794037184-1250753956632245-1270138510185072-1405007447309127-1251174080000000-1289816115626867-1559504482690248-1251594297435755-1328764199486016-1251874494658125-1271276372164656-1406266085535839-1252294868897280-1290971476539643-1560901366521000-1252715337232515-1329954315133632-1252995701736805-1272414913515504-1407525475216375-1253416326922240-1292127527194371-1562299084249992-1408155451921907-1273269265488000-1022588179040033-1312146683968864-1408785616574991-1254538454274560-1293284267796875-1563697636126056-1254959424633395-1332336677873088-1255240123851285-1274694035142000-1410046509835943-1255661251153920-1294441698552979-1565097022398024-1256082472636875-1333528925388864-1256363339286445-1275834615823152-1411308155223487-1256784717760000-1295599819668507-1566497243314728-1257206190441955-1334721883951296-1257487224573125-1276975876686576-1412570552961879-1257908854292480-1296758631349283-1567898299125000-1258330578248315-1335915553772352-1258611779911005-1278117817935024-1413833703275375-1259033660951040-1297918133801131-1356185349449840-1491970522948983-1395245149632000-1298498144130527-1589384182746096-1550791897411760-1298933265256448-1318467555994500-1648268492541160-1027858651187239-1357700753082240-1008690321231268-1280403742398000-1746200049687990-1455329175513600-1377865433443807-1688558810139288-1358762207031250-1514218332851328-1281404690816778-1631060742204768-1747760143449510-1262412103680000-1612183065534803-1748345418087120-1670827625835282-1496140520883008-1496307482217625-1477039722778656-971845092305150-1496808440748544-1341445534702461-1574916110289000-1419527198815883-1341894579175872-1264244614357205-1283837737048944-1420160751318375-1264667753123840-1303726014830291-1576322180686152-1265090986295435-1343092521000000-1265373194195565-1284983764865328-1421428421791871-1265796584732160-1304889666230875-1577729087718696-1266220069701795-1344291175566528-1266502445482885-1286130474486000-1422696846410263-1266926087864320-1306054009843299-1579136831635464-1267349824706875-1345490543087424-1267632368418845-1287277866113712-1423966025397807-1268056262720000-1307219045873387-1580545412685288-1268480251510355-1346690623774656-1268762963203125-1288425939951216-1425235958978759-1269187109498880-1308384774526963-1581954831117000-1269611350311915-1347891417840192-1269894230035405-1289574696201264-1426506647377375-1270318628400640-1309551196009851-1583365087179432-1270743121311235-1349092925496000-1271026169115365-1290724135066608-1427778090817911-1271450819624960-1310718310527875-1584776181121416-1428414095748979-1291586662303872-1546162210319571-1291874256750000-1429050289524623-1624991472612864-1390207677587567-1625353251789112-1273008680701875-1351498082426304-1273292064817045-1293025061454192-1430323243721767-1273717219840000-1313054619492627-1587600883639368-1274142469492555-1352701732124736-1274426021838125-1294176549381936-1431596953633599-1274851429230080-1314223814351003-1589014492713000-1275276931279715-1353906096261312-1275560651905605-1295328720735984-1432871419484375-1275986311741440-1315393703067811-1590428940661512-1276412066263035-1355111175048000-1276695955219165-1296481575719088-1434146641498351-1277121867573760-1316564285848875-1591844227733736-1277547874642195-1356316968696768-1277831931978485-1297635114534000-1435422619899783-1278258096926720-1317735562900019-1593260354178504-1278684356616875-1357523477419584-1278968582383245-1298789337383472-1436699354912927-1279395000000000-1318907534427067-1594677320244648-1279821512386755-1358730701428416-1280105906633125-1299944244470256-1437976846762039-1280532576993280-1320080200635843-1379341467070000-1753928945407459-1379647896600960-1281243904927805-1616517978057008-1439255095671375-1281670828106240-1636776800354779-1597513772236392-1597691162076579-1518961475416000-1381027391118270-1341718418596064-1045867224641851-1480165100236800-1401378520484375-1717372759301112-1697821293906738-1520311063498304-1362507889031841-1342910439036000-1441813865567743-1362961621396992-1738462813554456-1639868489050232-1304136521679750-1541423287767168-1679942544870505-1502232949434272-1779157463428710-1561878163456000-1720233881003127-1740199732311744-1621729649577574-1562571407193536-1523181591941625-1503566785493536-1602663410658663-1028984462198784-1662390038286516-1761537183625000-1286658607887315-1544161566839424-1029555211249604-1623709416984048-1445657703970375-1287372202455040-1327130797730931-1049936289992936-1287800485814635-1367201315304000-1288086060818765-1308047769753648-1446940499950431-1288514502479360-1328308332474875-1606043305003176-1288943039134595-1368414269231808-1289228783018085-1309208158038000-1448224054560503-1289657478021120-1329486563547139-1607467838859144-1290086268046875-1369627940353344-1290372180859645-1310369232384432-1449508368024847-1290801129280000-1330665491153547-1608893214824808-1291230172751155-1370842328880576-1291516254543125-1311530992995696-1450793440567719-1291945456455680-1331845115499923-1610319433149000-1292374753447115-1372057435025472-1292661004268205-1312693440074544-1452079272413375-1293090459747840-1333025436792091-1611746494080552-1293520010334435-1373273259000000-1293806430234565-1313856573823728-1453365863786071-1294236139356160-1334206455235875-1613174397868296-1454009444365139-1314729374884992-1334797225953943-1633813217342000-1594140509490480-1375098341356032-1355319337768996-1694336633391240-1056585620531375-1395644844782720-1036879449351876-1316184902144112-1794996155354310-1495995609600000-1416365843171831-1655934777847384-1715977634648562-1536568522922048-1397034980468750-1017952347775176-1776623117267087-1417462829281792-1737083156888943-998434054850000-1557729364549098-1577874713873472-1298394900506405-1797976335789360-1038945631639500-1498644951859200-1418874072085063-1738812553710264-1399199248063330-1559280086832000-1419501591659691-1339677739868296-1459810221404111-1379973131536896-1340122011932875-1620326568359016-1300405762858995-1380583289139648-1300693198281685-1320849807750000-1461101374648423-1301124430827520-1341307217608659-1621759534509384-1301555758676875-1381804143856704-1301843363528045-1322017753868592-1462393288989567-1302274850240000-1342493121876827-1623193345257768-1302706432283555-1383025718099136-1302994206613125-1323186388279536-1463685964651799-1303425947566080-1343679724943203-1624628000853000-1303857783878715-1384248012078912-1304145727736605-1324355711185584-1464979401859375-1304577723005440-1344867027013611-1626063501543912-1305009813662035-1385471026008000-1305297927098165-1325525722789488-1466273600836551-1305730176757760-1346055028293875-1627499847579336-1306162521833195-1386694760098368-1306450804897485-1326696423294000-1467568561807583-1306883309022720-1347243728989819-1628937039208104-1307315908591875-1387919214561984-1307604361334245-1327867812901872-1468864284996727-1710510080000000-1308181394104065-1771271688243904-1308469974137755-1389144389610816-1489971325369250-1369313827931488-1490299959266982-1309191609889280-1349623229452043-1631813960241000-1309624718670515-1390370285456832-1309913510918805-1330212660238704-1471458018926375-1310346778890240-1350814029629971-1633253690142792-1310780142389835-1391596902312000-1311069104465965-1331386118373168-1472756030115391-1311502627202560-1352005530046875-1634694266633256-1311936245495395-1392824240388288-1312225377449285-1332560266422000-1474054804419543-1312659155025920-1353197730908579-1636135689961224-1313093028186875-1394052299897664-1313382330068445-1333735104587952-1475354342063087-1313816362560000-1354390632420907-1637577960375528-1314250490663955-1395281081052096-1314539962523125-1334910633073776-1476654643270279-1314974250004480-1355584234789683-1639021078125000-1315408633126315-1396510584063552-1315698275013005-1336086852082224-1477955708265375-1316132817559040-1356778538220731-1640465043458472-1316567455773635-1397740809144000-1316857267737765-1661448916195696-1357674725989949-1053833652338688-1357973542919875-1641909856624776-1479908738350899-1398971756505408-1318016940897085-1500676679142000-1480560130516303-1480723008418304-1764891413001279-1683932197326392-1663826856593750-1603131459165504-1420652471205310-1380214189248736-1035274491770589-1522629926400000-1441581517061911-1685414423190744-1340356437696342-1401435818918976-1685970482052375-1543949946093856-1828562807601270-1645887466501632-1442850096038399-1016203324450000-1748061869072706-1565297216643776-1463815434438504-1036983241137384-1037097224566125-1484635662614528-1464459129149256-1769749266120504-1424092684832930-1485288441000000-1098827259402654-1668772903543856-1567190651728779-1648784305027584-1445389486231375-1099431099105264-1486431263551339-1405137334945728-1323825520200885-1833190550190000-1629681718498480-1324261850296320-1365158309270899-1650596554046664-1324698276256875-1406372620444224-1324989280160845-1345521487294512-1488391751501407-1325425865920000-1366358228609787-1652047309010088-1325862547572355-1407608629707456-1326153721953125-1346703930130416-1489699700679159-1326590563450880-1367558850863363-1653498913797000-1327027500869915-1408845362947392-1327318845777405-1347887065516464-1491008415887375-1327755943088640-1368760176237451-1654951368656232-1328193136349235-1410082820376000-1328484651833365-1349070893655408-1492317897350311-1328922005032960-1369962204937875-1656404673836616-1329359454209995-1411321002205248-1329651140320685-1350255414750000-1493628145292223-1330088749483520-1371164937170459-1657858829586984-1330526454651875-1412559908647104-1330818311439045-1351440629002992-1494939159937367-1740873461760000-1659131913797361-1741255260163880-1679983373934054-1413799539913536-1331986165388125-1516581268328304-1639727059189040-1332424286702080-1701589829605947-1722279682452000-1599435004893258-1620118142044992-1599785642841126-1394837778334432-1518078058593750-1333593079869440-1374777357119411-1662226402746312-1334031553461035-1416280977768000-1334323922577165-1355000432739888-1498876806334751-1334762556341760-1375982905538875-1663683963264936-1335201286224195-1417522784779968-1335493826216485-1356188421654000-1500190890035383-1335932716318720-1377189158519619-1665142375597704-1336371702566875-1418765317464384-1336664413485245-1357377104740272-1501505741560527-1337103560000000-1378396116267467-1666601639993448-1337542802688755-1420008576033216-1337835684583125-1358566482201456-1502821361134439-1338275087585280-1379603778988243-1668061756701000-1338714586789515-1421252560698432-1339007639709805-1359756554240304-1504137748981375-1339447299274240-1380812146887771-1442797417504240-1752159995090015-1649272199040000-1340180279064965-1360947321059568-1505454905325591-1340620195266560-1382021220171875-1670984548046856-1341060207726395-1423742709165888-1341353602848285-1362138782862000-1506772830391343-1341793775761920-1383230999046379-1672447223182824-1342234044961875-1424988873392064-1342527611259445-1363330939850352-1508091524402887-1342968040960000-1384441483717107-1673910751625928-1343408566974955-1426235764562496-1343702304498125-1364523792227376-1509410987584479-1344142991060480-1385652674389883-1675375133625000-1344583773965315-1427483382889152-1344877682764005-1365717340195824-1510731220160375-1345318626263040-1386864571270531-1676840369428872-1345759666132635-1428731728584000-1346053746256765-1698284089160496-1387773957503749-1802231697980928-1408794744334500-1844065121931944-1346936243676595-1429980801859008-1036331150135450-1368106523718000-1513373994392103-1389138782089216-1410026163351556-1679773403446344-1078490805437500-1493458020444672-1348407929721645-1535278179032048-1556195071742925-1722377238336000-1722565277628203-1722753330605944-1785216387532482-1619326497040512-1370348912402250-1744270808049504-1059137154705453-1557724640870400-1474806939912999-1807355030163000-1454352405223970-1620740961800064-1475450843243147-1413262051945312-1538129465115750-1351207085795840-1392934655995691-1829725729039296-1351649411612435-1434984375000000-1726328938097583-1580907375080608-1040184099626350-1518834446364672-1810315210698375-1061335013981016-1103076295520679-1623572361879936-1644566734225091-1415730811068000-1540816251303494-1686753062419968-1728589763659851-1520491718110312-1624812135638250-1645822493803584-1646001940195627-1583668181923232-1813080960424233-1083798716416000-1813476297333207-1688593022692488-1459436993326690-1543001567502976-1647437980921875-1585049789855776-1689513504386823-1689697640858112-1731607267021787-1794391012822000-1878055700606190-1627825641995904-1544515688504338-1419439337832672-1064695500124125-1085690162266112-1816641061654311-1044160334243600-1378441798260054-1524806265672000-1357852112592365-1546030799702512-1671566709760560-1818026803051008-1400242105542875-1693014385554216-1442354513146287-1630665284866176-1442668694560281-1380094245750000-1526634105456023-1359479759339520-1401462492972259-1694489886424584-1359923888626875-1443768688797504-1360220028550045-1381296854857392-1527964360565167-1360664319040000-1402683589285227-1695966244334568-1361108706265555-1445026509567936-1361405018163125-1382500162394736-1529295388208199-1361849566638080-1403905394687603-1697443459533000-1362294211876715-1446285060674112-1362590695798605-1383704168564784-1530627188609375-1363035502333440-1405127909385211-1698921532268712-1363480405660035-1447544342328000-1363777061656165-1384908873570288-1531959761992951-1364222126325760-1406351133583875-1700400462790536-1364667287815195-1448804354741568-1364964115935485-1386114277614000-1533293108583183-1365409438814720-1407575067489419-1701880251347304-1365854858541875-1450065098126784-1366151858836245-1723640473237744-1408493483787533-1829138112000000-1513934018121672-1703360898187848-1451168848380663-1472360291140480-1472520312908750-1598910090237216-1073069427894693-1409871857160704-1494205666154559-1852174463128000-1810276272611266-1621004868939456-1621180994925569-1600300547517344-1052943691668750-1621709449428992-1495504928282023-1748456243461656-1369421704147835-1453851716232000-1770098685941124-1601691810684448-1875869131549663-1370165577730560-1749786060546875-1665639892359704-1560389081625342-1455115385623488-1771637177451876-1603083879972000-1898594935253190-1877703290417152-1835706998726919-1793701558468840-1899419604558750-1625235414530112-1414319399178151-1900038263226480-1836903028876353-1541476741312000-1816183409272006-1562932088103312-1119518799485471-1563271364242816-1711334090251125-1056493709106800-1859630710874024-1542815603490816-1416162493910083-1796819005625000-1374187150404315-1458910786834752-1543652785907621-1078559358835464-1882396016237375-1417238371599872-1840494236128191-1756064280867896-1565817500461246-1671797296584000-1693142912462480-1777992878048352-1905198977092230-1376126266511360-1418622443409875-1715237000987976-1376574013747595-1461444717292608-1376872565855085-1398206809758000-1546669150187903-1377320474949120-1419853485704539-1716725383579944-1377768481171875-1462712782052544-1378067205952645-1399419916603632-1548011016852247-1378515374080000-1421085239970147-1718214626944008-1378963639364155-1463981580115776-1379262536868125-1400633724920496-1549353659414319-1379710964103680-1422317706412523-1719704731329000-1380159488524115-1465251111694272-1380458558801205-1401848234911344-1550697078098375-1380907245219840-1423550885237491-1721195696983752-1381356028851435-1466521377000000-1381655271951565-1403063446778928-1552041273128671-1382104217628160-1424784776650875-1488742304827120-1637793862492711-1531609436081664-1723247181508149-1404279360726000-1553386244729463-1064078370406400-1447303252214596-1724180213097864-1468905102810375-1660681167420288-1469223127946097-1405495976955312-1554731993125007-1384500237120000-1427254698066187-1725673764054888-1384949798834355-1470336577400256-1385249560703125-1406713295669616-1556078518539559-1385699284602880-1428490728479763-1727168177277000-1386149105827915-1471609779734592-1386449040719405-1407931317071664-1557425821197375-1386899024176640-1429727472305051-1728663453013032-1387349104987235-1472883716856000-1387649212951365-1409150041364208-1558773901322711-1388099456040960-1430964929747875-1730159591511816-1388549796511995-1474158388976448-1388850077598685-1410369468750000-1560122759139823-1389300580395520-1432203101014059-1731656593022184-1389751180601875-1475433796307904-1390051634861045-1411589599431792-1561472394872967-1818349288960000-1732967177478561-1134039336580584-1412352538340502-1476709939062336-1498273414548750-1091717153245896-1113243644586476-1905565180866048-1862944745791983-1777484128939000-1413573812310726-1477986817451712-1135387875162601-1456881425176032-1564174000984375-1392908110397440-1435921899811011-1736152778111112-1393359490259035-1479264431688000-1393660464335165-1415254213280688-1565525971811151-1394112006709760-1437162928428875-1737653234156136-1394563646606195-1480542781983168-1394864794054485-1416477159174000-1566878721450983-1395316596510720-1438404671899219-1739154554456904-1395768496516875-1481821868549184-1396069817387245-1417700809377072-1568232250128127-1396521880000000-1439647130427867-1740656739262248-1396974040190755-1483101691598016-1397275534533125-1418925164092656-1569586558066839-1397727857377280-1440890304220643-1505570187870000-1656305867580287-1548920610095616-1441512159405399-1764429065589808-1721579885470000-1441978668191232-1463658584430884-1829770552931720-1141038801695727-1507194903760000-1119751240850372-1593663986402352-1938448988169030-1917117363367936-1874238141234375-1831349642857960-1939285157245470-1659345069501504-1400896850846285-1422602457342000-1142516033751123-1530705335280128-1875855199612719-1789801884765432-1768428597445750-1682345094538368-1509959602567710-1100231988468072-1121926061917388-1402558709760000-1791152581498643-1791345593630104-1683614606396346-1705383145779136-1424903988824250-1640975317371936-1943469609698070-1922082556953088-1533511948714479-1576879323625000-1944307221844590-1555613329982976-1771861574317114-1426286098503024-1080636152568750-1923739524583424-1469981757841924-1772815966842384-1405432288050635-1492081092264000-1146214690754193-1427515390483248-1579088551799231-1709060652734976-1882332734247375-1947450410810640-1861097407009218-1688153790650496-1493527582037721-1428745388598000-1580449101903703-1407400680325120-1450861468770339-1754215346273544-1407855185546875-1494653275738944-1408158243383645-1429976093050032-1581810433288047-1408612911680000-1452111089202347-1755726189810408-1409067677835155-1495940475274176-1409370909643125-1431207504042096-1583172546176519-1409825838919680-1453361426956723-1757237900589000-1410280866083115-1497228413623872-1410584271912205-1432439621776944-1584535440793375-1411039462243840-1454612482239291-1758750478858152-1411494750490435-1498517091000000-1411798330390565-1433672446457328-1585899117362871-1412253781852160-1455864255255875-1760263924866696-1412709331256795-1499806507614528-1413013085277885-1434905978286000-1587263576109263-1848382274234880-1761588902137257-1152768477281032-1435677294867750-1501096663679424-1610044795711762-1610217819582768-1915059396145192-1501742019072000-1806637407329763-1959214912330320-1872339847834162-1676577421366848-1676757550015625-1655159279986976-1089037562349150-1677298013371904-1546765607112319-1786597243074000-1677838592852807-1656226359719168-1852557385895145-1089856680825200-1852955343156875-1177298053300224-1504486843070757-1591874402010056-1155868537862007-1657649845984000-1505133169704849-1614374112185712-1592729237348911-1767464651119104-1462133893552875-1767844179709416-1942654602833947-1680904070645184-1615587709999826-1484753471500000-1594097610343623-1419554332651520-1463389977295859-1769362837379784-1420011450576875-1507558543178304-1420316250372045-1442322030726192-1595466766860767-1420773531840000-1464646780213627-1770882364531368-1421230911447555-1508853140396736-1421535885713125-1443560518269936-1596836707124599-1421993428910080-1465904302512003-1772402761413000-1422451070274715-1510148478549312-1422756219060605-1444799714583984-1598207431359375-1423214024061440-1467162544396811-1773924028273512-1423671927258035-1511444557848000-1423977250614165-1446039619871088-1599578939789351-1424435317493760-1468421506073875-1534336192287920-1600264988147619-1578512742787584-1469051256898823-1798136048718000-1951844653491119-1513390066908672-1469681187749019-1776969172926504-1864920578489375-1689579687483072-1843375359501732-1667994521535392-1953518679475911-1558592000000000-1558758997964071-1778493051216648-1427338689141755-1515337244740416-1427644536508125-1449763591598256-1603698172493039-1428103389473280-1472202711916843-1780017800481000-1428562340746515-1516636290743232-1428868362882805-1451006334805104-1605072819946375-1429327478026240-1473464554821171-1781543420968392-1429786691505835-1517936078952000-1430092888461965-1452249787998768-1606448252716191-1430552265858560-1474727118546875-1783069912927656-1431011741619395-1519236609578688-1431318113445285-1805856121414000-1475674514503997-1916379454242816-1850495431002708-1894757602324144-1542409606001250-1696832130120512-1542739733265710-1851485777473248-1146280502812588-1521188798016000-1565448702377391-1786125512257128-1433463940707955-1521839898933696-1433770662423125-1455984409528176-1610579265167079-1434230827028480-1478519136710483-1787654620125000-1434691090082315-1523142658085952-1434997986817005-1457230704696624-1611957841445375-1435458413975040-1479784585779931-1789184600460072-1435918939609635-1524446160504000-1436226011413765-1458477710865648-1613337204161431-1436686701199360-1481050756699875-1790715453511176-1437147489489595-1525750406399808-1437454736413085-1459725428238000-1614717353539503-1437915688901120-1482317649676139-1792247179527144-1438376739921875-1527055395985344-1660020186939975-1615925629730296-1217608300537145-1439145377280000-1483585264914547-1793779778756808-1439606691106155-1528361129472576-1439914288418125-1462222997403696-1617480013178719-1440375766535680-1484853602620923-1795313251449000-1440837343242115-1529667607073472-1441145115823205-1463472849602544-1618862523888375-1441606856867840-1486122663001091-1796847597852552-1442068696529435-1530974829000000-1442376644429565-1464723413815728-1620245822157071-1442838648476160-1487392446260875-1798382818216296-1443300751167795-1532282795464128-1443608874436885-1465974690246000-1621629908209063-1444071141560320-1488662952606099-1799918912789064-1622322246723875-1466913615083136-1133645109358263-1822917995240624-1623014782268607-1156243469056000-1867977183707124-1979377450394472-1445766965296355-1735105436268672-1779785156250000-1468479380568816-1780164870750640-1669082576486400-1580233367338919-2003326361730000-1914493796399826-1758850463361472-1714505425605049-1692419581967904-1113552668018750-1492319688023552-1581582024882063-1514916126036896-1648760970071806-1537522110936000-1448544812469365-1470986922193008-1627174134735111-1449008132648960-1493752212957875-1806072038147016-1449471551613995-1538833803267648-1449780552476685-1472241762750000-1628562163067423-1450244136107520-1495026337817659-1807612507497384-1450707818551875-1540146241408704-1451016995083045-1473497316740592-1629950980528567-1451480842240000-1496301186997827-1809153852549768-1451944788238555-1541459425571136-1452254140488125-1474753584367536-1631340587342799-1452718251246080-1497576760704203-1810696073553000-1453182460873715-1542773355966912-1453491988891605-1476010565833584-1632730983734375-1453956363325440-1498853059142611-1812239170755912-1454420836657035-1544088032808000-1454730540493165-1477268261341488-1634122169927551-1455195178677760-1500130082518875-1813783144407336-1455659915788195-1545403456306368-1455969795492485-1478526671094000-1635514146146583-1456434697502720-1501407831038819-1815327994756104-1636210430585875-1479470947253376-1771070316508467-1479785795293872-1636906912615727-1121288400000000-1569970766322070-1839304261829456-1637603592264171-1772389666459456-1480888115198250-1884967170728544-1189451025844379-1548695283068928-1863121445666307-1751071425558000-1841065734950342-1684080661809600-1886370919406148-1122959233217200-1886772118423500-1460157476810240-1932106073710918-1797499070098560-1842632432651638-1550672621112000-1460933853460965-1483567456605168-1641089955766391-1461399811522560-1506526080671875-1821516168101256-1461865868650395-1551991781076288-1462176628444285-1484829440622000-1642485885478543-1462642850705920-1507807457997579-1823065405669224-1463109172061875-1553311688969664-1463420108023445-1486092140099952-1643882606562087-1463886594560000-1509089561701907-1824615521427528-1464353180218955-1554632345004096-1464664292398125-1487355555241776-1645280119241279-1465131043284480-1510372391990683-1826166515625000-1465597893321315-1555953749391552-1465909181768005-1488619686250224-1646678423740375-1466376197079040-1511655949069731-1827718388510472-1466843311568635-1557275902344000-1467154776332765-1489884533328048-1648077520283631-1467622056143360-1512940233144875-1829271140332776-1468089435160595-1558598804073408-1468401076292085-1491150096678000-1649477409095303-1468868620677120-1514225244421939-1830824771340744-1650177650671875-1492099739366016-1786187668704707-1492416376502832-1650878090399647-1560584561088000-1877424053699403-1990733046875584-1855198023577334-1787514514814016-1470895793193125-2036840963189040-1176966265066956-1697727538790400-1607352521011399-1969781684643000-1585049889231970-1766385743700864-1608034445352747-1517601860424328-1653681831383375-1563234859805184-1518084643522891-1835490941966952-1473080986968435-1563897903000000-1473393334068565-1496219516854128-1655084891511271-1473861937500160-1519372565665875-1837048092205896-1474330640278795-1565224551793728-1474643163995885-1497488664606000-1656488745028863-1475112032376320-1520661216039899-1838606122874664-1475581000131875-1566551950636224-1475893700515845-1498758529846512-1657893392160407-1476362833920000-1521950594850787-1840165034222088-1476832066727355-1567880099739456-1477144943828125-1500029112778416-1659298833130159-1477614342330880-1523240702304363-1841724826497000-1478083840264915-1569208999315392-1478396894132405-1501300413604464-1660705068162375-1478866557808640-1524531538606451-1843285499948232-1479336320944235-1570538649576000-1479649551628365-1502572432527408-1662112097481311-1480119480552960-1525823103962875-1844847054824616-1480589508964995-1571869050733248-1480902916515685-1503845169750000-1663519921311223-1937180221767680-1481529864293505-2005975743716032-1481843404526875-1573200202999104-1687378725931682-1550728280792416-1687735780148646-1482627448640000-1528408422662027-1847972809848168-1483098007829555-1574532106585536-1483411769263125-1506392799905136-1666337953400999-1483882494382080-1529702176416403-1849537010493000-1484353319072715-1575864761704512-1484667257522605-1507667693243184-1667748162109375-1485138248189440-1530996660048411-1851102093558312-1485609338456035-1577198168568000-1485923453972165-1508943305691888-1669159166225751-1486394710261760-1532291873763875-1852668059292936-1486866066179195-1578532327387968-1487180358811485-1510219637454000-1670570965974383-1487651880798720-1533587817768619-1854234907945704-1488123502441875-1579867238376384-1488437972240245-1511496688732272-1671983561579527-1488909760000000-1534884492268467-1855802639765448-1489381647443755-1581202901745216-1489696294458125-1512774459729456-1673396953265439-1490168348065280-1536181897469243-1857371255001000-1490640501384515-1582539317706432-1490955325664805-1881096090199408-1537155431016125-1193142116155392-1537480033576771-1858940753901192-1675518533936307-1583876486472000-1492215066059965-1699008787351152-1239948093040218-1492687651586560-2021082735375000-2021296049764288-1791792404257674-1769007383123904-1792170619011942-2068107399630000-1172051195336541-1631851293667328-1586050991852853-1264376940777720-1586385707688375-1632540129155776-1678704266010069-1563889494809696-1840064093481520-1587222703296000-1541378829398107-1863654555077928-1679767073364411-1656931316571648-1495998544373125-1519174117595376-1680475860755479-1496471928340480-1542679891190883-1865227591125000-1496945412160315-1589232693817152-1497261123519005-1520456211163824-1681894033635375-1497734773783040-1543981684919531-1866801512080872-1498208523927635-1590573629784000-1498524412851765-1521739025870448-1683313004165831-1498998329487360-1545284210789875-1868376318194376-1499472346031595-1591915319827008-1499788412571085-1523022561918000-1684732772571103-1500262595653120-1546587469007739-1869952009714344-1500736878671875-1593257764158144-1501053122876645-1524306819509232-1686153339075447-1501527572480000-1547891459778947-1871528586889608-1502002122048155-1594600962989376-1502318543968125-1525591798846896-1687574703903119-1502793260167680-1549196183309323-1873106049969000-1503268076360115-1595944916532672-1734905395436775-1873895113800504-1688996867278375-1203247727132672-1573643455324164-2082982665779280-1504534741807435-1805631750000000-1852124946840080-1528163923572528-1852514881562160-1644280009132544-2038195358111000-2084737372039440-1992292033826498-1783984084383424-1575632261983572-1181848553601000-2062658624117959-1738378373529600-2039911913749336-1715560963295056-1715741466324750-1599981307554624-1507387340186845-1530738937716912-1693268150932207-1507863123520000-1554422409138987-1879424766304488-1508339006958355-1601328282065856-1508656318203125-1532027528828016-1694693510740359-1509132368506880-1555730799552563-1881006662637000-1509608518943915-1602676012348992-1509926008203405-1533316842902064-1696119670217375-1510402325552640-1557039923960251-1882589446366632-1510878743063235-1604024498616000-1511196410387365-1534606880141808-1697546629587511-1511672994856960-1558349782567875-1884173117742216-1512149679515995-1605373741078848-1512467524954685-1535897640750000-1698974389075023-1512944376619520-1559660375581259-1885757677012584-1513421328501875-1606723739949504-1513739352105045-1537189124929392-1700402948904167-1514216471040000-1560971703206227-1887343124426568-1514693690220555-1608074495439936-1515011892038125-1538481332882736-1701832309299199-1515489278318080-1562283765648603-1888929460233000-1702547289779003-1539450963946368-1842869637712843-1539774264812784-1703262470484375-1166740614348800-1633608349522310-1913856396837264-1703977851443347-1844224404248000-1540906174298106-1961359172082912-1237654136058211-1611454695768576-1938619969434875-1822026842536368-1915665144756246-1752316634510400-1962800590839396-1168456288950000-1963212554441964-1519311979294720-2010377541771702-1870314864686720-1917273877079750-1613485087838784-1520109183591245-1543657406490672-1707557761023327-1520587640000000-1567539367708667-1895283692359848-1521066196794755-1614839629607616-1521385290433125-1544953236355056-1708991127611639-1521864014561280-1568855107325443-1896874473861000-1522342839103515-1616194929268032-1522662111255805-1546249791209904-1710425296111375-1523141103178240-1570171582994571-1898466145247592-1523620195542835-1617550987032000-1523939646258965-1547547071257968-1711860266746791-1524418906050560-1571488794921875-1900058706768456-1524898266312395-1618907803111488-1525217895642285-1548845076702000-1713296039742143-1525697423377920-1572806743313179-1901652158672424-1526177051611875-1620265377718464-1526496859605445-1550143807744752-1714732615321687-1526976655360000-1574125428374307-1903246501208328-1527456551640955-1621623711064896-1527776538348125-1551443264588976-1716169993709679-1528256602196480-1575444850311083-1904841734625000-1716888984026923-1552418333651328-1858392271285083-1552743447437424-1717608175130375-1623662634184704-1953305907079619-2071191748235456-1930176171204678-1859754633784000-1530338040970765-2119151395217520-1224526743972844-1766329201420800-1672299989553375-2049370791769752-1649091599187410-1837751517703296-1673000160503939-1578911840321000-1720486947966903-1626383855910912-1579407539433539-1909632782647944-1532581703046875-1627064636084544-1532902405107645-1556648354035632-1721927539831247-1533383542080000-1580729910931147-1911231582076008-1533864779719155-1628426766307776-1534185660743125-1557951442928496-1723368935625319-1534667066183680-1582053020333523-1912831273629000-1535148572319115-1629789656542272-1535469632356205-1559255258839344-1724811135573375-1535951306339840-1583376867846491-1914431857555752-1536433081046435-1631153307000000-1536754320146565-1560559801970928-1726254139899671-1537236262748160-1584701453675875-1916033334105096-1537718306100795-1632517717892928-1538039724313885-1561865072526000-1727697948828463-1538521935608320-1586026778027499-1917635703525864-1539004247681875-1633882889433024-1539325845057845-1563171070707312-1729142562584007-1539808325120000-1587352841107187-1919238966066888-1540290905989355-1635248821832256-1540612682578125-1564477796717616-1730587981390559-2015278641169920-1541256370191785-2086841910296000-1541578281222915-1636615515302592-1755394116053938-1613233288661472-1755760701437750-1542383254896640-1590007184274051-1922448171505032-1542866373582235-1637982970056000-1543188508746365-1567093433036208-1733481235053711-1543671795560960-1591335464772875-1924054114899816-1544155183266995-1639351186304448-1544477497793685-1568402343750000-1734929070358823-1544961053675520-1592664484823059-1925660952410184-1545444710476875-1640720164259904-1545767204416045-1569711983103792-1736377711611967-1546251029440000-1593994244630427-1927268684284968-1546734955411555-1642089904134336-1547057628813125-1571022351300336-1737827159037399-1547541723054080-1595324744400803-1928877310773000-1548025918270715-1643460406139712-1548348771184605-1572333448542384-1739277412859375-1548833134717440-1596655984340011-1930486832123112-1549317599254035-1644831670488000-1549640631730165-1573645275032688-1740728473302151-1550125264629760-1597987964653875-1932097248584136-1550609998561195-1646203697391168-1550933210649485-1956765789998000-1598987435883957-1241134490392576-1599320685548219-1933708560404904-1742906576870875-1647576487061184-1552226508142245-1767334282213808-1289810723385546-1552711680000000-2102351715763288-2102570710733504-1863836343534906-1840132653009728-1864224629289750-2151252452755440-1219170018171093-1697452670397952-1649808897659901-1315202011255000-1745813540228363-1698159844116288-1746177137757181-1626745328365792-1914017299470000-1651011799732224-1603323293772371-1938547870513992-1244629426417468-1723512453696000-1556110714057965-1580215353304368-1747995882676991-1556596694914560-1604658979046875-1940162766262056-1557082776943395-1653075277649088-1557406887841285-1581531559542000-1749451787553943-1557893138513920-1605995405930979-1941778558614024-1558379490386875-1654451884332864-1558703781196445-1582848496447152-1750908500621487-1559190301760000-1607332574630507-1943395247818728-1559676923551955-1655829255055296-1560001394323125-1584166164222576-1752366022103879-1560488184852480-1608670485351283-1945012834125000-1560975076638315-1657207390028352-1561299727421005-1585484563071024-1753824352225375-1561786787991040-1610009138299131-1946631317781672-1562273949845635-1658586289464000-1562598780689765-1586803693195248-1755283491210231-1563086111375360-1611348533679875-1948250699037576-1563573543373595-1659965953574208-1804498331918175-1756560901519000-1203248931015550-1756925989691904-1612688671699339-1949870978141544-2046373505859375-1733578833987072-1565199048538645-2167423838293680-2167649009589510-1710211866112000-2119919412322008-2096047129812216-1975789863993734-1662727576666176-1566500263518125-1783585530613744-1928400836808240-1566988404999680-2001131457427627-2025451794996000-1880971977453738-1905284831154752-1881362639360646-1640332607186912-1785253183285750-1568290611363840-1616713543648291-1954737205030152-1568779124685435-1665492261000000-1569104856585565-1593410320049328-1762591326933871-1569593538972160-1618056654280875-1956361078014696-1570082322811795-1666875751662528-1570408235072885-1594733842086000-1764055323808263-1570897188024320-1619400508581299-1957985850091464-1571386242456875-1668260008271424-1571712335128845-1596058096817712-1765520131115807-1572201558720000-1620745106755387-1959611521509288-1572690883820355-1669645031038656-1573017156953125-1597383084447216-1766985749080759-1573506651258880-1622090449008963-1961238092517000-1573996247101915-1671030820176192-1574322700745405-1598708805177264-1768452177927375-1574812465840640-1623436535547851-1696303573277040-2060010742501615-1939034638720000-1575628966705365-1600035259210608-1769919417879911-1576119002664960-1624783366577875-1964493934297416-1576609140217995-1673804698410048-1576935955032685-1601362446750000-1771387469162623-1577426261931520-1626130942304859-1966123205567784-1577916670451875-1675192787930304-1578243665927045-1602690367998192-1772856331999767-1578734243840000-1627479262934627-1967753377423368-1579224923402555-1676581644668736-1579552099588125-1604019023157936-1774326006615599-1580042948590080-1628828328673003-1969384450113000-1580533899269715-1677971268837312-1580861256215605-1605348412431984-1775796493234375-1581352376381440-1630178139725811-1971016423885512-1581843598253035-1679361660648000-1582171136009165-1996176362937776-1631190987251829-2118332921307648-1655879870870500-2167478859383784-1583154020552195-1680752820312768-1218062876283450-1608009394134000-1778739903377783-1583973401886720-1632879998598019-1974283075674504-1584465166366875-1682144748043584-1584793065893245-1609340986967472-1780212827350927-1585285000000000-1634232046829067-1975917754188648-1585777035896755-1683537444052416-1586105116383125-1610673314726256-1781686564224039-1586597321953280-1635584841197843-1977553334781000-1587089629341515-1684930908551232-1587417890837805-1612006377613104-1783161114221375-1587910367946240-1636938381910171-1979189817700392-1588402946900835-1686325141752000-1588731389456965-1613340175830768-1784636477567191-1589224138178560-1638292669171875-1980827203195656-1589716988774395-1687720143866688-1590045612440285-1614674709582000-1786112654485743-1590538632849920-1639647703188779-1982465491515624-1591031755161875-1689115915107264-1591360559987445-1616009979069552-1787589645201287-1591853852160000-1641003484166707-1984104682909128-1592347246262955-1690512455685696-1837703344959375-1788882679821528-1887098543085371-1593169796308480-2034565388385867-1348345219375000-1593663462277315-1691909765813952-1593992629572005-1618682726064624-1790546068920375-1594486465495040-1643717287828931-1987385775912072-1594980403404635-1693307845704000-1595309752008765-1620020203977648-1792025502372431-1595803859919360-1645075310924875-1989027678019176-1596298069844595-1694706695567808-1596627599808085-1621358418438000-1793505750518503-1597121979781120-1646434081805139-1990670484195144-1597616461796875-1696106315617344-1597946173169645-1622697369648432-1794986813582847-1598440825280000-1647793600675547-1992314194688808-1598935579461155-1697506706064576-1599265472293125-1624037057811696-1796468691789719-1599760396615680-1649153867741923-1993958809749000-1600255423037115-1698907867121472-1600585497378205-1625377483130544-1797951385363375-1601080693987840-1650514883210091-1995604329624552-1601575992724435-1700309799000000-1601906248624565-1626718645807728-1799434894528071-1602401717596160-1651876647285875-1726019170611120-1701537121874967-1726375001939840-1603227726231885-1628060546046000-1800919219508063-1603723467640320-1653239160175099-1998898084817064-1604219311231875-1703115976069824-1604549930399845-1629403184048112-1802404360527607-1605045944320000-1654602422083587-2000546320631688-1605542060451355-1704520221685056-1605872861328125-1630746560016816-1803890317810959-1606369147834880-1655966433217163-2002195462257000-1606865536580915-1705925238969792-1607196519216405-1632090674154864-1805377091582375-1607693078384640-1657331193781651-2003845509941832-1608189739820235-1707331028136000-1608520904264365-1633435526665008-1806864682066111-1609017736168960-1658696703982875-2005496463935016-1609514670368995-1708737589395648-1609846016671685-1634781117750000-1808353089486423-1610343121387520-1660062964026659-2007148324485384-1610840328426875-1710144922960704-1859044449966975-1809656116298776-1859427035000925-1859618347200000-2157379220124447-2157601172718936-1736179538362290-1909993959946688-1959805777302875-1885576715918496-2233149480041670-2208563856437248-2159155267141383-2109736483105000-2234068377048990-1911566187026496-1713138072049473-1638822324481584-1812823215609375-1291458914916352-1664166245271611-2012109347967912-1813568952070747-1714371559608000-1987881530939280-2037788052958576-1814314893018551-1615651940597760-1665535506743875-2187793897243328-1616150239743195-1715781984514368-1318054958348257-2064335957397000-1815807388485583-1716487486966272-2189368442981016-2015421234304104-2239587053088750-1966061760001344-1667590806900991-2240277525935280-2165824124581113-1817487424000000-2141369556653686-1842763110090192-1319952415066631-1843141760043136-2017700263000125-1245621933690800-2192519800481384-1818981658584576-1669647797214043-2118427456685000-1719841264744239-1869584674209600-2094149884394148-2094364948396896-1271709302182125-2069857083424768-1745841857291910-2194997987444416-1746200407732130-1921017671496000-1846362379103714-2071132585870984-1272754292140917-1672221412945408-1722315262828125-2022055905569256-1622804021805395-1722845713764288-1623137189439285-1648277694822000-1823282144537543-1623637026385920-1673766851086579-2023716845377224-1624136965936875-1724260782041664-1624470315978445-1649631423611952-1824779553061087-1624970426560000-1675141372982907-2025378694479528-1625470639773955-1725676624956096-1625804172273125-1650985893409776-1826277781212279-1626304556564480-1676516647191683-2027041453125000-1626805043516315-1727093242719552-1627138758523005-1652341104418224-1827776829215375-1627639416599040-1677892673918731-2028705121562472-1628140177363635-1728510635544000-1628474074927765-1653697056840048-1829276697294631-1628975006863360-1679269453369875-2030369700040776-1629476041515595-1729928803641408-1629810121687085-1655053750878000-1830777385674303-1630311327557120-1680646985750939-2032035188808744-1630812636171875-1731347747223744-1631146899000645-1656411186734832-1832278894578647-2133694033920000-1631815561677665-2184346150197816-1732589959164903-1757880038481280-1758060130688750-1908946541069856-1281134827888053-1683231889063424-1783906059984399-2211264975832000-2161230300468706-1935253232611776-1935451442290289-1910511358157984-1257044092368750-1936046152527872-1785368228056183-2087334332162136-1634826805163435-1735609233000000-1987350272074179-1660487947246128-1836788346682271-1736320159766016-2214664016191000-2139383103692360-2064086746990326-1938426211730624-2215571014855352-1284155545041000-1284286988168781-1309603115565056-1788294960678087-2090755957324952-1637506574006875-1763649091854720-2066200362637066-1260007197271600-1310541578775468-1310675681536000-2193085615955007-1941205411857096-2269173538914030-1966818276089472-1664401114406250-1916779178006176-2093538779468989-1311748832968704-2194881203311143-1640021515405000-1665422950731606-1741302083683392-1640524812487405-1665934025692464-1842812450437375-1641028212528640-1691694374975451-2045391899240232-1641531715539235-1742727238776000-1641867441423365-1667297403399408-1844320531612311-1642371116072960-1693078692987875-2047065591812616-1642874893719995-1744153171261248-1643210802710685-1668661524750000-1845829435330223-1643714752043520-1694463765988459-2048740197162984-1644218804401875-1745579881351104-1644554896549045-1670026389946992-1847339161815367-1645059120640000-1695849594183027-2050415715540168-1645563447784555-1747007369257536-1645899723138125-1671391999193136-1848849711291999-1646404222062080-1697236177777403-2052092147193000-1646908824067715-1748435635192512-1647245282677605-1672758352691184-1850361083984375-1647750056509440-1698623516977411-2053769492370312-1648254933451035-1749864679368000-1648591575367165-1674125450643888-1851873280116751-1649096624181760-1700011611988875-1776312871511920-1649601776134195-1776675581735040-2284530371178210-1726265817292000-1320220378020492-1371138030231552-2209281198246759-2082523552988688-1676348573121750-1854332355652928-1651286360995245-1880117866266608-2032767280655920-2210860008000000-1702790070269467-2058807011537448-1753977518334063-1982959503038592-1754335460753625-1678231213257456-1856414811396439-1653140728545280-1704180433950243-2060488013301000-1653646705979515-1755588642714432-1653984081619805-1679601291056304-1857930303531375-1654490231114240-1705571554265771-2062169929833192-1654996483858835-1757021581272000-1655334043054965-1680972114323568-1859446620227591-1655840467906560-1706963431421875-2063852761382856-1656346996036395-1758455299341888-1656684738838285-1682343683262000-1860963761709343-1657191439121920-1708356065624379-2065536508198824-1657698242711875-1759889797136064-1658036169169445-1683715998074352-1862481728200887-1658543144960000-1709749457079107-2067221170529928-1659050224084955-1761325074866496-1659388334248125-1685089058963376-1864000519926479-1659895585620480-1711143605991883-2068906748625000-1660402940355315-1762761132745152-1660741234274005-2095302348830448-1712189714882125-2223517572820992-1840339894103496-2070593242732872-1764018323520951-1789766057520000-1789948320942670-1943570362173728-1304370816148197-1713759677506048-1816258605493375-2251366635469248-2200423226788418-1970346962524864-1970547561190593-1945154041348000-1279836882705550-1971149438877696-1817738396524007-2125178090599192-1664465500546875-1767073989390144-2151439462563972-1946738580574752-2279965355962271-1665312700480000-2126692623406203-2024407403285272-1896473318797438-1768513169981376-2153191627366500-1948323980087456-2307460518387270-2282054228062208-2230999068773703-2179933489665000-2308399687599390-1975165089088576-1718824973772519-2309104231720560-2232361141226625-1873321139363328-2207150744996678-1899369385195408-1360497509940447-1899755750000000-2079673852918581-1283879842700400-2259858308094376-1874845817372672-1720923874495875-2183483628328360-1669892548144795-1772835399851328-1875799161103717-1310623058901000-2287398252424959-1722149021963776-2236450684656639-2133842256445752-1902655156274750-2031419403147584-2057342666513040-2160429363105888-2314981008482310-1672100651520000-1723725065779987-2084118201916488-1672610490113355-1775720795297856-1672950440078125-1698860746676016-1879233874391359-1673460451386880-1725126800593563-2085812951337000-1673970566338915-1777164666316992-1674310700558405-1700242027790064-1880761758492375-1674820988272640-1726529295129251-2087508619258632-1675331379658235-1778609319816000-1675671698182365-1701624057413808-1882290470518511-1676182262376960-1727932549592875-2089205205930216-1676692930270995-1780054756006848-1677033433149685-1703006835750000-1883820010694023-1677544273899520-1729336564190259-2090902711600584-1678055218376875-1781500975101504-1678395905660045-1704390363001392-1885350379243167-1678907023040000-1730741339127227-1808420735262960-1989464689254119-1860467454586368-2093238282907125-1705774639370736-1886881576390199-1292515776921600-1757999813036612-2094300480933000-1784214746812359-2017143036265344-1784576791130673-1707159665060784-1888413602359375-1681634734973440-1733553170843211-2096000745092712-1682146509650035-1785844331928000-1682487750446165-1708545440274288-1889946457374951-1682999698165760-1734960228033875-2097701929246536-1683511749725195-1787293684757568-1683853175125485-1709931965214000-1891480141661183-1684365399774720-1736368046387419-2099404033643304-1684877728291875-1788743821550784-1685219338346245-1711319240082672-1893014655442327-1685731840000000-1737776626109667-2101107058531848-1686244445549755-1790194742519616-1686586240308125-1712707265083056-1894549998942639-1687099019041280-1739185967406443-2102811004161000-1687611901698515-1791646447876032-1687953881210805-1714096040417904-1896086172386375-2207995225436160-2104302712077153-1377028903102696-1714964406121494-1793098937832000-1819270127504270-1325602483042248-1351731577423084-2313774890753536-2262009005859375-2158227131689208-1716354401182278-1794552212599488-1378563741135017-1768902383596000-1899161010001143-1691204991057920-1743418562802179-2107928367980424-1691718705486875-1796006272390464-1692061239560445-1718266870456752-1900699674620687-1692575127360000-1744830952455307-2109635999060328-1693089119195955-1797461117416896-1693431838223125-1719658649156976-1902239170080679-1693946003476480-1746244104712083-2111344552125000-1694460272794315-1798916747890752-1694803176825005-1721051179205424-1903779496605375-1695317619607040-1747658019778331-2113054027423272-1695832166481635-1800373164024000-1696175255565765-1722444460804848-1905320654419031-1696689975951360-1749072697859875-1827574194620720-2010534917465151-1880170816725504-1749780323095703-2141738735166000-2089712486296880-1750311167254016-1776614827806756-2220993066492040-1384994511859375-1829422967944320-1359137307410116-2143471650247664-1908405464810247-1699436910080000-1751904343892147-2301241272225984-1699952290074155-1804747128499776-1386395146688625-2171366542511048-1909949117836319-1805476810618368-2302869783259672-2119901155929000-2355683740773390-2067975774809152-1754030082862319-2356397872864560-2278081417331625-1911686722224128-2252351609301078-1938265780413008-1388357621412247-1938657402000000-2122258268087181-1310168294820400-2306129109849576-1913232143913472-1756157540700875-2123330260053096-2333277511805627-1835347420403840-1704423282108885-2150412658102000-1914585070927463-1704939669688320-2177296634318051-2177516474446552-2151498542271750-2046754018428288-1941988315516162-2204641717675488-2362354587176310-1706317213120000-1758996826148187-1312816703752400-2048200779773226-2022145880787648-1838499981718750-1786151666303968-1339748950442733-1970417882726400-2285915411511543-2364978718530000-1734492739642806-1813516298870592-1839984788308590-1340695610164104-1367121685299500-1761661434097152-2287761310614111-2182797077947576-2156715875054358-2051717181072000-2130844313197701-2183678007678504-2104962194832560-1763083658006528-1789578825466500-2237199154499560-2158456858489286-1895421553703424-1763972936542183-1737820218750000-1922328319577823-1711834806955520-1764684574632059-2133639755798184-1712352690351875-1817911516211904-1712698003971045-1739222534775792-1923879470350967-1713216061440000-1766108424951427-2135361242776968-1713734223366555-1819378165206336-1714079722688125-1740625604988336-1925431455328399-1714598058734080-1767533040961803-2137083655473000-1715116499265715-1820845602827712-1715462184339605-1742029429590384-1926984274734375-1715980799037440-1768958422869011-2138806994135112-1716499518249035-1822313829288000-1716845389125165-1743434008784688-1928537928793151-1717364282549760-1770384570878875-2140531259012136-1717883280516195-1823782844799168-1718229337244485-1744839342774000-1930092417728983-1718748509470720-1771811485197219-2142256450352904-1719267786266875-1825252649573184-1719614028897245-2169577657642544-1772882173949733-1323179600000000-1799705422239268-2143982568406248-1376522428560604-2038517243105728-2224060846150500-2012448075334816-1350594506268093-1933398479794176-1774667613582643-2145709613421000-1722039029017515-1828194627757632-1722385643601805-1749059875539504-1934760896041375-1722905652682240-1776096828061371-2147437585645992-1723425766416835-1829666801592000-1723772567052965-1750468230736368-1936318726727991-1724292855234560-1777526809671875-2149166485330056-1724813248098395-1831139765537088-1725160234836285-1751877341742000-1937877393412943-1725680802193920-1778957558619979-2150896312722024-1726201474261875-1832613519804864-1726548647151445-1753287208759152-1939436896320487-1727069493760000-1780389075111507-2152627068070728-1727590445106955-1834088064607296-1727937804198125-1754697831990576-1940997235674879-1728458930132480-1781821359352283-2154358751625000-1941777719089723-1755756295801728-1356857123307327-1809324642294752-1942558411700375-2208884250083328-2209106211320819-2102854539840248-1969960400021646-1837039526664000-2236620641168004-2023812461226528-2396860797478230-2370467129084416-2317430987697375-2264384158881160-2397824069162670-2051677771222464-1785405430207903-2398546692270000-2318828012268057-1945878689787904-2292635262299062-1972930786132176-1413186927734375-1973327063069824-2160210039679773-1333596887207600-2347366200822632-1947442481856000-2214437742801803-2161294772874408-1734546476545155-1868160663537280-1734894767393125-2188856188993392-2402644299039270-2215994387070976-1895799934088199-2163031101189000-1735939919673115-1842951946519872-1736288397022205-1763177463232944-1950376849743375-1736811200483840-1790431199057291-2164768359202152-1737334108880435-1844432031000000-1737682772780565-1764593385641328-1951943050504871-1738205856092160-1791868863305875-2166506547162696-1738729044366795-1845912907710528-1739077894867885-1766010065886000-1953510089507263-1739601258104320-1793307296950299-2168245665319464-1740124726331875-1847394576863424-1740473763483845-1767427504169712-1955077966974807-1740997406720000-1794746500196387-2169985713921288-1741521154975355-1848877038670656-2009850437109375-2170856087216856-2117466958457657-1849618566885888-2225126526563387-2171726693217000-1984245483950334-1850360293344192-1743267741100405-1984842189685296-2414239197783750-1904757354827776-2361062612475864-2173468603455432-2093179503715482-2066550931368000-1744665850500365-1771684369282608-1959786632410911-1745190334184960-1799068729602875-2175211444885416-1745714922972995-1853329182138048-1746064707227685-1773104841750000-1961357865981623-1746589471211520-1800511013313859-2176955217755784-1747114340326875-1854814816682304-1747464311482045-1774526073270192-1962929939138767-1747989355840000-1801954067655627-2178699922315368-1748514505357555-1856301244940736-1748864663463125-1775948064045936-1964502852106599-1749389988270080-1803397892834003-1884335668110000-2072976726252047-2153957643043840-1750265763370605-1992809700859376-2019941717578125-1346762591308800-1885656331848310-2209132771046864-2182410514139859-2128736843368000-1832513808853588-2048308615716768-2398917214452743-1860020789477376-2237640180469875-2103052975705968-2211123047039846-2022570971870400-2265506114648196-1348650449950000-2265959412298764-1753596374366720-2320374979230502-2158704259182720-2212893184489750-1862254899355584-1970408759128029-1781643623759472-1970802906569927-2187000000000000-2349234907830087-2214442829520656-2214664266422214-2133853313765056-1998999166509250-1377826365251016-1432001933748179-1918534008996352-1945750124932488-2189187729081000-1756931207936515-1865236494359232-1757282488792805-1784495964421104-1973957978496375-1757809497866240-1812077042999171-2190938962432392-1758336612295835-1866728484552000-1758688080451965-1785923275662768-1975536776418191-1759215370498560-1813526269796875-2192691129463656-1759742765929395-1868221270154688-1760094421435285-1787351347782000-1977116415944743-2302351836385280-2194225041720897-1435870916203112-1788244279329750-1869714851379264-2005401721288322-2005602021100528-2032907771198925-1355407203200000-1897759595124470-2223311824395216-2196417585650067-2142398971689536-1844274399196500-2061453680837536-2414311803330247-1871956715470848-2251998845234867-2116547559750000-2225310606257382-2035548262545600-2280041648545668-1357303129873200-2280496882975500-1764846357015040-2335260563186598-2172552236408960-2227088306621078-1874200370904000-1983047563539613-1793071249089648-1440034245382491-2037987667660800-2364301605642375-2446073309474640-2120141736239514-2147537301480128-2011817932569666-1848882011324000-2039411553593325-1767666350661120-1822237859934139-2284824632598816-1904210467031250-2122046181760128-1768548214324645-1795935770280432-1986611939361847-1769077473280000-1823692498436547-2204982462620808-1769606837816155-1878693058656576-1769959806168125-1797369174219696-1988197476400719-1770489346695680-1825147910862923-2206742108049000-1771018992832115-1880192215169472-2043890941076775-1989585513152632-1499152220905625-1771901971107840-1826604097419091-2208502689396552-1772431898919435-1881692169000000-1772785242819565-1800238269799728-1991371080899071-1773315346716160-1828061058310875-2210264206912296-1773845556277795-1883192920360128-1774199088026885-1801673961846000-1992959148807063-2320800081018880-2211806302884657-1474684440563376-1802571656877750-1884694469461824-1775613684754845-1803110417000112-1994548060786607-1776144352320000-1830977303924587-2213790051443688-1776675125606355-1886196816517056-1777029033203125-1804547635464816-1996137817061959-1777559982714880-1832436589058163-2215554378957000-1778091037975915-1887699961737792-1778445133571405-1805985617442864-1997728417857375-1778976365104640-1833896649350651-1916202161165040-2108032201322663-1971343205568000-1834626970245807-2245587845109616-2191035466736560-1835174838140928-1862750880306500-2328670331931560-1452138943285719-1918110222125440-1425023672693348-2028120099750000-2466877997965590-1891461318154752-2412538514458776-1370896904613200-2248494609857750-2139024734840448-2029533048712082-2084592653527712-2441410558561431-2112441723392000-1893155557366389-2222621063133768-2003302174474531-1893720528515136-1784117058238125-2250956138372272-2086459514727188-1784649418606080-2279086651295147-2279313290779000-2361932955358146-2142431276578944-1813006719989322-2307692529074016-1401238342078125-2060849496883200-1951131486021543-2473511147977680-2253867532877798-1896735606408000-1786957537283165-2254539749462576-2089781130525012-1787490462517760-1842673300968875-2255436246138192-1788023493698195-1898244344722368-2311135817866596-2091235445284000-2476709123208390-2449433510572032-2394627985117959-2339811536017640-2477693669838750-2120015202654272-1789801029599245-1817516984077872-2478678477353910-1845421736000000-2396531946322287-2424319093011904-2259249008385014-2149255206513792-2232140560075125-2094562126618016-2370397814057898-1433406143463424-2315732195223636-2453817065229000-1792291558455515-2150963450073984-1434118029427044-2261718378108208-2013680923751375-1793181592650240-1848539931296971-1462423038572296-1793715754574835-1904287298712000-1794071921450965-1821853869069168-2015280829068391-1794606260162560-1850008531921875-2236799479037256-1795140704960395-1905800038452288-1795497060434285-1823301029022000-2016881581596543-1796031682065920-1851477910175579-2238576009085224-1796566409811875-1907313579113664-1796922953933445-1824748955123952-2018483181560087-1797457858560000-1852948066263907-2240353479531528-1797992869328955-1908827920908096-1798349602148125-1826197647577776-2020085629183279-1798884789844480-1854419000392683-2242131890625000-1799420083711315-1910343064047552-1799777005278005-2270713071819248-1855522711702125-1911100936187904-1855890712767731-1523643436343160-2022490890470467-1967275211896000-2022891952879413-1413393393181128-2106442098509972-2466999102537216-2328634464208500-2495212817498640-2162732133444714-2190676589297728-1941298236857630-1414514614833000-2468711333733479-1969616586539008-2413713032208279-1387328870541200-2164447509656250-2081405764843200-1804063746155645-2276121317686064-2026503900757647-1804600066880000-1860310521428747-2443635003547584-1805136493887155-1916411654294976-1944378337938750-2111248462557856-1416899179345053-1861600952807424-1972936712957399-2445572218232000-2390227750166706-2140299596595776-2307304679791831-1890509116348512-2057522486255750-1807462239331840-1863260955540891-2447510456476096-1807999233358435-1919450763000000-1863999051180367-1836359969638128-2031326515853271-1975869332946944-2449207254791000-2310276439087128-2282667730244326-2171533024292736-2060376286728546-2339037018444000-2506359147320790-1810327436536320-1866214507577899-2312106481728952-1950162305411250-2145390831776192-2229198069201040-1895005865585376-1421395038539709-1811761169920000-2453088595422168-2090907370968600-2509337097744030-2007668293360128-2314624367984375-1840726766074416-1394627928789150-2482683288432128-1897069256487652-2287868628834000-1813733789054915-1925538616051392-1535001431482035-1842183901780464-2037768562712375-1814630907248640-1870650685344451-2261756566532232-1815169320134235-1927062587976000-1815528321218365-1843641806271408-2039381199743311-1816066911592960-1872130972012875-2263546284800616-1816605608474995-1928587363789248-1816964798905685-1845100479750000-2040994687349223-1817503673323520-1873612039397459-2265336946950984-1818042654276875-1930112943703104-1818402034104045-1846559922418992-2042609025754367-1818941192640000-1875093887704027-2267128553232168-1819480457739555-1931639327929536-1819840027013125-1848020134481136-2044224215182999-1820379469742080-1876576517138403-1960796015710000-1932975574081959-1961183422719360-1877318124842839-2129705527675424-2522268808593750-2494489952766464-2438674831759071-2382848653462920-2523265391694510-2159006917144000-1934885565947529-1850942867595888-2047457148007751-2496461362016256-2328390477279875-2272509039348936-2413025596671858-2160712967572544-2160926287047913-2133072872244000-1403475953323550-2161566329714176-1993329338700447-2330460089447672-1825239252191875-1965836287739520-2415408674746478-2134757874764192-2528252245007910-2500407296000000-2444459581694487-2388500792608680-2529250403474430-2164127764203328-1827041364208125-2080221560092784-2249110066331440-1827582229025280-2333912167758107-2362264625364000-2193747840689418-2222092004667712-2194180689089766-1913064168660192-2082069307529750-1829025057034240-1885488708954771-2279696253765192-1829566313253835-1942346556072000-1829927210049965-1858263178955568-2055554388678591-1830468644226560-1886976812046875-2281495422050856-1831010185191395-1943879382429888-1831371271833285-1859729553462000-2057176394368343-1831912990801920-1888465697913379-2283295536706824-1832454816586875-1945413015008064-1832816093124445-1861196699186352-2058799253099887-1833358096960000-1889955366760107-2285096597981928-1833900207639955-1946947454018496-2116455777834375-2511775012931704-2229772797845217-2342903521857536-2343134372534467-2343365238375000-2428304412851186-2202632617021824-1863949676798682-2372533297399776-1440608548765125-2118750679411200-2005948221633503-2543001734872080-2317185355391478-1950018752184000-1837155116041765-2317870102832496-2148481427176372-1837697974927360-1894429073239875-2545006071122640-1979644090029410-2206106343732096-1951747775967921-1442738225973000-1499463819386883-1527906008558592-2009111241801007-2490411205605312-2320838900593750-1953093278622144-2066519488317309-2095034185376048-2406695065340315-2010496108032000-2039013631774152-2492373060334784-1982764608201090-2152927727912704-2238131962395875-2153351504775456-2521936103305967-2352149381464576-1955593709591661-2494335945112000-1984326096253970-2069572254450624-1842951125155205-2098335400740016-2268693882990000-1843495125155840-1900404989422691-2326097597011344-2439805753368914-2184692125000000-2184907019795577-2156743721816608-1419049903676350-2185551788732928-2015447253671375-2356317941919928-1845490707699795-1959252023099328-1845853695544885-1874435748966000-2073443405566663-1846398266552320-1903397654451699-2301348788376264-1846942944656875-1960793729538624-1847306122896845-1875910618020912-2075074807050207-1847850979520000-1904895164420987-2303159329528488-1848395943268355-1962336244529856-1848759311953125-1877386260524016-2076707064042359-1849304454266880-1906393459634563-2304970820037000-1849849703733915-1963879568284992-1850213262913405-1878862676678064-2078340176767375-2420222903605760-2306556653196393-1509376701086216-2420936295869615-2164814511264000-1908642375238207-2108259850526512-2564351686170630-1424779761459200-2479360289190375-2308596650118216-2565359322959070-2223529770274176-1568027535753195-1910330222125000-1482789951455852-1425899577830400-2024976226488767-1426179623573200-2110953097086750-1968514394253504-1455131756153343-2140109737583400-2511308621085352-1969287573504000-2369085720223923-2369318287539224-2341002064410854-2227025427599232-2113026385297250-2398805922365664-2570401466483670-1856583261678080-2513774798480792-1428421309650000-2114271009596414-1971608325938112-1457418724868367-1428982097961200-2429507940546875-2143893820723200-1972575843992277-2029951106899192-2001556605617730-2116138862288000-2030548639518811-1430104114868400-2517230158545256-2088361677819392-1916903530258875-2317677856474536-2432369645120255-2060562258537984-1860412269720485-2118215544046000-2547833412641319-2147261192601600-2032939942587847-2491311539738808-2004700102641250-2234027729601408-2033737460618283-1947995878089056-2120085718873126-1862420040000000-1919913486510667-2321316996703848-1862967864304755-1977805911431616-1863333140183125-1892185269811056-2093076736273639-1863881143521280-1921419645487443-2323137994461000-1864429254293515-1979357334484032-1864794721165805-1893669433625904-2094718418661375-1865343011018240-1922926591972571-2324959944311592-1865891408332835-1980909568632000-1866257066248965-1895154373321968-2096360959248791-1866805642690560-1924434326171875-2326782846504456-1867354326622395-1982462614087488-2155061741114175-2557590423183000-2270443072637689-1437130029798400-2012179095229590-2357354932168528-2443838935319375-2214047366258112-2243020859418534-2185721517709472-2559845572833591-1495786559488000-2502811011830727-2387973027650904-2129244643070318-2273335073068736-1928207109270375-2590382522352240-2504281571552001-2101499432418816-2475981404652614-2130704172250000-1526194253175903-2131121303057792-2332942175661237-1440228708313200-2535050607001000-2103145515450368-1930473144227331-2334083983675272-2103763018126067-2075147387712000-1873580260160765-1902590717116848-2104586543030031-1874130270671360-1931984820084875-2335911651311976-1874680388812595-1990240018396608-1875047194040085-1904080316358000-2106234237524903-1875597491589120-1933497284891539-2337740272783944-1876147896796875-1991797936148544-1876514893417645-1905570692899632-2107882791789247-1877065478080000-1935010538853147-2339569848340008-1877616170429155-1993356666691776-1877983358493125-1907061846944496-2109532206047319-1878534230343680-1936524582175523-2341400378229000-1879085209909115-1994916210238272-1879452589466205-1908553778695344-2111182480523375-1880003748579840-1938039415064491-2343231862699752-1880555015436435-1996476567000000-1880922586536565-2373088061289456-1939176058008109-1447287717683200-2026400785683750-2374015713136912-2461110383275655-2229694286428224-2258872019884662-2201167245236000-2577934512073359-1506356067014656-2056956313073887-2375871742016208-2231219434742375-2202457663728896-1536074440426089-2405785486417256-2116138467502007-2174327193600000-2058564095170631-2522712197653176-2029966648014690-2262183716787072-2059368300296875-1972545325807968-1508564296230316-2176026329126400-2089189231955208-2379586701394000-2234708099307607-2205901245120768-2438339386798308-2177301261517800-2380748419860750-2584235268214784-2468330769672005-2003899373601768-2614036902607710-2120481313352000-1597778828746155-1946575071658696-2150158399098118-1888836954600960-2412134856720875-1598558588051480-1889389946776995-2005855796960448-1889758668183685-1919019093750000-2122758506796823-1890311840235520-1948665370441059-2356079003186184-1890865120226875-2007421852163904-1891234033526045-1920517254447792-2124415671089967-1891787493440000-1950186527272427-2357918133268968-1892341061321555-2008988722278336-1892710166563125-1922016194676336-2126073697619399-1893263914414080-1951708475522803-2359758220173000-1893817770260715-2010556407515712-1894187067494605-1923515914638384-2127732586609375-1894741103357440-1953231215398011-2361599264147112-1895295247244035-2012124908088000-1895664736520165-1925016414536688-2129392338284151-1896219060469760-1954754747103875-2363441265440136-1896773492471195-2013694224207168-2189011354430175-2364362625159000-2131052952867983-2014479188163072-1956279070846219-2365284224300904-2482330200339375-2102884545480192-1548107478793369-1928019754953072-2132714430585127-1460905600000000-2045467060868070-2396351945187856-2484265300288295-2250671281201728-2280122824989750-2221874504342816-2602185379146927-1520526034253824-2544204750566223-2427466176603000-2164457694328094-2310929831438912-1960093346712399-2633217569382960-2545691478623625-2136247937630208-2516920663972118-2165933269253968-1551427545692727-2166354985232000-2371511283290541-1464038348612400-2576958300555496-2137912114084352-1962384290296875-2372665640398056-1904176249253395-2021553045425088-1904546891831285-1934035803942000-2139368977271943-1905102945873920-1963912577308979-2374513390830024-1905659108136875-2023127259276864-1906029943106445-1935541769071152-2141034774019487-1906586285760000-1965441657592507-2376362100322728-1907142736661955-2024702290159296-1907513764073125-1937048515758576-2142701435245879-1908070395412480-1966971531353283-2378211769125000-1908627135028315-2026278138284352-1908998354931005-1938556044207024-2144368961175375-1909555275031040-1968502198797131-2380062397485672-1910112303435635-2027854803864000-2204404287553575-2145828755866744-2351821755651760-1911040924815360-2440489459563875-2440726676657368-2529191520295218-2294140846298496-1941384767843994-2471093478252000-1500452561781861-2206762321113600-2089271343351807-2648629482086160-2413430246093750-2031010588234944-1913456748848645-1943083322146032-2149376729425047-1914014535680000-1973098965285347-2385620042406408-1914572430900155-2032589707450176-1914944421268125-1944593979666096-2151047716409519-1915502497159680-1974632809519723-2387474511489000-1916060681468115-2034169644967872-1916432864577205-1946105419960944-2152719569218375-1916991229603840-1976167448466291-2389329941374152-1917549703075435-2035750401000000-1917922078975565-1947617643233328-2154392288075871-1918480733212160-1977702882330875-2066457324219120-2273323710553511-2362124029864960-1919412064662885-2185388910254000-2658163405322790-2097199101247488-2126943522611784-2570306179699128-2541009002735250-2275310238377792-1920902821838845-2187086189766768-1625694765285745-1921462054720000-1980776135637387-2394901998333288-1922021396130355-2040497582302656-1922394350703125-1952159012943216-2159415643182759-1922953873018880-1982313955490963-2396761273917000-1923513503891915-2042081614512192-1923886651455405-1953674370153264-2161091828477375-1924446463280640-1983852571085851-2398621511547432-1925006383691235-2043666466296000-1925379724295365-2429176089864816-1985007055111069-2577796382097408-2015024698786500-2430118300503952-2637823125842947-2134176143860224-2430825118348618-1956707436750000-1482497808767550-1601252828716032-1986932190322859-1601563249295856-2521223524879375-2284153253136832-2284374621566961-2254925926321312-1483647663203950-2285038812672000-2107188011951351-2404207999207368-2404440957574107-2345299266026176-2018934203984500-2256674495620896-2672636601695670-2643196688731648-2584049321859183-2465481274859000-2317182752711658-2347117562313792-1931359740525605-2198991758931376-2674708479843750-2110252170346496-2615777136265304-2407937139109512-2556822828321554-2289470043784000-2289691755592857-2022261256579424-2528071349127395-1546734581803008-2498813177416500-2647808404047784-1933979886462195-2321000556441216-1547483509086788-2440498702518000-2172849418855783-1934916226846720-2470978355202531-1607780088780336-1935478176116875-2054783394667584-2144329332262056-1519046952971592-1548982088835948-1489550000000000-2115365699603071-2473131608876664-1936977239406755-2056374810676416-1937352126133125-1967347888982256-2176216545686039-1937914546913280-1997735953759843-2415406983381000-1938477076531515-2057967048167232-1938852156747805-1968871095229104-2177901412771375-1939414867786240-1999282538088171-2417276855164392-1939977687690835-2059560107352000-1940352961446965-1970395087494768-2179587149269191-1940915962818560-2000829920421875-2419147691731656-1941479073084395-2061153988442688-1941854540430285-1971919865982000-2181273755403743-2540084857505280-2420785465347897-1584123866007112-1972873251879750-2062748691651264-2212437079206322-2451856444443504-2182961231399287-2063546351616000-2003927079928707-2422892260213128-2542786988103095-2154098313589248-1585808941054625-1974971782432176-2184649577480079-1496479919129600-2095274328745430-2454701375250000-2544753377180335-2305469906170816-2335636710098406-2275968454255264-2665536337732375-1557542470828032-2126849967295703-2456599217863184-2307029412255183-2277287941216000-1588262091838993-2487518609617224-2188028880794431-2248191989260800-2128493962173375-2608406455408152-2098920514443410-2339022999021696-2129316277207139-2039542090924000-1559800432887372-2249929386393600-2160140758993224-2460397837204368-2310596638109375-2280809066130176-2521137599696772-2251233021491400-2461585708295198-2671978978368000-2552136364877485-2071934199952392-2702783722390830-2192469502451392-1652020014651875-2012654973091752-2223146892587222-2433679414751232-2013237731983923-2434149146349000-2674817025904819-2314390842662976-2224434387940418-2044272071343712-2194797938313375-1954460688227840-2014792305628091-2436028677168552-1955026415114435-2075535939000000-1955403627014565-1985678285791728-2196492381270071-1955969535836160-2016347679335875-2437909175260296-1956535553832795-2077138050808128-1956912959821885-1987210937646000-2198187696106063-1957479159800320-2017903853313099-2439790640873064-1958045468981875-2078740986853824-2259718925895975-2681791661177848-1627311365540586-1958989560320000-2501720129918563-2562249522367080-2080144232192823-2110494671223680-1598099994140625-2502926126875208-2201580942312959-2262116235686400-2141676429937919-2624560659039000-2111918985476370-2353507941093504-2142502136504227-2052171613359072-1569458924039500-2263860798259200-2173515774361416-2475631473045904-2324902313473663-2294929861344000-2536745797842564-2265169808646600-2476824241858974-2688519425624576-2567934436758125-2084759341509384-2719513243217070-2206039874906816-1662244925052195-2025111573625000-2236905813260374-2448740822888448-2025696734444659-1511859562013200-2600648862203250-2328712158420032-2540657887059012-1542690819411912-1573091111939308-2511137186368000-2148288025665951-2572141730199880-1967121276103555-2088375923987136-2149115430615875-2300683041454496-1513752966723150-1968068282286080-2028819495987203-2452988011653000-1968636631858715-2089984635630912-1969015592356605-1999500553777584-2211781629359375-1969584124285440-2030382079529611-2454877226391912-1970152765642035-2091594173208000-1970531920678165-2001040308997488-2213484801200551-2577593281187840-1971290376680625-1607514478731368-2457003752152443-2396567513297088-2336119616928713-2306002196084000-1608287793146163-2033314085802496-2154913214570047-2549719993748256-2610678671629250-2337692912750272-2095017183883737-2064853165938656-2216893767472727-1974136320000000-2035074643711267-2460550690167048-1974705837157755-2096427743658816-1975085576108125-2005664317127856-2218599562352239-2583549206827520-2462207095448649-1611228649733000-2341066639213687-2371698054969984-2007014326719402-2311329542954144-2737363847703750-2098847318913024-2190312035662536-2494761775563024-2008171959846294-2099654257512000-1978125240445965-2008750943301168-2222013776719391-1978695524482560-2039774432546875-2466232888505256-1979265918115395-2101268755140288-1979646241429285-2010295443222000-2223722196655543-1980216817745920-2041342635264579-2468128896793224-2224576734909875-2011454337568896-1554454909481703-2743419183594480-2255916854964006-1585391112448000-2073402860075428-1555201477848888-2134795243413490-2379000263233152-2104702310147625-1555798904621736-2318668032872948-2715543002124288-2074996100124932-1678466796875000-2594243172031335-2380828154250624-2533688546595991-1556994217128264-1557143674225125-2351207291141632-2656813876248591-2687609903045056-2474060185465299-2199375675072000-1649690065759374-2505325325891696-2230564633316631-2658599255113728-2078185028354500-1589352810712992-2017449054136758-2415057087585728-2476435359086829-2018029819278000-2415752290325369-2599476514030080-2079780716952356-2599975294300040-2508452071593750-2416911258013504-2111175615514377-2325575900168352-1530130896531950-2417838699008000-2203811176394952-2510136780936976-2602220595085895-2204445305829888-2143416245188750-2082375452672608-1561931352802053-2542210459429376-2205502458520968-1531745784450000-2389752532063338-2420622445477952-1991842327199205-2513026608735088-2237421091808375-2666771173343232-2667026815251351-2513990377318544-2146295061672930-2361150869000000-2054704822981367-2545624567795464-2239137399024271-1533802739123200-2577035554600500-2546600588451128-2638899257864098-2424337430038848-2363188230220433-2332720978916000-2732000793857559-2363867610976256-2210581496253384-2487142453358664-2241713505203875-2119082885212224-1566428704932663-2273075071017968-2304012992606925-2488572393408000-2058645945573787-1536450099912400-2151236170668690-2397321324857472-2397550931343750-2582225210373984-2736191112287687-2305999844966400-2705965594137432-2767729827330000-2767994859392190-2153091039845760-2276342756624738-2768790057093360-2276778684507750-2738550048233984-2646492722318758-2677522205663064-2277650707230206-2431778798216000-2185731931722291-1570183086338088-1539542535530350-2186359654846464-2679316848810375-2494775133788616-2279395420600302-2372030338846784-2218214664111528-2033558034750000-2711670186416488-2496207997582848-2064962218806459-2558332302238712-2250314794662875-2127213390055104-1634102850583529-2775157122124080-1541901460063950-2189709541376000-2683421901202647-2621984845043880-2529686170630054-2406517023810432-2098189881544500-2592129534615264-1573943461901013-1666687766473728-2191595355365039-2500509880593000-2253761461480203-2130471406168512-2439468641477243-1574997441862824-1575148048828125-2254839266152448-2224163705733576-1544705811107600-2657148024552754-2441101901688000-2070499544715847-2596098344697312-2256348769898751-1545592101555200-2596842947296500-2566173427657848-2040766693521798-2442969377242688-2783395684518210-2103211074092000-1639424127601963-2010806654238720-2072875711515619-1547070005549200-2661214698119250-2444837804983744-2506971967829613-2600071203810528-1578765496924149-2569608952000000-2198309240168271-1672113247387632-1610336961367004-2136997414881216-2013305824083125-2787920520427440-1579972542583293-2509607858614272-2695762211930823-2541076042122000-2665285518839666-2386588213742656-2014844803529805-2046037803872304-2263257938081375-2015422122954240-2077633497643771-2512005725697192-2015999552648835-2140265410872000-2016384567044965-2047601355587568-2264987431129591-2016962180546560-2079221042671875-2513925118718856-2017539904346395-2141900657517888-2328375132494175-2763268903423000-2453023378043289-2577473090246144-2080809396202379-2546905310069328-2019081040461875-2423128485168768-2268016163643069-2361447643495072-2765643374519191-2144355088896000-2082398558441107-2642101002245480-2393661046338639-2424978907757952-2269748079567125-1554770295226800-2798853529646070-2083789738955264-2146197142417581-2550796437250000-2551039764201782-2333490646305600-2800455875700930-2365054971714464-2676501676838250-2583381711945728-2708140297886391-2272564323045576-2054843144348214-2148449973384000-2024095152636765-2055431063606448-2273648113598831-2024674237647360-2087170899464875-2523536750918376-2025253433096595-2150089385731008-2025639624756085-2056999396518000-2275382895108103-2026219004293120-2088763298594739-2525462012518344-2276250616671875-2058176169599616-1590560446144983-2807138900461680-2308311963727686-1622211645184000-2121555858319588-2558590577197776-1622675472890524-2153370711965376-2028730925593125-2060138455270896-2278855104936119-2029310894407680-2091950526272323-2529315472869000-2029890973745115-2155012626276672-2030277754710205-2061709181517744-2280592533703375-2030858018275840-2093545355231691-2531243672117352-2031438392392435-2156655375000000-2031825369892565-2063280705948528-2282330845338471-2032405928284160-2095140994545875-2533172851079496-2283200332301539-2064459873201792-2471331199013091-2064853028766000-2284070040065663-2159121063071232-2753923807597336-2660293282103240-2566644896301750-2410371594099392-2535827072298453-2379521021411232-1659560770682027-2286027689984000-2098334705061987-2537034149140488-2036085366423355-2161588629761856-2036472933828125-2068000070372016-2287551079693359-2037054377146880-2099932776675563-2538966268737000-2037635931128915-2163234718252992-2038023695268405-2069574789566064-2289292925042375-2038605433712640-2101531659467251-2540899369042632-2039187282848235-2164881642216000-2039575243772365-2071150307957808-2291035654380511-2667897978160640-2040351313235625-2762584489221568-2040739421780995-2166529401862848-2260941318874728-2575205807750000-2292779267932023-1570546083430400-2638768301347668-2607602303215512-2702109875983250-2482406692681664-2419790986358361-2388592189076512-2797433084479231-2420481172032000-2263522220026632-2546704556702568-2295396346649931-2169827429055936-2610330352831375-2390409184641696-1572787088063150-2296487383617536-2233782190503639-2580106293226000-2674754583504935-2265889770809856-2171684039336673-2392227101429024-1573983161718750-2046372527613440-2109538248301211-2582068226829264-2298888881780347-2488075004648000-2330823309899634-2142041103917024-2835323714905830-2173954667544576-2615295316509875-1701679053135024-2678823295215255-2426929234689344-2458681289178582-2395865699604000-2805951287668319-1639587904587776-2238880692824847-2554458551939304-2302384957800875-2176433520974784-2492095275240667-2397686381458592-2839635037331910-2303478208000000-2240581916010871-2619520482354264-2209443872525890-2462185458475392-2304571804219125-2652087773413344-2305009339604639-1578923375385600-2652843043160436-2621510369323000-2084772356840646-2495646167221312-2843411027705730-2148558879040992-1674770984268875-2054159324938240-2117565147461571-1580422448051600-2718584540870674-2497541354712000-2561013214780941-2656117535723232-1612795786869717-2624995095905792-2245690755859375-1708152180248304-2815554915510587-2277968355730944-2119977181569663-2594845043254000-2310264084519143-1582522743398400-2658890363903508-2627486076092632-2722713643667250-2501334607609024-2438240881372681-2406803627741472-2818760987540591-2438934570688000-2280778438155912-2566119030764328-2312894449143611-2186367778120896-2535159492890000-1616317396680936-2852595222932070-2187196994715648-2631225500353267-1712043924750000-2695139402933335-2441710643665216-2473655611602006-2410456987884064-2823039534937375-1649572680517632-2252514614477903-2570013727927272-2316404706665067-2189685902424000-2507269251164699-2412285053524128-2856924031612230-2317502390054912-2254222736328375-2635467801652568-2222894269257410-2477173990951296-2318600420165557-2668231310892000-2319039729303903-1588533838822400-2668989642330228-2637465755551992-2097460574343750-2510834539018304-2860715329715970-2161634066887136-1684962583571467-2066659246080000-2130450495814147-1590038987328400-2735126033652882-2512737407098816-2576594961874125-2672277405575904-1622607756344853-2640964604171776-2259352282639599-1718543293686000-2832682091841019-2291824924263936-2132872302960319-2101237274623344-2738235014354250-2260849864749056-2738753406745078-2293126850908224-2102231896056534-2389125975000000-2134487860261767-2357717161310192-2549124629274160-2326296343721472-2772697719303375-2804833191055808-2103823943116038-2486572642859136-2709982982375465-2423272860036000-2869936729058790-1594560136806400-2264489604670887-2583676198809864-2328718574913875-2201325772809024-2488690610547414-2680381861771488-1659440955533868-2457481522496000-2776897582597407-2745238832998128-2490103256945226-2458411330099648-2107408987406250-2682410532914784-2842346580944887-2203825385484288-2651229029979587-1725059090718000-2587833294462171-2460271648847936-2364640452527938-2173118279333472-2333126938297375-2205492844721664-2653234940701899-2781364582016664-2365982007895006-2526084409896000-2270492982543491-1631071645494888-1599240986470350-2271136830193664-2783205326220375-2591505021063816-2367771537559502-2463995101336384-2144198338944183-2368442843750000-2560720692620080-2400902484825600-2785310028145599-2785573190468568-2241477538571250-2465858235549632-2530145510052347-2178052510062816-2338424313828967-1601811788800000-2274787599449751-2883805950845520-1698401690333191-2499770650396032-2275647172170875-2179698911890528-2564593847573040-2532775598729728-2148253048083803-2597387004873000-1667615785004572-2501659883708544-2341518149344941-1636009607394024-2855266726234375-2406350824243200-2278227189504743-2599349642159112-2086094786239035-2214678906888000-2086488673915165-2118788492288688-2343729701775151-2087079598389760-2151500493328875-2601313267868136-2087670634426195-2216351835615168-2088064720434485-2120388886374000-2345499946006983-2088655942430720-2153125442495219-2249746317992880-2474954465435375-2314461502536192-2314679882297256-2121990086145072-2347271081404127-1672186464000000-2186911675447268-2637406985371856-2476823119434279-2316208925265408-2863361665676125-2187943367313888-1673290981177036-2091811011297280-2188562538152772-1673764494532000-2349929455925363-2317957227311616-2350372713390181-2189594749117792-1706756841223875-2351037704094208-2802185854949631-2738025939411720-1707400677691727-2545233420872000-2158819207444287-2384592281794352-2578180643101360-2417272218316800-2288566759484375-2804564470833912-2256758840439810-2579396078044160-2740866661542065-1644675003837000-1677081589517932-2096549569553920-2161262461997979-2645376481739728-2613362057737875-2484541259589312-2129807479354698-1645915409796072-1646070504378669-2872825081856000-2292020221898791-2873366477372232-2776773025333202-2421832534468800-2163707559300375-2389991696196464-2584018214593840-2422745285414400-2810649270415263-1615467831250000-2649616799020182-2520604596292224-2133020160973482-2715008622804576-1713202493622875-2101295278551040-2166154500046131-2651364128218384-2489930040503983-2328465517632000-2393370465648194-2134828713331248-2426170143948525-2361694620339712-2847242388287000-2750436236441160-2783056302057218-2524404979514496-2168603284929903-2460139775428000-1715785291633483-2298721188446208-2331316968164424-2849655608414912-2234599365234375-2267198233256320-2332194805665576-2138046441178032-2850996875270632-1620037033600000-2300669073729711-2916615515487120-2916889968814830-2495796242563008-2722942998646500-2204494593143008-1685948595817356-2431885411430400-2853680671456472-2724224182596000-2627177593758651-2465238028805888-2368148753163861-2141267400688944-2401040795935750-2239018895568384-2693565913815659-1752605301030768-2499320382458823-2532017202000000-2207607210947668-2467557743253408-1623545917566350-2890183494762496-2825501222208375-2663366512884112-2923482014967870-2533922645694336-2599139377794320-2209476187228000-2372160674905263-2242390065234432-2177597951688299-2860397529435072-1722901368251375-2535829045097088-2763663205638105-2211138384778976-1723549258201627-2439214041600000-2341865566293192-2667375342334736-2407369829832558-2244920661934656-1724521397640625-2408048599517424-2928982967548470-2115575363898880-2864432698871832-1692778362964000-2669632075654262-2572204259575872-2116569431810405-2149333948641264-1726142442244875-2442883871539200-2345388823724616-2899433525924808-2932286849011710-2541553979952000-2411444361825954-2216129978924384-2607456617504560-1695005981779968-2216754455886500-2673396125839952-2510619920664471-2347813111924224-2902430403138061-2217795511500000-1696120523674252-2642281970946048-2218420301292036-1663971442971864-2381986664547875-2349577279498752-2774066921081905-2219461878354016-1632110465353950-2578976609344000-2840405402231247-2775369218375880-2416430585627678-2579945057178176-2547526609455750-2939729664302640-2940005565725670-1698829302104064-2842538839680183-2777453741705000-2679677402352102-2516518561637696-2255273691537873-2484302658760224-2909522138609375-2125131273341440-2877370739921304-1733124510027656-2125729471238035-2616527871360000-2649482998580421-2224465986675424-2584548495387873-2781104168611840-2748643094116500-2748900908313504-2945527219962270-2553029686137216-2422332251485506-2226135692732000-2946632379774390-2390270400474624-2848945561218159-2652715287918504-2161674398391750-2587701369338944-2194838585886191-2424377372415408-2621194247679920-2457600000000000-2326746118816071-2851350561408696-2294405180481890-2622423162885120-2786585804010625-1672108208267016-1705054452625836-2131517839393280-2197308937040843-2689495827282000-2656946093003811-2558780470406784-2526212321417169-2493638038224544-2920455042700375-2395653890347008-2888182153904344-2691512823006224-2297848186400130-2527869837416000-2199781141132487-2429836655123952-2627096543693360-2331766614997504-2890347681375000-2956314322221840-2299570980257810-2529765029018304-2530001994549953-1675872567777000-2924835861435399-2136316151889920-2202255198855779-1676500509780504-2301294635001250-2564539884087168-2268843887751057-2236171478163296-2631036326025520-1710333750528000-2763105529373364-2862055827373656-2434620245179518-2599364961353536-2632514759290000-2764399279600224-2962133655104070-1777446573907968-2205556827114483-1777779366750000-2930318042749939-2370816268171776-2865004465720299-2502996775103264-1646862528318750-2404644325907968-2866077199759791-2899291924241856-2668916172891699-2372591938752000-2372813959894632-2175282995313648-2406219961005431-1780110079819776-2340734097098375-2802549489397160-2571991909091514-2539255196819264-2308629776915630-2242878730524000-2408021529455503-2144329332421120-2210515454192139-2672664182199144-2144931127421875-2277139858513344-2145332386634645-2178541235544432-2409823996919847-2145934369280000-2212169979958547-2674664554484808-2146536464526155-2278844091840576-2146937923918125-2708698017468592-2213411415927701-1651954005273600-2379036176709768-2676665924649000-2148142602422115-2280549175265472-2148544262043205-2181802727714544-2413431629788375-2149146845347840-2215481507837091-2678668292940552-2149749541309435-2282255109000000-2150151401209565-2183434693783728-2415236795641071-2150754284956160-2217138510360875-2316629829291120-2548530933336311-2383264584267264-2217967321358943-2714780800342000-2648814094690480-2152362525880320-2914239967486936-2914512224583872-2682926640790875-2385046464256512-2219625562956071-2186701066904112-2418849827304607-2153971568320000-2220454993606587-2684681389067688-2154575165916355-2287378014181056-2154977626953125-2188335474360816-2420657693563959-2155581412474880-2222114474740163-2686687752357000-2156185310765915-2289087351273792-2156587972281405-2189970696018864-2422466460407375-2157192058544640-2223774782488651-2688695115017832-2157796257605235-2290797539736000-2158199119649365-2191606732081008-2424276128059111-2158803506728960-2225435917057875-2690703477299016-2425181299758179-2192834293702272-2625001145711971-2193243582750000-2426086696743423-1661858274790400-2858662948719622-2825686313002440-2726210550157750-2294220471616704-1695886382868543-1662788824415600-1729461707775308-2627696553984000-2894062359267447-2994136890797520-2861331022108242-2595402765301632-2296147368356625-2196519728719536-2429710538106799-2163642665966080-2230424283748203-2696734564353000-2164248068853715-2297646811518912-2164651733511605-2198159024425584-2431523811234375-2165257324605440-2232088727658611-2698746927603912-2165863028637035-2299361260008000-2166266894073165-2199799135549488-2433337986291551-2166872786357760-2233753999418875-2700760291719336-2167478791608195-2301076561138368-2167882857872485-2201440062294000-2435153063502583-2168489051422720-2235420099234819-2702774656948104-2436060940485875-2202671292725376-2636776467440467-2203081804861872-2436969043091727-2637513592000000-2237087027312267-2704790023539048-2972206658219003-2404705797047808-2237920802013375-3006442313803440-2639234083525697-2706302205775872-2405826036383688-2974145294629000-2205751377055446-2406498346953216-2774416190270551-2473806252009456-2574335420454875-2842063489564160-2273862523837284-2842592836459720-2742521386275638-2642431266792000-2308161195560409-2542559191583648-1672892053678350-2643415534698496-2409413140125000-2744309320812432-2844975710892055-2410086118777344-2343357404149230-2276616238556000-1707621116101941-2779328338066944-2411208028320264-1674605869445200-2612628297074250-2646369804860224-2177595519843445-2747376159032304-2446062484558087-1675541171200000-2882198992522806-2815433066584992-2178811638438955-2313107560812096-2179217111898125-2212949403913776-2447883883125279-2179825416404480-2247106000794683-2716903265625000-2180433834101315-2314829690703552-2180839508788005-2214596862922224-2449706185640375-2181448115159040-2248778732465731-2718925648718472-2182056834748635-2316552675144000-2182462710712765-2216245139376048-2451529392327631-2183071619023360-2250452294044875-2720949035164776-2183680640580595-2318276514345408-2184086717872085-2217894233478000-2453353503411303-2856910059950080-2184899023477105-2958292116280512-2185305251796875-2320001208519744-2488348511607042-2286803058928736-2488811101569286-2186321042880000-2253801907750747-2724998819111208-2186930668597155-2321726757878976-2187337148693125-2221194875437296-2457004439664919-2187946963271680-2255477960289123-2727025217109000-2188556891181115-2323453162635072-2188963572754205-2222846423700144-2458831265283375-2189573689571840-2257154843558891-2729052619454952-2190183919748435-2325180423000000-2190590802848565-2224498790422128-2460658996195271-2191201221980160-2258832557765875-2731081026397896-2191811754498795-2326908539185728-2529483275972175-2732095606671000-2563685754513556-2192829560696320-2800334650128651-2834336750712096-2598383237902375-2564876099517696-2835126235117092-2565352340668832-3038199256598310-1688045158400000-2937471220058007-2735140855070088-3039327475404030-2634328297241472-2364360202968750-2837495567925984-1756707895788716-2331232575257088-2804496524024987-1824781518198000-2872607820258735-2602486201574336-2636529345062886-2569164392313504-3008905876388375-1758175533350912-2400808547669463-2739204705116232-2468894994317987-2333829566376000-2875274143364785-2300432693106784-1826983655510778-2537712672268800-2402590829917375-1692122307886800-2504573293398302-2335561964845248-1794148760441097-2505270212750000-3047232828559590-2200983355883520-2980069175685976-1761113260288928-2777397657387750-2676033658147264-2202003999214045-2236088291362992-1795813142746787-2541480619200000-2440047590055432-3016449557911592-3050625029053230-2644120115874432-2508756748807250-2305557734664928-2712672285989040-2204250525102080-2814919245050947-2815180143399000-2917203987669746-2646081386742144-2239199442421722-2850154306408416-1730611189453125-2545252294003200-2409728779630943-2511781028687248-2240444710411974-2342500131768000-1833430829166414-2784356612651376-2478986145789751-2954681854722048-2309620453330500-1766343962679712-2242105785783798-2683981284170688-2752185088069389-2242728900654000-2616759403140267-2413079554600448-2311332498567076-1801646586406152-2209771201941875-2651971017940608-2890236047955705-2312402956357856-3060816733547910-2823014592000000-2959337483816487-1734944670389208-2517603780897198-2347712764593216-1803482559996625-2518303115276784-3063084635082870-3029330777056768-2961530059271823-1770273779092000-2791843983087542-2689952319323712-2860467209795748-2315830642228192-2486342410356375-2350321978343424-2827460558024179-2691446460551928-1805821057051127-2351192145672000-2215096114039965-2249382644219568-2488183747580591-2215711076866560-2284098123296875-2761627851386856-2216326153501395-2352933124605888-2216736267823285-2251048133862000-2490025993686343-2217351534161920-2285789160491379-2763672365722824-2217966914336875-2354674962752064-2218377231034445-2252714445410352-2491869148897887-2218992800960000-2287481032122107-2765717888885928-2219608484749955-2356417660322496-2220019003873125-2254381579067376-2493713213439479-2220634877460480-2289173738394883-2391895178750000-3041405030456739-2392337467058560-2221661586539005-2529510084737136-1709286429818750-2495788873261568-2290867279515531-2769811962688872-2222894055107635-2359905634584000-2223304979231765-2257718313518448-2497404071409831-2223921460367360-2292561655689875-2771860513826376-2224538055451595-2361650911699008-2224949182151085-2259387914718000-2499250865287103-2225565967173120-2294256867123739-2773910074786344-2226182866171875-2363397049086144-2226594195496645-2261058338837232-2501098569391447-2227211284480000-2295952914022947-2775960645817608-2227828487468155-2365144046957376-2228240019468125-2811270091794992-2297225497595301-1783085929990144-2297649796593323-2778012227169000-1783579935632092-2366891905524672-1749603374885007-1715455800489200-1784238751743500-2505027963875328-2985719907590151-2780064819089352-1819222686417447-2677593750000000-2643509626257577-2334743476520544-1785556870631404-2575560117004800-2472765925509000-2816465562837712-2919776437366655-2473450649316864-2404965615376030-2611346491076000-1752512645490381-2302532990795776-2440222801308487-3024780581921472-2268794760597750-2372140647522624-2303595469471671-2544504363091568-3094952980892310-3060846971712000-2992339922838207-2923820199555080-3096095205570030-2649125800384448-2305296115109375-2546382803640624-2753100187774640-2581269484646400-2443827154804119-3063671499653000-2409851498410370-2754369989821440-2926787996892145-2341646316952672-2514058003317375-2514289827685888-3031204200477464-1722433917243600-2273822404050054-2721947454056000-2722198409597259-2619065226870688-1723228080350350-3067628757221376-2344022306946500-2792401606494216-1792818130028796-2379151032790848-2241435817734685-2276129220750000-2517768903551023-2242055645739520-2311254966017259-2794461279364584-2242675588001875-2380905784557504-2243088946325045-2277807885217392-2519625722260167-2243709079040000-2312959378890227-2796521964794568-2244329326040555-2382661398927936-2244742887538125-2279487374834736-2521483453663199-2245363325038080-2314664629492603-2798583663033000-2245983876851715-2384417876114112-2246397641573605-2281167689804784-2523342097984375-2247018383933440-2316370718030211-2420311681518640-3077536806407971-2420757465840000-2248053208631165-2559557779461232-1729590174964350-2525434164347392-2318077644708875-2802710098930536-2249295417590195-2387933419781568-2249709588910485-2284530796614000-2527062126278183-2250330941214720-2319785409734419-2804774837087304-2250952407916875-2389692486686784-2251366782611245-2286213588858672-2528923510699327-2251988440000000-2321494013312667-2806840589047848-2252610211814755-2391452417255616-2253024789933125-2287897207267056-2530785808935639-2253646752481280-2323203455649443-2808907355061000-2254268829483515-2393213211700032-2254683611075805-2844631749506608-2324486087961125-1804244703086592-2324913736950571-2810975135375592-2533580970184107-2394974870232000-2429908111334270-2360699254397664-1770687267606717-2881971738529792-2465527833984375-2361567743905568-3125891778829470-2500943366674944-2813819989929309-2362436446396000-2779592535647280-2397618978657792-2328336817269179-2815113739904424-1807399653689500-2711348708285568-2537777569816269-1773130867821672-3094571628247591-2608024780800000-2469157056501191-2817184564616328-2260911441860955-2400265032472896-2261327037848125-2296327698860976-2540111015193679-2261950527316480-2331763255915083-2819256404625000-2262574131379315-2402030149474752-2262989931090005-2298016278509424-2541978801030375-2263613726167040-2333477735125331-2821329260179272-2264237635866635-2403796131624000-2264653639350765-2299705685740848-2543847502252031-2962286275530240-2823143842049625-1847411925567688-2300761985607558-2405562979132608-2580116062298866-3138267164670000-2615462793578325-3034215438974976-2894977086433011-2965007797632040-2860623098843750-2407330692212544-2267983501727645-3140573159677680-2756978417644281-2827034851392000-3071628461197208-2827553922604008-3002369869814882-2723329610781312-2409320404319625-2304778874960496-2549459100469319-3108529938935808-2375274564316292-2829630842829000-2410647487960599-2725329852795264-2411089957442433-2306471594551344-2551331465473375-3040906918789632-2936317462921332-3111383721062888-2272567389826435-2412639027000000-1853356521309353-2308165142738928-2553204746983671-2903225132122112-2483709560986375-2903757801400728-2274235788320795-2449401656723840-2274653015493885-2869825463902000-1820056234954412-1890231744678912-2485532634267887-2940899842468896-2310918926307750-2416182248601024-2276322434477845-2311554725715312-2556954060420007-2276948677120000-2347223833271187-2837948694114888-2277575034609355-2417955159560256-2277992670078125-2313250760909616-2558830092794559-2278619219002880-2348945881684763-2840030700777000-2559768452994043-2314523331593088-1788659228418687-3156746762061360-2595785221237750-1824232462221312-2385753380689604-3122816315643208-1859825077569207-2456597837680000-1825068473541092-2878256306324016-2808312230112560-2422391230788096-2914157879170875-2949538426542624-2282590030286995-2423279095616448-2283008278573685-2318343843750000-2564463695234823-2283635746795520-2354117080059059-2846282829962184-2284263329976875-2425055476067904-2284681782636045-2320043197791792-2566343398567967-2285309557440000-2355842497914427-2848368910252968-2285937447231555-2426832724422336-2286356104313125-2321743382052336-2568224020201399-2286984185774080-2357568758644803-2463357045310000-3132269261850979-2463808099455360-2288031243804605-2886703644427568-1830760125187500-2922442299319808-2500149346781743-2922977316521016-2324507952699174-2782620235208000-3029458758656526-2395605219072224-2607220731858838-2290335896309760-2361023809553875-2854633266296136-2290964706381195-2432169679023168-2291383977029485-2326848918174000-2573871397145983-2292012978910720-2362752600144219-2856723424196904-2292642095891875-2433950401109184-2293061571162245-2328552425337072-2575755694223127-2293690880000000-2364482234432867-2858814602122248-2294320303965755-2435731992158016-2294739983908125-2895167494334512-2365780013950181-1836295679821824-2366212712625643-2860906800321000-1836799464642012-2437514452381632-2367078268250399-2614623986116656-2826878955470000-2650441313587200-3074793000578631-1767283962371600-2898610653559238-2757467057904000-2333454639361626-2970122826404832-1874177362365651-2298729496194560-2369676201546875-2900465792590032-2723857043082791-2547215980383744-3148929724432221-2406143700716000-1840160385033932-2866665608183808-2973110057697108-1840664876424608-2725848955281375-2513674790806976-1770355250012650-2337082433695152-1770678750285950-2585427152192000-2550243297551112-2940132363810104-2479856216677490-2763520770471552-3118103098099000-2976643003465824-2587080792387879-1772134989209600-2977458695908116-2942281452375000-2907097750466182-2765540641828224-3191299840302930-2411424511686752-1879664261597875-2518270733339136-2553972517929096-2873481429189672-2589917244351867-2448227478264000-2945238158750623-2697090791322528-1774563827982350-2591099710963712-2520340733838375-3159588754172744-3053364455819218-2805090815406528-2379218219290903-2628033106822000-2841376184984880-2664033293913600-3090560657867679-3090842711955288-2487111894531250-2736072748437952-2807395737900507-2416713043610336-2594649270183047-2452700487168000-2381825026007347-1777643541648400-2346703564219542-2844748686648320-2489382192788750-2418477604327008-1885161859469459-2454491215123968-2952773257143627-1921256634726000-3024476113537535-2740069445674176-2882673621302517-2704977497146784-1922132987138250-2598676021116928-2563311470275656-2883988389718152-2884251391364619-2813291831000000-3062850124268286-2422009302126944-1852293642073004-1852462533961728-3099594902733375-3028615954340360-2921990004624726-2565883667326464-2316633934252885-2637639066654000-1924939105597674-2459868628242432-3137509731179736-3137795721979072-2924121612191750-2817398326152384-2425323389866484-2710902605472032-3210571980680310-2461662843072000-3139798144204568-3033035946523080-2926254256186294-2748074512646848-2320014544453125-3212620534689840-1820650845281133-2606267085520896-2570799002478408-2892412375317000-2892675888849771-2750078212540736-2357424637275642-1821812256781704-1821978213019125-3179820234525184-2536941589347663-3180399542272808-3073474979073634-2680600213800000-1930207936335534-2359357891498608-1859057328221964-3182137887666176-2431517772986500-1966847878959480-2610781266774979-2467949465322048-2754339308208873-2432625021500000-1824634883648901-2397287603022336-2540640540689567-1789346369333200-2791634459942250-2756095155568832-2362582330118538-3007196687200608-2613635012555767-1790323916800000-3008017951653204-3223169721101520-2793668005467066-2829741784330176-2364303231320250-2436170475519328-1827294135528213-2544111571369472-2544343085753839-2902965404913000-3189968280880379-2831802525929792-2652815873197458-2437944493636832-3226984817343750-3191419761905664-3012400554141972-3012674608049568-2331448382233035-2475147271848000-2869997018571280-2439719372771424-1794074480304350-2547817487133184-3122257502631375-2978976356304248-2369040018100998-2476948907544768-2333569873548485-2369686433334000-2621255166333783-2334206571806720-2406247101994019-2909309526666504-2334843385866875-2478751417291584-2335267992913245-2371410782135472-2623162516226927-2335905000000000-2407997895633067-2911426286076648-2624116538044971-2372704592548224-1833620211231375-3236094500779440-2661030664999382-1870083401498624-2445715949341572-2949513751882000-2913808867406811-2770168805845056-2374646190391002-1835120627743944-1835287391197125-3203047463980544-2555472300729823-3203629589283048-3095923352143874-2844187989032000-2412378594773487-2664660222571952-2880975470653360-2701159877836800-3133630109484375-1801100447078800-2954073057636006-2810227183760256-2378100534703674-3026948326668000-1910033724945923-2342706951569920-2415009562744779-2955951783630928-2920168771747875-2848324487701824-2451944991552404-2740657964826272-3209746163810391-2488680854016000-2993902419497443-1948016990344752-2922290794571067-2778232360687168-2670231951893250-2453949427530848-2634626049022079-2490489050254848-2418520494715483-1805029881250000-2816102221268778-2780250691418816-2383288329831882-3033551374682976-2636539878820375-1806013131980800-3034377430240212-2998525996182296-3107188412896594-2818403376048000-2385019269994746-3035754522723552-1843303923233397-2349522094799360-2422034827824875-2964550389582672-3217913700346907-2820449899053696-2531402626725630-2459299930124000-3255251077521990-2640609844015104-3147313649521479-3075240544984040-2388050431593750-2822497412512128-2424672810644711-2678239730500848-2895656908163120-2714924558400000-2570361672001311-3222294860235752-2534619050795090-2896970170936320-3078309925575625-2462871249123808-2644204466233719-2644444223635456-3188112213789272-1811591631450000-2391517759789686-2862833814460352-2863093356373203-2754617993188384-1812412966618750-3226387528917504-2465328535449764-1994196475545560-2647082511658827-2502263679000000-3046510146061284-2756616144347808-3264709714535430-3228727751888896-3156458104038375-3084175322176360-3265893330843870-2794406383669824-2939836721636349-2758615261556000-1923945481771443-2504986161004032-3013517235633451-1960779208619376-3086691342649375-2796432539276992-3123571239884718-2470024256094176-1852686007832109-2434141310976000-2579696834369831-1853189515924248-2398462481703222-2507710617013056-2435243896484375-3271519415193840-1854028898788533-2872187208939008-2581566575003919-2981797594354000-3091167645902735-2618637931869696-2546128519454590-2764618411807904-1855372438504125-2437670756503552-2583437218867063-3202296590598336-2401939878664854-2511346296936000-2438774407488807-2985038874141616-1856716627135557-2730712788748800-2585308766177375-3022535917879288-2986390100336886-2804546955809984-2695522831314226-2477191099500000-1821628887097550-2514075361738752-3024451282023891-1967893354958256-3097890211904375-2806578009652032-2952641412792333-2770630264903712-1968783831288666-2661744870208000-2625520129364232-2953977369009768-2954244608601507-2881560954080576-3137172909972750-2480779714044128-1897238442760076-1897410055716864-3174800116825383-3102096761105000-2992881662455302-2628133769120256-2628371458707624-2409558399073584-2665358643109375-1971813460091904-2592803994252543-3104341810238920-2848947721958442-2812677054264000-2557210338811870-2484371792710624-2667287325382551-2375196588277760-2448500903643875-2960395568547336-2375840835563195-2522274417346368-2376270398467485-2413046510094000-2669216937841583-2376914839902720-2450272131283819-2962537032496104-2377559397841875-2524098847233984-2377989167864245-3000195906588144-2451601112433133-3183710016000000-3074204684846484-3111083456264680-2672113101119171-2525924156682816-2672595998579125-2489766409595488-1830875996037150-2453595485039104-2600313694931359-3003450503202000-2380999008240515-2564384408888960-2784440286789372-2491566349095392-3041451270710125-2895136780713984-3188603159550231-2382504880355080-2712635141541966-2822861753096000-3116427509493185-2750037304278600-1980205664070618-2750533999756800-3154230450843750-3117834855709960-2567860544765810-2751527570126400-2384872533419285-2421781511622000-2678878960773543-2385518529105920-2459141083442579-2973259844209224-2386164641436875-2533234194329664-2386595447798445-2423531037659952-2680814159057087-2387241754560000-2460917438106907-2975407506687528-2387888177993955-2535063904764096-2755752913584375-3270455229413304-2903250312857617-2903512291770368-2462694647995683-2021797421875000-2683718703594323-2536894496031552-2426813669628282-2500579060032352-1949156569987875-2464250408361472-2611605412617103-3053278919789496-3163923779796194-2575519098320000-2870123003169318-3091180490221152-1913760519967244-1987545940402176-2613490537808375-3092295835868064-1951267379193639-2577378007738240-3129955527349265-3093411449772000-1915141673198572-2467808892156416-2615376569936607-3278725387439336-2579005287031250-2874007846988928-3132213996119305-2505997104864736-1879667269808589-2764465766400000-3243932236779608-3207358469253816-2728343923237838-2544225673670976-1954436449478625-2729081756626544-3319452645381270-2397598537351680-3246272103058072-1918424575028000-3025480615016022-2915054972613952-2509387353923476-3100110768399456-1882379713516125-2768454893875200-2621040110124183-2990470108826952-2695357861382627-2547896553000000-3138995920441585-1846634536980400-3139561522275795-1994724645037056-2549044426486125-2697058045012968-2734250315322782-2549733316033728-1958667211499337-2439314703606000-3326637821330790-1996162457075712-2624820342266087-3142673546867240-3032028681531750-2921363854581184-2588783348620910-2810932156940832-1886453269838709-2404519673920000-2478728056055787-3033940312384336-3145221277887695-2886462901625472-3071769094859375-3109058229477984-3331433694310470-2628367609352192-2665626801860808-3295307506293000-3184516343117426-2925574828859072-2481407037781479-2740905188474096-2963407429630000-2704352644505088-3223285672526511-3149470555490120-2445691323056454-2557089195576000-2483194097545007-2742879074388912-1890532698834957-2558009674039296-2669467646781000-3114659125681824-2892443679287994-2929789847775168-3004231988411469-2819039148500000-1966085728555203-2559851293604352-3079518396072091-2003722306876656-3154291028179375-2857673586615232-2895046592122854-2821068329022112-3303916605367831-1930551846912000-2636182843566551-3007746658308168-3156561186867495-2896869559938432-3082843510876375-1894447666266696-1894618004735013-2860758886526464-2638079775951039-2006607262662000-1932462195238172-2564459209144512-2416012083297605-3345548223386160-1895981080078125-3011534751891456-3234902151766071-3049262293144464-3198294239308754-2863846406344000-2417749960947165-2455166750451888-2715807275680751-2418401879861760-2493038264888875-3014242479432936-2419053915954195-2568149520427968-2419488671786485-2456932316454000-2717760215669383-2420140903198720-2494830904013619-3016409829685704-2420793251816875-2569996002936384-2793724864632975-3315517982630488-2943252236195721-2570919576000000-2496624402273467-2049651876844440-3317007299822603-2944574293537856-2758456552979250-2535025562744288-3355482210312870-2013470128078848-2498418759874243-2013831764334000-2722646661203763-2573691622746432-2424709805439805-3059139327279408-2835554432876500-2425362974794240-3097280001385179-3134878043693088-2911219513726602-2948807537352000-2911742221241958-2538669803786464-2762918068689558-2427105333186560-2502010053921875-3286517118084288-2427758932656395-2577390783693888-2689692624906408-3063535957774000-2989083792159280-2578316127432192-2503806990780379-1943427563506208-1980978911157375-2915664522096768-2504705781758351-1906738151767272-3365133928516710-2654954942464000-3290943601890648-3253838400659256-2767880947608718-2581093487474496-1982756902594625-3367247706048240-1945695409092396-2656860868408832-3293306017570712-3031610378625000-3069312925493782-2919852190429824-2545740456246036-2545968760125152-2733417451010375-2883452301176832-3295669563559384-3183602640172520-3071515583969478-2884486661672000-1948139676661412-3372082521041520-2772849766004678-2435829643087360-3110645931028875-3298329904205248-2473969189465158-2924043866580096-2549394956448212-2849579182148000-3374804137149990-2437577010053120-2512804581652739-3038140501054344-2438232488046875-2588509530318144-2438669538651645-2476409438669232-2739304381970447-2439325212480000-2514606682583947-3040319290549608-2439981003823155-2590365757949376-2440418263343125-2478185172886896-2741268568958119-3192174019973120-3042226585642689-2028332747646000-2479295437724886-2592222872772672-2442167823820205-2479961755773744-2743233694653375-2442824124515840-2518213468849691-3044679994061352-2443480542782435-2594080875000000-2443918220282565-2481739187532528-2745199759280471-2444574834524160-2520018154595875-3046861908575496-2746183143763539-2483072818545792-1994161246235137-2558775573468000-2747166763063663-2446326380792320-2521823702358699-3049044865260264-2446983426281875-2597799542514624-2447421521961845-2485296598476912-2749134706227207-2448078763520000-2523630112343987-3051228864364488-2448736122733355-2599660208225856-2449174427578125-2487076578068016-2751103588995359-2449831982906880-2525437384757563-3053413906137000-2450489655918915-2601521762188992-2827994042282775-2752827132363192-2074233392295625-2451586039152640-2527245519805251-3055599990826632-2452244026038235-2603384204616000-2452682749362365-2490639086501808-2755044174242511-2453340932456960-2529054517692875-3057787118682216-2453999233290995-2605247535718848-2454438165929685-2492421615750000-2757015877170023-2455096663019520-2530864378626259-3059975289952584-2455755277876875-2607111755709504-2456194419880045-2494204995289392-2758988520599167-2456853231040000-2532675102811227-3062164504886568-2457512159995555-2608976864799936-2836097897784375-3365803652329144-2987890496925777-2609909752823808-2534486690453603-2080734716115000-2610609564760359-2686519467932608-2762442910356741-1930098327404424-2876481970812500-3368812774500864-2574154352830244-3104404660157264-2461028437630035-2612709751128000-2991630591293339-2499560237682288-2764912096138951-2840916879052800-3295757966466375-3296052370762872-2652233051510210-2917716952417344-2993769188722051-2880338993204000-3411232401966390-2615511751337472-2729473400077704-3146757282932472-2464548067791875-2616446196398784-2995908805106667-2503134654450672-2768865853118327-2617380864000000-2541741679713667-3073126243219848-3073400621325387-2921888595230528-2656499504408750-2580829901813088-1935795224076693-3150693071812096-3302828509441023-3075321725361000-3417329149031790-2923975906923456-2468511661030805-2506712477249904-3418549369503750-2545147216556032-3305187602361831-3343476620442816-3115790335484038-2964065046384000-3078342220306941-2888578827996448-3268946651481562-1976748758120448-3193494445312500-3383885290415464-2471597392087395-2966181479753856-1977630736493828-3118849758054000-3043051694287280-2624866219425792-2739235164993864-3119962771696528-3120241066475750-2739968234168832-2549920076592151-2512085601304752-2778766731816687-3235838866240000-2588901956373028-3084114110468328-2475127089415955-2627676902824896-2475568537723125-2513878347428976-2780749735564679-2476230808596480-2552650102316083-3086314822125000-2476893197574315-2629551806002752-2477334855845005-2515671946277424-2782733682505375-2477997441687040-2554471201574331-3088516580431272-2478660145661635-2631427600824000-2479102013945765-2517466398052848-2784718572863031-2479764914831360-2556293166759875-3090719385635976-2480427933877595-2633304287500608-2480870012225085-2519261702958000-2786704406861903-2481533228229120-2558115998078539-3092923237987944-2482196562421875-2635181866244544-2482638850882645-2521057861195632-2788691184726247-2483302382080000-2559939695736147-3095128137736008-2789684927678051-2522405539995264-2560851869506375-3134456054294192-3058278253896240-2637999907450368-2599999547400292-3250288854765000-2026831170593663-2677185203692160-1988943240104964-3136689765989488-2792667572948375-2486843211939840-2563589690891491-3367402655266496-2487507492021435-2640819957000000-2679331211977070-2909247133375008-1952431731116277-2565187654143488-2718575152311375-3369801517263808-3293508240204898-2949101234380224-3179184260045807-2604864699148000-2834957982327894-2490387406008320-2567243153872499-3372201518254272-2491052317056875-2644583148393024-2568157061658471-2530051459467312-2798639239879007-3182297592384000-2760792916633992-3336254901025176-3144795866533494-2991657312339072-3298787393968750-3222358035218784-3452833585042470-2724144347348992-3376704590995032-3453755050530000-3300548364692626-2955404975535936-2610200158180916-1957824224836104-3416899066293375-2879665394419200-3379107868096664-3456213093294480-2534781649119654-2650234636056000-2650470289273449-2919618154941088-3457749962106630-2804868772319232-3343086009270375-3112805071839816-2036954762357319-2998048981589376-2959875556233673-2614148437500000-1999232386515052-2883764561625600-2691752829414390-2115136635978520-2807612692602875-2730934496310336-2808111779383789-2616007828174816-3077929781158320-2000832151552000-2616705326925508-3463594218605520-2848097194520078-2963823928276288-2001721278550500-3156840944525872-2810608100492399-2502818601454080-3196190767135547-2118145899815000-2503485723245715-2657782469579712-2503930536959605-2542678393782384-2812606222234375-2504597856317440-2581891716985011-3121668722183112-2505265294229035-2659671664488000-2505710318705165-2544485663792688-2814605290757151-2506377954229760-2583726695778875-3123887260724136-2507045708336195-2661561754431168-2507490943624485-2546293789974000-2816605306284983-2508158895390720-2585562543793219-3126106850144904-2508826965766875-2663452739621184-2509272411917245-2548102772529072-2818606269042127-2509940680000000-2587399261233867-3128327490694248-2510609066720755-2665344620270016-2511054723783125-2549912611660656-2820608179252839-2511723308257280-2589236848306643-3130549182621000-2512392011397515-2667237396589632-2899428322409775-2822360628071512-2899942846378125-2668184120692224-3364530620207631-3210124319412856-3171729470765238-3017278599504000-2862800293052914-3249953458772832-3482401861149030-2824865385316352-2592914632171875-3134995721602056-3135273770002923-2709736153568640-2555120672398074-2942521099412000-3484873475567190-3446458259466752-3369308509786719-3292145041704840-3486109721208750-2982824997541312-2673158097800457-2557160538007152-2906121882653925-2906379532800000-3410454312524248-3216963665846104-3178486814904774-3023706697095552-2868899105133250-3256876843897824-3489820212278070-2520649111252480-3218960303501067-2094448947750000-2521319397613315-2676714720668352-2056209461898281-2909988233989800-1940164075068750-2832890566279168-3221243186524819-3027460633447536-3027728890584762-3066817640024000-2795321956059432-1980195148856328-2019201385065644-1941711803827200-2757475030763375-3223812719789368-2524896265148595-2680511927414208-2525343611304085-2564422185798000-2836657596177703-2526014729605120-2603968876344339-3148360597481544-2526685966796875-2682411876730944-2527133524313645-2566239743242032-2838668043562047-2527804959680000-2605814299368347-3150591763002408-2528476513965155-2684312723626176-2528924282893125-2568058159290096-2840679440642519-2529596035399680-2607660594082723-3152823982389000-2530267906853115-2686214468311872-2530715887242205-2569877434144944-2842691787643375-2531387956963840-2609507760693291-3155057255890152-2532060145660435-2688117111000000-2532508337560565-3195139402678256-2610893707956909-3390564969811968-3273938614180500-3313207217520360-3313500378459655-3001907104297024-3041161960857462-2963445615796000-3470657816095759-2027979470739456-3393265818016239-3237539977743352-2886736768854750-3082059162424384-2692163209328697-2575340413577712-2848734530410807-2029415038976000-2615054493960387-3161763403569288-2849742486007091-2693830429198656-3123557866250000-3201929944035632-2850750679335759-2538564105658880-2616905150213963-3437433072216000-2539237564076915-2695736666016192-3242984430910671-2969742257862304-1953950533768750-2853019983679488-2775100361744663-3478954450620808-3361983493091634-3088606671736000-2697882257106849-2580811129570608-2932999140960525-2620377483657728-3363766880991750-3520532274708240-3520843413221070-3051667294056576-3521465745241410-3247860954625000-1995849952001901-2622230650126336-3405286941633399-2700983453691816-3523333181298750-3053825220171648-2584234258220538-2623621098212104-2858824787694767-1958272156800000-2663485409622308-3172961421883368-2859835121876331-3016804879191488-2742792143498750-2664661999343328-1998673019145213-3253029658464256-2782957889446839-3292804348932000-3214688128124102-2705281340277312-2548678491990605-2588117461671984-2862867552609375-2549353737981440-2628027426370811-3177448021945512-2550029103228035-2707192974648000-2550479412984165-2589946196783088-2864890363535351-2551154977013760-2629884197423875-3179692907129736-2551830660327195-2709105509352768-2552281182143485-2591775793134000-2866914127072783-2552957064286720-2631741842843019-3181938849414504-2553633065741875-2711018944603584-2554083799668245-2593606250927472-2868938843445927-2554760000000000-2633600362834067-3184185849048648-2555436319671755-2712933280612416-2555887265758125-2595437570366256-2870964512879039-3343198794923520-3186152841281049-2084950580653000-3344083629183135-2990267932419328-2911833491774578-2675974895642592-2912347178549750-3424277728100352-3385216751530518-3109950107252728-2913374733335566-2716764655752000-2756381109388270-2992906248777248-2008574716478517-2638948481310208-2796744227359375-3466692853322688-2088078650017199-2994489983236352-3191777282317509-2995018018852000-2009991908641341-2877300875096064-2838135968203464-3232606456006928-3035763884451375-2996602498137856-3312326277846852-2681643331315296-3549546648118710-2642673178688000-3431833279190127-3471585568183744-3235171639555574-3077629585460352-3196281597931125-2999244538629536-2091762735356619-2881361035657216-2644769860316483-3197690065125000-3355896341945335-2842892060299776-2566725893347005-2922376149620336-3515059335757375-2962389603571200-2804642538406703-3436977397110744-2765627708716530-3081970898448000-2805630871597651-2687319766190304-2924693792515478-2569214053519360-2648500032049875-3202199940559176-2569892921619595-2728280421407808-2570345566783085-2610119169438000-2887204205413503-2571024634181120-2650366432450139-3204456467535144-2571703821171875-2730202873777344-2572156678944645-2611958252808432-2889238462477847-2572836065280000-2652233709480547-3206714054348808-2573515571236155-2732126229024576-2573968641668125-2613798199851696-2891273674844719-2574648347015680-2654101863346923-3208972701249000-2575328172012115-2734050487361472-2575781455153205-2615639010770544-2893309842738375-2576461479587840-2655970894255091-3211232408484552-2894328285077827-2617020186000000-2022420786147351-2934751071921392-3490281274543976-3292259437619712-2816517865241375-3292838686830328-3055070866774311-3015659859066112-2103210933322537-3293997389073000-2897385046003063-2818252479397888-3493352533518936-3295156363104152-3414558660495250-3097197641685888-2620936156054458-3336030254846688-2025625043465109-2979122289600000-2820483743902831-3575575438546320-2940176067396158-2741756555845056-2026693880859375-2662753486609192-3418163155748938-2822219985825792-3418764151467254-2862472751784000-2624164004226006-2982266666097600-2187187784685035-2664626576512968-2943279064367750-2585539911984640-2665329211626651-2108580043151816-2586221652795235-2745615014136000-2586676213239365-2626702029025008-2905546928721111-2587358153768960-2667203509107875-3224812932875016-2588040214143995-2747545600035648-2588494987646685-2628548892750000-2907589791581423-2589177247787520-2669078685071659-3227080069425384-2589859627801875-2749477090720704-2590314614413045-2630396621972592-2909633611762567-2590997194240000-2670954739723827-3229348268301768-2591679893968555-2751409486403136-2592135093738125-2632245216895536-2911678389488799-2592817993326080-2672831673270203-3231617529753000-2593501012843715-2753342787294912-2593956425821605-2634094677721584-2913724124984375-2594639645245440-2674709485916611-3233887854027912-2595322984627035-2755276993608000-2595778610863165-2635945004653488-2915770818473551-2596462150197760-2676588177868875-3236159241375336-2916794524535819-2637333318356352-2118044421543257-2997495679425000-1998505801493550-2918074494029824-3318101838725731-3118489777523952-3438636552979250-3039061701076736-2679407864945991-2959605622209008-3599836126433910-2000084400000000-3480452140966287-3240705206283048-3601099411508430-3121226575089792-2681288756063375-3602047069243440-3482284225693641-2842113380810752-2882395914575688-3323053359263000-2802820897515170-3083373355841856-3203785704127760-2723456643479392-2042771589307125-2603760704330240-3525400498075544-2003244090411600-3285608351087638-2764961613912000-2604902337430965-3607104051814320-3206595795805360-2605587477442560-2685994834421875-3247532132909256-2606272737580395-2766901257204288-2606729644414285-2647065165822000-2928071109832543-2607415104785920-2687878806531579-3249809903917224-2608100685311875-2768841807401664-2608557805753445-2648921561171952-2930124515556087-2609243586560000-2689763659387907-3252088739739528-2609929487548955-2770783264716096-2610386821648125-2650778824249776-2932178881067279-2611072922964480-2691649393196683-3254368640625000-2611759144491315-2772725629359552-2612216692298005-2652636955258224-2934234206590375-2612903114199040-2693536008163731-3256649606822472-2613589656338635-2774668901544000-2614047417902765-2654495954400048-2936290492349631-2614734160463360-2695423504494875-3258931638580776-2615421023290595-2776613081481408-2615878998662085-2656355821878000-2938347738569303-3421663311790080-2616795109787105-3301476646471568-2939376721921875-2778558169383744-2617711434775645-2980424625518448-3222362679971120-2014152937600000-2739487726282788-3263498899775208-3424959038170895-3062584298191104-2982250919335250-2740686591824608-2982772854564822-3507080331300864-3467072394042934-3185147484531000-2983816907708654-2782451069931072-3387628083147588-3065264975197984-3630236600013750-2016974538316800-3509842697898351-3268070426198952-3631506986960910-3147581346000000-2824999560103070-3390295973535072-2098938209478604-2785373130326016-3350814324577875-3149233426920048-3311022103260326-3028638700958400-3392371967512836-2019445599550000-3392965264267404-2625738404856320-3474357645197542-3232243180091520-3313338920881750-2788297235788224-2626886452645845-2667533273158512-2950711398114407-2627575441920000-2708660674296787-3274935717494088-2628264551657355-2790247775931456-2628724025078125-2669399224666416-2952775373836159-2629413335610880-2710555228950363-3277226282697000-2630102766634915-2792199225523392-2630562454262405-2671266046132464-2954840311812375-2631252086128640-2712450666820451-3279517915700232-2631941838514235-2794151584776000-2632401740398365-2673133737759408-2956906212267311-2633091693672960-2714346988112875-3281810616752616-2633781767494995-2796104853901248-2634241883685685-2675002299750000-2958973075425223-2634932158443520-2716244193033459-3284104386102984-2635622553776875-2798059033111104-2636082884324045-3325810334078384-2717667676728693-2028287292800000-2758711569575908-3286399224000168-3448991642962495-3124653441181888-3165509691015750-3084612041032096-3612558390088807-2110892528369664-3531993867890583-3369897479599000-3004749165064014-3208052749100992-2802214686665073-2680613209931184-2965179443359375-2640458698109440-2721941111622411-3290992106430312-2641150058426035-2803927033368000-2641611032342165-2682485255403888-2967250159571751-2642302593781760-2723841853113875-3293290151460936-2642994275909195-2805884855035968-2643455464381485-2684358172254000-2969321839608383-2644147347678720-2725743479262619-3295589266033704-2644839351691875-2807843587848384-2645300754770245-2686231960684272-2971394483693527-2645992960000000-2727645990274467-3297889450397448-2646685285973755-2809803232017216-2647146903708125-2688106620897456-2973468092051439-2647839430945280-2729549386355243-2852016658470000-3137491847376887-3260015985802240-2648993911394805-3016040595895856-3057064381753125-3546503818186752-3465277041125605-2935549359549504-2161078857449127-3099175643488000-3384921039638263-3385216064714184-3467089687822195-3059463403276800-3467694043828125-3263996468862080-3345887935823606-2978915903464896-2693501126948874-2040708965350000-3428689797539244-3633095011991552-2816914585190853-2980473642270792-3511548840607250-3062664050539200-2654540088944445-3022355072559728-3267695531721520-2042487619200000-2778025136312228-3309406427789928-3473136408586095-3105663042429184-3024198453663250-2779235218100448-3024725271614102-3556405637935104-3515833580593014-3229942343875000-3025779091052974-2821580247385152-3394370347047191-2085879059841864-2086060688065125-2822563148066304-2945539731023496-3682245239992080-3518896242153794-3150913961272000-2741943048650127-3683527730921520-3561053453503689-2906400058343424-2947591835613000-3398214145855768-2866213204789410-3153108955244864-3276242494696720-2785048502364000-2088968173724661-2662642132933120-3605121535999896-2048542772421200-3359902515593750-2827481075550144-2991653331721309-2705017826501232-2992173996549447-3156403357184000-3566636175277767-3484947727394280-2706194842334742-2829449844941376-2665655657218125-2706901215694896-2994257259969119-2666351408647680-2748632071235323-3323262155769000-2667047281130115-2831419528020672-2667511263375205-2708785478901744-2996341490128375-2668207337635840-2750545216658691-3325575197033352-2668903532977435-2833390125000000-2669367730477565-2710670616324528-2998426687251471-2670064127644160-2752459249620875-3327889311323496-2670760645919795-2835361636091328-2671225058724885-2712556628166000-3000512851562663-3494051556986880-3329915041739457-2179022696803432-2713735829697750-2837334061506624-3043202467314562-3701513883584880-3084862996526925-3578752082496000-3414508481429163-3497089686395080-3373956175120694-2839307401457856-2674942299453125-3704088103521840-3251648746973457-3334258660442112-3622719215974232-3334838094837000-3540999925923026-3211883611307904-2841528502323153-2718219912230064-3006777149867375-3666115250256384-2801320145466404-3337156503718632-2843009879564511-3214116411792000-2843503786367049-2720109423773808-3008867185173511-3586221646123008-3462859548004500-3669300775696904-2680059134045995-2845232910646848-2185658539670897-2721999810750000-3010958188789023-3423715472382464-2928974759756767-3424310039467512-2681921417751875-2888473822613120-2682387123435045-3384228303267184-2146282306421708-2229025112064000-2931009653134151-3467974405755552-2725073557242102-2849187826671936-2684250485288125-2725783211810736-3015143101845199-2684949468398080-2767803489414603-3346440884433000-2685648572841715-2851166658290112-2686114709883605-2727676226300784-3017237011734375-2686814016573440-2769725519488211-3348764667152712-2687513444625035-2853146405928000-2687979797421165-2729570117034288-3019331890829951-2688679427765760-2771648439158875-2896003293543920-3185879951100231-2979263029353984-2193258840758857-2069291578950000-3600879634575177-2690545702174720-3435917860246131-2235610306255536-2691245777666875-2857108650110784-3478520849510532-2112142226214792-3727633016141910-2940943256000000-3645428827374488-3604315985643096-3397465932686614-2859091147079616-2693580239683125-2735257048723056-3025622345597639-2694280841441280-2777422537811443-3358070555661000-2694981564673515-2861074560916032-2695448780985805-2737154446457904-3027721103761375-2696149706698240-2779349017928571-3360399718439592-2696850753912835-2863058891832000-2697318186228965-2739052721449968-3029820832252791-2698019435970560-2781276388671875-3362729957976456-3030871060441459-2740477003516032-2117824788249639-3073188464678000-3654919106220008-2866037108193792-3447850536873371-3738956971689360-3406900329825750-3199439616562112-2742614352248298-2119476471285672-2119660044615069-3699334959616000-2951410447807191-3699975759018632-3575567101530802-3284817010796736-2786098713370375-3742844743632240-3618396551348001-2953200007711232-3577425236084614-2787305164875000-3411624070908982-3079049259409792-3079315836067698-3454126236935912-3412805688032750-2247651966910464-2913875145397510-3455322471119896-2706209665456635-2872994310024000-2206983745579393-2748557262364848-3040334037474031-2957293146433024-2999204714133000-3457715767984568-2916398199327410-3208315643273664-3333603411224720-2833808102284000-2125539989379261-2709255967109120-3668233146971096-2084403716701200-3418717866343750-2876974904276544-2710428230037645-2752365226627632-3044546119705247-2711131750080000-2794792938697147-3379071804868008-2711835391849155-2878966579459776-2712304553993125-2754270526976496-3046653618891319-2713008398663680-2796727441859523-3381410667429000-2713712365089115-2880959173630272-2714181743686205-2756176706407344-3048762090423375-2714885913059840-2798662837500491-3383750608987752-3049816690889227-2757606918000000-2131062304079151-2841662061035744-3050871534525671-3469099020890112-3469398917067875-3553306031264360-3553613189255655-3177622914541312-2801567604809543-3763625049990000-2174726869506412-3136896392409600-3639114309143439-3639428821211928-2928529133311250-3221660439974592-3305625572705227-3180370297161632-3766553434526310-2887940493312000-3013763514289992-3432638353473936-3223609642412159-3182019486612224-3559145060390625-2093795620458800-3559760066879555-2261690002603008-2890186881771741-3057998091641000-2220382182314223-3184219292608768-2891185650447753-2765720796887664-3143136001153125-3059583276658688-3688583320712664-3479305189727576-3269990874182682-3312199853496000-3522136895005764-3186970475533088-2096872158520350-2726169192680960-2810293964922875-3523657854606624-3733721747814347-2894933082272448-2727346328963685-3105246968750000-3147481475006325-2098502133350400-2938156611304390-3442137722031248-3232530294753375-3316778403504064-2897183094930417-3191375663610912-3737591446165631-2267947845504000-2982188792768751-3654546720069336-2772654022574502-3319069259923776-3613475815652750-3529746071636064-3067782126783399-3656439395856384-3614723239760374-3110611632642000-3615347059456946-3069105892138304-3237555386289609-3153735107761800-3490434626453125-3238393407524352-3575158263711805-3365145110316160-3449571285913398-2902938423288000-3071489629312493-2777202757544688-2230370333714411-3156456660172800-3661805525736375-3788401390169040-3283564368349434-3325948157757888-3115713783019106-2863335244252000-3158362678175325-2737483691870720-2821957273442219-3538281351207456-2948822030691250-3286113572846208-2738664082672245-2781037127721072-3076260805861127-2739372480000000-2823904290034867-3414268151266248-2740080999475755-2908952104382016-2740553413658125-2782955635588656-3078382913783839-2741262136737280-2825852201987643-3416623224921000-2741970981992515-2910958508797632-3164358015434775-3755361776917816-3333698271176625-2743152662282240-3545302758187092-3756656357237448-2743861833391835-2912965835592000-2237688279192033-2786795297896368-3082630056982991-3420747209286144-3716687503375000-3421336620670056-3632843163586338-3295188096061056-2915225181030441-2788716452742000-3084755092707943-2746936320593920-2831701312064979-3423694943262024-2747646143636875-2916983257164864-2748119426926445-2790638490319152-3086881104815487-2748829453760000-2833652807516507-3426054349330728-2749539602881955-2918993352367296-2750013103573125-3469545995274352-2835117017349341-3681737549512704-2877927665019332-3470740948250000-3598028987749335-3217338147543808-2836581731487959-2794485214479024-3091136059075375-2752618329111040-2837558487793131-3430776412893672-2753329130615635-2923016312664000-2753803066259765-2796409901467248-3093265001676231-2754514071695360-2839512673029875-3433139070885576-2755225199503595-2925029178182208-2755699352699085-2798335471998000-3095394921556703-2756410684485120-2841467755273339-3435502813349544-2757122138671875-2927042967562944-3181842126309975-3436685091336312-3224821400541364-2758308167680000-3522450298246803-3607638882042280-3098591634267251-2929057681018176-2971763347288750-3566422700270304-2292897472313562-3524571404350976-3694747958351103-3822481725210000-2251210574128463-3228428582981888-3780984856876173-3228983772762784-3781635050596375-2124696727756800-3697290143147751-3400099308703360-3485401396125318-3358175371000000-3571025063314884-2168308731419208-2168495113648677-2764005841692160-3061931167269000-3487499109852112-2764718602141795-2977645155891840-3318232612611462-3573788380764000-3446449236002511-3361640582643712-3021480905141287-3191979445795800-3149690342804750-3362796182696384-3490797217403466-2128717773431600-2128900668677950-3789768762432000-2938387757025309-3449708055981288-2768522060750355-2939145116830656-2768997738203125-2811839221935216-3110331743386759-2769711356538880-2855178464454963-3452079396717000-2770425097471915-2941165379184192-2770900992875405-2813771868105264-3112469489577375-2771614938160640-2857140730161851-3454451823915432-2772329006071235-2943186567096000-2772805119475365-2815705399642608-3114608215065911-3626909973872640-2773757509810625-3755563329983168-2774233786747995-2945208680778048-2860085814147383-2817639816750000-3116747920076623-2860822401230336-3031877985723567-2135308604133200-2989688627371250-3288939746000832-2947484665519017-2905016789922016-3118888604833767-3119156259328000-3717669614174247-3547046629905624-3504611832936454-3376684046634176-3633452804480625-3249013021892896-2137691965453150-2137875374361600-3036043487139839-3506717246786000-3678092142132546-3379002401545792-3593171528126628-2909007425444832-3123172914484375-2139343023308800-3722776156356471-2139710040467600-3680616931433554-3338520275376000-3167585754462434-2911004112963424-2311877988364698-2868687200685568-3725331180081375-3725650640221272-2826598021024998-2955333143160768-3640939954811865-2141913024950000-3641564347863035-2313662762852352-2956600329981333-3128265625924232-3342816954740250-3257382927675136-2786158436423245-3172206131079408-3772676609239912-2958375000000000-2872871232035067-3473470384020648-2787591686426755-2959389415924416-2788069545633125-2831205549494256-3131753300610039-2788786436833280-2874841594883843-3475852600581000-2789503450911515-2961418943399232-2789981528567805-2833147058461104-3133900849871375-2790698747466240-2876812858444171-3478235906092392-2791416089270835-2963449398552000-2791894385426965-2835089454822768-3136049380673191-3651877141975040-2792851141640625-3781414647786688-2793329601704395-2965480781594688-3180643086374786-3524798251214000-3138198893239743-3224453066457600-3052743646046527-2279003785223112-3010262756751250-3354580017879168-3612933978834852-3269124927290272-3871663628788710-3828972957696000-3743249086931127-3657510499997480-3872989730205630-3313841559119168-2367232324386875-2883966242581512-2324589680636442-2884460016049664-3745813468370463-3746134098375000-2282323006595503-3273045188606208-2971834836477513-3273605481647264-3833892408432375-2326380990603264-3059021959443703-3748699797114744-2844084586885014-3404574379064000-3706562670150366-3620673324099552-3146806765638431-3491961057713664-3578488468668875-3751266667072152-3191005551786462-3148153165913536-3105293416812648-2933028009324000-3709735101010346-2976669983834112-3796657474193496-3149769353121352-3365794851656250-3366082739680128-3323212046118041-2891873382734984-3151116598256847-2806028713280000-2892615417241547-3497341582280808-2806748679591155-2979726461616576-2807228725543125-2850660596259696-3153272989455719-2807948897095680-2894594796467923-3499734699549000-2808669191807115-2981765275409472-2809149456708205-2852610988298544-3155430364213375-2809869956707840-2896575078464091-3502128908256552-2810590579894435-2983805019000000-3243543535147575-3503326421977848-3287352642867252-2811791892316160-2898556263435875-3547789939623312-2812512844052795-2985845692600128-3029377666002030-2943075484508000-2207495223704181-3592897237569024-3073704820340687-3636806549169696-2857734999627750-2987887296421824-2988142562316297-3291568638390432-3854929409524151-2339145741312000-3075806199435831-3769267573318776-2859688616787222-3423252994543296-3726897511718750-2947100890665568-3164069703316959-2167356120857600-3771521727296943-2167726334850000-3728807707165826-3382230681957504-3209056967625138-2949114969455072-2342144218610250-2906241887895552-3774099003522711-3080274809613112-3384252798468282-3297758616544000-2907482775650807-2864332025497008-3168395280052111-2821414717288960-2908475740132875-3516517094663016-2822137312898995-2996063018163648-2822619111841685-2866288647750000-3170559546000423-2823341913067520-2910462347280659-3518918950413384-2824064837676875-2998109276272704-2824546855968045-2868246160844592-3172724797301567-2825269986240000-2912449858844827-3521321899593768-2825993239923555-3000156465875136-3261317858784375-3174620200663608-3479332640197040-2827198937006080-3610423534740147-3654234310692000-3393507023806458-3437306701267392-3394085972371926-2959199128865632-3220579602843750-2829128765565440-2916427596045611-3526131079239912-2829852677622035-3004253640408000-2830335354258165-2874124047205488-3179226465564551-2831059472117760-2918417822093875-3528537310203336-2831783713473195-3006303625762368-2832266609657485-2876085125694000-3181395660519583-3704680612820480-3530643660058617-2310371181313352-3705628128389375-3313549931924736-2921404858554991-3575755482956144-2267745531251148-3619979264000000-3096872691017671-3620596340979864-2312144096452631-3403068097233792-3141561329289000-3665467219832544-3185737010076239-3797023799545344-3055336944403030-3273854232075000-3405098509716618-3274412148609600-3493003872687760-2925639981483048-3711949027886875-2358380283715584-3057420069431910-3625535481559256-2839516641549835-3014512892712000-2184615704943050-2883938360229168-3190082307323391-2185173985971200-3059504141093750-3584295810900432-3191169248672059-3453751243615808-3235434905235186-2973355533356000-3935658620825190-2842662160465920-3848854943501656-2187035609645200-3237088308612750-3018623124473664-2231346188909703-2931625943785224-3763302926695034-3107177389504000-3763943725216806-3151476964259136-2889099806597862-3283347435508800-2407993078211875-2933623077484712-3240396805052502-2846536756244480-3635117845089667-2409018046875000-2847263634686315-3022737090687552-3242051898306498-3242327801962736-3856069290161000-3023766165947904-2936370617012731-3944714075416080-3068372011528530-3419334014928000-3025052838436089-2981465141121504-2280137908695244-3288940235980800-3157651240893000-3596519852489872-3377507162195551-3333927018431232-3729051351459265-2193746209150000-3729685777638435-2369648975956992-3028142341507773-3203959309210152-2326360080359375-3336196282347776-3029172643126377-2897715896126832-3293139001697925-3205594538496000-3864606952187608-3645336962998744-3426029646794586-3470248151118016-3690197849026500-3339034309997856-2196919869245150-2856238645511680-3647507113933227-2373278664006000-2856967174566115-3033038355579072-3648747586796831-3341305890605984-2198414414868750-3209957869846528-3122279183158183-3914175578639688-3782558539887314-3474971183000000-3035359360937169-2903633961598128-3211868071708271-2860125565340160-2948379956840875-3564762245041896-2860854755163795-3037165405729728-2861340950560885-2905608439206000-3214052087321863-2862070346936320-2950384691422899-3567186016670664-2862799867256875-3039230333980224-2863286283000845-3612452614549424-2951888838572853-3745251705280000-2996455861918948-3613680156912336-3393622019731559-3482063762885696-3085634996718750-2997728566566368-2248487363049933-3659613723426816-3130778790056519-3704334516708000-2910795701199606-3484430099035072-3793499153309182-3705592853735136-3220610074087375-2867909980848640-3662411355473499-3662722291461176-3442368591731082-3486797507016000-2913267994350186-2251352732306088-3929164746376023-2869858289192960-2958412717137875-3576892089740616-2870589132249995-3047499406429248-2871076429880685-2915494254750000-3224987017444223-2871807479723520-2960421996442459-3093240677930480-3402853482018375-3182158972657152-3359230600966268-3359515635806112-3934503435821831-3315874099200000-3139293808312551-3979724135213520-3272495234708878-3405452843757888-2874976796388125-2919454850921136-3229367924637999-2875708508142080-2964443283943403-3584183187393000-2876440344037715-3053711044120512-2876928303607605-2921436493379184-3231559865234375-2877660346429440-2966455292551411-3586615753242312-2878392513421035-3055783464168000-3321785415850575-3942186270904152-3499540698624073-3499837420745216-2968468211338875-2437008865085080-3943857774798667-3501024476954688-3279718670096306-3014051027692000-3989523355332390-2393916927639552-2970482040511619-2394322790921136-3946533163683875-3192971600097792-3459345748230294-3725765019042528-2306621440562348-2395540656000000-3149959274620271-3727028204323872-2351776599978831-3106383253348480-2307794530866500-3639522825680112-3551054845131440-3063044317974528-3684843757603107-2353171879313000-2886210023549515-3552559444362240-3597271170389757-3020187192580192-3420207567574875-3598185472574976-3020954798256484-2354767159895496-2888166610228835-3466093494864000-3777473093494185-3022234430058464-4000354940877030-3689528674516992-3867664812984375-2267443796727576-3290295107561742-3068237677869888-2356961847705217-3291131056518000-4003065897119190-3958922576599552-3870285699913119-2313470074578208-3648473226905750-3515290093986624-3738093256670052-3026331680041696-3249131107594887-3071356509696000-3694843045503043-3828715663096368-3472850010497946-3428616484245568-2939062879244250-3740942091309024-3607642335029463-3073436904642048-3697345690779467-2405705595750000-3787079276302335-3430938608436416-3832281681802222-3030432631453152-2273016797890125-2986372782620672-3164931470818503-2273593835887512-2942546851700214-3076559258184000-2987636374371127-4013582420801520-3523331506829913-3702041196119552-2988647504364875-3791888468849160-3613752321597603-3524822001835328-3302011280936466-3391541672548000-2276095462397661-3079683725709312-3883407896087079-2232032373821200-3482264978156250-3527207668083904-3527505952030307-3304525502616048-3349464465542925-3528400904768000-2992694305705947-3528997624013272-3842018440028482-3484916000272512-3708621579857375-3753621091185504-4022076892167270-3888336356081664-3888665068259703-3665488408218000-3129339981303970-3442564957792576-2995731802866519-2280525911022984-3309278069515750-3980414079650304-3130927359593110-3802161683709320-3623542642876419-3086982375000000-2997757942385567-3311236332524592-3580017456682160-3893597974253568-3893926982898375-3670448193405712-3133574182819010-3491991969687936-3447514099046633-2283611350701000-3985462376266959-2328781485561856-3896559719310639-3941680721153472-2956510274247750-3091158204498624-3001812961738671-3674170966970224-2285348132871309-2419984760832000-3182100558529031-2241105152832400-3675722865254694-3541544274268096-3855677588218750-3766328706972384-3990851928828287-3094292546738688-3722434326293787-2422029242358000-3812775353234735-3454217542835136-3633964216919397-3409933317651104-2423051914790250-3275883765157888-3231281419139016-3635498484610632-3635805389961339-3546331761656000-3860889576706206-3053054101925984-2334885500896364-2335082581997568-3907102531815375-3817606270863560-3683178060210486-3234282947034624-3234555905338728-2965259805750000-3280033838408023-2426531154296832-3190708338073767-3820184427974440-3505876809152250-3461221699290432-3146830676758510-3057179153355616-3282248643277167-2922796735040000-3012983116653227-3642868981070568-2923536537905555-3103708284543936-2924029809163125-2969265334298736-3284464444936199-2924769820078080-3015017026375603-3645328025133000-2925509955836715-3105803261378112-2926003449038605-3691577196136368-3016543059203125-3917333999718912-3782572470182772-3827925863246920-3287790016896347-3107899180728000-3288344497039693-3063373694701024-2252670575014350-3018833073799168-3199331626690375-3695314240424592-2929459455455195-3155068449223040-3425791659151644-3065440399772000-3741955892195893-3561920889380352-3922952380538559-2931188478697960-3337326611970750-3472916322932672-3834061911299705-3383280920039400-2436167557447146-3383851200000000-3880476364064886-3835677749912680-3159059624085890-3384991952164800-2933906889558125-2979294933451056-3295558412928639-2934648565921280-3025200305892443-3657639845961000-2935390367268515-3116292287524032-2935884970940805-2981303559665904-3297780200036375-2936626980618240-3027239709417571-3660105531971592-2937369115307835-3118392922632000-3389843009104575-4022952498104472-3571236107599993-3571536868599296-3029280029296875-2486931826190680-3301114752692459-3120494501527488-3256442363749608-2985323520102000-3302226769555143-2940586477137920-3031321265736179-3665040227828424-2941329278736875-3122597024422464-2941824549290445-2987334854728752-3304451552414687-2942567559360000-3033363418941307-3667509238172328-2943310694525955-3124700491528896-2943806187473125-2989347092564976-3306677334306679-2944549531156480-3035406489118083-3669979357125000-2945292999964315-3126804903058752-3398986979255775-3671214832407384-3444886476364500-2946532392727040-3762811784286619-3853806169376520-3854130409175215-3491682463192000-3491976219253137-3446915836052128-2267898558962350-3492857586290688-3220957792028375-3765661759428568-2949260280587595-3176393611834240-3176660782631630-3449236079988000-2314813623252261-3041285425558016-3223125753001407-3995196054258112-3359879214718750-3587199720266304-3360444327696242-3088235537031136-4087714261665510-2952486318080000-3043587943658147-3679870924000008-2953231122204155-3135231997651776-2953727727868125-2999421836984496-3317821237102319-2954472740743680-3045635601780523-3682346589729000-2955217878884115-3137341134478272-2955714707241205-3001439498335344-3320053017898375-2956460054179840-3047684178109491-3684823365559752-2957205526411435-3139451217000000-2957702577511565-3731569110209456-3049221213053109-2366758606870528-3049733672850875-3687301251741096-2367355251988636-3141562245428928-3050758764690543-3369777842414000-3643309130434480-3415889254809600-3962764410452439-2277642128717200-3735646870371750-3553718683452288-3007245314489658-3827724613963488-2415314812797827-2962427341120000-3053835418394187-3737843817337936-3327872131898891-3601698320690496-3374026056031250-3100716743327968-4104234430702470-3146843956236288-3785651889215587-2463161049918000-3695051805354171-3512875038223936-3376293229159938-3102800208229472-3331226935397375-3148958297009664-3057940840057051-4108026561054480-3195399990189330-3560887451472000-3150280240807449-3835445690032992-3333464723170711-2283386655539200-3836411553964500-3791058145297688-3928414018884178-3563279181461376-3015335419453434-3838021687500000-2330423002157301-2970396206635520-3062049939486059-3747897972967248-4068181811454875-3565671982174848-3200230526016510-3109056202286816-4115272567543110-3338223349248000-3978764337199047-3887624606011880-3018879398036502-3568065853852032-3065134178582375-3385656053797104-3660475725013040-3431983837862400-3249217208974239-4073304031937000-3203990973330770-3662011073571840-3891213081967945-3113231533208032-3342425895984375-3342706191106048-4029901536534104-2289908786547600-3022933058253174-3618662667608000-3618966085478739-3481828905614368-2290868969684350-4078088648557056-3116104240590500-2520589729221080-3345790471753419-3162724601247168-3071308868562623-3392476241886000-3667849313493680-3438896963481600-3989454845536359-2292982317309200-3760806186959750-3577652054990208-3027497761633818-3853501897525728-2431579960932147-2982376280000000-3074399320835867-3763012986107856-2386500881784604-3580051285080192-3304939628529000-3856085972475744-3351403114314839-2295673911705600-3857055298330836-3811457271103000-3949551644038866-3582451587571584-3031559131444602-3858671202384096-2342960908387125-2986376784202240-3078523147795371-3768060339801424-4090066578985051-3584852962704000-3217445188486270-3125779951792864-4137408178809030-3356178792804352-4000164486234375-3908533965897960-3035115808182678-3587255410717056-3081618436861863-3403863565238000-3680160620895280-3450439458777600-3266689506172127-4095207149159656-3221219106551250-3681701468564480-3912135295306505-3129970238832096-3360396392514487-3360677691392000-4051567020892248-2302219408384400-3039183986659062-3638115622835136-3638420127113875-3500545231355936-2303183029521150-4100008899097088-3132853232423332-2534137464375000-3363773015203723-3179722748924352-3917377540615545-2304532550793200-3918033150366875-2489311683108864-3181053288177717-3365743755955976-3412135289513646-3181851789864000-2444235555066193-3044019668179248-4151283163258230-2490978260837376-3275449094613375-3921640311561160-3783545932867766-3645428415870528-3230396619793630-3507581108228000-2353968397146861-3000406719365120-3092985580202339-3785761617825168-3924593271484375-3601692642707328-3832890869904039-3879394651116768-4156841831079510-4018616432064000-4018952446147167-3788294888215376-3234180656727090-3557896163907008-3096090554201375-3881990287262304-3373916453464519-2311094867353600-3143351768425092-3837058913927000-3236344289707970-3606513647278464-3005679252352205-3792096912352688-3376173316593375-2312640750156800-3284224328228383-4163449191371280-4163797140992910-3562657483000000-3516683060865276-2360076626831208-4118909254080103-3101011011698688-3286420582826375-3795901479508112-3425855847285582-3194645995998528-2454063536504737-3426714601254000-4167974048672790-2315734583526400-4029714789034239-3752116840687464-4169366971728750-3613753217513088-3011712563613845-3429005313406768-2363430782884509-3197849897472000-4078757895076568-4079098548575424-4172153748792030-3569807423414848-2410980368062500-4173199110249840-3431583584580742-3014480527418880-3849581173817387-4081824459416000-3061623962726406-3618584976050304-3154927218764116-3526389524198304-4176336242283750-3016494656880640-3109569454930851-3759644072007432-3017250186666235-3203194492296000-3017753943270365-3064436701714608-3389735633596911-3018509683304960-3111646597752875-3762155384413416-3019265549502995-3205333996506048-3019769530397685-3066483411750000-3391999544895623-3949918101319680-3764353699922337-2463301162825192-2417025447661500-3207474453194304-3021786014812045-3812417343908784-3719741878326320-3208545038784000-3859876173320523-2464945830547784-3023298967087555-3721293753707520-3768124232827125-3163627430991328-3582641645356851-3769067259297792-3164419151558212-2466591230169000-3025317022234715-3630683210703744-3956843730546945-3165738979348832-4190298073593750-3864708266116608-4051297081425471-2375096329328952-3446505571786686-3213901540248000-2468854850000473-3447367772976432-4193094168637830-4146849948307456-4054000273806375-2423282636593312-3821648888483846-3682139404471488-3915512585600196-3169964894332000-3403334222550783-3217118300892672-3870189511207531-3870512098686072-4197290642988750-3684595528506944-3078526240150218-2379059446031592-3965429529179915-3219264000000000-3872770712964083-2519843927328432-3966751522622295-3593709637060928-4014088072210750-3174194568398688-2380844285909493-3128036431138304-3315061053159759-2381439430851000-3082119550575846-3222484337207232-3129339671031199-4203940785366960-3690433199966625-3877613559123968-3130382523533171-3971711614815720-3785122790583579-3691970453432000-3458589477157314-3552360709481248-2384019538352517-3225706821305856-4067534273859375-2337858051278800-3647362270631274-3694430946822208-3694738585338731-3461182554798000-3508247386334325-3695661603356672-3134556250411779-3696277034097016-4024130261487250-3650096425143168-3884400323920199-3931527600577248-4212701669458710-3417253579072000-4119771886289048-3979656359817480-3839517469263574-3605700650335168-3278182515378750-2388588907892136-3466084126010902-4169015691890688-3279273999795430-3982306960625000-3795220092292731-3233234303909952-3139778623898759-3468103764324336-3749613349310000-4078043817134592-4078383135715791-3844313135583184-3282003770736530-3657394183248000-3610804897313537-2391771040906728-4174222188282183-2439074280767488-4081098361992375-4128350928723648-3096520753442358-3237540975743808-3143960696606103-3848152542526000-2393562232081461-2534570797243392-3332768394392207-2347215190661200-3849753049593750-3709216867511104-4038217443813838-3944633409910368-4179780560372471-3240773488128000-3898645880913603-2536679308141872-3993253129621895-3617718307334208-3805968134044125-3571328722708256-2537734001967162-3430925615443456-3384207948453768-3807550437849000-3807866951227251-3714154260364352-4043592625086702-3197525044063712-2445369448983500-2445572699062272-4091971318366551-3998235284721320-3857441661220518-3387303432000000-2540688699868254-3858403456843056-3435205593125071-4094352348999168-3200449366318500-2447605819308832-3106834745324838-3719096032765248-4190215803429581-3860969026742000-3672934202779218-4002889033338880-3202577265652996-2355031852477200-3108900288177750-3674460099093888-3392091072980136-3580837997062432-2356010153657950-3251564068032000-4147266727961368-4100479240042776-2451064709229084-3629762637626048-3724351466796875-3583217950236576-2357575999019150-3442346796548096-3348313947602919-3914551193951000-3301702854526370-3632174707081536-3821176357935597-2406125616359304-3727445210069625-3822128214759936-3397729364881416-4200319700826408-4059072836411234-3351373207624000-2360317897561050-4248924891775920-4249277587458630-2455341952647168-4108316936130375-4014206025411560-3872849581778886-3637002051281984-3259402198100481-3590364136500000-4204854301634639-3071215858347520-3402244494257544-3875099992381648-4017205266029375-3403091526077952-3308835737332510-3214564275829216-2411123244751629-3924310458368000-3404503558172232-2364434730176400-3688824187054266-3736426753136576-3074530211488125-3878959867028272-3453506824870799-4210789087093248-3359447460451439-4116847491831000-3312680771974770-3644251084354496-4023208228325945-2414125140877224-4213234444484375-3172023803604992-3361677120483543-3882822303963664-4025210543883815-3409872842304000-3978514857890244-2415727170448968-2463298600905324-3174128663392768-3363907766845375-4122313239848472-3696173456913834-3649089120343744-3080655280252485-3886687304038000-2512335410541163-3934738204360704-3366139399755047-3935390551118872-3888298477419750-3414398720942592-3414681721250856-3130384342429872-3462681765567727-2561648112000000-3368372019430671-4032892241324680-3701078389119306-3653931436360128-3322031112058750-3227383348427488-3464978037007239-3085510058209280-3180712351381043-3845657416941000-3086277068025515-3276473244128832-3086788478513805-3134537192710704-3467275323401375-3087555700170240-3182821052630971-3848206883130792-3088323048944835-3278645251512000-3088834685420965-3897006508269936-3184403190044989-4135313775525888-3232466964562500-3898297691596432-4231429601788387-3423462488953344-3709058155685142-3994701090828000-2473114972348332-2568447439875072-3377312370154927-3996024350715936-2521509835727375-3330571741857920-2474343849330756-3902172952728304-3807313177593520-3664842306048000-4188737937605848-4046274982181480-3903788402554374-3666055963938368-3809204592490000-3142853908585776-3809835203297840-2476597847619584-4000989177884916-3858416015625000-4096928881227586-3668484083495616-3954667232800991-3621440744744864-4241248656042375-3479064854560768-3431690371194696-2478648124446624-4099641854490194-3670913274952000-4052642142044385-2431786464373128-3624138465701972-4244408003529216-3243186757854500-3911225214465872-3100617926000595-3291697456617408-3101130919452085-3149101090278000-3483384765727303-3101900515717120-3197608063053939-3866084703084744-3102670239296875-3293876186247744-3103183459085645-3151185322358832-3485690179831647-3103953394880000-3199724224394747-3868643188439208-3104723458017155-3296055877046976-3105236904193125-3153270473869296-3487996610908919-3106007179591680-3201841319173123-3345483903230000-4253895458925219-3346037058636160-3107291254974205-3537824005013616-3585928827928125-3586225234675200-3395240502675183-3969412027534136-2534894284061647-3730907466000000-3252854812165268-3253123643141344-3540456532069398-3875684842819584-3971708951027875-4307028240655440-3541626963156782-3781238503878848-3159270407807514-3255274824188000-2393782197411550-3399451566156288-3399732427457087-4166213485461528-3352402728911250-3687947648192192-3544554169358962-2443070215021032-4263749223828551-3593343897600000-3401979874795431-4264805885984072-3738003767960826-3786239590197696-3690690220765625-3643060034502176-2444886924186933-3499833040247296-3452175190028808-4075821156645000-3165016592277606-3309154218259392-3117576600972405-3165800702308464-3501856566362375-3118348915568640-3214563501558451-3886584198284232-3119121357704235-3311340643176000-3119636389988365-3167892295503408-3504170122529311-3120409044712960-3216687136162875-3889151718728616-3121181827004995-3313528030957248-3121697086075685-3169984809750000-3506484697463223-3122470081003520-3218811705851459-3363215134290480-4276440694059875-3363770242421120-3123758689434045-4325561243524080-3556866048804646-2499625619712000-3269010900543908-3942367807574096-3702284962079319-3462162465351168-4279970566514125-3270359650760928-2501069575828876-3896218229870592-4040855921038356-2405469792650000-3704729050546447-3416330639510208-2406065091355850-3176267880827184-2550849732421875-3898789990995456-4187934617773071-4043856556500768-3370158376755730-3755629025616000-3370714248603870-3274678144377824-2408050129694350-4190352726786048-3275488284930500-2504991688183712-3179674674831798-3806288031882688-4288450184336341-3565971652806000-3807229535033209-3711149900018176-3277649312951076-2554849028502152-3133563701441875-3760586405716608-4098412729135705-3279000438021856-4340211230627910-4002969152000000-4196229152060487-2460061204037208-3569794752089198-3328866723441216-2557166319896625-3570677393644784-4343073616002870-4295171152608768-4198996428635823-2509951793492000-3958327033351542-3813824404635712-4055539815347748-3283326533364192-3525037999456375-3332159732711424-4008580327468179-4008910559810456-3960936704140838-3719722567176000-3864965171716880-2464118255395848-4300482137688063-3624300302476800-3431286882859375-4204880930359512-3383516177053810-3770514249430656-3432417424092819-4061222651388000-3529686528322343-2417792600678400-3288468711642116-4014196744143832-3385745902901250-3772998937488768-3144424666854445-3967139268733104-3532012324493887-3629078548800000-3435810537702591-4016841578019704-2565182289006271-3775484716877952-3291719167836500-3679283092984736-4357404421796070-4309343505317888-4212851062135863-4116342695625000-4358839233766590-3729536054660416-3245447808622359-3584819451745136-3875799431710000-3633860993011200-4215625640831391-4215972548800344-3392440957540530-3731992120472000-3829242040974299-3296327646292704-3538995842653831-3248386718978048-4218401437482375-4024783049543768-3588656008007662-3831447946523328-3201219842680794-3298497829564000-2571099499700883-3929739447909888-4269697744911896-4027432530867192-3979236523093750-3833970018595904-2523833398493316-3980218457962864-3883459322419120-3349759131648000-3252932160266947-4224304050578616-3981855375028134-3787929992176512-3205435093352250-3302841053229408-2574484844925059-3449121763405312-4226736137840703-3935560644369000-3595746070789054-3353065902516672-2575755115103321-4374283359760560-2527571487343500-3451390922387456-4278131944721624-3938149686977352-3987096525478918-3792915750000000-3306916286446068-3307188087784544-3550655485193471-3745519758908928-4280945810911000-4135344302588360-3989718824499126-3746751162655424-2530481440251908-3990702482982000-3893688200066480-3747982836269056-4283760910677336-4138063582003240-3992342273051750-3749214779779392-3895608112033040-3214140730932912-3896248222908720-3847861200832000-3263644038266987-3945923627200488-2533393625758684-3800402586694272-3557079190828125-2485286841518376-4337425421471287-3655433990246400-3460761723336119-3948517212237000-3168823418103915-3364104188092992-3169343907043405-3218367314006064-3560001616417375-3170124747312640-3267935365312251-3951111933502632-3170905715823235-3366314748216000-3171426432747365-3220481994317808-3562340709035511-3172207615016960-3270082438767875-3416784510953520-4149293210342455-3905537711887360-3173509870514685-3222597600750000-3564680826027023-3174291394859520-3272230452453259-3956304785716584-3175073047501875-3370738773165504-3175594220545045-3224714133505392-3567021967616167-3176376087040000-3274379406574227-3958902917162568-3177158081860555-3372952238415936-3666553249659375-4351333511485144-3862736528604777-3374059334327808-3276529301336603-2689908891615000-3961827174390291-3864321262678592-3326524073187156-3718184824069024-4403474784843750-4354904471076864-4257390625586871-4061981668321816-3817597066338042-3866857738648000-3916126456875280-3231069291738288-3916768813382960-3378490140504576-3280831913608875-3966704135842536-2546734929128156-3820415636658816-3575810377726237-2498373729129000-4360264572803319-3674681519001600-3478983714009847-3969306817679304-3185507347416875-3381815789534784-3186029661631245-3235310699226672-3578743052375327-3186813240000000-3285138290916667-3971910637735848-3187596946834755-3384034100903616-3188119489433125-3237432794179056-3581090346259639-3188903410401280-3287292891973443-3974515596261000-3189687459863515-3386253382132032-3190210230895805-3239555816873904-3583438666311375-4172838954396160-3976795869066153-2651414462335728-3240883177267494-3388473633432000-3192301886218965-3241679767513968-3585788012754791-3193086492610560-3291604919921875-3979728929712456-3193871227552395-3390694855015488-3194394455602285-3243804646302000-3588138385814143-3195179404817920-3293762347225179-3982337305136424-3195964482611875-3392917047094464-3196487939245445-3245930453440752-3590489785713687-3197273231360000-3295920717022307-3443781202490160-3788469480157439-3542755001614848-3297000255420375-4035464992559152-3937361328961840-2559494377949184-4282581530868063-4332161207000000-3446319408171570-3840498823185024-4185501542451545-3348675303689952-2560961296991500-2659677475774464-4285386638629191-4334998712203456-3990495823673499-3547397685312000-3301320766276327-3252313446988848-3597550148696031-3203560198991360-3302401483434875-3992782203959976-3204346648942595-3401815524604608-3204871020410085-3254442969558000-3599905658198903-3205657684869120-3304563625265539-3995396279191944-3206444478046875-3404042572340544-3206969078347645-3256573421491632-3602262195663247-3207756086080000-3306726710619147-3998011495132008-3208543222559155-3406270591843776-3209068051743125-3258704802992496-3604619761313319-3209855402823680-3308890739701523-4000627852029000-3210642882679115-3408499583326272-3211167940796205-3260837114263344-3606978355373375-3211955635299840-3311055712718491-3459594747027440-4398987197168811-3460160410000000-3213268745706565-3658481913750192-4449868740083430-2472351372083200-4302243011928375-4005863989689096-4451323777671870-3858129241739136-3413239418469201-3265104526926000-3611698629620463-3216158848248320-3315388491379499-4008483770949864-3216947358681875-3415192391769024-3217473103897845-3267239628723312-3614060310256007-3218261829120000-3317556297435187-4011104694162888-3219050683229355-3417425273288256-3219576657578125-3269375661101616-3616423020198559-3220365726522880-3319725048248763-4013726759577000-3221154924382915-3419659127846592-3221681127914405-3271512624263664-3618786759672375-3222470540656640-3321894744026051-4016349967441032-3223260082342235-3421893955656000-3223786515106365-3273650518412208-3621151528901711-3224576271720960-3324065384972875-3473187682225520-4416270584620347-3473754825869440-3225892819353685-4069920093750000-3623517328110823-2581346335932416-3375882299224836-4071249191903248-3227473149476875-3426366531875904-3228000040856045-3277929100479792-3625884157523967-3228790485440000-3328409503198427-4024226448220968-3229581059051555-3428604280710336-3230108179813125-3280069788804336-3628252017365399-3230898968494080-3330582980888803-4026854228373000-3231689886230715-3430843003643712-3232217236424605-3282211408926384-3630620907859375-3233008369277440-3332757404572011-4029483152219112-3233799631214035-3433082700888000-3234327210890165-3284353961048688-3632990829230151-3235118687989760-3334932774453875-4032113220008136-3235910294201195-3435323372655168-3236438103409485-4083224098798000-3336564922931957-2589783939864576-3337109090740219-4034744431988904-3437284760031375-3487384802043520-3338197603849391-4085888374130544-3637733765499127-3239342080000000-3339286353636867-2641740367725224-3240134374985755-3439807640606016-3340375340128375-3290787211444656-4487802880494870-3740140561958400-3540954985042159-2493833512050000-3890697351819018-3841129641528256-3492220621385790-3392719357037792-2544746879812125-3742579783987200-4341746323094631-4491827706188880-3294275393723094-3444295809192000-3344733653649287-3295080708760368-3644855907084991-2696414447748096-3395761493062500-4045280726806056-4045610281243923-3946040104108608-4196131275066276-3397144883116000-2498104122209550-3547596800688128-3547885763529127-4147866247761432-3248593561386875-3448787880108864-2649284702897409-3699302537602928-3999571684617520-3249916637760000-4150231501219643-4150569467954104-4300940252543202-3901170428967552-3301259151374250-4201944669193824-2551388414688573-3652284683350016-3352369821359283-4253352750625000-3252828670198315-3453283855052352-3253358317461005-3303678903615024-3654366548025375-3254152896151040-3354553716291131-4055835348597672-3254947604205635-3455533307064000-3255477481449765-3305830786891248-3656746790498231-3256272405135360-3356738559479875-4058476869501576-3257067458213595-3457783735718208-3257597565489085-3307983604398000-3659128066314703-3258392834245120-3358924351131339-4061119537085544-3259188232421875-3460035141226944-3259718569778645-3310137356338032-3661510375699047-3260514183680000-3361111091451347-4063763351598408-3261309927030155-3462287523802176-3261840494518125-4115271932105392-3362751769378901-2610109162911744-3363298780645723-4066408313289000-2610746033790492-3464540883655872-3364392981135119-4519701360448560-3716501083685750-3264759644323840-3365487418920291-4069054422406152-3265556078245435-3466795221000000-3266087106145565-3316604220785328-3668663507501871-3266883755932160-3367677006480875-4071701679198696-3267680535251795-3469050536046528-3268211793432885-3318761712486000-3671049953400263-3269008788664320-3369867543533299-4074350083915464-3269805913456875-3471306829007424-3270337401968845-3320920139633712-3673437433987807-3271134742720000-3372059030283387-4076999636805288-3271932213060355-3473564100094656-3272463931953125-3323079502431216-3675825949488759-3273261618298880-3374251466936963-4079650338117000-3677020595401843-3324699638671488-3979887989280723-3325239801081264-3678215500127375-3476951841176064-4434733539187864-4082302188099432-4536259722361710-3982151371336000-3478364049807849-3327401035786608-3680606086127911-3277518134824960-3378639190777875-4084955187001416-3278316642257995-3480341784234048-3278849052592685-3329563206750000-3682997707714623-3279647776171520-3380834478376859-4087609335071784-3280446629451875-3482602969946304-3280979270367045-3331726314174192-3685390365111767-3281778339840000-3383030716702627-4090264632559368-3282577539042555-3484865134844736-3283110410588125-3333890358261936-3687784058543599-3283909826030080-3385227905961003-4092921079713000-3284709371229715-3487128279141312-3285242473455605-3336055339215984-3690178788234375-3286042234941440-3387426046357811-3539388979934640-4500445372814771-3539963307440000-3287375459169165-4552119896235120-3743157767482438-3490524832421376-4199087857644875-2732158282675824-4300968359328255-3896487362634944-4352273932951534-3441611994732000-2581418345503821-3391550123933696-3594322207144647-2582046461784984-3341742873141750-3493923590539584-4000613719918867-2582884108643592-2583093548660949-4204199000000000-3596654604881071-2533060722200400-3343911251935782-4002884952309056-4053883022010000-3446079927742688-4054540355147440-4004183185256448-3396228123445843-4106220569181000-2636305902481212-3954779398886784-3701567912567381-2586236507695944-4513602068075375-3803905531507200-3601322426957823-4108883919556392-3297519750060835-3500727724152000-3298054237416965-3349064910486768-3704568940375191-3298856076738560-3400634874171875-4111548421339656-3299658046014395-3502997730170688-3300192764400285-3351236455182000-3706970930157743-3300994950289920-3402839678300779-4114214074779624-3301797266161875-3505268717283264-3302332215627445-3353408938365552-3709373957993287-3303134748160000-3405045435214707-4116880880125128-3303937410702955-3507540685701696-3304472591298125-4169056871813552-3406700378289141-4423984091349504-3661524693262728-4119548837625000-3509529463211919-3560680499922560-3560968806351390-3866507739343264-2594840268010125-3409183798198272-3613009647517703-4478459004721856-4173447366903078-3512087567304000-3308756116768765-4174460995630896-4072974544723760-2545815145907200-3462588848974500-4124888210083176-3717792733322699-4023690376696128-3361836178767594-4279046876412000-2700093316172283-3719297425199104-3413877994837139-4127559625539144-3924047034359375-4026296112423104-3364013239985178-3466233482301536-3721404675814847-3619741234752000-3671020497775752-2549526045768400-3977582407561386-3926905429270208-3570202831238750-3468477604259808-2601568640692653-3826145719910400-4438688055429303-4592117684610000-4184267869454822-3521193115505472-3725621564565061-3368642615354544-3726224237163375-4134911964719616-4441560915115551-4186637344785744-3574247731690930-3931990447000000-3574825823891070-4290137872037472-2656014383969804-2758391803846656-3627067655216375-4291525592509344-3372185590226838-3525751785496128-3321628900591885-3373003552446000-3731047957900063-3322434556280320-3424940156727099-4140934005041064-3323240342231875-3528032595205824-3323777605239845-3375185431664112-3733461378599607-3324583608320000-3427155452811587-4143612343127688-3325389741691355-3530314388341056-3325927236328125-3377368251600816-3735875839818959-3326733586874880-3429371703945163-3583215166790000-3941855157170007-3686188346205696-2713663432076761-4250042682334632-3738291341782375-4148302213287936-4302290574149652-4456303778550264-4559115808179091-3944722192488000-4354915210508785-3894121065113888-2715856409449971-3536023175056896-3433807072182875-4151654286239016-4562062639021547-3690955482177024-2717172762804297-3383922357750000-3743125468838423-3538308411850752-3436026189698659-4308201586774176-4205964950907750-4052415370300864-4411846346164798-4309593199658208-3745544094379567-3335342770240000-3438246263086827-4464948866190936-3746753797751531-3541738112819136-4363362924705625-3490972119740128-2618440436159613-3850958520422400-4518822712607192-4159706627853000-4622269297608990-3954927354258496-3595678680770190-3493226905473632-4212760638218750-3545170029356544-3442689278303611-4162393053663912-4573862660484171-3700502080704000-2724200498239273-3392674348309488-3752806221746551-3547459204939776-3444912220543875-4473605127404472-3599742796874210-3960036528807744-4011789193016982-4320736892556000-2674957654661292-2778064721021952-3652935290792047-4527946974969792-3807898896050750-3550894815681984-2624786116663023-3448526542228264-3757652851186727-2573942400000000-3500843974948868-4170459270399048-3964830374460879-4068141013387456-4377466713160625-2626691818028616-4584204355678127-3863405047718400-3657651671143359-4482272569407000-4431109427344066-3967708538033856-4328758276298148-3504515398631392-3814044797589750-3350444558090240-3453813558519971-4175842533462792-3351254866339835-3557772690312000-3351795144415965-3403635540693168-3764930616625391-3352605670402560-3456041286296875-4178535901313256-3353416327045395-3560067287268288-3353956837399285-3405830608422000-3767358625009543-3354767711825920-3458269971798579-4181230427041224-3355578716936875-3562362870617664-3356119459618445-4234214891152304-3459942114555573-4493122605888000-4338536831035764-4338886337224992-4597523711123723-3719644633640448-3461614796235375-4236944441360752-2687059235547596-3772521608380416-4548063568333912-4651803281250000-2739615893985303-4032212257866624-4394431336428545-4343081875697376-3774648913015375-2585584163660800-4344131182741812-4292760977533496-4448279167388194-4034810611728000-3414345409898346-4345880403373152-2638782684472797-3363425172623360-3467194295169875-2587666736854800-4037085086826714-3985648413888064-3623608417527630-3520360107644000-2640482611529061-3883375226073600-4505077853691279-4660800480614160-4246848894093750-3729240616361472-3366946516240645-4662301140805680-4662676356177510-2694207586304000-4507979285736567-4404702005130280-4249583870623334-3990784006617408-4146602729930000-2643671942232456-4199110923511143-4095758687077888-3473897603894123-4200124548609000-2696593184124892-4045215189684864-3786211093671261-2645373968217384-4616808289816375-3890881748275200-3683664344192183-4202828346314952-3372911310723435-3580763073000000-3373453913823565-3425628702382128-3789257692050271-3374267927580160-3478371272890875-4205533304137896-3375082072273795-3583067543425728-3375624908150885-3427833214806000-3791696147119863-3376439271096320-3480609546960899-4208239422326664-3377253765006875-3585373002364224-3377796833710845-3430038672814512-3794135648091407-4418184329280000-4210608227800041-2755310804443144-3431417564339622-3587679450027456-3847965494031250-4264304489122032-2756418333493499-2704627801800704-4525414042519143-4577798177656000-4057919933783898-4006217250294336-3850440268772738-3538526742347872-3851059128207750-4215687232513536-3487330129927451-4216364741576232-4633168068840491-4008793319608000-3852916104368754-3540801956386784-3801460428660311-3385133960232960-3489572245187875-4219075503716616-3385949851759995-3594604727485248-3386493852270685-3438869964750000-3803904115482223-3387309962283520-3491815321260459-4221787427466984-3388126203401875-3596915132167104-3388670436989045-4275281403110384-3493498258971693-4536697846272000-4380611732858004-4380963495041952-3390303487424555-3599226526633536-2817012146514750-4278028571799472-3808794630419999-4539612837302784-3548488003779812-2713767500756000-3444673730243526-4123501072124992-4645836153056413-4280776917069168-4020076607421875-3915973342003200-3550767485311044-2767732087110056-3394660853411035-4073919975216000-4439884490073985-3552192656873824-4701808769479830-4336460515845632-4545811338621375-2664999801491256-3867172757650622-3606166650859968-2770176360228057-3868103759006000-4704827991072390-4652925423685632-4548730231758759-2718999418667168-4287996923199750-4131450413335744-4393287038260932-3556755768437856-3818588231750527-3609640056000000-4342379092552683-4395049428739872-3401203900238755-3610798353153216-3401749533333125-3454361177481456-3821039252444439-3402568092385280-3507543773798243-4240803439701000-3403386782739515-3613115690778432-3403932649259805-3456577998320304-3823491321731375-3404751558474240-3509794543777771-4243524665289192-3405570599018835-3615434019672000-3406116699014965-3458795767379568-3825944439835591-3406935958466560-3512046276421875-3669596220134320-4666003478239987-3670184547872640-3408301682798285-3880531392118000-4719943488059190-4667873769815552-4563343441171119-4458796317312840-4721456815908750-4039792336414912-3620363760859257-3463234150970352-3830853823392887-3411307560960000-3516552630527107-4251695326145928-3412127652524955-3622394956082496-3412674453248125-3465454765907376-3833310089294479-3413494763860480-3518807252399883-4254421208625000-3414315205915315-3624717252169152-3414862240314005-3467676329875824-3835767404910375-3415682901463040-3521062837760531-4257148255948872-3416503694082635-3627040540584000-3942751110238575-4258512216505368-3995961076100372-3417871973967360-4364709091128875-4417649670898464-3839455347039099-3629364821539008-2787996197133577-3892985615502000-4735091325429990-3946225363353600-3788679653482824-4578354427320888-3684028358281250-4052755613535552-4579454082778971-3579629951875936-3843145652286447-3632853104448000-4370303526518203-4370653337365944-4528991233152482-4108018496080512-3476293857902250-4424728101969504-2686657063275453-3951282464870400-3740846747642999-4584221291163000-3688749075323970-4110649311560064-3742044297613147-4427561590181856-3848069736553375-2635875089996800-4428624460047732-4376252849849336-4534793447174914-4113281250000000-3480747194925066-4430396287800672-2690098645388877-3428831367004160-3534616594695875-4326294707117712-4273876852790283-4168682443840448-4696739404827381-4011019605076000-4750271537744790-3853306182726144-3800825119058184-4329063683325008-4487802933099375-3801737073894912-3696428838718910-3591103728996576-2746357737206668-4383959985664000-3803257322766792-2641362098032400-3486876741128022-3645662597153856-4491392696640625-4016154531135776-2800963253955699-3435418234426880-3805690563856008-4651771412376000-3700568507460370-4123820238155904-2749433247518724-3489944210894064-3860398344692375-3966479688499200-3755234219733863-4601851950423864-3702935419527330-4126457794992000-3756434838130891-4391676164999304-4233279147360560-3651495034077696-3545937925792875-4604794781318232-4340498199038486-4129096476226176-3494130022689834-3600300383500000-2806340671743003-3759737858183168-4607370787289799-4289963772304584-3919539257936750-3654997480317504-2807686100727729-4768149703060080-2755150999529708-3762141270336000-4663308107874328-4292705985254568-4346049447028854-4134377212847232-3604616714924500-3604904592949728-3870280169118199-4082676329611264-4666288412808792-4507570322905000-4348826845073702-4083980560140096-2758233069878884-4774246105970160-3925804671843750-3448617265533440-4403970556179739-4669642773360576-3502511684465574-4139662449936000-3609224602787988-4034161282103968-4777677615085830-3450820385525760-3557283405833875-4300939635070536-3451646797365195-3664348284821568-3452197811885485-3505588315614000-3877702593973183-3453024443614720-3559555401979419-4303686522827304-3453851207291875-3666688475246784-3454402456386245-3507826996818672-3880178842794327-4518376960000000-4306091008816881-2817790527594024-2764845244471804-3669029661815616-2871643601886750-4360991874763312-3882656145590639-4202113763317248-3564102296054443-4309183806561000-3458262842458515-3671371844740032-3458814560850805-3512307218081904-3885134502586375-3459642248458240-3566377194395571-4311934203035592-3460470068097835-3673715024232000-3461022021213965-3514548758545968-3887613914005791-3461850060930560-3568653060546875-4314685769580456-3462678232707395-3676059200503488-3463230420597285-3516791252502000-3890094380073143-4529923062497280-3464334972483905-4690550476137152-3464887336486875-3678404373766464-3945269879705122-3945584360777328-4799066179330710-4746121489216000-4639836860417727-4533535249129480-4800596371803630-4107504230520768-3681043885667625-3521279101700976-4001772407926725-4002091308134400-4642795861329063-4643165824875000-3736178236381570-4110123533809216-4217215986682083-4484485672990176-2776331364891500-4431805052502528-3791364189899903-4432511241227896-3524928289223814-3685445877624000-3472073412325765-3525770767300848-3900026795307031-3472903213711360-3580046915659875-4328461162067976-3473733147297595-3687795040972608-3474286509805085-3528018031758000-3902512537977903-3475116663749120-3582328592994539-4331219754259944-3475946949921875-3690145202372544-3476500547502645-3530266250923632-3904999336642247-3477331054080000-3584611239580147-3745414398499760-4762406010297843-3746010802065280-3478715525618125-4817066488637040-3961014413326022-3693672316282368-4443466761442827-2891160302886000-4551262723081535-4123236754397376-4605540064833902-3641879661894112-2731627140346125-3588893815078912-3803458810958983-2732279391331992-3536172370044534-3697201677000000-3590322097867767-4394475217777456-2786962132652204-4448774294042112-3805880817611375-4449482284220728-3967323936785982-3699555832724928-2841913900566937-3539268678726000-4826659433078790-4451606705434624-3808303852252887-4345030297377864-3916203004563875-3701910987561024-4453377572907479-4078115867577632-2683184368297950-3917760762304000-3810727915101631-4401472417065936-4562864757425695-3865322234838528-3758251031718750-4080711327081376-2738589837938733-3598041373507584-3813153006375719-4726537280696000-3545184831466806-3706624295414592-3599472082093079-4405674299758128-2740332359059125-4030220920819200-3815579126293263-4460820344795576-4407425873182358-4139009399448000-3978065497641554-3655810228329184-2688309430570350-3710161900548096-4463303110295875-2904066563594544-4571579210696455-4141642077880384-4357138578360669-4088504312500000-2905220772490554-3927740194819584-3874243388887944-4358870166902184-4359216539653875-4251919401600064-4629039546389998-3660461632398816-2799398952296908-2799621373952000-4684354062361047-4577031374451880-4415839888223654-3877630862381568-3877938912393000-3555059730492336-3932423881656399-2909147370236928-3825293896760239-4579940966805000-4203103184670858-4149546810920896-3772614902624190-3665116980216032-3934923369734375-3503977153597440-3612078675101011-4367188178231112-3504812030209035-3720788219688000-3505368688285165-3559580070800688-3937423916721151-3506203785909760-3614373940678875-4369963198436136-3507039016156195-3723152376063168-3507595910004485-4425318447398000-3616096027812957-4695900437446656-4534332760965588-4534692704823456-4804996278903875-3887496556872192-3617818661858391-3564104241297072-2862310876450147-4482842616000000-3835025142971471-4483554215969464-4645979081933922-4160102091873728-3620116358153375-3998654764993584-4323213055755440-4053333856358400-4702240368353223-2702651427050000-4432700030303942-4216805312563584-3568349131168602-4541895582768096-2865947191873875-3515119748042240-3623564726373371-4435162380809424-4381422582764979-4273578293672000-3678814887828948-4111942785554848-4815683374508263-3733803473043456-4491743028921875-2922570622582704-4384203628990923-4168030288541504-4005957179060386-3681441778716000-3952449448284943-3736173138811392-3628165956131979-2707801240485200-4224504894314250-4170675257445312-3575147963326698-4550549099415648-3954957413912487-2709089715200000-4551631561202964-4497802033990104-4660742661985202-4227520323591552-3577416158324250-4553436045625824-2764805321265573-3524050812372480-3632771079360283-4446430453250000-4826386304938539-4230201909508224-3796635937463390-3688452934006752-4882162842123750-3960290363015168-4720172146775991-4612027905780520-3581387807631414-4232884629168000-3636227477861527-4016450076706672-4342452247571760-4071371552140800-3854537118463375-4832126535432744-3800850073535410-4344172802882560-4616049279002265-3693131979404000-3964999885693703-3965313986555904-4780483193870296-2716398793181200-3585930433593750-4292590053632704-4292930060765507-4130234512971552-2717474765121950-4837488188608000-3696351117481188-2989932533113240-3968770190940251-3751600409194176-3643146850651375-4024092772621744-4350715057848240-4079118345830400-4732151956694103-2719842903450000-4460895541395622-4243626850030464-3591045477423162-4570783367890656-2884174971695875-3537475753443840-3646609826329291-4463368321572944-2830652753952348-4246315242000000-3919985880746472-4573678864843872-3975059343072871-2722858886963200-4574764991380500-4520661273293528-4684429389621298-4249004769150336-3595596264508314-4576575584364000-2778855068740581-3541958298744320-3651230539902299-4469023821651408-4850909670192875-4251695431721088-3815926014194910-3707192854954976-4906966988030310-3980410343424000-4744152019343607-4635457753623080-3599581355664822-4254387229951872-3654698635484375-4036852133549424-4364509689358640-4092051495206400-3874115164442319-4856669324873000-3820154409784370-4366236065725440-4639492732845145-3711887732162272-3985135800402375-3985450963775488-4804759187003864-2730192698883600-3604139349823254-4314386724536000-4314727881661059-4151205674867488-2731272310040350-4862049114226176-4589263113424500-4589625958389024-3551777065012995-3770646043962048-4372109150507920-3716586571500000-2733000279817550-3881167184723968-4756172351829399-4537856437513112-3608701190085750-3773031270698304-3554585755922045-3609556963446192-3992704308250767-3555428651840000-3665116097423627-4431311433451368-3556271680997555-3775417503116736-3556833774463125-3611839687149936-3995229272034599-3557677025710080-3667433774122003-4434113548413000-3996492153021603-3613552361367168-2792511073402167-4052198933435376-4107282842578125-3778998737862144-3669752427686811-4656023849054920-3615551165472774-4273261636176000-3616122387711306-4602701118134112-4000282392699351-4439020091572224-4548984788669875-4713778193348016-3617836415410998-4056682398656128-3947354049072168-4166980546324000-4441474719894951-3783777239388672-3893759392581647-4113450907783800-3839523999491250-4388373905914880-4717874432233678-4114750234199400-2743383405699950-3676424000000000-3841343247980070-4445333820936648-3567524806691755-3787363757860416-3568088085258125-3623267742878256-4007870059803039-3568933114273280-3679036814726843-4448141843481000-3569778276696515-3789756028823232-3570341792432805-3625556242885104-4010401412696375-3571187177226240-3681360355711171-3846500905928240-4231484885386143-3957025363776000-3957337604394792-4507323453305136-4397735705453360-3793346323769856-3683684874796875-4123853181118200-4289145675803274-4124503904846400-4399817911871120-3685138196009000-4675544134622235-3795741113044992-4566251655100771-2971048670458416-4456924535122875-4237163683880512-4402595209332240-3742501085619296-2752056072665950-4018318759872000-4844382725857048-4569494049117304-4735029870433602-4294900645556352-3579366111173125-4515864092349552-4020537482877079-2754009938329600-3911002470047079-4957999661250000-4958390578198590-4242513074538816-4683662891864545-4188075804191264-2755530250818750-4023391326611968-4795378627693791-4575262094362296-4079470892914046-3804130812504000-2922243850311993-3639307481985648-4963083184444230-4577426362109952-3915938396648375-4467831118591176-4026881191413699-3806530138079808-4303373184435702-4634767111212000-2869367645659372-4249206141892096-3918407916546207-2759659633461200-3863827917031250-4305747490432128-3809230585014777-4196004843841952-4969344597033510-3810131017728000-4583562160291603-2982311518717872-4694749063011895-4253225359206208-4308801452601750-4198650079284256-4917227529680767-2873213173868544-3923350070626799-4476287134449000-4697708326943535-4311177754625664-4587896611599631-2819291022863784-2819513055076125-4257247110172672-3925822705245783-2986072117048368-2875703286783548-3816137529000000-3595195236379565-4978354600548720-2821289732455077-4481224734057984-4813546266663375-4537262875791312-4758967415349698-4261271395589824-3597460342386885-3653093448246000-4040860831199063-3598310002360320-3709319198296099-4484753813069064-3599159796106875-3820947280597824-3599726399594845-3655394488616112-4043406054858607-3600576416320000-3711655470652587-4487578409939688-3601426566846355-3823353671173056-4156146240234375-4932348303929464-4378496375596257-3824557245247488-3713992723786163-3049039883835000-4934289103586099-4380219198241472-4103312942499138-3770908542527072-4991301009933750-2995016205210624-3716330957902651-2995487440779888-4049773789412187-3828169482936000-3606530280419365-3662303406913008-4051048138045111-3607381367848960-3718670173207875-4496059316027016-3608232589163995-3830578904547648-3608800144426685-3664608312750000-4053597637257423-3609651588907520-3721010369907659-4498888657377384-3610503167301875-3832989336928704-3611070960633045-3666914185460592-4056148205918567-3611922762240000-3723351548207827-4501719185469768-4057423891362531-3668644224626304-4391601163227875-3669221025247536-4058699844252799-4392636863932928-4837841083930383-5005056556170000-4782985500782146-4338397569826944-3838114862776473-3671528832313584-4061252552484375-3616467966525440-3728036850432611-4507383802875912-3617320616607035-3840226700808000-3617889124443165-3673837606861488-4063806330837551-3618741997877760-3730380974768875-4510217892687336-3619595005338195-3842641178386368-3620163751442485-3676147349094000-4066361179536583-3621016982302720-3732726081528819-4513053170236104-3621870347216875-3845056667793984-4179737690352975-4514471254489752-4236132869989524-3623292920000000-4627029704271883-4683144807466272-3624146642442755-3847473169242816-4349659038279750-3680769737423856-4071474088869239-2900455848935424-3793201619906372-4574514046202000-4295917532670687-4017277234377216-4129192431990178-4129516612281456-5022779362953750-4185978064627200-4018854410230536-4856496956372184-3907833024022130-4298953755096000-4857640708103907-4690503998632032-4244122430863092-4635392242184192-4635756059171875-4691976761402784-4524761250249723-4245788186154752-3855031261526241-4693449832428000-2905696948980332-3017691310851072-4862217510794319-2850489092842104-3912743003951250-4472057159060480-3913357040463710-2851383831760872-2795693672295950-4417542557696000-3746817364511907-4418235723010552-3691473847703862-3915506674154880-3859873631372625-3692342656921776-4196173057141725-4532222379428352-4868324385045663-4588895531250000-4141523214616574-4421702637261632-3694370408538282-4254457140040864-5038568048823750-3975182071566336-4031486680362696-4591775440499984-4760140471678215-4032435166272000-4256793103592156-2856756197437128-4985710531712783-4649959774730752-3977988302433375-4874818539443352-4370869618452714-4315171105232064-4427600552909611-2858548484433000-2858772573002061-3643819289477120-3756231227711939-4597538873255568-4541827305796875-4430030629997504-4430377856434707-4262469717432352-5048057123247510-4094856127296000-4039078733426952-4937038670235584-2973676766992911-4376697443843712-3815881390340500-3816180409360608-4097102932530919-4097423971782656-3985478040741399-4940134477432000-3929960319331970-4379441741460864-3986727243722747-4660905430643272-4099671716133375-2808214307916800-4718169626022132-4662366147926136-4831263834261314-4438369073000000-4326344159437377-4270492348770208-5001363013927303-4327360846921728-4046680312029000-4552871907685896-4103526904392339-3878979880273728-4441498684672691-2867521164741000-2867745721985781-4105133945874944-4049216289381384-2812175945157200-4837321369905250-4443933843941184-3769201017267871-4725935448648288-4107384508750407-2813497318400000-4727045547013524-4671136861066584-3714688771481622-4446717972821696-5066277802031250-3828153983478368-2983941810204499-3659837731130880-3772743406714363-2815700526850000-4843383966807426-4449503264299072-4562505976034997-4731857982071136-2873138613514125-4676258186395648-4000485708851463-3042861035245488-5015478227747491-4057783034688000-3776288014950007-5073022610791920-4453334938828953-4566434859938304-4059370793781000-5018225933070504-4849451627081378-4003930264013632-4624619257449018-4624981045750000-4456122992446529-4118005384925184-4061912069734344-4795687962798440-2990486394210375-4345008746695232-4176049302711682-4289250955982112-5079773403205110-4572153625536000-4911215740669647-2992124034058184-3669873057379555-4517120061803520-4573941718447125-3840152576808928-4461702590172177-4010198156214272-4744830770182356-5027654255517000-4124128732133203-4067951850349056-4124773647881541-3842555300078432-2995166951171875-4125741147560448-4917363565111071-4804696296822920-2996103648238767-4466239441288000-3788119409242847-4184220115843632-4523834778230960-4241426595532800-4015531004880375-4920823969911672-3959593093862210-4525602914165760-4808828883918865-2885522814669000-2942331610944492-3678201925598720-3791673640258619-4640918417492688-4584680066869875-4471827478727744-5038275225712797-4302683539660192-5095681239167910-4133486592000000-4077182001254472-4643820049306256-4814091966530295-4078137640555008-3965165769608750-3852176215464288-2946011921067436-4702655567504896-4079730704538888-2833367616050000-3740337375755046-3910658127786432-3797602297836799-3741213834728304-5102053661103750-3911879953895424-4989453907478744-4989843546215616-3005481362245127-4480218271352000-5104444688321490-4310756535286048-5105241863367030-4935452465945088-4028097529109375-4652532200967632-4823123325641055-4085788131270144-3915852646303641-4313449776132000-2838017440849550-3689710684241920-3803537132225379-4655438671101328-4599023990992875-4372252948590912-4713315847314599-2896359882427272-2896585942724469-4487218611136000-4998810836810648-2954073296038176-4885964037890402-4374983615493568-4318502625805500-4773454319805024-4148682822465479-2841785308569600-4774571846759316-4718099818375000-4889014984515186-4434568866109824-3752620263854682-4776434779255776-2900204507365125-3696627448983040-3810667091409531-2844003258395600-4892067200945794-4494226239144000-4608363566660661-4779416479078752-2902014919261197-4723255406231552-4040690243818375-3073440724849584-5065880711427107-4098560201224704-3814235409952503-3757599543918000-3074639383499994-3074879152622592-4043211932017007-4669989179954768-3018643006359375-4385917652591552-4785010510335972-4329632781742752-2905638002988189-3931463797248000-4729520810407203-3077277529473072-4388311899093199-4502645018548416-4787995777666500-4332333878279456-5073786472289967-5074181976094208-4960542051002703-4675817862018000-3763756497914886-3935143029012672-4962088796596659-4335036097991584-2852219706868750-4164565308899328-4050783291052583-3081117525947568-2967233275005948-3937597125000000-3709619671257565-5136796706580720-2911078280765877-4623837521693184-4966730962473375-4681651391973712-4910407180246498-4396869892223424-3711932581904885-3769332867366000-4169435385558663-3712800171192320-3827338302203699-4627441073400264-3713667895656875-3942508377474624-3714246453736845-3771682459236912-4172034311522207-3715114403520000-3829723865548987-4630325262424488-3715982488508355-3944965534385856-4288339946484375-5089226355006264-4517754946065457-4746871639638016-3832110419962563-4633210649637000-3718298042893915-3947423712028992-3718877081753405-3776384571782064-4177235402967375-3719745752752640-3834497965650251-4636097235286632-3720614559013235-3949882910616000-3721193838337365-3778737092861808-4179837568897511-3722062870056960-3836886502817875-4008999399673520-4181139057012579-3952343130358848-3036094038706897-4239404601750000-4583496783852080-4526555307756032-4068486541024767-4183417311248872-3782562023055750-4069436382236736-3840471168044431-3840769990886504-4987656539446473-3841367683072000-4988432687465847-2981823921457056-5161250602759230-4244025085910656-4760560617006375-5162455251494640-5105491766693407-4417454455755264-5048912085712792-2926301653443000-4246336586412414-4476216429769344-3902646047419156-4763894342807592-4821665634187500-3731340961853440-3903860280410244-5052447371536576-4478653887126042-4191886643976000-4536778036078339-2871601783668400-2986698078066924-4193190631931392-4021180369613750-4481092229176368-4251623167472222-4596706729077760-5114233818411741-2930856207729000-4942612335480106-4770566462767104-4943380836191702-5001250757306808-4254268102620750-4197104218289728-4254929507760802-4830295403068128-5118210774986111-4773533848000000-4141218671697672-4371626112963808-3796707201026982-4257244965591936-3969901772363625-3912671002533088-2934731292561693-4891598908395520-3971135906736501-4431901811337000-4489807818064218-4202326120295744-4375364384942172-3857528820309448-4433623829894875-3858128249836032-4031193420177910-4837807914662688-3052663553124927-4435346294456000-4838935462793124-3917537760413664-4954917907891562-5012922585612288-4898063408203125-4898443850161960-4034325903851810-4322827758686400-4496090034710742-4842319158348000-5130950889829599-3747614700177920-4151526349113864-4497836134280112-4959537758017250-4325514135259200-4441206010845681-3864726073574824-4441895728356163-4788389233152000-4846456927932564-5019934391560056-4731799752763974-4328201624548800-4155396133401000-3924845461489248-4502378108749794-4791364003764736-4098954837414879-4099273013375000-4965702023926786-4561871038880832-4273476695259698-2887708367513200-4678450638771375-4794340006166528-3985965474978117-5199488890768080-4044360755762530-4218017810408000-4276130685109794-2947291730609928-5143712128721983-3756935188431360-3930637165614500-4162174041045312-3815622233739558-4278453827408768-4394428632295484-3874336329321000-4452940922099747-4915965483438080-3990916856177973-4453977346743848-4280777810968750-4396815549662976-4860015198757572-4860392177907168-4745036577108798-4571792254528000-4919398508895485-3993703809189192-4746508857354934-4515322000605312-4573565412460875-3879147425781352-4805883654822349-3995562498490368-4111694722650599-5038664500083000-4286092933229454-4228500608501824-4866049204678788-4808492847028872-5214432649713750-4577467973625344-5041399860633951-5215645559195280-4752401023780118-4347045225000000-4405347310143676-4347719220330600-3130600495766058-4000521822498816-4986544127725750-5218880903983440-4465388633801711-4465734734300224-4640084002786320-2958282810861000-5220903673748790-4003003022648832-4873598732780148-4467811712852488-4061961762311250-4642601747655680-4120628331094723-2902075794111600-4991957139410474-4934293422080000-4063850607555270-3077153857381544-4296736372890958-4239000760421952-5226570209531250-2961952567379976-4878888045912972-4588833500343808-5112007973115032-3776207475105000-4531799982207498-4357837511937600-4706829063085797-2905675081545200-5230620244383750-4242942794354688-4882668468850452-3952942500702496-4069520656419330-4302397860176000-5116761241065848-4768260378788016-4710475600430967-4129255128369664-5002020265551750-4071727098945520-3083117794512319-4595946499234368-3839948792047434-4363916015625000-2909502583937550-3782646186475520-5005119330604822-4889099668745376-4773062003947750-4133093122150336-4191630147654696-2911079590775600-4832766173796757-4600217824704000-5066454787942047-4484450729738056-3086938755430191-4368647646580800-3844707460910250-2971140233593896-5243594414729670-4136933493379072-4195524809563848-4021022412177000-4079613761160770-4313068264397952-4488269647085609-4896673013301216-4897051885687500-4722522535558656-4023200816036877-4781565081530064-4781935009457398-4549021787856000-4491048402882657-2974820613336168-5250089537521830-4142057687875584-4025691383677125-4201046375879232-3851257047620598-4143339397310912-4260382679104037-4377444032925000-4844746067456693-4611620962237952-4903874930913588-5254558044316560-4087194531691250-4671440686586880-4438211830655548-4380152986919400-3095547457209147-4030363968000000-4965325017094085-3037845465491616-3096504966404231-4323756296542336-4733126177320125-2980346879641416-5259842274954870-4851118430839296-4208524438257288-4851868487803000-4793782779669942-4560292199059584-4502174895202369-4444048570582944-2982420992662125-4503218945032192-4094151815915910-2983112577451032-4328772383937166-4387608372600000-4621971318871219-4914880940612832-5207835796351263-4974160112919040-4038159640828125-3043485901246752-3102254168309999-4273246277487296-3922323594184863-4917919976508000-3103213059940123-4977235644641280-4977620175220645-5270828532993360-4041280722468375-4451609592000256-2928916762112650-4452297382531872-4569816075530082-4160025688384000-4043154143155149-4863879916026104-4805650103174774-4161311101606464-4865007002693375-3927477631022312-4865758490528109-4866134263463936-4983775358294165-2990496135375000-4515411455096927-4574406371044224-3988251957200436-2932764642993200-4868765215739125-3813182823191040-3989483881397924-4224485543379264-3109930834510287-4401185284200000-2934350043569050-2934576575996400-3052195244885644-4519945700773888-4109358740523750-5283869080130640-4520992496047951-4521341463718464-5050199722646174-4463311667828000-4992247017276435-4757684917298688-4993017643792445-4875911151804792-3877529777343750-4171603941061696-3936887788552911-4407304020911400-3173503764173706-3173748645888000-4055658412477029-5231615218382152-4115071030797090-4350553594541696-4292093458701125-3939622582380552-5292438617709270-4998799870661120-4234604197634568-4999571171365000-4588195698993738-4294411838265024-4059414714249033-4000891208626912-4589611553855250-4531119850729472-5061121599783478-4002125734061856-5297339653802910-4414790175000000-4473999064749276-4474344103237408-4592444137345506-4651680321593856-5064245025815750-4770179989494696-5065026083063298-4594215093726336-5065807220614894-5301834927390000-4772019343214511-4301040379756544-4183526177929287-2946372334797200-4302035248893875-4420239971947200-4302698580208549-4420921511747400-4892863620761397-4657421954752000-4952577227132724-5070886572396528-4599530694444426-4422966551476800-4600239750843750-3951792545213992-3126285777511099-3952401700368384-5014627397322565-3894010755162000-4838386196096262-4366684995324032-4367021489505538-4485394703702304-4898900621181125-4781223204558336-4132239658606710-4604850393754416-3896712080581254-4192240509864000-4664965015658059-2952736969644400-5079098849511402-4902298615119872-5079881433241750-3071792828755872-5316974055371070-4312988936599616-4254234565273128-4431835678125000-5259516748142239-5023520863879680-4196440611791567-4137654463226480-4610884343042250-4315647173157568-4493348551265468-3961546541032104-4553172747822083-5026616706560000-4080744241939989-4554224666770856-4140523038564290-4495771152486144-4791914500852125-4851447443441072-4970158063673292-4556328990692864-4142436158504630-4616212791294000-4379821081573214-4202584267129408-5327629584598530-5328039696698160-5091629837406250-4085459321094144-5151627820632471-2960933530867600-4145626001141730-4442084009400000-4323961201800293-4442767792662600-5331731652727830-3850991426613760-4029039529870500-3910839301330896-4148179053956210-4741140867701760-4148817480896830-4030589955532000-3082453008766092-3971927733661696-5098687567008502-5158371480425208-4387917906440750-4566157740139072-4863035588343786-4388930710631408-4685840532242921-2965950000000000-4211972981307071-4627593864504624-3144632572810431-4628305802020992-5340763613261250-2967319110610800-5104181419067498-3976819269730304-4214565429918759-4155524919070000-3146567979391543-4631154282278784-4869023779566154-3978654630627848-4869772648926750-4929539150355968-4038969127618084-5167901956503384-3148504179924527-4574593624216000-4040211473225748-4931813739007784-4991616916034028-4219429137813504-4279186666125000-4457828783218200-4636498332389274-4399067325496448-4399405481182786-4518655644852000-5054148064677235-4816676003102208-5114394754608582-4817416460595624-4639350172694250-4639706734935168-5175455236457811-2974628150143600-4878765071338158-4343624630272000-4224945861960391-2975542623104400-5296872861713123-4463999894788800-4285769185161000-3988452759845512-5358034760114070-4941678375323136-5180229519014463-5001985180500000-4645057361072778-4347631253128384-2978058390093850-4467430749709800-3157226911842875-4587266921746432-5123834533364598-4468803583733400-4409558211696046-4529083307616000-4946615622470423-4410574342988272-4708947756220713-4709309408037376-4173126271973750-4888894771038672-5127771200183618-4710756200472128-4890021157971738-3995811904081000-4950415741857613-4473610717593600-4235343324623207-5309499975652936-4832612567296875-4653984210016128-4893025702261706-2983781315127600-4834096822893159-5192576670144000-4118566610622429-5312761840083752-3104323850408924-4716546333431616-4776616075130000-4000723025859752-3105277096038156-4479108804710400-4121096377875861-4001951434743000-4181464184139970-4420744242934912-5018527225937988-4540920704836384-4959543967937125-4959924554009088-5199356010613551-4900918485953744-4901294544358518-4662564738000000-4961827776425983-2989282216460400-4603847813620979-4962969943539712-4185958425783750-5083339473256360-4425835050095182-4426174576130688-5323780495110581-4486676027325000-5204943425442897-3230902352858112-4248364123528687-4308530688975168-5146695270745250-4668290945205888-4429231091881362-2992953237551600-3053046431630109-4011172517376000-4191098643799270-5269213773458624-4670797634401626-4611269193194048-4372057970703125-5031246989359584-5091533162017555-4253253794785792-5032404396069876-4493562712275000-4913338572977462-4674021838821504-2996397548281850-2996627262905200-4615159763473875-4135979683774464-4256189397649063-2997546238803600-5156174740865234-4257168232024000-4077600407855028-4017943639436296-5397651401148630-4378430580152832-4078850662206500-4439089436226064-3959491300348518-4559763640744192-4080101172096532-4980505127625000-4980886785275933-3240825264709632-5221729684808199-4381787070971272-4922384531207750-4382458574914368-5283368534654584-3962829996332592-3062421423730629-4984322581568000-5284987833864728-4204289655966960-4444875260877278-4745568176192576-4565706446101500-3064064017941096-4926911670977966-4987377948819456-5107946944423765-3065002906863000-5108729431762935-4508047681233600-4989288187269511-5410485860402160-5350779100109375-4268925952708096-4329383186752776-4089175013407136-5171999711781154-4691242657296000-3007437098337050-3007667376828400-5414215800733830-3910566359797760-4091367264650500-4512882912514200-4212346523854210-4453392956057728-4333362703795368-3069700228509000-3009740412243550-4274158547778048-5177546091696902-4214604289936880-4214926893791250-4817428016122880-4998464121764959-3011353431519600-4637839221215123-4276776448000000-5240958129271287-5301604731315904-4217508317289890-4519104717124800-4398931859429125-4519796381536200-5424170688246870-5364312564935168-4279722863249359-4460897523114000-5425831021583790-4401288550257344-3014811841829850-4522563744925800-3196189552958875-5367596837842944-5247378084924231-5247779506136184-4463970001593966-4584968542048000-5188650744414046-4585670000847648-5129102162518195-4888106500345344-5129886808828125-5009566711119608-3983815544945478-4285947516604992-4044794998601263-3018734573350000-5132241227888235-3924955183185920-5193414737760982-5073025546251936-4227844551201250-4530179818219200-4711747254634134-5074577325658848-5377046588993791-4048198492608000-5075741367859764-3142365832345376-5136952226962095-4714269474625152-3022198631556250-3022429662946800-3083113920233373-4050674959806464-5139308807196165-5139701640625000-4474905794838574-4475247825854592-4717513651287606-4596903073688864-4899705350016375-5021069436604928-4295459935239103-4961332851243984-3206960191101887-4659524621752000-4901952405863061-3994488651960048-4963228757084654-3934567314063360-5206132974377750-5085448642940064-4722563106078714-4722923919232896-4359955154551848-4541966923725000-5026827396459413-4784936167880192-5088168896111028-3937574320083560-4967780901593750-4422874478010048-4483804266473042-4544743328471400-4787495283056481-4060590928384000-5151889408128485-4485516862298832-4243380545473090-4668075077689408-4850318517930000-4608154475949856-5032974070470949-4305643935846912-4124030210430692-4973474995298000-5216481817448706-4731588949236864-4671284193480289-3094203681633384-5460776333763750-4308274675449856-4187234477924037-4369621718274624-4734118244536122-4795178103000000-5159762699971585-3035386220580400-5039125753103541-3278717609389056-5282781574893375-4554469654846200-4494086382990782-4312222793733952-3037008389031450-4555860261825000-3219720290173243-4678063822688256-5164490523170245-5286411336129528-5226046759955250-4557946702987200-4922958065509053-4011605245918512-3039326774937950-4924085059008000-4255706831121270-4742435132311344-5229237670448962-4560729615316800-5290849968421875-3040950346898800-4987539026020206-4440464922935296-4319137803388519-5171193215145000-5475798711152190-4563513660177600-4746416215244886-3103662696896904-5416608789913375-5173560255029760-5295694945580511-3043734958123600-4687709312071863-4566298837800000-4627535692190396-5054141475544104-3105793628616957-4567691851468800-5238019371021750-4142005541174048-4507820306984302-4630006283726592-5300542879622763-5118155731500000-5118545943886284-4814237594194432-4266105356798390-4754022650041392-4754385063782250-4815705797171264-4694146998486561-4633537225374112-3109584359609229-5183035637760000-4268707632201670-5366784331561664-3232514191672791-4696652134061888-4148008904744500-5063396730031368-5063782610640629-4820112197078528-4332329693709039-5431080637817000-4943270273006691-4455385523699904-4516762345120658-4089812646976808-4700590576171875-4945153854099456-4334971290969943-4213180395232488-5007349469828998-4702381504744000-4580590660750575-3053959742548400-3115276237539237-4092929565331968-4276520807413750-4093553138978552-3238430482480959-4338605240194112-5255612256194734-5072663276577000-4706323148717267-4339927179624448-5318343950136759-5502154119748560-5502573139938750-4463538102692928-4769623078254294-5136908306274528-5320774452323313-4831875736000000-4342902525072271-3058614931640400-5200041285825295-4772165908478592-4160666520148500-4650510735891616-4712060380115011-4222817126166528-4284343510645030-4713136629817000-4529852737581294-4652635334672128-5510119141619730-5143169328355296-4959862210668375-4347864455574016-5266828213125318-4287279481984240-4287605783794130-4777981485264000-4533301776344114-3063274848972400-4962882909777327-5085810227412992-5208756215703125-3186775696040352-3983772737586395-4351836720083392-4229571573790641-4597710210525000-5088519769299253-5088906925254144-4414809340493064-4537788143489296-4783437877754250-4354486240083776-4170811132198804-3128346312559272-3128584288037469-5092004879872000-5276454581708406-4663268035355488-4295441994991490-4725345581909568-4602959403459375-3068872994426800-3130488526348773-4112915350987264-4297402538509430-4113540952875000-3254242540495103-4359788505851968-5035631595839514-4606110836149800-3132393537190125-4238266441826304-5344307494598391-5467580828932168-4239233273190951-4423884086592000-4792905462476118-5161982914966752-5346745900048689-4855460200818176-5347558866657375-3135014188781496-4795092062323914-4611015923342400-4058002449514794-3135967515273000-5534480959569990-4858413643681792-5412315138279896-4059544868835984-5044060284343750-4736855603647552-5229393836068305-5045210379154864-5230188677435315-4984440898752000-5230983599339485-4246650532283592-4308523554411090-4924401066552320-4370738019047875-4617327579244200-3140021308989453-4494881783545856-4372066477188999-4310815554430000-3264151165931863-4804210053512064-5050963475604874-4127320249307528-5051730885414750-4867281157778944-4189876699520164-4066953922283472-4806765160742922-4622240625000000-4684226246006076-4622942773050600-3328771589092458-4253753392828416-5302182227285750-5549216738959440-4748023746376911-4748384301007424-4933760907938320-3145511411901000-5551323983084790-4256338213535232-5182022561410548-4750548012113288-4319007904111250-4936383787207680-4381373222100323-3085708344991600-5307821275040874-5246500679680000-4320975611243270-3271844169826344-4568582026201358-4507186532697152-4569275619281250-5187138988380384-5496314407400287-4755599227298304-4447131583168008-5374025163399000-3274079884389423-4509923967504064-4263128349438153-5190289232125536-3089692322768750-4634890171699200-5191470902280852-4697401514834272-5068633572921158-4759931689128000-4822114831358838-4204213941349984-3215231054672364-4143015852579328-4328852416253750-4143644503003512-3278057002377119-4391692513556032-4082728081485834-4144901994625000-5073249931294382-5135508348862464-5259654460057045-3217915022580128-4270249566642375-4518142921787968-4580382657685282-5199747615645408-5509674223895231-4890980598464000-5386678246646847-4272517070410632-4087065366552102-4706674576498944-5574116221841250-5140963640800168-4769689347289251-4026666426798080-5451900190616792-4522941919989000-5080950089245702-4523627768439104-4709887323539292-4586290586030576-5144472653453125-4401027079543296-4277378709719277-5145642679069816-3286020897981567-4898402419048000-4774754119515457-4713101532247968-3162978902582637-4403696525737984-4404030282390375-5334863504336816-5583419805150270-4591159751564928-5522218697318741-4653907730925000-5398942061280177-4282244035625472-4220502311338276-4220822110967712-5338503025009250-4842264958497408-4097611559525418-4718819291154592-3104721581939950-4036443840000000-4223061160718468-4658140907640600-4596380537682798-4720964642385664-4907690248239875-5218698841189344-5094830000886526-4908805576053248-4349904016047030-5158133992523000-5593580969051790-4848137335776384-5345787031468142-5594851980678960-5346596774270250-5160478362042368-5347406598837718-5596546962332880-4601953737010766-4540108938344000-4229462808644148-4167580368679816-5598666170763030-4914756845047296-4479611203125000-5413273354154712-5351456948299938-4854014458889856-4232025278152852-5228191697148000-3112254453829550-3236989654286336-4295561414190453-4295886572755176-4109419932609750-4670148846859200-4172315418006151-4110353137576752-4546643777610687-4048687847360000-4173578703265307-5046051637580328-4049607144745955-4299139060936896-4050220086973125-4112842374836976-4549397163790679-4051139616276480-4176106038722083-5049107227125000-4052059284744315-4301742233170752-4052672474375005-4115332616885424-4552151661355375-4053592374807040-4178634394268331-5052164049943272-4054512414431635-4304346456024000-4678991367133575-4055432593259320-4679699250543525-5304060314890240-4493190917133000-4119069864379536-3307988096960039-4806308451993664-3121215552765450-3121451603150000-5057134018005591-4433131710263808-4371023755995190-3184843842175224-5620737660468750-4871674322406528-4247421833157844-5247211930275168-3310991187723467-4060956590080000-5185921245234003-5498741839585984-4124368170449142-4874621790909312-4249991550600500-4750349642625056-5625839305413270-4063413309063680-4188758021464523-5064403678929000-4064334834064115-4314773857870272-4064949261461205-4127798906047344-4565940827798375-4065871018659840-4191291480545491-5067466671847752-4066792915191435-4317383337000000-4067407590291565-4130295181082928-4568701998380671-5320123478781440-5070147803537625-3380353933022064-4131855863932038-4319993868020928-4069866910058885-4132792462326000-4571464281917463-4070789410488320-4196361462886499-5073596362233864-4071712050306875-4322605451145024-4072327220962845-4135290749979312-4574227678633007-4073250093120000-4198897986558187-5076663060198888-4575609794502891-4137165126297984-3197141764359375-5140890661032432-4576992188751559-3135162897817600-4389559511224230-5142443721994000-4076635150567915-4327831774550592-4077250816979405-4140290345327664-4579757812497375-4078174432816640-4203974099933051-5082800162917032-4079098188127235-4330446515256000-4079714102491365-4142791653428208-4582524550094711-4080638090280960-4206513690047875-5085870568167816-4081562217571995-4333062308912448-4082178379938685-4145293968750000-4585292401767823-4083102739755520-4209054302722059-5088942209678184-4084027239101875-4335679155731904-4084643649521045-4147797291495792-4588061367740967-5342666344960000-4085876656425265-5532065774288064-4086493252916555-4338297055926336-5344682191880625-3207051253261896-3270181305594476-5094320557819392-5472090416443983-5157991538306000-5158380634702902-4340916009707712-4089577165889605-4152806960070384-4593602643484375-4090502642237440-4216682278159011-5098164554255112-4091428258199035-4343536017288000-4092045413075165-4155313306304688-4596374953703151-4092971261749760-4219226983128875-5101241143292136-4093897250066195-4346157078879168-4094514653194485-4157820660774000-4599148379118983-4095440874270720-4221772711687219-5104318969832904-4096367235016875-4348779194693184-4096984886447245-4160329023681072-4601922919956127-4097911480000000-4224319464039867-4413800770232560-5612255399681803-4414466167332480-4099456113033125-5172011339526512-4604698576438839-4100383079137280-4226867240392643-3343893232473000-3281048147974012-4858841266920256-4985420589522963-4796462226470944-3155805033418750-4607822523806208-5491928291981631-5555472458926016-4924539780440202-4861770926936000-4988426495588219-4799354129458848-5683873854129030-4105329258434560-5242584580171875-5242979511714008-5180201276787206-4927879709341056-4675520090064386-5307746899308000-5181762244441662-5498137446038016-4424121941577590-5119726673802024-5372957313169375-4804417756288256-4235792524599951-4172885971879152-4615812363310487-4110279413760000-4237068589921507-5122811930590728-4111208010656955-4364534040127296-4111827152948125-4175400389670576-4618593601384879-4112755982932480-4239621489362283-5125898426625000-4113684952783315-4367163541436352-4114304343726005-4177915817319024-4621375956450375-4115233546711040-4242175414038131-5128986162153672-4116162889590635-4369794098664000-4116782529234765-4180432255027248-4624159428731231-4117712105295360-4244730364154875-5132075137425576-4625551583897499-4182320246282112-5006487308680811-4182949702998000-4626944018451703-4754067298713600-4500855673644807-3360046465340072-4438131113281250-4945718170643328-5326558744007172-4312300529962336-4693150680984486-4122672207680000-4249843341534347-5138256808194408-4123602670095155-4377692107978176-4124223056143125-4187987630538096-4632516551108519-4125153751879680-4252401369208723-5141349504189000-4126084587623115-4380326890999872-4126705222572205-4190508110512944-4635304494493375-4127636291683840-4254960423147291-5144443440922152-4128567500830435-4382962731000000-4129188384730565-4193029601561328-4638093556214871-4130119827292160-4257520503555875-5147538618642696-4131051409916795-4385599628190528-4767314472482175-5149086672951000-4831604985942356-4132604358904320-4260081610640299-5214223124483408-4133536315081875-4388237582783424-3180121305410650-4706933268318768-5725078810970310-5407425236480000-5598696261572568-5408238016463080-4963226659830426-5027235521800896-4136643847578125-4709763796893424-5728521518188470-5665296931900928-5538402996901743-5411489950845000-5730243389234190-4648213283286464-3247625857341087-4266809402977768-4649260990952375-3184664562892800-4458865322096710-5223634605417104-4140997009046235-4396157793096000-4141619138450365-4205652230002608-4652055647720911-4142552449384960-4270336309852875-5163033130765416-4143485900522995-4398799979418048-4144108279177685-4208179791750000-4654851424171623-4145041964011520-4272902553403859-5166135759635784-4145975789076875-4401443224202304-4146598417032045-4210708365990192-4657648320528767-4147532475840000-4275469824865627-5169239631235368-4148466674907555-4404087527660736-4149089552213125-4213237952925936-4660446337016599-5426954442014720-4150335493863585-5619337501624000-4150958558214715-4406732890005312-4726416072063458-4215768552759984-4982645848781250-3194243455308800-4280607452344811-5175451103617512-5175839485769859-4473283359440000-4729254405172434-4729609276688432-4793882600631525-4794242303692800-4538889916760375-5562155646001272-4475633419446210-4987508547705216-4540252230825499-4348736815932000-4732803919226054-5180890222038528-5309211688011531-5757408388780560-5501936257989250-4990502549755008-5310804889637759-4863270436479392-5759568010799910-4160000000000000-5632422410560088-5312796839840664-5249180888562214-4993497749764992-4737776222009250-5378419562898144-5763024529230870-5187111022121472-4290895051288843-3202400600050000-4996119532663818-4932436530693056-5124993622575760-3267428399659944-5702410403300375-4805762304307200-4549796062628823-5319174427524056-4230022059572694-4486723360560000-5320370793128663-4359184750164064-3397854565084851-4552184108501504-4616645401125000-5258240253281232-5515153124972738-5066625034054208-5387701279328676-4361799345836000-4682870820534743-4169991989329920-4298621557967779-5197230439503624-4170929557786875-4427933934099264-4171554681492445-4236049840101552-4685678928290287-4172492484160000-4301199119857707-5200346752081128-4173430427367955-4430588835957696-4174055800923125-4238589565144176-4688488158419079-4174993978388480-4303777711922483-5203464310125000-4175932296422315-4433244798821952-4176557919877005-4241130305112624-4691298511145375-4177496472215040-4306357334367931-5206583113884072-4692704108552667-4243036526256000-5079166493011499-4243672060209648-4694109986693431-4437230732967936-4308937987399875-5209703163607176-4695516145595699-4631540773999104-5082209960232211-3281166005493000-3281411669173461-5340736463619584-5598540468604479-5792027177270160-5020132682906250-5084873991159104-4763403083303442-4892509922145952-3283377420064989-4442549027328000-5666283730926808-5344735816803544-4250348998617942-4830303548452800-4186576394918125-4766612923548144-5797665804465270-5733676366571008-5605249156572303-5476802681965000-5799401502621390-4704311001484224-3286819372902207-5349537675498472-4705367121588375-4190023942307840-4319270909509091-5222195827116552-4190964510869435-4449202869000000-4191591634769565-4256396069719728-4708184214609071-4192532437916160-4321856718560875-5225322110392296-4193473381827795-4451866264840128-4194100755976885-4258943919846000-4711002431797063-4195041934520320-4324443559434099-5228449641125064-4195983253856875-4454530723381824-4196610878304845-4261492786520112-4713821773376607-4197552432320000-4327031432334587-5231578419563688-4198494127156355-4457196244837056-4845140771484375-4716289619787448-5168923002270640-4200063931514880-5363559522535187-5428586536548000-5041207202311098-5106219761217472-5041960952545686-4395884284575072-4784114020067750-4202576432304640-4332210275040651-5237839720553832-4203518878365235-4462530477336000-4204147254009365-4269145487857008-4722286546707111-4205089934888960-4334801245257875-5240972243603016-4206032756673995-4465199188803648-4206661382816685-4271698422750000-4725110388095423-4207604439467520-4337393248325659-5244106015353384-4208547637051875-4467868964032704-4209176513743045-5310434769193584-4339337928558493-5635083620352000-5441176834235604-5506364050179880-4470205890141543-4535330235166080-4535669004448750-4406407568012128-3305052518210613-5379212704595456-4601838882423439-5444835724692000-5315593741457302-4473211706622912-4732881756013341-4798074040713776-5835931232343750-5512124418600960-5707096122220504-5512947656178920-5059317951116442-5124563612728000-4541091607481870-4411675501782624-3309003665232837-5385643322808832-4607340046545375-5451344468207904-4283518986067398-4543465354727040-4543804528988830-5452972464156000-3505743973145034-5388860552904704-5648986305007959-5844215125924560-4286077647381750-4481233804017984-3442364030444769-4287037407997872-4742077080043727-4872360600000000-4612845593082671-3443648750287624-4548554741179890-5068767787953792-5459080335670500-4419585272203488-4809907555480982-4225234044129280-4355566206905043-5266077402141000-4226179874405515-4486587193760832-4226810506333805-4292158551142704-4747741656501375-4227756571850240-4358166480186971-5269221172458792-4228702778524835-4489265486712000-4229333661400965-4294720651389168-4750575635578391-4230280103362560-4360767788171875-5272366193717256-4231226686510395-4491944845332288-4231857820384285-5339049533694000-4362719448308197-3256003568358400-4688994767712264-5275512466165224-4233751598561875-4494625269833664-4234382983483445-4299847910243952-4756246976550087-4235330178560000-4365973509073907-5278659990051528-4236277514878955-4497306760428096-4236909150898125-4302413069257776-4759084338893279-4237856722644480-4368577922402683-5281808765625000-4238804435661315-4499989317327552-4239436322828005-4304979248266224-4761922829440375-5545117893263360-5284564971222033-3458059457236136-4502337429484551-4567929070320000-4568269460970670-4438078158001504-5874364662430230-3524881423666176-5679398768037375-5353395382369872-5353794244561366-4505357630889408-4244493681032085-4310114667078000-4963532094510836-4506700376051712-5421507197592611-4376723389285208-4834353088968750-4900047160843200-5227106298714640-5423526731891016-5489279261561676-5162920966208000-5555455288183485-4510058406097992-3464505767294911-4576103113841280-5230221611930000-5361376390919792-5034838109832531-4381289270247424-5493368719235796-5886190475010000-4774710004438483-4644241816973248-4382920711261719-3271079886609200-5364970431134750-4514762449949184-4384226155630891-5300727718430952-5301122342922819-4581557890000000-4385531859190367-4320397753558128-5171770146952033-3273515900723200-4386837821965875-4452644418137888-5369764982784326-4911735967358400-5632543101232094-5436463628653000-4781823871816863-5306254243757568-4389450525267899-3341472186436344-5897154443028750-5111247513410688-5242695242801040-3342466918909032-5833366496576551-5440510623744000-4654277057727431-4261274905306120-4327154909765622-4524180348123456-3475353594390625-4328120792554416-4787520050542159-4919050902566400-4657047941721519-5444559626771000-3476905129988623-5117335351000704-4461598565210516-4461930430619872-4855991340057750-4265715054448640-4397294859034451-5316527979452232-4266666916084235-4529567879976000-4267301569168365-4333274594991408-4793220751053311-4268253666792960-4399911712262875-5319691794680616-4269205906024995-4532263249069248-4269840810855685-4335853029750000-4796072797539223-4270793286123520-4402529603487459-5322856864830984-4271745903026875-4534959687223104-4272381059654045-4338432487138992-4798925975144367-4273333912640000-4405148532914027-5326023190152168-4274286907289555-4537657194649536-4932602672034375-5853790213562744-5196447156758177-4539006349406208-4407768500748403-3421208889956000-5592776278708935-4606158029119360-4672307463633307-4475218545486432-3488297169921875-4936636370803200-4739523052509576-5398191207392464-4279371938396035-4543055418168000-3489852555196073-4346176997115888-4807492296917751-4807849448046592-5796194277863000-5928366332921040-4347791595879798-5138680847903616-4480208382103092-4480541169692000-4876245206738854-4283506494558720-4415634636756619-5338701048121704-4284461000941875-4548457921320384-4285097417300245-4351345120636272-4813208837807527-4286052160000000-4418258760280467-5341873653029448-4287007044503755-4551160778289216-4287643712958125-4353930718065456-4816068806837439-4288598833825280-4420883923241243-5345047514601000-4289554096524515-4553864705802432-4290191017124805-4356517339544304-4818929908556375-4291146516234240-4423510125844771-5348222633085192-4292102157203835-4556569704072000-4953160765384575-5878187025598872-3566805147016218-4293695207426560-5483125396546875-5615665626445960-5880368602768987-5220040378137408-5220427746013531-3370399642857000-3370649740532541-4692821360611328-5750785248058119-5619000179652840-5421084723655750-4561982913728064-4297838982674445-5422291435229104-4893650423214406-5092419423168000-4431394973570107-5357755532501928-4564352540463183-4630846069386880-4631189578478750-4499203587284448-5955269975516070-3573427017351168-5757614989579863-5427120072250000-5427522588015782-4567400408953152-4302942672579005-4369465814779824-5031879226924500-4568755452578304-5496156857891419-3311183387595600-5960572058032110-5298679146880000-5034118437405756-4902005079943472-5829843670890536-3312656770867200-5830708183927000-3313147995734800-4572483204401847-5103004474508864-4705716592201339-5037478498548000-5236714507161769-5767442213362176-4773409437874824-3447717916054048-5437188938093750-5039719369733376-3448484624589316-4974144547151400-5040840054490164-3316587929600000-4776240571534152-5904401586554952-4312522978308155-4710951111093184-4644943875888750-4512565565165408-5176561710941634-5774285134001664-4779072824412168-3451808341748000-5443639543443222-5045698274937088-3452575656564164-3320030243689200-5777280613001625-3453343085084672-4781906196730056-5446463286851344-4317638284147435-4650108750000000-4849758348619573-3388438316286408-5913595062573903-4850836125916672-5848016397311000-5383231963811496-5715953553530498-5184620904567936-3656093187572595-3323967232550000-5983584115754790-4986689362329600-4721082185284487-5984913538506960-4389261596997750-5254202160539584-4855508339394149-4390236699540912-4856227407640207-5122701322816000-5788415747646207-5655767426915080-4391862191354022-4591832216849856-4325959280703125-4392837679004016-4859104390552359-4326920083066880-4460386240044563-5392806407037000-4327881027683915-4594552227964992-4328521736463405-4395439685558064-4861982509517375-4329482918192640-4463028061988251-5396000409070632-4330444242203235-4597273313016000-4331085203927365-4398042719405808-4864861764759511-4332046765096960-4465670926867875-4665971568393520-5132948493543871-4799995275354624-4466992750472983-4400646780750000-3534114168420003-5935083608218112-5802140158736799-3334809997573200-4669079376771250-5136367251370432-4736481190897203-5070411244004512-6004878515719110-4870983955968000-4604421272415189-5472325660314896-4338139957680555-4605443013903936-3537775830192625-4405857986738736-4873506350391199-4873866763521536-5875780727520792-6009765587370000-4407487331901126-5209233839881344-4541719157651156-4542054984267232-4943190018093750-4342312274493440-4476252819862211-5411989337624712-4343275496595035-4610894854728000-4343917723791165-4411073305146288-4879275092975951-4344881183285760-4478900902508875-5415190908754536-4345844785230195-4613622387845568-4346487265670485-4413682507014000-4882161170590183-4347451105054720-4481550029326419-5418393742271304-4348415086916875-4616350996382784-4349057820651245-5486909158829744-4483537559800533-5822337192000000-5621982340951284-5689331065012680-5689751448579295-5154626266702528-5155007122274625-5088434905741216-3347901876427150-5156149801549824-4754723142643559-5558748955423000-4353558730243515-4688794215064960-5559980977990951-5091442995661344-6029785764753750-5963228593375744-5829654028164831-5696059687267720-6031567484699310-5160722207256000-4356775566198965-4960387737416752-5362977382749360-4357740925890560-5564910888671875-5565321846053208-5498675801694406-5163771978992704-5365354062255120-3420665780397000-5969837919803599-4896970182065664-4494811333181179-5434426854368424-4361281798111875-4630010177782464-4361925799065445-4429359328288752-4899501538909687-4362891919360000-4497466729346307-5437637267432328-4363858182300955-4632745243288896-4364502436848125-4431975735404976-4902395586161679-4365468937556480-4500123171123083-5440848944625000-4366435580939315-4635481385698752-4367080089130005-4434593172653424-4905290772830375-5712061422735360-5443660199344833-3562163950226536-4436229594137814-4638218605224000-4705786352734670-3428754449273928-3496242865140844-5984395624470016-5850346413927375-5581776736648568-4438848705783558-4640956902076608-3565055957130377-4574371475884000-4911084565314903-4373206080389120-4508098772181539-5450491563463944-4374173865546875-4643696276468544-4374819134967645-4442451667219632-4913983171579247-4375787158080000-4510759398463147-5453708299660008-4376755323979155-4646436728611776-4377400847243125-5522666736606192-4512755555021101-5860278843838464-4580785564988292-5524295761738000-5726826351046535-5120834024095488-4716905388478990-4582474479126112-3437109233821125-5594139167103488-4785700733909983-5662373182064928-4449335461038534-4651920867000000-5933321908104888-5124610264559008-6069064725803430-3506829187350528-4788523531586375-5463366101481096-5733584498225655-5194335806268224-5734429640270465-5127632593236000-6005170153143359-5060909566809600-4791347439043887-6073986556290960-5264509577018250-4927404062063808-3442686623372463-5603216541177256-4928493312092007-4388707781120000-5604455125204963-3646540644140592-4389677851849355-4660155163016256-4863128837625000-3444970020635976-3512777201470316-3377919195417600-4796998584174719-5608171972411000-4392265405962915-4662902086118592-4392912453334405-4460824247015664-4934305356772375-4393883143536640-4529413099902051-5476260897409032-4394853976722235-4665650088456000-4395501278286365-4463453029100208-4937213091825711-4396472349800960-4532082105072875-5479487763555816-4397443564326995-4668399170240448-4398091120133685-4466082843750000-4940121968986823-4399062573035520-4534752158531059-4738149540674480-5212348169403375-5415825312097280-4400681979076045-5010375956763888-5078457522410925-5620573331008000-5620987024179723-5621400737650424-5554081766945654-5283539778172032-5012957927587250-5690803454708064-6097738130789670-4946307126132736-4540095411132803-5760246385305000-4405218430210715-5015540785293952-5354822664223443-3457165193046024-5626780860203125-3389876420428800-4813978676997743-4814332854357592-4746874555439730-5289763639056000-5561442679362362-5087059581882600-6037088114853143-3663221792956416-5766606612613125-5495641109720136-4410406762021195-4750018180871040-4411055589789485-5565125573198000-6108513897030390-5633821583266304-4819647599565247-5498875583780904-4413002454891875-4684916341205184-4413651537202245-4481883426873072-4957599228775127-4414625280000000-4550794504840867-5502111326698248-4415599166005755-4687672985054016-4416248502908125-4484520475156656-4960516106969839-4417222627617280-4553471902073643-4757708440870000-5233864014743287-4894362480047616-5030686769936978-5574954571597808-4963434129066375-5235787946504192-4896161569332936-5984637315662016-3604648755682727-5305344670704000-4625512204920948-5170070049410848-3401611846088350-4694569325139456-4558829846546875-5784015117797960-4695604359160527-5172350068509952-5785290284637065-5649580902321000-3539756541161932-4561175268294656-5991237532679256-4766107276959280-5038826439532750-5039196632982144-5175771353875228-4631293527712096-5721429933216396-4427622205760000-5994759631812248-4905163629193536-4496730279169062-4701472425679296-3611541176609625-4497721233438576-4975117660955879-5248112275574784-4907686181763528-5998723643000000-3613132981997703-5317831502116224-4636398693672436-5182237897445664-3409617401318750-4978406954567168-4569558341287131-5524797076005672-4433804671385635-4706999775864000-4434455791829765-4503008781739248-4980966296142231-4435432592015360-4572243092379875-5528042978733576-4436409535633595-4709765074790208-4437060911069085-4505654109198000-4983892331830703-4438038093765120-4574928894847339-4780127292333680-5258525958984375-4917424128579072-5054390180453842-5054761135795248-6011508454286632-4713915053568000-4577615748895347-6149487330807120-4783285580177090-5262000245587008-5945813173408875-3485732446349256-3485988217349253-5400260315058688-4853754619191199-5606156071458000-5264703526233767-5196711995333888-5812538510166345-3419391141849200-5813391392976875-3693484291129344-4719798362184837-4993776162047816-3625884266713047-5199762604000000-4721183381136369-4516245779153328-4995607933785871-3558776243529728-4585682622580875-5544291563790696-4997073673652939-4723607816238528-5477048384754320-5614386296822000-4998539700196263-4451080908984320-4588373685009299-6026962574331072-4452060148956875-4726379615375424-3630673722086289-5686188941552456-5001472613423807-4727765921472000-6030056573196568-5824913477883080-5619740260458294-5277460034694848-5483477316250000-3495973048281576-6169816447018470-4730539346853888-5690776034862387-5348350203846000-5623036698508262-5143398332817600-5761028351083908-3429434875025200-5761872849631500-4458918850480640-5899924988577958-5488704525893760-5626334425393558-4734701518296000-5009544039906333-5078540048689712-5833885617553595-4873367406219264-4942368497421000-6041115212927168-4805784645068610-5218091330305792-5424466016437571-5218855960500000-6112002750276239-5700375200356864-4739213291619213-6044656831018432-4808601978871250-5015052261125568-4465784592587045-5084496406445488-5497155495526320-4466765987840000-5704134331965523-5704552115241624-5636235341580454-5361689686184832-5087103776777250-5774973132490464-6187924341995670-5019461744103936-4607240606605003-5570355474513000-4470365667209715-4745812576293312-4471020362075605-4540137698607984-5022035135734375-4472002524221440-4609940095673811-5573619195229512-4472984830193035-4748593054248000-4473639780749165-4542797545847088-5024977231572351-4474622326453760-4612640638998875-4819529547367920-5026448710290619-4957956123139584-4613991306071823-5647387748518000-3581532394038092-3719555849060352-4890885056892647-3444537321389200-4822705165241250-5374264737499008-4754505175381137-5237229501391392-6202436141069910-4755549000000000-4618044889241067-5583418005852648-5859571059097295-5308470395540928-5791482318310500-5240295944544416-6137111325433527-4896255982948352-4896614184424759-5586686826381000-4483471712481515-4759725826247232-4484127686297805-4553447323309104-5036757105521375-4485111766986240-4623453358978171-5589956922484392-5038230882919707-4555446007728000-3451347862613050-5660624454497136-5039704947779191-5040073508913152-6076149366375000-5869437099073960-5662694556308006-5317797134954304-4834714532717230-5802081661068000-5042653939993743-4490362629009920-5734266897583771-5734686150866232-5389617145994250-5459113888917824-4561112122885098-3524753395010472-6151489908666391-4492989596160000-4631573978738707-5599774866733128-4493974972922955-4770875984709696-4494631970798125-4564113732112176-5048555375190079-4495617587668480-4634282963523483-4842142033750000-5326745505285127-4981216948747776-5258335473846652-5258719742735264-6158687614482375-5190284542771200-4913828407665703-6229251717040080-5122203437260046-5330249772232000-4499890259148765-4569453177321648-5054461412904431-4500876644559360-4639704101624875-5609604300115176-4501863174104595-4779250021583808-4502520940548085-4572124460838000-5057416158266503-4503507710341120-4642416255353139-5612883332211144-4504494624296875-4782043543201344-5198253054264975-6169044149783128-5476293045747081-4783440712128000-4645129465807547-3813444448185240-5893935438096895-5408947477494912-5756095175997375-3537136025546856-3537394304920653-5341161763897344-6035259772953303-6105076298552000-5619855517642251-4995791845249536-3747117436093278-5135313594735216-6246107633913750-6177157358293504-4928204374596783-5692144491121744-4859502444530930-5345842887000000-5901685894030585-3541270004413608-5277571859979252-6180765510864896-4722727311818500-5695469179959312-4515030679382795-4793228515288128-5557771972642320-4724450934908000-3474114492531550-4933602582501888-6045841499601039-5768292665132152-4587169830927750-4796027480773824-4518326562659845-4588174027472112-5075168815635607-4519315640320000-4658711376175587-5632584362375688-4520304862311355-4798827535669056-4520964423828125-4590852601392816-5078131624822959-4521953886394880-4661430931309163-5635872342657000-5079613461729643-4592862215829888-3549288752081487-6263907569469360-5150699636017750-3619674527219712-4733765746768004-6265735113606480-5709197205826758-5500725249976000-5570760893297680-4596212876329008-5571573372096560-3621786766727168-4736528040406500-5781771947351288-5712528530848886-5503934853269568-5574011282475920-4598894577750000-5574824077276080-3623899827798016-4739291408423236-5715444503061648-3624692437541500-5437434999704448-5019536642176296-5786832086853896-5089994392535567-3486551644800000-5857833698327604-5788519455872824-5998180193326242-5510357804896576-5371246508868625-5301876429134496-6209228824397207-5372420922609664-5023928507746248-5652331438653000-5094447688954403-4815650754510912-3559653397680567-4606945940257584-3769594050656250-4537804927485440-5026857840880776-6214207552685928-4538796845592035-5027956634304000-3491890926637050-4609631814517488-3492399713774350-5099275023777792-5029788312477000-5798650558657048-4890784410834210-5450128160620416-6149310414215672-5870223841356000-5101875620553583-3494689867494400-5871506576548788-5802030217938872-5732543698169750-5453304534407808-6292732693713570-4754855382098656-3706260097590747-4965351488000000-5035652671939272-5665521763887048-5106335843287171-4826888048778816-5946599378660625-5317346564106016-3498509014837150-3498763723545600-4968606191355359-5738808012002000-6019188029016066-5529656637570112-5880062920250148-5880490955500896-5110798664776375-3500801838284800-5881775185886292-5812177074415256-4622067562626294-5532877483992000-6303736911317490-4763170083367264-3712740988098051-4553692967682560-4694148188796875-3503350594558800-6026201525711138-5536099580863808-5676667049411109-5887342344828000-3574717945198941-5818101533650944-4977292352939927-3785821729248816-6240049048105875-5048496846162432-4838494803834657-4768718599142496-3717065776350707-6242319257536000-4769759425315428-3858174294946840-5682451836448467-5402229868018368-5963934286395625-3578620854101736-5333234653392948-6245952737804288-4772535702164932-6176671875000000-3720311570621303-5475573713610624-5195152854294498-4774271422144352-3721393921787875-4985626085070336-6109591704138591-4564969405458280-6321186480328110-5057316891072000-4846947756718089-4777049449377504-3723559253857691-6253223927689216-4778091487354500-3864913789500280-5130167606424899-5552228830465728-5974351383789265-4779828554044000-5623736491640880-3655694440093696-4780870996112356-6328083322694160-5766006109093750-5555458435133504-5626189593674640-4641943773518832-5627007452851120-3657820667904000-4783651582590788-5839293179854744-5769359494199334-5558689291950016-5629461505930000-4644643231909296-5630279682152240-5560305189989888-4716044522778123-5701900933809000-3660745577068892-5491517332788864-5139870401395261-3591129251049384-6267327912516375-5281839802675200-5000504930260183-5705215831802952-4578592203503435-4860704793000000-4579257422603565-4650045287950128-5143605500734271-4580255372060160-4721529224990875-5708532014329896-4581253466493795-4863529962817728-4581918943330885-4652747886006000-5146594882715863-4582917279416320-4724273170036899-4936166218700080-5994351379124375-5642152147399680-4584581495130845-4655451531022512-5149585422727407-4585580217920000-4727018177983787-5715168233978088-4586579085742355-4869183586155456-4587245078203125-4658156223202416-5152577120993159-4588244187770880-4729764249037363-5718488271597000-4589243442399915-4872012040099392-5296049645477775-6285101737645656-5579315455359625-4873426677732864-4732511383403451-5721809594744232-6287382860468491-5086791223488000-5440435401541217-5370170075600288-6359873416254630-4876256774455296-6148769904060375-5725132203668616-5796233393291686-5513890351022976-5655682482523920-4666276584750000-5656503197324080-4879087966628352-4738008842896459-5728456098618984-4597242702901875-4880503973575104-4597909727209045-4668985467610992-5164555501083367-4598910384640000-4740759168435027-5731781279844168-4599911187244555-4883336809321536-4600578469638125-4671695398649136-5167552993983999-4601579514222080-4743510558109403-5735107747593000-4602580704007715-4886170741048512-4603248244537605-4674406378067184-5170551646484375-4604249676349440-4746263012125411-5738435502114312-4605251253391035-4889005768968000-4605919052107165-5810965292387376-4748328051235429-3685536696977408-4749016530688875-5741764543656936-6025745246546255-5459011967876544-5530309071055782-5388896859044000-6311139265412919-3687674479230976-5035458941707447-5886949066851672-4610595450816875-4894679114232384-4611263766055245-4682545608628272-5179554563826527-4612266360000000-4754526762281467-5748426488801448-4613269099258755-4897517432001216-4613937672833125-4685260783593456-5182557856968439-4614940654305280-4757283475722243-5751759392901000-4615943781119515-4900356846810432-4616612613079805-4687977007952304-5185562310831375-4617615982154240-4760041254533771-5755093585017192-4618619496598835-4903197358872000-4619288586994965-4690694281907568-5188567925639591-6041920757207040-4620626961640625-6256071083396288-4621296245896395-4906038968397888-4764179920771463-5831209600974000-5689396933279280-4907460184776192-4765560009092379-5761765834294824-4623974029211875-4908881675600064-4624643636629445-4696131979418352-5194582638988887-4625648168960000-4768320985251107-5765103891953928-4626652846744955-4911725480690496-4627322712748125-4698852403379376-5197591737978479-4628327632980480-4771083027603883-5768443238625000-4629332698695315-4914570383881152-4630002823334005-4701573877747824-5200601998810375-4631008131543040-4773846136356531-5771783874556872-4632013585262635-4917416385384000-4632683968586765-5844731894296496-4775919167869749-3706951731877888-4776610311714875-5775125799998376-4919907537824847-4991571651866240-4777992799435503-5848115730886000-5206626006898103-4636372233093120-4779375553884739-3780973553154472-4637378463046875-4923111684174144-4780758575088311-4709744605325232-6422843533071510-5352756734400000-6209646896824767-6138715589566448-5568074945595786-5497086892828608-4997713123138750-4855272413149408-3570311414415150-5070208826765312-5070575462734999-5785159315869000-5214162556365283-4928811378756672-4643418900260205-6429814108360560-5715803548990000-4644426149475840-5931003697249259-5931432485833336-4716901752716934-5646396625000000-6433068768705090-4860892211864544-3788910447637931-5219065211420672-4790447194795875-5791854778559496-6078311609821655-5149059621732864-3790553949267137-4720653626766000-5221706375055663-5937437696167424-6295569613757336-5938295914093752-5580970532738250-5581373840335488-4937725955743497-4723383511692912-5367869115101925-4652489387520000-4795989421471987-5798555405260488-4653497947973355-4940223962081856-4654170402578125-4726114448852016-5227746666203359-4655179205946880-4798762137085563-5801907655737000-4656188155078915-4943079857932992-4656860868818405-4728846438446064-5230768557792375-4657870060912640-4801535921157251-5805261197962632-4658879398798235-4945936854216000-4659552371722365-4731579480677808-5233791613690511-4660561952616960-4804310773892875-5808616032186216-4661571679330995-4948794951142848-5379513359411175-5810293933875000-5452027443743476-4663254881259520-5955047697408291-6027230386754976-5238328381107875-4951654148925504-5167316479369896-4737048723865392-5239841219311167-4665948847040000-4809863686179227-5815329577622568-4666959351635555-4954514447775936-4667633102413125-4739784925226736-5242867769482199-4668643850158080-4812641746141603-5818688289333000-4669654743806715-4957375847906112-4670328753968605-4742522180036784-5245895484859375-4671339890813440-4815420875591211-5822048294036712-4672351173590035-4960238349528000-4673025443186165-4745260488498288-5248924365666951-4674036969205760-4818201074733875-5825409591982536-5250439243177219-4747314911425152-5682802006938051-4747999850814000-5251954412129183-5971830955375104-6332036511227416-5972692484244472-5613296576150250-5613701439585408-4966324823738937-4750740267186672-5254985624470327-4679434240000000-4823764682921667-5832136068595848-4680446690609755-4968832465463616-4681121738808125-4753481737819056-5258018002914639-4682134432801280-4826548092378443-5835501247761000-4683147272838515-4971699375172032-4683822580670805-4756224262913904-5261051547686375-4684835664138240-4829332572351571-5838867721163592-4685848893677835-4974567387432000-4686524461193965-4758967842673968-5264086259009791-4687537934210560-4832118123046875-5842235489052456-5265604052198459-4761026219740032-5699214816393931-4761712477302000-5267122137109143-5700447049449472-4834904744670179-5917772509104528-6134718406444375-5196841795256832-5052849134329710-5486345768061472-3826279954206307-6425725502016000-6281779732181727-5848974909284328-6499329216723630-5705377757820736-4694636336723125-5922890951239152-5273197394532679-5418058821734400-5129465153853879-6430356099125000-5057947749221570-5780928076784640-6142678488926545-6070848906718176-5276236774305375-3614121081420800-6072160703313012-6000305177371896-6217631418859394-5639653211088000-4772357903793546-6074347450880352-3688262238483597-4701064872591360-4846061944559875-5931428245296272-3761664352574076-5642902795111296-5353908615176866-4920162131484000-6512448127923990-4848504867862016-5138337740263407-6513854771702160-5356221707218750-4994674362500544-3836765175053849-5357378503033648-6516199628085510-4706482926080000-6372312445333208-3765728380261536-5938691392236934-5721833985818816-4708176921118125-4780954473032496-3839527623774259-5433684822950400-5216712823135368-6448900734001000-6521829579213390-5652659036379264-5363164980527218-4928668388870112-5798850622190000-3769524112719872-4929732359879364-6307611373954104-6235558695138514-5583401901000000-4858634296271767-5511683159871008-6454935408097503-6455399769668096-5150183762911375-3917322946286064-3772508262652636-5006188351316928-4716313755648885-6530750298990000-3701024686929981-5878520815546368-6314420924306439-5951951213992208-6242739243275250-5589831304726592-4719028115672845-4791973137483312-5300593867551007-4720046269120000-4865628322640187-5882749764222888-4721064569004355-5011951975448256-4721743516953125-4794730446341616-5303643764453559-4722762060922880-4868427811453763-5886134383077000-4723780751357915-5014835445686592-4724459959689405-4797488812703664-5306694831047375-4725478894256640-4871228373871051-5889520299901032-5308220803048587-4799558281584000-3709016148433071-4945710304553184-5309747067556711-6037543566979072-6037977475195875-6038411404201688-6257116872816178-5675467317077376-4802663600641434-6112920187500000-3711682523075301-5313182232323584-4876832720340059-5896296028454184-6479111751504875-5241905208663552-3858901900729929-4805770258839792-5315855051218967-6044488593408000-6409074812279128-6045357096006424-5681587078591866-5681995219036032-5026741450676625-4808532857244336-5318910798820399-5173558798915072-6412758806045592-5903076951873000-4810260018762726-5029269387083712-6123028544381028-5540280834494624-6561330062343750-4739078690877440-6416444211270104-3791807491833504-5979818116115398-5761457972408000-5032520836195329-4814061229808688-5470916924676525-4741801777589760-4888054305578875-6201708162130760-5691387844771434-5618824705022144-4816481224636554-5546649277764000-6568872000900390-5036496732291072-6423819257174616-6424280385088192-6570758388138750-5622052368727872-4746229017957245-4819593838065072-5331145499594127-4747251080000000-4893671547641867-5916654391270248-4748273288760755-5040836461166016-4748954842783125-4822361731084656-5334207103500839-4749977296097280-4896481781754643-5920052001021000-4750999896157515-5043730998253632-5482709666609775-6506615618841816-5775949595451625-3655926581324800-5118664423985910-5923450911229992-4753727547156835-5046626643192000-4754409622992965-4827900695920368-5340333827339991-4755432859074560-4902105477171875-5926851122146056-4756456241958395-5049523396193088-4757138578776285-4830671768142000-5343398947720943-4758162206353920-4904918938887979-5124909683719280-5930677914487875-5125644753953920-4906326073337951-6591059864322480-6225336239181115-5786315618816000-6299478791223606-6373185480212856-4761916763766955-5494913290468800-5348765730107125-4909493109770312-6228907945955955-5056770127861248-4910549091364283-5937059561625000-6523903455606539-5278142927678976-3885578164546281-4838991346455024-5352601345400375-5059670760751104-4913365782536131-6453838494462656-5134103114194530-5721267774768000-6455226250913528-4988486862283104-3814998632777644-5943019894424064-5209687046163375-6530920752440744-5430592894140862-5064023789558208-4770799022464085-4844543035398000-5358742143209703-4771824608645120-4919002395776339-5947279716425544-4772850341796875-5066927195386944-4773534245553645-4847320471498032-5361814302594047-4774560223680000-4921822318256347-5950689039258408-4775586348805155-5069831710762176-4776270513893125-4850098968954096-5364887635930519-4777296884039680-4924643318250723-5954099664789000-5366424742900883-4852183538683008-5661286195869689-6029333928688688-5367962143443375-4780034589923840-5148098174889110-5074917283152648-4854616291516134-5517004425000000-4928876839031967-4855659148745328-5371037825356871-3826218673225728-6181257288580500-3973949883292464-4783800643026795-5078551916286528-4931700533712743-4858440831486000-3828136485733612-5963485604064768-5227626981520287-6553409914135016-5449292640454750-5081460871967424-4787226043743845-4861223576393712-5377192713282807-4788253982720000-4935938097488387-5967755198865288-4789282068835355-5084370938254656-4789967541328125-4864007383671216-5380271919743759-4790995872698880-4938764488141963-5971172341617000-4792024351236915-5087282115360192-4792710085360405-4866792253521264-5383352301502375-4793738809200640-4941591957544851-5974590788559432-5384892933188387-4868881603344000-5680768200847817-6050081988848816-5386433858782911-6567491823474176-5239609789837375-3690129962926800-6642709000661070-5757426211944576-5019653620347732-5020012611500000-6275464524709835-5094564919345152-4947250133421859-5981431596011784-6572660240239875-5317588501258752-3914615875408129-4875153240534192-5392600500806767-5097479985984000-4950080840307627-6428176472354136-6059174212354454-5837914448698176-5838331810262875-3769319098451496-6578301604847607-4804721024430080-5322532972047048-6062206976586000-4805751466204715-5101854670581312-4806438509230605-4880732548455984-5398771847609375-4807469196541440-4955745493002811-5991702594841512-4808500031188035-5104772517048000-4809187336144165-4883523797999088-5401859285863351-4810218416373760-4958579439223875-5995128872153736-4811249643967195-5107691475816768-4811937210903485-4886316111534000-5404947900984783-4812968684126720-4961414465635019-5183937677504880-5998984995139875-5184678381115520-4962832383976191-6074348153327344-3778218114425949-6149304000000000-5260623740946071-6076083929328656-6372933433526322-5187641901124480-5039783494208500-6151939792505928-5411128662727039-4818472364193280-4967087759850843-4077751293055000-6302429316023135-5338909594492416-4820193124252805-6081293241297008-5414220809796375-5266262002466816-5266638029742823-6083030340046224-4822258577035835-5119378438152000-4822947192391965-4897496009646768-5417314134630191-4823980238338560-4972765377296875-6012279852679656-4825013431789395-5122302961610688-4825702309375285-4900293646182000-5420408637452743-4826735748689920-4975605807745779-6015713969319624-4827769335536875-5125228598643264-4828458475402445-4903092347925552-5423504318488287-4829492308160000-4978447319619707-5201734043666160-6019578913334067-5202476441482880-4979868481155375-6095199294493552-3791187124328973-4014484546387968-5278680355699079-6319997785625000-6097374028409382-5874718462724032-6693194707458930-5057441218995552-6322252511891875-5132547564501504-4984133588465931-6026024164788072-6621659346212731-5357230114752000-3943797896867993-4911494846433648-5432798433115431-5135477100711936-6177898547843875-3870766699461792-4913246574374358-5881426676136128-4988401130372103-4914297811038000-5435898829245503-4840529041221120-4989824185482139-6032904168879144-4841564596171875-5139873494833344-4842255048184645-4917101841864432-5439000404709847-4843290849280000-4992671107568547-6036346133804808-4844326798076155-5142805817760576-4845017512668125-4919906939115696-5442103159732719-4846053707655680-4995519112314923-6039789407649000-4847090050372115-5145739255745472-5593593493376775-4848126540827960-5668982728560500-5147206392950784-4998368199927091-6490880952931704-5521372648326126-5894858419000000-5223664484941070-5074778525634144-6343925175271795-5150141503919616-5001218370610875-6046679883088296-6644356214114827-5375592498507264-3957315293954537-4928328631446000-5451418504395063-5153077730476032-5004069624572099-6498284647046328-4930084359477750-5901581952334784-5005495657846071-4931137996424112-5454525979894607-4857115648320000-5006921962016587-6053575597187688-4858153567466355-5157484162501056-4858845595703125-4933948428840816-5457634636073959-4859883761274880-5009775383150163-6057025419357000-4860922074715915-5160423178953792-4861614365831405-4936759928898864-5460744473157375-4862652925744640-5012629888178651-6060476551937832-4863691633555235-5163363311736000-5612750985691575-6660938669928632-6511718188344009-4865423141928960-6213213352485875-4042619330119344-4866462244183995-5166304561059648-6289861925251716-5691232516500000-6740097153205590-4868194410027520-6591255362170776-3895109913149728-6142725851657750-5918413148460864-5169614801428617-4945200836948592-5470081072074567-4870966730240000-5021199908691827-6070837814637768-4872006621608555-5172190410179136-4872699964738125-4948016609599536-5473195635016799-4873740102766080-5024058751358203-6074294191353000-4874780388803715-5175135010398912-4875473995061605-6151035499609968-5026203595328125-6527027137216512-5101947315947844-6152785853547664-6678498670219171-5403214672704000-5178449021286129-5103762008374624-3978215072351811-6680874007609856-5104851030350500-4129217264197080-6081643347289443-5781726411127744-6382879125767865-3829999808409000-5707856543614196-6684675718828032-5107755846287876-6234909987302872-3981611143938375-5860146235751808-5484885775294229-5109571915714656-3982743597149747-5636358600000000-6538640786254287-6539105618537496-4961053462162182-5186924587290816-5187293299793625-6315414644936544-3834631444030893-5639564719718400-6617559602308952-6618029955768000-5565557096954894-5791599388353856-5265464551031790-6319006520092896-6394687214511875-3912321958152192-5116476905397284-6245555313891256-6170746130335638-5945409574792000-3913712231512772-6172061667453936-6021951435485360-5194302157664256-5420526490125000-3764521955958800-6174254644788806-5421681924217344-5045534667524263-4970581279422000-5498154710304543-4067417068803072-5348280123496927-6403325405856840-5876410123574250-5801483598699712-5274450622423710-5124115970518496-5501279919548087-4898747842560000-5049837181635907-6105460636155528-4899791683988955-5201686720332096-4900487660648125-4976233145593776-5504406312835279-4901531749204480-5052706882804683-6108930140625000-4902575986051315-5204642503983552-4903272226338005-6186105699051248-5054859872002125-6564239289249792-6338336184481812-6338786179951008-6716571684618131-5434016772672000-6264658481123223-5132855636753504-4000892062728691-4076669957170176-5058449546294875-4077248728163184-6720386924886507-5437103405243904-5210927261626521-5135771065644000-4003164489831083-4078985369812992-5061322509027939-4079564359928496-5213146618734375-5289074784040320-6725158006606037-5743239080440352-4005437777232867-3930142338304000-6575897024841567-6425182848230280-6198851490093334-5594482403610496-4914421037443125-5595276285034544-4083329131230762-6730408804036608-5369583440633399-6655730487032000-4008849321753063-5597658379920512-5522406063326261-4993214446980144-5523189550033375-3934605872617472-5145618788180964-6205451004942544-3935443161358748-5222400723000000-4920001774798565-4996048414342128-5526324237905271-4921048633180160-5072825238015875-6133253481877896-4922095640048795-5225364347665728-4922793727125885-4998883453806000-5529460111614863-4923840981496320-5075703640805899-6136733506466664-4924888384381875-5228329093324224-4925586735485845-5001719565574512-5532597171386407-4926634385920000-5078583132224787-6140214847190088-5534166146115491-5003847353222784-5989878203171875-5004556749850416-5535735417444159-4929428846650880-6674161294001432-6598786208319000-6523400393759426-5841132899014336-6448460819903145-5159134249467872-5614749847957750-4932224363888640-5084345381772451-6147181478036232-4933272955274235-5237230058376000-4933972098758365-5010234336735408-5542015469315311-4935020937832960-5087228140312875-6150666768656616-4936069925534995-5240199290125248-4936769333245685-5013074739750000-5545157275577223-4937818568683520-5090111988305459-6154153376406984-4938867952776875-5243169643927104-4939567624764045-6231895904830384-5092275589376693-3952493805312000-5092996925956027-6157641301536168-3953333629759644-5246141119993536-5094439803467375-5627093161808304-6083774739589040-5703942694502400-6617042044058583-3803167002650000-6237635518126502-5933780725302144-5021246877841722-6391130313928416-4032784388671875-4946217804669440-5098770071054411-6240727538320464-5860610232857303-5480439067584000-6774911185718349-5176703059353824-3958935499786124-6167239890407424-5177802432330500-3883626693431256-5559310098386019-5407382929810112-3808285665493450-5027292858654000-3808824739123550-5561277670721024-5485483963616904-6323991518615672-5333864254591250-5943869327380608-6706378386820024-6401995987698528-5564033051845527-3811251200000000-6403355062204884-6327572318711064-6251778808755814-5947234734110592-6862679422211250-5185502401640288-4041927509236579-5415040665073152-5491697315322888-6178596531201000-5568758679494763-5263993555818432-6179907809258757-5798842168899744-3891603542992125-5723351178547200-5418489003325623-3816107212931600-5648238126208366-5266972893672000-4045931966176433-5649436592423152-6871422306687030-3817726800051200-6643314389859375-6185592158066856-6873366177763470-5957338575766656-4964799847773285-6263728826374000-5576640670276343-5577034964926464-5501026137365064-3973244215330208-6571599241007250-5884289717294912-6496103711533505-6420132799220448-5579795547887887-3822047939200000-6421494439258164-6345496595835704-5046173240612262-6040543398486336-6882118134401250-5200190121012448-4053375830177019-4971472650260480-5124803216404883-3824750306250000-6579035454347186-6043959673303232-6197409248787837-6427397104183776-3902624006665125-6351778080649728-5433832663677503-4133066166139248-6812386675263531-5511533683392000-5282259645654489-5206072965748704-4057961204582891-6814793652207616-5207176492834500-4211984416788280-6203542549986603-5897611375596864-6510810131055265-3906762038373000-5822252722436436-6818645994486272-6436030580936628-3984490830966048-5670637458218750-6054216225667904-6131284894826640-5211960245555936-4062550035816667-5442668370432000-6669656185045767-6363454690745944-5673842188851438-6057637653236416-5674643560125250-5214905549133408-6902568251577270-4985540193287680-6366600836622027-3988995412948000-5677048126681054-6061060369599552-5064028199812362-6445581835541856-3990403790743500-4144173410156544-5449205262720583-6831176132889288-6601377748464914-5987718750000000-5373973071425070-5220799484680544-6603241886187322-3992939706083328-5221905091758500-6374245793487928-6297892124823126-6067909669680448-3994349012067908-6299225670582000-6146019734306480-5301316116959232-5532198501578184-3842075624637200-6301448665151750-5533369750374912-5533760203373736-5072971451844912-5611409791758207-4151198754432000-5458442724060031-6535216433755080-5997445249354026-5920972630944448-5383082141718750-5229648712115168-5614577767854359-4999634248826880-5153832692126563-6231192484437000-5000692372473915-5308801735900992-5001397871173405-5078700655334064-5617746936067375-5002456243632640-5156741654326251-6234709454854632-5003514765393235-5311797955416000-5004220529517365-6313461873695216-5158924094159469-6699373832491008-5236661437946500-6315242905761552-6854832332117747-5545873358682624-6393610349597367-5238507933500000-4083242589538003-4160578224632832-5162562862107259-4161164910163056-6858699747244875-5549002201124352-5318168664605817-5241463229147616-4085546089992587-4162925297664000-5165475108100227-4163512203809712-5320418365780743-5397906325150080-5166931641712375-5090171999714736-5630435534573199-5013754841838080-5168388449102603-6248790570033000-5014814956801715-5323794106994112-5015521783123605-5093042532284784-5633610666734375-5016582147133440-5171302885320211-6252314158448712-5017642660585035-5326795964328000-5018349752581165-5095914143850288-5636786992357951-5019410515125760-5174218416958875-6255839071210536-5020471427140195-5329798949861568-5793667828685175-6257602024299000-5871743875161396-5022239946014720-5177135044224419-3863805746029200-5718835276820750-6105673073054144-6183395544813840-5256256380681056-4019773256085548-6725863512000000-6726337175478687-6340212535839056-5412757699315890-5954452747694528-5181512039873375-5259218347109088-5723670024468182-5027901997281280-5182971586459443-6266421758061000-5028964105433515-5338814677780032-5029672260625805-5107411384121904-5649504233961375-5030734618058240-5185891501840571-6269951970695592-5031797125072835-5341822178232000-5032505546188965-5110288393705968-5652686530260791-5033568302530560-5188812513671875-6273483508920456-5034631208482395-5344830807943488-5035339895572285-6352721994654000-5191003992214597-4029122440718336-5191734622159179-6277016372984424-4029973084689500-5347840567126464-5038175308975445-5116045653712752-4031107462882188-6899880905216000-5504786653031191-3954420724937688-6978880477953630-6126337174252736-6049214143917750-5118925904540976-5662240588903679-5507498116127232-5507885540666879-6827155247000000-5120726610149766-5431455699026560-5043849328640005-6363457475265648-6208687852910000-5355369907912704-6442419775493619-6520497845762208-5045978183816635-5356876623624000-5046687935300765-5124689648860848-5668615938362031-5047752687311360-5203434026784875-6291161092607976-5048817589072595-5359890902812608-5049527606780085-5127573142758000-5671805406872903-5050592758149120-5206361621639539-6294700589599944-5051658059296875-5362906312532544-5052368343277645-5130457718083632-5674996071537247-5053433894080000-5209290314385147-5442924678699760-6920776368112843-5443689850865280-5055210144993125-5133343375040496-4122520005845259-5367431547322368-6845901033731672-6846382145592000-5135147459994486-6147047846793152-5914031214178332-3968905087960584-6926615179861375-5214784573158912-5526503292543983-6383170589336144-6383619087164118-5371959327000000-5060896944876565-5139117934658928-5684575244693671-5061963694428160-5218082982025875-6308871853377096-5063030593870795-5374979260964928-5063741943443885-5142006837726000-5687770696214463-5064809092728320-5221016068393499-6312417989517864-5065876391931875-5378000326521024-5066588008027845-5144896823235312-5690967345010007-5067655557120000-5223950253681187-6315965454234888-5692566118455891-5147065022841984-6161313476421875-5147787891389616-5694165191304559-6162611445175808-5226885538094763-6397532942194000-6632054628830735-5618134803396096-5462458977278590-5931086109420704-4136442527014875-6946589230198784-6790962794031111-6323064370393032-7026120254647710-6167805143096000-5075132599876365-6402924373764016-5700564477287711-6794300266910208-5310860291766500-4061531145200672-5155382097803718-6171269229026368-6952930474101661-6406520343750000-6094434815878578-5391609130647552-5313842734240836-4141962172884392-5080121378726875-6096573414142848-6644167967627905-5315707327678816-7035988630633110-6489200335808000-6802410110266047-3987899487331128-5786769918182078-5396150495142336-4145160000497625-5787987900621104-7039938566849670-6962205385986048-6806228739106983-4068376100516000-6415966170160902-6181669268608192-6573375189689028-5321676957736032-5713377429109375-5400694409055744-5244520337746011-3914095634747600-5793267799440286-6185138543208000-6263870677243280-5324663448032224-4072086993659724-6813392519528448-6813870283536375-6422718870459792-5483193235618210-6031935467086144-5248935226609623-6581216009676000-5719791098535983-3917939802854400-6582600330705588-6504692030681272-6740273874449250-6113700213998208-5173493595307818-6584907963781728-3998260087028349-5096178880000000-5253352592442867-6429926971395856-6351958416965787-6195554154622656-6980290720101125-5961115460438816-7059710423874870-5726610879602176-5648559989841288-6433533043362000-6669373551907135-5649747604655616-5493195082325790-5336620582541792-4081231112055500-6514729195143168-5651727332580936-3925085648371600-5181476073791094-5417377249992000-6674048237061185-5967802385314848-4162048495475651-5104756699394560-5654895859125000-6912023565565888-5498585726429810-6127424725309056-4085235964617028-6442554121334000-6285858923375280-5736248031268864-5579481325671127-3929487407485200-6444810707695750-5659254516460032-4244738151793662-5188376636815152-7075554537214710-5739462816192000-6919289012180248-6919773556228544-6369783044939667-5662425855426048-6685276392595625-6607088687785824-4090388909329996-4248008976826368-5585736202909479-7002328572125000-5193101602989366-5429531779820352-5429911901528913-6610790310756576-4013975102995125-6533005028515328-5588865393772303-5195647003318992-7085469136120110-5668772087232000-5432953513913289-5354589827259104-4173722420371291-7009194240700416-5355714242394500-4332130875484280-5750321582570499-6223386270286528-6696517134277265-5357588617404000-6303486523384880-6225128539668992-5279908842705339-6383620044293544-4098413210937500-6148049980595328-5754346820949709-4020441395227752-7016555292652071-5913241190400000-5598259977952711-6387194132790408-5125884743160155-5441704476154176-5126601967768125-5205836922162096-5758373937341519-5127677930119680-5285822359771723-6390769555089000-5128754043008115-5444750490343872-5129471535237205-5208750772696944-5761596982918375-5130547899043840-5288780773374291-5525978293835440-6079001228199823-5684658408000000-5685055945826472-6475099821934256-6317612307866160-5449321642569216-5686646282469000-3949336050670800-4186588927582079-5529843695411840-4108171105762308-6478722762022000-6321147048322480-5768449947500544-5610802458717287-3951545572397200-4188931129776375-5532937314190720-4110469329679076-5849922950502768-5929390412816925-5139164230720000-6958124060444568-6721385060723080-5219322595374822-5456945913886656-6564611116859375-6011389327906976-4192446070755099-4271847355588608-6882901725004743-6092189315289000-5222241475472406-5539128012709760-5143835435715405-6489599690193328-6331759180030000-5461523888408064-6570118212329099-6649740857564448-5145992330831235-5463050448696000-5146711429835365-5226256712218608-5780960515313911-5147790203944960-5306554438927875-6415834878529416-5148869128787995-5466104422602048-5149588495762685-5229178176750000-5784191982628623-5150667671851520-5309520582430859-6419420980199784-5151746998701875-5469159534458304-5152466633697045-5232100729806192-5787424653945767-5153546211840000-5312487831028627-5550748015478960-7057872441980883-5551523259614080-5155345843838125-5235024371589936-4124852651143276-6584359129248256-6902159523711183-6823300722278000-6189007146239658-6110087453781696-5237583451406922-6666480675659616-7063788099234375-5794298079182848-5318425644331811-6430187302453512-5160387042183035-5478331699848000-5161107481539165-5240874922151088-5797129894154351-5162188266293760-5321396209448875-6433778749781736-5163269201922195-5481391365624768-5163989909498485-5243801831334000-5800367383723783-5165071096606720-5324367880484019-6437371534146504-5166152434616875-5484452170411584-5166873410463245-5246729830055472-5803606078416927-6758095000000000-5168315563385065-6997592317408704-5169036740466755-5487514114420416-5726501152209000-6522303504825712-5806845978458039-3977569212825600-6682782409777236-6603686080783000-6842850804488466-6286313023640512-6127593225846169-6048435929792544-7083530828525375-6128875447163392-5731296212585736-6448157911948392-5811708089037707-5493641420952000-4060800738811311-5255520365478768-4300271059671018-5176613150658560-5734494406125000-4141868079521952-7089460812400787-5656031618214592-6612441635611287-6533229142414000-6294647398904489-6454455526430208-5658003597702527-3984787358165200-6535506851565750-6137428160760512-5898718758222322-4065616588874472-4225347051220907-5501306966016000-6617975445187443-4305970888024752-6778389566043095-6140851472847168-6141279476341625-6061945064661536-4307471679500442-5823469392841216-7020561930505112-7180620536250000-5266155355668966-5505909714005952-5346690685161759-5267256345216624-4150248720351500-6624897047728128-6944653052638791-6865307772995632-6227108335841562-6147701915432000-5269825917574746-6707518449603552-7107270619343183-5510515028583936-6629052324868875-4313177867420784-6789734412449855-6151129046403264-6231447884805702-6072090105668000-7111232400575079-4155166761680896-5673795936931207-6473372969547144-5834433826421875-5515122910465344-6794465165290305-5435950689117536-4317085003430106-5996368958400000-5676957926931311-3998136097368400-5917653478706238-5518196258352576-4238909664873625-5918889757284144-7199150945355270-5199748817735680-7040150085229272-4160378332708000-6561053372210822-6321454914140352-5201559189148205-5281950872522544-4241861894365875-6003052631155200-5763331704504456-7124614281290088-7205167646936910-6244913298000000-5925073732988274-5445041328050144-6406376852298160-4164434788220928-5446178370018500-6648003908706328-6568364585975526-6328498971341248-4165884161089508-6569736042942000-6409944622130480-5849481501407744-5689617634716687-4007051798277200-4247770464931375-5610653256942720-4168203857095876-7214700945512880-4168783915616268-5692389452288000-7055846816529368-6655409435703384-5934151353138158-6335548259439296-5533965087890625-5454142096297568-7219219652044470-5374681819421184-5695954540333919-6498653676057000-6499105714384371-6178591957689536-6339515783457323-6099198871487904-4012909924268750-5538200854462464-5538586031292357-4415121991723960-6502722775664139-6182030558088000-6824794028438785-5460214905311584-6424228947616560-4176039188359168-5461354058606500-7228765338852240-6586666378476886-6346132003765568-4177491252321348-7230776028750000-5945718091124374-5222953315307520-6669773290433891-7072058489431232-5304412604625750-6269287060952448-5465912256180724-6109385422823712-7235301444181110-5225858722240000-5387028803812827-6513129301929768-5226948527563555-5548992557651136-5227675148613125-5308469845687536-5871897447707799-5228765206446080-5390024857119203-6516751564053000-5229855415798715-5552078474286912-5230582306216605-5311421865553584-5875162711859375-6841418235240960-6519922144884873-4266418320414856-4186210705265628-5555165534808000-4347822911332014-6602708308014576-4187374214893324-5878837580705792-7087310239383000-7087802596059328-6524453329756443-5799916945488384-4350239879054526-5317329188094000-4028559500843550-5882105416973824-7091249731285016-7091742270393792-6528079788829875-5803140613934592-6528986613516213-6126388201957792-4272646378708747-5885374464000000-7095190682764888-6692519574547864-6289792495461306-6048297371524800-4355076501366750-5323240889063856-4033038269537150-5888644722008576-5808381622439688-4356588680694000-7180802094660859-5809591533897216-5890689248315581-5487598332935392-4277395632058875-4358403757891584-5408024507853971-4359008895636528-6861879190159015-6216486757096000-6297657466063158-6136604995855648-7186786234620463-4199312621058048-5572551574078125-4442197229094680-5896416439480059-5573711931396288-4119986034797439-5978433823758000-5978848714258934-6060064483737600-6787743222148308-7192274615984456-5899690786209875-5819276874834432-5900509562252869-5496746445894496-4284526108828707-5901737868352000-7034066009847327-6872840148921480-4285715291505071-6388584850991936-5418542786385375-5985074375369264-6470799538417840-6066795395174400-5743631376274679-7038459046875000-5663520795957570-6473044161520640-6878086470198545-4127138124504264-4208354269931500-5260807689879040-5423054791804731-6880472044008520-6638092193484278-6395678680104000-4210105764206212-6639473338979696-6477984159395760-5587648785678336-5830994349693000-4049582417254800-6641775673843366-5832207399227904-4374458839841886-6643157330206000-5914440347780303-5752799712235008-7130724971692696-6726036420110392-6645460516593750-6321729938828928-5430580365760511-6160488341192352-7214756182390871-5918131575296000-5837465891306952-6648685871784976-6892408187425895-5838679838181888-6812265278626500-4136304870960456-4217701188526956-5434722397479424-5759582575606399-7058005786143000-6328305788311338-6247606592387776-5274319093859205-6005025530557616-7303915520763750-7223261395451904-5762776355294183-6656062030726544-5682397872192930-6251070749000000-6901010752991585-5521191106453344-6495968974330160-6415213782918656-5441127861040875-6578535665425896-4223550034883036-6335763928580736-5930035977341917-4143188831241000-7230771543941559-6093768881049600-5769167456236087-6582182135294664-5282363858256875-5607820783516224-5283095605840845-5364745528126512-5934144642045407-5284193353920000-5447161128465787-6585829952402088-5285291254052355-5610928470219456-5286023271953125-5367718372498416-5937432939895159-5287121425530880-5450179433919363-5694611582590000-6264506450794207-5858125883306496-5858531467706664-6672678330663728-6510380769630000-5615592152676864-5453198854141451-7081509601871064-6674988334911958-6349818672912000-5698949683057470-5536505760322784-4071241903730350-5781563657662464-7166377705399000-7003990223573296-6352895916347994-6271882583134784-5376271417278234-6843000811500000-7250824052357039-5621814414884352-6762940392482091-4400289798796656-6926861391929375-6275355706775232-7009323826145198-5542639542632416-4157267290781229-5461885898752000-5788369107296551-4158130271810328-5381482064187702-5626484126665536-5463775606692375-7339907821670640-4159568838905013-6443699427030528-5791573518881039-6689322261746000-6934533219073935-5874363865069056-5629988106992073-6201575248139424-4080265917968750-5304712572989440-5468312683983411-6693024667784464-4244650650704828-6367416312816000-5878021541424552-6858166050873312-5960485044590751-4082806322355200-6859588939696500-6778395859705848-7023883775897858-6370939737791616-5391167910009354-6861960858396000-4166478579699021-5310584947998720-5474366026503619-6700433577772688-7272924593083875-6374464462324608-5721068719224110-5557993814933856-7356676810517910-5967494792000000-7112437468487487-6949413499868680-5396388175980582-6377990486654592-5478908963893375-6051750544788784-6542885211211440-6134378832998400-5807613317351959-7280469120069000-5726607406487170-6545146472842240-6954698711909745-5564143454852192-5973684425381375-5974097219716608-7202149080958744-4092412921531600-5402358319317894-6466906005352000-6467352830889419-6222187031046048-4093826926398350-7287515384283136-6878579600812500-6879054815873184-5323445874206395-5651432934573888-6552838659407120-5570297629276000-4096090011599550-5816849597347328-7128181288945119-6800918546651832-5408332864299750-5654556711344064-5327124234539445-5409453581642352-5983596738786887-5328228072960000-5492552854613107-6640709046857928-5329332063854955-5657681638994496-5330068142498125-5412442918115376-5986903278320479-5331172387540480-5495587903205883-6644378453625000-5988557004788123-5414685643052928-4184364151954527-6071849520009136-6154326406603125-5662371188834304-5498624069654531-6976347938372520-5417302938404214-6402709071408000-5418050891957946-6896177138518752-5993520011330831-6650803167588864-6815490931278875-7062321403407856-5420295165685158-6077720092343168-5913865521411048-6242844434148000-6654017077064991-5668627952013312-5833338548402007-6162402577531800-5751972645781250-6574136652334080-7067684574420638-6164103723851400-4109686039561950-5507359276864000-5754354469754870-6659069597869608-5344066517373155-5673323547869376-5344803952093125-5427406120966896-6003454249068119-5345910231367680-5510779918124323-6662745764469000-5347016663285115-5676455385252672-5347754369370205-5430402067053744-6006768099403375-5348861055715840-5513821676939691-5761106541539440-6337654275298423-5926527000000000-5926935735396072-6750586779804656-6586392513962160-5681155302076416-5516864554845875-6176020514866200-6423504254297754-6176872301438400-6589118105698320-5518766921917000-7001903478555635-5684290020767232-6838095668955851-4449188254360176-6674242504885875-6345087703731392-6592753397553040-5604226717572576-4121039018367950-6017131741184000-7254028699258968-6842339613829784-7090141799513362-6431036990182272-5359566896328125-6102081346432624-4205778362613333-5690562917042688-7258029726190232-7258529957976000-7424008172126190-6352089179187136-4290018194822724-7425543185757360-6105867365497750-5363631466352640-6849416756777699-7262532639724736-5447274808788054-6438132001392000-5613117200880628-6273916186982688-7430149496160630-5366588807656960-5532095737942875-6688516820562216-5367698090840995-5698410524998848-5368437697879685-5451404565750000-6029999203360023-5369547235819520-5535145334716259-6692203815832584-5370656926626875-5701551587229504-5371396805430045-5454409336009392-6033322813989167-7025585751360000-6695431047965961-4381262775157384-6034985077181931-5704693803519936-4464850430904750-6780424958130672-4382771578358939-6864058312953856-5872068659619639-6865003645319000-4383978870295783-5790559451967360-4301854625822884-6784160900904368-6039973698609375-5378429043453440-5544300849049211-7282568122416576-5379539957580035-5710981699128000-5959695491419752-4221741573201768-4304817131486924-4139532170035200-5878540298090375-6872569429066648-5382503143095195-5714127378869568-6542712071492051-5466439458414000-6046629469207183-6544063065124352-5550410130673419-4556620388572120-6048294175500875-5717274213518784-7374962619808397-4226392988922792-4226683815790749-5718848064000000-7211217633939687-6963034031789472-6466119333743706-6549468899416256-6467009146269750-6964950551077344-6053290127576639-4146374370585600-6966388171304436-7464500809290000-6469679073634218-6553074442357312-5475097026128202-5641397093248992-4231338860302125-5891092625391616-5891497836394023-6721748568227592-7386132957163651-6556681308312000-6142123888732514-5644502022093664-7471178230083030-7388673242241536-6974058820312500-6974538422743584-5397335393637395-5729873105431488-6643787963775120-5647608089996000-4152938550429550-5897578231369728-7227106835990919-6895300128620632-5483386726809750-5733025717798464-5401047708930445-5484517788424752-6066626114806687-5402161735360000-5568764899589307-6732850228988328-5403275914965955-5736179486344896-5404018786473125-5487534713108976-6069963169274679-5405133221396480-5571827956326083-6736553497125000-6071632155311923-5489798132531328-4408777238922081-5656933130137952-6073301447255375-5408105796887040-5574892136064331-6740258122951272-5409220793611635-5742490492824000-5409964209895765-5493571881172848-6076640948973031-5411079462031360-5577957439009875-6743964106715976-5412194867427595-5745647731180608-5412938556175085-6829099306766000-5580257153447637-7246503336638976-5664322729030756-6830976034453968-6748134961921875-6498650403942528-6749062052108373-6999508059747168-6083323624516247-5417030062080000-6917605783190003-4500920099370672-5418146285044155-5751965679187776-5835728251088750-5669382476474208-4335707856672556-6920932012043776-6004112334607368-4169808770450000-6838955963046422-5755126389262272-5421868135681205-5505659497759344-6090011197698375-5422985023139840-5590229886981491-6758801626135752-5424102063971435-5758288257000000-5424846843071565-5508684169850928-6093356821464671-5425964139548160-5593300809050875-6762514403325096-5427081589425795-5761451282612928-5427826641238885-5511709949526000-6096703670313463-5428944346808320-5596372855562499-6766228539945864-6098377554213875-5513980011255936-4261095139223463-6851642736863024-6100051744469007-5431925645120000-7354496273903768-7271421372265176-6853993859873494-6603691070386496-6687740936250000-6855404791816432-6103401044155559-5434908034682880-6940435623687587-4515773928318000-5436026712147915-5770947308822592-6775055064220797-6357277865788704-4266360685609125-6274490210419200-5940258176275263-4183567351163600-6861521067778358-5774114968056000-5439756745671365-5523824148116208-6110103321018711-5440876088360960-5608672290147875-6781098685719816-5441995584591995-5777283786224448-5442742000718685-5526855468750000-6113456298643823-5443861752875520-5611749961958059-6784819623230184-5444981658601875-5780453763539904-5445728347741045-5529887898183792-6116810502696967-5446848509440000-5614828759445427-6788541921664968-6118488064704131-5532162948031104-4275146232828375-6874235724285872-6120165933402399-5952898175939072-5701758066141412-4192756531650000-6792731134443891-5954530448531008-5619449066771439-5535956084262384-6123522590984375-4194480999628800-5704885101413444-6795990602303112-6796456325669259-6629096834008000-6965224572928903-4280130059196168-4280423346014037-5455815333429760-7386840715023000-7219452601362416-6548324253463434-6464814285150144-5541649038952554-7053491082876000-7473853743877719-6130659562983424-5627155210283219-6803444729624904-5459928414516875-5796321044741184-5460676469467245-5545066684449072-6133599927232127-5461798680000000-5630239639243867-6807173836414248-5462921044270755-5799497981390016-5463669372533125-5548105770940656-6136961494562839-5464791993057280-5633325195116643-6810904305621000-5465914767347515-5802676078669632-5466663368971805-5551145967651504-6140324289891375-7150182214812160-6814169583980553-4458959447989896-7151650994392015-6394855153568000-5637955642336287-6900656917156336-7153609680035195-6144108902756352-5807842962703125-5639885743986392-5892821301519810-6145791451967296-4630707774648395-6315033741525000-6904909484465662-6147474308324864-7242725699386182-6064092346874688-7243717151877250-6233392505718144-5896855914407710-6992464808387176-7161447998891115-5813808562176000-6993900469002643-6573030929687664-6236379141059918-6321087041668800-5900084930328750-6996293673358088-7249667766952378-5816991884917248-7250659852858214-5649156363875000-6577079747475978-6324547806465600-4638319026631235-5650702454190888-6241501306601750-5482774840791040-7001560644534819-4555543830374448-5483900076770635-5821769047464000-6834718090596861-6413260545674528-4219538946832350-7342499933219328-7343002121847375-6921463854443472-5908970801675410-6500312408438464-5656502805261903-5741320825004000-6248335222433014-5488777878405120-5658050235634339-6840797136161544-5489903935546875-5828142665050944-5490654725863645-5575507533562032-6167270887352047-5491781039680000-5661145942978347-6844539878322408-5492907507515155-5831331217546176-5493658571643125-5578557731370096-6170644744752519-5494785296199680-5664242779292723-6848283985389000-5495912174803115-5834520932791872-5496663512792205-6934726384800688-5666566147539125-7358581329080832-6090276621259656-6852029457610152-7190892687644415-6514547963000000-7107265263982884-5753893629502944-4315715118841677-6347073572044800-6008973561426375-6855776295234696-7194824733409655-6772062437544960-5502676681997885-5587714999086000-6180773699293263-5503804639224320-5673540064116299-6859524498511464-5504932750581875-5844097057151424-5505684910453845-5590769647097712-6184152479000807-5506813278720000-5676641418370387-6863274067689288-5507941801145355-5847291425518656-6356185655859375-7543188807983064-6696096804079657-7035620156924416-7036100655489387-7036581175931000-5595735824150406-6698383618231872-7631591062251330-5766484775906272-4494772983544875-6191336473919488-5682847517082851-6870777304743432-6871246438546539-5938519648880000-6872184770216301-6448416068819488-4327522006823157-6364437433228800-6025412098487375-4243537637726800-6959876824408086-5856881514330048-5517728787957685-5602999371750000-6452379085890676-6198102961270784-6113614714860744-7642540009319760-4500914082070375-6624438870411648-6879694499067933-4331955135469512-4247304691153950-6031584270656000-7391318918003247-6882042410803368-6287727064643678-6543081392951488-5863680834341625-5609120916477936-6204451018980599-7564846843035648-5695273281088003-7565879210797000-5951097529132770-6631675398351744-6462073295832092-4336687141935624-7568460541109375-5697993829217792-6038584492924143-6974615605942864-6975091396624598-5869684602648000-6210379782095293-5615246918303088-4339350409297437-7573108415123456-7403431143606375-7063525251148248-5617162208182998-6638917194489216-7150090749536196-4341422593149000-4256586934563550-6044765655771648-7407471490686159-6897081696894504-6301467284190750-6557379298619072-5535827517218245-6302756455071408-6814255370559920-5536960000000000-7070754074956083-7156431788352672-6645711164666106-6731371494853056-6646617377409750-5794881987150688-6306625022657382-5539980709153280-5710830940412843-6904609549281000-5541113758266515-5882506335671232-5541869210162805-5627512299733104-6224793928346375-5543002516746240-5713945868245171-6908375528680392-5544135977825835-5885714683752000-5544891704381965-5630581433310768-6228188730332191-5546025422978560-5717061928546875-6912142877215656-5547159296099395-5888924198186688-5547915297365285-6999385423814000-5719399717079997-7427189234466816-7171567853850708-6745148345873016-6318670688972750-5892134879187264-5977935373105710-5807532837075296-4441357067228588-7089572094912000-6150409197186312-4271408446104400-6322115122915518-5895346726965696-4357726996947375-5725246976425512-7349325021496778-6067879264940032-7350326178269814-6154180569000000-5641716396666966-6411477980145600-4702070721528235-5728367143654088-6327284120511750-5558128038295040-7097785259415019-4618150645128048-5559263560329635-5901773923704000-5987714557928670-5817033047950304-4448622264218444-7101168993533952-6160469614173000-4278395163974800-7017045765598566-5904989273087808-5563049750733085-5649019671438000-6248583465203503-5564185942981120-5735782083740139-6934775734215144-5565322289921875-5908205790097344-5566079940494645-5652096619128432-6251986910267847-5567216545280000-5738906077090547-6938552673668808-5568353304786155-5911423474944576-5569111230418125-5655174683931696-6255391590954719-5570248247815680-5742031204556923-6942330984249000-6257094394726683-5657483965761408-4371989610090207-7029951772971888-6258797507488375-5573281050787840-7545878463259224-7460637382219704-7032343509588518-6775523559000000-6861756444984080-7033778811915056-6262204660093071-5576314954396160-5748284862660875-4547460014179848-5577452952047795-5921083538632128-4548388004112537-7123431718073000-6265613048993063-5579349958840320-7554095203678936-7468761118958328-7383415380995250-6611181942972992-7298554286717105-7213179423326688-6269022674412607-7471809039936000-6012209166849270-6442090687788600-6700229865331626-6442966765396800-6872965156250000-5756499677369192-7303518501492555-4640197794398208-6015480153108230-7133125658751000-5586562507505915-5930754120489792-4727734071535035-5673666543474864-6275845635707375-4298816599372800-6018752325554710-7051017675757904-5589601228745235-6793977085576000-6708433297427238-6536866438857888-7741552157298630-6279685726072832-6194083561101000-7054852355579152-6625128630468271-6539532371304192-7314447696395665-4302908668750000-7315441799870835-4647772938949632-5939224512300813-6283954329991272-4562632996265375-6543088075279616-5940838834114617-5682927570692592-6286089357152567-4305833164800000-5856330934679108-6976397521221768-5598724003518555-6805065267952576-6719381618985750-6547534517438496-7754185980491670-6289933624603136-6204191535274248-7152539916179000-5601767132793715-5946895146174912-5602528087371605-5689107184201584-6292924693734375-5603669648445440-5776482517206611-6983982966147912-5604811364577035-5950126861608000-5605572594813165-5692198670173488-6296344219383551-5606714569397760-5779621270118875-6987777749655336-5607856699068195-5953359747634368-5608618205012485-5695291275894000-6299764983570583-5609760593182720-5782761159822819-6042100907736880-6646762177045375-6215576143790592-4575665240968769-7166150835302536-6303186986519727-6303614824000000-6217685931787272-7772634933336720-4577529013531631-6737198036529792-6996795869125125-4405688972984616-4319596046887150-6134242653130752-7517117290855623-6999170347341000-6394737688278894-6654435336481856-5790615858896999-7778967018510960-7520178352538625-6310462856887808-7434748329102918-6397775637089168-4582501547839327-6398643799152000-7004396090274741-4323994621452400-7610746819945896-6313888732413952-5795332090671875-7006772287589256-7353284509632055-6229087037305344-5623862804364285-5710771107822000-4586233310854723-5971161554606592-7615910966165656-7616427509231552-5712708056739750-6838402188284224-6579162195124028-4415263518952872-7705590240528791-5801230980608000-6147990016955991-7100977010880016-7101458530986374-5976022744236096-5629968370398125-5716970885929776-6323745030777279-5631113655764480-5804772235206683-7018185515625000-5632259096441315-5979265002639552-5633022809848005-5720072456938224-6327175711340375-5634168509399040-5807921226653731-7021992677342472-5635314364288635-5982508433544000-5636078353852765-5723175149520048-6330607632459631-5637224467663360-5811071356744875-7025801215660776-6332324058297899-5725502905110912-4424552078972559-6420373383742000-7635556026076968-5987375778803712-5814222625685939-7723893711651336-6075384230781250-6770172572012928-6597025376626908-4427251195620552-7726510856937871-5816980920384000-6164681005842911-7120254798688976-6426031122575838-5992245763382976-4429351267305375-5819345867198952-7470114141919658-6167605031206912-7471126238222934-6255320082408000-5734431815255286-6516841180881600-4779340567196635-5822500126600328-6431256599955750-5649459351011840-7214413600244059-4694032759945968-5650607278088435-5998743183000000-7042479762834981-6608206267842208-4347798530306350-7565681733562368-7566194047518375-7131838201578512-6088566806171010-6697876975490624-5828417434707143-5915809259388000-6438228308665094-5655583425656320-5829996060343899-7048681368122664-5656732182131875-6005245297708224-5657498106195845-5744925418678512-6354665834704407-5658647121920000-5833154166706787-7052499549614088-5659796293207355-6008498116251456-5660562493828125-5748037091146416-6358107688346159-5661711924410880-5836313413360363-7056319109697000-5662861510584915-6011752109203392-5663627987812405-7145368041439728-5838683596790125-7582087253839872-6275255427414216-7060140048620232-6014600316585111-6102181295280000-6451313839042754-6451750328476912-7672870833901416-6016635301111296-5842635328362875-4360470596686800-6453933070974302-6890475737903168-6978168979243920-5931844875500000-4536423516328652-7590298899972096-7590812324622999-7155042682056848-6108376402721250-6719668514791232-5847379759408631-7331539112579808-6371887530900367-7594406945472000-6110855619251670-6547788093444600-6810160136531466-6548673727540800-6985724346170000-5850939767733032-7423335972203355-4716320569417728-6114162284678630-7250139760599000-5678204198992715-6115402591679360-7863192083080530-5941480140302432-4631172607421875-5680123981309440-7690533893735704-7603655466739224-7516765246466754-6730581986744000-5769460260850506-5769850264923888-6382235468481751-6732402046763008-5858460085363875-7345431490694304-5684349025459195-6034562961115968-6472287547454306-6472724982406000-7697814790025448-6036194512015872-5861628461752619-7786868484033576-6124917185091250-6825368925268608-6650808864866748-4463344375012392-7789499834734711-5864401728000000-6214935173137271-7178297440810256-6478413430473198-6041090929137216-4465455844236375-5866779509452872-7531001861494298-6217875066737152-7532019449853894-6306302744712000-5781168029903046-6569952910689600-4818290925414835-5869950884406248-6483667262829750-7097466514046976-7273203834356179-4557013791336864-7186545568188838-6924090792152000-7099863712867341-6662050426198048-4470888394063317-6575279899276800-7627839776109375-7102261451402856-5699730483361395-6138585788352640-5700500283763285-7191885957174000-7894066366349190-7280574992134144-6228382254882327-7106098955818824-5702810100836875-6054160985216064-5703580178494445-5791718554754352-6406424211685887-5704735424960000-5880662712294107-7109937842309928-5705890827409955-6057431442146496-5706661182373125-5794847099483376-6409884727491479-5707816844820480-5883839088006883-6147709478750000-6411615452607123-6324211906085376-5885427704694359-5797976770651824-4480557136315125-7819539143002624-7644334997543391-7293363460352696-5799933387242214-6854929265808000-7382729654511204-4482674030175528-4395074998042350-6241427598823424-7648462515282375-7121462796722376-6506466694071662-6770699140684864-5891785030918503-5804239493118000-6420273751435103-6596616648153600-7652591518508079-7917008015558160-6158088277031250-6774354038927552-5982949968434644-5983353531027936-6423739252339447-5720153620480000-5896556028754947-7129153014601608-5721311103728155-6073801394861376-5722082845968125-5810506723774896-6427206000079119-7484237693893120-7132519225075689-4667271734997000-6781210517833367-6869741388392064-5813250055216362-6694496883239584-7928228212863750-6078718125379584-6343437884506056-7224958010787344-5815602169310934-6080357625000000-5728259282427565-5816778464244528-6434143236961471-5729417858844160-5906105749870875-7140698718803496-5730576591469795-6083637508571328-5731349166674885-5819916026166000-6437613726552663-5732508159672320-5909291280017699-7144550055168264-6439349439233875-5822269937886336-4675774285829889-5999510919668576-6441085463876207-5735599571520000-5912477955394987-7148402776096488-5736759137438355-6090200813777856-5737532268203125-5826194534396016-6444558449156359-5738692094586880-5915665776208563-7152256881837000-5739852077263915-6093484235836992-5740625485883405-7242507718954928-5918057393635125-7685159360451072-6007195858226404-7244459438967504-6096358198034511-6096768837816000-6097179496037049-6716186277174688-7953914175390630-7689301559083008-7689819438540375-7248363930833552-4685233668532119-6895713918178176-6807765764888473-5924039257125000-6454984894979023-6632280384345600-6278981552926767-7694481400081368-6191378917771250-6899429614866048-6280672899045203-7342689436496296-6458462874328167-5751073303040000-7344172641629923-4778458105265712-5752234953500555-6106629725391936-6372564340473000-4514203611988296-4603027251277676-4426285680921600-6285748759712639-7348623455419000-5755333452791715-6109919049170112-5756108251433605-5845057148780784-6465422580484375-5757270579773440-5934816766778211-7175410611272712-5758433064575035-6113209553928000-5759208141371165-5848204870554288-6468904307739951-5760370886965760-5938012611408875-7179274417666536-5761533789050195-6116501239877568-5762309144050485-5851353722214000-6472387284746183-5763472306974720-5941209603122419-6207651515560880-6828876049755375-6385872111892992-6563698972548802-6564140516564208-7806530041534312-6121440984000000-7363967799945483-7364463134102264-7276224050826614-6921751828747392-6567231879139250-7455197038549344-7988248342488870-5947207055048704-7723012111792023-7723531503747000-6214753612979170-6836688707227456-7014736732497363-7459208983593696-6482843716511375-7726648344509952-6217261528317910-6661799549777400-6928737381435402-6662695434600000-7107352967604880-5952808317099816-7552578000751195-4798430960541696-6220606464843750-7376357818549208-5777054108792395-6221861125280640-6222279382913230-6044906297596000-4533984481071141-7379333489529344-6312866209473727-6046531782183072-6936193816334250-6936660021053568-6047751086834004-4536118168605672-4536423035745069-7917034991616000-6316261364337191-7206359906840328-5783270032520955-6139576132696896-5784047336348125-5873427337676976-6496803135645679-5785213422676480-5963620680727083-7210234814625000-5786379665719315-6142877275810752-5787157248150005-5876585235725424-6500296118730375-5788323752407040-5966826856513331-7214111111203272-5789490413406635-6146179602024000-5790268274490765-5879744265484848-6503790353584031-7573415257290240-7217504010149625-4722881558415688-5881719233871558-6149483111548608-6595540780802866-6595983751662000-6685567644278325-4457344427622400-6240701281445190-7311026734349968-4636572202437500-7044496182074304-7847560663072504-6777893860485152-7937803418836671-6154440595008000-7403664762679003-6958128027440304-7315446251118934-6691406175412800-7494878086006500-4461536475042800-7495884492659052-5800776219463680-7675388393910134-7140375496720000-7319376205372422-6159400742110272-6516904886680661-5892391705687344-4732086715125875-6696798604915200-7768807801527951-8037237149675280-6966073051399722-7055855217000000-6609725687903474-6074209621195744-6699945526269525-5807009144668160-5986088046075875-7505449849616544-6254961262287010-6970281687947136-5808957849033885-5898722221326000-6524782062412463-5810127280888320-5989302268731499-7241284094373864-5811296869681875-6169329030105024-5812076682737845-5901889178739312-6528285065928007-5813246533120000-5992517641763187-7245171510258888-5814416540469355-6172640828744256-6709842268359375-7962880257336664-7068648719418057-6174297172428288-5995734165376763-4922201449935000-7607548812940735-6981513005311104-7429544138409471-4565447745184104-4565753925034125-6893855473139712-7789683732249111-7879748708063936-7253436887988939-6447931806528000-4836273132295134-6627929803520112-8061536217636630-7972498121867776-6360509212347375-7346432748380752-6271765501450610-6899404591848384-7616736467348665-4570348265625000-6811171656953076-7976775213043712-6095023337912836-7350373791391248-5826906388476875-6185899875491904-7172538581287440-6097066453790816-4483437596873950-6366908114496000-7802227223428047-7444003027074424-5919724437194502-6189217601286336-5830813130813125-5920914730308336-6549329419693399-5831985493934080-6011834049376803-7268525225973000-5833158014190715-6192536513147712-5833939781664605-5924089625310384-6552841202859375-5835112563837440-6015057480804011-7272422384315112-6554597565103147-5926471541232000-4579853000808591-8082634984179120-6646167312954838-4670592601079808-6108107169690500-8084801039369040-7366645492415046-7097609475037888-7187934075285520-5930442819774000-7188897024453680-4673096045336576-6111381050677476-7459979419809272-7370593760309750-7101413463956544-7191786387965840-5933621119641072-7192749681151920-4675600384000000-6114656101299268-7374049651763856-6205408503304263-6205824025502016-7645367581610625-6836315790454816-7466476353353269-5847632021537280-7467476216271707-7737903031126000-7018567965531018-6929050189240256-7199495142063760-6119980553709792-7560482079643500-6210811738804224-7471476560580579-4861286048417328-7652536553447015-6932761848936000-7743602952770846-6123258675616864-4592751392358117-6034018412651008-6394686285109375-4593673631590776-5945151975660678-6215802123857088-6036037874830863-8108653192830000-7118071896747089-7298764645367808-6488224945742664-8020703628227656-5948335528269750-6399395184982976-8022313816098517-7391839872454704-7121883192775801-7302672604224000-6401536357987791-4508425809784400-7394312997098774-6943904780395968-6673809484183250-4599825048394536-4780530126571419-6224125371445248-7487492224440067-4871706342750000-7668939600299335-6947621742462016-6948086455962729-6858310265637664-4873335857624250-6588468735303168-7942794876789784-8123856234904080-5957893004697414-6229122884664000-6048973103508527-8126029648073520-4785648580913291-7133802261118976-7947045296487000-7315383103965576-6683636389014862-6232456045862208-4787568942806177-6684977168422000-8130921244947990-4517480487142400-7860941581895679-7319296992029544-8133095917968750-7049154360563328-5874688011018645-7411640316980464-6598608682731047-6599049785856000-7955550684386008-7684852388242280-7775782141551282-7052924969930112-6058686643226375-6872999426362656-4793333110721459-6421686734490112-6512568261650568-7417587337858000-7689476349397535-6513874083380736-6333356357296990-6152814465490912-4705407835303500-7511056699916288-6516050840803656-4525337673939600-5973844872910134-6245800581000000-7694616258999585-6880351865509408-4798460698023331-5885297812892160-6519534661269000-7968852498588608-6339283426745010-7064244865182336-4709811193434308-7427506107222000-7246831490402480-6613175467372544-6432422227111287-4530177391197200-7429987180391750-6524326941645312-4893572039933502-5981431974449712-8157042918320310-6616710034624000-7976840699692568-7977373436159424-7343300021635827-6527813711113728-7162940582296875-4624485631593576-4624794445325133-7527128855740416-6439299217573319-4535020557850000-7075104457706298-6984864342268736-5987426327139642-7530144935117832-7258455608030000-6623782946943488-6442739550111663-4537443435083600-7441904022857558-6534790976448000-4901420415399534-7443394523480816-4720516498349964-6627321292460032-6536972391021000-4903056549136944-8081502961884947-6538281472756224-7537688658194967-6175867941500000-4813865397919603-4905020390188032-6086264798448859-4905675120383856-8085818947264875-6541773211786752-6269617692949017-6179165988482016-4816436048902187-4907639660544000-6089514778470627-4908294623796912-4726821307746044-6272546769020736-5909315121588125-8182674541862640-4637158270932213-7365389794785792-7911502009353183-7457315460786000-7821608711912546-7003535447989696-5912469770695605-6003831321999984-6641044283234375-5913653053501440-6096018208989811-7370304641677512-5914836494173035-6279245225448000-5915625542329165-6007035786455088-6644588772736351-5916809246133760-6099271659898875-7374238093037736-5917993107832195-6282596241240768-6829364350025175-8104719451411000-7194556538807409-7195036282519552-6102526268182019-5009870517288120-6649907871365875-7196955470634944-7744075978272705-4646755377539592-6925038310259924-8110125000000000-6196913109180068-5012543279700440-7382601323417187-7018496266324928-7748207161885625-4649234197871016-6928732402766068-8114451169005568-7659093618601236-7750789897585000-7021771782897487-7113437716454784-6201871851569396-4651713899599944-4652023924297125-8118778876204544-6294753667373997-7389985893412392-6295592688188271-7025984658616000-7208958128996619-7665732089454432-4654504617785517-6115148810846208-7941095466984375-4655435105156376-6025082146689078-6299369204474688-7851910816107454-4656675947877000-4656986193004341-7579521676639744-6575444787667464-7397868194043624-7763712185519375-7033478375512512-7033946909655281-6943059419610272-4568106519715950-7035352636928000-6487575442278391-7401811445341128-4752096684114364-7128619792724352-7768885119620625-6215522031498848-6672990102274079-7404769803197952-6491032946938079-4571454381250000-6400462338735570-7040977418906816-7407235703474037-6127380735770088-6859465015603125-5945265529815040-6128604824612931-5031279238431160-6678324345247667-6312809048904000-6587717584462632-6039143165769648-6680103057748431-5948432959439360-6131869858524875-7413649606147176-5949621035524595-6316171994255808-5950413174128085-6042360181638000-6683661430182503-5951601513861120-6135136051869139-7417598462883144-5952790011796875-6319536133729344-5953582431649645-6045578339760432-6687221066046847-5954771193280000-6138403404851547-7421548721600808-5955960113141155-6322901467536576-6873176324184375-7423524376780536-6965745607986228-5957941997895680-6141671917677923-7517173226778000-4767305071805692-6417953039308160-6143306609096919-6052018083578544-6694344128963375-5961113927907840-6144941590554091-7429453445976552-5962303691844435-6329635719000000-5963096955744565-6055239669679728-6697907556464071-5964286983516160-6148212423685875-7433407912132296-5965477169602795-6333004637080128-5966270714951885-6058462398846000-6701472248292063-5967461164920320-6151484417279099-7437363781265064-5968651773231875-6336374750341824-6887821846245975-7439342242025592-6980587719932084-5970636472320000-7624550424444563-7808793698247080-5971827502931355-6431626436663680-6340167556640625-4686522358279176-4870631336559299-6525241789537792-6525675581399919-4595851684850000-7905390382545826-7078552599577536-6619346306469864-6252020399695072-6712173911982375-5976990465904640-6161307362885651-7449239809013832-5978182341340235-6346492263336000-5978977012984365-6071364750217008-6715743663362111-5980169152488960-6164584000382875-7453201292543016-5981361450448995-6349867159443648-5982156403791685-6074593197750000-6719314680190423-5983348965867520-6167861799370659-7457164180293384-5984541686426875-6353243251792704-6906157986366975-7459146150829272-6999169988555604-5986529906240000-7644846016187323-7737466564088352-6724673578639531-6356620540595136-4882945907957625-6818150922937904-8292896520521670-6911206123622400-6635198560450248-8018064107931000-6451744427464770-7097390217490496-8019661791566379-6268657691905632-6730035325609375-6361688717612544-7652974326699339-4887163547926856-5994089157572035-7377830386560000-7470549296844021-6271988688262624-7287058919335473-7103048012791808-6273238116050500-8303366420537040-6735399921856819-6643575222096384-6736294298297637-6275320864412000-4891383615852163-6737636011405824-8030318439952959-7846234243717640-4892682586863375-7293350601473344-6185910464644991-6832653122377008-7387142321247920-6925905600000000-6556959145147671-8035117010069496-6465465760629890-7389594131973120-7851964844160625-4711491567692616-4804192561206636-6005639226529280-6190838931310043-7577350446402000-7855091801959135-7116261226545856-7116733429851969-7024774411786144-4621868765668750-7118150165102592-8043118874298231-7488917864118792-7951724280507474-7212507482544000-6103295835704826-7768346399608032-4716808924732917-6381988364960256-7677393823546875-4995262267371504-7863434414527055-7123818986311104-7216814790431142-7032234678692000-8235663154463799-4812167293812736-6570894983167927-7496870344705224-6756886814759875-6387070015193664-7868651545799505-6295338708646496-4999571099293626-6944309236800000-6574382025208991-4630153515624400-6853081611329118-6390459280188096-4908939133299625-6854444956473264-8337039865580070-6021594689044480-8152853330445912-4817914562500000-7597984367756582-7320494634397632-6023591106603005-6116667219106224-4912194757687875-6951679810291200-6674055018450696-8250420444902568-8343674847808110-7231664198928000-6861264394478994-6305363574881504-7418566480515760-4822387822706688-6306617430954500-7698293233130968-7606046780031366-7328262423617728-4823986086405668-7607559117006000-7422500755000880-6773480781346304-6588342530060607-4639985291541200-4918710324109375-6496840334920320-4826544042784516-6868998557046448-8354740972737510-4641830297600000-8077319852304567-7520761561427208-8356955371216830-6871729648506496-6036378629068125-6872640173170544-8359170160941270-8266838098180608-8081601779113503-7896340870565000-8361385341945390-6782461794207424-5017495847512878-6132901121964144-8363600914263750-6784258948886528-6691767077741256-5019157710193968-8272863357065011-6693096744000000-7716164172689783-6322095325685344-4927841792755731-8275603078647296-7811198786800500-7811716039059744-6045180540713795-6417616574209728-7441207555090320-6325445223788000-4651370620761550-6605383598604288-8094456638698839-7722808987788952-6141435407637750-6421016635900224-6049184236550845-6142655237230512-6794598749363407-6050385689920000-6236964246947787-7540709638826088-6051587302362355-6424417898283456-6052388465703125-6145908905794416-6798197662797159-6053590343290880-6240267650801363-7544703482397000-6799997595977443-6148349911068288-4751312078992887-8385223258773360-6894973159807750-4845436902438912-6336759865967204-8387443039902480-7642398220043958-7363285479016000-7456985006945680-6152419689351408-7457971837488560-4848002435514368-6340114941826500-7925668011947560-7646444403747686-7367183803551168-7460932851483920-6155676804750000-7461920030284080-7555693822990848-6623330225340367-4664625601093200-6530907817971250-7184473794807232-7558193115257733-7745327435885096-7465869616262320-7559692955136000-6626835792042551-4667094418896400-7654541055066054-6721504933575168-5041462086114750-6162194483801136-4668637872293150-6816662041550336-8217889414099992-8218432829464000-7565194065584691-6725061598957056-6538686651708190-6352287019006432-4764530267578125-7754552130142208-6633850635831943-6353967147810336-6167493484345974-6448260372168000-7102901255141916-4766735679631368-8318970993522943-5047799211887616-6637359913355375-6637798660044376-8414667159804270-6732178693277184-6265080367324223-8416335853710000-7388160873206209-7014540365721600-7763271064016931-4676978401149200-6454656750336375-6642187190398656-4677905739288650-6175243640596272-4678524032809950-6831096472000000-6737965028366472-7767889614899064-6551665096607890-7300909207742592-8237467462851000-7863556661806944-6834256717492439-4681307027865600-7865115413646036-7771996530943000-7678865298445542-7304769059213184-8429136503399730-6369101640420192-4964480682963875-6650970053142016-6745091221923336-7588728872745192-6090122954178835-7308630270864000-7965059058044185-6372468121418464-7497516488157360-4873707591221248-6373730857562500-8436377391189840-7686984816097606-7406242751177408-4875317173406628-7688507862574000-7501478623839280-6470452565448192-7783811977412171-8440835382585360-8066219731157250-7222557329822912-7223034223670881-7880193969284448-8349804397617191-6286222819328000-6661959514779591-4691830524544400-6944367610944718-6475581061298496-4974325414294625-8447525313888240-4881114603540396-6665038731832832-8261438385538712-7604780468625000-7699174821245782-7324088724061824-6385524439878036-6385945908093152-6855953232710375-7044252463411200-6668999119188503-8172411486436344-6951705309180846-7234008576872000-6200987978273946-6389318321476704-4980238495595891-8363593872303616-7894249937248500-7894770849394464-6109451976066595-6485846181283008-7520317831736720-6392691921964000-4700818901105550-6675603250577408-8180504228777079-7804903983783192-6206718642093750-6489270297102144-6113483996511645-6207947100653232-6866818688918447-6114693948480000-6303254141315947-7620854683333608-6115904060083155-6492695617853376-6116710889843125-6211223782582896-6870443057090119-6117921267527680-6306580908766323-7624876773069000-6872255719321283-6213682050542208-4801798228346007-8474320387240560-6968234025015750-4896919777564672-6404086590536164-7723084231771344-8006163972852415-7253120875000000-7253599113260577-7159868575496608-4710750423926350-7255033954172928-8009331733823125-8104093419622576-7350708841229754-7256947369711424-7540182624578320-6409577738268000-4807500198159381-6504693732383232-7825002439117851-5091301021864176-8014613192099375-7260775210003392-8109971759493518-6412958465764576-4810035855201309-6319483188736000-6697207127859031-4810986956409048-6226393435064022-6509840303009856-6321565848234375-8492215211241840-4812572403687333-7455260259998208-6700738711533119-7739391270914000-8023068353784735-6796458634231296-6513702011976153-7174985073331104-4720695925268750-6137309031792640-6326566097833251-7743471614191504-4910817700142588-7366711830192000-6800489659830312-7934427258247392-6895849349414511-4723495617459200-7935995361304500-7842035749800888-8126018041879778-7370594837314176-6237067953873834-7938609325500000-4820187399376701-6143780710379520-6333237197934259-7751636602700048-8413915760269875-7374479208690048-6618558199658510-6429879935915616-8510695615069110-6903574347968000-8228089283732847-8039467147767880-6242820821724102-7378364944559232-6338243599387375-7000909074230704-7569048663941040-7096450311782400-6718415253805639-8422229905677000-6624661869308770-7571540559139840-8045291441538945-6436656849787232-6910395312359375-6910850202997248-8331436301322904-4734082222027600-6249399858209574-7480834619848000-7481327006777339-7197699690679968-4735640408514350-8429994714566656-7956923148436500-7957446813964704-6157953365005195-6537334532885568-7580017093717520-6443438523772000-4738134218003550-6728593328142848-8245438584428559-7866855572900472-6255983515311750-6540776744942784-6162006694426245-6257218465554672-6921318198146327-6163223040000000-6353278632525667-7681334709283848-6164439545629755-6544220165111616-6165250638308125-6260512460731056-6924961716238639-6166467410721280-6356622976702443-7685378048961000-6926783954691563-6262983715621248-4839896642231247-7023057019230256-7118431348753125-6549387561037824-6359968494307571-8069147390367720-6265867668169494-7405603321584000-6266691817192026-7976314078475232-6932252588013791-7692457307180544-7882912841796875-8168374477396336-6269164697854278-7029525623973248-6839988148309608-7220462197572000-7695998565941871-6556281652641792-6746762337230727-7127330167507800-6652612149601250-7603485137556480-8174283856927358-7129204547555400-4753115462605950-6369593395648000-6655236511680470-7701565596692328-6180674920075955-6561455395048896-6181487436223125-6276999778244976-6943198488016679-6182706343956480-6373362303128083-7705616032125000-6183925411914315-6564906068338752-6184738212905005-6280300711493424-6946849680205375-6185957547927040-6376713690962331-6662675952121840-7329425112715783-6853938731712000-6854389066064232-7806900450717296-7616988659939760-6570084346331136-6380066253459875-7142334410122200-7428515776965114-7143272873822400-7619991612264720-6382162201621000-8097304819970435-6573538044006912-7907818794606011-5145183905869296-7718282795671875-7337614952034752-7623996776298640-6480822892391136-4765623929091950-6958267905536000-8388599872949208-7912494493229144-8199026687920882-7436814884733312-6197752716618125-7056366443375344-4863490817942853-6580449069946368-8393007868763672-8393558976792000-8584885338693390-7345328607069376-4960807354232964-8586576460384560-7060537511725750-6202230665379840-7920291419381459-8397968709538496-6298890026028534-7444631454000000-6490617585282868-7254695861119008-8591651157953430-6205488709788160-6396846693100875-7734008851221096-6206710770535795-6589094661908928-6207525566828885-6303439653126000-6972443872511463-6208747894968320-6400206307900499-7738070652801864-6209970383556875-6592555017897024-6210785465092845-6306749848491312-6976105309387007-8123395366080000-7741625895569241-5065840684473544-6977936508408891-6596016585176256-5162438634468750-7839773009208432-5067502814745899-7936421294473216-6789432293839719-7937462682911000-5068832780703223-6695123992421760-4973846948087524-7843888555566128-6983432028147375-6218532297136640-6410292209747051-8420040542079936-6219756069697235-6602943354456000-6890479761889512-4881076617582888-4977110412945164-4785996959539200-6796561397672375-7945797070137688-6223020248101995-6606408556880448-7564355095655171-6320002218750000-6990763875081823-7565843295621632-6417022027576059-5268050057658520-6992597638302875-6609874971443904-8526339766765277-4886200434635112-4886520792204429-6611608633344000-8336922643009047-8049970268821152-7475462436775866-7571798047395776-7476442589625750-8052081367268064-6998100851984399-4793533961241600-8053664933295156-8629492322970000-7479383562222858-7575769617232192-6329538818124522-6521770448248032-4891648417828125-6810388234448896-6810834573382743-7770616274327112-8538644092508371-7579742575608000-7100477312476034-6525190508720224-8636847485731830-8541442180077056-8062114125376500-8062642396003104-6239358271796195-6623752755327168-7680216520325520-6528611764652000-4800764342433550-6817531997749248-8354424541426359-7970835232373272-6338669755101750-6627225233765184-6243447240977245-6339915562833072-7012790202870127-6244674280000000-6437239738845867-7782844369558248-6245901479780755-6630698925614016-6246719702283125-6343238514796656-7016465749624839-6247947170017280-6440613480478643-7786923250221000-7018304004511363-6345731490603648-4807687159139850-7885123264677808-7020142580441375-7212947542387200-6828704126099423-8368114930258584-6733406896178130-7503430378704000-6830492798508931-4810521137612400-4810836092838350-6831834507771904-8371950917484375-8468734632157888-7891837523991206-7507361277277056-6449052991271863-6353214336942000-7027500095156943-7220506962777600-8376336338134719-8665742713833360-6740463279051250-7414994913253312-6548735797005204-6549164416592096-7031180779504487-6261050165760000-6454120234807507-7803253024102728-6262279509986955-6648085593439296-6263099162198125-6359870692278576-7034862748810879-8191814551416320-7806828202698969-5108505786125000-7422277049113927-7519162209796224-6362784309121482-7327321917685664-8677659456123750-6653307514159104-6943035962721096-7907863829034384-6365282403135414-6655048761864000-6269658954804765-6366531695299248-7042230543197231-6270889425615360-6464262683504875-7815515325273576-6272120057408595-6658532168630208-6272940568044085-6369863940198000-7045916368725703-6274171468165120-6467645859492339-7819605611897544-7047759763671875-6372363886770816-4924421378997783-7918214886444464-7049603480110047-5021963724544000-8112933404758644-8403230460600216-7148042689548638-7631517502001216-7728624282330000-8115586077182304-8695839301119270-5217844698021888-6474415752334723-5218526977326000-8601467859184419-6958945754804736-6766083991586990-6573196973634912-4930219994911125-6670733664336384-8411474848586751-7831885033954152-7929093214031318-7639503741000000-7736711965416080-6383204547113328-7737723322346160-6674222541705216-6481190367705875-7835981029530696-5030835095397436-7546745797758336-7063441603783317-4935055650621000-8612718714979759-7258383299289600-6871718518308287-7840078452967464-6291832068331875-6679458138335424-6292654297163845-6389881829801712-7068058332718807-6293887774720000-6487969707252387-7844177304513288-6295121413455355-6682950056782656-6295943928828125-6393222216663216-7071753163947759-6297177836218880-6491361149105963-6782462109990000-8236384798606735-7752397903805440-6299234706780405-6396563767473264-7075449282602375-6300469044080640-6494753772620851-7852379292927432-6301703542616235-6689937544296000-6302526631220365-6399906482434608-7079146688906911-6303761398504960-6498147578002875-7856482430293416-6304996327052995-6693433113786048-7275945810401175-8634686093875000-7664997058407729-8053623948836864-6501542565457859-8248764132406440-7472897690633375-7570442496459648-7376810122269468-4950550995253512-4853798195453950-6310349547840000-6504938735191627-7864692992587368-6311585336637555-6700427905292736-6312409285463125-6409941614253936-7090246635962599-6313645343150080-6508336087410003-7868800418013000-6314881562184715-6703927127733312-6315705797850605-6413288987847984-7093949195109375-6316942285821440-6511734622318811-7872909273289512-6318178935168035-6707427568248000-6319003457724165-7972186017905776-6514284299764829-8459398657179648-7001338395357000-7877019558665736-6710491453066407-6808189070919040-7197697963553506-7198167501126000-8560541367599848-6712680513372672-6518535241031019-4864895848389200-7200515495290750-7687538206426944-6422919177970218-6617984709535456-5158471563313947-6910856000000000-7008649065936072-7982593117264656-7496338483636079-7399465959812864-8276258193260625-4868704648410800-8277337634799155-5258886812955648-6720126879332301-7110163047473000-5162509769064543-7403326886403328-6721879765369593-6430043337349104-7307343829003125-7112945043243008-8575068118048344-8088375623580056-7601619622339002-7699578201432000-8187426984849924-7408154933001248-4874103850708350-7896562951647744-6532150679796875-7897592445751656-8678167199329787-7508566620474304-7216495398096786-6631806367436000-7119903207288743-6340053027409920-6535557499301779-7901711316951624-6341292691036875-6731964775731264-6342119223222445-6440109939573552-7123616082884287-6343359156160000-6538965503143707-7905831619993128-6344599250697955-6735474968469696-6345426070173125-8005520608637552-6541522283370141-8494768919445504-8202380210274516-8202914590500000-8691749529287939-7031985789067776-8106845038642791-6642185230451552-5177334553667875-5275363730955264-6545785064661931-5276051015064048-8696280119920731-7035651145152000-6742938179023689-6645647256302304-5180033014518491-5278113225547776-6549196622749875-5278800748436784-8700812284665907-7039317774703104-6550902846216103-7235796704182000-7138480493161503-6943357795332608-8606412301609496-8802585728390160-6846901367031250-7532081905577152-7630397943365574-8120054677523816-7142199823825847-4892236185600000-8219491891753044-8122169550459544-8416289831825682-7731746299335616-7536496480137625-7439104145588256-8712149585064767-7537968388217344-7048948737813768-7930583520849000-7147781241804683-6756561751937472-4994305476684207-6463639525106544-5288776540598250-6366534245027840-7052619985536456-8718389296094088-6367777358039435-7053997032000000-4898927838415050-6467005565671728-4899565456736350-7153831058499072-7056292507749000-8134866499998328-6861177203093010-7645809201553536-8626602412826552-8235019895004000-7157090065591063-4902435423846400-8236627355451348-8139101755152152-8041563418811750-7649789666133888-8827254601525170-6669915126542176-5198948498867427-6965082173888000-7063641376528392-7947113456435688-7162679237389291-6770644029829056-8341190947265625-8243595434623584-5103510040219916-6576104074973184-6969160532932919-4908178719850000-7657256760355098-7755931082145472-6578242738120679-7265994312723696-7855639800830000-7365141222259200-8544119376321711-8544674958906264-6875472868853330-7563511920888000-7760471336116459-6680333701679584-7172000988693111-6779455382224896-6583377421407875-4913287636006800-6879049885296610-7665725339515776-7666223685584022-8256469903500000-8748495120304639-7372806589785600-8651322066074776-8848518161423760-7275921178866750-6784745861344704-5211810195890329-7277340040247088-8851394231791110-6393089098240000-8655821615872728-5115136100023456-8066700377925254-7772082256656576-6395166800238125-6493975969951536-5215198374991539-7380477274022400-7085718593626248-8759304627057000-8858299343238990-7677691607074944-7284437114099058-6694242004209632-7876090528750000-5119791463268352-6695546896411844-8173036728635416-8075090990253798-7780166245528000-5121454777282532-8076664877526576-7880184928838960-7191135856097792-6994572766095375-4926075434142800-5221979137843759-6897401568167040-5124116828961988-8080862910038000-5026228976639421-5322235156733952-8575269104941959-8378680610897640-8083487418919750-7788255838065344-6704250511541364-7493472465493792-7986982710306519-5127778656000000-6705992139184868-8185786621135864-8087687815009014-7792302736315456-5129443699386500-8089263338604912-7892476642539440-6807703076732928-7104151375727688-4933758753050000-8091889665938342-7105535121609216-5329497307622238-8093465735164208-5132774867395500-7206094012215808-8687362156027544-8687926075156416-7997360130838179-7109225989056000-5332265578000494-6517636496781168-8888262992241030-7209836789501952-8691874192375000-8692438306743488-8001513614625723-7112918134393344-7113379742423208-6521021256222000-7213112782540543-5336073514755072-7016403785724927-8400465096976840-7709162294174250-7610820693803712-6919376844383710-6722116496022496-7216857989544087-6426386370560000-6624551110759907-8009305272363528-6427637262208955-6823626832140096-6428471280148125-6527794290265776-7220604492719279-6429722442324480-6627989979608683-8013462890625000-6430973766831315-6827168813295552-6431808073358005-8114499550795248-6630569912102125-8610402940833792-8314031689873812-8314570908463008-8810057183126131-7127699499072000-8217186457639223-6732589346257504-5247799638212691-5347161456178176-6634871287194875-5347854962051184-8814628789538507-7131398037179904-6834699592534521-6736082712044000-5250522526307083-5349935839444992-6638313726343939-5350629585176496-8819201977171875-7135097854505472-6540930386491578-7532468731448352-8920607019807510-6839575399488000-8723502198931608-8030107751759208-8129771833669334-7832848849310016-8824920685722125-7536375782365856-8925233990571270-7239825673670656-8728026739130072-8728592416632000-8034793268233851-7142501327694336-5357223161050878-8135569777575088-7243110743933375-7243580120790528-7144815962885256-8832358701987688-6947249124822930-7741722066000000-8238520091338783-5062551194476008-8835220589951303-7048778718674944-7148520419229000-8141897950490512-8440319060197655-7149909920408064-6951751651714030-7548105040916000-5065503884489781-6655112669502976-7052889681427087-8742176010228672-6557056724187750-6855548798092224-6657268427579871-8943178614248880-7850631910900961-8049903441408000-7155933172859592-8846101402264072-6958058457018690-7057916361715904-8748406530875000-7357091006314224-7655847211919291-6463146682170880-6662444146242363-5270632919261000-8055639838297971-7857243897003072-7260961323386701-5073054863372904-8953029418083750-8257217283227648-8655715851143511-8258286547777176-6567255423710454-7761804344112000-6468589037938365-8957087733031920-7862841553332953-8062422729122304-7167061908981000-8859858350446504-7367100652570302-7068891953229632-8861578971142861-7368531342750000-7767333052560978-6473196493803520-6672803629941459-5278828088402792-6474453452276875-7769846969509248-8467688904209905-6774589523000416-8966948746165110-8270054550848000-8669172362917647-5082257483006328-7374733140606878-6876885322681536-5282587044887625-7376164818736304-8971591726157670-8872481408974848-8673660964142583-5184592548356000-8176232588870502-7877611753196992-8376736678557828-6781606489710432-7280725005859375-6682741540040192-8678151114463071-8279691228178616-7382370898447486-7881689543688000-6585128584606506-6785116789337824-5288741912986011-8083317041639424-8782443306263000-8283976597717848-8184698970773446-7885768741162688-5190968284417188-8186287067758000-7987138028357680-7288734776385024-7089501844892447-4992929786549200-8188934352549750-7190748770913792-5393410305089742-6592372168588272-8990179673327910-7292506112000000-8791534665689688-8792103083879104-8093254473318987-7194469085803008-8394089917930500-5096741216862216-8894888105321727-7296278748299776-7196794934106888-8496765471285000-6597914962619046-6898266071850432-7398618639557778-5099377575903144-5199701443215500-8300059902701568-7100510148753623-5500750692064760-8101629151222779-7702046451176000-8502808559499185-6802686458554464-8003677751117360-5202726740277248-6804005405062500-9005883209709840-8205890491031606-7906185841785408-5204407967802628-8207481327974000-8007816246479280-6907187780616192-7207965983861064-5005855343725200-5306549494232375-7009103089089920-5207098685123556-8211724564973104-8011956168201520-7311382304832000-7111529842232591-5008443129144400-5309292664916271-7012726300746880-5209790329698500-9017527241208240-7414890202790102-6513499919380480-8317775566918467-8819415979000000-6614989198742166-7818219419197824-6816323794514036-7618736248434464-9022770328173750-6516866069143040-6717818824601531-8122066627816872-6518128674237635-6919691091384000-6518970501561765-6619689772286448-7322250850763831-6520233378447360-6721289892839875-8126263174538376-6521496418421595-6923266235251008-6522338535681085-6623109769518000-7326033737793103-8530863954414080-8129936338491177-5319931380574472-5219892257937500-6926842610334144-5421357190799982-8232962688602864-5221240167532428-7330291042816000-8837085585032408-8837655964910784-8135185635407547-7231742834969088-5424157177242750-6629953297390896-9041428874097270-7334076698297856-8841649311278872-8842219887512000-8139386699450451-7235477274779136-7436942619301618-9045513856960560-5226634126343500-7136826296467456-7137286786388583-5026582602899600-6635517133706934-7842480750000000-6535822272817565-9050183915220720-5229332498287404-7140510770476544-8850781476911000-8147267592299496-8650743361382498-7444143066709888-6539196108264885-7445103477374000-8954823655643959-5232369276665856-7144657319266487-8855921082337472-7044937034861250-7749930551139392-8857634726196344-6844977355860576-7348758423994207-7550581185600000-8859919928530968-8860491290521024-7048572584036690-8056030989265920-6545947261953125-8258496735205232-5237433186189516-7554477254246400-7152032924666119-8361366305391000-8261159563821862-7858682822699904-8060707176114960-8464288207309536-9069464896233750-6550591374512640-8365140539420699-8869636423372736-8265421280083158-7963541142856000-6552703060697365-6653942767037808-5041190663250350-7360612787474432-8873639396919000-8168308173126216-6656087493615318-7564223288894400-7362985188921877-6657374550750000-7363934292217023-5245880294127616-6860439403297636-8273415948036048-5246894557001500-6962674124685504-6559463506095045-6660807514225392-7367731521006167-6560731607040000-6763036015784227-8176734538082568-6561999871410555-6966264057135936-6562845471788125-6664241657666736-7371530054937199-6564114008558080-6766522640946603-8180949892833000-6565382708781715-6969855223346112-6566228599743605-6667676981276784-7375329894234375-6567497572413440-6770010464236211-8185166696096712-7377230303465347-6670254248592000-7984606435734339-6671113485258288-7379131039121951-8390511243090432-6773499485858875-8593799019634760-8189912331504243-7785973577649344-8898828526233272-5157607722129000-9001110693073319-7383408887988224-8901120807907416-8395915875064472-5361592683028375-7789985242788672-6576384959181245-6677990035146672-7386737246565327-6577655240000000-6780481124926667-8197825799455848-6578925684384755-6984232230023616-6579772738183125-6681430081459056-7390542309569639-6581043455201280-6783973742783443-8202048399261000-6582314335813515-6987829568212032-6583161680445805-6684871308953904-7394348679061375-6584432833738240-6787467559796571-8206272448823592-7396252353810107-6687453004848000-8005193709343819-6688313717833968-7398156355264791-8006739179831296-6790962576171875-8311862120594832-8616509014980055-7299159599890944-7096861752133230-7705659930772000-5374029629252323-9024894496369152-8822655446477919-8214724898216424-9128059298808750-8012923050889024-6593335488795445-8318281372817904-7405775628703687-8826629104128000-6899418240785028-5276365080546976-6697355663440662-8017047399980736-9032444440965125-8322562709919152-7917093200797794-7004032876635648-6902969074626532-5380601320125000-6599275048109315-7919639326545024-8630931185401545-6905188964329952-9139808381523750-8429476403478528-8836284382519191-5180223914037912-7516886623719246-7009439540424000-5384408430847393-7518336640425072-9144510836062230-9043486547862016-8840830478277375-5284514255087392-8333808208682966-8029428938180928-8538169486249956-6912295809484000-7421029865988903-7014848985894912-6811957872555539-9150979344302160-7117885865781250-7931868329094528-7017103742660577-5186888294945352-8950500126025832-7425323891136000-7222354501586111-8341846906778576-8647592137988895-7325489962188288-7122461812838750-7733455473841056-5189889130199853-6818527765889024-7226068351234599-8956829227192000-6718053560946486-7023870911806272-6820718668695319-6719348593543344-5396187217075875-8247532959484416-8960858390076824-8452261692292536-8350963678548118-8045957477000000-6824225089276767-7537688018630192-8149375381674160-7640530194124800-7233499869536375-9067927341679624-7132535798867010-8151993066152960-8662048962200465-6930084252348000-7440127100610463-7440604950777344-8970072442240536-5096959392117200-6728418482007750-8054230245585984-8054747481821227-7749368610825632-5098596215647950-9076084047872000-6934981418708548-5609536325747640-8261847601340427-7854359419939648-8670953472890625-6937208165871968-8161945379406640-5305605116258304-6938544442937252-8469649445011000-8368142675743062-8062508682878272-8165089897186960-6736631601143664-8166138249230000-8268745739636736-8983905360104664-8678192879638120-9189264625327710-7862431039848000-7148123363291470-8578298597440992-5310716160589164-6638821266920960-7149958686053750-5618185230291480-8274585624052563-7866468922696384-8684321677858665-6947903187500000-8174528296220080-5313784362172416-6949240837584836-9198114828215760-8381042373147750-8074936971888064-5315489429124836-9200475841636080-7565321063337446-6645640805440000-8486516554953723-8998329764400064-6749180296118502-7976815703356032-6954593154804500-7773279223515296-9205789598969670-6649052325294080-6854078196498803-8286805175373000-6650331946180715-7060035970523712-6651185117974605-6753944219406384-7470750776609375-6652465012477440-6857596039862011-8291058272339112-6653745071164035-7063659288888000-6654598534840165-6757410298568688-7474584634140151-8703841595555840-8294780925716625-5427797280089768-5325727491000956-7067283846735168-5531272437621726-8399878184798000-5327093558366892-7478899291431424-9016237457854616-9016815520608192-8300100934699875-7378340498376192-5534110139592942-6764346014025072-5124833071019950-7482735936000000-9020862651715288-9021440912141504-8304358579313787-7382125233105408-7485134505039125-6972900973473888-5435109397756979-6871239051989504-7281928969572159-7487533586593000-9231797421875790-7385911261871616-7488973281555181-6976476972877792-5437896692848875-9132147552518144-6977818287794884-5644185275048760-6670828214131835-8005506800304000-8724508718881185-5235040646016648-7801736896126292-9136829904615936-8624077372312500-9240674908317840-8009098017280074-7906923813677504-8728981583367065-6983632639116000-5135352963709550-6676386524753920-8525778151397571-9245411893953360-8013203580164250-8116456834079424-6781271699284698-7809237283587872-8631815109768396-5343846846208000-6988554996889828-8427914898334416-7914524513211239-7401068321730048-7195943916078750-7607627890476464-8019364554818994-6888869660196864-6992136345867332-5450102313625000-6684515762148315-8021932559332224-8742409348860545-6994375310182752-9257854182873750-8538345521571328-8950405086476991-5247125119296312-7613963112915646-7099960679064000-5453942134495193-7615425586618672-9262597037188230-9160265674428416-8954990237022375-5352750592274592-8441416265301766-8133104548238528-8648411558044356-7001543207804000-7516843670104703-8341141215794688-7311838662983807-5149511725781200-8445739746093750-7416246103875072-5562540557719182-8447361431908464-5357206171690828-7521174573056000-7418619505140552-5564320684612272-9171411689717443-7420043788927488-6905204799676375-9276241765901040-5359949295277356-7731190747430400-7319328861429199-8969328924903000-7629572488521854-7939387407050176-6805624589541162-7012304233778912-5465822073470875-7116336799248384-8560778843430659-5570019642750768-7942943493923823-8149775011000000-8666137869538884-7841292948933408-9183154101313103-9183741484842496-8977939480083375-8462507177724112-6811721908506438-7121801096526528-7225477690720030-7019484373228000-5264949970957581-7123623150354432-8982534028633239-8363583736195464-8467379295091750-8158118777960384-5370244348415076-9295248017936880-7643248180147366-6714093222720000-8573928758500763-9091011720511424-6818694731142822-8058972634207872-7026220203812500-7853336402018976-9300598199998470-6717528127098880-6924663959346963-8372143845117000-6718816518211915-7132738081200192-6719675537135405-6823491305961264-7547677352877375-6720964202800640-6928205911389851-8376426089019432-6722253033211235-7136386229496000-6723112345015365-6826981136506608-7551537481437911-8793448050032640-8380174250048625-5483674308922408-5380552575846396-7140035621514048-5588211038850846-8486344194750000-7555398925904623-7555881698998784-7452852650292744-8799068781986440-8074955493842250-8179003106374464-8697217168877412-7869413513393312-9216086165735031-5177907276800000-7353098059519351-8492852959028496-8804129488159495-7458091969632768-7251385937748750-7873436216708896-5491036513192339-9221386151259648-9014739766995183-8393569666713000-9326784200094990-8187366807241792-6736871295005605-8499365050470768-7566991156984375-5597857792917504-9019346861184471-8708891035601568-7672608242708686-7154645631048000-5495948308389473-6844448138759088-9333934356967830-8608511339628032-7364377497235375-8402150220293736-7572791716356619-7158301244856768-8300009604773520-5291593949049000-9338703157824390-7160129518620672-8613459286418531-5604295126092336-8822138824614375-7992330057707072-8096643380979894-7889540738863392-9239657209548911-5398796000000000-7371903527011071-8410736619684648-7580530405638971-7165616207668416-8204634943484875-7893570297792416-9348245631840870-7582949826789376-7375668463942759-8622810580383000-7272713984363170-8104398455846784-7585369762677381-8728927673654496-7586337881171375-5196453405004800-8730598779328692-8627213530256056-6860631617918694-8212492116232000-9356600627123490-7069882633316064-5510701266861851-6758838399938560-6967247130421875-5199769866678800-8944174735546738-8216684658710208-8425239430036509-8737842701868000-5305457199070341-8634922298591744-7386970965530527-5618617975906416-5410866123929500-7180261080003264-6764445485177445-9366752669298480-5308165043536269-8431152758784000-9056260135823127-8536329789443216-8953307073811602-8016844301711168-6767897540048125-6872457269920176-7601838981816079-6769192363348480-6977920131129483-8436530912625000-6770487351787315-7187590992917952-6771350769162005-6875963774688624-7605717553470375-6772646032855040-6981480218710931-8440835082048072-6773941461714635-7191257819304000-7817082891598575-9276863045567192-8235043809444713-8652559581245952-6985041516974875-8549401711646672-6777396746234595-8133394487277696-7612508227954157-7925856174468000-9282186304363079-7196760396890112-6988604026127139-8866704494304040-8032703028109375-8137542414688128-7616390427523909-5217038215927600-9391267212663510-6991722215104000-7200889171638429-8558123736100176-8558669059504534-7828549761652800-9394858290521250-7933941375876256-8978453052325258-8665803292594176-9084011089239303-7622701816517000-6892196874721686-7205937595985472-6788634535368205-6893514190634544-7625130201913375-6789932002147840-6999298820972091-8462377889520552-6791229634234435-7209610659000000-6792094814134565-6897027853663728-7629016691206071-6793392721756160-7002866175735875-8466690844828296-7630960430985139-6899663884324992-5331897995317479-9409830968790000-7737464836518694-5437483693664256-7111008395288996-8575585577238608-8471544670915875-7844522314267200-8786424423051492-5230347546351600-8787543356437356-6800317688320000-7323885320679270-8579954745707536-8894421764238695-7534578090428928-7221097025390625-5337672368335176-5338012167106533-8478559027533312-7432296438465919-5234344754850000-9003646069621826-8061917177465536-8167137225127686-7120521549743072-7644575854532375-5236344122572800-7436081908025063-9426619244886480-5551584637170807-8170776614832000-7437975124719691-7124147839135584-8381883778656560-8277636966196736-7020721132432875-8488277604119016-5449611390367196-8174937241051776-7651389635373277-5345831519625000-9329593689171639-7862517388185600-7443656702790967-8492599354269384-6815482456176875-7235357054896704-6816349694628045-6921656931308592-7656259099769567-6817650690240000-7027871604296827-8496922571097768-6818951851383555-7239040107539136-6819819384113125-6925180150039536-7660156158471799-6821120821166080-7031448660163203-7346756886910000-8081946563553247-7557625471136256-7033237643170039-8608390519089968-8398963878750000-8084516830218752-9240035370212504-8925601722118920-8611128034339798-8086573435864000-8402168978459280-6932230173829488-8403237526198960-7248253206859776-7038606412793875-8509901024139336-9350979568970067-7355170630407040-6830235516797485-9457850426310000-9458451700998390-7462141812034048-9249439786229016-9144913822032408-8619891983069750-7253784816801984-6833709916434245-8621535885164144-7991199711241524-6835013120000000-8728340727912883-8834062910938272-9360494885264003-7573016472887808-7047560432388375-6942814178375856-5680845337252122-5681206362037248-7470208991673359-8628113583602000-5577061944311343-8103038838673856-8840240446178148-7998821022762144-5367970965832125-7263010419585024-8737219827686979-5684817451188528-8106643622343343-8317734228792000-8844735007488324-8002887702863648-9372398105192463-9372993530932736-9162946532859375-8636889051252432-6952084014881478-7268549534148288-9165275059529043-8006955761092000-5268068661369550-7691868793995264-7481607846281927-5690598376080816-5480183524549500-7272243841337664-6851099589168445-9486740365674480-5376160956358869-8539150849344000-9172263006411327-8645670467112016-9067986308180002-8119526576914368-6854581060023125-6960478116433776-7699199502690279-6855886915604480-7067285998809683-8544574828125000-6857192937026315-7279636210623552-6858063710113005-6964014495442224-7703111117765375-6859370007959040-7070876415200731-8548915664498472-6860676471673635-7283334273144000-7917170238043575-8551086633886968-8340478089615313-7285183773966336-7074468047419875-5279788870854800-6969763665688758-8237516229760896-8871734370753156-5386752017733000-5492723188342572-7077611723132416-9190914894381279-9191498172953688-7818552060218750-7290734154999744-6868518737790645-7820040615142448-9511463726877510-7503964180992000-9301278156635608-8561946994091208-8245360984706586-8140167681977408-6872006106818125-6978171989557296-7718770826829919-6873314174471680-7085250241104123-8566293711609000-6874622408106115-7298139047355072-6875494656079205-8674251172831088-7087947500224125-9204336545759232-8887509344034132-9099693869172912-7407197369032930-8148433909000000-7408137030833070-8890328269839072-5503885602130604-7303696005782016-7515873972731375-8574991559617896-6881602457823795-7305548951905728-6882475296100885-6988802692806000-7730529526109863-6883784691896320-7096043384650899-8579342690606664-6885094253756875-7309255784284224-6885967387260845-6992348658334512-7734451744681407-6887277225920000-7099643533429787-7418008278117360-9008152532417695-8478798690257920-6889460659453125-6995895823090416-7738375289699159-6890770941050880-7103244899683363-8588049367797000-6892081388769915-7316673210307392-6892955112877405-6999444187276464-7742300161387375-6894265837488640-7106847483617451-8592404914496232-6895576728249235-7320383804376000-7957443170461575-9443430967386232-8382902499145953-7322239571767296-7110451285437875-5837307485775480-9021865018328455-8173266163230784-8810702274312567-7218864045500000-5520657562396652-5733353776223232-7114056305350459-5734080283564656-7752118146262875-7327808755687104-6903445562539045-9559222470604080-5417235885953229-8604390260736000-9242337929698647-8711720888638096-9137261630458642-8181554778669888-6906944742888125-7013649642377136-7758012919329999-6908257240302080-7121270000275403-8609841827793000-6909569903977715-7335238725976512-6910445105467605-7017204006755184-7761944427734375-6911758046269440-7124878675699411-8614204738986312-6913071153361035-7338955593768000-6913946650477165-7020759571779888-7765877264154751-6915260034741760-7128488570038875-8618569123824936-7767844180441019-7023427033594752-5427537204368319-7875748621006000-7982682974810325-7770303292801024-9367533912656216-5322799371949200-5642524486208375-8304618282100608-7346858106344337-7027874304580272-7986726289664925-7561246104000000-7668227838398472-9585891461592720-7456165228387890-8202300829435328-7776699413724125-5433380410770216-9482381550604727-9482981625376768-9270467529386823-8631671122701000-7459940900127170-8313031571405184-7247716873831796-8100902000339744-9593780417853750-6929279817674240-9381772387742744-9595601560676880-8743212334206838-8317240346064000-8317766542757958-7251844971690464-5652530860826251-8639320083922944-7573216412234375-8640413161406856-5547282792661116-8321450541046656-7788516856624997-5441636780757000-9496790333395199-8003419395417600-7577049577353327-8644786393342824-6937613022461875-7365008830832064-6938490590359445-7045682162090352-7793444322382887-6939807080960000-7153791977337107-8649161100665928-6941123738074955-7368735747602496-6942001601998125-7049247339587376-7797387791004479-6943318536660480-7157411630409883-8653537283625000-6944635637865315-7372463921449152-6945513797864005-7052813719555824-7801332589660375-9084317692559360-8657367654392433-5771943294979248-7055043317756214-7376193352584000-6949027178156765-7056381302198448-7805278718574831-6950345001167360-7164654599064875-8662294077446376-6951662990776595-7379924041219008-6952541743076085-7059950087718000-7809226177972103-6953860010373120-7168277915058739-8666674688806344-6955178444296875-7383655987566144-6956057492821645-7063520076317232-7813174968076447-6957376204480000-7171902452437947-7493505856491760-8243377251924199-7708580026265088-7923207809875250-7067091268198896-5675446982506059-8031800288870400-9424574367222872-9425169753912000-8783099358925222-7391123654244672-6963092547590205-7070663663565744-8142490645740500-7392991357315584-8893580312695259-7179608650689464-7930217873044926-8037890625000000-8574291511400080-8896389284810664-9004143332732268-8468717230125056-9112486396573125-7397661991484904-5682620951340679-7505822388435840-8578624423458320-8793645293582000-8257968834024987-7185959074955776-9009830998114548-9653999888946960-7830960997058875-7616895015370816-7188227990806671-5364687933791600-8798643681347438-7404204183552000-7190043467317987-8692989374932488-8693538163218027-7513408496567680-7191859249484375-7084965283940016-8481024077022457-5368075587097600-7193675337331563-7301504472836000-8805311144227862-8054146571457600-9236004311285582-8914380713352232-7840853777442375-8700674512859136-7197308430171251-5478893959568472-9669246574663710-8380542538992000-8595970668913680-5480277111148488-9564224338268623-8920008005110272-7630849775657375-6986430043276840-7094361194997318-7417300136710848-5697705958537897-7095704145750000-7848773997836023-7849269188624384-9462729687961176-5376890159373200-5699863136380375-8389007020338048-7421512827320817-7099286176297392-7852736107345167-6992603359040000-7208215047705227-8714958926174568-6993926685365555-7424790467007936-6994808995663125-7102869412154736-7856699550028199-6996132600238080-7211853033907603-8719357273533000-6997456371776715-7428537522434112-6998338978898605-7106453853524784-7860664326109375-6999663028733440-7215492243965211-8723757100508712-7000987245560035-7432285838328000-7001870149556165-7110039500610288-7864630435812951-7003194644725760-7219132678083875-8728158407350536-7866613990843219-7112729527297152-5496546583070919-7329190788572000-7868597879363183-8947051972591104-7222774336469419-8732561194307304-7008052556041875-7439786252366784-7008936053936245-7117214412738672-7872566656984327-7010261440000000-7226417219327667-8736965461627848-7011586993139755-7443538350935616-7012470788058125-7120803678187056-7876536768900639-7013796619681280-7230061326864443-8741371209561000-7015122618408515-7447291710820032-7016006710400805-7124394150161904-7880508215336375-9176512368476160-8745227453763153-9177668731607720-7882494439069107-7451046332232000-9395389422173307-9071981964011232-5508336038661717-5832723221277696-9397757162109375-8858214150090832-7562366467661810-8427167721737856-7239176955025663-7131578714502000-8104577170544325-8969630323257344-7565224924959590-8106108647707800-7998530927192750-8539509992441024-8864353414115946-5513542623801672-8973585435783877-9190395138240000-9190973890636285-9299688581062768-8867703298849974-8003065432082816-8760663771751125-5516320810248936-9086276951557932-7031490346516480-7248300241930083-8763422167125000-7032818574304315-7466077437394752-7033704152415005-7142364615029424-7900385473155375-7035032658967040-7251951701860331-8767836803959272-7036361332791635-7469838369624000-7037247208275765-7145962330420848-7904364931417031-7038576160911360-7255604387909875-8772252923147976-7039905280847595-7473600564652608-7040791453755085-7149561253758000-7908345725767903-7042120852549120-7259258300284539-8776670524939944-7043450418671875-7477364022692544-8128081025829975-8778879881889912-8020715909260086-8346405208064000-7262913439190147-8781089609584008-7480658084708103-7589550899665280-9216463057250625-8241120713729056-5747458906200259-5856269930892288-7700394867807599-9002436354547000-7050544264424115-7484894728654272-8353234036959889-8896211400373488-7920296127598375-8137802385715200-7812781680806856-5968472500781560-8464911567301722-7597193310000000-5752522427694353-8140873898430600-5970349654385985-8141897907724800-9119499137920500-8794355763117096-9772120899201870-8361118082156224-9773349967964610-9773964540990000-5864747483867274-8797674387898368-7820646731718984-8581526935197176-8907967766571750-8256684350384896-8474498303763414-8040414132237168-5976359190777745-7063413997120000-7389882278272548-9672659855583272-9238514316375695-8369533196595648-9239675882265625-9783801213585840-5870649734797482-8806528135360512-7828517059307208-8590162795443000-8916931946549062-8264992962944768-5546593871673687-9027376977561032-5982372758470625-7505630237873664-7288533771685051-9247228433858120-7071854376887235-8486758552272000-7399177531721428-7399642498889184-5767730834314571-7291740543254528-9468974470620375-9469569454773432-5769180650391319-8273307147547392-7838362391813928-8274346812500000-9799184223517590-7513179907287552-7840332448327944-9692130920118696-7187874466995750-7515068115347904-7079856725961045-7189229192871792-7952222709652967-7081191037440000-7299532332729427-8825362067632968-7082525516556555-7518845480502336-7083415262438125-7192842627372336-7956219554566399-7084750020974080-7303200977059803-8829797480073000-7086084947175715-7522624111211712-7086974991129605-7196457272454384-7960217738484375-7088310196797440-7306870850391011-8834234378351112-7089645570159035-7526404007688000-7090535912235165-7200073128320688-7964217261631151-9273985892835840-7092316820005625-9275150430010760-7093207385706195-7530185170143168-7748937843734899-8295158406564000-5457683646733550-7095434126110720-7314214284879219-8843112633416904-7096770394016875-7533967598789184-7097661332487245-7207308473217072-7972220326508127-7098997880000000-7317887846447867-8847553990702248-7100334595290755-7537751293838016-7101225832033125-7210927962652656-7976223868686839-7102562826977280-7321562637840643-8851996834821000-7103899989727515-7541536255501632-7104791524791805-8963530157909808-7324319538581125-9511280310001152-9183881304151092-9293796285331720-7107466577526835-7654674983760000-8639389453324219-8311832785074848-9734204282938263-8203495731916800-7766463129484375-9517248983409912-8533241230666074-8424369107581504-6017783953708395-7331214818029000-9848518196147190-5690611862747136-9521428540192719-9084231433645432-5801138103117375-8319134846592256-7334434095551951-5583277575108072-5583627718986669-7116834549760000-7336274105769507-8869783084606728-7118173503096955-7556688772543296-7119066231948125-7229043587814576-7996261685952879-7120405465172480-7339955049370283-8874233366625000-7121744866343315-7560480070460352-7122637893766005-7232670349863024-8000273272250375-7123977574871040-7343637224030131-8878685136969672-7125317423950635-7564272636264000-7126210749994765-8990552464050096-7346399663031349-9539952715043328-9211566162928500-9321811896921160-7128891176118595-7677748592922240-9213875742616356-7459319255404000-5814245546337483-5704900302340096-9545335197902679-9107039887920792-8997880339843750-8669232814752704-8669776056495507-5597294751487752-5597645481154389-7793288862912000-9550121326399167-8782270993037440-9002391780379734-8673579384145216-7685931601538750-5600100999065256-9883150316379270-5930261690277888-7687857859945830-9006340527658000-5821535983155463-8568080223790464-7140514123012205-8129709914680816-8789426115390000-7141856044643840-7362066570419291-5494423655739600-9451000608578114-8682276881000000-8792729789896080-7474288410366944-8134293858766198-7145435324252160-7365756135755875-8905427027826696-7146777862356795-7587054668574528-7147672981177885-7258091654286000-8028391950089263-7149015799544320-7369446933592299-8909889223423464-7150358786081875-7590856115519424-7151254203873845-7261728124505712-8032414274436807-7152597470720000-7373138964134387-8914352909337288-7153940905765355-7594658832046656-7154836622578125-9026666611379632-7375908796127861-9578272144679424-9248565777871476-9359253546845000-8478913308672807-8699689313783872-9691399706140856-5616958183801704-5617309734394125-7600365287768064-7931312300588616-9143612771706776-7161108733806235-7712445872880000-9145329523865543-5619770999265288-9697466563031016-8044992696812032-7935283831221000-9699287113695168-7715824784298610-8598171288360576-9149908580141967-7496779671500000-5733190196570252-7166936118251520-7387919417475859-8932222561139784-7168281348076875-7609882398218304-7169178261472045-7279928696166192-8052546049640767-7170523771840000-7391617614633627-8936693702371368-7171869450547555-7613691465836736-7172766663213125-7283572456029936-8056576436944599-7174112622510080-7395317045732003-8941166335413000-7175458750174715-7617501804309312-7176356262160605-9053815596766768-7398092428953125-9607078958925312-9276380413761972-9387400483254920-7179049247158035-7731767231440000-9389161538056985-9279280974614112-5744675955776524-7402256805613568-7844673020160375-5524763011062800-8619169130036634-8730217062007488-6078379198246795-9173400235117000-9837152526031119-5968982513636352-7848597236951647-8954593187886504-7186233833991875-7628940446971584-7187132244238245-7298159654015472-8072711434511927-7188480000000000-7410127113648067-8959071790656648-7189827924241755-7632755870980416-7190726634008125-7301809494158256-8076748547113039-7192074839073280-7413832717536843-8963551886481000-7193423212646515-7636572566903232-7194322221982805-7305460550965104-8080787005446375-9409723453788160-8967473195293953-5867972521077096-5757615759524668-7640390534952000-5979809637716094-9081018963945136-8084826809736191-9635943473330688-7532012521062500-5538590468078800-9970085609611470-8530494966682304-7755479838987230-7534365294636000-5651126931103341-9419133176545280-7535777193931716-9752791356290752-5874207111472375-8534758437640512-8202747647812322-7538130751379296-5653951141249269-7428203601088000-9646180169564127-9646782553837656-8982048069176067-8760816142665536-9870396520510125-8429179516901536-9982546397984070-8097459875721216-9761930979825112-5879711886625000-7211417633982315-7988530573195776-7878070585786267-7434699760118088-8766835065543625-8545423329490432-7658065190842317-5771655791777824-9879027542774731-8103528418968000-7548963427466708-9103730017494896-8771214195097713-8105551940288512-7883974095898375-9772296120531648-9550794561641618-8773951891464128-8885569113000720-9330429859212000-5776340869619372-8776142458670592-9665468907556479-9554967817633264-8666674412906250-8556097102089152-7334255163347178-9335089055926368-9891366300536471-9669691743744000-7558391577449988-5780307145983136-7337001446793942-8782716347879616-9561528247214750-9117374808124592-8784360332965737-8784908373580288-7895789962356799-9786941747352000-7785552965229970-8675871640385664-7675288295964633-7564524082591712-10012494641163750-7454210959245312-7899731206415783-9903097632630088-8234549823258126-7678640229000000-5898453844637953-8236090719553392-10017491830985430-9906804189968896-9684783341913375-5788967141100832-9129325178245526-8795873973181248-9353158093358436-7572076333708000-8129353554189063-8352596380569600-7907617628701687-10024365681498960-7351659870777750-8800262766766784-5792939194515876-10026866042912880-8244826096317766-7242528496320000-9248728352271563-9806492001842624-7355327524833222-8693201715948672-7579161132812500-8471355210972576-10032493376194470-7246141330554880-7469565112196163-9030932659557000-7247496453085915-7693975779561792-7248399961961405-7360372540626864-8141525520807375-7249755366064640-7473290503592651-9035436678089832-7251110939125235-7697812854936000-7252014748369365-7364043091633008-8145585541355111-7253370603048960-7477017133457875-9039942193907016-7254726626713995-7701651205827648-7255630736376685-9153827556750000-7479812918725717-9713198040439296-8039009554385544-9044449207257384-7705010809347375-7817164612629120-9381181935375012-5696072432775912-5919816581634987-6031886966784000-7931308384606951-10054397464877520-9161243873873254-7709331735011136-8156757557125125-7375062066127536-8157773701162799-8605310944817664-9723489368140383-9500552553605000-7377359068477926-7713173913726912-7266485911991605-7378737498793584-8161839121234375-7267843569725440-7491936041722611-9057979234995912-7269201396557035-7717017368808000-7270106708393165-7382414152381488-8165905891747551-7271464817077760-7495668867018875-9062492240967336-8167939783489819-7385172443924352-5707079447338719-9176659791238000-8169974012926583-5820069813682176-9402236511784788-9738636875028408-8283953903100750-8844231023249344-8956740811309840-9405163247624928-10077587858213910-6046929072000000-7503138236928267-6047681832994032-9968095983067003-8064579541943808-7841051415058750-7617495423755488-5713477119412893-7730479516028928-9747732925819623-9076040252541000-9188661898270342-8853042211666112-8965663903967760-7397132980006704-8966779707070000-7734328717377024-7510612567298971-9080559255114792-5829857534147868-8745330379344000-8185241500543853-5718812163689448-9980508777835463-8411064343756800-7962969598734375-9085079757461256-7290949631750395-7740104914836288-7291856748344285-7404499724622000-8190334886658543-7293217564305920-7518091859777579-9089601759829224-7294578549561875-7743957310409664-7295485967123445-7408184930339952-8194411116542087-7296847234560000-7521833367321907-7859120597194160-8645570272177839-8084672331176448-8085175078041000-9208688657656752-8984645149217840-7749738300200448-8087186273921928-5616450781250000-5953807997734303-7864008920530560-5842198413494404-9213270284667248-8989115214510000-8203077595168768-7978831754172103-5619244919475600-5956769907012887-7867921038320000-5845104678586212-9217853431099696-8993586762195760-7757450761038336-9332006313798875-9894790372288448-5959732798458639-8209198787052736-7534938419090303-8322688038942000-8998059792520880-8436205336473600-9786606381450279-5624835975741200-9225304285343750-8775834784748928-7426167819175578-9452073655999968-5964178977546867-7315013650880000-7540559526326747-9229317946304976-8667093164051399-8104798466661888-10019053919872125-7655483113200608-5854556696346956-7318650548551680-7656910102986692-5855647969028000-8220939581550483-8108827697742336-8221961048912261-7659288813340512-5970110655435875-8223493408598528-9801210529584351-9576490170365320-5971594189169647-8901608373000000-7549934249598367-8339251284050992-9015966745130160-8452993799884800-8002664462056375-9806690828585592-7890930935331010-9018766850728960-9583034875248465-5750177997741000-5863290675020012-7329568473976320-7555562811419899-9247680936217808-9135471572125875-8910457622661184-8347022864054962-8573150361020832-5753392316333709-7784484667392000-9815829199274007-5641631394112400-8801491379792826-8914884445941696-7561194169984375-8351688128858224-9029412539342640-8465599753766400-8014598592385519-10047092300793000-7902697953408370-9032215428029440-9597324580073145-7678336234011872-8243431413662375-8243943067865088-9938520786370264-5647237287523600-7454815868426454-8923742490616000-8924296313149859-8585931798144288-5648989890480350-10055826009150976-7683579805126500-9153067434584616-10057698176335147-8137069712653824-9606858937466665-5764473026625000-10060194760692039-8478218234265600-8026544581491367-9835953594330168-9723499901143250-8706464466855232-9498550501044612-5767334872434312-8594992998053204-10065813585984000-9500907802670004-9501497189009952-7352805106929555-7805769600025536-9050729042170000-7693596887048928-5657407432343150-8034016849334272-9845110132184583-9393043952999000-7469630742341526-7809643751464512-7357367060622605-7471020642203184-8263914099609375-7358736014589440-7585629058628411-9171254589798312-7360105138356035-7813519184568000-7361017981872165-7474727884731888-8268014704045751-7362387388661760-7589392938263875-9175805139852936-8270065514852019-7477509121306752-6005038705657057-7705055636892000-8272116664754383-7366039970398720-7593158062748619-9180357194905704-7367409999941875-7821273896616384-7368323447340245-7482146048572272-8276219981959527-7369693760000000-7596924432288467-9184910755205448-7371064242543755-7825153175985216-7371977991958125-9300610175208112-7599750026634581-9868943721798144-7714135211971172-9302916016322000-10097693118497259-8169426509078016-8964231782098763-5787394319079144-5787752945542125-9419867876589568-8058458573467623-5675322464531600-7491889834707894-8968120739352000-9082203945796880-5790263745619848-8629162927185492-10105830025243136-7721786700062500-9312143191927632-7382034219981395-7836798710013888-7382948875743285-7496997097062000-8292646820230343-7384321001041920-7612002365115379-9203140053850824-7385693296336875-7840683120704064-7386608254314445-7500712927202352-8296756923281887-7387980832960000-7615774963018107-9207701144117928-7389353581629955-7844568814754496-7390268841873125-7504429984955376-8300868384175479-7391641873940480-7619548807210883-9212263741125000-7393015076060315-7848455792377152-7393930638619005-7508148270523824-8304981203135375-9670782316239360-7395761990499545-10013343831736256-7396677779827635-7852344053784000-9673776304675385-8650029569581728-10244090194996230-8081949207015424-8196286820013000-10245992729282640-7969598746449410-8767101262860864-8312181904836757-5807500224573000-10135284541608879-8313725453653504-7630877819587739-9225960575074344-7404006816171875-7860124428798144-7404923285976645-7519310496149232-8317327810655447-7406298132480000-7634656650998947-9230529201529608-7407673149148155-7864016542829376-7408589921468125-7523033695006896-8321446064123119-7409965221767680-7638436729729323-9235099335969000-7411340692260115-7867909941492672-7412257767145205-7526758122693744-8325565676778375-7413633521315840-7642218055984691-9239670978641352-7415009445707435-7871804625000000-7415926823207565-9356055604724656-7645054869488309-5933842425059328-7646000629970875-9244244129795496-8331747644728539-7875700593563328-6163972966956366-9360685978182000-8333808980548663-7420973751992320-7649784451893699-9248818789680264-7422350584406875-7879597847394624-7423268567286845-7537938780756912-8337932672112207-7424645683520000-7653569521958987-9253394958544488-7426022970058355-7883496386705856-7426941255703125-7541668125788016-8342057723760359-7428318826106880-7657355840372563-9257972636637000-7429696566843915-7887396211708992-7430615155303405-7545398700662064-8346184135717375-7431993179952640-7661143407340251-9262551824206632-7433371374963235-7891297322616000-8578027230331575-9264841984123128-8693475411284532-7435668745256960-9495363798725875-9724768695403560-8352376304722579-7895199719638848-7666827099280983-7552863540750000-8354441041455023-9728374913671680-7783180829369636-9271714728772584-8356506118432875-7899103402989504-7899591453863817-8701536867940512-10305088194679110-8359087943168000-10077331297658328-9390820649306896-9849517907101042-8819299198721088-8819844014683625-8705838348497696-10310182263023670-8134090654556672-8249164833888648-9280883674233000-8364769829359003-7906914629522112-7449002828053605-10314640949690160-9169136008750000-7450383125053440-7680099977694211-5731771859827600-9859256445534354-8828018946824000-9631160860183044-9631755621042912-5962883584906924-7683420589127168-8142635042715375-9748826991594760-8946534807444234-8832380975377344-7915219698272361-7571547177414000-8375107126902183-5736728914534400-9638299606643988-6196432282303536-7459128965916875-7918641122078784-9640679972462532-8723058446562592-10330575323921910-5739562800000000-9987455756244687-9299239695799848-10333126345700430-8955928944523392-7923041544113625-7579029250915056-8613064822840725-7465116904161280-7695287728945443-9303832479861000-7466499191003515-7926465221428032-7467420810355805-7582772135369904-8387523121611375-7468803381578240-7699087792774571-9308426775887592-7470186123442835-7930379203032000-7471108046158965-7586516251897968-8391664511766791-7472491072450560-7702889107421875-9313022584128456-7473874269412395-7934294472871488-7474796495542285-7590261600702000-8395807264922143-7476179976977920-7706691673093179-9317619904832424-7477563629111875-7938211031158464-8629022490813975-9319919132435832-8745154862725044-7479870095360000-9551807845813843-9667486098924192-8402023950770611-7942128878104896-8287949947401000-7597755995948976-8404096861129679-7483561427796480-7714300558331083-9326819084625000-7484945990499315-7946048013922752-7485869127170005-7601505042797424-8408243704630375-7487253974487040-7718106878309331-9331420944211272-7488638992586635-7949968438824000-7489562432870765-7605255322732848-8412391912028031-7490947735631360-7721914450134875-9336024317255976-7492333209202595-7953890153020608-7493256953150085-7609006835958000-8416541483546903-7494642711429120-7725723274013539-9340629204007944-8418616780921875-7611821280345216-9111680959513907-7612759582675632-8420692419411247-8421211382336000-10152222907661208-9575982162857144-8999670344182986-9115612442922816-9577752614987375-8770530769617056-10271386028304567-9348691398930432-10041805776888903-9465273686538000-9465856894676422-7965663033502272-7504347803456205-7620268777399344-8428998385073375-7505734928739840-7737157260026491-9354452948995752-7507122224946435-7969589907000000-7508047184046565-7624025225810928-8433153415319671-7509434765148160-7740971094175875-9359063893065096-7510822517200795-7973518070852928-7511747780213885-7627782908526000-8437309810808463-7513135817208320-7744786181407499-9363676352085864-7514524025181875-7977447525273024-7515449592157845-7631541825747312-8441467571764007-7516838085120000-7748602521927187-8096053368413360-10294187394906963-8097050419319680-7519152620078125-10411775424105840-8561320214827142-7983344127180288-9603744322732587-6248603877318000-9836370901160735-8911143385695936-9953318312599982-7870550133141472-5903275982734125-7755761539121152-8219298006260263-5904366220846872-7641414858489654-7989243634056000-9147668056108659-5905820080458888-5906183582648757-9612615868227072-8223346173647375-5791445273246800-7645178252495718-9151609883714368-9268023386699920-7878304687500000-9269164136700080-9153862864965632-7763880421003059-9386761380170184-6026439846381500-9040216010686848-8461235590348789-5911637905511112-10317022480943631-8694655003200000-8231446495590751-9391382934124968-7536758614511555-8001051365574336-7537686006313125-7654121265060336-8466442824857399-7539077236654080-7771526895620803-9396006004773000-7540468638170715-8004989859899712-7541396334284605-7657888829502384-8470610150359375-7542788021117440-7775352014920011-9400630592363112-7544179879154035-8008929646488000-7545107879630165-7661657630072688-8474778843122151-9868500030115840-9404678351066625-6154056851217768-7664013758240598-8012870725551168-8594041962287106-7665427666974000-6155949203816563-8711784510681600-10106291397193359-10455427021516560-8597213000430750-9178670067924544-7668727463599818-7901598908300256-5810356391319950-8251213312000000-8251720569114471-9646970581725464-7555320908045755-8020756761950016-9764999769850500-8835542882486816-10347521757840927-7557643335457280-9651122367347707-10465715685690000-9536015933329942-9187701968942912-8141502103265790-5932030380034344-6048716426655500-8026674683572224-10237547562397144-9423776293153992-7679104417859094-9075862923504000-7912776975832948-7913263217760864-8612021492514758-9427251421638144-7798329091546875-9428409987622056-7566472900043395-9080325365245056-7916667469021652-8848583737412000-10362793910976999-8733228013977600-8267963775813127-10481161334193360-6172618636892375-9084789269482368-8269995674169963-7921045797920096-8503997994601487-7572518141760000-7805998164250507-9437681932858728-7573913654651955-8040494486095296-7574844091823125-7691852559582576-8508177633523879-7576239890452480-7809834585371283-9442320184125000-7577635860538315-8044445912588352-7578566602521005-9561240371868848-7812712725967125-10145488748923392-9796245822618612-9213701684332248-7697995582449414-8048398633464000-7582290332589765-7699413667435248-8516541019430231-7583687045775360-7817511198179875-9451601245197576-7585083930473595-8052352648934208-7586015282229085-7703196078798000-8520724766862703-7587412452805120-7821351390279339-9456244055501544-8522817154296875-7706033700114816-8990924488864241-9575338450836464-8524909884247047-8759006630400000-8409162454692552-6073656741618336-8059769918015703-9111603420746112-9345807804330000-5958318113453256-5841846830005150-8062243352851968-7829035546897723-9465534236889000-7596265183778115-8064222465031872-7597197450567205-7714550745064944-8533284229768375-7598595993763840-7832879511828291-9470181608470152-7599994708585435-8068181661000000-7600927280485565-7718338111889328-8537473458353871-7602326281372160-7836724734780875-9474830500974696-7603725453911795-8072142152622528-7604658330972885-7722126718086000-8541664057788263-9946383263354880-7606524313992305-10181664686107128-8543759871643875-8076103940111424-9715329538230679-7960035247610976-9248255153909161-9717117123904000-10186036554254607-10303749268863424-9133428728304426-9133988809375872-7846343297359375-7729707649407216-8550049370100759-7613524468858880-7848267953828963-9488786306517000-7614925015001915-8084031403536192-7615858807845405-7733499974937264-8554244083427375-7617259640240640-7852118210927851-9493441285203432-7618660644401235-8087997079896000-7619594742605365-7737293540650608-8558440168499911-7620996033064960-7855969727077875-9498097786057416-7622397495317995-8091964052970048-8796152191076175-7623799129375000-8914526843030676-8093948025841152-7859822502484859-10558617565919760-9151362681542250-9151923495531648-7979088905197524-8918351725777312-6219757974018187-8802083635200000-8333149763465351-9624790853476496-7629874862502555-8099901890108736-7630809877088125-7748681680917936-8571036656435599-7632212542190080-7867531831893003-9512076424113000-7633615379169715-8103872754597312-7634550699315605-7752480209391984-8575238230734375-7635953822781440-7871388386305811-9516739016125512-7637357118153035-8107844916648000-7638292743909165-7756279979063088-8579441177900351-7639696325813760-7875246200798875-8228373076647920-9521986253105043-8229380961639040-7877175580639823-10581928622910000-6114377615126092-9760084988821504-8349499620388647-10114097707093424-10114717026039250-9291995037802944-7881035285639191-7763883242807472-8587851191730927-7647185000000000-7882965610849067-9530735933628648-7648589670996755-8119769190292416-7649526213883125-7767686737286256-8592058258844039-7650931171553280-7886827206817843-9535404620781000-7652336301241515-8123746544711232-7653273149937805-7771491473773104-8596266699721375-7654678566346240-7890690063690171-9540074832340392-7656084154800835-8127725197752000-8835024587719575-7657489915312120-8953920754912692-8129715011321856-7894554181671875-6009655246868376-10488079348258787-8367406748166592-10489362947973621-7779104673582000-6129366583433132-8369454905814528-8369966997444527-9667313901646928-7663583532661875-8135686400547264-7664521299087445-7782913137309552-8608900267181287-7665928092160000-7902286201786707-9554094615949128-7667335057362955-8139668950725696-7668273129798125-7786722843856176-8613114205358079-7669680381908480-7906154104331483-9558770927625000-7671087806177315-8143652800373952-7672026184672005-7790533793424624-8617329518420375-7673433895895040-7910023268808931-8264708809217840-9564033601902699-8265719659120000-7911958324336727-8739115196668272-9093959697364619-6141750907455488-10276250022417375-10040628282657160-9686845417068566-9333019239352128-7797682674903594-8034467283724000-6026218873630461-8153618111066112-7917765384385139-9572809017555144-7682353399296875-8155612148257344-7683292696269645-7801974102288432-8629983709162847-7684701785280000-7921638335895547-9577491433328808-7686111046561155-8159601197904576-7687050649793125-7805790025971696-8634204524009719-7688460198215680-7925512550161923-9582175375749000-7689869918937115-8163591548081472-7690809828478205-7809607193690544-8638426714863375-10059056709122560-7692689877318745-10296998685439704-8640538326362827-8167583199000000-10180508307647886-10654671280428720-10655322265415430-9827175355379712-8406892515116375-9709962012407312-8763183986875182-8171576150872128-7698331862131885-7817245262046000-8646875225488063-7699742789240320-7937142771555099-9596236365377064-7701153888731875-8175570403909824-7702094717499845-7821066163088112-8651101545707607-7703506104320000-7941022038903587-9600926416871688-7704917663551355-8179565958325056-7705858798828125-7824888308976816-8655329242830959-7707270645434880-7944902570037163-9605617996257000-8657443607801643-7827755735445888-9132939325944049-9726581202924528-8659558317082375-9609137683623936-8067422937776004-9966248552070048-9729550909554758-9374164011576000-10205409154679006-9968682609588192-8663788768686111-7714803406568960-7952667424482875-9615005739695016-7716216345468995-8191560431955648-7717158400571685-7836362217750000-8668020597866423-7718571626987520-7956551748206659-9619701904245384-7719985025926875-8195561194000704-7720927387738045-7840189345052592-8672253804847567-7722341074240000-7960437336538827-9624399597681768-7723754933293555-8199563258483136-7724697601863125-9745597771116272-7963352357811021-10578829932597248-7964324189685203-9747976583466000-9154146264895247-9273597055042944-7966268090628039-6064245669841224-10702262901093750-8205568797740544-7968212307851611-9633799572207912-7731298429552035-8207571295608000-7732241711788165-7851678202933488-8684961694838551-7733656778997760-7972101691243875-9638501853795336-7735072018843195-8211577268674368-7736015607987485-7855510314894000-8689200415265583-7737431135582720-7975992340067819-9643205665264104-7738846835841875-8215584545025984-7739790731944245-7859343673525872-8693440514614727-10123116480000000-9647322755475681-9290580969571824-7861740155836182-8219593124874816-6313985468376625-7863178279031856-8697681993110239-8459905089290752-8579581721015688-5958406098050000-10249083280360066-9177064226801856-10011953104154148-10012563440236896-6198631400695500-7987185006149632-8464547814393223-10134231282999720-9300214386095802-9181540479496000-8228115686039409-7870851231477168-8706169088437391-7752540842242560-7991567593796875-9662036214929256-7753958384905395-8231626687524288-7754903509339285-7874689578822000-8710414705717543-7756321339985920-7995464572866579-9666747679537224-7757739343436875-8235640483481664-7758684775078445-9788475640240304-7998388138407573-10386599489088000-10029051891979764-10029662922760992-10627314096119723-8597901478952448-8001312416535375-10748686386504240-6210730468395596-8958330025574400-10392295862916663-10392928921875000-8362636097217570-9199460046007616-9438981976864883-10036997228081376-8723159838715375-5975130928460800-10038831362917812-9919925614765496-10279103154164194-9323475312528000-7889574961394346-10041888750829152-6097232326756797-7771455621263360-8011065157869875-5978770897654800-9327450562338714-9208428566016064-8371808447247630-8133109126844000-6100203265205061-8971433382873600-10407496374519279-10767031086854160-9810558939093750-8614673776553472-6461398696514382-7897745871374832-10770309121017510-8736449232896000-8617296416762952-6463365756503472-10653232782588643-8618870256357888-8260253457464625-8141035167584608-6345604822793859-6465726755417088-8022778904546123-6466513882806000-10658421571676219-9341657106996864-9581769916540560-9103235426317984-5989335167368750-8744961524502528-10542512985054424-9824303121430544-8387110597452930-8747090461000000-6470844225366654-7909290875086128-10786052946701430-8749219742991872-8629892499429000-6472813201809264-10668804203832427-8631467872280064-9950769753482207-8152933881388000-6354879196563243-10672050158600192-10073109573012948-10073722391976096-7795616551506875-8275850228668224-9595772379041040-8156902694209376-5998087416437950-8517802235328000-10437941849975007-9958642197542584-7919401978043622-8279878386411456-7800359853203125-7920847124386416-8761469820601159-7801783218810880-8042327180565363-9723404773197000-7803206757559915-8283907851043392-7804155879587405-7924701707452464-8765733395937375-7805579706928640-8046240642355451-9728136165080232-8767865702200987-7927593465264000-6126240153899871-9850632096194416-8769998354232311-6247501941178368-8170306946226500-10814298990636240-9853626998203686-9493705586143168-9614463540443920-7932414624750000-9615632543244080-6250541102114816-8174281394678436-9978038208550712-9858420103937750-9498323521491264-9619140120183440-7936272959386992-9620309502022320-6253581248512000-10102552927562004-9742339549380168-10344347191262642-9262362119821888-9984711399276375-9143182930552096-10707799124533807-8783335264974336-8663542049549448-6257382817556000-10349377367095746-9266866064367296-10230278942939945-6138540340366824-9148184570312500-10713656545214464-8186212473103044-9872208940568464-7826006933351035-8308112095368000-7826957903267165-7947855469683888-8791343897936751-7828384502581760-8069748076488875-9756556751880936-7829811275234195-8312150714155968-7830762553306485-7951718809254000-8795617158693383-7832189614878720-8073670427997619-9761298891253704-7833616849816875-8316190641528384-7834568436095245-7955583400564272-8799891803978527-7835995960000000-8077594050289467-8439789872696560-10731241623070603-8440814948388480-7838375551833125-8924230970340784-9045377911660725-9045927159398400-8563997686469959-10012041798543000-6393619692117143-9410049347597184-8204130849983796-8204628955556192-6153845310967125-8084954267960832-10619689097134744-10861705031636880-9896820918218838-8328318277272000-8811654219318653-10864342754950320-6277556856998284-8330340695494656-10624847520375000-9780282814742856-7969603040353878-9419193455158656-8212102958680052-8212601386876000-6159824876429541-8092810093421056-10509212072719119-10268244126672840-9423195864254250-9302950194526912-8457740682751710-8216589538505696-6283655642758988-8580127371264000-8701502218064712-10514953184723256-10394722350552402-9428343484589952-10275100287670625-8220578981060448-6044910111881150-7858859931220480-8101162482011883-9794536898625000-7860290404255315-8344506791305152-7861244149374005-7982670605491824-8829853106610375-7862674911703040-8105095005548531-9799291335772872-7864105847622635-8348557194984000-7865059901346765-7986545218022448-8834138836196831-7866491126607360-8109028801514875-9804047311262376-7867922525486595-8352608909155008-7868876887866085-9927492862086000-8111979983645437-6296246860906496-8112963870116739-9808804825342344-6297392350437500-8356661934030144-6540392859893982-9932309889794864-8842714455234447-10539216487104000-8238047975911588-6300065699624736-7996722040664742-9572414279940416-9815348919889125-7998176577814896-9574155387199937-10301930927493120-8242044360767492-6060694117450000-8000601198332886-9455829123272064-8728986745883304-9214488964279584-6062531248118750-9094348078195200-8609838010139583-10308177297989320-9459841903082922-8732691000000000-10795230604966589-8248541242392544-6308090286499404-7885590724444160-8250041007458500-6309237212003232-10799156539889027-8615579525820352-6067677188961450-8009819225166000-6068412560991550-8860419193158144-8739573109106184-10075396112525752-8497836876611250-9469591951567488-10684289499084344-10199257876065888-8864177779171207-6071722470400000-10201111724811924-10080280560925784-9959434707130694-9474182526886272-10932411292031250-8260544453443168-6438755536887699-8626025183662592-8748048359728008-9842150525337000-8870623542145243-8385069825676992-8507107805170590-8264548109960672-10939034988483750-6563818503143424-10575681380452311-9968487275087504-9969090974581158-9483368127792000-9970298446688522-6201414794932488-6323394059112364-8391165595101696-10094332142950875-6567794486460144-9852288259616163-9366322600603584-9001945962795026-8272559303500000-8881373423074023-8395231082237952-10099222708936291-10099834140727512-9978753481567750-9370860181114432-9736548032935440-6207425130704712-10833221188165231-10833876978624000-10591060148456847-10835188638937192-9496582827930666-9618916089933376-8158308696287375-9011214702358704-9742443373381040-9134093473382400-10596189715569783-10596831027891000-8526701903748770-9379939738188096-9624156948145843-8284585798203232-8894284739859375-8163741641723392-10601320938683871-10114515908229816-9018306853333886-9628234487048000-8044328198936106-8288597218445024-6460621074429211-9874376799105024-10728367080343000-10119412990690648-9998097222210246-9632895941572288-6341023973620388-9999911978478000-9756601898565680-8903437822836224-8660031875090847-6098982923829200-10002937060229750-8783597985172992-6588096978555342-8052605591922672-10981490010191910-8907747328000000-10738755863334488-10739405384858304-9885732381117387-8787849141662208-8788380632649000-8056502799643056-8911519285562639-6592481425640448-8668416438520559-10378309232885000-9524200864318218-9402664285547456-8548393517257790-8304655848352992-8915831397886375-7939234015498240-8184012960263571-9894703461419592-7940674224837835-8429840753832000-7941634461153965-8064300986929968-8920144901017791-7943074960770560-8187972248046875-9899490255996456-7944515634567395-8433918722359488-7945476180537285-10024129716454000-8190942551741597-10636642947465216-8314200466501316-10026553638512528-10883136725935875-8804867484344832-10395263489017505-6237535067265672-10885768098266591-9173954500800000-8685201797602191-10643073548404056-10521375179160802-9420870326712768-10277934156934500-6240551404944936-9300207199589748-10891690236735488-8322243709638532-10036253234250000-7956047296694315-8446160518450752-9793241565446160-8324758286521952-6121515634318750-8693077388161536-10652724308686191-10163557881659896-8082353564879814-8450243748024000-7960855447465765-8083818467044848-8941733286639031-7962298270351360-8207787842359875-9923447387363976-7963741267557595-8454328293388608-7964703362545085-8087725738158000-8946055139325903-7966146650309120-8211754793742539-9928243447075944-8948216587796875-8090657017593216-6252248898238383-11034046729237680-9072986307464086-6375997016064000-8338345754800388-10791452006945984-6499789699234311-9566305853949312-9076274084565250-8340863573978208-6501359728342259-7973847129863680-10796014070139672-10796665898392000-6502930010257663-8589294026732160-6381003637608964-9081207239306416-9204481903303125-10923311253192704-10678488187272951-10924630122018888-9574972904569722-9207260475000000-11049379507719090-9331150354367008-10313999232761868-9946242433718784-8227635381200875-9947443139013096-8965520710325739-8966061823312576-8475282248040201-8230118570937000-8967685292907463-9213931328409600-8723048051416887-10443715910539240-10075722169271750-9707683964001984-7987816894512845-10077546306287024-11061388976576310-9464203829696000-10693966435615407-8850713120283456-11064058928646030-8851781187030528-8237571137859375-11066061674625840-9714129061283057-9714715120631808-8239559248581763-9715887310043000-10085453444161062-9717059593742272-10947727514109493-8365060431365472-6520219802439875-6397582672013312-8243536429623051-6152263930763600-10582532231856034-9721749671496000-9845403582081680-6276823338750888-9108096887780118-8000837885480960-8247514890297875-9971477542047816-8002285535121995-8495246162192448-8003250731888685-8126867718750000-8989350283957823-8004698672555520-8251494630812059-9976289063558184-8006146787851875-8499345195251904-8007112295071045-8130788848215792-8993687465130967-8008560701440000-8255475651371427-9981102132616968-8010009282466555-8503445546646336-8010975100188125-10106762448141872-8258462256944421-6409939177867264-8259457952181803-9985916749473000-9000195852293803-9247333931073600-9124586106315858-8261947540407208-10112246753468750-8756253576400896-10606805550397238-8510624334467688-8141087813505174-9128436452048000-10485998109955985-8265931922064456-9006707378613151-8020154240949760-8267426395378875-9995550627572136-8021604219616195-8515754512959168-8022570969144485-8146485978774000-9011050140508983-8024021239070720-8271412538177219-10000369889312904-8025471683766875-8519860139813184-8026438743997245-8150413415601072-9015394298146127-8027889480000000-8275399962049867-10005190699846248-8029340390800755-8523967086062016-9265739725134375-10007601685987896-9390414092231668-8031758963937280-10256556110116707-10380754283844000-6426568272734012-8528075351917632-6427342418161444-8281882258664648-9024086801541375-9271880412787200-8777908722727423-10756676743714584-8655318575418130-9645078625104000-8780023329440931-6307157094972648-6431214077847884-11007933044391936-8782138275734375-11009258715745864-8040953971198395-8783724708320192-10516359897732065-8413594445916000-9032784890592943-9775794079811072-8291362472399979-9776971177230616-10148859499145750-9654374339146368-9159829595424722-9407958858483872-11017878173927991-6190191795200000-10771582067337927-10276955474422104-10153747865368774-8668355262250880-10526493502220625-8421701654846048-6316656396189573-8298851959908864-10776769753513263-11149053446250000-10158637801048182-8672529765074560-8549150933969913-10408288320180576-6443613836471500-6691847800356864-10781959105043991-6320839108572312-9667747389048762-9792282043224000-10412673219008004-9421556901866528-11033802837299583-8058880172495360-8927296652853000-10787799116468952-10540437834775855-9548971070102464-9673565608348902-9426092493028000-11039114466294679-6450207686148096-8807544128414807-11165164145966160-10669576394531250-9553567445989952-10422700469087172-9430629539595552-6577018802057267-9804070503488000-8315344705144347-9805249869600472-8192220415393542-8565109161898176-8441484791580500-6331494343841256-6456029523169356-11050407337361408-8816023621548199-11051736416541000-8071978255573115-8817614132160448-10556933370621345-8446054526210912-9067633139243375-9813508080735744-8323349047237291-9814688203564568-9691034271336522-9815868421000000-10313494441915183-9444249414069408-11184651939359430-8575415324553216-10813130201658375-10813780237539192-10690126502925298-9571967699241024-9696861828921462-6340636927821000-10941364495162728-8579540103378432-10942679852851736-10321557027407352-10197813817141750-9825313566776384-9825904089478827-9453336611696032-11195413525670310-8832468123648000-10823533902155607-6220795606272400-6594439611353751-9456745813037824-8710684032968750-10453448963561184-6471571545971116-8089950519738880-10953206509703832-10455961711188000-10083140319540771-9461292689703168-8092381248200405-10209463555225328-11081668879308375-8840963603787776-8966022847196616-10834595143465464-8219841822919254-8843088324664000-10089199777514301-8221323290722608-6602368319734771-8097730564584960-10340800147440875-10466016728373024-10092836617290963-9470390814913792-10717138541492014-10219280739750000-9596730222491027-10095867984642048-8974643849724744-6606731817041192-10721001114663250-9848952934870464-8478088854393524-6358948490821512-6484023108216108-10350119914688000-8854248694438351-10351362973245624-6610303380865391-8606383410380736-6486359552770500-8357926615166632-9106944421926599-8358930289004544-10854785038458183-11229762147570000-10232175342300102-9733629171087744-10108606355755677-8237136691239984-9610569717546875-9111866306190848-8987585712323976-10236475952326864-10611618121962815-8989204319424000-8740028790019870-9489743693156768-6618244797289611-11114323417235456-10865215435956375-10116497381177736-11241227281302270-9867891706263488-8119638679663485-10243851229918000-6371558119612821-6746760518372352-10870433139420159-10621175458981640-10246925307489750-9872630189594944-10123177609347813-6374235030599592-6374617507649949-11125000000000000-10500630012600084-10501260050400672-8126462587751755-8627070165604416-10003000300010000-8503060367214688-6252625367517150-8879260681636352-10880873557113423-10381226245083000-8255446197987846-8631211490519232-8131339147892805-8256931940581104-9133214963996375-8132802496266240-8383545404779171-10135938937072392-8134266020195835-8635354140552000-8135241800351965-8260894792302768-9137598293438191-8136705616898560-8387568782296875-10140803214823656-9139790483986859-8263867763048832-6386098934893839-11270262152430000-9267215669304534-6512487988903936-8516841110243716-11022455262658752-6638922241022375-9771075166839168-9270550199648322-8519394732531296-6640514595093907-8144515604160000-11027082195265048-11027743291319744-6642107203763871-8773120333962880-6517565799738500-9275553494802864-11156401999390247-9151305236873216-11032371703553112-10155405385125000-10281397003177382-9655061242026816-8150864897427005-9280002379252336-11287165852473750-9908217175473664-8905387114998703-11038324421969856-8781011564876530-9659691596632000-9158438261519613-6398744418754728-10163320743603807-6524991962431488-8533193113674500-10290643602374672-9663744371108751-9036769961839104-10292493587237738-8284698532638000-9163927725077503-9164476792047104-11048250377033496-10672244853444040-10798447598781250-9794527613440128-9292800845683442-8539842089069536-6405265268794989-8164062433280000-10425504228559603-10551744768714912-10175506247664747-9547960483445504-10428002502222375-9297812142668144-9800983608663234-9173264846547456-8545470842137892-6535163217908000-11185853118417819-8924080196886848-8798915870804990-10559331403369056-11314246914663750-9680546512924672-8926752770649783-10310388206377744-9808029747383322-8928356571000000-11192553775046789-11318990549508720-9684605118089979-8427368776165888-10943656476963375-10315328300463312-10315945923153526-9687504816197824-8429891990816943-9562838041156000-9940913611892849-8431406161330176-10571351010603348-10194413021405064-11327803674378750-8936913417223616-8308050626806458-9567418858470432-11330516325164310-9190857806144000-8939588552430831-11332551097426320-8185110128706355-9067126198076928-11082706421875000-8312527304424816-11335942925854470-8439484799709184-8565959884174852-6550831934244000-8692970271468279-9701431424297536-10332012767616234-10332631056100528-11341371258933750-9955799376321024-8444031300730651-9956990879017688-8318996455150854-8697653049336000-6681205702520713-8320489812577008-9203516630017111-8195402370088960-10969887141480375-11348838046092240-9836248073068794-9962949818501568-8323975008224634-8576729729500000-6559068026833452-8199325492267520-8956722060141967-10218843445233384-10219454705383875-9715371373124032-9968314896371547-9590344889367712-11231470359101431-8203249866240000-10475545562832323-10602391031528352-10224345664140507-9593786949631744-10478051824096375-6438706036689096-6439091088380613-10227403305672192-11111917429959192-10228626532953000-8334934815913926-9850966529698944-9093743605995624-8336430080089584-11115904721625000-8211102370365440-10485573006304339-6822346944946608-8212575272547035-8718485742408000-8213557305183165-10615077868799712-6571631532881324-9478881347212800-10996159687101375-11376017625137040-10871066662471458-9986809351329088-8217486218582485-8597268686412000-9229972475604583-9483415250841600-8978169712273047-11381458743124560-10876266160179250-9738634284574272-9233283016662229-6451035306481992-6704417745621747-8222890520000000-10500626166459883-10627774822762272-10248823866949587-9616755067614464-8984610677923875-9617904434778016-9745038088920211-8733088403324928-8986758350832359-11265764559229000-10760080941234135-9747949836865856-11014575406182939-9369279060825456-11395749931953750-9750279652782592-8611151002645284-10511297533699256-9878676962969802-8992666216008000-8359879238294826-8613723440791264-11401197339561030-9501565322956800-8995352464984375-10389619181340432-10390239765860806-9757271327831104-8363874958493274-6463380305517000-11279905966398799-8492121767840256-8999651575952927-11281927132948456-8240101787311875-9001264095642176-11030376663598611-9382719746014128-10017285462351601-10271500959744000-10652562996391764-11414141889523920-10780666594407095-9766598759362368-11162493624139000-11416868305824240-9768348314280171-8753977618856448-10657652509412916-10531404421875000-10405141208986582-9771264703431616-10279476521086437-9391687340242736-9899937085847250-10027457927000064-8504807429747731-10028655140107448-8378870248582614-8760250872744000-6729290004267793-8380370762592048-9269751228525631-8254380731983360-11048830555287375-11430506899898640-9907030565964714-10034642635057728-8383872658597194-8638444918444000-6606263874730572-8258322652037120-9021167678445607-11054766531461688-6607840956437500-8768619872295744-6608629591404516-9532246056371400-6355209893381950-10041830774208000-10678026772395444-6483474502314168-8772282985047903-9917085461891712-9917677138131750-6485021932476456-9410201045252822-11318349428420608-8902603660129830-10302198790509000-10811594277334535-9158602643790336-8268676162744205-8396387393604144-11323076568591375-8779088615069184-11197186664230424-10561612806278136-9925963076710122-10053818633000000-10945316098197486-8654952153765344-11328480625963303-8274102882140160-8529199302215875-6365453702630800-10949233300462098-9803967928994624-10695875538904836-8659082245788000-9296333790806863-8278051078136320-9042718047015087-11208544191604672-8916419050411250-9936030776450688-9936623205991014-8663213651505376-11466701695058310-8536831315456000-9047032235057431-10321877464886088-8410920081185622-8793758848443456-8921736465468750-8667346371126368-6755834438736499-8540903583465984-9051347795051519-10581783787771000-8414932047369606-10073019045355072-10966218643739182-10711828735415136-9309644108212375-6376848616652800-10713744184311252-10586830542801176-10970140831306834-10077822965016000-9823273598740217-9696276429728288-11355526705621023-9825029915283968-9187588426581000-10336652904560616-11358233678741147-9955000204046976-10210865012683920-9700899758500000-6382551169677550-9319079932637184-9191968944262344-11362971916805896-6767116769910375-9959746330405248-6640226468163236-11493384343444080-9450679002952646-8301766632640000-10601348901258123-11240653955337664-8430992670021702-9964493965026432-8687512201644500-9710150824520096-11499547750277670-8305723623342080-8561794284358403-10351442437893000-8307207818962715-8818945826440512-8308197380932605-8436518225099184-9331856193359375-8309681871229440-8565874486486411-10356375415422312-8311166538346035-8823148326168000-8312156414662165-8440538326635888-9336302845827751-10871684876963840-10360693056146625-6779622566360168-6652101212151356-8827352160763968-6908773878748926-10491725694158000-6525730088250021-6910007931159552-11133453340215759-10878159457853640-10494849161149750-10111493175431744-10368097517582613-6528450005884392-6528838627231149-6913299456000000-8578122870290467-6914122500499632-8835237949257063-9860200222123328-10885284465310625-9733304216579616-11398889914453727-9350207738763776-9094578900322959-10376122997601000-10376740513699011-10121126991227712-10634221930984751-9737939307203744-11532456470103750-9098368157782016-9227063222043336-11278192783847616-8971823539704130-9485063522512000-6921944681496894-10511726595618736-9358557297698591-11154012708377088-10770032323312500-10898895390245960-6667956214633116-8848391364189888-6668749625386628-10644983604081000-9876054204400307-9620105566617600-8722747908226116-6414166757325200-8338912794086875-9237499004293632-11162641905900411-9495225686447728-11548934347906710-9881342639168000-9111909812044591-10780928839874592-9498049797334718-9883693660485568-10782852517174500-8472745123691376-10142222292505217-9115703881592832-10785417776183316-10400842756125000-10016221946940378-9888396821796416-8861557827367713-10788624922039776-11431484667227375-10661456673161728-10790549514695412-11433523899800168-8864719720827951-9893101474872000-11178584422629747-9508786525623472-11436923159653383-9638429572300800-9124922434918375-10667796991359768-9511613324619662-9126549883329472-11441003160742101-11570241494070000-10028138689694658-9385867161045504-11186561370122079-11444403902781736-8358769309921875-9259494786012672-8488374700167978-9775073017966752-9904281006022403-9904869635584000-11191881442813767-10806596688734112-10421266088315547-9778559135272704-8363738359218125-8492915916622896-9780302504699028-10166971187327488-8623133500371323-10168179479271000-9525189758537054-10169387866943552-10298726173852560-8754437364857312-6952466252018250-8626720636403712-9142291862056583-10945647549009320-6825338643279447-8886346125000000-6697354346878052-8629796116102536-9660793396014525-8373184977564160-10692548250622875-11595018145879440-11080342139950498-9921360733631424-11081658485911694-8762762040268000-6572461880724381-8634923539787776-9150984835254487-6573633025033944-8507559742497750-8894795229378624-9539912133842562-8509075581060912-11475040911403951-9154789743168000-11347455466226968-11606041335298320-9027457068396690-9930792431392448-10447298064703125-8771091991347168-11480493208473287-11481174867017728-8643644820454563-10450399994037000-9547845846475534-10193575729332672-9032818533860590-6581444209338504-6710890517779500-9679743629299200-9293105534699016-10455364357990632-8519691492894054-9036572822480000-8391601431877365-8521208772125808-11491402983317623-6714476672237568-11234502759690375-10976889814563560-11106688871489778-10074106392994176-8912238417721281-9816961144500000-11496860461639439-8397081796779520-9172741372828767-10465297801948584-6718861484601500-10078890297810048-10984057863488905-10855477780653408-6591216888170829-10727518896128000-9177096814302151-10470266882450568-10470888128087307-10212953610685376-10730701821306375-9826285838833696-11637081507083670-9180908956380672-9310769882640648-11380504976984000-9053211462358770-10088462650441344-8666244811328639-9572241178422576-10348982708750000-9702746812723200-11255853936152871-6469265285027600-10610224380872198-10093251098736000-8540949798014106-10870944481938912-6859455119780211-8413038242485760-8672415274758875-11391310535444928-6861082543436159-10098041062002816-9580760943998706-8804464585772000-6862710224478763-8417030509854720-11396040117251416-11396715878643392-10620296780379750-9325691575828992-9326244537084456-8549564393514672-9456897060241327-6995927664000000-9198894703457871-11013414195212680-10107026327285706-9978040591662528-9071483763658750-8812820940261088-9461383342893639-8425018833121280-8684764987107443-10500114400461000-8426517206193515-8945602346644032-8427516220265805-8557677537785904-9465871044161375-8429014889418240-8688884161752571-10505094494951592-8430513736232835-8949844984632000-8431513066148965-10637308405831536-8691974397342589-11287262495244288-10898692382812500-10899338244007584-11548792709927587-9343397179666944-10252390505646931-6619024037397000-6619416244869141-10773413780985344-9216357846015727-6490777412005200-8568333826659750-10256643601097024-10387089905988240-6622162130997672-9868904689101044-11557691490816000-8831118895681028-10779798404370904-10650552222211974-10131613244218752-9093012046028750-9872997890946336-6495778109501150-10004090842729984-9225097699170879-10525030619625000-8966297877067119-10396323421424640-8577474826475082-8837921724585952-6628833872830125-8449014125527040-11439342723018584-11700020654128080-9100554983882530-10141218944688000-8971609559879889-10792575217554824-10403098142739760-8973203473691136-10794492609858875-6893276926839688-8454519455912595-9235483449111872-10927134419737956-8586113960358000-9887625707890036-8457022669189120-8847870603642756-10539999254143944-10540623255046875-10280969569946304-9630845413266242-9891724084197152-6638260429038789-10804082977856000-9242593977958111-11326102465867416-8592724269491142-8983834390531776-8463533335993125-6641011523671656-6771628218820556-8985961580986368-11461035100483672-10810479711247000-9638829454613454-10030186394989376-10161049872679446-9901096053809184-11725676050713750-6514649977676800-11336161766421951-10424673653471360-9643393744475326-10295583597000000-9123208823547070-8863070125291744-6908389875283131-6778443948310528-11341529161278375-10820719735552728-10169470797972954-10039686926108224-11213820235371294-6650449618461000-11475964506637928-9781230190809600-9260112365013887-11738865005490960-8609010252207750-10305333971473984-8479573826867845-8871463514743776-9524340356682007-6523906662400000-11352269033116407-11483434069100224-9657095258946958-10310211466370496-9266687462796875-8875662195887968-9528847942112559-11618049625123328-11357641510632543-11097202541445000-9139413133752370-10053948968383936-10185122000261286-9924551872364704-11753453773383750-11623547124854784-8750828169592051-6530854927363600-10711235382140358-10189338527472000-8622257755255386-6663047649042888-6794097311165164-11629046358539776-8754968205322875-10846348082557688-9670809745521502-10324853184610368-10456165627179920-6666199640625000-6928028756881803-9281492810989568-11504502091084376-11766663545495760-9152390388321250-10068224511053632-10591875182995533-8892470168126816-9939230554056404-9809030923200000-11379148370914047-11379820897413336-9156718868146290-10072986026468288-10335232784322875-10990010879828064-6803742117518476-9813669493862400-11384529324874983-11777795237970000-11255002703904946-10339508758272192-8507693430594605-8639091455598384-6937862139421875-9294666351888896-11389911974926671-10866879871409016-10736587908089398-10213455295056000-9166462937067870-6678817547400168-6810177056731724-9037114940030976-10871374651389875-7073360369333424-11134650887439255-10087279579598144-11266977761439934-8909299346652000-6682369200247221-8779317288336896-9304005147935247-6683553364275384-8649815209851750-9043522726325184-10354789721314267-6685132467249192-6685527281852349-10881010496000000-9308402039140471-6555599822480400-8653902782687382-10359071087358656-10490818032810000-8917721892449888-10492057032635440-10361518112014848-8788135508883643-10625089661721000-6821447961210012-10232776085011584-9577394338399181-6691451366410344-11677928083310375-9841531630387200-9317199976884423-10630109191417992-8530838127711835-9056347384392000-8531845369947965-8663615928808368-9583049945798991-8533356381954560-8796440402796875-10635130301758056-8534867572353395-9060624963185088-8535875131731285-8667707847942000-9587576034451943-8537386619473920-8800594811088979-9195193944559280-10115310276831375-9459030144748032-9459588364290216-10774055856598704-10511894299177520-6833134500608000-11433034266678927-11565130856196544-9200078749897490-10252121225703552-11172842603595625-8938801476910048-6835957387761996-7099297671610368-11438432193574263-11570591043000000-10650831462049131-9467964293054976-9205508340033390-8943021376038752-6707661717595125-9075607095919104-11443831819232991-10655230554525672-10787412911161878-10393364508424000-8552006867779765-9736705185690672-11711052369622583-9606261214195712-11580833524887000-10660259571813576-10792504215277766-10135022403046464-8556042975019085-9741300319222000-11848226123367990-9610794607803904-11586298652598296-10928630669292792-10797597121093750-10271490732467328-9218548071329310-8955689041658336-10800144174717998-6849275756544000-8957273340453188-10802054727775376-10143990919784799-9485849462911488-8564118998768125-11068129372142304-6852103087133356-7116065018661888-9356859302921199-6853315038388000-9226160264857970-10149374568586176-9622701551452861-8964140794354912-11733169989396375-8569674212003840-10943459785994659-10944104834315736-10812885451261318-10286033862000000-8835960106040967-10023470859781408-11738703742125103-9628942444918272-9497598837669000-10685428395270696-8575231827021795-10422819038851648-10555375459154320-11083797359964000-6861802698817612-9633482970988544-9370104044293287-10822447982059408-11219052233924375-9503757142221312-9240308311164910-10032925848768032-6997057895982627-11750468743232000-11487090012056607-10695507006573288-11884596811242030-10432649567832896-8584331288203125-10830102064667632-6736191993347133-7132858746052608-11492504938612743-11228970845345000-10833292330568262-10437567149447872-10702439726815197-6738970077205704-6739367008669125-11761548863901184-11101441512584052-11102095359068448-8591413095591235-9120652570296000-10575292431009680-8989527953788384-6610336295590350-9387230325899264-11503339896300375-10975096971214488-8727699461456118-9124950372426048-8596473913322685-8729241336750000-9655638477180623-8597992546091520-8863067990502859-10715683237703784-8599511357701875-9129249524474304-8600523998137045-8733353891982192-9660187391057767-8602043107840000-8867243348796627-10720731257047368-9662462383663331-8736439155928704-6751282201488375-11914728734582640-9797131400998662-6884875953240064-9003829272218212-11652700195224000-7018516607376383-10329745602543744-9800591858281458-9006479327908832-7020169092296875-8610148047421440-11657501849385304-11658187907638976-7021821836578167-9274650083440000-6890145507759332-9805784071896432-11926655389087830-9144307190309376-11662991069103000-6627089399262800-10869066122093846-10472033496391488-9014432614793492-10075546882724000-7026781625790363-9148612419612672-9546939827759304-6630209375389200-10343735128340250-10476963445386944-8620793504503245-9815019201287408-11937887743769910-11805939000000000-9418775023863071-10878661742184656-9287208726391890-10216530512500928-11278651600135625-9023451998558688-9687510880306039-10484361269608448-11679469066648152-11680155986488000-8760632199945846-10354083326630784-11151207048172548-11019102575231752-10621446354270000-9161536214874624-11021046703418779-7037949689625096-8631955295590835-10226148333016000-11023639230027663-6773959743195048-6774358047407517-10759907171487744-11690463016375000-10761172497091656-8768878308741078-10363829109968256-8637032020330285-9036195485436000-9701191924583743-6645042635238400-11563053911805519-11696650143842752-9836397642622750-10501636400437824-9438734356043363-9040445979107296-9705755133379287-9440398905344000-9573924978858312-11702151645015744-11436865829979602-10373581006868352-11438210262786750-9044697805482848-6783922033121973-7183398417619968-11573933158946463-10909405675250000-8781257171652966-9180944719829952-11709719025477176-6786713223578664-6787112027560125-10780164286672896-11579375340550791-11979367999840080-9850281325080046-9185261440104000-7055760284618993-9852017703404272-11982887685634230-9986326421260800-9587436602373000-11585499833728152-9322214168243410-10255038007555264-11587541811251283-9057461282924000-9724022278056503-6927107695312896-11590264821163479-11724174900523712-9326596023281250-10393103149024128-11326482780450305-9061718442205536-6929956403034028-7196915864448000-9463167362875311-7197761267461872-6931584586616924-9198219719088576-8665498467543125-11999087120165040-6799882005490653-10800446810591232-11601161126763303-10935069822378000-11469161304205106-10269503226342976-8669570201588205-8803465092746544-9737737667813375-8671097430627840-8938425209808091-10806790312608552-8672624839014435-9206865339000000-8673643210914565-8807600925631728-9742312328690071-8675170918236160-8942624199835875-10811866902220296-8676698804932795-9211190179768128-10012750956602175-11882495254159000-10548002538969849-10548621674317312-8946824504693099-7344839252824920-11885982925182875-10417540249653888-10685283761489040-10151615337142432-6679086265907950-9752038239744000-9619013148808392-11890866811038472-7081493536686951-10422432261900672-10690301406250000-8820016195872816-10691556062830640-9756617377988096-11762091899332632-11094442165451000-11496120595773826-10293642141241536-9759480067183501-6818666935379304-6952774186039500-8691477626224640-11098999473953299-10832189159165832-10966563215486758-10565967301976000-8827781661350586-9095823748959584-12039296455908630-8695557493608960-11104209354510875-6823468625466936-7091471568736719-10437117487195776-9768644435449277-6825069689625000-11375783324655835-6959710910038016-9101694202783236-10976216124421648-10307539130263375-9638783654717952-8702190000848045-6828272569251912-9908270626938246-8703721058240000-8972053956780827-10847447552265768-8705252295203555-9241501993427136-8706273219613125-8840734230391536-9778961205235799-8707804755886080-8976263471207203-10852536865653000-8709336471758715-9245837673390912-8710357715456605-8844881726737584-9783548766859375-8711889730685440-8980474302109611-10857627770631912-8713421925542035-9250174709208000-8714443488578165-10994250040046576-8983633289347629-6972780786270208-8984686449693875-10862720267451336-11399819012677255-10327500127303744-10462236647012982-10194571612084000-11939079578917519-6976050810034176-9525550655310047-11672837642016408-9392488716791250-10600715581025344-11272307459479332-9125735998258656-9931529923686326-8724152320000000-8993114695731267-10872910037607048-8725685952257755-9263193953898816-8726708473608125-8861484683687856-9801913360972239-8728242405409280-8997330794596043-10878007311441000-8729776516950515-9267536415248832-8730799357838805-8865638666830704-9806508097526375-8732333768970240-9001548210965971-10883106178110792-8733868359869835-9271880233512000-8734891520345965-11020047026229936-9004712137979989-6989141128706048-9005766945046875-10888206637865256-6990369184972316-9276225408900288-8738984961329285-9142858118956000-9815701877835543-6723477177958400-11699535354371319-11834705738319552-9952494387812750-10625582367948224-9550133190002763-9147141992902496-9820300922039087-9551810810304000-11839557258365848-11167508938552504-11033606583364374-10495996331713152-9016319546585375-10228065699455136-11978304449713847-9825476563644416-9691448298569928-10903517578125000-7000198814245052-10635539961085632-10770797485702160-9155713754784352-6732536520318750-9560761436750336-9695987529954696-11043298788171984-11447991910193215-9697690107072000-9428861630480670-10237648895271328-7139830872567691-11990228976009216-11721471549012375-10913732841616776-12127079452604670-10645503773345728-8759471350377085-11051056637406000-6873620338151061-7278376806484992-11726959878657279-11458044981900040-11054290146593750-10650488012253504-10920759535065573-6876436076784552-6876838387922589-12001459286528000-11327882682567444-11328545390212512-8766649143342155-9306679653926976-10790984445930000-9172873340352608-6745154354845150-9578679460710912-11737941676999503-11198921220187000-8905687153121286-9311035693947072-8771778538299205-8907249919932144-9852534461308375-8773317746851840-9043794882729891-10934182505522952-8774857135453435-9315393093000000-8775883494553565-8911418191870128-9857145002444271-8777423183260160-9048026805240875-10939298909809896-9859450812295339-8914545249067392-6888915019928079-12157619678190000-9996849543099094-7025223920173056-9187368406648196-11890230716948672-7161580357086375-10540300486754688-10000356867728962-9190054352801376-7163255221422227-8785637897920000-11895097398726168-11895792747365824-7164930346869151-9463668713815680-7030564837562500-10005619392674224-12169707849250470-9601108454408192-11900660946617432-10954657698597000-10008543815229134-10414904258710336-8927582528240442-9198652898283872-7169957290079875-9064437974410752-9606159798412463-11230392351557176-8930713365500454-9337200481176000-11909009520744248-6902215636178088-6902618952180957-10963623627362304-11776431959310375-10017320501760464-12183939482303070-9747721084045824-9071325979123783-12186075183750000-10697290933727529-9614582641760768-11917361998429976-11240895815918712-10564350541982250-10700415994355264-8940110268955338-11378986833875808-12057011743453831-9077157015552000-9619638710280551-6774789158496400-9485258824240290-10434394132973888-9350847366596625-9215866076120928-9894081122893999-10707918622934528-11928504709123992-11929201359064000-8947423527095526-10574845338006144-11388960041097828-11389625128696416-9898704615234375-6780330584268800-11391620546849172-11256663288758616-11664211692112754-10715424757688000-10444758011329257-10309713736737568-12073922325300943-10446587643115008-9768808115397000-10990550763936936-12076742291966667-10584729140159616-10856766238149520-10314530047044000-6786271178473550-9908534318465024-9773371468472904-12081678290117576-7195127278108375-10589673349876608-7060194322884196-12220280357111280-10048372552290726-8826788360000000-11271787612838683-11951508481159104-8964154519836582-10594619099006592-9236873653348500-10324167167187616-12226700944452870-8830910459105280-9103161990532243-11005957475901000-8832456577069515-9376539496890432-8833487422629805-8969910612032304-9921843683581375-8835033841354240-9107412411423771-11011096244337192-8836580440548835-9380917306872000-8837611606944965-8974098408227568-9926475820149591-11558899586007040-11015593978640625-7208154820249128-7072564469957116-9385296479277888-7345443108235806-11154842054974000-6938172319295541-7346728625052672-11837086541977119-11565644188232840-11158095776505750-10750499770018624-11023307229546693-6941005658143272-6941410483793469-7350157403136000-9120171612061107-7351014764315952-11571716573001095-10483225162901568-10483836512851625-11437579512621024-12119094497154447-9123895289035264-9669169255501279-6809671181250000-8989290095732166-9398442173161152-8990338429820682-9263313010077152-7220356103132875-9128152160796672-9673680444210503-11309328009004696-8993483921108214-9402826797384000-9539655767962670-9267634424932704-7223724395621891-9132410356418048-11859194283357375-11314603497203768-10088306814377662-10770576956843328-9271416765240212-11317241856409000-10908820732808880-9409406290317312-11319220894947811-7228357507994472-11593324487734375-10093600146385024-9002924796909978-6820795063367600-11596027366895315-11323839548736000-11597378963999485-10506473173516936-11735186321020482-10098306884544896-8870651303093125-10099483797664944-10918997068664240-8872202056007680-11329779663783027-9146258637583000-9010272266408886-10239542316561600-12288166678814130-9148390384139528-11743394179664250-8876338280675840-11335061509659259-11608871780029320-11063216390764419-10107724750000000-10518110056646577-10245509183850600-11748868211085322-7104380632547328-9427515720271125-11067728306039496-11068372965488283-10249090416638400-10932999861218320-11343648009933000-11480987107449804-8884614586232320-11345630125603851-11619695481703240-9979849054158875-9706993801482816-11484999490054692-9024453673212912-10255658177351925-9435754954752000-11761191000863446-8889789888762120-9027081491516022-10121862524430976-9301712542312500-11354221961644808-11628494691515555-9166523605046784-9440700798913341-10399058459852000-9031287061783206-9442349797612992-8895485042368405-6979940740206504-7117216628879500-9718303797784576-12045922795381464-11088369826882632-9035493938052054-10815841988856000-8899628499672365-9310922515621984-10406930876000532-8901182627816960-9175599194142875-9723962088872856-11231145058834486-10136013475815808-11780376906704814-11370095206625000-11507753983920684-8905327854059520-9179872131588259-10276574263459800-7262535080280375-10140733388883584-10826548040549747-9182543391018504-10005442872701167-11376713422528000-9184146395389227-12337630887269520-10556142805712119-9734152546684224-10008936325460125-11243568890738672-11655597043607355-9187887464402944-9462703239057621-9463253737617000-10698213508508058-10013013047991104-11385320941969911-10288539071041800-11112268559484375-10564129023985152-9604312286592310-11114207798156712-8919327493540035-10566587132024000-11390620034343103-10430571961111968-12352711515505830-9745483624873984-12079611775143000-6863814940902800-9060762633054198-10571504491969344-10572119269209113-9062343488814000-10024084017519183-12221854197535232-9475921097915133-9751152459973464-11811941886409250-10301711081755200-10851766613900667-9203932124365864-10028747918660327-10029331008000000-11816063209792886-9893093182502976-12367085438990430-10169083640567936-8932822487558125-10170266046323184-10308301300915725-8934380477601280-11546639803400436-12234650957009000-8935938648788515-9623877931704960-11686816770288745-11412496170674152-11550667466803500-11413822896570368-9489151259845797-11140085876483592-8940094657627835-10591189187656000-9491357483368209-10454856391932448-6878594727068350-8942692817410560-9768739818359375-11695649829101960-8944251954877395-9495219197335488-8945291480527285-11560740722748000-7157064869374732-7432768456630272-9773281921772727-7158312517621408-9636749813101250-10601040692354112-10050921205625269-9363045896972896-12255286741680591-8951010311360000-11430415646920843-11431079691206904-11294011908665974-10743708588442752-9229106295795375-10469445126994336-12260983452515047-10057345882914816-9920150216096328-11160817237125000-11712648988033335-10610898304145216-11714009631876545-10474311052844064-12266681928437375-10337691878131200-9786916679217903-12406671214408080-10753072838365962-10615829400792000-9237686688091327-10203410631265072-11031354759299760-10342495638220800-11997991606902375-6895797873814800-11309765192152966-10758693999271296-9104038894586394-11587631366892000-7311668105189683-8967660768069120-9244125471200539-12142242852082112-7313366288109375-10763692231014528-10212300856304242-9384821257607136-7315064733951467-8971826606080000-12147178054373208-12147883192417984-11320275515176934-9940331086668288-9940908084777000-9113028013112496-10080146344478319-7456979409804288-9805116074099599-11739200553765000-10773068087524938-10635569064573376-9669260293668990-9393540846310112-10084827617498375-8980162152099840-9257012011853491-11191962478711752-8981725641531435-9535000497000000-8982768068631565-9121493763386928-10089510339632671-8984331860508160-9261310185250875-11197158978909096-8985895833865795-9539427487796928-8986938583598885-11338026447302000-9264534688274877-12030765365723136-11616585281624148-11617259201716896-12309476787627875-9958806102938112-10927657242286227-7054972765229832-7055382010125909-11482954421184000-9823338016963631-6918244940952400-9132613015024422-10932095084082496-11071118136250000-7058247167543976-10518782293496308-12318762106851328-11627371131053076-11489616355511000-10798096986369498-10937168374318272-9137911071289242-11630743077651936-12323763827643375-9277978173809152-9832457448251263-6924667323963600-9695096396749330-10665224417848000-9557703309079449-9419732015113184-10112945694866711-10390615112908800-9837019279622375-6927880005446800-9699594324680610-10670172329816384-9700719023992430-11641537687500000-7207083973323052-9841012039341568-9564354845099613-7624203048498520-10119983371152875-9566018211155904-7070945046049743-11369629460543984-7210426841200908-7488184955904000-9846147174909751-7211680683101856-9708594353636290-10680072744244288-10125850594915125-9432845836370528-10127024311730399-10405080004262400-12070592279095983-12487543220970000-9713096455090770-10685025247176896-9297898389403439-10547480967774624-12352371063734375-10132307159810048-12214995815830104-11243999882399112-11383474224975398-10689979280904000-9024531321815165-10274677066398832-12496952849911830-10137004566856192-12220658662223000-11249212476428136-11944300223434658-10694934845662144-11528974222211727-7084478867289000-12363826342493719-9585993648771072-11531645800663331-7502951120805936-11810884919214375-10699891941687872-11951220844517278-9450349856348256-7088172904205349-9312452744000000-9868991613153471-7089404535142008-9175054848869382-9592658302286016-10983534674324875-7091046931645416-7091457570402093-11541667895607296-9873564736837159-6953617237050000-9179306249832246-10987987630526912-11127720369983760-9459109980797792-11129009021470000-10990532717213184-9321624384419371-11270078962549992-7235531304885468-10853925308304000-10158748960228253-7097619054276648-12386758142310263-10438883610316800-9882715221984375-11275299612826056-9048603703508395-9605996875073088-9049651298726285-9189408590142000-10164631156310943-9051222843153920-9330262015777979-11280521875098024-9052794569511875-9610445812188864-9053842488161445-9193664423623152-10169338547698487-9055414517760000-9334582831693507-9753113610778160-10729045817806239-10032935084610048-10033515660681000-11427720739586352-11149640977793840-7247685989033984-12126637811635263-12266734183000000-9758194043363570-10874045347012224-11850606825335545-9481033972502752-7250621916271500-7529927606820864-12132251887421991-12272413007422656-11296851837255099-10042226989632000-9763841037326670-9485422832043104-7114478651024997-9626027909377536-12137867695647375-11301427049121576-9767230279195410-10884114683834496-11582484238036447-10606261639428000-12421208980588679-10747060771127296-10049780885444424-11306657375105544-11865697021484375-10889151682451328-9772880758419310-9494204613994336-7400322701895267-9914213131712000-12288749389914008-7261953634050336-10893560330826186-10475182918132800-7542567805272750-11454191147345392-10197613420040519-12154022796939264-11735597051502996-12574580964210000-12016405396123506-10759496618970176-10760118663059689-11738989888498656-12438458328071375-9364324557466112-12160348258280751-11881486826837320-10344480596101726-11044070361000000-9227225039056266-11744419787755872-7410597953240331-9088994512732160-11606617664537875-7132189328856216-7412311419301079-10909315217214336-10210590233017317-7133838326421000-7274137882493612-9652779245394432-11611985196756251-7555222141556976-11893166551299375-10774432295033792-12034476917650318-9516182778698976-7137549500212509-9377322538496000-9937736882310231-7138786844101848-9238963830852822-9659474814574656-11060037689171875-7140436858389576-7140849401684133-11622053779452416-9942331216704319-7002046202850000-9243234949574406-11064511297335872-11205215678658960-9524983532898272-11206510306030000-11067068186394624-9386536715234851-11348558089479432-7285914908948988-10929503627952000-10229485242635333-7147039458033288-12473004916633823-10511566278028800-9951524133087375-11353802945821416-9111602633582995-9672875240154048-9112655085517685-9253384131750000-10235394709999623-9114233915371520-9395214393511859-11359049417891784-9115812927576875-9677344801226304-9116865703692045-9257659693254192-10240123922196767-9118445019840000-9399555237517627-9820997844638960-10803721352527719-10102764249312768-10103347516113000-11507254528329072-11227237907845040-7298125936984064-12211030976100183-12352100672824000-9826101822012770-10949716929999744-11933072624866945-9547009153812832-7301075469187500-7582323699477504-12216671066529471-12357805811414976-11375455059725859-10112099212224000-11095860336422139-7163563761446568-7163977195033437-11659694578348032-9974531211860375-7024723128662800-10959200488220634-10819322241594944-9836315081226830-11804259230316000-7167285236398821-7308241927141376-12227956456998159-12369221358188992-10964260624190250-10824317696187072-9137938251258245-9279057257183472-7170594295955949-9420736000000000-9983743963076071-12374931766912704-10406792967897998-11110595589189056-9845399473008750-9564654077902688-7455233957150179-11394505384745472-12379929816032152-11677198254883000-9286018557903846-9708670286135232-11116365106929563-10694841491984544-12665674359303750-9147959076106240-12385643519824344-10134292791587904-12668596589057310-10135461773376000-9432154193952487-12670788556318320-11122778024357193-7321744449230848-11968926288828125-10138969258097472-9857899642057810-10421809116120448-11971687233733065-9437050528609000-11973067865392235-7606858163945472-9720434748475653-11411603058399624-11412261002572875-10567517566699200-11131760251557587-10568736098915400-11414893032160839-9724358346816000-12120913470223206-9584530589549984-9303168898551462-9726600876981696-10291054987352125-9445759306953512-12125106348872778-11702812049371136-11985498327260165-10717063249500000-9307459780650966-9731086971557952-10154762953407144-9309069201528624-12412807621841000-11143958149937664-9451749698955931-11427400699308072-9170664830689635-9735574445304000-9171721825693765-9313361897553648-10301736305225431-9173307470479360-9456107938099875-11432669817703176-9174893298009595-9740063298431808-9175950617893085-9317655913038000-10306485929035503-9177536750021120-9460467516772139-11437940555559144-9179123064921875-9744553531153344-9180180709734645-9321951248184432-10311237012499847-12006926507520000-9182296243083665-12432132547592384-9183354131626155-9749045143680576-11869086407986500-7206646107014856-7348376121970156-9468645337946624-10034515511048799-12579201645281000-11590493736344822-11025738762689664-11591828815965274-7209967269575784-7351762535383500-10321337912393728-9473554292017091-11453762488380552-9191820165209435-9758032509000000-9192878785109565-9334845173623728-10325499023061071-9194466867356160-9477919230860875-11459039706568296-9196055132487795-9762528262216128-9197114077516885-9339145789446000-10330255947385063-9198702647480320-9482285510262099-11464318545461064-9200291400356875-9767025396085824-9201350670564845-9343447725944112-10335014332484607-12034613490880000-9203469454891465-12460798919346624-9204528969016355-9771523910821056-10196959640625000-12746933159073840-10481414920756342-12606751566102528-9915993229988230-11474881086357000-9775461244122279-10767794337741568-9493207075054679-9493753373320968-10344535485907375-10345130752076288-12046393335505005-9495938775968824-9921700933313330-10489258785456000-10064597632984691-10632228933546600-11767010344361181-10349893703544832-9925126606403750-10209288989385792-12195130083524978-10352275727402816-9785590671812481-10637123503125000-11772427209112933-9219901062827520-11773781685002891-11916319913254176-11491398041533875-10782672688143616-9931980317972510-12770423489548080-10500729933320246-12629982674944000-9934265589449670-9225205750509320-7522523470021591-9794037204899136-7381438042790500-7097944765514800-10505562391268262-9228389539566080-9512887018968203-11501315818353000-9229981708753715-9798544009278912-9231043256611605-9373598277385584-10368363948734375-9232635731005440-9517264030238611-11506607631843912-9234228388537035-9803052196008000-9235290261973165-9377910786589488-10373134028111551-9236883224757760-9521642383918875-11511901068279336-9238476370708195-9807561765298368-9239538569772485-11656703313638000-9524927030259357-7392905616818176-9526022080214819-11517196127908104-10380291889985875-11234112241617344-9954848809456110-7253235278905992-7395880629103148-10667748600000000-10241627232715272-12376010796977496-9958282107859890-11239278538267456-11951312059270500-9675427651531488-10529746921216982-9249633521889280-9534785501477043-11527791117741000-9251228133545515-9821098770656832-9252291309793805-9395174050438704-10392228975801375-9253886226890240-9539169226854971-11533091048442792-9255481327264835-9825613872312000-9256544829340965-9399493174173168-10397006371390391-9258140235202560-9543554295671875-11538392603333256-9259735824370395-9830130357588288-9260799652324285-11683526014494000-9546843979040197-7409916437620736-9547940708133579-11543695782661224-7411193300049500-9834648226697664-10262831016675816-9408135392387952-12544900942456872-9266652162560000-11833481530582243-10265778299267136-11692252243418374-10694747260708800-9269313209398125-11694266605400752-10696589735491725-7416728065603584-9556717564814683-12267535843750000-9272507138001315-9843688117263552-11270956670263883-7133926444153200-11985684520435500-9275169305559040-11844357683343219-10560635989655888-12273876140858194-10419120871848000-10276983119201832-10705805283654600-11705685693546654-12705680848841216-12135335565318125-9851602564239624-12850653970634670-10709492984462400-10567306247802066-11853199462889000-12139515439373435-9283691665797120-9998395600929190-11570236054572744-11570900082046875-10571552419562624-11000760153300841-10715641034171400-11573556446004759-9287954802880000-9574287410970747-10718100912732600-12862459129426830-10576406579930496-9433552540442250-11864087692281448-12150666462331755-11293620312997888-9864614077536261-11723837167098000-12153455284644535-10295282165838336-10009876351842990-10868489244541984-7579776003335875-12729033296699904-12443701419780351-11586179726894952-12874271515820910-11301397693000000-9299151746748565-11731910508143856-7297094587128477-7726778621485056-12449412923718375-12163917168832360-11735275493832326-11306584596166848-11593492135709949-7300024810941000-7300443478367781-12740720243144192-12025639065576948-12026328714552096-9306621373131875-9879903075244224-11455616971121040-9737832798097376-7160581758887950-10168609148928000-12460841174078007-11888610583490584-9454136011469622-9884436180507456-9311959268828125-9455762296330416-10459245811954159-9313561035450880-9600682536888363-11607460731297000-9315162985744915-9888970672147392-9316231054652405-9460099967716464-10464043722762375-9317833311088640-9605086435462451-11612785050956232-10466443228297987-9463354091664000-7313010945878871-12906053134711920-10612251910222918-7457685514426368-9752916929526500-12622145282360768-7602409548053919-11189093008718976-10615901728376626-9755711995500000-7604152453776203-9326381781483520-12627209671205976-12627933265892032-7605895625860375-10046098155381120-7463243400251236-10621378024536688-12918632373385110-12775823998784000-12489442393603647-12203027915663880-12921593381653230-11055774391549888-9333331262263125-10626247424128304-12924554842337670-10483850614542336-12638790503627992-12208621999505000-10629291554500014-11348136967244992-12641686817682296-11924092160478792-11493759218750000-9913935167122944-11926141325650539-7615924035450056-7472655342668828-9916206747768000-7473511365961732-9629883460426856-7474367454626124-11643431488487424-10206555311830375-12794865427072584-12939368933214270-10064529949255040-11071616936369913-9778091750492000-7333988761836021-10785895186521600-10211232122714447-12225414508213640-11219258039330250-11363745314215744-11508249085981840-11796630705640944-12804393232070711-10790836800000000-12518087345036487-7338609258629208-7626834474505831-10073754294468480-7195950716506250-9499198720401456-11802710398377726-11371554851803648-9644782141013243-11372856789159000-9501917904767046-9934391885898432-10078945464629790-9791536017908192-7344072347242125-11952801840365568-10225271126895623-12098196262205088-11810819904236838-11379367966552000-12388375354443646-7347015133027848-7347435595159317-9364914603266560-11958959904046875-12680104761700288-11816228304635606-11384578697433408-11385230150617531-10953506376932000-7206666538949550-9369202567761920-11964435513739171-12109278155730336-11677472034442875-10957267309197056-7785872205342462-12977196092250480-11535945366441520-12546058310208000-12114128611378164-12259045706465480-12259747011496095-10962283224573184-9953168581457625-10963537442552736-7357531499449773-10243423877496832-12552519059911863-11254626327750000-11832463411767782-10822994082705600-12122446691348868-7216154783633200-12123833408095500-9382074314263040-12413915950367398-11548489220472960-11837878416963478-9961711258584000-10539804477117213-9529683231758448-10541009967629831-12852103212527616-12564010313082375-11698195731986376-12998738495840670-11410656213531328-10111286155439630-9822953887164000-10545832848867103-9390662024773120-10402558815442824-12281500735956040-9536769308343750-11415876490787904-7948216488043315-9538405055477232-11562364055859120-11418487226368000-9684587065242947-11419792743409272-9541131716330742-9975389706797376-12289225980650625-7373957061730056-12869013550011967-10845294200870400-10267465334237999-12581979432663000-12438069834582306-11137047851120576-12150201123241188-12150895526261856-10560310318678375-7233502625996800-12152978894067732-12008986814789336-12443757651044914-11431546875000000-11142777330877577-10998694397880608-12880786007409903-11144687594044928-10421602033509000-11724972196787496-12883730243138027-11292004236279936-11582204520658320-11003722947076000-7239705015441550-10570573205766144-10426366466618184-12888883735174216-7675841159616375-11297166295279488-7531874442165476-13036681218224880-10719661320462566-9416456595520000-12024777571991163-12749890009177024-9562963712258022-11302329927238272-9853876069812500-11013784643055776-13043384647846470-9420760277626880-9711184432536563-11741057671437000-9422374496423915-10002784155580992-9423450744723405-9568973344214064-10584468868817375-9425065270832640-9715622056016251-11746422763774632-9426679981343235-10007354767416000-9427756557467365-9573345566669808-10589304995931511-12330716675440640-11751118560068625-7689442505968808-7544789422108796-10011926771350848-7835868289358046-11899590422750000-7401387293047701-7837210405112832-12627337584524799-12337758238834440-11902987394017750-11468166858553664-11759171407868133-7404345368780712-7404768015356829-7840790129664000-9728943037310227-7841685231089712-12344097937491495-10166307926750080-11328818238045750-10748466615454704-11039595731187988-10604427387393536-12784148866368792-12058464896219000-11332698044102058-11478644056406592-9444992924673605-9590847774764784-7702180883296875-7557287928266752-12644645513090871-12063970834977816-12500731214246354-11338519413936000-10176174934725870-9885991101533024-7705697392482211-9741720398151168-10323904618415375-7270770150302800-11343048524028234-10907399652110400-11344342776972582-10763195584446000-11054723355841396-7273259192934400-9746723278714419-8001497900032120-10620775733775875-10039388040926784-7420840505588823-10768108229268208-10914245690834925-11788057656000000-9751171721332667-12808239592826304-7714493347792031-11354052812299392-10772408019539250-7424650551411816-7570663656012236-10046261195440128-12813353634622552-12086011350223000-13106060835761790-11504864964709312-9466567910175805-9612755516201904-7719774132543875-10342173882543616-12673527194112831-12091525670361656-11946525739998038-11364416288784000-10199416603534270-7431427185838248-7577573428275084-10055430280237056-12096352076171875-7870364458400304-12389242882350055-11223836283440704-12536427849460254-9913089398396000-7435240854135141-9768422220857856-10352201655529727-7436512366781304-9624270423759750-10062310753846464-11521273292669387-7438207942461672-7438631876649069-12106698698752000-10356922849561191-7294023309664400-9628659472852662-11525870418572736-11672432658890000-9922133155985248-11673763027521840-11528497896621568-9777890803935083-11821705754625000-7589675644223452-11385162156561024-10655951200182621-7444992822535464-12992982633112375-10949766503731200-10366369543454903-11827095385219272-9491419731766635-10076081115624000-9492501231250765-9639088811980848-10662023774472031-9494123634511360-9786807999034875-11832486653687976-9495746222622595-10080674026492608-9496828050730085-9643482364758000-10666883494662903-9498450946949120-9791268628929539-10230266286661680-11253933848609375-10523758260367872-10524357620116776-11986756586319664-11695062675427120-10087566009408000-12135009566591003-12135700626361144-12575056473054882-11552163170410816-11260344519972625-11114739153169056-13016685691196567-11262268195999744-10531551712231368-12872629449592000-12434497762906535-11118536899999488-13021133221433573-11119803007825184-13168937484213750-10682079637616128-10390011405713983-12878493750530496-10244839590166930-10830875542000000-10099634536938969-11124868400303008-13174936202963430-10686945449705472-12883626474631000-12005880752768912-12592250190002898-11275098302076224-11275740063035833-11129935330836000-13180936743128790-10398886362777088-12889494114736536-11425429093286832-11426079336818250-11573226138417984-11573884768379227-7472173602401832-7472598826158909-12161980342784000-10404213762096631-7327328033552400-9672623377366422-11578495877794496-11725726286250000-11140073807001376-11727060701166640-10994744949926400-12754629798834543-7330664070850000-12022973080579062-11437137251839104-9678128256511242-12318318548163936-7772714584764875-7626493433741312-12173749330402899-12467801904958120-7627795055889788-10122073046856000-7628662886261092-11003505037686600-13204957123476630-10711296675615232-12766244053245375-12913716961810368-11446900158464394-11300787739240384-11301430474622673-11155293062500000-7633003025479052-10422577619693568-12918859039836376-12332339473193376-11892575055778875-11159100040988416-10719218781272789-9691899591231792-10867293227229446-10133592855744000-12190377293727723-7931539813395312-12485541077510495-11311074430020288-10577190441393000-12340757132852064-7493028543384813-9844342262431744-10432657290155239-12490511059305000-11462532362580858-11316220115480896-11610807940699443-7496010984582024-7496437112203125-9554825718397440-9849380213036011-7350701560747600-11467746258160842-11321367361304000-10292737160687870-9999227276992224-7499846714567037-11029813216972800-12795310530786375-13237280438729040-12061318746607046-10591028104886784-10591630016044968-9709545954174000-10739956599925983-7945076914762752-10446898473609247-12507561009485640-11478178792070250-11331666534983872-10302100400590110-10008323340364256-10744839970603127-9567866880000000-9862823150452867-11924389053562248-9569497859065755-10158967194398016-9570585281408125-9718377162292656-10749724821341839-9572216569377280-9867306846245643-11929809846321000-9573848042702515-10163585256541632-9574935794566805-12079835930989808-9870670509706125-12817867372081152-10019132078330884-12082580828369424-13114765530164051-10610300575296000-12232013430043863-12380090193764832-13117745312153263-13118490328167936-10023685453062500-7370775530798800-13268149427995470-11499715871869056-10320843912315230-11206124014212000-7520326041981741-11059931015577600-10470662569241127-7374124741485200-10324360849801250-11357441792085312-12538147626921505-7523315721768072-12539571472586115-7671702807808000-10032796340833828-12246608444530104-12099745858330774-11657734036579136-7673880825058500-12101806753722352-11807310995953840-10184383855669248-10627786433955528-7380826206250000-12105242099386182-10629596411582976-9891991464849959-9744902912703024-10779065019625375-7974007526052864-10484938310142303-12553103383080520-11519972199510762-11372925691512000-10339610144736670-10044762757019104-10783960237074231-9602701312655360-9898730771079875-11967801402429576-9604336247893595-10195950884006208-9605426307809085-9753755543598000-10788856936378703-9607061552325120-9903225341995339-11973235342973544-9608696982421875-10200580146538944-9609787372258645-12123804200692464-9906597162878413-12864520164864000-12421620700762644-12422325406929312-13162496219495443-10648915627903488-12276529689092375-10058450308007008-7840119224889459-7988499130917888-9912218564981723-7989405438726000-13168470685773419-10653749086772736-10210421981451033-10063015586642912-7843677591320875-7992124773433344-9916717217464291-7993031355438768-13174446959654211-10658584008000000-9918967054042967-13324741208532720-10956519632756198-9624515709852160-9921217230880875-11994987553566696-9626153120131795-10219111208814528-9627244830152885-9775910573286000-10813362668584263-9628882549944320-9925718605437299-12000429719563464-9630520455456875-10223747478479424-9631612495648845-9780345601265712-10818268263731807-9633250710720000-9930221341339387-12005873531397288-9634889111540355-10228385150206656-9635981481953125-12156850326859632-9933599286772861-7710096153903104-9934725438792963-12011318989317000-12605184961991735-11419461815420736-11568422147118486-11272434784054304-13201362568533375-7713592796096512-10532617817287663-12906896915317464-10385448108841330-11721384222536000-12463950262984164-10090436270300384-10981391128029718-9646363119144960-9943737719177875-12022214844409416-9648003006337995-10242306579882048-9649096367712685-9798099126750000-10837905480818623-9650736564651520-9948245902520859-12027665242079784-9652376947451875-10246949861978304-9653470639247045-9802540862526192-10842818495335767-9655111331840000-9952755448238627-12033117286831368-9656752210322555-10251594547196736-9657846232588125-12184434592705072-9956138501709221-7727589936728064-9957266356537003-12038570978913000-7728903036119772-10256240635749312-9959522321718239-11000692404515376-11893313948750000-11150613267763200-12935443889598471-7434584147267600-12193408454998598-11599264840176000-9815318329881306-12492930702854112-7882890708142611-9668243565493760-9966292261698875-12198242359222992-11455095641897831-10711864720387584-13241804679152541-10117906721132000-7737660833670092-12053577128214528-10119625277764676-13245553491416776-10269605959266375-10567873912619456-7442586021548650-9824769677975472-7443428657949950-10868021000000000-10719750755448072-12358189934788664-10423159770171890-11615035422436992-13104884229811000-12509915688834144-10872327765768039-7447221308825600-12512039893897236-12363786729783000-12215516731707142-11620295458022784-13408792008587730-10131660623338592-7897182361253875-10579842962274816-10729461956825736-12071327739268392-10879713439627707-10284146648952000-10433782598978270-11328747793465248-7602616161281517-9988315753054208-10585231981734375-13120466436138688-12226580884316006-11630820292880256-12227964372957898-7605627609477000-7755196271097132-10291131052564992-12379886927515771-8054839899538416-12679631884519375-11486904514520512-11636743304288934-11339006629466272-13279324645950391-7759145392128000-10594816978702391-12087728378557128-10894494820147011-10298118617733696-12686805650620625-10150018540810848-8060764698080442-11196139683494400-10599611646242079-7464937381250000-11048732111182174-10302778751285952-7914176122333481-11050606613308336-13440686952723750-9707711701975040-13143491308304984-7767047655697824-12248729228119078-11801272216664000-9710456526288765-9860405638665648-7918652213015491-11206273464460800-10758630747573000-13299614865343144-13449809074658670-11657160179373696-11059982304235666-10163801522124000-11958089510152880-9716496960901120-12407920552101411-12408621934405592-12857853102531250-11662432924192128-9868770263057178-12560963001766368-12561672968211276-9720891577280000-10020562258939547-9871559522046288-12265358027668534-10919777306259392-10770799996017000-9873791307603696-10921628778453719-8079469630783488-10623606683221799-12719121083465000-11672323605740538-11523329552710976-10476346089674990-10177596975311712-10926567060763375-9729684784867840-10029626368226091-12126054292152552-9731334101404435-10330769079000000-9732433749304565-9882721813615728-10931506831432071-9734083376476160-10034160471885875-12131536026916296-9735733190042795-10335439056664128-9736833169311885-12284083408942000-10037561946244277-13034585331380736-12585827747967348-12586538651025696-9740133604231875-10340110441477824-8092717406241102-12289635327840624-10941390838743607-11841351974912000-10043232778267587-12142504452119688-9744535344171355-10344783233653056-9745635986328125-9896127666768816-10946335075834959-9747287104954880-10047770981401163-12147991143057000-9748938410060915-10349457433401792-9750039383736405-9900598977066864-10951280802182375-9751690999664640-10052310551437651-12153479486549832-9753342802100235-10354133040936000-9754444107344365-9905071633993008-10956228018010111-12757971980848640-9756646966535625-13209744623339968-9757748520488995-10358810056467648-12611437126423716-7657376174625000-7807961501701452-10060825930203136-10662074019492967-13365889392167496-12315334713307750-11715247847192448-12316724888993226-7660834400235912-7811487668331308-10966745798208000-10065937465022827-12169954434849768-9766563937113555-10368168312371136-9767666237363125-9918497686567536-10971078604617799-9769319843246080-10070482504729203-12175449391053000-9770973635748715-10372849553166912-9772076267766605-9922975732033584-10976031780609375-9773730371325440-10075028912367611-12180946001055912-9775384661532035-10377532202808000-9776487625368165-9927455125141488-10980986447202551-12786801373347840-9778693801930625-13239593769499328-9779797014663195-10382216261506368-10834228036099368-12339677894238000-10985942604621583-7525042622694400-12642784625524788-12492979842306872-12945263381529250-11892249806209344-11591833890280721-11441935827077792-13399864692124311-11593795136000000-10841562639331272-12197445756351048-10993379636539171-10391588606922816-7681172505096375-9940901392343856-8133923386480122-9791385758369280-10846454213399688-7833991940372000-9793042040140515-10697618253313088-12355692295436954-12356388887876208-11904997012356625-12207077490917376-10700634102221223-7536082633811600-12359872242801638-11606875761096000-11155288619951714-7688537695949448-7990499367030051-10403311968416256-12514834268546875-8142640269867504-12817841373687055-11612110764743104-11612765250855153-11462596128292000-8144935221171114-11011366318731264-13274723932829656-13577187331521360-9957165157689750-10410350215769664-10109170593264551-13580248128954480-7846807742327788-10714514307904000-13280709717133848-12224978447727528-9961654833233862-11924470831311936-11623240373446625-11472935598751136-7850345594011596-10719345017618432-10870934155001928-12381483656250000-12835187847641335-10872771634008576-10571345723769390-11478107664760864-7702848268375125-10119998183081472-10724781301357103-13293435482757056-9970638232696614-10424436232344000-10122848833244927-9972323221128048-8008528804309691-12240139073163264-13298677865847000-12543777635082968-12393345764783366-11940603145921728-10127410986895303-11186128657942000-12093793121720880-11338569568473600-10734450343476607-13456618053279336-10584452912031250-12097198800686080-12853997514019305-10283777063584736-11040558794874647-11041180471296000-13310665630859608-7563304037088400-9984123455868342-11951366101614016-11952039001005875-11498811472781856-7565433465545150-13467229730564608-10290148074406692-12258072329409000-12258762419614851-11654047472227776-12562862250014831-7719783643545384-7720218210016125-11959442561388544-13322660597758424-13626215306963280-11810051330212122-11962135523000000-9994245348773466-10297680842613344-12872825548175795-11964828888838656-10147957641290875-12269116880905896-7876913383323036-11816035030340736-11059219240731917-7726738664241000-13484675309011559-11364129905049600-10758648370206087-12274641643574664-9850575347006875-10457353005436224-9851683959390845-10003811193646512-11065444058635407-9853347033920000-10157098400875787-12280168064522088-9855010295602355-10462061050539456-9856119240703125-10008314878978416-11070425594405159-9857782814330880-10161670838329363-10617268272590000-11679652096704207-10921847487146496-10922461867946664-10012819915804464-11075408625037375-7889775940646912-10317979642575204-12442969411658704-7891107348655388-10471481379576000-9864993796503365-10017326304327408-11080393150756311-9866658368552960-10170819829587875-12296757279524616-9868323127839995-10476193663933248-9869433071390685-10021834044750000-11085379171786223-9871098142763520-10175396383804459-12302290336074984-9872763401401875-10480907361799104-9873873677869045-10026343137274992-11090366688351367-9875539248640000-10179974310687027-12307825052148168-11092861007529731-10029725844107904-12005952825767875-10030853582105136-11095355700675999-10487980559390208-13376727130131992-12617395043499000-11857977532737258-12010677984252992-13075650218926062-10339467360638432-7755036392578125-10188561624072192-13382743536239704-13687666070953680-12471685561432998-10495056938568000-9887203488847165-10039878529491888-11105338213500751-9888870558261760-10193716329388875-12324439159992936-9890537815054195-10499776292587968-9891649423686485-10044393032454000-11110331714449383-9893316992798720-10198299748993619-12329980516645704-9894984749316875-10504497061176384-9896096691115245-10048908888532272-11115326712054527-9897764760000000-10202884542293467-12335523534065448-11117824772173371-10052296668695424-12032970431004875-10053426097929456-11120323206540439-12034998383771648-10207470709494243-12493427079322000-12951231113570135-10971070792598016-10666917934119790-11581875670067744-8077287993163875-13564509570681344-13260433848056031-12346614552201192-13719231068315310-12043112473352000-9909446490934965-12501849929610736-11130320687051591-13265647648985088-10369134437562500-7929783367624352-10065290212921878-12048523892041408-13574415678060421-10066985848062000-11745476285773307-10220663595117056-10373793239494116-8085910462576712-9917239415711875-11901355451376768-12970153954578505-10376705699209696-13734646221916710-12667107049472000-13278315426325527-7784277044571288-11295467413168718-10532851390514496-8090905222094625-11297369718679664-13740815515106070-13588902508773888-13284279522772863-7940474808500000-12522220778413782-12064767873831232-12829080784016868-10386029233405152-11150333620510375-10539947936354304-10235016576144531-13749301309312080-13138958566415794-11764611453672000-12834841808139204-11613127575741728-8099082900963891-13601109936559616-13296213072807375-13602636378883944-11922080585887914-12075605302219328-10241910777367503-11312595852302000-12230519536488880-11466755385753600-13302182526929079-13302928834296888-10704106458281250-11775177678431552-12081704206744307-10400025003651936-11165359053550447-10554150589248000-10248808073803947-7648793274808400-10096973477552742-12239442246712320-10710112690138750-10404693052957408-8109995041732059-10558887640608768-12701983034041027-8264404271646000-13009514116230535-11785750227904576-12398692324746717-11633993381111584-8266722044168250-11176010231459328-11023532366002056-12402169373501352-12402864861250419-12097299625000000-13169950724303086-10414033341656544-7964119108115404-7964565677539328-13326078210348375-13020461608648360-12561620189417126-11030333707620864-9958498468829885-12563733201182000-7967692130935212-11492507933529600-13332056599272639-13792555886466960-13180292263465250-11495085306907200-11035900522037736-10116809241516912-11190431427407207-8278317407232000-10885064495323031-13032145701375080-11959580503000026-11806914308560448-10734160085468750-10428054253059168-11195450402015359-9969110440506880-10276428225577563-12424437880137000-9970786703818915-10584966761548992-9971904317078405-10125885665102064-11200470877092375-9973580893552640-10281036403185251-12430009168666632-9975257657938235-10589713028616000-9976375605262365-12586286739079216-10284493440298469-13355239744747008-12895436723704500-12896159238088224-9979729948390995-10594460714278848-8291781606320046-12591929337750000-11210516329550023-12132608290476032-10290256890806259-12441156741712584-9984203575376875-10599209818749504-9985322190980045-10139510476729392-11215541307379167-9987000271040000-10294869201231227-12446733026726568-9988678539095555-10603960342239936-9989797488913125-10144054795082736-11220567786574199-9991476070318080-10299482889673603-12452310977733000-9993154839746715-10608712284962112-9994274123828605-10148600471012784-11225595767359375-13071631116392960-9996512942717145-13534498424176576-9997632477530035-10613465647128000-13075291202364985-7845613980921768-7999897438326924-8308050934358016-10924160037340375-13078951971494760-12618048294106246-12003205702290816-12619461157588458-7849128647229000-8003481153411692-11236285213300224-10313332225163419-12469054829195304-10006591765291875-10622976630638784-10007712052466245-10162245646290672-11240688721498327-10009392640000000-10317951427733667-12474639446659848-10011073415669755-10627734252407616-10012194037308125-10166796754555056-11245722710886639-10013875126561280-10322572009350443-12480225731361000-10015556403978515-10632493294468032-10016677360130805-10171349221409904-11250758202986375-13100930936156160-10018919523347345-13564834619162816-10020040730417835-10637253757032000-11100364084948392-12642788634223536-11255795198021791-7709880087731200-12953323195312500-12799833014665208-13263219538247938-12184336747603008-11876536885843553-11722951903172000-13728961629634599-11878530113601536-11107818301473864-12496994591372424-11263353509069875-10646778944518464-7869798512038503-10185014775544752-8333659995630426-10031818455360000-11112789632667912-8026352499634976-10033501740515955-11114654264206848-12659064167512250-12659772116071152-12197291795010817-12506783359537152-10963349079609879-7721100106250000-12663312254782982-11891823998193216-11429145227229698-7877283773083464-8186654592277875-10658693422984704-12822043747104619-8342518976980848-13132477038965215-11897144327992000-11897809480771137-11743949013428128-8344851330883338-11281633394982912-13600537531207000-13910418253106640-10201543644069558-10665846374860608-10357270349359703-10203254546958000-8193980593827683-10977455501751808-13606620854835096-13607381397810112-10206106476843750-12062436367782528-11908455297179441-11754456964053152-8042972681423628-10982364918272000-11137668539057352-12685275846306576-13150106165853895-11139535952460288-10830709623588750-11759713289057056-7891827531998853-10368274344897024-10987889761245599-13619553939992000-10215236223612486-10680161877742272-10371171428038319-10216948657039344-8204977788900875-12540383655100416-13624881709108824-12851458674864536-12697331171470118-12233478087000000-10375807883483767-11460487728046192-12390408612794160-11616656989324800-10997716278811375-13786639804563624-10844030286897010-12393869749672960-13169222182785465-10535966227148000-11311301401303463-11311933199929344-13637064684152536-7748764977917200-10228941049857750-12244416297889984-12245100152472227-11780754259129632-7750929074697950-13797424257472000-10542440963656548-12558608916366888-11939097388993159-12249887847506496-13025924558062500-11786018420329376-13957906441642470-10701659140620288-11167572206843208-12874447899711000-12720044263385062-11945098722415936-10239227709733242-12877323479025032-12412571027230000-11327103425714688-11017386886245263-7759156317163600-12725726765438358-11174432660928000-8381292358393134-10244373624836208-13970380226706630-11332163179999232-13661452417239000-13662215002034368-12576149850361563-11179423846439424-12266996945551171-7919642578125000-7920084612911301-12890268884785664-11027230979603167-7766089035253200-12115775048822250-11961112109501632-10874345131236510-13049942404423008-7923621483348429-8079437463552000-13518274711657047-13674420218512064-12121185185143866-11344819157365312-8392526287494750-10258104493500336-13989104835179670-11347351483060736-11192532779203848-8394867952182000-13836758037537979-11194406320006656-12905382820076111-10573674604280032-8241706162546875-13840618309259264-10575444388573444-8554145438682360-11354317321714147-12288234342008000-13222255510175985-7933795850916168-11823570967176212-13846796237293056-10580164778790500-8557963543341080-12604249305266643-11982485545790144-13228156875685865-7937336801889000-11828847874642996-13852976003448832-13075448120133588-13076177342775456-10119034863266875-10742343749861184-12455585879405840-10587838408380256-7785609442069950-11056181912000000-13548471326881887-12926273860705464-10279296945233382-10747136942510016-10124679021283125-10281016530220656-11372061409872839-10126372677857280-10438535341926643-12620425428621000-10128066523297515-10751931560749632-10129195858521805-10285603027731504-11377134542641375-10130890018762240-10443191850997371-12626055148813992-11379671674714907-10289043795888000-8262874524053033-10602014855440864-11382209183951991-10135408702914560-10447849744671875-12631686542962056-10137103555818395-10761525074849088-10138233562716285-10294780114542000-11387285334028943-10139928730513920-10452509023155979-12637319611314024-10141624087261875-10766323971132864-10142754430071445-12796187844670704-10456004390924173-13577956290048000-10613246846157828-12799040210342416-10146145962426955-10771124293855296-8430045209610750-10303962658422576-7962596578497573-11710353250214400-11086418704652479-12804746213250000-10931489887783570-12025308772878016-12025978694073729-7965702346073064-11871119668104500-13902480337895424-10622711515337924-12810453911786384-10155193744720635-10780729219464000-10156325095564765-10313150660995248-11407605026485231-10158022279375360-10471159989304875-12659868631737576-10159719652248595-10785533822774208-10160851339204085-10317746709798000-11412688723757703-10162549027205120-10475826194924339-12665510074841544-10164246904296875-10790339853370944-10165378927413645-10322344123882032-11417773931142047-10167077119680000-10480493786588347-12671153193642408-10168775501065155-10795147311466176-10169907860393125-10326942903450096-11422860648862519-13301331651461120-10172172831233985-13772323740472000-10173305442753115-10799956197271872-10957087225906990-11896928359114784-7983909489511125-10489249257498112-11116091823134383-13778458178037696-11587075661345726-12057493063000000-10805367900627369-10649361061662944-11589655583554198-10180669466972160-10494504879905875-12688092606714696-10182369361686795-10809578252862528-10183502729947885-10340747437086000-11438129866283263-10185202940024320-10499178017806299-12693742430791464-10186903339331875-10814391423071424-10188037044003845-10345351680617712-11443222627590807-10189737758720000-10503852542780387-12699393931809288-10191438662695355-10819206021838656-10192572703828125-10349957290647216-11448316900355759-10194273923258880-10508528455033963-12705047110017000-10195975331976915-10824022049376192-11765895818792775-12707874328144824-11924100877328500-10198811433840640-10513205754772851-12867624212153104-13966856737176691-11299658614848000-10515544925013607-10359172611010608-11458509981154911-10203350290664960-10517884442202875-12716358498997416-10205052709092995-10833658391610048-10206187759907685-10363782321750000-11463608789637623-10207890493931520-10522564517529859-12722016710267784-10209593417326875-10838478706730304-10210728804802045-10368393399798192-11468709110474767-10212432043840000-10527245980959627-12727676599723368-10214135472277555-10843300451468736-10215271196463125-10373005845357936-11473810943890599-10216974940590080-10531928832698003-12733338167613000-11476362427885603-10376466077079168-12421005844187043-10377619658631984-11478914290109375-13052093727748608-10536613072950811-12896273036582864-11481466530589947-10852948230648000-10224360020884165-12899140255537776-12427911134233873-10226064775413760-10541298701923875-12902007899438992-12745374573440043-12116646644122944-11015745412046830-8026203346149000-7869264056063550-11174975872091648-13694041158576159-13065155980038072-10389737427291750-12279462826171008-10705767507142164-10706362316063456-11494233407825927-10865016000000000-10550674126854067-12756001228488648-8189492763817404-11339927610628608-10238003363258125-11656220543583984-14177271954450870-7876699718425600-13706218825677423-12761671192281000-14180422284299790-12290381947718784-10557709342473199-10715882255322592-14183573080803750-11505092691755008-10560055109135171-12767342836000392-13398572991553015-11350009786176000-8355332310916833-10405331271630768-11509566148842191-11825553399436800-11195478889859375-14034548620132264-11039021988237810-12616725682396160-13406015402643065-10725407836236000-11672415434672534-12777272255582208-10569441650413779-12778691164215624-10255074602036875-10886760521907264-10256213358862445-10414579426869552-11519795547676287-10257921652160000-10574137006191707-12784367849209128-10259630135137955-10891596574485696-10260769229173125-10419205558696176-11524912519213079-10262478028308480-10578833752336483-12790046215125000-10264187017152315-10896434059013952-10265326448447005-10423833060264624-11530031005795375-10267035753495040-10583531889053931-12795726262212072-10268745248279635-10901272975704000-10269885016883765-12956573915238896-10587056404279149-8217275862335488-10588231416549875-12801407990719176-8218643862975676-10906113324767808-10590581701904103-14226943872870000-11698358449993414-10276155251781120-10592932335030139-12807091400895144-10277865758671875-10910955106417344-10279006202044645-10437723785448432-11545395558057847-10280717025280000-10597634644700547-12812776492988808-10282428038336155-10915798320864576-10283568819168125-10442356768011696-11550520107064719-10285280148615680-10602338345766923-12818463267249000-10286991667912115-10920642968321472-10288132786253205-10446991121330544-11555646172238375-10289844621987840-10607043438435091-12824151723924552-10291556647599435-10925489049000000-11876190119422575-12826996583245848-12035874045055252-10294410445596160-13145899158232875-13146628082110328-13622562708821698-12356032636561536-10455684229123914-13307972288604000-8080288293851181-10932760857772032-11250276175483687-13152460443184152-12994717445611750-10935185510869824-10301832789274845-10460902407848112-11571033467002607-10303546144320000-10621167068108587-12841227190931688-10305259689326355-10940035892485056-10306402158203125-10465542246216816-11576165599085959-10308116019834880-10625877729242163-12846922379757000-10309830071455915-10944887708169792-10310972878091405-10470183456354864-11581299248457375-10312687246384640-10630589783006651-12852619252241832-10314401804695235-10949740958136000-10315544949139365-10474826038465008-11586434415341111-10317259824168960-10635303229607875-11112126501289520-14129057925272547-11113357898285440-10320118371546685-14290186353750000-11750359745166374-10957023522826752-13180917906684891-8576012032790256-13500026040779375-12230112835588032-13660363238678798-10801815783637216-8101810608625629-10644144696832000-11280240827644951-8103157020755928-10487019345577302-10964309315843136-10647092941122375-11760127111825904-14303649480791670-10330985666926080-13987339846375192-8265704029076000-13035101303461302-12558902842019392-10651811264273039-11765338586521776-12719989328750000-11925650367283200-13834520485361271-13835286572954424-11132456186413730-12246379886664000-12565163395727539-10816182551926624-11612133020293551-10976459480203776-13204298254874875-14000513030843328-11137388326204210-12410919797068416-10979498423175561-12094030104484000-14163529855198519-10981322058166272-11459405197948104-13051711739337488-13529962334514375-11461308402350592-11143555549236110-10825767471106656-8278986312615148-13215267304000000-11464480877947272-7961885724520400-10510270862746182-10988618617434816-13537453316535625-12104745824410016-8441934679610379-10353889114849280-11469558056495688-14019124544568000-11152193485715170-12427417583577984-8285403538963044-13066167061692208-12748185471070000-14183141135122944-13865186053359231-13228438179603256-11794681821723966-12273523681496000-10520745248366826-10840155464535264-8130566430565917-14189420565876736-13393003061812500-13393744043834784-10364780100680395-11003221430964288-12758063956079120-10844954293756000-7974672240419550-11324661026236928-13877464957658319-13240152968647032-10528896802239750-11008091908841664-10370515264853445-10530644111411952-11648174865536087-10372236226560000-10691973305007907-12926831920779528-10373957378648955-11012963823756096-10375104919148125-10535304547609776-11653329780487279-10376826388564480-10696704877216683-12932552390625000-10378548048391315-11017837175919552-10379695927398005-10539966358618224-11658486216090375-10381417904599040-10701437845143731-11181224917905840-12300027470190383-12779955902080000-10384288289802765-11822766459141872-11983196067708525-11983858586380800-13902044510187375-13902813088499352-11186789869651410-12306149142736064-12626487361821611-13426374316572000-14226349655661479-11669448691810304-11350365161153607-13269470195274392-10392328183046875-11032465858023744-13431570377562372-12153044897464352-14232641832407871-10395200578880000-13274605155213403-14394945718239120-11836498400155838-12317037130729408-11037954950339625-10878585759504608-11839115212924822-12959747670085632-10720383678151123-12961180055709000-10401521712671115-12482515785876864-10882794575039476-12163795443357984-14245231751291375-12005072079475200-11365429515981183-14407678504043280-8484990569723647-12488034546000000-11367941536935971-10888207504229344-11689456775957271-10408995446620160-10729864974315875-12972642940453896-10410720662708795-11051990901841728-10411870912665885-10572637547406000-11694623862402863-10413596446456320-10734607718033899-12978376916402664-10415322170881875-11056875759628224-10416472759745845-13141506816125424-10738165692831853-13944358396416000-13464262032325524-12663517209345592-11862683885723758-11061762056571456-12344966909515625-12185315551206176-8337781580116716-11384907360584192-13790930988182854-13310586972171000-11867925612855134-12670512081707072-11548446115970664-10907468010555872-8501878296404875-11389937511038976-14117885095666264-14118664572537536-10589583058574454-12034281487800000-10751218326646007-10591337075199408-11715307434887311-14283834559422976-10753592668612875-13161839959926352-13644123843393455-12360653304398784-12361335622832273-8187830081625000-14289354932694039-10757748608167936-11400631499793367-14452302379847760-8511270041810375-11884315961901184-10760717791898631-10600695101746992-11725658360290367-14296454645184000-10763093532208027-13173468310406096-13013534391221907-12532243197282432-13175649388324250-8195063412894696-13659192729153355-11410072929206272-14142842588635992-11411332180163000-11894157411104014-11091110072392512-10448723661552605-10610058638891184-12218317382812500-11093558080786944-10772599990202411-13989073233979224-11256197139735730-12704123326088000-13508926988620644-12062207357322600-8685268405193898-8042358824755200-11099067416647125-13190923674885392-12387282333472431-12227082960969472-10457950416281485-11906631044406000-12872743559877680-10459681037278720-13356944771225931-14484232925548560-11909915028310750-12393432920417472-11106416034785337-10946057137509856-11912542650156726-10464296960000000-10786870170294467-13041562205837448-10466028281073755-11110704226257216-10467182601208125-10628802251457456-11756747714671439-10468914240545280-10791629695975243-13047316470801000-10470646070854515-11115606367914432-10471800730494805-10633491601256304-11761934610406375-13696158380380160-13052352840906753-8540899243099496-11764528630270307-11120509951272000-8703487565664894-10638182330123568-14507411956647030-11767771691402752-11607209137125000-8705886718721904-14349381992570987-11609128671174144-11126028206095641-10965385784876000-8547021751284523-8708766284316672-10805916672849379-8709726280599216-13710509924844375-12420793495406912-13066749610947693-12260835793431072-8712126579952026-11778153492032000-11617449097544712-13070350456829928-13071070705380867-12749030709270336-13395289338203375-8231293976535336-8231747533003773-10492021017620480-11622571335421128-14367581155125000-13884045599843186-12754651561879232-13562655188684868-13401933338599112-12918237779710000-11788541396909568-11466199313721503-8075233091995600-13244111840015478-11629616870592000-8722693136205774-13246300708208496-8400555853604044-11793737639002112-11632820327613000-8725095817201584-11795686623386099-11149961738995008-10504165674841085-14545030466070000-8242637887184661-13091969425125888-14062519391198079-13255058592690768-13902412424281250-12448194309487552-10508794674906645-10671056063141232-11803484708129447-10510530900480000-10834528444364947-13099181041921608-10512267317278155-11159790544781376-10513425034718125-10675757831854896-11808685340189119-10515161770247680-10839301977655323-13104952241769000-10516898697030115-11164707112980672-12136219332086775-14402439808334776-12784891951652625-12785595784658944-10844076912838691-8902344228469560-11816489152185427-12788411375000000-13760440552647585-8256718804854408-12304807262836052-14410370084829696-11010776432958500-8906265246241880-10526165537019795-12632093874231936-13766500974509465-8260355191401000-12310226390647156-14416716401569792-11015625482091396-14418303271838216-13933059781515250-12799677869947584-13772563175545105-12314969432467232-14584318945232310-11506040283968000-11344607600393270-8914110735455640-10535437818988355-12643221020806272-13778627156015625-11023508222963168-12969546756894640-8430669218709504-11025327850896452-13782418047545000-13296711263069862-12810950980084672-12973828626994960-10703997449990064-12975256126430000-12164971795699200-14112143556997311-14112919859451864-11355847509497330-12492119383128000-12817295012331259-13467012694011304-12980967171280560-11196700008861696-13469235014075875-8601309874856808-13795312279652455-11199163529206848-13959145421078814-12012018281750000-12499679395753627-13799106230791680-11039892083585636-13800624005994440-13314275302317750-12827873053017664-11204707771121817-12342095901892512-8120246429943950-12830694846464000-11694440833954632-13319401059050896-13807455371681495-11696369972986368-11372096036848750-11047786395557728-8286295354615413-13486280924089856-11699585676144648-8125158949650000-12675944799290058-12839162709622592-10564448792983605-10727568471260784-8127392567968750-11866645437493248-11704732027058376-8779031570261808-14469939968041971-11706662297664000-13495921927410103-11057507636925024-8618825241184211-14473917120134656-11059331004310500-8945538766013080-11873822186120219-11223818609957568-13664530113231396-12363825736004000-14642177215236390-14480282079199232-11552320516275847-13342849843359888-11390863588641250-12530638481956672-13833283097904705-13671289774396128-11881654665917327-8138566800000000-13673543490079284-14651030125368720-12698257097309706-12861761890728256-10745859794678250-11072100188837088-8304531367713693-11561845496983552-11562480681785559-13191723761661000-13843927398596135-12541658463867456-12542347427178569-13683312453513696-14498591730195375-10915269732332032-11567562997721023-8146618585851600-13361188343210038-11732419521216000-11733063935404392-10755899342089968-11897329957272791-8801247989661696-11572646802734375-13855338064241960-12715008492410874-12552684904848704-11412158429013230-11086705573596000-11902558116476143-10598750183057920-10925465500027179-13209123900680424-10600496302361875-11253452439190464-10601660488435445-10765354038256752-11907787807095687-10603406927360000-10930265704480307-13214927345360328-10605153558070955-11258396476216896-10606318085098125-13381012787807152-10933866780367541-14198487047483904-13709636633401716-13710389248500000-14527281289424139-11753052481138176-10937468647106159-10774814273405424-8326449876130125-10939269877071872-14368784912362584-14696154815248080-12084168306775246-11268288894024000-8655827394359393-12086158161769072-14700188305102230-12250829243020800-11761441526133000-14212521794785752-11435989933127410-12580279278153664-14214861818126883-11111076414284000-11928721888220903-11275712008998912-13564281915495011-14382196478674112-8662479996234375-12585803001138752-10951884024311111-12096774411057648-13078311495107120-11934614015936000-14224224479981967-13897993280718280-10791975072779142-11283138383299776-10956691963231375-14718751864277040-8341083620255853-12921210879705088-11613370875818599-13413361290138000-13904856738216535-11778877680615936-11452314800538990-12434623817841184-8344744733371125-10963305176550912-11618468092347983-14401144658242496-10801450895010534-11293045287000000-10966312062084767-13422192648105456-8348406917633277-12277742302924800-11623566800136375-13588858481808728-13425873524361926-12607914062044224-12117361081489346-11135482943548000-8188304091371550-11300479269176832-13594075506343051-8844823239102576-13923170337949375-12613445870694592-13269417328604853-12451000126601632-8847248294355786-11960824725504000-11797624587409992-13273055310378888-13273782986516427-12946744993218496-14094697580218750-11145255553903968-8523309700806316-8523776936290304-14261716239036543-13934624499445000-13443551098191062-11804740683204096-11805387742860264-10822198590647664-11970663626622375-8855496797773824-11643976548242263-13940735953398120-12793376480462682-12630051004648000-11482493819371470-11155033880281184-11975913246059711-10664068783080960-10992796365422875-13290526878987816-10665822068896995-11322800788832448-10666991032863685-10831692093750000-11981164400052823-10668744638955520-10997616269857059-13296354140498184-10670498437226875-11327765115011904-10671667742846045-13463456908775984-11001232122621093-14285964645312000-13794100850298804-13959081036191880-11989044008825131-11332730892006336-11990357612740125-11169712091042528-8213473501783150-11006657387679744-11664410173941239-13472310239306000-10679855274140715-11502012585535360-12488583384681692-11174607687784032-13640341738953125-12983686956245504-14299273820002671-10683950609731880-12163932999864286-12657758602104000-13973615635230985-12330336082482600-8878328161201098-12331686612172800-14141108328049750-13977442205870760-11511465085498210-12334387967390400-10690388252119485-10855450137774000-12007443196203983-10692144421470720-11021736926422219-13325515999052904-10693900783141875-11352608512373184-10695071797772245-10860205911561072-12012703562241127-10696828480000000-11026565286054867-13331353482706248-10698585354575755-11357581546622016-12345873128259375-14651238084836824-13005743447779497-13006455363086848-11031395055607643-9056118480255000-12020596991602363-11362556032957632-13998117759392745-8234637595257200-13999650092436875-8894382120566784-11365665824399397-12025203088494536-12190599023009166-11367531971592000-8732060369572033-10874481566536368-14829649986579030-8898276901764096-11700226516359375-14008079923117960-13514416564797206-13020699125452608-11537959633535230-12527613032612000-8407147669647741-10715578394193920-13683717978285571-14343959018416248-12201276334832750-13026399540895424-13192012364340240-13852370784711648-14842637801254710-14678522571456000-13854644357006964-13855402269717792-10722028733981955-11382468503407296-13197786832090000-11218732445166048-8249519195171150-11714958014021632-14355733733818263-13696449107375000-10891748000565366-11387450253356352-10727894925051005-10893535225839024-12049569148575375-10729655199511040-11060403292773131-13372263609933672-10731415666515635-11392433456664000-10732589418159765-10898302115707248-12054841809896231-10734350206095360-11065242937529875-13378114737045576-12057478717262499-10901878195562112-8424639220162359-13546238976846000-12060116009136703-8591237265668096-11235309128089956-8426942544520824-11567024082031250-12889674340403328-11403027590265177-8428785506251752-12561229763501364-14710665310208000-11240223871829188-13555128556991376-10745506335420155-11407391788858176-13061350892725875-10912611128658096-12070669022273519-13063492800050688-14387164473971103-14884087065210000-14223349430017506-12900952217422464-11413004537337033-10917383581432944-12075947836618375-8602515142787072-11084615634282291-13401536313502152-8603925571004348-11417371281000000-8935822324513854-13569953164942256-12081228189779871-13405930900176384-14565263967551000-14566059825628608-12249401394767582-12746695175161024-11919638924022888-8443538874321000-8609568825521612-8278883853926400-11756657349081287-13578853115723408-14076409403424375-11924198182605312-13912324533509892-8447229904340232-8613332365745068-11098553717696000-11761796403309231-14413129344533976-12922821820620426-12757841450278848-10770194675703125-13587756957051632-8782810406487099-13754963763900416-11766936954903319-13756466327031000-13591468039392262-11934623710480896-11935275507665064-10941266717865264-12102364995077375-8952923281204224-11772079004081663-14094103641842120-12934119021565482-12768994221368000-11608810441173470-11277745930812384-12107653045685911-10781375622184960-11113717055227875-13436719909585416-10783141741847995-11447344675338048-10784319262102685-10950829716750000-12112942636456623-10786085703211520-11118572238538859-13442589822455784-10787852337201875-11452345335482304-10789030200357045-13611519560844784-11122214553837293-8300613196800000-11953535465209032-13448461444615368-10792564304232555-11457347451740736-10793742510338125-10960398286245936-12123526439381599-10795509980270080-11128286846859003-13454334776313000-10797277643139715-11462351024325312-10798456192245605-10965184660479984-12128820651984375-10800224176701440-11133146272279811-11632280089454640-12796206327191903-11965936751424000-11135576515395447-14959053310875120-8311038634004350-11469859114277376-14462785354581375-13964830516329504-12303021913327422-11472362539320768-10807887672638485-12305035720926000-13303467069141680-10809656686366720-13803853096026531-14968850034580560-14304348104739250-12808080103275072-12975126565827894-12643120650159392-14806567339684911-8651500000000000-11813269336715071-13810631504780664-10816144721526755-11482379882164416-10817324643133125-10984344092054256-12150012915230039-10819094686433280-11152598120503843-13483727086581000-10820864922811515-11487390739559232-10822045187667805-10989137434621104-12155314835371375-10823815745866240-11157464620224171-13489610680732392-10825586497170835-11492403054552000-10826767105326965-10993932171462768-12160618297693191-10828538178498560-11162332535421875-11662774309030320-12829751188460591-11997304515500544-11164767023889063-14998265867430000-13165862203988489-13833242226399744-11167201866302779-14168117966240840-14835661617940875-13002749283159168-13336880074852240-12670726711930272-8336458801215950-11838416748544000-12005809375242312-15008079702067920-14341835594147602-12841645703439168-14510182701802875-11341910348138848-12176537939984079-12177201559753216-14680166272873112-13679991335250000-14348089869597986-12847245665146816-12847945774808529-12681780378607264-15018716186223750-11848743950708736-12016282411453896-13685956230919184-10849214972074635-11517486500904000-8847247027174993-11017926776889648-12187158749858431-12521735707660800-11854555640373375-13858897529282168-8850139597245439-13025443335405696-11356133340758612-11356752001324000-8518028013268461-11190960134127616-14699375211313496-15034270855070160-13698637390843750-11527530090049344-10859858993199645-11027534386080432-12197785733836847-10861633673280000-11196447592461547-13536741060920808-10863408546691155-11532554073456576-10864591903043125-11032340284419696-12203101541675719-10866367098695680-11201326838887923-13542640065549000-10868142487707115-11537579516369472-10869326187808205-11037147578858544-12208418893713375-10871101899107840-11206207502644091-13548540783696552-12211078148876827-11040753966000000-8531956218960351-13718794153139056-12213737790174071-14891532133072896-14557683489588375-14893153656660424-13053137394183354-13221205039757248-15062952299402610-12720518835156000-8536602325964181-11550149510380032-11215973082969099-13560347361545064-14230768734899375-12054954369664512-10883537293629845-12391163033624368-15071153692514310-8373318886400000-14570367850680807-13566253221743688-15074435083128030-13065221437836672-12898420541015625-12731601437068576-8711569793335916-11895290687457792-12063486449641608-13907275877851000-10891832822850915-11562728630937792-10893018242446405-11061204999642864-12235028824732375-10894796533104640-11230632088575651-13578070085933832-10896575017290235-11567762835336000-10897760780934365-11066020674937008-12240355446672111-10899539587688960-11235521260632875-13583981090423016-10901318587998995-11572798500723648-10902504695741685-11070837747750000-12245683614380423-10904284018667520-11240411851460659-11744352675458480-12919490649363375-12081219785021952-11242857678977831-13760663786353584-13090123830004962-12587342107200000-11413144217403108-8392474225576400-12925113217612519-11918609699817024-13933780344221375-12423564097257904-12927925113369651-11585394057412608-11250197290251203-13601724396453000-14274190655042935-12091736624288256-10916744700076605-15116314572722160-8734345541187500-11926389470916096-14782807585060504-13607642263479912-11088311355022374-13273094294728000-12937769960095057-12770441233131168-8738145354301324-11931577865334784-12100286048877000-13949699176313048-10925057092573195-11597998749922368-10926244921557485-11094944081694000-12272347647299583-10928026826462720-11264886094361819-13619483146552104-10929808925091875-11603043185697984-10930997098474245-11099769543877872-12277685094328727-10932779520000000-11269785202135267-13625406163095048-10934562135277755-11608089083946816-10935750653108125-11104596404999856-12283024088696239-10937533591329280-11274685730120043-11780162503270000-12958882887637687-12118055420745216-11277136526755999-11109424665262704-8921689389358875-9090517049155584-14646628776588231-14815785760180416-12459405831065966-13301980235192000-11282039185443687-11114254324869168-12293706720343391-8420804513971200-11452916287062500-13643185515737256-12296378345692059-13307762447775808-11792328784179230-8592020524017000-8760967378352332-12636697008537600-12131888064072264-14660160987102648-11796172507201250-13313546335756224-14156944720552452-11461006262406496-12472948907652006-10956563658560000-11294302048288907-13655047005831528-10958348858203955-11633340519708096-10959539099023125-11128751701777776-12309742278458279-10961324621844480-11299209680417683-13660980328125000-10963110338586315-11638395197247552-10964300924153005-11133586960786224-12315090561565375-10966086964119040-11304118733992731-13666915368914472-10967873198033635-11643451338744000-10969064128397765-13838647528067696-11307801457121949-14684061686857728-11477820689954500-13841652772009872-15024072798005507-11986146884827072-13675078856438829-15195356836470000-13001177625398347-11988749551339008-11482805898936356-8950319779873672-13679533037671875-13342490915101504-14187722349270372-8614441790592552-8614909314614589-13683245594112000-11994606928465911-14698414568061816-11826952364513090-13010353598265408-11490286418640500-8618182456416456-8618650115770053-15041205558660608-11999815087282399-13859693372898000-10986938430466115-11663690548539072-8959552757654121-11157784265244144-12341855215208375-12342524827926528-14879467300110424-15218462621123280-8962469753482647-13190765406000000-12345873254820773-11500889381845344-8626134966459477-11332988141209088-14885926219791000-15225068573335440-13872481611594326-11673818942689728-10997672326460885-11167472995206000-12352571925301863-10999461988536320-11338521926802899-13708508793230664-11001251844756875-11678885337820224-11002445190100845-11172319462750512-12357932605953407-11004235369920000-11343442359357787-13714457590946088-11006025743912355-11683953198603456-11007219434453125-11177167332274416-12363294837307159-11009010132090880-11348364215211363-13720408109397000-12365976534567443-11180804154588288-8640180739162887-13892808507975728-12368658619587375-15080415053801984-14742328537724511-15082050259828008-13218693222011082-12710970997800000-15253992091513890-12881847168688288-14238602904842988-11696629264183296-11358212197637875-13732314309500616-14411234412688455-12207824949901824-11021550453780685-12548291397750000-15262262676769590-11023342705323520-14924718993533976-8819630118096928-13908632036837750-13400505868083264-11704873621316217-11196572834218992-12384759274229367-11028122992640000-11368065875729027-13744227395532168-11029915956614555-11709314494729536-11031111373888125-11201427716681136-12390129262457999-11032904661742080-11372994851163403-13750186521393000-11034698143937715-11714391153880512-11035893906707605-11206284002339184-12395500802734375-11037687712829440-11377925251131411-13756147369482312-11039481713321035-11719469280168000-12739243640350575-15118054705064152-9173249182811898-11042472146101760-14101151302904875-14101915123753848-13253119997957034-13423758855514688-13084625540822913-12915394842244000-15295374912732390-11047257961758720-14107262642026931-9178716155561136-11219038429821750-11729629935000384-11050249798625245-11220861280516272-12411624738092527-11052045160000000-11392725000295467-13774040249609448-11053840715828755-11734712463969216-11055037861083125-11225723180985456-12417002488802439-11056833741025280-11397661100456243-13780007989101000-12419691946581763-11229370527838848-9018013034489841-11570907288260192-12422381792681375-11061623705034240-11402598626179771-13785977452065192-11063420298128835-11744881926072000-11064618134924965-11235451194755568-12427762649953591-11066415052226560-11407537577671875-13791948638750856-11068212164066395-11749968859629888-11069410346708285-11240317308462000-12433145060843343-11071207782801920-11412477955138379-13797921549406824-11073005413461875-11755057261808064-12777927625383975-15163961357602808-13460873876992001-14824802539008000-14825604761407527-13803896184281928-14656781600004402-13123642452565568-14147029391428375-14318250227949024-15171347869166447-11080797394900480-11422362988817883-13809872543625000-11082596063425315-11765238472873152-11083795283904005-11254924079299824-12449301617460375-11085594276823040-11427307645442531-13815850627684872-11087393464392635-11770331282184000-11088593030916765-11259795813494448-12454690245062831-11090392542927360-11432253728864875-13821830436710376-11092192249616595-11775425560963008-11093392162236085-11264668953318000-12460080427404103-11095192193413120-11437201239290739-13827811970950344-11096992419296875-11780521309422144-11098192678061645-11269543498973232-12465472164708447-11099993228480000-11442150176925947-13833795230653608-12468168616541851-11273200330913664-9053210964083625-11616068524925408-12470865457200119-11104795648327680-11447100541976323-13839780216069000-11106596912825115-11790717216228672-11107797864030205-11279296808589744-12476260305103375-11109599453155840-11452052334647691-13845766927445352-11111401237072435-11795817375000000-11112602534572565-11284175572956528-12481656708642471-11114404643164160-11457005555145875-13851755365031496-11116206946574795-11800919004299328-11117408590419885-11289055743966000-12487054668041663-11119211218552320-11461960203676699-13857745529076264-11121014041531875-11806022104338624-11122216031771845-11293937321820912-12492454183525207-11124019179520000-11466916280445987-11981007646765360-13179820526231359-12324653922083328-11469394854484375-14037928259869232-13696279731854640-11471254019382784-11643095782460452-14554656027045000-9075746409173423-11987482467013760-8905468057430724-14043996747090928-12503257883642375-11133639258992640-11476832719523251-15074863230316736-11135443641128235-11821340231016000-11993311799379470-11651275059045984-8910279829776364-14222945605622272-12338643312261000-8568965095566800-14053861768490486-11826449216134848-11141459656219685-14056138967750000-13028344570135476-11143264883179520-11486754874024259-14059175616060048-13888472226388875-13546278466249664-14232934528176519-8746010338856712-8746482611135829-11148079775040000-12349308997690632-15265942317025192-14752156487115042-13552131254445376-14410639108918500-11494820834120232-12524883966756199-12525560183361536-15100120621080792-15100935844984000-15444972714096990-12699885365684352-9267984220545918-12701256596782576-13216885854046875-13904227865581056-12188314427337343-9270486015869808-12533000172476347-11846899876728000-11160725464716165-12706742508205232-13737760387222960-11162532772085760-14254465013109875-14426984171884704-13397208329466234-13569699733540288-13398654461514582-11681508647772000-12712916046465254-11167353212254720-11511585276061419-13917742179491304-11169161235041875-11857134042062784-11170366691976245-11342830521474672-12546534972336327-11172175040000000-11516555646535667-13923751351003848-11173983583179755-11862253334231616-11175189387058125-11347727588011056-12551951619548639-11176998255521280-11521527447512443-13929762251961000-11178807319168515-11867374099684032-11180013470040805-11352626063825904-12557369825536375-11181822859018240-11526500679197571-13935774882611592-11183632443207835-11872496338632000-11184838941123965-11357525949121968-12562789590523791-11186648850690560-11531475341796875-13941789243204456-11188458955497395-11877620051287488-11189665800507285-11362427244102000-12568210914735143-11191476230737920-11536451435516179-12053658930607280-13259739814311375-13777095927956480-11194494048390445-12745188124601328-15501740299390710-12229810076224000-12402729629259912-14987439685228056-14815969054212802-13266175886808768-11199323684973125-12750686677734064-9477372647876265-11201135156756480-11546407917138083-13959842707125000-11202946823864315-11893000033618752-11204154710455005-11377139589173424-12584484244955375-11205966703127040-11551388305452331-13965863989975272-11207778891151635-11898129643224000-11208987125035765-11382046524916848-12589911808305031-11210799638671360-11556370125709875-13971887004011976-11212612347687595-11903260727596608-11213820928915085-11386954871358000-12595340931999903-11215633963589120-11561353378116539-13977911749483944-11217447193671875-11908393286948544-11218656122292645-11391864628699632-12600771616264247-11220469678080000-11566338062878147-13983938226640008-12603487543680051-11395547872731264-8806125045750375-12778203166495344-12951579309577725-8980245425874944-12262149504391599-15198975880792000-9154421783131663-13473271026843264-11746561325033876-11747194085286112-12784399827225750-13994488729276416-14340804083791459-14341576534456536-13478352084373722-13651886747000000-13825440050968080-11752256985371744-8814667462610277-12272060714310144-15038405403903375-13829163506865280-14175655985215926-13484886749483136-14177182848797978-8817991004961000-8991376960302412-14352393756442624-15217815214984536-15045695639087928-11414590614957750-11934078215817024-11242852938642845-11416434586011312-12627948453977007-11244669101120000-11591282979214187-14014096596390888-11246485459174355-11939219629496256-11247696473203125-11421352813013616-12633388506367559-11249513157242880-11596276262427763-14020133468877000-11251330036887915-11944362519638592-11252541398659405-11426272452335664-12638830120897375-11254358604336640-11601270979437051-14026172074789032-11256176005647235-11949506886456000-11257387715211365-11431193504180208-12644273297790711-11259205442600960-11606267130447875-14032212414375816-11261023365651995-11954652730160448-11262235423058685-11436115968750000-12649718037271823-11264053672235520-11611264715666059-14038254487886184-11265872117101875-11959800050963904-13000482141231975-12654483466304376-9534712858576345-11268903293440000-11616263735297427-14044298295568968-11270722260196555-11964948849078336-11271935013438125-11445965136876336-12660612204894399-11273754306414080-11621264189547803-14050343837673000-11275573795135715-11970099124715712-11276786896369605-11450891840838384-12666061633484375-11278606711357440-11626266078623011-14056391114447112-11280426722119035-11975250878088000-11281640171395165-11455819958336688-12671512625559151-11283460508469760-11631269402728875-14062440126140136-11285281041346195-11980404109407168-11286494838714485-11460749489574000-12676965181342983-11288315697950720-11636274162071219-14068490873000904-11290136753016875-11985558818885184-11291350898527245-11465680434753072-12682419301060127-11293172280000000-11641280356855867-12163185615672560-13380223492530279-12512050441809408-9210754501611625-11644409957623272-12687874984934839-11298030254817280-11646287987288643-14080597573221000-11299852354487515-11995872673165632-11301067196431805-11475546567747504-12693332233191375-11302889622602240-11651297053575371-14086653527077992-11304712244686835-12001031818392000-11305927434922965-11480481755968368-12698791046053991-11307750383554560-11656307555921875-14092711217098056-11309573528128395-12006192442625088-11310789066706285-11485418358942000-12704251423746943-11312612537873920-11661319494533979-14098770643530024-11314436205011875-12011354546076864-11315652091981445-11490356376871152-12709713366494487-11317476085760000-11666332869617507-14104831806622728-11319300275536955-12016518128959296-11320516510948125-11495295809958576-12715176874520879-11322341027412480-11671347681378283-14110894706625000-11324165739903315-12021683191484352-11325382323806005-14288172818020848-11675109733142125-15509560850919424-14464749346146819-14814093138540520-11329032598310635-12201151903920000-14467857093117623-8890365530960328-8890842985652997-12029433560065536-12553126512453000-15692250798170640-14995622664345218-13427034307766464-9591253803994995-11684518399201000-8894663238606861-11685773269794816-15349302462878296-15698993145086160-12210983613281250-13956159140910080-13607985753268374-11864009143338336-12737046563900047-9073451788544000-14657901330478644-9423442453804272-11343641539775155-12042358242250176-11693932118701375-14312744927409392-9076862066953356-9426478139301888-12394738419786199-15712483632210000-12919846680759854-13793549649090752-12222788634486990-14668133630386656-12747990806093375-11351559957603840-11701466733691291-14147308595674152-11353387807950435-12052704651000000-11354606483850565-11529911483033328-12753465277350871-11356434661212160-11706491607955875-14153383661010696-11358263034796795-12057880076958528-11359482059537885-11534862244686000-12758941315681263-11361310760184320-11711517920544299-14159460465247464-11363139657081875-12063056984255424-11364359030713845-11539814423321712-12764418921308807-11366188254720000-11716545671662387-14165539008633288-11368017675005355-12068235373102656-11369237397578125-11544768019143216-12769898094457759-11371067145018880-11721574861515963-14171619291417000-11372897088766915-12073415243712192-11374117160330405-11549723032353264-12775378835352375-11375947431280640-11726605490310851-14177701313847432-11377777898566235-12078596596296000-11378998319170365-11554679463154608-12780861144216911-11380829113704960-11731637558252875-14183785076173416-11382660104602995-12083779431066048-11383880874297685-14361973629750000-11735412553773517-15589667463565312-14539458185678691-14890604928206440-11387543707076875-12264166121397120-14016941324199440-14718577463344608-8936758271293029-12091556462784000-12617952729745032-15773286468341520-15073059518955842-13496369785463488-9640780916641875-11744853585302632-8940591664719213-11746112771948544-15428557180802392-15780052005570000-12274031648452770-14028216615203840-13678244303280726-11925262377428832-12802806063859375-9120295847217152-14733575208225972-9472091686273008-11402202895118035-12104525596248000-11754299678956447-15790203938355120-8948261739901437-9124206780203008-12458719163560375-15793588883273040-12986535604845422-13864747127031488-12285877262866830-14743842691116000-12813787937330783-11410148538846720-11761860199521019-14220324201870504-11411982672991875-12114907577467584-11413205538278245-11589414188351472-12819281228263927-11415040000000000-11766902347256067-14226420150432648-11416874658281755-12120100793476416-11418097873008125-11594381967182256-12824776088961039-11419932858913280-11771945935784843-14232517840881000-11421768041406515-12125295493367232-11422991605622805-11599351165429104-12830272519646375-11424827115786240-11776990965313171-14238617273464392-11426662822565835-12130491677352000-11427886736321965-11604321783294768-12835770520544191-11429722770818560-11782037436046875-14244718448431656-11431559001959395-12135689345642688-11432783265305285-11609293820982000-12841270091878743-11434619824209920-11787085348191779-14250821366031624-11436456579786875-12140888498451264-11437681192772445-11614267278693552-12846771233874287-11439518276160000-11792134701953707-14256926026513128-11441355556247955-12146089135989696-11442580518923125-14436028133997552-11795922663460141-15317913492885504-12325417683995430-14263032430125000-14968180833555335-12679608269707776-11447481243957005-15851206984091760-9158965315051500-13915326626865664-15501446577512984-15502276182545856-13036702618990046-13918305716264000-12157145421493689-11629196174001648-12863284086069431-11454222025359360-11807291414999875-14275250467735176-11456060879429595-12161699959103808-11457286891473085-11634175313838000-12868791512951503-11459126073541120-11812346537288139-14281362102231144-11460965452421875-12166906537681344-11462191814354645-11639155874712432-12874300511615847-11464031521280000-11817403102222547-14287475480852808-11465871425046155-12172114602048576-11467098136918125-11644137856827696-12879811082286719-11468938368775680-11822461110008923-14293590603849000-11470778797502115-12177324152417472-11472005859363205-11649121260386544-12885323225188375-11473846616227840-11827520560853091-14299707471468552-11475687569989435-12182535189000000-11476914981889565-11654106085591728-12890836940545071-11478756263836160-11832581454960875-14305826083960296-11480597742707795-12187747712008128-11481825504696885-14485538958742000-11836378072807277-15370447017332736-12014325043172996-14488637138382608-15726312755557875-12723090492160512-14490961062996266-11664080001752112-8836896636657950-9544358570112000-11842707573790587-9545379029703792-15025936840293695-13612458634746048-14673954037109375-13437109864796576-9371116969180299-15737245096214528-15384421395617943-15031559918745000-12379593330726370-13618280485961536-12557786905429227-14681014354170632-12912907531007375-11498408859824640-11852839468144651-15568740529766336-11500252439885235-12208612672536000-12386210956785470-12032962196239584-9202168682522764-14688861806620672-12742826057901000-8849657610006800-14514213978058886-12213832630851648-11506399129936685-14516540636750000-13455073592832276-11508243563947520-11862977139669659-14519643235101648-15759966913224875-13812843739064448-14167776072151440-13460106304119712-8855806161383950-12930167697408000-15587884127312728-14525849757969296-15235241585356242-13641584490298688-13996658965077875-14883318406512864-9036783126482613-9568869680176128-15417335691508383-11696534527458000-15950671693938990-12761218886432256-14534386614476794-11699033519977584-8863377517968750-15777654550360064-12055480967571844-14538268109243664-11524852340517035-12234727343208000-9398190962220273-11704032572797488-12946060628475551-14010868516962816-15430514543451375-15963453590657040-15254781250483458-13836470578060416-12240608271669561-11709033049494000-12951591655638583-11532854854942720-11888346604410819-14373246054100104-11534702114966875-12245183629809984-11535933731229245-11714034950269872-12957124257947727-11537781320000000-11893424833736267-14379385624467048-11539629106032755-12250414006458816-11540861072983125-11719038275327856-12962658435627239-11542709187809280-11898504509001043-14385526942941000-11544557499925515-12255645872288832-11545789817613805-11724043024870704-12968194188901375-11547638458570240-11903585630410971-14391670009770792-11549487296844835-12260879227512000-11550719965320965-11729049199101168-12973731517994391-11552569132482560-11908668198171875-14397814825205256-11554418496990395-12266114072340288-11555651516304285-11734056798222000-12979270423130543-11557501209745920-11913752212489579-14403961389493224-11559351100561875-12271350406985664-11560584470763445-14584899961208304-11917566172654573-15475874124288000-12808303171597512-14410109702883528-15122526679377095-13699960780258368-14946208948114500-12099957371095648-9075452069642373-13346964894374400-12635800676043679-14416259765625000-15128980678406335-14239800054000640-11570454590908005-11749088146954224-12995896597040375-11572305863639040-11929012936841731-14422411577966472-11574157333828635-12287068351944000-11575391756992765-11754101447664048-13001441808591631-11577243556303360-11934102739444875-14428565140156776-11579095553100595-12292310647977408-11580330327352085-11759116174278000-13006988597307303-11582182653317120-11939193989633939-14434720452444744-11584035176796875-12297554434887744-11585270302185645-11764132326998832-13012536963411647-11587123154880000-11944286687614747-14440877515079208-11588976205117155-12302799712886976-11590211681693125-11769149906029296-13018086907128919-11592065061191680-11949380833593123-14447036328309000-11593918638261115-12308046482187072-11595154466074205-14628512890135088-11953202393449125-15522149667743232-14987701790046132-15166935010525320-14453967086010819-14097830213000000-13741655330395377-13563915001986208-9459550013696731-12672902604754944-15708096498391000-14816380422551128-13210488788716782-14103840799238848-12319200819502401-11784211203006000-13391862540617325-13035440651922944-12857557928853384-15537043516581528-15359275010805250-14109853093637184-15003681000589092-13575482139196832-16077085227878310-12326421921792000-15721491452846168-14293026263859840-15365821667442962-13758503372477248-12508396552968750-15010875349173984-9292941581964716-13761434871765504-15549462332638143-14299117690960000-14657376222040662-13943124797656704-14658937482799034-9117629584052904-9296901712559500-14840075674267648-15734894020098264-15556916797763064-11802427407290454-12339558427176000-11624840685888365-11804312912943408-13056980705149311-11626697755112960-11985080416662875-14490197058488616-11628555022104995-12344815641517248-11629793309975685-11809341909750000-13062543277843223-11631650906603520-11990186154031459-14496369885438984-11633508701026875-12350074348855104-11634747340534045-11814372334690992-13068107430168367-11636605464640000-11995293341250027-14502544465224168-11638463786569555-12355334549401536-11639702777763125-11819404187969136-13073673162348999-11641561429422080-12000401978524403-14508720798093000-11643420278932715-12360596243368512-11644659621862605-11824437469787184-13079240474609375-11646518801149440-12005512066060411-14514898884294312-11648378178316035-12365859430968000-11649617873032165-11829472180347888-13084809367173751-11651477580021760-12010623604063875-14521078724076936-13087594406140019-11833249151002752-9502963217969057-12193129784092000-13090379840266383-11656437766238720-12015736592740619-14527260317689704-11658298198941875-12376390287912384-11659538597380245-11839545888508272-13095951894111527-11661399360000000-12020851032296467-14533443665381448-11663260320583755-12381657957681216-11664501070958125-11844584886513456-13101525528933439-11666362361505280-12025966922937243-14539628767401000-11668223850044515-12386927121930432-11669464952404805-11849625314072304-13107100744956375-11671326770954240-12031084264868771-14545815623997192-11673188787523835-12392197780872000-11674430241919965-11854667171387568-13112677542404591-11676292588546560-12036203058296875-14552004235418856-11678155133221395-12397469934717888-11679396939703285-11859710458662000-13118255921502343-11681259814481920-12041323303427379-14558194601914824-11683122887336875-12402743583680064-11684365045954445-14741059461213104-12045164440078773-8989406499200000-12945433433336712-14564386723733928-11688092050069955-12408018727970496-11689334560873125-11869801323899376-13129417425543479-11691198492180480-12051568149618883-14570580601125000-11693062621620315-12413295367801152-11694305484659005-11874848902267824-13135000550935375-11696169944343040-12056692751091531-14576776234336872-11698034602187635-12418573503384000-11699277817511765-11879897911406448-13140585258873831-11701142805647360-12061818805089875-14582973623618376-11703007991971595-12423853134931008-11704251559631085-11884948351518000-13146171549583103-11706117076293120-12066946311819739-14589172769218344-11707982791171875-12429134262654144-11709226711216645-11890000222805232-13151759423287447-11711092756480000-12072075271486947-14595373671385608-11712958999988155-12434416886765376-11714203272468125-11895053525470896-13157348880211119-11716069846407680-12077205684297323-14601576330369000-11717936618620115-12439701007476672-11719181243585205-11900108259717744-13162939920578375-15327524760514560-14607005098313313-9558177525433576-15329966615657415-13707521500000000-11724160624767565-11905164425748528-13168532544613471-11726028256284160-12087470870170875-14613986919779496-11727896086129795-12450273739547328-11729141416214885-11910222023766000-13174126752540663-11731009576632320-12092605643645699-14620194850704264-11732877935406875-12455562351330624-11734123618126845-11915281053972912-13179722544584207-11735992307520000-12097741871086987-14626404539440488-11737861195298355-12460852460561856-11739107230703125-11920341516572016-13185319920968359-11740976449146880-12102879552700563-14632615986237000-11742845866003915-12466144067452992-11744092254143405-11925403411766064-13190918881917375-11745962001712640-12108018688692251-14638829191342632-11747831947723235-12471437172216000-11749078688647365-11930466739757808-13196519427655511-11750948965416960-12113159279267875-14645044155006216-11752819440655995-12476731775062848-11754066534414685-11935531500750000-13202121558407023-11755937340459520-12118301324633259-14651260877476584-11757808345001875-12482027876205504-11759055791645045-11940597694945392-13207725274396167-11760927127040000-12123444824994227-12666957470742960-14658256792889307-12668301207390080-13392914431997250-11945665322546736-13575339632719725-12489974837687808-15930088069984792-15930932898584000-13397176750248414-14303149874838592-15028156906574911-13761451714629024-16297320159843750-9778910623432704-12677037812042310-15756582459492024-12678382261477730-14309218674648000-15215672167159044-13767290466471968-9782540829393498-9058388429235200-12863593554115375-14676145360402536-16126496141006267-13046845844841984-9604437350416857-11960876807814000-13230155995214183-12505878878441472-12144033380510419-16313745422932560-9607492682778375-14140078367745408-15047291235518359-15229391126812128-9428218045469548-13599112200000000-12874508586335871-14869938879215056-11787771421934755-12513835959143616-11789020986933125-11971024968739056-13241380872879639-11790895500001280-12154336393593443-14694827202261000-11792770211763515-12519142554292032-11794020129995805-11976101201033904-13246995691811375-11795895172938240-12159490084686571-14701058004143592-11797770414602835-12524450649432000-11799020686118965-11981178868153968-13252612097774791-11800896259010560-12164645232421875-14707290567072456-11802772030652395-12529760244775488-11804022655502285-11986257970302000-13258230090994143-11805898758417920-12169801837005179-14713524891296424-11807775060111875-12535071340534464-11809026038345445-11991338507680752-13263849671693687-11810902671360000-12174959898642307-14719760977064328-11812779503180955-12540383936920896-11814030834848125-11996420480492976-13269470840097679-11815907998036480-12180119417539083-14725998824625000-11817785360059315-12545698034146752-11819037045210005-12001503888941424-13275093596430375-11820914738647040-12185280393901331-14732238434227272-11822792630946635-12551013632424000-11824044669630765-12006588733228848-13280717940916031-11825922893391360-12190442827934875-14738479806119976-11827801316042595-12556330731964608-11829053708310085-14923596228966000-12194315610180637-16199276756303872-15107990414137011-15472857406752040-11832811415546875-12743702221864320-14565002044858640-15294061656531168-9286171796676789-12564309196608000-13111277448185352-16389964264191120-15662350337702882-14024009370255808-10017679717051875-12204001154109352-9290104462769853-12205292947329024-16031680914547672-16396904997810000-12753823232315970-14576569322071040-14212907174275446-12391395275030112-13303231204873375-9476775726159872-15309447763753332-9842308614381168-11847850202506435-12577614147000000-12213691825286767-16407319771836720-9297973125587277-9480787908886528-12945606832786375-16410792342943440-13494032017867982-14406553068506048-12765975516618030-15319981043724000-13314497371600463-11856001529848320-12221448054759499-14775965059509864-11857883136181875-12588264867609024-11859137650997845-12042222863763312-13320132839436007-11861019589120000-12226620698255187-14782218774402888-11862901726329355-12593592481928256-11864156595078125-12047319202061616-13325769897218559-11866039064122880-12231794801068763-14788474253577000-11867921732282915-12598921599206592-11869176955014405-12052416978023664-13331408545172375-11871059955056640-12236970363406051-14794731497281032-11872943154242235-12604252219656000-11874198731006365-12057516191852208-13337048783521711-11876082262120960-12242147385472875-14800990505763816-11877965992406995-12609584343488448-11879221923253685-12062616843750000-13342690612490823-11881105985515520-12247325867475059-14807251279274184-11882990246976875-12614917970915904-11884246531956045-12067718933919792-13348334032303967-11886131125440000-12252505809618427-14813513818060968-11888015918151555-12620253102150336-11889272557313125-12072822462564336-13353979043185399-11891157682094080-12257687212108803-14819778122373000-11893043006130715-12625589737403712-11894299999524605-12077927429886384-13359625645359375-11896185655677440-12262870075152011-14826044192459112-13362449543251147-12081757099632000-9336396489204591-12266110106332456-13365273839050151-9154780804915200-12451159688490500-14832312028568136-14100597082526031-14467610639773888-16116670829342072-9340836753789000-9341330203405221-12638937907011072-13189153630266504-15204966362577272-11908132772891875-12641608669397184-11909390829282245-12093250965945072-13376575001879127-11911278080000000-12278427429656867-14844852999850248-11913165530085755-12646951322846016-11914423940908125-12098361690004656-13382227971465839-11916311723297280-12283616136969643-14851126135521000-11918199705082515-12652295481373632-11919458470386805-12103473853755504-13387882533466375-11921346784522240-12288806305864371-14857401038209992-11923235298081835-12657641145192000-11924494417917965-12108587457400368-13393538688104991-11926383263874560-12293997936546875-14863677708166056-11928272309283395-12662988314513088-11929531783701285-12113702501142000-13399196435605943-11931421161553920-12299191029222979-14869956145638024-11933310738886875-12668336989548864-11934570567936445-12118818985183152-13404855776193487-11936460477760000-12304385584098507-14876236350874728-11938350587091955-12673687170511296-11939610770823125-12123936909726576-13410516710091879-11941501212692480-12309581601379283-14882518324125000-11943391854098315-12679038857612352-11944652392561005-12129056274975024-13416179237525375-15622402863951360-14888016501238233-9742055672577736-13419011098887867-12684392051064000-9927439283090574-13604986424298672-14157286830428819-14893516032344064-15997583404272375-16182317366150848-14895873388775403-13241474870690304-12690416194520721-13978587105428000-16554463241787990-16371388337449472-16004336169923679-15637245217628040-12878410644531250-14166998952981952-13063765998067443-12512435835674336-13433176383279047-9569342674944000-16011090835588167-16195980535765184-12883845815217090-14357042498378112-15646320171100625-13990388775418656-9756969865973459-13071347052954112-16017847401533103-15282200514827000-12152752085494086-14731385382743040-12890641928776990-12522998195218912-13444515785568375-16392123276591104-15656224123933205-13446642633663816-14368403114574522-13816500675000000-11974931930045565-13633718215367792-14002935326000852-11976826098332160-12345994686980875-10135306066897880-12715872495050367-13085138302137152-13454442995712317-12533566497228000-14746149662882480-12719224540434432-12351202410913299-14932837788475464-15671087888174375-13275032974797312-14566428939329827-12170063086673712-13461536851167807-14568732377152000-16044892673462607-16599039650050320-15862140518612162-14387350790047872-12727942615265625-12175195427391216-13467213730508759-11991986635898880-12361622251756963-14945435352117000-11993882602161915-12732638612880192-11995146690685405-12180329210841264-13472892205627375-11997042990000640-12366834369079851-14951736789939432-11998939489161235-12738006881496000-12000203932965365-12185464437226608-13478572276747911-12002100765224960-12372047951277875-14958039998761416-12003997797357995-12743376658794048-12005262596492685-12190601106750000-13484253944094623-12007159961771520-12377262998556859-14964344978831784-12009057526951875-12748747944986304-12010322681467045-12195739219614192-13489937207891767-12012220579840000-12382479511122627-14970651730399368-12014118678142555-12754120740284736-12015384188088125-12200878776021936-13495622068363599-12017282619630080-12387697489181003-14976960253713000-12019181251129715-12759495044901312-12020447116555605-12206019776175984-13501308525734375-12022346081341440-12392916932937811-14983270549021512-12024245246113035-12764870859048000-12025511467069165-12211162220279088-13506996580228351-12027410965173760-12398137842598875-14989582616573736-13509841206466619-12215020001069952-9439375988173119-12586497202732000-13512686232069783-13883627620761600-16105855805943159-16662107174020560-15181830080539750-14442013149403008-12961463237728110-12591798454511456-13518377481482927-9259650000000000-13334597796312072-15002212069404648-12039445765036755-12781007360788416-12040713052883125-12226598218310256-13524070328692039-12042614151393280-12413809369065843-15008529455181000-12044515450001515-12786389215175232-12045783093577805-12231746440237104-13529764773921375-12047684725706240-12419036144402171-15014848614196392-12049586557960835-12791772580152000-12050854557316965-12236896107126768-13535460817395191-12052756723138560-12424264386671875-15021169546699656-12054659089114395-12797157455930688-12055927444300285-12242047219182000-13541158459337743-12057830143889920-12429494096080779-15027492252939624-12059733043661875-12802543842723264-12061001754727445-12247199776605552-13546857699973287-12062904988160000-12434725272834707-15033816733165128-12064808421802955-12807931740741696-12066077488798125-12252353779600176-13552558539526079-12067981256148480-12439957917139483-15040142987625000-12069885223737315-12813321150197952-12071154646712005-12257509228368624-13558260978220375-15787846316687360-15045679915899633-10030980677712048-12260732118121014-12818712071304000-12076233228668765-12262666123113648-13563965016280431-12078138064079360-12450427609224875-15052800820243176-12080043099784595-12824104504271808-12081313234868085-12267824464038000-13569670653930503-12083218604421120-12455664657417139-15059132398899144-12085124174296875-12829498449313344-12086394665509645-12272984251344432-13575377891394847-12088300569280000-12460903173983547-15065465752784808-12090206673401155-12834893906640576-12091477520793125-12278145485235696-13581086728897719-12093383958855680-12466143159129923-15071800882149000-12095290597297115-12840290876465472-12096561800918205-12283308165914544-13586797166663375-12098468773347840-12471384613062091-15078137787240552-12100375946184435-12845689359000000-12101647506084565-12288472293583728-13592509204916071-12103555012956160-12476627535985875-15084476468308296-12105462720262795-12851089354456128-12106734636491885-12293637868446000-13598222843880063-12108642677880320-12481871928107099-15090816925601064-12110550919731875-12856490863045824-12111823192339845-12298804890704112-13603938083779607-15841033850880000-15096366282987441-9878388091931944-12861218424470823-14912340736209920-12303327222656250-15659602458895584-9694548713583916-12864595963519488-16407882546676632-15103503169857000-15290769089885462-12867298420473792-12122004581156405-13801160645275696-14920957114830000-12123914226544640-15482118738839299-14736766267013688-14550988886976282-14178631010144000-15671941274154564-9515606770271688-9889286997269971-10076406309467136-13249303845977375-16795773913332240-15303619599872886-12878112032979648-12132191674131685-12319487457750000-13626815057218423-12134102389227520-12508115933878659-15122545864149384-12136013304926875-12883521110416704-12137287360178045-12324661720028592-13632538305159567-12139198610240000-12513369145506827-15128896984017768-12141110060933555-12888931702259136-12142384472863125-12329837430919536-13638263155381799-12144296257966080-12518623827773203-15135249881853000-12146208243728715-12894343808718912-12147483012386605-12335014590625584-13643989608109375-12149395332605440-12523879980883611-15141604557903912-12151307853512035-12899757430008000-12152582978948165-12340193199349488-13649717663566551-12154495834357760-12529137605043875-15147961012419336-12156408890483195-12905172566338368-12157684372747485-12345373257294000-13655447321977583-12159597763422720-12534396700459819-15154319245648104-12161511354841875-12910589217921984-12162787193984245-12350554764661872-13661178583566727-12164701120000000-12539657267337267-15160679257839048-12166615246787755-12916007384970816-12167891442858125-12355737721655856-13666911448558239-12169805904289280-12544919305882043-15167041049241000-12171720566520515-12921427067696832-12172997119568805-12360922128478704-13672645917176375-15921038921564160-15172609076422353-9928277097104296-12364163119074294-12926848266312000-13864303270759714-12366107985333168-13678381989645391-12180019756802560-12555447798796875-15179769970673256-12181935490145395-12932270981028288-12183212757299285-12371295292422000-13684119666189543-12185128825425920-12560714253578579-15186137101201224-12187045094436875-12937695212057664-12188322718718445-12376484049947952-13689858947033087-12190239322560000-12565982180850907-15192506011935528-12192156127313955-12943120959612096-12193434108773125-12381674258113776-13695599832400279-12195351248404480-12571251580819683-15198876703125000-12197268588976315-12948548223903552-12198546927663005-12386865917122224-13701342322515375-12200464603159040-12576522453690731-15205249175018472-12202382479623635-12953977005144000-12203661175587765-12392059027176048-13707086417602631-12205579387023360-12581794799669875-15211623427864776-12207497799455595-12959407303545408-12208776852747085-12397253588478000-13712832117886303-12210695600197120-12587068618962939-15217999461912744-12212614548671875-12964839119319744-12213893959340645-12402449601230832-13718579423590647-12215813242880000-12592343911775747-15224377277411208-13721453678545651-12406347563432064-13910875764185250-12407647065637296-13724328334939919-12220932315271680-12597620678314123-15230756874609000-12222852336056115-12975707303835072-12224132461629205-12412845981900144-13730078852158375-12226052817571840-12602898918783891-15237138253754952-12227973374623435-12981143673000000-12229253857723565-12418046350222128-13735830975470271-12231174749980160-12608178633390875-15243521415097896-12233095843373795-12986581560385728-12234376684050885-12423248170806000-13741584705099863-12236298112696320-12613459822340899-15249906358886664-12238219742506875-12992020966204224-12239500940810845-12428451443854512-13747340041271407-12241422905920000-12618742485839787-15256293085370088-12243345072222355-12997461890667456-12244626628203125-12433656169570416-13753096984209159-12246549129850880-12624026624093363-15262681594797000-12248471832719915-13002904333987392-12249753746427405-12438862348156464-13758855534137375-12251676784688640-12629312237307451-15269071887416232-12253600024199235-13008348296376000-12254882295683365-12444069979815408-13764615691280311-12256805870632960-12634599325687875-15275463963476616-12258729646859995-13013793778045248-12260012276170685-12449279064750000-13770377455862223-12261936387883520-12639887889440459-13206543797850480-14527958061068375-13773979375103168-15095561462263440-9435219396335600-16040711923138715-13399413106176000-16231123908571766-12268351547525320-10003948290550791-14346034591385344-14535558352863625-14158751812792200-16047424571238355-13405020337142272-16237916002599174-14539359492581000-16239614322119746-13974352336570752-12275410807017605-12464915041235184-13787672396484375-12277336529469440-12655762434989411-15301050107106312-12279262453311035-13035590901768000-12280546514427165-12470129941299888-13793440593064751-12282472773941760-12661056902288875-15307451104104936-12284399234874195-13041043983019968-12285683654066485-12475346295654000-13799210398205383-12287610450718720-12666352845989619-15313853886037704-12289537448816875-13046498584824384-12290822226135245-12480564104500272-13804981812130527-12292749560000000-12671650266297467-15320258453153448-12294677095338755-13051954707393216-12295962230833125-12485783368041456-13810754835064439-12297890101985280-12676949163418243-15326664805701000-12299818174639515-13057412350938432-12301103668359805-12491004086480304-13816529467231375-12303032076874240-12682249537557771-15333072943929192-12304960686918835-13062871515672000-12306246538914965-12496226260019568-13822305708855591-12308175484866560-12687551388921875-15339482868086856-12310104632376395-13068332201805888-12311390842698285-12501449888862000-13828083560161343-12313320326161920-12692854717716379-15345894578422824-12315250011211875-13073794409552064-12316536579909445-12506674973210352-13833863021372887-12318466600960000-12698159524147107-15352308075185928-12320396823624955-13079258139122496-12321683750748125-15545089758907952-12702139098792741-16873871900645888-12703465808419883-9480693431250000-15549149164997782-14791426441693824-16309347424086222-9672327348045864-9862495784511500-14225496290611200-13467506321232503-17072378254432080-15555645684593478-13090190164584000-12331982394106765-12522358961318448-13851211066684831-12333914028367360-12714082811314875-15371559286526376-12335845864326595-13095658460899008-12337133867026085-12527589869718000-13856996969762103-12339066039173120-12719393530348739-15377979931486344-12340998413046875-13101128279886144-12342286774371645-12532822234637232-13862784483866447-12344219484480000-12724705728047947-15384402364117608-12346152396343155-13106599621757376-12347441116343125-12538056056278896-13868573609222119-12349374364487680-12730019404618323-15390826584669000-12351307814415115-13112072486724672-12352596893140205-12543291334845744-13874364346053375-12354530679395840-12735334560265691-15397252593389352-12356464667462435-13117546875000000-12357754104962565-12548528070540528-13880156694584471-12359688429404160-12740651195195875-15403680390527496-12361622955684795-13123022786795328-12362912752009885-12553766263566000-13885950655039663-12364847614712320-12745969309614699-15410109976332264-12366782679281875-13128500222322624-12368072834481845-12559005914124912-13891746227643207-12370008235520000-12751288903727987-15416541351052488-12371943838453355-13133979181793856-12373234352578125-12564247022420016-13897543412619359-12375170292026880-12756609977741563-15422974514937000-12377106433398915-13139459665420992-12378397306498405-15616638579842928-12760601754560125-15427800562139136-15809558211111699-9905299905533344-13334752807727330-14668992881928000-15812855704687943-16004206416583392-9907882414664364-12766590981027328-16578377929365375-15245280208586880-12578011868817318-14865698058946176-12960514946730132-12961190583500000-10102631042923003-14296921243545600-13535124295047767-16014221216066976-10104737696130375-14490567826306816-14681998437852361-14492078466868512-9916149460249708-13540063606336000-16782925354754328-9917700043073056-16403204939119042-14878100782127232-12399063484413125-14116592550614704-15261976472261040-12401002117038080-15835950999133747-9921835720836000-13357013332628770-14693480310220096-15839252161495911-16030921831278816-9924421103187500-12787901185531392-13552064079091343-15843379259557816-12408112165510035-13172374586328000-12409405193506165-12600975614130288-13938168872722951-12411344903925760-12793898950333875-15468056779630536-12413284816465195-13177865744981568-12414578203785485-12606228391614000-13943978964753183-12416518453214720-12799231870959419-15474504265787304-12418458904791875-13183358429486784-12419752651486245-12611482628658672-13949790671174327-12421693440000000-12804566273337667-15480953543347848-12423634430689755-13188852640055616-12424928536808125-12616738325467056-13955603992210639-12426869864481280-12809902157674443-15487404612561000-12428811394358515-13194348376900032-12430105859950805-12621995482241904-13961418928086375-12432047726858240-12815239524175571-15493857473675592-12433989795997835-13199845640232000-12435284621113965-12627254099185968-13967235479025791-12437227027330560-12820578373046875-15500312126940456-12439169635807395-13205344430263488-12440464820497285-12632514176502000-13973053645253143-12442407766097920-12825918704494179-15506768572604424-12444350913986875-13210844747206464-12445646458300445-12637775714392752-13978873426992687-12447589943360000-12831260518723307-15513226810916328-12449533630735955-13216346591272896-12450829534723125-15708017795015152-12835267852594541-15518071666225152-12836603815940083-15519686842125000-16286938643563335-14754818074289216-14755585874573929-14564712744332064-9582546464318750-15524533042269696-16675366087798191-9775723234449912-12651594201983814-13227354861624000-12461200004225765-12653569093540848-13996342467527031-12463145108111360-12847294860159875-15532612284227976-12465090414397595-13232861288332608-12466387397705085-12658836475758000-14002168713557903-12468333041349120-12852642607574539-15539077695619944-12470278887421875-13238369243012544-12471576230602645-12664105319563632-14007996576222247-12473522414080000-12857991838800147-15545544900904008-12475468800014155-13243878725875776-12476766503118125-12669375625160496-14013826055744319-12478713226503680-12863342554042523-15552013900329000-12480660152374115-13249389737134272-12481958215451205-12674647392751344-14019657152348375-12483905478819840-12868694753507491-15558484694143752-12485852944701435-13254902277000000-12487151367801565-12679920622538928-14025489866258671-12489099171228160-12874048437400875-15564957282597096-12491047177195795-13260416345684928-12492345960368885-12685195314726000-14031324197699463-12494294303928320-12879403605928499-15571431665937864-12496242850056875-13265931943401024-12497541993352845-12690471469515312-14037160146895007-16345488070080000-15577098223925241-10192952046345544-14040078728220891-13271449070360256-10386891249468750-15773506441560432-14812477040867891-15582766156480512-16737914934339543-16931184592696000-15585195691260171-13854227193156096-17318683912665330-13085907809157472-9814940847559125-17128924042678784-16744874445666111-9623991103563600-17324084094697710-14822486511448000-16170825444481764-9818511277086888-10011551240673164-14440487586508800-16751835885870375-15789906994548752-15020447938994394-14828648426360384-16562727475024414-9822592828125000-10015712966259052-12520291578795520-12906201725284059-15989110280456312-16567890509373250-14834812048765632-16376941855052905-14643673309226912-10212565765113387-13681694928896000-16765764553981047-15995755565702424-12720177102200502-15419197276779520-13492498332048750-13107679097714528-14072209827476399-17157420791106048-16387151741446765-14074402367609000-15039183488550858-14461504302273600-12533954572679605-14270166192380976-14656607399312500-12535907239997440-12922298425681011-10608407726122360-14080981354430147-13695912137592000-14082443629869493-13118573791472224-15434417541414960-13312876288574976-12927666965178875-15629781926996136-12543068755256195-13315641164223168-12544371141904485-12738022713174000-14089756525620983-12546324890910720-12933036991369219-15636274272896904-12548278842766875-13321172063909184-12549581590037245-12743313505137072-14095608664698127-12551535880000000-12938408504457867-15642768416422248-12553490372840755-13326704494958016-12554793480783125-12748605761932656-14101462423996839-12556748311777280-12943781504650643-15649264357821000-12558703345677515-13332238457581632-12560006814341805-12753899483763504-14107317803741375-12561962186442240-12949155992153371-15655762097341992-12563917761476835-13337773951992000-12565221590912965-12759194670832368-14113174804155991-12567177504194560-12954531967171875-15662261635234056-12569133620438395-13343310978401088-12570437810696285-12764491323342000-14119033425464943-12572394265233920-12959909429911979-15668762971746024-12574350922761875-13348849537020864-12575655473891445-12769789441495152-14124893667892487-12577612469760000-12965288380579507-15675266107126728-12579569668646955-13354389628063296-12580874580698125-12775089025494576-14130755531662879-12582832117972480-12970668819380283-15681771041625000-12584789858293315-13359931251740352-14522417459210775-14135885992646072-15492185224110000-10070442568056832-12976050746520131-15688277775489672-10072009193520508-14915094629512000-16271855978144004-14722918742122528-9880365620966997-14143217376563712-12981434162204875-15694786308969576-12595234569668595-13371019097846208-12596540564784085-12790996574598000-14148350853273703-12598499726725120-12986819066640339-15701296642313544-12600459091796875-13376565320698944-12601765448033645-12796302024010032-14154219204658047-12603725151680000-12992205460032347-15707808775770408-12605685058485155-13382113077034176-12606991775893125-12801608940282096-14160089178506519-12608952021319680-12997593342586723-15714322709589000-12610912469933115-13387662367063872-12612219548562205-12806917323616944-14165960775043375-12614180335843840-13002982714509291-15720838444018152-12616141326340435-13393213191000000-12617448766240565-12812227174217328-14171833994492871-12619410095452160-13008373576005875-15727355979306696-12621371627906795-13398765549054528-12622679429127885-12817538492286000-14177708837079263-12624641300344320-13013765927282299-15733875315703464-12626603374831875-13404319441439424-12627911537423845-12822851278025712-14183585303026807-12629873950720000-13019159768544387-15740396453457288-12631836567315355-13409874868366656-12633145091328125-15938023842339632-13023206127417861-16911606154919424-13996536823878408-15746919392817000-13414737125898879-13609858378309760-16527112426745145-13222374624642272-9917294498644125-14585011833139200-17113966703323864-17503826815590480-16726745029523634-14977047176168000-16144925731555543-13227852941580384-14395761764419718-15758338872559104-13035350234302875-15759970677349416-17317407522923947-14983251849365184-14400234272659826-13233332771500000-14207107404913623-12650819011051520-13040750037565859-15766499023019784-12652783796826875-13432111925738304-12654093767022045-12849437228886192-14212991991030767-12656058891840000-13046151331843627-15773029171291368-12658024220097555-13437675028556736-12659334551963125-12854758824909936-14218878201854599-12661300219310080-13051554117342003-15779561122413000-12663266090124715-13443239667189312-12664576783710605-12860081890023984-14224766037609375-12666542993661440-13056958394266811-15786094876633512-12668509407108035-13448805841848000-12669820462464165-12865406424431088-14230655498519351-12671787215093760-13062364162823875-15792630434201736-12673754171247195-13454373552744768-12675065588423485-12870732428334000-14236546584808783-12677032883806720-13067771423219019-15799167795366504-12679000382741875-13459942800091584-12680312161788245-12876059901935472-14242439296701927-12682280000000000-13073180175658067-15805706960376648-12684248041791755-13465513584100416-14637184826259375-17370357685515224-15419429549581097-16200998012330496-13078590420346843-17178738491288000-17570072974979790-15228184066502784-15619458032655760-9957919427443944-17378444304650375-14254966708011008-13084002157491171-15818790702928392-15819608676489579-13671973672560000-13672680612028270-13282719359412064-17580978725235030-10549132644842496-16996703562609375-16020709790609232-16021538090986006-15240787570160256-16023194777387898-9966160747977000-10162101000677132-14266763921240064-13094830109969779-16613702980580840-13487114890308375-15638043004052480-16225308307302199-14857676795626272-17595526744198710-14663696884800000-17206293681537048-17402719219897832-10363952723691871-14862285256137984-15058619917966625-14863821621381536-10170508840430796-13887374007468032-17213409478465112-10172085826500000-16823934444771986-15259705861655424-12717078719467005-14478653190068336-15653406921310000-12719050359575040-13111083237249931-9784896076555600-16048058779749078-15266015436048000-16832630332564366-9982657027810728-10178921316514444-14681895072460800-13899578795148375-17620094720834640-16054693521714566-13510135201439808-12727596488263085-12924073334238000-14295546892909503-12729569215301120-13121926123546139-15864640659567144-12731542146171875-13515719824945344-12732857546664645-12929415515976432-14301455873173847-12734830817280000-13127349807744547-15871197876716808-12736804291756155-13521305987232576-12738120054668125-12934759169643696-14307366481508719-12740093868935680-13132774986250923-15877756900449000-12742067887092115-13526893688513472-12743384012473205-12940104295442544-14313278718138375-12745358370467840-13138201659271091-15884317731012552-12747332932379435-13532482929000000-12748649420279565-12945450893575728-14319192583287071-12750624322076160-13143629827010875-15890880368656296-12752599427817795-13538073708904128-12753916278286885-12950798964246000-14325108077179063-12755891723960320-13149059489676099-15897444813629064-12757867373606875-13543666028437824-12759184586694845-12956148507656112-14331025200038607-12761160576320000-13154490647472587-15904011066179688-14333984372401291-12960161631821184-10015187255859375-14532590375403824-14729736937078725-10213144703483904-13945590363328919-17285567446136000-10411163133890823-15322879889925504-13359097504227316-13359786923007072-14539341927167750-12771702633264640-13165357449282651-17096197068714264-15131897745550663-15525735158376000-13757690386805470-14937691730345888-10024494569560557-13170113556348928-13957109099302375-17299844680459968-16121141545686886-13566050707107648-12780272328326685-16123636906750000-14944629574088276-12782250494507520-13176230234087659-16126964455373648-12784228864801875-13571650727968704-16522861890855012-14950027159703712-17704892782231110-9836558924800000-17116495399173447-15936869451309768-17708546100307230-15348198240565632-12790824906738125-12988276707007536-10430517731203539-14760927878822400-17123559452350383-17714940616170000-14566369045131614-13582855392606912-14371008404131341-14568622815609776-10631705441906250-13585657522028544-17327529189628504-16343853256427416-16935468202763154-15557802071128000-16149437384186762-10044680193832968-17332890890874856-17530759440441856-17137693388901375-17532567294358184-15366413021325834-15564220747553088-17732304918474210-14974718387684000-10049342259755421-12808645551902720-13203438382508819-15963188721196104-12810626644716875-13599673950033984-12811947486739245-13009724987053872-14390286071185727-12813928920000000-13208884502938267-15969773063211048-12815910557542755-13605283219482816-12817231762733125-13015090743983856-14396221127489239-12819213740769280-13214332120763043-15976359215541000-12821195923115515-13610894031104832-12822517491523805-13020457976086704-14402157815451375-12824500014410240-13219781236188971-15982947178434792-12826482741634835-13616506385112000-12827804673310965-13025826683565168-14408096135296391-12829787741122560-13225231849421875-15989536952141256-12831771013300395-13622120281716288-12833093308294285-13031196866622000-14414036087248543-12835076921105920-13230683960667579-15996128536909224-12837060738311875-13627735721129664-12838383396673445-13036568525459952-14419977671532087-12840367554560000-13236137570131907-16002721932987528-12842351916868955-13633352703564096-12843674938648125-16203624487016752-13240228760559941-17193421366562304-16601399775428916-16799900703125000-17591390228865339-15417967476522624-15616437951061883-10082017118724264-10082536337500125-14037195014926336-14037917898542103-16411368830689496-12852938635418635-13644591298344000-15227356978185737-14634836887013872-17800042463770230-9889421675187200-17208479745087375-16022512991572776-17803708858814670-15430675464736896-15233630587491393-15036565365508000-10288705993098572-14048764131115008-14247367516254024-16424894218970392-12863531170546875-13853746735400320-13260697358695511-13459311053264736-17814711064647510-10689376871808000-13857312938142870-9898590180088400-15442595543792586-15245398248873408-13860166340938750-13464854617040608-10099160752141053-14852471410790400-17229753596866503-17824800401010000-10497367150217063-15053603087314688-15252461753741289-15055152608989984-10301424017163500-14066129721401856-17434973473638424-10303014506698784-17040477783421314-15456112386000000-12880756449918565-13079594948614128-14467569136641271-12882744971100160-13279820406415875-16055534338645896-12884733696928795-13678344137233728-12886059627845885-13084979898606000-14473525421998863-12888048694776320-13285287509109899-16062144047714664-12890037966381875-13683975016396224-12891364261165845-13090366326406512-14479483341930407-12893353873920000-13290756112080787-16068755570582088-12895343691377355-13689607440699456-12896670350078125-13095754232218416-14485442896660159-12898660508730880-13296226215534363-16075368907497000-12900650872114915-13695241410355392-12901977894782405-13101143616244464-14491404086412375-12903968599408640-13301697819676451-16081984058708232-12905959508794235-13700876925576000-12907286895478365-13106534478687408-14497366911411311-12909278146152960-13307170924712875-16088601024464616-12911269601614995-13706513986573248-12912597352365685-13111926819750000-14503331371881223-12914589149163520-13312645530849459-16095219805014984-14506314215487875-13115972046013056-10135590346889943-13514815204472416-14509297468046367-16497720515648000-16498568596690123-16896993012983880-16897861589242495-15308261471005888-13718497874621625-10140280497966696-10140801715160013-14118312342454272-14119038008276039-17301682279011000-13921609281916770-15712337989292992-16707648412653828-13525934314158432-14720155589843750-16113430811091456-16512141846376539-10345487974959904-16314877109862998-15718799097288000-16117571590947621-15123436879441568-10149143619462237-14925978147532800-17315024334846375-16121713080132936-12937841914829195-13933776434695040-12939171486661485-16324101186958000-17917616976342390-16524873527099904-17322142901727759-16526571578839672-15531792898430250-15731726626567744-15334242811331521-15135874341900192-17924982524567910-12946485760000000-16532515675981683-10756647075283632-13147688440710582-13746016713105216-12949811340708125-13149714625569456-14545128407195439-12951806962465280-13351009821899243-16141602104001000-12953802789234515-13751666147946432-12955133454314805-13155118802888304-14551105959506375-12957129622794240-13356496444246771-16148235411861192-12959125996313835-13757317130472000-12960457025909965-13160524460651568-14557085149306591-12962453741186560-13361984569546875-16154870536754856-12964450661531395-13762969660893888-12965782055693285-13165931599062000-14563065976820343-12967779317841920-13367474198005379-16161507478930824-12969776785086875-13768623739424064-12971108543864445-13171340218322352-14569048442271887-12973106352960000-13372965329828107-16168146238637928-12975104367179955-13774279366274496-12976436490623125-13176750318635376-14575032545885479-12978434846740480-13378457965220883-16174786816125000-14578025212073123-13180808865932928-10585132192260881-13581621351725152-14581018287885375-12983764799383040-13383952104389531-16181429211640872-12985763907777635-13785595265784000-12987096760701765-13187574963230448-14587005668495831-12989096211087360-13389447747539875-16188073425434376-12991095866681595-13791255538867008-12992429084421085-13192989507918000-14592994687941103-12994429082053120-13394944894877739-16194719457754344-12996429284921875-13796917361118144-12997762867526645-13198405534469232-14598985346445447-12999763412480000-13400443546608947-16201367308849608-13001764162698155-13802580732749376-13003098110218125-13203823043086896-14604977644233119-13005099202567680-13405943702939323-16208016978969000-13007100500210115-13808245653972672-13008434812695205-13209242033973744-14610971581528375-13010436452515840-13411445364074691-16214668468361352-13012438297657435-13813912125000000-13013772975157565-13214662507332528-14616967158555471-13015775162524160-13416948530220875-16221321777275496-13017777555239795-13819580146043328-15022052997467175-17827083594539000-15824851858459649-13822414737887232-13422453201583699-11018996664540920-13824540936120375-14225981593178816-14627463364632149-10219710651759432-15230153502539284-17836225688512000-13628376682523748-18038482060738320-10623206214388351-15634953991942272-16638047486609375-16839369049068384-10424905670877516-15036692371046400-14235465094262119-16241292623637000-16242125097758571-15841896918836672-15842708893529523-15241868203715104-18050505865233750-10028572774732800-17450610950233311-16649137243080376-16449388210075158-15848393493256000-13241108551071786-13643053394613984-10634101250937371-14246412831576064-14447806864461000-16254615623382216-17058186752832455-15453502176619584-16859229848424516-15254370504500000-17864586041375439-13850781977789952-17464924261418799-16261279854652584-16462879838917750-15861391969945664-13251968408889738-13654242721243616-18072717693379110-10040913100800000-13455512850836227-16870462422267552-18076421435359230-15466175040481088-16069576440970000-13458959682788232-14664990832029199-10045028791321600-13461028064478603-16274613781233000-17882898988003579-14467805363897856-16478066737038394-13263513512252784-10048630942968750-17887479179300864-13667537990730244-16482286976757264-13065896612505035-13870662121128000-13067234942901165-13268948821482288-14677013163413951-13069242609845760-13472063012558875-16287954994858536-13071250482420195-13876345653989568-13072589178380485-13274385615414000-14683026792292183-13074597393694720-13477582747408419-16294628334935304-13076605814666875-13882030739198784-13077944876241245-13279823894250672-14689042063593327-13079953640000000-13483103989738667-16301303497519848-13081962609444755-13887717376967616-13083302036683125-13285263658195056-14695058977541639-13085311348961280-13488626739755443-16307980482861000-13087320866953515-13893405567508032-13088660659905805-13290704907449904-14701077534361375-13090670520778240-13494150997664571-16314659291207592-13092680587392835-13899095311032000-13094020746108965-13296147642217968-14707097734276791-13096031155650560-13499676763671875-16321339922808456-13098041770962395-13904786607751488-13099382295492285-13301591862702000-14713119577512143-13101393253777920-13505204037983179-16328022377912424-13103404417861875-13910479457878464-13104745308255445-13307037569104752-14719143064291687-13106756815360000-13510732820804307-16334706656768328-13108768528290955-13916173861624896-13110109784598125-16539753794751152-13514880398003541-10086247569689600-13717998382674532-17753611887000000-13114134102449315-13921869819202752-14527911571997544-10291130385823464-10493453950791500-10090375638220800-14329066250876903-16751736999983896-13119501140536635-13927567330824000-13120843128820765-13323383605852848-14737223388138031-13122856282831360-13527328222384875-16354770438335976-13124869642752595-13933266396700608-13126211997100085-13328835257958000-14743253451336903-13128225700229120-13532863041303539-16361462014687944-13130239609296875-13938967017044544-13131582329757645-13334288396995632-14749285159201247-13133596582080000-13538399369761147-16368155416036008-13135611040369155-13944669192067776-13136954126993125-13339743023168496-14755318511955319-13138968928583680-13543937207963523-16374850642629000-13140983936169115-13950372921982272-13142327389006205-13345199136679344-14761353509823375-13144342739939840-13549476556116491-16381547694715752-13146358296896435-13956078207000000-13147702115996565-13350656737730928-14767390153029671-13149718016348160-13555017414425875-16388246572545096-13151734122750795-13961785047332928-13153078308163885-13356115826526000-14773428441798463-13155094758008320-13560559783097499-16394947276365864-13157111413931875-13967493443193024-13158455965707845-13361576403267312-14779468376354007-17209849262080000-16400811890288241-10731943700501544-13364990019418422-13973203394792256-14176437787968750-10329075179939976-10532144078902316-18027090534947328-17622887575440543-16813498710211000-13370453014504806-13978914902342592-10737975860298361-13777729355381472-14791553183722375-13171233776496640-13577195953344051-16415060346265032-13173252081432235-13984627966056000-13174597732596365-13377967063196208-14797598056983711-13176616381160960-13582744365522875-16421768356539816-13178635235916995-13990342586144448-13179981253643685-13383433593750000-14803644576928823-13182000452075520-13588294289093059-16428478194050184-13184019856726875-13996058762819904-13185366241066045-13388901613263792-14809692743781967-13187385989440000-13593845724260427-16435189859044968-13189405944061555-14001776496294336-13190752695063125-13394371121940336-14815742557767399-13192772993454080-13599398671230803-16441903351773000-13194793498120715-14007495786779712-13196140615834605-13399842119982384-14821794019109375-13198161464317440-13604953130210011-16448618672483112-13200182519104035-14013216634488000-13201530003580165-13405314607592688-14827847128032151-13203551402229760-13610509101403875-16455335821424136-13205573007211195-14018939039631168-15238754836730175-14833144950047000-11176227447421905-13208942807390720-13616066585018219-16462054798844904-13210964962641875-14024663002421184-13212313180792245-13416264052329072-14839958289517127-13214335680000000-13621625581258867-16468775604994248-13216358385595755-14030388523070016-13217706970658125-13421741009860656-14846016342527839-13219730020257280-13627186090331643-16475498240121000-13221753276272515-14036115601789632-13223102228296805-13427219457771504-14852076044016375-13225125828362240-13632748112442371-16482222704473992-13227149634871835-14041844238792000-13228498953907965-13432699396264368-14858137394206991-13230523104514560-13638311647796875-16488948998302056-13232547461593395-14047574434289088-13233897147691285-13438180825542000-14864200393323943-13235921848913920-13643876696600979-16495677121854024-13237946756636875-14053306188492864-13239296809846445-13443663745807152-14870265041591487-13241322061760000-13649443259060507-16502407075378728-13243347520201955-14059039501615296-13244697940573125-13449148157262576-14876331339233879-13246723743252480-13655011335381283-16509138859125000-13248749752488315-14064774373868352-15288577546235775-18143370171967896-16105610186733625-10193943764300800-14272248728415510-16515872473341672-13254153453695635-14070510805464000-13255504608539765-13460121454555248-14888468883540231-13257531512975360-13666152030429875-16522607918277576-13259558624023595-14076248796614208-13260910146179085-13465610340798000-14894540130652703-13262937601605120-13671724649569339-16529345194181544-13264965263671875-14081988347530944-13266317153188645-13471100719042032-14900613028037047-13268345159680000-13677298783393347-16536084301302408-13270373372840155-14087729458426176-13271725629768125-13476592589490096-14906687575917519-13273754187399680-13682874432107723-16542825239889000-13275782951728115-14093472129511872-13277135576117205-13482085952344944-14912763774518375-13279164684963840-13688451595918291-16549568010190152-13281194000535435-14099216361000000-13282546992435565-13487580807809328-14918841624063871-13284576652572160-13694030275030875-16556312612454696-13286606519461795-14104962153102528-13287959878922885-13493077156086000-14924921124778263-13289990090424320-13699610469651299-16563059046931464-13292020508706875-14110709506031424-13293374235778845-13498574997377712-14931002276885807-13295404998720000-13705192179985387-16569807313869288-13297435968470355-14116458419998656-15344757765234375-13299467145040440-15550937892142708-16984125759164416-13710775406238963-17395152841345000-14940127101899843-16168905836551872-16374409060178960-17194004748858336-10644449532619500-14125084718360064-18015517807139864-16992773774422776-10851359675671007-15561232330784000-15766787877734817-15562816493699488-10648784842165964-14540427029643264-18022854982759000-10650410886675872-17615037551794578-15977242512456576-13315046370882685-16798297974750000-16389417428748080-10243907184870400-13932422752464036-16596818711207784-14958387903372875-14139469690490304-17009213090059919-10451976013849512-10452507857872029-14142347856384000-14757983435353032-18448417937981520-17629385208561842-15785252663591488-13735918689402375-13531593409797936-14967523881345599-13327925338990080-13738714283503003-16610335411113000-13329959619119715-14150984697477312-13331315920865605-13537101707871984-14973616599484375-13333350545981440-13744306609595811-16617096512245512-13335385378103035-14156744544648000-13336742047859165-13542611500583088-14979710970810351-13338777225013760-13749900453048875-16623859447829736-13340812609202195-14162505954552768-13342169647018485-13548122788134000-14985806995547783-13344205376286720-13755495814068019-16630624218114504-13346241312616875-14168268927403584-13347598718543245-13553635570727472-14991904673920927-13349635000000000-13761092692859067-16637390823348648-13351671488546755-14174033463412416-13353029262633125-13559149848566256-14998004006154039-13355066096353280-13766691089627843-16644159263781000-13357103137191515-14179799562791232-13358461279487805-13564665621853104-15004104992471375-13360498665546240-13772291004580171-16650929539660392-13362536258750835-14185567225752000-13363894769306965-13570182890790768-15010207633097191-13365932707778560-13777892437921875-16657701651235656-13367970853424395-14191336452506688-13369329732290285-13575701655582000-15016311928255743-13371368223249920-13783495389858779-16664475598755624-13373406921411875-14197107243267264-13374766168637445-13581221916429552-15022417878171287-17492745277440000-13377484939384865-17906158892281656-14202157968322983-14408718433002880-15026998426677125-18527377736640240-10499380816937973-10705794939766784-14618270378720079-18531143336250000-15237491959714174-16267878665140032-14415308343931390-10503115352762664-18123943252041000-18330828329037824-17919809884462791-18332690776456968-16067668760705562-16274491175864000-18541501365958290-15658063143600928-10507918199915397-13393125021519360-13805922387674875-11333795511472280-17516755447569855-14838475878895104-13396526651658085-16901091966726000-15046858229888503-11131117952827392-14636102066163207-18141442145835712-15256078357468750-16287721572487104-17113285353831239-15670791982033952-18558459193503510-14228874558528000-13817145003505547-16705157852648808-13406054280111155-14231764843824576-13407415738543125-13614374910051696-15059088340119719-13409458099015680-13822758591371923-16711944658749000-13411500666887115-14237546588561472-13412862494028205-13619905648970544-15065205879613375-13414905407587840-13828373699480091-16718733302784552-13416948528574435-14243329899000000-13418310724474565-13625437885567728-15071325075658071-13420354191196160-13833990328035875-16725523785004296-13422397865372795-14249114775352128-13423760430081885-13630971620046000-15077445928478063-13425804450040320-13839608477245099-16732316105657064-13427848677481875-14254901217829824-13429211611049845-13636506852608112-15083568438297607-13431256184320000-13845228147313587-16739110264991688-13433300965101355-14260689226645056-13434664267578125-13642043583456816-15089692605340959-13436709394234880-13850849338447163-16745906263257000-13438754728430915-14266478802009792-13440118399866405-13647581812794864-15095818429832375-13442164079984640-13856472050851651-16752704100701832-13444209967670235-14272269944136000-13445574008114365-13653121540825008-15101945911996111-13447620241768960-13862096284732875-16759503777575016-13449666683018995-14278062653235648-13451031092521685-13658662767750000-15108075052056423-13453077879787520-13867722040296659-16766305294125384-15111140243867875-13662819671715456-10558168804887543-13871238910344904-15114205850237567-10352720764800000-14080414232939108-16773108650601768-15945615535368519-16360616943232576-18225408811907000-10562988419301096-10563524022533613-14292551282884608-14914722752914248-17194232707679000-13466045687718715-14295450184494912-13467411204696605-13675295443921584-15126472421859375-13469459653245440-13884608439141611-16786720884327912-13471508309502035-14301249163608000-13472874195738165-13680842668453488-15132608195748551-13474923198197760-13890240283493875-16793529762075336-13476972408393195-14307049710754368-13478338663937485-13686391392894000-15138745628655583-13480388220382720-13895873650557819-16800340480744104-13482437984591875-14312851826145984-13483804609494245-13691941617445872-15144884720804727-13485854720000000-13901508540539267-16807153040583048-13487905038297755-14318655509994816-13489272032608125-13697493342311856-15151025472420239-13491322697249280-13907144953644043-16813967441841000-13493373569710515-14324460762512832-13494740933478805-13703046567694704-15157167883726375-13496792152330240-13912782890077971-16820783684766792-13498843579029835-14330267583912000-13500211312305965-13708601293797168-15163311954947391-13502263085442560-13918422350046875-16827601769609256-13504315066455395-14336075974404288-13505683169289285-13714157520822000-15169457686307543-13507735496785920-13924063333756579-16834421696617224-13509788032186875-14341885934201664-13511156504628445-17045706824480304-13928295071617573-18086911025088000-14137611898747428-17049160052040016-18505513236949723-14971510396712448-17051750278752250-13725274478449776-10398461733111150-11230907334893568-13935349873221683-11232044718750000-16848920159210331-16017685700247616-14562269735109390-14146921124896352-10610728041325125-17269314045884928-18102486602340591-16854892533122472-18728606493988110-16024174533752000-13527585382777765-17066433185763696-10615026275326797-11240008555954176-18109819378812375-17694397353813160-17070753291347366-16447046031649728-17905285515141374-10618788182133000-18531764404396479-15617445846873600-14785263719538607-10829191933186848-17910723902281250-16037157457596352-13538545363650645-13747526413694832-17497737312269676-13957234896384000-17916163390513526-15417013788858832-13751005449600342-14376778660262976-16252833087981750-13753093152853296-15212524308561919-10836867026745344-17506594085783796-18549591827921000-13548140201646115-16258590864756864-10839609010191364-17094094459903088-15218683329108375-13551568027811840-13969246082801891-16889047460498952-13553625001013435-14388422133000000-13554996432113565-13764231139006128-15224844011812271-13557053752220160-13974900789440875-16895883978193896-13559111280483795-14394246226081728-13560483081640885-13769802386406000-15231006356897863-13562540956856320-13980557021878899-16902722340542664-13564599040256875-14400071890588224-13565971211520845-13775375136958512-15237170364589407-13568029641920000-13986214780321787-16909562547794088-13570088280532355-14405899126731456-13571460821953125-13780949390866416-15243336035111159-13573519807610880-13991874064975363-16916404600197000-13575579001509915-14411727934723392-13576951913137405-13786525148332464-15249503368687375-13579011454128640-13997534876045451-16923248498000232-13581071203389235-14417558314776000-13582444485273365-13792102409559408-15255672365542311-13584504581672960-14003197213737875-16930094241452616-13586564886369995-14423390267101248-13587938538560685-13797681174750000-15261843025900223-13589999190443520-14008861078258459-16936941830802984-13592060050651875-14429223791911104-13593434073199045-13803261444106992-15268015349985367-13595495280640000-14014526469813027-16943791266300168-13597556696434555-14435058889417536-13598931089388125-13808843217833136-15274189338021999-13600992852462080-14020193388607403-14648703436710000-17788610154353935-15068760584173056-16534614421521243-13814426496131184-15280364990234375-16537120932040704-18212686263160071-18841661863033680-18005164327136754-16331090386416000-14447463694430529-13820011279203888-15286542306846751-13611992441781760-14031531808738875-16964350652160936-13614055524784195-14452573620235968-13615431029256485-13825597567254000-15292721288083383-13617494459678720-14037203310487619-16971207474733704-13619558098566875-14458415010648384-13620933973645245-13831185360484272-15298901934168527-13622997960000000-14042876340299467-16978066144697448-13625062154848755-14464257974817216-13626438400583125-13836774659097456-15305084245326439-13628502942945280-14048550898380243-16984926662301000-13630567693829515-14470102512954432-13631944310269805-13842365463296304-15311268221781375-13634009408714240-14054226984935771-16991789027793192-13636074715708835-14475948625272000-13637451702904965-13847957773283568-15317453863757591-13639517357506560-14059904600171875-16998653241422856-13641583220686395-14481796311981888-13642960578688285-13853551589262000-15323641171479343-13645026789521920-14065583744294379-17005519303438824-13647093208961875-14487645573296064-13648470937819445-13859146911434352-15329830145170887-13650537704960000-14071264417509107-17012387214089928-13652604680734955-14493496409426496-13653982780498125-13864743740003376-15336020785056479-13656050104020480-14076946620021883-14707999853750000-16179616276735527-16810839212272640-13659496106924005-15551595660041136-18915057235923750-14922631431847936-15133572915623496-18287323292092344-18078036284603794-16186965451272000-13665010917296765-15557874270735472-11563868336121585-13667079353807360-14088315613764875-17033002040342376-13669147999036595-14511058368835008-13670527211816085-13881543266118000-15354602704120103-13672596204933120-14094002405406739-17039877348022344-13674665406796875-14516915506350144-13676044990681645-13887146122301232-15360800011024447-13678114540480000-14099690727169947-17046754505581608-13680184299053155-14522774219741376-13681564254093125-13892750485894896-15366998985244119-13683634360647680-14105380579260323-17053633513269000-13685704676005115-14528634509220672-13687085002250205-13898356357101744-15373199627003375-13689155665635840-14111071961883691-17060514371333352-13691226537852435-14534496375000000-13692607235352565-13903963736124528-15379401936526471-13694678455644160-14116764875245875-17067397080023496-13696749884794795-14540359817291328-13698130953599885-13909572623166000-15385605914037663-13700202730872320-14122459319552699-17074281639588264-13702274717031875-14546224836306624-13703656157191845-13915183018428912-15391811559761207-13705728491520000-14128155295009987-17081168050276488-13707801034763355-14552091432257856-15818287899609375-15397242868401048-11601247096790065-13711255737786880-14133852801823563-17088056312337000-13713328838188915-14557959605356992-13714711021208405-13926408334430064-15404227856742375-13716784469872640-14139551840199251-17094946426018632-13718858127508235-14563829355816000-13720240682032365-13932023255573808-15410438508448511-13722314687976960-14145252410342875-17101838391570216-13724388902920995-14569700683846848-13725771828999685-13937639685750000-15416650829264023-13727846392299520-14150954512460259-17108732209240584-13729921164626875-14575573589661504-13731304462310045-13943257625161392-15422864819413167-13733379583040000-14156658146757227-17115627879278568-13735454912825555-14581448073471936-13736838582163125-13948877074010736-15429080479120199-13738914260398080-14162363313439603-17122525401933000-13740990147716715-14587324135490112-13742374188758605-13954498032500784-15435297808609375-13744450424573440-14168070012713211-17129424777452712-13746526869500035-14593201775928000-13747911282296165-13960120500834288-15441516808104951-13749988075765760-14173778244783875-17136326006086536-13752065078375195-14599080994997568-13753449862975485-13965744479214000-15447737477831183-13755527214174720-14179488009857419-17143229088083304-15450848439100875-13969963454088576-10795515176627823-17358368747925744-15453959818012327-11008854272000000-17784428983339284-18843974421093512-13763145958199755-16516606452907392-16940961829610000-13976996966923056-16942667209723440-14190197952008704-15038130775050559-10590765934050000-14827818524129170-16311421242187456-14617463731698393-14406341400192992-15466409510636375-11441481414672384-15044186296506023-15256843961546304-13986144062461494-14622613661832000-16530742873324758-13988255497249968-15472636863527791-11022158915176448-17805921820312500-18866747357607464-13779778436117395-16536566096009856-11024932064389828-17386344490454000-15478865887771143-13783245221457920-17601029350898371-11451848204813616-18875291936685875-14846482073601920-13786712588210445-19090254643386480-19091214966070710-15061604975424000-18668843803431448-18457626256444056-17397718216297974-14640279747976896-13792261584473125-14005154626196976-15491328951210679-13794342841876480-14219499306742083-17191602577125000-13796424308644315-14646171603730752-13797812069475005-14010790692245424-15497562990855375-13799893885207040-14225221343248331-17198520494983272-13801975910331635-14652065040024000-13803364043415765-14016428270164848-15503798702749031-13805446417551360-14230944914609875-17205440268443976-13807529001107595-14657960057068608-13808917506495085-14022067360158000-15510036087115903-13811000439109120-14236670021032539-17212361897755944-13813083581171875-14663856655076544-13814472458912645-14027707962427632-15516275144180247-13816555950080000-14242396662722147-17219285383168008-13818639650724155-14669754834259776-13820028900868125-14033350077176496-15522515874166319-13822112950663680-14248124839884523-17226210724929000-13824197209964115-14675654594830272-13825586832561205-14038993704607344-15528758277298375-13827671441059840-14253854552725491-17233137923287752-13829756259091435-14681555937000000-13831146254191565-14044638844922928-15535002353800671-13833231421468160-14259585801450875-17240066978493096-13835316798305795-14687458860980928-13836707165958885-14050285498326000-15541248103897463-13838792892088320-14265318586266499-17246997890793864-13840878827806875-14693363366985024-13842269568062845-17463432735327024-14269619183061253-18530137834176000-15336056855689992-17253930660438888-18106886147115695-16403532580467648-17895661703062500-14487691931423968-10866314738552733-15980677274726400-15129134362901719-17260865287677000-18114163468765735-17049480725693440-13853398844079405-14067234539087664-15559995397997375-13855486247216640-14282526159313051-17267801772757032-13857573860027235-14711086379256000-13858965718391365-14072887246868208-15566247844714711-13861053680680960-14288265090547875-17274740115927816-13863141852671995-14716997215472448-13864534083838685-14078541468750000-15572501966147823-13866622605355520-14294005558902059-17281680317438184-13868711336601875-14722909634771904-13870103940621045-14084197204935792-15578757762520967-13872193021440000-14299747564581427-17288622377536968-13874282312016555-14728823637366336-13875675288938125-14089854455628336-15585015234058399-13877764929134080-14305491107791803-17295566296473000-13879854779115715-14734739223467712-13881248128989605-14095513221030384-15591274380984375-13883338328637440-14311236188739011-17302512074495112-13885428738099035-14740656393288000-13886822460975165-14101173501344688-15597535203523151-13888913220149760-14316982807628875-17309459711852136-13891004189166195-14746575147039168-13892398285094485-14106835296774000-15603797701898983-13894489603870720-14322730964667219-17316409208792904-13896581132516875-14752495484933184-13897975601547245-14112498607521072-15610061876336127-18177011320000000-17322491544251481-11335038394753224-18179747127843295-16255648158635264-13903554410533125-14118163433788656-15616327727058839-13905646848737280-14334231894012643-17330313782421000-13907739496867515-14764340913997632-13909134712251805-14123829775779504-15622595254291375-13911227710282240-14339984666731371-17337268859605992-13913320918266835-14770266005592000-13914716506902965-14129497633696368-15628864458257991-13916810064834560-14345738978421875-17344225797370056-13918903832748395-14776192682177088-13920299794686285-14135167007742000-15635135339182943-13922393912593920-14351494829289979-17351184595962024-13924488240511875-14782120943964864-13925884575801445-14140837898119152-15641407897290487-13927979253760000-14357252219541507-17358145255630728-13930074141756955-14788050791167296-13931470850448125-14146510305030576-15647682132804879-13933566088532480-14363011149382283-17365107776625000-13935661536683315-14793982223996352-13937058618826005-14152184228679024-15653958045950375-13939154417111040-14368771619018131-17372072159193672-13941250425490635-14799915242664000-13942647881134765-14157859669267248-15660235636951231-13944744239695360-14374533628654875-17379038403585576-13946840808378595-14805849847382208-13948238637574085-14163536626998000-15666514906031703-13950335556485120-14380297178498339-17386006510049544-13952432685546875-14811786038362944-13953830888343645-17604176338940464-14384620851765413-19108886534208000-14386062268754347-17607704583511376-14816981506868703-16535720779971008-18254632213225625-16322606472682656-19115588830962167-15679863925600256-15251042565278199-17399948310189000-18260119669222535-16542348766042176-16543177388811689-10957718285738184-19123250517471375-17834935897676288-15257155105436383-10745013582939600-15903416601077726-16978822121000000-14185549171840266-17840296205641064-15691648767634871-13972715769692160-14403366784055875-17413897561602696-13974815141016795-14835546669150528-13976214838717885-14191944179886000-15697936430477263-13978314560504320-14409138038020299-17420874982159464-13980414492581875-14841490794623424-13981814564133845-14197630244729712-15704225772744807-13983914846720000-14414910833426387-17427854266281288-13986015339625355-14847436507630656-13987415785078125-14203317828135216-15710516794661759-13989516628538880-14420685170479963-17434835414217000-13991617682346915-14853383808384192-13993018501750405-14209006930305264-15716809496452375-13995119906160640-14426461049386851-17441818426215432-13997221520946235-14859332697096000-13998622714350365-14214697551442608-15723103878340911-14000724679784960-14432238470352875-17448803302525416-14002826855622995-14865283173978048-14004228423077685-14220389691750000-15729399940551623-14006330949611520-14438017433583859-17455790043395784-14008433686576875-14871235239242304-14009835628132045-14226083351430192-15735697683308767-14011938715840000-14443797939285627-17462778649075368-14014042014007555-14877188893100736-14015444329713125-14231778530685936-15741997106836599-14017547978670080-14449579987664003-17469769119813000-14019651838114715-14883144135765312-14021054528020605-14237475229719984-15748298211359375-14023158738301440-14455363578924811-17476761455857512-14025263159098035-14889100967448000-14026666223254165-14243173448735088-15754600997101351-14028770994933760-14461148713273875-17483755657457736-14030875977157195-14895059388360768-14032279415613485-17703145475918000-14465488576811157-11227507799013376-14466935390917019-17490751724862504-14900274310491375-16844630624635008-14901764511778137-14254574447519472-15767211613139927-14040000000000000-14472723612060067-17497749658320648-14042106105301755-14906980998724416-14043510292508125-14260277227694256-15773519443885039-14045616748833280-14478513376908843-17504749458081000-14047723415786515-14912944188599232-14049127977442805-14265981528661104-15779828956746375-14051234995466240-14484304685669171-17511751124392392-14053342224145835-14918908968552000-14054747160301965-14271687350622768-15786140151948191-14056854740098560-14490097538546875-17518754657503656-14058962530579395-14924875338794688-14060367841285285-14277394693782000-15792453029714743-14062475982929920-14495891935747779-17525760057663624-14064584335286875-14930843299539264-14065990020592445-14283103558341552-15798767590270287-14068098724160000-14501687877477707-17532767325121128-14070207638467955-14936812850997696-14071613698423125-14288813944504176-15805083833839079-14073722963988480-14507485363942483-17539776460125000-14075832440322315-14942783993381952-14077238874977005-14294525852472624-15811401760645375-14079348702615040-14513284395347931-17546787462924072-14081458741049635-14948756726904000-14082865550453765-14300239282449648-15817721370913431-14084975940239360-14519084971899875-17553800333767176-14087086540849595-14954731051775808-14088493725053085-14305954234638000-15824042664867503-14090604677061120-14524887093804139-17560815072903144-14092715839921875-14960706968209344-14094123398974645-14311670709240432-15830365642731847-14096234913280000-14530690761266547-17567831680580808-14098346638466155-14966684476416576-16268947583559375-17571340685200536-16487513193966228-14101866649095680-14536495974492923-17791823615778000-19311601928687819-16925619695297664-17360476609948560-16493276139604384-10851381267868750-15843807562825728-19100337918875224-18450111021201320-16931535281723322-17149462279000000-16064855153562274-16499864007371808-11507058467774531-14547384916325888-19107966737871000-17806039541023312-15201036343153010-16721974560037824-14116657091876885-14334551835846000-11077251976529181-14553194574770176-15422811690265687-10861677038077200-11513952247106375-16945907443989888-18467615577837105-18033983360931656-15862005798556607-14124408592320000-14559732289154587-17602942755803688-14126523130256355-14996595901477056-14127932939453125-14346001538904816-15868338884591959-14130047829114880-14565545234288163-17609970579957000-14132162929825915-15002582964777792-14133573114221405-14351728676082864-15874673656107375-14135688566704640-14571359726420651-17617000274393832-14137804230265235-15008571621336000-14139214789909365-14357457337297008-15881010113327111-14141330805288960-14577175765757875-17624031839363016-14143447031773995-15014561871363648-14144857966716685-14363187522750000-15887348256475423-14146974545067520-14582993352505659-17631065275113384-14149091334551875-15020553715072704-14150502644843045-14368919232644592-15893688085776567-14152619786240000-14588812486869827-17638100581893768-14154737138798555-15026547152675136-14156148824488125-14374652467183536-15900029601454799-14158266529006080-14594633169056203-17645137759953000-14160384444713715-15032542184382912-14161796505851605-14380387226569584-15906372803734375-14163914773565440-14600455399270611-17652176809539912-14166033252497035-15038538810408000-14167445689133165-14386123511005488-15912717692839551-14169564520117760-14606279177718875-17659217730903336-14171683562348195-15044537030962368-14173096374532485-14391861320694000-15919064268994583-14175215768862720-14612104504606819-17666260524292104-14177335374466875-15050536846257984-14178748562249245-14397600655837872-15925412532423727-14180868520000000-14617931380140267-17673305189955048-14182988689052755-15056538256506816-14184402252483125-17895060672188912-14622302553212781-11349218218983424-18334266023583636-11786901152094000-14188643506305515-15062541261920832-16154834630186178-16155639527945456-16374774782878125-16375590611827200-15502998122920223-18997577927180184-15286169043842130-17034008366544000-15506087754344131-14851640780151264-16162884810907958-17692687676473344-18130447282921875-18131350433523608-16166105631864142-17477741517788160-16167716202785186-11143170242517000-11362229699932332-16388647560537600-15515359111522927-19012724993682648-15298356743451250-17047589397091968-15518450384975763-14863481439286496-16394362157393925-16395178636800000-15521542069003991-11587080251701864-15304453021823490-17054382618529152-18367172813314500-14869404128151648-15963537558313279-14214816588244480-14652925166422683-17715612515625000-14216940139561315-15092580223887552-14218355957928005-14437818731626224-15969897638940375-14220479861719040-14658762888237731-17722670294174472-14222603977008635-15098592804744000-14224020171372765-14443570277712048-15976259408635631-14226144639183360-14664602160344875-17729729946988776-14228269318520595-15104606982249408-14229685888932085-14449323351078000-15982622867623303-14231810920837120-14670442982949939-17736791474316744-14233936164296875-15110622756615744-14235353110805645-14455077951926832-15988988016127647-14237478706880000-14676285356258747-17743854876407208-14239604514537155-15116640128054976-14241021837193125-14460834080461296-15995354854372919-14243147997511680-14682129280477123-17750920153509000-14245274369441115-15122659096779072-14246692068294205-14466591736884144-16001723382583375-14248818792931840-14687974755810891-17757987305870952-14250945729208435-15128679663000000-14252363804308565-14472350921398128-16008093600983271-14254491093340160-14693821782465875-17765056333741896-14256618594038795-15134701826929728-14258037045435885-14478111634206000-16014465509796863-14260164898936320-14699670360647899-17772127237370664-14262292964131875-15140725588780224-14263711791875845-14483873875510512-16020839109248407-14265840209920000-14705520490562787-17779200017006088-14267968839687355-15146750948763456-14269388043828125-18002277074730032-14709909106447461-19541000236272128-18224535676276987-18225441948771000-18006753694064662-17129227199320704-16251613374006738-18448694656535136-19767441428583750-16034388622553088-14717225406414451-17793351205292232-19551691301701491-15817885005888000-11644299822286513-14501169772431408-16039970053673311-15161821341943296-18239039641780875-18239946395044088-18021083862957686-17142858787406976-16264546334952626-18463375801500000-19783171748119590-15167852297060352-14728936531667459-17807509900590984-14290687400526875-15170868374263104-14292108110754045-14512708016578992-16052732473924367-14294239352640000-14734794423334027-17814592063992168-14296370806389555-15176901728089536-14297791893263125-14518479433121136-16059116221912999-14299923700142080-14740653867968403-17821676104893000-14302055718912715-15182936681320512-14303477182482605-14524252379579184-16065501662109375-14305609554429440-14746514865776411-17828762023542312-14307742138296035-15188973234168000-14309163978612165-14530026856155888-16071888794737751-14311296915701760-14752377416963875-17835849820188936-14313430064739195-15195011386843968-14314852281851485-14535802863054000-16078277620022383-14316985784158720-14758241521736619-17842939495081704-14319119498441875-15201051139560384-14320542092400245-14541580400476272-16084668138187527-14322676160000000-14764107180300467-17850031048469448-14324810439603755-15207092492529216-14326233410458125-14547359468625456-16091060349457439-14328368043425280-14769974392861243-17857124480601000-14330502888424515-15213135445962432-14331926236224805-14553140067704304-16097454254056375-14334061434634240-14775843159624771-17864219791725192-14336196845103835-15219180000072000-14337620569899965-14558922197915568-16103849852208591-14339756333826560-14781713480796875-17871316982090856-14341892309841395-15225226155069888-14343316411683285-14564705859462000-16110247144138343-14345452741201920-14787585356583379-15450483007855280-16996374996591375-16776475612301056-14349013761774445-16336611180127728-17662077950761520-14351150656960000-18326225064728043-19872796668379920-11703450023190271-17445630988662336-17667338609690000-18551626262109024-11484910056600396-16123847014383616-14799333772822883-17892619831125000-14358987754400315-15243374227513152-14360412987679005-14582066034139824-16129449184835375-14362551014423040-14805210313687531-17899724540944872-14364689253367635-15249426788184000-14366114863891765-14587855823054448-16135853254117831-14368253456527360-14811088409989875-17906831131250376-14370392261391595-15255480950803008-14371818249211085-14593647144318000-16142259018299103-14373957407813120-14816968061935739-17913939602290344-14376096778671875-15261536715582144-14377523143836645-14599439998133232-16148666477603447-14379662868480000-14822849269730947-17921049954313608-14381802805408155-15267594082733376-14383229547968125-14605234384702896-16155075632255119-14385369838727680-14828732033581323-17928162187569000-14387510341800115-15273653052468672-14388937461805205-14611030304229744-16161486482478375-14391078318755840-14834616353692691-17935276302305352-14393219388047435-15279713625000000-14394646885547565-14616827756916528-16167899028497471-14396788308764160-14840502230270875-17942392298771496-14398929944349795-15285775800539328-14400357819394885-14622626742966000-16174313270536663-14402499808952320-14846389663521699-17949510177216264-14404642010906875-15291839579298624-14406070263546845-14628427262580912-16180729208820207-14408212819520000-14852278653650987-17956629937888488-16183937814123691-14632778658816384-11307707617359375-18181921271349232-16187146843572359-11531141872533504-18628152430934676-19737949268053000-14416070675583915-17300142201323904-17744614995154960-14640032903318064-17746373890430000-16638050045299200-15751467950464863-19302051040755864-15531155525957330-17307002346192000-15754590505349891-15089651298325984-16199987203379511-16200789951250432-15979653099261000-19975556128620240-11763965928228119-17313864304354176-17980673029581069-15095633913500000-11988303235064154-16651246118745600-15763960645998767-17985127807828584-11546580003601500-17320728076050048-18876087498438905-15101618109755616-16212834351752167-16213637523968000-19324059491447847-18436510242219224-18215285895630854-17327593661519232-16439813423797250-16884969050513696-19774166877079407-17108834478923264-15332052622800621-17999388042633000-18889182251699935-15556567618847360-14446099677913605-18225212973536368-17781576208750000-14892807622459392-15115836913762244-18895731898746920-18229726473732198-16007381792064000-14896495725897047-14674886652186288-16232117806795951-18901347086819840-15121826447710500-18013655813314536-14456118604330195-15346485768005568-14457550257570485-14680700983014000-16238549021370183-14459697914654720-14905349658306419-18020792525231304-14461845784416875-15352565590622784-14463277815751245-14686516849434672-16244981934431327-14465426040000000-14911254228540667-18027931121863848-14467574476954755-15358647018791616-14469006886433125-14692334251651056-16251416546203639-14471155677921280-14917160357917443-18035071603461000-14473304682143515-15364730052724032-14474737469815805-14698153189865904-16257852856911375-14476886828618240-14923068046642571-18042213970271592-14479036400182835-15370814692632000-14480469566098965-14703973664281968-16264290866778791-14482619492290560-14928977294921875-18049358222544456-14484769631272395-15376900938727488-14486203175482285-14709795675102000-16270730576030143-14488353669137920-14934888102961179-18056504360528424-14490504375611875-15382988791222464-14491938298165445-14715619222528752-16277171984889687-14494089359360000-14940800470966307-18063652384472328-14496240633400955-15389078250328896-14497674934348125-14721444306764976-16283615093581679-14499826563156480-14946714399143083-18070802294625000-14501978404839315-15395169316258752-14503413084230005-14727270928013424-16290059902330375-14505565280727040-14952629887697331-18077954091235272-14507717690126635-15401261989224000-14509152748010765-14733099086476848-16296506411360031-14511305512271360-14958546936834875-15629105484180720-16299730303550299-15407356269436608-12058527261508686-18312002426566000-17196267202861747-18090474275340288-19431470187585879-19655792275858112-18093157923796875-16083602250895872-14967425437085111-14968165470645384-18320153035000798-14522790518080000-18545403202503003-18546320081369144-14748405317711142-17430795259293312-18996036463125625-15197580447402208-16315856142377319-17210726423711744-15870415357256599-18777194226756000-11848101055526663-17437689897723264-14532126546116205-16545084926418416-12074037130928250-19900785550984704-15876692280249983-19455500000590104-19232824115240514-17668234897000000-15879831362299171-11407203184088808-11631448662544204-15882185945350144-19685935711431000-18568334241192728-17450622244632954-17227747645948224-15214866650696372-17005691289236000-11859818119887843-15888465971353088-15665458822096790-18128069509221864-19024222812199375-15667781159918720-14549372800417845-18355500286231024-17908689973996720-15447008282112000-15223890740604548-19030803636399080-18360035270551494-16121803045206528-15002974569734375-14779779718253616-16348139720622559-12093741879211008-15229908782433252-18142405192377000-14559439413862915-15456168397478592-14560877880434405-14785621720775664-16354601542272375-14563035757936640-15011870639282051-18149575867249032-14565193848622235-15462277152456000-14566632694186365-14791465262540208-16361065066445711-14568791140200960-15017803305572875-18156748431315816-14570949799426995-15468387516800448-14572389024033685-14797310343750000-16367530293366823-14574548038635520-15023737534711059-18163922884826184-14576707266476875-15474499490723904-14578146870176045-14803156964607792-16373997223259967-14580306453440000-15029673326902427-18171099228028968-14582466249971555-15480613074438336-14583906232813125-14809005125316336-16380465856349399-14586066384814080-15035610682352803-18178277461173000-14588226750110715-15486728268155712-14589667112144605-14814854826078384-16386936192859375-14591827832957440-15041549601268011-18185457584507112-14593988767094035-15492845072088000-14595429508370165-14820706067096688-16393408233014151-14597590798069760-15047490083853875-18192639598280136-14599752301121195-15498963486447168-14601193421689485-14826558848574000-16399881977037983-14603355280350720-15053432130316219-18199823502740904-14605517352391875-15505083511445184-14606958852302245-14832413170713072-16406357425155127-14609121280000000-15059375740860867-18207009298138248-14611283921105755-15511205147294016-14612725800408125-14838269033716656-16412834577589839-14614888797217280-15065320915693643-15740664060870000-15516562900229439-15742217211512960-15068294089782399-20241990596982960-11920871397698875-15520390621876224-15071267655020371-18221386562737992-18222285392993979-15748430835760000-14849252930665626-15299984940192864-11925576463073651-15076472335467008-15977348255109375-18678666378918008-184