@php
    if (empty($authUser) and auth()->check()) {
        $authUser = auth()->user();
    }

    $navBtnUrl = null;
    $navBtnText = null;

    if(request()->is('forums*')) {
        $navBtnUrl = '/forums/create-topic';
        $navBtnText = trans('update.create_new_topic');
    } else {
        $navbarButton = getNavbarButton(!empty($authUser) ? $authUser->role_id : null, empty($authUser));

        if (!empty($navbarButton)) {
            $navBtnUrl = $navbarButton->url;
            $navBtnText = $navbarButton->title;
        }
    }
@endphp

@php
    $userLanguages = !empty($generalSettings['site_language']) ? [$generalSettings['site_language'] => getLanguages($generalSettings['site_language'])] : [];

    if (!empty($generalSettings['user_languages']) and is_array($generalSettings['user_languages'])) {
        $userLanguages = getLanguages($generalSettings['user_languages']);
    }

    $localLanguage = [];

    foreach($userLanguages as $key => $userLanguage) {
        $localLanguage[localeToCountryCode($key)] = $userLanguage;
    }

@endphp

<style>
#navbarVacuum {
    /* height: 80px;
    min-height: 80px; */
    display: block;
    background: transparent;
}

.navbar {
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
    background-color: transparent !important;
    background: transparent !important;
    box-shadow: none !important;
}

/* Ensure navbar is transparent on page load - more specific selectors */
.navbar:not(.scrolled),
.navbar.navbar-light:not(.scrolled),
#navbar:not(.scrolled),
#navbar.navbar-light:not(.scrolled),
nav#navbar:not(.scrolled),
nav#navbar.navbar-light:not(.scrolled) {
    background-color: transparent !important;
    background: transparent !important;
    box-shadow: none !important;
}

.navbar.scrolled {
    background-color: #ffffff !important;
    box-shadow: 0 3px 10px 0 rgba(0, 0, 0, 0.1) !important;
}

.navbar.scrolled .nav-link {
    color: rgb(13, 54, 71) !important;
}

.navbar.scrolled .navbar-brand img {
    display: none;
}

.navbar.scrolled .navbar-brand .logo-scrolled {
    display: block !important;
}

.navbar .navbar-brand .logo-scrolled {
    display: none;
}

/* Logo padding fix */
.navbar-brand {
    padding: 10px 0 !important;
    margin-right: 0 !important;
}

/* Desktop layout adjustments */
@media (min-width: 992px) {
    /* Left side: Hamburger menu (hidden on desktop) */
    .navbar-toggler {
        display: none;
    }
    
    /* Logo stays in original position on desktop */
    .navbar-brand {
        /* Keep original positioning */
    }
    
    /* Right side: Language and Start buttons */
    .nav-icons-or-start-live {
        margin-left: auto;
    }
}

.navbar-brand img {
    height: auto;
    width: auto;
    max-width: none;
    object-fit: contain;
    padding-top:18px;
}

/* Language button styling */
.language-select {
    margin-left: 0;
}

.language-select .btn {
    background-color: rgba(255, 255, 255, 0.9) !important;
    color: #333 !important;
    border: 1px solid rgba(255, 255, 255, 0.3) !important;
    border-radius: 8px !important;
    padding: 8px 15px !important;
    font-size: 14px !important;
    font-weight: 500 !important;
    transition: all 0.3s ease !important;
    backdrop-filter: blur(10px) !important;
}

.language-select .btn:hover {
    background-color: rgba(255, 255, 255, 1) !important;
    border-color: rgba(255, 255, 255, 0.5) !important;
    transform: translateY(-1px) !important;
}

.navbar.scrolled .language-select .btn {
    background-color: #ffffff !important;
    color: #333 !important;
    border: 1px solid #e0e0e0 !important;
}

/* Start learning button styling - Changed to secondary/outline */
.nav-start-a-live-btn {
    background-color: transparent !important;
    color: #ffffff !important;
    border: 2px solid rgba(255, 255, 255, 0.6) !important;
    border-radius: 8px !important;
    padding: 8px 20px !important;
    font-size: 14px !important;
    font-weight: 600 !important;
    transition: all 0.3s ease !important;
    backdrop-filter: blur(10px) !important;
    margin-left: 20px !important;
    text-decoration: none !important;
}

.nav-start-a-live-btn:hover {
    background-color: rgba(255, 255, 255, 0.15) !important;
    border-color: rgba(255, 255, 255, 0.8) !important;
    transform: translateY(-1px) !important;
    color: #ffffff !important;
    text-decoration: none !important;
    box-shadow: 0 4px 12px rgba(255, 255, 255, 0.2) !important;
}

.navbar.scrolled .nav-start-a-live-btn {
    background-color: transparent !important;
    color: #254c74 !important;
    border: 2px solid #254c74 !important;
}

.navbar.scrolled .nav-start-a-live-btn:hover {
    background-color: #254c74 !important;
    color: #ffffff !important;
    border-color: #254c74 !important;
}

/* Navigation links styling */
.navbar .nav-link {
    color: #ffffff !important;
    font-weight: 500 !important;
    transition: all 0.3s ease !important;
}

.navbar .nav-link:hover {
    color: rgba(255, 255, 255, 0.8) !important;
}

.navbar.scrolled .nav-link {
    color: rgb(13, 54, 71) !important;
}

.navbar.scrolled .nav-link:hover {
    color: #254c74 !important;
}

/* Mobile responsive adjustments */
@media (max-width: 991px) {
    /* Ensure proper layout for mobile navbar */
    .navbar .d-flex {
        position: relative;
    }
    
    /* Left side: Hamburger menu */
    .navbar-toggler {
        order: 1;
        margin-right: 0;
    }
    
    /* Center: Logo on mobile only */
    .navbar-brand {
        order: 2;
        padding: 8px 0 !important;
        position: absolute;
        left: 50%;
        transform: translateX(-50%);
        margin: 0 !important;
    }
    
    .navbar-brand img {
        height: auto;
        width: auto;
        max-width: none;
        padding-top:18px;
    }
    
    /* Right side: Language and Start buttons */
    .nav-icons-or-start-live {
        order: 3;
        margin-left: auto;
    }
    
    .language-select {
        margin-left: 10px;
    }
    
    .nav-start-a-live-btn {
        margin-right: 40px;
        padding: 6px 15px !important;
        font-size: 13px !important;
        border-width: 1.5px !important;
    }
    
    /* Mobile menu improvements */
    .navbar-toggle-content {
        background-color: rgba(255, 255, 255, 0.95) !important;
        backdrop-filter: blur(10px) !important;
        margin-top: 10px !important;
        padding: 20px !important;
        box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1) !important;
    }
    
    .navbar-toggle-content .nav-link {
        color: #333 !important;
        font-weight: 600 !important;
        padding: 12px 0 !important;
        border-bottom: 1px solid rgba(0, 0, 0, 0.1) !important;
    }
    
    .navbar-toggle-content .nav-link:hover {
        color:#254c74 !important;
        background-color: rgba(37, 76, 116, 0.05) !important;
    }
    
    .navbar-toggle-content .nav-link:last-child {
        border-bottom: none !important;
    }
    
    /* Mobile navbar toggler */
    .navbar-toggler {
        border: none !important;
        padding: 8px !important;
        background-color: rgba(255, 255, 255, 0.9) !important;
        backdrop-filter: blur(10px) !important;
    }
    
    .navbar-toggler:focus {
        box-shadow: none !important;
        outline: none !important;
    }
    
    .navbar-toggler-icon {
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba(0, 0, 0, 0.7)' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e") !important;
    }
    
    .navbar.scrolled .navbar-toggler {
        background-color: #ffffff !important;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1) !important;
    }
    
    .navbar.scrolled .navbar-toggler-icon {
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba(37, 76, 116, 0.8)' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e") !important;
    }
}

/* Extra small devices */
@media (max-width: 575px) {
    .navbar-brand img {
        max-width: 120px !important;
    }
    
    .nav-start-a-live-btn {
        padding: 5px 12px !important;
        font-size: 12px !important;
        margin-right: 40px !important;
        display:none  !important;
    }
    
    .language-select .btn {
        padding: 6px 10px !important;
        font-size: 12px !important;
    }
    
    .navbar-toggle-content {
        margin-top: 5px !important;
        padding: 15px !important;
    }
}
</style>


<script>


// Force transparency on page load
document.addEventListener('DOMContentLoaded', function() {
    var navbar = document.getElementById("navbar");
    if (navbar) {
        navbar.style.backgroundColor = "transparent";
        navbar.style.background = "transparent";
        navbar.style.boxShadow = "none";
    }
});

// Add scroll behavior
window.addEventListener('scroll', function() {
    var navbar = document.getElementById("navbar");
    if (navbar) {
        if (window.pageYOffset > 50) {
            navbar.classList.add("scrolled");
        } else {
            navbar.classList.remove("scrolled");
            navbar.style.backgroundColor = "transparent";
            navbar.style.background = "transparent";
            navbar.style.boxShadow = "none";
        }
    }
});
</script>

<nav id="navbar" class="navbar navbar-expand-lg navbar-light fixed-top">
    <div class="{{ (!empty($isPanel) and $isPanel) ? 'container-fluid' : 'container'}}" style="padding-left: 20px; padding-right: 20px;">
        <div class="d-flex align-items-center justify-content-between w-100">

            <!-- Left side: Hamburger menu -->
            <button class="navbar-toggler navbar-order" type="button" id="navbarToggle" data-bs-toggle="collapse" data-bs-target="#navbarContent" aria-controls="navbarContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <!-- Center: Logo -->
            <a class="navbar-brand navbar-order d-flex align-items-center justify-content-center {{ (empty($navBtnUrl) and empty($navBtnText)) ? 'ml-auto' : '' }}" href="/">
                @if(!empty($generalSettings['logo']))
                    <img src="{{ $generalSettings['logo'] }}" class="img-cover" alt="site logo">
                @endif
                <img src="/store/1/NEFT-LOGO2 copy.png" class="img-cover logo-scrolled" alt="site logo scrolled">
            </a>

            <div class="collapse navbar-collapse mx-lg-30 navbar-toggle-content" id="navbarContent">
                <div class="navbar-toggle-header text-right d-lg-none">
                    <button class="btn-transparent" id="navbarClose">
                        <i data-feather="x" width="32" height="32"></i>
                    </button>
                </div>

                <ul class="navbar-nav mr-auto d-flex align-items-center">

                    @if(!empty($authUser) and $authUser->isOrganization() and !empty($authUser->organization) and !empty($authUser->organization->logo))
                        <li class="mr-lg-25">
                            <a href="{{ $authUser->getProfileUrl() }}" class="d-flex align-items-center">
                                <img src="{{ $authUser->organization->logo }}" class="rounded-circle mr-10" alt="{{ $authUser->organization->full_name }} logo" width="32" height="32">
                                {{ $authUser->organization->full_name }}
                            </a>
                        </li>
                    @endif

                    @if(!empty($navbarPages) and count($navbarPages))
                        <!-- Debug: Found {{ count($navbarPages) }} navbar pages -->
                        @foreach($navbarPages as $navbarPage)
                            <li class="nav-item">
                                <a class="nav-link" href="{{ $navbarPage['link'] }}">
                                    {{ trans('navbar.' . $navbarPage['title']) }}
                                </a>
                            </li>
                        @endforeach
                    @else
                        <!-- Debug: No navbar pages found -->
                        <li class="nav-item">
                            <a class="nav-link" href="#">Debug: No navbar pages</a>
                        </li>
                    @endif
                </ul>

                <!-- Mobile Only: Start Learning and Language inside menu -->
                <ul class="navbar-nav d-lg-none mobile-menu-extra-items">
                    @if(!empty($navBtnUrl))
                        <li class="nav-item">
                            <a class="nav-link" href="{{ $navBtnUrl }}">
                                {{ trans('navbar.start_learning') }}
                            </a>
                        </li>
                    @endif

                    @if(!empty($localLanguage) and count($localLanguage) > 1)
                        @php
                            // Get current locale and find the other language
                            $currentLocale = app()->getLocale();
                            
                            // Define available languages explicitly
                            $availableLanguages = [
                                'en' => ['country' => 'us', 'name' => 'English'],
                                'ar' => ['country' => 'sa', 'name' => 'العربية']
                            ];
                            
                            // Find the other language
                            $otherLocale = null;
                            $otherCountryCode = null;
                            $otherLanguageName = null;
                            
                            foreach($availableLanguages as $locale => $info) {
                                if($locale != $currentLocale) {
                                    $otherLocale = $locale;
                                    $otherCountryCode = $info['country'];
                                    $otherLanguageName = $info['name'];
                                    break;
                                }
                            }
                        @endphp
                        
                        @if($otherLocale)
                            <li class="nav-item">
                                <form action="/locale" method="post" id="languageToggleFormMobile" class="m-0">
                                    {{ csrf_field() }}
                                    <input type="hidden" name="locale" value="{{ $otherCountryCode }}">
                                    
                                    @if(!empty($previousUrl))
                                        <input type="hidden" name="previous_url" value="{{ $previousUrl }}">
                                    @endif
                                    
                                    <button type="submit" class="nav-link mobile-language-toggle js-language-toggle" style="background: none; border: none; padding: 8px 0; width: 100%; text-align: left; cursor: pointer;">
                                        <i class="flagstrap-icon flagstrap-{{ strtolower($otherCountryCode) }}" style="font-size: 20px;"></i>
                                    </button>
                                </form>
                            </li>
                        @endif
                    @endif
                </ul>
            </div>

            <!-- Right side: Language and Start buttons (Desktop Only) -->
            <div class="nav-icons-or-start-live navbar-order d-none d-lg-flex align-items-center justify-content-end">

                @if(!empty($navBtnUrl))
                    <a href="{{ $navBtnUrl }}" class="btn btn-sm nav-start-a-live-btn">
                        {{ trans('navbar.start_learning') }}
                    </a>
                @endif

                @if(!empty($localLanguage) and count($localLanguage) > 1)
                    @php
                        // Get current locale and find the other language
                        $currentLocale = app()->getLocale();
                        
                        // Define available languages explicitly
                        $availableLanguages = [
                            'en' => ['country' => 'us', 'name' => 'English'],
                            'ar' => ['country' => 'sa', 'name' => 'العربية']
                        ];
                        
                        // Find the other language
                        $otherLocale = null;
                        $otherCountryCode = null;
                        $otherLanguageName = null;
                        
                        foreach($availableLanguages as $locale => $info) {
                            if($locale != $currentLocale) {
                                $otherLocale = $locale;
                                $otherCountryCode = $info['country'];
                                $otherLanguageName = $info['name'];
                                break;
                            }
                        }
                    @endphp
                    
                    @if($otherLocale)
                        <form action="/locale" method="post" class="mr-15 mx-md-20" id="languageToggleForm">
                            {{ csrf_field() }}
                            <input type="hidden" name="locale" value="{{ $otherCountryCode }}">
                            
                            @if(!empty($previousUrl))
                                <input type="hidden" name="previous_url" value="{{ $previousUrl }}">
                            @endif
                            
                            <div class="language-select">
                                <button type="submit" class="btn btn-sm btn-default js-language-toggle" style="display: inline-flex; align-items: center;">
                                    <i class="flagstrap-icon flagstrap-{{ strtolower($otherCountryCode) }}" style="margin-right: 5px;"></i>
                                    <span>{{ $otherLanguageName }}</span>
                                </button>
                            </div>
                        </form>
                    @endif
                @endif

                @if(!empty($isPanel))
                    @if($authUser->checkAccessToAIContentFeature())
                        <div class="js-show-ai-content-drawer show-ai-content-drawer-btn d-flex-center mr-40">
                            <div class="d-flex-center size-32 rounded-circle bg-white">
                                <img src="/assets/default/img/ai/ai-chip.svg" alt="ai" class="" width="16px" height="16px">
                            </div>
                            <span class="ml-5 font-weight-500 text-secondary font-14 d-none d-lg-block">{{ trans('navbar.ai_content') }}</span>
                        </div>
                    @endif
                @endif

                <div class="d-none nav-notify-cart-dropdown top-navbar">
                    @include('web.default.includes.shopping-cart-dropdwon')

                    <div class="border-left mx-15"></div>

                    @include('web.default.includes.notification-dropdown')
                </div>

            </div>
        </div>
    </div>

</nav>

@push('scripts_bottom')
    <script src="/assets/default/js/parts/navbar.min.js"></script>
    <script>
        // Language toggle - just log for debugging
        $(document).ready(function() {
            $('#languageToggleForm').on('submit', function(e) {
                console.log('Language form submitting...');
                console.log('Locale value:', $(this).find('input[name="locale"]').val());
                // Let form submit naturally - don't prevent default
                return true;
            });
            
            $('.js-language-toggle').on('click', function(e) {
                console.log('Language button clicked');
                // Let the button submit the form naturally - don't prevent default
            });
        });
    </script>
@endpush
