@php
    $statisticsSettings = getStatisticsSettings();
@endphp

@if(!empty($statisticsSettings['enable_statistics']))
    @if(!empty($statisticsSettings['display_default_statistics']) and !empty($homeDefaultStatistics))
        <div class="stats-container {{ ($heroSection == "2") ? 'page-has-hero-section-2' : '' }}">
            <div class="container">
                <div class="row">
                    <div class="col-sm-6 col-lg-3 mt-25 mt-lg-0">
                        <div class="stats-item d-flex flex-column align-items-center text-center py-30 px-5 w-100">
                            <div class="stat-icon-box teacher">
                                <img src="/assets/default/img/stats/teacher.svg" alt="" class="img-fluid"/>
                            </div>
                            <strong class="stat-number mt-10">{{ $homeDefaultStatistics['skillfulTeachersCount'] }}</strong>
                            <h4 class="stat-title">{{ trans('home.skillful_teachers') }}</h4>
                            <!-- <p class="stat-desc mt-10">{{ trans('home.skillful_teachers_hint') }}</p> -->
                        </div>
                    </div>

                    <div class="col-sm-6 col-lg-3 mt-25 mt-lg-0">
                        <div class="stats-item d-flex flex-column align-items-center text-center py-30 px-5 w-100">
                            <div class="stat-icon-box student">
                                <img src="/assets/default/img/stats/student.svg" alt="" class="img-fluid"/>
                            </div>
                            <strong class="stat-number mt-10">{{ $homeDefaultStatistics['studentsCount'] }}</strong>
                            <h4 class="stat-title">{{ trans('home.happy_students') }}</h4>
                            <!-- <p class="stat-desc mt-10">{{ trans('home.happy_students_hint') }}</p> -->
                        </div>
                    </div>

                    <div class="col-sm-6 col-lg-3 mt-25 mt-lg-0">
                        <div class="stats-item d-flex flex-column align-items-center text-center py-30 px-5 w-100">
                            <div class="stat-icon-box video">
                                <img src="/assets/default/img/stats/video.svg" alt="" class="img-fluid"/>
                            </div>
                            <strong class="stat-number mt-10">{{ $homeDefaultStatistics['liveClassCount'] }}</strong>
                            <h4 class="stat-title">{{ trans('home.live_classes') }}</h4>
                            <!-- <p class="stat-desc mt-10">{{ trans('home.live_classes_hint') }}</p> -->
                        </div>
                    </div>

                    <div class="col-sm-6 col-lg-3 mt-25 mt-lg-0">
                        <div class="stats-item d-flex flex-column align-items-center text-center py-30 px-5 w-100">
                            <div class="stat-icon-box course">
                                <img src="/assets/default/img/stats/course.svg" alt="" class="img-fluid"/>
                            </div>
                            <strong class="stat-number mt-10">{{ $homeDefaultStatistics['offlineCourseCount'] }}</strong>
                            <h4 class="stat-title">{{ trans('home.offline_courses') }}</h4>
                            <!-- <p class="stat-desc mt-10">{{ trans('home.offline_courses_hint') }}</p> -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
    @elseif(!empty($homeCustomStatistics))

        @php
        
            $homeCustomStatistics = [
        [
            'icon' => '/store/1/student.svg',
            'title_key' => 'home.people_trained',
            'count' => 90,
            'unit' => 'K',
            'color' => '#042148'
        ],
        [
            'icon' => '/store/1/hourglass-it-is-white-icon-vector.png',
            'title_key' => 'home.training_hours',
            'count' => 1,
            'unit' => 'M',
            'color' => '#fdbe2c'
        ],
        [
            'icon' => '/store/1/teacher.svg',
            'title_key' => 'home.coaching_assessors',
            'count' => 30,
            'unit' => '+',
            'color' => '#042148'
        ],
        [
            'icon' => '/store/1/users.png',
            'title_key' => 'home.clients',
            'count' => 120,
            'unit' => '+',
            'color' => '#fdbe2c'
        ],
    ];

    @endphp
<div class="home-sections stats-container">
  <div class="container">
    <div class="row">
      @foreach($homeCustomStatistics as $home)
        <div class="col-sm-6 col-lg-3 mt-25 mt-lg-0">
          <div class="stats-item d-flex flex-column align-items-center text-center py-30 px-5 w-100">
            <div class="stat-icon-box" style="background-color: {{ $home['color'] }}">
              <img src="{{ $home['icon'] }}" alt="{{ __($home['title_key']) }}" class="img-fluid"/>
            </div>
            <strong class="stat-number mt-10">{{ $home['count'] }}{{ $home['unit'] }}</strong>
            <h4 class="stat-title">{{ __($home['title_key']) }}</h4>
          </div>
        </div>
      @endforeach
    </div>
  </div>
</div>

    @else
        <div class="my-40"></div>
    @endif
@else
    <div class="my-40"></div>
@endif
