function _toConsumableArray(arr) {
	return (
		_arrayWithoutHoles(arr) ||
		_iterableToArray(arr) ||
		_unsupportedIterableToArray(arr) ||
		_nonIterableSpread()
	);
}
function _nonIterableSpread() {
	throw new TypeError(
		"Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."
	);
}
function _unsupportedIterableToArray(o, minLen) {
	if (!o) return;
	if (typeof o === "string") return _arrayLikeToArray(o, minLen);
	var n = Object.prototype.toString.call(o).slice(8, -1);
	if (n === "Object" && o.constructor) n = o.constructor.name;
	if (n === "Map" || n === "Set") return Array.from(o);
	if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
		return _arrayLikeToArray(o, minLen);
}
function _iterableToArray(iter) {
	if (
		(typeof Symbol !== "undefined" && iter[Symbol.iterator] != null) ||
		iter["@@iterator"] != null
	)
		return Array.from(iter);
}
function _arrayWithoutHoles(arr) {
	if (Array.isArray(arr)) return _arrayLikeToArray(arr);
}
function _arrayLikeToArray(arr, len) {
	if (len == null || len > arr.length) len = arr.length;
	for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
	return arr2;
}
(function ($) {
	"use strict";

	var TJThemeBuilder = {
		instance: [],
		templateId: 0,
		init: function init() {
			this.renderPopup();
			this.reinitSelect2();
			//open popup onclick
			$("body.post-type-tj-addons-template #wpcontent").on(
				"click",
				".page-title-action, .row-title, .row-actions .edit > a",
				this.openPopup
			);
			$(document)
				.on(
					"click",
					".tj-theme-builder-body-overlay,.tj-theme-builder-edit-cross",
					this.closePopup
				)
				.on("click", ".tj-theme-builder-tmp-save", this.savePost)
				.on("click", ".tj-theme-builder-tmp-elementor", this.redirectEditPage)
				.on("tj_template_edit_popup_open", this.displayLocation)
				.on(
					"change",
					"#tj-theme-builder-type, #tj-theme-builder-hf-display-type",
					this.displayLocation
				);
			$("#tj-theme-builder-hf-s-display-type").on(
				"select2:select",
				function (e) {
					// Get the selected data
					var selectedItems = $(this).val(); // Get the selected values

					var uniqueItems = _toConsumableArray(new Set(selectedItems)); // Remove duplicates

					// Update the Select2 element with unique values
					$(this).val(uniqueItems).trigger("change");
				}
			);
		},
		reinitSelect2: function reinitSelect2() {
			$("#tj-theme-builder-hf-s-display-type").select2({
				ajax: {
					url: ajaxurl,
					dataType: "json",
					method: "post",
					delay: 250,
					data: function data(params) {
						return {
							q: params.term,
							// search term
							page: params.page || 1,
							action: "tj_get_posts_by_query",
							nonce: Tj_Theme_Builder.nonce,
						};
					},
					processResults: function processResults(data) {
						var uniqueData = [];
						var seen = new Set();
						data.forEach(function (item) {
							if (!seen.has(item.id)) {
								seen.add(item.id);
								uniqueData.push(item);
							}
						});
						return {
							results: uniqueData,
						};
					},
					cache: true,
				},
				minimumInputLength: 2,
				placeholder: "Search and select an option",
				allowClear: true,
			});
		},
		// Render Popup HTML
		renderPopup: function renderPopup(event) {
			var popupTmp = wp.template("tj-theme-builder-ctppopup"),
				content = null;
			content = popupTmp({
				templatetype: Tj_Theme_Builder.templatetype,
				hflocation: Tj_Theme_Builder.hflocation,
				archivelocation: Tj_Theme_Builder.archivelocation,
				singlelocation: Tj_Theme_Builder.singlelocation,
				editor: Tj_Theme_Builder.editor,
				heading: Tj_Theme_Builder.labels,
			});
			$("body").append(content);
		},
		// Edit PopUp
		openPopup: function openPopup(event) {
			event.preventDefault();
			var rowId = $(this).closest("tr").attr("id"),
				tmpId = null,
				elementorEditlink = null;
			if (rowId) {
				tmpId = rowId.replace("post-", "");
				elementorEditlink = "post.php?post=" + tmpId + "&action=elementor";
			}
			$(".tj-theme-builder-tmp-save").attr("data-tmpid", tmpId);
			$(".tj-theme-builder-tmp-elementor").attr({
				"data-link": elementorEditlink,
				"data-tmpid": tmpId,
			});
			if (tmpId) {
				//fetch existing template data
				$.ajax({
					url: Tj_Theme_Builder.ajaxurl,
					data: {
						action: "tj_get_template",
						nonce: Tj_Theme_Builder.nonce,
						tmpId: tmpId,
					},
					type: "POST",
					beforeSend: function beforeSend() {},
					success: function success(response) {
						//type
						document.querySelector(
							"#tj-theme-builder-type option[value='" +
								response.data.tmpType +
								"']"
						).selected = "true";
						$("#tj-theme-builder-title").attr("value", response.data.tmpTitle);
						$(".tj-theme-builder-tmp-elementor")
							.removeClass("disabled")
							.removeAttr("disabled", "disabled");
					},
					complete: function complete(response) {
						$("#tj-theme-builder-hf-s-display-type")
							.val(null)
							.trigger("change");
						// Fire custom event.
						$(document).trigger("tj_template_edit_popup_open");

						//display
						var temDisplay = $(
							".hf-location:visible select, .archive-location:visible select, .single-location:visible select"
						);
						temDisplay.find(
							"option[value='" + response.responseJSON.data.tmpLocation + "']"
						)[0].selected = "true";

						//display specific locations
						if (response.responseJSON.data.tmpSpLocation) {
							$.each(
								response.responseJSON.data.tmpSpLocation,
								function (i, item) {
									// Create a DOM Option and pre-select by default
									var data = {
										id: i,
										text: item,
									};
									var newOption = new Option(data.text, data.id, true, true);
									// Append it to the select
									$("#tj-theme-builder-hf-s-display-type")
										.append(newOption)
										.trigger("change");
								}
							);
						}
						$(".tj-theme-builder-edit-popup-area").addClass("open-popup");
					},
					error: function error(errorThrown) {
						console.log(errorThrown);
					},
				});
			} else {
				// Fire custom event.
				$(document).trigger("tj_template_edit_popup_open");
				$(".tj-theme-builder-tmp-elementor")
					.addClass("button disabled")
					.attr("disabled", "disabled");
				$(".tj-theme-builder-edit-popup-area").addClass("open-popup");
			}
		},
		// Close Popup
		closePopup: function closePopup(event) {
			$(".tj-theme-builder-edit-popup-area").removeClass("open-popup");
			$("#tj-theme-builder-hf-s-display-type").select2("destroy");
			var $_select2html =
				'<label class="tj-theme-builder-edit-label"></label>\n                                <select class="tj-theme-builder-edit-input" name="tj-theme-builder-hf-s-display-type[]"\n                                        id="tj-theme-builder-hf-s-display-type" multiple="multiple">\n                                </select>';
			$(".tj-theme-builder-edit-field.hf-s-location").html($_select2html);
			TJThemeBuilder.reinitSelect2();
		},
		// Save Post
		savePost: function savePost(event) {
			var _JSON$stringify;
			var $this = $(this),
				tmpId = event.target.dataset.tmpid ? event.target.dataset.tmpid : "",
				title = $("#tj-theme-builder-title").val(),
				tmpType = $("#tj-theme-builder-type").val(),
				temDisplay = $(
					".hf-location:visible select, .archive-location:visible select, .single-location:visible select"
				).val(),
				specificsDisplay = $(".hf-s-location:visible select").val();
			$.ajax({
				url: Tj_Theme_Builder.ajaxurl,
				data: {
					action: "tj_save_template",
					nonce: Tj_Theme_Builder.nonce,
					tmpId: tmpId,
					title: title,
					tmpType: tmpType,
					tmpDisplay: temDisplay,
					specificsDisplay:
						(_JSON$stringify = JSON.stringify(specificsDisplay)) !== null &&
						_JSON$stringify !== void 0
							? _JSON$stringify
							: null,
				},
				type: "POST",
				beforeSend: function beforeSend() {
					$this.text(Tj_Theme_Builder.labels.buttons.save.saving);
					$this.addClass("updating-message");
				},
				success: function success(data) {
					if (tmpId == "") {
						if (data.data.id) {
							var elementorEditlink =
								"post.php?post=" + data.data.id + "&action=elementor";
						}
						$(".tj-theme-builder-tmp-save").attr("data-tmpid", data.data.id);
						$(".tj-theme-builder-tmp-elementor").attr({
							"data-link": elementorEditlink,
							"data-tmpid": data.data.id,
						});
						$(".tj-theme-builder-tmp-elementor")
							.removeClass("disabled")
							.removeAttr("disabled", "disabled");
					} else {
					}
				},
				complete: function complete(data) {
					$("body.post-type-woolentor-template").removeClass("loading");
					$this.removeClass("updating-message");
					$this.text(Tj_Theme_Builder.labels.buttons.save.saved);
				},
				error: function error(errorThrown) {
					console.log(errorThrown);
				},
			});
		},
		// Redirect Edit Page
		redirectEditPage: function redirectEditPage(event) {
			event.preventDefault();
			var $this = $(this),
				link = $this.data("link") ? $this.data("link") : "";
			window.location.replace(Tj_Theme_Builder.adminURL + link);
		},
		displayLocation: function displayLocation(event) {
			var type = $("#tj-theme-builder-type").val();
			$(".hf-s-location").addClass("hidden");
			if ("archive" === type) {
				$(".archive-location").removeClass("hidden");
				$(".hf-location, .single-location").addClass("hidden");
			} else if ("single" === type) {
				$(".single-location").removeClass("hidden");
				$(".hf-location, .archive-location").addClass("hidden");
			} else {
				$(".hf-location").removeClass("hidden");
				$(".single-location, .archive-location").addClass("hidden");
				setTimeout(function () {
					//specifics location for page post taxonomy etc
					if ("specifics" === $("#tj-theme-builder-hf-display-type").val()) {
						$(".hf-s-location").removeClass("hidden");
					}
				}, 100);
			}
		},
	};
	TJThemeBuilder.init();
})(jQuery);
