<?php

/**
 * 
 * Demo Imports
 */

function tj_ocdi_import_files()
{

  return [
    [
      'import_file_name'           => 'Home 01',
      'categories'                 => ['Multipage'],
      'local_import_file'          => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file'   => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url'   => plugins_url('assets/img/home-1.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/',
    ],
    [
      'import_file_name'           => 'Home 01 Landing',
      'categories'                 => ['Onepage'],
      'local_import_file'          => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file'   => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url'   => plugins_url('assets/img/home-1.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-01-landing/',
    ],
    [
      'import_file_name'           => 'Home 02',
      'categories'                 => ['Multipage'],
      'local_import_file'             => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugins_url('assets/img/home-2.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-02/',
    ],
    [
      'import_file_name'           => 'Home 02 Landing',
      'categories'                 => ['Onepage'],
      'local_import_file'          => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file'   => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url'   => plugins_url('assets/img/home-2.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-02-landing/',
    ],
    [
      'import_file_name'           => 'Home 03',
      'categories'                 => ['Multipage'],
      'local_import_file'             => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugins_url('assets/img/home-3.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-03/',
    ],
    [
      'import_file_name'           => 'Home 03 Landing',
      'categories'                 => ['Onepage'],
      'local_import_file'          => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file'   => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url'   => plugins_url('assets/img/home-3.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-03-landing/',
    ],
    [
      'import_file_name'           => 'Home 04',
      'categories'                 => ['Multipage'],
      'local_import_file'             => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugins_url('assets/img/home-4.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-04/',
    ],
    [
      'import_file_name'           => 'Home 04 Landing',
      'categories'                 => ['Onepage'],
      'local_import_file'          => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file'   => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url'   => plugins_url('assets/img/home-4.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-04-landing/',
    ],
    [
      'import_file_name'           => 'Home 05',
      'categories'                 => ['Multipage'],
      'local_import_file'             => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugins_url('assets/img/home-5.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-05/',
    ],
    [
      'import_file_name'           => 'Home 05 Landing',
      'categories'                 => ['Onepage'],
      'local_import_file'          => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file'   => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url'   => plugins_url('assets/img/home-5.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-05-landing/',
    ],
    [
      'import_file_name'           => 'Home 06',
      'categories'                 => ['Multipage'],
      'local_import_file'             => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugins_url('assets/img/home-6.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-06/',
    ],
    [
      'import_file_name'           => 'Home 06 Landing',
      'categories'                 => ['Onepage'],
      'local_import_file'          => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file'   => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url'   => plugins_url('assets/img/home-6.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-06-landing/',
    ],
    [
      'import_file_name'           => 'Home 07',
      'categories'                 => ['Multipage'],
      'local_import_file'             => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugins_url('assets/img/home-7.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-07/',
    ],
    [
      'import_file_name'           => 'Home 07 Landing',
      'categories'                 => ['Onepage'],
      'local_import_file'          => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file'   => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url'   => plugins_url('assets/img/home-7.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-07-landing/',
    ],
    [
      'import_file_name'           => 'Home 08',
      'categories'                 => ['Multipage'],
      'local_import_file'             => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugins_url('assets/img/home-8.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-08/',
    ],
    [
      'import_file_name'           => 'Home 08 Landing',
      'categories'                 => ['Onepage'],
      'local_import_file'          => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file'   => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url'   => plugins_url('assets/img/home-8.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-08-landing/',
    ],
    [
      'import_file_name'           => 'Home 09',
      'categories'                 => ['Multipage'],
      'local_import_file'             => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugins_url('assets/img/home-9.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-09/',
    ],
    [
      'import_file_name'           => 'Home 09 Landing',
      'categories'                 => ['Onepage'],
      'local_import_file'          => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file'   => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url'   => plugins_url('assets/img/home-9.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-09-landing/',
    ],
    [
      'import_file_name'           => 'Home 10',
      'categories'                 => ['Multipage'],
      'local_import_file'             => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugins_url('assets/img/home-10.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-10/',
    ],
    [
      'import_file_name'           => 'Home 10 Landing',
      'categories'                 => ['Onepage'],
      'local_import_file'          => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file'   => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url'   => plugins_url('assets/img/home-10.webp', dirname(__FILE__)),
      'preview_url'                => 'https://bexon.themejunction.net/home-10-landing/',
    ],
  ];
}
add_filter('ocdi/import_files', 'tj_ocdi_import_files');


function tj_ocdi_page($tj_page_name = 'Home 01')
{
  $posts = get_posts(
    array(
      'post_type'              => 'page',
      'title'                  => $tj_page_name,
      'post_status'            => 'all',
      'posts_per_page'         => 1,
      'no_found_rows'          => true,
      'ignore_sticky_posts'    => true,
      'update_post_term_cache' => false,
      'update_post_meta_cache' => false,
      'orderby'                => 'post_date ID',
      'order'                  => 'ASC',
    )
  );

  if (!empty($posts)) {
    $page_got_by_title = $posts[0];
  } else {
    $page_got_by_title = null;
  }

  return $page_got_by_title;
}


// after demo imports
function tj_ocdi_after_import_setup($demo)
{
  $front_page_id = "";
  $blog_page_id = "";
  if ("Home 01" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tj_ocdi_page('Home 01');
    $blog_page_id  = tj_ocdi_page('Blog');
  } else if ("Home 02" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tj_ocdi_page('Home 02');
    $blog_page_id  = tj_ocdi_page('Blog');
  } else if ("Home 03" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tj_ocdi_page('Home 03');
    $blog_page_id  = tj_ocdi_page('Blog');
  } else if ("Home 04" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tj_ocdi_page('Home 04');
    $blog_page_id  = tj_ocdi_page('Blog');
  } else if ("Home 05" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tj_ocdi_page('Home 05');
    $blog_page_id  = tj_ocdi_page('Blog');
  } else if ("Home 06" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tj_ocdi_page('Home 06');
    $blog_page_id  = tj_ocdi_page('Blog');
  } else if ("Home 07" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tj_ocdi_page('Home 07');
    $blog_page_id  = tj_ocdi_page('Blog');
  } else if ("Home 08" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tj_ocdi_page('Home 08');
    $blog_page_id  = tj_ocdi_page('Blog');
  } else if ("Home 09" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tj_ocdi_page('Home 09');
    $blog_page_id  = tj_ocdi_page('Blog');
  } else if ("Home 10" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tj_ocdi_page('Home 10');
    $blog_page_id  = tj_ocdi_page('Blog');
  }

  update_option('show_on_front', 'page');
  update_option('page_on_front', $front_page_id->ID);
  update_option('page_for_posts', $blog_page_id->ID);


  // Assign menus to their locations.
  $main_menu = get_term_by('name', 'Main Menu', 'nav_menu');

  set_theme_mod(
    'nav_menu_locations',
    [
      'main-menu' => $main_menu->term_id, // replace 'main-menu' here with the menu location identifier from register_nav_menu() function in your theme.
    ]
  );
}
add_action('ocdi/after_import', 'tj_ocdi_after_import_setup');

// updated elementor kit data
function tj_after_import_setup($selected_import)
{
  if (did_action('elementor/loaded')) {
    $tj_kit_data = plugin_dir_path(__FILE__) . 'sample-data/elementor-kit.zip';
    if (file_exists($tj_kit_data)) {
      $import_export_module = \Elementor\Plugin::$instance->app->get_component('import-export');
      if ($import_export_module && method_exists($import_export_module, 'import_kit')) {
        $import_export_module->import_kit($tj_kit_data, ['referrer' => 'remote']);
      }
    }
  }
}
add_action('ocdi/after_import', 'tj_after_import_setup');

function tj_ocdi_plugin_page_setup($default_settings)
{
  $default_settings['parent_slug'] = 'themes.php';
  $default_settings['page_title']  = esc_html__('One Click Demo Import', 'one-click-demo-import');
  $default_settings['menu_title']  = esc_html__('Import Theme Demos', 'one-click-demo-import');
  $default_settings['capability']  = 'import';
  $default_settings['menu_slug']   = 'one-click-demo-import';

  return $default_settings;
}
add_filter('ocdi/plugin_page_setup', 'tj_ocdi_plugin_page_setup');
