<?php
// Repeater list
$achievementList = $settings['tj_achievement_list'] ?? [];
?>

<div class="tj-award-wrapper tj-active-bg-wrapper">

  <?php foreach ($achievementList as $index => $item) :
    $no         = $item['tj_achieve_no'] ?? '';
    $normalImage          = $item['tj_normal_image'] ?? '';
    $hoverImage     = $item['tj_hover_image'] ?? '';
    $title   = $item['tj_title'] ?? '';
    $subtitle   = $item['tj_subtitle'] ?? '';
    $year     = $item['tj_year'] ?? '';

    $tjAnimation       = $item['tj_animation'] ?? '';
    $tjAnimationName   = $item['tj_animation_name'] ?? '';
    $tjAnimationDelay  = $item['tj_animation_delay']['size'] ?? '';
    $award_attr_key  = 'award_item_attr_' . $index;

    $achievement_class = 'tj-award-item tj-active-bg-item tj-el-card';
    if (!empty($tjAnimation)) {
      $achievement_class .= ' wow ' . esc_attr($tjAnimationName);
      $this->add_render_attribute($award_attr_key, 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
    }

    $this->add_render_attribute($award_attr_key, 'class', $achievement_class);


  ?>
    <div <?php $this->print_render_attribute_string($award_attr_key); ?>>
      <div class="tj-award-item-inner">
        <div class="row align-items-center justify-content-between">
          <div class="col-md-4 tj-award-img-wrapper">

            <?php if (!empty($no)) : ?>
              <h6 class="tj-award-index">
                <?php echo esc_html($no); ?>
              </h6>
            <?php endif; ?>

            <?php if (!empty($normalImage['url'] || $hoverImage['url'])) : ?>
              <div class="tj-award-img">
                <?php if (!empty($normalImage['url'])) : ?>
                  <img src="<?php echo esc_url($normalImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($normalImage['id'], '_wp_attachment_image_alt', true)); ?>">
                <?php endif; ?>

                <?php if (!empty($hoverImage['url'])) : ?>
                  <img src="<?php echo esc_url($hoverImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($hoverImage['id'], '_wp_attachment_image_alt', true)); ?>">
                <?php else: ?>
                  <img src="<?php echo esc_url($normalImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($normalImage['id'], '_wp_attachment_image_alt', true)); ?>">
                <?php endif; ?>
              </div>
            <?php endif; ?>
          </div>
          <div class="col-md-4 col-lg-3 tj-award-title-wrapper">

            <?php if (!empty($title)) : ?>
              <h5 class="tj-award-title">
                <?php echo tj_kses($title); ?>
              </h5>
            <?php endif; ?>
          </div>
          <div class="col-md-4 tj-award-date-wrapper">

            <?php if (!empty($subtitle)) : ?>
              <h6 class="tj-award-result">
                <?php echo esc_html($subtitle); ?>
              </h6>
            <?php endif; ?>

            <?php if (!empty($year)) : ?>
              <h6 class="tj-award-date">
                <?php echo esc_html($year); ?>
              </h6>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
  <span class="active-bg"></span>
</div>