<?php

$tjSectionSubtitle   = $settings['tj_subtitle'] ?? "";
// animation
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';
if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "sub-title tj-el-subtitle wow $tjSubtitleAnimationName";
  $this->add_render_attribute('subtitle_arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "sub-title tj-el-subtitle";
}
$this->add_render_attribute('subtitle_arg', 'class', $subtitleClass);

// title
$tjSectionTitle   = $settings['tj_title'] ?? "";
$tjSectionTitleTag   = $settings['tj_title_tag'] ?? "h1";
// animation
$tj_gsap_animation   = $settings['tj_gsap_animation'] ?? '';
$tjGsapAnimationType   = $settings['animation_type'] ?? '';
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';
if (!empty($tjTitleAnimation)) {
  $titleClass = "banner-title tj-el-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} elseif (!empty($tj_gsap_animation) || !empty($tjGsapAnimationType)) {
  $titleClass = "banner-title tj-el-title $tjGsapAnimationType";
} else {
  $titleClass = "banner-title tj-el-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

// desc
$tjBannerDesc = $settings['tj_banner_desc'] ?? "";
$tjDescAnimation = $settings['tj_desc_animation'] ?? '';
$tjDescAnimationName = $settings['tj_desc_animation_name'] ?? '';
$tjDescAnimationDelay = $settings['tj_desc_animation_delay'] ?? '';

$descClass = "banner-desc-area";
if (!empty($tjDescAnimation)) {
  $descClass .= " wow $tjDescAnimationName";
  $this->add_render_attribute('tj_desc_args', 'data-wow-delay', $tjDescAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_desc_args', 'class', $descClass);

// image
$bannerImage = $settings['tj_banner_image'] ?? '';
$bannerBgimage = $settings['tj_banner_bgimage'] ?? '';
$tjimgAnimation      = $settings['tj_img_animation'] ?? '';
$tjimgAnimationName  = $settings['tj_img_animation_name'] ?? '';
$tjimgAnimationDelay = $settings['tj_img_animation_delay'] ?? '';

if (!empty($tjimgAnimation)) {
  $imageClass = "banner-img tj-el-image-box wow $tjimgAnimationName";
  $this->add_render_attribute('tj_image_arg', 'data-wow-delay', $tjimgAnimationDelay['size'] . "s");
} else {
  $imageClass = "banner-img tj-el-image-box";
}
$this->add_render_attribute('tj_image_arg', 'class', $imageClass);

// button
$tjButtonShow = $settings['tj_button_show'] ?? '';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';

$btnClass = "banner-link tj-el-icon";
if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}
if (!empty($tjButtonAnimation)) {
  $btnClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_button_arg', 'data-wow-delay', $tjButtonAnimationDelay['size'] . "s");
}

$this->add_render_attribute('tj_button_arg', 'class', $btnClass);

$tjBannerScrollText = $settings['tj_hero_banner_scroll_text'] ?? "";

// Counter + Client

$counter_animation = $settings['counter_animation'] ?? '';
$counter_animation_name  = $settings['counter_animation_name'] ?? '';
$counter_animation_delay = $settings['counter_animation_delay'] ?? '';

$counterClass = 'counter-wrap';
if (!empty($counter_animation)) {
  $counterClass .= " wow $counter_animation_name";
  $this->add_render_attribute('tj_counter_wrap', 'data-wow-delay', $counter_animation_delay['size'] . "s");
}
$this->add_render_attribute('tj_counter_wrap', 'class', $counterClass);


?>

<section class="tj-banner-section fix">
  <div class="banner-area">
    <div class="banner-left-box tj-el-section">
      <div class="banner-content">

        <?php if (!empty($tjSectionSubtitle)) : ?>
          <span <?php echo $this->get_render_attribute_string('subtitle_arg'); ?>>
            <?php if (!empty($tj_subtitle_icon['value']) && !empty($subtitle_icon_show)): ?>
              <?php tj_render_icon($settings, 'tj_subtitle_icon') ?>
            <?php endif; ?>
            <?php echo tj_kses($tjSectionSubtitle); ?>
          </span>
        <?php endif; ?>

        <?php
        if (!empty($tjSectionTitle)) :
          printf(
            '<%1$s %2$s>%3$s</%1$s>',
            tag_escape($tjSectionTitleTag),
            $this->get_render_attribute_string('title_args'),
            tj_kses($tjSectionTitle)
          );
        endif;
        ?>

        <div <?php echo $this->get_render_attribute_string('tj_desc_args'); ?>>
          <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
            <?php if (!empty($tjBtnIcon['value'])): ?>
              <span>
                <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
              </span>
            <?php endif; ?>
          </a>
          <?php if (!empty($tjBannerDesc)) : ?>
            <div class="banner-desc tj-el-desc">
              <?php echo tj_kses($tjBannerDesc); ?>
            </div>
          <?php endif; ?>
        </div>

      </div>
      <?php if (!empty($bannerBgimage['url'])): ?>
        <div class="banner-shape">
          <img src="<?php echo esc_url($bannerBgimage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($bannerBgimage['id'], '_wp_attachment_image_alt', true)); ?>" />
        </div>
      <?php endif; ?>
    </div>
    <div class="banner-right-box">
      <?php if (!empty($bannerImage['url'])): ?>
        <div <?php echo $this->get_render_attribute_string('tj_image_arg'); ?>>
          <img src="<?php echo esc_url($bannerImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($bannerImage['id'], '_wp_attachment_image_alt', true)); ?>" />
        </div>
      <?php endif; ?>
      <?php if (!empty($tj_custom_html) || !empty($tj_number) || !empty($tj_counter_title)): ?>
        <div class="box-area">
          <div class="customers-box tj-el-box">
            <?php if (!empty($tj_custom_html)): ?>
              <div class="customers">
                <?php echo tj_kses($tj_custom_html); ?>
              </div>
            <?php endif; ?>
            <div <?php echo $this->get_render_attribute_string('tj_counter_wrap'); ?>>
              <?php if (!empty($tj_number)): ?>
                <div class="customers-number tj-el-number">
                  <span class="counter"><?php echo tj_kses($tj_number); ?></span><?php echo tj_kses($tj_suffix); ?>
                </div>
              <?php endif; ?>
              <?php if (!empty($tj_counter_title)): ?>
                <h6 class="customers-text tj-el-text"><?php echo tj_kses($tj_counter_title); ?></h6>
              <?php endif; ?>
            </div>
          </div>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <?php if (!empty($settings['tj_scroll_down_show']) && !empty($tjBannerScrollText)): ?>
    <div class="banner-scroll wow fadeInDown" data-wow-delay="1s">
      <a href="<?php echo esc_attr($settings['tj_banner_scroll_link']); ?>" class="scroll-down">
        <span class="icon"><i class="tji-arrow-down-long"></i></span>
        <?php echo esc_html__($tjBannerScrollText, 'tjcore'); ?>
      </a>
    </div>
  <?php endif; ?>

</section>