<?php

$tjSectionSubtitle   = $settings['tj_subtitle'] ?? "";
// animation
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';
if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "sub-title tj-el-subtitle wow $tjSubtitleAnimationName";
  $this->add_render_attribute('subtitle_arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "sub-title tj-el-subtitle";
}
$this->add_render_attribute('subtitle_arg', 'class', $subtitleClass);

// title
$tjSectionTitle   = $settings['tj_title'] ?? "";
$tjSectionTitleTag   = $settings['tj_title_tag'] ?? "h1";
// animation
$tj_gsap_animation   = $settings['tj_gsap_animation'] ?? '';
$tjGsapAnimationType   = $settings['animation_type'] ?? '';
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';
if (!empty($tjTitleAnimation)) {
  $titleClass = "banner-title tj-el-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} elseif (!empty($tj_gsap_animation) || !empty($tjGsapAnimationType)) {
  $titleClass = "banner-title tj-el-title $tjGsapAnimationType";
} else {
  $titleClass = "banner-title tj-el-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

// image
$bannerImage = $settings['tj_banner_image'] ?? '';
$bannerGrowthImage = $settings['tj_banner_growth_img'] ?? '';
$bannerBrandName = $settings['tj_brand_name'] ?? '';
$tjimgAnimation      = $settings['tj_img_animation'] ?? '';
$tjimgAnimationName  = $settings['tj_img_animation_name'] ?? '';
$tjimgAnimationDelay = $settings['tj_img_animation_delay'] ?? '';

if (!empty($tjimgAnimation)) {
  $imageClass = "banner-img tj-el-image-box wow $tjimgAnimationName";
  $this->add_render_attribute('tj_image_arg', 'data-wow-delay', $tjimgAnimationDelay['size'] . "s");
} else {
  $imageClass = "banner-img tj-el-image-box";
}
$this->add_render_attribute('tj_image_arg', 'class', $imageClass);

// button
$tjButtonShow = $settings['tj_button_show'] ?? '';
$tjBtnText = $settings['tj_btn_text'] ?? '';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';

$btnClass = "tj-primary-btn";
if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}
if (!empty($tjButtonAnimation)) {
  $btnClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_button_arg', 'data-wow-delay', $tjButtonAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_button_arg', 'class', $btnClass);

$tjBannerScrollText = $settings['tj_hero_banner_scroll_text'] ?? "";


// contact button
$tjContactButtonShow = $settings['tj_contact_button_show'] ?? "";
$tjContactButtonText = $settings['tj_contact_btn_text'] ?? "";
$tjContactButtonIcon = $settings['tj_contact_btn_icon'] ?? "";
$tjContactButtonLink = $settings['tj_contact_btn_link'] ?? "";
$tjContactButtonAnimation   = $settings['tj_contact_button_animation'] ?? '';
$tjContactButtonAnimationName   = $settings['tj_contact_button_animation_name'] ?? '';
$tjContactButtonAnimationDelay   = $settings['tj_contact_button_animation_delay'] ?? '';

$contactBtnClass = "number";
if (!empty($tjContactButtonAnimation)) {
  $contactBtnClass .= " wow $tjContactButtonAnimationName";
  $this->add_render_attribute('tj_contact_button_arg', 'data-wow-delay', $tjContactButtonAnimationDelay['size'] . "s");
}
if (!empty($tjContactButtonLink['url'])) {
  $this->add_link_attributes('tj_contact_button_arg', $tjContactButtonLink);
}
$this->add_render_attribute('tj_contact_button_arg', 'class', $contactBtnClass);

// Counter + Client
$tjClientName = $settings['tj_client_name'] ?? '';
$tjClientDesignation = $settings['tj_client_designation'] ?? '';
$counter_animation = $settings['counter_animation'] ?? '';
$counter_animation_name  = $settings['counter_animation_name'] ?? '';
$counter_animation_delay = $settings['counter_animation_delay'] ?? '';

$counterClass = 'author_wrap';
if (!empty($counter_animation)) {
  $counterClass .= " wow $counter_animation_name";
  $this->add_render_attribute('tj_counter_wrap', 'data-wow-delay', $counter_animation_delay['size'] . "s");
}
$this->add_render_attribute('tj_counter_wrap', 'class', $counterClass);
?>
<section class="tj-banner-section-2 tj-el-section fix">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-5">
        <div class="banner-content-2">
          <?php if (!empty($tjSectionSubtitle)) : ?>
            <span <?php echo $this->get_render_attribute_string('subtitle_arg'); ?>>
              <?php if (!empty($tj_subtitle_icon['value']) && !empty($subtitle_icon_show)): ?>
                <?php tj_render_icon($settings, 'tj_subtitle_icon') ?>
              <?php endif; ?>
              <?php echo tj_kses($tjSectionSubtitle); ?>
            </span>
          <?php endif; ?>

          <?php if (!empty($tjSectionTitle)) :
            printf(
              '<%1$s %2$s>%3$s</%1$s>',
              tag_escape($tjSectionTitleTag),
              $this->get_render_attribute_string('title_args'),
              tj_kses($tjSectionTitle)
            );
          endif; ?>

          <?php if ("yes" == $tjContactButtonShow || "yes" == $tjButtonShow): ?>
            <div class="btn-area">
              <?php if ("yes" == $tjButtonShow): ?>
                <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
                  <span class="btn-text"><span><?php echo esc_html($tjBtnText); ?></span></span>

                  <?php if (!empty($tjBtnIcon['value'])): ?>
                    <span class="btn-icon"><?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?></span>
                  <?php endif; ?>
                </a>
              <?php endif; ?>

              <?php if ("yes" == $tjContactButtonShow): ?>
                <a <?php echo $this->get_render_attribute_string('tj_contact_button_arg'); ?>>
                  <?php if (!empty($tjContactButtonIcon['value'])):
                    tj_render_icon($settings, 'contact_btn_icon', 'tj_contact_btn_icon');
                  endif; ?>
                  <span><?php echo esc_html($tjContactButtonText); ?></span>
                </a>
              <?php endif; ?>
            </div>
          <?php endif; ?>

        </div>
      </div>
      <div class="col-lg-7">
        <div class="banner-img-area wow fadeInUp" data-wow-delay=".3s">

          <?php if (!empty($bannerImage['url'])): ?>
            <div <?php echo $this->get_render_attribute_string('tj_image_arg'); ?>>
              <img src="<?php echo esc_url($bannerImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($bannerImage['id'], '_wp_attachment_image_alt', true)); ?>" />

              <?php if (!empty($bannerBrandName)): ?>
                <div class="brand-name wow fadeIn" data-wow-delay="2.2s">
                  <div class="marquee-vr">
                    <span class="text"><?php echo esc_html($bannerBrandName); ?><span class="icon">/</span></span>
                    <span class="text"><?php echo esc_html($bannerBrandName); ?><span class="icon">/</span></span>
                    <span class="text"><?php echo esc_html($bannerBrandName); ?><span class="icon">/</span></span>
                    <span class="text"><?php echo esc_html($bannerBrandName); ?><span class="icon">/</span></span>
                    <span class="text"><?php echo esc_html($bannerBrandName); ?><span class="icon">/</span></span>
                    <span class="text"><?php echo esc_html($bannerBrandName); ?><span class="icon">/</span></span>
                  </div>
                </div>
              <?php endif; ?>

              <?php if (!empty($bannerGrowthImage['url'])): ?>
                <div class="growth-box wow fadeInUp" data-wow-delay="1.7s">
                  <img src="<?php echo esc_url($bannerGrowthImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($bannerGrowthImage['id'], '_wp_attachment_image_alt', true)); ?>" />
                </div>
              <?php endif; ?>
            </div>
          <?php endif; ?>

          <div <?php echo $this->get_render_attribute_string('tj_counter_wrap'); ?>>
            <div class="banner-author">
              <?php if (!empty($tjClientName)): ?>
                <h4 class="title tj-el-name"><?php echo esc_html($tjClientName); ?></h4>
              <?php endif; ?>

              <?php if (!empty($tjClientDesignation)): ?>
                <span class="designation tj-el-job"><?php echo esc_html($tjClientDesignation); ?></span>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php if (!empty($settings['tj_banner_left_shape']['url'])): ?>
    <div class="bg-shape-1">
      <img src="<?php echo esc_url($settings['tj_banner_left_shape']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_banner_left_shape']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>
  <?php if (!empty($settings['tj_banner_right_shape']['url'])): ?>
    <div class="bg-shape-2">
      <img src="<?php echo esc_url($settings['tj_banner_right_shape']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_banner_right_shape']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>

  <?php if (!empty($settings['tj_scroll_down_show']) && !empty($tjBannerScrollText)): ?>
    <div class="banner-scroll wow fadeInDown" data-wow-delay="1s">
      <a href="<?php echo esc_attr($settings['tj_banner_scroll_link']); ?>" class="scroll-down">
        <span class="icon"><i class="tji-arrow-down-long"></i></span>
        <?php echo esc_html__($tjBannerScrollText, 'tjcore'); ?>
      </a>
    </div>
  <?php endif; ?>
</section>