<?php

$tjSectionSubtitle   = $settings['tj_subtitle'] ?? "";
// animation
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';
if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "sub-title tj-el-subtitle wow $tjSubtitleAnimationName";
  $this->add_render_attribute('subtitle_arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "sub-title tj-el-subtitle";
}
$this->add_render_attribute('subtitle_arg', 'class', $subtitleClass);

// title
$tjSectionTitle   = $settings['tj_title'] ?? "";
$tjSectionTitleTag   = $settings['tj_title_tag'] ?? "h1";
// animation
$tj_gsap_animation   = $settings['tj_gsap_animation'] ?? '';
$tjGsapAnimationType   = $settings['animation_type'] ?? '';
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';
if (!empty($tjTitleAnimation)) {
  $titleClass = "banner-title tj-el-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} elseif (!empty($tj_gsap_animation) || !empty($tjGsapAnimationType)) {
  $titleClass = "banner-title tj-el-title $tjGsapAnimationType";
} else {
  $titleClass = "banner-title tj-el-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

// desc
$tjBannerDesc = $settings['tj_banner_desc'] ?? "";
$tjDescAnimation = $settings['tj_desc_animation'] ?? '';
$tjDescAnimationName = $settings['tj_desc_animation_name'] ?? '';
$tjDescAnimationDelay = $settings['tj_desc_animation_delay'] ?? '';

$descClass = "banner-desc tj-el-desc";
if (!empty($tjDescAnimation)) {
  $descClass .= " wow $tjDescAnimationName";
  $this->add_render_attribute('tj_desc_args', 'data-wow-delay', $tjDescAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_desc_args', 'class', $descClass);

// image
$bannerImage = $settings['tj_banner_image'] ?? '';


// button
$tjButtonShow = $settings['tj_button_show'] ?? '';
$tjBtnText = $settings['tj_btn_text'] ?? '';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';

$btnClass = "tj-primary-btn tj-el-icon";
if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}
if (!empty($tjButtonAnimation)) {
  $btnClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_button_arg', 'data-wow-delay', $tjButtonAnimationDelay['size'] . "s");
}

$this->add_render_attribute('tj_button_arg', 'class', $btnClass);

$tjBannerScrollText = $settings['tj_hero_banner_scroll_text'] ?? "";

// Counter + Client
$counter_animation = $settings['counter_animation'] ?? '';
$counter_animation_name  = $settings['counter_animation_name'] ?? '';
$counter_animation_delay = $settings['counter_animation_delay'] ?? '';

$counterClass = 'solution-wrapper';
if (!empty($counter_animation)) {
  $counterClass .= " wow $counter_animation_name";
  $this->add_render_attribute('tj_counter_wrap', 'data-wow-delay', $counter_animation_delay['size'] . "s");
}
$this->add_render_attribute('tj_counter_wrap', 'class', $counterClass);


?>

<section class="h5-banner-section tj-el-section fix">

  <?php if (!empty($bannerImage['url'])): ?>
    <div class="banner-bg" data-bg-image="<?php echo esc_url($bannerImage['url']); ?>"></div>
  <?php endif; ?>

  <div class="h5-banner-area">
    <div class="h5-banner-content">

      <?php if (!empty($tjSectionSubtitle)) : ?>
        <span <?php echo $this->get_render_attribute_string('subtitle_arg'); ?>>
          <?php if (!empty($tj_subtitle_icon['value']) && !empty($subtitle_icon_show)): ?>
            <?php tj_render_icon($settings, 'tj_subtitle_icon') ?>
          <?php endif; ?>
          <?php echo tj_kses($tjSectionSubtitle); ?>
        </span>
      <?php endif; ?>

      <?php
      if (!empty($tjSectionTitle)) :
        printf(
          '<%1$s %2$s>%3$s</%1$s>',
          tag_escape($tjSectionTitleTag),
          $this->get_render_attribute_string('title_args'),
          tj_kses($tjSectionTitle)
        );
      endif;
      ?>

      <?php if (!empty($tjBannerDesc)) : ?>
        <div <?php echo $this->get_render_attribute_string('tj_desc_args'); ?>>
          <?php echo tj_kses($tjBannerDesc); ?>
        </div>
      <?php endif; ?>

      <?php if ("yes" == $tjButtonShow): ?>
        <div class="btn-area">
          <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
            <span class="btn-text"><span> <?php echo tj_kses($tjBtnText); ?></span></span>
            <?php if (!empty($tjBtnIcon['value'])): ?>
              <span class="btn-icon">
                <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
              </span>
            <?php endif; ?>
          </a>
        </div>
      <?php endif; ?>

    </div>

    <?php if (!empty($tj_custom_html) || !empty($tj_number) || !empty($tj_counter_title)): ?>
      <div <?php echo $this->get_render_attribute_string('tj_counter_wrap'); ?>>
        <div class="solution-box tj-el-box">
          <?php if (!empty($tj_custom_html)): ?>
            <span class="list-icon"> <?php echo tj_kses($tj_custom_html); ?></span>
          <?php endif; ?>
          <?php if (!empty($tj_counter_title)): ?>
            <p class="desc tj-el-text"><?php echo tj_kses($tj_counter_title); ?></p>
          <?php endif; ?>
          <div class="hero-counter tj-el-number">
            <span class="counter"><?php echo tj_kses($tj_number); ?></span><span class="count-plus"><?php echo tj_kses($tj_suffix); ?></span>
          </div>
        </div>
      </div>
    <?php endif; ?>

  </div>

  <?php if (!empty($settings['tj_banner_left_shape']['url'])): ?>
    <div class="bg-shape-1">
      <img src="<?php echo esc_url($settings['tj_banner_left_shape']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_banner_left_shape']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>
  <?php if (!empty($settings['tj_banner_right_shape']['url'])): ?>
    <div class="bg-shape-2">
      <img src="<?php echo esc_url($settings['tj_banner_right_shape']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_banner_right_shape']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>

  <?php if (!empty($settings['tj_scroll_down_show']) && !empty($tjBannerScrollText)): ?>
    <div class="banner-scroll wow fadeInDown" data-wow-delay="1.5s">
      <a href="<?php echo esc_attr($settings['tj_banner_scroll_link']); ?>" class="scroll-down">
        <span class="icon"><i class="tji-arrow-down-long"></i></span>
        <?php echo esc_html__($tjBannerScrollText, 'tjcore'); ?>
      </a>
    </div>
  <?php endif; ?>

</section>