<?php

$tjSectionSubtitle   = $settings['tj_subtitle'] ?? "";
// animation
$tjSubtitleAnimation   = $settings['tj_subtitle_animation'] ?? '';
$tjSubtitleAnimationName   = $settings['tj_subtitle_animation_name'] ?? '';
$tjSubtitleAnimationDelay   = $settings['tj_subtitle_animation_delay'] ?? '';
if (!empty($tjSubtitleAnimation)) {
  $subtitleClass = "sub-title tj-el-subtitle wow $tjSubtitleAnimationName";
  $this->add_render_attribute('subtitle_arg', 'data-wow-delay', $tjSubtitleAnimationDelay['size'] . "s");
} else {
  $subtitleClass = "sub-title tj-el-subtitle";
}
$this->add_render_attribute('subtitle_arg', 'class', $subtitleClass);

// title
$tjSectionTitle   = $settings['tj_title'] ?? "";
$tjSectionTitleTag   = $settings['tj_title_tag'] ?? "h1";
// animation
$tj_gsap_animation   = $settings['tj_gsap_animation'] ?? '';
$tjGsapAnimationType   = $settings['animation_type'] ?? '';
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';
if (!empty($tjTitleAnimation)) {
  $titleClass = "h7-hero-title tj-el-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} elseif (!empty($tj_gsap_animation) || !empty($tjGsapAnimationType)) {
  $titleClass = "h7-hero-title tj-el-title $tjGsapAnimationType";
} else {
  $titleClass = "h7-hero-title tj-el-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

// desc
$tjBannerDesc = $settings['tj_banner_desc'] ?? "";
$tjDescAnimation = $settings['tj_desc_animation'] ?? '';
$tjDescAnimationName = $settings['tj_desc_animation_name'] ?? '';
$tjDescAnimationDelay = $settings['tj_desc_animation_delay'] ?? '';

$descClass = "banner-desc tj-el-desc";
if (!empty($tjDescAnimation)) {
  $descClass .= " wow $tjDescAnimationName";
  $this->add_render_attribute('tj_desc_args', 'data-wow-delay', $tjDescAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_desc_args', 'class', $descClass);

// image
$bannerImage = $settings['tj_banner_image'] ?? '';
$bannerBgimage = $settings['tj_banner_bgimage'] ?? '';
$tjimgAnimation      = $settings['tj_img_animation'] ?? '';
$tjimgAnimationName  = $settings['tj_img_animation_name'] ?? '';
$tjimgAnimationDelay = $settings['tj_img_animation_delay'] ?? '';

if (!empty($tjimgAnimation)) {
  $imageClass = "h7-hero-banner tj-el-image-box wow $tjimgAnimationName";
  $this->add_render_attribute('tj_image_arg', 'data-wow-delay', $tjimgAnimationDelay['size'] . "s");
} else {
  $imageClass = "h7-hero-banner tj-el-image-box";
}
$this->add_render_attribute('tj_image_arg', 'class', $imageClass);

// button
$tjButtonShow = $settings['tj_button_show'] ?? '';
$tjBtnText = $settings['tj_btn_text'] ?? '';
$tjBtnIcon = $settings['tj_btn_icon'] ?? '';
$tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
$tjBtnLink = $settings['tj_btn_link'] ?? '';
$tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';
$tjButtonAnimation   = $settings['tj_button_animation'] ?? '';
$tjButtonAnimationName   = $settings['tj_button_animation_name'] ?? '';
$tjButtonAnimationDelay   = $settings['tj_button_animation_delay'] ?? '';

$btnClass = "circle-icon tj-el-icon";
if ('2' == $tjBtnLinkType) {
  $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
  $this->add_render_attribute('tj_button_arg', 'target', '_self');
  $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
} else {
  if (!empty($tjBtnLink['url'])) {
    $this->add_link_attributes('tj_button_arg', $tjBtnLink);
  }
}
if (!empty($tjButtonAnimation)) {
  $btnClass .= " wow $tjButtonAnimationName";
  $this->add_render_attribute('tj_button_arg', 'data-wow-delay', $tjButtonAnimationDelay['size'] . "s");
}

$this->add_render_attribute('tj_button_arg', 'class', $btnClass);


// Counter + Client
$counter_animation = $settings['counter_animation'] ?? '';
$counter_animation_name  = $settings['counter_animation_name'] ?? '';
$counter_animation_delay = $settings['counter_animation_delay'] ?? '';

$counterClass = 'h7-hero-box';
if (!empty($counter_animation)) {
  $counterClass .= " wow $counter_animation_name";
  $this->add_render_attribute('tj_counter_wrap', 'data-wow-delay', $counter_animation_delay['size'] . "s");
}
$this->add_render_attribute('tj_counter_wrap', 'class', $counterClass);


?>

<section class="h7-hero tj-el-section fix">
  <div class="h7-hero-inner">
    <?php if (!empty($bannerBgimage['url'])): ?>
      <div class="h7-hero-bg-image" data-bg-image="<?php echo esc_url($bannerBgimage['url']); ?>"></div>
    <?php endif; ?>
    <div class="container">
      <div class="row ">
        <div class="col-12">
          <div class="h7-hero-item-wrapper">
            <div class="h7-hero-content">
              <?php if (!empty($tjSectionSubtitle)) : ?>
                <span <?php echo $this->get_render_attribute_string('subtitle_arg'); ?>>
                  <?php if (!empty($tj_subtitle_icon['value']) && !empty($subtitle_icon_show)): ?>
                    <?php tj_render_icon($settings, 'tj_subtitle_icon') ?>
                  <?php endif; ?>
                  <?php echo tj_kses($tjSectionSubtitle); ?>
                </span>
              <?php endif; ?>

              <?php
              if (!empty($tjSectionTitle)) :
                printf(
                  '<%1$s %2$s>%3$s</%1$s>',
                  tag_escape($tjSectionTitleTag),
                  $this->get_render_attribute_string('title_args'),
                  tj_kses($tjSectionTitle)
                );
              endif;
              ?>

              <?php if (!empty($tjBannerDesc)) : ?>
                <div <?php echo $this->get_render_attribute_string('tj_desc_args'); ?>>
                  <?php echo tj_kses($tjBannerDesc); ?>
                </div>
              <?php endif; ?>

            </div>

            <?php if (!empty($bannerImage['url'])): ?>
              <div <?php echo $this->get_render_attribute_string('tj_image_arg'); ?>>
                <img src="<?php echo esc_url($bannerImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($bannerImage['id'], '_wp_attachment_image_alt', true)); ?>" />
              </div>
            <?php endif; ?>
            <?php if (!empty($tj_custom_html) || !empty($tj_rating) || !empty($tj_counter_title)): ?>
              <div <?php echo $this->get_render_attribute_string('tj_counter_wrap'); ?>>
                <?php if (!empty($tj_custom_html)): ?>
                  <div class="customers">
                    <?php echo tj_kses($tj_custom_html); ?>
                  </div>
                <?php endif; ?>
                <?php if (!empty($tj_counter_title)): ?>
                  <div class="h7-hero-box-content wow fadeInLeft" data-wow-delay=".9s">
                    <div class="star-ratings">
                      <div class="fill-ratings" style="width: 100%">
                        <span>★★★★★</span>
                      </div>
                      <div class="empty-ratings">
                        <span>★★★★★</span>
                      </div>
                    </div>
                    <h5 class="customers-text tj-el-text"><?php echo tj_kses($tj_counter_title); ?></h5>
                  </div>
                <?php endif; ?>
              </div>
            <?php endif; ?>
          </div>
        </div>

      </div>

    </div>
  </div>

  <?php if ("yes" == $tjButtonShow): ?>
    <div class="circle-text-wrap wow fadeInUp" data-wow-delay="2.2s">
      <?php if (!empty($settings['tj_btn_image']['url'])): ?>
        <span class="circle-text" data-bg-image="<?php echo esc_url($settings['tj_btn_image']['url']); ?>"></span>
      <?php endif; ?>
      <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
        <?php if (!empty($tjBtnIcon['value'])): ?>
          <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
        <?php endif; ?>
      </a>
    </div>
  <?php endif; ?>

  <?php if (!empty($settings['tj_banner_left_shape']['url'])): ?>
    <div class="h7-hero-shape h7-hero-shape-1 wow fadeInUpBig" data-wow-delay="1s">
      <img class="tj-anim-move-var-big" src="<?php echo esc_url($settings['tj_banner_left_shape']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_banner_left_shape']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>
  <?php if (!empty($settings['tj_banner_right_shape']['url'])): ?>
    <div class="h7-hero-shape h7-hero-shape-2 wow fadeInDownBig" data-wow-delay="1.2s">
      <img class="tj-anim-move-var-big-reverse" src="<?php echo esc_url($settings['tj_banner_right_shape']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_banner_right_shape']['id'], '_wp_attachment_image_alt', true)); ?>" />
    </div>
  <?php endif; ?>

</section>