<?php
$brands   = (!empty($settings['brands_items'])) ? $settings['brands_items'] : "";
$tjSectionTitle   = $settings['tj_title'] ?? "";


$loop            = (isset($settings['slide_loop']) && !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no');
$autoplay        = (isset($settings['slide_autoplay']) && !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no');
$autoplayDelay   = (isset($settings['slide_autoplay_delay']) && !empty($settings['slide_autoplay_delay']) ? $settings['slide_autoplay_delay'] : '5000');

// animation
$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

$brandsClass = 'clent-section-2 carouselWrap fix';
if (!empty($tjAnimation) && !empty($tjAnimationName)) {
  $brandsClass .= ' wow ' . esc_attr($tjAnimationName);

  if (!empty($tjAnimationDelay)) {
    $this->add_render_attribute('tj-brands-arg', 'data-wow-delay', esc_attr($tjAnimationDelay . 's'));
  }
}

$this->add_render_attribute('tj-brands-arg', 'class', esc_attr($brandsClass));

?>
<div <?php echo $this->get_render_attribute_string('tj-brands-arg'); ?> data-loop="<?php echo $loop; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>">
  <?php if (!empty($brands)): ?>
    <div class="swiper client-slider client-slider-3" id="brandsCarousel-<?php echo $this->get_id(); ?>">
      <div class="swiper-wrapper">
        <?php foreach ($brands as $brand):
          $image = $brand['brand_image'];
        ?>
          <div class="swiper-slide client-item">
            <?php if (!empty($image['url'])) : ?>
              <div class="client-logo tj-el-image">
                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true)); ?>">
              </div>
            <?php endif; ?>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  <?php endif; ?>
</div>